<?php
/**
 * Copyright © 2015 PlazaThemes.com. All rights reserved.

 * @author PlazaThemes Team <contact@plazathemes.com>
 */

namespace Plazathemes\Blog\Controller;

/**
 * Blog Controller Router
 */
class Router implements \Magento\Framework\App\RouterInterface
{
    /**
     * @var \Magento\Framework\App\ActionFactory
     */
    protected $actionFactory;

    /**
     * Event manager
     *
     * @var \Magento\Framework\Event\ManagerInterface
     */
    protected $_eventManager;

    /**
     * Store manager
     *
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * Page factory
     *
     * @var \Plazathemes\Blog\Model\PostFactory
     */
    protected $_postFactory;

    /**
     * Category factory
     *
     * @var \Plazathemes\Blog\Model\CategoryFactory
     */
    protected $_categoryFactory;

    /**
     * Config primary
     *
     * @var \Magento\Framework\App\State
     */
    protected $_appState;

    /**
     * Url
     *
     * @var \Magento\Framework\UrlInterface
     */
    protected $_url;

    /**
     * Response
     *
     * @var \Magento\Framework\App\ResponseInterface
     */
    protected $_response;

    /**
     * @param \Magento\Framework\App\ActionFactory $actionFactory
     * @param \Magento\Framework\Event\ManagerInterface $eventManager
     * @param \Magento\Framework\UrlInterface $url
     * @param \Plazathemes\Blog\Model\PostFactory $postFactory
     * @param \Plazathemes\Blog\Model\CategoryFactory $categoryFactory
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\App\ResponseInterface $response
     */
    public function __construct(
        \Magento\Framework\App\ActionFactory $actionFactory,
        \Magento\Framework\Event\ManagerInterface $eventManager,
        \Magento\Framework\UrlInterface $url,
        \Plazathemes\Blog\Model\PostFactory $postFactory,
        \Plazathemes\Blog\Model\CategoryFactory $categoryFactory,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\App\ResponseInterface $response
    ) {
        $this->actionFactory = $actionFactory;
        $this->_eventManager = $eventManager;
        $this->_url = $url;
        $this->_postFactory = $postFactory;
        $this->_categoryFactory = $categoryFactory;
        $this->_storeManager = $storeManager;
        $this->_response = $response;
    }

    /**
     * Validate and Match Blog Pages and modify request
     *
     * @param \Magento\Framework\App\RequestInterface $request
     * @return bool
     */
    public function match(\Magento\Framework\App\RequestInterface $request)
    {
        $_identifier = trim($request->getPathInfo(), '/');

        if (strpos($_identifier, 'blog') !== 0) {
            return;
        }

        $identifier = str_replace(array('blog/', 'blog'), '', $_identifier);

        $condition = new \Magento\Framework\DataObject(['identifier' => $identifier, 'continue' => true]);
        $this->_eventManager->dispatch(
            'Plazathemes_blog_controller_router_match_before',
            ['router' => $this, 'condition' => $condition]
        );
        
        if ($condition->getRedirectUrl()) {
            $this->_response->setRedirect($condition->getRedirectUrl());
            $request->setDispatched(true);
            return $this->actionFactory->create(
                'Magento\Framework\App\Action\Redirect',
                ['request' => $request]
            );
        }

        if (!$condition->getContinue()) {
            return null;
        }

        $identifier = $condition->getIdentifier();

        $success = false;
        $info = explode('/', $identifier);

        if (!$identifier) {
            $request->setModuleName('blog')->setControllerName('index')->setActionName('index');
            $success = true;
        } elseif (count($info) > 1) {
            
            $store = $this->_storeManager->getStore()->getId();

            switch ($info[0]) {
                case 'post' :
                    $post = $this->_postFactory->create();
                    $postId = $post->checkIdentifier($info[1], $this->_storeManager->getStore()->getId());
                    if (!$postId) {
                        return null;
                    }

                    $request->setModuleName('blog')->setControllerName('post')->setActionName('view')->setParam('id', $postId);
                    $success = true;
                    break;
                case 'category' :
                    $category = $this->_categoryFactory->create();
                    $categoryId = $category->checkIdentifier($info[1], $this->_storeManager->getStore()->getId());
                    if (!$categoryId) {
                        return null;
                    }

                    $request->setModuleName('blog')->setControllerName('category')->setActionName('view')->setParam('id', $categoryId);
                    $success = true;
                    break;
                case 'archive' :
                    $request->setModuleName('blog')->setControllerName('archive')->setActionName('view')
                        ->setParam('date', $info[1]);

                    $success = true;
                    break;

                case 'search' :
                    $request->setModuleName('blog')->setControllerName('search')->setActionName('index')
                        ->setParam('q', $info[1]);

                    $success = true;
                    break;
            }

        }

        if (!$success) {
            return null;
        }

        $request->setAlias(\Magento\Framework\Url::REWRITE_REQUEST_PATH_ALIAS, $_identifier);

        return $this->actionFactory->create(
            'Magento\Framework\App\Action\Forward',
            ['request' => $request]
        );
    }

}
