require.config({
    config: {
        'jsbuild':{"Magento_Checkout/js/view/shipping-information/list.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine([\n    'jquery',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Checkout/js/model/quote'\n], function ($, ko, utils, Component, layout, quote) {\n    'use strict';\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-information/address-renderer/default'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/list',\n            rendererTemplates: {}\n        },\n\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            var self = this;\n            quote.shippingAddress.subscribe(function(address) {\n                self.createRendererComponent(address);\n            });\n            return this;\n        },\n\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = {};\n            return this;\n        },\n\n        initChildren: function () {\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param address\n         */\n        createRendererComponent: function (address) {\n\n            $.each(this.rendererComponents, function(index, component) {\n                component.visible(false);\n            });\n\n            if (this.rendererComponents[address.getType()]) {\n                this.rendererComponents[address.getType()].address(address);\n                this.rendererComponents[address.getType()].visible(true);\n            } else {\n                // rendererTemplates are provided via layout\n                var rendererTemplate =\n                    (address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined)\n                    ? utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()])\n                    : defaultRendererTemplate;\n                var templateData = {\n                    parentName: this.name,\n                    name: address.getType()\n                };\n\n                var rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(\n                    rendererComponent,\n                    {address: ko.observable(address), visible: ko.observable(true)}\n                );\n                layout([rendererComponent]);\n                this.rendererComponents[address.getType()] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/cart-items.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'ko',\n        'Magento_Checkout/js/model/totals',\n        'uiComponent',\n        'Magento_Checkout/js/model/step-navigator',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (ko, totals, Component, stepNavigator, quote) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/cart-items'\n            },\n            totals: totals.totals(),\n            getItems: totals.getItems(),\n            getItemsQty: function() {\n                return parseFloat(this.totals.items_qty);\n            },\n            isItemsBlockExpanded: function () {\n                return quote.isVirtual() || stepNavigator.isProcessed('shipping');\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/grand-total.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/grand-total'\n            },\n            isDisplayed: function() {\n                return this.isFullMode();\n            },\n            getPureValue: function() {\n                var totals = quote.getTotals()();\n                if (totals) {\n                    return totals.grand_total;\n                }\n                return quote.grand_total;\n            },\n            getValue: function() {\n                return this.getFormattedPrice(this.getPureValue());\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/shipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function ($, Component, quote) {\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/shipping'\n            },\n            quoteIsVirtual: quote.isVirtual(),\n            totals: quote.getTotals(),\n            getShippingMethodTitle: function() {\n                if (!this.isCalculated()) {\n                    return '';\n                }\n                var shippingMethod = quote.shippingMethod();\n                return shippingMethod ? shippingMethod.carrier_title + \" - \" + shippingMethod.method_title : '';\n            },\n            isCalculated: function() {\n                return this.totals() && this.isFullMode() && null != quote.shippingMethod();\n            },\n            getValue: function() {\n                if (!this.isCalculated()) {\n                    return this.notCalculatedMessage;\n                }\n                var price =  this.totals().shipping_amount;\n                return this.getFormattedPrice(price);\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/subtotal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/subtotal'\n            },\n            getPureValue: function() {\n                var totals = quote.getTotals()();\n                if (totals) {\n                    return totals.subtotal;\n                }\n                return quote.subtotal;\n            },\n            getValue: function () {\n                return this.getFormattedPrice(this.getPureValue());\n            }\n\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * @return {*}\n             */\n            isDisplayed: function () {\n                return this.isFullMode();\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/item/details.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'uiComponent'\n    ],\n    function (Component) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/item/details'\n            },\n            getValue: function(quoteItem) {\n                return quoteItem.name;\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/item/details/subtotal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total'\n    ],\n    function (viewModel) {\n        \"use strict\";\n        return viewModel.extend({\n            defaults: {\n                displayArea: 'after_details',\n                template: 'Magento_Checkout/summary/item/details/subtotal'\n            },\n            getValue: function(quoteItem) {\n                return this.getFormattedPrice(quoteItem.row_total);\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/item/details/thumbnail.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'uiComponent'\n    ],\n    function (Component) {\n        \"use strict\";\n        var imageData = window.checkoutConfig.imageData;\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/item/details/thumbnail'\n            },\n            displayArea: 'before_details',\n            imageData: imageData,\n            getImageItem: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id];\n                }\n                return [];\n            },\n            getSrc: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id]['src'];\n                }\n                return null;\n            },\n            getWidth: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id]['width'];\n                }\n                return null;\n            },\n            getHeight: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id]['height'];\n                }\n                return null;\n            },\n            getAlt: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id]['alt'];\n                }\n                return null;\n            }\n        });\n    }\n);\n","Magento_Payment/cc-type.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.creditCardType', {\n        options: {\n            typeCodes: ['SS', 'SM', 'SO'] // Type codes for Switch/Maestro/Solo credit cards.\n        },\n\n        /**\n         * Bind change handler to select element and trigger the event to show/hide\n         * the Switch/Maestro or Solo credit card type container for those credit card types.\n         * @private\n         */\n        _create: function() {\n            this.element.on('change', $.proxy(this._toggleCardType, this)).trigger('change');\n        },\n\n        /**\n         * Toggle the Switch/Maestro and Solo credit card type container depending on which\n         * credit card type is selected.\n         * @private\n         */\n        _toggleCardType: function() {\n            $(this.options.creditCardTypeContainer)\n                .toggle($.inArray(this.element.val(), this.options.typeCodes) !== -1);\n        }\n    });\n\n    return $.mage.creditCardType;\n});","Magento_Payment/transparent.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'Magento_Payment/js/model/credit-card-validation/validator'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.transparent', {\n        options: {\n            context: null,\n            placeOrderSelector: '[data-role=\"review-save\"]',\n            paymentFormSelector: '#co-payment-form',\n            updateSelectorPrefix: '#checkout-',\n            updateSelectorSuffix: '-load',\n            hiddenFormTmpl:\n                '<form target=\"<%= data.target %>\" action=\"<%= data.action %>\" method=\"POST\" ' +\n                'hidden enctype=\"application/x-www-form-urlencoded\" class=\"no-display\">' +\n                    '<% _.each(data.inputs, function(val, key){ %>' +\n                    '<input value=\"<%= val %>\" name=\"<%= key %>\" type=\"hidden\">' +\n                    '<% }); %>' +\n                '</form>',\n            reviewAgreementForm: '#checkout-agreements',\n            cgiUrl: null,\n            orderSaveUrl: null,\n            controller: null,\n            gateway: null,\n            dateDelim: null,\n            cardFieldsMap: null,\n            expireYearLength: 2\n        },\n\n        /**\n         * {Function}\n         * @private\n         */\n        _create: function () {\n            this.hiddenFormTmpl = mageTemplate(this.options.hiddenFormTmpl);\n\n            if (this.options.context) {\n                this.options.context.setPlaceOrderHandler($.proxy(this._orderSave, this));\n                this.options.context.setValidateHandler($.proxy(this._validateHandler, this));\n            } else {\n                $(this.options.placeOrderSelector)\n                    .off('click')\n                    .on('click', $.proxy(this._placeOrderHandler, this));\n            }\n\n            this.element.validation();\n            $('[data-container=\"' + this.options.gateway + '-cc-number\"]').on('focusout', function () {\n                $(this).valid();\n            });\n        },\n\n        /**\n         * handler for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _validateHandler: function () {\n            return this.element.validation && this.element.validation('isValid');\n        },\n\n        /**\n         * handler for Place Order button to call gateway for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _placeOrderHandler: function () {\n            if (this._validateHandler()) {\n                this._orderSave();\n            }\n\n            return false;\n        },\n\n        /**\n         * Save order and generate post data for gateway call\n         * @private\n         */\n        _orderSave: function () {\n            var postData = $(this.options.paymentFormSelector).serialize();\n\n            if ($(this.options.reviewAgreementForm).length) {\n                postData += '&' + $(this.options.reviewAgreementForm).serialize();\n            }\n            postData += '&controller=' + this.options.controller;\n            postData += '&cc_type=' + this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-type\"]'\n            ).val();\n\n            return $.ajax({\n                url: this.options.orderSaveUrl,\n                type: 'post',\n                context: this,\n                data: postData,\n                dataType: 'json',\n\n                /**\n                 * {Function}\n                 */\n                beforeSend: function () {\n                    this.element.trigger('showAjaxLoader');\n                }.bind(this),\n\n                /**\n                 * {Function}\n                 */\n                success: function (response) {\n                    var preparedData,\n                        msg,\n\n                        /**\n                         * {Function}\n                         */\n                        alertActionHandler = function () {\n                            // default action\n                        };\n\n                    if (response.success && response[this.options.gateway]) {\n                        preparedData = this._preparePaymentData(\n                            response[this.options.gateway].fields,\n                            this.options.cardFieldsMap\n                        );\n                        this._postPaymentToGateway(preparedData);\n                    } else {\n                        msg = response['error_messages'];\n\n                        if (this.options.context) {\n                            this.options.context.clearTimeout().fail();\n                            alertActionHandler = this.options.context.alertActionHandler;\n                        }\n\n                        if (typeof msg === 'object') {\n                            msg = msg.join('\\n');\n                        }\n\n                        if (msg) {\n                            alert(\n                                {\n                                    content: msg,\n                                    actions: {\n\n                                        /**\n                                         * {Function}\n                                         */\n                                        always: alertActionHandler\n                                    }\n                                }\n                            );\n                        }\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Post data to gateway for credit card validation\n         * @param {Object} data\n         * @private\n         */\n        _postPaymentToGateway: function (data) {\n            var tmpl,\n                iframeSelector = '[data-container=\"' + this.options.gateway + '-transparent-iframe\"]';\n\n            tmpl = this.hiddenFormTmpl({\n                data: {\n                    target: $(iframeSelector).attr('name'),\n                    action: this.options.cgiUrl,\n                    inputs: data\n                }\n            });\n            $(tmpl).appendTo($(iframeSelector)).submit();\n        },\n\n        /**\n         * Add credit card fields to post data for gateway\n         * @param {Object} data\n         * @param {Object} ccfields\n         * @private\n         */\n        _preparePaymentData: function (data, ccfields) {\n            var preparedata;\n\n            if (this.element.find('[data-container=\"' + this.options.gateway + '-cc-cvv\"]').length) {\n                data[ccfields.cccvv] = this.element.find(\n                    '[data-container=\"' + this.options.gateway + '-cc-cvv\"]'\n                ).val();\n            }\n            preparedata = this._prepareExpDate();\n            data[ccfields.ccexpdate] = preparedata.month + this.options.dateDelim + preparedata.year;\n            data[ccfields.ccnum] = this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-number\"]'\n            ).val();\n\n            return data;\n        },\n\n        /**\n         * Grab Month and Year into one\n         * @returns {Object}\n         * @private\n         */\n        _prepareExpDate: function () {\n            var year = this.element.find('[data-container=\"' + this.options.gateway + '-cc-year\"]').val(),\n                month = parseInt(\n                    this.element.find('[data-container=\"' + this.options.gateway + '-cc-month\"]').val(),\n                    10\n                );\n\n            if (year.length > this.options.expireYearLength) {\n                year = year.substring(year.length - this.options.expireYearLength);\n            }\n\n            if (month < 10) {\n                month = '0' + month;\n            }\n\n            return {\n                month: month, year: year\n            };\n        }\n    });\n\n    return $.mage.transparent;\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-data.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n        return {\n            creditCard: null,\n            creditCardNumber: null,\n            expirationMonth: null,\n            expirationYear: null,\n            cvvCode: null\n        }\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'mageUtils',\n        'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator',\n        'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type'\n    ],\n    function (utils, luhn10, creditCardTypes) {\n        'use strict';\n\n        function resultWrapper(card, isPotentiallyValid, isValid) {\n            return {\n                card: card,\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid\n            };\n        }\n\n        return function (value) {\n            var potentialTypes,\n                cardType,\n                valid,\n                i,\n                maxLength;\n\n            if (utils.isEmpty(value)) {\n                return resultWrapper(null, false, false);\n            }\n\n            value = value.replace(/\\-|\\s/g, '');\n\n            if (!/^\\d*$/.test(value)) {\n                return resultWrapper(null, false, false);\n            }\n\n            potentialTypes = creditCardTypes.getCardTypes(value);\n\n            if (potentialTypes.length === 0) {\n                return resultWrapper(null, false, false);\n            } else if (potentialTypes.length !== 1) {\n                return resultWrapper(null, true, false);\n            }\n\n            cardType = potentialTypes[0];\n\n            if (cardType.type === 'unionpay') {  // UnionPay is not Luhn 10 compliant\n                valid = true;\n            } else {\n                valid = luhn10(value);\n            }\n\n            for (i = 0; i < cardType.lengths.length; i++) {\n                if (cardType.lengths[i] === value.length) {\n                    return resultWrapper(cardType, valid, valid);\n                }\n            }\n\n            maxLength = Math.max.apply(null, cardType.lengths);\n\n            if (value.length < maxLength) {\n                return resultWrapper(cardType, true, false);\n            }\n\n            return resultWrapper(cardType, false, false);\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/cvv-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n\n        function resultWrapper(isValid, isPotentiallyValid) {\n            return {\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid\n            };\n        }\n\n        /**\n         * CVV number validation\n         * validate digit count fot CVV code\n         */\n        return function(value, maxLength) {\n            var DEFAULT_LENGTH = 3;\n            maxLength = maxLength || DEFAULT_LENGTH;\n\n            if (!/^\\d*$/.test(value)) {\n                return resultWrapper(false, false);\n            }\n            if (value.length === maxLength) {\n                return resultWrapper(true, true);\n            }\n            if (value.length < maxLength) {\n                return resultWrapper(false, true);\n            }\n            if (value.length > maxLength) {\n                return resultWrapper(false, false);\n            }\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'mageUtils',\n        'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date',\n        'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n        'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator'\n    ],\n    function(utils, parseDate, expirationMonth, expirationYear) {\n        'use strict';\n\n        function resultWrapper(isValid, isPotentiallyValid, month, year) {\n            return {\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid,\n                month: month,\n                year: year\n            };\n        }\n\n        return function(value) {\n            var date,\n                monthValid,\n                yearValid;\n\n            if (utils.isEmpty(value)) {\n                return resultWrapper(false, false, null, null);\n            }\n\n            value = value.replace(/^(\\d\\d) (\\d\\d(\\d\\d)?)$/, '$1/$2');\n            date = parseDate(value);\n            monthValid = expirationMonth(date.month);\n            yearValid = expirationYear(date.year);\n\n            if (monthValid.isValid && yearValid.isValid) {\n                return resultWrapper(true, true, date.month, date.year);\n            }\n\n            if (monthValid.isPotentiallyValid && yearValid.isPotentiallyValid) {\n                return resultWrapper(false, true, null, null);\n            }\n\n            return resultWrapper(false, false, null, null);\n        }\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'Magento_Payment/js/model/credit-card-validation/cvv-validator',\n            'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n            'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator',\n            'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n            'Magento_Payment/js/model/credit-card-validation/credit-card-data'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($, cvvValidator, creditCardNumberValidator, expirationDateValidator, monthValidator, creditCardData) {\n    \"use strict\";\n\n    $.each({\n        'validate-card-type': [\n            function (number, item, allowedTypes) {\n                var cardInfo,\n                    i,\n                    l;\n\n                if (!creditCardNumberValidator(number).isValid) {\n                    return false;\n                } else {\n                    cardInfo = creditCardNumberValidator(number).card;\n\n                    for (i = 0, l = allowedTypes.length; i < l; i++) {\n                        if (cardInfo.title == allowedTypes[i].type) {\n                            return true;\n                        }\n                    }\n                    return false;\n                }\n            },\n            'Please enter a valid credit card type number.'\n        ],\n        'validate-card-number': [\n            /**\n             * Validate credit card number based on mod 10\n             * @param number - credit card number\n             * @return {boolean}\n             */\n                function (number) {\n                return creditCardNumberValidator(number).isValid;\n            },\n            'Please enter a valid credit card number.'\n        ],\n        'validate-card-date': [\n            /**\n             * Validate credit card number based on mod 10\n             * @param date - month\n             * @return {boolean}\n             */\n                function (date) {\n                return monthValidator(date).isValid;\n            },\n            'Incorrect credit card expiration month.'\n        ],\n        'validate-card-cvv': [\n            /**\n             * Validate credit card number based on mod 10\n             * @param cvv - month\n             * @return {boolean}\n             */\n                function (cvv) {\n                var maxLength = creditCardData.creditCard ? creditCardData.creditCard.code.size : 3;\n                return cvvValidator(cvv, maxLength).isValid;\n            },\n            'Please enter a valid credit card verification number.'\n        ],\n        'validate-card-year': [\n            /**\n             * Validate credit card number based on mod 10\n             * @param date - month\n             * @return {boolean}\n             */\n                function (date) {\n                return monthValidator(date).isValid;\n            },\n            'Incorrect credit card expiration year.'\n        ]\n\n    }, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n}));","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'mageUtils'\n    ],\n    function ($, utils) {\n        'use strict';\n        var types = [\n            {\n                title: 'Visa',\n                type: 'VI',\n                pattern: '^4\\\\d*$',\n                gaps: [4, 8, 12],\n                lengths: [16],\n                code: {\n                    name: 'CVV',\n                    size: 3\n                }\n            },\n            {\n                title: 'MasterCard',\n                type: 'MC',\n                pattern: '^5([1-5]\\\\d*)?$',\n                gaps: [4, 8, 12],\n                lengths: [16],\n                code: {\n                    name: 'CVC',\n                    size: 3\n                }\n            },\n            {\n                title: 'American Express',\n                type: 'AE',\n                pattern: '^3([47]\\\\d*)?$',\n                isAmex: true,\n                gaps: [4, 10],\n                lengths: [15],\n                code: {\n                    name: 'CID',\n                    size: 4\n                }\n            },\n            {\n                title: 'Diners',\n                type: 'DN',\n                pattern: '^3((0([0-5]\\\\d*)?)|[689]\\\\d*)?$',\n                gaps: [4, 10],\n                lengths: [14],\n                code: {\n                    name: 'CVV',\n                    size: 3\n                }\n            },\n            {\n                title: 'Discover',\n                type: 'DI',\n                pattern: '^6(0|01|011\\\\d*|5\\\\d*|4|4[4-9]\\\\d*)?$',\n                gaps: [4, 8, 12],\n                lengths: [16],\n                code: {\n                    name: 'CID',\n                    size: 3\n                }\n            },\n            {\n                title: 'JCB',\n                type: 'JCB',\n                pattern: '^((2|21|213|2131\\\\d*)|(1|18|180|1800\\\\d*)|(3|35\\\\d*))$',\n                gaps: [4, 8, 12],\n                lengths: [16],\n                code: {\n                    name: 'CVV',\n                    size: 3\n                }\n            },\n            {\n                title: 'UnionPay',\n                type: 'UN',\n                pattern: '^6(2\\\\d*)?$',\n                gaps: [4, 8, 12],\n                lengths: [16, 17, 18, 19],\n                code: {\n                    name: 'CVN',\n                    size: 3\n                }\n            },\n            {\n                title: 'Maestro International',\n                type: 'MI',\n                pattern: '^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$',\n                gaps: [4, 8, 12],\n                lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n                code: {\n                    name: 'CVC',\n                    size: 3\n                }\n            },\n            {\n                title: 'Maestro Domestic',\n                type: 'MD',\n                pattern: '^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$',\n                gaps: [4, 8, 12],\n                lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n                code: {\n                    name: 'CVC',\n                    size: 3\n                }\n            }\n        ];\n        return {\n            getCardTypes: function (cardNumber) {\n                var i, value,\n                    result = [];\n\n                if (utils.isEmpty(cardNumber)) {\n                    return result;\n                }\n\n                if (cardNumber === '') {\n                    return $.extend(true, {}, types);\n                }\n\n                for (i = 0; i < types.length; i++) {\n                    value = types[i];\n\n                    if (new RegExp(value.pattern).test(cardNumber)) {\n                        result.push($.extend(true, {}, value));\n                    }\n                }\n                return result;\n            }\n        }\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n        /**\n         * Luhn algorithm verification\n         */\n        return function(a, b, c, d, e) {\n            for(d = +a[b = a.length-1], e = 0; b--;) {\n                c = +a[b];\n                d += ++e % 2 ? 2 * c % 10 + (c > 4) : c;\n            }\n            return !(d%10)\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function () {\n        'use strict';\n\n        function resultWrapper(isValid, isPotentiallyValid) {\n            return {\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid\n            };\n        }\n\n        return function (value) {\n            var month,\n                monthValid;\n\n            if ((value.replace(/\\s/g, '') === '') || (value === '0')) {\n                return resultWrapper(false, true);\n            }\n\n            if (!/^\\d*$/.test(value)) {\n                return resultWrapper(false, false);\n            }\n\n            if (isNaN(value)) {\n                return resultWrapper(false, false);\n            }\n\n            month = parseInt(value, 10);\n            monthValid = month > 0 && month < 13;\n\n            return resultWrapper(monthValid, monthValid);\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n\n        function resultWrapper(isValid, isPotentiallyValid) {\n            return {\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid\n            };\n        }\n\n        return function(value) {\n            var currentYear = new Date().getFullYear(),\n                len = value.length,\n                valid,\n                expMaxLifetime = 19;\n\n            if (value.replace(/\\s/g, '') === '') {\n                return resultWrapper(false, true);\n            }\n\n            if (!/^\\d*$/.test(value)) {\n                return resultWrapper(false, false);\n            }\n\n            if (len !== 4) {\n                return resultWrapper(false, true);\n            }\n\n            value = parseInt(value, 10);\n            valid = value >= currentYear && value <= currentYear + expMaxLifetime;\n            return resultWrapper(valid, valid);\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n        return function(value) {\n            var month, len;\n\n            if (value.match('/')) {\n                value = value.split(/\\s*\\/\\s*/g);\n\n                return {\n                    month: value[0],\n                    year: value.slice(1).join()\n                };\n            }\n\n            len = (value[0] === '0' || value.length > 5 || value.length === 4 || value.length === 3) ? 2 : 1;\n            month = value.substr(0, len);\n\n            return {\n                month: month,\n                year: value.substr(month.length, 4)\n            };\n        }\n    }\n);\n","Magento_Payment/js/view/payment/cc-form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n        'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n        'mage/translate'\n    ],\n    function (_, Component, creditCardData, cardNumberValidator, $t) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                creditCardType: '',\n                creditCardExpYear: '',\n                creditCardExpMonth: '',\n                creditCardNumber: '',\n                creditCardSsStartMonth: '',\n                creditCardSsStartYear: '',\n                creditCardSsIssue: '',\n                creditCardVerificationNumber: '',\n                selectedCardType: null\n            },\n\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'creditCardType',\n                        'creditCardExpYear',\n                        'creditCardExpMonth',\n                        'creditCardNumber',\n                        'creditCardVerificationNumber',\n                        'creditCardSsStartMonth',\n                        'creditCardSsStartYear',\n                        'creditCardSsIssue',\n                        'selectedCardType'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * Init component\n             */\n            initialize: function () {\n                var self = this;\n\n                this._super();\n\n                //Set credit card number to credit card data object\n                this.creditCardNumber.subscribe(function (value) {\n                    var result;\n\n                    self.selectedCardType(null);\n\n                    if (value === '' || value === null) {\n                        return false;\n                    }\n                    result = cardNumberValidator(value);\n\n                    if (!result.isPotentiallyValid && !result.isValid) {\n                        return false;\n                    }\n\n                    if (result.card !== null) {\n                        self.selectedCardType(result.card.type);\n                        creditCardData.creditCard = result.card;\n                    }\n\n                    if (result.isValid) {\n                        creditCardData.creditCardNumber = value;\n                        self.creditCardType(result.card.type);\n                    }\n                });\n\n                //Set expiration year to credit card data object\n                this.creditCardExpYear.subscribe(function (value) {\n                    creditCardData.expirationYear = value;\n                });\n\n                //Set expiration month to credit card data object\n                this.creditCardExpMonth.subscribe(function (value) {\n                    creditCardData.expirationMonth = value;\n                });\n\n                //Set cvv code to credit card data object\n                this.creditCardVerificationNumber.subscribe(function (value) {\n                    creditCardData.cvvCode = value;\n                });\n            },\n\n            /**\n             * Get code\n             * @returns {String}\n             */\n            getCode: function () {\n                return 'cc';\n            },\n\n            /**\n             * Get data\n             * @returns {Object}\n             */\n            getData: function () {\n                return {\n                    'method': this.item.method,\n                    'additional_data': {\n                        'cc_cid': this.creditCardVerificationNumber(),\n                        'cc_ss_start_month': this.creditCardSsStartMonth(),\n                        'cc_ss_start_year': this.creditCardSsStartYear(),\n                        'cc_ss_issue': this.creditCardSsIssue(),\n                        'cc_type': this.creditCardType(),\n                        'cc_exp_year': this.creditCardExpYear(),\n                        'cc_exp_month': this.creditCardExpMonth(),\n                        'cc_number': this.creditCardNumber()\n                    }\n                };\n            },\n\n            /**\n             * Get list of available credit card types\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                return window.checkoutConfig.payment.ccform.availableTypes[this.getCode()];\n            },\n\n            /**\n             * Get payment icons\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * Get list of months\n             * @returns {Object}\n             */\n            getCcMonths: function () {\n                return window.checkoutConfig.payment.ccform.months[this.getCode()];\n            },\n\n            /**\n             * Get list of years\n             * @returns {Object}\n             */\n            getCcYears: function () {\n                return window.checkoutConfig.payment.ccform.years[this.getCode()];\n            },\n\n            /**\n             * Check if current payment has verification\n             * @returns {Boolean}\n             */\n            hasVerification: function () {\n                return window.checkoutConfig.payment.ccform.hasVerification[this.getCode()];\n            },\n\n            /**\n             * @deprecated\n             * @returns {Boolean}\n             */\n            hasSsCardType: function () {\n                return window.checkoutConfig.payment.ccform.hasSsCardType[this.getCode()];\n            },\n\n            /**\n             * Get image url for CVV\n             * @returns {String}\n             */\n            getCvvImageUrl: function () {\n                return window.checkoutConfig.payment.ccform.cvvImageUrl[this.getCode()];\n            },\n\n            /**\n             * Get image for CVV\n             * @returns {String}\n             */\n            getCvvImageHtml: function () {\n                return '<img src=\"' + this.getCvvImageUrl() +\n                    '\" alt=\"' + $t('Card Verification Number Visual Reference') +\n                    '\" title=\"' + $t('Card Verification Number Visual Reference') +\n                    '\" />';\n            },\n\n            /**\n             * @deprecated\n             * @returns {Object}\n             */\n            getSsStartYears: function () {\n                return window.checkoutConfig.payment.ccform.ssStartYears[this.getCode()];\n            },\n\n            /**\n             * Get list of available credit card types values\n             * @returns {Object}\n             */\n            getCcAvailableTypesValues: function () {\n                return _.map(this.getCcAvailableTypes(), function (value, key) {\n                    return {\n                        'value': key,\n                        'type': value\n                    };\n                });\n            },\n\n            /**\n             * Get list of available month values\n             * @returns {Object}\n             */\n            getCcMonthsValues: function () {\n                return _.map(this.getCcMonths(), function (value, key) {\n                    return {\n                        'value': key,\n                        'month': value\n                    };\n                });\n            },\n\n            /**\n             * Get list of available year values\n             * @returns {Object}\n             */\n            getCcYearsValues: function () {\n                return _.map(this.getCcYears(), function (value, key) {\n                    return {\n                        'value': key,\n                        'year': value\n                    };\n                });\n            },\n\n            /**\n             * @deprecated\n             * @returns {Object}\n             */\n            getSsStartYearsValues: function () {\n                return _.map(this.getSsStartYears(), function (value, key) {\n                    return {\n                        'value': key,\n                        'year': value\n                    };\n                });\n            },\n\n            /**\n             * Is legend available to display\n             * @returns {Boolean}\n             */\n            isShowLegend: function () {\n                return false;\n            },\n\n            /**\n             * Get available credit card type by code\n             * @param {String} code\n             * @returns {String}\n             */\n            getCcTypeTitleByCode: function (code) {\n                var title = '',\n                    keyValue = 'value',\n                    keyType = 'type';\n\n                _.each(this.getCcAvailableTypesValues(), function (value) {\n                    if (value[keyValue] === code) {\n                        title = value[keyType];\n                    }\n                });\n\n                return title;\n            },\n\n            /**\n             * Prepare credit card number to output\n             * @param {String} number\n             * @returns {String}\n             */\n            formatDisplayCcNumber: function (number) {\n                return 'xxxx-' + number.substr(-4);\n            },\n\n            /**\n             * Get credit card details\n             * @returns {Array}\n             */\n            getInfo: function () {\n                return [\n                    {\n                        'name': 'Credit Card Type', value: this.getCcTypeTitleByCode(this.creditCardType())\n                    },\n                    {\n                        'name': 'Credit Card Number', value: this.formatDisplayCcNumber(this.creditCardNumber())\n                    }\n                ];\n            }\n        });\n    }\n);\n","Magento_Payment/js/view/payment/iframe.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Ui/js/model/messageList',\n        'mage/translate',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/set-payment-information',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Ui/js/modal/alert'\n    ],\n    function (\n        $,\n        Component,\n        messageList,\n        $t,\n        fullScreenLoader,\n        setPaymentInformationAction,\n        additionalValidators,\n        alert\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Payment/payment/iframe',\n                timeoutId: null,\n                timeoutMessage: 'Sorry, but something went wrong.'\n            },\n\n            /**\n             * @returns {String}\n             */\n            getSource: function () {\n                return window.checkoutConfig.payment.iframe.source[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getControllerName: function () {\n                return window.checkoutConfig.payment.iframe.controllerName[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getPlaceOrderUrl: function () {\n                return window.checkoutConfig.payment.iframe.placeOrderUrl[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCgiUrl: function () {\n                return window.checkoutConfig.payment.iframe.cgiUrl[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getSaveOrderUrl: function () {\n                return window.checkoutConfig.payment.iframe.saveOrderUrl[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getDateDelim: function () {\n                return window.checkoutConfig.payment.iframe.dateDelim[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCardFieldsMap: function () {\n                return window.checkoutConfig.payment.iframe.cardFieldsMap[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getExpireYearLength: function () {\n                return window.checkoutConfig.payment.iframe.expireYearLength[this.getCode()];\n            },\n\n            /**\n             * @param {Object} parent\n             * @returns {Function}\n             */\n            originalPlaceOrder: function (parent) {\n                return parent.placeOrder.bind(parent);\n            },\n\n            /**\n             * @returns {Number}\n             */\n            getTimeoutTime: function () {\n                return window.checkoutConfig.payment.iframe.timeoutTime[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTimeoutMessage: function () {\n                return $t(this.timeoutMessage);\n            },\n\n            /**\n             * @override\n             */\n            placeOrder: function () {\n                if (this.validateHandler() && additionalValidators.validate()) {\n\n                    fullScreenLoader.startLoader();\n\n                    this.isPlaceOrderActionAllowed(false);\n\n                    $.when(\n                        setPaymentInformationAction(\n                            this.messageContainer,\n                            {\n                                method: this.getCode()\n                            }\n                        )\n                    ).done(this.done.bind(this))\n                        .fail(this.fail.bind(this));\n\n                    this.initTimeoutHandler();\n                }\n            },\n\n            /**\n             * {Function}\n             */\n            initTimeoutHandler: function () {\n                this.timeoutId = setTimeout(\n                    this.timeoutHandler.bind(this),\n                    this.getTimeoutTime()\n                );\n\n                $(window).off('clearTimeout')\n                    .on('clearTimeout', this.clearTimeout.bind(this));\n            },\n\n            /**\n             * {Function}\n             */\n            clearTimeout: function () {\n                clearTimeout(this.timeoutId);\n\n                return this;\n            },\n\n            /**\n             * {Function}\n             */\n            timeoutHandler: function () {\n                this.clearTimeout();\n\n                alert(\n                    {\n                        content: this.getTimeoutMessage(),\n                        actions: {\n\n                            /**\n                             * {Function}\n                             */\n                            always: this.alertActionHandler.bind(this)\n                        }\n                    }\n                );\n\n                this.fail();\n            },\n\n            /**\n             * {Function}\n             */\n            alertActionHandler: function () {\n                fullScreenLoader.startLoader();\n                window.location.reload();\n            },\n\n            /**\n             * {Function}\n             */\n            fail: function () {\n                fullScreenLoader.stopLoader();\n                this.isPlaceOrderActionAllowed(true);\n\n                return this;\n            },\n\n            /**\n             * {Function}\n             */\n            done: function () {\n                this.placeOrderHandler().fail(function () {\n                    fullScreenLoader.stopLoader();\n                });\n\n                return this;\n            }\n        });\n    }\n);\n","Magento_Payment/js/view/payment/payments.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n        rendererList.push(\n            {\n                type: 'free',\n                component: 'Magento_Payment/js/view/payment/method-renderer/free-method'\n            }\n        );\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);","Magento_Payment/js/view/payment/method-renderer/free-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Payment/payment/free'\n            },\n\n            /** Returns is method available */\n            isAvailable: function() {\n                return quote.totals().grand_total <= 0;\n            }\n        });\n    }\n);\n","Magento_GiftMessage/extra-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.extraOptions', {\n        options: {\n            events: 'billingSave shippingSave',\n            additionalContainer: '#onepage-checkout-shipping-method-additional-load'\n        },\n\n        /**\n         * Set up event handler for requesting any additional extra options from the backend.\n         * @private\n         */\n        _create: function() {\n            this.element.on(this.options.events, $.proxy(this._addExtraOptions, this));\n        },\n\n        /**\n         * Fetch the extra options using an Ajax call. Extra options include Gift Receipt and\n         * Printed Card.\n         * @private\n         */\n        _addExtraOptions: function() {\n            $.ajax({\n                url: this.options.additionalUrl,\n                context: this,\n                type: 'post',\n                async: false,\n                success: function(response) {\n                    $(this.options.additionalContainer).html(response).trigger('contentUpdated');\n                }\n            });\n        }\n    });\n    \n    return $.mage.extraOptions;\n});","Magento_GiftMessage/gift-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.giftOptions', {\n        options: {\n            mageError: 'mage-error',\n            noDisplay: 'no-display',\n            requiredEntry: 'required-entry'\n        },\n\n        /**\n         * Initial toggle of the various gift options after widget instantiation.\n         * @private\n         */\n        _init: function() {\n            this._toggleVisibility();\n        },\n\n        /**\n         * Bind a click handler to the widget's context element.\n         * @private\n         */\n        _create: function() {\n            this.element.on('click', $.proxy(this._toggleVisibility, this));\n            $(this.element.data('selector').id).find('.giftmessage-area')\n                .on('change', $.proxy(this._toggleRequired, this));\n        },\n\n        /**\n         * Toggle the visibility of the widget's context element's selector(s).\n         * @private\n         * @param event {Object} - Click event. Target is a checkbox.\n         */\n        _toggleVisibility: function(event) {\n            var checkbox = event ? $(event.target) : this.element,\n                container = $(checkbox.data('selector').id);\n            if (checkbox.is(':checked')) {\n                container.show()\n                    .find('.giftmessage-area:not(:visible)').each(function(x, element) {\n                        if ($(element).val().length > 0) {\n                            $(element).change();\n                            container.find('a').click();\n                        }\n                    });\n            } else {\n                var _this = this;\n                container.hide()\n                    .find('.input-text:not(.giftmessage-area)').each(function(x, element) {\n                        $(element).val(element.defaultValue).removeClass(_this.options.mageError)\n                            .next('div.' + _this.options.mageError).remove();\n                    }).end()\n                    .find('.giftmessage-area').val('').change().end()\n                    .find('.select').val('').change().end()\n                    .find('.checkbox:checked').prop('checked', false).click().prop('checked', false).end()\n                    .find('.price-box').addClass(this.options.noDisplay).end();\n            }\n        },\n\n        /**\n         * Make the From and To input fields required if a gift message has been written.\n         * @private\n         * @param event {Object} - Change event. Target is a textarea.\n         */\n        _toggleRequired: function(event) {\n            var textArea = $(event.target),\n                length = textArea.val().length;\n            textArea.closest('li').prev('.fields')\n                .find('.input-text').toggleClass(this.options.requiredEntry, length > 0);\n        }\n    });\n    \n    return $.mage.giftOptions;\n});","Magento_GiftMessage/js/action/gift-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_GiftMessage/js/model/url-builder',\n        'mage/storage',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/model/error-processor',\n        'mage/url',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (urlBuilder, storage, messageList, errorProcessor, url, quote) {\n        'use strict';\n\n        return function (giftMessage, remove) {\n            var serviceUrl;\n\n            url.setBaseUrl(giftMessage.getConfigValue('baseUrl'));\n\n            if (giftMessage.getConfigValue('isCustomerLoggedIn')) {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message', {});\n\n                if (giftMessage.itemId != 'orderLevel') {\n                    serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message/:itemId', {\n                        itemId: giftMessage.itemId\n                    });\n                }\n            } else {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/gift-message', {\n                    cartId: quote.getQuoteId()\n                });\n\n                if (giftMessage.itemId != 'orderLevel') {\n                    serviceUrl = urlBuilder.createUrl(\n                        '/guest-carts/:cartId/gift-message/:itemId',\n                        {\n                            cartId: quote.getQuoteId(), itemId: giftMessage.itemId\n                        }\n                    );\n                }\n            }\n            messageList.clear();\n\n            storage.post(\n                serviceUrl,\n                JSON.stringify({\n                    gift_message: giftMessage.getSubmitParams(remove)\n                })\n            ).done(\n                function (response) {\n                    giftMessage.reset();\n                    _.each(giftMessage.getAfterSubmitCallbacks(), function (callback) {\n                        if (_.isFunction(callback)) {\n                            callback();\n                        }\n                    });\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response);\n                }\n            );\n        };\n    }\n);\n","Magento_GiftMessage/js/model/gift-message.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(['uiElement', 'underscore', 'mage/url'],\n    function (uiElement, _, url) {\n        'use strict';\n\n        var provider = uiElement();\n\n        return function (itemId) {\n            var model = {\n                id: 'message-' + itemId,\n                itemId: itemId,\n                observables: {},\n                additionalOptions: [],\n                submitParams: [\n                    'recipient',\n                    'sender',\n                    'message'\n                ],\n                initialize: function() {\n                    this.getObservable('alreadyAdded')(false);\n                    var message = false;\n\n                    if (this.itemId == 'orderLevel') {\n                        message = window.giftOptionsConfig.giftMessage.hasOwnProperty(this.itemId)\n                            ? window.giftOptionsConfig.giftMessage[this.itemId]\n                            : null;\n                    } else {\n                        message =\n                            window.giftOptionsConfig.giftMessage.hasOwnProperty('itemLevel')\n                            && window.giftOptionsConfig.giftMessage['itemLevel'].hasOwnProperty(this.itemId)\n                            ? window.giftOptionsConfig.giftMessage['itemLevel'][this.itemId]['message']\n                            : null;\n                    }\n                    if (_.isObject(message)) {\n                        this.getObservable('recipient')(message.recipient);\n                        this.getObservable('sender')(message.sender);\n                        this.getObservable('message')(message.message);\n                        this.getObservable('alreadyAdded')(true);\n                    }\n                },\n                getObservable: function(key) {\n                    this.initObservable(this.id, key);\n                    return provider[this.getUniqueKey(this.id, key)];\n                },\n                initObservable: function(node, key) {\n                    if (node && !this.observables.hasOwnProperty(node)) {\n                        this.observables[node] = [];\n                    }\n                    if (key && this.observables[node].indexOf(key) == -1) {\n                        this.observables[node].push(key);\n                        provider.observe(this.getUniqueKey(node, key));\n                    }\n                },\n                getUniqueKey: function(node, key) {\n                    return node + '-' + key;\n                },\n                getConfigValue: function(key) {\n                    return window.giftOptionsConfig.hasOwnProperty(key) ?\n                        window.giftOptionsConfig[key]\n                        : null;\n                },\n                reset: function() {\n                    this.getObservable('isClear')(true);\n                },\n                getAfterSubmitCallbacks: function() {\n                    var callbacks = [];\n                    callbacks.push(this.afterSubmit);\n                    _.each(this.additionalOptions, function(option) {\n                        if (_.isFunction(option.afterSubmit)) {\n                            callbacks.push(option.afterSubmit);\n                        }\n                    });\n                    return callbacks;\n                },\n                afterSubmit: function() {\n                    window.location.href = url.build('checkout/cart/updatePost')\n                        + '?form_key=' + window.giftOptionsConfig.giftMessage.formKey\n                        + '&cart[]';\n                },\n                getSubmitParams: function(remove) {\n                    var params = {},\n                        self = this;\n                    _.each(this.submitParams, function(key) {\n                        var observable = provider[self.getUniqueKey(self.id, key)];\n                        if (_.isFunction(observable)) {\n                            params[key] = remove ? null : observable();\n                        }\n                    });\n\n                    if(this.additionalOptions.length) {\n                        params['extension_attributes'] = {};\n                    }\n                    _.each(this.additionalOptions, function(option) {\n                        if (_.isFunction(option.getSubmitParams)) {\n                            params['extension_attributes'] = _.extend(\n                                params['extension_attributes'],\n                                option.getSubmitParams(remove)\n                            );\n                        }\n                    });\n                    return params;\n                },\n\n                /**\n                 * Check if gift message can be displayed\n                 *\n                 * @returns {Boolean}\n                 */\n                isGiftMessageAvailable: function () {\n                    var isGloballyAvailable,\n                        giftMessageConfig,\n                        itemConfig;\n\n                    // itemId represent gift message level: 'orderLevel' constant or cart item ID\n                    if (this.itemId === 'orderLevel') {\n                        return this.getConfigValue('isOrderLevelGiftOptionsEnabled');\n                    }\n\n                    // gift message product configuration must override system configuration\n                    isGloballyAvailable = this.getConfigValue('isItemLevelGiftOptionsEnabled');\n                    giftMessageConfig = window.giftOptionsConfig.giftMessage;\n                    itemConfig = giftMessageConfig.hasOwnProperty('itemLevel') &&\n                        giftMessageConfig.itemLevel.hasOwnProperty(this.itemId) ?\n                        giftMessageConfig.itemLevel[this.itemId] :\n                        {};\n\n                    return itemConfig.hasOwnProperty('is_available') ? itemConfig['is_available'] : isGloballyAvailable;\n                }\n            };\n            model.initialize();\n            return model;\n        }\n    }\n);\n","Magento_GiftMessage/js/model/gift-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(['underscore', 'ko'],\n    function (_, ko) {\n\n        'use strict';\n\n        return {\n            options: ko.observableArray([]),\n            addOption: function (option) {\n                if (!this.options().hasOwnProperty(option.itemId)) {\n                    this.options.push({\n                            id: option.itemId, value: option\n                        }\n                    );\n                }\n            },\n            getOptionByItemId: function (itemId) {\n                var option = null;\n                _.each(this.options(), function (data) {\n                    if (data.id === itemId) {\n                        option = data.value;\n\n                        return false;\n                    }\n                });\n\n                return option;\n            }\n        };\n    }\n);\n","Magento_GiftMessage/js/model/url-builder.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/url-builder'\n    ],\n    function ($, urlBuilder) {\n        'use strict';\n\n        return $.extend(\n            urlBuilder,\n            {\n                storeCode: window.giftOptionsConfig.storeCode\n            }\n        );\n    }\n);\n","Magento_GiftMessage/js/view/gift-message.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_GiftMessage/js/model/gift-message',\n        'Magento_GiftMessage/js/model/gift-options',\n        'Magento_GiftMessage/js/action/gift-options'\n    ],\n    function (Component, GiftMessage, giftOptions, giftOptionsService) {\n        'use strict';\n\n        return Component.extend({\n            formBlockVisibility: null,\n            resultBlockVisibility: null,\n            model: {},\n\n            /**\n             * Component init\n             */\n            initialize: function () {\n                var self = this,\n                    model;\n\n                this._super()\n                    .observe('formBlockVisibility')\n                    .observe({\n                        'resultBlockVisibility': false\n                    });\n\n                this.itemId = this.itemId || 'orderLevel';\n                model = new GiftMessage(this.itemId);\n                giftOptions.addOption(model);\n                this.model = model;\n\n                this.model.getObservable('isClear').subscribe(function (value) {\n                    if (value == true) {\n                        self.formBlockVisibility(false);\n                        self.model.getObservable('alreadyAdded')(true);\n                    }\n                });\n\n                this.isResultBlockVisible();\n            },\n\n            /**\n             * Is reslt block visible\n             */\n            isResultBlockVisible: function () {\n                var self = this;\n\n                if (this.model.getObservable('alreadyAdded')()) {\n                    this.resultBlockVisibility(true);\n                }\n                this.model.getObservable('additionalOptionsApplied').subscribe(function (value) {\n                    if (value == true) {\n                        self.resultBlockVisibility(true);\n                    }\n                });\n            },\n\n            /**\n             * @param {String} key\n             * @return {*}\n             */\n            getObservable: function (key) {\n                return this.model.getObservable(key);\n            },\n\n            /**\n             * Hide\\Show form block\n             */\n            toggleFormBlockVisibility: function () {\n                if (!this.model.getObservable('alreadyAdded')()) {\n                    this.formBlockVisibility(!this.formBlockVisibility());\n                } else {\n                    this.resultBlockVisibility(!this.resultBlockVisibility());\n                }\n            },\n\n            /**\n             * Edit options\n             */\n            editOptions: function () {\n                this.resultBlockVisibility(false);\n                this.formBlockVisibility(true);\n            },\n\n            /**\n             * Delete options\n             */\n            deleteOptions: function () {\n                giftOptionsService(this.model, true);\n            },\n\n            /**\n             * Hide form block\n             */\n            hideFormBlock: function () {\n                this.formBlockVisibility(false);\n\n                if (this.model.getObservable('alreadyAdded')()) {\n                    this.resultBlockVisibility(true);\n                }\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            hasActiveOptions: function () {\n                var regionData = this.getRegion('additionalOptions'),\n                    options = regionData();\n\n                for (var i = 0; i < options.length; i++) {\n                    if (options[i].isActive()) {\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isActive: function () {\n                return this.model.isGiftMessageAvailable();\n            },\n\n            /**\n             * Submit options\n             */\n            submitOptions: function () {\n                giftOptionsService(this.model);\n            }\n        });\n    }\n);\n","Magento_Downloadable/downloadable.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true expr:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"Magento_Catalog/js/price-box\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.downloadable', {\n        options: {\n            priceHolderSelector: '.price-box'\n        },\n\n        _create: function() {\n            var self = this;\n\n            this.element.find(this.options.linkElement).on('change', $.proxy(function() {\n                this._reloadPrice();\n            }, this));\n\n            this.element.find(this.options.allElements).on('change', function() {\n                if (this.checked) {\n                    $('label[for=\"' + this.id + '\"] > span').text($(this).attr('data-checked'));\n                    self.element.find(self.options.linkElement + ':not(:checked)').each(function(){\n                        $(this).trigger('click');\n                    });\n                } else {\n                    $('[for=\"' + this.id + '\"] > span').text($(this).attr('data-notchecked'));\n                    self.element.find(self.options.linkElement + ':checked').each(function(){\n                        $(this).trigger('click');\n                    });\n                }\n            });\n        },\n\n        /**\n         * Reload product price with selected link price included\n         * @private\n         */\n        _reloadPrice: function() {\n            var finalPrice = 0;\n            var basePrice = 0;\n            this.element.find(this.options.linkElement + ':checked').each($.proxy(function(index, element) {\n                finalPrice += this.options.config.links[$(element).val()].finalPrice;\n                basePrice += this.options.config.links[$(element).val()].basePrice;\n            }, this));\n\n            $(this.options.priceHolderSelector).trigger('updatePrice', {\n                'prices': {\n                    'finalPrice': { 'amount': finalPrice },\n                    'basePrice': { 'amount': basePrice }\n                }\n            });\n        }\n    });\n    \n    return $.mage.downloadable;\n});","Magento_Msrp/js/msrp.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'mage/dropdown',\n    'mage/template'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.addToCart', {\n        options: {\n            showAddToCart: true,\n            submitUrl: '',\n            cartButtonId: '',\n            singleOpenDropDown: true,\n            dialog: {}, // Options for mage/dropdown\n            dialogDelay: 500, // Delay in ms after resize dropdown shown again\n            origin: '', //Required, type of popup: 'msrp', 'tier' or 'info' popup\n\n            // Selectors\n            cartForm: '.form.map.checkout',\n            msrpLabelId: '#map-popup-msrp',\n            priceLabelId: '#map-popup-price',\n            popUpAttr: '[data-role=msrp-popup-template]',\n            popupCartButtonId: '#map-popup-button',\n            paypalCheckoutButons: '[data-action=checkout-form-submit]',\n            popupId: '',\n            realPrice: '',\n            isSaleable: '',\n            msrpPrice: '',\n            helpLinkId: '',\n            addToCartButton: '',\n\n            // Text options\n            productName: '',\n            addToCartUrl: ''\n        },\n\n        openDropDown: null,\n        triggerClass: 'dropdown-active',\n\n        popUpOptions: {\n            appendTo: 'body',\n            dialogContentClass: 'active',\n            closeOnMouseLeave: false,\n            autoPosition: true,\n            closeOnClickOutside: false,\n            'dialogClass': 'popup map-popup-wrapper',\n            position: {\n                my: 'left top',\n                collision: 'fit none',\n                at: 'left bottom',\n                within: 'body'\n            },\n            shadowHinter: 'popup popup-pointer'\n        },\n        popupOpened: false,\n\n        /**\n         * Creates widget instance\n         * @private\n         */\n        _create: function () {\n            if (this.options.origin === 'msrp') {\n                this.initMsrpPopup();\n            } else if (this.options.origin === 'info') {\n                this.initInfoPopup();\n            } else if (this.options.origin === 'tier') {\n                this.initTierPopup();\n            }\n            $(this.options.cartButtonId).on('click', this._addToCartSubmit.bind(this));\n        },\n\n        /**\n         * Init msrp popup\n         * @private\n         */\n        initMsrpPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $msrpPopup = $(popupDOM.innerHTML.trim());\n\n            $msrpPopup.find(this.options.productIdInput).val(this.options.productId);\n            $('body').append($msrpPopup);\n            $msrpPopup.trigger('contentUpdated');\n\n            $msrpPopup.find('button')\n                .on('click',\n                this.handleMsrpAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $msrpPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleMsrpPaypalCheckout.bind(this));\n\n            $(this.options.popupId).on('click',\n                this.openPopup.bind(this));\n\n            this.$popup = $msrpPopup;\n        },\n\n        /**\n         * Init info popup\n         * @private\n         */\n        initInfoPopup: function () {\n            var infoPopupDOM = $('[data-role=msrp-info-template]')[0],\n                $infoPopup = $(infoPopupDOM.innerHTML.trim());\n\n            $('body').append($infoPopup);\n\n            $(this.options.helpLinkId).on('click', function (e) {\n                this.popUpOptions.position.of = $(e.target);\n                $infoPopup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n                this._toggle($infoPopup);\n            }.bind(this));\n\n            this.$popup = $infoPopup;\n        },\n\n        /**\n         * Init tier price popup\n         * @private\n         */\n        initTierPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $tierPopup = $(popupDOM.innerHTML.trim());\n\n            $('body').append($tierPopup);\n            $tierPopup.find(this.options.productIdInput).val(this.options.productId);\n            this.popUpOptions.position.of = $(this.options.helpLinkId);\n\n            $tierPopup.find('button').on('click',\n                this.handleTierAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $tierPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleTierPaypalCheckout.bind(this));\n\n            $(this.options.attr).on('click', function (e) {\n                this.$popup = $tierPopup;\n                this.tierOptions = $(e.target).data('tier-price');\n                this.openPopup(e);\n            }.bind(this));\n        },\n\n        /**\n         * handle 'AddToCart' click on Msrp popup\n         * @param {Object} ev\n         *\n         * @private\n         */\n        handleMsrpAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Msrp popup\n         *\n         * @private\n         */\n        handleMsrpPaypalCheckout: function () {\n            this.closePopup(this.$popup);\n        },\n\n        /**\n         * handle 'AddToCart' click on Tier popup\n         *\n         * @param {Object} ev\n         * @private\n         */\n        handleTierAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton &&\n                this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Tier popup\n         *\n         * @private\n         */\n        handleTierPaypalCheckout: function () {\n            if (this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * Open and set up popup\n         *\n         * @param {Object} event\n         */\n        openPopup: function (event) {\n            var options = this.tierOptions || this.options;\n\n            this.popUpOptions.position.of = $(event.target);\n            this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n            this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n            this.$popup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n            this._toggle(this.$popup);\n\n            if (!this.options.isSaleable) {\n                this.$popup.find('form').hide();\n            }\n        },\n\n        /**\n         *\n         * @param {HTMLElement} $elem\n         * @private\n         */\n        _toggle: function ($elem) {\n            $(document).on('mouseup.msrp touchend.msrp', function (e) {\n                if (!$elem.is(e.target) && $elem.has(e.target).length === 0) {\n                    this.closePopup($elem);\n                }\n            }.bind(this));\n            $(window).on('resize', function () {\n                this.closePopup($elem);\n            }.bind(this));\n        },\n\n        /**\n         *\n         * @param {HTMLElement} $elem\n         */\n        closePopup: function ($elem) {\n            $elem.dropdownDialog('close');\n            $(document).off('mouseup.msrp touchend.msrp');\n        },\n\n        /**\n         * Handler for addToCart action\n         */\n        _addToCartSubmit: function () {\n            this.element.trigger('addToCart', this.element);\n\n            if (this.element.data('stop-processing')) {\n                return false;\n            }\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n\n                return false;\n            }\n\n            if (this.options.addToCartUrl) {\n                $('.mage-dropdown-dialog > .ui-dialog-content').dropdownDialog('close');\n            }\n            $(this.options.cartForm).submit();\n\n        }\n    });\n\n    return $.mage.addToCart;\n});\n","Magento_Msrp/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Tax/js/view/checkout/minicart/subtotal/totals',\n    'underscore'\n], function (Component, _) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.displaySubtotal(this.isMsrpApplied(this.cart().items));\n            this.cart.subscribe(function (updatedCart) {\n\n                this.displaySubtotal(this.isMsrpApplied(updatedCart.items));\n            }, this);\n        },\n\n        /**\n         * Determine if subtotal should be hidden.\n         * @param {Array} cartItems\n         * @return {Boolean}\n         */\n        isMsrpApplied: function (cartItems) {\n            return !_.find(cartItems, function (item) {\n                if (_.has(item, 'canApplyMsrp')) {\n                    return item.canApplyMsrp;\n                }\n\n                return false;\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery/ui',\n    'jquery/jquery.parsequery'\n], function ($, _, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.configurable', {\n        options: {\n            superSelector: '.super-attribute-select',\n            selectSimpleProduct: '[name=\"selected_configurable_option\"]',\n            priceHolderSelector: '.price-box',\n            spConfig: {},\n            state: {},\n            priceFormat: {},\n            optionTemplate: '<%- data.label %>' +\n            \"<% if (typeof data.finalPrice.value !== 'undefined') { %>\" +\n            ' <%- data.finalPrice.formatted %>' +\n            '<% } %>',\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n            mediaGalleryInitial: null,\n            onlyMainImg: false\n        },\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            // Initial setting of various option values\n            this._initializeOptions();\n\n            // Override defaults with URL query parameters and/or inputs values\n            this._overrideDefaults();\n\n            // Change events to check select reloads\n            this._setupChangeEvents();\n\n            // Fill state\n            this._fillState();\n\n            // Setup child and prev/next settings\n            this._setChildSettings();\n\n            // Setup/configure values to inputs\n            this._configureForValues();\n        },\n\n        /**\n         * Initialize tax configuration, initial settings, and options values.\n         * @private\n         */\n        _initializeOptions: function () {\n            var options = this.options,\n                gallery = $(options.mediaGallerySelector),\n                priceBoxOptions = $(this.options.priceHolderSelector).priceBox('option').priceConfig || null;\n\n            if (priceBoxOptions && priceBoxOptions.optionTemplate) {\n                options.optionTemplate = priceBoxOptions.optionTemplate;\n            }\n\n            if (priceBoxOptions && priceBoxOptions.priceFormat) {\n                options.priceFormat = priceBoxOptions.priceFormat;\n            }\n            options.optionTemplate = mageTemplate(options.optionTemplate);\n\n            options.settings = options.spConfig.containerId ?\n                $(options.spConfig.containerId).find(options.superSelector) :\n                $(options.superSelector);\n\n            options.values = options.spConfig.defaultValues || {};\n            options.parentImage = $('[data-role=base-image-container] img').attr('src');\n\n            this.inputSimpleProduct = this.element.find(options.selectSimpleProduct);\n\n            gallery.on('gallery:loaded', function () {\n                var galleryObject = gallery.data('gallery');\n                options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n            });\n        },\n\n        /**\n         * Override default options values settings with either URL query parameters or\n         * initialized inputs values.\n         * @private\n         */\n        _overrideDefaults: function () {\n            var hashIndex = window.location.href.indexOf('#');\n\n            if (hashIndex !== -1) {\n                this._parseQueryParams(window.location.href.substr(hashIndex + 1));\n            }\n\n            if (this.options.spConfig.inputsInitialized) {\n                this._setValuesByAttribute();\n            }\n        },\n\n        /**\n         * Parse query parameters from a query string and set options values based on the\n         * key value pairs of the parameters.\n         * @param {*} queryString - URL query string containing query parameters.\n         * @private\n         */\n        _parseQueryParams: function (queryString) {\n            var queryParams = $.parseQuery({\n                query: queryString\n            });\n\n            $.each(queryParams, $.proxy(function (key, value) {\n                this.options.values[key] = value;\n            }, this));\n        },\n\n        /**\n         * Override default options values with values based on each element's attribute\n         * identifier.\n         * @private\n         */\n        _setValuesByAttribute: function () {\n            this.options.values = {};\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                var attributeId;\n\n                if (element.value) {\n                    attributeId = element.id.replace(/[a-z]*/, '');\n                    this.options.values[attributeId] = element.value;\n                }\n            }, this));\n        },\n\n        /**\n         * Set up .on('change') events for each option element to configure the option.\n         * @private\n         */\n        _setupChangeEvents: function () {\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                $(element).on('change', this, this._configure);\n            }, this));\n        },\n\n        /**\n         * Iterate through the option settings and set each option's element configuration,\n         * attribute identifier. Set the state based on the attribute identifier.\n         * @private\n         */\n        _fillState: function () {\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.options.spConfig.attributes[attributeId]) {\n                    element.config = this.options.spConfig.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.options.state[attributeId] = false;\n                }\n            }, this));\n        },\n\n        /**\n         * Set each option's child settings, and next/prev option setting. Fill (initialize)\n         * an option's list of selections as needed or disable an option's setting.\n         * @private\n         */\n        _setChildSettings: function () {\n            var childSettings = [],\n                settings = this.options.settings,\n                index = settings.length,\n                option;\n\n            while (index--) {\n                option = settings[index];\n\n                if (index) {\n                    option.disabled = true;\n                } else {\n                    this._fillSelect(option);\n                }\n\n                _.extend(option, {\n                    childSettings: childSettings.slice(),\n                    prevSetting: settings[index - 1],\n                    nextSetting: settings[index + 1]\n                });\n\n                childSettings.push(option);\n            }\n        },\n\n        /**\n         * Setup for all configurable option settings. Set the value of the option and configure\n         * the option, which sets its state, and initializes the option's choices, etc.\n         * @private\n         */\n        _configureForValues: function () {\n            if (this.options.values) {\n                this.options.settings.each($.proxy(function (index, element) {\n                    var attributeId = element.attributeId;\n                    element.value = this.options.values[attributeId] || '';\n                    this._configureElement(element);\n                }, this));\n            }\n        },\n\n        /**\n         * Event handler for configuring an option.\n         * @private\n         * @param {Object} event - Event triggered to configure an option.\n         */\n        _configure: function (event) {\n            event.data._configureElement(this);\n        },\n\n        /**\n         * Configure an option, initializing it's state and enabling related options, which\n         * populates the related option's selection and resets child option selections.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _configureElement: function (element) {\n            this.simpleProduct = this._getSimpleProductId(element);\n\n            if (element.value) {\n                this.options.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this._fillSelect(element.nextSetting);\n                    this._resetChildren(element.nextSetting);\n                } else {\n                    if (!!document.documentMode) {\n                        this.inputSimpleProduct.val(element.options[element.selectedIndex].config.allowedProducts[0]);\n                    } else {\n                        this.inputSimpleProduct.val(element.selectedOptions[0].config.allowedProducts[0]);\n                    }\n                }\n            } else {\n                this._resetChildren(element);\n            }\n            this._reloadPrice();\n            this._changeProductImage();\n        },\n\n        /**\n         * Change displayed product image according to chosen options of configurable product\n         * @private\n         */\n        _changeProductImage: function () {\n            var images,\n                initialImages = $.extend(true, [], this.options.mediaGalleryInitial),\n                galleryObject = $(this.options.mediaGallerySelector).data('gallery');\n\n            if (this.options.spConfig.images[this.simpleProduct]) {\n                images = $.extend(true, [], this.options.spConfig.images[this.simpleProduct]);\n            }\n\n            function updateGallery(imagesArr) {\n                var imgToUpdate,\n                    mainImg;\n\n                mainImg = imagesArr.filter(function (img) {\n                    return img.isMain;\n                });\n\n                imgToUpdate = mainImg.length ? mainImg[0] : imagesArr[0];\n                galleryObject.updateDataByIndex(0, imgToUpdate);\n                galleryObject.seek(1);\n            }\n\n            if (galleryObject) {\n                if (images) {\n                    images.map(function (img) {\n                        img.type = 'image';\n                    });\n\n                    if (this.options.onlyMainImg) {\n                        updateGallery(images);\n                    } else {\n                        galleryObject.updateData(images)\n                    }\n                } else {\n                    if (this.options.onlyMainImg) {\n                        updateGallery(initialImages);\n                    } else {\n                        galleryObject.updateData(this.options.mediaGalleryInitial);\n                        $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n                    }\n                }\n            }\n        },\n\n        /**\n         * For a given option element, reset all of its selectable options. Clear any selected\n         * index, disable the option choice, and reset the option's state if necessary.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _resetChildren: function (element) {\n            if (element.childSettings) {\n                _.each(element.childSettings, function (set) {\n                    set.selectedIndex = 0;\n                    set.disabled = true;\n                });\n\n                if (element.config) {\n                    this.options.state[element.config.id] = false;\n                }\n            }\n        },\n\n        /**\n         * Populates an option's selectable choices.\n         * @private\n         * @param {*} element - Element associated with a configurable option.\n         */\n        _fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this._getAttributeOptions(attributeId),\n                prevConfig,\n                index = 1,\n                allowedProducts,\n                i,\n                j;\n\n            this._clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.options.spConfig.chooseText;\n            prevConfig = false;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (i = 0; i < options.length; i++) {\n                    allowedProducts = [];\n\n                    if (prevConfig) {\n                        for (j = 0; j < options[i].products.length; j++) {\n                            // prevConfig.config can be undefined\n                            if (prevConfig.config &&\n                                prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1) {\n                                allowedProducts.push(options[i].products[j]);\n                            }\n                        }\n                    } else {\n                        allowedProducts = options[i].products.slice(0);\n                    }\n\n                    if (allowedProducts.length > 0) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this._getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price !== 'undefined') {\n                            element.options[index].setAttribute('price', options[i].prices);\n                        }\n\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n                }\n            }\n        },\n\n        /**\n         * Generate the label associated with a configurable option. This includes the option's\n         * label or value and the option's price.\n         * @private\n         * @param {*} option - A single choice among a group of choices for a configurable option.\n         * @return {String} The option label with option value and price (e.g. Black +1.99)\n         */\n        _getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * Removes an option's selections.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * Retrieve the attribute options associated with a specific attribute Id.\n         * @private\n         * @param {Number} attributeId - The id of the attribute whose configurable options are sought.\n         * @return {Object} Object containing the attribute options.\n         */\n        _getAttributeOptions: function (attributeId) {\n            if (this.options.spConfig.attributes[attributeId]) {\n                return this.options.spConfig.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload the price of the configurable product incorporating the prices of all of the\n         * configurable product's option selections.\n         */\n        _reloadPrice: function () {\n            $(this.options.priceHolderSelector).trigger('updatePrice', this._getPrices());\n        },\n\n        /**\n         * Get product various prices\n         * @returns {{}}\n         * @private\n         */\n        _getPrices: function () {\n            var prices = {},\n                elements = _.toArray(this.options.settings),\n                hasProductPrice = false;\n\n            _.each(elements, function (element) {\n                var selected = element.options[element.selectedIndex],\n                    config = selected && selected.config,\n                    priceValue = {};\n\n                if (config && config.allowedProducts.length === 1 && !hasProductPrice) {\n                    priceValue = this._calculatePrice(config);\n                    hasProductPrice = true;\n                }\n\n                prices[element.attributeId] = priceValue;\n            }, this);\n\n            return prices;\n        },\n\n        /**\n         * Returns pracies for configured products\n         *\n         * @param {*} config - Products configuration\n         * @returns {*}\n         * @private\n         */\n        _calculatePrice: function (config) {\n            var displayPrices = $(this.options.priceHolderSelector).priceBox('option').prices,\n                newPrices = this.options.spConfig.optionPrices[_.first(config.allowedProducts)];\n\n            _.each(displayPrices, function (price, code) {\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Returns Simple product Id\n         *  depending on current selected option.\n         *\n         * @private\n         * @param {HTMLElement} element\n         * @returns {String|undefined}\n         */\n        _getSimpleProductId: function (element) {\n            // TODO: Rewrite algorithm. It should return ID of\n            //        simple product based on selected options.\n            var allOptions = element.config.options,\n                value = element.value,\n                config;\n\n            config = _.filter(allOptions, function (option) {\n                return option.id === value;\n            });\n            config = _.first(config);\n\n            return _.isEmpty(config) ?\n                undefined :\n                _.first(config.allowedProducts);\n\n        }\n\n    });\n\n    return $.mage.configurable;\n});\n","Magento_Wishlist/wishlist.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true sub:true*/\n/*global alert*/\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/validation/validation',\n\n    'mage/dataPost'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.wishlist', {\n        options: {\n            dataAttribute: 'item-id',\n            nameFormat: 'qty[{0}]',\n            btnRemoveSelector: '[data-role=remove]',\n            qtySelector: '[data-role=qty]',\n            addToCartSelector: '[data-role=tocart]',\n            addAllToCartSelector: '[data-role=all-tocart]',\n            commentInputType: 'textarea',\n            infoList: false\n        },\n\n        /**\n         * Bind handlers to events.\n         */\n        _create: function () {\n            var _this = this;\n            if (!this.options.infoList) {\n                this.element\n                    .on('addToCart', function (event, context) {\n                        event.stopPropagation(event);\n                        $(context).data('stop-processing', true);\n                        var urlParams = _this._getItemsToCartParams(\n                            $(context).parents('[data-row=product-item]').find(_this.options.addToCartSelector)\n                        );\n                        $.mage.dataPost().postData(urlParams);\n                        return false;\n                    })\n                    .on('click', this.options.btnRemoveSelector, $.proxy(function (event) {\n                        event.preventDefault();\n                        $.mage.dataPost().postData($(event.currentTarget).data('post-remove'));\n                    }, this))\n                    .on('click', this.options.addAllToCartSelector, $.proxy(this._addAllWItemsToCart, this))\n                    .on('focusin focusout', this.options.commentInputType, $.proxy(this._focusComment, this));\n            }\n\n            // Setup validation for the form\n            this.element.mage('validation', {\n                errorPlacement: function (error, element) {\n                    error.insertAfter(element.next());\n                }\n            });\n        },\n\n        /**\n         * Add wish list items to cart.\n         * @private\n         * @param {jQuery object} elem - clicked 'add to cart' button\n         */\n        _getItemsToCartParams: function (elem) {\n            if (elem.data(this.options.dataAttribute)) {\n                var itemId = elem.data(this.options.dataAttribute),\n                    url = this.options.addToCartUrl,\n                    qtyName = $.validator.format(this.options.nameFormat, itemId),\n                    qtyValue = elem.parents().find('[name=\"' + qtyName + '\"]').val();\n                url.data.item = itemId;\n                url.data.qty = qtyValue;\n                return url;\n            }\n        },\n\n        /**\n         * Add all wish list items to cart\n         * @private\n         */\n        _addAllWItemsToCart: function () {\n            var urlParams = this.options.addAllToCartUrl,\n                separator = (urlParams.action.indexOf('?') >= 0) ? '&' : '?';\n\n            this.element.find(this.options.qtySelector).each(function (index, element) {\n                urlParams.action += separator + $(element).prop('name') + '=' + encodeURIComponent($(element).val());\n                separator = '&';\n            });\n            $.mage.dataPost().postData(urlParams);\n        },\n\n        /**\n         * Toggle comment string.\n         * @private\n         * @param {Event} e\n         */\n        _focusComment: function (e) {\n            var commentInput = e.currentTarget;\n\n            if (commentInput.value === '' || commentInput.value === this.options.commentString) {\n                commentInput.value = commentInput.value === this.options.commentString ?\n                    '' : this.options.commentString;\n            }\n        }\n    });\n\n    // Extension for mage.wishlist - Select All checkbox\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            selectAllCheckbox: '#select-all',\n            parentContainer: '#wishlist-table'\n        },\n\n        _create: function () {\n            this._super();\n            var selectAllCheckboxParent = $(this.options.selectAllCheckbox).parents(this.options.parentContainer),\n                checkboxCount = selectAllCheckboxParent.find('input:checkbox:not(' + this.options.selectAllCheckbox + ')').length;\n            // If Select all checkbox is checked, check all item checkboxes, if unchecked, uncheck all item checkboxes\n            $(this.options.selectAllCheckbox).on('click', function () {\n                selectAllCheckboxParent.find('input:checkbox').attr('checked', $(this).is(':checked'));\n            });\n            // If all item checkboxes are checked, check select all checkbox,\n            // if not all item checkboxes are checked, uncheck select all checkbox\n            selectAllCheckboxParent.on('click', 'input:checkbox:not(' + this.options.selectAllCheckbox + ')', $.proxy(function () {\n                var checkedCount = selectAllCheckboxParent.find('input:checkbox:checked:not(' + this.options.selectAllCheckbox + ')').length;\n                $(this.options.selectAllCheckbox).attr('checked', checkboxCount === checkedCount);\n            }, this));\n        }\n    });\n    // Extension for mage.wishlist info add to cart\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        _create: function () {\n            this._super();\n\n            if (this.options.infoList) {\n                this.element.on('addToCart', $.proxy(function (event, context) {\n                    this.element.find('input:checkbox').attr('checked', false);\n                    $(context).closest('tr').find('input:checkbox').attr('checked', true);\n                    this.element.submit();\n                }, this));\n                this._checkBoxValidate();\n            }\n        },\n\n        /**\n         * validate checkbox selection.\n         * @private\n         */\n        _checkBoxValidate: function () {\n            this.element.validation({\n                submitHandler: $.proxy(function (form) {\n                    if ($(form).find('input:checkbox:checked').length) {\n                        form.submit();\n                    } else {\n                        alert({\n                            content: this.options.checkBoxValidationMessage\n                        });\n                    }\n                }, this)\n            });\n        }\n    });\n\n    // Extension for mage.wishlist - Add Wishlist item to Gift Registry\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            formTmplSelector: '#form-tmpl',\n            formTmplId: '#wishlist-hidden-form'\n        },\n\n        _create: function () {\n            this._super();\n            var _this = this;\n            this.element.on('click', '[data-wishlist-to-giftregistry]', function () {\n                var json = $(this).data('wishlist-to-giftregistry'),\n                    tmplJson = {\n                        item: json.itemId,\n                        entity: json.entity,\n                        url: json.url\n                    },\n                    html = mageTemplate(_this.options.formTmplSelector, {\n                        data: tmplJson\n                    });\n\n                $(html).appendTo('body');\n                $(_this.options.formTmplId).submit();\n            });\n        }\n    });\n\n    return $.mage.wishlist;\n});\n","Magento_Wishlist/js/add-to-wishlist.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.addToWishlist', {\n        options: {\n            bundleInfo: 'div.control [name^=bundle_option]',\n            configurableInfo: '.super-attribute-select',\n            groupedInfo: '#super-product-table input',\n            downloadableInfo: '#downloadable-links-list input',\n            customOptionsInfo: '.product-custom-option',\n            qtyInfo: '#qty'\n        },\n        _create: function () {\n            this._bind();\n        },\n        _bind: function() {\n            var options = this.options,\n                dataUpdateFunc = '_updateWishlistData',\n                changeCustomOption = 'change ' + options.customOptionsInfo,\n                changeQty = 'change ' + options.qtyInfo,\n                events = {};\n\n            if ('productType' in options) {\n                if (typeof options.productType === 'string') {\n                    options.productType = [options.productType];\n                }\n            } else {\n                options.productType = [];\n            }\n\n            events[changeCustomOption] = dataUpdateFunc;\n            events[changeQty] = dataUpdateFunc;\n\n            for (var key in options.productType) {\n                if (options.productType.hasOwnProperty(key) && options.productType[key] + 'Info' in options) {\n                    events['change ' + options[options.productType[key] + 'Info']] = dataUpdateFunc;\n                }\n            }\n            this._on(events);\n        },\n        _updateWishlistData: function(event) {\n            var dataToAdd = {},\n                isFileUploaded = false;\n            if (event.handleObj.selector == this.options.qtyInfo) {\n                this._updateAddToWishlistButton({});\n                event.stopPropagation();\n                return;\n            }\n            var self = this;\n            $(event.handleObj.selector).each(function(index, element){\n                if ($(element).is('input[type=text]')\n                    || $(element).is('input[type=email]')\n                    || $(element).is('input[type=number]')\n                    || $(element).is('input[type=hidden]')\n                    || $(element).is('input[type=checkbox]:checked')\n                    || $(element).is('input[type=radio]:checked')\n                    || $(element).is('textarea')\n                    || $('#' + element.id + ' option:selected').length\n                ) {\n                    dataToAdd = $.extend({}, dataToAdd, self._getElementData(element));\n                    return;\n                }\n                if ($(element).is('input[type=file]') && $(element).val()) {\n                    isFileUploaded = true;\n                }\n            });\n            if (isFileUploaded) {\n                this.bindFormSubmit();\n            }\n            this._updateAddToWishlistButton(dataToAdd);\n            event.stopPropagation();\n        },\n        _updateAddToWishlistButton: function(dataToAdd) {\n            var self = this;\n            $('[data-action=\"add-to-wishlist\"]').each(function(index, element) {\n                var params = $(element).data('post');\n                if (!params)\n                    params = {'data': {}};\n\n                if (!$.isEmptyObject(dataToAdd)) {\n                    self._removeExcessiveData(params, dataToAdd);\n                }\n\n                params.data = $.extend({}, params.data, dataToAdd, {'qty': $(self.options.qtyInfo).val()});\n                $(element).data('post', params);\n            });\n        },\n        _arrayDiffByKeys: function(array1, array2) {\n            var result = {};\n            $.each(array1, function(key, value) {\n                if (key.indexOf('option') === -1) {\n                    return;\n                }\n                if (!array2[key])\n                    result[key] = value;\n            });\n            return result;\n        },\n        _getElementData: function(element) {\n            element = $(element);\n            var data = {},\n                elementName = element.data('selector') ? element.data('selector') : element.attr('name'),\n                elementValue = element.val();\n            if (element.is('select[multiple]') && elementValue !== null) {\n                if (elementName.substr(elementName.length - 2) == '[]') {\n                    elementName = elementName.substring(0, elementName.length - 2);\n                }\n                $.each(elementValue, function (key, option) {\n                    data[elementName + '[' + option + ']'] = option;\n                });\n            } else {\n                if (elementValue) {\n                    if (elementName.substr(elementName.length - 2) == '[]') {\n                        elementName = elementName.substring(0, elementName.length - 2);\n                        if (elementValue) {\n                            data[elementName + '[' + elementValue + ']'] = elementValue;\n                        }\n                    } else {\n                        data[elementName] = elementValue;\n                    }\n                }\n            }\n            return data;\n        },\n        _removeExcessiveData: function(params, dataToAdd) {\n            var dataToRemove = this._arrayDiffByKeys(params.data, dataToAdd);\n            $.each(dataToRemove, function(key, value) {\n                delete params.data[key];\n            });\n        },\n        bindFormSubmit: function() {\n            var self = this;\n            $('[data-action=\"add-to-wishlist\"]').on('click', function(event) {\n                event.stopPropagation();\n                event.preventDefault();\n\n                var element = $('input[type=file]' + self.options.customOptionsInfo),\n                    params = $(event.currentTarget).data('post'),\n                    form = $(element).closest('form'),\n                    action = params.action;\n                if (params.data.id) {\n                    $('<input>', {\n                        type: 'hidden',\n                        name: 'id',\n                        value: params.data.id\n                    }).appendTo(form);\n                }\n                if (params.data.uenc) {\n                    action += 'uenc/' + params.data.uenc;\n                }\n\n                $(form).attr('action', action).submit();\n            });\n        }\n    });\n    \n    return $.mage.addToWishlist;\n});\n","Magento_Wishlist/js/search.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.wishlistSearch', {\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function() {\n            this.element.on('change', $.proxy(this._toggleForm, this));\n        },\n\n        /**\n         * Toggle Form\n         * @private\n         */\n        _toggleForm: function() {\n            switch (this.element.val()) {\n                case 'name':\n                    $(this.options.emailFormSelector).hide();\n                    $(this.options.nameFormSelector).show();\n                    break;\n                case 'email':\n                    $(this.options.nameFormSelector).hide();\n                    $(this.options.emailFormSelector).show();\n                    break;\n                default:\n                    $(this.options.emailFormSelector).add(this.options.nameFormSelector).hide();\n            }\n        }\n    });\n\n    return $.mage.wishlistSearch;\n});","Magento_Vault/js/customer_account/deleteWidget.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modalToggle',\n    'mage/translate'\n], function ($, modalToggle) {\n    'use strict';\n\n    return function (config, deleteButton) {\n        config.buttons = [\n            {\n                text: $.mage.__('Cancel'),\n                class: 'action secondary cancel'\n            }, {\n                text: $.mage.__('Delete'),\n                class: 'action primary',\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) { //eslint-disable-line no-unused-vars\n                    deleteButton.form.submit();\n                }\n            }\n        ];\n\n        modalToggle(config, deleteButton);\n    };\n});\n","Magento_Vault/js/view/payment/vault-enabler.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiElement'\n    ],\n    function (\n        Component\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                isActivePaymentTokenEnabler: true\n            },\n\n            /**\n             * @param {String} paymentCode\n             */\n            setPaymentCode: function (paymentCode) {\n                this.paymentCode = paymentCode;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'isActivePaymentTokenEnabler'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * @param {Object} data\n             */\n            visitAdditionalData: function (data) {\n                if (!this.isVaultEnabled()) {\n                    return;\n                }\n\n                if (!('additional_data' in data)) {\n                    data['additional_data'] = {};\n                }\n\n                data['additional_data']['is_active_payment_token_enabler'] = this.isActivePaymentTokenEnabler();\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isVaultEnabled: function () {\n                return typeof window.checkoutConfig.vault[this.paymentCode] !== 'undefined' &&\n                    window.checkoutConfig.vault[this.paymentCode]['is_enabled'] === true;\n            }\n        });\n    }\n);\n","Magento_Vault/js/view/payment/vault.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        _,\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        _.each(window.checkoutConfig.payment.vault, function (config, index) {\n            rendererList.push(\n                {\n                    type: index,\n                    config: config.config,\n                    component: config.component,\n\n                    /**\n                     * Custom payment method types comparator\n                     * @param {String} typeA\n                     * @param {String} typeB\n                     * @return {Boolean}\n                     */\n                    typeComparatorCallback: function (typeA, typeB) {\n                        return typeA.indexOf(typeB) === 0;\n                    }\n                }\n            );\n        });\n\n        /**\n         * Add view logic here if needed\n         */\n        return Component.extend({});\n    }\n);\n","Magento_Vault/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/checkout-data'\n    ],\n    function (Component, selectPaymentMethod, checkoutData) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Vault/payment/form'\n            },\n\n            /**\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([]);\n\n                return this;\n            },\n\n            /**\n             * @returns\n             */\n            selectPaymentMethod: function () {\n                selectPaymentMethod(\n                    {\n                        method: this.getId()\n                    }\n                );\n                checkoutData.setSelectedPaymentMethod(this.getId());\n\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTitle: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getToken: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getId: function () {\n                return this.index;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Get last 4 digits of card\n             * @returns {String}\n             */\n            getMaskedCard: function () {\n                return '';\n            },\n\n            /**\n             * Get expiration date\n             * @returns {String}\n             */\n            getExpirationDate: function () {\n                return '';\n            },\n\n            /**\n             * Get card type\n             * @returns {String}\n             */\n            getCardType: function () {\n                return '';\n            },\n\n            /**\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * @returns {*}\n             */\n            getData: function () {\n                var data = {\n                    method: this.getCode()\n                };\n\n                data['additional_data'] = {};\n                data['additional_data']['public_hash'] = this.getToken();\n\n                return data;\n            }\n        });\n    }\n);\n","Magento_SalesRule/js/form/element/coupon-type.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function (_, uiRegistry, select) {\n    'use strict';\n\n    return select.extend({\n\n        /**\n         * Hide fields on coupon tab\n         */\n        onUpdate: function () {\n\n            /* eslint-disable eqeqeq */\n            if (this.value() != this.displayOnlyForCouponType) {\n                uiRegistry.get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation').checked(false);\n            }\n\n            this.enableDisableFields();\n        },\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/manage-coupon-codes.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, uiRegistry, fieldset, async) {\n    'use strict';\n\n    return fieldset.extend({\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Initialize element\n         *\n         * @returns {Abstract} Chainable\n         */\n        initialize: function (elems, position) {\n            var obj = this;\n\n            this._super();\n\n            async.async('#sales-rule-form-tab-coupons', document.getElementById('container'), function (node) {\n                var useAutoGeneration = uiRegistry.get(\n                    'sales_rule_form.sales_rule_form.rule_information.use_auto_generation'\n                );\n\n                useAutoGeneration.on('checked', function () {\n                    obj.enableDisableFields();\n                });\n                obj.enableDisableFields();\n            });\n\n            return this;\n        },\n\n        /*eslint-enable no-unused-vars*/\n        /*eslint-disable lines-around-comment*/\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            /**\n             * \\Magento\\Rule\\Model\\AbstractModel::COUPON_TYPE_AUTO\n             */\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/action/cancel-coupon.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\n/*global define,alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/resource-url-manager',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_SalesRule/js/model/payment/discount-messages',\n        'mage/storage',\n        'Magento_Checkout/js/action/get-payment-information',\n        'Magento_Checkout/js/model/totals',\n        'mage/translate'\n    ],\n    function ($, quote, urlManager, errorProcessor, messageContainer, storage, getPaymentInformationAction, totals, $t) {\n        'use strict';\n\n        return function (isApplied, isLoading) {\n            var quoteId = quote.getQuoteId(),\n                url = urlManager.getCancelCouponUrl(quoteId),\n                message = $t('Your coupon was successfully removed.');\n            messageContainer.clear();\n\n            return storage.delete(\n                url,\n                false\n            ).done(\n                function () {\n                    var deferred = $.Deferred();\n                    totals.isLoading(true);\n                    getPaymentInformationAction(deferred);\n                    $.when(deferred).done(function () {\n                        isApplied(false);\n                        totals.isLoading(false);\n                    });\n                    messageContainer.addSuccessMessage({\n                        'message': message\n                    });\n                }\n            ).fail(\n                function (response) {\n                    totals.isLoading(false);\n                    errorProcessor.process(response, messageContainer);\n                }\n            ).always(\n                function () {\n                    isLoading(false);\n                }\n            );\n        };\n    }\n);\n","Magento_SalesRule/js/action/set-coupon-code.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\n/*global define,alert*/\ndefine(\n    [\n        'ko',\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/resource-url-manager',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_SalesRule/js/model/payment/discount-messages',\n        'mage/storage',\n        'mage/translate',\n        'Magento_Checkout/js/action/get-payment-information',\n        'Magento_Checkout/js/model/totals'\n    ],\n    function (\n        ko,\n        $,\n        quote,\n        urlManager,\n        errorProcessor,\n        messageContainer,\n        storage,\n        $t,\n        getPaymentInformationAction,\n        totals\n    ) {\n        'use strict';\n        return function (couponCode, isApplied, isLoading) {\n            var quoteId = quote.getQuoteId();\n            var url = urlManager.getApplyCouponUrl(couponCode, quoteId);\n            var message = $t('Your coupon was successfully applied.');\n            return storage.put(\n                url,\n                {},\n                false\n            ).done(\n                function (response) {\n                    if (response) {\n                        var deferred = $.Deferred();\n                        isLoading(false);\n                        isApplied(true);\n                        totals.isLoading(true);\n                        getPaymentInformationAction(deferred);\n                        $.when(deferred).done(function () {\n                            totals.isLoading(false);\n                        });\n                        messageContainer.addSuccessMessage({'message': message});\n                    }\n                }\n            ).fail(\n                function (response) {\n                    isLoading(false);\n                    totals.isLoading(false);\n                    errorProcessor.process(response, messageContainer);\n                }\n            );\n        };\n    }\n);\n","Magento_SalesRule/js/model/payment/discount-messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Ui/js/model/messages'\n    ],\n    function (Messages) {\n        'use strict';\n\n        return new Messages();\n    }\n);\n","Magento_SalesRule/js/view/cart/totals/discount.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_SalesRule/js/view/summary/discount'\n    ],\n    function (Component) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_SalesRule/cart/totals/discount'\n            },\n            /**\n             * @override\n             *\n             * @returns {boolean}\n             */\n            isDisplayed: function () {\n                return this.getPureValue() != 0;\n            }\n        });\n    }\n);\n","Magento_SalesRule/js/view/payment/discount-messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/view/messages',\n    '../../model/payment/discount-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n\n\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_SalesRule/js/view/payment/discount.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'ko',\n        'uiComponent',\n        'Magento_Checkout/js/model/quote',\n        'Magento_SalesRule/js/action/set-coupon-code',\n        'Magento_SalesRule/js/action/cancel-coupon'\n    ],\n    function ($, ko, Component, quote, setCouponCodeAction, cancelCouponAction) {\n        'use strict';\n        var totals = quote.getTotals();\n        var couponCode = ko.observable(null);\n        if (totals()) {\n            couponCode(totals()['coupon_code']);\n        }\n        var isApplied = ko.observable(couponCode() != null);\n        var isLoading = ko.observable(false);\n        return Component.extend({\n            defaults: {\n                template: 'Magento_SalesRule/payment/discount'\n            },\n            couponCode: couponCode,\n            /**\n             * Applied flag\n             */\n            isApplied: isApplied,\n            isLoading: isLoading,\n            /**\n             * Coupon code application procedure\n             */\n            apply: function() {\n                if (this.validate()) {\n                    isLoading(true);\n                    setCouponCodeAction(couponCode(), isApplied, isLoading);\n                }\n            },\n            /**\n             * Cancel using coupon\n             */\n            cancel: function() {\n                if (this.validate()) {\n                    isLoading(true);\n                    couponCode('');\n                    cancelCouponAction(isApplied, isLoading);\n                }\n            },\n            /**\n             * Coupon form validation\n             *\n             * @returns {boolean}\n             */\n            validate: function() {\n                var form = '#discount-form';\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","Magento_SalesRule/js/view/summary/discount.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_SalesRule/summary/discount'\n            },\n            totals: quote.getTotals(),\n            isDisplayed: function() {\n                return this.isFullMode() && this.getPureValue() != 0;\n            },\n            getCouponCode: function() {\n                if (!this.totals()) {\n                    return null;\n                }\n                return this.totals()['coupon_code'];\n            },\n            getPureValue: function() {\n                var price = 0;\n                if (this.totals() && this.totals().discount_amount) {\n                    price = parseFloat(this.totals().discount_amount);\n                }\n                return price;\n            },\n            getValue: function() {\n                return this.getFormattedPrice(this.getPureValue());\n            }\n        });\n    }\n);\n","Magento_Cookie/js/notices.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"mage/cookies\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.cookieNotices', {\n        _create: function() {\n            if ($.mage.cookies.get(this.options.cookieName)) {\n                this.element.hide();\n            } else {\n                this.element.show();\n            }\n            $(this.options.cookieAllowButtonSelector).on('click', $.proxy(function() {\n                var cookieExpires = new Date(new Date().getTime() + this.options.cookieLifetime * 1000);\n\n                $.mage.cookies.set(this.options.cookieName, this.options.cookieValue, {expires: cookieExpires});\n                if ($.mage.cookies.get(this.options.cookieName)) {\n                    window.location.reload();\n                } else {\n                    window.location.href = this.options.noCookiesUrl;\n                }\n            }, this));\n        }\n    });\n\n    return $.mage.cookieNotices;\n});\n","Magento_Cookie/js/require-cookie.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint evil:true browser:true jquery:true */\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.requireCookie', {\n        options: {\n            event: 'click',\n            noCookieUrl: 'enable-cookies',\n            triggers: ['.action.login', '.action.submit']\n        },\n\n        /**\n         * Constructor\n         * @private\n         */\n        _create: function() {\n            this._bind();\n        },\n\n        /**\n         * This method binds elements found in this widget.\n         * @private\n         */\n        _bind: function() {\n            var events = {};\n\n            $.each(this.options.triggers, function(index, value) {\n                events['click ' + value] = '_checkCookie';\n            });\n            this._on(events);\n        },\n\n        /**\n         * This method set the url for the redirect.\n         * @private\n         */\n        _checkCookie: function(event) {\n            if (navigator.cookieEnabled) {\n                return;\n            }\n            event.preventDefault();\n            window.location = this.options.noCookieUrl;\n        }\n    });\n\n    return $.mage.requireCookie;\n});\n","Magento_Search/form-mini.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    \"matchMedia\",\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, mageTemplate, mediaCheck) {\n    'use strict';\n\n    /**\n     * Check wether the incoming string is not empty or if doesn't consist of spaces.\n     *\n     * @param {String} value - Value to check.\n     * @returns {Boolean}\n     */\n    function isEmpty(value) {\n        return (value.length === 0) || (value == null) || /^\\s+$/.test(value);\n    }\n\n    $.widget('mage.quickSearch', {\n        options: {\n            autocomplete: 'off',\n            minSearchLength: 2,\n            responseFieldElements: 'ul li',\n            selectClass: 'selected',\n            template:\n                '<li class=\"<%- data.row_class %>\" id=\"qs-option-<%- data.index %>\" role=\"option\">' +\n                    '<span class=\"qs-option-name\">' +\n                       ' <%- data.title %>' +\n                    '</span>' +\n                    '<span aria-hidden=\"true\" class=\"amount\">' +\n                        '<%- data.num_results %>' +\n                    '</span>' +\n                '</li>',\n            submitBtn: 'button[type=\"submit\"]',\n            searchLabel: '[data-role=minisearch-label]',\n            isExpandable: null\n        },\n\n        _create: function () {\n            this.responseList = {\n                indexList: null,\n                selected: null\n            };\n            this.autoComplete = $(this.options.destinationSelector);\n            this.searchForm = $(this.options.formSelector);\n            this.submitBtn = this.searchForm.find(this.options.submitBtn)[0];\n            this.searchLabel = $(this.options.searchLabel);\n            this.isExpandable = this.options.isExpandable;\n\n            _.bindAll(this, '_onKeyDown', '_onPropertyChange', '_onSubmit');\n\n            this.submitBtn.disabled = true;\n\n            this.element.attr('autocomplete', this.options.autocomplete);\n\n            mediaCheck({\n                media: '(max-width: 768px)',\n                entry: function () {\n                    this.isExpandable = true;\n                }.bind(this),\n                exit: function () {\n                    this.isExpandable = false;\n                    this.element.removeAttr('aria-expanded');\n                }.bind(this)\n            });\n\n            this.searchLabel.on('click', function (e) {\n                // allow input to lose its' focus when clicking on label\n                if (this.isExpandable && this.isActive()) {\n                    e.preventDefault();\n                }\n            }.bind(this));\n\n            this.element.on('blur', $.proxy(function () {\n\n                setTimeout($.proxy(function () {\n                    if (this.autoComplete.is(':hidden')) {\n                        this.setActiveState(false);\n                    }\n                    this.autoComplete.hide();\n                    this._updateAriaHasPopup(false);\n                }, this), 250);\n            }, this));\n\n            this.element.trigger('blur');\n\n            this.element.on('focus', this.setActiveState.bind(this, true));\n            this.element.on('keydown', this._onKeyDown);\n            this.element.on('input propertychange', this._onPropertyChange);\n\n            this.searchForm.on('submit', $.proxy(function() {\n                this._onSubmit();\n                this._updateAriaHasPopup(false);\n            }, this));\n        },\n\n        /**\n         * Checks if search field is active.\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            return this.searchLabel.hasClass('active');\n        },\n\n        /**\n         * Sets state of the search field to provided value.\n         *\n         * @param {Boolean} isActive\n         */\n        setActiveState: function (isActive) {\n            this.searchLabel.toggleClass('active', isActive);\n\n            if (this.isExpandable) {\n                this.element.attr('aria-expanded', isActive);\n            }\n        },\n\n        /**\n         * @private\n         * @return {Element} The first element in the suggestion list.\n         */\n        _getFirstVisibleElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.first() : false;\n        },\n\n        /**\n         * @private\n         * @return {Element} The last element in the suggestion list.\n         */\n        _getLastElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.last() : false;\n        },\n\n        /**\n         * @private\n         * @param {Boolean} show Set attribute aria-haspopup to \"true/false\" for element.\n         */\n        _updateAriaHasPopup: function(show) {\n            if (show) {\n                this.element.attr('aria-haspopup', 'true');\n            } else {\n                this.element.attr('aria-haspopup', 'false');\n            }\n        },\n\n        /**\n         * Clears the item selected from the suggestion list and resets the suggestion list.\n         * @private\n         * @param {Boolean} all - Controls whether to clear the suggestion list.\n         */\n        _resetResponseList: function (all) {\n            this.responseList.selected = null;\n\n            if (all === true) {\n                this.responseList.indexList = null;\n            }\n        },\n\n        /**\n         * Executes when the search box is submitted. Sets the search input field to the\n         * value of the selected item.\n         * @private\n         * @param {Event} e - The submit event\n         */\n        _onSubmit: function (e) {\n            var value = this.element.val();\n\n            if (isEmpty(value)) {\n                e.preventDefault();\n            }\n\n            if (this.responseList.selected) {\n                this.element.val(this.responseList.selected.find('.qs-option-name').text());\n            }\n        },\n\n        /**\n         * Executes when keys are pressed in the search input field. Performs specific actions\n         * depending on which keys are pressed.\n         * @private\n         * @param {Event} e - The key down event\n         * @return {Boolean} Default return type for any unhandled keys\n         */\n        _onKeyDown: function (e) {\n            var keyCode = e.keyCode || e.which;\n\n            switch (keyCode) {\n                case $.ui.keyCode.HOME:\n                    this._getFirstVisibleElement().addClass(this.options.selectClass);\n                    this.responseList.selected = this._getFirstVisibleElement();\n                    break;\n                case $.ui.keyCode.END:\n                    this._getLastElement().addClass(this.options.selectClass);\n                    this.responseList.selected = this._getLastElement();\n                    break;\n                case $.ui.keyCode.ESCAPE:\n                    this._resetResponseList(true);\n                    this.autoComplete.hide();\n                    break;\n                case $.ui.keyCode.ENTER:\n                    this.searchForm.trigger('submit');\n                    break;\n                case $.ui.keyCode.DOWN:\n                    if (this.responseList.indexList) {\n                        if (!this.responseList.selected) {\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        }\n                        else if (!this._getLastElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected.removeClass(this.options.selectClass).next().addClass(this.options.selectClass);\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                    }\n                    break;\n                case $.ui.keyCode.UP:\n                    if (this.responseList.indexList !== null) {\n                        if (!this._getFirstVisibleElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected.removeClass(this.options.selectClass).prev().addClass(this.options.selectClass);\n\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getLastElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getLastElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                    }\n                    break;\n                default:\n                    return true;\n            }\n        },\n\n        /**\n         * Executes when the value of the search input field changes. Executes a GET request\n         * to populate a suggestion list based on entered text. Handles click (select), hover,\n         * and mouseout events on the populated suggestion list dropdown.\n         * @private\n         */\n        _onPropertyChange: function () {\n            var searchField = this.element,\n                clonePosition = {\n                    position: 'absolute',\n                    // Removed to fix display issues\n                    // left: searchField.offset().left,\n                    // top: searchField.offset().top + searchField.outerHeight(),\n                    width: searchField.outerWidth()\n                },\n                source = this.options.template,\n                template = mageTemplate(source),\n                dropdown = $('<ul role=\"listbox\"></ul>'),\n                value = this.element.val();\n\n            this.submitBtn.disabled = isEmpty(value);\n\n            if (value.length >= parseInt(this.options.minSearchLength, 10)) {\n                $.get(this.options.url, {q: value}, $.proxy(function (data) {\n                    $.each(data, function(index, element) {\n                        element.index = index;\n                        var html = template({\n                            data: element\n                        });\n                        dropdown.append(html);\n                    });\n                    this.responseList.indexList = this.autoComplete.html(dropdown)\n                        .css(clonePosition)\n                        .show()\n                        .find(this.options.responseFieldElements + ':visible');\n\n                    this._resetResponseList(false);\n                    this.element.removeAttr('aria-activedescendant');\n\n                    if (this.responseList.indexList.length) {\n                        this._updateAriaHasPopup(true);\n                    } else {\n                        this._updateAriaHasPopup(false);\n                    }\n\n                    this.responseList.indexList\n                        .on('click', function (e) {\n                            this.responseList.selected = $(e.currentTarget);\n                            this.searchForm.trigger('submit');\n                        }.bind(this))\n                        .on('mouseenter mouseleave', function (e) {\n                            this.responseList.indexList.removeClass(this.options.selectClass);\n                            $(e.target).addClass(this.options.selectClass);\n                            this.responseList.selected = $(e.target);\n                            this.element.attr('aria-activedescendant', $(e.target).attr('id'));\n                        }.bind(this))\n                        .on('mouseout', function (e) {\n                            if (!this._getLastElement() && this._getLastElement().hasClass(this.options.selectClass)) {\n                                $(e.target).removeClass(this.options.selectClass);\n                                this._resetResponseList(false);\n                            }\n                        }.bind(this));\n                }, this));\n            } else {\n                this._resetResponseList(true);\n                this.autoComplete.hide();\n                this._updateAriaHasPopup(false);\n                this.element.removeAttr('aria-activedescendant');\n            }\n        }\n    });\n\n    return $.mage.quickSearch;\n});\n","Magento_Paypal/order-review.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    \"jquery/ui\",\n    \"mage/translate\",\n    \"mage/mage\",\n    \"mage/validation\"\n], function($, alert){\n    \"use strict\";\n\n    $.widget('mage.orderReview', {\n        options: {\n            orderReviewSubmitSelector: '#review-button',\n            shippingSelector: '#shipping_method',\n            shippingSubmitFormSelector: null,\n            updateOrderSelector: '#update-order',\n            billingAsShippingSelector: '#billing\\\\:as_shipping',\n            updateContainerSelector: '#details-reload',\n            waitLoadingContainer: '#review-please-wait',\n            shippingMethodContainer: '#shipping-method-container',\n            agreementSelector: 'div.checkout-agreements input',\n            isAjax: false,\n            updateShippingMethodSubmitSelector: \"#update-shipping-method-submit\",\n            reviewSubmitSelector: \"#review-submit\",\n            shippingMethodUpdateUrl: null,\n            updateOrderSubmitUrl: null,\n            canEditShippingMethod: false\n        },\n\n        /**\n         * Widget instance properties\n         */\n        triggerPropertyChange: true,\n        isShippingSubmitForm: false,\n\n        _create: function () {\n            //change handler for ajaxEnabled\n            if (this.options.isAjax) {\n                this._submitOrder = this._ajaxSubmitOrder;\n            }\n\n            this.element.on('click', this.options.orderReviewSubmitSelector, $.proxy(this._submitOrder, this))\n                .on('click', this.options.billingAsShippingSelector, $.proxy(this._shippingTobilling, this))\n                .on('change', this.options.shippingSelector, $.proxy(this._submitUpdateOrder, this, this.options.updateOrderSubmitUrl, this.options.updateContainerSelector))\n                .find(this.options.updateOrderSelector).on('click', $.proxy(this._updateOrderHandler, this)).end()\n                .find(this.options.updateShippingMethodSubmitSelector).hide().end()\n                .find(this.options.reviewSubmitSelector).hide();\n            this._shippingTobilling();\n            if ($(this.options.shippingSubmitFormSelector).length && this.options.canEditShippingMethod) {\n                this.isShippingSubmitForm = true;\n                $(this.options.shippingSubmitFormSelector).find(this.options.updateShippingMethodSubmitSelector).hide().end()\n                    .on('change',\n                        this.options.shippingSelector, $.proxy(this._submitUpdateOrder, this, $(this.options.shippingSubmitFormSelector).prop('action'), this.options.updateContainerSelector));\n                this._updateOrderSubmit(!$(this.options.shippingSubmitFormSelector).find(this.options.shippingSelector).val());\n            } else {\n                var isDisable = (this.isShippingSubmitForm && this.element.find(this.options.shippingSelector).val());\n                this.element.on('input propertychange', \":input[name]\", $.proxy(this._updateOrderSubmit, this, isDisable, this._onShippingChange))\n                    .find('select').not(this.options.shippingSelector).on('change', this._propertyChange);\n                this._updateOrderSubmit(isDisable);\n            }\n        },\n\n        /**\n         * show ajax loader\n         */\n        _ajaxBeforeSend: function () {\n            this.element.find(this.options.waitLoadingContainer).show();\n        },\n\n        /**\n         * hide ajax loader\n         */\n        _ajaxComplete: function () {\n            this.element.find(this.options.waitLoadingContainer).hide();\n        },\n\n        /**\n         * trigger propertychange for input type select\n         */\n        _propertyChange: function () {\n            $(this).trigger('propertychange');\n        },\n\n        /**\n         * trigger change for the update of shippping methods from server\n         */\n        _updateOrderHandler: function () {\n            $(this.options.shippingSelector).trigger('change');\n        },\n\n        /**\n         * Attempt to submit order\n         */\n        _submitOrder: function () {\n            if (this._validateForm()) {\n                this.element.find(this.options.updateOrderSelector).fadeTo(0, 0.5)\n                    .end().find(this.options.waitLoadingContainer).show()\n                    .end().submit();\n                this._updateOrderSubmit(true);\n            }\n        },\n\n        /**\n         * Attempt to ajax submit order\n         */\n        _ajaxSubmitOrder: function () {\n            if (this.element.find(this.options.waitLoadingContainer).is(\":visible\")) {\n                return false;\n            }\n            $.ajax({\n                url: this.element.prop('action'),\n                type: 'post',\n                context: this,\n                data: {isAjax: 1},\n                dataType: 'json',\n                beforeSend: this._ajaxBeforeSend,\n                complete: this._ajaxComplete,\n                success: function (response) {\n                    if ($.type(response) === 'object' && !$.isEmptyObject(response)) {\n                        if (response.error_messages) {\n                            this._ajaxComplete();\n                            var msg = response.error_messages;\n                            if (msg) {\n                                if ($.type(msg) === 'array') {\n                                    msg = msg.join(\"\\n\");\n                                }\n                            }\n                            alert({\n                                content: $.mage.__(msg)\n                            });\n                            return false;\n                        }\n                        if (response.redirect) {\n                            $.mage.redirect(response.redirect);\n                            return false;\n                        }\n                        else if (response.success) {\n                            $.mage.redirect(this.options.successUrl);\n                            return false;\n                        }\n                        this._ajaxComplete();\n                        alert({\n                            content: $.mage.__('Sorry, something went wrong.')\n                        });\n                    }\n                },\n                error: function () {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    this._ajaxComplete();\n                }\n            });\n        },\n\n        /**\n         * Validate Order form\n         */\n        _validateForm: function () {\n            this.element.find(this.options.agreementSelector).off('change').on('change', $.proxy(function (e) {\n                var isValid = this._validateForm();\n                this._updateOrderSubmit(!isValid);\n            }, this));\n\n            if (this.element.data('mageValidation')) {\n                return this.element.validation().valid();\n            }\n            return true;\n        },\n\n        /**\n         * Check/Set whether order can be submitted\n         * Also disables form submission element, if any\n         * @param shouldDisable - whether should prevent order submission explicitly\n         * @param optional function for shipping change handler\n         * @param optional if true the property change will be set to true\n         */\n        _updateOrderSubmit: function (shouldDisable, fn) {\n            this._toggleButton(this.options.orderReviewSubmitSelector, shouldDisable);\n            if ($.type(fn) === 'function') {\n                fn.call(this);\n            }\n        },\n\n        /**\n         * Enable/Disable button\n         * @param button button selector to be toggled\n         * @param disable  boolean for toggling\n         */\n        _toggleButton: function (button, disable) {\n            $(button).prop({\"disabled\": disable}).toggleClass('no-checkout', disable).fadeTo(0, disable ? 0.5 : 1);\n        },\n\n        /**\n         * Copy element value from shipping to billing address\n         * @param e optional\n         */\n        _shippingTobilling: function (e) {\n            if (this.options.shippingSubmitFormSelector) {\n                return false;\n            }\n            var isChecked = $(this.options.billingAsShippingSelector).is(':checked'),\n                opacity = isChecked ? 0.5 : 1;\n            if (isChecked) {\n                this.element.validation(\"clearError\", ':input[name^=\"billing\"]');\n            }\n            $(':input[name^=\"shipping\"]', this.element).each($.proxy(function (key, value) {\n                var fieldObj = $(value.id.replace('shipping:', '#billing\\\\:'));\n                if (isChecked) {\n                    fieldObj = fieldObj.val($(value).val());\n                }\n                fieldObj.prop({\"readonly\": isChecked, \"disabled\": isChecked}).fadeTo(0, opacity);\n                if (fieldObj.is(\"select\")) {\n                    this.triggerPropertyChange = false;\n                    fieldObj.trigger('change');\n                }\n            }, this));\n            if (isChecked || e) {\n                this._updateOrderSubmit(true);\n            }\n            this.triggerPropertyChange = true;\n        },\n\n        /**\n         * Dispatch an ajax request of Update Order submission\n         * @param url - url where to submit shipping method\n         * @param resultId - id of element to be updated\n         */\n        _submitUpdateOrder: function (url, resultId) {\n            if (this.element.find(this.options.waitLoadingContainer).is(\":visible\")) {\n                return false;\n            }\n            var isChecked = $(this.options.billingAsShippingSelector).is(':checked'),\n                formData = null,\n                callBackResponseHandler = null,\n                shippingMethod = $.trim($(this.options.shippingSelector).val());\n            this._shippingTobilling();\n\n            if (url && resultId && shippingMethod) {\n                this._updateOrderSubmit(true);\n                this._toggleButton(this.options.updateOrderSelector, true);\n\n                // form data and callBack updated based on the shippping Form element\n                if (this.isShippingSubmitForm) {\n                    formData = $(this.options.shippingSubmitFormSelector).serialize() + \"&isAjax=true\";\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._updateOrderSubmit(false);\n                        this._ajaxComplete();\n                    };\n                } else {\n                    formData = this.element.serialize() + \"&isAjax=true\";\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._ajaxShippingUpdate(shippingMethod);\n                    };\n                }\n                if (isChecked) {\n                    $(this.options.shippingSelect).prop('disabled', true);\n                }\n                $.ajax({\n                    url: url,\n                    type: 'post',\n                    context: this,\n                    beforeSend: this._ajaxBeforeSend,\n                    data: formData,\n                    success: callBackResponseHandler\n                });\n            }\n        },\n\n        /**\n         * Update Shipping Methods Element from server\n         * @param shippingMethod\n         */\n        _ajaxShippingUpdate: function (shippingMethod) {\n            $.ajax({\n                    url: this.options.shippingMethodUpdateUrl,\n                    data: {isAjax: true, shipping_method: shippingMethod},\n                    type: 'post',\n                    context: this,\n                    success: function (response) {\n                        $(this.options.shippingMethodContainer).parent().html(response);\n                        this._toggleButton(this.options.updateOrderSelector, false);\n                        this._updateOrderSubmit(false);\n                    },\n                    complete: this._ajaxComplete\n                }\n            );\n        },\n\n        /**\n         * Actions on change Shipping Address data\n         */\n        _onShippingChange: function () {\n            if (this.triggerPropertyChange && $.trim($(this.options.shippingSelector).val())) {\n                this.element.find(this.options.shippingSelector).hide().end()\n                    .find(this.options.shippingSelector + '_update').show();\n            }\n        }\n    });\n    \n    return $.mage.orderReview;\n});\n","Magento_Paypal/js/paypal-checkout.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'jquery/ui',\n    'mage/mage'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.paypalCheckout', {\n        options: {\n            originalForm:\n                'form:not(#product_addtocart_form_from_popup):has(input[name=\"product\"][value=%1])',\n            productId: 'input[type=\"hidden\"][name=\"product\"]',\n            ppCheckoutSelector: '[data-role=pp-checkout-url]',\n            ppCheckoutInput: '<input type=\"hidden\" data-role=\"pp-checkout-url\" name=\"return_url\" value=\"\"/>'\n        },\n\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', '[data-action=\"checkout-form-submit\"]', $.proxy(function (e) {\n                var $target = $(e.target),\n                    returnUrl = $target.data('checkout-url'),\n                    productId = $target.closest('form').find(this.options.productId).val(),\n                    originalForm = this.options.originalForm.replace('%1', productId),\n                    self = this,\n                    billingAgreement = customerData.get('paypal-billing-agreement');\n\n                e.preventDefault();\n\n                if (billingAgreement().askToCreate) {\n                    confirm({\n                        content: billingAgreement().confirmMessage,\n                        actions: {\n\n                            /**\n                             * Confirmation handler\n                             *\n                             */\n                            confirm: function () {\n                                returnUrl = billingAgreement().confirmUrl;\n                                self._redirect(returnUrl, originalForm);\n                            },\n\n                            /**\n                             * Cancel confirmation handler\n                             *\n                             */\n                            cancel: function (event) {\n                                if (event && !$(event.target).hasClass('action-close')) {\n                                    self._redirect(returnUrl);\n                                }\n                            }\n                        }\n                    });\n                } else {\n                    this._redirect(returnUrl, originalForm);\n                }\n            }, this));\n        },\n\n        /**\n         * Redirect to certain url, with optional form\n         * @param {String} returnUrl\n         * @param {HTMLElement} originalForm\n         *\n         */\n        _redirect: function (returnUrl, originalForm) {\n            var $form,\n                ppCheckoutInput;\n\n            if (this.options.isCatalogProduct) {\n                // find the form from which the button was clicked\n                $form = originalForm ? $(originalForm) : $($(this.options.shortcutContainerClass).closest('form'));\n\n                ppCheckoutInput = $form.find(this.options.ppCheckoutSelector)[0];\n\n                if (!ppCheckoutInput) {\n                    ppCheckoutInput = $(this.options.ppCheckoutInput);\n                    ppCheckoutInput.appendTo($form);\n                }\n                $(ppCheckoutInput).val(returnUrl);\n\n                $form.submit();\n            } else {\n                $.mage.redirect(returnUrl);\n            }\n        }\n    });\n\n    return $.mage.paypalCheckout;\n});\n","Magento_Paypal/js/action/set-payment-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function ($, quote, urlBuilder, storage, errorProcessor, customer, fullScreenLoader) {\n        'use strict';\n\n        return function (messageContainer) {\n            var serviceUrl,\n                payload,\n                method = 'put',\n                paymentData = quote.paymentMethod();\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    email: quote.guestEmail,\n                    paymentMethod: paymentData\n                };\n                method = 'post';\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/selected-payment-method', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    method: paymentData\n                };\n            }\n            fullScreenLoader.startLoader();\n\n            return storage[method](\n                serviceUrl, JSON.stringify(payload)\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Paypal/js/in-context/billing-agreement.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.billingAgreement', {\n        options: {\n            invalidateOnLoad: false,\n            cancelButtonSelector: '.block-billing-agreements-view button.cancel',\n            cancelMessage: '',\n            cancelUrl: ''\n        },\n\n        /**\n         * Initialize billing agreements events\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            if (this.options.invalidateOnLoad) {\n                this.invalidate();\n            }\n            $(this.options.cancelButtonSelector).on('click', function () {\n                confirm({\n                    content: self.options.cancelMessage,\n                    actions: {\n                        /**\n                         * 'Confirm' action handler.\n                         */\n                        confirm: function () {\n                            self.invalidate();\n                            window.location.href = self.options.cancelUrl;\n                        }\n                    }\n                });\n\n                return false;\n            });\n        },\n\n        /**\n         * clear paypal billing agreement customer data\n         * @returns void\n         */\n        invalidate: function () {\n            customerData.invalidate(['paypal-billing-agreement']);\n        }\n    });\n\n    return $.mage.billingAgreement;\n});\n","Magento_Paypal/js/in-context/button.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'jquery',\n        'domReady!'\n    ],\n    function (\n        Component,\n        $\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {},\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                return this.initEvents();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initEvents: function () {\n                $('#' + this.id).off('click.' + this.id)\n                    .on('click.' + this.id, this.click.bind(this));\n\n                return this;\n            },\n\n            /**\n             * @param {Object} event\n             * @returns void\n             */\n            click: function (event) {\n                event.preventDefault();\n\n                $('#' + this.paypalButton).click();\n            }\n        });\n    }\n);\n","Magento_Paypal/js/in-context/express-checkout.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'uiComponent',\n        'paypalInContextExpressCheckout',\n        'Magento_Customer/js/customer-data',\n        'domReady!'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        paypalExpressCheckout,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                clientConfig: {\n\n                    /**\n                     * @param {Object} event\n                     */\n                    click: function (event) {\n                        $('body').trigger('processStart');\n\n                        event.preventDefault();\n\n                        paypalExpressCheckout.checkout.initXO();\n\n                        $.get(\n                            this.path,\n                            {\n                                button: 1\n                            }\n                        ).done(\n                            function (response) {\n                                if (response && response.url) {\n                                    paypalExpressCheckout.checkout.startFlow(response.url);\n\n                                    return;\n                                }\n\n                                paypalExpressCheckout.checkout.closeFlow();\n                            }\n                        ).fail(\n                            function () {\n                                $('body').trigger('processStop');\n                                paypalExpressCheckout.checkout.closeFlow();\n                            }\n                        ).always(\n                            function () {\n                                customerData.invalidate(['cart']);\n                            }\n                        );\n                    }\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                return this.initClient();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initClient: function () {\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n\n                paypalExpressCheckout.checkout.setup(this.merchantId, this.clientConfig);\n\n                return this;\n            }\n        });\n    }\n);\n","Magento_Paypal/js/model/iframe-redirect.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko',\n        'Magento_Paypal/js/model/iframe',\n        'Magento_Ui/js/model/messageList'\n    ],\n    function (ko, iframe, messageList) {\n        'use strict';\n\n        return function (cartUrl, errorMessage, goToSuccessPage, successUrl) {\n            if (this === window.self) {\n                window.location = cartUrl;\n            }\n\n            if (!!errorMessage.message) {\n                document.removeEventListener('click', iframe.stopEventPropagation, true);\n                iframe.isInAction(false);\n                messageList.addErrorMessage(errorMessage);\n            } else if (!!goToSuccessPage) {\n                window.location = successUrl;\n            } else {\n                window.location = cartUrl;\n            }\n        };\n    }\n);\n","Magento_Paypal/js/model/iframe.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko'\n    ],\n    function (ko) {\n        'use strict';\n\n        var isInAction = ko.observable(false);\n\n        return {\n            isInAction: isInAction,\n            stopEventPropagation: function (event) {\n                event.stopImmediatePropagation();\n                event.preventDefault();\n            }\n        };\n    }\n);\n","Magento_Paypal/js/view/payment/paypal-payments.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        var isContextCheckout = window.checkoutConfig.payment.paypalExpress.isContextCheckout,\n            paypalExpress = 'Magento_Paypal/js/view/payment/method-renderer' +\n                (isContextCheckout ? '/in-context/checkout-express' : '/paypal-express');\n\n        rendererList.push(\n            {\n                type: 'paypal_express',\n                component: paypalExpress,\n                config: window.checkoutConfig.payment.paypalExpress.inContextConfig\n            },\n            {\n                type: 'paypal_express_bml',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/paypal-express-bml'\n            },\n            {\n                type: 'payflow_express',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express'\n            },\n            {\n                type: 'payflow_express_bml',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml'\n            },\n            {\n                type: 'payflowpro',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method'\n            },\n            {\n                type: 'payflow_link',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n            },\n            {\n                type: 'payflow_advanced',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n            },\n            {\n                type: 'hosted_pro',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n            },\n            {\n                type: 'paypal_billing_agreement',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement'\n            }\n        );\n\n        /**\n         * Add view logic here if needed\n         **/\n        return Component.extend({});\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/iframe-methods.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'Magento_Paypal/js/model/iframe',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (Component, ko, iframe, fullScreenLoader) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/iframe-methods',\n                paymentReady: false\n            },\n            redirectAfterPlaceOrder: false,\n            isInAction: iframe.isInAction,\n\n            /**\n             * @return {exports}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe('paymentReady');\n\n                return this;\n            },\n\n            /**\n             * @return {*}\n             */\n            isPaymentReady: function () {\n                return this.paymentReady();\n            },\n\n            /**\n             * Get action url for payment method iframe.\n             * @returns {String}\n             */\n            getActionUrl: function () {\n                return this.isInAction() ? window.checkoutConfig.payment.paypalIframe.actionUrl[this.getCode()] : '';\n            },\n\n            /**\n             * Places order in pending payment status.\n             */\n            placePendingPaymentOrder: function () {\n                if (this.placeOrder()) {\n                    fullScreenLoader.startLoader();\n                    this.isInAction(true);\n                    // capture all click events\n                    document.addEventListener('click', iframe.stopEventPropagation, true);\n                }\n            },\n\n            getPlaceOrderDeferredObject: function () {\n                var self = this;\n                return this._super()\n                    .fail(\n                        function () {\n                            fullScreenLoader.stopLoader();\n                            self.isInAction(false);\n                            document.removeEventListener('click', iframe.stopEventPropagation, true);\n                        }\n                    );\n            },\n\n            /**\n             * After place order callback\n             */\n            afterPlaceOrder: function () {\n                if (this.iframeIsLoaded) {\n                    document.getElementById(this.getCode() + '-iframe')\n                        .contentWindow.location.reload();\n                }\n\n                this.paymentReady(true);\n                this.iframeIsLoaded = true;\n                this.isPlaceOrderActionAllowed(true);\n                fullScreenLoader.stopLoader();\n            },\n\n            /**\n             * Hide loader when iframe is fully loaded.\n             */\n            iframeLoaded: function () {\n                fullScreenLoader.stopLoader();\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/payflow-express-bml'\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/payflow-express'\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Payment/js/view/payment/iframe',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/action/set-payment-information',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Vault/js/view/payment/vault-enabler'\n    ],\n    function ($, Component, additionalValidators, setPaymentInformationAction, fullScreenLoader, VaultEnabler) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/payflowpro-form'\n            },\n            placeOrderHandler: null,\n            validateHandler: null,\n\n            /**\n             * @returns {exports.initialize}\n             */\n            initialize: function () {\n                this._super();\n                this.vaultEnabler = new VaultEnabler();\n                this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n                return this;\n            },\n\n            /**\n             * @param {Function} handler\n             */\n            setPlaceOrderHandler: function(handler) {\n                this.placeOrderHandler = handler;\n            },\n\n            /**\n             * @param {Function} handler\n             */\n            setValidateHandler: function (handler) {\n                this.validateHandler = handler;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            context: function () {\n                return this;\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isShowLegend: function () {\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return 'payflowpro';\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                return true;\n            },\n\n            /**\n             * @override\n             */\n            placeOrder: function () {\n                var self = this;\n\n                if (this.validateHandler() && additionalValidators.validate()) {\n                    this.isPlaceOrderActionAllowed(false);\n                    fullScreenLoader.startLoader();\n                    $.when(\n                        setPaymentInformationAction(this.messageContainer, self.getData())\n                    ).done(\n                        function () {\n                            self.placeOrderHandler().fail(\n                                function () {\n                                    fullScreenLoader.stopLoader();\n                                }\n                            );\n                        }\n                    ).always(\n                        function () {\n                            self.isPlaceOrderActionAllowed(true);\n                            fullScreenLoader.stopLoader();\n                        }\n                    );\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            getData: function () {\n                var data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'cc_type': this.creditCardType(),\n                        'cc_exp_year': this.creditCardExpYear(),\n                        'cc_exp_month': this.creditCardExpMonth(),\n                        'cc_last_4': this.creditCardNumber().substr(-4)\n                    }\n                };\n\n                this.vaultEnabler.visitAdditionalData(data);\n\n                return data;\n            },\n\n            /**\n             * @returns {Bool}\n             */\n            isVaultEnabled: function () {\n                return this.vaultEnabler.isVaultEnabled();\n            },\n\n            /**\n             * @returns {String}\n             */\n            getVaultCode: function () {\n                return 'payflowpro_cc_vault';\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/payment/default',\n        \"mage/validation\"\n    ],\n    function ($, Component) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal_billing_agreement-form',\n                selectedBillingAgreement: ''\n            },\n            initObservable: function () {\n                this._super()\n                    .observe('selectedBillingAgreement');\n                return this;\n            },\n            getTransportName: function() {\n                return window.checkoutConfig.payment.paypalBillingAgreement.transportName;\n            },\n            getBillingAgreements: function() {\n                return window.checkoutConfig.payment.paypalBillingAgreement.agreements;\n            },\n            getData: function() {\n\n                var additionalData = null;\n                if (this.getTransportName()) {\n                    additionalData = {};\n                    additionalData[this.getTransportName()] = this.selectedBillingAgreement();\n                }\n                return {'method': this.item.method, 'additional_data': additionalData};\n            },\n            validate: function() {\n                var form = '#billing-agreement-form';\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Paypal/js/action/set-payment-method',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (\n        $,\n        Component,\n        setPaymentMethodAction,\n        additionalValidators,\n        quote,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express-bml',\n                billingAgreement: ''\n            },\n\n            /** Init observable variables */\n            initObservable: function () {\n                this._super()\n                    .observe('billingAgreement');\n\n                return this;\n            },\n\n            /** Open window with  */\n            showAcceptanceWindow: function (data, event) {\n                window.open(\n                    $(event.target).attr('href'),\n                    'olcwhatispaypal',\n                    'toolbar=no, location=no,' +\n                    ' directories=no, status=no,' +\n                    ' menubar=no, scrollbars=yes,' +\n                    ' resizable=yes, ,left=0,' +\n                    ' top=0, width=400, height=350'\n                );\n\n                return false;\n            },\n\n            /** Returns payment acceptance mark link path */\n            getPaymentAcceptanceMarkHref: function () {\n                return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkHref;\n            },\n\n            /** Returns payment acceptance mark image path */\n            getPaymentAcceptanceMarkSrc: function () {\n                return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkSrc;\n            },\n\n            /** Returns billing agreement data */\n            getBillingAgreementCode: function () {\n                return window.checkoutConfig.payment.paypalExpress.billingAgreementCode[this.item.method];\n            },\n\n            /** Returns payment information data */\n            getData: function () {\n                var parent = this._super(),\n                    additionalData = null;\n\n                if (this.getBillingAgreementCode()) {\n                    additionalData = {};\n                    additionalData[this.getBillingAgreementCode()] = this.billingAgreement();\n                }\n\n                return $.extend(true, parent, {\n                    'additional_data': additionalData\n                });\n            },\n\n            /** Redirect to paypal */\n            continueToPayPal: function () {\n                if (additionalValidators.validate()) {\n                    //update payment method information if additional data was changed\n                    this.selectPaymentMethod();\n                    setPaymentMethodAction(this.messageContainer).done(\n                        function () {\n                            customerData.invalidate(['cart']);\n                            $.mage.redirect(\n                                window.checkoutConfig.payment.paypalExpress.redirectUrl[quote.paymentMethod().method]\n                            );\n                        }\n                    );\n\n                    return false;\n                }\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express-bml.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express-bml'\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express'\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/in-context/checkout-express.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract',\n        'Magento_Paypal/js/action/set-payment-method',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Ui/js/lib/view/utils/dom-observer',\n        'paypalInContextExpressCheckout',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        setPaymentMethodAction,\n        additionalValidators,\n        domObserver,\n        paypalExpressCheckout,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express-in-context',\n                clientConfig: {\n\n                    /**\n                     * @param {Object} event\n                     */\n                    click: function (event) {\n                        event.preventDefault();\n\n                        if (additionalValidators.validate()) {\n                            paypalExpressCheckout.checkout.initXO();\n                            this.selectPaymentMethod();\n                            setPaymentMethodAction(this.messageContainer).done(\n                                function () {\n                                    $('body').trigger('processStart');\n\n                                    $.get(\n                                        this.path,\n                                        {\n                                            button: 0\n                                        }\n                                    ).done(\n                                        function (response) {\n                                            if (response && response.url) {\n                                                paypalExpressCheckout.checkout.startFlow(response.url);\n\n                                                return;\n                                            }\n\n                                            paypalExpressCheckout.checkout.closeFlow();\n                                            window.location.reload();\n                                        }\n                                    ).fail(\n                                        function () {\n                                            paypalExpressCheckout.checkout.closeFlow();\n                                            window.location.reload();\n                                        }\n                                    ).always(\n                                        function () {\n                                            $('body').trigger('processStop');\n                                            customerData.invalidate(['cart']);\n                                        }\n                                    );\n\n                                }.bind(this)\n                            );\n                        }\n                    }\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n                this.initClient();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initClient: function () {\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n\n                domObserver.get('#' + this.getButtonId(), function () {\n                    paypalExpressCheckout.checkout.setup(this.merchantId, this.clientConfig);\n                }.bind(this));\n\n                return this;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getButtonId: function () {\n                return this.inContextId;\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro/vault.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'Magento_Vault/js/view/payment/method-renderer/vault'\n], function ($, VaultComponent) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Vault/payment/form'\n        },\n\n        /**\n         * @returns {String}\n         */\n        getToken: function () {\n            return this.publicHash;\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details['cc_last_4'];\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details['cc_exp_month'] + '/' + this.details['cc_exp_year'];\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details['cc_type'];\n        }\n    });\n});\n","Magento_Paypal/js/view/review/actions/iframe.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'ko',\n        'Magento_Paypal/js/model/iframe'\n    ],\n    function (Component, ko, iframe) {\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/review/actions/iframe'\n            },\n            getCode: function() {\n                return this.index;\n            },\n            getActionUrl: function() {\n                return this.isInAction() ? window.checkoutConfig.payment.paypalIframe.actionUrl[this.getCode()] : '';\n            },\n            afterSave: function() {\n                iframe.setIsInAction(true);\n                return false;\n            },\n            isInAction: function() {\n                return iframe.getIsInAction()();\n            },\n            placeOrder: function(context) {\n                return context.placeOrder.bind(context, this.afterSave);\n            }\n        });\n    }\n);\n","Magento_Bundle/js/price-bundle.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        optionConfig: null,\n        productBundleSelector: 'input.bundle.option, select.bundle.option, textarea.bundle.option',\n        qtyFieldSelector: 'input.qty',\n        priceBoxSelector: '.price-box',\n        optionHandlers: {},\n        optionTemplate: '<%- data.label %>' +\n        '<% if (data.finalPrice.value) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd', // should be eliminated\n        priceFormat: {},\n        isFixedPrice: false\n    };\n\n    $.widget('mage.priceBundle', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form);\n\n            options.trigger('change');\n        },\n\n        /**\n         * @private\n         */\n        _create: function createPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                priceBox = $(this.options.priceBoxSelector, form),\n                qty = $(this.options.qtyFieldSelector, form);\n\n            if (priceBox.data('magePriceBox') && priceBox.priceBox('option') && priceBox.priceBox('option').priceConfig) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n                priceBox.priceBox('setDefault', this.options.optionConfig.prices);\n            }\n            this._applyQtyFix();\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onBundleOptionChanged.bind(this));\n            qty.on('change', this._onQtyFieldChanged.bind(this));\n        },\n\n        /**\n         * Handle change on bundle option inputs\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onBundleOptionChanged: function onBundleOptionChanged(event) {\n            var changes,\n                bundleOption = $(event.target),\n                priceBox = $(this.options.priceBoxSelector, this.element),\n                handler = this.options.optionHandlers[bundleOption.data('role')];\n\n            bundleOption.data('optionContainer', bundleOption.closest(this.options.controlContainer));\n            bundleOption.data('qtyField', bundleOption.data('optionContainer').find(this.options.qtyFieldSelector));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(bundleOption, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(bundleOption, this.options.optionConfig);\n            }\n\n            if (changes) {\n                priceBox.trigger('updatePrice', changes);\n            }\n            this.updateProductSummary();\n        },\n\n        /**\n         * Handle change on qty inputs near bundle option\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyFieldChanged: function onQtyFieldChanged(event) {\n            var field = $(event.target),\n                optionInstance,\n                optionConfig;\n\n            if (field.data('optionId') && field.data('optionValueId')) {\n                optionInstance = field.data('option');\n                optionConfig = this.options.optionConfig\n                    .options[field.data('optionId')]\n                    .selections[field.data('optionValueId')];\n                optionConfig.qty = field.val();\n\n                optionInstance.trigger('change');\n            }\n        },\n\n        /**\n         * Helper to fix backend behavior:\n         *  - if default qty large than 1 then backend multiply price in config\n         *\n         * @private\n         */\n        _applyQtyFix: function applyQtyFix() {\n            var config = this.options.optionConfig;\n            if (config.isFixedPrice) {\n                _.each(config.options, function (option) {\n                    _.each(option.selections, function (item) {\n                        if (item.qty && item.qty !== 1) {\n                            _.each(item.prices, function (price) {\n                                price.amount = price.amount / item.qty;\n                            });\n                        }\n                    });\n                });\n            }\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionName = $element.prop('name'),\n                    optionType = $element.prop('type'),\n                    optionConfig = config.optionConfig && config.optionConfig.options[optionId].selections;\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue].prices;\n\n                    _.each(prices, function (price, type) {\n                        var value = +(price.amount);\n                        value += _.reduce(price.adjustments, function (sum, x) {\n                            return sum + x;\n                        }, 0);\n                        toTemplate.data[type] = {\n                            value: value,\n                            formatted: utils.formatPrice(value, format)\n                        };\n                    });\n\n                    $option.html(template(toTemplate));\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            this._super(options);\n\n            return this;\n        },\n\n        /**\n         * Handler to update productSummary box\n         */\n        updateProductSummary: function updateProductSummary() {\n            this.element.trigger('updateProductSummary', {\n                config: this.options.optionConfig\n            });\n        }\n    });\n\n    return $.mage.priceBundle;\n\n    /**\n     * Converts option value to priceBox object\n     *\n     * @param   {jQuery} element\n     * @param   {Object} config\n     * @returns {Object|null} - priceBox object with additional prices\n     */\n    function defaultGetOptionValue(element, config) {\n        var changes = {},\n            optionHash,\n            tempChanges,\n            qtyField,\n            optionId = utils.findOptionId(element[0]),\n            optionValue = element.val() || null,\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = config.options[optionId].selections,\n            optionQty = 0,\n            canQtyCustomize = false,\n            selectedIds = config.selected;\n\n        switch (optionType) {\n            case 'radio':\n\n            case 'select-one':\n\n                if (optionType === 'radio' && !element.is(':checked')) {\n                    return null;\n                }\n\n                qtyField = element.data('qtyField');\n                qtyField.data('option', element);\n\n                if (optionValue) {\n                    optionQty = optionConfig[optionValue].qty || 0;\n                    canQtyCustomize = optionConfig[optionValue].customQty === '1';\n                    toggleQtyField(qtyField, optionQty, optionId, optionValue, canQtyCustomize);\n                    tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                    tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig[optionValue]);\n                    tempChanges = applyQty(tempChanges, optionQty);\n                } else {\n                    tempChanges = {};\n                    toggleQtyField(qtyField, '0', optionId, optionValue, false);\n                }\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n\n            case 'select-multiple':\n                optionValue = _.compact(optionValue);\n\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = 'bundle-option-' + optionName + '##' + optionValueCode;\n                    optionQty = row.qty || 0;\n                    tempChanges = utils.deepClone(row.prices);\n                    tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);\n                    tempChanges = applyQty(tempChanges, optionQty);\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? tempChanges : {};\n                });\n\n                selectedIds[optionId] = optionValue || [];\n                break;\n\n            case 'checkbox':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);\n                tempChanges = applyQty(tempChanges, optionQty);\n                changes[optionHash] = element.is(':checked') ? tempChanges : {};\n\n                selectedIds[optionId] = selectedIds[optionId] || [];\n\n                if (!_.contains(selectedIds[optionId], optionValue) && element.is(':checked')) {\n                    selectedIds[optionId].push(optionValue);\n                } else if (!element.is(':checked')) {\n                    selectedIds[optionId] = _.without(selectedIds[optionId], optionValue);\n                }\n                break;\n\n            case 'hidden':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);\n                tempChanges = applyQty(tempChanges, optionQty);\n\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n        }\n\n        return changes;\n    }\n\n    /**\n     * Helper to toggle qty field\n     * @param {jQuery} element\n     * @param {String|Number} value\n     * @param {String|Number} optionId\n     * @param {String|Number} optionValueId\n     * @param {Boolean} canEdit\n     */\n    function toggleQtyField(element, value, optionId, optionValueId, canEdit) {\n        element\n            .val(value)\n            .data('optionId', optionId)\n            .data('optionValueId', optionValueId)\n            .attr('disabled', !canEdit);\n\n        if (canEdit) {\n            element.removeClass('qty-disabled');\n        } else {\n            element.addClass('qty-disabled');\n        }\n    }\n\n    /**\n     * Helper to multiply on qty\n     *\n     * @param   {Object} prices\n     * @param   {Number} qty\n     * @returns {Object}\n     */\n    function applyQty(prices, qty) {\n        _.each(prices, function (everyPrice) {\n            everyPrice.amount *= qty;\n            _.each(everyPrice.adjustments, function (el, index) {\n                everyPrice.adjustments[index] *= qty;\n            });\n        });\n\n        return prices;\n    }\n\n    /**\n     * Helper to limit price with tier price\n     *\n     * @param {Object} oneItemPrice\n     * @param {Number} qty\n     * @param {Object} optionConfig\n     * @returns {Object}\n     */\n    function applyTierPrice(oneItemPrice, qty, optionConfig) {\n        var tiers = optionConfig.tierPrice,\n            magicKey = _.keys(oneItemPrice)[0],\n            lowest = false;\n\n        _.each(tiers, function (tier, index) {\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if (tier.price_qty > qty) {\n                return;\n            }\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            if (tier.prices[magicKey].amount < oneItemPrice[magicKey].amount) {\n                lowest = index;\n            }\n        });\n\n        if (lowest !== false) {\n            oneItemPrice = utils.deepClone(tiers[lowest].prices);\n        }\n\n        return oneItemPrice;\n    }\n});\n","Magento_Bundle/js/float.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true expr:true*/\ndefine([\"jquery\",\"jquery/ui\"], function($){\n\n    $.widget('mage.float', {\n        options: {\n            productOptionsSelector: '#product-options-wrapper'\n        },\n\n        /**\n         * Bind handlers to scroll event\n         * @private\n         */\n        _create: function() {\n            $(window).on('scroll', $.proxy(this._setTop, this));\n        },\n\n        /**\n         * float bundleSummary on windowScroll\n         * @private\n         */\n        _setTop: function() {\n            if ((this.element).is(':visible')) {\n                var starTop = $(this.options.productOptionsSelector).offset().top,\n                    offset = $(document).scrollTop(),\n                    maxTop = this.element.parent().offset().top;\n                if (!this.options.top) {\n                    this.options.top = this.element.position().top;\n                    this.element.css('top', this.options.top);\n                }\n\n                if (starTop > offset) {\n                    return false;\n                }\n\n                if (offset < this.options.top) {\n                    offset = this.options.top;\n                }\n\n                var allowedTop = this.options.top + offset - starTop;\n\n                if (allowedTop < maxTop) {\n                    this.element.css('top', allowedTop);\n                }\n            }\n        }\n    });\n});","Magento_Bundle/js/product-summary.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'Magento_Bundle/js/price-bundle'\n], function ($, mageTemplate) {\n    'use strict';\n\n    /**\n     * Widget product Summary:\n     * Handles rendering of Bundle options and displays them in the Summary box\n     */\n    $.widget('mage.productSummary', {\n        options: {\n            mainContainer:          '#product_addtocart_form',\n            templates: {\n                summaryBlock:       '[data-template=\"bundle-summary\"]',\n                optionBlock:        '[data-template=\"bundle-option\"]'\n            },\n            optionSelector:         '[data-container=\"options\"]',\n            summaryContainer:       '[data-container=\"product-summary\"]',\n            bundleSummaryContainer: '.bundle-summary'\n        },\n        cache: {},\n        /**\n         * Method attaches event observer to the product form\n         * @private\n         */\n        _create: function () {\n            this.element\n                .closest(this.options.mainContainer)\n                .on('updateProductSummary', $.proxy(this._renderSummaryBox, this))\n                .priceBundle({})\n            ;\n        },\n        /**\n         * Method extracts data from the event and renders Summary box\n         * using jQuery template mechanism\n         * @param {Event} event\n         * @param {Object} data\n         * @private\n         */\n        _renderSummaryBox: function (event, data) {\n            this.cache.currentElement = data.config;\n            this.cache.currentElementCount = 0;\n\n            // Clear Summary box\n            this.element.html('');\n\n            $.each(this.cache.currentElement.selected, $.proxy(this._renderOption, this));\n            this.element\n                .parents(this.options.bundleSummaryContainer)\n                .toggleClass('empty', !this.cache.currentElementCount); // Zero elements equal '.empty' container\n        },\n\n        /**\n         * @param {String} key\n         * @param {String} row\n         * @private\n         */\n        _renderOption: function (key, row) {\n            var template;\n\n            if (row && row.length > 0 && row[0] !== null) {\n                template = this.element\n                    .closest(this.options.summaryContainer)\n                    .find(this.options.templates.summaryBlock)\n                    .html();\n                template = mageTemplate($.trim(template), {\n                    data: {\n                        _label_: this.cache.currentElement.options[key].title\n                    }\n                });\n\n                this.cache.currentKey = key;\n                this.cache.summaryContainer = $(template);\n                this.element.append(this.cache.summaryContainer);\n\n                $.each(row, this._renderOptionRow.bind(this));\n                this.cache.currentElementCount += row.length;\n\n                //Reset Cache\n                this.cache.currentKey = null;\n            }\n        },\n\n        /**\n         * @param {String} key\n         * @param {String} optionIndex\n         * @private\n         */\n        _renderOptionRow: function (key, optionIndex) {\n            var template;\n\n            template = this.element\n                .closest(this.options.summaryContainer)\n                .find(this.options.templates.optionBlock)\n                .html();\n            template = mageTemplate($.trim(template), {\n                data: {\n                    _quantity_: this.cache.currentElement.options[this.cache.currentKey].selections[optionIndex].qty,\n                    _label_: this.cache.currentElement.options[this.cache.currentKey].selections[optionIndex].name\n                }\n            });\n            this.cache.summaryContainer\n                .find(this.options.optionSelector)\n                .append(template);\n        }\n    });\n\n    return $.mage.productSummary;\n});\n","Magento_Bundle/js/slide.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true expr:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.slide', {\n        options: {\n            slideSpeed: 1500,\n            slideSelector: '#bundle-slide',\n            slideBackSelector: '.bundle-slide-back',\n            bundleProductSelector: '#bundleProduct',\n            bundleOptionsContainer: '#options-container',\n            productViewContainer: '#productView',\n            slidedown: true\n\n        },\n\n        _create: function() {\n            if(this.options.slidedown === true) {\n                $(this.options.slideSelector).on('click', $.proxy(this._show, this));\n                $(this.options.slideBackSelector).on('click', $.proxy(this._hide, this));\n                this.options.autostart && this._show();\n            } else {\n                $(this.options.slideSelector).on('click', $.proxy(this._slide, this));\n                $(this.options.slideBackSelector).on('click', $.proxy(this._slideBack, this));\n                this.options.autostart && this._slide();\n            }\n        },\n\n        /**\n         * slide bundleOptionsContainer over to the main view area\n         * @private\n         */\n        _slide: function() {\n            $(this.options.bundleProductSelector).css('top', '0px');\n            $(this.options.bundleOptionsContainer).show();\n            this.element.css('height',$(this.options.productViewContainer).height() + 'px');\n            $(this.options.bundleProductSelector).css('left', '0px').animate(\n                {'left': '-' + this.element.width() + 'px'},\n                this.options.slideSpeed,\n                $.proxy(function() {\n                    this.element.css('height','auto');\n                    $(this.options.productViewContainer).hide();\n                }, this)\n            );\n        },\n\n        /**\n         * slideback productViewContainer to main view area\n         * @private\n         */\n        _slideBack: function() {\n            $(this.options.bundleProductSelector).css('top', '0px');\n            $(this.options.productViewContainer).show();\n            this.element.css('height', $(this.options.bundleOptionsContainer).height() + 'px');\n            $(this.options.bundleProductSelector).animate(\n                {'left': '0px'},\n                this.options.slideSpeed,\n                $.proxy(function() {\n                    $(this.options.bundleOptionsContainer).hide();\n                    this.element.css('height','auto');\n                }, this)\n            );\n        },\n        _show: function() {\n            $(this.options.bundleOptionsContainer).slideDown(800);\n            $('html, body').animate({\n                scrollTop: $(this.options.bundleOptionsContainer).offset().top\n            }, 600);\n            $('#product-options-wrapper > fieldset').focus();\n        },\n        _hide: function() {\n            $('html, body').animate({\n                scrollTop: 0\n            }, 600);\n            $(this.options.bundleOptionsContainer).slideUp(800);\n        }\n    });\n    \n    return $.mage.slide;\n});","Magento_Translation/add-class.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n'use strict';\n\n(function () {\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Weee/tax-toggle.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    function onToggle(config, e) {\n        var elem = $(e.currentTarget),\n            expandedClassName = config.expandedClassName || 'cart-tax-total-expanded';\n\n        elem.toggleClass(expandedClassName);\n\n        $(config.itemTaxId).toggle();\n    }\n\n    return function (data, el) {\n        $(el).on('click', onToggle.bind(null, data));\n    };\n});\n","Magento_Weee/js/view/cart/totals/weee.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Weee/js/view/checkout/summary/weee'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * @override\n             */\n            isFullMode: function () {\n                return true;\n            }\n        });\n    }\n);\n","Magento_Weee/js/view/checkout/summary/weee.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/totals',\n        'Magento_Catalog/js/price-utils'\n    ],\n    function (Component, quote, totals) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Weee/checkout/summary/weee'\n            },\n            isIncludedInSubtotal: window.checkoutConfig.isIncludedInSubtotal,\n            totals: totals.totals,\n\n            /**\n             * @returns {Number}\n             */\n            getWeeeTaxSegment: function () {\n                var weee = totals.getSegment('weee_tax') || totals.getSegment('weee');\n\n                if (weee !== null && weee.hasOwnProperty('value')) {\n                    return weee.value;\n                }\n\n                return 0;\n            },\n\n            /**\n             * Get weee value\n             * @returns {String}\n             */\n            getValue: function () {\n                return this.getFormattedPrice(this.getWeeeTaxSegment());\n            },\n\n            /**\n             * Weee display flag\n             * @returns {Boolean}\n             */\n            isDisplayed: function () {\n                return this.isFullMode() && this.getWeeeTaxSegment() > 0;\n            }\n        });\n    }\n);\n","Magento_Weee/js/view/checkout/summary/item/price/row_excl_tax.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Weee/js/view/checkout/summary/item/price/weee'\n    ],\n    function (weee) {\n        \"use strict\";\n        return weee.extend({\n            defaults: {\n                template: 'Magento_Weee/checkout/summary/item/price/row_excl_tax'\n            },\n\n            getFinalRowDisplayPriceExclTax: function(item) {\n                var rowTotalExclTax = parseFloat(item.row_total);\n                if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                    rowTotalExclTax += parseFloat(item.weee_tax_applied_amount);\n                }\n                return rowTotalExclTax;\n            },\n\n            getRowDisplayPriceExclTax: function(item) {\n                var rowTotalExclTax = parseFloat(item.row_total);\n                if (window.checkoutConfig.getIncludeWeeeFlag) {\n                    rowTotalExclTax += this.getRowWeeeTaxExclTax(item);\n                }\n                return rowTotalExclTax;\n            },\n\n            getRowWeeeTaxExclTax: function(item) {\n                var totalWeeeTaxExclTaxApplied = 0;\n                if (item.weee_tax_applied) {\n                    var weeeTaxAppliedAmounts = JSON.parse(item.weee_tax_applied);\n                    weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                        totalWeeeTaxExclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount.row_amount, 0));\n                    });\n                }\n                return totalWeeeTaxExclTaxApplied;\n            }\n\n        });\n    }\n);\n","Magento_Weee/js/view/checkout/summary/item/price/row_incl_tax.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Weee/js/view/checkout/summary/item/price/weee'\n    ],\n    function (weee) {\n        \"use strict\";\n        return weee.extend({\n            defaults: {\n                template: 'Magento_Weee/checkout/summary/item/price/row_incl_tax',\n                displayArea: 'row_incl_tax'\n            },\n\n            getFinalRowDisplayPriceInclTax: function(item) {\n                var rowTotalInclTax = parseFloat(item.row_total_incl_tax);\n                if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                    rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n                }\n                return rowTotalInclTax;\n            },\n\n            getRowDisplayPriceInclTax: function(item) {\n                var rowTotalInclTax = parseFloat(item.row_total_incl_tax);\n                if (window.checkoutConfig.getIncludeWeeeFlag) {\n                    rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n                }\n                return rowTotalInclTax;\n            },\n\n            getRowWeeeTaxInclTax: function(item) {\n                var totalWeeeTaxInclTaxApplied = 0;\n                if (item.weee_tax_applied) {\n                    var weeeTaxAppliedAmounts = JSON.parse(item.weee_tax_applied);\n                    weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                        totalWeeeTaxInclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount.row_amount_incl_tax, 0));\n                    });\n                }\n                return totalWeeeTaxInclTaxApplied;\n            }\n\n        });\n    }\n);\n","Magento_Weee/js/view/checkout/summary/item/price/weee.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component,quote) {\n        \"use strict\";\n        return Component.extend({\n\n            isDisplayPriceWithWeeeDetails: function(item) {\n                if(!parseFloat(item.weee_tax_applied_amount) || parseFloat(item.weee_tax_applied_amount <= 0)) {\n                    return false;\n                }\n                return window.checkoutConfig.isDisplayPriceWithWeeeDetails;\n            },\n            isDisplayFinalPrice: function(item) {\n                if(!parseFloat(item.weee_tax_applied_amount)) {\n                    return false;\n                }\n                return window.checkoutConfig.isDisplayFinalPrice;\n            },\n            getWeeeTaxApplied: function(item) {\n                if (item.weee_tax_applied) {\n                    return JSON.parse(item.weee_tax_applied)\n                }\n                return [];\n\n            }\n        });\n    }\n);\n","Magento_Usps/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        'use strict';\n        return {\n            getRules: function () {\n                return {\n                    'country_id': {\n                        'required': true\n                    },\n                    'postcode': {\n                        'required': false\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Usps/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        './shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n        var checkoutConfig = window.checkoutConfig;\n\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var rules = validationRules.getRules(),\n                    self = this;\n\n                $.each(rules, function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        self.validationErrors.push(message);\n                    }\n                });\n\n                if (!Boolean(this.validationErrors.length)) {\n                    if (address.country_id == checkoutConfig.originCountryCode) {\n                        return !utils.isEmpty(address.postcode);\n                    }\n                    return true;\n                }\n                return false;\n            }\n        };\n    }\n);\n","Magento_Usps/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../model/shipping-rates-validator',\n        '../model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        uspsShippingRatesValidator,\n        uspsShippingRatesValidationRules\n    ) {\n        'use strict';\n        defaultShippingRatesValidator.registerValidator('usps', uspsShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('usps', uspsShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_Ups/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        'use strict';\n        return {\n            getRules: function () {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Ups/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        'Magento_Ups/js/model/shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n\n                        self.validationErrors.push(message);\n                    }\n                });\n\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_Ups/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        'Magento_Ups/js/model/shipping-rates-validator',\n        'Magento_Ups/js/model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        upsShippingRatesValidator,\n        upsShippingRatesValidationRules\n    ) {\n        'use strict';\n        defaultShippingRatesValidator.registerValidator('ups', upsShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('ups', upsShippingRatesValidationRules);\n\n        return Component;\n    }\n);\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'jquery/jquery.parsequery'\n], function ($, _) {\n    'use strict';\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - option-type (integer, 0-3)\n     *  - option-label (string)\n     *  - option-tooltip-thumb\n     *  - option-tooltip-value\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.attr('option-type'), 10),\n                label = $this.attr('option-label'),\n                thumb = $this.attr('option-tooltip-thumb'),\n                value = $this.attr('option-tooltip-value'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.size()) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.hover(function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            }, function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // text for more button\n            moreButtonText: 'More',\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            //\n            onlyMainImg: false\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns array\n         */\n        getProduct: function () {\n            return this._CalcProducts().shift();\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                this._sortAttributes();\n                this._RenderControls();\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return attribute.position;\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                isProductViewExist = $('body.catalog-product-view').size() > 0,\n                $main = isProductViewExist ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (isProductViewExist) {\n                gallery.on('gallery:loaded', function () {\n                    var galleryObject = gallery.data('gallery');\n\n                    options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n                });\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n            this.productForm = this.element.parents(this.options.selectorProduct).find('form:first');\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    options = $widget._RenderSwatchOptions(item),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span class=\"' + classes.attributeLabelClass + '\">' + item.label + '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.productForm) {\n                    $widget.productForm.append(input);\n                    input = '';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code +\n                        '\" attribute-code=\"' + item.code +\n                        '\" attribute-id=\"' + item.id + '\">' +\n                            label +\n                        '<div class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: this.products\n                        };\n                    }\n                });\n            });\n\n            // Connect Tooltip\n            container\n                .find('[option-type=\"1\"], [option-type=\"2\"], [option-type=\"0\"], [option-type=\"3\"]')\n                .SwatchRendererTooltip();\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function () {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    attr;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\">' + moreText + '</a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ? optionConfig[id].value : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                label = this.label ? this.label : '';\n                attr =\n                    ' option-type=\"' + type + '\"' +\n                    ' option-id=\"' + id + '\"' +\n                    ' option-label=\"' + label + '\"' +\n                    ' option-tooltip-thumb=\"' + thumb + '\"' +\n                    ' option-tooltip-value=\"' + value + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        '\" style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        '\" style=\"background: url(' + value + ') no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Defaualt\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required:true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"true\" ' +\n                'style=\"visibility: hidden; position:absolute; left:-1000px\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n\n            var $widget = this;\n\n            $widget.element.on('click', '.' + this.options.classes.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + this.options.classes.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + this.options.classes.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n        },\n\n        /**\n         * Event for swatch options\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnClick: function ($this, $widget) {\n\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),\n                attributeId = $parent.attr('attribute-id'),\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n\n            if ($this.hasClass('disabled')) {\n                return;\n            }\n\n            if ($this.hasClass('selected')) {\n                $parent.removeAttr('option-selected').find('.selected').removeClass('selected');\n                $input.val('');\n                $label.text('');\n            } else {\n                $parent.attr('option-selected', $this.attr('option-id')).find('.selected').removeClass('selected');\n                $label.text($this.attr('option-label'));\n                $input.val($this.attr('option-id'));\n                $this.addClass('selected');\n            }\n\n            $widget._Rebuild();\n\n            if ($widget.element.parents($widget.options.selectorProduct)\n                    .find(this.options.selectorProductPrice).is(':data(mage-priceBox)')\n            ) {\n                $widget._UpdatePrice();\n            }\n\n            $widget._LoadProductMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for select\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnChange: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                attributeId = $parent.attr('attribute-id'),\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n\n            if ($this.val() > 0) {\n                $parent.attr('option-selected', $this.val());\n                $input.val($this.val());\n            } else {\n                $parent.removeAttr('option-selected');\n                $input.val('');\n            }\n\n            $widget._Rebuild();\n            $widget._UpdatePrice();\n            $widget._LoadProductMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for more switcher\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _OnMoreClick: function ($this) {\n            $this.nextAll().show();\n            $this.blur().remove();\n        },\n\n        /**\n         * Rewind options for controls\n         *\n         * @private\n         */\n        _Rewind: function (controls) {\n            controls.find('div[option-id], option[option-id]').removeClass('disabled').removeAttr('disabled');\n            controls.find('div[option-empty], option[option-empty]').attr('disabled', true).addClass('disabled');\n        },\n\n        /**\n         * Rebuild container\n         *\n         * @private\n         */\n        _Rebuild: function () {\n\n            var $widget = this,\n                controls = $widget.element.find('.' + $widget.options.classes.attributeClass + '[attribute-id]'),\n                selected = controls.filter('[option-selected]');\n\n            // Enable all options\n            $widget._Rewind(controls);\n\n            // done if nothing selected\n            if (selected.size() <= 0) {\n                return;\n            }\n\n            // Disable not available options\n            controls.each(function () {\n                var $this = $(this),\n                    id = $this.attr('attribute-id'),\n                    products = $widget._CalcProducts(id);\n\n                if (selected.size() === 1 && selected.first().attr('attribute-id') === id) {\n                    return;\n                }\n\n                $this.find('[option-id]').each(function () {\n                    var $element = $(this),\n                        option = $element.attr('option-id');\n\n                    if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option) ||\n                        $element.hasClass('selected') ||\n                        $element.is(':selected')) {\n                        return;\n                    }\n\n                    if (_.intersection(products, $widget.optionsMap[id][option].products).length <= 0) {\n                        $element.attr('disabled', true).addClass('disabled');\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get selected product list\n         *\n         * @returns {Array}\n         * @private\n         */\n        _CalcProducts: function ($skipAttributeId) {\n            var $widget = this,\n                products = [];\n\n            // Generate intersection of products\n            $widget.element.find('.' + $widget.options.classes.attributeClass + '[option-selected]').each(function () {\n                var id = $(this).attr('attribute-id'),\n                    option = $(this).attr('option-selected');\n\n                if ($skipAttributeId !== undefined && $skipAttributeId === id) {\n                    return;\n                }\n\n                if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option)) {\n                    return;\n                }\n\n                if (products.length === 0) {\n                    products = $widget.optionsMap[id][option].products;\n                } else {\n                    products = _.intersection(products, $widget.optionsMap[id][option].products);\n                }\n            });\n\n            return products;\n        },\n\n        /**\n         * Update total price\n         *\n         * @private\n         */\n        _UpdatePrice: function () {\n            var $widget = this,\n                $product = $widget.element.parents($widget.options.selectorProduct),\n                $productPrice = $product.find(this.options.selectorProductPrice),\n                options = _.object(_.keys($widget.optionsMap), {}),\n                result;\n\n            $widget.element.find('.' + $widget.options.classes.attributeClass + '[option-selected]').each(function () {\n                var attributeId = $(this).attr('attribute-id');\n\n                options[attributeId] = $(this).attr('option-selected');\n            });\n\n            result = $widget.options.jsonConfig.optionPrices[_.findKey($widget.options.jsonConfig.index, options)];\n\n            $productPrice.trigger(\n                'updatePrice',\n                {\n                    'prices': $widget._getPrices(result, $productPrice.priceBox('option').prices)\n                }\n            );\n\n        },\n\n        /**\n         * Get prices\n         *\n         * @param {Object} newPrices\n         * @param {Object} displayPrices\n         * @returns {*}\n         * @private\n         */\n        _getPrices: function (newPrices, displayPrices) {\n            var $widget = this;\n\n            if (_.isEmpty(newPrices)) {\n                newPrices = $widget.options.jsonConfig.prices;\n            }\n\n            _.each(displayPrices, function (price, code) {\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Gets all product media and change current to the needed one\n         *\n         * @private\n         */\n        _LoadProductMedia: function () {\n            var $widget = this,\n                $this = $widget.element,\n                attributes = {},\n                productId = 0,\n                mediaCallData,\n                mediaCacheKey,\n\n                /**\n                 * Processes product media data\n                 *\n                 * @param {Object} data\n                 * @returns void\n                 */\n                mediaSuccessCallback = function (data) {\n                    if (!(mediaCacheKey in $widget.options.mediaCache)) {\n                        $widget.options.mediaCache[mediaCacheKey] = data;\n                    }\n                    $widget._ProductMediaCallback($this, data);\n                    $widget._DisableProductMediaLoader($this);\n                };\n\n            if (!$widget.options.mediaCallback) {\n                return;\n            }\n\n            $this.find('[option-selected]').each(function () {\n                var $selected = $(this);\n\n                attributes[$selected.attr('attribute-code')] = $selected.attr('option-selected');\n            });\n\n            if ($('body.catalog-product-view').size() > 0) {\n                //Product Page\n                productId = document.getElementsByName('product')[0].value;\n            } else {\n                //Category View\n                productId = $this.parents('.product.details.product-item-details')\n                    .find('.price-box.price-final_price').attr('data-product-id');\n            }\n\n            mediaCallData = {\n                'product_id': productId,\n                'attributes': attributes,\n                'additional': $.parseQuery()\n            };\n            mediaCacheKey = JSON.stringify(mediaCallData);\n\n            if (mediaCacheKey in $widget.options.mediaCache) {\n                mediaSuccessCallback($widget.options.mediaCache[mediaCacheKey]);\n            } else {\n                mediaCallData.isAjax = true;\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                $widget.xhr = $.post(\n                    $widget.options.mediaCallback,\n                    mediaCallData,\n                    mediaSuccessCallback,\n                    'json'\n                ).done(function () {\n                    $widget._XhrKiller();\n                });\n            }\n        },\n\n        /**\n         * Enable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _EnableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').size() > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .addClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .addClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Disable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _DisableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').size() > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .removeClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .removeClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Callback for product media\n         *\n         * @param {Object} $this\n         * @param {String} response\n         * @private\n         */\n        _ProductMediaCallback: function ($this, response) {\n            var isProductViewExist = $('body.catalog-product-view').size() > 0,\n                $main = isProductViewExist ? $this.parents('.column.main') : $this.parents('.product-item-info'),\n                $widget = this,\n                images = [],\n\n                /**\n                 * Check whether object supported or not\n                 *\n                 * @param {Object} e\n                 * @returns {*|Boolean}\n                 */\n                support = function (e) {\n                    return e.hasOwnProperty('large') && e.hasOwnProperty('medium') && e.hasOwnProperty('small');\n                };\n\n            if (_.size($widget) < 1 || !support(response)) {\n                this.updateBaseImage(this.options.mediaGalleryInitial, $main, isProductViewExist);\n\n                return;\n            }\n\n            images.push({\n                full: response.large,\n                img: response.medium,\n                thumb: response.small,\n                isMain: true\n            });\n\n            if (response.hasOwnProperty('gallery')) {\n                $.each(response.gallery, function () {\n                    if (!support(this) || response.large === this.large) {\n                        return;\n                    }\n                    images.push({\n                        full: this.large,\n                        img: this.medium,\n                        thumb: this.small\n                    });\n                });\n            }\n\n            this.updateBaseImage(images, $main, isProductViewExist);\n        },\n\n        /**\n         * Check if images to update are initial and set their type\n         * @param {Array} images\n         */\n        _setImageType: function (images) {\n            var initial = this.options.mediaGalleryInitial[0].img;\n\n            if (images[0].img === initial) {\n                images = $.extend(true, [], this.options.mediaGalleryInitial);\n            } else {\n                images.map(function (img) {\n                    img.type = 'image';\n                });\n            }\n\n            return images;\n        },\n\n        /**\n         * Update [gallery-placeholder] or [product-image-photo]\n         * @param {Array} images\n         * @param {jQuery} context\n         * @param {Boolean} isProductViewExist\n         */\n        updateBaseImage: function (images, context, isProductViewExist) {\n            var justAnImage = images[0],\n                updateImg,\n                imagesToUpdate,\n                gallery = context.find(this.options.mediaGallerySelector).data('gallery'),\n                item;\n\n            if (isProductViewExist) {\n                imagesToUpdate = images.length ? this._setImageType($.extend(true, [], images)) : [];\n\n                if (this.options.onlyMainImg) {\n                    updateImg = imagesToUpdate.filter(function (img) {\n                        return img.isMain;\n                    });\n                    item = updateImg.length ? updateImg[0] : imagesToUpdate[0];\n                    gallery.updateDataByIndex(0, item);\n\n                    gallery.seek(1);\n                } else {\n                    gallery.updateData(imagesToUpdate);\n                    $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n                }\n            } else if (justAnImage && justAnImage.img) {\n                context.find('.product-image-photo').attr('src', justAnImage.img);\n            }\n        },\n\n        /**\n         * Kill doubled AJAX requests\n         *\n         * @private\n         */\n        _XhrKiller: function () {\n            var $widget = this;\n\n            if ($widget.xhr !== undefined && $widget.xhr !== null) {\n                $widget.xhr.abort();\n                $widget.xhr = null;\n            }\n        },\n\n        /**\n         * Emulate mouse click on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelected: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeCode, optionId) {\n                this.element.find('.' + this.options.classes.attributeClass +\n                    '[attribute-code=\"' + attributeCode + '\"] [option-id=\"' + optionId + '\"]').trigger('click');\n            }, this));\n        },\n\n        /**\n         * Get default options values settings with either URL query parameters\n         * @private\n         */\n        _getSelectedAttributes: function () {\n            var hashIndex = window.location.href.indexOf('#'),\n                selectedAttributes = {},\n                params;\n\n            if (hashIndex !== -1) {\n                params = $.parseQuery(window.location.href.substr(hashIndex + 1));\n\n                selectedAttributes = _.invert(_.mapObject(_.invert(params), function (attributeId) {\n                    var attribute = this.options.jsonConfig.attributes[attributeId];\n\n                    return attribute ? attribute.code : attributeId;\n                }.bind(this)));\n            }\n\n            return selectedAttributes;\n        }\n    });\n\n    return $.mage.SwatchRenderer;\n});\n","Magento_SendFriend/back-event.js":"/**\n* Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n* See COPYING.txt for license details.\n*/\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).on('click', function() {\n            history.back();\n            return false;\n        });\n    };\n});\n","Magento_ProductVideo/js/fotorama-add-video-events.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'catalogGallery',\n    'Magento_ProductVideo/js/load-player'\n], function ($) {\n    'use strict';\n\n    /**\n     * @private\n     */\n    var allowBase = true; //global var is needed because fotorama always fully reloads events in case of fullscreen\n\n    /**\n     * @private\n     */\n    function parseHref(href) {\n        var a = document.createElement('a');\n\n        a.href = href;\n\n        return a;\n    }\n\n    /**\n     * @private\n     */\n    function parseURL(href, forceVideo) {\n        var id,\n            type,\n            ampersandPosition,\n            vimeoRegex;\n\n        /**\n         * Get youtube ID\n         * @param {String} srcid\n         * @returns {{}}\n         */\n        function _getYoutubeId(srcid) {\n            if (srcid) {\n                ampersandPosition = srcid.indexOf('&');\n\n                if (ampersandPosition === -1) {\n                    return srcid;\n                }\n\n                srcid = srcid.substring(0, ampersandPosition);\n            }\n\n            return srcid;\n        }\n\n        if (typeof href !== 'string') {\n            return href;\n        }\n\n        href = parseHref(href);\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            id = href.search.split('v=')[1];\n\n            if (id) {\n                id = _getYoutubeId(id);\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n            ].join(''));\n            id = href.href.match(vimeoRegex)[3];\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {\n            id: id, type: type, s: href.search.replace(/^\\?/, '')\n        } : false;\n    }\n\n    //create AddFotoramaVideoEvents widget\n    $.widget('mage.AddFotoramaVideoEvents', {\n        options: {\n            videoData: '',\n            videoSettings: '',\n            optionsVideoData: ''\n        },\n\n        PV: 'product-video', // [CONST]\n        VU: 'video-unplayed',\n        PVLOADED: 'fotorama__product-video--loaded', // [CONST]\n        VID: 'video', // [CONST]\n        VI: 'vimeo', // [CONST]\n        FTVC: 'fotorama__video-close',\n        FTAR: 'fotorama__arr',\n        TI: 'video-thumb-icon',\n        isFullscreen: false,\n        FTCF: '[data-gallery-role=\"fotorama__fullscreen-icon\"]',\n        Base: 0, //on check for video is base this setting become true if there is any video with base role\n        MobileMaxWidth: 767,\n        GP: 'gallery-placeholder', //gallery placeholder class is needed to find and erase <script> tag\n        videoData: null,\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n\n            $(this.element).on('gallery:loaded',  $.proxy(function () {\n                this.fotoramaItem = $(this.element).find('.fotorama-item');\n                this._initialize();\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initialize: function () {\n            this._loadVideoData();\n\n            if (this._checkForVideoExist()) {\n                this._checkFullscreen();\n                this._listenForFullscreen();\n                this._checkForVimeo();\n                this._isVideoBase();\n                this._initFotoramaVideo();\n                this._attachFotoramaEvents();\n            }\n        },\n\n        /**\n         *\n         * @param {Object} options\n         * @private\n         */\n        _setOptions: function (options) {\n\n            if (options.videoData && options.videoData.length) {\n                this.options.videoData = options.videoData;\n            }\n            this._initialize();\n        },\n\n        /**\n         *\n         * @private\n         */\n        _loadVideoData: function () {\n            var $widget = this;\n\n            if (!$widget.videoData) {\n                $widget.videoData = $widget.options.VideoData;\n            }\n\n            $('#product-options-wrapper').find('[option-selected]').each(function () {\n                var key = $(this).attr('attribute-code') + '_' + $(this).attr('option-selected');\n\n                if ($widget.options.optionsVideoData && $widget.options.optionsVideoData[key]) {\n                    $widget.options.VideoData = $widget.options.optionsVideoData[key];\n                } else {\n                    $widget.options.VideoData = $widget.videoData;\n                }\n            });\n\n            if (!$('#product-options-wrapper').find('[option-selected]').length) {\n                $widget.options.VideoData = $widget.videoData;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkFullscreen: function () {\n            if (this.fotoramaItem.data('fotorama').fullScreen || false) {\n                this.isFullscreen = true;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _listenForFullscreen: function () {\n            var self = this;\n\n            this.fotoramaItem.on('fotorama:fullscreenenter', $.proxy(function () {\n                this.isFullscreen = true;\n            }, this));\n            this.fotoramaItem.on('fotorama:fullscreenexit', $.proxy(function () {\n                this.isFullscreen = false;\n                self._hideVideoArrows();\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} inputData\n         * @param {bool} isJSON\n         * @returns {{}}\n         * @private\n         */\n        _createVideoData: function (inputData, isJSON) {\n            var videoData = [],\n                dataUrl,\n                tmpVideoData,\n                tmpInputData,\n                i;\n\n            if (isJSON) {\n                inputData = $.parseJSON(inputData);\n            }\n\n            for (i = 0; i < inputData.length; i++) {\n                tmpInputData = inputData[i];\n                dataUrl = '';\n                tmpVideoData = {\n                    mediaType: '',\n                    isBase: '',\n                    id: '',\n                    provider: ''\n                };\n                tmpVideoData.mediaType = this.VID;\n\n                if (tmpInputData.mediaType !== 'external-video') {\n                    tmpVideoData.mediaType = tmpInputData.mediaType;\n                }\n\n                tmpVideoData.isBase = tmpInputData.isBase;\n\n                if (tmpInputData.videoUrl != null) {\n                    dataUrl = tmpInputData.videoUrl;\n                    dataUrl = parseURL(dataUrl);\n                    tmpVideoData.id = dataUrl.id;\n                    tmpVideoData.provider = dataUrl.type;\n                    tmpVideoData.videoUrl = tmpInputData.videoUrl;\n                }\n\n                videoData.push(tmpVideoData);\n            }\n\n            return videoData;\n        },\n\n        /**\n         *\n         * @param {Object} fotorama\n         * @param {bool} isBase\n         * @private\n         */\n        _createCloseVideo: function (fotorama, isBase) {\n            var closeVideo;\n\n            this.fotoramaItem.find('.' + this.FTVC).remove();\n            this.fotoramaItem.append('<div class=\"' + this.FTVC + '\"></div>');\n            this.fotoramaItem.css('position', 'relative');\n            closeVideo = this.fotoramaItem.find('.' + this.FTVC);\n            this._closeVideoSetEvents(closeVideo, fotorama);\n\n            if (\n                isBase &&\n                this.options.videoData[fotorama.activeIndex].isBase &&\n                $(window).width() > this.MobileMaxWidth) {\n                this._showCloseVideo();\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _hideCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .removeClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @private\n         */\n        _showCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .addClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @param {jQuery} $closeVideo\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _closeVideoSetEvents: function ($closeVideo, fotorama) {\n            $closeVideo.on('click', $.proxy(function () {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n                this._hideCloseVideo();\n            }, this));\n        },\n\n        /**\n         *\n         * @returns {Boolean}\n         * @private\n         */\n        _checkForVideoExist: function () {\n            var key, result, checker, videoSettings;\n\n            if (!this.options.videoData) {\n                return false;\n            }\n\n            if (!this.options.videoSettings) {\n                return false;\n            }\n            result = this._createVideoData(this.options.videoData, false),\n                checker = false;\n            videoSettings = this.options.videoSettings[0];\n            videoSettings.playIfBase = parseInt(videoSettings.playIfBase, 10);\n            videoSettings.showRelated = parseInt(videoSettings.showRelated, 10);\n            videoSettings.videoAutoRestart = parseInt(videoSettings.videoAutoRestart, 10);\n\n            for (key in result) {\n                if (result[key].mediaType === this.VID) {\n                    checker = true;\n                }\n            }\n\n            if (checker) {\n                this.options.videoData = result;\n            }\n\n            return checker;\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkForVimeo: function () {\n            var allVideoData = this.options.videoData,\n                videoItem;\n\n            for (videoItem in allVideoData) {\n                if (allVideoData[videoItem].provider === this.VI) {\n                    this._loadVimeoJSFramework();\n                }\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _isVideoBase: function () {\n            var allVideoData = this.options.videoData,\n                videoItem,\n                allVideoDataKeys,\n                key,\n                i;\n\n            allVideoDataKeys = Object.keys(allVideoData);\n\n            for (i = 0; i < allVideoDataKeys.length; i++) {\n                key = allVideoDataKeys[i];\n                videoItem = allVideoData[key];\n\n                if (\n                    videoItem.mediaType === this.VID && videoItem.isBase &&\n                    this.options.videoSettings[0].playIfBase && allowBase\n                ) {\n                    this.Base = true;\n                    allowBase = false;\n                }\n            }\n\n            if (!this.isFullscreen) {\n                this._createCloseVideo(this.fotoramaItem.data('fotorama'), this.Base);\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _loadVimeoJSFramework: function () {\n            var element = document.createElement('script'),\n                scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://secure-a.vimeocdn.com/js/froogaloop2.min.js';\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n        },\n\n        /**\n         *\n         * @param {Event} e\n         * @private\n         */\n        _initFotoramaVideo: function (e) {\n            var fotorama = this.fotoramaItem.data('fotorama'),\n                thumbsParent,\n                thumbs,\n                t;\n\n            if (!fotorama.activeFrame.$navThumbFrame) {\n                this.fotoramaItem.on('fotorama:showend', $.proxy(function (evt, fotoramaData) {\n                    $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n                }, this));\n\n                this._startPrepareForPlayer(e, fotorama);\n\n                return null;\n            }\n            fotorama.data.map($.proxy(this._setItemType, this));\n\n            thumbsParent = fotorama.activeFrame.$navThumbFrame.parent();\n            thumbs = thumbsParent.find('.fotorama__nav__frame:visible');\n\n            for (t = 0; t < thumbs.length; t++) {\n                this._setThumbsIcon(thumbs.eq(t), t);\n                this._checkForVideo(e, fotorama, t);\n            }\n\n            this.fotoramaItem.on('fotorama:showend', $.proxy(function (evt, fotoramaData) {\n                $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} elem\n         * @param {Number} i\n         * @private\n         */\n        _setThumbsIcon: function (elem, i) {\n            var fotorama = this.fotoramaItem.data('fotorama');\n\n            if (fotorama.options.nav === 'dots' && elem.hasClass(this.TI)) {\n                elem.removeClass(this.TI);\n            }\n\n            if (this.options.videoData[i].mediaType === this.VID &&\n                fotorama.data[i].type ===  this.VID &&\n                fotorama.options.nav === 'thumbs') {\n                elem.addClass(this.TI);\n            }\n        },\n\n        /**\n         * Temporary solution with adding types for configurable product items\n         *\n         * @param {Object} item\n         * @param {Number} i\n         * @private\n         */\n        _setItemType: function (item, i) {\n            !item.type && (item.type = this.options.videoData[i].mediaType);\n        },\n\n        /**\n         * Attach\n         *\n         * @private\n         */\n        _attachFotoramaEvents: function () {\n            this.fotoramaItem.on('fotorama:showend', $.proxy(function (e, fotorama) {\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n            this.fotoramaItem.on('fotorama:show', $.proxy(function (e, fotorama) {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit', $.proxy(function (e, fotorama) {\n                fotorama.activeFrame.$stageFrame.find('.' + this.PV).remove();\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n        },\n\n        /**\n         * Start prepare for player\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _startPrepareForPlayer: function (e, fotorama) {\n            this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, false);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i - 1);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i + 1);\n        },\n\n        /**\n         * Check for video\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _checkForVideo: function (e, fotorama, number) {\n            var videoData = this.options.videoData[number - 1],\n                $image = fotorama.data[number - 1],\n                videoEventIsSet = false;\n\n            if ($image) {\n\n                !$image.type && this._setItemType($image, number - 1);\n\n                if ($image.type === 'image') {\n                    $image.$navThumbFrame && $image.$navThumbFrame.removeClass(this.TI);\n                    this._hideCloseVideo();\n\n                    return;\n                } else if ($image.$navThumbFrame && $image.type === 'video') {\n                    !$image.$navThumbFrame.hasClass(this.TI) && $image.$navThumbFrame.addClass(this.TI);\n                }\n\n                $image = $image.$stageFrame;\n\n                if ($image) {\n                    videoEventIsSet = $image.hasClass(this.VU);\n                }\n            }\n\n            if ($image && videoData && videoData.mediaType === this.VID && !videoEventIsSet) {\n                $(fotorama.activeFrame.$stageFrame).removeAttr('href');\n                this._prepareForVideoContainer($image, videoData, fotorama, number);\n            }\n\n            if (this.isFullscreen && this.fotoramaItem.data('fotorama').activeFrame.i === number) {\n                this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n            }\n        },\n\n        /**\n         * Prepare for video container\n         *\n         * @param {jQuery} $image\n         * @param {Object} videoData\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _prepareForVideoContainer: function ($image, videoData, fotorama, number) {\n            $image.addClass('fotorama-video-container').addClass(this.VU);\n            this._createVideoContainer(videoData, $image);\n            this._setVideoEvent($image, this.PV, fotorama, number);\n        },\n\n        /**\n         * Create video container\n         *\n         * @param {Object} videoData\n         * @param {jQuery} $image\n         * @private\n         */\n        _createVideoContainer: function (videoData, $image) {\n            var videoSettings;\n\n            if ($image.find('.' + this.PV).length !== 0) {\n                return;\n            }\n\n            videoSettings = this.options.videoSettings[0];\n            $image.append(\n                '<div class=\"' +\n                this.PV +\n                '\" data-related=\"' +\n                videoSettings.showRelated +\n                '\" data-loop=\"' +\n                videoSettings.videoAutoRestart +\n                '\" data-type=\"' +\n                videoData.provider +\n                '\" data-code=\"' +\n                videoData.id +\n                '\" data-width=\"100%\" data-height=\"100%\"></div>'\n            );\n        },\n\n        /**\n         *\n         * @param {Object} $image\n         * @param {Object} PV\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _setVideoEvent: function ($image, PV, fotorama, number) {\n            $image.find('.magnify-lens').remove();\n            $image\n                .off('click tap', $.proxy(this._clickHandler, this))\n                .on('click tap', $.proxy(this._clickHandler, this));\n            this._handleBaseVideo(fotorama, number); //check for video is it base and handle it if it's base\n        },\n\n        /**\n         * Hides preview arrows above video player.\n         * @private\n         */\n        _hideVideoArrows: function () {\n            var arrows = $('.' + this.FTAR);\n\n            arrows.removeClass('fotorama__arr--shown');\n            arrows.removeClass('fotorama__arr--hidden');\n        },\n\n        /**\n         *\n         * @param {Event} event\n         * @private\n         */\n        _clickHandler: function (event) {\n            if ($(event.target).hasClass(this.VU) && $(event.target).find('iframe').length === 0) {\n\n                $(event.target).removeClass(this.VU);\n                $(event.target).find('.' + this.PV).productVideoLoader();\n\n                $('.' + this.FTAR).addClass(this.isFullscreen ? 'fotorama__arr--shown' : 'fotorama__arr--hidden');\n            }\n        },\n\n        /**\n         * Handle base video\n         * @param {Object} fotorama\n         * @param {Number} srcNumber\n         * @private\n         */\n        _handleBaseVideo: function (fotorama, srcNumber) {\n            var waitForFroogaloop,\n                videoData = this.options.videoData,\n                activeIndex = fotorama.activeIndex,\n                number = parseInt(srcNumber, 10),\n                activeIndexIsBase = videoData[activeIndex];\n\n            if (!this.Base) {\n                return;\n            }\n\n            if (activeIndexIsBase && number === 1 && $(window).width() > this.MobileMaxWidth) {\n                if (this.options.videoData[fotorama.activeIndex].provider === this.VI) {\n                    waitForFroogaloop = setInterval($.proxy(function () {\n                        if (window.Froogaloop) {\n                            clearInterval(waitForFroogaloop);\n                            fotorama.requestFullScreen();\n                            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n                            this.Base = false;\n                        }\n                    }, this), 50);\n                } else { //if not a vimeo - play it immediately with a little lag in case for fotorama fullscreen\n                    setTimeout($.proxy(function () {\n                        fotorama.requestFullScreen();\n                        this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n                        this.Base = false;\n                    }, this), 50);\n                }\n            }\n        },\n\n        /**\n         * Destroy video player\n         * @param {jQuery} $wrapper\n         * @param {jQuery} current\n         * @param {bool} close\n         * @private\n         */\n        _unloadVideoPlayer: function ($wrapper, current, close) {\n            var self = this;\n\n            if (!$wrapper) {\n                return;\n            }\n\n            $wrapper.find('.' + this.PVLOADED).removeClass(this.PVLOADED);\n\n            $wrapper.find('.' + this.PV).each(function () {\n                var $item = $(this).parent(),\n                    cloneVideoDiv,\n                    iframeElement = $(this).find('iframe'),\n                    currentIndex,\n                    itemIndex;\n\n                if (iframeElement.length === 0) {\n                    return;\n                }\n\n                currentIndex = current.activeFrame.$stageFrame.index();\n                itemIndex = $item.index();\n\n                if (currentIndex === itemIndex && !close) {\n                    return;\n                }\n\n                if (currentIndex !== itemIndex && close) {\n                    return;\n                }\n\n                iframeElement.remove();\n                cloneVideoDiv = $(this).clone();\n                $(this).remove();\n                $item.append(cloneVideoDiv);\n                $item.addClass(self.VU);\n\n                self._hideCloseVideo();\n                self._hideVideoArrows();\n\n                if (self.isFullscreen && !self.fotoramaItem.data('fotorama').options.fullscreen.arrows) {\n                    if ($('.' + self.FTAR + '--prev').is(':focus') || $('.' + self.FTAR + '--next').is(':focus')) {\n                        $(self.FTCF).focus();\n                    }\n                }\n            });\n        }\n    });\n\n    return $.mage.AddFotoramaVideoEvents;\n});\n","Magento_ProductVideo/js/load-player.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n @version 0.0.1\n @requires jQuery & jQuery UI\n */\ndefine(['jquery', 'jquery/ui'], function ($) {\n    'use strict';\n\n    var videoRegister = {\n        _register: {},\n\n        /**\n         * Checks, if api is already registered\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isRegistered: function (api) {\n            return this._register[api] !== undefined;\n        },\n\n        /**\n         * Checks, if api is loaded\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isLoaded: function (api) {\n            return this._register[api] !== undefined && this._register[api] === true;\n        },\n\n        /**\n         * Register new video api\n         * @param {String} api\n         * @param {bool} loaded\n         */\n        register: function (api, loaded) {\n            loaded = loaded || false;\n            this._register[api] = loaded;\n        }\n    };\n\n    $.widget('mage.productVideoLoader', {\n\n        /**\n         * @private\n         */\n        _create: function () {\n            switch (this.element.data('type')) {\n                case 'youtube':\n                    this.element.videoYoutube();\n                    this._player = this.element.data('mageVideoYoutube');\n                    break;\n\n                case 'vimeo':\n                    this.element.videoVimeo();\n                    this._player = this.element.data('mageVideoVimeo');\n                    break;\n                default:\n                    throw {\n                        name: 'Video Error',\n                        message: 'Unknown video type',\n\n                        /**\n                         * join name with message\n                         */\n                        toString: function () {\n                            return this.name + ': ' + this.message;\n                        }\n                    };\n            }\n        },\n\n        /**\n         * Initializes variables\n         * @private\n         */\n        _initialize: function () {\n            this._params = this.element.data('params') || {};\n            this._code = this.element.data('code');\n            this._width = this.element.data('width');\n            this._height = this.element.data('height');\n            this._autoplay = !!this.element.data('autoplay');\n            this._playing = this._autoplay || false;\n            this._loop = this.element.data('loop');\n            this._rel = this.element.data('related');\n\n            this._responsive = this.element.data('responsive') !== false;\n\n            if (this._responsive === true) {\n                this.element.addClass('responsive');\n            }\n\n            this._calculateRatio();\n        },\n\n        /**\n         * Abstract play command\n         */\n        play: function () {\n            this._player.play();\n        },\n\n        /**\n         * Abstract pause command\n         */\n        pause: function () {\n            this._player.pause();\n        },\n\n        /**\n         * Abstract stop command\n         */\n        stop: function () {\n            this._player.stop();\n        },\n\n        /**\n         * Abstract playing command\n         */\n        playing: function () {\n            return this._player.playing();\n        },\n\n        /**\n         * Destroyer\n         */\n        destroy: function () {\n            this._player.destroy();\n        },\n\n        /**\n         * Calculates ratio for responsive videos\n         * @private\n         */\n        _calculateRatio: function () {\n            if (!this._responsive) {\n                return;\n            }\n            this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n        }\n    });\n\n    $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n        /**\n         * Initialization of the Youtube widget\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            this._initialize();\n\n            this.element.append('<div/>');\n\n            this._on(window, {\n\n                /**\n                 * Handle event\n                 */\n                'youtubeapiready': function () {\n                    if (self._player !== undefined) {\n                        return;\n                    }\n                    self._autoplay = true;\n\n                    if (self._autoplay) {\n                        self._params.autoplay = 1;\n                    }\n\n                    if (!self._rel) {\n                        self._params.rel = 0;\n                    }\n\n                    self._player = new window.YT.Player(self.element.children(':first')[0], {\n                        height: self._height,\n                        width: self._width,\n                        videoId: self._code,\n                        playerVars: self._params,\n                        events: {\n\n                            /**\n                             * Get duration\n                             */\n                            'onReady': function onPlayerReady() {\n                                self._player.getDuration();\n                                self.element.closest('.fotorama__stage__frame')\n                                    .addClass('fotorama__product-video--loaded');\n                            },\n\n                            /**\n                             * Event observer\n                             */\n                            onStateChange: function (data) {\n                                switch (window.parseInt(data.data, 10)) {\n                                    case 1:\n                                        self._playing = true;\n                                        break;\n                                    default:\n                                        self._playing = false;\n                                        break;\n                                }\n\n                                self._trigger('statechange', {}, data);\n\n                                if (data.data === window.YT.PlayerState.ENDED && self._loop) {\n                                    self._player.playVideo();\n                                }\n                            }\n                        }\n\n                    });\n                }\n            });\n\n            this._loadApi();\n        },\n\n        /**\n         * Loads Youtube API and triggers event, when loaded\n         * @private\n         */\n        _loadApi: function () {\n            var element,\n                scriptTag;\n\n            if (videoRegister.isRegistered('youtube')) {\n                if (videoRegister.isLoaded('youtube')) {\n                    $(window).trigger('youtubeapiready');\n                }\n\n                return;\n            }\n            videoRegister.register('youtube');\n\n            element = document.createElement('script');\n            scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://www.youtube.com/iframe_api';\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n\n            /**\n             * Event observe and handle\n             */\n            window.onYouTubeIframeAPIReady = function () {\n                $(window).trigger('youtubeapiready');\n                videoRegister.register('youtube', true);\n            };\n        },\n\n        /**\n         * Play command for Youtube\n         */\n        play: function () {\n            this._player.playVideo();\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Youtube\n         */\n        pause: function () {\n            this._player.pauseVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Youtube\n         */\n        stop: function () {\n            this._player.stopVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Youtube\n         */\n        playing: function () {\n            return this._playing;\n        },\n\n        /**\n         * stops and unloads player\n         * @private\n         */\n        destroy: function () {\n            this.stop();\n            this._player.destroy();\n        }\n    });\n\n    $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n        /**\n         * Initialize the Vimeo widget\n         * @private\n         */\n        _create: function () {\n            var timestamp,\n                additionalParams = '',\n                src;\n\n            this._initialize();\n            timestamp = new Date().getTime();\n            this._autoplay = true;\n\n            if (this._autoplay) {\n                additionalParams += '&autoplay=1';\n            }\n\n            if (this._loop) {\n                additionalParams += '&loop=1';\n            }\n            src = 'http://player.vimeo.com/video/' +\n                this._code + '?api=1&player_id=vimeo' +\n                this._code +\n                timestamp +\n                additionalParams;\n            this.element.append(\n                $('<iframe/>')\n                    .attr('frameborder', 0)\n                    .attr('id', 'vimeo' + this._code + timestamp)\n                    .attr('width', this._width)\n                    .attr('height', this._height)\n                    .attr('src', src)\n                    .attr('webkitallowfullscreen', '')\n                    .attr('mozallowfullscreen', '')\n                    .attr('allowfullscreen', '')\n            );\n            this._player = window.$f(this.element.children(':first')[0]);\n\n            // Froogaloop throws error without a registered ready event\n            this._player.addEvent('ready', function (id) {\n                $('#' + id).closest('.fotorama__stage__frame').addClass('fotorama__product-video--loaded');\n            });\n        },\n\n        /**\n         * Play command for Vimeo\n         */\n        play: function () {\n            this._player.api('play');\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Vimeo\n         */\n        pause: function () {\n            this._player.api('pause');\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Vimeo\n         */\n        stop: function () {\n            this._player.api('unload');\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Vimeo\n         */\n        playing: function () {\n            return this._playing;\n        }\n    });\n});\n","Magento_Persistent/js/view/remember-me.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        \"ko\",\n        \"uiComponent\"\n    ],\n    function (ko, Component) {\n        \"use strict\";\n        var persistenceConfig = window.checkoutConfig.persistenceConfig;\n        return Component.extend({\n            defaults: {\n                template: \"Magento_Persistent/remember-me\"\n            },\n            dataScope: \"global\",\n            isRememberMeCheckboxVisible: ko.observable(persistenceConfig.isRememberMeCheckboxVisible),\n            isRememberMeCheckboxChecked: ko.observable(persistenceConfig.isRememberMeCheckboxChecked)\n        });\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/flatrate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        \"use strict\";\n        return {\n            getRules: function() {\n                return {\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/freeshipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        \"use strict\";\n        return {\n            getRules: function() {\n                return {\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/tablerate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        \"use strict\";\n        return {\n            getRules: function() {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    },\n                    'region_id': {\n                        'required': true\n                    },\n                    'region_id_input': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validator/flatrate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        '../shipping-rates-validation-rules/flatrate',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        \"use strict\";\n        return {\n            validationErrors: [],\n            validate: function(address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function(field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validator/freeshipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        '../shipping-rates-validation-rules/freeshipping',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        \"use strict\";\n        return {\n            validationErrors: [],\n            validate: function(address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function(field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validator/tablerate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        '../shipping-rates-validation-rules/tablerate',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        var regionFields = ['region', 'region_id', 'region_id_input'];\n                        if (\n                            $.inArray(field, regionFields) === -1\n                            || utils.isEmpty(address['region']) && utils.isEmpty(address['region_id'])\n                        ) {\n                            self.validationErrors.push(message);\n                        }\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/view/shipping-rates-validation/flatrate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../../model/shipping-rates-validator/flatrate',\n        '../../model/shipping-rates-validation-rules/flatrate'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        flatrateShippingRatesValidator,\n        flatrateShippingRatesValidationRules\n    ) {\n        \"use strict\";\n        defaultShippingRatesValidator.registerValidator('flatrate', flatrateShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('flatrate', flatrateShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_OfflineShipping/js/view/shipping-rates-validation/freeshipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../../model/shipping-rates-validator/freeshipping',\n        '../../model/shipping-rates-validation-rules/freeshipping'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        freeshippingShippingRatesValidator,\n        freeshippingShippingRatesValidationRules\n    ) {\n        \"use strict\";\n        defaultShippingRatesValidator.registerValidator('freeshipping', freeshippingShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('freeshipping', freeshippingShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_OfflineShipping/js/view/shipping-rates-validation/tablerate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../../model/shipping-rates-validator/tablerate',\n        '../../model/shipping-rates-validation-rules/tablerate'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        tablerateShippingRatesValidator,\n        tablerateShippingRatesValidationRules\n    ) {\n        \"use strict\";\n        defaultShippingRatesValidator.registerValidator('tablerate', tablerateShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('tablerate', tablerateShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_OfflinePayments/js/view/payment/offline-payments.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n        rendererList.push(\n            {\n                type: 'checkmo',\n                component: 'Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method'\n            },\n            {\n                type: 'banktransfer',\n                component: 'Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method'\n            },\n            {\n                type: 'cashondelivery',\n                component: 'Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method'\n            },\n            {\n                type: 'purchaseorder',\n                component: 'Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method'\n            }\n        );\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);","Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko',\n        'Magento_Checkout/js/view/payment/default'\n    ],\n    function (ko, Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_OfflinePayments/payment/banktransfer'\n            },\n            /**\n             * Get value of instruction field.\n             * @returns {String}\n             */\n            getInstructions: function () {\n                return window.checkoutConfig.payment.instructions[this.item.method];\n            }\n        });\n    }\n);\n","Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default'\n    ],\n    function (Component) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_OfflinePayments/payment/cashondelivery'\n            },\n\n            /** Returns payment method instructions */\n            getInstructions: function() {\n                return window.checkoutConfig.payment.instructions[this.item.method];\n            }\n        });\n    }\n);\n","Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_OfflinePayments/payment/checkmo'\n            },\n\n            /** Returns send check to info */\n            getMailingAddress: function() {\n                return window.checkoutConfig.payment.checkmo.mailingAddress;\n            },\n\n            /** Returns payable to info */\n            getPayableTo: function() {\n                return window.checkoutConfig.payment.checkmo.payableTo;\n            }\n        });\n    }\n);\n","Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'jquery',\n        \"mage/validation\"\n    ],\n    function (Component, $) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_OfflinePayments/payment/purchaseorder-form',\n                purchaseOrderNumber: ''\n            },\n            initObservable: function () {\n                this._super()\n                    .observe('purchaseOrderNumber');\n                return this;\n            },\n            getData: function () {\n                return {\n                    \"method\": this.item.method,\n                    'po_number': this.purchaseOrderNumber(),\n                    \"additional_data\": null\n                };\n\n            },\n            validate: function () {\n                var form = 'form[data-role=purchaseorder-form]';\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","Magento_Multishipping/js/multi-shipping.js":"/**\n * @category    checkout multi-shipping addresses\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.multiShipping', {\n        options: {\n            addNewAddressBtn: 'button[data-role=\"add-new-address\"]', // Add a new multishipping address.\n            addNewAddressFlag: '#add_new_address_flag', // Hidden input field with value 0 or 1.\n            canContinueBtn: 'button[data-role=\"can-continue\"]', // Continue (update quantity or go to shipping).\n            canContinueFlag: '#can_continue_flag' // Hidden input field with value 0 or 1.\n        },\n\n        /**\n         * Bind event handlers to click events for corresponding buttons.\n         * @private\n         */\n        _create: function() {\n            $(this.options.addNewAddressBtn).on('click', $.proxy(this._addNewAddress, this));\n            $(this.options.canContinueBtn).on('click', $.proxy(this._canContinue, this));\n        },\n\n        /**\n         * Add a new address. Set the hidden input field and submit the form. Then enter a new shipping address.\n         * @private\n         */\n        _addNewAddress: function() {\n            $(this.options.addNewAddressFlag).val(1);\n            this.element.submit();\n        },\n\n        /**\n         * Can the user continue to the next step? The data-flag attribute holds either 0 (no) or 1 (yes).\n         * @private\n         * @param event {Event} - Click event on the corresponding button.\n         */\n        _canContinue: function(event) {\n            $(this.options.canContinueFlag).val(parseInt($(event.currentTarget).data('flag'), 10));\n        }\n    });\n    \n    return $.mage.multiShipping;\n});","Magento_Multishipping/js/overview.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\n/*global alert*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"mage/translate\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.orderOverview', {\n        options: {\n            opacity: 0.5, // CSS opacity for the 'Place Order' button when it's clicked and then disabled.\n            pleaseWaitLoader: 'span.please-wait', // 'Submitting order information...' Ajax loader.\n            placeOrderSubmit: 'button[type=\"submit\"]', // The 'Place Order' button.\n            agreements: '#checkout-agreements' // Container for all of the checkout agreements and terms/conditions\n        },\n\n        /**\n         * Bind a submit handler to the form.\n         * @private\n         */\n        _create: function() {\n            this.element.on('submit', $.proxy(this._showLoader, this));\n        },\n\n        /**\n         * Verify that all agreements and terms/conditions are checked. Show the Ajax loader. Disable\n         * the submit button (i.e. Place Order).\n         * @return {Boolean}\n         * @private\n         */\n        _showLoader: function() {\n            if ($(this.options.agreements).find('input[type=\"checkbox\"]:not(:checked)').length > 0) {\n                return false;\n            }\n            this.element.find(this.options.pleaseWaitLoader).show().end()\n                .find(this.options.placeOrderSubmit).prop('disabled', true).css('opacity', this.options.opacity);\n            return true;\n        }\n    });\n\n    return $.mage.orderOverview;\n});\n","Magento_Multishipping/js/payment.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global alert*/\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.payment', {\n        options: {\n            continueSelector: '#payment-continue',\n            methodsContainer: '#payment-methods',\n            minBalance: 0.0001,\n            tmpl: '<input id=\"hidden-free\" type=\"hidden\" name=\"payment[method]\" value=\"free\">'\n        },\n\n        _create: function () {\n            this.element.find('dd [name^=\"payment[\"]').prop('disabled', true).end()\n                .on('click', this.options.continueSelector, $.proxy(this._submitHandler, this))\n                .on('updateCheckoutPrice', $.proxy(function (event, data) {\n                    //updating the checkoutPrice\n                    if (data.price) {\n                        this.options.checkoutPrice += data.price;\n                    }\n\n                    //updating total price\n                    if (data.totalPrice) {\n                        data.totalPrice = this.options.checkoutPrice;\n                    }\n\n                    if (this.options.checkoutPrice < this.options.minBalance) {\n                        // Add free input field, hide and disable unchecked checkbox payment method and all radio button payment methods\n                        this._disablePaymentMethods();\n                    } else {\n                        // Remove free input field, show all payment method\n                        this._enablePaymentMethods();\n                    }\n                }, this))\n                .on('click', 'dt input:radio', $.proxy(this._paymentMethodHandler, this));\n\n            if (this.options.checkoutPrice < this.options.minBalance) {\n                this._disablePaymentMethods();\n            } else {\n                this._enablePaymentMethods();\n            }\n        },\n\n        /**\n         * Display payment details when payment method radio button is checked\n         * @private\n         * @param {EventObject} e\n         */\n        _paymentMethodHandler: function (e) {\n            var element = $(e.target),\n                parentsDl = element.closest('dl');\n\n            parentsDl.find('dt input:radio').prop('checked', false);\n            parentsDl.find('.items').hide().find('[name^=\"payment[\"]').prop('disabled', true);\n            element.prop('checked', true).parent().nextUntil('dt').find('.items').show().find('[name^=\"payment[\"]').prop('disabled', false);\n        },\n\n        /**\n         * make sure one payment method is selected\n         * @private\n         * @return {Boolean}\n         */\n        _validatePaymentMethod: function () {\n            var methods = this.element.find('[name^=\"payment[\"]'),\n                isValid = false;\n\n            if (methods.length === 0) {\n                alert({\n                    content: $.mage.__('We can\\'t complete your order because you don\\'t have a payment method set up.')\n                });\n            } else if (this.options.checkoutPrice < this.options.minBalance) {\n                isValid = true;\n            } else if (methods.filter('input:radio:checked').length) {\n                isValid = true;\n            } else {\n                alert({\n                    content: $.mage.__('Please choose a payment method.')\n                });\n            }\n\n            return isValid;\n        },\n\n        /**\n         * Disable and enable payment methods\n         * @private\n         */\n        _disablePaymentMethods: function () {\n            var tmpl = mageTemplate(this.options.tmpl, {\n                data: {}\n            });\n\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', true).end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', true).parent().hide();\n            this.element.find('[name=\"payment[method]\"][value=\"free\"]').parent('dt').remove();\n            this.element.find(this.options.methodsContainer).hide().find('[name^=\"payment[\"]').prop('disabled', true);\n\n            $(tmpl).appendTo(this.element);\n        },\n\n        /**\n         * Enable and enable payment methods\n         * @private\n         */\n        _enablePaymentMethods: function () {\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', false).end()\n                .find('input[name=\"payment[method]\"][value=\"free\"]').remove().end()\n                .find('dt input:radio:checked').trigger('click').end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', false).parent().show();\n            this.element.find(this.options.methodsContainer).show();\n        },\n\n        /**\n         * Validate  before form submit\n         * @private\n         * @param {EventObject} e\n         */\n        _submitHandler: function (e) {\n            e.preventDefault();\n\n            if (this._validatePaymentMethod()) {\n                this.element.submit();\n            }\n        }\n    });\n\n    return $.mage.payment;\n});\n","Magento_Fedex/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        'use strict';\n\n        return {\n            getRules: function () {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Fedex/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        'Magento_Fedex/js/model/shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_Fedex/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        'Magento_Fedex/js/model/shipping-rates-validator',\n        'Magento_Fedex/js/model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        fedexShippingRatesValidator,\n        fedexShippingRatesValidationRules\n    ) {\n        'use strict';\n        defaultShippingRatesValidator.registerValidator('fedex', fedexShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('fedex', fedexShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_Dhl/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        'use strict';\n\n        return {\n            getRules: function () {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Dhl/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        'Magento_Dhl/js/model/shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_Dhl/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        'Magento_Dhl/js/model/shipping-rates-validator',\n        'Magento_Dhl/js/model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        dhlShippingRatesValidator,\n        dhlShippingRatesValidationRules\n    ) {\n        'use strict';\n\n        defaultShippingRatesValidator.registerValidator('dhl', dhlShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('dhl', dhlShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_CheckoutAgreements/js/model/agreement-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'mage/validation'\n    ],\n    function ($) {\n        'use strict';\n        var checkoutConfig = window.checkoutConfig,\n            agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {};\n\n        var agreementsInputPath = '.payment-method._active div.checkout-agreements input';\n\n        return {\n            /**\n             * Validate checkout agreements\n             *\n             * @returns {boolean}\n             */\n            validate: function() {\n                if (!agreementsConfig.isEnabled) {\n                    return true;\n                }\n\n                if ($(agreementsInputPath).length == 0) {\n                    return true;\n                }\n\n                return $('#co-payment-form').validate({\n                    errorClass: 'mage-error',\n                    errorElement: 'div',\n                    meta: 'validate',\n                    errorPlacement: function (error, element) {\n                        var errorPlacement = element;\n                        if (element.is(':checkbox') || element.is(':radio')) {\n                            errorPlacement = element.siblings('label').last();\n                        }\n                        errorPlacement.after(error);\n                    }\n                }).element(agreementsInputPath);\n            }\n        }\n    }\n);\n","Magento_CheckoutAgreements/js/model/agreements-assigner.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var agreementsConfig = window.checkoutConfig.checkoutAgreements;\n\n    /** Override default place order action and add agreement_ids to request */\n    return function (paymentData) {\n        var agreementForm,\n            agreementData,\n            agreementIds;\n\n        if (!agreementsConfig.isEnabled) {\n            return;\n        }\n\n        agreementForm = $('.payment-method._active div[data-role=checkout-agreements] input');\n        agreementData = agreementForm.serializeArray();\n        agreementIds = [];\n\n        agreementData.forEach(function (item) {\n            agreementIds.push(item.value);\n        });\n\n        if (paymentData['extension_attributes'] === undefined) {\n            paymentData['extension_attributes'] = {};\n        }\n\n        paymentData['extension_attributes']['agreement_ids'] = agreementIds;\n    };\n});\n","Magento_CheckoutAgreements/js/model/agreements-modal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Ui/js/modal/modal',\n        'mage/translate'\n    ],\n    function ($, modal, $t) {\n        'use strict';\n        return {\n            modalWindow: null,\n\n            /** Create popUp window for provided element */\n            createModal: function(element) {\n                this.modalWindow = element;\n                var options = {\n                    'type': 'popup',\n                    'modalClass': 'agreements-modal',\n                    'responsive': true,\n                    'innerScroll': true,\n                    'trigger': '.show-modal',\n                    'buttons': [\n                        {\n                            text: $t('Close'),\n                            class: 'action secondary action-hide-popup',\n                            click: function() {\n                                this.closeModal();\n                            }\n                        }\n                    ]\n                };\n                modal(options, $(this.modalWindow));\n            },\n\n            /** Show login popup window */\n            showModal: function() {\n                $(this.modalWindow).modal('openModal');\n            }\n        }\n    }\n);\n","Magento_CheckoutAgreements/js/model/place-order-mixin.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override default place order action and add agreement_ids to request */\n        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) {\n            agreementsAssigner(paymentData);\n\n            return originalAction(paymentData, messageContainer);\n        });\n    };\n});\n","Magento_CheckoutAgreements/js/model/set-payment-information-mixin.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override place-order-mixin for set-payment-information action as they differs only by method signature */\n        return wrapper.wrap(placeOrderAction, function (originalAction, messageContainer, paymentData) {\n            agreementsAssigner(paymentData);\n\n            return originalAction(messageContainer, paymentData);\n        });\n    };\n});\n","Magento_CheckoutAgreements/js/view/agreement-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_CheckoutAgreements/js/model/agreement-validator'\n    ],\n    function (Component, additionalValidators, agreementValidator) {\n        'use strict';\n        additionalValidators.registerValidator(agreementValidator);\n        return Component.extend({});\n    }\n);\n","Magento_CheckoutAgreements/js/view/checkout-agreements.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko',\n        'jquery',\n        'uiComponent',\n        'Magento_CheckoutAgreements/js/model/agreements-modal'\n    ],\n    function (ko, $, Component, agreementsModal) {\n        'use strict';\n        var checkoutConfig = window.checkoutConfig,\n            agreementManualMode = 1,\n            agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {};\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_CheckoutAgreements/checkout/checkout-agreements'\n            },\n            isVisible: agreementsConfig.isEnabled,\n            agreements: agreementsConfig.agreements,\n            modalTitle: ko.observable(null),\n            modalContent: ko.observable(null),\n            modalWindow: null,\n\n            /**\n             * Checks if agreement required\n             *\n             * @param element\n             */\n            isAgreementRequired: function(element) {\n                return element.mode == agreementManualMode;\n            },\n\n            /**\n             * Show agreement content in modal\n             *\n             * @param element\n             */\n            showContent: function (element) {\n                this.modalTitle(element.checkboxText);\n                this.modalContent(element.content);\n                agreementsModal.showModal();\n            },\n\n            /**\n             * Init modal window for rendered element\n             *\n             * @param element\n             */\n            initModal: function(element) {\n                agreementsModal.createModal(element);\n            }\n        });\n    }\n);\n","Magento_Captcha/captcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.captcha', {\n        options: {\n            refreshClass: 'refreshing',\n            reloadSelector: '.captcha-reload',\n            imageSelector: '.captcha-img',\n            imageLoader: ''\n        },\n\n        /**\n         * Method binds click event to reload image\n         * @private\n         */\n        _create: function() {\n            this.element.on('click', this.options.reloadSelector, $.proxy(this.refresh, this));\n        },\n\n        /**\n         * Method triggeres an AJAX request to refresh the CAPTCHA image\n         * @param e - Event\n         */\n        refresh: function(e) {\n            var imageLoader = this.options.imageLoader;\n\n            if (imageLoader) {\n                this.element.find(this.options.imageSelector).attr('src', imageLoader);\n            }\n            this.element.addClass(this.options.refreshClass);\n\n            $.ajax({\n                url: this.options.url,\n                type: 'post',\n                async: false,\n                dataType: 'json',\n                context: this,\n                data: {\n                    'formId': this.options.type\n                },\n                success: function (response) {\n                    if (response.imgSrc) {\n                        this.element.find(this.options.imageSelector).attr('src', response.imgSrc);\n                    }\n                },\n                complete: function() {\n                    this.element.removeClass(this.options.refreshClass);\n                }\n            });\n        }\n    });\n\n    return $.mage.captcha;\n});","Magento_Captcha/onepage.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\"jquery\"], function($){\n    \"use strict\";\n    $(document).on(\"login\",function() {\n        $(\"[data-captcha='guest_checkout'], [data-captcha='register_during_checkout']\").hide();\n        $(\"[role='guest_checkout'], [role='register_during_checkout']\").hide();\n        var type = ($(\"#login\\\\:guest\").is(':checked')) ? 'guest_checkout' : 'register_during_checkout';\n        $(\"[role='\" + type + \"'], [data-captcha='\" + type + \"']\").show();\n    }).on('billingSave', function() {\n            $(\".captcha-reload:visible\").trigger(\"click\");\n        });\n});","Magento_Captcha/js/action/refresh.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global define*/\ndefine(\n    ['mage/storage'],\n    function(storage) {\n        \"use strict\";\n        return function(refreshUrl, formId, imageSource) {\n            return storage.post(\n                refreshUrl,\n                JSON.stringify({'formId': formId}),\n                false\n            ).done(\n                function (response) {\n                    if (response.imgSrc) {\n                        imageSource(response.imgSrc);\n                    }\n                }\n            );\n        };\n    }\n);\n","Magento_Captcha/js/model/captcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'ko',\n        'Magento_Captcha/js/action/refresh'\n    ],\n    function($, ko, refreshAction) {\n        return function (captchaData) {\n            return {\n                formId: captchaData.formId,\n                imageSource: ko.observable(captchaData.imageSrc),\n                visibility: ko.observable(false),\n                captchaValue: ko.observable(null),\n                isRequired: captchaData.isRequired,\n                isCaseSensitive: captchaData.isCaseSensitive,\n                imageHeight: captchaData.imageHeight,\n                refreshUrl: captchaData.refreshUrl,\n                isLoading: ko.observable(false),\n\n                getFormId: function () {\n                    return this.formId;\n                },\n                setFormId: function (formId) {\n                    this.formId = formId;\n                },\n                getIsVisible: function () {\n                    return this.visibility;\n                },\n                setIsVisible: function (flag) {\n                    this.visibility(flag);\n                },\n                getIsRequired: function () {\n                    return this.isRequired;\n                },\n                setIsRequired: function (flag) {\n                    this.isRequired = flag;\n                },\n                getIsCaseSensitive: function () {\n                    return this.isCaseSensitive;\n                },\n                setIsCaseSensitive: function (flag) {\n                    this.isCaseSensitive = flag;\n                },\n                getImageHeight: function () {\n                    return this.imageHeight;\n                },\n                setImageHeight: function (height) {\n                    this.imageHeight = height;\n                },\n                getImageSource: function () {\n                    return this.imageSource;\n                },\n                setImageSource: function (imageSource) {\n                     this.imageSource(imageSource);\n                },\n                getRefreshUrl: function () {\n                    return this.refreshUrl;\n                },\n                setRefreshUrl: function (url) {\n                    this.refreshUrl = url;\n                },\n                getCaptchaValue: function () {\n                    return this.captchaValue;\n                },\n                setCaptchaValue: function (value) {\n                    this.captchaValue(value);\n                },\n                refresh: function() {\n                    var refresh,\n                        self = this;\n                    this.isLoading(true);\n\n                    refresh = refreshAction(this.getRefreshUrl(), this.getFormId(), this.getImageSource());\n                    $.when(refresh).done(function() {\n                        self.isLoading(false);\n                    });\n                }\n            };\n        }\n    }\n);\n","Magento_Captcha/js/model/captchaList.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global define*/\ndefine(['jquery'], function($) {\n    \"use strict\";\n    var captchaList = [];\n    return {\n        add: function (captcha) {\n            captchaList.push(captcha);\n        },\n        getCaptchaByFormId: function(formId) {\n            var captcha = null;\n            $.each(captchaList, function(key, item) {\n                if (formId === item.formId) {\n                    captcha = item;\n                    return false;\n                }\n            });\n            return captcha;\n        },\n        getCaptchaList: function() {\n            return captchaList;\n        }\n    };\n});\n","Magento_Captcha/js/view/checkout/defaultCaptcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true jquery:true*/\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'uiComponent',\n        'Magento_Captcha/js/model/captcha',\n        'Magento_Captcha/js/model/captchaList'\n    ],\n    function ($, Component, Captcha, captchaList) {\n        'use strict';\n        var captchaConfig;\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Captcha/checkout/captcha'\n            },\n            dataScope: 'global',\n            currentCaptcha: null,\n            captchaValue: function() {\n                return this.currentCaptcha.getCaptchaValue();\n            },\n            initialize: function() {\n                this._super();\n                captchaConfig = window[this.configSource]['captcha'];\n\n                if (captchaConfig) {\n                    $.each(captchaConfig, function(formId, captchaData) {\n                        captchaData.formId = formId;\n                        captchaList.add(Captcha(captchaData));\n                    });\n                }\n            },\n            getIsLoading: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.isLoading : false;\n            },\n            getCurrentCaptcha: function() {\n                return this.currentCaptcha;\n            },\n            setCurrentCaptcha: function(captcha) {\n                this.currentCaptcha = captcha;\n            },\n            getFormId: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getFormId() : null;\n            },\n            getIsVisible: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getIsVisible() : false;\n            },\n            setIsVisible: function(flag) {\n                this.currentCaptcha.setIsVisible(flag);\n            },\n            isRequired: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getIsRequired() : false;\n            },\n            isCaseSensitive: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getIsCaseSensitive() : false;\n            },\n            imageHeight: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getImageHeight() : null;\n            },\n            getImageSource: function () {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getImageSource() : null;\n            },\n            refresh: function() {\n                this.currentCaptcha.refresh();\n            }\n        });\n    }\n);\n","Magento_Captcha/js/view/checkout/loginCaptcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true jquery:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Captcha/js/view/checkout/defaultCaptcha',\n        'Magento_Captcha/js/model/captchaList',\n        'Magento_Customer/js/action/login'\n    ],\n    function (defaultCaptcha, captchaList, loginAction) {\n        'use strict';\n        return defaultCaptcha.extend({\n            initialize: function() {\n                this._super();\n                var currentCaptcha = captchaList.getCaptchaByFormId(this.formId),\n                    self = this;\n\n                if (currentCaptcha != null) {\n                    currentCaptcha.setIsVisible(true);\n                    this.setCurrentCaptcha(currentCaptcha);\n\n                    loginAction.registerLoginCallback(function(loginData) {\n                        if (loginData.captcha_form_id && loginData.captcha_form_id == self.formId) {\n                            self.refresh();\n                        }\n                    });\n                }\n            }\n        });\n    }\n);\n","Magento_Braintree/js/validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Braintree/js/paypal/button.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'rjsResolver',\n        'uiRegistry',\n        'uiComponent',\n        'underscore',\n        'jquery',\n        'braintree',\n        'Magento_Braintree/js/paypal/form-builder',\n        'domReady!'\n    ],\n    function (\n        resolver,\n        registry,\n        Component,\n        _,\n        $,\n        braintree,\n        formBuilder\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n\n                integrationName: 'braintreePaypal.currentIntegration',\n\n                /**\n                 * {String}\n                 */\n                displayName: null,\n\n                /**\n                 * {String}\n                 */\n                clientToken: null,\n\n                /**\n                 * {Object}\n                 */\n                clientConfig: {\n\n                    /**\n                     * @param {Object} integration\n                     */\n                    onReady: function (integration) {\n                        resolver(function () {\n                            registry.set(this.integrationName, integration);\n                            $('#' + this.id).removeAttr('disabled');\n                        }, this);\n                    },\n\n                    /**\n                     * @param {Object} payload\n                     */\n                    onPaymentMethodReceived: function (payload) {\n                        $('body').trigger('processStart');\n\n                        formBuilder.build(\n                            {\n                                action: this.actionSuccess,\n                                fields: {\n                                    result: JSON.stringify(payload)\n                                }\n                            }\n                        ).submit();\n                    }\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super()\n                    .initComponent();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initComponent: function () {\n                var currentIntegration = registry.get(this.integrationName),\n                    $this = $('#' + this.id),\n                    self = this,\n                    data = {\n                        amount: $this.data('amount'),\n                        locale: $this.data('locale'),\n                        currency: $this.data('currency')\n                    },\n                    initCallback = function () {\n                        $this.attr('disabled', 'disabled');\n                        registry.remove(this.integrationName);\n                        braintree.setup(this.clientToken, 'custom', this.getClientConfig(data));\n\n                        $this.off('click')\n                            .on('click', function (event) {\n                                event.preventDefault();\n\n                                registry.get(self.integrationName, function (integration) {\n                                    integration.paypal.initAuthFlow();\n                                });\n                            });\n                    }.bind(this);\n\n                currentIntegration ?\n                    currentIntegration.teardown(initCallback) :\n                    initCallback();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            getClientConfig: function (data) {\n                this.clientConfig.paypal = {\n                    singleUse: true,\n                    amount: data.amount,\n                    currency: data.currency,\n                    locale: data.locale,\n                    enableShippingAddress: true,\n                    headless: true\n                };\n\n                if (this.displayName) {\n                    this.clientConfig.paypal.displayName = this.displayName;\n                }\n\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n\n                return this.clientConfig;\n            }\n        });\n    }\n);\n","Magento_Braintree/js/paypal/form-builder.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","Magento_Braintree/js/view/payment/3d-secure.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate'\n], function ($, braintree, quote, $t) {\n    'use strict';\n\n    return {\n        config: null,\n\n        /**\n         * Set 3d secure config\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n            this.config.thresholdAmount = parseFloat(config.thresholdAmount);\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'three_d_secure';\n        },\n\n        /**\n         * Validate Braintree payment nonce\n         * @param {Object} context\n         * @returns {Object}\n         */\n        validate: function (context) {\n            var client = braintree.getApiClient(),\n                state = $.Deferred(),\n                totalAmount = quote.totals()['base_grand_total'],\n                billingAddress = quote.billingAddress();\n\n            if (!this.isAmountAvailable(totalAmount) || !this.isCountryAvailable(billingAddress.countryId)) {\n                state.resolve();\n\n                return state.promise();\n            }\n\n            client.verify3DS({\n                amount: totalAmount,\n                creditCard: context.paymentMethodNonce\n            }, function (error, response) {\n                var liability;\n\n                if (error) {\n                    state.reject(error.message);\n\n                    return;\n                }\n\n                liability = {\n                    shifted: response.verificationDetails.liabilityShifted,\n                    shiftPossible: response.verificationDetails.liabilityShiftPossible\n                };\n\n                if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                    context.paymentMethodNonce = response.nonce;\n                    state.resolve();\n                } else {\n                    state.reject($t('Please try again with another form of payment.'));\n                }\n            });\n\n            return state.promise();\n        },\n\n        /**\n         * Check minimal amount for 3d secure activation\n         * @param {Number} amount\n         * @returns {Boolean}\n         */\n        isAmountAvailable: function (amount) {\n            amount = parseFloat(amount);\n\n            return amount >= this.config.thresholdAmount;\n        },\n\n        /**\n         * Check if current country is available for 3d secure\n         * @param {String} countryId\n         * @returns {Boolean}\n         */\n        isCountryAvailable: function (countryId) {\n            var key,\n                specificCountries = this.config.specificCountries;\n\n            // all countries are available\n            if (!specificCountries.length) {\n                return true;\n            }\n\n            for (key in specificCountries) {\n                if (countryId === specificCountries[key]) {\n                    return true;\n                }\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Braintree/js/view/payment/adapter.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'braintree',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function ($, braintree, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        apiClient: null,\n        config: {},\n        checkout: null,\n\n        /**\n         * Get Braintree api client\n         * @returns {Object}\n         */\n        getApiClient: function () {\n            if (!this.apiClient) {\n                this.apiClient = new braintree.api.Client({\n                    clientToken: this.getClientToken()\n                });\n            }\n\n            return this.apiClient;\n        },\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        setup: function () {\n            if (!this.getClientToken()) {\n                this.showError($t('Sorry, but something went wrong.'));\n            }\n\n            braintree.setup(this.getClientToken(), 'custom', this.config);\n        },\n\n        /**\n         * Get payment name\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'braintree';\n        },\n\n        /**\n         * Get client token\n         * @returns {String|*}\n         */\n        getClientToken: function () {\n\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n        }\n    };\n});\n","Magento_Braintree/js/view/payment/braintree.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        var config = window.checkoutConfig.payment,\n            braintreeType = 'braintree',\n            payPalType = 'braintree_paypal';\n\n        if (config[braintreeType].isActive) {\n            rendererList.push(\n                {\n                    type: braintreeType,\n                    component: 'Magento_Braintree/js/view/payment/method-renderer/hosted-fields'\n                }\n            );\n        }\n\n        if (config[payPalType].isActive) {\n            rendererList.push(\n                {\n                    type: payPalType,\n                    component: 'Magento_Braintree/js/view/payment/method-renderer/paypal'\n                }\n            );\n        }\n\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);\n","Magento_Braintree/js/view/payment/validator-handler.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Braintree/js/view/payment/3d-secure'\n], function ($, globalMessageList, verify3DSecure) {\n    'use strict';\n\n    return {\n        validators: [],\n\n        /**\n         * Get payment config\n         * @returns {Object}\n         */\n        getConfig: function () {\n            return window.checkoutConfig.payment;\n        },\n\n        /**\n         * Init list of validators\n         */\n        initialize: function () {\n            var config = this.getConfig();\n\n            if (config[verify3DSecure.getCode()].enabled) {\n                verify3DSecure.setConfig(config[verify3DSecure.getCode()]);\n                this.add(verify3DSecure);\n            }\n        },\n\n        /**\n         * Add new validator\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators\n         * @param {Object} context\n         * @param {Function} callback\n         */\n        validate: function (context, callback) {\n            var self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback();\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback();\n                }).fail(function (error) {\n                    self.showError(error);\n                });\n        },\n\n        /**\n         * Show error message\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n        }\n    };\n});\n","Magento_Braintree/js/view/payment/method-renderer/cc-form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Braintree/js/view/payment/adapter',\n        'mage/translate',\n        'Magento_Braintree/js/validator',\n        'Magento_Braintree/js/view/payment/validator-handler',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        quote,\n        braintree,\n        $t,\n        validator,\n        validatorManager,\n        fullScreenLoader\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                active: false,\n                braintreeClient: null,\n                braintreeDeviceData: null,\n                paymentMethodNonce: null,\n                lastBillingAddress: null,\n                validatorManager: validatorManager,\n                code: 'braintree',\n\n                /**\n                 * Additional payment data\n                 *\n                 * {Object}\n                 */\n                additionalData: {},\n\n                /**\n                 * Braintree client configuration\n                 *\n                 * {Object}\n                 */\n                clientConfig: {\n\n                    /**\n                     * Triggers on payment nonce receive\n                     * @param {Object} response\n                     */\n                    onPaymentMethodReceived: function (response) {\n                        this.beforePlaceOrder(response);\n                    },\n\n                    /**\n                     * Device data initialization\n                     *\n                     * @param {Object} checkout\n                     */\n                    onReady: function (checkout) {\n                        braintree.checkout = checkout;\n                    },\n\n                    /**\n                     * Triggers on any Braintree error\n                     * @param {Object} response\n                     */\n                    onError: function (response) {\n                        braintree.showError($t('Payment ' + this.getTitle() + ' can\\'t be initialized'));\n                        throw response.message;\n                    },\n\n                    /**\n                     * Triggers when customer click \"Cancel\"\n                     */\n                    onCancelled: function () {\n                        this.paymentMethodNonce = null;\n                    }\n                },\n                imports: {\n                    onActiveChange: 'active'\n                }\n            },\n\n            /**\n             * Set list of observable attributes\n             *\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                validator.setConfig(window.checkoutConfig.payment[this.getCode()]);\n                this._super()\n                    .observe(['active']);\n                this.validatorManager.initialize();\n                this.initClientConfig();\n\n                return this;\n            },\n\n            /**\n             * Get payment name\n             *\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Check if payment is active\n             *\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                var active = this.getCode() === this.isChecked();\n\n                this.active(active);\n\n                return active;\n            },\n\n            /**\n             * Triggers when payment method change\n             * @param {Boolean} isActive\n             */\n            onActiveChange: function (isActive) {\n                if (!isActive) {\n                    return;\n                }\n\n                this.initBraintree();\n            },\n\n            /**\n             * Init config\n             */\n            initClientConfig: function () {\n                // Advanced fraud tools settings\n                if (this.hasFraudProtection()) {\n                    this.clientConfig = _.extend(this.clientConfig, this.kountConfig());\n                }\n\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n            },\n\n            /**\n             * Init Braintree configuration\n             */\n            initBraintree: function () {\n                var intervalId = setInterval(function () {\n                    // stop loader when frame will be loaded\n                    if ($('#braintree-hosted-field-number').length) {\n                        clearInterval(intervalId);\n                        fullScreenLoader.stopLoader();\n                    }\n                }, 500);\n\n                if (braintree.checkout) {\n                    braintree.checkout.teardown(function () {\n                        braintree.checkout = null;\n                    });\n                }\n\n                fullScreenLoader.startLoader();\n                braintree.setConfig(this.clientConfig);\n                braintree.setup();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            kountConfig: function () {\n                var config = {\n                    dataCollector: {\n                        kount: {\n                            environment: this.getEnvironment()\n                        }\n                    },\n\n                    /**\n                     * Device data initialization\n                     *\n                     * @param {Object} checkout\n                     */\n                    onReady: function (checkout) {\n                        braintree.checkout = checkout;\n                        this.additionalData['device_data'] = checkout.deviceData;\n                    }\n                };\n\n                if (this.getKountMerchantId()) {\n                    config.dataCollector.kount.merchantId = this.getKountMerchantId();\n                }\n\n                return config;\n            },\n\n            /**\n             * Get full selector name\n             *\n             * @param {String} field\n             * @returns {String}\n             */\n            getSelector: function (field) {\n                return '#' + this.getCode() + '_' + field;\n            },\n\n            /**\n             * Get list of available CC types\n             *\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                var availableTypes = validator.getAvailableCardTypes(),\n                    billingAddress = quote.billingAddress(),\n                    billingCountryId;\n\n                this.lastBillingAddress = quote.shippingAddress();\n\n                if (!billingAddress) {\n                    billingAddress = this.lastBillingAddress;\n                }\n\n                billingCountryId = billingAddress.countryId;\n\n                if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n\n                    return validator.collectTypes(\n                        availableTypes, validator.getCountrySpecificCardTypes(billingCountryId)\n                    );\n                }\n\n                return availableTypes;\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            hasFraudProtection: function () {\n                return window.checkoutConfig.payment[this.getCode()].hasFraudProtection;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getEnvironment: function () {\n                return window.checkoutConfig.payment[this.getCode()].environment;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getKountMerchantId: function () {\n                return window.checkoutConfig.payment[this.getCode()].kountMerchantId;\n            },\n\n            /**\n             * Get data\n             *\n             * @returns {Object}\n             */\n            getData: function () {\n                var data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            /**\n             * Set payment nonce\n             * @param {String} paymentMethodNonce\n             */\n            setPaymentMethodNonce: function (paymentMethodNonce) {\n                this.paymentMethodNonce = paymentMethodNonce;\n            },\n\n            /**\n             * Prepare data to place order\n             * @param {Object} data\n             */\n            beforePlaceOrder: function (data) {\n                this.setPaymentMethodNonce(data.nonce);\n                this.placeOrder();\n            },\n\n            /**\n             * Action to place order\n             * @param {String} key\n             */\n            placeOrder: function (key) {\n                var self = this;\n\n                if (key) {\n                    return self._super();\n                }\n                // place order on success validation\n                self.validatorManager.validate(self, function () {\n                    return self.placeOrder('parent');\n                });\n\n                return false;\n            }\n        });\n    }\n);\n","Magento_Braintree/js/view/payment/method-renderer/hosted-fields.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Braintree/js/view/payment/method-renderer/cc-form',\n    'Magento_Braintree/js/validator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'mage/translate'\n], function ($, Component, validator, VaultEnabler, $t) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'Magento_Braintree/payment/form',\n            clientConfig: {\n\n                /**\n                 * {String}\n                 */\n                id: 'co-transparent-form-braintree'\n            },\n            isValidCardNumber: false\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this._super();\n\n            // Hosted fields settings\n            this.clientConfig.hostedFields = this.getHostedFields();\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = this._super();\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * Get Braintree Hosted Fields\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number')\n                    },\n                    expirationMonth: {\n                        selector: self.getSelector('expirationMonth'),\n                        placeholder: $t('MM')\n                    },\n                    expirationYear: {\n                        selector: self.getSelector('expirationYear'),\n                        placeholder: $t('YY')\n                    }\n                };\n\n            if (self.hasVerification()) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid')\n                };\n            }\n\n            /**\n             * Triggers on Hosted Field changes\n             * @param {Object} event\n             * @returns {Boolean}\n             */\n            fields.onFieldEvent = function (event) {\n                if (event.isEmpty === false) {\n                    self.validateCardType();\n                }\n\n                if (event.type !== 'fieldStateChange') {\n\n                    return false;\n                }\n\n                // Handle a change in validation or card type\n                if (event.target.fieldKey === 'number') {\n                    self.selectedCardType(null);\n                }\n\n                if (event.target.fieldKey === 'number' && event.card) {\n                    self.isValidCardNumber = event.isValid;\n                    self.selectedCardType(\n                        validator.getMageCardType(event.card.type, self.getCcAvailableTypes())\n                    );\n                }\n            };\n\n            return fields;\n        },\n\n        /**\n         * Validate current credit card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            var $selector = $(this.getSelector('cc_number')),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            $selector.removeClass(invalidClass);\n\n            if (this.selectedCardType() === null || !this.isValidCardNumber) {\n                $(this.getSelector('cc_number')).addClass(invalidClass);\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Trigger order placing\n         */\n        placeOrderClick: function () {\n            if (this.validateCardType()) {\n                $(this.getSelector('submit')).trigger('click');\n            }\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].ccVaultCode;\n        }\n    });\n});\n","Magento_Braintree/js/view/payment/method-renderer/paypal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/model/payment/additional-validators'\n], function ($, _, Component, Braintree, quote, fullScreenLoader, additionalValidators) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Braintree/payment/paypal',\n            code: 'braintree_paypal',\n            active: false,\n            paymentMethodNonce: null,\n            grandTotalAmount: null,\n\n            /**\n             * PayPal client configuration\n             * {Object}\n             */\n            clientConfig: {\n\n                /**\n                 * Triggers when widget is loaded\n                 * @param {Object} checkout\n                 */\n                onReady: function (checkout) {\n                    Braintree.checkout = checkout;\n                    this.enableButton();\n                },\n\n                /**\n                 * Triggers on payment nonce receive\n                 * @param {Object} response\n                 */\n                onPaymentMethodReceived: function (response) {\n                    this.beforePlaceOrder(response);\n                }\n            },\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super()\n                .observe(['active']);\n\n            this.grandTotalAmount = quote.totals()['base_grand_total'];\n\n            quote.totals.subscribe(function () {\n                if (self.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    self.grandTotalAmount = quote.totals()['base_grand_total'];\n                    self.reInitPayPal();\n                }\n            });\n\n            this.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Get payment name\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get payment title\n         *\n         * @returns {String}\n         */\n        getTitle: function () {\n            return window.checkoutConfig.payment[this.getCode()].title;\n        },\n\n        /**\n         * Check if payment is active\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            var active = this.getCode() === this.isChecked();\n\n            this.active(active);\n\n            return active;\n        },\n\n        /**\n         * Triggers when payment method change\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                return;\n            }\n\n            // need always re-init Braintree with PayPal configuration\n            this.reInitPayPal();\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n\n            Braintree.config = _.extend(Braintree.config, this.clientConfig);\n        },\n\n        /**\n         * Set payment nonce\n         * @param {String} paymentMethodNonce\n         */\n        setPaymentMethodNonce: function (paymentMethodNonce) {\n            this.paymentMethodNonce = paymentMethodNonce;\n        },\n\n        /**\n         * Update quote billing address\n         * @param {Object}customer\n         * @param {Object}address\n         */\n        setBillingAddress: function (customer, address) {\n            var billingAddress = {\n                street: [address.streetAddress],\n                city: address.locality,\n                regionCode: address.region,\n                postcode: address.postalCode,\n                countryId: address.countryCodeAlpha2,\n                firstname: customer.firstName,\n                lastname: customer.lastName,\n                telephone: customer.phone\n            };\n\n            quote.billingAddress(billingAddress);\n        },\n\n        /**\n         * Prepare data to place order\n         * @param {Object} data\n         */\n        beforePlaceOrder: function (data) {\n            this.setPaymentMethodNonce(data.nonce);\n\n            if (quote.billingAddress() === null && typeof data.details.billingAddress !== 'undefined') {\n                this.setBillingAddress(data.details, data.details.billingAddress);\n            }\n            this.placeOrder();\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            if (Braintree.checkout) {\n                Braintree.checkout.teardown(function () {\n                    Braintree.checkout = null;\n                });\n            }\n\n            this.disableButton();\n            this.clientConfig.paypal.amount = this.grandTotalAmount;\n\n            Braintree.setConfig(this.clientConfig);\n            Braintree.setup();\n        },\n\n        /**\n         * Triggers when customer click \"Continue to PayPal\" button\n         */\n        payWithPayPal: function () {\n            if (additionalValidators.validate()) {\n                Braintree.checkout.paypal.initAuthFlow();\n            }\n        },\n\n        /**\n         * Get locale\n         * @returns {String}\n         */\n        getLocale: function () {\n            return window.checkoutConfig.payment[this.getCode()].locale;\n        },\n\n        /**\n         * Is shipping address can be editable on PayPal side\n         * @returns {Boolean}\n         */\n        isAllowOverrideShippingAddress: function () {\n            return window.checkoutConfig.payment[this.getCode()].isAllowShippingAddressOverride;\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {};\n\n            config.paypal = {\n                container: 'paypal-container',\n                singleUse: true,\n                headless: true,\n                amount: this.grandTotalAmount,\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n                enableShippingAddress: true,\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            config.paypal.shippingAddressOverride = this.getShippingAddress();\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Get shipping address\n         * @returns {Object}\n         */\n        getShippingAddress: function () {\n            var address = quote.shippingAddress();\n\n            if (address.postcode === null) {\n\n                return {};\n            }\n\n            return {\n                recipientName: address.firstname + ' ' + address.lastname,\n                streetAddress: address.street[0],\n                locality: address.city,\n                countryCodeAlpha2: address.countryId,\n                postalCode: address.postcode,\n                region: address.regionCode,\n                phone: address.telephone,\n                editable: this.isAllowOverrideShippingAddress()\n            };\n        },\n\n        /**\n         * Get merchant name\n         * @returns {String}\n         */\n        getMerchantName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n        },\n\n        /**\n         * Returns payment acceptance mark image path\n         * @returns {String}\n         */\n        getPaymentAcceptanceMarkSrc: function () {\n\n            return window.checkoutConfig.payment[this.getCode()].paymentAcceptanceMarkSrc;\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader();\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader();\n        }\n    });\n});\n","Magento_Braintree/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'Magento_Braintree/js/view/payment/method-renderer/cc-form',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, Component, VaultComponent, globalMessageList, fullScreenLoader) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Vault/payment/form',\n            modules: {\n                hostedFields: '${ $.parentName }.braintree'\n            }\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.get(self.nonceUrl, {\n                'public_hash': self.publicHash\n            })\n                .done(function (response) {\n                    fullScreenLoader.stopLoader();\n                    self.hostedFields(function (formComponent) {\n                        formComponent.setPaymentMethodNonce(response.paymentMethodNonce);\n                        formComponent.additionalData['public_hash'] = self.publicHash;\n                        formComponent.code = self.code;\n                        formComponent.placeOrder();\n                    });\n                })\n                .fail(function (response) {\n                    var error = JSON.parse(response.responseText);\n\n                    fullScreenLoader.stopLoader();\n                    globalMessageList.addErrorMessage({\n                        message: error.message\n                    });\n                });\n        }\n    });\n});\n","Magento_Authorizenet/js/view/payment/authorizenet.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n        rendererList.push(\n            {\n                type: 'authorizenet_directpost',\n                component: 'Magento_Authorizenet/js/view/payment/method-renderer/authorizenet-directpost'\n            }\n        );\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);","Magento_Authorizenet/js/view/payment/method-renderer/authorizenet-directpost.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Payment/js/view/payment/iframe'\n    ],\n    function ($, Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Authorizenet/payment/authorizenet-directpost',\n                timeoutMessage: 'Sorry, but something went wrong. Please contact the seller.'\n            },\n            placeOrderHandler: null,\n            validateHandler: null,\n\n            /**\n             * @param {Object} handler\n             */\n            setPlaceOrderHandler: function (handler) {\n                this.placeOrderHandler = handler;\n            },\n\n            /**\n             * @param {Object} handler\n             */\n            setValidateHandler: function (handler) {\n                this.validateHandler = handler;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            context: function () {\n                return this;\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isShowLegend: function () {\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return 'authorizenet_directpost';\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                return true;\n            }\n        });\n    }\n);\n","Plazathemes_Bannerslider/js/owl.carousel.js":"/**\n * Copyright \u00c2\u00a9 2015 PlazaThemes.com. All rights reserved.\n *\n * @author PlazaThemes Team <contact@plazathemes.com>\n */\n\n/*\n *  jQuery OwlCarousel v1.3.3\n *\n *  Copyright (c) 2013 Bartosz Wojciechowski\n *  http://www.owlgraphic.com/owlcarousel/\n *\n *  Licensed under MIT\n *\n */\n\n/*JS Lint helpers: */\n/*global dragMove: false, dragEnd: false, $, jQuery, alert, window, document */\n/*jslint nomen: true, continue:true */\nif (typeof Object.create !== \"function\") {\n    Object.create = function (obj) {\n        function F() {}\n        F.prototype = obj;\n        return new F();\n    };\n}\nrequire([\n\t\"jquery\"\n], function($){\n\t(function ($, window, document) {\n\t\tvar Carousel = {\n\t\t\tinit : function (options, el) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.$elem = $(el);\n\t\t\t\tbase.options = $.extend({}, $.fn.owlCarousel.options, base.$elem.data(), options);\n\n\t\t\t\tbase.userOptions = options;\n\t\t\t\tbase.loadContent();\n\t\t\t},\n\n\t\t\tloadContent : function () {\n\t\t\t\tvar base = this, url;\n\n\t\t\t\tfunction getData(data) {\n\t\t\t\t\tvar i, content = \"\";\n\t\t\t\t\tif (typeof base.options.jsonSuccess === \"function\") {\n\t\t\t\t\t\tbase.options.jsonSuccess.apply(this, [data]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfor (i in data.owl) {\n\t\t\t\t\t\t\tif (data.owl.hasOwnProperty(i)) {\n\t\t\t\t\t\t\t\tcontent += data.owl[i].item;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbase.$elem.html(content);\n\t\t\t\t\t}\n\t\t\t\t\tbase.logIn();\n\t\t\t\t}\n\n\t\t\t\tif (typeof base.options.beforeInit === \"function\") {\n\t\t\t\t\tbase.options.beforeInit.apply(this, [base.$elem]);\n\t\t\t\t}\n\n\t\t\t\tif (typeof base.options.jsonPath === \"string\") {\n\t\t\t\t\turl = base.options.jsonPath;\n\t\t\t\t\t$.getJSON(url, getData);\n\t\t\t\t} else {\n\t\t\t\t\tbase.logIn();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlogIn : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.$elem.data(\"owl-originalStyles\", base.$elem.attr(\"style\"));\n\t\t\t\tbase.$elem.data(\"owl-originalClasses\", base.$elem.attr(\"class\"));\n\n\t\t\t\tbase.$elem.css({opacity: 0});\n\t\t\t\tbase.orignalItems = base.options.items;\n\t\t\t\tbase.checkBrowser();\n\t\t\t\tbase.wrapperWidth = 0;\n\t\t\t\tbase.checkVisible = null;\n\t\t\t\tbase.setVars();\n\t\t\t},\n\n\t\t\tsetVars : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.$elem.children().length === 0) {return false; }\n\t\t\t\tbase.baseClass();\n\t\t\t\tbase.eventTypes();\n\t\t\t\tbase.$userItems = base.$elem.children();\n\t\t\t\tbase.itemsAmount = base.$userItems.length;\n\t\t\t\tbase.wrapItems();\n\t\t\t\tbase.$owlItems = base.$elem.find(\".owl-item\");\n\t\t\t\tbase.$owlWrapper = base.$elem.find(\".owl-wrapper\");\n\t\t\t\tbase.playDirection = \"next\";\n\t\t\t\tbase.prevItem = 0;\n\t\t\t\tbase.prevArr = [0];\n\t\t\t\tbase.currentItem = 0;\n\t\t\t\tbase.customEvents();\n\t\t\t\tbase.onStartup();\n\t\t\t},\n\n\t\t\tonStartup : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.updateItems();\n\t\t\t\tbase.calculateAll();\n\t\t\t\tbase.buildControls();\n\t\t\t\tbase.updateControls();\n\t\t\t\tbase.response();\n\t\t\t\tbase.moveEvents();\n\t\t\t\tbase.stopOnHover();\n\t\t\t\tbase.owlStatus();\n\n\t\t\t\tif (base.options.transitionStyle !== false) {\n\t\t\t\t\tbase.transitionTypes(base.options.transitionStyle);\n\t\t\t\t}\n\t\t\t\tif (base.options.autoPlay === true) {\n\t\t\t\t\tbase.options.autoPlay = 5000;\n\t\t\t\t}\n\t\t\t\tbase.play();\n\n\t\t\t\tbase.$elem.find(\".owl-wrapper\").css(\"display\", \"block\");\n\n\t\t\t\tif (!base.$elem.is(\":visible\")) {\n\t\t\t\t\tbase.watchVisibility();\n\t\t\t\t} else {\n\t\t\t\t\tbase.$elem.css(\"opacity\", 1);\n\t\t\t\t}\n\t\t\t\tbase.onstartup = false;\n\t\t\t\tbase.eachMoveUpdate();\n\t\t\t\tif (typeof base.options.afterInit === \"function\") {\n\t\t\t\t\tbase.options.afterInit.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\teachMoveUpdate : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.options.lazyLoad === true) {\n\t\t\t\t\tbase.lazyLoad();\n\t\t\t\t}\n\t\t\t\tif (base.options.autoHeight === true) {\n\t\t\t\t\tbase.autoHeight();\n\t\t\t\t}\n\t\t\t\tbase.onVisibleItems();\n\n\t\t\t\tif (typeof base.options.afterAction === \"function\") {\n\t\t\t\t\tbase.options.afterAction.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateVars : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (typeof base.options.beforeUpdate === \"function\") {\n\t\t\t\t\tbase.options.beforeUpdate.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tbase.watchVisibility();\n\t\t\t\tbase.updateItems();\n\t\t\t\tbase.calculateAll();\n\t\t\t\tbase.updatePosition();\n\t\t\t\tbase.updateControls();\n\t\t\t\tbase.eachMoveUpdate();\n\t\t\t\tif (typeof base.options.afterUpdate === \"function\") {\n\t\t\t\t\tbase.options.afterUpdate.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\treload : function () {\n\t\t\t\tvar base = this;\n\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\tbase.updateVars();\n\t\t\t\t}, 0);\n\t\t\t},\n\n\t\t\twatchVisibility : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.$elem.is(\":visible\") === false) {\n\t\t\t\t\tbase.$elem.css({opacity: 0});\n\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\t} else {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.checkVisible = window.setInterval(function () {\n\t\t\t\t\tif (base.$elem.is(\":visible\")) {\n\t\t\t\t\t\tbase.reload();\n\t\t\t\t\t\tbase.$elem.animate({opacity: 1}, 200);\n\t\t\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\t\t}\n\t\t\t\t}, 500);\n\t\t\t},\n\n\t\t\twrapItems : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$userItems.wrapAll(\"<div class=\\\"owl-wrapper\\\">\").wrap(\"<div class=\\\"owl-item\\\"></div>\");\n\t\t\t\tbase.$elem.find(\".owl-wrapper\").wrap(\"<div class=\\\"owl-wrapper-outer\\\">\");\n\t\t\t\tbase.wrapperOuter = base.$elem.find(\".owl-wrapper-outer\");\n\t\t\t\tbase.$elem.css(\"display\", \"block\");\n\t\t\t},\n\n\t\t\tbaseClass : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\thasBaseClass = base.$elem.hasClass(base.options.baseClass),\n\t\t\t\t\thasThemeClass = base.$elem.hasClass(base.options.theme);\n\n\t\t\t\tif (!hasBaseClass) {\n\t\t\t\t\tbase.$elem.addClass(base.options.baseClass);\n\t\t\t\t}\n\n\t\t\t\tif (!hasThemeClass) {\n\t\t\t\t\tbase.$elem.addClass(base.options.theme);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateItems : function () {\n\t\t\t\tvar base = this, width, i;\n\n\t\t\t\tif (base.options.responsive === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (base.options.singleItem === true) {\n\t\t\t\t\tbase.options.items = base.orignalItems = 1;\n\t\t\t\t\tbase.options.itemsCustom = false;\n\t\t\t\t\tbase.options.itemsDesktop = false;\n\t\t\t\t\tbase.options.itemsDesktopSmall = false;\n\t\t\t\t\tbase.options.itemsTablet = false;\n\t\t\t\t\tbase.options.itemsTabletSmall = false;\n\t\t\t\t\tbase.options.itemsMobile = false;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\twidth = $(base.options.responsiveBaseWidth).width();\n\n\t\t\t\tif (width > (base.options.itemsDesktop[0] || base.orignalItems)) {\n\t\t\t\t\tbase.options.items = base.orignalItems;\n\t\t\t\t}\n\t\t\t\tif (base.options.itemsCustom !== false) {\n\t\t\t\t\t//Reorder array by screen size\n\t\t\t\t\tbase.options.itemsCustom.sort(function (a, b) {return a[0] - b[0]; });\n\n\t\t\t\t\tfor (i = 0; i < base.options.itemsCustom.length; i += 1) {\n\t\t\t\t\t\tif (base.options.itemsCustom[i][0] <= width) {\n\t\t\t\t\t\t\tbase.options.items = base.options.itemsCustom[i][1];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\tif (width <= base.options.itemsDesktop[0] && base.options.itemsDesktop !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsDesktop[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsDesktopSmall[0] && base.options.itemsDesktopSmall !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsDesktopSmall[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsTablet[0] && base.options.itemsTablet !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsTablet[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsTabletSmall[0] && base.options.itemsTabletSmall !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsTabletSmall[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsMobile[0] && base.options.itemsMobile !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsMobile[1];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t//if number of items is less than declared\n\t\t\t\tif (base.options.items > base.itemsAmount && base.options.itemsScaleUp === true) {\n\t\t\t\t\tbase.options.items = base.itemsAmount;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tresponse : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tsmallDelay,\n\t\t\t\t\tlastWindowWidth;\n\n\t\t\t\tif (base.options.responsive !== true) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tlastWindowWidth = $(window).width();\n\n\t\t\t\tbase.resizer = function () {\n\t\t\t\t\tif ($(window).width() !== lastWindowWidth) {\n\t\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\t\t}\n\t\t\t\t\t\twindow.clearTimeout(smallDelay);\n\t\t\t\t\t\tsmallDelay = window.setTimeout(function () {\n\t\t\t\t\t\t\tlastWindowWidth = $(window).width();\n\t\t\t\t\t\t\tbase.updateVars();\n\t\t\t\t\t\t}, base.options.responsiveRefreshRate);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t\t$(window).resize(base.resizer);\n\t\t\t},\n\n\t\t\tupdatePosition : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.jumpTo(base.currentItem);\n\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\tbase.checkAp();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tappendItemsSizes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\troundPages = 0,\n\t\t\t\t\tlastItem = base.itemsAmount - base.options.items;\n\n\t\t\t\tbase.$owlItems.each(function (index) {\n\t\t\t\t\tvar $this = $(this);\n\t\t\t\t\t$this\n\t\t\t\t\t\t.css({\"width\": base.itemWidth})\n\t\t\t\t\t\t.data(\"owl-item\", Number(index));\n\n\t\t\t\t\tif (index % base.options.items === 0 || index === lastItem) {\n\t\t\t\t\t\tif (!(index > lastItem)) {\n\t\t\t\t\t\t\troundPages += 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\t$this.data(\"owl-roundPages\", roundPages);\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tappendWrapperSizes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\twidth = base.$owlItems.length * base.itemWidth;\n\n\t\t\t\tbase.$owlWrapper.css({\n\t\t\t\t\t\"width\": width * 2,\n\t\t\t\t\t\"left\": 0\n\t\t\t\t});\n\t\t\t\tbase.appendItemsSizes();\n\t\t\t},\n\n\t\t\tcalculateAll : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.calculateWidth();\n\t\t\t\tbase.appendWrapperSizes();\n\t\t\t\tbase.loops();\n\t\t\t\tbase.max();\n\t\t\t},\n\n\t\t\tcalculateWidth : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.itemWidth = Math.round(base.$elem.width() / base.options.items);\n\t\t\t},\n\n\t\t\tmax : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tmaximum = ((base.itemsAmount * base.itemWidth) - base.options.items * base.itemWidth) * -1;\n\t\t\t\tif (base.options.items > base.itemsAmount) {\n\t\t\t\t\tbase.maximumItem = 0;\n\t\t\t\t\tmaximum = 0;\n\t\t\t\t\tbase.maximumPixels = 0;\n\t\t\t\t} else {\n\t\t\t\t\tbase.maximumItem = base.itemsAmount - base.options.items;\n\t\t\t\t\tbase.maximumPixels = maximum;\n\t\t\t\t}\n\t\t\t\treturn maximum;\n\t\t\t},\n\n\t\t\tmin : function () {\n\t\t\t\treturn 0;\n\t\t\t},\n\n\t\t\tloops : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tprev = 0,\n\t\t\t\t\telWidth = 0,\n\t\t\t\t\ti,\n\t\t\t\t\titem,\n\t\t\t\t\troundPageNum;\n\n\t\t\t\tbase.positionsInArray = [0];\n\t\t\t\tbase.pagesInArray = [];\n\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\telWidth += base.itemWidth;\n\t\t\t\t\tbase.positionsInArray.push(-elWidth);\n\n\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\titem = $(base.$owlItems[i]);\n\t\t\t\t\t\troundPageNum = item.data(\"owl-roundPages\");\n\t\t\t\t\t\tif (roundPageNum !== prev) {\n\t\t\t\t\t\t\tbase.pagesInArray[prev] = base.positionsInArray[i];\n\t\t\t\t\t\t\tprev = roundPageNum;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbuildControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.navigation === true || base.options.pagination === true) {\n\t\t\t\t\tbase.owlControls = $(\"<div class=\\\"owl-controls\\\"/>\").toggleClass(\"clickable\", !base.browser.isTouch).appendTo(base.$elem);\n\t\t\t\t}\n\t\t\t\tif (base.options.pagination === true) {\n\t\t\t\t\tbase.buildPagination();\n\t\t\t\t}\n\t\t\t\tif (base.options.navigation === true) {\n\t\t\t\t\tbase.buildButtons();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbuildButtons : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tbuttonsWrapper = $(\"<div class=\\\"owl-buttons\\\"/>\");\n\t\t\t\tbase.owlControls.append(buttonsWrapper);\n\n\t\t\t\tbase.buttonPrev = $(\"<div/>\", {\n\t\t\t\t\t\"class\" : \"owl-prev\",\n\t\t\t\t\t\"html\" : base.options.navigationText[0] || \"\"\n\t\t\t\t});\n\n\t\t\t\tbase.buttonNext = $(\"<div/>\", {\n\t\t\t\t\t\"class\" : \"owl-next\",\n\t\t\t\t\t\"html\" : base.options.navigationText[1] || \"\"\n\t\t\t\t});\n\n\t\t\t\tbuttonsWrapper\n\t\t\t\t\t.append(base.buttonPrev)\n\t\t\t\t\t.append(base.buttonNext);\n\n\t\t\t\tbuttonsWrapper.on(\"touchstart.owlControls mousedown.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t});\n\n\t\t\t\tbuttonsWrapper.on(\"touchend.owlControls mouseup.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif ($(this).hasClass(\"owl-next\")) {\n\t\t\t\t\t\tbase.next();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.prev();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tbuildPagination : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.paginationWrapper = $(\"<div class=\\\"owl-pagination\\\"/>\");\n\t\t\t\tbase.owlControls.append(base.paginationWrapper);\n\n\t\t\t\tbase.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\", \".owl-page\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif (Number($(this).data(\"owl-page\")) !== base.currentItem) {\n\t\t\t\t\t\tbase.goTo(Number($(this).data(\"owl-page\")), true);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tupdatePagination : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tcounter,\n\t\t\t\t\tlastPage,\n\t\t\t\t\tlastItem,\n\t\t\t\t\ti,\n\t\t\t\t\tpaginationButton,\n\t\t\t\t\tpaginationButtonInner;\n\n\t\t\t\tif (base.options.pagination === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tbase.paginationWrapper.html(\"\");\n\n\t\t\t\tcounter = 0;\n\t\t\t\tlastPage = base.itemsAmount - base.itemsAmount % base.options.items;\n\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\tif (i % base.options.items === 0) {\n\t\t\t\t\t\tcounter += 1;\n\t\t\t\t\t\tif (lastPage === i) {\n\t\t\t\t\t\t\tlastItem = base.itemsAmount - base.options.items;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tpaginationButton = $(\"<div/>\", {\n\t\t\t\t\t\t\t\"class\" : \"owl-page\"\n\t\t\t\t\t\t});\n\t\t\t\t\t\tpaginationButtonInner = $(\"<span></span>\", {\n\t\t\t\t\t\t\t\"text\": base.options.paginationNumbers === true ? counter : \"\",\n\t\t\t\t\t\t\t\"class\": base.options.paginationNumbers === true ? \"owl-numbers\" : \"\"\n\t\t\t\t\t\t});\n\t\t\t\t\t\tpaginationButton.append(paginationButtonInner);\n\n\t\t\t\t\t\tpaginationButton.data(\"owl-page\", lastPage === i ? lastItem : i);\n\t\t\t\t\t\tpaginationButton.data(\"owl-roundPages\", counter);\n\n\t\t\t\t\t\tbase.paginationWrapper.append(paginationButton);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.checkPagination();\n\t\t\t},\n\t\t\tcheckPagination : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.pagination === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.paginationWrapper.find(\".owl-page\").each(function () {\n\t\t\t\t\tif ($(this).data(\"owl-roundPages\") === $(base.$owlItems[base.currentItem]).data(\"owl-roundPages\")) {\n\t\t\t\t\t\tbase.paginationWrapper\n\t\t\t\t\t\t\t.find(\".owl-page\")\n\t\t\t\t\t\t\t.removeClass(\"active\");\n\t\t\t\t\t\t$(this).addClass(\"active\");\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tcheckNavigation : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.options.navigation === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (base.options.rewindNav === false) {\n\t\t\t\t\tif (base.currentItem === 0 && base.maximumItem === 0) {\n\t\t\t\t\t\tbase.buttonPrev.addClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.addClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem === 0 && base.maximumItem !== 0) {\n\t\t\t\t\t\tbase.buttonPrev.addClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.removeClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem === base.maximumItem) {\n\t\t\t\t\t\tbase.buttonPrev.removeClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.addClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem !== 0 && base.currentItem !== base.maximumItem) {\n\t\t\t\t\t\tbase.buttonPrev.removeClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.removeClass(\"disabled\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.updatePagination();\n\t\t\t\tbase.checkNavigation();\n\t\t\t\tif (base.owlControls) {\n\t\t\t\t\tif (base.options.items >= base.itemsAmount) {\n\t\t\t\t\t\tbase.owlControls.hide();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.owlControls.show();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tdestroyControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.owlControls) {\n\t\t\t\t\tbase.owlControls.remove();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tnext : function (speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tbase.currentItem += base.options.scrollPerPage === true ? base.options.items : 1;\n\t\t\t\tif (base.currentItem > base.maximumItem + (base.options.scrollPerPage === true ? (base.options.items - 1) : 0)) {\n\t\t\t\t\tif (base.options.rewindNav === true) {\n\t\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t\t\tspeed = \"rewind\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.goTo(base.currentItem, speed);\n\t\t\t},\n\n\t\t\tprev : function (speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tif (base.options.scrollPerPage === true && base.currentItem > 0 && base.currentItem < base.options.items) {\n\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t} else {\n\t\t\t\t\tbase.currentItem -= base.options.scrollPerPage === true ? base.options.items : 1;\n\t\t\t\t}\n\t\t\t\tif (base.currentItem < 0) {\n\t\t\t\t\tif (base.options.rewindNav === true) {\n\t\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\t\tspeed = \"rewind\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.goTo(base.currentItem, speed);\n\t\t\t},\n\n\t\t\tgoTo : function (position, speed, drag) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tgoToPixel;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (typeof base.options.beforeMove === \"function\") {\n\t\t\t\t\tbase.options.beforeMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tif (position >= base.maximumItem) {\n\t\t\t\t\tposition = base.maximumItem;\n\t\t\t\t} else if (position <= 0) {\n\t\t\t\t\tposition = 0;\n\t\t\t\t}\n\n\t\t\t\tbase.currentItem = base.owl.currentItem = position;\n\t\t\t\tif (base.options.transitionStyle !== false && drag !== \"drag\" && base.options.items === 1 && base.browser.support3d === true) {\n\t\t\t\t\tbase.swapSpeed(0);\n\t\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\t\tbase.transition3d(base.positionsInArray[position]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2slide(base.positionsInArray[position], 1);\n\t\t\t\t\t}\n\t\t\t\t\tbase.afterGo();\n\t\t\t\t\tbase.singleItemTransition();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tgoToPixel = base.positionsInArray[position];\n\n\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\tbase.isCss3Finish = false;\n\n\t\t\t\t\tif (speed === true) {\n\t\t\t\t\t\tbase.swapSpeed(\"paginationSpeed\");\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.paginationSpeed);\n\n\t\t\t\t\t} else if (speed === \"rewind\") {\n\t\t\t\t\t\tbase.swapSpeed(base.options.rewindSpeed);\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.rewindSpeed);\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.swapSpeed(\"slideSpeed\");\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.slideSpeed);\n\t\t\t\t\t}\n\t\t\t\t\tbase.transition3d(goToPixel);\n\t\t\t\t} else {\n\t\t\t\t\tif (speed === true) {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.paginationSpeed);\n\t\t\t\t\t} else if (speed === \"rewind\") {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.rewindSpeed);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.slideSpeed);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.afterGo();\n\t\t\t},\n\n\t\t\tjumpTo : function (position) {\n\t\t\t\tvar base = this;\n\t\t\t\tif (typeof base.options.beforeMove === \"function\") {\n\t\t\t\t\tbase.options.beforeMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tif (position >= base.maximumItem || position === -1) {\n\t\t\t\t\tposition = base.maximumItem;\n\t\t\t\t} else if (position <= 0) {\n\t\t\t\t\tposition = 0;\n\t\t\t\t}\n\t\t\t\tbase.swapSpeed(0);\n\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\tbase.transition3d(base.positionsInArray[position]);\n\t\t\t\t} else {\n\t\t\t\t\tbase.css2slide(base.positionsInArray[position], 1);\n\t\t\t\t}\n\t\t\t\tbase.currentItem = base.owl.currentItem = position;\n\t\t\t\tbase.afterGo();\n\t\t\t},\n\n\t\t\tafterGo : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.prevArr.push(base.currentItem);\n\t\t\t\tbase.prevItem = base.owl.prevItem = base.prevArr[base.prevArr.length - 2];\n\t\t\t\tbase.prevArr.shift(0);\n\n\t\t\t\tif (base.prevItem !== base.currentItem) {\n\t\t\t\t\tbase.checkPagination();\n\t\t\t\t\tbase.checkNavigation();\n\t\t\t\t\tbase.eachMoveUpdate();\n\n\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\tbase.checkAp();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (typeof base.options.afterMove === \"function\" && base.prevItem !== base.currentItem) {\n\t\t\t\t\tbase.options.afterMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tstop : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.apStatus = \"stop\";\n\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t},\n\n\t\t\tcheckAp : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.apStatus !== \"stop\") {\n\t\t\t\t\tbase.play();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tplay : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.apStatus = \"play\";\n\t\t\t\tif (base.options.autoPlay === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\tbase.autoPlayInterval = window.setInterval(function () {\n\t\t\t\t\tbase.next(true);\n\t\t\t\t}, base.options.autoPlay);\n\t\t\t},\n\n\t\t\tswapSpeed : function (action) {\n\t\t\t\tvar base = this;\n\t\t\t\tif (action === \"slideSpeed\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(base.options.slideSpeed));\n\t\t\t\t} else if (action === \"paginationSpeed\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(base.options.paginationSpeed));\n\t\t\t\t} else if (typeof action !== \"string\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(action));\n\t\t\t\t}\n\t\t\t},\n\n\t\t\taddCssSpeed : function (speed) {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"-moz-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"-o-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"transition\": \"all \" + speed + \"ms ease\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tremoveTransition : function () {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transition\": \"\",\n\t\t\t\t\t\"-moz-transition\": \"\",\n\t\t\t\t\t\"-o-transition\": \"\",\n\t\t\t\t\t\"transition\": \"\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tdoTranslate : function (pixels) {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-moz-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-o-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-ms-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"transform\": \"translate3d(\" + pixels + \"px, 0px,0px)\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\ttransition3d : function (value) {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$owlWrapper.css(base.doTranslate(value));\n\t\t\t},\n\n\t\t\tcss2move : function (value) {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$owlWrapper.css({\"left\" : value});\n\t\t\t},\n\n\t\t\tcss2slide : function (value, speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.isCssFinish = false;\n\t\t\t\tbase.$owlWrapper.stop(true, true).animate({\n\t\t\t\t\t\"left\" : value\n\t\t\t\t}, {\n\t\t\t\t\tduration : speed || base.options.slideSpeed,\n\t\t\t\t\tcomplete : function () {\n\t\t\t\t\t\tbase.isCssFinish = true;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tcheckBrowser : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ttranslate3D = \"translate3d(0px, 0px, 0px)\",\n\t\t\t\t\ttempElem = document.createElement(\"div\"),\n\t\t\t\t\tregex,\n\t\t\t\t\tasSupport,\n\t\t\t\t\tsupport3d,\n\t\t\t\t\tisTouch;\n\n\t\t\t\ttempElem.style.cssText = \"  -moz-transform:\" + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -ms-transform:\"     + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -o-transform:\"      + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -webkit-transform:\" + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; transform:\"         + translate3D;\n\t\t\t\tregex = /translate3d\\(0px, 0px, 0px\\)/g;\n\t\t\t\tasSupport = tempElem.style.cssText.match(regex);\n\t\t\t\tsupport3d = (asSupport !== null && asSupport.length === 1);\n\n\t\t\t\tisTouch = \"ontouchstart\" in window || window.navigator.msMaxTouchPoints;\n\n\t\t\t\tbase.browser = {\n\t\t\t\t\t\"support3d\" : support3d,\n\t\t\t\t\t\"isTouch\" : isTouch\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tmoveEvents : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.mouseDrag !== false || base.options.touchDrag !== false) {\n\t\t\t\t\tbase.gestures();\n\t\t\t\t\tbase.disabledEvents();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\teventTypes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ttypes = [\"s\", \"e\", \"x\"];\n\n\t\t\t\tbase.ev_types = {};\n\n\t\t\t\tif (base.options.mouseDrag === true && base.options.touchDrag === true) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"touchstart.owl mousedown.owl\",\n\t\t\t\t\t\t\"touchmove.owl mousemove.owl\",\n\t\t\t\t\t\t\"touchend.owl touchcancel.owl mouseup.owl\"\n\t\t\t\t\t];\n\t\t\t\t} else if (base.options.mouseDrag === false && base.options.touchDrag === true) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"touchstart.owl\",\n\t\t\t\t\t\t\"touchmove.owl\",\n\t\t\t\t\t\t\"touchend.owl touchcancel.owl\"\n\t\t\t\t\t];\n\t\t\t\t} else if (base.options.mouseDrag === true && base.options.touchDrag === false) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"mousedown.owl\",\n\t\t\t\t\t\t\"mousemove.owl\",\n\t\t\t\t\t\t\"mouseup.owl\"\n\t\t\t\t\t];\n\t\t\t\t}\n\n\t\t\t\tbase.ev_types.start = types[0];\n\t\t\t\tbase.ev_types.move = types[1];\n\t\t\t\tbase.ev_types.end = types[2];\n\t\t\t},\n\n\t\t\tdisabledEvents :  function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.on(\"dragstart.owl\", function (event) { event.preventDefault(); });\n\t\t\t\tbase.$elem.on(\"mousedown.disableTextSelect\", function (e) {\n\t\t\t\t\treturn $(e.target).is('input, textarea, select, option');\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tgestures : function () {\n\t\t\t\t/*jslint unparam: true*/\n\t\t\t\tvar base = this,\n\t\t\t\t\tlocals = {\n\t\t\t\t\t\toffsetX : 0,\n\t\t\t\t\t\toffsetY : 0,\n\t\t\t\t\t\tbaseElWidth : 0,\n\t\t\t\t\t\trelativePos : 0,\n\t\t\t\t\t\tposition: null,\n\t\t\t\t\t\tminSwipe : null,\n\t\t\t\t\t\tmaxSwipe: null,\n\t\t\t\t\t\tsliding : null,\n\t\t\t\t\t\tdargging: null,\n\t\t\t\t\t\ttargetElement : null\n\t\t\t\t\t};\n\n\t\t\t\tbase.isCssFinish = true;\n\n\t\t\t\tfunction getTouches(event) {\n\t\t\t\t\tif (event.touches !== undefined) {\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tx : event.touches[0].pageX,\n\t\t\t\t\t\t\ty : event.touches[0].pageY\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tif (event.touches === undefined) {\n\t\t\t\t\t\tif (event.pageX !== undefined) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tx : event.pageX,\n\t\t\t\t\t\t\t\ty : event.pageY\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (event.pageX === undefined) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tx : event.clientX,\n\t\t\t\t\t\t\t\ty : event.clientY\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction swapEvents(type) {\n\t\t\t\t\tif (type === \"on\") {\n\t\t\t\t\t\t$(document).on(base.ev_types.move, dragMove);\n\t\t\t\t\t\t$(document).on(base.ev_types.end, dragEnd);\n\t\t\t\t\t} else if (type === \"off\") {\n\t\t\t\t\t\t$(document).off(base.ev_types.move);\n\t\t\t\t\t\t$(document).off(base.ev_types.end);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction dragStart(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tposition;\n\n\t\t\t\t\tif (ev.which === 3) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.itemsAmount <= base.options.items) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.isCssFinish === false && !base.options.dragBeforeAnimFinish) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.isCss3Finish === false && !base.options.dragBeforeAnimFinish) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.browser.isTouch !== true && !base.$owlWrapper.hasClass(\"grabbing\")) {\n\t\t\t\t\t\tbase.$owlWrapper.addClass(\"grabbing\");\n\t\t\t\t\t}\n\n\t\t\t\t\tbase.newPosX = 0;\n\t\t\t\t\tbase.newRelativeX = 0;\n\n\t\t\t\t\t$(this).css(base.removeTransition());\n\n\t\t\t\t\tposition = $(this).position();\n\t\t\t\t\tlocals.relativePos = position.left;\n\n\t\t\t\t\tlocals.offsetX = getTouches(ev).x - position.left;\n\t\t\t\t\tlocals.offsetY = getTouches(ev).y - position.top;\n\n\t\t\t\t\tswapEvents(\"on\");\n\n\t\t\t\t\tlocals.sliding = false;\n\t\t\t\t\tlocals.targetElement = ev.target || ev.srcElement;\n\t\t\t\t}\n\n\t\t\t\tfunction dragMove(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tminSwipe,\n\t\t\t\t\t\tmaxSwipe;\n\n\t\t\t\t\tbase.newPosX = getTouches(ev).x - locals.offsetX;\n\t\t\t\t\tbase.newPosY = getTouches(ev).y - locals.offsetY;\n\t\t\t\t\tbase.newRelativeX = base.newPosX - locals.relativePos;\n\n\t\t\t\t\tif (typeof base.options.startDragging === \"function\" && locals.dragging !== true && base.newRelativeX !== 0) {\n\t\t\t\t\t\tlocals.dragging = true;\n\t\t\t\t\t\tbase.options.startDragging.apply(base, [base.$elem]);\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((base.newRelativeX > 8 || base.newRelativeX < -8) && (base.browser.isTouch === true)) {\n\t\t\t\t\t\tif (ev.preventDefault !== undefined) {\n\t\t\t\t\t\t\tev.preventDefault();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tev.returnValue = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tlocals.sliding = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((base.newPosY > 10 || base.newPosY < -10) && locals.sliding === false) {\n\t\t\t\t\t\t$(document).off(\"touchmove.owl\");\n\t\t\t\t\t}\n\n\t\t\t\t\tminSwipe = function () {\n\t\t\t\t\t\treturn base.newRelativeX / 5;\n\t\t\t\t\t};\n\n\t\t\t\t\tmaxSwipe = function () {\n\t\t\t\t\t\treturn base.maximumPixels + base.newRelativeX / 5;\n\t\t\t\t\t};\n\n\t\t\t\t\tbase.newPosX = Math.max(Math.min(base.newPosX, minSwipe()), maxSwipe());\n\t\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\t\tbase.transition3d(base.newPosX);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2move(base.newPosX);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction dragEnd(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tnewPosition,\n\t\t\t\t\t\thandlers,\n\t\t\t\t\t\towlStopEvent;\n\n\t\t\t\t\tev.target = ev.target || ev.srcElement;\n\n\t\t\t\t\tlocals.dragging = false;\n\n\t\t\t\t\tif (base.browser.isTouch !== true) {\n\t\t\t\t\t\tbase.$owlWrapper.removeClass(\"grabbing\");\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.newRelativeX < 0) {\n\t\t\t\t\t\tbase.dragDirection = base.owl.dragDirection = \"left\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.dragDirection = base.owl.dragDirection = \"right\";\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.newRelativeX !== 0) {\n\t\t\t\t\t\tnewPosition = base.getNewPosition();\n\t\t\t\t\t\tbase.goTo(newPosition, false, \"drag\");\n\t\t\t\t\t\tif (locals.targetElement === ev.target && base.browser.isTouch !== true) {\n\t\t\t\t\t\t\t$(ev.target).on(\"click.disable\", function (ev) {\n\t\t\t\t\t\t\t\tev.stopImmediatePropagation();\n\t\t\t\t\t\t\t\tev.stopPropagation();\n\t\t\t\t\t\t\t\tev.preventDefault();\n\t\t\t\t\t\t\t\t$(ev.target).off(\"click.disable\");\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\thandlers = $._data(ev.target, \"events\").click;\n\t\t\t\t\t\t\towlStopEvent = handlers.pop();\n\t\t\t\t\t\t\thandlers.splice(0, 0, owlStopEvent);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tswapEvents(\"off\");\n\t\t\t\t}\n\t\t\t\tbase.$elem.on(base.ev_types.start, \".owl-wrapper\", dragStart);\n\t\t\t},\n\n\t\t\tgetNewPosition : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tnewPosition = base.closestItem();\n\n\t\t\t\tif (newPosition > base.maximumItem) {\n\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\tnewPosition  = base.maximumItem;\n\t\t\t\t} else if (base.newPosX >= 0) {\n\t\t\t\t\tnewPosition = 0;\n\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t}\n\t\t\t\treturn newPosition;\n\t\t\t},\n\t\t\tclosestItem : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tarray = base.options.scrollPerPage === true ? base.pagesInArray : base.positionsInArray,\n\t\t\t\t\tgoal = base.newPosX,\n\t\t\t\t\tclosest = null;\n\n\t\t\t\t$.each(array, function (i, v) {\n\t\t\t\t\tif (goal - (base.itemWidth / 20) > array[i + 1] && goal - (base.itemWidth / 20) < v && base.moveDirection() === \"left\") {\n\t\t\t\t\t\tclosest = v;\n\t\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\t\tbase.currentItem = $.inArray(closest, base.positionsInArray);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tbase.currentItem = i;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if (goal + (base.itemWidth / 20) < v && goal + (base.itemWidth / 20) > (array[i + 1] || array[i] - base.itemWidth) && base.moveDirection() === \"right\") {\n\t\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\t\tclosest = array[i + 1] || array[array.length - 1];\n\t\t\t\t\t\t\tbase.currentItem = $.inArray(closest, base.positionsInArray);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tclosest = array[i + 1];\n\t\t\t\t\t\t\tbase.currentItem = i + 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn base.currentItem;\n\t\t\t},\n\n\t\t\tmoveDirection : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tdirection;\n\t\t\t\tif (base.newRelativeX < 0) {\n\t\t\t\t\tdirection = \"right\";\n\t\t\t\t\tbase.playDirection = \"next\";\n\t\t\t\t} else {\n\t\t\t\t\tdirection = \"left\";\n\t\t\t\t\tbase.playDirection = \"prev\";\n\t\t\t\t}\n\t\t\t\treturn direction;\n\t\t\t},\n\n\t\t\tcustomEvents : function () {\n\t\t\t\t/*jslint unparam: true*/\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.on(\"owl.next\", function () {\n\t\t\t\t\tbase.next();\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.prev\", function () {\n\t\t\t\t\tbase.prev();\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.play\", function (event, speed) {\n\t\t\t\t\tbase.options.autoPlay = speed;\n\t\t\t\t\tbase.play();\n\t\t\t\t\tbase.hoverStatus = \"play\";\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.stop\", function () {\n\t\t\t\t\tbase.stop();\n\t\t\t\t\tbase.hoverStatus = \"stop\";\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.goTo\", function (event, item) {\n\t\t\t\t\tbase.goTo(item);\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.jumpTo\", function (event, item) {\n\t\t\t\t\tbase.jumpTo(item);\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tstopOnHover : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.stopOnHover === true && base.browser.isTouch !== true && base.options.autoPlay !== false) {\n\t\t\t\t\tbase.$elem.on(\"mouseover\", function () {\n\t\t\t\t\t\tbase.stop();\n\t\t\t\t\t});\n\t\t\t\t\tbase.$elem.on(\"mouseout\", function () {\n\t\t\t\t\t\tif (base.hoverStatus !== \"stop\") {\n\t\t\t\t\t\t\tbase.play();\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlazyLoad : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ti,\n\t\t\t\t\t$item,\n\t\t\t\t\titemNumber,\n\t\t\t\t\t$lazyImg,\n\t\t\t\t\tfollow;\n\n\t\t\t\tif (base.options.lazyLoad === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\t$item = $(base.$owlItems[i]);\n\n\t\t\t\t\tif ($item.data(\"owl-loaded\") === \"loaded\") {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\titemNumber = $item.data(\"owl-item\");\n\t\t\t\t\t$lazyImg = $item.find(\".lazyOwl\");\n\n\t\t\t\t\tif (typeof $lazyImg.data(\"src\") !== \"string\") {\n\t\t\t\t\t\t$item.data(\"owl-loaded\", \"loaded\");\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t\tif ($item.data(\"owl-loaded\") === undefined) {\n\t\t\t\t\t\t$lazyImg.hide();\n\t\t\t\t\t\t$item.addClass(\"loading\").data(\"owl-loaded\", \"checked\");\n\t\t\t\t\t}\n\t\t\t\t\tif (base.options.lazyFollow === true) {\n\t\t\t\t\t\tfollow = itemNumber >= base.currentItem;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfollow = true;\n\t\t\t\t\t}\n\t\t\t\t\tif (follow && itemNumber < base.currentItem + base.options.items && $lazyImg.length) {\n\t\t\t\t\t\tbase.lazyPreload($item, $lazyImg);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlazyPreload : function ($item, $lazyImg) {\n\t\t\t\tvar base = this,\n\t\t\t\t\titerations = 0,\n\t\t\t\t\tisBackgroundImg;\n\n\t\t\t\tif ($lazyImg.prop(\"tagName\") === \"DIV\") {\n\t\t\t\t\t$lazyImg.css(\"background-image\", \"url(\" + $lazyImg.data(\"src\") + \")\");\n\t\t\t\t\tisBackgroundImg = true;\n\t\t\t\t} else {\n\t\t\t\t\t$lazyImg[0].src = $lazyImg.data(\"src\");\n\t\t\t\t}\n\n\t\t\t\tfunction showImage() {\n\t\t\t\t\t$item.data(\"owl-loaded\", \"loaded\").removeClass(\"loading\");\n\t\t\t\t\t$lazyImg.removeAttr(\"data-src\");\n\t\t\t\t\tif (base.options.lazyEffect === \"fade\") {\n\t\t\t\t\t\t$lazyImg.fadeIn(400);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t$lazyImg.show();\n\t\t\t\t\t}\n\t\t\t\t\tif (typeof base.options.afterLazyLoad === \"function\") {\n\t\t\t\t\t\tbase.options.afterLazyLoad.apply(this, [base.$elem]);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction checkLazyImage() {\n\t\t\t\t\titerations += 1;\n\t\t\t\t\tif (base.completeImg($lazyImg.get(0)) || isBackgroundImg === true) {\n\t\t\t\t\t\tshowImage();\n\t\t\t\t\t} else if (iterations <= 100) {//if image loads in less than 10 seconds \n\t\t\t\t\t\twindow.setTimeout(checkLazyImage, 100);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tshowImage();\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tcheckLazyImage();\n\t\t\t},\n\n\t\t\tautoHeight : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\t$currentimg = $(base.$owlItems[base.currentItem]).find(\"img\"),\n\t\t\t\t\titerations;\n\n\t\t\t\tfunction addHeight() {\n\t\t\t\t\tvar $currentItem = $(base.$owlItems[base.currentItem]).height();\n\t\t\t\t\tbase.wrapperOuter.css(\"height\", $currentItem + \"px\");\n\t\t\t\t\tif (!base.wrapperOuter.hasClass(\"autoHeight\")) {\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.wrapperOuter.addClass(\"autoHeight\");\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction checkImage() {\n\t\t\t\t\titerations += 1;\n\t\t\t\t\tif (base.completeImg($currentimg.get(0))) {\n\t\t\t\t\t\taddHeight();\n\t\t\t\t\t} else if (iterations <= 100) { //if image loads in less than 10 seconds \n\t\t\t\t\t\twindow.setTimeout(checkImage, 100);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.wrapperOuter.css(\"height\", \"\"); //Else remove height attribute\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ($currentimg.get(0) !== undefined) {\n\t\t\t\t\titerations = 0;\n\t\t\t\t\tcheckImage();\n\t\t\t\t} else {\n\t\t\t\t\taddHeight();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tcompleteImg : function (img) {\n\t\t\t\tvar naturalWidthType;\n\n\t\t\t\tif (!img.complete) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tnaturalWidthType = typeof img.naturalWidth;\n\t\t\t\tif (naturalWidthType !== \"undefined\" && img.naturalWidth === 0) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\n\t\t\tonVisibleItems : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ti;\n\n\t\t\t\tif (base.options.addClassActive === true) {\n\t\t\t\t\tbase.$owlItems.removeClass(\"active\");\n\t\t\t\t}\n\t\t\t\tbase.visibleItems = [];\n\t\t\t\tfor (i = base.currentItem; i < base.currentItem + base.options.items; i += 1) {\n\t\t\t\t\tbase.visibleItems.push(i);\n\n\t\t\t\t\tif (base.options.addClassActive === true) {\n\t\t\t\t\t\t$(base.$owlItems[i]).addClass(\"active\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.owl.visibleItems = base.visibleItems;\n\t\t\t},\n\n\t\t\ttransitionTypes : function (className) {\n\t\t\t\tvar base = this;\n\t\t\t\t//Currently available: \"fade\", \"backSlide\", \"goDown\", \"fadeUp\"\n\t\t\t\tbase.outClass = \"owl-\" + className + \"-out\";\n\t\t\t\tbase.inClass = \"owl-\" + className + \"-in\";\n\t\t\t},\n\n\t\t\tsingleItemTransition : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\toutClass = base.outClass,\n\t\t\t\t\tinClass = base.inClass,\n\t\t\t\t\t$currentItem = base.$owlItems.eq(base.currentItem),\n\t\t\t\t\t$prevItem = base.$owlItems.eq(base.prevItem),\n\t\t\t\t\tprevPos = Math.abs(base.positionsInArray[base.currentItem]) + base.positionsInArray[base.prevItem],\n\t\t\t\t\torigin = Math.abs(base.positionsInArray[base.currentItem]) + base.itemWidth / 2,\n\t\t\t\t\tanimEnd = 'webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend';\n\n\t\t\t\tbase.isTransition = true;\n\n\t\t\t\tbase.$owlWrapper\n\t\t\t\t\t.addClass('owl-origin')\n\t\t\t\t\t.css({\n\t\t\t\t\t\t\"-webkit-transform-origin\" : origin + \"px\",\n\t\t\t\t\t\t\"-moz-perspective-origin\" : origin + \"px\",\n\t\t\t\t\t\t\"perspective-origin\" : origin + \"px\"\n\t\t\t\t\t});\n\t\t\t\tfunction transStyles(prevPos) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\t\"position\" : \"relative\",\n\t\t\t\t\t\t\"left\" : prevPos + \"px\"\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t$prevItem\n\t\t\t\t\t.css(transStyles(prevPos, 10))\n\t\t\t\t\t.addClass(outClass)\n\t\t\t\t\t.on(animEnd, function () {\n\t\t\t\t\t\tbase.endPrev = true;\n\t\t\t\t\t\t$prevItem.off(animEnd);\n\t\t\t\t\t\tbase.clearTransStyle($prevItem, outClass);\n\t\t\t\t\t});\n\n\t\t\t\t$currentItem\n\t\t\t\t\t.addClass(inClass)\n\t\t\t\t\t.on(animEnd, function () {\n\t\t\t\t\t\tbase.endCurrent = true;\n\t\t\t\t\t\t$currentItem.off(animEnd);\n\t\t\t\t\t\tbase.clearTransStyle($currentItem, inClass);\n\t\t\t\t\t});\n\t\t\t},\n\n\t\t\tclearTransStyle : function (item, classToRemove) {\n\t\t\t\tvar base = this;\n\t\t\t\titem.css({\n\t\t\t\t\t\"position\" : \"\",\n\t\t\t\t\t\"left\" : \"\"\n\t\t\t\t}).removeClass(classToRemove);\n\n\t\t\t\tif (base.endPrev && base.endCurrent) {\n\t\t\t\t\tbase.$owlWrapper.removeClass('owl-origin');\n\t\t\t\t\tbase.endPrev = false;\n\t\t\t\t\tbase.endCurrent = false;\n\t\t\t\t\tbase.isTransition = false;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\towlStatus : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.owl = {\n\t\t\t\t\t\"userOptions\"   : base.userOptions,\n\t\t\t\t\t\"baseElement\"   : base.$elem,\n\t\t\t\t\t\"userItems\"     : base.$userItems,\n\t\t\t\t\t\"owlItems\"      : base.$owlItems,\n\t\t\t\t\t\"currentItem\"   : base.currentItem,\n\t\t\t\t\t\"prevItem\"      : base.prevItem,\n\t\t\t\t\t\"visibleItems\"  : base.visibleItems,\n\t\t\t\t\t\"isTouch\"       : base.browser.isTouch,\n\t\t\t\t\t\"browser\"       : base.browser,\n\t\t\t\t\t\"dragDirection\" : base.dragDirection\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tclearEvents : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.off(\".owl owl mousedown.disableTextSelect\");\n\t\t\t\t$(document).off(\".owl owl\");\n\t\t\t\t$(window).off(\"resize\", base.resizer);\n\t\t\t},\n\n\t\t\tunWrap : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.$elem.children().length !== 0) {\n\t\t\t\t\tbase.$owlWrapper.unwrap();\n\t\t\t\t\tbase.$userItems.unwrap().unwrap();\n\t\t\t\t\tif (base.owlControls) {\n\t\t\t\t\t\tbase.owlControls.remove();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.clearEvents();\n\t\t\t\tbase.$elem\n\t\t\t\t\t.attr(\"style\", base.$elem.data(\"owl-originalStyles\") || \"\")\n\t\t\t\t\t.attr(\"class\", base.$elem.data(\"owl-originalClasses\"));\n\t\t\t},\n\n\t\t\tdestroy : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.stop();\n\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.$elem.removeData();\n\t\t\t},\n\n\t\t\treinit : function (newOptions) {\n\t\t\t\tvar base = this,\n\t\t\t\t\toptions = $.extend({}, base.userOptions, newOptions);\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.init(options, base.$elem);\n\t\t\t},\n\n\t\t\taddItem : function (htmlString, targetPosition) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tposition;\n\n\t\t\t\tif (!htmlString) {return false; }\n\n\t\t\t\tif (base.$elem.children().length === 0) {\n\t\t\t\t\tbase.$elem.append(htmlString);\n\t\t\t\t\tbase.setVars();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.unWrap();\n\t\t\t\tif (targetPosition === undefined || targetPosition === -1) {\n\t\t\t\t\tposition = -1;\n\t\t\t\t} else {\n\t\t\t\t\tposition = targetPosition;\n\t\t\t\t}\n\t\t\t\tif (position >= base.$userItems.length || position === -1) {\n\t\t\t\t\tbase.$userItems.eq(-1).after(htmlString);\n\t\t\t\t} else {\n\t\t\t\t\tbase.$userItems.eq(position).before(htmlString);\n\t\t\t\t}\n\n\t\t\t\tbase.setVars();\n\t\t\t},\n\n\t\t\tremoveItem : function (targetPosition) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tposition;\n\n\t\t\t\tif (base.$elem.children().length === 0) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (targetPosition === undefined || targetPosition === -1) {\n\t\t\t\t\tposition = -1;\n\t\t\t\t} else {\n\t\t\t\t\tposition = targetPosition;\n\t\t\t\t}\n\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.$userItems.eq(position).remove();\n\t\t\t\tbase.setVars();\n\t\t\t}\n\n\t\t};\n\n\t\t$.fn.owlCarousel = function (options) {\n\t\t\treturn this.each(function () {\n\t\t\t\tif ($(this).data(\"owl-init\") === true) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\t$(this).data(\"owl-init\", true);\n\t\t\t\tvar carousel = Object.create(Carousel);\n\t\t\t\tcarousel.init(options, this);\n\t\t\t\t$.data(this, \"owlCarousel\", carousel);\n\t\t\t});\n\t\t};\n\n\t\t$.fn.owlCarousel.options = {\n\n\t\t\titems : 5,\n\t\t\titemsCustom : false,\n\t\t\titemsDesktop : [1199, 4],\n\t\t\titemsDesktopSmall : [979, 3],\n\t\t\titemsTablet : [768, 2],\n\t\t\titemsTabletSmall : false,\n\t\t\titemsMobile : [479, 1],\n\t\t\tsingleItem : false,\n\t\t\titemsScaleUp : false,\n\n\t\t\tslideSpeed : 200,\n\t\t\tpaginationSpeed : 800,\n\t\t\trewindSpeed : 1000,\n\n\t\t\tautoPlay : false,\n\t\t\tstopOnHover : false,\n\n\t\t\tnavigation : false,\n\t\t\tnavigationText : [\"prev\", \"next\"],\n\t\t\trewindNav : true,\n\t\t\tscrollPerPage : false,\n\n\t\t\tpagination : true,\n\t\t\tpaginationNumbers : false,\n\n\t\t\tresponsive : true,\n\t\t\tresponsiveRefreshRate : 200,\n\t\t\tresponsiveBaseWidth : window,\n\n\t\t\tbaseClass : \"owl-carousel\",\n\t\t\ttheme : \"owl-theme\",\n\n\t\t\tlazyLoad : false,\n\t\t\tlazyFollow : true,\n\t\t\tlazyEffect : \"fade\",\n\n\t\t\tautoHeight : false,\n\n\t\t\tjsonPath : false,\n\t\t\tjsonSuccess : false,\n\n\t\t\tdragBeforeAnimFinish : true,\n\t\t\tmouseDrag : true,\n\t\t\ttouchDrag : true,\n\n\t\t\taddClassActive : false,\n\t\t\ttransitionStyle : false,\n\n\t\t\tbeforeUpdate : false,\n\t\t\tafterUpdate : false,\n\t\t\tbeforeInit : false,\n\t\t\tafterInit : false,\n\t\t\tbeforeMove : false,\n\t\t\tafterMove : false,\n\t\t\tafterAction : false,\n\t\t\tstartDragging : false,\n\t\t\tafterLazyLoad: false\n\t\t};\n\t}($, window, document));\n});\n","Plazathemes_Brandslider/js/owl.carousel.js":"/**\n * Copyright \u00c2\u00a9 2015 PlazaThemes.com. All rights reserved.\n *\n * @author PlazaThemes Team <contact@plazathemes.com>\n */\n\n/*\n *  jQuery OwlCarousel v1.3.3\n *\n *  Copyright (c) 2013 Bartosz Wojciechowski\n *  http://www.owlgraphic.com/owlcarousel/\n *\n *  Licensed under MIT\n *\n */\n\n/*JS Lint helpers: */\n/*global dragMove: false, dragEnd: false, $, jQuery, alert, window, document */\n/*jslint nomen: true, continue:true */\nif (typeof Object.create !== \"function\") {\n    Object.create = function (obj) {\n        function F() {}\n        F.prototype = obj;\n        return new F();\n    };\n}\nrequire([\n\t\"jquery\"\n], function($){\n\t(function ($, window, document) {\n\t\tvar Carousel = {\n\t\t\tinit : function (options, el) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.$elem = $(el);\n\t\t\t\tbase.options = $.extend({}, $.fn.owlCarousel.options, base.$elem.data(), options);\n\n\t\t\t\tbase.userOptions = options;\n\t\t\t\tbase.loadContent();\n\t\t\t},\n\n\t\t\tloadContent : function () {\n\t\t\t\tvar base = this, url;\n\n\t\t\t\tfunction getData(data) {\n\t\t\t\t\tvar i, content = \"\";\n\t\t\t\t\tif (typeof base.options.jsonSuccess === \"function\") {\n\t\t\t\t\t\tbase.options.jsonSuccess.apply(this, [data]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfor (i in data.owl) {\n\t\t\t\t\t\t\tif (data.owl.hasOwnProperty(i)) {\n\t\t\t\t\t\t\t\tcontent += data.owl[i].item;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbase.$elem.html(content);\n\t\t\t\t\t}\n\t\t\t\t\tbase.logIn();\n\t\t\t\t}\n\n\t\t\t\tif (typeof base.options.beforeInit === \"function\") {\n\t\t\t\t\tbase.options.beforeInit.apply(this, [base.$elem]);\n\t\t\t\t}\n\n\t\t\t\tif (typeof base.options.jsonPath === \"string\") {\n\t\t\t\t\turl = base.options.jsonPath;\n\t\t\t\t\t$.getJSON(url, getData);\n\t\t\t\t} else {\n\t\t\t\t\tbase.logIn();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlogIn : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.$elem.data(\"owl-originalStyles\", base.$elem.attr(\"style\"));\n\t\t\t\tbase.$elem.data(\"owl-originalClasses\", base.$elem.attr(\"class\"));\n\n\t\t\t\tbase.$elem.css({opacity: 0});\n\t\t\t\tbase.orignalItems = base.options.items;\n\t\t\t\tbase.checkBrowser();\n\t\t\t\tbase.wrapperWidth = 0;\n\t\t\t\tbase.checkVisible = null;\n\t\t\t\tbase.setVars();\n\t\t\t},\n\n\t\t\tsetVars : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.$elem.children().length === 0) {return false; }\n\t\t\t\tbase.baseClass();\n\t\t\t\tbase.eventTypes();\n\t\t\t\tbase.$userItems = base.$elem.children();\n\t\t\t\tbase.itemsAmount = base.$userItems.length;\n\t\t\t\tbase.wrapItems();\n\t\t\t\tbase.$owlItems = base.$elem.find(\".owl-item\");\n\t\t\t\tbase.$owlWrapper = base.$elem.find(\".owl-wrapper\");\n\t\t\t\tbase.playDirection = \"next\";\n\t\t\t\tbase.prevItem = 0;\n\t\t\t\tbase.prevArr = [0];\n\t\t\t\tbase.currentItem = 0;\n\t\t\t\tbase.customEvents();\n\t\t\t\tbase.onStartup();\n\t\t\t},\n\n\t\t\tonStartup : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.updateItems();\n\t\t\t\tbase.calculateAll();\n\t\t\t\tbase.buildControls();\n\t\t\t\tbase.updateControls();\n\t\t\t\tbase.response();\n\t\t\t\tbase.moveEvents();\n\t\t\t\tbase.stopOnHover();\n\t\t\t\tbase.owlStatus();\n\n\t\t\t\tif (base.options.transitionStyle !== false) {\n\t\t\t\t\tbase.transitionTypes(base.options.transitionStyle);\n\t\t\t\t}\n\t\t\t\tif (base.options.autoPlay === true) {\n\t\t\t\t\tbase.options.autoPlay = 5000;\n\t\t\t\t}\n\t\t\t\tbase.play();\n\n\t\t\t\tbase.$elem.find(\".owl-wrapper\").css(\"display\", \"block\");\n\n\t\t\t\tif (!base.$elem.is(\":visible\")) {\n\t\t\t\t\tbase.watchVisibility();\n\t\t\t\t} else {\n\t\t\t\t\tbase.$elem.css(\"opacity\", 1);\n\t\t\t\t}\n\t\t\t\tbase.onstartup = false;\n\t\t\t\tbase.eachMoveUpdate();\n\t\t\t\tif (typeof base.options.afterInit === \"function\") {\n\t\t\t\t\tbase.options.afterInit.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\teachMoveUpdate : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.options.lazyLoad === true) {\n\t\t\t\t\tbase.lazyLoad();\n\t\t\t\t}\n\t\t\t\tif (base.options.autoHeight === true) {\n\t\t\t\t\tbase.autoHeight();\n\t\t\t\t}\n\t\t\t\tbase.onVisibleItems();\n\n\t\t\t\tif (typeof base.options.afterAction === \"function\") {\n\t\t\t\t\tbase.options.afterAction.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateVars : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (typeof base.options.beforeUpdate === \"function\") {\n\t\t\t\t\tbase.options.beforeUpdate.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tbase.watchVisibility();\n\t\t\t\tbase.updateItems();\n\t\t\t\tbase.calculateAll();\n\t\t\t\tbase.updatePosition();\n\t\t\t\tbase.updateControls();\n\t\t\t\tbase.eachMoveUpdate();\n\t\t\t\tif (typeof base.options.afterUpdate === \"function\") {\n\t\t\t\t\tbase.options.afterUpdate.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\treload : function () {\n\t\t\t\tvar base = this;\n\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\tbase.updateVars();\n\t\t\t\t}, 0);\n\t\t\t},\n\n\t\t\twatchVisibility : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.$elem.is(\":visible\") === false) {\n\t\t\t\t\tbase.$elem.css({opacity: 0});\n\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\t} else {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.checkVisible = window.setInterval(function () {\n\t\t\t\t\tif (base.$elem.is(\":visible\")) {\n\t\t\t\t\t\tbase.reload();\n\t\t\t\t\t\tbase.$elem.animate({opacity: 1}, 200);\n\t\t\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\t\t}\n\t\t\t\t}, 500);\n\t\t\t},\n\n\t\t\twrapItems : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$userItems.wrapAll(\"<div class=\\\"owl-wrapper\\\">\").wrap(\"<div class=\\\"owl-item\\\"></div>\");\n\t\t\t\tbase.$elem.find(\".owl-wrapper\").wrap(\"<div class=\\\"owl-wrapper-outer\\\">\");\n\t\t\t\tbase.wrapperOuter = base.$elem.find(\".owl-wrapper-outer\");\n\t\t\t\tbase.$elem.css(\"display\", \"block\");\n\t\t\t},\n\n\t\t\tbaseClass : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\thasBaseClass = base.$elem.hasClass(base.options.baseClass),\n\t\t\t\t\thasThemeClass = base.$elem.hasClass(base.options.theme);\n\n\t\t\t\tif (!hasBaseClass) {\n\t\t\t\t\tbase.$elem.addClass(base.options.baseClass);\n\t\t\t\t}\n\n\t\t\t\tif (!hasThemeClass) {\n\t\t\t\t\tbase.$elem.addClass(base.options.theme);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateItems : function () {\n\t\t\t\tvar base = this, width, i;\n\n\t\t\t\tif (base.options.responsive === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (base.options.singleItem === true) {\n\t\t\t\t\tbase.options.items = base.orignalItems = 1;\n\t\t\t\t\tbase.options.itemsCustom = false;\n\t\t\t\t\tbase.options.itemsDesktop = false;\n\t\t\t\t\tbase.options.itemsDesktopSmall = false;\n\t\t\t\t\tbase.options.itemsTablet = false;\n\t\t\t\t\tbase.options.itemsTabletSmall = false;\n\t\t\t\t\tbase.options.itemsMobile = false;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\twidth = $(base.options.responsiveBaseWidth).width();\n\n\t\t\t\tif (width > (base.options.itemsDesktop[0] || base.orignalItems)) {\n\t\t\t\t\tbase.options.items = base.orignalItems;\n\t\t\t\t}\n\t\t\t\tif (base.options.itemsCustom !== false) {\n\t\t\t\t\t//Reorder array by screen size\n\t\t\t\t\tbase.options.itemsCustom.sort(function (a, b) {return a[0] - b[0]; });\n\n\t\t\t\t\tfor (i = 0; i < base.options.itemsCustom.length; i += 1) {\n\t\t\t\t\t\tif (base.options.itemsCustom[i][0] <= width) {\n\t\t\t\t\t\t\tbase.options.items = base.options.itemsCustom[i][1];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\tif (width <= base.options.itemsDesktop[0] && base.options.itemsDesktop !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsDesktop[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsDesktopSmall[0] && base.options.itemsDesktopSmall !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsDesktopSmall[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsTablet[0] && base.options.itemsTablet !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsTablet[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsTabletSmall[0] && base.options.itemsTabletSmall !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsTabletSmall[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsMobile[0] && base.options.itemsMobile !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsMobile[1];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t//if number of items is less than declared\n\t\t\t\tif (base.options.items > base.itemsAmount && base.options.itemsScaleUp === true) {\n\t\t\t\t\tbase.options.items = base.itemsAmount;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tresponse : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tsmallDelay,\n\t\t\t\t\tlastWindowWidth;\n\n\t\t\t\tif (base.options.responsive !== true) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tlastWindowWidth = $(window).width();\n\n\t\t\t\tbase.resizer = function () {\n\t\t\t\t\tif ($(window).width() !== lastWindowWidth) {\n\t\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\t\t}\n\t\t\t\t\t\twindow.clearTimeout(smallDelay);\n\t\t\t\t\t\tsmallDelay = window.setTimeout(function () {\n\t\t\t\t\t\t\tlastWindowWidth = $(window).width();\n\t\t\t\t\t\t\tbase.updateVars();\n\t\t\t\t\t\t}, base.options.responsiveRefreshRate);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t\t$(window).resize(base.resizer);\n\t\t\t},\n\n\t\t\tupdatePosition : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.jumpTo(base.currentItem);\n\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\tbase.checkAp();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tappendItemsSizes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\troundPages = 0,\n\t\t\t\t\tlastItem = base.itemsAmount - base.options.items;\n\n\t\t\t\tbase.$owlItems.each(function (index) {\n\t\t\t\t\tvar $this = $(this);\n\t\t\t\t\t$this\n\t\t\t\t\t\t.css({\"width\": base.itemWidth})\n\t\t\t\t\t\t.data(\"owl-item\", Number(index));\n\n\t\t\t\t\tif (index % base.options.items === 0 || index === lastItem) {\n\t\t\t\t\t\tif (!(index > lastItem)) {\n\t\t\t\t\t\t\troundPages += 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\t$this.data(\"owl-roundPages\", roundPages);\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tappendWrapperSizes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\twidth = base.$owlItems.length * base.itemWidth;\n\n\t\t\t\tbase.$owlWrapper.css({\n\t\t\t\t\t\"width\": width * 2,\n\t\t\t\t\t\"left\": 0\n\t\t\t\t});\n\t\t\t\tbase.appendItemsSizes();\n\t\t\t},\n\n\t\t\tcalculateAll : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.calculateWidth();\n\t\t\t\tbase.appendWrapperSizes();\n\t\t\t\tbase.loops();\n\t\t\t\tbase.max();\n\t\t\t},\n\n\t\t\tcalculateWidth : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.itemWidth = Math.round(base.$elem.width() / base.options.items);\n\t\t\t},\n\n\t\t\tmax : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tmaximum = ((base.itemsAmount * base.itemWidth) - base.options.items * base.itemWidth) * -1;\n\t\t\t\tif (base.options.items > base.itemsAmount) {\n\t\t\t\t\tbase.maximumItem = 0;\n\t\t\t\t\tmaximum = 0;\n\t\t\t\t\tbase.maximumPixels = 0;\n\t\t\t\t} else {\n\t\t\t\t\tbase.maximumItem = base.itemsAmount - base.options.items;\n\t\t\t\t\tbase.maximumPixels = maximum;\n\t\t\t\t}\n\t\t\t\treturn maximum;\n\t\t\t},\n\n\t\t\tmin : function () {\n\t\t\t\treturn 0;\n\t\t\t},\n\n\t\t\tloops : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tprev = 0,\n\t\t\t\t\telWidth = 0,\n\t\t\t\t\ti,\n\t\t\t\t\titem,\n\t\t\t\t\troundPageNum;\n\n\t\t\t\tbase.positionsInArray = [0];\n\t\t\t\tbase.pagesInArray = [];\n\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\telWidth += base.itemWidth;\n\t\t\t\t\tbase.positionsInArray.push(-elWidth);\n\n\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\titem = $(base.$owlItems[i]);\n\t\t\t\t\t\troundPageNum = item.data(\"owl-roundPages\");\n\t\t\t\t\t\tif (roundPageNum !== prev) {\n\t\t\t\t\t\t\tbase.pagesInArray[prev] = base.positionsInArray[i];\n\t\t\t\t\t\t\tprev = roundPageNum;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbuildControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.navigation === true || base.options.pagination === true) {\n\t\t\t\t\tbase.owlControls = $(\"<div class=\\\"owl-controls\\\"/>\").toggleClass(\"clickable\", !base.browser.isTouch).appendTo(base.$elem);\n\t\t\t\t}\n\t\t\t\tif (base.options.pagination === true) {\n\t\t\t\t\tbase.buildPagination();\n\t\t\t\t}\n\t\t\t\tif (base.options.navigation === true) {\n\t\t\t\t\tbase.buildButtons();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbuildButtons : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tbuttonsWrapper = $(\"<div class=\\\"owl-buttons\\\"/>\");\n\t\t\t\tbase.owlControls.append(buttonsWrapper);\n\n\t\t\t\tbase.buttonPrev = $(\"<div/>\", {\n\t\t\t\t\t\"class\" : \"owl-prev\",\n\t\t\t\t\t\"html\" : base.options.navigationText[0] || \"\"\n\t\t\t\t});\n\n\t\t\t\tbase.buttonNext = $(\"<div/>\", {\n\t\t\t\t\t\"class\" : \"owl-next\",\n\t\t\t\t\t\"html\" : base.options.navigationText[1] || \"\"\n\t\t\t\t});\n\n\t\t\t\tbuttonsWrapper\n\t\t\t\t\t.append(base.buttonPrev)\n\t\t\t\t\t.append(base.buttonNext);\n\n\t\t\t\tbuttonsWrapper.on(\"touchstart.owlControls mousedown.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t});\n\n\t\t\t\tbuttonsWrapper.on(\"touchend.owlControls mouseup.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif ($(this).hasClass(\"owl-next\")) {\n\t\t\t\t\t\tbase.next();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.prev();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tbuildPagination : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.paginationWrapper = $(\"<div class=\\\"owl-pagination\\\"/>\");\n\t\t\t\tbase.owlControls.append(base.paginationWrapper);\n\n\t\t\t\tbase.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\", \".owl-page\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif (Number($(this).data(\"owl-page\")) !== base.currentItem) {\n\t\t\t\t\t\tbase.goTo(Number($(this).data(\"owl-page\")), true);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tupdatePagination : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tcounter,\n\t\t\t\t\tlastPage,\n\t\t\t\t\tlastItem,\n\t\t\t\t\ti,\n\t\t\t\t\tpaginationButton,\n\t\t\t\t\tpaginationButtonInner;\n\n\t\t\t\tif (base.options.pagination === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tbase.paginationWrapper.html(\"\");\n\n\t\t\t\tcounter = 0;\n\t\t\t\tlastPage = base.itemsAmount - base.itemsAmount % base.options.items;\n\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\tif (i % base.options.items === 0) {\n\t\t\t\t\t\tcounter += 1;\n\t\t\t\t\t\tif (lastPage === i) {\n\t\t\t\t\t\t\tlastItem = base.itemsAmount - base.options.items;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tpaginationButton = $(\"<div/>\", {\n\t\t\t\t\t\t\t\"class\" : \"owl-page\"\n\t\t\t\t\t\t});\n\t\t\t\t\t\tpaginationButtonInner = $(\"<span></span>\", {\n\t\t\t\t\t\t\t\"text\": base.options.paginationNumbers === true ? counter : \"\",\n\t\t\t\t\t\t\t\"class\": base.options.paginationNumbers === true ? \"owl-numbers\" : \"\"\n\t\t\t\t\t\t});\n\t\t\t\t\t\tpaginationButton.append(paginationButtonInner);\n\n\t\t\t\t\t\tpaginationButton.data(\"owl-page\", lastPage === i ? lastItem : i);\n\t\t\t\t\t\tpaginationButton.data(\"owl-roundPages\", counter);\n\n\t\t\t\t\t\tbase.paginationWrapper.append(paginationButton);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.checkPagination();\n\t\t\t},\n\t\t\tcheckPagination : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.pagination === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.paginationWrapper.find(\".owl-page\").each(function () {\n\t\t\t\t\tif ($(this).data(\"owl-roundPages\") === $(base.$owlItems[base.currentItem]).data(\"owl-roundPages\")) {\n\t\t\t\t\t\tbase.paginationWrapper\n\t\t\t\t\t\t\t.find(\".owl-page\")\n\t\t\t\t\t\t\t.removeClass(\"active\");\n\t\t\t\t\t\t$(this).addClass(\"active\");\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tcheckNavigation : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.options.navigation === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (base.options.rewindNav === false) {\n\t\t\t\t\tif (base.currentItem === 0 && base.maximumItem === 0) {\n\t\t\t\t\t\tbase.buttonPrev.addClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.addClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem === 0 && base.maximumItem !== 0) {\n\t\t\t\t\t\tbase.buttonPrev.addClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.removeClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem === base.maximumItem) {\n\t\t\t\t\t\tbase.buttonPrev.removeClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.addClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem !== 0 && base.currentItem !== base.maximumItem) {\n\t\t\t\t\t\tbase.buttonPrev.removeClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.removeClass(\"disabled\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.updatePagination();\n\t\t\t\tbase.checkNavigation();\n\t\t\t\tif (base.owlControls) {\n\t\t\t\t\tif (base.options.items >= base.itemsAmount) {\n\t\t\t\t\t\tbase.owlControls.hide();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.owlControls.show();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tdestroyControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.owlControls) {\n\t\t\t\t\tbase.owlControls.remove();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tnext : function (speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tbase.currentItem += base.options.scrollPerPage === true ? base.options.items : 1;\n\t\t\t\tif (base.currentItem > base.maximumItem + (base.options.scrollPerPage === true ? (base.options.items - 1) : 0)) {\n\t\t\t\t\tif (base.options.rewindNav === true) {\n\t\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t\t\tspeed = \"rewind\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.goTo(base.currentItem, speed);\n\t\t\t},\n\n\t\t\tprev : function (speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tif (base.options.scrollPerPage === true && base.currentItem > 0 && base.currentItem < base.options.items) {\n\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t} else {\n\t\t\t\t\tbase.currentItem -= base.options.scrollPerPage === true ? base.options.items : 1;\n\t\t\t\t}\n\t\t\t\tif (base.currentItem < 0) {\n\t\t\t\t\tif (base.options.rewindNav === true) {\n\t\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\t\tspeed = \"rewind\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.goTo(base.currentItem, speed);\n\t\t\t},\n\n\t\t\tgoTo : function (position, speed, drag) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tgoToPixel;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (typeof base.options.beforeMove === \"function\") {\n\t\t\t\t\tbase.options.beforeMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tif (position >= base.maximumItem) {\n\t\t\t\t\tposition = base.maximumItem;\n\t\t\t\t} else if (position <= 0) {\n\t\t\t\t\tposition = 0;\n\t\t\t\t}\n\n\t\t\t\tbase.currentItem = base.owl.currentItem = position;\n\t\t\t\tif (base.options.transitionStyle !== false && drag !== \"drag\" && base.options.items === 1 && base.browser.support3d === true) {\n\t\t\t\t\tbase.swapSpeed(0);\n\t\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\t\tbase.transition3d(base.positionsInArray[position]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2slide(base.positionsInArray[position], 1);\n\t\t\t\t\t}\n\t\t\t\t\tbase.afterGo();\n\t\t\t\t\tbase.singleItemTransition();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tgoToPixel = base.positionsInArray[position];\n\n\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\tbase.isCss3Finish = false;\n\n\t\t\t\t\tif (speed === true) {\n\t\t\t\t\t\tbase.swapSpeed(\"paginationSpeed\");\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.paginationSpeed);\n\n\t\t\t\t\t} else if (speed === \"rewind\") {\n\t\t\t\t\t\tbase.swapSpeed(base.options.rewindSpeed);\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.rewindSpeed);\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.swapSpeed(\"slideSpeed\");\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.slideSpeed);\n\t\t\t\t\t}\n\t\t\t\t\tbase.transition3d(goToPixel);\n\t\t\t\t} else {\n\t\t\t\t\tif (speed === true) {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.paginationSpeed);\n\t\t\t\t\t} else if (speed === \"rewind\") {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.rewindSpeed);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.slideSpeed);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.afterGo();\n\t\t\t},\n\n\t\t\tjumpTo : function (position) {\n\t\t\t\tvar base = this;\n\t\t\t\tif (typeof base.options.beforeMove === \"function\") {\n\t\t\t\t\tbase.options.beforeMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tif (position >= base.maximumItem || position === -1) {\n\t\t\t\t\tposition = base.maximumItem;\n\t\t\t\t} else if (position <= 0) {\n\t\t\t\t\tposition = 0;\n\t\t\t\t}\n\t\t\t\tbase.swapSpeed(0);\n\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\tbase.transition3d(base.positionsInArray[position]);\n\t\t\t\t} else {\n\t\t\t\t\tbase.css2slide(base.positionsInArray[position], 1);\n\t\t\t\t}\n\t\t\t\tbase.currentItem = base.owl.currentItem = position;\n\t\t\t\tbase.afterGo();\n\t\t\t},\n\n\t\t\tafterGo : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.prevArr.push(base.currentItem);\n\t\t\t\tbase.prevItem = base.owl.prevItem = base.prevArr[base.prevArr.length - 2];\n\t\t\t\tbase.prevArr.shift(0);\n\n\t\t\t\tif (base.prevItem !== base.currentItem) {\n\t\t\t\t\tbase.checkPagination();\n\t\t\t\t\tbase.checkNavigation();\n\t\t\t\t\tbase.eachMoveUpdate();\n\n\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\tbase.checkAp();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (typeof base.options.afterMove === \"function\" && base.prevItem !== base.currentItem) {\n\t\t\t\t\tbase.options.afterMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tstop : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.apStatus = \"stop\";\n\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t},\n\n\t\t\tcheckAp : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.apStatus !== \"stop\") {\n\t\t\t\t\tbase.play();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tplay : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.apStatus = \"play\";\n\t\t\t\tif (base.options.autoPlay === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\tbase.autoPlayInterval = window.setInterval(function () {\n\t\t\t\t\tbase.next(true);\n\t\t\t\t}, base.options.autoPlay);\n\t\t\t},\n\n\t\t\tswapSpeed : function (action) {\n\t\t\t\tvar base = this;\n\t\t\t\tif (action === \"slideSpeed\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(base.options.slideSpeed));\n\t\t\t\t} else if (action === \"paginationSpeed\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(base.options.paginationSpeed));\n\t\t\t\t} else if (typeof action !== \"string\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(action));\n\t\t\t\t}\n\t\t\t},\n\n\t\t\taddCssSpeed : function (speed) {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"-moz-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"-o-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"transition\": \"all \" + speed + \"ms ease\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tremoveTransition : function () {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transition\": \"\",\n\t\t\t\t\t\"-moz-transition\": \"\",\n\t\t\t\t\t\"-o-transition\": \"\",\n\t\t\t\t\t\"transition\": \"\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tdoTranslate : function (pixels) {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-moz-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-o-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-ms-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"transform\": \"translate3d(\" + pixels + \"px, 0px,0px)\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\ttransition3d : function (value) {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$owlWrapper.css(base.doTranslate(value));\n\t\t\t},\n\n\t\t\tcss2move : function (value) {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$owlWrapper.css({\"left\" : value});\n\t\t\t},\n\n\t\t\tcss2slide : function (value, speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.isCssFinish = false;\n\t\t\t\tbase.$owlWrapper.stop(true, true).animate({\n\t\t\t\t\t\"left\" : value\n\t\t\t\t}, {\n\t\t\t\t\tduration : speed || base.options.slideSpeed,\n\t\t\t\t\tcomplete : function () {\n\t\t\t\t\t\tbase.isCssFinish = true;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tcheckBrowser : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ttranslate3D = \"translate3d(0px, 0px, 0px)\",\n\t\t\t\t\ttempElem = document.createElement(\"div\"),\n\t\t\t\t\tregex,\n\t\t\t\t\tasSupport,\n\t\t\t\t\tsupport3d,\n\t\t\t\t\tisTouch;\n\n\t\t\t\ttempElem.style.cssText = \"  -moz-transform:\" + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -ms-transform:\"     + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -o-transform:\"      + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -webkit-transform:\" + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; transform:\"         + translate3D;\n\t\t\t\tregex = /translate3d\\(0px, 0px, 0px\\)/g;\n\t\t\t\tasSupport = tempElem.style.cssText.match(regex);\n\t\t\t\tsupport3d = (asSupport !== null && asSupport.length === 1);\n\n\t\t\t\tisTouch = \"ontouchstart\" in window || window.navigator.msMaxTouchPoints;\n\n\t\t\t\tbase.browser = {\n\t\t\t\t\t\"support3d\" : support3d,\n\t\t\t\t\t\"isTouch\" : isTouch\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tmoveEvents : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.mouseDrag !== false || base.options.touchDrag !== false) {\n\t\t\t\t\tbase.gestures();\n\t\t\t\t\tbase.disabledEvents();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\teventTypes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ttypes = [\"s\", \"e\", \"x\"];\n\n\t\t\t\tbase.ev_types = {};\n\n\t\t\t\tif (base.options.mouseDrag === true && base.options.touchDrag === true) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"touchstart.owl mousedown.owl\",\n\t\t\t\t\t\t\"touchmove.owl mousemove.owl\",\n\t\t\t\t\t\t\"touchend.owl touchcancel.owl mouseup.owl\"\n\t\t\t\t\t];\n\t\t\t\t} else if (base.options.mouseDrag === false && base.options.touchDrag === true) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"touchstart.owl\",\n\t\t\t\t\t\t\"touchmove.owl\",\n\t\t\t\t\t\t\"touchend.owl touchcancel.owl\"\n\t\t\t\t\t];\n\t\t\t\t} else if (base.options.mouseDrag === true && base.options.touchDrag === false) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"mousedown.owl\",\n\t\t\t\t\t\t\"mousemove.owl\",\n\t\t\t\t\t\t\"mouseup.owl\"\n\t\t\t\t\t];\n\t\t\t\t}\n\n\t\t\t\tbase.ev_types.start = types[0];\n\t\t\t\tbase.ev_types.move = types[1];\n\t\t\t\tbase.ev_types.end = types[2];\n\t\t\t},\n\n\t\t\tdisabledEvents :  function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.on(\"dragstart.owl\", function (event) { event.preventDefault(); });\n\t\t\t\tbase.$elem.on(\"mousedown.disableTextSelect\", function (e) {\n\t\t\t\t\treturn $(e.target).is('input, textarea, select, option');\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tgestures : function () {\n\t\t\t\t/*jslint unparam: true*/\n\t\t\t\tvar base = this,\n\t\t\t\t\tlocals = {\n\t\t\t\t\t\toffsetX : 0,\n\t\t\t\t\t\toffsetY : 0,\n\t\t\t\t\t\tbaseElWidth : 0,\n\t\t\t\t\t\trelativePos : 0,\n\t\t\t\t\t\tposition: null,\n\t\t\t\t\t\tminSwipe : null,\n\t\t\t\t\t\tmaxSwipe: null,\n\t\t\t\t\t\tsliding : null,\n\t\t\t\t\t\tdargging: null,\n\t\t\t\t\t\ttargetElement : null\n\t\t\t\t\t};\n\n\t\t\t\tbase.isCssFinish = true;\n\n\t\t\t\tfunction getTouches(event) {\n\t\t\t\t\tif (event.touches !== undefined) {\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tx : event.touches[0].pageX,\n\t\t\t\t\t\t\ty : event.touches[0].pageY\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tif (event.touches === undefined) {\n\t\t\t\t\t\tif (event.pageX !== undefined) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tx : event.pageX,\n\t\t\t\t\t\t\t\ty : event.pageY\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (event.pageX === undefined) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tx : event.clientX,\n\t\t\t\t\t\t\t\ty : event.clientY\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction swapEvents(type) {\n\t\t\t\t\tif (type === \"on\") {\n\t\t\t\t\t\t$(document).on(base.ev_types.move, dragMove);\n\t\t\t\t\t\t$(document).on(base.ev_types.end, dragEnd);\n\t\t\t\t\t} else if (type === \"off\") {\n\t\t\t\t\t\t$(document).off(base.ev_types.move);\n\t\t\t\t\t\t$(document).off(base.ev_types.end);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction dragStart(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tposition;\n\n\t\t\t\t\tif (ev.which === 3) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.itemsAmount <= base.options.items) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.isCssFinish === false && !base.options.dragBeforeAnimFinish) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.isCss3Finish === false && !base.options.dragBeforeAnimFinish) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.browser.isTouch !== true && !base.$owlWrapper.hasClass(\"grabbing\")) {\n\t\t\t\t\t\tbase.$owlWrapper.addClass(\"grabbing\");\n\t\t\t\t\t}\n\n\t\t\t\t\tbase.newPosX = 0;\n\t\t\t\t\tbase.newRelativeX = 0;\n\n\t\t\t\t\t$(this).css(base.removeTransition());\n\n\t\t\t\t\tposition = $(this).position();\n\t\t\t\t\tlocals.relativePos = position.left;\n\n\t\t\t\t\tlocals.offsetX = getTouches(ev).x - position.left;\n\t\t\t\t\tlocals.offsetY = getTouches(ev).y - position.top;\n\n\t\t\t\t\tswapEvents(\"on\");\n\n\t\t\t\t\tlocals.sliding = false;\n\t\t\t\t\tlocals.targetElement = ev.target || ev.srcElement;\n\t\t\t\t}\n\n\t\t\t\tfunction dragMove(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tminSwipe,\n\t\t\t\t\t\tmaxSwipe;\n\n\t\t\t\t\tbase.newPosX = getTouches(ev).x - locals.offsetX;\n\t\t\t\t\tbase.newPosY = getTouches(ev).y - locals.offsetY;\n\t\t\t\t\tbase.newRelativeX = base.newPosX - locals.relativePos;\n\n\t\t\t\t\tif (typeof base.options.startDragging === \"function\" && locals.dragging !== true && base.newRelativeX !== 0) {\n\t\t\t\t\t\tlocals.dragging = true;\n\t\t\t\t\t\tbase.options.startDragging.apply(base, [base.$elem]);\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((base.newRelativeX > 8 || base.newRelativeX < -8) && (base.browser.isTouch === true)) {\n\t\t\t\t\t\tif (ev.preventDefault !== undefined) {\n\t\t\t\t\t\t\tev.preventDefault();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tev.returnValue = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tlocals.sliding = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((base.newPosY > 10 || base.newPosY < -10) && locals.sliding === false) {\n\t\t\t\t\t\t$(document).off(\"touchmove.owl\");\n\t\t\t\t\t}\n\n\t\t\t\t\tminSwipe = function () {\n\t\t\t\t\t\treturn base.newRelativeX / 5;\n\t\t\t\t\t};\n\n\t\t\t\t\tmaxSwipe = function () {\n\t\t\t\t\t\treturn base.maximumPixels + base.newRelativeX / 5;\n\t\t\t\t\t};\n\n\t\t\t\t\tbase.newPosX = Math.max(Math.min(base.newPosX, minSwipe()), maxSwipe());\n\t\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\t\tbase.transition3d(base.newPosX);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2move(base.newPosX);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction dragEnd(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tnewPosition,\n\t\t\t\t\t\thandlers,\n\t\t\t\t\t\towlStopEvent;\n\n\t\t\t\t\tev.target = ev.target || ev.srcElement;\n\n\t\t\t\t\tlocals.dragging = false;\n\n\t\t\t\t\tif (base.browser.isTouch !== true) {\n\t\t\t\t\t\tbase.$owlWrapper.removeClass(\"grabbing\");\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.newRelativeX < 0) {\n\t\t\t\t\t\tbase.dragDirection = base.owl.dragDirection = \"left\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.dragDirection = base.owl.dragDirection = \"right\";\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.newRelativeX !== 0) {\n\t\t\t\t\t\tnewPosition = base.getNewPosition();\n\t\t\t\t\t\tbase.goTo(newPosition, false, \"drag\");\n\t\t\t\t\t\tif (locals.targetElement === ev.target && base.browser.isTouch !== true) {\n\t\t\t\t\t\t\t$(ev.target).on(\"click.disable\", function (ev) {\n\t\t\t\t\t\t\t\tev.stopImmediatePropagation();\n\t\t\t\t\t\t\t\tev.stopPropagation();\n\t\t\t\t\t\t\t\tev.preventDefault();\n\t\t\t\t\t\t\t\t$(ev.target).off(\"click.disable\");\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\thandlers = $._data(ev.target, \"events\").click;\n\t\t\t\t\t\t\towlStopEvent = handlers.pop();\n\t\t\t\t\t\t\thandlers.splice(0, 0, owlStopEvent);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tswapEvents(\"off\");\n\t\t\t\t}\n\t\t\t\tbase.$elem.on(base.ev_types.start, \".owl-wrapper\", dragStart);\n\t\t\t},\n\n\t\t\tgetNewPosition : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tnewPosition = base.closestItem();\n\n\t\t\t\tif (newPosition > base.maximumItem) {\n\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\tnewPosition  = base.maximumItem;\n\t\t\t\t} else if (base.newPosX >= 0) {\n\t\t\t\t\tnewPosition = 0;\n\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t}\n\t\t\t\treturn newPosition;\n\t\t\t},\n\t\t\tclosestItem : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tarray = base.options.scrollPerPage === true ? base.pagesInArray : base.positionsInArray,\n\t\t\t\t\tgoal = base.newPosX,\n\t\t\t\t\tclosest = null;\n\n\t\t\t\t$.each(array, function (i, v) {\n\t\t\t\t\tif (goal - (base.itemWidth / 20) > array[i + 1] && goal - (base.itemWidth / 20) < v && base.moveDirection() === \"left\") {\n\t\t\t\t\t\tclosest = v;\n\t\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\t\tbase.currentItem = $.inArray(closest, base.positionsInArray);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tbase.currentItem = i;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if (goal + (base.itemWidth / 20) < v && goal + (base.itemWidth / 20) > (array[i + 1] || array[i] - base.itemWidth) && base.moveDirection() === \"right\") {\n\t\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\t\tclosest = array[i + 1] || array[array.length - 1];\n\t\t\t\t\t\t\tbase.currentItem = $.inArray(closest, base.positionsInArray);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tclosest = array[i + 1];\n\t\t\t\t\t\t\tbase.currentItem = i + 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn base.currentItem;\n\t\t\t},\n\n\t\t\tmoveDirection : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tdirection;\n\t\t\t\tif (base.newRelativeX < 0) {\n\t\t\t\t\tdirection = \"right\";\n\t\t\t\t\tbase.playDirection = \"next\";\n\t\t\t\t} else {\n\t\t\t\t\tdirection = \"left\";\n\t\t\t\t\tbase.playDirection = \"prev\";\n\t\t\t\t}\n\t\t\t\treturn direction;\n\t\t\t},\n\n\t\t\tcustomEvents : function () {\n\t\t\t\t/*jslint unparam: true*/\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.on(\"owl.next\", function () {\n\t\t\t\t\tbase.next();\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.prev\", function () {\n\t\t\t\t\tbase.prev();\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.play\", function (event, speed) {\n\t\t\t\t\tbase.options.autoPlay = speed;\n\t\t\t\t\tbase.play();\n\t\t\t\t\tbase.hoverStatus = \"play\";\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.stop\", function () {\n\t\t\t\t\tbase.stop();\n\t\t\t\t\tbase.hoverStatus = \"stop\";\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.goTo\", function (event, item) {\n\t\t\t\t\tbase.goTo(item);\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.jumpTo\", function (event, item) {\n\t\t\t\t\tbase.jumpTo(item);\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tstopOnHover : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.stopOnHover === true && base.browser.isTouch !== true && base.options.autoPlay !== false) {\n\t\t\t\t\tbase.$elem.on(\"mouseover\", function () {\n\t\t\t\t\t\tbase.stop();\n\t\t\t\t\t});\n\t\t\t\t\tbase.$elem.on(\"mouseout\", function () {\n\t\t\t\t\t\tif (base.hoverStatus !== \"stop\") {\n\t\t\t\t\t\t\tbase.play();\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlazyLoad : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ti,\n\t\t\t\t\t$item,\n\t\t\t\t\titemNumber,\n\t\t\t\t\t$lazyImg,\n\t\t\t\t\tfollow;\n\n\t\t\t\tif (base.options.lazyLoad === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\t$item = $(base.$owlItems[i]);\n\n\t\t\t\t\tif ($item.data(\"owl-loaded\") === \"loaded\") {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\titemNumber = $item.data(\"owl-item\");\n\t\t\t\t\t$lazyImg = $item.find(\".lazyOwl\");\n\n\t\t\t\t\tif (typeof $lazyImg.data(\"src\") !== \"string\") {\n\t\t\t\t\t\t$item.data(\"owl-loaded\", \"loaded\");\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t\tif ($item.data(\"owl-loaded\") === undefined) {\n\t\t\t\t\t\t$lazyImg.hide();\n\t\t\t\t\t\t$item.addClass(\"loading\").data(\"owl-loaded\", \"checked\");\n\t\t\t\t\t}\n\t\t\t\t\tif (base.options.lazyFollow === true) {\n\t\t\t\t\t\tfollow = itemNumber >= base.currentItem;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfollow = true;\n\t\t\t\t\t}\n\t\t\t\t\tif (follow && itemNumber < base.currentItem + base.options.items && $lazyImg.length) {\n\t\t\t\t\t\tbase.lazyPreload($item, $lazyImg);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlazyPreload : function ($item, $lazyImg) {\n\t\t\t\tvar base = this,\n\t\t\t\t\titerations = 0,\n\t\t\t\t\tisBackgroundImg;\n\n\t\t\t\tif ($lazyImg.prop(\"tagName\") === \"DIV\") {\n\t\t\t\t\t$lazyImg.css(\"background-image\", \"url(\" + $lazyImg.data(\"src\") + \")\");\n\t\t\t\t\tisBackgroundImg = true;\n\t\t\t\t} else {\n\t\t\t\t\t$lazyImg[0].src = $lazyImg.data(\"src\");\n\t\t\t\t}\n\n\t\t\t\tfunction showImage() {\n\t\t\t\t\t$item.data(\"owl-loaded\", \"loaded\").removeClass(\"loading\");\n\t\t\t\t\t$lazyImg.removeAttr(\"data-src\");\n\t\t\t\t\tif (base.options.lazyEffect === \"fade\") {\n\t\t\t\t\t\t$lazyImg.fadeIn(400);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t$lazyImg.show();\n\t\t\t\t\t}\n\t\t\t\t\tif (typeof base.options.afterLazyLoad === \"function\") {\n\t\t\t\t\t\tbase.options.afterLazyLoad.apply(this, [base.$elem]);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction checkLazyImage() {\n\t\t\t\t\titerations += 1;\n\t\t\t\t\tif (base.completeImg($lazyImg.get(0)) || isBackgroundImg === true) {\n\t\t\t\t\t\tshowImage();\n\t\t\t\t\t} else if (iterations <= 100) {//if image loads in less than 10 seconds \n\t\t\t\t\t\twindow.setTimeout(checkLazyImage, 100);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tshowImage();\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tcheckLazyImage();\n\t\t\t},\n\n\t\t\tautoHeight : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\t$currentimg = $(base.$owlItems[base.currentItem]).find(\"img\"),\n\t\t\t\t\titerations;\n\n\t\t\t\tfunction addHeight() {\n\t\t\t\t\tvar $currentItem = $(base.$owlItems[base.currentItem]).height();\n\t\t\t\t\tbase.wrapperOuter.css(\"height\", $currentItem + \"px\");\n\t\t\t\t\tif (!base.wrapperOuter.hasClass(\"autoHeight\")) {\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.wrapperOuter.addClass(\"autoHeight\");\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction checkImage() {\n\t\t\t\t\titerations += 1;\n\t\t\t\t\tif (base.completeImg($currentimg.get(0))) {\n\t\t\t\t\t\taddHeight();\n\t\t\t\t\t} else if (iterations <= 100) { //if image loads in less than 10 seconds \n\t\t\t\t\t\twindow.setTimeout(checkImage, 100);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.wrapperOuter.css(\"height\", \"\"); //Else remove height attribute\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ($currentimg.get(0) !== undefined) {\n\t\t\t\t\titerations = 0;\n\t\t\t\t\tcheckImage();\n\t\t\t\t} else {\n\t\t\t\t\taddHeight();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tcompleteImg : function (img) {\n\t\t\t\tvar naturalWidthType;\n\n\t\t\t\tif (!img.complete) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tnaturalWidthType = typeof img.naturalWidth;\n\t\t\t\tif (naturalWidthType !== \"undefined\" && img.naturalWidth === 0) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\n\t\t\tonVisibleItems : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ti;\n\n\t\t\t\tif (base.options.addClassActive === true) {\n\t\t\t\t\tbase.$owlItems.removeClass(\"active\");\n\t\t\t\t}\n\t\t\t\tbase.visibleItems = [];\n\t\t\t\tfor (i = base.currentItem; i < base.currentItem + base.options.items; i += 1) {\n\t\t\t\t\tbase.visibleItems.push(i);\n\n\t\t\t\t\tif (base.options.addClassActive === true) {\n\t\t\t\t\t\t$(base.$owlItems[i]).addClass(\"active\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.owl.visibleItems = base.visibleItems;\n\t\t\t},\n\n\t\t\ttransitionTypes : function (className) {\n\t\t\t\tvar base = this;\n\t\t\t\t//Currently available: \"fade\", \"backSlide\", \"goDown\", \"fadeUp\"\n\t\t\t\tbase.outClass = \"owl-\" + className + \"-out\";\n\t\t\t\tbase.inClass = \"owl-\" + className + \"-in\";\n\t\t\t},\n\n\t\t\tsingleItemTransition : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\toutClass = base.outClass,\n\t\t\t\t\tinClass = base.inClass,\n\t\t\t\t\t$currentItem = base.$owlItems.eq(base.currentItem),\n\t\t\t\t\t$prevItem = base.$owlItems.eq(base.prevItem),\n\t\t\t\t\tprevPos = Math.abs(base.positionsInArray[base.currentItem]) + base.positionsInArray[base.prevItem],\n\t\t\t\t\torigin = Math.abs(base.positionsInArray[base.currentItem]) + base.itemWidth / 2,\n\t\t\t\t\tanimEnd = 'webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend';\n\n\t\t\t\tbase.isTransition = true;\n\n\t\t\t\tbase.$owlWrapper\n\t\t\t\t\t.addClass('owl-origin')\n\t\t\t\t\t.css({\n\t\t\t\t\t\t\"-webkit-transform-origin\" : origin + \"px\",\n\t\t\t\t\t\t\"-moz-perspective-origin\" : origin + \"px\",\n\t\t\t\t\t\t\"perspective-origin\" : origin + \"px\"\n\t\t\t\t\t});\n\t\t\t\tfunction transStyles(prevPos) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\t\"position\" : \"relative\",\n\t\t\t\t\t\t\"left\" : prevPos + \"px\"\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t$prevItem\n\t\t\t\t\t.css(transStyles(prevPos, 10))\n\t\t\t\t\t.addClass(outClass)\n\t\t\t\t\t.on(animEnd, function () {\n\t\t\t\t\t\tbase.endPrev = true;\n\t\t\t\t\t\t$prevItem.off(animEnd);\n\t\t\t\t\t\tbase.clearTransStyle($prevItem, outClass);\n\t\t\t\t\t});\n\n\t\t\t\t$currentItem\n\t\t\t\t\t.addClass(inClass)\n\t\t\t\t\t.on(animEnd, function () {\n\t\t\t\t\t\tbase.endCurrent = true;\n\t\t\t\t\t\t$currentItem.off(animEnd);\n\t\t\t\t\t\tbase.clearTransStyle($currentItem, inClass);\n\t\t\t\t\t});\n\t\t\t},\n\n\t\t\tclearTransStyle : function (item, classToRemove) {\n\t\t\t\tvar base = this;\n\t\t\t\titem.css({\n\t\t\t\t\t\"position\" : \"\",\n\t\t\t\t\t\"left\" : \"\"\n\t\t\t\t}).removeClass(classToRemove);\n\n\t\t\t\tif (base.endPrev && base.endCurrent) {\n\t\t\t\t\tbase.$owlWrapper.removeClass('owl-origin');\n\t\t\t\t\tbase.endPrev = false;\n\t\t\t\t\tbase.endCurrent = false;\n\t\t\t\t\tbase.isTransition = false;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\towlStatus : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.owl = {\n\t\t\t\t\t\"userOptions\"   : base.userOptions,\n\t\t\t\t\t\"baseElement\"   : base.$elem,\n\t\t\t\t\t\"userItems\"     : base.$userItems,\n\t\t\t\t\t\"owlItems\"      : base.$owlItems,\n\t\t\t\t\t\"currentItem\"   : base.currentItem,\n\t\t\t\t\t\"prevItem\"      : base.prevItem,\n\t\t\t\t\t\"visibleItems\"  : base.visibleItems,\n\t\t\t\t\t\"isTouch\"       : base.browser.isTouch,\n\t\t\t\t\t\"browser\"       : base.browser,\n\t\t\t\t\t\"dragDirection\" : base.dragDirection\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tclearEvents : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.off(\".owl owl mousedown.disableTextSelect\");\n\t\t\t\t$(document).off(\".owl owl\");\n\t\t\t\t$(window).off(\"resize\", base.resizer);\n\t\t\t},\n\n\t\t\tunWrap : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.$elem.children().length !== 0) {\n\t\t\t\t\tbase.$owlWrapper.unwrap();\n\t\t\t\t\tbase.$userItems.unwrap().unwrap();\n\t\t\t\t\tif (base.owlControls) {\n\t\t\t\t\t\tbase.owlControls.remove();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.clearEvents();\n\t\t\t\tbase.$elem\n\t\t\t\t\t.attr(\"style\", base.$elem.data(\"owl-originalStyles\") || \"\")\n\t\t\t\t\t.attr(\"class\", base.$elem.data(\"owl-originalClasses\"));\n\t\t\t},\n\n\t\t\tdestroy : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.stop();\n\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.$elem.removeData();\n\t\t\t},\n\n\t\t\treinit : function (newOptions) {\n\t\t\t\tvar base = this,\n\t\t\t\t\toptions = $.extend({}, base.userOptions, newOptions);\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.init(options, base.$elem);\n\t\t\t},\n\n\t\t\taddItem : function (htmlString, targetPosition) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tposition;\n\n\t\t\t\tif (!htmlString) {return false; }\n\n\t\t\t\tif (base.$elem.children().length === 0) {\n\t\t\t\t\tbase.$elem.append(htmlString);\n\t\t\t\t\tbase.setVars();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.unWrap();\n\t\t\t\tif (targetPosition === undefined || targetPosition === -1) {\n\t\t\t\t\tposition = -1;\n\t\t\t\t} else {\n\t\t\t\t\tposition = targetPosition;\n\t\t\t\t}\n\t\t\t\tif (position >= base.$userItems.length || position === -1) {\n\t\t\t\t\tbase.$userItems.eq(-1).after(htmlString);\n\t\t\t\t} else {\n\t\t\t\t\tbase.$userItems.eq(position).before(htmlString);\n\t\t\t\t}\n\n\t\t\t\tbase.setVars();\n\t\t\t},\n\n\t\t\tremoveItem : function (targetPosition) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tposition;\n\n\t\t\t\tif (base.$elem.children().length === 0) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (targetPosition === undefined || targetPosition === -1) {\n\t\t\t\t\tposition = -1;\n\t\t\t\t} else {\n\t\t\t\t\tposition = targetPosition;\n\t\t\t\t}\n\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.$userItems.eq(position).remove();\n\t\t\t\tbase.setVars();\n\t\t\t}\n\n\t\t};\n\n\t\t$.fn.owlCarousel = function (options) {\n\t\t\treturn this.each(function () {\n\t\t\t\tif ($(this).data(\"owl-init\") === true) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\t$(this).data(\"owl-init\", true);\n\t\t\t\tvar carousel = Object.create(Carousel);\n\t\t\t\tcarousel.init(options, this);\n\t\t\t\t$.data(this, \"owlCarousel\", carousel);\n\t\t\t});\n\t\t};\n\n\t\t$.fn.owlCarousel.options = {\n\n\t\t\titems : 5,\n\t\t\titemsCustom : false,\n\t\t\titemsDesktop : [1199, 4],\n\t\t\titemsDesktopSmall : [979, 3],\n\t\t\titemsTablet : [768, 2],\n\t\t\titemsTabletSmall : false,\n\t\t\titemsMobile : [479, 1],\n\t\t\tsingleItem : false,\n\t\t\titemsScaleUp : false,\n\n\t\t\tslideSpeed : 200,\n\t\t\tpaginationSpeed : 800,\n\t\t\trewindSpeed : 1000,\n\n\t\t\tautoPlay : false,\n\t\t\tstopOnHover : false,\n\n\t\t\tnavigation : false,\n\t\t\tnavigationText : [\"prev\", \"next\"],\n\t\t\trewindNav : true,\n\t\t\tscrollPerPage : false,\n\n\t\t\tpagination : true,\n\t\t\tpaginationNumbers : false,\n\n\t\t\tresponsive : true,\n\t\t\tresponsiveRefreshRate : 200,\n\t\t\tresponsiveBaseWidth : window,\n\n\t\t\tbaseClass : \"owl-carousel\",\n\t\t\ttheme : \"owl-theme\",\n\n\t\t\tlazyLoad : false,\n\t\t\tlazyFollow : true,\n\t\t\tlazyEffect : \"fade\",\n\n\t\t\tautoHeight : false,\n\n\t\t\tjsonPath : false,\n\t\t\tjsonSuccess : false,\n\n\t\t\tdragBeforeAnimFinish : true,\n\t\t\tmouseDrag : true,\n\t\t\ttouchDrag : true,\n\n\t\t\taddClassActive : false,\n\t\t\ttransitionStyle : false,\n\n\t\t\tbeforeUpdate : false,\n\t\t\tafterUpdate : false,\n\t\t\tbeforeInit : false,\n\t\t\tafterInit : false,\n\t\t\tbeforeMove : false,\n\t\t\tafterMove : false,\n\t\t\tafterAction : false,\n\t\t\tstartDragging : false,\n\t\t\tafterLazyLoad: false\n\t\t};\n\t}($, window, document));\n});\n","Plazathemes_Categorytab/js/categorytab.js":"define('js/theme', [\r\n    'jquery',\r\n    'domReady!'\r\n], function ($) {\r\n    'use strict';\r\n   /* for check in this file we only add jquery code that display(in console) class of element which selector used */\r\n\r\n});","Plazathemes_Categorytop/js/jquery-1.9.1.min.js":"/*! jQuery v1.9.1 | (c) 2005, 2012 jQuery Foundation, Inc. | jquery.org/license\n//@ sourceMappingURL=jquery.min.map\n*/(function(e,t){var n,r,i=typeof t,o=e.document,a=e.location,s=e.jQuery,u=e.$,l={},c=[],p=\"1.9.1\",f=c.concat,d=c.push,h=c.slice,g=c.indexOf,m=l.toString,y=l.hasOwnProperty,v=p.trim,b=function(e,t){return new b.fn.init(e,t,r)},x=/[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/.source,w=/\\S+/g,T=/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,N=/^(?:(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,C=/^<(\\w+)\\s*\\/?>(?:<\\/\\1>|)$/,k=/^[\\],:{}\\s]*$/,E=/(?:^|:|,)(?:\\s*\\[)+/g,S=/\\\\(?:[\"\\\\\\/bfnrt]|u[\\da-fA-F]{4})/g,A=/\"[^\"\\\\\\r\\n]*\"|true|false|null|-?(?:\\d+\\.|)\\d+(?:[eE][+-]?\\d+|)/g,j=/^-ms-/,D=/-([\\da-z])/gi,L=function(e,t){return t.toUpperCase()},H=function(e){(o.addEventListener||\"load\"===e.type||\"complete\"===o.readyState)&&(q(),b.ready())},q=function(){o.addEventListener?(o.removeEventListener(\"DOMContentLoaded\",H,!1),e.removeEventListener(\"load\",H,!1)):(o.detachEvent(\"onreadystatechange\",H),e.detachEvent(\"onload\",H))};b.fn=b.prototype={jquery:p,constructor:b,init:function(e,n,r){var i,a;if(!e)return this;if(\"string\"==typeof e){if(i=\"<\"===e.charAt(0)&&\">\"===e.charAt(e.length-1)&&e.length>=3?[null,e,null]:N.exec(e),!i||!i[1]&&n)return!n||n.jquery?(n||r).find(e):this.constructor(n).find(e);if(i[1]){if(n=n instanceof b?n[0]:n,b.merge(this,b.parseHTML(i[1],n&&n.nodeType?n.ownerDocument||n:o,!0)),C.test(i[1])&&b.isPlainObject(n))for(i in n)b.isFunction(this[i])?this[i](n[i]):this.attr(i,n[i]);return this}if(a=o.getElementById(i[2]),a&&a.parentNode){if(a.id!==i[2])return r.find(e);this.length=1,this[0]=a}return this.context=o,this.selector=e,this}return e.nodeType?(this.context=this[0]=e,this.length=1,this):b.isFunction(e)?r.ready(e):(e.selector!==t&&(this.selector=e.selector,this.context=e.context),b.makeArray(e,this))},selector:\"\",length:0,size:function(){return this.length},toArray:function(){return h.call(this)},get:function(e){return null==e?this.toArray():0>e?this[this.length+e]:this[e]},pushStack:function(e){var t=b.merge(this.constructor(),e);return t.prevObject=this,t.context=this.context,t},each:function(e,t){return b.each(this,e,t)},ready:function(e){return b.ready.promise().done(e),this},slice:function(){return this.pushStack(h.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(0>e?t:0);return this.pushStack(n>=0&&t>n?[this[n]]:[])},map:function(e){return this.pushStack(b.map(this,function(t,n){return e.call(t,n,t)}))},end:function(){return this.prevObject||this.constructor(null)},push:d,sort:[].sort,splice:[].splice},b.fn.init.prototype=b.fn,b.extend=b.fn.extend=function(){var e,n,r,i,o,a,s=arguments[0]||{},u=1,l=arguments.length,c=!1;for(\"boolean\"==typeof s&&(c=s,s=arguments[1]||{},u=2),\"object\"==typeof s||b.isFunction(s)||(s={}),l===u&&(s=this,--u);l>u;u++)if(null!=(o=arguments[u]))for(i in o)e=s[i],r=o[i],s!==r&&(c&&r&&(b.isPlainObject(r)||(n=b.isArray(r)))?(n?(n=!1,a=e&&b.isArray(e)?e:[]):a=e&&b.isPlainObject(e)?e:{},s[i]=b.extend(c,a,r)):r!==t&&(s[i]=r));return s},b.extend({noConflict:function(t){return e.$===b&&(e.$=u),t&&e.jQuery===b&&(e.jQuery=s),b},isReady:!1,readyWait:1,holdReady:function(e){e?b.readyWait++:b.ready(!0)},ready:function(e){if(e===!0?!--b.readyWait:!b.isReady){if(!o.body)return setTimeout(b.ready);b.isReady=!0,e!==!0&&--b.readyWait>0||(n.resolveWith(o,[b]),b.fn.trigger&&b(o).trigger(\"ready\").off(\"ready\"))}},isFunction:function(e){return\"function\"===b.type(e)},isArray:Array.isArray||function(e){return\"array\"===b.type(e)},isWindow:function(e){return null!=e&&e==e.window},isNumeric:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},type:function(e){return null==e?e+\"\":\"object\"==typeof e||\"function\"==typeof e?l[m.call(e)]||\"object\":typeof e},isPlainObject:function(e){if(!e||\"object\"!==b.type(e)||e.nodeType||b.isWindow(e))return!1;try{if(e.constructor&&!y.call(e,\"constructor\")&&!y.call(e.constructor.prototype,\"isPrototypeOf\"))return!1}catch(n){return!1}var r;for(r in e);return r===t||y.call(e,r)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},error:function(e){throw Error(e)},parseHTML:function(e,t,n){if(!e||\"string\"!=typeof e)return null;\"boolean\"==typeof t&&(n=t,t=!1),t=t||o;var r=C.exec(e),i=!n&&[];return r?[t.createElement(r[1])]:(r=b.buildFragment([e],t,i),i&&b(i).remove(),b.merge([],r.childNodes))},parseJSON:function(n){return e.JSON&&e.JSON.parse?e.JSON.parse(n):null===n?n:\"string\"==typeof n&&(n=b.trim(n),n&&k.test(n.replace(S,\"@\").replace(A,\"]\").replace(E,\"\")))?Function(\"return \"+n)():(b.error(\"Invalid JSON: \"+n),t)},parseXML:function(n){var r,i;if(!n||\"string\"!=typeof n)return null;try{e.DOMParser?(i=new DOMParser,r=i.parseFromString(n,\"text/xml\")):(r=new ActiveXObject(\"Microsoft.XMLDOM\"),r.async=\"false\",r.loadXML(n))}catch(o){r=t}return r&&r.documentElement&&!r.getElementsByTagName(\"parsererror\").length||b.error(\"Invalid XML: \"+n),r},noop:function(){},globalEval:function(t){t&&b.trim(t)&&(e.execScript||function(t){e.eval.call(e,t)})(t)},camelCase:function(e){return e.replace(j,\"ms-\").replace(D,L)},nodeName:function(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()},each:function(e,t,n){var r,i=0,o=e.length,a=M(e);if(n){if(a){for(;o>i;i++)if(r=t.apply(e[i],n),r===!1)break}else for(i in e)if(r=t.apply(e[i],n),r===!1)break}else if(a){for(;o>i;i++)if(r=t.call(e[i],i,e[i]),r===!1)break}else for(i in e)if(r=t.call(e[i],i,e[i]),r===!1)break;return e},trim:v&&!v.call(\"\\ufeff\\u00a0\")?function(e){return null==e?\"\":v.call(e)}:function(e){return null==e?\"\":(e+\"\").replace(T,\"\")},makeArray:function(e,t){var n=t||[];return null!=e&&(M(Object(e))?b.merge(n,\"string\"==typeof e?[e]:e):d.call(n,e)),n},inArray:function(e,t,n){var r;if(t){if(g)return g.call(t,e,n);for(r=t.length,n=n?0>n?Math.max(0,r+n):n:0;r>n;n++)if(n in t&&t[n]===e)return n}return-1},merge:function(e,n){var r=n.length,i=e.length,o=0;if(\"number\"==typeof r)for(;r>o;o++)e[i++]=n[o];else while(n[o]!==t)e[i++]=n[o++];return e.length=i,e},grep:function(e,t,n){var r,i=[],o=0,a=e.length;for(n=!!n;a>o;o++)r=!!t(e[o],o),n!==r&&i.push(e[o]);return i},map:function(e,t,n){var r,i=0,o=e.length,a=M(e),s=[];if(a)for(;o>i;i++)r=t(e[i],i,n),null!=r&&(s[s.length]=r);else for(i in e)r=t(e[i],i,n),null!=r&&(s[s.length]=r);return f.apply([],s)},guid:1,proxy:function(e,n){var r,i,o;return\"string\"==typeof n&&(o=e[n],n=e,e=o),b.isFunction(e)?(r=h.call(arguments,2),i=function(){return e.apply(n||this,r.concat(h.call(arguments)))},i.guid=e.guid=e.guid||b.guid++,i):t},access:function(e,n,r,i,o,a,s){var u=0,l=e.length,c=null==r;if(\"object\"===b.type(r)){o=!0;for(u in r)b.access(e,n,u,r[u],!0,a,s)}else if(i!==t&&(o=!0,b.isFunction(i)||(s=!0),c&&(s?(n.call(e,i),n=null):(c=n,n=function(e,t,n){return c.call(b(e),n)})),n))for(;l>u;u++)n(e[u],r,s?i:i.call(e[u],u,n(e[u],r)));return o?e:c?n.call(e):l?n(e[0],r):a},now:function(){return(new Date).getTime()}}),b.ready.promise=function(t){if(!n)if(n=b.Deferred(),\"complete\"===o.readyState)setTimeout(b.ready);else if(o.addEventListener)o.addEventListener(\"DOMContentLoaded\",H,!1),e.addEventListener(\"load\",H,!1);else{o.attachEvent(\"onreadystatechange\",H),e.attachEvent(\"onload\",H);var r=!1;try{r=null==e.frameElement&&o.documentElement}catch(i){}r&&r.doScroll&&function a(){if(!b.isReady){try{r.doScroll(\"left\")}catch(e){return setTimeout(a,50)}q(),b.ready()}}()}return n.promise(t)},b.each(\"Boolean Number String Function Array Date RegExp Object Error\".split(\" \"),function(e,t){l[\"[object \"+t+\"]\"]=t.toLowerCase()});function M(e){var t=e.length,n=b.type(e);return b.isWindow(e)?!1:1===e.nodeType&&t?!0:\"array\"===n||\"function\"!==n&&(0===t||\"number\"==typeof t&&t>0&&t-1 in e)}r=b(o);var _={};function F(e){var t=_[e]={};return b.each(e.match(w)||[],function(e,n){t[n]=!0}),t}b.Callbacks=function(e){e=\"string\"==typeof e?_[e]||F(e):b.extend({},e);var n,r,i,o,a,s,u=[],l=!e.once&&[],c=function(t){for(r=e.memory&&t,i=!0,a=s||0,s=0,o=u.length,n=!0;u&&o>a;a++)if(u[a].apply(t[0],t[1])===!1&&e.stopOnFalse){r=!1;break}n=!1,u&&(l?l.length&&c(l.shift()):r?u=[]:p.disable())},p={add:function(){if(u){var t=u.length;(function i(t){b.each(t,function(t,n){var r=b.type(n);\"function\"===r?e.unique&&p.has(n)||u.push(n):n&&n.length&&\"string\"!==r&&i(n)})})(arguments),n?o=u.length:r&&(s=t,c(r))}return this},remove:function(){return u&&b.each(arguments,function(e,t){var r;while((r=b.inArray(t,u,r))>-1)u.splice(r,1),n&&(o>=r&&o--,a>=r&&a--)}),this},has:function(e){return e?b.inArray(e,u)>-1:!(!u||!u.length)},empty:function(){return u=[],this},disable:function(){return u=l=r=t,this},disabled:function(){return!u},lock:function(){return l=t,r||p.disable(),this},locked:function(){return!l},fireWith:function(e,t){return t=t||[],t=[e,t.slice?t.slice():t],!u||i&&!l||(n?l.push(t):c(t)),this},fire:function(){return p.fireWith(this,arguments),this},fired:function(){return!!i}};return p},b.extend({Deferred:function(e){var t=[[\"resolve\",\"done\",b.Callbacks(\"once memory\"),\"resolved\"],[\"reject\",\"fail\",b.Callbacks(\"once memory\"),\"rejected\"],[\"notify\",\"progress\",b.Callbacks(\"memory\")]],n=\"pending\",r={state:function(){return n},always:function(){return i.done(arguments).fail(arguments),this},then:function(){var e=arguments;return b.Deferred(function(n){b.each(t,function(t,o){var a=o[0],s=b.isFunction(e[t])&&e[t];i[o[1]](function(){var e=s&&s.apply(this,arguments);e&&b.isFunction(e.promise)?e.promise().done(n.resolve).fail(n.reject).progress(n.notify):n[a+\"With\"](this===r?n.promise():this,s?[e]:arguments)})}),e=null}).promise()},promise:function(e){return null!=e?b.extend(e,r):r}},i={};return r.pipe=r.then,b.each(t,function(e,o){var a=o[2],s=o[3];r[o[1]]=a.add,s&&a.add(function(){n=s},t[1^e][2].disable,t[2][2].lock),i[o[0]]=function(){return i[o[0]+\"With\"](this===i?r:this,arguments),this},i[o[0]+\"With\"]=a.fireWith}),r.promise(i),e&&e.call(i,i),i},when:function(e){var t=0,n=h.call(arguments),r=n.length,i=1!==r||e&&b.isFunction(e.promise)?r:0,o=1===i?e:b.Deferred(),a=function(e,t,n){return function(r){t[e]=this,n[e]=arguments.length>1?h.call(arguments):r,n===s?o.notifyWith(t,n):--i||o.resolveWith(t,n)}},s,u,l;if(r>1)for(s=Array(r),u=Array(r),l=Array(r);r>t;t++)n[t]&&b.isFunction(n[t].promise)?n[t].promise().done(a(t,l,n)).fail(o.reject).progress(a(t,u,s)):--i;return i||o.resolveWith(l,n),o.promise()}}),b.support=function(){var t,n,r,a,s,u,l,c,p,f,d=o.createElement(\"div\");if(d.setAttribute(\"className\",\"t\"),d.innerHTML=\"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\",n=d.getElementsByTagName(\"*\"),r=d.getElementsByTagName(\"a\")[0],!n||!r||!n.length)return{};s=o.createElement(\"select\"),l=s.appendChild(o.createElement(\"option\")),a=d.getElementsByTagName(\"input\")[0],r.style.cssText=\"top:1px;float:left;opacity:.5\",t={getSetAttribute:\"t\"!==d.className,leadingWhitespace:3===d.firstChild.nodeType,tbody:!d.getElementsByTagName(\"tbody\").length,htmlSerialize:!!d.getElementsByTagName(\"link\").length,style:/top/.test(r.getAttribute(\"style\")),hrefNormalized:\"/a\"===r.getAttribute(\"href\"),opacity:/^0.5/.test(r.style.opacity),cssFloat:!!r.style.cssFloat,checkOn:!!a.value,optSelected:l.selected,enctype:!!o.createElement(\"form\").enctype,html5Clone:\"<:nav></:nav>\"!==o.createElement(\"nav\").cloneNode(!0).outerHTML,boxModel:\"CSS1Compat\"===o.compatMode,deleteExpando:!0,noCloneEvent:!0,inlineBlockNeedsLayout:!1,shrinkWrapBlocks:!1,reliableMarginRight:!0,boxSizingReliable:!0,pixelPosition:!1},a.checked=!0,t.noCloneChecked=a.cloneNode(!0).checked,s.disabled=!0,t.optDisabled=!l.disabled;try{delete d.test}catch(h){t.deleteExpando=!1}a=o.createElement(\"input\"),a.setAttribute(\"value\",\"\"),t.input=\"\"===a.getAttribute(\"value\"),a.value=\"t\",a.setAttribute(\"type\",\"radio\"),t.radioValue=\"t\"===a.value,a.setAttribute(\"checked\",\"t\"),a.setAttribute(\"name\",\"t\"),u=o.createDocumentFragment(),u.appendChild(a),t.appendChecked=a.checked,t.checkClone=u.cloneNode(!0).cloneNode(!0).lastChild.checked,d.attachEvent&&(d.attachEvent(\"onclick\",function(){t.noCloneEvent=!1}),d.cloneNode(!0).click());for(f in{submit:!0,change:!0,focusin:!0})d.setAttribute(c=\"on\"+f,\"t\"),t[f+\"Bubbles\"]=c in e||d.attributes[c].expando===!1;return d.style.backgroundClip=\"content-box\",d.cloneNode(!0).style.backgroundClip=\"\",t.clearCloneStyle=\"content-box\"===d.style.backgroundClip,b(function(){var n,r,a,s=\"padding:0;margin:0;border:0;display:block;box-sizing:content-box;-moz-box-sizing:content-box;-webkit-box-sizing:content-box;\",u=o.getElementsByTagName(\"body\")[0];u&&(n=o.createElement(\"div\"),n.style.cssText=\"border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px\",u.appendChild(n).appendChild(d),d.innerHTML=\"<table><tr><td></td><td>t</td></tr></table>\",a=d.getElementsByTagName(\"td\"),a[0].style.cssText=\"padding:0;margin:0;border:0;display:none\",p=0===a[0].offsetHeight,a[0].style.display=\"\",a[1].style.display=\"none\",t.reliableHiddenOffsets=p&&0===a[0].offsetHeight,d.innerHTML=\"\",d.style.cssText=\"box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;\",t.boxSizing=4===d.offsetWidth,t.doesNotIncludeMarginInBodyOffset=1!==u.offsetTop,e.getComputedStyle&&(t.pixelPosition=\"1%\"!==(e.getComputedStyle(d,null)||{}).top,t.boxSizingReliable=\"4px\"===(e.getComputedStyle(d,null)||{width:\"4px\"}).width,r=d.appendChild(o.createElement(\"div\")),r.style.cssText=d.style.cssText=s,r.style.marginRight=r.style.width=\"0\",d.style.width=\"1px\",t.reliableMarginRight=!parseFloat((e.getComputedStyle(r,null)||{}).marginRight)),typeof d.style.zoom!==i&&(d.innerHTML=\"\",d.style.cssText=s+\"width:1px;padding:1px;display:inline;zoom:1\",t.inlineBlockNeedsLayout=3===d.offsetWidth,d.style.display=\"block\",d.innerHTML=\"<div></div>\",d.firstChild.style.width=\"5px\",t.shrinkWrapBlocks=3!==d.offsetWidth,t.inlineBlockNeedsLayout&&(u.style.zoom=1)),u.removeChild(n),n=d=a=r=null)}),n=s=u=l=r=a=null,t}();var O=/(?:\\{[\\s\\S]*\\}|\\[[\\s\\S]*\\])$/,B=/([A-Z])/g;function P(e,n,r,i){if(b.acceptData(e)){var o,a,s=b.expando,u=\"string\"==typeof n,l=e.nodeType,p=l?b.cache:e,f=l?e[s]:e[s]&&s;if(f&&p[f]&&(i||p[f].data)||!u||r!==t)return f||(l?e[s]=f=c.pop()||b.guid++:f=s),p[f]||(p[f]={},l||(p[f].toJSON=b.noop)),(\"object\"==typeof n||\"function\"==typeof n)&&(i?p[f]=b.extend(p[f],n):p[f].data=b.extend(p[f].data,n)),o=p[f],i||(o.data||(o.data={}),o=o.data),r!==t&&(o[b.camelCase(n)]=r),u?(a=o[n],null==a&&(a=o[b.camelCase(n)])):a=o,a}}function R(e,t,n){if(b.acceptData(e)){var r,i,o,a=e.nodeType,s=a?b.cache:e,u=a?e[b.expando]:b.expando;if(s[u]){if(t&&(o=n?s[u]:s[u].data)){b.isArray(t)?t=t.concat(b.map(t,b.camelCase)):t in o?t=[t]:(t=b.camelCase(t),t=t in o?[t]:t.split(\" \"));for(r=0,i=t.length;i>r;r++)delete o[t[r]];if(!(n?$:b.isEmptyObject)(o))return}(n||(delete s[u].data,$(s[u])))&&(a?b.cleanData([e],!0):b.support.deleteExpando||s!=s.window?delete s[u]:s[u]=null)}}}b.extend({cache:{},expando:\"jQuery\"+(p+Math.random()).replace(/\\D/g,\"\"),noData:{embed:!0,object:\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\",applet:!0},hasData:function(e){return e=e.nodeType?b.cache[e[b.expando]]:e[b.expando],!!e&&!$(e)},data:function(e,t,n){return P(e,t,n)},removeData:function(e,t){return R(e,t)},_data:function(e,t,n){return P(e,t,n,!0)},_removeData:function(e,t){return R(e,t,!0)},acceptData:function(e){if(e.nodeType&&1!==e.nodeType&&9!==e.nodeType)return!1;var t=e.nodeName&&b.noData[e.nodeName.toLowerCase()];return!t||t!==!0&&e.getAttribute(\"classid\")===t}}),b.fn.extend({data:function(e,n){var r,i,o=this[0],a=0,s=null;if(e===t){if(this.length&&(s=b.data(o),1===o.nodeType&&!b._data(o,\"parsedAttrs\"))){for(r=o.attributes;r.length>a;a++)i=r[a].name,i.indexOf(\"data-\")||(i=b.camelCase(i.slice(5)),W(o,i,s[i]));b._data(o,\"parsedAttrs\",!0)}return s}return\"object\"==typeof e?this.each(function(){b.data(this,e)}):b.access(this,function(n){return n===t?o?W(o,e,b.data(o,e)):null:(this.each(function(){b.data(this,e,n)}),t)},null,n,arguments.length>1,null,!0)},removeData:function(e){return this.each(function(){b.removeData(this,e)})}});function W(e,n,r){if(r===t&&1===e.nodeType){var i=\"data-\"+n.replace(B,\"-$1\").toLowerCase();if(r=e.getAttribute(i),\"string\"==typeof r){try{r=\"true\"===r?!0:\"false\"===r?!1:\"null\"===r?null:+r+\"\"===r?+r:O.test(r)?b.parseJSON(r):r}catch(o){}b.data(e,n,r)}else r=t}return r}function $(e){var t;for(t in e)if((\"data\"!==t||!b.isEmptyObject(e[t]))&&\"toJSON\"!==t)return!1;return!0}b.extend({queue:function(e,n,r){var i;return e?(n=(n||\"fx\")+\"queue\",i=b._data(e,n),r&&(!i||b.isArray(r)?i=b._data(e,n,b.makeArray(r)):i.push(r)),i||[]):t},dequeue:function(e,t){t=t||\"fx\";var n=b.queue(e,t),r=n.length,i=n.shift(),o=b._queueHooks(e,t),a=function(){b.dequeue(e,t)};\"inprogress\"===i&&(i=n.shift(),r--),o.cur=i,i&&(\"fx\"===t&&n.unshift(\"inprogress\"),delete o.stop,i.call(e,a,o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+\"queueHooks\";return b._data(e,n)||b._data(e,n,{empty:b.Callbacks(\"once memory\").add(function(){b._removeData(e,t+\"queue\"),b._removeData(e,n)})})}}),b.fn.extend({queue:function(e,n){var r=2;return\"string\"!=typeof e&&(n=e,e=\"fx\",r--),r>arguments.length?b.queue(this[0],e):n===t?this:this.each(function(){var t=b.queue(this,e,n);b._queueHooks(this,e),\"fx\"===e&&\"inprogress\"!==t[0]&&b.dequeue(this,e)})},dequeue:function(e){return this.each(function(){b.dequeue(this,e)})},delay:function(e,t){return e=b.fx?b.fx.speeds[e]||e:e,t=t||\"fx\",this.queue(t,function(t,n){var r=setTimeout(t,e);n.stop=function(){clearTimeout(r)}})},clearQueue:function(e){return this.queue(e||\"fx\",[])},promise:function(e,n){var r,i=1,o=b.Deferred(),a=this,s=this.length,u=function(){--i||o.resolveWith(a,[a])};\"string\"!=typeof e&&(n=e,e=t),e=e||\"fx\";while(s--)r=b._data(a[s],e+\"queueHooks\"),r&&r.empty&&(i++,r.empty.add(u));return u(),o.promise(n)}});var I,z,X=/[\\t\\r\\n]/g,U=/\\r/g,V=/^(?:input|select|textarea|button|object)$/i,Y=/^(?:a|area)$/i,J=/^(?:checked|selected|autofocus|autoplay|async|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped)$/i,G=/^(?:checked|selected)$/i,Q=b.support.getSetAttribute,K=b.support.input;b.fn.extend({attr:function(e,t){return b.access(this,b.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){b.removeAttr(this,e)})},prop:function(e,t){return b.access(this,b.prop,e,t,arguments.length>1)},removeProp:function(e){return e=b.propFix[e]||e,this.each(function(){try{this[e]=t,delete this[e]}catch(n){}})},addClass:function(e){var t,n,r,i,o,a=0,s=this.length,u=\"string\"==typeof e&&e;if(b.isFunction(e))return this.each(function(t){b(this).addClass(e.call(this,t,this.className))});if(u)for(t=(e||\"\").match(w)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(\" \"+n.className+\" \").replace(X,\" \"):\" \")){o=0;while(i=t[o++])0>r.indexOf(\" \"+i+\" \")&&(r+=i+\" \");n.className=b.trim(r)}return this},removeClass:function(e){var t,n,r,i,o,a=0,s=this.length,u=0===arguments.length||\"string\"==typeof e&&e;if(b.isFunction(e))return this.each(function(t){b(this).removeClass(e.call(this,t,this.className))});if(u)for(t=(e||\"\").match(w)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(\" \"+n.className+\" \").replace(X,\" \"):\"\")){o=0;while(i=t[o++])while(r.indexOf(\" \"+i+\" \")>=0)r=r.replace(\" \"+i+\" \",\" \");n.className=e?b.trim(r):\"\"}return this},toggleClass:function(e,t){var n=typeof e,r=\"boolean\"==typeof t;return b.isFunction(e)?this.each(function(n){b(this).toggleClass(e.call(this,n,this.className,t),t)}):this.each(function(){if(\"string\"===n){var o,a=0,s=b(this),u=t,l=e.match(w)||[];while(o=l[a++])u=r?u:!s.hasClass(o),s[u?\"addClass\":\"removeClass\"](o)}else(n===i||\"boolean\"===n)&&(this.className&&b._data(this,\"__className__\",this.className),this.className=this.className||e===!1?\"\":b._data(this,\"__className__\")||\"\")})},hasClass:function(e){var t=\" \"+e+\" \",n=0,r=this.length;for(;r>n;n++)if(1===this[n].nodeType&&(\" \"+this[n].className+\" \").replace(X,\" \").indexOf(t)>=0)return!0;return!1},val:function(e){var n,r,i,o=this[0];{if(arguments.length)return i=b.isFunction(e),this.each(function(n){var o,a=b(this);1===this.nodeType&&(o=i?e.call(this,n,a.val()):e,null==o?o=\"\":\"number\"==typeof o?o+=\"\":b.isArray(o)&&(o=b.map(o,function(e){return null==e?\"\":e+\"\"})),r=b.valHooks[this.type]||b.valHooks[this.nodeName.toLowerCase()],r&&\"set\"in r&&r.set(this,o,\"value\")!==t||(this.value=o))});if(o)return r=b.valHooks[o.type]||b.valHooks[o.nodeName.toLowerCase()],r&&\"get\"in r&&(n=r.get(o,\"value\"))!==t?n:(n=o.value,\"string\"==typeof n?n.replace(U,\"\"):null==n?\"\":n)}}}),b.extend({valHooks:{option:{get:function(e){var t=e.attributes.value;return!t||t.specified?e.value:e.text}},select:{get:function(e){var t,n,r=e.options,i=e.selectedIndex,o=\"select-one\"===e.type||0>i,a=o?null:[],s=o?i+1:r.length,u=0>i?s:o?i:0;for(;s>u;u++)if(n=r[u],!(!n.selected&&u!==i||(b.support.optDisabled?n.disabled:null!==n.getAttribute(\"disabled\"))||n.parentNode.disabled&&b.nodeName(n.parentNode,\"optgroup\"))){if(t=b(n).val(),o)return t;a.push(t)}return a},set:function(e,t){var n=b.makeArray(t);return b(e).find(\"option\").each(function(){this.selected=b.inArray(b(this).val(),n)>=0}),n.length||(e.selectedIndex=-1),n}}},attr:function(e,n,r){var o,a,s,u=e.nodeType;if(e&&3!==u&&8!==u&&2!==u)return typeof e.getAttribute===i?b.prop(e,n,r):(a=1!==u||!b.isXMLDoc(e),a&&(n=n.toLowerCase(),o=b.attrHooks[n]||(J.test(n)?z:I)),r===t?o&&a&&\"get\"in o&&null!==(s=o.get(e,n))?s:(typeof e.getAttribute!==i&&(s=e.getAttribute(n)),null==s?t:s):null!==r?o&&a&&\"set\"in o&&(s=o.set(e,r,n))!==t?s:(e.setAttribute(n,r+\"\"),r):(b.removeAttr(e,n),t))},removeAttr:function(e,t){var n,r,i=0,o=t&&t.match(w);if(o&&1===e.nodeType)while(n=o[i++])r=b.propFix[n]||n,J.test(n)?!Q&&G.test(n)?e[b.camelCase(\"default-\"+n)]=e[r]=!1:e[r]=!1:b.attr(e,n,\"\"),e.removeAttribute(Q?n:r)},attrHooks:{type:{set:function(e,t){if(!b.support.radioValue&&\"radio\"===t&&b.nodeName(e,\"input\")){var n=e.value;return e.setAttribute(\"type\",t),n&&(e.value=n),t}}}},propFix:{tabindex:\"tabIndex\",readonly:\"readOnly\",\"for\":\"htmlFor\",\"class\":\"className\",maxlength:\"maxLength\",cellspacing:\"cellSpacing\",cellpadding:\"cellPadding\",rowspan:\"rowSpan\",colspan:\"colSpan\",usemap:\"useMap\",frameborder:\"frameBorder\",contenteditable:\"contentEditable\"},prop:function(e,n,r){var i,o,a,s=e.nodeType;if(e&&3!==s&&8!==s&&2!==s)return a=1!==s||!b.isXMLDoc(e),a&&(n=b.propFix[n]||n,o=b.propHooks[n]),r!==t?o&&\"set\"in o&&(i=o.set(e,r,n))!==t?i:e[n]=r:o&&\"get\"in o&&null!==(i=o.get(e,n))?i:e[n]},propHooks:{tabIndex:{get:function(e){var n=e.getAttributeNode(\"tabindex\");return n&&n.specified?parseInt(n.value,10):V.test(e.nodeName)||Y.test(e.nodeName)&&e.href?0:t}}}}),z={get:function(e,n){var r=b.prop(e,n),i=\"boolean\"==typeof r&&e.getAttribute(n),o=\"boolean\"==typeof r?K&&Q?null!=i:G.test(n)?e[b.camelCase(\"default-\"+n)]:!!i:e.getAttributeNode(n);return o&&o.value!==!1?n.toLowerCase():t},set:function(e,t,n){return t===!1?b.removeAttr(e,n):K&&Q||!G.test(n)?e.setAttribute(!Q&&b.propFix[n]||n,n):e[b.camelCase(\"default-\"+n)]=e[n]=!0,n}},K&&Q||(b.attrHooks.value={get:function(e,n){var r=e.getAttributeNode(n);return b.nodeName(e,\"input\")?e.defaultValue:r&&r.specified?r.value:t},set:function(e,n,r){return b.nodeName(e,\"input\")?(e.defaultValue=n,t):I&&I.set(e,n,r)}}),Q||(I=b.valHooks.button={get:function(e,n){var r=e.getAttributeNode(n);return r&&(\"id\"===n||\"name\"===n||\"coords\"===n?\"\"!==r.value:r.specified)?r.value:t},set:function(e,n,r){var i=e.getAttributeNode(r);return i||e.setAttributeNode(i=e.ownerDocument.createAttribute(r)),i.value=n+=\"\",\"value\"===r||n===e.getAttribute(r)?n:t}},b.attrHooks.contenteditable={get:I.get,set:function(e,t,n){I.set(e,\"\"===t?!1:t,n)}},b.each([\"width\",\"height\"],function(e,n){b.attrHooks[n]=b.extend(b.attrHooks[n],{set:function(e,r){return\"\"===r?(e.setAttribute(n,\"auto\"),r):t}})})),b.support.hrefNormalized||(b.each([\"href\",\"src\",\"width\",\"height\"],function(e,n){b.attrHooks[n]=b.extend(b.attrHooks[n],{get:function(e){var r=e.getAttribute(n,2);return null==r?t:r}})}),b.each([\"href\",\"src\"],function(e,t){b.propHooks[t]={get:function(e){return e.getAttribute(t,4)}}})),b.support.style||(b.attrHooks.style={get:function(e){return e.style.cssText||t},set:function(e,t){return e.style.cssText=t+\"\"}}),b.support.optSelected||(b.propHooks.selected=b.extend(b.propHooks.selected,{get:function(e){var t=e.parentNode;return t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex),null}})),b.support.enctype||(b.propFix.enctype=\"encoding\"),b.support.checkOn||b.each([\"radio\",\"checkbox\"],function(){b.valHooks[this]={get:function(e){return null===e.getAttribute(\"value\")?\"on\":e.value}}}),b.each([\"radio\",\"checkbox\"],function(){b.valHooks[this]=b.extend(b.valHooks[this],{set:function(e,n){return b.isArray(n)?e.checked=b.inArray(b(e).val(),n)>=0:t}})});var Z=/^(?:input|select|textarea)$/i,et=/^key/,tt=/^(?:mouse|contextmenu)|click/,nt=/^(?:focusinfocus|focusoutblur)$/,rt=/^([^.]*)(?:\\.(.+)|)$/;function it(){return!0}function ot(){return!1}b.event={global:{},add:function(e,n,r,o,a){var s,u,l,c,p,f,d,h,g,m,y,v=b._data(e);if(v){r.handler&&(c=r,r=c.handler,a=c.selector),r.guid||(r.guid=b.guid++),(u=v.events)||(u=v.events={}),(f=v.handle)||(f=v.handle=function(e){return typeof b===i||e&&b.event.triggered===e.type?t:b.event.dispatch.apply(f.elem,arguments)},f.elem=e),n=(n||\"\").match(w)||[\"\"],l=n.length;while(l--)s=rt.exec(n[l])||[],g=y=s[1],m=(s[2]||\"\").split(\".\").sort(),p=b.event.special[g]||{},g=(a?p.delegateType:p.bindType)||g,p=b.event.special[g]||{},d=b.extend({type:g,origType:y,data:o,handler:r,guid:r.guid,selector:a,needsContext:a&&b.expr.match.needsContext.test(a),namespace:m.join(\".\")},c),(h=u[g])||(h=u[g]=[],h.delegateCount=0,p.setup&&p.setup.call(e,o,m,f)!==!1||(e.addEventListener?e.addEventListener(g,f,!1):e.attachEvent&&e.attachEvent(\"on\"+g,f))),p.add&&(p.add.call(e,d),d.handler.guid||(d.handler.guid=r.guid)),a?h.splice(h.delegateCount++,0,d):h.push(d),b.event.global[g]=!0;e=null}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,p,f,d,h,g,m=b.hasData(e)&&b._data(e);if(m&&(c=m.events)){t=(t||\"\").match(w)||[\"\"],l=t.length;while(l--)if(s=rt.exec(t[l])||[],d=g=s[1],h=(s[2]||\"\").split(\".\").sort(),d){p=b.event.special[d]||{},d=(r?p.delegateType:p.bindType)||d,f=c[d]||[],s=s[2]&&RegExp(\"(^|\\\\.)\"+h.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"),u=o=f.length;while(o--)a=f[o],!i&&g!==a.origType||n&&n.guid!==a.guid||s&&!s.test(a.namespace)||r&&r!==a.selector&&(\"**\"!==r||!a.selector)||(f.splice(o,1),a.selector&&f.delegateCount--,p.remove&&p.remove.call(e,a));u&&!f.length&&(p.teardown&&p.teardown.call(e,h,m.handle)!==!1||b.removeEvent(e,d,m.handle),delete c[d])}else for(d in c)b.event.remove(e,d+t[l],n,r,!0);b.isEmptyObject(c)&&(delete m.handle,b._removeData(e,\"events\"))}},trigger:function(n,r,i,a){var s,u,l,c,p,f,d,h=[i||o],g=y.call(n,\"type\")?n.type:n,m=y.call(n,\"namespace\")?n.namespace.split(\".\"):[];if(l=f=i=i||o,3!==i.nodeType&&8!==i.nodeType&&!nt.test(g+b.event.triggered)&&(g.indexOf(\".\")>=0&&(m=g.split(\".\"),g=m.shift(),m.sort()),u=0>g.indexOf(\":\")&&\"on\"+g,n=n[b.expando]?n:new b.Event(g,\"object\"==typeof n&&n),n.isTrigger=!0,n.namespace=m.join(\".\"),n.namespace_re=n.namespace?RegExp(\"(^|\\\\.)\"+m.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"):null,n.result=t,n.target||(n.target=i),r=null==r?[n]:b.makeArray(r,[n]),p=b.event.special[g]||{},a||!p.trigger||p.trigger.apply(i,r)!==!1)){if(!a&&!p.noBubble&&!b.isWindow(i)){for(c=p.delegateType||g,nt.test(c+g)||(l=l.parentNode);l;l=l.parentNode)h.push(l),f=l;f===(i.ownerDocument||o)&&h.push(f.defaultView||f.parentWindow||e)}d=0;while((l=h[d++])&&!n.isPropagationStopped())n.type=d>1?c:p.bindType||g,s=(b._data(l,\"events\")||{})[n.type]&&b._data(l,\"handle\"),s&&s.apply(l,r),s=u&&l[u],s&&b.acceptData(l)&&s.apply&&s.apply(l,r)===!1&&n.preventDefault();if(n.type=g,!(a||n.isDefaultPrevented()||p._default&&p._default.apply(i.ownerDocument,r)!==!1||\"click\"===g&&b.nodeName(i,\"a\")||!b.acceptData(i)||!u||!i[g]||b.isWindow(i))){f=i[u],f&&(i[u]=null),b.event.triggered=g;try{i[g]()}catch(v){}b.event.triggered=t,f&&(i[u]=f)}return n.result}},dispatch:function(e){e=b.event.fix(e);var n,r,i,o,a,s=[],u=h.call(arguments),l=(b._data(this,\"events\")||{})[e.type]||[],c=b.event.special[e.type]||{};if(u[0]=e,e.delegateTarget=this,!c.preDispatch||c.preDispatch.call(this,e)!==!1){s=b.event.handlers.call(this,e,l),n=0;while((o=s[n++])&&!e.isPropagationStopped()){e.currentTarget=o.elem,a=0;while((i=o.handlers[a++])&&!e.isImmediatePropagationStopped())(!e.namespace_re||e.namespace_re.test(i.namespace))&&(e.handleObj=i,e.data=i.data,r=((b.event.special[i.origType]||{}).handle||i.handler).apply(o.elem,u),r!==t&&(e.result=r)===!1&&(e.preventDefault(),e.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,e),e.result}},handlers:function(e,n){var r,i,o,a,s=[],u=n.delegateCount,l=e.target;if(u&&l.nodeType&&(!e.button||\"click\"!==e.type))for(;l!=this;l=l.parentNode||this)if(1===l.nodeType&&(l.disabled!==!0||\"click\"!==e.type)){for(o=[],a=0;u>a;a++)i=n[a],r=i.selector+\" \",o[r]===t&&(o[r]=i.needsContext?b(r,this).index(l)>=0:b.find(r,this,null,[l]).length),o[r]&&o.push(i);o.length&&s.push({elem:l,handlers:o})}return n.length>u&&s.push({elem:this,handlers:n.slice(u)}),s},fix:function(e){if(e[b.expando])return e;var t,n,r,i=e.type,a=e,s=this.fixHooks[i];s||(this.fixHooks[i]=s=tt.test(i)?this.mouseHooks:et.test(i)?this.keyHooks:{}),r=s.props?this.props.concat(s.props):this.props,e=new b.Event(a),t=r.length;while(t--)n=r[t],e[n]=a[n];return e.target||(e.target=a.srcElement||o),3===e.target.nodeType&&(e.target=e.target.parentNode),e.metaKey=!!e.metaKey,s.filter?s.filter(e,a):e},props:\"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which\".split(\" \"),fixHooks:{},keyHooks:{props:\"char charCode key keyCode\".split(\" \"),filter:function(e,t){return null==e.which&&(e.which=null!=t.charCode?t.charCode:t.keyCode),e}},mouseHooks:{props:\"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement\".split(\" \"),filter:function(e,n){var r,i,a,s=n.button,u=n.fromElement;return null==e.pageX&&null!=n.clientX&&(i=e.target.ownerDocument||o,a=i.documentElement,r=i.body,e.pageX=n.clientX+(a&&a.scrollLeft||r&&r.scrollLeft||0)-(a&&a.clientLeft||r&&r.clientLeft||0),e.pageY=n.clientY+(a&&a.scrollTop||r&&r.scrollTop||0)-(a&&a.clientTop||r&&r.clientTop||0)),!e.relatedTarget&&u&&(e.relatedTarget=u===e.target?n.toElement:u),e.which||s===t||(e.which=1&s?1:2&s?3:4&s?2:0),e}},special:{load:{noBubble:!0},click:{trigger:function(){return b.nodeName(this,\"input\")&&\"checkbox\"===this.type&&this.click?(this.click(),!1):t}},focus:{trigger:function(){if(this!==o.activeElement&&this.focus)try{return this.focus(),!1}catch(e){}},delegateType:\"focusin\"},blur:{trigger:function(){return this===o.activeElement&&this.blur?(this.blur(),!1):t},delegateType:\"focusout\"},beforeunload:{postDispatch:function(e){e.result!==t&&(e.originalEvent.returnValue=e.result)}}},simulate:function(e,t,n,r){var i=b.extend(new b.Event,n,{type:e,isSimulated:!0,originalEvent:{}});r?b.event.trigger(i,null,t):b.event.dispatch.call(t,i),i.isDefaultPrevented()&&n.preventDefault()}},b.removeEvent=o.removeEventListener?function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n,!1)}:function(e,t,n){var r=\"on\"+t;e.detachEvent&&(typeof e[r]===i&&(e[r]=null),e.detachEvent(r,n))},b.Event=function(e,n){return this instanceof b.Event?(e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||e.returnValue===!1||e.getPreventDefault&&e.getPreventDefault()?it:ot):this.type=e,n&&b.extend(this,n),this.timeStamp=e&&e.timeStamp||b.now(),this[b.expando]=!0,t):new b.Event(e,n)},b.Event.prototype={isDefaultPrevented:ot,isPropagationStopped:ot,isImmediatePropagationStopped:ot,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=it,e&&(e.preventDefault?e.preventDefault():e.returnValue=!1)},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=it,e&&(e.stopPropagation&&e.stopPropagation(),e.cancelBubble=!0)},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=it,this.stopPropagation()}},b.each({mouseenter:\"mouseover\",mouseleave:\"mouseout\"},function(e,t){b.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;\nreturn(!i||i!==r&&!b.contains(r,i))&&(e.type=o.origType,n=o.handler.apply(this,arguments),e.type=t),n}}}),b.support.submitBubbles||(b.event.special.submit={setup:function(){return b.nodeName(this,\"form\")?!1:(b.event.add(this,\"click._submit keypress._submit\",function(e){var n=e.target,r=b.nodeName(n,\"input\")||b.nodeName(n,\"button\")?n.form:t;r&&!b._data(r,\"submitBubbles\")&&(b.event.add(r,\"submit._submit\",function(e){e._submit_bubble=!0}),b._data(r,\"submitBubbles\",!0))}),t)},postDispatch:function(e){e._submit_bubble&&(delete e._submit_bubble,this.parentNode&&!e.isTrigger&&b.event.simulate(\"submit\",this.parentNode,e,!0))},teardown:function(){return b.nodeName(this,\"form\")?!1:(b.event.remove(this,\"._submit\"),t)}}),b.support.changeBubbles||(b.event.special.change={setup:function(){return Z.test(this.nodeName)?((\"checkbox\"===this.type||\"radio\"===this.type)&&(b.event.add(this,\"propertychange._change\",function(e){\"checked\"===e.originalEvent.propertyName&&(this._just_changed=!0)}),b.event.add(this,\"click._change\",function(e){this._just_changed&&!e.isTrigger&&(this._just_changed=!1),b.event.simulate(\"change\",this,e,!0)})),!1):(b.event.add(this,\"beforeactivate._change\",function(e){var t=e.target;Z.test(t.nodeName)&&!b._data(t,\"changeBubbles\")&&(b.event.add(t,\"change._change\",function(e){!this.parentNode||e.isSimulated||e.isTrigger||b.event.simulate(\"change\",this.parentNode,e,!0)}),b._data(t,\"changeBubbles\",!0))}),t)},handle:function(e){var n=e.target;return this!==n||e.isSimulated||e.isTrigger||\"radio\"!==n.type&&\"checkbox\"!==n.type?e.handleObj.handler.apply(this,arguments):t},teardown:function(){return b.event.remove(this,\"._change\"),!Z.test(this.nodeName)}}),b.support.focusinBubbles||b.each({focus:\"focusin\",blur:\"focusout\"},function(e,t){var n=0,r=function(e){b.event.simulate(t,e.target,b.event.fix(e),!0)};b.event.special[t]={setup:function(){0===n++&&o.addEventListener(e,r,!0)},teardown:function(){0===--n&&o.removeEventListener(e,r,!0)}}}),b.fn.extend({on:function(e,n,r,i,o){var a,s;if(\"object\"==typeof e){\"string\"!=typeof n&&(r=r||n,n=t);for(a in e)this.on(a,n,r,e[a],o);return this}if(null==r&&null==i?(i=n,r=n=t):null==i&&(\"string\"==typeof n?(i=r,r=t):(i=r,r=n,n=t)),i===!1)i=ot;else if(!i)return this;return 1===o&&(s=i,i=function(e){return b().off(e),s.apply(this,arguments)},i.guid=s.guid||(s.guid=b.guid++)),this.each(function(){b.event.add(this,e,i,r,n)})},one:function(e,t,n,r){return this.on(e,t,n,r,1)},off:function(e,n,r){var i,o;if(e&&e.preventDefault&&e.handleObj)return i=e.handleObj,b(e.delegateTarget).off(i.namespace?i.origType+\".\"+i.namespace:i.origType,i.selector,i.handler),this;if(\"object\"==typeof e){for(o in e)this.off(o,n,e[o]);return this}return(n===!1||\"function\"==typeof n)&&(r=n,n=t),r===!1&&(r=ot),this.each(function(){b.event.remove(this,e,r,n)})},bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,\"**\"):this.off(t,e||\"**\",n)},trigger:function(e,t){return this.each(function(){b.event.trigger(e,t,this)})},triggerHandler:function(e,n){var r=this[0];return r?b.event.trigger(e,n,r,!0):t}}),function(e,t){var n,r,i,o,a,s,u,l,c,p,f,d,h,g,m,y,v,x=\"sizzle\"+-new Date,w=e.document,T={},N=0,C=0,k=it(),E=it(),S=it(),A=typeof t,j=1<<31,D=[],L=D.pop,H=D.push,q=D.slice,M=D.indexOf||function(e){var t=0,n=this.length;for(;n>t;t++)if(this[t]===e)return t;return-1},_=\"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",F=\"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",O=F.replace(\"w\",\"w#\"),B=\"([*^$|!~]?=)\",P=\"\\\\[\"+_+\"*(\"+F+\")\"+_+\"*(?:\"+B+_+\"*(?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|(\"+O+\")|)|)\"+_+\"*\\\\]\",R=\":(\"+F+\")(?:\\\\(((['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\"+P.replace(3,8)+\")*)|.*)\\\\)|)\",W=RegExp(\"^\"+_+\"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\"+_+\"+$\",\"g\"),$=RegExp(\"^\"+_+\"*,\"+_+\"*\"),I=RegExp(\"^\"+_+\"*([\\\\x20\\\\t\\\\r\\\\n\\\\f>+~])\"+_+\"*\"),z=RegExp(R),X=RegExp(\"^\"+O+\"$\"),U={ID:RegExp(\"^#(\"+F+\")\"),CLASS:RegExp(\"^\\\\.(\"+F+\")\"),NAME:RegExp(\"^\\\\[name=['\\\"]?(\"+F+\")['\\\"]?\\\\]\"),TAG:RegExp(\"^(\"+F.replace(\"w\",\"w*\")+\")\"),ATTR:RegExp(\"^\"+P),PSEUDO:RegExp(\"^\"+R),CHILD:RegExp(\"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\"+_+\"*(even|odd|(([+-]|)(\\\\d*)n|)\"+_+\"*(?:([+-]|)\"+_+\"*(\\\\d+)|))\"+_+\"*\\\\)|)\",\"i\"),needsContext:RegExp(\"^\"+_+\"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\"+_+\"*((?:-\\\\d)?\\\\d*)\"+_+\"*\\\\)|)(?=[^-]|$)\",\"i\")},V=/[\\x20\\t\\r\\n\\f]*[+~]/,Y=/^[^{]+\\{\\s*\\[native code/,J=/^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,G=/^(?:input|select|textarea|button)$/i,Q=/^h\\d$/i,K=/'|\\\\/g,Z=/\\=[\\x20\\t\\r\\n\\f]*([^'\"\\]]*)[\\x20\\t\\r\\n\\f]*\\]/g,et=/\\\\([\\da-fA-F]{1,6}[\\x20\\t\\r\\n\\f]?|.)/g,tt=function(e,t){var n=\"0x\"+t-65536;return n!==n?t:0>n?String.fromCharCode(n+65536):String.fromCharCode(55296|n>>10,56320|1023&n)};try{q.call(w.documentElement.childNodes,0)[0].nodeType}catch(nt){q=function(e){var t,n=[];while(t=this[e++])n.push(t);return n}}function rt(e){return Y.test(e+\"\")}function it(){var e,t=[];return e=function(n,r){return t.push(n+=\" \")>i.cacheLength&&delete e[t.shift()],e[n]=r}}function ot(e){return e[x]=!0,e}function at(e){var t=p.createElement(\"div\");try{return e(t)}catch(n){return!1}finally{t=null}}function st(e,t,n,r){var i,o,a,s,u,l,f,g,m,v;if((t?t.ownerDocument||t:w)!==p&&c(t),t=t||p,n=n||[],!e||\"string\"!=typeof e)return n;if(1!==(s=t.nodeType)&&9!==s)return[];if(!d&&!r){if(i=J.exec(e))if(a=i[1]){if(9===s){if(o=t.getElementById(a),!o||!o.parentNode)return n;if(o.id===a)return n.push(o),n}else if(t.ownerDocument&&(o=t.ownerDocument.getElementById(a))&&y(t,o)&&o.id===a)return n.push(o),n}else{if(i[2])return H.apply(n,q.call(t.getElementsByTagName(e),0)),n;if((a=i[3])&&T.getByClassName&&t.getElementsByClassName)return H.apply(n,q.call(t.getElementsByClassName(a),0)),n}if(T.qsa&&!h.test(e)){if(f=!0,g=x,m=t,v=9===s&&e,1===s&&\"object\"!==t.nodeName.toLowerCase()){l=ft(e),(f=t.getAttribute(\"id\"))?g=f.replace(K,\"\\\\$&\"):t.setAttribute(\"id\",g),g=\"[id='\"+g+\"'] \",u=l.length;while(u--)l[u]=g+dt(l[u]);m=V.test(e)&&t.parentNode||t,v=l.join(\",\")}if(v)try{return H.apply(n,q.call(m.querySelectorAll(v),0)),n}catch(b){}finally{f||t.removeAttribute(\"id\")}}}return wt(e.replace(W,\"$1\"),t,n,r)}a=st.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return t?\"HTML\"!==t.nodeName:!1},c=st.setDocument=function(e){var n=e?e.ownerDocument||e:w;return n!==p&&9===n.nodeType&&n.documentElement?(p=n,f=n.documentElement,d=a(n),T.tagNameNoComments=at(function(e){return e.appendChild(n.createComment(\"\")),!e.getElementsByTagName(\"*\").length}),T.attributes=at(function(e){e.innerHTML=\"<select></select>\";var t=typeof e.lastChild.getAttribute(\"multiple\");return\"boolean\"!==t&&\"string\"!==t}),T.getByClassName=at(function(e){return e.innerHTML=\"<div class='hidden e'></div><div class='hidden'></div>\",e.getElementsByClassName&&e.getElementsByClassName(\"e\").length?(e.lastChild.className=\"e\",2===e.getElementsByClassName(\"e\").length):!1}),T.getByName=at(function(e){e.id=x+0,e.innerHTML=\"<a name='\"+x+\"'></a><div name='\"+x+\"'></div>\",f.insertBefore(e,f.firstChild);var t=n.getElementsByName&&n.getElementsByName(x).length===2+n.getElementsByName(x+0).length;return T.getIdNotName=!n.getElementById(x),f.removeChild(e),t}),i.attrHandle=at(function(e){return e.innerHTML=\"<a href='#'></a>\",e.firstChild&&typeof e.firstChild.getAttribute!==A&&\"#\"===e.firstChild.getAttribute(\"href\")})?{}:{href:function(e){return e.getAttribute(\"href\",2)},type:function(e){return e.getAttribute(\"type\")}},T.getIdNotName?(i.find.ID=function(e,t){if(typeof t.getElementById!==A&&!d){var n=t.getElementById(e);return n&&n.parentNode?[n]:[]}},i.filter.ID=function(e){var t=e.replace(et,tt);return function(e){return e.getAttribute(\"id\")===t}}):(i.find.ID=function(e,n){if(typeof n.getElementById!==A&&!d){var r=n.getElementById(e);return r?r.id===e||typeof r.getAttributeNode!==A&&r.getAttributeNode(\"id\").value===e?[r]:t:[]}},i.filter.ID=function(e){var t=e.replace(et,tt);return function(e){var n=typeof e.getAttributeNode!==A&&e.getAttributeNode(\"id\");return n&&n.value===t}}),i.find.TAG=T.tagNameNoComments?function(e,n){return typeof n.getElementsByTagName!==A?n.getElementsByTagName(e):t}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if(\"*\"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},i.find.NAME=T.getByName&&function(e,n){return typeof n.getElementsByName!==A?n.getElementsByName(name):t},i.find.CLASS=T.getByClassName&&function(e,n){return typeof n.getElementsByClassName===A||d?t:n.getElementsByClassName(e)},g=[],h=[\":focus\"],(T.qsa=rt(n.querySelectorAll))&&(at(function(e){e.innerHTML=\"<select><option selected=''></option></select>\",e.querySelectorAll(\"[selected]\").length||h.push(\"\\\\[\"+_+\"*(?:checked|disabled|ismap|multiple|readonly|selected|value)\"),e.querySelectorAll(\":checked\").length||h.push(\":checked\")}),at(function(e){e.innerHTML=\"<input type='hidden' i=''/>\",e.querySelectorAll(\"[i^='']\").length&&h.push(\"[*^$]=\"+_+\"*(?:\\\"\\\"|'')\"),e.querySelectorAll(\":enabled\").length||h.push(\":enabled\",\":disabled\"),e.querySelectorAll(\"*,:x\"),h.push(\",.*:\")})),(T.matchesSelector=rt(m=f.matchesSelector||f.mozMatchesSelector||f.webkitMatchesSelector||f.oMatchesSelector||f.msMatchesSelector))&&at(function(e){T.disconnectedMatch=m.call(e,\"div\"),m.call(e,\"[s!='']:x\"),g.push(\"!=\",R)}),h=RegExp(h.join(\"|\")),g=RegExp(g.join(\"|\")),y=rt(f.contains)||f.compareDocumentPosition?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},v=f.compareDocumentPosition?function(e,t){var r;return e===t?(u=!0,0):(r=t.compareDocumentPosition&&e.compareDocumentPosition&&e.compareDocumentPosition(t))?1&r||e.parentNode&&11===e.parentNode.nodeType?e===n||y(w,e)?-1:t===n||y(w,t)?1:0:4&r?-1:1:e.compareDocumentPosition?-1:1}:function(e,t){var r,i=0,o=e.parentNode,a=t.parentNode,s=[e],l=[t];if(e===t)return u=!0,0;if(!o||!a)return e===n?-1:t===n?1:o?-1:a?1:0;if(o===a)return ut(e,t);r=e;while(r=r.parentNode)s.unshift(r);r=t;while(r=r.parentNode)l.unshift(r);while(s[i]===l[i])i++;return i?ut(s[i],l[i]):s[i]===w?-1:l[i]===w?1:0},u=!1,[0,0].sort(v),T.detectDuplicates=u,p):p},st.matches=function(e,t){return st(e,null,null,t)},st.matchesSelector=function(e,t){if((e.ownerDocument||e)!==p&&c(e),t=t.replace(Z,\"='$1']\"),!(!T.matchesSelector||d||g&&g.test(t)||h.test(t)))try{var n=m.call(e,t);if(n||T.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(r){}return st(t,p,null,[e]).length>0},st.contains=function(e,t){return(e.ownerDocument||e)!==p&&c(e),y(e,t)},st.attr=function(e,t){var n;return(e.ownerDocument||e)!==p&&c(e),d||(t=t.toLowerCase()),(n=i.attrHandle[t])?n(e):d||T.attributes?e.getAttribute(t):((n=e.getAttributeNode(t))||e.getAttribute(t))&&e[t]===!0?t:n&&n.specified?n.value:null},st.error=function(e){throw Error(\"Syntax error, unrecognized expression: \"+e)},st.uniqueSort=function(e){var t,n=[],r=1,i=0;if(u=!T.detectDuplicates,e.sort(v),u){for(;t=e[r];r++)t===e[r-1]&&(i=n.push(r));while(i--)e.splice(n[i],1)}return e};function ut(e,t){var n=t&&e,r=n&&(~t.sourceIndex||j)-(~e.sourceIndex||j);if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function lt(e){return function(t){var n=t.nodeName.toLowerCase();return\"input\"===n&&t.type===e}}function ct(e){return function(t){var n=t.nodeName.toLowerCase();return(\"input\"===n||\"button\"===n)&&t.type===e}}function pt(e){return ot(function(t){return t=+t,ot(function(n,r){var i,o=e([],n.length,t),a=o.length;while(a--)n[i=o[a]]&&(n[i]=!(r[i]=n[i]))})})}o=st.getText=function(e){var t,n=\"\",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if(\"string\"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else for(;t=e[r];r++)n+=o(t);return n},i=st.selectors={cacheLength:50,createPseudo:ot,match:U,find:{},relative:{\">\":{dir:\"parentNode\",first:!0},\" \":{dir:\"parentNode\"},\"+\":{dir:\"previousSibling\",first:!0},\"~\":{dir:\"previousSibling\"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(et,tt),e[3]=(e[4]||e[5]||\"\").replace(et,tt),\"~=\"===e[2]&&(e[3]=\" \"+e[3]+\" \"),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),\"nth\"===e[1].slice(0,3)?(e[3]||st.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*(\"even\"===e[3]||\"odd\"===e[3])),e[5]=+(e[7]+e[8]||\"odd\"===e[3])):e[3]&&st.error(e[0]),e},PSEUDO:function(e){var t,n=!e[5]&&e[2];return U.CHILD.test(e[0])?null:(e[4]?e[2]=e[4]:n&&z.test(n)&&(t=ft(n,!0))&&(t=n.indexOf(\")\",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){return\"*\"===e?function(){return!0}:(e=e.replace(et,tt).toLowerCase(),function(t){return t.nodeName&&t.nodeName.toLowerCase()===e})},CLASS:function(e){var t=k[e+\" \"];return t||(t=RegExp(\"(^|\"+_+\")\"+e+\"(\"+_+\"|$)\"))&&k(e,function(e){return t.test(e.className||typeof e.getAttribute!==A&&e.getAttribute(\"class\")||\"\")})},ATTR:function(e,t,n){return function(r){var i=st.attr(r,e);return null==i?\"!=\"===t:t?(i+=\"\",\"=\"===t?i===n:\"!=\"===t?i!==n:\"^=\"===t?n&&0===i.indexOf(n):\"*=\"===t?n&&i.indexOf(n)>-1:\"$=\"===t?n&&i.slice(-n.length)===n:\"~=\"===t?(\" \"+i+\" \").indexOf(n)>-1:\"|=\"===t?i===n||i.slice(0,n.length+1)===n+\"-\":!1):!0}},CHILD:function(e,t,n,r,i){var o=\"nth\"!==e.slice(0,3),a=\"last\"!==e.slice(-4),s=\"of-type\"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,u){var l,c,p,f,d,h,g=o!==a?\"nextSibling\":\"previousSibling\",m=t.parentNode,y=s&&t.nodeName.toLowerCase(),v=!u&&!s;if(m){if(o){while(g){p=t;while(p=p[g])if(s?p.nodeName.toLowerCase()===y:1===p.nodeType)return!1;h=g=\"only\"===e&&!h&&\"nextSibling\"}return!0}if(h=[a?m.firstChild:m.lastChild],a&&v){c=m[x]||(m[x]={}),l=c[e]||[],d=l[0]===N&&l[1],f=l[0]===N&&l[2],p=d&&m.childNodes[d];while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if(1===p.nodeType&&++f&&p===t){c[e]=[N,d,f];break}}else if(v&&(l=(t[x]||(t[x]={}))[e])&&l[0]===N)f=l[1];else while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if((s?p.nodeName.toLowerCase()===y:1===p.nodeType)&&++f&&(v&&((p[x]||(p[x]={}))[e]=[N,f]),p===t))break;return f-=i,f===r||0===f%r&&f/r>=0}}},PSEUDO:function(e,t){var n,r=i.pseudos[e]||i.setFilters[e.toLowerCase()]||st.error(\"unsupported pseudo: \"+e);return r[x]?r(t):r.length>1?(n=[e,e,\"\",t],i.setFilters.hasOwnProperty(e.toLowerCase())?ot(function(e,n){var i,o=r(e,t),a=o.length;while(a--)i=M.call(e,o[a]),e[i]=!(n[i]=o[a])}):function(e){return r(e,0,n)}):r}},pseudos:{not:ot(function(e){var t=[],n=[],r=s(e.replace(W,\"$1\"));return r[x]?ot(function(e,t,n,i){var o,a=r(e,null,i,[]),s=e.length;while(s--)(o=a[s])&&(e[s]=!(t[s]=o))}):function(e,i,o){return t[0]=e,r(t,null,o,n),!n.pop()}}),has:ot(function(e){return function(t){return st(e,t).length>0}}),contains:ot(function(e){return function(t){return(t.textContent||t.innerText||o(t)).indexOf(e)>-1}}),lang:ot(function(e){return X.test(e||\"\")||st.error(\"unsupported lang: \"+e),e=e.replace(et,tt).toLowerCase(),function(t){var n;do if(n=d?t.getAttribute(\"xml:lang\")||t.getAttribute(\"lang\"):t.lang)return n=n.toLowerCase(),n===e||0===n.indexOf(e+\"-\");while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===f},focus:function(e){return e===p.activeElement&&(!p.hasFocus||p.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:function(e){return e.disabled===!1},disabled:function(e){return e.disabled===!0},checked:function(e){var t=e.nodeName.toLowerCase();return\"input\"===t&&!!e.checked||\"option\"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,e.selected===!0},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeName>\"@\"||3===e.nodeType||4===e.nodeType)return!1;return!0},parent:function(e){return!i.pseudos.empty(e)},header:function(e){return Q.test(e.nodeName)},input:function(e){return G.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return\"input\"===t&&\"button\"===e.type||\"button\"===t},text:function(e){var t;return\"input\"===e.nodeName.toLowerCase()&&\"text\"===e.type&&(null==(t=e.getAttribute(\"type\"))||t.toLowerCase()===e.type)},first:pt(function(){return[0]}),last:pt(function(e,t){return[t-1]}),eq:pt(function(e,t,n){return[0>n?n+t:n]}),even:pt(function(e,t){var n=0;for(;t>n;n+=2)e.push(n);return e}),odd:pt(function(e,t){var n=1;for(;t>n;n+=2)e.push(n);return e}),lt:pt(function(e,t,n){var r=0>n?n+t:n;for(;--r>=0;)e.push(r);return e}),gt:pt(function(e,t,n){var r=0>n?n+t:n;for(;t>++r;)e.push(r);return e})}};for(n in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})i.pseudos[n]=lt(n);for(n in{submit:!0,reset:!0})i.pseudos[n]=ct(n);function ft(e,t){var n,r,o,a,s,u,l,c=E[e+\" \"];if(c)return t?0:c.slice(0);s=e,u=[],l=i.preFilter;while(s){(!n||(r=$.exec(s)))&&(r&&(s=s.slice(r[0].length)||s),u.push(o=[])),n=!1,(r=I.exec(s))&&(n=r.shift(),o.push({value:n,type:r[0].replace(W,\" \")}),s=s.slice(n.length));for(a in i.filter)!(r=U[a].exec(s))||l[a]&&!(r=l[a](r))||(n=r.shift(),o.push({value:n,type:a,matches:r}),s=s.slice(n.length));if(!n)break}return t?s.length:s?st.error(e):E(e,u).slice(0)}function dt(e){var t=0,n=e.length,r=\"\";for(;n>t;t++)r+=e[t].value;return r}function ht(e,t,n){var i=t.dir,o=n&&\"parentNode\"===i,a=C++;return t.first?function(t,n,r){while(t=t[i])if(1===t.nodeType||o)return e(t,n,r)}:function(t,n,s){var u,l,c,p=N+\" \"+a;if(s){while(t=t[i])if((1===t.nodeType||o)&&e(t,n,s))return!0}else while(t=t[i])if(1===t.nodeType||o)if(c=t[x]||(t[x]={}),(l=c[i])&&l[0]===p){if((u=l[1])===!0||u===r)return u===!0}else if(l=c[i]=[p],l[1]=e(t,n,s)||r,l[1]===!0)return!0}}function gt(e){return e.length>1?function(t,n,r){var i=e.length;while(i--)if(!e[i](t,n,r))return!1;return!0}:e[0]}function mt(e,t,n,r,i){var o,a=[],s=0,u=e.length,l=null!=t;for(;u>s;s++)(o=e[s])&&(!n||n(o,r,i))&&(a.push(o),l&&t.push(s));return a}function yt(e,t,n,r,i,o){return r&&!r[x]&&(r=yt(r)),i&&!i[x]&&(i=yt(i,o)),ot(function(o,a,s,u){var l,c,p,f=[],d=[],h=a.length,g=o||xt(t||\"*\",s.nodeType?[s]:s,[]),m=!e||!o&&t?g:mt(g,f,e,s,u),y=n?i||(o?e:h||r)?[]:a:m;if(n&&n(m,y,s,u),r){l=mt(y,d),r(l,[],s,u),c=l.length;while(c--)(p=l[c])&&(y[d[c]]=!(m[d[c]]=p))}if(o){if(i||e){if(i){l=[],c=y.length;while(c--)(p=y[c])&&l.push(m[c]=p);i(null,y=[],l,u)}c=y.length;while(c--)(p=y[c])&&(l=i?M.call(o,p):f[c])>-1&&(o[l]=!(a[l]=p))}}else y=mt(y===a?y.splice(h,y.length):y),i?i(null,a,y,u):H.apply(a,y)})}function vt(e){var t,n,r,o=e.length,a=i.relative[e[0].type],s=a||i.relative[\" \"],u=a?1:0,c=ht(function(e){return e===t},s,!0),p=ht(function(e){return M.call(t,e)>-1},s,!0),f=[function(e,n,r){return!a&&(r||n!==l)||((t=n).nodeType?c(e,n,r):p(e,n,r))}];for(;o>u;u++)if(n=i.relative[e[u].type])f=[ht(gt(f),n)];else{if(n=i.filter[e[u].type].apply(null,e[u].matches),n[x]){for(r=++u;o>r;r++)if(i.relative[e[r].type])break;return yt(u>1&&gt(f),u>1&&dt(e.slice(0,u-1)).replace(W,\"$1\"),n,r>u&&vt(e.slice(u,r)),o>r&&vt(e=e.slice(r)),o>r&&dt(e))}f.push(n)}return gt(f)}function bt(e,t){var n=0,o=t.length>0,a=e.length>0,s=function(s,u,c,f,d){var h,g,m,y=[],v=0,b=\"0\",x=s&&[],w=null!=d,T=l,C=s||a&&i.find.TAG(\"*\",d&&u.parentNode||u),k=N+=null==T?1:Math.random()||.1;for(w&&(l=u!==p&&u,r=n);null!=(h=C[b]);b++){if(a&&h){g=0;while(m=e[g++])if(m(h,u,c)){f.push(h);break}w&&(N=k,r=++n)}o&&((h=!m&&h)&&v--,s&&x.push(h))}if(v+=b,o&&b!==v){g=0;while(m=t[g++])m(x,y,u,c);if(s){if(v>0)while(b--)x[b]||y[b]||(y[b]=L.call(f));y=mt(y)}H.apply(f,y),w&&!s&&y.length>0&&v+t.length>1&&st.uniqueSort(f)}return w&&(N=k,l=T),x};return o?ot(s):s}s=st.compile=function(e,t){var n,r=[],i=[],o=S[e+\" \"];if(!o){t||(t=ft(e)),n=t.length;while(n--)o=vt(t[n]),o[x]?r.push(o):i.push(o);o=S(e,bt(i,r))}return o};function xt(e,t,n){var r=0,i=t.length;for(;i>r;r++)st(e,t[r],n);return n}function wt(e,t,n,r){var o,a,u,l,c,p=ft(e);if(!r&&1===p.length){if(a=p[0]=p[0].slice(0),a.length>2&&\"ID\"===(u=a[0]).type&&9===t.nodeType&&!d&&i.relative[a[1].type]){if(t=i.find.ID(u.matches[0].replace(et,tt),t)[0],!t)return n;e=e.slice(a.shift().value.length)}o=U.needsContext.test(e)?0:a.length;while(o--){if(u=a[o],i.relative[l=u.type])break;if((c=i.find[l])&&(r=c(u.matches[0].replace(et,tt),V.test(a[0].type)&&t.parentNode||t))){if(a.splice(o,1),e=r.length&&dt(a),!e)return H.apply(n,q.call(r,0)),n;break}}}return s(e,p)(r,t,d,n,V.test(e)),n}i.pseudos.nth=i.pseudos.eq;function Tt(){}i.filters=Tt.prototype=i.pseudos,i.setFilters=new Tt,c(),st.attr=b.attr,b.find=st,b.expr=st.selectors,b.expr[\":\"]=b.expr.pseudos,b.unique=st.uniqueSort,b.text=st.getText,b.isXMLDoc=st.isXML,b.contains=st.contains}(e);var at=/Until$/,st=/^(?:parents|prev(?:Until|All))/,ut=/^.[^:#\\[\\.,]*$/,lt=b.expr.match.needsContext,ct={children:!0,contents:!0,next:!0,prev:!0};b.fn.extend({find:function(e){var t,n,r,i=this.length;if(\"string\"!=typeof e)return r=this,this.pushStack(b(e).filter(function(){for(t=0;i>t;t++)if(b.contains(r[t],this))return!0}));for(n=[],t=0;i>t;t++)b.find(e,this[t],n);return n=this.pushStack(i>1?b.unique(n):n),n.selector=(this.selector?this.selector+\" \":\"\")+e,n},has:function(e){var t,n=b(e,this),r=n.length;return this.filter(function(){for(t=0;r>t;t++)if(b.contains(this,n[t]))return!0})},not:function(e){return this.pushStack(ft(this,e,!1))},filter:function(e){return this.pushStack(ft(this,e,!0))},is:function(e){return!!e&&(\"string\"==typeof e?lt.test(e)?b(e,this.context).index(this[0])>=0:b.filter(e,this).length>0:this.filter(e).length>0)},closest:function(e,t){var n,r=0,i=this.length,o=[],a=lt.test(e)||\"string\"!=typeof e?b(e,t||this.context):0;for(;i>r;r++){n=this[r];while(n&&n.ownerDocument&&n!==t&&11!==n.nodeType){if(a?a.index(n)>-1:b.find.matchesSelector(n,e)){o.push(n);break}n=n.parentNode}}return this.pushStack(o.length>1?b.unique(o):o)},index:function(e){return e?\"string\"==typeof e?b.inArray(this[0],b(e)):b.inArray(e.jquery?e[0]:e,this):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){var n=\"string\"==typeof e?b(e,t):b.makeArray(e&&e.nodeType?[e]:e),r=b.merge(this.get(),n);return this.pushStack(b.unique(r))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),b.fn.andSelf=b.fn.addBack;function pt(e,t){do e=e[t];while(e&&1!==e.nodeType);return e}b.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return b.dir(e,\"parentNode\")},parentsUntil:function(e,t,n){return b.dir(e,\"parentNode\",n)},next:function(e){return pt(e,\"nextSibling\")},prev:function(e){return pt(e,\"previousSibling\")},nextAll:function(e){return b.dir(e,\"nextSibling\")},prevAll:function(e){return b.dir(e,\"previousSibling\")},nextUntil:function(e,t,n){return b.dir(e,\"nextSibling\",n)},prevUntil:function(e,t,n){return b.dir(e,\"previousSibling\",n)},siblings:function(e){return b.sibling((e.parentNode||{}).firstChild,e)},children:function(e){return b.sibling(e.firstChild)},contents:function(e){return b.nodeName(e,\"iframe\")?e.contentDocument||e.contentWindow.document:b.merge([],e.childNodes)}},function(e,t){b.fn[e]=function(n,r){var i=b.map(this,t,n);return at.test(e)||(r=n),r&&\"string\"==typeof r&&(i=b.filter(r,i)),i=this.length>1&&!ct[e]?b.unique(i):i,this.length>1&&st.test(e)&&(i=i.reverse()),this.pushStack(i)}}),b.extend({filter:function(e,t,n){return n&&(e=\":not(\"+e+\")\"),1===t.length?b.find.matchesSelector(t[0],e)?[t[0]]:[]:b.find.matches(e,t)},dir:function(e,n,r){var i=[],o=e[n];while(o&&9!==o.nodeType&&(r===t||1!==o.nodeType||!b(o).is(r)))1===o.nodeType&&i.push(o),o=o[n];return i},sibling:function(e,t){var n=[];for(;e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n}});function ft(e,t,n){if(t=t||0,b.isFunction(t))return b.grep(e,function(e,r){var i=!!t.call(e,r,e);return i===n});if(t.nodeType)return b.grep(e,function(e){return e===t===n});if(\"string\"==typeof t){var r=b.grep(e,function(e){return 1===e.nodeType});if(ut.test(t))return b.filter(t,r,!n);t=b.filter(t,r)}return b.grep(e,function(e){return b.inArray(e,t)>=0===n})}function dt(e){var t=ht.split(\"|\"),n=e.createDocumentFragment();if(n.createElement)while(t.length)n.createElement(t.pop());return n}var ht=\"abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video\",gt=/ jQuery\\d+=\"(?:null|\\d+)\"/g,mt=RegExp(\"<(?:\"+ht+\")[\\\\s/>]\",\"i\"),yt=/^\\s+/,vt=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:]+)[^>]*)\\/>/gi,bt=/<([\\w:]+)/,xt=/<tbody/i,wt=/<|&#?\\w+;/,Tt=/<(?:script|style|link)/i,Nt=/^(?:checkbox|radio)$/i,Ct=/checked\\s*(?:[^=]|=\\s*.checked.)/i,kt=/^$|\\/(?:java|ecma)script/i,Et=/^true\\/(.*)/,St=/^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g,At={option:[1,\"<select multiple='multiple'>\",\"</select>\"],legend:[1,\"<fieldset>\",\"</fieldset>\"],area:[1,\"<map>\",\"</map>\"],param:[1,\"<object>\",\"</object>\"],thead:[1,\"<table>\",\"</table>\"],tr:[2,\"<table><tbody>\",\"</tbody></table>\"],col:[2,\"<table><tbody></tbody><colgroup>\",\"</colgroup></table>\"],td:[3,\"<table><tbody><tr>\",\"</tr></tbody></table>\"],_default:b.support.htmlSerialize?[0,\"\",\"\"]:[1,\"X<div>\",\"</div>\"]},jt=dt(o),Dt=jt.appendChild(o.createElement(\"div\"));At.optgroup=At.option,At.tbody=At.tfoot=At.colgroup=At.caption=At.thead,At.th=At.td,b.fn.extend({text:function(e){return b.access(this,function(e){return e===t?b.text(this):this.empty().append((this[0]&&this[0].ownerDocument||o).createTextNode(e))},null,e,arguments.length)},wrapAll:function(e){if(b.isFunction(e))return this.each(function(t){b(this).wrapAll(e.call(this,t))});if(this[0]){var t=b(e,this[0].ownerDocument).eq(0).clone(!0);this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstChild&&1===e.firstChild.nodeType)e=e.firstChild;return e}).append(this)}return this},wrapInner:function(e){return b.isFunction(e)?this.each(function(t){b(this).wrapInner(e.call(this,t))}):this.each(function(){var t=b(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=b.isFunction(e);return this.each(function(n){b(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(){return this.parent().each(function(){b.nodeName(this,\"body\")||b(this).replaceWith(this.childNodes)}).end()},append:function(){return this.domManip(arguments,!0,function(e){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&this.appendChild(e)})},prepend:function(){return this.domManip(arguments,!0,function(e){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&this.insertBefore(e,this.firstChild)})},before:function(){return this.domManip(arguments,!1,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return this.domManip(arguments,!1,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},remove:function(e,t){var n,r=0;for(;null!=(n=this[r]);r++)(!e||b.filter(e,[n]).length>0)&&(t||1!==n.nodeType||b.cleanData(Ot(n)),n.parentNode&&(t&&b.contains(n.ownerDocument,n)&&Mt(Ot(n,\"script\")),n.parentNode.removeChild(n)));return this},empty:function(){var e,t=0;for(;null!=(e=this[t]);t++){1===e.nodeType&&b.cleanData(Ot(e,!1));while(e.firstChild)e.removeChild(e.firstChild);e.options&&b.nodeName(e,\"select\")&&(e.options.length=0)}return this},clone:function(e,t){return e=null==e?!1:e,t=null==t?e:t,this.map(function(){return b.clone(this,e,t)})},html:function(e){return b.access(this,function(e){var n=this[0]||{},r=0,i=this.length;if(e===t)return 1===n.nodeType?n.innerHTML.replace(gt,\"\"):t;if(!(\"string\"!=typeof e||Tt.test(e)||!b.support.htmlSerialize&&mt.test(e)||!b.support.leadingWhitespace&&yt.test(e)||At[(bt.exec(e)||[\"\",\"\"])[1].toLowerCase()])){e=e.replace(vt,\"<$1></$2>\");try{for(;i>r;r++)n=this[r]||{},1===n.nodeType&&(b.cleanData(Ot(n,!1)),n.innerHTML=e);n=0}catch(o){}}n&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(e){var t=b.isFunction(e);return t||\"string\"==typeof e||(e=b(e).not(this).detach()),this.domManip([e],!0,function(e){var t=this.nextSibling,n=this.parentNode;n&&(b(this).remove(),n.insertBefore(e,t))})},detach:function(e){return this.remove(e,!0)},domManip:function(e,n,r){e=f.apply([],e);var i,o,a,s,u,l,c=0,p=this.length,d=this,h=p-1,g=e[0],m=b.isFunction(g);if(m||!(1>=p||\"string\"!=typeof g||b.support.checkClone)&&Ct.test(g))return this.each(function(i){var o=d.eq(i);m&&(e[0]=g.call(this,i,n?o.html():t)),o.domManip(e,n,r)});if(p&&(l=b.buildFragment(e,this[0].ownerDocument,!1,this),i=l.firstChild,1===l.childNodes.length&&(l=i),i)){for(n=n&&b.nodeName(i,\"tr\"),s=b.map(Ot(l,\"script\"),Ht),a=s.length;p>c;c++)o=l,c!==h&&(o=b.clone(o,!0,!0),a&&b.merge(s,Ot(o,\"script\"))),r.call(n&&b.nodeName(this[c],\"table\")?Lt(this[c],\"tbody\"):this[c],o,c);if(a)for(u=s[s.length-1].ownerDocument,b.map(s,qt),c=0;a>c;c++)o=s[c],kt.test(o.type||\"\")&&!b._data(o,\"globalEval\")&&b.contains(u,o)&&(o.src?b.ajax({url:o.src,type:\"GET\",dataType:\"script\",async:!1,global:!1,\"throws\":!0}):b.globalEval((o.text||o.textContent||o.innerHTML||\"\").replace(St,\"\")));l=i=null}return this}});function Lt(e,t){return e.getElementsByTagName(t)[0]||e.appendChild(e.ownerDocument.createElement(t))}function Ht(e){var t=e.getAttributeNode(\"type\");return e.type=(t&&t.specified)+\"/\"+e.type,e}function qt(e){var t=Et.exec(e.type);return t?e.type=t[1]:e.removeAttribute(\"type\"),e}function Mt(e,t){var n,r=0;for(;null!=(n=e[r]);r++)b._data(n,\"globalEval\",!t||b._data(t[r],\"globalEval\"))}function _t(e,t){if(1===t.nodeType&&b.hasData(e)){var n,r,i,o=b._data(e),a=b._data(t,o),s=o.events;if(s){delete a.handle,a.events={};for(n in s)for(r=0,i=s[n].length;i>r;r++)b.event.add(t,n,s[n][r])}a.data&&(a.data=b.extend({},a.data))}}function Ft(e,t){var n,r,i;if(1===t.nodeType){if(n=t.nodeName.toLowerCase(),!b.support.noCloneEvent&&t[b.expando]){i=b._data(t);for(r in i.events)b.removeEvent(t,r,i.handle);t.removeAttribute(b.expando)}\"script\"===n&&t.text!==e.text?(Ht(t).text=e.text,qt(t)):\"object\"===n?(t.parentNode&&(t.outerHTML=e.outerHTML),b.support.html5Clone&&e.innerHTML&&!b.trim(t.innerHTML)&&(t.innerHTML=e.innerHTML)):\"input\"===n&&Nt.test(e.type)?(t.defaultChecked=t.checked=e.checked,t.value!==e.value&&(t.value=e.value)):\"option\"===n?t.defaultSelected=t.selected=e.defaultSelected:(\"input\"===n||\"textarea\"===n)&&(t.defaultValue=e.defaultValue)}}b.each({appendTo:\"append\",prependTo:\"prepend\",insertBefore:\"before\",insertAfter:\"after\",replaceAll:\"replaceWith\"},function(e,t){b.fn[e]=function(e){var n,r=0,i=[],o=b(e),a=o.length-1;for(;a>=r;r++)n=r===a?this:this.clone(!0),b(o[r])[t](n),d.apply(i,n.get());return this.pushStack(i)}});function Ot(e,n){var r,o,a=0,s=typeof e.getElementsByTagName!==i?e.getElementsByTagName(n||\"*\"):typeof e.querySelectorAll!==i?e.querySelectorAll(n||\"*\"):t;if(!s)for(s=[],r=e.childNodes||e;null!=(o=r[a]);a++)!n||b.nodeName(o,n)?s.push(o):b.merge(s,Ot(o,n));return n===t||n&&b.nodeName(e,n)?b.merge([e],s):s}function Bt(e){Nt.test(e.type)&&(e.defaultChecked=e.checked)}b.extend({clone:function(e,t,n){var r,i,o,a,s,u=b.contains(e.ownerDocument,e);if(b.support.html5Clone||b.isXMLDoc(e)||!mt.test(\"<\"+e.nodeName+\">\")?o=e.cloneNode(!0):(Dt.innerHTML=e.outerHTML,Dt.removeChild(o=Dt.firstChild)),!(b.support.noCloneEvent&&b.support.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||b.isXMLDoc(e)))for(r=Ot(o),s=Ot(e),a=0;null!=(i=s[a]);++a)r[a]&&Ft(i,r[a]);if(t)if(n)for(s=s||Ot(e),r=r||Ot(o),a=0;null!=(i=s[a]);a++)_t(i,r[a]);else _t(e,o);return r=Ot(o,\"script\"),r.length>0&&Mt(r,!u&&Ot(e,\"script\")),r=s=i=null,o},buildFragment:function(e,t,n,r){var i,o,a,s,u,l,c,p=e.length,f=dt(t),d=[],h=0;for(;p>h;h++)if(o=e[h],o||0===o)if(\"object\"===b.type(o))b.merge(d,o.nodeType?[o]:o);else if(wt.test(o)){s=s||f.appendChild(t.createElement(\"div\")),u=(bt.exec(o)||[\"\",\"\"])[1].toLowerCase(),c=At[u]||At._default,s.innerHTML=c[1]+o.replace(vt,\"<$1></$2>\")+c[2],i=c[0];while(i--)s=s.lastChild;if(!b.support.leadingWhitespace&&yt.test(o)&&d.push(t.createTextNode(yt.exec(o)[0])),!b.support.tbody){o=\"table\"!==u||xt.test(o)?\"<table>\"!==c[1]||xt.test(o)?0:s:s.firstChild,i=o&&o.childNodes.length;while(i--)b.nodeName(l=o.childNodes[i],\"tbody\")&&!l.childNodes.length&&o.removeChild(l)\n}b.merge(d,s.childNodes),s.textContent=\"\";while(s.firstChild)s.removeChild(s.firstChild);s=f.lastChild}else d.push(t.createTextNode(o));s&&f.removeChild(s),b.support.appendChecked||b.grep(Ot(d,\"input\"),Bt),h=0;while(o=d[h++])if((!r||-1===b.inArray(o,r))&&(a=b.contains(o.ownerDocument,o),s=Ot(f.appendChild(o),\"script\"),a&&Mt(s),n)){i=0;while(o=s[i++])kt.test(o.type||\"\")&&n.push(o)}return s=null,f},cleanData:function(e,t){var n,r,o,a,s=0,u=b.expando,l=b.cache,p=b.support.deleteExpando,f=b.event.special;for(;null!=(n=e[s]);s++)if((t||b.acceptData(n))&&(o=n[u],a=o&&l[o])){if(a.events)for(r in a.events)f[r]?b.event.remove(n,r):b.removeEvent(n,r,a.handle);l[o]&&(delete l[o],p?delete n[u]:typeof n.removeAttribute!==i?n.removeAttribute(u):n[u]=null,c.push(o))}}});var Pt,Rt,Wt,$t=/alpha\\([^)]*\\)/i,It=/opacity\\s*=\\s*([^)]*)/,zt=/^(top|right|bottom|left)$/,Xt=/^(none|table(?!-c[ea]).+)/,Ut=/^margin/,Vt=RegExp(\"^(\"+x+\")(.*)$\",\"i\"),Yt=RegExp(\"^(\"+x+\")(?!px)[a-z%]+$\",\"i\"),Jt=RegExp(\"^([+-])=(\"+x+\")\",\"i\"),Gt={BODY:\"block\"},Qt={position:\"absolute\",visibility:\"hidden\",display:\"block\"},Kt={letterSpacing:0,fontWeight:400},Zt=[\"Top\",\"Right\",\"Bottom\",\"Left\"],en=[\"Webkit\",\"O\",\"Moz\",\"ms\"];function tn(e,t){if(t in e)return t;var n=t.charAt(0).toUpperCase()+t.slice(1),r=t,i=en.length;while(i--)if(t=en[i]+n,t in e)return t;return r}function nn(e,t){return e=t||e,\"none\"===b.css(e,\"display\")||!b.contains(e.ownerDocument,e)}function rn(e,t){var n,r,i,o=[],a=0,s=e.length;for(;s>a;a++)r=e[a],r.style&&(o[a]=b._data(r,\"olddisplay\"),n=r.style.display,t?(o[a]||\"none\"!==n||(r.style.display=\"\"),\"\"===r.style.display&&nn(r)&&(o[a]=b._data(r,\"olddisplay\",un(r.nodeName)))):o[a]||(i=nn(r),(n&&\"none\"!==n||!i)&&b._data(r,\"olddisplay\",i?n:b.css(r,\"display\"))));for(a=0;s>a;a++)r=e[a],r.style&&(t&&\"none\"!==r.style.display&&\"\"!==r.style.display||(r.style.display=t?o[a]||\"\":\"none\"));return e}b.fn.extend({css:function(e,n){return b.access(this,function(e,n,r){var i,o,a={},s=0;if(b.isArray(n)){for(o=Rt(e),i=n.length;i>s;s++)a[n[s]]=b.css(e,n[s],!1,o);return a}return r!==t?b.style(e,n,r):b.css(e,n)},e,n,arguments.length>1)},show:function(){return rn(this,!0)},hide:function(){return rn(this)},toggle:function(e){var t=\"boolean\"==typeof e;return this.each(function(){(t?e:nn(this))?b(this).show():b(this).hide()})}}),b.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Wt(e,\"opacity\");return\"\"===n?\"1\":n}}}},cssNumber:{columnCount:!0,fillOpacity:!0,fontWeight:!0,lineHeight:!0,opacity:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{\"float\":b.support.cssFloat?\"cssFloat\":\"styleFloat\"},style:function(e,n,r,i){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var o,a,s,u=b.camelCase(n),l=e.style;if(n=b.cssProps[u]||(b.cssProps[u]=tn(l,u)),s=b.cssHooks[n]||b.cssHooks[u],r===t)return s&&\"get\"in s&&(o=s.get(e,!1,i))!==t?o:l[n];if(a=typeof r,\"string\"===a&&(o=Jt.exec(r))&&(r=(o[1]+1)*o[2]+parseFloat(b.css(e,n)),a=\"number\"),!(null==r||\"number\"===a&&isNaN(r)||(\"number\"!==a||b.cssNumber[u]||(r+=\"px\"),b.support.clearCloneStyle||\"\"!==r||0!==n.indexOf(\"background\")||(l[n]=\"inherit\"),s&&\"set\"in s&&(r=s.set(e,r,i))===t)))try{l[n]=r}catch(c){}}},css:function(e,n,r,i){var o,a,s,u=b.camelCase(n);return n=b.cssProps[u]||(b.cssProps[u]=tn(e.style,u)),s=b.cssHooks[n]||b.cssHooks[u],s&&\"get\"in s&&(a=s.get(e,!0,r)),a===t&&(a=Wt(e,n,i)),\"normal\"===a&&n in Kt&&(a=Kt[n]),\"\"===r||r?(o=parseFloat(a),r===!0||b.isNumeric(o)?o||0:a):a},swap:function(e,t,n,r){var i,o,a={};for(o in t)a[o]=e.style[o],e.style[o]=t[o];i=n.apply(e,r||[]);for(o in t)e.style[o]=a[o];return i}}),e.getComputedStyle?(Rt=function(t){return e.getComputedStyle(t,null)},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),u=s?s.getPropertyValue(n)||s[n]:t,l=e.style;return s&&(\"\"!==u||b.contains(e.ownerDocument,e)||(u=b.style(e,n)),Yt.test(u)&&Ut.test(n)&&(i=l.width,o=l.minWidth,a=l.maxWidth,l.minWidth=l.maxWidth=l.width=u,u=s.width,l.width=i,l.minWidth=o,l.maxWidth=a)),u}):o.documentElement.currentStyle&&(Rt=function(e){return e.currentStyle},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),u=s?s[n]:t,l=e.style;return null==u&&l&&l[n]&&(u=l[n]),Yt.test(u)&&!zt.test(n)&&(i=l.left,o=e.runtimeStyle,a=o&&o.left,a&&(o.left=e.currentStyle.left),l.left=\"fontSize\"===n?\"1em\":u,u=l.pixelLeft+\"px\",l.left=i,a&&(o.left=a)),\"\"===u?\"auto\":u});function on(e,t,n){var r=Vt.exec(t);return r?Math.max(0,r[1]-(n||0))+(r[2]||\"px\"):t}function an(e,t,n,r,i){var o=n===(r?\"border\":\"content\")?4:\"width\"===t?1:0,a=0;for(;4>o;o+=2)\"margin\"===n&&(a+=b.css(e,n+Zt[o],!0,i)),r?(\"content\"===n&&(a-=b.css(e,\"padding\"+Zt[o],!0,i)),\"margin\"!==n&&(a-=b.css(e,\"border\"+Zt[o]+\"Width\",!0,i))):(a+=b.css(e,\"padding\"+Zt[o],!0,i),\"padding\"!==n&&(a+=b.css(e,\"border\"+Zt[o]+\"Width\",!0,i)));return a}function sn(e,t,n){var r=!0,i=\"width\"===t?e.offsetWidth:e.offsetHeight,o=Rt(e),a=b.support.boxSizing&&\"border-box\"===b.css(e,\"boxSizing\",!1,o);if(0>=i||null==i){if(i=Wt(e,t,o),(0>i||null==i)&&(i=e.style[t]),Yt.test(i))return i;r=a&&(b.support.boxSizingReliable||i===e.style[t]),i=parseFloat(i)||0}return i+an(e,t,n||(a?\"border\":\"content\"),r,o)+\"px\"}function un(e){var t=o,n=Gt[e];return n||(n=ln(e,t),\"none\"!==n&&n||(Pt=(Pt||b(\"<iframe frameborder='0' width='0' height='0'/>\").css(\"cssText\",\"display:block !important\")).appendTo(t.documentElement),t=(Pt[0].contentWindow||Pt[0].contentDocument).document,t.write(\"<!doctype html><html><body>\"),t.close(),n=ln(e,t),Pt.detach()),Gt[e]=n),n}function ln(e,t){var n=b(t.createElement(e)).appendTo(t.body),r=b.css(n[0],\"display\");return n.remove(),r}b.each([\"height\",\"width\"],function(e,n){b.cssHooks[n]={get:function(e,r,i){return r?0===e.offsetWidth&&Xt.test(b.css(e,\"display\"))?b.swap(e,Qt,function(){return sn(e,n,i)}):sn(e,n,i):t},set:function(e,t,r){var i=r&&Rt(e);return on(e,t,r?an(e,n,r,b.support.boxSizing&&\"border-box\"===b.css(e,\"boxSizing\",!1,i),i):0)}}}),b.support.opacity||(b.cssHooks.opacity={get:function(e,t){return It.test((t&&e.currentStyle?e.currentStyle.filter:e.style.filter)||\"\")?.01*parseFloat(RegExp.$1)+\"\":t?\"1\":\"\"},set:function(e,t){var n=e.style,r=e.currentStyle,i=b.isNumeric(t)?\"alpha(opacity=\"+100*t+\")\":\"\",o=r&&r.filter||n.filter||\"\";n.zoom=1,(t>=1||\"\"===t)&&\"\"===b.trim(o.replace($t,\"\"))&&n.removeAttribute&&(n.removeAttribute(\"filter\"),\"\"===t||r&&!r.filter)||(n.filter=$t.test(o)?o.replace($t,i):o+\" \"+i)}}),b(function(){b.support.reliableMarginRight||(b.cssHooks.marginRight={get:function(e,n){return n?b.swap(e,{display:\"inline-block\"},Wt,[e,\"marginRight\"]):t}}),!b.support.pixelPosition&&b.fn.position&&b.each([\"top\",\"left\"],function(e,n){b.cssHooks[n]={get:function(e,r){return r?(r=Wt(e,n),Yt.test(r)?b(e).position()[n]+\"px\":r):t}}})}),b.expr&&b.expr.filters&&(b.expr.filters.hidden=function(e){return 0>=e.offsetWidth&&0>=e.offsetHeight||!b.support.reliableHiddenOffsets&&\"none\"===(e.style&&e.style.display||b.css(e,\"display\"))},b.expr.filters.visible=function(e){return!b.expr.filters.hidden(e)}),b.each({margin:\"\",padding:\"\",border:\"Width\"},function(e,t){b.cssHooks[e+t]={expand:function(n){var r=0,i={},o=\"string\"==typeof n?n.split(\" \"):[n];for(;4>r;r++)i[e+Zt[r]+t]=o[r]||o[r-2]||o[0];return i}},Ut.test(e)||(b.cssHooks[e+t].set=on)});var cn=/%20/g,pn=/\\[\\]$/,fn=/\\r?\\n/g,dn=/^(?:submit|button|image|reset|file)$/i,hn=/^(?:input|select|textarea|keygen)/i;b.fn.extend({serialize:function(){return b.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=b.prop(this,\"elements\");return e?b.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!b(this).is(\":disabled\")&&hn.test(this.nodeName)&&!dn.test(e)&&(this.checked||!Nt.test(e))}).map(function(e,t){var n=b(this).val();return null==n?null:b.isArray(n)?b.map(n,function(e){return{name:t.name,value:e.replace(fn,\"\\r\\n\")}}):{name:t.name,value:n.replace(fn,\"\\r\\n\")}}).get()}}),b.param=function(e,n){var r,i=[],o=function(e,t){t=b.isFunction(t)?t():null==t?\"\":t,i[i.length]=encodeURIComponent(e)+\"=\"+encodeURIComponent(t)};if(n===t&&(n=b.ajaxSettings&&b.ajaxSettings.traditional),b.isArray(e)||e.jquery&&!b.isPlainObject(e))b.each(e,function(){o(this.name,this.value)});else for(r in e)gn(r,e[r],n,o);return i.join(\"&\").replace(cn,\"+\")};function gn(e,t,n,r){var i;if(b.isArray(t))b.each(t,function(t,i){n||pn.test(e)?r(e,i):gn(e+\"[\"+(\"object\"==typeof i?t:\"\")+\"]\",i,n,r)});else if(n||\"object\"!==b.type(t))r(e,t);else for(i in t)gn(e+\"[\"+i+\"]\",t[i],n,r)}b.each(\"blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu\".split(\" \"),function(e,t){b.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),b.fn.hover=function(e,t){return this.mouseenter(e).mouseleave(t||e)};var mn,yn,vn=b.now(),bn=/\\?/,xn=/#.*$/,wn=/([?&])_=[^&]*/,Tn=/^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/gm,Nn=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,Cn=/^(?:GET|HEAD)$/,kn=/^\\/\\//,En=/^([\\w.+-]+:)(?:\\/\\/([^\\/?#:]*)(?::(\\d+)|)|)/,Sn=b.fn.load,An={},jn={},Dn=\"*/\".concat(\"*\");try{yn=a.href}catch(Ln){yn=o.createElement(\"a\"),yn.href=\"\",yn=yn.href}mn=En.exec(yn.toLowerCase())||[];function Hn(e){return function(t,n){\"string\"!=typeof t&&(n=t,t=\"*\");var r,i=0,o=t.toLowerCase().match(w)||[];if(b.isFunction(n))while(r=o[i++])\"+\"===r[0]?(r=r.slice(1)||\"*\",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function qn(e,n,r,i){var o={},a=e===jn;function s(u){var l;return o[u]=!0,b.each(e[u]||[],function(e,u){var c=u(n,r,i);return\"string\"!=typeof c||a||o[c]?a?!(l=c):t:(n.dataTypes.unshift(c),s(c),!1)}),l}return s(n.dataTypes[0])||!o[\"*\"]&&s(\"*\")}function Mn(e,n){var r,i,o=b.ajaxSettings.flatOptions||{};for(i in n)n[i]!==t&&((o[i]?e:r||(r={}))[i]=n[i]);return r&&b.extend(!0,e,r),e}b.fn.load=function(e,n,r){if(\"string\"!=typeof e&&Sn)return Sn.apply(this,arguments);var i,o,a,s=this,u=e.indexOf(\" \");return u>=0&&(i=e.slice(u,e.length),e=e.slice(0,u)),b.isFunction(n)?(r=n,n=t):n&&\"object\"==typeof n&&(a=\"POST\"),s.length>0&&b.ajax({url:e,type:a,dataType:\"html\",data:n}).done(function(e){o=arguments,s.html(i?b(\"<div>\").append(b.parseHTML(e)).find(i):e)}).complete(r&&function(e,t){s.each(r,o||[e.responseText,t,e])}),this},b.each([\"ajaxStart\",\"ajaxStop\",\"ajaxComplete\",\"ajaxError\",\"ajaxSuccess\",\"ajaxSend\"],function(e,t){b.fn[t]=function(e){return this.on(t,e)}}),b.each([\"get\",\"post\"],function(e,n){b[n]=function(e,r,i,o){return b.isFunction(r)&&(o=o||i,i=r,r=t),b.ajax({url:e,type:n,dataType:o,data:r,success:i})}}),b.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:yn,type:\"GET\",isLocal:Nn.test(mn[1]),global:!0,processData:!0,async:!0,contentType:\"application/x-www-form-urlencoded; charset=UTF-8\",accepts:{\"*\":Dn,text:\"text/plain\",html:\"text/html\",xml:\"application/xml, text/xml\",json:\"application/json, text/javascript\"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:\"responseXML\",text:\"responseText\"},converters:{\"* text\":e.String,\"text html\":!0,\"text json\":b.parseJSON,\"text xml\":b.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Mn(Mn(e,b.ajaxSettings),t):Mn(b.ajaxSettings,e)},ajaxPrefilter:Hn(An),ajaxTransport:Hn(jn),ajax:function(e,n){\"object\"==typeof e&&(n=e,e=t),n=n||{};var r,i,o,a,s,u,l,c,p=b.ajaxSetup({},n),f=p.context||p,d=p.context&&(f.nodeType||f.jquery)?b(f):b.event,h=b.Deferred(),g=b.Callbacks(\"once memory\"),m=p.statusCode||{},y={},v={},x=0,T=\"canceled\",N={readyState:0,getResponseHeader:function(e){var t;if(2===x){if(!c){c={};while(t=Tn.exec(a))c[t[1].toLowerCase()]=t[2]}t=c[e.toLowerCase()]}return null==t?null:t},getAllResponseHeaders:function(){return 2===x?a:null},setRequestHeader:function(e,t){var n=e.toLowerCase();return x||(e=v[n]=v[n]||e,y[e]=t),this},overrideMimeType:function(e){return x||(p.mimeType=e),this},statusCode:function(e){var t;if(e)if(2>x)for(t in e)m[t]=[m[t],e[t]];else N.always(e[N.status]);return this},abort:function(e){var t=e||T;return l&&l.abort(t),k(0,t),this}};if(h.promise(N).complete=g.add,N.success=N.done,N.error=N.fail,p.url=((e||p.url||yn)+\"\").replace(xn,\"\").replace(kn,mn[1]+\"//\"),p.type=n.method||n.type||p.method||p.type,p.dataTypes=b.trim(p.dataType||\"*\").toLowerCase().match(w)||[\"\"],null==p.crossDomain&&(r=En.exec(p.url.toLowerCase()),p.crossDomain=!(!r||r[1]===mn[1]&&r[2]===mn[2]&&(r[3]||(\"http:\"===r[1]?80:443))==(mn[3]||(\"http:\"===mn[1]?80:443)))),p.data&&p.processData&&\"string\"!=typeof p.data&&(p.data=b.param(p.data,p.traditional)),qn(An,p,n,N),2===x)return N;u=p.global,u&&0===b.active++&&b.event.trigger(\"ajaxStart\"),p.type=p.type.toUpperCase(),p.hasContent=!Cn.test(p.type),o=p.url,p.hasContent||(p.data&&(o=p.url+=(bn.test(o)?\"&\":\"?\")+p.data,delete p.data),p.cache===!1&&(p.url=wn.test(o)?o.replace(wn,\"$1_=\"+vn++):o+(bn.test(o)?\"&\":\"?\")+\"_=\"+vn++)),p.ifModified&&(b.lastModified[o]&&N.setRequestHeader(\"If-Modified-Since\",b.lastModified[o]),b.etag[o]&&N.setRequestHeader(\"If-None-Match\",b.etag[o])),(p.data&&p.hasContent&&p.contentType!==!1||n.contentType)&&N.setRequestHeader(\"Content-Type\",p.contentType),N.setRequestHeader(\"Accept\",p.dataTypes[0]&&p.accepts[p.dataTypes[0]]?p.accepts[p.dataTypes[0]]+(\"*\"!==p.dataTypes[0]?\", \"+Dn+\"; q=0.01\":\"\"):p.accepts[\"*\"]);for(i in p.headers)N.setRequestHeader(i,p.headers[i]);if(p.beforeSend&&(p.beforeSend.call(f,N,p)===!1||2===x))return N.abort();T=\"abort\";for(i in{success:1,error:1,complete:1})N[i](p[i]);if(l=qn(jn,p,n,N)){N.readyState=1,u&&d.trigger(\"ajaxSend\",[N,p]),p.async&&p.timeout>0&&(s=setTimeout(function(){N.abort(\"timeout\")},p.timeout));try{x=1,l.send(y,k)}catch(C){if(!(2>x))throw C;k(-1,C)}}else k(-1,\"No Transport\");function k(e,n,r,i){var c,y,v,w,T,C=n;2!==x&&(x=2,s&&clearTimeout(s),l=t,a=i||\"\",N.readyState=e>0?4:0,r&&(w=_n(p,N,r)),e>=200&&300>e||304===e?(p.ifModified&&(T=N.getResponseHeader(\"Last-Modified\"),T&&(b.lastModified[o]=T),T=N.getResponseHeader(\"etag\"),T&&(b.etag[o]=T)),204===e?(c=!0,C=\"nocontent\"):304===e?(c=!0,C=\"notmodified\"):(c=Fn(p,w),C=c.state,y=c.data,v=c.error,c=!v)):(v=C,(e||!C)&&(C=\"error\",0>e&&(e=0))),N.status=e,N.statusText=(n||C)+\"\",c?h.resolveWith(f,[y,C,N]):h.rejectWith(f,[N,C,v]),N.statusCode(m),m=t,u&&d.trigger(c?\"ajaxSuccess\":\"ajaxError\",[N,p,c?y:v]),g.fireWith(f,[N,C]),u&&(d.trigger(\"ajaxComplete\",[N,p]),--b.active||b.event.trigger(\"ajaxStop\")))}return N},getScript:function(e,n){return b.get(e,t,n,\"script\")},getJSON:function(e,t,n){return b.get(e,t,n,\"json\")}});function _n(e,n,r){var i,o,a,s,u=e.contents,l=e.dataTypes,c=e.responseFields;for(s in c)s in r&&(n[c[s]]=r[s]);while(\"*\"===l[0])l.shift(),o===t&&(o=e.mimeType||n.getResponseHeader(\"Content-Type\"));if(o)for(s in u)if(u[s]&&u[s].test(o)){l.unshift(s);break}if(l[0]in r)a=l[0];else{for(s in r){if(!l[0]||e.converters[s+\" \"+l[0]]){a=s;break}i||(i=s)}a=a||i}return a?(a!==l[0]&&l.unshift(a),r[a]):t}function Fn(e,t){var n,r,i,o,a={},s=0,u=e.dataTypes.slice(),l=u[0];if(e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u[1])for(i in e.converters)a[i.toLowerCase()]=e.converters[i];for(;r=u[++s];)if(\"*\"!==r){if(\"*\"!==l&&l!==r){if(i=a[l+\" \"+r]||a[\"* \"+r],!i)for(n in a)if(o=n.split(\" \"),o[1]===r&&(i=a[l+\" \"+o[0]]||a[\"* \"+o[0]])){i===!0?i=a[n]:a[n]!==!0&&(r=o[0],u.splice(s--,0,r));break}if(i!==!0)if(i&&e[\"throws\"])t=i(t);else try{t=i(t)}catch(c){return{state:\"parsererror\",error:i?c:\"No conversion from \"+l+\" to \"+r}}}l=r}return{state:\"success\",data:t}}b.ajaxSetup({accepts:{script:\"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript\"},contents:{script:/(?:java|ecma)script/},converters:{\"text script\":function(e){return b.globalEval(e),e}}}),b.ajaxPrefilter(\"script\",function(e){e.cache===t&&(e.cache=!1),e.crossDomain&&(e.type=\"GET\",e.global=!1)}),b.ajaxTransport(\"script\",function(e){if(e.crossDomain){var n,r=o.head||b(\"head\")[0]||o.documentElement;return{send:function(t,i){n=o.createElement(\"script\"),n.async=!0,e.scriptCharset&&(n.charset=e.scriptCharset),n.src=e.url,n.onload=n.onreadystatechange=function(e,t){(t||!n.readyState||/loaded|complete/.test(n.readyState))&&(n.onload=n.onreadystatechange=null,n.parentNode&&n.parentNode.removeChild(n),n=null,t||i(200,\"success\"))},r.insertBefore(n,r.firstChild)},abort:function(){n&&n.onload(t,!0)}}}});var On=[],Bn=/(=)\\?(?=&|$)|\\?\\?/;b.ajaxSetup({jsonp:\"callback\",jsonpCallback:function(){var e=On.pop()||b.expando+\"_\"+vn++;return this[e]=!0,e}}),b.ajaxPrefilter(\"json jsonp\",function(n,r,i){var o,a,s,u=n.jsonp!==!1&&(Bn.test(n.url)?\"url\":\"string\"==typeof n.data&&!(n.contentType||\"\").indexOf(\"application/x-www-form-urlencoded\")&&Bn.test(n.data)&&\"data\");return u||\"jsonp\"===n.dataTypes[0]?(o=n.jsonpCallback=b.isFunction(n.jsonpCallback)?n.jsonpCallback():n.jsonpCallback,u?n[u]=n[u].replace(Bn,\"$1\"+o):n.jsonp!==!1&&(n.url+=(bn.test(n.url)?\"&\":\"?\")+n.jsonp+\"=\"+o),n.converters[\"script json\"]=function(){return s||b.error(o+\" was not called\"),s[0]},n.dataTypes[0]=\"json\",a=e[o],e[o]=function(){s=arguments},i.always(function(){e[o]=a,n[o]&&(n.jsonpCallback=r.jsonpCallback,On.push(o)),s&&b.isFunction(a)&&a(s[0]),s=a=t}),\"script\"):t});var Pn,Rn,Wn=0,$n=e.ActiveXObject&&function(){var e;for(e in Pn)Pn[e](t,!0)};function In(){try{return new e.XMLHttpRequest}catch(t){}}function zn(){try{return new e.ActiveXObject(\"Microsoft.XMLHTTP\")}catch(t){}}b.ajaxSettings.xhr=e.ActiveXObject?function(){return!this.isLocal&&In()||zn()}:In,Rn=b.ajaxSettings.xhr(),b.support.cors=!!Rn&&\"withCredentials\"in Rn,Rn=b.support.ajax=!!Rn,Rn&&b.ajaxTransport(function(n){if(!n.crossDomain||b.support.cors){var r;return{send:function(i,o){var a,s,u=n.xhr();if(n.username?u.open(n.type,n.url,n.async,n.username,n.password):u.open(n.type,n.url,n.async),n.xhrFields)for(s in n.xhrFields)u[s]=n.xhrFields[s];n.mimeType&&u.overrideMimeType&&u.overrideMimeType(n.mimeType),n.crossDomain||i[\"X-Requested-With\"]||(i[\"X-Requested-With\"]=\"XMLHttpRequest\");try{for(s in i)u.setRequestHeader(s,i[s])}catch(l){}u.send(n.hasContent&&n.data||null),r=function(e,i){var s,l,c,p;try{if(r&&(i||4===u.readyState))if(r=t,a&&(u.onreadystatechange=b.noop,$n&&delete Pn[a]),i)4!==u.readyState&&u.abort();else{p={},s=u.status,l=u.getAllResponseHeaders(),\"string\"==typeof u.responseText&&(p.text=u.responseText);try{c=u.statusText}catch(f){c=\"\"}s||!n.isLocal||n.crossDomain?1223===s&&(s=204):s=p.text?200:404}}catch(d){i||o(-1,d)}p&&o(s,c,p,l)},n.async?4===u.readyState?setTimeout(r):(a=++Wn,$n&&(Pn||(Pn={},b(e).unload($n)),Pn[a]=r),u.onreadystatechange=r):r()},abort:function(){r&&r(t,!0)}}}});var Xn,Un,Vn=/^(?:toggle|show|hide)$/,Yn=RegExp(\"^(?:([+-])=|)(\"+x+\")([a-z%]*)$\",\"i\"),Jn=/queueHooks$/,Gn=[nr],Qn={\"*\":[function(e,t){var n,r,i=this.createTween(e,t),o=Yn.exec(t),a=i.cur(),s=+a||0,u=1,l=20;if(o){if(n=+o[2],r=o[3]||(b.cssNumber[e]?\"\":\"px\"),\"px\"!==r&&s){s=b.css(i.elem,e,!0)||n||1;do u=u||\".5\",s/=u,b.style(i.elem,e,s+r);while(u!==(u=i.cur()/a)&&1!==u&&--l)}i.unit=r,i.start=s,i.end=o[1]?s+(o[1]+1)*n:n}return i}]};function Kn(){return setTimeout(function(){Xn=t}),Xn=b.now()}function Zn(e,t){b.each(t,function(t,n){var r=(Qn[t]||[]).concat(Qn[\"*\"]),i=0,o=r.length;for(;o>i;i++)if(r[i].call(e,t,n))return})}function er(e,t,n){var r,i,o=0,a=Gn.length,s=b.Deferred().always(function(){delete u.elem}),u=function(){if(i)return!1;var t=Xn||Kn(),n=Math.max(0,l.startTime+l.duration-t),r=n/l.duration||0,o=1-r,a=0,u=l.tweens.length;for(;u>a;a++)l.tweens[a].run(o);return s.notifyWith(e,[l,o,n]),1>o&&u?n:(s.resolveWith(e,[l]),!1)},l=s.promise({elem:e,props:b.extend({},t),opts:b.extend(!0,{specialEasing:{}},n),originalProperties:t,originalOptions:n,startTime:Xn||Kn(),duration:n.duration,tweens:[],createTween:function(t,n){var r=b.Tween(e,l.opts,t,n,l.opts.specialEasing[t]||l.opts.easing);return l.tweens.push(r),r},stop:function(t){var n=0,r=t?l.tweens.length:0;if(i)return this;for(i=!0;r>n;n++)l.tweens[n].run(1);return t?s.resolveWith(e,[l,t]):s.rejectWith(e,[l,t]),this}}),c=l.props;for(tr(c,l.opts.specialEasing);a>o;o++)if(r=Gn[o].call(l,e,c,l.opts))return r;return Zn(l,c),b.isFunction(l.opts.start)&&l.opts.start.call(e,l),b.fx.timer(b.extend(u,{elem:e,anim:l,queue:l.opts.queue})),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always)}function tr(e,t){var n,r,i,o,a;for(i in e)if(r=b.camelCase(i),o=t[r],n=e[i],b.isArray(n)&&(o=n[1],n=e[i]=n[0]),i!==r&&(e[r]=n,delete e[i]),a=b.cssHooks[r],a&&\"expand\"in a){n=a.expand(n),delete e[r];for(i in n)i in e||(e[i]=n[i],t[i]=o)}else t[r]=o}b.Animation=b.extend(er,{tweener:function(e,t){b.isFunction(e)?(t=e,e=[\"*\"]):e=e.split(\" \");var n,r=0,i=e.length;for(;i>r;r++)n=e[r],Qn[n]=Qn[n]||[],Qn[n].unshift(t)},prefilter:function(e,t){t?Gn.unshift(e):Gn.push(e)}});function nr(e,t,n){var r,i,o,a,s,u,l,c,p,f=this,d=e.style,h={},g=[],m=e.nodeType&&nn(e);n.queue||(c=b._queueHooks(e,\"fx\"),null==c.unqueued&&(c.unqueued=0,p=c.empty.fire,c.empty.fire=function(){c.unqueued||p()}),c.unqueued++,f.always(function(){f.always(function(){c.unqueued--,b.queue(e,\"fx\").length||c.empty.fire()})})),1===e.nodeType&&(\"height\"in t||\"width\"in t)&&(n.overflow=[d.overflow,d.overflowX,d.overflowY],\"inline\"===b.css(e,\"display\")&&\"none\"===b.css(e,\"float\")&&(b.support.inlineBlockNeedsLayout&&\"inline\"!==un(e.nodeName)?d.zoom=1:d.display=\"inline-block\")),n.overflow&&(d.overflow=\"hidden\",b.support.shrinkWrapBlocks||f.always(function(){d.overflow=n.overflow[0],d.overflowX=n.overflow[1],d.overflowY=n.overflow[2]}));for(i in t)if(a=t[i],Vn.exec(a)){if(delete t[i],u=u||\"toggle\"===a,a===(m?\"hide\":\"show\"))continue;g.push(i)}if(o=g.length){s=b._data(e,\"fxshow\")||b._data(e,\"fxshow\",{}),\"hidden\"in s&&(m=s.hidden),u&&(s.hidden=!m),m?b(e).show():f.done(function(){b(e).hide()}),f.done(function(){var t;b._removeData(e,\"fxshow\");for(t in h)b.style(e,t,h[t])});for(i=0;o>i;i++)r=g[i],l=f.createTween(r,m?s[r]:0),h[r]=s[r]||b.style(e,r),r in s||(s[r]=l.start,m&&(l.end=l.start,l.start=\"width\"===r||\"height\"===r?1:0))}}function rr(e,t,n,r,i){return new rr.prototype.init(e,t,n,r,i)}b.Tween=rr,rr.prototype={constructor:rr,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||\"swing\",this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(b.cssNumber[n]?\"\":\"px\")},cur:function(){var e=rr.propHooks[this.prop];return e&&e.get?e.get(this):rr.propHooks._default.get(this)},run:function(e){var t,n=rr.propHooks[this.prop];return this.pos=t=this.options.duration?b.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):rr.propHooks._default.set(this),this}},rr.prototype.init.prototype=rr.prototype,rr.propHooks={_default:{get:function(e){var t;return null==e.elem[e.prop]||e.elem.style&&null!=e.elem.style[e.prop]?(t=b.css(e.elem,e.prop,\"\"),t&&\"auto\"!==t?t:0):e.elem[e.prop]},set:function(e){b.fx.step[e.prop]?b.fx.step[e.prop](e):e.elem.style&&(null!=e.elem.style[b.cssProps[e.prop]]||b.cssHooks[e.prop])?b.style(e.elem,e.prop,e.now+e.unit):e.elem[e.prop]=e.now}}},rr.propHooks.scrollTop=rr.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},b.each([\"toggle\",\"show\",\"hide\"],function(e,t){var n=b.fn[t];b.fn[t]=function(e,r,i){return null==e||\"boolean\"==typeof e?n.apply(this,arguments):this.animate(ir(t,!0),e,r,i)}}),b.fn.extend({fadeTo:function(e,t,n,r){return this.filter(nn).css(\"opacity\",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=b.isEmptyObject(e),o=b.speed(t,n,r),a=function(){var t=er(this,b.extend({},e),o);a.finish=function(){t.stop(!0)},(i||b._data(this,\"finish\"))&&t.stop(!0)};return a.finish=a,i||o.queue===!1?this.each(a):this.queue(o.queue,a)},stop:function(e,n,r){var i=function(e){var t=e.stop;delete e.stop,t(r)};return\"string\"!=typeof e&&(r=n,n=e,e=t),n&&e!==!1&&this.queue(e||\"fx\",[]),this.each(function(){var t=!0,n=null!=e&&e+\"queueHooks\",o=b.timers,a=b._data(this);if(n)a[n]&&a[n].stop&&i(a[n]);else for(n in a)a[n]&&a[n].stop&&Jn.test(n)&&i(a[n]);for(n=o.length;n--;)o[n].elem!==this||null!=e&&o[n].queue!==e||(o[n].anim.stop(r),t=!1,o.splice(n,1));(t||!r)&&b.dequeue(this,e)})},finish:function(e){return e!==!1&&(e=e||\"fx\"),this.each(function(){var t,n=b._data(this),r=n[e+\"queue\"],i=n[e+\"queueHooks\"],o=b.timers,a=r?r.length:0;for(n.finish=!0,b.queue(this,e,[]),i&&i.cur&&i.cur.finish&&i.cur.finish.call(this),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),o.splice(t,1));for(t=0;a>t;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish})}});function ir(e,t){var n,r={height:e},i=0;for(t=t?1:0;4>i;i+=2-t)n=Zt[i],r[\"margin\"+n]=r[\"padding\"+n]=e;return t&&(r.opacity=r.width=e),r}b.each({slideDown:ir(\"show\"),slideUp:ir(\"hide\"),slideToggle:ir(\"toggle\"),fadeIn:{opacity:\"show\"},fadeOut:{opacity:\"hide\"},fadeToggle:{opacity:\"toggle\"}},function(e,t){b.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}}),b.speed=function(e,t,n){var r=e&&\"object\"==typeof e?b.extend({},e):{complete:n||!n&&t||b.isFunction(e)&&e,duration:e,easing:n&&t||t&&!b.isFunction(t)&&t};return r.duration=b.fx.off?0:\"number\"==typeof r.duration?r.duration:r.duration in b.fx.speeds?b.fx.speeds[r.duration]:b.fx.speeds._default,(null==r.queue||r.queue===!0)&&(r.queue=\"fx\"),r.old=r.complete,r.complete=function(){b.isFunction(r.old)&&r.old.call(this),r.queue&&b.dequeue(this,r.queue)},r},b.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2}},b.timers=[],b.fx=rr.prototype.init,b.fx.tick=function(){var e,n=b.timers,r=0;for(Xn=b.now();n.length>r;r++)e=n[r],e()||n[r]!==e||n.splice(r--,1);n.length||b.fx.stop(),Xn=t},b.fx.timer=function(e){e()&&b.timers.push(e)&&b.fx.start()},b.fx.interval=13,b.fx.start=function(){Un||(Un=setInterval(b.fx.tick,b.fx.interval))},b.fx.stop=function(){clearInterval(Un),Un=null},b.fx.speeds={slow:600,fast:200,_default:400},b.fx.step={},b.expr&&b.expr.filters&&(b.expr.filters.animated=function(e){return b.grep(b.timers,function(t){return e===t.elem}).length}),b.fn.offset=function(e){if(arguments.length)return e===t?this:this.each(function(t){b.offset.setOffset(this,e,t)});var n,r,o={top:0,left:0},a=this[0],s=a&&a.ownerDocument;if(s)return n=s.documentElement,b.contains(n,a)?(typeof a.getBoundingClientRect!==i&&(o=a.getBoundingClientRect()),r=or(s),{top:o.top+(r.pageYOffset||n.scrollTop)-(n.clientTop||0),left:o.left+(r.pageXOffset||n.scrollLeft)-(n.clientLeft||0)}):o},b.offset={setOffset:function(e,t,n){var r=b.css(e,\"position\");\"static\"===r&&(e.style.position=\"relative\");var i=b(e),o=i.offset(),a=b.css(e,\"top\"),s=b.css(e,\"left\"),u=(\"absolute\"===r||\"fixed\"===r)&&b.inArray(\"auto\",[a,s])>-1,l={},c={},p,f;u?(c=i.position(),p=c.top,f=c.left):(p=parseFloat(a)||0,f=parseFloat(s)||0),b.isFunction(t)&&(t=t.call(e,n,o)),null!=t.top&&(l.top=t.top-o.top+p),null!=t.left&&(l.left=t.left-o.left+f),\"using\"in t?t.using.call(e,l):i.css(l)}},b.fn.extend({position:function(){if(this[0]){var e,t,n={top:0,left:0},r=this[0];return\"fixed\"===b.css(r,\"position\")?t=r.getBoundingClientRect():(e=this.offsetParent(),t=this.offset(),b.nodeName(e[0],\"html\")||(n=e.offset()),n.top+=b.css(e[0],\"borderTopWidth\",!0),n.left+=b.css(e[0],\"borderLeftWidth\",!0)),{top:t.top-n.top-b.css(r,\"marginTop\",!0),left:t.left-n.left-b.css(r,\"marginLeft\",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent||o.documentElement;while(e&&!b.nodeName(e,\"html\")&&\"static\"===b.css(e,\"position\"))e=e.offsetParent;return e||o.documentElement})}}),b.each({scrollLeft:\"pageXOffset\",scrollTop:\"pageYOffset\"},function(e,n){var r=/Y/.test(n);b.fn[e]=function(i){return b.access(this,function(e,i,o){var a=or(e);return o===t?a?n in a?a[n]:a.document.documentElement[i]:e[i]:(a?a.scrollTo(r?b(a).scrollLeft():o,r?o:b(a).scrollTop()):e[i]=o,t)},e,i,arguments.length,null)}});function or(e){return b.isWindow(e)?e:9===e.nodeType?e.defaultView||e.parentWindow:!1}b.each({Height:\"height\",Width:\"width\"},function(e,n){b.each({padding:\"inner\"+e,content:n,\"\":\"outer\"+e},function(r,i){b.fn[i]=function(i,o){var a=arguments.length&&(r||\"boolean\"!=typeof i),s=r||(i===!0||o===!0?\"margin\":\"border\");return b.access(this,function(n,r,i){var o;return b.isWindow(n)?n.document.documentElement[\"client\"+e]:9===n.nodeType?(o=n.documentElement,Math.max(n.body[\"scroll\"+e],o[\"scroll\"+e],n.body[\"offset\"+e],o[\"offset\"+e],o[\"client\"+e])):i===t?b.css(n,r,s):b.style(n,r,i,s)},n,a?i:t,a,null)}})}),e.jQuery=e.$=b,\"function\"==typeof define&&define.amd&&define.amd.jQuery&&define(\"jquery\",[],function(){return b})})(window);","Plazathemes_Categorytop/js/owl.carousel.min.js":"\nrequire([\"jquery\"], function($){\n\"function\"!==typeof Object.create&&(Object.create=function(f){function g(){}g.prototype=f;return new g});\n(function(f,g,k){var l={init:function(a,b){this.$elem=f(b);this.options=f.extend({},f.fn.owlCarousel.options,this.$elem.data(),a);this.userOptions=a;this.loadContent()},loadContent:function(){function a(a){var d,e=\"\";if(\"function\"===typeof b.options.jsonSuccess)b.options.jsonSuccess.apply(this,[a]);else{for(d in a.owl)a.owl.hasOwnProperty(d)&&(e+=a.owl[d].item);b.$elem.html(e)}b.logIn()}var b=this,e;\"function\"===typeof b.options.beforeInit&&b.options.beforeInit.apply(this,[b.$elem]);\"string\"===typeof b.options.jsonPath?\n(e=b.options.jsonPath,f.getJSON(e,a)):b.logIn()},logIn:function(){this.$elem.data(\"owl-originalStyles\",this.$elem.attr(\"style\"));this.$elem.data(\"owl-originalClasses\",this.$elem.attr(\"class\"));this.$elem.css({opacity:0});this.orignalItems=this.options.items;this.checkBrowser();this.wrapperWidth=0;this.checkVisible=null;this.setVars()},setVars:function(){if(0===this.$elem.children().length)return!1;this.baseClass();this.eventTypes();this.$userItems=this.$elem.children();this.itemsAmount=this.$userItems.length;\nthis.wrapItems();this.$owlItems=this.$elem.find(\".owl-item\");this.$owlWrapper=this.$elem.find(\".owl-wrapper\");this.playDirection=\"next\";this.prevItem=0;this.prevArr=[0];this.currentItem=0;this.customEvents();this.onStartup()},onStartup:function(){this.updateItems();this.calculateAll();this.buildControls();this.updateControls();this.response();this.moveEvents();this.stopOnHover();this.owlStatus();!1!==this.options.transitionStyle&&this.transitionTypes(this.options.transitionStyle);!0===this.options.autoPlay&&\n(this.options.autoPlay=5E3);this.play();this.$elem.find(\".owl-wrapper\").css(\"display\",\"block\");this.$elem.is(\":visible\")?this.$elem.css(\"opacity\",1):this.watchVisibility();this.onstartup=!1;this.eachMoveUpdate();\"function\"===typeof this.options.afterInit&&this.options.afterInit.apply(this,[this.$elem])},eachMoveUpdate:function(){!0===this.options.lazyLoad&&this.lazyLoad();!0===this.options.autoHeight&&this.autoHeight();this.onVisibleItems();\"function\"===typeof this.options.afterAction&&this.options.afterAction.apply(this,\n[this.$elem])},updateVars:function(){\"function\"===typeof this.options.beforeUpdate&&this.options.beforeUpdate.apply(this,[this.$elem]);this.watchVisibility();this.updateItems();this.calculateAll();this.updatePosition();this.updateControls();this.eachMoveUpdate();\"function\"===typeof this.options.afterUpdate&&this.options.afterUpdate.apply(this,[this.$elem])},reload:function(){var a=this;g.setTimeout(function(){a.updateVars()},0)},watchVisibility:function(){var a=this;if(!1===a.$elem.is(\":visible\"))a.$elem.css({opacity:0}),\ng.clearInterval(a.autoPlayInterval),g.clearInterval(a.checkVisible);else return!1;a.checkVisible=g.setInterval(function(){a.$elem.is(\":visible\")&&(a.reload(),a.$elem.animate({opacity:1},200),g.clearInterval(a.checkVisible))},500)},wrapItems:function(){this.$userItems.wrapAll('<div class=\"owl-wrapper\">').wrap('<div class=\"owl-item\"></div>');this.$elem.find(\".owl-wrapper\").wrap('<div class=\"owl-wrapper-outer\">');this.wrapperOuter=this.$elem.find(\".owl-wrapper-outer\");this.$elem.css(\"display\",\"block\")},\nbaseClass:function(){var a=this.$elem.hasClass(this.options.baseClass),b=this.$elem.hasClass(this.options.theme);a||this.$elem.addClass(this.options.baseClass);b||this.$elem.addClass(this.options.theme)},updateItems:function(){var a,b;if(!1===this.options.responsive)return!1;if(!0===this.options.singleItem)return this.options.items=this.orignalItems=1,this.options.itemsCustom=!1,this.options.itemsDesktop=!1,this.options.itemsDesktopSmall=!1,this.options.itemsTablet=!1,this.options.itemsTabletSmall=\n!1,this.options.itemsMobile=!1;a=f(this.options.responsiveBaseWidth).width();a>(this.options.itemsDesktop[0]||this.orignalItems)&&(this.options.items=this.orignalItems);if(!1!==this.options.itemsCustom)for(this.options.itemsCustom.sort(function(a,b){return a[0]-b[0]}),b=0;b<this.options.itemsCustom.length;b+=1)this.options.itemsCustom[b][0]<=a&&(this.options.items=this.options.itemsCustom[b][1]);else a<=this.options.itemsDesktop[0]&&!1!==this.options.itemsDesktop&&(this.options.items=this.options.itemsDesktop[1]),\na<=this.options.itemsDesktopSmall[0]&&!1!==this.options.itemsDesktopSmall&&(this.options.items=this.options.itemsDesktopSmall[1]),a<=this.options.itemsTablet[0]&&!1!==this.options.itemsTablet&&(this.options.items=this.options.itemsTablet[1]),a<=this.options.itemsTabletSmall[0]&&!1!==this.options.itemsTabletSmall&&(this.options.items=this.options.itemsTabletSmall[1]),a<=this.options.itemsMobile[0]&&!1!==this.options.itemsMobile&&(this.options.items=this.options.itemsMobile[1]);this.options.items>this.itemsAmount&&\n!0===this.options.itemsScaleUp&&(this.options.items=this.itemsAmount)},response:function(){var a=this,b,e;if(!0!==a.options.responsive)return!1;e=f(g).width();a.resizer=function(){f(g).width()!==e&&(!1!==a.options.autoPlay&&g.clearInterval(a.autoPlayInterval),g.clearTimeout(b),b=g.setTimeout(function(){e=f(g).width();a.updateVars()},a.options.responsiveRefreshRate))};f(g).resize(a.resizer)},updatePosition:function(){this.jumpTo(this.currentItem);!1!==this.options.autoPlay&&this.checkAp()},appendItemsSizes:function(){var a=\nthis,b=0,e=a.itemsAmount-a.options.items;a.$owlItems.each(function(c){var d=f(this);d.css({width:a.itemWidth}).data(\"owl-item\",Number(c));if(0===c%a.options.items||c===e)c>e||(b+=1);d.data(\"owl-roundPages\",b)})},appendWrapperSizes:function(){this.$owlWrapper.css({width:this.$owlItems.length*this.itemWidth*2,left:0});this.appendItemsSizes()},calculateAll:function(){this.calculateWidth();this.appendWrapperSizes();this.loops();this.max()},calculateWidth:function(){this.itemWidth=Math.round(this.$elem.width()/\nthis.options.items)},max:function(){var a=-1*(this.itemsAmount*this.itemWidth-this.options.items*this.itemWidth);this.options.items>this.itemsAmount?this.maximumPixels=a=this.maximumItem=0:(this.maximumItem=this.itemsAmount-this.options.items,this.maximumPixels=a);return a},min:function(){return 0},loops:function(){var a=0,b=0,e,c;this.positionsInArray=[0];this.pagesInArray=[];for(e=0;e<this.itemsAmount;e+=1)b+=this.itemWidth,this.positionsInArray.push(-b),!0===this.options.scrollPerPage&&(c=f(this.$owlItems[e]),\nc=c.data(\"owl-roundPages\"),c!==a&&(this.pagesInArray[a]=this.positionsInArray[e],a=c))},buildControls:function(){if(!0===this.options.navigation||!0===this.options.pagination)this.owlControls=f('<div class=\"owl-controls\"/>').toggleClass(\"clickable\",!this.browser.isTouch).appendTo(this.$elem);!0===this.options.pagination&&this.buildPagination();!0===this.options.navigation&&this.buildButtons()},buildButtons:function(){var a=this,b=f('<div class=\"owl-buttons\"/>');a.owlControls.append(b);a.buttonPrev=\nf(\"<div/>\",{\"class\":\"owl-prev\",html:a.options.navigationText[0]||\"\"});a.buttonNext=f(\"<div/>\",{\"class\":\"owl-next\",html:a.options.navigationText[1]||\"\"});b.append(a.buttonPrev).append(a.buttonNext);b.on(\"touchstart.owlControls mousedown.owlControls\",'div[class^=\"owl\"]',function(a){a.preventDefault()});b.on(\"touchend.owlControls mouseup.owlControls\",'div[class^=\"owl\"]',function(b){b.preventDefault();f(this).hasClass(\"owl-next\")?a.next():a.prev()})},buildPagination:function(){var a=this;a.paginationWrapper=\nf('<div class=\"owl-pagination\"/>');a.owlControls.append(a.paginationWrapper);a.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\",\".owl-page\",function(b){b.preventDefault();Number(f(this).data(\"owl-page\"))!==a.currentItem&&a.goTo(Number(f(this).data(\"owl-page\")),!0)})},updatePagination:function(){var a,b,e,c,d,g;if(!1===this.options.pagination)return!1;this.paginationWrapper.html(\"\");a=0;b=this.itemsAmount-this.itemsAmount%this.options.items;for(c=0;c<this.itemsAmount;c+=1)0===c%this.options.items&&\n(a+=1,b===c&&(e=this.itemsAmount-this.options.items),d=f(\"<div/>\",{\"class\":\"owl-page\"}),g=f(\"<span></span>\",{text:!0===this.options.paginationNumbers?a:\"\",\"class\":!0===this.options.paginationNumbers?\"owl-numbers\":\"\"}),d.append(g),d.data(\"owl-page\",b===c?e:c),d.data(\"owl-roundPages\",a),this.paginationWrapper.append(d));this.checkPagination()},checkPagination:function(){var a=this;if(!1===a.options.pagination)return!1;a.paginationWrapper.find(\".owl-page\").each(function(){f(this).data(\"owl-roundPages\")===\nf(a.$owlItems[a.currentItem]).data(\"owl-roundPages\")&&(a.paginationWrapper.find(\".owl-page\").removeClass(\"active\"),f(this).addClass(\"active\"))})},checkNavigation:function(){if(!1===this.options.navigation)return!1;!1===this.options.rewindNav&&(0===this.currentItem&&0===this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0===this.currentItem&&0!==this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")):this.currentItem===\nthis.maximumItem?(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0!==this.currentItem&&this.currentItem!==this.maximumItem&&(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")))},updateControls:function(){this.updatePagination();this.checkNavigation();this.owlControls&&(this.options.items>=this.itemsAmount?this.owlControls.hide():this.owlControls.show())},destroyControls:function(){this.owlControls&&this.owlControls.remove()},next:function(a){if(this.isTransition)return!1;\nthis.currentItem+=!0===this.options.scrollPerPage?this.options.items:1;if(this.currentItem>this.maximumItem+(!0===this.options.scrollPerPage?this.options.items-1:0))if(!0===this.options.rewindNav)this.currentItem=0,a=\"rewind\";else return this.currentItem=this.maximumItem,!1;this.goTo(this.currentItem,a)},prev:function(a){if(this.isTransition)return!1;this.currentItem=!0===this.options.scrollPerPage&&0<this.currentItem&&this.currentItem<this.options.items?0:this.currentItem-(!0===this.options.scrollPerPage?\nthis.options.items:1);if(0>this.currentItem)if(!0===this.options.rewindNav)this.currentItem=this.maximumItem,a=\"rewind\";else return this.currentItem=0,!1;this.goTo(this.currentItem,a)},goTo:function(a,b,e){var c=this;if(c.isTransition)return!1;\"function\"===typeof c.options.beforeMove&&c.options.beforeMove.apply(this,[c.$elem]);a>=c.maximumItem?a=c.maximumItem:0>=a&&(a=0);c.currentItem=c.owl.currentItem=a;if(!1!==c.options.transitionStyle&&\"drag\"!==e&&1===c.options.items&&!0===c.browser.support3d)return c.swapSpeed(0),\n!0===c.browser.support3d?c.transition3d(c.positionsInArray[a]):c.css2slide(c.positionsInArray[a],1),c.afterGo(),c.singleItemTransition(),!1;a=c.positionsInArray[a];!0===c.browser.support3d?(c.isCss3Finish=!1,!0===b?(c.swapSpeed(\"paginationSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},c.options.paginationSpeed)):\"rewind\"===b?(c.swapSpeed(c.options.rewindSpeed),g.setTimeout(function(){c.isCss3Finish=!0},c.options.rewindSpeed)):(c.swapSpeed(\"slideSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},\nc.options.slideSpeed)),c.transition3d(a)):!0===b?c.css2slide(a,c.options.paginationSpeed):\"rewind\"===b?c.css2slide(a,c.options.rewindSpeed):c.css2slide(a,c.options.slideSpeed);c.afterGo()},jumpTo:function(a){\"function\"===typeof this.options.beforeMove&&this.options.beforeMove.apply(this,[this.$elem]);a>=this.maximumItem||-1===a?a=this.maximumItem:0>=a&&(a=0);this.swapSpeed(0);!0===this.browser.support3d?this.transition3d(this.positionsInArray[a]):this.css2slide(this.positionsInArray[a],1);this.currentItem=\nthis.owl.currentItem=a;this.afterGo()},afterGo:function(){this.prevArr.push(this.currentItem);this.prevItem=this.owl.prevItem=this.prevArr[this.prevArr.length-2];this.prevArr.shift(0);this.prevItem!==this.currentItem&&(this.checkPagination(),this.checkNavigation(),this.eachMoveUpdate(),!1!==this.options.autoPlay&&this.checkAp());\"function\"===typeof this.options.afterMove&&this.prevItem!==this.currentItem&&this.options.afterMove.apply(this,[this.$elem])},stop:function(){this.apStatus=\"stop\";g.clearInterval(this.autoPlayInterval)},\ncheckAp:function(){\"stop\"!==this.apStatus&&this.play()},play:function(){var a=this;a.apStatus=\"play\";if(!1===a.options.autoPlay)return!1;g.clearInterval(a.autoPlayInterval);a.autoPlayInterval=g.setInterval(function(){a.next(!0)},a.options.autoPlay)},swapSpeed:function(a){\"slideSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.slideSpeed)):\"paginationSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.paginationSpeed)):\"string\"!==typeof a&&this.$owlWrapper.css(this.addCssSpeed(a))},\naddCssSpeed:function(a){return{\"-webkit-transition\":\"all \"+a+\"ms ease\",\"-moz-transition\":\"all \"+a+\"ms ease\",\"-o-transition\":\"all \"+a+\"ms ease\",transition:\"all \"+a+\"ms ease\"}},removeTransition:function(){return{\"-webkit-transition\":\"\",\"-moz-transition\":\"\",\"-o-transition\":\"\",transition:\"\"}},doTranslate:function(a){return{\"-webkit-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-moz-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-o-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-ms-transform\":\"translate3d(\"+\na+\"px, 0px, 0px)\",transform:\"translate3d(\"+a+\"px, 0px,0px)\"}},transition3d:function(a){this.$owlWrapper.css(this.doTranslate(a))},css2move:function(a){this.$owlWrapper.css({left:a})},css2slide:function(a,b){var e=this;e.isCssFinish=!1;e.$owlWrapper.stop(!0,!0).animate({left:a},{duration:b||e.options.slideSpeed,complete:function(){e.isCssFinish=!0}})},checkBrowser:function(){var a=k.createElement(\"div\");a.style.cssText=\"  -moz-transform:translate3d(0px, 0px, 0px); -ms-transform:translate3d(0px, 0px, 0px); -o-transform:translate3d(0px, 0px, 0px); -webkit-transform:translate3d(0px, 0px, 0px); transform:translate3d(0px, 0px, 0px)\";\na=a.style.cssText.match(/translate3d\\(0px, 0px, 0px\\)/g);this.browser={support3d:null!==a&&1===a.length,isTouch:\"ontouchstart\"in g||g.navigator.msMaxTouchPoints}},moveEvents:function(){if(!1!==this.options.mouseDrag||!1!==this.options.touchDrag)this.gestures(),this.disabledEvents()},eventTypes:function(){var a=[\"s\",\"e\",\"x\"];this.ev_types={};!0===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl mousedown.owl\",\"touchmove.owl mousemove.owl\",\"touchend.owl touchcancel.owl mouseup.owl\"]:\n!1===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl\",\"touchmove.owl\",\"touchend.owl touchcancel.owl\"]:!0===this.options.mouseDrag&&!1===this.options.touchDrag&&(a=[\"mousedown.owl\",\"mousemove.owl\",\"mouseup.owl\"]);this.ev_types.start=a[0];this.ev_types.move=a[1];this.ev_types.end=a[2]},disabledEvents:function(){this.$elem.on(\"dragstart.owl\",function(a){a.preventDefault()});this.$elem.on(\"mousedown.disableTextSelect\",function(a){return f(a.target).is(\"input, textarea, select, option\")})},\ngestures:function(){function a(a){if(void 0!==a.touches)return{x:a.touches[0].pageX,y:a.touches[0].pageY};if(void 0===a.touches){if(void 0!==a.pageX)return{x:a.pageX,y:a.pageY};if(void 0===a.pageX)return{x:a.clientX,y:a.clientY}}}function b(a){\"on\"===a?(f(k).on(d.ev_types.move,e),f(k).on(d.ev_types.end,c)):\"off\"===a&&(f(k).off(d.ev_types.move),f(k).off(d.ev_types.end))}function e(b){b=b.originalEvent||b||g.event;d.newPosX=a(b).x-h.offsetX;d.newPosY=a(b).y-h.offsetY;d.newRelativeX=d.newPosX-h.relativePos;\n\"function\"===typeof d.options.startDragging&&!0!==h.dragging&&0!==d.newRelativeX&&(h.dragging=!0,d.options.startDragging.apply(d,[d.$elem]));(8<d.newRelativeX||-8>d.newRelativeX)&&!0===d.browser.isTouch&&(void 0!==b.preventDefault?b.preventDefault():b.returnValue=!1,h.sliding=!0);(10<d.newPosY||-10>d.newPosY)&&!1===h.sliding&&f(k).off(\"touchmove.owl\");d.newPosX=Math.max(Math.min(d.newPosX,d.newRelativeX/5),d.maximumPixels+d.newRelativeX/5);!0===d.browser.support3d?d.transition3d(d.newPosX):d.css2move(d.newPosX)}\nfunction c(a){a=a.originalEvent||a||g.event;var c;a.target=a.target||a.srcElement;h.dragging=!1;!0!==d.browser.isTouch&&d.$owlWrapper.removeClass(\"grabbing\");d.dragDirection=0>d.newRelativeX?d.owl.dragDirection=\"left\":d.owl.dragDirection=\"right\";0!==d.newRelativeX&&(c=d.getNewPosition(),d.goTo(c,!1,\"drag\"),h.targetElement===a.target&&!0!==d.browser.isTouch&&(f(a.target).on(\"click.disable\",function(a){a.stopImmediatePropagation();a.stopPropagation();a.preventDefault();f(a.target).off(\"click.disable\")}),\na=f._data(a.target,\"events\").click,c=a.pop(),a.splice(0,0,c)));b(\"off\")}var d=this,h={offsetX:0,offsetY:0,baseElWidth:0,relativePos:0,position:null,minSwipe:null,maxSwipe:null,sliding:null,dargging:null,targetElement:null};d.isCssFinish=!0;d.$elem.on(d.ev_types.start,\".owl-wrapper\",function(c){c=c.originalEvent||c||g.event;var e;if(3===c.which)return!1;if(!(d.itemsAmount<=d.options.items)){if(!1===d.isCssFinish&&!d.options.dragBeforeAnimFinish||!1===d.isCss3Finish&&!d.options.dragBeforeAnimFinish)return!1;\n!1!==d.options.autoPlay&&g.clearInterval(d.autoPlayInterval);!0===d.browser.isTouch||d.$owlWrapper.hasClass(\"grabbing\")||d.$owlWrapper.addClass(\"grabbing\");d.newPosX=0;d.newRelativeX=0;f(this).css(d.removeTransition());e=f(this).position();h.relativePos=e.left;h.offsetX=a(c).x-e.left;h.offsetY=a(c).y-e.top;b(\"on\");h.sliding=!1;h.targetElement=c.target||c.srcElement}})},getNewPosition:function(){var a=this.closestItem();a>this.maximumItem?a=this.currentItem=this.maximumItem:0<=this.newPosX&&(this.currentItem=\na=0);return a},closestItem:function(){var a=this,b=!0===a.options.scrollPerPage?a.pagesInArray:a.positionsInArray,e=a.newPosX,c=null;f.each(b,function(d,g){e-a.itemWidth/20>b[d+1]&&e-a.itemWidth/20<g&&\"left\"===a.moveDirection()?(c=g,a.currentItem=!0===a.options.scrollPerPage?f.inArray(c,a.positionsInArray):d):e+a.itemWidth/20<g&&e+a.itemWidth/20>(b[d+1]||b[d]-a.itemWidth)&&\"right\"===a.moveDirection()&&(!0===a.options.scrollPerPage?(c=b[d+1]||b[b.length-1],a.currentItem=f.inArray(c,a.positionsInArray)):\n(c=b[d+1],a.currentItem=d+1))});return a.currentItem},moveDirection:function(){var a;0>this.newRelativeX?(a=\"right\",this.playDirection=\"next\"):(a=\"left\",this.playDirection=\"prev\");return a},customEvents:function(){var a=this;a.$elem.on(\"owl.next\",function(){a.next()});a.$elem.on(\"owl.prev\",function(){a.prev()});a.$elem.on(\"owl.play\",function(b,e){a.options.autoPlay=e;a.play();a.hoverStatus=\"play\"});a.$elem.on(\"owl.stop\",function(){a.stop();a.hoverStatus=\"stop\"});a.$elem.on(\"owl.goTo\",function(b,e){a.goTo(e)});\na.$elem.on(\"owl.jumpTo\",function(b,e){a.jumpTo(e)})},stopOnHover:function(){var a=this;!0===a.options.stopOnHover&&!0!==a.browser.isTouch&&!1!==a.options.autoPlay&&(a.$elem.on(\"mouseover\",function(){a.stop()}),a.$elem.on(\"mouseout\",function(){\"stop\"!==a.hoverStatus&&a.play()}))},lazyLoad:function(){var a,b,e,c,d;if(!1===this.options.lazyLoad)return!1;for(a=0;a<this.itemsAmount;a+=1)b=f(this.$owlItems[a]),\"loaded\"!==b.data(\"owl-loaded\")&&(e=b.data(\"owl-item\"),c=b.find(\".lazyOwl\"),\"string\"!==typeof c.data(\"src\")?\nb.data(\"owl-loaded\",\"loaded\"):(void 0===b.data(\"owl-loaded\")&&(c.hide(),b.addClass(\"loading\").data(\"owl-loaded\",\"checked\")),(d=!0===this.options.lazyFollow?e>=this.currentItem:!0)&&e<this.currentItem+this.options.items&&c.length&&this.lazyPreload(b,c)))},lazyPreload:function(a,b){function e(){a.data(\"owl-loaded\",\"loaded\").removeClass(\"loading\");b.removeAttr(\"data-src\");\"fade\"===d.options.lazyEffect?b.fadeIn(400):b.show();\"function\"===typeof d.options.afterLazyLoad&&d.options.afterLazyLoad.apply(this,\n[d.$elem])}function c(){f+=1;d.completeImg(b.get(0))||!0===k?e():100>=f?g.setTimeout(c,100):e()}var d=this,f=0,k;\"DIV\"===b.prop(\"tagName\")?(b.css(\"background-image\",\"url(\"+b.data(\"src\")+\")\"),k=!0):b[0].src=b.data(\"src\");c()},autoHeight:function(){function a(){var a=f(e.$owlItems[e.currentItem]).height();e.wrapperOuter.css(\"height\",a+\"px\");e.wrapperOuter.hasClass(\"autoHeight\")||g.setTimeout(function(){e.wrapperOuter.addClass(\"autoHeight\")},0)}function b(){d+=1;e.completeImg(c.get(0))?a():100>=d?g.setTimeout(b,\n100):e.wrapperOuter.css(\"height\",\"\")}var e=this,c=f(e.$owlItems[e.currentItem]).find(\"img\"),d;void 0!==c.get(0)?(d=0,b()):a()},completeImg:function(a){return!a.complete||\"undefined\"!==typeof a.naturalWidth&&0===a.naturalWidth?!1:!0},onVisibleItems:function(){var a;!0===this.options.addClassActive&&this.$owlItems.removeClass(\"active\");this.visibleItems=[];for(a=this.currentItem;a<this.currentItem+this.options.items;a+=1)this.visibleItems.push(a),!0===this.options.addClassActive&&f(this.$owlItems[a]).addClass(\"active\");\nthis.owl.visibleItems=this.visibleItems},transitionTypes:function(a){this.outClass=\"owl-\"+a+\"-out\";this.inClass=\"owl-\"+a+\"-in\"},singleItemTransition:function(){var a=this,b=a.outClass,e=a.inClass,c=a.$owlItems.eq(a.currentItem),d=a.$owlItems.eq(a.prevItem),f=Math.abs(a.positionsInArray[a.currentItem])+a.positionsInArray[a.prevItem],g=Math.abs(a.positionsInArray[a.currentItem])+a.itemWidth/2;a.isTransition=!0;a.$owlWrapper.addClass(\"owl-origin\").css({\"-webkit-transform-origin\":g+\"px\",\"-moz-perspective-origin\":g+\n\"px\",\"perspective-origin\":g+\"px\"});d.css({position:\"relative\",left:f+\"px\"}).addClass(b).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endPrev=!0;d.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(d,b)});c.addClass(e).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endCurrent=!0;c.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(c,e)})},clearTransStyle:function(a,\nb){a.css({position:\"\",left:\"\"}).removeClass(b);this.endPrev&&this.endCurrent&&(this.$owlWrapper.removeClass(\"owl-origin\"),this.isTransition=this.endCurrent=this.endPrev=!1)},owlStatus:function(){this.owl={userOptions:this.userOptions,baseElement:this.$elem,userItems:this.$userItems,owlItems:this.$owlItems,currentItem:this.currentItem,prevItem:this.prevItem,visibleItems:this.visibleItems,isTouch:this.browser.isTouch,browser:this.browser,dragDirection:this.dragDirection}},clearEvents:function(){this.$elem.off(\".owl owl mousedown.disableTextSelect\");\nf(k).off(\".owl owl\");f(g).off(\"resize\",this.resizer)},unWrap:function(){0!==this.$elem.children().length&&(this.$owlWrapper.unwrap(),this.$userItems.unwrap().unwrap(),this.owlControls&&this.owlControls.remove());this.clearEvents();this.$elem.attr(\"style\",this.$elem.data(\"owl-originalStyles\")||\"\").attr(\"class\",this.$elem.data(\"owl-originalClasses\"))},destroy:function(){this.stop();g.clearInterval(this.checkVisible);this.unWrap();this.$elem.removeData()},reinit:function(a){a=f.extend({},this.userOptions,\na);this.unWrap();this.init(a,this.$elem)},addItem:function(a,b){var e;if(!a)return!1;if(0===this.$elem.children().length)return this.$elem.append(a),this.setVars(),!1;this.unWrap();e=void 0===b||-1===b?-1:b;e>=this.$userItems.length||-1===e?this.$userItems.eq(-1).after(a):this.$userItems.eq(e).before(a);this.setVars()},removeItem:function(a){if(0===this.$elem.children().length)return!1;a=void 0===a||-1===a?-1:a;this.unWrap();this.$userItems.eq(a).remove();this.setVars()}};f.fn.owlCarousel=function(a){return this.each(function(){if(!0===\nf(this).data(\"owl-init\"))return!1;f(this).data(\"owl-init\",!0);var b=Object.create(l);b.init(a,this);f.data(this,\"owlCarousel\",b)})};f.fn.owlCarousel.options={items:5,itemsCustom:!1,itemsDesktop:[1199,4],itemsDesktopSmall:[979,3],itemsTablet:[768,2],itemsTabletSmall:!1,itemsMobile:[479,1],singleItem:!1,itemsScaleUp:!1,slideSpeed:200,paginationSpeed:800,rewindSpeed:1E3,autoPlay:!1,stopOnHover:!1,navigation:!1,navigationText:[\"prev\",\"next\"],rewindNav:!0,scrollPerPage:!1,pagination:!0,paginationNumbers:!1,\nresponsive:!0,responsiveRefreshRate:200,responsiveBaseWidth:g,baseClass:\"owl-carousel\",theme:\"owl-theme\",lazyLoad:!1,lazyFollow:!0,lazyEffect:\"fade\",autoHeight:!1,jsonPath:!1,jsonSuccess:!1,dragBeforeAnimFinish:!0,mouseDrag:!0,touchDrag:!0,addClassActive:!1,transitionStyle:!1,beforeUpdate:!1,afterUpdate:!1,beforeInit:!1,afterInit:!1,beforeMove:!1,afterMove:!1,afterAction:!1,startDragging:!1,afterLazyLoad:!1}})(jQuery,window,document);\n});","Plazathemes_Featureproductslider/js/owl.carousel.min.js":"\nrequire([\"jquery\"], function($){\n\"function\"!==typeof Object.create&&(Object.create=function(f){function g(){}g.prototype=f;return new g});\n(function(f,g,k){var l={init:function(a,b){this.$elem=f(b);this.options=f.extend({},f.fn.owlCarousel.options,this.$elem.data(),a);this.userOptions=a;this.loadContent()},loadContent:function(){function a(a){var d,e=\"\";if(\"function\"===typeof b.options.jsonSuccess)b.options.jsonSuccess.apply(this,[a]);else{for(d in a.owl)a.owl.hasOwnProperty(d)&&(e+=a.owl[d].item);b.$elem.html(e)}b.logIn()}var b=this,e;\"function\"===typeof b.options.beforeInit&&b.options.beforeInit.apply(this,[b.$elem]);\"string\"===typeof b.options.jsonPath?\n(e=b.options.jsonPath,f.getJSON(e,a)):b.logIn()},logIn:function(){this.$elem.data(\"owl-originalStyles\",this.$elem.attr(\"style\"));this.$elem.data(\"owl-originalClasses\",this.$elem.attr(\"class\"));this.$elem.css({opacity:0});this.orignalItems=this.options.items;this.checkBrowser();this.wrapperWidth=0;this.checkVisible=null;this.setVars()},setVars:function(){if(0===this.$elem.children().length)return!1;this.baseClass();this.eventTypes();this.$userItems=this.$elem.children();this.itemsAmount=this.$userItems.length;\nthis.wrapItems();this.$owlItems=this.$elem.find(\".owl-item\");this.$owlWrapper=this.$elem.find(\".owl-wrapper\");this.playDirection=\"next\";this.prevItem=0;this.prevArr=[0];this.currentItem=0;this.customEvents();this.onStartup()},onStartup:function(){this.updateItems();this.calculateAll();this.buildControls();this.updateControls();this.response();this.moveEvents();this.stopOnHover();this.owlStatus();!1!==this.options.transitionStyle&&this.transitionTypes(this.options.transitionStyle);!0===this.options.autoPlay&&\n(this.options.autoPlay=5E3);this.play();this.$elem.find(\".owl-wrapper\").css(\"display\",\"block\");this.$elem.is(\":visible\")?this.$elem.css(\"opacity\",1):this.watchVisibility();this.onstartup=!1;this.eachMoveUpdate();\"function\"===typeof this.options.afterInit&&this.options.afterInit.apply(this,[this.$elem])},eachMoveUpdate:function(){!0===this.options.lazyLoad&&this.lazyLoad();!0===this.options.autoHeight&&this.autoHeight();this.onVisibleItems();\"function\"===typeof this.options.afterAction&&this.options.afterAction.apply(this,\n[this.$elem])},updateVars:function(){\"function\"===typeof this.options.beforeUpdate&&this.options.beforeUpdate.apply(this,[this.$elem]);this.watchVisibility();this.updateItems();this.calculateAll();this.updatePosition();this.updateControls();this.eachMoveUpdate();\"function\"===typeof this.options.afterUpdate&&this.options.afterUpdate.apply(this,[this.$elem])},reload:function(){var a=this;g.setTimeout(function(){a.updateVars()},0)},watchVisibility:function(){var a=this;if(!1===a.$elem.is(\":visible\"))a.$elem.css({opacity:0}),\ng.clearInterval(a.autoPlayInterval),g.clearInterval(a.checkVisible);else return!1;a.checkVisible=g.setInterval(function(){a.$elem.is(\":visible\")&&(a.reload(),a.$elem.animate({opacity:1},200),g.clearInterval(a.checkVisible))},500)},wrapItems:function(){this.$userItems.wrapAll('<div class=\"owl-wrapper\">').wrap('<div class=\"owl-item\"></div>');this.$elem.find(\".owl-wrapper\").wrap('<div class=\"owl-wrapper-outer\">');this.wrapperOuter=this.$elem.find(\".owl-wrapper-outer\");this.$elem.css(\"display\",\"block\")},\nbaseClass:function(){var a=this.$elem.hasClass(this.options.baseClass),b=this.$elem.hasClass(this.options.theme);a||this.$elem.addClass(this.options.baseClass);b||this.$elem.addClass(this.options.theme)},updateItems:function(){var a,b;if(!1===this.options.responsive)return!1;if(!0===this.options.singleItem)return this.options.items=this.orignalItems=1,this.options.itemsCustom=!1,this.options.itemsDesktop=!1,this.options.itemsDesktopSmall=!1,this.options.itemsTablet=!1,this.options.itemsTabletSmall=\n!1,this.options.itemsMobile=!1;a=f(this.options.responsiveBaseWidth).width();a>(this.options.itemsDesktop[0]||this.orignalItems)&&(this.options.items=this.orignalItems);if(!1!==this.options.itemsCustom)for(this.options.itemsCustom.sort(function(a,b){return a[0]-b[0]}),b=0;b<this.options.itemsCustom.length;b+=1)this.options.itemsCustom[b][0]<=a&&(this.options.items=this.options.itemsCustom[b][1]);else a<=this.options.itemsDesktop[0]&&!1!==this.options.itemsDesktop&&(this.options.items=this.options.itemsDesktop[1]),\na<=this.options.itemsDesktopSmall[0]&&!1!==this.options.itemsDesktopSmall&&(this.options.items=this.options.itemsDesktopSmall[1]),a<=this.options.itemsTablet[0]&&!1!==this.options.itemsTablet&&(this.options.items=this.options.itemsTablet[1]),a<=this.options.itemsTabletSmall[0]&&!1!==this.options.itemsTabletSmall&&(this.options.items=this.options.itemsTabletSmall[1]),a<=this.options.itemsMobile[0]&&!1!==this.options.itemsMobile&&(this.options.items=this.options.itemsMobile[1]);this.options.items>this.itemsAmount&&\n!0===this.options.itemsScaleUp&&(this.options.items=this.itemsAmount)},response:function(){var a=this,b,e;if(!0!==a.options.responsive)return!1;e=f(g).width();a.resizer=function(){f(g).width()!==e&&(!1!==a.options.autoPlay&&g.clearInterval(a.autoPlayInterval),g.clearTimeout(b),b=g.setTimeout(function(){e=f(g).width();a.updateVars()},a.options.responsiveRefreshRate))};f(g).resize(a.resizer)},updatePosition:function(){this.jumpTo(this.currentItem);!1!==this.options.autoPlay&&this.checkAp()},appendItemsSizes:function(){var a=\nthis,b=0,e=a.itemsAmount-a.options.items;a.$owlItems.each(function(c){var d=f(this);d.css({width:a.itemWidth}).data(\"owl-item\",Number(c));if(0===c%a.options.items||c===e)c>e||(b+=1);d.data(\"owl-roundPages\",b)})},appendWrapperSizes:function(){this.$owlWrapper.css({width:this.$owlItems.length*this.itemWidth*2,left:0});this.appendItemsSizes()},calculateAll:function(){this.calculateWidth();this.appendWrapperSizes();this.loops();this.max()},calculateWidth:function(){this.itemWidth=Math.round(this.$elem.width()/\nthis.options.items)},max:function(){var a=-1*(this.itemsAmount*this.itemWidth-this.options.items*this.itemWidth);this.options.items>this.itemsAmount?this.maximumPixels=a=this.maximumItem=0:(this.maximumItem=this.itemsAmount-this.options.items,this.maximumPixels=a);return a},min:function(){return 0},loops:function(){var a=0,b=0,e,c;this.positionsInArray=[0];this.pagesInArray=[];for(e=0;e<this.itemsAmount;e+=1)b+=this.itemWidth,this.positionsInArray.push(-b),!0===this.options.scrollPerPage&&(c=f(this.$owlItems[e]),\nc=c.data(\"owl-roundPages\"),c!==a&&(this.pagesInArray[a]=this.positionsInArray[e],a=c))},buildControls:function(){if(!0===this.options.navigation||!0===this.options.pagination)this.owlControls=f('<div class=\"owl-controls\"/>').toggleClass(\"clickable\",!this.browser.isTouch).appendTo(this.$elem);!0===this.options.pagination&&this.buildPagination();!0===this.options.navigation&&this.buildButtons()},buildButtons:function(){var a=this,b=f('<div class=\"owl-buttons\"/>');a.owlControls.append(b);a.buttonPrev=\nf(\"<div/>\",{\"class\":\"owl-prev\",html:a.options.navigationText[0]||\"\"});a.buttonNext=f(\"<div/>\",{\"class\":\"owl-next\",html:a.options.navigationText[1]||\"\"});b.append(a.buttonPrev).append(a.buttonNext);b.on(\"touchstart.owlControls mousedown.owlControls\",'div[class^=\"owl\"]',function(a){a.preventDefault()});b.on(\"touchend.owlControls mouseup.owlControls\",'div[class^=\"owl\"]',function(b){b.preventDefault();f(this).hasClass(\"owl-next\")?a.next():a.prev()})},buildPagination:function(){var a=this;a.paginationWrapper=\nf('<div class=\"owl-pagination\"/>');a.owlControls.append(a.paginationWrapper);a.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\",\".owl-page\",function(b){b.preventDefault();Number(f(this).data(\"owl-page\"))!==a.currentItem&&a.goTo(Number(f(this).data(\"owl-page\")),!0)})},updatePagination:function(){var a,b,e,c,d,g;if(!1===this.options.pagination)return!1;this.paginationWrapper.html(\"\");a=0;b=this.itemsAmount-this.itemsAmount%this.options.items;for(c=0;c<this.itemsAmount;c+=1)0===c%this.options.items&&\n(a+=1,b===c&&(e=this.itemsAmount-this.options.items),d=f(\"<div/>\",{\"class\":\"owl-page\"}),g=f(\"<span></span>\",{text:!0===this.options.paginationNumbers?a:\"\",\"class\":!0===this.options.paginationNumbers?\"owl-numbers\":\"\"}),d.append(g),d.data(\"owl-page\",b===c?e:c),d.data(\"owl-roundPages\",a),this.paginationWrapper.append(d));this.checkPagination()},checkPagination:function(){var a=this;if(!1===a.options.pagination)return!1;a.paginationWrapper.find(\".owl-page\").each(function(){f(this).data(\"owl-roundPages\")===\nf(a.$owlItems[a.currentItem]).data(\"owl-roundPages\")&&(a.paginationWrapper.find(\".owl-page\").removeClass(\"active\"),f(this).addClass(\"active\"))})},checkNavigation:function(){if(!1===this.options.navigation)return!1;!1===this.options.rewindNav&&(0===this.currentItem&&0===this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0===this.currentItem&&0!==this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")):this.currentItem===\nthis.maximumItem?(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0!==this.currentItem&&this.currentItem!==this.maximumItem&&(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")))},updateControls:function(){this.updatePagination();this.checkNavigation();this.owlControls&&(this.options.items>=this.itemsAmount?this.owlControls.hide():this.owlControls.show())},destroyControls:function(){this.owlControls&&this.owlControls.remove()},next:function(a){if(this.isTransition)return!1;\nthis.currentItem+=!0===this.options.scrollPerPage?this.options.items:1;if(this.currentItem>this.maximumItem+(!0===this.options.scrollPerPage?this.options.items-1:0))if(!0===this.options.rewindNav)this.currentItem=0,a=\"rewind\";else return this.currentItem=this.maximumItem,!1;this.goTo(this.currentItem,a)},prev:function(a){if(this.isTransition)return!1;this.currentItem=!0===this.options.scrollPerPage&&0<this.currentItem&&this.currentItem<this.options.items?0:this.currentItem-(!0===this.options.scrollPerPage?\nthis.options.items:1);if(0>this.currentItem)if(!0===this.options.rewindNav)this.currentItem=this.maximumItem,a=\"rewind\";else return this.currentItem=0,!1;this.goTo(this.currentItem,a)},goTo:function(a,b,e){var c=this;if(c.isTransition)return!1;\"function\"===typeof c.options.beforeMove&&c.options.beforeMove.apply(this,[c.$elem]);a>=c.maximumItem?a=c.maximumItem:0>=a&&(a=0);c.currentItem=c.owl.currentItem=a;if(!1!==c.options.transitionStyle&&\"drag\"!==e&&1===c.options.items&&!0===c.browser.support3d)return c.swapSpeed(0),\n!0===c.browser.support3d?c.transition3d(c.positionsInArray[a]):c.css2slide(c.positionsInArray[a],1),c.afterGo(),c.singleItemTransition(),!1;a=c.positionsInArray[a];!0===c.browser.support3d?(c.isCss3Finish=!1,!0===b?(c.swapSpeed(\"paginationSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},c.options.paginationSpeed)):\"rewind\"===b?(c.swapSpeed(c.options.rewindSpeed),g.setTimeout(function(){c.isCss3Finish=!0},c.options.rewindSpeed)):(c.swapSpeed(\"slideSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},\nc.options.slideSpeed)),c.transition3d(a)):!0===b?c.css2slide(a,c.options.paginationSpeed):\"rewind\"===b?c.css2slide(a,c.options.rewindSpeed):c.css2slide(a,c.options.slideSpeed);c.afterGo()},jumpTo:function(a){\"function\"===typeof this.options.beforeMove&&this.options.beforeMove.apply(this,[this.$elem]);a>=this.maximumItem||-1===a?a=this.maximumItem:0>=a&&(a=0);this.swapSpeed(0);!0===this.browser.support3d?this.transition3d(this.positionsInArray[a]):this.css2slide(this.positionsInArray[a],1);this.currentItem=\nthis.owl.currentItem=a;this.afterGo()},afterGo:function(){this.prevArr.push(this.currentItem);this.prevItem=this.owl.prevItem=this.prevArr[this.prevArr.length-2];this.prevArr.shift(0);this.prevItem!==this.currentItem&&(this.checkPagination(),this.checkNavigation(),this.eachMoveUpdate(),!1!==this.options.autoPlay&&this.checkAp());\"function\"===typeof this.options.afterMove&&this.prevItem!==this.currentItem&&this.options.afterMove.apply(this,[this.$elem])},stop:function(){this.apStatus=\"stop\";g.clearInterval(this.autoPlayInterval)},\ncheckAp:function(){\"stop\"!==this.apStatus&&this.play()},play:function(){var a=this;a.apStatus=\"play\";if(!1===a.options.autoPlay)return!1;g.clearInterval(a.autoPlayInterval);a.autoPlayInterval=g.setInterval(function(){a.next(!0)},a.options.autoPlay)},swapSpeed:function(a){\"slideSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.slideSpeed)):\"paginationSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.paginationSpeed)):\"string\"!==typeof a&&this.$owlWrapper.css(this.addCssSpeed(a))},\naddCssSpeed:function(a){return{\"-webkit-transition\":\"all \"+a+\"ms ease\",\"-moz-transition\":\"all \"+a+\"ms ease\",\"-o-transition\":\"all \"+a+\"ms ease\",transition:\"all \"+a+\"ms ease\"}},removeTransition:function(){return{\"-webkit-transition\":\"\",\"-moz-transition\":\"\",\"-o-transition\":\"\",transition:\"\"}},doTranslate:function(a){return{\"-webkit-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-moz-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-o-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-ms-transform\":\"translate3d(\"+\na+\"px, 0px, 0px)\",transform:\"translate3d(\"+a+\"px, 0px,0px)\"}},transition3d:function(a){this.$owlWrapper.css(this.doTranslate(a))},css2move:function(a){this.$owlWrapper.css({left:a})},css2slide:function(a,b){var e=this;e.isCssFinish=!1;e.$owlWrapper.stop(!0,!0).animate({left:a},{duration:b||e.options.slideSpeed,complete:function(){e.isCssFinish=!0}})},checkBrowser:function(){var a=k.createElement(\"div\");a.style.cssText=\"  -moz-transform:translate3d(0px, 0px, 0px); -ms-transform:translate3d(0px, 0px, 0px); -o-transform:translate3d(0px, 0px, 0px); -webkit-transform:translate3d(0px, 0px, 0px); transform:translate3d(0px, 0px, 0px)\";\na=a.style.cssText.match(/translate3d\\(0px, 0px, 0px\\)/g);this.browser={support3d:null!==a&&1===a.length,isTouch:\"ontouchstart\"in g||g.navigator.msMaxTouchPoints}},moveEvents:function(){if(!1!==this.options.mouseDrag||!1!==this.options.touchDrag)this.gestures(),this.disabledEvents()},eventTypes:function(){var a=[\"s\",\"e\",\"x\"];this.ev_types={};!0===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl mousedown.owl\",\"touchmove.owl mousemove.owl\",\"touchend.owl touchcancel.owl mouseup.owl\"]:\n!1===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl\",\"touchmove.owl\",\"touchend.owl touchcancel.owl\"]:!0===this.options.mouseDrag&&!1===this.options.touchDrag&&(a=[\"mousedown.owl\",\"mousemove.owl\",\"mouseup.owl\"]);this.ev_types.start=a[0];this.ev_types.move=a[1];this.ev_types.end=a[2]},disabledEvents:function(){this.$elem.on(\"dragstart.owl\",function(a){a.preventDefault()});this.$elem.on(\"mousedown.disableTextSelect\",function(a){return f(a.target).is(\"input, textarea, select, option\")})},\ngestures:function(){function a(a){if(void 0!==a.touches)return{x:a.touches[0].pageX,y:a.touches[0].pageY};if(void 0===a.touches){if(void 0!==a.pageX)return{x:a.pageX,y:a.pageY};if(void 0===a.pageX)return{x:a.clientX,y:a.clientY}}}function b(a){\"on\"===a?(f(k).on(d.ev_types.move,e),f(k).on(d.ev_types.end,c)):\"off\"===a&&(f(k).off(d.ev_types.move),f(k).off(d.ev_types.end))}function e(b){b=b.originalEvent||b||g.event;d.newPosX=a(b).x-h.offsetX;d.newPosY=a(b).y-h.offsetY;d.newRelativeX=d.newPosX-h.relativePos;\n\"function\"===typeof d.options.startDragging&&!0!==h.dragging&&0!==d.newRelativeX&&(h.dragging=!0,d.options.startDragging.apply(d,[d.$elem]));(8<d.newRelativeX||-8>d.newRelativeX)&&!0===d.browser.isTouch&&(void 0!==b.preventDefault?b.preventDefault():b.returnValue=!1,h.sliding=!0);(10<d.newPosY||-10>d.newPosY)&&!1===h.sliding&&f(k).off(\"touchmove.owl\");d.newPosX=Math.max(Math.min(d.newPosX,d.newRelativeX/5),d.maximumPixels+d.newRelativeX/5);!0===d.browser.support3d?d.transition3d(d.newPosX):d.css2move(d.newPosX)}\nfunction c(a){a=a.originalEvent||a||g.event;var c;a.target=a.target||a.srcElement;h.dragging=!1;!0!==d.browser.isTouch&&d.$owlWrapper.removeClass(\"grabbing\");d.dragDirection=0>d.newRelativeX?d.owl.dragDirection=\"left\":d.owl.dragDirection=\"right\";0!==d.newRelativeX&&(c=d.getNewPosition(),d.goTo(c,!1,\"drag\"),h.targetElement===a.target&&!0!==d.browser.isTouch&&(f(a.target).on(\"click.disable\",function(a){a.stopImmediatePropagation();a.stopPropagation();a.preventDefault();f(a.target).off(\"click.disable\")}),\na=f._data(a.target,\"events\").click,c=a.pop(),a.splice(0,0,c)));b(\"off\")}var d=this,h={offsetX:0,offsetY:0,baseElWidth:0,relativePos:0,position:null,minSwipe:null,maxSwipe:null,sliding:null,dargging:null,targetElement:null};d.isCssFinish=!0;d.$elem.on(d.ev_types.start,\".owl-wrapper\",function(c){c=c.originalEvent||c||g.event;var e;if(3===c.which)return!1;if(!(d.itemsAmount<=d.options.items)){if(!1===d.isCssFinish&&!d.options.dragBeforeAnimFinish||!1===d.isCss3Finish&&!d.options.dragBeforeAnimFinish)return!1;\n!1!==d.options.autoPlay&&g.clearInterval(d.autoPlayInterval);!0===d.browser.isTouch||d.$owlWrapper.hasClass(\"grabbing\")||d.$owlWrapper.addClass(\"grabbing\");d.newPosX=0;d.newRelativeX=0;f(this).css(d.removeTransition());e=f(this).position();h.relativePos=e.left;h.offsetX=a(c).x-e.left;h.offsetY=a(c).y-e.top;b(\"on\");h.sliding=!1;h.targetElement=c.target||c.srcElement}})},getNewPosition:function(){var a=this.closestItem();a>this.maximumItem?a=this.currentItem=this.maximumItem:0<=this.newPosX&&(this.currentItem=\na=0);return a},closestItem:function(){var a=this,b=!0===a.options.scrollPerPage?a.pagesInArray:a.positionsInArray,e=a.newPosX,c=null;f.each(b,function(d,g){e-a.itemWidth/20>b[d+1]&&e-a.itemWidth/20<g&&\"left\"===a.moveDirection()?(c=g,a.currentItem=!0===a.options.scrollPerPage?f.inArray(c,a.positionsInArray):d):e+a.itemWidth/20<g&&e+a.itemWidth/20>(b[d+1]||b[d]-a.itemWidth)&&\"right\"===a.moveDirection()&&(!0===a.options.scrollPerPage?(c=b[d+1]||b[b.length-1],a.currentItem=f.inArray(c,a.positionsInArray)):\n(c=b[d+1],a.currentItem=d+1))});return a.currentItem},moveDirection:function(){var a;0>this.newRelativeX?(a=\"right\",this.playDirection=\"next\"):(a=\"left\",this.playDirection=\"prev\");return a},customEvents:function(){var a=this;a.$elem.on(\"owl.next\",function(){a.next()});a.$elem.on(\"owl.prev\",function(){a.prev()});a.$elem.on(\"owl.play\",function(b,e){a.options.autoPlay=e;a.play();a.hoverStatus=\"play\"});a.$elem.on(\"owl.stop\",function(){a.stop();a.hoverStatus=\"stop\"});a.$elem.on(\"owl.goTo\",function(b,e){a.goTo(e)});\na.$elem.on(\"owl.jumpTo\",function(b,e){a.jumpTo(e)})},stopOnHover:function(){var a=this;!0===a.options.stopOnHover&&!0!==a.browser.isTouch&&!1!==a.options.autoPlay&&(a.$elem.on(\"mouseover\",function(){a.stop()}),a.$elem.on(\"mouseout\",function(){\"stop\"!==a.hoverStatus&&a.play()}))},lazyLoad:function(){var a,b,e,c,d;if(!1===this.options.lazyLoad)return!1;for(a=0;a<this.itemsAmount;a+=1)b=f(this.$owlItems[a]),\"loaded\"!==b.data(\"owl-loaded\")&&(e=b.data(\"owl-item\"),c=b.find(\".lazyOwl\"),\"string\"!==typeof c.data(\"src\")?\nb.data(\"owl-loaded\",\"loaded\"):(void 0===b.data(\"owl-loaded\")&&(c.hide(),b.addClass(\"loading\").data(\"owl-loaded\",\"checked\")),(d=!0===this.options.lazyFollow?e>=this.currentItem:!0)&&e<this.currentItem+this.options.items&&c.length&&this.lazyPreload(b,c)))},lazyPreload:function(a,b){function e(){a.data(\"owl-loaded\",\"loaded\").removeClass(\"loading\");b.removeAttr(\"data-src\");\"fade\"===d.options.lazyEffect?b.fadeIn(400):b.show();\"function\"===typeof d.options.afterLazyLoad&&d.options.afterLazyLoad.apply(this,\n[d.$elem])}function c(){f+=1;d.completeImg(b.get(0))||!0===k?e():100>=f?g.setTimeout(c,100):e()}var d=this,f=0,k;\"DIV\"===b.prop(\"tagName\")?(b.css(\"background-image\",\"url(\"+b.data(\"src\")+\")\"),k=!0):b[0].src=b.data(\"src\");c()},autoHeight:function(){function a(){var a=f(e.$owlItems[e.currentItem]).height();e.wrapperOuter.css(\"height\",a+\"px\");e.wrapperOuter.hasClass(\"autoHeight\")||g.setTimeout(function(){e.wrapperOuter.addClass(\"autoHeight\")},0)}function b(){d+=1;e.completeImg(c.get(0))?a():100>=d?g.setTimeout(b,\n100):e.wrapperOuter.css(\"height\",\"\")}var e=this,c=f(e.$owlItems[e.currentItem]).find(\"img\"),d;void 0!==c.get(0)?(d=0,b()):a()},completeImg:function(a){return!a.complete||\"undefined\"!==typeof a.naturalWidth&&0===a.naturalWidth?!1:!0},onVisibleItems:function(){var a;!0===this.options.addClassActive&&this.$owlItems.removeClass(\"active\");this.visibleItems=[];for(a=this.currentItem;a<this.currentItem+this.options.items;a+=1)this.visibleItems.push(a),!0===this.options.addClassActive&&f(this.$owlItems[a]).addClass(\"active\");\nthis.owl.visibleItems=this.visibleItems},transitionTypes:function(a){this.outClass=\"owl-\"+a+\"-out\";this.inClass=\"owl-\"+a+\"-in\"},singleItemTransition:function(){var a=this,b=a.outClass,e=a.inClass,c=a.$owlItems.eq(a.currentItem),d=a.$owlItems.eq(a.prevItem),f=Math.abs(a.positionsInArray[a.currentItem])+a.positionsInArray[a.prevItem],g=Math.abs(a.positionsInArray[a.currentItem])+a.itemWidth/2;a.isTransition=!0;a.$owlWrapper.addClass(\"owl-origin\").css({\"-webkit-transform-origin\":g+\"px\",\"-moz-perspective-origin\":g+\n\"px\",\"perspective-origin\":g+\"px\"});d.css({position:\"relative\",left:f+\"px\"}).addClass(b).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endPrev=!0;d.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(d,b)});c.addClass(e).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endCurrent=!0;c.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(c,e)})},clearTransStyle:function(a,\nb){a.css({position:\"\",left:\"\"}).removeClass(b);this.endPrev&&this.endCurrent&&(this.$owlWrapper.removeClass(\"owl-origin\"),this.isTransition=this.endCurrent=this.endPrev=!1)},owlStatus:function(){this.owl={userOptions:this.userOptions,baseElement:this.$elem,userItems:this.$userItems,owlItems:this.$owlItems,currentItem:this.currentItem,prevItem:this.prevItem,visibleItems:this.visibleItems,isTouch:this.browser.isTouch,browser:this.browser,dragDirection:this.dragDirection}},clearEvents:function(){this.$elem.off(\".owl owl mousedown.disableTextSelect\");\nf(k).off(\".owl owl\");f(g).off(\"resize\",this.resizer)},unWrap:function(){0!==this.$elem.children().length&&(this.$owlWrapper.unwrap(),this.$userItems.unwrap().unwrap(),this.owlControls&&this.owlControls.remove());this.clearEvents();this.$elem.attr(\"style\",this.$elem.data(\"owl-originalStyles\")||\"\").attr(\"class\",this.$elem.data(\"owl-originalClasses\"))},destroy:function(){this.stop();g.clearInterval(this.checkVisible);this.unWrap();this.$elem.removeData()},reinit:function(a){a=f.extend({},this.userOptions,\na);this.unWrap();this.init(a,this.$elem)},addItem:function(a,b){var e;if(!a)return!1;if(0===this.$elem.children().length)return this.$elem.append(a),this.setVars(),!1;this.unWrap();e=void 0===b||-1===b?-1:b;e>=this.$userItems.length||-1===e?this.$userItems.eq(-1).after(a):this.$userItems.eq(e).before(a);this.setVars()},removeItem:function(a){if(0===this.$elem.children().length)return!1;a=void 0===a||-1===a?-1:a;this.unWrap();this.$userItems.eq(a).remove();this.setVars()}};f.fn.owlCarousel=function(a){return this.each(function(){if(!0===\nf(this).data(\"owl-init\"))return!1;f(this).data(\"owl-init\",!0);var b=Object.create(l);b.init(a,this);f.data(this,\"owlCarousel\",b)})};f.fn.owlCarousel.options={items:5,itemsCustom:!1,itemsDesktop:[1199,4],itemsDesktopSmall:[979,3],itemsTablet:[768,2],itemsTabletSmall:!1,itemsMobile:[479,1],singleItem:!1,itemsScaleUp:!1,slideSpeed:200,paginationSpeed:800,rewindSpeed:1E3,autoPlay:!1,stopOnHover:!1,navigation:!1,navigationText:[\"prev\",\"next\"],rewindNav:!0,scrollPerPage:!1,pagination:!0,paginationNumbers:!1,\nresponsive:!0,responsiveRefreshRate:200,responsiveBaseWidth:g,baseClass:\"owl-carousel\",theme:\"owl-theme\",lazyLoad:!1,lazyFollow:!0,lazyEffect:\"fade\",autoHeight:!1,jsonPath:!1,jsonSuccess:!1,dragBeforeAnimFinish:!0,mouseDrag:!0,touchDrag:!0,addClassActive:!1,transitionStyle:!1,beforeUpdate:!1,afterUpdate:!1,beforeInit:!1,afterInit:!1,beforeMove:!1,afterMove:!1,afterAction:!1,startDragging:!1,afterLazyLoad:!1}})(jQuery,window,document);\n});","Plazathemes_InstagramGallery/plazathemes/instagramgallery/js/jquery.fancybox.js":"/*!\n * fancyBox - jQuery Plugin\n * version: 2.1.5 (Fri, 14 Jun 2013)\n * requires jQuery v1.6 or later\n *\n * Examples at http://fancyapps.com/fancybox/\n * License: www.fancyapps.com/fancybox/#license\n *\n * Copyright 2012 Janis Skarnelis - janis@fancyapps.com\n *\n */\nrequire([\"jquery\"], function($){\n\t(function (window, document, $, undefined) {\n\t\t\"use strict\";\n\n\t\tvar H = $(\"html\"),\n\t\t\tW = $(window),\n\t\t\tD = $(document),\n\t\t\tF = $.fancybox = function () {\n\t\t\t\tF.open.apply( this, arguments );\n\t\t\t},\n\t\t\tIE =  navigator.userAgent.match(/msie/i),\n\t\t\tdidUpdate\t= null,\n\t\t\tisTouch\t\t= document.createTouch !== undefined,\n\n\t\t\tisQuery\t= function(obj) {\n\t\t\t\treturn obj && obj.hasOwnProperty && obj instanceof $;\n\t\t\t},\n\t\t\tisString = function(str) {\n\t\t\t\treturn str && $.type(str) === \"string\";\n\t\t\t},\n\t\t\tisPercentage = function(str) {\n\t\t\t\treturn isString(str) && str.indexOf('%') > 0;\n\t\t\t},\n\t\t\tisScrollable = function(el) {\n\t\t\t\treturn (el && !(el.style.overflow && el.style.overflow === 'hidden') && ((el.clientWidth && el.scrollWidth > el.clientWidth) || (el.clientHeight && el.scrollHeight > el.clientHeight)));\n\t\t\t},\n\t\t\tgetScalar = function(orig, dim) {\n\t\t\t\tvar value = parseInt(orig, 10) || 0;\n\n\t\t\t\tif (dim && isPercentage(orig)) {\n\t\t\t\t\tvalue = F.getViewport()[ dim ] / 100 * value;\n\t\t\t\t}\n\n\t\t\t\treturn Math.ceil(value);\n\t\t\t},\n\t\t\tgetValue = function(value, dim) {\n\t\t\t\treturn getScalar(value, dim) + 'px';\n\t\t\t};\n\n\t\t$.extend(F, {\n\t\t\t// The current version of fancyBox\n\t\t\tversion: '2.1.5',\n\n\t\t\tdefaults: {\n\t\t\t\tpadding : 15,\n\t\t\t\tmargin  : 20,\n\n\t\t\t\twidth     : 800,\n\t\t\t\theight    : 600,\n\t\t\t\tminWidth  : 100,\n\t\t\t\tminHeight : 100,\n\t\t\t\tmaxWidth  : 9999,\n\t\t\t\tmaxHeight : 9999,\n\t\t\t\tpixelRatio: 1, // Set to 2 for retina display support\n\n\t\t\t\tautoSize   : true,\n\t\t\t\tautoHeight : false,\n\t\t\t\tautoWidth  : false,\n\n\t\t\t\tautoResize  : true,\n\t\t\t\tautoCenter  : !isTouch,\n\t\t\t\tfitToView   : true,\n\t\t\t\taspectRatio : false,\n\t\t\t\ttopRatio    : 0.5,\n\t\t\t\tleftRatio   : 0.5,\n\n\t\t\t\tscrolling : 'auto', // 'auto', 'yes' or 'no'\n\t\t\t\twrapCSS   : '',\n\n\t\t\t\tarrows     : true,\n\t\t\t\tcloseBtn   : true,\n\t\t\t\tcloseClick : false,\n\t\t\t\tnextClick  : false,\n\t\t\t\tmouseWheel : true,\n\t\t\t\tautoPlay   : false,\n\t\t\t\tplaySpeed  : 3000,\n\t\t\t\tpreload    : 3,\n\t\t\t\tmodal      : false,\n\t\t\t\tloop       : true,\n\n\t\t\t\tajax  : {\n\t\t\t\t\tdataType : 'html',\n\t\t\t\t\theaders  : { 'X-fancyBox': true }\n\t\t\t\t},\n\t\t\t\tiframe : {\n\t\t\t\t\tscrolling : 'auto',\n\t\t\t\t\tpreload   : true\n\t\t\t\t},\n\t\t\t\tswf : {\n\t\t\t\t\twmode: 'transparent',\n\t\t\t\t\tallowfullscreen   : 'true',\n\t\t\t\t\tallowscriptaccess : 'always'\n\t\t\t\t},\n\n\t\t\t\tkeys  : {\n\t\t\t\t\tnext : {\n\t\t\t\t\t\t13 : 'left', // enter\n\t\t\t\t\t\t34 : 'up',   // page down\n\t\t\t\t\t\t39 : 'left', // right arrow\n\t\t\t\t\t\t40 : 'up'    // down arrow\n\t\t\t\t\t},\n\t\t\t\t\tprev : {\n\t\t\t\t\t\t8  : 'right',  // backspace\n\t\t\t\t\t\t33 : 'down',   // page up\n\t\t\t\t\t\t37 : 'right',  // left arrow\n\t\t\t\t\t\t38 : 'down'    // up arrow\n\t\t\t\t\t},\n\t\t\t\t\tclose  : [27], // escape key\n\t\t\t\t\tplay   : [32], // space - start/stop slideshow\n\t\t\t\t\ttoggle : [70]  // letter \"f\" - toggle fullscreen\n\t\t\t\t},\n\n\t\t\t\tdirection : {\n\t\t\t\t\tnext : 'left',\n\t\t\t\t\tprev : 'right'\n\t\t\t\t},\n\n\t\t\t\tscrollOutside  : true,\n\n\t\t\t\t// Override some properties\n\t\t\t\tindex   : 0,\n\t\t\t\ttype    : null,\n\t\t\t\thref    : null,\n\t\t\t\tdata_href : null,\n\t\t\t\tdata_target : null,\n\t\t\t\tcontent : null,\n\t\t\t\ttitle   : null,\n\n\t\t\t\t// HTML templates\n\t\t\t\ttpl: {\n\t\t\t\t\twrap     : '<div class=\"fancybox-wrap\" tabIndex=\"-1\"><div class=\"fancybox-skin\"><div class=\"fancybox-outer\"><div class=\"fancybox-inner\"></div></div></div></div>',\n\t\t\t\t\timage    : '<a href=\"{data_href}\" target=\"{data_target}\"><img class=\"fancybox-image\" src=\"{href}\" alt=\"\" /></a>',\n\t\t\t\t\tiframe   : '<iframe id=\"fancybox-frame{rnd}\" name=\"fancybox-frame{rnd}\" class=\"fancybox-iframe\" frameborder=\"0\" vspace=\"0\" hspace=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen' + (IE ? ' allowtransparency=\"true\"' : '') + '></iframe>',\n\t\t\t\t\terror    : '<p class=\"fancybox-error\">The requested content cannot be loaded.<br/>Please try again later.</p>',\n\t\t\t\t\tcloseBtn : '<a title=\"Close\" class=\"fancybox-item fancybox-close\" href=\"javascript:;\"></a>',\n\t\t\t\t\tnext     : '<a title=\"Next\" class=\"fancybox-nav fancybox-next\" href=\"javascript:;\"><span></span></a>',\n\t\t\t\t\tprev     : '<a title=\"Previous\" class=\"fancybox-nav fancybox-prev\" href=\"javascript:;\"><span></span></a>',\n\t\t\t\t\tloading  : '<div id=\"fancybox-loading\"><div></div></div>'\n\t\t\t\t},\n\n\t\t\t\t// Properties for each animation type\n\t\t\t\t// Opening fancyBox\n\t\t\t\topenEffect  : 'fade', // 'elastic', 'fade' or 'none'\n\t\t\t\topenSpeed   : 250,\n\t\t\t\topenEasing  : 'swing',\n\t\t\t\topenOpacity : true,\n\t\t\t\topenMethod  : 'zoomIn',\n\n\t\t\t\t// Closing fancyBox\n\t\t\t\tcloseEffect  : 'fade', // 'elastic', 'fade' or 'none'\n\t\t\t\tcloseSpeed   : 250,\n\t\t\t\tcloseEasing  : 'swing',\n\t\t\t\tcloseOpacity : true,\n\t\t\t\tcloseMethod  : 'zoomOut',\n\n\t\t\t\t// Changing next gallery item\n\t\t\t\tnextEffect : 'elastic', // 'elastic', 'fade' or 'none'\n\t\t\t\tnextSpeed  : 250,\n\t\t\t\tnextEasing : 'swing',\n\t\t\t\tnextMethod : 'changeIn',\n\n\t\t\t\t// Changing previous gallery item\n\t\t\t\tprevEffect : 'elastic', // 'elastic', 'fade' or 'none'\n\t\t\t\tprevSpeed  : 250,\n\t\t\t\tprevEasing : 'swing',\n\t\t\t\tprevMethod : 'changeOut',\n\n\t\t\t\t// Enable default helpers\n\t\t\t\thelpers : {\n\t\t\t\t\toverlay : true,\n\t\t\t\t\ttitle   : true\n\t\t\t\t},\n\n\t\t\t\t// Callbacks\n\t\t\t\tonCancel     : $.noop, // If canceling\n\t\t\t\tbeforeLoad   : $.noop, // Before loading\n\t\t\t\tafterLoad    : $.noop, // After loading\n\t\t\t\tbeforeShow   : $.noop, // Before changing in current item\n\t\t\t\tafterShow    : $.noop, // After opening\n\t\t\t\tbeforeChange : $.noop, // Before changing gallery item\n\t\t\t\tbeforeClose  : $.noop, // Before closing\n\t\t\t\tafterClose   : $.noop  // After closing\n\t\t\t},\n\n\t\t\t//Current state\n\t\t\tgroup    : {}, // Selected group\n\t\t\topts     : {}, // Group options\n\t\t\tprevious : null,  // Previous element\n\t\t\tcoming   : null,  // Element being loaded\n\t\t\tcurrent  : null,  // Currently loaded element\n\t\t\tisActive : false, // Is activated\n\t\t\tisOpen   : false, // Is currently open\n\t\t\tisOpened : false, // Have been fully opened at least once\n\n\t\t\twrap  : null,\n\t\t\tskin  : null,\n\t\t\touter : null,\n\t\t\tinner : null,\n\n\t\t\tplayer : {\n\t\t\t\ttimer    : null,\n\t\t\t\tisActive : false\n\t\t\t},\n\n\t\t\t// Loaders\n\t\t\tajaxLoad   : null,\n\t\t\timgPreload : null,\n\n\t\t\t// Some collections\n\t\t\ttransitions : {},\n\t\t\thelpers     : {},\n\n\t\t\t/*\n\t\t\t *\tStatic methods\n\t\t\t */\n\n\t\t\topen: function (group, opts) {\n\t\t\t\tif (!group) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (!$.isPlainObject(opts)) {\n\t\t\t\t\topts = {};\n\t\t\t\t}\n\n\t\t\t\t// Close if already active\n\t\t\t\tif (false === F.close(true)) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Normalize group\n\t\t\t\tif (!$.isArray(group)) {\n\t\t\t\t\tgroup = isQuery(group) ? $(group).get() : [group];\n\t\t\t\t}\n\n\t\t\t\t// Recheck if the type of each element is `object` and set content type (image, ajax, etc)\n\t\t\t\t$.each(group, function(i, element) {\n\t\t\t\t\tvar obj = {},\n\t\t\t\t\t\thref,\n\t\t\t\t\t\tdata_href,\n\t\t\t\t\t\tdata_target,\n\t\t\t\t\t\ttitle,\n\t\t\t\t\t\tcontent,\n\t\t\t\t\t\ttype,\n\t\t\t\t\t\trez,\n\t\t\t\t\t\threfParts,\n\t\t\t\t\t\tselector;\n\n\t\t\t\t\tif ($.type(element) === \"object\") {\n\t\t\t\t\t\t// Check if is DOM element\n\t\t\t\t\t\tif (element.nodeType) {\n\t\t\t\t\t\t\telement = $(element);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isQuery(element)) {\n\t\t\t\t\t\t\tobj = {\n\t\t\t\t\t\t\t\thref    : element.data('fancybox-href') || element.attr('href'),\n\t\t\t\t\t\t\t\tdata_href : element.attr('data-href'),\n\t\t\t\t\t\t\t\tdata_target : element.attr('data-target'),\n\t\t\t\t\t\t\t\ttitle   : $('<div/>').text( element.data('fancybox-title') || element.attr('title') || '' ).html(),\n\t\t\t\t\t\t\t\tisDom   : true,\n\t\t\t\t\t\t\t\telement : element\n\t\t\t\t\t\t\t};\n\n\t\t\t\t\t\t\tif ($.metadata) {\n\t\t\t\t\t\t\t\t$.extend(true, obj, element.metadata());\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tobj = element;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\thref  = opts.href  || obj.href || (isString(element) ? element : null);\n\t\t\t\t\tdata_href = opts.data_href  || obj.data_href || (isString(element) ? element : null);\n\t\t\t\t\tdata_target = opts.data_target  || obj.data_target || (isString(element) ? element : null);\n\t\t\t\t\ttitle = opts.title !== undefined ? opts.title : obj.title || '';\n\n\t\t\t\t\tcontent = opts.content || obj.content;\n\t\t\t\t\ttype    = content ? 'html' : (opts.type  || obj.type);\n\n\t\t\t\t\tif (!type && obj.isDom) {\n\t\t\t\t\t\ttype = element.data('fancybox-type');\n\n\t\t\t\t\t\tif (!type) {\n\t\t\t\t\t\t\trez  = element.prop('class').match(/fancybox\\.(\\w+)/);\n\t\t\t\t\t\t\ttype = rez ? rez[1] : null;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (isString(href)) {\n\t\t\t\t\t\t// Try to guess the content type\n\t\t\t\t\t\tif (!type) {\n\t\t\t\t\t\t\tif (F.isImage(href)) {\n\t\t\t\t\t\t\t\ttype = 'image';\n\n\t\t\t\t\t\t\t} else if (F.isSWF(href)) {\n\t\t\t\t\t\t\t\ttype = 'swf';\n\n\t\t\t\t\t\t\t} else if (href.charAt(0) === '#') {\n\t\t\t\t\t\t\t\ttype = 'inline';\n\n\t\t\t\t\t\t\t} else if (isString(element)) {\n\t\t\t\t\t\t\t\ttype    = 'html';\n\t\t\t\t\t\t\t\tcontent = element;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Split url into two pieces with source url and content selector, e.g,\n\t\t\t\t\t\t// \"/mypage.html #my_id\" will load \"/mypage.html\" and display element having id \"my_id\"\n\t\t\t\t\t\tif (type === 'ajax') {\n\t\t\t\t\t\t\threfParts = href.split(/\\s+/, 2);\n\t\t\t\t\t\t\thref      = hrefParts.shift();\n\t\t\t\t\t\t\tselector  = hrefParts.shift();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!content) {\n\t\t\t\t\t\tif (type === 'inline') {\n\t\t\t\t\t\t\tif (href) {\n\t\t\t\t\t\t\t\tcontent = $( isString(href) ? href.replace(/.*(?=#[^\\s]+$)/, '') : href ); //strip for ie7\n\n\t\t\t\t\t\t\t} else if (obj.isDom) {\n\t\t\t\t\t\t\t\tcontent = element;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else if (type === 'html') {\n\t\t\t\t\t\t\tcontent = href;\n\n\t\t\t\t\t\t} else if (!type && !href && obj.isDom) {\n\t\t\t\t\t\t\ttype    = 'inline';\n\t\t\t\t\t\t\tcontent = element;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t$.extend(obj, {\n\t\t\t\t\t\thref     : href,\n\t\t\t\t\t\tdata_href : data_href,\n\t\t\t\t\t\tdata_target : data_target,\n\t\t\t\t\t\ttype     : type,\n\t\t\t\t\t\tcontent  : content,\n\t\t\t\t\t\ttitle    : title,\n\t\t\t\t\t\tselector : selector\n\t\t\t\t\t});\n\n\t\t\t\t\tgroup[ i ] = obj;\n\t\t\t\t});\n\n\t\t\t\t// Extend the defaults\n\t\t\t\tF.opts = $.extend(true, {}, F.defaults, opts);\n\n\t\t\t\t// All options are merged recursive except keys\n\t\t\t\tif (opts.keys !== undefined) {\n\t\t\t\t\tF.opts.keys = opts.keys ? $.extend({}, F.defaults.keys, opts.keys) : false;\n\t\t\t\t}\n\n\t\t\t\tF.group = group;\n\n\t\t\t\treturn F._start(F.opts.index);\n\t\t\t},\n\n\t\t\t// Cancel image loading or abort ajax request\n\t\t\tcancel: function () {\n\t\t\t\tvar coming = F.coming;\n\n\t\t\t\tif (coming && false === F.trigger('onCancel')) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tF.hideLoading();\n\n\t\t\t\tif (!coming) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (F.ajaxLoad) {\n\t\t\t\t\tF.ajaxLoad.abort();\n\t\t\t\t}\n\n\t\t\t\tF.ajaxLoad = null;\n\n\t\t\t\tif (F.imgPreload) {\n\t\t\t\t\tF.imgPreload.onload = F.imgPreload.onerror = null;\n\t\t\t\t}\n\n\t\t\t\tif (coming.wrap) {\n\t\t\t\t\tcoming.wrap.stop(true, true).trigger('onReset').remove();\n\t\t\t\t}\n\n\t\t\t\tF.coming = null;\n\n\t\t\t\t// If the first item has been canceled, then clear everything\n\t\t\t\tif (!F.current) {\n\t\t\t\t\tF._afterZoomOut( coming );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Start closing animation if is open; remove immediately if opening/closing\n\t\t\tclose: function (event) {\n\t\t\t\tF.cancel();\n\n\t\t\t\tif (false === F.trigger('beforeClose')) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tF.unbindEvents();\n\n\t\t\t\tif (!F.isActive) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (!F.isOpen || event === true) {\n\t\t\t\t\t$('.fancybox-wrap').stop(true).trigger('onReset').remove();\n\n\t\t\t\t\tF._afterZoomOut();\n\n\t\t\t\t} else {\n\t\t\t\t\tF.isOpen = F.isOpened = false;\n\t\t\t\t\tF.isClosing = true;\n\n\t\t\t\t\t$('.fancybox-item, .fancybox-nav').remove();\n\n\t\t\t\t\tF.wrap.stop(true, true).removeClass('fancybox-opened');\n\n\t\t\t\t\tF.transitions[ F.current.closeMethod ]();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Manage slideshow:\n\t\t\t//   $.fancybox.play(); - toggle slideshow\n\t\t\t//   $.fancybox.play( true ); - start\n\t\t\t//   $.fancybox.play( false ); - stop\n\t\t\tplay: function ( action ) {\n\t\t\t\tvar clear = function () {\n\t\t\t\t\t\tclearTimeout(F.player.timer);\n\t\t\t\t\t},\n\t\t\t\t\tset = function () {\n\t\t\t\t\t\tclear();\n\n\t\t\t\t\t\tif (F.current && F.player.isActive) {\n\t\t\t\t\t\t\tF.player.timer = setTimeout(F.next, F.current.playSpeed);\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\t\t\t\t\tstop = function () {\n\t\t\t\t\t\tclear();\n\n\t\t\t\t\t\tD.unbind('.player');\n\n\t\t\t\t\t\tF.player.isActive = false;\n\n\t\t\t\t\t\tF.trigger('onPlayEnd');\n\t\t\t\t\t},\n\t\t\t\t\tstart = function () {\n\t\t\t\t\t\tif (F.current && (F.current.loop || F.current.index < F.group.length - 1)) {\n\t\t\t\t\t\t\tF.player.isActive = true;\n\n\t\t\t\t\t\t\tD.bind({\n\t\t\t\t\t\t\t\t'onCancel.player beforeClose.player' : stop,\n\t\t\t\t\t\t\t\t'onUpdate.player'   : set,\n\t\t\t\t\t\t\t\t'beforeLoad.player' : clear\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\tset();\n\n\t\t\t\t\t\t\tF.trigger('onPlayStart');\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\tif (action === true || (!F.player.isActive && action !== false)) {\n\t\t\t\t\tstart();\n\t\t\t\t} else {\n\t\t\t\t\tstop();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Navigate to next gallery item\n\t\t\tnext: function ( direction ) {\n\t\t\t\tvar current = F.current;\n\n\t\t\t\tif (current) {\n\t\t\t\t\tif (!isString(direction)) {\n\t\t\t\t\t\tdirection = current.direction.next;\n\t\t\t\t\t}\n\n\t\t\t\t\tF.jumpto(current.index + 1, direction, 'next');\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Navigate to previous gallery item\n\t\t\tprev: function ( direction ) {\n\t\t\t\tvar current = F.current;\n\n\t\t\t\tif (current) {\n\t\t\t\t\tif (!isString(direction)) {\n\t\t\t\t\t\tdirection = current.direction.prev;\n\t\t\t\t\t}\n\n\t\t\t\t\tF.jumpto(current.index - 1, direction, 'prev');\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Navigate to gallery item by index\n\t\t\tjumpto: function ( index, direction, router ) {\n\t\t\t\tvar current = F.current;\n\n\t\t\t\tif (!current) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tindex = getScalar(index);\n\n\t\t\t\tF.direction = direction || current.direction[ (index >= current.index ? 'next' : 'prev') ];\n\t\t\t\tF.router    = router || 'jumpto';\n\n\t\t\t\tif (current.loop) {\n\t\t\t\t\tif (index < 0) {\n\t\t\t\t\t\tindex = current.group.length + (index % current.group.length);\n\t\t\t\t\t}\n\n\t\t\t\t\tindex = index % current.group.length;\n\t\t\t\t}\n\n\t\t\t\tif (current.group[ index ] !== undefined) {\n\t\t\t\t\tF.cancel();\n\n\t\t\t\t\tF._start(index);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Center inside viewport and toggle position type to fixed or absolute if needed\n\t\t\treposition: function (e, onlyAbsolute) {\n\t\t\t\tvar current = F.current,\n\t\t\t\t\twrap    = current ? current.wrap : null,\n\t\t\t\t\tpos;\n\n\t\t\t\tif (wrap) {\n\t\t\t\t\tpos = F._getPosition(onlyAbsolute);\n\n\t\t\t\t\tif (e && e.type === 'scroll') {\n\t\t\t\t\t\tdelete pos.position;\n\n\t\t\t\t\t\twrap.stop(true, true).animate(pos, 200);\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\twrap.css(pos);\n\n\t\t\t\t\t\tcurrent.pos = $.extend({}, current.dim, pos);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdate: function (e) {\n\t\t\t\tvar type = (e && e.originalEvent && e.originalEvent.type),\n\t\t\t\t\tanyway = !type || type === 'orientationchange';\n\n\t\t\t\tif (anyway) {\n\t\t\t\t\tclearTimeout(didUpdate);\n\n\t\t\t\t\tdidUpdate = null;\n\t\t\t\t}\n\n\t\t\t\tif (!F.isOpen || didUpdate) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tdidUpdate = setTimeout(function() {\n\t\t\t\t\tvar current = F.current;\n\n\t\t\t\t\tif (!current || F.isClosing) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tF.wrap.removeClass('fancybox-tmp');\n\n\t\t\t\t\tif (anyway || type === 'load' || (type === 'resize' && current.autoResize)) {\n\t\t\t\t\t\tF._setDimension();\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!(type === 'scroll' && current.canShrink)) {\n\t\t\t\t\t\tF.reposition(e);\n\t\t\t\t\t}\n\n\t\t\t\t\tF.trigger('onUpdate');\n\n\t\t\t\t\tdidUpdate = null;\n\n\t\t\t\t}, (anyway && !isTouch ? 0 : 300));\n\t\t\t},\n\n\t\t\t// Shrink content to fit inside viewport or restore if resized\n\t\t\ttoggle: function ( action ) {\n\t\t\t\tif (F.isOpen) {\n\t\t\t\t\tF.current.fitToView = $.type(action) === \"boolean\" ? action : !F.current.fitToView;\n\n\t\t\t\t\t// Help browser to restore document dimensions\n\t\t\t\t\tif (isTouch) {\n\t\t\t\t\t\tF.wrap.removeAttr('style').addClass('fancybox-tmp');\n\n\t\t\t\t\t\tF.trigger('onUpdate');\n\t\t\t\t\t}\n\n\t\t\t\t\tF.update();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\thideLoading: function () {\n\t\t\t\tD.unbind('.loading');\n\n\t\t\t\t$('#fancybox-loading').remove();\n\t\t\t},\n\n\t\t\tshowLoading: function () {\n\t\t\t\tvar el, viewport;\n\n\t\t\t\tF.hideLoading();\n\n\t\t\t\tel = $(F.opts.tpl.loading).click(F.cancel).appendTo('body');\n\n\t\t\t\t// If user will press the escape-button, the request will be canceled\n\t\t\t\tD.bind('keydown.loading', function(e) {\n\t\t\t\t\tif ((e.which || e.keyCode) === 27) {\n\t\t\t\t\t\te.preventDefault();\n\n\t\t\t\t\t\tF.cancel();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (!F.defaults.fixed) {\n\t\t\t\t\tviewport = F.getViewport();\n\n\t\t\t\t\tel.css({\n\t\t\t\t\t\tposition : 'absolute',\n\t\t\t\t\t\ttop  : (viewport.h * 0.5) + viewport.y,\n\t\t\t\t\t\tleft : (viewport.w * 0.5) + viewport.x\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tF.trigger('onLoading');\n\t\t\t},\n\n\t\t\tgetViewport: function () {\n\t\t\t\tvar locked = (F.current && F.current.locked) || false,\n\t\t\t\t\trez    = {\n\t\t\t\t\t\tx: W.scrollLeft(),\n\t\t\t\t\t\ty: W.scrollTop()\n\t\t\t\t\t};\n\n\t\t\t\tif (locked && locked.length) {\n\t\t\t\t\trez.w = locked[0].clientWidth;\n\t\t\t\t\trez.h = locked[0].clientHeight;\n\n\t\t\t\t} else {\n\t\t\t\t\t// See http://bugs.jquery.com/ticket/6724\n\t\t\t\t\trez.w = isTouch && window.innerWidth  ? window.innerWidth  : W.width();\n\t\t\t\t\trez.h = isTouch && window.innerHeight ? window.innerHeight : W.height();\n\t\t\t\t}\n\n\t\t\t\treturn rez;\n\t\t\t},\n\n\t\t\t// Unbind the keyboard / clicking actions\n\t\t\tunbindEvents: function () {\n\t\t\t\tif (F.wrap && isQuery(F.wrap)) {\n\t\t\t\t\tF.wrap.unbind('.fb');\n\t\t\t\t}\n\n\t\t\t\tD.unbind('.fb');\n\t\t\t\tW.unbind('.fb');\n\t\t\t},\n\n\t\t\tbindEvents: function () {\n\t\t\t\tvar current = F.current,\n\t\t\t\t\tkeys;\n\n\t\t\t\tif (!current) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Changing document height on iOS devices triggers a 'resize' event,\n\t\t\t\t// that can change document height... repeating infinitely\n\t\t\t\tW.bind('orientationchange.fb' + (isTouch ? '' : ' resize.fb') + (current.autoCenter && !current.locked ? ' scroll.fb' : ''), F.update);\n\n\t\t\t\tkeys = current.keys;\n\n\t\t\t\tif (keys) {\n\t\t\t\t\tD.bind('keydown.fb', function (e) {\n\t\t\t\t\t\tvar code   = e.which || e.keyCode,\n\t\t\t\t\t\t\ttarget = e.target || e.srcElement;\n\n\t\t\t\t\t\t// Skip esc key if loading, because showLoading will cancel preloading\n\t\t\t\t\t\tif (code === 27 && F.coming) {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Ignore key combinations and key events within form elements\n\t\t\t\t\t\tif (!e.ctrlKey && !e.altKey && !e.shiftKey && !e.metaKey && !(target && (target.type || $(target).is('[contenteditable]')))) {\n\t\t\t\t\t\t\t$.each(keys, function(i, val) {\n\t\t\t\t\t\t\t\tif (current.group.length > 1 && val[ code ] !== undefined) {\n\t\t\t\t\t\t\t\t\tF[ i ]( val[ code ] );\n\n\t\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tif ($.inArray(code, val) > -1) {\n\t\t\t\t\t\t\t\t\tF[ i ] ();\n\n\t\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif ($.fn.mousewheel && current.mouseWheel) {\n\t\t\t\t\tF.wrap.bind('mousewheel.fb', function (e, delta, deltaX, deltaY) {\n\t\t\t\t\t\tvar target = e.target || null,\n\t\t\t\t\t\t\tparent = $(target),\n\t\t\t\t\t\t\tcanScroll = false;\n\n\t\t\t\t\t\twhile (parent.length) {\n\t\t\t\t\t\t\tif (canScroll || parent.is('.fancybox-skin') || parent.is('.fancybox-wrap')) {\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tcanScroll = isScrollable( parent[0] );\n\t\t\t\t\t\t\tparent    = $(parent).parent();\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (delta !== 0 && !canScroll) {\n\t\t\t\t\t\t\tif (F.group.length > 1 && !current.canShrink) {\n\t\t\t\t\t\t\t\tif (deltaY > 0 || deltaX > 0) {\n\t\t\t\t\t\t\t\t\tF.prev( deltaY > 0 ? 'down' : 'left' );\n\n\t\t\t\t\t\t\t\t} else if (deltaY < 0 || deltaX < 0) {\n\t\t\t\t\t\t\t\t\tF.next( deltaY < 0 ? 'up' : 'right' );\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\ttrigger: function (event, o) {\n\t\t\t\tvar ret, obj = o || F.coming || F.current;\n\n\t\t\t\tif (obj) {\n\t\t\t\t\tif ($.isFunction( obj[event] )) {\n\t\t\t\t\t\tret = obj[event].apply(obj, Array.prototype.slice.call(arguments, 1));\n\t\t\t\t\t}\n\n\t\t\t\t\tif (ret === false) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (obj.helpers) {\n\t\t\t\t\t\t$.each(obj.helpers, function (helper, opts) {\n\t\t\t\t\t\t\tif (opts && F.helpers[helper] && $.isFunction(F.helpers[helper][event])) {\n\t\t\t\t\t\t\t\tF.helpers[helper][event]($.extend(true, {}, F.helpers[helper].defaults, opts), obj);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tD.trigger(event);\n\t\t\t},\n\n\t\t\tisImage: function (str) {\n\t\t\t\treturn isString(str) && str.match(/(^data:image\\/.*,)|(\\.(jp(e|g|eg)|gif|png|bmp|webp|svg)((\\?|#).*)?$)/i);\n\t\t\t},\n\n\t\t\tisSWF: function (str) {\n\t\t\t\treturn isString(str) && str.match(/\\.(swf)((\\?|#).*)?$/i);\n\t\t\t},\n\n\t\t\t_start: function (index) {\n\t\t\t\tvar coming = {},\n\t\t\t\t\tobj,\n\t\t\t\t\thref,\n\t\t\t\t\tdata_href,\n\t\t\t\t\tdata_target,\n\t\t\t\t\ttype,\n\t\t\t\t\tmargin,\n\t\t\t\t\tpadding;\n\n\t\t\t\tindex = getScalar( index );\n\t\t\t\tobj   = F.group[ index ] || null;\n\n\t\t\t\tif (!obj) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tcoming = $.extend(true, {}, F.opts, obj);\n\n\t\t\t\t// Convert margin and padding properties to array - top, right, bottom, left\n\t\t\t\tmargin  = coming.margin;\n\t\t\t\tpadding = coming.padding;\n\n\t\t\t\tif ($.type(margin) === 'number') {\n\t\t\t\t\tcoming.margin = [margin, margin, margin, margin];\n\t\t\t\t}\n\n\t\t\t\tif ($.type(padding) === 'number') {\n\t\t\t\t\tcoming.padding = [padding, padding, padding, padding];\n\t\t\t\t}\n\n\t\t\t\t// 'modal' propery is just a shortcut\n\t\t\t\tif (coming.modal) {\n\t\t\t\t\t$.extend(true, coming, {\n\t\t\t\t\t\tcloseBtn   : false,\n\t\t\t\t\t\tcloseClick : false,\n\t\t\t\t\t\tnextClick  : false,\n\t\t\t\t\t\tarrows     : false,\n\t\t\t\t\t\tmouseWheel : false,\n\t\t\t\t\t\tkeys       : null,\n\t\t\t\t\t\thelpers: {\n\t\t\t\t\t\t\toverlay : {\n\t\t\t\t\t\t\t\tcloseClick : false\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// 'autoSize' property is a shortcut, too\n\t\t\t\tif (coming.autoSize) {\n\t\t\t\t\tcoming.autoWidth = coming.autoHeight = true;\n\t\t\t\t}\n\n\t\t\t\tif (coming.width === 'auto') {\n\t\t\t\t\tcoming.autoWidth = true;\n\t\t\t\t}\n\n\t\t\t\tif (coming.height === 'auto') {\n\t\t\t\t\tcoming.autoHeight = true;\n\t\t\t\t}\n\n\t\t\t\t/*\n\t\t\t\t * Add reference to the group, so it`s possible to access from callbacks, example:\n\t\t\t\t * afterLoad : function() {\n\t\t\t\t *     this.title = 'Image ' + (this.index + 1) + ' of ' + this.group.length + (this.title ? ' - ' + this.title : '');\n\t\t\t\t * }\n\t\t\t\t */\n\n\t\t\t\tcoming.group  = F.group;\n\t\t\t\tcoming.index  = index;\n\n\t\t\t\t// Give a chance for callback or helpers to update coming item (type, title, etc)\n\t\t\t\tF.coming = coming;\n\n\t\t\t\tif (false === F.trigger('beforeLoad')) {\n\t\t\t\t\tF.coming = null;\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\ttype = coming.type;\n\t\t\t\thref = coming.href;\n\t\t\t\tdata_href = coming.data_href;\n\t\t\t\tdata_target = coming.data_target;\n\n\t\t\t\tif (!type) {\n\t\t\t\t\tF.coming = null;\n\n\t\t\t\t\t//If we can not determine content type then drop silently or display next/prev item if looping through gallery\n\t\t\t\t\tif (F.current && F.router && F.router !== 'jumpto') {\n\t\t\t\t\t\tF.current.index = index;\n\n\t\t\t\t\t\treturn F[ F.router ]( F.direction );\n\t\t\t\t\t}\n\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tF.isActive = true;\n\n\t\t\t\tif (type === 'image' || type === 'swf') {\n\t\t\t\t\tcoming.autoHeight = coming.autoWidth = false;\n\t\t\t\t\tcoming.scrolling  = 'visible';\n\t\t\t\t}\n\n\t\t\t\tif (type === 'image') {\n\t\t\t\t\tcoming.aspectRatio = true;\n\t\t\t\t}\n\n\t\t\t\tif (type === 'iframe' && isTouch) {\n\t\t\t\t\tcoming.scrolling = 'scroll';\n\t\t\t\t}\n\n\t\t\t\t// Build the neccessary markup\n\t\t\t\tcoming.wrap = $(coming.tpl.wrap).addClass('fancybox-' + (isTouch ? 'mobile' : 'desktop') + ' fancybox-type-' + type + ' fancybox-tmp ' + coming.wrapCSS).appendTo( coming.parent || 'body' );\n\n\t\t\t\t$.extend(coming, {\n\t\t\t\t\tskin  : $('.fancybox-skin',  coming.wrap),\n\t\t\t\t\touter : $('.fancybox-outer', coming.wrap),\n\t\t\t\t\tinner : $('.fancybox-inner', coming.wrap)\n\t\t\t\t});\n\n\t\t\t\t$.each([\"Top\", \"Right\", \"Bottom\", \"Left\"], function(i, v) {\n\t\t\t\t\tcoming.skin.css('padding' + v, getValue(coming.padding[ i ]));\n\t\t\t\t});\n\n\t\t\t\tF.trigger('onReady');\n\n\t\t\t\t// Check before try to load; 'inline' and 'html' types need content, others - href\n\t\t\t\tif (type === 'inline' || type === 'html') {\n\t\t\t\t\tif (!coming.content || !coming.content.length) {\n\t\t\t\t\t\treturn F._error( 'content' );\n\t\t\t\t\t}\n\n\t\t\t\t} else if (!href) {\n\t\t\t\t\treturn F._error( 'href' );\n\t\t\t\t}\n\n\t\t\t\tif (type === 'image') {\n\t\t\t\t\tF._loadImage();\n\n\t\t\t\t} else if (type === 'ajax') {\n\t\t\t\t\tF._loadAjax();\n\n\t\t\t\t} else if (type === 'iframe') {\n\t\t\t\t\tF._loadIframe();\n\n\t\t\t\t} else {\n\t\t\t\t\tF._afterLoad();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_error: function ( type ) {\n\t\t\t\t$.extend(F.coming, {\n\t\t\t\t\ttype       : 'html',\n\t\t\t\t\tautoWidth  : true,\n\t\t\t\t\tautoHeight : true,\n\t\t\t\t\tminWidth   : 0,\n\t\t\t\t\tminHeight  : 0,\n\t\t\t\t\tscrolling  : 'no',\n\t\t\t\t\thasError   : type,\n\t\t\t\t\tcontent    : F.coming.tpl.error\n\t\t\t\t});\n\n\t\t\t\tF._afterLoad();\n\t\t\t},\n\n\t\t\t_loadImage: function () {\n\t\t\t\t// Reset preload image so it is later possible to check \"complete\" property\n\t\t\t\tvar img = F.imgPreload = new Image();\n\n\t\t\t\timg.onload = function () {\n\t\t\t\t\tthis.onload = this.onerror = null;\n\n\t\t\t\t\tF.coming.width  = this.width / F.opts.pixelRatio;\n\t\t\t\t\tF.coming.height = this.height / F.opts.pixelRatio;\n\n\t\t\t\t\tF._afterLoad();\n\t\t\t\t};\n\n\t\t\t\timg.onerror = function () {\n\t\t\t\t\tthis.onload = this.onerror = null;\n\n\t\t\t\t\tF._error( 'image' );\n\t\t\t\t};\n\n\t\t\t\timg.src = F.coming.href;\n\t\t\t\timg.src2 = F.coming.data_href;\n\t\t\t\timg.target = F.coming.data_target;\n\n\t\t\t\tif (img.complete !== true) {\n\t\t\t\t\tF.showLoading();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_loadAjax: function () {\n\t\t\t\tvar coming = F.coming;\n\n\t\t\t\tF.showLoading();\n\n\t\t\t\tF.ajaxLoad = $.ajax($.extend({}, coming.ajax, {\n\t\t\t\t\turl: coming.href,\n\t\t\t\t\terror: function (jqXHR, textStatus) {\n\t\t\t\t\t\tif (F.coming && textStatus !== 'abort') {\n\t\t\t\t\t\t\tF._error( 'ajax', jqXHR );\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tF.hideLoading();\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\t\t\t\t\tsuccess: function (data, textStatus) {\n\t\t\t\t\t\tif (textStatus === 'success') {\n\t\t\t\t\t\t\tcoming.content = data;\n\n\t\t\t\t\t\t\tF._afterLoad();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}));\n\t\t\t},\n\n\t\t\t_loadIframe: function() {\n\t\t\t\tvar coming = F.coming,\n\t\t\t\t\tiframe = $(coming.tpl.iframe.replace(/\\{rnd\\}/g, new Date().getTime()))\n\t\t\t\t\t\t.attr('scrolling', isTouch ? 'auto' : coming.iframe.scrolling)\n\t\t\t\t\t\t.attr('src', coming.href);\n\n\t\t\t\t// This helps IE\n\t\t\t\t$(coming.wrap).bind('onReset', function () {\n\t\t\t\t\ttry {\n\t\t\t\t\t\t$(this).find('iframe').hide().attr('src', '//about:blank').end().empty();\n\t\t\t\t\t} catch (e) {}\n\t\t\t\t});\n\n\t\t\t\tif (coming.iframe.preload) {\n\t\t\t\t\tF.showLoading();\n\n\t\t\t\t\tiframe.one('load', function() {\n\t\t\t\t\t\t$(this).data('ready', 1);\n\n\t\t\t\t\t\t// iOS will lose scrolling if we resize\n\t\t\t\t\t\tif (!isTouch) {\n\t\t\t\t\t\t\t$(this).bind('load.fb', F.update);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Without this trick:\n\t\t\t\t\t\t//   - iframe won't scroll on iOS devices\n\t\t\t\t\t\t//   - IE7 sometimes displays empty iframe\n\t\t\t\t\t\t$(this).parents('.fancybox-wrap').width('100%').removeClass('fancybox-tmp').show();\n\n\t\t\t\t\t\tF._afterLoad();\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tcoming.content = iframe.appendTo( coming.inner );\n\n\t\t\t\tif (!coming.iframe.preload) {\n\t\t\t\t\tF._afterLoad();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_preloadImages: function() {\n\t\t\t\tvar group   = F.group,\n\t\t\t\t\tcurrent = F.current,\n\t\t\t\t\tlen     = group.length,\n\t\t\t\t\tcnt     = current.preload ? Math.min(current.preload, len - 1) : 0,\n\t\t\t\t\titem,\n\t\t\t\t\ti;\n\n\t\t\t\tfor (i = 1; i <= cnt; i += 1) {\n\t\t\t\t\titem = group[ (current.index + i ) % len ];\n\n\t\t\t\t\tif (item.type === 'image' && item.href) {\n\t\t\t\t\t\tnew Image().src = item.href;\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\tif (item.type === 'image' && item.data_href) {\n\t\t\t\t\t\tnew Image().src2 = item.data_href;\n\t\t\t\t\t}\n\t\t\t\t\tif (item.type === 'image' && item.data_target) {\n\t\t\t\t\t\tnew Image().target = item.data_target;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_afterLoad: function () {\n\t\t\t\tvar coming   = F.coming,\n\t\t\t\t\tprevious = F.current,\n\t\t\t\t\tplaceholder = 'fancybox-placeholder',\n\t\t\t\t\tcurrent,\n\t\t\t\t\tcontent,\n\t\t\t\t\ttype,\n\t\t\t\t\tscrolling,\n\t\t\t\t\thref,\n\t\t\t\t\tdata_href,\n\t\t\t\t\tdata_target,\n\t\t\t\t\tembed;\n\n\t\t\t\tF.hideLoading();\n\n\t\t\t\tif (!coming || F.isActive === false) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (false === F.trigger('afterLoad', coming, previous)) {\n\t\t\t\t\tcoming.wrap.stop(true).trigger('onReset').remove();\n\n\t\t\t\t\tF.coming = null;\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (previous) {\n\t\t\t\t\tF.trigger('beforeChange', previous);\n\n\t\t\t\t\tprevious.wrap.stop(true).removeClass('fancybox-opened')\n\t\t\t\t\t\t.find('.fancybox-item, .fancybox-nav')\n\t\t\t\t\t\t.remove();\n\t\t\t\t}\n\n\t\t\t\tF.unbindEvents();\n\n\t\t\t\tcurrent   = coming;\n\t\t\t\tcontent   = coming.content;\n\t\t\t\ttype      = coming.type;\n\t\t\t\tscrolling = coming.scrolling;\n\n\t\t\t\t$.extend(F, {\n\t\t\t\t\twrap  : current.wrap,\n\t\t\t\t\tskin  : current.skin,\n\t\t\t\t\touter : current.outer,\n\t\t\t\t\tinner : current.inner,\n\t\t\t\t\tcurrent  : current,\n\t\t\t\t\tprevious : previous\n\t\t\t\t});\n\n\t\t\t\thref = current.href;\n\t\t\t\tdata_href = current.data_href;\n\t\t\t\tdata_target = current.data_target;\n\n\t\t\t\tswitch (type) {\n\t\t\t\t\tcase 'inline':\n\t\t\t\t\tcase 'ajax':\n\t\t\t\t\tcase 'html':\n\t\t\t\t\t\tif (current.selector) {\n\t\t\t\t\t\t\tcontent = $('<div>').html(content).find(current.selector);\n\n\t\t\t\t\t\t} else if (isQuery(content)) {\n\t\t\t\t\t\t\tif (!content.data(placeholder)) {\n\t\t\t\t\t\t\t\tcontent.data(placeholder, $('<div class=\"' + placeholder + '\"></div>').insertAfter( content ).hide() );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tcontent = content.show().detach();\n\n\t\t\t\t\t\t\tcurrent.wrap.bind('onReset', function () {\n\t\t\t\t\t\t\t\tif ($(this).find(content).length) {\n\t\t\t\t\t\t\t\t\tcontent.hide().replaceAll( content.data(placeholder) ).data(placeholder, false);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'image':\n\t\t\t\t\t\t// content = current.tpl.image.replace(/\\{href\\}/g, href);\n\t\t\t\t\t\tcontent = '<a href=\"'+data_href+'\" target=\"'+data_target+'\"><img class=\"fancybox-image\" src=\"'+href+'\" alt=\"\" /></a>';\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'swf':\n\t\t\t\t\t\tcontent = '<object id=\"fancybox-swf\" classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" width=\"100%\" height=\"100%\"><param name=\"movie\" value=\"' + href + '\"></param>';\n\t\t\t\t\t\tembed   = '';\n\n\t\t\t\t\t\t$.each(current.swf, function(name, val) {\n\t\t\t\t\t\t\tcontent += '<param name=\"' + name + '\" value=\"' + val + '\"></param>';\n\t\t\t\t\t\t\tembed   += ' ' + name + '=\"' + val + '\"';\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tcontent += '<embed src=\"' + href + '\" type=\"application/x-shockwave-flash\" width=\"100%\" height=\"100%\"' + embed + '></embed></object>';\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif (!(isQuery(content) && content.parent().is(current.inner))) {\n\t\t\t\t\tcurrent.inner.append( content );\n\t\t\t\t}\n\n\t\t\t\t// Give a chance for helpers or callbacks to update elements\n\t\t\t\tF.trigger('beforeShow');\n\n\t\t\t\t// Set scrolling before calculating dimensions\n\t\t\t\tcurrent.inner.css('overflow', scrolling === 'yes' ? 'scroll' : (scrolling === 'no' ? 'hidden' : scrolling));\n\n\t\t\t\t// Set initial dimensions and start position\n\t\t\t\tF._setDimension();\n\n\t\t\t\tF.reposition();\n\n\t\t\t\tF.isOpen = false;\n\t\t\t\tF.coming = null;\n\n\t\t\t\tF.bindEvents();\n\n\t\t\t\tif (!F.isOpened) {\n\t\t\t\t\t$('.fancybox-wrap').not( current.wrap ).stop(true).trigger('onReset').remove();\n\n\t\t\t\t} else if (previous.prevMethod) {\n\t\t\t\t\tF.transitions[ previous.prevMethod ]();\n\t\t\t\t}\n\n\t\t\t\tF.transitions[ F.isOpened ? current.nextMethod : current.openMethod ]();\n\n\t\t\t\tF._preloadImages();\n\t\t\t},\n\n\t\t\t_setDimension: function () {\n\t\t\t\tvar viewport   = F.getViewport(),\n\t\t\t\t\tsteps      = 0,\n\t\t\t\t\tcanShrink  = false,\n\t\t\t\t\tcanExpand  = false,\n\t\t\t\t\twrap       = F.wrap,\n\t\t\t\t\tskin       = F.skin,\n\t\t\t\t\tinner      = F.inner,\n\t\t\t\t\tcurrent    = F.current,\n\t\t\t\t\twidth      = current.width,\n\t\t\t\t\theight     = current.height,\n\t\t\t\t\tminWidth   = current.minWidth,\n\t\t\t\t\tminHeight  = current.minHeight,\n\t\t\t\t\tmaxWidth   = current.maxWidth,\n\t\t\t\t\tmaxHeight  = current.maxHeight,\n\t\t\t\t\tscrolling  = current.scrolling,\n\t\t\t\t\tscrollOut  = current.scrollOutside ? current.scrollbarWidth : 0,\n\t\t\t\t\tmargin     = current.margin,\n\t\t\t\t\twMargin    = getScalar(margin[1] + margin[3]),\n\t\t\t\t\thMargin    = getScalar(margin[0] + margin[2]),\n\t\t\t\t\twPadding,\n\t\t\t\t\thPadding,\n\t\t\t\t\twSpace,\n\t\t\t\t\thSpace,\n\t\t\t\t\torigWidth,\n\t\t\t\t\torigHeight,\n\t\t\t\t\torigMaxWidth,\n\t\t\t\t\torigMaxHeight,\n\t\t\t\t\tratio,\n\t\t\t\t\twidth_,\n\t\t\t\t\theight_,\n\t\t\t\t\tmaxWidth_,\n\t\t\t\t\tmaxHeight_,\n\t\t\t\t\tiframe,\n\t\t\t\t\tbody;\n\n\t\t\t\t// Reset dimensions so we could re-check actual size\n\t\t\t\twrap.add(skin).add(inner).width('auto').height('auto').removeClass('fancybox-tmp');\n\n\t\t\t\twPadding = getScalar(skin.outerWidth(true)  - skin.width());\n\t\t\t\thPadding = getScalar(skin.outerHeight(true) - skin.height());\n\n\t\t\t\t// Any space between content and viewport (margin, padding, border, title)\n\t\t\t\twSpace = wMargin + wPadding;\n\t\t\t\thSpace = hMargin + hPadding;\n\n\t\t\t\torigWidth  = isPercentage(width)  ? (viewport.w - wSpace) * getScalar(width)  / 100 : width;\n\t\t\t\torigHeight = isPercentage(height) ? (viewport.h - hSpace) * getScalar(height) / 100 : height;\n\n\t\t\t\tif (current.type === 'iframe') {\n\t\t\t\t\tiframe = current.content;\n\n\t\t\t\t\tif (current.autoHeight && iframe && iframe.data('ready') === 1) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tif (iframe[0].contentWindow.document.location) {\n\t\t\t\t\t\t\t\tinner.width( origWidth ).height(9999);\n\n\t\t\t\t\t\t\t\tbody = iframe.contents().find('body');\n\n\t\t\t\t\t\t\t\tif (scrollOut) {\n\t\t\t\t\t\t\t\t\tbody.css('overflow-x', 'hidden');\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\torigHeight = body.outerHeight(true);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} catch (e) {}\n\t\t\t\t\t}\n\n\t\t\t\t} else if (current.autoWidth || current.autoHeight) {\n\t\t\t\t\tinner.addClass( 'fancybox-tmp' );\n\n\t\t\t\t\t// Set width or height in case we need to calculate only one dimension\n\t\t\t\t\tif (!current.autoWidth) {\n\t\t\t\t\t\tinner.width( origWidth );\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!current.autoHeight) {\n\t\t\t\t\t\tinner.height( origHeight );\n\t\t\t\t\t}\n\n\t\t\t\t\tif (current.autoWidth) {\n\t\t\t\t\t\torigWidth = inner.width();\n\t\t\t\t\t}\n\n\t\t\t\t\tif (current.autoHeight) {\n\t\t\t\t\t\torigHeight = inner.height();\n\t\t\t\t\t}\n\n\t\t\t\t\tinner.removeClass( 'fancybox-tmp' );\n\t\t\t\t}\n\n\t\t\t\twidth  = getScalar( origWidth );\n\t\t\t\theight = getScalar( origHeight );\n\n\t\t\t\tratio  = origWidth / origHeight;\n\n\t\t\t\t// Calculations for the content\n\t\t\t\tminWidth  = getScalar(isPercentage(minWidth) ? getScalar(minWidth, 'w') - wSpace : minWidth);\n\t\t\t\tmaxWidth  = getScalar(isPercentage(maxWidth) ? getScalar(maxWidth, 'w') - wSpace : maxWidth);\n\n\t\t\t\tminHeight = getScalar(isPercentage(minHeight) ? getScalar(minHeight, 'h') - hSpace : minHeight);\n\t\t\t\tmaxHeight = getScalar(isPercentage(maxHeight) ? getScalar(maxHeight, 'h') - hSpace : maxHeight);\n\n\t\t\t\t// These will be used to determine if wrap can fit in the viewport\n\t\t\t\torigMaxWidth  = maxWidth;\n\t\t\t\torigMaxHeight = maxHeight;\n\n\t\t\t\tif (current.fitToView) {\n\t\t\t\t\tmaxWidth  = Math.min(viewport.w - wSpace, maxWidth);\n\t\t\t\t\tmaxHeight = Math.min(viewport.h - hSpace, maxHeight);\n\t\t\t\t}\n\n\t\t\t\tmaxWidth_  = viewport.w - wMargin;\n\t\t\t\tmaxHeight_ = viewport.h - hMargin;\n\n\t\t\t\tif (current.aspectRatio) {\n\t\t\t\t\tif (width > maxWidth) {\n\t\t\t\t\t\twidth  = maxWidth;\n\t\t\t\t\t\theight = getScalar(width / ratio);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (height > maxHeight) {\n\t\t\t\t\t\theight = maxHeight;\n\t\t\t\t\t\twidth  = getScalar(height * ratio);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width < minWidth) {\n\t\t\t\t\t\twidth  = minWidth;\n\t\t\t\t\t\theight = getScalar(width / ratio);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (height < minHeight) {\n\t\t\t\t\t\theight = minHeight;\n\t\t\t\t\t\twidth  = getScalar(height * ratio);\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\t\t\t\t\twidth = Math.max(minWidth, Math.min(width, maxWidth));\n\n\t\t\t\t\tif (current.autoHeight && current.type !== 'iframe') {\n\t\t\t\t\t\tinner.width( width );\n\n\t\t\t\t\t\theight = inner.height();\n\t\t\t\t\t}\n\n\t\t\t\t\theight = Math.max(minHeight, Math.min(height, maxHeight));\n\t\t\t\t}\n\n\t\t\t\t// Try to fit inside viewport (including the title)\n\t\t\t\tif (current.fitToView) {\n\t\t\t\t\tinner.width( width ).height( height );\n\n\t\t\t\t\twrap.width( width + wPadding );\n\n\t\t\t\t\t// Real wrap dimensions\n\t\t\t\t\twidth_  = wrap.width();\n\t\t\t\t\theight_ = wrap.height();\n\n\t\t\t\t\tif (current.aspectRatio) {\n\t\t\t\t\t\twhile ((width_ > maxWidth_ || height_ > maxHeight_) && width > minWidth && height > minHeight) {\n\t\t\t\t\t\t\tif (steps++ > 19) {\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\theight = Math.max(minHeight, Math.min(maxHeight, height - 10));\n\t\t\t\t\t\t\twidth  = getScalar(height * ratio);\n\n\t\t\t\t\t\t\tif (width < minWidth) {\n\t\t\t\t\t\t\t\twidth  = minWidth;\n\t\t\t\t\t\t\t\theight = getScalar(width / ratio);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (width > maxWidth) {\n\t\t\t\t\t\t\t\twidth  = maxWidth;\n\t\t\t\t\t\t\t\theight = getScalar(width / ratio);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tinner.width( width ).height( height );\n\n\t\t\t\t\t\t\twrap.width( width + wPadding );\n\n\t\t\t\t\t\t\twidth_  = wrap.width();\n\t\t\t\t\t\t\theight_ = wrap.height();\n\t\t\t\t\t\t}\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\twidth  = Math.max(minWidth,  Math.min(width,  width  - (width_  - maxWidth_)));\n\t\t\t\t\t\theight = Math.max(minHeight, Math.min(height, height - (height_ - maxHeight_)));\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (scrollOut && scrolling === 'auto' && height < origHeight && (width + wPadding + scrollOut) < maxWidth_) {\n\t\t\t\t\twidth += scrollOut;\n\t\t\t\t}\n\n\t\t\t\tinner.width( width ).height( height );\n\n\t\t\t\twrap.width( width + wPadding );\n\n\t\t\t\twidth_  = wrap.width();\n\t\t\t\theight_ = wrap.height();\n\n\t\t\t\tcanShrink = (width_ > maxWidth_ || height_ > maxHeight_) && width > minWidth && height > minHeight;\n\t\t\t\tcanExpand = current.aspectRatio ? (width < origMaxWidth && height < origMaxHeight && width < origWidth && height < origHeight) : ((width < origMaxWidth || height < origMaxHeight) && (width < origWidth || height < origHeight));\n\n\t\t\t\t$.extend(current, {\n\t\t\t\t\tdim : {\n\t\t\t\t\t\twidth\t: getValue( width_ ),\n\t\t\t\t\t\theight\t: getValue( height_ )\n\t\t\t\t\t},\n\t\t\t\t\torigWidth  : origWidth,\n\t\t\t\t\torigHeight : origHeight,\n\t\t\t\t\tcanShrink  : canShrink,\n\t\t\t\t\tcanExpand  : canExpand,\n\t\t\t\t\twPadding   : wPadding,\n\t\t\t\t\thPadding   : hPadding,\n\t\t\t\t\twrapSpace  : height_ - skin.outerHeight(true),\n\t\t\t\t\tskinSpace  : skin.height() - height\n\t\t\t\t});\n\n\t\t\t\tif (!iframe && current.autoHeight && height > minHeight && height < maxHeight && !canExpand) {\n\t\t\t\t\tinner.height('auto');\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_getPosition: function (onlyAbsolute) {\n\t\t\t\tvar current  = F.current,\n\t\t\t\t\tviewport = F.getViewport(),\n\t\t\t\t\tmargin   = current.margin,\n\t\t\t\t\twidth    = F.wrap.width()  + margin[1] + margin[3],\n\t\t\t\t\theight   = F.wrap.height() + margin[0] + margin[2],\n\t\t\t\t\trez      = {\n\t\t\t\t\t\tposition: 'absolute',\n\t\t\t\t\t\ttop  : margin[0],\n\t\t\t\t\t\tleft : margin[3]\n\t\t\t\t\t};\n\n\t\t\t\tif (current.autoCenter && current.fixed && !onlyAbsolute && height <= viewport.h && width <= viewport.w) {\n\t\t\t\t\trez.position = 'fixed';\n\n\t\t\t\t} else if (!current.locked) {\n\t\t\t\t\trez.top  += viewport.y;\n\t\t\t\t\trez.left += viewport.x;\n\t\t\t\t}\n\n\t\t\t\trez.top  = getValue(Math.max(rez.top,  rez.top  + ((viewport.h - height) * current.topRatio)));\n\t\t\t\trez.left = getValue(Math.max(rez.left, rez.left + ((viewport.w - width)  * current.leftRatio)));\n\n\t\t\t\treturn rez;\n\t\t\t},\n\n\t\t\t_afterZoomIn: function () {\n\t\t\t\tvar current = F.current;\n\n\t\t\t\tif (!current) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tF.isOpen = F.isOpened = true;\n\n\t\t\t\tF.wrap.css('overflow', 'visible').addClass('fancybox-opened').hide().show(0);\n\n\t\t\t\tF.update();\n\n\t\t\t\t// Assign a click event\n\t\t\t\tif ( current.closeClick || (current.nextClick && F.group.length > 1) ) {\n\t\t\t\t\tF.inner.css('cursor', 'pointer').bind('click.fb', function(e) {\n\t\t\t\t\t\tif (!$(e.target).is('a') && !$(e.target).parent().is('a')) {\n\t\t\t\t\t\t\te.preventDefault();\n\n\t\t\t\t\t\t\tF[ current.closeClick ? 'close' : 'next' ]();\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Create a close button\n\t\t\t\tif (current.closeBtn) {\n\t\t\t\t\t$(current.tpl.closeBtn).appendTo(F.skin).bind('click.fb', function(e) {\n\t\t\t\t\t\te.preventDefault();\n\n\t\t\t\t\t\tF.close();\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Create navigation arrows\n\t\t\t\tif (current.arrows && F.group.length > 1) {\n\t\t\t\t\tif (current.loop || current.index > 0) {\n\t\t\t\t\t\t$(current.tpl.prev).appendTo(F.outer).bind('click.fb', F.prev);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (current.loop || current.index < F.group.length - 1) {\n\t\t\t\t\t\t$(current.tpl.next).appendTo(F.outer).bind('click.fb', F.next);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tF.trigger('afterShow');\n\n\t\t\t\t// Stop the slideshow if this is the last item\n\t\t\t\tif (!current.loop && current.index === current.group.length - 1) {\n\n\t\t\t\t\tF.play( false );\n\n\t\t\t\t} else if (F.opts.autoPlay && !F.player.isActive) {\n\t\t\t\t\tF.opts.autoPlay = false;\n\n\t\t\t\t\tF.play(true);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_afterZoomOut: function ( obj ) {\n\t\t\t\tobj = obj || F.current;\n\n\t\t\t\t$('.fancybox-wrap').trigger('onReset').remove();\n\n\t\t\t\t$.extend(F, {\n\t\t\t\t\tgroup  : {},\n\t\t\t\t\topts   : {},\n\t\t\t\t\trouter : false,\n\t\t\t\t\tcurrent   : null,\n\t\t\t\t\tisActive  : false,\n\t\t\t\t\tisOpened  : false,\n\t\t\t\t\tisOpen    : false,\n\t\t\t\t\tisClosing : false,\n\t\t\t\t\twrap   : null,\n\t\t\t\t\tskin   : null,\n\t\t\t\t\touter  : null,\n\t\t\t\t\tinner  : null\n\t\t\t\t});\n\n\t\t\t\tF.trigger('afterClose', obj);\n\t\t\t}\n\t\t});\n\n\t\t/*\n\t\t *\tDefault transitions\n\t\t */\n\n\t\tF.transitions = {\n\t\t\tgetOrigPosition: function () {\n\t\t\t\tvar current  = F.current,\n\t\t\t\t\telement  = current.element,\n\t\t\t\t\torig     = current.orig,\n\t\t\t\t\tpos      = {},\n\t\t\t\t\twidth    = 50,\n\t\t\t\t\theight   = 50,\n\t\t\t\t\thPadding = current.hPadding,\n\t\t\t\t\twPadding = current.wPadding,\n\t\t\t\t\tviewport = F.getViewport();\n\n\t\t\t\tif (!orig && current.isDom && element.is(':visible')) {\n\t\t\t\t\torig = element.find('img:first');\n\n\t\t\t\t\tif (!orig.length) {\n\t\t\t\t\t\torig = element;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (isQuery(orig)) {\n\t\t\t\t\tpos = orig.offset();\n\n\t\t\t\t\tif (orig.is('img')) {\n\t\t\t\t\t\twidth  = orig.outerWidth();\n\t\t\t\t\t\theight = orig.outerHeight();\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\t\t\t\t\tpos.top  = viewport.y + (viewport.h - height) * current.topRatio;\n\t\t\t\t\tpos.left = viewport.x + (viewport.w - width)  * current.leftRatio;\n\t\t\t\t}\n\n\t\t\t\tif (F.wrap.css('position') === 'fixed' || current.locked) {\n\t\t\t\t\tpos.top  -= viewport.y;\n\t\t\t\t\tpos.left -= viewport.x;\n\t\t\t\t}\n\n\t\t\t\tpos = {\n\t\t\t\t\ttop     : getValue(pos.top  - hPadding * current.topRatio),\n\t\t\t\t\tleft    : getValue(pos.left - wPadding * current.leftRatio),\n\t\t\t\t\twidth   : getValue(width  + wPadding),\n\t\t\t\t\theight  : getValue(height + hPadding)\n\t\t\t\t};\n\n\t\t\t\treturn pos;\n\t\t\t},\n\n\t\t\tstep: function (now, fx) {\n\t\t\t\tvar ratio,\n\t\t\t\t\tpadding,\n\t\t\t\t\tvalue,\n\t\t\t\t\tprop       = fx.prop,\n\t\t\t\t\tcurrent    = F.current,\n\t\t\t\t\twrapSpace  = current.wrapSpace,\n\t\t\t\t\tskinSpace  = current.skinSpace;\n\n\t\t\t\tif (prop === 'width' || prop === 'height') {\n\t\t\t\t\tratio = fx.end === fx.start ? 1 : (now - fx.start) / (fx.end - fx.start);\n\n\t\t\t\t\tif (F.isClosing) {\n\t\t\t\t\t\tratio = 1 - ratio;\n\t\t\t\t\t}\n\n\t\t\t\t\tpadding = prop === 'width' ? current.wPadding : current.hPadding;\n\t\t\t\t\tvalue   = now - padding;\n\n\t\t\t\t\tF.skin[ prop ](  getScalar( prop === 'width' ?  value : value - (wrapSpace * ratio) ) );\n\t\t\t\t\tF.inner[ prop ]( getScalar( prop === 'width' ?  value : value - (wrapSpace * ratio) - (skinSpace * ratio) ) );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tzoomIn: function () {\n\t\t\t\tvar current  = F.current,\n\t\t\t\t\tstartPos = current.pos,\n\t\t\t\t\teffect   = current.openEffect,\n\t\t\t\t\telastic  = effect === 'elastic',\n\t\t\t\t\tendPos   = $.extend({opacity : 1}, startPos);\n\n\t\t\t\t// Remove \"position\" property that breaks older IE\n\t\t\t\tdelete endPos.position;\n\n\t\t\t\tif (elastic) {\n\t\t\t\t\tstartPos = this.getOrigPosition();\n\n\t\t\t\t\tif (current.openOpacity) {\n\t\t\t\t\t\tstartPos.opacity = 0.1;\n\t\t\t\t\t}\n\n\t\t\t\t} else if (effect === 'fade') {\n\t\t\t\t\tstartPos.opacity = 0.1;\n\t\t\t\t}\n\n\t\t\t\tF.wrap.css(startPos).animate(endPos, {\n\t\t\t\t\tduration : effect === 'none' ? 0 : current.openSpeed,\n\t\t\t\t\teasing   : current.openEasing,\n\t\t\t\t\tstep     : elastic ? this.step : null,\n\t\t\t\t\tcomplete : F._afterZoomIn\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tzoomOut: function () {\n\t\t\t\tvar current  = F.current,\n\t\t\t\t\teffect   = current.closeEffect,\n\t\t\t\t\telastic  = effect === 'elastic',\n\t\t\t\t\tendPos   = {opacity : 0.1};\n\n\t\t\t\tif (elastic) {\n\t\t\t\t\tendPos = this.getOrigPosition();\n\n\t\t\t\t\tif (current.closeOpacity) {\n\t\t\t\t\t\tendPos.opacity = 0.1;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tF.wrap.animate(endPos, {\n\t\t\t\t\tduration : effect === 'none' ? 0 : current.closeSpeed,\n\t\t\t\t\teasing   : current.closeEasing,\n\t\t\t\t\tstep     : elastic ? this.step : null,\n\t\t\t\t\tcomplete : F._afterZoomOut\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tchangeIn: function () {\n\t\t\t\tvar current   = F.current,\n\t\t\t\t\teffect    = current.nextEffect,\n\t\t\t\t\tstartPos  = current.pos,\n\t\t\t\t\tendPos    = { opacity : 1 },\n\t\t\t\t\tdirection = F.direction,\n\t\t\t\t\tdistance  = 200,\n\t\t\t\t\tfield;\n\n\t\t\t\tstartPos.opacity = 0.1;\n\n\t\t\t\tif (effect === 'elastic') {\n\t\t\t\t\tfield = direction === 'down' || direction === 'up' ? 'top' : 'left';\n\n\t\t\t\t\tif (direction === 'down' || direction === 'right') {\n\t\t\t\t\t\tstartPos[ field ] = getValue(getScalar(startPos[ field ]) - distance);\n\t\t\t\t\t\tendPos[ field ]   = '+=' + distance + 'px';\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\tstartPos[ field ] = getValue(getScalar(startPos[ field ]) + distance);\n\t\t\t\t\t\tendPos[ field ]   = '-=' + distance + 'px';\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Workaround for http://bugs.jquery.com/ticket/12273\n\t\t\t\tif (effect === 'none') {\n\t\t\t\t\tF._afterZoomIn();\n\n\t\t\t\t} else {\n\t\t\t\t\tF.wrap.css(startPos).animate(endPos, {\n\t\t\t\t\t\tduration : current.nextSpeed,\n\t\t\t\t\t\teasing   : current.nextEasing,\n\t\t\t\t\t\tcomplete : F._afterZoomIn\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tchangeOut: function () {\n\t\t\t\tvar previous  = F.previous,\n\t\t\t\t\teffect    = previous.prevEffect,\n\t\t\t\t\tendPos    = { opacity : 0.1 },\n\t\t\t\t\tdirection = F.direction,\n\t\t\t\t\tdistance  = 200;\n\n\t\t\t\tif (effect === 'elastic') {\n\t\t\t\t\tendPos[ direction === 'down' || direction === 'up' ? 'top' : 'left' ] = ( direction === 'up' || direction === 'left' ? '-' : '+' ) + '=' + distance + 'px';\n\t\t\t\t}\n\n\t\t\t\tprevious.wrap.animate(endPos, {\n\t\t\t\t\tduration : effect === 'none' ? 0 : previous.prevSpeed,\n\t\t\t\t\teasing   : previous.prevEasing,\n\t\t\t\t\tcomplete : function () {\n\t\t\t\t\t\t$(this).trigger('onReset').remove();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\t/*\n\t\t *\tOverlay helper\n\t\t */\n\n\t\tF.helpers.overlay = {\n\t\t\tdefaults : {\n\t\t\t\tcloseClick : true,      // if true, fancyBox will be closed when user clicks on the overlay\n\t\t\t\tspeedOut   : 200,       // duration of fadeOut animation\n\t\t\t\tshowEarly  : true,      // indicates if should be opened immediately or wait until the content is ready\n\t\t\t\tcss        : {},        // custom CSS properties\n\t\t\t\tlocked     : !isTouch,  // if true, the content will be locked into overlay\n\t\t\t\tfixed      : true       // if false, the overlay CSS position property will not be set to \"fixed\"\n\t\t\t},\n\n\t\t\toverlay : null,      // current handle\n\t\t\tfixed   : false,     // indicates if the overlay has position \"fixed\"\n\t\t\tel      : $('html'), // element that contains \"the lock\"\n\n\t\t\t// Public methods\n\t\t\tcreate : function(opts) {\n\t\t\t\tvar parent;\n\n\t\t\t\topts = $.extend({}, this.defaults, opts);\n\n\t\t\t\tif (this.overlay) {\n\t\t\t\t\tthis.close();\n\t\t\t\t}\n\n\t\t\t\tparent = F.coming ? F.coming.parent : opts.parent;\n\n\t\t\t\tthis.overlay = $('<div class=\"fancybox-overlay\"></div>').appendTo( parent && parent.length ? parent : 'body' );\n\t\t\t\tthis.fixed   = false;\n\n\t\t\t\tif (opts.fixed && F.defaults.fixed) {\n\t\t\t\t\tthis.overlay.addClass('fancybox-overlay-fixed');\n\n\t\t\t\t\tthis.fixed = true;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\topen : function(opts) {\n\t\t\t\tvar that = this;\n\n\t\t\t\topts = $.extend({}, this.defaults, opts);\n\n\t\t\t\tif (this.overlay) {\n\t\t\t\t\tthis.overlay.unbind('.overlay').width('auto').height('auto');\n\n\t\t\t\t} else {\n\t\t\t\t\tthis.create(opts);\n\t\t\t\t}\n\n\t\t\t\tif (!this.fixed) {\n\t\t\t\t\tW.bind('resize.overlay', $.proxy( this.update, this) );\n\n\t\t\t\t\tthis.update();\n\t\t\t\t}\n\n\t\t\t\tif (opts.closeClick) {\n\t\t\t\t\tthis.overlay.bind('click.overlay', function(e) {\n\t\t\t\t\t\tif ($(e.target).hasClass('fancybox-overlay')) {\n\t\t\t\t\t\t\tif (F.isActive) {\n\t\t\t\t\t\t\t\tF.close();\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tthat.close();\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tthis.overlay.css( opts.css ).show();\n\t\t\t},\n\n\t\t\tclose : function() {\n\t\t\t\tW.unbind('resize.overlay');\n\n\t\t\t\tif (this.el.hasClass('fancybox-lock')) {\n\t\t\t\t\t$('.fancybox-margin').removeClass('fancybox-margin');\n\n\t\t\t\t\tthis.el.removeClass('fancybox-lock');\n\n\t\t\t\t\tW.scrollTop( this.scrollV ).scrollLeft( this.scrollH );\n\t\t\t\t}\n\n\t\t\t\t$('.fancybox-overlay').remove().hide();\n\n\t\t\t\t$.extend(this, {\n\t\t\t\t\toverlay : null,\n\t\t\t\t\tfixed   : false\n\t\t\t\t});\n\t\t\t},\n\n\t\t\t// Private, callbacks\n\n\t\t\tupdate : function () {\n\t\t\t\tvar width = '100%', offsetWidth;\n\n\t\t\t\t// Reset width/height so it will not mess\n\t\t\t\tthis.overlay.width(width).height('100%');\n\n\t\t\t\t// jQuery does not return reliable result for IE\n\t\t\t\tif (IE) {\n\t\t\t\t\toffsetWidth = Math.max(document.documentElement.offsetWidth, document.body.offsetWidth);\n\n\t\t\t\t\tif (D.width() > offsetWidth) {\n\t\t\t\t\t\twidth = D.width();\n\t\t\t\t\t}\n\n\t\t\t\t} else if (D.width() > W.width()) {\n\t\t\t\t\twidth = D.width();\n\t\t\t\t}\n\n\t\t\t\tthis.overlay.width(width).height(D.height());\n\t\t\t},\n\n\t\t\t// This is where we can manipulate DOM, because later it would cause iframes to reload\n\t\t\tonReady : function (opts, obj) {\n\t\t\t\tvar overlay = this.overlay;\n\n\t\t\t\t$('.fancybox-overlay').stop(true, true);\n\n\t\t\t\tif (!overlay) {\n\t\t\t\t\tthis.create(opts);\n\t\t\t\t}\n\n\t\t\t\tif (opts.locked && this.fixed && obj.fixed) {\n\t\t\t\t\tobj.locked = this.overlay.append( obj.wrap );\n\t\t\t\t\tobj.fixed  = false;\n\t\t\t\t}\n\n\t\t\t\tif (opts.showEarly === true) {\n\t\t\t\t\tthis.beforeShow.apply(this, arguments);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeShow : function(opts, obj) {\n\t\t\t\tif (obj.locked && !this.el.hasClass('fancybox-lock')) {\n\t\t\t\t\tif (this.fixPosition !== false) {\n\t\t\t\t\t\t$('*:not(object)').filter(function(){\n\t\t\t\t\t\t\treturn ($(this).css('position') === 'fixed' && !$(this).hasClass(\"fancybox-overlay\") && !$(this).hasClass(\"fancybox-wrap\") );\n\t\t\t\t\t\t}).addClass('fancybox-margin');\n\t\t\t\t\t}\n\n\t\t\t\t\tthis.el.addClass('fancybox-margin');\n\n\t\t\t\t\tthis.scrollV = W.scrollTop();\n\t\t\t\t\tthis.scrollH = W.scrollLeft();\n\n\t\t\t\t\tthis.el.addClass('fancybox-lock');\n\n\t\t\t\t\tW.scrollTop( this.scrollV ).scrollLeft( this.scrollH );\n\t\t\t\t}\n\n\t\t\t\tthis.open(opts);\n\t\t\t},\n\n\t\t\tonUpdate : function() {\n\t\t\t\tif (!this.fixed) {\n\t\t\t\t\tthis.update();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tafterClose: function (opts) {\n\t\t\t\t// Remove overlay if exists and fancyBox is not opening\n\t\t\t\t// (e.g., it is not being open using afterClose callback)\n\t\t\t\tif (this.overlay && !F.coming) {\n\t\t\t\t\tthis.overlay.fadeOut(opts.speedOut, $.proxy( this.close, this ));\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/*\n\t\t *\tTitle helper\n\t\t */\n\n\t\tF.helpers.title = {\n\t\t\tdefaults : {\n\t\t\t\ttype     : 'float', // 'float', 'inside', 'outside' or 'over',\n\t\t\t\tposition : 'bottom' // 'top' or 'bottom'\n\t\t\t},\n\n\t\t\tbeforeShow: function (opts) {\n\t\t\t\tvar current = F.current,\n\t\t\t\t\ttext    = current.title,\n\t\t\t\t\ttype    = opts.type,\n\t\t\t\t\ttitle,\n\t\t\t\t\ttarget;\n\n\t\t\t\tif ($.isFunction(text)) {\n\t\t\t\t\ttext = text.call(current.element, current);\n\t\t\t\t}\n\n\t\t\t\tif (!isString(text) || $.trim(text) === '') {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\ttitle = $('<div class=\"fancybox-title fancybox-title-' + type + '-wrap\">' + text + '</div>');\n\n\t\t\t\tswitch (type) {\n\t\t\t\t\tcase 'inside':\n\t\t\t\t\t\ttarget = F.skin;\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'outside':\n\t\t\t\t\t\ttarget = F.wrap;\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'over':\n\t\t\t\t\t\ttarget = F.inner;\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault: // 'float'\n\t\t\t\t\t\ttarget = F.skin;\n\n\t\t\t\t\t\ttitle.appendTo('body');\n\n\t\t\t\t\t\tif (IE) {\n\t\t\t\t\t\t\ttitle.width( title.width() );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttitle.wrapInner('<span class=\"child\"></span>');\n\n\t\t\t\t\t\t//Increase bottom margin so this title will also fit into viewport\n\t\t\t\t\t\tF.current.margin[2] += Math.abs( getScalar(title.css('margin-bottom')) );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\ttitle[ (opts.position === 'top' ? 'prependTo'  : 'appendTo') ](target);\n\t\t\t}\n\t\t};\n\n\t\t// jQuery plugin initialization\n\t\t$.fn.fancybox = function (options) {\n\t\t\tvar index,\n\t\t\t\tthat     = $(this),\n\t\t\t\tselector = this.selector || '',\n\t\t\t\trun      = function(e) {\n\t\t\t\t\tvar what = $(this).blur(), idx = index, relType, relVal;\n\n\t\t\t\t\tif (!(e.ctrlKey || e.altKey || e.shiftKey || e.metaKey) && !what.is('.fancybox-wrap')) {\n\t\t\t\t\t\trelType = options.groupAttr || 'data-fancybox-group';\n\t\t\t\t\t\trelVal  = what.attr(relType);\n\n\t\t\t\t\t\tif (!relVal) {\n\t\t\t\t\t\t\trelType = 'rel';\n\t\t\t\t\t\t\trelVal  = what.get(0)[ relType ];\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (relVal && relVal !== '' && relVal !== 'nofollow') {\n\t\t\t\t\t\t\twhat = selector.length ? $(selector) : that;\n\t\t\t\t\t\t\twhat = what.filter('[' + relType + '=\"' + relVal + '\"]');\n\t\t\t\t\t\t\tidx  = what.index(this);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\toptions.index = idx;\n\n\t\t\t\t\t\t// Stop an event from bubbling if everything is fine\n\t\t\t\t\t\tif (F.open(what, options) !== false) {\n\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\toptions = options || {};\n\t\t\tindex   = options.index || 0;\n\n\t\t\tif (!selector || options.live === false) {\n\t\t\t\tthat.unbind('click.fb-start').bind('click.fb-start', run);\n\n\t\t\t} else {\n\t\t\t\tD.undelegate(selector, 'click.fb-start').delegate(selector + \":not('.fancybox-item, .fancybox-nav')\", 'click.fb-start', run);\n\t\t\t}\n\n\t\t\tthis.filter('[data-fancybox-start=1]').trigger('click');\n\n\t\t\treturn this;\n\t\t};\n\n\t\t// Tests that need a body at doc ready\n\t\tD.ready(function() {\n\t\t\tvar w1, w2;\n\n\t\t\tif ( $.scrollbarWidth === undefined ) {\n\t\t\t\t// http://benalman.com/projects/jquery-misc-plugins/#scrollbarwidth\n\t\t\t\t$.scrollbarWidth = function() {\n\t\t\t\t\tvar parent = $('<div style=\"width:50px;height:50px;overflow:auto\"><div/></div>').appendTo('body'),\n\t\t\t\t\t\tchild  = parent.children(),\n\t\t\t\t\t\twidth  = child.innerWidth() - child.height( 99 ).innerWidth();\n\n\t\t\t\t\tparent.remove();\n\n\t\t\t\t\treturn width;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif ( $.support.fixedPosition === undefined ) {\n\t\t\t\t$.support.fixedPosition = (function() {\n\t\t\t\t\tvar elem  = $('<div style=\"position:fixed;top:20px;\"></div>').appendTo('body'),\n\t\t\t\t\t\tfixed = ( elem[0].offsetTop === 20 || elem[0].offsetTop === 15 );\n\n\t\t\t\t\telem.remove();\n\n\t\t\t\t\treturn fixed;\n\t\t\t\t}());\n\t\t\t}\n\n\t\t\t$.extend(F.defaults, {\n\t\t\t\tscrollbarWidth : $.scrollbarWidth(),\n\t\t\t\tfixed  : $.support.fixedPosition,\n\t\t\t\tparent : $('body')\n\t\t\t});\n\n\t\t\t//Get real width of page scroll-bar\n\t\t\tw1 = $(window).width();\n\n\t\t\tH.addClass('fancybox-lock-test');\n\n\t\t\tw2 = $(window).width();\n\n\t\t\tH.removeClass('fancybox-lock-test');\n\n\t\t\t$(\"<style type='text/css'>.fancybox-margin{margin-right:\" + (w2 - w1) + \"px;}</style>\").appendTo(\"head\");\n\t\t});\n\n\t}(window, document, $));\n\n\t;(function ($) {\n\t\t//Shortcut for fancyBox object\n\t\tvar F = $.fancybox;\n\n\t\t//Add helper object\n\t\tF.helpers.thumbs = {\n\t\t\tdefaults : {\n\t\t\t\twidth    : 50,       // thumbnail width\n\t\t\t\theight   : 50,       // thumbnail height\n\t\t\t\tposition : 'bottom', // 'top' or 'bottom'\n\t\t\t\tsource   : function ( item ) {  // function to obtain the URL of the thumbnail image\n\t\t\t\t\tvar href;\n\n\t\t\t\t\tif (item.element) {\n\t\t\t\t\t\thref = $(item.element).find('img').attr('src');\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!href && item.type === 'image' && item.href) {\n\t\t\t\t\t\thref = item.href;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn href;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\twrap  : null,\n\t\t\tlist  : null,\n\t\t\twidth : 0,\n\n\t\t\tinit: function (opts, obj) {\n\t\t\t\tvar that = this,\n\t\t\t\t\tlist,\n\t\t\t\t\tthumbWidth  = opts.width,\n\t\t\t\t\tthumbHeight = opts.height,\n\t\t\t\t\tthumbSource = opts.source;\n\n\t\t\t\t//Build list structure\n\t\t\t\tlist = '';\n\n\t\t\t\tfor (var n = 0; n < obj.group.length; n++) {\n\t\t\t\t\tlist += '<li><a style=\"width:' + thumbWidth + 'px;height:' + thumbHeight + 'px;\" href=\"javascript:$.fancybox.jumpto(' + n + ');\"></a></li>';\n\t\t\t\t}\n\n\t\t\t\tthis.wrap = $('<div id=\"fancybox-thumbs\"></div>').addClass(opts.position).appendTo('body');\n\t\t\t\tthis.list = $('<ul>' + list + '</ul>').appendTo(this.wrap);\n\n\t\t\t\t//Load each thumbnail\n\t\t\t\t$.each(obj.group, function (i) {\n\t\t\t\t\tvar el   = obj.group[ i ],\n\t\t\t\t\t\thref = thumbSource( el );\n\n\t\t\t\t\tif (!href) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t$(\"<img />\").load(function () {\n\t\t\t\t\t\tvar width  = this.width,\n\t\t\t\t\t\t\theight = this.height,\n\t\t\t\t\t\t\twidthRatio, heightRatio, parent;\n\n\t\t\t\t\t\tif (!that.list || !width || !height) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t//Calculate thumbnail width/height and center it\n\t\t\t\t\t\twidthRatio  = width / thumbWidth;\n\t\t\t\t\t\theightRatio = height / thumbHeight;\n\n\t\t\t\t\t\tparent = that.list.children().eq(i).find('a');\n\n\t\t\t\t\t\tif (widthRatio >= 1 && heightRatio >= 1) {\n\t\t\t\t\t\t\tif (widthRatio > heightRatio) {\n\t\t\t\t\t\t\t\twidth  = Math.floor(width / heightRatio);\n\t\t\t\t\t\t\t\theight = thumbHeight;\n\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\twidth  = thumbWidth;\n\t\t\t\t\t\t\t\theight = Math.floor(height / widthRatio);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t$(this).css({\n\t\t\t\t\t\t\twidth  : width,\n\t\t\t\t\t\t\theight : height,\n\t\t\t\t\t\t\ttop    : Math.floor(thumbHeight / 2 - height / 2),\n\t\t\t\t\t\t\tleft   : Math.floor(thumbWidth / 2 - width / 2)\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tparent.width(thumbWidth).height(thumbHeight);\n\n\t\t\t\t\t\t$(this).hide().appendTo(parent).fadeIn(300);\n\n\t\t\t\t\t})\n\t\t\t\t\t.attr('src',   href)\n\t\t\t\t\t.attr('title', el.title);\n\t\t\t\t});\n\n\t\t\t\t//Set initial width\n\t\t\t\tthis.width = this.list.children().eq(0).outerWidth(true);\n\n\t\t\t\tthis.list.width(this.width * (obj.group.length + 1)).css('left', Math.floor($(window).width() * 0.5 - (obj.index * this.width + this.width * 0.5)));\n\t\t\t},\n\n\t\t\tbeforeLoad: function (opts, obj) {\n\t\t\t\t//Remove self if gallery do not have at least two items\n\t\t\t\tif (obj.group.length < 2) {\n\t\t\t\t\tobj.helpers.thumbs = false;\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t//Increase bottom margin to give space for thumbs\n\t\t\t\tobj.margin[ opts.position === 'top' ? 0 : 2 ] += ((opts.height) + 15);\n\t\t\t},\n\n\t\t\tafterShow: function (opts, obj) {\n\t\t\t\t//Check if exists and create or update list\n\t\t\t\tif (this.list) {\n\t\t\t\t\tthis.onUpdate(opts, obj);\n\n\t\t\t\t} else {\n\t\t\t\t\tthis.init(opts, obj);\n\t\t\t\t}\n\n\t\t\t\t//Set active element\n\t\t\t\tthis.list.children().removeClass('active').eq(obj.index).addClass('active');\n\t\t\t},\n\n\t\t\t//Center list\n\t\t\tonUpdate: function (opts, obj) {\n\t\t\t\tif (this.list) {\n\t\t\t\t\tthis.list.stop(true).animate({\n\t\t\t\t\t\t'left': Math.floor($(window).width() * 0.5 - (obj.index * this.width + this.width * 0.5))\n\t\t\t\t\t}, 150);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeClose: function () {\n\t\t\t\tif (this.wrap) {\n\t\t\t\t\tthis.wrap.remove();\n\t\t\t\t}\n\n\t\t\t\tthis.wrap  = null;\n\t\t\t\tthis.list  = null;\n\t\t\t\tthis.width = 0;\n\t\t\t}\n\t\t}\n\n\t}($));\n\n\n\t/*Js for thumb*/\n\n\t /*!\n\t * Thumbnail helper for fancyBox\n\t * version: 1.0.7 (Mon, 01 Oct 2012)\n\t * @requires fancyBox v2.0 or later\n\t *\n\t * Usage:\n\t *     $(\".fancybox\").fancybox({\n\t *         helpers : {\n\t *             thumbs: {\n\t *                 width  : 50,\n\t *                 height : 50\n\t *             }\n\t *         }\n\t *     });\n\t *\n\t */\n\t;(function ($) {\n\t\t//Shortcut for fancyBox object\n\t\tvar F = $.fancybox;\n\n\t\t//Add helper object\n\t\tF.helpers.thumbs = {\n\t\t\tdefaults : {\n\t\t\t\twidth    : 50,       // thumbnail width\n\t\t\t\theight   : 50,       // thumbnail height\n\t\t\t\tposition : 'bottom', // 'top' or 'bottom'\n\t\t\t\tsource   : function ( item ) {  // function to obtain the URL of the thumbnail image\n\t\t\t\t\tvar href;\n\n\t\t\t\t\tif (item.element) {\n\t\t\t\t\t\thref = $(item.element).find('img').attr('src');\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!href && item.type === 'image' && item.href) {\n\t\t\t\t\t\thref = item.href;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn href;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\twrap  : null,\n\t\t\tlist  : null,\n\t\t\twidth : 0,\n\n\t\t\tinit: function (opts, obj) {\n\t\t\t\tvar that = this,\n\t\t\t\t\tlist,\n\t\t\t\t\tthumbWidth  = opts.width,\n\t\t\t\t\tthumbHeight = opts.height,\n\t\t\t\t\tthumbSource = opts.source;\n\n\t\t\t\t//Build list structure\n\t\t\t\tlist = '';\n\n\t\t\t\tfor (var n = 0; n < obj.group.length; n++) {\n\t\t\t\t\tlist += '<li><a style=\"width:' + thumbWidth + 'px;height:' + thumbHeight + 'px;\" href=\"javascript:$.fancybox.jumpto(' + n + ');\"></a></li>';\n\t\t\t\t}\n\n\t\t\t\tthis.wrap = $('<div id=\"fancybox-thumbs\"></div>').addClass(opts.position).appendTo('body');\n\t\t\t\tthis.list = $('<ul>' + list + '</ul>').appendTo(this.wrap);\n\n\t\t\t\t//Load each thumbnail\n\t\t\t\t$.each(obj.group, function (i) {\n\t\t\t\t\tvar el   = obj.group[ i ],\n\t\t\t\t\t\thref = thumbSource( el );\n\n\t\t\t\t\tif (!href) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t$(\"<img />\").load(function () {\n\t\t\t\t\t\tvar width  = this.width,\n\t\t\t\t\t\t\theight = this.height,\n\t\t\t\t\t\t\twidthRatio, heightRatio, parent;\n\n\t\t\t\t\t\tif (!that.list || !width || !height) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t//Calculate thumbnail width/height and center it\n\t\t\t\t\t\twidthRatio  = width / thumbWidth;\n\t\t\t\t\t\theightRatio = height / thumbHeight;\n\n\t\t\t\t\t\tparent = that.list.children().eq(i).find('a');\n\n\t\t\t\t\t\tif (widthRatio >= 1 && heightRatio >= 1) {\n\t\t\t\t\t\t\tif (widthRatio > heightRatio) {\n\t\t\t\t\t\t\t\twidth  = Math.floor(width / heightRatio);\n\t\t\t\t\t\t\t\theight = thumbHeight;\n\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\twidth  = thumbWidth;\n\t\t\t\t\t\t\t\theight = Math.floor(height / widthRatio);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t$(this).css({\n\t\t\t\t\t\t\twidth  : width,\n\t\t\t\t\t\t\theight : height,\n\t\t\t\t\t\t\ttop    : Math.floor(thumbHeight / 2 - height / 2),\n\t\t\t\t\t\t\tleft   : Math.floor(thumbWidth / 2 - width / 2)\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tparent.width(thumbWidth).height(thumbHeight);\n\n\t\t\t\t\t\t$(this).hide().appendTo(parent).fadeIn(300);\n\n\t\t\t\t\t})\n\t\t\t\t\t.attr('src',   href)\n\t\t\t\t\t.attr('title', el.title);\n\t\t\t\t});\n\n\t\t\t\t//Set initial width\n\t\t\t\tthis.width = this.list.children().eq(0).outerWidth(true);\n\n\t\t\t\tthis.list.width(this.width * (obj.group.length + 1)).css('left', Math.floor($(window).width() * 0.5 - (obj.index * this.width + this.width * 0.5)));\n\t\t\t},\n\n\t\t\tbeforeLoad: function (opts, obj) {\n\t\t\t\t//Remove self if gallery do not have at least two items\n\t\t\t\tif (obj.group.length < 2) {\n\t\t\t\t\tobj.helpers.thumbs = false;\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t//Increase bottom margin to give space for thumbs\n\t\t\t\tobj.margin[ opts.position === 'top' ? 0 : 2 ] += ((opts.height) + 15);\n\t\t\t},\n\n\t\t\tafterShow: function (opts, obj) {\n\t\t\t\t//Check if exists and create or update list\n\t\t\t\tif (this.list) {\n\t\t\t\t\tthis.onUpdate(opts, obj);\n\n\t\t\t\t} else {\n\t\t\t\t\tthis.init(opts, obj);\n\t\t\t\t}\n\n\t\t\t\t//Set active element\n\t\t\t\tthis.list.children().removeClass('active').eq(obj.index).addClass('active');\n\t\t\t},\n\n\t\t\t//Center list\n\t\t\tonUpdate: function (opts, obj) {\n\t\t\t\tif (this.list) {\n\t\t\t\t\tthis.list.stop(true).animate({\n\t\t\t\t\t\t'left': Math.floor($(window).width() * 0.5 - (obj.index * this.width + this.width * 0.5))\n\t\t\t\t\t}, 150);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeClose: function () {\n\t\t\t\tif (this.wrap) {\n\t\t\t\t\tthis.wrap.remove();\n\t\t\t\t}\n\n\t\t\t\tthis.wrap  = null;\n\t\t\t\tthis.list  = null;\n\t\t\t\tthis.width = 0;\n\t\t\t}\n\t\t}\n\n\t}($));\n});\n\n","Plazathemes_Loadjs/js/owl-carousel/owl.carousel.js":"/*\n *  jQuery OwlCarousel v1.3.3\n *\n *  Copyright (c) 2013 Bartosz Wojciechowski\n *  http://www.owlgraphic.com/owlcarousel/\n *\n *  Licensed under MIT\n *\n */\n\n/*JS Lint helpers: */\n/*global dragMove: false, dragEnd: false, $, jQuery, alert, window, document */\n/*jslint nomen: true, continue:true */\n\nif (typeof Object.create !== \"function\") {\n    Object.create = function (obj) {\n        function F() {}\n        F.prototype = obj;\n        return new F();\n    };\n}\n(function ($, window, document) {\n\n    var Carousel = {\n        init : function (options, el) {\n            var base = this;\n\n            base.$elem = $(el);\n            base.options = $.extend({}, $.fn.owlCarousel.options, base.$elem.data(), options);\n\n            base.userOptions = options;\n            base.loadContent();\n        },\n\n        loadContent : function () {\n            var base = this, url;\n\n            function getData(data) {\n                var i, content = \"\";\n                if (typeof base.options.jsonSuccess === \"function\") {\n                    base.options.jsonSuccess.apply(this, [data]);\n                } else {\n                    for (i in data.owl) {\n                        if (data.owl.hasOwnProperty(i)) {\n                            content += data.owl[i].item;\n                        }\n                    }\n                    base.$elem.html(content);\n                }\n                base.logIn();\n            }\n\n            if (typeof base.options.beforeInit === \"function\") {\n                base.options.beforeInit.apply(this, [base.$elem]);\n            }\n\n            if (typeof base.options.jsonPath === \"string\") {\n                url = base.options.jsonPath;\n                $.getJSON(url, getData);\n            } else {\n                base.logIn();\n            }\n        },\n\n        logIn : function () {\n            var base = this;\n\n            base.$elem.data(\"owl-originalStyles\", base.$elem.attr(\"style\"));\n            base.$elem.data(\"owl-originalClasses\", base.$elem.attr(\"class\"));\n\n            base.$elem.css({opacity: 0});\n            base.orignalItems = base.options.items;\n            base.checkBrowser();\n            base.wrapperWidth = 0;\n            base.checkVisible = null;\n            base.setVars();\n        },\n\n        setVars : function () {\n            var base = this;\n            if (base.$elem.children().length === 0) {return false; }\n            base.baseClass();\n            base.eventTypes();\n            base.$userItems = base.$elem.children();\n            base.itemsAmount = base.$userItems.length;\n            base.wrapItems();\n            base.$owlItems = base.$elem.find(\".owl-item\");\n            base.$owlWrapper = base.$elem.find(\".owl-wrapper\");\n            base.playDirection = \"next\";\n            base.prevItem = 0;\n            base.prevArr = [0];\n            base.currentItem = 0;\n            base.customEvents();\n            base.onStartup();\n        },\n\n        onStartup : function () {\n            var base = this;\n            base.updateItems();\n            base.calculateAll();\n            base.buildControls();\n            base.updateControls();\n            base.response();\n            base.moveEvents();\n            base.stopOnHover();\n            base.owlStatus();\n\n            if (base.options.transitionStyle !== false) {\n                base.transitionTypes(base.options.transitionStyle);\n            }\n            if (base.options.autoPlay === true) {\n                base.options.autoPlay = 5000;\n            }\n            base.play();\n\n            base.$elem.find(\".owl-wrapper\").css(\"display\", \"block\");\n\n            if (!base.$elem.is(\":visible\")) {\n                base.watchVisibility();\n            } else {\n                base.$elem.css(\"opacity\", 1);\n            }\n            base.onstartup = false;\n            base.eachMoveUpdate();\n            if (typeof base.options.afterInit === \"function\") {\n                base.options.afterInit.apply(this, [base.$elem]);\n            }\n        },\n\n        eachMoveUpdate : function () {\n            var base = this;\n\n            if (base.options.lazyLoad === true) {\n                base.lazyLoad();\n            }\n            if (base.options.autoHeight === true) {\n                base.autoHeight();\n            }\n            base.onVisibleItems();\n\n            if (typeof base.options.afterAction === \"function\") {\n                base.options.afterAction.apply(this, [base.$elem]);\n            }\n        },\n\n        updateVars : function () {\n            var base = this;\n            if (typeof base.options.beforeUpdate === \"function\") {\n                base.options.beforeUpdate.apply(this, [base.$elem]);\n            }\n            base.watchVisibility();\n            base.updateItems();\n            base.calculateAll();\n            base.updatePosition();\n            base.updateControls();\n            base.eachMoveUpdate();\n            if (typeof base.options.afterUpdate === \"function\") {\n                base.options.afterUpdate.apply(this, [base.$elem]);\n            }\n        },\n\n        reload : function () {\n            var base = this;\n            window.setTimeout(function () {\n                base.updateVars();\n            }, 0);\n        },\n\n        watchVisibility : function () {\n            var base = this;\n\n            if (base.$elem.is(\":visible\") === false) {\n                base.$elem.css({opacity: 0});\n                window.clearInterval(base.autoPlayInterval);\n                window.clearInterval(base.checkVisible);\n            } else {\n                return false;\n            }\n            base.checkVisible = window.setInterval(function () {\n                if (base.$elem.is(\":visible\")) {\n                    base.reload();\n                    base.$elem.animate({opacity: 1}, 200);\n                    window.clearInterval(base.checkVisible);\n                }\n            }, 500);\n        },\n\n        wrapItems : function () {\n            var base = this;\n            base.$userItems.wrapAll(\"<div class=\\\"owl-wrapper\\\">\").wrap(\"<div class=\\\"owl-item\\\"></div>\");\n            base.$elem.find(\".owl-wrapper\").wrap(\"<div class=\\\"owl-wrapper-outer\\\">\");\n            base.wrapperOuter = base.$elem.find(\".owl-wrapper-outer\");\n            base.$elem.css(\"display\", \"block\");\n        },\n\n        baseClass : function () {\n            var base = this,\n                hasBaseClass = base.$elem.hasClass(base.options.baseClass),\n                hasThemeClass = base.$elem.hasClass(base.options.theme);\n\n            if (!hasBaseClass) {\n                base.$elem.addClass(base.options.baseClass);\n            }\n\n            if (!hasThemeClass) {\n                base.$elem.addClass(base.options.theme);\n            }\n        },\n\n        updateItems : function () {\n            var base = this, width, i;\n\n            if (base.options.responsive === false) {\n                return false;\n            }\n            if (base.options.singleItem === true) {\n                base.options.items = base.orignalItems = 1;\n                base.options.itemsCustom = false;\n                base.options.itemsDesktop = false;\n                base.options.itemsDesktopSmall = false;\n                base.options.itemsTablet = false;\n                base.options.itemsTabletSmall = false;\n                base.options.itemsMobile = false;\n                return false;\n            }\n\n            width = $(base.options.responsiveBaseWidth).width();\n\n            if (width > (base.options.itemsDesktop[0] || base.orignalItems)) {\n                base.options.items = base.orignalItems;\n            }\n            if (base.options.itemsCustom !== false) {\n                //Reorder array by screen size\n                base.options.itemsCustom.sort(function (a, b) {return a[0] - b[0]; });\n\n                for (i = 0; i < base.options.itemsCustom.length; i += 1) {\n                    if (base.options.itemsCustom[i][0] <= width) {\n                        base.options.items = base.options.itemsCustom[i][1];\n                    }\n                }\n\n            } else {\n\n                if (width <= base.options.itemsDesktop[0] && base.options.itemsDesktop !== false) {\n                    base.options.items = base.options.itemsDesktop[1];\n                }\n\n                if (width <= base.options.itemsDesktopSmall[0] && base.options.itemsDesktopSmall !== false) {\n                    base.options.items = base.options.itemsDesktopSmall[1];\n                }\n\n                if (width <= base.options.itemsTablet[0] && base.options.itemsTablet !== false) {\n                    base.options.items = base.options.itemsTablet[1];\n                }\n\n                if (width <= base.options.itemsTabletSmall[0] && base.options.itemsTabletSmall !== false) {\n                    base.options.items = base.options.itemsTabletSmall[1];\n                }\n\n                if (width <= base.options.itemsMobile[0] && base.options.itemsMobile !== false) {\n                    base.options.items = base.options.itemsMobile[1];\n                }\n            }\n\n            //if number of items is less than declared\n            if (base.options.items > base.itemsAmount && base.options.itemsScaleUp === true) {\n                base.options.items = base.itemsAmount;\n            }\n        },\n\n        response : function () {\n            var base = this,\n                smallDelay,\n                lastWindowWidth;\n\n            if (base.options.responsive !== true) {\n                return false;\n            }\n            lastWindowWidth = $(window).width();\n\n            base.resizer = function () {\n                if ($(window).width() !== lastWindowWidth) {\n                    if (base.options.autoPlay !== false) {\n                        window.clearInterval(base.autoPlayInterval);\n                    }\n                    window.clearTimeout(smallDelay);\n                    smallDelay = window.setTimeout(function () {\n                        lastWindowWidth = $(window).width();\n                        base.updateVars();\n                    }, base.options.responsiveRefreshRate);\n                }\n            };\n            $(window).resize(base.resizer);\n        },\n\n        updatePosition : function () {\n            var base = this;\n            base.jumpTo(base.currentItem);\n            if (base.options.autoPlay !== false) {\n                base.checkAp();\n            }\n        },\n\n        appendItemsSizes : function () {\n            var base = this,\n                roundPages = 0,\n                lastItem = base.itemsAmount - base.options.items;\n\n            base.$owlItems.each(function (index) {\n                var $this = $(this);\n                $this\n                    .css({\"width\": base.itemWidth})\n                    .data(\"owl-item\", Number(index));\n\n                if (index % base.options.items === 0 || index === lastItem) {\n                    if (!(index > lastItem)) {\n                        roundPages += 1;\n                    }\n                }\n                $this.data(\"owl-roundPages\", roundPages);\n            });\n        },\n\n        appendWrapperSizes : function () {\n            var base = this,\n                width = base.$owlItems.length * base.itemWidth;\n\n            base.$owlWrapper.css({\n                \"width\": width * 2,\n                \"left\": 0\n            });\n            base.appendItemsSizes();\n        },\n\n        calculateAll : function () {\n            var base = this;\n            base.calculateWidth();\n            base.appendWrapperSizes();\n            base.loops();\n            base.max();\n        },\n\n        calculateWidth : function () {\n            var base = this;\n            base.itemWidth = Math.round(base.$elem.width() / base.options.items);\n        },\n\n        max : function () {\n            var base = this,\n                maximum = ((base.itemsAmount * base.itemWidth) - base.options.items * base.itemWidth) * -1;\n            if (base.options.items > base.itemsAmount) {\n                base.maximumItem = 0;\n                maximum = 0;\n                base.maximumPixels = 0;\n            } else {\n                base.maximumItem = base.itemsAmount - base.options.items;\n                base.maximumPixels = maximum;\n            }\n            return maximum;\n        },\n\n        min : function () {\n            return 0;\n        },\n\n        loops : function () {\n            var base = this,\n                prev = 0,\n                elWidth = 0,\n                i,\n                item,\n                roundPageNum;\n\n            base.positionsInArray = [0];\n            base.pagesInArray = [];\n\n            for (i = 0; i < base.itemsAmount; i += 1) {\n                elWidth += base.itemWidth;\n                base.positionsInArray.push(-elWidth);\n\n                if (base.options.scrollPerPage === true) {\n                    item = $(base.$owlItems[i]);\n                    roundPageNum = item.data(\"owl-roundPages\");\n                    if (roundPageNum !== prev) {\n                        base.pagesInArray[prev] = base.positionsInArray[i];\n                        prev = roundPageNum;\n                    }\n                }\n            }\n        },\n\n        buildControls : function () {\n            var base = this;\n            if (base.options.navigation === true || base.options.pagination === true) {\n                base.owlControls = $(\"<div class=\\\"owl-controls\\\"/>\").toggleClass(\"clickable\", !base.browser.isTouch).appendTo(base.$elem);\n            }\n            if (base.options.pagination === true) {\n                base.buildPagination();\n            }\n            if (base.options.navigation === true) {\n                base.buildButtons();\n            }\n        },\n\n        buildButtons : function () {\n            var base = this,\n                buttonsWrapper = $(\"<div class=\\\"owl-buttons\\\"/>\");\n            base.owlControls.append(buttonsWrapper);\n\n            base.buttonPrev = $(\"<div/>\", {\n                \"class\" : \"owl-prev\",\n                \"html\" : base.options.navigationText[0] || \"\"\n            });\n\n            base.buttonNext = $(\"<div/>\", {\n                \"class\" : \"owl-next\",\n                \"html\" : base.options.navigationText[1] || \"\"\n            });\n\n            buttonsWrapper\n                .append(base.buttonPrev)\n                .append(base.buttonNext);\n\n            buttonsWrapper.on(\"touchstart.owlControls mousedown.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n                event.preventDefault();\n            });\n\n            buttonsWrapper.on(\"touchend.owlControls mouseup.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n                event.preventDefault();\n                if ($(this).hasClass(\"owl-next\")) {\n                    base.next();\n                } else {\n                    base.prev();\n                }\n            });\n        },\n\n        buildPagination : function () {\n            var base = this;\n\n            base.paginationWrapper = $(\"<div class=\\\"owl-pagination\\\"/>\");\n            base.owlControls.append(base.paginationWrapper);\n\n            base.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\", \".owl-page\", function (event) {\n                event.preventDefault();\n                if (Number($(this).data(\"owl-page\")) !== base.currentItem) {\n                    base.goTo(Number($(this).data(\"owl-page\")), true);\n                }\n            });\n        },\n\n        updatePagination : function () {\n            var base = this,\n                counter,\n                lastPage,\n                lastItem,\n                i,\n                paginationButton,\n                paginationButtonInner;\n\n            if (base.options.pagination === false) {\n                return false;\n            }\n\n            base.paginationWrapper.html(\"\");\n\n            counter = 0;\n            lastPage = base.itemsAmount - base.itemsAmount % base.options.items;\n\n            for (i = 0; i < base.itemsAmount; i += 1) {\n                if (i % base.options.items === 0) {\n                    counter += 1;\n                    if (lastPage === i) {\n                        lastItem = base.itemsAmount - base.options.items;\n                    }\n                    paginationButton = $(\"<div/>\", {\n                        \"class\" : \"owl-page\"\n                    });\n                    paginationButtonInner = $(\"<span></span>\", {\n                        \"text\": base.options.paginationNumbers === true ? counter : \"\",\n                        \"class\": base.options.paginationNumbers === true ? \"owl-numbers\" : \"\"\n                    });\n                    paginationButton.append(paginationButtonInner);\n\n                    paginationButton.data(\"owl-page\", lastPage === i ? lastItem : i);\n                    paginationButton.data(\"owl-roundPages\", counter);\n\n                    base.paginationWrapper.append(paginationButton);\n                }\n            }\n            base.checkPagination();\n        },\n        checkPagination : function () {\n            var base = this;\n            if (base.options.pagination === false) {\n                return false;\n            }\n            base.paginationWrapper.find(\".owl-page\").each(function () {\n                if ($(this).data(\"owl-roundPages\") === $(base.$owlItems[base.currentItem]).data(\"owl-roundPages\")) {\n                    base.paginationWrapper\n                        .find(\".owl-page\")\n                        .removeClass(\"active\");\n                    $(this).addClass(\"active\");\n                }\n            });\n        },\n\n        checkNavigation : function () {\n            var base = this;\n\n            if (base.options.navigation === false) {\n                return false;\n            }\n            if (base.options.rewindNav === false) {\n                if (base.currentItem === 0 && base.maximumItem === 0) {\n                    base.buttonPrev.addClass(\"disabled\");\n                    base.buttonNext.addClass(\"disabled\");\n                } else if (base.currentItem === 0 && base.maximumItem !== 0) {\n                    base.buttonPrev.addClass(\"disabled\");\n                    base.buttonNext.removeClass(\"disabled\");\n                } else if (base.currentItem === base.maximumItem) {\n                    base.buttonPrev.removeClass(\"disabled\");\n                    base.buttonNext.addClass(\"disabled\");\n                } else if (base.currentItem !== 0 && base.currentItem !== base.maximumItem) {\n                    base.buttonPrev.removeClass(\"disabled\");\n                    base.buttonNext.removeClass(\"disabled\");\n                }\n            }\n        },\n\n        updateControls : function () {\n            var base = this;\n            base.updatePagination();\n            base.checkNavigation();\n            if (base.owlControls) {\n                if (base.options.items >= base.itemsAmount) {\n                    base.owlControls.hide();\n                } else {\n                    base.owlControls.show();\n                }\n            }\n        },\n\n        destroyControls : function () {\n            var base = this;\n            if (base.owlControls) {\n                base.owlControls.remove();\n            }\n        },\n\n        next : function (speed) {\n            var base = this;\n\n            if (base.isTransition) {\n                return false;\n            }\n\n            base.currentItem += base.options.scrollPerPage === true ? base.options.items : 1;\n            if (base.currentItem > base.maximumItem + (base.options.scrollPerPage === true ? (base.options.items - 1) : 0)) {\n                if (base.options.rewindNav === true) {\n                    base.currentItem = 0;\n                    speed = \"rewind\";\n                } else {\n                    base.currentItem = base.maximumItem;\n                    return false;\n                }\n            }\n            base.goTo(base.currentItem, speed);\n        },\n\n        prev : function (speed) {\n            var base = this;\n\n            if (base.isTransition) {\n                return false;\n            }\n\n            if (base.options.scrollPerPage === true && base.currentItem > 0 && base.currentItem < base.options.items) {\n                base.currentItem = 0;\n            } else {\n                base.currentItem -= base.options.scrollPerPage === true ? base.options.items : 1;\n            }\n            if (base.currentItem < 0) {\n                if (base.options.rewindNav === true) {\n                    base.currentItem = base.maximumItem;\n                    speed = \"rewind\";\n                } else {\n                    base.currentItem = 0;\n                    return false;\n                }\n            }\n            base.goTo(base.currentItem, speed);\n        },\n\n        goTo : function (position, speed, drag) {\n            var base = this,\n                goToPixel;\n\n            if (base.isTransition) {\n                return false;\n            }\n            if (typeof base.options.beforeMove === \"function\") {\n                base.options.beforeMove.apply(this, [base.$elem]);\n            }\n            if (position >= base.maximumItem) {\n                position = base.maximumItem;\n            } else if (position <= 0) {\n                position = 0;\n            }\n\n            base.currentItem = base.owl.currentItem = position;\n            if (base.options.transitionStyle !== false && drag !== \"drag\" && base.options.items === 1 && base.browser.support3d === true) {\n                base.swapSpeed(0);\n                if (base.browser.support3d === true) {\n                    base.transition3d(base.positionsInArray[position]);\n                } else {\n                    base.css2slide(base.positionsInArray[position], 1);\n                }\n                base.afterGo();\n                base.singleItemTransition();\n                return false;\n            }\n            goToPixel = base.positionsInArray[position];\n\n            if (base.browser.support3d === true) {\n                base.isCss3Finish = false;\n\n                if (speed === true) {\n                    base.swapSpeed(\"paginationSpeed\");\n                    window.setTimeout(function () {\n                        base.isCss3Finish = true;\n                    }, base.options.paginationSpeed);\n\n                } else if (speed === \"rewind\") {\n                    base.swapSpeed(base.options.rewindSpeed);\n                    window.setTimeout(function () {\n                        base.isCss3Finish = true;\n                    }, base.options.rewindSpeed);\n\n                } else {\n                    base.swapSpeed(\"slideSpeed\");\n                    window.setTimeout(function () {\n                        base.isCss3Finish = true;\n                    }, base.options.slideSpeed);\n                }\n                base.transition3d(goToPixel);\n            } else {\n                if (speed === true) {\n                    base.css2slide(goToPixel, base.options.paginationSpeed);\n                } else if (speed === \"rewind\") {\n                    base.css2slide(goToPixel, base.options.rewindSpeed);\n                } else {\n                    base.css2slide(goToPixel, base.options.slideSpeed);\n                }\n            }\n            base.afterGo();\n        },\n\n        jumpTo : function (position) {\n            var base = this;\n            if (typeof base.options.beforeMove === \"function\") {\n                base.options.beforeMove.apply(this, [base.$elem]);\n            }\n            if (position >= base.maximumItem || position === -1) {\n                position = base.maximumItem;\n            } else if (position <= 0) {\n                position = 0;\n            }\n            base.swapSpeed(0);\n            if (base.browser.support3d === true) {\n                base.transition3d(base.positionsInArray[position]);\n            } else {\n                base.css2slide(base.positionsInArray[position], 1);\n            }\n            base.currentItem = base.owl.currentItem = position;\n            base.afterGo();\n        },\n\n        afterGo : function () {\n            var base = this;\n\n            base.prevArr.push(base.currentItem);\n            base.prevItem = base.owl.prevItem = base.prevArr[base.prevArr.length - 2];\n            base.prevArr.shift(0);\n\n            if (base.prevItem !== base.currentItem) {\n                base.checkPagination();\n                base.checkNavigation();\n                base.eachMoveUpdate();\n\n                if (base.options.autoPlay !== false) {\n                    base.checkAp();\n                }\n            }\n            if (typeof base.options.afterMove === \"function\" && base.prevItem !== base.currentItem) {\n                base.options.afterMove.apply(this, [base.$elem]);\n            }\n        },\n\n        stop : function () {\n            var base = this;\n            base.apStatus = \"stop\";\n            window.clearInterval(base.autoPlayInterval);\n        },\n\n        checkAp : function () {\n            var base = this;\n            if (base.apStatus !== \"stop\") {\n                base.play();\n            }\n        },\n\n        play : function () {\n            var base = this;\n            base.apStatus = \"play\";\n            if (base.options.autoPlay === false) {\n                return false;\n            }\n            window.clearInterval(base.autoPlayInterval);\n            base.autoPlayInterval = window.setInterval(function () {\n                base.next(true);\n            }, base.options.autoPlay);\n        },\n\n        swapSpeed : function (action) {\n            var base = this;\n            if (action === \"slideSpeed\") {\n                base.$owlWrapper.css(base.addCssSpeed(base.options.slideSpeed));\n            } else if (action === \"paginationSpeed\") {\n                base.$owlWrapper.css(base.addCssSpeed(base.options.paginationSpeed));\n            } else if (typeof action !== \"string\") {\n                base.$owlWrapper.css(base.addCssSpeed(action));\n            }\n        },\n\n        addCssSpeed : function (speed) {\n            return {\n                \"-webkit-transition\": \"all \" + speed + \"ms ease\",\n                \"-moz-transition\": \"all \" + speed + \"ms ease\",\n                \"-o-transition\": \"all \" + speed + \"ms ease\",\n                \"transition\": \"all \" + speed + \"ms ease\"\n            };\n        },\n\n        removeTransition : function () {\n            return {\n                \"-webkit-transition\": \"\",\n                \"-moz-transition\": \"\",\n                \"-o-transition\": \"\",\n                \"transition\": \"\"\n            };\n        },\n\n        doTranslate : function (pixels) {\n            return {\n                \"-webkit-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                \"-moz-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                \"-o-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                \"-ms-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                \"transform\": \"translate3d(\" + pixels + \"px, 0px,0px)\"\n            };\n        },\n\n        transition3d : function (value) {\n            var base = this;\n            base.$owlWrapper.css(base.doTranslate(value));\n        },\n\n        css2move : function (value) {\n            var base = this;\n            base.$owlWrapper.css({\"left\" : value});\n        },\n\n        css2slide : function (value, speed) {\n            var base = this;\n\n            base.isCssFinish = false;\n            base.$owlWrapper.stop(true, true).animate({\n                \"left\" : value\n            }, {\n                duration : speed || base.options.slideSpeed,\n                complete : function () {\n                    base.isCssFinish = true;\n                }\n            });\n        },\n\n        checkBrowser : function () {\n            var base = this,\n                translate3D = \"translate3d(0px, 0px, 0px)\",\n                tempElem = document.createElement(\"div\"),\n                regex,\n                asSupport,\n                support3d,\n                isTouch;\n\n            tempElem.style.cssText = \"  -moz-transform:\" + translate3D +\n                                  \"; -ms-transform:\"     + translate3D +\n                                  \"; -o-transform:\"      + translate3D +\n                                  \"; -webkit-transform:\" + translate3D +\n                                  \"; transform:\"         + translate3D;\n            regex = /translate3d\\(0px, 0px, 0px\\)/g;\n            asSupport = tempElem.style.cssText.match(regex);\n            support3d = (asSupport !== null && asSupport.length === 1);\n\n            isTouch = \"ontouchstart\" in window || window.navigator.msMaxTouchPoints;\n\n            base.browser = {\n                \"support3d\" : support3d,\n                \"isTouch\" : isTouch\n            };\n        },\n\n        moveEvents : function () {\n            var base = this;\n            if (base.options.mouseDrag !== false || base.options.touchDrag !== false) {\n                base.gestures();\n                base.disabledEvents();\n            }\n        },\n\n        eventTypes : function () {\n            var base = this,\n                types = [\"s\", \"e\", \"x\"];\n\n            base.ev_types = {};\n\n            if (base.options.mouseDrag === true && base.options.touchDrag === true) {\n                types = [\n                    \"touchstart.owl mousedown.owl\",\n                    \"touchmove.owl mousemove.owl\",\n                    \"touchend.owl touchcancel.owl mouseup.owl\"\n                ];\n            } else if (base.options.mouseDrag === false && base.options.touchDrag === true) {\n                types = [\n                    \"touchstart.owl\",\n                    \"touchmove.owl\",\n                    \"touchend.owl touchcancel.owl\"\n                ];\n            } else if (base.options.mouseDrag === true && base.options.touchDrag === false) {\n                types = [\n                    \"mousedown.owl\",\n                    \"mousemove.owl\",\n                    \"mouseup.owl\"\n                ];\n            }\n\n            base.ev_types.start = types[0];\n            base.ev_types.move = types[1];\n            base.ev_types.end = types[2];\n        },\n\n        disabledEvents :  function () {\n            var base = this;\n            base.$elem.on(\"dragstart.owl\", function (event) { event.preventDefault(); });\n            base.$elem.on(\"mousedown.disableTextSelect\", function (e) {\n                return $(e.target).is('input, textarea, select, option');\n            });\n        },\n\n        gestures : function () {\n            /*jslint unparam: true*/\n            var base = this,\n                locals = {\n                    offsetX : 0,\n                    offsetY : 0,\n                    baseElWidth : 0,\n                    relativePos : 0,\n                    position: null,\n                    minSwipe : null,\n                    maxSwipe: null,\n                    sliding : null,\n                    dargging: null,\n                    targetElement : null\n                };\n\n            base.isCssFinish = true;\n\n            function getTouches(event) {\n                if (event.touches !== undefined) {\n                    return {\n                        x : event.touches[0].pageX,\n                        y : event.touches[0].pageY\n                    };\n                }\n\n                if (event.touches === undefined) {\n                    if (event.pageX !== undefined) {\n                        return {\n                            x : event.pageX,\n                            y : event.pageY\n                        };\n                    }\n                    if (event.pageX === undefined) {\n                        return {\n                            x : event.clientX,\n                            y : event.clientY\n                        };\n                    }\n                }\n            }\n\n            function swapEvents(type) {\n                if (type === \"on\") {\n                    $(document).on(base.ev_types.move, dragMove);\n                    $(document).on(base.ev_types.end, dragEnd);\n                } else if (type === \"off\") {\n                    $(document).off(base.ev_types.move);\n                    $(document).off(base.ev_types.end);\n                }\n            }\n\n            function dragStart(event) {\n                var ev = event.originalEvent || event || window.event,\n                    position;\n\n                if (ev.which === 3) {\n                    return false;\n                }\n                if (base.itemsAmount <= base.options.items) {\n                    return;\n                }\n                if (base.isCssFinish === false && !base.options.dragBeforeAnimFinish) {\n                    return false;\n                }\n                if (base.isCss3Finish === false && !base.options.dragBeforeAnimFinish) {\n                    return false;\n                }\n\n                if (base.options.autoPlay !== false) {\n                    window.clearInterval(base.autoPlayInterval);\n                }\n\n                if (base.browser.isTouch !== true && !base.$owlWrapper.hasClass(\"grabbing\")) {\n                    base.$owlWrapper.addClass(\"grabbing\");\n                }\n\n                base.newPosX = 0;\n                base.newRelativeX = 0;\n\n                $(this).css(base.removeTransition());\n\n                position = $(this).position();\n                locals.relativePos = position.left;\n\n                locals.offsetX = getTouches(ev).x - position.left;\n                locals.offsetY = getTouches(ev).y - position.top;\n\n                swapEvents(\"on\");\n\n                locals.sliding = false;\n                locals.targetElement = ev.target || ev.srcElement;\n            }\n\n            function dragMove(event) {\n                var ev = event.originalEvent || event || window.event,\n                    minSwipe,\n                    maxSwipe;\n\n                base.newPosX = getTouches(ev).x - locals.offsetX;\n                base.newPosY = getTouches(ev).y - locals.offsetY;\n                base.newRelativeX = base.newPosX - locals.relativePos;\n\n                if (typeof base.options.startDragging === \"function\" && locals.dragging !== true && base.newRelativeX !== 0) {\n                    locals.dragging = true;\n                    base.options.startDragging.apply(base, [base.$elem]);\n                }\n\n                if ((base.newRelativeX > 8 || base.newRelativeX < -8) && (base.browser.isTouch === true)) {\n                    if (ev.preventDefault !== undefined) {\n                        ev.preventDefault();\n                    } else {\n                        ev.returnValue = false;\n                    }\n                    locals.sliding = true;\n                }\n\n                if ((base.newPosY > 10 || base.newPosY < -10) && locals.sliding === false) {\n                    $(document).off(\"touchmove.owl\");\n                }\n\n                minSwipe = function () {\n                    return base.newRelativeX / 5;\n                };\n\n                maxSwipe = function () {\n                    return base.maximumPixels + base.newRelativeX / 5;\n                };\n\n                base.newPosX = Math.max(Math.min(base.newPosX, minSwipe()), maxSwipe());\n                if (base.browser.support3d === true) {\n                    base.transition3d(base.newPosX);\n                } else {\n                    base.css2move(base.newPosX);\n                }\n            }\n\n            function dragEnd(event) {\n                var ev = event.originalEvent || event || window.event,\n                    newPosition,\n                    handlers,\n                    owlStopEvent;\n\n                ev.target = ev.target || ev.srcElement;\n\n                locals.dragging = false;\n\n                if (base.browser.isTouch !== true) {\n                    base.$owlWrapper.removeClass(\"grabbing\");\n                }\n\n                if (base.newRelativeX < 0) {\n                    base.dragDirection = base.owl.dragDirection = \"left\";\n                } else {\n                    base.dragDirection = base.owl.dragDirection = \"right\";\n                }\n\n                if (base.newRelativeX !== 0) {\n                    newPosition = base.getNewPosition();\n                    base.goTo(newPosition, false, \"drag\");\n                    if (locals.targetElement === ev.target && base.browser.isTouch !== true) {\n                        $(ev.target).on(\"click.disable\", function (ev) {\n                            ev.stopImmediatePropagation();\n                            ev.stopPropagation();\n                            ev.preventDefault();\n                            $(ev.target).off(\"click.disable\");\n                        });\n                        handlers = $._data(ev.target, \"events\").click;\n                        owlStopEvent = handlers.pop();\n                        handlers.splice(0, 0, owlStopEvent);\n                    }\n                }\n                swapEvents(\"off\");\n            }\n            base.$elem.on(base.ev_types.start, \".owl-wrapper\", dragStart);\n        },\n\n        getNewPosition : function () {\n            var base = this,\n                newPosition = base.closestItem();\n\n            if (newPosition > base.maximumItem) {\n                base.currentItem = base.maximumItem;\n                newPosition  = base.maximumItem;\n            } else if (base.newPosX >= 0) {\n                newPosition = 0;\n                base.currentItem = 0;\n            }\n            return newPosition;\n        },\n        closestItem : function () {\n            var base = this,\n                array = base.options.scrollPerPage === true ? base.pagesInArray : base.positionsInArray,\n                goal = base.newPosX,\n                closest = null;\n\n            $.each(array, function (i, v) {\n                if (goal - (base.itemWidth / 20) > array[i + 1] && goal - (base.itemWidth / 20) < v && base.moveDirection() === \"left\") {\n                    closest = v;\n                    if (base.options.scrollPerPage === true) {\n                        base.currentItem = $.inArray(closest, base.positionsInArray);\n                    } else {\n                        base.currentItem = i;\n                    }\n                } else if (goal + (base.itemWidth / 20) < v && goal + (base.itemWidth / 20) > (array[i + 1] || array[i] - base.itemWidth) && base.moveDirection() === \"right\") {\n                    if (base.options.scrollPerPage === true) {\n                        closest = array[i + 1] || array[array.length - 1];\n                        base.currentItem = $.inArray(closest, base.positionsInArray);\n                    } else {\n                        closest = array[i + 1];\n                        base.currentItem = i + 1;\n                    }\n                }\n            });\n            return base.currentItem;\n        },\n\n        moveDirection : function () {\n            var base = this,\n                direction;\n            if (base.newRelativeX < 0) {\n                direction = \"right\";\n                base.playDirection = \"next\";\n            } else {\n                direction = \"left\";\n                base.playDirection = \"prev\";\n            }\n            return direction;\n        },\n\n        customEvents : function () {\n            /*jslint unparam: true*/\n            var base = this;\n            base.$elem.on(\"owl.next\", function () {\n                base.next();\n            });\n            base.$elem.on(\"owl.prev\", function () {\n                base.prev();\n            });\n            base.$elem.on(\"owl.play\", function (event, speed) {\n                base.options.autoPlay = speed;\n                base.play();\n                base.hoverStatus = \"play\";\n            });\n            base.$elem.on(\"owl.stop\", function () {\n                base.stop();\n                base.hoverStatus = \"stop\";\n            });\n            base.$elem.on(\"owl.goTo\", function (event, item) {\n                base.goTo(item);\n            });\n            base.$elem.on(\"owl.jumpTo\", function (event, item) {\n                base.jumpTo(item);\n            });\n        },\n\n        stopOnHover : function () {\n            var base = this;\n            if (base.options.stopOnHover === true && base.browser.isTouch !== true && base.options.autoPlay !== false) {\n                base.$elem.on(\"mouseover\", function () {\n                    base.stop();\n                });\n                base.$elem.on(\"mouseout\", function () {\n                    if (base.hoverStatus !== \"stop\") {\n                        base.play();\n                    }\n                });\n            }\n        },\n\n        lazyLoad : function () {\n            var base = this,\n                i,\n                $item,\n                itemNumber,\n                $lazyImg,\n                follow;\n\n            if (base.options.lazyLoad === false) {\n                return false;\n            }\n            for (i = 0; i < base.itemsAmount; i += 1) {\n                $item = $(base.$owlItems[i]);\n\n                if ($item.data(\"owl-loaded\") === \"loaded\") {\n                    continue;\n                }\n\n                itemNumber = $item.data(\"owl-item\");\n                $lazyImg = $item.find(\".lazyOwl\");\n\n                if (typeof $lazyImg.data(\"src\") !== \"string\") {\n                    $item.data(\"owl-loaded\", \"loaded\");\n                    continue;\n                }\n                if ($item.data(\"owl-loaded\") === undefined) {\n                    $lazyImg.hide();\n                    $item.addClass(\"loading\").data(\"owl-loaded\", \"checked\");\n                }\n                if (base.options.lazyFollow === true) {\n                    follow = itemNumber >= base.currentItem;\n                } else {\n                    follow = true;\n                }\n                if (follow && itemNumber < base.currentItem + base.options.items && $lazyImg.length) {\n                    base.lazyPreload($item, $lazyImg);\n                }\n            }\n        },\n\n        lazyPreload : function ($item, $lazyImg) {\n            var base = this,\n                iterations = 0,\n                isBackgroundImg;\n\n            if ($lazyImg.prop(\"tagName\") === \"DIV\") {\n                $lazyImg.css(\"background-image\", \"url(\" + $lazyImg.data(\"src\") + \")\");\n                isBackgroundImg = true;\n            } else {\n                $lazyImg[0].src = $lazyImg.data(\"src\");\n            }\n\n            function showImage() {\n                $item.data(\"owl-loaded\", \"loaded\").removeClass(\"loading\");\n                $lazyImg.removeAttr(\"data-src\");\n                if (base.options.lazyEffect === \"fade\") {\n                    $lazyImg.fadeIn(400);\n                } else {\n                    $lazyImg.show();\n                }\n                if (typeof base.options.afterLazyLoad === \"function\") {\n                    base.options.afterLazyLoad.apply(this, [base.$elem]);\n                }\n            }\n\n            function checkLazyImage() {\n                iterations += 1;\n                if (base.completeImg($lazyImg.get(0)) || isBackgroundImg === true) {\n                    showImage();\n                } else if (iterations <= 100) {//if image loads in less than 10 seconds \n                    window.setTimeout(checkLazyImage, 100);\n                } else {\n                    showImage();\n                }\n            }\n\n            checkLazyImage();\n        },\n\n        autoHeight : function () {\n            var base = this,\n                $currentimg = $(base.$owlItems[base.currentItem]).find(\"img\"),\n                iterations;\n\n            function addHeight() {\n                var $currentItem = $(base.$owlItems[base.currentItem]).height();\n                base.wrapperOuter.css(\"height\", $currentItem + \"px\");\n                if (!base.wrapperOuter.hasClass(\"autoHeight\")) {\n                    window.setTimeout(function () {\n                        base.wrapperOuter.addClass(\"autoHeight\");\n                    }, 0);\n                }\n            }\n\n            function checkImage() {\n                iterations += 1;\n                if (base.completeImg($currentimg.get(0))) {\n                    addHeight();\n                } else if (iterations <= 100) { //if image loads in less than 10 seconds \n                    window.setTimeout(checkImage, 100);\n                } else {\n                    base.wrapperOuter.css(\"height\", \"\"); //Else remove height attribute\n                }\n            }\n\n            if ($currentimg.get(0) !== undefined) {\n                iterations = 0;\n                checkImage();\n            } else {\n                addHeight();\n            }\n        },\n\n        completeImg : function (img) {\n            var naturalWidthType;\n\n            if (!img.complete) {\n                return false;\n            }\n            naturalWidthType = typeof img.naturalWidth;\n            if (naturalWidthType !== \"undefined\" && img.naturalWidth === 0) {\n                return false;\n            }\n            return true;\n        },\n\n        onVisibleItems : function () {\n            var base = this,\n                i;\n\n            if (base.options.addClassActive === true) {\n                base.$owlItems.removeClass(\"active\");\n            }\n            base.visibleItems = [];\n            for (i = base.currentItem; i < base.currentItem + base.options.items; i += 1) {\n                base.visibleItems.push(i);\n\n                if (base.options.addClassActive === true) {\n                    $(base.$owlItems[i]).addClass(\"active\");\n                }\n            }\n            base.owl.visibleItems = base.visibleItems;\n        },\n\n        transitionTypes : function (className) {\n            var base = this;\n            //Currently available: \"fade\", \"backSlide\", \"goDown\", \"fadeUp\"\n            base.outClass = \"owl-\" + className + \"-out\";\n            base.inClass = \"owl-\" + className + \"-in\";\n        },\n\n        singleItemTransition : function () {\n            var base = this,\n                outClass = base.outClass,\n                inClass = base.inClass,\n                $currentItem = base.$owlItems.eq(base.currentItem),\n                $prevItem = base.$owlItems.eq(base.prevItem),\n                prevPos = Math.abs(base.positionsInArray[base.currentItem]) + base.positionsInArray[base.prevItem],\n                origin = Math.abs(base.positionsInArray[base.currentItem]) + base.itemWidth / 2,\n                animEnd = 'webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend';\n\n            base.isTransition = true;\n\n            base.$owlWrapper\n                .addClass('owl-origin')\n                .css({\n                    \"-webkit-transform-origin\" : origin + \"px\",\n                    \"-moz-perspective-origin\" : origin + \"px\",\n                    \"perspective-origin\" : origin + \"px\"\n                });\n            function transStyles(prevPos) {\n                return {\n                    \"position\" : \"relative\",\n                    \"left\" : prevPos + \"px\"\n                };\n            }\n\n            $prevItem\n                .css(transStyles(prevPos, 10))\n                .addClass(outClass)\n                .on(animEnd, function () {\n                    base.endPrev = true;\n                    $prevItem.off(animEnd);\n                    base.clearTransStyle($prevItem, outClass);\n                });\n\n            $currentItem\n                .addClass(inClass)\n                .on(animEnd, function () {\n                    base.endCurrent = true;\n                    $currentItem.off(animEnd);\n                    base.clearTransStyle($currentItem, inClass);\n                });\n        },\n\n        clearTransStyle : function (item, classToRemove) {\n            var base = this;\n            item.css({\n                \"position\" : \"\",\n                \"left\" : \"\"\n            }).removeClass(classToRemove);\n\n            if (base.endPrev && base.endCurrent) {\n                base.$owlWrapper.removeClass('owl-origin');\n                base.endPrev = false;\n                base.endCurrent = false;\n                base.isTransition = false;\n            }\n        },\n\n        owlStatus : function () {\n            var base = this;\n            base.owl = {\n                \"userOptions\"   : base.userOptions,\n                \"baseElement\"   : base.$elem,\n                \"userItems\"     : base.$userItems,\n                \"owlItems\"      : base.$owlItems,\n                \"currentItem\"   : base.currentItem,\n                \"prevItem\"      : base.prevItem,\n                \"visibleItems\"  : base.visibleItems,\n                \"isTouch\"       : base.browser.isTouch,\n                \"browser\"       : base.browser,\n                \"dragDirection\" : base.dragDirection\n            };\n        },\n\n        clearEvents : function () {\n            var base = this;\n            base.$elem.off(\".owl owl mousedown.disableTextSelect\");\n            $(document).off(\".owl owl\");\n            $(window).off(\"resize\", base.resizer);\n        },\n\n        unWrap : function () {\n            var base = this;\n            if (base.$elem.children().length !== 0) {\n                base.$owlWrapper.unwrap();\n                base.$userItems.unwrap().unwrap();\n                if (base.owlControls) {\n                    base.owlControls.remove();\n                }\n            }\n            base.clearEvents();\n            base.$elem\n                .attr(\"style\", base.$elem.data(\"owl-originalStyles\") || \"\")\n                .attr(\"class\", base.$elem.data(\"owl-originalClasses\"));\n        },\n\n        destroy : function () {\n            var base = this;\n            base.stop();\n            window.clearInterval(base.checkVisible);\n            base.unWrap();\n            base.$elem.removeData();\n        },\n\n        reinit : function (newOptions) {\n            var base = this,\n                options = $.extend({}, base.userOptions, newOptions);\n            base.unWrap();\n            base.init(options, base.$elem);\n        },\n\n        addItem : function (htmlString, targetPosition) {\n            var base = this,\n                position;\n\n            if (!htmlString) {return false; }\n\n            if (base.$elem.children().length === 0) {\n                base.$elem.append(htmlString);\n                base.setVars();\n                return false;\n            }\n            base.unWrap();\n            if (targetPosition === undefined || targetPosition === -1) {\n                position = -1;\n            } else {\n                position = targetPosition;\n            }\n            if (position >= base.$userItems.length || position === -1) {\n                base.$userItems.eq(-1).after(htmlString);\n            } else {\n                base.$userItems.eq(position).before(htmlString);\n            }\n\n            base.setVars();\n        },\n\n        removeItem : function (targetPosition) {\n            var base = this,\n                position;\n\n            if (base.$elem.children().length === 0) {\n                return false;\n            }\n            if (targetPosition === undefined || targetPosition === -1) {\n                position = -1;\n            } else {\n                position = targetPosition;\n            }\n\n            base.unWrap();\n            base.$userItems.eq(position).remove();\n            base.setVars();\n        }\n\n    };\n\n    $.fn.owlCarousel = function (options) {\n        return this.each(function () {\n            if ($(this).data(\"owl-init\") === true) {\n                return false;\n            }\n            $(this).data(\"owl-init\", true);\n            var carousel = Object.create(Carousel);\n            carousel.init(options, this);\n            $.data(this, \"owlCarousel\", carousel);\n        });\n    };\n\n    $.fn.owlCarousel.options = {\n\n        items : 5,\n        itemsCustom : false,\n        itemsDesktop : [1199, 4],\n        itemsDesktopSmall : [979, 3],\n        itemsTablet : [768, 2],\n        itemsTabletSmall : false,\n        itemsMobile : [479, 1],\n        singleItem : false,\n        itemsScaleUp : false,\n\n        slideSpeed : 200,\n        paginationSpeed : 800,\n        rewindSpeed : 1000,\n\n        autoPlay : false,\n        stopOnHover : false,\n\n        navigation : false,\n        navigationText : [\"prev\", \"next\"],\n        rewindNav : true,\n        scrollPerPage : false,\n\n        pagination : true,\n        paginationNumbers : false,\n\n        responsive : true,\n        responsiveRefreshRate : 200,\n        responsiveBaseWidth : window,\n\n        baseClass : \"owl-carousel\",\n        theme : \"owl-theme\",\n\n        lazyLoad : false,\n        lazyFollow : true,\n        lazyEffect : \"fade\",\n\n        autoHeight : false,\n\n        jsonPath : false,\n        jsonSuccess : false,\n\n        dragBeforeAnimFinish : true,\n        mouseDrag : true,\n        touchDrag : true,\n\n        addClassActive : false,\n        transitionStyle : false,\n\n        beforeUpdate : false,\n        afterUpdate : false,\n        beforeInit : false,\n        afterInit : false,\n        beforeMove : false,\n        afterMove : false,\n        afterAction : false,\n        startDragging : false,\n        afterLazyLoad: false\n    };\n}(jQuery, window, document));","Plazathemes_Loadjs/js/owl-carousel/owl.carousel.min.js":"\"function\"!=typeof Object.create&&(Object.create=function(t){function e(){}return e.prototype=t,new e}),function(t,e,o){var i={init:function(e,o){var i=this;i.$elem=t(o),i.options=t.extend({},t.fn.owlCarousel.options,i.$elem.data(),e),i.userOptions=e,i.loadContent()},loadContent:function(){function e(t){var e,o=\"\";if(\"function\"==typeof i.options.jsonSuccess)i.options.jsonSuccess.apply(this,[t]);else{for(e in t.owl)t.owl.hasOwnProperty(e)&&(o+=t.owl[e].item);i.$elem.html(o)}i.logIn()}var o,i=this;\"function\"==typeof i.options.beforeInit&&i.options.beforeInit.apply(this,[i.$elem]),\"string\"==typeof i.options.jsonPath?(o=i.options.jsonPath,t.getJSON(o,e)):i.logIn()},logIn:function(){var t=this;t.$elem.data({\"owl-originalStyles\":t.$elem.attr(\"style\"),\"owl-originalClasses\":t.$elem.attr(\"class\")}),t.$elem.css({opacity:0}),t.orignalItems=t.options.items,t.checkBrowser(),t.wrapperWidth=0,t.checkVisible=null,t.setVars()},setVars:function(){var t=this;return 0===t.$elem.children().length?!1:(t.baseClass(),t.eventTypes(),t.$userItems=t.$elem.children(),t.itemsAmount=t.$userItems.length,t.wrapItems(),t.$owlItems=t.$elem.find(\".owl-item\"),t.$owlWrapper=t.$elem.find(\".owl-wrapper\"),t.playDirection=\"next\",t.prevItem=0,t.prevArr=[0],t.currentItem=0,t.customEvents(),void t.onStartup())},onStartup:function(){var t=this;t.updateItems(),t.calculateAll(),t.buildControls(),t.updateControls(),t.response(),t.moveEvents(),t.stopOnHover(),t.owlStatus(),t.options.transitionStyle!==!1&&t.transitionTypes(t.options.transitionStyle),t.options.autoPlay===!0&&(t.options.autoPlay=5e3),t.play(),t.$elem.find(\".owl-wrapper\").css(\"display\",\"block\"),t.$elem.is(\":visible\")?t.$elem.css(\"opacity\",1):t.watchVisibility(),t.onstartup=!1,t.eachMoveUpdate(),\"function\"==typeof t.options.afterInit&&t.options.afterInit.apply(this,[t.$elem])},eachMoveUpdate:function(){var t=this;t.options.lazyLoad===!0&&t.lazyLoad(),t.options.autoHeight===!0&&t.autoHeight(),t.onVisibleItems(),\"function\"==typeof t.options.afterAction&&t.options.afterAction.apply(this,[t.$elem])},updateVars:function(){var t=this;\"function\"==typeof t.options.beforeUpdate&&t.options.beforeUpdate.apply(this,[t.$elem]),t.watchVisibility(),t.updateItems(),t.calculateAll(),t.updatePosition(),t.updateControls(),t.eachMoveUpdate(),\"function\"==typeof t.options.afterUpdate&&t.options.afterUpdate.apply(this,[t.$elem])},reload:function(){var t=this;e.setTimeout(function(){t.updateVars()},0)},watchVisibility:function(){var t=this;return t.$elem.is(\":visible\")!==!1?!1:(t.$elem.css({opacity:0}),e.clearInterval(t.autoPlayInterval),e.clearInterval(t.checkVisible),void(t.checkVisible=e.setInterval(function(){t.$elem.is(\":visible\")&&(t.reload(),t.$elem.animate({opacity:1},200),e.clearInterval(t.checkVisible))},500)))},wrapItems:function(){var t=this;t.$userItems.wrapAll('<div class=\"owl-wrapper\">').wrap('<div class=\"owl-item\"></div>'),t.$elem.find(\".owl-wrapper\").wrap('<div class=\"owl-wrapper-outer\">'),t.wrapperOuter=t.$elem.find(\".owl-wrapper-outer\"),t.$elem.css(\"display\",\"block\")},baseClass:function(){var t=this,e=t.$elem.hasClass(t.options.baseClass),o=t.$elem.hasClass(t.options.theme);e||t.$elem.addClass(t.options.baseClass),o||t.$elem.addClass(t.options.theme)},updateItems:function(){var e,o,i=this;if(i.options.responsive===!1)return!1;if(i.options.singleItem===!0)return i.options.items=i.orignalItems=1,i.options.itemsCustom=!1,i.options.itemsDesktop=!1,i.options.itemsDesktopSmall=!1,i.options.itemsTablet=!1,i.options.itemsTabletSmall=!1,i.options.itemsMobile=!1,!1;if(e=t(i.options.responsiveBaseWidth).width(),e>(i.options.itemsDesktop[0]||i.orignalItems)&&(i.options.items=i.orignalItems),i.options.itemsCustom!==!1)for(i.options.itemsCustom.sort(function(t,e){return t[0]-e[0]}),o=0;o<i.options.itemsCustom.length;o+=1)i.options.itemsCustom[o][0]<=e&&(i.options.items=i.options.itemsCustom[o][1]);else e<=i.options.itemsDesktop[0]&&i.options.itemsDesktop!==!1&&(i.options.items=i.options.itemsDesktop[1]),e<=i.options.itemsDesktopSmall[0]&&i.options.itemsDesktopSmall!==!1&&(i.options.items=i.options.itemsDesktopSmall[1]),e<=i.options.itemsTablet[0]&&i.options.itemsTablet!==!1&&(i.options.items=i.options.itemsTablet[1]),e<=i.options.itemsTabletSmall[0]&&i.options.itemsTabletSmall!==!1&&(i.options.items=i.options.itemsTabletSmall[1]),e<=i.options.itemsMobile[0]&&i.options.itemsMobile!==!1&&(i.options.items=i.options.itemsMobile[1]);i.options.items>i.itemsAmount&&i.options.itemsScaleUp===!0&&(i.options.items=i.itemsAmount)},response:function(){var o,i,n=this;return n.options.responsive!==!0?!1:(i=t(e).width(),n.resizer=function(){t(e).width()!==i&&(n.options.autoPlay!==!1&&e.clearInterval(n.autoPlayInterval),e.clearTimeout(o),o=e.setTimeout(function(){i=t(e).width(),n.updateVars()},n.options.responsiveRefreshRate))},void t(e).resize(n.resizer))},updatePosition:function(){var t=this;t.jumpTo(t.currentItem),t.options.autoPlay!==!1&&t.checkAp()},appendItemsSizes:function(){var e=this,o=0,i=e.itemsAmount-e.options.items;e.$owlItems.each(function(n){var s=t(this);s.css({width:e.itemWidth}).data(\"owl-item\",Number(n)),(n%e.options.items===0||n===i)&&(n>i||(o+=1)),s.data(\"owl-roundPages\",o)})},appendWrapperSizes:function(){var t=this,e=t.$owlItems.length*t.itemWidth;t.$owlWrapper.css({width:2*e,left:0}),t.appendItemsSizes()},calculateAll:function(){var t=this;t.calculateWidth(),t.appendWrapperSizes(),t.loops(),t.max()},calculateWidth:function(){var t=this;t.itemWidth=Math.round(t.$elem.width()/t.options.items)},max:function(){var t=this,e=-1*(t.itemsAmount*t.itemWidth-t.options.items*t.itemWidth);return t.options.items>t.itemsAmount?(t.maximumItem=0,e=0,t.maximumPixels=0):(t.maximumItem=t.itemsAmount-t.options.items,t.maximumPixels=e),e},min:function(){return 0},loops:function(){var e,o,i,n=this,s=0,a=0;for(n.positionsInArray=[0],n.pagesInArray=[],e=0;e<n.itemsAmount;e+=1)a+=n.itemWidth,n.positionsInArray.push(-a),n.options.scrollPerPage===!0&&(o=t(n.$owlItems[e]),i=o.data(\"owl-roundPages\"),i!==s&&(n.pagesInArray[s]=n.positionsInArray[e],s=i))},buildControls:function(){var e=this;(e.options.navigation===!0||e.options.pagination===!0)&&(e.owlControls=t('<div class=\"owl-controls\"/>').toggleClass(\"clickable\",!e.browser.isTouch).appendTo(e.$elem)),e.options.pagination===!0&&e.buildPagination(),e.options.navigation===!0&&e.buildButtons()},buildButtons:function(){var e=this,o=t('<div class=\"owl-buttons\"/>');e.owlControls.append(o),e.buttonPrev=t(\"<div/>\",{\"class\":\"owl-prev\",html:e.options.navigationText[0]||\"\"}),e.buttonNext=t(\"<div/>\",{\"class\":\"owl-next\",html:e.options.navigationText[1]||\"\"}),o.append(e.buttonPrev).append(e.buttonNext),o.on(\"touchstart.owlControls mousedown.owlControls\",'div[class^=\"owl\"]',function(t){t.preventDefault()}),o.on(\"touchend.owlControls mouseup.owlControls\",'div[class^=\"owl\"]',function(o){o.preventDefault(),t(this).hasClass(\"owl-next\")?e.next():e.prev()})},buildPagination:function(){var e=this;e.paginationWrapper=t('<div class=\"owl-pagination\"/>'),e.owlControls.append(e.paginationWrapper),e.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\",\".owl-page\",function(o){o.preventDefault(),Number(t(this).data(\"owl-page\"))!==e.currentItem&&e.goTo(Number(t(this).data(\"owl-page\")),!0)})},updatePagination:function(){var e,o,i,n,s,a,r=this;if(r.options.pagination===!1)return!1;for(r.paginationWrapper.html(\"\"),e=0,o=r.itemsAmount-r.itemsAmount%r.options.items,n=0;n<r.itemsAmount;n+=1)n%r.options.items===0&&(e+=1,o===n&&(i=r.itemsAmount-r.options.items),s=t(\"<div/>\",{\"class\":\"owl-page\"}),a=t(\"<span></span>\",{text:r.options.paginationNumbers===!0?e:\"\",\"class\":r.options.paginationNumbers===!0?\"owl-numbers\":\"\"}),s.append(a),s.data(\"owl-page\",o===n?i:n),s.data(\"owl-roundPages\",e),r.paginationWrapper.append(s));r.checkPagination()},checkPagination:function(){var e=this;return e.options.pagination===!1?!1:void e.paginationWrapper.find(\".owl-page\").each(function(){t(this).data(\"owl-roundPages\")===t(e.$owlItems[e.currentItem]).data(\"owl-roundPages\")&&(e.paginationWrapper.find(\".owl-page\").removeClass(\"active\"),t(this).addClass(\"active\"))})},checkNavigation:function(){var t=this;return t.options.navigation===!1?!1:void(t.options.rewindNav===!1&&(0===t.currentItem&&0===t.maximumItem?(t.buttonPrev.addClass(\"disabled\"),t.buttonNext.addClass(\"disabled\")):0===t.currentItem&&0!==t.maximumItem?(t.buttonPrev.addClass(\"disabled\"),t.buttonNext.removeClass(\"disabled\")):t.currentItem===t.maximumItem?(t.buttonPrev.removeClass(\"disabled\"),t.buttonNext.addClass(\"disabled\")):0!==t.currentItem&&t.currentItem!==t.maximumItem&&(t.buttonPrev.removeClass(\"disabled\"),t.buttonNext.removeClass(\"disabled\"))))},updateControls:function(){var t=this;t.updatePagination(),t.checkNavigation(),t.owlControls&&(t.options.items>=t.itemsAmount?t.owlControls.hide():t.owlControls.show())},destroyControls:function(){var t=this;t.owlControls&&t.owlControls.remove()},next:function(t){var e=this;if(e.isTransition)return!1;if(e.currentItem+=e.options.scrollPerPage===!0?e.options.items:1,e.currentItem>e.maximumItem+(e.options.scrollPerPage===!0?e.options.items-1:0)){if(e.options.rewindNav!==!0)return e.currentItem=e.maximumItem,!1;e.currentItem=0,t=\"rewind\"}e.goTo(e.currentItem,t)},prev:function(t){var e=this;if(e.isTransition)return!1;if(e.options.scrollPerPage===!0&&e.currentItem>0&&e.currentItem<e.options.items?e.currentItem=0:e.currentItem-=e.options.scrollPerPage===!0?e.options.items:1,e.currentItem<0){if(e.options.rewindNav!==!0)return e.currentItem=0,!1;e.currentItem=e.maximumItem,t=\"rewind\"}e.goTo(e.currentItem,t)},goTo:function(t,o,i){var n,s=this;return s.isTransition?!1:(\"function\"==typeof s.options.beforeMove&&s.options.beforeMove.apply(this,[s.$elem]),t>=s.maximumItem?t=s.maximumItem:0>=t&&(t=0),s.currentItem=s.owl.currentItem=t,s.options.transitionStyle!==!1&&\"drag\"!==i&&1===s.options.items&&s.browser.support3d===!0?(s.swapSpeed(0),s.browser.support3d===!0?s.transition3d(s.positionsInArray[t]):s.css2slide(s.positionsInArray[t],1),s.afterGo(),s.singleItemTransition(),!1):(n=s.positionsInArray[t],s.browser.support3d===!0?(s.isCss3Finish=!1,o===!0?(s.swapSpeed(\"paginationSpeed\"),e.setTimeout(function(){s.isCss3Finish=!0},s.options.paginationSpeed)):\"rewind\"===o?(s.swapSpeed(s.options.rewindSpeed),e.setTimeout(function(){s.isCss3Finish=!0},s.options.rewindSpeed)):(s.swapSpeed(\"slideSpeed\"),e.setTimeout(function(){s.isCss3Finish=!0},s.options.slideSpeed)),s.transition3d(n)):o===!0?s.css2slide(n,s.options.paginationSpeed):\"rewind\"===o?s.css2slide(n,s.options.rewindSpeed):s.css2slide(n,s.options.slideSpeed),void s.afterGo()))},jumpTo:function(t){var e=this;\"function\"==typeof e.options.beforeMove&&e.options.beforeMove.apply(this,[e.$elem]),t>=e.maximumItem||-1===t?t=e.maximumItem:0>=t&&(t=0),e.swapSpeed(0),e.browser.support3d===!0?e.transition3d(e.positionsInArray[t]):e.css2slide(e.positionsInArray[t],1),e.currentItem=e.owl.currentItem=t,e.afterGo()},afterGo:function(){var t=this;t.prevArr.push(t.currentItem),t.prevItem=t.owl.prevItem=t.prevArr[t.prevArr.length-2],t.prevArr.shift(0),t.prevItem!==t.currentItem&&(t.checkPagination(),t.checkNavigation(),t.eachMoveUpdate(),t.options.autoPlay!==!1&&t.checkAp()),\"function\"==typeof t.options.afterMove&&t.prevItem!==t.currentItem&&t.options.afterMove.apply(this,[t.$elem])},stop:function(){var t=this;t.apStatus=\"stop\",e.clearInterval(t.autoPlayInterval)},checkAp:function(){var t=this;\"stop\"!==t.apStatus&&t.play()},play:function(){var t=this;return t.apStatus=\"play\",t.options.autoPlay===!1?!1:(e.clearInterval(t.autoPlayInterval),void(t.autoPlayInterval=e.setInterval(function(){t.next(!0)},t.options.autoPlay)))},swapSpeed:function(t){var e=this;\"slideSpeed\"===t?e.$owlWrapper.css(e.addCssSpeed(e.options.slideSpeed)):\"paginationSpeed\"===t?e.$owlWrapper.css(e.addCssSpeed(e.options.paginationSpeed)):\"string\"!=typeof t&&e.$owlWrapper.css(e.addCssSpeed(t))},addCssSpeed:function(t){return{\"-webkit-transition\":\"all \"+t+\"ms ease\",\"-moz-transition\":\"all \"+t+\"ms ease\",\"-o-transition\":\"all \"+t+\"ms ease\",transition:\"all \"+t+\"ms ease\"}},removeTransition:function(){return{\"-webkit-transition\":\"\",\"-moz-transition\":\"\",\"-o-transition\":\"\",transition:\"\"}},doTranslate:function(t){return{\"-webkit-transform\":\"translate3d(\"+t+\"px, 0px, 0px)\",\"-moz-transform\":\"translate3d(\"+t+\"px, 0px, 0px)\",\"-o-transform\":\"translate3d(\"+t+\"px, 0px, 0px)\",\"-ms-transform\":\"translate3d(\"+t+\"px, 0px, 0px)\",transform:\"translate3d(\"+t+\"px, 0px,0px)\"}},transition3d:function(t){var e=this;e.$owlWrapper.css(e.doTranslate(t))},css2move:function(t){var e=this;e.$owlWrapper.css({left:t})},css2slide:function(t,e){var o=this;o.isCssFinish=!1,o.$owlWrapper.stop(!0,!0).animate({left:t},{duration:e||o.options.slideSpeed,complete:function(){o.isCssFinish=!0}})},checkBrowser:function(){var t,i,n,s,a=this,r=\"translate3d(0px, 0px, 0px)\",l=o.createElement(\"div\");l.style.cssText=\"  -moz-transform:\"+r+\"; -ms-transform:\"+r+\"; -o-transform:\"+r+\"; -webkit-transform:\"+r+\"; transform:\"+r,t=/translate3d\\(0px, 0px, 0px\\)/g,i=l.style.cssText.match(t),n=null!==i&&i.length>=1,s=\"ontouchstart\"in e||e.navigator.msMaxTouchPoints,a.browser={support3d:n,isTouch:s}},moveEvents:function(){var t=this;(t.options.mouseDrag!==!1||t.options.touchDrag!==!1)&&(t.gestures(),t.disabledEvents())},eventTypes:function(){var t=this,e=[\"s\",\"e\",\"x\"];t.ev_types={},t.options.mouseDrag===!0&&t.options.touchDrag===!0?e=[\"touchstart.owl mousedown.owl\",\"touchmove.owl mousemove.owl\",\"touchend.owl touchcancel.owl mouseup.owl\"]:t.options.mouseDrag===!1&&t.options.touchDrag===!0?e=[\"touchstart.owl\",\"touchmove.owl\",\"touchend.owl touchcancel.owl\"]:t.options.mouseDrag===!0&&t.options.touchDrag===!1&&(e=[\"mousedown.owl\",\"mousemove.owl\",\"mouseup.owl\"]),t.ev_types.start=e[0],t.ev_types.move=e[1],t.ev_types.end=e[2]},disabledEvents:function(){var e=this;e.$elem.on(\"dragstart.owl\",function(t){t.preventDefault()}),e.$elem.on(\"mousedown.disableTextSelect\",function(e){return t(e.target).is(\"input, textarea, select, option\")})},gestures:function(){function i(t){if(void 0!==t.touches)return{x:t.touches[0].pageX,y:t.touches[0].pageY};if(void 0===t.touches){if(void 0!==t.pageX)return{x:t.pageX,y:t.pageY};if(void 0===t.pageX)return{x:t.clientX,y:t.clientY}}}function n(e){\"on\"===e?(t(o).on(l.ev_types.move,a),t(o).on(l.ev_types.end,r)):\"off\"===e&&(t(o).off(l.ev_types.move),t(o).off(l.ev_types.end))}function s(o){var s,a=o.originalEvent||o||e.event;if(3===a.which)return!1;if(!(l.itemsAmount<=l.options.items)){if(l.isCssFinish===!1&&!l.options.dragBeforeAnimFinish)return!1;if(l.isCss3Finish===!1&&!l.options.dragBeforeAnimFinish)return!1;l.options.autoPlay!==!1&&e.clearInterval(l.autoPlayInterval),l.browser.isTouch===!0||l.$owlWrapper.hasClass(\"grabbing\")||l.$owlWrapper.addClass(\"grabbing\"),l.newPosX=0,l.newRelativeX=0,t(this).css(l.removeTransition()),s=t(this).position(),p.relativePos=s.left,p.offsetX=i(a).x-s.left,p.offsetY=i(a).y-s.top,n(\"on\"),p.sliding=!1,p.targetElement=a.target||a.srcElement}}function a(n){var s,a,r=n.originalEvent||n||e.event;l.newPosX=i(r).x-p.offsetX,l.newPosY=i(r).y-p.offsetY,l.newRelativeX=l.newPosX-p.relativePos,\"function\"==typeof l.options.startDragging&&p.dragging!==!0&&0!==l.newRelativeX&&(p.dragging=!0,l.options.startDragging.apply(l,[l.$elem])),(l.newRelativeX>8||l.newRelativeX<-8)&&l.browser.isTouch===!0&&(void 0!==r.preventDefault?r.preventDefault():r.returnValue=!1,p.sliding=!0),(l.newPosY>10||l.newPosY<-10)&&p.sliding===!1&&t(o).off(\"touchmove.owl\"),s=function(){return l.newRelativeX/5},a=function(){return l.maximumPixels+l.newRelativeX/5},l.newPosX=Math.max(Math.min(l.newPosX,s()),a()),l.browser.support3d===!0?l.transition3d(l.newPosX):l.css2move(l.newPosX)}function r(o){var i,s,a,r=o.originalEvent||o||e.event;r.target=r.target||r.srcElement,p.dragging=!1,l.browser.isTouch!==!0&&l.$owlWrapper.removeClass(\"grabbing\"),l.dragDirection=l.owl.dragDirection=l.newRelativeX<0?\"left\":\"right\",0!==l.newRelativeX&&(i=l.getNewPosition(),l.goTo(i,!1,\"drag\"),p.targetElement===r.target&&l.browser.isTouch!==!0&&(t(r.target).on(\"click.disable\",function(e){e.stopImmediatePropagation(),e.stopPropagation(),e.preventDefault(),t(e.target).off(\"click.disable\")}),s=t._data(r.target,\"events\").click,a=s.pop(),s.splice(0,0,a))),n(\"off\")}var l=this,p={offsetX:0,offsetY:0,baseElWidth:0,relativePos:0,position:null,minSwipe:null,maxSwipe:null,sliding:null,dargging:null,targetElement:null};l.isCssFinish=!0,l.$elem.on(l.ev_types.start,\".owl-wrapper\",s)},getNewPosition:function(){var t=this,e=t.closestItem();return e>t.maximumItem?(t.currentItem=t.maximumItem,e=t.maximumItem):t.newPosX>=0&&(e=0,t.currentItem=0),e},closestItem:function(){var e=this,o=e.options.scrollPerPage===!0?e.pagesInArray:e.positionsInArray,i=e.newPosX,n=null;return t.each(o,function(s,a){i-e.itemWidth/20>o[s+1]&&i-e.itemWidth/20<a&&\"left\"===e.moveDirection()?(n=a,e.currentItem=e.options.scrollPerPage===!0?t.inArray(n,e.positionsInArray):s):i+e.itemWidth/20<a&&i+e.itemWidth/20>(o[s+1]||o[s]-e.itemWidth)&&\"right\"===e.moveDirection()&&(e.options.scrollPerPage===!0?(n=o[s+1]||o[o.length-1],e.currentItem=t.inArray(n,e.positionsInArray)):(n=o[s+1],e.currentItem=s+1))}),e.currentItem},moveDirection:function(){var t,e=this;return e.newRelativeX<0?(t=\"right\",e.playDirection=\"next\"):(t=\"left\",e.playDirection=\"prev\"),t},customEvents:function(){var t=this;t.$elem.on(\"owl.next\",function(){t.next()}),t.$elem.on(\"owl.prev\",function(){t.prev()}),t.$elem.on(\"owl.play\",function(e,o){t.options.autoPlay=o,t.play(),t.hoverStatus=\"play\"}),t.$elem.on(\"owl.stop\",function(){t.stop(),t.hoverStatus=\"stop\"}),t.$elem.on(\"owl.goTo\",function(e,o){t.goTo(o)}),t.$elem.on(\"owl.jumpTo\",function(e,o){t.jumpTo(o)})},stopOnHover:function(){var t=this;t.options.stopOnHover===!0&&t.browser.isTouch!==!0&&t.options.autoPlay!==!1&&(t.$elem.on(\"mouseover\",function(){t.stop()}),t.$elem.on(\"mouseout\",function(){\"stop\"!==t.hoverStatus&&t.play()}))},lazyLoad:function(){var e,o,i,n,s,a=this;if(a.options.lazyLoad===!1)return!1;for(e=0;e<a.itemsAmount;e+=1)o=t(a.$owlItems[e]),\"loaded\"!==o.data(\"owl-loaded\")&&(i=o.data(\"owl-item\"),n=o.find(\".lazyOwl\"),\"string\"==typeof n.data(\"src\")?(void 0===o.data(\"owl-loaded\")&&(n.hide(),o.addClass(\"loading\").data(\"owl-loaded\",\"checked\")),s=a.options.lazyFollow===!0?i>=a.currentItem:!0,s&&i<a.currentItem+a.options.items&&n.length&&n.each(function(){a.lazyPreload(o,t(this))})):o.data(\"owl-loaded\",\"loaded\"))},lazyPreload:function(t,o){function i(){t.data(\"owl-loaded\",\"loaded\").removeClass(\"loading\"),o.removeAttr(\"data-src\"),\"fade\"===a.options.lazyEffect?o.fadeIn(400):o.show(),\"function\"==typeof a.options.afterLazyLoad&&a.options.afterLazyLoad.apply(this,[a.$elem])}function n(){r+=1,a.completeImg(o.get(0))||s===!0?i():100>=r?e.setTimeout(n,100):i()}var s,a=this,r=0;\"DIV\"===o.prop(\"tagName\")?(o.css(\"background-image\",\"url(\"+o.data(\"src\")+\")\"),s=!0):o[0].src=o.data(\"src\"),n()},autoHeight:function(){function o(){var o=t(s.$owlItems[s.currentItem]).height();s.wrapperOuter.css(\"height\",o+\"px\"),s.wrapperOuter.hasClass(\"autoHeight\")||e.setTimeout(function(){s.wrapperOuter.addClass(\"autoHeight\")},0)}function i(){n+=1,s.completeImg(a.get(0))?o():100>=n?e.setTimeout(i,100):s.wrapperOuter.css(\"height\",\"\")}var n,s=this,a=t(s.$owlItems[s.currentItem]).find(\"img\");void 0!==a.get(0)?(n=0,i()):o()},completeImg:function(t){var e;return t.complete?(e=typeof t.naturalWidth,\"undefined\"!==e&&0===t.naturalWidth?!1:!0):!1},onVisibleItems:function(){var e,o=this;for(o.options.addClassActive===!0&&o.$owlItems.removeClass(\"active\"),o.visibleItems=[],e=o.currentItem;e<o.currentItem+o.options.items;e+=1)o.visibleItems.push(e),o.options.addClassActive===!0&&t(o.$owlItems[e]).addClass(\"active\");o.owl.visibleItems=o.visibleItems},transitionTypes:function(t){var e=this;e.outClass=\"owl-\"+t+\"-out\",e.inClass=\"owl-\"+t+\"-in\"},singleItemTransition:function(){function t(t){return{position:\"relative\",left:t+\"px\"}}var e=this,o=e.outClass,i=e.inClass,n=e.$owlItems.eq(e.currentItem),s=e.$owlItems.eq(e.prevItem),a=Math.abs(e.positionsInArray[e.currentItem])+e.positionsInArray[e.prevItem],r=Math.abs(e.positionsInArray[e.currentItem])+e.itemWidth/2,l=\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\";e.isTransition=!0,e.$owlWrapper.addClass(\"owl-origin\").css({\"-webkit-transform-origin\":r+\"px\",\"-moz-perspective-origin\":r+\"px\",\"perspective-origin\":r+\"px\"}),s.css(t(a,10)).addClass(o).on(l,function(){e.endPrev=!0,s.off(l),e.clearTransStyle(s,o)}),n.addClass(i).on(l,function(){e.endCurrent=!0,n.off(l),e.clearTransStyle(n,i)})},clearTransStyle:function(t,e){var o=this;t.css({position:\"\",left:\"\"}).removeClass(e),o.endPrev&&o.endCurrent&&(o.$owlWrapper.removeClass(\"owl-origin\"),o.endPrev=!1,o.endCurrent=!1,o.isTransition=!1)},owlStatus:function(){var t=this;t.owl={userOptions:t.userOptions,baseElement:t.$elem,userItems:t.$userItems,owlItems:t.$owlItems,currentItem:t.currentItem,prevItem:t.prevItem,visibleItems:t.visibleItems,isTouch:t.browser.isTouch,browser:t.browser,dragDirection:t.dragDirection}},clearEvents:function(){var i=this;i.$elem.off(\".owl owl mousedown.disableTextSelect\"),t(o).off(\".owl owl\"),t(e).off(\"resize\",i.resizer)},unWrap:function(){var t=this;0!==t.$elem.children().length&&(t.$owlWrapper.unwrap(),t.$userItems.unwrap().unwrap(),t.owlControls&&t.owlControls.remove()),t.clearEvents(),t.$elem.attr({style:t.$elem.data(\"owl-originalStyles\")||\"\",\"class\":t.$elem.data(\"owl-originalClasses\")})},destroy:function(){var t=this;t.stop(),e.clearInterval(t.checkVisible),t.unWrap(),t.$elem.removeData()},reinit:function(e){var o=this,i=t.extend({},o.userOptions,e);o.unWrap(),o.init(i,o.$elem)},addItem:function(t,e){var o,i=this;return t?0===i.$elem.children().length?(i.$elem.append(t),i.setVars(),!1):(i.unWrap(),o=void 0===e||-1===e?-1:e,o>=i.$userItems.length||-1===o?i.$userItems.eq(-1).after(t):i.$userItems.eq(o).before(t),void i.setVars()):!1},removeItem:function(t){var e,o=this;return 0===o.$elem.children().length?!1:(e=void 0===t||-1===t?-1:t,o.unWrap(),o.$userItems.eq(e).remove(),void o.setVars())}};t.fn.owlCarousel=function(e){return this.each(function(){if(t(this).data(\"owl-init\")===!0)return!1;t(this).data(\"owl-init\",!0);var o=Object.create(i);o.init(e,this),t.data(this,\"owlCarousel\",o)})},t.fn.owlCarousel.options={items:5,itemsCustom:!1,itemsDesktop:[1199,4],itemsDesktopSmall:[979,3],itemsTablet:[768,2],itemsTabletSmall:!1,itemsMobile:[479,1],singleItem:!1,itemsScaleUp:!1,slideSpeed:200,paginationSpeed:800,rewindSpeed:1e3,autoPlay:!1,stopOnHover:!1,navigation:!1,navigationText:[\"prev\",\"next\"],rewindNav:!0,scrollPerPage:!1,pagination:!0,paginationNumbers:!1,responsive:!0,responsiveRefreshRate:200,responsiveBaseWidth:e,baseClass:\"owl-carousel\",theme:\"owl-theme\",lazyLoad:!1,lazyFollow:!0,lazyEffect:\"fade\",autoHeight:!1,jsonPath:!1,jsonSuccess:!1,dragBeforeAnimFinish:!0,mouseDrag:!0,touchDrag:!0,addClassActive:!1,transitionStyle:!1,beforeUpdate:!1,afterUpdate:!1,beforeInit:!1,afterInit:!1,beforeMove:!1,afterMove:!1,afterAction:!1,startDragging:!1,afterLazyLoad:!1}}(jQuery,window,document);","Plazathemes_Newproductslider/js/jquery-1.9.1.min.js":"/*! jQuery v1.9.1 | (c) 2005, 2012 jQuery Foundation, Inc. | jquery.org/license\n//@ sourceMappingURL=jquery.min.map\n*/(function(e,t){var n,r,i=typeof t,o=e.document,a=e.location,s=e.jQuery,u=e.$,l={},c=[],p=\"1.9.1\",f=c.concat,d=c.push,h=c.slice,g=c.indexOf,m=l.toString,y=l.hasOwnProperty,v=p.trim,b=function(e,t){return new b.fn.init(e,t,r)},x=/[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/.source,w=/\\S+/g,T=/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,N=/^(?:(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,C=/^<(\\w+)\\s*\\/?>(?:<\\/\\1>|)$/,k=/^[\\],:{}\\s]*$/,E=/(?:^|:|,)(?:\\s*\\[)+/g,S=/\\\\(?:[\"\\\\\\/bfnrt]|u[\\da-fA-F]{4})/g,A=/\"[^\"\\\\\\r\\n]*\"|true|false|null|-?(?:\\d+\\.|)\\d+(?:[eE][+-]?\\d+|)/g,j=/^-ms-/,D=/-([\\da-z])/gi,L=function(e,t){return t.toUpperCase()},H=function(e){(o.addEventListener||\"load\"===e.type||\"complete\"===o.readyState)&&(q(),b.ready())},q=function(){o.addEventListener?(o.removeEventListener(\"DOMContentLoaded\",H,!1),e.removeEventListener(\"load\",H,!1)):(o.detachEvent(\"onreadystatechange\",H),e.detachEvent(\"onload\",H))};b.fn=b.prototype={jquery:p,constructor:b,init:function(e,n,r){var i,a;if(!e)return this;if(\"string\"==typeof e){if(i=\"<\"===e.charAt(0)&&\">\"===e.charAt(e.length-1)&&e.length>=3?[null,e,null]:N.exec(e),!i||!i[1]&&n)return!n||n.jquery?(n||r).find(e):this.constructor(n).find(e);if(i[1]){if(n=n instanceof b?n[0]:n,b.merge(this,b.parseHTML(i[1],n&&n.nodeType?n.ownerDocument||n:o,!0)),C.test(i[1])&&b.isPlainObject(n))for(i in n)b.isFunction(this[i])?this[i](n[i]):this.attr(i,n[i]);return this}if(a=o.getElementById(i[2]),a&&a.parentNode){if(a.id!==i[2])return r.find(e);this.length=1,this[0]=a}return this.context=o,this.selector=e,this}return e.nodeType?(this.context=this[0]=e,this.length=1,this):b.isFunction(e)?r.ready(e):(e.selector!==t&&(this.selector=e.selector,this.context=e.context),b.makeArray(e,this))},selector:\"\",length:0,size:function(){return this.length},toArray:function(){return h.call(this)},get:function(e){return null==e?this.toArray():0>e?this[this.length+e]:this[e]},pushStack:function(e){var t=b.merge(this.constructor(),e);return t.prevObject=this,t.context=this.context,t},each:function(e,t){return b.each(this,e,t)},ready:function(e){return b.ready.promise().done(e),this},slice:function(){return this.pushStack(h.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(0>e?t:0);return this.pushStack(n>=0&&t>n?[this[n]]:[])},map:function(e){return this.pushStack(b.map(this,function(t,n){return e.call(t,n,t)}))},end:function(){return this.prevObject||this.constructor(null)},push:d,sort:[].sort,splice:[].splice},b.fn.init.prototype=b.fn,b.extend=b.fn.extend=function(){var e,n,r,i,o,a,s=arguments[0]||{},u=1,l=arguments.length,c=!1;for(\"boolean\"==typeof s&&(c=s,s=arguments[1]||{},u=2),\"object\"==typeof s||b.isFunction(s)||(s={}),l===u&&(s=this,--u);l>u;u++)if(null!=(o=arguments[u]))for(i in o)e=s[i],r=o[i],s!==r&&(c&&r&&(b.isPlainObject(r)||(n=b.isArray(r)))?(n?(n=!1,a=e&&b.isArray(e)?e:[]):a=e&&b.isPlainObject(e)?e:{},s[i]=b.extend(c,a,r)):r!==t&&(s[i]=r));return s},b.extend({noConflict:function(t){return e.$===b&&(e.$=u),t&&e.jQuery===b&&(e.jQuery=s),b},isReady:!1,readyWait:1,holdReady:function(e){e?b.readyWait++:b.ready(!0)},ready:function(e){if(e===!0?!--b.readyWait:!b.isReady){if(!o.body)return setTimeout(b.ready);b.isReady=!0,e!==!0&&--b.readyWait>0||(n.resolveWith(o,[b]),b.fn.trigger&&b(o).trigger(\"ready\").off(\"ready\"))}},isFunction:function(e){return\"function\"===b.type(e)},isArray:Array.isArray||function(e){return\"array\"===b.type(e)},isWindow:function(e){return null!=e&&e==e.window},isNumeric:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},type:function(e){return null==e?e+\"\":\"object\"==typeof e||\"function\"==typeof e?l[m.call(e)]||\"object\":typeof e},isPlainObject:function(e){if(!e||\"object\"!==b.type(e)||e.nodeType||b.isWindow(e))return!1;try{if(e.constructor&&!y.call(e,\"constructor\")&&!y.call(e.constructor.prototype,\"isPrototypeOf\"))return!1}catch(n){return!1}var r;for(r in e);return r===t||y.call(e,r)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},error:function(e){throw Error(e)},parseHTML:function(e,t,n){if(!e||\"string\"!=typeof e)return null;\"boolean\"==typeof t&&(n=t,t=!1),t=t||o;var r=C.exec(e),i=!n&&[];return r?[t.createElement(r[1])]:(r=b.buildFragment([e],t,i),i&&b(i).remove(),b.merge([],r.childNodes))},parseJSON:function(n){return e.JSON&&e.JSON.parse?e.JSON.parse(n):null===n?n:\"string\"==typeof n&&(n=b.trim(n),n&&k.test(n.replace(S,\"@\").replace(A,\"]\").replace(E,\"\")))?Function(\"return \"+n)():(b.error(\"Invalid JSON: \"+n),t)},parseXML:function(n){var r,i;if(!n||\"string\"!=typeof n)return null;try{e.DOMParser?(i=new DOMParser,r=i.parseFromString(n,\"text/xml\")):(r=new ActiveXObject(\"Microsoft.XMLDOM\"),r.async=\"false\",r.loadXML(n))}catch(o){r=t}return r&&r.documentElement&&!r.getElementsByTagName(\"parsererror\").length||b.error(\"Invalid XML: \"+n),r},noop:function(){},globalEval:function(t){t&&b.trim(t)&&(e.execScript||function(t){e.eval.call(e,t)})(t)},camelCase:function(e){return e.replace(j,\"ms-\").replace(D,L)},nodeName:function(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()},each:function(e,t,n){var r,i=0,o=e.length,a=M(e);if(n){if(a){for(;o>i;i++)if(r=t.apply(e[i],n),r===!1)break}else for(i in e)if(r=t.apply(e[i],n),r===!1)break}else if(a){for(;o>i;i++)if(r=t.call(e[i],i,e[i]),r===!1)break}else for(i in e)if(r=t.call(e[i],i,e[i]),r===!1)break;return e},trim:v&&!v.call(\"\\ufeff\\u00a0\")?function(e){return null==e?\"\":v.call(e)}:function(e){return null==e?\"\":(e+\"\").replace(T,\"\")},makeArray:function(e,t){var n=t||[];return null!=e&&(M(Object(e))?b.merge(n,\"string\"==typeof e?[e]:e):d.call(n,e)),n},inArray:function(e,t,n){var r;if(t){if(g)return g.call(t,e,n);for(r=t.length,n=n?0>n?Math.max(0,r+n):n:0;r>n;n++)if(n in t&&t[n]===e)return n}return-1},merge:function(e,n){var r=n.length,i=e.length,o=0;if(\"number\"==typeof r)for(;r>o;o++)e[i++]=n[o];else while(n[o]!==t)e[i++]=n[o++];return e.length=i,e},grep:function(e,t,n){var r,i=[],o=0,a=e.length;for(n=!!n;a>o;o++)r=!!t(e[o],o),n!==r&&i.push(e[o]);return i},map:function(e,t,n){var r,i=0,o=e.length,a=M(e),s=[];if(a)for(;o>i;i++)r=t(e[i],i,n),null!=r&&(s[s.length]=r);else for(i in e)r=t(e[i],i,n),null!=r&&(s[s.length]=r);return f.apply([],s)},guid:1,proxy:function(e,n){var r,i,o;return\"string\"==typeof n&&(o=e[n],n=e,e=o),b.isFunction(e)?(r=h.call(arguments,2),i=function(){return e.apply(n||this,r.concat(h.call(arguments)))},i.guid=e.guid=e.guid||b.guid++,i):t},access:function(e,n,r,i,o,a,s){var u=0,l=e.length,c=null==r;if(\"object\"===b.type(r)){o=!0;for(u in r)b.access(e,n,u,r[u],!0,a,s)}else if(i!==t&&(o=!0,b.isFunction(i)||(s=!0),c&&(s?(n.call(e,i),n=null):(c=n,n=function(e,t,n){return c.call(b(e),n)})),n))for(;l>u;u++)n(e[u],r,s?i:i.call(e[u],u,n(e[u],r)));return o?e:c?n.call(e):l?n(e[0],r):a},now:function(){return(new Date).getTime()}}),b.ready.promise=function(t){if(!n)if(n=b.Deferred(),\"complete\"===o.readyState)setTimeout(b.ready);else if(o.addEventListener)o.addEventListener(\"DOMContentLoaded\",H,!1),e.addEventListener(\"load\",H,!1);else{o.attachEvent(\"onreadystatechange\",H),e.attachEvent(\"onload\",H);var r=!1;try{r=null==e.frameElement&&o.documentElement}catch(i){}r&&r.doScroll&&function a(){if(!b.isReady){try{r.doScroll(\"left\")}catch(e){return setTimeout(a,50)}q(),b.ready()}}()}return n.promise(t)},b.each(\"Boolean Number String Function Array Date RegExp Object Error\".split(\" \"),function(e,t){l[\"[object \"+t+\"]\"]=t.toLowerCase()});function M(e){var t=e.length,n=b.type(e);return b.isWindow(e)?!1:1===e.nodeType&&t?!0:\"array\"===n||\"function\"!==n&&(0===t||\"number\"==typeof t&&t>0&&t-1 in e)}r=b(o);var _={};function F(e){var t=_[e]={};return b.each(e.match(w)||[],function(e,n){t[n]=!0}),t}b.Callbacks=function(e){e=\"string\"==typeof e?_[e]||F(e):b.extend({},e);var n,r,i,o,a,s,u=[],l=!e.once&&[],c=function(t){for(r=e.memory&&t,i=!0,a=s||0,s=0,o=u.length,n=!0;u&&o>a;a++)if(u[a].apply(t[0],t[1])===!1&&e.stopOnFalse){r=!1;break}n=!1,u&&(l?l.length&&c(l.shift()):r?u=[]:p.disable())},p={add:function(){if(u){var t=u.length;(function i(t){b.each(t,function(t,n){var r=b.type(n);\"function\"===r?e.unique&&p.has(n)||u.push(n):n&&n.length&&\"string\"!==r&&i(n)})})(arguments),n?o=u.length:r&&(s=t,c(r))}return this},remove:function(){return u&&b.each(arguments,function(e,t){var r;while((r=b.inArray(t,u,r))>-1)u.splice(r,1),n&&(o>=r&&o--,a>=r&&a--)}),this},has:function(e){return e?b.inArray(e,u)>-1:!(!u||!u.length)},empty:function(){return u=[],this},disable:function(){return u=l=r=t,this},disabled:function(){return!u},lock:function(){return l=t,r||p.disable(),this},locked:function(){return!l},fireWith:function(e,t){return t=t||[],t=[e,t.slice?t.slice():t],!u||i&&!l||(n?l.push(t):c(t)),this},fire:function(){return p.fireWith(this,arguments),this},fired:function(){return!!i}};return p},b.extend({Deferred:function(e){var t=[[\"resolve\",\"done\",b.Callbacks(\"once memory\"),\"resolved\"],[\"reject\",\"fail\",b.Callbacks(\"once memory\"),\"rejected\"],[\"notify\",\"progress\",b.Callbacks(\"memory\")]],n=\"pending\",r={state:function(){return n},always:function(){return i.done(arguments).fail(arguments),this},then:function(){var e=arguments;return b.Deferred(function(n){b.each(t,function(t,o){var a=o[0],s=b.isFunction(e[t])&&e[t];i[o[1]](function(){var e=s&&s.apply(this,arguments);e&&b.isFunction(e.promise)?e.promise().done(n.resolve).fail(n.reject).progress(n.notify):n[a+\"With\"](this===r?n.promise():this,s?[e]:arguments)})}),e=null}).promise()},promise:function(e){return null!=e?b.extend(e,r):r}},i={};return r.pipe=r.then,b.each(t,function(e,o){var a=o[2],s=o[3];r[o[1]]=a.add,s&&a.add(function(){n=s},t[1^e][2].disable,t[2][2].lock),i[o[0]]=function(){return i[o[0]+\"With\"](this===i?r:this,arguments),this},i[o[0]+\"With\"]=a.fireWith}),r.promise(i),e&&e.call(i,i),i},when:function(e){var t=0,n=h.call(arguments),r=n.length,i=1!==r||e&&b.isFunction(e.promise)?r:0,o=1===i?e:b.Deferred(),a=function(e,t,n){return function(r){t[e]=this,n[e]=arguments.length>1?h.call(arguments):r,n===s?o.notifyWith(t,n):--i||o.resolveWith(t,n)}},s,u,l;if(r>1)for(s=Array(r),u=Array(r),l=Array(r);r>t;t++)n[t]&&b.isFunction(n[t].promise)?n[t].promise().done(a(t,l,n)).fail(o.reject).progress(a(t,u,s)):--i;return i||o.resolveWith(l,n),o.promise()}}),b.support=function(){var t,n,r,a,s,u,l,c,p,f,d=o.createElement(\"div\");if(d.setAttribute(\"className\",\"t\"),d.innerHTML=\"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\",n=d.getElementsByTagName(\"*\"),r=d.getElementsByTagName(\"a\")[0],!n||!r||!n.length)return{};s=o.createElement(\"select\"),l=s.appendChild(o.createElement(\"option\")),a=d.getElementsByTagName(\"input\")[0],r.style.cssText=\"top:1px;float:left;opacity:.5\",t={getSetAttribute:\"t\"!==d.className,leadingWhitespace:3===d.firstChild.nodeType,tbody:!d.getElementsByTagName(\"tbody\").length,htmlSerialize:!!d.getElementsByTagName(\"link\").length,style:/top/.test(r.getAttribute(\"style\")),hrefNormalized:\"/a\"===r.getAttribute(\"href\"),opacity:/^0.5/.test(r.style.opacity),cssFloat:!!r.style.cssFloat,checkOn:!!a.value,optSelected:l.selected,enctype:!!o.createElement(\"form\").enctype,html5Clone:\"<:nav></:nav>\"!==o.createElement(\"nav\").cloneNode(!0).outerHTML,boxModel:\"CSS1Compat\"===o.compatMode,deleteExpando:!0,noCloneEvent:!0,inlineBlockNeedsLayout:!1,shrinkWrapBlocks:!1,reliableMarginRight:!0,boxSizingReliable:!0,pixelPosition:!1},a.checked=!0,t.noCloneChecked=a.cloneNode(!0).checked,s.disabled=!0,t.optDisabled=!l.disabled;try{delete d.test}catch(h){t.deleteExpando=!1}a=o.createElement(\"input\"),a.setAttribute(\"value\",\"\"),t.input=\"\"===a.getAttribute(\"value\"),a.value=\"t\",a.setAttribute(\"type\",\"radio\"),t.radioValue=\"t\"===a.value,a.setAttribute(\"checked\",\"t\"),a.setAttribute(\"name\",\"t\"),u=o.createDocumentFragment(),u.appendChild(a),t.appendChecked=a.checked,t.checkClone=u.cloneNode(!0).cloneNode(!0).lastChild.checked,d.attachEvent&&(d.attachEvent(\"onclick\",function(){t.noCloneEvent=!1}),d.cloneNode(!0).click());for(f in{submit:!0,change:!0,focusin:!0})d.setAttribute(c=\"on\"+f,\"t\"),t[f+\"Bubbles\"]=c in e||d.attributes[c].expando===!1;return d.style.backgroundClip=\"content-box\",d.cloneNode(!0).style.backgroundClip=\"\",t.clearCloneStyle=\"content-box\"===d.style.backgroundClip,b(function(){var n,r,a,s=\"padding:0;margin:0;border:0;display:block;box-sizing:content-box;-moz-box-sizing:content-box;-webkit-box-sizing:content-box;\",u=o.getElementsByTagName(\"body\")[0];u&&(n=o.createElement(\"div\"),n.style.cssText=\"border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px\",u.appendChild(n).appendChild(d),d.innerHTML=\"<table><tr><td></td><td>t</td></tr></table>\",a=d.getElementsByTagName(\"td\"),a[0].style.cssText=\"padding:0;margin:0;border:0;display:none\",p=0===a[0].offsetHeight,a[0].style.display=\"\",a[1].style.display=\"none\",t.reliableHiddenOffsets=p&&0===a[0].offsetHeight,d.innerHTML=\"\",d.style.cssText=\"box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;\",t.boxSizing=4===d.offsetWidth,t.doesNotIncludeMarginInBodyOffset=1!==u.offsetTop,e.getComputedStyle&&(t.pixelPosition=\"1%\"!==(e.getComputedStyle(d,null)||{}).top,t.boxSizingReliable=\"4px\"===(e.getComputedStyle(d,null)||{width:\"4px\"}).width,r=d.appendChild(o.createElement(\"div\")),r.style.cssText=d.style.cssText=s,r.style.marginRight=r.style.width=\"0\",d.style.width=\"1px\",t.reliableMarginRight=!parseFloat((e.getComputedStyle(r,null)||{}).marginRight)),typeof d.style.zoom!==i&&(d.innerHTML=\"\",d.style.cssText=s+\"width:1px;padding:1px;display:inline;zoom:1\",t.inlineBlockNeedsLayout=3===d.offsetWidth,d.style.display=\"block\",d.innerHTML=\"<div></div>\",d.firstChild.style.width=\"5px\",t.shrinkWrapBlocks=3!==d.offsetWidth,t.inlineBlockNeedsLayout&&(u.style.zoom=1)),u.removeChild(n),n=d=a=r=null)}),n=s=u=l=r=a=null,t}();var O=/(?:\\{[\\s\\S]*\\}|\\[[\\s\\S]*\\])$/,B=/([A-Z])/g;function P(e,n,r,i){if(b.acceptData(e)){var o,a,s=b.expando,u=\"string\"==typeof n,l=e.nodeType,p=l?b.cache:e,f=l?e[s]:e[s]&&s;if(f&&p[f]&&(i||p[f].data)||!u||r!==t)return f||(l?e[s]=f=c.pop()||b.guid++:f=s),p[f]||(p[f]={},l||(p[f].toJSON=b.noop)),(\"object\"==typeof n||\"function\"==typeof n)&&(i?p[f]=b.extend(p[f],n):p[f].data=b.extend(p[f].data,n)),o=p[f],i||(o.data||(o.data={}),o=o.data),r!==t&&(o[b.camelCase(n)]=r),u?(a=o[n],null==a&&(a=o[b.camelCase(n)])):a=o,a}}function R(e,t,n){if(b.acceptData(e)){var r,i,o,a=e.nodeType,s=a?b.cache:e,u=a?e[b.expando]:b.expando;if(s[u]){if(t&&(o=n?s[u]:s[u].data)){b.isArray(t)?t=t.concat(b.map(t,b.camelCase)):t in o?t=[t]:(t=b.camelCase(t),t=t in o?[t]:t.split(\" \"));for(r=0,i=t.length;i>r;r++)delete o[t[r]];if(!(n?$:b.isEmptyObject)(o))return}(n||(delete s[u].data,$(s[u])))&&(a?b.cleanData([e],!0):b.support.deleteExpando||s!=s.window?delete s[u]:s[u]=null)}}}b.extend({cache:{},expando:\"jQuery\"+(p+Math.random()).replace(/\\D/g,\"\"),noData:{embed:!0,object:\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\",applet:!0},hasData:function(e){return e=e.nodeType?b.cache[e[b.expando]]:e[b.expando],!!e&&!$(e)},data:function(e,t,n){return P(e,t,n)},removeData:function(e,t){return R(e,t)},_data:function(e,t,n){return P(e,t,n,!0)},_removeData:function(e,t){return R(e,t,!0)},acceptData:function(e){if(e.nodeType&&1!==e.nodeType&&9!==e.nodeType)return!1;var t=e.nodeName&&b.noData[e.nodeName.toLowerCase()];return!t||t!==!0&&e.getAttribute(\"classid\")===t}}),b.fn.extend({data:function(e,n){var r,i,o=this[0],a=0,s=null;if(e===t){if(this.length&&(s=b.data(o),1===o.nodeType&&!b._data(o,\"parsedAttrs\"))){for(r=o.attributes;r.length>a;a++)i=r[a].name,i.indexOf(\"data-\")||(i=b.camelCase(i.slice(5)),W(o,i,s[i]));b._data(o,\"parsedAttrs\",!0)}return s}return\"object\"==typeof e?this.each(function(){b.data(this,e)}):b.access(this,function(n){return n===t?o?W(o,e,b.data(o,e)):null:(this.each(function(){b.data(this,e,n)}),t)},null,n,arguments.length>1,null,!0)},removeData:function(e){return this.each(function(){b.removeData(this,e)})}});function W(e,n,r){if(r===t&&1===e.nodeType){var i=\"data-\"+n.replace(B,\"-$1\").toLowerCase();if(r=e.getAttribute(i),\"string\"==typeof r){try{r=\"true\"===r?!0:\"false\"===r?!1:\"null\"===r?null:+r+\"\"===r?+r:O.test(r)?b.parseJSON(r):r}catch(o){}b.data(e,n,r)}else r=t}return r}function $(e){var t;for(t in e)if((\"data\"!==t||!b.isEmptyObject(e[t]))&&\"toJSON\"!==t)return!1;return!0}b.extend({queue:function(e,n,r){var i;return e?(n=(n||\"fx\")+\"queue\",i=b._data(e,n),r&&(!i||b.isArray(r)?i=b._data(e,n,b.makeArray(r)):i.push(r)),i||[]):t},dequeue:function(e,t){t=t||\"fx\";var n=b.queue(e,t),r=n.length,i=n.shift(),o=b._queueHooks(e,t),a=function(){b.dequeue(e,t)};\"inprogress\"===i&&(i=n.shift(),r--),o.cur=i,i&&(\"fx\"===t&&n.unshift(\"inprogress\"),delete o.stop,i.call(e,a,o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+\"queueHooks\";return b._data(e,n)||b._data(e,n,{empty:b.Callbacks(\"once memory\").add(function(){b._removeData(e,t+\"queue\"),b._removeData(e,n)})})}}),b.fn.extend({queue:function(e,n){var r=2;return\"string\"!=typeof e&&(n=e,e=\"fx\",r--),r>arguments.length?b.queue(this[0],e):n===t?this:this.each(function(){var t=b.queue(this,e,n);b._queueHooks(this,e),\"fx\"===e&&\"inprogress\"!==t[0]&&b.dequeue(this,e)})},dequeue:function(e){return this.each(function(){b.dequeue(this,e)})},delay:function(e,t){return e=b.fx?b.fx.speeds[e]||e:e,t=t||\"fx\",this.queue(t,function(t,n){var r=setTimeout(t,e);n.stop=function(){clearTimeout(r)}})},clearQueue:function(e){return this.queue(e||\"fx\",[])},promise:function(e,n){var r,i=1,o=b.Deferred(),a=this,s=this.length,u=function(){--i||o.resolveWith(a,[a])};\"string\"!=typeof e&&(n=e,e=t),e=e||\"fx\";while(s--)r=b._data(a[s],e+\"queueHooks\"),r&&r.empty&&(i++,r.empty.add(u));return u(),o.promise(n)}});var I,z,X=/[\\t\\r\\n]/g,U=/\\r/g,V=/^(?:input|select|textarea|button|object)$/i,Y=/^(?:a|area)$/i,J=/^(?:checked|selected|autofocus|autoplay|async|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped)$/i,G=/^(?:checked|selected)$/i,Q=b.support.getSetAttribute,K=b.support.input;b.fn.extend({attr:function(e,t){return b.access(this,b.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){b.removeAttr(this,e)})},prop:function(e,t){return b.access(this,b.prop,e,t,arguments.length>1)},removeProp:function(e){return e=b.propFix[e]||e,this.each(function(){try{this[e]=t,delete this[e]}catch(n){}})},addClass:function(e){var t,n,r,i,o,a=0,s=this.length,u=\"string\"==typeof e&&e;if(b.isFunction(e))return this.each(function(t){b(this).addClass(e.call(this,t,this.className))});if(u)for(t=(e||\"\").match(w)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(\" \"+n.className+\" \").replace(X,\" \"):\" \")){o=0;while(i=t[o++])0>r.indexOf(\" \"+i+\" \")&&(r+=i+\" \");n.className=b.trim(r)}return this},removeClass:function(e){var t,n,r,i,o,a=0,s=this.length,u=0===arguments.length||\"string\"==typeof e&&e;if(b.isFunction(e))return this.each(function(t){b(this).removeClass(e.call(this,t,this.className))});if(u)for(t=(e||\"\").match(w)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(\" \"+n.className+\" \").replace(X,\" \"):\"\")){o=0;while(i=t[o++])while(r.indexOf(\" \"+i+\" \")>=0)r=r.replace(\" \"+i+\" \",\" \");n.className=e?b.trim(r):\"\"}return this},toggleClass:function(e,t){var n=typeof e,r=\"boolean\"==typeof t;return b.isFunction(e)?this.each(function(n){b(this).toggleClass(e.call(this,n,this.className,t),t)}):this.each(function(){if(\"string\"===n){var o,a=0,s=b(this),u=t,l=e.match(w)||[];while(o=l[a++])u=r?u:!s.hasClass(o),s[u?\"addClass\":\"removeClass\"](o)}else(n===i||\"boolean\"===n)&&(this.className&&b._data(this,\"__className__\",this.className),this.className=this.className||e===!1?\"\":b._data(this,\"__className__\")||\"\")})},hasClass:function(e){var t=\" \"+e+\" \",n=0,r=this.length;for(;r>n;n++)if(1===this[n].nodeType&&(\" \"+this[n].className+\" \").replace(X,\" \").indexOf(t)>=0)return!0;return!1},val:function(e){var n,r,i,o=this[0];{if(arguments.length)return i=b.isFunction(e),this.each(function(n){var o,a=b(this);1===this.nodeType&&(o=i?e.call(this,n,a.val()):e,null==o?o=\"\":\"number\"==typeof o?o+=\"\":b.isArray(o)&&(o=b.map(o,function(e){return null==e?\"\":e+\"\"})),r=b.valHooks[this.type]||b.valHooks[this.nodeName.toLowerCase()],r&&\"set\"in r&&r.set(this,o,\"value\")!==t||(this.value=o))});if(o)return r=b.valHooks[o.type]||b.valHooks[o.nodeName.toLowerCase()],r&&\"get\"in r&&(n=r.get(o,\"value\"))!==t?n:(n=o.value,\"string\"==typeof n?n.replace(U,\"\"):null==n?\"\":n)}}}),b.extend({valHooks:{option:{get:function(e){var t=e.attributes.value;return!t||t.specified?e.value:e.text}},select:{get:function(e){var t,n,r=e.options,i=e.selectedIndex,o=\"select-one\"===e.type||0>i,a=o?null:[],s=o?i+1:r.length,u=0>i?s:o?i:0;for(;s>u;u++)if(n=r[u],!(!n.selected&&u!==i||(b.support.optDisabled?n.disabled:null!==n.getAttribute(\"disabled\"))||n.parentNode.disabled&&b.nodeName(n.parentNode,\"optgroup\"))){if(t=b(n).val(),o)return t;a.push(t)}return a},set:function(e,t){var n=b.makeArray(t);return b(e).find(\"option\").each(function(){this.selected=b.inArray(b(this).val(),n)>=0}),n.length||(e.selectedIndex=-1),n}}},attr:function(e,n,r){var o,a,s,u=e.nodeType;if(e&&3!==u&&8!==u&&2!==u)return typeof e.getAttribute===i?b.prop(e,n,r):(a=1!==u||!b.isXMLDoc(e),a&&(n=n.toLowerCase(),o=b.attrHooks[n]||(J.test(n)?z:I)),r===t?o&&a&&\"get\"in o&&null!==(s=o.get(e,n))?s:(typeof e.getAttribute!==i&&(s=e.getAttribute(n)),null==s?t:s):null!==r?o&&a&&\"set\"in o&&(s=o.set(e,r,n))!==t?s:(e.setAttribute(n,r+\"\"),r):(b.removeAttr(e,n),t))},removeAttr:function(e,t){var n,r,i=0,o=t&&t.match(w);if(o&&1===e.nodeType)while(n=o[i++])r=b.propFix[n]||n,J.test(n)?!Q&&G.test(n)?e[b.camelCase(\"default-\"+n)]=e[r]=!1:e[r]=!1:b.attr(e,n,\"\"),e.removeAttribute(Q?n:r)},attrHooks:{type:{set:function(e,t){if(!b.support.radioValue&&\"radio\"===t&&b.nodeName(e,\"input\")){var n=e.value;return e.setAttribute(\"type\",t),n&&(e.value=n),t}}}},propFix:{tabindex:\"tabIndex\",readonly:\"readOnly\",\"for\":\"htmlFor\",\"class\":\"className\",maxlength:\"maxLength\",cellspacing:\"cellSpacing\",cellpadding:\"cellPadding\",rowspan:\"rowSpan\",colspan:\"colSpan\",usemap:\"useMap\",frameborder:\"frameBorder\",contenteditable:\"contentEditable\"},prop:function(e,n,r){var i,o,a,s=e.nodeType;if(e&&3!==s&&8!==s&&2!==s)return a=1!==s||!b.isXMLDoc(e),a&&(n=b.propFix[n]||n,o=b.propHooks[n]),r!==t?o&&\"set\"in o&&(i=o.set(e,r,n))!==t?i:e[n]=r:o&&\"get\"in o&&null!==(i=o.get(e,n))?i:e[n]},propHooks:{tabIndex:{get:function(e){var n=e.getAttributeNode(\"tabindex\");return n&&n.specified?parseInt(n.value,10):V.test(e.nodeName)||Y.test(e.nodeName)&&e.href?0:t}}}}),z={get:function(e,n){var r=b.prop(e,n),i=\"boolean\"==typeof r&&e.getAttribute(n),o=\"boolean\"==typeof r?K&&Q?null!=i:G.test(n)?e[b.camelCase(\"default-\"+n)]:!!i:e.getAttributeNode(n);return o&&o.value!==!1?n.toLowerCase():t},set:function(e,t,n){return t===!1?b.removeAttr(e,n):K&&Q||!G.test(n)?e.setAttribute(!Q&&b.propFix[n]||n,n):e[b.camelCase(\"default-\"+n)]=e[n]=!0,n}},K&&Q||(b.attrHooks.value={get:function(e,n){var r=e.getAttributeNode(n);return b.nodeName(e,\"input\")?e.defaultValue:r&&r.specified?r.value:t},set:function(e,n,r){return b.nodeName(e,\"input\")?(e.defaultValue=n,t):I&&I.set(e,n,r)}}),Q||(I=b.valHooks.button={get:function(e,n){var r=e.getAttributeNode(n);return r&&(\"id\"===n||\"name\"===n||\"coords\"===n?\"\"!==r.value:r.specified)?r.value:t},set:function(e,n,r){var i=e.getAttributeNode(r);return i||e.setAttributeNode(i=e.ownerDocument.createAttribute(r)),i.value=n+=\"\",\"value\"===r||n===e.getAttribute(r)?n:t}},b.attrHooks.contenteditable={get:I.get,set:function(e,t,n){I.set(e,\"\"===t?!1:t,n)}},b.each([\"width\",\"height\"],function(e,n){b.attrHooks[n]=b.extend(b.attrHooks[n],{set:function(e,r){return\"\"===r?(e.setAttribute(n,\"auto\"),r):t}})})),b.support.hrefNormalized||(b.each([\"href\",\"src\",\"width\",\"height\"],function(e,n){b.attrHooks[n]=b.extend(b.attrHooks[n],{get:function(e){var r=e.getAttribute(n,2);return null==r?t:r}})}),b.each([\"href\",\"src\"],function(e,t){b.propHooks[t]={get:function(e){return e.getAttribute(t,4)}}})),b.support.style||(b.attrHooks.style={get:function(e){return e.style.cssText||t},set:function(e,t){return e.style.cssText=t+\"\"}}),b.support.optSelected||(b.propHooks.selected=b.extend(b.propHooks.selected,{get:function(e){var t=e.parentNode;return t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex),null}})),b.support.enctype||(b.propFix.enctype=\"encoding\"),b.support.checkOn||b.each([\"radio\",\"checkbox\"],function(){b.valHooks[this]={get:function(e){return null===e.getAttribute(\"value\")?\"on\":e.value}}}),b.each([\"radio\",\"checkbox\"],function(){b.valHooks[this]=b.extend(b.valHooks[this],{set:function(e,n){return b.isArray(n)?e.checked=b.inArray(b(e).val(),n)>=0:t}})});var Z=/^(?:input|select|textarea)$/i,et=/^key/,tt=/^(?:mouse|contextmenu)|click/,nt=/^(?:focusinfocus|focusoutblur)$/,rt=/^([^.]*)(?:\\.(.+)|)$/;function it(){return!0}function ot(){return!1}b.event={global:{},add:function(e,n,r,o,a){var s,u,l,c,p,f,d,h,g,m,y,v=b._data(e);if(v){r.handler&&(c=r,r=c.handler,a=c.selector),r.guid||(r.guid=b.guid++),(u=v.events)||(u=v.events={}),(f=v.handle)||(f=v.handle=function(e){return typeof b===i||e&&b.event.triggered===e.type?t:b.event.dispatch.apply(f.elem,arguments)},f.elem=e),n=(n||\"\").match(w)||[\"\"],l=n.length;while(l--)s=rt.exec(n[l])||[],g=y=s[1],m=(s[2]||\"\").split(\".\").sort(),p=b.event.special[g]||{},g=(a?p.delegateType:p.bindType)||g,p=b.event.special[g]||{},d=b.extend({type:g,origType:y,data:o,handler:r,guid:r.guid,selector:a,needsContext:a&&b.expr.match.needsContext.test(a),namespace:m.join(\".\")},c),(h=u[g])||(h=u[g]=[],h.delegateCount=0,p.setup&&p.setup.call(e,o,m,f)!==!1||(e.addEventListener?e.addEventListener(g,f,!1):e.attachEvent&&e.attachEvent(\"on\"+g,f))),p.add&&(p.add.call(e,d),d.handler.guid||(d.handler.guid=r.guid)),a?h.splice(h.delegateCount++,0,d):h.push(d),b.event.global[g]=!0;e=null}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,p,f,d,h,g,m=b.hasData(e)&&b._data(e);if(m&&(c=m.events)){t=(t||\"\").match(w)||[\"\"],l=t.length;while(l--)if(s=rt.exec(t[l])||[],d=g=s[1],h=(s[2]||\"\").split(\".\").sort(),d){p=b.event.special[d]||{},d=(r?p.delegateType:p.bindType)||d,f=c[d]||[],s=s[2]&&RegExp(\"(^|\\\\.)\"+h.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"),u=o=f.length;while(o--)a=f[o],!i&&g!==a.origType||n&&n.guid!==a.guid||s&&!s.test(a.namespace)||r&&r!==a.selector&&(\"**\"!==r||!a.selector)||(f.splice(o,1),a.selector&&f.delegateCount--,p.remove&&p.remove.call(e,a));u&&!f.length&&(p.teardown&&p.teardown.call(e,h,m.handle)!==!1||b.removeEvent(e,d,m.handle),delete c[d])}else for(d in c)b.event.remove(e,d+t[l],n,r,!0);b.isEmptyObject(c)&&(delete m.handle,b._removeData(e,\"events\"))}},trigger:function(n,r,i,a){var s,u,l,c,p,f,d,h=[i||o],g=y.call(n,\"type\")?n.type:n,m=y.call(n,\"namespace\")?n.namespace.split(\".\"):[];if(l=f=i=i||o,3!==i.nodeType&&8!==i.nodeType&&!nt.test(g+b.event.triggered)&&(g.indexOf(\".\")>=0&&(m=g.split(\".\"),g=m.shift(),m.sort()),u=0>g.indexOf(\":\")&&\"on\"+g,n=n[b.expando]?n:new b.Event(g,\"object\"==typeof n&&n),n.isTrigger=!0,n.namespace=m.join(\".\"),n.namespace_re=n.namespace?RegExp(\"(^|\\\\.)\"+m.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"):null,n.result=t,n.target||(n.target=i),r=null==r?[n]:b.makeArray(r,[n]),p=b.event.special[g]||{},a||!p.trigger||p.trigger.apply(i,r)!==!1)){if(!a&&!p.noBubble&&!b.isWindow(i)){for(c=p.delegateType||g,nt.test(c+g)||(l=l.parentNode);l;l=l.parentNode)h.push(l),f=l;f===(i.ownerDocument||o)&&h.push(f.defaultView||f.parentWindow||e)}d=0;while((l=h[d++])&&!n.isPropagationStopped())n.type=d>1?c:p.bindType||g,s=(b._data(l,\"events\")||{})[n.type]&&b._data(l,\"handle\"),s&&s.apply(l,r),s=u&&l[u],s&&b.acceptData(l)&&s.apply&&s.apply(l,r)===!1&&n.preventDefault();if(n.type=g,!(a||n.isDefaultPrevented()||p._default&&p._default.apply(i.ownerDocument,r)!==!1||\"click\"===g&&b.nodeName(i,\"a\")||!b.acceptData(i)||!u||!i[g]||b.isWindow(i))){f=i[u],f&&(i[u]=null),b.event.triggered=g;try{i[g]()}catch(v){}b.event.triggered=t,f&&(i[u]=f)}return n.result}},dispatch:function(e){e=b.event.fix(e);var n,r,i,o,a,s=[],u=h.call(arguments),l=(b._data(this,\"events\")||{})[e.type]||[],c=b.event.special[e.type]||{};if(u[0]=e,e.delegateTarget=this,!c.preDispatch||c.preDispatch.call(this,e)!==!1){s=b.event.handlers.call(this,e,l),n=0;while((o=s[n++])&&!e.isPropagationStopped()){e.currentTarget=o.elem,a=0;while((i=o.handlers[a++])&&!e.isImmediatePropagationStopped())(!e.namespace_re||e.namespace_re.test(i.namespace))&&(e.handleObj=i,e.data=i.data,r=((b.event.special[i.origType]||{}).handle||i.handler).apply(o.elem,u),r!==t&&(e.result=r)===!1&&(e.preventDefault(),e.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,e),e.result}},handlers:function(e,n){var r,i,o,a,s=[],u=n.delegateCount,l=e.target;if(u&&l.nodeType&&(!e.button||\"click\"!==e.type))for(;l!=this;l=l.parentNode||this)if(1===l.nodeType&&(l.disabled!==!0||\"click\"!==e.type)){for(o=[],a=0;u>a;a++)i=n[a],r=i.selector+\" \",o[r]===t&&(o[r]=i.needsContext?b(r,this).index(l)>=0:b.find(r,this,null,[l]).length),o[r]&&o.push(i);o.length&&s.push({elem:l,handlers:o})}return n.length>u&&s.push({elem:this,handlers:n.slice(u)}),s},fix:function(e){if(e[b.expando])return e;var t,n,r,i=e.type,a=e,s=this.fixHooks[i];s||(this.fixHooks[i]=s=tt.test(i)?this.mouseHooks:et.test(i)?this.keyHooks:{}),r=s.props?this.props.concat(s.props):this.props,e=new b.Event(a),t=r.length;while(t--)n=r[t],e[n]=a[n];return e.target||(e.target=a.srcElement||o),3===e.target.nodeType&&(e.target=e.target.parentNode),e.metaKey=!!e.metaKey,s.filter?s.filter(e,a):e},props:\"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which\".split(\" \"),fixHooks:{},keyHooks:{props:\"char charCode key keyCode\".split(\" \"),filter:function(e,t){return null==e.which&&(e.which=null!=t.charCode?t.charCode:t.keyCode),e}},mouseHooks:{props:\"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement\".split(\" \"),filter:function(e,n){var r,i,a,s=n.button,u=n.fromElement;return null==e.pageX&&null!=n.clientX&&(i=e.target.ownerDocument||o,a=i.documentElement,r=i.body,e.pageX=n.clientX+(a&&a.scrollLeft||r&&r.scrollLeft||0)-(a&&a.clientLeft||r&&r.clientLeft||0),e.pageY=n.clientY+(a&&a.scrollTop||r&&r.scrollTop||0)-(a&&a.clientTop||r&&r.clientTop||0)),!e.relatedTarget&&u&&(e.relatedTarget=u===e.target?n.toElement:u),e.which||s===t||(e.which=1&s?1:2&s?3:4&s?2:0),e}},special:{load:{noBubble:!0},click:{trigger:function(){return b.nodeName(this,\"input\")&&\"checkbox\"===this.type&&this.click?(this.click(),!1):t}},focus:{trigger:function(){if(this!==o.activeElement&&this.focus)try{return this.focus(),!1}catch(e){}},delegateType:\"focusin\"},blur:{trigger:function(){return this===o.activeElement&&this.blur?(this.blur(),!1):t},delegateType:\"focusout\"},beforeunload:{postDispatch:function(e){e.result!==t&&(e.originalEvent.returnValue=e.result)}}},simulate:function(e,t,n,r){var i=b.extend(new b.Event,n,{type:e,isSimulated:!0,originalEvent:{}});r?b.event.trigger(i,null,t):b.event.dispatch.call(t,i),i.isDefaultPrevented()&&n.preventDefault()}},b.removeEvent=o.removeEventListener?function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n,!1)}:function(e,t,n){var r=\"on\"+t;e.detachEvent&&(typeof e[r]===i&&(e[r]=null),e.detachEvent(r,n))},b.Event=function(e,n){return this instanceof b.Event?(e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||e.returnValue===!1||e.getPreventDefault&&e.getPreventDefault()?it:ot):this.type=e,n&&b.extend(this,n),this.timeStamp=e&&e.timeStamp||b.now(),this[b.expando]=!0,t):new b.Event(e,n)},b.Event.prototype={isDefaultPrevented:ot,isPropagationStopped:ot,isImmediatePropagationStopped:ot,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=it,e&&(e.preventDefault?e.preventDefault():e.returnValue=!1)},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=it,e&&(e.stopPropagation&&e.stopPropagation(),e.cancelBubble=!0)},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=it,this.stopPropagation()}},b.each({mouseenter:\"mouseover\",mouseleave:\"mouseout\"},function(e,t){b.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;\nreturn(!i||i!==r&&!b.contains(r,i))&&(e.type=o.origType,n=o.handler.apply(this,arguments),e.type=t),n}}}),b.support.submitBubbles||(b.event.special.submit={setup:function(){return b.nodeName(this,\"form\")?!1:(b.event.add(this,\"click._submit keypress._submit\",function(e){var n=e.target,r=b.nodeName(n,\"input\")||b.nodeName(n,\"button\")?n.form:t;r&&!b._data(r,\"submitBubbles\")&&(b.event.add(r,\"submit._submit\",function(e){e._submit_bubble=!0}),b._data(r,\"submitBubbles\",!0))}),t)},postDispatch:function(e){e._submit_bubble&&(delete e._submit_bubble,this.parentNode&&!e.isTrigger&&b.event.simulate(\"submit\",this.parentNode,e,!0))},teardown:function(){return b.nodeName(this,\"form\")?!1:(b.event.remove(this,\"._submit\"),t)}}),b.support.changeBubbles||(b.event.special.change={setup:function(){return Z.test(this.nodeName)?((\"checkbox\"===this.type||\"radio\"===this.type)&&(b.event.add(this,\"propertychange._change\",function(e){\"checked\"===e.originalEvent.propertyName&&(this._just_changed=!0)}),b.event.add(this,\"click._change\",function(e){this._just_changed&&!e.isTrigger&&(this._just_changed=!1),b.event.simulate(\"change\",this,e,!0)})),!1):(b.event.add(this,\"beforeactivate._change\",function(e){var t=e.target;Z.test(t.nodeName)&&!b._data(t,\"changeBubbles\")&&(b.event.add(t,\"change._change\",function(e){!this.parentNode||e.isSimulated||e.isTrigger||b.event.simulate(\"change\",this.parentNode,e,!0)}),b._data(t,\"changeBubbles\",!0))}),t)},handle:function(e){var n=e.target;return this!==n||e.isSimulated||e.isTrigger||\"radio\"!==n.type&&\"checkbox\"!==n.type?e.handleObj.handler.apply(this,arguments):t},teardown:function(){return b.event.remove(this,\"._change\"),!Z.test(this.nodeName)}}),b.support.focusinBubbles||b.each({focus:\"focusin\",blur:\"focusout\"},function(e,t){var n=0,r=function(e){b.event.simulate(t,e.target,b.event.fix(e),!0)};b.event.special[t]={setup:function(){0===n++&&o.addEventListener(e,r,!0)},teardown:function(){0===--n&&o.removeEventListener(e,r,!0)}}}),b.fn.extend({on:function(e,n,r,i,o){var a,s;if(\"object\"==typeof e){\"string\"!=typeof n&&(r=r||n,n=t);for(a in e)this.on(a,n,r,e[a],o);return this}if(null==r&&null==i?(i=n,r=n=t):null==i&&(\"string\"==typeof n?(i=r,r=t):(i=r,r=n,n=t)),i===!1)i=ot;else if(!i)return this;return 1===o&&(s=i,i=function(e){return b().off(e),s.apply(this,arguments)},i.guid=s.guid||(s.guid=b.guid++)),this.each(function(){b.event.add(this,e,i,r,n)})},one:function(e,t,n,r){return this.on(e,t,n,r,1)},off:function(e,n,r){var i,o;if(e&&e.preventDefault&&e.handleObj)return i=e.handleObj,b(e.delegateTarget).off(i.namespace?i.origType+\".\"+i.namespace:i.origType,i.selector,i.handler),this;if(\"object\"==typeof e){for(o in e)this.off(o,n,e[o]);return this}return(n===!1||\"function\"==typeof n)&&(r=n,n=t),r===!1&&(r=ot),this.each(function(){b.event.remove(this,e,r,n)})},bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,\"**\"):this.off(t,e||\"**\",n)},trigger:function(e,t){return this.each(function(){b.event.trigger(e,t,this)})},triggerHandler:function(e,n){var r=this[0];return r?b.event.trigger(e,n,r,!0):t}}),function(e,t){var n,r,i,o,a,s,u,l,c,p,f,d,h,g,m,y,v,x=\"sizzle\"+-new Date,w=e.document,T={},N=0,C=0,k=it(),E=it(),S=it(),A=typeof t,j=1<<31,D=[],L=D.pop,H=D.push,q=D.slice,M=D.indexOf||function(e){var t=0,n=this.length;for(;n>t;t++)if(this[t]===e)return t;return-1},_=\"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",F=\"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",O=F.replace(\"w\",\"w#\"),B=\"([*^$|!~]?=)\",P=\"\\\\[\"+_+\"*(\"+F+\")\"+_+\"*(?:\"+B+_+\"*(?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|(\"+O+\")|)|)\"+_+\"*\\\\]\",R=\":(\"+F+\")(?:\\\\(((['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\"+P.replace(3,8)+\")*)|.*)\\\\)|)\",W=RegExp(\"^\"+_+\"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\"+_+\"+$\",\"g\"),$=RegExp(\"^\"+_+\"*,\"+_+\"*\"),I=RegExp(\"^\"+_+\"*([\\\\x20\\\\t\\\\r\\\\n\\\\f>+~])\"+_+\"*\"),z=RegExp(R),X=RegExp(\"^\"+O+\"$\"),U={ID:RegExp(\"^#(\"+F+\")\"),CLASS:RegExp(\"^\\\\.(\"+F+\")\"),NAME:RegExp(\"^\\\\[name=['\\\"]?(\"+F+\")['\\\"]?\\\\]\"),TAG:RegExp(\"^(\"+F.replace(\"w\",\"w*\")+\")\"),ATTR:RegExp(\"^\"+P),PSEUDO:RegExp(\"^\"+R),CHILD:RegExp(\"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\"+_+\"*(even|odd|(([+-]|)(\\\\d*)n|)\"+_+\"*(?:([+-]|)\"+_+\"*(\\\\d+)|))\"+_+\"*\\\\)|)\",\"i\"),needsContext:RegExp(\"^\"+_+\"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\"+_+\"*((?:-\\\\d)?\\\\d*)\"+_+\"*\\\\)|)(?=[^-]|$)\",\"i\")},V=/[\\x20\\t\\r\\n\\f]*[+~]/,Y=/^[^{]+\\{\\s*\\[native code/,J=/^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,G=/^(?:input|select|textarea|button)$/i,Q=/^h\\d$/i,K=/'|\\\\/g,Z=/\\=[\\x20\\t\\r\\n\\f]*([^'\"\\]]*)[\\x20\\t\\r\\n\\f]*\\]/g,et=/\\\\([\\da-fA-F]{1,6}[\\x20\\t\\r\\n\\f]?|.)/g,tt=function(e,t){var n=\"0x\"+t-65536;return n!==n?t:0>n?String.fromCharCode(n+65536):String.fromCharCode(55296|n>>10,56320|1023&n)};try{q.call(w.documentElement.childNodes,0)[0].nodeType}catch(nt){q=function(e){var t,n=[];while(t=this[e++])n.push(t);return n}}function rt(e){return Y.test(e+\"\")}function it(){var e,t=[];return e=function(n,r){return t.push(n+=\" \")>i.cacheLength&&delete e[t.shift()],e[n]=r}}function ot(e){return e[x]=!0,e}function at(e){var t=p.createElement(\"div\");try{return e(t)}catch(n){return!1}finally{t=null}}function st(e,t,n,r){var i,o,a,s,u,l,f,g,m,v;if((t?t.ownerDocument||t:w)!==p&&c(t),t=t||p,n=n||[],!e||\"string\"!=typeof e)return n;if(1!==(s=t.nodeType)&&9!==s)return[];if(!d&&!r){if(i=J.exec(e))if(a=i[1]){if(9===s){if(o=t.getElementById(a),!o||!o.parentNode)return n;if(o.id===a)return n.push(o),n}else if(t.ownerDocument&&(o=t.ownerDocument.getElementById(a))&&y(t,o)&&o.id===a)return n.push(o),n}else{if(i[2])return H.apply(n,q.call(t.getElementsByTagName(e),0)),n;if((a=i[3])&&T.getByClassName&&t.getElementsByClassName)return H.apply(n,q.call(t.getElementsByClassName(a),0)),n}if(T.qsa&&!h.test(e)){if(f=!0,g=x,m=t,v=9===s&&e,1===s&&\"object\"!==t.nodeName.toLowerCase()){l=ft(e),(f=t.getAttribute(\"id\"))?g=f.replace(K,\"\\\\$&\"):t.setAttribute(\"id\",g),g=\"[id='\"+g+\"'] \",u=l.length;while(u--)l[u]=g+dt(l[u]);m=V.test(e)&&t.parentNode||t,v=l.join(\",\")}if(v)try{return H.apply(n,q.call(m.querySelectorAll(v),0)),n}catch(b){}finally{f||t.removeAttribute(\"id\")}}}return wt(e.replace(W,\"$1\"),t,n,r)}a=st.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return t?\"HTML\"!==t.nodeName:!1},c=st.setDocument=function(e){var n=e?e.ownerDocument||e:w;return n!==p&&9===n.nodeType&&n.documentElement?(p=n,f=n.documentElement,d=a(n),T.tagNameNoComments=at(function(e){return e.appendChild(n.createComment(\"\")),!e.getElementsByTagName(\"*\").length}),T.attributes=at(function(e){e.innerHTML=\"<select></select>\";var t=typeof e.lastChild.getAttribute(\"multiple\");return\"boolean\"!==t&&\"string\"!==t}),T.getByClassName=at(function(e){return e.innerHTML=\"<div class='hidden e'></div><div class='hidden'></div>\",e.getElementsByClassName&&e.getElementsByClassName(\"e\").length?(e.lastChild.className=\"e\",2===e.getElementsByClassName(\"e\").length):!1}),T.getByName=at(function(e){e.id=x+0,e.innerHTML=\"<a name='\"+x+\"'></a><div name='\"+x+\"'></div>\",f.insertBefore(e,f.firstChild);var t=n.getElementsByName&&n.getElementsByName(x).length===2+n.getElementsByName(x+0).length;return T.getIdNotName=!n.getElementById(x),f.removeChild(e),t}),i.attrHandle=at(function(e){return e.innerHTML=\"<a href='#'></a>\",e.firstChild&&typeof e.firstChild.getAttribute!==A&&\"#\"===e.firstChild.getAttribute(\"href\")})?{}:{href:function(e){return e.getAttribute(\"href\",2)},type:function(e){return e.getAttribute(\"type\")}},T.getIdNotName?(i.find.ID=function(e,t){if(typeof t.getElementById!==A&&!d){var n=t.getElementById(e);return n&&n.parentNode?[n]:[]}},i.filter.ID=function(e){var t=e.replace(et,tt);return function(e){return e.getAttribute(\"id\")===t}}):(i.find.ID=function(e,n){if(typeof n.getElementById!==A&&!d){var r=n.getElementById(e);return r?r.id===e||typeof r.getAttributeNode!==A&&r.getAttributeNode(\"id\").value===e?[r]:t:[]}},i.filter.ID=function(e){var t=e.replace(et,tt);return function(e){var n=typeof e.getAttributeNode!==A&&e.getAttributeNode(\"id\");return n&&n.value===t}}),i.find.TAG=T.tagNameNoComments?function(e,n){return typeof n.getElementsByTagName!==A?n.getElementsByTagName(e):t}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if(\"*\"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},i.find.NAME=T.getByName&&function(e,n){return typeof n.getElementsByName!==A?n.getElementsByName(name):t},i.find.CLASS=T.getByClassName&&function(e,n){return typeof n.getElementsByClassName===A||d?t:n.getElementsByClassName(e)},g=[],h=[\":focus\"],(T.qsa=rt(n.querySelectorAll))&&(at(function(e){e.innerHTML=\"<select><option selected=''></option></select>\",e.querySelectorAll(\"[selected]\").length||h.push(\"\\\\[\"+_+\"*(?:checked|disabled|ismap|multiple|readonly|selected|value)\"),e.querySelectorAll(\":checked\").length||h.push(\":checked\")}),at(function(e){e.innerHTML=\"<input type='hidden' i=''/>\",e.querySelectorAll(\"[i^='']\").length&&h.push(\"[*^$]=\"+_+\"*(?:\\\"\\\"|'')\"),e.querySelectorAll(\":enabled\").length||h.push(\":enabled\",\":disabled\"),e.querySelectorAll(\"*,:x\"),h.push(\",.*:\")})),(T.matchesSelector=rt(m=f.matchesSelector||f.mozMatchesSelector||f.webkitMatchesSelector||f.oMatchesSelector||f.msMatchesSelector))&&at(function(e){T.disconnectedMatch=m.call(e,\"div\"),m.call(e,\"[s!='']:x\"),g.push(\"!=\",R)}),h=RegExp(h.join(\"|\")),g=RegExp(g.join(\"|\")),y=rt(f.contains)||f.compareDocumentPosition?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},v=f.compareDocumentPosition?function(e,t){var r;return e===t?(u=!0,0):(r=t.compareDocumentPosition&&e.compareDocumentPosition&&e.compareDocumentPosition(t))?1&r||e.parentNode&&11===e.parentNode.nodeType?e===n||y(w,e)?-1:t===n||y(w,t)?1:0:4&r?-1:1:e.compareDocumentPosition?-1:1}:function(e,t){var r,i=0,o=e.parentNode,a=t.parentNode,s=[e],l=[t];if(e===t)return u=!0,0;if(!o||!a)return e===n?-1:t===n?1:o?-1:a?1:0;if(o===a)return ut(e,t);r=e;while(r=r.parentNode)s.unshift(r);r=t;while(r=r.parentNode)l.unshift(r);while(s[i]===l[i])i++;return i?ut(s[i],l[i]):s[i]===w?-1:l[i]===w?1:0},u=!1,[0,0].sort(v),T.detectDuplicates=u,p):p},st.matches=function(e,t){return st(e,null,null,t)},st.matchesSelector=function(e,t){if((e.ownerDocument||e)!==p&&c(e),t=t.replace(Z,\"='$1']\"),!(!T.matchesSelector||d||g&&g.test(t)||h.test(t)))try{var n=m.call(e,t);if(n||T.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(r){}return st(t,p,null,[e]).length>0},st.contains=function(e,t){return(e.ownerDocument||e)!==p&&c(e),y(e,t)},st.attr=function(e,t){var n;return(e.ownerDocument||e)!==p&&c(e),d||(t=t.toLowerCase()),(n=i.attrHandle[t])?n(e):d||T.attributes?e.getAttribute(t):((n=e.getAttributeNode(t))||e.getAttribute(t))&&e[t]===!0?t:n&&n.specified?n.value:null},st.error=function(e){throw Error(\"Syntax error, unrecognized expression: \"+e)},st.uniqueSort=function(e){var t,n=[],r=1,i=0;if(u=!T.detectDuplicates,e.sort(v),u){for(;t=e[r];r++)t===e[r-1]&&(i=n.push(r));while(i--)e.splice(n[i],1)}return e};function ut(e,t){var n=t&&e,r=n&&(~t.sourceIndex||j)-(~e.sourceIndex||j);if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function lt(e){return function(t){var n=t.nodeName.toLowerCase();return\"input\"===n&&t.type===e}}function ct(e){return function(t){var n=t.nodeName.toLowerCase();return(\"input\"===n||\"button\"===n)&&t.type===e}}function pt(e){return ot(function(t){return t=+t,ot(function(n,r){var i,o=e([],n.length,t),a=o.length;while(a--)n[i=o[a]]&&(n[i]=!(r[i]=n[i]))})})}o=st.getText=function(e){var t,n=\"\",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if(\"string\"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else for(;t=e[r];r++)n+=o(t);return n},i=st.selectors={cacheLength:50,createPseudo:ot,match:U,find:{},relative:{\">\":{dir:\"parentNode\",first:!0},\" \":{dir:\"parentNode\"},\"+\":{dir:\"previousSibling\",first:!0},\"~\":{dir:\"previousSibling\"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(et,tt),e[3]=(e[4]||e[5]||\"\").replace(et,tt),\"~=\"===e[2]&&(e[3]=\" \"+e[3]+\" \"),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),\"nth\"===e[1].slice(0,3)?(e[3]||st.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*(\"even\"===e[3]||\"odd\"===e[3])),e[5]=+(e[7]+e[8]||\"odd\"===e[3])):e[3]&&st.error(e[0]),e},PSEUDO:function(e){var t,n=!e[5]&&e[2];return U.CHILD.test(e[0])?null:(e[4]?e[2]=e[4]:n&&z.test(n)&&(t=ft(n,!0))&&(t=n.indexOf(\")\",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){return\"*\"===e?function(){return!0}:(e=e.replace(et,tt).toLowerCase(),function(t){return t.nodeName&&t.nodeName.toLowerCase()===e})},CLASS:function(e){var t=k[e+\" \"];return t||(t=RegExp(\"(^|\"+_+\")\"+e+\"(\"+_+\"|$)\"))&&k(e,function(e){return t.test(e.className||typeof e.getAttribute!==A&&e.getAttribute(\"class\")||\"\")})},ATTR:function(e,t,n){return function(r){var i=st.attr(r,e);return null==i?\"!=\"===t:t?(i+=\"\",\"=\"===t?i===n:\"!=\"===t?i!==n:\"^=\"===t?n&&0===i.indexOf(n):\"*=\"===t?n&&i.indexOf(n)>-1:\"$=\"===t?n&&i.slice(-n.length)===n:\"~=\"===t?(\" \"+i+\" \").indexOf(n)>-1:\"|=\"===t?i===n||i.slice(0,n.length+1)===n+\"-\":!1):!0}},CHILD:function(e,t,n,r,i){var o=\"nth\"!==e.slice(0,3),a=\"last\"!==e.slice(-4),s=\"of-type\"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,u){var l,c,p,f,d,h,g=o!==a?\"nextSibling\":\"previousSibling\",m=t.parentNode,y=s&&t.nodeName.toLowerCase(),v=!u&&!s;if(m){if(o){while(g){p=t;while(p=p[g])if(s?p.nodeName.toLowerCase()===y:1===p.nodeType)return!1;h=g=\"only\"===e&&!h&&\"nextSibling\"}return!0}if(h=[a?m.firstChild:m.lastChild],a&&v){c=m[x]||(m[x]={}),l=c[e]||[],d=l[0]===N&&l[1],f=l[0]===N&&l[2],p=d&&m.childNodes[d];while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if(1===p.nodeType&&++f&&p===t){c[e]=[N,d,f];break}}else if(v&&(l=(t[x]||(t[x]={}))[e])&&l[0]===N)f=l[1];else while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if((s?p.nodeName.toLowerCase()===y:1===p.nodeType)&&++f&&(v&&((p[x]||(p[x]={}))[e]=[N,f]),p===t))break;return f-=i,f===r||0===f%r&&f/r>=0}}},PSEUDO:function(e,t){var n,r=i.pseudos[e]||i.setFilters[e.toLowerCase()]||st.error(\"unsupported pseudo: \"+e);return r[x]?r(t):r.length>1?(n=[e,e,\"\",t],i.setFilters.hasOwnProperty(e.toLowerCase())?ot(function(e,n){var i,o=r(e,t),a=o.length;while(a--)i=M.call(e,o[a]),e[i]=!(n[i]=o[a])}):function(e){return r(e,0,n)}):r}},pseudos:{not:ot(function(e){var t=[],n=[],r=s(e.replace(W,\"$1\"));return r[x]?ot(function(e,t,n,i){var o,a=r(e,null,i,[]),s=e.length;while(s--)(o=a[s])&&(e[s]=!(t[s]=o))}):function(e,i,o){return t[0]=e,r(t,null,o,n),!n.pop()}}),has:ot(function(e){return function(t){return st(e,t).length>0}}),contains:ot(function(e){return function(t){return(t.textContent||t.innerText||o(t)).indexOf(e)>-1}}),lang:ot(function(e){return X.test(e||\"\")||st.error(\"unsupported lang: \"+e),e=e.replace(et,tt).toLowerCase(),function(t){var n;do if(n=d?t.getAttribute(\"xml:lang\")||t.getAttribute(\"lang\"):t.lang)return n=n.toLowerCase(),n===e||0===n.indexOf(e+\"-\");while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===f},focus:function(e){return e===p.activeElement&&(!p.hasFocus||p.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:function(e){return e.disabled===!1},disabled:function(e){return e.disabled===!0},checked:function(e){var t=e.nodeName.toLowerCase();return\"input\"===t&&!!e.checked||\"option\"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,e.selected===!0},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeName>\"@\"||3===e.nodeType||4===e.nodeType)return!1;return!0},parent:function(e){return!i.pseudos.empty(e)},header:function(e){return Q.test(e.nodeName)},input:function(e){return G.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return\"input\"===t&&\"button\"===e.type||\"button\"===t},text:function(e){var t;return\"input\"===e.nodeName.toLowerCase()&&\"text\"===e.type&&(null==(t=e.getAttribute(\"type\"))||t.toLowerCase()===e.type)},first:pt(function(){return[0]}),last:pt(function(e,t){return[t-1]}),eq:pt(function(e,t,n){return[0>n?n+t:n]}),even:pt(function(e,t){var n=0;for(;t>n;n+=2)e.push(n);return e}),odd:pt(function(e,t){var n=1;for(;t>n;n+=2)e.push(n);return e}),lt:pt(function(e,t,n){var r=0>n?n+t:n;for(;--r>=0;)e.push(r);return e}),gt:pt(function(e,t,n){var r=0>n?n+t:n;for(;t>++r;)e.push(r);return e})}};for(n in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})i.pseudos[n]=lt(n);for(n in{submit:!0,reset:!0})i.pseudos[n]=ct(n);function ft(e,t){var n,r,o,a,s,u,l,c=E[e+\" \"];if(c)return t?0:c.slice(0);s=e,u=[],l=i.preFilter;while(s){(!n||(r=$.exec(s)))&&(r&&(s=s.slice(r[0].length)||s),u.push(o=[])),n=!1,(r=I.exec(s))&&(n=r.shift(),o.push({value:n,type:r[0].replace(W,\" \")}),s=s.slice(n.length));for(a in i.filter)!(r=U[a].exec(s))||l[a]&&!(r=l[a](r))||(n=r.shift(),o.push({value:n,type:a,matches:r}),s=s.slice(n.length));if(!n)break}return t?s.length:s?st.error(e):E(e,u).slice(0)}function dt(e){var t=0,n=e.length,r=\"\";for(;n>t;t++)r+=e[t].value;return r}function ht(e,t,n){var i=t.dir,o=n&&\"parentNode\"===i,a=C++;return t.first?function(t,n,r){while(t=t[i])if(1===t.nodeType||o)return e(t,n,r)}:function(t,n,s){var u,l,c,p=N+\" \"+a;if(s){while(t=t[i])if((1===t.nodeType||o)&&e(t,n,s))return!0}else while(t=t[i])if(1===t.nodeType||o)if(c=t[x]||(t[x]={}),(l=c[i])&&l[0]===p){if((u=l[1])===!0||u===r)return u===!0}else if(l=c[i]=[p],l[1]=e(t,n,s)||r,l[1]===!0)return!0}}function gt(e){return e.length>1?function(t,n,r){var i=e.length;while(i--)if(!e[i](t,n,r))return!1;return!0}:e[0]}function mt(e,t,n,r,i){var o,a=[],s=0,u=e.length,l=null!=t;for(;u>s;s++)(o=e[s])&&(!n||n(o,r,i))&&(a.push(o),l&&t.push(s));return a}function yt(e,t,n,r,i,o){return r&&!r[x]&&(r=yt(r)),i&&!i[x]&&(i=yt(i,o)),ot(function(o,a,s,u){var l,c,p,f=[],d=[],h=a.length,g=o||xt(t||\"*\",s.nodeType?[s]:s,[]),m=!e||!o&&t?g:mt(g,f,e,s,u),y=n?i||(o?e:h||r)?[]:a:m;if(n&&n(m,y,s,u),r){l=mt(y,d),r(l,[],s,u),c=l.length;while(c--)(p=l[c])&&(y[d[c]]=!(m[d[c]]=p))}if(o){if(i||e){if(i){l=[],c=y.length;while(c--)(p=y[c])&&l.push(m[c]=p);i(null,y=[],l,u)}c=y.length;while(c--)(p=y[c])&&(l=i?M.call(o,p):f[c])>-1&&(o[l]=!(a[l]=p))}}else y=mt(y===a?y.splice(h,y.length):y),i?i(null,a,y,u):H.apply(a,y)})}function vt(e){var t,n,r,o=e.length,a=i.relative[e[0].type],s=a||i.relative[\" \"],u=a?1:0,c=ht(function(e){return e===t},s,!0),p=ht(function(e){return M.call(t,e)>-1},s,!0),f=[function(e,n,r){return!a&&(r||n!==l)||((t=n).nodeType?c(e,n,r):p(e,n,r))}];for(;o>u;u++)if(n=i.relative[e[u].type])f=[ht(gt(f),n)];else{if(n=i.filter[e[u].type].apply(null,e[u].matches),n[x]){for(r=++u;o>r;r++)if(i.relative[e[r].type])break;return yt(u>1&&gt(f),u>1&&dt(e.slice(0,u-1)).replace(W,\"$1\"),n,r>u&&vt(e.slice(u,r)),o>r&&vt(e=e.slice(r)),o>r&&dt(e))}f.push(n)}return gt(f)}function bt(e,t){var n=0,o=t.length>0,a=e.length>0,s=function(s,u,c,f,d){var h,g,m,y=[],v=0,b=\"0\",x=s&&[],w=null!=d,T=l,C=s||a&&i.find.TAG(\"*\",d&&u.parentNode||u),k=N+=null==T?1:Math.random()||.1;for(w&&(l=u!==p&&u,r=n);null!=(h=C[b]);b++){if(a&&h){g=0;while(m=e[g++])if(m(h,u,c)){f.push(h);break}w&&(N=k,r=++n)}o&&((h=!m&&h)&&v--,s&&x.push(h))}if(v+=b,o&&b!==v){g=0;while(m=t[g++])m(x,y,u,c);if(s){if(v>0)while(b--)x[b]||y[b]||(y[b]=L.call(f));y=mt(y)}H.apply(f,y),w&&!s&&y.length>0&&v+t.length>1&&st.uniqueSort(f)}return w&&(N=k,l=T),x};return o?ot(s):s}s=st.compile=function(e,t){var n,r=[],i=[],o=S[e+\" \"];if(!o){t||(t=ft(e)),n=t.length;while(n--)o=vt(t[n]),o[x]?r.push(o):i.push(o);o=S(e,bt(i,r))}return o};function xt(e,t,n){var r=0,i=t.length;for(;i>r;r++)st(e,t[r],n);return n}function wt(e,t,n,r){var o,a,u,l,c,p=ft(e);if(!r&&1===p.length){if(a=p[0]=p[0].slice(0),a.length>2&&\"ID\"===(u=a[0]).type&&9===t.nodeType&&!d&&i.relative[a[1].type]){if(t=i.find.ID(u.matches[0].replace(et,tt),t)[0],!t)return n;e=e.slice(a.shift().value.length)}o=U.needsContext.test(e)?0:a.length;while(o--){if(u=a[o],i.relative[l=u.type])break;if((c=i.find[l])&&(r=c(u.matches[0].replace(et,tt),V.test(a[0].type)&&t.parentNode||t))){if(a.splice(o,1),e=r.length&&dt(a),!e)return H.apply(n,q.call(r,0)),n;break}}}return s(e,p)(r,t,d,n,V.test(e)),n}i.pseudos.nth=i.pseudos.eq;function Tt(){}i.filters=Tt.prototype=i.pseudos,i.setFilters=new Tt,c(),st.attr=b.attr,b.find=st,b.expr=st.selectors,b.expr[\":\"]=b.expr.pseudos,b.unique=st.uniqueSort,b.text=st.getText,b.isXMLDoc=st.isXML,b.contains=st.contains}(e);var at=/Until$/,st=/^(?:parents|prev(?:Until|All))/,ut=/^.[^:#\\[\\.,]*$/,lt=b.expr.match.needsContext,ct={children:!0,contents:!0,next:!0,prev:!0};b.fn.extend({find:function(e){var t,n,r,i=this.length;if(\"string\"!=typeof e)return r=this,this.pushStack(b(e).filter(function(){for(t=0;i>t;t++)if(b.contains(r[t],this))return!0}));for(n=[],t=0;i>t;t++)b.find(e,this[t],n);return n=this.pushStack(i>1?b.unique(n):n),n.selector=(this.selector?this.selector+\" \":\"\")+e,n},has:function(e){var t,n=b(e,this),r=n.length;return this.filter(function(){for(t=0;r>t;t++)if(b.contains(this,n[t]))return!0})},not:function(e){return this.pushStack(ft(this,e,!1))},filter:function(e){return this.pushStack(ft(this,e,!0))},is:function(e){return!!e&&(\"string\"==typeof e?lt.test(e)?b(e,this.context).index(this[0])>=0:b.filter(e,this).length>0:this.filter(e).length>0)},closest:function(e,t){var n,r=0,i=this.length,o=[],a=lt.test(e)||\"string\"!=typeof e?b(e,t||this.context):0;for(;i>r;r++){n=this[r];while(n&&n.ownerDocument&&n!==t&&11!==n.nodeType){if(a?a.index(n)>-1:b.find.matchesSelector(n,e)){o.push(n);break}n=n.parentNode}}return this.pushStack(o.length>1?b.unique(o):o)},index:function(e){return e?\"string\"==typeof e?b.inArray(this[0],b(e)):b.inArray(e.jquery?e[0]:e,this):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){var n=\"string\"==typeof e?b(e,t):b.makeArray(e&&e.nodeType?[e]:e),r=b.merge(this.get(),n);return this.pushStack(b.unique(r))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),b.fn.andSelf=b.fn.addBack;function pt(e,t){do e=e[t];while(e&&1!==e.nodeType);return e}b.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return b.dir(e,\"parentNode\")},parentsUntil:function(e,t,n){return b.dir(e,\"parentNode\",n)},next:function(e){return pt(e,\"nextSibling\")},prev:function(e){return pt(e,\"previousSibling\")},nextAll:function(e){return b.dir(e,\"nextSibling\")},prevAll:function(e){return b.dir(e,\"previousSibling\")},nextUntil:function(e,t,n){return b.dir(e,\"nextSibling\",n)},prevUntil:function(e,t,n){return b.dir(e,\"previousSibling\",n)},siblings:function(e){return b.sibling((e.parentNode||{}).firstChild,e)},children:function(e){return b.sibling(e.firstChild)},contents:function(e){return b.nodeName(e,\"iframe\")?e.contentDocument||e.contentWindow.document:b.merge([],e.childNodes)}},function(e,t){b.fn[e]=function(n,r){var i=b.map(this,t,n);return at.test(e)||(r=n),r&&\"string\"==typeof r&&(i=b.filter(r,i)),i=this.length>1&&!ct[e]?b.unique(i):i,this.length>1&&st.test(e)&&(i=i.reverse()),this.pushStack(i)}}),b.extend({filter:function(e,t,n){return n&&(e=\":not(\"+e+\")\"),1===t.length?b.find.matchesSelector(t[0],e)?[t[0]]:[]:b.find.matches(e,t)},dir:function(e,n,r){var i=[],o=e[n];while(o&&9!==o.nodeType&&(r===t||1!==o.nodeType||!b(o).is(r)))1===o.nodeType&&i.push(o),o=o[n];return i},sibling:function(e,t){var n=[];for(;e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n}});function ft(e,t,n){if(t=t||0,b.isFunction(t))return b.grep(e,function(e,r){var i=!!t.call(e,r,e);return i===n});if(t.nodeType)return b.grep(e,function(e){return e===t===n});if(\"string\"==typeof t){var r=b.grep(e,function(e){return 1===e.nodeType});if(ut.test(t))return b.filter(t,r,!n);t=b.filter(t,r)}return b.grep(e,function(e){return b.inArray(e,t)>=0===n})}function dt(e){var t=ht.split(\"|\"),n=e.createDocumentFragment();if(n.createElement)while(t.length)n.createElement(t.pop());return n}var ht=\"abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video\",gt=/ jQuery\\d+=\"(?:null|\\d+)\"/g,mt=RegExp(\"<(?:\"+ht+\")[\\\\s/>]\",\"i\"),yt=/^\\s+/,vt=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:]+)[^>]*)\\/>/gi,bt=/<([\\w:]+)/,xt=/<tbody/i,wt=/<|&#?\\w+;/,Tt=/<(?:script|style|link)/i,Nt=/^(?:checkbox|radio)$/i,Ct=/checked\\s*(?:[^=]|=\\s*.checked.)/i,kt=/^$|\\/(?:java|ecma)script/i,Et=/^true\\/(.*)/,St=/^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g,At={option:[1,\"<select multiple='multiple'>\",\"</select>\"],legend:[1,\"<fieldset>\",\"</fieldset>\"],area:[1,\"<map>\",\"</map>\"],param:[1,\"<object>\",\"</object>\"],thead:[1,\"<table>\",\"</table>\"],tr:[2,\"<table><tbody>\",\"</tbody></table>\"],col:[2,\"<table><tbody></tbody><colgroup>\",\"</colgroup></table>\"],td:[3,\"<table><tbody><tr>\",\"</tr></tbody></table>\"],_default:b.support.htmlSerialize?[0,\"\",\"\"]:[1,\"X<div>\",\"</div>\"]},jt=dt(o),Dt=jt.appendChild(o.createElement(\"div\"));At.optgroup=At.option,At.tbody=At.tfoot=At.colgroup=At.caption=At.thead,At.th=At.td,b.fn.extend({text:function(e){return b.access(this,function(e){return e===t?b.text(this):this.empty().append((this[0]&&this[0].ownerDocument||o).createTextNode(e))},null,e,arguments.length)},wrapAll:function(e){if(b.isFunction(e))return this.each(function(t){b(this).wrapAll(e.call(this,t))});if(this[0]){var t=b(e,this[0].ownerDocument).eq(0).clone(!0);this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstChild&&1===e.firstChild.nodeType)e=e.firstChild;return e}).append(this)}return this},wrapInner:function(e){return b.isFunction(e)?this.each(function(t){b(this).wrapInner(e.call(this,t))}):this.each(function(){var t=b(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=b.isFunction(e);return this.each(function(n){b(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(){return this.parent().each(function(){b.nodeName(this,\"body\")||b(this).replaceWith(this.childNodes)}).end()},append:function(){return this.domManip(arguments,!0,function(e){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&this.appendChild(e)})},prepend:function(){return this.domManip(arguments,!0,function(e){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&this.insertBefore(e,this.firstChild)})},before:function(){return this.domManip(arguments,!1,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return this.domManip(arguments,!1,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},remove:function(e,t){var n,r=0;for(;null!=(n=this[r]);r++)(!e||b.filter(e,[n]).length>0)&&(t||1!==n.nodeType||b.cleanData(Ot(n)),n.parentNode&&(t&&b.contains(n.ownerDocument,n)&&Mt(Ot(n,\"script\")),n.parentNode.removeChild(n)));return this},empty:function(){var e,t=0;for(;null!=(e=this[t]);t++){1===e.nodeType&&b.cleanData(Ot(e,!1));while(e.firstChild)e.removeChild(e.firstChild);e.options&&b.nodeName(e,\"select\")&&(e.options.length=0)}return this},clone:function(e,t){return e=null==e?!1:e,t=null==t?e:t,this.map(function(){return b.clone(this,e,t)})},html:function(e){return b.access(this,function(e){var n=this[0]||{},r=0,i=this.length;if(e===t)return 1===n.nodeType?n.innerHTML.replace(gt,\"\"):t;if(!(\"string\"!=typeof e||Tt.test(e)||!b.support.htmlSerialize&&mt.test(e)||!b.support.leadingWhitespace&&yt.test(e)||At[(bt.exec(e)||[\"\",\"\"])[1].toLowerCase()])){e=e.replace(vt,\"<$1></$2>\");try{for(;i>r;r++)n=this[r]||{},1===n.nodeType&&(b.cleanData(Ot(n,!1)),n.innerHTML=e);n=0}catch(o){}}n&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(e){var t=b.isFunction(e);return t||\"string\"==typeof e||(e=b(e).not(this).detach()),this.domManip([e],!0,function(e){var t=this.nextSibling,n=this.parentNode;n&&(b(this).remove(),n.insertBefore(e,t))})},detach:function(e){return this.remove(e,!0)},domManip:function(e,n,r){e=f.apply([],e);var i,o,a,s,u,l,c=0,p=this.length,d=this,h=p-1,g=e[0],m=b.isFunction(g);if(m||!(1>=p||\"string\"!=typeof g||b.support.checkClone)&&Ct.test(g))return this.each(function(i){var o=d.eq(i);m&&(e[0]=g.call(this,i,n?o.html():t)),o.domManip(e,n,r)});if(p&&(l=b.buildFragment(e,this[0].ownerDocument,!1,this),i=l.firstChild,1===l.childNodes.length&&(l=i),i)){for(n=n&&b.nodeName(i,\"tr\"),s=b.map(Ot(l,\"script\"),Ht),a=s.length;p>c;c++)o=l,c!==h&&(o=b.clone(o,!0,!0),a&&b.merge(s,Ot(o,\"script\"))),r.call(n&&b.nodeName(this[c],\"table\")?Lt(this[c],\"tbody\"):this[c],o,c);if(a)for(u=s[s.length-1].ownerDocument,b.map(s,qt),c=0;a>c;c++)o=s[c],kt.test(o.type||\"\")&&!b._data(o,\"globalEval\")&&b.contains(u,o)&&(o.src?b.ajax({url:o.src,type:\"GET\",dataType:\"script\",async:!1,global:!1,\"throws\":!0}):b.globalEval((o.text||o.textContent||o.innerHTML||\"\").replace(St,\"\")));l=i=null}return this}});function Lt(e,t){return e.getElementsByTagName(t)[0]||e.appendChild(e.ownerDocument.createElement(t))}function Ht(e){var t=e.getAttributeNode(\"type\");return e.type=(t&&t.specified)+\"/\"+e.type,e}function qt(e){var t=Et.exec(e.type);return t?e.type=t[1]:e.removeAttribute(\"type\"),e}function Mt(e,t){var n,r=0;for(;null!=(n=e[r]);r++)b._data(n,\"globalEval\",!t||b._data(t[r],\"globalEval\"))}function _t(e,t){if(1===t.nodeType&&b.hasData(e)){var n,r,i,o=b._data(e),a=b._data(t,o),s=o.events;if(s){delete a.handle,a.events={};for(n in s)for(r=0,i=s[n].length;i>r;r++)b.event.add(t,n,s[n][r])}a.data&&(a.data=b.extend({},a.data))}}function Ft(e,t){var n,r,i;if(1===t.nodeType){if(n=t.nodeName.toLowerCase(),!b.support.noCloneEvent&&t[b.expando]){i=b._data(t);for(r in i.events)b.removeEvent(t,r,i.handle);t.removeAttribute(b.expando)}\"script\"===n&&t.text!==e.text?(Ht(t).text=e.text,qt(t)):\"object\"===n?(t.parentNode&&(t.outerHTML=e.outerHTML),b.support.html5Clone&&e.innerHTML&&!b.trim(t.innerHTML)&&(t.innerHTML=e.innerHTML)):\"input\"===n&&Nt.test(e.type)?(t.defaultChecked=t.checked=e.checked,t.value!==e.value&&(t.value=e.value)):\"option\"===n?t.defaultSelected=t.selected=e.defaultSelected:(\"input\"===n||\"textarea\"===n)&&(t.defaultValue=e.defaultValue)}}b.each({appendTo:\"append\",prependTo:\"prepend\",insertBefore:\"before\",insertAfter:\"after\",replaceAll:\"replaceWith\"},function(e,t){b.fn[e]=function(e){var n,r=0,i=[],o=b(e),a=o.length-1;for(;a>=r;r++)n=r===a?this:this.clone(!0),b(o[r])[t](n),d.apply(i,n.get());return this.pushStack(i)}});function Ot(e,n){var r,o,a=0,s=typeof e.getElementsByTagName!==i?e.getElementsByTagName(n||\"*\"):typeof e.querySelectorAll!==i?e.querySelectorAll(n||\"*\"):t;if(!s)for(s=[],r=e.childNodes||e;null!=(o=r[a]);a++)!n||b.nodeName(o,n)?s.push(o):b.merge(s,Ot(o,n));return n===t||n&&b.nodeName(e,n)?b.merge([e],s):s}function Bt(e){Nt.test(e.type)&&(e.defaultChecked=e.checked)}b.extend({clone:function(e,t,n){var r,i,o,a,s,u=b.contains(e.ownerDocument,e);if(b.support.html5Clone||b.isXMLDoc(e)||!mt.test(\"<\"+e.nodeName+\">\")?o=e.cloneNode(!0):(Dt.innerHTML=e.outerHTML,Dt.removeChild(o=Dt.firstChild)),!(b.support.noCloneEvent&&b.support.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||b.isXMLDoc(e)))for(r=Ot(o),s=Ot(e),a=0;null!=(i=s[a]);++a)r[a]&&Ft(i,r[a]);if(t)if(n)for(s=s||Ot(e),r=r||Ot(o),a=0;null!=(i=s[a]);a++)_t(i,r[a]);else _t(e,o);return r=Ot(o,\"script\"),r.length>0&&Mt(r,!u&&Ot(e,\"script\")),r=s=i=null,o},buildFragment:function(e,t,n,r){var i,o,a,s,u,l,c,p=e.length,f=dt(t),d=[],h=0;for(;p>h;h++)if(o=e[h],o||0===o)if(\"object\"===b.type(o))b.merge(d,o.nodeType?[o]:o);else if(wt.test(o)){s=s||f.appendChild(t.createElement(\"div\")),u=(bt.exec(o)||[\"\",\"\"])[1].toLowerCase(),c=At[u]||At._default,s.innerHTML=c[1]+o.replace(vt,\"<$1></$2>\")+c[2],i=c[0];while(i--)s=s.lastChild;if(!b.support.leadingWhitespace&&yt.test(o)&&d.push(t.createTextNode(yt.exec(o)[0])),!b.support.tbody){o=\"table\"!==u||xt.test(o)?\"<table>\"!==c[1]||xt.test(o)?0:s:s.firstChild,i=o&&o.childNodes.length;while(i--)b.nodeName(l=o.childNodes[i],\"tbody\")&&!l.childNodes.length&&o.removeChild(l)\n}b.merge(d,s.childNodes),s.textContent=\"\";while(s.firstChild)s.removeChild(s.firstChild);s=f.lastChild}else d.push(t.createTextNode(o));s&&f.removeChild(s),b.support.appendChecked||b.grep(Ot(d,\"input\"),Bt),h=0;while(o=d[h++])if((!r||-1===b.inArray(o,r))&&(a=b.contains(o.ownerDocument,o),s=Ot(f.appendChild(o),\"script\"),a&&Mt(s),n)){i=0;while(o=s[i++])kt.test(o.type||\"\")&&n.push(o)}return s=null,f},cleanData:function(e,t){var n,r,o,a,s=0,u=b.expando,l=b.cache,p=b.support.deleteExpando,f=b.event.special;for(;null!=(n=e[s]);s++)if((t||b.acceptData(n))&&(o=n[u],a=o&&l[o])){if(a.events)for(r in a.events)f[r]?b.event.remove(n,r):b.removeEvent(n,r,a.handle);l[o]&&(delete l[o],p?delete n[u]:typeof n.removeAttribute!==i?n.removeAttribute(u):n[u]=null,c.push(o))}}});var Pt,Rt,Wt,$t=/alpha\\([^)]*\\)/i,It=/opacity\\s*=\\s*([^)]*)/,zt=/^(top|right|bottom|left)$/,Xt=/^(none|table(?!-c[ea]).+)/,Ut=/^margin/,Vt=RegExp(\"^(\"+x+\")(.*)$\",\"i\"),Yt=RegExp(\"^(\"+x+\")(?!px)[a-z%]+$\",\"i\"),Jt=RegExp(\"^([+-])=(\"+x+\")\",\"i\"),Gt={BODY:\"block\"},Qt={position:\"absolute\",visibility:\"hidden\",display:\"block\"},Kt={letterSpacing:0,fontWeight:400},Zt=[\"Top\",\"Right\",\"Bottom\",\"Left\"],en=[\"Webkit\",\"O\",\"Moz\",\"ms\"];function tn(e,t){if(t in e)return t;var n=t.charAt(0).toUpperCase()+t.slice(1),r=t,i=en.length;while(i--)if(t=en[i]+n,t in e)return t;return r}function nn(e,t){return e=t||e,\"none\"===b.css(e,\"display\")||!b.contains(e.ownerDocument,e)}function rn(e,t){var n,r,i,o=[],a=0,s=e.length;for(;s>a;a++)r=e[a],r.style&&(o[a]=b._data(r,\"olddisplay\"),n=r.style.display,t?(o[a]||\"none\"!==n||(r.style.display=\"\"),\"\"===r.style.display&&nn(r)&&(o[a]=b._data(r,\"olddisplay\",un(r.nodeName)))):o[a]||(i=nn(r),(n&&\"none\"!==n||!i)&&b._data(r,\"olddisplay\",i?n:b.css(r,\"display\"))));for(a=0;s>a;a++)r=e[a],r.style&&(t&&\"none\"!==r.style.display&&\"\"!==r.style.display||(r.style.display=t?o[a]||\"\":\"none\"));return e}b.fn.extend({css:function(e,n){return b.access(this,function(e,n,r){var i,o,a={},s=0;if(b.isArray(n)){for(o=Rt(e),i=n.length;i>s;s++)a[n[s]]=b.css(e,n[s],!1,o);return a}return r!==t?b.style(e,n,r):b.css(e,n)},e,n,arguments.length>1)},show:function(){return rn(this,!0)},hide:function(){return rn(this)},toggle:function(e){var t=\"boolean\"==typeof e;return this.each(function(){(t?e:nn(this))?b(this).show():b(this).hide()})}}),b.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Wt(e,\"opacity\");return\"\"===n?\"1\":n}}}},cssNumber:{columnCount:!0,fillOpacity:!0,fontWeight:!0,lineHeight:!0,opacity:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{\"float\":b.support.cssFloat?\"cssFloat\":\"styleFloat\"},style:function(e,n,r,i){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var o,a,s,u=b.camelCase(n),l=e.style;if(n=b.cssProps[u]||(b.cssProps[u]=tn(l,u)),s=b.cssHooks[n]||b.cssHooks[u],r===t)return s&&\"get\"in s&&(o=s.get(e,!1,i))!==t?o:l[n];if(a=typeof r,\"string\"===a&&(o=Jt.exec(r))&&(r=(o[1]+1)*o[2]+parseFloat(b.css(e,n)),a=\"number\"),!(null==r||\"number\"===a&&isNaN(r)||(\"number\"!==a||b.cssNumber[u]||(r+=\"px\"),b.support.clearCloneStyle||\"\"!==r||0!==n.indexOf(\"background\")||(l[n]=\"inherit\"),s&&\"set\"in s&&(r=s.set(e,r,i))===t)))try{l[n]=r}catch(c){}}},css:function(e,n,r,i){var o,a,s,u=b.camelCase(n);return n=b.cssProps[u]||(b.cssProps[u]=tn(e.style,u)),s=b.cssHooks[n]||b.cssHooks[u],s&&\"get\"in s&&(a=s.get(e,!0,r)),a===t&&(a=Wt(e,n,i)),\"normal\"===a&&n in Kt&&(a=Kt[n]),\"\"===r||r?(o=parseFloat(a),r===!0||b.isNumeric(o)?o||0:a):a},swap:function(e,t,n,r){var i,o,a={};for(o in t)a[o]=e.style[o],e.style[o]=t[o];i=n.apply(e,r||[]);for(o in t)e.style[o]=a[o];return i}}),e.getComputedStyle?(Rt=function(t){return e.getComputedStyle(t,null)},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),u=s?s.getPropertyValue(n)||s[n]:t,l=e.style;return s&&(\"\"!==u||b.contains(e.ownerDocument,e)||(u=b.style(e,n)),Yt.test(u)&&Ut.test(n)&&(i=l.width,o=l.minWidth,a=l.maxWidth,l.minWidth=l.maxWidth=l.width=u,u=s.width,l.width=i,l.minWidth=o,l.maxWidth=a)),u}):o.documentElement.currentStyle&&(Rt=function(e){return e.currentStyle},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),u=s?s[n]:t,l=e.style;return null==u&&l&&l[n]&&(u=l[n]),Yt.test(u)&&!zt.test(n)&&(i=l.left,o=e.runtimeStyle,a=o&&o.left,a&&(o.left=e.currentStyle.left),l.left=\"fontSize\"===n?\"1em\":u,u=l.pixelLeft+\"px\",l.left=i,a&&(o.left=a)),\"\"===u?\"auto\":u});function on(e,t,n){var r=Vt.exec(t);return r?Math.max(0,r[1]-(n||0))+(r[2]||\"px\"):t}function an(e,t,n,r,i){var o=n===(r?\"border\":\"content\")?4:\"width\"===t?1:0,a=0;for(;4>o;o+=2)\"margin\"===n&&(a+=b.css(e,n+Zt[o],!0,i)),r?(\"content\"===n&&(a-=b.css(e,\"padding\"+Zt[o],!0,i)),\"margin\"!==n&&(a-=b.css(e,\"border\"+Zt[o]+\"Width\",!0,i))):(a+=b.css(e,\"padding\"+Zt[o],!0,i),\"padding\"!==n&&(a+=b.css(e,\"border\"+Zt[o]+\"Width\",!0,i)));return a}function sn(e,t,n){var r=!0,i=\"width\"===t?e.offsetWidth:e.offsetHeight,o=Rt(e),a=b.support.boxSizing&&\"border-box\"===b.css(e,\"boxSizing\",!1,o);if(0>=i||null==i){if(i=Wt(e,t,o),(0>i||null==i)&&(i=e.style[t]),Yt.test(i))return i;r=a&&(b.support.boxSizingReliable||i===e.style[t]),i=parseFloat(i)||0}return i+an(e,t,n||(a?\"border\":\"content\"),r,o)+\"px\"}function un(e){var t=o,n=Gt[e];return n||(n=ln(e,t),\"none\"!==n&&n||(Pt=(Pt||b(\"<iframe frameborder='0' width='0' height='0'/>\").css(\"cssText\",\"display:block !important\")).appendTo(t.documentElement),t=(Pt[0].contentWindow||Pt[0].contentDocument).document,t.write(\"<!doctype html><html><body>\"),t.close(),n=ln(e,t),Pt.detach()),Gt[e]=n),n}function ln(e,t){var n=b(t.createElement(e)).appendTo(t.body),r=b.css(n[0],\"display\");return n.remove(),r}b.each([\"height\",\"width\"],function(e,n){b.cssHooks[n]={get:function(e,r,i){return r?0===e.offsetWidth&&Xt.test(b.css(e,\"display\"))?b.swap(e,Qt,function(){return sn(e,n,i)}):sn(e,n,i):t},set:function(e,t,r){var i=r&&Rt(e);return on(e,t,r?an(e,n,r,b.support.boxSizing&&\"border-box\"===b.css(e,\"boxSizing\",!1,i),i):0)}}}),b.support.opacity||(b.cssHooks.opacity={get:function(e,t){return It.test((t&&e.currentStyle?e.currentStyle.filter:e.style.filter)||\"\")?.01*parseFloat(RegExp.$1)+\"\":t?\"1\":\"\"},set:function(e,t){var n=e.style,r=e.currentStyle,i=b.isNumeric(t)?\"alpha(opacity=\"+100*t+\")\":\"\",o=r&&r.filter||n.filter||\"\";n.zoom=1,(t>=1||\"\"===t)&&\"\"===b.trim(o.replace($t,\"\"))&&n.removeAttribute&&(n.removeAttribute(\"filter\"),\"\"===t||r&&!r.filter)||(n.filter=$t.test(o)?o.replace($t,i):o+\" \"+i)}}),b(function(){b.support.reliableMarginRight||(b.cssHooks.marginRight={get:function(e,n){return n?b.swap(e,{display:\"inline-block\"},Wt,[e,\"marginRight\"]):t}}),!b.support.pixelPosition&&b.fn.position&&b.each([\"top\",\"left\"],function(e,n){b.cssHooks[n]={get:function(e,r){return r?(r=Wt(e,n),Yt.test(r)?b(e).position()[n]+\"px\":r):t}}})}),b.expr&&b.expr.filters&&(b.expr.filters.hidden=function(e){return 0>=e.offsetWidth&&0>=e.offsetHeight||!b.support.reliableHiddenOffsets&&\"none\"===(e.style&&e.style.display||b.css(e,\"display\"))},b.expr.filters.visible=function(e){return!b.expr.filters.hidden(e)}),b.each({margin:\"\",padding:\"\",border:\"Width\"},function(e,t){b.cssHooks[e+t]={expand:function(n){var r=0,i={},o=\"string\"==typeof n?n.split(\" \"):[n];for(;4>r;r++)i[e+Zt[r]+t]=o[r]||o[r-2]||o[0];return i}},Ut.test(e)||(b.cssHooks[e+t].set=on)});var cn=/%20/g,pn=/\\[\\]$/,fn=/\\r?\\n/g,dn=/^(?:submit|button|image|reset|file)$/i,hn=/^(?:input|select|textarea|keygen)/i;b.fn.extend({serialize:function(){return b.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=b.prop(this,\"elements\");return e?b.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!b(this).is(\":disabled\")&&hn.test(this.nodeName)&&!dn.test(e)&&(this.checked||!Nt.test(e))}).map(function(e,t){var n=b(this).val();return null==n?null:b.isArray(n)?b.map(n,function(e){return{name:t.name,value:e.replace(fn,\"\\r\\n\")}}):{name:t.name,value:n.replace(fn,\"\\r\\n\")}}).get()}}),b.param=function(e,n){var r,i=[],o=function(e,t){t=b.isFunction(t)?t():null==t?\"\":t,i[i.length]=encodeURIComponent(e)+\"=\"+encodeURIComponent(t)};if(n===t&&(n=b.ajaxSettings&&b.ajaxSettings.traditional),b.isArray(e)||e.jquery&&!b.isPlainObject(e))b.each(e,function(){o(this.name,this.value)});else for(r in e)gn(r,e[r],n,o);return i.join(\"&\").replace(cn,\"+\")};function gn(e,t,n,r){var i;if(b.isArray(t))b.each(t,function(t,i){n||pn.test(e)?r(e,i):gn(e+\"[\"+(\"object\"==typeof i?t:\"\")+\"]\",i,n,r)});else if(n||\"object\"!==b.type(t))r(e,t);else for(i in t)gn(e+\"[\"+i+\"]\",t[i],n,r)}b.each(\"blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu\".split(\" \"),function(e,t){b.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),b.fn.hover=function(e,t){return this.mouseenter(e).mouseleave(t||e)};var mn,yn,vn=b.now(),bn=/\\?/,xn=/#.*$/,wn=/([?&])_=[^&]*/,Tn=/^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/gm,Nn=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,Cn=/^(?:GET|HEAD)$/,kn=/^\\/\\//,En=/^([\\w.+-]+:)(?:\\/\\/([^\\/?#:]*)(?::(\\d+)|)|)/,Sn=b.fn.load,An={},jn={},Dn=\"*/\".concat(\"*\");try{yn=a.href}catch(Ln){yn=o.createElement(\"a\"),yn.href=\"\",yn=yn.href}mn=En.exec(yn.toLowerCase())||[];function Hn(e){return function(t,n){\"string\"!=typeof t&&(n=t,t=\"*\");var r,i=0,o=t.toLowerCase().match(w)||[];if(b.isFunction(n))while(r=o[i++])\"+\"===r[0]?(r=r.slice(1)||\"*\",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function qn(e,n,r,i){var o={},a=e===jn;function s(u){var l;return o[u]=!0,b.each(e[u]||[],function(e,u){var c=u(n,r,i);return\"string\"!=typeof c||a||o[c]?a?!(l=c):t:(n.dataTypes.unshift(c),s(c),!1)}),l}return s(n.dataTypes[0])||!o[\"*\"]&&s(\"*\")}function Mn(e,n){var r,i,o=b.ajaxSettings.flatOptions||{};for(i in n)n[i]!==t&&((o[i]?e:r||(r={}))[i]=n[i]);return r&&b.extend(!0,e,r),e}b.fn.load=function(e,n,r){if(\"string\"!=typeof e&&Sn)return Sn.apply(this,arguments);var i,o,a,s=this,u=e.indexOf(\" \");return u>=0&&(i=e.slice(u,e.length),e=e.slice(0,u)),b.isFunction(n)?(r=n,n=t):n&&\"object\"==typeof n&&(a=\"POST\"),s.length>0&&b.ajax({url:e,type:a,dataType:\"html\",data:n}).done(function(e){o=arguments,s.html(i?b(\"<div>\").append(b.parseHTML(e)).find(i):e)}).complete(r&&function(e,t){s.each(r,o||[e.responseText,t,e])}),this},b.each([\"ajaxStart\",\"ajaxStop\",\"ajaxComplete\",\"ajaxError\",\"ajaxSuccess\",\"ajaxSend\"],function(e,t){b.fn[t]=function(e){return this.on(t,e)}}),b.each([\"get\",\"post\"],function(e,n){b[n]=function(e,r,i,o){return b.isFunction(r)&&(o=o||i,i=r,r=t),b.ajax({url:e,type:n,dataType:o,data:r,success:i})}}),b.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:yn,type:\"GET\",isLocal:Nn.test(mn[1]),global:!0,processData:!0,async:!0,contentType:\"application/x-www-form-urlencoded; charset=UTF-8\",accepts:{\"*\":Dn,text:\"text/plain\",html:\"text/html\",xml:\"application/xml, text/xml\",json:\"application/json, text/javascript\"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:\"responseXML\",text:\"responseText\"},converters:{\"* text\":e.String,\"text html\":!0,\"text json\":b.parseJSON,\"text xml\":b.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Mn(Mn(e,b.ajaxSettings),t):Mn(b.ajaxSettings,e)},ajaxPrefilter:Hn(An),ajaxTransport:Hn(jn),ajax:function(e,n){\"object\"==typeof e&&(n=e,e=t),n=n||{};var r,i,o,a,s,u,l,c,p=b.ajaxSetup({},n),f=p.context||p,d=p.context&&(f.nodeType||f.jquery)?b(f):b.event,h=b.Deferred(),g=b.Callbacks(\"once memory\"),m=p.statusCode||{},y={},v={},x=0,T=\"canceled\",N={readyState:0,getResponseHeader:function(e){var t;if(2===x){if(!c){c={};while(t=Tn.exec(a))c[t[1].toLowerCase()]=t[2]}t=c[e.toLowerCase()]}return null==t?null:t},getAllResponseHeaders:function(){return 2===x?a:null},setRequestHeader:function(e,t){var n=e.toLowerCase();return x||(e=v[n]=v[n]||e,y[e]=t),this},overrideMimeType:function(e){return x||(p.mimeType=e),this},statusCode:function(e){var t;if(e)if(2>x)for(t in e)m[t]=[m[t],e[t]];else N.always(e[N.status]);return this},abort:function(e){var t=e||T;return l&&l.abort(t),k(0,t),this}};if(h.promise(N).complete=g.add,N.success=N.done,N.error=N.fail,p.url=((e||p.url||yn)+\"\").replace(xn,\"\").replace(kn,mn[1]+\"//\"),p.type=n.method||n.type||p.method||p.type,p.dataTypes=b.trim(p.dataType||\"*\").toLowerCase().match(w)||[\"\"],null==p.crossDomain&&(r=En.exec(p.url.toLowerCase()),p.crossDomain=!(!r||r[1]===mn[1]&&r[2]===mn[2]&&(r[3]||(\"http:\"===r[1]?80:443))==(mn[3]||(\"http:\"===mn[1]?80:443)))),p.data&&p.processData&&\"string\"!=typeof p.data&&(p.data=b.param(p.data,p.traditional)),qn(An,p,n,N),2===x)return N;u=p.global,u&&0===b.active++&&b.event.trigger(\"ajaxStart\"),p.type=p.type.toUpperCase(),p.hasContent=!Cn.test(p.type),o=p.url,p.hasContent||(p.data&&(o=p.url+=(bn.test(o)?\"&\":\"?\")+p.data,delete p.data),p.cache===!1&&(p.url=wn.test(o)?o.replace(wn,\"$1_=\"+vn++):o+(bn.test(o)?\"&\":\"?\")+\"_=\"+vn++)),p.ifModified&&(b.lastModified[o]&&N.setRequestHeader(\"If-Modified-Since\",b.lastModified[o]),b.etag[o]&&N.setRequestHeader(\"If-None-Match\",b.etag[o])),(p.data&&p.hasContent&&p.contentType!==!1||n.contentType)&&N.setRequestHeader(\"Content-Type\",p.contentType),N.setRequestHeader(\"Accept\",p.dataTypes[0]&&p.accepts[p.dataTypes[0]]?p.accepts[p.dataTypes[0]]+(\"*\"!==p.dataTypes[0]?\", \"+Dn+\"; q=0.01\":\"\"):p.accepts[\"*\"]);for(i in p.headers)N.setRequestHeader(i,p.headers[i]);if(p.beforeSend&&(p.beforeSend.call(f,N,p)===!1||2===x))return N.abort();T=\"abort\";for(i in{success:1,error:1,complete:1})N[i](p[i]);if(l=qn(jn,p,n,N)){N.readyState=1,u&&d.trigger(\"ajaxSend\",[N,p]),p.async&&p.timeout>0&&(s=setTimeout(function(){N.abort(\"timeout\")},p.timeout));try{x=1,l.send(y,k)}catch(C){if(!(2>x))throw C;k(-1,C)}}else k(-1,\"No Transport\");function k(e,n,r,i){var c,y,v,w,T,C=n;2!==x&&(x=2,s&&clearTimeout(s),l=t,a=i||\"\",N.readyState=e>0?4:0,r&&(w=_n(p,N,r)),e>=200&&300>e||304===e?(p.ifModified&&(T=N.getResponseHeader(\"Last-Modified\"),T&&(b.lastModified[o]=T),T=N.getResponseHeader(\"etag\"),T&&(b.etag[o]=T)),204===e?(c=!0,C=\"nocontent\"):304===e?(c=!0,C=\"notmodified\"):(c=Fn(p,w),C=c.state,y=c.data,v=c.error,c=!v)):(v=C,(e||!C)&&(C=\"error\",0>e&&(e=0))),N.status=e,N.statusText=(n||C)+\"\",c?h.resolveWith(f,[y,C,N]):h.rejectWith(f,[N,C,v]),N.statusCode(m),m=t,u&&d.trigger(c?\"ajaxSuccess\":\"ajaxError\",[N,p,c?y:v]),g.fireWith(f,[N,C]),u&&(d.trigger(\"ajaxComplete\",[N,p]),--b.active||b.event.trigger(\"ajaxStop\")))}return N},getScript:function(e,n){return b.get(e,t,n,\"script\")},getJSON:function(e,t,n){return b.get(e,t,n,\"json\")}});function _n(e,n,r){var i,o,a,s,u=e.contents,l=e.dataTypes,c=e.responseFields;for(s in c)s in r&&(n[c[s]]=r[s]);while(\"*\"===l[0])l.shift(),o===t&&(o=e.mimeType||n.getResponseHeader(\"Content-Type\"));if(o)for(s in u)if(u[s]&&u[s].test(o)){l.unshift(s);break}if(l[0]in r)a=l[0];else{for(s in r){if(!l[0]||e.converters[s+\" \"+l[0]]){a=s;break}i||(i=s)}a=a||i}return a?(a!==l[0]&&l.unshift(a),r[a]):t}function Fn(e,t){var n,r,i,o,a={},s=0,u=e.dataTypes.slice(),l=u[0];if(e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u[1])for(i in e.converters)a[i.toLowerCase()]=e.converters[i];for(;r=u[++s];)if(\"*\"!==r){if(\"*\"!==l&&l!==r){if(i=a[l+\" \"+r]||a[\"* \"+r],!i)for(n in a)if(o=n.split(\" \"),o[1]===r&&(i=a[l+\" \"+o[0]]||a[\"* \"+o[0]])){i===!0?i=a[n]:a[n]!==!0&&(r=o[0],u.splice(s--,0,r));break}if(i!==!0)if(i&&e[\"throws\"])t=i(t);else try{t=i(t)}catch(c){return{state:\"parsererror\",error:i?c:\"No conversion from \"+l+\" to \"+r}}}l=r}return{state:\"success\",data:t}}b.ajaxSetup({accepts:{script:\"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript\"},contents:{script:/(?:java|ecma)script/},converters:{\"text script\":function(e){return b.globalEval(e),e}}}),b.ajaxPrefilter(\"script\",function(e){e.cache===t&&(e.cache=!1),e.crossDomain&&(e.type=\"GET\",e.global=!1)}),b.ajaxTransport(\"script\",function(e){if(e.crossDomain){var n,r=o.head||b(\"head\")[0]||o.documentElement;return{send:function(t,i){n=o.createElement(\"script\"),n.async=!0,e.scriptCharset&&(n.charset=e.scriptCharset),n.src=e.url,n.onload=n.onreadystatechange=function(e,t){(t||!n.readyState||/loaded|complete/.test(n.readyState))&&(n.onload=n.onreadystatechange=null,n.parentNode&&n.parentNode.removeChild(n),n=null,t||i(200,\"success\"))},r.insertBefore(n,r.firstChild)},abort:function(){n&&n.onload(t,!0)}}}});var On=[],Bn=/(=)\\?(?=&|$)|\\?\\?/;b.ajaxSetup({jsonp:\"callback\",jsonpCallback:function(){var e=On.pop()||b.expando+\"_\"+vn++;return this[e]=!0,e}}),b.ajaxPrefilter(\"json jsonp\",function(n,r,i){var o,a,s,u=n.jsonp!==!1&&(Bn.test(n.url)?\"url\":\"string\"==typeof n.data&&!(n.contentType||\"\").indexOf(\"application/x-www-form-urlencoded\")&&Bn.test(n.data)&&\"data\");return u||\"jsonp\"===n.dataTypes[0]?(o=n.jsonpCallback=b.isFunction(n.jsonpCallback)?n.jsonpCallback():n.jsonpCallback,u?n[u]=n[u].replace(Bn,\"$1\"+o):n.jsonp!==!1&&(n.url+=(bn.test(n.url)?\"&\":\"?\")+n.jsonp+\"=\"+o),n.converters[\"script json\"]=function(){return s||b.error(o+\" was not called\"),s[0]},n.dataTypes[0]=\"json\",a=e[o],e[o]=function(){s=arguments},i.always(function(){e[o]=a,n[o]&&(n.jsonpCallback=r.jsonpCallback,On.push(o)),s&&b.isFunction(a)&&a(s[0]),s=a=t}),\"script\"):t});var Pn,Rn,Wn=0,$n=e.ActiveXObject&&function(){var e;for(e in Pn)Pn[e](t,!0)};function In(){try{return new e.XMLHttpRequest}catch(t){}}function zn(){try{return new e.ActiveXObject(\"Microsoft.XMLHTTP\")}catch(t){}}b.ajaxSettings.xhr=e.ActiveXObject?function(){return!this.isLocal&&In()||zn()}:In,Rn=b.ajaxSettings.xhr(),b.support.cors=!!Rn&&\"withCredentials\"in Rn,Rn=b.support.ajax=!!Rn,Rn&&b.ajaxTransport(function(n){if(!n.crossDomain||b.support.cors){var r;return{send:function(i,o){var a,s,u=n.xhr();if(n.username?u.open(n.type,n.url,n.async,n.username,n.password):u.open(n.type,n.url,n.async),n.xhrFields)for(s in n.xhrFields)u[s]=n.xhrFields[s];n.mimeType&&u.overrideMimeType&&u.overrideMimeType(n.mimeType),n.crossDomain||i[\"X-Requested-With\"]||(i[\"X-Requested-With\"]=\"XMLHttpRequest\");try{for(s in i)u.setRequestHeader(s,i[s])}catch(l){}u.send(n.hasContent&&n.data||null),r=function(e,i){var s,l,c,p;try{if(r&&(i||4===u.readyState))if(r=t,a&&(u.onreadystatechange=b.noop,$n&&delete Pn[a]),i)4!==u.readyState&&u.abort();else{p={},s=u.status,l=u.getAllResponseHeaders(),\"string\"==typeof u.responseText&&(p.text=u.responseText);try{c=u.statusText}catch(f){c=\"\"}s||!n.isLocal||n.crossDomain?1223===s&&(s=204):s=p.text?200:404}}catch(d){i||o(-1,d)}p&&o(s,c,p,l)},n.async?4===u.readyState?setTimeout(r):(a=++Wn,$n&&(Pn||(Pn={},b(e).unload($n)),Pn[a]=r),u.onreadystatechange=r):r()},abort:function(){r&&r(t,!0)}}}});var Xn,Un,Vn=/^(?:toggle|show|hide)$/,Yn=RegExp(\"^(?:([+-])=|)(\"+x+\")([a-z%]*)$\",\"i\"),Jn=/queueHooks$/,Gn=[nr],Qn={\"*\":[function(e,t){var n,r,i=this.createTween(e,t),o=Yn.exec(t),a=i.cur(),s=+a||0,u=1,l=20;if(o){if(n=+o[2],r=o[3]||(b.cssNumber[e]?\"\":\"px\"),\"px\"!==r&&s){s=b.css(i.elem,e,!0)||n||1;do u=u||\".5\",s/=u,b.style(i.elem,e,s+r);while(u!==(u=i.cur()/a)&&1!==u&&--l)}i.unit=r,i.start=s,i.end=o[1]?s+(o[1]+1)*n:n}return i}]};function Kn(){return setTimeout(function(){Xn=t}),Xn=b.now()}function Zn(e,t){b.each(t,function(t,n){var r=(Qn[t]||[]).concat(Qn[\"*\"]),i=0,o=r.length;for(;o>i;i++)if(r[i].call(e,t,n))return})}function er(e,t,n){var r,i,o=0,a=Gn.length,s=b.Deferred().always(function(){delete u.elem}),u=function(){if(i)return!1;var t=Xn||Kn(),n=Math.max(0,l.startTime+l.duration-t),r=n/l.duration||0,o=1-r,a=0,u=l.tweens.length;for(;u>a;a++)l.tweens[a].run(o);return s.notifyWith(e,[l,o,n]),1>o&&u?n:(s.resolveWith(e,[l]),!1)},l=s.promise({elem:e,props:b.extend({},t),opts:b.extend(!0,{specialEasing:{}},n),originalProperties:t,originalOptions:n,startTime:Xn||Kn(),duration:n.duration,tweens:[],createTween:function(t,n){var r=b.Tween(e,l.opts,t,n,l.opts.specialEasing[t]||l.opts.easing);return l.tweens.push(r),r},stop:function(t){var n=0,r=t?l.tweens.length:0;if(i)return this;for(i=!0;r>n;n++)l.tweens[n].run(1);return t?s.resolveWith(e,[l,t]):s.rejectWith(e,[l,t]),this}}),c=l.props;for(tr(c,l.opts.specialEasing);a>o;o++)if(r=Gn[o].call(l,e,c,l.opts))return r;return Zn(l,c),b.isFunction(l.opts.start)&&l.opts.start.call(e,l),b.fx.timer(b.extend(u,{elem:e,anim:l,queue:l.opts.queue})),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always)}function tr(e,t){var n,r,i,o,a;for(i in e)if(r=b.camelCase(i),o=t[r],n=e[i],b.isArray(n)&&(o=n[1],n=e[i]=n[0]),i!==r&&(e[r]=n,delete e[i]),a=b.cssHooks[r],a&&\"expand\"in a){n=a.expand(n),delete e[r];for(i in n)i in e||(e[i]=n[i],t[i]=o)}else t[r]=o}b.Animation=b.extend(er,{tweener:function(e,t){b.isFunction(e)?(t=e,e=[\"*\"]):e=e.split(\" \");var n,r=0,i=e.length;for(;i>r;r++)n=e[r],Qn[n]=Qn[n]||[],Qn[n].unshift(t)},prefilter:function(e,t){t?Gn.unshift(e):Gn.push(e)}});function nr(e,t,n){var r,i,o,a,s,u,l,c,p,f=this,d=e.style,h={},g=[],m=e.nodeType&&nn(e);n.queue||(c=b._queueHooks(e,\"fx\"),null==c.unqueued&&(c.unqueued=0,p=c.empty.fire,c.empty.fire=function(){c.unqueued||p()}),c.unqueued++,f.always(function(){f.always(function(){c.unqueued--,b.queue(e,\"fx\").length||c.empty.fire()})})),1===e.nodeType&&(\"height\"in t||\"width\"in t)&&(n.overflow=[d.overflow,d.overflowX,d.overflowY],\"inline\"===b.css(e,\"display\")&&\"none\"===b.css(e,\"float\")&&(b.support.inlineBlockNeedsLayout&&\"inline\"!==un(e.nodeName)?d.zoom=1:d.display=\"inline-block\")),n.overflow&&(d.overflow=\"hidden\",b.support.shrinkWrapBlocks||f.always(function(){d.overflow=n.overflow[0],d.overflowX=n.overflow[1],d.overflowY=n.overflow[2]}));for(i in t)if(a=t[i],Vn.exec(a)){if(delete t[i],u=u||\"toggle\"===a,a===(m?\"hide\":\"show\"))continue;g.push(i)}if(o=g.length){s=b._data(e,\"fxshow\")||b._data(e,\"fxshow\",{}),\"hidden\"in s&&(m=s.hidden),u&&(s.hidden=!m),m?b(e).show():f.done(function(){b(e).hide()}),f.done(function(){var t;b._removeData(e,\"fxshow\");for(t in h)b.style(e,t,h[t])});for(i=0;o>i;i++)r=g[i],l=f.createTween(r,m?s[r]:0),h[r]=s[r]||b.style(e,r),r in s||(s[r]=l.start,m&&(l.end=l.start,l.start=\"width\"===r||\"height\"===r?1:0))}}function rr(e,t,n,r,i){return new rr.prototype.init(e,t,n,r,i)}b.Tween=rr,rr.prototype={constructor:rr,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||\"swing\",this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(b.cssNumber[n]?\"\":\"px\")},cur:function(){var e=rr.propHooks[this.prop];return e&&e.get?e.get(this):rr.propHooks._default.get(this)},run:function(e){var t,n=rr.propHooks[this.prop];return this.pos=t=this.options.duration?b.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):rr.propHooks._default.set(this),this}},rr.prototype.init.prototype=rr.prototype,rr.propHooks={_default:{get:function(e){var t;return null==e.elem[e.prop]||e.elem.style&&null!=e.elem.style[e.prop]?(t=b.css(e.elem,e.prop,\"\"),t&&\"auto\"!==t?t:0):e.elem[e.prop]},set:function(e){b.fx.step[e.prop]?b.fx.step[e.prop](e):e.elem.style&&(null!=e.elem.style[b.cssProps[e.prop]]||b.cssHooks[e.prop])?b.style(e.elem,e.prop,e.now+e.unit):e.elem[e.prop]=e.now}}},rr.propHooks.scrollTop=rr.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},b.each([\"toggle\",\"show\",\"hide\"],function(e,t){var n=b.fn[t];b.fn[t]=function(e,r,i){return null==e||\"boolean\"==typeof e?n.apply(this,arguments):this.animate(ir(t,!0),e,r,i)}}),b.fn.extend({fadeTo:function(e,t,n,r){return this.filter(nn).css(\"opacity\",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=b.isEmptyObject(e),o=b.speed(t,n,r),a=function(){var t=er(this,b.extend({},e),o);a.finish=function(){t.stop(!0)},(i||b._data(this,\"finish\"))&&t.stop(!0)};return a.finish=a,i||o.queue===!1?this.each(a):this.queue(o.queue,a)},stop:function(e,n,r){var i=function(e){var t=e.stop;delete e.stop,t(r)};return\"string\"!=typeof e&&(r=n,n=e,e=t),n&&e!==!1&&this.queue(e||\"fx\",[]),this.each(function(){var t=!0,n=null!=e&&e+\"queueHooks\",o=b.timers,a=b._data(this);if(n)a[n]&&a[n].stop&&i(a[n]);else for(n in a)a[n]&&a[n].stop&&Jn.test(n)&&i(a[n]);for(n=o.length;n--;)o[n].elem!==this||null!=e&&o[n].queue!==e||(o[n].anim.stop(r),t=!1,o.splice(n,1));(t||!r)&&b.dequeue(this,e)})},finish:function(e){return e!==!1&&(e=e||\"fx\"),this.each(function(){var t,n=b._data(this),r=n[e+\"queue\"],i=n[e+\"queueHooks\"],o=b.timers,a=r?r.length:0;for(n.finish=!0,b.queue(this,e,[]),i&&i.cur&&i.cur.finish&&i.cur.finish.call(this),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),o.splice(t,1));for(t=0;a>t;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish})}});function ir(e,t){var n,r={height:e},i=0;for(t=t?1:0;4>i;i+=2-t)n=Zt[i],r[\"margin\"+n]=r[\"padding\"+n]=e;return t&&(r.opacity=r.width=e),r}b.each({slideDown:ir(\"show\"),slideUp:ir(\"hide\"),slideToggle:ir(\"toggle\"),fadeIn:{opacity:\"show\"},fadeOut:{opacity:\"hide\"},fadeToggle:{opacity:\"toggle\"}},function(e,t){b.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}}),b.speed=function(e,t,n){var r=e&&\"object\"==typeof e?b.extend({},e):{complete:n||!n&&t||b.isFunction(e)&&e,duration:e,easing:n&&t||t&&!b.isFunction(t)&&t};return r.duration=b.fx.off?0:\"number\"==typeof r.duration?r.duration:r.duration in b.fx.speeds?b.fx.speeds[r.duration]:b.fx.speeds._default,(null==r.queue||r.queue===!0)&&(r.queue=\"fx\"),r.old=r.complete,r.complete=function(){b.isFunction(r.old)&&r.old.call(this),r.queue&&b.dequeue(this,r.queue)},r},b.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2}},b.timers=[],b.fx=rr.prototype.init,b.fx.tick=function(){var e,n=b.timers,r=0;for(Xn=b.now();n.length>r;r++)e=n[r],e()||n[r]!==e||n.splice(r--,1);n.length||b.fx.stop(),Xn=t},b.fx.timer=function(e){e()&&b.timers.push(e)&&b.fx.start()},b.fx.interval=13,b.fx.start=function(){Un||(Un=setInterval(b.fx.tick,b.fx.interval))},b.fx.stop=function(){clearInterval(Un),Un=null},b.fx.speeds={slow:600,fast:200,_default:400},b.fx.step={},b.expr&&b.expr.filters&&(b.expr.filters.animated=function(e){return b.grep(b.timers,function(t){return e===t.elem}).length}),b.fn.offset=function(e){if(arguments.length)return e===t?this:this.each(function(t){b.offset.setOffset(this,e,t)});var n,r,o={top:0,left:0},a=this[0],s=a&&a.ownerDocument;if(s)return n=s.documentElement,b.contains(n,a)?(typeof a.getBoundingClientRect!==i&&(o=a.getBoundingClientRect()),r=or(s),{top:o.top+(r.pageYOffset||n.scrollTop)-(n.clientTop||0),left:o.left+(r.pageXOffset||n.scrollLeft)-(n.clientLeft||0)}):o},b.offset={setOffset:function(e,t,n){var r=b.css(e,\"position\");\"static\"===r&&(e.style.position=\"relative\");var i=b(e),o=i.offset(),a=b.css(e,\"top\"),s=b.css(e,\"left\"),u=(\"absolute\"===r||\"fixed\"===r)&&b.inArray(\"auto\",[a,s])>-1,l={},c={},p,f;u?(c=i.position(),p=c.top,f=c.left):(p=parseFloat(a)||0,f=parseFloat(s)||0),b.isFunction(t)&&(t=t.call(e,n,o)),null!=t.top&&(l.top=t.top-o.top+p),null!=t.left&&(l.left=t.left-o.left+f),\"using\"in t?t.using.call(e,l):i.css(l)}},b.fn.extend({position:function(){if(this[0]){var e,t,n={top:0,left:0},r=this[0];return\"fixed\"===b.css(r,\"position\")?t=r.getBoundingClientRect():(e=this.offsetParent(),t=this.offset(),b.nodeName(e[0],\"html\")||(n=e.offset()),n.top+=b.css(e[0],\"borderTopWidth\",!0),n.left+=b.css(e[0],\"borderLeftWidth\",!0)),{top:t.top-n.top-b.css(r,\"marginTop\",!0),left:t.left-n.left-b.css(r,\"marginLeft\",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent||o.documentElement;while(e&&!b.nodeName(e,\"html\")&&\"static\"===b.css(e,\"position\"))e=e.offsetParent;return e||o.documentElement})}}),b.each({scrollLeft:\"pageXOffset\",scrollTop:\"pageYOffset\"},function(e,n){var r=/Y/.test(n);b.fn[e]=function(i){return b.access(this,function(e,i,o){var a=or(e);return o===t?a?n in a?a[n]:a.document.documentElement[i]:e[i]:(a?a.scrollTo(r?b(a).scrollLeft():o,r?o:b(a).scrollTop()):e[i]=o,t)},e,i,arguments.length,null)}});function or(e){return b.isWindow(e)?e:9===e.nodeType?e.defaultView||e.parentWindow:!1}b.each({Height:\"height\",Width:\"width\"},function(e,n){b.each({padding:\"inner\"+e,content:n,\"\":\"outer\"+e},function(r,i){b.fn[i]=function(i,o){var a=arguments.length&&(r||\"boolean\"!=typeof i),s=r||(i===!0||o===!0?\"margin\":\"border\");return b.access(this,function(n,r,i){var o;return b.isWindow(n)?n.document.documentElement[\"client\"+e]:9===n.nodeType?(o=n.documentElement,Math.max(n.body[\"scroll\"+e],o[\"scroll\"+e],n.body[\"offset\"+e],o[\"offset\"+e],o[\"client\"+e])):i===t?b.css(n,r,s):b.style(n,r,i,s)},n,a?i:t,a,null)}})}),e.jQuery=e.$=b,\"function\"==typeof define&&define.amd&&define.amd.jQuery&&define(\"jquery\",[],function(){return b})})(window);","Plazathemes_Newproductslider/js/owl.carousel.min.js":"\nrequire([\"jquery\"], function($){\n\"function\"!==typeof Object.create&&(Object.create=function(f){function g(){}g.prototype=f;return new g});\n(function(f,g,k){var l={init:function(a,b){this.$elem=f(b);this.options=f.extend({},f.fn.owlCarousel.options,this.$elem.data(),a);this.userOptions=a;this.loadContent()},loadContent:function(){function a(a){var d,e=\"\";if(\"function\"===typeof b.options.jsonSuccess)b.options.jsonSuccess.apply(this,[a]);else{for(d in a.owl)a.owl.hasOwnProperty(d)&&(e+=a.owl[d].item);b.$elem.html(e)}b.logIn()}var b=this,e;\"function\"===typeof b.options.beforeInit&&b.options.beforeInit.apply(this,[b.$elem]);\"string\"===typeof b.options.jsonPath?\n(e=b.options.jsonPath,f.getJSON(e,a)):b.logIn()},logIn:function(){this.$elem.data(\"owl-originalStyles\",this.$elem.attr(\"style\"));this.$elem.data(\"owl-originalClasses\",this.$elem.attr(\"class\"));this.$elem.css({opacity:0});this.orignalItems=this.options.items;this.checkBrowser();this.wrapperWidth=0;this.checkVisible=null;this.setVars()},setVars:function(){if(0===this.$elem.children().length)return!1;this.baseClass();this.eventTypes();this.$userItems=this.$elem.children();this.itemsAmount=this.$userItems.length;\nthis.wrapItems();this.$owlItems=this.$elem.find(\".owl-item\");this.$owlWrapper=this.$elem.find(\".owl-wrapper\");this.playDirection=\"next\";this.prevItem=0;this.prevArr=[0];this.currentItem=0;this.customEvents();this.onStartup()},onStartup:function(){this.updateItems();this.calculateAll();this.buildControls();this.updateControls();this.response();this.moveEvents();this.stopOnHover();this.owlStatus();!1!==this.options.transitionStyle&&this.transitionTypes(this.options.transitionStyle);!0===this.options.autoPlay&&\n(this.options.autoPlay=5E3);this.play();this.$elem.find(\".owl-wrapper\").css(\"display\",\"block\");this.$elem.is(\":visible\")?this.$elem.css(\"opacity\",1):this.watchVisibility();this.onstartup=!1;this.eachMoveUpdate();\"function\"===typeof this.options.afterInit&&this.options.afterInit.apply(this,[this.$elem])},eachMoveUpdate:function(){!0===this.options.lazyLoad&&this.lazyLoad();!0===this.options.autoHeight&&this.autoHeight();this.onVisibleItems();\"function\"===typeof this.options.afterAction&&this.options.afterAction.apply(this,\n[this.$elem])},updateVars:function(){\"function\"===typeof this.options.beforeUpdate&&this.options.beforeUpdate.apply(this,[this.$elem]);this.watchVisibility();this.updateItems();this.calculateAll();this.updatePosition();this.updateControls();this.eachMoveUpdate();\"function\"===typeof this.options.afterUpdate&&this.options.afterUpdate.apply(this,[this.$elem])},reload:function(){var a=this;g.setTimeout(function(){a.updateVars()},0)},watchVisibility:function(){var a=this;if(!1===a.$elem.is(\":visible\"))a.$elem.css({opacity:0}),\ng.clearInterval(a.autoPlayInterval),g.clearInterval(a.checkVisible);else return!1;a.checkVisible=g.setInterval(function(){a.$elem.is(\":visible\")&&(a.reload(),a.$elem.animate({opacity:1},200),g.clearInterval(a.checkVisible))},500)},wrapItems:function(){this.$userItems.wrapAll('<div class=\"owl-wrapper\">').wrap('<div class=\"owl-item\"></div>');this.$elem.find(\".owl-wrapper\").wrap('<div class=\"owl-wrapper-outer\">');this.wrapperOuter=this.$elem.find(\".owl-wrapper-outer\");this.$elem.css(\"display\",\"block\")},\nbaseClass:function(){var a=this.$elem.hasClass(this.options.baseClass),b=this.$elem.hasClass(this.options.theme);a||this.$elem.addClass(this.options.baseClass);b||this.$elem.addClass(this.options.theme)},updateItems:function(){var a,b;if(!1===this.options.responsive)return!1;if(!0===this.options.singleItem)return this.options.items=this.orignalItems=1,this.options.itemsCustom=!1,this.options.itemsDesktop=!1,this.options.itemsDesktopSmall=!1,this.options.itemsTablet=!1,this.options.itemsTabletSmall=\n!1,this.options.itemsMobile=!1;a=f(this.options.responsiveBaseWidth).width();a>(this.options.itemsDesktop[0]||this.orignalItems)&&(this.options.items=this.orignalItems);if(!1!==this.options.itemsCustom)for(this.options.itemsCustom.sort(function(a,b){return a[0]-b[0]}),b=0;b<this.options.itemsCustom.length;b+=1)this.options.itemsCustom[b][0]<=a&&(this.options.items=this.options.itemsCustom[b][1]);else a<=this.options.itemsDesktop[0]&&!1!==this.options.itemsDesktop&&(this.options.items=this.options.itemsDesktop[1]),\na<=this.options.itemsDesktopSmall[0]&&!1!==this.options.itemsDesktopSmall&&(this.options.items=this.options.itemsDesktopSmall[1]),a<=this.options.itemsTablet[0]&&!1!==this.options.itemsTablet&&(this.options.items=this.options.itemsTablet[1]),a<=this.options.itemsTabletSmall[0]&&!1!==this.options.itemsTabletSmall&&(this.options.items=this.options.itemsTabletSmall[1]),a<=this.options.itemsMobile[0]&&!1!==this.options.itemsMobile&&(this.options.items=this.options.itemsMobile[1]);this.options.items>this.itemsAmount&&\n!0===this.options.itemsScaleUp&&(this.options.items=this.itemsAmount)},response:function(){var a=this,b,e;if(!0!==a.options.responsive)return!1;e=f(g).width();a.resizer=function(){f(g).width()!==e&&(!1!==a.options.autoPlay&&g.clearInterval(a.autoPlayInterval),g.clearTimeout(b),b=g.setTimeout(function(){e=f(g).width();a.updateVars()},a.options.responsiveRefreshRate))};f(g).resize(a.resizer)},updatePosition:function(){this.jumpTo(this.currentItem);!1!==this.options.autoPlay&&this.checkAp()},appendItemsSizes:function(){var a=\nthis,b=0,e=a.itemsAmount-a.options.items;a.$owlItems.each(function(c){var d=f(this);d.css({width:a.itemWidth}).data(\"owl-item\",Number(c));if(0===c%a.options.items||c===e)c>e||(b+=1);d.data(\"owl-roundPages\",b)})},appendWrapperSizes:function(){this.$owlWrapper.css({width:this.$owlItems.length*this.itemWidth*2,left:0});this.appendItemsSizes()},calculateAll:function(){this.calculateWidth();this.appendWrapperSizes();this.loops();this.max()},calculateWidth:function(){this.itemWidth=Math.round(this.$elem.width()/\nthis.options.items)},max:function(){var a=-1*(this.itemsAmount*this.itemWidth-this.options.items*this.itemWidth);this.options.items>this.itemsAmount?this.maximumPixels=a=this.maximumItem=0:(this.maximumItem=this.itemsAmount-this.options.items,this.maximumPixels=a);return a},min:function(){return 0},loops:function(){var a=0,b=0,e,c;this.positionsInArray=[0];this.pagesInArray=[];for(e=0;e<this.itemsAmount;e+=1)b+=this.itemWidth,this.positionsInArray.push(-b),!0===this.options.scrollPerPage&&(c=f(this.$owlItems[e]),\nc=c.data(\"owl-roundPages\"),c!==a&&(this.pagesInArray[a]=this.positionsInArray[e],a=c))},buildControls:function(){if(!0===this.options.navigation||!0===this.options.pagination)this.owlControls=f('<div class=\"owl-controls\"/>').toggleClass(\"clickable\",!this.browser.isTouch).appendTo(this.$elem);!0===this.options.pagination&&this.buildPagination();!0===this.options.navigation&&this.buildButtons()},buildButtons:function(){var a=this,b=f('<div class=\"owl-buttons\"/>');a.owlControls.append(b);a.buttonPrev=\nf(\"<div/>\",{\"class\":\"owl-prev\",html:a.options.navigationText[0]||\"\"});a.buttonNext=f(\"<div/>\",{\"class\":\"owl-next\",html:a.options.navigationText[1]||\"\"});b.append(a.buttonPrev).append(a.buttonNext);b.on(\"touchstart.owlControls mousedown.owlControls\",'div[class^=\"owl\"]',function(a){a.preventDefault()});b.on(\"touchend.owlControls mouseup.owlControls\",'div[class^=\"owl\"]',function(b){b.preventDefault();f(this).hasClass(\"owl-next\")?a.next():a.prev()})},buildPagination:function(){var a=this;a.paginationWrapper=\nf('<div class=\"owl-pagination\"/>');a.owlControls.append(a.paginationWrapper);a.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\",\".owl-page\",function(b){b.preventDefault();Number(f(this).data(\"owl-page\"))!==a.currentItem&&a.goTo(Number(f(this).data(\"owl-page\")),!0)})},updatePagination:function(){var a,b,e,c,d,g;if(!1===this.options.pagination)return!1;this.paginationWrapper.html(\"\");a=0;b=this.itemsAmount-this.itemsAmount%this.options.items;for(c=0;c<this.itemsAmount;c+=1)0===c%this.options.items&&\n(a+=1,b===c&&(e=this.itemsAmount-this.options.items),d=f(\"<div/>\",{\"class\":\"owl-page\"}),g=f(\"<span></span>\",{text:!0===this.options.paginationNumbers?a:\"\",\"class\":!0===this.options.paginationNumbers?\"owl-numbers\":\"\"}),d.append(g),d.data(\"owl-page\",b===c?e:c),d.data(\"owl-roundPages\",a),this.paginationWrapper.append(d));this.checkPagination()},checkPagination:function(){var a=this;if(!1===a.options.pagination)return!1;a.paginationWrapper.find(\".owl-page\").each(function(){f(this).data(\"owl-roundPages\")===\nf(a.$owlItems[a.currentItem]).data(\"owl-roundPages\")&&(a.paginationWrapper.find(\".owl-page\").removeClass(\"active\"),f(this).addClass(\"active\"))})},checkNavigation:function(){if(!1===this.options.navigation)return!1;!1===this.options.rewindNav&&(0===this.currentItem&&0===this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0===this.currentItem&&0!==this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")):this.currentItem===\nthis.maximumItem?(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0!==this.currentItem&&this.currentItem!==this.maximumItem&&(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")))},updateControls:function(){this.updatePagination();this.checkNavigation();this.owlControls&&(this.options.items>=this.itemsAmount?this.owlControls.hide():this.owlControls.show())},destroyControls:function(){this.owlControls&&this.owlControls.remove()},next:function(a){if(this.isTransition)return!1;\nthis.currentItem+=!0===this.options.scrollPerPage?this.options.items:1;if(this.currentItem>this.maximumItem+(!0===this.options.scrollPerPage?this.options.items-1:0))if(!0===this.options.rewindNav)this.currentItem=0,a=\"rewind\";else return this.currentItem=this.maximumItem,!1;this.goTo(this.currentItem,a)},prev:function(a){if(this.isTransition)return!1;this.currentItem=!0===this.options.scrollPerPage&&0<this.currentItem&&this.currentItem<this.options.items?0:this.currentItem-(!0===this.options.scrollPerPage?\nthis.options.items:1);if(0>this.currentItem)if(!0===this.options.rewindNav)this.currentItem=this.maximumItem,a=\"rewind\";else return this.currentItem=0,!1;this.goTo(this.currentItem,a)},goTo:function(a,b,e){var c=this;if(c.isTransition)return!1;\"function\"===typeof c.options.beforeMove&&c.options.beforeMove.apply(this,[c.$elem]);a>=c.maximumItem?a=c.maximumItem:0>=a&&(a=0);c.currentItem=c.owl.currentItem=a;if(!1!==c.options.transitionStyle&&\"drag\"!==e&&1===c.options.items&&!0===c.browser.support3d)return c.swapSpeed(0),\n!0===c.browser.support3d?c.transition3d(c.positionsInArray[a]):c.css2slide(c.positionsInArray[a],1),c.afterGo(),c.singleItemTransition(),!1;a=c.positionsInArray[a];!0===c.browser.support3d?(c.isCss3Finish=!1,!0===b?(c.swapSpeed(\"paginationSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},c.options.paginationSpeed)):\"rewind\"===b?(c.swapSpeed(c.options.rewindSpeed),g.setTimeout(function(){c.isCss3Finish=!0},c.options.rewindSpeed)):(c.swapSpeed(\"slideSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},\nc.options.slideSpeed)),c.transition3d(a)):!0===b?c.css2slide(a,c.options.paginationSpeed):\"rewind\"===b?c.css2slide(a,c.options.rewindSpeed):c.css2slide(a,c.options.slideSpeed);c.afterGo()},jumpTo:function(a){\"function\"===typeof this.options.beforeMove&&this.options.beforeMove.apply(this,[this.$elem]);a>=this.maximumItem||-1===a?a=this.maximumItem:0>=a&&(a=0);this.swapSpeed(0);!0===this.browser.support3d?this.transition3d(this.positionsInArray[a]):this.css2slide(this.positionsInArray[a],1);this.currentItem=\nthis.owl.currentItem=a;this.afterGo()},afterGo:function(){this.prevArr.push(this.currentItem);this.prevItem=this.owl.prevItem=this.prevArr[this.prevArr.length-2];this.prevArr.shift(0);this.prevItem!==this.currentItem&&(this.checkPagination(),this.checkNavigation(),this.eachMoveUpdate(),!1!==this.options.autoPlay&&this.checkAp());\"function\"===typeof this.options.afterMove&&this.prevItem!==this.currentItem&&this.options.afterMove.apply(this,[this.$elem])},stop:function(){this.apStatus=\"stop\";g.clearInterval(this.autoPlayInterval)},\ncheckAp:function(){\"stop\"!==this.apStatus&&this.play()},play:function(){var a=this;a.apStatus=\"play\";if(!1===a.options.autoPlay)return!1;g.clearInterval(a.autoPlayInterval);a.autoPlayInterval=g.setInterval(function(){a.next(!0)},a.options.autoPlay)},swapSpeed:function(a){\"slideSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.slideSpeed)):\"paginationSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.paginationSpeed)):\"string\"!==typeof a&&this.$owlWrapper.css(this.addCssSpeed(a))},\naddCssSpeed:function(a){return{\"-webkit-transition\":\"all \"+a+\"ms ease\",\"-moz-transition\":\"all \"+a+\"ms ease\",\"-o-transition\":\"all \"+a+\"ms ease\",transition:\"all \"+a+\"ms ease\"}},removeTransition:function(){return{\"-webkit-transition\":\"\",\"-moz-transition\":\"\",\"-o-transition\":\"\",transition:\"\"}},doTranslate:function(a){return{\"-webkit-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-moz-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-o-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-ms-transform\":\"translate3d(\"+\na+\"px, 0px, 0px)\",transform:\"translate3d(\"+a+\"px, 0px,0px)\"}},transition3d:function(a){this.$owlWrapper.css(this.doTranslate(a))},css2move:function(a){this.$owlWrapper.css({left:a})},css2slide:function(a,b){var e=this;e.isCssFinish=!1;e.$owlWrapper.stop(!0,!0).animate({left:a},{duration:b||e.options.slideSpeed,complete:function(){e.isCssFinish=!0}})},checkBrowser:function(){var a=k.createElement(\"div\");a.style.cssText=\"  -moz-transform:translate3d(0px, 0px, 0px); -ms-transform:translate3d(0px, 0px, 0px); -o-transform:translate3d(0px, 0px, 0px); -webkit-transform:translate3d(0px, 0px, 0px); transform:translate3d(0px, 0px, 0px)\";\na=a.style.cssText.match(/translate3d\\(0px, 0px, 0px\\)/g);this.browser={support3d:null!==a&&1===a.length,isTouch:\"ontouchstart\"in g||g.navigator.msMaxTouchPoints}},moveEvents:function(){if(!1!==this.options.mouseDrag||!1!==this.options.touchDrag)this.gestures(),this.disabledEvents()},eventTypes:function(){var a=[\"s\",\"e\",\"x\"];this.ev_types={};!0===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl mousedown.owl\",\"touchmove.owl mousemove.owl\",\"touchend.owl touchcancel.owl mouseup.owl\"]:\n!1===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl\",\"touchmove.owl\",\"touchend.owl touchcancel.owl\"]:!0===this.options.mouseDrag&&!1===this.options.touchDrag&&(a=[\"mousedown.owl\",\"mousemove.owl\",\"mouseup.owl\"]);this.ev_types.start=a[0];this.ev_types.move=a[1];this.ev_types.end=a[2]},disabledEvents:function(){this.$elem.on(\"dragstart.owl\",function(a){a.preventDefault()});this.$elem.on(\"mousedown.disableTextSelect\",function(a){return f(a.target).is(\"input, textarea, select, option\")})},\ngestures:function(){function a(a){if(void 0!==a.touches)return{x:a.touches[0].pageX,y:a.touches[0].pageY};if(void 0===a.touches){if(void 0!==a.pageX)return{x:a.pageX,y:a.pageY};if(void 0===a.pageX)return{x:a.clientX,y:a.clientY}}}function b(a){\"on\"===a?(f(k).on(d.ev_types.move,e),f(k).on(d.ev_types.end,c)):\"off\"===a&&(f(k).off(d.ev_types.move),f(k).off(d.ev_types.end))}function e(b){b=b.originalEvent||b||g.event;d.newPosX=a(b).x-h.offsetX;d.newPosY=a(b).y-h.offsetY;d.newRelativeX=d.newPosX-h.relativePos;\n\"function\"===typeof d.options.startDragging&&!0!==h.dragging&&0!==d.newRelativeX&&(h.dragging=!0,d.options.startDragging.apply(d,[d.$elem]));(8<d.newRelativeX||-8>d.newRelativeX)&&!0===d.browser.isTouch&&(void 0!==b.preventDefault?b.preventDefault():b.returnValue=!1,h.sliding=!0);(10<d.newPosY||-10>d.newPosY)&&!1===h.sliding&&f(k).off(\"touchmove.owl\");d.newPosX=Math.max(Math.min(d.newPosX,d.newRelativeX/5),d.maximumPixels+d.newRelativeX/5);!0===d.browser.support3d?d.transition3d(d.newPosX):d.css2move(d.newPosX)}\nfunction c(a){a=a.originalEvent||a||g.event;var c;a.target=a.target||a.srcElement;h.dragging=!1;!0!==d.browser.isTouch&&d.$owlWrapper.removeClass(\"grabbing\");d.dragDirection=0>d.newRelativeX?d.owl.dragDirection=\"left\":d.owl.dragDirection=\"right\";0!==d.newRelativeX&&(c=d.getNewPosition(),d.goTo(c,!1,\"drag\"),h.targetElement===a.target&&!0!==d.browser.isTouch&&(f(a.target).on(\"click.disable\",function(a){a.stopImmediatePropagation();a.stopPropagation();a.preventDefault();f(a.target).off(\"click.disable\")}),\na=f._data(a.target,\"events\").click,c=a.pop(),a.splice(0,0,c)));b(\"off\")}var d=this,h={offsetX:0,offsetY:0,baseElWidth:0,relativePos:0,position:null,minSwipe:null,maxSwipe:null,sliding:null,dargging:null,targetElement:null};d.isCssFinish=!0;d.$elem.on(d.ev_types.start,\".owl-wrapper\",function(c){c=c.originalEvent||c||g.event;var e;if(3===c.which)return!1;if(!(d.itemsAmount<=d.options.items)){if(!1===d.isCssFinish&&!d.options.dragBeforeAnimFinish||!1===d.isCss3Finish&&!d.options.dragBeforeAnimFinish)return!1;\n!1!==d.options.autoPlay&&g.clearInterval(d.autoPlayInterval);!0===d.browser.isTouch||d.$owlWrapper.hasClass(\"grabbing\")||d.$owlWrapper.addClass(\"grabbing\");d.newPosX=0;d.newRelativeX=0;f(this).css(d.removeTransition());e=f(this).position();h.relativePos=e.left;h.offsetX=a(c).x-e.left;h.offsetY=a(c).y-e.top;b(\"on\");h.sliding=!1;h.targetElement=c.target||c.srcElement}})},getNewPosition:function(){var a=this.closestItem();a>this.maximumItem?a=this.currentItem=this.maximumItem:0<=this.newPosX&&(this.currentItem=\na=0);return a},closestItem:function(){var a=this,b=!0===a.options.scrollPerPage?a.pagesInArray:a.positionsInArray,e=a.newPosX,c=null;f.each(b,function(d,g){e-a.itemWidth/20>b[d+1]&&e-a.itemWidth/20<g&&\"left\"===a.moveDirection()?(c=g,a.currentItem=!0===a.options.scrollPerPage?f.inArray(c,a.positionsInArray):d):e+a.itemWidth/20<g&&e+a.itemWidth/20>(b[d+1]||b[d]-a.itemWidth)&&\"right\"===a.moveDirection()&&(!0===a.options.scrollPerPage?(c=b[d+1]||b[b.length-1],a.currentItem=f.inArray(c,a.positionsInArray)):\n(c=b[d+1],a.currentItem=d+1))});return a.currentItem},moveDirection:function(){var a;0>this.newRelativeX?(a=\"right\",this.playDirection=\"next\"):(a=\"left\",this.playDirection=\"prev\");return a},customEvents:function(){var a=this;a.$elem.on(\"owl.next\",function(){a.next()});a.$elem.on(\"owl.prev\",function(){a.prev()});a.$elem.on(\"owl.play\",function(b,e){a.options.autoPlay=e;a.play();a.hoverStatus=\"play\"});a.$elem.on(\"owl.stop\",function(){a.stop();a.hoverStatus=\"stop\"});a.$elem.on(\"owl.goTo\",function(b,e){a.goTo(e)});\na.$elem.on(\"owl.jumpTo\",function(b,e){a.jumpTo(e)})},stopOnHover:function(){var a=this;!0===a.options.stopOnHover&&!0!==a.browser.isTouch&&!1!==a.options.autoPlay&&(a.$elem.on(\"mouseover\",function(){a.stop()}),a.$elem.on(\"mouseout\",function(){\"stop\"!==a.hoverStatus&&a.play()}))},lazyLoad:function(){var a,b,e,c,d;if(!1===this.options.lazyLoad)return!1;for(a=0;a<this.itemsAmount;a+=1)b=f(this.$owlItems[a]),\"loaded\"!==b.data(\"owl-loaded\")&&(e=b.data(\"owl-item\"),c=b.find(\".lazyOwl\"),\"string\"!==typeof c.data(\"src\")?\nb.data(\"owl-loaded\",\"loaded\"):(void 0===b.data(\"owl-loaded\")&&(c.hide(),b.addClass(\"loading\").data(\"owl-loaded\",\"checked\")),(d=!0===this.options.lazyFollow?e>=this.currentItem:!0)&&e<this.currentItem+this.options.items&&c.length&&this.lazyPreload(b,c)))},lazyPreload:function(a,b){function e(){a.data(\"owl-loaded\",\"loaded\").removeClass(\"loading\");b.removeAttr(\"data-src\");\"fade\"===d.options.lazyEffect?b.fadeIn(400):b.show();\"function\"===typeof d.options.afterLazyLoad&&d.options.afterLazyLoad.apply(this,\n[d.$elem])}function c(){f+=1;d.completeImg(b.get(0))||!0===k?e():100>=f?g.setTimeout(c,100):e()}var d=this,f=0,k;\"DIV\"===b.prop(\"tagName\")?(b.css(\"background-image\",\"url(\"+b.data(\"src\")+\")\"),k=!0):b[0].src=b.data(\"src\");c()},autoHeight:function(){function a(){var a=f(e.$owlItems[e.currentItem]).height();e.wrapperOuter.css(\"height\",a+\"px\");e.wrapperOuter.hasClass(\"autoHeight\")||g.setTimeout(function(){e.wrapperOuter.addClass(\"autoHeight\")},0)}function b(){d+=1;e.completeImg(c.get(0))?a():100>=d?g.setTimeout(b,\n100):e.wrapperOuter.css(\"height\",\"\")}var e=this,c=f(e.$owlItems[e.currentItem]).find(\"img\"),d;void 0!==c.get(0)?(d=0,b()):a()},completeImg:function(a){return!a.complete||\"undefined\"!==typeof a.naturalWidth&&0===a.naturalWidth?!1:!0},onVisibleItems:function(){var a;!0===this.options.addClassActive&&this.$owlItems.removeClass(\"active\");this.visibleItems=[];for(a=this.currentItem;a<this.currentItem+this.options.items;a+=1)this.visibleItems.push(a),!0===this.options.addClassActive&&f(this.$owlItems[a]).addClass(\"active\");\nthis.owl.visibleItems=this.visibleItems},transitionTypes:function(a){this.outClass=\"owl-\"+a+\"-out\";this.inClass=\"owl-\"+a+\"-in\"},singleItemTransition:function(){var a=this,b=a.outClass,e=a.inClass,c=a.$owlItems.eq(a.currentItem),d=a.$owlItems.eq(a.prevItem),f=Math.abs(a.positionsInArray[a.currentItem])+a.positionsInArray[a.prevItem],g=Math.abs(a.positionsInArray[a.currentItem])+a.itemWidth/2;a.isTransition=!0;a.$owlWrapper.addClass(\"owl-origin\").css({\"-webkit-transform-origin\":g+\"px\",\"-moz-perspective-origin\":g+\n\"px\",\"perspective-origin\":g+\"px\"});d.css({position:\"relative\",left:f+\"px\"}).addClass(b).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endPrev=!0;d.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(d,b)});c.addClass(e).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endCurrent=!0;c.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(c,e)})},clearTransStyle:function(a,\nb){a.css({position:\"\",left:\"\"}).removeClass(b);this.endPrev&&this.endCurrent&&(this.$owlWrapper.removeClass(\"owl-origin\"),this.isTransition=this.endCurrent=this.endPrev=!1)},owlStatus:function(){this.owl={userOptions:this.userOptions,baseElement:this.$elem,userItems:this.$userItems,owlItems:this.$owlItems,currentItem:this.currentItem,prevItem:this.prevItem,visibleItems:this.visibleItems,isTouch:this.browser.isTouch,browser:this.browser,dragDirection:this.dragDirection}},clearEvents:function(){this.$elem.off(\".owl owl mousedown.disableTextSelect\");\nf(k).off(\".owl owl\");f(g).off(\"resize\",this.resizer)},unWrap:function(){0!==this.$elem.children().length&&(this.$owlWrapper.unwrap(),this.$userItems.unwrap().unwrap(),this.owlControls&&this.owlControls.remove());this.clearEvents();this.$elem.attr(\"style\",this.$elem.data(\"owl-originalStyles\")||\"\").attr(\"class\",this.$elem.data(\"owl-originalClasses\"))},destroy:function(){this.stop();g.clearInterval(this.checkVisible);this.unWrap();this.$elem.removeData()},reinit:function(a){a=f.extend({},this.userOptions,\na);this.unWrap();this.init(a,this.$elem)},addItem:function(a,b){var e;if(!a)return!1;if(0===this.$elem.children().length)return this.$elem.append(a),this.setVars(),!1;this.unWrap();e=void 0===b||-1===b?-1:b;e>=this.$userItems.length||-1===e?this.$userItems.eq(-1).after(a):this.$userItems.eq(e).before(a);this.setVars()},removeItem:function(a){if(0===this.$elem.children().length)return!1;a=void 0===a||-1===a?-1:a;this.unWrap();this.$userItems.eq(a).remove();this.setVars()}};f.fn.owlCarousel=function(a){return this.each(function(){if(!0===\nf(this).data(\"owl-init\"))return!1;f(this).data(\"owl-init\",!0);var b=Object.create(l);b.init(a,this);f.data(this,\"owlCarousel\",b)})};f.fn.owlCarousel.options={items:5,itemsCustom:!1,itemsDesktop:[1199,4],itemsDesktopSmall:[979,3],itemsTablet:[768,2],itemsTabletSmall:!1,itemsMobile:[479,1],singleItem:!1,itemsScaleUp:!1,slideSpeed:200,paginationSpeed:800,rewindSpeed:1E3,autoPlay:!1,stopOnHover:!1,navigation:!1,navigationText:[\"prev\",\"next\"],rewindNav:!0,scrollPerPage:!1,pagination:!0,paginationNumbers:!1,\nresponsive:!0,responsiveRefreshRate:200,responsiveBaseWidth:g,baseClass:\"owl-carousel\",theme:\"owl-theme\",lazyLoad:!1,lazyFollow:!0,lazyEffect:\"fade\",autoHeight:!1,jsonPath:!1,jsonSuccess:!1,dragBeforeAnimFinish:!0,mouseDrag:!0,touchDrag:!0,addClassActive:!1,transitionStyle:!1,beforeUpdate:!1,afterUpdate:!1,beforeInit:!1,afterInit:!1,beforeMove:!1,afterMove:!1,afterAction:!1,startDragging:!1,afterLazyLoad:!1}})(jQuery,window,document);\n});","Plazathemes_Newsletterpopup/js/jquery.bpopup.min.js":"/*================================================================================\r\n * @name: bPopup - if you can't get it up, use bPopup\r\n * @author: (c)Bjoern Klinggaard (twitter@bklinggaard)\r\n * @demo: http://dinbror.dk/bpopup\r\n * @version: 0.9.4.min\r\n ================================================================================*/\r\n require([\"jquery\"], function($){\r\n (function(b){b.fn.bPopup=function(z,F){function K(){a.contentContainer=b(a.contentContainer||c);switch(a.content){case \"iframe\":var h=b('<iframe class=\"b-iframe\" '+a.iframeAttr+\"></iframe>\");h.appendTo(a.contentContainer);r=c.outerHeight(!0);s=c.outerWidth(!0);A();h.attr(\"src\",a.loadUrl);k(a.loadCallback);break;case \"image\":A();b(\"<img />\").load(function(){k(a.loadCallback);G(b(this))}).attr(\"src\",a.loadUrl).hide().appendTo(a.contentContainer);break;default:A(),b('<div class=\"b-ajax-wrapper\"></div>').load(a.loadUrl,a.loadData,function(){k(a.loadCallback);G(b(this))}).hide().appendTo(a.contentContainer)}}function A(){a.modal&&b('<div class=\"b-modal '+e+'\"></div>').css({backgroundColor:a.modalColor,position:\"fixed\",top:0,right:0,bottom:0,left:0,opacity:0,zIndex:a.zIndex+t}).appendTo(a.appendTo).fadeTo(a.speed,a.opacity);D();c.data(\"bPopup\",a).data(\"id\",e).css({left:\"slideIn\"==a.transition||\"slideBack\"==a.transition?\"slideBack\"==a.transition?g.scrollLeft()+u:-1*(v+s):l(!(!a.follow[0]&&m||f)),position:a.positionStyle||\"absolute\",top:\"slideDown\"==a.transition||\"slideUp\"==a.transition?\"slideUp\"==a.transition?g.scrollTop()+w:x+-1*r:n(!(!a.follow[1]&&p||f)),\"z-index\":a.zIndex+t+1}).each(function(){a.appending&&b(this).appendTo(a.appendTo)});H(!0)}function q(){a.modal&&b(\".b-modal.\"+c.data(\"id\")).fadeTo(a.speed,0,function(){b(this).remove()});a.scrollBar||b(\"html\").css(\"overflow\",\"auto\");b(\".b-modal.\"+e).unbind(\"click\");g.unbind(\"keydown.\"+e);d.unbind(\".\"+e).data(\"bPopup\",0<d.data(\"bPopup\")-1?d.data(\"bPopup\")-1:null);c.undelegate(\".bClose, .\"+a.closeClass,\"click.\"+e,q).data(\"bPopup\",null);H();return!1}function G(h){var b=h.width(),e=h.height(),d={};a.contentContainer.css({height:e,width:b});e>=c.height()&&(d.height=c.height());b>=c.width()&&(d.width=c.width());r=c.outerHeight(!0);s=c.outerWidth(!0);D();a.contentContainer.css({height:\"auto\",width:\"auto\"});d.left=l(!(!a.follow[0]&&m||f));d.top=n(!(!a.follow[1]&&p||f));c.animate(d,250,function(){h.show();B=E()})}function L(){d.data(\"bPopup\",t);c.delegate(\".bClose, .\"+a.closeClass,\"click.\"+e,q);a.modalClose&&b(\".b-modal.\"+e).css(\"cursor\",\"pointer\").bind(\"click\",q);M||!a.follow[0]&&!a.follow[1]||d.bind(\"scroll.\"+e,function(){B&&c.dequeue().animate({left:a.follow[0]?l(!f):\"auto\",top:a.follow[1]?n(!f):\"auto\"},a.followSpeed,a.followEasing)}).bind(\"resize.\"+e,function(){w=y.innerHeight||d.height();u=y.innerWidth||d.width();if(B=E())clearTimeout(I),I=setTimeout(function(){D();c.dequeue().each(function(){f?b(this).css({left:v,top:x}):b(this).animate({left:a.follow[0]?l(!0):\"auto\",top:a.follow[1]?n(!0):\"auto\"},a.followSpeed,a.followEasing)})},50)});a.escClose&&g.bind(\"keydown.\"+e,function(a){27==a.which&&q()})}function H(b){function d(e){c.css({display:\"block\",opacity:1}).animate(e,a.speed,a.easing,function(){J(b)})}switch(b?a.transition:a.transitionClose||a.transition){case \"slideIn\":d({left:b?l(!(!a.follow[0]&&m||f)):g.scrollLeft()-(s||c.outerWidth(!0))-C});break;case \"slideBack\":d({left:b?l(!(!a.follow[0]&&m||f)):g.scrollLeft()+u+C});break;case \"slideDown\":d({top:b?n(!(!a.follow[1]&&p||f)):g.scrollTop()-(r||c.outerHeight(!0))-C});break;case \"slideUp\":d({top:b?n(!(!a.follow[1]&&p||f)):g.scrollTop()+w+C});break;default:c.stop().fadeTo(a.speed,b?1:0,function(){J(b)})}}function J(b){b?(L(),k(F),a.autoClose&&setTimeout(q,a.autoClose)):(c.hide(),k(a.onClose),a.loadUrl&&(a.contentContainer.empty(),c.css({height:\"auto\",width:\"auto\"})))}function l(a){return a?v+g.scrollLeft():v}function n(a){return a?x+g.scrollTop():x}function k(a){b.isFunction(a)&&a.call(c)}function D(){x=p?a.position[1]:Math.max(0,(w-c.outerHeight(!0))/2-a.amsl);v=m?a.position[0]:(u-c.outerWidth(!0))/2;B=E()}function E(){return w>c.outerHeight(!0)&&u>c.outerWidth(!0)}b.isFunction(z)&&(F=z,z=null);var a=b.extend({},b.fn.bPopup.defaults,z);a.scrollBar||b(\"html\").css(\"overflow\",\"hidden\");var c=this,g=b(document),y=window,d=b(y),w=y.innerHeight||d.height(),u=y.innerWidth||d.width(),M=/OS 6(_\\d)+/i.test(navigator.userAgent),C=200,t=0,e,B,p,m,f,x,v,r,s,I;c.close=function(){a=this.data(\"bPopup\");e=\"__b-popup\"+d.data(\"bPopup\")+\"__\";q()};return c.each(function(){b(this).data(\"bPopup\")||(k(a.onOpen),t=(d.data(\"bPopup\")||0)+1,e=\"__b-popup\"+t+\"__\",p=\"auto\"!==a.position[1],m=\"auto\"!==a.position[0],f=\"fixed\"===a.positionStyle,r=c.outerHeight(!0),s=c.outerWidth(!0),a.loadUrl?K():A())})};b.fn.bPopup.defaults={amsl:50,appending:!0,appendTo:\"body\",autoClose:!1,closeClass:\"b-close\",content:\"ajax\",contentContainer:!1,easing:\"swing\",escClose:!0,follow:[!0,!0],followEasing:\"swing\",followSpeed:500,iframeAttr:'scrolling=\"no\" frameborder=\"0\"',loadCallback:!1,loadData:!1,loadUrl:!1,modal:!0,modalClose:!0,modalColor:\"#000\",onClose:!1,onOpen:!1,opacity:0.7,position:[\"auto\",\"auto\"],positionStyle:\"absolute\",scrollBar:!0,speed:250,transition:\"fadeIn\",transitionClose:!1,zIndex:9997}})(jQuery);\r\n });","Plazathemes_Newsletterpopup/js/jquery.easing.1.3.js":"/*\n * jQuery Easing v1.3 - http://gsgd.co.uk/sandbox/jquery/easing/\n *\n * Uses the built in easing capabilities added In jQuery 1.1\n * to offer multiple easing options\n *\n * TERMS OF USE - jQuery Easing\n * \n * Open source under the BSD License. \n * \n * Copyright \u00c2\u00a9 2008 George McGinley Smith\n * All rights reserved.\n * \n * Redistribution and use in source and binary forms, with or without modification, \n * are permitted provided that the following conditions are met:\n * \n * Redistributions of source code must retain the above copyright notice, this list of \n * conditions and the following disclaimer.\n * Redistributions in binary form must reproduce the above copyright notice, this list \n * of conditions and the following disclaimer in the documentation and/or other materials \n * provided with the distribution.\n * \n * Neither the name of the author nor the names of contributors may be used to endorse \n * or promote products derived from this software without specific prior written permission.\n * \n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY \n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE\n *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE\n *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED \n * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED \n * OF THE POSSIBILITY OF SUCH DAMAGE. \n *\n*/\n\n// t: current time, b: begInnIng value, c: change In value, d: duration\n$jq.easing['jswing'] = $jq.easing['swing'];\n\n$jq.extend( $jq.easing,\n{\n\tdef: 'easeOutQuad',\n\tswing: function (x, t, b, c, d) {\n\t\t//alert(jQuery.easing.default);\n\t\treturn $jq.easing[$jq.easing.def](x, t, b, c, d);\n\t},\n\teaseInQuad: function (x, t, b, c, d) {\n\t\treturn c*(t/=d)*t + b;\n\t},\n\teaseOutQuad: function (x, t, b, c, d) {\n\t\treturn -c *(t/=d)*(t-2) + b;\n\t},\n\teaseInOutQuad: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return c/2*t*t + b;\n\t\treturn -c/2 * ((--t)*(t-2) - 1) + b;\n\t},\n\teaseInCubic: function (x, t, b, c, d) {\n\t\treturn c*(t/=d)*t*t + b;\n\t},\n\teaseOutCubic: function (x, t, b, c, d) {\n\t\treturn c*((t=t/d-1)*t*t + 1) + b;\n\t},\n\teaseInOutCubic: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return c/2*t*t*t + b;\n\t\treturn c/2*((t-=2)*t*t + 2) + b;\n\t},\n\teaseInQuart: function (x, t, b, c, d) {\n\t\treturn c*(t/=d)*t*t*t + b;\n\t},\n\teaseOutQuart: function (x, t, b, c, d) {\n\t\treturn -c * ((t=t/d-1)*t*t*t - 1) + b;\n\t},\n\teaseInOutQuart: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return c/2*t*t*t*t + b;\n\t\treturn -c/2 * ((t-=2)*t*t*t - 2) + b;\n\t},\n\teaseInQuint: function (x, t, b, c, d) {\n\t\treturn c*(t/=d)*t*t*t*t + b;\n\t},\n\teaseOutQuint: function (x, t, b, c, d) {\n\t\treturn c*((t=t/d-1)*t*t*t*t + 1) + b;\n\t},\n\teaseInOutQuint: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return c/2*t*t*t*t*t + b;\n\t\treturn c/2*((t-=2)*t*t*t*t + 2) + b;\n\t},\n\teaseInSine: function (x, t, b, c, d) {\n\t\treturn -c * Math.cos(t/d * (Math.PI/2)) + c + b;\n\t},\n\teaseOutSine: function (x, t, b, c, d) {\n\t\treturn c * Math.sin(t/d * (Math.PI/2)) + b;\n\t},\n\teaseInOutSine: function (x, t, b, c, d) {\n\t\treturn -c/2 * (Math.cos(Math.PI*t/d) - 1) + b;\n\t},\n\teaseInExpo: function (x, t, b, c, d) {\n\t\treturn (t==0) ? b : c * Math.pow(2, 10 * (t/d - 1)) + b;\n\t},\n\teaseOutExpo: function (x, t, b, c, d) {\n\t\treturn (t==d) ? b+c : c * (-Math.pow(2, -10 * t/d) + 1) + b;\n\t},\n\teaseInOutExpo: function (x, t, b, c, d) {\n\t\tif (t==0) return b;\n\t\tif (t==d) return b+c;\n\t\tif ((t/=d/2) < 1) return c/2 * Math.pow(2, 10 * (t - 1)) + b;\n\t\treturn c/2 * (-Math.pow(2, -10 * --t) + 2) + b;\n\t},\n\teaseInCirc: function (x, t, b, c, d) {\n\t\treturn -c * (Math.sqrt(1 - (t/=d)*t) - 1) + b;\n\t},\n\teaseOutCirc: function (x, t, b, c, d) {\n\t\treturn c * Math.sqrt(1 - (t=t/d-1)*t) + b;\n\t},\n\teaseInOutCirc: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return -c/2 * (Math.sqrt(1 - t*t) - 1) + b;\n\t\treturn c/2 * (Math.sqrt(1 - (t-=2)*t) + 1) + b;\n\t},\n\teaseInElastic: function (x, t, b, c, d) {\n\t\tvar s=1.70158;var p=0;var a=c;\n\t\tif (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;\n\t\tif (a < Math.abs(c)) { a=c; var s=p/4; }\n\t\telse var s = p/(2*Math.PI) * Math.asin (c/a);\n\t\treturn -(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;\n\t},\n\teaseOutElastic: function (x, t, b, c, d) {\n\t\tvar s=1.70158;var p=0;var a=c;\n\t\tif (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;\n\t\tif (a < Math.abs(c)) { a=c; var s=p/4; }\n\t\telse var s = p/(2*Math.PI) * Math.asin (c/a);\n\t\treturn a*Math.pow(2,-10*t) * Math.sin( (t*d-s)*(2*Math.PI)/p ) + c + b;\n\t},\n\teaseInOutElastic: function (x, t, b, c, d) {\n\t\tvar s=1.70158;var p=0;var a=c;\n\t\tif (t==0) return b;  if ((t/=d/2)==2) return b+c;  if (!p) p=d*(.3*1.5);\n\t\tif (a < Math.abs(c)) { a=c; var s=p/4; }\n\t\telse var s = p/(2*Math.PI) * Math.asin (c/a);\n\t\tif (t < 1) return -.5*(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;\n\t\treturn a*Math.pow(2,-10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )*.5 + c + b;\n\t},\n\teaseInBack: function (x, t, b, c, d, s) {\n\t\tif (s == undefined) s = 1.70158;\n\t\treturn c*(t/=d)*t*((s+1)*t - s) + b;\n\t},\n\teaseOutBack: function (x, t, b, c, d, s) {\n\t\tif (s == undefined) s = 1.70158;\n\t\treturn c*((t=t/d-1)*t*((s+1)*t + s) + 1) + b;\n\t},\n\teaseInOutBack: function (x, t, b, c, d, s) {\n\t\tif (s == undefined) s = 1.70158; \n\t\tif ((t/=d/2) < 1) return c/2*(t*t*(((s*=(1.525))+1)*t - s)) + b;\n\t\treturn c/2*((t-=2)*t*(((s*=(1.525))+1)*t + s) + 2) + b;\n\t},\n\teaseInBounce: function (x, t, b, c, d) {\n\t\treturn c - $jq.easing.easeOutBounce (x, d-t, 0, c, d) + b;\n\t},\n\teaseOutBounce: function (x, t, b, c, d) {\n\t\tif ((t/=d) < (1/2.75)) {\n\t\t\treturn c*(7.5625*t*t) + b;\n\t\t} else if (t < (2/2.75)) {\n\t\t\treturn c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;\n\t\t} else if (t < (2.5/2.75)) {\n\t\t\treturn c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;\n\t\t} else {\n\t\t\treturn c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;\n\t\t}\n\t},\n\teaseInOutBounce: function (x, t, b, c, d) {\n\t\tif (t < d/2) return $jq.easing.easeInBounce (x, t*2, 0, c, d) * .5 + b;\n\t\treturn $jq.easing.easeOutBounce (x, t*2-d, 0, c, d) * .5 + c*.5 + b;\n\t}\n});\n\n/*\n *\n * TERMS OF USE - EASING EQUATIONS\n * \n * Open source under the BSD License. \n * \n * Copyright \u00c2\u00a9 2001 Robert Penner\n * All rights reserved.\n * \n * Redistribution and use in source and binary forms, with or without modification, \n * are permitted provided that the following conditions are met:\n * \n * Redistributions of source code must retain the above copyright notice, this list of \n * conditions and the following disclaimer.\n * Redistributions in binary form must reproduce the above copyright notice, this list \n * of conditions and the following disclaimer in the documentation and/or other materials \n * provided with the distribution.\n * \n * Neither the name of the author nor the names of contributors may be used to endorse \n * or promote products derived from this software without specific prior written permission.\n * \n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY \n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE\n *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE\n *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED \n * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED \n * OF THE POSSIBILITY OF SUCH DAMAGE. \n *\n */","Plazathemes_Newsletterpopup/js/js.cookie.js":"/*!\n * JavaScript Cookie v2.0.4\n * https://github.com/js-cookie/js-cookie\n *\n * Copyright 2006, 2015 Klaus Hartl & Fagner Brack\n * Released under the MIT license\n */\n(function (factory) {\n\tif (typeof define === 'function' && define.amd) {\n\t\tdefine(factory);\n\t} else if (typeof exports === 'object') {\n\t\tmodule.exports = factory();\n\t} else {\n\t\tvar _OldCookies = window.Cookies;\n\t\tvar api = window.Cookies = factory();\n\t\tapi.noConflict = function () {\n\t\t\twindow.Cookies = _OldCookies;\n\t\t\treturn api;\n\t\t};\n\t}\n}(function () {\n\tfunction extend () {\n\t\tvar i = 0;\n\t\tvar result = {};\n\t\tfor (; i < arguments.length; i++) {\n\t\t\tvar attributes = arguments[ i ];\n\t\t\tfor (var key in attributes) {\n\t\t\t\tresult[key] = attributes[key];\n\t\t\t}\n\t\t}\n\t\treturn result;\n\t}\n\n\tfunction init (converter) {\n\t\tfunction api (key, value, attributes) {\n\t\t\tvar result;\n\n\t\t\t// Write\n\n\t\t\tif (arguments.length > 1) {\n\t\t\t\tattributes = extend({\n\t\t\t\t\tpath: '/'\n\t\t\t\t}, api.defaults, attributes);\n\n\t\t\t\tif (typeof attributes.expires === 'number') {\n\t\t\t\t\tvar expires = new Date();\n\t\t\t\t\texpires.setMilliseconds(expires.getMilliseconds() + attributes.expires * 864e+5);\n\t\t\t\t\tattributes.expires = expires;\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tresult = JSON.stringify(value);\n\t\t\t\t\tif (/^[\\{\\[]/.test(result)) {\n\t\t\t\t\t\tvalue = result;\n\t\t\t\t\t}\n\t\t\t\t} catch (e) {}\n\n\t\t\t\tif (!converter.write) {\n\t\t\t\t\tvalue = encodeURIComponent(String(value))\n\t\t\t\t\t\t.replace(/%(23|24|26|2B|3A|3C|3E|3D|2F|3F|40|5B|5D|5E|60|7B|7D|7C)/g, decodeURIComponent);\n\t\t\t\t} else {\n\t\t\t\t\tvalue = converter.write(value, key);\n\t\t\t\t}\n\n\t\t\t\tkey = encodeURIComponent(String(key));\n\t\t\t\tkey = key.replace(/%(23|24|26|2B|5E|60|7C)/g, decodeURIComponent);\n\t\t\t\tkey = key.replace(/[\\(\\)]/g, escape);\n\n\t\t\t\treturn (document.cookie = [\n\t\t\t\t\tkey, '=', value,\n\t\t\t\t\tattributes.expires && '; expires=' + attributes.expires.toUTCString(), // use expires attribute, max-age is not supported by IE\n\t\t\t\t\tattributes.path    && '; path=' + attributes.path,\n\t\t\t\t\tattributes.domain  && '; domain=' + attributes.domain,\n\t\t\t\t\tattributes.secure ? '; secure' : ''\n\t\t\t\t].join(''));\n\t\t\t}\n\n\t\t\t// Read\n\n\t\t\tif (!key) {\n\t\t\t\tresult = {};\n\t\t\t}\n\n\t\t\t// To prevent the for loop in the first place assign an empty array\n\t\t\t// in case there are no cookies at all. Also prevents odd result when\n\t\t\t// calling \"get()\"\n\t\t\tvar cookies = document.cookie ? document.cookie.split('; ') : [];\n\t\t\tvar rdecode = /(%[0-9A-Z]{2})+/g;\n\t\t\tvar i = 0;\n\n\t\t\tfor (; i < cookies.length; i++) {\n\t\t\t\tvar parts = cookies[i].split('=');\n\t\t\t\tvar name = parts[0].replace(rdecode, decodeURIComponent);\n\t\t\t\tvar cookie = parts.slice(1).join('=');\n\n\t\t\t\tif (cookie.charAt(0) === '\"') {\n\t\t\t\t\tcookie = cookie.slice(1, -1);\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tcookie = converter.read ?\n\t\t\t\t\t\tconverter.read(cookie, name) : converter(cookie, name) ||\n\t\t\t\t\t\tcookie.replace(rdecode, decodeURIComponent);\n\n\t\t\t\t\tif (this.json) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tcookie = JSON.parse(cookie);\n\t\t\t\t\t\t} catch (e) {}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (key === name) {\n\t\t\t\t\t\tresult = cookie;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!key) {\n\t\t\t\t\t\tresult[name] = cookie;\n\t\t\t\t\t}\n\t\t\t\t} catch (e) {}\n\t\t\t}\n\n\t\t\treturn result;\n\t\t}\n\n\t\tapi.get = api.set = api;\n\t\tapi.getJSON = function () {\n\t\t\treturn api.apply({\n\t\t\t\tjson: true\n\t\t\t}, [].slice.call(arguments));\n\t\t};\n\t\tapi.defaults = {};\n\n\t\tapi.remove = function (key, attributes) {\n\t\t\tapi(key, '', extend(attributes, {\n\t\t\t\texpires: -1\n\t\t\t}));\n\t\t};\n\n\t\tapi.withConverter = init;\n\n\t\treturn api;\n\t}\n\n\treturn init(function () {});\n}));\n","js/navigation-menu.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\n\ndefine([\n    \"jquery\",\n    \"matchMedia\",\n    \"mage/template\",\n    \"mage/dropdowns\",\n    \"mage/terms\"\n],function($, mediaCheck, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.navigationMenu', {\n        options: {\n            itemsContainer: '> ul',\n            topLevel: 'li.level0',\n            topLevelSubmenu: '> .submenu',\n            topLevelHoverClass: 'hover',\n            expandedTopLevel: '.more',\n            hoverInTimeout: 300,\n            hoverOutTimeout: 500,\n            submenuAnimationSpeed: 200,\n            collapsable: true,\n            collapsableDropdownTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<li class=\"level0 level-top more parent\">' +\n                        '<div class=\"submenu\">' +\n                            '<ul><%= elems %></ul>' +\n                        '</div>' +\n                    '</li>' +\n                '</script>'\n        },\n\n        _create: function() {\n            this.itemsContainer = $(this.options.itemsContainer, this.element);\n            this.topLevel = $(this.options.topLevel, this.element);\n            this.topLevelSubmenu = $(this.options.topLevelSubmenu, this.topLevel);\n\n            this._bind();\n        },\n\n        _init: function() {\n            if (this.options.collapsable) {\n                setTimeout($.proxy(function() {\n                    this._checkToCollapseOrExpand();\n                }, this), 100);\n            }\n        },\n\n        _bind: function() {\n            this._on({\n                'mouseenter > ul > li.level0': function(e) {\n                    if (!this.entered) { // fix IE bug with 'mouseenter' event\n                        this.timeoutId && clearTimeout(this.timeoutId);\n                        this.timeoutId = setTimeout($.proxy(function() {\n                            this._openSubmenu(e);\n                        }, this), this.options.hoverInTimeout);\n                        this.entered = true;\n                    }\n                },\n                'mouseleave > ul > li.level0': function(e) {\n                    this.entered = null;\n\n                    this.timeoutId && clearTimeout(this.timeoutId);\n                    this.timeoutId = setTimeout($.proxy(function() {\n                        this._closeSubmenu(e.currentTarget);\n                    }, this), this.options.hoverOutTimeout);\n                },\n                'click': function(e) {\n                    e.stopPropagation();\n                }\n            });\n\n            $(document)\n                .on('click.hideMenu', $.proxy(function(e) {\n                    var isOpened = this.topLevel.filter(function() {\n                        return $(this).data('opened');\n                    });\n\n                    if (isOpened) {\n                        this._closeSubmenu(null, false);\n                    }\n                }, this));\n\n            $(window)\n                .on('resize', $.proxy(function() {\n                    this.timeoutOnResize && clearTimeout(this.timeoutOnResize);\n                    this.timeoutOnResize = setTimeout($.proxy(function() {\n                        if (this.options.collapsable) {\n                            if ($(this.options.expandedTopLevel, this.element).length) {\n                                this._expandMenu();\n                            }\n                            this._checkToCollapseOrExpand();\n                        }\n                    }, this), 300);\n                }, this));\n        },\n\n        _openSubmenu: function(e) {\n            var menuItem = e.currentTarget;\n\n            if (!$(menuItem).data('opened')) {\n                this._closeSubmenu(menuItem, true, true);\n\n                $(this.options.topLevelSubmenu, menuItem)\n                    .slideDown(this.options.submenuAnimationSpeed, $.proxy(function() {\n                        $(menuItem).addClass(this.options.topLevelHoverClass);\n                        $(menuItem).data('opened', true);\n                    }, this));\n            } else if ($(e.target).closest(this.options.topLevel)) {\n                $(e.target)\n                    .addClass(this.options.topLevelHoverClass)\n                    .siblings(this.options.topLevel)\n                        .removeClass(this.options.topLevelHoverClass);\n            }\n        },\n\n        _closeSubmenu: function(menuItem, excludeCurrent, fast) {\n            var topLevel = $(this.options.topLevel, this.element),\n                activeSubmenu = $(this.options.topLevelSubmenu, menuItem || null);\n\n            $(this.options.topLevelSubmenu, topLevel)\n                .filter(function() {\n                    return excludeCurrent ? $(this).not(activeSubmenu) : true;\n                })\n                .slideUp(fast ? 0 : this.options.submenuAnimationSpeed);\n\n            topLevel\n                .removeClass(this.options.topLevelHoverClass)\n                .data('opened', false);\n        },\n\n        _checkToCollapseOrExpand: function() {\n            if ($(\"html\").hasClass(\"lt-640\") || $(\"html\").hasClass(\"w-640\")) {\n                return;\n            }\n\n            var navWidth = this.itemsContainer.width(),\n                totalWidth = 0,\n                startCollapseIndex = 0;\n\n            $.each($(this.options.topLevel, this.element), function(index, item) {\n                totalWidth = totalWidth + $(item).outerWidth(true);\n\n                if (totalWidth > navWidth && !startCollapseIndex) {\n                    startCollapseIndex = index - 2;\n                }\n            });\n\n            this[startCollapseIndex ? '_collapseMenu' : '_expandMenu'](startCollapseIndex);\n        },\n\n        _collapseMenu: function(startCollapseIndex) {\n            this.elemsToCollapse = this.topLevel.filter(function(index) {\n                return index > startCollapseIndex;\n            });\n            this.elemsToCollapseClone = $('<div></div>').append(this.elemsToCollapse.clone()).html();\n\n            this.collapsableDropdown = $(\n                mageTemplate(\n                    this.options.collapsableDropdownTemplate,\n                    {elems: this.elemsToCollapseClone}\n                )\n            );\n\n            this.itemsContainer.append(this.collapsableDropdown);\n            this.elemsToCollapse.detach();\n        },\n\n        _expandMenu: function() {\n            this.elemsToCollapse && this.elemsToCollapse.appendTo(this.itemsContainer);\n            this.collapsableDropdown && this.collapsableDropdown.remove();\n        },\n\n        _destroy: function() {\n            this._expandMenu();\n        }\n    });\n\n    /*\n     * Provides \"Continium\" effect for submenu\n     * */\n    $.widget('mage.navigationMenu', $.mage.navigationMenu, {\n        options: {\n            parentLevel: '> ul > li.level0',\n            submenuAnimationSpeed: 150,\n            submenuContiniumEffect: false\n        },\n\n        _init: function() {\n            this._super();\n            this._applySubmenuStyles();\n        },\n\n        _applySubmenuStyles: function() {\n            $(this.options.topLevelSubmenu, $(this.options.topLevel, this.element))\n                .removeAttr('style');\n\n            $(this.options.topLevelSubmenu, $(this.options.parentLevel, this.element))\n                .css({\n                    display: 'block',\n                    height: 0,\n                    overflow: 'hidden'\n                });\n        },\n\n        _openSubmenu: function(e) {\n            var menuItem = e.currentTarget,\n                submenu = $(this.options.topLevelSubmenu, menuItem),\n                openedItems = $(this.options.topLevel, this.element).filter(function() {\n                    return $(this).data('opened');\n                });\n\n            if (submenu.length) {\n                this.heightToAnimate = $(this.options.itemsContainer, submenu).outerHeight(true);\n\n                if (openedItems.length) {\n                    this._closeSubmenu(menuItem, true, this.heightToAnimate, $.proxy(function() {\n                        submenu.css({\n                            height: 'auto'\n                        });\n                        $(menuItem)\n                            .addClass(this.options.topLevelHoverClass);\n                    }, this), e);\n                } else {\n                    submenu.animate({\n                        height: this.heightToAnimate\n                    }, this.options.submenuAnimationSpeed, $.proxy(function() {\n                        $(menuItem)\n                            .addClass(this.options.topLevelHoverClass);\n                    }, this));\n                }\n\n                $(menuItem)\n                    .data('opened', true);\n            } else {\n                this._closeSubmenu(menuItem);\n            }\n        },\n\n        _closeSubmenu: function(menuItem, excludeCurrent, heightToAnimate, callback, e) {\n            var topLevel = $(this.options.topLevel, this.itemsContainer),\n                expandedTopLevel = e && $(e.target).closest(this.options.expandedTopLevel);\n\n            if (!excludeCurrent) {\n                $(this.options.topLevelSubmenu, $(this.options.parentLevel, this.element))\n                    .animate({\n                        height: 0\n                    });\n\n                topLevel\n                    .data('opened', false)\n                    .removeClass(this.options.topLevelHoverClass);\n            } else {\n                var prevOpenedItem = topLevel.filter(function() {\n                        return $(this).data('opened');\n                    }),\n                    prevOpenedSubmenu = $(this.options.topLevelSubmenu, prevOpenedItem);\n\n                prevOpenedSubmenu.animate({\n                    height: heightToAnimate\n                }, this.options.submenuAnimationSpeed, 'linear', function() {\n                    $(this).css({\n                        height: 0\n                    });\n                    callback && callback();\n                });\n\n                prevOpenedItem\n                    .data('opened', false)\n                    .removeClass(this.options.topLevelHoverClass);\n            }\n        },\n\n        _collapseMenu: function() {\n            this._superApply(arguments);\n            this._applySubmenuStyles();\n        }\n    });\n\n    //  Responsive menu\n    $.widget('mage.navigationMenu', $.mage.navigationMenu, {\n        options: {\n            responsive: false,\n            origNavPlaceholder: '.page-header',\n            mainContainer: 'body',\n            pageWrapper: '.page-wrapper',\n            openedMenuClass: 'opened',\n            toggleActionPlaceholder: '.block-search',\n            itemWithSubmenu: 'li.parent',\n            titleWithSubmenu: 'li.parent > a',\n            submenu: 'li.parent > .submenu',\n            toggleActionTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<span data-action=\"toggle-nav\" class=\"action toggle nav\">Toggle Nav</span>' +\n                '</script>',\n            submenuActionsTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<li class=\"action all\">' +\n                        '<a href=\"<%= categoryURL %>\"><span>All <%= category %></span></a>' +\n                    '</li>' +\n                '</script>',\n            navigationSectionsWrapperTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<dl class=\"navigation-tabs\" data-sections=\"tabs\">' +\n                    '</dl>' +\n                '</script>',\n            navigationItemWrapperTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<dt class=\"item title <% if (active) { %>active<% } %>\" data-section=\"title\">' +\n                        '<a class=\"switch\" data-toggle=\"switch\" href=\"#TODO\"><%= title %></a>' +\n                    '</dt>' +\n                    '<dd class=\"item content <% if (active) { %>active<%}%>\" data-section=\"content\">' +\n                    '</dd>' +\n                '</script>'\n        },\n\n        _init: function() {\n            this._super();\n\n            this.mainContainer = $(this.options.mainContainer);\n            this.pageWrapper = $(this.options.pageWrapper);\n            this.toggleAction = $(mageTemplate(this.options.toggleActionTemplate, {}));\n\n            if (this.options.responsive) {\n                mediaCheck({\n                    media: '(min-width: 768px)',\n                    entry: $.proxy(function() {\n                        this._toggleDesktopMode();\n                    }, this),\n                    exit: $.proxy(function() {\n                        this._toggleMobileMode();\n                    }, this)\n                });\n            }\n        },\n\n        _bind: function() {\n            this._super();\n            this._bindDocumentEvents();\n        },\n\n        _bindDocumentEvents: function() {\n            if (!this.eventsBound) {\n                $(document)\n                    .on('click.toggleMenu', '.action.toggle.nav', $.proxy(function(e) {\n                        if ($(this.element).data('opened')) {\n                            this._hideMenu();\n                        } else {\n                            this._showMenu();\n                        }\n                        e.stopPropagation();\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this))\n                    .on('click.hideMenu', this.options.pageWrapper, $.proxy(function() {\n                        if ($(this.element).data('opened')) {\n                            this._hideMenu();\n                            this.mobileNav.scrollTop(0);\n                            this._fixedBackLink();\n                        }\n                    }, this))\n                    .on('click.showSubmenu', this.options.titleWithSubmenu, $.proxy(function(e) {\n                        this._showSubmenu(e);\n\n                        e.preventDefault();\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this))\n                    .on('click.hideSubmenu', '.action.back', $.proxy(function(e) {\n                        this._hideSubmenu(e);\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this));\n\n                this.eventsBound = true;\n            }\n        },\n\n        _showMenu: function() {\n            $(this.element).data('opened', true);\n            this.mainContainer.add( \"html\" ).addClass(this.options.openedMenuClass);\n        },\n\n        _hideMenu: function() {\n            $(this.element).data('opened', false);\n            this.mainContainer.add( \"html\" ).removeClass(this.options.openedMenuClass);\n        },\n\n        _showSubmenu: function(e) {\n            $(e.currentTarget).addClass('action back');\n            var submenu = $(e.currentTarget).siblings('.submenu');\n\n            submenu.addClass('opened');\n        },\n\n        _hideSubmenu: function(e) {\n            var submenuSelector = '.submenu',\n                submenu = $(e.currentTarget).next(submenuSelector);\n            $(e.currentTarget).removeClass('action back');\n            submenu.removeClass('opened');\n        },\n\n        _renderSubmenuActions: function() {\n            $.each(\n                $(this.options.itemWithSubmenu),\n                $.proxy(\n                    function(index, item) {\n                        var actions = $(\n                            mageTemplate(\n                                this.options.submenuActionsTemplate,\n                                {\n                                    category: $('> a > span', item).text(),\n                                    categoryURL: $('> a', item).attr('href')\n                                }\n                            )\n                            ),\n                            submenu = $('> .submenu', item),\n                            items = $('> ul', submenu);\n                            items.prepend(actions);\n                    },\n                    this\n                )\n            );\n        },\n\n        _toggleMobileMode: function() {\n            this._expandMenu();\n\n            $(this.options.topLevelSubmenu, $(this.options.topLevel, this.element))\n                .removeAttr('style');\n\n            this.toggleAction.insertBefore(this.options.toggleActionPlaceholder);\n            this.mobileNav = $(this.element).detach().clone();\n            this.mainContainer.prepend(this.mobileNav);\n            this.mobileNav.find('> ul').addClass('nav');\n            this._insertExtraItems();\n            this._wrapItemsInSections();\n            this.mobileNav.scroll($.proxy(\n                function() {\n                    this._fixedBackLink();\n                }, this\n            ));\n\n            this._renderSubmenuActions();\n            this._bindDocumentEvents();\n        },\n\n        _toggleDesktopMode: function() {\n            this.mobileNav && this.mobileNav.remove();\n            this.toggleAction.detach();\n            $(this.element).insertAfter(this.options.origNavPlaceholder);\n\n            $(document)\n                .off('click.toggleMenu', '.action.toggle.nav')\n                .off('click.hideMenu', this.options.pageWrapper)\n                .off('click.showSubmenu', this.options.titleWithSubmenu)\n                .off('click.hideSubmenu', '.action.back');\n\n            this.eventsBound = false;\n\n            this._applySubmenuStyles();\n        },\n\n        _insertExtraItems: function() {\n            if ($('.header.panel .switcher').length) {\n                var settings = $('.header.panel .switcher')\n                    .clone()\n                    .addClass('settings');\n\n                this.mobileNav.prepend(settings);\n            }\n\n            if ($('.footer .switcher').length) {\n                var footerSettings = $('.footer .switcher')\n                    .clone()\n                    .addClass('settings');\n\n                this.mobileNav.prepend(footerSettings);\n            }\n\n\n            if ($('.header.panel .header.links li').length) {\n                var account = $('.header.panel > .header.links')\n                    .clone()\n                    .addClass('account');\n\n                this.mobileNav.prepend(account);\n            }\n        },\n\n        _wrapItemsInSections: function() {\n            var account = $('> .account', this.mobileNav),\n                settings = $('> .settings', this.mobileNav),\n                nav = $('> .nav', this.mobileNav),\n                navigationSectionsWrapper = $(mageTemplate(this.options.navigationSectionsWrapperTemplate, {})),\n                navigationItemWrapper;\n\n            this.mobileNav.append(navigationSectionsWrapper);\n\n            if (nav.length) {\n                navigationItemWrapper = $(mageTemplate(this.options.navigationItemWrapperTemplate, {title: 'Menu'}));\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(nav);\n            }\n\n            if (account.length) {\n                navigationItemWrapper = $(mageTemplate(this.options.navigationItemWrapperTemplate, {title: 'Account'}));\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(account);\n            }\n\n            if (settings.length) {\n                navigationItemWrapper = $(\n                    mageTemplate(this.options.navigationItemWrapperTemplate, {title: 'Settings'})\n                );\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(settings);\n            }\n\n            navigationSectionsWrapper.addClass(\"navigation-tabs-\" + navigationSectionsWrapper.find('[data-section=\"title\"]').length);\n            navigationSectionsWrapper.terms();\n        },\n\n        _fixedBackLink: function() {\n            var linksBack = this.mobileNav.find('.submenu .action.back');\n            var linkBack = this.mobileNav.find('.submenu.opened > ul > .action.back').last();\n\n            linksBack.removeClass('fixed');\n\n            if(linkBack.length) {\n                var subMenu = linkBack.parent(),\n                    navOffset = this.mobileNav.find('.nav').position().top,\n                    linkBackHeight = linkBack.height();\n\n                if (navOffset <= 0) {\n                    linkBack.addClass('fixed');\n                    subMenu.css({\n                        paddingTop: linkBackHeight\n                    })\n                } else {\n                    linkBack.removeClass('fixed');\n                    subMenu.css({\n                        paddingTop: 0\n                    })\n                }\n            }\n        }\n    });\n\n    return $.mage.navigationMenu;\n});\n","js/responsive.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'matchMedia',\n    'mage/tabs',\n    'domReady!'\n], function ($, mediaCheck) {\n    'use strict';\n\n    mediaCheck({\n        media: '(min-width: 768px)',\n        // Switch to Desktop Version\n        entry: function () {\n            (function () {\n\n                var productInfoMain = $('.product-info-main'),\n                    productInfoAdditional = $('#product-info-additional');\n\n                if (productInfoAdditional.length) {\n                    productInfoAdditional.addClass('hidden');\n                    productInfoMain.removeClass('responsive');\n                }\n\n            })();\n\n            var galleryElement = $('[data-role=media-gallery]');\n\n            if (galleryElement.length && galleryElement.data('mageZoom')) {\n                galleryElement.zoom('enable');\n            }\n\n            if (galleryElement.length && galleryElement.data('mageGallery')) {\n                galleryElement.gallery('option', 'disableLinks', true);\n                galleryElement.gallery('option', 'showNav', false);\n                galleryElement.gallery('option', 'showThumbs', true);\n            }\n        },\n        // Switch to Mobile Version\n        exit: function () {\n            $('.action.toggle.checkout.progress')\n                .on('click.gotoCheckoutProgress', function () {\n                    var myWrapper = '#checkout-progress-wrapper';\n                    scrollTo(myWrapper + ' .title');\n                    $(myWrapper + ' .title').addClass('active');\n                    $(myWrapper + ' .content').show();\n                });\n\n            $('body')\n                .on('click.checkoutProgress', '#checkout-progress-wrapper .title', function () {\n                    $(this).toggleClass('active');\n                    $('#checkout-progress-wrapper .content').toggle();\n                });\n\n            var galleryElement = $('[data-role=media-gallery]');\n\n            setTimeout(function () {\n                if (galleryElement.length && galleryElement.data('mageZoom')) {\n                    galleryElement.zoom('disable');\n                }\n\n                if (galleryElement.length && galleryElement.data('mageGallery')) {\n                    galleryElement.gallery('option', 'disableLinks', false);\n                    galleryElement.gallery('option', 'showNav', true);\n                    galleryElement.gallery('option', 'showThumbs', false);\n                }\n            }, 2000);\n        }\n    });\n});\n","js/theme.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'mage/mage',\n    'mage/ie-class-fixer',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    if ($('body').hasClass('checkout-cart-index')) {\n        if ($('#co-shipping-method-form .fieldset.rates').length > 0 && $('#co-shipping-method-form .fieldset.rates :checked').length === 0) {\n            $('#block-shipping').on('collapsiblecreate', function () {\n                $('#block-shipping').collapsible('forceActivate');\n            });\n        }\n    }\n\n    $('.cart-summary').mage('sticky', {\n        container: '#maincontent'\n    });\n\n    $('.panel.header > .header.links').clone().appendTo('#store\\\\.links');\n\n    keyboardHandler.apply();\n});\n","js/bootstrap.js":"/*!\r\n * Bootstrap v3.3.6 (http://getbootstrap.com)\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under the MIT license\r\n */\r\nrequire(['jquery'], \r\nfunction ($) {\t\t\r\nif (typeof jQuery === 'undefined') {\r\n  throw new Error('Bootstrap\\'s JavaScript requires jQuery')\r\n}\r\n\r\n+function ($) {\r\n  'use strict';\r\n  var version = $.fn.jquery.split(' ')[0].split('.')\r\n  if ((version[0] < 2 && version[1] < 9) || (version[0] == 1 && version[1] == 9 && version[2] < 1) || (version[0] > 2)) {\r\n    throw new Error('Bootstrap\\'s JavaScript requires jQuery version 1.9.1 or higher, but lower than version 3')\r\n  }\r\n}(jQuery);\r\n\r\n/* ========================================================================\r\n * Bootstrap: transition.js v3.3.6\r\n * http://getbootstrap.com/javascript/#transitions\r\n * ========================================================================\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\r\n * ======================================================================== */\r\n\r\n\r\n+function ($) {\r\n  'use strict';\r\n\r\n  // CSS TRANSITION SUPPORT (Shoutout: http://www.modernizr.com/)\r\n  // ============================================================\r\n\r\n  function transitionEnd() {\r\n    var el = document.createElement('bootstrap')\r\n\r\n    var transEndEventNames = {\r\n      WebkitTransition : 'webkitTransitionEnd',\r\n      MozTransition    : 'transitionend',\r\n      OTransition      : 'oTransitionEnd otransitionend',\r\n      transition       : 'transitionend'\r\n    }\r\n\r\n    for (var name in transEndEventNames) {\r\n      if (el.style[name] !== undefined) {\r\n        return { end: transEndEventNames[name] }\r\n      }\r\n    }\r\n\r\n    return false // explicit for ie8 (  ._.)\r\n  }\r\n\r\n  // http://blog.alexmaccaw.com/css-transitions\r\n  $.fn.emulateTransitionEnd = function (duration) {\r\n    var called = false\r\n    var $el = this\r\n    $(this).one('bsTransitionEnd', function () { called = true })\r\n    var callback = function () { if (!called) $($el).trigger($.support.transition.end) }\r\n    setTimeout(callback, duration)\r\n    return this\r\n  }\r\n\r\n  $(function () {\r\n    $.support.transition = transitionEnd()\r\n\r\n    if (!$.support.transition) return\r\n\r\n    $.event.special.bsTransitionEnd = {\r\n      bindType: $.support.transition.end,\r\n      delegateType: $.support.transition.end,\r\n      handle: function (e) {\r\n        if ($(e.target).is(this)) return e.handleObj.handler.apply(this, arguments)\r\n      }\r\n    }\r\n  })\r\n\r\n}(jQuery);\r\n\r\n/* ========================================================================\r\n * Bootstrap: alert.js v3.3.6\r\n * http://getbootstrap.com/javascript/#alerts\r\n * ========================================================================\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\r\n * ======================================================================== */\r\n\r\n\r\n+function ($) {\r\n  'use strict';\r\n\r\n  // ALERT CLASS DEFINITION\r\n  // ======================\r\n\r\n  var dismiss = '[data-dismiss=\"alert\"]'\r\n  var Alert   = function (el) {\r\n    $(el).on('click', dismiss, this.close)\r\n  }\r\n\r\n  Alert.VERSION = '3.3.6'\r\n\r\n  Alert.TRANSITION_DURATION = 150\r\n\r\n  Alert.prototype.close = function (e) {\r\n    var $this    = $(this)\r\n    var selector = $this.attr('data-target')\r\n\r\n    if (!selector) {\r\n      selector = $this.attr('href')\r\n      selector = selector && selector.replace(/.*(?=#[^\\s]*$)/, '') // strip for ie7\r\n    }\r\n\r\n    var $parent = $(selector)\r\n\r\n    if (e) e.preventDefault()\r\n\r\n    if (!$parent.length) {\r\n      $parent = $this.closest('.alert')\r\n    }\r\n\r\n    $parent.trigger(e = $.Event('close.bs.alert'))\r\n\r\n    if (e.isDefaultPrevented()) return\r\n\r\n    $parent.removeClass('in')\r\n\r\n    function removeElement() {\r\n      // detach from parent, fire event then clean up data\r\n      $parent.detach().trigger('closed.bs.alert').remove()\r\n    }\r\n\r\n    $.support.transition && $parent.hasClass('fade') ?\r\n      $parent\r\n        .one('bsTransitionEnd', removeElement)\r\n        .emulateTransitionEnd(Alert.TRANSITION_DURATION) :\r\n      removeElement()\r\n  }\r\n\r\n\r\n  // ALERT PLUGIN DEFINITION\r\n  // =======================\r\n\r\n  function Plugin(option) {\r\n    return this.each(function () {\r\n      var $this = $(this)\r\n      var data  = $this.data('bs.alert')\r\n\r\n      if (!data) $this.data('bs.alert', (data = new Alert(this)))\r\n      if (typeof option == 'string') data[option].call($this)\r\n    })\r\n  }\r\n\r\n  var old = $.fn.alert\r\n\r\n  $.fn.alert             = Plugin\r\n  $.fn.alert.Constructor = Alert\r\n\r\n\r\n  // ALERT NO CONFLICT\r\n  // =================\r\n\r\n  $.fn.alert.noConflict = function () {\r\n    $.fn.alert = old\r\n    return this\r\n  }\r\n\r\n\r\n  // ALERT DATA-API\r\n  // ==============\r\n\r\n  $(document).on('click.bs.alert.data-api', dismiss, Alert.prototype.close)\r\n\r\n}(jQuery);\r\n\r\n/* ========================================================================\r\n * Bootstrap: button.js v3.3.6\r\n * http://getbootstrap.com/javascript/#buttons\r\n * ========================================================================\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\r\n * ======================================================================== */\r\n\r\n\r\n+function ($) {\r\n  'use strict';\r\n\r\n  // BUTTON PUBLIC CLASS DEFINITION\r\n  // ==============================\r\n\r\n  var Button = function (element, options) {\r\n    this.$element  = $(element)\r\n    this.options   = $.extend({}, Button.DEFAULTS, options)\r\n    this.isLoading = false\r\n  }\r\n\r\n  Button.VERSION  = '3.3.6'\r\n\r\n  Button.DEFAULTS = {\r\n    loadingText: 'loading...'\r\n  }\r\n\r\n  Button.prototype.setState = function (state) {\r\n    var d    = 'disabled'\r\n    var $el  = this.$element\r\n    var val  = $el.is('input') ? 'val' : 'html'\r\n    var data = $el.data()\r\n\r\n    state += 'Text'\r\n\r\n    if (data.resetText == null) $el.data('resetText', $el[val]())\r\n\r\n    // push to event loop to allow forms to submit\r\n    setTimeout($.proxy(function () {\r\n      $el[val](data[state] == null ? this.options[state] : data[state])\r\n\r\n      if (state == 'loadingText') {\r\n        this.isLoading = true\r\n        $el.addClass(d).attr(d, d)\r\n      } else if (this.isLoading) {\r\n        this.isLoading = false\r\n        $el.removeClass(d).removeAttr(d)\r\n      }\r\n    }, this), 0)\r\n  }\r\n\r\n  Button.prototype.toggle = function () {\r\n    var changed = true\r\n    var $parent = this.$element.closest('[data-toggle=\"buttons\"]')\r\n\r\n    if ($parent.length) {\r\n      var $input = this.$element.find('input')\r\n      if ($input.prop('type') == 'radio') {\r\n        if ($input.prop('checked')) changed = false\r\n        $parent.find('.active').removeClass('active')\r\n        this.$element.addClass('active')\r\n      } else if ($input.prop('type') == 'checkbox') {\r\n        if (($input.prop('checked')) !== this.$element.hasClass('active')) changed = false\r\n        this.$element.toggleClass('active')\r\n      }\r\n      $input.prop('checked', this.$element.hasClass('active'))\r\n      if (changed) $input.trigger('change')\r\n    } else {\r\n      this.$element.attr('aria-pressed', !this.$element.hasClass('active'))\r\n      this.$element.toggleClass('active')\r\n    }\r\n  }\r\n\r\n\r\n  // BUTTON PLUGIN DEFINITION\r\n  // ========================\r\n\r\n  function Plugin(option) {\r\n    return this.each(function () {\r\n      var $this   = $(this)\r\n      var data    = $this.data('bs.button')\r\n      var options = typeof option == 'object' && option\r\n\r\n      if (!data) $this.data('bs.button', (data = new Button(this, options)))\r\n\r\n      if (option == 'toggle') data.toggle()\r\n      else if (option) data.setState(option)\r\n    })\r\n  }\r\n\r\n  var old = $.fn.button\r\n\r\n  $.fn.button             = Plugin\r\n  $.fn.button.Constructor = Button\r\n\r\n\r\n  // BUTTON NO CONFLICT\r\n  // ==================\r\n\r\n  $.fn.button.noConflict = function () {\r\n    $.fn.button = old\r\n    return this\r\n  }\r\n\r\n\r\n  // BUTTON DATA-API\r\n  // ===============\r\n\r\n  $(document)\r\n    .on('click.bs.button.data-api', '[data-toggle^=\"button\"]', function (e) {\r\n      var $btn = $(e.target)\r\n      if (!$btn.hasClass('btn')) $btn = $btn.closest('.btn')\r\n      Plugin.call($btn, 'toggle')\r\n      if (!($(e.target).is('input[type=\"radio\"]') || $(e.target).is('input[type=\"checkbox\"]'))) e.preventDefault()\r\n    })\r\n    .on('focus.bs.button.data-api blur.bs.button.data-api', '[data-toggle^=\"button\"]', function (e) {\r\n      $(e.target).closest('.btn').toggleClass('focus', /^focus(in)?$/.test(e.type))\r\n    })\r\n\r\n}(jQuery);\r\n\r\n/* ========================================================================\r\n * Bootstrap: carousel.js v3.3.6\r\n * http://getbootstrap.com/javascript/#carousel\r\n * ========================================================================\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\r\n * ======================================================================== */\r\n\r\n\r\n+function ($) {\r\n  'use strict';\r\n\r\n  // CAROUSEL CLASS DEFINITION\r\n  // =========================\r\n\r\n  var Carousel = function (element, options) {\r\n    this.$element    = $(element)\r\n    this.$indicators = this.$element.find('.carousel-indicators')\r\n    this.options     = options\r\n    this.paused      = null\r\n    this.sliding     = null\r\n    this.interval    = null\r\n    this.$active     = null\r\n    this.$items      = null\r\n\r\n    this.options.keyboard && this.$element.on('keydown.bs.carousel', $.proxy(this.keydown, this))\r\n\r\n    this.options.pause == 'hover' && !('ontouchstart' in document.documentElement) && this.$element\r\n      .on('mouseenter.bs.carousel', $.proxy(this.pause, this))\r\n      .on('mouseleave.bs.carousel', $.proxy(this.cycle, this))\r\n  }\r\n\r\n  Carousel.VERSION  = '3.3.6'\r\n\r\n  Carousel.TRANSITION_DURATION = 600\r\n\r\n  Carousel.DEFAULTS = {\r\n    interval: 5000,\r\n    pause: 'hover',\r\n    wrap: true,\r\n    keyboard: true\r\n  }\r\n\r\n  Carousel.prototype.keydown = function (e) {\r\n    if (/input|textarea/i.test(e.target.tagName)) return\r\n    switch (e.which) {\r\n      case 37: this.prev(); break\r\n      case 39: this.next(); break\r\n      default: return\r\n    }\r\n\r\n    e.preventDefault()\r\n  }\r\n\r\n  Carousel.prototype.cycle = function (e) {\r\n    e || (this.paused = false)\r\n\r\n    this.interval && clearInterval(this.interval)\r\n\r\n    this.options.interval\r\n      && !this.paused\r\n      && (this.interval = setInterval($.proxy(this.next, this), this.options.interval))\r\n\r\n    return this\r\n  }\r\n\r\n  Carousel.prototype.getItemIndex = function (item) {\r\n    this.$items = item.parent().children('.item')\r\n    return this.$items.index(item || this.$active)\r\n  }\r\n\r\n  Carousel.prototype.getItemForDirection = function (direction, active) {\r\n    var activeIndex = this.getItemIndex(active)\r\n    var willWrap = (direction == 'prev' && activeIndex === 0)\r\n                || (direction == 'next' && activeIndex == (this.$items.length - 1))\r\n    if (willWrap && !this.options.wrap) return active\r\n    var delta = direction == 'prev' ? -1 : 1\r\n    var itemIndex = (activeIndex + delta) % this.$items.length\r\n    return this.$items.eq(itemIndex)\r\n  }\r\n\r\n  Carousel.prototype.to = function (pos) {\r\n    var that        = this\r\n    var activeIndex = this.getItemIndex(this.$active = this.$element.find('.item.active'))\r\n\r\n    if (pos > (this.$items.length - 1) || pos < 0) return\r\n\r\n    if (this.sliding)       return this.$element.one('slid.bs.carousel', function () { that.to(pos) }) // yes, \"slid\"\r\n    if (activeIndex == pos) return this.pause().cycle()\r\n\r\n    return this.slide(pos > activeIndex ? 'next' : 'prev', this.$items.eq(pos))\r\n  }\r\n\r\n  Carousel.prototype.pause = function (e) {\r\n    e || (this.paused = true)\r\n\r\n    if (this.$element.find('.next, .prev').length && $.support.transition) {\r\n      this.$element.trigger($.support.transition.end)\r\n      this.cycle(true)\r\n    }\r\n\r\n    this.interval = clearInterval(this.interval)\r\n\r\n    return this\r\n  }\r\n\r\n  Carousel.prototype.next = function () {\r\n    if (this.sliding) return\r\n    return this.slide('next')\r\n  }\r\n\r\n  Carousel.prototype.prev = function () {\r\n    if (this.sliding) return\r\n    return this.slide('prev')\r\n  }\r\n\r\n  Carousel.prototype.slide = function (type, next) {\r\n    var $active   = this.$element.find('.item.active')\r\n    var $next     = next || this.getItemForDirection(type, $active)\r\n    var isCycling = this.interval\r\n    var direction = type == 'next' ? 'left' : 'right'\r\n    var that      = this\r\n\r\n    if ($next.hasClass('active')) return (this.sliding = false)\r\n\r\n    var relatedTarget = $next[0]\r\n    var slideEvent = $.Event('slide.bs.carousel', {\r\n      relatedTarget: relatedTarget,\r\n      direction: direction\r\n    })\r\n    this.$element.trigger(slideEvent)\r\n    if (slideEvent.isDefaultPrevented()) return\r\n\r\n    this.sliding = true\r\n\r\n    isCycling && this.pause()\r\n\r\n    if (this.$indicators.length) {\r\n      this.$indicators.find('.active').removeClass('active')\r\n      var $nextIndicator = $(this.$indicators.children()[this.getItemIndex($next)])\r\n      $nextIndicator && $nextIndicator.addClass('active')\r\n    }\r\n\r\n    var slidEvent = $.Event('slid.bs.carousel', { relatedTarget: relatedTarget, direction: direction }) // yes, \"slid\"\r\n    if ($.support.transition && this.$element.hasClass('slide')) {\r\n      $next.addClass(type)\r\n      $next[0].offsetWidth // force reflow\r\n      $active.addClass(direction)\r\n      $next.addClass(direction)\r\n      $active\r\n        .one('bsTransitionEnd', function () {\r\n          $next.removeClass([type, direction].join(' ')).addClass('active')\r\n          $active.removeClass(['active', direction].join(' '))\r\n          that.sliding = false\r\n          setTimeout(function () {\r\n            that.$element.trigger(slidEvent)\r\n          }, 0)\r\n        })\r\n        .emulateTransitionEnd(Carousel.TRANSITION_DURATION)\r\n    } else {\r\n      $active.removeClass('active')\r\n      $next.addClass('active')\r\n      this.sliding = false\r\n      this.$element.trigger(slidEvent)\r\n    }\r\n\r\n    isCycling && this.cycle()\r\n\r\n    return this\r\n  }\r\n\r\n\r\n  // CAROUSEL PLUGIN DEFINITION\r\n  // ==========================\r\n\r\n  function Plugin(option) {\r\n    return this.each(function () {\r\n      var $this   = $(this)\r\n      var data    = $this.data('bs.carousel')\r\n      var options = $.extend({}, Carousel.DEFAULTS, $this.data(), typeof option == 'object' && option)\r\n      var action  = typeof option == 'string' ? option : options.slide\r\n\r\n      if (!data) $this.data('bs.carousel', (data = new Carousel(this, options)))\r\n      if (typeof option == 'number') data.to(option)\r\n      else if (action) data[action]()\r\n      else if (options.interval) data.pause().cycle()\r\n    })\r\n  }\r\n\r\n  var old = $.fn.carousel\r\n\r\n  $.fn.carousel             = Plugin\r\n  $.fn.carousel.Constructor = Carousel\r\n\r\n\r\n  // CAROUSEL NO CONFLICT\r\n  // ====================\r\n\r\n  $.fn.carousel.noConflict = function () {\r\n    $.fn.carousel = old\r\n    return this\r\n  }\r\n\r\n\r\n  // CAROUSEL DATA-API\r\n  // =================\r\n\r\n  var clickHandler = function (e) {\r\n    var href\r\n    var $this   = $(this)\r\n    var $target = $($this.attr('data-target') || (href = $this.attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '')) // strip for ie7\r\n    if (!$target.hasClass('carousel')) return\r\n    var options = $.extend({}, $target.data(), $this.data())\r\n    var slideIndex = $this.attr('data-slide-to')\r\n    if (slideIndex) options.interval = false\r\n\r\n    Plugin.call($target, options)\r\n\r\n    if (slideIndex) {\r\n      $target.data('bs.carousel').to(slideIndex)\r\n    }\r\n\r\n    e.preventDefault()\r\n  }\r\n\r\n  $(document)\r\n    .on('click.bs.carousel.data-api', '[data-slide]', clickHandler)\r\n    .on('click.bs.carousel.data-api', '[data-slide-to]', clickHandler)\r\n\r\n  $(window).on('load', function () {\r\n    $('[data-ride=\"carousel\"]').each(function () {\r\n      var $carousel = $(this)\r\n      Plugin.call($carousel, $carousel.data())\r\n    })\r\n  })\r\n\r\n}(jQuery);\r\n\r\n/* ========================================================================\r\n * Bootstrap: collapse.js v3.3.6\r\n * http://getbootstrap.com/javascript/#collapse\r\n * ========================================================================\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\r\n * ======================================================================== */\r\n\r\n\r\n+function ($) {\r\n  'use strict';\r\n\r\n  // COLLAPSE PUBLIC CLASS DEFINITION\r\n  // ================================\r\n\r\n  var Collapse = function (element, options) {\r\n    this.$element      = $(element)\r\n    this.options       = $.extend({}, Collapse.DEFAULTS, options)\r\n    this.$trigger      = $('[data-toggle=\"collapse\"][href=\"#' + element.id + '\"],' +\r\n                           '[data-toggle=\"collapse\"][data-target=\"#' + element.id + '\"]')\r\n    this.transitioning = null\r\n\r\n    if (this.options.parent) {\r\n      this.$parent = this.getParent()\r\n    } else {\r\n      this.addAriaAndCollapsedClass(this.$element, this.$trigger)\r\n    }\r\n\r\n    if (this.options.toggle) this.toggle()\r\n  }\r\n\r\n  Collapse.VERSION  = '3.3.6'\r\n\r\n  Collapse.TRANSITION_DURATION = 350\r\n\r\n  Collapse.DEFAULTS = {\r\n    toggle: true\r\n  }\r\n\r\n  Collapse.prototype.dimension = function () {\r\n    var hasWidth = this.$element.hasClass('width')\r\n    return hasWidth ? 'width' : 'height'\r\n  }\r\n\r\n  Collapse.prototype.show = function () {\r\n    if (this.transitioning || this.$element.hasClass('in')) return\r\n\r\n    var activesData\r\n    var actives = this.$parent && this.$parent.children('.panel').children('.in, .collapsing')\r\n\r\n    if (actives && actives.length) {\r\n      activesData = actives.data('bs.collapse')\r\n      if (activesData && activesData.transitioning) return\r\n    }\r\n\r\n    var startEvent = $.Event('show.bs.collapse')\r\n    this.$element.trigger(startEvent)\r\n    if (startEvent.isDefaultPrevented()) return\r\n\r\n    if (actives && actives.length) {\r\n      Plugin.call(actives, 'hide')\r\n      activesData || actives.data('bs.collapse', null)\r\n    }\r\n\r\n    var dimension = this.dimension()\r\n\r\n    this.$element\r\n      .removeClass('collapse')\r\n      .addClass('collapsing')[dimension](0)\r\n      .attr('aria-expanded', true)\r\n\r\n    this.$trigger\r\n      .removeClass('collapsed')\r\n      .attr('aria-expanded', true)\r\n\r\n    this.transitioning = 1\r\n\r\n    var complete = function () {\r\n      this.$element\r\n        .removeClass('collapsing')\r\n        .addClass('collapse in')[dimension]('')\r\n      this.transitioning = 0\r\n      this.$element\r\n        .trigger('shown.bs.collapse')\r\n    }\r\n\r\n    if (!$.support.transition) return complete.call(this)\r\n\r\n    var scrollSize = $.camelCase(['scroll', dimension].join('-'))\r\n\r\n    this.$element\r\n      .one('bsTransitionEnd', $.proxy(complete, this))\r\n      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])\r\n  }\r\n\r\n  Collapse.prototype.hide = function () {\r\n    if (this.transitioning || !this.$element.hasClass('in')) return\r\n\r\n    var startEvent = $.Event('hide.bs.collapse')\r\n    this.$element.trigger(startEvent)\r\n    if (startEvent.isDefaultPrevented()) return\r\n\r\n    var dimension = this.dimension()\r\n\r\n    this.$element[dimension](this.$element[dimension]())[0].offsetHeight\r\n\r\n    this.$element\r\n      .addClass('collapsing')\r\n      .removeClass('collapse in')\r\n      .attr('aria-expanded', false)\r\n\r\n    this.$trigger\r\n      .addClass('collapsed')\r\n      .attr('aria-expanded', false)\r\n\r\n    this.transitioning = 1\r\n\r\n    var complete = function () {\r\n      this.transitioning = 0\r\n      this.$element\r\n        .removeClass('collapsing')\r\n        .addClass('collapse')\r\n        .trigger('hidden.bs.collapse')\r\n    }\r\n\r\n    if (!$.support.transition) return complete.call(this)\r\n\r\n    this.$element\r\n      [dimension](0)\r\n      .one('bsTransitionEnd', $.proxy(complete, this))\r\n      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)\r\n  }\r\n\r\n  Collapse.prototype.toggle = function () {\r\n    this[this.$element.hasClass('in') ? 'hide' : 'show']()\r\n  }\r\n\r\n  Collapse.prototype.getParent = function () {\r\n    return $(this.options.parent)\r\n      .find('[data-toggle=\"collapse\"][data-parent=\"' + this.options.parent + '\"]')\r\n      .each($.proxy(function (i, element) {\r\n        var $element = $(element)\r\n        this.addAriaAndCollapsedClass(getTargetFromTrigger($element), $element)\r\n      }, this))\r\n      .end()\r\n  }\r\n\r\n  Collapse.prototype.addAriaAndCollapsedClass = function ($element, $trigger) {\r\n    var isOpen = $element.hasClass('in')\r\n\r\n    $element.attr('aria-expanded', isOpen)\r\n    $trigger\r\n      .toggleClass('collapsed', !isOpen)\r\n      .attr('aria-expanded', isOpen)\r\n  }\r\n\r\n  function getTargetFromTrigger($trigger) {\r\n    var href\r\n    var target = $trigger.attr('data-target')\r\n      || (href = $trigger.attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '') // strip for ie7\r\n\r\n    return $(target)\r\n  }\r\n\r\n\r\n  // COLLAPSE PLUGIN DEFINITION\r\n  // ==========================\r\n\r\n  function Plugin(option) {\r\n    return this.each(function () {\r\n      var $this   = $(this)\r\n      var data    = $this.data('bs.collapse')\r\n      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)\r\n\r\n      if (!data && options.toggle && /show|hide/.test(option)) options.toggle = false\r\n      if (!data) $this.data('bs.collapse', (data = new Collapse(this, options)))\r\n      if (typeof option == 'string') data[option]()\r\n    })\r\n  }\r\n\r\n  var old = $.fn.collapse\r\n\r\n  $.fn.collapse             = Plugin\r\n  $.fn.collapse.Constructor = Collapse\r\n\r\n\r\n  // COLLAPSE NO CONFLICT\r\n  // ====================\r\n\r\n  $.fn.collapse.noConflict = function () {\r\n    $.fn.collapse = old\r\n    return this\r\n  }\r\n\r\n\r\n  // COLLAPSE DATA-API\r\n  // =================\r\n\r\n  $(document).on('click.bs.collapse.data-api', '[data-toggle=\"collapse\"]', function (e) {\r\n    var $this   = $(this)\r\n\r\n    if (!$this.attr('data-target')) e.preventDefault()\r\n\r\n    var $target = getTargetFromTrigger($this)\r\n    var data    = $target.data('bs.collapse')\r\n    var option  = data ? 'toggle' : $this.data()\r\n\r\n    Plugin.call($target, option)\r\n  })\r\n\r\n}(jQuery);\r\n\r\n/* ========================================================================\r\n * Bootstrap: dropdown.js v3.3.6\r\n * http://getbootstrap.com/javascript/#dropdowns\r\n * ========================================================================\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\r\n * ======================================================================== */\r\n\r\n\r\n+function ($) {\r\n  'use strict';\r\n\r\n  // DROPDOWN CLASS DEFINITION\r\n  // =========================\r\n\r\n  var backdrop = '.dropdown-backdrop'\r\n  var toggle   = '[data-toggle=\"dropdown\"]'\r\n  var Dropdown = function (element) {\r\n    $(element).on('click.bs.dropdown', this.toggle)\r\n  }\r\n\r\n  Dropdown.VERSION = '3.3.6'\r\n\r\n  function getParent($this) {\r\n    var selector = $this.attr('data-target')\r\n\r\n    if (!selector) {\r\n      selector = $this.attr('href')\r\n      selector = selector && /#[A-Za-z]/.test(selector) && selector.replace(/.*(?=#[^\\s]*$)/, '') // strip for ie7\r\n    }\r\n\r\n    var $parent = selector && $(selector)\r\n\r\n    return $parent && $parent.length ? $parent : $this.parent()\r\n  }\r\n\r\n  function clearMenus(e) {\r\n    if (e && e.which === 3) return\r\n    $(backdrop).remove()\r\n    $(toggle).each(function () {\r\n      var $this         = $(this)\r\n      var $parent       = getParent($this)\r\n      var relatedTarget = { relatedTarget: this }\r\n\r\n      if (!$parent.hasClass('open')) return\r\n\r\n      if (e && e.type == 'click' && /input|textarea/i.test(e.target.tagName) && $.contains($parent[0], e.target)) return\r\n\r\n      $parent.trigger(e = $.Event('hide.bs.dropdown', relatedTarget))\r\n\r\n      if (e.isDefaultPrevented()) return\r\n\r\n      $this.attr('aria-expanded', 'false')\r\n      $parent.removeClass('open').trigger($.Event('hidden.bs.dropdown', relatedTarget))\r\n    })\r\n  }\r\n\r\n  Dropdown.prototype.toggle = function (e) {\r\n    var $this = $(this)\r\n\r\n    if ($this.is('.disabled, :disabled')) return\r\n\r\n    var $parent  = getParent($this)\r\n    var isActive = $parent.hasClass('open')\r\n\r\n    clearMenus()\r\n\r\n    if (!isActive) {\r\n      if ('ontouchstart' in document.documentElement && !$parent.closest('.navbar-nav').length) {\r\n        // if mobile we use a backdrop because click events don't delegate\r\n        $(document.createElement('div'))\r\n          .addClass('dropdown-backdrop')\r\n          .insertAfter($(this))\r\n          .on('click', clearMenus)\r\n      }\r\n\r\n      var relatedTarget = { relatedTarget: this }\r\n      $parent.trigger(e = $.Event('show.bs.dropdown', relatedTarget))\r\n\r\n      if (e.isDefaultPrevented()) return\r\n\r\n      $this\r\n        .trigger('focus')\r\n        .attr('aria-expanded', 'true')\r\n\r\n      $parent\r\n        .toggleClass('open')\r\n        .trigger($.Event('shown.bs.dropdown', relatedTarget))\r\n    }\r\n\r\n    return false\r\n  }\r\n\r\n  Dropdown.prototype.keydown = function (e) {\r\n    if (!/(38|40|27|32)/.test(e.which) || /input|textarea/i.test(e.target.tagName)) return\r\n\r\n    var $this = $(this)\r\n\r\n    e.preventDefault()\r\n    e.stopPropagation()\r\n\r\n    if ($this.is('.disabled, :disabled')) return\r\n\r\n    var $parent  = getParent($this)\r\n    var isActive = $parent.hasClass('open')\r\n\r\n    if (!isActive && e.which != 27 || isActive && e.which == 27) {\r\n      if (e.which == 27) $parent.find(toggle).trigger('focus')\r\n      return $this.trigger('click')\r\n    }\r\n\r\n    var desc = ' li:not(.disabled):visible a'\r\n    var $items = $parent.find('.dropdown-menu' + desc)\r\n\r\n    if (!$items.length) return\r\n\r\n    var index = $items.index(e.target)\r\n\r\n    if (e.which == 38 && index > 0)                 index--         // up\r\n    if (e.which == 40 && index < $items.length - 1) index++         // down\r\n    if (!~index)                                    index = 0\r\n\r\n    $items.eq(index).trigger('focus')\r\n  }\r\n\r\n\r\n  // DROPDOWN PLUGIN DEFINITION\r\n  // ==========================\r\n\r\n  function Plugin(option) {\r\n    return this.each(function () {\r\n      var $this = $(this)\r\n      var data  = $this.data('bs.dropdown')\r\n\r\n      if (!data) $this.data('bs.dropdown', (data = new Dropdown(this)))\r\n      if (typeof option == 'string') data[option].call($this)\r\n    })\r\n  }\r\n\r\n  var old = $.fn.dropdown\r\n\r\n  $.fn.dropdown             = Plugin\r\n  $.fn.dropdown.Constructor = Dropdown\r\n\r\n\r\n  // DROPDOWN NO CONFLICT\r\n  // ====================\r\n\r\n  $.fn.dropdown.noConflict = function () {\r\n    $.fn.dropdown = old\r\n    return this\r\n  }\r\n\r\n\r\n  // APPLY TO STANDARD DROPDOWN ELEMENTS\r\n  // ===================================\r\n\r\n  $(document)\r\n    .on('click.bs.dropdown.data-api', clearMenus)\r\n    .on('click.bs.dropdown.data-api', '.dropdown form', function (e) { e.stopPropagation() })\r\n    .on('click.bs.dropdown.data-api', toggle, Dropdown.prototype.toggle)\r\n    .on('keydown.bs.dropdown.data-api', toggle, Dropdown.prototype.keydown)\r\n    .on('keydown.bs.dropdown.data-api', '.dropdown-menu', Dropdown.prototype.keydown)\r\n\r\n}(jQuery);\r\n\r\n/* ========================================================================\r\n * Bootstrap: modal.js v3.3.6\r\n * http://getbootstrap.com/javascript/#modals\r\n * ========================================================================\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\r\n * ======================================================================== */\r\n\r\n\r\n+function ($) {\r\n  'use strict';\r\n\r\n  // MODAL CLASS DEFINITION\r\n  // ======================\r\n\r\n  var Modal = function (element, options) {\r\n    this.options             = options\r\n    this.$body               = $(document.body)\r\n    this.$element            = $(element)\r\n    this.$dialog             = this.$element.find('.modal-dialog')\r\n    this.$backdrop           = null\r\n    this.isShown             = null\r\n    this.originalBodyPad     = null\r\n    this.scrollbarWidth      = 0\r\n    this.ignoreBackdropClick = false\r\n\r\n    if (this.options.remote) {\r\n      this.$element\r\n        .find('.modal-content')\r\n        .load(this.options.remote, $.proxy(function () {\r\n          this.$element.trigger('loaded.bs.modal')\r\n        }, this))\r\n    }\r\n  }\r\n\r\n  Modal.VERSION  = '3.3.6'\r\n\r\n  Modal.TRANSITION_DURATION = 300\r\n  Modal.BACKDROP_TRANSITION_DURATION = 150\r\n\r\n  Modal.DEFAULTS = {\r\n    backdrop: true,\r\n    keyboard: true,\r\n    show: true\r\n  }\r\n\r\n  Modal.prototype.toggle = function (_relatedTarget) {\r\n    return this.isShown ? this.hide() : this.show(_relatedTarget)\r\n  }\r\n\r\n  Modal.prototype.show = function (_relatedTarget) {\r\n    var that = this\r\n    var e    = $.Event('show.bs.modal', { relatedTarget: _relatedTarget })\r\n\r\n    this.$element.trigger(e)\r\n\r\n    if (this.isShown || e.isDefaultPrevented()) return\r\n\r\n    this.isShown = true\r\n\r\n    this.checkScrollbar()\r\n    this.setScrollbar()\r\n    this.$body.addClass('modal-open')\r\n\r\n    this.escape()\r\n    this.resize()\r\n\r\n    this.$element.on('click.dismiss.bs.modal', '[data-dismiss=\"modal\"]', $.proxy(this.hide, this))\r\n\r\n    this.$dialog.on('mousedown.dismiss.bs.modal', function () {\r\n      that.$element.one('mouseup.dismiss.bs.modal', function (e) {\r\n        if ($(e.target).is(that.$element)) that.ignoreBackdropClick = true\r\n      })\r\n    })\r\n\r\n    this.backdrop(function () {\r\n      var transition = $.support.transition && that.$element.hasClass('fade')\r\n\r\n      if (!that.$element.parent().length) {\r\n        that.$element.appendTo(that.$body) // don't move modals dom position\r\n      }\r\n\r\n      that.$element\r\n        .show()\r\n        .scrollTop(0)\r\n\r\n      that.adjustDialog()\r\n\r\n      if (transition) {\r\n        that.$element[0].offsetWidth // force reflow\r\n      }\r\n\r\n      that.$element.addClass('in')\r\n\r\n      that.enforceFocus()\r\n\r\n      var e = $.Event('shown.bs.modal', { relatedTarget: _relatedTarget })\r\n\r\n      transition ?\r\n        that.$dialog // wait for modal to slide in\r\n          .one('bsTransitionEnd', function () {\r\n            that.$element.trigger('focus').trigger(e)\r\n          })\r\n          .emulateTransitionEnd(Modal.TRANSITION_DURATION) :\r\n        that.$element.trigger('focus').trigger(e)\r\n    })\r\n  }\r\n\r\n  Modal.prototype.hide = function (e) {\r\n    if (e) e.preventDefault()\r\n\r\n    e = $.Event('hide.bs.modal')\r\n\r\n    this.$element.trigger(e)\r\n\r\n    if (!this.isShown || e.isDefaultPrevented()) return\r\n\r\n    this.isShown = false\r\n\r\n    this.escape()\r\n    this.resize()\r\n\r\n    $(document).off('focusin.bs.modal')\r\n\r\n    this.$element\r\n      .removeClass('in')\r\n      .off('click.dismiss.bs.modal')\r\n      .off('mouseup.dismiss.bs.modal')\r\n\r\n    this.$dialog.off('mousedown.dismiss.bs.modal')\r\n\r\n    $.support.transition && this.$element.hasClass('fade') ?\r\n      this.$element\r\n        .one('bsTransitionEnd', $.proxy(this.hideModal, this))\r\n        .emulateTransitionEnd(Modal.TRANSITION_DURATION) :\r\n      this.hideModal()\r\n  }\r\n\r\n  Modal.prototype.enforceFocus = function () {\r\n    $(document)\r\n      .off('focusin.bs.modal') // guard against infinite focus loop\r\n      .on('focusin.bs.modal', $.proxy(function (e) {\r\n        if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {\r\n          this.$element.trigger('focus')\r\n        }\r\n      }, this))\r\n  }\r\n\r\n  Modal.prototype.escape = function () {\r\n    if (this.isShown && this.options.keyboard) {\r\n      this.$element.on('keydown.dismiss.bs.modal', $.proxy(function (e) {\r\n        e.which == 27 && this.hide()\r\n      }, this))\r\n    } else if (!this.isShown) {\r\n      this.$element.off('keydown.dismiss.bs.modal')\r\n    }\r\n  }\r\n\r\n  Modal.prototype.resize = function () {\r\n    if (this.isShown) {\r\n      $(window).on('resize.bs.modal', $.proxy(this.handleUpdate, this))\r\n    } else {\r\n      $(window).off('resize.bs.modal')\r\n    }\r\n  }\r\n\r\n  Modal.prototype.hideModal = function () {\r\n    var that = this\r\n    this.$element.hide()\r\n    this.backdrop(function () {\r\n      that.$body.removeClass('modal-open')\r\n      that.resetAdjustments()\r\n      that.resetScrollbar()\r\n      that.$element.trigger('hidden.bs.modal')\r\n    })\r\n  }\r\n\r\n  Modal.prototype.removeBackdrop = function () {\r\n    this.$backdrop && this.$backdrop.remove()\r\n    this.$backdrop = null\r\n  }\r\n\r\n  Modal.prototype.backdrop = function (callback) {\r\n    var that = this\r\n    var animate = this.$element.hasClass('fade') ? 'fade' : ''\r\n\r\n    if (this.isShown && this.options.backdrop) {\r\n      var doAnimate = $.support.transition && animate\r\n\r\n      this.$backdrop = $(document.createElement('div'))\r\n        .addClass('modal-backdrop ' + animate)\r\n        .appendTo(this.$body)\r\n\r\n      this.$element.on('click.dismiss.bs.modal', $.proxy(function (e) {\r\n        if (this.ignoreBackdropClick) {\r\n          this.ignoreBackdropClick = false\r\n          return\r\n        }\r\n        if (e.target !== e.currentTarget) return\r\n        this.options.backdrop == 'static'\r\n          ? this.$element[0].focus()\r\n          : this.hide()\r\n      }, this))\r\n\r\n      if (doAnimate) this.$backdrop[0].offsetWidth // force reflow\r\n\r\n      this.$backdrop.addClass('in')\r\n\r\n      if (!callback) return\r\n\r\n      doAnimate ?\r\n        this.$backdrop\r\n          .one('bsTransitionEnd', callback)\r\n          .emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) :\r\n        callback()\r\n\r\n    } else if (!this.isShown && this.$backdrop) {\r\n      this.$backdrop.removeClass('in')\r\n\r\n      var callbackRemove = function () {\r\n        that.removeBackdrop()\r\n        callback && callback()\r\n      }\r\n      $.support.transition && this.$element.hasClass('fade') ?\r\n        this.$backdrop\r\n          .one('bsTransitionEnd', callbackRemove)\r\n          .emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) :\r\n        callbackRemove()\r\n\r\n    } else if (callback) {\r\n      callback()\r\n    }\r\n  }\r\n\r\n  // these following methods are used to handle overflowing modals\r\n\r\n  Modal.prototype.handleUpdate = function () {\r\n    this.adjustDialog()\r\n  }\r\n\r\n  Modal.prototype.adjustDialog = function () {\r\n    var modalIsOverflowing = this.$element[0].scrollHeight > document.