require.config({
    config: {
        'jsbuild':{"Magento_OfflineShipping/js/model/shipping-rates-validation-rules/tablerate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        \"use strict\";\n        return {\n            getRules: function() {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    },\n                    'region_id': {\n                        'required': true\n                    },\n                    'region_id_input': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validator/flatrate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        '../shipping-rates-validation-rules/flatrate',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        \"use strict\";\n        return {\n            validationErrors: [],\n            validate: function(address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function(field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validator/freeshipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        '../shipping-rates-validation-rules/freeshipping',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        \"use strict\";\n        return {\n            validationErrors: [],\n            validate: function(address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function(field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/model/shipping-rates-validator/tablerate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        '../shipping-rates-validation-rules/tablerate',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        var regionFields = ['region', 'region_id', 'region_id_input'];\n                        if (\n                            $.inArray(field, regionFields) === -1\n                            || utils.isEmpty(address['region']) && utils.isEmpty(address['region_id'])\n                        ) {\n                            self.validationErrors.push(message);\n                        }\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_OfflineShipping/js/view/shipping-rates-validation/flatrate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../../model/shipping-rates-validator/flatrate',\n        '../../model/shipping-rates-validation-rules/flatrate'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        flatrateShippingRatesValidator,\n        flatrateShippingRatesValidationRules\n    ) {\n        \"use strict\";\n        defaultShippingRatesValidator.registerValidator('flatrate', flatrateShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('flatrate', flatrateShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_OfflineShipping/js/view/shipping-rates-validation/freeshipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../../model/shipping-rates-validator/freeshipping',\n        '../../model/shipping-rates-validation-rules/freeshipping'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        freeshippingShippingRatesValidator,\n        freeshippingShippingRatesValidationRules\n    ) {\n        \"use strict\";\n        defaultShippingRatesValidator.registerValidator('freeshipping', freeshippingShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('freeshipping', freeshippingShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_OfflineShipping/js/view/shipping-rates-validation/tablerate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../../model/shipping-rates-validator/tablerate',\n        '../../model/shipping-rates-validation-rules/tablerate'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        tablerateShippingRatesValidator,\n        tablerateShippingRatesValidationRules\n    ) {\n        \"use strict\";\n        defaultShippingRatesValidator.registerValidator('tablerate', tablerateShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('tablerate', tablerateShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_OfflinePayments/js/view/payment/offline-payments.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n        rendererList.push(\n            {\n                type: 'checkmo',\n                component: 'Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method'\n            },\n            {\n                type: 'banktransfer',\n                component: 'Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method'\n            },\n            {\n                type: 'cashondelivery',\n                component: 'Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method'\n            },\n            {\n                type: 'purchaseorder',\n                component: 'Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method'\n            }\n        );\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);","Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko',\n        'Magento_Checkout/js/view/payment/default'\n    ],\n    function (ko, Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_OfflinePayments/payment/banktransfer'\n            },\n            /**\n             * Get value of instruction field.\n             * @returns {String}\n             */\n            getInstructions: function () {\n                return window.checkoutConfig.payment.instructions[this.item.method];\n            }\n        });\n    }\n);\n","Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default'\n    ],\n    function (Component) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_OfflinePayments/payment/cashondelivery'\n            },\n\n            /** Returns payment method instructions */\n            getInstructions: function() {\n                return window.checkoutConfig.payment.instructions[this.item.method];\n            }\n        });\n    }\n);\n","Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_OfflinePayments/payment/checkmo'\n            },\n\n            /** Returns send check to info */\n            getMailingAddress: function() {\n                return window.checkoutConfig.payment.checkmo.mailingAddress;\n            },\n\n            /** Returns payable to info */\n            getPayableTo: function() {\n                return window.checkoutConfig.payment.checkmo.payableTo;\n            }\n        });\n    }\n);\n","Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'jquery',\n        \"mage/validation\"\n    ],\n    function (Component, $) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_OfflinePayments/payment/purchaseorder-form',\n                purchaseOrderNumber: ''\n            },\n            initObservable: function () {\n                this._super()\n                    .observe('purchaseOrderNumber');\n                return this;\n            },\n            getData: function () {\n                return {\n                    \"method\": this.item.method,\n                    'po_number': this.purchaseOrderNumber(),\n                    \"additional_data\": null\n                };\n\n            },\n            validate: function () {\n                var form = 'form[data-role=purchaseorder-form]';\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","Magento_Multishipping/js/multi-shipping.js":"/**\n * @category    checkout multi-shipping addresses\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.multiShipping', {\n        options: {\n            addNewAddressBtn: 'button[data-role=\"add-new-address\"]', // Add a new multishipping address.\n            addNewAddressFlag: '#add_new_address_flag', // Hidden input field with value 0 or 1.\n            canContinueBtn: 'button[data-role=\"can-continue\"]', // Continue (update quantity or go to shipping).\n            canContinueFlag: '#can_continue_flag' // Hidden input field with value 0 or 1.\n        },\n\n        /**\n         * Bind event handlers to click events for corresponding buttons.\n         * @private\n         */\n        _create: function() {\n            $(this.options.addNewAddressBtn).on('click', $.proxy(this._addNewAddress, this));\n            $(this.options.canContinueBtn).on('click', $.proxy(this._canContinue, this));\n        },\n\n        /**\n         * Add a new address. Set the hidden input field and submit the form. Then enter a new shipping address.\n         * @private\n         */\n        _addNewAddress: function() {\n            $(this.options.addNewAddressFlag).val(1);\n            this.element.submit();\n        },\n\n        /**\n         * Can the user continue to the next step? The data-flag attribute holds either 0 (no) or 1 (yes).\n         * @private\n         * @param event {Event} - Click event on the corresponding button.\n         */\n        _canContinue: function(event) {\n            $(this.options.canContinueFlag).val(parseInt($(event.currentTarget).data('flag'), 10));\n        }\n    });\n    \n    return $.mage.multiShipping;\n});","Magento_Multishipping/js/overview.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\n/*global alert*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"mage/translate\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.orderOverview', {\n        options: {\n            opacity: 0.5, // CSS opacity for the 'Place Order' button when it's clicked and then disabled.\n            pleaseWaitLoader: 'span.please-wait', // 'Submitting order information...' Ajax loader.\n            placeOrderSubmit: 'button[type=\"submit\"]', // The 'Place Order' button.\n            agreements: '#checkout-agreements' // Container for all of the checkout agreements and terms/conditions\n        },\n\n        /**\n         * Bind a submit handler to the form.\n         * @private\n         */\n        _create: function() {\n            this.element.on('submit', $.proxy(this._showLoader, this));\n        },\n\n        /**\n         * Verify that all agreements and terms/conditions are checked. Show the Ajax loader. Disable\n         * the submit button (i.e. Place Order).\n         * @return {Boolean}\n         * @private\n         */\n        _showLoader: function() {\n            if ($(this.options.agreements).find('input[type=\"checkbox\"]:not(:checked)').length > 0) {\n                return false;\n            }\n            this.element.find(this.options.pleaseWaitLoader).show().end()\n                .find(this.options.placeOrderSubmit).prop('disabled', true).css('opacity', this.options.opacity);\n            return true;\n        }\n    });\n\n    return $.mage.orderOverview;\n});\n","Magento_Multishipping/js/payment.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global alert*/\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.payment', {\n        options: {\n            continueSelector: '#payment-continue',\n            methodsContainer: '#payment-methods',\n            minBalance: 0.0001,\n            tmpl: '<input id=\"hidden-free\" type=\"hidden\" name=\"payment[method]\" value=\"free\">'\n        },\n\n        _create: function () {\n            this.element.find('dd [name^=\"payment[\"]').prop('disabled', true).end()\n                .on('click', this.options.continueSelector, $.proxy(this._submitHandler, this))\n                .on('updateCheckoutPrice', $.proxy(function (event, data) {\n                    //updating the checkoutPrice\n                    if (data.price) {\n                        this.options.checkoutPrice += data.price;\n                    }\n\n                    //updating total price\n                    if (data.totalPrice) {\n                        data.totalPrice = this.options.checkoutPrice;\n                    }\n\n                    if (this.options.checkoutPrice < this.options.minBalance) {\n                        // Add free input field, hide and disable unchecked checkbox payment method and all radio button payment methods\n                        this._disablePaymentMethods();\n                    } else {\n                        // Remove free input field, show all payment method\n                        this._enablePaymentMethods();\n                    }\n                }, this))\n                .on('click', 'dt input:radio', $.proxy(this._paymentMethodHandler, this));\n\n            if (this.options.checkoutPrice < this.options.minBalance) {\n                this._disablePaymentMethods();\n            } else {\n                this._enablePaymentMethods();\n            }\n        },\n\n        /**\n         * Display payment details when payment method radio button is checked\n         * @private\n         * @param {EventObject} e\n         */\n        _paymentMethodHandler: function (e) {\n            var element = $(e.target),\n                parentsDl = element.closest('dl');\n\n            parentsDl.find('dt input:radio').prop('checked', false);\n            parentsDl.find('.items').hide().find('[name^=\"payment[\"]').prop('disabled', true);\n            element.prop('checked', true).parent().nextUntil('dt').find('.items').show().find('[name^=\"payment[\"]').prop('disabled', false);\n        },\n\n        /**\n         * make sure one payment method is selected\n         * @private\n         * @return {Boolean}\n         */\n        _validatePaymentMethod: function () {\n            var methods = this.element.find('[name^=\"payment[\"]'),\n                isValid = false;\n\n            if (methods.length === 0) {\n                alert({\n                    content: $.mage.__('We can\\'t complete your order because you don\\'t have a payment method set up.')\n                });\n            } else if (this.options.checkoutPrice < this.options.minBalance) {\n                isValid = true;\n            } else if (methods.filter('input:radio:checked').length) {\n                isValid = true;\n            } else {\n                alert({\n                    content: $.mage.__('Please choose a payment method.')\n                });\n            }\n\n            return isValid;\n        },\n\n        /**\n         * Disable and enable payment methods\n         * @private\n         */\n        _disablePaymentMethods: function () {\n            var tmpl = mageTemplate(this.options.tmpl, {\n                data: {}\n            });\n\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', true).end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', true).parent().hide();\n            this.element.find('[name=\"payment[method]\"][value=\"free\"]').parent('dt').remove();\n            this.element.find(this.options.methodsContainer).hide().find('[name^=\"payment[\"]').prop('disabled', true);\n\n            $(tmpl).appendTo(this.element);\n        },\n\n        /**\n         * Enable and enable payment methods\n         * @private\n         */\n        _enablePaymentMethods: function () {\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', false).end()\n                .find('input[name=\"payment[method]\"][value=\"free\"]').remove().end()\n                .find('dt input:radio:checked').trigger('click').end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', false).parent().show();\n            this.element.find(this.options.methodsContainer).show();\n        },\n\n        /**\n         * Validate  before form submit\n         * @private\n         * @param {EventObject} e\n         */\n        _submitHandler: function (e) {\n            e.preventDefault();\n\n            if (this._validatePaymentMethod()) {\n                this.element.submit();\n            }\n        }\n    });\n\n    return $.mage.payment;\n});\n","Magento_Fedex/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        'use strict';\n\n        return {\n            getRules: function () {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Fedex/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        'Magento_Fedex/js/model/shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_Fedex/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        'Magento_Fedex/js/model/shipping-rates-validator',\n        'Magento_Fedex/js/model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        fedexShippingRatesValidator,\n        fedexShippingRatesValidationRules\n    ) {\n        'use strict';\n        defaultShippingRatesValidator.registerValidator('fedex', fedexShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('fedex', fedexShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_Dhl/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        'use strict';\n\n        return {\n            getRules: function () {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Dhl/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        'Magento_Dhl/js/model/shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_Dhl/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        'Magento_Dhl/js/model/shipping-rates-validator',\n        'Magento_Dhl/js/model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        dhlShippingRatesValidator,\n        dhlShippingRatesValidationRules\n    ) {\n        'use strict';\n\n        defaultShippingRatesValidator.registerValidator('dhl', dhlShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('dhl', dhlShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_CheckoutAgreements/js/model/agreement-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'mage/validation'\n    ],\n    function ($) {\n        'use strict';\n        var checkoutConfig = window.checkoutConfig,\n            agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {};\n\n        var agreementsInputPath = '.payment-method._active div.checkout-agreements input';\n\n        return {\n            /**\n             * Validate checkout agreements\n             *\n             * @returns {boolean}\n             */\n            validate: function() {\n                if (!agreementsConfig.isEnabled) {\n                    return true;\n                }\n\n                if ($(agreementsInputPath).length == 0) {\n                    return true;\n                }\n\n                return $('#co-payment-form').validate({\n                    errorClass: 'mage-error',\n                    errorElement: 'div',\n                    meta: 'validate',\n                    errorPlacement: function (error, element) {\n                        var errorPlacement = element;\n                        if (element.is(':checkbox') || element.is(':radio')) {\n                            errorPlacement = element.siblings('label').last();\n                        }\n                        errorPlacement.after(error);\n                    }\n                }).element(agreementsInputPath);\n            }\n        }\n    }\n);\n","Magento_CheckoutAgreements/js/model/agreements-assigner.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var agreementsConfig = window.checkoutConfig.checkoutAgreements;\n\n    /** Override default place order action and add agreement_ids to request */\n    return function (paymentData) {\n        var agreementForm,\n            agreementData,\n            agreementIds;\n\n        if (!agreementsConfig.isEnabled) {\n            return;\n        }\n\n        agreementForm = $('.payment-method._active div[data-role=checkout-agreements] input');\n        agreementData = agreementForm.serializeArray();\n        agreementIds = [];\n\n        agreementData.forEach(function (item) {\n            agreementIds.push(item.value);\n        });\n\n        if (paymentData['extension_attributes'] === undefined) {\n            paymentData['extension_attributes'] = {};\n        }\n\n        paymentData['extension_attributes']['agreement_ids'] = agreementIds;\n    };\n});\n","Magento_CheckoutAgreements/js/model/agreements-modal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Ui/js/modal/modal',\n        'mage/translate'\n    ],\n    function ($, modal, $t) {\n        'use strict';\n        return {\n            modalWindow: null,\n\n            /** Create popUp window for provided element */\n            createModal: function(element) {\n                this.modalWindow = element;\n                var options = {\n                    'type': 'popup',\n                    'modalClass': 'agreements-modal',\n                    'responsive': true,\n                    'innerScroll': true,\n                    'trigger': '.show-modal',\n                    'buttons': [\n                        {\n                            text: $t('Close'),\n                            class: 'action secondary action-hide-popup',\n                            click: function() {\n                                this.closeModal();\n                            }\n                        }\n                    ]\n                };\n                modal(options, $(this.modalWindow));\n            },\n\n            /** Show login popup window */\n            showModal: function() {\n                $(this.modalWindow).modal('openModal');\n            }\n        }\n    }\n);\n","Magento_CheckoutAgreements/js/model/place-order-mixin.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override default place order action and add agreement_ids to request */\n        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) {\n            agreementsAssigner(paymentData);\n\n            return originalAction(paymentData, messageContainer);\n        });\n    };\n});\n","Magento_CheckoutAgreements/js/model/set-payment-information-mixin.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override place-order-mixin for set-payment-information action as they differs only by method signature */\n        return wrapper.wrap(placeOrderAction, function (originalAction, messageContainer, paymentData) {\n            agreementsAssigner(paymentData);\n\n            return originalAction(messageContainer, paymentData);\n        });\n    };\n});\n","Magento_CheckoutAgreements/js/view/agreement-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_CheckoutAgreements/js/model/agreement-validator'\n    ],\n    function (Component, additionalValidators, agreementValidator) {\n        'use strict';\n        additionalValidators.registerValidator(agreementValidator);\n        return Component.extend({});\n    }\n);\n","Magento_CheckoutAgreements/js/view/checkout-agreements.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko',\n        'jquery',\n        'uiComponent',\n        'Magento_CheckoutAgreements/js/model/agreements-modal'\n    ],\n    function (ko, $, Component, agreementsModal) {\n        'use strict';\n        var checkoutConfig = window.checkoutConfig,\n            agreementManualMode = 1,\n            agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {};\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_CheckoutAgreements/checkout/checkout-agreements'\n            },\n            isVisible: agreementsConfig.isEnabled,\n            agreements: agreementsConfig.agreements,\n            modalTitle: ko.observable(null),\n            modalContent: ko.observable(null),\n            modalWindow: null,\n\n            /**\n             * Checks if agreement required\n             *\n             * @param element\n             */\n            isAgreementRequired: function(element) {\n                return element.mode == agreementManualMode;\n            },\n\n            /**\n             * Show agreement content in modal\n             *\n             * @param element\n             */\n            showContent: function (element) {\n                this.modalTitle(element.checkboxText);\n                this.modalContent(element.content);\n                agreementsModal.showModal();\n            },\n\n            /**\n             * Init modal window for rendered element\n             *\n             * @param element\n             */\n            initModal: function(element) {\n                agreementsModal.createModal(element);\n            }\n        });\n    }\n);\n","Magento_Captcha/captcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.captcha', {\n        options: {\n            refreshClass: 'refreshing',\n            reloadSelector: '.captcha-reload',\n            imageSelector: '.captcha-img',\n            imageLoader: ''\n        },\n\n        /**\n         * Method binds click event to reload image\n         * @private\n         */\n        _create: function() {\n            this.element.on('click', this.options.reloadSelector, $.proxy(this.refresh, this));\n        },\n\n        /**\n         * Method triggeres an AJAX request to refresh the CAPTCHA image\n         * @param e - Event\n         */\n        refresh: function(e) {\n            var imageLoader = this.options.imageLoader;\n\n            if (imageLoader) {\n                this.element.find(this.options.imageSelector).attr('src', imageLoader);\n            }\n            this.element.addClass(this.options.refreshClass);\n\n            $.ajax({\n                url: this.options.url,\n                type: 'post',\n                async: false,\n                dataType: 'json',\n                context: this,\n                data: {\n                    'formId': this.options.type\n                },\n                success: function (response) {\n                    if (response.imgSrc) {\n                        this.element.find(this.options.imageSelector).attr('src', response.imgSrc);\n                    }\n                },\n                complete: function() {\n                    this.element.removeClass(this.options.refreshClass);\n                }\n            });\n        }\n    });\n\n    return $.mage.captcha;\n});","Magento_Captcha/onepage.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\"jquery\"], function($){\n    \"use strict\";\n    $(document).on(\"login\",function() {\n        $(\"[data-captcha='guest_checkout'], [data-captcha='register_during_checkout']\").hide();\n        $(\"[role='guest_checkout'], [role='register_during_checkout']\").hide();\n        var type = ($(\"#login\\\\:guest\").is(':checked')) ? 'guest_checkout' : 'register_during_checkout';\n        $(\"[role='\" + type + \"'], [data-captcha='\" + type + \"']\").show();\n    }).on('billingSave', function() {\n            $(\".captcha-reload:visible\").trigger(\"click\");\n        });\n});","Magento_Captcha/js/action/refresh.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global define*/\ndefine(\n    ['mage/storage'],\n    function(storage) {\n        \"use strict\";\n        return function(refreshUrl, formId, imageSource) {\n            return storage.post(\n                refreshUrl,\n                JSON.stringify({'formId': formId}),\n                false\n            ).done(\n                function (response) {\n                    if (response.imgSrc) {\n                        imageSource(response.imgSrc);\n                    }\n                }\n            );\n        };\n    }\n);\n","Magento_Captcha/js/model/captcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'ko',\n        'Magento_Captcha/js/action/refresh'\n    ],\n    function($, ko, refreshAction) {\n        return function (captchaData) {\n            return {\n                formId: captchaData.formId,\n                imageSource: ko.observable(captchaData.imageSrc),\n                visibility: ko.observable(false),\n                captchaValue: ko.observable(null),\n                isRequired: captchaData.isRequired,\n                isCaseSensitive: captchaData.isCaseSensitive,\n                imageHeight: captchaData.imageHeight,\n                refreshUrl: captchaData.refreshUrl,\n                isLoading: ko.observable(false),\n\n                getFormId: function () {\n                    return this.formId;\n                },\n                setFormId: function (formId) {\n                    this.formId = formId;\n                },\n                getIsVisible: function () {\n                    return this.visibility;\n                },\n                setIsVisible: function (flag) {\n                    this.visibility(flag);\n                },\n                getIsRequired: function () {\n                    return this.isRequired;\n                },\n                setIsRequired: function (flag) {\n                    this.isRequired = flag;\n                },\n                getIsCaseSensitive: function () {\n                    return this.isCaseSensitive;\n                },\n                setIsCaseSensitive: function (flag) {\n                    this.isCaseSensitive = flag;\n                },\n                getImageHeight: function () {\n                    return this.imageHeight;\n                },\n                setImageHeight: function (height) {\n                    this.imageHeight = height;\n                },\n                getImageSource: function () {\n                    return this.imageSource;\n                },\n                setImageSource: function (imageSource) {\n                     this.imageSource(imageSource);\n                },\n                getRefreshUrl: function () {\n                    return this.refreshUrl;\n                },\n                setRefreshUrl: function (url) {\n                    this.refreshUrl = url;\n                },\n                getCaptchaValue: function () {\n                    return this.captchaValue;\n                },\n                setCaptchaValue: function (value) {\n                    this.captchaValue(value);\n                },\n                refresh: function() {\n                    var refresh,\n                        self = this;\n                    this.isLoading(true);\n\n                    refresh = refreshAction(this.getRefreshUrl(), this.getFormId(), this.getImageSource());\n                    $.when(refresh).done(function() {\n                        self.isLoading(false);\n                    });\n                }\n            };\n        }\n    }\n);\n","Magento_Captcha/js/model/captchaList.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global define*/\ndefine(['jquery'], function($) {\n    \"use strict\";\n    var captchaList = [];\n    return {\n        add: function (captcha) {\n            captchaList.push(captcha);\n        },\n        getCaptchaByFormId: function(formId) {\n            var captcha = null;\n            $.each(captchaList, function(key, item) {\n                if (formId === item.formId) {\n                    captcha = item;\n                    return false;\n                }\n            });\n            return captcha;\n        },\n        getCaptchaList: function() {\n            return captchaList;\n        }\n    };\n});\n","Magento_Captcha/js/view/checkout/defaultCaptcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true jquery:true*/\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'uiComponent',\n        'Magento_Captcha/js/model/captcha',\n        'Magento_Captcha/js/model/captchaList'\n    ],\n    function ($, Component, Captcha, captchaList) {\n        'use strict';\n        var captchaConfig;\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Captcha/checkout/captcha'\n            },\n            dataScope: 'global',\n            currentCaptcha: null,\n            captchaValue: function() {\n                return this.currentCaptcha.getCaptchaValue();\n            },\n            initialize: function() {\n                this._super();\n                captchaConfig = window[this.configSource]['captcha'];\n\n                if (captchaConfig) {\n                    $.each(captchaConfig, function(formId, captchaData) {\n                        captchaData.formId = formId;\n                        captchaList.add(Captcha(captchaData));\n                    });\n                }\n            },\n            getIsLoading: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.isLoading : false;\n            },\n            getCurrentCaptcha: function() {\n                return this.currentCaptcha;\n            },\n            setCurrentCaptcha: function(captcha) {\n                this.currentCaptcha = captcha;\n            },\n            getFormId: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getFormId() : null;\n            },\n            getIsVisible: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getIsVisible() : false;\n            },\n            setIsVisible: function(flag) {\n                this.currentCaptcha.setIsVisible(flag);\n            },\n            isRequired: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getIsRequired() : false;\n            },\n            isCaseSensitive: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getIsCaseSensitive() : false;\n            },\n            imageHeight: function() {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getImageHeight() : null;\n            },\n            getImageSource: function () {\n                return this.currentCaptcha !== null ? this.currentCaptcha.getImageSource() : null;\n            },\n            refresh: function() {\n                this.currentCaptcha.refresh();\n            }\n        });\n    }\n);\n","Magento_Captcha/js/view/checkout/loginCaptcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true jquery:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Captcha/js/view/checkout/defaultCaptcha',\n        'Magento_Captcha/js/model/captchaList',\n        'Magento_Customer/js/action/login'\n    ],\n    function (defaultCaptcha, captchaList, loginAction) {\n        'use strict';\n        return defaultCaptcha.extend({\n            initialize: function() {\n                this._super();\n                var currentCaptcha = captchaList.getCaptchaByFormId(this.formId),\n                    self = this;\n\n                if (currentCaptcha != null) {\n                    currentCaptcha.setIsVisible(true);\n                    this.setCurrentCaptcha(currentCaptcha);\n\n                    loginAction.registerLoginCallback(function(loginData) {\n                        if (loginData.captcha_form_id && loginData.captcha_form_id == self.formId) {\n                            self.refresh();\n                        }\n                    });\n                }\n            }\n        });\n    }\n);\n","Magento_Braintree/js/validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Braintree/js/paypal/button.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'rjsResolver',\n        'uiRegistry',\n        'uiComponent',\n        'underscore',\n        'jquery',\n        'braintree',\n        'Magento_Braintree/js/paypal/form-builder',\n        'domReady!'\n    ],\n    function (\n        resolver,\n        registry,\n        Component,\n        _,\n        $,\n        braintree,\n        formBuilder\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n\n                integrationName: 'braintreePaypal.currentIntegration',\n\n                /**\n                 * {String}\n                 */\n                displayName: null,\n\n                /**\n                 * {String}\n                 */\n                clientToken: null,\n\n                /**\n                 * {Object}\n                 */\n                clientConfig: {\n\n                    /**\n                     * @param {Object} integration\n                     */\n                    onReady: function (integration) {\n                        resolver(function () {\n                            registry.set(this.integrationName, integration);\n                            $('#' + this.id).removeAttr('disabled');\n                        }, this);\n                    },\n\n                    /**\n                     * @param {Object} payload\n                     */\n                    onPaymentMethodReceived: function (payload) {\n                        $('body').trigger('processStart');\n\n                        formBuilder.build(\n                            {\n                                action: this.actionSuccess,\n                                fields: {\n                                    result: JSON.stringify(payload)\n                                }\n                            }\n                        ).submit();\n                    }\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super()\n                    .initComponent();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initComponent: function () {\n                var currentIntegration = registry.get(this.integrationName),\n                    $this = $('#' + this.id),\n                    self = this,\n                    data = {\n                        amount: $this.data('amount'),\n                        locale: $this.data('locale'),\n                        currency: $this.data('currency')\n                    },\n                    initCallback = function () {\n                        $this.attr('disabled', 'disabled');\n                        registry.remove(this.integrationName);\n                        braintree.setup(this.clientToken, 'custom', this.getClientConfig(data));\n\n                        $this.off('click')\n                            .on('click', function (event) {\n                                event.preventDefault();\n\n                                registry.get(self.integrationName, function (integration) {\n                                    integration.paypal.initAuthFlow();\n                                });\n                            });\n                    }.bind(this);\n\n                currentIntegration ?\n                    currentIntegration.teardown(initCallback) :\n                    initCallback();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            getClientConfig: function (data) {\n                this.clientConfig.paypal = {\n                    singleUse: true,\n                    amount: data.amount,\n                    currency: data.currency,\n                    locale: data.locale,\n                    enableShippingAddress: true,\n                    headless: true\n                };\n\n                if (this.displayName) {\n                    this.clientConfig.paypal.displayName = this.displayName;\n                }\n\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n\n                return this.clientConfig;\n            }\n        });\n    }\n);\n","Magento_Braintree/js/paypal/form-builder.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","Magento_Braintree/js/view/payment/3d-secure.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate'\n], function ($, braintree, quote, $t) {\n    'use strict';\n\n    return {\n        config: null,\n\n        /**\n         * Set 3d secure config\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n            this.config.thresholdAmount = parseFloat(config.thresholdAmount);\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'three_d_secure';\n        },\n\n        /**\n         * Validate Braintree payment nonce\n         * @param {Object} context\n         * @returns {Object}\n         */\n        validate: function (context) {\n            var client = braintree.getApiClient(),\n                state = $.Deferred(),\n                totalAmount = quote.totals()['base_grand_total'],\n                billingAddress = quote.billingAddress();\n\n            if (!this.isAmountAvailable(totalAmount) || !this.isCountryAvailable(billingAddress.countryId)) {\n                state.resolve();\n\n                return state.promise();\n            }\n\n            client.verify3DS({\n                amount: totalAmount,\n                creditCard: context.paymentMethodNonce\n            }, function (error, response) {\n                var liability;\n\n                if (error) {\n                    state.reject(error.message);\n\n                    return;\n                }\n\n                liability = {\n                    shifted: response.verificationDetails.liabilityShifted,\n                    shiftPossible: response.verificationDetails.liabilityShiftPossible\n                };\n\n                if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                    context.paymentMethodNonce = response.nonce;\n                    state.resolve();\n                } else {\n                    state.reject($t('Please try again with another form of payment.'));\n                }\n            });\n\n            return state.promise();\n        },\n\n        /**\n         * Check minimal amount for 3d secure activation\n         * @param {Number} amount\n         * @returns {Boolean}\n         */\n        isAmountAvailable: function (amount) {\n            amount = parseFloat(amount);\n\n            return amount >= this.config.thresholdAmount;\n        },\n\n        /**\n         * Check if current country is available for 3d secure\n         * @param {String} countryId\n         * @returns {Boolean}\n         */\n        isCountryAvailable: function (countryId) {\n            var key,\n                specificCountries = this.config.specificCountries;\n\n            // all countries are available\n            if (!specificCountries.length) {\n                return true;\n            }\n\n            for (key in specificCountries) {\n                if (countryId === specificCountries[key]) {\n                    return true;\n                }\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Braintree/js/view/payment/adapter.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'braintree',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function ($, braintree, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        apiClient: null,\n        config: {},\n        checkout: null,\n\n        /**\n         * Get Braintree api client\n         * @returns {Object}\n         */\n        getApiClient: function () {\n            if (!this.apiClient) {\n                this.apiClient = new braintree.api.Client({\n                    clientToken: this.getClientToken()\n                });\n            }\n\n            return this.apiClient;\n        },\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        setup: function () {\n            if (!this.getClientToken()) {\n                this.showError($t('Sorry, but something went wrong.'));\n            }\n\n            braintree.setup(this.getClientToken(), 'custom', this.config);\n        },\n\n        /**\n         * Get payment name\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'braintree';\n        },\n\n        /**\n         * Get client token\n         * @returns {String|*}\n         */\n        getClientToken: function () {\n\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n        }\n    };\n});\n","Magento_Braintree/js/view/payment/braintree.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        var config = window.checkoutConfig.payment,\n            braintreeType = 'braintree',\n            payPalType = 'braintree_paypal';\n\n        if (config[braintreeType].isActive) {\n            rendererList.push(\n                {\n                    type: braintreeType,\n                    component: 'Magento_Braintree/js/view/payment/method-renderer/hosted-fields'\n                }\n            );\n        }\n\n        if (config[payPalType].isActive) {\n            rendererList.push(\n                {\n                    type: payPalType,\n                    component: 'Magento_Braintree/js/view/payment/method-renderer/paypal'\n                }\n            );\n        }\n\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);\n","Magento_Braintree/js/view/payment/validator-handler.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Braintree/js/view/payment/3d-secure'\n], function ($, globalMessageList, verify3DSecure) {\n    'use strict';\n\n    return {\n        validators: [],\n\n        /**\n         * Get payment config\n         * @returns {Object}\n         */\n        getConfig: function () {\n            return window.checkoutConfig.payment;\n        },\n\n        /**\n         * Init list of validators\n         */\n        initialize: function () {\n            var config = this.getConfig();\n\n            if (config[verify3DSecure.getCode()].enabled) {\n                verify3DSecure.setConfig(config[verify3DSecure.getCode()]);\n                this.add(verify3DSecure);\n            }\n        },\n\n        /**\n         * Add new validator\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators\n         * @param {Object} context\n         * @param {Function} callback\n         */\n        validate: function (context, callback) {\n            var self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback();\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback();\n                }).fail(function (error) {\n                    self.showError(error);\n                });\n        },\n\n        /**\n         * Show error message\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n        }\n    };\n});\n","Magento_Braintree/js/view/payment/method-renderer/cc-form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Braintree/js/view/payment/adapter',\n        'mage/translate',\n        'Magento_Braintree/js/validator',\n        'Magento_Braintree/js/view/payment/validator-handler',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        quote,\n        braintree,\n        $t,\n        validator,\n        validatorManager,\n        fullScreenLoader\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                active: false,\n                braintreeClient: null,\n                braintreeDeviceData: null,\n                paymentMethodNonce: null,\n                lastBillingAddress: null,\n                validatorManager: validatorManager,\n                code: 'braintree',\n\n                /**\n                 * Additional payment data\n                 *\n                 * {Object}\n                 */\n                additionalData: {},\n\n                /**\n                 * Braintree client configuration\n                 *\n                 * {Object}\n                 */\n                clientConfig: {\n\n                    /**\n                     * Triggers on payment nonce receive\n                     * @param {Object} response\n                     */\n                    onPaymentMethodReceived: function (response) {\n                        this.beforePlaceOrder(response);\n                    },\n\n                    /**\n                     * Device data initialization\n                     *\n                     * @param {Object} checkout\n                     */\n                    onReady: function (checkout) {\n                        braintree.checkout = checkout;\n                    },\n\n                    /**\n                     * Triggers on any Braintree error\n                     * @param {Object} response\n                     */\n                    onError: function (response) {\n                        braintree.showError($t('Payment ' + this.getTitle() + ' can\\'t be initialized'));\n                        throw response.message;\n                    },\n\n                    /**\n                     * Triggers when customer click \"Cancel\"\n                     */\n                    onCancelled: function () {\n                        this.paymentMethodNonce = null;\n                    }\n                },\n                imports: {\n                    onActiveChange: 'active'\n                }\n            },\n\n            /**\n             * Set list of observable attributes\n             *\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                validator.setConfig(window.checkoutConfig.payment[this.getCode()]);\n                this._super()\n                    .observe(['active']);\n                this.validatorManager.initialize();\n                this.initClientConfig();\n\n                return this;\n            },\n\n            /**\n             * Get payment name\n             *\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Check if payment is active\n             *\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                var active = this.getCode() === this.isChecked();\n\n                this.active(active);\n\n                return active;\n            },\n\n            /**\n             * Triggers when payment method change\n             * @param {Boolean} isActive\n             */\n            onActiveChange: function (isActive) {\n                if (!isActive) {\n                    return;\n                }\n\n                this.initBraintree();\n            },\n\n            /**\n             * Init config\n             */\n            initClientConfig: function () {\n                // Advanced fraud tools settings\n                if (this.hasFraudProtection()) {\n                    this.clientConfig = _.extend(this.clientConfig, this.kountConfig());\n                }\n\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n            },\n\n            /**\n             * Init Braintree configuration\n             */\n            initBraintree: function () {\n                var intervalId = setInterval(function () {\n                    // stop loader when frame will be loaded\n                    if ($('#braintree-hosted-field-number').length) {\n                        clearInterval(intervalId);\n                        fullScreenLoader.stopLoader();\n                    }\n                }, 500);\n\n                if (braintree.checkout) {\n                    braintree.checkout.teardown(function () {\n                        braintree.checkout = null;\n                    });\n                }\n\n                fullScreenLoader.startLoader();\n                braintree.setConfig(this.clientConfig);\n                braintree.setup();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            kountConfig: function () {\n                var config = {\n                    dataCollector: {\n                        kount: {\n                            environment: this.getEnvironment()\n                        }\n                    },\n\n                    /**\n                     * Device data initialization\n                     *\n                     * @param {Object} checkout\n                     */\n                    onReady: function (checkout) {\n                        braintree.checkout = checkout;\n                        this.additionalData['device_data'] = checkout.deviceData;\n                    }\n                };\n\n                if (this.getKountMerchantId()) {\n                    config.dataCollector.kount.merchantId = this.getKountMerchantId();\n                }\n\n                return config;\n            },\n\n            /**\n             * Get full selector name\n             *\n             * @param {String} field\n             * @returns {String}\n             */\n            getSelector: function (field) {\n                return '#' + this.getCode() + '_' + field;\n            },\n\n            /**\n             * Get list of available CC types\n             *\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                var availableTypes = validator.getAvailableCardTypes(),\n                    billingAddress = quote.billingAddress(),\n                    billingCountryId;\n\n                this.lastBillingAddress = quote.shippingAddress();\n\n                if (!billingAddress) {\n                    billingAddress = this.lastBillingAddress;\n                }\n\n                billingCountryId = billingAddress.countryId;\n\n                if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n\n                    return validator.collectTypes(\n                        availableTypes, validator.getCountrySpecificCardTypes(billingCountryId)\n                    );\n                }\n\n                return availableTypes;\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            hasFraudProtection: function () {\n                return window.checkoutConfig.payment[this.getCode()].hasFraudProtection;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getEnvironment: function () {\n                return window.checkoutConfig.payment[this.getCode()].environment;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getKountMerchantId: function () {\n                return window.checkoutConfig.payment[this.getCode()].kountMerchantId;\n            },\n\n            /**\n             * Get data\n             *\n             * @returns {Object}\n             */\n            getData: function () {\n                var data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            /**\n             * Set payment nonce\n             * @param {String} paymentMethodNonce\n             */\n            setPaymentMethodNonce: function (paymentMethodNonce) {\n                this.paymentMethodNonce = paymentMethodNonce;\n            },\n\n            /**\n             * Prepare data to place order\n             * @param {Object} data\n             */\n            beforePlaceOrder: function (data) {\n                this.setPaymentMethodNonce(data.nonce);\n                this.placeOrder();\n            },\n\n            /**\n             * Action to place order\n             * @param {String} key\n             */\n            placeOrder: function (key) {\n                var self = this;\n\n                if (key) {\n                    return self._super();\n                }\n                // place order on success validation\n                self.validatorManager.validate(self, function () {\n                    return self.placeOrder('parent');\n                });\n\n                return false;\n            }\n        });\n    }\n);\n","Magento_Braintree/js/view/payment/method-renderer/hosted-fields.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Braintree/js/view/payment/method-renderer/cc-form',\n    'Magento_Braintree/js/validator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'mage/translate'\n], function ($, Component, validator, VaultEnabler, $t) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'Magento_Braintree/payment/form',\n            clientConfig: {\n\n                /**\n                 * {String}\n                 */\n                id: 'co-transparent-form-braintree'\n            },\n            isValidCardNumber: false\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this._super();\n\n            // Hosted fields settings\n            this.clientConfig.hostedFields = this.getHostedFields();\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = this._super();\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * Get Braintree Hosted Fields\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number')\n                    },\n                    expirationMonth: {\n                        selector: self.getSelector('expirationMonth'),\n                        placeholder: $t('MM')\n                    },\n                    expirationYear: {\n                        selector: self.getSelector('expirationYear'),\n                        placeholder: $t('YY')\n                    }\n                };\n\n            if (self.hasVerification()) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid')\n                };\n            }\n\n            /**\n             * Triggers on Hosted Field changes\n             * @param {Object} event\n             * @returns {Boolean}\n             */\n            fields.onFieldEvent = function (event) {\n                if (event.isEmpty === false) {\n                    self.validateCardType();\n                }\n\n                if (event.type !== 'fieldStateChange') {\n\n                    return false;\n                }\n\n                // Handle a change in validation or card type\n                if (event.target.fieldKey === 'number') {\n                    self.selectedCardType(null);\n                }\n\n                if (event.target.fieldKey === 'number' && event.card) {\n                    self.isValidCardNumber = event.isValid;\n                    self.selectedCardType(\n                        validator.getMageCardType(event.card.type, self.getCcAvailableTypes())\n                    );\n                }\n            };\n\n            return fields;\n        },\n\n        /**\n         * Validate current credit card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            var $selector = $(this.getSelector('cc_number')),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            $selector.removeClass(invalidClass);\n\n            if (this.selectedCardType() === null || !this.isValidCardNumber) {\n                $(this.getSelector('cc_number')).addClass(invalidClass);\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Trigger order placing\n         */\n        placeOrderClick: function () {\n            if (this.validateCardType()) {\n                $(this.getSelector('submit')).trigger('click');\n            }\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].ccVaultCode;\n        }\n    });\n});\n","Magento_Braintree/js/view/payment/method-renderer/paypal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/model/payment/additional-validators'\n], function ($, _, Component, Braintree, quote, fullScreenLoader, additionalValidators) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Braintree/payment/paypal',\n            code: 'braintree_paypal',\n            active: false,\n            paymentMethodNonce: null,\n            grandTotalAmount: null,\n\n            /**\n             * PayPal client configuration\n             * {Object}\n             */\n            clientConfig: {\n\n                /**\n                 * Triggers when widget is loaded\n                 * @param {Object} checkout\n                 */\n                onReady: function (checkout) {\n                    Braintree.checkout = checkout;\n                    this.enableButton();\n                },\n\n                /**\n                 * Triggers on payment nonce receive\n                 * @param {Object} response\n                 */\n                onPaymentMethodReceived: function (response) {\n                    this.beforePlaceOrder(response);\n                }\n            },\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super()\n                .observe(['active']);\n\n            this.grandTotalAmount = quote.totals()['base_grand_total'];\n\n            quote.totals.subscribe(function () {\n                if (self.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    self.grandTotalAmount = quote.totals()['base_grand_total'];\n                    self.reInitPayPal();\n                }\n            });\n\n            this.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Get payment name\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get payment title\n         *\n         * @returns {String}\n         */\n        getTitle: function () {\n            return window.checkoutConfig.payment[this.getCode()].title;\n        },\n\n        /**\n         * Check if payment is active\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            var active = this.getCode() === this.isChecked();\n\n            this.active(active);\n\n            return active;\n        },\n\n        /**\n         * Triggers when payment method change\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                return;\n            }\n\n            // need always re-init Braintree with PayPal configuration\n            this.reInitPayPal();\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n\n            Braintree.config = _.extend(Braintree.config, this.clientConfig);\n        },\n\n        /**\n         * Set payment nonce\n         * @param {String} paymentMethodNonce\n         */\n        setPaymentMethodNonce: function (paymentMethodNonce) {\n            this.paymentMethodNonce = paymentMethodNonce;\n        },\n\n        /**\n         * Update quote billing address\n         * @param {Object}customer\n         * @param {Object}address\n         */\n        setBillingAddress: function (customer, address) {\n            var billingAddress = {\n                street: [address.streetAddress],\n                city: address.locality,\n                regionCode: address.region,\n                postcode: address.postalCode,\n                countryId: address.countryCodeAlpha2,\n                firstname: customer.firstName,\n                lastname: customer.lastName,\n                telephone: customer.phone\n            };\n\n            quote.billingAddress(billingAddress);\n        },\n\n        /**\n         * Prepare data to place order\n         * @param {Object} data\n         */\n        beforePlaceOrder: function (data) {\n            this.setPaymentMethodNonce(data.nonce);\n\n            if (quote.billingAddress() === null && typeof data.details.billingAddress !== 'undefined') {\n                this.setBillingAddress(data.details, data.details.billingAddress);\n            }\n            this.placeOrder();\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            if (Braintree.checkout) {\n                Braintree.checkout.teardown(function () {\n                    Braintree.checkout = null;\n                });\n            }\n\n            this.disableButton();\n            this.clientConfig.paypal.amount = this.grandTotalAmount;\n\n            Braintree.setConfig(this.clientConfig);\n            Braintree.setup();\n        },\n\n        /**\n         * Triggers when customer click \"Continue to PayPal\" button\n         */\n        payWithPayPal: function () {\n            if (additionalValidators.validate()) {\n                Braintree.checkout.paypal.initAuthFlow();\n            }\n        },\n\n        /**\n         * Get locale\n         * @returns {String}\n         */\n        getLocale: function () {\n            return window.checkoutConfig.payment[this.getCode()].locale;\n        },\n\n        /**\n         * Is shipping address can be editable on PayPal side\n         * @returns {Boolean}\n         */\n        isAllowOverrideShippingAddress: function () {\n            return window.checkoutConfig.payment[this.getCode()].isAllowShippingAddressOverride;\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {};\n\n            config.paypal = {\n                container: 'paypal-container',\n                singleUse: true,\n                headless: true,\n                amount: this.grandTotalAmount,\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n                enableShippingAddress: true,\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            config.paypal.shippingAddressOverride = this.getShippingAddress();\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Get shipping address\n         * @returns {Object}\n         */\n        getShippingAddress: function () {\n            var address = quote.shippingAddress();\n\n            if (address.postcode === null) {\n\n                return {};\n            }\n\n            return {\n                recipientName: address.firstname + ' ' + address.lastname,\n                streetAddress: address.street[0],\n                locality: address.city,\n                countryCodeAlpha2: address.countryId,\n                postalCode: address.postcode,\n                region: address.regionCode,\n                phone: address.telephone,\n                editable: this.isAllowOverrideShippingAddress()\n            };\n        },\n\n        /**\n         * Get merchant name\n         * @returns {String}\n         */\n        getMerchantName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n        },\n\n        /**\n         * Returns payment acceptance mark image path\n         * @returns {String}\n         */\n        getPaymentAcceptanceMarkSrc: function () {\n\n            return window.checkoutConfig.payment[this.getCode()].paymentAcceptanceMarkSrc;\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader();\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader();\n        }\n    });\n});\n","Magento_Braintree/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'Magento_Braintree/js/view/payment/method-renderer/cc-form',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, Component, VaultComponent, globalMessageList, fullScreenLoader) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Vault/payment/form',\n            modules: {\n                hostedFields: '${ $.parentName }.braintree'\n            }\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.get(self.nonceUrl, {\n                'public_hash': self.publicHash\n            })\n                .done(function (response) {\n                    fullScreenLoader.stopLoader();\n                    self.hostedFields(function (formComponent) {\n                        formComponent.setPaymentMethodNonce(response.paymentMethodNonce);\n                        formComponent.additionalData['public_hash'] = self.publicHash;\n                        formComponent.code = self.code;\n                        formComponent.placeOrder();\n                    });\n                })\n                .fail(function (response) {\n                    var error = JSON.parse(response.responseText);\n\n                    fullScreenLoader.stopLoader();\n                    globalMessageList.addErrorMessage({\n                        message: error.message\n                    });\n                });\n        }\n    });\n});\n","Magento_Authorizenet/js/view/payment/authorizenet.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n        rendererList.push(\n            {\n                type: 'authorizenet_directpost',\n                component: 'Magento_Authorizenet/js/view/payment/method-renderer/authorizenet-directpost'\n            }\n        );\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);","Magento_Authorizenet/js/view/payment/method-renderer/authorizenet-directpost.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Payment/js/view/payment/iframe'\n    ],\n    function ($, Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Authorizenet/payment/authorizenet-directpost',\n                timeoutMessage: 'Sorry, but something went wrong. Please contact the seller.'\n            },\n            placeOrderHandler: null,\n            validateHandler: null,\n\n            /**\n             * @param {Object} handler\n             */\n            setPlaceOrderHandler: function (handler) {\n                this.placeOrderHandler = handler;\n            },\n\n            /**\n             * @param {Object} handler\n             */\n            setValidateHandler: function (handler) {\n                this.validateHandler = handler;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            context: function () {\n                return this;\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isShowLegend: function () {\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return 'authorizenet_directpost';\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                return true;\n            }\n        });\n    }\n);\n","Plazathemes_Bannerslider/js/owl.carousel.js":"/**\n * Copyright \u00c2\u00a9 2015 PlazaThemes.com. All rights reserved.\n *\n * @author PlazaThemes Team <contact@plazathemes.com>\n */\n\n/*\n *  jQuery OwlCarousel v1.3.3\n *\n *  Copyright (c) 2013 Bartosz Wojciechowski\n *  http://www.owlgraphic.com/owlcarousel/\n *\n *  Licensed under MIT\n *\n */\n\n/*JS Lint helpers: */\n/*global dragMove: false, dragEnd: false, $, jQuery, alert, window, document */\n/*jslint nomen: true, continue:true */\nif (typeof Object.create !== \"function\") {\n    Object.create = function (obj) {\n        function F() {}\n        F.prototype = obj;\n        return new F();\n    };\n}\nrequire([\n\t\"jquery\"\n], function($){\n\t(function ($, window, document) {\n\t\tvar Carousel = {\n\t\t\tinit : function (options, el) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.$elem = $(el);\n\t\t\t\tbase.options = $.extend({}, $.fn.owlCarousel.options, base.$elem.data(), options);\n\n\t\t\t\tbase.userOptions = options;\n\t\t\t\tbase.loadContent();\n\t\t\t},\n\n\t\t\tloadContent : function () {\n\t\t\t\tvar base = this, url;\n\n\t\t\t\tfunction getData(data) {\n\t\t\t\t\tvar i, content = \"\";\n\t\t\t\t\tif (typeof base.options.jsonSuccess === \"function\") {\n\t\t\t\t\t\tbase.options.jsonSuccess.apply(this, [data]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfor (i in data.owl) {\n\t\t\t\t\t\t\tif (data.owl.hasOwnProperty(i)) {\n\t\t\t\t\t\t\t\tcontent += data.owl[i].item;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbase.$elem.html(content);\n\t\t\t\t\t}\n\t\t\t\t\tbase.logIn();\n\t\t\t\t}\n\n\t\t\t\tif (typeof base.options.beforeInit === \"function\") {\n\t\t\t\t\tbase.options.beforeInit.apply(this, [base.$elem]);\n\t\t\t\t}\n\n\t\t\t\tif (typeof base.options.jsonPath === \"string\") {\n\t\t\t\t\turl = base.options.jsonPath;\n\t\t\t\t\t$.getJSON(url, getData);\n\t\t\t\t} else {\n\t\t\t\t\tbase.logIn();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlogIn : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.$elem.data(\"owl-originalStyles\", base.$elem.attr(\"style\"));\n\t\t\t\tbase.$elem.data(\"owl-originalClasses\", base.$elem.attr(\"class\"));\n\n\t\t\t\tbase.$elem.css({opacity: 0});\n\t\t\t\tbase.orignalItems = base.options.items;\n\t\t\t\tbase.checkBrowser();\n\t\t\t\tbase.wrapperWidth = 0;\n\t\t\t\tbase.checkVisible = null;\n\t\t\t\tbase.setVars();\n\t\t\t},\n\n\t\t\tsetVars : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.$elem.children().length === 0) {return false; }\n\t\t\t\tbase.baseClass();\n\t\t\t\tbase.eventTypes();\n\t\t\t\tbase.$userItems = base.$elem.children();\n\t\t\t\tbase.itemsAmount = base.$userItems.length;\n\t\t\t\tbase.wrapItems();\n\t\t\t\tbase.$owlItems = base.$elem.find(\".owl-item\");\n\t\t\t\tbase.$owlWrapper = base.$elem.find(\".owl-wrapper\");\n\t\t\t\tbase.playDirection = \"next\";\n\t\t\t\tbase.prevItem = 0;\n\t\t\t\tbase.prevArr = [0];\n\t\t\t\tbase.currentItem = 0;\n\t\t\t\tbase.customEvents();\n\t\t\t\tbase.onStartup();\n\t\t\t},\n\n\t\t\tonStartup : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.updateItems();\n\t\t\t\tbase.calculateAll();\n\t\t\t\tbase.buildControls();\n\t\t\t\tbase.updateControls();\n\t\t\t\tbase.response();\n\t\t\t\tbase.moveEvents();\n\t\t\t\tbase.stopOnHover();\n\t\t\t\tbase.owlStatus();\n\n\t\t\t\tif (base.options.transitionStyle !== false) {\n\t\t\t\t\tbase.transitionTypes(base.options.transitionStyle);\n\t\t\t\t}\n\t\t\t\tif (base.options.autoPlay === true) {\n\t\t\t\t\tbase.options.autoPlay = 5000;\n\t\t\t\t}\n\t\t\t\tbase.play();\n\n\t\t\t\tbase.$elem.find(\".owl-wrapper\").css(\"display\", \"block\");\n\n\t\t\t\tif (!base.$elem.is(\":visible\")) {\n\t\t\t\t\tbase.watchVisibility();\n\t\t\t\t} else {\n\t\t\t\t\tbase.$elem.css(\"opacity\", 1);\n\t\t\t\t}\n\t\t\t\tbase.onstartup = false;\n\t\t\t\tbase.eachMoveUpdate();\n\t\t\t\tif (typeof base.options.afterInit === \"function\") {\n\t\t\t\t\tbase.options.afterInit.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\teachMoveUpdate : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.options.lazyLoad === true) {\n\t\t\t\t\tbase.lazyLoad();\n\t\t\t\t}\n\t\t\t\tif (base.options.autoHeight === true) {\n\t\t\t\t\tbase.autoHeight();\n\t\t\t\t}\n\t\t\t\tbase.onVisibleItems();\n\n\t\t\t\tif (typeof base.options.afterAction === \"function\") {\n\t\t\t\t\tbase.options.afterAction.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateVars : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (typeof base.options.beforeUpdate === \"function\") {\n\t\t\t\t\tbase.options.beforeUpdate.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tbase.watchVisibility();\n\t\t\t\tbase.updateItems();\n\t\t\t\tbase.calculateAll();\n\t\t\t\tbase.updatePosition();\n\t\t\t\tbase.updateControls();\n\t\t\t\tbase.eachMoveUpdate();\n\t\t\t\tif (typeof base.options.afterUpdate === \"function\") {\n\t\t\t\t\tbase.options.afterUpdate.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\treload : function () {\n\t\t\t\tvar base = this;\n\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\tbase.updateVars();\n\t\t\t\t}, 0);\n\t\t\t},\n\n\t\t\twatchVisibility : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.$elem.is(\":visible\") === false) {\n\t\t\t\t\tbase.$elem.css({opacity: 0});\n\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\t} else {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.checkVisible = window.setInterval(function () {\n\t\t\t\t\tif (base.$elem.is(\":visible\")) {\n\t\t\t\t\t\tbase.reload();\n\t\t\t\t\t\tbase.$elem.animate({opacity: 1}, 200);\n\t\t\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\t\t}\n\t\t\t\t}, 500);\n\t\t\t},\n\n\t\t\twrapItems : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$userItems.wrapAll(\"<div class=\\\"owl-wrapper\\\">\").wrap(\"<div class=\\\"owl-item\\\"></div>\");\n\t\t\t\tbase.$elem.find(\".owl-wrapper\").wrap(\"<div class=\\\"owl-wrapper-outer\\\">\");\n\t\t\t\tbase.wrapperOuter = base.$elem.find(\".owl-wrapper-outer\");\n\t\t\t\tbase.$elem.css(\"display\", \"block\");\n\t\t\t},\n\n\t\t\tbaseClass : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\thasBaseClass = base.$elem.hasClass(base.options.baseClass),\n\t\t\t\t\thasThemeClass = base.$elem.hasClass(base.options.theme);\n\n\t\t\t\tif (!hasBaseClass) {\n\t\t\t\t\tbase.$elem.addClass(base.options.baseClass);\n\t\t\t\t}\n\n\t\t\t\tif (!hasThemeClass) {\n\t\t\t\t\tbase.$elem.addClass(base.options.theme);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateItems : function () {\n\t\t\t\tvar base = this, width, i;\n\n\t\t\t\tif (base.options.responsive === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (base.options.singleItem === true) {\n\t\t\t\t\tbase.options.items = base.orignalItems = 1;\n\t\t\t\t\tbase.options.itemsCustom = false;\n\t\t\t\t\tbase.options.itemsDesktop = false;\n\t\t\t\t\tbase.options.itemsDesktopSmall = false;\n\t\t\t\t\tbase.options.itemsTablet = false;\n\t\t\t\t\tbase.options.itemsTabletSmall = false;\n\t\t\t\t\tbase.options.itemsMobile = false;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\twidth = $(base.options.responsiveBaseWidth).width();\n\n\t\t\t\tif (width > (base.options.itemsDesktop[0] || base.orignalItems)) {\n\t\t\t\t\tbase.options.items = base.orignalItems;\n\t\t\t\t}\n\t\t\t\tif (base.options.itemsCustom !== false) {\n\t\t\t\t\t//Reorder array by screen size\n\t\t\t\t\tbase.options.itemsCustom.sort(function (a, b) {return a[0] - b[0]; });\n\n\t\t\t\t\tfor (i = 0; i < base.options.itemsCustom.length; i += 1) {\n\t\t\t\t\t\tif (base.options.itemsCustom[i][0] <= width) {\n\t\t\t\t\t\t\tbase.options.items = base.options.itemsCustom[i][1];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\tif (width <= base.options.itemsDesktop[0] && base.options.itemsDesktop !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsDesktop[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsDesktopSmall[0] && base.options.itemsDesktopSmall !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsDesktopSmall[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsTablet[0] && base.options.itemsTablet !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsTablet[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsTabletSmall[0] && base.options.itemsTabletSmall !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsTabletSmall[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsMobile[0] && base.options.itemsMobile !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsMobile[1];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t//if number of items is less than declared\n\t\t\t\tif (base.options.items > base.itemsAmount && base.options.itemsScaleUp === true) {\n\t\t\t\t\tbase.options.items = base.itemsAmount;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tresponse : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tsmallDelay,\n\t\t\t\t\tlastWindowWidth;\n\n\t\t\t\tif (base.options.responsive !== true) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tlastWindowWidth = $(window).width();\n\n\t\t\t\tbase.resizer = function () {\n\t\t\t\t\tif ($(window).width() !== lastWindowWidth) {\n\t\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\t\t}\n\t\t\t\t\t\twindow.clearTimeout(smallDelay);\n\t\t\t\t\t\tsmallDelay = window.setTimeout(function () {\n\t\t\t\t\t\t\tlastWindowWidth = $(window).width();\n\t\t\t\t\t\t\tbase.updateVars();\n\t\t\t\t\t\t}, base.options.responsiveRefreshRate);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t\t$(window).resize(base.resizer);\n\t\t\t},\n\n\t\t\tupdatePosition : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.jumpTo(base.currentItem);\n\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\tbase.checkAp();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tappendItemsSizes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\troundPages = 0,\n\t\t\t\t\tlastItem = base.itemsAmount - base.options.items;\n\n\t\t\t\tbase.$owlItems.each(function (index) {\n\t\t\t\t\tvar $this = $(this);\n\t\t\t\t\t$this\n\t\t\t\t\t\t.css({\"width\": base.itemWidth})\n\t\t\t\t\t\t.data(\"owl-item\", Number(index));\n\n\t\t\t\t\tif (index % base.options.items === 0 || index === lastItem) {\n\t\t\t\t\t\tif (!(index > lastItem)) {\n\t\t\t\t\t\t\troundPages += 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\t$this.data(\"owl-roundPages\", roundPages);\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tappendWrapperSizes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\twidth = base.$owlItems.length * base.itemWidth;\n\n\t\t\t\tbase.$owlWrapper.css({\n\t\t\t\t\t\"width\": width * 2,\n\t\t\t\t\t\"left\": 0\n\t\t\t\t});\n\t\t\t\tbase.appendItemsSizes();\n\t\t\t},\n\n\t\t\tcalculateAll : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.calculateWidth();\n\t\t\t\tbase.appendWrapperSizes();\n\t\t\t\tbase.loops();\n\t\t\t\tbase.max();\n\t\t\t},\n\n\t\t\tcalculateWidth : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.itemWidth = Math.round(base.$elem.width() / base.options.items);\n\t\t\t},\n\n\t\t\tmax : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tmaximum = ((base.itemsAmount * base.itemWidth) - base.options.items * base.itemWidth) * -1;\n\t\t\t\tif (base.options.items > base.itemsAmount) {\n\t\t\t\t\tbase.maximumItem = 0;\n\t\t\t\t\tmaximum = 0;\n\t\t\t\t\tbase.maximumPixels = 0;\n\t\t\t\t} else {\n\t\t\t\t\tbase.maximumItem = base.itemsAmount - base.options.items;\n\t\t\t\t\tbase.maximumPixels = maximum;\n\t\t\t\t}\n\t\t\t\treturn maximum;\n\t\t\t},\n\n\t\t\tmin : function () {\n\t\t\t\treturn 0;\n\t\t\t},\n\n\t\t\tloops : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tprev = 0,\n\t\t\t\t\telWidth = 0,\n\t\t\t\t\ti,\n\t\t\t\t\titem,\n\t\t\t\t\troundPageNum;\n\n\t\t\t\tbase.positionsInArray = [0];\n\t\t\t\tbase.pagesInArray = [];\n\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\telWidth += base.itemWidth;\n\t\t\t\t\tbase.positionsInArray.push(-elWidth);\n\n\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\titem = $(base.$owlItems[i]);\n\t\t\t\t\t\troundPageNum = item.data(\"owl-roundPages\");\n\t\t\t\t\t\tif (roundPageNum !== prev) {\n\t\t\t\t\t\t\tbase.pagesInArray[prev] = base.positionsInArray[i];\n\t\t\t\t\t\t\tprev = roundPageNum;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbuildControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.navigation === true || base.options.pagination === true) {\n\t\t\t\t\tbase.owlControls = $(\"<div class=\\\"owl-controls\\\"/>\").toggleClass(\"clickable\", !base.browser.isTouch).appendTo(base.$elem);\n\t\t\t\t}\n\t\t\t\tif (base.options.pagination === true) {\n\t\t\t\t\tbase.buildPagination();\n\t\t\t\t}\n\t\t\t\tif (base.options.navigation === true) {\n\t\t\t\t\tbase.buildButtons();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbuildButtons : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tbuttonsWrapper = $(\"<div class=\\\"owl-buttons\\\"/>\");\n\t\t\t\tbase.owlControls.append(buttonsWrapper);\n\n\t\t\t\tbase.buttonPrev = $(\"<div/>\", {\n\t\t\t\t\t\"class\" : \"owl-prev\",\n\t\t\t\t\t\"html\" : base.options.navigationText[0] || \"\"\n\t\t\t\t});\n\n\t\t\t\tbase.buttonNext = $(\"<div/>\", {\n\t\t\t\t\t\"class\" : \"owl-next\",\n\t\t\t\t\t\"html\" : base.options.navigationText[1] || \"\"\n\t\t\t\t});\n\n\t\t\t\tbuttonsWrapper\n\t\t\t\t\t.append(base.buttonPrev)\n\t\t\t\t\t.append(base.buttonNext);\n\n\t\t\t\tbuttonsWrapper.on(\"touchstart.owlControls mousedown.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t});\n\n\t\t\t\tbuttonsWrapper.on(\"touchend.owlControls mouseup.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif ($(this).hasClass(\"owl-next\")) {\n\t\t\t\t\t\tbase.next();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.prev();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tbuildPagination : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.paginationWrapper = $(\"<div class=\\\"owl-pagination\\\"/>\");\n\t\t\t\tbase.owlControls.append(base.paginationWrapper);\n\n\t\t\t\tbase.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\", \".owl-page\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif (Number($(this).data(\"owl-page\")) !== base.currentItem) {\n\t\t\t\t\t\tbase.goTo(Number($(this).data(\"owl-page\")), true);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tupdatePagination : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tcounter,\n\t\t\t\t\tlastPage,\n\t\t\t\t\tlastItem,\n\t\t\t\t\ti,\n\t\t\t\t\tpaginationButton,\n\t\t\t\t\tpaginationButtonInner;\n\n\t\t\t\tif (base.options.pagination === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tbase.paginationWrapper.html(\"\");\n\n\t\t\t\tcounter = 0;\n\t\t\t\tlastPage = base.itemsAmount - base.itemsAmount % base.options.items;\n\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\tif (i % base.options.items === 0) {\n\t\t\t\t\t\tcounter += 1;\n\t\t\t\t\t\tif (lastPage === i) {\n\t\t\t\t\t\t\tlastItem = base.itemsAmount - base.options.items;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tpaginationButton = $(\"<div/>\", {\n\t\t\t\t\t\t\t\"class\" : \"owl-page\"\n\t\t\t\t\t\t});\n\t\t\t\t\t\tpaginationButtonInner = $(\"<span></span>\", {\n\t\t\t\t\t\t\t\"text\": base.options.paginationNumbers === true ? counter : \"\",\n\t\t\t\t\t\t\t\"class\": base.options.paginationNumbers === true ? \"owl-numbers\" : \"\"\n\t\t\t\t\t\t});\n\t\t\t\t\t\tpaginationButton.append(paginationButtonInner);\n\n\t\t\t\t\t\tpaginationButton.data(\"owl-page\", lastPage === i ? lastItem : i);\n\t\t\t\t\t\tpaginationButton.data(\"owl-roundPages\", counter);\n\n\t\t\t\t\t\tbase.paginationWrapper.append(paginationButton);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.checkPagination();\n\t\t\t},\n\t\t\tcheckPagination : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.pagination === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.paginationWrapper.find(\".owl-page\").each(function () {\n\t\t\t\t\tif ($(this).data(\"owl-roundPages\") === $(base.$owlItems[base.currentItem]).data(\"owl-roundPages\")) {\n\t\t\t\t\t\tbase.paginationWrapper\n\t\t\t\t\t\t\t.find(\".owl-page\")\n\t\t\t\t\t\t\t.removeClass(\"active\");\n\t\t\t\t\t\t$(this).addClass(\"active\");\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tcheckNavigation : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.options.navigation === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (base.options.rewindNav === false) {\n\t\t\t\t\tif (base.currentItem === 0 && base.maximumItem === 0) {\n\t\t\t\t\t\tbase.buttonPrev.addClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.addClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem === 0 && base.maximumItem !== 0) {\n\t\t\t\t\t\tbase.buttonPrev.addClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.removeClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem === base.maximumItem) {\n\t\t\t\t\t\tbase.buttonPrev.removeClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.addClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem !== 0 && base.currentItem !== base.maximumItem) {\n\t\t\t\t\t\tbase.buttonPrev.removeClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.removeClass(\"disabled\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.updatePagination();\n\t\t\t\tbase.checkNavigation();\n\t\t\t\tif (base.owlControls) {\n\t\t\t\t\tif (base.options.items >= base.itemsAmount) {\n\t\t\t\t\t\tbase.owlControls.hide();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.owlControls.show();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tdestroyControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.owlControls) {\n\t\t\t\t\tbase.owlControls.remove();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tnext : function (speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tbase.currentItem += base.options.scrollPerPage === true ? base.options.items : 1;\n\t\t\t\tif (base.currentItem > base.maximumItem + (base.options.scrollPerPage === true ? (base.options.items - 1) : 0)) {\n\t\t\t\t\tif (base.options.rewindNav === true) {\n\t\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t\t\tspeed = \"rewind\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.goTo(base.currentItem, speed);\n\t\t\t},\n\n\t\t\tprev : function (speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tif (base.options.scrollPerPage === true && base.currentItem > 0 && base.currentItem < base.options.items) {\n\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t} else {\n\t\t\t\t\tbase.currentItem -= base.options.scrollPerPage === true ? base.options.items : 1;\n\t\t\t\t}\n\t\t\t\tif (base.currentItem < 0) {\n\t\t\t\t\tif (base.options.rewindNav === true) {\n\t\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\t\tspeed = \"rewind\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.goTo(base.currentItem, speed);\n\t\t\t},\n\n\t\t\tgoTo : function (position, speed, drag) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tgoToPixel;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (typeof base.options.beforeMove === \"function\") {\n\t\t\t\t\tbase.options.beforeMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tif (position >= base.maximumItem) {\n\t\t\t\t\tposition = base.maximumItem;\n\t\t\t\t} else if (position <= 0) {\n\t\t\t\t\tposition = 0;\n\t\t\t\t}\n\n\t\t\t\tbase.currentItem = base.owl.currentItem = position;\n\t\t\t\tif (base.options.transitionStyle !== false && drag !== \"drag\" && base.options.items === 1 && base.browser.support3d === true) {\n\t\t\t\t\tbase.swapSpeed(0);\n\t\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\t\tbase.transition3d(base.positionsInArray[position]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2slide(base.positionsInArray[position], 1);\n\t\t\t\t\t}\n\t\t\t\t\tbase.afterGo();\n\t\t\t\t\tbase.singleItemTransition();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tgoToPixel = base.positionsInArray[position];\n\n\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\tbase.isCss3Finish = false;\n\n\t\t\t\t\tif (speed === true) {\n\t\t\t\t\t\tbase.swapSpeed(\"paginationSpeed\");\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.paginationSpeed);\n\n\t\t\t\t\t} else if (speed === \"rewind\") {\n\t\t\t\t\t\tbase.swapSpeed(base.options.rewindSpeed);\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.rewindSpeed);\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.swapSpeed(\"slideSpeed\");\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.slideSpeed);\n\t\t\t\t\t}\n\t\t\t\t\tbase.transition3d(goToPixel);\n\t\t\t\t} else {\n\t\t\t\t\tif (speed === true) {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.paginationSpeed);\n\t\t\t\t\t} else if (speed === \"rewind\") {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.rewindSpeed);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.slideSpeed);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.afterGo();\n\t\t\t},\n\n\t\t\tjumpTo : function (position) {\n\t\t\t\tvar base = this;\n\t\t\t\tif (typeof base.options.beforeMove === \"function\") {\n\t\t\t\t\tbase.options.beforeMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tif (position >= base.maximumItem || position === -1) {\n\t\t\t\t\tposition = base.maximumItem;\n\t\t\t\t} else if (position <= 0) {\n\t\t\t\t\tposition = 0;\n\t\t\t\t}\n\t\t\t\tbase.swapSpeed(0);\n\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\tbase.transition3d(base.positionsInArray[position]);\n\t\t\t\t} else {\n\t\t\t\t\tbase.css2slide(base.positionsInArray[position], 1);\n\t\t\t\t}\n\t\t\t\tbase.currentItem = base.owl.currentItem = position;\n\t\t\t\tbase.afterGo();\n\t\t\t},\n\n\t\t\tafterGo : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.prevArr.push(base.currentItem);\n\t\t\t\tbase.prevItem = base.owl.prevItem = base.prevArr[base.prevArr.length - 2];\n\t\t\t\tbase.prevArr.shift(0);\n\n\t\t\t\tif (base.prevItem !== base.currentItem) {\n\t\t\t\t\tbase.checkPagination();\n\t\t\t\t\tbase.checkNavigation();\n\t\t\t\t\tbase.eachMoveUpdate();\n\n\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\tbase.checkAp();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (typeof base.options.afterMove === \"function\" && base.prevItem !== base.currentItem) {\n\t\t\t\t\tbase.options.afterMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tstop : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.apStatus = \"stop\";\n\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t},\n\n\t\t\tcheckAp : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.apStatus !== \"stop\") {\n\t\t\t\t\tbase.play();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tplay : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.apStatus = \"play\";\n\t\t\t\tif (base.options.autoPlay === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\tbase.autoPlayInterval = window.setInterval(function () {\n\t\t\t\t\tbase.next(true);\n\t\t\t\t}, base.options.autoPlay);\n\t\t\t},\n\n\t\t\tswapSpeed : function (action) {\n\t\t\t\tvar base = this;\n\t\t\t\tif (action === \"slideSpeed\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(base.options.slideSpeed));\n\t\t\t\t} else if (action === \"paginationSpeed\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(base.options.paginationSpeed));\n\t\t\t\t} else if (typeof action !== \"string\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(action));\n\t\t\t\t}\n\t\t\t},\n\n\t\t\taddCssSpeed : function (speed) {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"-moz-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"-o-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"transition\": \"all \" + speed + \"ms ease\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tremoveTransition : function () {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transition\": \"\",\n\t\t\t\t\t\"-moz-transition\": \"\",\n\t\t\t\t\t\"-o-transition\": \"\",\n\t\t\t\t\t\"transition\": \"\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tdoTranslate : function (pixels) {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-moz-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-o-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-ms-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"transform\": \"translate3d(\" + pixels + \"px, 0px,0px)\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\ttransition3d : function (value) {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$owlWrapper.css(base.doTranslate(value));\n\t\t\t},\n\n\t\t\tcss2move : function (value) {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$owlWrapper.css({\"left\" : value});\n\t\t\t},\n\n\t\t\tcss2slide : function (value, speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.isCssFinish = false;\n\t\t\t\tbase.$owlWrapper.stop(true, true).animate({\n\t\t\t\t\t\"left\" : value\n\t\t\t\t}, {\n\t\t\t\t\tduration : speed || base.options.slideSpeed,\n\t\t\t\t\tcomplete : function () {\n\t\t\t\t\t\tbase.isCssFinish = true;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tcheckBrowser : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ttranslate3D = \"translate3d(0px, 0px, 0px)\",\n\t\t\t\t\ttempElem = document.createElement(\"div\"),\n\t\t\t\t\tregex,\n\t\t\t\t\tasSupport,\n\t\t\t\t\tsupport3d,\n\t\t\t\t\tisTouch;\n\n\t\t\t\ttempElem.style.cssText = \"  -moz-transform:\" + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -ms-transform:\"     + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -o-transform:\"      + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -webkit-transform:\" + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; transform:\"         + translate3D;\n\t\t\t\tregex = /translate3d\\(0px, 0px, 0px\\)/g;\n\t\t\t\tasSupport = tempElem.style.cssText.match(regex);\n\t\t\t\tsupport3d = (asSupport !== null && asSupport.length === 1);\n\n\t\t\t\tisTouch = \"ontouchstart\" in window || window.navigator.msMaxTouchPoints;\n\n\t\t\t\tbase.browser = {\n\t\t\t\t\t\"support3d\" : support3d,\n\t\t\t\t\t\"isTouch\" : isTouch\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tmoveEvents : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.mouseDrag !== false || base.options.touchDrag !== false) {\n\t\t\t\t\tbase.gestures();\n\t\t\t\t\tbase.disabledEvents();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\teventTypes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ttypes = [\"s\", \"e\", \"x\"];\n\n\t\t\t\tbase.ev_types = {};\n\n\t\t\t\tif (base.options.mouseDrag === true && base.options.touchDrag === true) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"touchstart.owl mousedown.owl\",\n\t\t\t\t\t\t\"touchmove.owl mousemove.owl\",\n\t\t\t\t\t\t\"touchend.owl touchcancel.owl mouseup.owl\"\n\t\t\t\t\t];\n\t\t\t\t} else if (base.options.mouseDrag === false && base.options.touchDrag === true) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"touchstart.owl\",\n\t\t\t\t\t\t\"touchmove.owl\",\n\t\t\t\t\t\t\"touchend.owl touchcancel.owl\"\n\t\t\t\t\t];\n\t\t\t\t} else if (base.options.mouseDrag === true && base.options.touchDrag === false) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"mousedown.owl\",\n\t\t\t\t\t\t\"mousemove.owl\",\n\t\t\t\t\t\t\"mouseup.owl\"\n\t\t\t\t\t];\n\t\t\t\t}\n\n\t\t\t\tbase.ev_types.start = types[0];\n\t\t\t\tbase.ev_types.move = types[1];\n\t\t\t\tbase.ev_types.end = types[2];\n\t\t\t},\n\n\t\t\tdisabledEvents :  function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.on(\"dragstart.owl\", function (event) { event.preventDefault(); });\n\t\t\t\tbase.$elem.on(\"mousedown.disableTextSelect\", function (e) {\n\t\t\t\t\treturn $(e.target).is('input, textarea, select, option');\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tgestures : function () {\n\t\t\t\t/*jslint unparam: true*/\n\t\t\t\tvar base = this,\n\t\t\t\t\tlocals = {\n\t\t\t\t\t\toffsetX : 0,\n\t\t\t\t\t\toffsetY : 0,\n\t\t\t\t\t\tbaseElWidth : 0,\n\t\t\t\t\t\trelativePos : 0,\n\t\t\t\t\t\tposition: null,\n\t\t\t\t\t\tminSwipe : null,\n\t\t\t\t\t\tmaxSwipe: null,\n\t\t\t\t\t\tsliding : null,\n\t\t\t\t\t\tdargging: null,\n\t\t\t\t\t\ttargetElement : null\n\t\t\t\t\t};\n\n\t\t\t\tbase.isCssFinish = true;\n\n\t\t\t\tfunction getTouches(event) {\n\t\t\t\t\tif (event.touches !== undefined) {\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tx : event.touches[0].pageX,\n\t\t\t\t\t\t\ty : event.touches[0].pageY\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tif (event.touches === undefined) {\n\t\t\t\t\t\tif (event.pageX !== undefined) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tx : event.pageX,\n\t\t\t\t\t\t\t\ty : event.pageY\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (event.pageX === undefined) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tx : event.clientX,\n\t\t\t\t\t\t\t\ty : event.clientY\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction swapEvents(type) {\n\t\t\t\t\tif (type === \"on\") {\n\t\t\t\t\t\t$(document).on(base.ev_types.move, dragMove);\n\t\t\t\t\t\t$(document).on(base.ev_types.end, dragEnd);\n\t\t\t\t\t} else if (type === \"off\") {\n\t\t\t\t\t\t$(document).off(base.ev_types.move);\n\t\t\t\t\t\t$(document).off(base.ev_types.end);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction dragStart(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tposition;\n\n\t\t\t\t\tif (ev.which === 3) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.itemsAmount <= base.options.items) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.isCssFinish === false && !base.options.dragBeforeAnimFinish) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.isCss3Finish === false && !base.options.dragBeforeAnimFinish) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.browser.isTouch !== true && !base.$owlWrapper.hasClass(\"grabbing\")) {\n\t\t\t\t\t\tbase.$owlWrapper.addClass(\"grabbing\");\n\t\t\t\t\t}\n\n\t\t\t\t\tbase.newPosX = 0;\n\t\t\t\t\tbase.newRelativeX = 0;\n\n\t\t\t\t\t$(this).css(base.removeTransition());\n\n\t\t\t\t\tposition = $(this).position();\n\t\t\t\t\tlocals.relativePos = position.left;\n\n\t\t\t\t\tlocals.offsetX = getTouches(ev).x - position.left;\n\t\t\t\t\tlocals.offsetY = getTouches(ev).y - position.top;\n\n\t\t\t\t\tswapEvents(\"on\");\n\n\t\t\t\t\tlocals.sliding = false;\n\t\t\t\t\tlocals.targetElement = ev.target || ev.srcElement;\n\t\t\t\t}\n\n\t\t\t\tfunction dragMove(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tminSwipe,\n\t\t\t\t\t\tmaxSwipe;\n\n\t\t\t\t\tbase.newPosX = getTouches(ev).x - locals.offsetX;\n\t\t\t\t\tbase.newPosY = getTouches(ev).y - locals.offsetY;\n\t\t\t\t\tbase.newRelativeX = base.newPosX - locals.relativePos;\n\n\t\t\t\t\tif (typeof base.options.startDragging === \"function\" && locals.dragging !== true && base.newRelativeX !== 0) {\n\t\t\t\t\t\tlocals.dragging = true;\n\t\t\t\t\t\tbase.options.startDragging.apply(base, [base.$elem]);\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((base.newRelativeX > 8 || base.newRelativeX < -8) && (base.browser.isTouch === true)) {\n\t\t\t\t\t\tif (ev.preventDefault !== undefined) {\n\t\t\t\t\t\t\tev.preventDefault();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tev.returnValue = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tlocals.sliding = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((base.newPosY > 10 || base.newPosY < -10) && locals.sliding === false) {\n\t\t\t\t\t\t$(document).off(\"touchmove.owl\");\n\t\t\t\t\t}\n\n\t\t\t\t\tminSwipe = function () {\n\t\t\t\t\t\treturn base.newRelativeX / 5;\n\t\t\t\t\t};\n\n\t\t\t\t\tmaxSwipe = function () {\n\t\t\t\t\t\treturn base.maximumPixels + base.newRelativeX / 5;\n\t\t\t\t\t};\n\n\t\t\t\t\tbase.newPosX = Math.max(Math.min(base.newPosX, minSwipe()), maxSwipe());\n\t\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\t\tbase.transition3d(base.newPosX);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2move(base.newPosX);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction dragEnd(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tnewPosition,\n\t\t\t\t\t\thandlers,\n\t\t\t\t\t\towlStopEvent;\n\n\t\t\t\t\tev.target = ev.target || ev.srcElement;\n\n\t\t\t\t\tlocals.dragging = false;\n\n\t\t\t\t\tif (base.browser.isTouch !== true) {\n\t\t\t\t\t\tbase.$owlWrapper.removeClass(\"grabbing\");\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.newRelativeX < 0) {\n\t\t\t\t\t\tbase.dragDirection = base.owl.dragDirection = \"left\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.dragDirection = base.owl.dragDirection = \"right\";\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.newRelativeX !== 0) {\n\t\t\t\t\t\tnewPosition = base.getNewPosition();\n\t\t\t\t\t\tbase.goTo(newPosition, false, \"drag\");\n\t\t\t\t\t\tif (locals.targetElement === ev.target && base.browser.isTouch !== true) {\n\t\t\t\t\t\t\t$(ev.target).on(\"click.disable\", function (ev) {\n\t\t\t\t\t\t\t\tev.stopImmediatePropagation();\n\t\t\t\t\t\t\t\tev.stopPropagation();\n\t\t\t\t\t\t\t\tev.preventDefault();\n\t\t\t\t\t\t\t\t$(ev.target).off(\"click.disable\");\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\thandlers = $._data(ev.target, \"events\").click;\n\t\t\t\t\t\t\towlStopEvent = handlers.pop();\n\t\t\t\t\t\t\thandlers.splice(0, 0, owlStopEvent);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tswapEvents(\"off\");\n\t\t\t\t}\n\t\t\t\tbase.$elem.on(base.ev_types.start, \".owl-wrapper\", dragStart);\n\t\t\t},\n\n\t\t\tgetNewPosition : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tnewPosition = base.closestItem();\n\n\t\t\t\tif (newPosition > base.maximumItem) {\n\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\tnewPosition  = base.maximumItem;\n\t\t\t\t} else if (base.newPosX >= 0) {\n\t\t\t\t\tnewPosition = 0;\n\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t}\n\t\t\t\treturn newPosition;\n\t\t\t},\n\t\t\tclosestItem : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tarray = base.options.scrollPerPage === true ? base.pagesInArray : base.positionsInArray,\n\t\t\t\t\tgoal = base.newPosX,\n\t\t\t\t\tclosest = null;\n\n\t\t\t\t$.each(array, function (i, v) {\n\t\t\t\t\tif (goal - (base.itemWidth / 20) > array[i + 1] && goal - (base.itemWidth / 20) < v && base.moveDirection() === \"left\") {\n\t\t\t\t\t\tclosest = v;\n\t\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\t\tbase.currentItem = $.inArray(closest, base.positionsInArray);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tbase.currentItem = i;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if (goal + (base.itemWidth / 20) < v && goal + (base.itemWidth / 20) > (array[i + 1] || array[i] - base.itemWidth) && base.moveDirection() === \"right\") {\n\t\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\t\tclosest = array[i + 1] || array[array.length - 1];\n\t\t\t\t\t\t\tbase.currentItem = $.inArray(closest, base.positionsInArray);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tclosest = array[i + 1];\n\t\t\t\t\t\t\tbase.currentItem = i + 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn base.currentItem;\n\t\t\t},\n\n\t\t\tmoveDirection : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tdirection;\n\t\t\t\tif (base.newRelativeX < 0) {\n\t\t\t\t\tdirection = \"right\";\n\t\t\t\t\tbase.playDirection = \"next\";\n\t\t\t\t} else {\n\t\t\t\t\tdirection = \"left\";\n\t\t\t\t\tbase.playDirection = \"prev\";\n\t\t\t\t}\n\t\t\t\treturn direction;\n\t\t\t},\n\n\t\t\tcustomEvents : function () {\n\t\t\t\t/*jslint unparam: true*/\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.on(\"owl.next\", function () {\n\t\t\t\t\tbase.next();\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.prev\", function () {\n\t\t\t\t\tbase.prev();\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.play\", function (event, speed) {\n\t\t\t\t\tbase.options.autoPlay = speed;\n\t\t\t\t\tbase.play();\n\t\t\t\t\tbase.hoverStatus = \"play\";\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.stop\", function () {\n\t\t\t\t\tbase.stop();\n\t\t\t\t\tbase.hoverStatus = \"stop\";\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.goTo\", function (event, item) {\n\t\t\t\t\tbase.goTo(item);\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.jumpTo\", function (event, item) {\n\t\t\t\t\tbase.jumpTo(item);\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tstopOnHover : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.stopOnHover === true && base.browser.isTouch !== true && base.options.autoPlay !== false) {\n\t\t\t\t\tbase.$elem.on(\"mouseover\", function () {\n\t\t\t\t\t\tbase.stop();\n\t\t\t\t\t});\n\t\t\t\t\tbase.$elem.on(\"mouseout\", function () {\n\t\t\t\t\t\tif (base.hoverStatus !== \"stop\") {\n\t\t\t\t\t\t\tbase.play();\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlazyLoad : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ti,\n\t\t\t\t\t$item,\n\t\t\t\t\titemNumber,\n\t\t\t\t\t$lazyImg,\n\t\t\t\t\tfollow;\n\n\t\t\t\tif (base.options.lazyLoad === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\t$item = $(base.$owlItems[i]);\n\n\t\t\t\t\tif ($item.data(\"owl-loaded\") === \"loaded\") {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\titemNumber = $item.data(\"owl-item\");\n\t\t\t\t\t$lazyImg = $item.find(\".lazyOwl\");\n\n\t\t\t\t\tif (typeof $lazyImg.data(\"src\") !== \"string\") {\n\t\t\t\t\t\t$item.data(\"owl-loaded\", \"loaded\");\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t\tif ($item.data(\"owl-loaded\") === undefined) {\n\t\t\t\t\t\t$lazyImg.hide();\n\t\t\t\t\t\t$item.addClass(\"loading\").data(\"owl-loaded\", \"checked\");\n\t\t\t\t\t}\n\t\t\t\t\tif (base.options.lazyFollow === true) {\n\t\t\t\t\t\tfollow = itemNumber >= base.currentItem;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfollow = true;\n\t\t\t\t\t}\n\t\t\t\t\tif (follow && itemNumber < base.currentItem + base.options.items && $lazyImg.length) {\n\t\t\t\t\t\tbase.lazyPreload($item, $lazyImg);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlazyPreload : function ($item, $lazyImg) {\n\t\t\t\tvar base = this,\n\t\t\t\t\titerations = 0,\n\t\t\t\t\tisBackgroundImg;\n\n\t\t\t\tif ($lazyImg.prop(\"tagName\") === \"DIV\") {\n\t\t\t\t\t$lazyImg.css(\"background-image\", \"url(\" + $lazyImg.data(\"src\") + \")\");\n\t\t\t\t\tisBackgroundImg = true;\n\t\t\t\t} else {\n\t\t\t\t\t$lazyImg[0].src = $lazyImg.data(\"src\");\n\t\t\t\t}\n\n\t\t\t\tfunction showImage() {\n\t\t\t\t\t$item.data(\"owl-loaded\", \"loaded\").removeClass(\"loading\");\n\t\t\t\t\t$lazyImg.removeAttr(\"data-src\");\n\t\t\t\t\tif (base.options.lazyEffect === \"fade\") {\n\t\t\t\t\t\t$lazyImg.fadeIn(400);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t$lazyImg.show();\n\t\t\t\t\t}\n\t\t\t\t\tif (typeof base.options.afterLazyLoad === \"function\") {\n\t\t\t\t\t\tbase.options.afterLazyLoad.apply(this, [base.$elem]);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction checkLazyImage() {\n\t\t\t\t\titerations += 1;\n\t\t\t\t\tif (base.completeImg($lazyImg.get(0)) || isBackgroundImg === true) {\n\t\t\t\t\t\tshowImage();\n\t\t\t\t\t} else if (iterations <= 100) {//if image loads in less than 10 seconds \n\t\t\t\t\t\twindow.setTimeout(checkLazyImage, 100);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tshowImage();\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tcheckLazyImage();\n\t\t\t},\n\n\t\t\tautoHeight : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\t$currentimg = $(base.$owlItems[base.currentItem]).find(\"img\"),\n\t\t\t\t\titerations;\n\n\t\t\t\tfunction addHeight() {\n\t\t\t\t\tvar $currentItem = $(base.$owlItems[base.currentItem]).height();\n\t\t\t\t\tbase.wrapperOuter.css(\"height\", $currentItem + \"px\");\n\t\t\t\t\tif (!base.wrapperOuter.hasClass(\"autoHeight\")) {\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.wrapperOuter.addClass(\"autoHeight\");\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction checkImage() {\n\t\t\t\t\titerations += 1;\n\t\t\t\t\tif (base.completeImg($currentimg.get(0))) {\n\t\t\t\t\t\taddHeight();\n\t\t\t\t\t} else if (iterations <= 100) { //if image loads in less than 10 seconds \n\t\t\t\t\t\twindow.setTimeout(checkImage, 100);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.wrapperOuter.css(\"height\", \"\"); //Else remove height attribute\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ($currentimg.get(0) !== undefined) {\n\t\t\t\t\titerations = 0;\n\t\t\t\t\tcheckImage();\n\t\t\t\t} else {\n\t\t\t\t\taddHeight();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tcompleteImg : function (img) {\n\t\t\t\tvar naturalWidthType;\n\n\t\t\t\tif (!img.complete) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tnaturalWidthType = typeof img.naturalWidth;\n\t\t\t\tif (naturalWidthType !== \"undefined\" && img.naturalWidth === 0) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\n\t\t\tonVisibleItems : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ti;\n\n\t\t\t\tif (base.options.addClassActive === true) {\n\t\t\t\t\tbase.$owlItems.removeClass(\"active\");\n\t\t\t\t}\n\t\t\t\tbase.visibleItems = [];\n\t\t\t\tfor (i = base.currentItem; i < base.currentItem + base.options.items; i += 1) {\n\t\t\t\t\tbase.visibleItems.push(i);\n\n\t\t\t\t\tif (base.options.addClassActive === true) {\n\t\t\t\t\t\t$(base.$owlItems[i]).addClass(\"active\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.owl.visibleItems = base.visibleItems;\n\t\t\t},\n\n\t\t\ttransitionTypes : function (className) {\n\t\t\t\tvar base = this;\n\t\t\t\t//Currently available: \"fade\", \"backSlide\", \"goDown\", \"fadeUp\"\n\t\t\t\tbase.outClass = \"owl-\" + className + \"-out\";\n\t\t\t\tbase.inClass = \"owl-\" + className + \"-in\";\n\t\t\t},\n\n\t\t\tsingleItemTransition : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\toutClass = base.outClass,\n\t\t\t\t\tinClass = base.inClass,\n\t\t\t\t\t$currentItem = base.$owlItems.eq(base.currentItem),\n\t\t\t\t\t$prevItem = base.$owlItems.eq(base.prevItem),\n\t\t\t\t\tprevPos = Math.abs(base.positionsInArray[base.currentItem]) + base.positionsInArray[base.prevItem],\n\t\t\t\t\torigin = Math.abs(base.positionsInArray[base.currentItem]) + base.itemWidth / 2,\n\t\t\t\t\tanimEnd = 'webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend';\n\n\t\t\t\tbase.isTransition = true;\n\n\t\t\t\tbase.$owlWrapper\n\t\t\t\t\t.addClass('owl-origin')\n\t\t\t\t\t.css({\n\t\t\t\t\t\t\"-webkit-transform-origin\" : origin + \"px\",\n\t\t\t\t\t\t\"-moz-perspective-origin\" : origin + \"px\",\n\t\t\t\t\t\t\"perspective-origin\" : origin + \"px\"\n\t\t\t\t\t});\n\t\t\t\tfunction transStyles(prevPos) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\t\"position\" : \"relative\",\n\t\t\t\t\t\t\"left\" : prevPos + \"px\"\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t$prevItem\n\t\t\t\t\t.css(transStyles(prevPos, 10))\n\t\t\t\t\t.addClass(outClass)\n\t\t\t\t\t.on(animEnd, function () {\n\t\t\t\t\t\tbase.endPrev = true;\n\t\t\t\t\t\t$prevItem.off(animEnd);\n\t\t\t\t\t\tbase.clearTransStyle($prevItem, outClass);\n\t\t\t\t\t});\n\n\t\t\t\t$currentItem\n\t\t\t\t\t.addClass(inClass)\n\t\t\t\t\t.on(animEnd, function () {\n\t\t\t\t\t\tbase.endCurrent = true;\n\t\t\t\t\t\t$currentItem.off(animEnd);\n\t\t\t\t\t\tbase.clearTransStyle($currentItem, inClass);\n\t\t\t\t\t});\n\t\t\t},\n\n\t\t\tclearTransStyle : function (item, classToRemove) {\n\t\t\t\tvar base = this;\n\t\t\t\titem.css({\n\t\t\t\t\t\"position\" : \"\",\n\t\t\t\t\t\"left\" : \"\"\n\t\t\t\t}).removeClass(classToRemove);\n\n\t\t\t\tif (base.endPrev && base.endCurrent) {\n\t\t\t\t\tbase.$owlWrapper.removeClass('owl-origin');\n\t\t\t\t\tbase.endPrev = false;\n\t\t\t\t\tbase.endCurrent = false;\n\t\t\t\t\tbase.isTransition = false;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\towlStatus : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.owl = {\n\t\t\t\t\t\"userOptions\"   : base.userOptions,\n\t\t\t\t\t\"baseElement\"   : base.$elem,\n\t\t\t\t\t\"userItems\"     : base.$userItems,\n\t\t\t\t\t\"owlItems\"      : base.$owlItems,\n\t\t\t\t\t\"currentItem\"   : base.currentItem,\n\t\t\t\t\t\"prevItem\"      : base.prevItem,\n\t\t\t\t\t\"visibleItems\"  : base.visibleItems,\n\t\t\t\t\t\"isTouch\"       : base.browser.isTouch,\n\t\t\t\t\t\"browser\"       : base.browser,\n\t\t\t\t\t\"dragDirection\" : base.dragDirection\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tclearEvents : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.off(\".owl owl mousedown.disableTextSelect\");\n\t\t\t\t$(document).off(\".owl owl\");\n\t\t\t\t$(window).off(\"resize\", base.resizer);\n\t\t\t},\n\n\t\t\tunWrap : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.$elem.children().length !== 0) {\n\t\t\t\t\tbase.$owlWrapper.unwrap();\n\t\t\t\t\tbase.$userItems.unwrap().unwrap();\n\t\t\t\t\tif (base.owlControls) {\n\t\t\t\t\t\tbase.owlControls.remove();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.clearEvents();\n\t\t\t\tbase.$elem\n\t\t\t\t\t.attr(\"style\", base.$elem.data(\"owl-originalStyles\") || \"\")\n\t\t\t\t\t.attr(\"class\", base.$elem.data(\"owl-originalClasses\"));\n\t\t\t},\n\n\t\t\tdestroy : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.stop();\n\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.$elem.removeData();\n\t\t\t},\n\n\t\t\treinit : function (newOptions) {\n\t\t\t\tvar base = this,\n\t\t\t\t\toptions = $.extend({}, base.userOptions, newOptions);\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.init(options, base.$elem);\n\t\t\t},\n\n\t\t\taddItem : function (htmlString, targetPosition) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tposition;\n\n\t\t\t\tif (!htmlString) {return false; }\n\n\t\t\t\tif (base.$elem.children().length === 0) {\n\t\t\t\t\tbase.$elem.append(htmlString);\n\t\t\t\t\tbase.setVars();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.unWrap();\n\t\t\t\tif (targetPosition === undefined || targetPosition === -1) {\n\t\t\t\t\tposition = -1;\n\t\t\t\t} else {\n\t\t\t\t\tposition = targetPosition;\n\t\t\t\t}\n\t\t\t\tif (position >= base.$userItems.length || position === -1) {\n\t\t\t\t\tbase.$userItems.eq(-1).after(htmlString);\n\t\t\t\t} else {\n\t\t\t\t\tbase.$userItems.eq(position).before(htmlString);\n\t\t\t\t}\n\n\t\t\t\tbase.setVars();\n\t\t\t},\n\n\t\t\tremoveItem : function (targetPosition) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tposition;\n\n\t\t\t\tif (base.$elem.children().length === 0) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (targetPosition === undefined || targetPosition === -1) {\n\t\t\t\t\tposition = -1;\n\t\t\t\t} else {\n\t\t\t\t\tposition = targetPosition;\n\t\t\t\t}\n\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.$userItems.eq(position).remove();\n\t\t\t\tbase.setVars();\n\t\t\t}\n\n\t\t};\n\n\t\t$.fn.owlCarousel = function (options) {\n\t\t\treturn this.each(function () {\n\t\t\t\tif ($(this).data(\"owl-init\") === true) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\t$(this).data(\"owl-init\", true);\n\t\t\t\tvar carousel = Object.create(Carousel);\n\t\t\t\tcarousel.init(options, this);\n\t\t\t\t$.data(this, \"owlCarousel\", carousel);\n\t\t\t});\n\t\t};\n\n\t\t$.fn.owlCarousel.options = {\n\n\t\t\titems : 5,\n\t\t\titemsCustom : false,\n\t\t\titemsDesktop : [1199, 4],\n\t\t\titemsDesktopSmall : [979, 3],\n\t\t\titemsTablet : [768, 2],\n\t\t\titemsTabletSmall : false,\n\t\t\titemsMobile : [479, 1],\n\t\t\tsingleItem : false,\n\t\t\titemsScaleUp : false,\n\n\t\t\tslideSpeed : 200,\n\t\t\tpaginationSpeed : 800,\n\t\t\trewindSpeed : 1000,\n\n\t\t\tautoPlay : false,\n\t\t\tstopOnHover : false,\n\n\t\t\tnavigation : false,\n\t\t\tnavigationText : [\"prev\", \"next\"],\n\t\t\trewindNav : true,\n\t\t\tscrollPerPage : false,\n\n\t\t\tpagination : true,\n\t\t\tpaginationNumbers : false,\n\n\t\t\tresponsive : true,\n\t\t\tresponsiveRefreshRate : 200,\n\t\t\tresponsiveBaseWidth : window,\n\n\t\t\tbaseClass : \"owl-carousel\",\n\t\t\ttheme : \"owl-theme\",\n\n\t\t\tlazyLoad : false,\n\t\t\tlazyFollow : true,\n\t\t\tlazyEffect : \"fade\",\n\n\t\t\tautoHeight : false,\n\n\t\t\tjsonPath : false,\n\t\t\tjsonSuccess : false,\n\n\t\t\tdragBeforeAnimFinish : true,\n\t\t\tmouseDrag : true,\n\t\t\ttouchDrag : true,\n\n\t\t\taddClassActive : false,\n\t\t\ttransitionStyle : false,\n\n\t\t\tbeforeUpdate : false,\n\t\t\tafterUpdate : false,\n\t\t\tbeforeInit : false,\n\t\t\tafterInit : false,\n\t\t\tbeforeMove : false,\n\t\t\tafterMove : false,\n\t\t\tafterAction : false,\n\t\t\tstartDragging : false,\n\t\t\tafterLazyLoad: false\n\t\t};\n\t}($, window, document));\n});\n","Plazathemes_Brandslider/js/owl.carousel.js":"/**\n * Copyright \u00c2\u00a9 2015 PlazaThemes.com. All rights reserved.\n *\n * @author PlazaThemes Team <contact@plazathemes.com>\n */\n\n/*\n *  jQuery OwlCarousel v1.3.3\n *\n *  Copyright (c) 2013 Bartosz Wojciechowski\n *  http://www.owlgraphic.com/owlcarousel/\n *\n *  Licensed under MIT\n *\n */\n\n/*JS Lint helpers: */\n/*global dragMove: false, dragEnd: false, $, jQuery, alert, window, document */\n/*jslint nomen: true, continue:true */\nif (typeof Object.create !== \"function\") {\n    Object.create = function (obj) {\n        function F() {}\n        F.prototype = obj;\n        return new F();\n    };\n}\nrequire([\n\t\"jquery\"\n], function($){\n\t(function ($, window, document) {\n\t\tvar Carousel = {\n\t\t\tinit : function (options, el) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.$elem = $(el);\n\t\t\t\tbase.options = $.extend({}, $.fn.owlCarousel.options, base.$elem.data(), options);\n\n\t\t\t\tbase.userOptions = options;\n\t\t\t\tbase.loadContent();\n\t\t\t},\n\n\t\t\tloadContent : function () {\n\t\t\t\tvar base = this, url;\n\n\t\t\t\tfunction getData(data) {\n\t\t\t\t\tvar i, content = \"\";\n\t\t\t\t\tif (typeof base.options.jsonSuccess === \"function\") {\n\t\t\t\t\t\tbase.options.jsonSuccess.apply(this, [data]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfor (i in data.owl) {\n\t\t\t\t\t\t\tif (data.owl.hasOwnProperty(i)) {\n\t\t\t\t\t\t\t\tcontent += data.owl[i].item;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbase.$elem.html(content);\n\t\t\t\t\t}\n\t\t\t\t\tbase.logIn();\n\t\t\t\t}\n\n\t\t\t\tif (typeof base.options.beforeInit === \"function\") {\n\t\t\t\t\tbase.options.beforeInit.apply(this, [base.$elem]);\n\t\t\t\t}\n\n\t\t\t\tif (typeof base.options.jsonPath === \"string\") {\n\t\t\t\t\turl = base.options.jsonPath;\n\t\t\t\t\t$.getJSON(url, getData);\n\t\t\t\t} else {\n\t\t\t\t\tbase.logIn();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlogIn : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.$elem.data(\"owl-originalStyles\", base.$elem.attr(\"style\"));\n\t\t\t\tbase.$elem.data(\"owl-originalClasses\", base.$elem.attr(\"class\"));\n\n\t\t\t\tbase.$elem.css({opacity: 0});\n\t\t\t\tbase.orignalItems = base.options.items;\n\t\t\t\tbase.checkBrowser();\n\t\t\t\tbase.wrapperWidth = 0;\n\t\t\t\tbase.checkVisible = null;\n\t\t\t\tbase.setVars();\n\t\t\t},\n\n\t\t\tsetVars : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.$elem.children().length === 0) {return false; }\n\t\t\t\tbase.baseClass();\n\t\t\t\tbase.eventTypes();\n\t\t\t\tbase.$userItems = base.$elem.children();\n\t\t\t\tbase.itemsAmount = base.$userItems.length;\n\t\t\t\tbase.wrapItems();\n\t\t\t\tbase.$owlItems = base.$elem.find(\".owl-item\");\n\t\t\t\tbase.$owlWrapper = base.$elem.find(\".owl-wrapper\");\n\t\t\t\tbase.playDirection = \"next\";\n\t\t\t\tbase.prevItem = 0;\n\t\t\t\tbase.prevArr = [0];\n\t\t\t\tbase.currentItem = 0;\n\t\t\t\tbase.customEvents();\n\t\t\t\tbase.onStartup();\n\t\t\t},\n\n\t\t\tonStartup : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.updateItems();\n\t\t\t\tbase.calculateAll();\n\t\t\t\tbase.buildControls();\n\t\t\t\tbase.updateControls();\n\t\t\t\tbase.response();\n\t\t\t\tbase.moveEvents();\n\t\t\t\tbase.stopOnHover();\n\t\t\t\tbase.owlStatus();\n\n\t\t\t\tif (base.options.transitionStyle !== false) {\n\t\t\t\t\tbase.transitionTypes(base.options.transitionStyle);\n\t\t\t\t}\n\t\t\t\tif (base.options.autoPlay === true) {\n\t\t\t\t\tbase.options.autoPlay = 5000;\n\t\t\t\t}\n\t\t\t\tbase.play();\n\n\t\t\t\tbase.$elem.find(\".owl-wrapper\").css(\"display\", \"block\");\n\n\t\t\t\tif (!base.$elem.is(\":visible\")) {\n\t\t\t\t\tbase.watchVisibility();\n\t\t\t\t} else {\n\t\t\t\t\tbase.$elem.css(\"opacity\", 1);\n\t\t\t\t}\n\t\t\t\tbase.onstartup = false;\n\t\t\t\tbase.eachMoveUpdate();\n\t\t\t\tif (typeof base.options.afterInit === \"function\") {\n\t\t\t\t\tbase.options.afterInit.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\teachMoveUpdate : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.options.lazyLoad === true) {\n\t\t\t\t\tbase.lazyLoad();\n\t\t\t\t}\n\t\t\t\tif (base.options.autoHeight === true) {\n\t\t\t\t\tbase.autoHeight();\n\t\t\t\t}\n\t\t\t\tbase.onVisibleItems();\n\n\t\t\t\tif (typeof base.options.afterAction === \"function\") {\n\t\t\t\t\tbase.options.afterAction.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateVars : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (typeof base.options.beforeUpdate === \"function\") {\n\t\t\t\t\tbase.options.beforeUpdate.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tbase.watchVisibility();\n\t\t\t\tbase.updateItems();\n\t\t\t\tbase.calculateAll();\n\t\t\t\tbase.updatePosition();\n\t\t\t\tbase.updateControls();\n\t\t\t\tbase.eachMoveUpdate();\n\t\t\t\tif (typeof base.options.afterUpdate === \"function\") {\n\t\t\t\t\tbase.options.afterUpdate.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\treload : function () {\n\t\t\t\tvar base = this;\n\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\tbase.updateVars();\n\t\t\t\t}, 0);\n\t\t\t},\n\n\t\t\twatchVisibility : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.$elem.is(\":visible\") === false) {\n\t\t\t\t\tbase.$elem.css({opacity: 0});\n\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\t} else {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.checkVisible = window.setInterval(function () {\n\t\t\t\t\tif (base.$elem.is(\":visible\")) {\n\t\t\t\t\t\tbase.reload();\n\t\t\t\t\t\tbase.$elem.animate({opacity: 1}, 200);\n\t\t\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\t\t}\n\t\t\t\t}, 500);\n\t\t\t},\n\n\t\t\twrapItems : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$userItems.wrapAll(\"<div class=\\\"owl-wrapper\\\">\").wrap(\"<div class=\\\"owl-item\\\"></div>\");\n\t\t\t\tbase.$elem.find(\".owl-wrapper\").wrap(\"<div class=\\\"owl-wrapper-outer\\\">\");\n\t\t\t\tbase.wrapperOuter = base.$elem.find(\".owl-wrapper-outer\");\n\t\t\t\tbase.$elem.css(\"display\", \"block\");\n\t\t\t},\n\n\t\t\tbaseClass : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\thasBaseClass = base.$elem.hasClass(base.options.baseClass),\n\t\t\t\t\thasThemeClass = base.$elem.hasClass(base.options.theme);\n\n\t\t\t\tif (!hasBaseClass) {\n\t\t\t\t\tbase.$elem.addClass(base.options.baseClass);\n\t\t\t\t}\n\n\t\t\t\tif (!hasThemeClass) {\n\t\t\t\t\tbase.$elem.addClass(base.options.theme);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateItems : function () {\n\t\t\t\tvar base = this, width, i;\n\n\t\t\t\tif (base.options.responsive === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (base.options.singleItem === true) {\n\t\t\t\t\tbase.options.items = base.orignalItems = 1;\n\t\t\t\t\tbase.options.itemsCustom = false;\n\t\t\t\t\tbase.options.itemsDesktop = false;\n\t\t\t\t\tbase.options.itemsDesktopSmall = false;\n\t\t\t\t\tbase.options.itemsTablet = false;\n\t\t\t\t\tbase.options.itemsTabletSmall = false;\n\t\t\t\t\tbase.options.itemsMobile = false;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\twidth = $(base.options.responsiveBaseWidth).width();\n\n\t\t\t\tif (width > (base.options.itemsDesktop[0] || base.orignalItems)) {\n\t\t\t\t\tbase.options.items = base.orignalItems;\n\t\t\t\t}\n\t\t\t\tif (base.options.itemsCustom !== false) {\n\t\t\t\t\t//Reorder array by screen size\n\t\t\t\t\tbase.options.itemsCustom.sort(function (a, b) {return a[0] - b[0]; });\n\n\t\t\t\t\tfor (i = 0; i < base.options.itemsCustom.length; i += 1) {\n\t\t\t\t\t\tif (base.options.itemsCustom[i][0] <= width) {\n\t\t\t\t\t\t\tbase.options.items = base.options.itemsCustom[i][1];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\tif (width <= base.options.itemsDesktop[0] && base.options.itemsDesktop !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsDesktop[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsDesktopSmall[0] && base.options.itemsDesktopSmall !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsDesktopSmall[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsTablet[0] && base.options.itemsTablet !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsTablet[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsTabletSmall[0] && base.options.itemsTabletSmall !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsTabletSmall[1];\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width <= base.options.itemsMobile[0] && base.options.itemsMobile !== false) {\n\t\t\t\t\t\tbase.options.items = base.options.itemsMobile[1];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t//if number of items is less than declared\n\t\t\t\tif (base.options.items > base.itemsAmount && base.options.itemsScaleUp === true) {\n\t\t\t\t\tbase.options.items = base.itemsAmount;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tresponse : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tsmallDelay,\n\t\t\t\t\tlastWindowWidth;\n\n\t\t\t\tif (base.options.responsive !== true) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tlastWindowWidth = $(window).width();\n\n\t\t\t\tbase.resizer = function () {\n\t\t\t\t\tif ($(window).width() !== lastWindowWidth) {\n\t\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\t\t}\n\t\t\t\t\t\twindow.clearTimeout(smallDelay);\n\t\t\t\t\t\tsmallDelay = window.setTimeout(function () {\n\t\t\t\t\t\t\tlastWindowWidth = $(window).width();\n\t\t\t\t\t\t\tbase.updateVars();\n\t\t\t\t\t\t}, base.options.responsiveRefreshRate);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t\t$(window).resize(base.resizer);\n\t\t\t},\n\n\t\t\tupdatePosition : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.jumpTo(base.currentItem);\n\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\tbase.checkAp();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tappendItemsSizes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\troundPages = 0,\n\t\t\t\t\tlastItem = base.itemsAmount - base.options.items;\n\n\t\t\t\tbase.$owlItems.each(function (index) {\n\t\t\t\t\tvar $this = $(this);\n\t\t\t\t\t$this\n\t\t\t\t\t\t.css({\"width\": base.itemWidth})\n\t\t\t\t\t\t.data(\"owl-item\", Number(index));\n\n\t\t\t\t\tif (index % base.options.items === 0 || index === lastItem) {\n\t\t\t\t\t\tif (!(index > lastItem)) {\n\t\t\t\t\t\t\troundPages += 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\t$this.data(\"owl-roundPages\", roundPages);\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tappendWrapperSizes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\twidth = base.$owlItems.length * base.itemWidth;\n\n\t\t\t\tbase.$owlWrapper.css({\n\t\t\t\t\t\"width\": width * 2,\n\t\t\t\t\t\"left\": 0\n\t\t\t\t});\n\t\t\t\tbase.appendItemsSizes();\n\t\t\t},\n\n\t\t\tcalculateAll : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.calculateWidth();\n\t\t\t\tbase.appendWrapperSizes();\n\t\t\t\tbase.loops();\n\t\t\t\tbase.max();\n\t\t\t},\n\n\t\t\tcalculateWidth : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.itemWidth = Math.round(base.$elem.width() / base.options.items);\n\t\t\t},\n\n\t\t\tmax : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tmaximum = ((base.itemsAmount * base.itemWidth) - base.options.items * base.itemWidth) * -1;\n\t\t\t\tif (base.options.items > base.itemsAmount) {\n\t\t\t\t\tbase.maximumItem = 0;\n\t\t\t\t\tmaximum = 0;\n\t\t\t\t\tbase.maximumPixels = 0;\n\t\t\t\t} else {\n\t\t\t\t\tbase.maximumItem = base.itemsAmount - base.options.items;\n\t\t\t\t\tbase.maximumPixels = maximum;\n\t\t\t\t}\n\t\t\t\treturn maximum;\n\t\t\t},\n\n\t\t\tmin : function () {\n\t\t\t\treturn 0;\n\t\t\t},\n\n\t\t\tloops : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tprev = 0,\n\t\t\t\t\telWidth = 0,\n\t\t\t\t\ti,\n\t\t\t\t\titem,\n\t\t\t\t\troundPageNum;\n\n\t\t\t\tbase.positionsInArray = [0];\n\t\t\t\tbase.pagesInArray = [];\n\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\telWidth += base.itemWidth;\n\t\t\t\t\tbase.positionsInArray.push(-elWidth);\n\n\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\titem = $(base.$owlItems[i]);\n\t\t\t\t\t\troundPageNum = item.data(\"owl-roundPages\");\n\t\t\t\t\t\tif (roundPageNum !== prev) {\n\t\t\t\t\t\t\tbase.pagesInArray[prev] = base.positionsInArray[i];\n\t\t\t\t\t\t\tprev = roundPageNum;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbuildControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.navigation === true || base.options.pagination === true) {\n\t\t\t\t\tbase.owlControls = $(\"<div class=\\\"owl-controls\\\"/>\").toggleClass(\"clickable\", !base.browser.isTouch).appendTo(base.$elem);\n\t\t\t\t}\n\t\t\t\tif (base.options.pagination === true) {\n\t\t\t\t\tbase.buildPagination();\n\t\t\t\t}\n\t\t\t\tif (base.options.navigation === true) {\n\t\t\t\t\tbase.buildButtons();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbuildButtons : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tbuttonsWrapper = $(\"<div class=\\\"owl-buttons\\\"/>\");\n\t\t\t\tbase.owlControls.append(buttonsWrapper);\n\n\t\t\t\tbase.buttonPrev = $(\"<div/>\", {\n\t\t\t\t\t\"class\" : \"owl-prev\",\n\t\t\t\t\t\"html\" : base.options.navigationText[0] || \"\"\n\t\t\t\t});\n\n\t\t\t\tbase.buttonNext = $(\"<div/>\", {\n\t\t\t\t\t\"class\" : \"owl-next\",\n\t\t\t\t\t\"html\" : base.options.navigationText[1] || \"\"\n\t\t\t\t});\n\n\t\t\t\tbuttonsWrapper\n\t\t\t\t\t.append(base.buttonPrev)\n\t\t\t\t\t.append(base.buttonNext);\n\n\t\t\t\tbuttonsWrapper.on(\"touchstart.owlControls mousedown.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t});\n\n\t\t\t\tbuttonsWrapper.on(\"touchend.owlControls mouseup.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif ($(this).hasClass(\"owl-next\")) {\n\t\t\t\t\t\tbase.next();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.prev();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tbuildPagination : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.paginationWrapper = $(\"<div class=\\\"owl-pagination\\\"/>\");\n\t\t\t\tbase.owlControls.append(base.paginationWrapper);\n\n\t\t\t\tbase.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\", \".owl-page\", function (event) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif (Number($(this).data(\"owl-page\")) !== base.currentItem) {\n\t\t\t\t\t\tbase.goTo(Number($(this).data(\"owl-page\")), true);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tupdatePagination : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tcounter,\n\t\t\t\t\tlastPage,\n\t\t\t\t\tlastItem,\n\t\t\t\t\ti,\n\t\t\t\t\tpaginationButton,\n\t\t\t\t\tpaginationButtonInner;\n\n\t\t\t\tif (base.options.pagination === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tbase.paginationWrapper.html(\"\");\n\n\t\t\t\tcounter = 0;\n\t\t\t\tlastPage = base.itemsAmount - base.itemsAmount % base.options.items;\n\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\tif (i % base.options.items === 0) {\n\t\t\t\t\t\tcounter += 1;\n\t\t\t\t\t\tif (lastPage === i) {\n\t\t\t\t\t\t\tlastItem = base.itemsAmount - base.options.items;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tpaginationButton = $(\"<div/>\", {\n\t\t\t\t\t\t\t\"class\" : \"owl-page\"\n\t\t\t\t\t\t});\n\t\t\t\t\t\tpaginationButtonInner = $(\"<span></span>\", {\n\t\t\t\t\t\t\t\"text\": base.options.paginationNumbers === true ? counter : \"\",\n\t\t\t\t\t\t\t\"class\": base.options.paginationNumbers === true ? \"owl-numbers\" : \"\"\n\t\t\t\t\t\t});\n\t\t\t\t\t\tpaginationButton.append(paginationButtonInner);\n\n\t\t\t\t\t\tpaginationButton.data(\"owl-page\", lastPage === i ? lastItem : i);\n\t\t\t\t\t\tpaginationButton.data(\"owl-roundPages\", counter);\n\n\t\t\t\t\t\tbase.paginationWrapper.append(paginationButton);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.checkPagination();\n\t\t\t},\n\t\t\tcheckPagination : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.pagination === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.paginationWrapper.find(\".owl-page\").each(function () {\n\t\t\t\t\tif ($(this).data(\"owl-roundPages\") === $(base.$owlItems[base.currentItem]).data(\"owl-roundPages\")) {\n\t\t\t\t\t\tbase.paginationWrapper\n\t\t\t\t\t\t\t.find(\".owl-page\")\n\t\t\t\t\t\t\t.removeClass(\"active\");\n\t\t\t\t\t\t$(this).addClass(\"active\");\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tcheckNavigation : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.options.navigation === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (base.options.rewindNav === false) {\n\t\t\t\t\tif (base.currentItem === 0 && base.maximumItem === 0) {\n\t\t\t\t\t\tbase.buttonPrev.addClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.addClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem === 0 && base.maximumItem !== 0) {\n\t\t\t\t\t\tbase.buttonPrev.addClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.removeClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem === base.maximumItem) {\n\t\t\t\t\t\tbase.buttonPrev.removeClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.addClass(\"disabled\");\n\t\t\t\t\t} else if (base.currentItem !== 0 && base.currentItem !== base.maximumItem) {\n\t\t\t\t\t\tbase.buttonPrev.removeClass(\"disabled\");\n\t\t\t\t\t\tbase.buttonNext.removeClass(\"disabled\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdateControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.updatePagination();\n\t\t\t\tbase.checkNavigation();\n\t\t\t\tif (base.owlControls) {\n\t\t\t\t\tif (base.options.items >= base.itemsAmount) {\n\t\t\t\t\t\tbase.owlControls.hide();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.owlControls.show();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tdestroyControls : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.owlControls) {\n\t\t\t\t\tbase.owlControls.remove();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tnext : function (speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tbase.currentItem += base.options.scrollPerPage === true ? base.options.items : 1;\n\t\t\t\tif (base.currentItem > base.maximumItem + (base.options.scrollPerPage === true ? (base.options.items - 1) : 0)) {\n\t\t\t\t\tif (base.options.rewindNav === true) {\n\t\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t\t\tspeed = \"rewind\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.goTo(base.currentItem, speed);\n\t\t\t},\n\n\t\t\tprev : function (speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tif (base.options.scrollPerPage === true && base.currentItem > 0 && base.currentItem < base.options.items) {\n\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t} else {\n\t\t\t\t\tbase.currentItem -= base.options.scrollPerPage === true ? base.options.items : 1;\n\t\t\t\t}\n\t\t\t\tif (base.currentItem < 0) {\n\t\t\t\t\tif (base.options.rewindNav === true) {\n\t\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\t\tspeed = \"rewind\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.goTo(base.currentItem, speed);\n\t\t\t},\n\n\t\t\tgoTo : function (position, speed, drag) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tgoToPixel;\n\n\t\t\t\tif (base.isTransition) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (typeof base.options.beforeMove === \"function\") {\n\t\t\t\t\tbase.options.beforeMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tif (position >= base.maximumItem) {\n\t\t\t\t\tposition = base.maximumItem;\n\t\t\t\t} else if (position <= 0) {\n\t\t\t\t\tposition = 0;\n\t\t\t\t}\n\n\t\t\t\tbase.currentItem = base.owl.currentItem = position;\n\t\t\t\tif (base.options.transitionStyle !== false && drag !== \"drag\" && base.options.items === 1 && base.browser.support3d === true) {\n\t\t\t\t\tbase.swapSpeed(0);\n\t\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\t\tbase.transition3d(base.positionsInArray[position]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2slide(base.positionsInArray[position], 1);\n\t\t\t\t\t}\n\t\t\t\t\tbase.afterGo();\n\t\t\t\t\tbase.singleItemTransition();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tgoToPixel = base.positionsInArray[position];\n\n\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\tbase.isCss3Finish = false;\n\n\t\t\t\t\tif (speed === true) {\n\t\t\t\t\t\tbase.swapSpeed(\"paginationSpeed\");\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.paginationSpeed);\n\n\t\t\t\t\t} else if (speed === \"rewind\") {\n\t\t\t\t\t\tbase.swapSpeed(base.options.rewindSpeed);\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.rewindSpeed);\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.swapSpeed(\"slideSpeed\");\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.isCss3Finish = true;\n\t\t\t\t\t\t}, base.options.slideSpeed);\n\t\t\t\t\t}\n\t\t\t\t\tbase.transition3d(goToPixel);\n\t\t\t\t} else {\n\t\t\t\t\tif (speed === true) {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.paginationSpeed);\n\t\t\t\t\t} else if (speed === \"rewind\") {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.rewindSpeed);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2slide(goToPixel, base.options.slideSpeed);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.afterGo();\n\t\t\t},\n\n\t\t\tjumpTo : function (position) {\n\t\t\t\tvar base = this;\n\t\t\t\tif (typeof base.options.beforeMove === \"function\") {\n\t\t\t\t\tbase.options.beforeMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t\tif (position >= base.maximumItem || position === -1) {\n\t\t\t\t\tposition = base.maximumItem;\n\t\t\t\t} else if (position <= 0) {\n\t\t\t\t\tposition = 0;\n\t\t\t\t}\n\t\t\t\tbase.swapSpeed(0);\n\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\tbase.transition3d(base.positionsInArray[position]);\n\t\t\t\t} else {\n\t\t\t\t\tbase.css2slide(base.positionsInArray[position], 1);\n\t\t\t\t}\n\t\t\t\tbase.currentItem = base.owl.currentItem = position;\n\t\t\t\tbase.afterGo();\n\t\t\t},\n\n\t\t\tafterGo : function () {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.prevArr.push(base.currentItem);\n\t\t\t\tbase.prevItem = base.owl.prevItem = base.prevArr[base.prevArr.length - 2];\n\t\t\t\tbase.prevArr.shift(0);\n\n\t\t\t\tif (base.prevItem !== base.currentItem) {\n\t\t\t\t\tbase.checkPagination();\n\t\t\t\t\tbase.checkNavigation();\n\t\t\t\t\tbase.eachMoveUpdate();\n\n\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\tbase.checkAp();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (typeof base.options.afterMove === \"function\" && base.prevItem !== base.currentItem) {\n\t\t\t\t\tbase.options.afterMove.apply(this, [base.$elem]);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tstop : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.apStatus = \"stop\";\n\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t},\n\n\t\t\tcheckAp : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.apStatus !== \"stop\") {\n\t\t\t\t\tbase.play();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tplay : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.apStatus = \"play\";\n\t\t\t\tif (base.options.autoPlay === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\tbase.autoPlayInterval = window.setInterval(function () {\n\t\t\t\t\tbase.next(true);\n\t\t\t\t}, base.options.autoPlay);\n\t\t\t},\n\n\t\t\tswapSpeed : function (action) {\n\t\t\t\tvar base = this;\n\t\t\t\tif (action === \"slideSpeed\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(base.options.slideSpeed));\n\t\t\t\t} else if (action === \"paginationSpeed\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(base.options.paginationSpeed));\n\t\t\t\t} else if (typeof action !== \"string\") {\n\t\t\t\t\tbase.$owlWrapper.css(base.addCssSpeed(action));\n\t\t\t\t}\n\t\t\t},\n\n\t\t\taddCssSpeed : function (speed) {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"-moz-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"-o-transition\": \"all \" + speed + \"ms ease\",\n\t\t\t\t\t\"transition\": \"all \" + speed + \"ms ease\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tremoveTransition : function () {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transition\": \"\",\n\t\t\t\t\t\"-moz-transition\": \"\",\n\t\t\t\t\t\"-o-transition\": \"\",\n\t\t\t\t\t\"transition\": \"\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tdoTranslate : function (pixels) {\n\t\t\t\treturn {\n\t\t\t\t\t\"-webkit-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-moz-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-o-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"-ms-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n\t\t\t\t\t\"transform\": \"translate3d(\" + pixels + \"px, 0px,0px)\"\n\t\t\t\t};\n\t\t\t},\n\n\t\t\ttransition3d : function (value) {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$owlWrapper.css(base.doTranslate(value));\n\t\t\t},\n\n\t\t\tcss2move : function (value) {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$owlWrapper.css({\"left\" : value});\n\t\t\t},\n\n\t\t\tcss2slide : function (value, speed) {\n\t\t\t\tvar base = this;\n\n\t\t\t\tbase.isCssFinish = false;\n\t\t\t\tbase.$owlWrapper.stop(true, true).animate({\n\t\t\t\t\t\"left\" : value\n\t\t\t\t}, {\n\t\t\t\t\tduration : speed || base.options.slideSpeed,\n\t\t\t\t\tcomplete : function () {\n\t\t\t\t\t\tbase.isCssFinish = true;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tcheckBrowser : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ttranslate3D = \"translate3d(0px, 0px, 0px)\",\n\t\t\t\t\ttempElem = document.createElement(\"div\"),\n\t\t\t\t\tregex,\n\t\t\t\t\tasSupport,\n\t\t\t\t\tsupport3d,\n\t\t\t\t\tisTouch;\n\n\t\t\t\ttempElem.style.cssText = \"  -moz-transform:\" + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -ms-transform:\"     + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -o-transform:\"      + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; -webkit-transform:\" + translate3D +\n\t\t\t\t\t\t\t\t\t  \"; transform:\"         + translate3D;\n\t\t\t\tregex = /translate3d\\(0px, 0px, 0px\\)/g;\n\t\t\t\tasSupport = tempElem.style.cssText.match(regex);\n\t\t\t\tsupport3d = (asSupport !== null && asSupport.length === 1);\n\n\t\t\t\tisTouch = \"ontouchstart\" in window || window.navigator.msMaxTouchPoints;\n\n\t\t\t\tbase.browser = {\n\t\t\t\t\t\"support3d\" : support3d,\n\t\t\t\t\t\"isTouch\" : isTouch\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tmoveEvents : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.mouseDrag !== false || base.options.touchDrag !== false) {\n\t\t\t\t\tbase.gestures();\n\t\t\t\t\tbase.disabledEvents();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\teventTypes : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ttypes = [\"s\", \"e\", \"x\"];\n\n\t\t\t\tbase.ev_types = {};\n\n\t\t\t\tif (base.options.mouseDrag === true && base.options.touchDrag === true) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"touchstart.owl mousedown.owl\",\n\t\t\t\t\t\t\"touchmove.owl mousemove.owl\",\n\t\t\t\t\t\t\"touchend.owl touchcancel.owl mouseup.owl\"\n\t\t\t\t\t];\n\t\t\t\t} else if (base.options.mouseDrag === false && base.options.touchDrag === true) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"touchstart.owl\",\n\t\t\t\t\t\t\"touchmove.owl\",\n\t\t\t\t\t\t\"touchend.owl touchcancel.owl\"\n\t\t\t\t\t];\n\t\t\t\t} else if (base.options.mouseDrag === true && base.options.touchDrag === false) {\n\t\t\t\t\ttypes = [\n\t\t\t\t\t\t\"mousedown.owl\",\n\t\t\t\t\t\t\"mousemove.owl\",\n\t\t\t\t\t\t\"mouseup.owl\"\n\t\t\t\t\t];\n\t\t\t\t}\n\n\t\t\t\tbase.ev_types.start = types[0];\n\t\t\t\tbase.ev_types.move = types[1];\n\t\t\t\tbase.ev_types.end = types[2];\n\t\t\t},\n\n\t\t\tdisabledEvents :  function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.on(\"dragstart.owl\", function (event) { event.preventDefault(); });\n\t\t\t\tbase.$elem.on(\"mousedown.disableTextSelect\", function (e) {\n\t\t\t\t\treturn $(e.target).is('input, textarea, select, option');\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tgestures : function () {\n\t\t\t\t/*jslint unparam: true*/\n\t\t\t\tvar base = this,\n\t\t\t\t\tlocals = {\n\t\t\t\t\t\toffsetX : 0,\n\t\t\t\t\t\toffsetY : 0,\n\t\t\t\t\t\tbaseElWidth : 0,\n\t\t\t\t\t\trelativePos : 0,\n\t\t\t\t\t\tposition: null,\n\t\t\t\t\t\tminSwipe : null,\n\t\t\t\t\t\tmaxSwipe: null,\n\t\t\t\t\t\tsliding : null,\n\t\t\t\t\t\tdargging: null,\n\t\t\t\t\t\ttargetElement : null\n\t\t\t\t\t};\n\n\t\t\t\tbase.isCssFinish = true;\n\n\t\t\t\tfunction getTouches(event) {\n\t\t\t\t\tif (event.touches !== undefined) {\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tx : event.touches[0].pageX,\n\t\t\t\t\t\t\ty : event.touches[0].pageY\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tif (event.touches === undefined) {\n\t\t\t\t\t\tif (event.pageX !== undefined) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tx : event.pageX,\n\t\t\t\t\t\t\t\ty : event.pageY\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (event.pageX === undefined) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tx : event.clientX,\n\t\t\t\t\t\t\t\ty : event.clientY\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction swapEvents(type) {\n\t\t\t\t\tif (type === \"on\") {\n\t\t\t\t\t\t$(document).on(base.ev_types.move, dragMove);\n\t\t\t\t\t\t$(document).on(base.ev_types.end, dragEnd);\n\t\t\t\t\t} else if (type === \"off\") {\n\t\t\t\t\t\t$(document).off(base.ev_types.move);\n\t\t\t\t\t\t$(document).off(base.ev_types.end);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction dragStart(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tposition;\n\n\t\t\t\t\tif (ev.which === 3) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.itemsAmount <= base.options.items) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.isCssFinish === false && !base.options.dragBeforeAnimFinish) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif (base.isCss3Finish === false && !base.options.dragBeforeAnimFinish) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.options.autoPlay !== false) {\n\t\t\t\t\t\twindow.clearInterval(base.autoPlayInterval);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.browser.isTouch !== true && !base.$owlWrapper.hasClass(\"grabbing\")) {\n\t\t\t\t\t\tbase.$owlWrapper.addClass(\"grabbing\");\n\t\t\t\t\t}\n\n\t\t\t\t\tbase.newPosX = 0;\n\t\t\t\t\tbase.newRelativeX = 0;\n\n\t\t\t\t\t$(this).css(base.removeTransition());\n\n\t\t\t\t\tposition = $(this).position();\n\t\t\t\t\tlocals.relativePos = position.left;\n\n\t\t\t\t\tlocals.offsetX = getTouches(ev).x - position.left;\n\t\t\t\t\tlocals.offsetY = getTouches(ev).y - position.top;\n\n\t\t\t\t\tswapEvents(\"on\");\n\n\t\t\t\t\tlocals.sliding = false;\n\t\t\t\t\tlocals.targetElement = ev.target || ev.srcElement;\n\t\t\t\t}\n\n\t\t\t\tfunction dragMove(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tminSwipe,\n\t\t\t\t\t\tmaxSwipe;\n\n\t\t\t\t\tbase.newPosX = getTouches(ev).x - locals.offsetX;\n\t\t\t\t\tbase.newPosY = getTouches(ev).y - locals.offsetY;\n\t\t\t\t\tbase.newRelativeX = base.newPosX - locals.relativePos;\n\n\t\t\t\t\tif (typeof base.options.startDragging === \"function\" && locals.dragging !== true && base.newRelativeX !== 0) {\n\t\t\t\t\t\tlocals.dragging = true;\n\t\t\t\t\t\tbase.options.startDragging.apply(base, [base.$elem]);\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((base.newRelativeX > 8 || base.newRelativeX < -8) && (base.browser.isTouch === true)) {\n\t\t\t\t\t\tif (ev.preventDefault !== undefined) {\n\t\t\t\t\t\t\tev.preventDefault();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tev.returnValue = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tlocals.sliding = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((base.newPosY > 10 || base.newPosY < -10) && locals.sliding === false) {\n\t\t\t\t\t\t$(document).off(\"touchmove.owl\");\n\t\t\t\t\t}\n\n\t\t\t\t\tminSwipe = function () {\n\t\t\t\t\t\treturn base.newRelativeX / 5;\n\t\t\t\t\t};\n\n\t\t\t\t\tmaxSwipe = function () {\n\t\t\t\t\t\treturn base.maximumPixels + base.newRelativeX / 5;\n\t\t\t\t\t};\n\n\t\t\t\t\tbase.newPosX = Math.max(Math.min(base.newPosX, minSwipe()), maxSwipe());\n\t\t\t\t\tif (base.browser.support3d === true) {\n\t\t\t\t\t\tbase.transition3d(base.newPosX);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.css2move(base.newPosX);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction dragEnd(event) {\n\t\t\t\t\tvar ev = event.originalEvent || event || window.event,\n\t\t\t\t\t\tnewPosition,\n\t\t\t\t\t\thandlers,\n\t\t\t\t\t\towlStopEvent;\n\n\t\t\t\t\tev.target = ev.target || ev.srcElement;\n\n\t\t\t\t\tlocals.dragging = false;\n\n\t\t\t\t\tif (base.browser.isTouch !== true) {\n\t\t\t\t\t\tbase.$owlWrapper.removeClass(\"grabbing\");\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.newRelativeX < 0) {\n\t\t\t\t\t\tbase.dragDirection = base.owl.dragDirection = \"left\";\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.dragDirection = base.owl.dragDirection = \"right\";\n\t\t\t\t\t}\n\n\t\t\t\t\tif (base.newRelativeX !== 0) {\n\t\t\t\t\t\tnewPosition = base.getNewPosition();\n\t\t\t\t\t\tbase.goTo(newPosition, false, \"drag\");\n\t\t\t\t\t\tif (locals.targetElement === ev.target && base.browser.isTouch !== true) {\n\t\t\t\t\t\t\t$(ev.target).on(\"click.disable\", function (ev) {\n\t\t\t\t\t\t\t\tev.stopImmediatePropagation();\n\t\t\t\t\t\t\t\tev.stopPropagation();\n\t\t\t\t\t\t\t\tev.preventDefault();\n\t\t\t\t\t\t\t\t$(ev.target).off(\"click.disable\");\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\thandlers = $._data(ev.target, \"events\").click;\n\t\t\t\t\t\t\towlStopEvent = handlers.pop();\n\t\t\t\t\t\t\thandlers.splice(0, 0, owlStopEvent);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tswapEvents(\"off\");\n\t\t\t\t}\n\t\t\t\tbase.$elem.on(base.ev_types.start, \".owl-wrapper\", dragStart);\n\t\t\t},\n\n\t\t\tgetNewPosition : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tnewPosition = base.closestItem();\n\n\t\t\t\tif (newPosition > base.maximumItem) {\n\t\t\t\t\tbase.currentItem = base.maximumItem;\n\t\t\t\t\tnewPosition  = base.maximumItem;\n\t\t\t\t} else if (base.newPosX >= 0) {\n\t\t\t\t\tnewPosition = 0;\n\t\t\t\t\tbase.currentItem = 0;\n\t\t\t\t}\n\t\t\t\treturn newPosition;\n\t\t\t},\n\t\t\tclosestItem : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tarray = base.options.scrollPerPage === true ? base.pagesInArray : base.positionsInArray,\n\t\t\t\t\tgoal = base.newPosX,\n\t\t\t\t\tclosest = null;\n\n\t\t\t\t$.each(array, function (i, v) {\n\t\t\t\t\tif (goal - (base.itemWidth / 20) > array[i + 1] && goal - (base.itemWidth / 20) < v && base.moveDirection() === \"left\") {\n\t\t\t\t\t\tclosest = v;\n\t\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\t\tbase.currentItem = $.inArray(closest, base.positionsInArray);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tbase.currentItem = i;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if (goal + (base.itemWidth / 20) < v && goal + (base.itemWidth / 20) > (array[i + 1] || array[i] - base.itemWidth) && base.moveDirection() === \"right\") {\n\t\t\t\t\t\tif (base.options.scrollPerPage === true) {\n\t\t\t\t\t\t\tclosest = array[i + 1] || array[array.length - 1];\n\t\t\t\t\t\t\tbase.currentItem = $.inArray(closest, base.positionsInArray);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tclosest = array[i + 1];\n\t\t\t\t\t\t\tbase.currentItem = i + 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn base.currentItem;\n\t\t\t},\n\n\t\t\tmoveDirection : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\tdirection;\n\t\t\t\tif (base.newRelativeX < 0) {\n\t\t\t\t\tdirection = \"right\";\n\t\t\t\t\tbase.playDirection = \"next\";\n\t\t\t\t} else {\n\t\t\t\t\tdirection = \"left\";\n\t\t\t\t\tbase.playDirection = \"prev\";\n\t\t\t\t}\n\t\t\t\treturn direction;\n\t\t\t},\n\n\t\t\tcustomEvents : function () {\n\t\t\t\t/*jslint unparam: true*/\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.on(\"owl.next\", function () {\n\t\t\t\t\tbase.next();\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.prev\", function () {\n\t\t\t\t\tbase.prev();\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.play\", function (event, speed) {\n\t\t\t\t\tbase.options.autoPlay = speed;\n\t\t\t\t\tbase.play();\n\t\t\t\t\tbase.hoverStatus = \"play\";\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.stop\", function () {\n\t\t\t\t\tbase.stop();\n\t\t\t\t\tbase.hoverStatus = \"stop\";\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.goTo\", function (event, item) {\n\t\t\t\t\tbase.goTo(item);\n\t\t\t\t});\n\t\t\t\tbase.$elem.on(\"owl.jumpTo\", function (event, item) {\n\t\t\t\t\tbase.jumpTo(item);\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tstopOnHover : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.options.stopOnHover === true && base.browser.isTouch !== true && base.options.autoPlay !== false) {\n\t\t\t\t\tbase.$elem.on(\"mouseover\", function () {\n\t\t\t\t\t\tbase.stop();\n\t\t\t\t\t});\n\t\t\t\t\tbase.$elem.on(\"mouseout\", function () {\n\t\t\t\t\t\tif (base.hoverStatus !== \"stop\") {\n\t\t\t\t\t\t\tbase.play();\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlazyLoad : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ti,\n\t\t\t\t\t$item,\n\t\t\t\t\titemNumber,\n\t\t\t\t\t$lazyImg,\n\t\t\t\t\tfollow;\n\n\t\t\t\tif (base.options.lazyLoad === false) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tfor (i = 0; i < base.itemsAmount; i += 1) {\n\t\t\t\t\t$item = $(base.$owlItems[i]);\n\n\t\t\t\t\tif ($item.data(\"owl-loaded\") === \"loaded\") {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\titemNumber = $item.data(\"owl-item\");\n\t\t\t\t\t$lazyImg = $item.find(\".lazyOwl\");\n\n\t\t\t\t\tif (typeof $lazyImg.data(\"src\") !== \"string\") {\n\t\t\t\t\t\t$item.data(\"owl-loaded\", \"loaded\");\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t\tif ($item.data(\"owl-loaded\") === undefined) {\n\t\t\t\t\t\t$lazyImg.hide();\n\t\t\t\t\t\t$item.addClass(\"loading\").data(\"owl-loaded\", \"checked\");\n\t\t\t\t\t}\n\t\t\t\t\tif (base.options.lazyFollow === true) {\n\t\t\t\t\t\tfollow = itemNumber >= base.currentItem;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfollow = true;\n\t\t\t\t\t}\n\t\t\t\t\tif (follow && itemNumber < base.currentItem + base.options.items && $lazyImg.length) {\n\t\t\t\t\t\tbase.lazyPreload($item, $lazyImg);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlazyPreload : function ($item, $lazyImg) {\n\t\t\t\tvar base = this,\n\t\t\t\t\titerations = 0,\n\t\t\t\t\tisBackgroundImg;\n\n\t\t\t\tif ($lazyImg.prop(\"tagName\") === \"DIV\") {\n\t\t\t\t\t$lazyImg.css(\"background-image\", \"url(\" + $lazyImg.data(\"src\") + \")\");\n\t\t\t\t\tisBackgroundImg = true;\n\t\t\t\t} else {\n\t\t\t\t\t$lazyImg[0].src = $lazyImg.data(\"src\");\n\t\t\t\t}\n\n\t\t\t\tfunction showImage() {\n\t\t\t\t\t$item.data(\"owl-loaded\", \"loaded\").removeClass(\"loading\");\n\t\t\t\t\t$lazyImg.removeAttr(\"data-src\");\n\t\t\t\t\tif (base.options.lazyEffect === \"fade\") {\n\t\t\t\t\t\t$lazyImg.fadeIn(400);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t$lazyImg.show();\n\t\t\t\t\t}\n\t\t\t\t\tif (typeof base.options.afterLazyLoad === \"function\") {\n\t\t\t\t\t\tbase.options.afterLazyLoad.apply(this, [base.$elem]);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction checkLazyImage() {\n\t\t\t\t\titerations += 1;\n\t\t\t\t\tif (base.completeImg($lazyImg.get(0)) || isBackgroundImg === true) {\n\t\t\t\t\t\tshowImage();\n\t\t\t\t\t} else if (iterations <= 100) {//if image loads in less than 10 seconds \n\t\t\t\t\t\twindow.setTimeout(checkLazyImage, 100);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tshowImage();\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tcheckLazyImage();\n\t\t\t},\n\n\t\t\tautoHeight : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\t$currentimg = $(base.$owlItems[base.currentItem]).find(\"img\"),\n\t\t\t\t\titerations;\n\n\t\t\t\tfunction addHeight() {\n\t\t\t\t\tvar $currentItem = $(base.$owlItems[base.currentItem]).height();\n\t\t\t\t\tbase.wrapperOuter.css(\"height\", $currentItem + \"px\");\n\t\t\t\t\tif (!base.wrapperOuter.hasClass(\"autoHeight\")) {\n\t\t\t\t\t\twindow.setTimeout(function () {\n\t\t\t\t\t\t\tbase.wrapperOuter.addClass(\"autoHeight\");\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfunction checkImage() {\n\t\t\t\t\titerations += 1;\n\t\t\t\t\tif (base.completeImg($currentimg.get(0))) {\n\t\t\t\t\t\taddHeight();\n\t\t\t\t\t} else if (iterations <= 100) { //if image loads in less than 10 seconds \n\t\t\t\t\t\twindow.setTimeout(checkImage, 100);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tbase.wrapperOuter.css(\"height\", \"\"); //Else remove height attribute\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ($currentimg.get(0) !== undefined) {\n\t\t\t\t\titerations = 0;\n\t\t\t\t\tcheckImage();\n\t\t\t\t} else {\n\t\t\t\t\taddHeight();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tcompleteImg : function (img) {\n\t\t\t\tvar naturalWidthType;\n\n\t\t\t\tif (!img.complete) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tnaturalWidthType = typeof img.naturalWidth;\n\t\t\t\tif (naturalWidthType !== \"undefined\" && img.naturalWidth === 0) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\n\t\t\tonVisibleItems : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\ti;\n\n\t\t\t\tif (base.options.addClassActive === true) {\n\t\t\t\t\tbase.$owlItems.removeClass(\"active\");\n\t\t\t\t}\n\t\t\t\tbase.visibleItems = [];\n\t\t\t\tfor (i = base.currentItem; i < base.currentItem + base.options.items; i += 1) {\n\t\t\t\t\tbase.visibleItems.push(i);\n\n\t\t\t\t\tif (base.options.addClassActive === true) {\n\t\t\t\t\t\t$(base.$owlItems[i]).addClass(\"active\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.owl.visibleItems = base.visibleItems;\n\t\t\t},\n\n\t\t\ttransitionTypes : function (className) {\n\t\t\t\tvar base = this;\n\t\t\t\t//Currently available: \"fade\", \"backSlide\", \"goDown\", \"fadeUp\"\n\t\t\t\tbase.outClass = \"owl-\" + className + \"-out\";\n\t\t\t\tbase.inClass = \"owl-\" + className + \"-in\";\n\t\t\t},\n\n\t\t\tsingleItemTransition : function () {\n\t\t\t\tvar base = this,\n\t\t\t\t\toutClass = base.outClass,\n\t\t\t\t\tinClass = base.inClass,\n\t\t\t\t\t$currentItem = base.$owlItems.eq(base.currentItem),\n\t\t\t\t\t$prevItem = base.$owlItems.eq(base.prevItem),\n\t\t\t\t\tprevPos = Math.abs(base.positionsInArray[base.currentItem]) + base.positionsInArray[base.prevItem],\n\t\t\t\t\torigin = Math.abs(base.positionsInArray[base.currentItem]) + base.itemWidth / 2,\n\t\t\t\t\tanimEnd = 'webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend';\n\n\t\t\t\tbase.isTransition = true;\n\n\t\t\t\tbase.$owlWrapper\n\t\t\t\t\t.addClass('owl-origin')\n\t\t\t\t\t.css({\n\t\t\t\t\t\t\"-webkit-transform-origin\" : origin + \"px\",\n\t\t\t\t\t\t\"-moz-perspective-origin\" : origin + \"px\",\n\t\t\t\t\t\t\"perspective-origin\" : origin + \"px\"\n\t\t\t\t\t});\n\t\t\t\tfunction transStyles(prevPos) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\t\"position\" : \"relative\",\n\t\t\t\t\t\t\"left\" : prevPos + \"px\"\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t$prevItem\n\t\t\t\t\t.css(transStyles(prevPos, 10))\n\t\t\t\t\t.addClass(outClass)\n\t\t\t\t\t.on(animEnd, function () {\n\t\t\t\t\t\tbase.endPrev = true;\n\t\t\t\t\t\t$prevItem.off(animEnd);\n\t\t\t\t\t\tbase.clearTransStyle($prevItem, outClass);\n\t\t\t\t\t});\n\n\t\t\t\t$currentItem\n\t\t\t\t\t.addClass(inClass)\n\t\t\t\t\t.on(animEnd, function () {\n\t\t\t\t\t\tbase.endCurrent = true;\n\t\t\t\t\t\t$currentItem.off(animEnd);\n\t\t\t\t\t\tbase.clearTransStyle($currentItem, inClass);\n\t\t\t\t\t});\n\t\t\t},\n\n\t\t\tclearTransStyle : function (item, classToRemove) {\n\t\t\t\tvar base = this;\n\t\t\t\titem.css({\n\t\t\t\t\t\"position\" : \"\",\n\t\t\t\t\t\"left\" : \"\"\n\t\t\t\t}).removeClass(classToRemove);\n\n\t\t\t\tif (base.endPrev && base.endCurrent) {\n\t\t\t\t\tbase.$owlWrapper.removeClass('owl-origin');\n\t\t\t\t\tbase.endPrev = false;\n\t\t\t\t\tbase.endCurrent = false;\n\t\t\t\t\tbase.isTransition = false;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\towlStatus : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.owl = {\n\t\t\t\t\t\"userOptions\"   : base.userOptions,\n\t\t\t\t\t\"baseElement\"   : base.$elem,\n\t\t\t\t\t\"userItems\"     : base.$userItems,\n\t\t\t\t\t\"owlItems\"      : base.$owlItems,\n\t\t\t\t\t\"currentItem\"   : base.currentItem,\n\t\t\t\t\t\"prevItem\"      : base.prevItem,\n\t\t\t\t\t\"visibleItems\"  : base.visibleItems,\n\t\t\t\t\t\"isTouch\"       : base.browser.isTouch,\n\t\t\t\t\t\"browser\"       : base.browser,\n\t\t\t\t\t\"dragDirection\" : base.dragDirection\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tclearEvents : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.$elem.off(\".owl owl mousedown.disableTextSelect\");\n\t\t\t\t$(document).off(\".owl owl\");\n\t\t\t\t$(window).off(\"resize\", base.resizer);\n\t\t\t},\n\n\t\t\tunWrap : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tif (base.$elem.children().length !== 0) {\n\t\t\t\t\tbase.$owlWrapper.unwrap();\n\t\t\t\t\tbase.$userItems.unwrap().unwrap();\n\t\t\t\t\tif (base.owlControls) {\n\t\t\t\t\t\tbase.owlControls.remove();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbase.clearEvents();\n\t\t\t\tbase.$elem\n\t\t\t\t\t.attr(\"style\", base.$elem.data(\"owl-originalStyles\") || \"\")\n\t\t\t\t\t.attr(\"class\", base.$elem.data(\"owl-originalClasses\"));\n\t\t\t},\n\n\t\t\tdestroy : function () {\n\t\t\t\tvar base = this;\n\t\t\t\tbase.stop();\n\t\t\t\twindow.clearInterval(base.checkVisible);\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.$elem.removeData();\n\t\t\t},\n\n\t\t\treinit : function (newOptions) {\n\t\t\t\tvar base = this,\n\t\t\t\t\toptions = $.extend({}, base.userOptions, newOptions);\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.init(options, base.$elem);\n\t\t\t},\n\n\t\t\taddItem : function (htmlString, targetPosition) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tposition;\n\n\t\t\t\tif (!htmlString) {return false; }\n\n\t\t\t\tif (base.$elem.children().length === 0) {\n\t\t\t\t\tbase.$elem.append(htmlString);\n\t\t\t\t\tbase.setVars();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tbase.unWrap();\n\t\t\t\tif (targetPosition === undefined || targetPosition === -1) {\n\t\t\t\t\tposition = -1;\n\t\t\t\t} else {\n\t\t\t\t\tposition = targetPosition;\n\t\t\t\t}\n\t\t\t\tif (position >= base.$userItems.length || position === -1) {\n\t\t\t\t\tbase.$userItems.eq(-1).after(htmlString);\n\t\t\t\t} else {\n\t\t\t\t\tbase.$userItems.eq(position).before(htmlString);\n\t\t\t\t}\n\n\t\t\t\tbase.setVars();\n\t\t\t},\n\n\t\t\tremoveItem : function (targetPosition) {\n\t\t\t\tvar base = this,\n\t\t\t\t\tposition;\n\n\t\t\t\tif (base.$elem.children().length === 0) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (targetPosition === undefined || targetPosition === -1) {\n\t\t\t\t\tposition = -1;\n\t\t\t\t} else {\n\t\t\t\t\tposition = targetPosition;\n\t\t\t\t}\n\n\t\t\t\tbase.unWrap();\n\t\t\t\tbase.$userItems.eq(position).remove();\n\t\t\t\tbase.setVars();\n\t\t\t}\n\n\t\t};\n\n\t\t$.fn.owlCarousel = function (options) {\n\t\t\treturn this.each(function () {\n\t\t\t\tif ($(this).data(\"owl-init\") === true) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\t$(this).data(\"owl-init\", true);\n\t\t\t\tvar carousel = Object.create(Carousel);\n\t\t\t\tcarousel.init(options, this);\n\t\t\t\t$.data(this, \"owlCarousel\", carousel);\n\t\t\t});\n\t\t};\n\n\t\t$.fn.owlCarousel.options = {\n\n\t\t\titems : 5,\n\t\t\titemsCustom : false,\n\t\t\titemsDesktop : [1199, 4],\n\t\t\titemsDesktopSmall : [979, 3],\n\t\t\titemsTablet : [768, 2],\n\t\t\titemsTabletSmall : false,\n\t\t\titemsMobile : [479, 1],\n\t\t\tsingleItem : false,\n\t\t\titemsScaleUp : false,\n\n\t\t\tslideSpeed : 200,\n\t\t\tpaginationSpeed : 800,\n\t\t\trewindSpeed : 1000,\n\n\t\t\tautoPlay : false,\n\t\t\tstopOnHover : false,\n\n\t\t\tnavigation : false,\n\t\t\tnavigationText : [\"prev\", \"next\"],\n\t\t\trewindNav : true,\n\t\t\tscrollPerPage : false,\n\n\t\t\tpagination : true,\n\t\t\tpaginationNumbers : false,\n\n\t\t\tresponsive : true,\n\t\t\tresponsiveRefreshRate : 200,\n\t\t\tresponsiveBaseWidth : window,\n\n\t\t\tbaseClass : \"owl-carousel\",\n\t\t\ttheme : \"owl-theme\",\n\n\t\t\tlazyLoad : false,\n\t\t\tlazyFollow : true,\n\t\t\tlazyEffect : \"fade\",\n\n\t\t\tautoHeight : false,\n\n\t\t\tjsonPath : false,\n\t\t\tjsonSuccess : false,\n\n\t\t\tdragBeforeAnimFinish : true,\n\t\t\tmouseDrag : true,\n\t\t\ttouchDrag : true,\n\n\t\t\taddClassActive : false,\n\t\t\ttransitionStyle : false,\n\n\t\t\tbeforeUpdate : false,\n\t\t\tafterUpdate : false,\n\t\t\tbeforeInit : false,\n\t\t\tafterInit : false,\n\t\t\tbeforeMove : false,\n\t\t\tafterMove : false,\n\t\t\tafterAction : false,\n\t\t\tstartDragging : false,\n\t\t\tafterLazyLoad: false\n\t\t};\n\t}($, window, document));\n});\n","Plazathemes_Categorytop/js/jquery-1.9.1.min.js":"/*! jQuery v1.9.1 | (c) 2005, 2012 jQuery Foundation, Inc. | jquery.org/license\n//@ sourceMappingURL=jquery.min.map\n*/(function(e,t){var n,r,i=typeof t,o=e.document,a=e.location,s=e.jQuery,u=e.$,l={},c=[],p=\"1.9.1\",f=c.concat,d=c.push,h=c.slice,g=c.indexOf,m=l.toString,y=l.hasOwnProperty,v=p.trim,b=function(e,t){return new b.fn.init(e,t,r)},x=/[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/.source,w=/\\S+/g,T=/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,N=/^(?:(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,C=/^<(\\w+)\\s*\\/?>(?:<\\/\\1>|)$/,k=/^[\\],:{}\\s]*$/,E=/(?:^|:|,)(?:\\s*\\[)+/g,S=/\\\\(?:[\"\\\\\\/bfnrt]|u[\\da-fA-F]{4})/g,A=/\"[^\"\\\\\\r\\n]*\"|true|false|null|-?(?:\\d+\\.|)\\d+(?:[eE][+-]?\\d+|)/g,j=/^-ms-/,D=/-([\\da-z])/gi,L=function(e,t){return t.toUpperCase()},H=function(e){(o.addEventListener||\"load\"===e.type||\"complete\"===o.readyState)&&(q(),b.ready())},q=function(){o.addEventListener?(o.removeEventListener(\"DOMContentLoaded\",H,!1),e.removeEventListener(\"load\",H,!1)):(o.detachEvent(\"onreadystatechange\",H),e.detachEvent(\"onload\",H))};b.fn=b.prototype={jquery:p,constructor:b,init:function(e,n,r){var i,a;if(!e)return this;if(\"string\"==typeof e){if(i=\"<\"===e.charAt(0)&&\">\"===e.charAt(e.length-1)&&e.length>=3?[null,e,null]:N.exec(e),!i||!i[1]&&n)return!n||n.jquery?(n||r).find(e):this.constructor(n).find(e);if(i[1]){if(n=n instanceof b?n[0]:n,b.merge(this,b.parseHTML(i[1],n&&n.nodeType?n.ownerDocument||n:o,!0)),C.test(i[1])&&b.isPlainObject(n))for(i in n)b.isFunction(this[i])?this[i](n[i]):this.attr(i,n[i]);return this}if(a=o.getElementById(i[2]),a&&a.parentNode){if(a.id!==i[2])return r.find(e);this.length=1,this[0]=a}return this.context=o,this.selector=e,this}return e.nodeType?(this.context=this[0]=e,this.length=1,this):b.isFunction(e)?r.ready(e):(e.selector!==t&&(this.selector=e.selector,this.context=e.context),b.makeArray(e,this))},selector:\"\",length:0,size:function(){return this.length},toArray:function(){return h.call(this)},get:function(e){return null==e?this.toArray():0>e?this[this.length+e]:this[e]},pushStack:function(e){var t=b.merge(this.constructor(),e);return t.prevObject=this,t.context=this.context,t},each:function(e,t){return b.each(this,e,t)},ready:function(e){return b.ready.promise().done(e),this},slice:function(){return this.pushStack(h.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(0>e?t:0);return this.pushStack(n>=0&&t>n?[this[n]]:[])},map:function(e){return this.pushStack(b.map(this,function(t,n){return e.call(t,n,t)}))},end:function(){return this.prevObject||this.constructor(null)},push:d,sort:[].sort,splice:[].splice},b.fn.init.prototype=b.fn,b.extend=b.fn.extend=function(){var e,n,r,i,o,a,s=arguments[0]||{},u=1,l=arguments.length,c=!1;for(\"boolean\"==typeof s&&(c=s,s=arguments[1]||{},u=2),\"object\"==typeof s||b.isFunction(s)||(s={}),l===u&&(s=this,--u);l>u;u++)if(null!=(o=arguments[u]))for(i in o)e=s[i],r=o[i],s!==r&&(c&&r&&(b.isPlainObject(r)||(n=b.isArray(r)))?(n?(n=!1,a=e&&b.isArray(e)?e:[]):a=e&&b.isPlainObject(e)?e:{},s[i]=b.extend(c,a,r)):r!==t&&(s[i]=r));return s},b.extend({noConflict:function(t){return e.$===b&&(e.$=u),t&&e.jQuery===b&&(e.jQuery=s),b},isReady:!1,readyWait:1,holdReady:function(e){e?b.readyWait++:b.ready(!0)},ready:function(e){if(e===!0?!--b.readyWait:!b.isReady){if(!o.body)return setTimeout(b.ready);b.isReady=!0,e!==!0&&--b.readyWait>0||(n.resolveWith(o,[b]),b.fn.trigger&&b(o).trigger(\"ready\").off(\"ready\"))}},isFunction:function(e){return\"function\"===b.type(e)},isArray:Array.isArray||function(e){return\"array\"===b.type(e)},isWindow:function(e){return null!=e&&e==e.window},isNumeric:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},type:function(e){return null==e?e+\"\":\"object\"==typeof e||\"function\"==typeof e?l[m.call(e)]||\"object\":typeof e},isPlainObject:function(e){if(!e||\"object\"!==b.type(e)||e.nodeType||b.isWindow(e))return!1;try{if(e.constructor&&!y.call(e,\"constructor\")&&!y.call(e.constructor.prototype,\"isPrototypeOf\"))return!1}catch(n){return!1}var r;for(r in e);return r===t||y.call(e,r)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},error:function(e){throw Error(e)},parseHTML:function(e,t,n){if(!e||\"string\"!=typeof e)return null;\"boolean\"==typeof t&&(n=t,t=!1),t=t||o;var r=C.exec(e),i=!n&&[];return r?[t.createElement(r[1])]:(r=b.buildFragment([e],t,i),i&&b(i).remove(),b.merge([],r.childNodes))},parseJSON:function(n){return e.JSON&&e.JSON.parse?e.JSON.parse(n):null===n?n:\"string\"==typeof n&&(n=b.trim(n),n&&k.test(n.replace(S,\"@\").replace(A,\"]\").replace(E,\"\")))?Function(\"return \"+n)():(b.error(\"Invalid JSON: \"+n),t)},parseXML:function(n){var r,i;if(!n||\"string\"!=typeof n)return null;try{e.DOMParser?(i=new DOMParser,r=i.parseFromString(n,\"text/xml\")):(r=new ActiveXObject(\"Microsoft.XMLDOM\"),r.async=\"false\",r.loadXML(n))}catch(o){r=t}return r&&r.documentElement&&!r.getElementsByTagName(\"parsererror\").length||b.error(\"Invalid XML: \"+n),r},noop:function(){},globalEval:function(t){t&&b.trim(t)&&(e.execScript||function(t){e.eval.call(e,t)})(t)},camelCase:function(e){return e.replace(j,\"ms-\").replace(D,L)},nodeName:function(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()},each:function(e,t,n){var r,i=0,o=e.length,a=M(e);if(n){if(a){for(;o>i;i++)if(r=t.apply(e[i],n),r===!1)break}else for(i in e)if(r=t.apply(e[i],n),r===!1)break}else if(a){for(;o>i;i++)if(r=t.call(e[i],i,e[i]),r===!1)break}else for(i in e)if(r=t.call(e[i],i,e[i]),r===!1)break;return e},trim:v&&!v.call(\"\\ufeff\\u00a0\")?function(e){return null==e?\"\":v.call(e)}:function(e){return null==e?\"\":(e+\"\").replace(T,\"\")},makeArray:function(e,t){var n=t||[];return null!=e&&(M(Object(e))?b.merge(n,\"string\"==typeof e?[e]:e):d.call(n,e)),n},inArray:function(e,t,n){var r;if(t){if(g)return g.call(t,e,n);for(r=t.length,n=n?0>n?Math.max(0,r+n):n:0;r>n;n++)if(n in t&&t[n]===e)return n}return-1},merge:function(e,n){var r=n.length,i=e.length,o=0;if(\"number\"==typeof r)for(;r>o;o++)e[i++]=n[o];else while(n[o]!==t)e[i++]=n[o++];return e.length=i,e},grep:function(e,t,n){var r,i=[],o=0,a=e.length;for(n=!!n;a>o;o++)r=!!t(e[o],o),n!==r&&i.push(e[o]);return i},map:function(e,t,n){var r,i=0,o=e.length,a=M(e),s=[];if(a)for(;o>i;i++)r=t(e[i],i,n),null!=r&&(s[s.length]=r);else for(i in e)r=t(e[i],i,n),null!=r&&(s[s.length]=r);return f.apply([],s)},guid:1,proxy:function(e,n){var r,i,o;return\"string\"==typeof n&&(o=e[n],n=e,e=o),b.isFunction(e)?(r=h.call(arguments,2),i=function(){return e.apply(n||this,r.concat(h.call(arguments)))},i.guid=e.guid=e.guid||b.guid++,i):t},access:function(e,n,r,i,o,a,s){var u=0,l=e.length,c=null==r;if(\"object\"===b.type(r)){o=!0;for(u in r)b.access(e,n,u,r[u],!0,a,s)}else if(i!==t&&(o=!0,b.isFunction(i)||(s=!0),c&&(s?(n.call(e,i),n=null):(c=n,n=function(e,t,n){return c.call(b(e),n)})),n))for(;l>u;u++)n(e[u],r,s?i:i.call(e[u],u,n(e[u],r)));return o?e:c?n.call(e):l?n(e[0],r):a},now:function(){return(new Date).getTime()}}),b.ready.promise=function(t){if(!n)if(n=b.Deferred(),\"complete\"===o.readyState)setTimeout(b.ready);else if(o.addEventListener)o.addEventListener(\"DOMContentLoaded\",H,!1),e.addEventListener(\"load\",H,!1);else{o.attachEvent(\"onreadystatechange\",H),e.attachEvent(\"onload\",H);var r=!1;try{r=null==e.frameElement&&o.documentElement}catch(i){}r&&r.doScroll&&function a(){if(!b.isReady){try{r.doScroll(\"left\")}catch(e){return setTimeout(a,50)}q(),b.ready()}}()}return n.promise(t)},b.each(\"Boolean Number String Function Array Date RegExp Object Error\".split(\" \"),function(e,t){l[\"[object \"+t+\"]\"]=t.toLowerCase()});function M(e){var t=e.length,n=b.type(e);return b.isWindow(e)?!1:1===e.nodeType&&t?!0:\"array\"===n||\"function\"!==n&&(0===t||\"number\"==typeof t&&t>0&&t-1 in e)}r=b(o);var _={};function F(e){var t=_[e]={};return b.each(e.match(w)||[],function(e,n){t[n]=!0}),t}b.Callbacks=function(e){e=\"string\"==typeof e?_[e]||F(e):b.extend({},e);var n,r,i,o,a,s,u=[],l=!e.once&&[],c=function(t){for(r=e.memory&&t,i=!0,a=s||0,s=0,o=u.length,n=!0;u&&o>a;a++)if(u[a].apply(t[0],t[1])===!1&&e.stopOnFalse){r=!1;break}n=!1,u&&(l?l.length&&c(l.shift()):r?u=[]:p.disable())},p={add:function(){if(u){var t=u.length;(function i(t){b.each(t,function(t,n){var r=b.type(n);\"function\"===r?e.unique&&p.has(n)||u.push(n):n&&n.length&&\"string\"!==r&&i(n)})})(arguments),n?o=u.length:r&&(s=t,c(r))}return this},remove:function(){return u&&b.each(arguments,function(e,t){var r;while((r=b.inArray(t,u,r))>-1)u.splice(r,1),n&&(o>=r&&o--,a>=r&&a--)}),this},has:function(e){return e?b.inArray(e,u)>-1:!(!u||!u.length)},empty:function(){return u=[],this},disable:function(){return u=l=r=t,this},disabled:function(){return!u},lock:function(){return l=t,r||p.disable(),this},locked:function(){return!l},fireWith:function(e,t){return t=t||[],t=[e,t.slice?t.slice():t],!u||i&&!l||(n?l.push(t):c(t)),this},fire:function(){return p.fireWith(this,arguments),this},fired:function(){return!!i}};return p},b.extend({Deferred:function(e){var t=[[\"resolve\",\"done\",b.Callbacks(\"once memory\"),\"resolved\"],[\"reject\",\"fail\",b.Callbacks(\"once memory\"),\"rejected\"],[\"notify\",\"progress\",b.Callbacks(\"memory\")]],n=\"pending\",r={state:function(){return n},always:function(){return i.done(arguments).fail(arguments),this},then:function(){var e=arguments;return b.Deferred(function(n){b.each(t,function(t,o){var a=o[0],s=b.isFunction(e[t])&&e[t];i[o[1]](function(){var e=s&&s.apply(this,arguments);e&&b.isFunction(e.promise)?e.promise().done(n.resolve).fail(n.reject).progress(n.notify):n[a+\"With\"](this===r?n.promise():this,s?[e]:arguments)})}),e=null}).promise()},promise:function(e){return null!=e?b.extend(e,r):r}},i={};return r.pipe=r.then,b.each(t,function(e,o){var a=o[2],s=o[3];r[o[1]]=a.add,s&&a.add(function(){n=s},t[1^e][2].disable,t[2][2].lock),i[o[0]]=function(){return i[o[0]+\"With\"](this===i?r:this,arguments),this},i[o[0]+\"With\"]=a.fireWith}),r.promise(i),e&&e.call(i,i),i},when:function(e){var t=0,n=h.call(arguments),r=n.length,i=1!==r||e&&b.isFunction(e.promise)?r:0,o=1===i?e:b.Deferred(),a=function(e,t,n){return function(r){t[e]=this,n[e]=arguments.length>1?h.call(arguments):r,n===s?o.notifyWith(t,n):--i||o.resolveWith(t,n)}},s,u,l;if(r>1)for(s=Array(r),u=Array(r),l=Array(r);r>t;t++)n[t]&&b.isFunction(n[t].promise)?n[t].promise().done(a(t,l,n)).fail(o.reject).progress(a(t,u,s)):--i;return i||o.resolveWith(l,n),o.promise()}}),b.support=function(){var t,n,r,a,s,u,l,c,p,f,d=o.createElement(\"div\");if(d.setAttribute(\"className\",\"t\"),d.innerHTML=\"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\",n=d.getElementsByTagName(\"*\"),r=d.getElementsByTagName(\"a\")[0],!n||!r||!n.length)return{};s=o.createElement(\"select\"),l=s.appendChild(o.createElement(\"option\")),a=d.getElementsByTagName(\"input\")[0],r.style.cssText=\"top:1px;float:left;opacity:.5\",t={getSetAttribute:\"t\"!==d.className,leadingWhitespace:3===d.firstChild.nodeType,tbody:!d.getElementsByTagName(\"tbody\").length,htmlSerialize:!!d.getElementsByTagName(\"link\").length,style:/top/.test(r.getAttribute(\"style\")),hrefNormalized:\"/a\"===r.getAttribute(\"href\"),opacity:/^0.5/.test(r.style.opacity),cssFloat:!!r.style.cssFloat,checkOn:!!a.value,optSelected:l.selected,enctype:!!o.createElement(\"form\").enctype,html5Clone:\"<:nav></:nav>\"!==o.createElement(\"nav\").cloneNode(!0).outerHTML,boxModel:\"CSS1Compat\"===o.compatMode,deleteExpando:!0,noCloneEvent:!0,inlineBlockNeedsLayout:!1,shrinkWrapBlocks:!1,reliableMarginRight:!0,boxSizingReliable:!0,pixelPosition:!1},a.checked=!0,t.noCloneChecked=a.cloneNode(!0).checked,s.disabled=!0,t.optDisabled=!l.disabled;try{delete d.test}catch(h){t.deleteExpando=!1}a=o.createElement(\"input\"),a.setAttribute(\"value\",\"\"),t.input=\"\"===a.getAttribute(\"value\"),a.value=\"t\",a.setAttribute(\"type\",\"radio\"),t.radioValue=\"t\"===a.value,a.setAttribute(\"checked\",\"t\"),a.setAttribute(\"name\",\"t\"),u=o.createDocumentFragment(),u.appendChild(a),t.appendChecked=a.checked,t.checkClone=u.cloneNode(!0).cloneNode(!0).lastChild.checked,d.attachEvent&&(d.attachEvent(\"onclick\",function(){t.noCloneEvent=!1}),d.cloneNode(!0).click());for(f in{submit:!0,change:!0,focusin:!0})d.setAttribute(c=\"on\"+f,\"t\"),t[f+\"Bubbles\"]=c in e||d.attributes[c].expando===!1;return d.style.backgroundClip=\"content-box\",d.cloneNode(!0).style.backgroundClip=\"\",t.clearCloneStyle=\"content-box\"===d.style.backgroundClip,b(function(){var n,r,a,s=\"padding:0;margin:0;border:0;display:block;box-sizing:content-box;-moz-box-sizing:content-box;-webkit-box-sizing:content-box;\",u=o.getElementsByTagName(\"body\")[0];u&&(n=o.createElement(\"div\"),n.style.cssText=\"border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px\",u.appendChild(n).appendChild(d),d.innerHTML=\"<table><tr><td></td><td>t</td></tr></table>\",a=d.getElementsByTagName(\"td\"),a[0].style.cssText=\"padding:0;margin:0;border:0;display:none\",p=0===a[0].offsetHeight,a[0].style.display=\"\",a[1].style.display=\"none\",t.reliableHiddenOffsets=p&&0===a[0].offsetHeight,d.innerHTML=\"\",d.style.cssText=\"box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;\",t.boxSizing=4===d.offsetWidth,t.doesNotIncludeMarginInBodyOffset=1!==u.offsetTop,e.getComputedStyle&&(t.pixelPosition=\"1%\"!==(e.getComputedStyle(d,null)||{}).top,t.boxSizingReliable=\"4px\"===(e.getComputedStyle(d,null)||{width:\"4px\"}).width,r=d.appendChild(o.createElement(\"div\")),r.style.cssText=d.style.cssText=s,r.style.marginRight=r.style.width=\"0\",d.style.width=\"1px\",t.reliableMarginRight=!parseFloat((e.getComputedStyle(r,null)||{}).marginRight)),typeof d.style.zoom!==i&&(d.innerHTML=\"\",d.style.cssText=s+\"width:1px;padding:1px;display:inline;zoom:1\",t.inlineBlockNeedsLayout=3===d.offsetWidth,d.style.display=\"block\",d.innerHTML=\"<div></div>\",d.firstChild.style.width=\"5px\",t.shrinkWrapBlocks=3!==d.offsetWidth,t.inlineBlockNeedsLayout&&(u.style.zoom=1)),u.removeChild(n),n=d=a=r=null)}),n=s=u=l=r=a=null,t}();var O=/(?:\\{[\\s\\S]*\\}|\\[[\\s\\S]*\\])$/,B=/([A-Z])/g;function P(e,n,r,i){if(b.acceptData(e)){var o,a,s=b.expando,u=\"string\"==typeof n,l=e.nodeType,p=l?b.cache:e,f=l?e[s]:e[s]&&s;if(f&&p[f]&&(i||p[f].data)||!u||r!==t)return f||(l?e[s]=f=c.pop()||b.guid++:f=s),p[f]||(p[f]={},l||(p[f].toJSON=b.noop)),(\"object\"==typeof n||\"function\"==typeof n)&&(i?p[f]=b.extend(p[f],n):p[f].data=b.extend(p[f].data,n)),o=p[f],i||(o.data||(o.data={}),o=o.data),r!==t&&(o[b.camelCase(n)]=r),u?(a=o[n],null==a&&(a=o[b.camelCase(n)])):a=o,a}}function R(e,t,n){if(b.acceptData(e)){var r,i,o,a=e.nodeType,s=a?b.cache:e,u=a?e[b.expando]:b.expando;if(s[u]){if(t&&(o=n?s[u]:s[u].data)){b.isArray(t)?t=t.concat(b.map(t,b.camelCase)):t in o?t=[t]:(t=b.camelCase(t),t=t in o?[t]:t.split(\" \"));for(r=0,i=t.length;i>r;r++)delete o[t[r]];if(!(n?$:b.isEmptyObject)(o))return}(n||(delete s[u].data,$(s[u])))&&(a?b.cleanData([e],!0):b.support.deleteExpando||s!=s.window?delete s[u]:s[u]=null)}}}b.extend({cache:{},expando:\"jQuery\"+(p+Math.random()).replace(/\\D/g,\"\"),noData:{embed:!0,object:\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\",applet:!0},hasData:function(e){return e=e.nodeType?b.cache[e[b.expando]]:e[b.expando],!!e&&!$(e)},data:function(e,t,n){return P(e,t,n)},removeData:function(e,t){return R(e,t)},_data:function(e,t,n){return P(e,t,n,!0)},_removeData:function(e,t){return R(e,t,!0)},acceptData:function(e){if(e.nodeType&&1!==e.nodeType&&9!==e.nodeType)return!1;var t=e.nodeName&&b.noData[e.nodeName.toLowerCase()];return!t||t!==!0&&e.getAttribute(\"classid\")===t}}),b.fn.extend({data:function(e,n){var r,i,o=this[0],a=0,s=null;if(e===t){if(this.length&&(s=b.data(o),1===o.nodeType&&!b._data(o,\"parsedAttrs\"))){for(r=o.attributes;r.length>a;a++)i=r[a].name,i.indexOf(\"data-\")||(i=b.camelCase(i.slice(5)),W(o,i,s[i]));b._data(o,\"parsedAttrs\",!0)}return s}return\"object\"==typeof e?this.each(function(){b.data(this,e)}):b.access(this,function(n){return n===t?o?W(o,e,b.data(o,e)):null:(this.each(function(){b.data(this,e,n)}),t)},null,n,arguments.length>1,null,!0)},removeData:function(e){return this.each(function(){b.removeData(this,e)})}});function W(e,n,r){if(r===t&&1===e.nodeType){var i=\"data-\"+n.replace(B,\"-$1\").toLowerCase();if(r=e.getAttribute(i),\"string\"==typeof r){try{r=\"true\"===r?!0:\"false\"===r?!1:\"null\"===r?null:+r+\"\"===r?+r:O.test(r)?b.parseJSON(r):r}catch(o){}b.data(e,n,r)}else r=t}return r}function $(e){var t;for(t in e)if((\"data\"!==t||!b.isEmptyObject(e[t]))&&\"toJSON\"!==t)return!1;return!0}b.extend({queue:function(e,n,r){var i;return e?(n=(n||\"fx\")+\"queue\",i=b._data(e,n),r&&(!i||b.isArray(r)?i=b._data(e,n,b.makeArray(r)):i.push(r)),i||[]):t},dequeue:function(e,t){t=t||\"fx\";var n=b.queue(e,t),r=n.length,i=n.shift(),o=b._queueHooks(e,t),a=function(){b.dequeue(e,t)};\"inprogress\"===i&&(i=n.shift(),r--),o.cur=i,i&&(\"fx\"===t&&n.unshift(\"inprogress\"),delete o.stop,i.call(e,a,o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+\"queueHooks\";return b._data(e,n)||b._data(e,n,{empty:b.Callbacks(\"once memory\").add(function(){b._removeData(e,t+\"queue\"),b._removeData(e,n)})})}}),b.fn.extend({queue:function(e,n){var r=2;return\"string\"!=typeof e&&(n=e,e=\"fx\",r--),r>arguments.length?b.queue(this[0],e):n===t?this:this.each(function(){var t=b.queue(this,e,n);b._queueHooks(this,e),\"fx\"===e&&\"inprogress\"!==t[0]&&b.dequeue(this,e)})},dequeue:function(e){return this.each(function(){b.dequeue(this,e)})},delay:function(e,t){return e=b.fx?b.fx.speeds[e]||e:e,t=t||\"fx\",this.queue(t,function(t,n){var r=setTimeout(t,e);n.stop=function(){clearTimeout(r)}})},clearQueue:function(e){return this.queue(e||\"fx\",[])},promise:function(e,n){var r,i=1,o=b.Deferred(),a=this,s=this.length,u=function(){--i||o.resolveWith(a,[a])};\"string\"!=typeof e&&(n=e,e=t),e=e||\"fx\";while(s--)r=b._data(a[s],e+\"queueHooks\"),r&&r.empty&&(i++,r.empty.add(u));return u(),o.promise(n)}});var I,z,X=/[\\t\\r\\n]/g,U=/\\r/g,V=/^(?:input|select|textarea|button|object)$/i,Y=/^(?:a|area)$/i,J=/^(?:checked|selected|autofocus|autoplay|async|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped)$/i,G=/^(?:checked|selected)$/i,Q=b.support.getSetAttribute,K=b.support.input;b.fn.extend({attr:function(e,t){return b.access(this,b.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){b.removeAttr(this,e)})},prop:function(e,t){return b.access(this,b.prop,e,t,arguments.length>1)},removeProp:function(e){return e=b.propFix[e]||e,this.each(function(){try{this[e]=t,delete this[e]}catch(n){}})},addClass:function(e){var t,n,r,i,o,a=0,s=this.length,u=\"string\"==typeof e&&e;if(b.isFunction(e))return this.each(function(t){b(this).addClass(e.call(this,t,this.className))});if(u)for(t=(e||\"\").match(w)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(\" \"+n.className+\" \").replace(X,\" \"):\" \")){o=0;while(i=t[o++])0>r.indexOf(\" \"+i+\" \")&&(r+=i+\" \");n.className=b.trim(r)}return this},removeClass:function(e){var t,n,r,i,o,a=0,s=this.length,u=0===arguments.length||\"string\"==typeof e&&e;if(b.isFunction(e))return this.each(function(t){b(this).removeClass(e.call(this,t,this.className))});if(u)for(t=(e||\"\").match(w)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(\" \"+n.className+\" \").replace(X,\" \"):\"\")){o=0;while(i=t[o++])while(r.indexOf(\" \"+i+\" \")>=0)r=r.replace(\" \"+i+\" \",\" \");n.className=e?b.trim(r):\"\"}return this},toggleClass:function(e,t){var n=typeof e,r=\"boolean\"==typeof t;return b.isFunction(e)?this.each(function(n){b(this).toggleClass(e.call(this,n,this.className,t),t)}):this.each(function(){if(\"string\"===n){var o,a=0,s=b(this),u=t,l=e.match(w)||[];while(o=l[a++])u=r?u:!s.hasClass(o),s[u?\"addClass\":\"removeClass\"](o)}else(n===i||\"boolean\"===n)&&(this.className&&b._data(this,\"__className__\",this.className),this.className=this.className||e===!1?\"\":b._data(this,\"__className__\")||\"\")})},hasClass:function(e){var t=\" \"+e+\" \",n=0,r=this.length;for(;r>n;n++)if(1===this[n].nodeType&&(\" \"+this[n].className+\" \").replace(X,\" \").indexOf(t)>=0)return!0;return!1},val:function(e){var n,r,i,o=this[0];{if(arguments.length)return i=b.isFunction(e),this.each(function(n){var o,a=b(this);1===this.nodeType&&(o=i?e.call(this,n,a.val()):e,null==o?o=\"\":\"number\"==typeof o?o+=\"\":b.isArray(o)&&(o=b.map(o,function(e){return null==e?\"\":e+\"\"})),r=b.valHooks[this.type]||b.valHooks[this.nodeName.toLowerCase()],r&&\"set\"in r&&r.set(this,o,\"value\")!==t||(this.value=o))});if(o)return r=b.valHooks[o.type]||b.valHooks[o.nodeName.toLowerCase()],r&&\"get\"in r&&(n=r.get(o,\"value\"))!==t?n:(n=o.value,\"string\"==typeof n?n.replace(U,\"\"):null==n?\"\":n)}}}),b.extend({valHooks:{option:{get:function(e){var t=e.attributes.value;return!t||t.specified?e.value:e.text}},select:{get:function(e){var t,n,r=e.options,i=e.selectedIndex,o=\"select-one\"===e.type||0>i,a=o?null:[],s=o?i+1:r.length,u=0>i?s:o?i:0;for(;s>u;u++)if(n=r[u],!(!n.selected&&u!==i||(b.support.optDisabled?n.disabled:null!==n.getAttribute(\"disabled\"))||n.parentNode.disabled&&b.nodeName(n.parentNode,\"optgroup\"))){if(t=b(n).val(),o)return t;a.push(t)}return a},set:function(e,t){var n=b.makeArray(t);return b(e).find(\"option\").each(function(){this.selected=b.inArray(b(this).val(),n)>=0}),n.length||(e.selectedIndex=-1),n}}},attr:function(e,n,r){var o,a,s,u=e.nodeType;if(e&&3!==u&&8!==u&&2!==u)return typeof e.getAttribute===i?b.prop(e,n,r):(a=1!==u||!b.isXMLDoc(e),a&&(n=n.toLowerCase(),o=b.attrHooks[n]||(J.test(n)?z:I)),r===t?o&&a&&\"get\"in o&&null!==(s=o.get(e,n))?s:(typeof e.getAttribute!==i&&(s=e.getAttribute(n)),null==s?t:s):null!==r?o&&a&&\"set\"in o&&(s=o.set(e,r,n))!==t?s:(e.setAttribute(n,r+\"\"),r):(b.removeAttr(e,n),t))},removeAttr:function(e,t){var n,r,i=0,o=t&&t.match(w);if(o&&1===e.nodeType)while(n=o[i++])r=b.propFix[n]||n,J.test(n)?!Q&&G.test(n)?e[b.camelCase(\"default-\"+n)]=e[r]=!1:e[r]=!1:b.attr(e,n,\"\"),e.removeAttribute(Q?n:r)},attrHooks:{type:{set:function(e,t){if(!b.support.radioValue&&\"radio\"===t&&b.nodeName(e,\"input\")){var n=e.value;return e.setAttribute(\"type\",t),n&&(e.value=n),t}}}},propFix:{tabindex:\"tabIndex\",readonly:\"readOnly\",\"for\":\"htmlFor\",\"class\":\"className\",maxlength:\"maxLength\",cellspacing:\"cellSpacing\",cellpadding:\"cellPadding\",rowspan:\"rowSpan\",colspan:\"colSpan\",usemap:\"useMap\",frameborder:\"frameBorder\",contenteditable:\"contentEditable\"},prop:function(e,n,r){var i,o,a,s=e.nodeType;if(e&&3!==s&&8!==s&&2!==s)return a=1!==s||!b.isXMLDoc(e),a&&(n=b.propFix[n]||n,o=b.propHooks[n]),r!==t?o&&\"set\"in o&&(i=o.set(e,r,n))!==t?i:e[n]=r:o&&\"get\"in o&&null!==(i=o.get(e,n))?i:e[n]},propHooks:{tabIndex:{get:function(e){var n=e.getAttributeNode(\"tabindex\");return n&&n.specified?parseInt(n.value,10):V.test(e.nodeName)||Y.test(e.nodeName)&&e.href?0:t}}}}),z={get:function(e,n){var r=b.prop(e,n),i=\"boolean\"==typeof r&&e.getAttribute(n),o=\"boolean\"==typeof r?K&&Q?null!=i:G.test(n)?e[b.camelCase(\"default-\"+n)]:!!i:e.getAttributeNode(n);return o&&o.value!==!1?n.toLowerCase():t},set:function(e,t,n){return t===!1?b.removeAttr(e,n):K&&Q||!G.test(n)?e.setAttribute(!Q&&b.propFix[n]||n,n):e[b.camelCase(\"default-\"+n)]=e[n]=!0,n}},K&&Q||(b.attrHooks.value={get:function(e,n){var r=e.getAttributeNode(n);return b.nodeName(e,\"input\")?e.defaultValue:r&&r.specified?r.value:t},set:function(e,n,r){return b.nodeName(e,\"input\")?(e.defaultValue=n,t):I&&I.set(e,n,r)}}),Q||(I=b.valHooks.button={get:function(e,n){var r=e.getAttributeNode(n);return r&&(\"id\"===n||\"name\"===n||\"coords\"===n?\"\"!==r.value:r.specified)?r.value:t},set:function(e,n,r){var i=e.getAttributeNode(r);return i||e.setAttributeNode(i=e.ownerDocument.createAttribute(r)),i.value=n+=\"\",\"value\"===r||n===e.getAttribute(r)?n:t}},b.attrHooks.contenteditable={get:I.get,set:function(e,t,n){I.set(e,\"\"===t?!1:t,n)}},b.each([\"width\",\"height\"],function(e,n){b.attrHooks[n]=b.extend(b.attrHooks[n],{set:function(e,r){return\"\"===r?(e.setAttribute(n,\"auto\"),r):t}})})),b.support.hrefNormalized||(b.each([\"href\",\"src\",\"width\",\"height\"],function(e,n){b.attrHooks[n]=b.extend(b.attrHooks[n],{get:function(e){var r=e.getAttribute(n,2);return null==r?t:r}})}),b.each([\"href\",\"src\"],function(e,t){b.propHooks[t]={get:function(e){return e.getAttribute(t,4)}}})),b.support.style||(b.attrHooks.style={get:function(e){return e.style.cssText||t},set:function(e,t){return e.style.cssText=t+\"\"}}),b.support.optSelected||(b.propHooks.selected=b.extend(b.propHooks.selected,{get:function(e){var t=e.parentNode;return t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex),null}})),b.support.enctype||(b.propFix.enctype=\"encoding\"),b.support.checkOn||b.each([\"radio\",\"checkbox\"],function(){b.valHooks[this]={get:function(e){return null===e.getAttribute(\"value\")?\"on\":e.value}}}),b.each([\"radio\",\"checkbox\"],function(){b.valHooks[this]=b.extend(b.valHooks[this],{set:function(e,n){return b.isArray(n)?e.checked=b.inArray(b(e).val(),n)>=0:t}})});var Z=/^(?:input|select|textarea)$/i,et=/^key/,tt=/^(?:mouse|contextmenu)|click/,nt=/^(?:focusinfocus|focusoutblur)$/,rt=/^([^.]*)(?:\\.(.+)|)$/;function it(){return!0}function ot(){return!1}b.event={global:{},add:function(e,n,r,o,a){var s,u,l,c,p,f,d,h,g,m,y,v=b._data(e);if(v){r.handler&&(c=r,r=c.handler,a=c.selector),r.guid||(r.guid=b.guid++),(u=v.events)||(u=v.events={}),(f=v.handle)||(f=v.handle=function(e){return typeof b===i||e&&b.event.triggered===e.type?t:b.event.dispatch.apply(f.elem,arguments)},f.elem=e),n=(n||\"\").match(w)||[\"\"],l=n.length;while(l--)s=rt.exec(n[l])||[],g=y=s[1],m=(s[2]||\"\").split(\".\").sort(),p=b.event.special[g]||{},g=(a?p.delegateType:p.bindType)||g,p=b.event.special[g]||{},d=b.extend({type:g,origType:y,data:o,handler:r,guid:r.guid,selector:a,needsContext:a&&b.expr.match.needsContext.test(a),namespace:m.join(\".\")},c),(h=u[g])||(h=u[g]=[],h.delegateCount=0,p.setup&&p.setup.call(e,o,m,f)!==!1||(e.addEventListener?e.addEventListener(g,f,!1):e.attachEvent&&e.attachEvent(\"on\"+g,f))),p.add&&(p.add.call(e,d),d.handler.guid||(d.handler.guid=r.guid)),a?h.splice(h.delegateCount++,0,d):h.push(d),b.event.global[g]=!0;e=null}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,p,f,d,h,g,m=b.hasData(e)&&b._data(e);if(m&&(c=m.events)){t=(t||\"\").match(w)||[\"\"],l=t.length;while(l--)if(s=rt.exec(t[l])||[],d=g=s[1],h=(s[2]||\"\").split(\".\").sort(),d){p=b.event.special[d]||{},d=(r?p.delegateType:p.bindType)||d,f=c[d]||[],s=s[2]&&RegExp(\"(^|\\\\.)\"+h.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"),u=o=f.length;while(o--)a=f[o],!i&&g!==a.origType||n&&n.guid!==a.guid||s&&!s.test(a.namespace)||r&&r!==a.selector&&(\"**\"!==r||!a.selector)||(f.splice(o,1),a.selector&&f.delegateCount--,p.remove&&p.remove.call(e,a));u&&!f.length&&(p.teardown&&p.teardown.call(e,h,m.handle)!==!1||b.removeEvent(e,d,m.handle),delete c[d])}else for(d in c)b.event.remove(e,d+t[l],n,r,!0);b.isEmptyObject(c)&&(delete m.handle,b._removeData(e,\"events\"))}},trigger:function(n,r,i,a){var s,u,l,c,p,f,d,h=[i||o],g=y.call(n,\"type\")?n.type:n,m=y.call(n,\"namespace\")?n.namespace.split(\".\"):[];if(l=f=i=i||o,3!==i.nodeType&&8!==i.nodeType&&!nt.test(g+b.event.triggered)&&(g.indexOf(\".\")>=0&&(m=g.split(\".\"),g=m.shift(),m.sort()),u=0>g.indexOf(\":\")&&\"on\"+g,n=n[b.expando]?n:new b.Event(g,\"object\"==typeof n&&n),n.isTrigger=!0,n.namespace=m.join(\".\"),n.namespace_re=n.namespace?RegExp(\"(^|\\\\.)\"+m.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"):null,n.result=t,n.target||(n.target=i),r=null==r?[n]:b.makeArray(r,[n]),p=b.event.special[g]||{},a||!p.trigger||p.trigger.apply(i,r)!==!1)){if(!a&&!p.noBubble&&!b.isWindow(i)){for(c=p.delegateType||g,nt.test(c+g)||(l=l.parentNode);l;l=l.parentNode)h.push(l),f=l;f===(i.ownerDocument||o)&&h.push(f.defaultView||f.parentWindow||e)}d=0;while((l=h[d++])&&!n.isPropagationStopped())n.type=d>1?c:p.bindType||g,s=(b._data(l,\"events\")||{})[n.type]&&b._data(l,\"handle\"),s&&s.apply(l,r),s=u&&l[u],s&&b.acceptData(l)&&s.apply&&s.apply(l,r)===!1&&n.preventDefault();if(n.type=g,!(a||n.isDefaultPrevented()||p._default&&p._default.apply(i.ownerDocument,r)!==!1||\"click\"===g&&b.nodeName(i,\"a\")||!b.acceptData(i)||!u||!i[g]||b.isWindow(i))){f=i[u],f&&(i[u]=null),b.event.triggered=g;try{i[g]()}catch(v){}b.event.triggered=t,f&&(i[u]=f)}return n.result}},dispatch:function(e){e=b.event.fix(e);var n,r,i,o,a,s=[],u=h.call(arguments),l=(b._data(this,\"events\")||{})[e.type]||[],c=b.event.special[e.type]||{};if(u[0]=e,e.delegateTarget=this,!c.preDispatch||c.preDispatch.call(this,e)!==!1){s=b.event.handlers.call(this,e,l),n=0;while((o=s[n++])&&!e.isPropagationStopped()){e.currentTarget=o.elem,a=0;while((i=o.handlers[a++])&&!e.isImmediatePropagationStopped())(!e.namespace_re||e.namespace_re.test(i.namespace))&&(e.handleObj=i,e.data=i.data,r=((b.event.special[i.origType]||{}).handle||i.handler).apply(o.elem,u),r!==t&&(e.result=r)===!1&&(e.preventDefault(),e.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,e),e.result}},handlers:function(e,n){var r,i,o,a,s=[],u=n.delegateCount,l=e.target;if(u&&l.nodeType&&(!e.button||\"click\"!==e.type))for(;l!=this;l=l.parentNode||this)if(1===l.nodeType&&(l.disabled!==!0||\"click\"!==e.type)){for(o=[],a=0;u>a;a++)i=n[a],r=i.selector+\" \",o[r]===t&&(o[r]=i.needsContext?b(r,this).index(l)>=0:b.find(r,this,null,[l]).length),o[r]&&o.push(i);o.length&&s.push({elem:l,handlers:o})}return n.length>u&&s.push({elem:this,handlers:n.slice(u)}),s},fix:function(e){if(e[b.expando])return e;var t,n,r,i=e.type,a=e,s=this.fixHooks[i];s||(this.fixHooks[i]=s=tt.test(i)?this.mouseHooks:et.test(i)?this.keyHooks:{}),r=s.props?this.props.concat(s.props):this.props,e=new b.Event(a),t=r.length;while(t--)n=r[t],e[n]=a[n];return e.target||(e.target=a.srcElement||o),3===e.target.nodeType&&(e.target=e.target.parentNode),e.metaKey=!!e.metaKey,s.filter?s.filter(e,a):e},props:\"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which\".split(\" \"),fixHooks:{},keyHooks:{props:\"char charCode key keyCode\".split(\" \"),filter:function(e,t){return null==e.which&&(e.which=null!=t.charCode?t.charCode:t.keyCode),e}},mouseHooks:{props:\"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement\".split(\" \"),filter:function(e,n){var r,i,a,s=n.button,u=n.fromElement;return null==e.pageX&&null!=n.clientX&&(i=e.target.ownerDocument||o,a=i.documentElement,r=i.body,e.pageX=n.clientX+(a&&a.scrollLeft||r&&r.scrollLeft||0)-(a&&a.clientLeft||r&&r.clientLeft||0),e.pageY=n.clientY+(a&&a.scrollTop||r&&r.scrollTop||0)-(a&&a.clientTop||r&&r.clientTop||0)),!e.relatedTarget&&u&&(e.relatedTarget=u===e.target?n.toElement:u),e.which||s===t||(e.which=1&s?1:2&s?3:4&s?2:0),e}},special:{load:{noBubble:!0},click:{trigger:function(){return b.nodeName(this,\"input\")&&\"checkbox\"===this.type&&this.click?(this.click(),!1):t}},focus:{trigger:function(){if(this!==o.activeElement&&this.focus)try{return this.focus(),!1}catch(e){}},delegateType:\"focusin\"},blur:{trigger:function(){return this===o.activeElement&&this.blur?(this.blur(),!1):t},delegateType:\"focusout\"},beforeunload:{postDispatch:function(e){e.result!==t&&(e.originalEvent.returnValue=e.result)}}},simulate:function(e,t,n,r){var i=b.extend(new b.Event,n,{type:e,isSimulated:!0,originalEvent:{}});r?b.event.trigger(i,null,t):b.event.dispatch.call(t,i),i.isDefaultPrevented()&&n.preventDefault()}},b.removeEvent=o.removeEventListener?function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n,!1)}:function(e,t,n){var r=\"on\"+t;e.detachEvent&&(typeof e[r]===i&&(e[r]=null),e.detachEvent(r,n))},b.Event=function(e,n){return this instanceof b.Event?(e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||e.returnValue===!1||e.getPreventDefault&&e.getPreventDefault()?it:ot):this.type=e,n&&b.extend(this,n),this.timeStamp=e&&e.timeStamp||b.now(),this[b.expando]=!0,t):new b.Event(e,n)},b.Event.prototype={isDefaultPrevented:ot,isPropagationStopped:ot,isImmediatePropagationStopped:ot,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=it,e&&(e.preventDefault?e.preventDefault():e.returnValue=!1)},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=it,e&&(e.stopPropagation&&e.stopPropagation(),e.cancelBubble=!0)},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=it,this.stopPropagation()}},b.each({mouseenter:\"mouseover\",mouseleave:\"mouseout\"},function(e,t){b.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;\nreturn(!i||i!==r&&!b.contains(r,i))&&(e.type=o.origType,n=o.handler.apply(this,arguments),e.type=t),n}}}),b.support.submitBubbles||(b.event.special.submit={setup:function(){return b.nodeName(this,\"form\")?!1:(b.event.add(this,\"click._submit keypress._submit\",function(e){var n=e.target,r=b.nodeName(n,\"input\")||b.nodeName(n,\"button\")?n.form:t;r&&!b._data(r,\"submitBubbles\")&&(b.event.add(r,\"submit._submit\",function(e){e._submit_bubble=!0}),b._data(r,\"submitBubbles\",!0))}),t)},postDispatch:function(e){e._submit_bubble&&(delete e._submit_bubble,this.parentNode&&!e.isTrigger&&b.event.simulate(\"submit\",this.parentNode,e,!0))},teardown:function(){return b.nodeName(this,\"form\")?!1:(b.event.remove(this,\"._submit\"),t)}}),b.support.changeBubbles||(b.event.special.change={setup:function(){return Z.test(this.nodeName)?((\"checkbox\"===this.type||\"radio\"===this.type)&&(b.event.add(this,\"propertychange._change\",function(e){\"checked\"===e.originalEvent.propertyName&&(this._just_changed=!0)}),b.event.add(this,\"click._change\",function(e){this._just_changed&&!e.isTrigger&&(this._just_changed=!1),b.event.simulate(\"change\",this,e,!0)})),!1):(b.event.add(this,\"beforeactivate._change\",function(e){var t=e.target;Z.test(t.nodeName)&&!b._data(t,\"changeBubbles\")&&(b.event.add(t,\"change._change\",function(e){!this.parentNode||e.isSimulated||e.isTrigger||b.event.simulate(\"change\",this.parentNode,e,!0)}),b._data(t,\"changeBubbles\",!0))}),t)},handle:function(e){var n=e.target;return this!==n||e.isSimulated||e.isTrigger||\"radio\"!==n.type&&\"checkbox\"!==n.type?e.handleObj.handler.apply(this,arguments):t},teardown:function(){return b.event.remove(this,\"._change\"),!Z.test(this.nodeName)}}),b.support.focusinBubbles||b.each({focus:\"focusin\",blur:\"focusout\"},function(e,t){var n=0,r=function(e){b.event.simulate(t,e.target,b.event.fix(e),!0)};b.event.special[t]={setup:function(){0===n++&&o.addEventListener(e,r,!0)},teardown:function(){0===--n&&o.removeEventListener(e,r,!0)}}}),b.fn.extend({on:function(e,n,r,i,o){var a,s;if(\"object\"==typeof e){\"string\"!=typeof n&&(r=r||n,n=t);for(a in e)this.on(a,n,r,e[a],o);return this}if(null==r&&null==i?(i=n,r=n=t):null==i&&(\"string\"==typeof n?(i=r,r=t):(i=r,r=n,n=t)),i===!1)i=ot;else if(!i)return this;return 1===o&&(s=i,i=function(e){return b().off(e),s.apply(this,arguments)},i.guid=s.guid||(s.guid=b.guid++)),this.each(function(){b.event.add(this,e,i,r,n)})},one:function(e,t,n,r){return this.on(e,t,n,r,1)},off:function(e,n,r){var i,o;if(e&&e.preventDefault&&e.handleObj)return i=e.handleObj,b(e.delegateTarget).off(i.namespace?i.origType+\".\"+i.namespace:i.origType,i.selector,i.handler),this;if(\"object\"==typeof e){for(o in e)this.off(o,n,e[o]);return this}return(n===!1||\"function\"==typeof n)&&(r=n,n=t),r===!1&&(r=ot),this.each(function(){b.event.remove(this,e,r,n)})},bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,\"**\"):this.off(t,e||\"**\",n)},trigger:function(e,t){return this.each(function(){b.event.trigger(e,t,this)})},triggerHandler:function(e,n){var r=this[0];return r?b.event.trigger(e,n,r,!0):t}}),function(e,t){var n,r,i,o,a,s,u,l,c,p,f,d,h,g,m,y,v,x=\"sizzle\"+-new Date,w=e.document,T={},N=0,C=0,k=it(),E=it(),S=it(),A=typeof t,j=1<<31,D=[],L=D.pop,H=D.push,q=D.slice,M=D.indexOf||function(e){var t=0,n=this.length;for(;n>t;t++)if(this[t]===e)return t;return-1},_=\"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",F=\"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",O=F.replace(\"w\",\"w#\"),B=\"([*^$|!~]?=)\",P=\"\\\\[\"+_+\"*(\"+F+\")\"+_+\"*(?:\"+B+_+\"*(?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|(\"+O+\")|)|)\"+_+\"*\\\\]\",R=\":(\"+F+\")(?:\\\\(((['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\"+P.replace(3,8)+\")*)|.*)\\\\)|)\",W=RegExp(\"^\"+_+\"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\"+_+\"+$\",\"g\"),$=RegExp(\"^\"+_+\"*,\"+_+\"*\"),I=RegExp(\"^\"+_+\"*([\\\\x20\\\\t\\\\r\\\\n\\\\f>+~])\"+_+\"*\"),z=RegExp(R),X=RegExp(\"^\"+O+\"$\"),U={ID:RegExp(\"^#(\"+F+\")\"),CLASS:RegExp(\"^\\\\.(\"+F+\")\"),NAME:RegExp(\"^\\\\[name=['\\\"]?(\"+F+\")['\\\"]?\\\\]\"),TAG:RegExp(\"^(\"+F.replace(\"w\",\"w*\")+\")\"),ATTR:RegExp(\"^\"+P),PSEUDO:RegExp(\"^\"+R),CHILD:RegExp(\"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\"+_+\"*(even|odd|(([+-]|)(\\\\d*)n|)\"+_+\"*(?:([+-]|)\"+_+\"*(\\\\d+)|))\"+_+\"*\\\\)|)\",\"i\"),needsContext:RegExp(\"^\"+_+\"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\"+_+\"*((?:-\\\\d)?\\\\d*)\"+_+\"*\\\\)|)(?=[^-]|$)\",\"i\")},V=/[\\x20\\t\\r\\n\\f]*[+~]/,Y=/^[^{]+\\{\\s*\\[native code/,J=/^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,G=/^(?:input|select|textarea|button)$/i,Q=/^h\\d$/i,K=/'|\\\\/g,Z=/\\=[\\x20\\t\\r\\n\\f]*([^'\"\\]]*)[\\x20\\t\\r\\n\\f]*\\]/g,et=/\\\\([\\da-fA-F]{1,6}[\\x20\\t\\r\\n\\f]?|.)/g,tt=function(e,t){var n=\"0x\"+t-65536;return n!==n?t:0>n?String.fromCharCode(n+65536):String.fromCharCode(55296|n>>10,56320|1023&n)};try{q.call(w.documentElement.childNodes,0)[0].nodeType}catch(nt){q=function(e){var t,n=[];while(t=this[e++])n.push(t);return n}}function rt(e){return Y.test(e+\"\")}function it(){var e,t=[];return e=function(n,r){return t.push(n+=\" \")>i.cacheLength&&delete e[t.shift()],e[n]=r}}function ot(e){return e[x]=!0,e}function at(e){var t=p.createElement(\"div\");try{return e(t)}catch(n){return!1}finally{t=null}}function st(e,t,n,r){var i,o,a,s,u,l,f,g,m,v;if((t?t.ownerDocument||t:w)!==p&&c(t),t=t||p,n=n||[],!e||\"string\"!=typeof e)return n;if(1!==(s=t.nodeType)&&9!==s)return[];if(!d&&!r){if(i=J.exec(e))if(a=i[1]){if(9===s){if(o=t.getElementById(a),!o||!o.parentNode)return n;if(o.id===a)return n.push(o),n}else if(t.ownerDocument&&(o=t.ownerDocument.getElementById(a))&&y(t,o)&&o.id===a)return n.push(o),n}else{if(i[2])return H.apply(n,q.call(t.getElementsByTagName(e),0)),n;if((a=i[3])&&T.getByClassName&&t.getElementsByClassName)return H.apply(n,q.call(t.getElementsByClassName(a),0)),n}if(T.qsa&&!h.test(e)){if(f=!0,g=x,m=t,v=9===s&&e,1===s&&\"object\"!==t.nodeName.toLowerCase()){l=ft(e),(f=t.getAttribute(\"id\"))?g=f.replace(K,\"\\\\$&\"):t.setAttribute(\"id\",g),g=\"[id='\"+g+\"'] \",u=l.length;while(u--)l[u]=g+dt(l[u]);m=V.test(e)&&t.parentNode||t,v=l.join(\",\")}if(v)try{return H.apply(n,q.call(m.querySelectorAll(v),0)),n}catch(b){}finally{f||t.removeAttribute(\"id\")}}}return wt(e.replace(W,\"$1\"),t,n,r)}a=st.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return t?\"HTML\"!==t.nodeName:!1},c=st.setDocument=function(e){var n=e?e.ownerDocument||e:w;return n!==p&&9===n.nodeType&&n.documentElement?(p=n,f=n.documentElement,d=a(n),T.tagNameNoComments=at(function(e){return e.appendChild(n.createComment(\"\")),!e.getElementsByTagName(\"*\").length}),T.attributes=at(function(e){e.innerHTML=\"<select></select>\";var t=typeof e.lastChild.getAttribute(\"multiple\");return\"boolean\"!==t&&\"string\"!==t}),T.getByClassName=at(function(e){return e.innerHTML=\"<div class='hidden e'></div><div class='hidden'></div>\",e.getElementsByClassName&&e.getElementsByClassName(\"e\").length?(e.lastChild.className=\"e\",2===e.getElementsByClassName(\"e\").length):!1}),T.getByName=at(function(e){e.id=x+0,e.innerHTML=\"<a name='\"+x+\"'></a><div name='\"+x+\"'></div>\",f.insertBefore(e,f.firstChild);var t=n.getElementsByName&&n.getElementsByName(x).length===2+n.getElementsByName(x+0).length;return T.getIdNotName=!n.getElementById(x),f.removeChild(e),t}),i.attrHandle=at(function(e){return e.innerHTML=\"<a href='#'></a>\",e.firstChild&&typeof e.firstChild.getAttribute!==A&&\"#\"===e.firstChild.getAttribute(\"href\")})?{}:{href:function(e){return e.getAttribute(\"href\",2)},type:function(e){return e.getAttribute(\"type\")}},T.getIdNotName?(i.find.ID=function(e,t){if(typeof t.getElementById!==A&&!d){var n=t.getElementById(e);return n&&n.parentNode?[n]:[]}},i.filter.ID=function(e){var t=e.replace(et,tt);return function(e){return e.getAttribute(\"id\")===t}}):(i.find.ID=function(e,n){if(typeof n.getElementById!==A&&!d){var r=n.getElementById(e);return r?r.id===e||typeof r.getAttributeNode!==A&&r.getAttributeNode(\"id\").value===e?[r]:t:[]}},i.filter.ID=function(e){var t=e.replace(et,tt);return function(e){var n=typeof e.getAttributeNode!==A&&e.getAttributeNode(\"id\");return n&&n.value===t}}),i.find.TAG=T.tagNameNoComments?function(e,n){return typeof n.getElementsByTagName!==A?n.getElementsByTagName(e):t}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if(\"*\"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},i.find.NAME=T.getByName&&function(e,n){return typeof n.getElementsByName!==A?n.getElementsByName(name):t},i.find.CLASS=T.getByClassName&&function(e,n){return typeof n.getElementsByClassName===A||d?t:n.getElementsByClassName(e)},g=[],h=[\":focus\"],(T.qsa=rt(n.querySelectorAll))&&(at(function(e){e.innerHTML=\"<select><option selected=''></option></select>\",e.querySelectorAll(\"[selected]\").length||h.push(\"\\\\[\"+_+\"*(?:checked|disabled|ismap|multiple|readonly|selected|value)\"),e.querySelectorAll(\":checked\").length||h.push(\":checked\")}),at(function(e){e.innerHTML=\"<input type='hidden' i=''/>\",e.querySelectorAll(\"[i^='']\").length&&h.push(\"[*^$]=\"+_+\"*(?:\\\"\\\"|'')\"),e.querySelectorAll(\":enabled\").length||h.push(\":enabled\",\":disabled\"),e.querySelectorAll(\"*,:x\"),h.push(\",.*:\")})),(T.matchesSelector=rt(m=f.matchesSelector||f.mozMatchesSelector||f.webkitMatchesSelector||f.oMatchesSelector||f.msMatchesSelector))&&at(function(e){T.disconnectedMatch=m.call(e,\"div\"),m.call(e,\"[s!='']:x\"),g.push(\"!=\",R)}),h=RegExp(h.join(\"|\")),g=RegExp(g.join(\"|\")),y=rt(f.contains)||f.compareDocumentPosition?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},v=f.compareDocumentPosition?function(e,t){var r;return e===t?(u=!0,0):(r=t.compareDocumentPosition&&e.compareDocumentPosition&&e.compareDocumentPosition(t))?1&r||e.parentNode&&11===e.parentNode.nodeType?e===n||y(w,e)?-1:t===n||y(w,t)?1:0:4&r?-1:1:e.compareDocumentPosition?-1:1}:function(e,t){var r,i=0,o=e.parentNode,a=t.parentNode,s=[e],l=[t];if(e===t)return u=!0,0;if(!o||!a)return e===n?-1:t===n?1:o?-1:a?1:0;if(o===a)return ut(e,t);r=e;while(r=r.parentNode)s.unshift(r);r=t;while(r=r.parentNode)l.unshift(r);while(s[i]===l[i])i++;return i?ut(s[i],l[i]):s[i]===w?-1:l[i]===w?1:0},u=!1,[0,0].sort(v),T.detectDuplicates=u,p):p},st.matches=function(e,t){return st(e,null,null,t)},st.matchesSelector=function(e,t){if((e.ownerDocument||e)!==p&&c(e),t=t.replace(Z,\"='$1']\"),!(!T.matchesSelector||d||g&&g.test(t)||h.test(t)))try{var n=m.call(e,t);if(n||T.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(r){}return st(t,p,null,[e]).length>0},st.contains=function(e,t){return(e.ownerDocument||e)!==p&&c(e),y(e,t)},st.attr=function(e,t){var n;return(e.ownerDocument||e)!==p&&c(e),d||(t=t.toLowerCase()),(n=i.attrHandle[t])?n(e):d||T.attributes?e.getAttribute(t):((n=e.getAttributeNode(t))||e.getAttribute(t))&&e[t]===!0?t:n&&n.specified?n.value:null},st.error=function(e){throw Error(\"Syntax error, unrecognized expression: \"+e)},st.uniqueSort=function(e){var t,n=[],r=1,i=0;if(u=!T.detectDuplicates,e.sort(v),u){for(;t=e[r];r++)t===e[r-1]&&(i=n.push(r));while(i--)e.splice(n[i],1)}return e};function ut(e,t){var n=t&&e,r=n&&(~t.sourceIndex||j)-(~e.sourceIndex||j);if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function lt(e){return function(t){var n=t.nodeName.toLowerCase();return\"input\"===n&&t.type===e}}function ct(e){return function(t){var n=t.nodeName.toLowerCase();return(\"input\"===n||\"button\"===n)&&t.type===e}}function pt(e){return ot(function(t){return t=+t,ot(function(n,r){var i,o=e([],n.length,t),a=o.length;while(a--)n[i=o[a]]&&(n[i]=!(r[i]=n[i]))})})}o=st.getText=function(e){var t,n=\"\",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if(\"string\"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else for(;t=e[r];r++)n+=o(t);return n},i=st.selectors={cacheLength:50,createPseudo:ot,match:U,find:{},relative:{\">\":{dir:\"parentNode\",first:!0},\" \":{dir:\"parentNode\"},\"+\":{dir:\"previousSibling\",first:!0},\"~\":{dir:\"previousSibling\"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(et,tt),e[3]=(e[4]||e[5]||\"\").replace(et,tt),\"~=\"===e[2]&&(e[3]=\" \"+e[3]+\" \"),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),\"nth\"===e[1].slice(0,3)?(e[3]||st.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*(\"even\"===e[3]||\"odd\"===e[3])),e[5]=+(e[7]+e[8]||\"odd\"===e[3])):e[3]&&st.error(e[0]),e},PSEUDO:function(e){var t,n=!e[5]&&e[2];return U.CHILD.test(e[0])?null:(e[4]?e[2]=e[4]:n&&z.test(n)&&(t=ft(n,!0))&&(t=n.indexOf(\")\",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){return\"*\"===e?function(){return!0}:(e=e.replace(et,tt).toLowerCase(),function(t){return t.nodeName&&t.nodeName.toLowerCase()===e})},CLASS:function(e){var t=k[e+\" \"];return t||(t=RegExp(\"(^|\"+_+\")\"+e+\"(\"+_+\"|$)\"))&&k(e,function(e){return t.test(e.className||typeof e.getAttribute!==A&&e.getAttribute(\"class\")||\"\")})},ATTR:function(e,t,n){return function(r){var i=st.attr(r,e);return null==i?\"!=\"===t:t?(i+=\"\",\"=\"===t?i===n:\"!=\"===t?i!==n:\"^=\"===t?n&&0===i.indexOf(n):\"*=\"===t?n&&i.indexOf(n)>-1:\"$=\"===t?n&&i.slice(-n.length)===n:\"~=\"===t?(\" \"+i+\" \").indexOf(n)>-1:\"|=\"===t?i===n||i.slice(0,n.length+1)===n+\"-\":!1):!0}},CHILD:function(e,t,n,r,i){var o=\"nth\"!==e.slice(0,3),a=\"last\"!==e.slice(-4),s=\"of-type\"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,u){var l,c,p,f,d,h,g=o!==a?\"nextSibling\":\"previousSibling\",m=t.parentNode,y=s&&t.nodeName.toLowerCase(),v=!u&&!s;if(m){if(o){while(g){p=t;while(p=p[g])if(s?p.nodeName.toLowerCase()===y:1===p.nodeType)return!1;h=g=\"only\"===e&&!h&&\"nextSibling\"}return!0}if(h=[a?m.firstChild:m.lastChild],a&&v){c=m[x]||(m[x]={}),l=c[e]||[],d=l[0]===N&&l[1],f=l[0]===N&&l[2],p=d&&m.childNodes[d];while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if(1===p.nodeType&&++f&&p===t){c[e]=[N,d,f];break}}else if(v&&(l=(t[x]||(t[x]={}))[e])&&l[0]===N)f=l[1];else while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if((s?p.nodeName.toLowerCase()===y:1===p.nodeType)&&++f&&(v&&((p[x]||(p[x]={}))[e]=[N,f]),p===t))break;return f-=i,f===r||0===f%r&&f/r>=0}}},PSEUDO:function(e,t){var n,r=i.pseudos[e]||i.setFilters[e.toLowerCase()]||st.error(\"unsupported pseudo: \"+e);return r[x]?r(t):r.length>1?(n=[e,e,\"\",t],i.setFilters.hasOwnProperty(e.toLowerCase())?ot(function(e,n){var i,o=r(e,t),a=o.length;while(a--)i=M.call(e,o[a]),e[i]=!(n[i]=o[a])}):function(e){return r(e,0,n)}):r}},pseudos:{not:ot(function(e){var t=[],n=[],r=s(e.replace(W,\"$1\"));return r[x]?ot(function(e,t,n,i){var o,a=r(e,null,i,[]),s=e.length;while(s--)(o=a[s])&&(e[s]=!(t[s]=o))}):function(e,i,o){return t[0]=e,r(t,null,o,n),!n.pop()}}),has:ot(function(e){return function(t){return st(e,t).length>0}}),contains:ot(function(e){return function(t){return(t.textContent||t.innerText||o(t)).indexOf(e)>-1}}),lang:ot(function(e){return X.test(e||\"\")||st.error(\"unsupported lang: \"+e),e=e.replace(et,tt).toLowerCase(),function(t){var n;do if(n=d?t.getAttribute(\"xml:lang\")||t.getAttribute(\"lang\"):t.lang)return n=n.toLowerCase(),n===e||0===n.indexOf(e+\"-\");while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===f},focus:function(e){return e===p.activeElement&&(!p.hasFocus||p.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:function(e){return e.disabled===!1},disabled:function(e){return e.disabled===!0},checked:function(e){var t=e.nodeName.toLowerCase();return\"input\"===t&&!!e.checked||\"option\"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,e.selected===!0},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeName>\"@\"||3===e.nodeType||4===e.nodeType)return!1;return!0},parent:function(e){return!i.pseudos.empty(e)},header:function(e){return Q.test(e.nodeName)},input:function(e){return G.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return\"input\"===t&&\"button\"===e.type||\"button\"===t},text:function(e){var t;return\"input\"===e.nodeName.toLowerCase()&&\"text\"===e.type&&(null==(t=e.getAttribute(\"type\"))||t.toLowerCase()===e.type)},first:pt(function(){return[0]}),last:pt(function(e,t){return[t-1]}),eq:pt(function(e,t,n){return[0>n?n+t:n]}),even:pt(function(e,t){var n=0;for(;t>n;n+=2)e.push(n);return e}),odd:pt(function(e,t){var n=1;for(;t>n;n+=2)e.push(n);return e}),lt:pt(function(e,t,n){var r=0>n?n+t:n;for(;--r>=0;)e.push(r);return e}),gt:pt(function(e,t,n){var r=0>n?n+t:n;for(;t>++r;)e.push(r);return e})}};for(n in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})i.pseudos[n]=lt(n);for(n in{submit:!0,reset:!0})i.pseudos[n]=ct(n);function ft(e,t){var n,r,o,a,s,u,l,c=E[e+\" \"];if(c)return t?0:c.slice(0);s=e,u=[],l=i.preFilter;while(s){(!n||(r=$.exec(s)))&&(r&&(s=s.slice(r[0].length)||s),u.push(o=[])),n=!1,(r=I.exec(s))&&(n=r.shift(),o.push({value:n,type:r[0].replace(W,\" \")}),s=s.slice(n.length));for(a in i.filter)!(r=U[a].exec(s))||l[a]&&!(r=l[a](r))||(n=r.shift(),o.push({value:n,type:a,matches:r}),s=s.slice(n.length));if(!n)break}return t?s.length:s?st.error(e):E(e,u).slice(0)}function dt(e){var t=0,n=e.length,r=\"\";for(;n>t;t++)r+=e[t].value;return r}function ht(e,t,n){var i=t.dir,o=n&&\"parentNode\"===i,a=C++;return t.first?function(t,n,r){while(t=t[i])if(1===t.nodeType||o)return e(t,n,r)}:function(t,n,s){var u,l,c,p=N+\" \"+a;if(s){while(t=t[i])if((1===t.nodeType||o)&&e(t,n,s))return!0}else while(t=t[i])if(1===t.nodeType||o)if(c=t[x]||(t[x]={}),(l=c[i])&&l[0]===p){if((u=l[1])===!0||u===r)return u===!0}else if(l=c[i]=[p],l[1]=e(t,n,s)||r,l[1]===!0)return!0}}function gt(e){return e.length>1?function(t,n,r){var i=e.length;while(i--)if(!e[i](t,n,r))return!1;return!0}:e[0]}function mt(e,t,n,r,i){var o,a=[],s=0,u=e.length,l=null!=t;for(;u>s;s++)(o=e[s])&&(!n||n(o,r,i))&&(a.push(o),l&&t.push(s));return a}function yt(e,t,n,r,i,o){return r&&!r[x]&&(r=yt(r)),i&&!i[x]&&(i=yt(i,o)),ot(function(o,a,s,u){var l,c,p,f=[],d=[],h=a.length,g=o||xt(t||\"*\",s.nodeType?[s]:s,[]),m=!e||!o&&t?g:mt(g,f,e,s,u),y=n?i||(o?e:h||r)?[]:a:m;if(n&&n(m,y,s,u),r){l=mt(y,d),r(l,[],s,u),c=l.length;while(c--)(p=l[c])&&(y[d[c]]=!(m[d[c]]=p))}if(o){if(i||e){if(i){l=[],c=y.length;while(c--)(p=y[c])&&l.push(m[c]=p);i(null,y=[],l,u)}c=y.length;while(c--)(p=y[c])&&(l=i?M.call(o,p):f[c])>-1&&(o[l]=!(a[l]=p))}}else y=mt(y===a?y.splice(h,y.length):y),i?i(null,a,y,u):H.apply(a,y)})}function vt(e){var t,n,r,o=e.length,a=i.relative[e[0].type],s=a||i.relative[\" \"],u=a?1:0,c=ht(function(e){return e===t},s,!0),p=ht(function(e){return M.call(t,e)>-1},s,!0),f=[function(e,n,r){return!a&&(r||n!==l)||((t=n).nodeType?c(e,n,r):p(e,n,r))}];for(;o>u;u++)if(n=i.relative[e[u].type])f=[ht(gt(f),n)];else{if(n=i.filter[e[u].type].apply(null,e[u].matches),n[x]){for(r=++u;o>r;r++)if(i.relative[e[r].type])break;return yt(u>1&&gt(f),u>1&&dt(e.slice(0,u-1)).replace(W,\"$1\"),n,r>u&&vt(e.slice(u,r)),o>r&&vt(e=e.slice(r)),o>r&&dt(e))}f.push(n)}return gt(f)}function bt(e,t){var n=0,o=t.length>0,a=e.length>0,s=function(s,u,c,f,d){var h,g,m,y=[],v=0,b=\"0\",x=s&&[],w=null!=d,T=l,C=s||a&&i.find.TAG(\"*\",d&&u.parentNode||u),k=N+=null==T?1:Math.random()||.1;for(w&&(l=u!==p&&u,r=n);null!=(h=C[b]);b++){if(a&&h){g=0;while(m=e[g++])if(m(h,u,c)){f.push(h);break}w&&(N=k,r=++n)}o&&((h=!m&&h)&&v--,s&&x.push(h))}if(v+=b,o&&b!==v){g=0;while(m=t[g++])m(x,y,u,c);if(s){if(v>0)while(b--)x[b]||y[b]||(y[b]=L.call(f));y=mt(y)}H.apply(f,y),w&&!s&&y.length>0&&v+t.length>1&&st.uniqueSort(f)}return w&&(N=k,l=T),x};return o?ot(s):s}s=st.compile=function(e,t){var n,r=[],i=[],o=S[e+\" \"];if(!o){t||(t=ft(e)),n=t.length;while(n--)o=vt(t[n]),o[x]?r.push(o):i.push(o);o=S(e,bt(i,r))}return o};function xt(e,t,n){var r=0,i=t.length;for(;i>r;r++)st(e,t[r],n);return n}function wt(e,t,n,r){var o,a,u,l,c,p=ft(e);if(!r&&1===p.length){if(a=p[0]=p[0].slice(0),a.length>2&&\"ID\"===(u=a[0]).type&&9===t.nodeType&&!d&&i.relative[a[1].type]){if(t=i.find.ID(u.matches[0].replace(et,tt),t)[0],!t)return n;e=e.slice(a.shift().value.length)}o=U.needsContext.test(e)?0:a.length;while(o--){if(u=a[o],i.relative[l=u.type])break;if((c=i.find[l])&&(r=c(u.matches[0].replace(et,tt),V.test(a[0].type)&&t.parentNode||t))){if(a.splice(o,1),e=r.length&&dt(a),!e)return H.apply(n,q.call(r,0)),n;break}}}return s(e,p)(r,t,d,n,V.test(e)),n}i.pseudos.nth=i.pseudos.eq;function Tt(){}i.filters=Tt.prototype=i.pseudos,i.setFilters=new Tt,c(),st.attr=b.attr,b.find=st,b.expr=st.selectors,b.expr[\":\"]=b.expr.pseudos,b.unique=st.uniqueSort,b.text=st.getText,b.isXMLDoc=st.isXML,b.contains=st.contains}(e);var at=/Until$/,st=/^(?:parents|prev(?:Until|All))/,ut=/^.[^:#\\[\\.,]*$/,lt=b.expr.match.needsContext,ct={children:!0,contents:!0,next:!0,prev:!0};b.fn.extend({find:function(e){var t,n,r,i=this.length;if(\"string\"!=typeof e)return r=this,this.pushStack(b(e).filter(function(){for(t=0;i>t;t++)if(b.contains(r[t],this))return!0}));for(n=[],t=0;i>t;t++)b.find(e,this[t],n);return n=this.pushStack(i>1?b.unique(n):n),n.selector=(this.selector?this.selector+\" \":\"\")+e,n},has:function(e){var t,n=b(e,this),r=n.length;return this.filter(function(){for(t=0;r>t;t++)if(b.contains(this,n[t]))return!0})},not:function(e){return this.pushStack(ft(this,e,!1))},filter:function(e){return this.pushStack(ft(this,e,!0))},is:function(e){return!!e&&(\"string\"==typeof e?lt.test(e)?b(e,this.context).index(this[0])>=0:b.filter(e,this).length>0:this.filter(e).length>0)},closest:function(e,t){var n,r=0,i=this.length,o=[],a=lt.test(e)||\"string\"!=typeof e?b(e,t||this.context):0;for(;i>r;r++){n=this[r];while(n&&n.ownerDocument&&n!==t&&11!==n.nodeType){if(a?a.index(n)>-1:b.find.matchesSelector(n,e)){o.push(n);break}n=n.parentNode}}return this.pushStack(o.length>1?b.unique(o):o)},index:function(e){return e?\"string\"==typeof e?b.inArray(this[0],b(e)):b.inArray(e.jquery?e[0]:e,this):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){var n=\"string\"==typeof e?b(e,t):b.makeArray(e&&e.nodeType?[e]:e),r=b.merge(this.get(),n);return this.pushStack(b.unique(r))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),b.fn.andSelf=b.fn.addBack;function pt(e,t){do e=e[t];while(e&&1!==e.nodeType);return e}b.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return b.dir(e,\"parentNode\")},parentsUntil:function(e,t,n){return b.dir(e,\"parentNode\",n)},next:function(e){return pt(e,\"nextSibling\")},prev:function(e){return pt(e,\"previousSibling\")},nextAll:function(e){return b.dir(e,\"nextSibling\")},prevAll:function(e){return b.dir(e,\"previousSibling\")},nextUntil:function(e,t,n){return b.dir(e,\"nextSibling\",n)},prevUntil:function(e,t,n){return b.dir(e,\"previousSibling\",n)},siblings:function(e){return b.sibling((e.parentNode||{}).firstChild,e)},children:function(e){return b.sibling(e.firstChild)},contents:function(e){return b.nodeName(e,\"iframe\")?e.contentDocument||e.contentWindow.document:b.merge([],e.childNodes)}},function(e,t){b.fn[e]=function(n,r){var i=b.map(this,t,n);return at.test(e)||(r=n),r&&\"string\"==typeof r&&(i=b.filter(r,i)),i=this.length>1&&!ct[e]?b.unique(i):i,this.length>1&&st.test(e)&&(i=i.reverse()),this.pushStack(i)}}),b.extend({filter:function(e,t,n){return n&&(e=\":not(\"+e+\")\"),1===t.length?b.find.matchesSelector(t[0],e)?[t[0]]:[]:b.find.matches(e,t)},dir:function(e,n,r){var i=[],o=e[n];while(o&&9!==o.nodeType&&(r===t||1!==o.nodeType||!b(o).is(r)))1===o.nodeType&&i.push(o),o=o[n];return i},sibling:function(e,t){var n=[];for(;e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n}});function ft(e,t,n){if(t=t||0,b.isFunction(t))return b.grep(e,function(e,r){var i=!!t.call(e,r,e);return i===n});if(t.nodeType)return b.grep(e,function(e){return e===t===n});if(\"string\"==typeof t){var r=b.grep(e,function(e){return 1===e.nodeType});if(ut.test(t))return b.filter(t,r,!n);t=b.filter(t,r)}return b.grep(e,function(e){return b.inArray(e,t)>=0===n})}function dt(e){var t=ht.split(\"|\"),n=e.createDocumentFragment();if(n.createElement)while(t.length)n.createElement(t.pop());return n}var ht=\"abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video\",gt=/ jQuery\\d+=\"(?:null|\\d+)\"/g,mt=RegExp(\"<(?:\"+ht+\")[\\\\s/>]\",\"i\"),yt=/^\\s+/,vt=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:]+)[^>]*)\\/>/gi,bt=/<([\\w:]+)/,xt=/<tbody/i,wt=/<|&#?\\w+;/,Tt=/<(?:script|style|link)/i,Nt=/^(?:checkbox|radio)$/i,Ct=/checked\\s*(?:[^=]|=\\s*.checked.)/i,kt=/^$|\\/(?:java|ecma)script/i,Et=/^true\\/(.*)/,St=/^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g,At={option:[1,\"<select multiple='multiple'>\",\"</select>\"],legend:[1,\"<fieldset>\",\"</fieldset>\"],area:[1,\"<map>\",\"</map>\"],param:[1,\"<object>\",\"</object>\"],thead:[1,\"<table>\",\"</table>\"],tr:[2,\"<table><tbody>\",\"</tbody></table>\"],col:[2,\"<table><tbody></tbody><colgroup>\",\"</colgroup></table>\"],td:[3,\"<table><tbody><tr>\",\"</tr></tbody></table>\"],_default:b.support.htmlSerialize?[0,\"\",\"\"]:[1,\"X<div>\",\"</div>\"]},jt=dt(o),Dt=jt.appendChild(o.createElement(\"div\"));At.optgroup=At.option,At.tbody=At.tfoot=At.colgroup=At.caption=At.thead,At.th=At.td,b.fn.extend({text:function(e){return b.access(this,function(e){return e===t?b.text(this):this.empty().append((this[0]&&this[0].ownerDocument||o).createTextNode(e))},null,e,arguments.length)},wrapAll:function(e){if(b.isFunction(e))return this.each(function(t){b(this).wrapAll(e.call(this,t))});if(this[0]){var t=b(e,this[0].ownerDocument).eq(0).clone(!0);this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstChild&&1===e.firstChild.nodeType)e=e.firstChild;return e}).append(this)}return this},wrapInner:function(e){return b.isFunction(e)?this.each(function(t){b(this).wrapInner(e.call(this,t))}):this.each(function(){var t=b(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=b.isFunction(e);return this.each(function(n){b(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(){return this.parent().each(function(){b.nodeName(this,\"body\")||b(this).replaceWith(this.childNodes)}).end()},append:function(){return this.domManip(arguments,!0,function(e){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&this.appendChild(e)})},prepend:function(){return this.domManip(arguments,!0,function(e){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&this.insertBefore(e,this.firstChild)})},before:function(){return this.domManip(arguments,!1,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return this.domManip(arguments,!1,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},remove:function(e,t){var n,r=0;for(;null!=(n=this[r]);r++)(!e||b.filter(e,[n]).length>0)&&(t||1!==n.nodeType||b.cleanData(Ot(n)),n.parentNode&&(t&&b.contains(n.ownerDocument,n)&&Mt(Ot(n,\"script\")),n.parentNode.removeChild(n)));return this},empty:function(){var e,t=0;for(;null!=(e=this[t]);t++){1===e.nodeType&&b.cleanData(Ot(e,!1));while(e.firstChild)e.removeChild(e.firstChild);e.options&&b.nodeName(e,\"select\")&&(e.options.length=0)}return this},clone:function(e,t){return e=null==e?!1:e,t=null==t?e:t,this.map(function(){return b.clone(this,e,t)})},html:function(e){return b.access(this,function(e){var n=this[0]||{},r=0,i=this.length;if(e===t)return 1===n.nodeType?n.innerHTML.replace(gt,\"\"):t;if(!(\"string\"!=typeof e||Tt.test(e)||!b.support.htmlSerialize&&mt.test(e)||!b.support.leadingWhitespace&&yt.test(e)||At[(bt.exec(e)||[\"\",\"\"])[1].toLowerCase()])){e=e.replace(vt,\"<$1></$2>\");try{for(;i>r;r++)n=this[r]||{},1===n.nodeType&&(b.cleanData(Ot(n,!1)),n.innerHTML=e);n=0}catch(o){}}n&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(e){var t=b.isFunction(e);return t||\"string\"==typeof e||(e=b(e).not(this).detach()),this.domManip([e],!0,function(e){var t=this.nextSibling,n=this.parentNode;n&&(b(this).remove(),n.insertBefore(e,t))})},detach:function(e){return this.remove(e,!0)},domManip:function(e,n,r){e=f.apply([],e);var i,o,a,s,u,l,c=0,p=this.length,d=this,h=p-1,g=e[0],m=b.isFunction(g);if(m||!(1>=p||\"string\"!=typeof g||b.support.checkClone)&&Ct.test(g))return this.each(function(i){var o=d.eq(i);m&&(e[0]=g.call(this,i,n?o.html():t)),o.domManip(e,n,r)});if(p&&(l=b.buildFragment(e,this[0].ownerDocument,!1,this),i=l.firstChild,1===l.childNodes.length&&(l=i),i)){for(n=n&&b.nodeName(i,\"tr\"),s=b.map(Ot(l,\"script\"),Ht),a=s.length;p>c;c++)o=l,c!==h&&(o=b.clone(o,!0,!0),a&&b.merge(s,Ot(o,\"script\"))),r.call(n&&b.nodeName(this[c],\"table\")?Lt(this[c],\"tbody\"):this[c],o,c);if(a)for(u=s[s.length-1].ownerDocument,b.map(s,qt),c=0;a>c;c++)o=s[c],kt.test(o.type||\"\")&&!b._data(o,\"globalEval\")&&b.contains(u,o)&&(o.src?b.ajax({url:o.src,type:\"GET\",dataType:\"script\",async:!1,global:!1,\"throws\":!0}):b.globalEval((o.text||o.textContent||o.innerHTML||\"\").replace(St,\"\")));l=i=null}return this}});function Lt(e,t){return e.getElementsByTagName(t)[0]||e.appendChild(e.ownerDocument.createElement(t))}function Ht(e){var t=e.getAttributeNode(\"type\");return e.type=(t&&t.specified)+\"/\"+e.type,e}function qt(e){var t=Et.exec(e.type);return t?e.type=t[1]:e.removeAttribute(\"type\"),e}function Mt(e,t){var n,r=0;for(;null!=(n=e[r]);r++)b._data(n,\"globalEval\",!t||b._data(t[r],\"globalEval\"))}function _t(e,t){if(1===t.nodeType&&b.hasData(e)){var n,r,i,o=b._data(e),a=b._data(t,o),s=o.events;if(s){delete a.handle,a.events={};for(n in s)for(r=0,i=s[n].length;i>r;r++)b.event.add(t,n,s[n][r])}a.data&&(a.data=b.extend({},a.data))}}function Ft(e,t){var n,r,i;if(1===t.nodeType){if(n=t.nodeName.toLowerCase(),!b.support.noCloneEvent&&t[b.expando]){i=b._data(t);for(r in i.events)b.removeEvent(t,r,i.handle);t.removeAttribute(b.expando)}\"script\"===n&&t.text!==e.text?(Ht(t).text=e.text,qt(t)):\"object\"===n?(t.parentNode&&(t.outerHTML=e.outerHTML),b.support.html5Clone&&e.innerHTML&&!b.trim(t.innerHTML)&&(t.innerHTML=e.innerHTML)):\"input\"===n&&Nt.test(e.type)?(t.defaultChecked=t.checked=e.checked,t.value!==e.value&&(t.value=e.value)):\"option\"===n?t.defaultSelected=t.selected=e.defaultSelected:(\"input\"===n||\"textarea\"===n)&&(t.defaultValue=e.defaultValue)}}b.each({appendTo:\"append\",prependTo:\"prepend\",insertBefore:\"before\",insertAfter:\"after\",replaceAll:\"replaceWith\"},function(e,t){b.fn[e]=function(e){var n,r=0,i=[],o=b(e),a=o.length-1;for(;a>=r;r++)n=r===a?this:this.clone(!0),b(o[r])[t](n),d.apply(i,n.get());return this.pushStack(i)}});function Ot(e,n){var r,o,a=0,s=typeof e.getElementsByTagName!==i?e.getElementsByTagName(n||\"*\"):typeof e.querySelectorAll!==i?e.querySelectorAll(n||\"*\"):t;if(!s)for(s=[],r=e.childNodes||e;null!=(o=r[a]);a++)!n||b.nodeName(o,n)?s.push(o):b.merge(s,Ot(o,n));return n===t||n&&b.nodeName(e,n)?b.merge([e],s):s}function Bt(e){Nt.test(e.type)&&(e.defaultChecked=e.checked)}b.extend({clone:function(e,t,n){var r,i,o,a,s,u=b.contains(e.ownerDocument,e);if(b.support.html5Clone||b.isXMLDoc(e)||!mt.test(\"<\"+e.nodeName+\">\")?o=e.cloneNode(!0):(Dt.innerHTML=e.outerHTML,Dt.removeChild(o=Dt.firstChild)),!(b.support.noCloneEvent&&b.support.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||b.isXMLDoc(e)))for(r=Ot(o),s=Ot(e),a=0;null!=(i=s[a]);++a)r[a]&&Ft(i,r[a]);if(t)if(n)for(s=s||Ot(e),r=r||Ot(o),a=0;null!=(i=s[a]);a++)_t(i,r[a]);else _t(e,o);return r=Ot(o,\"script\"),r.length>0&&Mt(r,!u&&Ot(e,\"script\")),r=s=i=null,o},buildFragment:function(e,t,n,r){var i,o,a,s,u,l,c,p=e.length,f=dt(t),d=[],h=0;for(;p>h;h++)if(o=e[h],o||0===o)if(\"object\"===b.type(o))b.merge(d,o.nodeType?[o]:o);else if(wt.test(o)){s=s||f.appendChild(t.createElement(\"div\")),u=(bt.exec(o)||[\"\",\"\"])[1].toLowerCase(),c=At[u]||At._default,s.innerHTML=c[1]+o.replace(vt,\"<$1></$2>\")+c[2],i=c[0];while(i--)s=s.lastChild;if(!b.support.leadingWhitespace&&yt.test(o)&&d.push(t.createTextNode(yt.exec(o)[0])),!b.support.tbody){o=\"table\"!==u||xt.test(o)?\"<table>\"!==c[1]||xt.test(o)?0:s:s.firstChild,i=o&&o.childNodes.length;while(i--)b.nodeName(l=o.childNodes[i],\"tbody\")&&!l.childNodes.length&&o.removeChild(l)\n}b.merge(d,s.childNodes),s.textContent=\"\";while(s.firstChild)s.removeChild(s.firstChild);s=f.lastChild}else d.push(t.createTextNode(o));s&&f.removeChild(s),b.support.appendChecked||b.grep(Ot(d,\"input\"),Bt),h=0;while(o=d[h++])if((!r||-1===b.inArray(o,r))&&(a=b.contains(o.ownerDocument,o),s=Ot(f.appendChild(o),\"script\"),a&&Mt(s),n)){i=0;while(o=s[i++])kt.test(o.type||\"\")&&n.push(o)}return s=null,f},cleanData:function(e,t){var n,r,o,a,s=0,u=b.expando,l=b.cache,p=b.support.deleteExpando,f=b.event.special;for(;null!=(n=e[s]);s++)if((t||b.acceptData(n))&&(o=n[u],a=o&&l[o])){if(a.events)for(r in a.events)f[r]?b.event.remove(n,r):b.removeEvent(n,r,a.handle);l[o]&&(delete l[o],p?delete n[u]:typeof n.removeAttribute!==i?n.removeAttribute(u):n[u]=null,c.push(o))}}});var Pt,Rt,Wt,$t=/alpha\\([^)]*\\)/i,It=/opacity\\s*=\\s*([^)]*)/,zt=/^(top|right|bottom|left)$/,Xt=/^(none|table(?!-c[ea]).+)/,Ut=/^margin/,Vt=RegExp(\"^(\"+x+\")(.*)$\",\"i\"),Yt=RegExp(\"^(\"+x+\")(?!px)[a-z%]+$\",\"i\"),Jt=RegExp(\"^([+-])=(\"+x+\")\",\"i\"),Gt={BODY:\"block\"},Qt={position:\"absolute\",visibility:\"hidden\",display:\"block\"},Kt={letterSpacing:0,fontWeight:400},Zt=[\"Top\",\"Right\",\"Bottom\",\"Left\"],en=[\"Webkit\",\"O\",\"Moz\",\"ms\"];function tn(e,t){if(t in e)return t;var n=t.charAt(0).toUpperCase()+t.slice(1),r=t,i=en.length;while(i--)if(t=en[i]+n,t in e)return t;return r}function nn(e,t){return e=t||e,\"none\"===b.css(e,\"display\")||!b.contains(e.ownerDocument,e)}function rn(e,t){var n,r,i,o=[],a=0,s=e.length;for(;s>a;a++)r=e[a],r.style&&(o[a]=b._data(r,\"olddisplay\"),n=r.style.display,t?(o[a]||\"none\"!==n||(r.style.display=\"\"),\"\"===r.style.display&&nn(r)&&(o[a]=b._data(r,\"olddisplay\",un(r.nodeName)))):o[a]||(i=nn(r),(n&&\"none\"!==n||!i)&&b._data(r,\"olddisplay\",i?n:b.css(r,\"display\"))));for(a=0;s>a;a++)r=e[a],r.style&&(t&&\"none\"!==r.style.display&&\"\"!==r.style.display||(r.style.display=t?o[a]||\"\":\"none\"));return e}b.fn.extend({css:function(e,n){return b.access(this,function(e,n,r){var i,o,a={},s=0;if(b.isArray(n)){for(o=Rt(e),i=n.length;i>s;s++)a[n[s]]=b.css(e,n[s],!1,o);return a}return r!==t?b.style(e,n,r):b.css(e,n)},e,n,arguments.length>1)},show:function(){return rn(this,!0)},hide:function(){return rn(this)},toggle:function(e){var t=\"boolean\"==typeof e;return this.each(function(){(t?e:nn(this))?b(this).show():b(this).hide()})}}),b.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Wt(e,\"opacity\");return\"\"===n?\"1\":n}}}},cssNumber:{columnCount:!0,fillOpacity:!0,fontWeight:!0,lineHeight:!0,opacity:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{\"float\":b.support.cssFloat?\"cssFloat\":\"styleFloat\"},style:function(e,n,r,i){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var o,a,s,u=b.camelCase(n),l=e.style;if(n=b.cssProps[u]||(b.cssProps[u]=tn(l,u)),s=b.cssHooks[n]||b.cssHooks[u],r===t)return s&&\"get\"in s&&(o=s.get(e,!1,i))!==t?o:l[n];if(a=typeof r,\"string\"===a&&(o=Jt.exec(r))&&(r=(o[1]+1)*o[2]+parseFloat(b.css(e,n)),a=\"number\"),!(null==r||\"number\"===a&&isNaN(r)||(\"number\"!==a||b.cssNumber[u]||(r+=\"px\"),b.support.clearCloneStyle||\"\"!==r||0!==n.indexOf(\"background\")||(l[n]=\"inherit\"),s&&\"set\"in s&&(r=s.set(e,r,i))===t)))try{l[n]=r}catch(c){}}},css:function(e,n,r,i){var o,a,s,u=b.camelCase(n);return n=b.cssProps[u]||(b.cssProps[u]=tn(e.style,u)),s=b.cssHooks[n]||b.cssHooks[u],s&&\"get\"in s&&(a=s.get(e,!0,r)),a===t&&(a=Wt(e,n,i)),\"normal\"===a&&n in Kt&&(a=Kt[n]),\"\"===r||r?(o=parseFloat(a),r===!0||b.isNumeric(o)?o||0:a):a},swap:function(e,t,n,r){var i,o,a={};for(o in t)a[o]=e.style[o],e.style[o]=t[o];i=n.apply(e,r||[]);for(o in t)e.style[o]=a[o];return i}}),e.getComputedStyle?(Rt=function(t){return e.getComputedStyle(t,null)},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),u=s?s.getPropertyValue(n)||s[n]:t,l=e.style;return s&&(\"\"!==u||b.contains(e.ownerDocument,e)||(u=b.style(e,n)),Yt.test(u)&&Ut.test(n)&&(i=l.width,o=l.minWidth,a=l.maxWidth,l.minWidth=l.maxWidth=l.width=u,u=s.width,l.width=i,l.minWidth=o,l.maxWidth=a)),u}):o.documentElement.currentStyle&&(Rt=function(e){return e.currentStyle},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),u=s?s[n]:t,l=e.style;return null==u&&l&&l[n]&&(u=l[n]),Yt.test(u)&&!zt.test(n)&&(i=l.left,o=e.runtimeStyle,a=o&&o.left,a&&(o.left=e.currentStyle.left),l.left=\"fontSize\"===n?\"1em\":u,u=l.pixelLeft+\"px\",l.left=i,a&&(o.left=a)),\"\"===u?\"auto\":u});function on(e,t,n){var r=Vt.exec(t);return r?Math.max(0,r[1]-(n||0))+(r[2]||\"px\"):t}function an(e,t,n,r,i){var o=n===(r?\"border\":\"content\")?4:\"width\"===t?1:0,a=0;for(;4>o;o+=2)\"margin\"===n&&(a+=b.css(e,n+Zt[o],!0,i)),r?(\"content\"===n&&(a-=b.css(e,\"padding\"+Zt[o],!0,i)),\"margin\"!==n&&(a-=b.css(e,\"border\"+Zt[o]+\"Width\",!0,i))):(a+=b.css(e,\"padding\"+Zt[o],!0,i),\"padding\"!==n&&(a+=b.css(e,\"border\"+Zt[o]+\"Width\",!0,i)));return a}function sn(e,t,n){var r=!0,i=\"width\"===t?e.offsetWidth:e.offsetHeight,o=Rt(e),a=b.support.boxSizing&&\"border-box\"===b.css(e,\"boxSizing\",!1,o);if(0>=i||null==i){if(i=Wt(e,t,o),(0>i||null==i)&&(i=e.style[t]),Yt.test(i))return i;r=a&&(b.support.boxSizingReliable||i===e.style[t]),i=parseFloat(i)||0}return i+an(e,t,n||(a?\"border\":\"content\"),r,o)+\"px\"}function un(e){var t=o,n=Gt[e];return n||(n=ln(e,t),\"none\"!==n&&n||(Pt=(Pt||b(\"<iframe frameborder='0' width='0' height='0'/>\").css(\"cssText\",\"display:block !important\")).appendTo(t.documentElement),t=(Pt[0].contentWindow||Pt[0].contentDocument).document,t.write(\"<!doctype html><html><body>\"),t.close(),n=ln(e,t),Pt.detach()),Gt[e]=n),n}function ln(e,t){var n=b(t.createElement(e)).appendTo(t.body),r=b.css(n[0],\"display\");return n.remove(),r}b.each([\"height\",\"width\"],function(e,n){b.cssHooks[n]={get:function(e,r,i){return r?0===e.offsetWidth&&Xt.test(b.css(e,\"display\"))?b.swap(e,Qt,function(){return sn(e,n,i)}):sn(e,n,i):t},set:function(e,t,r){var i=r&&Rt(e);return on(e,t,r?an(e,n,r,b.support.boxSizing&&\"border-box\"===b.css(e,\"boxSizing\",!1,i),i):0)}}}),b.support.opacity||(b.cssHooks.opacity={get:function(e,t){return It.test((t&&e.currentStyle?e.currentStyle.filter:e.style.filter)||\"\")?.01*parseFloat(RegExp.$1)+\"\":t?\"1\":\"\"},set:function(e,t){var n=e.style,r=e.currentStyle,i=b.isNumeric(t)?\"alpha(opacity=\"+100*t+\")\":\"\",o=r&&r.filter||n.filter||\"\";n.zoom=1,(t>=1||\"\"===t)&&\"\"===b.trim(o.replace($t,\"\"))&&n.removeAttribute&&(n.removeAttribute(\"filter\"),\"\"===t||r&&!r.filter)||(n.filter=$t.test(o)?o.replace($t,i):o+\" \"+i)}}),b(function(){b.support.reliableMarginRight||(b.cssHooks.marginRight={get:function(e,n){return n?b.swap(e,{display:\"inline-block\"},Wt,[e,\"marginRight\"]):t}}),!b.support.pixelPosition&&b.fn.position&&b.each([\"top\",\"left\"],function(e,n){b.cssHooks[n]={get:function(e,r){return r?(r=Wt(e,n),Yt.test(r)?b(e).position()[n]+\"px\":r):t}}})}),b.expr&&b.expr.filters&&(b.expr.filters.hidden=function(e){return 0>=e.offsetWidth&&0>=e.offsetHeight||!b.support.reliableHiddenOffsets&&\"none\"===(e.style&&e.style.display||b.css(e,\"display\"))},b.expr.filters.visible=function(e){return!b.expr.filters.hidden(e)}),b.each({margin:\"\",padding:\"\",border:\"Width\"},function(e,t){b.cssHooks[e+t]={expand:function(n){var r=0,i={},o=\"string\"==typeof n?n.split(\" \"):[n];for(;4>r;r++)i[e+Zt[r]+t]=o[r]||o[r-2]||o[0];return i}},Ut.test(e)||(b.cssHooks[e+t].set=on)});var cn=/%20/g,pn=/\\[\\]$/,fn=/\\r?\\n/g,dn=/^(?:submit|button|image|reset|file)$/i,hn=/^(?:input|select|textarea|keygen)/i;b.fn.extend({serialize:function(){return b.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=b.prop(this,\"elements\");return e?b.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!b(this).is(\":disabled\")&&hn.test(this.nodeName)&&!dn.test(e)&&(this.checked||!Nt.test(e))}).map(function(e,t){var n=b(this).val();return null==n?null:b.isArray(n)?b.map(n,function(e){return{name:t.name,value:e.replace(fn,\"\\r\\n\")}}):{name:t.name,value:n.replace(fn,\"\\r\\n\")}}).get()}}),b.param=function(e,n){var r,i=[],o=function(e,t){t=b.isFunction(t)?t():null==t?\"\":t,i[i.length]=encodeURIComponent(e)+\"=\"+encodeURIComponent(t)};if(n===t&&(n=b.ajaxSettings&&b.ajaxSettings.traditional),b.isArray(e)||e.jquery&&!b.isPlainObject(e))b.each(e,function(){o(this.name,this.value)});else for(r in e)gn(r,e[r],n,o);return i.join(\"&\").replace(cn,\"+\")};function gn(e,t,n,r){var i;if(b.isArray(t))b.each(t,function(t,i){n||pn.test(e)?r(e,i):gn(e+\"[\"+(\"object\"==typeof i?t:\"\")+\"]\",i,n,r)});else if(n||\"object\"!==b.type(t))r(e,t);else for(i in t)gn(e+\"[\"+i+\"]\",t[i],n,r)}b.each(\"blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu\".split(\" \"),function(e,t){b.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),b.fn.hover=function(e,t){return this.mouseenter(e).mouseleave(t||e)};var mn,yn,vn=b.now(),bn=/\\?/,xn=/#.*$/,wn=/([?&])_=[^&]*/,Tn=/^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/gm,Nn=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,Cn=/^(?:GET|HEAD)$/,kn=/^\\/\\//,En=/^([\\w.+-]+:)(?:\\/\\/([^\\/?#:]*)(?::(\\d+)|)|)/,Sn=b.fn.load,An={},jn={},Dn=\"*/\".concat(\"*\");try{yn=a.href}catch(Ln){yn=o.createElement(\"a\"),yn.href=\"\",yn=yn.href}mn=En.exec(yn.toLowerCase())||[];function Hn(e){return function(t,n){\"string\"!=typeof t&&(n=t,t=\"*\");var r,i=0,o=t.toLowerCase().match(w)||[];if(b.isFunction(n))while(r=o[i++])\"+\"===r[0]?(r=r.slice(1)||\"*\",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function qn(e,n,r,i){var o={},a=e===jn;function s(u){var l;return o[u]=!0,b.each(e[u]||[],function(e,u){var c=u(n,r,i);return\"string\"!=typeof c||a||o[c]?a?!(l=c):t:(n.dataTypes.unshift(c),s(c),!1)}),l}return s(n.dataTypes[0])||!o[\"*\"]&&s(\"*\")}function Mn(e,n){var r,i,o=b.ajaxSettings.flatOptions||{};for(i in n)n[i]!==t&&((o[i]?e:r||(r={}))[i]=n[i]);return r&&b.extend(!0,e,r),e}b.fn.load=function(e,n,r){if(\"string\"!=typeof e&&Sn)return Sn.apply(this,arguments);var i,o,a,s=this,u=e.indexOf(\" \");return u>=0&&(i=e.slice(u,e.length),e=e.slice(0,u)),b.isFunction(n)?(r=n,n=t):n&&\"object\"==typeof n&&(a=\"POST\"),s.length>0&&b.ajax({url:e,type:a,dataType:\"html\",data:n}).done(function(e){o=arguments,s.html(i?b(\"<div>\").append(b.parseHTML(e)).find(i):e)}).complete(r&&function(e,t){s.each(r,o||[e.responseText,t,e])}),this},b.each([\"ajaxStart\",\"ajaxStop\",\"ajaxComplete\",\"ajaxError\",\"ajaxSuccess\",\"ajaxSend\"],function(e,t){b.fn[t]=function(e){return this.on(t,e)}}),b.each([\"get\",\"post\"],function(e,n){b[n]=function(e,r,i,o){return b.isFunction(r)&&(o=o||i,i=r,r=t),b.ajax({url:e,type:n,dataType:o,data:r,success:i})}}),b.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:yn,type:\"GET\",isLocal:Nn.test(mn[1]),global:!0,processData:!0,async:!0,contentType:\"application/x-www-form-urlencoded; charset=UTF-8\",accepts:{\"*\":Dn,text:\"text/plain\",html:\"text/html\",xml:\"application/xml, text/xml\",json:\"application/json, text/javascript\"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:\"responseXML\",text:\"responseText\"},converters:{\"* text\":e.String,\"text html\":!0,\"text json\":b.parseJSON,\"text xml\":b.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Mn(Mn(e,b.ajaxSettings),t):Mn(b.ajaxSettings,e)},ajaxPrefilter:Hn(An),ajaxTransport:Hn(jn),ajax:function(e,n){\"object\"==typeof e&&(n=e,e=t),n=n||{};var r,i,o,a,s,u,l,c,p=b.ajaxSetup({},n),f=p.context||p,d=p.context&&(f.nodeType||f.jquery)?b(f):b.event,h=b.Deferred(),g=b.Callbacks(\"once memory\"),m=p.statusCode||{},y={},v={},x=0,T=\"canceled\",N={readyState:0,getResponseHeader:function(e){var t;if(2===x){if(!c){c={};while(t=Tn.exec(a))c[t[1].toLowerCase()]=t[2]}t=c[e.toLowerCase()]}return null==t?null:t},getAllResponseHeaders:function(){return 2===x?a:null},setRequestHeader:function(e,t){var n=e.toLowerCase();return x||(e=v[n]=v[n]||e,y[e]=t),this},overrideMimeType:function(e){return x||(p.mimeType=e),this},statusCode:function(e){var t;if(e)if(2>x)for(t in e)m[t]=[m[t],e[t]];else N.always(e[N.status]);return this},abort:function(e){var t=e||T;return l&&l.abort(t),k(0,t),this}};if(h.promise(N).complete=g.add,N.success=N.done,N.error=N.fail,p.url=((e||p.url||yn)+\"\").replace(xn,\"\").replace(kn,mn[1]+\"//\"),p.type=n.method||n.type||p.method||p.type,p.dataTypes=b.trim(p.dataType||\"*\").toLowerCase().match(w)||[\"\"],null==p.crossDomain&&(r=En.exec(p.url.toLowerCase()),p.crossDomain=!(!r||r[1]===mn[1]&&r[2]===mn[2]&&(r[3]||(\"http:\"===r[1]?80:443))==(mn[3]||(\"http:\"===mn[1]?80:443)))),p.data&&p.processData&&\"string\"!=typeof p.data&&(p.data=b.param(p.data,p.traditional)),qn(An,p,n,N),2===x)return N;u=p.global,u&&0===b.active++&&b.event.trigger(\"ajaxStart\"),p.type=p.type.toUpperCase(),p.hasContent=!Cn.test(p.type),o=p.url,p.hasContent||(p.data&&(o=p.url+=(bn.test(o)?\"&\":\"?\")+p.data,delete p.data),p.cache===!1&&(p.url=wn.test(o)?o.replace(wn,\"$1_=\"+vn++):o+(bn.test(o)?\"&\":\"?\")+\"_=\"+vn++)),p.ifModified&&(b.lastModified[o]&&N.setRequestHeader(\"If-Modified-Since\",b.lastModified[o]),b.etag[o]&&N.setRequestHeader(\"If-None-Match\",b.etag[o])),(p.data&&p.hasContent&&p.contentType!==!1||n.contentType)&&N.setRequestHeader(\"Content-Type\",p.contentType),N.setRequestHeader(\"Accept\",p.dataTypes[0]&&p.accepts[p.dataTypes[0]]?p.accepts[p.dataTypes[0]]+(\"*\"!==p.dataTypes[0]?\", \"+Dn+\"; q=0.01\":\"\"):p.accepts[\"*\"]);for(i in p.headers)N.setRequestHeader(i,p.headers[i]);if(p.beforeSend&&(p.beforeSend.call(f,N,p)===!1||2===x))return N.abort();T=\"abort\";for(i in{success:1,error:1,complete:1})N[i](p[i]);if(l=qn(jn,p,n,N)){N.readyState=1,u&&d.trigger(\"ajaxSend\",[N,p]),p.async&&p.timeout>0&&(s=setTimeout(function(){N.abort(\"timeout\")},p.timeout));try{x=1,l.send(y,k)}catch(C){if(!(2>x))throw C;k(-1,C)}}else k(-1,\"No Transport\");function k(e,n,r,i){var c,y,v,w,T,C=n;2!==x&&(x=2,s&&clearTimeout(s),l=t,a=i||\"\",N.readyState=e>0?4:0,r&&(w=_n(p,N,r)),e>=200&&300>e||304===e?(p.ifModified&&(T=N.getResponseHeader(\"Last-Modified\"),T&&(b.lastModified[o]=T),T=N.getResponseHeader(\"etag\"),T&&(b.etag[o]=T)),204===e?(c=!0,C=\"nocontent\"):304===e?(c=!0,C=\"notmodified\"):(c=Fn(p,w),C=c.state,y=c.data,v=c.error,c=!v)):(v=C,(e||!C)&&(C=\"error\",0>e&&(e=0))),N.status=e,N.statusText=(n||C)+\"\",c?h.resolveWith(f,[y,C,N]):h.rejectWith(f,[N,C,v]),N.statusCode(m),m=t,u&&d.trigger(c?\"ajaxSuccess\":\"ajaxError\",[N,p,c?y:v]),g.fireWith(f,[N,C]),u&&(d.trigger(\"ajaxComplete\",[N,p]),--b.active||b.event.trigger(\"ajaxStop\")))}return N},getScript:function(e,n){return b.get(e,t,n,\"script\")},getJSON:function(e,t,n){return b.get(e,t,n,\"json\")}});function _n(e,n,r){var i,o,a,s,u=e.contents,l=e.dataTypes,c=e.responseFields;for(s in c)s in r&&(n[c[s]]=r[s]);while(\"*\"===l[0])l.shift(),o===t&&(o=e.mimeType||n.getResponseHeader(\"Content-Type\"));if(o)for(s in u)if(u[s]&&u[s].test(o)){l.unshift(s);break}if(l[0]in r)a=l[0];else{for(s in r){if(!l[0]||e.converters[s+\" \"+l[0]]){a=s;break}i||(i=s)}a=a||i}return a?(a!==l[0]&&l.unshift(a),r[a]):t}function Fn(e,t){var n,r,i,o,a={},s=0,u=e.dataTypes.slice(),l=u[0];if(e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u[1])for(i in e.converters)a[i.toLowerCase()]=e.converters[i];for(;r=u[++s];)if(\"*\"!==r){if(\"*\"!==l&&l!==r){if(i=a[l+\" \"+r]||a[\"* \"+r],!i)for(n in a)if(o=n.split(\" \"),o[1]===r&&(i=a[l+\" \"+o[0]]||a[\"* \"+o[0]])){i===!0?i=a[n]:a[n]!==!0&&(r=o[0],u.splice(s--,0,r));break}if(i!==!0)if(i&&e[\"throws\"])t=i(t);else try{t=i(t)}catch(c){return{state:\"parsererror\",error:i?c:\"No conversion from \"+l+\" to \"+r}}}l=r}return{state:\"success\",data:t}}b.ajaxSetup({accepts:{script:\"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript\"},contents:{script:/(?:java|ecma)script/},converters:{\"text script\":function(e){return b.globalEval(e),e}}}),b.ajaxPrefilter(\"script\",function(e){e.cache===t&&(e.cache=!1),e.crossDomain&&(e.type=\"GET\",e.global=!1)}),b.ajaxTransport(\"script\",function(e){if(e.crossDomain){var n,r=o.head||b(\"head\")[0]||o.documentElement;return{send:function(t,i){n=o.createElement(\"script\"),n.async=!0,e.scriptCharset&&(n.charset=e.scriptCharset),n.src=e.url,n.onload=n.onreadystatechange=function(e,t){(t||!n.readyState||/loaded|complete/.test(n.readyState))&&(n.onload=n.onreadystatechange=null,n.parentNode&&n.parentNode.removeChild(n),n=null,t||i(200,\"success\"))},r.insertBefore(n,r.firstChild)},abort:function(){n&&n.onload(t,!0)}}}});var On=[],Bn=/(=)\\?(?=&|$)|\\?\\?/;b.ajaxSetup({jsonp:\"callback\",jsonpCallback:function(){var e=On.pop()||b.expando+\"_\"+vn++;return this[e]=!0,e}}),b.ajaxPrefilter(\"json jsonp\",function(n,r,i){var o,a,s,u=n.jsonp!==!1&&(Bn.test(n.url)?\"url\":\"string\"==typeof n.data&&!(n.contentType||\"\").indexOf(\"application/x-www-form-urlencoded\")&&Bn.test(n.data)&&\"data\");return u||\"jsonp\"===n.dataTypes[0]?(o=n.jsonpCallback=b.isFunction(n.jsonpCallback)?n.jsonpCallback():n.jsonpCallback,u?n[u]=n[u].replace(Bn,\"$1\"+o):n.jsonp!==!1&&(n.url+=(bn.test(n.url)?\"&\":\"?\")+n.jsonp+\"=\"+o),n.converters[\"script json\"]=function(){return s||b.error(o+\" was not called\"),s[0]},n.dataTypes[0]=\"json\",a=e[o],e[o]=function(){s=arguments},i.always(function(){e[o]=a,n[o]&&(n.jsonpCallback=r.jsonpCallback,On.push(o)),s&&b.isFunction(a)&&a(s[0]),s=a=t}),\"script\"):t});var Pn,Rn,Wn=0,$n=e.ActiveXObject&&function(){var e;for(e in Pn)Pn[e](t,!0)};function In(){try{return new e.XMLHttpRequest}catch(t){}}function zn(){try{return new e.ActiveXObject(\"Microsoft.XMLHTTP\")}catch(t){}}b.ajaxSettings.xhr=e.ActiveXObject?function(){return!this.isLocal&&In()||zn()}:In,Rn=b.ajaxSettings.xhr(),b.support.cors=!!Rn&&\"withCredentials\"in Rn,Rn=b.support.ajax=!!Rn,Rn&&b.ajaxTransport(function(n){if(!n.crossDomain||b.support.cors){var r;return{send:function(i,o){var a,s,u=n.xhr();if(n.username?u.open(n.type,n.url,n.async,n.username,n.password):u.open(n.type,n.url,n.async),n.xhrFields)for(s in n.xhrFields)u[s]=n.xhrFields[s];n.mimeType&&u.overrideMimeType&&u.overrideMimeType(n.mimeType),n.crossDomain||i[\"X-Requested-With\"]||(i[\"X-Requested-With\"]=\"XMLHttpRequest\");try{for(s in i)u.setRequestHeader(s,i[s])}catch(l){}u.send(n.hasContent&&n.data||null),r=function(e,i){var s,l,c,p;try{if(r&&(i||4===u.readyState))if(r=t,a&&(u.onreadystatechange=b.noop,$n&&delete Pn[a]),i)4!==u.readyState&&u.abort();else{p={},s=u.status,l=u.getAllResponseHeaders(),\"string\"==typeof u.responseText&&(p.text=u.responseText);try{c=u.statusText}catch(f){c=\"\"}s||!n.isLocal||n.crossDomain?1223===s&&(s=204):s=p.text?200:404}}catch(d){i||o(-1,d)}p&&o(s,c,p,l)},n.async?4===u.readyState?setTimeout(r):(a=++Wn,$n&&(Pn||(Pn={},b(e).unload($n)),Pn[a]=r),u.onreadystatechange=r):r()},abort:function(){r&&r(t,!0)}}}});var Xn,Un,Vn=/^(?:toggle|show|hide)$/,Yn=RegExp(\"^(?:([+-])=|)(\"+x+\")([a-z%]*)$\",\"i\"),Jn=/queueHooks$/,Gn=[nr],Qn={\"*\":[function(e,t){var n,r,i=this.createTween(e,t),o=Yn.exec(t),a=i.cur(),s=+a||0,u=1,l=20;if(o){if(n=+o[2],r=o[3]||(b.cssNumber[e]?\"\":\"px\"),\"px\"!==r&&s){s=b.css(i.elem,e,!0)||n||1;do u=u||\".5\",s/=u,b.style(i.elem,e,s+r);while(u!==(u=i.cur()/a)&&1!==u&&--l)}i.unit=r,i.start=s,i.end=o[1]?s+(o[1]+1)*n:n}return i}]};function Kn(){return setTimeout(function(){Xn=t}),Xn=b.now()}function Zn(e,t){b.each(t,function(t,n){var r=(Qn[t]||[]).concat(Qn[\"*\"]),i=0,o=r.length;for(;o>i;i++)if(r[i].call(e,t,n))return})}function er(e,t,n){var r,i,o=0,a=Gn.length,s=b.Deferred().always(function(){delete u.elem}),u=function(){if(i)return!1;var t=Xn||Kn(),n=Math.max(0,l.startTime+l.duration-t),r=n/l.duration||0,o=1-r,a=0,u=l.tweens.length;for(;u>a;a++)l.tweens[a].run(o);return s.notifyWith(e,[l,o,n]),1>o&&u?n:(s.resolveWith(e,[l]),!1)},l=s.promise({elem:e,props:b.extend({},t),opts:b.extend(!0,{specialEasing:{}},n),originalProperties:t,originalOptions:n,startTime:Xn||Kn(),duration:n.duration,tweens:[],createTween:function(t,n){var r=b.Tween(e,l.opts,t,n,l.opts.specialEasing[t]||l.opts.easing);return l.tweens.push(r),r},stop:function(t){var n=0,r=t?l.tweens.length:0;if(i)return this;for(i=!0;r>n;n++)l.tweens[n].run(1);return t?s.resolveWith(e,[l,t]):s.rejectWith(e,[l,t]),this}}),c=l.props;for(tr(c,l.opts.specialEasing);a>o;o++)if(r=Gn[o].call(l,e,c,l.opts))return r;return Zn(l,c),b.isFunction(l.opts.start)&&l.opts.start.call(e,l),b.fx.timer(b.extend(u,{elem:e,anim:l,queue:l.opts.queue})),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always)}function tr(e,t){var n,r,i,o,a;for(i in e)if(r=b.camelCase(i),o=t[r],n=e[i],b.isArray(n)&&(o=n[1],n=e[i]=n[0]),i!==r&&(e[r]=n,delete e[i]),a=b.cssHooks[r],a&&\"expand\"in a){n=a.expand(n),delete e[r];for(i in n)i in e||(e[i]=n[i],t[i]=o)}else t[r]=o}b.Animation=b.extend(er,{tweener:function(e,t){b.isFunction(e)?(t=e,e=[\"*\"]):e=e.split(\" \");var n,r=0,i=e.length;for(;i>r;r++)n=e[r],Qn[n]=Qn[n]||[],Qn[n].unshift(t)},prefilter:function(e,t){t?Gn.unshift(e):Gn.push(e)}});function nr(e,t,n){var r,i,o,a,s,u,l,c,p,f=this,d=e.style,h={},g=[],m=e.nodeType&&nn(e);n.queue||(c=b._queueHooks(e,\"fx\"),null==c.unqueued&&(c.unqueued=0,p=c.empty.fire,c.empty.fire=function(){c.unqueued||p()}),c.unqueued++,f.always(function(){f.always(function(){c.unqueued--,b.queue(e,\"fx\").length||c.empty.fire()})})),1===e.nodeType&&(\"height\"in t||\"width\"in t)&&(n.overflow=[d.overflow,d.overflowX,d.overflowY],\"inline\"===b.css(e,\"display\")&&\"none\"===b.css(e,\"float\")&&(b.support.inlineBlockNeedsLayout&&\"inline\"!==un(e.nodeName)?d.zoom=1:d.display=\"inline-block\")),n.overflow&&(d.overflow=\"hidden\",b.support.shrinkWrapBlocks||f.always(function(){d.overflow=n.overflow[0],d.overflowX=n.overflow[1],d.overflowY=n.overflow[2]}));for(i in t)if(a=t[i],Vn.exec(a)){if(delete t[i],u=u||\"toggle\"===a,a===(m?\"hide\":\"show\"))continue;g.push(i)}if(o=g.length){s=b._data(e,\"fxshow\")||b._data(e,\"fxshow\",{}),\"hidden\"in s&&(m=s.hidden),u&&(s.hidden=!m),m?b(e).show():f.done(function(){b(e).hide()}),f.done(function(){var t;b._removeData(e,\"fxshow\");for(t in h)b.style(e,t,h[t])});for(i=0;o>i;i++)r=g[i],l=f.createTween(r,m?s[r]:0),h[r]=s[r]||b.style(e,r),r in s||(s[r]=l.start,m&&(l.end=l.start,l.start=\"width\"===r||\"height\"===r?1:0))}}function rr(e,t,n,r,i){return new rr.prototype.init(e,t,n,r,i)}b.Tween=rr,rr.prototype={constructor:rr,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||\"swing\",this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(b.cssNumber[n]?\"\":\"px\")},cur:function(){var e=rr.propHooks[this.prop];return e&&e.get?e.get(this):rr.propHooks._default.get(this)},run:function(e){var t,n=rr.propHooks[this.prop];return this.pos=t=this.options.duration?b.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):rr.propHooks._default.set(this),this}},rr.prototype.init.prototype=rr.prototype,rr.propHooks={_default:{get:function(e){var t;return null==e.elem[e.prop]||e.elem.style&&null!=e.elem.style[e.prop]?(t=b.css(e.elem,e.prop,\"\"),t&&\"auto\"!==t?t:0):e.elem[e.prop]},set:function(e){b.fx.step[e.prop]?b.fx.step[e.prop](e):e.elem.style&&(null!=e.elem.style[b.cssProps[e.prop]]||b.cssHooks[e.prop])?b.style(e.elem,e.prop,e.now+e.unit):e.elem[e.prop]=e.now}}},rr.propHooks.scrollTop=rr.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},b.each([\"toggle\",\"show\",\"hide\"],function(e,t){var n=b.fn[t];b.fn[t]=function(e,r,i){return null==e||\"boolean\"==typeof e?n.apply(this,arguments):this.animate(ir(t,!0),e,r,i)}}),b.fn.extend({fadeTo:function(e,t,n,r){return this.filter(nn).css(\"opacity\",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=b.isEmptyObject(e),o=b.speed(t,n,r),a=function(){var t=er(this,b.extend({},e),o);a.finish=function(){t.stop(!0)},(i||b._data(this,\"finish\"))&&t.stop(!0)};return a.finish=a,i||o.queue===!1?this.each(a):this.queue(o.queue,a)},stop:function(e,n,r){var i=function(e){var t=e.stop;delete e.stop,t(r)};return\"string\"!=typeof e&&(r=n,n=e,e=t),n&&e!==!1&&this.queue(e||\"fx\",[]),this.each(function(){var t=!0,n=null!=e&&e+\"queueHooks\",o=b.timers,a=b._data(this);if(n)a[n]&&a[n].stop&&i(a[n]);else for(n in a)a[n]&&a[n].stop&&Jn.test(n)&&i(a[n]);for(n=o.length;n--;)o[n].elem!==this||null!=e&&o[n].queue!==e||(o[n].anim.stop(r),t=!1,o.splice(n,1));(t||!r)&&b.dequeue(this,e)})},finish:function(e){return e!==!1&&(e=e||\"fx\"),this.each(function(){var t,n=b._data(this),r=n[e+\"queue\"],i=n[e+\"queueHooks\"],o=b.timers,a=r?r.length:0;for(n.finish=!0,b.queue(this,e,[]),i&&i.cur&&i.cur.finish&&i.cur.finish.call(this),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),o.splice(t,1));for(t=0;a>t;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish})}});function ir(e,t){var n,r={height:e},i=0;for(t=t?1:0;4>i;i+=2-t)n=Zt[i],r[\"margin\"+n]=r[\"padding\"+n]=e;return t&&(r.opacity=r.width=e),r}b.each({slideDown:ir(\"show\"),slideUp:ir(\"hide\"),slideToggle:ir(\"toggle\"),fadeIn:{opacity:\"show\"},fadeOut:{opacity:\"hide\"},fadeToggle:{opacity:\"toggle\"}},function(e,t){b.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}}),b.speed=function(e,t,n){var r=e&&\"object\"==typeof e?b.extend({},e):{complete:n||!n&&t||b.isFunction(e)&&e,duration:e,easing:n&&t||t&&!b.isFunction(t)&&t};return r.duration=b.fx.off?0:\"number\"==typeof r.duration?r.duration:r.duration in b.fx.speeds?b.fx.speeds[r.duration]:b.fx.speeds._default,(null==r.queue||r.queue===!0)&&(r.queue=\"fx\"),r.old=r.complete,r.complete=function(){b.isFunction(r.old)&&r.old.call(this),r.queue&&b.dequeue(this,r.queue)},r},b.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2}},b.timers=[],b.fx=rr.prototype.init,b.fx.tick=function(){var e,n=b.timers,r=0;for(Xn=b.now();n.length>r;r++)e=n[r],e()||n[r]!==e||n.splice(r--,1);n.length||b.fx.stop(),Xn=t},b.fx.timer=function(e){e()&&b.timers.push(e)&&b.fx.start()},b.fx.interval=13,b.fx.start=function(){Un||(Un=setInterval(b.fx.tick,b.fx.interval))},b.fx.stop=function(){clearInterval(Un),Un=null},b.fx.speeds={slow:600,fast:200,_default:400},b.fx.step={},b.expr&&b.expr.filters&&(b.expr.filters.animated=function(e){return b.grep(b.timers,function(t){return e===t.elem}).length}),b.fn.offset=function(e){if(arguments.length)return e===t?this:this.each(function(t){b.offset.setOffset(this,e,t)});var n,r,o={top:0,left:0},a=this[0],s=a&&a.ownerDocument;if(s)return n=s.documentElement,b.contains(n,a)?(typeof a.getBoundingClientRect!==i&&(o=a.getBoundingClientRect()),r=or(s),{top:o.top+(r.pageYOffset||n.scrollTop)-(n.clientTop||0),left:o.left+(r.pageXOffset||n.scrollLeft)-(n.clientLeft||0)}):o},b.offset={setOffset:function(e,t,n){var r=b.css(e,\"position\");\"static\"===r&&(e.style.position=\"relative\");var i=b(e),o=i.offset(),a=b.css(e,\"top\"),s=b.css(e,\"left\"),u=(\"absolute\"===r||\"fixed\"===r)&&b.inArray(\"auto\",[a,s])>-1,l={},c={},p,f;u?(c=i.position(),p=c.top,f=c.left):(p=parseFloat(a)||0,f=parseFloat(s)||0),b.isFunction(t)&&(t=t.call(e,n,o)),null!=t.top&&(l.top=t.top-o.top+p),null!=t.left&&(l.left=t.left-o.left+f),\"using\"in t?t.using.call(e,l):i.css(l)}},b.fn.extend({position:function(){if(this[0]){var e,t,n={top:0,left:0},r=this[0];return\"fixed\"===b.css(r,\"position\")?t=r.getBoundingClientRect():(e=this.offsetParent(),t=this.offset(),b.nodeName(e[0],\"html\")||(n=e.offset()),n.top+=b.css(e[0],\"borderTopWidth\",!0),n.left+=b.css(e[0],\"borderLeftWidth\",!0)),{top:t.top-n.top-b.css(r,\"marginTop\",!0),left:t.left-n.left-b.css(r,\"marginLeft\",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent||o.documentElement;while(e&&!b.nodeName(e,\"html\")&&\"static\"===b.css(e,\"position\"))e=e.offsetParent;return e||o.documentElement})}}),b.each({scrollLeft:\"pageXOffset\",scrollTop:\"pageYOffset\"},function(e,n){var r=/Y/.test(n);b.fn[e]=function(i){return b.access(this,function(e,i,o){var a=or(e);return o===t?a?n in a?a[n]:a.document.documentElement[i]:e[i]:(a?a.scrollTo(r?b(a).scrollLeft():o,r?o:b(a).scrollTop()):e[i]=o,t)},e,i,arguments.length,null)}});function or(e){return b.isWindow(e)?e:9===e.nodeType?e.defaultView||e.parentWindow:!1}b.each({Height:\"height\",Width:\"width\"},function(e,n){b.each({padding:\"inner\"+e,content:n,\"\":\"outer\"+e},function(r,i){b.fn[i]=function(i,o){var a=arguments.length&&(r||\"boolean\"!=typeof i),s=r||(i===!0||o===!0?\"margin\":\"border\");return b.access(this,function(n,r,i){var o;return b.isWindow(n)?n.document.documentElement[\"client\"+e]:9===n.nodeType?(o=n.documentElement,Math.max(n.body[\"scroll\"+e],o[\"scroll\"+e],n.body[\"offset\"+e],o[\"offset\"+e],o[\"client\"+e])):i===t?b.css(n,r,s):b.style(n,r,i,s)},n,a?i:t,a,null)}})}),e.jQuery=e.$=b,\"function\"==typeof define&&define.amd&&define.amd.jQuery&&define(\"jquery\",[],function(){return b})})(window);","Plazathemes_Categorytop/js/owl.carousel.min.js":"\nrequire([\"jquery\"], function($){\n\"function\"!==typeof Object.create&&(Object.create=function(f){function g(){}g.prototype=f;return new g});\n(function(f,g,k){var l={init:function(a,b){this.$elem=f(b);this.options=f.extend({},f.fn.owlCarousel.options,this.$elem.data(),a);this.userOptions=a;this.loadContent()},loadContent:function(){function a(a){var d,e=\"\";if(\"function\"===typeof b.options.jsonSuccess)b.options.jsonSuccess.apply(this,[a]);else{for(d in a.owl)a.owl.hasOwnProperty(d)&&(e+=a.owl[d].item);b.$elem.html(e)}b.logIn()}var b=this,e;\"function\"===typeof b.options.beforeInit&&b.options.beforeInit.apply(this,[b.$elem]);\"string\"===typeof b.options.jsonPath?\n(e=b.options.jsonPath,f.getJSON(e,a)):b.logIn()},logIn:function(){this.$elem.data(\"owl-originalStyles\",this.$elem.attr(\"style\"));this.$elem.data(\"owl-originalClasses\",this.$elem.attr(\"class\"));this.$elem.css({opacity:0});this.orignalItems=this.options.items;this.checkBrowser();this.wrapperWidth=0;this.checkVisible=null;this.setVars()},setVars:function(){if(0===this.$elem.children().length)return!1;this.baseClass();this.eventTypes();this.$userItems=this.$elem.children();this.itemsAmount=this.$userItems.length;\nthis.wrapItems();this.$owlItems=this.$elem.find(\".owl-item\");this.$owlWrapper=this.$elem.find(\".owl-wrapper\");this.playDirection=\"next\";this.prevItem=0;this.prevArr=[0];this.currentItem=0;this.customEvents();this.onStartup()},onStartup:function(){this.updateItems();this.calculateAll();this.buildControls();this.updateControls();this.response();this.moveEvents();this.stopOnHover();this.owlStatus();!1!==this.options.transitionStyle&&this.transitionTypes(this.options.transitionStyle);!0===this.options.autoPlay&&\n(this.options.autoPlay=5E3);this.play();this.$elem.find(\".owl-wrapper\").css(\"display\",\"block\");this.$elem.is(\":visible\")?this.$elem.css(\"opacity\",1):this.watchVisibility();this.onstartup=!1;this.eachMoveUpdate();\"function\"===typeof this.options.afterInit&&this.options.afterInit.apply(this,[this.$elem])},eachMoveUpdate:function(){!0===this.options.lazyLoad&&this.lazyLoad();!0===this.options.autoHeight&&this.autoHeight();this.onVisibleItems();\"function\"===typeof this.options.afterAction&&this.options.afterAction.apply(this,\n[this.$elem])},updateVars:function(){\"function\"===typeof this.options.beforeUpdate&&this.options.beforeUpdate.apply(this,[this.$elem]);this.watchVisibility();this.updateItems();this.calculateAll();this.updatePosition();this.updateControls();this.eachMoveUpdate();\"function\"===typeof this.options.afterUpdate&&this.options.afterUpdate.apply(this,[this.$elem])},reload:function(){var a=this;g.setTimeout(function(){a.updateVars()},0)},watchVisibility:function(){var a=this;if(!1===a.$elem.is(\":visible\"))a.$elem.css({opacity:0}),\ng.clearInterval(a.autoPlayInterval),g.clearInterval(a.checkVisible);else return!1;a.checkVisible=g.setInterval(function(){a.$elem.is(\":visible\")&&(a.reload(),a.$elem.animate({opacity:1},200),g.clearInterval(a.checkVisible))},500)},wrapItems:function(){this.$userItems.wrapAll('<div class=\"owl-wrapper\">').wrap('<div class=\"owl-item\"></div>');this.$elem.find(\".owl-wrapper\").wrap('<div class=\"owl-wrapper-outer\">');this.wrapperOuter=this.$elem.find(\".owl-wrapper-outer\");this.$elem.css(\"display\",\"block\")},\nbaseClass:function(){var a=this.$elem.hasClass(this.options.baseClass),b=this.$elem.hasClass(this.options.theme);a||this.$elem.addClass(this.options.baseClass);b||this.$elem.addClass(this.options.theme)},updateItems:function(){var a,b;if(!1===this.options.responsive)return!1;if(!0===this.options.singleItem)return this.options.items=this.orignalItems=1,this.options.itemsCustom=!1,this.options.itemsDesktop=!1,this.options.itemsDesktopSmall=!1,this.options.itemsTablet=!1,this.options.itemsTabletSmall=\n!1,this.options.itemsMobile=!1;a=f(this.options.responsiveBaseWidth).width();a>(this.options.itemsDesktop[0]||this.orignalItems)&&(this.options.items=this.orignalItems);if(!1!==this.options.itemsCustom)for(this.options.itemsCustom.sort(function(a,b){return a[0]-b[0]}),b=0;b<this.options.itemsCustom.length;b+=1)this.options.itemsCustom[b][0]<=a&&(this.options.items=this.options.itemsCustom[b][1]);else a<=this.options.itemsDesktop[0]&&!1!==this.options.itemsDesktop&&(this.options.items=this.options.itemsDesktop[1]),\na<=this.options.itemsDesktopSmall[0]&&!1!==this.options.itemsDesktopSmall&&(this.options.items=this.options.itemsDesktopSmall[1]),a<=this.options.itemsTablet[0]&&!1!==this.options.itemsTablet&&(this.options.items=this.options.itemsTablet[1]),a<=this.options.itemsTabletSmall[0]&&!1!==this.options.itemsTabletSmall&&(this.options.items=this.options.itemsTabletSmall[1]),a<=this.options.itemsMobile[0]&&!1!==this.options.itemsMobile&&(this.options.items=this.options.itemsMobile[1]);this.options.items>this.itemsAmount&&\n!0===this.options.itemsScaleUp&&(this.options.items=this.itemsAmount)},response:function(){var a=this,b,e;if(!0!==a.options.responsive)return!1;e=f(g).width();a.resizer=function(){f(g).width()!==e&&(!1!==a.options.autoPlay&&g.clearInterval(a.autoPlayInterval),g.clearTimeout(b),b=g.setTimeout(function(){e=f(g).width();a.updateVars()},a.options.responsiveRefreshRate))};f(g).resize(a.resizer)},updatePosition:function(){this.jumpTo(this.currentItem);!1!==this.options.autoPlay&&this.checkAp()},appendItemsSizes:function(){var a=\nthis,b=0,e=a.itemsAmount-a.options.items;a.$owlItems.each(function(c){var d=f(this);d.css({width:a.itemWidth}).data(\"owl-item\",Number(c));if(0===c%a.options.items||c===e)c>e||(b+=1);d.data(\"owl-roundPages\",b)})},appendWrapperSizes:function(){this.$owlWrapper.css({width:this.$owlItems.length*this.itemWidth*2,left:0});this.appendItemsSizes()},calculateAll:function(){this.calculateWidth();this.appendWrapperSizes();this.loops();this.max()},calculateWidth:function(){this.itemWidth=Math.round(this.$elem.width()/\nthis.options.items)},max:function(){var a=-1*(this.itemsAmount*this.itemWidth-this.options.items*this.itemWidth);this.options.items>this.itemsAmount?this.maximumPixels=a=this.maximumItem=0:(this.maximumItem=this.itemsAmount-this.options.items,this.maximumPixels=a);return a},min:function(){return 0},loops:function(){var a=0,b=0,e,c;this.positionsInArray=[0];this.pagesInArray=[];for(e=0;e<this.itemsAmount;e+=1)b+=this.itemWidth,this.positionsInArray.push(-b),!0===this.options.scrollPerPage&&(c=f(this.$owlItems[e]),\nc=c.data(\"owl-roundPages\"),c!==a&&(this.pagesInArray[a]=this.positionsInArray[e],a=c))},buildControls:function(){if(!0===this.options.navigation||!0===this.options.pagination)this.owlControls=f('<div class=\"owl-controls\"/>').toggleClass(\"clickable\",!this.browser.isTouch).appendTo(this.$elem);!0===this.options.pagination&&this.buildPagination();!0===this.options.navigation&&this.buildButtons()},buildButtons:function(){var a=this,b=f('<div class=\"owl-buttons\"/>');a.owlControls.append(b);a.buttonPrev=\nf(\"<div/>\",{\"class\":\"owl-prev\",html:a.options.navigationText[0]||\"\"});a.buttonNext=f(\"<div/>\",{\"class\":\"owl-next\",html:a.options.navigationText[1]||\"\"});b.append(a.buttonPrev).append(a.buttonNext);b.on(\"touchstart.owlControls mousedown.owlControls\",'div[class^=\"owl\"]',function(a){a.preventDefault()});b.on(\"touchend.owlControls mouseup.owlControls\",'div[class^=\"owl\"]',function(b){b.preventDefault();f(this).hasClass(\"owl-next\")?a.next():a.prev()})},buildPagination:function(){var a=this;a.paginationWrapper=\nf('<div class=\"owl-pagination\"/>');a.owlControls.append(a.paginationWrapper);a.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\",\".owl-page\",function(b){b.preventDefault();Number(f(this).data(\"owl-page\"))!==a.currentItem&&a.goTo(Number(f(this).data(\"owl-page\")),!0)})},updatePagination:function(){var a,b,e,c,d,g;if(!1===this.options.pagination)return!1;this.paginationWrapper.html(\"\");a=0;b=this.itemsAmount-this.itemsAmount%this.options.items;for(c=0;c<this.itemsAmount;c+=1)0===c%this.options.items&&\n(a+=1,b===c&&(e=this.itemsAmount-this.options.items),d=f(\"<div/>\",{\"class\":\"owl-page\"}),g=f(\"<span></span>\",{text:!0===this.options.paginationNumbers?a:\"\",\"class\":!0===this.options.paginationNumbers?\"owl-numbers\":\"\"}),d.append(g),d.data(\"owl-page\",b===c?e:c),d.data(\"owl-roundPages\",a),this.paginationWrapper.append(d));this.checkPagination()},checkPagination:function(){var a=this;if(!1===a.options.pagination)return!1;a.paginationWrapper.find(\".owl-page\").each(function(){f(this).data(\"owl-roundPages\")===\nf(a.$owlItems[a.currentItem]).data(\"owl-roundPages\")&&(a.paginationWrapper.find(\".owl-page\").removeClass(\"active\"),f(this).addClass(\"active\"))})},checkNavigation:function(){if(!1===this.options.navigation)return!1;!1===this.options.rewindNav&&(0===this.currentItem&&0===this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0===this.currentItem&&0!==this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")):this.currentItem===\nthis.maximumItem?(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0!==this.currentItem&&this.currentItem!==this.maximumItem&&(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")))},updateControls:function(){this.updatePagination();this.checkNavigation();this.owlControls&&(this.options.items>=this.itemsAmount?this.owlControls.hide():this.owlControls.show())},destroyControls:function(){this.owlControls&&this.owlControls.remove()},next:function(a){if(this.isTransition)return!1;\nthis.currentItem+=!0===this.options.scrollPerPage?this.options.items:1;if(this.currentItem>this.maximumItem+(!0===this.options.scrollPerPage?this.options.items-1:0))if(!0===this.options.rewindNav)this.currentItem=0,a=\"rewind\";else return this.currentItem=this.maximumItem,!1;this.goTo(this.currentItem,a)},prev:function(a){if(this.isTransition)return!1;this.currentItem=!0===this.options.scrollPerPage&&0<this.currentItem&&this.currentItem<this.options.items?0:this.currentItem-(!0===this.options.scrollPerPage?\nthis.options.items:1);if(0>this.currentItem)if(!0===this.options.rewindNav)this.currentItem=this.maximumItem,a=\"rewind\";else return this.currentItem=0,!1;this.goTo(this.currentItem,a)},goTo:function(a,b,e){var c=this;if(c.isTransition)return!1;\"function\"===typeof c.options.beforeMove&&c.options.beforeMove.apply(this,[c.$elem]);a>=c.maximumItem?a=c.maximumItem:0>=a&&(a=0);c.currentItem=c.owl.currentItem=a;if(!1!==c.options.transitionStyle&&\"drag\"!==e&&1===c.options.items&&!0===c.browser.support3d)return c.swapSpeed(0),\n!0===c.browser.support3d?c.transition3d(c.positionsInArray[a]):c.css2slide(c.positionsInArray[a],1),c.afterGo(),c.singleItemTransition(),!1;a=c.positionsInArray[a];!0===c.browser.support3d?(c.isCss3Finish=!1,!0===b?(c.swapSpeed(\"paginationSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},c.options.paginationSpeed)):\"rewind\"===b?(c.swapSpeed(c.options.rewindSpeed),g.setTimeout(function(){c.isCss3Finish=!0},c.options.rewindSpeed)):(c.swapSpeed(\"slideSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},\nc.options.slideSpeed)),c.transition3d(a)):!0===b?c.css2slide(a,c.options.paginationSpeed):\"rewind\"===b?c.css2slide(a,c.options.rewindSpeed):c.css2slide(a,c.options.slideSpeed);c.afterGo()},jumpTo:function(a){\"function\"===typeof this.options.beforeMove&&this.options.beforeMove.apply(this,[this.$elem]);a>=this.maximumItem||-1===a?a=this.maximumItem:0>=a&&(a=0);this.swapSpeed(0);!0===this.browser.support3d?this.transition3d(this.positionsInArray[a]):this.css2slide(this.positionsInArray[a],1);this.currentItem=\nthis.owl.currentItem=a;this.afterGo()},afterGo:function(){this.prevArr.push(this.currentItem);this.prevItem=this.owl.prevItem=this.prevArr[this.prevArr.length-2];this.prevArr.shift(0);this.prevItem!==this.currentItem&&(this.checkPagination(),this.checkNavigation(),this.eachMoveUpdate(),!1!==this.options.autoPlay&&this.checkAp());\"function\"===typeof this.options.afterMove&&this.prevItem!==this.currentItem&&this.options.afterMove.apply(this,[this.$elem])},stop:function(){this.apStatus=\"stop\";g.clearInterval(this.autoPlayInterval)},\ncheckAp:function(){\"stop\"!==this.apStatus&&this.play()},play:function(){var a=this;a.apStatus=\"play\";if(!1===a.options.autoPlay)return!1;g.clearInterval(a.autoPlayInterval);a.autoPlayInterval=g.setInterval(function(){a.next(!0)},a.options.autoPlay)},swapSpeed:function(a){\"slideSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.slideSpeed)):\"paginationSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.paginationSpeed)):\"string\"!==typeof a&&this.$owlWrapper.css(this.addCssSpeed(a))},\naddCssSpeed:function(a){return{\"-webkit-transition\":\"all \"+a+\"ms ease\",\"-moz-transition\":\"all \"+a+\"ms ease\",\"-o-transition\":\"all \"+a+\"ms ease\",transition:\"all \"+a+\"ms ease\"}},removeTransition:function(){return{\"-webkit-transition\":\"\",\"-moz-transition\":\"\",\"-o-transition\":\"\",transition:\"\"}},doTranslate:function(a){return{\"-webkit-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-moz-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-o-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-ms-transform\":\"translate3d(\"+\na+\"px, 0px, 0px)\",transform:\"translate3d(\"+a+\"px, 0px,0px)\"}},transition3d:function(a){this.$owlWrapper.css(this.doTranslate(a))},css2move:function(a){this.$owlWrapper.css({left:a})},css2slide:function(a,b){var e=this;e.isCssFinish=!1;e.$owlWrapper.stop(!0,!0).animate({left:a},{duration:b||e.options.slideSpeed,complete:function(){e.isCssFinish=!0}})},checkBrowser:function(){var a=k.createElement(\"div\");a.style.cssText=\"  -moz-transform:translate3d(0px, 0px, 0px); -ms-transform:translate3d(0px, 0px, 0px); -o-transform:translate3d(0px, 0px, 0px); -webkit-transform:translate3d(0px, 0px, 0px); transform:translate3d(0px, 0px, 0px)\";\na=a.style.cssText.match(/translate3d\\(0px, 0px, 0px\\)/g);this.browser={support3d:null!==a&&1===a.length,isTouch:\"ontouchstart\"in g||g.navigator.msMaxTouchPoints}},moveEvents:function(){if(!1!==this.options.mouseDrag||!1!==this.options.touchDrag)this.gestures(),this.disabledEvents()},eventTypes:function(){var a=[\"s\",\"e\",\"x\"];this.ev_types={};!0===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl mousedown.owl\",\"touchmove.owl mousemove.owl\",\"touchend.owl touchcancel.owl mouseup.owl\"]:\n!1===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl\",\"touchmove.owl\",\"touchend.owl touchcancel.owl\"]:!0===this.options.mouseDrag&&!1===this.options.touchDrag&&(a=[\"mousedown.owl\",\"mousemove.owl\",\"mouseup.owl\"]);this.ev_types.start=a[0];this.ev_types.move=a[1];this.ev_types.end=a[2]},disabledEvents:function(){this.$elem.on(\"dragstart.owl\",function(a){a.preventDefault()});this.$elem.on(\"mousedown.disableTextSelect\",function(a){return f(a.target).is(\"input, textarea, select, option\")})},\ngestures:function(){function a(a){if(void 0!==a.touches)return{x:a.touches[0].pageX,y:a.touches[0].pageY};if(void 0===a.touches){if(void 0!==a.pageX)return{x:a.pageX,y:a.pageY};if(void 0===a.pageX)return{x:a.clientX,y:a.clientY}}}function b(a){\"on\"===a?(f(k).on(d.ev_types.move,e),f(k).on(d.ev_types.end,c)):\"off\"===a&&(f(k).off(d.ev_types.move),f(k).off(d.ev_types.end))}function e(b){b=b.originalEvent||b||g.event;d.newPosX=a(b).x-h.offsetX;d.newPosY=a(b).y-h.offsetY;d.newRelativeX=d.newPosX-h.relativePos;\n\"function\"===typeof d.options.startDragging&&!0!==h.dragging&&0!==d.newRelativeX&&(h.dragging=!0,d.options.startDragging.apply(d,[d.$elem]));(8<d.newRelativeX||-8>d.newRelativeX)&&!0===d.browser.isTouch&&(void 0!==b.preventDefault?b.preventDefault():b.returnValue=!1,h.sliding=!0);(10<d.newPosY||-10>d.newPosY)&&!1===h.sliding&&f(k).off(\"touchmove.owl\");d.newPosX=Math.max(Math.min(d.newPosX,d.newRelativeX/5),d.maximumPixels+d.newRelativeX/5);!0===d.browser.support3d?d.transition3d(d.newPosX):d.css2move(d.newPosX)}\nfunction c(a){a=a.originalEvent||a||g.event;var c;a.target=a.target||a.srcElement;h.dragging=!1;!0!==d.browser.isTouch&&d.$owlWrapper.removeClass(\"grabbing\");d.dragDirection=0>d.newRelativeX?d.owl.dragDirection=\"left\":d.owl.dragDirection=\"right\";0!==d.newRelativeX&&(c=d.getNewPosition(),d.goTo(c,!1,\"drag\"),h.targetElement===a.target&&!0!==d.browser.isTouch&&(f(a.target).on(\"click.disable\",function(a){a.stopImmediatePropagation();a.stopPropagation();a.preventDefault();f(a.target).off(\"click.disable\")}),\na=f._data(a.target,\"events\").click,c=a.pop(),a.splice(0,0,c)));b(\"off\")}var d=this,h={offsetX:0,offsetY:0,baseElWidth:0,relativePos:0,position:null,minSwipe:null,maxSwipe:null,sliding:null,dargging:null,targetElement:null};d.isCssFinish=!0;d.$elem.on(d.ev_types.start,\".owl-wrapper\",function(c){c=c.originalEvent||c||g.event;var e;if(3===c.which)return!1;if(!(d.itemsAmount<=d.options.items)){if(!1===d.isCssFinish&&!d.options.dragBeforeAnimFinish||!1===d.isCss3Finish&&!d.options.dragBeforeAnimFinish)return!1;\n!1!==d.options.autoPlay&&g.clearInterval(d.autoPlayInterval);!0===d.browser.isTouch||d.$owlWrapper.hasClass(\"grabbing\")||d.$owlWrapper.addClass(\"grabbing\");d.newPosX=0;d.newRelativeX=0;f(this).css(d.removeTransition());e=f(this).position();h.relativePos=e.left;h.offsetX=a(c).x-e.left;h.offsetY=a(c).y-e.top;b(\"on\");h.sliding=!1;h.targetElement=c.target||c.srcElement}})},getNewPosition:function(){var a=this.closestItem();a>this.maximumItem?a=this.currentItem=this.maximumItem:0<=this.newPosX&&(this.currentItem=\na=0);return a},closestItem:function(){var a=this,b=!0===a.options.scrollPerPage?a.pagesInArray:a.positionsInArray,e=a.newPosX,c=null;f.each(b,function(d,g){e-a.itemWidth/20>b[d+1]&&e-a.itemWidth/20<g&&\"left\"===a.moveDirection()?(c=g,a.currentItem=!0===a.options.scrollPerPage?f.inArray(c,a.positionsInArray):d):e+a.itemWidth/20<g&&e+a.itemWidth/20>(b[d+1]||b[d]-a.itemWidth)&&\"right\"===a.moveDirection()&&(!0===a.options.scrollPerPage?(c=b[d+1]||b[b.length-1],a.currentItem=f.inArray(c,a.positionsInArray)):\n(c=b[d+1],a.currentItem=d+1))});return a.currentItem},moveDirection:function(){var a;0>this.newRelativeX?(a=\"right\",this.playDirection=\"next\"):(a=\"left\",this.playDirection=\"prev\");return a},customEvents:function(){var a=this;a.$elem.on(\"owl.next\",function(){a.next()});a.$elem.on(\"owl.prev\",function(){a.prev()});a.$elem.on(\"owl.play\",function(b,e){a.options.autoPlay=e;a.play();a.hoverStatus=\"play\"});a.$elem.on(\"owl.stop\",function(){a.stop();a.hoverStatus=\"stop\"});a.$elem.on(\"owl.goTo\",function(b,e){a.goTo(e)});\na.$elem.on(\"owl.jumpTo\",function(b,e){a.jumpTo(e)})},stopOnHover:function(){var a=this;!0===a.options.stopOnHover&&!0!==a.browser.isTouch&&!1!==a.options.autoPlay&&(a.$elem.on(\"mouseover\",function(){a.stop()}),a.$elem.on(\"mouseout\",function(){\"stop\"!==a.hoverStatus&&a.play()}))},lazyLoad:function(){var a,b,e,c,d;if(!1===this.options.lazyLoad)return!1;for(a=0;a<this.itemsAmount;a+=1)b=f(this.$owlItems[a]),\"loaded\"!==b.data(\"owl-loaded\")&&(e=b.data(\"owl-item\"),c=b.find(\".lazyOwl\"),\"string\"!==typeof c.data(\"src\")?\nb.data(\"owl-loaded\",\"loaded\"):(void 0===b.data(\"owl-loaded\")&&(c.hide(),b.addClass(\"loading\").data(\"owl-loaded\",\"checked\")),(d=!0===this.options.lazyFollow?e>=this.currentItem:!0)&&e<this.currentItem+this.options.items&&c.length&&this.lazyPreload(b,c)))},lazyPreload:function(a,b){function e(){a.data(\"owl-loaded\",\"loaded\").removeClass(\"loading\");b.removeAttr(\"data-src\");\"fade\"===d.options.lazyEffect?b.fadeIn(400):b.show();\"function\"===typeof d.options.afterLazyLoad&&d.options.afterLazyLoad.apply(this,\n[d.$elem])}function c(){f+=1;d.completeImg(b.get(0))||!0===k?e():100>=f?g.setTimeout(c,100):e()}var d=this,f=0,k;\"DIV\"===b.prop(\"tagName\")?(b.css(\"background-image\",\"url(\"+b.data(\"src\")+\")\"),k=!0):b[0].src=b.data(\"src\");c()},autoHeight:function(){function a(){var a=f(e.$owlItems[e.currentItem]).height();e.wrapperOuter.css(\"height\",a+\"px\");e.wrapperOuter.hasClass(\"autoHeight\")||g.setTimeout(function(){e.wrapperOuter.addClass(\"autoHeight\")},0)}function b(){d+=1;e.completeImg(c.get(0))?a():100>=d?g.setTimeout(b,\n100):e.wrapperOuter.css(\"height\",\"\")}var e=this,c=f(e.$owlItems[e.currentItem]).find(\"img\"),d;void 0!==c.get(0)?(d=0,b()):a()},completeImg:function(a){return!a.complete||\"undefined\"!==typeof a.naturalWidth&&0===a.naturalWidth?!1:!0},onVisibleItems:function(){var a;!0===this.options.addClassActive&&this.$owlItems.removeClass(\"active\");this.visibleItems=[];for(a=this.currentItem;a<this.currentItem+this.options.items;a+=1)this.visibleItems.push(a),!0===this.options.addClassActive&&f(this.$owlItems[a]).addClass(\"active\");\nthis.owl.visibleItems=this.visibleItems},transitionTypes:function(a){this.outClass=\"owl-\"+a+\"-out\";this.inClass=\"owl-\"+a+\"-in\"},singleItemTransition:function(){var a=this,b=a.outClass,e=a.inClass,c=a.$owlItems.eq(a.currentItem),d=a.$owlItems.eq(a.prevItem),f=Math.abs(a.positionsInArray[a.currentItem])+a.positionsInArray[a.prevItem],g=Math.abs(a.positionsInArray[a.currentItem])+a.itemWidth/2;a.isTransition=!0;a.$owlWrapper.addClass(\"owl-origin\").css({\"-webkit-transform-origin\":g+\"px\",\"-moz-perspective-origin\":g+\n\"px\",\"perspective-origin\":g+\"px\"});d.css({position:\"relative\",left:f+\"px\"}).addClass(b).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endPrev=!0;d.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(d,b)});c.addClass(e).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endCurrent=!0;c.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(c,e)})},clearTransStyle:function(a,\nb){a.css({position:\"\",left:\"\"}).removeClass(b);this.endPrev&&this.endCurrent&&(this.$owlWrapper.removeClass(\"owl-origin\"),this.isTransition=this.endCurrent=this.endPrev=!1)},owlStatus:function(){this.owl={userOptions:this.userOptions,baseElement:this.$elem,userItems:this.$userItems,owlItems:this.$owlItems,currentItem:this.currentItem,prevItem:this.prevItem,visibleItems:this.visibleItems,isTouch:this.browser.isTouch,browser:this.browser,dragDirection:this.dragDirection}},clearEvents:function(){this.$elem.off(\".owl owl mousedown.disableTextSelect\");\nf(k).off(\".owl owl\");f(g).off(\"resize\",this.resizer)},unWrap:function(){0!==this.$elem.children().length&&(this.$owlWrapper.unwrap(),this.$userItems.unwrap().unwrap(),this.owlControls&&this.owlControls.remove());this.clearEvents();this.$elem.attr(\"style\",this.$elem.data(\"owl-originalStyles\")||\"\").attr(\"class\",this.$elem.data(\"owl-originalClasses\"))},destroy:function(){this.stop();g.clearInterval(this.checkVisible);this.unWrap();this.$elem.removeData()},reinit:function(a){a=f.extend({},this.userOptions,\na);this.unWrap();this.init(a,this.$elem)},addItem:function(a,b){var e;if(!a)return!1;if(0===this.$elem.children().length)return this.$elem.append(a),this.setVars(),!1;this.unWrap();e=void 0===b||-1===b?-1:b;e>=this.$userItems.length||-1===e?this.$userItems.eq(-1).after(a):this.$userItems.eq(e).before(a);this.setVars()},removeItem:function(a){if(0===this.$elem.children().length)return!1;a=void 0===a||-1===a?-1:a;this.unWrap();this.$userItems.eq(a).remove();this.setVars()}};f.fn.owlCarousel=function(a){return this.each(function(){if(!0===\nf(this).data(\"owl-init\"))return!1;f(this).data(\"owl-init\",!0);var b=Object.create(l);b.init(a,this);f.data(this,\"owlCarousel\",b)})};f.fn.owlCarousel.options={items:5,itemsCustom:!1,itemsDesktop:[1199,4],itemsDesktopSmall:[979,3],itemsTablet:[768,2],itemsTabletSmall:!1,itemsMobile:[479,1],singleItem:!1,itemsScaleUp:!1,slideSpeed:200,paginationSpeed:800,rewindSpeed:1E3,autoPlay:!1,stopOnHover:!1,navigation:!1,navigationText:[\"prev\",\"next\"],rewindNav:!0,scrollPerPage:!1,pagination:!0,paginationNumbers:!1,\nresponsive:!0,responsiveRefreshRate:200,responsiveBaseWidth:g,baseClass:\"owl-carousel\",theme:\"owl-theme\",lazyLoad:!1,lazyFollow:!0,lazyEffect:\"fade\",autoHeight:!1,jsonPath:!1,jsonSuccess:!1,dragBeforeAnimFinish:!0,mouseDrag:!0,touchDrag:!0,addClassActive:!1,transitionStyle:!1,beforeUpdate:!1,afterUpdate:!1,beforeInit:!1,afterInit:!1,beforeMove:!1,afterMove:!1,afterAction:!1,startDragging:!1,afterLazyLoad:!1}})(jQuery,window,document);\n});","Plazathemes_Featureproductslider/js/owl.carousel.min.js":"\nrequire([\"jquery\"], function($){\n\"function\"!==typeof Object.create&&(Object.create=function(f){function g(){}g.prototype=f;return new g});\n(function(f,g,k){var l={init:function(a,b){this.$elem=f(b);this.options=f.extend({},f.fn.owlCarousel.options,this.$elem.data(),a);this.userOptions=a;this.loadContent()},loadContent:function(){function a(a){var d,e=\"\";if(\"function\"===typeof b.options.jsonSuccess)b.options.jsonSuccess.apply(this,[a]);else{for(d in a.owl)a.owl.hasOwnProperty(d)&&(e+=a.owl[d].item);b.$elem.html(e)}b.logIn()}var b=this,e;\"function\"===typeof b.options.beforeInit&&b.options.beforeInit.apply(this,[b.$elem]);\"string\"===typeof b.options.jsonPath?\n(e=b.options.jsonPath,f.getJSON(e,a)):b.logIn()},logIn:function(){this.$elem.data(\"owl-originalStyles\",this.$elem.attr(\"style\"));this.$elem.data(\"owl-originalClasses\",this.$elem.attr(\"class\"));this.$elem.css({opacity:0});this.orignalItems=this.options.items;this.checkBrowser();this.wrapperWidth=0;this.checkVisible=null;this.setVars()},setVars:function(){if(0===this.$elem.children().length)return!1;this.baseClass();this.eventTypes();this.$userItems=this.$elem.children();this.itemsAmount=this.$userItems.length;\nthis.wrapItems();this.$owlItems=this.$elem.find(\".owl-item\");this.$owlWrapper=this.$elem.find(\".owl-wrapper\");this.playDirection=\"next\";this.prevItem=0;this.prevArr=[0];this.currentItem=0;this.customEvents();this.onStartup()},onStartup:function(){this.updateItems();this.calculateAll();this.buildControls();this.updateControls();this.response();this.moveEvents();this.stopOnHover();this.owlStatus();!1!==this.options.transitionStyle&&this.transitionTypes(this.options.transitionStyle);!0===this.options.autoPlay&&\n(this.options.autoPlay=5E3);this.play();this.$elem.find(\".owl-wrapper\").css(\"display\",\"block\");this.$elem.is(\":visible\")?this.$elem.css(\"opacity\",1):this.watchVisibility();this.onstartup=!1;this.eachMoveUpdate();\"function\"===typeof this.options.afterInit&&this.options.afterInit.apply(this,[this.$elem])},eachMoveUpdate:function(){!0===this.options.lazyLoad&&this.lazyLoad();!0===this.options.autoHeight&&this.autoHeight();this.onVisibleItems();\"function\"===typeof this.options.afterAction&&this.options.afterAction.apply(this,\n[this.$elem])},updateVars:function(){\"function\"===typeof this.options.beforeUpdate&&this.options.beforeUpdate.apply(this,[this.$elem]);this.watchVisibility();this.updateItems();this.calculateAll();this.updatePosition();this.updateControls();this.eachMoveUpdate();\"function\"===typeof this.options.afterUpdate&&this.options.afterUpdate.apply(this,[this.$elem])},reload:function(){var a=this;g.setTimeout(function(){a.updateVars()},0)},watchVisibility:function(){var a=this;if(!1===a.$elem.is(\":visible\"))a.$elem.css({opacity:0}),\ng.clearInterval(a.autoPlayInterval),g.clearInterval(a.checkVisible);else return!1;a.checkVisible=g.setInterval(function(){a.$elem.is(\":visible\")&&(a.reload(),a.$elem.animate({opacity:1},200),g.clearInterval(a.checkVisible))},500)},wrapItems:function(){this.$userItems.wrapAll('<div class=\"owl-wrapper\">').wrap('<div class=\"owl-item\"></div>');this.$elem.find(\".owl-wrapper\").wrap('<div class=\"owl-wrapper-outer\">');this.wrapperOuter=this.$elem.find(\".owl-wrapper-outer\");this.$elem.css(\"display\",\"block\")},\nbaseClass:function(){var a=this.$elem.hasClass(this.options.baseClass),b=this.$elem.hasClass(this.options.theme);a||this.$elem.addClass(this.options.baseClass);b||this.$elem.addClass(this.options.theme)},updateItems:function(){var a,b;if(!1===this.options.responsive)return!1;if(!0===this.options.singleItem)return this.options.items=this.orignalItems=1,this.options.itemsCustom=!1,this.options.itemsDesktop=!1,this.options.itemsDesktopSmall=!1,this.options.itemsTablet=!1,this.options.itemsTabletSmall=\n!1,this.options.itemsMobile=!1;a=f(this.options.responsiveBaseWidth).width();a>(this.options.itemsDesktop[0]||this.orignalItems)&&(this.options.items=this.orignalItems);if(!1!==this.options.itemsCustom)for(this.options.itemsCustom.sort(function(a,b){return a[0]-b[0]}),b=0;b<this.options.itemsCustom.length;b+=1)this.options.itemsCustom[b][0]<=a&&(this.options.items=this.options.itemsCustom[b][1]);else a<=this.options.itemsDesktop[0]&&!1!==this.options.itemsDesktop&&(this.options.items=this.options.itemsDesktop[1]),\na<=this.options.itemsDesktopSmall[0]&&!1!==this.options.itemsDesktopSmall&&(this.options.items=this.options.itemsDesktopSmall[1]),a<=this.options.itemsTablet[0]&&!1!==this.options.itemsTablet&&(this.options.items=this.options.itemsTablet[1]),a<=this.options.itemsTabletSmall[0]&&!1!==this.options.itemsTabletSmall&&(this.options.items=this.options.itemsTabletSmall[1]),a<=this.options.itemsMobile[0]&&!1!==this.options.itemsMobile&&(this.options.items=this.options.itemsMobile[1]);this.options.items>this.itemsAmount&&\n!0===this.options.itemsScaleUp&&(this.options.items=this.itemsAmount)},response:function(){var a=this,b,e;if(!0!==a.options.responsive)return!1;e=f(g).width();a.resizer=function(){f(g).width()!==e&&(!1!==a.options.autoPlay&&g.clearInterval(a.autoPlayInterval),g.clearTimeout(b),b=g.setTimeout(function(){e=f(g).width();a.updateVars()},a.options.responsiveRefreshRate))};f(g).resize(a.resizer)},updatePosition:function(){this.jumpTo(this.currentItem);!1!==this.options.autoPlay&&this.checkAp()},appendItemsSizes:function(){var a=\nthis,b=0,e=a.itemsAmount-a.options.items;a.$owlItems.each(function(c){var d=f(this);d.css({width:a.itemWidth}).data(\"owl-item\",Number(c));if(0===c%a.options.items||c===e)c>e||(b+=1);d.data(\"owl-roundPages\",b)})},appendWrapperSizes:function(){this.$owlWrapper.css({width:this.$owlItems.length*this.itemWidth*2,left:0});this.appendItemsSizes()},calculateAll:function(){this.calculateWidth();this.appendWrapperSizes();this.loops();this.max()},calculateWidth:function(){this.itemWidth=Math.round(this.$elem.width()/\nthis.options.items)},max:function(){var a=-1*(this.itemsAmount*this.itemWidth-this.options.items*this.itemWidth);this.options.items>this.itemsAmount?this.maximumPixels=a=this.maximumItem=0:(this.maximumItem=this.itemsAmount-this.options.items,this.maximumPixels=a);return a},min:function(){return 0},loops:function(){var a=0,b=0,e,c;this.positionsInArray=[0];this.pagesInArray=[];for(e=0;e<this.itemsAmount;e+=1)b+=this.itemWidth,this.positionsInArray.push(-b),!0===this.options.scrollPerPage&&(c=f(this.$owlItems[e]),\nc=c.data(\"owl-roundPages\"),c!==a&&(this.pagesInArray[a]=this.positionsInArray[e],a=c))},buildControls:function(){if(!0===this.options.navigation||!0===this.options.pagination)this.owlControls=f('<div class=\"owl-controls\"/>').toggleClass(\"clickable\",!this.browser.isTouch).appendTo(this.$elem);!0===this.options.pagination&&this.buildPagination();!0===this.options.navigation&&this.buildButtons()},buildButtons:function(){var a=this,b=f('<div class=\"owl-buttons\"/>');a.owlControls.append(b);a.buttonPrev=\nf(\"<div/>\",{\"class\":\"owl-prev\",html:a.options.navigationText[0]||\"\"});a.buttonNext=f(\"<div/>\",{\"class\":\"owl-next\",html:a.options.navigationText[1]||\"\"});b.append(a.buttonPrev).append(a.buttonNext);b.on(\"touchstart.owlControls mousedown.owlControls\",'div[class^=\"owl\"]',function(a){a.preventDefault()});b.on(\"touchend.owlControls mouseup.owlControls\",'div[class^=\"owl\"]',function(b){b.preventDefault();f(this).hasClass(\"owl-next\")?a.next():a.prev()})},buildPagination:function(){var a=this;a.paginationWrapper=\nf('<div class=\"owl-pagination\"/>');a.owlControls.append(a.paginationWrapper);a.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\",\".owl-page\",function(b){b.preventDefault();Number(f(this).data(\"owl-page\"))!==a.currentItem&&a.goTo(Number(f(this).data(\"owl-page\")),!0)})},updatePagination:function(){var a,b,e,c,d,g;if(!1===this.options.pagination)return!1;this.paginationWrapper.html(\"\");a=0;b=this.itemsAmount-this.itemsAmount%this.options.items;for(c=0;c<this.itemsAmount;c+=1)0===c%this.options.items&&\n(a+=1,b===c&&(e=this.itemsAmount-this.options.items),d=f(\"<div/>\",{\"class\":\"owl-page\"}),g=f(\"<span></span>\",{text:!0===this.options.paginationNumbers?a:\"\",\"class\":!0===this.options.paginationNumbers?\"owl-numbers\":\"\"}),d.append(g),d.data(\"owl-page\",b===c?e:c),d.data(\"owl-roundPages\",a),this.paginationWrapper.append(d));this.checkPagination()},checkPagination:function(){var a=this;if(!1===a.options.pagination)return!1;a.paginationWrapper.find(\".owl-page\").each(function(){f(this).data(\"owl-roundPages\")===\nf(a.$owlItems[a.currentItem]).data(\"owl-roundPages\")&&(a.paginationWrapper.find(\".owl-page\").removeClass(\"active\"),f(this).addClass(\"active\"))})},checkNavigation:function(){if(!1===this.options.navigation)return!1;!1===this.options.rewindNav&&(0===this.currentItem&&0===this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0===this.currentItem&&0!==this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")):this.currentItem===\nthis.maximumItem?(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0!==this.currentItem&&this.currentItem!==this.maximumItem&&(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")))},updateControls:function(){this.updatePagination();this.checkNavigation();this.owlControls&&(this.options.items>=this.itemsAmount?this.owlControls.hide():this.owlControls.show())},destroyControls:function(){this.owlControls&&this.owlControls.remove()},next:function(a){if(this.isTransition)return!1;\nthis.currentItem+=!0===this.options.scrollPerPage?this.options.items:1;if(this.currentItem>this.maximumItem+(!0===this.options.scrollPerPage?this.options.items-1:0))if(!0===this.options.rewindNav)this.currentItem=0,a=\"rewind\";else return this.currentItem=this.maximumItem,!1;this.goTo(this.currentItem,a)},prev:function(a){if(this.isTransition)return!1;this.currentItem=!0===this.options.scrollPerPage&&0<this.currentItem&&this.currentItem<this.options.items?0:this.currentItem-(!0===this.options.scrollPerPage?\nthis.options.items:1);if(0>this.currentItem)if(!0===this.options.rewindNav)this.currentItem=this.maximumItem,a=\"rewind\";else return this.currentItem=0,!1;this.goTo(this.currentItem,a)},goTo:function(a,b,e){var c=this;if(c.isTransition)return!1;\"function\"===typeof c.options.beforeMove&&c.options.beforeMove.apply(this,[c.$elem]);a>=c.maximumItem?a=c.maximumItem:0>=a&&(a=0);c.currentItem=c.owl.currentItem=a;if(!1!==c.options.transitionStyle&&\"drag\"!==e&&1===c.options.items&&!0===c.browser.support3d)return c.swapSpeed(0),\n!0===c.browser.support3d?c.transition3d(c.positionsInArray[a]):c.css2slide(c.positionsInArray[a],1),c.afterGo(),c.singleItemTransition(),!1;a=c.positionsInArray[a];!0===c.browser.support3d?(c.isCss3Finish=!1,!0===b?(c.swapSpeed(\"paginationSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},c.options.paginationSpeed)):\"rewind\"===b?(c.swapSpeed(c.options.rewindSpeed),g.setTimeout(function(){c.isCss3Finish=!0},c.options.rewindSpeed)):(c.swapSpeed(\"slideSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},\nc.options.slideSpeed)),c.transition3d(a)):!0===b?c.css2slide(a,c.options.paginationSpeed):\"rewind\"===b?c.css2slide(a,c.options.rewindSpeed):c.css2slide(a,c.options.slideSpeed);c.afterGo()},jumpTo:function(a){\"function\"===typeof this.options.beforeMove&&this.options.beforeMove.apply(this,[this.$elem]);a>=this.maximumItem||-1===a?a=this.maximumItem:0>=a&&(a=0);this.swapSpeed(0);!0===this.browser.support3d?this.transition3d(this.positionsInArray[a]):this.css2slide(this.positionsInArray[a],1);this.currentItem=\nthis.owl.currentItem=a;this.afterGo()},afterGo:function(){this.prevArr.push(this.currentItem);this.prevItem=this.owl.prevItem=this.prevArr[this.prevArr.length-2];this.prevArr.shift(0);this.prevItem!==this.currentItem&&(this.checkPagination(),this.checkNavigation(),this.eachMoveUpdate(),!1!==this.options.autoPlay&&this.checkAp());\"function\"===typeof this.options.afterMove&&this.prevItem!==this.currentItem&&this.options.afterMove.apply(this,[this.$elem])},stop:function(){this.apStatus=\"stop\";g.clearInterval(this.autoPlayInterval)},\ncheckAp:function(){\"stop\"!==this.apStatus&&this.play()},play:function(){var a=this;a.apStatus=\"play\";if(!1===a.options.autoPlay)return!1;g.clearInterval(a.autoPlayInterval);a.autoPlayInterval=g.setInterval(function(){a.next(!0)},a.options.autoPlay)},swapSpeed:function(a){\"slideSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.slideSpeed)):\"paginationSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.paginationSpeed)):\"string\"!==typeof a&&this.$owlWrapper.css(this.addCssSpeed(a))},\naddCssSpeed:function(a){return{\"-webkit-transition\":\"all \"+a+\"ms ease\",\"-moz-transition\":\"all \"+a+\"ms ease\",\"-o-transition\":\"all \"+a+\"ms ease\",transition:\"all \"+a+\"ms ease\"}},removeTransition:function(){return{\"-webkit-transition\":\"\",\"-moz-transition\":\"\",\"-o-transition\":\"\",transition:\"\"}},doTranslate:function(a){return{\"-webkit-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-moz-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-o-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-ms-transform\":\"translate3d(\"+\na+\"px, 0px, 0px)\",transform:\"translate3d(\"+a+\"px, 0px,0px)\"}},transition3d:function(a){this.$owlWrapper.css(this.doTranslate(a))},css2move:function(a){this.$owlWrapper.css({left:a})},css2slide:function(a,b){var e=this;e.isCssFinish=!1;e.$owlWrapper.stop(!0,!0).animate({left:a},{duration:b||e.options.slideSpeed,complete:function(){e.isCssFinish=!0}})},checkBrowser:function(){var a=k.createElement(\"div\");a.style.cssText=\"  -moz-transform:translate3d(0px, 0px, 0px); -ms-transform:translate3d(0px, 0px, 0px); -o-transform:translate3d(0px, 0px, 0px); -webkit-transform:translate3d(0px, 0px, 0px); transform:translate3d(0px, 0px, 0px)\";\na=a.style.cssText.match(/translate3d\\(0px, 0px, 0px\\)/g);this.browser={support3d:null!==a&&1===a.length,isTouch:\"ontouchstart\"in g||g.navigator.msMaxTouchPoints}},moveEvents:function(){if(!1!==this.options.mouseDrag||!1!==this.options.touchDrag)this.gestures(),this.disabledEvents()},eventTypes:function(){var a=[\"s\",\"e\",\"x\"];this.ev_types={};!0===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl mousedown.owl\",\"touchmove.owl mousemove.owl\",\"touchend.owl touchcancel.owl mouseup.owl\"]:\n!1===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl\",\"touchmove.owl\",\"touchend.owl touchcancel.owl\"]:!0===this.options.mouseDrag&&!1===this.options.touchDrag&&(a=[\"mousedown.owl\",\"mousemove.owl\",\"mouseup.owl\"]);this.ev_types.start=a[0];this.ev_types.move=a[1];this.ev_types.end=a[2]},disabledEvents:function(){this.$elem.on(\"dragstart.owl\",function(a){a.preventDefault()});this.$elem.on(\"mousedown.disableTextSelect\",function(a){return f(a.target).is(\"input, textarea, select, option\")})},\ngestures:function(){function a(a){if(void 0!==a.touches)return{x:a.touches[0].pageX,y:a.touches[0].pageY};if(void 0===a.touches){if(void 0!==a.pageX)return{x:a.pageX,y:a.pageY};if(void 0===a.pageX)return{x:a.clientX,y:a.clientY}}}function b(a){\"on\"===a?(f(k).on(d.ev_types.move,e),f(k).on(d.ev_types.end,c)):\"off\"===a&&(f(k).off(d.ev_types.move),f(k).off(d.ev_types.end))}function e(b){b=b.originalEvent||b||g.event;d.newPosX=a(b).x-h.offsetX;d.newPosY=a(b).y-h.offsetY;d.newRelativeX=d.newPosX-h.relativePos;\n\"function\"===typeof d.options.startDragging&&!0!==h.dragging&&0!==d.newRelativeX&&(h.dragging=!0,d.options.startDragging.apply(d,[d.$elem]));(8<d.newRelativeX||-8>d.newRelativeX)&&!0===d.browser.isTouch&&(void 0!==b.preventDefault?b.preventDefault():b.returnValue=!1,h.sliding=!0);(10<d.newPosY||-10>d.newPosY)&&!1===h.sliding&&f(k).off(\"touchmove.owl\");d.newPosX=Math.max(Math.min(d.newPosX,d.newRelativeX/5),d.maximumPixels+d.newRelativeX/5);!0===d.browser.support3d?d.transition3d(d.newPosX):d.css2move(d.newPosX)}\nfunction c(a){a=a.originalEvent||a||g.event;var c;a.target=a.target||a.srcElement;h.dragging=!1;!0!==d.browser.isTouch&&d.$owlWrapper.removeClass(\"grabbing\");d.dragDirection=0>d.newRelativeX?d.owl.dragDirection=\"left\":d.owl.dragDirection=\"right\";0!==d.newRelativeX&&(c=d.getNewPosition(),d.goTo(c,!1,\"drag\"),h.targetElement===a.target&&!0!==d.browser.isTouch&&(f(a.target).on(\"click.disable\",function(a){a.stopImmediatePropagation();a.stopPropagation();a.preventDefault();f(a.target).off(\"click.disable\")}),\na=f._data(a.target,\"events\").click,c=a.pop(),a.splice(0,0,c)));b(\"off\")}var d=this,h={offsetX:0,offsetY:0,baseElWidth:0,relativePos:0,position:null,minSwipe:null,maxSwipe:null,sliding:null,dargging:null,targetElement:null};d.isCssFinish=!0;d.$elem.on(d.ev_types.start,\".owl-wrapper\",function(c){c=c.originalEvent||c||g.event;var e;if(3===c.which)return!1;if(!(d.itemsAmount<=d.options.items)){if(!1===d.isCssFinish&&!d.options.dragBeforeAnimFinish||!1===d.isCss3Finish&&!d.options.dragBeforeAnimFinish)return!1;\n!1!==d.options.autoPlay&&g.clearInterval(d.autoPlayInterval);!0===d.browser.isTouch||d.$owlWrapper.hasClass(\"grabbing\")||d.$owlWrapper.addClass(\"grabbing\");d.newPosX=0;d.newRelativeX=0;f(this).css(d.removeTransition());e=f(this).position();h.relativePos=e.left;h.offsetX=a(c).x-e.left;h.offsetY=a(c).y-e.top;b(\"on\");h.sliding=!1;h.targetElement=c.target||c.srcElement}})},getNewPosition:function(){var a=this.closestItem();a>this.maximumItem?a=this.currentItem=this.maximumItem:0<=this.newPosX&&(this.currentItem=\na=0);return a},closestItem:function(){var a=this,b=!0===a.options.scrollPerPage?a.pagesInArray:a.positionsInArray,e=a.newPosX,c=null;f.each(b,function(d,g){e-a.itemWidth/20>b[d+1]&&e-a.itemWidth/20<g&&\"left\"===a.moveDirection()?(c=g,a.currentItem=!0===a.options.scrollPerPage?f.inArray(c,a.positionsInArray):d):e+a.itemWidth/20<g&&e+a.itemWidth/20>(b[d+1]||b[d]-a.itemWidth)&&\"right\"===a.moveDirection()&&(!0===a.options.scrollPerPage?(c=b[d+1]||b[b.length-1],a.currentItem=f.inArray(c,a.positionsInArray)):\n(c=b[d+1],a.currentItem=d+1))});return a.currentItem},moveDirection:function(){var a;0>this.newRelativeX?(a=\"right\",this.playDirection=\"next\"):(a=\"left\",this.playDirection=\"prev\");return a},customEvents:function(){var a=this;a.$elem.on(\"owl.next\",function(){a.next()});a.$elem.on(\"owl.prev\",function(){a.prev()});a.$elem.on(\"owl.play\",function(b,e){a.options.autoPlay=e;a.play();a.hoverStatus=\"play\"});a.$elem.on(\"owl.stop\",function(){a.stop();a.hoverStatus=\"stop\"});a.$elem.on(\"owl.goTo\",function(b,e){a.goTo(e)});\na.$elem.on(\"owl.jumpTo\",function(b,e){a.jumpTo(e)})},stopOnHover:function(){var a=this;!0===a.options.stopOnHover&&!0!==a.browser.isTouch&&!1!==a.options.autoPlay&&(a.$elem.on(\"mouseover\",function(){a.stop()}),a.$elem.on(\"mouseout\",function(){\"stop\"!==a.hoverStatus&&a.play()}))},lazyLoad:function(){var a,b,e,c,d;if(!1===this.options.lazyLoad)return!1;for(a=0;a<this.itemsAmount;a+=1)b=f(this.$owlItems[a]),\"loaded\"!==b.data(\"owl-loaded\")&&(e=b.data(\"owl-item\"),c=b.find(\".lazyOwl\"),\"string\"!==typeof c.data(\"src\")?\nb.data(\"owl-loaded\",\"loaded\"):(void 0===b.data(\"owl-loaded\")&&(c.hide(),b.addClass(\"loading\").data(\"owl-loaded\",\"checked\")),(d=!0===this.options.lazyFollow?e>=this.currentItem:!0)&&e<this.currentItem+this.options.items&&c.length&&this.lazyPreload(b,c)))},lazyPreload:function(a,b){function e(){a.data(\"owl-loaded\",\"loaded\").removeClass(\"loading\");b.removeAttr(\"data-src\");\"fade\"===d.options.lazyEffect?b.fadeIn(400):b.show();\"function\"===typeof d.options.afterLazyLoad&&d.options.afterLazyLoad.apply(this,\n[d.$elem])}function c(){f+=1;d.completeImg(b.get(0))||!0===k?e():100>=f?g.setTimeout(c,100):e()}var d=this,f=0,k;\"DIV\"===b.prop(\"tagName\")?(b.css(\"background-image\",\"url(\"+b.data(\"src\")+\")\"),k=!0):b[0].src=b.data(\"src\");c()},autoHeight:function(){function a(){var a=f(e.$owlItems[e.currentItem]).height();e.wrapperOuter.css(\"height\",a+\"px\");e.wrapperOuter.hasClass(\"autoHeight\")||g.setTimeout(function(){e.wrapperOuter.addClass(\"autoHeight\")},0)}function b(){d+=1;e.completeImg(c.get(0))?a():100>=d?g.setTimeout(b,\n100):e.wrapperOuter.css(\"height\",\"\")}var e=this,c=f(e.$owlItems[e.currentItem]).find(\"img\"),d;void 0!==c.get(0)?(d=0,b()):a()},completeImg:function(a){return!a.complete||\"undefined\"!==typeof a.naturalWidth&&0===a.naturalWidth?!1:!0},onVisibleItems:function(){var a;!0===this.options.addClassActive&&this.$owlItems.removeClass(\"active\");this.visibleItems=[];for(a=this.currentItem;a<this.currentItem+this.options.items;a+=1)this.visibleItems.push(a),!0===this.options.addClassActive&&f(this.$owlItems[a]).addClass(\"active\");\nthis.owl.visibleItems=this.visibleItems},transitionTypes:function(a){this.outClass=\"owl-\"+a+\"-out\";this.inClass=\"owl-\"+a+\"-in\"},singleItemTransition:function(){var a=this,b=a.outClass,e=a.inClass,c=a.$owlItems.eq(a.currentItem),d=a.$owlItems.eq(a.prevItem),f=Math.abs(a.positionsInArray[a.currentItem])+a.positionsInArray[a.prevItem],g=Math.abs(a.positionsInArray[a.currentItem])+a.itemWidth/2;a.isTransition=!0;a.$owlWrapper.addClass(\"owl-origin\").css({\"-webkit-transform-origin\":g+\"px\",\"-moz-perspective-origin\":g+\n\"px\",\"perspective-origin\":g+\"px\"});d.css({position:\"relative\",left:f+\"px\"}).addClass(b).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endPrev=!0;d.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(d,b)});c.addClass(e).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endCurrent=!0;c.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(c,e)})},clearTransStyle:function(a,\nb){a.css({position:\"\",left:\"\"}).removeClass(b);this.endPrev&&this.endCurrent&&(this.$owlWrapper.removeClass(\"owl-origin\"),this.isTransition=this.endCurrent=this.endPrev=!1)},owlStatus:function(){this.owl={userOptions:this.userOptions,baseElement:this.$elem,userItems:this.$userItems,owlItems:this.$owlItems,currentItem:this.currentItem,prevItem:this.prevItem,visibleItems:this.visibleItems,isTouch:this.browser.isTouch,browser:this.browser,dragDirection:this.dragDirection}},clearEvents:function(){this.$elem.off(\".owl owl mousedown.disableTextSelect\");\nf(k).off(\".owl owl\");f(g).off(\"resize\",this.resizer)},unWrap:function(){0!==this.$elem.children().length&&(this.$owlWrapper.unwrap(),this.$userItems.unwrap().unwrap(),this.owlControls&&this.owlControls.remove());this.clearEvents();this.$elem.attr(\"style\",this.$elem.data(\"owl-originalStyles\")||\"\").attr(\"class\",this.$elem.data(\"owl-originalClasses\"))},destroy:function(){this.stop();g.clearInterval(this.checkVisible);this.unWrap();this.$elem.removeData()},reinit:function(a){a=f.extend({},this.userOptions,\na);this.unWrap();this.init(a,this.$elem)},addItem:function(a,b){var e;if(!a)return!1;if(0===this.$elem.children().length)return this.$elem.append(a),this.setVars(),!1;this.unWrap();e=void 0===b||-1===b?-1:b;e>=this.$userItems.length||-1===e?this.$userItems.eq(-1).after(a):this.$userItems.eq(e).before(a);this.setVars()},removeItem:function(a){if(0===this.$elem.children().length)return!1;a=void 0===a||-1===a?-1:a;this.unWrap();this.$userItems.eq(a).remove();this.setVars()}};f.fn.owlCarousel=function(a){return this.each(function(){if(!0===\nf(this).data(\"owl-init\"))return!1;f(this).data(\"owl-init\",!0);var b=Object.create(l);b.init(a,this);f.data(this,\"owlCarousel\",b)})};f.fn.owlCarousel.options={items:5,itemsCustom:!1,itemsDesktop:[1199,4],itemsDesktopSmall:[979,3],itemsTablet:[768,2],itemsTabletSmall:!1,itemsMobile:[479,1],singleItem:!1,itemsScaleUp:!1,slideSpeed:200,paginationSpeed:800,rewindSpeed:1E3,autoPlay:!1,stopOnHover:!1,navigation:!1,navigationText:[\"prev\",\"next\"],rewindNav:!0,scrollPerPage:!1,pagination:!0,paginationNumbers:!1,\nresponsive:!0,responsiveRefreshRate:200,responsiveBaseWidth:g,baseClass:\"owl-carousel\",theme:\"owl-theme\",lazyLoad:!1,lazyFollow:!0,lazyEffect:\"fade\",autoHeight:!1,jsonPath:!1,jsonSuccess:!1,dragBeforeAnimFinish:!0,mouseDrag:!0,touchDrag:!0,addClassActive:!1,transitionStyle:!1,beforeUpdate:!1,afterUpdate:!1,beforeInit:!1,afterInit:!1,beforeMove:!1,afterMove:!1,afterAction:!1,startDragging:!1,afterLazyLoad:!1}})(jQuery,window,document);\n});","Plazathemes_InstagramGallery/plazathemes/instagramgallery/js/jquery.fancybox.js":"/*!\n * fancyBox - jQuery Plugin\n * version: 2.1.5 (Fri, 14 Jun 2013)\n * requires jQuery v1.6 or later\n *\n * Examples at http://fancyapps.com/fancybox/\n * License: www.fancyapps.com/fancybox/#license\n *\n * Copyright 2012 Janis Skarnelis - janis@fancyapps.com\n *\n */\nrequire([\"jquery\"], function($){\n\t(function (window, document, $, undefined) {\n\t\t\"use strict\";\n\n\t\tvar H = $(\"html\"),\n\t\t\tW = $(window),\n\t\t\tD = $(document),\n\t\t\tF = $.fancybox = function () {\n\t\t\t\tF.open.apply( this, arguments );\n\t\t\t},\n\t\t\tIE =  navigator.userAgent.match(/msie/i),\n\t\t\tdidUpdate\t= null,\n\t\t\tisTouch\t\t= document.createTouch !== undefined,\n\n\t\t\tisQuery\t= function(obj) {\n\t\t\t\treturn obj && obj.hasOwnProperty && obj instanceof $;\n\t\t\t},\n\t\t\tisString = function(str) {\n\t\t\t\treturn str && $.type(str) === \"string\";\n\t\t\t},\n\t\t\tisPercentage = function(str) {\n\t\t\t\treturn isString(str) && str.indexOf('%') > 0;\n\t\t\t},\n\t\t\tisScrollable = function(el) {\n\t\t\t\treturn (el && !(el.style.overflow && el.style.overflow === 'hidden') && ((el.clientWidth && el.scrollWidth > el.clientWidth) || (el.clientHeight && el.scrollHeight > el.clientHeight)));\n\t\t\t},\n\t\t\tgetScalar = function(orig, dim) {\n\t\t\t\tvar value = parseInt(orig, 10) || 0;\n\n\t\t\t\tif (dim && isPercentage(orig)) {\n\t\t\t\t\tvalue = F.getViewport()[ dim ] / 100 * value;\n\t\t\t\t}\n\n\t\t\t\treturn Math.ceil(value);\n\t\t\t},\n\t\t\tgetValue = function(value, dim) {\n\t\t\t\treturn getScalar(value, dim) + 'px';\n\t\t\t};\n\n\t\t$.extend(F, {\n\t\t\t// The current version of fancyBox\n\t\t\tversion: '2.1.5',\n\n\t\t\tdefaults: {\n\t\t\t\tpadding : 15,\n\t\t\t\tmargin  : 20,\n\n\t\t\t\twidth     : 800,\n\t\t\t\theight    : 600,\n\t\t\t\tminWidth  : 100,\n\t\t\t\tminHeight : 100,\n\t\t\t\tmaxWidth  : 9999,\n\t\t\t\tmaxHeight : 9999,\n\t\t\t\tpixelRatio: 1, // Set to 2 for retina display support\n\n\t\t\t\tautoSize   : true,\n\t\t\t\tautoHeight : false,\n\t\t\t\tautoWidth  : false,\n\n\t\t\t\tautoResize  : true,\n\t\t\t\tautoCenter  : !isTouch,\n\t\t\t\tfitToView   : true,\n\t\t\t\taspectRatio : false,\n\t\t\t\ttopRatio    : 0.5,\n\t\t\t\tleftRatio   : 0.5,\n\n\t\t\t\tscrolling : 'auto', // 'auto', 'yes' or 'no'\n\t\t\t\twrapCSS   : '',\n\n\t\t\t\tarrows     : true,\n\t\t\t\tcloseBtn   : true,\n\t\t\t\tcloseClick : false,\n\t\t\t\tnextClick  : false,\n\t\t\t\tmouseWheel : true,\n\t\t\t\tautoPlay   : false,\n\t\t\t\tplaySpeed  : 3000,\n\t\t\t\tpreload    : 3,\n\t\t\t\tmodal      : false,\n\t\t\t\tloop       : true,\n\n\t\t\t\tajax  : {\n\t\t\t\t\tdataType : 'html',\n\t\t\t\t\theaders  : { 'X-fancyBox': true }\n\t\t\t\t},\n\t\t\t\tiframe : {\n\t\t\t\t\tscrolling : 'auto',\n\t\t\t\t\tpreload   : true\n\t\t\t\t},\n\t\t\t\tswf : {\n\t\t\t\t\twmode: 'transparent',\n\t\t\t\t\tallowfullscreen   : 'true',\n\t\t\t\t\tallowscriptaccess : 'always'\n\t\t\t\t},\n\n\t\t\t\tkeys  : {\n\t\t\t\t\tnext : {\n\t\t\t\t\t\t13 : 'left', // enter\n\t\t\t\t\t\t34 : 'up',   // page down\n\t\t\t\t\t\t39 : 'left', // right arrow\n\t\t\t\t\t\t40 : 'up'    // down arrow\n\t\t\t\t\t},\n\t\t\t\t\tprev : {\n\t\t\t\t\t\t8  : 'right',  // backspace\n\t\t\t\t\t\t33 : 'down',   // page up\n\t\t\t\t\t\t37 : 'right',  // left arrow\n\t\t\t\t\t\t38 : 'down'    // up arrow\n\t\t\t\t\t},\n\t\t\t\t\tclose  : [27], // escape key\n\t\t\t\t\tplay   : [32], // space - start/stop slideshow\n\t\t\t\t\ttoggle : [70]  // letter \"f\" - toggle fullscreen\n\t\t\t\t},\n\n\t\t\t\tdirection : {\n\t\t\t\t\tnext : 'left',\n\t\t\t\t\tprev : 'right'\n\t\t\t\t},\n\n\t\t\t\tscrollOutside  : true,\n\n\t\t\t\t// Override some properties\n\t\t\t\tindex   : 0,\n\t\t\t\ttype    : null,\n\t\t\t\thref    : null,\n\t\t\t\tdata_href : null,\n\t\t\t\tdata_target : null,\n\t\t\t\tcontent : null,\n\t\t\t\ttitle   : null,\n\n\t\t\t\t// HTML templates\n\t\t\t\ttpl: {\n\t\t\t\t\twrap     : '<div class=\"fancybox-wrap\" tabIndex=\"-1\"><div class=\"fancybox-skin\"><div class=\"fancybox-outer\"><div class=\"fancybox-inner\"></div></div></div></div>',\n\t\t\t\t\timage    : '<a href=\"{data_href}\" target=\"{data_target}\"><img class=\"fancybox-image\" src=\"{href}\" alt=\"\" /></a>',\n\t\t\t\t\tiframe   : '<iframe id=\"fancybox-frame{rnd}\" name=\"fancybox-frame{rnd}\" class=\"fancybox-iframe\" frameborder=\"0\" vspace=\"0\" hspace=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen' + (IE ? ' allowtransparency=\"true\"' : '') + '></iframe>',\n\t\t\t\t\terror    : '<p class=\"fancybox-error\">The requested content cannot be loaded.<br/>Please try again later.</p>',\n\t\t\t\t\tcloseBtn : '<a title=\"Close\" class=\"fancybox-item fancybox-close\" href=\"javascript:;\"></a>',\n\t\t\t\t\tnext     : '<a title=\"Next\" class=\"fancybox-nav fancybox-next\" href=\"javascript:;\"><span></span></a>',\n\t\t\t\t\tprev     : '<a title=\"Previous\" class=\"fancybox-nav fancybox-prev\" href=\"javascript:;\"><span></span></a>',\n\t\t\t\t\tloading  : '<div id=\"fancybox-loading\"><div></div></div>'\n\t\t\t\t},\n\n\t\t\t\t// Properties for each animation type\n\t\t\t\t// Opening fancyBox\n\t\t\t\topenEffect  : 'fade', // 'elastic', 'fade' or 'none'\n\t\t\t\topenSpeed   : 250,\n\t\t\t\topenEasing  : 'swing',\n\t\t\t\topenOpacity : true,\n\t\t\t\topenMethod  : 'zoomIn',\n\n\t\t\t\t// Closing fancyBox\n\t\t\t\tcloseEffect  : 'fade', // 'elastic', 'fade' or 'none'\n\t\t\t\tcloseSpeed   : 250,\n\t\t\t\tcloseEasing  : 'swing',\n\t\t\t\tcloseOpacity : true,\n\t\t\t\tcloseMethod  : 'zoomOut',\n\n\t\t\t\t// Changing next gallery item\n\t\t\t\tnextEffect : 'elastic', // 'elastic', 'fade' or 'none'\n\t\t\t\tnextSpeed  : 250,\n\t\t\t\tnextEasing : 'swing',\n\t\t\t\tnextMethod : 'changeIn',\n\n\t\t\t\t// Changing previous gallery item\n\t\t\t\tprevEffect : 'elastic', // 'elastic', 'fade' or 'none'\n\t\t\t\tprevSpeed  : 250,\n\t\t\t\tprevEasing : 'swing',\n\t\t\t\tprevMethod : 'changeOut',\n\n\t\t\t\t// Enable default helpers\n\t\t\t\thelpers : {\n\t\t\t\t\toverlay : true,\n\t\t\t\t\ttitle   : true\n\t\t\t\t},\n\n\t\t\t\t// Callbacks\n\t\t\t\tonCancel     : $.noop, // If canceling\n\t\t\t\tbeforeLoad   : $.noop, // Before loading\n\t\t\t\tafterLoad    : $.noop, // After loading\n\t\t\t\tbeforeShow   : $.noop, // Before changing in current item\n\t\t\t\tafterShow    : $.noop, // After opening\n\t\t\t\tbeforeChange : $.noop, // Before changing gallery item\n\t\t\t\tbeforeClose  : $.noop, // Before closing\n\t\t\t\tafterClose   : $.noop  // After closing\n\t\t\t},\n\n\t\t\t//Current state\n\t\t\tgroup    : {}, // Selected group\n\t\t\topts     : {}, // Group options\n\t\t\tprevious : null,  // Previous element\n\t\t\tcoming   : null,  // Element being loaded\n\t\t\tcurrent  : null,  // Currently loaded element\n\t\t\tisActive : false, // Is activated\n\t\t\tisOpen   : false, // Is currently open\n\t\t\tisOpened : false, // Have been fully opened at least once\n\n\t\t\twrap  : null,\n\t\t\tskin  : null,\n\t\t\touter : null,\n\t\t\tinner : null,\n\n\t\t\tplayer : {\n\t\t\t\ttimer    : null,\n\t\t\t\tisActive : false\n\t\t\t},\n\n\t\t\t// Loaders\n\t\t\tajaxLoad   : null,\n\t\t\timgPreload : null,\n\n\t\t\t// Some collections\n\t\t\ttransitions : {},\n\t\t\thelpers     : {},\n\n\t\t\t/*\n\t\t\t *\tStatic methods\n\t\t\t */\n\n\t\t\topen: function (group, opts) {\n\t\t\t\tif (!group) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (!$.isPlainObject(opts)) {\n\t\t\t\t\topts = {};\n\t\t\t\t}\n\n\t\t\t\t// Close if already active\n\t\t\t\tif (false === F.close(true)) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Normalize group\n\t\t\t\tif (!$.isArray(group)) {\n\t\t\t\t\tgroup = isQuery(group) ? $(group).get() : [group];\n\t\t\t\t}\n\n\t\t\t\t// Recheck if the type of each element is `object` and set content type (image, ajax, etc)\n\t\t\t\t$.each(group, function(i, element) {\n\t\t\t\t\tvar obj = {},\n\t\t\t\t\t\thref,\n\t\t\t\t\t\tdata_href,\n\t\t\t\t\t\tdata_target,\n\t\t\t\t\t\ttitle,\n\t\t\t\t\t\tcontent,\n\t\t\t\t\t\ttype,\n\t\t\t\t\t\trez,\n\t\t\t\t\t\threfParts,\n\t\t\t\t\t\tselector;\n\n\t\t\t\t\tif ($.type(element) === \"object\") {\n\t\t\t\t\t\t// Check if is DOM element\n\t\t\t\t\t\tif (element.nodeType) {\n\t\t\t\t\t\t\telement = $(element);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isQuery(element)) {\n\t\t\t\t\t\t\tobj = {\n\t\t\t\t\t\t\t\thref    : element.data('fancybox-href') || element.attr('href'),\n\t\t\t\t\t\t\t\tdata_href : element.attr('data-href'),\n\t\t\t\t\t\t\t\tdata_target : element.attr('data-target'),\n\t\t\t\t\t\t\t\ttitle   : $('<div/>').text( element.data('fancybox-title') || element.attr('title') || '' ).html(),\n\t\t\t\t\t\t\t\tisDom   : true,\n\t\t\t\t\t\t\t\telement : element\n\t\t\t\t\t\t\t};\n\n\t\t\t\t\t\t\tif ($.metadata) {\n\t\t\t\t\t\t\t\t$.extend(true, obj, element.metadata());\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tobj = element;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\thref  = opts.href  || obj.href || (isString(element) ? element : null);\n\t\t\t\t\tdata_href = opts.data_href  || obj.data_href || (isString(element) ? element : null);\n\t\t\t\t\tdata_target = opts.data_target  || obj.data_target || (isString(element) ? element : null);\n\t\t\t\t\ttitle = opts.title !== undefined ? opts.title : obj.title || '';\n\n\t\t\t\t\tcontent = opts.content || obj.content;\n\t\t\t\t\ttype    = content ? 'html' : (opts.type  || obj.type);\n\n\t\t\t\t\tif (!type && obj.isDom) {\n\t\t\t\t\t\ttype = element.data('fancybox-type');\n\n\t\t\t\t\t\tif (!type) {\n\t\t\t\t\t\t\trez  = element.prop('class').match(/fancybox\\.(\\w+)/);\n\t\t\t\t\t\t\ttype = rez ? rez[1] : null;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (isString(href)) {\n\t\t\t\t\t\t// Try to guess the content type\n\t\t\t\t\t\tif (!type) {\n\t\t\t\t\t\t\tif (F.isImage(href)) {\n\t\t\t\t\t\t\t\ttype = 'image';\n\n\t\t\t\t\t\t\t} else if (F.isSWF(href)) {\n\t\t\t\t\t\t\t\ttype = 'swf';\n\n\t\t\t\t\t\t\t} else if (href.charAt(0) === '#') {\n\t\t\t\t\t\t\t\ttype = 'inline';\n\n\t\t\t\t\t\t\t} else if (isString(element)) {\n\t\t\t\t\t\t\t\ttype    = 'html';\n\t\t\t\t\t\t\t\tcontent = element;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Split url into two pieces with source url and content selector, e.g,\n\t\t\t\t\t\t// \"/mypage.html #my_id\" will load \"/mypage.html\" and display element having id \"my_id\"\n\t\t\t\t\t\tif (type === 'ajax') {\n\t\t\t\t\t\t\threfParts = href.split(/\\s+/, 2);\n\t\t\t\t\t\t\thref      = hrefParts.shift();\n\t\t\t\t\t\t\tselector  = hrefParts.shift();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!content) {\n\t\t\t\t\t\tif (type === 'inline') {\n\t\t\t\t\t\t\tif (href) {\n\t\t\t\t\t\t\t\tcontent = $( isString(href) ? href.replace(/.*(?=#[^\\s]+$)/, '') : href ); //strip for ie7\n\n\t\t\t\t\t\t\t} else if (obj.isDom) {\n\t\t\t\t\t\t\t\tcontent = element;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else if (type === 'html') {\n\t\t\t\t\t\t\tcontent = href;\n\n\t\t\t\t\t\t} else if (!type && !href && obj.isDom) {\n\t\t\t\t\t\t\ttype    = 'inline';\n\t\t\t\t\t\t\tcontent = element;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t$.extend(obj, {\n\t\t\t\t\t\thref     : href,\n\t\t\t\t\t\tdata_href : data_href,\n\t\t\t\t\t\tdata_target : data_target,\n\t\t\t\t\t\ttype     : type,\n\t\t\t\t\t\tcontent  : content,\n\t\t\t\t\t\ttitle    : title,\n\t\t\t\t\t\tselector : selector\n\t\t\t\t\t});\n\n\t\t\t\t\tgroup[ i ] = obj;\n\t\t\t\t});\n\n\t\t\t\t// Extend the defaults\n\t\t\t\tF.opts = $.extend(true, {}, F.defaults, opts);\n\n\t\t\t\t// All options are merged recursive except keys\n\t\t\t\tif (opts.keys !== undefined) {\n\t\t\t\t\tF.opts.keys = opts.keys ? $.extend({}, F.defaults.keys, opts.keys) : false;\n\t\t\t\t}\n\n\t\t\t\tF.group = group;\n\n\t\t\t\treturn F._start(F.opts.index);\n\t\t\t},\n\n\t\t\t// Cancel image loading or abort ajax request\n\t\t\tcancel: function () {\n\t\t\t\tvar coming = F.coming;\n\n\t\t\t\tif (coming && false === F.trigger('onCancel')) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tF.hideLoading();\n\n\t\t\t\tif (!coming) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (F.ajaxLoad) {\n\t\t\t\t\tF.ajaxLoad.abort();\n\t\t\t\t}\n\n\t\t\t\tF.ajaxLoad = null;\n\n\t\t\t\tif (F.imgPreload) {\n\t\t\t\t\tF.imgPreload.onload = F.imgPreload.onerror = null;\n\t\t\t\t}\n\n\t\t\t\tif (coming.wrap) {\n\t\t\t\t\tcoming.wrap.stop(true, true).trigger('onReset').remove();\n\t\t\t\t}\n\n\t\t\t\tF.coming = null;\n\n\t\t\t\t// If the first item has been canceled, then clear everything\n\t\t\t\tif (!F.current) {\n\t\t\t\t\tF._afterZoomOut( coming );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Start closing animation if is open; remove immediately if opening/closing\n\t\t\tclose: function (event) {\n\t\t\t\tF.cancel();\n\n\t\t\t\tif (false === F.trigger('beforeClose')) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tF.unbindEvents();\n\n\t\t\t\tif (!F.isActive) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (!F.isOpen || event === true) {\n\t\t\t\t\t$('.fancybox-wrap').stop(true).trigger('onReset').remove();\n\n\t\t\t\t\tF._afterZoomOut();\n\n\t\t\t\t} else {\n\t\t\t\t\tF.isOpen = F.isOpened = false;\n\t\t\t\t\tF.isClosing = true;\n\n\t\t\t\t\t$('.fancybox-item, .fancybox-nav').remove();\n\n\t\t\t\t\tF.wrap.stop(true, true).removeClass('fancybox-opened');\n\n\t\t\t\t\tF.transitions[ F.current.closeMethod ]();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Manage slideshow:\n\t\t\t//   $.fancybox.play(); - toggle slideshow\n\t\t\t//   $.fancybox.play( true ); - start\n\t\t\t//   $.fancybox.play( false ); - stop\n\t\t\tplay: function ( action ) {\n\t\t\t\tvar clear = function () {\n\t\t\t\t\t\tclearTimeout(F.player.timer);\n\t\t\t\t\t},\n\t\t\t\t\tset = function () {\n\t\t\t\t\t\tclear();\n\n\t\t\t\t\t\tif (F.current && F.player.isActive) {\n\t\t\t\t\t\t\tF.player.timer = setTimeout(F.next, F.current.playSpeed);\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\t\t\t\t\tstop = function () {\n\t\t\t\t\t\tclear();\n\n\t\t\t\t\t\tD.unbind('.player');\n\n\t\t\t\t\t\tF.player.isActive = false;\n\n\t\t\t\t\t\tF.trigger('onPlayEnd');\n\t\t\t\t\t},\n\t\t\t\t\tstart = function () {\n\t\t\t\t\t\tif (F.current && (F.current.loop || F.current.index < F.group.length - 1)) {\n\t\t\t\t\t\t\tF.player.isActive = true;\n\n\t\t\t\t\t\t\tD.bind({\n\t\t\t\t\t\t\t\t'onCancel.player beforeClose.player' : stop,\n\t\t\t\t\t\t\t\t'onUpdate.player'   : set,\n\t\t\t\t\t\t\t\t'beforeLoad.player' : clear\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\tset();\n\n\t\t\t\t\t\t\tF.trigger('onPlayStart');\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\tif (action === true || (!F.player.isActive && action !== false)) {\n\t\t\t\t\tstart();\n\t\t\t\t} else {\n\t\t\t\t\tstop();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Navigate to next gallery item\n\t\t\tnext: function ( direction ) {\n\t\t\t\tvar current = F.current;\n\n\t\t\t\tif (current) {\n\t\t\t\t\tif (!isString(direction)) {\n\t\t\t\t\t\tdirection = current.direction.next;\n\t\t\t\t\t}\n\n\t\t\t\t\tF.jumpto(current.index + 1, direction, 'next');\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Navigate to previous gallery item\n\t\t\tprev: function ( direction ) {\n\t\t\t\tvar current = F.current;\n\n\t\t\t\tif (current) {\n\t\t\t\t\tif (!isString(direction)) {\n\t\t\t\t\t\tdirection = current.direction.prev;\n\t\t\t\t\t}\n\n\t\t\t\t\tF.jumpto(current.index - 1, direction, 'prev');\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Navigate to gallery item by index\n\t\t\tjumpto: function ( index, direction, router ) {\n\t\t\t\tvar current = F.current;\n\n\t\t\t\tif (!current) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tindex = getScalar(index);\n\n\t\t\t\tF.direction = direction || current.direction[ (index >= current.index ? 'next' : 'prev') ];\n\t\t\t\tF.router    = router || 'jumpto';\n\n\t\t\t\tif (current.loop) {\n\t\t\t\t\tif (index < 0) {\n\t\t\t\t\t\tindex = current.group.length + (index % current.group.length);\n\t\t\t\t\t}\n\n\t\t\t\t\tindex = index % current.group.length;\n\t\t\t\t}\n\n\t\t\t\tif (current.group[ index ] !== undefined) {\n\t\t\t\t\tF.cancel();\n\n\t\t\t\t\tF._start(index);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Center inside viewport and toggle position type to fixed or absolute if needed\n\t\t\treposition: function (e, onlyAbsolute) {\n\t\t\t\tvar current = F.current,\n\t\t\t\t\twrap    = current ? current.wrap : null,\n\t\t\t\t\tpos;\n\n\t\t\t\tif (wrap) {\n\t\t\t\t\tpos = F._getPosition(onlyAbsolute);\n\n\t\t\t\t\tif (e && e.type === 'scroll') {\n\t\t\t\t\t\tdelete pos.position;\n\n\t\t\t\t\t\twrap.stop(true, true).animate(pos, 200);\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\twrap.css(pos);\n\n\t\t\t\t\t\tcurrent.pos = $.extend({}, current.dim, pos);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tupdate: function (e) {\n\t\t\t\tvar type = (e && e.originalEvent && e.originalEvent.type),\n\t\t\t\t\tanyway = !type || type === 'orientationchange';\n\n\t\t\t\tif (anyway) {\n\t\t\t\t\tclearTimeout(didUpdate);\n\n\t\t\t\t\tdidUpdate = null;\n\t\t\t\t}\n\n\t\t\t\tif (!F.isOpen || didUpdate) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tdidUpdate = setTimeout(function() {\n\t\t\t\t\tvar current = F.current;\n\n\t\t\t\t\tif (!current || F.isClosing) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tF.wrap.removeClass('fancybox-tmp');\n\n\t\t\t\t\tif (anyway || type === 'load' || (type === 'resize' && current.autoResize)) {\n\t\t\t\t\t\tF._setDimension();\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!(type === 'scroll' && current.canShrink)) {\n\t\t\t\t\t\tF.reposition(e);\n\t\t\t\t\t}\n\n\t\t\t\t\tF.trigger('onUpdate');\n\n\t\t\t\t\tdidUpdate = null;\n\n\t\t\t\t}, (anyway && !isTouch ? 0 : 300));\n\t\t\t},\n\n\t\t\t// Shrink content to fit inside viewport or restore if resized\n\t\t\ttoggle: function ( action ) {\n\t\t\t\tif (F.isOpen) {\n\t\t\t\t\tF.current.fitToView = $.type(action) === \"boolean\" ? action : !F.current.fitToView;\n\n\t\t\t\t\t// Help browser to restore document dimensions\n\t\t\t\t\tif (isTouch) {\n\t\t\t\t\t\tF.wrap.removeAttr('style').addClass('fancybox-tmp');\n\n\t\t\t\t\t\tF.trigger('onUpdate');\n\t\t\t\t\t}\n\n\t\t\t\t\tF.update();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\thideLoading: function () {\n\t\t\t\tD.unbind('.loading');\n\n\t\t\t\t$('#fancybox-loading').remove();\n\t\t\t},\n\n\t\t\tshowLoading: function () {\n\t\t\t\tvar el, viewport;\n\n\t\t\t\tF.hideLoading();\n\n\t\t\t\tel = $(F.opts.tpl.loading).click(F.cancel).appendTo('body');\n\n\t\t\t\t// If user will press the escape-button, the request will be canceled\n\t\t\t\tD.bind('keydown.loading', function(e) {\n\t\t\t\t\tif ((e.which || e.keyCode) === 27) {\n\t\t\t\t\t\te.preventDefault();\n\n\t\t\t\t\t\tF.cancel();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (!F.defaults.fixed) {\n\t\t\t\t\tviewport = F.getViewport();\n\n\t\t\t\t\tel.css({\n\t\t\t\t\t\tposition : 'absolute',\n\t\t\t\t\t\ttop  : (viewport.h * 0.5) + viewport.y,\n\t\t\t\t\t\tleft : (viewport.w * 0.5) + viewport.x\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tF.trigger('onLoading');\n\t\t\t},\n\n\t\t\tgetViewport: function () {\n\t\t\t\tvar locked = (F.current && F.current.locked) || false,\n\t\t\t\t\trez    = {\n\t\t\t\t\t\tx: W.scrollLeft(),\n\t\t\t\t\t\ty: W.scrollTop()\n\t\t\t\t\t};\n\n\t\t\t\tif (locked && locked.length) {\n\t\t\t\t\trez.w = locked[0].clientWidth;\n\t\t\t\t\trez.h = locked[0].clientHeight;\n\n\t\t\t\t} else {\n\t\t\t\t\t// See http://bugs.jquery.com/ticket/6724\n\t\t\t\t\trez.w = isTouch && window.innerWidth  ? window.innerWidth  : W.width();\n\t\t\t\t\trez.h = isTouch && window.innerHeight ? window.innerHeight : W.height();\n\t\t\t\t}\n\n\t\t\t\treturn rez;\n\t\t\t},\n\n\t\t\t// Unbind the keyboard / clicking actions\n\t\t\tunbindEvents: function () {\n\t\t\t\tif (F.wrap && isQuery(F.wrap)) {\n\t\t\t\t\tF.wrap.unbind('.fb');\n\t\t\t\t}\n\n\t\t\t\tD.unbind('.fb');\n\t\t\t\tW.unbind('.fb');\n\t\t\t},\n\n\t\t\tbindEvents: function () {\n\t\t\t\tvar current = F.current,\n\t\t\t\t\tkeys;\n\n\t\t\t\tif (!current) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Changing document height on iOS devices triggers a 'resize' event,\n\t\t\t\t// that can change document height... repeating infinitely\n\t\t\t\tW.bind('orientationchange.fb' + (isTouch ? '' : ' resize.fb') + (current.autoCenter && !current.locked ? ' scroll.fb' : ''), F.update);\n\n\t\t\t\tkeys = current.keys;\n\n\t\t\t\tif (keys) {\n\t\t\t\t\tD.bind('keydown.fb', function (e) {\n\t\t\t\t\t\tvar code   = e.which || e.keyCode,\n\t\t\t\t\t\t\ttarget = e.target || e.srcElement;\n\n\t\t\t\t\t\t// Skip esc key if loading, because showLoading will cancel preloading\n\t\t\t\t\t\tif (code === 27 && F.coming) {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Ignore key combinations and key events within form elements\n\t\t\t\t\t\tif (!e.ctrlKey && !e.altKey && !e.shiftKey && !e.metaKey && !(target && (target.type || $(target).is('[contenteditable]')))) {\n\t\t\t\t\t\t\t$.each(keys, function(i, val) {\n\t\t\t\t\t\t\t\tif (current.group.length > 1 && val[ code ] !== undefined) {\n\t\t\t\t\t\t\t\t\tF[ i ]( val[ code ] );\n\n\t\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tif ($.inArray(code, val) > -1) {\n\t\t\t\t\t\t\t\t\tF[ i ] ();\n\n\t\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif ($.fn.mousewheel && current.mouseWheel) {\n\t\t\t\t\tF.wrap.bind('mousewheel.fb', function (e, delta, deltaX, deltaY) {\n\t\t\t\t\t\tvar target = e.target || null,\n\t\t\t\t\t\t\tparent = $(target),\n\t\t\t\t\t\t\tcanScroll = false;\n\n\t\t\t\t\t\twhile (parent.length) {\n\t\t\t\t\t\t\tif (canScroll || parent.is('.fancybox-skin') || parent.is('.fancybox-wrap')) {\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tcanScroll = isScrollable( parent[0] );\n\t\t\t\t\t\t\tparent    = $(parent).parent();\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (delta !== 0 && !canScroll) {\n\t\t\t\t\t\t\tif (F.group.length > 1 && !current.canShrink) {\n\t\t\t\t\t\t\t\tif (deltaY > 0 || deltaX > 0) {\n\t\t\t\t\t\t\t\t\tF.prev( deltaY > 0 ? 'down' : 'left' );\n\n\t\t\t\t\t\t\t\t} else if (deltaY < 0 || deltaX < 0) {\n\t\t\t\t\t\t\t\t\tF.next( deltaY < 0 ? 'up' : 'right' );\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\ttrigger: function (event, o) {\n\t\t\t\tvar ret, obj = o || F.coming || F.current;\n\n\t\t\t\tif (obj) {\n\t\t\t\t\tif ($.isFunction( obj[event] )) {\n\t\t\t\t\t\tret = obj[event].apply(obj, Array.prototype.slice.call(arguments, 1));\n\t\t\t\t\t}\n\n\t\t\t\t\tif (ret === false) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (obj.helpers) {\n\t\t\t\t\t\t$.each(obj.helpers, function (helper, opts) {\n\t\t\t\t\t\t\tif (opts && F.helpers[helper] && $.isFunction(F.helpers[helper][event])) {\n\t\t\t\t\t\t\t\tF.helpers[helper][event]($.extend(true, {}, F.helpers[helper].defaults, opts), obj);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tD.trigger(event);\n\t\t\t},\n\n\t\t\tisImage: function (str) {\n\t\t\t\treturn isString(str) && str.match(/(^data:image\\/.*,)|(\\.(jp(e|g|eg)|gif|png|bmp|webp|svg)((\\?|#).*)?$)/i);\n\t\t\t},\n\n\t\t\tisSWF: function (str) {\n\t\t\t\treturn isString(str) && str.match(/\\.(swf)((\\?|#).*)?$/i);\n\t\t\t},\n\n\t\t\t_start: function (index) {\n\t\t\t\tvar coming = {},\n\t\t\t\t\tobj,\n\t\t\t\t\thref,\n\t\t\t\t\tdata_href,\n\t\t\t\t\tdata_target,\n\t\t\t\t\ttype,\n\t\t\t\t\tmargin,\n\t\t\t\t\tpadding;\n\n\t\t\t\tindex = getScalar( index );\n\t\t\t\tobj   = F.group[ index ] || null;\n\n\t\t\t\tif (!obj) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tcoming = $.extend(true, {}, F.opts, obj);\n\n\t\t\t\t// Convert margin and padding properties to array - top, right, bottom, left\n\t\t\t\tmargin  = coming.margin;\n\t\t\t\tpadding = coming.padding;\n\n\t\t\t\tif ($.type(margin) === 'number') {\n\t\t\t\t\tcoming.margin = [margin, margin, margin, margin];\n\t\t\t\t}\n\n\t\t\t\tif ($.type(padding) === 'number') {\n\t\t\t\t\tcoming.padding = [padding, padding, padding, padding];\n\t\t\t\t}\n\n\t\t\t\t// 'modal' propery is just a shortcut\n\t\t\t\tif (coming.modal) {\n\t\t\t\t\t$.extend(true, coming, {\n\t\t\t\t\t\tcloseBtn   : false,\n\t\t\t\t\t\tcloseClick : false,\n\t\t\t\t\t\tnextClick  : false,\n\t\t\t\t\t\tarrows     : false,\n\t\t\t\t\t\tmouseWheel : false,\n\t\t\t\t\t\tkeys       : null,\n\t\t\t\t\t\thelpers: {\n\t\t\t\t\t\t\toverlay : {\n\t\t\t\t\t\t\t\tcloseClick : false\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// 'autoSize' property is a shortcut, too\n\t\t\t\tif (coming.autoSize) {\n\t\t\t\t\tcoming.autoWidth = coming.autoHeight = true;\n\t\t\t\t}\n\n\t\t\t\tif (coming.width === 'auto') {\n\t\t\t\t\tcoming.autoWidth = true;\n\t\t\t\t}\n\n\t\t\t\tif (coming.height === 'auto') {\n\t\t\t\t\tcoming.autoHeight = true;\n\t\t\t\t}\n\n\t\t\t\t/*\n\t\t\t\t * Add reference to the group, so it`s possible to access from callbacks, example:\n\t\t\t\t * afterLoad : function() {\n\t\t\t\t *     this.title = 'Image ' + (this.index + 1) + ' of ' + this.group.length + (this.title ? ' - ' + this.title : '');\n\t\t\t\t * }\n\t\t\t\t */\n\n\t\t\t\tcoming.group  = F.group;\n\t\t\t\tcoming.index  = index;\n\n\t\t\t\t// Give a chance for callback or helpers to update coming item (type, title, etc)\n\t\t\t\tF.coming = coming;\n\n\t\t\t\tif (false === F.trigger('beforeLoad')) {\n\t\t\t\t\tF.coming = null;\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\ttype = coming.type;\n\t\t\t\thref = coming.href;\n\t\t\t\tdata_href = coming.data_href;\n\t\t\t\tdata_target = coming.data_target;\n\n\t\t\t\tif (!type) {\n\t\t\t\t\tF.coming = null;\n\n\t\t\t\t\t//If we can not determine content type then drop silently or display next/prev item if looping through gallery\n\t\t\t\t\tif (F.current && F.router && F.router !== 'jumpto') {\n\t\t\t\t\t\tF.current.index = index;\n\n\t\t\t\t\t\treturn F[ F.router ]( F.direction );\n\t\t\t\t\t}\n\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tF.isActive = true;\n\n\t\t\t\tif (type === 'image' || type === 'swf') {\n\t\t\t\t\tcoming.autoHeight = coming.autoWidth = false;\n\t\t\t\t\tcoming.scrolling  = 'visible';\n\t\t\t\t}\n\n\t\t\t\tif (type === 'image') {\n\t\t\t\t\tcoming.aspectRatio = true;\n\t\t\t\t}\n\n\t\t\t\tif (type === 'iframe' && isTouch) {\n\t\t\t\t\tcoming.scrolling = 'scroll';\n\t\t\t\t}\n\n\t\t\t\t// Build the neccessary markup\n\t\t\t\tcoming.wrap = $(coming.tpl.wrap).addClass('fancybox-' + (isTouch ? 'mobile' : 'desktop') + ' fancybox-type-' + type + ' fancybox-tmp ' + coming.wrapCSS).appendTo( coming.parent || 'body' );\n\n\t\t\t\t$.extend(coming, {\n\t\t\t\t\tskin  : $('.fancybox-skin',  coming.wrap),\n\t\t\t\t\touter : $('.fancybox-outer', coming.wrap),\n\t\t\t\t\tinner : $('.fancybox-inner', coming.wrap)\n\t\t\t\t});\n\n\t\t\t\t$.each([\"Top\", \"Right\", \"Bottom\", \"Left\"], function(i, v) {\n\t\t\t\t\tcoming.skin.css('padding' + v, getValue(coming.padding[ i ]));\n\t\t\t\t});\n\n\t\t\t\tF.trigger('onReady');\n\n\t\t\t\t// Check before try to load; 'inline' and 'html' types need content, others - href\n\t\t\t\tif (type === 'inline' || type === 'html') {\n\t\t\t\t\tif (!coming.content || !coming.content.length) {\n\t\t\t\t\t\treturn F._error( 'content' );\n\t\t\t\t\t}\n\n\t\t\t\t} else if (!href) {\n\t\t\t\t\treturn F._error( 'href' );\n\t\t\t\t}\n\n\t\t\t\tif (type === 'image') {\n\t\t\t\t\tF._loadImage();\n\n\t\t\t\t} else if (type === 'ajax') {\n\t\t\t\t\tF._loadAjax();\n\n\t\t\t\t} else if (type === 'iframe') {\n\t\t\t\t\tF._loadIframe();\n\n\t\t\t\t} else {\n\t\t\t\t\tF._afterLoad();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_error: function ( type ) {\n\t\t\t\t$.extend(F.coming, {\n\t\t\t\t\ttype       : 'html',\n\t\t\t\t\tautoWidth  : true,\n\t\t\t\t\tautoHeight : true,\n\t\t\t\t\tminWidth   : 0,\n\t\t\t\t\tminHeight  : 0,\n\t\t\t\t\tscrolling  : 'no',\n\t\t\t\t\thasError   : type,\n\t\t\t\t\tcontent    : F.coming.tpl.error\n\t\t\t\t});\n\n\t\t\t\tF._afterLoad();\n\t\t\t},\n\n\t\t\t_loadImage: function () {\n\t\t\t\t// Reset preload image so it is later possible to check \"complete\" property\n\t\t\t\tvar img = F.imgPreload = new Image();\n\n\t\t\t\timg.onload = function () {\n\t\t\t\t\tthis.onload = this.onerror = null;\n\n\t\t\t\t\tF.coming.width  = this.width / F.opts.pixelRatio;\n\t\t\t\t\tF.coming.height = this.height / F.opts.pixelRatio;\n\n\t\t\t\t\tF._afterLoad();\n\t\t\t\t};\n\n\t\t\t\timg.onerror = function () {\n\t\t\t\t\tthis.onload = this.onerror = null;\n\n\t\t\t\t\tF._error( 'image' );\n\t\t\t\t};\n\n\t\t\t\timg.src = F.coming.href;\n\t\t\t\timg.src2 = F.coming.data_href;\n\t\t\t\timg.target = F.coming.data_target;\n\n\t\t\t\tif (img.complete !== true) {\n\t\t\t\t\tF.showLoading();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_loadAjax: function () {\n\t\t\t\tvar coming = F.coming;\n\n\t\t\t\tF.showLoading();\n\n\t\t\t\tF.ajaxLoad = $.ajax($.extend({}, coming.ajax, {\n\t\t\t\t\turl: coming.href,\n\t\t\t\t\terror: function (jqXHR, textStatus) {\n\t\t\t\t\t\tif (F.coming && textStatus !== 'abort') {\n\t\t\t\t\t\t\tF._error( 'ajax', jqXHR );\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tF.hideLoading();\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\t\t\t\t\tsuccess: function (data, textStatus) {\n\t\t\t\t\t\tif (textStatus === 'success') {\n\t\t\t\t\t\t\tcoming.content = data;\n\n\t\t\t\t\t\t\tF._afterLoad();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}));\n\t\t\t},\n\n\t\t\t_loadIframe: function() {\n\t\t\t\tvar coming = F.coming,\n\t\t\t\t\tiframe = $(coming.tpl.iframe.replace(/\\{rnd\\}/g, new Date().getTime()))\n\t\t\t\t\t\t.attr('scrolling', isTouch ? 'auto' : coming.iframe.scrolling)\n\t\t\t\t\t\t.attr('src', coming.href);\n\n\t\t\t\t// This helps IE\n\t\t\t\t$(coming.wrap).bind('onReset', function () {\n\t\t\t\t\ttry {\n\t\t\t\t\t\t$(this).find('iframe').hide().attr('src', '//about:blank').end().empty();\n\t\t\t\t\t} catch (e) {}\n\t\t\t\t});\n\n\t\t\t\tif (coming.iframe.preload) {\n\t\t\t\t\tF.showLoading();\n\n\t\t\t\t\tiframe.one('load', function() {\n\t\t\t\t\t\t$(this).data('ready', 1);\n\n\t\t\t\t\t\t// iOS will lose scrolling if we resize\n\t\t\t\t\t\tif (!isTouch) {\n\t\t\t\t\t\t\t$(this).bind('load.fb', F.update);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Without this trick:\n\t\t\t\t\t\t//   - iframe won't scroll on iOS devices\n\t\t\t\t\t\t//   - IE7 sometimes displays empty iframe\n\t\t\t\t\t\t$(this).parents('.fancybox-wrap').width('100%').removeClass('fancybox-tmp').show();\n\n\t\t\t\t\t\tF._afterLoad();\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tcoming.content = iframe.appendTo( coming.inner );\n\n\t\t\t\tif (!coming.iframe.preload) {\n\t\t\t\t\tF._afterLoad();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_preloadImages: function() {\n\t\t\t\tvar group   = F.group,\n\t\t\t\t\tcurrent = F.current,\n\t\t\t\t\tlen     = group.length,\n\t\t\t\t\tcnt     = current.preload ? Math.min(current.preload, len - 1) : 0,\n\t\t\t\t\titem,\n\t\t\t\t\ti;\n\n\t\t\t\tfor (i = 1; i <= cnt; i += 1) {\n\t\t\t\t\titem = group[ (current.index + i ) % len ];\n\n\t\t\t\t\tif (item.type === 'image' && item.href) {\n\t\t\t\t\t\tnew Image().src = item.href;\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\tif (item.type === 'image' && item.data_href) {\n\t\t\t\t\t\tnew Image().src2 = item.data_href;\n\t\t\t\t\t}\n\t\t\t\t\tif (item.type === 'image' && item.data_target) {\n\t\t\t\t\t\tnew Image().target = item.data_target;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_afterLoad: function () {\n\t\t\t\tvar coming   = F.coming,\n\t\t\t\t\tprevious = F.current,\n\t\t\t\t\tplaceholder = 'fancybox-placeholder',\n\t\t\t\t\tcurrent,\n\t\t\t\t\tcontent,\n\t\t\t\t\ttype,\n\t\t\t\t\tscrolling,\n\t\t\t\t\thref,\n\t\t\t\t\tdata_href,\n\t\t\t\t\tdata_target,\n\t\t\t\t\tembed;\n\n\t\t\t\tF.hideLoading();\n\n\t\t\t\tif (!coming || F.isActive === false) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (false === F.trigger('afterLoad', coming, previous)) {\n\t\t\t\t\tcoming.wrap.stop(true).trigger('onReset').remove();\n\n\t\t\t\t\tF.coming = null;\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (previous) {\n\t\t\t\t\tF.trigger('beforeChange', previous);\n\n\t\t\t\t\tprevious.wrap.stop(true).removeClass('fancybox-opened')\n\t\t\t\t\t\t.find('.fancybox-item, .fancybox-nav')\n\t\t\t\t\t\t.remove();\n\t\t\t\t}\n\n\t\t\t\tF.unbindEvents();\n\n\t\t\t\tcurrent   = coming;\n\t\t\t\tcontent   = coming.content;\n\t\t\t\ttype      = coming.type;\n\t\t\t\tscrolling = coming.scrolling;\n\n\t\t\t\t$.extend(F, {\n\t\t\t\t\twrap  : current.wrap,\n\t\t\t\t\tskin  : current.skin,\n\t\t\t\t\touter : current.outer,\n\t\t\t\t\tinner : current.inner,\n\t\t\t\t\tcurrent  : current,\n\t\t\t\t\tprevious : previous\n\t\t\t\t});\n\n\t\t\t\thref = current.href;\n\t\t\t\tdata_href = current.data_href;\n\t\t\t\tdata_target = current.data_target;\n\n\t\t\t\tswitch (type) {\n\t\t\t\t\tcase 'inline':\n\t\t\t\t\tcase 'ajax':\n\t\t\t\t\tcase 'html':\n\t\t\t\t\t\tif (current.selector) {\n\t\t\t\t\t\t\tcontent = $('<div>').html(content).find(current.selector);\n\n\t\t\t\t\t\t} else if (isQuery(content)) {\n\t\t\t\t\t\t\tif (!content.data(placeholder)) {\n\t\t\t\t\t\t\t\tcontent.data(placeholder, $('<div class=\"' + placeholder + '\"></div>').insertAfter( content ).hide() );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tcontent = content.show().detach();\n\n\t\t\t\t\t\t\tcurrent.wrap.bind('onReset', function () {\n\t\t\t\t\t\t\t\tif ($(this).find(content).length) {\n\t\t\t\t\t\t\t\t\tcontent.hide().replaceAll( content.data(placeholder) ).data(placeholder, false);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'image':\n\t\t\t\t\t\t// content = current.tpl.image.replace(/\\{href\\}/g, href);\n\t\t\t\t\t\tcontent = '<a href=\"'+data_href+'\" target=\"'+data_target+'\"><img class=\"fancybox-image\" src=\"'+href+'\" alt=\"\" /></a>';\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'swf':\n\t\t\t\t\t\tcontent = '<object id=\"fancybox-swf\" classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" width=\"100%\" height=\"100%\"><param name=\"movie\" value=\"' + href + '\"></param>';\n\t\t\t\t\t\tembed   = '';\n\n\t\t\t\t\t\t$.each(current.swf, function(name, val) {\n\t\t\t\t\t\t\tcontent += '<param name=\"' + name + '\" value=\"' + val + '\"></param>';\n\t\t\t\t\t\t\tembed   += ' ' + name + '=\"' + val + '\"';\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tcontent += '<embed src=\"' + href + '\" type=\"application/x-shockwave-flash\" width=\"100%\" height=\"100%\"' + embed + '></embed></object>';\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif (!(isQuery(content) && content.parent().is(current.inner))) {\n\t\t\t\t\tcurrent.inner.append( content );\n\t\t\t\t}\n\n\t\t\t\t// Give a chance for helpers or callbacks to update elements\n\t\t\t\tF.trigger('beforeShow');\n\n\t\t\t\t// Set scrolling before calculating dimensions\n\t\t\t\tcurrent.inner.css('overflow', scrolling === 'yes' ? 'scroll' : (scrolling === 'no' ? 'hidden' : scrolling));\n\n\t\t\t\t// Set initial dimensions and start position\n\t\t\t\tF._setDimension();\n\n\t\t\t\tF.reposition();\n\n\t\t\t\tF.isOpen = false;\n\t\t\t\tF.coming = null;\n\n\t\t\t\tF.bindEvents();\n\n\t\t\t\tif (!F.isOpened) {\n\t\t\t\t\t$('.fancybox-wrap').not( current.wrap ).stop(true).trigger('onReset').remove();\n\n\t\t\t\t} else if (previous.prevMethod) {\n\t\t\t\t\tF.transitions[ previous.prevMethod ]();\n\t\t\t\t}\n\n\t\t\t\tF.transitions[ F.isOpened ? current.nextMethod : current.openMethod ]();\n\n\t\t\t\tF._preloadImages();\n\t\t\t},\n\n\t\t\t_setDimension: function () {\n\t\t\t\tvar viewport   = F.getViewport(),\n\t\t\t\t\tsteps      = 0,\n\t\t\t\t\tcanShrink  = false,\n\t\t\t\t\tcanExpand  = false,\n\t\t\t\t\twrap       = F.wrap,\n\t\t\t\t\tskin       = F.skin,\n\t\t\t\t\tinner      = F.inner,\n\t\t\t\t\tcurrent    = F.current,\n\t\t\t\t\twidth      = current.width,\n\t\t\t\t\theight     = current.height,\n\t\t\t\t\tminWidth   = current.minWidth,\n\t\t\t\t\tminHeight  = current.minHeight,\n\t\t\t\t\tmaxWidth   = current.maxWidth,\n\t\t\t\t\tmaxHeight  = current.maxHeight,\n\t\t\t\t\tscrolling  = current.scrolling,\n\t\t\t\t\tscrollOut  = current.scrollOutside ? current.scrollbarWidth : 0,\n\t\t\t\t\tmargin     = current.margin,\n\t\t\t\t\twMargin    = getScalar(margin[1] + margin[3]),\n\t\t\t\t\thMargin    = getScalar(margin[0] + margin[2]),\n\t\t\t\t\twPadding,\n\t\t\t\t\thPadding,\n\t\t\t\t\twSpace,\n\t\t\t\t\thSpace,\n\t\t\t\t\torigWidth,\n\t\t\t\t\torigHeight,\n\t\t\t\t\torigMaxWidth,\n\t\t\t\t\torigMaxHeight,\n\t\t\t\t\tratio,\n\t\t\t\t\twidth_,\n\t\t\t\t\theight_,\n\t\t\t\t\tmaxWidth_,\n\t\t\t\t\tmaxHeight_,\n\t\t\t\t\tiframe,\n\t\t\t\t\tbody;\n\n\t\t\t\t// Reset dimensions so we could re-check actual size\n\t\t\t\twrap.add(skin).add(inner).width('auto').height('auto').removeClass('fancybox-tmp');\n\n\t\t\t\twPadding = getScalar(skin.outerWidth(true)  - skin.width());\n\t\t\t\thPadding = getScalar(skin.outerHeight(true) - skin.height());\n\n\t\t\t\t// Any space between content and viewport (margin, padding, border, title)\n\t\t\t\twSpace = wMargin + wPadding;\n\t\t\t\thSpace = hMargin + hPadding;\n\n\t\t\t\torigWidth  = isPercentage(width)  ? (viewport.w - wSpace) * getScalar(width)  / 100 : width;\n\t\t\t\torigHeight = isPercentage(height) ? (viewport.h - hSpace) * getScalar(height) / 100 : height;\n\n\t\t\t\tif (current.type === 'iframe') {\n\t\t\t\t\tiframe = current.content;\n\n\t\t\t\t\tif (current.autoHeight && iframe && iframe.data('ready') === 1) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tif (iframe[0].contentWindow.document.location) {\n\t\t\t\t\t\t\t\tinner.width( origWidth ).height(9999);\n\n\t\t\t\t\t\t\t\tbody = iframe.contents().find('body');\n\n\t\t\t\t\t\t\t\tif (scrollOut) {\n\t\t\t\t\t\t\t\t\tbody.css('overflow-x', 'hidden');\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\torigHeight = body.outerHeight(true);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} catch (e) {}\n\t\t\t\t\t}\n\n\t\t\t\t} else if (current.autoWidth || current.autoHeight) {\n\t\t\t\t\tinner.addClass( 'fancybox-tmp' );\n\n\t\t\t\t\t// Set width or height in case we need to calculate only one dimension\n\t\t\t\t\tif (!current.autoWidth) {\n\t\t\t\t\t\tinner.width( origWidth );\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!current.autoHeight) {\n\t\t\t\t\t\tinner.height( origHeight );\n\t\t\t\t\t}\n\n\t\t\t\t\tif (current.autoWidth) {\n\t\t\t\t\t\torigWidth = inner.width();\n\t\t\t\t\t}\n\n\t\t\t\t\tif (current.autoHeight) {\n\t\t\t\t\t\torigHeight = inner.height();\n\t\t\t\t\t}\n\n\t\t\t\t\tinner.removeClass( 'fancybox-tmp' );\n\t\t\t\t}\n\n\t\t\t\twidth  = getScalar( origWidth );\n\t\t\t\theight = getScalar( origHeight );\n\n\t\t\t\tratio  = origWidth / origHeight;\n\n\t\t\t\t// Calculations for the content\n\t\t\t\tminWidth  = getScalar(isPercentage(minWidth) ? getScalar(minWidth, 'w') - wSpace : minWidth);\n\t\t\t\tmaxWidth  = getScalar(isPercentage(maxWidth) ? getScalar(maxWidth, 'w') - wSpace : maxWidth);\n\n\t\t\t\tminHeight = getScalar(isPercentage(minHeight) ? getScalar(minHeight, 'h') - hSpace : minHeight);\n\t\t\t\tmaxHeight = getScalar(isPercentage(maxHeight) ? getScalar(maxHeight, 'h') - hSpace : maxHeight);\n\n\t\t\t\t// These will be used to determine if wrap can fit in the viewport\n\t\t\t\torigMaxWidth  = maxWidth;\n\t\t\t\torigMaxHeight = maxHeight;\n\n\t\t\t\tif (current.fitToView) {\n\t\t\t\t\tmaxWidth  = Math.min(viewport.w - wSpace, maxWidth);\n\t\t\t\t\tmaxHeight = Math.min(viewport.h - hSpace, maxHeight);\n\t\t\t\t}\n\n\t\t\t\tmaxWidth_  = viewport.w - wMargin;\n\t\t\t\tmaxHeight_ = viewport.h - hMargin;\n\n\t\t\t\tif (current.aspectRatio) {\n\t\t\t\t\tif (width > maxWidth) {\n\t\t\t\t\t\twidth  = maxWidth;\n\t\t\t\t\t\theight = getScalar(width / ratio);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (height > maxHeight) {\n\t\t\t\t\t\theight = maxHeight;\n\t\t\t\t\t\twidth  = getScalar(height * ratio);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (width < minWidth) {\n\t\t\t\t\t\twidth  = minWidth;\n\t\t\t\t\t\theight = getScalar(width / ratio);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (height < minHeight) {\n\t\t\t\t\t\theight = minHeight;\n\t\t\t\t\t\twidth  = getScalar(height * ratio);\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\t\t\t\t\twidth = Math.max(minWidth, Math.min(width, maxWidth));\n\n\t\t\t\t\tif (current.autoHeight && current.type !== 'iframe') {\n\t\t\t\t\t\tinner.width( width );\n\n\t\t\t\t\t\theight = inner.height();\n\t\t\t\t\t}\n\n\t\t\t\t\theight = Math.max(minHeight, Math.min(height, maxHeight));\n\t\t\t\t}\n\n\t\t\t\t// Try to fit inside viewport (including the title)\n\t\t\t\tif (current.fitToView) {\n\t\t\t\t\tinner.width( width ).height( height );\n\n\t\t\t\t\twrap.width( width + wPadding );\n\n\t\t\t\t\t// Real wrap dimensions\n\t\t\t\t\twidth_  = wrap.width();\n\t\t\t\t\theight_ = wrap.height();\n\n\t\t\t\t\tif (current.aspectRatio) {\n\t\t\t\t\t\twhile ((width_ > maxWidth_ || height_ > maxHeight_) && width > minWidth && height > minHeight) {\n\t\t\t\t\t\t\tif (steps++ > 19) {\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\theight = Math.max(minHeight, Math.min(maxHeight, height - 10));\n\t\t\t\t\t\t\twidth  = getScalar(height * ratio);\n\n\t\t\t\t\t\t\tif (width < minWidth) {\n\t\t\t\t\t\t\t\twidth  = minWidth;\n\t\t\t\t\t\t\t\theight = getScalar(width / ratio);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (width > maxWidth) {\n\t\t\t\t\t\t\t\twidth  = maxWidth;\n\t\t\t\t\t\t\t\theight = getScalar(width / ratio);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tinner.width( width ).height( height );\n\n\t\t\t\t\t\t\twrap.width( width + wPadding );\n\n\t\t\t\t\t\t\twidth_  = wrap.width();\n\t\t\t\t\t\t\theight_ = wrap.height();\n\t\t\t\t\t\t}\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\twidth  = Math.max(minWidth,  Math.min(width,  width  - (width_  - maxWidth_)));\n\t\t\t\t\t\theight = Math.max(minHeight, Math.min(height, height - (height_ - maxHeight_)));\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (scrollOut && scrolling === 'auto' && height < origHeight && (width + wPadding + scrollOut) < maxWidth_) {\n\t\t\t\t\twidth += scrollOut;\n\t\t\t\t}\n\n\t\t\t\tinner.width( width ).height( height );\n\n\t\t\t\twrap.width( width + wPadding );\n\n\t\t\t\twidth_  = wrap.width();\n\t\t\t\theight_ = wrap.height();\n\n\t\t\t\tcanShrink = (width_ > maxWidth_ || height_ > maxHeight_) && width > minWidth && height > minHeight;\n\t\t\t\tcanExpand = current.aspectRatio ? (width < origMaxWidth && height < origMaxHeight && width < origWidth && height < origHeight) : ((width < origMaxWidth || height < origMaxHeight) && (width < origWidth || height < origHeight));\n\n\t\t\t\t$.extend(current, {\n\t\t\t\t\tdim : {\n\t\t\t\t\t\twidth\t: getValue( width_ ),\n\t\t\t\t\t\theight\t: getValue( height_ )\n\t\t\t\t\t},\n\t\t\t\t\torigWidth  : origWidth,\n\t\t\t\t\torigHeight : origHeight,\n\t\t\t\t\tcanShrink  : canShrink,\n\t\t\t\t\tcanExpand  : canExpand,\n\t\t\t\t\twPadding   : wPadding,\n\t\t\t\t\thPadding   : hPadding,\n\t\t\t\t\twrapSpace  : height_ - skin.outerHeight(true),\n\t\t\t\t\tskinSpace  : skin.height() - height\n\t\t\t\t});\n\n\t\t\t\tif (!iframe && current.autoHeight && height > minHeight && height < maxHeight && !canExpand) {\n\t\t\t\t\tinner.height('auto');\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_getPosition: function (onlyAbsolute) {\n\t\t\t\tvar current  = F.current,\n\t\t\t\t\tviewport = F.getViewport(),\n\t\t\t\t\tmargin   = current.margin,\n\t\t\t\t\twidth    = F.wrap.width()  + margin[1] + margin[3],\n\t\t\t\t\theight   = F.wrap.height() + margin[0] + margin[2],\n\t\t\t\t\trez      = {\n\t\t\t\t\t\tposition: 'absolute',\n\t\t\t\t\t\ttop  : margin[0],\n\t\t\t\t\t\tleft : margin[3]\n\t\t\t\t\t};\n\n\t\t\t\tif (current.autoCenter && current.fixed && !onlyAbsolute && height <= viewport.h && width <= viewport.w) {\n\t\t\t\t\trez.position = 'fixed';\n\n\t\t\t\t} else if (!current.locked) {\n\t\t\t\t\trez.top  += viewport.y;\n\t\t\t\t\trez.left += viewport.x;\n\t\t\t\t}\n\n\t\t\t\trez.top  = getValue(Math.max(rez.top,  rez.top  + ((viewport.h - height) * current.topRatio)));\n\t\t\t\trez.left = getValue(Math.max(rez.left, rez.left + ((viewport.w - width)  * current.leftRatio)));\n\n\t\t\t\treturn rez;\n\t\t\t},\n\n\t\t\t_afterZoomIn: function () {\n\t\t\t\tvar current = F.current;\n\n\t\t\t\tif (!current) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tF.isOpen = F.isOpened = true;\n\n\t\t\t\tF.wrap.css('overflow', 'visible').addClass('fancybox-opened').hide().show(0);\n\n\t\t\t\tF.update();\n\n\t\t\t\t// Assign a click event\n\t\t\t\tif ( current.closeClick || (current.nextClick && F.group.length > 1) ) {\n\t\t\t\t\tF.inner.css('cursor', 'pointer').bind('click.fb', function(e) {\n\t\t\t\t\t\tif (!$(e.target).is('a') && !$(e.target).parent().is('a')) {\n\t\t\t\t\t\t\te.preventDefault();\n\n\t\t\t\t\t\t\tF[ current.closeClick ? 'close' : 'next' ]();\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Create a close button\n\t\t\t\tif (current.closeBtn) {\n\t\t\t\t\t$(current.tpl.closeBtn).appendTo(F.skin).bind('click.fb', function(e) {\n\t\t\t\t\t\te.preventDefault();\n\n\t\t\t\t\t\tF.close();\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Create navigation arrows\n\t\t\t\tif (current.arrows && F.group.length > 1) {\n\t\t\t\t\tif (current.loop || current.index > 0) {\n\t\t\t\t\t\t$(current.tpl.prev).appendTo(F.outer).bind('click.fb', F.prev);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (current.loop || current.index < F.group.length - 1) {\n\t\t\t\t\t\t$(current.tpl.next).appendTo(F.outer).bind('click.fb', F.next);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tF.trigger('afterShow');\n\n\t\t\t\t// Stop the slideshow if this is the last item\n\t\t\t\tif (!current.loop && current.index === current.group.length - 1) {\n\n\t\t\t\t\tF.play( false );\n\n\t\t\t\t} else if (F.opts.autoPlay && !F.player.isActive) {\n\t\t\t\t\tF.opts.autoPlay = false;\n\n\t\t\t\t\tF.play(true);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t_afterZoomOut: function ( obj ) {\n\t\t\t\tobj = obj || F.current;\n\n\t\t\t\t$('.fancybox-wrap').trigger('onReset').remove();\n\n\t\t\t\t$.extend(F, {\n\t\t\t\t\tgroup  : {},\n\t\t\t\t\topts   : {},\n\t\t\t\t\trouter : false,\n\t\t\t\t\tcurrent   : null,\n\t\t\t\t\tisActive  : false,\n\t\t\t\t\tisOpened  : false,\n\t\t\t\t\tisOpen    : false,\n\t\t\t\t\tisClosing : false,\n\t\t\t\t\twrap   : null,\n\t\t\t\t\tskin   : null,\n\t\t\t\t\touter  : null,\n\t\t\t\t\tinner  : null\n\t\t\t\t});\n\n\t\t\t\tF.trigger('afterClose', obj);\n\t\t\t}\n\t\t});\n\n\t\t/*\n\t\t *\tDefault transitions\n\t\t */\n\n\t\tF.transitions = {\n\t\t\tgetOrigPosition: function () {\n\t\t\t\tvar current  = F.current,\n\t\t\t\t\telement  = current.element,\n\t\t\t\t\torig     = current.orig,\n\t\t\t\t\tpos      = {},\n\t\t\t\t\twidth    = 50,\n\t\t\t\t\theight   = 50,\n\t\t\t\t\thPadding = current.hPadding,\n\t\t\t\t\twPadding = current.wPadding,\n\t\t\t\t\tviewport = F.getViewport();\n\n\t\t\t\tif (!orig && current.isDom && element.is(':visible')) {\n\t\t\t\t\torig = element.find('img:first');\n\n\t\t\t\t\tif (!orig.length) {\n\t\t\t\t\t\torig = element;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (isQuery(orig)) {\n\t\t\t\t\tpos = orig.offset();\n\n\t\t\t\t\tif (orig.is('img')) {\n\t\t\t\t\t\twidth  = orig.outerWidth();\n\t\t\t\t\t\theight = orig.outerHeight();\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\t\t\t\t\tpos.top  = viewport.y + (viewport.h - height) * current.topRatio;\n\t\t\t\t\tpos.left = viewport.x + (viewport.w - width)  * current.leftRatio;\n\t\t\t\t}\n\n\t\t\t\tif (F.wrap.css('position') === 'fixed' || current.locked) {\n\t\t\t\t\tpos.top  -= viewport.y;\n\t\t\t\t\tpos.left -= viewport.x;\n\t\t\t\t}\n\n\t\t\t\tpos = {\n\t\t\t\t\ttop     : getValue(pos.top  - hPadding * current.topRatio),\n\t\t\t\t\tleft    : getValue(pos.left - wPadding * current.leftRatio),\n\t\t\t\t\twidth   : getValue(width  + wPadding),\n\t\t\t\t\theight  : getValue(height + hPadding)\n\t\t\t\t};\n\n\t\t\t\treturn pos;\n\t\t\t},\n\n\t\t\tstep: function (now, fx) {\n\t\t\t\tvar ratio,\n\t\t\t\t\tpadding,\n\t\t\t\t\tvalue,\n\t\t\t\t\tprop       = fx.prop,\n\t\t\t\t\tcurrent    = F.current,\n\t\t\t\t\twrapSpace  = current.wrapSpace,\n\t\t\t\t\tskinSpace  = current.skinSpace;\n\n\t\t\t\tif (prop === 'width' || prop === 'height') {\n\t\t\t\t\tratio = fx.end === fx.start ? 1 : (now - fx.start) / (fx.end - fx.start);\n\n\t\t\t\t\tif (F.isClosing) {\n\t\t\t\t\t\tratio = 1 - ratio;\n\t\t\t\t\t}\n\n\t\t\t\t\tpadding = prop === 'width' ? current.wPadding : current.hPadding;\n\t\t\t\t\tvalue   = now - padding;\n\n\t\t\t\t\tF.skin[ prop ](  getScalar( prop === 'width' ?  value : value - (wrapSpace * ratio) ) );\n\t\t\t\t\tF.inner[ prop ]( getScalar( prop === 'width' ?  value : value - (wrapSpace * ratio) - (skinSpace * ratio) ) );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tzoomIn: function () {\n\t\t\t\tvar current  = F.current,\n\t\t\t\t\tstartPos = current.pos,\n\t\t\t\t\teffect   = current.openEffect,\n\t\t\t\t\telastic  = effect === 'elastic',\n\t\t\t\t\tendPos   = $.extend({opacity : 1}, startPos);\n\n\t\t\t\t// Remove \"position\" property that breaks older IE\n\t\t\t\tdelete endPos.position;\n\n\t\t\t\tif (elastic) {\n\t\t\t\t\tstartPos = this.getOrigPosition();\n\n\t\t\t\t\tif (current.openOpacity) {\n\t\t\t\t\t\tstartPos.opacity = 0.1;\n\t\t\t\t\t}\n\n\t\t\t\t} else if (effect === 'fade') {\n\t\t\t\t\tstartPos.opacity = 0.1;\n\t\t\t\t}\n\n\t\t\t\tF.wrap.css(startPos).animate(endPos, {\n\t\t\t\t\tduration : effect === 'none' ? 0 : current.openSpeed,\n\t\t\t\t\teasing   : current.openEasing,\n\t\t\t\t\tstep     : elastic ? this.step : null,\n\t\t\t\t\tcomplete : F._afterZoomIn\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tzoomOut: function () {\n\t\t\t\tvar current  = F.current,\n\t\t\t\t\teffect   = current.closeEffect,\n\t\t\t\t\telastic  = effect === 'elastic',\n\t\t\t\t\tendPos   = {opacity : 0.1};\n\n\t\t\t\tif (elastic) {\n\t\t\t\t\tendPos = this.getOrigPosition();\n\n\t\t\t\t\tif (current.closeOpacity) {\n\t\t\t\t\t\tendPos.opacity = 0.1;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tF.wrap.animate(endPos, {\n\t\t\t\t\tduration : effect === 'none' ? 0 : current.closeSpeed,\n\t\t\t\t\teasing   : current.closeEasing,\n\t\t\t\t\tstep     : elastic ? this.step : null,\n\t\t\t\t\tcomplete : F._afterZoomOut\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tchangeIn: function () {\n\t\t\t\tvar current   = F.current,\n\t\t\t\t\teffect    = current.nextEffect,\n\t\t\t\t\tstartPos  = current.pos,\n\t\t\t\t\tendPos    = { opacity : 1 },\n\t\t\t\t\tdirection = F.direction,\n\t\t\t\t\tdistance  = 200,\n\t\t\t\t\tfield;\n\n\t\t\t\tstartPos.opacity = 0.1;\n\n\t\t\t\tif (effect === 'elastic') {\n\t\t\t\t\tfield = direction === 'down' || direction === 'up' ? 'top' : 'left';\n\n\t\t\t\t\tif (direction === 'down' || direction === 'right') {\n\t\t\t\t\t\tstartPos[ field ] = getValue(getScalar(startPos[ field ]) - distance);\n\t\t\t\t\t\tendPos[ field ]   = '+=' + distance + 'px';\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\tstartPos[ field ] = getValue(getScalar(startPos[ field ]) + distance);\n\t\t\t\t\t\tendPos[ field ]   = '-=' + distance + 'px';\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Workaround for http://bugs.jquery.com/ticket/12273\n\t\t\t\tif (effect === 'none') {\n\t\t\t\t\tF._afterZoomIn();\n\n\t\t\t\t} else {\n\t\t\t\t\tF.wrap.css(startPos).animate(endPos, {\n\t\t\t\t\t\tduration : current.nextSpeed,\n\t\t\t\t\t\teasing   : current.nextEasing,\n\t\t\t\t\t\tcomplete : F._afterZoomIn\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tchangeOut: function () {\n\t\t\t\tvar previous  = F.previous,\n\t\t\t\t\teffect    = previous.prevEffect,\n\t\t\t\t\tendPos    = { opacity : 0.1 },\n\t\t\t\t\tdirection = F.direction,\n\t\t\t\t\tdistance  = 200;\n\n\t\t\t\tif (effect === 'elastic') {\n\t\t\t\t\tendPos[ direction === 'down' || direction === 'up' ? 'top' : 'left' ] = ( direction === 'up' || direction === 'left' ? '-' : '+' ) + '=' + distance + 'px';\n\t\t\t\t}\n\n\t\t\t\tprevious.wrap.animate(endPos, {\n\t\t\t\t\tduration : effect === 'none' ? 0 : previous.prevSpeed,\n\t\t\t\t\teasing   : previous.prevEasing,\n\t\t\t\t\tcomplete : function () {\n\t\t\t\t\t\t$(this).trigger('onReset').remove();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\t/*\n\t\t *\tOverlay helper\n\t\t */\n\n\t\tF.helpers.overlay = {\n\t\t\tdefaults : {\n\t\t\t\tcloseClick : true,      // if true, fancyBox will be closed when user clicks on the overlay\n\t\t\t\tspeedOut   : 200,       // duration of fadeOut animation\n\t\t\t\tshowEarly  : true,      // indicates if should be opened immediately or wait until the content is ready\n\t\t\t\tcss        : {},        // custom CSS properties\n\t\t\t\tlocked     : !isTouch,  // if true, the content will be locked into overlay\n\t\t\t\tfixed      : true       // if false, the overlay CSS position property will not be set to \"fixed\"\n\t\t\t},\n\n\t\t\toverlay : null,      // current handle\n\t\t\tfixed   : false,     // indicates if the overlay has position \"fixed\"\n\t\t\tel      : $('html'), // element that contains \"the lock\"\n\n\t\t\t// Public methods\n\t\t\tcreate : function(opts) {\n\t\t\t\tvar parent;\n\n\t\t\t\topts = $.extend({}, this.defaults, opts);\n\n\t\t\t\tif (this.overlay) {\n\t\t\t\t\tthis.close();\n\t\t\t\t}\n\n\t\t\t\tparent = F.coming ? F.coming.parent : opts.parent;\n\n\t\t\t\tthis.overlay = $('<div class=\"fancybox-overlay\"></div>').appendTo( parent && parent.length ? parent : 'body' );\n\t\t\t\tthis.fixed   = false;\n\n\t\t\t\tif (opts.fixed && F.defaults.fixed) {\n\t\t\t\t\tthis.overlay.addClass('fancybox-overlay-fixed');\n\n\t\t\t\t\tthis.fixed = true;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\topen : function(opts) {\n\t\t\t\tvar that = this;\n\n\t\t\t\topts = $.extend({}, this.defaults, opts);\n\n\t\t\t\tif (this.overlay) {\n\t\t\t\t\tthis.overlay.unbind('.overlay').width('auto').height('auto');\n\n\t\t\t\t} else {\n\t\t\t\t\tthis.create(opts);\n\t\t\t\t}\n\n\t\t\t\tif (!this.fixed) {\n\t\t\t\t\tW.bind('resize.overlay', $.proxy( this.update, this) );\n\n\t\t\t\t\tthis.update();\n\t\t\t\t}\n\n\t\t\t\tif (opts.closeClick) {\n\t\t\t\t\tthis.overlay.bind('click.overlay', function(e) {\n\t\t\t\t\t\tif ($(e.target).hasClass('fancybox-overlay')) {\n\t\t\t\t\t\t\tif (F.isActive) {\n\t\t\t\t\t\t\t\tF.close();\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tthat.close();\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tthis.overlay.css( opts.css ).show();\n\t\t\t},\n\n\t\t\tclose : function() {\n\t\t\t\tW.unbind('resize.overlay');\n\n\t\t\t\tif (this.el.hasClass('fancybox-lock')) {\n\t\t\t\t\t$('.fancybox-margin').removeClass('fancybox-margin');\n\n\t\t\t\t\tthis.el.removeClass('fancybox-lock');\n\n\t\t\t\t\tW.scrollTop( this.scrollV ).scrollLeft( this.scrollH );\n\t\t\t\t}\n\n\t\t\t\t$('.fancybox-overlay').remove().hide();\n\n\t\t\t\t$.extend(this, {\n\t\t\t\t\toverlay : null,\n\t\t\t\t\tfixed   : false\n\t\t\t\t});\n\t\t\t},\n\n\t\t\t// Private, callbacks\n\n\t\t\tupdate : function () {\n\t\t\t\tvar width = '100%', offsetWidth;\n\n\t\t\t\t// Reset width/height so it will not mess\n\t\t\t\tthis.overlay.width(width).height('100%');\n\n\t\t\t\t// jQuery does not return reliable result for IE\n\t\t\t\tif (IE) {\n\t\t\t\t\toffsetWidth = Math.max(document.documentElement.offsetWidth, document.body.offsetWidth);\n\n\t\t\t\t\tif (D.width() > offsetWidth) {\n\t\t\t\t\t\twidth = D.width();\n\t\t\t\t\t}\n\n\t\t\t\t} else if (D.width() > W.width()) {\n\t\t\t\t\twidth = D.width();\n\t\t\t\t}\n\n\t\t\t\tthis.overlay.width(width).height(D.height());\n\t\t\t},\n\n\t\t\t// This is where we can manipulate DOM, because later it would cause iframes to reload\n\t\t\tonReady : function (opts, obj) {\n\t\t\t\tvar overlay = this.overlay;\n\n\t\t\t\t$('.fancybox-overlay').stop(true, true);\n\n\t\t\t\tif (!overlay) {\n\t\t\t\t\tthis.create(opts);\n\t\t\t\t}\n\n\t\t\t\tif (opts.locked && this.fixed && obj.fixed) {\n\t\t\t\t\tobj.locked = this.overlay.append( obj.wrap );\n\t\t\t\t\tobj.fixed  = false;\n\t\t\t\t}\n\n\t\t\t\tif (opts.showEarly === true) {\n\t\t\t\t\tthis.beforeShow.apply(this, arguments);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeShow : function(opts, obj) {\n\t\t\t\tif (obj.locked && !this.el.hasClass('fancybox-lock')) {\n\t\t\t\t\tif (this.fixPosition !== false) {\n\t\t\t\t\t\t$('*:not(object)').filter(function(){\n\t\t\t\t\t\t\treturn ($(this).css('position') === 'fixed' && !$(this).hasClass(\"fancybox-overlay\") && !$(this).hasClass(\"fancybox-wrap\") );\n\t\t\t\t\t\t}).addClass('fancybox-margin');\n\t\t\t\t\t}\n\n\t\t\t\t\tthis.el.addClass('fancybox-margin');\n\n\t\t\t\t\tthis.scrollV = W.scrollTop();\n\t\t\t\t\tthis.scrollH = W.scrollLeft();\n\n\t\t\t\t\tthis.el.addClass('fancybox-lock');\n\n\t\t\t\t\tW.scrollTop( this.scrollV ).scrollLeft( this.scrollH );\n\t\t\t\t}\n\n\t\t\t\tthis.open(opts);\n\t\t\t},\n\n\t\t\tonUpdate : function() {\n\t\t\t\tif (!this.fixed) {\n\t\t\t\t\tthis.update();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tafterClose: function (opts) {\n\t\t\t\t// Remove overlay if exists and fancyBox is not opening\n\t\t\t\t// (e.g., it is not being open using afterClose callback)\n\t\t\t\tif (this.overlay && !F.coming) {\n\t\t\t\t\tthis.overlay.fadeOut(opts.speedOut, $.proxy( this.close, this ));\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/*\n\t\t *\tTitle helper\n\t\t */\n\n\t\tF.helpers.title = {\n\t\t\tdefaults : {\n\t\t\t\ttype     : 'float', // 'float', 'inside', 'outside' or 'over',\n\t\t\t\tposition : 'bottom' // 'top' or 'bottom'\n\t\t\t},\n\n\t\t\tbeforeShow: function (opts) {\n\t\t\t\tvar current = F.current,\n\t\t\t\t\ttext    = current.title,\n\t\t\t\t\ttype    = opts.type,\n\t\t\t\t\ttitle,\n\t\t\t\t\ttarget;\n\n\t\t\t\tif ($.isFunction(text)) {\n\t\t\t\t\ttext = text.call(current.element, current);\n\t\t\t\t}\n\n\t\t\t\tif (!isString(text) || $.trim(text) === '') {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\ttitle = $('<div class=\"fancybox-title fancybox-title-' + type + '-wrap\">' + text + '</div>');\n\n\t\t\t\tswitch (type) {\n\t\t\t\t\tcase 'inside':\n\t\t\t\t\t\ttarget = F.skin;\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'outside':\n\t\t\t\t\t\ttarget = F.wrap;\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'over':\n\t\t\t\t\t\ttarget = F.inner;\n\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault: // 'float'\n\t\t\t\t\t\ttarget = F.skin;\n\n\t\t\t\t\t\ttitle.appendTo('body');\n\n\t\t\t\t\t\tif (IE) {\n\t\t\t\t\t\t\ttitle.width( title.width() );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttitle.wrapInner('<span class=\"child\"></span>');\n\n\t\t\t\t\t\t//Increase bottom margin so this title will also fit into viewport\n\t\t\t\t\t\tF.current.margin[2] += Math.abs( getScalar(title.css('margin-bottom')) );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\ttitle[ (opts.position === 'top' ? 'prependTo'  : 'appendTo') ](target);\n\t\t\t}\n\t\t};\n\n\t\t// jQuery plugin initialization\n\t\t$.fn.fancybox = function (options) {\n\t\t\tvar index,\n\t\t\t\tthat     = $(this),\n\t\t\t\tselector = this.selector || '',\n\t\t\t\trun      = function(e) {\n\t\t\t\t\tvar what = $(this).blur(), idx = index, relType, relVal;\n\n\t\t\t\t\tif (!(e.ctrlKey || e.altKey || e.shiftKey || e.metaKey) && !what.is('.fancybox-wrap')) {\n\t\t\t\t\t\trelType = options.groupAttr || 'data-fancybox-group';\n\t\t\t\t\t\trelVal  = what.attr(relType);\n\n\t\t\t\t\t\tif (!relVal) {\n\t\t\t\t\t\t\trelType = 'rel';\n\t\t\t\t\t\t\trelVal  = what.get(0)[ relType ];\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (relVal && relVal !== '' && relVal !== 'nofollow') {\n\t\t\t\t\t\t\twhat = selector.length ? $(selector) : that;\n\t\t\t\t\t\t\twhat = what.filter('[' + relType + '=\"' + relVal + '\"]');\n\t\t\t\t\t\t\tidx  = what.index(this);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\toptions.index = idx;\n\n\t\t\t\t\t\t// Stop an event from bubbling if everything is fine\n\t\t\t\t\t\tif (F.open(what, options) !== false) {\n\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\toptions = options || {};\n\t\t\tindex   = options.index || 0;\n\n\t\t\tif (!selector || options.live === false) {\n\t\t\t\tthat.unbind('click.fb-start').bind('click.fb-start', run);\n\n\t\t\t} else {\n\t\t\t\tD.undelegate(selector, 'click.fb-start').delegate(selector + \":not('.fancybox-item, .fancybox-nav')\", 'click.fb-start', run);\n\t\t\t}\n\n\t\t\tthis.filter('[data-fancybox-start=1]').trigger('click');\n\n\t\t\treturn this;\n\t\t};\n\n\t\t// Tests that need a body at doc ready\n\t\tD.ready(function() {\n\t\t\tvar w1, w2;\n\n\t\t\tif ( $.scrollbarWidth === undefined ) {\n\t\t\t\t// http://benalman.com/projects/jquery-misc-plugins/#scrollbarwidth\n\t\t\t\t$.scrollbarWidth = function() {\n\t\t\t\t\tvar parent = $('<div style=\"width:50px;height:50px;overflow:auto\"><div/></div>').appendTo('body'),\n\t\t\t\t\t\tchild  = parent.children(),\n\t\t\t\t\t\twidth  = child.innerWidth() - child.height( 99 ).innerWidth();\n\n\t\t\t\t\tparent.remove();\n\n\t\t\t\t\treturn width;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif ( $.support.fixedPosition === undefined ) {\n\t\t\t\t$.support.fixedPosition = (function() {\n\t\t\t\t\tvar elem  = $('<div style=\"position:fixed;top:20px;\"></div>').appendTo('body'),\n\t\t\t\t\t\tfixed = ( elem[0].offsetTop === 20 || elem[0].offsetTop === 15 );\n\n\t\t\t\t\telem.remove();\n\n\t\t\t\t\treturn fixed;\n\t\t\t\t}());\n\t\t\t}\n\n\t\t\t$.extend(F.defaults, {\n\t\t\t\tscrollbarWidth : $.scrollbarWidth(),\n\t\t\t\tfixed  : $.support.fixedPosition,\n\t\t\t\tparent : $('body')\n\t\t\t});\n\n\t\t\t//Get real width of page scroll-bar\n\t\t\tw1 = $(window).width();\n\n\t\t\tH.addClass('fancybox-lock-test');\n\n\t\t\tw2 = $(window).width();\n\n\t\t\tH.removeClass('fancybox-lock-test');\n\n\t\t\t$(\"<style type='text/css'>.fancybox-margin{margin-right:\" + (w2 - w1) + \"px;}</style>\").appendTo(\"head\");\n\t\t});\n\n\t}(window, document, $));\n\n\t;(function ($) {\n\t\t//Shortcut for fancyBox object\n\t\tvar F = $.fancybox;\n\n\t\t//Add helper object\n\t\tF.helpers.thumbs = {\n\t\t\tdefaults : {\n\t\t\t\twidth    : 50,       // thumbnail width\n\t\t\t\theight   : 50,       // thumbnail height\n\t\t\t\tposition : 'bottom', // 'top' or 'bottom'\n\t\t\t\tsource   : function ( item ) {  // function to obtain the URL of the thumbnail image\n\t\t\t\t\tvar href;\n\n\t\t\t\t\tif (item.element) {\n\t\t\t\t\t\thref = $(item.element).find('img').attr('src');\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!href && item.type === 'image' && item.href) {\n\t\t\t\t\t\thref = item.href;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn href;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\twrap  : null,\n\t\t\tlist  : null,\n\t\t\twidth : 0,\n\n\t\t\tinit: function (opts, obj) {\n\t\t\t\tvar that = this,\n\t\t\t\t\tlist,\n\t\t\t\t\tthumbWidth  = opts.width,\n\t\t\t\t\tthumbHeight = opts.height,\n\t\t\t\t\tthumbSource = opts.source;\n\n\t\t\t\t//Build list structure\n\t\t\t\tlist = '';\n\n\t\t\t\tfor (var n = 0; n < obj.group.length; n++) {\n\t\t\t\t\tlist += '<li><a style=\"width:' + thumbWidth + 'px;height:' + thumbHeight + 'px;\" href=\"javascript:$.fancybox.jumpto(' + n + ');\"></a></li>';\n\t\t\t\t}\n\n\t\t\t\tthis.wrap = $('<div id=\"fancybox-thumbs\"></div>').addClass(opts.position).appendTo('body');\n\t\t\t\tthis.list = $('<ul>' + list + '</ul>').appendTo(this.wrap);\n\n\t\t\t\t//Load each thumbnail\n\t\t\t\t$.each(obj.group, function (i) {\n\t\t\t\t\tvar el   = obj.group[ i ],\n\t\t\t\t\t\thref = thumbSource( el );\n\n\t\t\t\t\tif (!href) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t$(\"<img />\").load(function () {\n\t\t\t\t\t\tvar width  = this.width,\n\t\t\t\t\t\t\theight = this.height,\n\t\t\t\t\t\t\twidthRatio, heightRatio, parent;\n\n\t\t\t\t\t\tif (!that.list || !width || !height) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t//Calculate thumbnail width/height and center it\n\t\t\t\t\t\twidthRatio  = width / thumbWidth;\n\t\t\t\t\t\theightRatio = height / thumbHeight;\n\n\t\t\t\t\t\tparent = that.list.children().eq(i).find('a');\n\n\t\t\t\t\t\tif (widthRatio >= 1 && heightRatio >= 1) {\n\t\t\t\t\t\t\tif (widthRatio > heightRatio) {\n\t\t\t\t\t\t\t\twidth  = Math.floor(width / heightRatio);\n\t\t\t\t\t\t\t\theight = thumbHeight;\n\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\twidth  = thumbWidth;\n\t\t\t\t\t\t\t\theight = Math.floor(height / widthRatio);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t$(this).css({\n\t\t\t\t\t\t\twidth  : width,\n\t\t\t\t\t\t\theight : height,\n\t\t\t\t\t\t\ttop    : Math.floor(thumbHeight / 2 - height / 2),\n\t\t\t\t\t\t\tleft   : Math.floor(thumbWidth / 2 - width / 2)\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tparent.width(thumbWidth).height(thumbHeight);\n\n\t\t\t\t\t\t$(this).hide().appendTo(parent).fadeIn(300);\n\n\t\t\t\t\t})\n\t\t\t\t\t.attr('src',   href)\n\t\t\t\t\t.attr('title', el.title);\n\t\t\t\t});\n\n\t\t\t\t//Set initial width\n\t\t\t\tthis.width = this.list.children().eq(0).outerWidth(true);\n\n\t\t\t\tthis.list.width(this.width * (obj.group.length + 1)).css('left', Math.floor($(window).width() * 0.5 - (obj.index * this.width + this.width * 0.5)));\n\t\t\t},\n\n\t\t\tbeforeLoad: function (opts, obj) {\n\t\t\t\t//Remove self if gallery do not have at least two items\n\t\t\t\tif (obj.group.length < 2) {\n\t\t\t\t\tobj.helpers.thumbs = false;\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t//Increase bottom margin to give space for thumbs\n\t\t\t\tobj.margin[ opts.position === 'top' ? 0 : 2 ] += ((opts.height) + 15);\n\t\t\t},\n\n\t\t\tafterShow: function (opts, obj) {\n\t\t\t\t//Check if exists and create or update list\n\t\t\t\tif (this.list) {\n\t\t\t\t\tthis.onUpdate(opts, obj);\n\n\t\t\t\t} else {\n\t\t\t\t\tthis.init(opts, obj);\n\t\t\t\t}\n\n\t\t\t\t//Set active element\n\t\t\t\tthis.list.children().removeClass('active').eq(obj.index).addClass('active');\n\t\t\t},\n\n\t\t\t//Center list\n\t\t\tonUpdate: function (opts, obj) {\n\t\t\t\tif (this.list) {\n\t\t\t\t\tthis.list.stop(true).animate({\n\t\t\t\t\t\t'left': Math.floor($(window).width() * 0.5 - (obj.index * this.width + this.width * 0.5))\n\t\t\t\t\t}, 150);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeClose: function () {\n\t\t\t\tif (this.wrap) {\n\t\t\t\t\tthis.wrap.remove();\n\t\t\t\t}\n\n\t\t\t\tthis.wrap  = null;\n\t\t\t\tthis.list  = null;\n\t\t\t\tthis.width = 0;\n\t\t\t}\n\t\t}\n\n\t}($));\n\n\n\t/*Js for thumb*/\n\n\t /*!\n\t * Thumbnail helper for fancyBox\n\t * version: 1.0.7 (Mon, 01 Oct 2012)\n\t * @requires fancyBox v2.0 or later\n\t *\n\t * Usage:\n\t *     $(\".fancybox\").fancybox({\n\t *         helpers : {\n\t *             thumbs: {\n\t *                 width  : 50,\n\t *                 height : 50\n\t *             }\n\t *         }\n\t *     });\n\t *\n\t */\n\t;(function ($) {\n\t\t//Shortcut for fancyBox object\n\t\tvar F = $.fancybox;\n\n\t\t//Add helper object\n\t\tF.helpers.thumbs = {\n\t\t\tdefaults : {\n\t\t\t\twidth    : 50,       // thumbnail width\n\t\t\t\theight   : 50,       // thumbnail height\n\t\t\t\tposition : 'bottom', // 'top' or 'bottom'\n\t\t\t\tsource   : function ( item ) {  // function to obtain the URL of the thumbnail image\n\t\t\t\t\tvar href;\n\n\t\t\t\t\tif (item.element) {\n\t\t\t\t\t\thref = $(item.element).find('img').attr('src');\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!href && item.type === 'image' && item.href) {\n\t\t\t\t\t\thref = item.href;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn href;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\twrap  : null,\n\t\t\tlist  : null,\n\t\t\twidth : 0,\n\n\t\t\tinit: function (opts, obj) {\n\t\t\t\tvar that = this,\n\t\t\t\t\tlist,\n\t\t\t\t\tthumbWidth  = opts.width,\n\t\t\t\t\tthumbHeight = opts.height,\n\t\t\t\t\tthumbSource = opts.source;\n\n\t\t\t\t//Build list structure\n\t\t\t\tlist = '';\n\n\t\t\t\tfor (var n = 0; n < obj.group.length; n++) {\n\t\t\t\t\tlist += '<li><a style=\"width:' + thumbWidth + 'px;height:' + thumbHeight + 'px;\" href=\"javascript:$.fancybox.jumpto(' + n + ');\"></a></li>';\n\t\t\t\t}\n\n\t\t\t\tthis.wrap = $('<div id=\"fancybox-thumbs\"></div>').addClass(opts.position).appendTo('body');\n\t\t\t\tthis.list = $('<ul>' + list + '</ul>').appendTo(this.wrap);\n\n\t\t\t\t//Load each thumbnail\n\t\t\t\t$.each(obj.group, function (i) {\n\t\t\t\t\tvar el   = obj.group[ i ],\n\t\t\t\t\t\thref = thumbSource( el );\n\n\t\t\t\t\tif (!href) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t$(\"<img />\").load(function () {\n\t\t\t\t\t\tvar width  = this.width,\n\t\t\t\t\t\t\theight = this.height,\n\t\t\t\t\t\t\twidthRatio, heightRatio, parent;\n\n\t\t\t\t\t\tif (!that.list || !width || !height) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t//Calculate thumbnail width/height and center it\n\t\t\t\t\t\twidthRatio  = width / thumbWidth;\n\t\t\t\t\t\theightRatio = height / thumbHeight;\n\n\t\t\t\t\t\tparent = that.list.children().eq(i).find('a');\n\n\t\t\t\t\t\tif (widthRatio >= 1 && heightRatio >= 1) {\n\t\t\t\t\t\t\tif (widthRatio > heightRatio) {\n\t\t\t\t\t\t\t\twidth  = Math.floor(width / heightRatio);\n\t\t\t\t\t\t\t\theight = thumbHeight;\n\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\twidth  = thumbWidth;\n\t\t\t\t\t\t\t\theight = Math.floor(height / widthRatio);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t$(this).css({\n\t\t\t\t\t\t\twidth  : width,\n\t\t\t\t\t\t\theight : height,\n\t\t\t\t\t\t\ttop    : Math.floor(thumbHeight / 2 - height / 2),\n\t\t\t\t\t\t\tleft   : Math.floor(thumbWidth / 2 - width / 2)\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tparent.width(thumbWidth).height(thumbHeight);\n\n\t\t\t\t\t\t$(this).hide().appendTo(parent).fadeIn(300);\n\n\t\t\t\t\t})\n\t\t\t\t\t.attr('src',   href)\n\t\t\t\t\t.attr('title', el.title);\n\t\t\t\t});\n\n\t\t\t\t//Set initial width\n\t\t\t\tthis.width = this.list.children().eq(0).outerWidth(true);\n\n\t\t\t\tthis.list.width(this.width * (obj.group.length + 1)).css('left', Math.floor($(window).width() * 0.5 - (obj.index * this.width + this.width * 0.5)));\n\t\t\t},\n\n\t\t\tbeforeLoad: function (opts, obj) {\n\t\t\t\t//Remove self if gallery do not have at least two items\n\t\t\t\tif (obj.group.length < 2) {\n\t\t\t\t\tobj.helpers.thumbs = false;\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t//Increase bottom margin to give space for thumbs\n\t\t\t\tobj.margin[ opts.position === 'top' ? 0 : 2 ] += ((opts.height) + 15);\n\t\t\t},\n\n\t\t\tafterShow: function (opts, obj) {\n\t\t\t\t//Check if exists and create or update list\n\t\t\t\tif (this.list) {\n\t\t\t\t\tthis.onUpdate(opts, obj);\n\n\t\t\t\t} else {\n\t\t\t\t\tthis.init(opts, obj);\n\t\t\t\t}\n\n\t\t\t\t//Set active element\n\t\t\t\tthis.list.children().removeClass('active').eq(obj.index).addClass('active');\n\t\t\t},\n\n\t\t\t//Center list\n\t\t\tonUpdate: function (opts, obj) {\n\t\t\t\tif (this.list) {\n\t\t\t\t\tthis.list.stop(true).animate({\n\t\t\t\t\t\t'left': Math.floor($(window).width() * 0.5 - (obj.index * this.width + this.width * 0.5))\n\t\t\t\t\t}, 150);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeClose: function () {\n\t\t\t\tif (this.wrap) {\n\t\t\t\t\tthis.wrap.remove();\n\t\t\t\t}\n\n\t\t\t\tthis.wrap  = null;\n\t\t\t\tthis.list  = null;\n\t\t\t\tthis.width = 0;\n\t\t\t}\n\t\t}\n\n\t}($));\n});\n\n","Plazathemes_Loadjs/js/owl-carousel/owl.carousel.js":"/*\n *  jQuery OwlCarousel v1.3.3\n *\n *  Copyright (c) 2013 Bartosz Wojciechowski\n *  http://www.owlgraphic.com/owlcarousel/\n *\n *  Licensed under MIT\n *\n */\n\n/*JS Lint helpers: */\n/*global dragMove: false, dragEnd: false, $, jQuery, alert, window, document */\n/*jslint nomen: true, continue:true */\n\nif (typeof Object.create !== \"function\") {\n    Object.create = function (obj) {\n        function F() {}\n        F.prototype = obj;\n        return new F();\n    };\n}\n(function ($, window, document) {\n\n    var Carousel = {\n        init : function (options, el) {\n            var base = this;\n\n            base.$elem = $(el);\n            base.options = $.extend({}, $.fn.owlCarousel.options, base.$elem.data(), options);\n\n            base.userOptions = options;\n            base.loadContent();\n        },\n\n        loadContent : function () {\n            var base = this, url;\n\n            function getData(data) {\n                var i, content = \"\";\n                if (typeof base.options.jsonSuccess === \"function\") {\n                    base.options.jsonSuccess.apply(this, [data]);\n                } else {\n                    for (i in data.owl) {\n                        if (data.owl.hasOwnProperty(i)) {\n                            content += data.owl[i].item;\n                        }\n                    }\n                    base.$elem.html(content);\n                }\n                base.logIn();\n            }\n\n            if (typeof base.options.beforeInit === \"function\") {\n                base.options.beforeInit.apply(this, [base.$elem]);\n            }\n\n            if (typeof base.options.jsonPath === \"string\") {\n                url = base.options.jsonPath;\n                $.getJSON(url, getData);\n            } else {\n                base.logIn();\n            }\n        },\n\n        logIn : function () {\n            var base = this;\n\n            base.$elem.data(\"owl-originalStyles\", base.$elem.attr(\"style\"));\n            base.$elem.data(\"owl-originalClasses\", base.$elem.attr(\"class\"));\n\n            base.$elem.css({opacity: 0});\n            base.orignalItems = base.options.items;\n            base.checkBrowser();\n            base.wrapperWidth = 0;\n            base.checkVisible = null;\n            base.setVars();\n        },\n\n        setVars : function () {\n            var base = this;\n            if (base.$elem.children().length === 0) {return false; }\n            base.baseClass();\n            base.eventTypes();\n            base.$userItems = base.$elem.children();\n            base.itemsAmount = base.$userItems.length;\n            base.wrapItems();\n            base.$owlItems = base.$elem.find(\".owl-item\");\n            base.$owlWrapper = base.$elem.find(\".owl-wrapper\");\n            base.playDirection = \"next\";\n            base.prevItem = 0;\n            base.prevArr = [0];\n            base.currentItem = 0;\n            base.customEvents();\n            base.onStartup();\n        },\n\n        onStartup : function () {\n            var base = this;\n            base.updateItems();\n            base.calculateAll();\n            base.buildControls();\n            base.updateControls();\n            base.response();\n            base.moveEvents();\n            base.stopOnHover();\n            base.owlStatus();\n\n            if (base.options.transitionStyle !== false) {\n                base.transitionTypes(base.options.transitionStyle);\n            }\n            if (base.options.autoPlay === true) {\n                base.options.autoPlay = 5000;\n            }\n            base.play();\n\n            base.$elem.find(\".owl-wrapper\").css(\"display\", \"block\");\n\n            if (!base.$elem.is(\":visible\")) {\n                base.watchVisibility();\n            } else {\n                base.$elem.css(\"opacity\", 1);\n            }\n            base.onstartup = false;\n            base.eachMoveUpdate();\n            if (typeof base.options.afterInit === \"function\") {\n                base.options.afterInit.apply(this, [base.$elem]);\n            }\n        },\n\n        eachMoveUpdate : function () {\n            var base = this;\n\n            if (base.options.lazyLoad === true) {\n                base.lazyLoad();\n            }\n            if (base.options.autoHeight === true) {\n                base.autoHeight();\n            }\n            base.onVisibleItems();\n\n            if (typeof base.options.afterAction === \"function\") {\n                base.options.afterAction.apply(this, [base.$elem]);\n            }\n        },\n\n        updateVars : function () {\n            var base = this;\n            if (typeof base.options.beforeUpdate === \"function\") {\n                base.options.beforeUpdate.apply(this, [base.$elem]);\n            }\n            base.watchVisibility();\n            base.updateItems();\n            base.calculateAll();\n            base.updatePosition();\n            base.updateControls();\n            base.eachMoveUpdate();\n            if (typeof base.options.afterUpdate === \"function\") {\n                base.options.afterUpdate.apply(this, [base.$elem]);\n            }\n        },\n\n        reload : function () {\n            var base = this;\n            window.setTimeout(function () {\n                base.updateVars();\n            }, 0);\n        },\n\n        watchVisibility : function () {\n            var base = this;\n\n            if (base.$elem.is(\":visible\") === false) {\n                base.$elem.css({opacity: 0});\n                window.clearInterval(base.autoPlayInterval);\n                window.clearInterval(base.checkVisible);\n            } else {\n                return false;\n            }\n            base.checkVisible = window.setInterval(function () {\n                if (base.$elem.is(\":visible\")) {\n                    base.reload();\n                    base.$elem.animate({opacity: 1}, 200);\n                    window.clearInterval(base.checkVisible);\n                }\n            }, 500);\n        },\n\n        wrapItems : function () {\n            var base = this;\n            base.$userItems.wrapAll(\"<div class=\\\"owl-wrapper\\\">\").wrap(\"<div class=\\\"owl-item\\\"></div>\");\n            base.$elem.find(\".owl-wrapper\").wrap(\"<div class=\\\"owl-wrapper-outer\\\">\");\n            base.wrapperOuter = base.$elem.find(\".owl-wrapper-outer\");\n            base.$elem.css(\"display\", \"block\");\n        },\n\n        baseClass : function () {\n            var base = this,\n                hasBaseClass = base.$elem.hasClass(base.options.baseClass),\n                hasThemeClass = base.$elem.hasClass(base.options.theme);\n\n            if (!hasBaseClass) {\n                base.$elem.addClass(base.options.baseClass);\n            }\n\n            if (!hasThemeClass) {\n                base.$elem.addClass(base.options.theme);\n            }\n        },\n\n        updateItems : function () {\n            var base = this, width, i;\n\n            if (base.options.responsive === false) {\n                return false;\n            }\n            if (base.options.singleItem === true) {\n                base.options.items = base.orignalItems = 1;\n                base.options.itemsCustom = false;\n                base.options.itemsDesktop = false;\n                base.options.itemsDesktopSmall = false;\n                base.options.itemsTablet = false;\n                base.options.itemsTabletSmall = false;\n                base.options.itemsMobile = false;\n                return false;\n            }\n\n            width = $(base.options.responsiveBaseWidth).width();\n\n            if (width > (base.options.itemsDesktop[0] || base.orignalItems)) {\n                base.options.items = base.orignalItems;\n            }\n            if (base.options.itemsCustom !== false) {\n                //Reorder array by screen size\n                base.options.itemsCustom.sort(function (a, b) {return a[0] - b[0]; });\n\n                for (i = 0; i < base.options.itemsCustom.length; i += 1) {\n                    if (base.options.itemsCustom[i][0] <= width) {\n                        base.options.items = base.options.itemsCustom[i][1];\n                    }\n                }\n\n            } else {\n\n                if (width <= base.options.itemsDesktop[0] && base.options.itemsDesktop !== false) {\n                    base.options.items = base.options.itemsDesktop[1];\n                }\n\n                if (width <= base.options.itemsDesktopSmall[0] && base.options.itemsDesktopSmall !== false) {\n                    base.options.items = base.options.itemsDesktopSmall[1];\n                }\n\n                if (width <= base.options.itemsTablet[0] && base.options.itemsTablet !== false) {\n                    base.options.items = base.options.itemsTablet[1];\n                }\n\n                if (width <= base.options.itemsTabletSmall[0] && base.options.itemsTabletSmall !== false) {\n                    base.options.items = base.options.itemsTabletSmall[1];\n                }\n\n                if (width <= base.options.itemsMobile[0] && base.options.itemsMobile !== false) {\n                    base.options.items = base.options.itemsMobile[1];\n                }\n            }\n\n            //if number of items is less than declared\n            if (base.options.items > base.itemsAmount && base.options.itemsScaleUp === true) {\n                base.options.items = base.itemsAmount;\n            }\n        },\n\n        response : function () {\n            var base = this,\n                smallDelay,\n                lastWindowWidth;\n\n            if (base.options.responsive !== true) {\n                return false;\n            }\n            lastWindowWidth = $(window).width();\n\n            base.resizer = function () {\n                if ($(window).width() !== lastWindowWidth) {\n                    if (base.options.autoPlay !== false) {\n                        window.clearInterval(base.autoPlayInterval);\n                    }\n                    window.clearTimeout(smallDelay);\n                    smallDelay = window.setTimeout(function () {\n                        lastWindowWidth = $(window).width();\n                        base.updateVars();\n                    }, base.options.responsiveRefreshRate);\n                }\n            };\n            $(window).resize(base.resizer);\n        },\n\n        updatePosition : function () {\n            var base = this;\n            base.jumpTo(base.currentItem);\n            if (base.options.autoPlay !== false) {\n                base.checkAp();\n            }\n        },\n\n        appendItemsSizes : function () {\n            var base = this,\n                roundPages = 0,\n                lastItem = base.itemsAmount - base.options.items;\n\n            base.$owlItems.each(function (index) {\n                var $this = $(this);\n                $this\n                    .css({\"width\": base.itemWidth})\n                    .data(\"owl-item\", Number(index));\n\n                if (index % base.options.items === 0 || index === lastItem) {\n                    if (!(index > lastItem)) {\n                        roundPages += 1;\n                    }\n                }\n                $this.data(\"owl-roundPages\", roundPages);\n            });\n        },\n\n        appendWrapperSizes : function () {\n            var base = this,\n                width = base.$owlItems.length * base.itemWidth;\n\n            base.$owlWrapper.css({\n                \"width\": width * 2,\n                \"left\": 0\n            });\n            base.appendItemsSizes();\n        },\n\n        calculateAll : function () {\n            var base = this;\n            base.calculateWidth();\n            base.appendWrapperSizes();\n            base.loops();\n            base.max();\n        },\n\n        calculateWidth : function () {\n            var base = this;\n            base.itemWidth = Math.round(base.$elem.width() / base.options.items);\n        },\n\n        max : function () {\n            var base = this,\n                maximum = ((base.itemsAmount * base.itemWidth) - base.options.items * base.itemWidth) * -1;\n            if (base.options.items > base.itemsAmount) {\n                base.maximumItem = 0;\n                maximum = 0;\n                base.maximumPixels = 0;\n            } else {\n                base.maximumItem = base.itemsAmount - base.options.items;\n                base.maximumPixels = maximum;\n            }\n            return maximum;\n        },\n\n        min : function () {\n            return 0;\n        },\n\n        loops : function () {\n            var base = this,\n                prev = 0,\n                elWidth = 0,\n                i,\n                item,\n                roundPageNum;\n\n            base.positionsInArray = [0];\n            base.pagesInArray = [];\n\n            for (i = 0; i < base.itemsAmount; i += 1) {\n                elWidth += base.itemWidth;\n                base.positionsInArray.push(-elWidth);\n\n                if (base.options.scrollPerPage === true) {\n                    item = $(base.$owlItems[i]);\n                    roundPageNum = item.data(\"owl-roundPages\");\n                    if (roundPageNum !== prev) {\n                        base.pagesInArray[prev] = base.positionsInArray[i];\n                        prev = roundPageNum;\n                    }\n                }\n            }\n        },\n\n        buildControls : function () {\n            var base = this;\n            if (base.options.navigation === true || base.options.pagination === true) {\n                base.owlControls = $(\"<div class=\\\"owl-controls\\\"/>\").toggleClass(\"clickable\", !base.browser.isTouch).appendTo(base.$elem);\n            }\n            if (base.options.pagination === true) {\n                base.buildPagination();\n            }\n            if (base.options.navigation === true) {\n                base.buildButtons();\n            }\n        },\n\n        buildButtons : function () {\n            var base = this,\n                buttonsWrapper = $(\"<div class=\\\"owl-buttons\\\"/>\");\n            base.owlControls.append(buttonsWrapper);\n\n            base.buttonPrev = $(\"<div/>\", {\n                \"class\" : \"owl-prev\",\n                \"html\" : base.options.navigationText[0] || \"\"\n            });\n\n            base.buttonNext = $(\"<div/>\", {\n                \"class\" : \"owl-next\",\n                \"html\" : base.options.navigationText[1] || \"\"\n            });\n\n            buttonsWrapper\n                .append(base.buttonPrev)\n                .append(base.buttonNext);\n\n            buttonsWrapper.on(\"touchstart.owlControls mousedown.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n                event.preventDefault();\n            });\n\n            buttonsWrapper.on(\"touchend.owlControls mouseup.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n                event.preventDefault();\n                if ($(this).hasClass(\"owl-next\")) {\n                    base.next();\n                } else {\n                    base.prev();\n                }\n            });\n        },\n\n        buildPagination : function () {\n            var base = this;\n\n            base.paginationWrapper = $(\"<div class=\\\"owl-pagination\\\"/>\");\n            base.owlControls.append(base.paginationWrapper);\n\n            base.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\", \".owl-page\", function (event) {\n                event.preventDefault();\n                if (Number($(this).data(\"owl-page\")) !== base.currentItem) {\n                    base.goTo(Number($(this).data(\"owl-page\")), true);\n                }\n            });\n        },\n\n        updatePagination : function () {\n            var base = this,\n                counter,\n                lastPage,\n                lastItem,\n                i,\n                paginationButton,\n                paginationButtonInner;\n\n            if (base.options.pagination === false) {\n                return false;\n            }\n\n            base.paginationWrapper.html(\"\");\n\n            counter = 0;\n            lastPage = base.itemsAmount - base.itemsAmount % base.options.items;\n\n            for (i = 0; i < base.itemsAmount; i += 1) {\n                if (i % base.options.items === 0) {\n                    counter += 1;\n                    if (lastPage === i) {\n                        lastItem = base.itemsAmount - base.options.items;\n                    }\n                    paginationButton = $(\"<div/>\", {\n                        \"class\" : \"owl-page\"\n                    });\n                    paginationButtonInner = $(\"<span></span>\", {\n                        \"text\": base.options.paginationNumbers === true ? counter : \"\",\n                        \"class\": base.options.paginationNumbers === true ? \"owl-numbers\" : \"\"\n                    });\n                    paginationButton.append(paginationButtonInner);\n\n                    paginationButton.data(\"owl-page\", lastPage === i ? lastItem : i);\n                    paginationButton.data(\"owl-roundPages\", counter);\n\n                    base.paginationWrapper.append(paginationButton);\n                }\n            }\n            base.checkPagination();\n        },\n        checkPagination : function () {\n            var base = this;\n            if (base.options.pagination === false) {\n                return false;\n            }\n            base.paginationWrapper.find(\".owl-page\").each(function () {\n                if ($(this).data(\"owl-roundPages\") === $(base.$owlItems[base.currentItem]).data(\"owl-roundPages\")) {\n                    base.paginationWrapper\n                        .find(\".owl-page\")\n                        .removeClass(\"active\");\n                    $(this).addClass(\"active\");\n                }\n            });\n        },\n\n        checkNavigation : function () {\n            var base = this;\n\n            if (base.options.navigation === false) {\n                return false;\n            }\n            if (base.options.rewindNav === false) {\n                if (base.currentItem === 0 && base.maximumItem === 0) {\n                    base.buttonPrev.addClass(\"disabled\");\n                    base.buttonNext.addClass(\"disabled\");\n                } else if (base.currentItem === 0 && base.maximumItem !== 0) {\n                    base.buttonPrev.addClass(\"disabled\");\n                    base.buttonNext.removeClass(\"disabled\");\n                } else if (base.currentItem === base.maximumItem) {\n                    base.buttonPrev.removeClass(\"disabled\");\n                    base.buttonNext.addClass(\"disabled\");\n                } else if (base.currentItem !== 0 && base.currentItem !== base.maximumItem) {\n                    base.buttonPrev.removeClass(\"disabled\");\n                    base.buttonNext.removeClass(\"disabled\");\n                }\n            }\n        },\n\n        updateControls : function () {\n            var base = this;\n            base.updatePagination();\n            base.checkNavigation();\n            if (base.owlControls) {\n                if (base.options.items >= base.itemsAmount) {\n                    base.owlControls.hide();\n                } else {\n                    base.owlControls.show();\n                }\n            }\n        },\n\n        destroyControls : function () {\n            var base = this;\n            if (base.owlControls) {\n                base.owlControls.remove();\n            }\n        },\n\n        next : function (speed) {\n            var base = this;\n\n            if (base.isTransition) {\n                return false;\n            }\n\n            base.currentItem += base.options.scrollPerPage === true ? base.options.items : 1;\n            if (base.currentItem > base.maximumItem + (base.options.scrollPerPage === true ? (base.options.items - 1) : 0)) {\n                if (base.options.rewindNav === true) {\n                    base.currentItem = 0;\n                    speed = \"rewind\";\n                } else {\n                    base.currentItem = base.maximumItem;\n                    return false;\n                }\n            }\n            base.goTo(base.currentItem, speed);\n        },\n\n        prev : function (speed) {\n            var base = this;\n\n            if (base.isTransition) {\n                return false;\n            }\n\n            if (base.options.scrollPerPage === true && base.currentItem > 0 && base.currentItem < base.options.items) {\n                base.currentItem = 0;\n            } else {\n                base.currentItem -= base.options.scrollPerPage === true ? base.options.items : 1;\n            }\n            if (base.currentItem < 0) {\n                if (base.options.rewindNav === true) {\n                    base.currentItem = base.maximumItem;\n                    speed = \"rewind\";\n                } else {\n                    base.currentItem = 0;\n                    return false;\n                }\n            }\n            base.goTo(base.currentItem, speed);\n        },\n\n        goTo : function (position, speed, drag) {\n            var base = this,\n                goToPixel;\n\n            if (base.isTransition) {\n                return false;\n            }\n            if (typeof base.options.beforeMove === \"function\") {\n                base.options.beforeMove.apply(this, [base.$elem]);\n            }\n            if (position >= base.maximumItem) {\n                position = base.maximumItem;\n            } else if (position <= 0) {\n                position = 0;\n            }\n\n            base.currentItem = base.owl.currentItem = position;\n            if (base.options.transitionStyle !== false && drag !== \"drag\" && base.options.items === 1 && base.browser.support3d === true) {\n                base.swapSpeed(0);\n                if (base.browser.support3d === true) {\n                    base.transition3d(base.positionsInArray[position]);\n                } else {\n                    base.css2slide(base.positionsInArray[position], 1);\n                }\n                base.afterGo();\n                base.singleItemTransition();\n                return false;\n            }\n            goToPixel = base.positionsInArray[position];\n\n            if (base.browser.support3d === true) {\n                base.isCss3Finish = false;\n\n                if (speed === true) {\n                    base.swapSpeed(\"paginationSpeed\");\n                    window.setTimeout(function () {\n                        base.isCss3Finish = true;\n                    }, base.options.paginationSpeed);\n\n                } else if (speed === \"rewind\") {\n                    base.swapSpeed(base.options.rewindSpeed);\n                    window.setTimeout(function () {\n                        base.isCss3Finish = true;\n                    }, base.options.rewindSpeed);\n\n                } else {\n                    base.swapSpeed(\"slideSpeed\");\n                    window.setTimeout(function () {\n                        base.isCss3Finish = true;\n                    }, base.options.slideSpeed);\n                }\n                base.transition3d(goToPixel);\n            } else {\n                if (speed === true) {\n                    base.css2slide(goToPixel, base.options.paginationSpeed);\n                } else if (speed === \"rewind\") {\n                    base.css2slide(goToPixel, base.options.rewindSpeed);\n                } else {\n                    base.css2slide(goToPixel, base.options.slideSpeed);\n                }\n            }\n            base.afterGo();\n        },\n\n        jumpTo : function (position) {\n            var base = this;\n            if (typeof base.options.beforeMove === \"function\") {\n                base.options.beforeMove.apply(this, [base.$elem]);\n            }\n            if (position >= base.maximumItem || position === -1) {\n                position = base.maximumItem;\n            } else if (position <= 0) {\n                position = 0;\n            }\n            base.swapSpeed(0);\n            if (base.browser.support3d === true) {\n                base.transition3d(base.positionsInArray[position]);\n            } else {\n                base.css2slide(base.positionsInArray[position], 1);\n            }\n            base.currentItem = base.owl.currentItem = position;\n            base.afterGo();\n        },\n\n        afterGo : function () {\n            var base = this;\n\n            base.prevArr.push(base.currentItem);\n            base.prevItem = base.owl.prevItem = base.prevArr[base.prevArr.length - 2];\n            base.prevArr.shift(0);\n\n            if (base.prevItem !== base.currentItem) {\n                base.checkPagination();\n                base.checkNavigation();\n                base.eachMoveUpdate();\n\n                if (base.options.autoPlay !== false) {\n                    base.checkAp();\n                }\n            }\n            if (typeof base.options.afterMove === \"function\" && base.prevItem !== base.currentItem) {\n                base.options.afterMove.apply(this, [base.$elem]);\n            }\n        },\n\n        stop : function () {\n            var base = this;\n            base.apStatus = \"stop\";\n            window.clearInterval(base.autoPlayInterval);\n        },\n\n        checkAp : function () {\n            var base = this;\n            if (base.apStatus !== \"stop\") {\n                base.play();\n            }\n        },\n\n        play : function () {\n            var base = this;\n            base.apStatus = \"play\";\n            if (base.options.autoPlay === false) {\n                return false;\n            }\n            window.clearInterval(base.autoPlayInterval);\n            base.autoPlayInterval = window.setInterval(function () {\n                base.next(true);\n            }, base.options.autoPlay);\n        },\n\n        swapSpeed : function (action) {\n            var base = this;\n            if (action === \"slideSpeed\") {\n                base.$owlWrapper.css(base.addCssSpeed(base.options.slideSpeed));\n            } else if (action === \"paginationSpeed\") {\n                base.$owlWrapper.css(base.addCssSpeed(base.options.paginationSpeed));\n            } else if (typeof action !== \"string\") {\n                base.$owlWrapper.css(base.addCssSpeed(action));\n            }\n        },\n\n        addCssSpeed : function (speed) {\n            return {\n                \"-webkit-transition\": \"all \" + speed + \"ms ease\",\n                \"-moz-transition\": \"all \" + speed + \"ms ease\",\n                \"-o-transition\": \"all \" + speed + \"ms ease\",\n                \"transition\": \"all \" + speed + \"ms ease\"\n            };\n        },\n\n        removeTransition : function () {\n            return {\n                \"-webkit-transition\": \"\",\n                \"-moz-transition\": \"\",\n                \"-o-transition\": \"\",\n                \"transition\": \"\"\n            };\n        },\n\n        doTranslate : function (pixels) {\n            return {\n                \"-webkit-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                \"-moz-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                \"-o-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                \"-ms-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                \"transform\": \"translate3d(\" + pixels + \"px, 0px,0px)\"\n            };\n        },\n\n        transition3d : function (value) {\n            var base = this;\n            base.$owlWrapper.css(base.doTranslate(value));\n        },\n\n        css2move : function (value) {\n            var base = this;\n            base.$owlWrapper.css({\"left\" : value});\n        },\n\n        css2slide : function (value, speed) {\n            var base = this;\n\n            base.isCssFinish = false;\n            base.$owlWrapper.stop(true, true).animate({\n                \"left\" : value\n            }, {\n                duration : speed || base.options.slideSpeed,\n                complete : function () {\n                    base.isCssFinish = true;\n                }\n            });\n        },\n\n        checkBrowser : function () {\n            var base = this,\n                translate3D = \"translate3d(0px, 0px, 0px)\",\n                tempElem = document.createElement(\"div\"),\n                regex,\n                asSupport,\n                support3d,\n                isTouch;\n\n            tempElem.style.cssText = \"  -moz-transform:\" + translate3D +\n                                  \"; -ms-transform:\"     + translate3D +\n                                  \"; -o-transform:\"      + translate3D +\n                                  \"; -webkit-transform:\" + translate3D +\n                                  \"; transform:\"         + translate3D;\n            regex = /translate3d\\(0px, 0px, 0px\\)/g;\n            asSupport = tempElem.style.cssText.match(regex);\n            support3d = (asSupport !== null && asSupport.length === 1);\n\n            isTouch = \"ontouchstart\" in window || window.navigator.msMaxTouchPoints;\n\n            base.browser = {\n                \"support3d\" : support3d,\n                \"isTouch\" : isTouch\n            };\n        },\n\n        moveEvents : function () {\n            var base = this;\n            if (base.options.mouseDrag !== false || base.options.touchDrag !== false) {\n                base.gestures();\n                base.disabledEvents();\n            }\n        },\n\n        eventTypes : function () {\n            var base = this,\n                types = [\"s\", \"e\", \"x\"];\n\n            base.ev_types = {};\n\n            if (base.options.mouseDrag === true && base.options.touchDrag === true) {\n                types = [\n                    \"touchstart.owl mousedown.owl\",\n                    \"touchmove.owl mousemove.owl\",\n                    \"touchend.owl touchcancel.owl mouseup.owl\"\n                ];\n            } else if (base.options.mouseDrag === false && base.options.touchDrag === true) {\n                types = [\n                    \"touchstart.owl\",\n                    \"touchmove.owl\",\n                    \"touchend.owl touchcancel.owl\"\n                ];\n            } else if (base.options.mouseDrag === true && base.options.touchDrag === false) {\n                types = [\n                    \"mousedown.owl\",\n                    \"mousemove.owl\",\n                    \"mouseup.owl\"\n                ];\n            }\n\n            base.ev_types.start = types[0];\n            base.ev_types.move = types[1];\n            base.ev_types.end = types[2];\n        },\n\n        disabledEvents :  function () {\n            var base = this;\n            base.$elem.on(\"dragstart.owl\", function (event) { event.preventDefault(); });\n            base.$elem.on(\"mousedown.disableTextSelect\", function (e) {\n                return $(e.target).is('input, textarea, select, option');\n            });\n        },\n\n        gestures : function () {\n            /*jslint unparam: true*/\n            var base = this,\n                locals = {\n                    offsetX : 0,\n                    offsetY : 0,\n                    baseElWidth : 0,\n                    relativePos : 0,\n                    position: null,\n                    minSwipe : null,\n                    maxSwipe: null,\n                    sliding : null,\n                    dargging: null,\n                    targetElement : null\n                };\n\n            base.isCssFinish = true;\n\n            function getTouches(event) {\n                if (event.touches !== undefined) {\n                    return {\n                        x : event.touches[0].pageX,\n                        y : event.touches[0].pageY\n                    };\n                }\n\n                if (event.touches === undefined) {\n                    if (event.pageX !== undefined) {\n                        return {\n                            x : event.pageX,\n                            y : event.pageY\n                        };\n                    }\n                    if (event.pageX === undefined) {\n                        return {\n                            x : event.clientX,\n                            y : event.clientY\n                        };\n                    }\n                }\n            }\n\n            function swapEvents(type) {\n                if (type === \"on\") {\n                    $(document).on(base.ev_types.move, dragMove);\n                    $(document).on(base.ev_types.end, dragEnd);\n                } else if (type === \"off\") {\n                    $(document).off(base.ev_types.move);\n                    $(document).off(base.ev_types.end);\n                }\n            }\n\n            function dragStart(event) {\n                var ev = event.originalEvent || event || window.event,\n                    position;\n\n                if (ev.which === 3) {\n                    return false;\n                }\n                if (base.itemsAmount <= base.options.items) {\n                    return;\n                }\n                if (base.isCssFinish === false && !base.options.dragBeforeAnimFinish) {\n                    return false;\n                }\n                if (base.isCss3Finish === false && !base.options.dragBeforeAnimFinish) {\n                    return false;\n                }\n\n                if (base.options.autoPlay !== false) {\n                    window.clearInterval(base.autoPlayInterval);\n                }\n\n                if (base.browser.isTouch !== true && !base.$owlWrapper.hasClass(\"grabbing\")) {\n                    base.$owlWrapper.addClass(\"grabbing\");\n                }\n\n                base.newPosX = 0;\n                base.newRelativeX = 0;\n\n                $(this).css(base.removeTransition());\n\n                position = $(this).position();\n                locals.relativePos = position.left;\n\n                locals.offsetX = getTouches(ev).x - position.left;\n                locals.offsetY = getTouches(ev).y - position.top;\n\n                swapEvents(\"on\");\n\n                locals.sliding = false;\n                locals.targetElement = ev.target || ev.srcElement;\n            }\n\n            function dragMove(event) {\n                var ev = event.originalEvent || event || window.event,\n                    minSwipe,\n                    maxSwipe;\n\n                base.newPosX = getTouches(ev).x - locals.offsetX;\n                base.newPosY = getTouches(ev).y - locals.offsetY;\n                base.newRelativeX = base.newPosX - locals.relativePos;\n\n                if (typeof base.options.startDragging === \"function\" && locals.dragging !== true && base.newRelativeX !== 0) {\n                    locals.dragging = true;\n                    base.options.startDragging.apply(base, [base.$elem]);\n                }\n\n                if ((base.newRelativeX > 8 || base.newRelativeX < -8) && (base.browser.isTouch === true)) {\n                    if (ev.preventDefault !== undefined) {\n                        ev.preventDefault();\n                    } else {\n                        ev.returnValue = false;\n                    }\n                    locals.sliding = true;\n                }\n\n                if ((base.newPosY > 10 || base.newPosY < -10) && locals.sliding === false) {\n                    $(document).off(\"touchmove.owl\");\n                }\n\n                minSwipe = function () {\n                    return base.newRelativeX / 5;\n                };\n\n                maxSwipe = function () {\n                    return base.maximumPixels + base.newRelativeX / 5;\n                };\n\n                base.newPosX = Math.max(Math.min(base.newPosX, minSwipe()), maxSwipe());\n                if (base.browser.support3d === true) {\n                    base.transition3d(base.newPosX);\n                } else {\n                    base.css2move(base.newPosX);\n                }\n            }\n\n            function dragEnd(event) {\n                var ev = event.originalEvent || event || window.event,\n                    newPosition,\n                    handlers,\n                    owlStopEvent;\n\n                ev.target = ev.target || ev.srcElement;\n\n                locals.dragging = false;\n\n                if (base.browser.isTouch !== true) {\n                    base.$owlWrapper.removeClass(\"grabbing\");\n                }\n\n                if (base.newRelativeX < 0) {\n                    base.dragDirection = base.owl.dragDirection = \"left\";\n                } else {\n                    base.dragDirection = base.owl.dragDirection = \"right\";\n                }\n\n                if (base.newRelativeX !== 0) {\n                    newPosition = base.getNewPosition();\n                    base.goTo(newPosition, false, \"drag\");\n                    if (locals.targetElement === ev.target && base.browser.isTouch !== true) {\n                        $(ev.target).on(\"click.disable\", function (ev) {\n                            ev.stopImmediatePropagation();\n                            ev.stopPropagation();\n                            ev.preventDefault();\n                            $(ev.target).off(\"click.disable\");\n                        });\n                        handlers = $._data(ev.target, \"events\").click;\n                        owlStopEvent = handlers.pop();\n                        handlers.splice(0, 0, owlStopEvent);\n                    }\n                }\n                swapEvents(\"off\");\n            }\n            base.$elem.on(base.ev_types.start, \".owl-wrapper\", dragStart);\n        },\n\n        getNewPosition : function () {\n            var base = this,\n                newPosition = base.closestItem();\n\n            if (newPosition > base.maximumItem) {\n                base.currentItem = base.maximumItem;\n                newPosition  = base.maximumItem;\n            } else if (base.newPosX >= 0) {\n                newPosition = 0;\n                base.currentItem = 0;\n            }\n            return newPosition;\n        },\n        closestItem : function () {\n            var base = this,\n                array = base.options.scrollPerPage === true ? base.pagesInArray : base.positionsInArray,\n                goal = base.newPosX,\n                closest = null;\n\n            $.each(array, function (i, v) {\n                if (goal - (base.itemWidth / 20) > array[i + 1] && goal - (base.itemWidth / 20) < v && base.moveDirection() === \"left\") {\n                    closest = v;\n                    if (base.options.scrollPerPage === true) {\n                        base.currentItem = $.inArray(closest, base.positionsInArray);\n                    } else {\n                        base.currentItem = i;\n                    }\n                } else if (goal + (base.itemWidth / 20) < v && goal + (base.itemWidth / 20) > (array[i + 1] || array[i] - base.itemWidth) && base.moveDirection() === \"right\") {\n                    if (base.options.scrollPerPage === true) {\n                        closest = array[i + 1] || array[array.length - 1];\n                        base.currentItem = $.inArray(closest, base.positionsInArray);\n                    } else {\n                        closest = array[i + 1];\n                        base.currentItem = i + 1;\n                    }\n                }\n            });\n            return base.currentItem;\n        },\n\n        moveDirection : function () {\n            var base = this,\n                direction;\n            if (base.newRelativeX < 0) {\n                direction = \"right\";\n                base.playDirection = \"next\";\n            } else {\n                direction = \"left\";\n                base.playDirection = \"prev\";\n            }\n            return direction;\n        },\n\n        customEvents : function () {\n            /*jslint unparam: true*/\n            var base = this;\n            base.$elem.on(\"owl.next\", function () {\n                base.next();\n            });\n            base.$elem.on(\"owl.prev\", function () {\n                base.prev();\n            });\n            base.$elem.on(\"owl.play\", function (event, speed) {\n                base.options.autoPlay = speed;\n                base.play();\n                base.hoverStatus = \"play\";\n            });\n            base.$elem.on(\"owl.stop\", function () {\n                base.stop();\n                base.hoverStatus = \"stop\";\n            });\n            base.$elem.on(\"owl.goTo\", function (event, item) {\n                base.goTo(item);\n            });\n            base.$elem.on(\"owl.jumpTo\", function (event, item) {\n                base.jumpTo(item);\n            });\n        },\n\n        stopOnHover : function () {\n            var base = this;\n            if (base.options.stopOnHover === true && base.browser.isTouch !== true && base.options.autoPlay !== false) {\n                base.$elem.on(\"mouseover\", function () {\n                    base.stop();\n                });\n                base.$elem.on(\"mouseout\", function () {\n                    if (base.hoverStatus !== \"stop\") {\n                        base.play();\n                    }\n                });\n            }\n        },\n\n        lazyLoad : function () {\n            var base = this,\n                i,\n                $item,\n                itemNumber,\n                $lazyImg,\n                follow;\n\n            if (base.options.lazyLoad === false) {\n                return false;\n            }\n            for (i = 0; i < base.itemsAmount; i += 1) {\n                $item = $(base.$owlItems[i]);\n\n                if ($item.data(\"owl-loaded\") === \"loaded\") {\n                    continue;\n                }\n\n                itemNumber = $item.data(\"owl-item\");\n                $lazyImg = $item.find(\".lazyOwl\");\n\n                if (typeof $lazyImg.data(\"src\") !== \"string\") {\n                    $item.data(\"owl-loaded\", \"loaded\");\n                    continue;\n                }\n                if ($item.data(\"owl-loaded\") === undefined) {\n                    $lazyImg.hide();\n                    $item.addClass(\"loading\").data(\"owl-loaded\", \"checked\");\n                }\n                if (base.options.lazyFollow === true) {\n                    follow = itemNumber >= base.currentItem;\n                } else {\n                    follow = true;\n                }\n                if (follow && itemNumber < base.currentItem + base.options.items && $lazyImg.length) {\n                    base.lazyPreload($item, $lazyImg);\n                }\n            }\n        },\n\n        lazyPreload : function ($item, $lazyImg) {\n            var base = this,\n                iterations = 0,\n                isBackgroundImg;\n\n            if ($lazyImg.prop(\"tagName\") === \"DIV\") {\n                $lazyImg.css(\"background-image\", \"url(\" + $lazyImg.data(\"src\") + \")\");\n                isBackgroundImg = true;\n            } else {\n                $lazyImg[0].src = $lazyImg.data(\"src\");\n            }\n\n            function showImage() {\n                $item.data(\"owl-loaded\", \"loaded\").removeClass(\"loading\");\n                $lazyImg.removeAttr(\"data-src\");\n                if (base.options.lazyEffect === \"fade\") {\n                    $lazyImg.fadeIn(400);\n                } else {\n                    $lazyImg.show();\n                }\n                if (typeof base.options.afterLazyLoad === \"function\") {\n                    base.options.afterLazyLoad.apply(this, [base.$elem]);\n                }\n            }\n\n            function checkLazyImage() {\n                iterations += 1;\n                if (base.completeImg($lazyImg.get(0)) || isBackgroundImg === true) {\n                    showImage();\n                } else if (iterations <= 100) {//if image loads in less than 10 seconds \n                    window.setTimeout(checkLazyImage, 100);\n                } else {\n                    showImage();\n                }\n            }\n\n            checkLazyImage();\n        },\n\n        autoHeight : function () {\n            var base = this,\n                $currentimg = $(base.$owlItems[base.currentItem]).find(\"img\"),\n                iterations;\n\n            function addHeight() {\n                var $currentItem = $(base.$owlItems[base.currentItem]).height();\n                base.wrapperOuter.css(\"height\", $currentItem + \"px\");\n                if (!base.wrapperOuter.hasClass(\"autoHeight\")) {\n                    window.setTimeout(function () {\n                        base.wrapperOuter.addClass(\"autoHeight\");\n                    }, 0);\n                }\n            }\n\n            function checkImage() {\n                iterations += 1;\n                if (base.completeImg($currentimg.get(0))) {\n                    addHeight();\n                } else if (iterations <= 100) { //if image loads in less than 10 seconds \n                    window.setTimeout(checkImage, 100);\n                } else {\n                    base.wrapperOuter.css(\"height\", \"\"); //Else remove height attribute\n                }\n            }\n\n            if ($currentimg.get(0) !== undefined) {\n                iterations = 0;\n                checkImage();\n            } else {\n                addHeight();\n            }\n        },\n\n        completeImg : function (img) {\n            var naturalWidthType;\n\n            if (!img.complete) {\n                return false;\n            }\n            naturalWidthType = typeof img.naturalWidth;\n            if (naturalWidthType !== \"undefined\" && img.naturalWidth === 0) {\n                return false;\n            }\n            return true;\n        },\n\n        onVisibleItems : function () {\n            var base = this,\n                i;\n\n            if (base.options.addClassActive === true) {\n                base.$owlItems.removeClass(\"active\");\n            }\n            base.visibleItems = [];\n            for (i = base.currentItem; i < base.currentItem + base.options.items; i += 1) {\n                base.visibleItems.push(i);\n\n                if (base.options.addClassActive === true) {\n                    $(base.$owlItems[i]).addClass(\"active\");\n                }\n            }\n            base.owl.visibleItems = base.visibleItems;\n        },\n\n        transitionTypes : function (className) {\n            var base = this;\n            //Currently available: \"fade\", \"backSlide\", \"goDown\", \"fadeUp\"\n            base.outClass = \"owl-\" + className + \"-out\";\n            base.inClass = \"owl-\" + className + \"-in\";\n        },\n\n        singleItemTransition : function () {\n            var base = this,\n                outClass = base.outClass,\n                inClass = base.inClass,\n                $currentItem = base.$owlItems.eq(base.currentItem),\n                $prevItem = base.$owlItems.eq(base.prevItem),\n                prevPos = Math.abs(base.positionsInArray[base.currentItem]) + base.positionsInArray[base.prevItem],\n                origin = Math.abs(base.positionsInArray[base.currentItem]) + base.itemWidth / 2,\n                animEnd = 'webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend';\n\n            base.isTransition = true;\n\n            base.$owlWrapper\n                .addClass('owl-origin')\n                .css({\n                    \"-webkit-transform-origin\" : origin + \"px\",\n                    \"-moz-perspective-origin\" : origin + \"px\",\n                    \"perspective-origin\" : origin + \"px\"\n                });\n            function transStyles(prevPos) {\n                return {\n                    \"position\" : \"relative\",\n                    \"left\" : prevPos + \"px\"\n                };\n            }\n\n            $prevItem\n                .css(transStyles(prevPos, 10))\n                .addClass(outClass)\n                .on(animEnd, function () {\n                    base.endPrev = true;\n                    $prevItem.off(animEnd);\n                    base.clearTransStyle($prevItem, outClass);\n                });\n\n            $currentItem\n                .addClass(inClass)\n                .on(animEnd, function () {\n                    base.endCurrent = true;\n                    $currentItem.off(animEnd);\n                    base.clearTransStyle($currentItem, inClass);\n                });\n        },\n\n        clearTransStyle : function (item, classToRemove) {\n            var base = this;\n            item.css({\n                \"position\" : \"\",\n                \"left\" : \"\"\n            }).removeClass(classToRemove);\n\n            if (base.endPrev && base.endCurrent) {\n                base.$owlWrapper.removeClass('owl-origin');\n                base.endPrev = false;\n                base.endCurrent = false;\n                base.isTransition = false;\n            }\n        },\n\n        owlStatus : function () {\n            var base = this;\n            base.owl = {\n                \"userOptions\"   : base.userOptions,\n                \"baseElement\"   : base.$elem,\n                \"userItems\"     : base.$userItems,\n                \"owlItems\"      : base.$owlItems,\n                \"currentItem\"   : base.currentItem,\n                \"prevItem\"      : base.prevItem,\n                \"visibleItems\"  : base.visibleItems,\n                \"isTouch\"       : base.browser.isTouch,\n                \"browser\"       : base.browser,\n                \"dragDirection\" : base.dragDirection\n            };\n        },\n\n        clearEvents : function () {\n            var base = this;\n            base.$elem.off(\".owl owl mousedown.disableTextSelect\");\n            $(document).off(\".owl owl\");\n            $(window).off(\"resize\", base.resizer);\n        },\n\n        unWrap : function () {\n            var base = this;\n            if (base.$elem.children().length !== 0) {\n                base.$owlWrapper.unwrap();\n                base.$userItems.unwrap().unwrap();\n                if (base.owlControls) {\n                    base.owlControls.remove();\n                }\n            }\n            base.clearEvents();\n            base.$elem\n                .attr(\"style\", base.$elem.data(\"owl-originalStyles\") || \"\")\n                .attr(\"class\", base.$elem.data(\"owl-originalClasses\"));\n        },\n\n        destroy : function () {\n            var base = this;\n            base.stop();\n            window.clearInterval(base.checkVisible);\n            base.unWrap();\n            base.$elem.removeData();\n        },\n\n        reinit : function (newOptions) {\n            var base = this,\n                options = $.extend({}, base.userOptions, newOptions);\n            base.unWrap();\n            base.init(options, base.$elem);\n        },\n\n        addItem : function (htmlString, targetPosition) {\n            var base = this,\n                position;\n\n            if (!htmlString) {return false; }\n\n            if (base.$elem.children().length === 0) {\n                base.$elem.append(htmlString);\n                base.setVars();\n                return false;\n            }\n            base.unWrap();\n            if (targetPosition === undefined || targetPosition === -1) {\n                position = -1;\n            } else {\n                position = targetPosition;\n            }\n            if (position >= base.$userItems.length || position === -1) {\n                base.$userItems.eq(-1).after(htmlString);\n            } else {\n                base.$userItems.eq(position).before(htmlString);\n            }\n\n            base.setVars();\n        },\n\n        removeItem : function (targetPosition) {\n            var base = this,\n                position;\n\n            if (base.$elem.children().length === 0) {\n                return false;\n            }\n            if (targetPosition === undefined || targetPosition === -1) {\n                position = -1;\n            } else {\n                position = targetPosition;\n            }\n\n            base.unWrap();\n            base.$userItems.eq(position).remove();\n            base.setVars();\n        }\n\n    };\n\n    $.fn.owlCarousel = function (options) {\n        return this.each(function () {\n            if ($(this).data(\"owl-init\") === true) {\n                return false;\n            }\n            $(this).data(\"owl-init\", true);\n            var carousel = Object.create(Carousel);\n            carousel.init(options, this);\n            $.data(this, \"owlCarousel\", carousel);\n        });\n    };\n\n    $.fn.owlCarousel.options = {\n\n        items : 5,\n        itemsCustom : false,\n        itemsDesktop : [1199, 4],\n        itemsDesktopSmall : [979, 3],\n        itemsTablet : [768, 2],\n        itemsTabletSmall : false,\n        itemsMobile : [479, 1],\n        singleItem : false,\n        itemsScaleUp : false,\n\n        slideSpeed : 200,\n        paginationSpeed : 800,\n        rewindSpeed : 1000,\n\n        autoPlay : false,\n        stopOnHover : false,\n\n        navigation : false,\n        navigationText : [\"prev\", \"next\"],\n        rewindNav : true,\n        scrollPerPage : false,\n\n        pagination : true,\n        paginationNumbers : false,\n\n        responsive : true,\n        responsiveRefreshRate : 200,\n        responsiveBaseWidth : window,\n\n        baseClass : \"owl-carousel\",\n        theme : \"owl-theme\",\n\n        lazyLoad : false,\n        lazyFollow : true,\n        lazyEffect : \"fade\",\n\n        autoHeight : false,\n\n        jsonPath : false,\n        jsonSuccess : false,\n\n        dragBeforeAnimFinish : true,\n        mouseDrag : true,\n        touchDrag : true,\n\n        addClassActive : false,\n        transitionStyle : false,\n\n        beforeUpdate : false,\n        afterUpdate : false,\n        beforeInit : false,\n        afterInit : false,\n        beforeMove : false,\n        afterMove : false,\n        afterAction : false,\n        startDragging : false,\n        afterLazyLoad: false\n    };\n}(jQuery, window, document));","Plazathemes_Loadjs/js/owl-carousel/owl.carousel.min.js":"\"function\"!=typeof Object.create&&(Object.create=function(t){function e(){}return e.prototype=t,new e}),function(t,e,o){var i={init:function(e,o){var i=this;i.$elem=t(o),i.options=t.extend({},t.fn.owlCarousel.options,i.$elem.data(),e),i.userOptions=e,i.loadContent()},loadContent:function(){function e(t){var e,o=\"\";if(\"function\"==typeof i.options.jsonSuccess)i.options.jsonSuccess.apply(this,[t]);else{for(e in t.owl)t.owl.hasOwnProperty(e)&&(o+=t.owl[e].item);i.$elem.html(o)}i.logIn()}var o,i=this;\"function\"==typeof i.options.beforeInit&&i.options.beforeInit.apply(this,[i.$elem]),\"string\"==typeof i.options.jsonPath?(o=i.options.jsonPath,t.getJSON(o,e)):i.logIn()},logIn:function(){var t=this;t.$elem.data({\"owl-originalStyles\":t.$elem.attr(\"style\"),\"owl-originalClasses\":t.$elem.attr(\"class\")}),t.$elem.css({opacity:0}),t.orignalItems=t.options.items,t.checkBrowser(),t.wrapperWidth=0,t.checkVisible=null,t.setVars()},setVars:function(){var t=this;return 0===t.$elem.children().length?!1:(t.baseClass(),t.eventTypes(),t.$userItems=t.$elem.children(),t.itemsAmount=t.$userItems.length,t.wrapItems(),t.$owlItems=t.$elem.find(\".owl-item\"),t.$owlWrapper=t.$elem.find(\".owl-wrapper\"),t.playDirection=\"next\",t.prevItem=0,t.prevArr=[0],t.currentItem=0,t.customEvents(),void t.onStartup())},onStartup:function(){var t=this;t.updateItems(),t.calculateAll(),t.buildControls(),t.updateControls(),t.response(),t.moveEvents(),t.stopOnHover(),t.owlStatus(),t.options.transitionStyle!==!1&&t.transitionTypes(t.options.transitionStyle),t.options.autoPlay===!0&&(t.options.autoPlay=5e3),t.play(),t.$elem.find(\".owl-wrapper\").css(\"display\",\"block\"),t.$elem.is(\":visible\")?t.$elem.css(\"opacity\",1):t.watchVisibility(),t.onstartup=!1,t.eachMoveUpdate(),\"function\"==typeof t.options.afterInit&&t.options.afterInit.apply(this,[t.$elem])},eachMoveUpdate:function(){var t=this;t.options.lazyLoad===!0&&t.lazyLoad(),t.options.autoHeight===!0&&t.autoHeight(),t.onVisibleItems(),\"function\"==typeof t.options.afterAction&&t.options.afterAction.apply(this,[t.$elem])},updateVars:function(){var t=this;\"function\"==typeof t.options.beforeUpdate&&t.options.beforeUpdate.apply(this,[t.$elem]),t.watchVisibility(),t.updateItems(),t.calculateAll(),t.updatePosition(),t.updateControls(),t.eachMoveUpdate(),\"function\"==typeof t.options.afterUpdate&&t.options.afterUpdate.apply(this,[t.$elem])},reload:function(){var t=this;e.setTimeout(function(){t.updateVars()},0)},watchVisibility:function(){var t=this;return t.$elem.is(\":visible\")!==!1?!1:(t.$elem.css({opacity:0}),e.clearInterval(t.autoPlayInterval),e.clearInterval(t.checkVisible),void(t.checkVisible=e.setInterval(function(){t.$elem.is(\":visible\")&&(t.reload(),t.$elem.animate({opacity:1},200),e.clearInterval(t.checkVisible))},500)))},wrapItems:function(){var t=this;t.$userItems.wrapAll('<div class=\"owl-wrapper\">').wrap('<div class=\"owl-item\"></div>'),t.$elem.find(\".owl-wrapper\").wrap('<div class=\"owl-wrapper-outer\">'),t.wrapperOuter=t.$elem.find(\".owl-wrapper-outer\"),t.$elem.css(\"display\",\"block\")},baseClass:function(){var t=this,e=t.$elem.hasClass(t.options.baseClass),o=t.$elem.hasClass(t.options.theme);e||t.$elem.addClass(t.options.baseClass),o||t.$elem.addClass(t.options.theme)},updateItems:function(){var e,o,i=this;if(i.options.responsive===!1)return!1;if(i.options.singleItem===!0)return i.options.items=i.orignalItems=1,i.options.itemsCustom=!1,i.options.itemsDesktop=!1,i.options.itemsDesktopSmall=!1,i.options.itemsTablet=!1,i.options.itemsTabletSmall=!1,i.options.itemsMobile=!1,!1;if(e=t(i.options.responsiveBaseWidth).width(),e>(i.options.itemsDesktop[0]||i.orignalItems)&&(i.options.items=i.orignalItems),i.options.itemsCustom!==!1)for(i.options.itemsCustom.sort(function(t,e){return t[0]-e[0]}),o=0;o<i.options.itemsCustom.length;o+=1)i.options.itemsCustom[o][0]<=e&&(i.options.items=i.options.itemsCustom[o][1]);else e<=i.options.itemsDesktop[0]&&i.options.itemsDesktop!==!1&&(i.options.items=i.options.itemsDesktop[1]),e<=i.options.itemsDesktopSmall[0]&&i.options.itemsDesktopSmall!==!1&&(i.options.items=i.options.itemsDesktopSmall[1]),e<=i.options.itemsTablet[0]&&i.options.itemsTablet!==!1&&(i.options.items=i.options.itemsTablet[1]),e<=i.options.itemsTabletSmall[0]&&i.options.itemsTabletSmall!==!1&&(i.options.items=i.options.itemsTabletSmall[1]),e<=i.options.itemsMobile[0]&&i.options.itemsMobile!==!1&&(i.options.items=i.options.itemsMobile[1]);i.options.items>i.itemsAmount&&i.options.itemsScaleUp===!0&&(i.options.items=i.itemsAmount)},response:function(){var o,i,n=this;return n.options.responsive!==!0?!1:(i=t(e).width(),n.resizer=function(){t(e).width()!==i&&(n.options.autoPlay!==!1&&e.clearInterval(n.autoPlayInterval),e.clearTimeout(o),o=e.setTimeout(function(){i=t(e).width(),n.updateVars()},n.options.responsiveRefreshRate))},void t(e).resize(n.resizer))},updatePosition:function(){var t=this;t.jumpTo(t.currentItem),t.options.autoPlay!==!1&&t.checkAp()},appendItemsSizes:function(){var e=this,o=0,i=e.itemsAmount-e.options.items;e.$owlItems.each(function(n){var s=t(this);s.css({width:e.itemWidth}).data(\"owl-item\",Number(n)),(n%e.options.items===0||n===i)&&(n>i||(o+=1)),s.data(\"owl-roundPages\",o)})},appendWrapperSizes:function(){var t=this,e=t.$owlItems.length*t.itemWidth;t.$owlWrapper.css({width:2*e,left:0}),t.appendItemsSizes()},calculateAll:function(){var t=this;t.calculateWidth(),t.appendWrapperSizes(),t.loops(),t.max()},calculateWidth:function(){var t=this;t.itemWidth=Math.round(t.$elem.width()/t.options.items)},max:function(){var t=this,e=-1*(t.itemsAmount*t.itemWidth-t.options.items*t.itemWidth);return t.options.items>t.itemsAmount?(t.maximumItem=0,e=0,t.maximumPixels=0):(t.maximumItem=t.itemsAmount-t.options.items,t.maximumPixels=e),e},min:function(){return 0},loops:function(){var e,o,i,n=this,s=0,a=0;for(n.positionsInArray=[0],n.pagesInArray=[],e=0;e<n.itemsAmount;e+=1)a+=n.itemWidth,n.positionsInArray.push(-a),n.options.scrollPerPage===!0&&(o=t(n.$owlItems[e]),i=o.data(\"owl-roundPages\"),i!==s&&(n.pagesInArray[s]=n.positionsInArray[e],s=i))},buildControls:function(){var e=this;(e.options.navigation===!0||e.options.pagination===!0)&&(e.owlControls=t('<div class=\"owl-controls\"/>').toggleClass(\"clickable\",!e.browser.isTouch).appendTo(e.$elem)),e.options.pagination===!0&&e.buildPagination(),e.options.navigation===!0&&e.buildButtons()},buildButtons:function(){var e=this,o=t('<div class=\"owl-buttons\"/>');e.owlControls.append(o),e.buttonPrev=t(\"<div/>\",{\"class\":\"owl-prev\",html:e.options.navigationText[0]||\"\"}),e.buttonNext=t(\"<div/>\",{\"class\":\"owl-next\",html:e.options.navigationText[1]||\"\"}),o.append(e.buttonPrev).append(e.buttonNext),o.on(\"touchstart.owlControls mousedown.owlControls\",'div[class^=\"owl\"]',function(t){t.preventDefault()}),o.on(\"touchend.owlControls mouseup.owlControls\",'div[class^=\"owl\"]',function(o){o.preventDefault(),t(this).hasClass(\"owl-next\")?e.next():e.prev()})},buildPagination:function(){var e=this;e.paginationWrapper=t('<div class=\"owl-pagination\"/>'),e.owlControls.append(e.paginationWrapper),e.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\",\".owl-page\",function(o){o.preventDefault(),Number(t(this).data(\"owl-page\"))!==e.currentItem&&e.goTo(Number(t(this).data(\"owl-page\")),!0)})},updatePagination:function(){var e,o,i,n,s,a,r=this;if(r.options.pagination===!1)return!1;for(r.paginationWrapper.html(\"\"),e=0,o=r.itemsAmount-r.itemsAmount%r.options.items,n=0;n<r.itemsAmount;n+=1)n%r.options.items===0&&(e+=1,o===n&&(i=r.itemsAmount-r.options.items),s=t(\"<div/>\",{\"class\":\"owl-page\"}),a=t(\"<span></span>\",{text:r.options.paginationNumbers===!0?e:\"\",\"class\":r.options.paginationNumbers===!0?\"owl-numbers\":\"\"}),s.append(a),s.data(\"owl-page\",o===n?i:n),s.data(\"owl-roundPages\",e),r.paginationWrapper.append(s));r.checkPagination()},checkPagination:function(){var e=this;return e.options.pagination===!1?!1:void e.paginationWrapper.find(\".owl-page\").each(function(){t(this).data(\"owl-roundPages\")===t(e.$owlItems[e.currentItem]).data(\"owl-roundPages\")&&(e.paginationWrapper.find(\".owl-page\").removeClass(\"active\"),t(this).addClass(\"active\"))})},checkNavigation:function(){var t=this;return t.options.navigation===!1?!1:void(t.options.rewindNav===!1&&(0===t.currentItem&&0===t.maximumItem?(t.buttonPrev.addClass(\"disabled\"),t.buttonNext.addClass(\"disabled\")):0===t.currentItem&&0!==t.maximumItem?(t.buttonPrev.addClass(\"disabled\"),t.buttonNext.removeClass(\"disabled\")):t.currentItem===t.maximumItem?(t.buttonPrev.removeClass(\"disabled\"),t.buttonNext.addClass(\"disabled\")):0!==t.currentItem&&t.currentItem!==t.maximumItem&&(t.buttonPrev.removeClass(\"disabled\"),t.buttonNext.removeClass(\"disabled\"))))},updateControls:function(){var t=this;t.updatePagination(),t.checkNavigation(),t.owlControls&&(t.options.items>=t.itemsAmount?t.owlControls.hide():t.owlControls.show())},destroyControls:function(){var t=this;t.owlControls&&t.owlControls.remove()},next:function(t){var e=this;if(e.isTransition)return!1;if(e.currentItem+=e.options.scrollPerPage===!0?e.options.items:1,e.currentItem>e.maximumItem+(e.options.scrollPerPage===!0?e.options.items-1:0)){if(e.options.rewindNav!==!0)return e.currentItem=e.maximumItem,!1;e.currentItem=0,t=\"rewind\"}e.goTo(e.currentItem,t)},prev:function(t){var e=this;if(e.isTransition)return!1;if(e.options.scrollPerPage===!0&&e.currentItem>0&&e.currentItem<e.options.items?e.currentItem=0:e.currentItem-=e.options.scrollPerPage===!0?e.options.items:1,e.currentItem<0){if(e.options.rewindNav!==!0)return e.currentItem=0,!1;e.currentItem=e.maximumItem,t=\"rewind\"}e.goTo(e.currentItem,t)},goTo:function(t,o,i){var n,s=this;return s.isTransition?!1:(\"function\"==typeof s.options.beforeMove&&s.options.beforeMove.apply(this,[s.$elem]),t>=s.maximumItem?t=s.maximumItem:0>=t&&(t=0),s.currentItem=s.owl.currentItem=t,s.options.transitionStyle!==!1&&\"drag\"!==i&&1===s.options.items&&s.browser.support3d===!0?(s.swapSpeed(0),s.browser.support3d===!0?s.transition3d(s.positionsInArray[t]):s.css2slide(s.positionsInArray[t],1),s.afterGo(),s.singleItemTransition(),!1):(n=s.positionsInArray[t],s.browser.support3d===!0?(s.isCss3Finish=!1,o===!0?(s.swapSpeed(\"paginationSpeed\"),e.setTimeout(function(){s.isCss3Finish=!0},s.options.paginationSpeed)):\"rewind\"===o?(s.swapSpeed(s.options.rewindSpeed),e.setTimeout(function(){s.isCss3Finish=!0},s.options.rewindSpeed)):(s.swapSpeed(\"slideSpeed\"),e.setTimeout(function(){s.isCss3Finish=!0},s.options.slideSpeed)),s.transition3d(n)):o===!0?s.css2slide(n,s.options.paginationSpeed):\"rewind\"===o?s.css2slide(n,s.options.rewindSpeed):s.css2slide(n,s.options.slideSpeed),void s.afterGo()))},jumpTo:function(t){var e=this;\"function\"==typeof e.options.beforeMove&&e.options.beforeMove.apply(this,[e.$elem]),t>=e.maximumItem||-1===t?t=e.maximumItem:0>=t&&(t=0),e.swapSpeed(0),e.browser.support3d===!0?e.transition3d(e.positionsInArray[t]):e.css2slide(e.positionsInArray[t],1),e.currentItem=e.owl.currentItem=t,e.afterGo()},afterGo:function(){var t=this;t.prevArr.push(t.currentItem),t.prevItem=t.owl.prevItem=t.prevArr[t.prevArr.length-2],t.prevArr.shift(0),t.prevItem!==t.currentItem&&(t.checkPagination(),t.checkNavigation(),t.eachMoveUpdate(),t.options.autoPlay!==!1&&t.checkAp()),\"function\"==typeof t.options.afterMove&&t.prevItem!==t.currentItem&&t.options.afterMove.apply(this,[t.$elem])},stop:function(){var t=this;t.apStatus=\"stop\",e.clearInterval(t.autoPlayInterval)},checkAp:function(){var t=this;\"stop\"!==t.apStatus&&t.play()},play:function(){var t=this;return t.apStatus=\"play\",t.options.autoPlay===!1?!1:(e.clearInterval(t.autoPlayInterval),void(t.autoPlayInterval=e.setInterval(function(){t.next(!0)},t.options.autoPlay)))},swapSpeed:function(t){var e=this;\"slideSpeed\"===t?e.$owlWrapper.css(e.addCssSpeed(e.options.slideSpeed)):\"paginationSpeed\"===t?e.$owlWrapper.css(e.addCssSpeed(e.options.paginationSpeed)):\"string\"!=typeof t&&e.$owlWrapper.css(e.addCssSpeed(t))},addCssSpeed:function(t){return{\"-webkit-transition\":\"all \"+t+\"ms ease\",\"-moz-transition\":\"all \"+t+\"ms ease\",\"-o-transition\":\"all \"+t+\"ms ease\",transition:\"all \"+t+\"ms ease\"}},removeTransition:function(){return{\"-webkit-transition\":\"\",\"-moz-transition\":\"\",\"-o-transition\":\"\",transition:\"\"}},doTranslate:function(t){return{\"-webkit-transform\":\"translate3d(\"+t+\"px, 0px, 0px)\",\"-moz-transform\":\"translate3d(\"+t+\"px, 0px, 0px)\",\"-o-transform\":\"translate3d(\"+t+\"px, 0px, 0px)\",\"-ms-transform\":\"translate3d(\"+t+\"px, 0px, 0px)\",transform:\"translate3d(\"+t+\"px, 0px,0px)\"}},transition3d:function(t){var e=this;e.$owlWrapper.css(e.doTranslate(t))},css2move:function(t){var e=this;e.$owlWrapper.css({left:t})},css2slide:function(t,e){var o=this;o.isCssFinish=!1,o.$owlWrapper.stop(!0,!0).animate({left:t},{duration:e||o.options.slideSpeed,complete:function(){o.isCssFinish=!0}})},checkBrowser:function(){var t,i,n,s,a=this,r=\"translate3d(0px, 0px, 0px)\",l=o.createElement(\"div\");l.style.cssText=\"  -moz-transform:\"+r+\"; -ms-transform:\"+r+\"; -o-transform:\"+r+\"; -webkit-transform:\"+r+\"; transform:\"+r,t=/translate3d\\(0px, 0px, 0px\\)/g,i=l.style.cssText.match(t),n=null!==i&&i.length>=1,s=\"ontouchstart\"in e||e.navigator.msMaxTouchPoints,a.browser={support3d:n,isTouch:s}},moveEvents:function(){var t=this;(t.options.mouseDrag!==!1||t.options.touchDrag!==!1)&&(t.gestures(),t.disabledEvents())},eventTypes:function(){var t=this,e=[\"s\",\"e\",\"x\"];t.ev_types={},t.options.mouseDrag===!0&&t.options.touchDrag===!0?e=[\"touchstart.owl mousedown.owl\",\"touchmove.owl mousemove.owl\",\"touchend.owl touchcancel.owl mouseup.owl\"]:t.options.mouseDrag===!1&&t.options.touchDrag===!0?e=[\"touchstart.owl\",\"touchmove.owl\",\"touchend.owl touchcancel.owl\"]:t.options.mouseDrag===!0&&t.options.touchDrag===!1&&(e=[\"mousedown.owl\",\"mousemove.owl\",\"mouseup.owl\"]),t.ev_types.start=e[0],t.ev_types.move=e[1],t.ev_types.end=e[2]},disabledEvents:function(){var e=this;e.$elem.on(\"dragstart.owl\",function(t){t.preventDefault()}),e.$elem.on(\"mousedown.disableTextSelect\",function(e){return t(e.target).is(\"input, textarea, select, option\")})},gestures:function(){function i(t){if(void 0!==t.touches)return{x:t.touches[0].pageX,y:t.touches[0].pageY};if(void 0===t.touches){if(void 0!==t.pageX)return{x:t.pageX,y:t.pageY};if(void 0===t.pageX)return{x:t.clientX,y:t.clientY}}}function n(e){\"on\"===e?(t(o).on(l.ev_types.move,a),t(o).on(l.ev_types.end,r)):\"off\"===e&&(t(o).off(l.ev_types.move),t(o).off(l.ev_types.end))}function s(o){var s,a=o.originalEvent||o||e.event;if(3===a.which)return!1;if(!(l.itemsAmount<=l.options.items)){if(l.isCssFinish===!1&&!l.options.dragBeforeAnimFinish)return!1;if(l.isCss3Finish===!1&&!l.options.dragBeforeAnimFinish)return!1;l.options.autoPlay!==!1&&e.clearInterval(l.autoPlayInterval),l.browser.isTouch===!0||l.$owlWrapper.hasClass(\"grabbing\")||l.$owlWrapper.addClass(\"grabbing\"),l.newPosX=0,l.newRelativeX=0,t(this).css(l.removeTransition()),s=t(this).position(),p.relativePos=s.left,p.offsetX=i(a).x-s.left,p.offsetY=i(a).y-s.top,n(\"on\"),p.sliding=!1,p.targetElement=a.target||a.srcElement}}function a(n){var s,a,r=n.originalEvent||n||e.event;l.newPosX=i(r).x-p.offsetX,l.newPosY=i(r).y-p.offsetY,l.newRelativeX=l.newPosX-p.relativePos,\"function\"==typeof l.options.startDragging&&p.dragging!==!0&&0!==l.newRelativeX&&(p.dragging=!0,l.options.startDragging.apply(l,[l.$elem])),(l.newRelativeX>8||l.newRelativeX<-8)&&l.browser.isTouch===!0&&(void 0!==r.preventDefault?r.preventDefault():r.returnValue=!1,p.sliding=!0),(l.newPosY>10||l.newPosY<-10)&&p.sliding===!1&&t(o).off(\"touchmove.owl\"),s=function(){return l.newRelativeX/5},a=function(){return l.maximumPixels+l.newRelativeX/5},l.newPosX=Math.max(Math.min(l.newPosX,s()),a()),l.browser.support3d===!0?l.transition3d(l.newPosX):l.css2move(l.newPosX)}function r(o){var i,s,a,r=o.originalEvent||o||e.event;r.target=r.target||r.srcElement,p.dragging=!1,l.browser.isTouch!==!0&&l.$owlWrapper.removeClass(\"grabbing\"),l.dragDirection=l.owl.dragDirection=l.newRelativeX<0?\"left\":\"right\",0!==l.newRelativeX&&(i=l.getNewPosition(),l.goTo(i,!1,\"drag\"),p.targetElement===r.target&&l.browser.isTouch!==!0&&(t(r.target).on(\"click.disable\",function(e){e.stopImmediatePropagation(),e.stopPropagation(),e.preventDefault(),t(e.target).off(\"click.disable\")}),s=t._data(r.target,\"events\").click,a=s.pop(),s.splice(0,0,a))),n(\"off\")}var l=this,p={offsetX:0,offsetY:0,baseElWidth:0,relativePos:0,position:null,minSwipe:null,maxSwipe:null,sliding:null,dargging:null,targetElement:null};l.isCssFinish=!0,l.$elem.on(l.ev_types.start,\".owl-wrapper\",s)},getNewPosition:function(){var t=this,e=t.closestItem();return e>t.maximumItem?(t.currentItem=t.maximumItem,e=t.maximumItem):t.newPosX>=0&&(e=0,t.currentItem=0),e},closestItem:function(){var e=this,o=e.options.scrollPerPage===!0?e.pagesInArray:e.positionsInArray,i=e.newPosX,n=null;return t.each(o,function(s,a){i-e.itemWidth/20>o[s+1]&&i-e.itemWidth/20<a&&\"left\"===e.moveDirection()?(n=a,e.currentItem=e.options.scrollPerPage===!0?t.inArray(n,e.positionsInArray):s):i+e.itemWidth/20<a&&i+e.itemWidth/20>(o[s+1]||o[s]-e.itemWidth)&&\"right\"===e.moveDirection()&&(e.options.scrollPerPage===!0?(n=o[s+1]||o[o.length-1],e.currentItem=t.inArray(n,e.positionsInArray)):(n=o[s+1],e.currentItem=s+1))}),e.currentItem},moveDirection:function(){var t,e=this;return e.newRelativeX<0?(t=\"right\",e.playDirection=\"next\"):(t=\"left\",e.playDirection=\"prev\"),t},customEvents:function(){var t=this;t.$elem.on(\"owl.next\",function(){t.next()}),t.$elem.on(\"owl.prev\",function(){t.prev()}),t.$elem.on(\"owl.play\",function(e,o){t.options.autoPlay=o,t.play(),t.hoverStatus=\"play\"}),t.$elem.on(\"owl.stop\",function(){t.stop(),t.hoverStatus=\"stop\"}),t.$elem.on(\"owl.goTo\",function(e,o){t.goTo(o)}),t.$elem.on(\"owl.jumpTo\",function(e,o){t.jumpTo(o)})},stopOnHover:function(){var t=this;t.options.stopOnHover===!0&&t.browser.isTouch!==!0&&t.options.autoPlay!==!1&&(t.$elem.on(\"mouseover\",function(){t.stop()}),t.$elem.on(\"mouseout\",function(){\"stop\"!==t.hoverStatus&&t.play()}))},lazyLoad:function(){var e,o,i,n,s,a=this;if(a.options.lazyLoad===!1)return!1;for(e=0;e<a.itemsAmount;e+=1)o=t(a.$owlItems[e]),\"loaded\"!==o.data(\"owl-loaded\")&&(i=o.data(\"owl-item\"),n=o.find(\".lazyOwl\"),\"string\"==typeof n.data(\"src\")?(void 0===o.data(\"owl-loaded\")&&(n.hide(),o.addClass(\"loading\").data(\"owl-loaded\",\"checked\")),s=a.options.lazyFollow===!0?i>=a.currentItem:!0,s&&i<a.currentItem+a.options.items&&n.length&&n.each(function(){a.lazyPreload(o,t(this))})):o.data(\"owl-loaded\",\"loaded\"))},lazyPreload:function(t,o){function i(){t.data(\"owl-loaded\",\"loaded\").removeClass(\"loading\"),o.removeAttr(\"data-src\"),\"fade\"===a.options.lazyEffect?o.fadeIn(400):o.show(),\"function\"==typeof a.options.afterLazyLoad&&a.options.afterLazyLoad.apply(this,[a.$elem])}function n(){r+=1,a.completeImg(o.get(0))||s===!0?i():100>=r?e.setTimeout(n,100):i()}var s,a=this,r=0;\"DIV\"===o.prop(\"tagName\")?(o.css(\"background-image\",\"url(\"+o.data(\"src\")+\")\"),s=!0):o[0].src=o.data(\"src\"),n()},autoHeight:function(){function o(){var o=t(s.$owlItems[s.currentItem]).height();s.wrapperOuter.css(\"height\",o+\"px\"),s.wrapperOuter.hasClass(\"autoHeight\")||e.setTimeout(function(){s.wrapperOuter.addClass(\"autoHeight\")},0)}function i(){n+=1,s.completeImg(a.get(0))?o():100>=n?e.setTimeout(i,100):s.wrapperOuter.css(\"height\",\"\")}var n,s=this,a=t(s.$owlItems[s.currentItem]).find(\"img\");void 0!==a.get(0)?(n=0,i()):o()},completeImg:function(t){var e;return t.complete?(e=typeof t.naturalWidth,\"undefined\"!==e&&0===t.naturalWidth?!1:!0):!1},onVisibleItems:function(){var e,o=this;for(o.options.addClassActive===!0&&o.$owlItems.removeClass(\"active\"),o.visibleItems=[],e=o.currentItem;e<o.currentItem+o.options.items;e+=1)o.visibleItems.push(e),o.options.addClassActive===!0&&t(o.$owlItems[e]).addClass(\"active\");o.owl.visibleItems=o.visibleItems},transitionTypes:function(t){var e=this;e.outClass=\"owl-\"+t+\"-out\",e.inClass=\"owl-\"+t+\"-in\"},singleItemTransition:function(){function t(t){return{position:\"relative\",left:t+\"px\"}}var e=this,o=e.outClass,i=e.inClass,n=e.$owlItems.eq(e.currentItem),s=e.$owlItems.eq(e.prevItem),a=Math.abs(e.positionsInArray[e.currentItem])+e.positionsInArray[e.prevItem],r=Math.abs(e.positionsInArray[e.currentItem])+e.itemWidth/2,l=\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\";e.isTransition=!0,e.$owlWrapper.addClass(\"owl-origin\").css({\"-webkit-transform-origin\":r+\"px\",\"-moz-perspective-origin\":r+\"px\",\"perspective-origin\":r+\"px\"}),s.css(t(a,10)).addClass(o).on(l,function(){e.endPrev=!0,s.off(l),e.clearTransStyle(s,o)}),n.addClass(i).on(l,function(){e.endCurrent=!0,n.off(l),e.clearTransStyle(n,i)})},clearTransStyle:function(t,e){var o=this;t.css({position:\"\",left:\"\"}).removeClass(e),o.endPrev&&o.endCurrent&&(o.$owlWrapper.removeClass(\"owl-origin\"),o.endPrev=!1,o.endCurrent=!1,o.isTransition=!1)},owlStatus:function(){var t=this;t.owl={userOptions:t.userOptions,baseElement:t.$elem,userItems:t.$userItems,owlItems:t.$owlItems,currentItem:t.currentItem,prevItem:t.prevItem,visibleItems:t.visibleItems,isTouch:t.browser.isTouch,browser:t.browser,dragDirection:t.dragDirection}},clearEvents:function(){var i=this;i.$elem.off(\".owl owl mousedown.disableTextSelect\"),t(o).off(\".owl owl\"),t(e).off(\"resize\",i.resizer)},unWrap:function(){var t=this;0!==t.$elem.children().length&&(t.$owlWrapper.unwrap(),t.$userItems.unwrap().unwrap(),t.owlControls&&t.owlControls.remove()),t.clearEvents(),t.$elem.attr({style:t.$elem.data(\"owl-originalStyles\")||\"\",\"class\":t.$elem.data(\"owl-originalClasses\")})},destroy:function(){var t=this;t.stop(),e.clearInterval(t.checkVisible),t.unWrap(),t.$elem.removeData()},reinit:function(e){var o=this,i=t.extend({},o.userOptions,e);o.unWrap(),o.init(i,o.$elem)},addItem:function(t,e){var o,i=this;return t?0===i.$elem.children().length?(i.$elem.append(t),i.setVars(),!1):(i.unWrap(),o=void 0===e||-1===e?-1:e,o>=i.$userItems.length||-1===o?i.$userItems.eq(-1).after(t):i.$userItems.eq(o).before(t),void i.setVars()):!1},removeItem:function(t){var e,o=this;return 0===o.$elem.children().length?!1:(e=void 0===t||-1===t?-1:t,o.unWrap(),o.$userItems.eq(e).remove(),void o.setVars())}};t.fn.owlCarousel=function(e){return this.each(function(){if(t(this).data(\"owl-init\")===!0)return!1;t(this).data(\"owl-init\",!0);var o=Object.create(i);o.init(e,this),t.data(this,\"owlCarousel\",o)})},t.fn.owlCarousel.options={items:5,itemsCustom:!1,itemsDesktop:[1199,4],itemsDesktopSmall:[979,3],itemsTablet:[768,2],itemsTabletSmall:!1,itemsMobile:[479,1],singleItem:!1,itemsScaleUp:!1,slideSpeed:200,paginationSpeed:800,rewindSpeed:1e3,autoPlay:!1,stopOnHover:!1,navigation:!1,navigationText:[\"prev\",\"next\"],rewindNav:!0,scrollPerPage:!1,pagination:!0,paginationNumbers:!1,responsive:!0,responsiveRefreshRate:200,responsiveBaseWidth:e,baseClass:\"owl-carousel\",theme:\"owl-theme\",lazyLoad:!1,lazyFollow:!0,lazyEffect:\"fade\",autoHeight:!1,jsonPath:!1,jsonSuccess:!1,dragBeforeAnimFinish:!0,mouseDrag:!0,touchDrag:!0,addClassActive:!1,transitionStyle:!1,beforeUpdate:!1,afterUpdate:!1,beforeInit:!1,afterInit:!1,beforeMove:!1,afterMove:!1,afterAction:!1,startDragging:!1,afterLazyLoad:!1}}(jQuery,window,document);","Plazathemes_Newproductslider/js/jquery-1.9.1.min.js":"/*! jQuery v1.9.1 | (c) 2005, 2012 jQuery Foundation, Inc. | jquery.org/license\n//@ sourceMappingURL=jquery.min.map\n*/(function(e,t){var n,r,i=typeof t,o=e.document,a=e.location,s=e.jQuery,u=e.$,l={},c=[],p=\"1.9.1\",f=c.concat,d=c.push,h=c.slice,g=c.indexOf,m=l.toString,y=l.hasOwnProperty,v=p.trim,b=function(e,t){return new b.fn.init(e,t,r)},x=/[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/.source,w=/\\S+/g,T=/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,N=/^(?:(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,C=/^<(\\w+)\\s*\\/?>(?:<\\/\\1>|)$/,k=/^[\\],:{}\\s]*$/,E=/(?:^|:|,)(?:\\s*\\[)+/g,S=/\\\\(?:[\"\\\\\\/bfnrt]|u[\\da-fA-F]{4})/g,A=/\"[^\"\\\\\\r\\n]*\"|true|false|null|-?(?:\\d+\\.|)\\d+(?:[eE][+-]?\\d+|)/g,j=/^-ms-/,D=/-([\\da-z])/gi,L=function(e,t){return t.toUpperCase()},H=function(e){(o.addEventListener||\"load\"===e.type||\"complete\"===o.readyState)&&(q(),b.ready())},q=function(){o.addEventListener?(o.removeEventListener(\"DOMContentLoaded\",H,!1),e.removeEventListener(\"load\",H,!1)):(o.detachEvent(\"onreadystatechange\",H),e.detachEvent(\"onload\",H))};b.fn=b.prototype={jquery:p,constructor:b,init:function(e,n,r){var i,a;if(!e)return this;if(\"string\"==typeof e){if(i=\"<\"===e.charAt(0)&&\">\"===e.charAt(e.length-1)&&e.length>=3?[null,e,null]:N.exec(e),!i||!i[1]&&n)return!n||n.jquery?(n||r).find(e):this.constructor(n).find(e);if(i[1]){if(n=n instanceof b?n[0]:n,b.merge(this,b.parseHTML(i[1],n&&n.nodeType?n.ownerDocument||n:o,!0)),C.test(i[1])&&b.isPlainObject(n))for(i in n)b.isFunction(this[i])?this[i](n[i]):this.attr(i,n[i]);return this}if(a=o.getElementById(i[2]),a&&a.parentNode){if(a.id!==i[2])return r.find(e);this.length=1,this[0]=a}return this.context=o,this.selector=e,this}return e.nodeType?(this.context=this[0]=e,this.length=1,this):b.isFunction(e)?r.ready(e):(e.selector!==t&&(this.selector=e.selector,this.context=e.context),b.makeArray(e,this))},selector:\"\",length:0,size:function(){return this.length},toArray:function(){return h.call(this)},get:function(e){return null==e?this.toArray():0>e?this[this.length+e]:this[e]},pushStack:function(e){var t=b.merge(this.constructor(),e);return t.prevObject=this,t.context=this.context,t},each:function(e,t){return b.each(this,e,t)},ready:function(e){return b.ready.promise().done(e),this},slice:function(){return this.pushStack(h.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(0>e?t:0);return this.pushStack(n>=0&&t>n?[this[n]]:[])},map:function(e){return this.pushStack(b.map(this,function(t,n){return e.call(t,n,t)}))},end:function(){return this.prevObject||this.constructor(null)},push:d,sort:[].sort,splice:[].splice},b.fn.init.prototype=b.fn,b.extend=b.fn.extend=function(){var e,n,r,i,o,a,s=arguments[0]||{},u=1,l=arguments.length,c=!1;for(\"boolean\"==typeof s&&(c=s,s=arguments[1]||{},u=2),\"object\"==typeof s||b.isFunction(s)||(s={}),l===u&&(s=this,--u);l>u;u++)if(null!=(o=arguments[u]))for(i in o)e=s[i],r=o[i],s!==r&&(c&&r&&(b.isPlainObject(r)||(n=b.isArray(r)))?(n?(n=!1,a=e&&b.isArray(e)?e:[]):a=e&&b.isPlainObject(e)?e:{},s[i]=b.extend(c,a,r)):r!==t&&(s[i]=r));return s},b.extend({noConflict:function(t){return e.$===b&&(e.$=u),t&&e.jQuery===b&&(e.jQuery=s),b},isReady:!1,readyWait:1,holdReady:function(e){e?b.readyWait++:b.ready(!0)},ready:function(e){if(e===!0?!--b.readyWait:!b.isReady){if(!o.body)return setTimeout(b.ready);b.isReady=!0,e!==!0&&--b.readyWait>0||(n.resolveWith(o,[b]),b.fn.trigger&&b(o).trigger(\"ready\").off(\"ready\"))}},isFunction:function(e){return\"function\"===b.type(e)},isArray:Array.isArray||function(e){return\"array\"===b.type(e)},isWindow:function(e){return null!=e&&e==e.window},isNumeric:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},type:function(e){return null==e?e+\"\":\"object\"==typeof e||\"function\"==typeof e?l[m.call(e)]||\"object\":typeof e},isPlainObject:function(e){if(!e||\"object\"!==b.type(e)||e.nodeType||b.isWindow(e))return!1;try{if(e.constructor&&!y.call(e,\"constructor\")&&!y.call(e.constructor.prototype,\"isPrototypeOf\"))return!1}catch(n){return!1}var r;for(r in e);return r===t||y.call(e,r)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},error:function(e){throw Error(e)},parseHTML:function(e,t,n){if(!e||\"string\"!=typeof e)return null;\"boolean\"==typeof t&&(n=t,t=!1),t=t||o;var r=C.exec(e),i=!n&&[];return r?[t.createElement(r[1])]:(r=b.buildFragment([e],t,i),i&&b(i).remove(),b.merge([],r.childNodes))},parseJSON:function(n){return e.JSON&&e.JSON.parse?e.JSON.parse(n):null===n?n:\"string\"==typeof n&&(n=b.trim(n),n&&k.test(n.replace(S,\"@\").replace(A,\"]\").replace(E,\"\")))?Function(\"return \"+n)():(b.error(\"Invalid JSON: \"+n),t)},parseXML:function(n){var r,i;if(!n||\"string\"!=typeof n)return null;try{e.DOMParser?(i=new DOMParser,r=i.parseFromString(n,\"text/xml\")):(r=new ActiveXObject(\"Microsoft.XMLDOM\"),r.async=\"false\",r.loadXML(n))}catch(o){r=t}return r&&r.documentElement&&!r.getElementsByTagName(\"parsererror\").length||b.error(\"Invalid XML: \"+n),r},noop:function(){},globalEval:function(t){t&&b.trim(t)&&(e.execScript||function(t){e.eval.call(e,t)})(t)},camelCase:function(e){return e.replace(j,\"ms-\").replace(D,L)},nodeName:function(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()},each:function(e,t,n){var r,i=0,o=e.length,a=M(e);if(n){if(a){for(;o>i;i++)if(r=t.apply(e[i],n),r===!1)break}else for(i in e)if(r=t.apply(e[i],n),r===!1)break}else if(a){for(;o>i;i++)if(r=t.call(e[i],i,e[i]),r===!1)break}else for(i in e)if(r=t.call(e[i],i,e[i]),r===!1)break;return e},trim:v&&!v.call(\"\\ufeff\\u00a0\")?function(e){return null==e?\"\":v.call(e)}:function(e){return null==e?\"\":(e+\"\").replace(T,\"\")},makeArray:function(e,t){var n=t||[];return null!=e&&(M(Object(e))?b.merge(n,\"string\"==typeof e?[e]:e):d.call(n,e)),n},inArray:function(e,t,n){var r;if(t){if(g)return g.call(t,e,n);for(r=t.length,n=n?0>n?Math.max(0,r+n):n:0;r>n;n++)if(n in t&&t[n]===e)return n}return-1},merge:function(e,n){var r=n.length,i=e.length,o=0;if(\"number\"==typeof r)for(;r>o;o++)e[i++]=n[o];else while(n[o]!==t)e[i++]=n[o++];return e.length=i,e},grep:function(e,t,n){var r,i=[],o=0,a=e.length;for(n=!!n;a>o;o++)r=!!t(e[o],o),n!==r&&i.push(e[o]);return i},map:function(e,t,n){var r,i=0,o=e.length,a=M(e),s=[];if(a)for(;o>i;i++)r=t(e[i],i,n),null!=r&&(s[s.length]=r);else for(i in e)r=t(e[i],i,n),null!=r&&(s[s.length]=r);return f.apply([],s)},guid:1,proxy:function(e,n){var r,i,o;return\"string\"==typeof n&&(o=e[n],n=e,e=o),b.isFunction(e)?(r=h.call(arguments,2),i=function(){return e.apply(n||this,r.concat(h.call(arguments)))},i.guid=e.guid=e.guid||b.guid++,i):t},access:function(e,n,r,i,o,a,s){var u=0,l=e.length,c=null==r;if(\"object\"===b.type(r)){o=!0;for(u in r)b.access(e,n,u,r[u],!0,a,s)}else if(i!==t&&(o=!0,b.isFunction(i)||(s=!0),c&&(s?(n.call(e,i),n=null):(c=n,n=function(e,t,n){return c.call(b(e),n)})),n))for(;l>u;u++)n(e[u],r,s?i:i.call(e[u],u,n(e[u],r)));return o?e:c?n.call(e):l?n(e[0],r):a},now:function(){return(new Date).getTime()}}),b.ready.promise=function(t){if(!n)if(n=b.Deferred(),\"complete\"===o.readyState)setTimeout(b.ready);else if(o.addEventListener)o.addEventListener(\"DOMContentLoaded\",H,!1),e.addEventListener(\"load\",H,!1);else{o.attachEvent(\"onreadystatechange\",H),e.attachEvent(\"onload\",H);var r=!1;try{r=null==e.frameElement&&o.documentElement}catch(i){}r&&r.doScroll&&function a(){if(!b.isReady){try{r.doScroll(\"left\")}catch(e){return setTimeout(a,50)}q(),b.ready()}}()}return n.promise(t)},b.each(\"Boolean Number String Function Array Date RegExp Object Error\".split(\" \"),function(e,t){l[\"[object \"+t+\"]\"]=t.toLowerCase()});function M(e){var t=e.length,n=b.type(e);return b.isWindow(e)?!1:1===e.nodeType&&t?!0:\"array\"===n||\"function\"!==n&&(0===t||\"number\"==typeof t&&t>0&&t-1 in e)}r=b(o);var _={};function F(e){var t=_[e]={};return b.each(e.match(w)||[],function(e,n){t[n]=!0}),t}b.Callbacks=function(e){e=\"string\"==typeof e?_[e]||F(e):b.extend({},e);var n,r,i,o,a,s,u=[],l=!e.once&&[],c=function(t){for(r=e.memory&&t,i=!0,a=s||0,s=0,o=u.length,n=!0;u&&o>a;a++)if(u[a].apply(t[0],t[1])===!1&&e.stopOnFalse){r=!1;break}n=!1,u&&(l?l.length&&c(l.shift()):r?u=[]:p.disable())},p={add:function(){if(u){var t=u.length;(function i(t){b.each(t,function(t,n){var r=b.type(n);\"function\"===r?e.unique&&p.has(n)||u.push(n):n&&n.length&&\"string\"!==r&&i(n)})})(arguments),n?o=u.length:r&&(s=t,c(r))}return this},remove:function(){return u&&b.each(arguments,function(e,t){var r;while((r=b.inArray(t,u,r))>-1)u.splice(r,1),n&&(o>=r&&o--,a>=r&&a--)}),this},has:function(e){return e?b.inArray(e,u)>-1:!(!u||!u.length)},empty:function(){return u=[],this},disable:function(){return u=l=r=t,this},disabled:function(){return!u},lock:function(){return l=t,r||p.disable(),this},locked:function(){return!l},fireWith:function(e,t){return t=t||[],t=[e,t.slice?t.slice():t],!u||i&&!l||(n?l.push(t):c(t)),this},fire:function(){return p.fireWith(this,arguments),this},fired:function(){return!!i}};return p},b.extend({Deferred:function(e){var t=[[\"resolve\",\"done\",b.Callbacks(\"once memory\"),\"resolved\"],[\"reject\",\"fail\",b.Callbacks(\"once memory\"),\"rejected\"],[\"notify\",\"progress\",b.Callbacks(\"memory\")]],n=\"pending\",r={state:function(){return n},always:function(){return i.done(arguments).fail(arguments),this},then:function(){var e=arguments;return b.Deferred(function(n){b.each(t,function(t,o){var a=o[0],s=b.isFunction(e[t])&&e[t];i[o[1]](function(){var e=s&&s.apply(this,arguments);e&&b.isFunction(e.promise)?e.promise().done(n.resolve).fail(n.reject).progress(n.notify):n[a+\"With\"](this===r?n.promise():this,s?[e]:arguments)})}),e=null}).promise()},promise:function(e){return null!=e?b.extend(e,r):r}},i={};return r.pipe=r.then,b.each(t,function(e,o){var a=o[2],s=o[3];r[o[1]]=a.add,s&&a.add(function(){n=s},t[1^e][2].disable,t[2][2].lock),i[o[0]]=function(){return i[o[0]+\"With\"](this===i?r:this,arguments),this},i[o[0]+\"With\"]=a.fireWith}),r.promise(i),e&&e.call(i,i),i},when:function(e){var t=0,n=h.call(arguments),r=n.length,i=1!==r||e&&b.isFunction(e.promise)?r:0,o=1===i?e:b.Deferred(),a=function(e,t,n){return function(r){t[e]=this,n[e]=arguments.length>1?h.call(arguments):r,n===s?o.notifyWith(t,n):--i||o.resolveWith(t,n)}},s,u,l;if(r>1)for(s=Array(r),u=Array(r),l=Array(r);r>t;t++)n[t]&&b.isFunction(n[t].promise)?n[t].promise().done(a(t,l,n)).fail(o.reject).progress(a(t,u,s)):--i;return i||o.resolveWith(l,n),o.promise()}}),b.support=function(){var t,n,r,a,s,u,l,c,p,f,d=o.createElement(\"div\");if(d.setAttribute(\"className\",\"t\"),d.innerHTML=\"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\",n=d.getElementsByTagName(\"*\"),r=d.getElementsByTagName(\"a\")[0],!n||!r||!n.length)return{};s=o.createElement(\"select\"),l=s.appendChild(o.createElement(\"option\")),a=d.getElementsByTagName(\"input\")[0],r.style.cssText=\"top:1px;float:left;opacity:.5\",t={getSetAttribute:\"t\"!==d.className,leadingWhitespace:3===d.firstChild.nodeType,tbody:!d.getElementsByTagName(\"tbody\").length,htmlSerialize:!!d.getElementsByTagName(\"link\").length,style:/top/.test(r.getAttribute(\"style\")),hrefNormalized:\"/a\"===r.getAttribute(\"href\"),opacity:/^0.5/.test(r.style.opacity),cssFloat:!!r.style.cssFloat,checkOn:!!a.value,optSelected:l.selected,enctype:!!o.createElement(\"form\").enctype,html5Clone:\"<:nav></:nav>\"!==o.createElement(\"nav\").cloneNode(!0).outerHTML,boxModel:\"CSS1Compat\"===o.compatMode,deleteExpando:!0,noCloneEvent:!0,inlineBlockNeedsLayout:!1,shrinkWrapBlocks:!1,reliableMarginRight:!0,boxSizingReliable:!0,pixelPosition:!1},a.checked=!0,t.noCloneChecked=a.cloneNode(!0).checked,s.disabled=!0,t.optDisabled=!l.disabled;try{delete d.test}catch(h){t.deleteExpando=!1}a=o.createElement(\"input\"),a.setAttribute(\"value\",\"\"),t.input=\"\"===a.getAttribute(\"value\"),a.value=\"t\",a.setAttribute(\"type\",\"radio\"),t.radioValue=\"t\"===a.value,a.setAttribute(\"checked\",\"t\"),a.setAttribute(\"name\",\"t\"),u=o.createDocumentFragment(),u.appendChild(a),t.appendChecked=a.checked,t.checkClone=u.cloneNode(!0).cloneNode(!0).lastChild.checked,d.attachEvent&&(d.attachEvent(\"onclick\",function(){t.noCloneEvent=!1}),d.cloneNode(!0).click());for(f in{submit:!0,change:!0,focusin:!0})d.setAttribute(c=\"on\"+f,\"t\"),t[f+\"Bubbles\"]=c in e||d.attributes[c].expando===!1;return d.style.backgroundClip=\"content-box\",d.cloneNode(!0).style.backgroundClip=\"\",t.clearCloneStyle=\"content-box\"===d.style.backgroundClip,b(function(){var n,r,a,s=\"padding:0;margin:0;border:0;display:block;box-sizing:content-box;-moz-box-sizing:content-box;-webkit-box-sizing:content-box;\",u=o.getElementsByTagName(\"body\")[0];u&&(n=o.createElement(\"div\"),n.style.cssText=\"border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px\",u.appendChild(n).appendChild(d),d.innerHTML=\"<table><tr><td></td><td>t</td></tr></table>\",a=d.getElementsByTagName(\"td\"),a[0].style.cssText=\"padding:0;margin:0;border:0;display:none\",p=0===a[0].offsetHeight,a[0].style.display=\"\",a[1].style.display=\"none\",t.reliableHiddenOffsets=p&&0===a[0].offsetHeight,d.innerHTML=\"\",d.style.cssText=\"box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;\",t.boxSizing=4===d.offsetWidth,t.doesNotIncludeMarginInBodyOffset=1!==u.offsetTop,e.getComputedStyle&&(t.pixelPosition=\"1%\"!==(e.getComputedStyle(d,null)||{}).top,t.boxSizingReliable=\"4px\"===(e.getComputedStyle(d,null)||{width:\"4px\"}).width,r=d.appendChild(o.createElement(\"div\")),r.style.cssText=d.style.cssText=s,r.style.marginRight=r.style.width=\"0\",d.style.width=\"1px\",t.reliableMarginRight=!parseFloat((e.getComputedStyle(r,null)||{}).marginRight)),typeof d.style.zoom!==i&&(d.innerHTML=\"\",d.style.cssText=s+\"width:1px;padding:1px;display:inline;zoom:1\",t.inlineBlockNeedsLayout=3===d.offsetWidth,d.style.display=\"block\",d.innerHTML=\"<div></div>\",d.firstChild.style.width=\"5px\",t.shrinkWrapBlocks=3!==d.offsetWidth,t.inlineBlockNeedsLayout&&(u.style.zoom=1)),u.removeChild(n),n=d=a=r=null)}),n=s=u=l=r=a=null,t}();var O=/(?:\\{[\\s\\S]*\\}|\\[[\\s\\S]*\\])$/,B=/([A-Z])/g;function P(e,n,r,i){if(b.acceptData(e)){var o,a,s=b.expando,u=\"string\"==typeof n,l=e.nodeType,p=l?b.cache:e,f=l?e[s]:e[s]&&s;if(f&&p[f]&&(i||p[f].data)||!u||r!==t)return f||(l?e[s]=f=c.pop()||b.guid++:f=s),p[f]||(p[f]={},l||(p[f].toJSON=b.noop)),(\"object\"==typeof n||\"function\"==typeof n)&&(i?p[f]=b.extend(p[f],n):p[f].data=b.extend(p[f].data,n)),o=p[f],i||(o.data||(o.data={}),o=o.data),r!==t&&(o[b.camelCase(n)]=r),u?(a=o[n],null==a&&(a=o[b.camelCase(n)])):a=o,a}}function R(e,t,n){if(b.acceptData(e)){var r,i,o,a=e.nodeType,s=a?b.cache:e,u=a?e[b.expando]:b.expando;if(s[u]){if(t&&(o=n?s[u]:s[u].data)){b.isArray(t)?t=t.concat(b.map(t,b.camelCase)):t in o?t=[t]:(t=b.camelCase(t),t=t in o?[t]:t.split(\" \"));for(r=0,i=t.length;i>r;r++)delete o[t[r]];if(!(n?$:b.isEmptyObject)(o))return}(n||(delete s[u].data,$(s[u])))&&(a?b.cleanData([e],!0):b.support.deleteExpando||s!=s.window?delete s[u]:s[u]=null)}}}b.extend({cache:{},expando:\"jQuery\"+(p+Math.random()).replace(/\\D/g,\"\"),noData:{embed:!0,object:\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\",applet:!0},hasData:function(e){return e=e.nodeType?b.cache[e[b.expando]]:e[b.expando],!!e&&!$(e)},data:function(e,t,n){return P(e,t,n)},removeData:function(e,t){return R(e,t)},_data:function(e,t,n){return P(e,t,n,!0)},_removeData:function(e,t){return R(e,t,!0)},acceptData:function(e){if(e.nodeType&&1!==e.nodeType&&9!==e.nodeType)return!1;var t=e.nodeName&&b.noData[e.nodeName.toLowerCase()];return!t||t!==!0&&e.getAttribute(\"classid\")===t}}),b.fn.extend({data:function(e,n){var r,i,o=this[0],a=0,s=null;if(e===t){if(this.length&&(s=b.data(o),1===o.nodeType&&!b._data(o,\"parsedAttrs\"))){for(r=o.attributes;r.length>a;a++)i=r[a].name,i.indexOf(\"data-\")||(i=b.camelCase(i.slice(5)),W(o,i,s[i]));b._data(o,\"parsedAttrs\",!0)}return s}return\"object\"==typeof e?this.each(function(){b.data(this,e)}):b.access(this,function(n){return n===t?o?W(o,e,b.data(o,e)):null:(this.each(function(){b.data(this,e,n)}),t)},null,n,arguments.length>1,null,!0)},removeData:function(e){return this.each(function(){b.removeData(this,e)})}});function W(e,n,r){if(r===t&&1===e.nodeType){var i=\"data-\"+n.replace(B,\"-$1\").toLowerCase();if(r=e.getAttribute(i),\"string\"==typeof r){try{r=\"true\"===r?!0:\"false\"===r?!1:\"null\"===r?null:+r+\"\"===r?+r:O.test(r)?b.parseJSON(r):r}catch(o){}b.data(e,n,r)}else r=t}return r}function $(e){var t;for(t in e)if((\"data\"!==t||!b.isEmptyObject(e[t]))&&\"toJSON\"!==t)return!1;return!0}b.extend({queue:function(e,n,r){var i;return e?(n=(n||\"fx\")+\"queue\",i=b._data(e,n),r&&(!i||b.isArray(r)?i=b._data(e,n,b.makeArray(r)):i.push(r)),i||[]):t},dequeue:function(e,t){t=t||\"fx\";var n=b.queue(e,t),r=n.length,i=n.shift(),o=b._queueHooks(e,t),a=function(){b.dequeue(e,t)};\"inprogress\"===i&&(i=n.shift(),r--),o.cur=i,i&&(\"fx\"===t&&n.unshift(\"inprogress\"),delete o.stop,i.call(e,a,o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+\"queueHooks\";return b._data(e,n)||b._data(e,n,{empty:b.Callbacks(\"once memory\").add(function(){b._removeData(e,t+\"queue\"),b._removeData(e,n)})})}}),b.fn.extend({queue:function(e,n){var r=2;return\"string\"!=typeof e&&(n=e,e=\"fx\",r--),r>arguments.length?b.queue(this[0],e):n===t?this:this.each(function(){var t=b.queue(this,e,n);b._queueHooks(this,e),\"fx\"===e&&\"inprogress\"!==t[0]&&b.dequeue(this,e)})},dequeue:function(e){return this.each(function(){b.dequeue(this,e)})},delay:function(e,t){return e=b.fx?b.fx.speeds[e]||e:e,t=t||\"fx\",this.queue(t,function(t,n){var r=setTimeout(t,e);n.stop=function(){clearTimeout(r)}})},clearQueue:function(e){return this.queue(e||\"fx\",[])},promise:function(e,n){var r,i=1,o=b.Deferred(),a=this,s=this.length,u=function(){--i||o.resolveWith(a,[a])};\"string\"!=typeof e&&(n=e,e=t),e=e||\"fx\";while(s--)r=b._data(a[s],e+\"queueHooks\"),r&&r.empty&&(i++,r.empty.add(u));return u(),o.promise(n)}});var I,z,X=/[\\t\\r\\n]/g,U=/\\r/g,V=/^(?:input|select|textarea|button|object)$/i,Y=/^(?:a|area)$/i,J=/^(?:checked|selected|autofocus|autoplay|async|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped)$/i,G=/^(?:checked|selected)$/i,Q=b.support.getSetAttribute,K=b.support.input;b.fn.extend({attr:function(e,t){return b.access(this,b.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){b.removeAttr(this,e)})},prop:function(e,t){return b.access(this,b.prop,e,t,arguments.length>1)},removeProp:function(e){return e=b.propFix[e]||e,this.each(function(){try{this[e]=t,delete this[e]}catch(n){}})},addClass:function(e){var t,n,r,i,o,a=0,s=this.length,u=\"string\"==typeof e&&e;if(b.isFunction(e))return this.each(function(t){b(this).addClass(e.call(this,t,this.className))});if(u)for(t=(e||\"\").match(w)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(\" \"+n.className+\" \").replace(X,\" \"):\" \")){o=0;while(i=t[o++])0>r.indexOf(\" \"+i+\" \")&&(r+=i+\" \");n.className=b.trim(r)}return this},removeClass:function(e){var t,n,r,i,o,a=0,s=this.length,u=0===arguments.length||\"string\"==typeof e&&e;if(b.isFunction(e))return this.each(function(t){b(this).removeClass(e.call(this,t,this.className))});if(u)for(t=(e||\"\").match(w)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(\" \"+n.className+\" \").replace(X,\" \"):\"\")){o=0;while(i=t[o++])while(r.indexOf(\" \"+i+\" \")>=0)r=r.replace(\" \"+i+\" \",\" \");n.className=e?b.trim(r):\"\"}return this},toggleClass:function(e,t){var n=typeof e,r=\"boolean\"==typeof t;return b.isFunction(e)?this.each(function(n){b(this).toggleClass(e.call(this,n,this.className,t),t)}):this.each(function(){if(\"string\"===n){var o,a=0,s=b(this),u=t,l=e.match(w)||[];while(o=l[a++])u=r?u:!s.hasClass(o),s[u?\"addClass\":\"removeClass\"](o)}else(n===i||\"boolean\"===n)&&(this.className&&b._data(this,\"__className__\",this.className),this.className=this.className||e===!1?\"\":b._data(this,\"__className__\")||\"\")})},hasClass:function(e){var t=\" \"+e+\" \",n=0,r=this.length;for(;r>n;n++)if(1===this[n].nodeType&&(\" \"+this[n].className+\" \").replace(X,\" \").indexOf(t)>=0)return!0;return!1},val:function(e){var n,r,i,o=this[0];{if(arguments.length)return i=b.isFunction(e),this.each(function(n){var o,a=b(this);1===this.nodeType&&(o=i?e.call(this,n,a.val()):e,null==o?o=\"\":\"number\"==typeof o?o+=\"\":b.isArray(o)&&(o=b.map(o,function(e){return null==e?\"\":e+\"\"})),r=b.valHooks[this.type]||b.valHooks[this.nodeName.toLowerCase()],r&&\"set\"in r&&r.set(this,o,\"value\")!==t||(this.value=o))});if(o)return r=b.valHooks[o.type]||b.valHooks[o.nodeName.toLowerCase()],r&&\"get\"in r&&(n=r.get(o,\"value\"))!==t?n:(n=o.value,\"string\"==typeof n?n.replace(U,\"\"):null==n?\"\":n)}}}),b.extend({valHooks:{option:{get:function(e){var t=e.attributes.value;return!t||t.specified?e.value:e.text}},select:{get:function(e){var t,n,r=e.options,i=e.selectedIndex,o=\"select-one\"===e.type||0>i,a=o?null:[],s=o?i+1:r.length,u=0>i?s:o?i:0;for(;s>u;u++)if(n=r[u],!(!n.selected&&u!==i||(b.support.optDisabled?n.disabled:null!==n.getAttribute(\"disabled\"))||n.parentNode.disabled&&b.nodeName(n.parentNode,\"optgroup\"))){if(t=b(n).val(),o)return t;a.push(t)}return a},set:function(e,t){var n=b.makeArray(t);return b(e).find(\"option\").each(function(){this.selected=b.inArray(b(this).val(),n)>=0}),n.length||(e.selectedIndex=-1),n}}},attr:function(e,n,r){var o,a,s,u=e.nodeType;if(e&&3!==u&&8!==u&&2!==u)return typeof e.getAttribute===i?b.prop(e,n,r):(a=1!==u||!b.isXMLDoc(e),a&&(n=n.toLowerCase(),o=b.attrHooks[n]||(J.test(n)?z:I)),r===t?o&&a&&\"get\"in o&&null!==(s=o.get(e,n))?s:(typeof e.getAttribute!==i&&(s=e.getAttribute(n)),null==s?t:s):null!==r?o&&a&&\"set\"in o&&(s=o.set(e,r,n))!==t?s:(e.setAttribute(n,r+\"\"),r):(b.removeAttr(e,n),t))},removeAttr:function(e,t){var n,r,i=0,o=t&&t.match(w);if(o&&1===e.nodeType)while(n=o[i++])r=b.propFix[n]||n,J.test(n)?!Q&&G.test(n)?e[b.camelCase(\"default-\"+n)]=e[r]=!1:e[r]=!1:b.attr(e,n,\"\"),e.removeAttribute(Q?n:r)},attrHooks:{type:{set:function(e,t){if(!b.support.radioValue&&\"radio\"===t&&b.nodeName(e,\"input\")){var n=e.value;return e.setAttribute(\"type\",t),n&&(e.value=n),t}}}},propFix:{tabindex:\"tabIndex\",readonly:\"readOnly\",\"for\":\"htmlFor\",\"class\":\"className\",maxlength:\"maxLength\",cellspacing:\"cellSpacing\",cellpadding:\"cellPadding\",rowspan:\"rowSpan\",colspan:\"colSpan\",usemap:\"useMap\",frameborder:\"frameBorder\",contenteditable:\"contentEditable\"},prop:function(e,n,r){var i,o,a,s=e.nodeType;if(e&&3!==s&&8!==s&&2!==s)return a=1!==s||!b.isXMLDoc(e),a&&(n=b.propFix[n]||n,o=b.propHooks[n]),r!==t?o&&\"set\"in o&&(i=o.set(e,r,n))!==t?i:e[n]=r:o&&\"get\"in o&&null!==(i=o.get(e,n))?i:e[n]},propHooks:{tabIndex:{get:function(e){var n=e.getAttributeNode(\"tabindex\");return n&&n.specified?parseInt(n.value,10):V.test(e.nodeName)||Y.test(e.nodeName)&&e.href?0:t}}}}),z={get:function(e,n){var r=b.prop(e,n),i=\"boolean\"==typeof r&&e.getAttribute(n),o=\"boolean\"==typeof r?K&&Q?null!=i:G.test(n)?e[b.camelCase(\"default-\"+n)]:!!i:e.getAttributeNode(n);return o&&o.value!==!1?n.toLowerCase():t},set:function(e,t,n){return t===!1?b.removeAttr(e,n):K&&Q||!G.test(n)?e.setAttribute(!Q&&b.propFix[n]||n,n):e[b.camelCase(\"default-\"+n)]=e[n]=!0,n}},K&&Q||(b.attrHooks.value={get:function(e,n){var r=e.getAttributeNode(n);return b.nodeName(e,\"input\")?e.defaultValue:r&&r.specified?r.value:t},set:function(e,n,r){return b.nodeName(e,\"input\")?(e.defaultValue=n,t):I&&I.set(e,n,r)}}),Q||(I=b.valHooks.button={get:function(e,n){var r=e.getAttributeNode(n);return r&&(\"id\"===n||\"name\"===n||\"coords\"===n?\"\"!==r.value:r.specified)?r.value:t},set:function(e,n,r){var i=e.getAttributeNode(r);return i||e.setAttributeNode(i=e.ownerDocument.createAttribute(r)),i.value=n+=\"\",\"value\"===r||n===e.getAttribute(r)?n:t}},b.attrHooks.contenteditable={get:I.get,set:function(e,t,n){I.set(e,\"\"===t?!1:t,n)}},b.each([\"width\",\"height\"],function(e,n){b.attrHooks[n]=b.extend(b.attrHooks[n],{set:function(e,r){return\"\"===r?(e.setAttribute(n,\"auto\"),r):t}})})),b.support.hrefNormalized||(b.each([\"href\",\"src\",\"width\",\"height\"],function(e,n){b.attrHooks[n]=b.extend(b.attrHooks[n],{get:function(e){var r=e.getAttribute(n,2);return null==r?t:r}})}),b.each([\"href\",\"src\"],function(e,t){b.propHooks[t]={get:function(e){return e.getAttribute(t,4)}}})),b.support.style||(b.attrHooks.style={get:function(e){return e.style.cssText||t},set:function(e,t){return e.style.cssText=t+\"\"}}),b.support.optSelected||(b.propHooks.selected=b.extend(b.propHooks.selected,{get:function(e){var t=e.parentNode;return t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex),null}})),b.support.enctype||(b.propFix.enctype=\"encoding\"),b.support.checkOn||b.each([\"radio\",\"checkbox\"],function(){b.valHooks[this]={get:function(e){return null===e.getAttribute(\"value\")?\"on\":e.value}}}),b.each([\"radio\",\"checkbox\"],function(){b.valHooks[this]=b.extend(b.valHooks[this],{set:function(e,n){return b.isArray(n)?e.checked=b.inArray(b(e).val(),n)>=0:t}})});var Z=/^(?:input|select|textarea)$/i,et=/^key/,tt=/^(?:mouse|contextmenu)|click/,nt=/^(?:focusinfocus|focusoutblur)$/,rt=/^([^.]*)(?:\\.(.+)|)$/;function it(){return!0}function ot(){return!1}b.event={global:{},add:function(e,n,r,o,a){var s,u,l,c,p,f,d,h,g,m,y,v=b._data(e);if(v){r.handler&&(c=r,r=c.handler,a=c.selector),r.guid||(r.guid=b.guid++),(u=v.events)||(u=v.events={}),(f=v.handle)||(f=v.handle=function(e){return typeof b===i||e&&b.event.triggered===e.type?t:b.event.dispatch.apply(f.elem,arguments)},f.elem=e),n=(n||\"\").match(w)||[\"\"],l=n.length;while(l--)s=rt.exec(n[l])||[],g=y=s[1],m=(s[2]||\"\").split(\".\").sort(),p=b.event.special[g]||{},g=(a?p.delegateType:p.bindType)||g,p=b.event.special[g]||{},d=b.extend({type:g,origType:y,data:o,handler:r,guid:r.guid,selector:a,needsContext:a&&b.expr.match.needsContext.test(a),namespace:m.join(\".\")},c),(h=u[g])||(h=u[g]=[],h.delegateCount=0,p.setup&&p.setup.call(e,o,m,f)!==!1||(e.addEventListener?e.addEventListener(g,f,!1):e.attachEvent&&e.attachEvent(\"on\"+g,f))),p.add&&(p.add.call(e,d),d.handler.guid||(d.handler.guid=r.guid)),a?h.splice(h.delegateCount++,0,d):h.push(d),b.event.global[g]=!0;e=null}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,p,f,d,h,g,m=b.hasData(e)&&b._data(e);if(m&&(c=m.events)){t=(t||\"\").match(w)||[\"\"],l=t.length;while(l--)if(s=rt.exec(t[l])||[],d=g=s[1],h=(s[2]||\"\").split(\".\").sort(),d){p=b.event.special[d]||{},d=(r?p.delegateType:p.bindType)||d,f=c[d]||[],s=s[2]&&RegExp(\"(^|\\\\.)\"+h.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"),u=o=f.length;while(o--)a=f[o],!i&&g!==a.origType||n&&n.guid!==a.guid||s&&!s.test(a.namespace)||r&&r!==a.selector&&(\"**\"!==r||!a.selector)||(f.splice(o,1),a.selector&&f.delegateCount--,p.remove&&p.remove.call(e,a));u&&!f.length&&(p.teardown&&p.teardown.call(e,h,m.handle)!==!1||b.removeEvent(e,d,m.handle),delete c[d])}else for(d in c)b.event.remove(e,d+t[l],n,r,!0);b.isEmptyObject(c)&&(delete m.handle,b._removeData(e,\"events\"))}},trigger:function(n,r,i,a){var s,u,l,c,p,f,d,h=[i||o],g=y.call(n,\"type\")?n.type:n,m=y.call(n,\"namespace\")?n.namespace.split(\".\"):[];if(l=f=i=i||o,3!==i.nodeType&&8!==i.nodeType&&!nt.test(g+b.event.triggered)&&(g.indexOf(\".\")>=0&&(m=g.split(\".\"),g=m.shift(),m.sort()),u=0>g.indexOf(\":\")&&\"on\"+g,n=n[b.expando]?n:new b.Event(g,\"object\"==typeof n&&n),n.isTrigger=!0,n.namespace=m.join(\".\"),n.namespace_re=n.namespace?RegExp(\"(^|\\\\.)\"+m.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"):null,n.result=t,n.target||(n.target=i),r=null==r?[n]:b.makeArray(r,[n]),p=b.event.special[g]||{},a||!p.trigger||p.trigger.apply(i,r)!==!1)){if(!a&&!p.noBubble&&!b.isWindow(i)){for(c=p.delegateType||g,nt.test(c+g)||(l=l.parentNode);l;l=l.parentNode)h.push(l),f=l;f===(i.ownerDocument||o)&&h.push(f.defaultView||f.parentWindow||e)}d=0;while((l=h[d++])&&!n.isPropagationStopped())n.type=d>1?c:p.bindType||g,s=(b._data(l,\"events\")||{})[n.type]&&b._data(l,\"handle\"),s&&s.apply(l,r),s=u&&l[u],s&&b.acceptData(l)&&s.apply&&s.apply(l,r)===!1&&n.preventDefault();if(n.type=g,!(a||n.isDefaultPrevented()||p._default&&p._default.apply(i.ownerDocument,r)!==!1||\"click\"===g&&b.nodeName(i,\"a\")||!b.acceptData(i)||!u||!i[g]||b.isWindow(i))){f=i[u],f&&(i[u]=null),b.event.triggered=g;try{i[g]()}catch(v){}b.event.triggered=t,f&&(i[u]=f)}return n.result}},dispatch:function(e){e=b.event.fix(e);var n,r,i,o,a,s=[],u=h.call(arguments),l=(b._data(this,\"events\")||{})[e.type]||[],c=b.event.special[e.type]||{};if(u[0]=e,e.delegateTarget=this,!c.preDispatch||c.preDispatch.call(this,e)!==!1){s=b.event.handlers.call(this,e,l),n=0;while((o=s[n++])&&!e.isPropagationStopped()){e.currentTarget=o.elem,a=0;while((i=o.handlers[a++])&&!e.isImmediatePropagationStopped())(!e.namespace_re||e.namespace_re.test(i.namespace))&&(e.handleObj=i,e.data=i.data,r=((b.event.special[i.origType]||{}).handle||i.handler).apply(o.elem,u),r!==t&&(e.result=r)===!1&&(e.preventDefault(),e.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,e),e.result}},handlers:function(e,n){var r,i,o,a,s=[],u=n.delegateCount,l=e.target;if(u&&l.nodeType&&(!e.button||\"click\"!==e.type))for(;l!=this;l=l.parentNode||this)if(1===l.nodeType&&(l.disabled!==!0||\"click\"!==e.type)){for(o=[],a=0;u>a;a++)i=n[a],r=i.selector+\" \",o[r]===t&&(o[r]=i.needsContext?b(r,this).index(l)>=0:b.find(r,this,null,[l]).length),o[r]&&o.push(i);o.length&&s.push({elem:l,handlers:o})}return n.length>u&&s.push({elem:this,handlers:n.slice(u)}),s},fix:function(e){if(e[b.expando])return e;var t,n,r,i=e.type,a=e,s=this.fixHooks[i];s||(this.fixHooks[i]=s=tt.test(i)?this.mouseHooks:et.test(i)?this.keyHooks:{}),r=s.props?this.props.concat(s.props):this.props,e=new b.Event(a),t=r.length;while(t--)n=r[t],e[n]=a[n];return e.target||(e.target=a.srcElement||o),3===e.target.nodeType&&(e.target=e.target.parentNode),e.metaKey=!!e.metaKey,s.filter?s.filter(e,a):e},props:\"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which\".split(\" \"),fixHooks:{},keyHooks:{props:\"char charCode key keyCode\".split(\" \"),filter:function(e,t){return null==e.which&&(e.which=null!=t.charCode?t.charCode:t.keyCode),e}},mouseHooks:{props:\"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement\".split(\" \"),filter:function(e,n){var r,i,a,s=n.button,u=n.fromElement;return null==e.pageX&&null!=n.clientX&&(i=e.target.ownerDocument||o,a=i.documentElement,r=i.body,e.pageX=n.clientX+(a&&a.scrollLeft||r&&r.scrollLeft||0)-(a&&a.clientLeft||r&&r.clientLeft||0),e.pageY=n.clientY+(a&&a.scrollTop||r&&r.scrollTop||0)-(a&&a.clientTop||r&&r.clientTop||0)),!e.relatedTarget&&u&&(e.relatedTarget=u===e.target?n.toElement:u),e.which||s===t||(e.which=1&s?1:2&s?3:4&s?2:0),e}},special:{load:{noBubble:!0},click:{trigger:function(){return b.nodeName(this,\"input\")&&\"checkbox\"===this.type&&this.click?(this.click(),!1):t}},focus:{trigger:function(){if(this!==o.activeElement&&this.focus)try{return this.focus(),!1}catch(e){}},delegateType:\"focusin\"},blur:{trigger:function(){return this===o.activeElement&&this.blur?(this.blur(),!1):t},delegateType:\"focusout\"},beforeunload:{postDispatch:function(e){e.result!==t&&(e.originalEvent.returnValue=e.result)}}},simulate:function(e,t,n,r){var i=b.extend(new b.Event,n,{type:e,isSimulated:!0,originalEvent:{}});r?b.event.trigger(i,null,t):b.event.dispatch.call(t,i),i.isDefaultPrevented()&&n.preventDefault()}},b.removeEvent=o.removeEventListener?function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n,!1)}:function(e,t,n){var r=\"on\"+t;e.detachEvent&&(typeof e[r]===i&&(e[r]=null),e.detachEvent(r,n))},b.Event=function(e,n){return this instanceof b.Event?(e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||e.returnValue===!1||e.getPreventDefault&&e.getPreventDefault()?it:ot):this.type=e,n&&b.extend(this,n),this.timeStamp=e&&e.timeStamp||b.now(),this[b.expando]=!0,t):new b.Event(e,n)},b.Event.prototype={isDefaultPrevented:ot,isPropagationStopped:ot,isImmediatePropagationStopped:ot,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=it,e&&(e.preventDefault?e.preventDefault():e.returnValue=!1)},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=it,e&&(e.stopPropagation&&e.stopPropagation(),e.cancelBubble=!0)},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=it,this.stopPropagation()}},b.each({mouseenter:\"mouseover\",mouseleave:\"mouseout\"},function(e,t){b.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;\nreturn(!i||i!==r&&!b.contains(r,i))&&(e.type=o.origType,n=o.handler.apply(this,arguments),e.type=t),n}}}),b.support.submitBubbles||(b.event.special.submit={setup:function(){return b.nodeName(this,\"form\")?!1:(b.event.add(this,\"click._submit keypress._submit\",function(e){var n=e.target,r=b.nodeName(n,\"input\")||b.nodeName(n,\"button\")?n.form:t;r&&!b._data(r,\"submitBubbles\")&&(b.event.add(r,\"submit._submit\",function(e){e._submit_bubble=!0}),b._data(r,\"submitBubbles\",!0))}),t)},postDispatch:function(e){e._submit_bubble&&(delete e._submit_bubble,this.parentNode&&!e.isTrigger&&b.event.simulate(\"submit\",this.parentNode,e,!0))},teardown:function(){return b.nodeName(this,\"form\")?!1:(b.event.remove(this,\"._submit\"),t)}}),b.support.changeBubbles||(b.event.special.change={setup:function(){return Z.test(this.nodeName)?((\"checkbox\"===this.type||\"radio\"===this.type)&&(b.event.add(this,\"propertychange._change\",function(e){\"checked\"===e.originalEvent.propertyName&&(this._just_changed=!0)}),b.event.add(this,\"click._change\",function(e){this._just_changed&&!e.isTrigger&&(this._just_changed=!1),b.event.simulate(\"change\",this,e,!0)})),!1):(b.event.add(this,\"beforeactivate._change\",function(e){var t=e.target;Z.test(t.nodeName)&&!b._data(t,\"changeBubbles\")&&(b.event.add(t,\"change._change\",function(e){!this.parentNode||e.isSimulated||e.isTrigger||b.event.simulate(\"change\",this.parentNode,e,!0)}),b._data(t,\"changeBubbles\",!0))}),t)},handle:function(e){var n=e.target;return this!==n||e.isSimulated||e.isTrigger||\"radio\"!==n.type&&\"checkbox\"!==n.type?e.handleObj.handler.apply(this,arguments):t},teardown:function(){return b.event.remove(this,\"._change\"),!Z.test(this.nodeName)}}),b.support.focusinBubbles||b.each({focus:\"focusin\",blur:\"focusout\"},function(e,t){var n=0,r=function(e){b.event.simulate(t,e.target,b.event.fix(e),!0)};b.event.special[t]={setup:function(){0===n++&&o.addEventListener(e,r,!0)},teardown:function(){0===--n&&o.removeEventListener(e,r,!0)}}}),b.fn.extend({on:function(e,n,r,i,o){var a,s;if(\"object\"==typeof e){\"string\"!=typeof n&&(r=r||n,n=t);for(a in e)this.on(a,n,r,e[a],o);return this}if(null==r&&null==i?(i=n,r=n=t):null==i&&(\"string\"==typeof n?(i=r,r=t):(i=r,r=n,n=t)),i===!1)i=ot;else if(!i)return this;return 1===o&&(s=i,i=function(e){return b().off(e),s.apply(this,arguments)},i.guid=s.guid||(s.guid=b.guid++)),this.each(function(){b.event.add(this,e,i,r,n)})},one:function(e,t,n,r){return this.on(e,t,n,r,1)},off:function(e,n,r){var i,o;if(e&&e.preventDefault&&e.handleObj)return i=e.handleObj,b(e.delegateTarget).off(i.namespace?i.origType+\".\"+i.namespace:i.origType,i.selector,i.handler),this;if(\"object\"==typeof e){for(o in e)this.off(o,n,e[o]);return this}return(n===!1||\"function\"==typeof n)&&(r=n,n=t),r===!1&&(r=ot),this.each(function(){b.event.remove(this,e,r,n)})},bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,\"**\"):this.off(t,e||\"**\",n)},trigger:function(e,t){return this.each(function(){b.event.trigger(e,t,this)})},triggerHandler:function(e,n){var r=this[0];return r?b.event.trigger(e,n,r,!0):t}}),function(e,t){var n,r,i,o,a,s,u,l,c,p,f,d,h,g,m,y,v,x=\"sizzle\"+-new Date,w=e.document,T={},N=0,C=0,k=it(),E=it(),S=it(),A=typeof t,j=1<<31,D=[],L=D.pop,H=D.push,q=D.slice,M=D.indexOf||function(e){var t=0,n=this.length;for(;n>t;t++)if(this[t]===e)return t;return-1},_=\"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",F=\"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",O=F.replace(\"w\",\"w#\"),B=\"([*^$|!~]?=)\",P=\"\\\\[\"+_+\"*(\"+F+\")\"+_+\"*(?:\"+B+_+\"*(?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|(\"+O+\")|)|)\"+_+\"*\\\\]\",R=\":(\"+F+\")(?:\\\\(((['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\"+P.replace(3,8)+\")*)|.*)\\\\)|)\",W=RegExp(\"^\"+_+\"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\"+_+\"+$\",\"g\"),$=RegExp(\"^\"+_+\"*,\"+_+\"*\"),I=RegExp(\"^\"+_+\"*([\\\\x20\\\\t\\\\r\\\\n\\\\f>+~])\"+_+\"*\"),z=RegExp(R),X=RegExp(\"^\"+O+\"$\"),U={ID:RegExp(\"^#(\"+F+\")\"),CLASS:RegExp(\"^\\\\.(\"+F+\")\"),NAME:RegExp(\"^\\\\[name=['\\\"]?(\"+F+\")['\\\"]?\\\\]\"),TAG:RegExp(\"^(\"+F.replace(\"w\",\"w*\")+\")\"),ATTR:RegExp(\"^\"+P),PSEUDO:RegExp(\"^\"+R),CHILD:RegExp(\"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\"+_+\"*(even|odd|(([+-]|)(\\\\d*)n|)\"+_+\"*(?:([+-]|)\"+_+\"*(\\\\d+)|))\"+_+\"*\\\\)|)\",\"i\"),needsContext:RegExp(\"^\"+_+\"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\"+_+\"*((?:-\\\\d)?\\\\d*)\"+_+\"*\\\\)|)(?=[^-]|$)\",\"i\")},V=/[\\x20\\t\\r\\n\\f]*[+~]/,Y=/^[^{]+\\{\\s*\\[native code/,J=/^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,G=/^(?:input|select|textarea|button)$/i,Q=/^h\\d$/i,K=/'|\\\\/g,Z=/\\=[\\x20\\t\\r\\n\\f]*([^'\"\\]]*)[\\x20\\t\\r\\n\\f]*\\]/g,et=/\\\\([\\da-fA-F]{1,6}[\\x20\\t\\r\\n\\f]?|.)/g,tt=function(e,t){var n=\"0x\"+t-65536;return n!==n?t:0>n?String.fromCharCode(n+65536):String.fromCharCode(55296|n>>10,56320|1023&n)};try{q.call(w.documentElement.childNodes,0)[0].nodeType}catch(nt){q=function(e){var t,n=[];while(t=this[e++])n.push(t);return n}}function rt(e){return Y.test(e+\"\")}function it(){var e,t=[];return e=function(n,r){return t.push(n+=\" \")>i.cacheLength&&delete e[t.shift()],e[n]=r}}function ot(e){return e[x]=!0,e}function at(e){var t=p.createElement(\"div\");try{return e(t)}catch(n){return!1}finally{t=null}}function st(e,t,n,r){var i,o,a,s,u,l,f,g,m,v;if((t?t.ownerDocument||t:w)!==p&&c(t),t=t||p,n=n||[],!e||\"string\"!=typeof e)return n;if(1!==(s=t.nodeType)&&9!==s)return[];if(!d&&!r){if(i=J.exec(e))if(a=i[1]){if(9===s){if(o=t.getElementById(a),!o||!o.parentNode)return n;if(o.id===a)return n.push(o),n}else if(t.ownerDocument&&(o=t.ownerDocument.getElementById(a))&&y(t,o)&&o.id===a)return n.push(o),n}else{if(i[2])return H.apply(n,q.call(t.getElementsByTagName(e),0)),n;if((a=i[3])&&T.getByClassName&&t.getElementsByClassName)return H.apply(n,q.call(t.getElementsByClassName(a),0)),n}if(T.qsa&&!h.test(e)){if(f=!0,g=x,m=t,v=9===s&&e,1===s&&\"object\"!==t.nodeName.toLowerCase()){l=ft(e),(f=t.getAttribute(\"id\"))?g=f.replace(K,\"\\\\$&\"):t.setAttribute(\"id\",g),g=\"[id='\"+g+\"'] \",u=l.length;while(u--)l[u]=g+dt(l[u]);m=V.test(e)&&t.parentNode||t,v=l.join(\",\")}if(v)try{return H.apply(n,q.call(m.querySelectorAll(v),0)),n}catch(b){}finally{f||t.removeAttribute(\"id\")}}}return wt(e.replace(W,\"$1\"),t,n,r)}a=st.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return t?\"HTML\"!==t.nodeName:!1},c=st.setDocument=function(e){var n=e?e.ownerDocument||e:w;return n!==p&&9===n.nodeType&&n.documentElement?(p=n,f=n.documentElement,d=a(n),T.tagNameNoComments=at(function(e){return e.appendChild(n.createComment(\"\")),!e.getElementsByTagName(\"*\").length}),T.attributes=at(function(e){e.innerHTML=\"<select></select>\";var t=typeof e.lastChild.getAttribute(\"multiple\");return\"boolean\"!==t&&\"string\"!==t}),T.getByClassName=at(function(e){return e.innerHTML=\"<div class='hidden e'></div><div class='hidden'></div>\",e.getElementsByClassName&&e.getElementsByClassName(\"e\").length?(e.lastChild.className=\"e\",2===e.getElementsByClassName(\"e\").length):!1}),T.getByName=at(function(e){e.id=x+0,e.innerHTML=\"<a name='\"+x+\"'></a><div name='\"+x+\"'></div>\",f.insertBefore(e,f.firstChild);var t=n.getElementsByName&&n.getElementsByName(x).length===2+n.getElementsByName(x+0).length;return T.getIdNotName=!n.getElementById(x),f.removeChild(e),t}),i.attrHandle=at(function(e){return e.innerHTML=\"<a href='#'></a>\",e.firstChild&&typeof e.firstChild.getAttribute!==A&&\"#\"===e.firstChild.getAttribute(\"href\")})?{}:{href:function(e){return e.getAttribute(\"href\",2)},type:function(e){return e.getAttribute(\"type\")}},T.getIdNotName?(i.find.ID=function(e,t){if(typeof t.getElementById!==A&&!d){var n=t.getElementById(e);return n&&n.parentNode?[n]:[]}},i.filter.ID=function(e){var t=e.replace(et,tt);return function(e){return e.getAttribute(\"id\")===t}}):(i.find.ID=function(e,n){if(typeof n.getElementById!==A&&!d){var r=n.getElementById(e);return r?r.id===e||typeof r.getAttributeNode!==A&&r.getAttributeNode(\"id\").value===e?[r]:t:[]}},i.filter.ID=function(e){var t=e.replace(et,tt);return function(e){var n=typeof e.getAttributeNode!==A&&e.getAttributeNode(\"id\");return n&&n.value===t}}),i.find.TAG=T.tagNameNoComments?function(e,n){return typeof n.getElementsByTagName!==A?n.getElementsByTagName(e):t}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if(\"*\"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},i.find.NAME=T.getByName&&function(e,n){return typeof n.getElementsByName!==A?n.getElementsByName(name):t},i.find.CLASS=T.getByClassName&&function(e,n){return typeof n.getElementsByClassName===A||d?t:n.getElementsByClassName(e)},g=[],h=[\":focus\"],(T.qsa=rt(n.querySelectorAll))&&(at(function(e){e.innerHTML=\"<select><option selected=''></option></select>\",e.querySelectorAll(\"[selected]\").length||h.push(\"\\\\[\"+_+\"*(?:checked|disabled|ismap|multiple|readonly|selected|value)\"),e.querySelectorAll(\":checked\").length||h.push(\":checked\")}),at(function(e){e.innerHTML=\"<input type='hidden' i=''/>\",e.querySelectorAll(\"[i^='']\").length&&h.push(\"[*^$]=\"+_+\"*(?:\\\"\\\"|'')\"),e.querySelectorAll(\":enabled\").length||h.push(\":enabled\",\":disabled\"),e.querySelectorAll(\"*,:x\"),h.push(\",.*:\")})),(T.matchesSelector=rt(m=f.matchesSelector||f.mozMatchesSelector||f.webkitMatchesSelector||f.oMatchesSelector||f.msMatchesSelector))&&at(function(e){T.disconnectedMatch=m.call(e,\"div\"),m.call(e,\"[s!='']:x\"),g.push(\"!=\",R)}),h=RegExp(h.join(\"|\")),g=RegExp(g.join(\"|\")),y=rt(f.contains)||f.compareDocumentPosition?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},v=f.compareDocumentPosition?function(e,t){var r;return e===t?(u=!0,0):(r=t.compareDocumentPosition&&e.compareDocumentPosition&&e.compareDocumentPosition(t))?1&r||e.parentNode&&11===e.parentNode.nodeType?e===n||y(w,e)?-1:t===n||y(w,t)?1:0:4&r?-1:1:e.compareDocumentPosition?-1:1}:function(e,t){var r,i=0,o=e.parentNode,a=t.parentNode,s=[e],l=[t];if(e===t)return u=!0,0;if(!o||!a)return e===n?-1:t===n?1:o?-1:a?1:0;if(o===a)return ut(e,t);r=e;while(r=r.parentNode)s.unshift(r);r=t;while(r=r.parentNode)l.unshift(r);while(s[i]===l[i])i++;return i?ut(s[i],l[i]):s[i]===w?-1:l[i]===w?1:0},u=!1,[0,0].sort(v),T.detectDuplicates=u,p):p},st.matches=function(e,t){return st(e,null,null,t)},st.matchesSelector=function(e,t){if((e.ownerDocument||e)!==p&&c(e),t=t.replace(Z,\"='$1']\"),!(!T.matchesSelector||d||g&&g.test(t)||h.test(t)))try{var n=m.call(e,t);if(n||T.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(r){}return st(t,p,null,[e]).length>0},st.contains=function(e,t){return(e.ownerDocument||e)!==p&&c(e),y(e,t)},st.attr=function(e,t){var n;return(e.ownerDocument||e)!==p&&c(e),d||(t=t.toLowerCase()),(n=i.attrHandle[t])?n(e):d||T.attributes?e.getAttribute(t):((n=e.getAttributeNode(t))||e.getAttribute(t))&&e[t]===!0?t:n&&n.specified?n.value:null},st.error=function(e){throw Error(\"Syntax error, unrecognized expression: \"+e)},st.uniqueSort=function(e){var t,n=[],r=1,i=0;if(u=!T.detectDuplicates,e.sort(v),u){for(;t=e[r];r++)t===e[r-1]&&(i=n.push(r));while(i--)e.splice(n[i],1)}return e};function ut(e,t){var n=t&&e,r=n&&(~t.sourceIndex||j)-(~e.sourceIndex||j);if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function lt(e){return function(t){var n=t.nodeName.toLowerCase();return\"input\"===n&&t.type===e}}function ct(e){return function(t){var n=t.nodeName.toLowerCase();return(\"input\"===n||\"button\"===n)&&t.type===e}}function pt(e){return ot(function(t){return t=+t,ot(function(n,r){var i,o=e([],n.length,t),a=o.length;while(a--)n[i=o[a]]&&(n[i]=!(r[i]=n[i]))})})}o=st.getText=function(e){var t,n=\"\",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if(\"string\"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else for(;t=e[r];r++)n+=o(t);return n},i=st.selectors={cacheLength:50,createPseudo:ot,match:U,find:{},relative:{\">\":{dir:\"parentNode\",first:!0},\" \":{dir:\"parentNode\"},\"+\":{dir:\"previousSibling\",first:!0},\"~\":{dir:\"previousSibling\"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(et,tt),e[3]=(e[4]||e[5]||\"\").replace(et,tt),\"~=\"===e[2]&&(e[3]=\" \"+e[3]+\" \"),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),\"nth\"===e[1].slice(0,3)?(e[3]||st.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*(\"even\"===e[3]||\"odd\"===e[3])),e[5]=+(e[7]+e[8]||\"odd\"===e[3])):e[3]&&st.error(e[0]),e},PSEUDO:function(e){var t,n=!e[5]&&e[2];return U.CHILD.test(e[0])?null:(e[4]?e[2]=e[4]:n&&z.test(n)&&(t=ft(n,!0))&&(t=n.indexOf(\")\",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){return\"*\"===e?function(){return!0}:(e=e.replace(et,tt).toLowerCase(),function(t){return t.nodeName&&t.nodeName.toLowerCase()===e})},CLASS:function(e){var t=k[e+\" \"];return t||(t=RegExp(\"(^|\"+_+\")\"+e+\"(\"+_+\"|$)\"))&&k(e,function(e){return t.test(e.className||typeof e.getAttribute!==A&&e.getAttribute(\"class\")||\"\")})},ATTR:function(e,t,n){return function(r){var i=st.attr(r,e);return null==i?\"!=\"===t:t?(i+=\"\",\"=\"===t?i===n:\"!=\"===t?i!==n:\"^=\"===t?n&&0===i.indexOf(n):\"*=\"===t?n&&i.indexOf(n)>-1:\"$=\"===t?n&&i.slice(-n.length)===n:\"~=\"===t?(\" \"+i+\" \").indexOf(n)>-1:\"|=\"===t?i===n||i.slice(0,n.length+1)===n+\"-\":!1):!0}},CHILD:function(e,t,n,r,i){var o=\"nth\"!==e.slice(0,3),a=\"last\"!==e.slice(-4),s=\"of-type\"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,u){var l,c,p,f,d,h,g=o!==a?\"nextSibling\":\"previousSibling\",m=t.parentNode,y=s&&t.nodeName.toLowerCase(),v=!u&&!s;if(m){if(o){while(g){p=t;while(p=p[g])if(s?p.nodeName.toLowerCase()===y:1===p.nodeType)return!1;h=g=\"only\"===e&&!h&&\"nextSibling\"}return!0}if(h=[a?m.firstChild:m.lastChild],a&&v){c=m[x]||(m[x]={}),l=c[e]||[],d=l[0]===N&&l[1],f=l[0]===N&&l[2],p=d&&m.childNodes[d];while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if(1===p.nodeType&&++f&&p===t){c[e]=[N,d,f];break}}else if(v&&(l=(t[x]||(t[x]={}))[e])&&l[0]===N)f=l[1];else while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if((s?p.nodeName.toLowerCase()===y:1===p.nodeType)&&++f&&(v&&((p[x]||(p[x]={}))[e]=[N,f]),p===t))break;return f-=i,f===r||0===f%r&&f/r>=0}}},PSEUDO:function(e,t){var n,r=i.pseudos[e]||i.setFilters[e.toLowerCase()]||st.error(\"unsupported pseudo: \"+e);return r[x]?r(t):r.length>1?(n=[e,e,\"\",t],i.setFilters.hasOwnProperty(e.toLowerCase())?ot(function(e,n){var i,o=r(e,t),a=o.length;while(a--)i=M.call(e,o[a]),e[i]=!(n[i]=o[a])}):function(e){return r(e,0,n)}):r}},pseudos:{not:ot(function(e){var t=[],n=[],r=s(e.replace(W,\"$1\"));return r[x]?ot(function(e,t,n,i){var o,a=r(e,null,i,[]),s=e.length;while(s--)(o=a[s])&&(e[s]=!(t[s]=o))}):function(e,i,o){return t[0]=e,r(t,null,o,n),!n.pop()}}),has:ot(function(e){return function(t){return st(e,t).length>0}}),contains:ot(function(e){return function(t){return(t.textContent||t.innerText||o(t)).indexOf(e)>-1}}),lang:ot(function(e){return X.test(e||\"\")||st.error(\"unsupported lang: \"+e),e=e.replace(et,tt).toLowerCase(),function(t){var n;do if(n=d?t.getAttribute(\"xml:lang\")||t.getAttribute(\"lang\"):t.lang)return n=n.toLowerCase(),n===e||0===n.indexOf(e+\"-\");while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===f},focus:function(e){return e===p.activeElement&&(!p.hasFocus||p.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:function(e){return e.disabled===!1},disabled:function(e){return e.disabled===!0},checked:function(e){var t=e.nodeName.toLowerCase();return\"input\"===t&&!!e.checked||\"option\"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,e.selected===!0},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeName>\"@\"||3===e.nodeType||4===e.nodeType)return!1;return!0},parent:function(e){return!i.pseudos.empty(e)},header:function(e){return Q.test(e.nodeName)},input:function(e){return G.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return\"input\"===t&&\"button\"===e.type||\"button\"===t},text:function(e){var t;return\"input\"===e.nodeName.toLowerCase()&&\"text\"===e.type&&(null==(t=e.getAttribute(\"type\"))||t.toLowerCase()===e.type)},first:pt(function(){return[0]}),last:pt(function(e,t){return[t-1]}),eq:pt(function(e,t,n){return[0>n?n+t:n]}),even:pt(function(e,t){var n=0;for(;t>n;n+=2)e.push(n);return e}),odd:pt(function(e,t){var n=1;for(;t>n;n+=2)e.push(n);return e}),lt:pt(function(e,t,n){var r=0>n?n+t:n;for(;--r>=0;)e.push(r);return e}),gt:pt(function(e,t,n){var r=0>n?n+t:n;for(;t>++r;)e.push(r);return e})}};for(n in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})i.pseudos[n]=lt(n);for(n in{submit:!0,reset:!0})i.pseudos[n]=ct(n);function ft(e,t){var n,r,o,a,s,u,l,c=E[e+\" \"];if(c)return t?0:c.slice(0);s=e,u=[],l=i.preFilter;while(s){(!n||(r=$.exec(s)))&&(r&&(s=s.slice(r[0].length)||s),u.push(o=[])),n=!1,(r=I.exec(s))&&(n=r.shift(),o.push({value:n,type:r[0].replace(W,\" \")}),s=s.slice(n.length));for(a in i.filter)!(r=U[a].exec(s))||l[a]&&!(r=l[a](r))||(n=r.shift(),o.push({value:n,type:a,matches:r}),s=s.slice(n.length));if(!n)break}return t?s.length:s?st.error(e):E(e,u).slice(0)}function dt(e){var t=0,n=e.length,r=\"\";for(;n>t;t++)r+=e[t].value;return r}function ht(e,t,n){var i=t.dir,o=n&&\"parentNode\"===i,a=C++;return t.first?function(t,n,r){while(t=t[i])if(1===t.nodeType||o)return e(t,n,r)}:function(t,n,s){var u,l,c,p=N+\" \"+a;if(s){while(t=t[i])if((1===t.nodeType||o)&&e(t,n,s))return!0}else while(t=t[i])if(1===t.nodeType||o)if(c=t[x]||(t[x]={}),(l=c[i])&&l[0]===p){if((u=l[1])===!0||u===r)return u===!0}else if(l=c[i]=[p],l[1]=e(t,n,s)||r,l[1]===!0)return!0}}function gt(e){return e.length>1?function(t,n,r){var i=e.length;while(i--)if(!e[i](t,n,r))return!1;return!0}:e[0]}function mt(e,t,n,r,i){var o,a=[],s=0,u=e.length,l=null!=t;for(;u>s;s++)(o=e[s])&&(!n||n(o,r,i))&&(a.push(o),l&&t.push(s));return a}function yt(e,t,n,r,i,o){return r&&!r[x]&&(r=yt(r)),i&&!i[x]&&(i=yt(i,o)),ot(function(o,a,s,u){var l,c,p,f=[],d=[],h=a.length,g=o||xt(t||\"*\",s.nodeType?[s]:s,[]),m=!e||!o&&t?g:mt(g,f,e,s,u),y=n?i||(o?e:h||r)?[]:a:m;if(n&&n(m,y,s,u),r){l=mt(y,d),r(l,[],s,u),c=l.length;while(c--)(p=l[c])&&(y[d[c]]=!(m[d[c]]=p))}if(o){if(i||e){if(i){l=[],c=y.length;while(c--)(p=y[c])&&l.push(m[c]=p);i(null,y=[],l,u)}c=y.length;while(c--)(p=y[c])&&(l=i?M.call(o,p):f[c])>-1&&(o[l]=!(a[l]=p))}}else y=mt(y===a?y.splice(h,y.length):y),i?i(null,a,y,u):H.apply(a,y)})}function vt(e){var t,n,r,o=e.length,a=i.relative[e[0].type],s=a||i.relative[\" \"],u=a?1:0,c=ht(function(e){return e===t},s,!0),p=ht(function(e){return M.call(t,e)>-1},s,!0),f=[function(e,n,r){return!a&&(r||n!==l)||((t=n).nodeType?c(e,n,r):p(e,n,r))}];for(;o>u;u++)if(n=i.relative[e[u].type])f=[ht(gt(f),n)];else{if(n=i.filter[e[u].type].apply(null,e[u].matches),n[x]){for(r=++u;o>r;r++)if(i.relative[e[r].type])break;return yt(u>1&&gt(f),u>1&&dt(e.slice(0,u-1)).replace(W,\"$1\"),n,r>u&&vt(e.slice(u,r)),o>r&&vt(e=e.slice(r)),o>r&&dt(e))}f.push(n)}return gt(f)}function bt(e,t){var n=0,o=t.length>0,a=e.length>0,s=function(s,u,c,f,d){var h,g,m,y=[],v=0,b=\"0\",x=s&&[],w=null!=d,T=l,C=s||a&&i.find.TAG(\"*\",d&&u.parentNode||u),k=N+=null==T?1:Math.random()||.1;for(w&&(l=u!==p&&u,r=n);null!=(h=C[b]);b++){if(a&&h){g=0;while(m=e[g++])if(m(h,u,c)){f.push(h);break}w&&(N=k,r=++n)}o&&((h=!m&&h)&&v--,s&&x.push(h))}if(v+=b,o&&b!==v){g=0;while(m=t[g++])m(x,y,u,c);if(s){if(v>0)while(b--)x[b]||y[b]||(y[b]=L.call(f));y=mt(y)}H.apply(f,y),w&&!s&&y.length>0&&v+t.length>1&&st.uniqueSort(f)}return w&&(N=k,l=T),x};return o?ot(s):s}s=st.compile=function(e,t){var n,r=[],i=[],o=S[e+\" \"];if(!o){t||(t=ft(e)),n=t.length;while(n--)o=vt(t[n]),o[x]?r.push(o):i.push(o);o=S(e,bt(i,r))}return o};function xt(e,t,n){var r=0,i=t.length;for(;i>r;r++)st(e,t[r],n);return n}function wt(e,t,n,r){var o,a,u,l,c,p=ft(e);if(!r&&1===p.length){if(a=p[0]=p[0].slice(0),a.length>2&&\"ID\"===(u=a[0]).type&&9===t.nodeType&&!d&&i.relative[a[1].type]){if(t=i.find.ID(u.matches[0].replace(et,tt),t)[0],!t)return n;e=e.slice(a.shift().value.length)}o=U.needsContext.test(e)?0:a.length;while(o--){if(u=a[o],i.relative[l=u.type])break;if((c=i.find[l])&&(r=c(u.matches[0].replace(et,tt),V.test(a[0].type)&&t.parentNode||t))){if(a.splice(o,1),e=r.length&&dt(a),!e)return H.apply(n,q.call(r,0)),n;break}}}return s(e,p)(r,t,d,n,V.test(e)),n}i.pseudos.nth=i.pseudos.eq;function Tt(){}i.filters=Tt.prototype=i.pseudos,i.setFilters=new Tt,c(),st.attr=b.attr,b.find=st,b.expr=st.selectors,b.expr[\":\"]=b.expr.pseudos,b.unique=st.uniqueSort,b.text=st.getText,b.isXMLDoc=st.isXML,b.contains=st.contains}(e);var at=/Until$/,st=/^(?:parents|prev(?:Until|All))/,ut=/^.[^:#\\[\\.,]*$/,lt=b.expr.match.needsContext,ct={children:!0,contents:!0,next:!0,prev:!0};b.fn.extend({find:function(e){var t,n,r,i=this.length;if(\"string\"!=typeof e)return r=this,this.pushStack(b(e).filter(function(){for(t=0;i>t;t++)if(b.contains(r[t],this))return!0}));for(n=[],t=0;i>t;t++)b.find(e,this[t],n);return n=this.pushStack(i>1?b.unique(n):n),n.selector=(this.selector?this.selector+\" \":\"\")+e,n},has:function(e){var t,n=b(e,this),r=n.length;return this.filter(function(){for(t=0;r>t;t++)if(b.contains(this,n[t]))return!0})},not:function(e){return this.pushStack(ft(this,e,!1))},filter:function(e){return this.pushStack(ft(this,e,!0))},is:function(e){return!!e&&(\"string\"==typeof e?lt.test(e)?b(e,this.context).index(this[0])>=0:b.filter(e,this).length>0:this.filter(e).length>0)},closest:function(e,t){var n,r=0,i=this.length,o=[],a=lt.test(e)||\"string\"!=typeof e?b(e,t||this.context):0;for(;i>r;r++){n=this[r];while(n&&n.ownerDocument&&n!==t&&11!==n.nodeType){if(a?a.index(n)>-1:b.find.matchesSelector(n,e)){o.push(n);break}n=n.parentNode}}return this.pushStack(o.length>1?b.unique(o):o)},index:function(e){return e?\"string\"==typeof e?b.inArray(this[0],b(e)):b.inArray(e.jquery?e[0]:e,this):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){var n=\"string\"==typeof e?b(e,t):b.makeArray(e&&e.nodeType?[e]:e),r=b.merge(this.get(),n);return this.pushStack(b.unique(r))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),b.fn.andSelf=b.fn.addBack;function pt(e,t){do e=e[t];while(e&&1!==e.nodeType);return e}b.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return b.dir(e,\"parentNode\")},parentsUntil:function(e,t,n){return b.dir(e,\"parentNode\",n)},next:function(e){return pt(e,\"nextSibling\")},prev:function(e){return pt(e,\"previousSibling\")},nextAll:function(e){return b.dir(e,\"nextSibling\")},prevAll:function(e){return b.dir(e,\"previousSibling\")},nextUntil:function(e,t,n){return b.dir(e,\"nextSibling\",n)},prevUntil:function(e,t,n){return b.dir(e,\"previousSibling\",n)},siblings:function(e){return b.sibling((e.parentNode||{}).firstChild,e)},children:function(e){return b.sibling(e.firstChild)},contents:function(e){return b.nodeName(e,\"iframe\")?e.contentDocument||e.contentWindow.document:b.merge([],e.childNodes)}},function(e,t){b.fn[e]=function(n,r){var i=b.map(this,t,n);return at.test(e)||(r=n),r&&\"string\"==typeof r&&(i=b.filter(r,i)),i=this.length>1&&!ct[e]?b.unique(i):i,this.length>1&&st.test(e)&&(i=i.reverse()),this.pushStack(i)}}),b.extend({filter:function(e,t,n){return n&&(e=\":not(\"+e+\")\"),1===t.length?b.find.matchesSelector(t[0],e)?[t[0]]:[]:b.find.matches(e,t)},dir:function(e,n,r){var i=[],o=e[n];while(o&&9!==o.nodeType&&(r===t||1!==o.nodeType||!b(o).is(r)))1===o.nodeType&&i.push(o),o=o[n];return i},sibling:function(e,t){var n=[];for(;e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n}});function ft(e,t,n){if(t=t||0,b.isFunction(t))return b.grep(e,function(e,r){var i=!!t.call(e,r,e);return i===n});if(t.nodeType)return b.grep(e,function(e){return e===t===n});if(\"string\"==typeof t){var r=b.grep(e,function(e){return 1===e.nodeType});if(ut.test(t))return b.filter(t,r,!n);t=b.filter(t,r)}return b.grep(e,function(e){return b.inArray(e,t)>=0===n})}function dt(e){var t=ht.split(\"|\"),n=e.createDocumentFragment();if(n.createElement)while(t.length)n.createElement(t.pop());return n}var ht=\"abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video\",gt=/ jQuery\\d+=\"(?:null|\\d+)\"/g,mt=RegExp(\"<(?:\"+ht+\")[\\\\s/>]\",\"i\"),yt=/^\\s+/,vt=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:]+)[^>]*)\\/>/gi,bt=/<([\\w:]+)/,xt=/<tbody/i,wt=/<|&#?\\w+;/,Tt=/<(?:script|style|link)/i,Nt=/^(?:checkbox|radio)$/i,Ct=/checked\\s*(?:[^=]|=\\s*.checked.)/i,kt=/^$|\\/(?:java|ecma)script/i,Et=/^true\\/(.*)/,St=/^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g,At={option:[1,\"<select multiple='multiple'>\",\"</select>\"],legend:[1,\"<fieldset>\",\"</fieldset>\"],area:[1,\"<map>\",\"</map>\"],param:[1,\"<object>\",\"</object>\"],thead:[1,\"<table>\",\"</table>\"],tr:[2,\"<table><tbody>\",\"</tbody></table>\"],col:[2,\"<table><tbody></tbody><colgroup>\",\"</colgroup></table>\"],td:[3,\"<table><tbody><tr>\",\"</tr></tbody></table>\"],_default:b.support.htmlSerialize?[0,\"\",\"\"]:[1,\"X<div>\",\"</div>\"]},jt=dt(o),Dt=jt.appendChild(o.createElement(\"div\"));At.optgroup=At.option,At.tbody=At.tfoot=At.colgroup=At.caption=At.thead,At.th=At.td,b.fn.extend({text:function(e){return b.access(this,function(e){return e===t?b.text(this):this.empty().append((this[0]&&this[0].ownerDocument||o).createTextNode(e))},null,e,arguments.length)},wrapAll:function(e){if(b.isFunction(e))return this.each(function(t){b(this).wrapAll(e.call(this,t))});if(this[0]){var t=b(e,this[0].ownerDocument).eq(0).clone(!0);this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstChild&&1===e.firstChild.nodeType)e=e.firstChild;return e}).append(this)}return this},wrapInner:function(e){return b.isFunction(e)?this.each(function(t){b(this).wrapInner(e.call(this,t))}):this.each(function(){var t=b(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=b.isFunction(e);return this.each(function(n){b(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(){return this.parent().each(function(){b.nodeName(this,\"body\")||b(this).replaceWith(this.childNodes)}).end()},append:function(){return this.domManip(arguments,!0,function(e){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&this.appendChild(e)})},prepend:function(){return this.domManip(arguments,!0,function(e){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&this.insertBefore(e,this.firstChild)})},before:function(){return this.domManip(arguments,!1,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return this.domManip(arguments,!1,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},remove:function(e,t){var n,r=0;for(;null!=(n=this[r]);r++)(!e||b.filter(e,[n]).length>0)&&(t||1!==n.nodeType||b.cleanData(Ot(n)),n.parentNode&&(t&&b.contains(n.ownerDocument,n)&&Mt(Ot(n,\"script\")),n.parentNode.removeChild(n)));return this},empty:function(){var e,t=0;for(;null!=(e=this[t]);t++){1===e.nodeType&&b.cleanData(Ot(e,!1));while(e.firstChild)e.removeChild(e.firstChild);e.options&&b.nodeName(e,\"select\")&&(e.options.length=0)}return this},clone:function(e,t){return e=null==e?!1:e,t=null==t?e:t,this.map(function(){return b.clone(this,e,t)})},html:function(e){return b.access(this,function(e){var n=this[0]||{},r=0,i=this.length;if(e===t)return 1===n.nodeType?n.innerHTML.replace(gt,\"\"):t;if(!(\"string\"!=typeof e||Tt.test(e)||!b.support.htmlSerialize&&mt.test(e)||!b.support.leadingWhitespace&&yt.test(e)||At[(bt.exec(e)||[\"\",\"\"])[1].toLowerCase()])){e=e.replace(vt,\"<$1></$2>\");try{for(;i>r;r++)n=this[r]||{},1===n.nodeType&&(b.cleanData(Ot(n,!1)),n.innerHTML=e);n=0}catch(o){}}n&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(e){var t=b.isFunction(e);return t||\"string\"==typeof e||(e=b(e).not(this).detach()),this.domManip([e],!0,function(e){var t=this.nextSibling,n=this.parentNode;n&&(b(this).remove(),n.insertBefore(e,t))})},detach:function(e){return this.remove(e,!0)},domManip:function(e,n,r){e=f.apply([],e);var i,o,a,s,u,l,c=0,p=this.length,d=this,h=p-1,g=e[0],m=b.isFunction(g);if(m||!(1>=p||\"string\"!=typeof g||b.support.checkClone)&&Ct.test(g))return this.each(function(i){var o=d.eq(i);m&&(e[0]=g.call(this,i,n?o.html():t)),o.domManip(e,n,r)});if(p&&(l=b.buildFragment(e,this[0].ownerDocument,!1,this),i=l.firstChild,1===l.childNodes.length&&(l=i),i)){for(n=n&&b.nodeName(i,\"tr\"),s=b.map(Ot(l,\"script\"),Ht),a=s.length;p>c;c++)o=l,c!==h&&(o=b.clone(o,!0,!0),a&&b.merge(s,Ot(o,\"script\"))),r.call(n&&b.nodeName(this[c],\"table\")?Lt(this[c],\"tbody\"):this[c],o,c);if(a)for(u=s[s.length-1].ownerDocument,b.map(s,qt),c=0;a>c;c++)o=s[c],kt.test(o.type||\"\")&&!b._data(o,\"globalEval\")&&b.contains(u,o)&&(o.src?b.ajax({url:o.src,type:\"GET\",dataType:\"script\",async:!1,global:!1,\"throws\":!0}):b.globalEval((o.text||o.textContent||o.innerHTML||\"\").replace(St,\"\")));l=i=null}return this}});function Lt(e,t){return e.getElementsByTagName(t)[0]||e.appendChild(e.ownerDocument.createElement(t))}function Ht(e){var t=e.getAttributeNode(\"type\");return e.type=(t&&t.specified)+\"/\"+e.type,e}function qt(e){var t=Et.exec(e.type);return t?e.type=t[1]:e.removeAttribute(\"type\"),e}function Mt(e,t){var n,r=0;for(;null!=(n=e[r]);r++)b._data(n,\"globalEval\",!t||b._data(t[r],\"globalEval\"))}function _t(e,t){if(1===t.nodeType&&b.hasData(e)){var n,r,i,o=b._data(e),a=b._data(t,o),s=o.events;if(s){delete a.handle,a.events={};for(n in s)for(r=0,i=s[n].length;i>r;r++)b.event.add(t,n,s[n][r])}a.data&&(a.data=b.extend({},a.data))}}function Ft(e,t){var n,r,i;if(1===t.nodeType){if(n=t.nodeName.toLowerCase(),!b.support.noCloneEvent&&t[b.expando]){i=b._data(t);for(r in i.events)b.removeEvent(t,r,i.handle);t.removeAttribute(b.expando)}\"script\"===n&&t.text!==e.text?(Ht(t).text=e.text,qt(t)):\"object\"===n?(t.parentNode&&(t.outerHTML=e.outerHTML),b.support.html5Clone&&e.innerHTML&&!b.trim(t.innerHTML)&&(t.innerHTML=e.innerHTML)):\"input\"===n&&Nt.test(e.type)?(t.defaultChecked=t.checked=e.checked,t.value!==e.value&&(t.value=e.value)):\"option\"===n?t.defaultSelected=t.selected=e.defaultSelected:(\"input\"===n||\"textarea\"===n)&&(t.defaultValue=e.defaultValue)}}b.each({appendTo:\"append\",prependTo:\"prepend\",insertBefore:\"before\",insertAfter:\"after\",replaceAll:\"replaceWith\"},function(e,t){b.fn[e]=function(e){var n,r=0,i=[],o=b(e),a=o.length-1;for(;a>=r;r++)n=r===a?this:this.clone(!0),b(o[r])[t](n),d.apply(i,n.get());return this.pushStack(i)}});function Ot(e,n){var r,o,a=0,s=typeof e.getElementsByTagName!==i?e.getElementsByTagName(n||\"*\"):typeof e.querySelectorAll!==i?e.querySelectorAll(n||\"*\"):t;if(!s)for(s=[],r=e.childNodes||e;null!=(o=r[a]);a++)!n||b.nodeName(o,n)?s.push(o):b.merge(s,Ot(o,n));return n===t||n&&b.nodeName(e,n)?b.merge([e],s):s}function Bt(e){Nt.test(e.type)&&(e.defaultChecked=e.checked)}b.extend({clone:function(e,t,n){var r,i,o,a,s,u=b.contains(e.ownerDocument,e);if(b.support.html5Clone||b.isXMLDoc(e)||!mt.test(\"<\"+e.nodeName+\">\")?o=e.cloneNode(!0):(Dt.innerHTML=e.outerHTML,Dt.removeChild(o=Dt.firstChild)),!(b.support.noCloneEvent&&b.support.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||b.isXMLDoc(e)))for(r=Ot(o),s=Ot(e),a=0;null!=(i=s[a]);++a)r[a]&&Ft(i,r[a]);if(t)if(n)for(s=s||Ot(e),r=r||Ot(o),a=0;null!=(i=s[a]);a++)_t(i,r[a]);else _t(e,o);return r=Ot(o,\"script\"),r.length>0&&Mt(r,!u&&Ot(e,\"script\")),r=s=i=null,o},buildFragment:function(e,t,n,r){var i,o,a,s,u,l,c,p=e.length,f=dt(t),d=[],h=0;for(;p>h;h++)if(o=e[h],o||0===o)if(\"object\"===b.type(o))b.merge(d,o.nodeType?[o]:o);else if(wt.test(o)){s=s||f.appendChild(t.createElement(\"div\")),u=(bt.exec(o)||[\"\",\"\"])[1].toLowerCase(),c=At[u]||At._default,s.innerHTML=c[1]+o.replace(vt,\"<$1></$2>\")+c[2],i=c[0];while(i--)s=s.lastChild;if(!b.support.leadingWhitespace&&yt.test(o)&&d.push(t.createTextNode(yt.exec(o)[0])),!b.support.tbody){o=\"table\"!==u||xt.test(o)?\"<table>\"!==c[1]||xt.test(o)?0:s:s.firstChild,i=o&&o.childNodes.length;while(i--)b.nodeName(l=o.childNodes[i],\"tbody\")&&!l.childNodes.length&&o.removeChild(l)\n}b.merge(d,s.childNodes),s.textContent=\"\";while(s.firstChild)s.removeChild(s.firstChild);s=f.lastChild}else d.push(t.createTextNode(o));s&&f.removeChild(s),b.support.appendChecked||b.grep(Ot(d,\"input\"),Bt),h=0;while(o=d[h++])if((!r||-1===b.inArray(o,r))&&(a=b.contains(o.ownerDocument,o),s=Ot(f.appendChild(o),\"script\"),a&&Mt(s),n)){i=0;while(o=s[i++])kt.test(o.type||\"\")&&n.push(o)}return s=null,f},cleanData:function(e,t){var n,r,o,a,s=0,u=b.expando,l=b.cache,p=b.support.deleteExpando,f=b.event.special;for(;null!=(n=e[s]);s++)if((t||b.acceptData(n))&&(o=n[u],a=o&&l[o])){if(a.events)for(r in a.events)f[r]?b.event.remove(n,r):b.removeEvent(n,r,a.handle);l[o]&&(delete l[o],p?delete n[u]:typeof n.removeAttribute!==i?n.removeAttribute(u):n[u]=null,c.push(o))}}});var Pt,Rt,Wt,$t=/alpha\\([^)]*\\)/i,It=/opacity\\s*=\\s*([^)]*)/,zt=/^(top|right|bottom|left)$/,Xt=/^(none|table(?!-c[ea]).+)/,Ut=/^margin/,Vt=RegExp(\"^(\"+x+\")(.*)$\",\"i\"),Yt=RegExp(\"^(\"+x+\")(?!px)[a-z%]+$\",\"i\"),Jt=RegExp(\"^([+-])=(\"+x+\")\",\"i\"),Gt={BODY:\"block\"},Qt={position:\"absolute\",visibility:\"hidden\",display:\"block\"},Kt={letterSpacing:0,fontWeight:400},Zt=[\"Top\",\"Right\",\"Bottom\",\"Left\"],en=[\"Webkit\",\"O\",\"Moz\",\"ms\"];function tn(e,t){if(t in e)return t;var n=t.charAt(0).toUpperCase()+t.slice(1),r=t,i=en.length;while(i--)if(t=en[i]+n,t in e)return t;return r}function nn(e,t){return e=t||e,\"none\"===b.css(e,\"display\")||!b.contains(e.ownerDocument,e)}function rn(e,t){var n,r,i,o=[],a=0,s=e.length;for(;s>a;a++)r=e[a],r.style&&(o[a]=b._data(r,\"olddisplay\"),n=r.style.display,t?(o[a]||\"none\"!==n||(r.style.display=\"\"),\"\"===r.style.display&&nn(r)&&(o[a]=b._data(r,\"olddisplay\",un(r.nodeName)))):o[a]||(i=nn(r),(n&&\"none\"!==n||!i)&&b._data(r,\"olddisplay\",i?n:b.css(r,\"display\"))));for(a=0;s>a;a++)r=e[a],r.style&&(t&&\"none\"!==r.style.display&&\"\"!==r.style.display||(r.style.display=t?o[a]||\"\":\"none\"));return e}b.fn.extend({css:function(e,n){return b.access(this,function(e,n,r){var i,o,a={},s=0;if(b.isArray(n)){for(o=Rt(e),i=n.length;i>s;s++)a[n[s]]=b.css(e,n[s],!1,o);return a}return r!==t?b.style(e,n,r):b.css(e,n)},e,n,arguments.length>1)},show:function(){return rn(this,!0)},hide:function(){return rn(this)},toggle:function(e){var t=\"boolean\"==typeof e;return this.each(function(){(t?e:nn(this))?b(this).show():b(this).hide()})}}),b.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Wt(e,\"opacity\");return\"\"===n?\"1\":n}}}},cssNumber:{columnCount:!0,fillOpacity:!0,fontWeight:!0,lineHeight:!0,opacity:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{\"float\":b.support.cssFloat?\"cssFloat\":\"styleFloat\"},style:function(e,n,r,i){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var o,a,s,u=b.camelCase(n),l=e.style;if(n=b.cssProps[u]||(b.cssProps[u]=tn(l,u)),s=b.cssHooks[n]||b.cssHooks[u],r===t)return s&&\"get\"in s&&(o=s.get(e,!1,i))!==t?o:l[n];if(a=typeof r,\"string\"===a&&(o=Jt.exec(r))&&(r=(o[1]+1)*o[2]+parseFloat(b.css(e,n)),a=\"number\"),!(null==r||\"number\"===a&&isNaN(r)||(\"number\"!==a||b.cssNumber[u]||(r+=\"px\"),b.support.clearCloneStyle||\"\"!==r||0!==n.indexOf(\"background\")||(l[n]=\"inherit\"),s&&\"set\"in s&&(r=s.set(e,r,i))===t)))try{l[n]=r}catch(c){}}},css:function(e,n,r,i){var o,a,s,u=b.camelCase(n);return n=b.cssProps[u]||(b.cssProps[u]=tn(e.style,u)),s=b.cssHooks[n]||b.cssHooks[u],s&&\"get\"in s&&(a=s.get(e,!0,r)),a===t&&(a=Wt(e,n,i)),\"normal\"===a&&n in Kt&&(a=Kt[n]),\"\"===r||r?(o=parseFloat(a),r===!0||b.isNumeric(o)?o||0:a):a},swap:function(e,t,n,r){var i,o,a={};for(o in t)a[o]=e.style[o],e.style[o]=t[o];i=n.apply(e,r||[]);for(o in t)e.style[o]=a[o];return i}}),e.getComputedStyle?(Rt=function(t){return e.getComputedStyle(t,null)},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),u=s?s.getPropertyValue(n)||s[n]:t,l=e.style;return s&&(\"\"!==u||b.contains(e.ownerDocument,e)||(u=b.style(e,n)),Yt.test(u)&&Ut.test(n)&&(i=l.width,o=l.minWidth,a=l.maxWidth,l.minWidth=l.maxWidth=l.width=u,u=s.width,l.width=i,l.minWidth=o,l.maxWidth=a)),u}):o.documentElement.currentStyle&&(Rt=function(e){return e.currentStyle},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),u=s?s[n]:t,l=e.style;return null==u&&l&&l[n]&&(u=l[n]),Yt.test(u)&&!zt.test(n)&&(i=l.left,o=e.runtimeStyle,a=o&&o.left,a&&(o.left=e.currentStyle.left),l.left=\"fontSize\"===n?\"1em\":u,u=l.pixelLeft+\"px\",l.left=i,a&&(o.left=a)),\"\"===u?\"auto\":u});function on(e,t,n){var r=Vt.exec(t);return r?Math.max(0,r[1]-(n||0))+(r[2]||\"px\"):t}function an(e,t,n,r,i){var o=n===(r?\"border\":\"content\")?4:\"width\"===t?1:0,a=0;for(;4>o;o+=2)\"margin\"===n&&(a+=b.css(e,n+Zt[o],!0,i)),r?(\"content\"===n&&(a-=b.css(e,\"padding\"+Zt[o],!0,i)),\"margin\"!==n&&(a-=b.css(e,\"border\"+Zt[o]+\"Width\",!0,i))):(a+=b.css(e,\"padding\"+Zt[o],!0,i),\"padding\"!==n&&(a+=b.css(e,\"border\"+Zt[o]+\"Width\",!0,i)));return a}function sn(e,t,n){var r=!0,i=\"width\"===t?e.offsetWidth:e.offsetHeight,o=Rt(e),a=b.support.boxSizing&&\"border-box\"===b.css(e,\"boxSizing\",!1,o);if(0>=i||null==i){if(i=Wt(e,t,o),(0>i||null==i)&&(i=e.style[t]),Yt.test(i))return i;r=a&&(b.support.boxSizingReliable||i===e.style[t]),i=parseFloat(i)||0}return i+an(e,t,n||(a?\"border\":\"content\"),r,o)+\"px\"}function un(e){var t=o,n=Gt[e];return n||(n=ln(e,t),\"none\"!==n&&n||(Pt=(Pt||b(\"<iframe frameborder='0' width='0' height='0'/>\").css(\"cssText\",\"display:block !important\")).appendTo(t.documentElement),t=(Pt[0].contentWindow||Pt[0].contentDocument).document,t.write(\"<!doctype html><html><body>\"),t.close(),n=ln(e,t),Pt.detach()),Gt[e]=n),n}function ln(e,t){var n=b(t.createElement(e)).appendTo(t.body),r=b.css(n[0],\"display\");return n.remove(),r}b.each([\"height\",\"width\"],function(e,n){b.cssHooks[n]={get:function(e,r,i){return r?0===e.offsetWidth&&Xt.test(b.css(e,\"display\"))?b.swap(e,Qt,function(){return sn(e,n,i)}):sn(e,n,i):t},set:function(e,t,r){var i=r&&Rt(e);return on(e,t,r?an(e,n,r,b.support.boxSizing&&\"border-box\"===b.css(e,\"boxSizing\",!1,i),i):0)}}}),b.support.opacity||(b.cssHooks.opacity={get:function(e,t){return It.test((t&&e.currentStyle?e.currentStyle.filter:e.style.filter)||\"\")?.01*parseFloat(RegExp.$1)+\"\":t?\"1\":\"\"},set:function(e,t){var n=e.style,r=e.currentStyle,i=b.isNumeric(t)?\"alpha(opacity=\"+100*t+\")\":\"\",o=r&&r.filter||n.filter||\"\";n.zoom=1,(t>=1||\"\"===t)&&\"\"===b.trim(o.replace($t,\"\"))&&n.removeAttribute&&(n.removeAttribute(\"filter\"),\"\"===t||r&&!r.filter)||(n.filter=$t.test(o)?o.replace($t,i):o+\" \"+i)}}),b(function(){b.support.reliableMarginRight||(b.cssHooks.marginRight={get:function(e,n){return n?b.swap(e,{display:\"inline-block\"},Wt,[e,\"marginRight\"]):t}}),!b.support.pixelPosition&&b.fn.position&&b.each([\"top\",\"left\"],function(e,n){b.cssHooks[n]={get:function(e,r){return r?(r=Wt(e,n),Yt.test(r)?b(e).position()[n]+\"px\":r):t}}})}),b.expr&&b.expr.filters&&(b.expr.filters.hidden=function(e){return 0>=e.offsetWidth&&0>=e.offsetHeight||!b.support.reliableHiddenOffsets&&\"none\"===(e.style&&e.style.display||b.css(e,\"display\"))},b.expr.filters.visible=function(e){return!b.expr.filters.hidden(e)}),b.each({margin:\"\",padding:\"\",border:\"Width\"},function(e,t){b.cssHooks[e+t]={expand:function(n){var r=0,i={},o=\"string\"==typeof n?n.split(\" \"):[n];for(;4>r;r++)i[e+Zt[r]+t]=o[r]||o[r-2]||o[0];return i}},Ut.test(e)||(b.cssHooks[e+t].set=on)});var cn=/%20/g,pn=/\\[\\]$/,fn=/\\r?\\n/g,dn=/^(?:submit|button|image|reset|file)$/i,hn=/^(?:input|select|textarea|keygen)/i;b.fn.extend({serialize:function(){return b.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=b.prop(this,\"elements\");return e?b.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!b(this).is(\":disabled\")&&hn.test(this.nodeName)&&!dn.test(e)&&(this.checked||!Nt.test(e))}).map(function(e,t){var n=b(this).val();return null==n?null:b.isArray(n)?b.map(n,function(e){return{name:t.name,value:e.replace(fn,\"\\r\\n\")}}):{name:t.name,value:n.replace(fn,\"\\r\\n\")}}).get()}}),b.param=function(e,n){var r,i=[],o=function(e,t){t=b.isFunction(t)?t():null==t?\"\":t,i[i.length]=encodeURIComponent(e)+\"=\"+encodeURIComponent(t)};if(n===t&&(n=b.ajaxSettings&&b.ajaxSettings.traditional),b.isArray(e)||e.jquery&&!b.isPlainObject(e))b.each(e,function(){o(this.name,this.value)});else for(r in e)gn(r,e[r],n,o);return i.join(\"&\").replace(cn,\"+\")};function gn(e,t,n,r){var i;if(b.isArray(t))b.each(t,function(t,i){n||pn.test(e)?r(e,i):gn(e+\"[\"+(\"object\"==typeof i?t:\"\")+\"]\",i,n,r)});else if(n||\"object\"!==b.type(t))r(e,t);else for(i in t)gn(e+\"[\"+i+\"]\",t[i],n,r)}b.each(\"blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu\".split(\" \"),function(e,t){b.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),b.fn.hover=function(e,t){return this.mouseenter(e).mouseleave(t||e)};var mn,yn,vn=b.now(),bn=/\\?/,xn=/#.*$/,wn=/([?&])_=[^&]*/,Tn=/^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/gm,Nn=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,Cn=/^(?:GET|HEAD)$/,kn=/^\\/\\//,En=/^([\\w.+-]+:)(?:\\/\\/([^\\/?#:]*)(?::(\\d+)|)|)/,Sn=b.fn.load,An={},jn={},Dn=\"*/\".concat(\"*\");try{yn=a.href}catch(Ln){yn=o.createElement(\"a\"),yn.href=\"\",yn=yn.href}mn=En.exec(yn.toLowerCase())||[];function Hn(e){return function(t,n){\"string\"!=typeof t&&(n=t,t=\"*\");var r,i=0,o=t.toLowerCase().match(w)||[];if(b.isFunction(n))while(r=o[i++])\"+\"===r[0]?(r=r.slice(1)||\"*\",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function qn(e,n,r,i){var o={},a=e===jn;function s(u){var l;return o[u]=!0,b.each(e[u]||[],function(e,u){var c=u(n,r,i);return\"string\"!=typeof c||a||o[c]?a?!(l=c):t:(n.dataTypes.unshift(c),s(c),!1)}),l}return s(n.dataTypes[0])||!o[\"*\"]&&s(\"*\")}function Mn(e,n){var r,i,o=b.ajaxSettings.flatOptions||{};for(i in n)n[i]!==t&&((o[i]?e:r||(r={}))[i]=n[i]);return r&&b.extend(!0,e,r),e}b.fn.load=function(e,n,r){if(\"string\"!=typeof e&&Sn)return Sn.apply(this,arguments);var i,o,a,s=this,u=e.indexOf(\" \");return u>=0&&(i=e.slice(u,e.length),e=e.slice(0,u)),b.isFunction(n)?(r=n,n=t):n&&\"object\"==typeof n&&(a=\"POST\"),s.length>0&&b.ajax({url:e,type:a,dataType:\"html\",data:n}).done(function(e){o=arguments,s.html(i?b(\"<div>\").append(b.parseHTML(e)).find(i):e)}).complete(r&&function(e,t){s.each(r,o||[e.responseText,t,e])}),this},b.each([\"ajaxStart\",\"ajaxStop\",\"ajaxComplete\",\"ajaxError\",\"ajaxSuccess\",\"ajaxSend\"],function(e,t){b.fn[t]=function(e){return this.on(t,e)}}),b.each([\"get\",\"post\"],function(e,n){b[n]=function(e,r,i,o){return b.isFunction(r)&&(o=o||i,i=r,r=t),b.ajax({url:e,type:n,dataType:o,data:r,success:i})}}),b.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:yn,type:\"GET\",isLocal:Nn.test(mn[1]),global:!0,processData:!0,async:!0,contentType:\"application/x-www-form-urlencoded; charset=UTF-8\",accepts:{\"*\":Dn,text:\"text/plain\",html:\"text/html\",xml:\"application/xml, text/xml\",json:\"application/json, text/javascript\"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:\"responseXML\",text:\"responseText\"},converters:{\"* text\":e.String,\"text html\":!0,\"text json\":b.parseJSON,\"text xml\":b.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Mn(Mn(e,b.ajaxSettings),t):Mn(b.ajaxSettings,e)},ajaxPrefilter:Hn(An),ajaxTransport:Hn(jn),ajax:function(e,n){\"object\"==typeof e&&(n=e,e=t),n=n||{};var r,i,o,a,s,u,l,c,p=b.ajaxSetup({},n),f=p.context||p,d=p.context&&(f.nodeType||f.jquery)?b(f):b.event,h=b.Deferred(),g=b.Callbacks(\"once memory\"),m=p.statusCode||{},y={},v={},x=0,T=\"canceled\",N={readyState:0,getResponseHeader:function(e){var t;if(2===x){if(!c){c={};while(t=Tn.exec(a))c[t[1].toLowerCase()]=t[2]}t=c[e.toLowerCase()]}return null==t?null:t},getAllResponseHeaders:function(){return 2===x?a:null},setRequestHeader:function(e,t){var n=e.toLowerCase();return x||(e=v[n]=v[n]||e,y[e]=t),this},overrideMimeType:function(e){return x||(p.mimeType=e),this},statusCode:function(e){var t;if(e)if(2>x)for(t in e)m[t]=[m[t],e[t]];else N.always(e[N.status]);return this},abort:function(e){var t=e||T;return l&&l.abort(t),k(0,t),this}};if(h.promise(N).complete=g.add,N.success=N.done,N.error=N.fail,p.url=((e||p.url||yn)+\"\").replace(xn,\"\").replace(kn,mn[1]+\"//\"),p.type=n.method||n.type||p.method||p.type,p.dataTypes=b.trim(p.dataType||\"*\").toLowerCase().match(w)||[\"\"],null==p.crossDomain&&(r=En.exec(p.url.toLowerCase()),p.crossDomain=!(!r||r[1]===mn[1]&&r[2]===mn[2]&&(r[3]||(\"http:\"===r[1]?80:443))==(mn[3]||(\"http:\"===mn[1]?80:443)))),p.data&&p.processData&&\"string\"!=typeof p.data&&(p.data=b.param(p.data,p.traditional)),qn(An,p,n,N),2===x)return N;u=p.global,u&&0===b.active++&&b.event.trigger(\"ajaxStart\"),p.type=p.type.toUpperCase(),p.hasContent=!Cn.test(p.type),o=p.url,p.hasContent||(p.data&&(o=p.url+=(bn.test(o)?\"&\":\"?\")+p.data,delete p.data),p.cache===!1&&(p.url=wn.test(o)?o.replace(wn,\"$1_=\"+vn++):o+(bn.test(o)?\"&\":\"?\")+\"_=\"+vn++)),p.ifModified&&(b.lastModified[o]&&N.setRequestHeader(\"If-Modified-Since\",b.lastModified[o]),b.etag[o]&&N.setRequestHeader(\"If-None-Match\",b.etag[o])),(p.data&&p.hasContent&&p.contentType!==!1||n.contentType)&&N.setRequestHeader(\"Content-Type\",p.contentType),N.setRequestHeader(\"Accept\",p.dataTypes[0]&&p.accepts[p.dataTypes[0]]?p.accepts[p.dataTypes[0]]+(\"*\"!==p.dataTypes[0]?\", \"+Dn+\"; q=0.01\":\"\"):p.accepts[\"*\"]);for(i in p.headers)N.setRequestHeader(i,p.headers[i]);if(p.beforeSend&&(p.beforeSend.call(f,N,p)===!1||2===x))return N.abort();T=\"abort\";for(i in{success:1,error:1,complete:1})N[i](p[i]);if(l=qn(jn,p,n,N)){N.readyState=1,u&&d.trigger(\"ajaxSend\",[N,p]),p.async&&p.timeout>0&&(s=setTimeout(function(){N.abort(\"timeout\")},p.timeout));try{x=1,l.send(y,k)}catch(C){if(!(2>x))throw C;k(-1,C)}}else k(-1,\"No Transport\");function k(e,n,r,i){var c,y,v,w,T,C=n;2!==x&&(x=2,s&&clearTimeout(s),l=t,a=i||\"\",N.readyState=e>0?4:0,r&&(w=_n(p,N,r)),e>=200&&300>e||304===e?(p.ifModified&&(T=N.getResponseHeader(\"Last-Modified\"),T&&(b.lastModified[o]=T),T=N.getResponseHeader(\"etag\"),T&&(b.etag[o]=T)),204===e?(c=!0,C=\"nocontent\"):304===e?(c=!0,C=\"notmodified\"):(c=Fn(p,w),C=c.state,y=c.data,v=c.error,c=!v)):(v=C,(e||!C)&&(C=\"error\",0>e&&(e=0))),N.status=e,N.statusText=(n||C)+\"\",c?h.resolveWith(f,[y,C,N]):h.rejectWith(f,[N,C,v]),N.statusCode(m),m=t,u&&d.trigger(c?\"ajaxSuccess\":\"ajaxError\",[N,p,c?y:v]),g.fireWith(f,[N,C]),u&&(d.trigger(\"ajaxComplete\",[N,p]),--b.active||b.event.trigger(\"ajaxStop\")))}return N},getScript:function(e,n){return b.get(e,t,n,\"script\")},getJSON:function(e,t,n){return b.get(e,t,n,\"json\")}});function _n(e,n,r){var i,o,a,s,u=e.contents,l=e.dataTypes,c=e.responseFields;for(s in c)s in r&&(n[c[s]]=r[s]);while(\"*\"===l[0])l.shift(),o===t&&(o=e.mimeType||n.getResponseHeader(\"Content-Type\"));if(o)for(s in u)if(u[s]&&u[s].test(o)){l.unshift(s);break}if(l[0]in r)a=l[0];else{for(s in r){if(!l[0]||e.converters[s+\" \"+l[0]]){a=s;break}i||(i=s)}a=a||i}return a?(a!==l[0]&&l.unshift(a),r[a]):t}function Fn(e,t){var n,r,i,o,a={},s=0,u=e.dataTypes.slice(),l=u[0];if(e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u[1])for(i in e.converters)a[i.toLowerCase()]=e.converters[i];for(;r=u[++s];)if(\"*\"!==r){if(\"*\"!==l&&l!==r){if(i=a[l+\" \"+r]||a[\"* \"+r],!i)for(n in a)if(o=n.split(\" \"),o[1]===r&&(i=a[l+\" \"+o[0]]||a[\"* \"+o[0]])){i===!0?i=a[n]:a[n]!==!0&&(r=o[0],u.splice(s--,0,r));break}if(i!==!0)if(i&&e[\"throws\"])t=i(t);else try{t=i(t)}catch(c){return{state:\"parsererror\",error:i?c:\"No conversion from \"+l+\" to \"+r}}}l=r}return{state:\"success\",data:t}}b.ajaxSetup({accepts:{script:\"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript\"},contents:{script:/(?:java|ecma)script/},converters:{\"text script\":function(e){return b.globalEval(e),e}}}),b.ajaxPrefilter(\"script\",function(e){e.cache===t&&(e.cache=!1),e.crossDomain&&(e.type=\"GET\",e.global=!1)}),b.ajaxTransport(\"script\",function(e){if(e.crossDomain){var n,r=o.head||b(\"head\")[0]||o.documentElement;return{send:function(t,i){n=o.createElement(\"script\"),n.async=!0,e.scriptCharset&&(n.charset=e.scriptCharset),n.src=e.url,n.onload=n.onreadystatechange=function(e,t){(t||!n.readyState||/loaded|complete/.test(n.readyState))&&(n.onload=n.onreadystatechange=null,n.parentNode&&n.parentNode.removeChild(n),n=null,t||i(200,\"success\"))},r.insertBefore(n,r.firstChild)},abort:function(){n&&n.onload(t,!0)}}}});var On=[],Bn=/(=)\\?(?=&|$)|\\?\\?/;b.ajaxSetup({jsonp:\"callback\",jsonpCallback:function(){var e=On.pop()||b.expando+\"_\"+vn++;return this[e]=!0,e}}),b.ajaxPrefilter(\"json jsonp\",function(n,r,i){var o,a,s,u=n.jsonp!==!1&&(Bn.test(n.url)?\"url\":\"string\"==typeof n.data&&!(n.contentType||\"\").indexOf(\"application/x-www-form-urlencoded\")&&Bn.test(n.data)&&\"data\");return u||\"jsonp\"===n.dataTypes[0]?(o=n.jsonpCallback=b.isFunction(n.jsonpCallback)?n.jsonpCallback():n.jsonpCallback,u?n[u]=n[u].replace(Bn,\"$1\"+o):n.jsonp!==!1&&(n.url+=(bn.test(n.url)?\"&\":\"?\")+n.jsonp+\"=\"+o),n.converters[\"script json\"]=function(){return s||b.error(o+\" was not called\"),s[0]},n.dataTypes[0]=\"json\",a=e[o],e[o]=function(){s=arguments},i.always(function(){e[o]=a,n[o]&&(n.jsonpCallback=r.jsonpCallback,On.push(o)),s&&b.isFunction(a)&&a(s[0]),s=a=t}),\"script\"):t});var Pn,Rn,Wn=0,$n=e.ActiveXObject&&function(){var e;for(e in Pn)Pn[e](t,!0)};function In(){try{return new e.XMLHttpRequest}catch(t){}}function zn(){try{return new e.ActiveXObject(\"Microsoft.XMLHTTP\")}catch(t){}}b.ajaxSettings.xhr=e.ActiveXObject?function(){return!this.isLocal&&In()||zn()}:In,Rn=b.ajaxSettings.xhr(),b.support.cors=!!Rn&&\"withCredentials\"in Rn,Rn=b.support.ajax=!!Rn,Rn&&b.ajaxTransport(function(n){if(!n.crossDomain||b.support.cors){var r;return{send:function(i,o){var a,s,u=n.xhr();if(n.username?u.open(n.type,n.url,n.async,n.username,n.password):u.open(n.type,n.url,n.async),n.xhrFields)for(s in n.xhrFields)u[s]=n.xhrFields[s];n.mimeType&&u.overrideMimeType&&u.overrideMimeType(n.mimeType),n.crossDomain||i[\"X-Requested-With\"]||(i[\"X-Requested-With\"]=\"XMLHttpRequest\");try{for(s in i)u.setRequestHeader(s,i[s])}catch(l){}u.send(n.hasContent&&n.data||null),r=function(e,i){var s,l,c,p;try{if(r&&(i||4===u.readyState))if(r=t,a&&(u.onreadystatechange=b.noop,$n&&delete Pn[a]),i)4!==u.readyState&&u.abort();else{p={},s=u.status,l=u.getAllResponseHeaders(),\"string\"==typeof u.responseText&&(p.text=u.responseText);try{c=u.statusText}catch(f){c=\"\"}s||!n.isLocal||n.crossDomain?1223===s&&(s=204):s=p.text?200:404}}catch(d){i||o(-1,d)}p&&o(s,c,p,l)},n.async?4===u.readyState?setTimeout(r):(a=++Wn,$n&&(Pn||(Pn={},b(e).unload($n)),Pn[a]=r),u.onreadystatechange=r):r()},abort:function(){r&&r(t,!0)}}}});var Xn,Un,Vn=/^(?:toggle|show|hide)$/,Yn=RegExp(\"^(?:([+-])=|)(\"+x+\")([a-z%]*)$\",\"i\"),Jn=/queueHooks$/,Gn=[nr],Qn={\"*\":[function(e,t){var n,r,i=this.createTween(e,t),o=Yn.exec(t),a=i.cur(),s=+a||0,u=1,l=20;if(o){if(n=+o[2],r=o[3]||(b.cssNumber[e]?\"\":\"px\"),\"px\"!==r&&s){s=b.css(i.elem,e,!0)||n||1;do u=u||\".5\",s/=u,b.style(i.elem,e,s+r);while(u!==(u=i.cur()/a)&&1!==u&&--l)}i.unit=r,i.start=s,i.end=o[1]?s+(o[1]+1)*n:n}return i}]};function Kn(){return setTimeout(function(){Xn=t}),Xn=b.now()}function Zn(e,t){b.each(t,function(t,n){var r=(Qn[t]||[]).concat(Qn[\"*\"]),i=0,o=r.length;for(;o>i;i++)if(r[i].call(e,t,n))return})}function er(e,t,n){var r,i,o=0,a=Gn.length,s=b.Deferred().always(function(){delete u.elem}),u=function(){if(i)return!1;var t=Xn||Kn(),n=Math.max(0,l.startTime+l.duration-t),r=n/l.duration||0,o=1-r,a=0,u=l.tweens.length;for(;u>a;a++)l.tweens[a].run(o);return s.notifyWith(e,[l,o,n]),1>o&&u?n:(s.resolveWith(e,[l]),!1)},l=s.promise({elem:e,props:b.extend({},t),opts:b.extend(!0,{specialEasing:{}},n),originalProperties:t,originalOptions:n,startTime:Xn||Kn(),duration:n.duration,tweens:[],createTween:function(t,n){var r=b.Tween(e,l.opts,t,n,l.opts.specialEasing[t]||l.opts.easing);return l.tweens.push(r),r},stop:function(t){var n=0,r=t?l.tweens.length:0;if(i)return this;for(i=!0;r>n;n++)l.tweens[n].run(1);return t?s.resolveWith(e,[l,t]):s.rejectWith(e,[l,t]),this}}),c=l.props;for(tr(c,l.opts.specialEasing);a>o;o++)if(r=Gn[o].call(l,e,c,l.opts))return r;return Zn(l,c),b.isFunction(l.opts.start)&&l.opts.start.call(e,l),b.fx.timer(b.extend(u,{elem:e,anim:l,queue:l.opts.queue})),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always)}function tr(e,t){var n,r,i,o,a;for(i in e)if(r=b.camelCase(i),o=t[r],n=e[i],b.isArray(n)&&(o=n[1],n=e[i]=n[0]),i!==r&&(e[r]=n,delete e[i]),a=b.cssHooks[r],a&&\"expand\"in a){n=a.expand(n),delete e[r];for(i in n)i in e||(e[i]=n[i],t[i]=o)}else t[r]=o}b.Animation=b.extend(er,{tweener:function(e,t){b.isFunction(e)?(t=e,e=[\"*\"]):e=e.split(\" \");var n,r=0,i=e.length;for(;i>r;r++)n=e[r],Qn[n]=Qn[n]||[],Qn[n].unshift(t)},prefilter:function(e,t){t?Gn.unshift(e):Gn.push(e)}});function nr(e,t,n){var r,i,o,a,s,u,l,c,p,f=this,d=e.style,h={},g=[],m=e.nodeType&&nn(e);n.queue||(c=b._queueHooks(e,\"fx\"),null==c.unqueued&&(c.unqueued=0,p=c.empty.fire,c.empty.fire=function(){c.unqueued||p()}),c.unqueued++,f.always(function(){f.always(function(){c.unqueued--,b.queue(e,\"fx\").length||c.empty.fire()})})),1===e.nodeType&&(\"height\"in t||\"width\"in t)&&(n.overflow=[d.overflow,d.overflowX,d.overflowY],\"inline\"===b.css(e,\"display\")&&\"none\"===b.css(e,\"float\")&&(b.support.inlineBlockNeedsLayout&&\"inline\"!==un(e.nodeName)?d.zoom=1:d.display=\"inline-block\")),n.overflow&&(d.overflow=\"hidden\",b.support.shrinkWrapBlocks||f.always(function(){d.overflow=n.overflow[0],d.overflowX=n.overflow[1],d.overflowY=n.overflow[2]}));for(i in t)if(a=t[i],Vn.exec(a)){if(delete t[i],u=u||\"toggle\"===a,a===(m?\"hide\":\"show\"))continue;g.push(i)}if(o=g.length){s=b._data(e,\"fxshow\")||b._data(e,\"fxshow\",{}),\"hidden\"in s&&(m=s.hidden),u&&(s.hidden=!m),m?b(e).show():f.done(function(){b(e).hide()}),f.done(function(){var t;b._removeData(e,\"fxshow\");for(t in h)b.style(e,t,h[t])});for(i=0;o>i;i++)r=g[i],l=f.createTween(r,m?s[r]:0),h[r]=s[r]||b.style(e,r),r in s||(s[r]=l.start,m&&(l.end=l.start,l.start=\"width\"===r||\"height\"===r?1:0))}}function rr(e,t,n,r,i){return new rr.prototype.init(e,t,n,r,i)}b.Tween=rr,rr.prototype={constructor:rr,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||\"swing\",this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(b.cssNumber[n]?\"\":\"px\")},cur:function(){var e=rr.propHooks[this.prop];return e&&e.get?e.get(this):rr.propHooks._default.get(this)},run:function(e){var t,n=rr.propHooks[this.prop];return this.pos=t=this.options.duration?b.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):rr.propHooks._default.set(this),this}},rr.prototype.init.prototype=rr.prototype,rr.propHooks={_default:{get:function(e){var t;return null==e.elem[e.prop]||e.elem.style&&null!=e.elem.style[e.prop]?(t=b.css(e.elem,e.prop,\"\"),t&&\"auto\"!==t?t:0):e.elem[e.prop]},set:function(e){b.fx.step[e.prop]?b.fx.step[e.prop](e):e.elem.style&&(null!=e.elem.style[b.cssProps[e.prop]]||b.cssHooks[e.prop])?b.style(e.elem,e.prop,e.now+e.unit):e.elem[e.prop]=e.now}}},rr.propHooks.scrollTop=rr.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},b.each([\"toggle\",\"show\",\"hide\"],function(e,t){var n=b.fn[t];b.fn[t]=function(e,r,i){return null==e||\"boolean\"==typeof e?n.apply(this,arguments):this.animate(ir(t,!0),e,r,i)}}),b.fn.extend({fadeTo:function(e,t,n,r){return this.filter(nn).css(\"opacity\",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=b.isEmptyObject(e),o=b.speed(t,n,r),a=function(){var t=er(this,b.extend({},e),o);a.finish=function(){t.stop(!0)},(i||b._data(this,\"finish\"))&&t.stop(!0)};return a.finish=a,i||o.queue===!1?this.each(a):this.queue(o.queue,a)},stop:function(e,n,r){var i=function(e){var t=e.stop;delete e.stop,t(r)};return\"string\"!=typeof e&&(r=n,n=e,e=t),n&&e!==!1&&this.queue(e||\"fx\",[]),this.each(function(){var t=!0,n=null!=e&&e+\"queueHooks\",o=b.timers,a=b._data(this);if(n)a[n]&&a[n].stop&&i(a[n]);else for(n in a)a[n]&&a[n].stop&&Jn.test(n)&&i(a[n]);for(n=o.length;n--;)o[n].elem!==this||null!=e&&o[n].queue!==e||(o[n].anim.stop(r),t=!1,o.splice(n,1));(t||!r)&&b.dequeue(this,e)})},finish:function(e){return e!==!1&&(e=e||\"fx\"),this.each(function(){var t,n=b._data(this),r=n[e+\"queue\"],i=n[e+\"queueHooks\"],o=b.timers,a=r?r.length:0;for(n.finish=!0,b.queue(this,e,[]),i&&i.cur&&i.cur.finish&&i.cur.finish.call(this),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),o.splice(t,1));for(t=0;a>t;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish})}});function ir(e,t){var n,r={height:e},i=0;for(t=t?1:0;4>i;i+=2-t)n=Zt[i],r[\"margin\"+n]=r[\"padding\"+n]=e;return t&&(r.opacity=r.width=e),r}b.each({slideDown:ir(\"show\"),slideUp:ir(\"hide\"),slideToggle:ir(\"toggle\"),fadeIn:{opacity:\"show\"},fadeOut:{opacity:\"hide\"},fadeToggle:{opacity:\"toggle\"}},function(e,t){b.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}}),b.speed=function(e,t,n){var r=e&&\"object\"==typeof e?b.extend({},e):{complete:n||!n&&t||b.isFunction(e)&&e,duration:e,easing:n&&t||t&&!b.isFunction(t)&&t};return r.duration=b.fx.off?0:\"number\"==typeof r.duration?r.duration:r.duration in b.fx.speeds?b.fx.speeds[r.duration]:b.fx.speeds._default,(null==r.queue||r.queue===!0)&&(r.queue=\"fx\"),r.old=r.complete,r.complete=function(){b.isFunction(r.old)&&r.old.call(this),r.queue&&b.dequeue(this,r.queue)},r},b.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2}},b.timers=[],b.fx=rr.prototype.init,b.fx.tick=function(){var e,n=b.timers,r=0;for(Xn=b.now();n.length>r;r++)e=n[r],e()||n[r]!==e||n.splice(r--,1);n.length||b.fx.stop(),Xn=t},b.fx.timer=function(e){e()&&b.timers.push(e)&&b.fx.start()},b.fx.interval=13,b.fx.start=function(){Un||(Un=setInterval(b.fx.tick,b.fx.interval))},b.fx.stop=function(){clearInterval(Un),Un=null},b.fx.speeds={slow:600,fast:200,_default:400},b.fx.step={},b.expr&&b.expr.filters&&(b.expr.filters.animated=function(e){return b.grep(b.timers,function(t){return e===t.elem}).length}),b.fn.offset=function(e){if(arguments.length)return e===t?this:this.each(function(t){b.offset.setOffset(this,e,t)});var n,r,o={top:0,left:0},a=this[0],s=a&&a.ownerDocument;if(s)return n=s.documentElement,b.contains(n,a)?(typeof a.getBoundingClientRect!==i&&(o=a.getBoundingClientRect()),r=or(s),{top:o.top+(r.pageYOffset||n.scrollTop)-(n.clientTop||0),left:o.left+(r.pageXOffset||n.scrollLeft)-(n.clientLeft||0)}):o},b.offset={setOffset:function(e,t,n){var r=b.css(e,\"position\");\"static\"===r&&(e.style.position=\"relative\");var i=b(e),o=i.offset(),a=b.css(e,\"top\"),s=b.css(e,\"left\"),u=(\"absolute\"===r||\"fixed\"===r)&&b.inArray(\"auto\",[a,s])>-1,l={},c={},p,f;u?(c=i.position(),p=c.top,f=c.left):(p=parseFloat(a)||0,f=parseFloat(s)||0),b.isFunction(t)&&(t=t.call(e,n,o)),null!=t.top&&(l.top=t.top-o.top+p),null!=t.left&&(l.left=t.left-o.left+f),\"using\"in t?t.using.call(e,l):i.css(l)}},b.fn.extend({position:function(){if(this[0]){var e,t,n={top:0,left:0},r=this[0];return\"fixed\"===b.css(r,\"position\")?t=r.getBoundingClientRect():(e=this.offsetParent(),t=this.offset(),b.nodeName(e[0],\"html\")||(n=e.offset()),n.top+=b.css(e[0],\"borderTopWidth\",!0),n.left+=b.css(e[0],\"borderLeftWidth\",!0)),{top:t.top-n.top-b.css(r,\"marginTop\",!0),left:t.left-n.left-b.css(r,\"marginLeft\",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent||o.documentElement;while(e&&!b.nodeName(e,\"html\")&&\"static\"===b.css(e,\"position\"))e=e.offsetParent;return e||o.documentElement})}}),b.each({scrollLeft:\"pageXOffset\",scrollTop:\"pageYOffset\"},function(e,n){var r=/Y/.test(n);b.fn[e]=function(i){return b.access(this,function(e,i,o){var a=or(e);return o===t?a?n in a?a[n]:a.document.documentElement[i]:e[i]:(a?a.scrollTo(r?b(a).scrollLeft():o,r?o:b(a).scrollTop()):e[i]=o,t)},e,i,arguments.length,null)}});function or(e){return b.isWindow(e)?e:9===e.nodeType?e.defaultView||e.parentWindow:!1}b.each({Height:\"height\",Width:\"width\"},function(e,n){b.each({padding:\"inner\"+e,content:n,\"\":\"outer\"+e},function(r,i){b.fn[i]=function(i,o){var a=arguments.length&&(r||\"boolean\"!=typeof i),s=r||(i===!0||o===!0?\"margin\":\"border\");return b.access(this,function(n,r,i){var o;return b.isWindow(n)?n.document.documentElement[\"client\"+e]:9===n.nodeType?(o=n.documentElement,Math.max(n.body[\"scroll\"+e],o[\"scroll\"+e],n.body[\"offset\"+e],o[\"offset\"+e],o[\"client\"+e])):i===t?b.css(n,r,s):b.style(n,r,i,s)},n,a?i:t,a,null)}})}),e.jQuery=e.$=b,\"function\"==typeof define&&define.amd&&define.amd.jQuery&&define(\"jquery\",[],function(){return b})})(window);","Plazathemes_Newproductslider/js/owl.carousel.min.js":"\nrequire([\"jquery\"], function($){\n\"function\"!==typeof Object.create&&(Object.create=function(f){function g(){}g.prototype=f;return new g});\n(function(f,g,k){var l={init:function(a,b){this.$elem=f(b);this.options=f.extend({},f.fn.owlCarousel.options,this.$elem.data(),a);this.userOptions=a;this.loadContent()},loadContent:function(){function a(a){var d,e=\"\";if(\"function\"===typeof b.options.jsonSuccess)b.options.jsonSuccess.apply(this,[a]);else{for(d in a.owl)a.owl.hasOwnProperty(d)&&(e+=a.owl[d].item);b.$elem.html(e)}b.logIn()}var b=this,e;\"function\"===typeof b.options.beforeInit&&b.options.beforeInit.apply(this,[b.$elem]);\"string\"===typeof b.options.jsonPath?\n(e=b.options.jsonPath,f.getJSON(e,a)):b.logIn()},logIn:function(){this.$elem.data(\"owl-originalStyles\",this.$elem.attr(\"style\"));this.$elem.data(\"owl-originalClasses\",this.$elem.attr(\"class\"));this.$elem.css({opacity:0});this.orignalItems=this.options.items;this.checkBrowser();this.wrapperWidth=0;this.checkVisible=null;this.setVars()},setVars:function(){if(0===this.$elem.children().length)return!1;this.baseClass();this.eventTypes();this.$userItems=this.$elem.children();this.itemsAmount=this.$userItems.length;\nthis.wrapItems();this.$owlItems=this.$elem.find(\".owl-item\");this.$owlWrapper=this.$elem.find(\".owl-wrapper\");this.playDirection=\"next\";this.prevItem=0;this.prevArr=[0];this.currentItem=0;this.customEvents();this.onStartup()},onStartup:function(){this.updateItems();this.calculateAll();this.buildControls();this.updateControls();this.response();this.moveEvents();this.stopOnHover();this.owlStatus();!1!==this.options.transitionStyle&&this.transitionTypes(this.options.transitionStyle);!0===this.options.autoPlay&&\n(this.options.autoPlay=5E3);this.play();this.$elem.find(\".owl-wrapper\").css(\"display\",\"block\");this.$elem.is(\":visible\")?this.$elem.css(\"opacity\",1):this.watchVisibility();this.onstartup=!1;this.eachMoveUpdate();\"function\"===typeof this.options.afterInit&&this.options.afterInit.apply(this,[this.$elem])},eachMoveUpdate:function(){!0===this.options.lazyLoad&&this.lazyLoad();!0===this.options.autoHeight&&this.autoHeight();this.onVisibleItems();\"function\"===typeof this.options.afterAction&&this.options.afterAction.apply(this,\n[this.$elem])},updateVars:function(){\"function\"===typeof this.options.beforeUpdate&&this.options.beforeUpdate.apply(this,[this.$elem]);this.watchVisibility();this.updateItems();this.calculateAll();this.updatePosition();this.updateControls();this.eachMoveUpdate();\"function\"===typeof this.options.afterUpdate&&this.options.afterUpdate.apply(this,[this.$elem])},reload:function(){var a=this;g.setTimeout(function(){a.updateVars()},0)},watchVisibility:function(){var a=this;if(!1===a.$elem.is(\":visible\"))a.$elem.css({opacity:0}),\ng.clearInterval(a.autoPlayInterval),g.clearInterval(a.checkVisible);else return!1;a.checkVisible=g.setInterval(function(){a.$elem.is(\":visible\")&&(a.reload(),a.$elem.animate({opacity:1},200),g.clearInterval(a.checkVisible))},500)},wrapItems:function(){this.$userItems.wrapAll('<div class=\"owl-wrapper\">').wrap('<div class=\"owl-item\"></div>');this.$elem.find(\".owl-wrapper\").wrap('<div class=\"owl-wrapper-outer\">');this.wrapperOuter=this.$elem.find(\".owl-wrapper-outer\");this.$elem.css(\"display\",\"block\")},\nbaseClass:function(){var a=this.$elem.hasClass(this.options.baseClass),b=this.$elem.hasClass(this.options.theme);a||this.$elem.addClass(this.options.baseClass);b||this.$elem.addClass(this.options.theme)},updateItems:function(){var a,b;if(!1===this.options.responsive)return!1;if(!0===this.options.singleItem)return this.options.items=this.orignalItems=1,this.options.itemsCustom=!1,this.options.itemsDesktop=!1,this.options.itemsDesktopSmall=!1,this.options.itemsTablet=!1,this.options.itemsTabletSmall=\n!1,this.options.itemsMobile=!1;a=f(this.options.responsiveBaseWidth).width();a>(this.options.itemsDesktop[0]||this.orignalItems)&&(this.options.items=this.orignalItems);if(!1!==this.options.itemsCustom)for(this.options.itemsCustom.sort(function(a,b){return a[0]-b[0]}),b=0;b<this.options.itemsCustom.length;b+=1)this.options.itemsCustom[b][0]<=a&&(this.options.items=this.options.itemsCustom[b][1]);else a<=this.options.itemsDesktop[0]&&!1!==this.options.itemsDesktop&&(this.options.items=this.options.itemsDesktop[1]),\na<=this.options.itemsDesktopSmall[0]&&!1!==this.options.itemsDesktopSmall&&(this.options.items=this.options.itemsDesktopSmall[1]),a<=this.options.itemsTablet[0]&&!1!==this.options.itemsTablet&&(this.options.items=this.options.itemsTablet[1]),a<=this.options.itemsTabletSmall[0]&&!1!==this.options.itemsTabletSmall&&(this.options.items=this.options.itemsTabletSmall[1]),a<=this.options.itemsMobile[0]&&!1!==this.options.itemsMobile&&(this.options.items=this.options.itemsMobile[1]);this.options.items>this.itemsAmount&&\n!0===this.options.itemsScaleUp&&(this.options.items=this.itemsAmount)},response:function(){var a=this,b,e;if(!0!==a.options.responsive)return!1;e=f(g).width();a.resizer=function(){f(g).width()!==e&&(!1!==a.options.autoPlay&&g.clearInterval(a.autoPlayInterval),g.clearTimeout(b),b=g.setTimeout(function(){e=f(g).width();a.updateVars()},a.options.responsiveRefreshRate))};f(g).resize(a.resizer)},updatePosition:function(){this.jumpTo(this.currentItem);!1!==this.options.autoPlay&&this.checkAp()},appendItemsSizes:function(){var a=\nthis,b=0,e=a.itemsAmount-a.options.items;a.$owlItems.each(function(c){var d=f(this);d.css({width:a.itemWidth}).data(\"owl-item\",Number(c));if(0===c%a.options.items||c===e)c>e||(b+=1);d.data(\"owl-roundPages\",b)})},appendWrapperSizes:function(){this.$owlWrapper.css({width:this.$owlItems.length*this.itemWidth*2,left:0});this.appendItemsSizes()},calculateAll:function(){this.calculateWidth();this.appendWrapperSizes();this.loops();this.max()},calculateWidth:function(){this.itemWidth=Math.round(this.$elem.width()/\nthis.options.items)},max:function(){var a=-1*(this.itemsAmount*this.itemWidth-this.options.items*this.itemWidth);this.options.items>this.itemsAmount?this.maximumPixels=a=this.maximumItem=0:(this.maximumItem=this.itemsAmount-this.options.items,this.maximumPixels=a);return a},min:function(){return 0},loops:function(){var a=0,b=0,e,c;this.positionsInArray=[0];this.pagesInArray=[];for(e=0;e<this.itemsAmount;e+=1)b+=this.itemWidth,this.positionsInArray.push(-b),!0===this.options.scrollPerPage&&(c=f(this.$owlItems[e]),\nc=c.data(\"owl-roundPages\"),c!==a&&(this.pagesInArray[a]=this.positionsInArray[e],a=c))},buildControls:function(){if(!0===this.options.navigation||!0===this.options.pagination)this.owlControls=f('<div class=\"owl-controls\"/>').toggleClass(\"clickable\",!this.browser.isTouch).appendTo(this.$elem);!0===this.options.pagination&&this.buildPagination();!0===this.options.navigation&&this.buildButtons()},buildButtons:function(){var a=this,b=f('<div class=\"owl-buttons\"/>');a.owlControls.append(b);a.buttonPrev=\nf(\"<div/>\",{\"class\":\"owl-prev\",html:a.options.navigationText[0]||\"\"});a.buttonNext=f(\"<div/>\",{\"class\":\"owl-next\",html:a.options.navigationText[1]||\"\"});b.append(a.buttonPrev).append(a.buttonNext);b.on(\"touchstart.owlControls mousedown.owlControls\",'div[class^=\"owl\"]',function(a){a.preventDefault()});b.on(\"touchend.owlControls mouseup.owlControls\",'div[class^=\"owl\"]',function(b){b.preventDefault();f(this).hasClass(\"owl-next\")?a.next():a.prev()})},buildPagination:function(){var a=this;a.paginationWrapper=\nf('<div class=\"owl-pagination\"/>');a.owlControls.append(a.paginationWrapper);a.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\",\".owl-page\",function(b){b.preventDefault();Number(f(this).data(\"owl-page\"))!==a.currentItem&&a.goTo(Number(f(this).data(\"owl-page\")),!0)})},updatePagination:function(){var a,b,e,c,d,g;if(!1===this.options.pagination)return!1;this.paginationWrapper.html(\"\");a=0;b=this.itemsAmount-this.itemsAmount%this.options.items;for(c=0;c<this.itemsAmount;c+=1)0===c%this.options.items&&\n(a+=1,b===c&&(e=this.itemsAmount-this.options.items),d=f(\"<div/>\",{\"class\":\"owl-page\"}),g=f(\"<span></span>\",{text:!0===this.options.paginationNumbers?a:\"\",\"class\":!0===this.options.paginationNumbers?\"owl-numbers\":\"\"}),d.append(g),d.data(\"owl-page\",b===c?e:c),d.data(\"owl-roundPages\",a),this.paginationWrapper.append(d));this.checkPagination()},checkPagination:function(){var a=this;if(!1===a.options.pagination)return!1;a.paginationWrapper.find(\".owl-page\").each(function(){f(this).data(\"owl-roundPages\")===\nf(a.$owlItems[a.currentItem]).data(\"owl-roundPages\")&&(a.paginationWrapper.find(\".owl-page\").removeClass(\"active\"),f(this).addClass(\"active\"))})},checkNavigation:function(){if(!1===this.options.navigation)return!1;!1===this.options.rewindNav&&(0===this.currentItem&&0===this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0===this.currentItem&&0!==this.maximumItem?(this.buttonPrev.addClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")):this.currentItem===\nthis.maximumItem?(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.addClass(\"disabled\")):0!==this.currentItem&&this.currentItem!==this.maximumItem&&(this.buttonPrev.removeClass(\"disabled\"),this.buttonNext.removeClass(\"disabled\")))},updateControls:function(){this.updatePagination();this.checkNavigation();this.owlControls&&(this.options.items>=this.itemsAmount?this.owlControls.hide():this.owlControls.show())},destroyControls:function(){this.owlControls&&this.owlControls.remove()},next:function(a){if(this.isTransition)return!1;\nthis.currentItem+=!0===this.options.scrollPerPage?this.options.items:1;if(this.currentItem>this.maximumItem+(!0===this.options.scrollPerPage?this.options.items-1:0))if(!0===this.options.rewindNav)this.currentItem=0,a=\"rewind\";else return this.currentItem=this.maximumItem,!1;this.goTo(this.currentItem,a)},prev:function(a){if(this.isTransition)return!1;this.currentItem=!0===this.options.scrollPerPage&&0<this.currentItem&&this.currentItem<this.options.items?0:this.currentItem-(!0===this.options.scrollPerPage?\nthis.options.items:1);if(0>this.currentItem)if(!0===this.options.rewindNav)this.currentItem=this.maximumItem,a=\"rewind\";else return this.currentItem=0,!1;this.goTo(this.currentItem,a)},goTo:function(a,b,e){var c=this;if(c.isTransition)return!1;\"function\"===typeof c.options.beforeMove&&c.options.beforeMove.apply(this,[c.$elem]);a>=c.maximumItem?a=c.maximumItem:0>=a&&(a=0);c.currentItem=c.owl.currentItem=a;if(!1!==c.options.transitionStyle&&\"drag\"!==e&&1===c.options.items&&!0===c.browser.support3d)return c.swapSpeed(0),\n!0===c.browser.support3d?c.transition3d(c.positionsInArray[a]):c.css2slide(c.positionsInArray[a],1),c.afterGo(),c.singleItemTransition(),!1;a=c.positionsInArray[a];!0===c.browser.support3d?(c.isCss3Finish=!1,!0===b?(c.swapSpeed(\"paginationSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},c.options.paginationSpeed)):\"rewind\"===b?(c.swapSpeed(c.options.rewindSpeed),g.setTimeout(function(){c.isCss3Finish=!0},c.options.rewindSpeed)):(c.swapSpeed(\"slideSpeed\"),g.setTimeout(function(){c.isCss3Finish=!0},\nc.options.slideSpeed)),c.transition3d(a)):!0===b?c.css2slide(a,c.options.paginationSpeed):\"rewind\"===b?c.css2slide(a,c.options.rewindSpeed):c.css2slide(a,c.options.slideSpeed);c.afterGo()},jumpTo:function(a){\"function\"===typeof this.options.beforeMove&&this.options.beforeMove.apply(this,[this.$elem]);a>=this.maximumItem||-1===a?a=this.maximumItem:0>=a&&(a=0);this.swapSpeed(0);!0===this.browser.support3d?this.transition3d(this.positionsInArray[a]):this.css2slide(this.positionsInArray[a],1);this.currentItem=\nthis.owl.currentItem=a;this.afterGo()},afterGo:function(){this.prevArr.push(this.currentItem);this.prevItem=this.owl.prevItem=this.prevArr[this.prevArr.length-2];this.prevArr.shift(0);this.prevItem!==this.currentItem&&(this.checkPagination(),this.checkNavigation(),this.eachMoveUpdate(),!1!==this.options.autoPlay&&this.checkAp());\"function\"===typeof this.options.afterMove&&this.prevItem!==this.currentItem&&this.options.afterMove.apply(this,[this.$elem])},stop:function(){this.apStatus=\"stop\";g.clearInterval(this.autoPlayInterval)},\ncheckAp:function(){\"stop\"!==this.apStatus&&this.play()},play:function(){var a=this;a.apStatus=\"play\";if(!1===a.options.autoPlay)return!1;g.clearInterval(a.autoPlayInterval);a.autoPlayInterval=g.setInterval(function(){a.next(!0)},a.options.autoPlay)},swapSpeed:function(a){\"slideSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.slideSpeed)):\"paginationSpeed\"===a?this.$owlWrapper.css(this.addCssSpeed(this.options.paginationSpeed)):\"string\"!==typeof a&&this.$owlWrapper.css(this.addCssSpeed(a))},\naddCssSpeed:function(a){return{\"-webkit-transition\":\"all \"+a+\"ms ease\",\"-moz-transition\":\"all \"+a+\"ms ease\",\"-o-transition\":\"all \"+a+\"ms ease\",transition:\"all \"+a+\"ms ease\"}},removeTransition:function(){return{\"-webkit-transition\":\"\",\"-moz-transition\":\"\",\"-o-transition\":\"\",transition:\"\"}},doTranslate:function(a){return{\"-webkit-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-moz-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-o-transform\":\"translate3d(\"+a+\"px, 0px, 0px)\",\"-ms-transform\":\"translate3d(\"+\na+\"px, 0px, 0px)\",transform:\"translate3d(\"+a+\"px, 0px,0px)\"}},transition3d:function(a){this.$owlWrapper.css(this.doTranslate(a))},css2move:function(a){this.$owlWrapper.css({left:a})},css2slide:function(a,b){var e=this;e.isCssFinish=!1;e.$owlWrapper.stop(!0,!0).animate({left:a},{duration:b||e.options.slideSpeed,complete:function(){e.isCssFinish=!0}})},checkBrowser:function(){var a=k.createElement(\"div\");a.style.cssText=\"  -moz-transform:translate3d(0px, 0px, 0px); -ms-transform:translate3d(0px, 0px, 0px); -o-transform:translate3d(0px, 0px, 0px); -webkit-transform:translate3d(0px, 0px, 0px); transform:translate3d(0px, 0px, 0px)\";\na=a.style.cssText.match(/translate3d\\(0px, 0px, 0px\\)/g);this.browser={support3d:null!==a&&1===a.length,isTouch:\"ontouchstart\"in g||g.navigator.msMaxTouchPoints}},moveEvents:function(){if(!1!==this.options.mouseDrag||!1!==this.options.touchDrag)this.gestures(),this.disabledEvents()},eventTypes:function(){var a=[\"s\",\"e\",\"x\"];this.ev_types={};!0===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl mousedown.owl\",\"touchmove.owl mousemove.owl\",\"touchend.owl touchcancel.owl mouseup.owl\"]:\n!1===this.options.mouseDrag&&!0===this.options.touchDrag?a=[\"touchstart.owl\",\"touchmove.owl\",\"touchend.owl touchcancel.owl\"]:!0===this.options.mouseDrag&&!1===this.options.touchDrag&&(a=[\"mousedown.owl\",\"mousemove.owl\",\"mouseup.owl\"]);this.ev_types.start=a[0];this.ev_types.move=a[1];this.ev_types.end=a[2]},disabledEvents:function(){this.$elem.on(\"dragstart.owl\",function(a){a.preventDefault()});this.$elem.on(\"mousedown.disableTextSelect\",function(a){return f(a.target).is(\"input, textarea, select, option\")})},\ngestures:function(){function a(a){if(void 0!==a.touches)return{x:a.touches[0].pageX,y:a.touches[0].pageY};if(void 0===a.touches){if(void 0!==a.pageX)return{x:a.pageX,y:a.pageY};if(void 0===a.pageX)return{x:a.clientX,y:a.clientY}}}function b(a){\"on\"===a?(f(k).on(d.ev_types.move,e),f(k).on(d.ev_types.end,c)):\"off\"===a&&(f(k).off(d.ev_types.move),f(k).off(d.ev_types.end))}function e(b){b=b.originalEvent||b||g.event;d.newPosX=a(b).x-h.offsetX;d.newPosY=a(b).y-h.offsetY;d.newRelativeX=d.newPosX-h.relativePos;\n\"function\"===typeof d.options.startDragging&&!0!==h.dragging&&0!==d.newRelativeX&&(h.dragging=!0,d.options.startDragging.apply(d,[d.$elem]));(8<d.newRelativeX||-8>d.newRelativeX)&&!0===d.browser.isTouch&&(void 0!==b.preventDefault?b.preventDefault():b.returnValue=!1,h.sliding=!0);(10<d.newPosY||-10>d.newPosY)&&!1===h.sliding&&f(k).off(\"touchmove.owl\");d.newPosX=Math.max(Math.min(d.newPosX,d.newRelativeX/5),d.maximumPixels+d.newRelativeX/5);!0===d.browser.support3d?d.transition3d(d.newPosX):d.css2move(d.newPosX)}\nfunction c(a){a=a.originalEvent||a||g.event;var c;a.target=a.target||a.srcElement;h.dragging=!1;!0!==d.browser.isTouch&&d.$owlWrapper.removeClass(\"grabbing\");d.dragDirection=0>d.newRelativeX?d.owl.dragDirection=\"left\":d.owl.dragDirection=\"right\";0!==d.newRelativeX&&(c=d.getNewPosition(),d.goTo(c,!1,\"drag\"),h.targetElement===a.target&&!0!==d.browser.isTouch&&(f(a.target).on(\"click.disable\",function(a){a.stopImmediatePropagation();a.stopPropagation();a.preventDefault();f(a.target).off(\"click.disable\")}),\na=f._data(a.target,\"events\").click,c=a.pop(),a.splice(0,0,c)));b(\"off\")}var d=this,h={offsetX:0,offsetY:0,baseElWidth:0,relativePos:0,position:null,minSwipe:null,maxSwipe:null,sliding:null,dargging:null,targetElement:null};d.isCssFinish=!0;d.$elem.on(d.ev_types.start,\".owl-wrapper\",function(c){c=c.originalEvent||c||g.event;var e;if(3===c.which)return!1;if(!(d.itemsAmount<=d.options.items)){if(!1===d.isCssFinish&&!d.options.dragBeforeAnimFinish||!1===d.isCss3Finish&&!d.options.dragBeforeAnimFinish)return!1;\n!1!==d.options.autoPlay&&g.clearInterval(d.autoPlayInterval);!0===d.browser.isTouch||d.$owlWrapper.hasClass(\"grabbing\")||d.$owlWrapper.addClass(\"grabbing\");d.newPosX=0;d.newRelativeX=0;f(this).css(d.removeTransition());e=f(this).position();h.relativePos=e.left;h.offsetX=a(c).x-e.left;h.offsetY=a(c).y-e.top;b(\"on\");h.sliding=!1;h.targetElement=c.target||c.srcElement}})},getNewPosition:function(){var a=this.closestItem();a>this.maximumItem?a=this.currentItem=this.maximumItem:0<=this.newPosX&&(this.currentItem=\na=0);return a},closestItem:function(){var a=this,b=!0===a.options.scrollPerPage?a.pagesInArray:a.positionsInArray,e=a.newPosX,c=null;f.each(b,function(d,g){e-a.itemWidth/20>b[d+1]&&e-a.itemWidth/20<g&&\"left\"===a.moveDirection()?(c=g,a.currentItem=!0===a.options.scrollPerPage?f.inArray(c,a.positionsInArray):d):e+a.itemWidth/20<g&&e+a.itemWidth/20>(b[d+1]||b[d]-a.itemWidth)&&\"right\"===a.moveDirection()&&(!0===a.options.scrollPerPage?(c=b[d+1]||b[b.length-1],a.currentItem=f.inArray(c,a.positionsInArray)):\n(c=b[d+1],a.currentItem=d+1))});return a.currentItem},moveDirection:function(){var a;0>this.newRelativeX?(a=\"right\",this.playDirection=\"next\"):(a=\"left\",this.playDirection=\"prev\");return a},customEvents:function(){var a=this;a.$elem.on(\"owl.next\",function(){a.next()});a.$elem.on(\"owl.prev\",function(){a.prev()});a.$elem.on(\"owl.play\",function(b,e){a.options.autoPlay=e;a.play();a.hoverStatus=\"play\"});a.$elem.on(\"owl.stop\",function(){a.stop();a.hoverStatus=\"stop\"});a.$elem.on(\"owl.goTo\",function(b,e){a.goTo(e)});\na.$elem.on(\"owl.jumpTo\",function(b,e){a.jumpTo(e)})},stopOnHover:function(){var a=this;!0===a.options.stopOnHover&&!0!==a.browser.isTouch&&!1!==a.options.autoPlay&&(a.$elem.on(\"mouseover\",function(){a.stop()}),a.$elem.on(\"mouseout\",function(){\"stop\"!==a.hoverStatus&&a.play()}))},lazyLoad:function(){var a,b,e,c,d;if(!1===this.options.lazyLoad)return!1;for(a=0;a<this.itemsAmount;a+=1)b=f(this.$owlItems[a]),\"loaded\"!==b.data(\"owl-loaded\")&&(e=b.data(\"owl-item\"),c=b.find(\".lazyOwl\"),\"string\"!==typeof c.data(\"src\")?\nb.data(\"owl-loaded\",\"loaded\"):(void 0===b.data(\"owl-loaded\")&&(c.hide(),b.addClass(\"loading\").data(\"owl-loaded\",\"checked\")),(d=!0===this.options.lazyFollow?e>=this.currentItem:!0)&&e<this.currentItem+this.options.items&&c.length&&this.lazyPreload(b,c)))},lazyPreload:function(a,b){function e(){a.data(\"owl-loaded\",\"loaded\").removeClass(\"loading\");b.removeAttr(\"data-src\");\"fade\"===d.options.lazyEffect?b.fadeIn(400):b.show();\"function\"===typeof d.options.afterLazyLoad&&d.options.afterLazyLoad.apply(this,\n[d.$elem])}function c(){f+=1;d.completeImg(b.get(0))||!0===k?e():100>=f?g.setTimeout(c,100):e()}var d=this,f=0,k;\"DIV\"===b.prop(\"tagName\")?(b.css(\"background-image\",\"url(\"+b.data(\"src\")+\")\"),k=!0):b[0].src=b.data(\"src\");c()},autoHeight:function(){function a(){var a=f(e.$owlItems[e.currentItem]).height();e.wrapperOuter.css(\"height\",a+\"px\");e.wrapperOuter.hasClass(\"autoHeight\")||g.setTimeout(function(){e.wrapperOuter.addClass(\"autoHeight\")},0)}function b(){d+=1;e.completeImg(c.get(0))?a():100>=d?g.setTimeout(b,\n100):e.wrapperOuter.css(\"height\",\"\")}var e=this,c=f(e.$owlItems[e.currentItem]).find(\"img\"),d;void 0!==c.get(0)?(d=0,b()):a()},completeImg:function(a){return!a.complete||\"undefined\"!==typeof a.naturalWidth&&0===a.naturalWidth?!1:!0},onVisibleItems:function(){var a;!0===this.options.addClassActive&&this.$owlItems.removeClass(\"active\");this.visibleItems=[];for(a=this.currentItem;a<this.currentItem+this.options.items;a+=1)this.visibleItems.push(a),!0===this.options.addClassActive&&f(this.$owlItems[a]).addClass(\"active\");\nthis.owl.visibleItems=this.visibleItems},transitionTypes:function(a){this.outClass=\"owl-\"+a+\"-out\";this.inClass=\"owl-\"+a+\"-in\"},singleItemTransition:function(){var a=this,b=a.outClass,e=a.inClass,c=a.$owlItems.eq(a.currentItem),d=a.$owlItems.eq(a.prevItem),f=Math.abs(a.positionsInArray[a.currentItem])+a.positionsInArray[a.prevItem],g=Math.abs(a.positionsInArray[a.currentItem])+a.itemWidth/2;a.isTransition=!0;a.$owlWrapper.addClass(\"owl-origin\").css({\"-webkit-transform-origin\":g+\"px\",\"-moz-perspective-origin\":g+\n\"px\",\"perspective-origin\":g+\"px\"});d.css({position:\"relative\",left:f+\"px\"}).addClass(b).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endPrev=!0;d.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(d,b)});c.addClass(e).on(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\",function(){a.endCurrent=!0;c.off(\"webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend\");a.clearTransStyle(c,e)})},clearTransStyle:function(a,\nb){a.css({position:\"\",left:\"\"}).removeClass(b);this.endPrev&&this.endCurrent&&(this.$owlWrapper.removeClass(\"owl-origin\"),this.isTransition=this.endCurrent=this.endPrev=!1)},owlStatus:function(){this.owl={userOptions:this.userOptions,baseElement:this.$elem,userItems:this.$userItems,owlItems:this.$owlItems,currentItem:this.currentItem,prevItem:this.prevItem,visibleItems:this.visibleItems,isTouch:this.browser.isTouch,browser:this.browser,dragDirection:this.dragDirection}},clearEvents:function(){this.$elem.off(\".owl owl mousedown.disableTextSelect\");\nf(k).off(\".owl owl\");f(g).off(\"resize\",this.resizer)},unWrap:function(){0!==this.$elem.children().length&&(this.$owlWrapper.unwrap(),this.$userItems.unwrap().unwrap(),this.owlControls&&this.owlControls.remove());this.clearEvents();this.$elem.attr(\"style\",this.$elem.data(\"owl-originalStyles\")||\"\").attr(\"class\",this.$elem.data(\"owl-originalClasses\"))},destroy:function(){this.stop();g.clearInterval(this.checkVisible);this.unWrap();this.$elem.removeData()},reinit:function(a){a=f.extend({},this.userOptions,\na);this.unWrap();this.init(a,this.$elem)},addItem:function(a,b){var e;if(!a)return!1;if(0===this.$elem.children().length)return this.$elem.append(a),this.setVars(),!1;this.unWrap();e=void 0===b||-1===b?-1:b;e>=this.$userItems.length||-1===e?this.$userItems.eq(-1).after(a):this.$userItems.eq(e).before(a);this.setVars()},removeItem:function(a){if(0===this.$elem.children().length)return!1;a=void 0===a||-1===a?-1:a;this.unWrap();this.$userItems.eq(a).remove();this.setVars()}};f.fn.owlCarousel=function(a){return this.each(function(){if(!0===\nf(this).data(\"owl-init\"))return!1;f(this).data(\"owl-init\",!0);var b=Object.create(l);b.init(a,this);f.data(this,\"owlCarousel\",b)})};f.fn.owlCarousel.options={items:5,itemsCustom:!1,itemsDesktop:[1199,4],itemsDesktopSmall:[979,3],itemsTablet:[768,2],itemsTabletSmall:!1,itemsMobile:[479,1],singleItem:!1,itemsScaleUp:!1,slideSpeed:200,paginationSpeed:800,rewindSpeed:1E3,autoPlay:!1,stopOnHover:!1,navigation:!1,navigationText:[\"prev\",\"next\"],rewindNav:!0,scrollPerPage:!1,pagination:!0,paginationNumbers:!1,\nresponsive:!0,responsiveRefreshRate:200,responsiveBaseWidth:g,baseClass:\"owl-carousel\",theme:\"owl-theme\",lazyLoad:!1,lazyFollow:!0,lazyEffect:\"fade\",autoHeight:!1,jsonPath:!1,jsonSuccess:!1,dragBeforeAnimFinish:!0,mouseDrag:!0,touchDrag:!0,addClassActive:!1,transitionStyle:!1,beforeUpdate:!1,afterUpdate:!1,beforeInit:!1,afterInit:!1,beforeMove:!1,afterMove:!1,afterAction:!1,startDragging:!1,afterLazyLoad:!1}})(jQuery,window,document);\n});","Plazathemes_Newsletterpopup/js/jquery.bpopup.min.js":"/*================================================================================\r\n * @name: bPopup - if you can't get it up, use bPopup\r\n * @author: (c)Bjoern Klinggaard (twitter@bklinggaard)\r\n * @demo: http://dinbror.dk/bpopup\r\n * @version: 0.9.4.min\r\n ================================================================================*/\r\n require([\"jquery\"], function($){\r\n (function(b){b.fn.bPopup=function(z,F){function K(){a.contentContainer=b(a.contentContainer||c);switch(a.content){case \"iframe\":var h=b('<iframe class=\"b-iframe\" '+a.iframeAttr+\"></iframe>\");h.appendTo(a.contentContainer);r=c.outerHeight(!0);s=c.outerWidth(!0);A();h.attr(\"src\",a.loadUrl);k(a.loadCallback);break;case \"image\":A();b(\"<img />\").load(function(){k(a.loadCallback);G(b(this))}).attr(\"src\",a.loadUrl).hide().appendTo(a.contentContainer);break;default:A(),b('<div class=\"b-ajax-wrapper\"></div>').load(a.loadUrl,a.loadData,function(){k(a.loadCallback);G(b(this))}).hide().appendTo(a.contentContainer)}}function A(){a.modal&&b('<div class=\"b-modal '+e+'\"></div>').css({backgroundColor:a.modalColor,position:\"fixed\",top:0,right:0,bottom:0,left:0,opacity:0,zIndex:a.zIndex+t}).appendTo(a.appendTo).fadeTo(a.speed,a.opacity);D();c.data(\"bPopup\",a).data(\"id\",e).css({left:\"slideIn\"==a.transition||\"slideBack\"==a.transition?\"slideBack\"==a.transition?g.scrollLeft()+u:-1*(v+s):l(!(!a.follow[0]&&m||f)),position:a.positionStyle||\"absolute\",top:\"slideDown\"==a.transition||\"slideUp\"==a.transition?\"slideUp\"==a.transition?g.scrollTop()+w:x+-1*r:n(!(!a.follow[1]&&p||f)),\"z-index\":a.zIndex+t+1}).each(function(){a.appending&&b(this).appendTo(a.appendTo)});H(!0)}function q(){a.modal&&b(\".b-modal.\"+c.data(\"id\")).fadeTo(a.speed,0,function(){b(this).remove()});a.scrollBar||b(\"html\").css(\"overflow\",\"auto\");b(\".b-modal.\"+e).unbind(\"click\");g.unbind(\"keydown.\"+e);d.unbind(\".\"+e).data(\"bPopup\",0<d.data(\"bPopup\")-1?d.data(\"bPopup\")-1:null);c.undelegate(\".bClose, .\"+a.closeClass,\"click.\"+e,q).data(\"bPopup\",null);H();return!1}function G(h){var b=h.width(),e=h.height(),d={};a.contentContainer.css({height:e,width:b});e>=c.height()&&(d.height=c.height());b>=c.width()&&(d.width=c.width());r=c.outerHeight(!0);s=c.outerWidth(!0);D();a.contentContainer.css({height:\"auto\",width:\"auto\"});d.left=l(!(!a.follow[0]&&m||f));d.top=n(!(!a.follow[1]&&p||f));c.animate(d,250,function(){h.show();B=E()})}function L(){d.data(\"bPopup\",t);c.delegate(\".bClose, .\"+a.closeClass,\"click.\"+e,q);a.modalClose&&b(\".b-modal.\"+e).css(\"cursor\",\"pointer\").bind(\"click\",q);M||!a.follow[0]&&!a.follow[1]||d.bind(\"scroll.\"+e,function(){B&&c.dequeue().animate({left:a.follow[0]?l(!f):\"auto\",top:a.follow[1]?n(!f):\"auto\"},a.followSpeed,a.followEasing)}).bind(\"resize.\"+e,function(){w=y.innerHeight||d.height();u=y.innerWidth||d.width();if(B=E())clearTimeout(I),I=setTimeout(function(){D();c.dequeue().each(function(){f?b(this).css({left:v,top:x}):b(this).animate({left:a.follow[0]?l(!0):\"auto\",top:a.follow[1]?n(!0):\"auto\"},a.followSpeed,a.followEasing)})},50)});a.escClose&&g.bind(\"keydown.\"+e,function(a){27==a.which&&q()})}function H(b){function d(e){c.css({display:\"block\",opacity:1}).animate(e,a.speed,a.easing,function(){J(b)})}switch(b?a.transition:a.transitionClose||a.transition){case \"slideIn\":d({left:b?l(!(!a.follow[0]&&m||f)):g.scrollLeft()-(s||c.outerWidth(!0))-C});break;case \"slideBack\":d({left:b?l(!(!a.follow[0]&&m||f)):g.scrollLeft()+u+C});break;case \"slideDown\":d({top:b?n(!(!a.follow[1]&&p||f)):g.scrollTop()-(r||c.outerHeight(!0))-C});break;case \"slideUp\":d({top:b?n(!(!a.follow[1]&&p||f)):g.scrollTop()+w+C});break;default:c.stop().fadeTo(a.speed,b?1:0,function(){J(b)})}}function J(b){b?(L(),k(F),a.autoClose&&setTimeout(q,a.autoClose)):(c.hide(),k(a.onClose),a.loadUrl&&(a.contentContainer.empty(),c.css({height:\"auto\",width:\"auto\"})))}function l(a){return a?v+g.scrollLeft():v}function n(a){return a?x+g.scrollTop():x}function k(a){b.isFunction(a)&&a.call(c)}function D(){x=p?a.position[1]:Math.max(0,(w-c.outerHeight(!0))/2-a.amsl);v=m?a.position[0]:(u-c.outerWidth(!0))/2;B=E()}function E(){return w>c.outerHeight(!0)&&u>c.outerWidth(!0)}b.isFunction(z)&&(F=z,z=null);var a=b.extend({},b.fn.bPopup.defaults,z);a.scrollBar||b(\"html\").css(\"overflow\",\"hidden\");var c=this,g=b(document),y=window,d=b(y),w=y.innerHeight||d.height(),u=y.innerWidth||d.width(),M=/OS 6(_\\d)+/i.test(navigator.userAgent),C=200,t=0,e,B,p,m,f,x,v,r,s,I;c.close=function(){a=this.data(\"bPopup\");e=\"__b-popup\"+d.data(\"bPopup\")+\"__\";q()};return c.each(function(){b(this).data(\"bPopup\")||(k(a.onOpen),t=(d.data(\"bPopup\")||0)+1,e=\"__b-popup\"+t+\"__\",p=\"auto\"!==a.position[1],m=\"auto\"!==a.position[0],f=\"fixed\"===a.positionStyle,r=c.outerHeight(!0),s=c.outerWidth(!0),a.loadUrl?K():A())})};b.fn.bPopup.defaults={amsl:50,appending:!0,appendTo:\"body\",autoClose:!1,closeClass:\"b-close\",content:\"ajax\",contentContainer:!1,easing:\"swing\",escClose:!0,follow:[!0,!0],followEasing:\"swing\",followSpeed:500,iframeAttr:'scrolling=\"no\" frameborder=\"0\"',loadCallback:!1,loadData:!1,loadUrl:!1,modal:!0,modalClose:!0,modalColor:\"#000\",onClose:!1,onOpen:!1,opacity:0.7,position:[\"auto\",\"auto\"],positionStyle:\"absolute\",scrollBar:!0,speed:250,transition:\"fadeIn\",transitionClose:!1,zIndex:9997}})(jQuery);\r\n });","Plazathemes_Newsletterpopup/js/jquery.easing.1.3.js":"/*\n * jQuery Easing v1.3 - http://gsgd.co.uk/sandbox/jquery/easing/\n *\n * Uses the built in easing capabilities added In jQuery 1.1\n * to offer multiple easing options\n *\n * TERMS OF USE - jQuery Easing\n * \n * Open source under the BSD License. \n * \n * Copyright \u00c2\u00a9 2008 George McGinley Smith\n * All rights reserved.\n * \n * Redistribution and use in source and binary forms, with or without modification, \n * are permitted provided that the following conditions are met:\n * \n * Redistributions of source code must retain the above copyright notice, this list of \n * conditions and the following disclaimer.\n * Redistributions in binary form must reproduce the above copyright notice, this list \n * of conditions and the following disclaimer in the documentation and/or other materials \n * provided with the distribution.\n * \n * Neither the name of the author nor the names of contributors may be used to endorse \n * or promote products derived from this software without specific prior written permission.\n * \n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY \n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE\n *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE\n *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED \n * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED \n * OF THE POSSIBILITY OF SUCH DAMAGE. \n *\n*/\n\n// t: current time, b: begInnIng value, c: change In value, d: duration\n$jq.easing['jswing'] = $jq.easing['swing'];\n\n$jq.extend( $jq.easing,\n{\n\tdef: 'easeOutQuad',\n\tswing: function (x, t, b, c, d) {\n\t\t//alert(jQuery.easing.default);\n\t\treturn $jq.easing[$jq.easing.def](x, t, b, c, d);\n\t},\n\teaseInQuad: function (x, t, b, c, d) {\n\t\treturn c*(t/=d)*t + b;\n\t},\n\teaseOutQuad: function (x, t, b, c, d) {\n\t\treturn -c *(t/=d)*(t-2) + b;\n\t},\n\teaseInOutQuad: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return c/2*t*t + b;\n\t\treturn -c/2 * ((--t)*(t-2) - 1) + b;\n\t},\n\teaseInCubic: function (x, t, b, c, d) {\n\t\treturn c*(t/=d)*t*t + b;\n\t},\n\teaseOutCubic: function (x, t, b, c, d) {\n\t\treturn c*((t=t/d-1)*t*t + 1) + b;\n\t},\n\teaseInOutCubic: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return c/2*t*t*t + b;\n\t\treturn c/2*((t-=2)*t*t + 2) + b;\n\t},\n\teaseInQuart: function (x, t, b, c, d) {\n\t\treturn c*(t/=d)*t*t*t + b;\n\t},\n\teaseOutQuart: function (x, t, b, c, d) {\n\t\treturn -c * ((t=t/d-1)*t*t*t - 1) + b;\n\t},\n\teaseInOutQuart: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return c/2*t*t*t*t + b;\n\t\treturn -c/2 * ((t-=2)*t*t*t - 2) + b;\n\t},\n\teaseInQuint: function (x, t, b, c, d) {\n\t\treturn c*(t/=d)*t*t*t*t + b;\n\t},\n\teaseOutQuint: function (x, t, b, c, d) {\n\t\treturn c*((t=t/d-1)*t*t*t*t + 1) + b;\n\t},\n\teaseInOutQuint: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return c/2*t*t*t*t*t + b;\n\t\treturn c/2*((t-=2)*t*t*t*t + 2) + b;\n\t},\n\teaseInSine: function (x, t, b, c, d) {\n\t\treturn -c * Math.cos(t/d * (Math.PI/2)) + c + b;\n\t},\n\teaseOutSine: function (x, t, b, c, d) {\n\t\treturn c * Math.sin(t/d * (Math.PI/2)) + b;\n\t},\n\teaseInOutSine: function (x, t, b, c, d) {\n\t\treturn -c/2 * (Math.cos(Math.PI*t/d) - 1) + b;\n\t},\n\teaseInExpo: function (x, t, b, c, d) {\n\t\treturn (t==0) ? b : c * Math.pow(2, 10 * (t/d - 1)) + b;\n\t},\n\teaseOutExpo: function (x, t, b, c, d) {\n\t\treturn (t==d) ? b+c : c * (-Math.pow(2, -10 * t/d) + 1) + b;\n\t},\n\teaseInOutExpo: function (x, t, b, c, d) {\n\t\tif (t==0) return b;\n\t\tif (t==d) return b+c;\n\t\tif ((t/=d/2) < 1) return c/2 * Math.pow(2, 10 * (t - 1)) + b;\n\t\treturn c/2 * (-Math.pow(2, -10 * --t) + 2) + b;\n\t},\n\teaseInCirc: function (x, t, b, c, d) {\n\t\treturn -c * (Math.sqrt(1 - (t/=d)*t) - 1) + b;\n\t},\n\teaseOutCirc: function (x, t, b, c, d) {\n\t\treturn c * Math.sqrt(1 - (t=t/d-1)*t) + b;\n\t},\n\teaseInOutCirc: function (x, t, b, c, d) {\n\t\tif ((t/=d/2) < 1) return -c/2 * (Math.sqrt(1 - t*t) - 1) + b;\n\t\treturn c/2 * (Math.sqrt(1 - (t-=2)*t) + 1) + b;\n\t},\n\teaseInElastic: function (x, t, b, c, d) {\n\t\tvar s=1.70158;var p=0;var a=c;\n\t\tif (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;\n\t\tif (a < Math.abs(c)) { a=c; var s=p/4; }\n\t\telse var s = p/(2*Math.PI) * Math.asin (c/a);\n\t\treturn -(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;\n\t},\n\teaseOutElastic: function (x, t, b, c, d) {\n\t\tvar s=1.70158;var p=0;var a=c;\n\t\tif (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;\n\t\tif (a < Math.abs(c)) { a=c; var s=p/4; }\n\t\telse var s = p/(2*Math.PI) * Math.asin (c/a);\n\t\treturn a*Math.pow(2,-10*t) * Math.sin( (t*d-s)*(2*Math.PI)/p ) + c + b;\n\t},\n\teaseInOutElastic: function (x, t, b, c, d) {\n\t\tvar s=1.70158;var p=0;var a=c;\n\t\tif (t==0) return b;  if ((t/=d/2)==2) return b+c;  if (!p) p=d*(.3*1.5);\n\t\tif (a < Math.abs(c)) { a=c; var s=p/4; }\n\t\telse var s = p/(2*Math.PI) * Math.asin (c/a);\n\t\tif (t < 1) return -.5*(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;\n\t\treturn a*Math.pow(2,-10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )*.5 + c + b;\n\t},\n\teaseInBack: function (x, t, b, c, d, s) {\n\t\tif (s == undefined) s = 1.70158;\n\t\treturn c*(t/=d)*t*((s+1)*t - s) + b;\n\t},\n\teaseOutBack: function (x, t, b, c, d, s) {\n\t\tif (s == undefined) s = 1.70158;\n\t\treturn c*((t=t/d-1)*t*((s+1)*t + s) + 1) + b;\n\t},\n\teaseInOutBack: function (x, t, b, c, d, s) {\n\t\tif (s == undefined) s = 1.70158; \n\t\tif ((t/=d/2) < 1) return c/2*(t*t*(((s*=(1.525))+1)*t - s)) + b;\n\t\treturn c/2*((t-=2)*t*(((s*=(1.525))+1)*t + s) + 2) + b;\n\t},\n\teaseInBounce: function (x, t, b, c, d) {\n\t\treturn c - $jq.easing.easeOutBounce (x, d-t, 0, c, d) + b;\n\t},\n\teaseOutBounce: function (x, t, b, c, d) {\n\t\tif ((t/=d) < (1/2.75)) {\n\t\t\treturn c*(7.5625*t*t) + b;\n\t\t} else if (t < (2/2.75)) {\n\t\t\treturn c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;\n\t\t} else if (t < (2.5/2.75)) {\n\t\t\treturn c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;\n\t\t} else {\n\t\t\treturn c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;\n\t\t}\n\t},\n\teaseInOutBounce: function (x, t, b, c, d) {\n\t\tif (t < d/2) return $jq.easing.easeInBounce (x, t*2, 0, c, d) * .5 + b;\n\t\treturn $jq.easing.easeOutBounce (x, t*2-d, 0, c, d) * .5 + c*.5 + b;\n\t}\n});\n\n/*\n *\n * TERMS OF USE - EASING EQUATIONS\n * \n * Open source under the BSD License. \n * \n * Copyright \u00c2\u00a9 2001 Robert Penner\n * All rights reserved.\n * \n * Redistribution and use in source and binary forms, with or without modification, \n * are permitted provided that the following conditions are met:\n * \n * Redistributions of source code must retain the above copyright notice, this list of \n * conditions and the following disclaimer.\n * Redistributions in binary form must reproduce the above copyright notice, this list \n * of conditions and the following disclaimer in the documentation and/or other materials \n * provided with the distribution.\n * \n * Neither the name of the author nor the names of contributors may be used to endorse \n * or promote products derived from this software without specific prior written permission.\n * \n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY \n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE\n *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE\n *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED \n * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED \n * OF THE POSSIBILITY OF SUCH DAMAGE. \n *\n */","Plazathemes_Newsletterpopup/js/js.cookie.js":"/*!\n * JavaScript Cookie v2.0.4\n * https://github.com/js-cookie/js-cookie\n *\n * Copyright 2006, 2015 Klaus Hartl & Fagner Brack\n * Released under the MIT license\n */\n(function (factory) {\n\tif (typeof define === 'function' && define.amd) {\n\t\tdefine(factory);\n\t} else if (typeof exports === 'object') {\n\t\tmodule.exports = factory();\n\t} else {\n\t\tvar _OldCookies = window.Cookies;\n\t\tvar api = window.Cookies = factory();\n\t\tapi.noConflict = function () {\n\t\t\twindow.Cookies = _OldCookies;\n\t\t\treturn api;\n\t\t};\n\t}\n}(function () {\n\tfunction extend () {\n\t\tvar i = 0;\n\t\tvar result = {};\n\t\tfor (; i < arguments.length; i++) {\n\t\t\tvar attributes = arguments[ i ];\n\t\t\tfor (var key in attributes) {\n\t\t\t\tresult[key] = attributes[key];\n\t\t\t}\n\t\t}\n\t\treturn result;\n\t}\n\n\tfunction init (converter) {\n\t\tfunction api (key, value, attributes) {\n\t\t\tvar result;\n\n\t\t\t// Write\n\n\t\t\tif (arguments.length > 1) {\n\t\t\t\tattributes = extend({\n\t\t\t\t\tpath: '/'\n\t\t\t\t}, api.defaults, attributes);\n\n\t\t\t\tif (typeof attributes.expires === 'number') {\n\t\t\t\t\tvar expires = new Date();\n\t\t\t\t\texpires.setMilliseconds(expires.getMilliseconds() + attributes.expires * 864e+5);\n\t\t\t\t\tattributes.expires = expires;\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tresult = JSON.stringify(value);\n\t\t\t\t\tif (/^[\\{\\[]/.test(result)) {\n\t\t\t\t\t\tvalue = result;\n\t\t\t\t\t}\n\t\t\t\t} catch (e) {}\n\n\t\t\t\tif (!converter.write) {\n\t\t\t\t\tvalue = encodeURIComponent(String(value))\n\t\t\t\t\t\t.replace(/%(23|24|26|2B|3A|3C|3E|3D|2F|3F|40|5B|5D|5E|60|7B|7D|7C)/g, decodeURIComponent);\n\t\t\t\t} else {\n\t\t\t\t\tvalue = converter.write(value, key);\n\t\t\t\t}\n\n\t\t\t\tkey = encodeURIComponent(String(key));\n\t\t\t\tkey = key.replace(/%(23|24|26|2B|5E|60|7C)/g, decodeURIComponent);\n\t\t\t\tkey = key.replace(/[\\(\\)]/g, escape);\n\n\t\t\t\treturn (document.cookie = [\n\t\t\t\t\tkey, '=', value,\n\t\t\t\t\tattributes.expires && '; expires=' + attributes.expires.toUTCString(), // use expires attribute, max-age is not supported by IE\n\t\t\t\t\tattributes.path    && '; path=' + attributes.path,\n\t\t\t\t\tattributes.domain  && '; domain=' + attributes.domain,\n\t\t\t\t\tattributes.secure ? '; secure' : ''\n\t\t\t\t].join(''));\n\t\t\t}\n\n\t\t\t// Read\n\n\t\t\tif (!key) {\n\t\t\t\tresult = {};\n\t\t\t}\n\n\t\t\t// To prevent the for loop in the first place assign an empty array\n\t\t\t// in case there are no cookies at all. Also prevents odd result when\n\t\t\t// calling \"get()\"\n\t\t\tvar cookies = document.cookie ? document.cookie.split('; ') : [];\n\t\t\tvar rdecode = /(%[0-9A-Z]{2})+/g;\n\t\t\tvar i = 0;\n\n\t\t\tfor (; i < cookies.length; i++) {\n\t\t\t\tvar parts = cookies[i].split('=');\n\t\t\t\tvar name = parts[0].replace(rdecode, decodeURIComponent);\n\t\t\t\tvar cookie = parts.slice(1).join('=');\n\n\t\t\t\tif (cookie.charAt(0) === '\"') {\n\t\t\t\t\tcookie = cookie.slice(1, -1);\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tcookie = converter.read ?\n\t\t\t\t\t\tconverter.read(cookie, name) : converter(cookie, name) ||\n\t\t\t\t\t\tcookie.replace(rdecode, decodeURIComponent);\n\n\t\t\t\t\tif (this.json) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tcookie = JSON.parse(cookie);\n\t\t\t\t\t\t} catch (e) {}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (key === name) {\n\t\t\t\t\t\tresult = cookie;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!key) {\n\t\t\t\t\t\tresult[name] = cookie;\n\t\t\t\t\t}\n\t\t\t\t} catch (e) {}\n\t\t\t}\n\n\t\t\treturn result;\n\t\t}\n\n\t\tapi.get = api.set = api;\n\t\tapi.getJSON = function () {\n\t\t\treturn api.apply({\n\t\t\t\tjson: true\n\t\t\t}, [].slice.call(arguments));\n\t\t};\n\t\tapi.defaults = {};\n\n\t\tapi.remove = function (key, attributes) {\n\t\t\tapi(key, '', extend(attributes, {\n\t\t\t\texpires: -1\n\t\t\t}));\n\t\t};\n\n\t\tapi.withConverter = init;\n\n\t\treturn api;\n\t}\n\n\treturn init(function () {});\n}));\n","js/navigation-menu.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\n\ndefine([\n    \"jquery\",\n    \"matchMedia\",\n    \"mage/template\",\n    \"mage/dropdowns\",\n    \"mage/terms\"\n],function($, mediaCheck, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.navigationMenu', {\n        options: {\n            itemsContainer: '> ul',\n            topLevel: 'li.level0',\n            topLevelSubmenu: '> .submenu',\n            topLevelHoverClass: 'hover',\n            expandedTopLevel: '.more',\n            hoverInTimeout: 300,\n            hoverOutTimeout: 500,\n            submenuAnimationSpeed: 200,\n            collapsable: true,\n            collapsableDropdownTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<li class=\"level0 level-top more parent\">' +\n                        '<div class=\"submenu\">' +\n                            '<ul><%= elems %></ul>' +\n                        '</div>' +\n                    '</li>' +\n                '</script>'\n        },\n\n        _create: function() {\n            this.itemsContainer = $(this.options.itemsContainer, this.element);\n            this.topLevel = $(this.options.topLevel, this.element);\n            this.topLevelSubmenu = $(this.options.topLevelSubmenu, this.topLevel);\n\n            this._bind();\n        },\n\n        _init: function() {\n            if (this.options.collapsable) {\n                setTimeout($.proxy(function() {\n                    this._checkToCollapseOrExpand();\n                }, this), 100);\n            }\n        },\n\n        _bind: function() {\n            this._on({\n                'mouseenter > ul > li.level0': function(e) {\n                    if (!this.entered) { // fix IE bug with 'mouseenter' event\n                        this.timeoutId && clearTimeout(this.timeoutId);\n                        this.timeoutId = setTimeout($.proxy(function() {\n                            this._openSubmenu(e);\n                        }, this), this.options.hoverInTimeout);\n                        this.entered = true;\n                    }\n                },\n                'mouseleave > ul > li.level0': function(e) {\n                    this.entered = null;\n\n                    this.timeoutId && clearTimeout(this.timeoutId);\n                    this.timeoutId = setTimeout($.proxy(function() {\n                        this._closeSubmenu(e.currentTarget);\n                    }, this), this.options.hoverOutTimeout);\n                },\n                'click': function(e) {\n                    e.stopPropagation();\n                }\n            });\n\n            $(document)\n                .on('click.hideMenu', $.proxy(function(e) {\n                    var isOpened = this.topLevel.filter(function() {\n                        return $(this).data('opened');\n                    });\n\n                    if (isOpened) {\n                        this._closeSubmenu(null, false);\n                    }\n                }, this));\n\n            $(window)\n                .on('resize', $.proxy(function() {\n                    this.timeoutOnResize && clearTimeout(this.timeoutOnResize);\n                    this.timeoutOnResize = setTimeout($.proxy(function() {\n                        if (this.options.collapsable) {\n                            if ($(this.options.expandedTopLevel, this.element).length) {\n                                this._expandMenu();\n                            }\n                            this._checkToCollapseOrExpand();\n                        }\n                    }, this), 300);\n                }, this));\n        },\n\n        _openSubmenu: function(e) {\n            var menuItem = e.currentTarget;\n\n            if (!$(menuItem).data('opened')) {\n                this._closeSubmenu(menuItem, true, true);\n\n                $(this.options.topLevelSubmenu, menuItem)\n                    .slideDown(this.options.submenuAnimationSpeed, $.proxy(function() {\n                        $(menuItem).addClass(this.options.topLevelHoverClass);\n                        $(menuItem).data('opened', true);\n                    }, this));\n            } else if ($(e.target).closest(this.options.topLevel)) {\n                $(e.target)\n                    .addClass(this.options.topLevelHoverClass)\n                    .siblings(this.options.topLevel)\n                        .removeClass(this.options.topLevelHoverClass);\n            }\n        },\n\n        _closeSubmenu: function(menuItem, excludeCurrent, fast) {\n            var topLevel = $(this.options.topLevel, this.element),\n                activeSubmenu = $(this.options.topLevelSubmenu, menuItem || null);\n\n            $(this.options.topLevelSubmenu, topLevel)\n                .filter(function() {\n                    return excludeCurrent ? $(this).not(activeSubmenu) : true;\n                })\n                .slideUp(fast ? 0 : this.options.submenuAnimationSpeed);\n\n            topLevel\n                .removeClass(this.options.topLevelHoverClass)\n                .data('opened', false);\n        },\n\n        _checkToCollapseOrExpand: function() {\n            if ($(\"html\").hasClass(\"lt-640\") || $(\"html\").hasClass(\"w-640\")) {\n                return;\n            }\n\n            var navWidth = this.itemsContainer.width(),\n                totalWidth = 0,\n                startCollapseIndex = 0;\n\n            $.each($(this.options.topLevel, this.element), function(index, item) {\n                totalWidth = totalWidth + $(item).outerWidth(true);\n\n                if (totalWidth > navWidth && !startCollapseIndex) {\n                    startCollapseIndex = index - 2;\n                }\n            });\n\n            this[startCollapseIndex ? '_collapseMenu' : '_expandMenu'](startCollapseIndex);\n        },\n\n        _collapseMenu: function(startCollapseIndex) {\n            this.elemsToCollapse = this.topLevel.filter(function(index) {\n                return index > startCollapseIndex;\n            });\n            this.elemsToCollapseClone = $('<div></div>').append(this.elemsToCollapse.clone()).html();\n\n            this.collapsableDropdown = $(\n                mageTemplate(\n                    this.options.collapsableDropdownTemplate,\n                    {elems: this.elemsToCollapseClone}\n                )\n            );\n\n            this.itemsContainer.append(this.collapsableDropdown);\n            this.elemsToCollapse.detach();\n        },\n\n        _expandMenu: function() {\n            this.elemsToCollapse && this.elemsToCollapse.appendTo(this.itemsContainer);\n            this.collapsableDropdown && this.collapsableDropdown.remove();\n        },\n\n        _destroy: function() {\n            this._expandMenu();\n        }\n    });\n\n    /*\n     * Provides \"Continium\" effect for submenu\n     * */\n    $.widget('mage.navigationMenu', $.mage.navigationMenu, {\n        options: {\n            parentLevel: '> ul > li.level0',\n            submenuAnimationSpeed: 150,\n            submenuContiniumEffect: false\n        },\n\n        _init: function() {\n            this._super();\n            this._applySubmenuStyles();\n        },\n\n        _applySubmenuStyles: function() {\n            $(this.options.topLevelSubmenu, $(this.options.topLevel, this.element))\n                .removeAttr('style');\n\n            $(this.options.topLevelSubmenu, $(this.options.parentLevel, this.element))\n                .css({\n                    display: 'block',\n                    height: 0,\n                    overflow: 'hidden'\n                });\n        },\n\n        _openSubmenu: function(e) {\n            var menuItem = e.currentTarget,\n                submenu = $(this.options.topLevelSubmenu, menuItem),\n                openedItems = $(this.options.topLevel, this.element).filter(function() {\n                    return $(this).data('opened');\n                });\n\n            if (submenu.length) {\n                this.heightToAnimate = $(this.options.itemsContainer, submenu).outerHeight(true);\n\n                if (openedItems.length) {\n                    this._closeSubmenu(menuItem, true, this.heightToAnimate, $.proxy(function() {\n                        submenu.css({\n                            height: 'auto'\n                        });\n                        $(menuItem)\n                            .addClass(this.options.topLevelHoverClass);\n                    }, this), e);\n                } else {\n                    submenu.animate({\n                        height: this.heightToAnimate\n                    }, this.options.submenuAnimationSpeed, $.proxy(function() {\n                        $(menuItem)\n                            .addClass(this.options.topLevelHoverClass);\n                    }, this));\n                }\n\n                $(menuItem)\n                    .data('opened', true);\n            } else {\n                this._closeSubmenu(menuItem);\n            }\n        },\n\n        _closeSubmenu: function(menuItem, excludeCurrent, heightToAnimate, callback, e) {\n            var topLevel = $(this.options.topLevel, this.itemsContainer),\n                expandedTopLevel = e && $(e.target).closest(this.options.expandedTopLevel);\n\n            if (!excludeCurrent) {\n                $(this.options.topLevelSubmenu, $(this.options.parentLevel, this.element))\n                    .animate({\n                        height: 0\n                    });\n\n                topLevel\n                    .data('opened', false)\n                    .removeClass(this.options.topLevelHoverClass);\n            } else {\n                var prevOpenedItem = topLevel.filter(function() {\n                        return $(this).data('opened');\n                    }),\n                    prevOpenedSubmenu = $(this.options.topLevelSubmenu, prevOpenedItem);\n\n                prevOpenedSubmenu.animate({\n                    height: heightToAnimate\n                }, this.options.submenuAnimationSpeed, 'linear', function() {\n                    $(this).css({\n                        height: 0\n                    });\n                    callback && callback();\n                });\n\n                prevOpenedItem\n                    .data('opened', false)\n                    .removeClass(this.options.topLevelHoverClass);\n            }\n        },\n\n        _collapseMenu: function() {\n            this._superApply(arguments);\n            this._applySubmenuStyles();\n        }\n    });\n\n    //  Responsive menu\n    $.widget('mage.navigationMenu', $.mage.navigationMenu, {\n        options: {\n            responsive: false,\n            origNavPlaceholder: '.page-header',\n            mainContainer: 'body',\n            pageWrapper: '.page-wrapper',\n            openedMenuClass: 'opened',\n            toggleActionPlaceholder: '.block-search',\n            itemWithSubmenu: 'li.parent',\n            titleWithSubmenu: 'li.parent > a',\n            submenu: 'li.parent > .submenu',\n            toggleActionTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<span data-action=\"toggle-nav\" class=\"action toggle nav\">Toggle Nav</span>' +\n                '</script>',\n            submenuActionsTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<li class=\"action all\">' +\n                        '<a href=\"<%= categoryURL %>\"><span>All <%= category %></span></a>' +\n                    '</li>' +\n                '</script>',\n            navigationSectionsWrapperTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<dl class=\"navigation-tabs\" data-sections=\"tabs\">' +\n                    '</dl>' +\n                '</script>',\n            navigationItemWrapperTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<dt class=\"item title <% if (active) { %>active<% } %>\" data-section=\"title\">' +\n                        '<a class=\"switch\" data-toggle=\"switch\" href=\"#TODO\"><%= title %></a>' +\n                    '</dt>' +\n                    '<dd class=\"item content <% if (active) { %>active<%}%>\" data-section=\"content\">' +\n                    '</dd>' +\n                '</script>'\n        },\n\n        _init: function() {\n            this._super();\n\n            this.mainContainer = $(this.options.mainContainer);\n            this.pageWrapper = $(this.options.pageWrapper);\n            this.toggleAction = $(mageTemplate(this.options.toggleActionTemplate, {}));\n\n            if (this.options.responsive) {\n                mediaCheck({\n                    media: '(min-width: 768px)',\n                    entry: $.proxy(function() {\n                        this._toggleDesktopMode();\n                    }, this),\n                    exit: $.proxy(function() {\n                        this._toggleMobileMode();\n                    }, this)\n                });\n            }\n        },\n\n        _bind: function() {\n            this._super();\n            this._bindDocumentEvents();\n        },\n\n        _bindDocumentEvents: function() {\n            if (!this.eventsBound) {\n                $(document)\n                    .on('click.toggleMenu', '.action.toggle.nav', $.proxy(function(e) {\n                        if ($(this.element).data('opened')) {\n                            this._hideMenu();\n                        } else {\n                            this._showMenu();\n                        }\n                        e.stopPropagation();\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this))\n                    .on('click.hideMenu', this.options.pageWrapper, $.proxy(function() {\n                        if ($(this.element).data('opened')) {\n                            this._hideMenu();\n                            this.mobileNav.scrollTop(0);\n                            this._fixedBackLink();\n                        }\n                    }, this))\n                    .on('click.showSubmenu', this.options.titleWithSubmenu, $.proxy(function(e) {\n                        this._showSubmenu(e);\n\n                        e.preventDefault();\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this))\n                    .on('click.hideSubmenu', '.action.back', $.proxy(function(e) {\n                        this._hideSubmenu(e);\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this));\n\n                this.eventsBound = true;\n            }\n        },\n\n        _showMenu: function() {\n            $(this.element).data('opened', true);\n            this.mainContainer.add( \"html\" ).addClass(this.options.openedMenuClass);\n        },\n\n        _hideMenu: function() {\n            $(this.element).data('opened', false);\n            this.mainContainer.add( \"html\" ).removeClass(this.options.openedMenuClass);\n        },\n\n        _showSubmenu: function(e) {\n            $(e.currentTarget).addClass('action back');\n            var submenu = $(e.currentTarget).siblings('.submenu');\n\n            submenu.addClass('opened');\n        },\n\n        _hideSubmenu: function(e) {\n            var submenuSelector = '.submenu',\n                submenu = $(e.currentTarget).next(submenuSelector);\n            $(e.currentTarget).removeClass('action back');\n            submenu.removeClass('opened');\n        },\n\n        _renderSubmenuActions: function() {\n            $.each(\n                $(this.options.itemWithSubmenu),\n                $.proxy(\n                    function(index, item) {\n                        var actions = $(\n                            mageTemplate(\n                                this.options.submenuActionsTemplate,\n                                {\n                                    category: $('> a > span', item).text(),\n                                    categoryURL: $('> a', item).attr('href')\n                                }\n                            )\n                            ),\n                            submenu = $('> .submenu', item),\n                            items = $('> ul', submenu);\n                            items.prepend(actions);\n                    },\n                    this\n                )\n            );\n        },\n\n        _toggleMobileMode: function() {\n            this._expandMenu();\n\n            $(this.options.topLevelSubmenu, $(this.options.topLevel, this.element))\n                .removeAttr('style');\n\n            this.toggleAction.insertBefore(this.options.toggleActionPlaceholder);\n            this.mobileNav = $(this.element).detach().clone();\n            this.mainContainer.prepend(this.mobileNav);\n            this.mobileNav.find('> ul').addClass('nav');\n            this._insertExtraItems();\n            this._wrapItemsInSections();\n            this.mobileNav.scroll($.proxy(\n                function() {\n                    this._fixedBackLink();\n                }, this\n            ));\n\n            this._renderSubmenuActions();\n            this._bindDocumentEvents();\n        },\n\n        _toggleDesktopMode: function() {\n            this.mobileNav && this.mobileNav.remove();\n            this.toggleAction.detach();\n            $(this.element).insertAfter(this.options.origNavPlaceholder);\n\n            $(document)\n                .off('click.toggleMenu', '.action.toggle.nav')\n                .off('click.hideMenu', this.options.pageWrapper)\n                .off('click.showSubmenu', this.options.titleWithSubmenu)\n                .off('click.hideSubmenu', '.action.back');\n\n            this.eventsBound = false;\n\n            this._applySubmenuStyles();\n        },\n\n        _insertExtraItems: function() {\n            if ($('.header.panel .switcher').length) {\n                var settings = $('.header.panel .switcher')\n                    .clone()\n                    .addClass('settings');\n\n                this.mobileNav.prepend(settings);\n            }\n\n            if ($('.footer .switcher').length) {\n                var footerSettings = $('.footer .switcher')\n                    .clone()\n                    .addClass('settings');\n\n                this.mobileNav.prepend(footerSettings);\n            }\n\n\n            if ($('.header.panel .header.links li').length) {\n                var account = $('.header.panel > .header.links')\n                    .clone()\n                    .addClass('account');\n\n                this.mobileNav.prepend(account);\n            }\n        },\n\n        _wrapItemsInSections: function() {\n            var account = $('> .account', this.mobileNav),\n                settings = $('> .settings', this.mobileNav),\n                nav = $('> .nav', this.mobileNav),\n                navigationSectionsWrapper = $(mageTemplate(this.options.navigationSectionsWrapperTemplate, {})),\n                navigationItemWrapper;\n\n            this.mobileNav.append(navigationSectionsWrapper);\n\n            if (nav.length) {\n                navigationItemWrapper = $(mageTemplate(this.options.navigationItemWrapperTemplate, {title: 'Menu'}));\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(nav);\n            }\n\n            if (account.length) {\n                navigationItemWrapper = $(mageTemplate(this.options.navigationItemWrapperTemplate, {title: 'Account'}));\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(account);\n            }\n\n            if (settings.length) {\n                navigationItemWrapper = $(\n                    mageTemplate(this.options.navigationItemWrapperTemplate, {title: 'Settings'})\n                );\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(settings);\n            }\n\n            navigationSectionsWrapper.addClass(\"navigation-tabs-\" + navigationSectionsWrapper.find('[data-section=\"title\"]').length);\n            navigationSectionsWrapper.terms();\n        },\n\n        _fixedBackLink: function() {\n            var linksBack = this.mobileNav.find('.submenu .action.back');\n            var linkBack = this.mobileNav.find('.submenu.opened > ul > .action.back').last();\n\n            linksBack.removeClass('fixed');\n\n            if(linkBack.length) {\n                var subMenu = linkBack.parent(),\n                    navOffset = this.mobileNav.find('.nav').position().top,\n                    linkBackHeight = linkBack.height();\n\n                if (navOffset <= 0) {\n                    linkBack.addClass('fixed');\n                    subMenu.css({\n                        paddingTop: linkBackHeight\n                    })\n                } else {\n                    linkBack.removeClass('fixed');\n                    subMenu.css({\n                        paddingTop: 0\n                    })\n                }\n            }\n        }\n    });\n\n    return $.mage.navigationMenu;\n});\n","js/responsive.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'matchMedia',\n    'mage/tabs',\n    'domReady!'\n], function ($, mediaCheck) {\n    'use strict';\n\n    mediaCheck({\n        media: '(min-width: 768px)',\n        // Switch to Desktop Version\n        entry: function () {\n            (function () {\n\n                var productInfoMain = $('.product-info-main'),\n                    productInfoAdditional = $('#product-info-additional');\n\n                if (productInfoAdditional.length) {\n                    productInfoAdditional.addClass('hidden');\n                    productInfoMain.removeClass('responsive');\n                }\n\n            })();\n\n            var galleryElement = $('[data-role=media-gallery]');\n\n            if (galleryElement.length && galleryElement.data('mageZoom')) {\n                galleryElement.zoom('enable');\n            }\n\n            if (galleryElement.length && galleryElement.data('mageGallery')) {\n                galleryElement.gallery('option', 'disableLinks', true);\n                galleryElement.gallery('option', 'showNav', false);\n                galleryElement.gallery('option', 'showThumbs', true);\n            }\n        },\n        // Switch to Mobile Version\n        exit: function () {\n            $('.action.toggle.checkout.progress')\n                .on('click.gotoCheckoutProgress', function () {\n                    var myWrapper = '#checkout-progress-wrapper';\n                    scrollTo(myWrapper + ' .title');\n                    $(myWrapper + ' .title').addClass('active');\n                    $(myWrapper + ' .content').show();\n                });\n\n            $('body')\n                .on('click.checkoutProgress', '#checkout-progress-wrapper .title', function () {\n                    $(this).toggleClass('active');\n                    $('#checkout-progress-wrapper .content').toggle();\n                });\n\n            var galleryElement = $('[data-role=media-gallery]');\n\n            setTimeout(function () {\n                if (galleryElement.length && galleryElement.data('mageZoom')) {\n                    galleryElement.zoom('disable');\n                }\n\n                if (galleryElement.length && galleryElement.data('mageGallery')) {\n                    galleryElement.gallery('option', 'disableLinks', false);\n                    galleryElement.gallery('option', 'showNav', true);\n                    galleryElement.gallery('option', 'showThumbs', false);\n                }\n            }, 2000);\n        }\n    });\n});\n","js/theme.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'mage/mage',\n    'mage/ie-class-fixer',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    if ($('body').hasClass('checkout-cart-index')) {\n        if ($('#co-shipping-method-form .fieldset.rates').length > 0 && $('#co-shipping-method-form .fieldset.rates :checked').length === 0) {\n            $('#block-shipping').on('collapsiblecreate', function () {\n                $('#block-shipping').collapsible('forceActivate');\n            });\n        }\n    }\n\n    $('.cart-summary').mage('sticky', {\n        container: '#maincontent'\n    });\n\n    $('.panel.header > .header.links').clone().appendTo('#store\\\\.links');\n\n    keyboardHandler.apply();\n});\n","es6-collections.js":"(function (exports) {'use strict';\n  //shared pointer\n  var i;\n  //shortcuts\n  var defineProperty = Object.defineProperty, is = function(a,b) { return isNaN(a)? isNaN(b): a === b; };\n\n\n  //Polyfill global objects\n  if (typeof WeakMap == 'undefined') {\n    exports.WeakMap = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakMap#clear():\n      clear: sharedClear,\n      // WeakMap#get(key:void*):void*\n      get: sharedGet,\n      // WeakMap#has(key:void*):boolean\n      has: mapHas,\n      // WeakMap#set(key:void*, value:void*):void\n      set: sharedSet\n    }, true);\n  }\n\n  if (typeof Map == 'undefined' || typeof ((new Map).values) !== 'function' || !(new Map).values().next) {\n    exports.Map = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      //:was Map#get(key:void*[, d3fault:void*]):void*\n      // Map#has(key:void*):boolean\n      has: mapHas,\n      // Map#get(key:void*):boolean\n      get: sharedGet,\n      // Map#set(key:void*, value:void*):void\n      set: sharedSet,\n      // Map#keys(void):Iterator\n      keys: sharedKeys,\n      // Map#values(void):Iterator\n      values: sharedValues,\n      // Map#entries(void):Iterator\n      entries: mapEntries,\n      // Map#forEach(callback:Function, context:void*):void ==> callback.call(context, key, value, mapObject) === not in specs`\n      forEach: sharedForEach,\n      // Map#clear():\n      clear: sharedClear\n    });\n  }\n\n  if (typeof Set == 'undefined' || typeof ((new Set).values) !== 'function' || !(new Set).values().next) {\n    exports.Set = createCollection({\n      // Set#has(value:void*):boolean\n      has: setHas,\n      // Set#add(value:void*):boolean\n      add: sharedAdd,\n      // Set#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // Set#clear():\n      clear: sharedClear,\n      // Set#keys(void):Iterator\n      keys: sharedValues, // specs actually say \"the same function object as the initial value of the values property\"\n      // Set#values(void):Iterator\n      values: sharedValues,\n      // Set#entries(void):Iterator\n      entries: setEntries,\n      // Set#forEach(callback:Function, context:void*):void ==> callback.call(context, value, index) === not in specs\n      forEach: sharedForEach\n    });\n  }\n\n  if (typeof WeakSet == 'undefined') {\n    exports.WeakSet = createCollection({\n      // WeakSet#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakSet#add(value:void*):boolean\n      add: sharedAdd,\n      // WeakSet#clear():\n      clear: sharedClear,\n      // WeakSet#has(value:void*):boolean\n      has: setHas\n    }, true);\n  }\n\n\n  /**\n   * ES6 collection constructor\n   * @return {Function} a collection class\n   */\n  function createCollection(proto, objectOnly){\n    function Collection(a){\n      if (!this || this.constructor !== Collection) return new Collection(a);\n      this._keys = [];\n      this._values = [];\n      this._itp = []; // iteration pointers\n      this.objectOnly = objectOnly;\n\n      //parse initial iterable argument passed\n      if (a) init.call(this, a);\n    }\n\n    //define size for non object-only collections\n    if (!objectOnly) {\n      defineProperty(proto, 'size', {\n        get: sharedSize\n      });\n    }\n\n    //set prototype\n    proto.constructor = Collection;\n    Collection.prototype = proto;\n\n    return Collection;\n  }\n\n\n  /** parse initial iterable argument passed */\n  function init(a){\n    var i;\n    //init Set argument, like `[1,2,3,{}]`\n    if (this.add)\n      a.forEach(this.add, this);\n    //init Map argument like `[[1,2], [{}, 4]]`\n    else\n      a.forEach(function(a){this.set(a[0],a[1])}, this);\n  }\n\n\n  /** delete */\n  function sharedDelete(key) {\n    if (this.has(key)) {\n      this._keys.splice(i, 1);\n      this._values.splice(i, 1);\n      // update iteration pointers\n      this._itp.forEach(function(p) { if (i < p[0]) p[0]--; });\n    }\n    // Aurora here does it while Canary doesn't\n    return -1 < i;\n  };\n\n  function sharedGet(key) {\n    return this.has(key) ? this._values[i] : undefined;\n  }\n\n  function has(list, key) {\n    if (this.objectOnly && key !== Object(key))\n      throw new TypeError(\"Invalid value used as weak collection key\");\n    //NaN or 0 passed\n    if (key != key || key === 0) for (i = list.length; i-- && !is(list[i], key);){}\n    else i = list.indexOf(key);\n    return -1 < i;\n  }\n\n  function setHas(value) {\n    return has.call(this, this._values, value);\n  }\n\n  function mapHas(value) {\n    return has.call(this, this._keys, value);\n  }\n\n  /** @chainable */\n  function sharedSet(key, value) {\n    this.has(key) ?\n      this._values[i] = value\n      :\n      this._values[this._keys.push(key) - 1] = value\n    ;\n    return this;\n  }\n\n  /** @chainable */\n  function sharedAdd(value) {\n    if (!this.has(value)) this._values.push(value);\n    return this;\n  }\n\n  function sharedClear() {\n    this._values.length = 0;\n  }\n\n  /** keys, values, and iterate related methods */\n  function sharedKeys() {\n    return sharedIterator(this._itp, this._keys);\n  }\n\n  function sharedValues() {\n    return sharedIterator(this._itp, this._values);\n  }\n\n  function mapEntries() {\n    return sharedIterator(this._itp, this._keys, this._values);\n  }\n\n  function setEntries() {\n    return sharedIterator(this._itp, this._values, this._values);\n  }\n\n  function sharedIterator(itp, array, array2) {\n    var p = [0], done = false;\n    itp.push(p);\n    return {\n      next: function() {\n        var v, k = p[0];\n        if (!done && k < array.length) {\n          v = array2 ? [array[k], array2[k]]: array[k];\n          p[0]++;\n        } else {\n          done = true;\n          itp.splice(itp.indexOf(p), 1);\n        }\n        return { done: done, value: v };\n      }\n    };\n  }\n\n  function sharedSize() {\n    return this._values.length;\n  }\n\n  function sharedForEach(callback, context) {\n    var it = this.entries();\n    for (;;) {\n      var r = it.next();\n      if (r.done) break;\n      callback.call(context, r.value[1], r.value[0], this);\n    }\n  }\n\n})(typeof exports != 'undefined' && typeof global != 'undefined' ? global : window );","FormData.js":"/*\n * FormData for XMLHttpRequest 2  -  Polyfill for Web Worker\n * (c) 2014 Rob Wu <rob@robwu.nl>\n * License: MIT\n * - append(name, value[, filename])\n * - XMLHttpRequest.prototype.send(object FormData)\n * \n * Specification: http://www.w3.org/TR/XMLHttpRequest/#formdata\n *                http://www.w3.org/TR/XMLHttpRequest/#the-send-method\n * The .append() implementation also accepts Uint8Array and ArrayBuffer objects\n * Web Workers do not natively support FormData:\n *                http://dev.w3.org/html5/workers/#apis-available-to-workers\n * Originally released in 2012 as a part of http://stackoverflow.com/a/10002486.\n * Updates since initial release:\n * - Forward-compatibility by testing whether FormData exists before defining it.\n * - Increased robustness of .append.\n * - Allow any typed array in .append.\n * - Remove use of String.prototype.toString to work around a Firefox bug.\n * - Use typed array in xhr.send instead of arraybuffer to get rid of deprecation\n *   warnings.\n **/\n(function(exports) {\n    if (exports.FormData) {\n        // Don't replace FormData if it already exists\n        return;\n    }\n    // Export variable to the global scope\n    exports.FormData = FormData;\n\n    var ___send$rw = XMLHttpRequest.prototype.send;\n    XMLHttpRequest.prototype.send = function(data) {\n        if (data instanceof FormData) {\n            if (!data.__endedMultipart) data.__append('--' + data.boundary + '--\\r\\n');\n            data.__endedMultipart = true;\n            this.setRequestHeader('Content-Type', 'multipart/form-data; boundary=' + data.boundary);\n            data = new Uint8Array(data.data);\n        }\n        // Invoke original XHR.send\n        return ___send$rw.call(this, data);\n    };\n\n    function FormData() {\n        // Force a Constructor\n        if (!(this instanceof FormData)) return new FormData();\n        // Generate a random boundary - This must be unique with respect to the form's contents.\n        this.boundary = '------RWWorkerFormDataBoundary' + Math.random().toString(36);\n        var internal_data = this.data = [];\n        /**\n         * Internal method.\n         * @param inp String | ArrayBuffer | Uint8Array  Input\n         */\n        this.__append = function(inp) {\n            var i = 0, len;\n            if (typeof inp == 'string') {\n                for (len = inp.length; i < len; ++i)\n                    internal_data.push(inp.charCodeAt(i) & 0xff);\n            } else if (inp && inp.byteLength) {/*If ArrayBuffer or typed array */\n                if (!('byteOffset' in inp))   /* If ArrayBuffer, wrap in view */\n                    inp = new Uint8Array(inp);\n                for (len = inp.byteLength; i < len; ++i)\n                    internal_data.push(inp[i] & 0xff);\n            }\n        };\n    }\n    /**\n     * @param name     String                                   Key name\n     * @param value    String|Blob|File|typed array|ArrayBuffer Value\n     * @param filename String                                   Optional File name (when value is not a string).\n     **/\n    FormData.prototype.append = function(name, value, filename) {\n        if (this.__endedMultipart) {\n            // Truncate the closing boundary\n            this.data.length -= this.boundary.length + 6;\n            this.__endedMultipart = false;\n        }\n        if (arguments.length < 2) {\n            throw new SyntaxError('Not enough arguments');\n        }\n        var part = '--' + this.boundary + '\\r\\n' +\n            'Content-Disposition: form-data; name=\"' + name + '\"';\n\n        if (value instanceof File || value instanceof Blob) {\n            return this.append(name,\n                new Uint8Array(new FileReaderSync().readAsArrayBuffer(value)),\n                filename || value.name);\n        } else if (typeof value.byteLength == 'number') {\n            // Duck-typed typed array or array buffer\n            part += '; filename=\"'+ (filename || 'blob').replace(/\"/g,'%22') +'\"\\r\\n';\n            part += 'Content-Type: application/octet-stream\\r\\n\\r\\n';\n            this.__append(part);\n            this.__append(value);\n            part = '\\r\\n';\n        } else {\n            part += '\\r\\n\\r\\n' + value + '\\r\\n';\n        }\n        this.__append(part);\n    };\n})(this || self);\n","jquery.js":"/*!\n * jQuery JavaScript Library v1.11.0\n * http://jquery.com/\n *\n * Includes Sizzle.js\n * http://sizzlejs.com/\n *\n * Copyright 2005, 2014 jQuery Foundation, Inc. and other contributors\n * Released under the MIT license\n * http://jquery.org/license\n *\n * Date: 2014-01-23T21:02Z\n */\n\n(function( global, factory ) {\n\n\tif ( typeof module === \"object\" && typeof module.exports === \"object\" ) {\n\t\t// For CommonJS and CommonJS-like environments where a proper window is present,\n\t\t// execute the factory and get jQuery\n\t\t// For environments that do not inherently posses a window with a document\n\t\t// (such as Node.js), expose a jQuery-making factory as module.exports\n\t\t// This accentuates the need for the creation of a real window\n\t\t// e.g. var jQuery = require(\"jquery\")(window);\n\t\t// See ticket #14549 for more info\n\t\tmodule.exports = global.document ?\n\t\t\tfactory( global, true ) :\n\t\t\tfunction( w ) {\n\t\t\t\tif ( !w.document ) {\n\t\t\t\t\tthrow new Error( \"jQuery requires a window with a document\" );\n\t\t\t\t}\n\t\t\t\treturn factory( w );\n\t\t\t};\n\t} else {\n\t\tfactory( global );\n\t}\n\n// Pass this if window is not defined yet\n}(typeof window !== \"undefined\" ? window : this, function( window, noGlobal ) {\n\n// Can't do this because several apps including ASP.NET trace\n// the stack via arguments.caller.callee and Firefox dies if\n// you try to trace through \"use strict\" call chains. (#13335)\n// Support: Firefox 18+\n//\n\nvar deletedIds = [];\n\nvar slice = deletedIds.slice;\n\nvar concat = deletedIds.concat;\n\nvar push = deletedIds.push;\n\nvar indexOf = deletedIds.indexOf;\n\nvar class2type = {};\n\nvar toString = class2type.toString;\n\nvar hasOwn = class2type.hasOwnProperty;\n\nvar trim = \"\".trim;\n\nvar support = {};\n\n\n\nvar\n\tversion = \"1.11.0\",\n\n\t// Define a local copy of jQuery\n\tjQuery = function( selector, context ) {\n\t\t// The jQuery object is actually just the init constructor 'enhanced'\n\t\t// Need init if jQuery is called (just allow error to be thrown if not included)\n\t\treturn new jQuery.fn.init( selector, context );\n\t},\n\n\t// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)\n\trtrim = /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,\n\n\t// Matches dashed string for camelizing\n\trmsPrefix = /^-ms-/,\n\trdashAlpha = /-([\\da-z])/gi,\n\n\t// Used by jQuery.camelCase as callback to replace()\n\tfcamelCase = function( all, letter ) {\n\t\treturn letter.toUpperCase();\n\t};\n\njQuery.fn = jQuery.prototype = {\n\t// The current version of jQuery being used\n\tjquery: version,\n\n\tconstructor: jQuery,\n\n\t// Start with an empty selector\n\tselector: \"\",\n\n\t// The default length of a jQuery object is 0\n\tlength: 0,\n\n\ttoArray: function() {\n\t\treturn slice.call( this );\n\t},\n\n\t// Get the Nth element in the matched element set OR\n\t// Get the whole matched element set as a clean array\n\tget: function( num ) {\n\t\treturn num != null ?\n\n\t\t\t// Return a 'clean' array\n\t\t\t( num < 0 ? this[ num + this.length ] : this[ num ] ) :\n\n\t\t\t// Return just the object\n\t\t\tslice.call( this );\n\t},\n\n\t// Take an array of elements and push it onto the stack\n\t// (returning the new matched element set)\n\tpushStack: function( elems ) {\n\n\t\t// Build a new jQuery matched element set\n\t\tvar ret = jQuery.merge( this.constructor(), elems );\n\n\t\t// Add the old object onto the stack (as a reference)\n\t\tret.prevObject = this;\n\t\tret.context = this.context;\n\n\t\t// Return the newly-formed element set\n\t\treturn ret;\n\t},\n\n\t// Execute a callback for every element in the matched set.\n\t// (You can seed the arguments with an array of args, but this is\n\t// only used internally.)\n\teach: function( callback, args ) {\n\t\treturn jQuery.each( this, callback, args );\n\t},\n\n\tmap: function( callback ) {\n\t\treturn this.pushStack( jQuery.map(this, function( elem, i ) {\n\t\t\treturn callback.call( elem, i, elem );\n\t\t}));\n\t},\n\n\tslice: function() {\n\t\treturn this.pushStack( slice.apply( this, arguments ) );\n\t},\n\n\tfirst: function() {\n\t\treturn this.eq( 0 );\n\t},\n\n\tlast: function() {\n\t\treturn this.eq( -1 );\n\t},\n\n\teq: function( i ) {\n\t\tvar len = this.length,\n\t\t\tj = +i + ( i < 0 ? len : 0 );\n\t\treturn this.pushStack( j >= 0 && j < len ? [ this[j] ] : [] );\n\t},\n\n\tend: function() {\n\t\treturn this.prevObject || this.constructor(null);\n\t},\n\n\t// For internal use only.\n\t// Behaves like an Array's method, not like a jQuery method.\n\tpush: push,\n\tsort: deletedIds.sort,\n\tsplice: deletedIds.splice\n};\n\njQuery.extend = jQuery.fn.extend = function() {\n\tvar src, copyIsArray, copy, name, options, clone,\n\t\ttarget = arguments[0] || {},\n\t\ti = 1,\n\t\tlength = arguments.length,\n\t\tdeep = false;\n\n\t// Handle a deep copy situation\n\tif ( typeof target === \"boolean\" ) {\n\t\tdeep = target;\n\n\t\t// skip the boolean and the target\n\t\ttarget = arguments[ i ] || {};\n\t\ti++;\n\t}\n\n\t// Handle case when target is a string or something (possible in deep copy)\n\tif ( typeof target !== \"object\" && !jQuery.isFunction(target) ) {\n\t\ttarget = {};\n\t}\n\n\t// extend jQuery itself if only one argument is passed\n\tif ( i === length ) {\n\t\ttarget = this;\n\t\ti--;\n\t}\n\n\tfor ( ; i < length; i++ ) {\n\t\t// Only deal with non-null/undefined values\n\t\tif ( (options = arguments[ i ]) != null ) {\n\t\t\t// Extend the base object\n\t\t\tfor ( name in options ) {\n\t\t\t\tsrc = target[ name ];\n\t\t\t\tcopy = options[ name ];\n\n\t\t\t\t// Prevent never-ending loop\n\t\t\t\tif ( target === copy ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\t// Recurse if we're merging plain objects or arrays\n\t\t\t\tif ( deep && copy && ( jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)) ) ) {\n\t\t\t\t\tif ( copyIsArray ) {\n\t\t\t\t\t\tcopyIsArray = false;\n\t\t\t\t\t\tclone = src && jQuery.isArray(src) ? src : [];\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\tclone = src && jQuery.isPlainObject(src) ? src : {};\n\t\t\t\t\t}\n\n\t\t\t\t\t// Never move original objects, clone them\n\t\t\t\t\ttarget[ name ] = jQuery.extend( deep, clone, copy );\n\n\t\t\t\t// Don't bring in undefined values\n\t\t\t\t} else if ( copy !== undefined ) {\n\t\t\t\t\ttarget[ name ] = copy;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\t// Return the modified object\n\treturn target;\n};\n\njQuery.extend({\n\t// Unique for each copy of jQuery on the page\n\texpando: \"jQuery\" + ( version + Math.random() ).replace( /\\D/g, \"\" ),\n\n\t// Assume jQuery is ready without the ready module\n\tisReady: true,\n\n\terror: function( msg ) {\n\t\tthrow new Error( msg );\n\t},\n\n\tnoop: function() {},\n\n\t// See test/unit/core.js for details concerning isFunction.\n\t// Since version 1.3, DOM methods and functions like alert\n\t// aren't supported. They return false on IE (#2968).\n\tisFunction: function( obj ) {\n\t\treturn jQuery.type(obj) === \"function\";\n\t},\n\n\tisArray: Array.isArray || function( obj ) {\n\t\treturn jQuery.type(obj) === \"array\";\n\t},\n\n\tisWindow: function( obj ) {\n\t\t/* jshint eqeqeq: false */\n\t\treturn obj != null && obj == obj.window;\n\t},\n\n\tisNumeric: function( obj ) {\n\t\t// parseFloat NaNs numeric-cast false positives (null|true|false|\"\")\n\t\t// ...but misinterprets leading-number strings, particularly hex literals (\"0x...\")\n\t\t// subtraction forces infinities to NaN\n\t\treturn obj - parseFloat( obj ) >= 0;\n\t},\n\n\tisEmptyObject: function( obj ) {\n\t\tvar name;\n\t\tfor ( name in obj ) {\n\t\t\treturn false;\n\t\t}\n\t\treturn true;\n\t},\n\n\tisPlainObject: function( obj ) {\n\t\tvar key;\n\n\t\t// Must be an Object.\n\t\t// Because of IE, we also have to check the presence of the constructor property.\n\t\t// Make sure that DOM nodes and window objects don't pass through, as well\n\t\tif ( !obj || jQuery.type(obj) !== \"object\" || obj.nodeType || jQuery.isWindow( obj ) ) {\n\t\t\treturn false;\n\t\t}\n\n\t\ttry {\n\t\t\t// Not own constructor property must be Object\n\t\t\tif ( obj.constructor &&\n\t\t\t\t!hasOwn.call(obj, \"constructor\") &&\n\t\t\t\t!hasOwn.call(obj.constructor.prototype, \"isPrototypeOf\") ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t} catch ( e ) {\n\t\t\t// IE8,9 Will throw exceptions on certain host objects #9897\n\t\t\treturn false;\n\t\t}\n\n\t\t// Support: IE<9\n\t\t// Handle iteration over inherited properties before own properties.\n\t\tif ( support.ownLast ) {\n\t\t\tfor ( key in obj ) {\n\t\t\t\treturn hasOwn.call( obj, key );\n\t\t\t}\n\t\t}\n\n\t\t// Own properties are enumerated firstly, so to speed up,\n\t\t// if last one is own, then all properties are own.\n\t\tfor ( key in obj ) {}\n\n\t\treturn key === undefined || hasOwn.call( obj, key );\n\t},\n\n\ttype: function( obj ) {\n\t\tif ( obj == null ) {\n\t\t\treturn obj + \"\";\n\t\t}\n\t\treturn typeof obj === \"object\" || typeof obj === \"function\" ?\n\t\t\tclass2type[ toString.call(obj) ] || \"object\" :\n\t\t\ttypeof obj;\n\t},\n\n\t// Evaluates a script in a global context\n\t// Workarounds based on findings by Jim Driscoll\n\t// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context\n\tglobalEval: function( data ) {\n\t\tif ( data && jQuery.trim( data ) ) {\n\t\t\t// We use execScript on Internet Explorer\n\t\t\t// We use an anonymous function so that context is window\n\t\t\t// rather than jQuery in Firefox\n\t\t\t( window.execScript || function( data ) {\n\t\t\t\twindow[ \"eval\" ].call( window, data );\n\t\t\t} )( data );\n\t\t}\n\t},\n\n\t// Convert dashed to camelCase; used by the css and data modules\n\t// Microsoft forgot to hump their vendor prefix (#9572)\n\tcamelCase: function( string ) {\n\t\treturn string.replace( rmsPrefix, \"ms-\" ).replace( rdashAlpha, fcamelCase );\n\t},\n\n\tnodeName: function( elem, name ) {\n\t\treturn elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n\t},\n\n\t// args is for internal usage only\n\teach: function( obj, callback, args ) {\n\t\tvar value,\n\t\t\ti = 0,\n\t\t\tlength = obj.length,\n\t\t\tisArray = isArraylike( obj );\n\n\t\tif ( args ) {\n\t\t\tif ( isArray ) {\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tvalue = callback.apply( obj[ i ], args );\n\n\t\t\t\t\tif ( value === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( i in obj ) {\n\t\t\t\t\tvalue = callback.apply( obj[ i ], args );\n\n\t\t\t\t\tif ( value === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t// A special, fast, case for the most common use of each\n\t\t} else {\n\t\t\tif ( isArray ) {\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tvalue = callback.call( obj[ i ], i, obj[ i ] );\n\n\t\t\t\t\tif ( value === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( i in obj ) {\n\t\t\t\t\tvalue = callback.call( obj[ i ], i, obj[ i ] );\n\n\t\t\t\t\tif ( value === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn obj;\n\t},\n\n\t// Use native String.trim function wherever possible\n\ttrim: trim && !trim.call(\"\\uFEFF\\xA0\") ?\n\t\tfunction( text ) {\n\t\t\treturn text == null ?\n\t\t\t\t\"\" :\n\t\t\t\ttrim.call( text );\n\t\t} :\n\n\t\t// Otherwise use our own trimming functionality\n\t\tfunction( text ) {\n\t\t\treturn text == null ?\n\t\t\t\t\"\" :\n\t\t\t\t( text + \"\" ).replace( rtrim, \"\" );\n\t\t},\n\n\t// results is for internal usage only\n\tmakeArray: function( arr, results ) {\n\t\tvar ret = results || [];\n\n\t\tif ( arr != null ) {\n\t\t\tif ( isArraylike( Object(arr) ) ) {\n\t\t\t\tjQuery.merge( ret,\n\t\t\t\t\ttypeof arr === \"string\" ?\n\t\t\t\t\t[ arr ] : arr\n\t\t\t\t);\n\t\t\t} else {\n\t\t\t\tpush.call( ret, arr );\n\t\t\t}\n\t\t}\n\n\t\treturn ret;\n\t},\n\n\tinArray: function( elem, arr, i ) {\n\t\tvar len;\n\n\t\tif ( arr ) {\n\t\t\tif ( indexOf ) {\n\t\t\t\treturn indexOf.call( arr, elem, i );\n\t\t\t}\n\n\t\t\tlen = arr.length;\n\t\t\ti = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;\n\n\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t// Skip accessing in sparse arrays\n\t\t\t\tif ( i in arr && arr[ i ] === elem ) {\n\t\t\t\t\treturn i;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn -1;\n\t},\n\n\tmerge: function( first, second ) {\n\t\tvar len = +second.length,\n\t\t\tj = 0,\n\t\t\ti = first.length;\n\n\t\twhile ( j < len ) {\n\t\t\tfirst[ i++ ] = second[ j++ ];\n\t\t}\n\n\t\t// Support: IE<9\n\t\t// Workaround casting of .length to NaN on otherwise arraylike objects (e.g., NodeLists)\n\t\tif ( len !== len ) {\n\t\t\twhile ( second[j] !== undefined ) {\n\t\t\t\tfirst[ i++ ] = second[ j++ ];\n\t\t\t}\n\t\t}\n\n\t\tfirst.length = i;\n\n\t\treturn first;\n\t},\n\n\tgrep: function( elems, callback, invert ) {\n\t\tvar callbackInverse,\n\t\t\tmatches = [],\n\t\t\ti = 0,\n\t\t\tlength = elems.length,\n\t\t\tcallbackExpect = !invert;\n\n\t\t// Go through the array, only saving the items\n\t\t// that pass the validator function\n\t\tfor ( ; i < length; i++ ) {\n\t\t\tcallbackInverse = !callback( elems[ i ], i );\n\t\t\tif ( callbackInverse !== callbackExpect ) {\n\t\t\t\tmatches.push( elems[ i ] );\n\t\t\t}\n\t\t}\n\n\t\treturn matches;\n\t},\n\n\t// arg is for internal usage only\n\tmap: function( elems, callback, arg ) {\n\t\tvar value,\n\t\t\ti = 0,\n\t\t\tlength = elems.length,\n\t\t\tisArray = isArraylike( elems ),\n\t\t\tret = [];\n\n\t\t// Go through the array, translating each of the items to their new values\n\t\tif ( isArray ) {\n\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\tvalue = callback( elems[ i ], i, arg );\n\n\t\t\t\tif ( value != null ) {\n\t\t\t\t\tret.push( value );\n\t\t\t\t}\n\t\t\t}\n\n\t\t// Go through every key on the object,\n\t\t} else {\n\t\t\tfor ( i in elems ) {\n\t\t\t\tvalue = callback( elems[ i ], i, arg );\n\n\t\t\t\tif ( value != null ) {\n\t\t\t\t\tret.push( value );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Flatten any nested arrays\n\t\treturn concat.apply( [], ret );\n\t},\n\n\t// A global GUID counter for objects\n\tguid: 1,\n\n\t// Bind a function to a context, optionally partially applying any\n\t// arguments.\n\tproxy: function( fn, context ) {\n\t\tvar args, proxy, tmp;\n\n\t\tif ( typeof context === \"string\" ) {\n\t\t\ttmp = fn[ context ];\n\t\t\tcontext = fn;\n\t\t\tfn = tmp;\n\t\t}\n\n\t\t// Quick check to determine if target is callable, in the spec\n\t\t// this throws a TypeError, but we will just return undefined.\n\t\tif ( !jQuery.isFunction( fn ) ) {\n\t\t\treturn undefined;\n\t\t}\n\n\t\t// Simulated bind\n\t\targs = slice.call( arguments, 2 );\n\t\tproxy = function() {\n\t\t\treturn fn.apply( context || this, args.concat( slice.call( arguments ) ) );\n\t\t};\n\n\t\t// Set the guid of unique handler to the same of original handler, so it can be removed\n\t\tproxy.guid = fn.guid = fn.guid || jQuery.guid++;\n\n\t\treturn proxy;\n\t},\n\n\tnow: function() {\n\t\treturn +( new Date() );\n\t},\n\n\t// jQuery.support is not used in Core but other projects attach their\n\t// properties to it so it needs to exist.\n\tsupport: support\n});\n\n// Populate the class2type map\njQuery.each(\"Boolean Number String Function Array Date RegExp Object Error\".split(\" \"), function(i, name) {\n\tclass2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n});\n\nfunction isArraylike( obj ) {\n\tvar length = obj.length,\n\t\ttype = jQuery.type( obj );\n\n\tif ( type === \"function\" || jQuery.isWindow( obj ) ) {\n\t\treturn false;\n\t}\n\n\tif ( obj.nodeType === 1 && length ) {\n\t\treturn true;\n\t}\n\n\treturn type === \"array\" || length === 0 ||\n\t\ttypeof length === \"number\" && length > 0 && ( length - 1 ) in obj;\n}\nvar Sizzle =\n/*!\n * Sizzle CSS Selector Engine v1.10.16\n * http://sizzlejs.com/\n *\n * Copyright 2013 jQuery Foundation, Inc. and other contributors\n * Released under the MIT license\n * http://jquery.org/license\n *\n * Date: 2014-01-13\n */\n(function( window ) {\n\nvar i,\n\tsupport,\n\tExpr,\n\tgetText,\n\tisXML,\n\tcompile,\n\toutermostContext,\n\tsortInput,\n\thasDuplicate,\n\n\t// Local document vars\n\tsetDocument,\n\tdocument,\n\tdocElem,\n\tdocumentIsHTML,\n\trbuggyQSA,\n\trbuggyMatches,\n\tmatches,\n\tcontains,\n\n\t// Instance-specific data\n\texpando = \"sizzle\" + -(new Date()),\n\tpreferredDoc = window.document,\n\tdirruns = 0,\n\tdone = 0,\n\tclassCache = createCache(),\n\ttokenCache = createCache(),\n\tcompilerCache = createCache(),\n\tsortOrder = function( a, b ) {\n\t\tif ( a === b ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn 0;\n\t},\n\n\t// General-purpose constants\n\tstrundefined = typeof undefined,\n\tMAX_NEGATIVE = 1 << 31,\n\n\t// Instance methods\n\thasOwn = ({}).hasOwnProperty,\n\tarr = [],\n\tpop = arr.pop,\n\tpush_native = arr.push,\n\tpush = arr.push,\n\tslice = arr.slice,\n\t// Use a stripped-down indexOf if we can't use a native one\n\tindexOf = arr.indexOf || function( elem ) {\n\t\tvar i = 0,\n\t\t\tlen = this.length;\n\t\tfor ( ; i < len; i++ ) {\n\t\t\tif ( this[i] === elem ) {\n\t\t\t\treturn i;\n\t\t\t}\n\t\t}\n\t\treturn -1;\n\t},\n\n\tbooleans = \"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped\",\n\n\t// Regular expressions\n\n\t// Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace\n\twhitespace = \"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",\n\t// http://www.w3.org/TR/css3-syntax/#characters\n\tcharacterEncoding = \"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",\n\n\t// Loosely modeled on CSS identifier characters\n\t// An unquoted value should be a CSS identifier http://www.w3.org/TR/css3-selectors/#attribute-selectors\n\t// Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier\n\tidentifier = characterEncoding.replace( \"w\", \"w#\" ),\n\n\t// Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors\n\tattributes = \"\\\\[\" + whitespace + \"*(\" + characterEncoding + \")\" + whitespace +\n\t\t\"*(?:([*^$|!~]?=)\" + whitespace + \"*(?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|(\" + identifier + \")|)|)\" + whitespace + \"*\\\\]\",\n\n\t// Prefer arguments quoted,\n\t//   then not containing pseudos/brackets,\n\t//   then attribute selectors/non-parenthetical expressions,\n\t//   then anything else\n\t// These preferences are here to reduce the number of selectors\n\t//   needing tokenize in the PSEUDO preFilter\n\tpseudos = \":(\" + characterEncoding + \")(?:\\\\(((['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\" + attributes.replace( 3, 8 ) + \")*)|.*)\\\\)|)\",\n\n\t// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter\n\trtrim = new RegExp( \"^\" + whitespace + \"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\" + whitespace + \"+$\", \"g\" ),\n\n\trcomma = new RegExp( \"^\" + whitespace + \"*,\" + whitespace + \"*\" ),\n\trcombinators = new RegExp( \"^\" + whitespace + \"*([>+~]|\" + whitespace + \")\" + whitespace + \"*\" ),\n\n\trattributeQuotes = new RegExp( \"=\" + whitespace + \"*([^\\\\]'\\\"]*?)\" + whitespace + \"*\\\\]\", \"g\" ),\n\n\trpseudo = new RegExp( pseudos ),\n\tridentifier = new RegExp( \"^\" + identifier + \"$\" ),\n\n\tmatchExpr = {\n\t\t\"ID\": new RegExp( \"^#(\" + characterEncoding + \")\" ),\n\t\t\"CLASS\": new RegExp( \"^\\\\.(\" + characterEncoding + \")\" ),\n\t\t\"TAG\": new RegExp( \"^(\" + characterEncoding.replace( \"w\", \"w*\" ) + \")\" ),\n\t\t\"ATTR\": new RegExp( \"^\" + attributes ),\n\t\t\"PSEUDO\": new RegExp( \"^\" + pseudos ),\n\t\t\"CHILD\": new RegExp( \"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\" + whitespace +\n\t\t\t\"*(even|odd|(([+-]|)(\\\\d*)n|)\" + whitespace + \"*(?:([+-]|)\" + whitespace +\n\t\t\t\"*(\\\\d+)|))\" + whitespace + \"*\\\\)|)\", \"i\" ),\n\t\t\"bool\": new RegExp( \"^(?:\" + booleans + \")$\", \"i\" ),\n\t\t// For use in libraries implementing .is()\n\t\t// We use this for POS matching in `select`\n\t\t\"needsContext\": new RegExp( \"^\" + whitespace + \"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\" +\n\t\t\twhitespace + \"*((?:-\\\\d)?\\\\d*)\" + whitespace + \"*\\\\)|)(?=[^-]|$)\", \"i\" )\n\t},\n\n\trinputs = /^(?:input|select|textarea|button)$/i,\n\trheader = /^h\\d$/i,\n\n\trnative = /^[^{]+\\{\\s*\\[native \\w/,\n\n\t// Easily-parseable/retrievable ID or TAG or CLASS selectors\n\trquickExpr = /^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,\n\n\trsibling = /[+~]/,\n\trescape = /'|\\\\/g,\n\n\t// CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters\n\trunescape = new RegExp( \"\\\\\\\\([\\\\da-f]{1,6}\" + whitespace + \"?|(\" + whitespace + \")|.)\", \"ig\" ),\n\tfunescape = function( _, escaped, escapedWhitespace ) {\n\t\tvar high = \"0x\" + escaped - 0x10000;\n\t\t// NaN means non-codepoint\n\t\t// Support: Firefox\n\t\t// Workaround erroneous numeric interpretation of +\"0x\"\n\t\treturn high !== high || escapedWhitespace ?\n\t\t\tescaped :\n\t\t\thigh < 0 ?\n\t\t\t\t// BMP codepoint\n\t\t\t\tString.fromCharCode( high + 0x10000 ) :\n\t\t\t\t// Supplemental Plane codepoint (surrogate pair)\n\t\t\t\tString.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );\n\t};\n\n// Optimize for push.apply( _, NodeList )\ntry {\n\tpush.apply(\n\t\t(arr = slice.call( preferredDoc.childNodes )),\n\t\tpreferredDoc.childNodes\n\t);\n\t// Support: Android<4.0\n\t// Detect silently failing push.apply\n\tarr[ preferredDoc.childNodes.length ].nodeType;\n} catch ( e ) {\n\tpush = { apply: arr.length ?\n\n\t\t// Leverage slice if possible\n\t\tfunction( target, els ) {\n\t\t\tpush_native.apply( target, slice.call(els) );\n\t\t} :\n\n\t\t// Support: IE<9\n\t\t// Otherwise append directly\n\t\tfunction( target, els ) {\n\t\t\tvar j = target.length,\n\t\t\t\ti = 0;\n\t\t\t// Can't trust NodeList.length\n\t\t\twhile ( (target[j++] = els[i++]) ) {}\n\t\t\ttarget.length = j - 1;\n\t\t}\n\t};\n}\n\nfunction Sizzle( selector, context, results, seed ) {\n\tvar match, elem, m, nodeType,\n\t\t// QSA vars\n\t\ti, groups, old, nid, newContext, newSelector;\n\n\tif ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {\n\t\tsetDocument( context );\n\t}\n\n\tcontext = context || document;\n\tresults = results || [];\n\n\tif ( !selector || typeof selector !== \"string\" ) {\n\t\treturn results;\n\t}\n\n\tif ( (nodeType = context.nodeType) !== 1 && nodeType !== 9 ) {\n\t\treturn [];\n\t}\n\n\tif ( documentIsHTML && !seed ) {\n\n\t\t// Shortcuts\n\t\tif ( (match = rquickExpr.exec( selector )) ) {\n\t\t\t// Speed-up: Sizzle(\"#ID\")\n\t\t\tif ( (m = match[1]) ) {\n\t\t\t\tif ( nodeType === 9 ) {\n\t\t\t\t\telem = context.getElementById( m );\n\t\t\t\t\t// Check parentNode to catch when Blackberry 4.6 returns\n\t\t\t\t\t// nodes that are no longer in the document (jQuery #6963)\n\t\t\t\t\tif ( elem && elem.parentNode ) {\n\t\t\t\t\t\t// Handle the case where IE, Opera, and Webkit return items\n\t\t\t\t\t\t// by name instead of ID\n\t\t\t\t\t\tif ( elem.id === m ) {\n\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn results;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Context is not a document\n\t\t\t\t\tif ( context.ownerDocument && (elem = context.ownerDocument.getElementById( m )) &&\n\t\t\t\t\t\tcontains( context, elem ) && elem.id === m ) {\n\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\treturn results;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t// Speed-up: Sizzle(\"TAG\")\n\t\t\t} else if ( match[2] ) {\n\t\t\t\tpush.apply( results, context.getElementsByTagName( selector ) );\n\t\t\t\treturn results;\n\n\t\t\t// Speed-up: Sizzle(\".CLASS\")\n\t\t\t} else if ( (m = match[3]) && support.getElementsByClassName && context.getElementsByClassName ) {\n\t\t\t\tpush.apply( results, context.getElementsByClassName( m ) );\n\t\t\t\treturn results;\n\t\t\t}\n\t\t}\n\n\t\t// QSA path\n\t\tif ( support.qsa && (!rbuggyQSA || !rbuggyQSA.test( selector )) ) {\n\t\t\tnid = old = expando;\n\t\t\tnewContext = context;\n\t\t\tnewSelector = nodeType === 9 && selector;\n\n\t\t\t// qSA works strangely on Element-rooted queries\n\t\t\t// We can work around this by specifying an extra ID on the root\n\t\t\t// and working up from there (Thanks to Andrew Dupont for the technique)\n\t\t\t// IE 8 doesn't work on object elements\n\t\t\tif ( nodeType === 1 && context.nodeName.toLowerCase() !== \"object\" ) {\n\t\t\t\tgroups = tokenize( selector );\n\n\t\t\t\tif ( (old = context.getAttribute(\"id\")) ) {\n\t\t\t\t\tnid = old.replace( rescape, \"\\\\$&\" );\n\t\t\t\t} else {\n\t\t\t\t\tcontext.setAttribute( \"id\", nid );\n\t\t\t\t}\n\t\t\t\tnid = \"[id='\" + nid + \"'] \";\n\n\t\t\t\ti = groups.length;\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\tgroups[i] = nid + toSelector( groups[i] );\n\t\t\t\t}\n\t\t\t\tnewContext = rsibling.test( selector ) && testContext( context.parentNode ) || context;\n\t\t\t\tnewSelector = groups.join(\",\");\n\t\t\t}\n\n\t\t\tif ( newSelector ) {\n\t\t\t\ttry {\n\t\t\t\t\tpush.apply( results,\n\t\t\t\t\t\tnewContext.querySelectorAll( newSelector )\n\t\t\t\t\t);\n\t\t\t\t\treturn results;\n\t\t\t\t} catch(qsaError) {\n\t\t\t\t} finally {\n\t\t\t\t\tif ( !old ) {\n\t\t\t\t\t\tcontext.removeAttribute(\"id\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\t// All others\n\treturn select( selector.replace( rtrim, \"$1\" ), context, results, seed );\n}\n\n/**\n * Create key-value caches of limited size\n * @returns {Function(string, Object)} Returns the Object data after storing it on itself with\n *\tproperty name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)\n *\tdeleting the oldest entry\n */\nfunction createCache() {\n\tvar keys = [];\n\n\tfunction cache( key, value ) {\n\t\t// Use (key + \" \") to avoid collision with native prototype properties (see Issue #157)\n\t\tif ( keys.push( key + \" \" ) > Expr.cacheLength ) {\n\t\t\t// Only keep the most recent entries\n\t\t\tdelete cache[ keys.shift() ];\n\t\t}\n\t\treturn (cache[ key + \" \" ] = value);\n\t}\n\treturn cache;\n}\n\n/**\n * Mark a function for special use by Sizzle\n * @param {Function} fn The function to mark\n */\nfunction markFunction( fn ) {\n\tfn[ expando ] = true;\n\treturn fn;\n}\n\n/**\n * Support testing using an element\n * @param {Function} fn Passed the created div and expects a boolean result\n */\nfunction assert( fn ) {\n\tvar div = document.createElement(\"div\");\n\n\ttry {\n\t\treturn !!fn( div );\n\t} catch (e) {\n\t\treturn false;\n\t} finally {\n\t\t// Remove from its parent by default\n\t\tif ( div.parentNode ) {\n\t\t\tdiv.parentNode.removeChild( div );\n\t\t}\n\t\t// release memory in IE\n\t\tdiv = null;\n\t}\n}\n\n/**\n * Adds the same handler for all of the specified attrs\n * @param {String} attrs Pipe-separated list of attributes\n * @param {Function} handler The method that will be applied\n */\nfunction addHandle( attrs, handler ) {\n\tvar arr = attrs.split(\"|\"),\n\t\ti = attrs.length;\n\n\twhile ( i-- ) {\n\t\tExpr.attrHandle[ arr[i] ] = handler;\n\t}\n}\n\n/**\n * Checks document order of two siblings\n * @param {Element} a\n * @param {Element} b\n * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b\n */\nfunction siblingCheck( a, b ) {\n\tvar cur = b && a,\n\t\tdiff = cur && a.nodeType === 1 && b.nodeType === 1 &&\n\t\t\t( ~b.sourceIndex || MAX_NEGATIVE ) -\n\t\t\t( ~a.sourceIndex || MAX_NEGATIVE );\n\n\t// Use IE sourceIndex if available on both nodes\n\tif ( diff ) {\n\t\treturn diff;\n\t}\n\n\t// Check if b follows a\n\tif ( cur ) {\n\t\twhile ( (cur = cur.nextSibling) ) {\n\t\t\tif ( cur === b ) {\n\t\t\t\treturn -1;\n\t\t\t}\n\t\t}\n\t}\n\n\treturn a ? 1 : -1;\n}\n\n/**\n * Returns a function to use in pseudos for input types\n * @param {String} type\n */\nfunction createInputPseudo( type ) {\n\treturn function( elem ) {\n\t\tvar name = elem.nodeName.toLowerCase();\n\t\treturn name === \"input\" && elem.type === type;\n\t};\n}\n\n/**\n * Returns a function to use in pseudos for buttons\n * @param {String} type\n */\nfunction createButtonPseudo( type ) {\n\treturn function( elem ) {\n\t\tvar name = elem.nodeName.toLowerCase();\n\t\treturn (name === \"input\" || name === \"button\") && elem.type === type;\n\t};\n}\n\n/**\n * Returns a function to use in pseudos for positionals\n * @param {Function} fn\n */\nfunction createPositionalPseudo( fn ) {\n\treturn markFunction(function( argument ) {\n\t\targument = +argument;\n\t\treturn markFunction(function( seed, matches ) {\n\t\t\tvar j,\n\t\t\t\tmatchIndexes = fn( [], seed.length, argument ),\n\t\t\t\ti = matchIndexes.length;\n\n\t\t\t// Match elements found at the specified indexes\n\t\t\twhile ( i-- ) {\n\t\t\t\tif ( seed[ (j = matchIndexes[i]) ] ) {\n\t\t\t\t\tseed[j] = !(matches[j] = seed[j]);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t});\n}\n\n/**\n * Checks a node for validity as a Sizzle context\n * @param {Element|Object=} context\n * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value\n */\nfunction testContext( context ) {\n\treturn context && typeof context.getElementsByTagName !== strundefined && context;\n}\n\n// Expose support vars for convenience\nsupport = Sizzle.support = {};\n\n/**\n * Detects XML nodes\n * @param {Element|Object} elem An element or a document\n * @returns {Boolean} True iff elem is a non-HTML XML node\n */\nisXML = Sizzle.isXML = function( elem ) {\n\t// documentElement is verified for cases where it doesn't yet exist\n\t// (such as loading iframes in IE - #4833)\n\tvar documentElement = elem && (elem.ownerDocument || elem).documentElement;\n\treturn documentElement ? documentElement.nodeName !== \"HTML\" : false;\n};\n\n/**\n * Sets document-related variables once based on the current document\n * @param {Element|Object} [doc] An element or document object to use to set the document\n * @returns {Object} Returns the current document\n */\nsetDocument = Sizzle.setDocument = function( node ) {\n\tvar hasCompare,\n\t\tdoc = node ? node.ownerDocument || node : preferredDoc,\n\t\tparent = doc.defaultView;\n\n\t// If no document and documentElement is available, return\n\tif ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {\n\t\treturn document;\n\t}\n\n\t// Set our document\n\tdocument = doc;\n\tdocElem = doc.documentElement;\n\n\t// Support tests\n\tdocumentIsHTML = !isXML( doc );\n\n\t// Support: IE>8\n\t// If iframe document is assigned to \"document\" variable and if iframe has been reloaded,\n\t// IE will throw \"permission denied\" error when accessing \"document\" variable, see jQuery #13936\n\t// IE6-8 do not support the defaultView property so parent will be undefined\n\tif ( parent && parent !== parent.top ) {\n\t\t// IE11 does not have attachEvent, so all must suffer\n\t\tif ( parent.addEventListener ) {\n\t\t\tparent.addEventListener( \"unload\", function() {\n\t\t\t\tsetDocument();\n\t\t\t}, false );\n\t\t} else if ( parent.attachEvent ) {\n\t\t\tparent.attachEvent( \"onunload\", function() {\n\t\t\t\tsetDocument();\n\t\t\t});\n\t\t}\n\t}\n\n\t/* Attributes\n\t---------------------------------------------------------------------- */\n\n\t// Support: IE<8\n\t// Verify that getAttribute really returns attributes and not properties (excepting IE8 booleans)\n\tsupport.attributes = assert(function( div ) {\n\t\tdiv.className = \"i\";\n\t\treturn !div.getAttribute(\"className\");\n\t});\n\n\t/* getElement(s)By*\n\t---------------------------------------------------------------------- */\n\n\t// Check if getElementsByTagName(\"*\") returns only elements\n\tsupport.getElementsByTagName = assert(function( div ) {\n\t\tdiv.appendChild( doc.createComment(\"\") );\n\t\treturn !div.getElementsByTagName(\"*\").length;\n\t});\n\n\t// Check if getElementsByClassName can be trusted\n\tsupport.getElementsByClassName = rnative.test( doc.getElementsByClassName ) && assert(function( div ) {\n\t\tdiv.innerHTML = \"<div class='a'></div><div class='a i'></div>\";\n\n\t\t// Support: Safari<4\n\t\t// Catch class over-caching\n\t\tdiv.firstChild.className = \"i\";\n\t\t// Support: Opera<10\n\t\t// Catch gEBCN failure to find non-leading classes\n\t\treturn div.getElementsByClassName(\"i\").length === 2;\n\t});\n\n\t// Support: IE<10\n\t// Check if getElementById returns elements by name\n\t// The broken getElementById methods don't pick up programatically-set names,\n\t// so use a roundabout getElementsByName test\n\tsupport.getById = assert(function( div ) {\n\t\tdocElem.appendChild( div ).id = expando;\n\t\treturn !doc.getElementsByName || !doc.getElementsByName( expando ).length;\n\t});\n\n\t// ID find and filter\n\tif ( support.getById ) {\n\t\tExpr.find[\"ID\"] = function( id, context ) {\n\t\t\tif ( typeof context.getElementById !== strundefined && documentIsHTML ) {\n\t\t\t\tvar m = context.getElementById( id );\n\t\t\t\t// Check parentNode to catch when Blackberry 4.6 returns\n\t\t\t\t// nodes that are no longer in the document #6963\n\t\t\t\treturn m && m.parentNode ? [m] : [];\n\t\t\t}\n\t\t};\n\t\tExpr.filter[\"ID\"] = function( id ) {\n\t\t\tvar attrId = id.replace( runescape, funescape );\n\t\t\treturn function( elem ) {\n\t\t\t\treturn elem.getAttribute(\"id\") === attrId;\n\t\t\t};\n\t\t};\n\t} else {\n\t\t// Support: IE6/7\n\t\t// getElementById is not reliable as a find shortcut\n\t\tdelete Expr.find[\"ID\"];\n\n\t\tExpr.filter[\"ID\"] =  function( id ) {\n\t\t\tvar attrId = id.replace( runescape, funescape );\n\t\t\treturn function( elem ) {\n\t\t\t\tvar node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode(\"id\");\n\t\t\t\treturn node && node.value === attrId;\n\t\t\t};\n\t\t};\n\t}\n\n\t// Tag\n\tExpr.find[\"TAG\"] = support.getElementsByTagName ?\n\t\tfunction( tag, context ) {\n\t\t\tif ( typeof context.getElementsByTagName !== strundefined ) {\n\t\t\t\treturn context.getElementsByTagName( tag );\n\t\t\t}\n\t\t} :\n\t\tfunction( tag, context ) {\n\t\t\tvar elem,\n\t\t\t\ttmp = [],\n\t\t\t\ti = 0,\n\t\t\t\tresults = context.getElementsByTagName( tag );\n\n\t\t\t// Filter out possible comments\n\t\t\tif ( tag === \"*\" ) {\n\t\t\t\twhile ( (elem = results[i++]) ) {\n\t\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\t\ttmp.push( elem );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn tmp;\n\t\t\t}\n\t\t\treturn results;\n\t\t};\n\n\t// Class\n\tExpr.find[\"CLASS\"] = support.getElementsByClassName && function( className, context ) {\n\t\tif ( typeof context.getElementsByClassName !== strundefined && documentIsHTML ) {\n\t\t\treturn context.getElementsByClassName( className );\n\t\t}\n\t};\n\n\t/* QSA/matchesSelector\n\t---------------------------------------------------------------------- */\n\n\t// QSA and matchesSelector support\n\n\t// matchesSelector(:active) reports false when true (IE9/Opera 11.5)\n\trbuggyMatches = [];\n\n\t// qSa(:focus) reports false when true (Chrome 21)\n\t// We allow this because of a bug in IE8/9 that throws an error\n\t// whenever `document.activeElement` is accessed on an iframe\n\t// So, we allow :focus to pass through QSA all the time to avoid the IE error\n\t// See http://bugs.jquery.com/ticket/13378\n\trbuggyQSA = [];\n\n\tif ( (support.qsa = rnative.test( doc.querySelectorAll )) ) {\n\t\t// Build QSA regex\n\t\t// Regex strategy adopted from Diego Perini\n\t\tassert(function( div ) {\n\t\t\t// Select is set to empty string on purpose\n\t\t\t// This is to test IE's treatment of not explicitly\n\t\t\t// setting a boolean content attribute,\n\t\t\t// since its presence should be enough\n\t\t\t// http://bugs.jquery.com/ticket/12359\n\t\t\tdiv.innerHTML = \"<select t=''><option selected=''></option></select>\";\n\n\t\t\t// Support: IE8, Opera 10-12\n\t\t\t// Nothing should be selected when empty strings follow ^= or $= or *=\n\t\t\tif ( div.querySelectorAll(\"[t^='']\").length ) {\n\t\t\t\trbuggyQSA.push( \"[*^$]=\" + whitespace + \"*(?:''|\\\"\\\")\" );\n\t\t\t}\n\n\t\t\t// Support: IE8\n\t\t\t// Boolean attributes and \"value\" are not treated correctly\n\t\t\tif ( !div.querySelectorAll(\"[selected]\").length ) {\n\t\t\t\trbuggyQSA.push( \"\\\\[\" + whitespace + \"*(?:value|\" + booleans + \")\" );\n\t\t\t}\n\n\t\t\t// Webkit/Opera - :checked should return selected option elements\n\t\t\t// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n\t\t\t// IE8 throws error here and will not see later tests\n\t\t\tif ( !div.querySelectorAll(\":checked\").length ) {\n\t\t\t\trbuggyQSA.push(\":checked\");\n\t\t\t}\n\t\t});\n\n\t\tassert(function( div ) {\n\t\t\t// Support: Windows 8 Native Apps\n\t\t\t// The type and name attributes are restricted during .innerHTML assignment\n\t\t\tvar input = doc.createElement(\"input\");\n\t\t\tinput.setAttribute( \"type\", \"hidden\" );\n\t\t\tdiv.appendChild( input ).setAttribute( \"name\", \"D\" );\n\n\t\t\t// Support: IE8\n\t\t\t// Enforce case-sensitivity of name attribute\n\t\t\tif ( div.querySelectorAll(\"[name=d]\").length ) {\n\t\t\t\trbuggyQSA.push( \"name\" + whitespace + \"*[*^$|!~]?=\" );\n\t\t\t}\n\n\t\t\t// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)\n\t\t\t// IE8 throws error here and will not see later tests\n\t\t\tif ( !div.querySelectorAll(\":enabled\").length ) {\n\t\t\t\trbuggyQSA.push( \":enabled\", \":disabled\" );\n\t\t\t}\n\n\t\t\t// Opera 10-11 does not throw on post-comma invalid pseudos\n\t\t\tdiv.querySelectorAll(\"*,:x\");\n\t\t\trbuggyQSA.push(\",.*:\");\n\t\t});\n\t}\n\n\tif ( (support.matchesSelector = rnative.test( (matches = docElem.webkitMatchesSelector ||\n\t\tdocElem.mozMatchesSelector ||\n\t\tdocElem.oMatchesSelector ||\n\t\tdocElem.msMatchesSelector) )) ) {\n\n\t\tassert(function( div ) {\n\t\t\t// Check to see if it's possible to do matchesSelector\n\t\t\t// on a disconnected node (IE 9)\n\t\t\tsupport.disconnectedMatch = matches.call( div, \"div\" );\n\n\t\t\t// This should fail with an exception\n\t\t\t// Gecko does not error, returns false instead\n\t\t\tmatches.call( div, \"[s!='']:x\" );\n\t\t\trbuggyMatches.push( \"!=\", pseudos );\n\t\t});\n\t}\n\n\trbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join(\"|\") );\n\trbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join(\"|\") );\n\n\t/* Contains\n\t---------------------------------------------------------------------- */\n\thasCompare = rnative.test( docElem.compareDocumentPosition );\n\n\t// Element contains another\n\t// Purposefully does not implement inclusive descendent\n\t// As in, an element does not contain itself\n\tcontains = hasCompare || rnative.test( docElem.contains ) ?\n\t\tfunction( a, b ) {\n\t\t\tvar adown = a.nodeType === 9 ? a.documentElement : a,\n\t\t\t\tbup = b && b.parentNode;\n\t\t\treturn a === bup || !!( bup && bup.nodeType === 1 && (\n\t\t\t\tadown.contains ?\n\t\t\t\t\tadown.contains( bup ) :\n\t\t\t\t\ta.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16\n\t\t\t));\n\t\t} :\n\t\tfunction( a, b ) {\n\t\t\tif ( b ) {\n\t\t\t\twhile ( (b = b.parentNode) ) {\n\t\t\t\t\tif ( b === a ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn false;\n\t\t};\n\n\t/* Sorting\n\t---------------------------------------------------------------------- */\n\n\t// Document order sorting\n\tsortOrder = hasCompare ?\n\tfunction( a, b ) {\n\n\t\t// Flag for duplicate removal\n\t\tif ( a === b ) {\n\t\t\thasDuplicate = true;\n\t\t\treturn 0;\n\t\t}\n\n\t\t// Sort on method existence if only one input has compareDocumentPosition\n\t\tvar compare = !a.compareDocumentPosition - !b.compareDocumentPosition;\n\t\tif ( compare ) {\n\t\t\treturn compare;\n\t\t}\n\n\t\t// Calculate position if both inputs belong to the same document\n\t\tcompare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?\n\t\t\ta.compareDocumentPosition( b ) :\n\n\t\t\t// Otherwise we know they are disconnected\n\t\t\t1;\n\n\t\t// Disconnected nodes\n\t\tif ( compare & 1 ||\n\t\t\t(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {\n\n\t\t\t// Choose the first element that is related to our preferred document\n\t\t\tif ( a === doc || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {\n\t\t\t\treturn -1;\n\t\t\t}\n\t\t\tif ( b === doc || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {\n\t\t\t\treturn 1;\n\t\t\t}\n\n\t\t\t// Maintain original order\n\t\t\treturn sortInput ?\n\t\t\t\t( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :\n\t\t\t\t0;\n\t\t}\n\n\t\treturn compare & 4 ? -1 : 1;\n\t} :\n\tfunction( a, b ) {\n\t\t// Exit early if the nodes are identical\n\t\tif ( a === b ) {\n\t\t\thasDuplicate = true;\n\t\t\treturn 0;\n\t\t}\n\n\t\tvar cur,\n\t\t\ti = 0,\n\t\t\taup = a.parentNode,\n\t\t\tbup = b.parentNode,\n\t\t\tap = [ a ],\n\t\t\tbp = [ b ];\n\n\t\t// Parentless nodes are either documents or disconnected\n\t\tif ( !aup || !bup ) {\n\t\t\treturn a === doc ? -1 :\n\t\t\t\tb === doc ? 1 :\n\t\t\t\taup ? -1 :\n\t\t\t\tbup ? 1 :\n\t\t\t\tsortInput ?\n\t\t\t\t( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :\n\t\t\t\t0;\n\n\t\t// If the nodes are siblings, we can do a quick check\n\t\t} else if ( aup === bup ) {\n\t\t\treturn siblingCheck( a, b );\n\t\t}\n\n\t\t// Otherwise we need full lists of their ancestors for comparison\n\t\tcur = a;\n\t\twhile ( (cur = cur.parentNode) ) {\n\t\t\tap.unshift( cur );\n\t\t}\n\t\tcur = b;\n\t\twhile ( (cur = cur.parentNode) ) {\n\t\t\tbp.unshift( cur );\n\t\t}\n\n\t\t// Walk down the tree looking for a discrepancy\n\t\twhile ( ap[i] === bp[i] ) {\n\t\t\ti++;\n\t\t}\n\n\t\treturn i ?\n\t\t\t// Do a sibling check if the nodes have a common ancestor\n\t\t\tsiblingCheck( ap[i], bp[i] ) :\n\n\t\t\t// Otherwise nodes in our document sort first\n\t\t\tap[i] === preferredDoc ? -1 :\n\t\t\tbp[i] === preferredDoc ? 1 :\n\t\t\t0;\n\t};\n\n\treturn doc;\n};\n\nSizzle.matches = function( expr, elements ) {\n\treturn Sizzle( expr, null, null, elements );\n};\n\nSizzle.matchesSelector = function( elem, expr ) {\n\t// Set document vars if needed\n\tif ( ( elem.ownerDocument || elem ) !== document ) {\n\t\tsetDocument( elem );\n\t}\n\n\t// Make sure that attribute selectors are quoted\n\texpr = expr.replace( rattributeQuotes, \"='$1']\" );\n\n\tif ( support.matchesSelector && documentIsHTML &&\n\t\t( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&\n\t\t( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {\n\n\t\ttry {\n\t\t\tvar ret = matches.call( elem, expr );\n\n\t\t\t// IE 9's matchesSelector returns false on disconnected nodes\n\t\t\tif ( ret || support.disconnectedMatch ||\n\t\t\t\t\t// As well, disconnected nodes are said to be in a document\n\t\t\t\t\t// fragment in IE 9\n\t\t\t\t\telem.document && elem.document.nodeType !== 11 ) {\n\t\t\t\treturn ret;\n\t\t\t}\n\t\t} catch(e) {}\n\t}\n\n\treturn Sizzle( expr, document, null, [elem] ).length > 0;\n};\n\nSizzle.contains = function( context, elem ) {\n\t// Set document vars if needed\n\tif ( ( context.ownerDocument || context ) !== document ) {\n\t\tsetDocument( context );\n\t}\n\treturn contains( context, elem );\n};\n\nSizzle.attr = function( elem, name ) {\n\t// Set document vars if needed\n\tif ( ( elem.ownerDocument || elem ) !== document ) {\n\t\tsetDocument( elem );\n\t}\n\n\tvar fn = Expr.attrHandle[ name.toLowerCase() ],\n\t\t// Don't get fooled by Object.prototype properties (jQuery #13807)\n\t\tval = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?\n\t\t\tfn( elem, name, !documentIsHTML ) :\n\t\t\tundefined;\n\n\treturn val !== undefined ?\n\t\tval :\n\t\tsupport.attributes || !documentIsHTML ?\n\t\t\telem.getAttribute( name ) :\n\t\t\t(val = elem.getAttributeNode(name)) && val.specified ?\n\t\t\t\tval.value :\n\t\t\t\tnull;\n};\n\nSizzle.error = function( msg ) {\n\tthrow new Error( \"Syntax error, unrecognized expression: \" + msg );\n};\n\n/**\n * Document sorting and removing duplicates\n * @param {ArrayLike} results\n */\nSizzle.uniqueSort = function( results ) {\n\tvar elem,\n\t\tduplicates = [],\n\t\tj = 0,\n\t\ti = 0;\n\n\t// Unless we *know* we can detect duplicates, assume their presence\n\thasDuplicate = !support.detectDuplicates;\n\tsortInput = !support.sortStable && results.slice( 0 );\n\tresults.sort( sortOrder );\n\n\tif ( hasDuplicate ) {\n\t\twhile ( (elem = results[i++]) ) {\n\t\t\tif ( elem === results[ i ] ) {\n\t\t\t\tj = duplicates.push( i );\n\t\t\t}\n\t\t}\n\t\twhile ( j-- ) {\n\t\t\tresults.splice( duplicates[ j ], 1 );\n\t\t}\n\t}\n\n\t// Clear input after sorting to release objects\n\t// See https://github.com/jquery/sizzle/pull/225\n\tsortInput = null;\n\n\treturn results;\n};\n\n/**\n * Utility function for retrieving the text value of an array of DOM nodes\n * @param {Array|Element} elem\n */\ngetText = Sizzle.getText = function( elem ) {\n\tvar node,\n\t\tret = \"\",\n\t\ti = 0,\n\t\tnodeType = elem.nodeType;\n\n\tif ( !nodeType ) {\n\t\t// If no nodeType, this is expected to be an array\n\t\twhile ( (node = elem[i++]) ) {\n\t\t\t// Do not traverse comment nodes\n\t\t\tret += getText( node );\n\t\t}\n\t} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {\n\t\t// Use textContent for elements\n\t\t// innerText usage removed for consistency of new lines (jQuery #11153)\n\t\tif ( typeof elem.textContent === \"string\" ) {\n\t\t\treturn elem.textContent;\n\t\t} else {\n\t\t\t// Traverse its children\n\t\t\tfor ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n\t\t\t\tret += getText( elem );\n\t\t\t}\n\t\t}\n\t} else if ( nodeType === 3 || nodeType === 4 ) {\n\t\treturn elem.nodeValue;\n\t}\n\t// Do not include comment or processing instruction nodes\n\n\treturn ret;\n};\n\nExpr = Sizzle.selectors = {\n\n\t// Can be adjusted by the user\n\tcacheLength: 50,\n\n\tcreatePseudo: markFunction,\n\n\tmatch: matchExpr,\n\n\tattrHandle: {},\n\n\tfind: {},\n\n\trelative: {\n\t\t\">\": { dir: \"parentNode\", first: true },\n\t\t\" \": { dir: \"parentNode\" },\n\t\t\"+\": { dir: \"previousSibling\", first: true },\n\t\t\"~\": { dir: \"previousSibling\" }\n\t},\n\n\tpreFilter: {\n\t\t\"ATTR\": function( match ) {\n\t\t\tmatch[1] = match[1].replace( runescape, funescape );\n\n\t\t\t// Move the given value to match[3] whether quoted or unquoted\n\t\t\tmatch[3] = ( match[4] || match[5] || \"\" ).replace( runescape, funescape );\n\n\t\t\tif ( match[2] === \"~=\" ) {\n\t\t\t\tmatch[3] = \" \" + match[3] + \" \";\n\t\t\t}\n\n\t\t\treturn match.slice( 0, 4 );\n\t\t},\n\n\t\t\"CHILD\": function( match ) {\n\t\t\t/* matches from matchExpr[\"CHILD\"]\n\t\t\t\t1 type (only|nth|...)\n\t\t\t\t2 what (child|of-type)\n\t\t\t\t3 argument (even|odd|\\d*|\\d*n([+-]\\d+)?|...)\n\t\t\t\t4 xn-component of xn+y argument ([+-]?\\d*n|)\n\t\t\t\t5 sign of xn-component\n\t\t\t\t6 x of xn-component\n\t\t\t\t7 sign of y-component\n\t\t\t\t8 y of y-component\n\t\t\t*/\n\t\t\tmatch[1] = match[1].toLowerCase();\n\n\t\t\tif ( match[1].slice( 0, 3 ) === \"nth\" ) {\n\t\t\t\t// nth-* requires argument\n\t\t\t\tif ( !match[3] ) {\n\t\t\t\t\tSizzle.error( match[0] );\n\t\t\t\t}\n\n\t\t\t\t// numeric x and y parameters for Expr.filter.CHILD\n\t\t\t\t// remember that false/true cast respectively to 0/1\n\t\t\t\tmatch[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === \"even\" || match[3] === \"odd\" ) );\n\t\t\t\tmatch[5] = +( ( match[7] + match[8] ) || match[3] === \"odd\" );\n\n\t\t\t// other types prohibit arguments\n\t\t\t} else if ( match[3] ) {\n\t\t\t\tSizzle.error( match[0] );\n\t\t\t}\n\n\t\t\treturn match;\n\t\t},\n\n\t\t\"PSEUDO\": function( match ) {\n\t\t\tvar excess,\n\t\t\t\tunquoted = !match[5] && match[2];\n\n\t\t\tif ( matchExpr[\"CHILD\"].test( match[0] ) ) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\t// Accept quoted arguments as-is\n\t\t\tif ( match[3] && match[4] !== undefined ) {\n\t\t\t\tmatch[2] = match[4];\n\n\t\t\t// Strip excess characters from unquoted arguments\n\t\t\t} else if ( unquoted && rpseudo.test( unquoted ) &&\n\t\t\t\t// Get excess from tokenize (recursively)\n\t\t\t\t(excess = tokenize( unquoted, true )) &&\n\t\t\t\t// advance to the next closing parenthesis\n\t\t\t\t(excess = unquoted.indexOf( \")\", unquoted.length - excess ) - unquoted.length) ) {\n\n\t\t\t\t// excess is a negative index\n\t\t\t\tmatch[0] = match[0].slice( 0, excess );\n\t\t\t\tmatch[2] = unquoted.slice( 0, excess );\n\t\t\t}\n\n\t\t\t// Return only captures needed by the pseudo filter method (type and argument)\n\t\t\treturn match.slice( 0, 3 );\n\t\t}\n\t},\n\n\tfilter: {\n\n\t\t\"TAG\": function( nodeNameSelector ) {\n\t\t\tvar nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();\n\t\t\treturn nodeNameSelector === \"*\" ?\n\t\t\t\tfunction() { return true; } :\n\t\t\t\tfunction( elem ) {\n\t\t\t\t\treturn elem.nodeName && elem.nodeName.toLowerCase() === nodeName;\n\t\t\t\t};\n\t\t},\n\n\t\t\"CLASS\": function( className ) {\n\t\t\tvar pattern = classCache[ className + \" \" ];\n\n\t\t\treturn pattern ||\n\t\t\t\t(pattern = new RegExp( \"(^|\" + whitespace + \")\" + className + \"(\" + whitespace + \"|$)\" )) &&\n\t\t\t\tclassCache( className, function( elem ) {\n\t\t\t\t\treturn pattern.test( typeof elem.className === \"string\" && elem.className || typeof elem.getAttribute !== strundefined && elem.getAttribute(\"class\") || \"\" );\n\t\t\t\t});\n\t\t},\n\n\t\t\"ATTR\": function( name, operator, check ) {\n\t\t\treturn function( elem ) {\n\t\t\t\tvar result = Sizzle.attr( elem, name );\n\n\t\t\t\tif ( result == null ) {\n\t\t\t\t\treturn operator === \"!=\";\n\t\t\t\t}\n\t\t\t\tif ( !operator ) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\n\t\t\t\tresult += \"\";\n\n\t\t\t\treturn operator === \"=\" ? result === check :\n\t\t\t\t\toperator === \"!=\" ? result !== check :\n\t\t\t\t\toperator === \"^=\" ? check && result.indexOf( check ) === 0 :\n\t\t\t\t\toperator === \"*=\" ? check && result.indexOf( check ) > -1 :\n\t\t\t\t\toperator === \"$=\" ? check && result.slice( -check.length ) === check :\n\t\t\t\t\toperator === \"~=\" ? ( \" \" + result + \" \" ).indexOf( check ) > -1 :\n\t\t\t\t\toperator === \"|=\" ? result === check || result.slice( 0, check.length + 1 ) === check + \"-\" :\n\t\t\t\t\tfalse;\n\t\t\t};\n\t\t},\n\n\t\t\"CHILD\": function( type, what, argument, first, last ) {\n\t\t\tvar simple = type.slice( 0, 3 ) !== \"nth\",\n\t\t\t\tforward = type.slice( -4 ) !== \"last\",\n\t\t\t\tofType = what === \"of-type\";\n\n\t\t\treturn first === 1 && last === 0 ?\n\n\t\t\t\t// Shortcut for :nth-*(n)\n\t\t\t\tfunction( elem ) {\n\t\t\t\t\treturn !!elem.parentNode;\n\t\t\t\t} :\n\n\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\tvar cache, outerCache, node, diff, nodeIndex, start,\n\t\t\t\t\t\tdir = simple !== forward ? \"nextSibling\" : \"previousSibling\",\n\t\t\t\t\t\tparent = elem.parentNode,\n\t\t\t\t\t\tname = ofType && elem.nodeName.toLowerCase(),\n\t\t\t\t\t\tuseCache = !xml && !ofType;\n\n\t\t\t\t\tif ( parent ) {\n\n\t\t\t\t\t\t// :(first|last|only)-(child|of-type)\n\t\t\t\t\t\tif ( simple ) {\n\t\t\t\t\t\t\twhile ( dir ) {\n\t\t\t\t\t\t\t\tnode = elem;\n\t\t\t\t\t\t\t\twhile ( (node = node[ dir ]) ) {\n\t\t\t\t\t\t\t\t\tif ( ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1 ) {\n\t\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t// Reverse direction for :only-* (if we haven't yet done so)\n\t\t\t\t\t\t\t\tstart = dir = type === \"only\" && !start && \"nextSibling\";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tstart = [ forward ? parent.firstChild : parent.lastChild ];\n\n\t\t\t\t\t\t// non-xml :nth-child(...) stores cache data on `parent`\n\t\t\t\t\t\tif ( forward && useCache ) {\n\t\t\t\t\t\t\t// Seek `elem` from a previously-cached index\n\t\t\t\t\t\t\touterCache = parent[ expando ] || (parent[ expando ] = {});\n\t\t\t\t\t\t\tcache = outerCache[ type ] || [];\n\t\t\t\t\t\t\tnodeIndex = cache[0] === dirruns && cache[1];\n\t\t\t\t\t\t\tdiff = cache[0] === dirruns && cache[2];\n\t\t\t\t\t\t\tnode = nodeIndex && parent.childNodes[ nodeIndex ];\n\n\t\t\t\t\t\t\twhile ( (node = ++nodeIndex && node && node[ dir ] ||\n\n\t\t\t\t\t\t\t\t// Fallback to seeking `elem` from the start\n\t\t\t\t\t\t\t\t(diff = nodeIndex = 0) || start.pop()) ) {\n\n\t\t\t\t\t\t\t\t// When found, cache indexes on `parent` and break\n\t\t\t\t\t\t\t\tif ( node.nodeType === 1 && ++diff && node === elem ) {\n\t\t\t\t\t\t\t\t\touterCache[ type ] = [ dirruns, nodeIndex, diff ];\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Use previously-cached element index if available\n\t\t\t\t\t\t} else if ( useCache && (cache = (elem[ expando ] || (elem[ expando ] = {}))[ type ]) && cache[0] === dirruns ) {\n\t\t\t\t\t\t\tdiff = cache[1];\n\n\t\t\t\t\t\t// xml :nth-child(...) or :nth-last-child(...) or :nth(-last)?-of-type(...)\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Use the same loop as above to seek `elem` from the start\n\t\t\t\t\t\t\twhile ( (node = ++nodeIndex && node && node[ dir ] ||\n\t\t\t\t\t\t\t\t(diff = nodeIndex = 0) || start.pop()) ) {\n\n\t\t\t\t\t\t\t\tif ( ( ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1 ) && ++diff ) {\n\t\t\t\t\t\t\t\t\t// Cache the index of each encountered element\n\t\t\t\t\t\t\t\t\tif ( useCache ) {\n\t\t\t\t\t\t\t\t\t\t(node[ expando ] || (node[ expando ] = {}))[ type ] = [ dirruns, diff ];\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\tif ( node === elem ) {\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Incorporate the offset, then check against cycle size\n\t\t\t\t\t\tdiff -= last;\n\t\t\t\t\t\treturn diff === first || ( diff % first === 0 && diff / first >= 0 );\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t},\n\n\t\t\"PSEUDO\": function( pseudo, argument ) {\n\t\t\t// pseudo-class names are case-insensitive\n\t\t\t// http://www.w3.org/TR/selectors/#pseudo-classes\n\t\t\t// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters\n\t\t\t// Remember that setFilters inherits from pseudos\n\t\t\tvar args,\n\t\t\t\tfn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||\n\t\t\t\t\tSizzle.error( \"unsupported pseudo: \" + pseudo );\n\n\t\t\t// The user may use createPseudo to indicate that\n\t\t\t// arguments are needed to create the filter function\n\t\t\t// just as Sizzle does\n\t\t\tif ( fn[ expando ] ) {\n\t\t\t\treturn fn( argument );\n\t\t\t}\n\n\t\t\t// But maintain support for old signatures\n\t\t\tif ( fn.length > 1 ) {\n\t\t\t\targs = [ pseudo, pseudo, \"\", argument ];\n\t\t\t\treturn Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?\n\t\t\t\t\tmarkFunction(function( seed, matches ) {\n\t\t\t\t\t\tvar idx,\n\t\t\t\t\t\t\tmatched = fn( seed, argument ),\n\t\t\t\t\t\t\ti = matched.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tidx = indexOf.call( seed, matched[i] );\n\t\t\t\t\t\t\tseed[ idx ] = !( matches[ idx ] = matched[i] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}) :\n\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\treturn fn( elem, 0, args );\n\t\t\t\t\t};\n\t\t\t}\n\n\t\t\treturn fn;\n\t\t}\n\t},\n\n\tpseudos: {\n\t\t// Potentially complex pseudos\n\t\t\"not\": markFunction(function( selector ) {\n\t\t\t// Trim the selector passed to compile\n\t\t\t// to avoid treating leading and trailing\n\t\t\t// spaces as combinators\n\t\t\tvar input = [],\n\t\t\t\tresults = [],\n\t\t\t\tmatcher = compile( selector.replace( rtrim, \"$1\" ) );\n\n\t\t\treturn matcher[ expando ] ?\n\t\t\t\tmarkFunction(function( seed, matches, context, xml ) {\n\t\t\t\t\tvar elem,\n\t\t\t\t\t\tunmatched = matcher( seed, null, xml, [] ),\n\t\t\t\t\t\ti = seed.length;\n\n\t\t\t\t\t// Match elements unmatched by `matcher`\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\tif ( (elem = unmatched[i]) ) {\n\t\t\t\t\t\t\tseed[i] = !(matches[i] = elem);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}) :\n\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\tinput[0] = elem;\n\t\t\t\t\tmatcher( input, null, xml, results );\n\t\t\t\t\treturn !results.pop();\n\t\t\t\t};\n\t\t}),\n\n\t\t\"has\": markFunction(function( selector ) {\n\t\t\treturn function( elem ) {\n\t\t\t\treturn Sizzle( selector, elem ).length > 0;\n\t\t\t};\n\t\t}),\n\n\t\t\"contains\": markFunction(function( text ) {\n\t\t\treturn function( elem ) {\n\t\t\t\treturn ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;\n\t\t\t};\n\t\t}),\n\n\t\t// \"Whether an element is represented by a :lang() selector\n\t\t// is based solely on the element's language value\n\t\t// being equal to the identifier C,\n\t\t// or beginning with the identifier C immediately followed by \"-\".\n\t\t// The matching of C against the element's language value is performed case-insensitively.\n\t\t// The identifier C does not have to be a valid language name.\"\n\t\t// http://www.w3.org/TR/selectors/#lang-pseudo\n\t\t\"lang\": markFunction( function( lang ) {\n\t\t\t// lang value must be a valid identifier\n\t\t\tif ( !ridentifier.test(lang || \"\") ) {\n\t\t\t\tSizzle.error( \"unsupported lang: \" + lang );\n\t\t\t}\n\t\t\tlang = lang.replace( runescape, funescape ).toLowerCase();\n\t\t\treturn function( elem ) {\n\t\t\t\tvar elemLang;\n\t\t\t\tdo {\n\t\t\t\t\tif ( (elemLang = documentIsHTML ?\n\t\t\t\t\t\telem.lang :\n\t\t\t\t\t\telem.getAttribute(\"xml:lang\") || elem.getAttribute(\"lang\")) ) {\n\n\t\t\t\t\t\telemLang = elemLang.toLowerCase();\n\t\t\t\t\t\treturn elemLang === lang || elemLang.indexOf( lang + \"-\" ) === 0;\n\t\t\t\t\t}\n\t\t\t\t} while ( (elem = elem.parentNode) && elem.nodeType === 1 );\n\t\t\t\treturn false;\n\t\t\t};\n\t\t}),\n\n\t\t// Miscellaneous\n\t\t\"target\": function( elem ) {\n\t\t\tvar hash = window.location && window.location.hash;\n\t\t\treturn hash && hash.slice( 1 ) === elem.id;\n\t\t},\n\n\t\t\"root\": function( elem ) {\n\t\t\treturn elem === docElem;\n\t\t},\n\n\t\t\"focus\": function( elem ) {\n\t\t\treturn elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);\n\t\t},\n\n\t\t// Boolean properties\n\t\t\"enabled\": function( elem ) {\n\t\t\treturn elem.disabled === false;\n\t\t},\n\n\t\t\"disabled\": function( elem ) {\n\t\t\treturn elem.disabled === true;\n\t\t},\n\n\t\t\"checked\": function( elem ) {\n\t\t\t// In CSS3, :checked should return both checked and selected elements\n\t\t\t// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n\t\t\tvar nodeName = elem.nodeName.toLowerCase();\n\t\t\treturn (nodeName === \"input\" && !!elem.checked) || (nodeName === \"option\" && !!elem.selected);\n\t\t},\n\n\t\t\"selected\": function( elem ) {\n\t\t\t// Accessing this property makes selected-by-default\n\t\t\t// options in Safari work properly\n\t\t\tif ( elem.parentNode ) {\n\t\t\t\telem.parentNode.selectedIndex;\n\t\t\t}\n\n\t\t\treturn elem.selected === true;\n\t\t},\n\n\t\t// Contents\n\t\t\"empty\": function( elem ) {\n\t\t\t// http://www.w3.org/TR/selectors/#empty-pseudo\n\t\t\t// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),\n\t\t\t//   but not by others (comment: 8; processing instruction: 7; etc.)\n\t\t\t// nodeType < 6 works because attributes (2) do not appear as children\n\t\t\tfor ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n\t\t\t\tif ( elem.nodeType < 6 ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn true;\n\t\t},\n\n\t\t\"parent\": function( elem ) {\n\t\t\treturn !Expr.pseudos[\"empty\"]( elem );\n\t\t},\n\n\t\t// Element/input types\n\t\t\"header\": function( elem ) {\n\t\t\treturn rheader.test( elem.nodeName );\n\t\t},\n\n\t\t\"input\": function( elem ) {\n\t\t\treturn rinputs.test( elem.nodeName );\n\t\t},\n\n\t\t\"button\": function( elem ) {\n\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\treturn name === \"input\" && elem.type === \"button\" || name === \"button\";\n\t\t},\n\n\t\t\"text\": function( elem ) {\n\t\t\tvar attr;\n\t\t\treturn elem.nodeName.toLowerCase() === \"input\" &&\n\t\t\t\telem.type === \"text\" &&\n\n\t\t\t\t// Support: IE<8\n\t\t\t\t// New HTML5 attribute values (e.g., \"search\") appear with elem.type === \"text\"\n\t\t\t\t( (attr = elem.getAttribute(\"type\")) == null || attr.toLowerCase() === \"text\" );\n\t\t},\n\n\t\t// Position-in-collection\n\t\t\"first\": createPositionalPseudo(function() {\n\t\t\treturn [ 0 ];\n\t\t}),\n\n\t\t\"last\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\treturn [ length - 1 ];\n\t\t}),\n\n\t\t\"eq\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\treturn [ argument < 0 ? argument + length : argument ];\n\t\t}),\n\n\t\t\"even\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\tvar i = 0;\n\t\t\tfor ( ; i < length; i += 2 ) {\n\t\t\t\tmatchIndexes.push( i );\n\t\t\t}\n\t\t\treturn matchIndexes;\n\t\t}),\n\n\t\t\"odd\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\tvar i = 1;\n\t\t\tfor ( ; i < length; i += 2 ) {\n\t\t\t\tmatchIndexes.push( i );\n\t\t\t}\n\t\t\treturn matchIndexes;\n\t\t}),\n\n\t\t\"lt\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\tvar i = argument < 0 ? argument + length : argument;\n\t\t\tfor ( ; --i >= 0; ) {\n\t\t\t\tmatchIndexes.push( i );\n\t\t\t}\n\t\t\treturn matchIndexes;\n\t\t}),\n\n\t\t\"gt\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\tvar i = argument < 0 ? argument + length : argument;\n\t\t\tfor ( ; ++i < length; ) {\n\t\t\t\tmatchIndexes.push( i );\n\t\t\t}\n\t\t\treturn matchIndexes;\n\t\t})\n\t}\n};\n\nExpr.pseudos[\"nth\"] = Expr.pseudos[\"eq\"];\n\n// Add button/input type pseudos\nfor ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {\n\tExpr.pseudos[ i ] = createInputPseudo( i );\n}\nfor ( i in { submit: true, reset: true } ) {\n\tExpr.pseudos[ i ] = createButtonPseudo( i );\n}\n\n// Easy API for creating new setFilters\nfunction setFilters() {}\nsetFilters.prototype = Expr.filters = Expr.pseudos;\nExpr.setFilters = new setFilters();\n\nfunction tokenize( selector, parseOnly ) {\n\tvar matched, match, tokens, type,\n\t\tsoFar, groups, preFilters,\n\t\tcached = tokenCache[ selector + \" \" ];\n\n\tif ( cached ) {\n\t\treturn parseOnly ? 0 : cached.slice( 0 );\n\t}\n\n\tsoFar = selector;\n\tgroups = [];\n\tpreFilters = Expr.preFilter;\n\n\twhile ( soFar ) {\n\n\t\t// Comma and first run\n\t\tif ( !matched || (match = rcomma.exec( soFar )) ) {\n\t\t\tif ( match ) {\n\t\t\t\t// Don't consume trailing commas as valid\n\t\t\t\tsoFar = soFar.slice( match[0].length ) || soFar;\n\t\t\t}\n\t\t\tgroups.push( (tokens = []) );\n\t\t}\n\n\t\tmatched = false;\n\n\t\t// Combinators\n\t\tif ( (match = rcombinators.exec( soFar )) ) {\n\t\t\tmatched = match.shift();\n\t\t\ttokens.push({\n\t\t\t\tvalue: matched,\n\t\t\t\t// Cast descendant combinators to space\n\t\t\t\ttype: match[0].replace( rtrim, \" \" )\n\t\t\t});\n\t\t\tsoFar = soFar.slice( matched.length );\n\t\t}\n\n\t\t// Filters\n\t\tfor ( type in Expr.filter ) {\n\t\t\tif ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||\n\t\t\t\t(match = preFilters[ type ]( match ))) ) {\n\t\t\t\tmatched = match.shift();\n\t\t\t\ttokens.push({\n\t\t\t\t\tvalue: matched,\n\t\t\t\t\ttype: type,\n\t\t\t\t\tmatches: match\n\t\t\t\t});\n\t\t\t\tsoFar = soFar.slice( matched.length );\n\t\t\t}\n\t\t}\n\n\t\tif ( !matched ) {\n\t\t\tbreak;\n\t\t}\n\t}\n\n\t// Return the length of the invalid excess\n\t// if we're just parsing\n\t// Otherwise, throw an error or return tokens\n\treturn parseOnly ?\n\t\tsoFar.length :\n\t\tsoFar ?\n\t\t\tSizzle.error( selector ) :\n\t\t\t// Cache the tokens\n\t\t\ttokenCache( selector, groups ).slice( 0 );\n}\n\nfunction toSelector( tokens ) {\n\tvar i = 0,\n\t\tlen = tokens.length,\n\t\tselector = \"\";\n\tfor ( ; i < len; i++ ) {\n\t\tselector += tokens[i].value;\n\t}\n\treturn selector;\n}\n\nfunction addCombinator( matcher, combinator, base ) {\n\tvar dir = combinator.dir,\n\t\tcheckNonElements = base && dir === \"parentNode\",\n\t\tdoneName = done++;\n\n\treturn combinator.first ?\n\t\t// Check against closest ancestor/preceding element\n\t\tfunction( elem, context, xml ) {\n\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\treturn matcher( elem, context, xml );\n\t\t\t\t}\n\t\t\t}\n\t\t} :\n\n\t\t// Check against all ancestor/preceding elements\n\t\tfunction( elem, context, xml ) {\n\t\t\tvar oldCache, outerCache,\n\t\t\t\tnewCache = [ dirruns, doneName ];\n\n\t\t\t// We can't set arbitrary data on XML nodes, so they don't benefit from dir caching\n\t\t\tif ( xml ) {\n\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\tif ( matcher( elem, context, xml ) ) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\touterCache = elem[ expando ] || (elem[ expando ] = {});\n\t\t\t\t\t\tif ( (oldCache = outerCache[ dir ]) &&\n\t\t\t\t\t\t\toldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {\n\n\t\t\t\t\t\t\t// Assign to newCache so results back-propagate to previous elements\n\t\t\t\t\t\t\treturn (newCache[ 2 ] = oldCache[ 2 ]);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Reuse newcache so results back-propagate to previous elements\n\t\t\t\t\t\t\touterCache[ dir ] = newCache;\n\n\t\t\t\t\t\t\t// A match means we're done; a fail means we have to keep checking\n\t\t\t\t\t\t\tif ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {\n\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n}\n\nfunction elementMatcher( matchers ) {\n\treturn matchers.length > 1 ?\n\t\tfunction( elem, context, xml ) {\n\t\t\tvar i = matchers.length;\n\t\t\twhile ( i-- ) {\n\t\t\t\tif ( !matchers[i]( elem, context, xml ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn true;\n\t\t} :\n\t\tmatchers[0];\n}\n\nfunction condense( unmatched, map, filter, context, xml ) {\n\tvar elem,\n\t\tnewUnmatched = [],\n\t\ti = 0,\n\t\tlen = unmatched.length,\n\t\tmapped = map != null;\n\n\tfor ( ; i < len; i++ ) {\n\t\tif ( (elem = unmatched[i]) ) {\n\t\t\tif ( !filter || filter( elem, context, xml ) ) {\n\t\t\t\tnewUnmatched.push( elem );\n\t\t\t\tif ( mapped ) {\n\t\t\t\t\tmap.push( i );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\treturn newUnmatched;\n}\n\nfunction setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {\n\tif ( postFilter && !postFilter[ expando ] ) {\n\t\tpostFilter = setMatcher( postFilter );\n\t}\n\tif ( postFinder && !postFinder[ expando ] ) {\n\t\tpostFinder = setMatcher( postFinder, postSelector );\n\t}\n\treturn markFunction(function( seed, results, context, xml ) {\n\t\tvar temp, i, elem,\n\t\t\tpreMap = [],\n\t\t\tpostMap = [],\n\t\t\tpreexisting = results.length,\n\n\t\t\t// Get initial elements from seed or context\n\t\t\telems = seed || multipleContexts( selector || \"*\", context.nodeType ? [ context ] : context, [] ),\n\n\t\t\t// Prefilter to get matcher input, preserving a map for seed-results synchronization\n\t\t\tmatcherIn = preFilter && ( seed || !selector ) ?\n\t\t\t\tcondense( elems, preMap, preFilter, context, xml ) :\n\t\t\t\telems,\n\n\t\t\tmatcherOut = matcher ?\n\t\t\t\t// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,\n\t\t\t\tpostFinder || ( seed ? preFilter : preexisting || postFilter ) ?\n\n\t\t\t\t\t// ...intermediate processing is necessary\n\t\t\t\t\t[] :\n\n\t\t\t\t\t// ...otherwise use results directly\n\t\t\t\t\tresults :\n\t\t\t\tmatcherIn;\n\n\t\t// Find primary matches\n\t\tif ( matcher ) {\n\t\t\tmatcher( matcherIn, matcherOut, context, xml );\n\t\t}\n\n\t\t// Apply postFilter\n\t\tif ( postFilter ) {\n\t\t\ttemp = condense( matcherOut, postMap );\n\t\t\tpostFilter( temp, [], context, xml );\n\n\t\t\t// Un-match failing elements by moving them back to matcherIn\n\t\t\ti = temp.length;\n\t\t\twhile ( i-- ) {\n\t\t\t\tif ( (elem = temp[i]) ) {\n\t\t\t\t\tmatcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( seed ) {\n\t\t\tif ( postFinder || preFilter ) {\n\t\t\t\tif ( postFinder ) {\n\t\t\t\t\t// Get the final matcherOut by condensing this intermediate into postFinder contexts\n\t\t\t\t\ttemp = [];\n\t\t\t\t\ti = matcherOut.length;\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\tif ( (elem = matcherOut[i]) ) {\n\t\t\t\t\t\t\t// Restore matcherIn since elem is not yet a final match\n\t\t\t\t\t\t\ttemp.push( (matcherIn[i] = elem) );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tpostFinder( null, (matcherOut = []), temp, xml );\n\t\t\t\t}\n\n\t\t\t\t// Move matched elements from seed to results to keep them synchronized\n\t\t\t\ti = matcherOut.length;\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\tif ( (elem = matcherOut[i]) &&\n\t\t\t\t\t\t(temp = postFinder ? indexOf.call( seed, elem ) : preMap[i]) > -1 ) {\n\n\t\t\t\t\t\tseed[temp] = !(results[temp] = elem);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t// Add elements to results, through postFinder if defined\n\t\t} else {\n\t\t\tmatcherOut = condense(\n\t\t\t\tmatcherOut === results ?\n\t\t\t\t\tmatcherOut.splice( preexisting, matcherOut.length ) :\n\t\t\t\t\tmatcherOut\n\t\t\t);\n\t\t\tif ( postFinder ) {\n\t\t\t\tpostFinder( null, results, matcherOut, xml );\n\t\t\t} else {\n\t\t\t\tpush.apply( results, matcherOut );\n\t\t\t}\n\t\t}\n\t});\n}\n\nfunction matcherFromTokens( tokens ) {\n\tvar checkContext, matcher, j,\n\t\tlen = tokens.length,\n\t\tleadingRelative = Expr.relative[ tokens[0].type ],\n\t\timplicitRelative = leadingRelative || Expr.relative[\" \"],\n\t\ti = leadingRelative ? 1 : 0,\n\n\t\t// The foundational matcher ensures that elements are reachable from top-level context(s)\n\t\tmatchContext = addCombinator( function( elem ) {\n\t\t\treturn elem === checkContext;\n\t\t}, implicitRelative, true ),\n\t\tmatchAnyContext = addCombinator( function( elem ) {\n\t\t\treturn indexOf.call( checkContext, elem ) > -1;\n\t\t}, implicitRelative, true ),\n\t\tmatchers = [ function( elem, context, xml ) {\n\t\t\treturn ( !leadingRelative && ( xml || context !== outermostContext ) ) || (\n\t\t\t\t(checkContext = context).nodeType ?\n\t\t\t\t\tmatchContext( elem, context, xml ) :\n\t\t\t\t\tmatchAnyContext( elem, context, xml ) );\n\t\t} ];\n\n\tfor ( ; i < len; i++ ) {\n\t\tif ( (matcher = Expr.relative[ tokens[i].type ]) ) {\n\t\t\tmatchers = [ addCombinator(elementMatcher( matchers ), matcher) ];\n\t\t} else {\n\t\t\tmatcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );\n\n\t\t\t// Return special upon seeing a positional matcher\n\t\t\tif ( matcher[ expando ] ) {\n\t\t\t\t// Find the next relative operator (if any) for proper handling\n\t\t\t\tj = ++i;\n\t\t\t\tfor ( ; j < len; j++ ) {\n\t\t\t\t\tif ( Expr.relative[ tokens[j].type ] ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn setMatcher(\n\t\t\t\t\ti > 1 && elementMatcher( matchers ),\n\t\t\t\t\ti > 1 && toSelector(\n\t\t\t\t\t\t// If the preceding token was a descendant combinator, insert an implicit any-element `*`\n\t\t\t\t\t\ttokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === \" \" ? \"*\" : \"\" })\n\t\t\t\t\t).replace( rtrim, \"$1\" ),\n\t\t\t\t\tmatcher,\n\t\t\t\t\ti < j && matcherFromTokens( tokens.slice( i, j ) ),\n\t\t\t\t\tj < len && matcherFromTokens( (tokens = tokens.slice( j )) ),\n\t\t\t\t\tj < len && toSelector( tokens )\n\t\t\t\t);\n\t\t\t}\n\t\t\tmatchers.push( matcher );\n\t\t}\n\t}\n\n\treturn elementMatcher( matchers );\n}\n\nfunction matcherFromGroupMatchers( elementMatchers, setMatchers ) {\n\tvar bySet = setMatchers.length > 0,\n\t\tbyElement = elementMatchers.length > 0,\n\t\tsuperMatcher = function( seed, context, xml, results, outermost ) {\n\t\t\tvar elem, j, matcher,\n\t\t\t\tmatchedCount = 0,\n\t\t\t\ti = \"0\",\n\t\t\t\tunmatched = seed && [],\n\t\t\t\tsetMatched = [],\n\t\t\t\tcontextBackup = outermostContext,\n\t\t\t\t// We must always have either seed elements or outermost context\n\t\t\t\telems = seed || byElement && Expr.find[\"TAG\"]( \"*\", outermost ),\n\t\t\t\t// Use integer dirruns iff this is the outermost matcher\n\t\t\t\tdirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),\n\t\t\t\tlen = elems.length;\n\n\t\t\tif ( outermost ) {\n\t\t\t\toutermostContext = context !== document && context;\n\t\t\t}\n\n\t\t\t// Add elements passing elementMatchers directly to results\n\t\t\t// Keep `i` a string if there are no elements so `matchedCount` will be \"00\" below\n\t\t\t// Support: IE<9, Safari\n\t\t\t// Tolerate NodeList properties (IE: \"length\"; Safari: <number>) matching elements by id\n\t\t\tfor ( ; i !== len && (elem = elems[i]) != null; i++ ) {\n\t\t\t\tif ( byElement && elem ) {\n\t\t\t\t\tj = 0;\n\t\t\t\t\twhile ( (matcher = elementMatchers[j++]) ) {\n\t\t\t\t\t\tif ( matcher( elem, context, xml ) ) {\n\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\tdirruns = dirrunsUnique;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Track unmatched elements for set filters\n\t\t\t\tif ( bySet ) {\n\t\t\t\t\t// They will have gone through all possible matchers\n\t\t\t\t\tif ( (elem = !matcher && elem) ) {\n\t\t\t\t\t\tmatchedCount--;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Lengthen the array for every element, matched or not\n\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\tunmatched.push( elem );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Apply set filters to unmatched elements\n\t\t\tmatchedCount += i;\n\t\t\tif ( bySet && i !== matchedCount ) {\n\t\t\t\tj = 0;\n\t\t\t\twhile ( (matcher = setMatchers[j++]) ) {\n\t\t\t\t\tmatcher( unmatched, setMatched, context, xml );\n\t\t\t\t}\n\n\t\t\t\tif ( seed ) {\n\t\t\t\t\t// Reintegrate element matches to eliminate the need for sorting\n\t\t\t\t\tif ( matchedCount > 0 ) {\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( !(unmatched[i] || setMatched[i]) ) {\n\t\t\t\t\t\t\t\tsetMatched[i] = pop.call( results );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Discard index placeholder values to get only actual matches\n\t\t\t\t\tsetMatched = condense( setMatched );\n\t\t\t\t}\n\n\t\t\t\t// Add matches to results\n\t\t\t\tpush.apply( results, setMatched );\n\n\t\t\t\t// Seedless set matches succeeding multiple successful matchers stipulate sorting\n\t\t\t\tif ( outermost && !seed && setMatched.length > 0 &&\n\t\t\t\t\t( matchedCount + setMatchers.length ) > 1 ) {\n\n\t\t\t\t\tSizzle.uniqueSort( results );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Override manipulation of globals by nested matchers\n\t\t\tif ( outermost ) {\n\t\t\t\tdirruns = dirrunsUnique;\n\t\t\t\toutermostContext = contextBackup;\n\t\t\t}\n\n\t\t\treturn unmatched;\n\t\t};\n\n\treturn bySet ?\n\t\tmarkFunction( superMatcher ) :\n\t\tsuperMatcher;\n}\n\ncompile = Sizzle.compile = function( selector, group /* Internal Use Only */ ) {\n\tvar i,\n\t\tsetMatchers = [],\n\t\telementMatchers = [],\n\t\tcached = compilerCache[ selector + \" \" ];\n\n\tif ( !cached ) {\n\t\t// Generate a function of recursive functions that can be used to check each element\n\t\tif ( !group ) {\n\t\t\tgroup = tokenize( selector );\n\t\t}\n\t\ti = group.length;\n\t\twhile ( i-- ) {\n\t\t\tcached = matcherFromTokens( group[i] );\n\t\t\tif ( cached[ expando ] ) {\n\t\t\t\tsetMatchers.push( cached );\n\t\t\t} else {\n\t\t\t\telementMatchers.push( cached );\n\t\t\t}\n\t\t}\n\n\t\t// Cache the compiled function\n\t\tcached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );\n\t}\n\treturn cached;\n};\n\nfunction multipleContexts( selector, contexts, results ) {\n\tvar i = 0,\n\t\tlen = contexts.length;\n\tfor ( ; i < len; i++ ) {\n\t\tSizzle( selector, contexts[i], results );\n\t}\n\treturn results;\n}\n\nfunction select( selector, context, results, seed ) {\n\tvar i, tokens, token, type, find,\n\t\tmatch = tokenize( selector );\n\n\tif ( !seed ) {\n\t\t// Try to minimize operations if there is only one group\n\t\tif ( match.length === 1 ) {\n\n\t\t\t// Take a shortcut and set the context if the root selector is an ID\n\t\t\ttokens = match[0] = match[0].slice( 0 );\n\t\t\tif ( tokens.length > 2 && (token = tokens[0]).type === \"ID\" &&\n\t\t\t\t\tsupport.getById && context.nodeType === 9 && documentIsHTML &&\n\t\t\t\t\tExpr.relative[ tokens[1].type ] ) {\n\n\t\t\t\tcontext = ( Expr.find[\"ID\"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];\n\t\t\t\tif ( !context ) {\n\t\t\t\t\treturn results;\n\t\t\t\t}\n\t\t\t\tselector = selector.slice( tokens.shift().value.length );\n\t\t\t}\n\n\t\t\t// Fetch a seed set for right-to-left matching\n\t\t\ti = matchExpr[\"needsContext\"].test( selector ) ? 0 : tokens.length;\n\t\t\twhile ( i-- ) {\n\t\t\t\ttoken = tokens[i];\n\n\t\t\t\t// Abort if we hit a combinator\n\t\t\t\tif ( Expr.relative[ (type = token.type) ] ) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tif ( (find = Expr.find[ type ]) ) {\n\t\t\t\t\t// Search, expanding context for leading sibling combinators\n\t\t\t\t\tif ( (seed = find(\n\t\t\t\t\t\ttoken.matches[0].replace( runescape, funescape ),\n\t\t\t\t\t\trsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context\n\t\t\t\t\t)) ) {\n\n\t\t\t\t\t\t// If seed is empty or no tokens remain, we can return early\n\t\t\t\t\t\ttokens.splice( i, 1 );\n\t\t\t\t\t\tselector = seed.length && toSelector( tokens );\n\t\t\t\t\t\tif ( !selector ) {\n\t\t\t\t\t\t\tpush.apply( results, seed );\n\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\t// Compile and execute a filtering function\n\t// Provide `match` to avoid retokenization if we modified the selector above\n\tcompile( selector, match )(\n\t\tseed,\n\t\tcontext,\n\t\t!documentIsHTML,\n\t\tresults,\n\t\trsibling.test( selector ) && testContext( context.parentNode ) || context\n\t);\n\treturn results;\n}\n\n// One-time assignments\n\n// Sort stability\nsupport.sortStable = expando.split(\"\").sort( sortOrder ).join(\"\") === expando;\n\n// Support: Chrome<14\n// Always assume duplicates if they aren't passed to the comparison function\nsupport.detectDuplicates = !!hasDuplicate;\n\n// Initialize against the default document\nsetDocument();\n\n// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)\n// Detached nodes confoundingly follow *each other*\nsupport.sortDetached = assert(function( div1 ) {\n\t// Should return 1, but returns 4 (following)\n\treturn div1.compareDocumentPosition( document.createElement(\"div\") ) & 1;\n});\n\n// Support: IE<8\n// Prevent attribute/property \"interpolation\"\n// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx\nif ( !assert(function( div ) {\n\tdiv.innerHTML = \"<a href='#'></a>\";\n\treturn div.firstChild.getAttribute(\"href\") === \"#\" ;\n}) ) {\n\taddHandle( \"type|href|height|width\", function( elem, name, isXML ) {\n\t\tif ( !isXML ) {\n\t\t\treturn elem.getAttribute( name, name.toLowerCase() === \"type\" ? 1 : 2 );\n\t\t}\n\t});\n}\n\n// Support: IE<9\n// Use defaultValue in place of getAttribute(\"value\")\nif ( !support.attributes || !assert(function( div ) {\n\tdiv.innerHTML = \"<input/>\";\n\tdiv.firstChild.setAttribute( \"value\", \"\" );\n\treturn div.firstChild.getAttribute( \"value\" ) === \"\";\n}) ) {\n\taddHandle( \"value\", function( elem, name, isXML ) {\n\t\tif ( !isXML && elem.nodeName.toLowerCase() === \"input\" ) {\n\t\t\treturn elem.defaultValue;\n\t\t}\n\t});\n}\n\n// Support: IE<9\n// Use getAttributeNode to fetch booleans when getAttribute lies\nif ( !assert(function( div ) {\n\treturn div.getAttribute(\"disabled\") == null;\n}) ) {\n\taddHandle( booleans, function( elem, name, isXML ) {\n\t\tvar val;\n\t\tif ( !isXML ) {\n\t\t\treturn elem[ name ] === true ? name.toLowerCase() :\n\t\t\t\t\t(val = elem.getAttributeNode( name )) && val.specified ?\n\t\t\t\t\tval.value :\n\t\t\t\tnull;\n\t\t}\n\t});\n}\n\nreturn Sizzle;\n\n})( window );\n\n\n\njQuery.find = Sizzle;\njQuery.expr = Sizzle.selectors;\njQuery.expr[\":\"] = jQuery.expr.pseudos;\njQuery.unique = Sizzle.uniqueSort;\njQuery.text = Sizzle.getText;\njQuery.isXMLDoc = Sizzle.isXML;\njQuery.contains = Sizzle.contains;\n\n\n\nvar rneedsContext = jQuery.expr.match.needsContext;\n\nvar rsingleTag = (/^<(\\w+)\\s*\\/?>(?:<\\/\\1>|)$/);\n\n\n\nvar risSimple = /^.[^:#\\[\\.,]*$/;\n\n// Implement the identical functionality for filter and not\nfunction winnow( elements, qualifier, not ) {\n\tif ( jQuery.isFunction( qualifier ) ) {\n\t\treturn jQuery.grep( elements, function( elem, i ) {\n\t\t\t/* jshint -W018 */\n\t\t\treturn !!qualifier.call( elem, i, elem ) !== not;\n\t\t});\n\n\t}\n\n\tif ( qualifier.nodeType ) {\n\t\treturn jQuery.grep( elements, function( elem ) {\n\t\t\treturn ( elem === qualifier ) !== not;\n\t\t});\n\n\t}\n\n\tif ( typeof qualifier === \"string\" ) {\n\t\tif ( risSimple.test( qualifier ) ) {\n\t\t\treturn jQuery.filter( qualifier, elements, not );\n\t\t}\n\n\t\tqualifier = jQuery.filter( qualifier, elements );\n\t}\n\n\treturn jQuery.grep( elements, function( elem ) {\n\t\treturn ( jQuery.inArray( elem, qualifier ) >= 0 ) !== not;\n\t});\n}\n\njQuery.filter = function( expr, elems, not ) {\n\tvar elem = elems[ 0 ];\n\n\tif ( not ) {\n\t\texpr = \":not(\" + expr + \")\";\n\t}\n\n\treturn elems.length === 1 && elem.nodeType === 1 ?\n\t\tjQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :\n\t\tjQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {\n\t\t\treturn elem.nodeType === 1;\n\t\t}));\n};\n\njQuery.fn.extend({\n\tfind: function( selector ) {\n\t\tvar i,\n\t\t\tret = [],\n\t\t\tself = this,\n\t\t\tlen = self.length;\n\n\t\tif ( typeof selector !== \"string\" ) {\n\t\t\treturn this.pushStack( jQuery( selector ).filter(function() {\n\t\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\t\tif ( jQuery.contains( self[ i ], this ) ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}) );\n\t\t}\n\n\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\tjQuery.find( selector, self[ i ], ret );\n\t\t}\n\n\t\t// Needed because $( selector, context ) becomes $( context ).find( selector )\n\t\tret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );\n\t\tret.selector = this.selector ? this.selector + \" \" + selector : selector;\n\t\treturn ret;\n\t},\n\tfilter: function( selector ) {\n\t\treturn this.pushStack( winnow(this, selector || [], false) );\n\t},\n\tnot: function( selector ) {\n\t\treturn this.pushStack( winnow(this, selector || [], true) );\n\t},\n\tis: function( selector ) {\n\t\treturn !!winnow(\n\t\t\tthis,\n\n\t\t\t// If this is a positional/relative selector, check membership in the returned set\n\t\t\t// so $(\"p:first\").is(\"p:last\") won't return true for a doc with two \"p\".\n\t\t\ttypeof selector === \"string\" && rneedsContext.test( selector ) ?\n\t\t\t\tjQuery( selector ) :\n\t\t\t\tselector || [],\n\t\t\tfalse\n\t\t).length;\n\t}\n});\n\n\n// Initialize a jQuery object\n\n\n// A central reference to the root jQuery(document)\nvar rootjQuery,\n\n\t// Use the correct document accordingly with window argument (sandbox)\n\tdocument = window.document,\n\n\t// A simple way to check for HTML strings\n\t// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)\n\t// Strict HTML recognition (#11290: must start with <)\n\trquickExpr = /^(?:\\s*(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,\n\n\tinit = jQuery.fn.init = function( selector, context ) {\n\t\tvar match, elem;\n\n\t\t// HANDLE: $(\"\"), $(null), $(undefined), $(false)\n\t\tif ( !selector ) {\n\t\t\treturn this;\n\t\t}\n\n\t\t// Handle HTML strings\n\t\tif ( typeof selector === \"string\" ) {\n\t\t\tif ( selector.charAt(0) === \"<\" && selector.charAt( selector.length - 1 ) === \">\" && selector.length >= 3 ) {\n\t\t\t\t// Assume that strings that start and end with <> are HTML and skip the regex check\n\t\t\t\tmatch = [ null, selector, null ];\n\n\t\t\t} else {\n\t\t\t\tmatch = rquickExpr.exec( selector );\n\t\t\t}\n\n\t\t\t// Match html or make sure no context is specified for #id\n\t\t\tif ( match && (match[1] || !context) ) {\n\n\t\t\t\t// HANDLE: $(html) -> $(array)\n\t\t\t\tif ( match[1] ) {\n\t\t\t\t\tcontext = context instanceof jQuery ? context[0] : context;\n\n\t\t\t\t\t// scripts is true for back-compat\n\t\t\t\t\t// Intentionally let the error be thrown if parseHTML is not present\n\t\t\t\t\tjQuery.merge( this, jQuery.parseHTML(\n\t\t\t\t\t\tmatch[1],\n\t\t\t\t\t\tcontext && context.nodeType ? context.ownerDocument || context : document,\n\t\t\t\t\t\ttrue\n\t\t\t\t\t) );\n\n\t\t\t\t\t// HANDLE: $(html, props)\n\t\t\t\t\tif ( rsingleTag.test( match[1] ) && jQuery.isPlainObject( context ) ) {\n\t\t\t\t\t\tfor ( match in context ) {\n\t\t\t\t\t\t\t// Properties of context are called as methods if possible\n\t\t\t\t\t\t\tif ( jQuery.isFunction( this[ match ] ) ) {\n\t\t\t\t\t\t\t\tthis[ match ]( context[ match ] );\n\n\t\t\t\t\t\t\t// ...and otherwise set as attributes\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tthis.attr( match, context[ match ] );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn this;\n\n\t\t\t\t// HANDLE: $(#id)\n\t\t\t\t} else {\n\t\t\t\t\telem = document.getElementById( match[2] );\n\n\t\t\t\t\t// Check parentNode to catch when Blackberry 4.6 returns\n\t\t\t\t\t// nodes that are no longer in the document #6963\n\t\t\t\t\tif ( elem && elem.parentNode ) {\n\t\t\t\t\t\t// Handle the case where IE and Opera return items\n\t\t\t\t\t\t// by name instead of ID\n\t\t\t\t\t\tif ( elem.id !== match[2] ) {\n\t\t\t\t\t\t\treturn rootjQuery.find( selector );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Otherwise, we inject the element directly into the jQuery object\n\t\t\t\t\t\tthis.length = 1;\n\t\t\t\t\t\tthis[0] = elem;\n\t\t\t\t\t}\n\n\t\t\t\t\tthis.context = document;\n\t\t\t\t\tthis.selector = selector;\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\n\t\t\t// HANDLE: $(expr, $(...))\n\t\t\t} else if ( !context || context.jquery ) {\n\t\t\t\treturn ( context || rootjQuery ).find( selector );\n\n\t\t\t// HANDLE: $(expr, context)\n\t\t\t// (which is just equivalent to: $(context).find(expr)\n\t\t\t} else {\n\t\t\t\treturn this.constructor( context ).find( selector );\n\t\t\t}\n\n\t\t// HANDLE: $(DOMElement)\n\t\t} else if ( selector.nodeType ) {\n\t\t\tthis.context = this[0] = selector;\n\t\t\tthis.length = 1;\n\t\t\treturn this;\n\n\t\t// HANDLE: $(function)\n\t\t// Shortcut for document ready\n\t\t} else if ( jQuery.isFunction( selector ) ) {\n\t\t\treturn typeof rootjQuery.ready !== \"undefined\" ?\n\t\t\t\trootjQuery.ready( selector ) :\n\t\t\t\t// Execute immediately if ready is not present\n\t\t\t\tselector( jQuery );\n\t\t}\n\n\t\tif ( selector.selector !== undefined ) {\n\t\t\tthis.selector = selector.selector;\n\t\t\tthis.context = selector.context;\n\t\t}\n\n\t\treturn jQuery.makeArray( selector, this );\n\t};\n\n// Give the init function the jQuery prototype for later instantiation\ninit.prototype = jQuery.fn;\n\n// Initialize central reference\nrootjQuery = jQuery( document );\n\n\nvar rparentsprev = /^(?:parents|prev(?:Until|All))/,\n\t// methods guaranteed to produce a unique set when starting from a unique set\n\tguaranteedUnique = {\n\t\tchildren: true,\n\t\tcontents: true,\n\t\tnext: true,\n\t\tprev: true\n\t};\n\njQuery.extend({\n\tdir: function( elem, dir, until ) {\n\t\tvar matched = [],\n\t\t\tcur = elem[ dir ];\n\n\t\twhile ( cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !jQuery( cur ).is( until )) ) {\n\t\t\tif ( cur.nodeType === 1 ) {\n\t\t\t\tmatched.push( cur );\n\t\t\t}\n\t\t\tcur = cur[dir];\n\t\t}\n\t\treturn matched;\n\t},\n\n\tsibling: function( n, elem ) {\n\t\tvar r = [];\n\n\t\tfor ( ; n; n = n.nextSibling ) {\n\t\t\tif ( n.nodeType === 1 && n !== elem ) {\n\t\t\t\tr.push( n );\n\t\t\t}\n\t\t}\n\n\t\treturn r;\n\t}\n});\n\njQuery.fn.extend({\n\thas: function( target ) {\n\t\tvar i,\n\t\t\ttargets = jQuery( target, this ),\n\t\t\tlen = targets.length;\n\n\t\treturn this.filter(function() {\n\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\tif ( jQuery.contains( this, targets[i] ) ) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t},\n\n\tclosest: function( selectors, context ) {\n\t\tvar cur,\n\t\t\ti = 0,\n\t\t\tl = this.length,\n\t\t\tmatched = [],\n\t\t\tpos = rneedsContext.test( selectors ) || typeof selectors !== \"string\" ?\n\t\t\t\tjQuery( selectors, context || this.context ) :\n\t\t\t\t0;\n\n\t\tfor ( ; i < l; i++ ) {\n\t\t\tfor ( cur = this[i]; cur && cur !== context; cur = cur.parentNode ) {\n\t\t\t\t// Always skip document fragments\n\t\t\t\tif ( cur.nodeType < 11 && (pos ?\n\t\t\t\t\tpos.index(cur) > -1 :\n\n\t\t\t\t\t// Don't pass non-elements to Sizzle\n\t\t\t\t\tcur.nodeType === 1 &&\n\t\t\t\t\t\tjQuery.find.matchesSelector(cur, selectors)) ) {\n\n\t\t\t\t\tmatched.push( cur );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn this.pushStack( matched.length > 1 ? jQuery.unique( matched ) : matched );\n\t},\n\n\t// Determine the position of an element within\n\t// the matched set of elements\n\tindex: function( elem ) {\n\n\t\t// No argument, return index in parent\n\t\tif ( !elem ) {\n\t\t\treturn ( this[0] && this[0].parentNode ) ? this.first().prevAll().length : -1;\n\t\t}\n\n\t\t// index in selector\n\t\tif ( typeof elem === \"string\" ) {\n\t\t\treturn jQuery.inArray( this[0], jQuery( elem ) );\n\t\t}\n\n\t\t// Locate the position of the desired element\n\t\treturn jQuery.inArray(\n\t\t\t// If it receives a jQuery object, the first element is used\n\t\t\telem.jquery ? elem[0] : elem, this );\n\t},\n\n\tadd: function( selector, context ) {\n\t\treturn this.pushStack(\n\t\t\tjQuery.unique(\n\t\t\t\tjQuery.merge( this.get(), jQuery( selector, context ) )\n\t\t\t)\n\t\t);\n\t},\n\n\taddBack: function( selector ) {\n\t\treturn this.add( selector == null ?\n\t\t\tthis.prevObject : this.prevObject.filter(selector)\n\t\t);\n\t}\n});\n\nfunction sibling( cur, dir ) {\n\tdo {\n\t\tcur = cur[ dir ];\n\t} while ( cur && cur.nodeType !== 1 );\n\n\treturn cur;\n}\n\njQuery.each({\n\tparent: function( elem ) {\n\t\tvar parent = elem.parentNode;\n\t\treturn parent && parent.nodeType !== 11 ? parent : null;\n\t},\n\tparents: function( elem ) {\n\t\treturn jQuery.dir( elem, \"parentNode\" );\n\t},\n\tparentsUntil: function( elem, i, until ) {\n\t\treturn jQuery.dir( elem, \"parentNode\", until );\n\t},\n\tnext: function( elem ) {\n\t\treturn sibling( elem, \"nextSibling\" );\n\t},\n\tprev: function( elem ) {\n\t\treturn sibling( elem, \"previousSibling\" );\n\t},\n\tnextAll: function( elem ) {\n\t\treturn jQuery.dir( elem, \"nextSibling\" );\n\t},\n\tprevAll: function( elem ) {\n\t\treturn jQuery.dir( elem, \"previousSibling\" );\n\t},\n\tnextUntil: function( elem, i, until ) {\n\t\treturn jQuery.dir( elem, \"nextSibling\", until );\n\t},\n\tprevUntil: function( elem, i, until ) {\n\t\treturn jQuery.dir( elem, \"previousSibling\", until );\n\t},\n\tsiblings: function( elem ) {\n\t\treturn jQuery.sibling( ( elem.parentNode || {} ).firstChild, elem );\n\t},\n\tchildren: function( elem ) {\n\t\treturn jQuery.sibling( elem.firstChild );\n\t},\n\tcontents: function( elem ) {\n\t\treturn jQuery.nodeName( elem, \"iframe\" ) ?\n\t\t\telem.contentDocument || elem.contentWindow.document :\n\t\t\tjQuery.merge( [], elem.childNodes );\n\t}\n}, function( name, fn ) {\n\tjQuery.fn[ name ] = function( until, selector ) {\n\t\tvar ret = jQuery.map( this, fn, until );\n\n\t\tif ( name.slice( -5 ) !== \"Until\" ) {\n\t\t\tselector = until;\n\t\t}\n\n\t\tif ( selector && typeof selector === \"string\" ) {\n\t\t\tret = jQuery.filter( selector, ret );\n\t\t}\n\n\t\tif ( this.length > 1 ) {\n\t\t\t// Remove duplicates\n\t\t\tif ( !guaranteedUnique[ name ] ) {\n\t\t\t\tret = jQuery.unique( ret );\n\t\t\t}\n\n\t\t\t// Reverse order for parents* and prev-derivatives\n\t\t\tif ( rparentsprev.test( name ) ) {\n\t\t\t\tret = ret.reverse();\n\t\t\t}\n\t\t}\n\n\t\treturn this.pushStack( ret );\n\t};\n});\nvar rnotwhite = (/\\S+/g);\n\n\n\n// String to Object options format cache\nvar optionsCache = {};\n\n// Convert String-formatted options into Object-formatted ones and store in cache\nfunction createOptions( options ) {\n\tvar object = optionsCache[ options ] = {};\n\tjQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {\n\t\tobject[ flag ] = true;\n\t});\n\treturn object;\n}\n\n/*\n * Create a callback list using the following parameters:\n *\n *\toptions: an optional list of space-separated options that will change how\n *\t\t\tthe callback list behaves or a more traditional option object\n *\n * By default a callback list will act like an event callback list and can be\n * \"fired\" multiple times.\n *\n * Possible options:\n *\n *\tonce:\t\t\twill ensure the callback list can only be fired once (like a Deferred)\n *\n *\tmemory:\t\t\twill keep track of previous values and will call any callback added\n *\t\t\t\t\tafter the list has been fired right away with the latest \"memorized\"\n *\t\t\t\t\tvalues (like a Deferred)\n *\n *\tunique:\t\t\twill ensure a callback can only be added once (no duplicate in the list)\n *\n *\tstopOnFalse:\tinterrupt callings when a callback returns false\n *\n */\njQuery.Callbacks = function( options ) {\n\n\t// Convert options from String-formatted to Object-formatted if needed\n\t// (we check in cache first)\n\toptions = typeof options === \"string\" ?\n\t\t( optionsCache[ options ] || createOptions( options ) ) :\n\t\tjQuery.extend( {}, options );\n\n\tvar // Flag to know if list is currently firing\n\t\tfiring,\n\t\t// Last fire value (for non-forgettable lists)\n\t\tmemory,\n\t\t// Flag to know if list was already fired\n\t\tfired,\n\t\t// End of the loop when firing\n\t\tfiringLength,\n\t\t// Index of currently firing callback (modified by remove if needed)\n\t\tfiringIndex,\n\t\t// First callback to fire (used internally by add and fireWith)\n\t\tfiringStart,\n\t\t// Actual callback list\n\t\tlist = [],\n\t\t// Stack of fire calls for repeatable lists\n\t\tstack = !options.once && [],\n\t\t// Fire callbacks\n\t\tfire = function( data ) {\n\t\t\tmemory = options.memory && data;\n\t\t\tfired = true;\n\t\t\tfiringIndex = firingStart || 0;\n\t\t\tfiringStart = 0;\n\t\t\tfiringLength = list.length;\n\t\t\tfiring = true;\n\t\t\tfor ( ; list && firingIndex < firingLength; firingIndex++ ) {\n\t\t\t\tif ( list[ firingIndex ].apply( data[ 0 ], data[ 1 ] ) === false && options.stopOnFalse ) {\n\t\t\t\t\tmemory = false; // To prevent further calls using add\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t\tfiring = false;\n\t\t\tif ( list ) {\n\t\t\t\tif ( stack ) {\n\t\t\t\t\tif ( stack.length ) {\n\t\t\t\t\t\tfire( stack.shift() );\n\t\t\t\t\t}\n\t\t\t\t} else if ( memory ) {\n\t\t\t\t\tlist = [];\n\t\t\t\t} else {\n\t\t\t\t\tself.disable();\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t// Actual Callbacks object\n\t\tself = {\n\t\t\t// Add a callback or a collection of callbacks to the list\n\t\t\tadd: function() {\n\t\t\t\tif ( list ) {\n\t\t\t\t\t// First, we save the current length\n\t\t\t\t\tvar start = list.length;\n\t\t\t\t\t(function add( args ) {\n\t\t\t\t\t\tjQuery.each( args, function( _, arg ) {\n\t\t\t\t\t\t\tvar type = jQuery.type( arg );\n\t\t\t\t\t\t\tif ( type === \"function\" ) {\n\t\t\t\t\t\t\t\tif ( !options.unique || !self.has( arg ) ) {\n\t\t\t\t\t\t\t\t\tlist.push( arg );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else if ( arg && arg.length && type !== \"string\" ) {\n\t\t\t\t\t\t\t\t// Inspect recursively\n\t\t\t\t\t\t\t\tadd( arg );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t})( arguments );\n\t\t\t\t\t// Do we need to add the callbacks to the\n\t\t\t\t\t// current firing batch?\n\t\t\t\t\tif ( firing ) {\n\t\t\t\t\t\tfiringLength = list.length;\n\t\t\t\t\t// With memory, if we're not firing then\n\t\t\t\t\t// we should call right away\n\t\t\t\t\t} else if ( memory ) {\n\t\t\t\t\t\tfiringStart = start;\n\t\t\t\t\t\tfire( memory );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t},\n\t\t\t// Remove a callback from the list\n\t\t\tremove: function() {\n\t\t\t\tif ( list ) {\n\t\t\t\t\tjQuery.each( arguments, function( _, arg ) {\n\t\t\t\t\t\tvar index;\n\t\t\t\t\t\twhile ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {\n\t\t\t\t\t\t\tlist.splice( index, 1 );\n\t\t\t\t\t\t\t// Handle firing indexes\n\t\t\t\t\t\t\tif ( firing ) {\n\t\t\t\t\t\t\t\tif ( index <= firingLength ) {\n\t\t\t\t\t\t\t\t\tfiringLength--;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif ( index <= firingIndex ) {\n\t\t\t\t\t\t\t\t\tfiringIndex--;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t},\n\t\t\t// Check if a given callback is in the list.\n\t\t\t// If no argument is given, return whether or not list has callbacks attached.\n\t\t\thas: function( fn ) {\n\t\t\t\treturn fn ? jQuery.inArray( fn, list ) > -1 : !!( list && list.length );\n\t\t\t},\n\t\t\t// Remove all callbacks from the list\n\t\t\tempty: function() {\n\t\t\t\tlist = [];\n\t\t\t\tfiringLength = 0;\n\t\t\t\treturn this;\n\t\t\t},\n\t\t\t// Have the list do nothing anymore\n\t\t\tdisable: function() {\n\t\t\t\tlist = stack = memory = undefined;\n\t\t\t\treturn this;\n\t\t\t},\n\t\t\t// Is it disabled?\n\t\t\tdisabled: function() {\n\t\t\t\treturn !list;\n\t\t\t},\n\t\t\t// Lock the list in its current state\n\t\t\tlock: function() {\n\t\t\t\tstack = undefined;\n\t\t\t\tif ( !memory ) {\n\t\t\t\t\tself.disable();\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t},\n\t\t\t// Is it locked?\n\t\t\tlocked: function() {\n\t\t\t\treturn !stack;\n\t\t\t},\n\t\t\t// Call all callbacks with the given context and arguments\n\t\t\tfireWith: function( context, args ) {\n\t\t\t\tif ( list && ( !fired || stack ) ) {\n\t\t\t\t\targs = args || [];\n\t\t\t\t\targs = [ context, args.slice ? args.slice() : args ];\n\t\t\t\t\tif ( firing ) {\n\t\t\t\t\t\tstack.push( args );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfire( args );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t},\n\t\t\t// Call all the callbacks with the given arguments\n\t\t\tfire: function() {\n\t\t\t\tself.fireWith( this, arguments );\n\t\t\t\treturn this;\n\t\t\t},\n\t\t\t// To know if the callbacks have already been called at least once\n\t\t\tfired: function() {\n\t\t\t\treturn !!fired;\n\t\t\t}\n\t\t};\n\n\treturn self;\n};\n\n\njQuery.extend({\n\n\tDeferred: function( func ) {\n\t\tvar tuples = [\n\t\t\t\t// action, add listener, listener list, final state\n\t\t\t\t[ \"resolve\", \"done\", jQuery.Callbacks(\"once memory\"), \"resolved\" ],\n\t\t\t\t[ \"reject\", \"fail\", jQuery.Callbacks(\"once memory\"), \"rejected\" ],\n\t\t\t\t[ \"notify\", \"progress\", jQuery.Callbacks(\"memory\") ]\n\t\t\t],\n\t\t\tstate = \"pending\",\n\t\t\tpromise = {\n\t\t\t\tstate: function() {\n\t\t\t\t\treturn state;\n\t\t\t\t},\n\t\t\t\talways: function() {\n\t\t\t\t\tdeferred.done( arguments ).fail( arguments );\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\t\t\t\tthen: function( /* fnDone, fnFail, fnProgress */ ) {\n\t\t\t\t\tvar fns = arguments;\n\t\t\t\t\treturn jQuery.Deferred(function( newDefer ) {\n\t\t\t\t\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\t\t\t\t\tvar fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];\n\t\t\t\t\t\t\t// deferred[ done | fail | progress ] for forwarding actions to newDefer\n\t\t\t\t\t\t\tdeferred[ tuple[1] ](function() {\n\t\t\t\t\t\t\t\tvar returned = fn && fn.apply( this, arguments );\n\t\t\t\t\t\t\t\tif ( returned && jQuery.isFunction( returned.promise ) ) {\n\t\t\t\t\t\t\t\t\treturned.promise()\n\t\t\t\t\t\t\t\t\t\t.done( newDefer.resolve )\n\t\t\t\t\t\t\t\t\t\t.fail( newDefer.reject )\n\t\t\t\t\t\t\t\t\t\t.progress( newDefer.notify );\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnewDefer[ tuple[ 0 ] + \"With\" ]( this === promise ? newDefer.promise() : this, fn ? [ returned ] : arguments );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\t\t\t\t\t\tfns = null;\n\t\t\t\t\t}).promise();\n\t\t\t\t},\n\t\t\t\t// Get a promise for this deferred\n\t\t\t\t// If obj is provided, the promise aspect is added to the object\n\t\t\t\tpromise: function( obj ) {\n\t\t\t\t\treturn obj != null ? jQuery.extend( obj, promise ) : promise;\n\t\t\t\t}\n\t\t\t},\n\t\t\tdeferred = {};\n\n\t\t// Keep pipe for back-compat\n\t\tpromise.pipe = promise.then;\n\n\t\t// Add list-specific methods\n\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\tvar list = tuple[ 2 ],\n\t\t\t\tstateString = tuple[ 3 ];\n\n\t\t\t// promise[ done | fail | progress ] = list.add\n\t\t\tpromise[ tuple[1] ] = list.add;\n\n\t\t\t// Handle state\n\t\t\tif ( stateString ) {\n\t\t\t\tlist.add(function() {\n\t\t\t\t\t// state = [ resolved | rejected ]\n\t\t\t\t\tstate = stateString;\n\n\t\t\t\t// [ reject_list | resolve_list ].disable; progress_list.lock\n\t\t\t\t}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );\n\t\t\t}\n\n\t\t\t// deferred[ resolve | reject | notify ]\n\t\t\tdeferred[ tuple[0] ] = function() {\n\t\t\t\tdeferred[ tuple[0] + \"With\" ]( this === deferred ? promise : this, arguments );\n\t\t\t\treturn this;\n\t\t\t};\n\t\t\tdeferred[ tuple[0] + \"With\" ] = list.fireWith;\n\t\t});\n\n\t\t// Make the deferred a promise\n\t\tpromise.promise( deferred );\n\n\t\t// Call given func if any\n\t\tif ( func ) {\n\t\t\tfunc.call( deferred, deferred );\n\t\t}\n\n\t\t// All done!\n\t\treturn deferred;\n\t},\n\n\t// Deferred helper\n\twhen: function( subordinate /* , ..., subordinateN */ ) {\n\t\tvar i = 0,\n\t\t\tresolveValues = slice.call( arguments ),\n\t\t\tlength = resolveValues.length,\n\n\t\t\t// the count of uncompleted subordinates\n\t\t\tremaining = length !== 1 || ( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,\n\n\t\t\t// the master Deferred. If resolveValues consist of only a single Deferred, just use that.\n\t\t\tdeferred = remaining === 1 ? subordinate : jQuery.Deferred(),\n\n\t\t\t// Update function for both resolve and progress values\n\t\t\tupdateFunc = function( i, contexts, values ) {\n\t\t\t\treturn function( value ) {\n\t\t\t\t\tcontexts[ i ] = this;\n\t\t\t\t\tvalues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;\n\t\t\t\t\tif ( values === progressValues ) {\n\t\t\t\t\t\tdeferred.notifyWith( contexts, values );\n\n\t\t\t\t\t} else if ( !(--remaining) ) {\n\t\t\t\t\t\tdeferred.resolveWith( contexts, values );\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tprogressValues, progressContexts, resolveContexts;\n\n\t\t// add listeners to Deferred subordinates; treat others as resolved\n\t\tif ( length > 1 ) {\n\t\t\tprogressValues = new Array( length );\n\t\t\tprogressContexts = new Array( length );\n\t\t\tresolveContexts = new Array( length );\n\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\tif ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {\n\t\t\t\t\tresolveValues[ i ].promise()\n\t\t\t\t\t\t.done( updateFunc( i, resolveContexts, resolveValues ) )\n\t\t\t\t\t\t.fail( deferred.reject )\n\t\t\t\t\t\t.progress( updateFunc( i, progressContexts, progressValues ) );\n\t\t\t\t} else {\n\t\t\t\t\t--remaining;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// if we're not waiting on anything, resolve the master\n\t\tif ( !remaining ) {\n\t\t\tdeferred.resolveWith( resolveContexts, resolveValues );\n\t\t}\n\n\t\treturn deferred.promise();\n\t}\n});\n\n\n// The deferred used on DOM ready\nvar readyList;\n\njQuery.fn.ready = function( fn ) {\n\t// Add the callback\n\tjQuery.ready.promise().done( fn );\n\n\treturn this;\n};\n\njQuery.extend({\n\t// Is the DOM ready to be used? Set to true once it occurs.\n\tisReady: false,\n\n\t// A counter to track how many items to wait for before\n\t// the ready event fires. See #6781\n\treadyWait: 1,\n\n\t// Hold (or release) the ready event\n\tholdReady: function( hold ) {\n\t\tif ( hold ) {\n\t\t\tjQuery.readyWait++;\n\t\t} else {\n\t\t\tjQuery.ready( true );\n\t\t}\n\t},\n\n\t// Handle when the DOM is ready\n\tready: function( wait ) {\n\n\t\t// Abort if there are pending holds or we're already ready\n\t\tif ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).\n\t\tif ( !document.body ) {\n\t\t\treturn setTimeout( jQuery.ready );\n\t\t}\n\n\t\t// Remember that the DOM is ready\n\t\tjQuery.isReady = true;\n\n\t\t// If a normal DOM Ready event fired, decrement, and wait if need be\n\t\tif ( wait !== true && --jQuery.readyWait > 0 ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// If there are functions bound, to execute\n\t\treadyList.resolveWith( document, [ jQuery ] );\n\n\t\t// Trigger any bound ready events\n\t\tif ( jQuery.fn.trigger ) {\n\t\t\tjQuery( document ).trigger(\"ready\").off(\"ready\");\n\t\t}\n\t}\n});\n\n/**\n * Clean-up method for dom ready events\n */\nfunction detach() {\n\tif ( document.addEventListener ) {\n\t\tdocument.removeEventListener( \"DOMContentLoaded\", completed, false );\n\t\twindow.removeEventListener( \"load\", completed, false );\n\n\t} else {\n\t\tdocument.detachEvent( \"onreadystatechange\", completed );\n\t\twindow.detachEvent( \"onload\", completed );\n\t}\n}\n\n/**\n * The ready event handler and self cleanup method\n */\nfunction completed() {\n\t// readyState === \"complete\" is good enough for us to call the dom ready in oldIE\n\tif ( document.addEventListener || event.type === \"load\" || document.readyState === \"complete\" ) {\n\t\tdetach();\n\t\tjQuery.ready();\n\t}\n}\n\njQuery.ready.promise = function( obj ) {\n\tif ( !readyList ) {\n\n\t\treadyList = jQuery.Deferred();\n\n\t\t// Catch cases where $(document).ready() is called after the browser event has already occurred.\n\t\t// we once tried to use readyState \"interactive\" here, but it caused issues like the one\n\t\t// discovered by ChrisS here: http://bugs.jquery.com/ticket/12282#comment:15\n\t\tif ( document.readyState === \"complete\" ) {\n\t\t\t// Handle it asynchronously to allow scripts the opportunity to delay ready\n\t\t\tsetTimeout( jQuery.ready );\n\n\t\t// Standards-based browsers support DOMContentLoaded\n\t\t} else if ( document.addEventListener ) {\n\t\t\t// Use the handy event callback\n\t\t\tdocument.addEventListener( \"DOMContentLoaded\", completed, false );\n\n\t\t\t// A fallback to window.onload, that will always work\n\t\t\twindow.addEventListener( \"load\", completed, false );\n\n\t\t// If IE event model is used\n\t\t} else {\n\t\t\t// Ensure firing before onload, maybe late but safe also for iframes\n\t\t\tdocument.attachEvent( \"onreadystatechange\", completed );\n\n\t\t\t// A fallback to window.onload, that will always work\n\t\t\twindow.attachEvent( \"onload\", completed );\n\n\t\t\t// If IE and not a frame\n\t\t\t// continually check to see if the document is ready\n\t\t\tvar top = false;\n\n\t\t\ttry {\n\t\t\t\ttop = window.frameElement == null && document.documentElement;\n\t\t\t} catch(e) {}\n\n\t\t\tif ( top && top.doScroll ) {\n\t\t\t\t(function doScrollCheck() {\n\t\t\t\t\tif ( !jQuery.isReady ) {\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Use the trick by Diego Perini\n\t\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\t\ttop.doScroll(\"left\");\n\t\t\t\t\t\t} catch(e) {\n\t\t\t\t\t\t\treturn setTimeout( doScrollCheck, 50 );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// detach all dom ready events\n\t\t\t\t\t\tdetach();\n\n\t\t\t\t\t\t// and execute any waiting functions\n\t\t\t\t\t\tjQuery.ready();\n\t\t\t\t\t}\n\t\t\t\t})();\n\t\t\t}\n\t\t}\n\t}\n\treturn readyList.promise( obj );\n};\n\n\nvar strundefined = typeof undefined;\n\n\n\n// Support: IE<9\n// Iteration over object's inherited properties before its own\nvar i;\nfor ( i in jQuery( support ) ) {\n\tbreak;\n}\nsupport.ownLast = i !== \"0\";\n\n// Note: most support tests are defined in their respective modules.\n// false until the test is run\nsupport.inlineBlockNeedsLayout = false;\n\njQuery(function() {\n\t// We need to execute this one support test ASAP because we need to know\n\t// if body.style.zoom needs to be set.\n\n\tvar container, div,\n\t\tbody = document.getElementsByTagName(\"body\")[0];\n\n\tif ( !body ) {\n\t\t// Return for frameset docs that don't have a body\n\t\treturn;\n\t}\n\n\t// Setup\n\tcontainer = document.createElement( \"div\" );\n\tcontainer.style.cssText = \"border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px\";\n\n\tdiv = document.createElement( \"div\" );\n\tbody.appendChild( container ).appendChild( div );\n\n\tif ( typeof div.style.zoom !== strundefined ) {\n\t\t// Support: IE<8\n\t\t// Check if natively block-level elements act like inline-block\n\t\t// elements when setting their display to 'inline' and giving\n\t\t// them layout\n\t\tdiv.style.cssText = \"border:0;margin:0;width:1px;padding:1px;display:inline;zoom:1\";\n\n\t\tif ( (support.inlineBlockNeedsLayout = ( div.offsetWidth === 3 )) ) {\n\t\t\t// Prevent IE 6 from affecting layout for positioned elements #11048\n\t\t\t// Prevent IE from shrinking the body in IE 7 mode #12869\n\t\t\t// Support: IE<8\n\t\t\tbody.style.zoom = 1;\n\t\t}\n\t}\n\n\tbody.removeChild( container );\n\n\t// Null elements to avoid leaks in IE\n\tcontainer = div = null;\n});\n\n\n\n\n(function() {\n\tvar div = document.createElement( \"div\" );\n\n\t// Execute the test only if not already executed in another module.\n\tif (support.deleteExpando == null) {\n\t\t// Support: IE<9\n\t\tsupport.deleteExpando = true;\n\t\ttry {\n\t\t\tdelete div.test;\n\t\t} catch( e ) {\n\t\t\tsupport.deleteExpando = false;\n\t\t}\n\t}\n\n\t// Null elements to avoid leaks in IE.\n\tdiv = null;\n})();\n\n\n/**\n * Determines whether an object can have data\n */\njQuery.acceptData = function( elem ) {\n\tvar noData = jQuery.noData[ (elem.nodeName + \" \").toLowerCase() ],\n\t\tnodeType = +elem.nodeType || 1;\n\n\t// Do not set data on non-element DOM nodes because it will not be cleared (#8335).\n\treturn nodeType !== 1 && nodeType !== 9 ?\n\t\tfalse :\n\n\t\t// Nodes accept data unless otherwise specified; rejection can be conditional\n\t\t!noData || noData !== true && elem.getAttribute(\"classid\") === noData;\n};\n\n\nvar rbrace = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/,\n\trmultiDash = /([A-Z])/g;\n\nfunction dataAttr( elem, key, data ) {\n\t// If nothing was found internally, try to fetch any\n\t// data from the HTML5 data-* attribute\n\tif ( data === undefined && elem.nodeType === 1 ) {\n\n\t\tvar name = \"data-\" + key.replace( rmultiDash, \"-$1\" ).toLowerCase();\n\n\t\tdata = elem.getAttribute( name );\n\n\t\tif ( typeof data === \"string\" ) {\n\t\t\ttry {\n\t\t\t\tdata = data === \"true\" ? true :\n\t\t\t\t\tdata === \"false\" ? false :\n\t\t\t\t\tdata === \"null\" ? null :\n\t\t\t\t\t// Only convert to a number if it doesn't change the string\n\t\t\t\t\t+data + \"\" === data ? +data :\n\t\t\t\t\trbrace.test( data ) ? jQuery.parseJSON( data ) :\n\t\t\t\t\tdata;\n\t\t\t} catch( e ) {}\n\n\t\t\t// Make sure we set the data so it isn't changed later\n\t\t\tjQuery.data( elem, key, data );\n\n\t\t} else {\n\t\t\tdata = undefined;\n\t\t}\n\t}\n\n\treturn data;\n}\n\n// checks a cache object for emptiness\nfunction isEmptyDataObject( obj ) {\n\tvar name;\n\tfor ( name in obj ) {\n\n\t\t// if the public data object is empty, the private is still empty\n\t\tif ( name === \"data\" && jQuery.isEmptyObject( obj[name] ) ) {\n\t\t\tcontinue;\n\t\t}\n\t\tif ( name !== \"toJSON\" ) {\n\t\t\treturn false;\n\t\t}\n\t}\n\n\treturn true;\n}\n\nfunction internalData( elem, name, data, pvt /* Internal Use Only */ ) {\n\tif ( !jQuery.acceptData( elem ) ) {\n\t\treturn;\n\t}\n\n\tvar ret, thisCache,\n\t\tinternalKey = jQuery.expando,\n\n\t\t// We have to handle DOM nodes and JS objects differently because IE6-7\n\t\t// can't GC object references properly across the DOM-JS boundary\n\t\tisNode = elem.nodeType,\n\n\t\t// Only DOM nodes need the global jQuery cache; JS object data is\n\t\t// attached directly to the object so GC can occur automatically\n\t\tcache = isNode ? jQuery.cache : elem,\n\n\t\t// Only defining an ID for JS objects if its cache already exists allows\n\t\t// the code to shortcut on the same path as a DOM node with no cache\n\t\tid = isNode ? elem[ internalKey ] : elem[ internalKey ] && internalKey;\n\n\t// Avoid doing any more work than we need to when trying to get data on an\n\t// object that has no data at all\n\tif ( (!id || !cache[id] || (!pvt && !cache[id].data)) && data === undefined && typeof name === \"string\" ) {\n\t\treturn;\n\t}\n\n\tif ( !id ) {\n\t\t// Only DOM nodes need a new unique ID for each element since their data\n\t\t// ends up in the global cache\n\t\tif ( isNode ) {\n\t\t\tid = elem[ internalKey ] = deletedIds.pop() || jQuery.guid++;\n\t\t} else {\n\t\t\tid = internalKey;\n\t\t}\n\t}\n\n\tif ( !cache[ id ] ) {\n\t\t// Avoid exposing jQuery metadata on plain JS objects when the object\n\t\t// is serialized using JSON.stringify\n\t\tcache[ id ] = isNode ? {} : { toJSON: jQuery.noop };\n\t}\n\n\t// An object can be passed to jQuery.data instead of a key/value pair; this gets\n\t// shallow copied over onto the existing cache\n\tif ( typeof name === \"object\" || typeof name === \"function\" ) {\n\t\tif ( pvt ) {\n\t\t\tcache[ id ] = jQuery.extend( cache[ id ], name );\n\t\t} else {\n\t\t\tcache[ id ].data = jQuery.extend( cache[ id ].data, name );\n\t\t}\n\t}\n\n\tthisCache = cache[ id ];\n\n\t// jQuery data() is stored in a separate object inside the object's internal data\n\t// cache in order to avoid key collisions between internal data and user-defined\n\t// data.\n\tif ( !pvt ) {\n\t\tif ( !thisCache.data ) {\n\t\t\tthisCache.data = {};\n\t\t}\n\n\t\tthisCache = thisCache.data;\n\t}\n\n\tif ( data !== undefined ) {\n\t\tthisCache[ jQuery.camelCase( name ) ] = data;\n\t}\n\n\t// Check for both converted-to-camel and non-converted data property names\n\t// If a data property was specified\n\tif ( typeof name === \"string\" ) {\n\n\t\t// First Try to find as-is property data\n\t\tret = thisCache[ name ];\n\n\t\t// Test for null|undefined property data\n\t\tif ( ret == null ) {\n\n\t\t\t// Try to find the camelCased property\n\t\t\tret = thisCache[ jQuery.camelCase( name ) ];\n\t\t}\n\t} else {\n\t\tret = thisCache;\n\t}\n\n\treturn ret;\n}\n\nfunction internalRemoveData( elem, name, pvt ) {\n\tif ( !jQuery.acceptData( elem ) ) {\n\t\treturn;\n\t}\n\n\tvar thisCache, i,\n\t\tisNode = elem.nodeType,\n\n\t\t// See jQuery.data for more information\n\t\tcache = isNode ? jQuery.cache : elem,\n\t\tid = isNode ? elem[ jQuery.expando ] : jQuery.expando;\n\n\t// If there is already no cache entry for this object, there is no\n\t// purpose in continuing\n\tif ( !cache[ id ] ) {\n\t\treturn;\n\t}\n\n\tif ( name ) {\n\n\t\tthisCache = pvt ? cache[ id ] : cache[ id ].data;\n\n\t\tif ( thisCache ) {\n\n\t\t\t// Support array or space separated string names for data keys\n\t\t\tif ( !jQuery.isArray( name ) ) {\n\n\t\t\t\t// try the string as a key before any manipulation\n\t\t\t\tif ( name in thisCache ) {\n\t\t\t\t\tname = [ name ];\n\t\t\t\t} else {\n\n\t\t\t\t\t// split the camel cased version by spaces unless a key with the spaces exists\n\t\t\t\t\tname = jQuery.camelCase( name );\n\t\t\t\t\tif ( name in thisCache ) {\n\t\t\t\t\t\tname = [ name ];\n\t\t\t\t\t} else {\n\t\t\t\t\t\tname = name.split(\" \");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// If \"name\" is an array of keys...\n\t\t\t\t// When data is initially created, via (\"key\", \"val\") signature,\n\t\t\t\t// keys will be converted to camelCase.\n\t\t\t\t// Since there is no way to tell _how_ a key was added, remove\n\t\t\t\t// both plain key and camelCase key. #12786\n\t\t\t\t// This will only penalize the array argument path.\n\t\t\t\tname = name.concat( jQuery.map( name, jQuery.camelCase ) );\n\t\t\t}\n\n\t\t\ti = name.length;\n\t\t\twhile ( i-- ) {\n\t\t\t\tdelete thisCache[ name[i] ];\n\t\t\t}\n\n\t\t\t// If there is no data left in the cache, we want to continue\n\t\t\t// and let the cache object itself get destroyed\n\t\t\tif ( pvt ? !isEmptyDataObject(thisCache) : !jQuery.isEmptyObject(thisCache) ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\t}\n\n\t// See jQuery.data for more information\n\tif ( !pvt ) {\n\t\tdelete cache[ id ].data;\n\n\t\t// Don't destroy the parent cache unless the internal data object\n\t\t// had been the only thing left in it\n\t\tif ( !isEmptyDataObject( cache[ id ] ) ) {\n\t\t\treturn;\n\t\t}\n\t}\n\n\t// Destroy the cache\n\tif ( isNode ) {\n\t\tjQuery.cleanData( [ elem ], true );\n\n\t// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)\n\t/* jshint eqeqeq: false */\n\t} else if ( support.deleteExpando || cache != cache.window ) {\n\t\t/* jshint eqeqeq: true */\n\t\tdelete cache[ id ];\n\n\t// When all else fails, null\n\t} else {\n\t\tcache[ id ] = null;\n\t}\n}\n\njQuery.extend({\n\tcache: {},\n\n\t// The following elements (space-suffixed to avoid Object.prototype collisions)\n\t// throw uncatchable exceptions if you attempt to set expando properties\n\tnoData: {\n\t\t\"applet \": true,\n\t\t\"embed \": true,\n\t\t// ...but Flash objects (which have this classid) *can* handle expandos\n\t\t\"object \": \"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"\n\t},\n\n\thasData: function( elem ) {\n\t\telem = elem.nodeType ? jQuery.cache[ elem[jQuery.expando] ] : elem[ jQuery.expando ];\n\t\treturn !!elem && !isEmptyDataObject( elem );\n\t},\n\n\tdata: function( elem, name, data ) {\n\t\treturn internalData( elem, name, data );\n\t},\n\n\tremoveData: function( elem, name ) {\n\t\treturn internalRemoveData( elem, name );\n\t},\n\n\t// For internal use only.\n\t_data: function( elem, name, data ) {\n\t\treturn internalData( elem, name, data, true );\n\t},\n\n\t_removeData: function( elem, name ) {\n\t\treturn internalRemoveData( elem, name, true );\n\t}\n});\n\njQuery.fn.extend({\n\tdata: function( key, value ) {\n\t\tvar i, name, data,\n\t\t\telem = this[0],\n\t\t\tattrs = elem && elem.attributes;\n\n\t\t// Special expections of .data basically thwart jQuery.access,\n\t\t// so implement the relevant behavior ourselves\n\n\t\t// Gets all values\n\t\tif ( key === undefined ) {\n\t\t\tif ( this.length ) {\n\t\t\t\tdata = jQuery.data( elem );\n\n\t\t\t\tif ( elem.nodeType === 1 && !jQuery._data( elem, \"parsedAttrs\" ) ) {\n\t\t\t\t\ti = attrs.length;\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\tname = attrs[i].name;\n\n\t\t\t\t\t\tif ( name.indexOf(\"data-\") === 0 ) {\n\t\t\t\t\t\t\tname = jQuery.camelCase( name.slice(5) );\n\n\t\t\t\t\t\t\tdataAttr( elem, name, data[ name ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tjQuery._data( elem, \"parsedAttrs\", true );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn data;\n\t\t}\n\n\t\t// Sets multiple values\n\t\tif ( typeof key === \"object\" ) {\n\t\t\treturn this.each(function() {\n\t\t\t\tjQuery.data( this, key );\n\t\t\t});\n\t\t}\n\n\t\treturn arguments.length > 1 ?\n\n\t\t\t// Sets one value\n\t\t\tthis.each(function() {\n\t\t\t\tjQuery.data( this, key, value );\n\t\t\t}) :\n\n\t\t\t// Gets one value\n\t\t\t// Try to fetch any internally stored data first\n\t\t\telem ? dataAttr( elem, key, jQuery.data( elem, key ) ) : undefined;\n\t},\n\n\tremoveData: function( key ) {\n\t\treturn this.each(function() {\n\t\t\tjQuery.removeData( this, key );\n\t\t});\n\t}\n});\n\n\njQuery.extend({\n\tqueue: function( elem, type, data ) {\n\t\tvar queue;\n\n\t\tif ( elem ) {\n\t\t\ttype = ( type || \"fx\" ) + \"queue\";\n\t\t\tqueue = jQuery._data( elem, type );\n\n\t\t\t// Speed up dequeue by getting out quickly if this is just a lookup\n\t\t\tif ( data ) {\n\t\t\t\tif ( !queue || jQuery.isArray(data) ) {\n\t\t\t\t\tqueue = jQuery._data( elem, type, jQuery.makeArray(data) );\n\t\t\t\t} else {\n\t\t\t\t\tqueue.push( data );\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn queue || [];\n\t\t}\n\t},\n\n\tdequeue: function( elem, type ) {\n\t\ttype = type || \"fx\";\n\n\t\tvar queue = jQuery.queue( elem, type ),\n\t\t\tstartLength = queue.length,\n\t\t\tfn = queue.shift(),\n\t\t\thooks = jQuery._queueHooks( elem, type ),\n\t\t\tnext = function() {\n\t\t\t\tjQuery.dequeue( elem, type );\n\t\t\t};\n\n\t\t// If the fx queue is dequeued, always remove the progress sentinel\n\t\tif ( fn === \"inprogress\" ) {\n\t\t\tfn = queue.shift();\n\t\t\tstartLength--;\n\t\t}\n\n\t\tif ( fn ) {\n\n\t\t\t// Add a progress sentinel to prevent the fx queue from being\n\t\t\t// automatically dequeued\n\t\t\tif ( type === \"fx\" ) {\n\t\t\t\tqueue.unshift( \"inprogress\" );\n\t\t\t}\n\n\t\t\t// clear up the last queue stop function\n\t\t\tdelete hooks.stop;\n\t\t\tfn.call( elem, next, hooks );\n\t\t}\n\n\t\tif ( !startLength && hooks ) {\n\t\t\thooks.empty.fire();\n\t\t}\n\t},\n\n\t// not intended for public consumption - generates a queueHooks object, or returns the current one\n\t_queueHooks: function( elem, type ) {\n\t\tvar key = type + \"queueHooks\";\n\t\treturn jQuery._data( elem, key ) || jQuery._data( elem, key, {\n\t\t\tempty: jQuery.Callbacks(\"once memory\").add(function() {\n\t\t\t\tjQuery._removeData( elem, type + \"queue\" );\n\t\t\t\tjQuery._removeData( elem, key );\n\t\t\t})\n\t\t});\n\t}\n});\n\njQuery.fn.extend({\n\tqueue: function( type, data ) {\n\t\tvar setter = 2;\n\n\t\tif ( typeof type !== \"string\" ) {\n\t\t\tdata = type;\n\t\t\ttype = \"fx\";\n\t\t\tsetter--;\n\t\t}\n\n\t\tif ( arguments.length < setter ) {\n\t\t\treturn jQuery.queue( this[0], type );\n\t\t}\n\n\t\treturn data === undefined ?\n\t\t\tthis :\n\t\t\tthis.each(function() {\n\t\t\t\tvar queue = jQuery.queue( this, type, data );\n\n\t\t\t\t// ensure a hooks for this queue\n\t\t\t\tjQuery._queueHooks( this, type );\n\n\t\t\t\tif ( type === \"fx\" && queue[0] !== \"inprogress\" ) {\n\t\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t\t}\n\t\t\t});\n\t},\n\tdequeue: function( type ) {\n\t\treturn this.each(function() {\n\t\t\tjQuery.dequeue( this, type );\n\t\t});\n\t},\n\tclearQueue: function( type ) {\n\t\treturn this.queue( type || \"fx\", [] );\n\t},\n\t// Get a promise resolved when queues of a certain type\n\t// are emptied (fx is the type by default)\n\tpromise: function( type, obj ) {\n\t\tvar tmp,\n\t\t\tcount = 1,\n\t\t\tdefer = jQuery.Deferred(),\n\t\t\telements = this,\n\t\t\ti = this.length,\n\t\t\tresolve = function() {\n\t\t\t\tif ( !( --count ) ) {\n\t\t\t\t\tdefer.resolveWith( elements, [ elements ] );\n\t\t\t\t}\n\t\t\t};\n\n\t\tif ( typeof type !== \"string\" ) {\n\t\t\tobj = type;\n\t\t\ttype = undefined;\n\t\t}\n\t\ttype = type || \"fx\";\n\n\t\twhile ( i-- ) {\n\t\t\ttmp = jQuery._data( elements[ i ], type + \"queueHooks\" );\n\t\t\tif ( tmp && tmp.empty ) {\n\t\t\t\tcount++;\n\t\t\t\ttmp.empty.add( resolve );\n\t\t\t}\n\t\t}\n\t\tresolve();\n\t\treturn defer.promise( obj );\n\t}\n});\nvar pnum = (/[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/).source;\n\nvar cssExpand = [ \"Top\", \"Right\", \"Bottom\", \"Left\" ];\n\nvar isHidden = function( elem, el ) {\n\t\t// isHidden might be called from jQuery#filter function;\n\t\t// in that case, element will be second argument\n\t\telem = el || elem;\n\t\treturn jQuery.css( elem, \"display\" ) === \"none\" || !jQuery.contains( elem.ownerDocument, elem );\n\t};\n\n\n\n// Multifunctional method to get and set values of a collection\n// The value/s can optionally be executed if it's a function\nvar access = jQuery.access = function( elems, fn, key, value, chainable, emptyGet, raw ) {\n\tvar i = 0,\n\t\tlength = elems.length,\n\t\tbulk = key == null;\n\n\t// Sets many values\n\tif ( jQuery.type( key ) === \"object\" ) {\n\t\tchainable = true;\n\t\tfor ( i in key ) {\n\t\t\tjQuery.access( elems, fn, i, key[i], true, emptyGet, raw );\n\t\t}\n\n\t// Sets one value\n\t} else if ( value !== undefined ) {\n\t\tchainable = true;\n\n\t\tif ( !jQuery.isFunction( value ) ) {\n\t\t\traw = true;\n\t\t}\n\n\t\tif ( bulk ) {\n\t\t\t// Bulk operations run against the entire set\n\t\t\tif ( raw ) {\n\t\t\t\tfn.call( elems, value );\n\t\t\t\tfn = null;\n\n\t\t\t// ...except when executing function values\n\t\t\t} else {\n\t\t\t\tbulk = fn;\n\t\t\t\tfn = function( elem, key, value ) {\n\t\t\t\t\treturn bulk.call( jQuery( elem ), value );\n\t\t\t\t};\n\t\t\t}\n\t\t}\n\n\t\tif ( fn ) {\n\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\tfn( elems[i], key, raw ? value : value.call( elems[i], i, fn( elems[i], key ) ) );\n\t\t\t}\n\t\t}\n\t}\n\n\treturn chainable ?\n\t\telems :\n\n\t\t// Gets\n\t\tbulk ?\n\t\t\tfn.call( elems ) :\n\t\t\tlength ? fn( elems[0], key ) : emptyGet;\n};\nvar rcheckableType = (/^(?:checkbox|radio)$/i);\n\n\n\n(function() {\n\tvar fragment = document.createDocumentFragment(),\n\t\tdiv = document.createElement(\"div\"),\n\t\tinput = document.createElement(\"input\");\n\n\t// Setup\n\tdiv.setAttribute( \"className\", \"t\" );\n\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a>\";\n\n\t// IE strips leading whitespace when .innerHTML is used\n\tsupport.leadingWhitespace = div.firstChild.nodeType === 3;\n\n\t// Make sure that tbody elements aren't automatically inserted\n\t// IE will insert them into empty tables\n\tsupport.tbody = !div.getElementsByTagName( \"tbody\" ).length;\n\n\t// Make sure that link elements get serialized correctly by innerHTML\n\t// This requires a wrapper element in IE\n\tsupport.htmlSerialize = !!div.getElementsByTagName( \"link\" ).length;\n\n\t// Makes sure cloning an html5 element does not cause problems\n\t// Where outerHTML is undefined, this still works\n\tsupport.html5Clone =\n\t\tdocument.createElement( \"nav\" ).cloneNode( true ).outerHTML !== \"<:nav></:nav>\";\n\n\t// Check if a disconnected checkbox will retain its checked\n\t// value of true after appended to the DOM (IE6/7)\n\tinput.type = \"checkbox\";\n\tinput.checked = true;\n\tfragment.appendChild( input );\n\tsupport.appendChecked = input.checked;\n\n\t// Make sure textarea (and checkbox) defaultValue is properly cloned\n\t// Support: IE6-IE11+\n\tdiv.innerHTML = \"<textarea>x</textarea>\";\n\tsupport.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;\n\n\t// #11217 - WebKit loses check when the name is after the checked attribute\n\tfragment.appendChild( div );\n\tdiv.innerHTML = \"<input type='radio' checked='checked' name='t'/>\";\n\n\t// Support: Safari 5.1, iOS 5.1, Android 4.x, Android 2.3\n\t// old WebKit doesn't clone checked state correctly in fragments\n\tsupport.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;\n\n\t// Support: IE<9\n\t// Opera does not clone events (and typeof div.attachEvent === undefined).\n\t// IE9-10 clones events bound via attachEvent, but they don't trigger with .click()\n\tsupport.noCloneEvent = true;\n\tif ( div.attachEvent ) {\n\t\tdiv.attachEvent( \"onclick\", function() {\n\t\t\tsupport.noCloneEvent = false;\n\t\t});\n\n\t\tdiv.cloneNode( true ).click();\n\t}\n\n\t// Execute the test only if not already executed in another module.\n\tif (support.deleteExpando == null) {\n\t\t// Support: IE<9\n\t\tsupport.deleteExpando = true;\n\t\ttry {\n\t\t\tdelete div.test;\n\t\t} catch( e ) {\n\t\t\tsupport.deleteExpando = false;\n\t\t}\n\t}\n\n\t// Null elements to avoid leaks in IE.\n\tfragment = div = input = null;\n})();\n\n\n(function() {\n\tvar i, eventName,\n\t\tdiv = document.createElement( \"div\" );\n\n\t// Support: IE<9 (lack submit/change bubble), Firefox 23+ (lack focusin event)\n\tfor ( i in { submit: true, change: true, focusin: true }) {\n\t\teventName = \"on\" + i;\n\n\t\tif ( !(support[ i + \"Bubbles\" ] = eventName in window) ) {\n\t\t\t// Beware of CSP restrictions (https://developer.mozilla.org/en/Security/CSP)\n\t\t\tdiv.setAttribute( eventName, \"t\" );\n\t\t\tsupport[ i + \"Bubbles\" ] = div.attributes[ eventName ].expando === false;\n\t\t}\n\t}\n\n\t// Null elements to avoid leaks in IE.\n\tdiv = null;\n})();\n\n\nvar rformElems = /^(?:input|select|textarea)$/i,\n\trkeyEvent = /^key/,\n\trmouseEvent = /^(?:mouse|contextmenu)|click/,\n\trfocusMorph = /^(?:focusinfocus|focusoutblur)$/,\n\trtypenamespace = /^([^.]*)(?:\\.(.+)|)$/;\n\nfunction returnTrue() {\n\treturn true;\n}\n\nfunction returnFalse() {\n\treturn false;\n}\n\nfunction safeActiveElement() {\n\ttry {\n\t\treturn document.activeElement;\n\t} catch ( err ) { }\n}\n\n/*\n * Helper functions for managing events -- not part of the public interface.\n * Props to Dean Edwards' addEvent library for many of the ideas.\n */\njQuery.event = {\n\n\tglobal: {},\n\n\tadd: function( elem, types, handler, data, selector ) {\n\t\tvar tmp, events, t, handleObjIn,\n\t\t\tspecial, eventHandle, handleObj,\n\t\t\thandlers, type, namespaces, origType,\n\t\t\telemData = jQuery._data( elem );\n\n\t\t// Don't attach events to noData or text/comment nodes (but allow plain objects)\n\t\tif ( !elemData ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Caller can pass in an object of custom data in lieu of the handler\n\t\tif ( handler.handler ) {\n\t\t\thandleObjIn = handler;\n\t\t\thandler = handleObjIn.handler;\n\t\t\tselector = handleObjIn.selector;\n\t\t}\n\n\t\t// Make sure that the handler has a unique ID, used to find/remove it later\n\t\tif ( !handler.guid ) {\n\t\t\thandler.guid = jQuery.guid++;\n\t\t}\n\n\t\t// Init the element's event structure and main handler, if this is the first\n\t\tif ( !(events = elemData.events) ) {\n\t\t\tevents = elemData.events = {};\n\t\t}\n\t\tif ( !(eventHandle = elemData.handle) ) {\n\t\t\teventHandle = elemData.handle = function( e ) {\n\t\t\t\t// Discard the second event of a jQuery.event.trigger() and\n\t\t\t\t// when an event is called after a page has unloaded\n\t\t\t\treturn typeof jQuery !== strundefined && (!e || jQuery.event.triggered !== e.type) ?\n\t\t\t\t\tjQuery.event.dispatch.apply( eventHandle.elem, arguments ) :\n\t\t\t\t\tundefined;\n\t\t\t};\n\t\t\t// Add elem as a property of the handle fn to prevent a memory leak with IE non-native events\n\t\t\teventHandle.elem = elem;\n\t\t}\n\n\t\t// Handle multiple events separated by a space\n\t\ttypes = ( types || \"\" ).match( rnotwhite ) || [ \"\" ];\n\t\tt = types.length;\n\t\twhile ( t-- ) {\n\t\t\ttmp = rtypenamespace.exec( types[t] ) || [];\n\t\t\ttype = origType = tmp[1];\n\t\t\tnamespaces = ( tmp[2] || \"\" ).split( \".\" ).sort();\n\n\t\t\t// There *must* be a type, no attaching namespace-only handlers\n\t\t\tif ( !type ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\t// If event changes its type, use the special event handlers for the changed type\n\t\t\tspecial = jQuery.event.special[ type ] || {};\n\n\t\t\t// If selector defined, determine special event api type, otherwise given type\n\t\t\ttype = ( selector ? special.delegateType : special.bindType ) || type;\n\n\t\t\t// Update special based on newly reset type\n\t\t\tspecial = jQuery.event.special[ type ] || {};\n\n\t\t\t// handleObj is passed to all event handlers\n\t\t\thandleObj = jQuery.extend({\n\t\t\t\ttype: type,\n\t\t\t\torigType: origType,\n\t\t\t\tdata: data,\n\t\t\t\thandler: handler,\n\t\t\t\tguid: handler.guid,\n\t\t\t\tselector: selector,\n\t\t\t\tneedsContext: selector && jQuery.expr.match.needsContext.test( selector ),\n\t\t\t\tnamespace: namespaces.join(\".\")\n\t\t\t}, handleObjIn );\n\n\t\t\t// Init the event handler queue if we're the first\n\t\t\tif ( !(handlers = events[ type ]) ) {\n\t\t\t\thandlers = events[ type ] = [];\n\t\t\t\thandlers.delegateCount = 0;\n\n\t\t\t\t// Only use addEventListener/attachEvent if the special events handler returns false\n\t\t\t\tif ( !special.setup || special.setup.call( elem, data, namespaces, eventHandle ) === false ) {\n\t\t\t\t\t// Bind the global event handler to the element\n\t\t\t\t\tif ( elem.addEventListener ) {\n\t\t\t\t\t\telem.addEventListener( type, eventHandle, false );\n\n\t\t\t\t\t} else if ( elem.attachEvent ) {\n\t\t\t\t\t\telem.attachEvent( \"on\" + type, eventHandle );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( special.add ) {\n\t\t\t\tspecial.add.call( elem, handleObj );\n\n\t\t\t\tif ( !handleObj.handler.guid ) {\n\t\t\t\t\thandleObj.handler.guid = handler.guid;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Add to the element's handler list, delegates in front\n\t\t\tif ( selector ) {\n\t\t\t\thandlers.splice( handlers.delegateCount++, 0, handleObj );\n\t\t\t} else {\n\t\t\t\thandlers.push( handleObj );\n\t\t\t}\n\n\t\t\t// Keep track of which events have ever been used, for event optimization\n\t\t\tjQuery.event.global[ type ] = true;\n\t\t}\n\n\t\t// Nullify elem to prevent memory leaks in IE\n\t\telem = null;\n\t},\n\n\t// Detach an event or set of events from an element\n\tremove: function( elem, types, handler, selector, mappedTypes ) {\n\t\tvar j, handleObj, tmp,\n\t\t\torigCount, t, events,\n\t\t\tspecial, handlers, type,\n\t\t\tnamespaces, origType,\n\t\t\telemData = jQuery.hasData( elem ) && jQuery._data( elem );\n\n\t\tif ( !elemData || !(events = elemData.events) ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Once for each type.namespace in types; type may be omitted\n\t\ttypes = ( types || \"\" ).match( rnotwhite ) || [ \"\" ];\n\t\tt = types.length;\n\t\twhile ( t-- ) {\n\t\t\ttmp = rtypenamespace.exec( types[t] ) || [];\n\t\t\ttype = origType = tmp[1];\n\t\t\tnamespaces = ( tmp[2] || \"\" ).split( \".\" ).sort();\n\n\t\t\t// Unbind all events (on this namespace, if provided) for the element\n\t\t\tif ( !type ) {\n\t\t\t\tfor ( type in events ) {\n\t\t\t\t\tjQuery.event.remove( elem, type + types[ t ], handler, selector, true );\n\t\t\t\t}\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tspecial = jQuery.event.special[ type ] || {};\n\t\t\ttype = ( selector ? special.delegateType : special.bindType ) || type;\n\t\t\thandlers = events[ type ] || [];\n\t\t\ttmp = tmp[2] && new RegExp( \"(^|\\\\.)\" + namespaces.join(\"\\\\.(?:.*\\\\.|)\") + \"(\\\\.|$)\" );\n\n\t\t\t// Remove matching events\n\t\t\torigCount = j = handlers.length;\n\t\t\twhile ( j-- ) {\n\t\t\t\thandleObj = handlers[ j ];\n\n\t\t\t\tif ( ( mappedTypes || origType === handleObj.origType ) &&\n\t\t\t\t\t( !handler || handler.guid === handleObj.guid ) &&\n\t\t\t\t\t( !tmp || tmp.test( handleObj.namespace ) ) &&\n\t\t\t\t\t( !selector || selector === handleObj.selector || selector === \"**\" && handleObj.selector ) ) {\n\t\t\t\t\thandlers.splice( j, 1 );\n\n\t\t\t\t\tif ( handleObj.selector ) {\n\t\t\t\t\t\thandlers.delegateCount--;\n\t\t\t\t\t}\n\t\t\t\t\tif ( special.remove ) {\n\t\t\t\t\t\tspecial.remove.call( elem, handleObj );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove generic event handler if we removed something and no more handlers exist\n\t\t\t// (avoids potential for endless recursion during removal of special event handlers)\n\t\t\tif ( origCount && !handlers.length ) {\n\t\t\t\tif ( !special.teardown || special.teardown.call( elem, namespaces, elemData.handle ) === false ) {\n\t\t\t\t\tjQuery.removeEvent( elem, type, elemData.handle );\n\t\t\t\t}\n\n\t\t\t\tdelete events[ type ];\n\t\t\t}\n\t\t}\n\n\t\t// Remove the expando if it's no longer used\n\t\tif ( jQuery.isEmptyObject( events ) ) {\n\t\t\tdelete elemData.handle;\n\n\t\t\t// removeData also checks for emptiness and clears the expando if empty\n\t\t\t// so use it instead of delete\n\t\t\tjQuery._removeData( elem, \"events\" );\n\t\t}\n\t},\n\n\ttrigger: function( event, data, elem, onlyHandlers ) {\n\t\tvar handle, ontype, cur,\n\t\t\tbubbleType, special, tmp, i,\n\t\t\teventPath = [ elem || document ],\n\t\t\ttype = hasOwn.call( event, \"type\" ) ? event.type : event,\n\t\t\tnamespaces = hasOwn.call( event, \"namespace\" ) ? event.namespace.split(\".\") : [];\n\n\t\tcur = tmp = elem = elem || document;\n\n\t\t// Don't do events on text and comment nodes\n\t\tif ( elem.nodeType === 3 || elem.nodeType === 8 ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// focus/blur morphs to focusin/out; ensure we're not firing them right now\n\t\tif ( rfocusMorph.test( type + jQuery.event.triggered ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( type.indexOf(\".\") >= 0 ) {\n\t\t\t// Namespaced trigger; create a regexp to match event type in handle()\n\t\t\tnamespaces = type.split(\".\");\n\t\t\ttype = namespaces.shift();\n\t\t\tnamespaces.sort();\n\t\t}\n\t\tontype = type.indexOf(\":\") < 0 && \"on\" + type;\n\n\t\t// Caller can pass in a jQuery.Event object, Object, or just an event type string\n\t\tevent = event[ jQuery.expando ] ?\n\t\t\tevent :\n\t\t\tnew jQuery.Event( type, typeof event === \"object\" && event );\n\n\t\t// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)\n\t\tevent.isTrigger = onlyHandlers ? 2 : 3;\n\t\tevent.namespace = namespaces.join(\".\");\n\t\tevent.namespace_re = event.namespace ?\n\t\t\tnew RegExp( \"(^|\\\\.)\" + namespaces.join(\"\\\\.(?:.*\\\\.|)\") + \"(\\\\.|$)\" ) :\n\t\t\tnull;\n\n\t\t// Clean up the event in case it is being reused\n\t\tevent.result = undefined;\n\t\tif ( !event.target ) {\n\t\t\tevent.target = elem;\n\t\t}\n\n\t\t// Clone any incoming data and prepend the event, creating the handler arg list\n\t\tdata = data == null ?\n\t\t\t[ event ] :\n\t\t\tjQuery.makeArray( data, [ event ] );\n\n\t\t// Allow special events to draw outside the lines\n\t\tspecial = jQuery.event.special[ type ] || {};\n\t\tif ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Determine event propagation path in advance, per W3C events spec (#9951)\n\t\t// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)\n\t\tif ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {\n\n\t\t\tbubbleType = special.delegateType || type;\n\t\t\tif ( !rfocusMorph.test( bubbleType + type ) ) {\n\t\t\t\tcur = cur.parentNode;\n\t\t\t}\n\t\t\tfor ( ; cur; cur = cur.parentNode ) {\n\t\t\t\teventPath.push( cur );\n\t\t\t\ttmp = cur;\n\t\t\t}\n\n\t\t\t// Only add window if we got to document (e.g., not plain obj or detached DOM)\n\t\t\tif ( tmp === (elem.ownerDocument || document) ) {\n\t\t\t\teventPath.push( tmp.defaultView || tmp.parentWindow || window );\n\t\t\t}\n\t\t}\n\n\t\t// Fire handlers on the event path\n\t\ti = 0;\n\t\twhile ( (cur = eventPath[i++]) && !event.isPropagationStopped() ) {\n\n\t\t\tevent.type = i > 1 ?\n\t\t\t\tbubbleType :\n\t\t\t\tspecial.bindType || type;\n\n\t\t\t// jQuery handler\n\t\t\thandle = ( jQuery._data( cur, \"events\" ) || {} )[ event.type ] && jQuery._data( cur, \"handle\" );\n\t\t\tif ( handle ) {\n\t\t\t\thandle.apply( cur, data );\n\t\t\t}\n\n\t\t\t// Native handler\n\t\t\thandle = ontype && cur[ ontype ];\n\t\t\tif ( handle && handle.apply && jQuery.acceptData( cur ) ) {\n\t\t\t\tevent.result = handle.apply( cur, data );\n\t\t\t\tif ( event.result === false ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tevent.type = type;\n\n\t\t// If nobody prevented the default action, do it now\n\t\tif ( !onlyHandlers && !event.isDefaultPrevented() ) {\n\n\t\t\tif ( (!special._default || special._default.apply( eventPath.pop(), data ) === false) &&\n\t\t\t\tjQuery.acceptData( elem ) ) {\n\n\t\t\t\t// Call a native DOM method on the target with the same name name as the event.\n\t\t\t\t// Can't use an .isFunction() check here because IE6/7 fails that test.\n\t\t\t\t// Don't do default actions on window, that's where global variables be (#6170)\n\t\t\t\tif ( ontype && elem[ type ] && !jQuery.isWindow( elem ) ) {\n\n\t\t\t\t\t// Don't re-trigger an onFOO event when we call its FOO() method\n\t\t\t\t\ttmp = elem[ ontype ];\n\n\t\t\t\t\tif ( tmp ) {\n\t\t\t\t\t\telem[ ontype ] = null;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Prevent re-triggering of the same event, since we already bubbled it above\n\t\t\t\t\tjQuery.event.triggered = type;\n\t\t\t\t\ttry {\n\t\t\t\t\t\telem[ type ]();\n\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t// IE<9 dies on focus/blur to hidden element (#1486,#12518)\n\t\t\t\t\t\t// only reproducible on winXP IE8 native, not IE9 in IE8 mode\n\t\t\t\t\t}\n\t\t\t\t\tjQuery.event.triggered = undefined;\n\n\t\t\t\t\tif ( tmp ) {\n\t\t\t\t\t\telem[ ontype ] = tmp;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn event.result;\n\t},\n\n\tdispatch: function( event ) {\n\n\t\t// Make a writable jQuery.Event from the native event object\n\t\tevent = jQuery.event.fix( event );\n\n\t\tvar i, ret, handleObj, matched, j,\n\t\t\thandlerQueue = [],\n\t\t\targs = slice.call( arguments ),\n\t\t\thandlers = ( jQuery._data( this, \"events\" ) || {} )[ event.type ] || [],\n\t\t\tspecial = jQuery.event.special[ event.type ] || {};\n\n\t\t// Use the fix-ed jQuery.Event rather than the (read-only) native event\n\t\targs[0] = event;\n\t\tevent.delegateTarget = this;\n\n\t\t// Call the preDispatch hook for the mapped type, and let it bail if desired\n\t\tif ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Determine handlers\n\t\thandlerQueue = jQuery.event.handlers.call( this, event, handlers );\n\n\t\t// Run delegates first; they may want to stop propagation beneath us\n\t\ti = 0;\n\t\twhile ( (matched = handlerQueue[ i++ ]) && !event.isPropagationStopped() ) {\n\t\t\tevent.currentTarget = matched.elem;\n\n\t\t\tj = 0;\n\t\t\twhile ( (handleObj = matched.handlers[ j++ ]) && !event.isImmediatePropagationStopped() ) {\n\n\t\t\t\t// Triggered event must either 1) have no namespace, or\n\t\t\t\t// 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).\n\t\t\t\tif ( !event.namespace_re || event.namespace_re.test( handleObj.namespace ) ) {\n\n\t\t\t\t\tevent.handleObj = handleObj;\n\t\t\t\t\tevent.data = handleObj.data;\n\n\t\t\t\t\tret = ( (jQuery.event.special[ handleObj.origType ] || {}).handle || handleObj.handler )\n\t\t\t\t\t\t\t.apply( matched.elem, args );\n\n\t\t\t\t\tif ( ret !== undefined ) {\n\t\t\t\t\t\tif ( (event.result = ret) === false ) {\n\t\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\t\tevent.stopPropagation();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Call the postDispatch hook for the mapped type\n\t\tif ( special.postDispatch ) {\n\t\t\tspecial.postDispatch.call( this, event );\n\t\t}\n\n\t\treturn event.result;\n\t},\n\n\thandlers: function( event, handlers ) {\n\t\tvar sel, handleObj, matches, i,\n\t\t\thandlerQueue = [],\n\t\t\tdelegateCount = handlers.delegateCount,\n\t\t\tcur = event.target;\n\n\t\t// Find delegate handlers\n\t\t// Black-hole SVG <use> instance trees (#13180)\n\t\t// Avoid non-left-click bubbling in Firefox (#3861)\n\t\tif ( delegateCount && cur.nodeType && (!event.button || event.type !== \"click\") ) {\n\n\t\t\t/* jshint eqeqeq: false */\n\t\t\tfor ( ; cur != this; cur = cur.parentNode || this ) {\n\t\t\t\t/* jshint eqeqeq: true */\n\n\t\t\t\t// Don't check non-elements (#13208)\n\t\t\t\t// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)\n\t\t\t\tif ( cur.nodeType === 1 && (cur.disabled !== true || event.type !== \"click\") ) {\n\t\t\t\t\tmatches = [];\n\t\t\t\t\tfor ( i = 0; i < delegateCount; i++ ) {\n\t\t\t\t\t\thandleObj = handlers[ i ];\n\n\t\t\t\t\t\t// Don't conflict with Object.prototype properties (#13203)\n\t\t\t\t\t\tsel = handleObj.selector + \" \";\n\n\t\t\t\t\t\tif ( matches[ sel ] === undefined ) {\n\t\t\t\t\t\t\tmatches[ sel ] = handleObj.needsContext ?\n\t\t\t\t\t\t\t\tjQuery( sel, this ).index( cur ) >= 0 :\n\t\t\t\t\t\t\t\tjQuery.find( sel, this, null, [ cur ] ).length;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( matches[ sel ] ) {\n\t\t\t\t\t\t\tmatches.push( handleObj );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif ( matches.length ) {\n\t\t\t\t\t\thandlerQueue.push({ elem: cur, handlers: matches });\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Add the remaining (directly-bound) handlers\n\t\tif ( delegateCount < handlers.length ) {\n\t\t\thandlerQueue.push({ elem: this, handlers: handlers.slice( delegateCount ) });\n\t\t}\n\n\t\treturn handlerQueue;\n\t},\n\n\tfix: function( event ) {\n\t\tif ( event[ jQuery.expando ] ) {\n\t\t\treturn event;\n\t\t}\n\n\t\t// Create a writable copy of the event object and normalize some properties\n\t\tvar i, prop, copy,\n\t\t\ttype = event.type,\n\t\t\toriginalEvent = event,\n\t\t\tfixHook = this.fixHooks[ type ];\n\n\t\tif ( !fixHook ) {\n\t\t\tthis.fixHooks[ type ] = fixHook =\n\t\t\t\trmouseEvent.test( type ) ? this.mouseHooks :\n\t\t\t\trkeyEvent.test( type ) ? this.keyHooks :\n\t\t\t\t{};\n\t\t}\n\t\tcopy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;\n\n\t\tevent = new jQuery.Event( originalEvent );\n\n\t\ti = copy.length;\n\t\twhile ( i-- ) {\n\t\t\tprop = copy[ i ];\n\t\t\tevent[ prop ] = originalEvent[ prop ];\n\t\t}\n\n\t\t// Support: IE<9\n\t\t// Fix target property (#1925)\n\t\tif ( !event.target ) {\n\t\t\tevent.target = originalEvent.srcElement || document;\n\t\t}\n\n\t\t// Support: Chrome 23+, Safari?\n\t\t// Target should not be a text node (#504, #13143)\n\t\tif ( event.target.nodeType === 3 ) {\n\t\t\tevent.target = event.target.parentNode;\n\t\t}\n\n\t\t// Support: IE<9\n\t\t// For mouse/key events, metaKey==false if it's undefined (#3368, #11328)\n\t\tevent.metaKey = !!event.metaKey;\n\n\t\treturn fixHook.filter ? fixHook.filter( event, originalEvent ) : event;\n\t},\n\n\t// Includes some event props shared by KeyEvent and MouseEvent\n\tprops: \"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which\".split(\" \"),\n\n\tfixHooks: {},\n\n\tkeyHooks: {\n\t\tprops: \"char charCode key keyCode\".split(\" \"),\n\t\tfilter: function( event, original ) {\n\n\t\t\t// Add which for key events\n\t\t\tif ( event.which == null ) {\n\t\t\t\tevent.which = original.charCode != null ? original.charCode : original.keyCode;\n\t\t\t}\n\n\t\t\treturn event;\n\t\t}\n\t},\n\n\tmouseHooks: {\n\t\tprops: \"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement\".split(\" \"),\n\t\tfilter: function( event, original ) {\n\t\t\tvar body, eventDoc, doc,\n\t\t\t\tbutton = original.button,\n\t\t\t\tfromElement = original.fromElement;\n\n\t\t\t// Calculate pageX/Y if missing and clientX/Y available\n\t\t\tif ( event.pageX == null && original.clientX != null ) {\n\t\t\t\teventDoc = event.target.ownerDocument || document;\n\t\t\t\tdoc = eventDoc.documentElement;\n\t\t\t\tbody = eventDoc.body;\n\n\t\t\t\tevent.pageX = original.clientX + ( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) - ( doc && doc.clientLeft || body && body.clientLeft || 0 );\n\t\t\t\tevent.pageY = original.clientY + ( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) - ( doc && doc.clientTop  || body && body.clientTop  || 0 );\n\t\t\t}\n\n\t\t\t// Add relatedTarget, if necessary\n\t\t\tif ( !event.relatedTarget && fromElement ) {\n\t\t\t\tevent.relatedTarget = fromElement === event.target ? original.toElement : fromElement;\n\t\t\t}\n\n\t\t\t// Add which for click: 1 === left; 2 === middle; 3 === right\n\t\t\t// Note: button is not normalized, so don't use it\n\t\t\tif ( !event.which && button !== undefined ) {\n\t\t\t\tevent.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );\n\t\t\t}\n\n\t\t\treturn event;\n\t\t}\n\t},\n\n\tspecial: {\n\t\tload: {\n\t\t\t// Prevent triggered image.load events from bubbling to window.load\n\t\t\tnoBubble: true\n\t\t},\n\t\tfocus: {\n\t\t\t// Fire native event if possible so blur/focus sequence is correct\n\t\t\ttrigger: function() {\n\t\t\t\tif ( this !== safeActiveElement() && this.focus ) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tthis.focus();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t// If we error on focus to hidden element (#1486, #12518),\n\t\t\t\t\t\t// let .trigger() run the handlers\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tdelegateType: \"focusin\"\n\t\t},\n\t\tblur: {\n\t\t\ttrigger: function() {\n\t\t\t\tif ( this === safeActiveElement() && this.blur ) {\n\t\t\t\t\tthis.blur();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t},\n\t\t\tdelegateType: \"focusout\"\n\t\t},\n\t\tclick: {\n\t\t\t// For checkbox, fire native event so checked state will be right\n\t\t\ttrigger: function() {\n\t\t\t\tif ( jQuery.nodeName( this, \"input\" ) && this.type === \"checkbox\" && this.click ) {\n\t\t\t\t\tthis.click();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// For cross-browser consistency, don't fire native .click() on links\n\t\t\t_default: function( event ) {\n\t\t\t\treturn jQuery.nodeName( event.target, \"a\" );\n\t\t\t}\n\t\t},\n\n\t\tbeforeunload: {\n\t\t\tpostDispatch: function( event ) {\n\n\t\t\t\t// Even when returnValue equals to undefined Firefox will still show alert\n\t\t\t\tif ( event.result !== undefined ) {\n\t\t\t\t\tevent.originalEvent.returnValue = event.result;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\n\tsimulate: function( type, elem, event, bubble ) {\n\t\t// Piggyback on a donor event to simulate a different one.\n\t\t// Fake originalEvent to avoid donor's stopPropagation, but if the\n\t\t// simulated event prevents default then we do the same on the donor.\n\t\tvar e = jQuery.extend(\n\t\t\tnew jQuery.Event(),\n\t\t\tevent,\n\t\t\t{\n\t\t\t\ttype: type,\n\t\t\t\tisSimulated: true,\n\t\t\t\toriginalEvent: {}\n\t\t\t}\n\t\t);\n\t\tif ( bubble ) {\n\t\t\tjQuery.event.trigger( e, null, elem );\n\t\t} else {\n\t\t\tjQuery.event.dispatch.call( elem, e );\n\t\t}\n\t\tif ( e.isDefaultPrevented() ) {\n\t\t\tevent.preventDefault();\n\t\t}\n\t}\n};\n\njQuery.removeEvent = document.removeEventListener ?\n\tfunction( elem, type, handle ) {\n\t\tif ( elem.removeEventListener ) {\n\t\t\telem.removeEventListener( type, handle, false );\n\t\t}\n\t} :\n\tfunction( elem, type, handle ) {\n\t\tvar name = \"on\" + type;\n\n\t\tif ( elem.detachEvent ) {\n\n\t\t\t// #8545, #7054, preventing memory leaks for custom events in IE6-8\n\t\t\t// detachEvent needed property on element, by name of that event, to properly expose it to GC\n\t\t\tif ( typeof elem[ name ] === strundefined ) {\n\t\t\t\telem[ name ] = null;\n\t\t\t}\n\n\t\t\telem.detachEvent( name, handle );\n\t\t}\n\t};\n\njQuery.Event = function( src, props ) {\n\t// Allow instantiation without the 'new' keyword\n\tif ( !(this instanceof jQuery.Event) ) {\n\t\treturn new jQuery.Event( src, props );\n\t}\n\n\t// Event object\n\tif ( src && src.type ) {\n\t\tthis.originalEvent = src;\n\t\tthis.type = src.type;\n\n\t\t// Events bubbling up the document may have been marked as prevented\n\t\t// by a handler lower down the tree; reflect the correct value.\n\t\tthis.isDefaultPrevented = src.defaultPrevented ||\n\t\t\t\tsrc.defaultPrevented === undefined && (\n\t\t\t\t// Support: IE < 9\n\t\t\t\tsrc.returnValue === false ||\n\t\t\t\t// Support: Android < 4.0\n\t\t\t\tsrc.getPreventDefault && src.getPreventDefault() ) ?\n\t\t\treturnTrue :\n\t\t\treturnFalse;\n\n\t// Event type\n\t} else {\n\t\tthis.type = src;\n\t}\n\n\t// Put explicitly provided properties onto the event object\n\tif ( props ) {\n\t\tjQuery.extend( this, props );\n\t}\n\n\t// Create a timestamp if incoming event doesn't have one\n\tthis.timeStamp = src && src.timeStamp || jQuery.now();\n\n\t// Mark it as fixed\n\tthis[ jQuery.expando ] = true;\n};\n\n// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding\n// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html\njQuery.Event.prototype = {\n\tisDefaultPrevented: returnFalse,\n\tisPropagationStopped: returnFalse,\n\tisImmediatePropagationStopped: returnFalse,\n\n\tpreventDefault: function() {\n\t\tvar e = this.originalEvent;\n\n\t\tthis.isDefaultPrevented = returnTrue;\n\t\tif ( !e ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// If preventDefault exists, run it on the original event\n\t\tif ( e.preventDefault ) {\n\t\t\te.preventDefault();\n\n\t\t// Support: IE\n\t\t// Otherwise set the returnValue property of the original event to false\n\t\t} else {\n\t\t\te.returnValue = false;\n\t\t}\n\t},\n\tstopPropagation: function() {\n\t\tvar e = this.originalEvent;\n\n\t\tthis.isPropagationStopped = returnTrue;\n\t\tif ( !e ) {\n\t\t\treturn;\n\t\t}\n\t\t// If stopPropagation exists, run it on the original event\n\t\tif ( e.stopPropagation ) {\n\t\t\te.stopPropagation();\n\t\t}\n\n\t\t// Support: IE\n\t\t// Set the cancelBubble property of the original event to true\n\t\te.cancelBubble = true;\n\t},\n\tstopImmediatePropagation: function() {\n\t\tthis.isImmediatePropagationStopped = returnTrue;\n\t\tthis.stopPropagation();\n\t}\n};\n\n// Create mouseenter/leave events using mouseover/out and event-time checks\njQuery.each({\n\tmouseenter: \"mouseover\",\n\tmouseleave: \"mouseout\"\n}, function( orig, fix ) {\n\tjQuery.event.special[ orig ] = {\n\t\tdelegateType: fix,\n\t\tbindType: fix,\n\n\t\thandle: function( event ) {\n\t\t\tvar ret,\n\t\t\t\ttarget = this,\n\t\t\t\trelated = event.relatedTarget,\n\t\t\t\thandleObj = event.handleObj;\n\n\t\t\t// For mousenter/leave call the handler if related is outside the target.\n\t\t\t// NB: No relatedTarget if the mouse left/entered the browser window\n\t\t\tif ( !related || (related !== target && !jQuery.contains( target, related )) ) {\n\t\t\t\tevent.type = handleObj.origType;\n\t\t\t\tret = handleObj.handler.apply( this, arguments );\n\t\t\t\tevent.type = fix;\n\t\t\t}\n\t\t\treturn ret;\n\t\t}\n\t};\n});\n\n// IE submit delegation\nif ( !support.submitBubbles ) {\n\n\tjQuery.event.special.submit = {\n\t\tsetup: function() {\n\t\t\t// Only need this for delegated form submit events\n\t\t\tif ( jQuery.nodeName( this, \"form\" ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// Lazy-add a submit handler when a descendant form may potentially be submitted\n\t\t\tjQuery.event.add( this, \"click._submit keypress._submit\", function( e ) {\n\t\t\t\t// Node name check avoids a VML-related crash in IE (#9807)\n\t\t\t\tvar elem = e.target,\n\t\t\t\t\tform = jQuery.nodeName( elem, \"input\" ) || jQuery.nodeName( elem, \"button\" ) ? elem.form : undefined;\n\t\t\t\tif ( form && !jQuery._data( form, \"submitBubbles\" ) ) {\n\t\t\t\t\tjQuery.event.add( form, \"submit._submit\", function( event ) {\n\t\t\t\t\t\tevent._submit_bubble = true;\n\t\t\t\t\t});\n\t\t\t\t\tjQuery._data( form, \"submitBubbles\", true );\n\t\t\t\t}\n\t\t\t});\n\t\t\t// return undefined since we don't need an event listener\n\t\t},\n\n\t\tpostDispatch: function( event ) {\n\t\t\t// If form was submitted by the user, bubble the event up the tree\n\t\t\tif ( event._submit_bubble ) {\n\t\t\t\tdelete event._submit_bubble;\n\t\t\t\tif ( this.parentNode && !event.isTrigger ) {\n\t\t\t\t\tjQuery.event.simulate( \"submit\", this.parentNode, event, true );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tteardown: function() {\n\t\t\t// Only need this for delegated form submit events\n\t\t\tif ( jQuery.nodeName( this, \"form\" ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// Remove delegated handlers; cleanData eventually reaps submit handlers attached above\n\t\t\tjQuery.event.remove( this, \"._submit\" );\n\t\t}\n\t};\n}\n\n// IE change delegation and checkbox/radio fix\nif ( !support.changeBubbles ) {\n\n\tjQuery.event.special.change = {\n\n\t\tsetup: function() {\n\n\t\t\tif ( rformElems.test( this.nodeName ) ) {\n\t\t\t\t// IE doesn't fire change on a check/radio until blur; trigger it on click\n\t\t\t\t// after a propertychange. Eat the blur-change in special.change.handle.\n\t\t\t\t// This still fires onchange a second time for check/radio after blur.\n\t\t\t\tif ( this.type === \"checkbox\" || this.type === \"radio\" ) {\n\t\t\t\t\tjQuery.event.add( this, \"propertychange._change\", function( event ) {\n\t\t\t\t\t\tif ( event.originalEvent.propertyName === \"checked\" ) {\n\t\t\t\t\t\t\tthis._just_changed = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tjQuery.event.add( this, \"click._change\", function( event ) {\n\t\t\t\t\t\tif ( this._just_changed && !event.isTrigger ) {\n\t\t\t\t\t\t\tthis._just_changed = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\t// Allow triggered, simulated change events (#11500)\n\t\t\t\t\t\tjQuery.event.simulate( \"change\", this, event, true );\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\t// Delegated event; lazy-add a change handler on descendant inputs\n\t\t\tjQuery.event.add( this, \"beforeactivate._change\", function( e ) {\n\t\t\t\tvar elem = e.target;\n\n\t\t\t\tif ( rformElems.test( elem.nodeName ) && !jQuery._data( elem, \"changeBubbles\" ) ) {\n\t\t\t\t\tjQuery.event.add( elem, \"change._change\", function( event ) {\n\t\t\t\t\t\tif ( this.parentNode && !event.isSimulated && !event.isTrigger ) {\n\t\t\t\t\t\t\tjQuery.event.simulate( \"change\", this.parentNode, event, true );\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tjQuery._data( elem, \"changeBubbles\", true );\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\thandle: function( event ) {\n\t\t\tvar elem = event.target;\n\n\t\t\t// Swallow native change events from checkbox/radio, we already triggered them above\n\t\t\tif ( this !== elem || event.isSimulated || event.isTrigger || (elem.type !== \"radio\" && elem.type !== \"checkbox\") ) {\n\t\t\t\treturn event.handleObj.handler.apply( this, arguments );\n\t\t\t}\n\t\t},\n\n\t\tteardown: function() {\n\t\t\tjQuery.event.remove( this, \"._change\" );\n\n\t\t\treturn !rformElems.test( this.nodeName );\n\t\t}\n\t};\n}\n\n// Create \"bubbling\" focus and blur events\nif ( !support.focusinBubbles ) {\n\tjQuery.each({ focus: \"focusin\", blur: \"focusout\" }, function( orig, fix ) {\n\n\t\t// Attach a single capturing handler on the document while someone wants focusin/focusout\n\t\tvar handler = function( event ) {\n\t\t\t\tjQuery.event.simulate( fix, event.target, jQuery.event.fix( event ), true );\n\t\t\t};\n\n\t\tjQuery.event.special[ fix ] = {\n\t\t\tsetup: function() {\n\t\t\t\tvar doc = this.ownerDocument || this,\n\t\t\t\t\tattaches = jQuery._data( doc, fix );\n\n\t\t\t\tif ( !attaches ) {\n\t\t\t\t\tdoc.addEventListener( orig, handler, true );\n\t\t\t\t}\n\t\t\t\tjQuery._data( doc, fix, ( attaches || 0 ) + 1 );\n\t\t\t},\n\t\t\tteardown: function() {\n\t\t\t\tvar doc = this.ownerDocument || this,\n\t\t\t\t\tattaches = jQuery._data( doc, fix ) - 1;\n\n\t\t\t\tif ( !attaches ) {\n\t\t\t\t\tdoc.removeEventListener( orig, handler, true );\n\t\t\t\t\tjQuery._removeData( doc, fix );\n\t\t\t\t} else {\n\t\t\t\t\tjQuery._data( doc, fix, attaches );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t});\n}\n\njQuery.fn.extend({\n\n\ton: function( types, selector, data, fn, /*INTERNAL*/ one ) {\n\t\tvar type, origFn;\n\n\t\t// Types can be a map of types/handlers\n\t\tif ( typeof types === \"object\" ) {\n\t\t\t// ( types-Object, selector, data )\n\t\t\tif ( typeof selector !== \"string\" ) {\n\t\t\t\t// ( types-Object, data )\n\t\t\t\tdata = data || selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t\tfor ( type in types ) {\n\t\t\t\tthis.on( type, selector, data, types[ type ], one );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\n\t\tif ( data == null && fn == null ) {\n\t\t\t// ( types, fn )\n\t\t\tfn = selector;\n\t\t\tdata = selector = undefined;\n\t\t} else if ( fn == null ) {\n\t\t\tif ( typeof selector === \"string\" ) {\n\t\t\t\t// ( types, selector, fn )\n\t\t\t\tfn = data;\n\t\t\t\tdata = undefined;\n\t\t\t} else {\n\t\t\t\t// ( types, data, fn )\n\t\t\t\tfn = data;\n\t\t\t\tdata = selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t}\n\t\tif ( fn === false ) {\n\t\t\tfn = returnFalse;\n\t\t} else if ( !fn ) {\n\t\t\treturn this;\n\t\t}\n\n\t\tif ( one === 1 ) {\n\t\t\torigFn = fn;\n\t\t\tfn = function( event ) {\n\t\t\t\t// Can use an empty set, since event contains the info\n\t\t\t\tjQuery().off( event );\n\t\t\t\treturn origFn.apply( this, arguments );\n\t\t\t};\n\t\t\t// Use same guid so caller can remove using origFn\n\t\t\tfn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );\n\t\t}\n\t\treturn this.each( function() {\n\t\t\tjQuery.event.add( this, types, fn, data, selector );\n\t\t});\n\t},\n\tone: function( types, selector, data, fn ) {\n\t\treturn this.on( types, selector, data, fn, 1 );\n\t},\n\toff: function( types, selector, fn ) {\n\t\tvar handleObj, type;\n\t\tif ( types && types.preventDefault && types.handleObj ) {\n\t\t\t// ( event )  dispatched jQuery.Event\n\t\t\thandleObj = types.handleObj;\n\t\t\tjQuery( types.delegateTarget ).off(\n\t\t\t\thandleObj.namespace ? handleObj.origType + \".\" + handleObj.namespace : handleObj.origType,\n\t\t\t\thandleObj.selector,\n\t\t\t\thandleObj.handler\n\t\t\t);\n\t\t\treturn this;\n\t\t}\n\t\tif ( typeof types === \"object\" ) {\n\t\t\t// ( types-object [, selector] )\n\t\t\tfor ( type in types ) {\n\t\t\t\tthis.off( type, selector, types[ type ] );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t\tif ( selector === false || typeof selector === \"function\" ) {\n\t\t\t// ( types [, fn] )\n\t\t\tfn = selector;\n\t\t\tselector = undefined;\n\t\t}\n\t\tif ( fn === false ) {\n\t\t\tfn = returnFalse;\n\t\t}\n\t\treturn this.each(function() {\n\t\t\tjQuery.event.remove( this, types, fn, selector );\n\t\t});\n\t},\n\n\ttrigger: function( type, data ) {\n\t\treturn this.each(function() {\n\t\t\tjQuery.event.trigger( type, data, this );\n\t\t});\n\t},\n\ttriggerHandler: function( type, data ) {\n\t\tvar elem = this[0];\n\t\tif ( elem ) {\n\t\t\treturn jQuery.event.trigger( type, data, elem, true );\n\t\t}\n\t}\n});\n\n\nfunction createSafeFragment( document ) {\n\tvar list = nodeNames.split( \"|\" ),\n\t\tsafeFrag = document.createDocumentFragment();\n\n\tif ( safeFrag.createElement ) {\n\t\twhile ( list.length ) {\n\t\t\tsafeFrag.createElement(\n\t\t\t\tlist.pop()\n\t\t\t);\n\t\t}\n\t}\n\treturn safeFrag;\n}\n\nvar nodeNames = \"abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|\" +\n\t\t\"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video\",\n\trinlinejQuery = / jQuery\\d+=\"(?:null|\\d+)\"/g,\n\trnoshimcache = new RegExp(\"<(?:\" + nodeNames + \")[\\\\s/>]\", \"i\"),\n\trleadingWhitespace = /^\\s+/,\n\trxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:]+)[^>]*)\\/>/gi,\n\trtagName = /<([\\w:]+)/,\n\trtbody = /<tbody/i,\n\trhtml = /<|&#?\\w+;/,\n\trnoInnerhtml = /<(?:script|style|link)/i,\n\t// checked=\"checked\" or checked\n\trchecked = /checked\\s*(?:[^=]|=\\s*.checked.)/i,\n\trscriptType = /^$|\\/(?:java|ecma)script/i,\n\trscriptTypeMasked = /^true\\/(.*)/,\n\trcleanScript = /^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g,\n\n\t// We have to close these tags to support XHTML (#13200)\n\twrapMap = {\n\t\toption: [ 1, \"<select multiple='multiple'>\", \"</select>\" ],\n\t\tlegend: [ 1, \"<fieldset>\", \"</fieldset>\" ],\n\t\tarea: [ 1, \"<map>\", \"</map>\" ],\n\t\tparam: [ 1, \"<object>\", \"</object>\" ],\n\t\tthead: [ 1, \"<table>\", \"</table>\" ],\n\t\ttr: [ 2, \"<table><tbody>\", \"</tbody></table>\" ],\n\t\tcol: [ 2, \"<table><tbody></tbody><colgroup>\", \"</colgroup></table>\" ],\n\t\ttd: [ 3, \"<table><tbody><tr>\", \"</tr></tbody></table>\" ],\n\n\t\t// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,\n\t\t// unless wrapped in a div with non-breaking characters in front of it.\n\t\t_default: support.htmlSerialize ? [ 0, \"\", \"\" ] : [ 1, \"X<div>\", \"</div>\"  ]\n\t},\n\tsafeFragment = createSafeFragment( document ),\n\tfragmentDiv = safeFragment.appendChild( document.createElement(\"div\") );\n\nwrapMap.optgroup = wrapMap.option;\nwrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;\nwrapMap.th = wrapMap.td;\n\nfunction getAll( context, tag ) {\n\tvar elems, elem,\n\t\ti = 0,\n\t\tfound = typeof context.getElementsByTagName !== strundefined ? context.getElementsByTagName( tag || \"*\" ) :\n\t\t\ttypeof context.querySelectorAll !== strundefined ? context.querySelectorAll( tag || \"*\" ) :\n\t\t\tundefined;\n\n\tif ( !found ) {\n\t\tfor ( found = [], elems = context.childNodes || context; (elem = elems[i]) != null; i++ ) {\n\t\t\tif ( !tag || jQuery.nodeName( elem, tag ) ) {\n\t\t\t\tfound.push( elem );\n\t\t\t} else {\n\t\t\t\tjQuery.merge( found, getAll( elem, tag ) );\n\t\t\t}\n\t\t}\n\t}\n\n\treturn tag === undefined || tag && jQuery.nodeName( context, tag ) ?\n\t\tjQuery.merge( [ context ], found ) :\n\t\tfound;\n}\n\n// Used in buildFragment, fixes the defaultChecked property\nfunction fixDefaultChecked( elem ) {\n\tif ( rcheckableType.test( elem.type ) ) {\n\t\telem.defaultChecked = elem.checked;\n\t}\n}\n\n// Support: IE<8\n// Manipulating tables requires a tbody\nfunction manipulationTarget( elem, content ) {\n\treturn jQuery.nodeName( elem, \"table\" ) &&\n\t\tjQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, \"tr\" ) ?\n\n\t\telem.getElementsByTagName(\"tbody\")[0] ||\n\t\t\telem.appendChild( elem.ownerDocument.createElement(\"tbody\") ) :\n\t\telem;\n}\n\n// Replace/restore the type attribute of script elements for safe DOM manipulation\nfunction disableScript( elem ) {\n\telem.type = (jQuery.find.attr( elem, \"type\" ) !== null) + \"/\" + elem.type;\n\treturn elem;\n}\nfunction restoreScript( elem ) {\n\tvar match = rscriptTypeMasked.exec( elem.type );\n\tif ( match ) {\n\t\telem.type = match[1];\n\t} else {\n\t\telem.removeAttribute(\"type\");\n\t}\n\treturn elem;\n}\n\n// Mark scripts as having already been evaluated\nfunction setGlobalEval( elems, refElements ) {\n\tvar elem,\n\t\ti = 0;\n\tfor ( ; (elem = elems[i]) != null; i++ ) {\n\t\tjQuery._data( elem, \"globalEval\", !refElements || jQuery._data( refElements[i], \"globalEval\" ) );\n\t}\n}\n\nfunction cloneCopyEvent( src, dest ) {\n\n\tif ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {\n\t\treturn;\n\t}\n\n\tvar type, i, l,\n\t\toldData = jQuery._data( src ),\n\t\tcurData = jQuery._data( dest, oldData ),\n\t\tevents = oldData.events;\n\n\tif ( events ) {\n\t\tdelete curData.handle;\n\t\tcurData.events = {};\n\n\t\tfor ( type in events ) {\n\t\t\tfor ( i = 0, l = events[ type ].length; i < l; i++ ) {\n\t\t\t\tjQuery.event.add( dest, type, events[ type ][ i ] );\n\t\t\t}\n\t\t}\n\t}\n\n\t// make the cloned public data object a copy from the original\n\tif ( curData.data ) {\n\t\tcurData.data = jQuery.extend( {}, curData.data );\n\t}\n}\n\nfunction fixCloneNodeIssues( src, dest ) {\n\tvar nodeName, e, data;\n\n\t// We do not need to do anything for non-Elements\n\tif ( dest.nodeType !== 1 ) {\n\t\treturn;\n\t}\n\n\tnodeName = dest.nodeName.toLowerCase();\n\n\t// IE6-8 copies events bound via attachEvent when using cloneNode.\n\tif ( !support.noCloneEvent && dest[ jQuery.expando ] ) {\n\t\tdata = jQuery._data( dest );\n\n\t\tfor ( e in data.events ) {\n\t\t\tjQuery.removeEvent( dest, e, data.handle );\n\t\t}\n\n\t\t// Event data gets referenced instead of copied if the expando gets copied too\n\t\tdest.removeAttribute( jQuery.expando );\n\t}\n\n\t// IE blanks contents when cloning scripts, and tries to evaluate newly-set text\n\tif ( nodeName === \"script\" && dest.text !== src.text ) {\n\t\tdisableScript( dest ).text = src.text;\n\t\trestoreScript( dest );\n\n\t// IE6-10 improperly clones children of object elements using classid.\n\t// IE10 throws NoModificationAllowedError if parent is null, #12132.\n\t} else if ( nodeName === \"object\" ) {\n\t\tif ( dest.parentNode ) {\n\t\t\tdest.outerHTML = src.outerHTML;\n\t\t}\n\n\t\t// This path appears unavoidable for IE9. When cloning an object\n\t\t// element in IE9, the outerHTML strategy above is not sufficient.\n\t\t// If the src has innerHTML and the destination does not,\n\t\t// copy the src.innerHTML into the dest.innerHTML. #10324\n\t\tif ( support.html5Clone && ( src.innerHTML && !jQuery.trim(dest.innerHTML) ) ) {\n\t\t\tdest.innerHTML = src.innerHTML;\n\t\t}\n\n\t} else if ( nodeName === \"input\" && rcheckableType.test( src.type ) ) {\n\t\t// IE6-8 fails to persist the checked state of a cloned checkbox\n\t\t// or radio button. Worse, IE6-7 fail to give the cloned element\n\t\t// a checked appearance if the defaultChecked value isn't also set\n\n\t\tdest.defaultChecked = dest.checked = src.checked;\n\n\t\t// IE6-7 get confused and end up setting the value of a cloned\n\t\t// checkbox/radio button to an empty string instead of \"on\"\n\t\tif ( dest.value !== src.value ) {\n\t\t\tdest.value = src.value;\n\t\t}\n\n\t// IE6-8 fails to return the selected option to the default selected\n\t// state when cloning options\n\t} else if ( nodeName === \"option\" ) {\n\t\tdest.defaultSelected = dest.selected = src.defaultSelected;\n\n\t// IE6-8 fails to set the defaultValue to the correct value when\n\t// cloning other types of input fields\n\t} else if ( nodeName === \"input\" || nodeName === \"textarea\" ) {\n\t\tdest.defaultValue = src.defaultValue;\n\t}\n}\n\njQuery.extend({\n\tclone: function( elem, dataAndEvents, deepDataAndEvents ) {\n\t\tvar destElements, node, clone, i, srcElements,\n\t\t\tinPage = jQuery.contains( elem.ownerDocument, elem );\n\n\t\tif ( support.html5Clone || jQuery.isXMLDoc(elem) || !rnoshimcache.test( \"<\" + elem.nodeName + \">\" ) ) {\n\t\t\tclone = elem.cloneNode( true );\n\n\t\t// IE<=8 does not properly clone detached, unknown element nodes\n\t\t} else {\n\t\t\tfragmentDiv.innerHTML = elem.outerHTML;\n\t\t\tfragmentDiv.removeChild( clone = fragmentDiv.firstChild );\n\t\t}\n\n\t\tif ( (!support.noCloneEvent || !support.noCloneChecked) &&\n\t\t\t\t(elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem) ) {\n\n\t\t\t// We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2\n\t\t\tdestElements = getAll( clone );\n\t\t\tsrcElements = getAll( elem );\n\n\t\t\t// Fix all IE cloning issues\n\t\t\tfor ( i = 0; (node = srcElements[i]) != null; ++i ) {\n\t\t\t\t// Ensure that the destination node is not null; Fixes #9587\n\t\t\t\tif ( destElements[i] ) {\n\t\t\t\t\tfixCloneNodeIssues( node, destElements[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Copy the events from the original to the clone\n\t\tif ( dataAndEvents ) {\n\t\t\tif ( deepDataAndEvents ) {\n\t\t\t\tsrcElements = srcElements || getAll( elem );\n\t\t\t\tdestElements = destElements || getAll( clone );\n\n\t\t\t\tfor ( i = 0; (node = srcElements[i]) != null; i++ ) {\n\t\t\t\t\tcloneCopyEvent( node, destElements[i] );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tcloneCopyEvent( elem, clone );\n\t\t\t}\n\t\t}\n\n\t\t// Preserve script evaluation history\n\t\tdestElements = getAll( clone, \"script\" );\n\t\tif ( destElements.length > 0 ) {\n\t\t\tsetGlobalEval( destElements, !inPage && getAll( elem, \"script\" ) );\n\t\t}\n\n\t\tdestElements = srcElements = node = null;\n\n\t\t// Return the cloned set\n\t\treturn clone;\n\t},\n\n\tbuildFragment: function( elems, context, scripts, selection ) {\n\t\tvar j, elem, contains,\n\t\t\ttmp, tag, tbody, wrap,\n\t\t\tl = elems.length,\n\n\t\t\t// Ensure a safe fragment\n\t\t\tsafe = createSafeFragment( context ),\n\n\t\t\tnodes = [],\n\t\t\ti = 0;\n\n\t\tfor ( ; i < l; i++ ) {\n\t\t\telem = elems[ i ];\n\n\t\t\tif ( elem || elem === 0 ) {\n\n\t\t\t\t// Add nodes directly\n\t\t\t\tif ( jQuery.type( elem ) === \"object\" ) {\n\t\t\t\t\tjQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );\n\n\t\t\t\t// Convert non-html into a text node\n\t\t\t\t} else if ( !rhtml.test( elem ) ) {\n\t\t\t\t\tnodes.push( context.createTextNode( elem ) );\n\n\t\t\t\t// Convert html into DOM nodes\n\t\t\t\t} else {\n\t\t\t\t\ttmp = tmp || safe.appendChild( context.createElement(\"div\") );\n\n\t\t\t\t\t// Deserialize a standard representation\n\t\t\t\t\ttag = (rtagName.exec( elem ) || [ \"\", \"\" ])[ 1 ].toLowerCase();\n\t\t\t\t\twrap = wrapMap[ tag ] || wrapMap._default;\n\n\t\t\t\t\ttmp.innerHTML = wrap[1] + elem.replace( rxhtmlTag, \"<$1></$2>\" ) + wrap[2];\n\n\t\t\t\t\t// Descend through wrappers to the right content\n\t\t\t\t\tj = wrap[0];\n\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\ttmp = tmp.lastChild;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Manually add leading whitespace removed by IE\n\t\t\t\t\tif ( !support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {\n\t\t\t\t\t\tnodes.push( context.createTextNode( rleadingWhitespace.exec( elem )[0] ) );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove IE's autoinserted <tbody> from table fragments\n\t\t\t\t\tif ( !support.tbody ) {\n\n\t\t\t\t\t\t// String was a <table>, *may* have spurious <tbody>\n\t\t\t\t\t\telem = tag === \"table\" && !rtbody.test( elem ) ?\n\t\t\t\t\t\t\ttmp.firstChild :\n\n\t\t\t\t\t\t\t// String was a bare <thead> or <tfoot>\n\t\t\t\t\t\t\twrap[1] === \"<table>\" && !rtbody.test( elem ) ?\n\t\t\t\t\t\t\t\ttmp :\n\t\t\t\t\t\t\t\t0;\n\n\t\t\t\t\t\tj = elem && elem.childNodes.length;\n\t\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\t\tif ( jQuery.nodeName( (tbody = elem.childNodes[j]), \"tbody\" ) && !tbody.childNodes.length ) {\n\t\t\t\t\t\t\t\telem.removeChild( tbody );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tjQuery.merge( nodes, tmp.childNodes );\n\n\t\t\t\t\t// Fix #12392 for WebKit and IE > 9\n\t\t\t\t\ttmp.textContent = \"\";\n\n\t\t\t\t\t// Fix #12392 for oldIE\n\t\t\t\t\twhile ( tmp.firstChild ) {\n\t\t\t\t\t\ttmp.removeChild( tmp.firstChild );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remember the top-level container for proper cleanup\n\t\t\t\t\ttmp = safe.lastChild;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Fix #11356: Clear elements from fragment\n\t\tif ( tmp ) {\n\t\t\tsafe.removeChild( tmp );\n\t\t}\n\n\t\t// Reset defaultChecked for any radios and checkboxes\n\t\t// about to be appended to the DOM in IE 6/7 (#8060)\n\t\tif ( !support.appendChecked ) {\n\t\t\tjQuery.grep( getAll( nodes, \"input\" ), fixDefaultChecked );\n\t\t}\n\n\t\ti = 0;\n\t\twhile ( (elem = nodes[ i++ ]) ) {\n\n\t\t\t// #4087 - If origin and destination elements are the same, and this is\n\t\t\t// that element, do not do anything\n\t\t\tif ( selection && jQuery.inArray( elem, selection ) !== -1 ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tcontains = jQuery.contains( elem.ownerDocument, elem );\n\n\t\t\t// Append to fragment\n\t\t\ttmp = getAll( safe.appendChild( elem ), \"script\" );\n\n\t\t\t// Preserve script evaluation history\n\t\t\tif ( contains ) {\n\t\t\t\tsetGlobalEval( tmp );\n\t\t\t}\n\n\t\t\t// Capture executables\n\t\t\tif ( scripts ) {\n\t\t\t\tj = 0;\n\t\t\t\twhile ( (elem = tmp[ j++ ]) ) {\n\t\t\t\t\tif ( rscriptType.test( elem.type || \"\" ) ) {\n\t\t\t\t\t\tscripts.push( elem );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\ttmp = null;\n\n\t\treturn safe;\n\t},\n\n\tcleanData: function( elems, /* internal */ acceptData ) {\n\t\tvar elem, type, id, data,\n\t\t\ti = 0,\n\t\t\tinternalKey = jQuery.expando,\n\t\t\tcache = jQuery.cache,\n\t\t\tdeleteExpando = support.deleteExpando,\n\t\t\tspecial = jQuery.event.special;\n\n\t\tfor ( ; (elem = elems[i]) != null; i++ ) {\n\t\t\tif ( acceptData || jQuery.acceptData( elem ) ) {\n\n\t\t\t\tid = elem[ internalKey ];\n\t\t\t\tdata = id && cache[ id ];\n\n\t\t\t\tif ( data ) {\n\t\t\t\t\tif ( data.events ) {\n\t\t\t\t\t\tfor ( type in data.events ) {\n\t\t\t\t\t\t\tif ( special[ type ] ) {\n\t\t\t\t\t\t\t\tjQuery.event.remove( elem, type );\n\n\t\t\t\t\t\t\t// This is a shortcut to avoid jQuery.event.remove's overhead\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tjQuery.removeEvent( elem, type, data.handle );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove cache only if it was not already removed by jQuery.event.remove\n\t\t\t\t\tif ( cache[ id ] ) {\n\n\t\t\t\t\t\tdelete cache[ id ];\n\n\t\t\t\t\t\t// IE does not allow us to delete expando properties from nodes,\n\t\t\t\t\t\t// nor does it have a removeAttribute function on Document nodes;\n\t\t\t\t\t\t// we must handle all of these cases\n\t\t\t\t\t\tif ( deleteExpando ) {\n\t\t\t\t\t\t\tdelete elem[ internalKey ];\n\n\t\t\t\t\t\t} else if ( typeof elem.removeAttribute !== strundefined ) {\n\t\t\t\t\t\t\telem.removeAttribute( internalKey );\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telem[ internalKey ] = null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tdeletedIds.push( id );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n});\n\njQuery.fn.extend({\n\ttext: function( value ) {\n\t\treturn access( this, function( value ) {\n\t\t\treturn value === undefined ?\n\t\t\t\tjQuery.text( this ) :\n\t\t\t\tthis.empty().append( ( this[0] && this[0].ownerDocument || document ).createTextNode( value ) );\n\t\t}, null, value, arguments.length );\n\t},\n\n\tappend: function() {\n\t\treturn this.domManip( arguments, function( elem ) {\n\t\t\tif ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n\t\t\t\tvar target = manipulationTarget( this, elem );\n\t\t\t\ttarget.appendChild( elem );\n\t\t\t}\n\t\t});\n\t},\n\n\tprepend: function() {\n\t\treturn this.domManip( arguments, function( elem ) {\n\t\t\tif ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n\t\t\t\tvar target = manipulationTarget( this, elem );\n\t\t\t\ttarget.insertBefore( elem, target.firstChild );\n\t\t\t}\n\t\t});\n\t},\n\n\tbefore: function() {\n\t\treturn this.domManip( arguments, function( elem ) {\n\t\t\tif ( this.parentNode ) {\n\t\t\t\tthis.parentNode.insertBefore( elem, this );\n\t\t\t}\n\t\t});\n\t},\n\n\tafter: function() {\n\t\treturn this.domManip( arguments, function( elem ) {\n\t\t\tif ( this.parentNode ) {\n\t\t\t\tthis.parentNode.insertBefore( elem, this.nextSibling );\n\t\t\t}\n\t\t});\n\t},\n\n\tremove: function( selector, keepData /* Internal Use Only */ ) {\n\t\tvar elem,\n\t\t\telems = selector ? jQuery.filter( selector, this ) : this,\n\t\t\ti = 0;\n\n\t\tfor ( ; (elem = elems[i]) != null; i++ ) {\n\n\t\t\tif ( !keepData && elem.nodeType === 1 ) {\n\t\t\t\tjQuery.cleanData( getAll( elem ) );\n\t\t\t}\n\n\t\t\tif ( elem.parentNode ) {\n\t\t\t\tif ( keepData && jQuery.contains( elem.ownerDocument, elem ) ) {\n\t\t\t\t\tsetGlobalEval( getAll( elem, \"script\" ) );\n\t\t\t\t}\n\t\t\t\telem.parentNode.removeChild( elem );\n\t\t\t}\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tempty: function() {\n\t\tvar elem,\n\t\t\ti = 0;\n\n\t\tfor ( ; (elem = this[i]) != null; i++ ) {\n\t\t\t// Remove element nodes and prevent memory leaks\n\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\tjQuery.cleanData( getAll( elem, false ) );\n\t\t\t}\n\n\t\t\t// Remove any remaining nodes\n\t\t\twhile ( elem.firstChild ) {\n\t\t\t\telem.removeChild( elem.firstChild );\n\t\t\t}\n\n\t\t\t// If this is a select, ensure that it displays empty (#12336)\n\t\t\t// Support: IE<9\n\t\t\tif ( elem.options && jQuery.nodeName( elem, \"select\" ) ) {\n\t\t\t\telem.options.length = 0;\n\t\t\t}\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tclone: function( dataAndEvents, deepDataAndEvents ) {\n\t\tdataAndEvents = dataAndEvents == null ? false : dataAndEvents;\n\t\tdeepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;\n\n\t\treturn this.map(function() {\n\t\t\treturn jQuery.clone( this, dataAndEvents, deepDataAndEvents );\n\t\t});\n\t},\n\n\thtml: function( value ) {\n\t\treturn access( this, function( value ) {\n\t\t\tvar elem = this[ 0 ] || {},\n\t\t\t\ti = 0,\n\t\t\t\tl = this.length;\n\n\t\t\tif ( value === undefined ) {\n\t\t\t\treturn elem.nodeType === 1 ?\n\t\t\t\t\telem.innerHTML.replace( rinlinejQuery, \"\" ) :\n\t\t\t\t\tundefined;\n\t\t\t}\n\n\t\t\t// See if we can take a shortcut and just use innerHTML\n\t\t\tif ( typeof value === \"string\" && !rnoInnerhtml.test( value ) &&\n\t\t\t\t( support.htmlSerialize || !rnoshimcache.test( value )  ) &&\n\t\t\t\t( support.leadingWhitespace || !rleadingWhitespace.test( value ) ) &&\n\t\t\t\t!wrapMap[ (rtagName.exec( value ) || [ \"\", \"\" ])[ 1 ].toLowerCase() ] ) {\n\n\t\t\t\tvalue = value.replace( rxhtmlTag, \"<$1></$2>\" );\n\n\t\t\t\ttry {\n\t\t\t\t\tfor (; i < l; i++ ) {\n\t\t\t\t\t\t// Remove element nodes and prevent memory leaks\n\t\t\t\t\t\telem = this[i] || {};\n\t\t\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\t\t\tjQuery.cleanData( getAll( elem, false ) );\n\t\t\t\t\t\t\telem.innerHTML = value;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\telem = 0;\n\n\t\t\t\t// If using innerHTML throws an exception, use the fallback method\n\t\t\t\t} catch(e) {}\n\t\t\t}\n\n\t\t\tif ( elem ) {\n\t\t\t\tthis.empty().append( value );\n\t\t\t}\n\t\t}, null, value, arguments.length );\n\t},\n\n\treplaceWith: function() {\n\t\tvar arg = arguments[ 0 ];\n\n\t\t// Make the changes, replacing each context element with the new content\n\t\tthis.domManip( arguments, function( elem ) {\n\t\t\targ = this.parentNode;\n\n\t\t\tjQuery.cleanData( getAll( this ) );\n\n\t\t\tif ( arg ) {\n\t\t\t\targ.replaceChild( elem, this );\n\t\t\t}\n\t\t});\n\n\t\t// Force removal if there was no new content (e.g., from empty arguments)\n\t\treturn arg && (arg.length || arg.nodeType) ? this : this.remove();\n\t},\n\n\tdetach: function( selector ) {\n\t\treturn this.remove( selector, true );\n\t},\n\n\tdomManip: function( args, callback ) {\n\n\t\t// Flatten any nested arrays\n\t\targs = concat.apply( [], args );\n\n\t\tvar first, node, hasScripts,\n\t\t\tscripts, doc, fragment,\n\t\t\ti = 0,\n\t\t\tl = this.length,\n\t\t\tset = this,\n\t\t\tiNoClone = l - 1,\n\t\t\tvalue = args[0],\n\t\t\tisFunction = jQuery.isFunction( value );\n\n\t\t// We can't cloneNode fragments that contain checked, in WebKit\n\t\tif ( isFunction ||\n\t\t\t\t( l > 1 && typeof value === \"string\" &&\n\t\t\t\t\t!support.checkClone && rchecked.test( value ) ) ) {\n\t\t\treturn this.each(function( index ) {\n\t\t\t\tvar self = set.eq( index );\n\t\t\t\tif ( isFunction ) {\n\t\t\t\t\targs[0] = value.call( this, index, self.html() );\n\t\t\t\t}\n\t\t\t\tself.domManip( args, callback );\n\t\t\t});\n\t\t}\n\n\t\tif ( l ) {\n\t\t\tfragment = jQuery.buildFragment( args, this[ 0 ].ownerDocument, false, this );\n\t\t\tfirst = fragment.firstChild;\n\n\t\t\tif ( fragment.childNodes.length === 1 ) {\n\t\t\t\tfragment = first;\n\t\t\t}\n\n\t\t\tif ( first ) {\n\t\t\t\tscripts = jQuery.map( getAll( fragment, \"script\" ), disableScript );\n\t\t\t\thasScripts = scripts.length;\n\n\t\t\t\t// Use the original fragment for the last item instead of the first because it can end up\n\t\t\t\t// being emptied incorrectly in certain situations (#8070).\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\tnode = fragment;\n\n\t\t\t\t\tif ( i !== iNoClone ) {\n\t\t\t\t\t\tnode = jQuery.clone( node, true, true );\n\n\t\t\t\t\t\t// Keep references to cloned scripts for later restoration\n\t\t\t\t\t\tif ( hasScripts ) {\n\t\t\t\t\t\t\tjQuery.merge( scripts, getAll( node, \"script\" ) );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tcallback.call( this[i], node, i );\n\t\t\t\t}\n\n\t\t\t\tif ( hasScripts ) {\n\t\t\t\t\tdoc = scripts[ scripts.length - 1 ].ownerDocument;\n\n\t\t\t\t\t// Reenable scripts\n\t\t\t\t\tjQuery.map( scripts, restoreScript );\n\n\t\t\t\t\t// Evaluate executable scripts on first document insertion\n\t\t\t\t\tfor ( i = 0; i < hasScripts; i++ ) {\n\t\t\t\t\t\tnode = scripts[ i ];\n\t\t\t\t\t\tif ( rscriptType.test( node.type || \"\" ) &&\n\t\t\t\t\t\t\t!jQuery._data( node, \"globalEval\" ) && jQuery.contains( doc, node ) ) {\n\n\t\t\t\t\t\t\tif ( node.src ) {\n\t\t\t\t\t\t\t\t// Optional AJAX dependency, but won't run scripts if not present\n\t\t\t\t\t\t\t\tif ( jQuery._evalUrl ) {\n\t\t\t\t\t\t\t\t\tjQuery._evalUrl( node.src );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tjQuery.globalEval( ( node.text || node.textContent || node.innerHTML || \"\" ).replace( rcleanScript, \"\" ) );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Fix #11809: Avoid leaking memory\n\t\t\t\tfragment = first = null;\n\t\t\t}\n\t\t}\n\n\t\treturn this;\n\t}\n});\n\njQuery.each({\n\tappendTo: \"append\",\n\tprependTo: \"prepend\",\n\tinsertBefore: \"before\",\n\tinsertAfter: \"after\",\n\treplaceAll: \"replaceWith\"\n}, function( name, original ) {\n\tjQuery.fn[ name ] = function( selector ) {\n\t\tvar elems,\n\t\t\ti = 0,\n\t\t\tret = [],\n\t\t\tinsert = jQuery( selector ),\n\t\t\tlast = insert.length - 1;\n\n\t\tfor ( ; i <= last; i++ ) {\n\t\t\telems = i === last ? this : this.clone(true);\n\t\t\tjQuery( insert[i] )[ original ]( elems );\n\n\t\t\t// Modern browsers can apply jQuery collections as arrays, but oldIE needs a .get()\n\t\t\tpush.apply( ret, elems.get() );\n\t\t}\n\n\t\treturn this.pushStack( ret );\n\t};\n});\n\n\nvar iframe,\n\telemdisplay = {};\n\n/**\n * Retrieve the actual display of a element\n * @param {String} name nodeName of the element\n * @param {Object} doc Document object\n */\n// Called only from within defaultDisplay\nfunction actualDisplay( name, doc ) {\n\tvar elem = jQuery( doc.createElement( name ) ).appendTo( doc.body ),\n\n\t\t// getDefaultComputedStyle might be reliably used only on attached element\n\t\tdisplay = window.getDefaultComputedStyle ?\n\n\t\t\t// Use of this method is a temporary fix (more like optmization) until something better comes along,\n\t\t\t// since it was removed from specification and supported only in FF\n\t\t\twindow.getDefaultComputedStyle( elem[ 0 ] ).display : jQuery.css( elem[ 0 ], \"display\" );\n\n\t// We don't have any data stored on the element,\n\t// so use \"detach\" method as fast way to get rid of the element\n\telem.detach();\n\n\treturn display;\n}\n\n/**\n * Try to determine the default display value of an element\n * @param {String} nodeName\n */\nfunction defaultDisplay( nodeName ) {\n\tvar doc = document,\n\t\tdisplay = elemdisplay[ nodeName ];\n\n\tif ( !display ) {\n\t\tdisplay = actualDisplay( nodeName, doc );\n\n\t\t// If the simple way fails, read from inside an iframe\n\t\tif ( display === \"none\" || !display ) {\n\n\t\t\t// Use the already-created iframe if possible\n\t\t\tiframe = (iframe || jQuery( \"<iframe frameborder='0' width='0' height='0'/>\" )).appendTo( doc.documentElement );\n\n\t\t\t// Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse\n\t\t\tdoc = ( iframe[ 0 ].contentWindow || iframe[ 0 ].contentDocument ).document;\n\n\t\t\t// Support: IE\n\t\t\tdoc.write();\n\t\t\tdoc.close();\n\n\t\t\tdisplay = actualDisplay( nodeName, doc );\n\t\t\tiframe.detach();\n\t\t}\n\n\t\t// Store the correct default display\n\t\telemdisplay[ nodeName ] = display;\n\t}\n\n\treturn display;\n}\n\n\n(function() {\n\tvar a, shrinkWrapBlocksVal,\n\t\tdiv = document.createElement( \"div\" ),\n\t\tdivReset =\n\t\t\t\"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;\" +\n\t\t\t\"display:block;padding:0;margin:0;border:0\";\n\n\t// Setup\n\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\ta = div.getElementsByTagName( \"a\" )[ 0 ];\n\n\ta.style.cssText = \"float:left;opacity:.5\";\n\n\t// Make sure that element opacity exists\n\t// (IE uses filter instead)\n\t// Use a regex to work around a WebKit issue. See #5145\n\tsupport.opacity = /^0.5/.test( a.style.opacity );\n\n\t// Verify style float existence\n\t// (IE uses styleFloat instead of cssFloat)\n\tsupport.cssFloat = !!a.style.cssFloat;\n\n\tdiv.style.backgroundClip = \"content-box\";\n\tdiv.cloneNode( true ).style.backgroundClip = \"\";\n\tsupport.clearCloneStyle = div.style.backgroundClip === \"content-box\";\n\n\t// Null elements to avoid leaks in IE.\n\ta = div = null;\n\n\tsupport.shrinkWrapBlocks = function() {\n\t\tvar body, container, div, containerStyles;\n\n\t\tif ( shrinkWrapBlocksVal == null ) {\n\t\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\t\t\tif ( !body ) {\n\t\t\t\t// Test fired too early or in an unsupported environment, exit.\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tcontainerStyles = \"border:0;width:0;height:0;position:absolute;top:0;left:-9999px\";\n\t\t\tcontainer = document.createElement( \"div\" );\n\t\t\tdiv = document.createElement( \"div\" );\n\n\t\t\tbody.appendChild( container ).appendChild( div );\n\n\t\t\t// Will be changed later if needed.\n\t\t\tshrinkWrapBlocksVal = false;\n\n\t\t\tif ( typeof div.style.zoom !== strundefined ) {\n\t\t\t\t// Support: IE6\n\t\t\t\t// Check if elements with layout shrink-wrap their children\n\t\t\t\tdiv.style.cssText = divReset + \";width:1px;padding:1px;zoom:1\";\n\t\t\t\tdiv.innerHTML = \"<div></div>\";\n\t\t\t\tdiv.firstChild.style.width = \"5px\";\n\t\t\t\tshrinkWrapBlocksVal = div.offsetWidth !== 3;\n\t\t\t}\n\n\t\t\tbody.removeChild( container );\n\n\t\t\t// Null elements to avoid leaks in IE.\n\t\t\tbody = container = div = null;\n\t\t}\n\n\t\treturn shrinkWrapBlocksVal;\n\t};\n\n})();\nvar rmargin = (/^margin/);\n\nvar rnumnonpx = new RegExp( \"^(\" + pnum + \")(?!px)[a-z%]+$\", \"i\" );\n\n\n\nvar getStyles, curCSS,\n\trposition = /^(top|right|bottom|left)$/;\n\nif ( window.getComputedStyle ) {\n\tgetStyles = function( elem ) {\n\t\treturn elem.ownerDocument.defaultView.getComputedStyle( elem, null );\n\t};\n\n\tcurCSS = function( elem, name, computed ) {\n\t\tvar width, minWidth, maxWidth, ret,\n\t\t\tstyle = elem.style;\n\n\t\tcomputed = computed || getStyles( elem );\n\n\t\t// getPropertyValue is only needed for .css('filter') in IE9, see #12537\n\t\tret = computed ? computed.getPropertyValue( name ) || computed[ name ] : undefined;\n\n\t\tif ( computed ) {\n\n\t\t\tif ( ret === \"\" && !jQuery.contains( elem.ownerDocument, elem ) ) {\n\t\t\t\tret = jQuery.style( elem, name );\n\t\t\t}\n\n\t\t\t// A tribute to the \"awesome hack by Dean Edwards\"\n\t\t\t// Chrome < 17 and Safari 5.0 uses \"computed value\" instead of \"used value\" for margin-right\n\t\t\t// Safari 5.1.7 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels\n\t\t\t// this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values\n\t\t\tif ( rnumnonpx.test( ret ) && rmargin.test( name ) ) {\n\n\t\t\t\t// Remember the original values\n\t\t\t\twidth = style.width;\n\t\t\t\tminWidth = style.minWidth;\n\t\t\t\tmaxWidth = style.maxWidth;\n\n\t\t\t\t// Put in the new values to get a computed value out\n\t\t\t\tstyle.minWidth = style.maxWidth = style.width = ret;\n\t\t\t\tret = computed.width;\n\n\t\t\t\t// Revert the changed values\n\t\t\t\tstyle.width = width;\n\t\t\t\tstyle.minWidth = minWidth;\n\t\t\t\tstyle.maxWidth = maxWidth;\n\t\t\t}\n\t\t}\n\n\t\t// Support: IE\n\t\t// IE returns zIndex value as an integer.\n\t\treturn ret === undefined ?\n\t\t\tret :\n\t\t\tret + \"\";\n\t};\n} else if ( document.documentElement.currentStyle ) {\n\tgetStyles = function( elem ) {\n\t\treturn elem.currentStyle;\n\t};\n\n\tcurCSS = function( elem, name, computed ) {\n\t\tvar left, rs, rsLeft, ret,\n\t\t\tstyle = elem.style;\n\n\t\tcomputed = computed || getStyles( elem );\n\t\tret = computed ? computed[ name ] : undefined;\n\n\t\t// Avoid setting ret to empty string here\n\t\t// so we don't default to auto\n\t\tif ( ret == null && style && style[ name ] ) {\n\t\t\tret = style[ name ];\n\t\t}\n\n\t\t// From the awesome hack by Dean Edwards\n\t\t// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291\n\n\t\t// If we're not dealing with a regular pixel number\n\t\t// but a number that has a weird ending, we need to convert it to pixels\n\t\t// but not position css attributes, as those are proportional to the parent element instead\n\t\t// and we can't measure the parent instead because it might trigger a \"stacking dolls\" problem\n\t\tif ( rnumnonpx.test( ret ) && !rposition.test( name ) ) {\n\n\t\t\t// Remember the original values\n\t\t\tleft = style.left;\n\t\t\trs = elem.runtimeStyle;\n\t\t\trsLeft = rs && rs.left;\n\n\t\t\t// Put in the new values to get a computed value out\n\t\t\tif ( rsLeft ) {\n\t\t\t\trs.left = elem.currentStyle.left;\n\t\t\t}\n\t\t\tstyle.left = name === \"fontSize\" ? \"1em\" : ret;\n\t\t\tret = style.pixelLeft + \"px\";\n\n\t\t\t// Revert the changed values\n\t\t\tstyle.left = left;\n\t\t\tif ( rsLeft ) {\n\t\t\t\trs.left = rsLeft;\n\t\t\t}\n\t\t}\n\n\t\t// Support: IE\n\t\t// IE returns zIndex value as an integer.\n\t\treturn ret === undefined ?\n\t\t\tret :\n\t\t\tret + \"\" || \"auto\";\n\t};\n}\n\n\n\n\nfunction addGetHookIf( conditionFn, hookFn ) {\n\t// Define the hook, we'll check on the first run if it's really needed.\n\treturn {\n\t\tget: function() {\n\t\t\tvar condition = conditionFn();\n\n\t\t\tif ( condition == null ) {\n\t\t\t\t// The test was not ready at this point; screw the hook this time\n\t\t\t\t// but check again when needed next time.\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( condition ) {\n\t\t\t\t// Hook not needed (or it's not possible to use it due to missing dependency),\n\t\t\t\t// remove it.\n\t\t\t\t// Since there are no other hooks for marginRight, remove the whole object.\n\t\t\t\tdelete this.get;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Hook needed; redefine it so that the support test is not executed again.\n\n\t\t\treturn (this.get = hookFn).apply( this, arguments );\n\t\t}\n\t};\n}\n\n\n(function() {\n\tvar a, reliableHiddenOffsetsVal, boxSizingVal, boxSizingReliableVal,\n\t\tpixelPositionVal, reliableMarginRightVal,\n\t\tdiv = document.createElement( \"div\" ),\n\t\tcontainerStyles = \"border:0;width:0;height:0;position:absolute;top:0;left:-9999px\",\n\t\tdivReset =\n\t\t\t\"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;\" +\n\t\t\t\"display:block;padding:0;margin:0;border:0\";\n\n\t// Setup\n\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\ta = div.getElementsByTagName( \"a\" )[ 0 ];\n\n\ta.style.cssText = \"float:left;opacity:.5\";\n\n\t// Make sure that element opacity exists\n\t// (IE uses filter instead)\n\t// Use a regex to work around a WebKit issue. See #5145\n\tsupport.opacity = /^0.5/.test( a.style.opacity );\n\n\t// Verify style float existence\n\t// (IE uses styleFloat instead of cssFloat)\n\tsupport.cssFloat = !!a.style.cssFloat;\n\n\tdiv.style.backgroundClip = \"content-box\";\n\tdiv.cloneNode( true ).style.backgroundClip = \"\";\n\tsupport.clearCloneStyle = div.style.backgroundClip === \"content-box\";\n\n\t// Null elements to avoid leaks in IE.\n\ta = div = null;\n\n\tjQuery.extend(support, {\n\t\treliableHiddenOffsets: function() {\n\t\t\tif ( reliableHiddenOffsetsVal != null ) {\n\t\t\t\treturn reliableHiddenOffsetsVal;\n\t\t\t}\n\n\t\t\tvar container, tds, isSupported,\n\t\t\t\tdiv = document.createElement( \"div\" ),\n\t\t\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\n\t\t\tif ( !body ) {\n\t\t\t\t// Return for frameset docs that don't have a body\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Setup\n\t\t\tdiv.setAttribute( \"className\", \"t\" );\n\t\t\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\n\t\t\tcontainer = document.createElement( \"div\" );\n\t\t\tcontainer.style.cssText = containerStyles;\n\n\t\t\tbody.appendChild( container ).appendChild( div );\n\n\t\t\t// Support: IE8\n\t\t\t// Check if table cells still have offsetWidth/Height when they are set\n\t\t\t// to display:none and there are still other visible table cells in a\n\t\t\t// table row; if so, offsetWidth/Height are not reliable for use when\n\t\t\t// determining if an element has been hidden directly using\n\t\t\t// display:none (it is still safe to use offsets if a parent element is\n\t\t\t// hidden; don safety goggles and see bug #4512 for more information).\n\t\t\tdiv.innerHTML = \"<table><tr><td></td><td>t</td></tr></table>\";\n\t\t\ttds = div.getElementsByTagName( \"td\" );\n\t\t\ttds[ 0 ].style.cssText = \"padding:0;margin:0;border:0;display:none\";\n\t\t\tisSupported = ( tds[ 0 ].offsetHeight === 0 );\n\n\t\t\ttds[ 0 ].style.display = \"\";\n\t\t\ttds[ 1 ].style.display = \"none\";\n\n\t\t\t// Support: IE8\n\t\t\t// Check if empty table cells still have offsetWidth/Height\n\t\t\treliableHiddenOffsetsVal = isSupported && ( tds[ 0 ].offsetHeight === 0 );\n\n\t\t\tbody.removeChild( container );\n\n\t\t\t// Null elements to avoid leaks in IE.\n\t\t\tdiv = body = null;\n\n\t\t\treturn reliableHiddenOffsetsVal;\n\t\t},\n\n\t\tboxSizing: function() {\n\t\t\tif ( boxSizingVal == null ) {\n\t\t\t\tcomputeStyleTests();\n\t\t\t}\n\t\t\treturn boxSizingVal;\n\t\t},\n\n\t\tboxSizingReliable: function() {\n\t\t\tif ( boxSizingReliableVal == null ) {\n\t\t\t\tcomputeStyleTests();\n\t\t\t}\n\t\t\treturn boxSizingReliableVal;\n\t\t},\n\n\t\tpixelPosition: function() {\n\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\tcomputeStyleTests();\n\t\t\t}\n\t\t\treturn pixelPositionVal;\n\t\t},\n\n\t\treliableMarginRight: function() {\n\t\t\tvar body, container, div, marginDiv;\n\n\t\t\t// Use window.getComputedStyle because jsdom on node.js will break without it.\n\t\t\tif ( reliableMarginRightVal == null && window.getComputedStyle ) {\n\t\t\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\t\t\t\tif ( !body ) {\n\t\t\t\t\t// Test fired too early or in an unsupported environment, exit.\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tcontainer = document.createElement( \"div\" );\n\t\t\t\tdiv = document.createElement( \"div\" );\n\t\t\t\tcontainer.style.cssText = containerStyles;\n\n\t\t\t\tbody.appendChild( container ).appendChild( div );\n\n\t\t\t\t// Check if div with explicit width and no margin-right incorrectly\n\t\t\t\t// gets computed margin-right based on width of container. (#3333)\n\t\t\t\t// Fails in WebKit before Feb 2011 nightlies\n\t\t\t\t// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right\n\t\t\t\tmarginDiv = div.appendChild( document.createElement( \"div\" ) );\n\t\t\t\tmarginDiv.style.cssText = div.style.cssText = divReset;\n\t\t\t\tmarginDiv.style.marginRight = marginDiv.style.width = \"0\";\n\t\t\t\tdiv.style.width = \"1px\";\n\n\t\t\t\treliableMarginRightVal =\n\t\t\t\t\t!parseFloat( ( window.getComputedStyle( marginDiv, null ) || {} ).marginRight );\n\n\t\t\t\tbody.removeChild( container );\n\t\t\t}\n\n\t\t\treturn reliableMarginRightVal;\n\t\t}\n\t});\n\n\tfunction computeStyleTests() {\n\t\tvar container, div,\n\t\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\n\t\tif ( !body ) {\n\t\t\t// Test fired too early or in an unsupported environment, exit.\n\t\t\treturn;\n\t\t}\n\n\t\tcontainer = document.createElement( \"div\" );\n\t\tdiv = document.createElement( \"div\" );\n\t\tcontainer.style.cssText = containerStyles;\n\n\t\tbody.appendChild( container ).appendChild( div );\n\n\t\tdiv.style.cssText =\n\t\t\t\"-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;\" +\n\t\t\t\t\"position:absolute;display:block;padding:1px;border:1px;width:4px;\" +\n\t\t\t\t\"margin-top:1%;top:1%\";\n\n\t\t// Workaround failing boxSizing test due to offsetWidth returning wrong value\n\t\t// with some non-1 values of body zoom, ticket #13543\n\t\tjQuery.swap( body, body.style.zoom != null ? { zoom: 1 } : {}, function() {\n\t\t\tboxSizingVal = div.offsetWidth === 4;\n\t\t});\n\n\t\t// Will be changed later if needed.\n\t\tboxSizingReliableVal = true;\n\t\tpixelPositionVal = false;\n\t\treliableMarginRightVal = true;\n\n\t\t// Use window.getComputedStyle because jsdom on node.js will break without it.\n\t\tif ( window.getComputedStyle ) {\n\t\t\tpixelPositionVal = ( window.getComputedStyle( div, null ) || {} ).top !== \"1%\";\n\t\t\tboxSizingReliableVal =\n\t\t\t\t( window.getComputedStyle( div, null ) || { width: \"4px\" } ).width === \"4px\";\n\t\t}\n\n\t\tbody.removeChild( container );\n\n\t\t// Null elements to avoid leaks in IE.\n\t\tdiv = body = null;\n\t}\n\n})();\n\n\n// A method for quickly swapping in/out CSS properties to get correct calculations.\njQuery.swap = function( elem, options, callback, args ) {\n\tvar ret, name,\n\t\told = {};\n\n\t// Remember the old values, and insert the new ones\n\tfor ( name in options ) {\n\t\told[ name ] = elem.style[ name ];\n\t\telem.style[ name ] = options[ name ];\n\t}\n\n\tret = callback.apply( elem, args || [] );\n\n\t// Revert the old values\n\tfor ( name in options ) {\n\t\telem.style[ name ] = old[ name ];\n\t}\n\n\treturn ret;\n};\n\n\nvar\n\t\tralpha = /alpha\\([^)]*\\)/i,\n\tropacity = /opacity\\s*=\\s*([^)]*)/,\n\n\t// swappable if display is none or starts with table except \"table\", \"table-cell\", or \"table-caption\"\n\t// see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display\n\trdisplayswap = /^(none|table(?!-c[ea]).+)/,\n\trnumsplit = new RegExp( \"^(\" + pnum + \")(.*)$\", \"i\" ),\n\trrelNum = new RegExp( \"^([+-])=(\" + pnum + \")\", \"i\" ),\n\n\tcssShow = { position: \"absolute\", visibility: \"hidden\", display: \"block\" },\n\tcssNormalTransform = {\n\t\tletterSpacing: 0,\n\t\tfontWeight: 400\n\t},\n\n\tcssPrefixes = [ \"Webkit\", \"O\", \"Moz\", \"ms\" ];\n\n\n// return a css property mapped to a potentially vendor prefixed property\nfunction vendorPropName( style, name ) {\n\n\t// shortcut for names that are not vendor prefixed\n\tif ( name in style ) {\n\t\treturn name;\n\t}\n\n\t// check for vendor prefixed names\n\tvar capName = name.charAt(0).toUpperCase() + name.slice(1),\n\t\torigName = name,\n\t\ti = cssPrefixes.length;\n\n\twhile ( i-- ) {\n\t\tname = cssPrefixes[ i ] + capName;\n\t\tif ( name in style ) {\n\t\t\treturn name;\n\t\t}\n\t}\n\n\treturn origName;\n}\n\nfunction showHide( elements, show ) {\n\tvar display, elem, hidden,\n\t\tvalues = [],\n\t\tindex = 0,\n\t\tlength = elements.length;\n\n\tfor ( ; index < length; index++ ) {\n\t\telem = elements[ index ];\n\t\tif ( !elem.style ) {\n\t\t\tcontinue;\n\t\t}\n\n\t\tvalues[ index ] = jQuery._data( elem, \"olddisplay\" );\n\t\tdisplay = elem.style.display;\n\t\tif ( show ) {\n\t\t\t// Reset the inline display of this element to learn if it is\n\t\t\t// being hidden by cascaded rules or not\n\t\t\tif ( !values[ index ] && display === \"none\" ) {\n\t\t\t\telem.style.display = \"\";\n\t\t\t}\n\n\t\t\t// Set elements which have been overridden with display: none\n\t\t\t// in a stylesheet to whatever the default browser style is\n\t\t\t// for such an element\n\t\t\tif ( elem.style.display === \"\" && isHidden( elem ) ) {\n\t\t\t\tvalues[ index ] = jQuery._data( elem, \"olddisplay\", defaultDisplay(elem.nodeName) );\n\t\t\t}\n\t\t} else {\n\n\t\t\tif ( !values[ index ] ) {\n\t\t\t\thidden = isHidden( elem );\n\n\t\t\t\tif ( display && display !== \"none\" || !hidden ) {\n\t\t\t\t\tjQuery._data( elem, \"olddisplay\", hidden ? display : jQuery.css( elem, \"display\" ) );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\t// Set the display of most of the elements in a second loop\n\t// to avoid the constant reflow\n\tfor ( index = 0; index < length; index++ ) {\n\t\telem = elements[ index ];\n\t\tif ( !elem.style ) {\n\t\t\tcontinue;\n\t\t}\n\t\tif ( !show || elem.style.display === \"none\" || elem.style.display === \"\" ) {\n\t\t\telem.style.display = show ? values[ index ] || \"\" : \"none\";\n\t\t}\n\t}\n\n\treturn elements;\n}\n\nfunction setPositiveNumber( elem, value, subtract ) {\n\tvar matches = rnumsplit.exec( value );\n\treturn matches ?\n\t\t// Guard against undefined \"subtract\", e.g., when used as in cssHooks\n\t\tMath.max( 0, matches[ 1 ] - ( subtract || 0 ) ) + ( matches[ 2 ] || \"px\" ) :\n\t\tvalue;\n}\n\nfunction augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {\n\tvar i = extra === ( isBorderBox ? \"border\" : \"content\" ) ?\n\t\t// If we already have the right measurement, avoid augmentation\n\t\t4 :\n\t\t// Otherwise initialize for horizontal or vertical properties\n\t\tname === \"width\" ? 1 : 0,\n\n\t\tval = 0;\n\n\tfor ( ; i < 4; i += 2 ) {\n\t\t// both box models exclude margin, so add it if we want it\n\t\tif ( extra === \"margin\" ) {\n\t\t\tval += jQuery.css( elem, extra + cssExpand[ i ], true, styles );\n\t\t}\n\n\t\tif ( isBorderBox ) {\n\t\t\t// border-box includes padding, so remove it if we want content\n\t\t\tif ( extra === \"content\" ) {\n\t\t\t\tval -= jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\t\t\t}\n\n\t\t\t// at this point, extra isn't border nor margin, so remove border\n\t\t\tif ( extra !== \"margin\" ) {\n\t\t\t\tval -= jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\t\t\t}\n\t\t} else {\n\t\t\t// at this point, extra isn't content, so add padding\n\t\t\tval += jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\n\t\t\t// at this point, extra isn't content nor padding, so add border\n\t\t\tif ( extra !== \"padding\" ) {\n\t\t\t\tval += jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\t\t\t}\n\t\t}\n\t}\n\n\treturn val;\n}\n\nfunction getWidthOrHeight( elem, name, extra ) {\n\n\t// Start with offset property, which is equivalent to the border-box value\n\tvar valueIsBorderBox = true,\n\t\tval = name === \"width\" ? elem.offsetWidth : elem.offsetHeight,\n\t\tstyles = getStyles( elem ),\n\t\tisBorderBox = support.boxSizing() && jQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\";\n\n\t// some non-html elements return undefined for offsetWidth, so check for null/undefined\n\t// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285\n\t// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668\n\tif ( val <= 0 || val == null ) {\n\t\t// Fall back to computed then uncomputed css if necessary\n\t\tval = curCSS( elem, name, styles );\n\t\tif ( val < 0 || val == null ) {\n\t\t\tval = elem.style[ name ];\n\t\t}\n\n\t\t// Computed unit is not pixels. Stop here and return.\n\t\tif ( rnumnonpx.test(val) ) {\n\t\t\treturn val;\n\t\t}\n\n\t\t// we need the check for style in case a browser which returns unreliable values\n\t\t// for getComputedStyle silently falls back to the reliable elem.style\n\t\tvalueIsBorderBox = isBorderBox && ( support.boxSizingReliable() || val === elem.style[ name ] );\n\n\t\t// Normalize \"\", auto, and prepare for extra\n\t\tval = parseFloat( val ) || 0;\n\t}\n\n\t// use the active box-sizing model to add/subtract irrelevant styles\n\treturn ( val +\n\t\taugmentWidthOrHeight(\n\t\t\telem,\n\t\t\tname,\n\t\t\textra || ( isBorderBox ? \"border\" : \"content\" ),\n\t\t\tvalueIsBorderBox,\n\t\t\tstyles\n\t\t)\n\t) + \"px\";\n}\n\njQuery.extend({\n\t// Add in style property hooks for overriding the default\n\t// behavior of getting and setting a style property\n\tcssHooks: {\n\t\topacity: {\n\t\t\tget: function( elem, computed ) {\n\t\t\t\tif ( computed ) {\n\t\t\t\t\t// We should always get a number back from opacity\n\t\t\t\t\tvar ret = curCSS( elem, \"opacity\" );\n\t\t\t\t\treturn ret === \"\" ? \"1\" : ret;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\n\t// Don't automatically add \"px\" to these possibly-unitless properties\n\tcssNumber: {\n\t\t\"columnCount\": true,\n\t\t\"fillOpacity\": true,\n\t\t\"fontWeight\": true,\n\t\t\"lineHeight\": true,\n\t\t\"opacity\": true,\n\t\t\"order\": true,\n\t\t\"orphans\": true,\n\t\t\"widows\": true,\n\t\t\"zIndex\": true,\n\t\t\"zoom\": true\n\t},\n\n\t// Add in properties whose names you wish to fix before\n\t// setting or getting the value\n\tcssProps: {\n\t\t// normalize float css property\n\t\t\"float\": support.cssFloat ? \"cssFloat\" : \"styleFloat\"\n\t},\n\n\t// Get and set the style property on a DOM Node\n\tstyle: function( elem, name, value, extra ) {\n\t\t// Don't set styles on text and comment nodes\n\t\tif ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Make sure that we're working with the right name\n\t\tvar ret, type, hooks,\n\t\t\torigName = jQuery.camelCase( name ),\n\t\t\tstyle = elem.style;\n\n\t\tname = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( style, origName ) );\n\n\t\t// gets hook for the prefixed version\n\t\t// followed by the unprefixed version\n\t\thooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n\t\t// Check if we're setting a value\n\t\tif ( value !== undefined ) {\n\t\t\ttype = typeof value;\n\n\t\t\t// convert relative number strings (+= or -=) to relative numbers. #7345\n\t\t\tif ( type === \"string\" && (ret = rrelNum.exec( value )) ) {\n\t\t\t\tvalue = ( ret[1] + 1 ) * ret[2] + parseFloat( jQuery.css( elem, name ) );\n\t\t\t\t// Fixes bug #9237\n\t\t\t\ttype = \"number\";\n\t\t\t}\n\n\t\t\t// Make sure that null and NaN values aren't set. See: #7116\n\t\t\tif ( value == null || value !== value ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If a number was passed in, add 'px' to the (except for certain CSS properties)\n\t\t\tif ( type === \"number\" && !jQuery.cssNumber[ origName ] ) {\n\t\t\t\tvalue += \"px\";\n\t\t\t}\n\n\t\t\t// Fixes #8908, it can be done more correctly by specifing setters in cssHooks,\n\t\t\t// but it would mean to define eight (for every problematic property) identical functions\n\t\t\tif ( !support.clearCloneStyle && value === \"\" && name.indexOf(\"background\") === 0 ) {\n\t\t\t\tstyle[ name ] = \"inherit\";\n\t\t\t}\n\n\t\t\t// If a hook was provided, use that value, otherwise just set the specified value\n\t\t\tif ( !hooks || !(\"set\" in hooks) || (value = hooks.set( elem, value, extra )) !== undefined ) {\n\n\t\t\t\t// Support: IE\n\t\t\t\t// Swallow errors from 'invalid' CSS values (#5509)\n\t\t\t\ttry {\n\t\t\t\t\t// Support: Chrome, Safari\n\t\t\t\t\t// Setting style to blank string required to delete \"style: x !important;\"\n\t\t\t\t\tstyle[ name ] = \"\";\n\t\t\t\t\tstyle[ name ] = value;\n\t\t\t\t} catch(e) {}\n\t\t\t}\n\n\t\t} else {\n\t\t\t// If a hook was provided get the non-computed value from there\n\t\t\tif ( hooks && \"get\" in hooks && (ret = hooks.get( elem, false, extra )) !== undefined ) {\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\t// Otherwise just get the value from the style object\n\t\t\treturn style[ name ];\n\t\t}\n\t},\n\n\tcss: function( elem, name, extra, styles ) {\n\t\tvar num, val, hooks,\n\t\t\torigName = jQuery.camelCase( name );\n\n\t\t// Make sure that we're working with the right name\n\t\tname = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( elem.style, origName ) );\n\n\t\t// gets hook for the prefixed version\n\t\t// followed by the unprefixed version\n\t\thooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n\t\t// If a hook was provided get the computed value from there\n\t\tif ( hooks && \"get\" in hooks ) {\n\t\t\tval = hooks.get( elem, true, extra );\n\t\t}\n\n\t\t// Otherwise, if a way to get the computed value exists, use that\n\t\tif ( val === undefined ) {\n\t\t\tval = curCSS( elem, name, styles );\n\t\t}\n\n\t\t//convert \"normal\" to computed value\n\t\tif ( val === \"normal\" && name in cssNormalTransform ) {\n\t\t\tval = cssNormalTransform[ name ];\n\t\t}\n\n\t\t// Return, converting to number if forced or a qualifier was provided and val looks numeric\n\t\tif ( extra === \"\" || extra ) {\n\t\t\tnum = parseFloat( val );\n\t\t\treturn extra === true || jQuery.isNumeric( num ) ? num || 0 : val;\n\t\t}\n\t\treturn val;\n\t}\n});\n\njQuery.each([ \"height\", \"width\" ], function( i, name ) {\n\tjQuery.cssHooks[ name ] = {\n\t\tget: function( elem, computed, extra ) {\n\t\t\tif ( computed ) {\n\t\t\t\t// certain elements can have dimension info if we invisibly show them\n\t\t\t\t// however, it must have a current display style that would benefit from this\n\t\t\t\treturn elem.offsetWidth === 0 && rdisplayswap.test( jQuery.css( elem, \"display\" ) ) ?\n\t\t\t\t\tjQuery.swap( elem, cssShow, function() {\n\t\t\t\t\t\treturn getWidthOrHeight( elem, name, extra );\n\t\t\t\t\t}) :\n\t\t\t\t\tgetWidthOrHeight( elem, name, extra );\n\t\t\t}\n\t\t},\n\n\t\tset: function( elem, value, extra ) {\n\t\t\tvar styles = extra && getStyles( elem );\n\t\t\treturn setPositiveNumber( elem, value, extra ?\n\t\t\t\taugmentWidthOrHeight(\n\t\t\t\t\telem,\n\t\t\t\t\tname,\n\t\t\t\t\textra,\n\t\t\t\t\tsupport.boxSizing() && jQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\",\n\t\t\t\t\tstyles\n\t\t\t\t) : 0\n\t\t\t);\n\t\t}\n\t};\n});\n\nif ( !support.opacity ) {\n\tjQuery.cssHooks.opacity = {\n\t\tget: function( elem, computed ) {\n\t\t\t// IE uses filters for opacity\n\t\t\treturn ropacity.test( (computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || \"\" ) ?\n\t\t\t\t( 0.01 * parseFloat( RegExp.$1 ) ) + \"\" :\n\t\t\t\tcomputed ? \"1\" : \"\";\n\t\t},\n\n\t\tset: function( elem, value ) {\n\t\t\tvar style = elem.style,\n\t\t\t\tcurrentStyle = elem.currentStyle,\n\t\t\t\topacity = jQuery.isNumeric( value ) ? \"alpha(opacity=\" + value * 100 + \")\" : \"\",\n\t\t\t\tfilter = currentStyle && currentStyle.filter || style.filter || \"\";\n\n\t\t\t// IE has trouble with opacity if it does not have layout\n\t\t\t// Force it by setting the zoom level\n\t\t\tstyle.zoom = 1;\n\n\t\t\t// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652\n\t\t\t// if value === \"\", then remove inline opacity #12685\n\t\t\tif ( ( value >= 1 || value === \"\" ) &&\n\t\t\t\t\tjQuery.trim( filter.replace( ralpha, \"\" ) ) === \"\" &&\n\t\t\t\t\tstyle.removeAttribute ) {\n\n\t\t\t\t// Setting style.filter to null, \"\" & \" \" still leave \"filter:\" in the cssText\n\t\t\t\t// if \"filter:\" is present at all, clearType is disabled, we want to avoid this\n\t\t\t\t// style.removeAttribute is IE Only, but so apparently is this code path...\n\t\t\t\tstyle.removeAttribute( \"filter\" );\n\n\t\t\t\t// if there is no filter style applied in a css rule or unset inline opacity, we are done\n\t\t\t\tif ( value === \"\" || currentStyle && !currentStyle.filter ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// otherwise, set new filter values\n\t\t\tstyle.filter = ralpha.test( filter ) ?\n\t\t\t\tfilter.replace( ralpha, opacity ) :\n\t\t\t\tfilter + \" \" + opacity;\n\t\t}\n\t};\n}\n\njQuery.cssHooks.marginRight = addGetHookIf( support.reliableMarginRight,\n\tfunction( elem, computed ) {\n\t\tif ( computed ) {\n\t\t\t// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right\n\t\t\t// Work around by temporarily setting element display to inline-block\n\t\t\treturn jQuery.swap( elem, { \"display\": \"inline-block\" },\n\t\t\t\tcurCSS, [ elem, \"marginRight\" ] );\n\t\t}\n\t}\n);\n\n// These hooks are used by animate to expand properties\njQuery.each({\n\tmargin: \"\",\n\tpadding: \"\",\n\tborder: \"Width\"\n}, function( prefix, suffix ) {\n\tjQuery.cssHooks[ prefix + suffix ] = {\n\t\texpand: function( value ) {\n\t\t\tvar i = 0,\n\t\t\t\texpanded = {},\n\n\t\t\t\t// assumes a single number if not a string\n\t\t\t\tparts = typeof value === \"string\" ? value.split(\" \") : [ value ];\n\n\t\t\tfor ( ; i < 4; i++ ) {\n\t\t\t\texpanded[ prefix + cssExpand[ i ] + suffix ] =\n\t\t\t\t\tparts[ i ] || parts[ i - 2 ] || parts[ 0 ];\n\t\t\t}\n\n\t\t\treturn expanded;\n\t\t}\n\t};\n\n\tif ( !rmargin.test( prefix ) ) {\n\t\tjQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;\n\t}\n});\n\njQuery.fn.extend({\n\tcss: function( name, value ) {\n\t\treturn access( this, function( elem, name, value ) {\n\t\t\tvar styles, len,\n\t\t\t\tmap = {},\n\t\t\t\ti = 0;\n\n\t\t\tif ( jQuery.isArray( name ) ) {\n\t\t\t\tstyles = getStyles( elem );\n\t\t\t\tlen = name.length;\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tmap[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );\n\t\t\t\t}\n\n\t\t\t\treturn map;\n\t\t\t}\n\n\t\t\treturn value !== undefined ?\n\t\t\t\tjQuery.style( elem, name, value ) :\n\t\t\t\tjQuery.css( elem, name );\n\t\t}, name, value, arguments.length > 1 );\n\t},\n\tshow: function() {\n\t\treturn showHide( this, true );\n\t},\n\thide: function() {\n\t\treturn showHide( this );\n\t},\n\ttoggle: function( state ) {\n\t\tif ( typeof state === \"boolean\" ) {\n\t\t\treturn state ? this.show() : this.hide();\n\t\t}\n\n\t\treturn this.each(function() {\n\t\t\tif ( isHidden( this ) ) {\n\t\t\t\tjQuery( this ).show();\n\t\t\t} else {\n\t\t\t\tjQuery( this ).hide();\n\t\t\t}\n\t\t});\n\t}\n});\n\n\nfunction Tween( elem, options, prop, end, easing ) {\n\treturn new Tween.prototype.init( elem, options, prop, end, easing );\n}\njQuery.Tween = Tween;\n\nTween.prototype = {\n\tconstructor: Tween,\n\tinit: function( elem, options, prop, end, easing, unit ) {\n\t\tthis.elem = elem;\n\t\tthis.prop = prop;\n\t\tthis.easing = easing || \"swing\";\n\t\tthis.options = options;\n\t\tthis.start = this.now = this.cur();\n\t\tthis.end = end;\n\t\tthis.unit = unit || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" );\n\t},\n\tcur: function() {\n\t\tvar hooks = Tween.propHooks[ this.prop ];\n\n\t\treturn hooks && hooks.get ?\n\t\t\thooks.get( this ) :\n\t\t\tTween.propHooks._default.get( this );\n\t},\n\trun: function( percent ) {\n\t\tvar eased,\n\t\t\thooks = Tween.propHooks[ this.prop ];\n\n\t\tif ( this.options.duration ) {\n\t\t\tthis.pos = eased = jQuery.easing[ this.easing ](\n\t\t\t\tpercent, this.options.duration * percent, 0, 1, this.options.duration\n\t\t\t);\n\t\t} else {\n\t\t\tthis.pos = eased = percent;\n\t\t}\n\t\tthis.now = ( this.end - this.start ) * eased + this.start;\n\n\t\tif ( this.options.step ) {\n\t\t\tthis.options.step.call( this.elem, this.now, this );\n\t\t}\n\n\t\tif ( hooks && hooks.set ) {\n\t\t\thooks.set( this );\n\t\t} else {\n\t\t\tTween.propHooks._default.set( this );\n\t\t}\n\t\treturn this;\n\t}\n};\n\nTween.prototype.init.prototype = Tween.prototype;\n\nTween.propHooks = {\n\t_default: {\n\t\tget: function( tween ) {\n\t\t\tvar result;\n\n\t\t\tif ( tween.elem[ tween.prop ] != null &&\n\t\t\t\t(!tween.elem.style || tween.elem.style[ tween.prop ] == null) ) {\n\t\t\t\treturn tween.elem[ tween.prop ];\n\t\t\t}\n\n\t\t\t// passing an empty string as a 3rd parameter to .css will automatically\n\t\t\t// attempt a parseFloat and fallback to a string if the parse fails\n\t\t\t// so, simple values such as \"10px\" are parsed to Float.\n\t\t\t// complex values such as \"rotate(1rad)\" are returned as is.\n\t\t\tresult = jQuery.css( tween.elem, tween.prop, \"\" );\n\t\t\t// Empty strings, null, undefined and \"auto\" are converted to 0.\n\t\t\treturn !result || result === \"auto\" ? 0 : result;\n\t\t},\n\t\tset: function( tween ) {\n\t\t\t// use step hook for back compat - use cssHook if its there - use .style if its\n\t\t\t// available and use plain properties where available\n\t\t\tif ( jQuery.fx.step[ tween.prop ] ) {\n\t\t\t\tjQuery.fx.step[ tween.prop ]( tween );\n\t\t\t} else if ( tween.elem.style && ( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null || jQuery.cssHooks[ tween.prop ] ) ) {\n\t\t\t\tjQuery.style( tween.elem, tween.prop, tween.now + tween.unit );\n\t\t\t} else {\n\t\t\t\ttween.elem[ tween.prop ] = tween.now;\n\t\t\t}\n\t\t}\n\t}\n};\n\n// Support: IE <=9\n// Panic based approach to setting things on disconnected nodes\n\nTween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {\n\tset: function( tween ) {\n\t\tif ( tween.elem.nodeType && tween.elem.parentNode ) {\n\t\t\ttween.elem[ tween.prop ] = tween.now;\n\t\t}\n\t}\n};\n\njQuery.easing = {\n\tlinear: function( p ) {\n\t\treturn p;\n\t},\n\tswing: function( p ) {\n\t\treturn 0.5 - Math.cos( p * Math.PI ) / 2;\n\t}\n};\n\njQuery.fx = Tween.prototype.init;\n\n// Back Compat <1.8 extension point\njQuery.fx.step = {};\n\n\n\n\nvar\n\tfxNow, timerId,\n\trfxtypes = /^(?:toggle|show|hide)$/,\n\trfxnum = new RegExp( \"^(?:([+-])=|)(\" + pnum + \")([a-z%]*)$\", \"i\" ),\n\trrun = /queueHooks$/,\n\tanimationPrefilters = [ defaultPrefilter ],\n\ttweeners = {\n\t\t\"*\": [ function( prop, value ) {\n\t\t\tvar tween = this.createTween( prop, value ),\n\t\t\t\ttarget = tween.cur(),\n\t\t\t\tparts = rfxnum.exec( value ),\n\t\t\t\tunit = parts && parts[ 3 ] || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" ),\n\n\t\t\t\t// Starting value computation is required for potential unit mismatches\n\t\t\t\tstart = ( jQuery.cssNumber[ prop ] || unit !== \"px\" && +target ) &&\n\t\t\t\t\trfxnum.exec( jQuery.css( tween.elem, prop ) ),\n\t\t\t\tscale = 1,\n\t\t\t\tmaxIterations = 20;\n\n\t\t\tif ( start && start[ 3 ] !== unit ) {\n\t\t\t\t// Trust units reported by jQuery.css\n\t\t\t\tunit = unit || start[ 3 ];\n\n\t\t\t\t// Make sure we update the tween properties later on\n\t\t\t\tparts = parts || [];\n\n\t\t\t\t// Iteratively approximate from a nonzero starting point\n\t\t\t\tstart = +target || 1;\n\n\t\t\t\tdo {\n\t\t\t\t\t// If previous iteration zeroed out, double until we get *something*\n\t\t\t\t\t// Use a string for doubling factor so we don't accidentally see scale as unchanged below\n\t\t\t\t\tscale = scale || \".5\";\n\n\t\t\t\t\t// Adjust and apply\n\t\t\t\t\tstart = start / scale;\n\t\t\t\t\tjQuery.style( tween.elem, prop, start + unit );\n\n\t\t\t\t// Update scale, tolerating zero or NaN from tween.cur()\n\t\t\t\t// And breaking the loop if scale is unchanged or perfect, or if we've just had enough\n\t\t\t\t} while ( scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations );\n\t\t\t}\n\n\t\t\t// Update tween properties\n\t\t\tif ( parts ) {\n\t\t\t\tstart = tween.start = +start || +target || 0;\n\t\t\t\ttween.unit = unit;\n\t\t\t\t// If a +=/-= token was provided, we're doing a relative animation\n\t\t\t\ttween.end = parts[ 1 ] ?\n\t\t\t\t\tstart + ( parts[ 1 ] + 1 ) * parts[ 2 ] :\n\t\t\t\t\t+parts[ 2 ];\n\t\t\t}\n\n\t\t\treturn tween;\n\t\t} ]\n\t};\n\n// Animations created synchronously will run synchronously\nfunction createFxNow() {\n\tsetTimeout(function() {\n\t\tfxNow = undefined;\n\t});\n\treturn ( fxNow = jQuery.now() );\n}\n\n// Generate parameters to create a standard animation\nfunction genFx( type, includeWidth ) {\n\tvar which,\n\t\tattrs = { height: type },\n\t\ti = 0;\n\n\t// if we include width, step value is 1 to do all cssExpand values,\n\t// if we don't include width, step value is 2 to skip over Left and Right\n\tincludeWidth = includeWidth ? 1 : 0;\n\tfor ( ; i < 4 ; i += 2 - includeWidth ) {\n\t\twhich = cssExpand[ i ];\n\t\tattrs[ \"margin\" + which ] = attrs[ \"padding\" + which ] = type;\n\t}\n\n\tif ( includeWidth ) {\n\t\tattrs.opacity = attrs.width = type;\n\t}\n\n\treturn attrs;\n}\n\nfunction createTween( value, prop, animation ) {\n\tvar tween,\n\t\tcollection = ( tweeners[ prop ] || [] ).concat( tweeners[ \"*\" ] ),\n\t\tindex = 0,\n\t\tlength = collection.length;\n\tfor ( ; index < length; index++ ) {\n\t\tif ( (tween = collection[ index ].call( animation, prop, value )) ) {\n\n\t\t\t// we're done with this property\n\t\t\treturn tween;\n\t\t}\n\t}\n}\n\nfunction defaultPrefilter( elem, props, opts ) {\n\t/* jshint validthis: true */\n\tvar prop, value, toggle, tween, hooks, oldfire, display, dDisplay,\n\t\tanim = this,\n\t\torig = {},\n\t\tstyle = elem.style,\n\t\thidden = elem.nodeType && isHidden( elem ),\n\t\tdataShow = jQuery._data( elem, \"fxshow\" );\n\n\t// handle queue: false promises\n\tif ( !opts.queue ) {\n\t\thooks = jQuery._queueHooks( elem, \"fx\" );\n\t\tif ( hooks.unqueued == null ) {\n\t\t\thooks.unqueued = 0;\n\t\t\toldfire = hooks.empty.fire;\n\t\t\thooks.empty.fire = function() {\n\t\t\t\tif ( !hooks.unqueued ) {\n\t\t\t\t\toldfire();\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t\thooks.unqueued++;\n\n\t\tanim.always(function() {\n\t\t\t// doing this makes sure that the complete handler will be called\n\t\t\t// before this completes\n\t\t\tanim.always(function() {\n\t\t\t\thooks.unqueued--;\n\t\t\t\tif ( !jQuery.queue( elem, \"fx\" ).length ) {\n\t\t\t\t\thooks.empty.fire();\n\t\t\t\t}\n\t\t\t});\n\t\t});\n\t}\n\n\t// height/width overflow pass\n\tif ( elem.nodeType === 1 && ( \"height\" in props || \"width\" in props ) ) {\n\t\t// Make sure that nothing sneaks out\n\t\t// Record all 3 overflow attributes because IE does not\n\t\t// change the overflow attribute when overflowX and\n\t\t// overflowY are set to the same value\n\t\topts.overflow = [ style.overflow, style.overflowX, style.overflowY ];\n\n\t\t// Set display property to inline-block for height/width\n\t\t// animations on inline elements that are having width/height animated\n\t\tdisplay = jQuery.css( elem, \"display\" );\n\t\tdDisplay = defaultDisplay( elem.nodeName );\n\t\tif ( display === \"none\" ) {\n\t\t\tdisplay = dDisplay;\n\t\t}\n\t\tif ( display === \"inline\" &&\n\t\t\t\tjQuery.css( elem, \"float\" ) === \"none\" ) {\n\n\t\t\t// inline-level elements accept inline-block;\n\t\t\t// block-level elements need to be inline with layout\n\t\t\tif ( !support.inlineBlockNeedsLayout || dDisplay === \"inline\" ) {\n\t\t\t\tstyle.display = \"inline-block\";\n\t\t\t} else {\n\t\t\t\tstyle.zoom = 1;\n\t\t\t}\n\t\t}\n\t}\n\n\tif ( opts.overflow ) {\n\t\tstyle.overflow = \"hidden\";\n\t\tif ( !support.shrinkWrapBlocks() ) {\n\t\t\tanim.always(function() {\n\t\t\t\tstyle.overflow = opts.overflow[ 0 ];\n\t\t\t\tstyle.overflowX = opts.overflow[ 1 ];\n\t\t\t\tstyle.overflowY = opts.overflow[ 2 ];\n\t\t\t});\n\t\t}\n\t}\n\n\t// show/hide pass\n\tfor ( prop in props ) {\n\t\tvalue = props[ prop ];\n\t\tif ( rfxtypes.exec( value ) ) {\n\t\t\tdelete props[ prop ];\n\t\t\ttoggle = toggle || value === \"toggle\";\n\t\t\tif ( value === ( hidden ? \"hide\" : \"show\" ) ) {\n\n\t\t\t\t// If there is dataShow left over from a stopped hide or show and we are going to proceed with show, we should pretend to be hidden\n\t\t\t\tif ( value === \"show\" && dataShow && dataShow[ prop ] !== undefined ) {\n\t\t\t\t\thidden = true;\n\t\t\t\t} else {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\t\t\t}\n\t\t\torig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );\n\t\t}\n\t}\n\n\tif ( !jQuery.isEmptyObject( orig ) ) {\n\t\tif ( dataShow ) {\n\t\t\tif ( \"hidden\" in dataShow ) {\n\t\t\t\thidden = dataShow.hidden;\n\t\t\t}\n\t\t} else {\n\t\t\tdataShow = jQuery._data( elem, \"fxshow\", {} );\n\t\t}\n\n\t\t// store state if its toggle - enables .stop().toggle() to \"reverse\"\n\t\tif ( toggle ) {\n\t\t\tdataShow.hidden = !hidden;\n\t\t}\n\t\tif ( hidden ) {\n\t\t\tjQuery( elem ).show();\n\t\t} else {\n\t\t\tanim.done(function() {\n\t\t\t\tjQuery( elem ).hide();\n\t\t\t});\n\t\t}\n\t\tanim.done(function() {\n\t\t\tvar prop;\n\t\t\tjQuery._removeData( elem, \"fxshow\" );\n\t\t\tfor ( prop in orig ) {\n\t\t\t\tjQuery.style( elem, prop, orig[ prop ] );\n\t\t\t}\n\t\t});\n\t\tfor ( prop in orig ) {\n\t\t\ttween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );\n\n\t\t\tif ( !( prop in dataShow ) ) {\n\t\t\t\tdataShow[ prop ] = tween.start;\n\t\t\t\tif ( hidden ) {\n\t\t\t\t\ttween.end = tween.start;\n\t\t\t\t\ttween.start = prop === \"width\" || prop === \"height\" ? 1 : 0;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n\nfunction propFilter( props, specialEasing ) {\n\tvar index, name, easing, value, hooks;\n\n\t// camelCase, specialEasing and expand cssHook pass\n\tfor ( index in props ) {\n\t\tname = jQuery.camelCase( index );\n\t\teasing = specialEasing[ name ];\n\t\tvalue = props[ index ];\n\t\tif ( jQuery.isArray( value ) ) {\n\t\t\teasing = value[ 1 ];\n\t\t\tvalue = props[ index ] = value[ 0 ];\n\t\t}\n\n\t\tif ( index !== name ) {\n\t\t\tprops[ name ] = value;\n\t\t\tdelete props[ index ];\n\t\t}\n\n\t\thooks = jQuery.cssHooks[ name ];\n\t\tif ( hooks && \"expand\" in hooks ) {\n\t\t\tvalue = hooks.expand( value );\n\t\t\tdelete props[ name ];\n\n\t\t\t// not quite $.extend, this wont overwrite keys already present.\n\t\t\t// also - reusing 'index' from above because we have the correct \"name\"\n\t\t\tfor ( index in value ) {\n\t\t\t\tif ( !( index in props ) ) {\n\t\t\t\t\tprops[ index ] = value[ index ];\n\t\t\t\t\tspecialEasing[ index ] = easing;\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\tspecialEasing[ name ] = easing;\n\t\t}\n\t}\n}\n\nfunction Animation( elem, properties, options ) {\n\tvar result,\n\t\tstopped,\n\t\tindex = 0,\n\t\tlength = animationPrefilters.length,\n\t\tdeferred = jQuery.Deferred().always( function() {\n\t\t\t// don't match elem in the :animated selector\n\t\t\tdelete tick.elem;\n\t\t}),\n\t\ttick = function() {\n\t\t\tif ( stopped ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tvar currentTime = fxNow || createFxNow(),\n\t\t\t\tremaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),\n\t\t\t\t// archaic crash bug won't allow us to use 1 - ( 0.5 || 0 ) (#12497)\n\t\t\t\ttemp = remaining / animation.duration || 0,\n\t\t\t\tpercent = 1 - temp,\n\t\t\t\tindex = 0,\n\t\t\t\tlength = animation.tweens.length;\n\n\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\tanimation.tweens[ index ].run( percent );\n\t\t\t}\n\n\t\t\tdeferred.notifyWith( elem, [ animation, percent, remaining ]);\n\n\t\t\tif ( percent < 1 && length ) {\n\t\t\t\treturn remaining;\n\t\t\t} else {\n\t\t\t\tdeferred.resolveWith( elem, [ animation ] );\n\t\t\t\treturn false;\n\t\t\t}\n\t\t},\n\t\tanimation = deferred.promise({\n\t\t\telem: elem,\n\t\t\tprops: jQuery.extend( {}, properties ),\n\t\t\topts: jQuery.extend( true, { specialEasing: {} }, options ),\n\t\t\toriginalProperties: properties,\n\t\t\toriginalOptions: options,\n\t\t\tstartTime: fxNow || createFxNow(),\n\t\t\tduration: options.duration,\n\t\t\ttweens: [],\n\t\t\tcreateTween: function( prop, end ) {\n\t\t\t\tvar tween = jQuery.Tween( elem, animation.opts, prop, end,\n\t\t\t\t\t\tanimation.opts.specialEasing[ prop ] || animation.opts.easing );\n\t\t\t\tanimation.tweens.push( tween );\n\t\t\t\treturn tween;\n\t\t\t},\n\t\t\tstop: function( gotoEnd ) {\n\t\t\t\tvar index = 0,\n\t\t\t\t\t// if we are going to the end, we want to run all the tweens\n\t\t\t\t\t// otherwise we skip this part\n\t\t\t\t\tlength = gotoEnd ? animation.tweens.length : 0;\n\t\t\t\tif ( stopped ) {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\tstopped = true;\n\t\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\t\tanimation.tweens[ index ].run( 1 );\n\t\t\t\t}\n\n\t\t\t\t// resolve when we played the last frame\n\t\t\t\t// otherwise, reject\n\t\t\t\tif ( gotoEnd ) {\n\t\t\t\t\tdeferred.resolveWith( elem, [ animation, gotoEnd ] );\n\t\t\t\t} else {\n\t\t\t\t\tdeferred.rejectWith( elem, [ animation, gotoEnd ] );\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t}\n\t\t}),\n\t\tprops = animation.props;\n\n\tpropFilter( props, animation.opts.specialEasing );\n\n\tfor ( ; index < length ; index++ ) {\n\t\tresult = animationPrefilters[ index ].call( animation, elem, props, animation.opts );\n\t\tif ( result ) {\n\t\t\treturn result;\n\t\t}\n\t}\n\n\tjQuery.map( props, createTween, animation );\n\n\tif ( jQuery.isFunction( animation.opts.start ) ) {\n\t\tanimation.opts.start.call( elem, animation );\n\t}\n\n\tjQuery.fx.timer(\n\t\tjQuery.extend( tick, {\n\t\t\telem: elem,\n\t\t\tanim: animation,\n\t\t\tqueue: animation.opts.queue\n\t\t})\n\t);\n\n\t// attach callbacks from options\n\treturn animation.progress( animation.opts.progress )\n\t\t.done( animation.opts.done, animation.opts.complete )\n\t\t.fail( animation.opts.fail )\n\t\t.always( animation.opts.always );\n}\n\njQuery.Animation = jQuery.extend( Animation, {\n\ttweener: function( props, callback ) {\n\t\tif ( jQuery.isFunction( props ) ) {\n\t\t\tcallback = props;\n\t\t\tprops = [ \"*\" ];\n\t\t} else {\n\t\t\tprops = props.split(\" \");\n\t\t}\n\n\t\tvar prop,\n\t\t\tindex = 0,\n\t\t\tlength = props.length;\n\n\t\tfor ( ; index < length ; index++ ) {\n\t\t\tprop = props[ index ];\n\t\t\ttweeners[ prop ] = tweeners[ prop ] || [];\n\t\t\ttweeners[ prop ].unshift( callback );\n\t\t}\n\t},\n\n\tprefilter: function( callback, prepend ) {\n\t\tif ( prepend ) {\n\t\t\tanimationPrefilters.unshift( callback );\n\t\t} else {\n\t\t\tanimationPrefilters.push( callback );\n\t\t}\n\t}\n});\n\njQuery.speed = function( speed, easing, fn ) {\n\tvar opt = speed && typeof speed === \"object\" ? jQuery.extend( {}, speed ) : {\n\t\tcomplete: fn || !fn && easing ||\n\t\t\tjQuery.isFunction( speed ) && speed,\n\t\tduration: speed,\n\t\teasing: fn && easing || easing && !jQuery.isFunction( easing ) && easing\n\t};\n\n\topt.duration = jQuery.fx.off ? 0 : typeof opt.duration === \"number\" ? opt.duration :\n\t\topt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;\n\n\t// normalize opt.queue - true/undefined/null -> \"fx\"\n\tif ( opt.queue == null || opt.queue === true ) {\n\t\topt.queue = \"fx\";\n\t}\n\n\t// Queueing\n\topt.old = opt.complete;\n\n\topt.complete = function() {\n\t\tif ( jQuery.isFunction( opt.old ) ) {\n\t\t\topt.old.call( this );\n\t\t}\n\n\t\tif ( opt.queue ) {\n\t\t\tjQuery.dequeue( this, opt.queue );\n\t\t}\n\t};\n\n\treturn opt;\n};\n\njQuery.fn.extend({\n\tfadeTo: function( speed, to, easing, callback ) {\n\n\t\t// show any hidden elements after setting opacity to 0\n\t\treturn this.filter( isHidden ).css( \"opacity\", 0 ).show()\n\n\t\t\t// animate to the value specified\n\t\t\t.end().animate({ opacity: to }, speed, easing, callback );\n\t},\n\tanimate: function( prop, speed, easing, callback ) {\n\t\tvar empty = jQuery.isEmptyObject( prop ),\n\t\t\toptall = jQuery.speed( speed, easing, callback ),\n\t\t\tdoAnimation = function() {\n\t\t\t\t// Operate on a copy of prop so per-property easing won't be lost\n\t\t\t\tvar anim = Animation( this, jQuery.extend( {}, prop ), optall );\n\n\t\t\t\t// Empty animations, or finishing resolves immediately\n\t\t\t\tif ( empty || jQuery._data( this, \"finish\" ) ) {\n\t\t\t\t\tanim.stop( true );\n\t\t\t\t}\n\t\t\t};\n\t\t\tdoAnimation.finish = doAnimation;\n\n\t\treturn empty || optall.queue === false ?\n\t\t\tthis.each( doAnimation ) :\n\t\t\tthis.queue( optall.queue, doAnimation );\n\t},\n\tstop: function( type, clearQueue, gotoEnd ) {\n\t\tvar stopQueue = function( hooks ) {\n\t\t\tvar stop = hooks.stop;\n\t\t\tdelete hooks.stop;\n\t\t\tstop( gotoEnd );\n\t\t};\n\n\t\tif ( typeof type !== \"string\" ) {\n\t\t\tgotoEnd = clearQueue;\n\t\t\tclearQueue = type;\n\t\t\ttype = undefined;\n\t\t}\n\t\tif ( clearQueue && type !== false ) {\n\t\t\tthis.queue( type || \"fx\", [] );\n\t\t}\n\n\t\treturn this.each(function() {\n\t\t\tvar dequeue = true,\n\t\t\t\tindex = type != null && type + \"queueHooks\",\n\t\t\t\ttimers = jQuery.timers,\n\t\t\t\tdata = jQuery._data( this );\n\n\t\t\tif ( index ) {\n\t\t\t\tif ( data[ index ] && data[ index ].stop ) {\n\t\t\t\t\tstopQueue( data[ index ] );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( index in data ) {\n\t\t\t\t\tif ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {\n\t\t\t\t\t\tstopQueue( data[ index ] );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfor ( index = timers.length; index--; ) {\n\t\t\t\tif ( timers[ index ].elem === this && (type == null || timers[ index ].queue === type) ) {\n\t\t\t\t\ttimers[ index ].anim.stop( gotoEnd );\n\t\t\t\t\tdequeue = false;\n\t\t\t\t\ttimers.splice( index, 1 );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// start the next in the queue if the last step wasn't forced\n\t\t\t// timers currently will call their complete callbacks, which will dequeue\n\t\t\t// but only if they were gotoEnd\n\t\t\tif ( dequeue || !gotoEnd ) {\n\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t}\n\t\t});\n\t},\n\tfinish: function( type ) {\n\t\tif ( type !== false ) {\n\t\t\ttype = type || \"fx\";\n\t\t}\n\t\treturn this.each(function() {\n\t\t\tvar index,\n\t\t\t\tdata = jQuery._data( this ),\n\t\t\t\tqueue = data[ type + \"queue\" ],\n\t\t\t\thooks = data[ type + \"queueHooks\" ],\n\t\t\t\ttimers = jQuery.timers,\n\t\t\t\tlength = queue ? queue.length : 0;\n\n\t\t\t// enable finishing flag on private data\n\t\t\tdata.finish = true;\n\n\t\t\t// empty the queue first\n\t\t\tjQuery.queue( this, type, [] );\n\n\t\t\tif ( hooks && hooks.stop ) {\n\t\t\t\thooks.stop.call( this, true );\n\t\t\t}\n\n\t\t\t// look for any active animations, and finish them\n\t\t\tfor ( index = timers.length; index--; ) {\n\t\t\t\tif ( timers[ index ].elem === this && timers[ index ].queue === type ) {\n\t\t\t\t\ttimers[ index ].anim.stop( true );\n\t\t\t\t\ttimers.splice( index, 1 );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// look for any animations in the old queue and finish them\n\t\t\tfor ( index = 0; index < length; index++ ) {\n\t\t\t\tif ( queue[ index ] && queue[ index ].finish ) {\n\t\t\t\t\tqueue[ index ].finish.call( this );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// turn off finishing flag\n\t\t\tdelete data.finish;\n\t\t});\n\t}\n});\n\njQuery.each([ \"toggle\", \"show\", \"hide\" ], function( i, name ) {\n\tvar cssFn = jQuery.fn[ name ];\n\tjQuery.fn[ name ] = function( speed, easing, callback ) {\n\t\treturn speed == null || typeof speed === \"boolean\" ?\n\t\t\tcssFn.apply( this, arguments ) :\n\t\t\tthis.animate( genFx( name, true ), speed, easing, callback );\n\t};\n});\n\n// Generate shortcuts for custom animations\njQuery.each({\n\tslideDown: genFx(\"show\"),\n\tslideUp: genFx(\"hide\"),\n\tslideToggle: genFx(\"toggle\"),\n\tfadeIn: { opacity: \"show\" },\n\tfadeOut: { opacity: \"hide\" },\n\tfadeToggle: { opacity: \"toggle\" }\n}, function( name, props ) {\n\tjQuery.fn[ name ] = function( speed, easing, callback ) {\n\t\treturn this.animate( props, speed, easing, callback );\n\t};\n});\n\njQuery.timers = [];\njQuery.fx.tick = function() {\n\tvar timer,\n\t\ttimers = jQuery.timers,\n\t\ti = 0;\n\n\tfxNow = jQuery.now();\n\n\tfor ( ; i < timers.length; i++ ) {\n\t\ttimer = timers[ i ];\n\t\t// Checks the timer has not already been removed\n\t\tif ( !timer() && timers[ i ] === timer ) {\n\t\t\ttimers.splice( i--, 1 );\n\t\t}\n\t}\n\n\tif ( !timers.length ) {\n\t\tjQuery.fx.stop();\n\t}\n\tfxNow = undefined;\n};\n\njQuery.fx.timer = function( timer ) {\n\tjQuery.timers.push( timer );\n\tif ( timer() ) {\n\t\tjQuery.fx.start();\n\t} else {\n\t\tjQuery.timers.pop();\n\t}\n};\n\njQuery.fx.interval = 13;\n\njQuery.fx.start = function() {\n\tif ( !timerId ) {\n\t\ttimerId = setInterval( jQuery.fx.tick, jQuery.fx.interval );\n\t}\n};\n\njQuery.fx.stop = function() {\n\tclearInterval( timerId );\n\ttimerId = null;\n};\n\njQuery.fx.speeds = {\n\tslow: 600,\n\tfast: 200,\n\t// Default speed\n\t_default: 400\n};\n\n\n// Based off of the plugin by Clint Helfers, with permission.\n// http://blindsignals.com/index.php/2009/07/jquery-delay/\njQuery.fn.delay = function( time, type ) {\n\ttime = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;\n\ttype = type || \"fx\";\n\n\treturn this.queue( type, function( next, hooks ) {\n\t\tvar timeout = setTimeout( next, time );\n\t\thooks.stop = function() {\n\t\t\tclearTimeout( timeout );\n\t\t};\n\t});\n};\n\n\n(function() {\n\tvar a, input, select, opt,\n\t\tdiv = document.createElement(\"div\" );\n\n\t// Setup\n\tdiv.setAttribute( \"className\", \"t\" );\n\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\ta = div.getElementsByTagName(\"a\")[ 0 ];\n\n\t// First batch of tests.\n\tselect = document.createElement(\"select\");\n\topt = select.appendChild( document.createElement(\"option\") );\n\tinput = div.getElementsByTagName(\"input\")[ 0 ];\n\n\ta.style.cssText = \"top:1px\";\n\n\t// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)\n\tsupport.getSetAttribute = div.className !== \"t\";\n\n\t// Get the style information from getAttribute\n\t// (IE uses .cssText instead)\n\tsupport.style = /top/.test( a.getAttribute(\"style\") );\n\n\t// Make sure that URLs aren't manipulated\n\t// (IE normalizes it by default)\n\tsupport.hrefNormalized = a.getAttribute(\"href\") === \"/a\";\n\n\t// Check the default checkbox/radio value (\"\" on WebKit; \"on\" elsewhere)\n\tsupport.checkOn = !!input.value;\n\n\t// Make sure that a selected-by-default option has a working selected property.\n\t// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)\n\tsupport.optSelected = opt.selected;\n\n\t// Tests for enctype support on a form (#6743)\n\tsupport.enctype = !!document.createElement(\"form\").enctype;\n\n\t// Make sure that the options inside disabled selects aren't marked as disabled\n\t// (WebKit marks them as disabled)\n\tselect.disabled = true;\n\tsupport.optDisabled = !opt.disabled;\n\n\t// Support: IE8 only\n\t// Check if we can trust getAttribute(\"value\")\n\tinput = document.createElement( \"input\" );\n\tinput.setAttribute( \"value\", \"\" );\n\tsupport.input = input.getAttribute( \"value\" ) === \"\";\n\n\t// Check if an input maintains its value after becoming a radio\n\tinput.value = \"t\";\n\tinput.setAttribute( \"type\", \"radio\" );\n\tsupport.radioValue = input.value === \"t\";\n\n\t// Null elements to avoid leaks in IE.\n\ta = input = select = opt = div = null;\n})();\n\n\nvar rreturn = /\\r/g;\n\njQuery.fn.extend({\n\tval: function( value ) {\n\t\tvar hooks, ret, isFunction,\n\t\t\telem = this[0];\n\n\t\tif ( !arguments.length ) {\n\t\t\tif ( elem ) {\n\t\t\t\thooks = jQuery.valHooks[ elem.type ] || jQuery.valHooks[ elem.nodeName.toLowerCase() ];\n\n\t\t\t\tif ( hooks && \"get\" in hooks && (ret = hooks.get( elem, \"value\" )) !== undefined ) {\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\tret = elem.value;\n\n\t\t\t\treturn typeof ret === \"string\" ?\n\t\t\t\t\t// handle most common string cases\n\t\t\t\t\tret.replace(rreturn, \"\") :\n\t\t\t\t\t// handle cases where value is null/undef or number\n\t\t\t\t\tret == null ? \"\" : ret;\n\t\t\t}\n\n\t\t\treturn;\n\t\t}\n\n\t\tisFunction = jQuery.isFunction( value );\n\n\t\treturn this.each(function( i ) {\n\t\t\tvar val;\n\n\t\t\tif ( this.nodeType !== 1 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( isFunction ) {\n\t\t\t\tval = value.call( this, i, jQuery( this ).val() );\n\t\t\t} else {\n\t\t\t\tval = value;\n\t\t\t}\n\n\t\t\t// Treat null/undefined as \"\"; convert numbers to string\n\t\t\tif ( val == null ) {\n\t\t\t\tval = \"\";\n\t\t\t} else if ( typeof val === \"number\" ) {\n\t\t\t\tval += \"\";\n\t\t\t} else if ( jQuery.isArray( val ) ) {\n\t\t\t\tval = jQuery.map( val, function( value ) {\n\t\t\t\t\treturn value == null ? \"\" : value + \"\";\n\t\t\t\t});\n\t\t\t}\n\n\t\t\thooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];\n\n\t\t\t// If set returns undefined, fall back to normal setting\n\t\t\tif ( !hooks || !(\"set\" in hooks) || hooks.set( this, val, \"value\" ) === undefined ) {\n\t\t\t\tthis.value = val;\n\t\t\t}\n\t\t});\n\t}\n});\n\njQuery.extend({\n\tvalHooks: {\n\t\toption: {\n\t\t\tget: function( elem ) {\n\t\t\t\tvar val = jQuery.find.attr( elem, \"value\" );\n\t\t\t\treturn val != null ?\n\t\t\t\t\tval :\n\t\t\t\t\tjQuery.text( elem );\n\t\t\t}\n\t\t},\n\t\tselect: {\n\t\t\tget: function( elem ) {\n\t\t\t\tvar value, option,\n\t\t\t\t\toptions = elem.options,\n\t\t\t\t\tindex = elem.selectedIndex,\n\t\t\t\t\tone = elem.type === \"select-one\" || index < 0,\n\t\t\t\t\tvalues = one ? null : [],\n\t\t\t\t\tmax = one ? index + 1 : options.length,\n\t\t\t\t\ti = index < 0 ?\n\t\t\t\t\t\tmax :\n\t\t\t\t\t\tone ? index : 0;\n\n\t\t\t\t// Loop through all the selected options\n\t\t\t\tfor ( ; i < max; i++ ) {\n\t\t\t\t\toption = options[ i ];\n\n\t\t\t\t\t// oldIE doesn't update selected after form reset (#2551)\n\t\t\t\t\tif ( ( option.selected || i === index ) &&\n\t\t\t\t\t\t\t// Don't return options that are disabled or in a disabled optgroup\n\t\t\t\t\t\t\t( support.optDisabled ? !option.disabled : option.getAttribute(\"disabled\") === null ) &&\n\t\t\t\t\t\t\t( !option.parentNode.disabled || !jQuery.nodeName( option.parentNode, \"optgroup\" ) ) ) {\n\n\t\t\t\t\t\t// Get the specific value for the option\n\t\t\t\t\t\tvalue = jQuery( option ).val();\n\n\t\t\t\t\t\t// We don't need an array for one selects\n\t\t\t\t\t\tif ( one ) {\n\t\t\t\t\t\t\treturn value;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Multi-Selects return an array\n\t\t\t\t\t\tvalues.push( value );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn values;\n\t\t\t},\n\n\t\t\tset: function( elem, value ) {\n\t\t\t\tvar optionSet, option,\n\t\t\t\t\toptions = elem.options,\n\t\t\t\t\tvalues = jQuery.makeArray( value ),\n\t\t\t\t\ti = options.length;\n\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\toption = options[ i ];\n\n\t\t\t\t\tif ( jQuery.inArray( jQuery.valHooks.option.get( option ), values ) >= 0 ) {\n\n\t\t\t\t\t\t// Support: IE6\n\t\t\t\t\t\t// When new option element is added to select box we need to\n\t\t\t\t\t\t// force reflow of newly added node in order to workaround delay\n\t\t\t\t\t\t// of initialization properties\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\toption.selected = optionSet = true;\n\n\t\t\t\t\t\t} catch ( _ ) {\n\n\t\t\t\t\t\t\t// Will be executed only in IE6\n\t\t\t\t\t\t\toption.scrollHeight;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\toption.selected = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Force browsers to behave consistently when non-matching value is set\n\t\t\t\tif ( !optionSet ) {\n\t\t\t\t\telem.selectedIndex = -1;\n\t\t\t\t}\n\n\t\t\t\treturn options;\n\t\t\t}\n\t\t}\n\t}\n});\n\n// Radios and checkboxes getter/setter\njQuery.each([ \"radio\", \"checkbox\" ], function() {\n\tjQuery.valHooks[ this ] = {\n\t\tset: function( elem, value ) {\n\t\t\tif ( jQuery.isArray( value ) ) {\n\t\t\t\treturn ( elem.checked = jQuery.inArray( jQuery(elem).val(), value ) >= 0 );\n\t\t\t}\n\t\t}\n\t};\n\tif ( !support.checkOn ) {\n\t\tjQuery.valHooks[ this ].get = function( elem ) {\n\t\t\t// Support: Webkit\n\t\t\t// \"\" is returned instead of \"on\" if a value isn't specified\n\t\t\treturn elem.getAttribute(\"value\") === null ? \"on\" : elem.value;\n\t\t};\n\t}\n});\n\n\n\n\nvar nodeHook, boolHook,\n\tattrHandle = jQuery.expr.attrHandle,\n\truseDefault = /^(?:checked|selected)$/i,\n\tgetSetAttribute = support.getSetAttribute,\n\tgetSetInput = support.input;\n\njQuery.fn.extend({\n\tattr: function( name, value ) {\n\t\treturn access( this, jQuery.attr, name, value, arguments.length > 1 );\n\t},\n\n\tremoveAttr: function( name ) {\n\t\treturn this.each(function() {\n\t\t\tjQuery.removeAttr( this, name );\n\t\t});\n\t}\n});\n\njQuery.extend({\n\tattr: function( elem, name, value ) {\n\t\tvar hooks, ret,\n\t\t\tnType = elem.nodeType;\n\n\t\t// don't get/set attributes on text, comment and attribute nodes\n\t\tif ( !elem || nType === 3 || nType === 8 || nType === 2 ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Fallback to prop when attributes are not supported\n\t\tif ( typeof elem.getAttribute === strundefined ) {\n\t\t\treturn jQuery.prop( elem, name, value );\n\t\t}\n\n\t\t// All attributes are lowercase\n\t\t// Grab necessary hook if one is defined\n\t\tif ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\t\t\tname = name.toLowerCase();\n\t\t\thooks = jQuery.attrHooks[ name ] ||\n\t\t\t\t( jQuery.expr.match.bool.test( name ) ? boolHook : nodeHook );\n\t\t}\n\n\t\tif ( value !== undefined ) {\n\n\t\t\tif ( value === null ) {\n\t\t\t\tjQuery.removeAttr( elem, name );\n\n\t\t\t} else if ( hooks && \"set\" in hooks && (ret = hooks.set( elem, value, name )) !== undefined ) {\n\t\t\t\treturn ret;\n\n\t\t\t} else {\n\t\t\t\telem.setAttribute( name, value + \"\" );\n\t\t\t\treturn value;\n\t\t\t}\n\n\t\t} else if ( hooks && \"get\" in hooks && (ret = hooks.get( elem, name )) !== null ) {\n\t\t\treturn ret;\n\n\t\t} else {\n\t\t\tret = jQuery.find.attr( elem, name );\n\n\t\t\t// Non-existent attributes return null, we normalize to undefined\n\t\t\treturn ret == null ?\n\t\t\t\tundefined :\n\t\t\t\tret;\n\t\t}\n\t},\n\n\tremoveAttr: function( elem, value ) {\n\t\tvar name, propName,\n\t\t\ti = 0,\n\t\t\tattrNames = value && value.match( rnotwhite );\n\n\t\tif ( attrNames && elem.nodeType === 1 ) {\n\t\t\twhile ( (name = attrNames[i++]) ) {\n\t\t\t\tpropName = jQuery.propFix[ name ] || name;\n\n\t\t\t\t// Boolean attributes get special treatment (#10870)\n\t\t\t\tif ( jQuery.expr.match.bool.test( name ) ) {\n\t\t\t\t\t// Set corresponding property to false\n\t\t\t\t\tif ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\t\t\t\t\t\telem[ propName ] = false;\n\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t// Also clear defaultChecked/defaultSelected (if appropriate)\n\t\t\t\t\t} else {\n\t\t\t\t\t\telem[ jQuery.camelCase( \"default-\" + name ) ] =\n\t\t\t\t\t\t\telem[ propName ] = false;\n\t\t\t\t\t}\n\n\t\t\t\t// See #9699 for explanation of this approach (setting first, then removal)\n\t\t\t\t} else {\n\t\t\t\t\tjQuery.attr( elem, name, \"\" );\n\t\t\t\t}\n\n\t\t\t\telem.removeAttribute( getSetAttribute ? name : propName );\n\t\t\t}\n\t\t}\n\t},\n\n\tattrHooks: {\n\t\ttype: {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tif ( !support.radioValue && value === \"radio\" && jQuery.nodeName(elem, \"input\") ) {\n\t\t\t\t\t// Setting the type on a radio button after the value resets the value in IE6-9\n\t\t\t\t\t// Reset value to default in case type is set after value during creation\n\t\t\t\t\tvar val = elem.value;\n\t\t\t\t\telem.setAttribute( \"type\", value );\n\t\t\t\t\tif ( val ) {\n\t\t\t\t\t\telem.value = val;\n\t\t\t\t\t}\n\t\t\t\t\treturn value;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n});\n\n// Hook for boolean attributes\nboolHook = {\n\tset: function( elem, value, name ) {\n\t\tif ( value === false ) {\n\t\t\t// Remove boolean attributes when set to false\n\t\t\tjQuery.removeAttr( elem, name );\n\t\t} else if ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\t\t\t// IE<8 needs the *property* name\n\t\t\telem.setAttribute( !getSetAttribute && jQuery.propFix[ name ] || name, name );\n\n\t\t// Use defaultChecked and defaultSelected for oldIE\n\t\t} else {\n\t\t\telem[ jQuery.camelCase( \"default-\" + name ) ] = elem[ name ] = true;\n\t\t}\n\n\t\treturn name;\n\t}\n};\n\n// Retrieve booleans specially\njQuery.each( jQuery.expr.match.bool.source.match( /\\w+/g ), function( i, name ) {\n\n\tvar getter = attrHandle[ name ] || jQuery.find.attr;\n\n\tattrHandle[ name ] = getSetInput && getSetAttribute || !ruseDefault.test( name ) ?\n\t\tfunction( elem, name, isXML ) {\n\t\t\tvar ret, handle;\n\t\t\tif ( !isXML ) {\n\t\t\t\t// Avoid an infinite loop by temporarily removing this function from the getter\n\t\t\t\thandle = attrHandle[ name ];\n\t\t\t\tattrHandle[ name ] = ret;\n\t\t\t\tret = getter( elem, name, isXML ) != null ?\n\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\tnull;\n\t\t\t\tattrHandle[ name ] = handle;\n\t\t\t}\n\t\t\treturn ret;\n\t\t} :\n\t\tfunction( elem, name, isXML ) {\n\t\t\tif ( !isXML ) {\n\t\t\t\treturn elem[ jQuery.camelCase( \"default-\" + name ) ] ?\n\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\tnull;\n\t\t\t}\n\t\t};\n});\n\n// fix oldIE attroperties\nif ( !getSetInput || !getSetAttribute ) {\n\tjQuery.attrHooks.value = {\n\t\tset: function( elem, value, name ) {\n\t\t\tif ( jQuery.nodeName( elem, \"input\" ) ) {\n\t\t\t\t// Does not return so that setAttribute is also used\n\t\t\t\telem.defaultValue = value;\n\t\t\t} else {\n\t\t\t\t// Use nodeHook if defined (#1954); otherwise setAttribute is fine\n\t\t\t\treturn nodeHook && nodeHook.set( elem, value, name );\n\t\t\t}\n\t\t}\n\t};\n}\n\n// IE6/7 do not support getting/setting some attributes with get/setAttribute\nif ( !getSetAttribute ) {\n\n\t// Use this for any attribute in IE6/7\n\t// This fixes almost every IE6/7 issue\n\tnodeHook = {\n\t\tset: function( elem, value, name ) {\n\t\t\t// Set the existing or create a new attribute node\n\t\t\tvar ret = elem.getAttributeNode( name );\n\t\t\tif ( !ret ) {\n\t\t\t\telem.setAttributeNode(\n\t\t\t\t\t(ret = elem.ownerDocument.createAttribute( name ))\n\t\t\t\t);\n\t\t\t}\n\n\t\t\tret.value = value += \"\";\n\n\t\t\t// Break association with cloned elements by also using setAttribute (#9646)\n\t\t\tif ( name === \"value\" || value === elem.getAttribute( name ) ) {\n\t\t\t\treturn value;\n\t\t\t}\n\t\t}\n\t};\n\n\t// Some attributes are constructed with empty-string values when not defined\n\tattrHandle.id = attrHandle.name = attrHandle.coords =\n\t\tfunction( elem, name, isXML ) {\n\t\t\tvar ret;\n\t\t\tif ( !isXML ) {\n\t\t\t\treturn (ret = elem.getAttributeNode( name )) && ret.value !== \"\" ?\n\t\t\t\t\tret.value :\n\t\t\t\t\tnull;\n\t\t\t}\n\t\t};\n\n\t// Fixing value retrieval on a button requires this module\n\tjQuery.valHooks.button = {\n\t\tget: function( elem, name ) {\n\t\t\tvar ret = elem.getAttributeNode( name );\n\t\t\tif ( ret && ret.specified ) {\n\t\t\t\treturn ret.value;\n\t\t\t}\n\t\t},\n\t\tset: nodeHook.set\n\t};\n\n\t// Set contenteditable to false on removals(#10429)\n\t// Setting to empty string throws an error as an invalid value\n\tjQuery.attrHooks.contenteditable = {\n\t\tset: function( elem, value, name ) {\n\t\t\tnodeHook.set( elem, value === \"\" ? false : value, name );\n\t\t}\n\t};\n\n\t// Set width and height to auto instead of 0 on empty string( Bug #8150 )\n\t// This is for removals\n\tjQuery.each([ \"width\", \"height\" ], function( i, name ) {\n\t\tjQuery.attrHooks[ name ] = {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tif ( value === \"\" ) {\n\t\t\t\t\telem.setAttribute( name, \"auto\" );\n\t\t\t\t\treturn value;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t});\n}\n\nif ( !support.style ) {\n\tjQuery.attrHooks.style = {\n\t\tget: function( elem ) {\n\t\t\t// Return undefined in the case of empty string\n\t\t\t// Note: IE uppercases css property names, but if we were to .toLowerCase()\n\t\t\t// .cssText, that would destroy case senstitivity in URL's, like in \"background\"\n\t\t\treturn elem.style.cssText || undefined;\n\t\t},\n\t\tset: function( elem, value ) {\n\t\t\treturn ( elem.style.cssText = value + \"\" );\n\t\t}\n\t};\n}\n\n\n\n\nvar rfocusable = /^(?:input|select|textarea|button|object)$/i,\n\trclickable = /^(?:a|area)$/i;\n\njQuery.fn.extend({\n\tprop: function( name, value ) {\n\t\treturn access( this, jQuery.prop, name, value, arguments.length > 1 );\n\t},\n\n\tremoveProp: function( name ) {\n\t\tname = jQuery.propFix[ name ] || name;\n\t\treturn this.each(function() {\n\t\t\t// try/catch handles cases where IE balks (such as removing a property on window)\n\t\t\ttry {\n\t\t\t\tthis[ name ] = undefined;\n\t\t\t\tdelete this[ name ];\n\t\t\t} catch( e ) {}\n\t\t});\n\t}\n});\n\njQuery.extend({\n\tpropFix: {\n\t\t\"for\": \"htmlFor\",\n\t\t\"class\": \"className\"\n\t},\n\n\tprop: function( elem, name, value ) {\n\t\tvar ret, hooks, notxml,\n\t\t\tnType = elem.nodeType;\n\n\t\t// don't get/set properties on text, comment and attribute nodes\n\t\tif ( !elem || nType === 3 || nType === 8 || nType === 2 ) {\n\t\t\treturn;\n\t\t}\n\n\t\tnotxml = nType !== 1 || !jQuery.isXMLDoc( elem );\n\n\t\tif ( notxml ) {\n\t\t\t// Fix name and attach hooks\n\t\t\tname = jQuery.propFix[ name ] || name;\n\t\t\thooks = jQuery.propHooks[ name ];\n\t\t}\n\n\t\tif ( value !== undefined ) {\n\t\t\treturn hooks && \"set\" in hooks && (ret = hooks.set( elem, value, name )) !== undefined ?\n\t\t\t\tret :\n\t\t\t\t( elem[ name ] = value );\n\n\t\t} else {\n\t\t\treturn hooks && \"get\" in hooks && (ret = hooks.get( elem, name )) !== null ?\n\t\t\t\tret :\n\t\t\t\telem[ name ];\n\t\t}\n\t},\n\n\tpropHooks: {\n\t\ttabIndex: {\n\t\t\tget: function( elem ) {\n\t\t\t\t// elem.tabIndex doesn't always return the correct value when it hasn't been explicitly set\n\t\t\t\t// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/\n\t\t\t\t// Use proper attribute retrieval(#12072)\n\t\t\t\tvar tabindex = jQuery.find.attr( elem, \"tabindex\" );\n\n\t\t\t\treturn tabindex ?\n\t\t\t\t\tparseInt( tabindex, 10 ) :\n\t\t\t\t\trfocusable.test( elem.nodeName ) || rclickable.test( elem.nodeName ) && elem.href ?\n\t\t\t\t\t\t0 :\n\t\t\t\t\t\t-1;\n\t\t\t}\n\t\t}\n\t}\n});\n\n// Some attributes require a special call on IE\n// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx\nif ( !support.hrefNormalized ) {\n\t// href/src property should get the full normalized URL (#10299/#12915)\n\tjQuery.each([ \"href\", \"src\" ], function( i, name ) {\n\t\tjQuery.propHooks[ name ] = {\n\t\t\tget: function( elem ) {\n\t\t\t\treturn elem.getAttribute( name, 4 );\n\t\t\t}\n\t\t};\n\t});\n}\n\n// Support: Safari, IE9+\n// mis-reports the default selected property of an option\n// Accessing the parent's selectedIndex property fixes it\nif ( !support.optSelected ) {\n\tjQuery.propHooks.selected = {\n\t\tget: function( elem ) {\n\t\t\tvar parent = elem.parentNode;\n\n\t\t\tif ( parent ) {\n\t\t\t\tparent.selectedIndex;\n\n\t\t\t\t// Make sure that it also works with optgroups, see #5701\n\t\t\t\tif ( parent.parentNode ) {\n\t\t\t\t\tparent.parentNode.selectedIndex;\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn null;\n\t\t}\n\t};\n}\n\njQuery.each([\n\t\"tabIndex\",\n\t\"readOnly\",\n\t\"maxLength\",\n\t\"cellSpacing\",\n\t\"cellPadding\",\n\t\"rowSpan\",\n\t\"colSpan\",\n\t\"useMap\",\n\t\"frameBorder\",\n\t\"contentEditable\"\n], function() {\n\tjQuery.propFix[ this.toLowerCase() ] = this;\n});\n\n// IE6/7 call enctype encoding\nif ( !support.enctype ) {\n\tjQuery.propFix.enctype = \"encoding\";\n}\n\n\n\n\nvar rclass = /[\\t\\r\\n\\f]/g;\n\njQuery.fn.extend({\n\taddClass: function( value ) {\n\t\tvar classes, elem, cur, clazz, j, finalValue,\n\t\t\ti = 0,\n\t\t\tlen = this.length,\n\t\t\tproceed = typeof value === \"string\" && value;\n\n\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\treturn this.each(function( j ) {\n\t\t\t\tjQuery( this ).addClass( value.call( this, j, this.className ) );\n\t\t\t});\n\t\t}\n\n\t\tif ( proceed ) {\n\t\t\t// The disjunction here is for better compressibility (see removeClass)\n\t\t\tclasses = ( value || \"\" ).match( rnotwhite ) || [];\n\n\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\telem = this[ i ];\n\t\t\t\tcur = elem.nodeType === 1 && ( elem.className ?\n\t\t\t\t\t( \" \" + elem.className + \" \" ).replace( rclass, \" \" ) :\n\t\t\t\t\t\" \"\n\t\t\t\t);\n\n\t\t\t\tif ( cur ) {\n\t\t\t\t\tj = 0;\n\t\t\t\t\twhile ( (clazz = classes[j++]) ) {\n\t\t\t\t\t\tif ( cur.indexOf( \" \" + clazz + \" \" ) < 0 ) {\n\t\t\t\t\t\t\tcur += clazz + \" \";\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// only assign if different to avoid unneeded rendering.\n\t\t\t\t\tfinalValue = jQuery.trim( cur );\n\t\t\t\t\tif ( elem.className !== finalValue ) {\n\t\t\t\t\t\telem.className = finalValue;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tremoveClass: function( value ) {\n\t\tvar classes, elem, cur, clazz, j, finalValue,\n\t\t\ti = 0,\n\t\t\tlen = this.length,\n\t\t\tproceed = arguments.length === 0 || typeof value === \"string\" && value;\n\n\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\treturn this.each(function( j ) {\n\t\t\t\tjQuery( this ).removeClass( value.call( this, j, this.className ) );\n\t\t\t});\n\t\t}\n\t\tif ( proceed ) {\n\t\t\tclasses = ( value || \"\" ).match( rnotwhite ) || [];\n\n\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\telem = this[ i ];\n\t\t\t\t// This expression is here for better compressibility (see addClass)\n\t\t\t\tcur = elem.nodeType === 1 && ( elem.className ?\n\t\t\t\t\t( \" \" + elem.className + \" \" ).replace( rclass, \" \" ) :\n\t\t\t\t\t\"\"\n\t\t\t\t);\n\n\t\t\t\tif ( cur ) {\n\t\t\t\t\tj = 0;\n\t\t\t\t\twhile ( (clazz = classes[j++]) ) {\n\t\t\t\t\t\t// Remove *all* instances\n\t\t\t\t\t\twhile ( cur.indexOf( \" \" + clazz + \" \" ) >= 0 ) {\n\t\t\t\t\t\t\tcur = cur.replace( \" \" + clazz + \" \", \" \" );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// only assign if different to avoid unneeded rendering.\n\t\t\t\t\tfinalValue = value ? jQuery.trim( cur ) : \"\";\n\t\t\t\t\tif ( elem.className !== finalValue ) {\n\t\t\t\t\t\telem.className = finalValue;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn this;\n\t},\n\n\ttoggleClass: function( value, stateVal ) {\n\t\tvar type = typeof value;\n\n\t\tif ( typeof stateVal === \"boolean\" && type === \"string\" ) {\n\t\t\treturn stateVal ? this.addClass( value ) : this.removeClass( value );\n\t\t}\n\n\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\treturn this.each(function( i ) {\n\t\t\t\tjQuery( this ).toggleClass( value.call(this, i, this.className, stateVal), stateVal );\n\t\t\t});\n\t\t}\n\n\t\treturn this.each(function() {\n\t\t\tif ( type === \"string\" ) {\n\t\t\t\t// toggle individual class names\n\t\t\t\tvar className,\n\t\t\t\t\ti = 0,\n\t\t\t\t\tself = jQuery( this ),\n\t\t\t\t\tclassNames = value.match( rnotwhite ) || [];\n\n\t\t\t\twhile ( (className = classNames[ i++ ]) ) {\n\t\t\t\t\t// check each className given, space separated list\n\t\t\t\t\tif ( self.hasClass( className ) ) {\n\t\t\t\t\t\tself.removeClass( className );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tself.addClass( className );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t// Toggle whole class name\n\t\t\t} else if ( type === strundefined || type === \"boolean\" ) {\n\t\t\t\tif ( this.className ) {\n\t\t\t\t\t// store className if set\n\t\t\t\t\tjQuery._data( this, \"__className__\", this.className );\n\t\t\t\t}\n\n\t\t\t\t// If the element has a class name or if we're passed \"false\",\n\t\t\t\t// then remove the whole classname (if there was one, the above saved it).\n\t\t\t\t// Otherwise bring back whatever was previously saved (if anything),\n\t\t\t\t// falling back to the empty string if nothing was stored.\n\t\t\t\tthis.className = this.className || value === false ? \"\" : jQuery._data( this, \"__className__\" ) || \"\";\n\t\t\t}\n\t\t});\n\t},\n\n\thasClass: function( selector ) {\n\t\tvar className = \" \" + selector + \" \",\n\t\t\ti = 0,\n\t\t\tl = this.length;\n\t\tfor ( ; i < l; i++ ) {\n\t\t\tif ( this[i].nodeType === 1 && (\" \" + this[i].className + \" \").replace(rclass, \" \").indexOf( className ) >= 0 ) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\n\t\treturn false;\n\t}\n});\n\n\n\n\n// Return jQuery for attributes-only inclusion\n\n\njQuery.each( (\"blur focus focusin focusout load resize scroll unload click dblclick \" +\n\t\"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n\t\"change select submit keydown keypress keyup error contextmenu\").split(\" \"), function( i, name ) {\n\n\t// Handle event binding\n\tjQuery.fn[ name ] = function( data, fn ) {\n\t\treturn arguments.length > 0 ?\n\t\t\tthis.on( name, null, data, fn ) :\n\t\t\tthis.trigger( name );\n\t};\n});\n\njQuery.fn.extend({\n\thover: function( fnOver, fnOut ) {\n\t\treturn this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );\n\t},\n\n\tbind: function( types, data, fn ) {\n\t\treturn this.on( types, null, data, fn );\n\t},\n\tunbind: function( types, fn ) {\n\t\treturn this.off( types, null, fn );\n\t},\n\n\tdelegate: function( selector, types, data, fn ) {\n\t\treturn this.on( types, selector, data, fn );\n\t},\n\tundelegate: function( selector, types, fn ) {\n\t\t// ( namespace ) or ( selector, types [, fn] )\n\t\treturn arguments.length === 1 ? this.off( selector, \"**\" ) : this.off( types, selector || \"**\", fn );\n\t}\n});\n\n\nvar nonce = jQuery.now();\n\nvar rquery = (/\\?/);\n\n\n\nvar rvalidtokens = /(,)|(\\[|{)|(}|])|\"(?:[^\"\\\\\\r\\n]|\\\\[\"\\\\\\/bfnrt]|\\\\u[\\da-fA-F]{4})*\"\\s*:?|true|false|null|-?(?!0\\d)\\d+(?:\\.\\d+|)(?:[eE][+-]?\\d+|)/g;\n\njQuery.parseJSON = function( data ) {\n\t// Attempt to parse using the native JSON parser first\n\tif ( window.JSON && window.JSON.parse ) {\n\t\t// Support: Android 2.3\n\t\t// Workaround failure to string-cast null input\n\t\treturn window.JSON.parse( data + \"\" );\n\t}\n\n\tvar requireNonComma,\n\t\tdepth = null,\n\t\tstr = jQuery.trim( data + \"\" );\n\n\t// Guard against invalid (and possibly dangerous) input by ensuring that nothing remains\n\t// after removing valid tokens\n\treturn str && !jQuery.trim( str.replace( rvalidtokens, function( token, comma, open, close ) {\n\n\t\t// Force termination if we see a misplaced comma\n\t\tif ( requireNonComma && comma ) {\n\t\t\tdepth = 0;\n\t\t}\n\n\t\t// Perform no more replacements after returning to outermost depth\n\t\tif ( depth === 0 ) {\n\t\t\treturn token;\n\t\t}\n\n\t\t// Commas must not follow \"[\", \"{\", or \",\"\n\t\trequireNonComma = open || comma;\n\n\t\t// Determine new depth\n\t\t// array/object open (\"[\" or \"{\"): depth += true - false (increment)\n\t\t// array/object close (\"]\" or \"}\"): depth += false - true (decrement)\n\t\t// other cases (\",\" or primitive): depth += true - true (numeric cast)\n\t\tdepth += !close - !open;\n\n\t\t// Remove this token\n\t\treturn \"\";\n\t}) ) ?\n\t\t( Function( \"return \" + str ) )() :\n\t\tjQuery.error( \"Invalid JSON: \" + data );\n};\n\n\n// Cross-browser xml parsing\njQuery.parseXML = function( data ) {\n\tvar xml, tmp;\n\tif ( !data || typeof data !== \"string\" ) {\n\t\treturn null;\n\t}\n\ttry {\n\t\tif ( window.DOMParser ) { // Standard\n\t\t\ttmp = new DOMParser();\n\t\t\txml = tmp.parseFromString( data, \"text/xml\" );\n\t\t} else { // IE\n\t\t\txml = new ActiveXObject( \"Microsoft.XMLDOM\" );\n\t\t\txml.async = \"false\";\n\t\t\txml.loadXML( data );\n\t\t}\n\t} catch( e ) {\n\t\txml = undefined;\n\t}\n\tif ( !xml || !xml.documentElement || xml.getElementsByTagName( \"parsererror\" ).length ) {\n\t\tjQuery.error( \"Invalid XML: \" + data );\n\t}\n\treturn xml;\n};\n\n\nvar\n\t// Document location\n\tajaxLocParts,\n\tajaxLocation,\n\n\trhash = /#.*$/,\n\trts = /([?&])_=[^&]*/,\n\trheaders = /^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/mg, // IE leaves an \\r character at EOL\n\t// #7653, #8125, #8152: local protocol detection\n\trlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,\n\trnoContent = /^(?:GET|HEAD)$/,\n\trprotocol = /^\\/\\//,\n\trurl = /^([\\w.+-]+:)(?:\\/\\/(?:[^\\/?#]*@|)([^\\/?#:]*)(?::(\\d+)|)|)/,\n\n\t/* Prefilters\n\t * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)\n\t * 2) These are called:\n\t *    - BEFORE asking for a transport\n\t *    - AFTER param serialization (s.data is a string if s.processData is true)\n\t * 3) key is the dataType\n\t * 4) the catchall symbol \"*\" can be used\n\t * 5) execution will start with transport dataType and THEN continue down to \"*\" if needed\n\t */\n\tprefilters = {},\n\n\t/* Transports bindings\n\t * 1) key is the dataType\n\t * 2) the catchall symbol \"*\" can be used\n\t * 3) selection will start with transport dataType and THEN go to \"*\" if needed\n\t */\n\ttransports = {},\n\n\t// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression\n\tallTypes = \"*/\".concat(\"*\");\n\n// #8138, IE may throw an exception when accessing\n// a field from window.location if document.domain has been set\ntry {\n\tajaxLocation = location.href;\n} catch( e ) {\n\t// Use the href attribute of an A element\n\t// since IE will modify it given document.location\n\tajaxLocation = document.createElement( \"a\" );\n\tajaxLocation.href = \"\";\n\tajaxLocation = ajaxLocation.href;\n}\n\n// Segment location into parts\najaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];\n\n// Base \"constructor\" for jQuery.ajaxPrefilter and jQuery.ajaxTransport\nfunction addToPrefiltersOrTransports( structure ) {\n\n\t// dataTypeExpression is optional and defaults to \"*\"\n\treturn function( dataTypeExpression, func ) {\n\n\t\tif ( typeof dataTypeExpression !== \"string\" ) {\n\t\t\tfunc = dataTypeExpression;\n\t\t\tdataTypeExpression = \"*\";\n\t\t}\n\n\t\tvar dataType,\n\t\t\ti = 0,\n\t\t\tdataTypes = dataTypeExpression.toLowerCase().match( rnotwhite ) || [];\n\n\t\tif ( jQuery.isFunction( func ) ) {\n\t\t\t// For each dataType in the dataTypeExpression\n\t\t\twhile ( (dataType = dataTypes[i++]) ) {\n\t\t\t\t// Prepend if requested\n\t\t\t\tif ( dataType.charAt( 0 ) === \"+\" ) {\n\t\t\t\t\tdataType = dataType.slice( 1 ) || \"*\";\n\t\t\t\t\t(structure[ dataType ] = structure[ dataType ] || []).unshift( func );\n\n\t\t\t\t// Otherwise append\n\t\t\t\t} else {\n\t\t\t\t\t(structure[ dataType ] = structure[ dataType ] || []).push( func );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n}\n\n// Base inspection function for prefilters and transports\nfunction inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {\n\n\tvar inspected = {},\n\t\tseekingTransport = ( structure === transports );\n\n\tfunction inspect( dataType ) {\n\t\tvar selected;\n\t\tinspected[ dataType ] = true;\n\t\tjQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {\n\t\t\tvar dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );\n\t\t\tif ( typeof dataTypeOrTransport === \"string\" && !seekingTransport && !inspected[ dataTypeOrTransport ] ) {\n\t\t\t\toptions.dataTypes.unshift( dataTypeOrTransport );\n\t\t\t\tinspect( dataTypeOrTransport );\n\t\t\t\treturn false;\n\t\t\t} else if ( seekingTransport ) {\n\t\t\t\treturn !( selected = dataTypeOrTransport );\n\t\t\t}\n\t\t});\n\t\treturn selected;\n\t}\n\n\treturn inspect( options.dataTypes[ 0 ] ) || !inspected[ \"*\" ] && inspect( \"*\" );\n}\n\n// A special extend for ajax options\n// that takes \"flat\" options (not to be deep extended)\n// Fixes #9887\nfunction ajaxExtend( target, src ) {\n\tvar deep, key,\n\t\tflatOptions = jQuery.ajaxSettings.flatOptions || {};\n\n\tfor ( key in src ) {\n\t\tif ( src[ key ] !== undefined ) {\n\t\t\t( flatOptions[ key ] ? target : ( deep || (deep = {}) ) )[ key ] = src[ key ];\n\t\t}\n\t}\n\tif ( deep ) {\n\t\tjQuery.extend( true, target, deep );\n\t}\n\n\treturn target;\n}\n\n/* Handles responses to an ajax request:\n * - finds the right dataType (mediates between content-type and expected dataType)\n * - returns the corresponding response\n */\nfunction ajaxHandleResponses( s, jqXHR, responses ) {\n\tvar firstDataType, ct, finalDataType, type,\n\t\tcontents = s.contents,\n\t\tdataTypes = s.dataTypes;\n\n\t// Remove auto dataType and get content-type in the process\n\twhile ( dataTypes[ 0 ] === \"*\" ) {\n\t\tdataTypes.shift();\n\t\tif ( ct === undefined ) {\n\t\t\tct = s.mimeType || jqXHR.getResponseHeader(\"Content-Type\");\n\t\t}\n\t}\n\n\t// Check if we're dealing with a known content-type\n\tif ( ct ) {\n\t\tfor ( type in contents ) {\n\t\t\tif ( contents[ type ] && contents[ type ].test( ct ) ) {\n\t\t\t\tdataTypes.unshift( type );\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t}\n\n\t// Check to see if we have a response for the expected dataType\n\tif ( dataTypes[ 0 ] in responses ) {\n\t\tfinalDataType = dataTypes[ 0 ];\n\t} else {\n\t\t// Try convertible dataTypes\n\t\tfor ( type in responses ) {\n\t\t\tif ( !dataTypes[ 0 ] || s.converters[ type + \" \" + dataTypes[0] ] ) {\n\t\t\t\tfinalDataType = type;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tif ( !firstDataType ) {\n\t\t\t\tfirstDataType = type;\n\t\t\t}\n\t\t}\n\t\t// Or just use first one\n\t\tfinalDataType = finalDataType || firstDataType;\n\t}\n\n\t// If we found a dataType\n\t// We add the dataType to the list if needed\n\t// and return the corresponding response\n\tif ( finalDataType ) {\n\t\tif ( finalDataType !== dataTypes[ 0 ] ) {\n\t\t\tdataTypes.unshift( finalDataType );\n\t\t}\n\t\treturn responses[ finalDataType ];\n\t}\n}\n\n/* Chain conversions given the request and the original response\n * Also sets the responseXXX fields on the jqXHR instance\n */\nfunction ajaxConvert( s, response, jqXHR, isSuccess ) {\n\tvar conv2, current, conv, tmp, prev,\n\t\tconverters = {},\n\t\t// Work with a copy of dataTypes in case we need to modify it for conversion\n\t\tdataTypes = s.dataTypes.slice();\n\n\t// Create converters map with lowercased keys\n\tif ( dataTypes[ 1 ] ) {\n\t\tfor ( conv in s.converters ) {\n\t\t\tconverters[ conv.toLowerCase() ] = s.converters[ conv ];\n\t\t}\n\t}\n\n\tcurrent = dataTypes.shift();\n\n\t// Convert to each sequential dataType\n\twhile ( current ) {\n\n\t\tif ( s.responseFields[ current ] ) {\n\t\t\tjqXHR[ s.responseFields[ current ] ] = response;\n\t\t}\n\n\t\t// Apply the dataFilter if provided\n\t\tif ( !prev && isSuccess && s.dataFilter ) {\n\t\t\tresponse = s.dataFilter( response, s.dataType );\n\t\t}\n\n\t\tprev = current;\n\t\tcurrent = dataTypes.shift();\n\n\t\tif ( current ) {\n\n\t\t\t// There's only work to do if current dataType is non-auto\n\t\t\tif ( current === \"*\" ) {\n\n\t\t\t\tcurrent = prev;\n\n\t\t\t// Convert response if prev dataType is non-auto and differs from current\n\t\t\t} else if ( prev !== \"*\" && prev !== current ) {\n\n\t\t\t\t// Seek a direct converter\n\t\t\t\tconv = converters[ prev + \" \" + current ] || converters[ \"* \" + current ];\n\n\t\t\t\t// If none found, seek a pair\n\t\t\t\tif ( !conv ) {\n\t\t\t\t\tfor ( conv2 in converters ) {\n\n\t\t\t\t\t\t// If conv2 outputs current\n\t\t\t\t\t\ttmp = conv2.split( \" \" );\n\t\t\t\t\t\tif ( tmp[ 1 ] === current ) {\n\n\t\t\t\t\t\t\t// If prev can be converted to accepted input\n\t\t\t\t\t\t\tconv = converters[ prev + \" \" + tmp[ 0 ] ] ||\n\t\t\t\t\t\t\t\tconverters[ \"* \" + tmp[ 0 ] ];\n\t\t\t\t\t\t\tif ( conv ) {\n\t\t\t\t\t\t\t\t// Condense equivalence converters\n\t\t\t\t\t\t\t\tif ( conv === true ) {\n\t\t\t\t\t\t\t\t\tconv = converters[ conv2 ];\n\n\t\t\t\t\t\t\t\t// Otherwise, insert the intermediate dataType\n\t\t\t\t\t\t\t\t} else if ( converters[ conv2 ] !== true ) {\n\t\t\t\t\t\t\t\t\tcurrent = tmp[ 0 ];\n\t\t\t\t\t\t\t\t\tdataTypes.unshift( tmp[ 1 ] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Apply converter (if not an equivalence)\n\t\t\t\tif ( conv !== true ) {\n\n\t\t\t\t\t// Unless errors are allowed to bubble, catch and return them\n\t\t\t\t\tif ( conv && s[ \"throws\" ] ) {\n\t\t\t\t\t\tresponse = conv( response );\n\t\t\t\t\t} else {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tresponse = conv( response );\n\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\treturn { state: \"parsererror\", error: conv ? e : \"No conversion from \" + prev + \" to \" + current };\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\treturn { state: \"success\", data: response };\n}\n\njQuery.extend({\n\n\t// Counter for holding the number of active queries\n\tactive: 0,\n\n\t// Last-Modified header cache for next request\n\tlastModified: {},\n\tetag: {},\n\n\tajaxSettings: {\n\t\turl: ajaxLocation,\n\t\ttype: \"GET\",\n\t\tisLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),\n\t\tglobal: true,\n\t\tprocessData: true,\n\t\tasync: true,\n\t\tcontentType: \"application/x-www-form-urlencoded; charset=UTF-8\",\n\t\t/*\n\t\ttimeout: 0,\n\t\tdata: null,\n\t\tdataType: null,\n\t\tusername: null,\n\t\tpassword: null,\n\t\tcache: null,\n\t\tthrows: false,\n\t\ttraditional: false,\n\t\theaders: {},\n\t\t*/\n\n\t\taccepts: {\n\t\t\t\"*\": allTypes,\n\t\t\ttext: \"text/plain\",\n\t\t\thtml: \"text/html\",\n\t\t\txml: \"application/xml, text/xml\",\n\t\t\tjson: \"application/json, text/javascript\"\n\t\t},\n\n\t\tcontents: {\n\t\t\txml: /xml/,\n\t\t\thtml: /html/,\n\t\t\tjson: /json/\n\t\t},\n\n\t\tresponseFields: {\n\t\t\txml: \"responseXML\",\n\t\t\ttext: \"responseText\",\n\t\t\tjson: \"responseJSON\"\n\t\t},\n\n\t\t// Data converters\n\t\t// Keys separate source (or catchall \"*\") and destination types with a single space\n\t\tconverters: {\n\n\t\t\t// Convert anything to text\n\t\t\t\"* text\": String,\n\n\t\t\t// Text to html (true = no transformation)\n\t\t\t\"text html\": true,\n\n\t\t\t// Evaluate text as a json expression\n\t\t\t\"text json\": jQuery.parseJSON,\n\n\t\t\t// Parse text as xml\n\t\t\t\"text xml\": jQuery.parseXML\n\t\t},\n\n\t\t// For options that shouldn't be deep extended:\n\t\t// you can add your own custom options here if\n\t\t// and when you create one that shouldn't be\n\t\t// deep extended (see ajaxExtend)\n\t\tflatOptions: {\n\t\t\turl: true,\n\t\t\tcontext: true\n\t\t}\n\t},\n\n\t// Creates a full fledged settings object into target\n\t// with both ajaxSettings and settings fields.\n\t// If target is omitted, writes into ajaxSettings.\n\tajaxSetup: function( target, settings ) {\n\t\treturn settings ?\n\n\t\t\t// Building a settings object\n\t\t\tajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :\n\n\t\t\t// Extending ajaxSettings\n\t\t\tajaxExtend( jQuery.ajaxSettings, target );\n\t},\n\n\tajaxPrefilter: addToPrefiltersOrTransports( prefilters ),\n\tajaxTransport: addToPrefiltersOrTransports( transports ),\n\n\t// Main method\n\tajax: function( url, options ) {\n\n\t\t// If url is an object, simulate pre-1.5 signature\n\t\tif ( typeof url === \"object\" ) {\n\t\t\toptions = url;\n\t\t\turl = undefined;\n\t\t}\n\n\t\t// Force options to be an object\n\t\toptions = options || {};\n\n\t\tvar // Cross-domain detection vars\n\t\t\tparts,\n\t\t\t// Loop variable\n\t\t\ti,\n\t\t\t// URL without anti-cache param\n\t\t\tcacheURL,\n\t\t\t// Response headers as string\n\t\t\tresponseHeadersString,\n\t\t\t// timeout handle\n\t\t\ttimeoutTimer,\n\n\t\t\t// To know if global events are to be dispatched\n\t\t\tfireGlobals,\n\n\t\t\ttransport,\n\t\t\t// Response headers\n\t\t\tresponseHeaders,\n\t\t\t// Create the final options object\n\t\t\ts = jQuery.ajaxSetup( {}, options ),\n\t\t\t// Callbacks context\n\t\t\tcallbackContext = s.context || s,\n\t\t\t// Context for global events is callbackContext if it is a DOM node or jQuery collection\n\t\t\tglobalEventContext = s.context && ( callbackContext.nodeType || callbackContext.jquery ) ?\n\t\t\t\tjQuery( callbackContext ) :\n\t\t\t\tjQuery.event,\n\t\t\t// Deferreds\n\t\t\tdeferred = jQuery.Deferred(),\n\t\t\tcompleteDeferred = jQuery.Callbacks(\"once memory\"),\n\t\t\t// Status-dependent callbacks\n\t\t\tstatusCode = s.statusCode || {},\n\t\t\t// Headers (they are sent all at once)\n\t\t\trequestHeaders = {},\n\t\t\trequestHeadersNames = {},\n\t\t\t// The jqXHR state\n\t\t\tstate = 0,\n\t\t\t// Default abort message\n\t\t\tstrAbort = \"canceled\",\n\t\t\t// Fake xhr\n\t\t\tjqXHR = {\n\t\t\t\treadyState: 0,\n\n\t\t\t\t// Builds headers hashtable if needed\n\t\t\t\tgetResponseHeader: function( key ) {\n\t\t\t\t\tvar match;\n\t\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\t\tif ( !responseHeaders ) {\n\t\t\t\t\t\t\tresponseHeaders = {};\n\t\t\t\t\t\t\twhile ( (match = rheaders.exec( responseHeadersString )) ) {\n\t\t\t\t\t\t\t\tresponseHeaders[ match[1].toLowerCase() ] = match[ 2 ];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tmatch = responseHeaders[ key.toLowerCase() ];\n\t\t\t\t\t}\n\t\t\t\t\treturn match == null ? null : match;\n\t\t\t\t},\n\n\t\t\t\t// Raw string\n\t\t\t\tgetAllResponseHeaders: function() {\n\t\t\t\t\treturn state === 2 ? responseHeadersString : null;\n\t\t\t\t},\n\n\t\t\t\t// Caches the header\n\t\t\t\tsetRequestHeader: function( name, value ) {\n\t\t\t\t\tvar lname = name.toLowerCase();\n\t\t\t\t\tif ( !state ) {\n\t\t\t\t\t\tname = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;\n\t\t\t\t\t\trequestHeaders[ name ] = value;\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Overrides response content-type header\n\t\t\t\toverrideMimeType: function( type ) {\n\t\t\t\t\tif ( !state ) {\n\t\t\t\t\t\ts.mimeType = type;\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Status-dependent callbacks\n\t\t\t\tstatusCode: function( map ) {\n\t\t\t\t\tvar code;\n\t\t\t\t\tif ( map ) {\n\t\t\t\t\t\tif ( state < 2 ) {\n\t\t\t\t\t\t\tfor ( code in map ) {\n\t\t\t\t\t\t\t\t// Lazy-add the new callback in a way that preserves old ones\n\t\t\t\t\t\t\t\tstatusCode[ code ] = [ statusCode[ code ], map[ code ] ];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Execute the appropriate callbacks\n\t\t\t\t\t\t\tjqXHR.always( map[ jqXHR.status ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Cancel the request\n\t\t\t\tabort: function( statusText ) {\n\t\t\t\t\tvar finalText = statusText || strAbort;\n\t\t\t\t\tif ( transport ) {\n\t\t\t\t\t\ttransport.abort( finalText );\n\t\t\t\t\t}\n\t\t\t\t\tdone( 0, finalText );\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t};\n\n\t\t// Attach deferreds\n\t\tdeferred.promise( jqXHR ).complete = completeDeferred.add;\n\t\tjqXHR.success = jqXHR.done;\n\t\tjqXHR.error = jqXHR.fail;\n\n\t\t// Remove hash character (#7531: and string promotion)\n\t\t// Add protocol if not provided (#5866: IE7 issue with protocol-less urls)\n\t\t// Handle falsy url in the settings object (#10093: consistency with old signature)\n\t\t// We also use the url parameter if available\n\t\ts.url = ( ( url || s.url || ajaxLocation ) + \"\" ).replace( rhash, \"\" ).replace( rprotocol, ajaxLocParts[ 1 ] + \"//\" );\n\n\t\t// Alias method option to type as per ticket #12004\n\t\ts.type = options.method || options.type || s.method || s.type;\n\n\t\t// Extract dataTypes list\n\t\ts.dataTypes = jQuery.trim( s.dataType || \"*\" ).toLowerCase().match( rnotwhite ) || [ \"\" ];\n\n\t\t// A cross-domain request is in order when we have a protocol:host:port mismatch\n\t\tif ( s.crossDomain == null ) {\n\t\t\tparts = rurl.exec( s.url.toLowerCase() );\n\t\t\ts.crossDomain = !!( parts &&\n\t\t\t\t( parts[ 1 ] !== ajaxLocParts[ 1 ] || parts[ 2 ] !== ajaxLocParts[ 2 ] ||\n\t\t\t\t\t( parts[ 3 ] || ( parts[ 1 ] === \"http:\" ? \"80\" : \"443\" ) ) !==\n\t\t\t\t\t\t( ajaxLocParts[ 3 ] || ( ajaxLocParts[ 1 ] === \"http:\" ? \"80\" : \"443\" ) ) )\n\t\t\t);\n\t\t}\n\n\t\t// Convert data if not already a string\n\t\tif ( s.data && s.processData && typeof s.data !== \"string\" ) {\n\t\t\ts.data = jQuery.param( s.data, s.traditional );\n\t\t}\n\n\t\t// Apply prefilters\n\t\tinspectPrefiltersOrTransports( prefilters, s, options, jqXHR );\n\n\t\t// If request was aborted inside a prefilter, stop there\n\t\tif ( state === 2 ) {\n\t\t\treturn jqXHR;\n\t\t}\n\n\t\t// We can fire global events as of now if asked to\n\t\tfireGlobals = s.global;\n\n\t\t// Watch for a new set of requests\n\t\tif ( fireGlobals && jQuery.active++ === 0 ) {\n\t\t\tjQuery.event.trigger(\"ajaxStart\");\n\t\t}\n\n\t\t// Uppercase the type\n\t\ts.type = s.type.toUpperCase();\n\n\t\t// Determine if request has content\n\t\ts.hasContent = !rnoContent.test( s.type );\n\n\t\t// Save the URL in case we're toying with the If-Modified-Since\n\t\t// and/or If-None-Match header later on\n\t\tcacheURL = s.url;\n\n\t\t// More options handling for requests with no content\n\t\tif ( !s.hasContent ) {\n\n\t\t\t// If data is available, append data to url\n\t\t\tif ( s.data ) {\n\t\t\t\tcacheURL = ( s.url += ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + s.data );\n\t\t\t\t// #9682: remove data so that it's not used in an eventual retry\n\t\t\t\tdelete s.data;\n\t\t\t}\n\n\t\t\t// Add anti-cache in url if needed\n\t\t\tif ( s.cache === false ) {\n\t\t\t\ts.url = rts.test( cacheURL ) ?\n\n\t\t\t\t\t// If there is already a '_' parameter, set its value\n\t\t\t\t\tcacheURL.replace( rts, \"$1_=\" + nonce++ ) :\n\n\t\t\t\t\t// Otherwise add one to the end\n\t\t\t\t\tcacheURL + ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + \"_=\" + nonce++;\n\t\t\t}\n\t\t}\n\n\t\t// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n\t\tif ( s.ifModified ) {\n\t\t\tif ( jQuery.lastModified[ cacheURL ] ) {\n\t\t\t\tjqXHR.setRequestHeader( \"If-Modified-Since\", jQuery.lastModified[ cacheURL ] );\n\t\t\t}\n\t\t\tif ( jQuery.etag[ cacheURL ] ) {\n\t\t\t\tjqXHR.setRequestHeader( \"If-None-Match\", jQuery.etag[ cacheURL ] );\n\t\t\t}\n\t\t}\n\n\t\t// Set the correct header, if data is being sent\n\t\tif ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {\n\t\t\tjqXHR.setRequestHeader( \"Content-Type\", s.contentType );\n\t\t}\n\n\t\t// Set the Accepts header for the server, depending on the dataType\n\t\tjqXHR.setRequestHeader(\n\t\t\t\"Accept\",\n\t\t\ts.dataTypes[ 0 ] && s.accepts[ s.dataTypes[0] ] ?\n\t\t\t\ts.accepts[ s.dataTypes[0] ] + ( s.dataTypes[ 0 ] !== \"*\" ? \", \" + allTypes + \"; q=0.01\" : \"\" ) :\n\t\t\t\ts.accepts[ \"*\" ]\n\t\t);\n\n\t\t// Check for headers option\n\t\tfor ( i in s.headers ) {\n\t\t\tjqXHR.setRequestHeader( i, s.headers[ i ] );\n\t\t}\n\n\t\t// Allow custom headers/mimetypes and early abort\n\t\tif ( s.beforeSend && ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {\n\t\t\t// Abort if not done already and return\n\t\t\treturn jqXHR.abort();\n\t\t}\n\n\t\t// aborting is no longer a cancellation\n\t\tstrAbort = \"abort\";\n\n\t\t// Install callbacks on deferreds\n\t\tfor ( i in { success: 1, error: 1, complete: 1 } ) {\n\t\t\tjqXHR[ i ]( s[ i ] );\n\t\t}\n\n\t\t// Get transport\n\t\ttransport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );\n\n\t\t// If no transport, we auto-abort\n\t\tif ( !transport ) {\n\t\t\tdone( -1, \"No Transport\" );\n\t\t} else {\n\t\t\tjqXHR.readyState = 1;\n\n\t\t\t// Send global event\n\t\t\tif ( fireGlobals ) {\n\t\t\t\tglobalEventContext.trigger( \"ajaxSend\", [ jqXHR, s ] );\n\t\t\t}\n\t\t\t// Timeout\n\t\t\tif ( s.async && s.timeout > 0 ) {\n\t\t\t\ttimeoutTimer = setTimeout(function() {\n\t\t\t\t\tjqXHR.abort(\"timeout\");\n\t\t\t\t}, s.timeout );\n\t\t\t}\n\n\t\t\ttry {\n\t\t\t\tstate = 1;\n\t\t\t\ttransport.send( requestHeaders, done );\n\t\t\t} catch ( e ) {\n\t\t\t\t// Propagate exception as error if not done\n\t\t\t\tif ( state < 2 ) {\n\t\t\t\t\tdone( -1, e );\n\t\t\t\t// Simply rethrow otherwise\n\t\t\t\t} else {\n\t\t\t\t\tthrow e;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Callback for when everything is done\n\t\tfunction done( status, nativeStatusText, responses, headers ) {\n\t\t\tvar isSuccess, success, error, response, modified,\n\t\t\t\tstatusText = nativeStatusText;\n\n\t\t\t// Called once\n\t\t\tif ( state === 2 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// State is \"done\" now\n\t\t\tstate = 2;\n\n\t\t\t// Clear timeout if it exists\n\t\t\tif ( timeoutTimer ) {\n\t\t\t\tclearTimeout( timeoutTimer );\n\t\t\t}\n\n\t\t\t// Dereference transport for early garbage collection\n\t\t\t// (no matter how long the jqXHR object will be used)\n\t\t\ttransport = undefined;\n\n\t\t\t// Cache response headers\n\t\t\tresponseHeadersString = headers || \"\";\n\n\t\t\t// Set readyState\n\t\t\tjqXHR.readyState = status > 0 ? 4 : 0;\n\n\t\t\t// Determine if successful\n\t\t\tisSuccess = status >= 200 && status < 300 || status === 304;\n\n\t\t\t// Get response data\n\t\t\tif ( responses ) {\n\t\t\t\tresponse = ajaxHandleResponses( s, jqXHR, responses );\n\t\t\t}\n\n\t\t\t// Convert no matter what (that way responseXXX fields are always set)\n\t\t\tresponse = ajaxConvert( s, response, jqXHR, isSuccess );\n\n\t\t\t// If successful, handle type chaining\n\t\t\tif ( isSuccess ) {\n\n\t\t\t\t// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n\t\t\t\tif ( s.ifModified ) {\n\t\t\t\t\tmodified = jqXHR.getResponseHeader(\"Last-Modified\");\n\t\t\t\t\tif ( modified ) {\n\t\t\t\t\t\tjQuery.lastModified[ cacheURL ] = modified;\n\t\t\t\t\t}\n\t\t\t\t\tmodified = jqXHR.getResponseHeader(\"etag\");\n\t\t\t\t\tif ( modified ) {\n\t\t\t\t\t\tjQuery.etag[ cacheURL ] = modified;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// if no content\n\t\t\t\tif ( status === 204 || s.type === \"HEAD\" ) {\n\t\t\t\t\tstatusText = \"nocontent\";\n\n\t\t\t\t// if not modified\n\t\t\t\t} else if ( status === 304 ) {\n\t\t\t\t\tstatusText = \"notmodified\";\n\n\t\t\t\t// If we have data, let's convert it\n\t\t\t\t} else {\n\t\t\t\t\tstatusText = response.state;\n\t\t\t\t\tsuccess = response.data;\n\t\t\t\t\terror = response.error;\n\t\t\t\t\tisSuccess = !error;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// We extract error from statusText\n\t\t\t\t// then normalize statusText and status for non-aborts\n\t\t\t\terror = statusText;\n\t\t\t\tif ( status || !statusText ) {\n\t\t\t\t\tstatusText = \"error\";\n\t\t\t\t\tif ( status < 0 ) {\n\t\t\t\t\t\tstatus = 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set data for the fake xhr object\n\t\t\tjqXHR.status = status;\n\t\t\tjqXHR.statusText = ( nativeStatusText || statusText ) + \"\";\n\n\t\t\t// Success/Error\n\t\t\tif ( isSuccess ) {\n\t\t\t\tdeferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );\n\t\t\t} else {\n\t\t\t\tdeferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );\n\t\t\t}\n\n\t\t\t// Status-dependent callbacks\n\t\t\tjqXHR.statusCode( statusCode );\n\t\t\tstatusCode = undefined;\n\n\t\t\tif ( fireGlobals ) {\n\t\t\t\tglobalEventContext.trigger( isSuccess ? \"ajaxSuccess\" : \"ajaxError\",\n\t\t\t\t\t[ jqXHR, s, isSuccess ? success : error ] );\n\t\t\t}\n\n\t\t\t// Complete\n\t\t\tcompleteDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );\n\n\t\t\tif ( fireGlobals ) {\n\t\t\t\tglobalEventContext.trigger( \"ajaxComplete\", [ jqXHR, s ] );\n\t\t\t\t// Handle the global AJAX counter\n\t\t\t\tif ( !( --jQuery.active ) ) {\n\t\t\t\t\tjQuery.event.trigger(\"ajaxStop\");\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn jqXHR;\n\t},\n\n\tgetJSON: function( url, data, callback ) {\n\t\treturn jQuery.get( url, data, callback, \"json\" );\n\t},\n\n\tgetScript: function( url, callback ) {\n\t\treturn jQuery.get( url, undefined, callback, \"script\" );\n\t}\n});\n\njQuery.each( [ \"get\", \"post\" ], function( i, method ) {\n\tjQuery[ method ] = function( url, data, callback, type ) {\n\t\t// shift arguments if data argument was omitted\n\t\tif ( jQuery.isFunction( data ) ) {\n\t\t\ttype = type || callback;\n\t\t\tcallback = data;\n\t\t\tdata = undefined;\n\t\t}\n\n\t\treturn jQuery.ajax({\n\t\t\turl: url,\n\t\t\ttype: method,\n\t\t\tdataType: type,\n\t\t\tdata: data,\n\t\t\tsuccess: callback\n\t\t});\n\t};\n});\n\n// Attach a bunch of functions for handling common AJAX events\njQuery.each( [ \"ajaxStart\", \"ajaxStop\", \"ajaxComplete\", \"ajaxError\", \"ajaxSuccess\", \"ajaxSend\" ], function( i, type ) {\n\tjQuery.fn[ type ] = function( fn ) {\n\t\treturn this.on( type, fn );\n\t};\n});\n\n\njQuery._evalUrl = function( url ) {\n\treturn jQuery.ajax({\n\t\turl: url,\n\t\ttype: \"GET\",\n\t\tdataType: \"script\",\n\t\tasync: false,\n\t\tglobal: false,\n\t\t\"throws\": true\n\t});\n};\n\n\njQuery.fn.extend({\n\twrapAll: function( html ) {\n\t\tif ( jQuery.isFunction( html ) ) {\n\t\t\treturn this.each(function(i) {\n\t\t\t\tjQuery(this).wrapAll( html.call(this, i) );\n\t\t\t});\n\t\t}\n\n\t\tif ( this[0] ) {\n\t\t\t// The elements to wrap the target around\n\t\t\tvar wrap = jQuery( html, this[0].ownerDocument ).eq(0).clone(true);\n\n\t\t\tif ( this[0].parentNode ) {\n\t\t\t\twrap.insertBefore( this[0] );\n\t\t\t}\n\n\t\t\twrap.map(function() {\n\t\t\t\tvar elem = this;\n\n\t\t\t\twhile ( elem.firstChild && elem.firstChild.nodeType === 1 ) {\n\t\t\t\t\telem = elem.firstChild;\n\t\t\t\t}\n\n\t\t\t\treturn elem;\n\t\t\t}).append( this );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\twrapInner: function( html ) {\n\t\tif ( jQuery.isFunction( html ) ) {\n\t\t\treturn this.each(function(i) {\n\t\t\t\tjQuery(this).wrapInner( html.call(this, i) );\n\t\t\t});\n\t\t}\n\n\t\treturn this.each(function() {\n\t\t\tvar self = jQuery( this ),\n\t\t\t\tcontents = self.contents();\n\n\t\t\tif ( contents.length ) {\n\t\t\t\tcontents.wrapAll( html );\n\n\t\t\t} else {\n\t\t\t\tself.append( html );\n\t\t\t}\n\t\t});\n\t},\n\n\twrap: function( html ) {\n\t\tvar isFunction = jQuery.isFunction( html );\n\n\t\treturn this.each(function(i) {\n\t\t\tjQuery( this ).wrapAll( isFunction ? html.call(this, i) : html );\n\t\t});\n\t},\n\n\tunwrap: function() {\n\t\treturn this.parent().each(function() {\n\t\t\tif ( !jQuery.nodeName( this, \"body\" ) ) {\n\t\t\t\tjQuery( this ).replaceWith( this.childNodes );\n\t\t\t}\n\t\t}).end();\n\t}\n});\n\n\njQuery.expr.filters.hidden = function( elem ) {\n\t// Support: Opera <= 12.12\n\t// Opera reports offsetWidths and offsetHeights less than zero on some elements\n\treturn elem.offsetWidth <= 0 && elem.offsetHeight <= 0 ||\n\t\t(!support.reliableHiddenOffsets() &&\n\t\t\t((elem.style && elem.style.display) || jQuery.css( elem, \"display\" )) === \"none\");\n};\n\njQuery.expr.filters.visible = function( elem ) {\n\treturn !jQuery.expr.filters.hidden( elem );\n};\n\n\n\n\nvar r20 = /%20/g,\n\trbracket = /\\[\\]$/,\n\trCRLF = /\\r?\\n/g,\n\trsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,\n\trsubmittable = /^(?:input|select|textarea|keygen)/i;\n\nfunction buildParams( prefix, obj, traditional, add ) {\n\tvar name;\n\n\tif ( jQuery.isArray( obj ) ) {\n\t\t// Serialize array item.\n\t\tjQuery.each( obj, function( i, v ) {\n\t\t\tif ( traditional || rbracket.test( prefix ) ) {\n\t\t\t\t// Treat each array item as a scalar.\n\t\t\t\tadd( prefix, v );\n\n\t\t\t} else {\n\t\t\t\t// Item is non-scalar (array or object), encode its numeric index.\n\t\t\t\tbuildParams( prefix + \"[\" + ( typeof v === \"object\" ? i : \"\" ) + \"]\", v, traditional, add );\n\t\t\t}\n\t\t});\n\n\t} else if ( !traditional && jQuery.type( obj ) === \"object\" ) {\n\t\t// Serialize object item.\n\t\tfor ( name in obj ) {\n\t\t\tbuildParams( prefix + \"[\" + name + \"]\", obj[ name ], traditional, add );\n\t\t}\n\n\t} else {\n\t\t// Serialize scalar item.\n\t\tadd( prefix, obj );\n\t}\n}\n\n// Serialize an array of form elements or a set of\n// key/values into a query string\njQuery.param = function( a, traditional ) {\n\tvar prefix,\n\t\ts = [],\n\t\tadd = function( key, value ) {\n\t\t\t// If value is a function, invoke it and return its value\n\t\t\tvalue = jQuery.isFunction( value ) ? value() : ( value == null ? \"\" : value );\n\t\t\ts[ s.length ] = encodeURIComponent( key ) + \"=\" + encodeURIComponent( value );\n\t\t};\n\n\t// Set traditional to true for jQuery <= 1.3.2 behavior.\n\tif ( traditional === undefined ) {\n\t\ttraditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;\n\t}\n\n\t// If an array was passed in, assume that it is an array of form elements.\n\tif ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {\n\t\t// Serialize the form elements\n\t\tjQuery.each( a, function() {\n\t\t\tadd( this.name, this.value );\n\t\t});\n\n\t} else {\n\t\t// If traditional, encode the \"old\" way (the way 1.3.2 or older\n\t\t// did it), otherwise encode params recursively.\n\t\tfor ( prefix in a ) {\n\t\t\tbuildParams( prefix, a[ prefix ], traditional, add );\n\t\t}\n\t}\n\n\t// Return the resulting serialization\n\treturn s.join( \"&\" ).replace( r20, \"+\" );\n};\n\njQuery.fn.extend({\n\tserialize: function() {\n\t\treturn jQuery.param( this.serializeArray() );\n\t},\n\tserializeArray: function() {\n\t\treturn this.map(function() {\n\t\t\t// Can add propHook for \"elements\" to filter or add form elements\n\t\t\tvar elements = jQuery.prop( this, \"elements\" );\n\t\t\treturn elements ? jQuery.makeArray( elements ) : this;\n\t\t})\n\t\t.filter(function() {\n\t\t\tvar type = this.type;\n\t\t\t// Use .is(\":disabled\") so that fieldset[disabled] works\n\t\t\treturn this.name && !jQuery( this ).is( \":disabled\" ) &&\n\t\t\t\trsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&\n\t\t\t\t( this.checked || !rcheckableType.test( type ) );\n\t\t})\n\t\t.map(function( i, elem ) {\n\t\t\tvar val = jQuery( this ).val();\n\n\t\t\treturn val == null ?\n\t\t\t\tnull :\n\t\t\t\tjQuery.isArray( val ) ?\n\t\t\t\t\tjQuery.map( val, function( val ) {\n\t\t\t\t\t\treturn { name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n\t\t\t\t\t}) :\n\t\t\t\t\t{ name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n\t\t}).get();\n\t}\n});\n\n\n// Create the request object\n// (This is still attached to ajaxSettings for backward compatibility)\njQuery.ajaxSettings.xhr = window.ActiveXObject !== undefined ?\n\t// Support: IE6+\n\tfunction() {\n\n\t\t// XHR cannot access local files, always use ActiveX for that case\n\t\treturn !this.isLocal &&\n\n\t\t\t// Support: IE7-8\n\t\t\t// oldIE XHR does not support non-RFC2616 methods (#13240)\n\t\t\t// See http://msdn.microsoft.com/en-us/library/ie/ms536648(v=vs.85).aspx\n\t\t\t// and http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9\n\t\t\t// Although this check for six methods instead of eight\n\t\t\t// since IE also does not support \"trace\" and \"connect\"\n\t\t\t/^(get|post|head|put|delete|options)$/i.test( this.type ) &&\n\n\t\t\tcreateStandardXHR() || createActiveXHR();\n\t} :\n\t// For all other browsers, use the standard XMLHttpRequest object\n\tcreateStandardXHR;\n\nvar xhrId = 0,\n\txhrCallbacks = {},\n\txhrSupported = jQuery.ajaxSettings.xhr();\n\n// Support: IE<10\n// Open requests must be manually aborted on unload (#5280)\nif ( window.ActiveXObject ) {\n\tjQuery( window ).on( \"unload\", function() {\n\t\tfor ( var key in xhrCallbacks ) {\n\t\t\txhrCallbacks[ key ]( undefined, true );\n\t\t}\n\t});\n}\n\n// Determine support properties\nsupport.cors = !!xhrSupported && ( \"withCredentials\" in xhrSupported );\nxhrSupported = support.ajax = !!xhrSupported;\n\n// Create transport if the browser can provide an xhr\nif ( xhrSupported ) {\n\n\tjQuery.ajaxTransport(function( options ) {\n\t\t// Cross domain only allowed if supported through XMLHttpRequest\n\t\tif ( !options.crossDomain || support.cors ) {\n\n\t\t\tvar callback;\n\n\t\t\treturn {\n\t\t\t\tsend: function( headers, complete ) {\n\t\t\t\t\tvar i,\n\t\t\t\t\t\txhr = options.xhr(),\n\t\t\t\t\t\tid = ++xhrId;\n\n\t\t\t\t\t// Open the socket\n\t\t\t\t\txhr.open( options.type, options.url, options.async, options.username, options.password );\n\n\t\t\t\t\t// Apply custom fields if provided\n\t\t\t\t\tif ( options.xhrFields ) {\n\t\t\t\t\t\tfor ( i in options.xhrFields ) {\n\t\t\t\t\t\t\txhr[ i ] = options.xhrFields[ i ];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Override mime type if needed\n\t\t\t\t\tif ( options.mimeType && xhr.overrideMimeType ) {\n\t\t\t\t\t\txhr.overrideMimeType( options.mimeType );\n\t\t\t\t\t}\n\n\t\t\t\t\t// X-Requested-With header\n\t\t\t\t\t// For cross-domain requests, seeing as conditions for a preflight are\n\t\t\t\t\t// akin to a jigsaw puzzle, we simply never set it to be sure.\n\t\t\t\t\t// (it can always be set on a per-request basis or even using ajaxSetup)\n\t\t\t\t\t// For same-domain requests, won't change header if already provided.\n\t\t\t\t\tif ( !options.crossDomain && !headers[\"X-Requested-With\"] ) {\n\t\t\t\t\t\theaders[\"X-Requested-With\"] = \"XMLHttpRequest\";\n\t\t\t\t\t}\n\n\t\t\t\t\t// Set headers\n\t\t\t\t\tfor ( i in headers ) {\n\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t// IE's ActiveXObject throws a 'Type Mismatch' exception when setting\n\t\t\t\t\t\t// request header to a null-value.\n\t\t\t\t\t\t//\n\t\t\t\t\t\t// To keep consistent with other XHR implementations, cast the value\n\t\t\t\t\t\t// to string and ignore `undefined`.\n\t\t\t\t\t\tif ( headers[ i ] !== undefined ) {\n\t\t\t\t\t\t\txhr.setRequestHeader( i, headers[ i ] + \"\" );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Do send the request\n\t\t\t\t\t// This may raise an exception which is actually\n\t\t\t\t\t// handled in jQuery.ajax (so no try/catch here)\n\t\t\t\t\txhr.send( ( options.hasContent && options.data ) || null );\n\n\t\t\t\t\t// Listener\n\t\t\t\t\tcallback = function( _, isAbort ) {\n\t\t\t\t\t\tvar status, statusText, responses;\n\n\t\t\t\t\t\t// Was never called and is aborted or complete\n\t\t\t\t\t\tif ( callback && ( isAbort || xhr.readyState === 4 ) ) {\n\t\t\t\t\t\t\t// Clean up\n\t\t\t\t\t\t\tdelete xhrCallbacks[ id ];\n\t\t\t\t\t\t\tcallback = undefined;\n\t\t\t\t\t\t\txhr.onreadystatechange = jQuery.noop;\n\n\t\t\t\t\t\t\t// Abort manually if needed\n\t\t\t\t\t\t\tif ( isAbort ) {\n\t\t\t\t\t\t\t\tif ( xhr.readyState !== 4 ) {\n\t\t\t\t\t\t\t\t\txhr.abort();\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tresponses = {};\n\t\t\t\t\t\t\t\tstatus = xhr.status;\n\n\t\t\t\t\t\t\t\t// Support: IE<10\n\t\t\t\t\t\t\t\t// Accessing binary-data responseText throws an exception\n\t\t\t\t\t\t\t\t// (#11426)\n\t\t\t\t\t\t\t\tif ( typeof xhr.responseText === \"string\" ) {\n\t\t\t\t\t\t\t\t\tresponses.text = xhr.responseText;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Firefox throws an exception when accessing\n\t\t\t\t\t\t\t\t// statusText for faulty cross-domain requests\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tstatusText = xhr.statusText;\n\t\t\t\t\t\t\t\t} catch( e ) {\n\t\t\t\t\t\t\t\t\t// We normalize with Webkit giving an empty statusText\n\t\t\t\t\t\t\t\t\tstatusText = \"\";\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Filter status for non standard behaviors\n\n\t\t\t\t\t\t\t\t// If the request is local and we have data: assume a success\n\t\t\t\t\t\t\t\t// (success with no data won't get notified, that's the best we\n\t\t\t\t\t\t\t\t// can do given current implementations)\n\t\t\t\t\t\t\t\tif ( !status && options.isLocal && !options.crossDomain ) {\n\t\t\t\t\t\t\t\t\tstatus = responses.text ? 200 : 404;\n\t\t\t\t\t\t\t\t// IE - #1450: sometimes returns 1223 when it should be 204\n\t\t\t\t\t\t\t\t} else if ( status === 1223 ) {\n\t\t\t\t\t\t\t\t\tstatus = 204;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Call complete if needed\n\t\t\t\t\t\tif ( responses ) {\n\t\t\t\t\t\t\tcomplete( status, statusText, responses, xhr.getAllResponseHeaders() );\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\tif ( !options.async ) {\n\t\t\t\t\t\t// if we're in sync mode we fire the callback\n\t\t\t\t\t\tcallback();\n\t\t\t\t\t} else if ( xhr.readyState === 4 ) {\n\t\t\t\t\t\t// (IE6 & IE7) if it's in cache and has been\n\t\t\t\t\t\t// retrieved directly we need to fire the callback\n\t\t\t\t\t\tsetTimeout( callback );\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Add to the list of active xhr callbacks\n\t\t\t\t\t\txhr.onreadystatechange = xhrCallbacks[ id ] = callback;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tabort: function() {\n\t\t\t\t\tif ( callback ) {\n\t\t\t\t\t\tcallback( undefined, true );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t});\n}\n\n// Functions to create xhrs\nfunction createStandardXHR() {\n\ttry {\n\t\treturn new window.XMLHttpRequest();\n\t} catch( e ) {}\n}\n\nfunction createActiveXHR() {\n\ttry {\n\t\treturn new window.ActiveXObject( \"Microsoft.XMLHTTP\" );\n\t} catch( e ) {}\n}\n\n\n\n\n// Install script dataType\njQuery.ajaxSetup({\n\taccepts: {\n\t\tscript: \"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript\"\n\t},\n\tcontents: {\n\t\tscript: /(?:java|ecma)script/\n\t},\n\tconverters: {\n\t\t\"text script\": function( text ) {\n\t\t\tjQuery.globalEval( text );\n\t\t\treturn text;\n\t\t}\n\t}\n});\n\n// Handle cache's special case and global\njQuery.ajaxPrefilter( \"script\", function( s ) {\n\tif ( s.cache === undefined ) {\n\t\ts.cache = false;\n\t}\n\tif ( s.crossDomain ) {\n\t\ts.type = \"GET\";\n\t\ts.global = false;\n\t}\n});\n\n// Bind script tag hack transport\njQuery.ajaxTransport( \"script\", function(s) {\n\n\t// This transport only deals with cross domain requests\n\tif ( s.crossDomain ) {\n\n\t\tvar script,\n\t\t\thead = document.head || jQuery(\"head\")[0] || document.documentElement;\n\n\t\treturn {\n\n\t\t\tsend: function( _, callback ) {\n\n\t\t\t\tscript = document.createElement(\"script\");\n\n\t\t\t\tscript.async = true;\n\n\t\t\t\tif ( s.scriptCharset ) {\n\t\t\t\t\tscript.charset = s.scriptCharset;\n\t\t\t\t}\n\n\t\t\t\tscript.src = s.url;\n\n\t\t\t\t// Attach handlers for all browsers\n\t\t\t\tscript.onload = script.onreadystatechange = function( _, isAbort ) {\n\n\t\t\t\t\tif ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {\n\n\t\t\t\t\t\t// Handle memory leak in IE\n\t\t\t\t\t\tscript.onload = script.onreadystatechange = null;\n\n\t\t\t\t\t\t// Remove the script\n\t\t\t\t\t\tif ( script.parentNode ) {\n\t\t\t\t\t\t\tscript.parentNode.removeChild( script );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Dereference the script\n\t\t\t\t\t\tscript = null;\n\n\t\t\t\t\t\t// Callback if not abort\n\t\t\t\t\t\tif ( !isAbort ) {\n\t\t\t\t\t\t\tcallback( 200, \"success\" );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Circumvent IE6 bugs with base elements (#2709 and #4378) by prepending\n\t\t\t\t// Use native DOM manipulation to avoid our domManip AJAX trickery\n\t\t\t\thead.insertBefore( script, head.firstChild );\n\t\t\t},\n\n\t\t\tabort: function() {\n\t\t\t\tif ( script ) {\n\t\t\t\t\tscript.onload( undefined, true );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n});\n\n\n\n\nvar oldCallbacks = [],\n\trjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n// Default jsonp settings\njQuery.ajaxSetup({\n\tjsonp: \"callback\",\n\tjsonpCallback: function() {\n\t\tvar callback = oldCallbacks.pop() || ( jQuery.expando + \"_\" + ( nonce++ ) );\n\t\tthis[ callback ] = true;\n\t\treturn callback;\n\t}\n});\n\n// Detect, normalize options and install callbacks for jsonp requests\njQuery.ajaxPrefilter( \"json jsonp\", function( s, originalSettings, jqXHR ) {\n\n\tvar callbackName, overwritten, responseContainer,\n\t\tjsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?\n\t\t\t\"url\" :\n\t\t\ttypeof s.data === \"string\" && !( s.contentType || \"\" ).indexOf(\"application/x-www-form-urlencoded\") && rjsonp.test( s.data ) && \"data\"\n\t\t);\n\n\t// Handle iff the expected data type is \"jsonp\" or we have a parameter to set\n\tif ( jsonProp || s.dataTypes[ 0 ] === \"jsonp\" ) {\n\n\t\t// Get callback name, remembering preexisting value associated with it\n\t\tcallbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?\n\t\t\ts.jsonpCallback() :\n\t\t\ts.jsonpCallback;\n\n\t\t// Insert callback into url or form data\n\t\tif ( jsonProp ) {\n\t\t\ts[ jsonProp ] = s[ jsonProp ].replace( rjsonp, \"$1\" + callbackName );\n\t\t} else if ( s.jsonp !== false ) {\n\t\t\ts.url += ( rquery.test( s.url ) ? \"&\" : \"?\" ) + s.jsonp + \"=\" + callbackName;\n\t\t}\n\n\t\t// Use data converter to retrieve json after script execution\n\t\ts.converters[\"script json\"] = function() {\n\t\t\tif ( !responseContainer ) {\n\t\t\t\tjQuery.error( callbackName + \" was not called\" );\n\t\t\t}\n\t\t\treturn responseContainer[ 0 ];\n\t\t};\n\n\t\t// force json dataType\n\t\ts.dataTypes[ 0 ] = \"json\";\n\n\t\t// Install callback\n\t\toverwritten = window[ callbackName ];\n\t\twindow[ callbackName ] = function() {\n\t\t\tresponseContainer = arguments;\n\t\t};\n\n\t\t// Clean-up function (fires after converters)\n\t\tjqXHR.always(function() {\n\t\t\t// Restore preexisting value\n\t\t\twindow[ callbackName ] = overwritten;\n\n\t\t\t// Save back as free\n\t\t\tif ( s[ callbackName ] ) {\n\t\t\t\t// make sure that re-using the options doesn't screw things around\n\t\t\t\ts.jsonpCallback = originalSettings.jsonpCallback;\n\n\t\t\t\t// save the callback name for future use\n\t\t\t\toldCallbacks.push( callbackName );\n\t\t\t}\n\n\t\t\t// Call if it was a function and we have a response\n\t\t\tif ( responseContainer && jQuery.isFunction( overwritten ) ) {\n\t\t\t\toverwritten( responseContainer[ 0 ] );\n\t\t\t}\n\n\t\t\tresponseContainer = overwritten = undefined;\n\t\t});\n\n\t\t// Delegate to script\n\t\treturn \"script\";\n\t}\n});\n\n\n\n\n// data: string of html\n// context (optional): If specified, the fragment will be created in this context, defaults to document\n// keepScripts (optional): If true, will include scripts passed in the html string\njQuery.parseHTML = function( data, context, keepScripts ) {\n\tif ( !data || typeof data !== \"string\" ) {\n\t\treturn null;\n\t}\n\tif ( typeof context === \"boolean\" ) {\n\t\tkeepScripts = context;\n\t\tcontext = false;\n\t}\n\tcontext = context || document;\n\n\tvar parsed = rsingleTag.exec( data ),\n\t\tscripts = !keepScripts && [];\n\n\t// Single tag\n\tif ( parsed ) {\n\t\treturn [ context.createElement( parsed[1] ) ];\n\t}\n\n\tparsed = jQuery.buildFragment( [ data ], context, scripts );\n\n\tif ( scripts && scripts.length ) {\n\t\tjQuery( scripts ).remove();\n\t}\n\n\treturn jQuery.merge( [], parsed.childNodes );\n};\n\n\n// Keep a copy of the old load method\nvar _load = jQuery.fn.load;\n\n/**\n * Load a url into a page\n */\njQuery.fn.load = function( url, params, callback ) {\n\tif ( typeof url !== \"string\" && _load ) {\n\t\treturn _load.apply( this, arguments );\n\t}\n\n\tvar selector, response, type,\n\t\tself = this,\n\t\toff = url.indexOf(\" \");\n\n\tif ( off >= 0 ) {\n\t\tselector = url.slice( off, url.length );\n\t\turl = url.slice( 0, off );\n\t}\n\n\t// If it's a function\n\tif ( jQuery.isFunction( params ) ) {\n\n\t\t// We assume that it's the callback\n\t\tcallback = params;\n\t\tparams = undefined;\n\n\t// Otherwise, build a param string\n\t} else if ( params && typeof params === \"object\" ) {\n\t\ttype = \"POST\";\n\t}\n\n\t// If we have elements to modify, make the request\n\tif ( self.length > 0 ) {\n\t\tjQuery.ajax({\n\t\t\turl: url,\n\n\t\t\t// if \"type\" variable is undefined, then \"GET\" method will be used\n\t\t\ttype: type,\n\t\t\tdataType: \"html\",\n\t\t\tdata: params\n\t\t}).done(function( responseText ) {\n\n\t\t\t// Save response for use in complete callback\n\t\t\tresponse = arguments;\n\n\t\t\tself.html( selector ?\n\n\t\t\t\t// If a selector was specified, locate the right elements in a dummy div\n\t\t\t\t// Exclude scripts to avoid IE 'Permission Denied' errors\n\t\t\t\tjQuery(\"<div>\").append( jQuery.parseHTML( responseText ) ).find( selector ) :\n\n\t\t\t\t// Otherwise use the full result\n\t\t\t\tresponseText );\n\n\t\t}).complete( callback && function( jqXHR, status ) {\n\t\t\tself.each( callback, response || [ jqXHR.responseText, status, jqXHR ] );\n\t\t});\n\t}\n\n\treturn this;\n};\n\n\n\n\njQuery.expr.filters.animated = function( elem ) {\n\treturn jQuery.grep(jQuery.timers, function( fn ) {\n\t\treturn elem === fn.elem;\n\t}).length;\n};\n\n\n\n\n\nvar docElem = window.document.documentElement;\n\n/**\n * Gets a window from an element\n */\nfunction getWindow( elem ) {\n\treturn jQuery.isWindow( elem ) ?\n\t\telem :\n\t\telem.nodeType === 9 ?\n\t\t\telem.defaultView || elem.parentWindow :\n\t\t\tfalse;\n}\n\njQuery.offset = {\n\tsetOffset: function( elem, options, i ) {\n\t\tvar curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,\n\t\t\tposition = jQuery.css( elem, \"position\" ),\n\t\t\tcurElem = jQuery( elem ),\n\t\t\tprops = {};\n\n\t\t// set position first, in-case top/left are set even on static elem\n\t\tif ( position === \"static\" ) {\n\t\t\telem.style.position = \"relative\";\n\t\t}\n\n\t\tcurOffset = curElem.offset();\n\t\tcurCSSTop = jQuery.css( elem, \"top\" );\n\t\tcurCSSLeft = jQuery.css( elem, \"left\" );\n\t\tcalculatePosition = ( position === \"absolute\" || position === \"fixed\" ) &&\n\t\t\tjQuery.inArray(\"auto\", [ curCSSTop, curCSSLeft ] ) > -1;\n\n\t\t// need to be able to calculate position if either top or left is auto and position is either absolute or fixed\n\t\tif ( calculatePosition ) {\n\t\t\tcurPosition = curElem.position();\n\t\t\tcurTop = curPosition.top;\n\t\t\tcurLeft = curPosition.left;\n\t\t} else {\n\t\t\tcurTop = parseFloat( curCSSTop ) || 0;\n\t\t\tcurLeft = parseFloat( curCSSLeft ) || 0;\n\t\t}\n\n\t\tif ( jQuery.isFunction( options ) ) {\n\t\t\toptions = options.call( elem, i, curOffset );\n\t\t}\n\n\t\tif ( options.top != null ) {\n\t\t\tprops.top = ( options.top - curOffset.top ) + curTop;\n\t\t}\n\t\tif ( options.left != null ) {\n\t\t\tprops.left = ( options.left - curOffset.left ) + curLeft;\n\t\t}\n\n\t\tif ( \"using\" in options ) {\n\t\t\toptions.using.call( elem, props );\n\t\t} else {\n\t\t\tcurElem.css( props );\n\t\t}\n\t}\n};\n\njQuery.fn.extend({\n\toffset: function( options ) {\n\t\tif ( arguments.length ) {\n\t\t\treturn options === undefined ?\n\t\t\t\tthis :\n\t\t\t\tthis.each(function( i ) {\n\t\t\t\t\tjQuery.offset.setOffset( this, options, i );\n\t\t\t\t});\n\t\t}\n\n\t\tvar docElem, win,\n\t\t\tbox = { top: 0, left: 0 },\n\t\t\telem = this[ 0 ],\n\t\t\tdoc = elem && elem.ownerDocument;\n\n\t\tif ( !doc ) {\n\t\t\treturn;\n\t\t}\n\n\t\tdocElem = doc.documentElement;\n\n\t\t// Make sure it's not a disconnected DOM node\n\t\tif ( !jQuery.contains( docElem, elem ) ) {\n\t\t\treturn box;\n\t\t}\n\n\t\t// If we don't have gBCR, just use 0,0 rather than error\n\t\t// BlackBerry 5, iOS 3 (original iPhone)\n\t\tif ( typeof elem.getBoundingClientRect !== strundefined ) {\n\t\t\tbox = elem.getBoundingClientRect();\n\t\t}\n\t\twin = getWindow( doc );\n\t\treturn {\n\t\t\ttop: box.top  + ( win.pageYOffset || docElem.scrollTop )  - ( docElem.clientTop  || 0 ),\n\t\t\tleft: box.left + ( win.pageXOffset || docElem.scrollLeft ) - ( docElem.clientLeft || 0 )\n\t\t};\n\t},\n\n\tposition: function() {\n\t\tif ( !this[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar offsetParent, offset,\n\t\t\tparentOffset = { top: 0, left: 0 },\n\t\t\telem = this[ 0 ];\n\n\t\t// fixed elements are offset from window (parentOffset = {top:0, left: 0}, because it is its only offset parent\n\t\tif ( jQuery.css( elem, \"position\" ) === \"fixed\" ) {\n\t\t\t// we assume that getBoundingClientRect is available when computed position is fixed\n\t\t\toffset = elem.getBoundingClientRect();\n\t\t} else {\n\t\t\t// Get *real* offsetParent\n\t\t\toffsetParent = this.offsetParent();\n\n\t\t\t// Get correct offsets\n\t\t\toffset = this.offset();\n\t\t\tif ( !jQuery.nodeName( offsetParent[ 0 ], \"html\" ) ) {\n\t\t\t\tparentOffset = offsetParent.offset();\n\t\t\t}\n\n\t\t\t// Add offsetParent borders\n\t\t\tparentOffset.top  += jQuery.css( offsetParent[ 0 ], \"borderTopWidth\", true );\n\t\t\tparentOffset.left += jQuery.css( offsetParent[ 0 ], \"borderLeftWidth\", true );\n\t\t}\n\n\t\t// Subtract parent offsets and element margins\n\t\t// note: when an element has margin: auto the offsetLeft and marginLeft\n\t\t// are the same in Safari causing offset.left to incorrectly be 0\n\t\treturn {\n\t\t\ttop:  offset.top  - parentOffset.top - jQuery.css( elem, \"marginTop\", true ),\n\t\t\tleft: offset.left - parentOffset.left - jQuery.css( elem, \"marginLeft\", true)\n\t\t};\n\t},\n\n\toffsetParent: function() {\n\t\treturn this.map(function() {\n\t\t\tvar offsetParent = this.offsetParent || docElem;\n\n\t\t\twhile ( offsetParent && ( !jQuery.nodeName( offsetParent, \"html\" ) && jQuery.css( offsetParent, \"position\" ) === \"static\" ) ) {\n\t\t\t\toffsetParent = offsetParent.offsetParent;\n\t\t\t}\n\t\t\treturn offsetParent || docElem;\n\t\t});\n\t}\n});\n\n// Create scrollLeft and scrollTop methods\njQuery.each( { scrollLeft: \"pageXOffset\", scrollTop: \"pageYOffset\" }, function( method, prop ) {\n\tvar top = /Y/.test( prop );\n\n\tjQuery.fn[ method ] = function( val ) {\n\t\treturn access( this, function( elem, method, val ) {\n\t\t\tvar win = getWindow( elem );\n\n\t\t\tif ( val === undefined ) {\n\t\t\t\treturn win ? (prop in win) ? win[ prop ] :\n\t\t\t\t\twin.document.documentElement[ method ] :\n\t\t\t\t\telem[ method ];\n\t\t\t}\n\n\t\t\tif ( win ) {\n\t\t\t\twin.scrollTo(\n\t\t\t\t\t!top ? val : jQuery( win ).scrollLeft(),\n\t\t\t\t\ttop ? val : jQuery( win ).scrollTop()\n\t\t\t\t);\n\n\t\t\t} else {\n\t\t\t\telem[ method ] = val;\n\t\t\t}\n\t\t}, method, val, arguments.length, null );\n\t};\n});\n\n// Add the top/left cssHooks using jQuery.fn.position\n// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084\n// getComputedStyle returns percent when specified for top/left/bottom/right\n// rather than make the css module depend on the offset module, we just check for it here\njQuery.each( [ \"top\", \"left\" ], function( i, prop ) {\n\tjQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,\n\t\tfunction( elem, computed ) {\n\t\t\tif ( computed ) {\n\t\t\t\tcomputed = curCSS( elem, prop );\n\t\t\t\t// if curCSS returns percentage, fallback to offset\n\t\t\t\treturn rnumnonpx.test( computed ) ?\n\t\t\t\t\tjQuery( elem ).position()[ prop ] + \"px\" :\n\t\t\t\t\tcomputed;\n\t\t\t}\n\t\t}\n\t);\n});\n\n\n// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods\njQuery.each( { Height: \"height\", Width: \"width\" }, function( name, type ) {\n\tjQuery.each( { padding: \"inner\" + name, content: type, \"\": \"outer\" + name }, function( defaultExtra, funcName ) {\n\t\t// margin is only for outerHeight, outerWidth\n\t\tjQuery.fn[ funcName ] = function( margin, value ) {\n\t\t\tvar chainable = arguments.length && ( defaultExtra || typeof margin !== \"boolean\" ),\n\t\t\t\textra = defaultExtra || ( margin === true || value === true ? \"margin\" : \"border\" );\n\n\t\t\treturn access( this, function( elem, type, value ) {\n\t\t\t\tvar doc;\n\n\t\t\t\tif ( jQuery.isWindow( elem ) ) {\n\t\t\t\t\t// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there\n\t\t\t\t\t// isn't a whole lot we can do. See pull request at this URL for discussion:\n\t\t\t\t\t// https://github.com/jquery/jquery/pull/764\n\t\t\t\t\treturn elem.document.documentElement[ \"client\" + name ];\n\t\t\t\t}\n\n\t\t\t\t// Get document width or height\n\t\t\t\tif ( elem.nodeType === 9 ) {\n\t\t\t\t\tdoc = elem.documentElement;\n\n\t\t\t\t\t// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height], whichever is greatest\n\t\t\t\t\t// unfortunately, this causes bug #3838 in IE6/8 only, but there is currently no good, small way to fix it.\n\t\t\t\t\treturn Math.max(\n\t\t\t\t\t\telem.body[ \"scroll\" + name ], doc[ \"scroll\" + name ],\n\t\t\t\t\t\telem.body[ \"offset\" + name ], doc[ \"offset\" + name ],\n\t\t\t\t\t\tdoc[ \"client\" + name ]\n\t\t\t\t\t);\n\t\t\t\t}\n\n\t\t\t\treturn value === undefined ?\n\t\t\t\t\t// Get width or height on the element, requesting but not forcing parseFloat\n\t\t\t\t\tjQuery.css( elem, type, extra ) :\n\n\t\t\t\t\t// Set width or height on the element\n\t\t\t\t\tjQuery.style( elem, type, value, extra );\n\t\t\t}, type, chainable ? margin : undefined, chainable, null );\n\t\t};\n\t});\n});\n\n\n// The number of elements contained in the matched element set\njQuery.fn.size = function() {\n\treturn this.length;\n};\n\njQuery.fn.andSelf = jQuery.fn.addBack;\n\n\n\n\n// Register as a named AMD module, since jQuery can be concatenated with other\n// files that may use define, but not via a proper concatenation script that\n// understands anonymous AMD modules. A named AMD is safest and most robust\n// way to register. Lowercase jquery is used because AMD module names are\n// derived from file names, and jQuery is normally delivered in a lowercase\n// file name. Do this after creating the global so that if an AMD module wants\n// to call noConflict to hide this version of jQuery, it will work.\nif ( typeof define === \"function\" && define.amd ) {\n\tdefine( \"jquery\", [], function() {\n\t\treturn jQuery;\n\t});\n}\n\n\n\n\nvar\n\t// Map over jQuery in case of overwrite\n\t_jQuery = window.jQuery,\n\n\t// Map over the $ in case of overwrite\n\t_$ = window.$;\n\njQuery.noConflict = function( deep ) {\n\tif ( window.$ === jQuery ) {\n\t\twindow.$ = _$;\n\t}\n\n\tif ( deep && window.jQuery === jQuery ) {\n\t\twindow.jQuery = _jQuery;\n\t}\n\n\treturn jQuery;\n};\n\n// Expose jQuery and $ identifiers, even in\n// AMD (#7102#comment:10, https://github.com/jquery/jquery/pull/557)\n// and CommonJS for browser emulators (#13566)\nif ( typeof noGlobal === strundefined ) {\n\twindow.jQuery = window.$ = jQuery;\n}\n\n\n\n\nreturn jQuery;\n\n}));\n","matchMedia.js":"/*! matchMedia() polyfill - Test a CSS media type/query in JS. Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas, David Knight. Dual MIT/BSD license */\n\nwindow.matchMedia || (window.matchMedia = function() {\n    \"use strict\";\n\n    // For browsers that support matchMedium api such as IE 9 and webkit\n    var styleMedia = (window.styleMedia || window.media);\n\n    // For those that don't support matchMedium\n    if (!styleMedia) {\n        var style = document.createElement('style'),\n            script = document.getElementsByTagName('script')[0],\n            info = null;\n\n        style.type = 'text/css';\n        style.id = 'matchmediajs-test';\n\n        script.parentNode.insertBefore(style, script);\n\n        // 'style.currentStyle' is used by IE <= 8 and 'window.getComputedStyle' for all other browsers\n        info = ('getComputedStyle' in window) && window.getComputedStyle(style, null) || style.currentStyle;\n\n        styleMedia = {\n            matchMedium: function(media) {\n                var text = '@media ' + media + '{ #matchmediajs-test { width: 1px; } }';\n\n                // 'style.styleSheet' is used by IE <= 8 and 'style.textContent' for all other browsers\n                if (style.styleSheet) {\n                    style.styleSheet.cssText = text;\n                } else {\n                    style.textContent = text;\n                }\n\n                // Test if media query is true or false\n                return info.width === '1px';\n            }\n        };\n    }\n\n    return function(media) {\n        return {\n            matches: styleMedia.matchMedium(media || 'all'),\n            media: media || 'all'\n        };\n    };\n}());\n\n/*! matchMedia() polyfill addListener/removeListener extension. Author & copyright (c) 2012: Scott Jehl. Dual MIT/BSD license */\n(function() {\n    // Bail out for browsers that have addListener support\n    if (window.matchMedia && window.matchMedia('all').addListener) {\n        return false;\n    }\n\n    var localMatchMedia = window.matchMedia,\n        hasMediaQueries = localMatchMedia('only all').matches,\n        isListening = false,\n        timeoutID = 0, // setTimeout for debouncing 'handleChange'\n        queries = [], // Contains each 'mql' and associated 'listeners' if 'addListener' is used\n        handleChange = function(evt) {\n            // Debounce\n            clearTimeout(timeoutID);\n\n            timeoutID = setTimeout(function() {\n                for (var i = 0, il = queries.length; i < il; i++) {\n                    var mql = queries[i].mql,\n                        listeners = queries[i].listeners || [],\n                        matches = localMatchMedia(mql.media).matches;\n\n                    // Update mql.matches value and call listeners\n                    // Fire listeners only if transitioning to or from matched state\n                    if (matches !== mql.matches) {\n                        mql.matches = matches;\n\n                        for (var j = 0, jl = listeners.length; j < jl; j++) {\n                            listeners[j].call(window, mql);\n                        }\n                    }\n                }\n            }, 30);\n        };\n\n    window.matchMedia = function(media) {\n        var mql = localMatchMedia(media),\n            listeners = [],\n            index = 0;\n\n        mql.addListener = function(listener) {\n            // Changes would not occur to css media type so return now (Affects IE <= 8)\n            if (!hasMediaQueries) {\n                return;\n            }\n\n            // Set up 'resize' listener for browsers that support CSS3 media queries (Not for IE <= 8)\n            // There should only ever be 1 resize listener running for performance\n            if (!isListening) {\n                isListening = true;\n                window.addEventListener('resize', handleChange, true);\n            }\n\n            // Push object only if it has not been pushed already\n            if (index === 0) {\n                index = queries.push({\n                    mql: mql,\n                    listeners: listeners\n                });\n            }\n\n            listeners.push(listener);\n        };\n\n        mql.removeListener = function(listener) {\n            for (var i = 0, il = listeners.length; i < il; i++) {\n                if (listeners[i] === listener) {\n                    listeners.splice(i, 1);\n                }\n            }\n        };\n\n        return mql;\n    };\n}());\n\nwindow.mediaCheck = function(options) {\n    var mq;\n\n    function mqChange(mq, options) {\n        if (mq.matches) {\n            if (typeof options.entry === \"function\") {\n                options.entry();\n            }\n        } else if (typeof options.exit === \"function\") {\n            options.exit();\n        }\n    };\n\n    mq = window.matchMedia(options.media);\n\n    mq.addListener(function() {\n        mqChange(mq, options);\n    });\n\n    mqChange(mq, options);\n};","moment.js":"//! moment.js\n//! version : 2.8.1\n//! authors : Tim Wood, Iskren Chernev, Moment.js contributors\n//! license : MIT\n//! momentjs.com\n(function(a){function b(a,b,c){switch(arguments.length){case 2:return null!=a?a:b;case 3:return null!=a?a:null!=b?b:c;default:throw new Error(\"Implement me\")}}function c(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1}}function d(a){rb.suppressDeprecationWarnings===!1&&\"undefined\"!=typeof console&&console.warn&&console.warn(\"Deprecation warning: \"+a)}function e(a,b){var c=!0;return l(function(){return c&&(d(a),c=!1),b.apply(this,arguments)},b)}function f(a,b){nc[a]||(d(b),nc[a]=!0)}function g(a,b){return function(c){return o(a.call(this,c),b)}}function h(a,b){return function(c){return this.localeData().ordinal(a.call(this,c),b)}}function i(){}function j(a,b){b!==!1&&E(a),m(this,a),this._d=new Date(+a._d)}function k(a){var b=x(a),c=b.year||0,d=b.quarter||0,e=b.month||0,f=b.week||0,g=b.day||0,h=b.hour||0,i=b.minute||0,j=b.second||0,k=b.millisecond||0;this._milliseconds=+k+1e3*j+6e4*i+36e5*h,this._days=+g+7*f,this._months=+e+3*d+12*c,this._data={},this._locale=rb.localeData(),this._bubble()}function l(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c]);return b.hasOwnProperty(\"toString\")&&(a.toString=b.toString),b.hasOwnProperty(\"valueOf\")&&(a.valueOf=b.valueOf),a}function m(a,b){var c,d,e;if(\"undefined\"!=typeof b._isAMomentObject&&(a._isAMomentObject=b._isAMomentObject),\"undefined\"!=typeof b._i&&(a._i=b._i),\"undefined\"!=typeof b._f&&(a._f=b._f),\"undefined\"!=typeof b._l&&(a._l=b._l),\"undefined\"!=typeof b._strict&&(a._strict=b._strict),\"undefined\"!=typeof b._tzm&&(a._tzm=b._tzm),\"undefined\"!=typeof b._isUTC&&(a._isUTC=b._isUTC),\"undefined\"!=typeof b._offset&&(a._offset=b._offset),\"undefined\"!=typeof b._pf&&(a._pf=b._pf),\"undefined\"!=typeof b._locale&&(a._locale=b._locale),Fb.length>0)for(c in Fb)d=Fb[c],e=b[d],\"undefined\"!=typeof e&&(a[d]=e);return a}function n(a){return 0>a?Math.ceil(a):Math.floor(a)}function o(a,b,c){for(var d=\"\"+Math.abs(a),e=a>=0;d.length<b;)d=\"0\"+d;return(e?c?\"+\":\"\":\"-\")+d}function p(a,b){var c={milliseconds:0,months:0};return c.months=b.month()-a.month()+12*(b.year()-a.year()),a.clone().add(c.months,\"M\").isAfter(b)&&--c.months,c.milliseconds=+b-+a.clone().add(c.months,\"M\"),c}function q(a,b){var c;return b=J(b,a),a.isBefore(b)?c=p(a,b):(c=p(b,a),c.milliseconds=-c.milliseconds,c.months=-c.months),c}function r(a,b){return function(c,d){var e,g;return null===d||isNaN(+d)||(f(b,\"moment().\"+b+\"(period, number) is deprecated. Please use moment().\"+b+\"(number, period).\"),g=c,c=d,d=g),c=\"string\"==typeof c?+c:c,e=rb.duration(c,d),s(this,e,a),this}}function s(a,b,c,d){var e=b._milliseconds,f=b._days,g=b._months;d=null==d?!0:d,e&&a._d.setTime(+a._d+e*c),f&&lb(a,\"Date\",kb(a,\"Date\")+f*c),g&&jb(a,kb(a,\"Month\")+g*c),d&&rb.updateOffset(a,f||g)}function t(a){return\"[object Array]\"===Object.prototype.toString.call(a)}function u(a){return\"[object Date]\"===Object.prototype.toString.call(a)||a instanceof Date}function v(a,b,c){var d,e=Math.min(a.length,b.length),f=Math.abs(a.length-b.length),g=0;for(d=0;e>d;d++)(c&&a[d]!==b[d]||!c&&z(a[d])!==z(b[d]))&&g++;return g+f}function w(a){if(a){var b=a.toLowerCase().replace(/(.)s$/,\"$1\");a=gc[a]||hc[b]||b}return a}function x(a){var b,c,d={};for(c in a)a.hasOwnProperty(c)&&(b=w(c),b&&(d[b]=a[c]));return d}function y(b){var c,d;if(0===b.indexOf(\"week\"))c=7,d=\"day\";else{if(0!==b.indexOf(\"month\"))return;c=12,d=\"month\"}rb[b]=function(e,f){var g,h,i=rb._locale[b],j=[];if(\"number\"==typeof e&&(f=e,e=a),h=function(a){var b=rb().utc().set(d,a);return i.call(rb._locale,b,e||\"\")},null!=f)return h(f);for(g=0;c>g;g++)j.push(h(g));return j}}function z(a){var b=+a,c=0;return 0!==b&&isFinite(b)&&(c=b>=0?Math.floor(b):Math.ceil(b)),c}function A(a,b){return new Date(Date.UTC(a,b+1,0)).getUTCDate()}function B(a,b,c){return fb(rb([a,11,31+b-c]),b,c).week}function C(a){return D(a)?366:365}function D(a){return a%4===0&&a%100!==0||a%400===0}function E(a){var b;a._a&&-2===a._pf.overflow&&(b=a._a[yb]<0||a._a[yb]>11?yb:a._a[zb]<1||a._a[zb]>A(a._a[xb],a._a[yb])?zb:a._a[Ab]<0||a._a[Ab]>23?Ab:a._a[Bb]<0||a._a[Bb]>59?Bb:a._a[Cb]<0||a._a[Cb]>59?Cb:a._a[Db]<0||a._a[Db]>999?Db:-1,a._pf._overflowDayOfYear&&(xb>b||b>zb)&&(b=zb),a._pf.overflow=b)}function F(a){return null==a._isValid&&(a._isValid=!isNaN(a._d.getTime())&&a._pf.overflow<0&&!a._pf.empty&&!a._pf.invalidMonth&&!a._pf.nullInput&&!a._pf.invalidFormat&&!a._pf.userInvalidated,a._strict&&(a._isValid=a._isValid&&0===a._pf.charsLeftOver&&0===a._pf.unusedTokens.length)),a._isValid}function G(a){return a?a.toLowerCase().replace(\"_\",\"-\"):a}function H(a){for(var b,c,d,e,f=0;f<a.length;){for(e=G(a[f]).split(\"-\"),b=e.length,c=G(a[f+1]),c=c?c.split(\"-\"):null;b>0;){if(d=I(e.slice(0,b).join(\"-\")))return d;if(c&&c.length>=b&&v(e,c,!0)>=b-1)break;b--}f++}return null}function I(a){var b=null;if(!Eb[a]&&Gb)try{b=rb.locale(),require(\"./locale/\"+a),rb.locale(b)}catch(c){}return Eb[a]}function J(a,b){return b._isUTC?rb(a).zone(b._offset||0):rb(a).local()}function K(a){return a.match(/\\[[\\s\\S]/)?a.replace(/^\\[|\\]$/g,\"\"):a.replace(/\\\\/g,\"\")}function L(a){var b,c,d=a.match(Kb);for(b=0,c=d.length;c>b;b++)d[b]=mc[d[b]]?mc[d[b]]:K(d[b]);return function(e){var f=\"\";for(b=0;c>b;b++)f+=d[b]instanceof Function?d[b].call(e,a):d[b];return f}}function M(a,b){return a.isValid()?(b=N(b,a.localeData()),ic[b]||(ic[b]=L(b)),ic[b](a)):a.localeData().invalidDate()}function N(a,b){function c(a){return b.longDateFormat(a)||a}var d=5;for(Lb.lastIndex=0;d>=0&&Lb.test(a);)a=a.replace(Lb,c),Lb.lastIndex=0,d-=1;return a}function O(a,b){var c,d=b._strict;switch(a){case\"Q\":return Wb;case\"DDDD\":return Yb;case\"YYYY\":case\"GGGG\":case\"gggg\":return d?Zb:Ob;case\"Y\":case\"G\":case\"g\":return _b;case\"YYYYYY\":case\"YYYYY\":case\"GGGGG\":case\"ggggg\":return d?$b:Pb;case\"S\":if(d)return Wb;case\"SS\":if(d)return Xb;case\"SSS\":if(d)return Yb;case\"DDD\":return Nb;case\"MMM\":case\"MMMM\":case\"dd\":case\"ddd\":case\"dddd\":return Rb;case\"a\":case\"A\":return b._locale._meridiemParse;case\"X\":return Ub;case\"Z\":case\"ZZ\":return Sb;case\"T\":return Tb;case\"SSSS\":return Qb;case\"MM\":case\"DD\":case\"YY\":case\"GG\":case\"gg\":case\"HH\":case\"hh\":case\"mm\":case\"ss\":case\"ww\":case\"WW\":return d?Xb:Mb;case\"M\":case\"D\":case\"d\":case\"H\":case\"h\":case\"m\":case\"s\":case\"w\":case\"W\":case\"e\":case\"E\":return Mb;case\"Do\":return Vb;default:return c=new RegExp(X(W(a.replace(\"\\\\\",\"\")),\"i\"))}}function P(a){a=a||\"\";var b=a.match(Sb)||[],c=b[b.length-1]||[],d=(c+\"\").match(ec)||[\"-\",0,0],e=+(60*d[1])+z(d[2]);return\"+\"===d[0]?-e:e}function Q(a,b,c){var d,e=c._a;switch(a){case\"Q\":null!=b&&(e[yb]=3*(z(b)-1));break;case\"M\":case\"MM\":null!=b&&(e[yb]=z(b)-1);break;case\"MMM\":case\"MMMM\":d=c._locale.monthsParse(b),null!=d?e[yb]=d:c._pf.invalidMonth=b;break;case\"D\":case\"DD\":null!=b&&(e[zb]=z(b));break;case\"Do\":null!=b&&(e[zb]=z(parseInt(b,10)));break;case\"DDD\":case\"DDDD\":null!=b&&(c._dayOfYear=z(b));break;case\"YY\":e[xb]=rb.parseTwoDigitYear(b);break;case\"YYYY\":case\"YYYYY\":case\"YYYYYY\":e[xb]=z(b);break;case\"a\":case\"A\":c._isPm=c._locale.isPM(b);break;case\"H\":case\"HH\":case\"h\":case\"hh\":e[Ab]=z(b);break;case\"m\":case\"mm\":e[Bb]=z(b);break;case\"s\":case\"ss\":e[Cb]=z(b);break;case\"S\":case\"SS\":case\"SSS\":case\"SSSS\":e[Db]=z(1e3*(\"0.\"+b));break;case\"X\":c._d=new Date(1e3*parseFloat(b));break;case\"Z\":case\"ZZ\":c._useUTC=!0,c._tzm=P(b);break;case\"dd\":case\"ddd\":case\"dddd\":d=c._locale.weekdaysParse(b),null!=d?(c._w=c._w||{},c._w.d=d):c._pf.invalidWeekday=b;break;case\"w\":case\"ww\":case\"W\":case\"WW\":case\"d\":case\"e\":case\"E\":a=a.substr(0,1);case\"gggg\":case\"GGGG\":case\"GGGGG\":a=a.substr(0,2),b&&(c._w=c._w||{},c._w[a]=z(b));break;case\"gg\":case\"GG\":c._w=c._w||{},c._w[a]=rb.parseTwoDigitYear(b)}}function R(a){var c,d,e,f,g,h,i;c=a._w,null!=c.GG||null!=c.W||null!=c.E?(g=1,h=4,d=b(c.GG,a._a[xb],fb(rb(),1,4).year),e=b(c.W,1),f=b(c.E,1)):(g=a._locale._week.dow,h=a._locale._week.doy,d=b(c.gg,a._a[xb],fb(rb(),g,h).year),e=b(c.w,1),null!=c.d?(f=c.d,g>f&&++e):f=null!=c.e?c.e+g:g),i=gb(d,e,f,h,g),a._a[xb]=i.year,a._dayOfYear=i.dayOfYear}function S(a){var c,d,e,f,g=[];if(!a._d){for(e=U(a),a._w&&null==a._a[zb]&&null==a._a[yb]&&R(a),a._dayOfYear&&(f=b(a._a[xb],e[xb]),a._dayOfYear>C(f)&&(a._pf._overflowDayOfYear=!0),d=bb(f,0,a._dayOfYear),a._a[yb]=d.getUTCMonth(),a._a[zb]=d.getUTCDate()),c=0;3>c&&null==a._a[c];++c)a._a[c]=g[c]=e[c];for(;7>c;c++)a._a[c]=g[c]=null==a._a[c]?2===c?1:0:a._a[c];a._d=(a._useUTC?bb:ab).apply(null,g),null!=a._tzm&&a._d.setUTCMinutes(a._d.getUTCMinutes()+a._tzm)}}function T(a){var b;a._d||(b=x(a._i),a._a=[b.year,b.month,b.day,b.hour,b.minute,b.second,b.millisecond],S(a))}function U(a){var b=new Date;return a._useUTC?[b.getUTCFullYear(),b.getUTCMonth(),b.getUTCDate()]:[b.getFullYear(),b.getMonth(),b.getDate()]}function V(a){if(a._f===rb.ISO_8601)return void Z(a);a._a=[],a._pf.empty=!0;var b,c,d,e,f,g=\"\"+a._i,h=g.length,i=0;for(d=N(a._f,a._locale).match(Kb)||[],b=0;b<d.length;b++)e=d[b],c=(g.match(O(e,a))||[])[0],c&&(f=g.substr(0,g.indexOf(c)),f.length>0&&a._pf.unusedInput.push(f),g=g.slice(g.indexOf(c)+c.length),i+=c.length),mc[e]?(c?a._pf.empty=!1:a._pf.unusedTokens.push(e),Q(e,c,a)):a._strict&&!c&&a._pf.unusedTokens.push(e);a._pf.charsLeftOver=h-i,g.length>0&&a._pf.unusedInput.push(g),a._isPm&&a._a[Ab]<12&&(a._a[Ab]+=12),a._isPm===!1&&12===a._a[Ab]&&(a._a[Ab]=0),S(a),E(a)}function W(a){return a.replace(/\\\\(\\[)|\\\\(\\])|\\[([^\\]\\[]*)\\]|\\\\(.)/g,function(a,b,c,d,e){return b||c||d||e})}function X(a){return a.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g,\"\\\\$&\")}function Y(a){var b,d,e,f,g;if(0===a._f.length)return a._pf.invalidFormat=!0,void(a._d=new Date(0/0));for(f=0;f<a._f.length;f++)g=0,b=m({},a),b._pf=c(),b._f=a._f[f],V(b),F(b)&&(g+=b._pf.charsLeftOver,g+=10*b._pf.unusedTokens.length,b._pf.score=g,(null==e||e>g)&&(e=g,d=b));l(a,d||b)}function Z(a){var b,c,d=a._i,e=ac.exec(d);if(e){for(a._pf.iso=!0,b=0,c=cc.length;c>b;b++)if(cc[b][1].exec(d)){a._f=cc[b][0]+(e[6]||\" \");break}for(b=0,c=dc.length;c>b;b++)if(dc[b][1].exec(d)){a._f+=dc[b][0];break}d.match(Sb)&&(a._f+=\"Z\"),V(a)}else a._isValid=!1}function $(a){Z(a),a._isValid===!1&&(delete a._isValid,rb.createFromInputFallback(a))}function _(b){var c,d=b._i;d===a?b._d=new Date:u(d)?b._d=new Date(+d):null!==(c=Hb.exec(d))?b._d=new Date(+c[1]):\"string\"==typeof d?$(b):t(d)?(b._a=d.slice(0),S(b)):\"object\"==typeof d?T(b):\"number\"==typeof d?b._d=new Date(d):rb.createFromInputFallback(b)}function ab(a,b,c,d,e,f,g){var h=new Date(a,b,c,d,e,f,g);return 1970>a&&h.setFullYear(a),h}function bb(a){var b=new Date(Date.UTC.apply(null,arguments));return 1970>a&&b.setUTCFullYear(a),b}function cb(a,b){if(\"string\"==typeof a)if(isNaN(a)){if(a=b.weekdaysParse(a),\"number\"!=typeof a)return null}else a=parseInt(a,10);return a}function db(a,b,c,d,e){return e.relativeTime(b||1,!!c,a,d)}function eb(a,b,c){var d=rb.duration(a).abs(),e=wb(d.as(\"s\")),f=wb(d.as(\"m\")),g=wb(d.as(\"h\")),h=wb(d.as(\"d\")),i=wb(d.as(\"M\")),j=wb(d.as(\"y\")),k=e<jc.s&&[\"s\",e]||1===f&&[\"m\"]||f<jc.m&&[\"mm\",f]||1===g&&[\"h\"]||g<jc.h&&[\"hh\",g]||1===h&&[\"d\"]||h<jc.d&&[\"dd\",h]||1===i&&[\"M\"]||i<jc.M&&[\"MM\",i]||1===j&&[\"y\"]||[\"yy\",j];return k[2]=b,k[3]=+a>0,k[4]=c,db.apply({},k)}function fb(a,b,c){var d,e=c-b,f=c-a.day();return f>e&&(f-=7),e-7>f&&(f+=7),d=rb(a).add(f,\"d\"),{week:Math.ceil(d.dayOfYear()/7),year:d.year()}}function gb(a,b,c,d,e){var f,g,h=bb(a,0,1).getUTCDay();return h=0===h?7:h,c=null!=c?c:e,f=e-h+(h>d?7:0)-(e>h?7:0),g=7*(b-1)+(c-e)+f+1,{year:g>0?a:a-1,dayOfYear:g>0?g:C(a-1)+g}}function hb(b){var c=b._i,d=b._f;return b._locale=b._locale||rb.localeData(b._l),null===c||d===a&&\"\"===c?rb.invalid({nullInput:!0}):(\"string\"==typeof c&&(b._i=c=b._locale.preparse(c)),rb.isMoment(c)?new j(c,!0):(d?t(d)?Y(b):V(b):_(b),new j(b)))}function ib(a,b){var c,d;if(1===b.length&&t(b[0])&&(b=b[0]),!b.length)return rb();for(c=b[0],d=1;d<b.length;++d)b[d][a](c)&&(c=b[d]);return c}function jb(a,b){var c;return\"string\"==typeof b&&(b=a.localeData().monthsParse(b),\"number\"!=typeof b)?a:(c=Math.min(a.date(),A(a.year(),b)),a._d[\"set\"+(a._isUTC?\"UTC\":\"\")+\"Month\"](b,c),a)}function kb(a,b){return a._d[\"get\"+(a._isUTC?\"UTC\":\"\")+b]()}function lb(a,b,c){return\"Month\"===b?jb(a,c):a._d[\"set\"+(a._isUTC?\"UTC\":\"\")+b](c)}function mb(a,b){return function(c){return null!=c?(lb(this,a,c),rb.updateOffset(this,b),this):kb(this,a)}}function nb(a){return 400*a/146097}function ob(a){return 146097*a/400}function pb(a){rb.duration.fn[a]=function(){return this._data[a]}}function qb(a){\"undefined\"==typeof ender&&(sb=vb.moment,vb.moment=a?e(\"Accessing Moment through the global scope is deprecated, and will be removed in an upcoming release.\",rb):rb)}for(var rb,sb,tb,ub=\"2.8.1\",vb=\"undefined\"!=typeof global?global:this,wb=Math.round,xb=0,yb=1,zb=2,Ab=3,Bb=4,Cb=5,Db=6,Eb={},Fb=[],Gb=\"undefined\"!=typeof module&&module.exports,Hb=/^\\/?Date\\((\\-?\\d+)/i,Ib=/(\\-)?(?:(\\d*)\\.)?(\\d+)\\:(\\d+)(?:\\:(\\d+)\\.?(\\d{3})?)?/,Jb=/^(-)?P(?:(?:([0-9,.]*)Y)?(?:([0-9,.]*)M)?(?:([0-9,.]*)D)?(?:T(?:([0-9,.]*)H)?(?:([0-9,.]*)M)?(?:([0-9,.]*)S)?)?|([0-9,.]*)W)$/,Kb=/(\\[[^\\[]*\\])|(\\\\)?(Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Q|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|S{1,4}|X|zz?|ZZ?|.)/g,Lb=/(\\[[^\\[]*\\])|(\\\\)?(LT|LL?L?L?|l{1,4})/g,Mb=/\\d\\d?/,Nb=/\\d{1,3}/,Ob=/\\d{1,4}/,Pb=/[+\\-]?\\d{1,6}/,Qb=/\\d+/,Rb=/[0-9]*['a-z\\u00A0-\\u05FF\\u0700-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]+|[\\u0600-\\u06FF\\/]+(\\s*?[\\u0600-\\u06FF]+){1,2}/i,Sb=/Z|[\\+\\-]\\d\\d:?\\d\\d/gi,Tb=/T/i,Ub=/[\\+\\-]?\\d+(\\.\\d{1,3})?/,Vb=/\\d{1,2}/,Wb=/\\d/,Xb=/\\d\\d/,Yb=/\\d{3}/,Zb=/\\d{4}/,$b=/[+-]?\\d{6}/,_b=/[+-]?\\d+/,ac=/^\\s*(?:[+-]\\d{6}|\\d{4})-(?:(\\d\\d-\\d\\d)|(W\\d\\d$)|(W\\d\\d-\\d)|(\\d\\d\\d))((T| )(\\d\\d(:\\d\\d(:\\d\\d(\\.\\d+)?)?)?)?([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,bc=\"YYYY-MM-DDTHH:mm:ssZ\",cc=[[\"YYYYYY-MM-DD\",/[+-]\\d{6}-\\d{2}-\\d{2}/],[\"YYYY-MM-DD\",/\\d{4}-\\d{2}-\\d{2}/],[\"GGGG-[W]WW-E\",/\\d{4}-W\\d{2}-\\d/],[\"GGGG-[W]WW\",/\\d{4}-W\\d{2}/],[\"YYYY-DDD\",/\\d{4}-\\d{3}/]],dc=[[\"HH:mm:ss.SSSS\",/(T| )\\d\\d:\\d\\d:\\d\\d\\.\\d+/],[\"HH:mm:ss\",/(T| )\\d\\d:\\d\\d:\\d\\d/],[\"HH:mm\",/(T| )\\d\\d:\\d\\d/],[\"HH\",/(T| )\\d\\d/]],ec=/([\\+\\-]|\\d\\d)/gi,fc=(\"Date|Hours|Minutes|Seconds|Milliseconds\".split(\"|\"),{Milliseconds:1,Seconds:1e3,Minutes:6e4,Hours:36e5,Days:864e5,Months:2592e6,Years:31536e6}),gc={ms:\"millisecond\",s:\"second\",m:\"minute\",h:\"hour\",d:\"day\",D:\"date\",w:\"week\",W:\"isoWeek\",M:\"month\",Q:\"quarter\",y:\"year\",DDD:\"dayOfYear\",e:\"weekday\",E:\"isoWeekday\",gg:\"weekYear\",GG:\"isoWeekYear\"},hc={dayofyear:\"dayOfYear\",isoweekday:\"isoWeekday\",isoweek:\"isoWeek\",weekyear:\"weekYear\",isoweekyear:\"isoWeekYear\"},ic={},jc={s:45,m:45,h:22,d:26,M:11},kc=\"DDD w W M D d\".split(\" \"),lc=\"M D H h m s w W\".split(\" \"),mc={M:function(){return this.month()+1},MMM:function(a){return this.localeData().monthsShort(this,a)},MMMM:function(a){return this.localeData().months(this,a)},D:function(){return this.date()},DDD:function(){return this.dayOfYear()},d:function(){return this.day()},dd:function(a){return this.localeData().weekdaysMin(this,a)},ddd:function(a){return this.localeData().weekdaysShort(this,a)},dddd:function(a){return this.localeData().weekdays(this,a)},w:function(){return this.week()},W:function(){return this.isoWeek()},YY:function(){return o(this.year()%100,2)},YYYY:function(){return o(this.year(),4)},YYYYY:function(){return o(this.year(),5)},YYYYYY:function(){var a=this.year(),b=a>=0?\"+\":\"-\";return b+o(Math.abs(a),6)},gg:function(){return o(this.weekYear()%100,2)},gggg:function(){return o(this.weekYear(),4)},ggggg:function(){return o(this.weekYear(),5)},GG:function(){return o(this.isoWeekYear()%100,2)},GGGG:function(){return o(this.isoWeekYear(),4)},GGGGG:function(){return o(this.isoWeekYear(),5)},e:function(){return this.weekday()},E:function(){return this.isoWeekday()},a:function(){return this.localeData().meridiem(this.hours(),this.minutes(),!0)},A:function(){return this.localeData().meridiem(this.hours(),this.minutes(),!1)},H:function(){return this.hours()},h:function(){return this.hours()%12||12},m:function(){return this.minutes()},s:function(){return this.seconds()},S:function(){return z(this.milliseconds()/100)},SS:function(){return o(z(this.milliseconds()/10),2)},SSS:function(){return o(this.milliseconds(),3)},SSSS:function(){return o(this.milliseconds(),3)},Z:function(){var a=-this.zone(),b=\"+\";return 0>a&&(a=-a,b=\"-\"),b+o(z(a/60),2)+\":\"+o(z(a)%60,2)},ZZ:function(){var a=-this.zone(),b=\"+\";return 0>a&&(a=-a,b=\"-\"),b+o(z(a/60),2)+o(z(a)%60,2)},z:function(){return this.zoneAbbr()},zz:function(){return this.zoneName()},X:function(){return this.unix()},Q:function(){return this.quarter()}},nc={},oc=[\"months\",\"monthsShort\",\"weekdays\",\"weekdaysShort\",\"weekdaysMin\"];kc.length;)tb=kc.pop(),mc[tb+\"o\"]=h(mc[tb],tb);for(;lc.length;)tb=lc.pop(),mc[tb+tb]=g(mc[tb],2);mc.DDDD=g(mc.DDD,3),l(i.prototype,{set:function(a){var b,c;for(c in a)b=a[c],\"function\"==typeof b?this[c]=b:this[\"_\"+c]=b},_months:\"January_February_March_April_May_June_July_August_September_October_November_December\".split(\"_\"),months:function(a){return this._months[a.month()]},_monthsShort:\"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec\".split(\"_\"),monthsShort:function(a){return this._monthsShort[a.month()]},monthsParse:function(a){var b,c,d;for(this._monthsParse||(this._monthsParse=[]),b=0;12>b;b++)if(this._monthsParse[b]||(c=rb.utc([2e3,b]),d=\"^\"+this.months(c,\"\")+\"|^\"+this.monthsShort(c,\"\"),this._monthsParse[b]=new RegExp(d.replace(\".\",\"\"),\"i\")),this._monthsParse[b].test(a))return b},_weekdays:\"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday\".split(\"_\"),weekdays:function(a){return this._weekdays[a.day()]},_weekdaysShort:\"Sun_Mon_Tue_Wed_Thu_Fri_Sat\".split(\"_\"),weekdaysShort:function(a){return this._weekdaysShort[a.day()]},_weekdaysMin:\"Su_Mo_Tu_We_Th_Fr_Sa\".split(\"_\"),weekdaysMin:function(a){return this._weekdaysMin[a.day()]},weekdaysParse:function(a){var b,c,d;for(this._weekdaysParse||(this._weekdaysParse=[]),b=0;7>b;b++)if(this._weekdaysParse[b]||(c=rb([2e3,1]).day(b),d=\"^\"+this.weekdays(c,\"\")+\"|^\"+this.weekdaysShort(c,\"\")+\"|^\"+this.weekdaysMin(c,\"\"),this._weekdaysParse[b]=new RegExp(d.replace(\".\",\"\"),\"i\")),this._weekdaysParse[b].test(a))return b},_longDateFormat:{LT:\"h:mm A\",L:\"MM/DD/YYYY\",LL:\"MMMM D, YYYY\",LLL:\"MMMM D, YYYY LT\",LLLL:\"dddd, MMMM D, YYYY LT\"},longDateFormat:function(a){var b=this._longDateFormat[a];return!b&&this._longDateFormat[a.toUpperCase()]&&(b=this._longDateFormat[a.toUpperCase()].replace(/MMMM|MM|DD|dddd/g,function(a){return a.slice(1)}),this._longDateFormat[a]=b),b},isPM:function(a){return\"p\"===(a+\"\").toLowerCase().charAt(0)},_meridiemParse:/[ap]\\.?m?\\.?/i,meridiem:function(a,b,c){return a>11?c?\"pm\":\"PM\":c?\"am\":\"AM\"},_calendar:{sameDay:\"[Today at] LT\",nextDay:\"[Tomorrow at] LT\",nextWeek:\"dddd [at] LT\",lastDay:\"[Yesterday at] LT\",lastWeek:\"[Last] dddd [at] LT\",sameElse:\"L\"},calendar:function(a