require.config({
    config: {
        'jsbuild':{"knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.3.0\n * (c) Steven Sanderson - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\nvar DEBUG=true;\n(function(undefined){\n    // (0, eval)('this') is a robust way of getting a reference to the global object\n    // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n    var window = this || (0, eval)('this'),\n        document = window['document'],\n        navigator = window['navigator'],\n        jQueryInstance = window[\"jQuery\"],\n        JSON = window[\"JSON\"];\n(function(factory) {\n    // Support three module loading scenarios\n    if (typeof define === 'function' && define['amd']) {\n        // [1] AMD anonymous module\n        define(['exports', 'require'], factory);\n    } else if (typeof require === 'function' && typeof exports === 'object' && typeof module === 'object') {\n        // [2] CommonJS/Node.js\n        factory(module['exports'] || exports);  // module.exports is for Node.js\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window['ko'] = {});\n    }\n}(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\nvar ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\nko.exportSymbol = function(koPath, object) {\n    var tokens = koPath.split(\".\");\n\n    // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n    // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n    var target = ko;\n\n    for (var i = 0; i < tokens.length - 1; i++)\n        target = target[tokens[i]];\n    target[tokens[tokens.length - 1]] = object;\n};\nko.exportProperty = function(owner, publicName, object) {\n    owner[publicName] = object;\n};\nko.version = \"3.3.0\";\n\nko.exportSymbol('version', ko.version);\nko.utils = (function () {\n    function objectForEach(obj, action) {\n        for (var prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                action(prop, obj[prop]);\n            }\n        }\n    }\n\n    function extend(target, source) {\n        if (source) {\n            for(var prop in source) {\n                if(source.hasOwnProperty(prop)) {\n                    target[prop] = source[prop];\n                }\n            }\n        }\n        return target;\n    }\n\n    function setPrototypeOf(obj, proto) {\n        obj.__proto__ = proto;\n        return obj;\n    }\n\n    var canSetPrototype = ({ __proto__: [] } instanceof Array);\n\n    // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n    var knownEvents = {}, knownEventTypesByEventName = {};\n    var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n    knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n    knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n    objectForEach(knownEvents, function(eventType, knownEventsForType) {\n        if (knownEventsForType.length) {\n            for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n        }\n    });\n    var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n    // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n    // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n    // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n    // If there is a future need to detect specific versions of IE10+, we will amend this.\n    var ieVersion = document && (function() {\n        var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n        // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n        while (\n            div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n            iElems[0]\n        ) {}\n        return version > 4 ? version : undefined;\n    }());\n    var isIe6 = ieVersion === 6,\n        isIe7 = ieVersion === 7;\n\n    function isClickOnCheckableElement(element, eventType) {\n        if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n        if (eventType.toLowerCase() != \"click\") return false;\n        var inputType = element.type;\n        return (inputType == \"checkbox\") || (inputType == \"radio\");\n    }\n\n    // For details on the pattern for changing node classes\n    // see: https://github.com/knockout/knockout/issues/1597\n    var cssClassNameRegex = /\\S+/g;\n\n    function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n        var addOrRemoveFn;\n        if (classNames) {\n            if (typeof node.classList === 'object') {\n                addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                    addOrRemoveFn.call(node.classList, className);\n                });\n            } else if (typeof node.className['baseVal'] === 'string') {\n                // SVG tag .classNames is an SVGAnimatedString instance\n                toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n            } else {\n                // node.className ought to be a string.\n                toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n            }\n        }\n    }\n\n    function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n        // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n        var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n        ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n            ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n        });\n        obj[prop] = currentClassNames.join(\" \");\n    }\n\n    return {\n        fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n        arrayForEach: function (array, action) {\n            for (var i = 0, j = array.length; i < j; i++)\n                action(array[i], i);\n        },\n\n        arrayIndexOf: function (array, item) {\n            if (typeof Array.prototype.indexOf == \"function\")\n                return Array.prototype.indexOf.call(array, item);\n            for (var i = 0, j = array.length; i < j; i++)\n                if (array[i] === item)\n                    return i;\n            return -1;\n        },\n\n        arrayFirst: function (array, predicate, predicateOwner) {\n            for (var i = 0, j = array.length; i < j; i++)\n                if (predicate.call(predicateOwner, array[i], i))\n                    return array[i];\n            return null;\n        },\n\n        arrayRemoveItem: function (array, itemToRemove) {\n            var index = ko.utils.arrayIndexOf(array, itemToRemove);\n            if (index > 0) {\n                array.splice(index, 1);\n            }\n            else if (index === 0) {\n                array.shift();\n            }\n        },\n\n        arrayGetDistinctValues: function (array) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++) {\n                if (ko.utils.arrayIndexOf(result, array[i]) < 0)\n                    result.push(array[i]);\n            }\n            return result;\n        },\n\n        arrayMap: function (array, mapping) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++)\n                result.push(mapping(array[i], i));\n            return result;\n        },\n\n        arrayFilter: function (array, predicate) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++)\n                if (predicate(array[i], i))\n                    result.push(array[i]);\n            return result;\n        },\n\n        arrayPushAll: function (array, valuesToPush) {\n            if (valuesToPush instanceof Array)\n                array.push.apply(array, valuesToPush);\n            else\n                for (var i = 0, j = valuesToPush.length; i < j; i++)\n                    array.push(valuesToPush[i]);\n            return array;\n        },\n\n        addOrRemoveItem: function(array, value, included) {\n            var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n            if (existingEntryIndex < 0) {\n                if (included)\n                    array.push(value);\n            } else {\n                if (!included)\n                    array.splice(existingEntryIndex, 1);\n            }\n        },\n\n        canSetPrototype: canSetPrototype,\n\n        extend: extend,\n\n        setPrototypeOf: setPrototypeOf,\n\n        setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n        objectForEach: objectForEach,\n\n        objectMap: function(source, mapping) {\n            if (!source)\n                return source;\n            var target = {};\n            for (var prop in source) {\n                if (source.hasOwnProperty(prop)) {\n                    target[prop] = mapping(source[prop], prop, source);\n                }\n            }\n            return target;\n        },\n\n        emptyDomNode: function (domNode) {\n            while (domNode.firstChild) {\n                ko.removeNode(domNode.firstChild);\n            }\n        },\n\n        moveCleanedNodesToContainerElement: function(nodes) {\n            // Ensure it's a real array, as we're about to reparent the nodes and\n            // we don't want the underlying collection to change while we're doing that.\n            var nodesArray = ko.utils.makeArray(nodes);\n            var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n            var container = templateDocument.createElement('div');\n            for (var i = 0, j = nodesArray.length; i < j; i++) {\n                container.appendChild(ko.cleanNode(nodesArray[i]));\n            }\n            return container;\n        },\n\n        cloneNodes: function (nodesArray, shouldCleanNodes) {\n            for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                var clonedNode = nodesArray[i].cloneNode(true);\n                newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n            }\n            return newNodesArray;\n        },\n\n        setDomNodeChildren: function (domNode, childNodes) {\n            ko.utils.emptyDomNode(domNode);\n            if (childNodes) {\n                for (var i = 0, j = childNodes.length; i < j; i++)\n                    domNode.appendChild(childNodes[i]);\n            }\n        },\n\n        replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n            var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n            if (nodesToReplaceArray.length > 0) {\n                var insertionPoint = nodesToReplaceArray[0];\n                var parent = insertionPoint.parentNode;\n                for (var i = 0, j = newNodesArray.length; i < j; i++)\n                    parent.insertBefore(newNodesArray[i], insertionPoint);\n                for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                    ko.removeNode(nodesToReplaceArray[i]);\n                }\n            }\n        },\n\n        fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n            // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n            // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n            // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n            // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n            // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n            //\n            // Rules:\n            //   [A] Any leading nodes that have been removed should be ignored\n            //       These most likely correspond to memoization nodes that were already removed during binding\n            //       See https://github.com/SteveSanderson/knockout/pull/440\n            //   [B] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n            //       and include any nodes that have been inserted among the previous collection\n\n            if (continuousNodeArray.length) {\n                // The parent node can be a virtual element; so get the real parent node\n                parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                // Rule [A]\n                while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                    continuousNodeArray.splice(0, 1);\n\n                // Rule [B]\n                if (continuousNodeArray.length > 1) {\n                    var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                    // Replace with the actual new continuous node set\n                    continuousNodeArray.length = 0;\n                    while (current !== last) {\n                        continuousNodeArray.push(current);\n                        current = current.nextSibling;\n                        if (!current) // Won't happen, except if the developer has manually removed some DOM elements (then we're in an undefined scenario)\n                            return;\n                    }\n                    continuousNodeArray.push(last);\n                }\n            }\n            return continuousNodeArray;\n        },\n\n        setOptionNodeSelectionState: function (optionNode, isSelected) {\n            // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n            if (ieVersion < 7)\n                optionNode.setAttribute(\"selected\", isSelected);\n            else\n                optionNode.selected = isSelected;\n        },\n\n        stringTrim: function (string) {\n            return string === null || string === undefined ? '' :\n                string.trim ?\n                    string.trim() :\n                    string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n        },\n\n        stringStartsWith: function (string, startsWith) {\n            string = string || \"\";\n            if (startsWith.length > string.length)\n                return false;\n            return string.substring(0, startsWith.length) === startsWith;\n        },\n\n        domNodeIsContainedBy: function (node, containedByNode) {\n            if (node === containedByNode)\n                return true;\n            if (node.nodeType === 11)\n                return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n            if (containedByNode.contains)\n                return containedByNode.contains(node.nodeType === 3 ? node.parentNode : node);\n            if (containedByNode.compareDocumentPosition)\n                return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n            while (node && node != containedByNode) {\n                node = node.parentNode;\n            }\n            return !!node;\n        },\n\n        domNodeIsAttachedToDocument: function (node) {\n            return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n        },\n\n        anyDomNodeIsAttachedToDocument: function(nodes) {\n            return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n        },\n\n        tagNameLower: function(element) {\n            // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n            // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n            // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n            return element && element.tagName && element.tagName.toLowerCase();\n        },\n\n        registerEventHandler: function (element, eventType, handler) {\n            var mustUseAttachEvent = ieVersion && eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n            if (!mustUseAttachEvent && jQueryInstance) {\n                jQueryInstance(element)['bind'](eventType, handler);\n            } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                element.addEventListener(eventType, handler, false);\n            else if (typeof element.attachEvent != \"undefined\") {\n                var attachEventHandler = function (event) { handler.call(element, event); },\n                    attachEventName = \"on\" + eventType;\n                element.attachEvent(attachEventName, attachEventHandler);\n\n                // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                // so to avoid leaks, we have to remove them manually. See bug #856\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                    element.detachEvent(attachEventName, attachEventHandler);\n                });\n            } else\n                throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n        },\n\n        triggerEvent: function (element, eventType) {\n            if (!(element && element.nodeType))\n                throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n            // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n            // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n            // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n            // In both cases, we'll use the click method instead.\n            var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n            if (jQueryInstance && !useClickWorkaround) {\n                jQueryInstance(element)['trigger'](eventType);\n            } else if (typeof document.createEvent == \"function\") {\n                if (typeof element.dispatchEvent == \"function\") {\n                    var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                    var event = document.createEvent(eventCategory);\n                    event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                    element.dispatchEvent(event);\n                }\n                else\n                    throw new Error(\"The supplied element doesn't support dispatchEvent\");\n            } else if (useClickWorkaround && element.click) {\n                element.click();\n            } else if (typeof element.fireEvent != \"undefined\") {\n                element.fireEvent(\"on\" + eventType);\n            } else {\n                throw new Error(\"Browser doesn't support triggering events\");\n            }\n        },\n\n        unwrapObservable: function (value) {\n            return ko.isObservable(value) ? value() : value;\n        },\n\n        peekObservable: function (value) {\n            return ko.isObservable(value) ? value.peek() : value;\n        },\n\n        toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n        setTextContent: function(element, textContent) {\n            var value = ko.utils.unwrapObservable(textContent);\n            if ((value === null) || (value === undefined))\n                value = \"\";\n\n            // We need there to be exactly one child: a text node.\n            // If there are no children, more than one, or if it's not a text node,\n            // we'll clear everything and create a single text node.\n            var innerTextNode = ko.virtualElements.firstChild(element);\n            if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n            } else {\n                innerTextNode.data = value;\n            }\n\n            ko.utils.forceRefresh(element);\n        },\n\n        setElementName: function(element, name) {\n            element.name = name;\n\n            // Workaround IE 6/7 issue\n            // - https://github.com/SteveSanderson/knockout/issues/197\n            // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n            if (ieVersion <= 7) {\n                try {\n                    element.mergeAttributes(document.createElement(\"<input name='\" + element.name + \"'/>\"), false);\n                }\n                catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n            }\n        },\n\n        forceRefresh: function(node) {\n            // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n            if (ieVersion >= 9) {\n                // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                var elem = node.nodeType == 1 ? node : node.parentNode;\n                if (elem.style)\n                    elem.style.zoom = elem.style.zoom;\n            }\n        },\n\n        ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n            // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n            // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n            // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n            if (ieVersion) {\n                var originalWidth = selectElement.style.width;\n                selectElement.style.width = 0;\n                selectElement.style.width = originalWidth;\n            }\n        },\n\n        range: function (min, max) {\n            min = ko.utils.unwrapObservable(min);\n            max = ko.utils.unwrapObservable(max);\n            var result = [];\n            for (var i = min; i <= max; i++)\n                result.push(i);\n            return result;\n        },\n\n        makeArray: function(arrayLikeObject) {\n            var result = [];\n            for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                result.push(arrayLikeObject[i]);\n            };\n            return result;\n        },\n\n        isIe6 : isIe6,\n        isIe7 : isIe7,\n        ieVersion : ieVersion,\n\n        getFormFields: function(form, fieldName) {\n            var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n            var isMatchingField = (typeof fieldName == 'string')\n                ? function(field) { return field.name === fieldName }\n                : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n            var matches = [];\n            for (var i = fields.length - 1; i >= 0; i--) {\n                if (isMatchingField(fields[i]))\n                    matches.push(fields[i]);\n            };\n            return matches;\n        },\n\n        parseJson: function (jsonString) {\n            if (typeof jsonString == \"string\") {\n                jsonString = ko.utils.stringTrim(jsonString);\n                if (jsonString) {\n                    if (JSON && JSON.parse) // Use native parsing where available\n                        return JSON.parse(jsonString);\n                    return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                }\n            }\n            return null;\n        },\n\n        stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n            if (!JSON || !JSON.stringify)\n                throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n            return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n        },\n\n        postJson: function (urlOrForm, data, options) {\n            options = options || {};\n            var params = options['params'] || {};\n            var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n            var url = urlOrForm;\n\n            // If we were given a form, use its 'action' URL and pick out any requested field values\n            if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                var originalForm = urlOrForm;\n                url = originalForm.action;\n                for (var i = includeFields.length - 1; i >= 0; i--) {\n                    var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                    for (var j = fields.length - 1; j >= 0; j--)\n                        params[fields[j].name] = fields[j].value;\n                }\n            }\n\n            data = ko.utils.unwrapObservable(data);\n            var form = document.createElement(\"form\");\n            form.style.display = \"none\";\n            form.action = url;\n            form.method = \"post\";\n            for (var key in data) {\n                // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                var input = document.createElement(\"input\");\n                input.type = \"hidden\";\n                input.name = key;\n                input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                form.appendChild(input);\n            }\n            objectForEach(params, function(key, value) {\n                var input = document.createElement(\"input\");\n                input.type = \"hidden\";\n                input.name = key;\n                input.value = value;\n                form.appendChild(input);\n            });\n            document.body.appendChild(form);\n            options['submitter'] ? options['submitter'](form) : form.submit();\n            setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n        }\n    }\n}());\n\nko.exportSymbol('utils', ko.utils);\nko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\nko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\nko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\nko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\nko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\nko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\nko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\nko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\nko.exportSymbol('utils.extend', ko.utils.extend);\nko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\nko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\nko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\nko.exportSymbol('utils.postJson', ko.utils.postJson);\nko.exportSymbol('utils.parseJson', ko.utils.parseJson);\nko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\nko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\nko.exportSymbol('utils.range', ko.utils.range);\nko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\nko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\nko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\nko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\nko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\nko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\nko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\nif (!Function.prototype['bind']) {\n    // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n    // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n    Function.prototype['bind'] = function (object) {\n        var originalFunction = this;\n        if (arguments.length === 1) {\n            return function () {\n                return originalFunction.apply(object, arguments);\n            };\n        } else {\n            var partialArgs = Array.prototype.slice.call(arguments, 1);\n            return function () {\n                var args = partialArgs.slice(0);\n                args.push.apply(args, arguments);\n                return originalFunction.apply(object, args);\n            };\n        }\n    };\n}\n\nko.utils.domData = new (function () {\n    var uniqueId = 0;\n    var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n    var dataStore = {};\n\n    function getAll(node, createIfNotFound) {\n        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n        if (!hasExistingDataStore) {\n            if (!createIfNotFound)\n                return undefined;\n            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n            dataStore[dataStoreKey] = {};\n        }\n        return dataStore[dataStoreKey];\n    }\n\n    return {\n        get: function (node, key) {\n            var allDataForNode = getAll(node, false);\n            return allDataForNode === undefined ? undefined : allDataForNode[key];\n        },\n        set: function (node, key, value) {\n            if (value === undefined) {\n                // Make sure we don't actually create a new domData key if we are actually deleting a value\n                if (getAll(node, false) === undefined)\n                    return;\n            }\n            var allDataForNode = getAll(node, true);\n            allDataForNode[key] = value;\n        },\n        clear: function (node) {\n            var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n            if (dataStoreKey) {\n                delete dataStore[dataStoreKey];\n                node[dataStoreKeyExpandoPropertyName] = null;\n                return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n            }\n            return false;\n        },\n\n        nextKey: function () {\n            return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n        }\n    };\n})();\n\nko.exportSymbol('utils.domData', ko.utils.domData);\nko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\nko.utils.domNodeDisposal = new (function () {\n    var domDataKey = ko.utils.domData.nextKey();\n    var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n    var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n    function getDisposeCallbacksCollection(node, createIfNotFound) {\n        var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n        if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n            allDisposeCallbacks = [];\n            ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n        }\n        return allDisposeCallbacks;\n    }\n    function destroyCallbacksCollection(node) {\n        ko.utils.domData.set(node, domDataKey, undefined);\n    }\n\n    function cleanSingleNode(node) {\n        // Run all the dispose callbacks\n        var callbacks = getDisposeCallbacksCollection(node, false);\n        if (callbacks) {\n            callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n            for (var i = 0; i < callbacks.length; i++)\n                callbacks[i](node);\n        }\n\n        // Erase the DOM data\n        ko.utils.domData.clear(node);\n\n        // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n        ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n        // Clear any immediate-child comment nodes, as these wouldn't have been found by\n        // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n        if (cleanableNodeTypesWithDescendants[node.nodeType])\n            cleanImmediateCommentTypeChildren(node);\n    }\n\n    function cleanImmediateCommentTypeChildren(nodeWithChildren) {\n        var child, nextChild = nodeWithChildren.firstChild;\n        while (child = nextChild) {\n            nextChild = child.nextSibling;\n            if (child.nodeType === 8)\n                cleanSingleNode(child);\n        }\n    }\n\n    return {\n        addDisposeCallback : function(node, callback) {\n            if (typeof callback != \"function\")\n                throw new Error(\"Callback must be a function\");\n            getDisposeCallbacksCollection(node, true).push(callback);\n        },\n\n        removeDisposeCallback : function(node, callback) {\n            var callbacksCollection = getDisposeCallbacksCollection(node, false);\n            if (callbacksCollection) {\n                ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                if (callbacksCollection.length == 0)\n                    destroyCallbacksCollection(node);\n            }\n        },\n\n        cleanNode : function(node) {\n            // First clean this node, where applicable\n            if (cleanableNodeTypes[node.nodeType]) {\n                cleanSingleNode(node);\n\n                // ... then its descendants, where applicable\n                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                    // Clone the descendants list in case it changes during iteration\n                    var descendants = [];\n                    ko.utils.arrayPushAll(descendants, node.getElementsByTagName(\"*\"));\n                    for (var i = 0, j = descendants.length; i < j; i++)\n                        cleanSingleNode(descendants[i]);\n                }\n            }\n            return node;\n        },\n\n        removeNode : function(node) {\n            ko.cleanNode(node);\n            if (node.parentNode)\n                node.parentNode.removeChild(node);\n        },\n\n        \"cleanExternalData\" : function (node) {\n            // Special support for jQuery here because it's so commonly used.\n            // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n            // so notify it to tear down any resources associated with the node & descendants here.\n            if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                jQueryInstance['cleanData']([node]);\n        }\n    };\n})();\nko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\nko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\nko.exportSymbol('cleanNode', ko.cleanNode);\nko.exportSymbol('removeNode', ko.removeNode);\nko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\nko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\nko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n(function () {\n    var leadingCommentRegex = /^(\\s*)<!--(.*?)-->/;\n\n    function simpleHtmlParse(html, documentContext) {\n        documentContext || (documentContext = document);\n        var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n        // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n        // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n        // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n        // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n        // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n        // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n        // Trim whitespace, otherwise indexOf won't work as expected\n        var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\");\n\n        // Finds the first match from the left column, and returns the corresponding \"wrap\" data from the right column\n        var wrap = tags.match(/^<(thead|tbody|tfoot)/)              && [1, \"<table>\", \"</table>\"] ||\n                   !tags.indexOf(\"<tr\")                             && [2, \"<table><tbody>\", \"</tbody></table>\"] ||\n                   (!tags.indexOf(\"<td\") || !tags.indexOf(\"<th\"))   && [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"] ||\n                   /* anything else */                                 [0, \"\", \"\"];\n\n        // Go to html and back, then peel off extra wrappers\n        // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n        var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n        if (typeof windowContext['innerShiv'] == \"function\") {\n            div.appendChild(windowContext['innerShiv'](markup));\n        } else {\n            div.innerHTML = markup;\n        }\n\n        // Move to the right depth\n        while (wrap[0]--)\n            div = div.lastChild;\n\n        return ko.utils.makeArray(div.lastChild.childNodes);\n    }\n\n    function jQueryHtmlParse(html, documentContext) {\n        // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n        if (jQueryInstance['parseHTML']) {\n            return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n        } else {\n            // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n            var elems = jQueryInstance['clean']([html], documentContext);\n\n            // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n            // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n            // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n            if (elems && elems[0]) {\n                // Find the top-most parent element that's a direct child of a document fragment\n                var elem = elems[0];\n                while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                    elem = elem.parentNode;\n                // ... then detach it\n                if (elem.parentNode)\n                    elem.parentNode.removeChild(elem);\n            }\n\n            return elems;\n        }\n    }\n\n    ko.utils.parseHtmlFragment = function(html, documentContext) {\n        return jQueryInstance ? jQueryHtmlParse(html, documentContext)   // As below, benefit from jQuery's optimisations where possible\n                              : simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n    };\n\n    ko.utils.setHtml = function(node, html) {\n        ko.utils.emptyDomNode(node);\n\n        // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n        html = ko.utils.unwrapObservable(html);\n\n        if ((html !== null) && (html !== undefined)) {\n            if (typeof html != 'string')\n                html = html.toString();\n\n            // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n            // for example <tr> elements which are not normally allowed to exist on their own.\n            // If you've referenced jQuery we'll use that rather than duplicating its code.\n            if (jQueryInstance) {\n                jQueryInstance(node)['html'](html);\n            } else {\n                // ... otherwise, use KO's own parsing logic.\n                var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                for (var i = 0; i < parsedNodes.length; i++)\n                    node.appendChild(parsedNodes[i]);\n            }\n        }\n    };\n})();\n\nko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\nko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\nko.memoization = (function () {\n    var memos = {};\n\n    function randomMax8HexChars() {\n        return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n    }\n    function generateRandomId() {\n        return randomMax8HexChars() + randomMax8HexChars();\n    }\n    function findMemoNodes(rootNode, appendToArray) {\n        if (!rootNode)\n            return;\n        if (rootNode.nodeType == 8) {\n            var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n            if (memoId != null)\n                appendToArray.push({ domNode: rootNode, memoId: memoId });\n        } else if (rootNode.nodeType == 1) {\n            for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                findMemoNodes(childNodes[i], appendToArray);\n        }\n    }\n\n    return {\n        memoize: function (callback) {\n            if (typeof callback != \"function\")\n                throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n            var memoId = generateRandomId();\n            memos[memoId] = callback;\n            return \"<!--[ko_memo:\" + memoId + \"]-->\";\n        },\n\n        unmemoize: function (memoId, callbackParams) {\n            var callback = memos[memoId];\n            if (callback === undefined)\n                throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n            try {\n                callback.apply(null, callbackParams || []);\n                return true;\n            }\n            finally { delete memos[memoId]; }\n        },\n\n        unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n            var memos = [];\n            findMemoNodes(domNode, memos);\n            for (var i = 0, j = memos.length; i < j; i++) {\n                var node = memos[i].domNode;\n                var combinedParams = [node];\n                if (extraCallbackParamsArray)\n                    ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                if (node.parentNode)\n                    node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n            }\n        },\n\n        parseMemoText: function (memoText) {\n            var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n            return match ? match[1] : null;\n        }\n    };\n})();\n\nko.exportSymbol('memoization', ko.memoization);\nko.exportSymbol('memoization.memoize', ko.memoization.memoize);\nko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\nko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\nko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\nko.extenders = {\n    'throttle': function(target, timeout) {\n        // Throttling means two things:\n\n        // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n        //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n        target['throttleEvaluation'] = timeout;\n\n        // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n        //     so the target cannot change value synchronously or faster than a certain rate\n        var writeTimeoutInstance = null;\n        return ko.dependentObservable({\n            'read': target,\n            'write': function(value) {\n                clearTimeout(writeTimeoutInstance);\n                writeTimeoutInstance = setTimeout(function() {\n                    target(value);\n                }, timeout);\n            }\n        });\n    },\n\n    'rateLimit': function(target, options) {\n        var timeout, method, limitFunction;\n\n        if (typeof options == 'number') {\n            timeout = options;\n        } else {\n            timeout = options['timeout'];\n            method = options['method'];\n        }\n\n        limitFunction = method == 'notifyWhenChangesStop' ?  debounce : throttle;\n        target.limit(function(callback) {\n            return limitFunction(callback, timeout);\n        });\n    },\n\n    'notify': function(target, notifyWhen) {\n        target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n            null :  // null equalityComparer means to always notify\n            valuesArePrimitiveAndEqual;\n    }\n};\n\nvar primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\nfunction valuesArePrimitiveAndEqual(a, b) {\n    var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n    return oldValueIsPrimitive ? (a === b) : false;\n}\n\nfunction throttle(callback, timeout) {\n    var timeoutInstance;\n    return function () {\n        if (!timeoutInstance) {\n            timeoutInstance = setTimeout(function() {\n                timeoutInstance = undefined;\n                callback();\n            }, timeout);\n        }\n    };\n}\n\nfunction debounce(callback, timeout) {\n    var timeoutInstance;\n    return function () {\n        clearTimeout(timeoutInstance);\n        timeoutInstance = setTimeout(callback, timeout);\n    };\n}\n\nfunction applyExtenders(requestedExtenders) {\n    var target = this;\n    if (requestedExtenders) {\n        ko.utils.objectForEach(requestedExtenders, function(key, value) {\n            var extenderHandler = ko.extenders[key];\n            if (typeof extenderHandler == 'function') {\n                target = extenderHandler(target, value) || target;\n            }\n        });\n    }\n    return target;\n}\n\nko.exportSymbol('extenders', ko.extenders);\n\nko.subscription = function (target, callback, disposeCallback) {\n    this._target = target;\n    this.callback = callback;\n    this.disposeCallback = disposeCallback;\n    this.isDisposed = false;\n    ko.exportProperty(this, 'dispose', this.dispose);\n};\nko.subscription.prototype.dispose = function () {\n    this.isDisposed = true;\n    this.disposeCallback();\n};\n\nko.subscribable = function () {\n    ko.utils.setPrototypeOfOrExtend(this, ko.subscribable['fn']);\n    this._subscriptions = {};\n    this._versionNumber = 1;\n}\n\nvar defaultEvent = \"change\";\n\nvar ko_subscribable_fn = {\n    subscribe: function (callback, callbackTarget, event) {\n        var self = this;\n\n        event = event || defaultEvent;\n        var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n        var subscription = new ko.subscription(self, boundCallback, function () {\n            ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n            if (self.afterSubscriptionRemove)\n                self.afterSubscriptionRemove(event);\n        });\n\n        if (self.beforeSubscriptionAdd)\n            self.beforeSubscriptionAdd(event);\n\n        if (!self._subscriptions[event])\n            self._subscriptions[event] = [];\n        self._subscriptions[event].push(subscription);\n\n        return subscription;\n    },\n\n    \"notifySubscribers\": function (valueToNotify, event) {\n        event = event || defaultEvent;\n        if (event === defaultEvent) {\n            this.updateVersion();\n        }\n        if (this.hasSubscriptionsForEvent(event)) {\n            try {\n                ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                for (var a = this._subscriptions[event].slice(0), i = 0, subscription; subscription = a[i]; ++i) {\n                    // In case a subscription was disposed during the arrayForEach cycle, check\n                    // for isDisposed on each subscription before invoking its callback\n                    if (!subscription.isDisposed)\n                        subscription.callback(valueToNotify);\n                }\n            } finally {\n                ko.dependencyDetection.end(); // End suppressing dependency detection\n            }\n        }\n    },\n\n    getVersion: function () {\n        return this._versionNumber;\n    },\n\n    hasChanged: function (versionToCheck) {\n        return this.getVersion() !== versionToCheck;\n    },\n\n    updateVersion: function () {\n        ++this._versionNumber;\n    },\n\n    limit: function(limitFunction) {\n        var self = this, selfIsObservable = ko.isObservable(self),\n            isPending, previousValue, pendingValue, beforeChange = 'beforeChange';\n\n        if (!self._origNotifySubscribers) {\n            self._origNotifySubscribers = self[\"notifySubscribers\"];\n            self[\"notifySubscribers\"] = function(value, event) {\n                if (!event || event === defaultEvent) {\n                    self._rateLimitedChange(value);\n                } else if (event === beforeChange) {\n                    self._rateLimitedBeforeChange(value);\n                } else {\n                    self._origNotifySubscribers(value, event);\n                }\n            };\n        }\n\n        var finish = limitFunction(function() {\n            // If an observable provided a reference to itself, access it to get the latest value.\n            // This allows computed observables to delay calculating their value until needed.\n            if (selfIsObservable && pendingValue === self) {\n                pendingValue = self();\n            }\n            isPending = false;\n            if (self.isDifferent(previousValue, pendingValue)) {\n                self._origNotifySubscribers(previousValue = pendingValue);\n            }\n        });\n\n        self._rateLimitedChange = function(value) {\n            isPending = true;\n            pendingValue = value;\n            finish();\n        };\n        self._rateLimitedBeforeChange = function(value) {\n            if (!isPending) {\n                previousValue = value;\n                self._origNotifySubscribers(value, beforeChange);\n            }\n        };\n    },\n\n    hasSubscriptionsForEvent: function(event) {\n        return this._subscriptions[event] && this._subscriptions[event].length;\n    },\n\n    getSubscriptionsCount: function (event) {\n        if (event) {\n            return this._subscriptions[event] && this._subscriptions[event].length || 0;\n        } else {\n            var total = 0;\n            ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                total += subscriptions.length;\n            });\n            return total;\n        }\n    },\n\n    isDifferent: function(oldValue, newValue) {\n        return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n    },\n\n    extend: applyExtenders\n};\n\nko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\nko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\nko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n}\n\nko.subscribable['fn'] = ko_subscribable_fn;\n\n\nko.isSubscribable = function (instance) {\n    return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n};\n\nko.exportSymbol('subscribable', ko.subscribable);\nko.exportSymbol('isSubscribable', ko.isSubscribable);\n\nko.computedContext = ko.dependencyDetection = (function () {\n    var outerFrames = [],\n        currentFrame,\n        lastId = 0;\n\n    // Return a unique ID that can be assigned to an observable for dependency tracking.\n    // Theoretically, you could eventually overflow the number storage size, resulting\n    // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n    // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n    // take over 285 years to reach that number.\n    // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n    function getId() {\n        return ++lastId;\n    }\n\n    function begin(options) {\n        outerFrames.push(currentFrame);\n        currentFrame = options;\n    }\n\n    function end() {\n        currentFrame = outerFrames.pop();\n    }\n\n    return {\n        begin: begin,\n\n        end: end,\n\n        registerDependency: function (subscribable) {\n            if (currentFrame) {\n                if (!ko.isSubscribable(subscribable))\n                    throw new Error(\"Only subscribable things can act as dependencies\");\n                currentFrame.callback(subscribable, subscribable._id || (subscribable._id = getId()));\n            }\n        },\n\n        ignore: function (callback, callbackTarget, callbackArgs) {\n            try {\n                begin();\n                return callback.apply(callbackTarget, callbackArgs || []);\n            } finally {\n                end();\n            }\n        },\n\n        getDependenciesCount: function () {\n            if (currentFrame)\n                return currentFrame.computed.getDependenciesCount();\n        },\n\n        isInitial: function() {\n            if (currentFrame)\n                return currentFrame.isInitial;\n        }\n    };\n})();\n\nko.exportSymbol('computedContext', ko.computedContext);\nko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\nko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\nko.exportSymbol('computedContext.isSleeping', ko.computedContext.isSleeping);\n\nko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\nko.observable = function (initialValue) {\n    var _latestValue = initialValue;\n\n    function observable() {\n        if (arguments.length > 0) {\n            // Write\n\n            // Ignore writes if the value hasn't changed\n            if (observable.isDifferent(_latestValue, arguments[0])) {\n                observable.valueWillMutate();\n                _latestValue = arguments[0];\n                if (DEBUG) observable._latestValue = _latestValue;\n                observable.valueHasMutated();\n            }\n            return this; // Permits chained assignments\n        }\n        else {\n            // Read\n            ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n            return _latestValue;\n        }\n    }\n    ko.subscribable.call(observable);\n    ko.utils.setPrototypeOfOrExtend(observable, ko.observable['fn']);\n\n    if (DEBUG) observable._latestValue = _latestValue;\n    observable.peek = function() { return _latestValue };\n    observable.valueHasMutated = function () { observable[\"notifySubscribers\"](_latestValue); }\n    observable.valueWillMutate = function () { observable[\"notifySubscribers\"](_latestValue, \"beforeChange\"); }\n\n    ko.exportProperty(observable, 'peek', observable.peek);\n    ko.exportProperty(observable, \"valueHasMutated\", observable.valueHasMutated);\n    ko.exportProperty(observable, \"valueWillMutate\", observable.valueWillMutate);\n\n    return observable;\n}\n\nko.observable['fn'] = {\n    \"equalityComparer\": valuesArePrimitiveAndEqual\n};\n\nvar protoProperty = ko.observable.protoProperty = \"__ko_proto__\";\nko.observable['fn'][protoProperty] = ko.observable;\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.observable['fn'], ko.subscribable['fn']);\n}\n\nko.hasPrototype = function(instance, prototype) {\n    if ((instance === null) || (instance === undefined) || (instance[protoProperty] === undefined)) return false;\n    if (instance[protoProperty] === prototype) return true;\n    return ko.hasPrototype(instance[protoProperty], prototype); // Walk the prototype chain\n};\n\nko.isObservable = function (instance) {\n    return ko.hasPrototype(instance, ko.observable);\n}\nko.isWriteableObservable = function (instance) {\n    // Observable\n    if ((typeof instance == \"function\") && instance[protoProperty] === ko.observable)\n        return true;\n    // Writeable dependent observable\n    if ((typeof instance == \"function\") && (instance[protoProperty] === ko.dependentObservable) && (instance.hasWriteFunction))\n        return true;\n    // Anything else\n    return false;\n}\n\n\nko.exportSymbol('observable', ko.observable);\nko.exportSymbol('isObservable', ko.isObservable);\nko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\nko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\nko.observableArray = function (initialValues) {\n    initialValues = initialValues || [];\n\n    if (typeof initialValues != 'object' || !('length' in initialValues))\n        throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n    var result = ko.observable(initialValues);\n    ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n    return result.extend({'trackArrayChanges':true});\n};\n\nko.observableArray['fn'] = {\n    'remove': function (valueOrPredicate) {\n        var underlyingArray = this.peek();\n        var removedValues = [];\n        var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n        for (var i = 0; i < underlyingArray.length; i++) {\n            var value = underlyingArray[i];\n            if (predicate(value)) {\n                if (removedValues.length === 0) {\n                    this.valueWillMutate();\n                }\n                removedValues.push(value);\n                underlyingArray.splice(i, 1);\n                i--;\n            }\n        }\n        if (removedValues.length) {\n            this.valueHasMutated();\n        }\n        return removedValues;\n    },\n\n    'removeAll': function (arrayOfValues) {\n        // If you passed zero args, we remove everything\n        if (arrayOfValues === undefined) {\n            var underlyingArray = this.peek();\n            var allValues = underlyingArray.slice(0);\n            this.valueWillMutate();\n            underlyingArray.splice(0, underlyingArray.length);\n            this.valueHasMutated();\n            return allValues;\n        }\n        // If you passed an arg, we interpret it as an array of entries to remove\n        if (!arrayOfValues)\n            return [];\n        return this['remove'](function (value) {\n            return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n        });\n    },\n\n    'destroy': function (valueOrPredicate) {\n        var underlyingArray = this.peek();\n        var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n        this.valueWillMutate();\n        for (var i = underlyingArray.length - 1; i >= 0; i--) {\n            var value = underlyingArray[i];\n            if (predicate(value))\n                underlyingArray[i][\"_destroy\"] = true;\n        }\n        this.valueHasMutated();\n    },\n\n    'destroyAll': function (arrayOfValues) {\n        // If you passed zero args, we destroy everything\n        if (arrayOfValues === undefined)\n            return this['destroy'](function() { return true });\n\n        // If you passed an arg, we interpret it as an array of entries to destroy\n        if (!arrayOfValues)\n            return [];\n        return this['destroy'](function (value) {\n            return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n        });\n    },\n\n    'indexOf': function (item) {\n        var underlyingArray = this();\n        return ko.utils.arrayIndexOf(underlyingArray, item);\n    },\n\n    'replace': function(oldItem, newItem) {\n        var index = this['indexOf'](oldItem);\n        if (index >= 0) {\n            this.valueWillMutate();\n            this.peek()[index] = newItem;\n            this.valueHasMutated();\n        }\n    }\n};\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\nko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n    ko.observableArray['fn'][methodName] = function () {\n        // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n        // (for consistency with mutating regular observables)\n        var underlyingArray = this.peek();\n        this.valueWillMutate();\n        this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n        var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n        this.valueHasMutated();\n        return methodCallResult;\n    };\n});\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\nko.utils.arrayForEach([\"slice\"], function (methodName) {\n    ko.observableArray['fn'][methodName] = function () {\n        var underlyingArray = this();\n        return underlyingArray[methodName].apply(underlyingArray, arguments);\n    };\n});\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n}\n\nko.exportSymbol('observableArray', ko.observableArray);\nvar arrayChangeEventName = 'arrayChange';\nko.extenders['trackArrayChanges'] = function(target) {\n    // Only modify the target observable once\n    if (target.cacheDiffForKnownOperation) {\n        return;\n    }\n    var trackingChanges = false,\n        cachedDiff = null,\n        arrayChangeSubscription,\n        pendingNotifications = 0,\n        underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n        underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n    // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n    target.beforeSubscriptionAdd = function (event) {\n        if (underlyingBeforeSubscriptionAddFunction)\n            underlyingBeforeSubscriptionAddFunction.call(target, event);\n        if (event === arrayChangeEventName) {\n            trackChanges();\n        }\n    };\n    // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n    target.afterSubscriptionRemove = function (event) {\n        if (underlyingAfterSubscriptionRemoveFunction)\n            underlyingAfterSubscriptionRemoveFunction.call(target, event);\n        if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n            arrayChangeSubscription.dispose();\n            trackingChanges = false;\n        }\n    };\n\n    function trackChanges() {\n        // Calling 'trackChanges' multiple times is the same as calling it once\n        if (trackingChanges) {\n            return;\n        }\n\n        trackingChanges = true;\n\n        // Intercept \"notifySubscribers\" to track how many times it was called.\n        var underlyingNotifySubscribersFunction = target['notifySubscribers'];\n        target['notifySubscribers'] = function(valueToNotify, event) {\n            if (!event || event === defaultEvent) {\n                ++pendingNotifications;\n            }\n            return underlyingNotifySubscribersFunction.apply(this, arguments);\n        };\n\n        // Each time the array changes value, capture a clone so that on the next\n        // change it's possible to produce a diff\n        var previousContents = [].concat(target.peek() || []);\n        cachedDiff = null;\n        arrayChangeSubscription = target.subscribe(function(currentContents) {\n            // Make a copy of the current contents and ensure it's an array\n            currentContents = [].concat(currentContents || []);\n\n            // Compute the diff and issue notifications, but only if someone is listening\n            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                var changes = getChanges(previousContents, currentContents);\n            }\n\n            // Eliminate references to the old, removed items, so they can be GCed\n            previousContents = currentContents;\n            cachedDiff = null;\n            pendingNotifications = 0;\n\n            if (changes && changes.length) {\n                target['notifySubscribers'](changes, arrayChangeEventName);\n            }\n        });\n    }\n\n    function getChanges(previousContents, currentContents) {\n        // We try to re-use cached diffs.\n        // The scenarios where pendingNotifications > 1 are when using rate-limiting or the Deferred Updates\n        // plugin, which without this check would not be compatible with arrayChange notifications. Normally,\n        // notifications are issued immediately so we wouldn't be queueing up more than one.\n        if (!cachedDiff || pendingNotifications > 1) {\n            cachedDiff = ko.utils.compareArrays(previousContents, currentContents, { 'sparse': true });\n        }\n\n        return cachedDiff;\n    }\n\n    target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n        // Only run if we're currently tracking changes for this observable array\n        // and there aren't any pending deferred notifications.\n        if (!trackingChanges || pendingNotifications) {\n            return;\n        }\n        var diff = [],\n            arrayLength = rawArray.length,\n            argsLength = args.length,\n            offset = 0;\n\n        function pushDiff(status, value, index) {\n            return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n        }\n        switch (operationName) {\n            case 'push':\n                offset = arrayLength;\n            case 'unshift':\n                for (var index = 0; index < argsLength; index++) {\n                    pushDiff('added', args[index], offset + index);\n                }\n                break;\n\n            case 'pop':\n                offset = arrayLength - 1;\n            case 'shift':\n                if (arrayLength) {\n                    pushDiff('deleted', rawArray[offset], offset);\n                }\n                break;\n\n            case 'splice':\n                // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                    endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                    endAddIndex = startIndex + argsLength - 2,\n                    endIndex = Math.max(endDeleteIndex, endAddIndex),\n                    additions = [], deletions = [];\n                for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                    if (index < endDeleteIndex)\n                        deletions.push(pushDiff('deleted', rawArray[index], index));\n                    if (index < endAddIndex)\n                        additions.push(pushDiff('added', args[argsIndex], index));\n                }\n                ko.utils.findMovesInArrayComparison(deletions, additions);\n                break;\n\n            default:\n                return;\n        }\n        cachedDiff = diff;\n    };\n};\nko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n    var _latestValue,\n        _needsEvaluation = true,\n        _isBeingEvaluated = false,\n        _suppressDisposalUntilDisposeWhenReturnsFalse = false,\n        _isDisposed = false,\n        readFunction = evaluatorFunctionOrOptions,\n        pure = false,\n        isSleeping = false;\n\n    if (readFunction && typeof readFunction == \"object\") {\n        // Single-parameter syntax - everything is on this \"options\" param\n        options = readFunction;\n        readFunction = options[\"read\"];\n    } else {\n        // Multi-parameter syntax - construct the options according to the params passed\n        options = options || {};\n        if (!readFunction)\n            readFunction = options[\"read\"];\n    }\n    if (typeof readFunction != \"function\")\n        throw new Error(\"Pass a function that returns the value of the ko.computed\");\n\n    function addDependencyTracking(id, target, trackingObj) {\n        if (pure && target === dependentObservable) {\n            throw Error(\"A 'pure' computed must not be called recursively\");\n        }\n\n        dependencyTracking[id] = trackingObj;\n        trackingObj._order = _dependenciesCount++;\n        trackingObj._version = target.getVersion();\n    }\n\n    function haveDependenciesChanged() {\n        var id, dependency;\n        for (id in dependencyTracking) {\n            if (dependencyTracking.hasOwnProperty(id)) {\n                dependency = dependencyTracking[id];\n                if (dependency._target.hasChanged(dependency._version)) {\n                    return true;\n                }\n            }\n        }\n    }\n\n    function disposeComputed() {\n        if (!isSleeping && dependencyTracking) {\n            ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                if (dependency.dispose)\n                    dependency.dispose();\n            });\n        }\n        dependencyTracking = null;\n        _dependenciesCount = 0;\n        _isDisposed = true;\n        _needsEvaluation = false;\n        isSleeping = false;\n    }\n\n    function evaluatePossiblyAsync() {\n        var throttleEvaluationTimeout = dependentObservable['throttleEvaluation'];\n        if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n            clearTimeout(evaluationTimeoutInstance);\n            evaluationTimeoutInstance = setTimeout(function () {\n                evaluateImmediate(true /*notifyChange*/);\n            }, throttleEvaluationTimeout);\n        } else if (dependentObservable._evalRateLimited) {\n            dependentObservable._evalRateLimited();\n        } else {\n            evaluateImmediate(true /*notifyChange*/);\n        }\n    }\n\n    function evaluateImmediate(notifyChange) {\n        if (_isBeingEvaluated) {\n            // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n            // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n            // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n            // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n            return;\n        }\n\n        // Do not evaluate (and possibly capture new dependencies) if disposed\n        if (_isDisposed) {\n            return;\n        }\n\n        if (disposeWhen && disposeWhen()) {\n            // See comment below about _suppressDisposalUntilDisposeWhenReturnsFalse\n            if (!_suppressDisposalUntilDisposeWhenReturnsFalse) {\n                dispose();\n                return;\n            }\n        } else {\n            // It just did return false, so we can stop suppressing now\n            _suppressDisposalUntilDisposeWhenReturnsFalse = false;\n        }\n\n        _isBeingEvaluated = true;\n\n        try {\n            // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n            // Then, during evaluation, we cross off any that are in fact still being used.\n            var disposalCandidates = dependencyTracking,\n                disposalCount = _dependenciesCount,\n                isInitial = pure ? undefined : !_dependenciesCount;   // If we're evaluating when there are no previous dependencies, it must be the first time\n\n            ko.dependencyDetection.begin({\n                callback: function(subscribable, id) {\n                    if (!_isDisposed) {\n                        if (disposalCount && disposalCandidates[id]) {\n                            // Don't want to dispose this subscription, as it's still being used\n                            addDependencyTracking(id, subscribable, disposalCandidates[id]);\n                            delete disposalCandidates[id];\n                            --disposalCount;\n                        } else if (!dependencyTracking[id]) {\n                            // Brand new subscription - add it\n                            addDependencyTracking(id, subscribable, isSleeping ? { _target: subscribable } : subscribable.subscribe(evaluatePossiblyAsync));\n                        }\n                    }\n                },\n                computed: dependentObservable,\n                isInitial: isInitial\n            });\n\n            dependencyTracking = {};\n            _dependenciesCount = 0;\n\n            try {\n                var newValue = evaluatorFunctionTarget ? readFunction.call(evaluatorFunctionTarget) : readFunction();\n\n            } finally {\n                ko.dependencyDetection.end();\n\n                // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                if (disposalCount && !isSleeping) {\n                    ko.utils.objectForEach(disposalCandidates, function(id, toDispose) {\n                        if (toDispose.dispose)\n                            toDispose.dispose();\n                    });\n                }\n\n                _needsEvaluation = false;\n            }\n\n            if (dependentObservable.isDifferent(_latestValue, newValue)) {\n                if (!isSleeping) {\n                    notify(_latestValue, \"beforeChange\");\n                }\n\n                _latestValue = newValue;\n                if (DEBUG) dependentObservable._latestValue = _latestValue;\n\n                if (isSleeping) {\n                    dependentObservable.updateVersion();\n                } else if (notifyChange) {\n                    notify(_latestValue);\n                }\n            }\n\n            if (isInitial) {\n                notify(_latestValue, \"awake\");\n            }\n        } finally {\n            _isBeingEvaluated = false;\n        }\n\n        if (!_dependenciesCount)\n            dispose();\n    }\n\n    function dependentObservable() {\n        if (arguments.length > 0) {\n            if (typeof writeFunction === \"function\") {\n                // Writing a value\n                writeFunction.apply(evaluatorFunctionTarget, arguments);\n            } else {\n                throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n            }\n            return this; // Permits chained assignments\n        } else {\n            // Reading the value\n            ko.dependencyDetection.registerDependency(dependentObservable);\n            if (_needsEvaluation || (isSleeping && haveDependenciesChanged())) {\n                evaluateImmediate();\n            }\n            return _latestValue;\n        }\n    }\n\n    function peek() {\n        // Peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n        if ((_needsEvaluation && !_dependenciesCount) || (isSleeping && haveDependenciesChanged())) {\n            evaluateImmediate();\n        }\n        return _latestValue;\n    }\n\n    function isActive() {\n        return _needsEvaluation || _dependenciesCount > 0;\n    }\n\n    function notify(value, event) {\n        dependentObservable[\"notifySubscribers\"](value, event);\n    }\n\n    // By here, \"options\" is always non-null\n    var writeFunction = options[\"write\"],\n        disposeWhenNodeIsRemoved = options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n        disposeWhenOption = options[\"disposeWhen\"] || options.disposeWhen,\n        disposeWhen = disposeWhenOption,\n        dispose = disposeComputed,\n        dependencyTracking = {},\n        _dependenciesCount = 0,\n        evaluationTimeoutInstance = null;\n\n    if (!evaluatorFunctionTarget)\n        evaluatorFunctionTarget = options[\"owner\"];\n\n    ko.subscribable.call(dependentObservable);\n    ko.utils.setPrototypeOfOrExtend(dependentObservable, ko.dependentObservable['fn']);\n\n    dependentObservable.peek = peek;\n    dependentObservable.getDependenciesCount = function () { return _dependenciesCount; };\n    dependentObservable.hasWriteFunction = typeof writeFunction === \"function\";\n    dependentObservable.dispose = function () { dispose(); };\n    dependentObservable.isActive = isActive;\n\n    // Replace the limit function with one that delays evaluation as well.\n    var originalLimit = dependentObservable.limit;\n    dependentObservable.limit = function(limitFunction) {\n        originalLimit.call(dependentObservable, limitFunction);\n        dependentObservable._evalRateLimited = function() {\n            dependentObservable._rateLimitedBeforeChange(_latestValue);\n\n            _needsEvaluation = true;    // Mark as dirty\n\n            // Pass the observable to the rate-limit code, which will access it when\n            // it's time to do the notification.\n            dependentObservable._rateLimitedChange(dependentObservable);\n        }\n    };\n\n    if (options['pure']) {\n        pure = true;\n        isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n        dependentObservable.beforeSubscriptionAdd = function (event) {\n            // If asleep, wake up the computed by subscribing to any dependencies.\n            if (!_isDisposed && isSleeping && event == 'change') {\n                isSleeping = false;\n                if (_needsEvaluation || haveDependenciesChanged()) {\n                    dependencyTracking = null;\n                    _dependenciesCount = 0;\n                    _needsEvaluation = true;\n                    evaluateImmediate();\n                } else {\n                    // First put the dependencies in order\n                    var dependeciesOrder = [];\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependeciesOrder[dependency._order] = id;\n                    });\n                    // Next, subscribe to each one\n                    ko.utils.arrayForEach(dependeciesOrder, function(id, order) {\n                        var dependency = dependencyTracking[id],\n                            subscription = dependency._target.subscribe(evaluatePossiblyAsync);\n                        subscription._order = order;\n                        subscription._version = dependency._version;\n                        dependencyTracking[id] = subscription;\n                    });\n                }\n                if (!_isDisposed) {     // test since evaluating could trigger disposal\n                    notify(_latestValue, \"awake\");\n                }\n            }\n        };\n\n        dependentObservable.afterSubscriptionRemove = function (event) {\n            if (!_isDisposed && event == 'change' && !dependentObservable.hasSubscriptionsForEvent('change')) {\n                ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                    if (dependency.dispose) {\n                        dependencyTracking[id] = {\n                            _target: dependency._target,\n                            _order: dependency._order,\n                            _version: dependency._version\n                        };\n                        dependency.dispose();\n                    }\n                });\n                isSleeping = true;\n                notify(undefined, \"asleep\");\n            }\n        };\n\n        // Because a pure computed is not automatically updated while it is sleeping, we can't\n        // simply return the version number. Instead, we check if any of the dependencies have\n        // changed and conditionally re-evaluate the computed observable.\n        dependentObservable._originalGetVersion = dependentObservable.getVersion;\n        dependentObservable.getVersion = function () {\n            if (isSleeping && (_needsEvaluation || haveDependenciesChanged())) {\n                evaluateImmediate();\n            }\n            return dependentObservable._originalGetVersion();\n        };\n    } else if (options['deferEvaluation']) {\n        // This will force a computed with deferEvaluation to evaluate when the first subscriptions is registered.\n        dependentObservable.beforeSubscriptionAdd = function (event) {\n            if (event == 'change' || event == 'beforeChange') {\n                peek();\n            }\n        }\n    }\n\n    ko.exportProperty(dependentObservable, 'peek', dependentObservable.peek);\n    ko.exportProperty(dependentObservable, 'dispose', dependentObservable.dispose);\n    ko.exportProperty(dependentObservable, 'isActive', dependentObservable.isActive);\n    ko.exportProperty(dependentObservable, 'getDependenciesCount', dependentObservable.getDependenciesCount);\n\n    // Add a \"disposeWhen\" callback that, on each evaluation, disposes if the node was removed without using ko.removeNode.\n    if (disposeWhenNodeIsRemoved) {\n        // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n        // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n        // we'll prevent disposal until \"disposeWhen\" first returns false.\n        _suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n        // Only watch for the node's disposal if the value really is a node. It might not be,\n        // e.g., { disposeWhenNodeIsRemoved: true } can be used to opt into the \"only dispose\n        // after first false result\" behaviour even if there's no specific node to watch. This\n        // technique is intended for KO's internal use only and shouldn't be documented or used\n        // by application code, as it's likely to change in a future version of KO.\n        if (disposeWhenNodeIsRemoved.nodeType) {\n            disposeWhen = function () {\n                return !ko.utils.domNodeIsAttachedToDocument(disposeWhenNodeIsRemoved) || (disposeWhenOption && disposeWhenOption());\n            };\n        }\n    }\n\n    // Evaluate, unless sleeping or deferEvaluation is true\n    if (!isSleeping && !options['deferEvaluation'])\n        evaluateImmediate();\n\n    // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n    // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n    if (disposeWhenNodeIsRemoved && isActive() && disposeWhenNodeIsRemoved.nodeType) {\n        dispose = function() {\n            ko.utils.domNodeDisposal.removeDisposeCallback(disposeWhenNodeIsRemoved, dispose);\n            disposeComputed();\n        };\n        ko.utils.domNodeDisposal.addDisposeCallback(disposeWhenNodeIsRemoved, dispose);\n    }\n\n    return dependentObservable;\n};\n\nko.isComputed = function(instance) {\n    return ko.hasPrototype(instance, ko.dependentObservable);\n};\n\nvar protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\nko.dependentObservable[protoProp] = ko.observable;\n\nko.dependentObservable['fn'] = {\n    \"equalityComparer\": valuesArePrimitiveAndEqual\n};\nko.dependentObservable['fn'][protoProp] = ko.dependentObservable;\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.dependentObservable constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.dependentObservable['fn'], ko.subscribable['fn']);\n}\n\nko.exportSymbol('dependentObservable', ko.dependentObservable);\nko.exportSymbol('computed', ko.dependentObservable); // Make \"ko.computed\" an alias for \"ko.dependentObservable\"\nko.exportSymbol('isComputed', ko.isComputed);\n\nko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n    if (typeof evaluatorFunctionOrOptions === 'function') {\n        return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n    } else {\n        evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n        evaluatorFunctionOrOptions['pure'] = true;\n        return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n    }\n}\nko.exportSymbol('pureComputed', ko.pureComputed);\n\n(function() {\n    var maxNestedObservableDepth = 10; // Escape the (unlikely) pathalogical case where an observable's current value is itself (or similar reference cycle)\n\n    ko.toJS = function(rootObject) {\n        if (arguments.length == 0)\n            throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n        // We just unwrap everything at every level in the object graph\n        return mapJsObjectGraph(rootObject, function(valueToMap) {\n            // Loop because an observable's value might in turn be another observable wrapper\n            for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                valueToMap = valueToMap();\n            return valueToMap;\n        });\n    };\n\n    ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n        var plainJavaScriptObject = ko.toJS(rootObject);\n        return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n    };\n\n    function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n        visitedObjects = visitedObjects || new objectLookup();\n\n        rootObject = mapInputCallback(rootObject);\n        var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n        if (!canHaveProperties)\n            return rootObject;\n\n        var outputProperties = rootObject instanceof Array ? [] : {};\n        visitedObjects.save(rootObject, outputProperties);\n\n        visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n            var propertyValue = mapInputCallback(rootObject[indexer]);\n\n            switch (typeof propertyValue) {\n                case \"boolean\":\n                case \"number\":\n                case \"string\":\n                case \"function\":\n                    outputProperties[indexer] = propertyValue;\n                    break;\n                case \"object\":\n                case \"undefined\":\n                    var previouslyMappedValue = visitedObjects.get(propertyValue);\n                    outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                        ? previouslyMappedValue\n                        : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                    break;\n            }\n        });\n\n        return outputProperties;\n    }\n\n    function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n        if (rootObject instanceof Array) {\n            for (var i = 0; i < rootObject.length; i++)\n                visitorCallback(i);\n\n            // For arrays, also respect toJSON property for custom mappings (fixes #278)\n            if (typeof rootObject['toJSON'] == 'function')\n                visitorCallback('toJSON');\n        } else {\n            for (var propertyName in rootObject) {\n                visitorCallback(propertyName);\n            }\n        }\n    };\n\n    function objectLookup() {\n        this.keys = [];\n        this.values = [];\n    };\n\n    objectLookup.prototype = {\n        constructor: objectLookup,\n        save: function(key, value) {\n            var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n            if (existingIndex >= 0)\n                this.values[existingIndex] = value;\n            else {\n                this.keys.push(key);\n                this.values.push(value);\n            }\n        },\n        get: function(key) {\n            var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n            return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n        }\n    };\n})();\n\nko.exportSymbol('toJS', ko.toJS);\nko.exportSymbol('toJSON', ko.toJSON);\n(function () {\n    var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n    // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n    // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n    // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n    ko.selectExtensions = {\n        readValue : function(element) {\n            switch (ko.utils.tagNameLower(element)) {\n                case 'option':\n                    if (element[hasDomDataExpandoProperty] === true)\n                        return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                    return ko.utils.ieVersion <= 7\n                        ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                        : element.value;\n                case 'select':\n                    return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                default:\n                    return element.value;\n            }\n        },\n\n        writeValue: function(element, value, allowUnset) {\n            switch (ko.utils.tagNameLower(element)) {\n                case 'option':\n                    switch(typeof value) {\n                        case \"string\":\n                            ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                            if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                delete element[hasDomDataExpandoProperty];\n                            }\n                            element.value = value;\n                            break;\n                        default:\n                            // Store arbitrary object using DomData\n                            ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                            element[hasDomDataExpandoProperty] = true;\n\n                            // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                            element.value = typeof value === \"number\" ? value : \"\";\n                            break;\n                    }\n                    break;\n                case 'select':\n                    if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                        value = undefined;\n                    var selection = -1;\n                    for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                        optionValue = ko.selectExtensions.readValue(element.options[i]);\n                        // Include special check to handle selecting a caption with a blank string value\n                        if (optionValue == value || (optionValue == \"\" && value === undefined)) {\n                            selection = i;\n                            break;\n                        }\n                    }\n                    if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                        element.selectedIndex = selection;\n                    }\n                    break;\n                default:\n                    if ((value === null) || (value === undefined))\n                        value = \"\";\n                    element.value = value;\n                    break;\n            }\n        }\n    };\n})();\n\nko.exportSymbol('selectExtensions', ko.selectExtensions);\nko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\nko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\nko.expressionRewriting = (function () {\n    var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n    // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n    // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n    // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n    var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n    function getWriteableValue(expression) {\n        if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n            return false;\n        var match = expression.match(javaScriptAssignmentTarget);\n        return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n    }\n\n    // The following regular expressions will be used to split an object-literal string into tokens\n\n        // These two match strings, either with double quotes or single quotes\n    var stringDouble = '\"(?:[^\"\\\\\\\\]|\\\\\\\\.)*\"',\n        stringSingle = \"'(?:[^'\\\\\\\\]|\\\\\\\\.)*'\",\n        // Matches a regular expression (text enclosed by slashes), but will also match sets of divisions\n        // as a regular expression (this is handled by the parsing loop below).\n        stringRegexp = '/(?:[^/\\\\\\\\]|\\\\\\\\.)*/\\w*',\n        // These characters have special meaning to the parser and must not appear in the middle of a\n        // token, except as part of a string.\n        specials = ',\"\\'{}()/:[\\\\]',\n        // Match text (at least two characters) that does not contain any of the above special characters,\n        // although some of the special characters are allowed to start it (all but the colon and comma).\n        // The text can contain spaces, but leading or trailing spaces are skipped.\n        everyThingElse = '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n        // Match any non-space character not matched already. This will match colons and commas, since they're\n        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n        oneNotSpace = '[^\\\\s]',\n\n        // Create the actual regular expression by or-ing the above strings. The order is important.\n        bindingToken = RegExp(stringDouble + '|' + stringSingle + '|' + stringRegexp + '|' + everyThingElse + '|' + oneNotSpace, 'g'),\n\n        // Match end of previous token to determine whether a slash is a division or regex.\n        divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n        keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n    function parseObjectLiteral(objectLiteralString) {\n        // Trim leading and trailing spaces from the string\n        var str = ko.utils.stringTrim(objectLiteralString);\n\n        // Trim braces '{' surrounding the whole object literal\n        if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n        // Split into tokens\n        var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n        if (toks) {\n            // Append a comma so that we don't need a separate code block to deal with the last item\n            toks.push(',');\n\n            for (var i = 0, tok; tok = toks[i]; ++i) {\n                var c = tok.charCodeAt(0);\n                // A comma signals the end of a key/value pair if depth is zero\n                if (c === 44) { // \",\"\n                    if (depth <= 0) {\n                        result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                        key = depth = 0;\n                        values = [];\n                        continue;\n                    }\n                // Simply skip the colon that separates the name and value\n                } else if (c === 58) { // \":\"\n                    if (!depth && !key && values.length === 1) {\n                        key = values.pop();\n                        continue;\n                    }\n                // A set of slashes is initially matched as a regular expression, but could be division\n                } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                    // Look at the end of the previous token to determine if the slash is actually division\n                    var match = toks[i-1].match(divisionLookBehind);\n                    if (match && !keywordRegexLookBehind[match[0]]) {\n                        // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                        str = str.substr(str.indexOf(tok) + 1);\n                        toks = str.match(bindingToken);\n                        toks.push(',');\n                        i = -1;\n                        // Continue with just the slash\n                        tok = '/';\n                    }\n                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                    ++depth;\n                } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                    --depth;\n                // The key will be the first token; if it's a string, trim the quotes\n                } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                    tok = tok.slice(1, -1);\n                }\n                values.push(tok);\n            }\n        }\n        return result;\n    }\n\n    // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n    var twoWayBindings = {};\n\n    function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n        bindingOptions = bindingOptions || {};\n\n        function processKeyValue(key, val) {\n            var writableVal;\n            function callPreprocessHook(obj) {\n                return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n            }\n            if (!bindingParams) {\n                if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                    return;\n\n                if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                    // For two-way bindings, provide a write method in case the value\n                    // isn't a writable observable.\n                    propertyAccessorResultStrings.push(\"'\" + key + \"':function(_z){\" + writableVal + \"=_z}\");\n                }\n            }\n            // Values are wrapped in a function so that each value can be accessed independently\n            if (makeValueAccessors) {\n                val = 'function(){return ' + val + ' }';\n            }\n            resultStrings.push(\"'\" + key + \"':\" + val);\n        }\n\n        var resultStrings = [],\n            propertyAccessorResultStrings = [],\n            makeValueAccessors = bindingOptions['valueAccessors'],\n            bindingParams = bindingOptions['bindingParams'],\n            keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n        ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n            processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n        });\n\n        if (propertyAccessorResultStrings.length)\n            processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n        return resultStrings.join(\",\");\n    }\n\n    return {\n        bindingRewriteValidators: [],\n\n        twoWayBindings: twoWayBindings,\n\n        parseObjectLiteral: parseObjectLiteral,\n\n        preProcessBindings: preProcessBindings,\n\n        keyValueArrayContainsKey: function(keyValueArray, key) {\n            for (var i = 0; i < keyValueArray.length; i++)\n                if (keyValueArray[i]['key'] == key)\n                    return true;\n            return false;\n        },\n\n        // Internal, private KO utility for updating model properties from within bindings\n        // property:            If the property being updated is (or might be) an observable, pass it here\n        //                      If it turns out to be a writable observable, it will be written to directly\n        // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n        //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n        // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n        // value:               The value to be written\n        // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n        //                      it is !== existing value on that writable observable\n        writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n            if (!property || !ko.isObservable(property)) {\n                var propWriters = allBindings.get('_ko_property_writers');\n                if (propWriters && propWriters[key])\n                    propWriters[key](value);\n            } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                property(value);\n            }\n        }\n    };\n})();\n\nko.exportSymbol('expressionRewriting', ko.expressionRewriting);\nko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\nko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\nko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\nko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\nko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\nko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n(function() {\n    // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n    // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n    // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n    // of that virtual hierarchy\n    //\n    // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n    // without having to scatter special cases all over the binding and templating code.\n\n    // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n    // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n    // So, use node.text where available, and node.nodeValue elsewhere\n    var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n    var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n    var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n    var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n    function isStartComment(node) {\n        return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n    }\n\n    function isEndComment(node) {\n        return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n    }\n\n    function getVirtualChildren(startComment, allowUnbalanced) {\n        var currentNode = startComment;\n        var depth = 1;\n        var children = [];\n        while (currentNode = currentNode.nextSibling) {\n            if (isEndComment(currentNode)) {\n                depth--;\n                if (depth === 0)\n                    return children;\n            }\n\n            children.push(currentNode);\n\n            if (isStartComment(currentNode))\n                depth++;\n        }\n        if (!allowUnbalanced)\n            throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n        return null;\n    }\n\n    function getMatchingEndComment(startComment, allowUnbalanced) {\n        var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n        if (allVirtualChildren) {\n            if (allVirtualChildren.length > 0)\n                return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n            return startComment.nextSibling;\n        } else\n            return null; // Must have no matching end comment, and allowUnbalanced is true\n    }\n\n    function getUnbalancedChildTags(node) {\n        // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n        //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n        var childNode = node.firstChild, captureRemaining = null;\n        if (childNode) {\n            do {\n                if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                    captureRemaining.push(childNode);\n                else if (isStartComment(childNode)) {\n                    var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                    if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                        childNode = matchingEndComment;\n                    else\n                        captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                } else if (isEndComment(childNode)) {\n                    captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                }\n            } while (childNode = childNode.nextSibling);\n        }\n        return captureRemaining;\n    }\n\n    ko.virtualElements = {\n        allowedBindings: {},\n\n        childNodes: function(node) {\n            return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n        },\n\n        emptyNode: function(node) {\n            if (!isStartComment(node))\n                ko.utils.emptyDomNode(node);\n            else {\n                var virtualChildren = ko.virtualElements.childNodes(node);\n                for (var i = 0, j = virtualChildren.length; i < j; i++)\n                    ko.removeNode(virtualChildren[i]);\n            }\n        },\n\n        setDomNodeChildren: function(node, childNodes) {\n            if (!isStartComment(node))\n                ko.utils.setDomNodeChildren(node, childNodes);\n            else {\n                ko.virtualElements.emptyNode(node);\n                var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                for (var i = 0, j = childNodes.length; i < j; i++)\n                    endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n            }\n        },\n\n        prepend: function(containerNode, nodeToPrepend) {\n            if (!isStartComment(containerNode)) {\n                if (containerNode.firstChild)\n                    containerNode.insertBefore(nodeToPrepend, containerNode.firstChild);\n                else\n                    containerNode.appendChild(nodeToPrepend);\n            } else {\n                // Start comments must always have a parent and at least one following sibling (the end comment)\n                containerNode.parentNode.insertBefore(nodeToPrepend, containerNode.nextSibling);\n            }\n        },\n\n        insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n            if (!insertAfterNode) {\n                ko.virtualElements.prepend(containerNode, nodeToInsert);\n            } else if (!isStartComment(containerNode)) {\n                // Insert after insertion point\n                if (insertAfterNode.nextSibling)\n                    containerNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);\n                else\n                    containerNode.appendChild(nodeToInsert);\n            } else {\n                // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                containerNode.parentNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);\n            }\n        },\n\n        firstChild: function(node) {\n            if (!isStartComment(node))\n                return node.firstChild;\n            if (!node.nextSibling || isEndComment(node.nextSibling))\n                return null;\n            return node.nextSibling;\n        },\n\n        nextSibling: function(node) {\n            if (isStartComment(node))\n                node = getMatchingEndComment(node);\n            if (node.nextSibling && isEndComment(node.nextSibling))\n                return null;\n            return node.nextSibling;\n        },\n\n        hasBindingValue: isStartComment,\n\n        virtualNodeBindingValue: function(node) {\n            var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n            return regexMatch ? regexMatch[1] : null;\n        },\n\n        normaliseVirtualElementDomStructure: function(elementVerified) {\n            // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n            // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n            // that are direct descendants of <ul> into the preceding <li>)\n            if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                return;\n\n            // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n            // must be intended to appear *after* that child, so move them there.\n            var childNode = elementVerified.firstChild;\n            if (childNode) {\n                do {\n                    if (childNode.nodeType === 1) {\n                        var unbalancedTags = getUnbalancedChildTags(childNode);\n                        if (unbalancedTags) {\n                            // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                            var nodeToInsertBefore = childNode.nextSibling;\n                            for (var i = 0; i < unbalancedTags.length; i++) {\n                                if (nodeToInsertBefore)\n                                    elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                else\n                                    elementVerified.appendChild(unbalancedTags[i]);\n                            }\n                        }\n                    }\n                } while (childNode = childNode.nextSibling);\n            }\n        }\n    };\n})();\nko.exportSymbol('virtualElements', ko.virtualElements);\nko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\nko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\nko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\nko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\nko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n(function() {\n    var defaultBindingAttributeName = \"data-bind\";\n\n    ko.bindingProvider = function() {\n        this.bindingCache = {};\n    };\n\n    ko.utils.extend(ko.bindingProvider.prototype, {\n        'nodeHasBindings': function(node) {\n            switch (node.nodeType) {\n                case 1: // Element\n                    return node.getAttribute(defaultBindingAttributeName) != null\n                        || ko.components['getComponentNameForNode'](node);\n                case 8: // Comment node\n                    return ko.virtualElements.hasBindingValue(node);\n                default: return false;\n            }\n        },\n\n        'getBindings': function(node, bindingContext) {\n            var bindingsString = this['getBindingsString'](node, bindingContext),\n                parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n            return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n        },\n\n        'getBindingAccessors': function(node, bindingContext) {\n            var bindingsString = this['getBindingsString'](node, bindingContext),\n                parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n            return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n        },\n\n        // The following function is only used internally by this default provider.\n        // It's not part of the interface definition for a general binding provider.\n        'getBindingsString': function(node, bindingContext) {\n            switch (node.nodeType) {\n                case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                default: return null;\n            }\n        },\n\n        // The following function is only used internally by this default provider.\n        // It's not part of the interface definition for a general binding provider.\n        'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n            try {\n                var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                return bindingFunction(bindingContext, node);\n            } catch (ex) {\n                ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                throw ex;\n            }\n        }\n    });\n\n    ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n    function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n        var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n        return cache[cacheKey]\n            || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n    }\n\n    function createBindingsStringEvaluator(bindingsString, options) {\n        // Build the source for a function that evaluates \"expression\"\n        // For each scope variable, add an extra level of \"with\" nesting\n        // Example result: with(sc1) { with(sc0) { return (expression) } }\n        var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n            functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n        return new Function(\"$context\", \"$element\", functionBody);\n    }\n})();\n\nko.exportSymbol('bindingProvider', ko.bindingProvider);\n(function () {\n    ko.bindingHandlers = {};\n\n    // The following element types will not be recursed into during binding. In the future, we\n    // may consider adding <template> to this list, because such elements' contents are always\n    // intended to be bound in a different context from where they appear in the document.\n    var bindingDoesNotRecurseIntoElementTypes = {\n        // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n        // because it's unexpected and a potential XSS issue\n        'script': true,\n        'textarea': true\n    };\n\n    // Use an overridable method for retrieving binding handlers so that a plugins may support dynamically created handlers\n    ko['getBindingHandler'] = function(bindingKey) {\n        return ko.bindingHandlers[bindingKey];\n    };\n\n    // The ko.bindingContext constructor is only called directly to create the root context. For child\n    // contexts, use bindingContext.createChildContext or bindingContext.extend.\n    ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback) {\n\n        // The binding context object includes static properties for the current, parent, and root view models.\n        // If a view model is actually stored in an observable, the corresponding binding context object, and\n        // any child contexts, must be updated when the view model is changed.\n        function updateContext() {\n            // Most of the time, the context will directly get a view model object, but if a function is given,\n            // we call the function to retrieve the view model. If the function accesses any obsevables or returns\n            // an observable, the dependency is tracked, and those observables can later cause the binding\n            // context to be updated.\n            var dataItemOrObservable = isFunc ? dataItemOrAccessor() : dataItemOrAccessor,\n                dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n            if (parentContext) {\n                // When a \"parent\" context is given, register a dependency on the parent context. Thus whenever the\n                // parent context is updated, this context will also be updated.\n                if (parentContext._subscribable)\n                    parentContext._subscribable();\n\n                // Copy $root and any custom properties from the parent context\n                ko.utils.extend(self, parentContext);\n\n                // Because the above copy overwrites our own properties, we need to reset them.\n                // During the first execution, \"subscribable\" isn't set, so don't bother doing the update then.\n                if (subscribable) {\n                    self._subscribable = subscribable;\n                }\n            } else {\n                self['$parents'] = [];\n                self['$root'] = dataItem;\n\n                // Export 'ko' in the binding context so it will be available in bindings and templates\n                // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                // See https://github.com/SteveSanderson/knockout/issues/490\n                self['ko'] = ko;\n            }\n            self['$rawData'] = dataItemOrObservable;\n            self['$data'] = dataItem;\n            if (dataItemAlias)\n                self[dataItemAlias] = dataItem;\n\n            // The extendCallback function is provided when creating a child context or extending a context.\n            // It handles the specific actions needed to finish setting up the binding context. Actions in this\n            // function could also add dependencies to this binding context.\n            if (extendCallback)\n                extendCallback(self, parentContext, dataItem);\n\n            return self['$data'];\n        }\n        function disposeWhen() {\n            return nodes && !ko.utils.anyDomNodeIsAttachedToDocument(nodes);\n        }\n\n        var self = this,\n            isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor),\n            nodes,\n            subscribable = ko.dependentObservable(updateContext, null, { disposeWhen: disposeWhen, disposeWhenNodeIsRemoved: true });\n\n        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n        // the context object.\n        if (subscribable.isActive()) {\n            self._subscribable = subscribable;\n\n            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n            subscribable['equalityComparer'] = null;\n\n            // We need to be able to dispose of this computed observable when it's no longer needed. This would be\n            // easy if we had a single node to watch, but binding contexts can be used by many different nodes, and\n            // we cannot assume that those nodes have any relation to each other. So instead we track any node that\n            // the context is attached to, and dispose the computed when all of those nodes have been cleaned.\n\n            // Add properties to *subscribable* instead of *self* because any properties added to *self* may be overwritten on updates\n            nodes = [];\n            subscribable._addNode = function(node) {\n                nodes.push(node);\n                ko.utils.domNodeDisposal.addDisposeCallback(node, function(node) {\n                    ko.utils.arrayRemoveItem(nodes, node);\n                    if (!nodes.length) {\n                        subscribable.dispose();\n                        self._subscribable = subscribable = undefined;\n                    }\n                });\n            };\n        }\n    }\n\n    // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n    // any obsevables, the new child context will automatically get a dependency on the parent context.\n    // But this does not mean that the $data value of the child context will also get updated. If the child\n    // view model also depends on the parent view model, you must provide a function that returns the correct\n    // view model on each update.\n    ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback) {\n        return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function(self, parentContext) {\n            // Extend the context hierarchy by setting the appropriate pointers\n            self['$parentContext'] = parentContext;\n            self['$parent'] = parentContext['$data'];\n            self['$parents'] = (parentContext['$parents'] || []).slice(0);\n            self['$parents'].unshift(self['$parent']);\n            if (extendCallback)\n                extendCallback(self);\n        });\n    };\n\n    // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n    // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n    // when an observable view model is updated.\n    ko.bindingContext.prototype['extend'] = function(properties) {\n        // If the parent context references an observable view model, \"_subscribable\" will always be the\n        // latest view model object. If not, \"_subscribable\" isn't set, and we can use the static \"$data\" value.\n        return new ko.bindingContext(this._subscribable || this['$data'], this, null, function(self, parentContext) {\n            // This \"child\" context doesn't directly track a parent observable view model,\n            // so we need to manually set the $rawData value to match the parent.\n            self['$rawData'] = parentContext['$rawData'];\n            ko.utils.extend(self, typeof(properties) == \"function\" ? properties() : properties);\n        });\n    };\n\n    // Returns the valueAccesor function for a binding value\n    function makeValueAccessor(value) {\n        return function() {\n            return value;\n        };\n    }\n\n    // Returns the value of a valueAccessor function\n    function evaluateValueAccessor(valueAccessor) {\n        return valueAccessor();\n    }\n\n    // Given a function that returns bindings, create and return a new object that contains\n    // binding value-accessors functions. Each accessor function calls the original function\n    // so that it always gets the latest value and all dependencies are captured. This is used\n    // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n    function makeAccessorsFromFunction(callback) {\n        return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n            return function() {\n                return callback()[key];\n            };\n        });\n    }\n\n    // Given a bindings function or object, create and return a new object that contains\n    // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n    function makeBindingAccessors(bindings, context, node) {\n        if (typeof bindings === 'function') {\n            return makeAccessorsFromFunction(bindings.bind(null, context, node));\n        } else {\n            return ko.utils.objectMap(bindings, makeValueAccessor);\n        }\n    }\n\n    // This function is used if the binding provider doesn't include a getBindingAccessors function.\n    // It must be called with 'this' set to the provider instance.\n    function getBindingsAndMakeAccessors(node, context) {\n        return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n    }\n\n    function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n        var validator = ko.virtualElements.allowedBindings[bindingName];\n        if (!validator)\n            throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n    }\n\n    function applyBindingsToDescendantsInternal (bindingContext, elementOrVirtualElement, bindingContextsMayDifferFromDomParentElement) {\n        var currentChild,\n            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement),\n            provider = ko.bindingProvider['instance'],\n            preprocessNode = provider['preprocessNode'];\n\n        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n        // trigger insertion of <template> contents at that point in the document.\n        if (preprocessNode) {\n            while (currentChild = nextInQueue) {\n                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                preprocessNode.call(provider, currentChild);\n            }\n            // Reset nextInQueue for the next loop\n            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n        }\n\n        while (currentChild = nextInQueue) {\n            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild, bindingContextsMayDifferFromDomParentElement);\n        }\n    }\n\n    function applyBindingsToNodeAndDescendantsInternal (bindingContext, nodeVerified, bindingContextMayDifferFromDomParentElement) {\n        var shouldBindDescendants = true;\n\n        // Perf optimisation: Apply bindings only if...\n        // (1) We need to store the binding context on this node (because it may differ from the DOM parent node's binding context)\n        //     Note that we can't store binding contexts on non-elements (e.g., text nodes), as IE doesn't allow expando properties for those\n        // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n        var isElement = (nodeVerified.nodeType === 1);\n        if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n            ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n        var shouldApplyBindings = (isElement && bindingContextMayDifferFromDomParentElement)             // Case (1)\n                               || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);       // Case (2)\n        if (shouldApplyBindings)\n            shouldBindDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext, bindingContextMayDifferFromDomParentElement)['shouldBindDescendants'];\n\n        if (shouldBindDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n            // We're recursing automatically into (real or virtual) child nodes without changing binding contexts. So,\n            //  * For children of a *real* element, the binding context is certainly the same as on their DOM .parentNode,\n            //    hence bindingContextsMayDifferFromDomParentElement is false\n            //  * For children of a *virtual* element, we can't be sure. Evaluating .parentNode on those children may\n            //    skip over any number of intermediate virtual elements, any of which might define a custom binding context,\n            //    hence bindingContextsMayDifferFromDomParentElement is true\n            applyBindingsToDescendantsInternal(bindingContext, nodeVerified, /* bindingContextsMayDifferFromDomParentElement: */ !isElement);\n        }\n    }\n\n    var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n\n    function topologicalSortBindings(bindings) {\n        // Depth-first sort\n        var result = [],                // The list of key/handler pairs that we will return\n            bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n            cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n        ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n            if (!bindingsConsidered[bindingKey]) {\n                var binding = ko['getBindingHandler'](bindingKey);\n                if (binding) {\n                    // First add dependencies (if any) of the current binding\n                    if (binding['after']) {\n                        cyclicDependencyStack.push(bindingKey);\n                        ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                            if (bindings[bindingDependencyKey]) {\n                                if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                    throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                } else {\n                                    pushBinding(bindingDependencyKey);\n                                }\n                            }\n                        });\n                        cyclicDependencyStack.length--;\n                    }\n                    // Next add the current binding\n                    result.push({ key: bindingKey, handler: binding });\n                }\n                bindingsConsidered[bindingKey] = true;\n            }\n        });\n\n        return result;\n    }\n\n    function applyBindingsToNodeInternal(node, sourceBindings, bindingContext, bindingContextMayDifferFromDomParentElement) {\n        // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n        var alreadyBound = ko.utils.domData.get(node, boundElementDomDataKey);\n        if (!sourceBindings) {\n            if (alreadyBound) {\n                throw Error(\"You cannot apply bindings multiple times to the same element.\");\n            }\n            ko.utils.domData.set(node, boundElementDomDataKey, true);\n        }\n\n        // Optimization: Don't store the binding context on this node if it's definitely the same as on node.parentNode, because\n        // we can easily recover it just by scanning up the node's ancestors in the DOM\n        // (note: here, parent node means \"real DOM parent\" not \"virtual parent\", as there's no O(1) way to find the virtual parent)\n        if (!alreadyBound && bindingContextMayDifferFromDomParentElement)\n            ko.storedBindingContextForNode(node, bindingContext);\n\n        // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n        var bindings;\n        if (sourceBindings && typeof sourceBindings !== 'function') {\n            bindings = sourceBindings;\n        } else {\n            var provider = ko.bindingProvider['instance'],\n                getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n            // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n            // the binding context is updated or if the binding provider accesses observables.\n            var bindingsUpdater = ko.dependentObservable(\n                function() {\n                    bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                    // Register a dependency on the binding context to support obsevable view models.\n                    if (bindings && bindingContext._subscribable)\n                        bindingContext._subscribable();\n                    return bindings;\n                },\n                null, { disposeWhenNodeIsRemoved: node }\n            );\n\n            if (!bindings || !bindingsUpdater.isActive())\n                bindingsUpdater = null;\n        }\n\n        var bindingHandlerThatControlsDescendantBindings;\n        if (bindings) {\n            // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n            // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n            // the latest binding value and registers a dependency on the binding updater.\n            var getValueAccessor = bindingsUpdater\n                ? function(bindingKey) {\n                    return function() {\n                        return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                    };\n                } : function(bindingKey) {\n                    return bindings[bindingKey];\n                };\n\n            // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n            function allBindings() {\n                return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n            }\n            // The following is the 3.x allBindings API\n            allBindings['get'] = function(key) {\n                return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n            };\n            allBindings['has'] = function(key) {\n                return key in bindings;\n            };\n\n            // First put the bindings into the right order\n            var orderedBindings = topologicalSortBindings(bindings);\n\n            // Go through the sorted bindings, calling init and update for each\n            ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                // so bindingKeyAndHandler.handler will always be nonnull.\n                var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                    handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                    bindingKey = bindingKeyAndHandler.key;\n\n                if (node.nodeType === 8) {\n                    validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                }\n\n                try {\n                    // Run init, ignoring any dependencies\n                    if (typeof handlerInitFn == \"function\") {\n                        ko.dependencyDetection.ignore(function() {\n                            var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, bindingContext['$data'], bindingContext);\n\n                            // If this binding handler claims to control descendant bindings, make a note of this\n                            if (initResult && initResult['controlsDescendantBindings']) {\n                                if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                    throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                bindingHandlerThatControlsDescendantBindings = bindingKey;\n                            }\n                        });\n                    }\n\n                    // Run update in its own computed wrapper\n                    if (typeof handlerUpdateFn == \"function\") {\n                        ko.dependentObservable(\n                            function() {\n                                handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, bindingContext['$data'], bindingContext);\n                            },\n                            null,\n                            { disposeWhenNodeIsRemoved: node }\n                        );\n                    }\n                } catch (ex) {\n                    ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                    throw ex;\n                }\n            });\n        }\n\n        return {\n            'shouldBindDescendants': bindingHandlerThatControlsDescendantBindings === undefined\n        };\n    };\n\n    var storedBindingContextDomDataKey = ko.utils.domData.nextKey();\n    ko.storedBindingContextForNode = function (node, bindingContext) {\n        if (arguments.length == 2) {\n            ko.utils.domData.set(node, storedBindingContextDomDataKey, bindingContext);\n            if (bindingContext._subscribable)\n                bindingContext._subscribable._addNode(node);\n        } else {\n            return ko.utils.domData.get(node, storedBindingContextDomDataKey);\n        }\n    }\n\n    function getBindingContext(viewModelOrBindingContext) {\n        return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n            ? viewModelOrBindingContext\n            : new ko.bindingContext(viewModelOrBindingContext);\n    }\n\n    ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n        if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n            ko.virtualElements.normaliseVirtualElementDomStructure(node);\n        return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext), true);\n    };\n\n    ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n        var context = getBindingContext(viewModelOrBindingContext);\n        return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n    };\n\n    ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n        if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n            applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);\n    };\n\n    ko.applyBindings = function (viewModelOrBindingContext, rootNode) {\n        // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n        if (!jQueryInstance && window['jQuery']) {\n            jQueryInstance = window['jQuery'];\n        }\n\n        if (rootNode && (rootNode.nodeType !== 1) && (rootNode.nodeType !== 8))\n            throw new Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n        rootNode = rootNode || window.document.body; // Make \"rootNode\" parameter optional\n\n        applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);\n    };\n\n    // Retrieving binding context from arbitrary nodes\n    ko.contextFor = function(node) {\n        // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n        switch (node.nodeType) {\n            case 1:\n            case 8:\n                var context = ko.storedBindingContextForNode(node);\n                if (context) return context;\n                if (node.parentNode) return ko.contextFor(node.parentNode);\n                break;\n        }\n        return undefined;\n    };\n    ko.dataFor = function(node) {\n        var context = ko.contextFor(node);\n        return context ? context['$data'] : undefined;\n    };\n\n    ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n    ko.exportSymbol('applyBindings', ko.applyBindings);\n    ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n    ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n    ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n    ko.exportSymbol('contextFor', ko.contextFor);\n    ko.exportSymbol('dataFor', ko.dataFor);\n})();\n(function(undefined) {\n    var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n        loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n    ko.components = {\n        get: function(componentName, callback) {\n            var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n            if (cachedDefinition) {\n                // It's already loaded and cached. Reuse the same definition object.\n                // Note that for API consistency, even cache hits complete asynchronously by default.\n                // You can bypass this by putting synchronous:true on your component config.\n                if (cachedDefinition.isSynchronousComponent) {\n                    ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                        callback(cachedDefinition.definition);\n                    });\n                } else {\n                    setTimeout(function() { callback(cachedDefinition.definition); }, 0);\n                }\n            } else {\n                // Join the loading process that is already underway, or start a new one.\n                loadComponentAndNotify(componentName, callback);\n            }\n        },\n\n        clearCachedDefinition: function(componentName) {\n            delete loadedDefinitionsCache[componentName];\n        },\n\n        _getFirstResultFromLoaders: getFirstResultFromLoaders\n    };\n\n    function getObjectOwnProperty(obj, propName) {\n        return obj.hasOwnProperty(propName) ? obj[propName] : undefined;\n    }\n\n    function loadComponentAndNotify(componentName, callback) {\n        var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n            completedAsync;\n        if (!subscribable) {\n            // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n            subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n            subscribable.subscribe(callback);\n\n            beginLoadingComponent(componentName, function(definition, config) {\n                var isSynchronousComponent = !!(config && config['synchronous']);\n                loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                delete loadingSubscribablesCache[componentName];\n\n                // For API consistency, all loads complete asynchronously. However we want to avoid\n                // adding an extra setTimeout if it's unnecessary (i.e., the completion is already\n                // async) since setTimeout(..., 0) still takes about 16ms or more on most browsers.\n                //\n                // You can bypass the 'always synchronous' feature by putting the synchronous:true\n                // flag on your component configuration when you register it.\n                if (completedAsync || isSynchronousComponent) {\n                    // Note that notifySubscribers ignores any dependencies read within the callback.\n                    // See comment in loaderRegistryBehaviors.js for reasoning\n                    subscribable['notifySubscribers'](definition);\n                } else {\n                    setTimeout(function() {\n                        subscribable['notifySubscribers'](definition);\n                    }, 0);\n                }\n            });\n            completedAsync = true;\n        } else {\n            subscribable.subscribe(callback);\n        }\n    }\n\n    function beginLoadingComponent(componentName, callback) {\n        getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n            if (config) {\n                // We have a config, so now load its definition\n                getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                    callback(definition, config);\n                });\n            } else {\n                // The component has no config - it's unknown to all the loaders.\n                // Note that this is not an error (e.g., a module loading error) - that would abort the\n                // process and this callback would not run. For this callback to run, all loaders must\n                // have confirmed they don't know about this component.\n                callback(null, null);\n            }\n        });\n    }\n\n    function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n        // On the first call in the stack, start with the full set of loaders\n        if (!candidateLoaders) {\n            candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n        }\n\n        // Try the next candidate\n        var currentCandidateLoader = candidateLoaders.shift();\n        if (currentCandidateLoader) {\n            var methodInstance = currentCandidateLoader[methodName];\n            if (methodInstance) {\n                var wasAborted = false,\n                    synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                        if (wasAborted) {\n                            callback(null);\n                        } else if (result !== null) {\n                            // This candidate returned a value. Use it.\n                            callback(result);\n                        } else {\n                            // Try the next candidate\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    }));\n\n                // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                // that we'll extend the API to support synchronous return values in the future. It won't be\n                // a breaking change, because currently no loader is allowed to return anything except undefined.\n                if (synchronousReturnValue !== undefined) {\n                    wasAborted = true;\n\n                    // Method to suppress exceptions will remain undocumented. This is only to keep\n                    // KO's specs running tidily, since we can observe the loading got aborted without\n                    // having exceptions cluttering up the console too.\n                    if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                        throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                    }\n                }\n            } else {\n                // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n            }\n        } else {\n            // No candidates returned a value\n            callback(null);\n        }\n    }\n\n    // Reference the loaders via string name so it's possible for developers\n    // to replace the whole array by assigning to ko.components.loaders\n    ko.components['loaders'] = [];\n\n    ko.exportSymbol('components', ko.components);\n    ko.exportSymbol('components.get', ko.components.get);\n    ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n})();\n(function(undefined) {\n\n    // The default loader is responsible for two things:\n    // 1. Maintaining the default in-memory registry of component configuration objects\n    //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n    // 2. Answering requests for components by fetching configuration objects\n    //    from that default in-memory registry and resolving them into standard\n    //    component definition objects (of the form { createViewModel: ..., template: ... })\n    // Custom loaders may override either of these facilities, i.e.,\n    // 1. To supply configuration objects from some other source (e.g., conventions)\n    // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n    var defaultConfigRegistry = {};\n\n    ko.components.register = function(componentName, config) {\n        if (!config) {\n            throw new Error('Invalid configuration for ' + componentName);\n        }\n\n        if (ko.components.isRegistered(componentName)) {\n            throw new Error('Component ' + componentName + ' is already registered');\n        }\n\n        defaultConfigRegistry[componentName] = config;\n    }\n\n    ko.components.isRegistered = function(componentName) {\n        return componentName in defaultConfigRegistry;\n    }\n\n    ko.components.unregister = function(componentName) {\n        delete defaultConfigRegistry[componentName];\n        ko.components.clearCachedDefinition(componentName);\n    }\n\n    ko.components.defaultLoader = {\n        'getConfig': function(componentName, callback) {\n            var result = defaultConfigRegistry.hasOwnProperty(componentName)\n                ? defaultConfigRegistry[componentName]\n                : null;\n            callback(result);\n        },\n\n        'loadComponent': function(componentName, config, callback) {\n            var errorCallback = makeErrorCallback(componentName);\n            possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                resolveConfig(componentName, errorCallback, loadedConfig, callback);\n            });\n        },\n\n        'loadTemplate': function(componentName, templateConfig, callback) {\n            resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n        },\n\n        'loadViewModel': function(componentName, viewModelConfig, callback) {\n            resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n        }\n    };\n\n    var createViewModelKey = 'createViewModel';\n\n    // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n    // into the standard component definition format:\n    //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n    // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n    // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n    // so this is implemented manually below.\n    function resolveConfig(componentName, errorCallback, config, callback) {\n        var result = {},\n            makeCallBackWhenZero = 2,\n            tryIssueCallback = function() {\n                if (--makeCallBackWhenZero === 0) {\n                    callback(result);\n                }\n            },\n            templateConfig = config['template'],\n            viewModelConfig = config['viewModel'];\n\n        if (templateConfig) {\n            possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                    result['template'] = resolvedTemplate;\n                    tryIssueCallback();\n                });\n            });\n        } else {\n            tryIssueCallback();\n        }\n\n        if (viewModelConfig) {\n            possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                    result[createViewModelKey] = resolvedViewModel;\n                    tryIssueCallback();\n                });\n            });\n        } else {\n            tryIssueCallback();\n        }\n    }\n\n    function resolveTemplate(errorCallback, templateConfig, callback) {\n        if (typeof templateConfig === 'string') {\n            // Markup - parse it\n            callback(ko.utils.parseHtmlFragment(templateConfig));\n        } else if (templateConfig instanceof Array) {\n            // Assume already an array of DOM nodes - pass through unchanged\n            callback(templateConfig);\n        } else if (isDocumentFragment(templateConfig)) {\n            // Document fragment - use its child nodes\n            callback(ko.utils.makeArray(templateConfig.childNodes));\n        } else if (templateConfig['element']) {\n            var element = templateConfig['element'];\n            if (isDomElement(element)) {\n                // Element instance - copy its child nodes\n                callback(cloneNodesFromTemplateSourceElement(element));\n            } else if (typeof element === 'string') {\n                // Element ID - find it, then copy its child nodes\n                var elemInstance = document.getElementById(element);\n                if (elemInstance) {\n                    callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                } else {\n                    errorCallback('Cannot find element with ID ' + element);\n                }\n            } else {\n                errorCallback('Unknown element type: ' + element);\n            }\n        } else {\n            errorCallback('Unknown template value: ' + templateConfig);\n        }\n    }\n\n    function resolveViewModel(errorCallback, viewModelConfig, callback) {\n        if (typeof viewModelConfig === 'function') {\n            // Constructor - convert to standard factory function format\n            // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n            // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n            // be used in factory functions, not viewmodel constructors.\n            callback(function (params /*, componentInfo */) {\n                return new viewModelConfig(params);\n            });\n        } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n            // Already a factory function - use it as-is\n            callback(viewModelConfig[createViewModelKey]);\n        } else if ('instance' in viewModelConfig) {\n            // Fixed object instance - promote to createViewModel format for API consistency\n            var fixedInstance = viewModelConfig['instance'];\n            callback(function (params, componentInfo) {\n                return fixedInstance;\n            });\n        } else if ('viewModel' in viewModelConfig) {\n            // Resolved AMD module whose value is of the form { viewModel: ... }\n            resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n        } else {\n            errorCallback('Unknown viewModel value: ' + viewModelConfig);\n        }\n    }\n\n    function cloneNodesFromTemplateSourceElement(elemInstance) {\n        switch (ko.utils.tagNameLower(elemInstance)) {\n            case 'script':\n                return ko.utils.parseHtmlFragment(elemInstance.text);\n            case 'textarea':\n                return ko.utils.parseHtmlFragment(elemInstance.value);\n            case 'template':\n                // For browsers with proper <template> element support (i.e., where the .content property\n                // gives a document fragment), use that document fragment.\n                if (isDocumentFragment(elemInstance.content)) {\n                    return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                }\n        }\n\n        // Regular elements such as <div>, and <template> elements on old browsers that don't really\n        // understand <template> and just treat it as a regular container\n        return ko.utils.cloneNodes(elemInstance.childNodes);\n    }\n\n    function isDomElement(obj) {\n        if (window['HTMLElement']) {\n            return obj instanceof HTMLElement;\n        } else {\n            return obj && obj.tagName && obj.nodeType === 1;\n        }\n    }\n\n    function isDocumentFragment(obj) {\n        if (window['DocumentFragment']) {\n            return obj instanceof DocumentFragment;\n        } else {\n            return obj && obj.nodeType === 11;\n        }\n    }\n\n    function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n        if (typeof config['require'] === 'string') {\n            // The config is the value of an AMD module\n            if (amdRequire || window['require']) {\n                (amdRequire || window['require'])([config['require']], callback);\n            } else {\n                errorCallback('Uses require, but no AMD loader is present');\n            }\n        } else {\n            callback(config);\n        }\n    }\n\n    function makeErrorCallback(componentName) {\n        return function (message) {\n            throw new Error('Component \\'' + componentName + '\\': ' + message);\n        };\n    }\n\n    ko.exportSymbol('components.register', ko.components.register);\n    ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n    ko.exportSymbol('components.unregister', ko.components.unregister);\n\n    // Expose the default loader so that developers can directly ask it for configuration\n    // or to resolve configuration\n    ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n    // By default, the default loader is the only registered component loader\n    ko.components['loaders'].push(ko.components.defaultLoader);\n\n    // Privately expose the underlying config registry for use in old-IE shim\n    ko.components._allRegisteredComponents = defaultConfigRegistry;\n})();\n(function (undefined) {\n    // Overridable API for determining which component name applies to a given node. By overriding this,\n    // you can for example map specific tagNames to components that are not preregistered.\n    ko.components['getComponentNameForNode'] = function(node) {\n        var tagNameLower = ko.utils.tagNameLower(node);\n        return ko.components.isRegistered(tagNameLower) && tagNameLower;\n    };\n\n    ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n        // Determine if it's really a custom element matching a component\n        if (node.nodeType === 1) {\n            var componentName = ko.components['getComponentNameForNode'](node);\n            if (componentName) {\n                // It does represent a component, so add a component binding for it\n                allBindings = allBindings || {};\n\n                if (allBindings['component']) {\n                    // Avoid silently overwriting some other 'component' binding that may already be on the element\n                    throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                }\n\n                var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                allBindings['component'] = valueAccessors\n                    ? function() { return componentBindingValue; }\n                    : componentBindingValue;\n            }\n        }\n\n        return allBindings;\n    }\n\n    var nativeBindingProviderInstance = new ko.bindingProvider();\n\n    function getComponentParamsFromCustomElement(elem, bindingContext) {\n        var paramsAttribute = elem.getAttribute('params');\n\n        if (paramsAttribute) {\n            var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                    return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                }),\n                result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                    var paramValue = paramValueComputed.peek();\n                    // Does the evaluation of the parameter value unwrap any observables?\n                    if (!paramValueComputed.isActive()) {\n                        // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                        // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                        return paramValue;\n                    } else {\n                        // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                        // level of observability, and any inner (resulting model value) level of observability.\n                        // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                        // writable observable, the computed will also be writable and pass the value on to the observable.\n                        return ko.computed({\n                            'read': function() {\n                                return ko.utils.unwrapObservable(paramValueComputed());\n                            },\n                            'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                paramValueComputed()(value);\n                            },\n                            disposeWhenNodeIsRemoved: elem\n                        });\n                    }\n                });\n\n            // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n            // This is in case the developer wants to react to outer (binding) observability separately from inner\n            // (model value) observability, or in case the model value observable has subobservables.\n            if (!result.hasOwnProperty('$raw')) {\n                result['$raw'] = rawParamComputedValues;\n            }\n\n            return result;\n        } else {\n            // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n            // any empty one. Otherwise component viewmodels need special code to check whether or not\n            // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n            return { '$raw': {} };\n        }\n    }\n\n    // --------------------------------------------------------------------------------\n    // Compatibility code for older (pre-HTML5) IE browsers\n\n    if (ko.utils.ieVersion < 9) {\n        // Whenever you preregister a component, enable it as a custom element in the current document\n        ko.components['register'] = (function(originalFunction) {\n            return function(componentName) {\n                document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                return originalFunction.apply(this, arguments);\n            }\n        })(ko.components['register']);\n\n        // Whenever you create a document fragment, enable all preregistered component names as custom elements\n        // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n        document.createDocumentFragment = (function(originalFunction) {\n            return function() {\n                var newDocFrag = originalFunction(),\n                    allComponents = ko.components._allRegisteredComponents;\n                for (var componentName in allComponents) {\n                    if (allComponents.hasOwnProperty(componentName)) {\n                        newDocFrag.createElement(componentName);\n                    }\n                }\n                return newDocFrag;\n            };\n        })(document.createDocumentFragment);\n    }\n})();(function(undefined) {\n\n    var componentLoadingOperationUniqueId = 0;\n\n    ko.bindingHandlers['component'] = {\n        'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n            var currentViewModel,\n                currentLoadingOperationId,\n                disposeAssociatedComponentViewModel = function () {\n                    var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                    if (typeof currentViewModelDispose === 'function') {\n                        currentViewModelDispose.call(currentViewModel);\n                    }\n\n                    // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                    currentLoadingOperationId = null;\n                },\n                originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n            ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n            ko.computed(function () {\n                var value = ko.utils.unwrapObservable(valueAccessor()),\n                    componentName, componentParams;\n\n                if (typeof value === 'string') {\n                    componentName = value;\n                } else {\n                    componentName = ko.utils.unwrapObservable(value['name']);\n                    componentParams = ko.utils.unwrapObservable(value['params']);\n                }\n\n                if (!componentName) {\n                    throw new Error('No component name specified');\n                }\n\n                var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                ko.components.get(componentName, function(componentDefinition) {\n                    // If this is not the current load operation for this element, ignore it.\n                    if (currentLoadingOperationId !== loadingOperationId) {\n                        return;\n                    }\n\n                    // Clean up previous state\n                    disposeAssociatedComponentViewModel();\n\n                    // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                    if (!componentDefinition) {\n                        throw new Error('Unknown component \\'' + componentName + '\\'');\n                    }\n                    cloneTemplateIntoElement(componentName, componentDefinition, element);\n                    var componentViewModel = createViewModel(componentDefinition, element, originalChildNodes, componentParams),\n                        childBindingContext = bindingContext['createChildContext'](componentViewModel, /* dataItemAlias */ undefined, function(ctx) {\n                            ctx['$component'] = componentViewModel;\n                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                        });\n                    currentViewModel = componentViewModel;\n                    ko.applyBindingsToDescendants(childBindingContext, element);\n                });\n            }, null, { disposeWhenNodeIsRemoved: element });\n\n            return { 'controlsDescendantBindings': true };\n        }\n    };\n\n    ko.virtualElements.allowedBindings['component'] = true;\n\n    function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n        var template = componentDefinition['template'];\n        if (!template) {\n            throw new Error('Component \\'' + componentName + '\\' has no template');\n        }\n\n        var clonedNodesArray = ko.utils.cloneNodes(template);\n        ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n    }\n\n    function createViewModel(componentDefinition, element, originalChildNodes, componentParams) {\n        var componentViewModelFactory = componentDefinition['createViewModel'];\n        return componentViewModelFactory\n            ? componentViewModelFactory.call(componentDefinition, componentParams, { 'element': element, 'templateNodes': originalChildNodes })\n            : componentParams; // Template-only component\n    }\n\n})();\nvar attrHtmlToJavascriptMap = { 'class': 'className', 'for': 'htmlFor' };\nko.bindingHandlers['attr'] = {\n    'update': function(element, valueAccessor, allBindings) {\n        var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n        ko.utils.objectForEach(value, function(attrName, attrValue) {\n            attrValue = ko.utils.unwrapObservable(attrValue);\n\n            // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n            // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n            // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n            var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n            if (toRemove)\n                element.removeAttribute(attrName);\n\n            // In IE <= 7 and IE8 Quirks Mode, you have to use the Javascript property name instead of the\n            // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n            // but instead of figuring out the mode, we'll just set the attribute through the Javascript\n            // property for IE <= 8.\n            if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavascriptMap) {\n                attrName = attrHtmlToJavascriptMap[attrName];\n                if (toRemove)\n                    element.removeAttribute(attrName);\n                else\n                    element[attrName] = attrValue;\n            } else if (!toRemove) {\n                element.setAttribute(attrName, attrValue.toString());\n            }\n\n            // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n            // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n            // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n            // entirely, and there's no strong reason to allow for such casing in HTML.\n            if (attrName === \"name\") {\n                ko.utils.setElementName(element, toRemove ? \"\" : attrValue.toString());\n            }\n        });\n    }\n};\n(function() {\n\nko.bindingHandlers['checked'] = {\n    'after': ['value', 'attr'],\n    'init': function (element, valueAccessor, allBindings) {\n        var checkedValue = ko.pureComputed(function() {\n            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n            if (allBindings['has']('checkedValue')) {\n                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n            } else if (allBindings['has']('value')) {\n                return ko.utils.unwrapObservable(allBindings.get('value'));\n            }\n\n            return element.value;\n        });\n\n        function updateModel() {\n            // This updates the model value from the view value.\n            // It runs in response to DOM events (click) and changes in checkedValue.\n            var isChecked = element.checked,\n                elemValue = useCheckedValue ? checkedValue() : isChecked;\n\n            // When we're first setting up this computed, don't change any model state.\n            if (ko.computedContext.isInitial()) {\n                return;\n            }\n\n            // We can ignore unchecked radio buttons, because some other radio\n            // button will be getting checked, and that one can take care of updating state.\n            if (isRadio && !isChecked) {\n                return;\n            }\n\n            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n            if (isValueArray) {\n                if (oldElemValue !== elemValue) {\n                    // When we're responding to the checkedValue changing, and the element is\n                    // currently checked, replace the old elem value with the new elem value\n                    // in the model array.\n                    if (isChecked) {\n                        ko.utils.addOrRemoveItem(modelValue, elemValue, true);\n                        ko.utils.addOrRemoveItem(modelValue, oldElemValue, false);\n                    }\n\n                    oldElemValue = elemValue;\n                } else {\n                    // When we're responding to the user having checked/unchecked a checkbox,\n                    // add/remove the element value to the model array.\n                    ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);\n                }\n            } else {\n                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n            }\n        };\n\n        function updateView() {\n            // This updates the view value from the model value.\n            // It runs in response to changes in the bound (checked) value.\n            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n            if (isValueArray) {\n                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n            } else if (isCheckbox) {\n                // When a checkbox is bound to any other value (not an array), being checked represents the value being trueish\n                element.checked = modelValue;\n            } else {\n                // For radio buttons, being checked means that the radio button's value corresponds to the model value\n                element.checked = (checkedValue() === modelValue);\n            }\n        };\n\n        var isCheckbox = element.type == \"checkbox\",\n            isRadio = element.type == \"radio\";\n\n        // Only bind to check boxes and radio buttons\n        if (!isCheckbox && !isRadio) {\n            return;\n        }\n\n        var isValueArray = isCheckbox && (ko.utils.unwrapObservable(valueAccessor()) instanceof Array),\n            oldElemValue = isValueArray ? checkedValue() : undefined,\n            useCheckedValue = isRadio || isValueArray;\n\n        // IE 6 won't allow radio buttons to be selected unless they have a name\n        if (isRadio && !element.name)\n            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n        // Set up two computeds to update the binding:\n\n        // The first responds to changes in the checkedValue value and to element clicks\n        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n        // The second responds to changes in the model value (the one associated with the checked binding)\n        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n    }\n};\nko.expressionRewriting.twoWayBindings['checked'] = true;\n\nko.bindingHandlers['checkedValue'] = {\n    'update': function (element, valueAccessor) {\n        element.value = ko.utils.unwrapObservable(valueAccessor());\n    }\n};\n\n})();var classesWrittenByBindingKey = '__ko__cssValue';\nko.bindingHandlers['css'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        if (value !== null && typeof value == \"object\") {\n            ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n            });\n        } else {\n            value = String(value || ''); // Make sure we don't try to store or set a non-string value\n            ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n            element[classesWrittenByBindingKey] = value;\n            ko.utils.toggleDomNodeCssClass(element, value, true);\n        }\n    }\n};\nko.bindingHandlers['enable'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        if (value && element.disabled)\n            element.removeAttribute(\"disabled\");\n        else if ((!value) && (!element.disabled))\n            element.disabled = true;\n    }\n};\n\nko.bindingHandlers['disable'] = {\n    'update': function (element, valueAccessor) {\n        ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n    }\n};\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\nfunction makeEventHandlerShortcut(eventName) {\n    ko.bindingHandlers[eventName] = {\n        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var newValueAccessor = function () {\n                var result = {};\n                result[eventName] = valueAccessor();\n                return result;\n            };\n            return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n        }\n    }\n}\n\nko.bindingHandlers['event'] = {\n    'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n        var eventsToHandle = valueAccessor() || {};\n        ko.utils.objectForEach(eventsToHandle, function(eventName) {\n            if (typeof eventName == \"string\") {\n                ko.utils.registerEventHandler(element, eventName, function (event) {\n                    var handlerReturnValue;\n                    var handlerFunction = valueAccessor()[eventName];\n                    if (!handlerFunction)\n                        return;\n\n                    try {\n                        // Take all the event args, and prefix with the viewmodel\n                        var argsForHandler = ko.utils.makeArray(arguments);\n                        viewModel = bindingContext['$data'];\n                        argsForHandler.unshift(viewModel);\n                        handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                    } finally {\n                        if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                            if (event.preventDefault)\n                                event.preventDefault();\n                            else\n                                event.returnValue = false;\n                        }\n                    }\n\n                    var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                    if (!bubble) {\n                        event.cancelBubble = true;\n                        if (event.stopPropagation)\n                            event.stopPropagation();\n                    }\n                });\n            }\n        });\n    }\n};\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\nko.bindingHandlers['foreach'] = {\n    makeTemplateValueAccessor: function(valueAccessor) {\n        return function() {\n            var modelValue = valueAccessor(),\n                unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n            // If unwrappedValue is the array, pass in the wrapped value on its own\n            // The value will be unwrapped and tracked within the template binding\n            // (See https://github.com/SteveSanderson/knockout/issues/523)\n            if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n            // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n            ko.utils.unwrapObservable(modelValue);\n            return {\n                'foreach': unwrappedValue['data'],\n                'as': unwrappedValue['as'],\n                'includeDestroyed': unwrappedValue['includeDestroyed'],\n                'afterAdd': unwrappedValue['afterAdd'],\n                'beforeRemove': unwrappedValue['beforeRemove'],\n                'afterRender': unwrappedValue['afterRender'],\n                'beforeMove': unwrappedValue['beforeMove'],\n                'afterMove': unwrappedValue['afterMove'],\n                'templateEngine': ko.nativeTemplateEngine.instance\n            };\n        };\n    },\n    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n        return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n    },\n    'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n        return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n    }\n};\nko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\nko.virtualElements.allowedBindings['foreach'] = true;\nvar hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\nvar hasfocusLastValue = '__ko_hasfocusLastValue';\nko.bindingHandlers['hasfocus'] = {\n    'init': function(element, valueAccessor, allBindings) {\n        var handleElementFocusChange = function(isFocused) {\n            // Where possible, ignore which event was raised and determine focus state using activeElement,\n            // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n            // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n            // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n            // from calling 'blur()' on the element when it loses focus.\n            // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n            element[hasfocusUpdatingProperty] = true;\n            var ownerDoc = element.ownerDocument;\n            if (\"activeElement\" in ownerDoc) {\n                var active;\n                try {\n                    active = ownerDoc.activeElement;\n                } catch(e) {\n                    // IE9 throws if you access activeElement during page load (see issue #703)\n                    active = ownerDoc.body;\n                }\n                isFocused = (active === element);\n            }\n            var modelValue = valueAccessor();\n            ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n            //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n            element[hasfocusLastValue] = isFocused;\n            element[hasfocusUpdatingProperty] = false;\n        };\n        var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n        var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n        ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n        ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n        ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n        ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n    },\n    'update': function(element, valueAccessor) {\n        var value = !!ko.utils.unwrapObservable(valueAccessor()); //force boolean to compare with last value\n        if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n            value ? element.focus() : element.blur();\n            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]); // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n        }\n    }\n};\nko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\nko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\nko.expressionRewriting.twoWayBindings['hasFocus'] = true;\nko.bindingHandlers['html'] = {\n    'init': function() {\n        // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor) {\n        // setHtml will unwrap the value if needed\n        ko.utils.setHtml(element, valueAccessor());\n    }\n};\n// Makes a binding like with or if\nfunction makeWithIfBinding(bindingKey, isWith, isNot, makeContextCallback) {\n    ko.bindingHandlers[bindingKey] = {\n        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var didDisplayOnLastUpdate,\n                savedNodes;\n            ko.computed(function() {\n                var dataValue = ko.utils.unwrapObservable(valueAccessor()),\n                    shouldDisplay = !isNot !== !dataValue, // equivalent to isNot ? !dataValue : !!dataValue\n                    isFirstRender = !savedNodes,\n                    needsRefresh = isFirstRender || isWith || (shouldDisplay !== didDisplayOnLastUpdate);\n\n                if (needsRefresh) {\n                    // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                    if (isFirstRender && ko.computedContext.getDependenciesCount()) {\n                        savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                    }\n\n                    if (shouldDisplay) {\n                        if (!isFirstRender) {\n                            ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                        }\n                        ko.applyBindingsToDescendants(makeContextCallback ? makeContextCallback(bindingContext, dataValue) : bindingContext, element);\n                    } else {\n                        ko.virtualElements.emptyNode(element);\n                    }\n\n                    didDisplayOnLastUpdate = shouldDisplay;\n                }\n            }, null, { disposeWhenNodeIsRemoved: element });\n            return { 'controlsDescendantBindings': true };\n        }\n    };\n    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n    ko.virtualElements.allowedBindings[bindingKey] = true;\n}\n\n// Construct the actual binding handlers\nmakeWithIfBinding('if');\nmakeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\nmakeWithIfBinding('with', true /* isWith */, false /* isNot */,\n    function(bindingContext, dataValue) {\n        return bindingContext['createChildContext'](dataValue);\n    }\n);\nvar captionPlaceholder = {};\nko.bindingHandlers['options'] = {\n    'init': function(element) {\n        if (ko.utils.tagNameLower(element) !== \"select\")\n            throw new Error(\"options binding applies only to SELECT elements\");\n\n        // Remove all existing <option>s.\n        while (element.length > 0) {\n            element.remove(0);\n        }\n\n        // Ensures that the binding processor doesn't try to bind the options\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor, allBindings) {\n        function selectedOptions() {\n            return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n        }\n\n        var selectWasPreviouslyEmpty = element.length == 0,\n            multiple = element.multiple,\n            previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n            unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n            valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n            includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n            arrayToDomNodeChildrenOptions = {},\n            captionValue,\n            filteredArray,\n            previousSelectedValues = [];\n\n        if (!valueAllowUnset) {\n            if (multiple) {\n                previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n            } else if (element.selectedIndex >= 0) {\n                previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n            }\n        }\n\n        if (unwrappedArray) {\n            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                unwrappedArray = [unwrappedArray];\n\n            // Filter out any entries marked as destroyed\n            filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n            });\n\n            // If caption is included, add it to the array\n            if (allBindings['has']('optionsCaption')) {\n                captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                // If caption value is null or undefined, don't show a caption\n                if (captionValue !== null && captionValue !== undefined) {\n                    filteredArray.unshift(captionPlaceholder);\n                }\n            }\n        } else {\n            // If a falsy value is provided (e.g. null), we'll simply empty the select element\n        }\n\n        function applyToObject(object, predicate, defaultValue) {\n            var predicateType = typeof predicate;\n            if (predicateType == \"function\")    // Given a function; run it against the data value\n                return predicate(object);\n            else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                return object[predicate];\n            else                                // Given no optionsText arg; use the data value itself\n                return defaultValue;\n        }\n\n        // The following functions can run at two different times:\n        // The first is when the whole array is being updated directly from this binding handler.\n        // The second is when an observable value for a specific array entry is updated.\n        // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n        var itemUpdate = false;\n        function optionForArrayItem(arrayEntry, index, oldOptions) {\n            if (oldOptions.length) {\n                previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                itemUpdate = true;\n            }\n            var option = element.ownerDocument.createElement(\"option\");\n            if (arrayEntry === captionPlaceholder) {\n                ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                ko.selectExtensions.writeValue(option, undefined);\n            } else {\n                // Apply a value to the option element\n                var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                // Apply some text to the option element\n                var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                ko.utils.setTextContent(option, optionText);\n            }\n            return [option];\n        }\n\n        // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n        // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n        arrayToDomNodeChildrenOptions['beforeRemove'] =\n            function (option) {\n                element.removeChild(option);\n            };\n\n        function setSelectionCallback(arrayEntry, newOptions) {\n            if (itemUpdate && valueAllowUnset) {\n                // The model value is authoritative, so make sure its value is the one selected\n                // There is no need to use dependencyDetection.ignore since setDomNodeChildrenFromArrayMapping does so already.\n                ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n            } else if (previousSelectedValues.length) {\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                // If this option was changed from being selected during a single-item update, notify the change\n                if (itemUpdate && !isSelected) {\n                    ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                }\n            }\n        }\n\n        var callback = setSelectionCallback;\n        if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n            callback = function(arrayEntry, newOptions) {\n                setSelectionCallback(arrayEntry, newOptions);\n                ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n            }\n        }\n\n        ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n        ko.dependencyDetection.ignore(function () {\n            if (valueAllowUnset) {\n                // The model value is authoritative, so make sure its value is the one selected\n                ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n            } else {\n                // Determine if the selection has changed as a result of updating the options list\n                var selectionChanged;\n                if (multiple) {\n                    // For a multiple-select box, compare the new selection count to the previous one\n                    // But if nothing was selected before, the selection can't have changed\n                    selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                } else {\n                    // For a single-select box, compare the current value to the previous value\n                    // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                    selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                        ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                        : (previousSelectedValues.length || element.selectedIndex >= 0);\n                }\n\n                // Ensure consistency between model value and selected option.\n                // If the dropdown was changed so that selection is no longer the same,\n                // notify the value or selectedOptions binding.\n                if (selectionChanged) {\n                    ko.utils.triggerEvent(element, \"change\");\n                }\n            }\n        });\n\n        // Workaround for IE bug\n        ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n        if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n            element.scrollTop = previousScrollTop;\n    }\n};\nko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\nko.bindingHandlers['selectedOptions'] = {\n    'after': ['options', 'foreach'],\n    'init': function (element, valueAccessor, allBindings) {\n        ko.utils.registerEventHandler(element, \"change\", function () {\n            var value = valueAccessor(), valueToWrite = [];\n            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                if (node.selected)\n                    valueToWrite.push(ko.selectExtensions.readValue(node));\n            });\n            ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n        });\n    },\n    'update': function (element, valueAccessor) {\n        if (ko.utils.tagNameLower(element) != \"select\")\n            throw new Error(\"values binding applies only to SELECT elements\");\n\n        var newValue = ko.utils.unwrapObservable(valueAccessor());\n        if (newValue && typeof newValue.length == \"number\") {\n            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                ko.utils.setOptionNodeSelectionState(node, isSelected);\n            });\n        }\n    }\n};\nko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\nko.bindingHandlers['style'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor() || {});\n        ko.utils.objectForEach(value, function(styleName, styleValue) {\n            styleValue = ko.utils.unwrapObservable(styleValue);\n\n            if (styleValue === null || styleValue === undefined || styleValue === false) {\n                // Empty string removes the value, whereas null/undefined have no effect\n                styleValue = \"\";\n            }\n\n            element.style[styleName] = styleValue;\n        });\n    }\n};\nko.bindingHandlers['submit'] = {\n    'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n        if (typeof valueAccessor() != \"function\")\n            throw new Error(\"The value for a submit binding must be a function\");\n        ko.utils.registerEventHandler(element, \"submit\", function (event) {\n            var handlerReturnValue;\n            var value = valueAccessor();\n            try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n            finally {\n                if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                    if (event.preventDefault)\n                        event.preventDefault();\n                    else\n                        event.returnValue = false;\n                }\n            }\n        });\n    }\n};\nko.bindingHandlers['text'] = {\n    'init': function() {\n        // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n        // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor) {\n        ko.utils.setTextContent(element, valueAccessor());\n    }\n};\nko.virtualElements.allowedBindings['text'] = true;\n(function () {\n\nif (window && window.navigator) {\n    var parseVersion = function (matches) {\n        if (matches) {\n            return parseFloat(matches[1]);\n        }\n    };\n\n    // Detect various browser versions because some old versions don't fully support the 'input' event\n    var operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()),\n        userAgent = window.navigator.userAgent,\n        safariVersion = parseVersion(userAgent.match(/^(?:(?!chrome).)*version\\/([^ ]*) safari/i)),\n        firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]*)/));\n}\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\nif (ko.utils.ieVersion < 10) {\n    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n        selectionChangeHandlerName = ko.utils.domData.nextKey();\n    var selectionChangeHandler = function(event) {\n        var target = this.activeElement,\n            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n        if (handler) {\n            handler(event);\n        }\n    };\n    var registerForSelectionChangeEvent = function (element, handler) {\n        var ownerDoc = element.ownerDocument;\n        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n        }\n        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n    };\n}\n\nko.bindingHandlers['textInput'] = {\n    'init': function (element, valueAccessor, allBindings) {\n\n        var previousElementValue = element.value,\n            timeoutHandle,\n            elementValueBeforeEvent;\n\n        var updateModel = function (event) {\n            clearTimeout(timeoutHandle);\n            elementValueBeforeEvent = timeoutHandle = undefined;\n\n            var elementValue = element.value;\n            if (previousElementValue !== elementValue) {\n                // Provide a way for tests to know exactly which event was processed\n                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                previousElementValue = elementValue;\n                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n            }\n        };\n\n        var deferUpdateModel = function (event) {\n            if (!timeoutHandle) {\n                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                // event firing and the updateModel function running. This allows us to ignore model\n                // updates that are from the previous state of the element, usually due to techniques\n                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                elementValueBeforeEvent = element.value;\n                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                timeoutHandle = setTimeout(handler, 4);\n            }\n        };\n\n        var updateView = function () {\n            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n            if (modelValue === null || modelValue === undefined) {\n                modelValue = '';\n            }\n\n            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                setTimeout(updateView, 4);\n                return;\n            }\n\n            // Update the element only if the element and model are different. On some browsers, updating the value\n            // will move the cursor to the end of the input, which would be bad while the user is typing.\n            if (element.value !== modelValue) {\n                previousElementValue = modelValue;  // Make sure we ignore events (propertychange) that result from updating the value\n                element.value = modelValue;\n            }\n        };\n\n        var onEvent = function (event, handler) {\n            ko.utils.registerEventHandler(element, event, handler);\n        };\n\n        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n            // Provide a way for tests to specify exactly which events are bound\n            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                if (eventName.slice(0,5) == 'after') {\n                    onEvent(eventName.slice(5), deferUpdateModel);\n                } else {\n                    onEvent(eventName, updateModel);\n                }\n            });\n        } else {\n            if (ko.utils.ieVersion < 10) {\n                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                // but that's an acceptable compromise for this binding. IE 9 does support 'input', but since it doesn't fire it\n                // when using autocomplete, we'll use 'propertychange' for it also.\n                onEvent('propertychange', function(event) {\n                    if (event.propertyName === 'value') {\n                        updateModel(event);\n                    }\n                });\n\n                if (ko.utils.ieVersion == 8) {\n                    // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                    // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                    // events too.\n                    onEvent('keyup', updateModel);      // A single keystoke\n                    onEvent('keydown', updateModel);    // The first character when a key is held down\n                }\n                if (ko.utils.ieVersion >= 8) {\n                    // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                    // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                    // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                    // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                    // These are also needed in IE8 because of the bug described above.\n                    registerForSelectionChangeEvent(element, updateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                    onEvent('dragend', deferUpdateModel);\n                }\n            } else {\n                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                // through the user interface.\n                onEvent('input', updateModel);\n\n                if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                    // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                    // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                    onEvent('keydown', deferUpdateModel);\n                    onEvent('paste', deferUpdateModel);\n                    onEvent('cut', deferUpdateModel);\n                } else if (operaVersion < 11) {\n                    // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                    // We can try to catch some of those using 'keydown'.\n                    onEvent('keydown', deferUpdateModel);\n                } else if (firefoxVersion < 4.0) {\n                    // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                    onEvent('DOMAutoComplete', updateModel);\n\n                    // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                    onEvent('dragdrop', updateModel);       // <3.5\n                    onEvent('drop', updateModel);           // 3.5\n                }\n            }\n        }\n\n        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n        onEvent('change', updateModel);\n\n        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n    }\n};\nko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\nko.bindingHandlers['textinput'] = {\n    // preprocess is the only way to set up a full alias\n    'preprocess': function (value, name, addBinding) {\n        addBinding('textInput', value);\n    }\n};\n\n})();ko.bindingHandlers['uniqueName'] = {\n    'init': function (element, valueAccessor) {\n        if (valueAccessor()) {\n            var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n            ko.utils.setElementName(element, name);\n        }\n    }\n};\nko.bindingHandlers['uniqueName'].currentIndex = 0;\nko.bindingHandlers['value'] = {\n    'after': ['options', 'foreach'],\n    'init': function (element, valueAccessor, allBindings) {\n        // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n        if (element.tagName.toLowerCase() == \"input\" && (element.type == \"checkbox\" || element.type == \"radio\")) {\n            ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n            return;\n        }\n\n        // Always catch \"change\" event; possibly other events too if asked\n        var eventsToCatch = [\"change\"];\n        var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n        var propertyChangedFired = false;\n        var elementValueBeforeEvent = null;\n\n        if (requestedEventsToCatch) {\n            if (typeof requestedEventsToCatch == \"string\") // Allow both individual event names, and arrays of event names\n                requestedEventsToCatch = [requestedEventsToCatch];\n            ko.utils.arrayPushAll(eventsToCatch, requestedEventsToCatch);\n            eventsToCatch = ko.utils.arrayGetDistinctValues(eventsToCatch);\n        }\n\n        var valueUpdateHandler = function() {\n            elementValueBeforeEvent = null;\n            propertyChangedFired = false;\n            var modelValue = valueAccessor();\n            var elementValue = ko.selectExtensions.readValue(element);\n            ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n        }\n\n        // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n        // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n        var ieAutoCompleteHackNeeded = ko.utils.ieVersion && element.tagName.toLowerCase() == \"input\" && element.type == \"text\"\n                                       && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n        if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n            ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n            ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n            ko.utils.registerEventHandler(element, \"blur\", function() {\n                if (propertyChangedFired) {\n                    valueUpdateHandler();\n                }\n            });\n        }\n\n        ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n            // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n            // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n            // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n            var handler = valueUpdateHandler;\n            if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                handler = function() {\n                    // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                    // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                    // at the earliest asynchronous opportunity. We store this temporary information so that\n                    // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                    // we can overwrite that model value change with the value the user just typed. Otherwise,\n                    // techniques like rateLimit can trigger model changes at critical moments that will\n                    // override the user's inputs, causing keystrokes to be lost.\n                    elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                    setTimeout(valueUpdateHandler, 0);\n                };\n                eventName = eventName.substring(\"after\".length);\n            }\n            ko.utils.registerEventHandler(element, eventName, handler);\n        });\n\n        var updateFromModel = function () {\n            var newValue = ko.utils.unwrapObservable(valueAccessor());\n            var elementValue = ko.selectExtensions.readValue(element);\n\n            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                setTimeout(updateFromModel, 0);\n                return;\n            }\n\n            var valueHasChanged = (newValue !== elementValue);\n\n            if (valueHasChanged) {\n                if (ko.utils.tagNameLower(element) === \"select\") {\n                    var allowUnset = allBindings.get('valueAllowUnset');\n                    var applyValueAction = function () {\n                        ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                    };\n                    applyValueAction();\n\n                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                    } else {\n                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                        // to apply the value as well.\n                        setTimeout(applyValueAction, 0);\n                    }\n                } else {\n                    ko.selectExtensions.writeValue(element, newValue);\n                }\n            }\n        };\n\n        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n    },\n    'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n};\nko.expressionRewriting.twoWayBindings['value'] = true;\nko.bindingHandlers['visible'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        var isCurrentlyVisible = !(element.style.display == \"none\");\n        if (value && !isCurrentlyVisible)\n            element.style.display = \"\";\n        else if ((!value) && isCurrentlyVisible)\n            element.style.display = \"none\";\n    }\n};\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\nmakeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\nko.templateEngine = function () { };\n\nko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n    throw new Error(\"Override renderTemplateSource\");\n};\n\nko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n    throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n};\n\nko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n    // Named template\n    if (typeof template == \"string\") {\n        templateDocument = templateDocument || document;\n        var elem = templateDocument.getElementById(template);\n        if (!elem)\n            throw new Error(\"Cannot find template with ID \" + template);\n        return new ko.templateSources.domElement(elem);\n    } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n        // Anonymous template\n        return new ko.templateSources.anonymousTemplate(template);\n    } else\n        throw new Error(\"Unknown template type: \" + template);\n};\n\nko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n    var templateSource = this['makeTemplateSource'](template, templateDocument);\n    return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n};\n\nko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n    // Skip rewriting if requested\n    if (this['allowTemplateRewriting'] === false)\n        return true;\n    return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n};\n\nko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n    var templateSource = this['makeTemplateSource'](template, templateDocument);\n    var rewritten = rewriterCallback(templateSource['text']());\n    templateSource['text'](rewritten);\n    templateSource['data'](\"isRewritten\", true);\n};\n\nko.exportSymbol('templateEngine', ko.templateEngine);\n\nko.templateRewriting = (function () {\n    var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n    var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n    function validateDataBindValuesForRewriting(keyValueArray) {\n        var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n        for (var i = 0; i < keyValueArray.length; i++) {\n            var key = keyValueArray[i]['key'];\n            if (allValidators.hasOwnProperty(key)) {\n                var validator = allValidators[key];\n\n                if (typeof validator === \"function\") {\n                    var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                    if (possibleErrorMessage)\n                        throw new Error(possibleErrorMessage);\n                } else if (!validator) {\n                    throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                }\n            }\n        }\n    }\n\n    function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n        var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n        validateDataBindValuesForRewriting(dataBindKeyValueArray);\n        var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n        // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n        // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n        // extra indirection.\n        var applyBindingsToNextSiblingScript =\n            \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n        return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n    }\n\n    return {\n        ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n            if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                templateEngine['rewriteTemplate'](template, function (htmlString) {\n                    return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                }, templateDocument);\n        },\n\n        memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n            return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n            }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n            });\n        },\n\n        applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n            return ko.memoization.memoize(function (domNode, bindingContext) {\n                var nodeToBind = domNode.nextSibling;\n                if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                    ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                }\n            });\n        }\n    }\n})();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\nko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n(function() {\n    // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n    // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n    //\n    // Two are provided by default:\n    //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n    //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n    //                                           without reading/writing the actual element text content, since it will be overwritten\n    //                                           with the rendered template output.\n    // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n    // Template sources need to have the following functions:\n    //   text()             - returns the template text from your storage location\n    //   text(value)        - writes the supplied template text to your storage location\n    //   data(key)          - reads values stored using data(key, value) - see below\n    //   data(key, value)   - associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n    //\n    // Optionally, template sources can also have the following functions:\n    //   nodes()            - returns a DOM element containing the nodes of this template, where available\n    //   nodes(value)       - writes the given DOM element to your storage location\n    // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n    // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n    //\n    // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n    // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n    ko.templateSources = {};\n\n    // ---- ko.templateSources.domElement -----\n\n    ko.templateSources.domElement = function(element) {\n        this.domElement = element;\n    }\n\n    ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n        var tagNameLower = ko.utils.tagNameLower(this.domElement),\n            elemContentsProperty = tagNameLower === \"script\" ? \"text\"\n                                 : tagNameLower === \"textarea\" ? \"value\"\n                                 : \"innerHTML\";\n\n        if (arguments.length == 0) {\n            return this.domElement[elemContentsProperty];\n        } else {\n            var valueToWrite = arguments[0];\n            if (elemContentsProperty === \"innerHTML\")\n                ko.utils.setHtml(this.domElement, valueToWrite);\n            else\n                this.domElement[elemContentsProperty] = valueToWrite;\n        }\n    };\n\n    var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n    ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n        if (arguments.length === 1) {\n            return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n        } else {\n            ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n        }\n    };\n\n    // ---- ko.templateSources.anonymousTemplate -----\n    // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n    // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n    // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n    var anonymousTemplatesDomDataKey = ko.utils.domData.nextKey();\n    ko.templateSources.anonymousTemplate = function(element) {\n        this.domElement = element;\n    }\n    ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n    ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n    ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n        if (arguments.length == 0) {\n            var templateData = ko.utils.domData.get(this.domElement, anonymousTemplatesDomDataKey) || {};\n            if (templateData.textData === undefined && templateData.containerData)\n                templateData.textData = templateData.containerData.innerHTML;\n            return templateData.textData;\n        } else {\n            var valueToWrite = arguments[0];\n            ko.utils.domData.set(this.domElement, anonymousTemplatesDomDataKey, {textData: valueToWrite});\n        }\n    };\n    ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n        if (arguments.length == 0) {\n            var templateData = ko.utils.domData.get(this.domElement, anonymousTemplatesDomDataKey) || {};\n            return templateData.containerData;\n        } else {\n            var valueToWrite = arguments[0];\n            ko.utils.domData.set(this.domElement, anonymousTemplatesDomDataKey, {containerData: valueToWrite});\n        }\n    };\n\n    ko.exportSymbol('templateSources', ko.templateSources);\n    ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n    ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n})();\n(function () {\n    var _templateEngine;\n    ko.setTemplateEngine = function (templateEngine) {\n        if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n            throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n        _templateEngine = templateEngine;\n    }\n\n    function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n        var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n        while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n            nextInQueue = ko.virtualElements.nextSibling(node);\n            action(node, nextInQueue);\n        }\n    }\n\n    function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n        // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n        // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n        // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n        // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n        // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n        if (continuousNodeArray.length) {\n            var firstNode = continuousNodeArray[0],\n                lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                parentNode = firstNode.parentNode,\n                provider = ko.bindingProvider['instance'],\n                preprocessNode = provider['preprocessNode'];\n\n            if (preprocessNode) {\n                invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                    var nodePreviousSibling = node.previousSibling;\n                    var newNodes = preprocessNode.call(provider, node);\n                    if (newNodes) {\n                        if (node === firstNode)\n                            firstNode = newNodes[0] || nextNodeInRange;\n                        if (node === lastNode)\n                            lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                    }\n                });\n\n                // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                // first node needs to be in the array).\n                continuousNodeArray.length = 0;\n                if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                    return;\n                }\n                if (firstNode === lastNode) {\n                    continuousNodeArray.push(firstNode);\n                } else {\n                    continuousNodeArray.push(firstNode, lastNode);\n                    ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                }\n            }\n\n            // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n            // whereas a regular applyBindings won't introduce new memoized nodes\n            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                if (node.nodeType === 1 || node.nodeType === 8)\n                    ko.applyBindings(bindingContext, node);\n            });\n            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                if (node.nodeType === 1 || node.nodeType === 8)\n                    ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n            });\n\n            // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n            ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n        }\n    }\n\n    function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n        return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                                        : null;\n    }\n\n    function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n        options = options || {};\n        var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n        var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n        var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n        ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n        var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n        // Loosely check result is an array of DOM nodes\n        if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n            throw new Error(\"Template engine must return an array of DOM nodes\");\n\n        var haveAddedNodesToParent = false;\n        switch (renderMode) {\n            case \"replaceChildren\":\n                ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                haveAddedNodesToParent = true;\n                break;\n            case \"replaceNode\":\n                ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                haveAddedNodesToParent = true;\n                break;\n            case \"ignoreTargetNode\": break;\n            default:\n                throw new Error(\"Unknown renderMode: \" + renderMode);\n        }\n\n        if (haveAddedNodesToParent) {\n            activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n            if (options['afterRender'])\n                ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext['$data']]);\n        }\n\n        return renderedNodesArray;\n    }\n\n    function resolveTemplateName(template, data, context) {\n        // The template can be specified as:\n        if (ko.isObservable(template)) {\n            // 1. An observable, with string value\n            return template();\n        } else if (typeof template === 'function') {\n            // 2. A function of (data, context) returning a string\n            return template(data, context);\n        } else {\n            // 3. A string\n            return template;\n        }\n    }\n\n    ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n        options = options || {};\n        if ((options['templateEngine'] || _templateEngine) == undefined)\n            throw new Error(\"Set a template engine before calling renderTemplate\");\n        renderMode = renderMode || \"replaceChildren\";\n\n        if (targetNodeOrNodeArray) {\n            var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n            var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n            var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n            return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                function () {\n                    // Ensure we've got a proper binding context to work with\n                    var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                        ? dataOrBindingContext\n                        : new ko.bindingContext(ko.utils.unwrapObservable(dataOrBindingContext));\n\n                    var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                        renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                    if (renderMode == \"replaceNode\") {\n                        targetNodeOrNodeArray = renderedNodesArray;\n                        firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    }\n                },\n                null,\n                { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n            );\n        } else {\n            // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n            return ko.memoization.memoize(function (domNode) {\n                ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n            });\n        }\n    };\n\n    ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n        // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n        // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n        var arrayItemContext;\n\n        // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n        var executeTemplateForArrayItem = function (arrayValue, index) {\n            // Support selecting template as a function of the data being rendered\n            arrayItemContext = parentBindingContext['createChildContext'](arrayValue, options['as'], function(context) {\n                context['$index'] = index;\n            });\n\n            var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n            return executeTemplate(null, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n        }\n\n        // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n        var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n            activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n            if (options['afterRender'])\n                options['afterRender'](addedNodesArray, arrayValue);\n\n            // release the \"cache\" variable, so that it can be collected by\n            // the GC when its value isn't used from within the bindings anymore.\n            arrayItemContext = null;\n        };\n\n        return ko.dependentObservable(function () {\n            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                unwrappedArray = [unwrappedArray];\n\n            // Filter out any entries marked as destroyed\n            var filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                return options['includeDestroyed'] || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n            });\n\n            // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n            // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n            ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, filteredArray, executeTemplateForArrayItem, options, activateBindingsCallback]);\n\n        }, null, { disposeWhenNodeIsRemoved: targetNode });\n    };\n\n    var templateComputedDomDataKey = ko.utils.domData.nextKey();\n    function disposeOldComputedAndStoreNewOne(element, newComputed) {\n        var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n        if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n            oldComputed.dispose();\n        ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && newComputed.isActive()) ? newComputed : undefined);\n    }\n\n    ko.bindingHandlers['template'] = {\n        'init': function(element, valueAccessor) {\n            // Support anonymous templates\n            var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n            if (typeof bindingValue == \"string\" || bindingValue['name']) {\n                // It's a named template - clear the element\n                ko.virtualElements.emptyNode(element);\n            } else if ('nodes' in bindingValue) {\n                // We've been given an array of DOM nodes. Save them as the template source.\n                // There is no known use case for the node array being an observable array (if the output\n                // varies, put that behavior *into* your template - that's what templates are for), and\n                // the implementation would be a mess, so assert that it's not observable.\n                var nodes = bindingValue['nodes'] || [];\n                if (ko.isObservable(nodes)) {\n                    throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                }\n                var container = ko.utils.moveCleanedNodesToContainerElement(nodes); // This also removes the nodes from their current parent\n                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n            } else {\n                // It's an anonymous template - store the element contents, then clear the element\n                var templateNodes = ko.virtualElements.childNodes(element),\n                    container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n            }\n            return { 'controlsDescendantBindings': true };\n        },\n        'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var value = valueAccessor(),\n                dataValue,\n                options = ko.utils.unwrapObservable(value),\n                shouldDisplay = true,\n                templateComputed = null,\n                templateName;\n\n            if (typeof options == \"string\") {\n                templateName = value;\n                options = {};\n            } else {\n                templateName = options['name'];\n\n                // Support \"if\"/\"ifnot\" conditions\n                if ('if' in options)\n                    shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                if (shouldDisplay && 'ifnot' in options)\n                    shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                dataValue = ko.utils.unwrapObservable(options['data']);\n            }\n\n            if ('foreach' in options) {\n                // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                var dataArray = (shouldDisplay && options['foreach']) || [];\n                templateComputed = ko.renderTemplateForEach(templateName || element, dataArray, options, element, bindingContext);\n            } else if (!shouldDisplay) {\n                ko.virtualElements.emptyNode(element);\n            } else {\n                // Render once for this single data point (or use the viewModel if no data was provided)\n                var innerBindingContext = ('data' in options) ?\n                    bindingContext['createChildContext'](dataValue, options['as']) :  // Given an explitit 'data' value, we create a child binding context for it\n                    bindingContext;                                                        // Given no explicit 'data' value, we retain the same binding context\n                templateComputed = ko.renderTemplate(templateName || element, innerBindingContext, options, element);\n            }\n\n            // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n            disposeOldComputedAndStoreNewOne(element, templateComputed);\n        }\n    };\n\n    // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n    ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n        var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n        if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n            return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n        if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n            return null; // Named templates can be rewritten, so return \"no error\"\n        return \"This template engine does not support anonymous templates nested within its templates\";\n    };\n\n    ko.virtualElements.allowedBindings['template'] = true;\n})();\n\nko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\nko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\nko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n    if (left.length && right.length) {\n        var failedCompares, l, r, leftItem, rightItem;\n        for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n            for (r = 0; rightItem = right[r]; ++r) {\n                if (leftItem['value'] === rightItem['value']) {\n                    leftItem['moved'] = rightItem['index'];\n                    rightItem['moved'] = leftItem['index'];\n                    right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                    failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                    break;\n                }\n            }\n            failedCompares += r;\n        }\n    }\n};\n\nko.utils.compareArrays = (function () {\n    var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n    // Simple calculation based on Levenshtein distance.\n    function compareArrays(oldArray, newArray, options) {\n        // For backward compatibility, if the third arg is actually a bool, interpret\n        // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n        options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n        oldArray = oldArray || [];\n        newArray = newArray || [];\n\n        if (oldArray.length <= newArray.length)\n            return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n        else\n            return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n    }\n\n    function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n        var myMin = Math.min,\n            myMax = Math.max,\n            editDistanceMatrix = [],\n            smlIndex, smlIndexMax = smlArray.length,\n            bigIndex, bigIndexMax = bigArray.length,\n            compareRange = (bigIndexMax - smlIndexMax) || 1,\n            maxDistance = smlIndexMax + bigIndexMax + 1,\n            thisRow, lastRow,\n            bigIndexMaxForRow, bigIndexMinForRow;\n\n        for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n            lastRow = thisRow;\n            editDistanceMatrix.push(thisRow = []);\n            bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n            bigIndexMinForRow = myMax(0, smlIndex - 1);\n            for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                if (!bigIndex)\n                    thisRow[bigIndex] = smlIndex + 1;\n                else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                    thisRow[bigIndex] = bigIndex + 1;\n                else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                    thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                else {\n                    var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                    var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                    thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                }\n            }\n        }\n\n        var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n        for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n            meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n            if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                notInSml.push(editScript[editScript.length] = {     // added\n                    'status': statusNotInSml,\n                    'value': bigArray[--bigIndex],\n                    'index': bigIndex });\n            } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                notInBig.push(editScript[editScript.length] = {     // deleted\n                    'status': statusNotInBig,\n                    'value': smlArray[--smlIndex],\n                    'index': smlIndex });\n            } else {\n                --bigIndex;\n                --smlIndex;\n                if (!options['sparse']) {\n                    editScript.push({\n                        'status': \"retained\",\n                        'value': bigArray[bigIndex] });\n                }\n            }\n        }\n\n        // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n        // smlIndexMax keeps the time complexity of this algorithm linear.\n        ko.utils.findMovesInArrayComparison(notInSml, notInBig, smlIndexMax * 10);\n\n        return editScript.reverse();\n    }\n\n    return compareArrays;\n})();\n\nko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n(function () {\n    // Objective:\n    // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n    //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n    // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n    //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n    //   previously mapped - retain those nodes, and just insert/delete other ones\n\n    // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n    // You can use this, for example, to activate bindings on those nodes.\n\n    function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n        // Map this array value inside a dependentObservable so we re-map when any dependency changes\n        var mappedNodes = [];\n        var dependentObservable = ko.dependentObservable(function() {\n            var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n            // On subsequent evaluations, just replace the previously-inserted DOM nodes\n            if (mappedNodes.length > 0) {\n                ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                if (callbackAfterAddingNodes)\n                    ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n            }\n\n            // Replace the contents of the mappedNodes array, thereby updating the record\n            // of which nodes would be deleted if valueToMap was itself later removed\n            mappedNodes.length = 0;\n            ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n        }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n        return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n    }\n\n    var lastMappingResultDomDataKey = ko.utils.domData.nextKey();\n\n    ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes) {\n        // Compare the provided array against the previous one\n        array = array || [];\n        options = options || {};\n        var isFirstExecution = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) === undefined;\n        var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) || [];\n        var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; });\n        var editScript = ko.utils.compareArrays(lastArray, array, options['dontLimitMoves']);\n\n        // Build the new mapping result\n        var newMappingResult = [];\n        var lastMappingResultIndex = 0;\n        var newMappingResultIndex = 0;\n\n        var nodesToDelete = [];\n        var itemsToProcess = [];\n        var itemsForBeforeRemoveCallbacks = [];\n        var itemsForMoveCallbacks = [];\n        var itemsForAfterAddCallbacks = [];\n        var mapData;\n\n        function itemMovedOrRetained(editScriptIndex, oldPosition) {\n            mapData = lastMappingResult[oldPosition];\n            if (newMappingResultIndex !== oldPosition)\n                itemsForMoveCallbacks[editScriptIndex] = mapData;\n            // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n            mapData.indexObservable(newMappingResultIndex++);\n            ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n            newMappingResult.push(mapData);\n            itemsToProcess.push(mapData);\n        }\n\n        function callCallback(callback, items) {\n            if (callback) {\n                for (var i = 0, n = items.length; i < n; i++) {\n                    if (items[i]) {\n                        ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                            callback(node, i, items[i].arrayEntry);\n                        });\n                    }\n                }\n            }\n        }\n\n        for (var i = 0, editScriptItem, movedIndex; editScriptItem = editScript[i]; i++) {\n            movedIndex = editScriptItem['moved'];\n            switch (editScriptItem['status']) {\n                case \"deleted\":\n                    if (movedIndex === undefined) {\n                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                        // Stop tracking changes to the mapping for these nodes\n                        if (mapData.dependentObservable)\n                            mapData.dependentObservable.dispose();\n\n                        // Queue these nodes for later removal\n                        nodesToDelete.push.apply(nodesToDelete, ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode));\n                        if (options['beforeRemove']) {\n                            itemsForBeforeRemoveCallbacks[i] = mapData;\n                            itemsToProcess.push(mapData);\n                        }\n                    }\n                    lastMappingResultIndex++;\n                    break;\n\n                case \"retained\":\n                    itemMovedOrRetained(i, lastMappingResultIndex++);\n                    break;\n\n                case \"added\":\n                    if (movedIndex !== undefined) {\n                        itemMovedOrRetained(i, movedIndex);\n                    } else {\n                        mapData = { arrayEntry: editScriptItem['value'], indexObservable: ko.observable(newMappingResultIndex++) };\n                        newMappingResult.push(mapData);\n                        itemsToProcess.push(mapData);\n                        if (!isFirstExecution)\n                            itemsForAfterAddCallbacks[i] = mapData;\n                    }\n                    break;\n            }\n        }\n\n        // Call beforeMove first before any changes have been made to the DOM\n        callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n        // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n        ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n        // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n        for (var i = 0, nextNode = ko.virtualElements.firstChild(domNode), lastNode, node; mapData = itemsToProcess[i]; i++) {\n            // Get nodes for newly added items\n            if (!mapData.mappedNodes)\n                ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n            // Put nodes in the right place if they aren't there already\n            for (var j = 0; node = mapData.mappedNodes[j]; nextNode = node.nextSibling, lastNode = node, j++) {\n                if (node !== nextNode)\n                    ko.virtualElements.insertAfter(domNode, node, lastNode);\n            }\n\n            // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n            if (!mapData.initialized && callbackAfterAddingNodes) {\n                callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                mapData.initialized = true;\n            }\n        }\n\n        // If there's a beforeRemove callback, call it after reordering.\n        // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n        // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n        // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n        // Perhaps we'll make that change in the future if this scenario becomes more common.\n        callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n        // Finally call afterMove and afterAdd callbacks\n        callCallback(options['afterMove'], itemsForMoveCallbacks);\n        callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n\n        // Store a copy of the array items we just considered so we can difference it next time\n        ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n    }\n})();\n\nko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\nko.nativeTemplateEngine = function () {\n    this['allowTemplateRewriting'] = false;\n}\n\nko.nativeTemplateEngine.prototype = new ko.templateEngine();\nko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\nko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n    var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n        templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n        templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n    if (templateNodes) {\n        return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n    } else {\n        var templateText = templateSource['text']();\n        return ko.utils.parseHtmlFragment(templateText, templateDocument);\n    }\n};\n\nko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\nko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\nko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n(function() {\n    ko.jqueryTmplTemplateEngine = function () {\n        // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n        // doesn't expose a version number, so we have to infer it.\n        // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n        // which KO internally refers to as version \"2\", so older versions are no longer detected.\n        var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n            if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                return 0;\n            // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n            try {\n                if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                    // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                    return 2; // Final version of jquery.tmpl\n                }\n            } catch(ex) { /* Apparently not the version we were looking for */ }\n\n            return 1; // Any older version that we don't support\n        })();\n\n        function ensureHasReferencedJQueryTemplates() {\n            if (jQueryTmplVersion < 2)\n                throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n        }\n\n        function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n            return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n        }\n\n        this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n            templateDocument = templateDocument || document;\n            options = options || {};\n            ensureHasReferencedJQueryTemplates();\n\n            // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n            var precompiled = templateSource['data']('precompiled');\n            if (!precompiled) {\n                var templateText = templateSource['text']() || \"\";\n                // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                precompiled = jQueryInstance['template'](null, templateText);\n                templateSource['data']('precompiled', precompiled);\n            }\n\n            var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n            var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n            var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n            resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n            jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n            return resultNodes;\n        };\n\n        this['createJavaScriptEvaluatorBlock'] = function(script) {\n            return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n        };\n\n        this['addTemplate'] = function(templateName, templateMarkup) {\n            document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n        };\n\n        if (jQueryTmplVersion > 0) {\n            jQueryInstance['tmpl']['tag']['ko_code'] = {\n                open: \"__.push($1 || '');\"\n            };\n            jQueryInstance['tmpl']['tag']['ko_with'] = {\n                open: \"with($1) {\",\n                close: \"} \"\n            };\n        }\n    };\n\n    ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n    ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n    // Use this one by default *only if jquery.tmpl is referenced*\n    var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n    if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n        ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n    ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n})();\n}));\n}());\n})();\n","mage/loader.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true */\n/*global console:true*/\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'mage/translate'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.loader', {\n        loaderStarted: 0,\n        options: {\n            icon: '',\n            texts: {\n                loaderText: $.mage.__('Please wait...'),\n                imgAlt: $.mage.__('Loading...')\n            },\n            template:\n                '<div class=\"loading-mask\" data-role=\"loader\">' +\n                    '<div class=\"loader\">' +\n                        '<img alt=\"<%- data.texts.imgAlt %>\" src=\"<%- data.icon %>\">' +\n                        '<p><%- data.texts.loaderText %></p>' +\n                    '</div>' +\n                '</div>'\n\n        },\n\n        /**\n         * Loader creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind on ajax events\n         * @protected\n         */\n        _bind: function () {\n            this._on({\n                'processStop': 'hide',\n                'processStart': 'show',\n                'show.loader': 'show',\n                'hide.loader': 'hide',\n                'contentUpdated.loader': '_contentUpdated'\n            });\n        },\n\n        /**\n         * Verify loader present after content updated\n         *\n         * This will be cleaned up by the task MAGETWO-11070\n         *\n         * @param {EventObject} e\n         * @private\n         */\n        _contentUpdated: function (e) {\n            this.show(e);\n        },\n\n        /**\n         * Show loader\n         */\n        show: function (e, ctx) {\n            this._render();\n            this.loaderStarted++;\n            this.spinner.show();\n\n            if (ctx) {\n                this.spinner\n                    .css({\n                        width: ctx.outerWidth(),\n                        height: ctx.outerHeight(),\n                        position: 'absolute'\n                    })\n                    .position({\n                        my: 'top left',\n                        at: 'top left',\n                        of: ctx\n                    });\n            }\n\n            return false;\n        },\n\n        /**\n         * Hide loader\n         */\n        hide: function () {\n            if (this.loaderStarted > 0) {\n                this.loaderStarted--;\n\n                if (this.loaderStarted === 0) {\n                    this.spinner.hide();\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Render loader\n         * @protected\n         */\n        _render: function () {\n            var html;\n\n            if (!this.spinnerTemplate) {\n                this.spinnerTemplate = mageTemplate(this.options.template);\n\n                html = $(this.spinnerTemplate({\n                    data: this.options\n                }));\n\n                html.prependTo(this.element);\n\n                this.spinner = html;\n            }\n        },\n\n        /**\n         * Destroy loader\n         */\n        _destroy: function () {\n            this.spinner.remove();\n        }\n    });\n\n    /**\n     * This widget takes care of registering the needed loader listeners on the body\n     */\n    $.widget('mage.loaderAjax', {\n        options: {\n            defaultContainer: '[data-container=body]',\n            loadingClass: 'ajax-loading'\n        },\n\n        _create: function () {\n            this._bind();\n            // There should only be one instance of this widget, and it should be attached\n            // to the body only. Having it on the page twice will trigger multiple processStarts.\n            if (window.console && !this.element.is(this.options.defaultContainer) && $.mage.isDevMode(undefined)) {\n                console.warn('This widget is intended to be attached to the body, not below.');\n            }\n        },\n\n        _bind: function () {\n            $(document).on({\n                'ajaxSend': this._onAjaxSend.bind(this),\n                'ajaxComplete': this._onAjaxComplete.bind(this)\n            });\n        },\n\n        _getJqueryObj: function (loaderContext) {\n            var ctx;\n            // Check to see if context is jQuery object or not.\n            if (loaderContext) {\n                if (loaderContext.jquery) {\n                    ctx = loaderContext;\n                } else {\n                    ctx = $(loaderContext);\n                }\n            } else {\n                ctx = $('[data-container=\"body\"]');\n            }\n\n            return ctx;\n        },\n\n        _onAjaxSend: function (e, jqxhr, settings) {\n            $(this.options.defaultContainer)\n                .addClass(this.options.loadingClass)\n                .attr({\n                    'aria-busy': true\n                })\n\n            if (settings && settings.showLoader) {\n                var ctx = this._getJqueryObj(settings.loaderContext);\n                ctx.trigger('processStart');\n\n                // Check to make sure the loader is there on the page if not report it on the console.\n                // NOTE that this check should be removed before going live. It is just an aid to help\n                // in finding the uses of the loader that maybe broken.\n                if (window.console && !ctx.parents('[data-role=\"loader\"]').length) {\n                    console.warn('Expected to start loader but did not find one in the dom');\n                }\n            }\n        },\n\n        _onAjaxComplete: function (e, jqxhr, settings) {\n            $(this.options.defaultContainer)\n                .removeClass(this.options.loadingClass)\n                .attr('aria-busy', false);\n\n            if (settings && settings.showLoader) {\n                this._getJqueryObj(settings.loaderContext).trigger('processStop');\n            }\n        }\n\n    });\n\n    return {\n        loader: $.mage.loader,\n        loaderAjax: $.mage.loaderAjax\n    };\n});\n","mage/menu.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    \"jquery\",\n    \"matchMedia\",\n    \"jquery/ui\",\n    \"jquery/jquery.mobile.custom\",\n    \"mage/translate\"\n], function ($, mediaCheck) {\n    'use strict';\n\n    /**\n     * Menu Widget - this widget is a wrapper for the jQuery UI Menu\n     */\n    $.widget('mage.menu', $.ui.menu, {\n        options: {\n            responsive: false,\n            expanded: false,\n            delay: 300\n        },\n        _create: function () {\n            var self = this;\n\n            this._super();\n            $(window).on('resize', function () {\n                self.element.find('.submenu-reverse').removeClass('submenu-reverse');\n            });\n        },\n\n        _init: function () {\n            this._super();\n            this.delay = this.options.delay;\n\n            if (this.options.expanded === true) {\n                this.isExpanded();\n            }\n\n            if (this.options.responsive === true) {\n                mediaCheck({\n                    media: '(max-width: 640px)',\n                    entry: $.proxy(function () {\n                        this._toggleMobileMode();\n                    }, this),\n                    exit: $.proxy(function () {\n                        this._toggleDesktopMode();\n                    }, this)\n                });\n            }\n\n            this._assignControls()._listen();\n        },\n\n        _assignControls: function () {\n            this.controls = {\n                toggleBtn: $('[data-action=\"toggle-nav\"]'),\n                swipeArea: $('.nav-sections')\n            };\n\n            return this;\n        },\n\n        _listen: function () {\n            var controls = this.controls;\n            var toggle = this.toggle;\n\n            this._on(controls.toggleBtn, {'click': toggle});\n            this._on(controls.swipeArea, {'swipeleft': toggle});\n        },\n\n        toggle: function () {\n            if ($('html').hasClass('nav-open')) {\n                $('html').removeClass('nav-open');\n                setTimeout(function () {\n                    $('html').removeClass('nav-before-open');\n                }, 300);\n            } else {\n                $('html').addClass('nav-before-open');\n                setTimeout(function () {\n                    $('html').addClass('nav-open');\n                }, 42);\n            }\n        },\n\n        //Add class for expanded option\n        isExpanded: function () {\n            var subMenus = this.element.find(this.options.menus),\n                expandedMenus = subMenus.find('ul');\n\n            expandedMenus.addClass('expanded');\n        },\n\n        _activate: function (event) {\n            window.location.href = this.active.find('> a').attr('href');\n            this.collapseAll(event);\n        },\n\n        _keydown: function (event) {\n\n            var match, prev, character, skip, regex,\n                preventDefault = true;\n\n            function escape(value) {\n                return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\");\n            }\n\n            if (this.active.closest('ul').attr('aria-expanded') != 'true') {\n\n                switch (event.keyCode) {\n                    case $.ui.keyCode.PAGE_UP:\n                        this.previousPage(event);\n                        break;\n                    case $.ui.keyCode.PAGE_DOWN:\n                        this.nextPage(event);\n                        break;\n                    case $.ui.keyCode.HOME:\n                        this._move(\"first\", \"first\", event);\n                        break;\n                    case $.ui.keyCode.END:\n                        this._move(\"last\", \"last\", event);\n                        break;\n                    case $.ui.keyCode.UP:\n                        this.previous(event);\n                        break;\n                    case $.ui.keyCode.DOWN:\n                        if (this.active && !this.active.is(\".ui-state-disabled\")) {\n                            this.expand(event);\n                        }\n                        break;\n                    case $.ui.keyCode.LEFT:\n                        this.previous(event);\n                        break;\n                    case $.ui.keyCode.RIGHT:\n                        this.next(event);\n                        break;\n                    case $.ui.keyCode.ENTER:\n                    case $.ui.keyCode.SPACE:\n                        this._activate(event);\n                        break;\n                    case $.ui.keyCode.ESCAPE:\n                        this.collapse(event);\n                        break;\n                    default:\n                        preventDefault = false;\n                        prev = this.previousFilter || \"\";\n                        character = String.fromCharCode(event.keyCode);\n                        skip = false;\n\n                        clearTimeout(this.filterTimer);\n\n                        if (character === prev) {\n                            skip = true;\n                        } else {\n                            character = prev + character;\n                        }\n\n                        regex = new RegExp(\"^\" + escape(character), \"i\");\n                        match = this.activeMenu.children(\".ui-menu-item\").filter(function () {\n                            return regex.test($(this).children(\"a\").text());\n                        });\n                        match = skip && match.index(this.active.next()) !== -1 ?\n                            this.active.nextAll(\".ui-menu-item\") :\n                            match;\n\n                        // If no matches on the current filter, reset to the last character pressed\n                        // to move down the menu to the first item that starts with that character\n                        if (!match.length) {\n                            character = String.fromCharCode(event.keyCode);\n                            regex = new RegExp(\"^\" + escape(character), \"i\");\n                            match = this.activeMenu.children(\".ui-menu-item\").filter(function () {\n                                return regex.test($(this).children(\"a\").text());\n                            });\n                        }\n\n                        if (match.length) {\n                            this.focus(event, match);\n                            if (match.length > 1) {\n                                this.previousFilter = character;\n                                this.filterTimer = this._delay(function () {\n                                    delete this.previousFilter;\n                                }, 1000);\n                            } else {\n                                delete this.previousFilter;\n                            }\n                        } else {\n                            delete this.previousFilter;\n                        }\n                }\n            } else {\n                switch (event.keyCode) {\n                    case $.ui.keyCode.DOWN:\n                        this.next(event);\n                        break;\n                    case $.ui.keyCode.UP:\n                        this.previous(event);\n                        break;\n                    case $.ui.keyCode.RIGHT:\n                        if (this.active && !this.active.is(\".ui-state-disabled\")) {\n                            this.expand(event);\n                        }\n                        break;\n                    case $.ui.keyCode.ENTER:\n                    case $.ui.keyCode.SPACE:\n                        this._activate(event);\n                        break;\n                    case $.ui.keyCode.LEFT:\n                    case $.ui.keyCode.ESCAPE:\n                        this.collapse(event);\n                        break;\n                    default:\n                        preventDefault = false;\n                        prev = this.previousFilter || \"\";\n                        character = String.fromCharCode(event.keyCode);\n                        skip = false;\n\n                        clearTimeout(this.filterTimer);\n\n                        if (character === prev) {\n                            skip = true;\n                        } else {\n                            character = prev + character;\n                        }\n\n                        regex = new RegExp(\"^\" + escape(character), \"i\");\n                        match = this.activeMenu.children(\".ui-menu-item\").filter(function () {\n                            return regex.test($(this).children(\"a\").text());\n                        });\n                        match = skip && match.index(this.active.next()) !== -1 ?\n                            this.active.nextAll(\".ui-menu-item\") :\n                            match;\n\n                        // If no matches on the current filter, reset to the last character pressed\n                        // to move down the menu to the first item that starts with that character\n                        if (!match.length) {\n                            character = String.fromCharCode(event.keyCode);\n                            regex = new RegExp(\"^\" + escape(character), \"i\");\n                            match = this.activeMenu.children(\".ui-menu-item\").filter(function () {\n                                return regex.test($(this).children(\"a\").text());\n                            });\n                        }\n\n                        if (match.length) {\n                            this.focus(event, match);\n                            if (match.length > 1) {\n                                this.previousFilter = character;\n                                this.filterTimer = this._delay(function () {\n                                    delete this.previousFilter;\n                                }, 1000);\n                            } else {\n                                delete this.previousFilter;\n                            }\n                        } else {\n                            delete this.previousFilter;\n                        }\n                }\n            }\n\n            if (preventDefault) {\n                event.preventDefault();\n            }\n        },\n\n        _toggleMobileMode: function () {\n            $(this.element).off('mouseenter mouseleave');\n            this._on({\n                \"click .ui-menu-item:has(a)\": function (event) {\n                    event.preventDefault();\n\n                    var target = $(event.target).closest(\".ui-menu-item\");\n\n                    if (!target.hasClass('level-top') || !target.has(\".ui-menu\").length) {\n                        window.location.href = target.find('> a').attr('href');\n                    }\n                }\n            });\n\n            var subMenus = this.element.find('.level-top');\n            $.each(subMenus, $.proxy(function (index, item) {\n                var category = $(item).find('> a span').not('.ui-menu-icon').text(),\n                    categoryUrl = $(item).find('> a').attr('href'),\n                    menu = $(item).find('> .ui-menu');\n\n                this.categoryLink = $('<a>')\n                    .attr('href', categoryUrl)\n                    .text($.mage.__('All ') + category);\n\n                this.categoryParent = $('<li>')\n                    .addClass('ui-menu-item all-category')\n                    .html(this.categoryLink);\n\n                if (menu.find('.all-category').length === 0) {\n                    menu.prepend(this.categoryParent);\n                }\n\n            }, this));\n        },\n\n        _toggleDesktopMode: function () {\n            this._on({\n                // Prevent focus from sticking to links inside menu after clicking\n                // them (focus should always stay on UL during navigation).\n                \"mousedown .ui-menu-item > a\": function (event) {\n                    event.preventDefault();\n                },\n                \"click .ui-state-disabled > a\": function (event) {\n                    event.preventDefault();\n                },\n                \"click .ui-menu-item:has(a)\": function (event) {\n                    var target = $(event.target).closest(\".ui-menu-item\");\n                    if (!this.mouseHandled && target.not(\".ui-state-disabled\").length) {\n                        this.select(event);\n\n                        // Only set the mouseHandled flag if the event will bubble, see #9469.\n                        if (!event.isPropagationStopped()) {\n                            this.mouseHandled = true;\n                        }\n\n                        // Open submenu on click\n                        if (target.has(\".ui-menu\").length) {\n                            this.expand(event);\n                        } else if (!this.element.is(\":focus\") && $(this.document[0].activeElement).closest(\".ui-menu\").length) {\n\n                            // Redirect focus to the menu\n                            this.element.trigger(\"focus\", [true]);\n\n                            // If the active item is on the top level, let it stay active.\n                            // Otherwise, blur the active item since it is no longer visible.\n                            if (this.active && this.active.parents(\".ui-menu\").length === 1) {\n                                clearTimeout(this.timer);\n                            }\n                        }\n                    }\n                },\n                \"mouseenter .ui-menu-item\": function (event) {\n                    var target = $(event.currentTarget),\n                        ulElement,\n                        ulElementWidth,\n                        width,\n                        targetPageX,\n                        rightBound;\n\n                    if (target.has('ul')) {\n                        ulElement = target.find('ul');\n                        ulElementWidth = target.find('ul').outerWidth(true);\n                        width = target.outerWidth() * 2;\n                        targetPageX = target.offset().left;\n                        rightBound = $(window).width();\n\n                        if ((ulElementWidth + width + targetPageX) > rightBound) {\n                            ulElement.addClass('submenu-reverse');\n                        }\n                        if ((targetPageX - ulElementWidth) < 0) {\n                            ulElement.removeClass('submenu-reverse');\n                        }\n                    }\n\n                    // Remove ui-state-active class from siblings of the newly focused menu item\n                    // to avoid a jump caused by adjacent elements both having a class with a border\n                    target.siblings().children(\".ui-state-active\").removeClass(\"ui-state-active\");\n                    this.focus(event, target);\n                },\n                \"mouseleave\": function (event) {\n                    this.collapseAll(event, true);\n                },\n                \"mouseleave .ui-menu\": \"collapseAll\"\n            });\n\n            var categoryParent = this.element.find('.all-category'),\n                html = $('html');\n\n            categoryParent.remove();\n\n            if (html.hasClass('nav-open')) {\n                html.removeClass('nav-open');\n                setTimeout(function () {\n                    html.removeClass('nav-before-open');\n                }, 300);\n            }\n        },\n        _delay: function(handler, delay) {\n            var instance = this,\n                handlerProxy = function () {\n                return (typeof handler === \"string\" ? instance[handler] : handler)\n                    .apply(instance, arguments);\n            };\n            \n            return setTimeout(handlerProxy, delay || 0);\n        }\n    });\n\n\n    $.widget('mage.navigation', $.mage.menu, {\n\n        options: {\n            responsiveAction: 'wrap', //option for responsive handling\n            maxItems: null, //option to set max number of menu items\n            container: '#menu', //container to check against navigation length\n            moreText: $.mage.__('more'),\n            breakpoint: 768\n        },\n\n        _init: function () {\n            this._super();\n\n            var that = this,\n                moreMenu = $('[responsive=more]'),\n                responsive = this.options.responsiveAction;\n\n            this.element\n                .addClass('ui-menu-responsive')\n                .attr('responsive', 'main');\n\n            this.setupMoreMenu();\n            this.setMaxItems();\n\n            //check responsive option\n            if (responsive == \"onResize\") {\n                $(window).on('resize', function () {\n                    if ($(window).width() > that.options.breakpoint) {\n                        that._responsive();\n                        $('[responsive=more]').show();\n                    } else {\n                        that.element.children().show();\n                        $('[responsive=more]').hide();\n                    }\n                });\n            } else if (responsive == \"onReload\") {\n                this._responsive();\n            }\n        },\n\n        setupMoreMenu: function () {\n            var moreListItems = this.element.children().clone(),\n                moreLink = $('<a>' + this.options.moreText + '</a>');\n\n            moreListItems.hide();\n\n            moreLink.attr('href', '#');\n\n            this.moreItemsList = $('<ul>')\n                .append(moreListItems);\n\n            this.moreListContainer = $('<li>')\n                .append(moreLink)\n                .append(this.moreItemsList);\n\n            this.responsiveMenu = $('<ul>')\n                .addClass('ui-menu-more')\n                .attr('responsive', 'more')\n                .append(this.moreListContainer)\n                .menu({\n                    position: {\n                        my: \"right top\",\n                        at: \"right bottom\"\n                    }\n                })\n                .insertAfter(this.element);\n        },\n\n        _responsive: function () {\n            var container = $(this.options.container),\n                containerSize = container.width(),\n                width = 0,\n                items = this.element.children('li'),\n                more = $('.ui-menu-more > li > ul > li a');\n\n\n            items = items.map(function () {\n                var item = {};\n\n                item.item = $(this);\n                item.itemSize = $(this).outerWidth();\n                return item;\n            });\n\n            $.each(items, function (index, item) {\n                var itemText = items[index].item\n                    .find('a:first')\n                    .text();\n\n                width += parseInt(items[index].itemSize, null);\n\n                if (width < containerSize) {\n                    items[index].item.show();\n\n                    more.each(function () {\n                        var text = $(this).text();\n                        if (text === itemText) {\n                            $(this).parent().hide();\n                        }\n                    });\n                } else if (width > containerSize) {\n                    items[index].item.hide();\n\n                    more.each(function () {\n                        var text = $(this).text();\n                        if (text === itemText) {\n                            $(this).parent().show();\n                        }\n                    });\n                }\n            });\n        },\n\n        setMaxItems: function () {\n            var items = this.element.children('li'),\n                itemsCount = items.length,\n                maxItems = this.options.maxItems,\n                overflow = itemsCount - maxItems,\n                overflowItems = items.slice(overflow);\n\n            overflowItems.hide();\n\n            overflowItems.each(function () {\n                var itemText = $(this).find('a:first').text();\n\n                $(this).hide();\n\n                $('.ui-menu-more > li > ul > li a').each(function () {\n                    var text = $(this).text();\n                    if (text === itemText) {\n                        $(this).parent().show();\n                    }\n                });\n            });\n        }\n    });\n\n    return {\n        menu: $.mage.menu,\n        navigation: $.mage.navigation\n    };\n});\n","mage/popup-window.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.popupWindow', {\n        options: {\n            centerBrowser: 0, // center window over browser window? {1 (YES) or 0 (NO)}. overrides top and left\n            centerScreen: 0, // center window over entire screen? {1 (YES) or 0 (NO)}. overrides top and left\n            height: 500, // sets the height in pixels of the window.\n            left: 0, // left position when the window appears.\n            location: 0, // determines whether the address bar is displayed {1 (YES) or 0 (NO)}.\n            menubar: 0, // determines whether the menu bar is displayed {1 (YES) or 0 (NO)}.\n            resizable: 0, // whether the window can be resized {1 (YES) or 0 (NO)}. Can also be overloaded using resizable.\n            scrollbars: 0, // determines whether scrollbars appear on the window {1 (YES) or 0 (NO)}.\n            status: 0, // whether a status line appears at the bottom of the window {1 (YES) or 0 (NO)}.\n            width: 500, // sets the width in pixels of the window.\n            windowName: null, // name of window set from the name attribute of the element that invokes the click\n            windowURL: null, // url used for the popup\n            top: 0, // top position when the window appears.\n            toolbar: 0 // determines whether a toolbar (includes the forward and back buttons) is displayed {1 (YES) or 0 (NO)}.\n        },\n\n        _create: function() {\n            this.element.on('click', $.proxy(this._openPopupWindow, this));\n        },\n\n        _openPopupWindow: function(event) {\n            var element = $(event.target),\n                settings = this.options,\n                windowFeatures =\n                    'height=' + settings.height +\n                        ',width=' + settings.width +\n                        ',toolbar=' + settings.toolbar +\n                        ',scrollbars=' + settings.scrollbars +\n                        ',status=' + settings.status +\n                        ',resizable=' + settings.resizable +\n                        ',location=' + settings.location +\n                        ',menuBar=' + settings.menubar,\n                centeredX,\n                centeredY;\n\n            settings.windowName = settings.windowName || element.attr('name');\n            settings.windowURL = settings.windowURL || element.attr('href');\n\n            if (settings.centerBrowser) {\n                if ($.browser.msie) { // Hacked together for IE browsers\n                    centeredY = (window.screenTop - 120) + ((((document.documentElement.clientHeight + 120) / 2) - (settings.height / 2)));\n                    centeredX = window.screenLeft + ((((document.body.offsetWidth + 20) / 2) - (settings.width / 2)));\n                } else {\n                    centeredY = window.screenY + (((window.outerHeight / 2) - (settings.height / 2)));\n                    centeredX = window.screenX + (((window.outerWidth / 2) - (settings.width / 2)));\n                }\n                windowFeatures += ',left=' + centeredX +',top=' + centeredY;\n            } else if (settings.centerScreen) {\n                centeredY = (screen.height - settings.height) / 2;\n                centeredX = (screen.width - settings.width) / 2;\n                windowFeatures += ',left=' + centeredX +',top=' + centeredY;\n            } else {\n                windowFeatures += ',left=' + settings.left +',top=' + settings.top;\n            }\n\n            window.open(settings.windowURL, settings.windowName, windowFeatures).focus();\n            event.preventDefault();\n        }\n    });\n    \n    return $.mage.popupWindow;\n});\n","mage/smart-keyboard-handler.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n],function($){\n    'use strict';\n\n    function KeyboardHandler() {\n        var body = $('body'),\n            focusState = false,\n            tabFocusClass = '_keyfocus',\n            productsGrid = '[data-container=\"product-grid\"]',\n            catalogProductsGrid = $(productsGrid),\n            CODE_TAB = 9;\n\n        return {\n            apply: smartKeyboardFocus\n        };\n\n        /**\n         * Tab key onKeypress handler. Apply main logic:\n         *  - call differ actions onTabKeyPress and onClick\n         */\n        function smartKeyboardFocus() {\n            $(document).on('keydown keypress', function(event) {\n                if (event.which === CODE_TAB && !focusState) {\n                    body\n                        .on('focusin.keyboardHandler', onFocusInHandler)\n                        .on('click', onClickHandler);\n                }\n            });\n\n            // ARIA support for catalog grid products\n            if (catalogProductsGrid.length) {\n                body.on('focusin.gridProducts', productsGrid, function() {\n                    if (body.hasClass(tabFocusClass)) {\n                        $(this).addClass('active');\n                    }\n                });\n                body.on('focusout.gridProducts', productsGrid, function() {\n                    $(this).removeClass('active');\n                });\n            }\n        }\n\n        /**\n         * Handle logic, when onTabKeyPress fired at first.\n         * Then it changes state.\n         */\n        function onFocusInHandler () {\n            focusState = true;\n            $('body').addClass(tabFocusClass)\n                .off('focusin.keyboardHandler', onFocusInHandler);\n        }\n\n        /**\n         * Handle logic to remove state after onTabKeyPress to normal.\n         * @param {Event} event\n         */\n        function onClickHandler(event) {\n            focusState  = false;\n            $('body').removeClass(tabFocusClass)\n                .off('click', onClickHandler);\n        }\n    }\n\n    return new KeyboardHandler;\n});","mage/sticky.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.sticky', {\n        options: {\n            container: ''\n        },\n\n        /**\n         * Bind handlers to scroll event\n         * @private\n         */\n        _create: function() {\n            $(window).on({\n                'scroll': $.proxy(this._stick, this),\n                'resize': $.proxy(this.reset, this)\n            });\n\n            this.element.on('dimensionsChanged', $.proxy(this.reset, this));\n\n            this.reset();\n        },\n\n        /**\n         * float Block on windowScroll\n         * @private\n         */\n        _stick: function() {\n            var offset,\n                isStatic;\n\n            isStatic = this.element.css('position') === 'static';\n\n            if( !isStatic && this.element.is(':visible') ) {\n                offset = $(document).scrollTop() - this.parentOffset;\n\n                offset = Math.max( 0, Math.min( offset, this.maxOffset) );\n                \n                this.element.css( 'top', offset );\n            }\n        },\n\n        /**\n         * Defines maximum offset value of the element. \n         * @private\n         */\n        _calculateDimens: function(){\n            var $parent         = this.element.parent(),\n                topMargin       = parseInt( this.element.css(\"margin-top\"), 10 ),\n                parentHeight    = $parent.height() - topMargin,\n                height          = this.element.innerHeight(),\n                maxScroll       = document.body.offsetHeight - window.innerHeight;\n\n            if(this.options.container.length > 0) {\n               maxScroll = $(this.options.container).height();\n            }\n\n            this.parentOffset   = $parent.offset().top + topMargin;\n            this.maxOffset      = maxScroll - this.parentOffset;\n\n            if( this.maxOffset + height >= parentHeight ){\n                this.maxOffset = parentHeight - height;\n            }\n\n            return this;\n        },\n\n        /**\n         * Facade method that palces sticky element where it should be.\n         */\n        reset: function(){\n            this._calculateDimens()\n                ._stick();\n        }\n    });\n    \n    return $.mage.sticky;\n});\n","mage/storage.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(['jquery', 'mage/url'], function ($, urlBuilder) {\n    'use strict';\n\n    return {\n        /**\n         * Perform asynchronous GET request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        get: function (url, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'GET',\n                global: global,\n                contentType: contentType\n            });\n        },\n        /**\n         * Perform asynchronous POST request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        post: function (url, data, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'POST',\n                data: data,\n                global: global,\n                contentType: contentType\n            });\n        },\n        /**\n         * Perform asynchronous PUT request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        put: function(url, data, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'PUT',\n                data: data,\n                global: global,\n                contentType: contentType\n            });\n        },\n        /**\n         * Perform asynchronous DELETE request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        delete: function(url, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'DELETE',\n                global: global,\n                contentType: contentType\n            });\n        }\n    };\n});\n","mage/tabs.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"mage/mage\",\n    \"mage/collapsible\"\n], function($){\n    \"use strict\";\n        \n    $.widget(\"mage.tabs\", {\n        options: {\n            active: 0,\n            disabled: [],\n            openOnFocus: true,\n            collapsible: false,\n            collapsibleElement: \"[data-role=collapsible]\",\n            header: \"[data-role=title]\",\n            content: \"[data-role=content]\",\n            trigger: \"[data-role=trigger]\",\n            closedState: null,\n            openedState: null,\n            disabledState: null,\n            ajaxUrlElement: \"[data-ajax=true]\",\n            ajaxContent: false,\n            loadingClass: null,\n            saveState: false,\n            animate: false,\n            icons: {\n                activeHeader: null,\n                header: null\n            }\n        },\n\n        _create : function () {\n            if((typeof this.options.disabled) === \"string\") {\n                this.options.disabled = this.options.disabled.split(\" \").map(function(item) {\n                    return parseInt(item, 10);\n                });\n            }\n            this._processPanels();\n\n            this._handleDeepLinking();\n\n            this._processTabIndex();\n\n            this._closeOthers();\n\n            this._bind();\n        },\n\n        _destroy: function() {\n            $.each(this.collapsibles, function() {\n                $(this).collapsible(\"destroy\");\n            });\n        },\n\n        /**\n         * If deep linking is used, all sections must be closed but the one that contains the anchor.\n         * @private\n         */\n        _handleDeepLinking: function() {\n            var self = this,\n                anchor = window.location.hash,\n                isValid = $.mage.isValidSelector(anchor),\n                anchorId = anchor.replace(\"#\",\"\");\n\n            if (anchor && isValid) {\n                $.each(self.contents,function(i) {\n                    if($(this).attr(\"id\") === anchorId) {\n                        self.collapsibles.not(self.collapsibles.eq(i)).collapsible(\"forceDeactivate\");\n                        return false;\n                    }\n                });\n            }\n        },\n\n        /**\n         * When the widget gets instantiated, the first tab that is not disabled receive focusable property\n         * Updated: for accessibility all tabs receive tabIndex 0\n         * @private\n         */\n        _processTabIndex: function() {\n            var self = this;\n            self.triggers.attr(\"tabIndex\",0);\n            $.each(this.collapsibles, function(i) {\n                if(!$(this).collapsible(\"option\",\"disabled\")) {\n                    self.triggers.eq(i).attr(\"tabIndex\", 0);\n                    return false;\n                }\n            });\n            $.each(this.collapsibles, function(i) {\n                $(this).on(\"beforeOpen\", function () {\n                    self.triggers.attr(\"tabIndex\",0);\n                    self.triggers.eq(i).attr(\"tabIndex\",0);\n\n                });\n            });\n        },\n\n        /**\n         * Prepare the elements for instantiating the collapsible widget\n         * @private\n         */\n        _processPanels: function() {\n            this.contents = this.element.find(this.options.content);\n\n            this.collapsibles = this.element.find(this.options.collapsibleElement);\n\n            this.collapsibles\n                .attr('role', 'presentation')\n                .parent()\n                .attr('role', 'tablist');\n\n            this.headers = this.element.find(this.options.header);\n            if (this.headers.length === 0) {\n                this.headers = this.collapsibles;\n            }\n            this.triggers = this.element.find(this.options.trigger);\n            if (this.triggers.length === 0) {\n                this.triggers = this.headers;\n            }\n            this._callCollapsible();\n        },\n\n        /**\n         * Setting the disabled and active tabs and calling instantiation of collapsible\n         * @private\n         */\n        _callCollapsible: function() {\n            var self = this,\n                disabled = false,\n                active = false;\n\n            $.each(this.collapsibles, function(i) {\n                disabled = active = false;\n                if($.inArray(i,self.options.disabled) !== -1) {\n                    disabled = true;\n                }\n                if(i === self.options.active) {\n                    active = true;\n                }\n                self._instantiateCollapsible(this,i,active,disabled);\n            });\n        },\n\n        /**\n         * Instantiate collapsible\n         * @param element\n         * @param index\n         * @param active\n         * @param disabled\n         * @private\n         */\n        _instantiateCollapsible: function(element,index,active,disabled) {\n            $(element).collapsible(\n                $.extend({}, this.options, {\n                    active: active,\n                    disabled: disabled,\n                    header: this.headers.eq(index),\n                    content: this.contents.eq(index),\n                    trigger: this.triggers.eq(index)}\n                ));\n        },\n\n        /**\n         * Adding callback to close others tabs when one gets opened\n         * @private\n         */\n        _closeOthers: function() {\n            var self = this;\n            $.each(this.collapsibles, function() {\n                $(this).on(\"beforeOpen\", function () {\n                    self.collapsibles.not(this).collapsible(\"forceDeactivate\");\n                });\n            });\n        },\n\n        activate: function(index) {\n            this._toggleActivate(\"activate\",index);\n        },\n\n        deactivate: function(index) {\n            this._toggleActivate(\"deactivate\",index);\n        },\n\n        _toggleActivate: function(action,index) {\n            this.collapsibles.eq(index).collapsible(action);\n        },\n\n        disable: function(index) {\n            this._toggleEnable(\"disable\",index);\n        },\n\n        enable: function(index) {\n            this._toggleEnable(\"enable\",index);\n        },\n\n        _toggleEnable: function(action,index) {\n            if($.isArray( index )) {\n                var self = this;\n                $.each(index, function() {\n                    self.collapsibles.eq(this).collapsible(action);\n                });\n            } else if(index === undefined) {\n                this.collapsibles.collapsible(action);\n            } else {\n                this.collapsibles.eq(index).collapsible(action);\n            }\n        },\n\n        _keydown: function( event ) {\n            if ( event.altKey || event.ctrlKey ) {\n                return;\n            }\n            var keyCode = $.ui.keyCode,\n                toFocus = false,\n                toFocusIndex,\n                enabledTriggers = [],\n                length,\n                currentIndex,\n                self = this;\n\n            $.each(this.triggers, function() {\n                if(!self.collapsibles.eq(self.triggers.index($(this))).collapsible(\"option\",\"disabled\")) {\n                    enabledTriggers.push(this);\n                }\n            });\n            length = $(enabledTriggers).length;\n            currentIndex = $(enabledTriggers).index(event.target);\n            var nextToFocus = function(direction) {\n                if(length > 0) {\n                    if(direction === \"right\") {\n                        toFocusIndex = (currentIndex + 1) % length;\n                    } else {\n                        toFocusIndex = (currentIndex + length - 1) % length;\n                    }\n                    return enabledTriggers[toFocusIndex];\n                }\n                else return event.target;\n            };\n\n            switch ( event.keyCode ) {\n                case keyCode.RIGHT:\n                case keyCode.DOWN:\n                    toFocus = nextToFocus(\"right\");\n                    break;\n                case keyCode.LEFT:\n                case keyCode.UP:\n                    toFocus = nextToFocus(\"left\");\n                    break;\n                case keyCode.HOME:\n                    toFocus = enabledTriggers[0];\n                    break;\n                case keyCode.END:\n                    toFocus = enabledTriggers[length - 1];\n                    break;\n            }\n\n            if ( toFocus ) {\n                toFocusIndex = this.triggers.index(toFocus);\n                $( event.target ).attr( \"tabIndex\", -1 );\n                $( toFocus ).attr( \"tabIndex\", 0 );\n                toFocus.focus();\n                if(this.options.openOnFocus) {\n                    this.activate(toFocusIndex);\n                }\n                event.preventDefault();\n            }\n        },\n\n        _bind: function () {\n            var events = {\n                keydown: \"_keydown\"\n            };\n            this._off(this.triggers);\n            this._on(this.triggers, events);\n        }\n    });\n\n    return $.mage.tabs;\n});\n","mage/template.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'underscore'\n        ], factory);\n    } else {\n        root.mageTemplate = factory(root._);\n    }\n}(this, function (_) {\n    'use strict';\n\n    /**\n     * Checks if provided string is a valid DOM selector.\n     *\n     * @param {String} selector - Selector to be checked.\n     * @returns {Boolean}\n     */\n    function isSelector(selector) {\n        try {\n            document.querySelector(selector);\n\n            return true;\n        } catch (e) {\n            return false;\n        }\n    }\n\n    /**\n     * Unescapes characters used in underscore templates.\n     *\n     * @param {String} str - String to be processed.\n     * @returns {String}\n     */\n    function unescape(str) {\n        return str.replace(/&lt;%|%3C%/g, '<%').replace(/%&gt;|%%3E/g, '%>');\n    }\n\n    /**\n     * If 'tmpl' is a valid selector, returns target node's innerHTML if found.\n     * Else, returns empty string and emits console warning.\n     * If 'tmpl' is not a selector, returns 'tmpl' as is.\n     *\n     * @param {String} tmpl\n     * @returns {String}\n     */\n    function getTmplString(tmpl) {\n        if (isSelector(tmpl)) {\n            tmpl = document.querySelector(tmpl);\n\n            if (tmpl) {\n                tmpl = tmpl.innerHTML.trim();\n            } else {\n                console.warn('No template was found by selector: ' + tmpl);\n\n                tmpl = '';\n            }\n        }\n\n        return unescape(tmpl);\n    }\n\n    /**\n     * Compiles or renders template provided either\n     * by selector or by the template string.\n     *\n     * @param {String} tmpl - Template string or selector.\n     * @param {(Object|Array|Function)} [data] - Data object with which to render template.\n     * @returns {String|Function}\n     */\n    return function (tmpl, data) {\n        var render;\n\n        tmpl   = getTmplString(tmpl);\n        render = _.template(tmpl);\n\n        return !_.isUndefined(data) ?\n            render(data) :\n            render;\n    };\n}));\n","mage/terms.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    \"jquery\"\n], function($){\n\n    'use strict';\n\n    $.fn.terms = function(args){\n\n        // default\n        var defaults = {\n            start:0,\n            wrapper:'',\n            showAnchor:'',\n            effects:'slide'\n        };\n\n        var options = $.extend(defaults, args);\n\n        this.each(function() {\n            var obj = $(this),\n                wrapper = (options.wrapper !== '') ? '> ' + options.wrapper : '',\n                switches = $(wrapper + '> [data-section=\"title\"] > [data-toggle=\"switch\"]',obj),\n                terms = $(wrapper + '> [data-section=\"content\"]',obj),\n                t = switches.length,\n                marginTop = $(switches[0]).closest('[data-section=\"title\"]').css('position') == 'absolute' ? 0 : null,\n                title,\n                current,\n\n                init = function() {\n                    if (t > 0) {\n                        if($(switches[0]).closest('[data-section=\"title\"]').css('display')=='table-cell') {\n                            obj.addClass('adjusted');\n                            var linksList;\n                            if (obj[0].tagName=='DL') {\n                                linksList = $('<dd>');\n                            } else {\n                                linksList = $('<div>');\n                            }\n                            linksList.addClass('sections-nav');\n                            obj.prepend(linksList);\n\n                            for (var i=0; i < t; i++) {\n                                title = $(switches[i]).html();\n                                var classes = $(switches[i]).closest('[data-section=\"title\"]').attr('class');\n                                var dataSection = $(switches[i]).closest('[data-section=\"title\"]').attr('data-section');\n                                var itemHref = $(switches[i]).attr('href');\n                                var itemClass = $(switches[i]).attr('class');\n                                $(switches[i]).parent('[data-section=\"title\"]').hide();\n                                switches[i] = $('<a/>',{\n                                    href: itemHref,\n                                    'class' : itemClass,\n                                    html: title\n                                }).appendTo(linksList);\n                                $(switches[i]).wrap('<strong class=\"'+classes+'\" data-section=\"'+dataSection+'\" />');\n                            }\n                        }\n                        $(switches).each(function(ind,el){\n                            $(el).click(function(event){\n                                event.preventDefault();\n                                showItem(ind);\n                            });\n                            if (marginTop !== null) {\n                                $(el).closest('[data-section=\"title\"]').css({'top' : marginTop + 'px'});\n                                marginTop = marginTop + $(el).closest('[data-section=\"title\"]').outerHeight(true);\n                                obj.css({'min-height' : marginTop + 'px' });\n                            }\n                        });\n\n                        var fromUrl = false;\n                        if (window.location.hash.length > 0) {\n                            $(terms).each(function(ind,el) {\n                                if ( '#info-'+$(el).attr('id') == window.location.hash) {\n                                    showItem(ind);\n                                    $('html, body').animate({\n                                        scrollTop: $(switches[ind]).offset().top\n                                    }, 700);\n                                    fromUrl = true;\n                                }\n                            });\n                        }\n                        if (fromUrl === false) {\n                            if ( options.start % 1 === 0 ) {\n                                current = options.start + 1;\n                                showItem(options.start);\n                            } else {\n                                $(terms).each(function(ind,el) {\n                                    if ( $(el).attr('id') == options.start) {\n                                        current = ind + 1;\n                                        showItem(ind);\n                                        $('html, body').animate({\n                                            scrollTop: $(switches[ind]).offset().top\n                                        }, 700);\n                                    }\n                                });\n                            }\n                        }\n                    }\n                },\n\n\n                showItem = function(item) {\n                    if (item != current && !$(switches[item]).closest('[data-section=\"title\"]').hasClass('disabled') ) {\n                        $(switches).closest('[data-section=\"title\"]').removeClass('active');\n                        if (options.wrapper !== '') {\n                            $(switches).parent().parent().removeClass('active');\n                        }\n                        $(terms).removeClass('active');\n                        $(switches[item]).closest('[data-section=\"title\"]').addClass('active');\n                        if (options.wrapper !== '') {\n                            $(switches[current]).parent().parent().addClass('active');\n                        }\n                        $(terms[item]).addClass('active');\n\n                        /*if ($(terms[item]).attr('id')) {\n                         scr = document.body.scrollTop;\n                         window.location.hash='#tab-' + $(terms[item]).attr('id');\n                         document.body.scrollTop = scr;\n                         }*/\n                        current = item;\n                    } else if (\n                    // Check if this is accordion width as criteria for now\n                        (obj.attr('data-sections') == 'accordion' ||\n                            $(switches[item]).closest('[data-section=\"title\"]').css('width') == obj.css('width')\n                            ) &&\n                            item == current && !$(switches[item]).closest('[data-section=\"title\"]').hasClass('disabled')\n                        ) {\n                        $(switches).closest('[data-section=\"title\"]').removeClass('active');\n                        if (options.wrapper !== '') {\n                            $(switches).parent().parent().removeClass('active');\n                        }\n                        $(terms).removeClass('active');\n                        current = -1;\n                    }\n                };\n\n            init();\n        });\n    };\n\n    return function(data, el){\n        $(el).terms(data);\n    };\n});\n","mage/toggle.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget(\"mage.toggleAdvanced\", {\n\n        options: {\n            baseToggleClass: \"active\"      // Class used to be toggled on clicked element\n        },\n\n        /**\n         * Toggle creation\n         * @private\n         */\n        _create: function() {\n            this.beforeCreate();\n            this._bindCore();\n            this.afterCreate();\n        },\n\n        /**\n         *  Core bound events & setup\n         * @protected\n         */\n        _bindCore: function() {\n            var widget = this;\n            this.element.on('click', $.proxy(function(e) {\n                widget._onClick();\n                e.preventDefault();\n            }, this));\n        },\n\n        /**\n         * Binding Click event\n         *\n         * @protected\n         */\n        _onClick: function() {\n            this._prepareOptions();\n            this._toggleSelectors();\n        },\n\n        /**\n         * Method used to look for data attributes to override default options\n         *\n         * @protected\n         */\n        _prepareOptions: function() {\n            this.options.baseToggleClass = (this.element.data('base-toggle-class')) ?\n                this.element.data('base-toggle-class') :this.options.baseToggleClass;\n        },\n\n        /**\n         * Method responsible for hiding and revealing specified DOM elements\n         * Toggle the class on clicked element\n         *\n         * @protected\n         */\n        _toggleSelectors: function () {\n            this.element.toggleClass(this.options.baseToggleClass);\n        },\n\n        /**\n         * Method used to inject 3rd party functionality before create\n         * @public\n         */\n        beforeCreate: function() {},\n\n        /**\n         * Method used to inject 3rd party functionality after create\n         * @public\n         */\n        afterCreate: function() {}\n    });\n\n    // Extension for mage.toggle - Adding selectors support for other DOM elements we wish to toggle\n    $.widget('mage.toggleAdvanced', $.mage.toggleAdvanced, {\n\n        options: {\n            selectorsToggleClass: \"hidden\",    // Class used to be toggled on selectors DOM elements\n            toggleContainers: null\n        },\n\n        /**\n         * Method responsible for hiding and revealing specified DOM elements\n         * If data-toggle-selectors attribute is present - toggle will be done on these selectors\n         * Otherwise we toggle the class on clicked element\n         *\n         * @protected\n         * @override\n         */\n        _toggleSelectors: function () {\n            this._super();\n            if (this.options.toggleContainers) {\n                $(this.options.toggleContainers).toggleClass(this.options.selectorsToggleClass);\n            } else {\n                this.element.toggleClass(this.options.baseToggleClass);\n            }\n        },\n\n        /**\n         * Method used to look for data attributes to override default options\n         *\n         * @protected\n         * @override\n         */\n        _prepareOptions: function() {\n            this.options.selectorsToggleClass = (this.element.data('selectors-toggle-class')) ?\n                this.element.data('selectors-toggle-class') :this.options.selectorsToggleClass;\n            this.options.toggleContainers = (this.element.data('toggle-selectors')) ?\n                this.element.data('toggle-selectors') :this.options.toggleContainers;\n            this._super();\n        }\n    });\n\n    // Extension for mage.toggle - Adding label toggle\n    $.widget('mage.toggleAdvanced', $.mage.toggleAdvanced, {\n\n        options: {\n            newLabel: null,             // Text of the new label to be used on toggle\n            curLabel: null,             // Text of the old label to be used on toggle\n            currentLabelElement: null   // Current label container\n        },\n\n        /**\n         * Binding Click event\n         *\n         * @protected\n         * @override\n         */\n        _onClick: function() {\n            this._super();\n            this._toggleLabel();\n        },\n\n        /**\n         * Method responsible for replacing clicked element labels\n         * @protected\n         */\n        _toggleLabel: function() {\n            if (this.options.newLabel) {\n                var cachedLabel = this.options.newLabel,\n                    currentLabelSelector = (this.options.currentLabelElement) ?\n                        $(this.options.currentLabelElement) : this.element;\n\n                this.element.data('toggle-label', this.options.curLabel);\n                currentLabelSelector.html(this.options.newLabel);\n\n                this.options.curLabel = this.options.newLabel;\n                this.options.newLabel = cachedLabel;\n            }\n        },\n\n        /**\n         * Method used to look for data attributes to override default options\n         *\n         * @protected\n         * @override\n         */\n        _prepareOptions: function() {\n            this.options.newLabel = (this.element.data('toggle-label')) ?\n                this.element.data('toggle-label') : this.options.newLabel;\n\n            this.options.currentLabelElement = (this.element.data('current-label-el')) ?\n                this.element.data('current-label-el') : this.options.currentLabelElement;\n\n            if(!this.options.currentLabelElement) {\n                this.options.currentLabelElement = this.element;\n            }\n\n            this.options.curLabel = $(this.options.currentLabelElement).html();\n\n            this._super();\n        }\n    });\n    \n    return $.mage.toggleAdvanced;\n});\n","mage/translate-inline.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"mage/template\",\n            \"jquery/ui\",\n            \"mage/translate\"\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    'use strict';\n\n    $.widget(\"mage.translateInline\", $.ui.dialog, {\n        options: {\n            translateForm: {\n                template: '#translate-form-template',\n                data: {\n                    id: 'translate-inline-form',\n                    message: 'Please refresh the page to see your changes after submitting this form.'\n                }\n            },\n            autoOpen : false,\n            translateArea: null,\n            modal: true,\n            dialogClass: 'popup-window',\n            width: '75%',\n            title: $.mage.__('Translate'),\n            height: 470,\n            position: {\n                my: 'left top',\n                at: 'center top',\n                of: 'body'\n            },\n            buttons: [{\n                text: $.mage.__('Submit'),\n                'class': 'action-primary',\n                click: function(e) {\n                    $(this).translateInline('submit');\n                }\n            },\n            {\n                text: $.mage.__('Close'),\n                'class': 'action-close',\n                click: function() {\n                    $(this).translateInline('close');\n                }\n            }],\n            open: function () {\n                $(this).closest('.ui-dialog').addClass('ui-dialog-active');\n\n                var topMargin = jQuery(this).closest('.ui-dialog').children('.ui-dialog-titlebar').outerHeight() + 45;\n                jQuery(this).closest('.ui-dialog').css('margin-top', topMargin);\n            },\n            close: function () {\n                $(this).closest('.ui-dialog').removeClass('ui-dialog-active');\n            }\n        },\n        /**\n         * Translate Inline creation\n         * @protected\n         */\n        _create: function() {\n            this.tmpl = mageTemplate(this.options.translateForm.template);\n            (this.options.translateArea && $(this.options.translateArea).length ?\n                $(this.options.translateArea) :\n                this.element.closest('body'))\n                    .on('edit.editTrigger', $.proxy(this._onEdit, this));\n            this._super();\n        },\n\n        _prepareContent: function(templateData) {\n            var data = $.extend({\n                items: templateData,\n                escape: $.mage.escapeHTML\n            }, this.options.translateForm.data);\n            this.data = data;\n\n            return $(this.tmpl({\n                data: data\n            }));\n        },\n\n        /**\n         * Render translation form and open dialog\n         * @param {Object} event object\n         * @protected\n         */\n        _onEdit: function(e) {\n            this.target = e.target;\n            this.element.html(this._prepareContent($(e.target).data('translate')));\n            this.open(e);\n        },\n\n        submit: function() {\n            if (this.formIsSubmitted) {\n                return;\n            }\n            this._formSubmit();\n        },\n        /**\n         * Send ajax request on form submit\n         * @protected\n         */\n        _formSubmit: function() {\n            this.formIsSubmitted = true;\n            var parameters = $.param({area: this.options.area}) +\n                '&' + $('#' + this.options.translateForm.data.id).serialize();\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'POST',\n                data: parameters,\n                loaderContext: this.element,\n                showLoader: true\n            }).complete($.proxy(this._formSubmitComplete, this));\n        },\n\n        _formSubmitComplete: function(response) {\n            this.close();\n            this.formIsSubmitted = false;\n            this._updatePlaceholder(response.responseJSON[this.data.items[0]['original']])\n        },\n\n        _updatePlaceholder: function(newValue) {\n            var target = jQuery(this.target);\n            target.data('translate')[0]['shown'] = newValue;\n            target.data('translate')[0]['translated'] = newValue;\n            target.html(newValue);\n        },\n\n        /**\n         * Destroy translateInline\n         */\n        destroy: function() {\n            this.element.off('.editTrigger');\n            this._super();\n        }\n    });\n    /*\n     * @TODO move the \"escapeHTML\" method into the file with global utility functions\n     */\n    $.extend(true, $, {\n        mage: {\n            escapeHTML: function(str) {\n                return str ?\n                    jQuery('<div/>').text(str).html().replace(/\"/g, '&quot;'):\n                    false;\n            }\n        }\n    });\n\n    $.widget('ui.button', $.ui.button, {\n        _create: function () {\n            this._super();\n            /**\n             * Decode HTML entities to prevent incorrect rendering of dialog button label\n             */\n            this.options.label = this.options.label\n                ? jQuery('<div/>').html(this.options.label).text()\n                : this.options.label;\n            /**\n             * Reset button to make decoded label visible\n             */\n            this._resetButton();\n        }\n    });\n\n    $.widget('ui.dialog', $.ui.dialog, {\n        /**\n         * Prevent rendering of dialog title as escaped HTML\n         */\n        _title: function (title) {\n            this._super(title);\n            if (this.options.title) {\n                title.html(this.options.title);\n            }\n        }\n    });\n\n    return $.mage.translateInline;\n}));\n","mage/translate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"mage/mage\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    $.extend(true, $, {\n        mage: {\n            translate: (function() {\n                /**\n                 * Key-value translations storage\n                 * @type {Object}\n                 * @private\n                 */\n                var _data = {};\n\n                /**\n                 * Add new translation (two string parameters) or several translations (object)\n                 * @param {(Object.<string>|string)}\n                 * @param {string}\n                 */\n                this.add = function() {\n                    if (arguments.length > 1) {\n                        _data[arguments[0]] = arguments[1];\n                    } else if (typeof arguments[0] === 'object') {\n                        $.extend(_data, arguments[0]);\n                    }\n                };\n\n                /**\n                 * Make a translation with parsing (to handle case when _data represents tuple)\n                 * @param {string} text\n                 * @return {string}\n                 */\n                this.translate = function (text) {\n                    return _data[text] ? _data[text] : text;\n                };\n\n                return this;\n            }())\n        }\n    });\n    /**\n     * Sort alias for jQuery.mage.translate.translate method\n     * @type {function(string): string}\n     */\n    $.mage.__ = $.proxy($.mage.translate.translate, $.mage.translate);\n\n    return $.mage.__;\n}));","mage/validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint regexdash:true eqnull:true browser:true jquery:true*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui',\n            'jquery/validate',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    \"use strict\";\n    $.extend(true, $, {\n        // @TODO: Move methods 'isEmpty', 'isEmptyNoTrim', 'parseNumber', 'stripHtml' in file with utility functions\n        mage: {\n            /**\n             * Check if string is empty with trim\n             * @param {string} value\n             */\n            isEmpty: function (value) {\n                return (value === '' || value === undefined || (value == null) || (value.length === 0) || /^\\s+$/.test(value));\n            },\n\n            /**\n             * Check if string is empty no trim\n             * @param {string} value\n             */\n            isEmptyNoTrim: function (value) {\n                return (value === '' || (value == null) || (value.length === 0));\n            },\n\n\n            /**\n             * Checks if {value} is between numbers {from} and {to}\n             * @param {string} value\n             * @param {string} from\n             * @param {string} to\n             * @returns {boolean}\n             */\n            isBetween: function (value, from, to) {\n                return ($.mage.isEmpty(from) || value >= $.mage.parseNumber(from)) &&\n                    ($.mage.isEmpty(to) || value <= $.mage.parseNumber(to));\n            },\n\n            /**\n             * Parse price string\n             * @param {string} value\n             */\n            parseNumber: function (value) {\n                if (typeof value !== 'string') {\n                    return parseFloat(value);\n                }\n                var isDot = value.indexOf('.');\n                var isComa = value.indexOf(',');\n                if (isDot !== -1 && isComa !== -1) {\n                    if (isComa > isDot) {\n                        value = value.replace('.', '').replace(',', '.');\n                    } else {\n                        value = value.replace(',', '');\n                    }\n                } else if (isComa !== -1) {\n                    value = value.replace(',', '.');\n                }\n                return parseFloat(value);\n            },\n\n            /**\n             * Removes HTML tags and space characters, numbers and punctuation.\n             * @param value Value being stripped.\n             * @return {*}\n             */\n            stripHtml: function (value) {\n                return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                    .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n            }\n        }\n    });\n\n    $.validator.addMethod = function (name, method, message, dontSkip) {\n        $.validator.methods[name] = method;\n        $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];\n\n        if (method.length < 3 || dontSkip) {\n            $.validator.addClassRules(name, $.validator.normalizeRule(name));\n        }\n    };\n\n    /**\n     * Javascript object with credit card types\n     * 0 - regexp for card number\n     * 1 - regexp for cvn\n     * 2 - check or not credit card number trough Luhn algorithm by\n     */\n    var creditCartTypes = {\n        'SO': [new RegExp('^(6334[5-9]([0-9]{11}|[0-9]{13,14}))|(6767([0-9]{12}|[0-9]{14,15}))$'), new RegExp('^([0-9]{3}|[0-9]{4})?$'), true],\n        'SM': [new RegExp('(^(5[0678])[0-9]{11,18}$)|(^(6[^05])[0-9]{11,18}$)|(^(601)[^1][0-9]{9,16}$)|(^(6011)[0-9]{9,11}$)|(^(6011)[0-9]{13,16}$)|(^(65)[0-9]{11,13}$)|(^(65)[0-9]{15,18}$)|(^(49030)[2-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49033)[5-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49110)[1-2]([0-9]{10}$|[0-9]{12,13}$))|(^(49117)[4-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49118)[0-2]([0-9]{10}$|[0-9]{12,13}$))|(^(4936)([0-9]{12}$|[0-9]{14,15}$))'), new RegExp('^([0-9]{3}|[0-9]{4})?$'), true],\n        'VI': [new RegExp('^4[0-9]{12}([0-9]{3})?$'), new RegExp('^[0-9]{3}$'), true],\n        'MC': [new RegExp('^5[1-5][0-9]{14}$'), new RegExp('^[0-9]{3}$'), true],\n        'AE': [new RegExp('^3[47][0-9]{13}$'), new RegExp('^[0-9]{4}$'), true],\n        'DI': [new RegExp('^(30[0-5][0-9]{13}|3095[0-9]{12}|35(2[8-9][0-9]{12}|[3-8][0-9]{13})|36[0-9]{12}|3[8-9][0-9]{14}|6011(0[0-9]{11}|[2-4][0-9]{11}|74[0-9]{10}|7[7-9][0-9]{10}|8[6-9][0-9]{10}|9[0-9]{11})|62(2(12[6-9][0-9]{10}|1[3-9][0-9]{11}|[2-8][0-9]{12}|9[0-1][0-9]{11}|92[0-5][0-9]{10})|[4-6][0-9]{13}|8[2-8][0-9]{12})|6(4[4-9][0-9]{13}|5[0-9]{14}))$'), new RegExp('^[0-9]{3}$'), true],\n        'JCB': [new RegExp('^(30[0-5][0-9]{13}|3095[0-9]{12}|35(2[8-9][0-9]{12}|[3-8][0-9]{13})|36[0-9]{12}|3[8-9][0-9]{14}|6011(0[0-9]{11}|[2-4][0-9]{11}|74[0-9]{10}|7[7-9][0-9]{10}|8[6-9][0-9]{10}|9[0-9]{11})|62(2(12[6-9][0-9]{10}|1[3-9][0-9]{11}|[2-8][0-9]{12}|9[0-1][0-9]{11}|92[0-5][0-9]{10})|[4-6][0-9]{13}|8[2-8][0-9]{12})|6(4[4-9][0-9]{13}|5[0-9]{14}))$'), new RegExp('^[0-9]{3}$'), true],\n        'OT': [new RegExp('^([0-9]+)$'), new RegExp('^([0-9]{3}|[0-9]{4})?$'), false],\n        'DN': [new RegExp('^3((0([0-5]\\\\d*)?)|[689]\\\\d*)?$'), new RegExp('^[0-9]{3}$'), true],\n        'UN': [new RegExp('^6(2\\\\d*)?$'), new RegExp('^[0-9]{3}$'), true],\n        'MI': [new RegExp('^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'MD': [new RegExp('^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$'), new RegExp('^[0-9]{3}$'), true]\n    };\n\n    /**\n     * validate credit card number using mod10\n     * @param s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = \"0123456789\",\n            w = \"\", i, j, k, m, c, a, x;\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n            if (v.indexOf(x, 0) != -1)\n                w += x;\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n        return (c % 10 === 0);\n    }\n\n    /**\n     * validate all table required inputs at once, using single hidden input\n     * @param {String} value\n     * @param {HTMLElement} element\n     *\n     * @return {Boolean}\n     */\n    function tableSingleValidation(value, element) {\n        var empty = $(element).closest('table')\n            .find('input.required-option:visible')\n            .filter(function (i, el) {\n                return $.mage.isEmpty(el.value);\n            })\n            .length;\n        return empty === 0;\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    var rules = {\n        \"max-words\": [\n            function (value, element, params) {\n                return this.optional(element) || $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length < params;\n            },\n            'Please enter {0} words or less.'\n        ],\n        \"min-words\": [\n            function (value, element, params) {\n                return this.optional(element) || $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            'Please enter at least {0} words.'\n        ],\n        \"range-words\": [\n            function (value, element, params) {\n                return this.optional(element) ||\n                    $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length >= params[0] &&\n                    value.match(/bw+b/g).length < params[1];\n            },\n            'Please enter between {0} and {1} words.'\n        ],\n        \"letters-with-basic-punc\": [\n            function (value, element) {\n                return this.optional(element) || /^[a-z\\-.,()'\\\"\\s]+$/i.test(value);\n            },\n            'Letters or punctuation only please'\n        ],\n        \"alphanumeric\": [\n            function (value, element) {\n                return this.optional(element) || /^\\w+$/i.test(value);\n            },\n            'Letters, numbers, spaces or underscores only please'\n        ],\n        \"letters-only\": [\n            function (value, element) {\n                return this.optional(element) || /^[a-z]+$/i.test(value);\n            },\n            'Letters only please'\n        ],\n        \"no-whitespace\": [\n            function (value, element) {\n                return this.optional(element) || /^\\S+$/i.test(value);\n            },\n            'No white space please'\n        ],\n        \"zip-range\": [\n            function (value, element) {\n                return this.optional(element) || /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            'Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx'\n        ],\n        \"integer\": [\n            function (value, element) {\n                return this.optional(element) || /^-?\\d+$/.test(value);\n            },\n            'A positive or negative non-decimal number please'\n        ],\n        \"vinUS\": [\n            function (v) {\n                if (v.length !== 17) {\n                    return false;\n                }\n                var i, n, d, f, cd, cdv;\n                var LL = [\"A\", \"B\", \"C\", \"D\", \"E\", \"F\", \"G\", \"H\", \"J\", \"K\", \"L\", \"M\", \"N\", \"P\", \"R\", \"S\", \"T\", \"U\", \"V\", \"W\", \"X\", \"Y\", \"Z\"];\n                var VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9];\n                var FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2];\n                var rs = 0;\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = v.slice(i, i + 1);\n                    if (i === 8) {\n                        cdv = d;\n                    }\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {\n                            if (d.toUpperCase() === LL[n]) {\n                                d = VL[n];\n                                d *= f;\n                                if (isNaN(cdv) && n === 8) {\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n                cd = rs % 11;\n                if (cd === 10) {\n                    cd = \"X\";\n                }\n                if (cd === cdv) {\n                    return true;\n                }\n                return false;\n            },\n            'The specified vehicle identification number (VIN) is invalid.'\n        ],\n        \"dateITA\": [\n            function (value, element) {\n                var check = false;\n                var re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/;\n                if (re.test(value)) {\n                    var adata = value.split('/');\n                    var gg = parseInt(adata[0], 10);\n                    var mm = parseInt(adata[1], 10);\n                    var aaaa = parseInt(adata[2], 10);\n                    var xdata = new Date(aaaa, mm - 1, gg);\n                    if ((xdata.getFullYear() === aaaa) &&\n                        (xdata.getMonth() === mm - 1) && (xdata.getDate() === gg )) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n                return this.optional(element) || check;\n            },\n            'Please enter a correct date'\n        ],\n        \"dateNL\": [\n            function (value, element) {\n                return this.optional(element) || /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            'Vul hier een geldige datum in.'\n        ],\n        \"time\": [\n            function (value, element) {\n                return this.optional(element) || /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            'Please enter a valid time, between 00:00 and 23:59'\n        ],\n        \"time12h\": [\n            function (value, element) {\n                return this.optional(element) || /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\ [AP]M))$/i.test(value);\n            },\n            'Please enter a valid time, between 00:00 am and 12:00 pm'\n        ],\n        \"phoneUS\": [\n            function (phone_number, element) {\n                phone_number = phone_number.replace(/\\s+/g, \"\");\n                return this.optional(element) || phone_number.length > 9 &&\n                    phone_number.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            'Please specify a valid phone number'\n        ],\n        \"phoneUK\": [\n            function (phone_number, element) {\n                return this.optional(element) || phone_number.length > 9 &&\n                    phone_number.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            'Please specify a valid phone number'\n        ],\n        \"mobileUK\": [\n            function (phone_number, element) {\n                return this.optional(element) || phone_number.length > 9 &&\n                    phone_number.match(/^((0|\\+44)7(5|6|7|8|9){1}\\d{2}\\s?\\d{6})$/);\n            },\n            'Please specify a valid mobile number'\n        ],\n        \"stripped-min-length\": [\n            function (value, element, param) {\n                return $(value).text().length >= param;\n            },\n            'Please enter at least {0} characters'\n        ],\n        \"email2\": [\n            function (value, element) {\n                return this.optional(element) || /^((([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\x22)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\x22)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);\n            },\n            $.validator.messages.email\n        ],\n        \"url2\": [\n            function (value, element) {\n                return this.optional(element) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);\n            },\n            $.validator.messages.url\n        ],\n        \"credit-card-types\": [\n            function (value, element, param) {\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, \"\");\n\n                var validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n                return false;\n            },\n            'Please enter a valid credit card number.'\n        ],\n        \"ipv4\": [\n            function (value, element) {\n                return this.optional(element) || /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);\n            },\n            'Please enter a valid IP v4 address.'\n        ],\n        \"ipv6\": [\n            function (value, element) {\n                return this.optional(element) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);\n            },\n            'Please enter a valid IP v6 address.'\n        ],\n        \"pattern\": [\n            function (value, element, param) {\n                return this.optional(element) || param.test(value);\n            },\n            'Invalid format.'\n        ],\n        \"allow-container-className\": [\n            function (element) {\n                if (element.type === 'radio' || element.type === 'checkbox') {\n                    return $(element).hasClass('change-container-classname');\n                }\n            },\n            ''\n        ],\n        \"validate-no-html-tags\": [\n            function (value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            'HTML tags are not allowed.'\n        ],\n        \"validate-select\": [\n            function (value) {\n                return ((value !== \"none\") && (value != null) && (value.length !== 0));\n            },\n            'Please select an option.'\n        ],\n        \"validate-no-empty\": [\n            function (value) {\n                return !$.mage.isEmpty(value);\n            },\n            'Empty Value.'\n        ],\n        \"validate-alphanum-with-spaces\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z0-9 ]+$/.test(v);\n            },\n            'Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.'\n        ],\n        \"validate-data\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(v);\n            },\n            'Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.'\n        ],\n        \"validate-street\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(v);\n            },\n            'Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.'\n        ],\n        \"validate-phoneStrict\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(v);\n            },\n            'Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.'\n        ],\n        \"validate-phoneLax\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(v);\n            },\n            'Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.'\n        ],\n        \"validate-fax\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(v);\n            },\n            'Please enter a valid fax number (Ex: 123-456-7890).'\n        ],\n        \"validate-email\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(v);\n            },\n            'Please enter a valid email address (Ex: johndoe@domain.com).'\n        ],\n        \"validate-emailSender\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[\\S ]+$/.test(v);\n            },\n            'Please enter a valid email address (Ex: johndoe@domain.com).'\n        ],\n        \"validate-password\": [\n            function (v) {\n                if (v == null) {\n                    return false;\n                }\n                /*strip leading and trailing spaces*/\n                var pass = $.trim(v);\n                if (!pass.length) {\n                    return true;\n                }\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            'Please enter 6 or more characters. Leading and trailing spaces will be ignored.'\n        ],\n        \"validate-admin-password\": [\n            function (v) {\n                if (v == null) {\n                    return false;\n                }\n                var pass = $.trim(v);\n                /*strip leading and trailing spaces*/\n                if (0 === pass.length) {\n                    return true;\n                }\n                if (!(/[a-z]/i.test(v)) || !(/[0-9]/.test(v))) {\n                    return false;\n                }\n                if (pass.length < 7) {\n                    return false;\n                }\n                return true;\n            },\n            'Please enter 7 or more characters, using both numeric and alphabetic.'\n        ],\n        \"validate-customer-password\": [\n            function (v, elm) {\n                var validator = this,\n                    length = 0,\n                    counter = 0;\n                var passwordMinLength = $(elm).data('password-min-length');\n                var passwordMinCharacterSets = $(elm).data('password-min-character-sets');\n                var pass = $.trim(v);\n                var result = pass.length >= passwordMinLength;\n                if (result == false) {\n                    validator.passwordErrorMessage = $.mage.__(\n                        \"Minimum length of this field must be equal or greater than %1 symbols.\" +\n                        \" Leading and trailing spaces will be ignored.\"\n                    ).replace('%1', passwordMinLength);\n                    return result;\n                }\n                if (pass.match(/\\d+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[a-z]+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[A-Z]+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter ++;\n                }\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__(\n                        \"Minimum of different classes of characters in password is %1.\" +\n                        \" Classes of characters: Lower Case, Upper Case, Digits, Special Characters.\"\n                    ).replace('%1', passwordMinCharacterSets);\n                }\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        \"validate-url\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = (v || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(v);\n\n            },\n            'Please enter a valid URL. Protocol is required (http://, https:// or ftp://).'\n        ],\n        \"validate-clean-url\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v);\n\n            },\n            'Please enter a valid URL. For example http://www.example.com or www.example.com.'\n        ],\n        \"validate-xml-identifier\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(v);\n\n            },\n            'Please enter a valid XML-identifier (Ex: something_1, block5, id-4).'\n        ],\n        \"validate-ssn\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(v);\n\n            },\n            'Please enter a valid social security number (Ex: 123-45-6789).'\n        ],\n        \"validate-zip-us\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(v);\n\n            },\n            'Please enter a valid zip code (Ex: 90602 or 90602-1234).'\n        ],\n        \"validate-date-au\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                var regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/;\n                if ($.mage.isEmpty(v) || !regex.test(v)) {\n                    return false;\n                }\n                var d = new Date(v.replace(regex, '$2/$1/$3'));\n                return parseInt(RegExp.$2, 10) === (1 + d.getMonth()) &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            'Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.'\n        ],\n        \"validate-currency-dollar\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(v);\n\n            },\n            'Please enter a valid $ amount. For example $100.00.'\n        ],\n        \"validate-not-negative-number\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n                return !isNaN(v) && v >= 0;\n\n            },\n            'Please enter a number 0 or greater in this field.'\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        \"validate-zero-or-greater\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n                return !isNaN(v) && v >= 0;\n\n            },\n            'Please enter a number 0 or greater in this field.'\n        ],\n        \"validate-greater-than-zero\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n                return !isNaN(v) && v > 0;\n            },\n            'Please enter a number greater than 0 in this field.'\n        ],\n        \"validate-css-length\": [\n            function (v) {\n                if (v !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(v);\n                }\n                return true;\n            },\n            'Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).'\n        ],\n        /** @description Additional methods */\n        \"validate-number\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || (!isNaN($.mage.parseNumber(v)) && /^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(v));\n            },\n            'Please enter a valid number in this field.'\n        ],\n        \"required-number\": [\n            function (v) {\n                return !!v.length;\n            },\n            'Please enter a valid number in this field.'\n        ],\n        \"validate-number-range\": [\n            function (v, elm, param) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                var numValue = $.mage.parseNumber(v);\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                var dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/,\n                    classNameRange = /^number-range-(-?[\\d.,]+)?-(-?[\\d.,]+)?$/,\n                    result = true,\n                    range, m, classes, ii;\n\n                range = param;\n                if (typeof range === 'object') {\n                    m = dataAttrRange.exec(range);\n                    if (m) {\n                        result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                    }\n                } else if (elm && elm.className) {\n                    classes = elm.className.split(\" \");\n                    ii = classes.length;\n\n                    while (ii--) {\n                        range = classes[ii];\n                        m = classNameRange.exec(range);\n                        if (m) {\n                            result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                            break;\n                        }\n                    }\n                }\n\n                return result;\n            },\n            'The value is not within the specified range.',\n            true\n        ],\n        \"validate-digits\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || !/[^\\d]/.test(v);\n            },\n            'Please enter a valid number in this field.'\n        ],\n        \"validate-digits-range\": [\n            function (v, elm, param) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                var numValue = $.mage.parseNumber(v);\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                var dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/,\n                    classNameRange = /^digits-range-(-?\\d+)?-(-?\\d+)?$/,\n                    result = true,\n                    range, m, classes, ii;\n                range = param;\n\n                if (typeof range === 'object') {\n                    m = dataAttrRange.exec(range);\n                    if (m) {\n                        result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                    }\n                } else if (elm && elm.className) {\n                    classes = elm.className.split(\" \");\n                    ii = classes.length;\n\n                    while (ii--) {\n                        range = classes[ii];\n                        m = classNameRange.exec(range);\n                        if (m) {\n                            result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                            break;\n                        }\n                    }\n                }\n\n                return result;\n            },\n            'The value is not within the specified range.',\n            true\n        ],\n        'validate-range': [\n            function (v, elm) {\n                var minValue, maxValue;\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](v)) {\n                    minValue = maxValue = $.mage.parseNumber(v);\n                } else {\n                    var ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(v);\n\n                    if (ranges) {\n                        minValue = $.mage.parseNumber(ranges[1]);\n                        maxValue = $.mage.parseNumber(ranges[2]);\n                        if (minValue > maxValue) {\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n                var reRange = /^range-(-?\\d+)?-(-?\\d+)?$/,\n                    result = true;\n\n                var values = $(elm).prop('class').split(\" \");\n\n                for (var i = values.length - 1; i >= 0; i--) {\n                    var name = values[i];\n                    var validRange = reRange.exec(name);\n                    if (validRange) {\n                        var minValidRange = $.mage.parseNumber(validRange[1]);\n                        var maxValidRange = $.mage.parseNumber(validRange[2]);\n                        result = result &&\n                        (isNaN(minValidRange) || minValue >= minValidRange) &&\n                        (isNaN(maxValidRange) || maxValue <= maxValidRange);\n                    }\n                }\n                return result;\n            },\n            'The value is not within the specified range.'\n        ],\n        \"validate-alpha\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z]+$/.test(v);\n            },\n            'Please use letters only (a-z or A-Z) in this field.'\n        ],\n        \"validate-code\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-z]+[a-z0-9_]+$/.test(v);\n            },\n            'Please use only letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.'\n        ],\n        \"validate-alphanum\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z0-9]+$/.test(v);\n            },\n            'Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.'\n        ],\n        \"validate-date\": [\n            function (v) {\n                var test = new Date(v);\n                return $.mage.isEmptyNoTrim(v) || !isNaN(test);\n            }, 'Please enter a valid date.'\n\n        ],\n        \"validate-date-range\": [\n            function (v, elm) {\n                var m = /\\bdate-range-(\\w+)-(\\w+)\\b/.exec(elm.className);\n                if (!m || m[2] === 'to' || $.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                var currentYear = new Date().getFullYear() + '';\n                var normalizedTime = function (v) {\n                    v = v.split(/[.\\/]/);\n                    if (v[2] && v[2].length < 4) {\n                        v[2] = currentYear.substr(0, v[2].length) + v[2];\n                    }\n                    return new Date(v.join('/')).getTime();\n                };\n\n                var dependentElements = $(elm.form).find('.validate-date-range.date-range-' + m[1] + '-to');\n                return !dependentElements.length || $.mage.isEmptyNoTrim(dependentElements[0].value) ||\n                    normalizedTime(v) <= normalizedTime(dependentElements[0].value);\n            },\n            'Make sure the To Date is later than or the same as the From Date.'\n        ],\n        \"validate-cpassword\": [\n            function () {\n                var conf = $('#confirmation').length > 0 ? $('#confirmation') : $($('.validate-cpassword')[0]);\n                var pass = false;\n                if ($('#password')) {\n                    pass = $('#password');\n                }\n                var passwordElements = $('.validate-password');\n                for (var i = 0; i < passwordElements.length; i++) {\n                    var passwordElement = $(passwordElements[i]);\n                    if (passwordElement.closest('form').attr('id') === conf.closest('form').attr('id')) {\n                        pass = passwordElement;\n                    }\n                }\n                if ($('.validate-admin-password').length) {\n                    pass = $($('.validate-admin-password')[0]);\n                }\n                return (pass.val() === conf.val());\n            },\n            'Please make sure your passwords match.'\n        ],\n        \"validate-identifier\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(v);\n            },\n            'Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").'\n        ],\n        \"validate-zip-international\": [\n            /*function(v) {\n             // @TODO: Cleanup\n             return Validation.get('IsEmpty').test(v) || /(^[A-z0-9]{2,10}([\\s]{0,1}|[\\-]{0,1})[A-z0-9]{2,10}$)/.test(v);\n             }*/\n            function () {\n                return true;\n            },\n            'Please enter a valid zip code.'\n        ],\n        \"validate-one-required\": [\n            function (v, elm) {\n                var p = $(elm).parent();\n                var options = p.find('input');\n                return options.map(function (elm) {\n                        return $(elm).val();\n                    }).length > 0;\n            },\n            'Please select one of the options above.'\n        ],\n        \"validate-state\": [\n            function (v) {\n                return (v !== 0 || v === '');\n            },\n            'Please select State/Province.'\n        ],\n        \"required-file\": [\n            function (v, elm) {\n                var result = !$.mage.isEmptyNoTrim(v);\n                if (!result) {\n                    var ovId = $(elm).attr('id') + '_value';\n                    if ($(ovId)) {\n                        result = !$.mage.isEmptyNoTrim($(ovId).val());\n                    }\n                }\n                return result;\n            },\n            'Please select a file.'\n        ],\n        \"validate-ajax-error\": [\n            function (v, element) {\n                element = $(element);\n                element.on('change.ajaxError', function () {\n                    element.removeClass('validate-ajax-error');\n                    element.off('change.ajaxError');\n                });\n                return !element.hasClass('validate-ajax-error');\n            },\n            ''\n        ],\n        \"validate-optional-datetime\": [\n            function (v, elm, param) {\n                var dateTimeParts = $('.datetime-picker[id^=\"options_' + param + '\"]'),\n                    hasWithValue = false, hasWithNoValue = false,\n                    pattern = /day_part$/i;\n                for (var i = 0; i < dateTimeParts.length; i++) {\n                    if (!pattern.test($(dateTimeParts[i]).attr('id'))) {\n                        if ($(dateTimeParts[i]).val() === \"\") {\n                            hasWithValue = true;\n                        } else {\n                            hasWithNoValue = true;\n                        }\n                    }\n                }\n                return hasWithValue ^ hasWithNoValue;\n            },\n            'The field isn\\'t complete.'\n        ],\n        \"validate-required-datetime\": [\n            function (v, elm, param) {\n                var dateTimeParts = $('.datetime-picker[id^=\"options_' + param + '\"]');\n                for (var i = 0; i < dateTimeParts.length; i++) {\n                    if (dateTimeParts[i].value === \"\") {\n                        return false;\n                    }\n                }\n                return true;\n            },\n            'This is a required field.'\n        ],\n        \"validate-one-required-by-name\": [\n            function (v, elm, selector) {\n                var name = elm.name.replace(/([\\\\\"])/g, '\\\\$1'),\n                    container = this.currentForm,\n                    selector = selector === true ? 'input[name=\"' + name + '\"]:checked' : selector;\n\n                return !!container.querySelectorAll(selector).length;\n            },\n            'Please select one of the options.'\n        ],\n        \"less-than-equals-to\": [\n            function (value, element, params) {\n                if ($.isNumeric($(params).val()) && $.isNumeric(value)) {\n                    this.lteToVal = $(params).val();\n                    return parseFloat(value) <= parseFloat($(params).val());\n                }\n                return true;\n            },\n            function () {\n                var message = $.mage.__('Please enter a value less than or equal to %s.');\n                return message.replace('%s', this.lteToVal);\n            }\n        ],\n        \"greater-than-equals-to\": [\n            function (value, element, params) {\n                if ($.isNumeric($(params).val()) && $.isNumeric(value)) {\n                    this.gteToVal = $(params).val();\n                    return parseFloat(value) >= parseFloat($(params).val());\n                }\n                return true;\n            },\n            function () {\n                var message = $.mage.__('Please enter a value greater than or equal to %s.');\n                return message.replace('%s', this.gteToVal);\n            }\n        ],\n        \"validate-emails\": [\n            function (value) {\n                if ($.mage.isEmpty(value)) {\n                    return true;\n                }\n                var valid_regexp = /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i,\n                    emails = value.split(/[\\s\\n\\,]+/g);\n                for (var i = 0; i < emails.length; i++) {\n                    if (!valid_regexp.test(emails[i].trim())) {\n                        return false;\n                    }\n                }\n                return true;\n            }, \"Please enter valid email addresses, separated by commas. For example, johndoe@domain.com, johnsmith@domain.com.\"\n        ],\n\n        \"validate-cc-type-select\": [\n            /**\n             * Validate credit card type matches credit card number\n             * @param value - select credit card type\n             * @param element - element contains the select box for credit card types\n             * @param params - selector for credit card number\n             * @return {boolean}\n             */\n                function (value, element, params) {\n                if (value && params && creditCartTypes[value]) {\n                    return creditCartTypes[value][0].test($(params).val().replace(/\\s+/g, ''));\n                }\n                return false;\n            }, 'Card type does not match credit card number.'\n        ],\n        \"validate-cc-number\": [\n            /**\n             * Validate credit card number based on mod 10\n             * @param value - credit card number\n             * @return {boolean}\n             */\n                function (value) {\n                if (value) {\n                    return validateCreditCard(value);\n                }\n                return false;\n            }, 'Please enter a valid credit card number.'\n        ],\n        \"validate-cc-type\": [\n            /**\n             * Validate credit card number is for the correct credit card type\n             * @param value - credit card number\n             * @param element - element contains credit card number\n             * @param params - selector for credit card type\n             * @return {boolean}\n             */\n                function (value, element, params) {\n                if (value && params) {\n                    var ccType = $(params).val();\n                    value = value.replace(/\\s/g, '').replace(/\\-/g, '');\n                    if (creditCartTypes[ccType] && creditCartTypes[ccType][0]) {\n                        return creditCartTypes[ccType][0].test(value);\n                    } else if (creditCartTypes[ccType] && !creditCartTypes[ccType][0]) {\n                        return true;\n                    }\n                }\n                return false;\n            }, 'Credit card number does not match credit card type.'\n        ],\n        \"validate-cc-exp\": [\n            /**\n             * Validate credit card expiration date, make sure it's within the year and not before current month\n             * @param value - month\n             * @param element - element contains month\n             * @param params - year selector\n             * @return {Boolean}\n             */\n                function (value, element, params) {\n                var isValid = false;\n                if (value && params) {\n                    var month = value,\n                        year = $(params).val(),\n                        currentTime = new Date(),\n                        currentMonth = currentTime.getMonth() + 1,\n                        currentYear = currentTime.getFullYear();\n                    isValid = !year || year > currentYear || (year == currentYear && month >= currentMonth);\n                }\n                return isValid;\n            }, 'Incorrect credit card expiration date.'\n        ],\n        \"validate-cc-cvn\": [\n            /**\n             * Validate credit card cvn based on credit card type\n             * @param value - credit card cvn\n             * @param element - element contains credit card cvn\n             * @param params - credit card type selector\n             * @return {*}\n             */\n                function (value, element, params) {\n                if (value && params) {\n                    var ccType = $(params).val();\n                    if (creditCartTypes[ccType] && creditCartTypes[ccType][0]) {\n                        return creditCartTypes[ccType][1].test(value);\n                    }\n                }\n                return false;\n            }, 'Please enter a valid credit card verification number.'\n        ],\n        \"validate-cc-ukss\": [\n            /**\n             * Validate Switch/Solo/Maestro issue number and start date is filled\n             * @param value - input field value\n             * @return {*}\n             */\n                function (value) {\n                return value;\n            }, 'Please enter issue number or start date for switch/solo card type.'\n        ],\n\n        \"validate-length\": [\n            function (v, elm) {\n                var reMax = new RegExp(/^maximum-length-[0-9]+$/),\n                    reMin = new RegExp(/^minimum-length-[0-9]+$/),\n                    validator = this,\n                    result = true,\n                    length = 0;\n                $.each(elm.className.split(' '), function (index, name) {\n                    if (name.match(reMax) && result) {\n                        length = name.split('-')[2];\n                        validator.attrLength = length;\n                        result = (v.length <= length);\n                    }\n                    if (name.match(reMin) && result && $.mage.isEmpty(v)) {\n                        length = name.split('-')[2];\n                        result = v.length >= length;\n                    }\n                });\n                return result;\n            }, function () {\n                return $.mage.__(\"Maximum length of this field must be equal or less than %1 symbols.\")\n                    .replace('%1', this.attrLength);\n            }\n        ],\n        'required-entry': [\n            function (value) {\n                return !$.mage.isEmpty(value);\n            }, $.mage.__('This is a required field.')\n        ],\n        'not-negative-amount': [\n            function (v) {\n                if (v.length)\n                    return (/^\\s*\\d+([,.]\\d+)*\\s*%?\\s*$/).test(v);\n                else\n                    return true;\n            },\n            'Please enter positive number in this field.'\n        ],\n        'validate-per-page-value-list': [\n            function (v) {\n                var isValid = !$.mage.isEmpty(v);\n                var values = v.split(',');\n                for (var i = 0; i < values.length; i++) {\n                    if (!/^[0-9]+$/.test(values[i])) {\n                        isValid = false;\n                    }\n                }\n                return isValid;\n            },\n            'Please enter a valid value, ex: 10,20,30'\n        ],\n        'validate-per-page-value': [\n            function (v, elm) {\n                if ($.mage.isEmpty(v)) {\n                    return false;\n                }\n                var values = $('#' + elm.id + '_values').val().split(',');\n                return values.indexOf(v) != -1;\n            },\n            'Please enter a valid value from list'\n        ],\n        'validate-new-password': [\n            function (v) {\n\n                if ($.validator.methods['validate-password'] && !$.validator.methods['validate-password'](v)) {\n                    return false;\n                }\n                if ($.mage.isEmpty(v) && v !== '') {\n                    return false;\n                }\n                return true;\n            },\n            'Please enter 6 or more characters. Leading and trailing spaces will be ignored.'\n        ],\n        'required-if-not-specified': [\n            function (value, element, params) {\n                var valid = false;\n\n                // if there is an alternate, determine its validity\n                var alternate = $(params);\n                if (alternate.length > 0) {\n                    valid = this.check(alternate);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        var alternateValue = alternate.val();\n                        if (typeof alternateValue == 'undefined' || alternateValue.length === 0) {\n                            valid = false;\n                        }\n                    }\n                }\n\n                if (!valid)\n                    valid = !this.optional(element);\n\n                return valid;\n            },\n            'This is a required field.'\n        ],\n        'required-if-all-sku-empty-and-file-not-loaded': [\n            function (value, element, params) {\n                var valid = false;\n                var alternate = $(params.specifiedId);\n\n                if (alternate.length > 0) {\n                    valid = this.check(alternate);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        var alternateValue = alternate.val();\n                        if (typeof alternateValue == 'undefined' || alternateValue.length === 0) {\n                            valid = false;\n                        }\n                    }\n                }\n\n                if (!valid)\n                    valid = !this.optional(element);\n\n                $('input[' + params.dataSku + '=true]').each(function () {\n                    if ($(this).val() !== '') {\n                        valid = true;\n                    }\n                });\n\n                return valid;\n            }, 'Please enter valid SKU key.'\n        ],\n        'required-if-specified': [\n            function (value, element, params) {\n                var valid = true;\n\n                // if there is an dependent, determine its validity\n                var dependent = $(params);\n                if (dependent.length > 0) {\n                    valid = this.check(dependent);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        var dependentValue = dependent.val();\n                        valid = typeof dependentValue != 'undefined' && dependentValue.length > 0;\n                    }\n                }\n\n                if (valid) {\n                    valid = !this.optional(element);\n                } else {\n                    valid = true; // dependent was not valid, so don't even check\n                }\n\n                return valid;\n            },\n            'This is a required field.'\n        ],\n        'required-number-if-specified': [\n            function (value, element, params) {\n                var valid = true,\n                    dependent = $(params),\n                    depeValue;\n\n                if (dependent.length) {\n                    valid = this.check(dependent);\n\n                    if (valid) {\n                        depeValue = dependent[0].value;\n                        valid = !!(depeValue && depeValue.length);\n                    }\n                }\n\n                return valid ? !!value.length : true;\n            },\n            'Please enter a valid number.'\n        ],\n        'datetime-validation': [\n            function (value, element) {\n                var isValid = true;\n\n                if ($(element).val().length === 0) {\n                    isValid = false;\n                    $(element).addClass('mage-error');\n                }\n\n                return isValid;\n            },\n            'This is required field'\n        ],\n        'required-text-swatch-entry': [\n            tableSingleValidation,\n            'Admin is a required field in the each row.'\n        ],\n        'required-visual-swatch-entry': [\n            tableSingleValidation,\n            'Admin is a required field in the each row.'\n        ],\n        'required-dropdown-attribute-entry': [\n            tableSingleValidation,\n            'Admin is a required field in the each row.'\n        ],\n        'validate-item-quantity': [\n            function (value, element, params) {\n                // obtain values for validation\n                var qty = $.mage.parseNumber(value);\n\n                // validate quantity\n                var isMinAllowedValid = typeof params.minAllowed === 'undefined' || (qty >= $.mage.parseNumber(params.minAllowed));\n                var isMaxAllowedValid = typeof params.maxAllowed === 'undefined' || (qty <= $.mage.parseNumber(params.maxAllowed));\n                var isQtyIncrementsValid = typeof params.qtyIncrements === 'undefined' || (qty % $.mage.parseNumber(params.qtyIncrements) === 0);\n\n                return isMaxAllowedValid && isMinAllowedValid && isQtyIncrementsValid && qty > 0;\n            },\n            ''\n        ]\n    };\n\n    $.each(rules, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n    $.validator.addClassRules({\n        \"required-option\": {\n            required: true\n        },\n        \"required-options-count\": {\n            required: true\n        },\n        \"validate-both-passwords\": {\n            'validate-cpassword': true\n        }\n    });\n    $.validator.messages = $.extend($.validator.messages, {\n        required: $.mage.__('This is a required field.')\n    });\n\n    if ($.metadata) {\n        // Setting the type as html5 to enable data-validate attribute\n        $.metadata.setType(\"html5\");\n    }\n\n    var showLabel = $.validator.prototype.showLabel;\n    $.extend(true, $.validator.prototype, {\n        showLabel: function (element, message) {\n            showLabel.call(this, element, message);\n\n            // ARIA (adding aria-invalid & aria-describedby)\n            var label = this.errorsFor(element),\n                elem = $(element);\n\n            if (!label.attr('id')) {\n                label.attr('id', this.idOrName(element) + '-error');\n            }\n            elem.attr('aria-invalid', 'true')\n                .attr('aria-describedby', label.attr('id'));\n        }\n    });\n\n    /**\n     * Validate form field without instantiating validate plug-in\n     * @param {Element||String} element - DOM element or selector\n     * @return {Boolean} validation result\n     */\n    $.validator.validateElement = function (element) {\n        element = $(element);\n        var form = element.get(0).form,\n            validator = form ? $(form).data('validator') : null;\n        if (validator) {\n            return validator.element(element.get(0));\n        } else {\n            var valid = true,\n                classes = element.prop('class').split(' ');\n            $.each(classes, $.proxy(function (i, className) {\n                if (this.methods[className] && !this.methods[className](element.val(), element.get(0))) {\n                    valid = false;\n                    return valid;\n                }\n            }, this));\n            return valid;\n        }\n    };\n\n    var originValidateDelegate = $.fn.validateDelegate;\n\n    $.fn.validateDelegate = function () {\n        if (!this[0].form) {\n            return this;\n        }\n\n        return originValidateDelegate.apply(this, arguments);\n    };\n\n    /**\n     * Validate single element.\n     *\n     * @param {Element} element\n     * @returns {*}\n     */\n    $.validator.validateSingleElement = function (element) {\n        var errors = {},\n            valid = true,\n            validateConfig = {\n                errorElement: 'label',\n                ignore: '.ignore-validate'\n            },\n            form, validator, classes;\n\n        element = $(element).not(validateConfig.ignore);\n\n        if (!element.length) {\n            return true;\n        }\n\n        form = element.get(0).form;\n        validator = form ? $(form).data('validator') : null;\n\n        if (validator) {\n            return validator.element(element.get(0));\n        }\n\n        classes = element.prop('class').split(' ');\n        validator = element.parent().data('validator') ||\n            $.mage.validation(validateConfig, element.parent()).validate;\n\n        element.removeClass(validator.settings.errorClass);\n        validator.toHide = validator.toShow;\n        validator.hideErrors();\n        validator.toShow = validator.toHide = $([]);\n\n        $.each(classes, $.proxy(function (i, className) {\n            if (this.methods[className] && !this.methods[className](element.val(), element.get(0))) {\n                valid = false;\n                errors[element.get(0).name] = this.messages[className];\n                validator.invalid[element.get(0).name] = true;\n                validator.showErrors(errors);\n\n                return valid;\n            }\n        }, this));\n\n        return valid;\n    };\n\n    $.widget(\"mage.validation\", {\n        options: {\n            meta: \"validate\",\n            onfocusout: false,\n            onkeyup: false,\n            onclick: false,\n            ignoreTitle: true,\n            errorClass: 'mage-error',\n            errorElement: 'div',\n            errorPlacement: function (error, element) {\n                var errorPlacement = element;\n                // logic for date-picker error placement\n                if (element.hasClass('hasDatepicker')) {\n                    errorPlacement = element.siblings('img');\n                }\n                // logic for field wrapper\n                var fieldWrapper = element.closest('.addon');\n                if (fieldWrapper.length) {\n                    errorPlacement = fieldWrapper.after(error);\n                }\n                //logic for checkboxes/radio\n                if (element.is(':checkbox') || element.is(':radio')) {\n                    errorPlacement = element.siblings('label').last();\n                }\n                errorPlacement.after(error);\n            }\n        },\n        /**\n         * Check if form pass validation rules without submit\n         * @return boolean\n         */\n        isValid: function () {\n            return this.element.valid();\n        },\n\n        /**\n         * Remove validation error messages\n         */\n        clearError: function () {\n            if (arguments.length) {\n                $.each(arguments, $.proxy(function (index, item) {\n                    this.validate.prepareElement(item);\n                    this.validate.hideErrors();\n                }, this));\n            } else {\n                this.validate.resetForm();\n            }\n        },\n        /**\n         * Validation creation\n         * @protected\n         */\n        _create: function () {\n            this.validate = this.element.validate(this.options);\n\n            // ARIA (adding aria-required attribute)\n            this.element\n                .find('.field.required')\n                .find('.control')\n                .find('input, select, textarea')\n                .attr('aria-required', 'true');\n\n            this._listenFormValidate();\n        },\n        /**\n         * Validation listening\n         * @protected\n         */\n        _listenFormValidate: function () {\n            $('form').on('invalid-form.validate', function (event, validation) {\n                var firstActive = $(validation.errorList[0].element || []),\n                    lastActive = $(validation.findLastActive() || validation.errorList.length && validation.errorList[0].element || []);\n\n                if (lastActive.is(':hidden')) {\n                    var parent = lastActive.parent();\n                    var windowHeight = $(window).height();\n                    $('html, body').animate({\n                        scrollTop: parent.offset().top - windowHeight / 2\n                    });\n                }\n\n                // ARIA (removing aria attributes if success)\n                var successList = validation.successList;\n                if (successList.length) {\n                    $.each(successList, function () {\n                        $(this)\n                            .removeAttr('aria-describedby')\n                            .removeAttr('aria-invalid');\n                    })\n                }\n                if (firstActive.length) {\n                    firstActive.focus();\n                }\n            });\n        }\n    });\n\n    return $.mage.validation;\n}));\n","mage/apply/main.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    './scripts'\n], function (_, $, processScripts) {\n    'use strict';\n\n    var dataAttr = 'data-mage-init',\n        nodeSelector = '[' + dataAttr + ']';\n\n    /**\n     * Initializes components assigned to a specified element via data-* attribute.\n     *\n     * @param {HTMLElement} el - Element to initialize components with.\n     * @param {Object|String} config - Initial components' config.\n     * @param {String} component - Components' path.\n     */\n    function init(el, config, component) {\n        require([component], function (fn) {\n\n            if (typeof fn === 'object') {\n                fn = fn[component].bind(fn);\n            }\n\n            if (_.isFunction(fn)) {\n                fn(config, el);\n            } else if ($(el)[component]) {\n                $(el)[component](config);\n            }\n        });\n    }\n\n    /**\n     * Parses elements 'data-mage-init' attribute as a valid JSON data.\n     * Note: data-mage-init attribute will be removed.\n     *\n     * @param {HTMLElement} el - Element whose attribute should be parsed.\n     * @returns {Object}\n     */\n    function getData(el) {\n        var data = el.getAttribute(dataAttr);\n\n        el.removeAttribute(dataAttr);\n\n        return {\n            el: el,\n            data: JSON.parse(data)\n        };\n    }\n\n    return {\n        /**\n         * Initializes components assigned to HTML elements via [data-mage-init].\n         *\n         * @example Sample 'data-mage-init' declaration.\n         *      data-mage-init='{\"path/to/component\": {\"foo\": \"bar\"}}'\n         */\n        apply: function () {\n            var virtuals = processScripts(),\n                nodes = document.querySelectorAll(nodeSelector);\n\n            _.toArray(nodes)\n                .map(getData)\n                .concat(virtuals)\n                .forEach(function (itemContainer) {\n                    var element = itemContainer.el;\n\n                    _.each(itemContainer.data, function (obj, key) {\n                            if (obj.mixins) {\n                                require(obj.mixins, function () {\n                                    for (var i = 0, len = arguments.length; i < len; i++) {\n                                        $.extend(true, itemContainer.data[key], arguments[i](itemContainer.data[key], element));\n                                    }\n\n                                    delete obj.mixins;\n                                    init.call(null, element, obj, key);\n                                });\n                            } else {\n                                init.call(null, element, obj, key);\n                            }\n\n                        }\n                    );\n\n                });\n        },\n        applyFor: init\n    };\n});\n","mage/apply/scripts.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery'\n], function (_, $) {\n    'use strict';\n\n    var scriptSelector = 'script[type=\"text/x-magento-init\"]',\n        dataAttr = 'data-mage-init',\n        virtuals = [];\n\n    /**\n     * Adds components to the virtula list.\n     *\n     * @param {Object} components\n     */\n    function addVirtual(components) {\n        virtuals.push({\n            el: false,\n            data: components\n        });\n    }\n\n    /**\n     * Merges provided data with a current data\n     * of a elements' \"data-mage-init\" attribute.\n     *\n     * @param {Object} components - Object with components and theirs configuration.\n     * @param {HTMLElement} elem - Element whose data should be modified.\n     */\n    function setData(components, elem) {\n        var data = elem.getAttribute(dataAttr);\n\n        data = !!data ? JSON.parse(data) : {};\n        _.each(components, function(obj, key) {\n            if (_.has(obj, 'mixins')) {\n                data[key] = data[key] || {};\n                data[key].mixins = data[key].mixins || [];\n                data[key].mixins = data[key].mixins.concat(obj.mixins);\n                delete obj.mixins;\n            }\n        });\n\n        data = $.extend(true, data, components);\n        data = JSON.stringify(data);\n        elem.setAttribute(dataAttr, data);\n    }\n\n    /**\n     * Search for the elements by privded selector and extends theirs data.\n     *\n     * @param {Object} components - Object with components and theirs configuration.\n     * @param {String} selector - Selector for the elements.\n     */\n    function processElems(components, selector) {\n        var elems,\n            iterator;\n\n        if (selector === '*') {\n            addVirtual(components);\n\n            return;\n        }\n\n        elems = document.querySelectorAll(selector);\n        iterator = setData.bind(null, components);\n\n        _.toArray(elems).forEach(iterator);\n    }\n\n    /**\n     * Parses content of a provided script node.\n     * Note: node will be removed from DOM.\n     *\n     * @param {HTMLScriptElement} node - Node to be processed.\n     * @returns {Object}\n     */\n    function getNodeData(node) {\n        var data = node.textContent;\n\n        node.parentNode.removeChild(node);\n\n        return JSON.parse(data);\n    }\n\n    /**\n     * Parses 'script' tags with a custom type attribute and moves it's data\n     * to a 'data-mage-init' attribute of an elemennt found by provided selector.\n     * Note: All found script nodes will be removed from DOM.\n     *\n     * @returns {Array} An array of components not assigned to the specific element.\n     *\n     * @example Sample declaration.\n     *      <script type=\"text/x-magento-init\">\n     *          {\n     *              \"body\": {\n     *                  \"path/to/component\": {\"foo\": \"bar\"}\n     *              }\n     *          }\n     *      </script>\n     *\n     * @example Providing data without selector.\n     *      {\n     *          \"*\": {\n     *              \"path/to/component\": {\"bar\": \"baz\"}\n     *          }\n     *      }\n     */\n    return function () {\n        var nodes = document.querySelectorAll(scriptSelector);\n\n        _.toArray(nodes)\n            .map(getNodeData)\n            .forEach(function (item) {\n                _.each(item, processElems);\n            });\n\n        return virtuals.splice(0, virtuals.length);\n    };\n});\n","mage/gallery/gallery.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'fotorama/fotorama',\n    'underscore',\n    'matchMedia',\n    'mage/template',\n    'text!mage/gallery/gallery.html',\n    'uiClass',\n    'mage/translate'\n], function ($, fotorama, _, mediaCheck, template, galleryTpl, Class, $t) {\n    'use strict';\n\n    /**\n     * Retrieves index if the main item.\n     * @param {Array.<Object>} data - Set of gallery items.\n     */\n    var getMainImageIndex = function (data) {\n            var mainIndex;\n            if (_.every(data, function (item) {\n                    return _.isObject(item);\n                })\n            ) {\n                mainIndex = _.findIndex(data, function (item) {\n                    return item.isMain;\n                });\n            }\n            return mainIndex > 0 ? mainIndex : 0;\n        },\n\n        /**\n         * Helper for parse translate property\n         *\n         * @param {Element} el - el that to parse\n         * @returns {Array} - array of properties.\n         */\n        getTranslate = function (el) {\n            var slideTransform = $(el).attr('style').split(';');\n\n            slideTransform = $.map(slideTransform, function (style) {\n                style = style.trim();\n\n                if (style.startsWith('transform: translate3d')) {\n                    return style.match(/transform: translate3d\\((.+)px,(.+)px,(.+)px\\)/);\n                }\n\n                return false;\n            });\n\n            return slideTransform.filter(Boolean);\n        },\n\n        _toNumber = function (str) {\n\n            var type = typeof(str);\n\n            if (type === 'string') {\n                return parseInt(str);\n            } else {\n                return str;\n            }\n        };\n\n    return Class.extend({\n\n        defaults: {\n            settings: {},\n            config: {},\n            startConfig: {}\n        },\n\n        /**\n         * Checks if device has touch interface.\n         * @return {Boolean} The result of searching touch events on device.\n         */\n        isTouchEnabled: (function () {\n            return 'ontouchstart' in document.documentElement;\n        })(),\n\n        /**\n         * Initializes gallery.\n         * @param {Object} config - Gallery configuration.\n         * @param {String} element - String selector of gallery DOM element.\n         */\n        initialize: function (config, element) {\n            var self = this;\n\n            this._super();\n\n            _.bindAll(this,\n                '_focusSwitcher'\n            );\n\n            /*turn off arrows for touch devices*/\n            if (this.isTouchEnabled) {\n                config.options.arrows = false;\n\n                if (config.fullscreen) {\n                    config.fullscreen.arrows = false;\n                }\n            }\n\n            config.options.width = _toNumber(config.options.width);\n            config.options.height = _toNumber(config.options.height);\n            config.options.thumbwidth = _toNumber(config.options.thumbwidth);\n            config.options.thumbheight = _toNumber(config.options.thumbheight);\n\n            config.options.swipe = true;\n            this.config = config;\n\n            this.settings = {\n                $element: $(element),\n                $pageWrapper: $('body>.page-wrapper'),\n                currentConfig: config,\n                defaultConfig: _.clone(config),\n                fullscreenConfig: _.clone(config.fullscreen),\n                breakpoints: config.breakpoints,\n                activeBreakpoint: {},\n                fotoramaApi: null,\n                isFullscreen: false,\n                api: null,\n                data: _.clone(config.data)\n            };\n            config.options.ratio = config.options.width / config.options.height;\n            config.options.height = null;\n\n            $.extend(true, this.startConfig, config);\n\n            this.initGallery();\n            this.initApi();\n            this.setupBreakpoints();\n            this.initFullscreenSettings();\n\n            this.settings.$element.on('mouseup', '.fotorama__stage__frame', function () {\n                if (\n                    !$(this).parents('.fotorama__shadows--left, .fotorama__shadows--right').length &&\n                    !$(this).hasClass('fotorama-video-container')\n                ) {\n                    self.openFullScreen();\n                }\n            });\n\n            if (this.isTouchEnabled) {\n                this.settings.$element.on('tap', '.fotorama__stage__frame', function () {\n                    var translate = getTranslate($(this).parents('.fotorama__stage__shaft'));\n\n                    if (translate[1] === '0' && !$(this).hasClass('fotorama-video-container')) {\n                        self.openFullScreen();\n                        self.settings.$pageWrapper.hide();\n                    }\n                });\n            }\n        },\n\n        /**\n         * Open gallery fullscreen\n         */\n        openFullScreen: function () {\n            this.settings.api.fotorama.requestFullScreen();\n            this.settings.$fullscreenIcon.css({\n                opacity: 1,\n                visibility: 'visible',\n                display: 'block'\n            });\n        },\n\n        /**\n         * Gallery fullscreen settings.\n         */\n        initFullscreenSettings: function () {\n            var settings = this.settings,\n                self = this;\n\n            settings.$gallery = this.settings.$element.find('[data-gallery-role=\"gallery\"]');\n            settings.$fullscreenIcon = this.settings.$element.find('[data-gallery-role=\"fotorama__fullscreen-icon\"]');\n            settings.focusableStart = this.settings.$element.find('[data-gallery-role=\"fotorama__focusable-start\"]');\n            settings.focusableEnd = this.settings.$element.find('[data-gallery-role=\"fotorama__focusable-end\"]');\n            settings.closeIcon = this.settings.$element.find('[data-gallery-role=\"fotorama__fullscreen-icon\"]');\n            settings.fullscreenConfig.swipe = true;\n\n            settings.$gallery.on('fotorama:fullscreenenter', function () {\n                settings.closeIcon.show();\n                settings.focusableStart.attr('tabindex', '0');\n                settings.focusableEnd.attr('tabindex', '0');\n                settings.focusableStart.bind('focusin', self._focusSwitcher);\n                settings.focusableEnd.bind('focusin', self._focusSwitcher);\n                settings.api.updateOptions(settings.defaultConfig.options, true);\n                settings.api.updateOptions(settings.fullscreenConfig, true);\n\n                if (!_.isEqual(settings.activeBreakpoint, {}) && settings.breakpoints) {\n                    settings.api.updateOptions(settings.activeBreakpoint.options, true);\n                }\n                settings.isFullscreen = true;\n            });\n\n            settings.$gallery.on('fotorama:fullscreenexit', function () {\n                settings.closeIcon.hide();\n                settings.focusableStart.attr('tabindex', '-1');\n                settings.focusableEnd.attr('tabindex', '-1');\n                settings.api.updateOptions(settings.defaultConfig.options, true);\n                settings.focusableStart.unbind('focusin', this._focusSwitcher);\n                settings.focusableEnd.unbind('focusin', this._focusSwitcher);\n                settings.closeIcon.hide();\n\n                if (!_.isEqual(settings.activeBreakpoint, {}) && settings.breakpoints) {\n                    settings.api.updateOptions(settings.activeBreakpoint.options, true);\n                }\n                settings.isFullscreen = false;\n                settings.$element.data('gallery').updateOptions({\n                    swipe: true\n                });\n            });\n        },\n\n        /**\n         * Switcher focus.\n         */\n        _focusSwitcher: function (e) {\n            var target = $(e.target),\n                settings = this.settings;\n\n            if (target.is(settings.focusableStart)) {\n                this._setFocus('start');\n            } else if (target.is(settings.focusableEnd)) {\n                this._setFocus('end');\n            }\n        },\n\n        /**\n         * Set focus to element.\n         * @param {String} position - can be \"start\" and \"end\"\n         *      positions.\n         *      If position is \"end\" - sets focus to first\n         *      focusable element in modal window scope.\n         *      If position is \"start\" - sets focus to last\n         *      focusable element in modal window scope\n         */\n        _setFocus: function (position) {\n            var settings = this.settings,\n                focusableElements,\n                infelicity;\n\n            if (position === 'end') {\n                settings.$gallery.find(settings.closeIcon).focus();\n            } else if (position === 'start') {\n                infelicity = 3; //Constant for find last focusable element\n                focusableElements = settings.$gallery.find(':focusable');\n                focusableElements.eq(focusableElements.length - infelicity).focus();\n            }\n        },\n\n        /**\n         * Initializes gallery with configuration options.\n         */\n        initGallery: function () {\n            var breakpoints = {},\n                settings = this.settings,\n                config = this.config,\n                tpl = template(galleryTpl, {\n                    next: $t('Next'),\n                    previous: $t('Previous')\n                }),\n                mainImageIndex;\n\n            if (settings.breakpoints) {\n                _.each(_.values(settings.breakpoints), function (breakpoint) {\n                    var conditions;\n\n                    _.each(_.pairs(breakpoint.conditions), function (pair) {\n                        conditions = conditions ? conditions + ' and (' + pair[0] + ': ' + pair[1] + ')' :\n                        '(' + pair[0] + ': ' + pair[1] + ')';\n                    });\n                    breakpoints[conditions] = breakpoint.options;\n                });\n                settings.breakpoints = breakpoints;\n            }\n\n            _.extend(config, config.options);\n            config.options = undefined;\n\n            config.click = false;\n            config.breakpoints = null;\n            settings.currentConfig = config;\n            settings.$element.html(tpl);\n            settings.$element.removeClass('_block-content-loading');\n            settings.$elementF = $(settings.$element.children()[0]);\n            settings.$elementF.fotorama(config);\n            settings.fotoramaApi = settings.$elementF.data('fotorama');\n            $.extend(true, config, this.startConfig);\n\n            mainImageIndex = getMainImageIndex(config.data);\n            if (mainImageIndex) {\n                this.settings.fotoramaApi.show(mainImageIndex);\n            }\n        },\n\n        /**\n         * Creates breakpoints for gallery.\n         */\n        setupBreakpoints: function () {\n            var pairs,\n                settings = this.settings,\n                config = this.config,\n                startConfig = this.startConfig,\n                triggeredBreakpoints = 0,\n                isTouchEnabled = this.isTouchEnabled;\n\n            if (_.isObject(settings.breakpoints)) {\n                pairs = _.pairs(settings.breakpoints);\n                _.each(pairs, function (pair) {\n                    mediaCheck({\n                        media: pair[0],\n\n                        /**\n                         * Is triggered when breakpoint enties.\n                         */\n                        entry: function () {\n                            $.extend(true, config, _.clone(startConfig));\n\n                            settings.api.updateOptions(settings.defaultConfig.options, true);\n\n                            if (settings.isFullscreen) {\n                                settings.api.updateOptions(settings.fullscreenConfig, true);\n                            }\n\n                            if (isTouchEnabled) {\n                                settings.breakpoints[pair[0]].options.arrows = false;\n                                if (settings.breakpoints[pair[0]].options.fullscreen) {\n                                    settings.breakpoints[pair[0]].options.fullscreen.arrows = false;\n                                }\n                            }\n\n                            settings.api.updateOptions(settings.breakpoints[pair[0]].options, true);\n                            $.extend(true, config, settings.breakpoints[pair[0]]);\n                            settings.activeBreakpoint = settings.breakpoints[pair[0]];\n                        },\n\n                        /**\n                         * Is triggered when breakpoint exits.\n                         */\n                        exit: function () {\n                            $.extend(true, config, _.clone(startConfig));\n                            settings.api.updateOptions(settings.defaultConfig.options, true);\n\n                            if (settings.isFullscreen) {\n                                settings.api.updateOptions(settings.fullscreenConfig, true);\n                            }\n                            settings.activeBreakpoint = {};\n                        }\n                    });\n                });\n            }\n        },\n\n        /**\n         * Creates gallery's API.\n         */\n        initApi: function () {\n            var settings = this.settings,\n                config = this.config,\n                api = {\n\n                    /**\n                     * Contains fotorama's API methods.\n                     */\n                    fotorama: settings.fotoramaApi,\n\n                    /**\n                     * Displays the last image on preview.\n                     */\n                    last: function () {\n                        settings.fotoramaApi.show('>>');\n                    },\n\n                    /**\n                     * Displays the first image on preview.\n                     */\n                    first: function () {\n                        settings.fotoramaApi.show('<<');\n                    },\n\n                    /**\n                     * Displays previous element on preview.\n                     */\n                    prev: function () {\n                        settings.fotoramaApi.show('<');\n                    },\n\n                    /**\n                     * Displays next element on preview.\n                     */\n                    next: function () {\n                        settings.fotoramaApi.show('>');\n                    },\n\n                    /**\n                     * Displays image with appropriate count number on preview.\n                     * @param {Number} index - Number of image that should be displayed.\n                     */\n                    seek: function (index) {\n                        if (_.isNumber(index) && index !== 0) {\n\n                            if (index > 0) {\n                                index -= 1;\n                            }\n                            settings.fotoramaApi.show(index);\n                        }\n                    },\n\n                    /**\n                     * Updates gallery with new set of options.\n                     * @param {Object} configuration - Standart gallery configuration object.\n                     * @param {Boolean} isInternal - Is this function called via breakpoints.\n                     */\n                    updateOptions: function (configuration, isInternal) {\n\n                        var $selectable = \n                                $('a[href], area[href], input, select, textarea, button, iframe, object, embed, *[tabindex], *[contenteditable]')\n                                .not('[tabindex=-1], [disabled], :hidden'),\n                            fotorama = settings.fotoramaApi,\n                            $focus = $(':focus'),\n                            index;\n\n                        if (_.isObject(configuration)) {\n\n                            //Saves index of focus\n                            $selectable.each(function (number) {\n            \n                                if ($(this).is($focus)) {\n                                    index = number;\n                                }\n                            });\n\n                            if (this.isTouchEnabled) {\n                                configuration.arrows = false;\n                            }\n                            configuration.click = false;\n                            configuration.breakpoints = null;\n\n                            if (!isInternal) {\n                                !_.isEqual(settings.activeBreakpoint, {} && settings.brekpoints) ?\n                                    $.extend(true, settings.activeBreakpoint.options, configuration) :\n\n                                    settings.isFullscreen ?\n                                        $.extend(true, settings.fullscreenConfig, configuration) :\n                                        $.extend(true, settings.defaultConfig.options, configuration);\n\n                            }\n                            $.extend(true, settings.currentConfig.options, configuration);\n                            settings.fotoramaApi.setOptions(settings.currentConfig.options);\n\n                            if (_.isNumber(index)) {\n                                $selectable.eq(index).focus();\n                            }\n                        }\n                    },\n\n                    /**\n                     * Updates gallery with specific set of items.\n                     * @param {Array.<Object>} data - Set of gallery items to update.\n                     */\n                    updateData: function (data) {\n                        if (_.isArray(data)) {\n                            settings.fotoramaApi.load(data);\n\n                            $.extend(false, settings, {\n                                data: data,\n                                defaultConfig: data\n                            });\n                            $.extend(false, config, {\n                                data: data\n                            });\n                        }\n                    },\n\n                    /**\n                     * Returns current images list\n                     *\n                     * @returns {Array}\n                     */\n                    returnCurrentImages: function () {\n                        var images = [];\n\n                        _.each(this.fotorama.data, function (item) {\n                            images.push(_.omit(item, '$navThumbFrame', '$navDotFrame', '$stageFrame', 'labelledby'));\n                        });\n\n                        return images;\n                    },\n\n                    /**\n                     * Updates gallery data partially by index\n                     * @param {Number} index - Index of image in data array to be updated.\n                     * @param {Object} item - Standart gallery image object.\n                     *\n                     */\n                    updateDataByIndex: function(index, item){\n                        settings.fotoramaApi.spliceByIndex(index, item);\n                    }\n                };\n\n            settings.$element.data('gallery', api);\n            settings.api = settings.$element.data('gallery');\n            settings.$element.trigger('gallery:loaded');\n        }\n    });\n});\n","mage/requirejs/resolver.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'domReady!'\n], function (_) {\n    'use strict';\n\n    var context     = require.s.contexts._,\n        execCb      = context.execCb,\n        registry    = context.registry,\n        callbacks   = [],\n        retries     = 10,\n        updateDelay = 1,\n        ready,\n        update;\n\n    /**\n     * Checks if provided callback already exists in the callbacks list.\n     *\n     * @param {Object} callback - Callback object to be checked.\n     * @returns {Boolean}\n     */\n    function isSubscribed(callback) {\n        return !!_.findWhere(callbacks, callback);\n    }\n\n    /**\n     * Checks if provided module has unresolved dependencies.\n     *\n     * @param {Object} module - Module to be checked.\n     * @returns {Boolean}\n     */\n    function isPending(module) {\n        return !!module.depCount;\n    }\n\n    /**\n     * Checks if requirejs's registry object contains pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function hasPending() {\n        return _.some(registry, isPending);\n    }\n\n    /**\n     * Checks if 'resolver' module is in ready\n     * state and that there are no pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function isReady() {\n        return ready && !hasPending();\n    }\n\n    /**\n     * Invokes provided callback handler.\n     *\n     * @param {Object} callback\n     */\n    function invoke(callback) {\n        callback.handler.call(callback.ctx);\n    }\n\n    /**\n     * Sets 'resolver' module to a ready state\n     * and invokes pending callbacks.\n     */\n    function resolve() {\n        ready = true;\n\n        callbacks.splice(0).forEach(invoke);\n    }\n\n    /**\n     * Drops 'ready' flag and runs the update process.\n     */\n    function tick() {\n        ready = false;\n\n        update(retries);\n    }\n\n    /**\n     * Adds callback which will be invoked\n     * when all of the pending modules are initiated.\n     *\n     * @param {Function} handler - 'Ready' event handler function.\n     * @param {Object} [ctx] - Optional context with which handler\n     *      will be invoked.\n     */\n    function subscribe(handler, ctx) {\n        var callback = {\n            handler: handler,\n            ctx: ctx\n        };\n\n        if (!isSubscribed(callback)) {\n            callbacks.push(callback);\n\n            if (isReady()) {\n                _.defer(tick);\n            }\n        }\n    }\n\n    /**\n     * Checks for all modules to be initiated\n     * and invokes pending callbacks if it's so.\n     *\n     * @param {Number} [retry] - Number of retries\n     *      that will be used to repeat the 'update' function\n     *      invokation in case if there are no pending requests.\n     */\n    update = _.debounce(function (retry) {\n        if (!hasPending()) {\n            retry ? update(--retry) : resolve();\n        }\n    }, updateDelay);\n\n    /**\n     * Overrides requirejs's original 'execCb' method\n     * in order to track pending modules.\n     *\n     * @returns {*} Result of original method call.\n     */\n    context.execCb = function () {\n        var exported = execCb.apply(context, arguments);\n\n        tick();\n\n        return exported;\n    };\n\n    return subscribe;\n});\n","mage/requirejs/text.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* inspired by http://github.com/requirejs/text */\n/*global XMLHttpRequest, XDomainRequest */\n\ndefine(['module'], function (module) {\n    'use strict';\n\n    var xmlRegExp = /^\\s*<\\?xml(\\s)+version=[\\'\\\"](\\d)*.(\\d)*[\\'\\\"](\\s)*\\?>/im,\n        bodyRegExp = /<body[^>]*>\\s*([\\s\\S]+)\\s*<\\/body>/im,\n        stripReg = /!strip$/i,\n        defaultConfig = module.config && module.config() || {};\n\n    /**\n     * Strips <?xml ...?> declarations so that external SVG and XML documents can be\n     * added to a document without worry.\n     * Also, if the string is an HTML document, only the part inside the body tag is returned.\n     *\n     * @param {String} external\n     * @returns {String}\n     */\n    function stripContent(external) {\n        var matches;\n\n        if (!external) {\n            return '';\n        }\n\n        matches = external.match(bodyRegExp);\n        external = matches ?\n            matches[1] :\n            external.replace(xmlRegExp, '');\n\n        return external;\n    }\n\n    /**\n     * Checks that url match current location\n     *\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    function sameDomain(url) {\n        var uProtocol, uHostName, uPort,\n            xdRegExp = /^([\\w:]+)?\\/\\/([^\\/\\\\]+)/i,\n            location = window.location,\n            match = xdRegExp.exec(url);\n\n        if (!match) {\n            return true;\n        }\n        uProtocol = match[1];\n        uHostName = match[2];\n\n        uHostName = uHostName.split(':');\n        uPort = uHostName[1] || '';\n        uHostName = uHostName[0];\n\n        return (!uProtocol || uProtocol === location.protocol) &&\n            (!uHostName || uHostName.toLowerCase() === location.hostname.toLowerCase()) &&\n            (!uPort && !uHostName || uPort === location.port);\n    }\n\n    /**\n     * @returns {XMLHttpRequest|XDomainRequest|null}\n     */\n    function createRequest(url) {\n        var xhr = new XMLHttpRequest();\n\n        if (!sameDomain(url) && typeof XDomainRequest !== 'undefined') {\n            xhr = new XDomainRequest();\n        }\n\n        return xhr;\n    }\n\n    /**\n     * XHR requester. Returns value to callback.\n     *\n     * @param {String} url\n     * @param {Function} callback\n     * @param {Function} fail\n     * @param {Object} headers\n     */\n    function getContent(url, callback, fail, headers) {\n        var xhr = createRequest(url),\n            header,\n            errorHandler = fail || Function();\n\n        /*eslint-disable max-depth */\n        if ('setRequestHeader' in xhr && headers) {\n            for (header in headers) {\n                if (headers.hasOwnProperty(header)) {\n                    xhr.setRequestHeader(header.toLowerCase(), headers[header]);\n                }\n            }\n        }\n\n        /*eslint-enable max-depth */\n\n        if (defaultConfig.onXhr) {\n            defaultConfig.onXhr(xhr, url);\n        }\n\n        /**\n         * onload handler\n         */\n        xhr.onload = function () {\n\n            callback(xhr.responseText);\n\n            if (defaultConfig.onXhrComplete) {\n                defaultConfig.onXhrComplete(xhr, url);\n            }\n        };\n\n        /**\n         * onerror handler\n         */\n        xhr.onerror = function (event) {\n            errorHandler(event);\n\n            if (defaultConfig.onXhrFailure) {\n                defaultConfig.onXhrFailure(xhr, url, event);\n            }\n        };\n\n        xhr.open('GET', url);\n        xhr.send();\n    }\n\n    /**\n     * Main method used by RequireJs.\n     *\n     * @param {String} name - has format: some.module.filext!strip\n     * @param {Function} req\n     * @param {Function|undefined} onLoad\n     */\n    function loadContent(name, req, onLoad) {\n\n        var toStrip = stripReg.test(name),\n            url = req.toUrl(name.replace(stripReg, '')),\n            headers = defaultConfig.headers;\n\n        getContent(url, function (content) {\n                content = toStrip ? stripContent(content) : content;\n                onLoad(content);\n            }, onLoad.error, headers);\n    }\n\n    return {\n        load: loadContent,\n        get: getContent\n    };\n});\n","mage/utils/arrays.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    './strings'\n], function (_, utils) {\n    'use strict';\n\n    /**\n     * Defines index of an item in a specified container.\n     *\n     * @param {*} item - Item whose index should be defined.\n     * @param {Array} container - Container upon which to perform search.\n     * @returns {Number}\n     */\n    function getIndex(item, container) {\n        var index = container.indexOf(item);\n\n        if (~index) {\n            return index;\n        }\n\n        return _.findIndex(container, function (value) {\n            return value && value.name === item;\n        });\n    }\n\n    return {\n       /**\n         * Facade method to remove/add value from/to array\n         * without creating a new instance.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to add/remove.\n         * @param {Boolean} add - Flag that specfies operation.\n         * @returns {Utils} Chainable.\n         */\n        toggle: function (arr, value, add) {\n            return add ?\n                this.add(arr, value) :\n                this.remove(arr, value);\n        },\n\n        /**\n         * Removes the incoming value from array in case\n         * without creating a new instance of it.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to be removed.\n         * @returns {Utils} Chainable.\n         */\n        remove: function (arr, value) {\n            var index = arr.indexOf(value);\n\n            if (~index) {\n                arr.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds the incoming value to array if\n         * it's not alredy present in there.\n         *\n         * @param {Array} arr - Array to be modifed.\n         * @param {...*} Values to be added.\n         * @returns {Utils} Chainable.\n         */\n        add: function (arr) {\n            var values = _.toArray(arguments).slice(1);\n\n            values.forEach(function (value) {\n                if (!~arr.indexOf(value)) {\n                    arr.push(value);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Inserts specified item into container at a specified position.\n         *\n         * @param {*} item - Item to be inserted into container.\n         * @param {Array} container - Container of items.\n         * @param {*} [position=-1] - Position at which item should be inserted.\n         *      Position can represent:\n         *          - specific index in container\n         *          - item which might already be present in container\n         *          - structure with one of these properties: after, before\n         * @returns {Boolean|*}\n         *      - true if element has changed its' position\n         *      - false if nothing has changed\n         *      - inserted value if it wasn't present in container\n         */\n        insert: function (item, container, position) {\n            var currentIndex = getIndex(item, container),\n                newIndex,\n                target;\n\n            if (typeof position === 'undefined') {\n                position = -1;\n            } else if (typeof position === 'string') {\n                position = isNaN(+position) ? position : +position;\n            }\n\n            newIndex = position;\n\n            if (~currentIndex) {\n                target = container.splice(currentIndex, 1)[0];\n\n                if (typeof item === 'string') {\n                    item = target;\n                }\n            }\n\n            if (typeof position !== 'number') {\n                target = position.after || position.before || position;\n\n                newIndex = getIndex(target, container);\n\n                if (~newIndex && (position.after || newIndex >= currentIndex)) {\n                    newIndex++;\n                }\n            }\n\n            if (newIndex < 0) {\n                newIndex += container.length + 1;\n            }\n\n            container[newIndex] ?\n                container.splice(newIndex, 0, item) :\n                container[newIndex] = item;\n\n            return !~currentIndex ? item : currentIndex !== newIndex;\n        },\n\n        formatOffset: function (elems, offset) {\n            if (utils.isEmpty(offset)) {\n                offset = -1;\n            }\n\n            offset = +offset;\n\n            if (offset < 0) {\n                offset += elems.length + 1;\n            }\n\n            return offset;\n        }\n    };\n});\n","mage/utils/compare.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mage/utils/objects'\n], function (_, utils) {\n    'use strict';\n\n    var result = [];\n\n    /**\n     * Checks if all of the provided arrays contains equal values.\n     *\n     * @param {(Boolean|Array)} [keepOrder=false]\n     * @param {Array} target\n     * @returns {Boolean}\n     */\n    function equalArrays(keepOrder, target) {\n        var args = _.toArray(arguments),\n            arrays;\n\n        if (!Array.isArray(keepOrder)) {\n            arrays      = args.slice(2);\n        } else {\n            target      = keepOrder;\n            keepOrder   = false;\n            arrays      = args.slice(1);\n        }\n\n        if (!arrays.length) {\n            return true;\n        }\n\n        return arrays.every(function (array) {\n            if (array === target) {\n                return true;\n            } else if (array.length !== target.length) {\n                return false;\n            } else if (!keepOrder) {\n                return !_.difference(target, array).length;\n            }\n\n            return array.every(function (value, index) {\n                return target.indexOf(value) === index;\n            });\n        });\n    }\n\n    /**\n     * Checks if two values are different.\n     *\n     * @param {*} a - First value.\n     * @param {*} b - Second value.\n     * @returns {Boolean}\n     */\n    function isDifferent(a, b) {\n        var oldIsPrimitive = utils.isPrimitive(a);\n\n        if (Array.isArray(a) && Array.isArray(b)) {\n            return !equalArrays(true, a, b);\n        }\n\n        return oldIsPrimitive ? a !== b : true;\n    }\n\n    /**\n     * @param {String} prefix\n     * @param {String} part\n     */\n    function getPath(prefix, part) {\n        return prefix ? prefix + '.' + part : part;\n    }\n\n    /**\n     * Checks if object has own specified property.\n     *\n     * @param {*} obj - Value to be checked.\n     * @param {String} key - Key of the property.\n     * @returns {Boolean}\n     */\n    function hasOwn(obj, key) {\n        return Object.prototype.hasOwnProperty.call(obj, key);\n    }\n\n    /**\n     * @param {Array} changes\n     */\n    function getContainers(changes) {\n        var containers  = {},\n            indexed     = _.indexBy(changes, 'path');\n\n        _.each(indexed, function (change, name) {\n            var path;\n\n            name.split('.').forEach(function (part) {\n                path = getPath(path, part);\n\n                if (path in indexed) {\n                    return;\n                }\n\n                (containers[path] = containers[path] || []).push(change);\n            });\n        });\n\n        return containers;\n    }\n\n    /**\n     * @param {String} path\n     * @param {String} name\n     * @param {String} type\n     * @param {String} newValue\n     * @param {String} oldValue\n     */\n    function addChange(path, name, type, newValue, oldValue) {\n        var data;\n\n        data = {\n            path: path,\n            name: name,\n            type: type\n        };\n\n        if (type !== 'remove') {\n            data.value = newValue;\n            data.oldValue = oldValue;\n        } else {\n            data.oldValue = newValue;\n        }\n\n        result.push(data);\n    }\n\n    /**\n     * @param {String} ns\n     * @param {String} name\n     * @param {String} type\n     * @param {String} iterator\n     * @param {String} placeholder\n     */\n    function setAll(ns, name, type, iterator, placeholder) {\n        var key;\n\n        if (arguments.length > 4) {\n            type === 'add' ?\n                addChange(ns, name, 'update', iterator, placeholder) :\n                addChange(ns, name, 'update', placeholder, iterator);\n        } else {\n            addChange(ns, name, type, iterator);\n        }\n\n        if (!utils.isObject(iterator)) {\n            return;\n        }\n\n        for (key in iterator) {\n            if (hasOwn(iterator, key)) {\n                setAll(getPath(ns, key), key, type, iterator[key]);\n            }\n        }\n    }\n\n    /*eslint-disable max-depth*/\n    /**\n     * @param {Object} old\n     * @param {Object} current\n     * @param {String} ns\n     * @param {String} name\n     */\n    function compare(old, current, ns, name) {\n        var key,\n            oldIsObj = utils.isObject(old),\n            newIsObj = utils.isObject(current);\n\n        if (oldIsObj && newIsObj) {\n            for (key in old) {\n                if (hasOwn(old, key) && !hasOwn(current, key)) {\n                    setAll(getPath(ns, key), key, 'remove', old[key]);\n                }\n            }\n\n            for (key in current) {\n                if (hasOwn(current, key)) {\n                    hasOwn(old, key) ?\n                        compare(old[key], current[key], getPath(ns, key), key) :\n                        setAll(getPath(ns, key), key, 'add', current[key]);\n                }\n            }\n        } else if (oldIsObj) {\n            setAll(ns, name, 'remove', old, current);\n        } else if (newIsObj) {\n            setAll(ns, name, 'add', current, old);\n        } else if (isDifferent(old, current)) {\n            addChange(ns, name, 'update', current, old);\n        }\n    }\n\n    /*eslint-enable max-depth*/\n\n    return {\n\n        /**\n         *\n         * @returns {Object}\n         */\n        compare: function () {\n            var changes;\n\n            compare.apply(null, arguments);\n\n            changes = result.splice(0);\n\n            return {\n                containers: getContainers(changes),\n                changes: changes,\n                equal: !changes.length\n            };\n        },\n\n        equalArrays: equalArrays\n    };\n});\n","mage/utils/misc.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'FormData'\n], function (_, $) {\n    'use strict';\n\n    var defaultAttributes,\n        ajaxSettings,\n        map;\n\n    defaultAttributes = {\n        method: 'post',\n        enctype: 'multipart/form-data'\n    };\n\n    ajaxSettings = {\n        default: {\n            method: 'POST',\n            cache: false,\n            processData: false,\n            contentType: false\n        },\n        simple: {\n            method: 'POST',\n            dataType: 'json'\n        }\n    };\n\n    map = {\n        'D': 'DDD',\n        'dd': 'DD',\n        'd': 'D',\n        'EEEE': 'dddd',\n        'EEE': 'ddd',\n        'e': 'd',\n        'y': 'YYYY',\n        'a': 'A'\n    };\n\n    return {\n\n        /**\n         * Generates a unique identifier.\n         *\n         * @param {Number} [size=7] - Length of a resulting identifier.\n         * @returns {String}\n         */\n        uniqueid: function (size) {\n            var code = Math.random() * 25 + 65 | 0,\n                idstr = String.fromCharCode(code);\n\n            size = size || 7;\n\n            while (idstr.length < size) {\n                code = Math.floor(Math.random() * 42 + 48);\n\n                if (code < 58 || code > 64) {\n                    idstr += String.fromCharCode(code);\n                }\n            }\n\n            return idstr;\n        },\n\n        /**\n         * Limits function call.\n         *\n         * @param {Object} owner\n         * @param {String} target\n         * @param {Number} limit\n         */\n        limit: function (owner, target, limit) {\n            var fn = owner[target];\n\n            owner[target] = _.debounce(fn.bind(owner), limit);\n        },\n\n        /**\n         * Converts mage date format to a moment.js format.\n         *\n         * @param {String} mageFormat\n         * @returns {String}\n         */\n        normalizeDate: function (mageFormat) {\n            var result = mageFormat;\n\n            _.each(map, function (moment, mage) {\n                result = result.replace(mage, moment);\n            });\n\n            return result;\n        },\n\n        /**\n         * Puts provided value in range of min and max parameters.\n         *\n         * @param {Number} value - Value to be located.\n         * @param {Number} min - Min value.\n         * @param {Number} max - Max value.\n         * @returns {Number}\n         */\n        inRange: function (value, min, max) {\n            return Math.min(Math.max(min, value), max);\n        },\n\n        /**\n         * Serializes and sends data via POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} attrs - Attributes that will be added to virtual form.\n         */\n        submit: function (options, attrs) {\n            var form        = document.createElement('form'),\n                data        = this.serialize(options.data),\n                attributes  = _.extend({}, defaultAttributes, attrs || {}),\n                field;\n\n            if (!attributes.action) {\n                attributes.action = options.url;\n            }\n\n            data['form_key'] = window.FORM_KEY;\n\n            _.each(attributes, function (value, name) {\n                form.setAttribute(name, value);\n            });\n\n            _.each(data, function (value, name) {\n                field = document.createElement('input');\n\n                field.setAttribute('name', name);\n                field.setAttribute('type', 'hidden');\n\n                field.value = value;\n\n                form.appendChild(field);\n            });\n\n            document.body.appendChild(form);\n\n            form.submit();\n        },\n\n        /**\n         * Serializes and sends data via AJAX POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} config\n         */\n        ajaxSubmit: function (options, config) {\n            var t = new Date().getTime(),\n                settings;\n\n            options.data['form_key'] = window.FORM_KEY;\n            options.data = this.prepareFormData(options.data, config.ajaxSaveType);\n            settings = _.extend({}, ajaxSettings[config.ajaxSaveType], options || {});\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (data) {\n                    data.t = t;\n                    config.response.data(data);\n                    config.response.status(undefined);\n                    config.response.status(!data.error);\n                })\n                .fail(function (xhr) {\n                    config.response.status(undefined);\n                    config.response.status(false);\n                    config.response.data({\n                        error: true,\n                        messages: xhr.statusText,\n                        t: t\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n        },\n\n        /**\n         * Creates FormData object and append this data.\n         *\n         * @param {Object} data\n         * @param {String} type\n         * @returns {FormData}\n         */\n        prepareFormData: function (data, type) {\n            var formData;\n\n            if (type === 'default') {\n                formData = new FormData();\n                _.each(this.serialize(data), function (val, name) {\n                    formData.append(name, val);\n                });\n            } else if (type === 'simple') {\n                formData = this.serialize(data);\n            }\n\n            return formData;\n        }\n    };\n});\n","mage/utils/objects.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore'\n], function (ko, $, _) {\n    'use strict';\n\n    var primitives = [\n        'undefined',\n        'boolean',\n        'number',\n        'string'\n    ];\n\n    /**\n     * Sets nested property of a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @param {*} value - Value of the last property in 'path' array.\n     * returns {*} New value for the property.\n     */\n    function setNested(parent, path, value) {\n        var last = path.pop(),\n            len = path.length,\n            pi = 0,\n            part = path[pi];\n\n        for (; pi < len; part = path[++pi]) {\n            if (!_.isObject(parent[part])) {\n                parent[part] = {};\n            }\n\n            parent = parent[part];\n        }\n\n        if (typeof parent[last] === 'function') {\n            parent[last](value);\n        } else {\n            parent[last] = value;\n        }\n\n        return value;\n    }\n\n    /**\n     * Retrieves value of a nested property.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @returns {*} Value of the property.\n     */\n    function getNested(parent, path) {\n        var exists = true,\n            len = path.length,\n            pi = 0;\n\n        for (; pi < len && exists; pi++) {\n            parent = parent[path[pi]];\n\n            if (typeof parent === 'undefined') {\n                exists = false;\n            }\n        }\n\n        if (exists) {\n            if (ko.isObservable(parent)) {\n                parent = parent();\n            }\n\n            return parent;\n        }\n    }\n\n    /**\n     * Removes property from a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object from which to remove property.\n     * @param {Array} path - Splitted path to the propery.\n     */\n    function removeNested(parent, path) {\n        var field = path.pop();\n\n        parent = getNested(parent, path);\n\n        if (_.isObject(parent)) {\n            delete parent[field];\n        }\n    }\n\n    return {\n\n        /**\n         * Retrieves or defines objects' property by a composite path.\n         *\n         * @param {Object} data - Container for the properties specified in path.\n         * @param {String} path - Objects' properties divided by dots.\n         * @param {*} [value] - New value for the last property.\n         * @returns {*} Returns value of the last property in chain.\n         *\n         * @example\n         *      utils.nested({}, 'one.two', 3);\n         *      => { one: {two: 3} }\n         */\n        nested: function (data, path, value) {\n            var action = arguments.length > 2 ? setNested : getNested;\n\n            path = path ? path.split('.') : [];\n\n            return action(data, path, value);\n        },\n\n        /**\n         * Removes nested property from an object.\n         *\n         * @param {Object} data - Data source.\n         * @param {String} path - Path to the property e.g. 'one.two.three'\n         */\n        nestedRemove: function (data, path) {\n            path = path.split('.');\n\n            removeNested(data, path);\n        },\n\n        /**\n         * Flattens objects' nested properties.\n         *\n         * @param {Object} data - Object to flatten.\n         * @param {String} [separator='.'] - Objects' keys separator.\n         * @returns {Object} Flattened object.\n         *\n         * @example Example with a default separator.\n         *      utils.flatten({one: { two: { three: 'value'} }});\n         *      => { 'one.two.three': 'value' };\n         *\n         * @example Example with a custom separator.\n         *      utils.flatten({one: { two: { three: 'value'} }}, '=>');\n         *      => {'one=>two=>three': 'value'};\n         */\n        flatten: function (data, separator, parent, result) {\n            separator = separator || '.';\n            result = result || {};\n\n            _.each(data, function (node, name) {\n                if (parent) {\n                    name = parent + separator + name;\n                }\n\n                typeof node === 'object' ?\n                    this.flatten(node, separator, name, result) :\n                    result[name] = node;\n\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Opposite operation of the 'flatten' method.\n         *\n         * @param {Object} data - Previously flattened object.\n         * @param {String} [separator='.'] - Keys separator.\n         * @returns {Object} Object with nested properties.\n         *\n         * @example Example using custom separator.\n         *      utils.unflatten({'one=>two': 'value'}, '=>');\n         *      => {\n         *          one: { two: 'value' }\n         *      };\n         */\n        unflatten: function (data, separator) {\n            var result = {};\n\n            separator = separator || '.';\n\n            _.each(data, function (value, nodes) {\n                nodes = nodes.split(separator);\n\n                setNested(result, nodes, value);\n            });\n\n            return result;\n        },\n\n        /**\n         * Same operation as 'flatten' method,\n         * but returns objects' keys wrapped in '[]'.\n         *\n         * @param {Object} data - Object that should be serialized.\n         * @returns {Object} Serialized data.\n         *\n         * @example\n         *      utils.serialize({one: { two: { three: 'value'} }});\n         *      => { 'one[two][three]': 'value' }\n         */\n        serialize: function (data) {\n            var result = {};\n\n            data = this.flatten(data);\n\n            _.each(data, function (value, keys) {\n                keys = this.serializeName(keys);\n                value = _.isUndefined(value) ? '' : value;\n\n                result[keys] = value;\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Performs deep extend of specified objects.\n         *\n         * @returns {Object|Array} Extended object.\n         */\n        extend: function () {\n            var args = _.toArray(arguments);\n\n            args.unshift(true);\n\n            return $.extend.apply($, args);\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         *\n         * @param {(Object|Array)} data - Data that should be copied.\n         * @returns {Object|Array} Cloned object.\n         */\n        copy: function (data) {\n            var result = data,\n                isArray = Array.isArray(data),\n                placeholder;\n\n            if (this.isObject(data) || isArray) {\n                placeholder = isArray ? [] : {};\n                result = this.extend(placeholder, data);\n            }\n\n            return result;\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         * Doesn't save links to original object.\n         *\n         * @param {*} original - Object to clone\n         * @returns {*}\n         */\n        hardCopy: function (original) {\n            if (original === null || typeof original !== 'object') {\n                return original;\n            }\n\n            return JSON.parse(JSON.stringify(original));\n        },\n\n        /**\n         * Removes specified nested properties from the target object.\n         *\n         * @param {Object} target - Object whose properties should be removed.\n         * @param {(...String|Array|Object)} list - List that specifies properties to be removed.\n         * @returns {Object} Modified object.\n         *\n         * @example Basic usage\n         *      var obj = {a: {b: 2}, c: 'a'};\n         *\n         *      omit(obj, 'a.b');\n         *      => {'a.b': 2};\n         *      obj => {a: {}, c: 'a'};\n         *\n         * @example Various syntaxes that would return same result\n         *      omit(obj, ['a.b', 'c']);\n         *      omit(obj, 'a.b', 'c');\n         *      omit(obj, {'a.b': true, 'c': true});\n         */\n        omit: function (target, list) {\n            var removed = {},\n                ignored = list;\n\n            if (this.isObject(list)) {\n                ignored = [];\n\n                _.each(list, function (value, key) {\n                    if (value) {\n                        ignored.push(key);\n                    }\n                });\n            } else if (_.isString(list)) {\n                ignored = _.toArray(arguments).slice(1);\n            }\n\n            _.each(ignored, function (path) {\n                var value = this.nested(target, path);\n\n                if (!_.isUndefined(value)) {\n                    removed[path] = value;\n\n                    this.nestedRemove(target, path);\n                }\n            }, this);\n\n            return removed;\n        },\n\n        /**\n         * Checks if provided value is a plain object.\n         *\n         * @param {*} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isObject: function (value) {\n            var objProto = Object.prototype;\n\n            return typeof value == 'object' ?\n            objProto.toString.call(value) === '[object Object]' :\n                false;\n        },\n\n        /**\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isPrimitive: function (value) {\n            return value === null || ~primitives.indexOf(typeof value);\n        },\n\n        /**\n         * Iterates over obj props/array elems recursively, applying action to each one\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to be called with each item as an argument.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         */\n        forEachRecursive: function (data, action, maxDepth) {\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return;\n            }\n\n            if (!_.isObject(data)) {\n                action(data);\n\n                return;\n            }\n\n            _.each(data, function (value) {\n                this.forEachRecursive(value, action, maxDepth);\n            }, this);\n\n            action(data);\n        },\n\n        /**\n         * Maps obj props/array elems recursively\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to transform each item.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         *\n         * @returns {Object|Array}\n         */\n        mapRecursive: function (data, action, maxDepth) {\n            var newData;\n\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return data;\n            }\n\n            if (!_.isObject(data)) {\n                return action(data);\n            }\n\n            if (_.isArray(data)) {\n                newData = _.map(data, function (item) {\n                    return this.mapRecursive(item, action, maxDepth);\n                }, this);\n\n                return action(newData);\n            }\n\n            newData = _.mapObject(data, function (val, key) {\n                if (data.hasOwnProperty(key)) {\n                    return this.mapRecursive(val, action, maxDepth);\n                }\n\n                return val;\n            }, this);\n\n            return action(newData);\n        },\n\n        /**\n         * Removes empty(in common sence) obj props/array elems\n         *\n         * @param {*} data - Data to be cleaned.\n         * @returns {*}\n         */\n        removeEmptyValues: function (data) {\n            if (!_.isObject(data)) {\n                return data;\n            }\n\n            if (_.isArray(data)) {\n                return data.filter(function (item) {\n                    return !this.isEmptyObj(item);\n                }, this);\n            }\n\n            return _.omit(data, this.isEmptyObj.bind(this));\n        },\n\n        /**\n         * Checks that argument of any type is empty in common sence:\n         * empty string, string with spaces only, object without own props, empty array, null or undefined\n         *\n         * @param {*} val - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEmptyObj: function (val) {\n\n            return _.isObject(val) && _.isEmpty(val) ||\n            this.isEmpty(val) ||\n            val && val.trim && this.isEmpty(val.trim());\n        }\n    };\n});\n","mage/utils/strings.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var jsonRe = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/;\n\n    return {\n\n        /**\n         * Attempts to convert string to one of the primitive values,\n         * or to parse it as a valid json object.\n         *\n         * @param {String} str - String to be processed.\n         * @returns {*}\n         */\n        castString: function (str) {\n            try {\n                str = str === 'true' ? true :\n                    str === 'false' ? false :\n                        str === 'null' ? null :\n                            +str + '' === str ? +str :\n                                jsonRe.test(str) ? JSON.parse(str) :\n                                    str;\n            } catch (e) {\n            }\n\n            return str;\n        },\n\n        /**\n         * Splits string by separator if it's possible,\n         * otherwise returns the incoming value.\n         *\n         * @param {(String|Array|*)} str - String to split.\n         * @param {String} [separator=' '] - Seperator based on which to split the string.\n         * @returns {Array|*} Splitted string or the incoming value.\n         */\n        stringToArray: function (str, separator) {\n            separator = separator || ' ';\n\n            return typeof str === 'string' ?\n                str.split(separator) :\n                str;\n        },\n\n        /**\n         * Converts the incoming string which consists\n         * of a specified delimiters into a format commonly used in form elements.\n         *\n         * @param {String} name - The incoming string.\n         * @param {String} [separator='.']\n         * @returns {String} Serialized string.\n         *\n         * @example\n         *      utils.serializeName('one.two.three');\n         *      => 'one[two][three]';\n         */\n        serializeName: function (name, separator) {\n            var result;\n\n            separator = separator || '.';\n            name = name.split(separator);\n\n            result = name.shift();\n\n            name.forEach(function (part) {\n                result += '[' + part + ']';\n            });\n\n            return result;\n        },\n\n        /**\n         * Checks wether the incoming value is not empty,\n         * e.g. not 'null' or 'undefined'\n         *\n         * @param {*} value - Value to check.\n         * @returns {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || _.isUndefined(value) || _.isNull(value);\n        },\n\n        /**\n         * Adds 'prefix' to the 'part' value if it was provided.\n         *\n         * @param {String} prefix\n         * @param {String} part\n         * @returns {String}\n         */\n        fullPath: function (prefix, part) {\n            return prefix ? prefix + '.' + part : part;\n        },\n\n        /**\n         * Splits incoming string and returns its' part specified by offset.\n         *\n         * @param {String} parts\n         * @param {Number} [offset]\n         * @param {String} [delimiter=.]\n         * @returns {String}\n         */\n        getPart: function (parts, offset, delimiter) {\n            delimiter = delimiter || '.';\n            parts = parts.split(delimiter);\n            offset = this.formatOffset(parts, offset);\n\n            parts.splice(offset, 1);\n\n            return parts.join(delimiter) || '';\n        },\n\n        /**\n         * Converts nameThroughCamelCase to name-through-minus\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        camelCaseToMinus: function camelCaseToMinus(string) {\n            return ('' + string)\n                .split('')\n                .map(function (symbol, index) {\n                    return index ?\n                        symbol.toUpperCase() === symbol ?\n                        '-' + symbol.toLowerCase() :\n                            symbol :\n                        symbol.toLowerCase();\n                })\n                .join('');\n        },\n\n        /**\n         * Converts name-through-minus to nameThroughCamelCase\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        minusToCamelCase: function minusToCamelCase(string) {\n            return ('' + string)\n                .split('-')\n                .map(function (part, index) {\n                    return index ? part.charAt(0).toUpperCase() + part.slice(1) : part;\n                })\n                .join('');\n        }\n    };\n});\n","mage/utils/template.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/utils/objects',\n    'mage/utils/strings'\n], function (jQuery, _, utils, stringUtils) {\n    'use strict';\n\n    var tmplSettings = _.templateSettings,\n        interpolate = /\\$\\{([\\s\\S]+?)\\}/g,\n        opener = '${',\n        template,\n        hasStringTmpls;\n\n    /**\n     * Identifies whether ES6 templates are supported.\n     */\n    hasStringTmpls = (function () {\n        var testString = 'var foo = \"bar\"; return `${ foo }` === foo';\n\n        try {\n            return Function(testString)();\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    if (hasStringTmpls) {\n\n        /*eslint-disable no-unused-vars, no-eval*/\n        /**\n         * Evaluates template string using ES6 templates.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} $ - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, $) {\n            return eval('`' + tmpl + '`');\n        };\n\n        /*eslint-enable no-unused-vars, no-eval*/\n    } else {\n\n        /**\n         * Fallback function used when ES6 templates are not supported.\n         * Uses underscore templates renderer.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} data - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, data) {\n            var cached = tmplSettings.interpolate;\n\n            tmplSettings.interpolate = interpolate;\n\n            tmpl = _.template(tmpl, {\n                variable: '$'\n            })(data);\n\n            tmplSettings.interpolate = cached;\n\n            return tmpl;\n        };\n    }\n\n    /**\n     * Checks if provided value contains template syntax.\n     *\n     * @param {*} value - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isTemplate(value) {\n        return typeof value === 'string' && ~value.indexOf(opener);\n    }\n\n    /**\n     * Iteratively processes provided string\n     * until no templates syntax will be found.\n     *\n     * @param {String} tmpl - Template string.\n     * @param {Object} data - Data object used in a template.\n     * @param {Boolean} [castString=false] - Flag that indicates whether template\n     *      should be casted after evaluation to a value of another type or\n     *      that it should be leaved as a string.\n     * @returns {*} Compiled template.\n     */\n    function render(tmpl, data, castString) {\n        var last = tmpl;\n\n        while (~tmpl.indexOf(opener)) {\n            tmpl = template(tmpl, data);\n\n            if (tmpl === last) {\n                break;\n            }\n\n            last = tmpl;\n        }\n\n        return castString ?\n            stringUtils.castString(tmpl) :\n            tmpl;\n    }\n\n    return {\n\n        /**\n         * Applies provided data to the template.\n         *\n         * @param {Object|String} tmpl\n         * @param {Object} [data] - Data object to match with template.\n         * @param {Boolean} [castString=false] - Flag that indicates whether template\n         *      should be casted after evaluation to a value of another type or\n         *      that it should be leaved as a string.\n         * @returns {*}\n         *\n         * @example Template defined as a string.\n         *      var source = { foo: 'Random Stuff', bar: 'Some' };\n         *\n         *      utils.template('${ $.bar } ${ $.foo }', source);\n         *      => 'Some Random Stuff';\n         *\n         * @example Template defined as an object.\n         *      var tmpl = {\n         *              key: {'${ $.$data.bar }': '${ $.$data.foo }'},\n         *              foo: 'bar',\n         *              x1: 2, x2: 5,\n         *              delta: '${ $.x2 - $.x1 }',\n         *              baz: 'Upper ${ $.foo.toUpperCase() }'\n         *      };\n         *\n         *      utils.template(tmpl, source);\n         *      => {\n         *          key: {'Some': 'Random Stuff'},\n         *          foo: 'bar',\n         *          x1: 2, x2: 5,\n         *          delta: 3,\n         *          baz: 'Upper BAR'\n         *      };\n         */\n        template: function (tmpl, data, castString, dontClone) {\n            if (typeof tmpl === 'string') {\n                return render(tmpl, data, castString);\n            }\n\n            if (!dontClone) {\n                tmpl = utils.copy(tmpl);\n            }\n\n            tmpl.$data = data || {};\n\n            /**\n             * Template iterator function.\n             */\n            _.each(tmpl, function iterate(value, key, list) {\n                if (key === '$data') {\n                    return;\n                }\n\n                if (isTemplate(key)) {\n                    delete list[key];\n\n                    key = render(key, tmpl);\n                    list[key] = value;\n                }\n\n                if (isTemplate(value)) {\n                    list[key] = render(value, tmpl, castString);\n                } else if (jQuery.isPlainObject(value) || Array.isArray(value)) {\n                    _.each(value, iterate);\n                }\n            });\n\n            delete tmpl.$data;\n\n            return tmpl;\n        }\n    };\n});\n","mage/utils/wrapper.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Utility methods used to wrap and extend functions.\n *\n * @example Usage of a 'wrap' method with arguments delegation.\n *      var multiply = function (a, b) {\n *          return a * b;\n *      };\n *\n *      multiply = module.wrap(multiply, function (orig) {\n *          return 'Result is: ' + orig();\n *      });\n *\n *      multiply(2, 2);\n *      => 'Result is: 4'\n *\n * @example Usage of 'wrapSuper' method.\n *      var multiply = function (a, b) {\n *         return a * b;\n *      };\n *\n *      var obj = {\n *          multiply: module.wrapSuper(multiply, function () {\n *              return 'Result is: ' + this._super();\n *          });\n *      };\n *\n *      obj.multiply(2, 2);\n *      => 'Result is: 4'\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Checks if string has a '_super' substring.\n     */\n    var superReg = /\\b_super\\b/;\n\n    return {\n\n        /**\n         * Wraps target function with a specified wrapper, which will recieve\n         * reference to the original function as a first argument.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapper function.\n         */\n        wrap: function (target, wrapper) {\n            if (!_.isFunction(target) || !_.isFunction(wrapper)) {\n                return wrapper;\n            }\n\n            return function () {\n                var args    = _.toArray(arguments),\n                    ctx     = this,\n                    _super;\n\n                /**\n                 * Function that will be passed to the wrapper.\n                 * If no arguments will be passed to it, then the original\n                 * function will be called with an arguments of a wrapper function.\n                 */\n                _super = function () {\n                    var superArgs = arguments.length ? arguments : args.slice(1);\n\n                    return target.apply(ctx, superArgs);\n                };\n\n                args.unshift(_super);\n\n                return wrapper.apply(ctx, args);\n            };\n        },\n\n        /**\n         * Wraps the incoming function to implement support of the '_super' method.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapped function.\n         */\n        wrapSuper: function (target, wrapper) {\n            if (!this.hasSuper(wrapper) || !_.isFunction(target)) {\n                return wrapper;\n            }\n\n            return function () {\n                var _super  = this._super,\n                    args    = arguments,\n                    result;\n\n                /**\n                 * Temporary define '_super' method which\n                 * contains call to the original function.\n                 */\n                this._super = function () {\n                    var superArgs = arguments.length ? arguments : args;\n\n                    return target.apply(this, superArgs);\n                };\n\n                result = wrapper.apply(this, args);\n\n                this._super = _super;\n\n                return result;\n            };\n        },\n\n        /**\n         * Checks wether the incoming method contains calls of the '_super' method.\n         *\n         * @param {Function} fn - Function to be checked.\n         * @returns {Boolean}\n         */\n        hasSuper: function (fn) {\n            return _.isFunction(fn) && superReg.test(fn);\n        },\n\n        /**\n         * Extends target object with provided extenders.\n         * If property in target and extender objects is a function,\n         * then it will be wrapped using 'wrap' method.\n         *\n         * @param {Object} target - Object to be extended.\n         * @param {...Object} extenders - Multiple extenders objects.\n         * @returns {Object} Modified target object.\n         */\n        extend: function (target) {\n            var extenders = _.toArray(arguments).slice(1),\n                iterator = this._extend.bind(this, target);\n\n            extenders.forEach(iterator);\n\n            return target;\n        },\n\n        /**\n         * Same as the 'extend' method, but operates only on one extender object.\n         *\n         * @private\n         * @param {Object} target\n         * @param {Object} extender\n         */\n        _extend: function (target, extender) {\n            _.each(extender, function (value, key) {\n                target[key] = this.wrap(target[key], extender[key]);\n            }, this);\n        }\n    };\n});\n","mage/validation/url.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n\n        /**\n         * Redirects to the url if it is considered safe\n         *\n         * @param {String} path - url to be redirected to\n         */\n        redirect: function (path) {\n            path = this.sanitize(path);\n\n            if (this.validate(path)) {\n                window.location.href = path;\n            }\n        },\n\n        /**\n         * Validates url\n         *\n         * @param {Object} path - url to be validated\n         * @returns {Boolean}\n         */\n        validate: function (path) {\n            var hostname = window.location.hostname;\n\n            if (path.indexOf(hostname) === -1 ||\n                path.indexOf('javascript:') !== -1 ||\n                path.indexOf('vbscript:') !== -1) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Sanitize url, replacing disallowed chars\n         *\n         * @param {Sring} path - url to be normalized\n         * @returns {String}\n         */\n        sanitize: function (path) {\n            return path.replace('[^-A-Za-z0-9+&@#/%?=~_|!:,.;\\(\\)]', '');\n        }\n    };\n});\n","mage/validation/validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"mage/validation\",\n            \"mage/translate\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    \"use strict\";\n\n    $.each({\n        'validate-grouped-qty': [\n            function (value, element, params) {\n                var result = false;\n                var total = 0;\n                $(params).find('input[data-validate*=\"validate-grouped-qty\"]').each(function (i, e) {\n                    var val = $(e).val();\n                    if (val && val.length > 0) {\n                        result = true;\n                        var valInt = parseInt(val, 10) || 0;\n                        if (valInt >= 0) {\n                            total += valInt;\n                        } else {\n                            result = false;\n                            return result;\n                        }\n                    }\n                });\n                return result && total > 0;\n            },\n            'Please specify the quantity of product(s).'\n        ],\n        'validate-one-checkbox-required-by-name': [\n            function (value, element, params) {\n                var checkedCount = 0;\n                if (element.type === 'checkbox') {\n                    $('[name=\"' + element.name + '\"]').each(function () {\n                        if ($(this).is(':checked')) {\n                            checkedCount += 1;\n                            return false;\n                        }\n                    });\n                }\n                var container = '#' + params;\n                if (checkedCount > 0) {\n                    $(container).removeClass('validation-failed');\n                    $(container).addClass('validation-passed');\n                    return true;\n                } else {\n                    $(container).addClass('validation-failed');\n                    $(container).removeClass('validation-passed');\n                    return false;\n                }\n            },\n            'Please select one of the options.'\n        ],\n        'validate-date-between': [\n            function (value, element, params) {\n                var minDate = new Date(params[0]),\n                    maxDate = new Date(params[1]),\n                    inputDate = new Date(element.value);\n                minDate.setHours(0);\n                maxDate.setHours(0);\n                if (inputDate >= minDate && inputDate <= maxDate) {\n                    return true;\n                }\n                var message = $.mage.__('Please enter a date between %min and %max.');\n                this.dateBetweenErrorMessage = message.replace('%min', minDate).replace('%max', maxDate);\n                return false;\n            },\n            function () {\n                return this.dateBetweenErrorMessage;\n            }\n        ],\n        'validate-dob': [\n            function (val, element, params) {\n                var dob = $(element).parents('.customer-dob');\n                $(dob).find('.' + this.settings.errorClass).removeClass(this.settings.errorClass);\n                var dayVal = $(dob).find(params[0]).find('input:text').val(),\n                    monthVal = $(dob).find(params[1]).find('input:text').val(),\n                    yearVal = $(dob).find(params[2]).find('input:text').val(),\n                    dobLength = dayVal.length + monthVal.length + yearVal.length;\n                if (params[3] && dobLength === 0) {\n                    this.dobErrorMessage = 'This is a required field.';\n                    return false;\n                }\n                if (!params[3] && dobLength === 0) {\n                    return true;\n                }\n                var day = parseInt(dayVal, 10) || 0,\n                    month = parseInt(monthVal, 10) || 0,\n                    year = parseInt(yearVal, 10) || 0,\n                    curYear = (new Date()).getFullYear();\n                if (!day || !month || !year) {\n                    this.dobErrorMessage = 'Please enter a valid full date.';\n                    return false;\n                }\n                if (month < 1 || month > 12) {\n                    this.dobErrorMessage = 'Please enter a valid month (1-12).';\n                    return false;\n                }\n                if (year < 1900 || year > curYear) {\n                    var validYearMessage = $.mage.__('Please enter a valid year (1900-%1).');\n                    this.dobErrorMessage = validYearMessage.replace('%1', curYear.toString());\n                    return false;\n                }\n                var validateDayInMonth = new Date(year, month, 0).getDate();\n                if (day < 1 || day > validateDayInMonth) {\n                    var validDateMessage = $.mage.__('Please enter a valid day (1-%1).');\n                    this.dobErrorMessage = validDateMessage.replace('%1', validateDayInMonth.toString());\n                    return false;\n                }\n                var today = new Date(),\n                    dateEntered = new Date();\n                dateEntered.setFullYear(year, month - 1, day);\n                if (dateEntered > today) {\n                    this.dobErrorMessage = $.mage.__('Please enter a date from the past.');\n                    return false;\n                }\n\n                day = day % 10 === day ? '0' + day : day;\n                month = month % 10 === month ? '0' + month : month;\n                $(element).val(month + '/' + day + '/' + year);\n                return true;\n            },\n            function () {\n                return this.dobErrorMessage;\n            }\n        ]\n    }, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n}));","mage/view/composite.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(['jquery'], function($) {\n    return function (wrapperTag) {\n        wrapperTag = wrapperTag || 'div';\n        var renderedChildren = {};\n        var children = {};\n        return {\n            addChild: function (child, key) {\n                children[key] = child;\n            },\n\n            render: function (root) {\n                $.each(children, function (key, child) {\n                    var childRoot = $('<div>');\n                    renderedChildren[key] = child.render(childRoot);\n                    root.append(childRoot);\n                });\n            }\n        }\n    }\n});\n","magnifier/magnifier.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n;(function ($) {\n    $.fn.magnify = function (options) {\n        'use strict';\n\n        var magnify = new Magnify($(this), options);\n        /*events must be tracked here*/\n\n        /**\n         * Return that from _init function\n         *\n         */\n        return magnify;\n\n    };\n\n    function Magnify(element, options) {\n        var gOptions = options || {},\n            $box = $(element),\n            $thumb,\n            that = this,\n            largeWrapper = options.largeWrapper ||  \".magnifier-preview\",\n            $largeWrapper = $(largeWrapper);\n        curThumb = null,\n            currentOpts = {\n                x: 0,\n                y: 0,\n                w: 0,\n                h: 0,\n                lensW: 0,\n                lensH: 0,\n                lensBgX: 0,\n                lensBgY: 0,\n                largeW: 0,\n                largeH: 0,\n                largeL: 0,\n                largeT: 0,\n                zoom: 2,\n                zoomMin: 1.1,\n                zoomMax: 5,\n                mode: 'outside',\n                eventType: 'click',\n                status: 0,\n                zoomAttached: false,\n                zoomable: (gOptions.zoomable !== undefined)\n                    ? gOptions.zoomable\n                    : false,\n                onthumbenter: (gOptions.onthumbenter !== undefined)\n                    ? gOptions.onthumbenter\n                    : null,\n                onthumbmove: (gOptions.onthumbmove !== undefined)\n                    ? gOptions.onthumbmove\n                    : null,\n                onthumbleave: (gOptions.onthumbleave !== undefined)\n                    ? gOptions.onthumbleave\n                    : null,\n                onzoom: (gOptions.onzoom !== undefined)\n                    ? gOptions.onzoom\n                    : null\n            },\n            pos = {\n                t: 0,\n                l: 0,\n                x: 0,\n                y: 0\n            },\n            gId = 0,\n            status = 0,\n            curIdx = '',\n            curLens = null,\n            curLarge = null,\n            lensbg = (gOptions.bg !== undefined) ? gOptions.lensbg : true,\n            gZoom = (gOptions.zoom !== undefined)\n                ? gOptions.zoom\n                : currentOpts.zoom,\n            gZoomMin = (gOptions.zoomMin !== undefined)\n                ? gOptions.zoomMin\n                : currentOpts.zoomMin,\n            gZoomMax = (gOptions.zoomMax !== undefined)\n                ? gOptions.zoomMax\n                : currentOpts.zoomMax,\n            gMode = gOptions.mode || currentOpts.mode,\n            gEventType = gOptions.eventType || currentOpts.eventType,\n            data = {},\n            inBounds = false,\n            isOverThumb = false,\n            rate = 1,\n            paddingX = 0,\n            paddingY = 0,\n            enabled = true,\n            showWrapper = true;\n\n        var MagnifyCls = {\n            magnifyHidden: \"magnify-hidden\",\n            magnifyOpaque: \"magnify-opaque\",\n            magnifyFull: \"magnify-fullimage\"\n\n        };\n\n\n        /**\n         * Update Lens positon on.\n         *\n         */\n        that.update = function () {\n            updateLensOnLoad();\n        };\n\n        /**\n         * Init new Magnifier\n         *\n         */\n        that.init = function () {\n            _init($box, options);\n        };\n\n        function _toBoolean (str) {\n            if (typeof  str === 'string') {\n                if (str === 'true') {\n                    return true;\n                } else if (str === 'false' || '') {\n                    return false;\n                } else {\n                    console.warn(\"Wrong type: can't be transformed to Boolean\");\n                }\n            } else if (typeof str === 'boolean') {\n                return str;\n            }\n        }\n\n        function createLens(thumb) {\n            if ($(thumb).siblings('.magnify-lens').length) {\n                return false;\n            }\n            var lens = $('<div class=\"magnify-lens magnify-hidden\" data-gallery-role=\"magnifier-zoom\"></div>');\n            $(thumb).parent().append(lens);\n        }\n\n        function updateLensOnLoad(idx, thumb, large, largeWrapper) {\n            var lens = $box.find('.magnify-lens'),\n                textWrapper;\n\n            if (data[idx].status === 1) {\n                textWrapper = $('<div class=\"magnifier-loader-text\"></div>');\n                lens.className = 'magnifier-loader magnify-hidden';\n                textWrapper.html(\"Loading...\");\n                lens.html(\"\").append(textWrapper);\n            } else if (data[idx].status === 2) {\n                lens.addClass(MagnifyCls.magnifyHidden);\n                lens.html(\"\");\n                large.id = idx + '-large';\n                large.style.width = data[idx].largeW * rate + 'px';\n                large.style.height = data[idx].largeH + 'px';\n                large.className = 'magnifier-large magnify-hidden';\n\n                if (data[idx].mode === 'inside') {\n                    lens.append(large);\n                } else {\n                    largeWrapper.html(\"\").append(large);\n                }\n            }\n\n            data[idx].lensH = data[idx].lensH > $thumb.height() ? $thumb.height() : data[idx].lensH;\n\n            if (Math.round(data[idx].lensW) === 0) {\n                lens.css('display', 'none');\n            } else {\n                lens.css({\n                    width: data[idx].lensW + 1 + 'px',\n                    height: data[idx].lensH - 1 + 'px',\n                    display: ''\n                });\n            }\n        }\n\n        function getMousePos() {\n            var xPos = pos.x - currentOpts.x,\n                yPos = pos.y - currentOpts.y,\n                t,\n                l;\n\n            inBounds = ( xPos < 0 || yPos < 0 || xPos > currentOpts.w || yPos > currentOpts.h ) ? false : true;\n\n            l = xPos - currentOpts.lensW / 2;\n            t = yPos - currentOpts.lensH / 2;\n\n            if (currentOpts.mode !== 'inside') {\n                if (xPos < currentOpts.lensW / 2) {\n                    l = 0;\n                }\n\n                if (yPos < currentOpts.lensH / 2) {\n                    t = 0;\n                }\n\n                if (xPos - currentOpts.w + Math.ceil(currentOpts.lensW / 2) > 0) {\n                    l = currentOpts.w - Math.ceil(currentOpts.lensW + 2);\n                }\n\n                if (yPos - currentOpts.h + Math.ceil(currentOpts.lensH / 2) > 0) {\n                    t = currentOpts.h - Math.ceil(currentOpts.lensH);\n                }\n\n                pos.l = l;\n                pos.t = t;\n\n                currentOpts.lensBgX = pos.l;\n                currentOpts.lensBgY = pos.t;\n\n                if (currentOpts.mode === 'inside') {\n                    currentOpts.largeL = xPos * (currentOpts.zoom - (currentOpts.lensW / currentOpts.w));\n                    currentOpts.largeT = yPos * (currentOpts.zoom - (currentOpts.lensH / currentOpts.h));\n                } else {\n                    currentOpts.largeL = currentOpts.lensBgX * currentOpts.zoom * (currentOpts.largeWrapperW / currentOpts.w) * rate;\n                    currentOpts.largeT = currentOpts.lensBgY * currentOpts.zoom * (currentOpts.largeWrapperH / currentOpts.h);\n                }\n            }\n        }\n\n\n\n        function onThumbEnter() {\n            if (_toBoolean(enabled)) {\n                currentOpts = data[curIdx];\n                curLens = $box.find('.magnify-lens');\n\n                if (currentOpts.status === 2) {\n                    curLens.removeClass(MagnifyCls.magnifyOpaque);\n                    curLarge = $('#' + curIdx + '-large');\n                    curLarge.removeClass(MagnifyCls.magnifyHidden);\n                } else if (currentOpts.status === 1) {\n                    curLens.className = 'magnifier-loader';\n                }\n            }\n        }\n\n        function onThumbLeave() {\n            if (currentOpts.status > 0) {\n                var handler = currentOpts.onthumbleave;\n\n                if (handler !== null) {\n                    handler({\n                        thumb: curThumb,\n                        lens: curLens,\n                        large: curLarge,\n                        x: pos.x,\n                        y: pos.y\n                    });\n                }\n                if (!curLens.hasClass(MagnifyCls.magnifyHidden)) {\n                    curLens.addClass(MagnifyCls.magnifyHidden);\n\n                    //$curThumb.removeClass(MagnifyCls.magnifyOpaque);\n                    if (curLarge !== null) {\n                        curLarge.addClass(MagnifyCls.magnifyHidden);\n                    }\n                }\n            }\n        }\n\n        function move() {\n            if (_toBoolean(enabled)) {\n                if (status !== currentOpts.status) {\n                    onThumbEnter();\n                }\n\n                if (currentOpts.status > 0) {\n                    curThumb.className = currentOpts.thumbCssClass + ' magnify-opaque';\n\n                    if (currentOpts.status === 1) {\n                        curLens.className = 'magnifier-loader';\n                    } else if (currentOpts.status === 2) {\n                        curLens.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.css({\n                            left: '-' + currentOpts.largeL + 'px',\n                            top: '-' + currentOpts.largeT + 'px'\n                        });\n                    }\n\n                    pos.t = pos.t <= 0 ? 0 : pos.t;\n                    curLens.css({\n                        left: pos.l + paddingX +'px',\n                        top: pos.t + 1 + paddingY + 'px'\n                    });\n\n                    if (lensbg) {\n                        curLens.css({\n                            \"background-color\": \"rgba(f,f,f,.5)\"\n                        });\n                    } else {\n                        curLens.get(0).style.backgroundPosition = '-' +\n                        currentOpts.lensBgX + 'px -' +\n                        currentOpts.lensBgY + 'px';\n                    }\n                    var handler = currentOpts.onthumbmove;\n\n                    if (handler !== null) {\n                        handler({\n                            thumb: curThumb,\n                            lens: curLens,\n                            large: curLarge,\n                            x: pos.x,\n                            y: pos.y\n                        });\n                    }\n                }\n\n                status = currentOpts.status;\n            }\n        }\n\n        function setThumbData(thumb, thumbData) {\n            var thumbBounds = thumb.getBoundingClientRect(),\n                w = 0,\n                h = 0;\n\n            thumbData.x = thumbBounds.left;\n            thumbData.y = thumbBounds.top;\n            thumbData.w = thumbBounds.right - thumbData.x;\n            thumbData.h = thumbBounds.bottom - thumbData.y;\n\n            if (thumbData.mode === 'inside') {\n                w = thumbData.w;\n                h = thumbData.h;\n            } else {\n                w = thumbData.largeWrapperW;\n                h = thumbData.largeWrapperH;\n            }\n\n            thumbData.largeW = thumbData.zoom * w;\n            thumbData.largeH = thumbData.zoom * h;\n\n            thumbData.lensW = (thumbData.w / thumbData.zoom) / rate;\n            thumbData.lensH = thumbData.h / thumbData.zoom;\n        }\n\n        function _init($box, options) {\n            var opts = {};\n            if (options.thumb === undefined) {\n                return false;\n            }\n\n            $thumb = $box.find(options.thumb);\n\n            if ($thumb.length) {\n                for (var key in options) {\n                    opts[key] = options[key];\n                }\n\n                opts.thumb = $thumb;\n                enabled = opts.enabled;\n\n                if(_toBoolean(enabled)) {\n\n                    $largeWrapper.show().css('display', '');\n                    $largeWrapper.addClass(MagnifyCls.magnifyHidden);\n                    set(opts);\n                } else {\n                    $largeWrapper.empty().hide();\n                }\n            }\n\n            return that;\n        }\n\n        function hoverEvents(thumb) {\n            $(thumb).on('mouseover', function (e) {\n\n                if (showWrapper) {\n\n                    if (currentOpts.status !== 0) {\n                        onThumbLeave();\n                    }\n                    handleEvents(e);\n                    isOverThumb = inBounds;\n                }\n            }).trigger('mouseover');\n        }\n\n        function clickEvents(thumb) {\n            $(thumb).on('click', function (e) {\n\n                if (showWrapper) {\n                    if (!isOverThumb) {\n                        if (currentOpts.status !== 0) {\n                            onThumbLeave();\n                        }\n                        handleEvents(e);\n                        isOverThumb = true;\n                    }\n                }\n            });\n        }\n\n        function bindEvents(eType, thumb) {\n            switch (eType) {\n                case 'hover':\n                    hoverEvents(thumb);\n                    break;\n                case 'click':\n                    clickEvents(thumb);\n                    break;\n            }\n        }\n\n        function handleEvents(e) {\n            var src = e.target;\n            curIdx = src.id;\n            curThumb = src;\n\n            onThumbEnter(src);\n\n            setThumbData(curThumb, currentOpts);\n\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n            move();\n\n            var handler = currentOpts.onthumbenter;\n\n            if (handler !== null) {\n                handler({\n                    thumb: curThumb,\n                    lens: curLens,\n                    large: curLarge,\n                    x: pos.x,\n                    y: pos.y\n                });\n            }\n        }\n\n        function set(options) {\n            if (data[options.thumb.id] !== undefined) {\n                curThumb = options.thumb;\n                return false;\n            }\n\n            var thumbObj = new Image(),\n                largeObj = new Image(),\n                $thumb = options.thumb,\n                thumb = $thumb.get(0),\n                idx = thumb.id,\n                largeUrl,\n                largeWrapper = $(options.largeWrapper),\n                zoom = options.zoom || thumb.getAttribute('data-zoom') || gZoom,\n                zoomMin = options.zoomMin || gZoomMin,\n                zoomMax = options.zoomMax || gZoomMax,\n                mode = options.mode || thumb.getAttribute('data-mode') || gMode,\n                eventType = options.eventType || thumb.getAttribute('data-eventType') || gEventType,\n                onthumbenter = (options.onthumbenter !== undefined)\n                    ? options.onthumbenter\n                    : currentOpts.onthumbenter,\n                onthumbleave = (options.onthumbleave !== undefined)\n                    ? options.onthumbleave\n                    : currentOpts.onthumbleave,\n                onthumbmove = (options.onthumbmove !== undefined)\n                    ? options.onthumbmove\n                    : currentOpts.onthumbmove;\n\n            largeUrl = $thumb.data(\"original\") || gOptions.full || $thumb.attr('src');\n\n            if (thumb.id === '') {\n                idx = thumb.id = 'magnifier-item-' + gId;\n                gId += 1;\n            }\n\n            createLens(thumb, idx);\n\n            if (options.width) {\n                largeWrapper.width(options.width);\n            }\n            if (options.height) {\n                largeWrapper.height(options.height);\n            }\n            if (options.top) {\n                if (typeof options.top == 'function') {\n                    var top = options.top() + 'px';\n                } else {\n                    var top = options.top + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.top = top.replace(\"%px\", \"%\");\n                }\n            }\n            if (options.left) {\n                if (typeof options.left == 'function') {\n                    var left = options.left() + 'px';\n                } else {\n                    var left = options.left + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.left = left.replace(\"%px\", \"%\");\n                }\n            }\n\n            data[idx] = {\n                zoom: zoom,\n                zoomMin: zoomMin,\n                zoomMax: zoomMax,\n                mode: mode,\n                eventType: eventType,\n                thumbCssClass: thumb.className,\n                zoomAttached: false,\n                status: 0,\n                largeUrl: largeUrl,\n                largeWrapperId: mode === 'outside' ? largeWrapper.attr('id') : null,\n                largeWrapperW: mode === 'outside' ? largeWrapper.width() : null,\n                largeWrapperH: mode === 'outside' ? largeWrapper.height() : null,\n                onthumbenter: onthumbenter,\n                onthumbleave: onthumbleave,\n                onthumbmove: onthumbmove\n            };\n\n            rate = ($thumb.width() / $thumb.height()) / (data[idx].largeWrapperW / data[idx].largeWrapperH);\n            paddingX = ($thumb.parent().width() - $thumb.width()) / 2;\n            paddingY = ($thumb.parent().height() - $thumb.height()) / 2;\n\n            showWrapper = false;\n            $(thumbObj).on('load', function () {\n                data[idx].status = 1;\n\n                $(largeObj).on('load', function () {\n\n                    if ((largeObj.width > largeWrapper.width()) || (largeObj.height > largeWrapper.height())) {\n                        showWrapper = true;\n                        bindEvents(eventType, thumb);\n                        data[idx].status = 2;\n                        data[idx].zoom = largeObj.height / largeWrapper.height();\n                        setThumbData(thumb, data[idx]);\n                        updateLensOnLoad(idx, thumb, largeObj, largeWrapper);\n                    }\n                });\n\n                largeObj.src = data[idx].largeUrl;\n            });\n\n            thumbObj.src = thumb.src;\n        }\n\n        function onMousemove(e) {\n\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n\n            if (gEventType === 'hover') {\n                isOverThumb = inBounds;\n            }\n\n            if (inBounds && isOverThumb) {\n                $largeWrapper.removeClass(MagnifyCls.magnifyHidden);\n                move();\n            } else {\n                onThumbLeave();\n                isOverThumb = false;\n                $largeWrapper.addClass(MagnifyCls.magnifyHidden);\n            }\n        }\n\n        function onScroll() {\n\n            if (curThumb !== null) {\n                setThumbData(curThumb, currentOpts);\n            }\n        }\n\n\n        $(window).on('scroll', onScroll);\n        $(window).resize(function() {\n            _init($box, gOptions);\n        });\n\n        $(document).on('mousemove', onMousemove);\n        _init($box, gOptions);\n\n    }\n}(jQuery));\n","magnifier/magnify.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'magnifier/magnifier'\n], function ($, _) {\n    'use strict';\n\n    return function (config, element) {\n\n        var isTouchEnabled = 'ontouchstart' in document.documentElement,\n            gallerySelector = '[data-gallery-role=\"gallery\"]',\n            magnifierSelector = '[data-gallery-role=\"magnifier\"]',\n            magnifierZoomSelector = '[data-gallery-role=\"magnifier-zoom\"]',\n            zoomInButtonSelector = '[data-gallery-role=\"fotorama__zoom-in\"]',\n            zoomOutButtonSelector = '[data-gallery-role=\"fotorama__zoom-out\"]',\n            fullscreenImageSelector = '[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"] .fotorama__img--full',\n            imageDraggableClass = 'fotorama__img--draggable',\n            imageZoommable = 'fotorama__img--zoommable',\n            zoomInLoaded = 'zoom-in-loaded',\n            zoomOutLoaded = 'zoom-out-loaded',\n            zoomInDisabled = 'fotorama__zoom-in--disabled',\n            zoomOutDisabled = 'fotorama__zoom-out--disabled',\n            keyboardNavigation,\n            videoContainerClass = 'fotorama-video-container',\n            hideMagnifier,\n            dragFlag,\n            endX,\n            transitionEnabled,\n            transitionActive = false,\n            tapFlag = 0,\n            allowZoomOut = false,\n            allowZoomIn = true;\n\n        if (isTouchEnabled) {\n            $(element).on('fotorama:showend fotorama:load', function () {\n                $(magnifierSelector).remove();\n                $(magnifierZoomSelector).remove();\n            });\n        }\n\n        (function () {\n            var style = document.documentElement.style,\n                transitionEnabled = style.transition !== undefined ||\n                style.WebkitTransition !== undefined ||\n                style.MozTransition !== undefined ||\n                style.MsTransition !== undefined ||\n                style.OTransition !== undefined;\n        })();\n\n        /**\n         * Return width and height of original image\n         * @param src path for original image\n         * @returns {{rw: number, rh: number}}\n         */\n        function getImageSize(src) {\n            var img = new Image(),\n                imgSize = {\n                    rw: 0,\n                    rh: 0\n                };\n\n            img.src = src;\n            imgSize.rw = img.width;\n            imgSize.rh = img.height;\n\n            return imgSize;\n        }\n\n        /**\n         * Sets min-height and min-width for image to avoid transition bug\n         * @param $image - fullscreen image\n         */\n        function calculateMinSize($image) {\n\n            var minHeight,\n                minWidth,\n                height = $image.height(),\n                width = $image.width(),\n                parentHeight = $image.parent().height(),\n                parentWidth = $image.parent().width();\n\n            if (width > parentWidth || height > parentHeight) {\n\n                if (width / height < parentWidth / parentHeight) {\n                    minHeight = parentHeight;\n                    minWidth = width * (parentHeight / height);\n                } else {\n                    minWidth = parentWidth;\n                    minHeight = height * parentWidth / width;\n                }\n                $image.css({\n                    'min-width': minWidth,\n                    'min-height': minHeight\n                });\n            }\n        }\n\n        function toggleZoomable($image, flag) {\n            if (flag) {\n                $image.css({\n                    'min-width': $image.width(),\n                    'min-height': $image.height(),\n                    'width': $image.width(),\n                    'height': $image.height()\n                }).addClass(imageZoommable);\n            } else {\n                $image.css({\n                    width: '',\n                    height: '',\n                    top: '',\n                    left: '',\n                    right: '',\n                    bottom: ''\n                }).removeClass(imageZoommable);\n                calculateMinSize($image);\n            }\n        }\n\n        function resetVars($image) {\n            allowZoomIn = true;\n            allowZoomOut = dragFlag = transitionActive = false;\n            $image.hasClass(imageDraggableClass) && $image.removeClass(imageDraggableClass);\n            toggleZoomable($image, false);\n        }\n\n        /**\n         * Set state for zoom controls.\n         * If state is true, zoom controls will be visible.\n         * IF state is false, zoom controls will be hidden.\n         * @param isHide\n         */\n        function hideZoomControls(isHide) {\n            if (isHide) {\n                $(zoomInButtonSelector).addClass(zoomInDisabled);\n                $(zoomOutButtonSelector).addClass(zoomOutDisabled);\n            } else {\n                $(zoomInButtonSelector).removeClass(zoomInDisabled);\n                $(zoomOutButtonSelector).removeClass(zoomOutDisabled);\n            }\n        }\n\n        /**\n         * Asynchronus control visibility of zoom buttons.\n         * If image bigger than her wrapper. Zoom controls must visible.\n         * @param path - image source path\n         * @param $image\n         */\n        function asyncToggleZoomButtons(path, $image) {\n            var img = new Image();\n            img.onload = function () {\n                this.height > $image.parent().height() || this.width > $image.parent().width() ?\n                    hideZoomControls(false) : hideZoomControls(true);\n            };\n            img.src = path;\n        }\n\n        /**\n         * Control visibility of zoom buttons.\n         * Zoom controls must be invisible for video content and touch devices.\n         * On touch devices active pinchIn/pinchOut.\n         * @param $image\n         * @param isTouchScreen - true for touch devices\n         * @param isVideoActiveFrame - true for active video frame\n         */\n        function toggleZoomButtons($image, isTouchScreen, isVideoActiveFrame) {\n            var path = $image.attr('src');\n\n            if (path && !isTouchScreen && !isVideoActiveFrame) {\n                asyncToggleZoomButtons(path, $image);\n            } else {\n                hideZoomControls(true);\n            }\n        }\n\n        /**\n         * Handle resize event in fullscreen.\n         * @param $image - Fullscreen image.\n         * @param e - Event.\n         */\n        function resizeHandler(e, $image) {\n            var imageSize,\n                parentWidth,\n                parentHeight,\n                isImageSmall,\n                isImageFit;\n\n            if (!e.data.$image || !e.data.$image.length)\n                return;\n\n            imageSize = getImageSize($(fullscreenImageSelector)[0].src);\n            parentWidth = e.data.$image.parent().width();\n            parentHeight = e.data.$image.parent().height();\n            isImageSmall = parentWidth >= imageSize.rw && parentHeight >= imageSize.rh;\n            isImageFit = parentWidth > e.data.$image.width() && parentHeight > e.data.$image.height();\n\n            toggleZoomButtons(e.data.$image, isTouchEnabled, checkForVideo(e.data.fotorama.activeFrame.$stageFrame));\n            calculateMinSize(e.data.$image);\n\n            if (e.data.$image.hasClass(imageZoommable) && !allowZoomOut || isImageSmall || isImageFit) {\n                resetVars(e.data.$image);\n            }\n\n            if (!isImageSmall) {\n                toggleStandartNavigation();\n            }\n        }\n\n        function getTopValue($image, topProp, step, height, containerHeight) {\n            var top;\n\n            if (parseInt($image.css('marginTop')) || parseInt($image.css('marginLeft'))) {\n                top = dragFlag ? topProp - step / 4 : 0;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > height - containerHeight ? height - containerHeight : top;\n            } else {\n                top = topProp + step / 2;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > 0 ? 0 : top;\n\n                if (!dragFlag && step < 0) {\n                    top = top < (containerHeight - height) / 2 ? (containerHeight - height) / 2 : top;\n                }\n            }\n\n            return top;\n        }\n\n        function getLeftValue(leftProp, step, width, containerWidth) {\n            var left;\n\n            left = leftProp + step / 2;\n            left = left < containerWidth - width ? containerWidth - width : left;\n            left = left > 0 ? 0 : left;\n\n            if (!dragFlag && step < 0) {\n                left = left < (containerWidth - width) / 2 ? (containerWidth - width) / 2 : left;\n            }\n\n            return left;\n        }\n\n        function checkFullscreenImagePosition($image, dimentions, widthStep, heightStep) {\n            var $imageContainer,\n                containerWidth,\n                containerHeight,\n                settings,\n                top,\n                left,\n                right,\n                bottom,\n                ratio;\n\n            if ($(gallerySelector).data('fotorama').fullScreen) {\n                transitionActive = true;\n                $imageContainer = $image.parent();\n                containerWidth = $imageContainer.width();\n                containerHeight = $imageContainer.height();\n                top = $image.position().top;\n                left = $image.position().left;\n                ratio = $image.width() / $image.height();\n                dimentions.height = isNaN(dimentions.height) ? dimentions.width / ratio : dimentions.height;\n                dimentions.width = isNaN(dimentions.width) ? dimentions.height * ratio : dimentions.width;\n\n                top = dimentions.height >= containerHeight ?\n                    getTopValue($image, top, heightStep, dimentions.height, containerHeight) : 0;\n\n                left = dimentions.width >= containerWidth ?\n                    getLeftValue(left, widthStep, dimentions.width, containerWidth) : 0;\n\n                right = dragFlag && left < (containerWidth - dimentions.width) / 2 ? 0 : left;\n                bottom = dragFlag ? 0 : top;\n\n                settings = $.extend(dimentions, {\n                    top: top,\n                    bottom: bottom,\n                    left: left,\n                    right: right\n                });\n\n                $image.css(settings);\n            }\n        }\n\n        /**\n         * Toggles fotorama's keyboard and mouse/touch navigation.\n         */\n        function toggleStandartNavigation() {\n            var $selectable =\n                    $('a[href], area[href], input, select, textarea, button, iframe, object, embed, *[tabindex], *[contenteditable]')\n                    .not('[tabindex=-1], [disabled], :hidden'),\n                fotorama = $(gallerySelector).data('fotorama'),\n                $focus = $(':focus'),\n                index;\n\n            if (fotorama.fullScreen) {\n\n                $selectable.each(function (number) {\n\n                    if ($(this).is($focus)) {\n                        index = number;\n                    }\n                });\n\n                fotorama.setOptions({\n                    swipe: !allowZoomOut,\n                    keyboard: !allowZoomOut\n                });\n\n                if (_.isNumber(index)) {\n                    $selectable.eq(index).focus();\n                }\n            }\n        }\n\n        function zoomIn(e, xStep, yStep) {\n            var $image,\n                imgOriginalSize,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                widthResult,\n                heightResult,\n                ratio,\n                dimentions = {};\n\n            if (allowZoomIn && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomInButtonSelector).hasClass(zoomInDisabled))) {\n                $image = $(fullscreenImageSelector);\n                imgOriginalSize = getImageSize($image[0].src);\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n                allowZoomOut = true;\n                toggleStandartNavigation();\n\n                if (!$image.hasClass(imageZoommable)) {\n                    toggleZoomable($image, true);\n                }\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth + zoomWidthStep;\n\n                    if (widthResult >= imgOriginalSize.rw) {\n                        widthResult = imgOriginalSize.rw;\n                        zoomWidthStep = xStep || widthResult - imageWidth;\n                        allowZoomIn = false;\n                    }\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || heightResult - imageHeight;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight + zoomHeightStep;\n\n                    if (heightResult >= imgOriginalSize.rh) {\n                        heightResult = imgOriginalSize.rh;\n                        zoomHeightStep = yStep || heightResult - imageHeight;\n                        allowZoomIn = false;\n                    }\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || widthResult - imageWidth;\n                }\n\n                if (imageWidth >= imageHeight && imageWidth !== imgOriginalSize.rw) {\n                    dimentions = $.extend(dimentions, {\n                        width: widthResult,\n                        height: 'auto'\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n\n                } else if (imageWidth < imageHeight && imageHeight !== imgOriginalSize.rh) {\n                    dimentions = $.extend(dimentions, {\n                        width: 'auto',\n                        height: heightResult\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n                }\n            }\n\n            return false;\n        }\n\n        function zoomOut(e, xStep, yStep) {\n            var $image,\n                widthResult,\n                heightResult,\n                dimentions,\n                parentWidth,\n                parentHeight,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                ratio,\n                fitIntoParent;\n\n            if (allowZoomOut && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomOutButtonSelector).hasClass(zoomOutDisabled))) {\n                allowZoomIn = true;\n                $image = $(fullscreenImageSelector);\n                parentWidth = $image.parent().width();\n                parentHeight = $image.parent().height();\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth - zoomWidthStep;\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || imageHeight - heightResult;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight - zoomHeightStep;\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || imageWidth - widthResult;\n                }\n\n                fitIntoParent = function () {\n                    if (ratio > parentWidth / parentHeight) {\n                        widthResult = parentWidth;\n                        zoomWidthStep = imageWidth - widthResult;\n                        heightResult = widthResult / ratio;\n                        zoomHeightStep = imageHeight - heightResult;\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                    } else {\n                        heightResult = parentHeight;\n                        zoomHeightStep = imageHeight - heightResult;\n                        widthResult = heightResult * ratio;\n                        zoomWidthStep = imageWidth - widthResult;\n                        dimentions = {\n                            width: 'auto',\n                            height: heightResult\n                        };\n                    }\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                };\n\n                if (imageWidth >= imageHeight) {\n                    if (widthResult > parentWidth) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else {\n                        if (heightResult > parentHeight) {\n                            dimentions = {\n                                width: widthResult,\n                                height: 'auto'\n                            };\n                            checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                        } else {\n                            allowZoomOut = dragFlag = false;\n                            toggleStandartNavigation();\n                            fitIntoParent();\n                        }\n                    }\n                } else {\n                    if (heightResult > parentHeight) {\n                        dimentions = {\n                            width: 'auto',\n                            height: heightResult\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else {\n                        if (widthResult > parentWidth) {\n                            dimentions = {\n                                width: 'auto',\n                                height: heightResult\n                            };\n                            checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                        } else {\n                            allowZoomOut = dragFlag = false;\n                            toggleStandartNavigation();\n                            fitIntoParent();\n                        }\n                    }\n                }\n            }\n\n            return false;\n        }\n\n        /**\n         * Bind event on scroll on active item in fotorama\n         * @param e\n         * @param fotorama - object of fotorama\n         */\n        function mousewheel(e, fotorama, element) {\n            var $fotoramaStage = fotorama.activeFrame.$stageFrame,\n                fotoramaStage = $fotoramaStage.get(0);\n\n            function onWheel(e) {\n                var delta = e.deltaY || e.wheelDelta,\n                    ev = e || window.event;\n\n                if ($(gallerySelector).data('fotorama').fullScreen) {\n\n                    if (e.deltaY) {\n                        if (delta > 0) {\n                            zoomOut(ev);\n                        } else {\n                            zoomIn(ev);\n                        }\n                    } else {\n                        if (delta > 0) {\n                            zoomIn(ev);\n                        } else {\n                            zoomOut(ev);\n                        }\n                    }\n\n                    e.preventDefault ? e.preventDefault() : e.returnValue = false;\n                }\n            }\n\n            if (!$fotoramaStage.hasClass('magnify-wheel-loaded')) {\n                if (fotoramaStage && fotoramaStage.addEventListener) {\n                    if ('onwheel' in document) {\n                        fotoramaStage.addEventListener('wheel', onWheel);\n                    } else if ('onmousewheel' in document) {\n                        fotoramaStage.addEventListener('mousewheel', onWheel);\n                    } else {\n                        fotoramaStage.addEventListener('MozMousePixelScroll', onWheel);\n                    }\n                    $fotoramaStage.addClass('magnify-wheel-loaded');\n                }\n            }\n        }\n\n        /**\n         * Method which makes draggable picture. Also work on touch devices.\n         */\n        function magnifierFullscreen(fotorama) {\n            var isDragActive = false,\n                startX,\n                startY,\n                imagePosX,\n                imagePosY,\n                touch,\n                swipeSlide,\n                $gallery = $(gallerySelector),\n                $image = $(fullscreenImageSelector, $gallery),\n                $imageContainer = $('[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"]'),\n                gallery = $gallery.data('fotorama'),\n                pinchDimention;\n\n            swipeSlide = _.throttle(function (direction) {\n                $(gallerySelector).data('fotorama').show(direction);\n            }, 500, {\n                trailing: false\n            });\n\n            function shiftImage(dx, dy, e) {\n                var top = +imagePosY + dy,\n                    left = +imagePosX + dx,\n                    swipeCondition = $image.width() / 10 + 20;\n\n                dragFlag = true;\n\n                if (($image.offset().left === $imageContainer.offset().left + $imageContainer.width() - $image.width() && e.keyCode === 39) ||\n                    (endX - 1 < $imageContainer.offset().left + $imageContainer.width() - $image.width() && dx < 0 && \n                    _.isNumber(endX) &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove'))) {\n                    endX = null;\n                    swipeSlide('>');\n                    return;\n                }\n\n                if (($image.offset().left === $imageContainer.offset().left && dx !== 0 && e.keyCode === 37) ||\n                    (endX === $imageContainer.offset().left && dx > 0 &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove'))) {\n                    endX = null;\n                    swipeSlide('<');\n\n                    return;\n                }\n\n                if ($image.height() > $imageContainer.height()) {\n\n                    if ($imageContainer.offset().top + $imageContainer.height() > top + $image.height()) {\n                        top = $imageContainer.offset().top + $imageContainer.height() - $image.height();\n                    } else {\n                        top = $imageContainer.offset().top < top ? 0 : top;\n                    }\n                    $image.offset({\n                        'top': top\n                    });\n                    $image.css('bottom', '');\n                }\n\n                if ($image.width() > $imageContainer.width()) {\n\n                    if ($imageContainer.offset().left + $imageContainer.width() > left + $image.width()) {\n                        left = $imageContainer.offset().left + $imageContainer.width() - $image.width();\n                    } else {\n                        left = $imageContainer.offset().left < left ? $imageContainer.offset().left : left;\n                    }\n                    $image.offset({\n                        'left': left\n                    });\n                    $image.css('right', '');\n                } else if (Math.abs(dy) < 1 && allowZoomOut &&\n                    !(e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    dx < 0 ? $(gallerySelector).data('fotorama').show('>') : $(gallerySelector).data('fotorama').show('<');\n                }\n\n                if ($image.width() <= $imageContainer.width() && allowZoomOut &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove') && \n                    Math.abs(dx) > Math.abs(dy) && Math.abs(dx) > swipeCondition) {\n                    dx < 0 ? swipeSlide('>') : swipeSlide('<');\n                }\n            }\n\n            /**\n             * Sets image size to original or fit in parent block\n             * @param e - event object\n             */\n            function dblClickHandler(e) {\n                var imgOriginalSize = getImageSize($image[0].src),\n                    proportions;\n\n                if (imgOriginalSize.rh < $image.parent().height() && imgOriginalSize.rw < $image.parent().width()) {\n                    return;\n                }\n\n                proportions = imgOriginalSize.rw / imgOriginalSize.rh;\n\n                if (allowZoomIn) {\n                    zoomIn(e, imgOriginalSize.rw - $image.width(), imgOriginalSize.rh - $image.height());\n                } else {\n                    if (proportions > $imageContainer.width() / $imageContainer.height()) {\n                        zoomOut(e, imgOriginalSize.rw - $imageContainer.width(), imgOriginalSize.rw / proportions);\n                    } else {\n                        zoomOut(e, imgOriginalSize.rw * proportions, imgOriginalSize.rh - $imageContainer.height());\n                    }\n                }\n            }\n\n            function detectDoubleTap(e) {\n                var now = new Date().getTime(),\n                    timesince = now - tapFlag;\n\n                if (timesince < 400 && timesince > 0) {\n                    transitionActive = false;\n                    tapFlag = 0;\n                    dblClickHandler(e);\n                } else {\n                    tapFlag = new Date().getTime();\n                }\n            }\n\n            if (isTouchEnabled) {\n                $image.off('tap');\n                $image.on('tap', function (e) {\n                    if (e.originalEvent.originalEvent.touches.length === 0) {\n                        detectDoubleTap(e);\n                    }\n                });\n            } else {\n                $image.unbind('dblclick');\n                $image.dblclick(dblClickHandler);\n            }\n\n            if (gallery.fullScreen) {\n                toggleZoomButtons($image, isTouchEnabled, checkForVideo(fotorama.activeFrame.$stageFrame));\n            }\n\n            function getDimention(event) {\n                return Math.sqrt(\n                    (event.touches[0].clientX - event.touches[1].clientX) * (event.touches[0].clientX - event.touches[1].clientX) +\n                    (event.touches[0].clientY - event.touches[1].clientY) * (event.touches[0].clientY - event.touches[1].clientY));\n            }\n\n            $image.off(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown');\n            $image.on(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    pinchDimention = getDimention(e.originalEvent);\n                    isDragActive = false;\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n                } else {\n                    if (gallery.fullScreen && (!transitionEnabled || !transitionActive)) {\n                        e.preventDefault();\n\n                        imagePosY = $image.offset().top;\n                        imagePosX = $image.offset().left;\n\n                        if (isTouchEnabled) {\n                            touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                            e.clientX = touch.pageX;\n                            e.clientY = touch.pageY;\n                        }\n                        startX = e.clientX || e.originalEvent.clientX;\n                        startY = e.clientY || e.originalEvent.clientY;\n                        isDragActive = true;\n                    }\n                }\n\n                if ($image.offset() && ($image.width() > $imageContainer.width())) {\n                    endX = $image.offset().left;\n                }\n            });\n\n            $image.off(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove');\n            $image.on(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    var currentDimention = getDimention(e.originalEvent);\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n                    if (currentDimention < pinchDimention) {\n                        zoomOut(e);\n                        pinchDimention = currentDimention;\n                    } else if (currentDimention > pinchDimention) {\n                        zoomIn(e);\n                        pinchDimention = currentDimention;\n                    }\n                } else {\n                    var clientX,\n                        clientY;\n\n                    if (gallery.fullScreen && isDragActive && (!transitionEnabled || !transitionActive)) {\n\n                        if (allowZoomOut && !$image.hasClass(imageDraggableClass)) {\n                            $image.addClass(imageDraggableClass);\n                        }\n                        clientX = e.clientX || e.originalEvent.clientX;\n                        clientY = e.clientY || e.originalEvent.clientY;\n\n                        e.preventDefault();\n\n                        if (isTouchEnabled) {\n                            touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                            clientX = touch.pageX;\n                            clientY = touch.pageY;\n                        }\n\n                        if (allowZoomOut) {\n                            shiftImage(clientX - startX, clientY - startY, e);\n                        }\n                    }\n                }\n            });\n\n            $image.off('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd ');\n            $image.on('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd', function () {\n                transitionActive = false;\n            });\n\n            if (keyboardNavigation) {\n                $(document).unbind('keydown', keyboardNavigation);\n            }\n\n            /**\n             * Replaces original navigations with better one\n             * @param e - event object\n             */\n            keyboardNavigation = function (e) {\n                var step = 40,\n                    $focus = $(':focus'),\n                    isFullScreen = $(gallerySelector).data('fotorama').fullScreen,\n                    initVars = function () {\n                        imagePosX = $(fullscreenImageSelector, $gallery).offset().left;\n                        imagePosY = $(fullscreenImageSelector, $gallery).offset().top;\n                    };\n\n                if (($focus.attr('data-gallery-role') || !$focus.length) && allowZoomOut) {\n                    if (isFullScreen) {\n                        imagePosX = $(fullscreenImageSelector, $(gallerySelector)).offset().left;\n                        imagePosY = $(fullscreenImageSelector, $(gallerySelector)).offset().top;\n                    }\n\n                    if (e.keyCode === 39) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(-step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 38) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(0, step, e);\n                        }\n                    }\n\n                    if (e.keyCode === 37) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 40) {\n\n                        if (isFullScreen) {\n                            e.preventDefault();\n                            initVars();\n                            shiftImage(0, -step, e);\n                        }\n                    }\n                }\n\n                if (e.keyCode === 27 && isFullScreen && allowZoomOut) {\n                    $(gallerySelector).data('fotorama').cancelFullScreen();\n                }\n            };\n\n            /**\n             * @todo keyboard navigation through Fotorama Api.\n             */\n            $(document).keydown(keyboardNavigation);\n\n            $(document).on(isTouchEnabled ? 'touchend' : 'mouseup pointerup MSPointerUp', function (e) {\n                if (gallery.fullScreen) {\n\n                    if ($image.offset() && $image.width() > $imageContainer.width()) {\n                        endX = $image.offset().left;\n                    }\n\n                    isDragActive = false;\n                    $image.removeClass(imageDraggableClass);\n                }\n            });\n\n            $(window).off('resize', resizeHandler);\n            $(window).on('resize', {\n                $image: $image,\n                fotorama: fotorama\n            }, resizeHandler);\n        }\n\n        /**\n         * Hides magnifier preview and zoom blocks.\n         */\n        hideMagnifier = function () {\n            $(magnifierSelector).empty().hide();\n            $(magnifierZoomSelector).remove();\n        };\n\n        /**\n         * Check is active frame in gallery include video content.\n         * If true activeFrame contain video.\n         * @param $stageFrame - active frame in gallery\n         * @returns {*|Boolean}\n         */\n        function checkForVideo($stageFrame) {\n            return $stageFrame.hasClass(videoContainerClass);\n        }\n\n        /**\n         * Hides magnifier on drag and while arrow click.\n         */\n        function behaveOnDrag(e, initPos) {\n            var pos = [e.pageX, e.pageY],\n                isArrow = $(e.target).data('gallery-role') === 'arrow',\n                isClick = initPos[0] === pos[0] && initPos[1] === pos[1],\n                isImg = $(e.target).parent().data('active');\n\n            if (isArrow || isImg && !isClick) {\n                hideMagnifier();\n            }\n        }\n\n        if (config.magnifierOpts.enabled) {\n            $(element).on('pointerdown mousedown MSPointerDown', function (e) {\n                var pos = [e.pageX, e.pageY];\n\n                $(element).on('mousemove pointermove MSPointerMove', function (ev) {\n                    navigator.msPointerEnabled ? hideMagnifier() : behaveOnDrag(ev, pos);\n                });\n                $(document).on('mouseup pointerup MSPointerUp', function () {\n                    $(element).off('mousemove pointermove MSPointerMove');\n                });\n            });\n        }\n\n        $.extend(config.magnifierOpts, {\n            zoomable: false,\n            thumb: '.fotorama__img',\n            largeWrapper: '[data-gallery-role=\"magnifier\"]',\n            height: config.magnifierOpts.height || function () {\n                return $('[data-active=\"true\"]').height();\n            },\n            width: config.magnifierOpts.width || function () {\n                var productMedia = $(gallerySelector).parent().parent();\n\n                return productMedia.parent().width() - productMedia.width() - 20;\n            },\n            left: config.magnifierOpts.left || function () {\n                return $(gallerySelector).offset().left + $(gallerySelector).width() + 20;\n            },\n            top: config.magnifierOpts.top || function () {\n                return $(gallerySelector).offset().top;\n            }\n        });\n\n        $(element).on('fotorama:load fotorama:showend fotorama:fullscreenexit fotorama:ready', function (e, fotorama) {\n            var $activeStageFrame = $(gallerySelector).data('fotorama').activeFrame.$stageFrame;\n\n            if (!$activeStageFrame.find(magnifierZoomSelector).length) {\n                hideMagnifier();\n\n                if (config.magnifierOpts) {\n                    config.magnifierOpts.large = $(gallerySelector).data('fotorama').activeFrame.img;\n                    config.magnifierOpts.full = fotorama.data[fotorama.activeIndex].original;\n                    !checkForVideo($activeStageFrame) && $($activeStageFrame).magnify(config.magnifierOpts);\n                }\n            }\n        });\n\n        $(element).on('gallery:loaded', function (e) {\n            var $prevImage;\n\n            $(element).find(gallerySelector)\n                .on('fotorama:ready', function (e, fotorama) {\n                    var $zoomIn = $(zoomInButtonSelector),\n                        $zoomOut = $(zoomOutButtonSelector);\n\n                    if (!$zoomIn.hasClass(zoomInLoaded)) {\n                        $zoomIn.on('click touchstart', zoomIn);\n                        $zoomIn.on('mousedown', function(e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomIn.keyup(function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $(window).keyup(function (e) {\n\n                            if (e.keyCode === 107 || fotorama.fullscreen) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $zoomIn.addClass(zoomInLoaded);\n                    }\n\n                    if (!$zoomOut.hasClass(zoomOutLoaded)) {\n                        $zoomOut.on('click touchstart', zoomOut);\n                        $zoomOut.on('mousedown', function(e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomOut.keyup(function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $(window).keyup(function (e) {\n\n                            if (e.keyCode === 109 || fotorama.fullscreen) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $zoomOut.addClass(zoomOutLoaded);\n                    }\n                })\n                .on('fotorama:fullscreenenter fotorama:showend', function (e, fotorama) {\n                    hideMagnifier();\n\n                    if (!$(fullscreenImageSelector).is($prevImage)) {\n                        resetVars($(fullscreenImageSelector));\n                    }\n                    magnifierFullscreen(fotorama);\n                    mousewheel(e, fotorama, element);\n\n                    if ($prevImage) {\n                        calculateMinSize($prevImage);\n\n                        if (!$(fullscreenImageSelector).is($prevImage)) {\n                            resetVars($prevImage);\n                        }\n                    }\n\n                    toggleStandartNavigation();\n                })\n                .on('fotorama:load', function (e, fotorama) {\n                    if ($(gallerySelector).data('fotorama').fullScreen) {\n                        toggleZoomButtons($(fullscreenImageSelector), isTouchEnabled,\n                            checkForVideo(fotorama.activeFrame.$stageFrame));\n                    }\n                    magnifierFullscreen(fotorama);\n                })\n                .on('fotorama:show', function (e, fotorama) {\n                    $prevImage = _.clone($(fullscreenImageSelector));\n                    hideMagnifier();\n                })\n                .on('fotorama:fullscreenexit', function (e, fotorama) {\n                    resetVars($(fullscreenImageSelector));\n                    hideMagnifier();\n                    hideZoomControls(true);\n                });\n        });\n\n        return config;\n    };\n});\n","requirejs/domReady.js":"/**\n * @license RequireJS domReady 2.0.1 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/domReady for details\n */\n/*jslint */\n/*global require: false, define: false, requirejs: false,\n  window: false, clearInterval: false, document: false,\n  self: false, setInterval: false */\n\n\ndefine(function () {\n    'use strict';\n\n    var isTop, testDiv, scrollIntervalId,\n        isBrowser = typeof window !== \"undefined\" && window.document,\n        isPageLoaded = !isBrowser,\n        doc = isBrowser ? document : null,\n        readyCalls = [];\n\n    function runCallbacks(callbacks) {\n        var i;\n        for (i = 0; i < callbacks.length; i += 1) {\n            callbacks[i](doc);\n        }\n    }\n\n    function callReady() {\n        var callbacks = readyCalls;\n\n        if (isPageLoaded) {\n            //Call the DOM ready callbacks\n            if (callbacks.length) {\n                readyCalls = [];\n                runCallbacks(callbacks);\n            }\n        }\n    }\n\n    /**\n     * Sets the page as loaded.\n     */\n    function pageLoaded() {\n        if (!isPageLoaded) {\n            isPageLoaded = true;\n            if (scrollIntervalId) {\n                clearInterval(scrollIntervalId);\n            }\n\n            callReady();\n        }\n    }\n\n    if (isBrowser) {\n        if (document.addEventListener) {\n            //Standards. Hooray! Assumption here that if standards based,\n            //it knows about DOMContentLoaded.\n            document.addEventListener(\"DOMContentLoaded\", pageLoaded, false);\n            window.addEventListener(\"load\", pageLoaded, false);\n        } else if (window.attachEvent) {\n            window.attachEvent(\"onload\", pageLoaded);\n\n            testDiv = document.createElement('div');\n            try {\n                isTop = window.frameElement === null;\n            } catch (e) {}\n\n            //DOMContentLoaded approximation that uses a doScroll, as found by\n            //Diego Perini: http://javascript.nwbox.com/IEContentLoaded/,\n            //but modified by other contributors, including jdalton\n            if (testDiv.doScroll && isTop && window.external) {\n                scrollIntervalId = setInterval(function () {\n                    try {\n                        testDiv.doScroll();\n                        pageLoaded();\n                    } catch (e) {}\n                }, 30);\n            }\n        }\n\n        //Check if document already complete, and if so, just trigger page load\n        //listeners. Latest webkit browsers also use \"interactive\", and\n        //will fire the onDOMContentLoaded before \"interactive\" but not after\n        //entering \"interactive\" or \"complete\". More details:\n        //http://dev.w3.org/html5/spec/the-end.html#the-end\n        //http://stackoverflow.com/questions/3665561/document-readystate-of-interactive-vs-ondomcontentloaded\n        //Hmm, this is more complicated on further use, see \"firing too early\"\n        //bug: https://github.com/requirejs/domReady/issues/1\n        //so removing the || document.readyState === \"interactive\" test.\n        //There is still a window.onload binding that should get fired if\n        //DOMContentLoaded is missed.\n        if (document.readyState === \"complete\") {\n            pageLoaded();\n        }\n    }\n\n    /** START OF PUBLIC API **/\n\n    /**\n     * Registers a callback for DOM ready. If DOM is already ready, the\n     * callback is called immediately.\n     * @param {Function} callback\n     */\n    function domReady(callback) {\n        if (isPageLoaded) {\n            callback(doc);\n        } else {\n            readyCalls.push(callback);\n        }\n        return domReady;\n    }\n\n    domReady.version = '2.0.1';\n\n    /**\n     * Loader Plugin API method\n     */\n    domReady.load = function (name, req, onLoad, config) {\n        if (config.isBuild) {\n            onLoad(null);\n        } else {\n            domReady(onLoad);\n        }\n    };\n\n    /** END OF PUBLIC API **/\n\n    return domReady;\n});"}
    }
});
