require.config({
    config: {
        'jsbuild':{"Magento_Theme/menu.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @classDescription simple Navigation with replacing old handlers\n * @param {String} id id of ul element with navigation lists\n * @param {Object} settings object with settings\n */\ndefine([\"prototype\"], function(){\n\n\nwindow.mainNav = function() {\n\n    var main = {\n        obj_nav :   $(arguments[0]) || $(\"nav\"),\n\n        settings :  {\n            show_delay      :   0,\n            hide_delay      :   0,\n            _ie6            :   /MSIE 6.+Win/.test(navigator.userAgent),\n            _ie7            :   /MSIE 7.+Win/.test(navigator.userAgent)\n        },\n\n        init :  function(obj, level) {\n            obj.lists = obj.childElements();\n            obj.lists.each(function(el,ind){\n                main.handlNavElement(el);\n                if((main.settings._ie6 || main.settings._ie7) && level){\n                    main.ieFixZIndex(el, ind, obj.lists.size());\n                }\n            });\n            if(main.settings._ie6 && !level){\n                document.execCommand(\"BackgroundImageCache\", false, true);\n            }\n        },\n\n        handlNavElement :   function(list) {\n            if(list !== undefined){\n                list.onmouseover = function(){\n                    main.fireNavEvent(this,true);\n                };\n                list.onmouseout = function(){\n                    main.fireNavEvent(this,false);\n                };\n                if(list.down(\"ul\")){\n                    main.init(list.down(\"ul\"), true);\n                }\n            }\n        },\n\n        ieFixZIndex : function(el, i, l) {\n            if(el.tagName.toString().toLowerCase().indexOf(\"iframe\") == -1){\n                el.style.zIndex = l - i;\n            } else {\n                el.onmouseover = \"null\";\n                el.onmouseout = \"null\";\n            }\n        },\n\n        fireNavEvent :  function(elm,ev) {\n            if(ev){\n                elm.addClassName(\"over\");\n                elm.down(\"a\").addClassName(\"over\");\n                if (elm.childElements()[1]) {\n                    main.show(elm.childElements()[1]);\n                }\n            } else {\n                elm.removeClassName(\"over\");\n                elm.down(\"a\").removeClassName(\"over\");\n                if (elm.childElements()[1]) {\n                    main.hide(elm.childElements()[1]);\n                }\n            }\n        },\n\n        show : function (sub_elm) {\n            if (sub_elm.hide_time_id) {\n                clearTimeout(sub_elm.hide_time_id);\n            }\n            sub_elm.show_time_id = setTimeout(function() {\n                if (!sub_elm.hasClassName(\"shown-sub\")) {\n                    sub_elm.addClassName(\"shown-sub\");\n                }\n            }, main.settings.show_delay);\n        },\n\n        hide : function (sub_elm) {\n            if (sub_elm.show_time_id) {\n                clearTimeout(sub_elm.show_time_id);\n            }\n            sub_elm.hide_time_id = setTimeout(function(){\n                if (sub_elm.hasClassName(\"shown-sub\")) {\n                    sub_elm.removeClassName(\"shown-sub\");\n                }\n            }, main.settings.hide_delay);\n        }\n\n    };\n    if (arguments[1]) {\n        main.settings = Object.extend(main.settings, arguments[1]);\n    }\n    if (main.obj_nav) {\n        main.init(main.obj_nav, false);\n    }\n};\n\ndocument.observe(\"dom:loaded\", function() {\n    //run navigation without delays and with default id=\"#nav\"\n    //mainNav();\n\n    //run navigation with delays\n    mainNav(\"nav\", {\"show_delay\":\"100\",\"hide_delay\":\"100\"});\n});\n\n});","Magento_Theme/js/row-builder.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.rowBuilder', {\n\n        /**\n         * options with default values for setting up the template\n         */\n        options: {\n            //Default template options\n            rowTemplate: '#template-registrant',\n            rowContainer: '#registrant-container',\n            //Row index used by the template rows.\n            rowIndex: 0,\n            //Row count: Should not be set externally\n            rowCount: 0,\n            rowParentElem: '<li></li>',\n            rowContainerClass: 'fields',\n            addRowBtn: '#add-registrant-button',\n            btnRemoveIdPrefix: 'btn-remove',\n            btnRemoveSelector: '.btn-remove',\n            rowIdPrefix: 'row',\n            //This class is added to rows added after the first one. Adds the dotted separator\n            additionalRowClass: 'add-row',\n            /*\n             This is provided during widget instantiation. eg :\n             formDataPost : {\"formData\":formData,\"templateFields\":['field1-name','field2-name'] }\n             -\"formData\" is the multi-dimensional array of form field values : [['a','b'],['c','b']]\n             received from the server and encoded\n             -\"templateFields\" are the input fields in the template with index suffixed after the field name\n             eg field1-name{index}\n             */\n            formDataPost: null,\n            //Default selectors for add element of a template\n            addEventSelector: 'button',\n            //Default selectors for remove markup elements of a template\n            remEventSelector: 'a',\n            //This option allows adding first row delete option and a row separator\n            hideFirstRowAddSeparator: true,\n            //Max rows - This option should be set when instantiating the widget\n            maxRows: 1000,\n            maxRowsMsg: '#max-registrant-message'\n        },\n\n        /**\n         * Initialize create\n         * @private\n         */\n        _create: function () {\n            this.rowTemplate = mageTemplate(this.options.rowTemplate);\n\n            this.options.rowCount = this.options.rowIndex = 0;\n\n            //On document ready related tasks\n            $($.proxy(this.ready, this));\n\n            //Binding template-wide events handlers for adding and removing rows\n            this.element.on('click', this.options.addEventSelector + this.options.addRowBtn, $.proxy(this.handleAdd, this));\n            this.element.on('click', this.options.remEventSelector + this.options.btnRemoveSelector, $.proxy(this.handleRemove, this));\n        },\n\n        /**\n         * Initialize template\n         * @public\n         */\n        ready: function () {\n            if (this.options.formDataPost && this.options.formDataPost.formData && this.options.formDataPost.formData.length) {\n                this.processFormDataArr(this.options.formDataPost);\n            } else if (this.options.rowIndex === 0 && this.options.maxRows !== 0) {\n                //If no form data , then add default row\n                this.addRow(0);\n            }\n        },\n\n        /**\n         * Process and loop through all row data to create preselected values. This is used for any error on submit.\n         * For complex implementations the inheriting widget can override this behavior\n         * @public\n         * @param {Object} formDataArr\n         */\n        processFormDataArr: function (formDataArr) {\n            var formData = formDataArr.formData,\n                templateFields = formDataArr.templateFields,\n                formRow,\n                i, j;\n\n            for (i = this.options.rowIndex = 0; i < formData.length; this.options.rowIndex = i++) {\n                this.addRow(i);\n\n                formRow = formData[i];\n\n                for (j = 0; j < formRow.length; j++) {\n                    this.setFieldById(templateFields[j] + i, formRow[j]);\n                }\n            }\n\n        },\n\n        /**\n         * Initialize and create markup for template row. Add it to the parent container.\n         * The template processing will substitute row index at all places marked with _index_ in the template\n         * using the template\n         * @public\n         * @param {Number} index - current index/count of the created template. This will be used as the id\n         * @return {*}\n         */\n        addRow: function (index) {\n            var row = $(this.options.rowParentElem),\n                tmpl;\n\n            row.addClass(this.options.rowContainerClass).attr('id', this.options.rowIdPrefix + index);\n\n            tmpl = this.rowTemplate({\n                data: {\n                    _index_: index\n                }\n            });\n\n            $(tmpl).appendTo(row);\n\n            $(this.options.rowContainer).append(row);\n\n            row.addClass(this.options.additionalRowClass);\n\n            //Remove 'delete' link and additionalRowClass for first row\n            if (this.options.rowIndex === 0 && this.options.hideFirstRowAddSeparator) {\n                $('#' + this._esc(this.options.btnRemoveIdPrefix) + '0').remove();\n                $('#' + this._esc(this.options.rowIdPrefix) + '0').removeClass(this.options.additionalRowClass);\n            }\n\n            this.maxRowCheck(++this.options.rowCount);\n\n            return row;\n        },\n\n        /**\n         * Remove return item information row\n         * @public\n         * @param {*} rowIndex - return item information row index\n         * @return {Boolean}\n         */\n        removeRow: function (rowIndex) {\n            $('#' + this._esc(this.options.rowIdPrefix) + rowIndex).remove();\n            this.maxRowCheck(--this.options.rowCount);\n\n            return false;\n        },\n\n        /**\n         * Function to check if maximum rows are exceeded and render/hide maxMsg and Add btn\n         * @public\n         * @param {Number} rowIndex\n         */\n        maxRowCheck: function (rowIndex) {\n            var addRowBtn = $(this.options.addRowBtn),\n                maxRowMsg = $(this.options.maxRowsMsg);\n            //liIndex starts from 0\n            if (rowIndex >= this.options.maxRows) {\n                addRowBtn.hide();\n                maxRowMsg.show();\n            } else if (addRowBtn.is(':hidden')) {\n                addRowBtn.show();\n                maxRowMsg.hide();\n            }\n        },\n\n        /**\n         * Set the value on given element\n         * @public\n         * @param {String} domId\n         * @param {String} value\n         */\n        setFieldById: function (domId, value) {\n            var x = $('#' + this._esc(domId));\n\n            if (x.length) {\n\n                if (x.is(':checkbox')) {\n                    x.attr('checked', true);\n                } else if (x.is('option')) {\n                    x.attr('selected', 'selected');\n                } else {\n                    x.val(value);\n                }\n            }\n        },\n\n        /**\n         * Delegated handler for adding a row\n         * @public\n         * @return {Boolean}\n         */\n        handleAdd: function () {\n            this.addRow(++this.options.rowIndex);\n\n            return false;\n        },\n\n        /**\n         * Delegated handler for removing a selected row\n         * @public\n         * @param {Object} e - Native event object\n         * @return {Boolean}\n         */\n        handleRemove: function (e) {\n            this.removeRow($(e.currentTarget).closest(\"[id^='\" + this.options.btnRemoveIdPrefix + \"']\")\n                .attr('id').replace(this.options.btnRemoveIdPrefix, ''));\n\n            return false;\n        },\n\n        /**\n         * Utility function to add escape chars for jquery selector strings\n         * @private\n         * @param {String} str - String to be processed\n         * @return {String}\n         */\n        _esc: function (str) {\n            return str ? str.replace(/([ ;&,.+*~\\':\"!\\^$\\[\\]()=>|\\/@])/g, '\\\\$1') : str;\n        }\n    });\n\n    return $.mage.rowBuilder;\n});\n","Magento_Theme/js/truncate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.truncateOptions', {\n        options: {\n            detailsLink: 'a.details',\n            mouseEvents: 'mouseover mouseout',\n            truncatedFullValue: 'div.truncated.full.value'\n        },\n\n        /**\n         * Establish the event handler for mouse events on the appropriate elements.\n         * @private\n         */\n        _create: function() {\n            this.element.on(this.options.mouseEvents, $.proxy(this._toggleShow, this))\n                .find(this.options.detailsLink).on(this.options.mouseEvents, $.proxy(this._toggleShow, this));\n        },\n\n        /**\n         * Toggle the \"show\" class on the associated element.\n         * @private\n         * @param event {Object} - Mouse over/out event.\n         */\n        _toggleShow: function(event) {\n            $(event.currentTarget).find(this.options.truncatedFullValue).toggleClass('show');\n        }\n    });\n\n});","Magento_Theme/js/view/messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery/jquery-storageapi'\n], function ($, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            cookieMessages: [],\n            messages: []\n        },\n        initialize: function () {\n            this._super();\n\n            this.cookieMessages = $.cookieStorage.get('mage-messages');\n            this.messages = customerData.get('messages').extend({disposableCustomerData: 'messages'});\n            $.cookieStorage.setConf({path: '/', expires: -1}).set('mage-messages', null);\n        }\n    });\n});\n","Magento_Ui/js/block-loader.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/knockout/template/loader',\n    'mage/template'\n], function (ko, $, templateLoader, template) {\n    'use strict';\n\n    var blockLoaderTemplatePath = 'ui/block-loader',\n        blockContentLoadingClass = '_block-content-loading',\n        blockLoader,\n        blockLoaderClass,\n        loaderImageHref;\n\n    templateLoader.loadTemplate(blockLoaderTemplatePath).done(function (blockLoaderTemplate) {\n        blockLoader = template($.trim(blockLoaderTemplate), {\n            loaderImageHref: loaderImageHref\n        });\n        blockLoader = $(blockLoader);\n        blockLoaderClass = '.' + blockLoader.attr('class');\n    });\n\n    /**\n     * Helper function to check if blockContentLoading class should be applied.\n     * @param {Object} element\n     * @returns {Boolean}\n     */\n    function isLoadingClassRequired(element) {\n        var position = element.css('position');\n\n        if (position === 'absolute' || position === 'fixed') {\n            return false;\n        }\n\n        return true;\n    }\n\n    /**\n     * Add loader to block.\n     * @param {Object} element\n     */\n    function addBlockLoader(element) {\n        element.find(':focus').blur();\n        element.find('input:disabled, select:disabled').addClass('_disabled');\n        element.find('input, select').prop('disabled', true);\n\n        if (isLoadingClassRequired(element)) {\n            element.addClass(blockContentLoadingClass);\n        }\n        element.append(blockLoader.clone());\n    }\n\n    /**\n     * Remove loader from block.\n     * @param {Object} element\n     */\n    function removeBlockLoader(element) {\n        if (!element.has(blockLoaderClass).length) {\n            return;\n        }\n        element.find(blockLoaderClass).remove();\n        element.find('input:not(\"._disabled\"), select:not(\"._disabled\")').prop('disabled', false);\n        element.find('input:disabled, select:disabled').removeClass('_disabled');\n        element.removeClass(blockContentLoadingClass);\n    }\n\n    return function (loaderHref) {\n        loaderImageHref = loaderHref;\n        ko.bindingHandlers.blockLoader = {\n            /**\n             * Process loader for block\n             * @param {String} element\n             * @param {Boolean} displayBlockLoader\n             */\n            update: function (element, displayBlockLoader) {\n                element = $(element);\n\n                if (ko.unwrap(displayBlockLoader())) {\n                    addBlockLoader(element);\n                } else {\n                    removeBlockLoader(element);\n                }\n            }\n        };\n    };\n});\n","Magento_Ui/js/core/app.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    './renderer/types',\n    './renderer/layout',\n    '../lib/knockout/bootstrap'\n], function (types, layout) {\n    'use strict';\n\n    return function (data, merge) {\n        types.set(data.types);\n        layout(data.components, undefined, true, merge);\n    };\n});\n","Magento_Ui/js/core/renderer/layout.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'uiRegistry',\n    './types'\n], function (_, $, utils, registry, types) {\n    'use strict';\n\n    var templates = registry.create(),\n        layout = {},\n        cachedConfig = {};\n\n    function getNodeName(parent, node, name) {\n        var parentName = parent && parent.name;\n\n        if (typeof name !== 'string') {\n            name = node.name || name;\n        }\n\n        return utils.fullPath(parentName, name);\n    }\n\n    function getNodeType(parent, node) {\n        return node.type || parent && parent.childType;\n    }\n\n    function getDataScope(parent, node) {\n        var dataScope = node.dataScope,\n            parentScope = parent && parent.dataScope;\n\n        return !utils.isEmpty(parentScope) ?\n            !utils.isEmpty(dataScope) ?\n                parentScope + '.' + dataScope :\n                parentScope :\n            dataScope || '';\n    }\n\n    function loadDeps(node) {\n        var loaded = $.Deferred();\n\n        registry.get(node.deps, function (deps) {\n            node.provider = node.extendProvider ? deps && deps.name : node.provider;\n            loaded.resolve(node);\n        });\n\n        return loaded.promise();\n    }\n\n    function loadSource(node) {\n        var loaded = $.Deferred(),\n            source = node.component;\n\n        require([source], function (constr) {\n            loaded.resolve(node, constr);\n        });\n\n        return loaded.promise();\n    }\n\n    function initComponent(node, Constr) {\n        var component = new Constr(_.omit(node, 'children'));\n\n        registry.set(node.name, component);\n    }\n\n    function run(nodes, parent, cached, merge) {\n        if (_.isBoolean(merge) && merge) {\n            layout.merge(nodes);\n\n            return false;\n        }\n\n        if (cached) {\n            cachedConfig[_.keys(nodes)[0]] = JSON.parse(JSON.stringify(nodes));\n        }\n\n        _.each(nodes || [], layout.iterator.bind(layout, parent));\n    }\n\n    _.extend(layout, {\n        iterator: function (parent, node) {\n            var action = _.isString(node) ?\n                this.addChild :\n                this.process;\n\n            action.apply(this, arguments);\n        },\n\n        process: function (parent, node, name) {\n            if (!parent && node.parent) {\n                return this.waitParent(node, name);\n            }\n\n            if (node.nodeTemplate) {\n                return this.waitTemplate.apply(this, arguments);\n            }\n\n            node = this.build.apply(this, arguments);\n\n            if (!registry.has(node.name)) {\n                this.addChild(parent, node)\n                    .manipulate(node)\n                    .initComponent(node);\n            }\n\n            if (node) {\n                run(node.children, node);\n            }\n\n            return this;\n        },\n\n        build: function (parent, node, name) {\n            var defaults    = parent && parent.childDefaults || {},\n                children    = node.children,\n                type        = getNodeType(parent, node),\n                dataScope   = getDataScope(parent, node),\n                component,\n                extendDeps  = true,\n                nodeName;\n\n            node.children = false;\n            node.extendProvider = true;\n\n            if (node.config && node.config.provider || node.provider) {\n                node.extendProvider = false;\n            }\n\n            if (node.config && node.config.deps || node.deps) {\n                extendDeps= false;\n            }\n\n            node = utils.extend({\n            }, types.get(type), defaults, node);\n\n            nodeName = getNodeName(parent, node, name);\n\n            if (registry.has(nodeName)) {\n                component = registry.get(nodeName);\n                component.children = children;\n\n                return component;\n            }\n\n            if (extendDeps && parent && parent.deps && type) {\n                node.deps = parent.deps;\n            }\n\n            _.extend(node, node.config || {}, {\n                index: node.name || name,\n                name: nodeName,\n                dataScope: dataScope,\n                parentName: utils.getPart(nodeName, -2),\n                parentScope: utils.getPart(dataScope, -2)\n            });\n\n            node.children = children;\n            node.componentType = node.type;\n\n            delete node.type;\n            delete node.config;\n\n            if (children) {\n                node.initChildCount = _.size(children);\n            }\n\n            if (node.isTemplate) {\n                node.isTemplate = false;\n\n                templates.set(node.name, node);\n                registry.get(node.parentName, function (parent) {\n                    parent.childTemplate = node;\n                });\n\n                return false;\n            }\n\n            if (node.componentDisabled === true) {\n                return false;\n            }\n\n            return node;\n        },\n\n        initComponent: function (node) {\n            if (!node.component) {\n                return this;\n            }\n\n            loadDeps(node)\n                .then(loadSource)\n                .done(initComponent);\n\n            return this;\n        }\n    });\n\n    _.extend(layout, {\n        waitTemplate: function (parent, node) {\n            var args = _.toArray(arguments);\n\n            templates.get(node.nodeTemplate, function () {\n                this.applyTemplate.apply(this, args);\n            }.bind(this));\n\n            return this;\n        },\n\n        waitParent: function (node, name) {\n            var process = this.process.bind(this);\n\n            registry.get(node.parent, function (parent) {\n                process(parent, node, name);\n            });\n\n            return this;\n        },\n\n        applyTemplate: function (parent, node, name) {\n            var template = templates.get(node.nodeTemplate);\n\n            node = utils.extend({}, template, node);\n\n            delete node.nodeTemplate;\n\n            this.process(parent, node, name);\n        }\n    });\n\n    _.extend(layout, {\n        manipulate: function (node) {\n            var name = node.name;\n\n            if (node.appendTo) {\n                this.insert(name, node.appendTo, -1);\n            }\n\n            if (node.prependTo) {\n                this.insert(name, node.prependTo, 0);\n            }\n\n            if (node.insertTo) {\n                this.insertTo(name, node.insertTo);\n            }\n\n            return this;\n        },\n\n        insert: function (item, target, position) {\n            registry.get(target, function (container) {\n                container.insertChild(item, position);\n            });\n\n            return this;\n        },\n\n        insertTo: function (item, targets) {\n            _.each(targets, function (info, target) {\n                this.insert(item, target, info.position);\n            }, this);\n\n            return this;\n        },\n\n        addChild: function (parent, child) {\n            var name;\n\n            if (parent && parent.component) {\n                name = child.name || child;\n\n                this.insert(name, parent.name, child.sortOrder);\n            }\n\n            return this;\n        },\n\n        merge: function (components) {\n            var cachedKey = _.keys(components)[0],\n                compared = utils.compare(cachedConfig[cachedKey], components),\n                remove = this.filterComponents(this.getByProperty(compared.changes, 'type', 'remove'), true),\n                update = this.getByProperty(compared.changes, 'type', 'update'),\n                dataSources = this.getDataSources(components),\n                names, index, name, component;\n\n            _.each(dataSources, function (val, key) {\n                name = key.replace(/\\.children|\\.config/g, '');\n                component = registry.get(name);\n\n                component.cacheData();\n                component.updateConfig(\n                    true,\n                    this.getFullConfig(key, components),\n                    this.getFullConfig(key, cachedConfig[cachedKey])\n                );\n            }, this);\n\n            _.each(remove, function (val) {\n                component = registry.get(val.path);\n\n                if (component) {\n                    component.cleanData().destroy();\n                }\n            });\n\n            update = _.compact(_.filter(update, function (val) {\n                return !_.isEqual(val.oldValue, val.value);\n            }));\n\n            _.each(update, function (val) {\n                names = val.path.split('.');\n                index = Math.max(_.lastIndexOf(names, 'config'), _.lastIndexOf(names, 'children') + 2);\n                name = _.without(names.splice(0, index), 'children', 'config').join('.');\n                component = registry.get(name);\n\n                if (val.name === 'sortOrder' && component) {\n                    registry.get(component.parentName).insertChild(component, val.value);\n                } else if (component) {\n                    component.updateConfig(\n                        val.oldValue,\n                        val.value,\n                        val.path\n                    );\n                }\n            }, this);\n\n            run(components, undefined, true);\n        },\n\n        getDataSources: function (config, parentPath) {\n            var dataSources = {},\n                key, obj;\n\n            for (key in config) {\n                if (config.hasOwnProperty(key)) {\n                    if (\n                        key === 'type' &&\n                        config[key] === 'dataSource' &&\n                        config.hasOwnProperty('config')\n                    ) {\n                        dataSources[parentPath + '.config'] = config.config;\n                    } else if (_.isObject(config[key])) {\n                        obj = this.getDataSources(config[key], utils.fullPath(parentPath, key));\n\n                        _.each(obj, function (value, path) {\n                            dataSources[path] = value;\n                        });\n                    }\n                }\n            }\n\n            return dataSources;\n        },\n\n        getFullConfig: function (path, config) {\n            var index;\n\n            path = path.split('.');\n            index = _.lastIndexOf(path, 'config');\n\n            if (!~index) {\n                return false;\n            }\n            path = path.splice(0, index);\n\n            _.each(path, function (val) {\n                config = config[val];\n            });\n\n            return config.config;\n        },\n\n        getByProperty: function (data, prop, propValue) {\n            return _.filter(data, function (value) {\n                return value[prop] === propValue;\n            });\n        },\n\n        filterComponents: function (data, splitPath, index, separator, keyName) {\n            var result = [],\n                names, length;\n\n            index = -2;\n            separator = '.' || separator;\n            keyName = 'children' || keyName;\n\n            _.each(data, function (val) {\n                names = val.path.split(separator);\n                length  = names.length;\n\n                if (names[length + index] === keyName) {\n                    val.path = splitPath ? _.without(names, keyName).join(separator) : val.path;\n                    result.push(val);\n                }\n            });\n\n            return result;\n        }\n    });\n\n    return run;\n});\n","Magento_Ui/js/core/renderer/types.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils'\n], function (_, utils) {\n    'use strict';\n\n    var store = {};\n\n    function flatten(data) {\n        var extender = data.extends || [],\n            result = {};\n\n        extender = utils.stringToArray(extender);\n\n        extender.push(data);\n\n        extender.forEach(function (item) {\n            if (_.isString(item)) {\n                item = store[item] || {};\n            }\n\n            utils.extend(result, item);\n        });\n\n        delete result.extends;\n\n        return result;\n    }\n\n    return {\n        set: function (types) {\n            types = types || {};\n\n            utils.extend(store, types);\n\n            _.each(types, function (data, type) {\n                store[type] = flatten(data);\n            });\n        },\n\n        get: function (type) {\n            return store[type] || {};\n        }\n    };\n});\n","Magento_Ui/js/form/adapter.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var buttons = {\n            'reset':            '#reset',\n            'save':             '#save',\n            'saveAndContinue':  '#save_and_continue'\n        },\n        selectorPrefix = '',\n        eventPrefix;\n\n    /**\n     * Initialize listener.\n     *\n     * @param {Function} callback\n     * @param {String} action\n     */\n    function initListener(callback, action) {\n        var selector    = selectorPrefix ? selectorPrefix + ' ' + buttons[action] : buttons[action],\n            elem        = $(selector)[0];\n\n        if (!elem) {\n            return;\n        }\n\n        if (elem.onclick) {\n            elem.onclick = null;\n        }\n\n        $(elem).on('click' + eventPrefix, callback);\n    }\n\n    /**\n     * Destroy listener.\n     *\n     * @param {String} action\n     */\n    function destroyListener(action) {\n        var selector    = selectorPrefix ? selectorPrefix + ' ' + buttons[action] : buttons[action],\n            elem        = $(selector)[0];\n\n        if (!elem) {\n            return;\n        }\n\n        if (elem.onclick) {\n            elem.onclick = null;\n        }\n\n        $(elem).off('click' + eventPrefix);\n    }\n\n    return {\n\n        /**\n         * Attaches events handlers.\n         *\n         * @param {Object} handlers\n         * @param {String} selectorPref\n         * @param {String} eventPref\n         */\n        on: function (handlers, selectorPref, eventPref) {\n            selectorPrefix = selectorPrefix || selectorPref;\n            eventPrefix = eventPref;\n            _.each(handlers, initListener);\n            selectorPrefix = '';\n        },\n\n        /**\n         * Removes events handlers.\n         *\n         * @param {Object} handlers\n         * @param {String} eventPref\n         */\n        off: function (handlers, eventPref) {\n            eventPrefix = eventPref;\n            _.each(handlers, destroyListener);\n        }\n    };\n});","Magento_Ui/js/form/button-adapter.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiClass',\n    'jquery',\n    'underscore',\n    'uiRegistry'\n], function (Class, $, _, registry) {\n    'use strict';\n\n    return Class.extend({\n\n        /**\n         * Initialize actions and adapter.\n         *\n         * @param {Object} config\n         * @param {Element} elem\n         * @returns {Object}\n         */\n        initialize: function (config, elem) {\n            return this._super()\n                .initActions()\n                .initAdapter(elem);\n        },\n\n        /**\n         * Creates callback from declared actions.\n         *\n         * @returns {Object}\n         */\n        initActions: function () {\n            var callbacks = [];\n\n            _.each(this.actions, function (action) {\n                callbacks.push({\n                    action: registry.async(action.targetName),\n                    args: _.union([action.actionName], action.params)\n                });\n            });\n\n            /**\n             * Callback function.\n             */\n            this.callback = function () {\n                _.each(callbacks, function (callback) {\n                    callback.action.apply(callback.action, callback.args);\n                });\n            };\n\n            return this;\n        },\n\n        /**\n         * Attach callback handler on button.\n         *\n         * @param {Element} elem\n         */\n        initAdapter: function (elem) {\n            $(elem).on('click', this.callback);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/client.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    /**\n     * Before save validate request.\n     *\n     * @param {Object} data\n     * @param {String} url\n     * @param {String} selectorPrefix\n     * @param {String} messagesClass\n     * @returns {*}\n     */\n    function beforeSave(data, url, selectorPrefix, messagesClass) {\n        var save = $.Deferred();\n\n        data = utils.serialize(data);\n\n        data['form_key'] = window.FORM_KEY;\n\n        if (!url || url === 'undefined') {\n            return save.resolve();\n        }\n\n        $('body').trigger('processStart');\n\n        $.ajax({\n            url: url,\n            data: data,\n\n            /**\n             * Success callback.\n             * @param {Object} resp\n             * @returns {Boolean}\n             */\n            success: function (resp) {\n                if (!resp.error) {\n                    save.resolve();\n\n                    return true;\n                }\n\n                $('body').notification('clear');\n                $.each(resp.messages || [resp.message] || [], function (key, message) {\n                    $('body').notification('add', {\n                        error: resp.error,\n                        message: message,\n\n                        /**\n                         * Insert method.\n                         *\n                         * @param {String} msg\n                         */\n                        insertMethod: function (msg) {\n                            var $wrapper = $('<div/>').addClass(messagesClass).html(msg);\n\n                            $('.page-main-actions', selectorPrefix).after($wrapper);\n                        }\n                    });\n                });\n            },\n\n            /**\n             * Complete callback.\n             */\n            complete: function () {\n                $('body').trigger('processStop');\n            }\n        });\n\n        return save.promise();\n    }\n\n    return Class.extend({\n\n        /**\n         * Assembles data and submits it using 'utils.submit' method\n         */\n        save: function (data, options) {\n            var url = this.urls.beforeSave,\n                save = this._save.bind(this, data, options);\n\n            beforeSave(data, url, this.selectorPrefix, this.messagesClass).then(save);\n\n            return this;\n        },\n\n        /**\n         * Save data.\n         *\n         * @param {Object} data\n         * @param {Object} options\n         * @returns {Object}\n         * @private\n         */\n        _save: function (data, options) {\n            var url = this.urls.save;\n\n            options = options || {};\n\n            if (!options.redirect) {\n                url += 'back/edit';\n            }\n\n            if (options.ajaxSave) {\n                utils.ajaxSubmit({\n                    url: url,\n                    data: data\n                }, options);\n\n                return this;\n            }\n\n            utils.submit({\n                url: url,\n                data: data\n            }, options.attributes);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/spinner',\n    'rjsResolver',\n    './adapter',\n    'uiCollection',\n    'mageUtils',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'mage/validation'\n], function (_, loader, resolver, adapter, Collection, utils, $, app) {\n    'use strict';\n\n    /**\n     * Format params\n     *\n     * @param {Object} params\n     * @returns {Array}\n     */\n    function prepareParams(params) {\n        var result = '?';\n\n        _.each(params, function (value, key) {\n            result += key + '=' + value + '&';\n        });\n\n        return result.slice(0, -1);\n    }\n\n    /**\n     * Collect form data.\n     *\n     * @param {Array} items\n     * @returns {Object}\n     */\n    function collectData(items) {\n        var result = {};\n\n        items = Array.prototype.slice.call(items);\n\n        items.forEach(function (item) {\n            switch (item.type) {\n                case 'checkbox':\n                    result[item.name] = +!!item.checked;\n                    break;\n\n                case 'radio':\n                    if (item.checked) {\n                        result[item.name] = item.value;\n                    }\n                    break;\n\n                default:\n                    result[item.name] = item.value;\n            }\n        });\n\n        return result;\n    }\n\n    /**\n     * Makes ajax request\n     *\n     * @param {Object} params\n     * @param {Object} data\n     * @param {String} url\n     * @returns {*}\n     */\n    function makeRequest(params, data, url) {\n        var save = $.Deferred();\n\n        data = utils.serialize(data);\n        data['form_key'] = window.FORM_KEY;\n\n        if (!url) {\n            save.resolve();\n        }\n\n        $('body').trigger('processStart');\n\n        $.ajax({\n            url: url + prepareParams(params),\n            data: data,\n            dataType: 'json',\n\n            /**\n             * Success callback.\n             * @param {Object} resp\n             * @returns {Boolean}\n             */\n            success: function (resp) {\n                if (resp.ajaxExpired) {\n                    window.location.href = resp.ajaxRedirect;\n                }\n\n                if (!resp.error) {\n                    save.resolve(resp);\n\n                    return true;\n                }\n\n                $('body').notification('clear');\n                $.each(resp.messages, function (key, message) {\n                    $('body').notification('add', {\n                        error: resp.error,\n                        message: message,\n\n                        /**\n                         * Inserts message on page\n                         * @param {String} msg\n                         */\n                        insertMethod: function (msg) {\n                            $('.page-main-actions').after(msg);\n                        }\n                    });\n                });\n            },\n\n            /**\n             * Complete callback.\n             */\n            complete: function () {\n                $('body').trigger('processStop');\n            }\n        });\n\n        return save.promise();\n    }\n\n    /**\n     * Check if fields is valid.\n     *\n     * @param {Array}items\n     * @returns {Boolean}\n     */\n    function isValidFields(items) {\n        var result = true;\n\n        _.each(items, function (item) {\n            if (!$.validator.validateSingleElement(item)) {\n                result = false;\n            }\n        });\n\n        return result;\n    }\n\n    return Collection.extend({\n        defaults: {\n            additionalFields: [],\n            additionalInvalid: false,\n            selectorPrefix: '.page-content',\n            messagesClass: 'messages',\n            eventPrefix: '.${ $.index }',\n            ajaxSave: false,\n            ajaxSaveType: 'default',\n            imports: {\n                reloadUrl: '${ $.provider}:reloadUrl'\n            },\n            listens: {\n                selectorPrefix: 'destroyAdapter initAdapter',\n                '${ $.name }.${ $.reloadItem }': 'params.set reload'\n            },\n            exports: {\n                selectorPrefix: '${ $.provider }:client.selectorPrefix',\n                messagesClass: '${ $.provider }:client.messagesClass'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initAdapter();\n\n            resolver(this.hideLoader, this);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'responseData',\n                    'responseStatus'\n                ]);\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n\n            this.selector = '[data-form-part=' + this.namespace + ']';\n\n            return this;\n        },\n\n        /**\n         * Initialize adapter handlers.\n         *\n         * @returns {Object}\n         */\n        initAdapter: function () {\n            adapter.on({\n                'reset': this.reset.bind(this),\n                'save': this.save.bind(this, true, {}),\n                'saveAndContinue': this.save.bind(this, false, {})\n            }, this.selectorPrefix, this.eventPrefix);\n\n            return this;\n        },\n\n        /**\n         * Destroy adapter handlers.\n         *\n         * @returns {Object}\n         */\n        destroyAdapter: function () {\n            adapter.off([\n                'reset',\n                'save',\n                'saveAndContinue'\n            ], this.eventPrefix);\n\n            return this;\n        },\n\n        /**\n         * Hide loader.\n         *\n         * @returns {Object}\n         */\n        hideLoader: function () {\n            loader.get(this.name).hide();\n\n            return this;\n        },\n\n        /**\n         * Validate and save form.\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        save: function (redirect, data) {\n            this.validate();\n\n            if (!this.additionalInvalid && !this.source.get('params.invalid')) {\n                this.setAdditionalData(data)\n                    .submit(redirect);\n            }\n        },\n\n        /**\n         * Set additional data to source before form submit and after validation.\n         *\n         * @param {Object} data\n         * @returns {Object}\n         */\n        setAdditionalData: function (data) {\n            _.each(data, function (value, name) {\n                this.source.set('data.' + name, value);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Submits form\n         *\n         * @param {String} redirect\n         */\n        submit: function (redirect) {\n            var additional = collectData(this.additionalFields),\n                source = this.source;\n\n            _.each(additional, function (value, name) {\n                source.set('data.' + name, value);\n            });\n\n            source.save({\n                redirect: redirect,\n                ajaxSave: this.ajaxSave,\n                ajaxSaveType: this.ajaxSaveType,\n                response: {\n                    data: this.responseData,\n                    status: this.responseStatus\n                },\n                attributes: {\n                    id: this.namespace\n                }\n            });\n        },\n\n        /**\n         * Validates each element and returns true, if all elements are valid.\n         */\n        validate: function () {\n            this.additionalFields = document.querySelectorAll(this.selector);\n            this.source.set('params.invalid', false);\n            this.source.trigger('data.validate');\n            this.set('additionalInvalid', !isValidFields(this.additionalFields));\n        },\n\n        /**\n         * Trigger reset form data.\n         */\n        reset: function () {\n            this.source.trigger('data.reset');\n        },\n\n        /**\n         * Trigger overload form data.\n         */\n        overload: function () {\n            this.source.trigger('data.overload');\n        },\n\n        /**\n         * Updates data from server.\n         */\n        reload: function () {\n            makeRequest(this.params, this.data, this.reloadUrl).then(function (data) {\n                app(data, true);\n            });\n        }\n    });\n});\n","Magento_Ui/js/form/provider.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    './client',\n    'mageUtils'\n], function (_, Element, Client, utils) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            clientConfig: {\n                urls: {\n                    save: '${ $.submit_url }',\n                    beforeSave: '${ $.validate_url }'\n                }\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initClient();\n\n            return this;\n        },\n\n        /**\n         * Initializes client component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initClient: function () {\n            this.client = new Client(this.clientConfig);\n\n            return this;\n        },\n\n        /**\n         * Saves currently available data.\n         *\n         * @param {Object} [options] - Addtitional request options.\n         * @returns {Provider} Chainable.\n         */\n        save: function (options) {\n            var data = this.get('data');\n\n            this.client.save(data, options);\n\n            return this;\n        },\n\n        /**\n         * Update data that stored in provider.\n         *\n         * @param {Boolean} isProvider\n         * @param {Object} newData\n         * @param {Object} oldData\n         *\n         * @returns {Provider}\n         */\n        updateConfig: function (isProvider, newData, oldData) {\n            if (isProvider === true) {\n                this.setData(oldData, newData, this);\n            }\n\n            return this;\n        },\n\n        /**\n         *  Set data to provder based on current data.\n         *\n         * @param {Object} oldData\n         * @param {Object} newData\n         * @param {Provider} current\n         * @param {String} parentPath\n         */\n        setData: function (oldData, newData, current, parentPath) {\n\n            /* eslint-disable eqeqeq */\n            _.each(newData, function (val, key) {\n                if (_.isObject(val) || _.isArray(val)) {\n                    this.setData(oldData[key], val, current[key], utils.fullPath(parentPath, key));\n                } else if (val != oldData[key] && oldData[key] == current[key]) {\n                    this.set(utils.fullPath(parentPath, key), val);\n                }\n            }, this);\n\n            /* eslint-enable eqeqeq */\n        }\n    });\n});\n","Magento_Ui/js/form/switcher.js":"define([\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (_, registry, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            rules: []\n        },\n\n        /**\n         * Initializes instance of a DataSwitcher.\n         *\n         * @returns {DataSwitcher} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initRules();\n\n            return this;\n        },\n\n        /**\n         *\n         * @returns {DataSwitcher} Chainable.\n         */\n        initRules: function () {\n            this.rules.forEach(this.initRule, this);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule definition.\n         * @returns {DataSwitcher} Chainable.\n         */\n        initRule: function (rule) {\n            var handler = this.onValueChange.bind(this, rule);\n\n            if (!rule.target) {\n                rule.target = this.target;\n            }\n\n            if (!rule.property) {\n                rule.property = this.property;\n            }\n\n            registry.get(rule.target, function (target) {\n                this.applyRule(rule, target.get(rule.property));\n                target.on(rule.property, handler);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule definition.\n         * @returns {DataSwitcher} Chainable.\n         */\n        addRule: function (rule) {\n            this.rules.push(rule);\n            this.initRule(rule);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule object.\n         * @param {*} value - Current value associated with a rule.\n         */\n        applyRule: function (rule, value) {\n            var actions = rule.actions;\n\n            //TODO Refactor this logic in scope of MAGETWO-48585\n            /* eslint-disable eqeqeq */\n            if (rule.value != value) {\n                return;\n            } else if (rule.strict) {\n                return;\n            }\n\n            /* eslint-enable eqeqeq */\n            actions.forEach(this.applyAction, this);\n        },\n\n        /**\n         *\n         * @param {Object} action - Action object.\n         */\n        applyAction: function (action) {\n            registry.get(action.target, function (target) {\n                var callback = target[action.callback];\n\n                callback.apply(target, action.params || []);\n            });\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rules object.\n         * @param {*} value - Current value associated with a rule.\n         */\n        onValueChange: function (rule, value) {\n            this.applyRule(rule, value);\n        }\n    });\n});\n","Magento_Ui/js/form/components/area.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    './tab'\n], function (_, Tab) {\n    'use strict';\n\n    return Tab.extend({\n        defaults: {\n            uniqueNs:   'params.activeArea',\n            template:   'ui/area',\n            changed:    false,\n            loading:    false\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onChildrenUpdate', 'onContentLoading');\n\n            return this._super();\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('changed loading');\n\n            return this;\n        },\n\n        /**\n         * Calls parent's initElement method.\n         * Assignes callbacks on various events of incoming element.\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.on({\n                'update':   this.onChildrenUpdate,\n                'loading':  this.onContentLoading\n            });\n\n            return this;\n        },\n\n        /**\n         * Is being invoked on children update.\n         * Sets changed property to one incoming.\n         * Invokes setActive method if settings\n         * contain makeVisible property set to true.\n         *\n         * @param  {Boolean} hasChanged\n         */\n        onChildrenUpdate: function (hasChanged) {\n            if (!hasChanged) {\n                hasChanged = _.some(this.delegate('hasChanged'));\n            }\n\n            this.changed(hasChanged);\n        },\n\n        /**\n         * Callback that sets loading property to true.\n         */\n        onContentLoading: function (isLoading) {\n            this.loading(isLoading);\n        }\n    });\n});\n","Magento_Ui/js/form/components/button.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'uiRegistry',\n    'uiLayout',\n    'mageUtils'\n], function (Element, registry, layout, utils) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            additionalClasses: {},\n            displayArea: 'outsideGroup',\n            displayAsLink: false,\n            elementTmpl: 'ui/form/element/button',\n            template: 'ui/form/components/button/simple',\n            visible: true,\n            disabled: false,\n            title: ''\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            return this._super()\n                ._setClasses();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'visible',\n                    'disabled',\n                    'title'\n                ]);\n        },\n\n        /**\n         * Performs configured actions\n         */\n        action: function () {\n            this.actions.forEach(this.applyAction, this);\n        },\n\n        /**\n         * Apply action on target component,\n         * but previously create this component from template if it is not existed\n         *\n         * @param {Object} action - action configuration\n         */\n        applyAction: function (action) {\n            var targetName = action.targetName,\n                params = action.params || [],\n                actionName = action.actionName,\n                target;\n\n            if (!registry.has(targetName)) {\n                this.getFromTemplate(targetName);\n            }\n            target = registry.async(targetName);\n\n            if (target && typeof target === 'function' && actionName) {\n                params.unshift(actionName);\n                target.apply(target, params);\n            }\n        },\n\n        /**\n         * Create target component from template\n         *\n         * @param {Object} targetName - name of component,\n         * that supposed to be a template and need to be initialized\n         */\n        getFromTemplate: function (targetName) {\n            var parentName = targetName.split('.'),\n                index = parentName.pop(),\n                child;\n\n            parentName = parentName.join('.');\n            child = utils.template({\n                parent: parentName,\n                name: index,\n                nodeTemplate: targetName\n            });\n            layout([child]);\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Object} Chainable.\n         */\n        _setClasses: function () {\n            if (typeof this.additionalClasses === 'string') {\n                this.additionalClasses = this.additionalClasses\n                    .trim()\n                    .split(' ')\n                    .reduce(function (classes, name) {\n                        classes[name] = true;\n\n                        return classes;\n                    }, {}\n                );\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/components/collection.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Ui/js/modal/confirm'\n], function (_, utils, registry, Component, layout, confirm) {\n    'use strict';\n\n    var childTemplate = {\n        parent: '${ $.$data.name }',\n        name: '${ $.$data.childIndex }',\n        dataScope: '${ $.name }',\n        nodeTemplate: '${ $.$data.name }.${ $.$data.itemTemplate }'\n    };\n\n    return Component.extend({\n        defaults: {\n            lastIndex: 0,\n            template: 'ui/form/components/collection'\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method.\n         */\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            return this;\n        },\n\n        /**\n         * Activates the incoming child and triggers the update event.\n         *\n         * @param {Object} elem - Incoming child.\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.activate();\n\n            this.bubble('update');\n\n            return this;\n        },\n\n        /**\n         * Loops over corresponding data in data storage,\n         * creates child for each and pushes it's identifier to initialItems array.\n         *\n         * @returns {Collection} Chainable.\n         */\n        initChildren: function () {\n            var children = this.source.get(this.dataScope),\n                initial = this.initialItems = [];\n\n            _.each(children, function (item, index) {\n                initial.push(index);\n                this.addChild(index);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Creates new item of collection, based on incoming 'index'.\n         * If not passed creates one with 'new_' prefix.\n         *\n         * @param {String|Object} [index] - Index of a child.\n         * @returns {Collection} Chainable.\n         */\n        addChild: function (index) {\n            this.childIndex = !_.isString(index) ?\n                'new_' + this.lastIndex++ :\n                index;\n\n            layout([utils.template(childTemplate, this)]);\n\n            return this;\n        },\n\n        /**\n         * Returnes true if current set of items differ from initial one,\n         * or if some child has been changed.\n         *\n         * @returns {Boolean}\n         */\n        hasChanged: function () {\n            var initial = this.initialItems,\n                current = this.elems.pluck('index'),\n                changed = !utils.equalArrays(initial, current);\n\n            return changed || this.elems.some(function (elem) {\n                return _.some(elem.delegate('hasChanged'));\n            });\n        },\n\n        /**\n         * Initiates validation of its' children components.\n         *\n         * @returns {Array} An array of validation results.\n         */\n        validate: function () {\n            var elems;\n\n            this.allValid = true;\n\n            elems = this.elems.sortBy(function (elem) {\n                return !elem.active();\n            });\n\n            elems = elems.map(this._validate, this);\n\n            return _.flatten(elems);\n        },\n\n        /**\n         * Iterator function for components validation.\n         * Activates first invalid child component.\n         *\n         * @param {Object} elem - Element to run validation on.\n         * @returns {Array} An array of validation results.\n         */\n        _validate: function (elem) {\n            var result = elem.delegate('validate'),\n                invalid;\n\n            invalid = _.some(result, function (item) {\n                return !item.valid;\n            });\n\n            if (this.allValid && invalid) {\n                this.allValid = false;\n\n                elem.activate();\n            }\n\n            return result;\n        },\n\n        /**\n         * Creates function that removes element\n         * from collection using '_removeChild' method.\n         * @param  {Object} elem - Element that should be removed.\n         * @returns {Function}\n         *      Since this method is used by 'click' binding,\n         *      it requires function to invoke.\n         */\n        removeAddress: function (elem) {\n            var self = this;\n\n            confirm({\n                content: this.removeMessage,\n                actions: {\n                    confirm: function () {\n                        self._removeAddress(elem)\n                    }\n                }\n            });\n        },\n\n        /**\n         * Removes elememt from both collection and data storage,\n         * activates first element if removed one was active,\n         * triggers 'update' event.\n         *\n         * @param {Object} elem - Element to remove.\n         */\n        _removeAddress: function (elem) {\n            var isActive = elem.active(),\n                first;\n\n            elem.destroy();\n\n            first = this.elems.first();\n\n            if (first && isActive) {\n                first.activate();\n            }\n\n            this.bubble('update');\n        }\n    });\n});\n","Magento_Ui/js/form/components/fieldset.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/lib/collapsible',\n    'underscore'\n], function (Collapsible, _) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            template: 'ui/form/fieldset',\n            collapsible: false,\n            changed: false,\n            loading: false,\n            error: false,\n            opened: false,\n            level: 0,\n            visible: true,\n            disabled: false,\n            additionalClasses: {}\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onChildrenUpdate', 'onChildrenError', 'onContentLoading');\n\n            return this._super()\n                       ._setClasses();\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         *\n         * @returns {Object} Reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('changed loading error visible');\n\n            return this;\n        },\n\n        /**\n         * Calls parent's initElement method.\n         * Assignes callbacks on various events of incoming element.\n         *\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            elem.initContainer(this);\n\n            elem.on({\n                'update':   this.onChildrenUpdate,\n                'loading':  this.onContentLoading,\n                'error':  this.onChildrenError\n            });\n\n            if (this.disabled) {\n                try {\n                    elem.disabled(true);\n                }\n                catch (e) {\n\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Is being invoked on children update.\n         * Sets changed property to one incoming.\n         *\n         * @param  {Boolean} hasChanged\n         */\n        onChildrenUpdate: function (hasChanged) {\n            if (!hasChanged) {\n                hasChanged = _.some(this.delegate('hasChanged'));\n            }\n\n            this.changed(hasChanged);\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var addtional = this.additionalClasses,\n                classes;\n\n            if (_.isString(addtional)) {\n                addtional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                addtional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__collapsible-block-wrapper': this.collapsible,\n                _show: this.opened,\n                _hide: !this.opened,\n                _disabled: this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Is being invoked on children validation error.\n         * Sets error property to one incoming.\n         *\n         * @param {String} message - error message.\n         */\n        onChildrenError: function (message) {\n            var hasErrors = this.elems.some('error');\n\n            this.error(hasErrors || message);\n        },\n\n        /**\n         * Callback that sets loading property to true.\n         */\n        onContentLoading: function (isLoading) {\n            this.loading(isLoading);\n        }\n    });\n});\n","Magento_Ui/js/form/components/group.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiCollection'\n], function (_, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            showLabel: true,\n            required: false,\n            template: 'ui/group/group',\n            fieldTemplate: 'ui/form/field',\n            breakLine: true,\n            validateWholeGroup: false,\n            additionalClasses: {}\n        },\n\n        /**\n         * Extends this with defaults and config.\n         * Then calls initObservable, iniListenes and extractData methods.\n         */\n        initialize: function () {\n            this._super()\n                ._setClasses();\n\n            return this;\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('visible')\n                .observe({\n                    required: !!+this.required\n                });\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var addtional = this.additionalClasses,\n                classes;\n\n            if (_.isString(addtional)) {\n                addtional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                addtional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__control-grouped': !this.breakLine,\n                'admin__control-fields': this.breakLine,\n                required:   this.required,\n                _error:     this.error,\n                _disabled:  this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Defines if group has only one element.\n         * @return {Boolean}\n         */\n        isSingle: function () {\n            return this.elems.getLength() === 1;\n        },\n\n        /**\n         * Defines if group has multiple elements.\n         * @return {Boolean}\n         */\n        isMultiple: function () {\n            return this.elems.getLength() > 1;\n        },\n\n        /**\n         * Returns an array of child components previews.\n         *\n         * @returns {Array}\n         */\n        getPreview: function () {\n            return this.elems.map('getPreview');\n        }\n    });\n});\n","Magento_Ui/js/form/components/html.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent'\n], function ($, _, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            content:        '',\n            showSpinner:    false,\n            loading:        false,\n            visible:        true,\n            template:       'ui/content/content',\n            additionalClasses: {}\n        },\n\n        /**\n         * Extends instance with default config, calls 'initialize' method of\n         *     parent, calls 'initAjaxConfig'\n         */\n        initialize: function () {\n            _.bindAll(this, 'onContainerToggle', 'onDataLoaded');\n\n            this._super()\n                ._setClasses()\n                .initAjaxConfig();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' method of parent, initializes observable\n         * properties of instance\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('content loading visible');\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses,\n                classes;\n\n            if (_.isString(additional)) {\n                additional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__scope-old': !!additional\n            });\n\n            return this;\n        },\n\n        initContainer: function (parent) {\n            this._super();\n\n            parent.on('active', this.onContainerToggle);\n\n            return this;\n        },\n\n        /**\n         * Initializes default ajax config on instance\n         *\n         * @return {Object} - reference to instance\n         */\n        initAjaxConfig: function () {\n            this.ajaxConfig = {\n                url: this.url,\n                data: {\n                    FORM_KEY: window.FORM_KEY\n                },\n                success:    this.onDataLoaded\n            };\n\n            return this;\n        },\n\n        /**\n         * Calls 'loadData' if both 'active' variable and 'shouldLoad'\n         * property are truthy\n         *\n         * @param  {Boolean} active\n         */\n        onContainerToggle: function (active) {\n            if (active && this.shouldLoad()) {\n                this.loadData();\n            }\n        },\n\n        /**\n         * Defines if instance has 'content' property defined.\n         *\n         * @return {Boolean} [description]\n         */\n        hasData: function () {\n            return !!this.content();\n        },\n\n        /**\n         * Defines if instance should load external data\n         *\n         * @return {Boolean}\n         */\n        shouldLoad: function () {\n            return this.url && !this.hasData() && !this.loading();\n        },\n\n        /**\n         * Sets loading property to true, makes ajax call\n         *\n         * @return {Object} - reference to instance\n         */\n        loadData: function () {\n            this.loading(true);\n\n            $.ajax(this.ajaxConfig);\n\n            return this;\n        },\n\n        /**\n         * Ajax's request success handler. Calls 'updateContent' passing 'data'\n         * to it, then sets 'loading' property to false.\n         *\n         * @param  {String} data\n         */\n        onDataLoaded: function (data) {\n            this.updateContent(data)\n                .loading(false);\n        },\n\n        /**\n         * Sets incoming data 'content' property's value\n         *\n         * @param  {String} content\n         * @return {Object} - reference to instance\n         */\n        updateContent: function (content) {\n            this.content(content);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/components/insert-form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './insert',\n    'mageUtils',\n    'jquery'\n], function (Insert, utils, $) {\n    'use strict';\n\n    /**\n     * Get page actions element.\n     *\n     * @param {String} elem\n     * @param {String} actionsClass\n     * @returns {String}\n     */\n    function getPageActions(elem, actionsClass) {\n        var el = document.createElement('div');\n\n        el.innerHTML = elem;\n\n        return el.getElementsByClassName(actionsClass)[0];\n    }\n\n    /**\n     * Return element without page actions toolbar\n     *\n     * @param {String} elem\n     * @param {String} actionsClass\n     * @returns {String}\n     */\n    function removePageActions(elem, actionsClass) {\n        var el = document.createElement('div'),\n            actions;\n\n        el.innerHTML = elem;\n        actions = el.getElementsByClassName(actionsClass)[0];\n        el.removeChild(actions);\n\n        return el.innerHTML;\n    }\n\n    return Insert.extend({\n        defaults: {\n            externalFormName: '${ $.ns }.${ $.ns }',\n            pageActionsClass: 'page-actions',\n            actionsContainerClass: 'page-main-actions',\n            exports: {\n                prefix: '${ $.externalFormName }:selectorPrefix'\n            },\n            imports: {\n                toolbarSection: '${ $.toolbarContainer }:toolbarSection',\n                prefix: '${ $.toolbarContainer }:rootSelector',\n                messagesClass: '${ $.externalFormName }:messagesClass'\n            },\n            settings: {\n                ajax: {\n                    ajaxSave: true,\n                    exports: {\n                        ajaxSave: '${ $.externalFormName }:ajaxSave'\n                    },\n                    imports: {\n                        responseStatus: '${ $.externalFormName }:responseStatus',\n                        responseData: '${ $.externalFormName }:responseData'\n                    }\n                }\n            },\n            modules: {\n                externalForm: '${ $.externalFormName }'\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('responseStatus');\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var defaults = this.constructor.defaults;\n\n            utils.extend(defaults, defaults.settings[config.formSubmitType] || {});\n\n            return this._super();\n        },\n\n        /** @inheritdoc*/\n        destroyInserted: function () {\n            if (this.isRendered && this.externalForm()) {\n                this.externalForm().delegate('destroy');\n                this.removeActions();\n                this.responseStatus(undefined);\n                this.responseData = {};\n            }\n\n            return this._super();\n        },\n\n        /** @inheritdoc */\n        onRender: function (data) {\n            var actions = getPageActions(data, this.pageActionsClass);\n\n            if (!data.length) {\n                return this;\n            }\n            data = removePageActions(data, this.pageActionsClass);\n            this.renderActions(actions);\n            this._super(data);\n        },\n\n        /**\n         * Insert actions in toolbar.\n         *\n         * @param {String} actions\n         */\n        renderActions: function (actions) {\n            var $container = $('<div/>');\n\n            $container\n                .addClass(this.actionsContainerClass)\n                .append(actions);\n\n            this.formHeader = $container;\n\n            $(this.toolbarSection).append(this.formHeader);\n        },\n\n        /**\n         * Remove actions toolbar.\n         */\n        removeActions: function () {\n            $(this.formHeader).siblings('.' + this.messagesClass).remove();\n            $(this.formHeader).remove();\n            this.formHeader = $();\n        },\n\n        /**\n         * Reset external form data.\n         */\n        resetForm: function () {\n            if (this.externalSource()) {\n                this.externalSource().trigger('data.reset');\n                this.responseStatus(undefined);\n            }\n        }\n    });\n});\n","Magento_Ui/js/form/components/tab.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiCollection'\n], function (Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            uniqueProp:     'active',\n            active:         false,\n            wasActivated:   false\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            this._super()\n                .setUnique();\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('active wasActivated');\n\n            return this;\n        },\n\n        /**\n         * Sets active property to true, then invokes pushParams method.\n         */\n        activate: function () {\n            this.active(true);\n            this.wasActivated(true);\n\n            this.setUnique();\n\n            return true;\n        }\n    });\n});\n","Magento_Ui/js/form/components/tab_group.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/collapsible'\n], function (_, Collapsible) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.validate': 'onValidate'\n            },\n            collapsible: false,\n            opened: true\n        },\n\n        /**\n         * Invokes initElement method of parent class, calls 'initActivation' method\n         * passing element to it.\n         * @param {Object} elem\n         * @returns {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            this._super()\n                .initActivation(elem);\n\n            return this;\n        },\n\n        /**\n         * Activates element if one is first or if one has 'active' propert\n         * set to true.\n         *\n         * @param  {Object} elem\n         * @returns {Object} - reference to instance\n         */\n        initActivation: function (elem) {\n            var elems   = this.elems(),\n                isFirst = !elems.indexOf(elem);\n\n            if (isFirst || elem.active()) {\n                elem.activate();\n            }\n\n            return this;\n        },\n\n        /**\n         * Delegates 'validate' method on element, then reads 'invalid' property\n         * of params storage, and if defined, activates element, sets\n         * 'allValid' property of instance to false and sets invalid's\n         * 'focused' property to true.\n         *\n         * @param {Object} elem\n         */\n        validate: function (elem) {\n            var result  = elem.delegate('validate'),\n                invalid;\n\n            invalid = _.find(result, function (item) {\n                return !item.valid;\n            });\n\n            if (invalid) {\n                elem.activate();\n                invalid.target.focused(true);\n            }\n\n            return invalid;\n        },\n\n        /**\n         * Sets 'allValid' property of instance to true, then calls 'validate' method\n         * of instance for each element.\n         */\n        onValidate: function () {\n            this.elems.sortBy(function (elem) {\n                return !elem.active();\n            }).some(this.validate, this);\n        }\n    });\n});\n","Magento_Ui/js/form/components/collection/item.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    '../tab'\n], function (_, utils, Tab) {\n    'use strict';\n\n    var previewConfig = {\n        separator: ' ',\n        prefix: ''\n    };\n\n    /**\n     * Parses incoming data and returnes result merged with default preview config\n     *\n     * @param  {Object|String} data\n     * @return {Object}\n     */\n    function parsePreview(data) {\n        if (typeof data == 'string') {\n            data = {\n                items: data\n            };\n        }\n\n        data.items = utils.stringToArray(data.items);\n\n        return _.defaults(data, previewConfig);\n    }\n\n    return Tab.extend({\n        defaults: {\n            label: '',\n            uniqueNs: 'activeCollectionItem',\n            previewTpl: 'ui/form/components/collection/preview'\n        },\n\n        /**\n         * Extends instance with default config, calls initializes of parent class\n         */\n        initialize: function () {\n            _.bindAll(this, 'buildPreview', 'hasPreview');\n\n            return this._super();\n        },\n\n        /**\n         * Calls initProperties of parent class, initializes properties\n         * of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initConfig: function () {\n            this._super();\n\n            this.displayed = [];\n\n            return this;\n        },\n\n        /**\n         * Calls initObservable of parent class, initializes observable\n         * properties of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    noPreview: true,\n                    indexed: {}\n                });\n\n            return this;\n        },\n\n        /**\n         * Is being called when child element has been initialized,\n         *     calls initElement of parent class, binds to element's update event,\n         *     calls insertToArea and insertToIndexed methods passing element to it\n         *\n         * @param  {Object} elem\n         */\n        initElement: function (elem) {\n            this._super()\n                .insertToIndexed(elem);\n\n            return this;\n        },\n\n        /**\n         * Adds element to observable indexed object of instance\n         *\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        insertToIndexed: function (elem) {\n            var indexed = this.indexed();\n\n            indexed[elem.index] = elem;\n\n            this.indexed(indexed);\n\n            return this;\n        },\n\n        /**\n         * Destroys current instance along with all of its' children.\n         * Overrides base method to clear data when this method is called.\n         */\n        destroy: function () {\n            this._super();\n            this._clearData();\n        },\n\n        /**\n         * Clears all data associated with component.\n         * @private\n         *\n         * @returns {Item} Chainable.\n         */\n        _clearData: function () {\n            this.source.remove(this.dataScope);\n\n            return this;\n        },\n\n        /**\n         * Formats incoming previews array via parsePreview function.\n         *\n         * @param  {Array} previews\n         * @return {Array} - formatted previews\n         */\n        formatPreviews: function (previews) {\n            return previews.map(parsePreview);\n        },\n\n        /**\n         * Creates string view of previews\n         *\n         * @param  {Object} data\n         * @return {Strict} - formatted preview string\n         */\n        buildPreview: function (data) {\n            var preview = this.getPreview(data.items),\n                prefix = data.prefix;\n\n            return prefix + preview.join(data.separator);\n        },\n\n        /**\n         * Defines if instance has preview for incoming data\n         *\n         * @param  {Object}  data\n         * @return {Boolean}\n         */\n        hasPreview: function (data) {\n            return !!this.getPreview(data.items).length;\n        },\n\n        /**\n         * Creates an array of previews for elements specified in incoming\n         * items array, calls updatePreview afterwards.\n         *\n         * @param  {Array} items - An array of element's indexes.\n         * @returns {Array} An array of previews.\n         */\n        getPreview: function (items) {\n            var elems = this.indexed(),\n                displayed = this.displayed,\n                preview;\n\n            items = items.map(function (index) {\n                var elem = elems[index];\n\n                preview = elem && elem.visible() ? elem.getPreview() : '';\n\n                preview = Array.isArray(preview) ?\n                    _.compact(preview).join(', ') :\n                    preview;\n\n                utils.toggle(displayed, index, !!preview);\n\n                return preview;\n            });\n\n            this.noPreview(!displayed.length);\n\n            return _.compact(items);\n        }\n    });\n});\n","Magento_Ui/js/form/element/abstract.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiElement',\n    'Magento_Ui/js/lib/validation/validator'\n], function (_, utils, layout, Element, validator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true,\n            preview: '',\n            focused: false,\n            required: false,\n            disabled: false,\n            valueChangedByUser: false,\n            elementTmpl: 'ui/form/element/input',\n            tooltipTpl: 'ui/form/element/helper/tooltip',\n            fallbackResetTpl: 'ui/form/element/helper/fallback-reset',\n            'input_type': 'input',\n            placeholder: '',\n            description: '',\n            labelVisible: true,\n            label: '',\n            error: '',\n            warn: '',\n            notice: '',\n            customScope: '',\n            default: '',\n            isDifferedFromDefault: false,\n            showFallbackReset: false,\n            additionalClasses: {},\n            isUseDefault: '',\n            valueUpdate: false, // ko binding valueUpdate\n\n            switcherConfig: {\n                component: 'Magento_Ui/js/form/switcher',\n                name: '${ $.name }_switcher',\n                target: '${ $.name }',\n                property: 'value'\n            },\n            listens: {\n                visible: 'setPreview',\n                value: 'setDifferedFromDefault',\n                '${ $.provider }:data.reset': 'reset',\n                '${ $.provider }:data.overload': 'overload',\n                '${ $.provider }:${ $.customScope ? $.customScope + \".\" : \"\"}data.validate': 'validate',\n                'isUseDefault': 'toggleUseDefault'\n            },\n\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            _.bindAll(this, 'reset');\n\n            this._super()\n                .setInitialValue()\n                ._setClasses()\n                .initSwitcher();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            var rules = this.validation = this.validation || {};\n\n            this._super();\n\n            this.observe('error disabled focused preview visible value warn isDifferedFromDefault')\n                .observe('isUseDefault')\n                .observe({\n                    'required': !!rules['required-entry']\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initConfig: function () {\n            var uid = utils.uniqueid(),\n                name,\n                valueUpdate,\n                scope;\n\n            this._super();\n\n            scope   = this.dataScope;\n            name    = scope.split('.').slice(1);\n\n            valueUpdate = this.showFallbackReset ? 'afterkeydown' : this.valueUpdate;\n\n            _.extend(this, {\n                uid: uid,\n                noticeId: 'notice-' + uid,\n                inputName: utils.serializeName(name.join('.')),\n                valueUpdate: valueUpdate\n            });\n\n            return this;\n        },\n\n        /**\n         * Initializes switcher element instance.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initSwitcher: function () {\n            if (this.switcherConfig.enabled) {\n                layout([this.switcherConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets initial value of the element and subscribes to it's changes.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.on('value', this.onUpdate.bind(this));\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses,\n                classes;\n\n            if (_.isString(additional) && additional.trim().length) {\n                additional = this.additionalClasses.trim().split(' ');\n                classes = this.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                _required: this.required,\n                _error: this.error,\n                _warn: this.warn,\n                _disabled: this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Gets initial value of element\n         *\n         * @returns {*} Elements' value.\n         */\n        getInitialValue: function () {\n            var values = [this.value(), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n                    return true;\n                }\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /**\n         * Sets 'value' as 'hidden' propertie's value, triggers 'toggle' event,\n         * sets instance's hidden identifier in params storage based on\n         * 'value'.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        setVisible: function (isVisible) {\n            this.visible(isVisible);\n\n            return this;\n        },\n\n        /**\n         * Show element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        show: function () {\n            this.visible(true);\n\n            return this;\n        },\n\n        /**\n         * Hide element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        hide: function () {\n            this.visible(false);\n\n            return this;\n        },\n\n        /**\n         * Disable element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        disable: function () {\n            this.disabled(true);\n\n            return this;\n        },\n\n        /**\n         * Enable element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        enable: function () {\n            this.disabled(false);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {(String|Object)} rule\n         * @param {(Object|Boolean)} [options]\n         * @returns {Abstract} Chainable.\n         */\n        setValidation: function (rule, options) {\n            var rules =  utils.copy(this.validation),\n                changed;\n\n            if (_.isObject(rule)) {\n                _.extend(this.validation, rule);\n            } else {\n                this.validation[rule] = options;\n            }\n\n            changed = utils.compare(rules, this.validation).equal;\n\n            if (changed) {\n                this.required(!!rules['required-entry']);\n                this.validate();\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns unwrapped preview observable.\n         *\n         * @returns {String} Value of the preview observable.\n         */\n        getPreview: function () {\n            return this.value();\n        },\n\n        /**\n         * Checks if element has addons\n         *\n         * @returns {Boolean}\n         */\n        hasAddons: function () {\n            return this.addbefore || this.addafter;\n        },\n\n        /**\n         * Checks if element has service setting\n         *\n         * @returns {Boolean}\n         */\n        hasService: function() {\n            return this.service && this.service.template;\n        },\n\n        /**\n         * Defines if value has changed.\n         *\n         * @returns {Boolean}\n         */\n        hasChanged: function () {\n            var notEqual = this.value() !== this.initialValue;\n\n            return !this.visible() ? false : notEqual;\n        },\n\n        /**\n         * Checks if 'value' is not empty.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !utils.isEmpty(this.value());\n        },\n\n        /**\n         * Sets value observable to initialValue property.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        reset: function () {\n            this.value(this.initialValue);\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * Sets current state as initial.\n         */\n        overload: function () {\n            this.setInitialValue();\n            this.bubble('update', this.hasChanged());\n        },\n\n        /**\n         * Clears 'value' property.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        clear: function () {\n            this.value('');\n\n            return this;\n        },\n\n        /**\n         * Converts values like 'null' or 'undefined' to an empty string.\n         *\n         * @param {*} value - Value to be processed.\n         * @returns {*}\n         */\n        normalizeData: function (value) {\n            return utils.isEmpty(value) ? '' : value;\n        },\n\n        /**\n         * Validates itself by it's validation rules using validator object.\n         * If validation of a rule did not pass, writes it's message to\n         * 'error' observable property.\n         *\n         * @returns {Object} Validate information.\n         */\n        validate: function () {\n            var value   = this.value(),\n                result  = validator(this.validation, value, this.validationParams),\n                message = !this.disabled() && this.visible() ? result.message : '',\n                isValid = this.disabled() || !this.visible() || result.passed;\n\n            this.error(message);\n            this.bubble('error', message);\n\n            //TODO: Implement proper result propagation for form\n            if (!isValid) {\n                this.source.set('params.invalid', true);\n            }\n\n            return {\n                valid: isValid,\n                target: this\n            };\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         */\n        onUpdate: function () {\n            this.bubble('update', this.hasChanged());\n\n            this.validate();\n        },\n\n        /**\n         * Restore value to default\n         */\n        restoreToDefault: function () {\n            this.value(this.default);\n        },\n\n        /**\n         * Update whether value differs from default value\n         */\n        setDifferedFromDefault: function () {\n            var value = typeof this.value() != 'undefined' && this.value() !== null ? this.value() : '',\n                defaultValue = typeof this.default != 'undefined' && this.default !== null ? this.default : '';\n            this.isDifferedFromDefault(value !== defaultValue);\n        },\n\n        /**\n         * @param {Boolean} state\n         */\n        toggleUseDefault: function (state) {\n            this.disabled(state);\n        },\n\n        /**\n         *  Callback when value is changed by user\n         */\n        userChanges: function() {\n            this.valueChangedByUser = true;\n        }\n    });\n});\n","Magento_Ui/js/form/element/boolean.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            checked: false,\n            links: {\n                checked: 'value'\n            }\n        },\n\n        /**\n         * @returns {*|void|Element}\n         */\n        initObservable: function () {\n            return this._super()\n                    .observe('checked');\n        },\n\n        /**\n         * Converts provided value to boolean.\n         *\n         * @returns {Boolean}\n         */\n        normalizeData: function () {\n            return !!+this._super();\n        },\n\n        /**\n         * Calls 'onUpdate' method of parent, if value is defined and instance's\n         *     'unique' property set to true, calls 'setUnique' method\n         *\n         * @return {Object} - reference to instance\n         */\n        onUpdate: function () {\n            if (this.hasUnique) {\n                this.setUnique();\n            }\n\n            return this._super();\n        }\n    });\n});\n","Magento_Ui/js/form/element/checkbox-set.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils',\n    './abstract'\n], function (_, utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            template: 'ui/form/element/checkbox-set',\n            multiple: false,\n            multipleScopeValue: null\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function () {\n            this._super();\n\n            this.value = this.normalizeData(this.value);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initLinks: function () {\n            var scope = this.source.get(this.dataScope);\n\n            this.multipleScopeValue = this.multiple && _.isArray(scope) ? utils.copy(scope) : undefined;\n\n            return this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            this.value(utils.copy(this.initialValue));\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            var value = this.multiple ? [] : '';\n\n            this.value(value);\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        normalizeData: function (value) {\n            if (!this.multiple) {\n                return this._super();\n            }\n\n            return _.isArray(value) ? utils.copy(value) : [];\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.initialValue = utils.copy(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        getInitialValue: function () {\n            var values = [this.multipleScopeValue, this.default, this.value.peek(), []],\n                value;\n\n            if (!this.multiple) {\n                return this._super();\n            }\n\n            values.some(function (v) {\n                return _.isArray(v) && (value = utils.copy(v));\n            });\n\n            return value;\n        },\n\n        /**\n         * Returns labels which matches current value.\n         *\n         * @returns {String|Array}\n         */\n        getPreview: function () {\n            var option;\n\n            if (!this.multiple) {\n                option = this.getOption(this.value());\n\n                return option ? option.label : '';\n            }\n\n            return this.value.map(function (value) {\n                return this.getOption(value).label;\n            }, this);\n        },\n\n        /**\n         * Returns option object assoctiated with provided value.\n         *\n         * @param {String} value\n         * @returns {Object}\n         */\n        getOption: function (value) {\n            return _.findWhere(this.options, {\n                value: value\n            });\n        },\n\n        /**\n         * @inheritdoc\n         */\n        hasChanged: function () {\n            var value = this.value(),\n                initial = this.initialValue;\n\n            return this.multiple ?\n                !utils.equalArrays(value, initial) :\n                this._super();\n        }\n    });\n});\n","Magento_Ui/js/form/element/date.js":"/**\n * Copyright \u00c2\u00a9 2015 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'moment',\n    'mageUtils',\n    './abstract'\n], function (moment, utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            options: {},\n\n            timeOffset: 0,\n\n            validationParams: {\n                dateFormat: '${ $.outputDateFormat }'\n            },\n\n            /**\n             * Format of date that comes from the\n             * server (ICU Date Format).\n             *\n             * Used only in date picker mode\n             * (this.options.showsTime == false).\n             *\n             * @type {String}\n             */\n            inputDateFormat: 'y-MM-dd',\n\n            /**\n             * Format of date that should be sent to the\n             * server (ICU Date Format).\n             *\n             * Used only in date picker mode\n             * (this.options.showsTime == false).\n             *\n             * @type {String}\n             */\n            outputDateFormat: 'MM/dd/y',\n\n            /**\n             * Date/time format that is used to display date in\n             * the input field.\n             *\n             * @type {String}\n             */\n            pickerDateTimeFormat: '',\n\n            pickerDefaultDateFormat: 'MM/dd/y', // ICU Date Format\n            pickerDefaultTimeFormat: 'h:mm a', // ICU Time Format\n\n            elementTmpl: 'ui/form/element/date',\n\n            listens: {\n                'value': 'onValueChange',\n                'shiftedValue': 'onShiftedValueChange'\n            },\n\n            /**\n             * Date/time value shifted to corresponding timezone\n             * according to this.timeOffset property. This value\n             * will be sent to the server.\n             *\n             * @type {String}\n             */\n            shiftedValue: ''\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            if (!this.options.dateFormat) {\n                this.options.dateFormat = this.pickerDefaultDateFormat;\n            }\n\n            if (!this.options.timeFormat) {\n                this.options.timeFormat = this.pickerDefaultTimeFormat;\n            }\n\n            this.prepareDateTimeFormats();\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super().observe(['shiftedValue']);\n        },\n\n        /**\n         * Prepares and sets date/time value that will be displayed\n         * in the input field.\n         *\n         * @param {String} value\n         */\n        onValueChange: function (value) {\n            var dateFormat,\n                shiftedValue;\n\n            if (value) {\n                if (this.options.showsTime) {\n                    shiftedValue = moment.utc(value).add(this.timeOffset, 'seconds');\n                } else {\n                    dateFormat = this.shiftedValue() ? this.outputDateFormat : this.inputDateFormat;\n\n                    shiftedValue = moment(value, dateFormat);\n                }\n\n                shiftedValue = shiftedValue.format(this.pickerDateTimeFormat);\n            } else {\n                shiftedValue = '';\n            }\n\n            if (shiftedValue !== this.shiftedValue()) {\n                this.shiftedValue(shiftedValue);\n            }\n        },\n\n        /**\n         * Prepares and sets date/time value that will be sent\n         * to the server.\n         *\n         * @param {String} shiftedValue\n         */\n        onShiftedValueChange: function (shiftedValue) {\n            var value;\n\n            if (shiftedValue) {\n                if (this.options.showsTime) {\n                    value = moment.utc(shiftedValue, this.pickerDateTimeFormat);\n                    value = value.subtract(this.timeOffset, 'seconds').toISOString();\n                } else {\n                    value = moment(shiftedValue, this.pickerDateTimeFormat);\n                    value = value.format(this.outputDateFormat);\n                }\n            } else {\n                value = '';\n            }\n\n            if (value !== this.value()) {\n                this.value(value);\n            }\n        },\n\n        /**\n         * Prepares and converts all date/time formats to be compatible\n         * with moment.js library.\n         */\n        prepareDateTimeFormats: function () {\n            this.pickerDateTimeFormat = this.options.dateFormat;\n\n            if (this.options.showsTime) {\n                this.pickerDateTimeFormat += ' ' + this.options.timeFormat;\n            }\n\n            this.pickerDateTimeFormat = utils.normalizeDate(this.pickerDateTimeFormat);\n\n            if (this.dateFormat) {\n                this.inputDateFormat = this.dateFormat;\n            }\n\n            this.inputDateFormat = utils.normalizeDate(this.inputDateFormat);\n            this.outputDateFormat = utils.normalizeDate(this.outputDateFormat);\n\n            this.validationParams.dateFormat = this.outputDateFormat;\n        }\n    });\n});\n","Magento_Ui/js/form/element/media.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mageUtils',\n    './abstract'\n], function (utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: ''\n            }\n        },\n\n        /**\n         * Initializes file component.\n         *\n         * @returns {Media} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFormId();\n\n            return this;\n        },\n\n        /**\n         * Defines form ID with which file input will be associated.\n         *\n         * @returns {Media} Chainable.\n         */\n        initFormId: function () {\n            var namespace;\n\n            if (this.formId) {\n                return this;\n            }\n\n            namespace   = this.name.split('.');\n            this.formId = namespace[0];\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/multiselect.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils',\n    './select'\n], function (_, utils, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            size: 5,\n            elementTmpl: 'ui/form/element/multiselect'\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.initialValue = utils.copy(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        normalizeData: function (value) {\n            if (utils.isEmpty(value)) {\n                value = [];\n            }\n\n            return _.isString(value) ? value.split(',') : value;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        getInitialValue: function () {\n            var values = [\n                    this.normalizeData(this.source.get(this.dataScope)),\n                    this.normalizeData(this.default)\n                ],\n                value;\n\n            values.some(function (v) {\n                return _.isArray(v) && (value = utils.copy(v)) && !_.isEmpty(v);\n            });\n\n            return value;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        hasChanged: function () {\n            var value = this.value(),\n                initial = this.initialValue;\n\n            return !utils.equalArrays(value, initial);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            this.value(utils.copy(this.initialValue));\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            this.value([]);\n            this.error(false);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/post-code.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    './abstract'\n], function (_, registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                update: '${ $.parentName }.country_id:value'\n            }\n        },\n\n        /**\n         * @param {String} value\n         */\n        update: function (value) {\n            var country = registry.get(this.parentName + '.' + 'country_id'),\n                options = country.indexedOptions,\n                option;\n\n            if (!value) {\n                return;\n            }\n\n            option = options[value];\n\n            if (option['is_zipcode_optional']) {\n                this.error(false);\n                this.validation = _.omit(this.validation, 'required-entry');\n            } else {\n                this.validation['required-entry'] = true;\n            }\n\n            this.required(!option['is_zipcode_optional']);\n        }\n    });\n});\n","Magento_Ui/js/form/element/region.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    './select'\n], function (_, registry, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            skipValidation: false,\n            imports: {\n                update: '${ $.parentName }.country_id:value'\n            }\n        },\n\n        /**\n         * @param {String} value\n         */\n        update: function (value) {\n            var country = registry.get(this.parentName + '.' + 'country_id'),\n                options = country.indexedOptions,\n                option;\n\n            if (!value) {\n                return;\n            }\n\n            option = options[value];\n\n            if (this.skipValidation) {\n                this.validation['required-entry'] = false;\n                this.required(false);\n            } else {\n                if (!option['is_region_required']) {\n                    this.error(false);\n                    this.validation = _.omit(this.validation, 'required-entry');\n                } else {\n                    this.validation['required-entry'] = true;\n                }\n\n                this.required(!!option['is_region_required']);\n            }\n        },\n\n        /**\n         * Filters 'initialOptions' property by 'field' and 'value' passed,\n         * calls 'setOptions' passing the result to it\n         *\n         * @param {*} value\n         * @param {String} field\n         */\n        filter: function (value, field) {\n            var country = registry.get(this.parentName + '.' + 'country_id'),\n                option = country.indexedOptions[value];\n\n            this._super(value, field);\n\n            if (option && option['is_region_visible'] === false) {\n                // hide select and corresponding text input field if region must not be shown for selected country\n                this.setVisible(false);\n\n                if (this.customEntry) {\n                    this.toggleInput(false);\n                }\n            }\n        }\n    });\n});\n\n","Magento_Ui/js/form/element/select.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    './abstract',\n    'uiLayout'\n], function (_, utils, registry, Abstract, layout) {\n    'use strict';\n\n    var inputNode = {\n        parent: '${ $.$data.parentName }',\n        component: 'Magento_Ui/js/form/element/abstract',\n        template: '${ $.$data.template }',\n        provider: '${ $.$data.provider }',\n        name: '${ $.$data.index }_input',\n        dataScope: '${ $.$data.customEntry }',\n        customScope: '${ $.$data.customScope }',\n        sortOrder: {\n            after: '${ $.$data.name }'\n        },\n        displayArea: 'body',\n        label: '${ $.$data.label }'\n    };\n\n    /**\n     * Parses incoming options, considers options with undefined value property\n     *     as caption\n     *\n     * @param  {Array} nodes\n     * @return {Object}\n     */\n    function parseOptions(nodes, captionValue) {\n        var caption,\n            value;\n\n        nodes = _.map(nodes, function (node) {\n            value = node.value;\n\n            if (value === null || value === captionValue) {\n                if (_.isUndefined(caption)) {\n                    caption = node.label;\n                }\n            } else {\n                return node;\n            }\n        });\n\n        return {\n            options: _.compact(nodes),\n            caption: _.isString(caption) ? caption : false\n        };\n    }\n\n    /**\n     * Recursively loops over data to find non-undefined, non-array value\n     *\n     * @param  {Array} data\n     * @return {*} - first non-undefined value in array\n     */\n    function findFirst(data) {\n        var value;\n\n        data.some(function (node) {\n            value = node.value;\n\n            if (Array.isArray(value)) {\n                value = findFirst(value);\n            }\n\n            return !_.isUndefined(value);\n        });\n\n        return value;\n    }\n\n    /**\n     * Recursively set to object item like value and item.value like key.\n     *\n     * @param {Array} data\n     * @param {Object} result\n     * @returns {Object}\n     */\n    function indexOptions(data, result) {\n        var value;\n\n        result = result || {};\n\n        data.forEach(function (item) {\n            value = item.value;\n\n            if (Array.isArray(value)) {\n                indexOptions(value, result);\n            } else {\n                result[value] = item;\n            }\n        });\n\n        return result;\n    }\n\n    return Abstract.extend({\n        defaults: {\n            customName: '${ $.parentName }.${ $.index }_input',\n            elementTmpl: 'ui/form/element/select'\n        },\n\n        /**\n         * Extends instance with defaults, extends config with formatted values\n         *     and options, and invokes initialize method of AbstractElement class.\n         *     If instance's 'customEntry' property is set to true, calls 'initInput'\n         */\n        initialize: function () {\n            this._super();\n\n            if (this.customEntry) {\n                this.initInput();\n            }\n\n            if (this.filterBy) {\n                this.initFilter();\n            }\n\n            return this;\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @param  {Object} config\n         * @returns {Object} Chainable.\n         */\n        initConfig: function (config) {\n            var options = config.options,\n                captionValue = config.captionValue || '',\n                result = parseOptions(options, captionValue);\n\n            if (config.caption) {\n                delete result.caption;\n            }\n\n            _.extend(config, result);\n\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n\n            this.initialOptions = this.options;\n\n            this.observe('options')\n                .setOptions(this.options());\n\n            return this;\n        },\n\n        /**\n         * Set link for filter.\n         *\n         * @returns {Object} Chainable\n         */\n        initFilter: function () {\n            var filter = this.filterBy;\n\n            this.filter(this.default, filter.field);\n            this.setLinks({\n                filter: filter.target\n            }, 'imports');\n\n            return this;\n        },\n\n        /**\n         * Creates input from template, renders it via renderer.\n         *\n         * @returns {Object} Chainable.\n         */\n        initInput: function () {\n            layout([utils.template(inputNode, this)]);\n\n            return this;\n        },\n\n        /**\n         * Matches specfied value with existing options\n         * or, if value is not specified, returns value of the first option.\n         *\n         * @returns {*}\n         */\n        normalizeData: function () {\n            var value = this._super(),\n                option;\n\n            if (value !== '') {\n                option = this.getOption(value);\n\n                return option && option.value;\n            }\n\n            if (!this.caption) {\n                return findFirst(this.options);\n            }\n        },\n\n        /**\n         * Filters 'initialOptions' property by 'field' and 'value' passed,\n         * calls 'setOptions' passing the result to it\n         *\n         * @param {*} value\n         * @param {String} field\n         */\n        filter: function (value, field) {\n            var source = this.initialOptions,\n                result;\n\n            field = field || this.filterBy.field;\n\n            result = _.filter(source, function (item) {\n                return item[field] === value || item.value === '';\n            });\n\n            this.setOptions(result);\n        },\n\n        /**\n         * Change visibility for input.\n         *\n         * @param {Boolean} isVisible\n         */\n        toggleInput: function (isVisible) {\n            registry.get(this.customName, function (input) {\n                input.setVisible(isVisible);\n            });\n        },\n\n        /**\n         * Sets 'data' to 'options' observable array, if instance has\n         * 'customEntry' property set to true, calls 'setHidden' method\n         *  passing !options.length as a parameter\n         *\n         * @param {Array} data\n         * @returns {Object} Chainable\n         */\n        setOptions: function (data) {\n            var isVisible;\n\n            this.indexedOptions = indexOptions(data);\n\n            this.options(data);\n\n            if (this.customEntry) {\n                isVisible = !!data.length;\n\n                this.setVisible(isVisible);\n                this.toggleInput(!isVisible);\n            }\n\n            return this;\n        },\n\n        /**\n         * Processes preview for option by it's value, and sets the result\n         * to 'preview' observable\n         *\n         * @returns {Object} Chainable.\n         */\n        getPreview: function () {\n            var value = this.value(),\n                option = this.indexedOptions[value],\n                preview = option ? option.label : '';\n\n            this.preview(preview);\n\n            return preview;\n        },\n\n        getOption: function (value) {\n            return this.indexedOptions[value];\n        },\n\n        /**\n         * Select first available option\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            var value = this.caption ? '' : findFirst(this.options);\n\n            this.value(value);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/single-checkbox-toggle-notice.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (SingleCheckbox) {\n    'use strict';\n\n    return SingleCheckbox.extend({\n        defaults: {\n            notices: [],\n            tracks: {\n                notice: true\n            }\n        },\n\n        /**\n         * Choose notice on initialization\n         *\n         * @returns {*|void|Element}\n         */\n        initialize: function () {\n            this._super()\n                .chooseNotice();\n\n            return this;\n        },\n\n        /**\n         * Choose notice function\n         *\n         * @returns void\n         */\n        chooseNotice: function () {\n            var checkedNoticeNumber = Number(this.checked());\n\n            this.notice = this.notices[checkedNoticeNumber];\n        },\n\n        /**\n         * Choose notice on update\n         *\n         * @returns void\n         */\n        onUpdate: function () {\n            this._super();\n            this.chooseNotice();\n        }\n    });\n});\n","Magento_Ui/js/form/element/single-checkbox-use-config.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isUseDefault: false,\n            isUseConfig: false,\n            listens: {\n                'isUseConfig': 'toggleElement',\n                'isUseDefault': 'toggleElement'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n\n            return this\n                ._super()\n                .observe('isUseConfig');\n        },\n\n        /**\n         * Toggle element\n         */\n        toggleElement: function () {\n            this.disabled(this.isUseDefault() || this.isUseConfig());\n        }\n    });\n});\n","Magento_Ui/js/form/element/single-checkbox.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'underscore',\n    'mage/translate'\n], function (AbstractField, _, $t) {\n    'use strict';\n\n    return AbstractField.extend({\n        defaults: {\n            template: 'ui/form/components/single/field',\n            checked: false,\n            initialChecked: false,\n            multiple: false,\n            prefer: 'checkbox', // 'radio' | 'checkbox' | 'toggle'\n            valueMap: {},\n\n            templates: {\n                radio: 'ui/form/components/single/radio',\n                checkbox: 'ui/form/components/single/checkbox',\n                toggle: 'ui/form/components/single/switcher'\n            },\n\n            listens: {\n                'checked': 'onCheckedChanged',\n                'value': 'onExtendedValueChanged'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function (config) {\n            this._super();\n\n            if (!config.elementTmpl) {\n                if (!this.prefer && !this.multiple) {\n                    this.elementTmpl = this.templates.radio;\n                } else if (this.prefer === 'radio') {\n                    this.elementTmpl = this.templates.radio;\n                } else if (this.prefer === 'checkbox') {\n                    this.elementTmpl = this.templates.checkbox;\n                } else if (this.prefer === 'toggle') {\n                    this.elementTmpl = this.templates.toggle;\n                } else {\n                    this.elementTmpl = this.templates.checkbox;\n                }\n            }\n\n            if (this.prefer === 'toggle' && _.isEmpty(this.toggleLabels)) {\n                this.toggleLabels = {\n                    'on': $t('Yes'),\n                    'off': $t('No')\n                };\n            }\n\n            if (typeof this.default === 'undefined' || this.default === null) {\n                this.default = '';\n            }\n\n            if (typeof this.value === 'undefined' || this.value === null) {\n                this.value = _.isEmpty(this.valueMap) || this.default !== '' ? this.default : this.valueMap.false;\n                this.initialValue = this.value;\n            } else {\n                this.initialValue = this.value;\n            }\n\n            if (this.multiple && !_.isArray(this.value)) {\n                this.value = []; // needed for correct observable assignment\n            }\n\n            this.initialChecked = this.checked;\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe('checked');\n        },\n\n        /**\n         * Get true/false key from valueMap by value.\n         *\n         * @param {*} value\n         * @returns {Boolean|undefined}\n         */\n        getReverseValueMap: function getReverseValueMap(value) {\n            var bool = false;\n\n            _.some(this.valueMap, function (iValue, iBool) {\n                if (iValue === value) {\n                    bool = iBool === 'true';\n\n                    return true;\n                }\n            });\n\n            return bool;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            if (_.isEmpty(this.valueMap)) {\n                this.on('value', this.onUpdate.bind(this));\n            } else {\n                this._super();\n                this.checked(this.getReverseValueMap(this.value()));\n            }\n\n            return this;\n        },\n\n        /**\n         * Handle dataScope changes for checkbox / radio button.\n         *\n         * @param {*} newExportedValue\n         */\n        onExtendedValueChanged: function (newExportedValue) {\n            var isMappedUsed = !_.isEmpty(this.valueMap),\n                oldChecked = this.checked.peek(),\n                oldValue = this.initialValue,\n                newChecked;\n\n            if (this.multiple) {\n                newChecked = newExportedValue.indexOf(oldValue) !== -1;\n            } else if (isMappedUsed) {\n                newChecked = this.getReverseValueMap(newExportedValue);\n            } else if (typeof newExportedValue === 'boolean') {\n                newChecked = newExportedValue;\n            } else {\n                newChecked = newExportedValue === oldValue;\n            }\n\n            if (newChecked !== oldChecked) {\n                this.checked(newChecked);\n            }\n        },\n\n        /**\n         * Handle checked state changes for checkbox / radio button.\n         *\n         * @param {Boolean} newChecked\n         */\n        onCheckedChanged: function (newChecked) {\n            var isMappedUsed = !_.isEmpty(this.valueMap),\n                oldValue = this.initialValue,\n                newValue;\n\n            if (isMappedUsed) {\n                newValue = this.valueMap[newChecked];\n            } else {\n                newValue = oldValue;\n            }\n\n            if (!this.multiple && newChecked) {\n                this.value(newValue);\n            } else if (!this.multiple && !newChecked) {\n                if (typeof newValue === 'boolean') {\n                    this.value(newChecked);\n                } else if (newValue === this.value.peek()) {\n                    this.value('');\n                }\n\n                if (isMappedUsed) {\n                    this.value(newValue);\n                }\n            } else if (this.multiple && newChecked && this.value.indexOf(newValue) === -1) {\n                this.value.push(newValue);\n            } else if (this.multiple && !newChecked && this.value.indexOf(newValue) !== -1) {\n                this.value.splice(this.value.indexOf(newValue), 1);\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            if (this.hasUnique) {\n                this.setUnique();\n            }\n\n            return this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            if (this.multiple && this.initialChecked) {\n                this.value.push(this.initialValue);\n            } else if (this.multiple && !this.initialChecked) {\n                this.value.splice(this.value.indexOf(this.initialValue), 1);\n            } else {\n                this.value(this.initialValue);\n            }\n\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            if (this.multiple) {\n                this.value([]);\n            } else {\n                this.value('');\n            }\n\n            this.error(false);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/text.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'mageUtils'\n], function (Element, utils) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            error: '',\n            uid: utils.uniqueid(),\n            disabled: false,\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            }\n        },\n\n        /**\n         * Has service\n         *\n         * @returns {Boolean} false.\n         */\n        hasService: function () {\n            return false;\n        },\n\n        /**\n         * Has addons\n         *\n         * @returns {Boolean} false.\n         */\n        hasAddons: function () {\n            return false;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('disabled visible value');\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/textarea.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            cols: 15,\n            rows: 2,\n            elementTmpl: 'ui/form/element/textarea'\n        }\n    });\n});\n","Magento_Ui/js/form/element/wysiwyg.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'ko',\n    './abstract',\n    'Magento_Variable/variables'\n], function ($, _, ko, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementSelector: 'textarea',\n            value: '',\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            },\n            template: 'ui/form/field',\n            elementTmpl: 'ui/form/element/wysiwyg',\n            content:        '',\n            showSpinner:    false,\n            loading:        false\n        },\n\n        /**\n         *\n         * @returns {} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initNodeListener();\n\n            return this;\n        },\n\n        /**\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe('value');\n\n            return this;\n        },\n\n        /**\n         *\n         * @returns {} Chainable.\n         */\n        initNodeListener: function () {\n            $.async({\n                component: this,\n                selector: this.elementSelector\n            }, this.setElementNode.bind(this));\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {HTMLElement} node\n         */\n        setElementNode: function (node) {\n            $(node).bindings({\n                value: this.value\n            });\n        }\n    });\n});\n","Magento_Ui/js/lib/collapsible.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            collapsible: true\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('opened');\n\n            return this;\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        toggleOpened: function () {\n            this.opened() ?\n                this.close() :\n                this.open();\n\n            return this;\n        },\n\n        /**\n         * Sets 'opened' flag to false.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        close: function () {\n            if (this.collapsible) {\n                this.opened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets 'opened' flag to true.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        open: function () {\n            if (this.collapsible) {\n                this.opened(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/lib/key-codes.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        13: 'enterKey',\n        27: 'escapeKey',\n        40: 'pageDownKey',\n        38: 'pageUpKey',\n        32: 'spaceKey',\n        9:  'tabKey',\n        37: 'pageLeftKey',\n        39: 'pageRightKey',\n        17: 'ctrlKey',\n        18: 'altKey',\n        16: 'shiftKey'\n    };\n});\n","Magento_Ui/js/lib/spinner.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var selector = '[data-role=\"spinner\"]',\n        spinner = $(selector);\n\n    return {\n        show: function () {\n            spinner.show();\n        },\n\n        hide: function () {\n            spinner.hide();\n        },\n\n        get: function (id) {\n            return $(selector + '[data-component=\"' + id + '\"]');\n        }\n    };\n});\n","Magento_Ui/js/lib/core/class.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/utils/wrapper'\n], function (_, utils, wrapper) {\n    'use strict';\n\n    var Class;\n\n    /**\n     * Returns property of an object if\n     * it's his own property.\n     *\n     * @param {Object} obj - Object whose property should be retrieved.\n     * @param {String} prop - Name of the property.\n     * @returns {*} Value of the property or false.\n     */\n    function getOwn(obj, prop) {\n        return _.isObject(obj) && obj.hasOwnProperty(prop) && obj[prop];\n    }\n\n    /**\n     * Creates constructor function which allows\n     * initialization without usage of a 'new' operator.\n     *\n     * @param {Object} protoProps - Prototypal propeties of a new consturctor.\n     * @param {Function} consturctor\n     * @returns {Function} Created consturctor.\n     */\n    function createConstructor(protoProps, consturctor) {\n        var UiClass = consturctor;\n\n        if (!UiClass) {\n\n            /**\n             * Default constructor function.\n             */\n            UiClass = function () {\n                var obj = this;\n\n                if (!_.isObject(obj) || Object.getPrototypeOf(obj) !== UiClass.prototype) {\n                    obj = Object.create(UiClass.prototype);\n                }\n\n                obj.initialize.apply(obj, arguments);\n\n                return obj;\n            };\n        }\n\n        UiClass.prototype = protoProps;\n        UiClass.prototype.constructor = UiClass;\n\n        return UiClass;\n    }\n\n    Class = createConstructor({\n\n        /**\n         * Entry point to the initialization of consturctors' instance.\n         *\n         * @param {Object} [options={}]\n         * @returns {Class} Chainable.\n         */\n        initialize: function (options) {\n            this.initConfig(options);\n\n            return this;\n        },\n\n        /**\n         * Recursively extends data specified in constructors' 'defaults'\n         * property with provided options object. Evaluates resulting\n         * object using string templates (see: mage/utils/template.js).\n         *\n         * @param {Object} [options={}]\n         * @returns {Class} Chainable.\n         */\n        initConfig: function (options) {\n            var defaults    = this.constructor.defaults,\n                config      = utils.extend({}, defaults, options || {}),\n                ignored     = config.ignoreTmpls || {},\n                cached      = utils.omit(config, ignored);\n\n            config = utils.template(config, this, false, true);\n\n            _.each(cached, function (value, key) {\n                utils.nested(config, key, value);\n            });\n\n            return _.extend(this, config);\n        }\n    });\n\n    _.extend(Class, {\n        defaults: {\n            ignoreTmpls: {\n                templates: true\n            }\n        },\n\n        /**\n         * Creates new constructor based on a current prototype properties,\n         * extending them with properties specified in 'exender' object.\n         *\n         * @param {Object} [extender={}]\n         * @returns {Function} New constructor.\n         */\n        extend: function (extender) {\n            var parent      = this,\n                parentProto = parent.prototype,\n                childProto  = Object.create(parentProto),\n                child       = createConstructor(childProto, getOwn(extender, 'constructor')),\n                defaults;\n\n            extender = extender || {};\n            defaults = extender.defaults;\n\n            delete extender.defaults;\n\n            _.each(extender, function (method, name) {\n                childProto[name] = wrapper.wrapSuper(parentProto[name], method);\n            });\n\n            child.defaults = utils.extend({}, parent.defaults || {});\n\n            if (defaults) {\n                utils.extend(child.defaults, defaults);\n                extender.defaults = defaults;\n            }\n\n            return _.extend(child, {\n                __super__:  parentProto,\n                extend:     parent.extend\n            });\n        }\n    });\n\n    return Class;\n});\n","Magento_Ui/js/lib/core/collection.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiElement'\n], function (_, utils, registry, Element) {\n    'use strict';\n\n    /**\n     * Removes non plain object items from the specfied array.\n     *\n     * @param {Array} container - Array whose value should be filtered.\n     * @returns {Array}\n     */\n    function compact(container) {\n        return container.filter(utils.isObject);\n    }\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/collection',\n            _elems: [],\n            ignoreTmpls: {\n                childDefaults: true\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Model} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    elems: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @param {Object} elem - Instance of an element that was added.\n         * @returns {Collection} Chainable.\n         */\n        initElement: function (elem) {\n            elem.initContainer(this);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a child found by provided index.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Object}\n         */\n        getChild: function (index) {\n            return _.findWhere(this.elems(), {\n                index: index\n            });\n        },\n\n        /**\n         * Requests specified components to insert\n         * them into 'elems' array starting from provided position.\n         *\n         * @param {(String|Array)} elems - Name of the component to insert.\n         * @param {Number} [position=-1] - Position at which to insert elements.\n         * @returns {Collection} Chainable.\n         */\n        insertChild: function (elems, position) {\n            var container   = this._elems,\n                insert      = this._insert.bind(this),\n                update;\n\n            if (!Array.isArray(elems)) {\n                elems = [elems];\n            }\n\n            elems.map(function (item) {\n                return item.elem ?\n                    utils.insert(item.elem, container, item.position) :\n                    utils.insert(item, container, position);\n            }).forEach(function (item) {\n                if (item === true) {\n                    update = true;\n                } else if (_.isString(item)) {\n                    registry.get(item, insert);\n                } else if (utils.isObject(item)) {\n                    insert(item);\n                }\n            });\n\n            if (update) {\n                this._updateCollection();\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes specified child from collection.\n         *\n         * @param {(Object|String)} elem - Child or index of a child to be removed.\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         *\n         * @returns {Collection} Chainable.\n         */\n        removeChild: function (elem, skipUpdate) {\n            if (_.isString(elem)) {\n                elem = this.getChild(elem);\n            }\n\n            if (elem) {\n                utils.remove(this._elems, elem);\n\n                if (!skipUpdate) {\n                    this._updateCollection();\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Destroys collection children with its' elements.\n         */\n        destroyChildren: function () {\n            this.elems.each(function (elem) {\n                elem.destroy(true);\n            });\n\n            this._updateCollection();\n        },\n\n        /**\n         * Clear data. Call method \"clear\"\n         * in child components\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            var elems = this.elems();\n\n            _.each(elems, function (elem) {\n                if (_.isFunction(elem.clear)) {\n                    elem.clear();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Checks if specified child exists in collection.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Boolean}\n         */\n        hasChild: function (index) {\n            return !!this.getChild(index);\n        },\n\n        /**\n         * Creates 'async' wrapper for the specified child\n         * using uiRegistry 'async' method and caches it\n         * in a '_requested' components  object.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Function} Async module wrapper.\n         */\n        requestChild: function (index) {\n            var name = this.formChildName(index);\n\n            return this.requestModule(name);\n        },\n\n        /**\n         * Creates complete child name based on a provided index.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {String}\n         */\n        formChildName: function (index) {\n            return this.name + '.' + index;\n        },\n\n        /**\n         * Retrieves requested region.\n         * Creates region if it was not created yet\n         *\n         * @returns {ObservableArray}\n         */\n        getRegion: function (name) {\n            var regions = this.regions = this.regions || {};\n\n            if (!regions[name]) {\n                regions[name] = [];\n\n                this.observe.call(regions, name);\n            }\n\n            return regions[name];\n        },\n\n        /**\n         * Replaces specified regions' data with a provided one.\n         * Creates region if it was not created yet.\n         *\n         * @param {Array} items - New regions' data.\n         * @param {String} name - Name of the region.\n         * @returns {Collection} Chainable.\n         */\n        updateRegion: function (items, name) {\n            this.getRegion(name)(items);\n\n            return this;\n        },\n\n        /**\n         * Destroys collection along with its' elements.\n         */\n        destroy: function () {\n            this._super();\n\n            this.elems.each('destroy');\n        },\n\n        /**\n         * Inserts provided component into 'elems' array at a specified position.\n         * @private\n         *\n         * @param {Object} elem - Element to insert.\n         */\n        _insert: function (elem) {\n            var index = this._elems.indexOf(elem.name);\n\n            if (~index) {\n                this._elems[index] = elem;\n            }\n\n            this._updateCollection()\n                .initElement(elem);\n        },\n\n        /**\n         * Synchronizes multiple elements arrays with a core '_elems' container.\n         * Performs elemets grouping by theirs 'displayArea' property.\n         * @private\n         *\n         * @returns {Collection} Chainable.\n         */\n        _updateCollection: function () {\n            var _elems = compact(this._elems),\n                grouped;\n\n            grouped = _elems.filter(function (elem) {\n                return elem.displayArea && _.isString(elem.displayArea);\n            });\n            grouped = _.groupBy(grouped, 'displayArea');\n\n            _.each(grouped, this.updateRegion, this);\n\n            this.elems(_elems);\n\n            return this;\n        },\n\n        /**\n         * Tries to call specified method of a current component,\n         * otherwise delegates attempt to its' children.\n         *\n         * @param {String} target - Name of the method.\n         * @param {...*} parameters - Arguments that will be passed to method.\n         * @returns {*} Result of the method calls.\n         */\n        delegate: function (target) {\n            var args = _.toArray(arguments);\n\n            target = this[target];\n\n            if (_.isFunction(target)) {\n                return target.apply(this, args.slice(1));\n            }\n\n            return this._delegate(args);\n        },\n\n        /**\n         * Calls 'delegate' method of all of it's children components.\n         * @private\n         *\n         * @param {Array} args - An array of arguments to pass to the next delegation call.\n         * @returns {Array} An array of delegation resutls.\n         */\n        _delegate: function (args) {\n            var result;\n\n            result = this.elems.map(function (elem) {\n                var target;\n\n                if (!_.isFunction(elem.delegate)) {\n                    target = elem[args[0]];\n\n                    if (_.isFunction(target)) {\n                        return target.apply(elem, args.slice(1));\n                    }\n                } else {\n                    return elem.delegate.apply(elem, args);\n                }\n            });\n\n            return _.flatten(result);\n        }\n    });\n});\n","Magento_Ui/js/lib/core/events.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'es6-collections'\n], function (ko, _) {\n    'use strict';\n\n    var eventsMap = new WeakMap();\n\n    /**\n     * Returns events map or a specific event\n     * data associated with a provided object.\n     *\n     * @param {Object} obj - Key in the events weakmap.\n     * @param {String} [name] - Name of the event.\n     * @returns {Map|Array|Boolean}\n     */\n    function getEvents(obj, name) {\n        var events = eventsMap.get(obj);\n\n        if (!events) {\n            return false;\n        }\n\n        return name ? events.get(name) : events;\n    }\n\n    /**\n     * Adds new event handler.\n     *\n     * @param {Object} obj - Key in the events weakmap.\n     * @param {String} ns - Callback namespace.\n     * @param {Fucntion} callback - Event callback.\n     * @param {String} name - Name of the event.\n     */\n    function addHandler(obj, ns, callback, name) {\n        var events      = getEvents(obj),\n            observable,\n            data;\n\n        observable = !ko.isObservable(obj[name]) ?\n            ko.getObservable(obj, name) :\n            obj[name];\n\n        if (observable) {\n            observable.subscribe(callback);\n\n            return;\n        }\n\n        if (!events) {\n            events = new Map();\n\n            eventsMap.set(obj, events);\n        }\n\n        data = {\n            callback: callback,\n            ns: ns\n        };\n\n        events.has(name) ?\n            events.get(name).push(data) :\n            events.set(name, [data]);\n    }\n\n    /**\n     * Invokes provided callbacks with a specified arguments.\n     *\n     * @param {Array} handlers\n     * @param {Array} args\n     * @returns {Boolean}\n     */\n    function trigger(handlers, args) {\n        var bubble = true,\n            callback;\n\n        handlers.forEach(function (handler) {\n            callback = handler.callback;\n\n            if (callback.apply(null, args) === false) {\n                bubble = false;\n            }\n        });\n\n        return bubble;\n    }\n\n    return {\n\n        /**\n         * Calls callback when name event is triggered.\n         * @param  {String}   events\n         * @param  {Function} callback\n         * @return {Object} reference to this\n         */\n        on: function (events, callback, ns) {\n            var iterator;\n\n            if (arguments.length < 2) {\n                ns = callback;\n            }\n\n            iterator = addHandler.bind(null, this, ns);\n\n            _.isObject(events) ?\n                _.each(events, iterator) :\n                iterator(callback, events);\n\n            return this;\n        },\n\n        /**\n         * Removed callback from listening to target event\n         * @param  {String} ns\n         * @return {Object} reference to this\n         */\n        off: function (ns) {\n            var storage = getEvents(this);\n\n            if (!storage) {\n                return this;\n            }\n\n            storage.forEach(function (handlers, name) {\n                handlers = handlers.filter(function (handler) {\n                    return !ns ? false : handler.ns !== ns;\n                });\n\n                handlers.length ?\n                    storage.set(name, handlers) :\n                    storage.delete(name);\n            });\n\n            return this;\n        },\n\n        /**\n         * Triggers event and executes all attached callbacks.\n         *\n         * @param {String} name - Name of the event to be triggered.\n         * @returns {Boolean}\n         */\n        trigger: function (name) {\n            var handlers,\n                args;\n\n            handlers = getEvents(this, name),\n            args = _.toArray(arguments).slice(1);\n\n            if (!handlers || !name) {\n                return true;\n            }\n\n            return trigger(handlers, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/core/element/element.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiEvents',\n    'uiClass',\n    './links',\n    '../storage/local'\n], function (ko, _, utils, registry, Events, Class, links) {\n    'use strict';\n\n    var Element;\n\n    /**\n     * Creates observable property using knockouts'\n     * 'observableArray' or 'observable' methods,\n     * depending on a type of 'value' parameter.\n     *\n     * @param {Object} obj - Object to whom property belongs.\n     * @param {String} key - Key of the property.\n     * @param {*} value - Initial value.\n     */\n    function observable(obj, key, value) {\n        var method = Array.isArray(value) ? 'observableArray' : 'observable';\n\n        if (_.isFunction(obj[key]) && !ko.isObservable(obj[key])) {\n            return;\n        }\n\n        if (ko.isObservable(value)) {\n            value = value();\n        }\n\n        ko.isObservable(obj[key]) ?\n            obj[key](value) :\n            obj[key] = ko[method](value);\n    }\n\n    /**\n     * Creates observable propery using 'track' method.\n     *\n     * @param {Object} obj - Object to whom property belongs.\n     * @param {String} key - Key of the property.\n     * @param {*} value - Initial value.\n     */\n    function accessor(obj, key, value) {\n        if (_.isFunction(obj[key]) || ko.isObservable(obj[key])) {\n            return;\n        }\n\n        obj[key] = value;\n\n        if (!ko.es5.isTracked(obj, key)) {\n            ko.track(obj, [key]);\n        }\n    }\n\n    Element = _.extend({\n        defaults: {\n            _requesetd: {},\n            containers: [],\n            exports: {},\n            imports: {},\n            links: {},\n            listens: {},\n            name: '',\n            ns: '${ $.name.split(\".\")[0] }',\n            provider: '',\n            registerNodes: true,\n            source: null,\n            statefull: {},\n            template: '',\n            tracks: {},\n            storageConfig: {\n                provider: 'localStorage',\n                namespace: '${ $.name }',\n                path: '${ $.storageConfig.provider }:${ $.storageConfig.namespace }'\n            },\n            maps: {\n                imports: {},\n                exports: {}\n            },\n            modules: {\n                storage: '${ $.storageConfig.provider }'\n            }\n        },\n\n        /**\n         * Initializes model instance.\n         *\n         * @returns {Element} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initObservable()\n                .initModules()\n                .initStatefull()\n                .initLinks()\n                .initUnique();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Element} Chainable.\n         */\n        initObservable: function () {\n            _.each(this.tracks, function (enabled, key) {\n                if (enabled) {\n                    this.track(key);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Parses 'modules' object and creates\n         * async wrappers for specified components.\n         *\n         * @returns {Element} Chainable.\n         */\n        initModules: function () {\n            _.each(this.modules, function (name, property) {\n                if (name) {\n                    this[property] = this.requestModule(name);\n                }\n            }, this);\n\n            if (!_.isFunction(this.source)) {\n                this.source = registry.get(this.provider);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when current element was injected to another component.\n         *\n         * @param {Object} parent - Instance of a 'parent' component.\n         * @returns {Collection} Chainable.\n         */\n        initContainer: function (parent) {\n            this.containers.push(parent);\n\n            return this;\n        },\n\n        /**\n         * Initializes statefull properties\n         * based on the keys of 'statefull' object.\n         *\n         * @returns {Element} Chainable.\n         */\n        initStatefull: function () {\n            _.each(this.statefull, function (path, key) {\n                if (path) {\n                    this.setStatefull(key, path);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Initializes links between properties.\n         *\n         * @returns {Element} Chainbale.\n         */\n        initLinks: function () {\n            return this.setListeners(this.listens)\n                       .setLinks(this.links, 'imports')\n                       .setLinks(this.links, 'exports')\n                       .setLinks(this.exports, 'exports')\n                       .setLinks(this.imports, 'imports');\n        },\n\n        /**\n         * Initializes listeners of the unique property.\n         *\n         * @returns {Element} Chainable.\n         */\n        initUnique: function () {\n            var update = this.onUniqueUpdate.bind(this),\n                uniqueNs = this.uniqueNs;\n\n            this.hasUnique = this.uniqueProp && uniqueNs;\n\n            if (this.hasUnique) {\n                this.source.on(uniqueNs, update, this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Makes specified property to be stored automatically.\n         *\n         * @param {String} key - Name of the property\n         *      that will be stored.\n         * @param {String} [path=key] - Path to the property in storage.\n         * @returns {Element} Chainable.\n         */\n        setStatefull: function (key, path) {\n            var link = {};\n\n            path        = !_.isString(path) || !path ? key : path;\n            link[key]   = this.storageConfig.path + '.' + path;\n\n            this.setLinks(link, 'imports')\n                .setLinks(link, 'exports');\n\n            return this;\n        },\n\n        /**\n         * Updates property specified in uniqueNs\n         * if elements' unique property is set to 'true'.\n         *\n         * @returns {Element} Chainable.\n         */\n        setUnique: function () {\n            var property = this.uniqueProp;\n\n            if (this[property]()) {\n                this.source.set(this.uniqueNs, this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates 'async' wrapper for the specified component\n         * using uiRegistry 'async' method and caches it\n         * in a '_requested' components  object.\n         *\n         * @param {String} name - Name of requested component.\n         * @returns {Function} Async module wrapper.\n         */\n        requestModule: function (name) {\n            var requested = this._requesetd;\n\n            if (!requested[name]) {\n                requested[name] = registry.async(name);\n            }\n\n            return requested[name];\n        },\n\n        /**\n         * Returns path to elements' template.\n         *\n         * @returns {String}\n         */\n        getTemplate: function () {\n            return this.template;\n        },\n\n        /**\n         * Checks if template was specified for an element.\n         *\n         * @returns {Boolean}\n         */\n        hasTemplate: function () {\n            return !!this.template;\n        },\n\n        /**\n         * Returns value of the nested property.\n         *\n         * @param {String} path - Path to the property.\n         * @returns {*} Value of the property.\n         */\n        get: function (path) {\n            return utils.nested(this, path);\n        },\n\n        /**\n         * Sets provided value as a value of the specified nested property.\n         * Triggers changes notifications, if value has mutated.\n         *\n         * @param {String} path - Path to property.\n         * @param {*} value - New value of the property.\n         * @returns {Element} Chainable.\n         */\n        set: function (path, value) {\n            var data = this.get(path),\n                diffs;\n\n            diffs = !_.isFunction(data) && !this.isTracked(path) ?\n                utils.compare(data, value, path) :\n                false;\n\n            utils.nested(this, path, value);\n\n            if (diffs) {\n                this._notifyChanges(diffs);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes nested property from the object.\n         *\n         * @param {String} path - Path to the property.\n         * @returns {Element} Chainable.\n         */\n        remove: function (path) {\n            var data = utils.nested(this, path),\n                diffs;\n\n            if (_.isUndefined(data) || _.isFunction(data)) {\n                return this;\n            }\n\n            diffs = utils.compare(data, undefined, path);\n\n            utils.nestedRemove(this, path);\n\n            this._notifyChanges(diffs);\n\n            return this;\n        },\n\n        /**\n         * Creates observable properties for the current object.\n         *\n         * If 'useTrack' flag is set to 'true' then each property will be\n         * created with a ES5 get/set accessor descriptors, instead of\n         * making them an observable functions.\n         * See 'knockout-es5' library for more information.\n         *\n         * @param {Boolean} [useAccessors=false] - Whether to create an\n         *      observable function or to use property accesessors.\n         * @param {(Object|String|Array)} properties - List of observable properties.\n         * @returns {Element} Chainable.\n         *\n         * @example Sample declaration and equivalent knockout methods.\n         *      this.key = 'value';\n         *      this.array = ['value'];\n         *\n         *      this.observe(['key', 'array']);\n         *      =>\n         *          this.key = ko.observable('value');\n         *          this.array = ko.observableArray(['value']);\n         *\n         * @example Another syntaxes of the previous example.\n         *      this.observe({\n         *          key: 'value',\n         *          array: ['value']\n         *      });\n         */\n        observe: function (useAccessors, properties) {\n            var model = this,\n                trackMethod;\n\n            if (typeof useAccessors !== 'boolean') {\n                properties   = useAccessors;\n                useAccessors = false;\n            }\n\n            trackMethod = useAccessors ? accessor : observable;\n\n            if (_.isString(properties)) {\n                properties = properties.split(' ');\n            }\n\n            if (Array.isArray(properties)) {\n                properties.forEach(function (key) {\n                    trackMethod(model, key, model[key]);\n                });\n            } else if (typeof properties === 'object') {\n                _.each(properties, function (value, key) {\n                    trackMethod(model, key, value);\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Delegates call to 'observe' method but\n         * with a predefined 'useAccessors' flag.\n         *\n         * @param {(String|Array|Object)} properties - List of observable properties.\n         * @returns {Element} Chainable.\n         */\n        track: function (properties) {\n            this.observe(true, properties);\n\n            return this;\n        },\n\n        /**\n         * Checks if specified property is tracked.\n         *\n         * @param {String} property - Property to be checked.\n         * @returns {Boolean}\n         */\n        isTracked: function (property) {\n            return ko.es5.isTracked(this, property);\n        },\n\n        /**\n         * Invokes subscribers for the provided changes.\n         *\n         * @param {Object} diffs - Object with changes descriptions.\n         * @returns {Element} Chainable.\n         */\n        _notifyChanges: function (diffs) {\n            diffs.changes.forEach(function (change) {\n                this.trigger(change.path, change.value, change);\n            }, this);\n\n            _.each(diffs.containers, function (changes, name) {\n                var value = utils.nested(this, name);\n\n                this.trigger(name, value, changes);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Extracts all stored data and sets it to element.\n         *\n         * @returns {Element} Chainable.\n         */\n        restore: function () {\n            var ns = this.storageConfig.namespace,\n                storage = this.storage();\n\n            if (storage) {\n                utils.extend(this, storage.get(ns));\n            }\n\n            return this;\n        },\n\n        /**\n         * Stores value of the specified property in components' storage module.\n         *\n         * @param {String} property\n         * @param {*} [data=this[property]]\n         * @returns {Element} Chainable.\n         */\n        store: function (property, data) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property);\n\n            if (arguments.length < 2) {\n                data = this.get(property);\n            }\n\n            this.storage('set', path, data);\n\n            return this;\n        },\n\n        /**\n         * Extracts specified property from storage.\n         *\n         * @param {String} [property] - Name of the property\n         *      to be extracted. If not specified then all of the\n         *      stored will be returned.\n         * @returns {*}\n         */\n        getStored: function (property) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property),\n                storage = this.storage(),\n                data;\n\n            if (storage) {\n                data = storage.get(path);\n            }\n\n            return data;\n        },\n\n        /**\n         * Removes stored property.\n         *\n         * @param {String} property - Property to be removed from storage.\n         * @returns {Element} Chainable.\n         */\n        removeStored: function (property) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property);\n\n            this.storage('remove', path);\n\n            return this;\n        },\n\n        /**\n         * Destroys current instance along with all of its' children.\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         */\n        destroy: function (skipUpdate) {\n            this._dropHandlers()\n                ._clearRefs(skipUpdate);\n        },\n\n        /**\n         * Removes events listeners.\n         * @private\n         *\n         * @returns {Element} Chainable.\n         */\n        _dropHandlers: function () {\n            this.off();\n\n            if (_.isFunction(this.source)) {\n                this.source().off(this.name);\n            } else if (this.source) {\n                this.source.off(this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes all references to current instance and\n         * calls 'destroy' method on all of its' children.\n         * @private\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         *\n         * @returns {Element} Chainable.\n         */\n        _clearRefs: function (skipUpdate) {\n            registry.remove(this.name);\n\n            this.containers.forEach(function (parent) {\n                parent.removeChild(this, skipUpdate);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Overrides 'EventsBus.trigger' method to implement events bubbling.\n         *\n         * @param {...*} arguments - Any number of arguments that should be passed to the events' handler.\n         * @returns {Boolean} False if event bubbling was canceled.\n         */\n        bubble: function () {\n            var args = _.toArray(arguments),\n                bubble = this.trigger.apply(this, args),\n                result;\n\n            if (!bubble) {\n                return false;\n            }\n\n            this.containers.forEach(function (parent) {\n                result = parent.bubble.apply(parent, args);\n\n                if (result === false) {\n                    bubble = false;\n                }\n            });\n\n            return !!bubble;\n        },\n\n        /**\n         * Callback which fires when property under uniqueNs has changed.\n         */\n        onUniqueUpdate: function (name) {\n            var active = name === this.name,\n                property = this.uniqueProp;\n\n            this[property](active);\n        },\n\n        /**\n         * Clean data form data source.\n         *\n         * @returns {Element}\n         */\n        cleanData: function () {\n            if (this.source && this.source.componentType === 'dataSource') {\n                if (this.elems) {\n                    _.each(this.elems(), function (val) {\n                        val.cleanData();\n                    });\n                } else {\n                    this.source.remove(this.dataScope);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Fallback data.\n         */\n        cacheData: function () {\n            this.cachedComponent = utils.copy(this);\n        },\n\n        /**\n         * Update configuration in component.\n         *\n         * @param {*} oldValue\n         * @param {*} newValue\n         * @param {String} path - path to value.\n         * @returns {Element}\n         */\n        updateConfig: function (oldValue, newValue, path) {\n            var names = path.split('.'),\n                index = _.lastIndexOf(names, 'config') + 1;\n\n            names = names.splice(index, names.length - index).join('.');\n            this.set(names, newValue);\n\n            return this;\n        }\n    }, Events, links);\n\n    return Class.extend(Element);\n});\n","Magento_Ui/js/lib/core/element/links.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry'\n], function (ko, _, utils, registry) {\n    'use strict';\n\n    function parseData(placeholder, data, direction) {\n        if (typeof data !== 'string') {\n            return false;\n        }\n\n        data = data.split(':');\n\n        if (!data[0]) {\n            return false;\n        }\n\n        if (!data[1]) {\n            data[1] = data[0];\n            data[0] = placeholder;\n        }\n\n        return {\n            target: data[0],\n            property: data[1],\n            direction: direction\n        };\n    }\n\n    function notEmpty(value) {\n        return typeof value !== 'undefined' && value != null;\n    }\n\n    function updateValue(data, owner, target, value) {\n        var component = target.component,\n            property = target.property,\n            linked = data.linked;\n\n        if (data.mute) {\n            return;\n        }\n\n        if (linked) {\n            linked.mute = true;\n        }\n\n        if (owner.component !== target.component) {\n            value = data.inversionValue ? !utils.copy(value) : utils.copy(value);\n        }\n\n        component.set(property, value, owner);\n\n        if (linked) {\n            linked.mute = false;\n        }\n    }\n\n    function getValue(owner) {\n        var component = owner.component,\n            property = owner.property;\n\n        return component.get(property);\n    }\n\n    function form(ownerComponent, targetComponent, ownerProp, targetProp, direction) {\n        var result,\n            tmp;\n\n        result = {\n            owner: {\n                component: ownerComponent,\n                property: ownerProp\n            },\n            target: {\n                component: targetComponent,\n                property: targetProp\n            }\n        };\n\n        if (direction === 'exports') {\n            tmp = result.owner;\n            result.owner = result.target;\n            result.target = tmp;\n        }\n\n        return result;\n    }\n\n    function setLinked(map, data) {\n        var match;\n\n        if (!map) {\n            return;\n        }\n\n        match = _.findWhere(map, {\n            linked: false,\n            target: data.target,\n            property: data.property\n        });\n\n        if (match) {\n            match.linked = data;\n            data.linked = match;\n        }\n    }\n\n    function setData(maps, property, data) {\n        var direction   = data.direction,\n            map         = maps[direction];\n\n        data.linked = false;\n\n        (map[property] = map[property] || []).push(data);\n\n        direction = direction === 'imports' ? 'exports' : 'imports';\n\n        setLinked(maps[direction][property], data);\n    }\n\n    function setLink(target, owner, data, property, immediate) {\n        var direction = data.direction,\n            formated = form(target, owner, data.property, property, direction),\n            callback,\n            value;\n\n        owner = formated.owner;\n        target = formated.target;\n\n        callback = updateValue.bind(null, data, owner, target);\n\n        owner.component.on(owner.property, callback, target.component.name);\n\n        if (immediate) {\n            value = getValue(owner);\n\n            if (notEmpty(value)) {\n                updateValue(data, owner, target, value);\n            }\n        }\n    }\n\n    function transfer(owner, data) {\n        var args = _.toArray(arguments);\n\n        if (data.target.substr(0,1) === '!') {\n            data.target = data.target.substr(1);\n            data.inversionValue = true;\n        }\n\n        if (owner.name === data.target) {\n            args.unshift(owner);\n\n            setLink.apply(null, args);\n        } else {\n            registry.get(data.target, function (target) {\n                args.unshift(target);\n\n                setLink.apply(null, args);\n            });\n        }\n    }\n\n    return {\n        setListeners: function (listeners) {\n            var owner = this,\n                data;\n\n            _.each(listeners, function (callbacks, sources) {\n                sources = sources.split(' ');\n                callbacks = callbacks.split(' ');\n\n                sources.forEach(function (target) {\n                    callbacks.forEach(function (callback) {\n                        data = parseData(owner.name, target, 'imports');\n\n                        if (data) {\n                            setData(owner.maps, callback, data);\n                            transfer(owner, data, callback);\n                        }\n                    });\n                });\n            });\n\n            return this;\n        },\n\n        setLinks: function (links, direction) {\n            var owner = this,\n                property,\n                data;\n\n            for (property in links) {\n                if (links.hasOwnProperty(property)) {\n                    data = parseData(owner.name, links[property], direction);\n\n                    if (data) {\n                        setData(owner.maps, property, data);\n                        transfer(owner, data, property, true);\n                    }\n                }\n            }\n\n            return this;\n        }\n    };\n});\n","Magento_Ui/js/lib/core/storage/local.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiEvents'\n], function (_, registry, utils, EventsBus) {\n    'use strict';\n\n    var root = 'appData',\n        localStorage = window.localStorage,\n        hasSupport,\n        storage;\n\n    /**\n     * Flag which indicates whether localStorage is supported.\n     */\n    hasSupport = (function () {\n        var key = '_storageSupported';\n\n        try {\n            localStorage.setItem(key, 'true');\n\n            if (localStorage.getItem(key) === 'true') {\n                localStorage.removeItem(key);\n\n                return true;\n            }\n\n            return false;\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    if (!hasSupport) {\n        localStorage = {\n            _data: {},\n\n            /**\n             * Sets value of the specified item.\n             *\n             * @param {String} key - Key of the property.\n             * @param {*} value - Properties' value.\n             */\n            setItem: function (key, value) {\n                this._data[key] = value + '';\n            },\n\n            /**\n             * Retrieves specfied item.\n             *\n             * @param {String} key - Key of the property to be retrieved.\n             */\n            getItem: function (key) {\n                return this._data[key];\n            },\n\n            /**\n             * Removes specfied item.\n             *\n             * @param {String} key - Key of the property to be removed.\n             */\n            removeItem: function (key) {\n                delete this._data[key];\n            },\n\n            /**\n             * Removes all items.\n             */\n            clear: function () {\n                this._data = {};\n            }\n        };\n    }\n\n    /**\n     * Extracts and parses data stored in localStorage by the\n     * key specified in 'root' varaible.\n     *\n     * @returns {Object}\n     */\n    function getRoot() {\n        var data = localStorage.getItem(root);\n\n        return !_.isNull(data) ? JSON.parse(data) : {};\n    }\n\n    /**\n     * Writes provided data to the localStorage.\n     *\n     * @param {*} data - Data to be stored.\n     */\n    function setRoot(data) {\n        localStorage.setItem(root, JSON.stringify(data));\n    }\n\n    /**\n     * Provides methods to work with a localStorage\n     * as a single nested structure.\n     */\n    storage = _.extend({\n\n        /**\n         * Retrieves value of the specified property.\n         *\n         * @param {String} path - Path to the property.\n         *\n         * @example Retrieveing data.\n         *      localStoarge =>\n         *          'appData' => '\n         *              \"one\": {\"two\": \"three\"}\n         *          '\n         *      storage.get('one.two')\n         *      => \"three\"\n         *\n         *      storage.get('one')\n         *      => {\"two\": \"three\"}\n         */\n        get: function (path) {\n            var data = getRoot();\n\n            return utils.nested(data, path);\n        },\n\n        /**\n         * Sets specified data to the localStorage.\n         *\n         * @param {String} path - Path of the property.\n         * @param {*} value - Value of the property.\n         *\n         * @example Setting data.\n         *      storage.set('one.two', 'four');\n         *      => localStoarge =>\n         *          'appData' => '\n         *              \"one\": {\"two\": \"four\"}\n         *          '\n         */\n        set: function (path, value) {\n            var data = getRoot();\n\n            utils.nested(data, path, value);\n\n            setRoot(data);\n        },\n\n        /**\n         * Removes specified data from the localStorage.\n         *\n         * @param {String} path - Path to the property that should be removed.\n         *\n         * @example Removing data.\n         *      storage.remove('one.two', 'four');\n         *      => localStoarge =>\n         *          'appData' => '\n         *              \"one\": {}\n         *          '\n         */\n        remove: function (path) {\n            var data = getRoot();\n\n            utils.nestedRemove(data, path);\n\n            setRoot(data);\n        }\n    }, EventsBus);\n\n    registry.set('localStorage', storage);\n\n    return storage;\n});\n","Magento_Ui/js/lib/knockout/bootstrap.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Loads all available knockout bindings, sets custom template engine, initializes knockout on page */\n\ndefine([\n    'ko',\n    './template/engine',\n    'knockoutjs/knockout-es5',\n    './bindings/bootstrap',\n    './extender/observable_array',\n    './extender/bound-nodes',\n    'domReady!'\n], function (ko, templateEngine) {\n    'use strict';\n\n    ko.uid = 0;\n\n    ko.setTemplateEngine(templateEngine);\n    ko.applyBindings();\n});\n","Magento_Ui/js/lib/knockout/bindings/after-render.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.afterRender = {\n\n        /**\n         * Binding init callback.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var callback = valueAccessor();\n\n            if (typeof callback === 'function') {\n                callback.call(viewModel, element, viewModel);\n            }\n        }\n    };\n\n    renderer.addAttribute('afterRender');\n});\n","Magento_Ui/js/lib/knockout/bindings/autoselect.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer'\n], function (ko, $, renderer) {\n    'use strict';\n\n    /**\n     * 'Focus' event handler.\n     *\n     * @param {EventObject} e\n     */\n    function onFocus(e) {\n        e.target.select();\n    }\n\n    ko.bindingHandlers.autoselect = {\n\n        /**\n         * Adds event handler which automatically\n         * selects inputs' element text when field gets focused.\n         */\n        init: function (element, valueAccessor) {\n            var enabled = ko.unwrap(valueAccessor());\n\n            if (enabled !== false) {\n                $(element).on('focus', onFocus);\n            }\n        }\n    };\n\n    renderer.addAttribute('autoselect');\n});\n","Magento_Ui/js/lib/knockout/bindings/bind-html.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/apply/main',\n    '../template/renderer'\n], function (ko, _, mage, renderer) {\n    'use strict';\n\n    /**\n     * Set html to node element.\n     *\n     * @param {HTMLElement} el - Element to apply bindings to.\n     * @param {Function} html - Observable html content.\n     */\n    function setHtml(el, html) {\n        ko.utils.emptyDomNode(el);\n        html = ko.utils.unwrapObservable(html);\n\n        if (!_.isNull(html) && !_.isUndefined(html)) {\n            if (!_.isString(html)) {\n                html = html.toString();\n            }\n\n            el.innerHTML = html;\n        }\n    }\n\n    /**\n     * Apply bindings and call magento attributes parser.\n     *\n     * @param {HTMLElement} el - Element to apply bindings to.\n     * @param {ko.bindingContext} ctx - Instance of ko.bindingContext, passed to binding initially.\n     */\n    function applyComponents(el, ctx) {\n        ko.utils.arrayForEach(el.childNodes, ko.cleanNode);\n        ko.applyBindingsToDescendants(ctx, el);\n        mage.apply();\n    }\n\n    ko.bindingHandlers.bindHtml = {\n        /**\n         * Scope binding's init method.\n         *\n         * @returns {Object} - Knockout declaration for it to let binding control descendants.\n         */\n        init: function () {\n            return {\n                controlsDescendantBindings: true\n            };\n        },\n\n        /**\n         * Reads params passed to binding.\n         * Set html to node element, apply bindings and call magento attributes parser.\n         *\n         * @param {HTMLElement} el - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to el.\n         * @param {ko.bindingContext} bindingContext - Instance of ko.bindingContext, passed to binding initially.\n         */\n        update: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            setHtml(el, valueAccessor());\n            applyComponents(el, bindingContext);\n        }\n    };\n\n    renderer.addAttribute('bindHtml');\n});\n","Magento_Ui/js/lib/knockout/bindings/bootstrap.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function (require) {\n    'use strict';\n\n    var renderer = require('../template/renderer');\n\n    renderer.addAttribute('repeat', renderer.handlers.wrapAttribute);\n\n    renderer.addAttribute('outerfasteach', {\n        binding: 'fastForEach',\n        handler: renderer.handlers.wrapAttribute\n    });\n\n    renderer\n        .addNode('repeat')\n        .addNode('fastForEach');\n\n    return {\n        resizable:      require('./resizable'),\n        i18n:           require('./i18n'),\n        scope:          require('./scope'),\n        range:          require('./range'),\n        mageInit:       require('./mage-init'),\n        keyboard:       require('./keyboard'),\n        optgroup:       require('./optgroup'),\n        aferRender:     require('./after-render'),\n        autoselect:     require('./autoselect'),\n        datepicker:     require('./datepicker'),\n        outerClick:     require('./outer_click'),\n        fadeVisible:    require('./fadeVisible'),\n        collapsible:    require('./collapsible'),\n        staticChecked:  require('./staticChecked'),\n        simpleChecked:  require('./simple-checked'),\n        bindHtml:       require('./bind-html'),\n        tooltip:        require('./tooltip'),\n        repeat:         require('knockoutjs/knockout-repeat'),\n        fastForEach:    require('knockoutjs/knockout-fast-foreach')\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/collapsible.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var collapsible,\n        defaults;\n\n    defaults = {\n        closeOnOuter: true,\n        onTarget: false,\n        openClass: '_active',\n        as: '$collapsible'\n    };\n\n    collapsible = {\n\n        /**\n         * Sets 'opened' property to true.\n         */\n        open: function () {\n            this.opened(true);\n        },\n\n        /**\n         * Sets 'opened' property to false.\n         */\n        close: function () {\n            this.opened(false);\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         */\n        toggle: function () {\n            this.opened(!this.opened());\n        }\n    };\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element, closes collapsible model.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} model\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, model, e) {\n        var target = e.target;\n\n        if (target !== container && !container.contains(target)) {\n            model.close();\n        }\n    }\n\n    /**\n     * Creates 'css' binding which toggles\n     * class specified in 'name' parameter.\n     *\n     * @param {Object} model\n     * @param {String} name\n     * @returns {Object}\n     */\n    function getClassBinding(model, name) {\n        var binding = {};\n\n        binding[name] = model.opened;\n\n        return {\n            css: binding\n        };\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {Object} [options={}]\n     * @returns {Object} Complete instance configuration.\n     */\n    function buildConfig(options) {\n        if (typeof options !== 'object') {\n            options = {};\n        }\n\n        return _.extend({}, defaults, options);\n    }\n\n    ko.bindingHandlers.collapsible = {\n\n        /**\n         * Initializes 'collapsible' binding.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var $collapsible = Object.create(collapsible),\n                config = buildConfig(valueAccessor()),\n                outerClick,\n                bindings;\n\n            _.bindAll($collapsible, 'open', 'close', 'toggle');\n\n            $collapsible.opened = ko.observable(!!config.opened);\n\n            bindingCtx[config.as] = $collapsible;\n\n            if (config.closeOnOuter) {\n                outerClick = onOuterClick.bind(null, element, $collapsible);\n\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n\n            if (config.openClass) {\n                bindings = getClassBinding($collapsible, config.openClass);\n\n                ko.applyBindingsToNode(element, bindings, bindingCtx);\n            }\n\n            if (config.onTarget) {\n                $(element).on('click', $collapsible.toggle);\n            }\n\n            if (viewModel && _.isFunction(viewModel.on)) {\n                viewModel.on({\n                    close:          $collapsible.close,\n                    open:           $collapsible.open,\n                    toggleOpened:   $collapsible.toggle\n                });\n            }\n        }\n    };\n\n    ko.bindingHandlers.closeCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which closes associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.close);\n            }\n        }\n    };\n\n    ko.bindingHandlers.openCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which opens associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.open);\n            }\n        }\n    };\n\n    ko.bindingHandlers.toggleCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which toggles associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.toggle);\n            }\n        }\n    };\n\n    renderer\n        .addAttribute('collapsible')\n        .addAttribute('openCollapsible')\n        .addAttribute('closeCollapsible')\n        .addAttribute('toggleCollapsible');\n});\n","Magento_Ui/js/lib/knockout/bindings/datepicker.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates datepicker binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'mage/calendar'\n], function (ko, _, $, $t) {\n    'use strict';\n\n    var defaults = {\n        dateFormat: 'mm\\/dd\\/yyyy',\n        showsTime: false,\n        timeFormat: null,\n        buttonImage: null,\n        buttonImageOnly: null,\n        buttonText: $t('Select Date')\n    };\n\n    ko.bindingHandlers.datepicker = {\n        /**\n         * Initializes calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * For more info about options take a look at \"mage/calendar\" and jquery.ui.datepicker widget.\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         */\n        init: function (el, valueAccessor) {\n            var config = valueAccessor(),\n                observable,\n                options = {};\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            $(el).calendar(options);\n            observable() && $(el).datepicker('setDate', observable());\n            $(el).blur();\n\n            ko.utils.registerEventHandler(el, 'change', function () {\n                observable(this.value);\n            });\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/fadeVisible.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'ko',\n], function($, ko) {\n    ko.bindingHandlers.fadeVisible = {\n        init: function (element, valueAccessor) {\n            // Initially set the element to be instantly visible/hidden depending on the value\n            var value = valueAccessor();\n            $(element).toggle(ko.unwrap(value)); // Use \"unwrapObservable\" so we can handle values that may or may not be observable\n        },\n        update: function (element, valueAccessor) {\n            // Whenever the value subsequently changes, slowly fade the element in or out\n            var value = valueAccessor();\n            ko.unwrap(value) ? $(element).fadeIn() : $(element).fadeOut();\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/i18n.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'module',\n    '../template/renderer',\n    'mage/translate'\n], function ($, ko, module, renderer) {\n    'use strict';\n\n    var locations = {\n            'legend': 'Caption for the fieldset element',\n            'label': 'Label for an input element.',\n            'button': 'Push button',\n            'a': 'Link label',\n            'b': 'Bold text',\n            'strong': 'Strong emphasized text',\n            'i': 'Italic text',\n            'em': 'Emphasized text',\n            'u': 'Underlined text',\n            'sup': 'Superscript text',\n            'sub': 'Subscript text',\n            'span': 'Span element',\n            'small': 'Smaller text',\n            'big': 'Bigger text',\n            'address': 'Contact information',\n            'blockquote': 'Long quotation',\n            'q': 'Short quotation',\n            'cite': 'Citation',\n            'caption': 'Table caption',\n            'abbr': 'Abbreviated phrase',\n            'acronym': 'An acronym',\n            'var': 'Variable part of a text',\n            'dfn': 'Term',\n            'strike': 'Strikethrough text',\n            'del': 'Deleted text',\n            'ins': 'Inserted text',\n            'h1': 'Heading level 1',\n            'h2': 'Heading level 2',\n            'h3': 'Heading level 3',\n            'h4': 'Heading level 4',\n            'h5': 'Heading level 5',\n            'h6': 'Heading level 6',\n            'center': 'Centered text',\n            'select': 'List options',\n            'img': 'Image',\n            'input': 'Form element'\n        },\n\n        /**\n         * Generates [data-translate] attribute's value\n         * @param {Object} translationData\n         * @param {String} location\n         */\n        composeTranslateAttr = function (translationData, location) {\n            var obj = [{\n                'shown': translationData.shown,\n                'translated': translationData.translated,\n                'original': translationData.original,\n                'location': locations[location] || 'Text'\n            }];\n\n            return JSON.stringify(obj);\n        },\n\n        /**\n         * Sets text for the element\n         * @param {Object} el\n         * @param {String} text\n         */\n        setText = function (el, text) {\n            $(el).text(text);\n        },\n\n        /**\n         * Sets [data-translate] attribute for the element\n         * @param {Object} el - The element which is binded\n         * @param {String} original - The original value of the element\n         */\n        setTranslateProp = function (el, original) {\n            var location = $(el).prop('tagName').toLowerCase(),\n                translated = $.mage.__(original),\n                translationData = {\n                    shown: translated,\n                    translated: translated,\n                    original: original\n                },\n                translateAttr = composeTranslateAttr(translationData, location);\n\n            $(el).attr('data-translate', translateAttr);\n\n            setText(el, translationData.shown);\n        },\n\n        /**\n         * Checks if node represents ko virtual node (nodeType === 8, nodeName === '#comment').\n         *\n         * @param {HTMLElement} node\n         * @returns {Boolean}\n         */\n        isVirtualElement = function (node) {\n            return node.nodeType === 8;\n        },\n\n        /**\n        * Checks if it's real DOM element\n        * in case of virtual element, returns span wrapper\n        * @param {Object} el\n        * @param {bool} isUpdate\n        * @return {Object} el\n        */\n        getRealElement = function (el, isUpdate) {\n            if (isVirtualElement(el)) {\n                if (isUpdate) {\n                    return $(el).next('span');\n                }\n\n                return $('<span/>').insertAfter(el);\n            }\n\n            return el;\n        },\n\n        /**\n         * execute i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         * @param {bool} isUpdate\n         */\n        execute = function (element, valueAccessor, isUpdate) {\n            var original = ko.unwrap(valueAccessor() || ''),\n                el = getRealElement(element, isUpdate),\n                inlineTranslation = (module.config() || {}).inlineTranslation;\n\n            if (inlineTranslation) {\n                setTranslateProp(el, original);\n            } else {\n                setText(el, $.mage.__(original));\n            }\n        };\n\n    /**\n     * i18n binding\n     * @property {Function}  init\n     * @property {Function}  update\n     */\n    ko.bindingHandlers.i18n = {\n\n        /**\n         * init i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            execute(element, valueAccessor);\n        },\n\n        /**\n         * update i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            execute(element, valueAccessor, true);\n        }\n    };\n\n    ko.virtualElements.allowedBindings.i18n = true;\n\n    renderer\n        .addNode('translate', {\n            binding: 'i18n'\n        })\n        .addAttribute('translate', {\n            binding: 'i18n'\n        });\n});\n","Magento_Ui/js/lib/knockout/bindings/keyboard.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.keyboard = {\n\n        /**\n         * Attaches keypress handlers to element\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         * @param  {Object} allBindings - all bindings object\n         * @param  {Object} viewModel - reference to viewmodel\n         */\n        init: function (el, valueAccessor, allBindings, viewModel) {\n            var map = valueAccessor();\n\n            ko.utils.registerEventHandler(el, 'keyup', function (e) {\n                var callback = map[e.keyCode];\n\n                if (callback) {\n                    return callback.call(viewModel, e);\n                }\n            });\n        }\n    };\n\n    renderer.addAttribute('keyboard');\n});\n","Magento_Ui/js/lib/knockout/bindings/mage-init.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'mage/apply/main'\n], function (ko, _, mage) {\n    'use strict';\n\n    ko.bindingHandlers.mageInit = {\n        init: function (el, valueAccessor) {\n            var data = valueAccessor();\n\n            _.each(data, function (config, component) {\n                mage.applyFor(el, config, component);\n            });\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/optgroup.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'mageUtils'\n    ], function (ko, utils) {\n    'use strict';\n\n    var captionPlaceholder = {},\n        optgroupTmpl = '<optgroup label=\"${ $.label }\"></optgroup>',\n        nbspRe = /&nbsp;/g,\n        optionsText,\n        optionsValue,\n        optionTitle;\n\n    ko.bindingHandlers.optgroup = {\n        /**\n         * @param {*} element\n         * @returns {Object}\n         */\n        'init': function (element) {\n            if (ko.utils.tagNameLower(element) !== 'select') {\n                throw new Error('options binding applies only to SELECT elements');\n            }\n\n            // Remove all existing <option>s.\n            while (element.length > 0) {\n                element.remove(0);\n            }\n\n            // Ensures that the binding processor doesn't try to bind the options\n            return {\n                'controlsDescendantBindings': true\n            };\n        },\n\n        /**\n         * @param {*} element\n         * @param {*} valueAccessor\n         * @param {*} allBindings\n         */\n        'update': function (element, valueAccessor, allBindings) {\n            var selectWasPreviouslyEmpty = element.length == 0,\n                previousScrollTop = (!selectWasPreviouslyEmpty && element.multiple) ? element.scrollTop : null,\n                includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                arrayToDomNodeChildrenOptions = {},\n                captionValue,\n                unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                filteredArray,\n                previousSelectedValues,\n                itemUpdate = false,\n                callback = setSelectionCallback,\n                nestedOptionsLevel = -1,\n                i, l;\n\n            optionsText = ko.utils.unwrapObservable(allBindings.get('optionsText')) || 'text';\n            optionsValue = ko.utils.unwrapObservable(allBindings.get('optionsValue')) || 'value';\n            optionTitle = optionsText + 'title';\n\n            if (element.multiple) {\n                previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n            } else {\n                previousSelectedValues = element.selectedIndex >= 0 ? [ko.selectExtensions.readValue(element.options[element.selectedIndex])] : [];\n            }\n\n            if (unwrappedArray) {\n                if (typeof unwrappedArray.length === 'undefined') { // Coerce single value into array\n                    unwrappedArray = [unwrappedArray];\n                }\n\n                // Filter out any entries marked as destroyed\n                filteredArray = ko.utils.arrayFilter(unwrappedArray, function (item) {\n                    if (item && !item.label) {\n                        return false;\n                    }\n\n                    return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item._destroy);\n                });\n                filteredArray.map(recursivePathBuilder, null);\n            }\n\n            /**\n             *\n             * @param {*} option\n             */\n            arrayToDomNodeChildrenOptions.beforeRemove = function (option) {\n                element.removeChild(option);\n            };\n\n            if (allBindings.has('optionsAfterRender')) {\n\n                /**\n                 * @param {*} arrayEntry\n                 * @param {*} newOptions\n                 */\n                callback = function (arrayEntry, newOptions) {\n                    setSelectionCallback(arrayEntry, newOptions);\n                    ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n                }\n            }\n\n            filteredArray = formatOptions(filteredArray);\n            ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionNodeFromArray, arrayToDomNodeChildrenOptions, callback);\n\n            ko.dependencyDetection.ignore(function () {\n                var selectionChanged;\n\n                if (allBindings.get('valueAllowUnset') && allBindings.has('value')) {\n                    // The model value is authoritative, so make sure its value is the one selected\n                    ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n                } else {\n                    // Determine if the selection has changed as a result of updating the options list\n                    if (element.multiple) {\n                        // For a multiple-select box, compare the new selection count to the previous one\n                        // But if nothing was selected before, the selection can't have changed\n                        selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                    } else {\n                        // For a single-select box, compare the current value to the previous value\n                        // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                        selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0) ?\n                            (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                            : (previousSelectedValues.length || element.selectedIndex >= 0);\n                    }\n\n                    // Ensure consistency between model value and selected option.\n                    // If the dropdown was changed so that selection is no longer the same,\n                    // notify the value or selectedOptions binding.\n                    if (selectionChanged) {\n                        ko.utils.triggerEvent(element, 'change');\n                    }\n                }\n            });\n\n            if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20) {\n                element.scrollTop = previousScrollTop;\n            }\n            /**\n             *\n             * @returns {*}\n             */\n            function selectedOptions() {\n                return ko.utils.arrayFilter(element.options, function (node) {\n                    return node.selected;\n                });\n            }\n\n            /**\n             *\n             * @param {*} object\n             * @param {*} predicate\n             * @param {*} defaultValue\n             * @returns {*}\n             */\n            function applyToObject(object, predicate, defaultValue) {\n                var predicateType = typeof predicate;\n\n                if (predicateType === 'function') {   // Given a function; run it against the data value\n                    return predicate(object);\n                } else if (predicateType === 'string') { // Given a string; treat it as a property name on the data value\n                    return object[predicate];\n                } else {                      // Given no optionsText arg; use the data value itself\n                    return defaultValue;\n                }\n            }\n\n            /**\n             *\n             * @param {*} obj\n             */\n            function recursivePathBuilder(obj) {\n\n                obj[optionTitle] = (this && this[optionTitle] ? this[optionTitle] + '/' : '') + obj[optionsText].trim();\n\n                if (Array.isArray(obj[optionsValue])) {\n                    obj[optionsValue].map(recursivePathBuilder, obj);\n                }\n            }\n\n            /**\n             *\n             * @param {Array} arrayEntry\n             * @param {*} oldOptions\n             * @returns {*[]}\n             */\n            function optionNodeFromArray(arrayEntry, oldOptions) {\n                var option;\n\n                if (oldOptions.length) {\n                    previousSelectedValues = oldOptions[0].selected ? [ko.selectExtensions.readValue(oldOptions[0])] : [];\n                    itemUpdate = true;\n                }\n\n                if (arrayEntry === captionPlaceholder) { // empty value, label === caption\n                    option = element.ownerDocument.createElement('option');\n                    ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                    ko.selectExtensions.writeValue(option, undefined);\n                } else if (typeof arrayEntry[optionsValue] === 'undefined') { // empty value === optgroup\n                    option = utils.template(optgroupTmpl, {\n                        label: arrayEntry[optionsText],\n                        title: arrayEntry[optionsText + 'title']\n                    });\n                    option = ko.utils.parseHtmlFragment(option)[0];\n\n                } else {\n                    option = element.ownerDocument.createElement('option');\n                    option.setAttribute('data-title', arrayEntry[optionsText + 'title']);\n                    ko.selectExtensions.writeValue(option, arrayEntry[optionsValue]);\n                    ko.utils.setTextContent(option, arrayEntry[optionsText]);\n                }\n\n                return [option];\n            }\n\n            /**\n             *\n             * @param {*} newOptions\n             */\n            function setSelectionCallback(newOptions) {\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                if (previousSelectedValues.length) {\n                    var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions.value)) >= 0;\n                    ko.utils.setOptionNodeSelectionState(newOptions.value, isSelected);\n\n                    // If this option was changed from being selected during a single-item update, notify the change\n                    if (itemUpdate && !isSelected) {\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, 'change']);\n                    }\n                }\n            }\n\n            /**\n             *\n             * @param {*} string, times\n             * @returns {Array}\n             */\n            function strPad(string, times) {\n                return  (new Array(times + 1)).join(string);\n            }\n\n            /**\n             *\n             * @param {*} options\n             * @returns {Array}\n             */\n            function formatOptions(options) {\n                var res = [];\n                nestedOptionsLevel++;\n\n                if (!nestedOptionsLevel) { // zero level\n                    // If caption is included, add it to the array\n                    if (allBindings.has('optionsCaption')) {\n                        captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                        // If caption value is null or undefined, don't show a caption\n                        if (captionValue !== null && captionValue !== undefined && captionValue !== false) {\n                            res.push(captionPlaceholder);\n                        }\n                    }\n                }\n\n                ko.utils.arrayForEach(options, function (option) {\n                    var value = applyToObject(option, optionsValue, option),\n                        label = applyToObject(option, optionsText, value) || '',\n                        title = applyToObject(option, optionsText, value) || '',\n                        obj = {},\n                        space = '\\u2007\\u2007\\u2007';\n\n                    obj[optionTitle] = applyToObject(option, optionsText + 'title', value);\n\n                    label = label.replace(nbspRe, '').trim();\n\n                    if (Array.isArray(value)) {\n                        obj[optionsText] = strPad('&nbsp;', nestedOptionsLevel * 4) + label;\n                        res.push(obj);\n                        res = res.concat(formatOptions(value));\n                    } else {\n                        obj[optionsText] = strPad(space, nestedOptionsLevel * 2) + label;\n                        obj[optionsValue] = value;\n                        res.push(obj);\n                    }\n                });\n                nestedOptionsLevel--;\n\n                return res;\n            }\n        }\n    };\n    ko.bindingHandlers.selectedOptions.after.push('optgroup');\n});","Magento_Ui/js/lib/knockout/bindings/outer_click.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates outerClick binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var defaults = {\n        onlyIfVisible: true\n    };\n\n    /**\n     * Checks if element sis visible.\n     *\n     * @param {Element} el\n     * @returns {Boolean}\n     */\n    function isVisible(el) {\n        var style = window.getComputedStyle(el),\n            visibility = {\n                display: 'none',\n                visibility: 'hidden',\n                opacity: '0'\n            },\n            visible = true;\n\n        _.each(visibility, function (val, key) {\n            if (style[key] === val) {\n                visible = false;\n            }\n        });\n\n        return visible;\n    }\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element,\n     * invokes specfied in configuration callback.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} config\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, config, e) {\n        var target = e.target,\n            callback = config.callback;\n\n        if (container === target || container.contains(target)) {\n            return;\n        }\n\n        if (config.onlyIfVisible) {\n            if (!_.isNull(container.offsetParent) && isVisible(container)) {\n                callback();\n            }\n        } else {\n            callback();\n        }\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {(Object|Function)} [options={}]\n     * @returns {Object}\n     */\n    function buildConfig(options) {\n        var config = {};\n\n        if (_.isFunction(options)) {\n            options = {\n                callback: options\n            };\n        } else if (!_.isObject(options)) {\n            options = {};\n        }\n\n        return _.extend(config, defaults, options);\n    }\n\n    ko.bindingHandlers.outerClick = {\n\n        /**\n         * Initializes outer click binding.\n         */\n        init: function (element, valueAccessor) {\n            var config = buildConfig(valueAccessor()),\n                outerClick = onOuterClick.bind(null, element, config),\n                isTouchDevice = typeof document.ontouchstart !== 'undefined';\n\n            if (isTouchDevice) {\n                $(document).on('touchstart', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('touchstart', outerClick);\n                });\n            } else {\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n        }\n    };\n\n    renderer.addAttribute('outerClick');\n});\n","Magento_Ui/js/lib/knockout/bindings/range.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer',\n    'jquery/ui'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var isTouchDevice = !_.isUndefined(document.ontouchstart),\n        sliderFn = 'slider';\n\n    ko.bindingHandlers.range = {\n\n        /**\n         * Initializes binding and a slider update.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            var config  = valueAccessor(),\n                value   = config.value;\n\n            _.extend(config, {\n                value: value(),\n\n                /**\n                 * Callback which is being called when sliders' value changes.\n                 *\n                 * @param {Event} event\n                 * @param {Object} ui\n                 */\n                slide: function (event, ui) {\n                    value(ui.value);\n                }\n            });\n\n            $(element)[sliderFn](config);\n        },\n\n        /**\n         * Updates sliders' plugin configuration.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            var config = valueAccessor();\n\n            config.value = ko.unwrap(config.value);\n\n            $(element)[sliderFn]('option', config);\n        }\n    };\n\n    renderer.addAttribute('range');\n\n    if (!isTouchDevice) {\n        return;\n    }\n\n    $.widget('mage.touchSlider', $.ui.slider, {\n\n        /**\n         * Creates instance of widget.\n         *\n         * @override\n         */\n        _create: function () {\n            _.bindAll(\n                this,\n                '_mouseDown',\n                '_mouseMove',\n                '_onTouchEnd'\n            );\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Initializes mouse events on element.\n         * @override\n         */\n        _mouseInit: function () {\n            var result = this._superApply(arguments);\n\n            this.element\n                .off('mousedown.' + this.widgetName)\n                .on('touchstart.' + this.widgetName, this._mouseDown);\n\n            return result;\n        },\n\n        /**\n         * Elements' 'mousedown' event handler polyfill.\n         * @override\n         */\n        _mouseDown: function (event) {\n            var prevDelegate = this._mouseMoveDelegate,\n                result;\n\n            event = this._touchToMouse(event);\n            result = this._super(event);\n\n            if (prevDelegate === this._mouseMoveDelegate) {\n                return result;\n            }\n\n            $(document)\n                .off('mousemove.' + this.widgetName)\n                .off('mouseup.' + this.widgetName);\n\n            $(document)\n                .on('touchmove.' + this.widgetName, this._mouseMove)\n                .on('touchend.' + this.widgetName, this._onTouchEnd)\n                .on('tochleave.' + this.widgetName, this._onTouchEnd);\n\n            return result;\n        },\n\n        /**\n         * Documents' 'mousemove' event handler polyfill.\n         *\n         * @override\n         * @param {Event} event - Touch event object.\n         */\n        _mouseMove: function (event) {\n            event = this._touchToMouse(event);\n\n            return this._super(event);\n        },\n\n        /**\n         * Documents' 'touchend' event handler.\n         */\n        _onTouchEnd: function (event) {\n            $(document).trigger('mouseup');\n\n            return this._mouseUp(event);\n        },\n\n        /**\n         * Removes previously assigned touch handlers.\n         *\n         * @override\n         */\n        _mouseUp: function () {\n            this._removeTouchHandlers();\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Removes previously assigned touch handlers.\n         *\n         * @override\n         */\n        _mouseDestroy: function () {\n            this._removeTouchHandlers();\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Removes touch events from document object.\n         */\n        _removeTouchHandlers: function () {\n            $(document)\n                .off('touchmove.' + this.widgetName)\n                .off('touchend.' + this.widgetName)\n                .off('touchleave.' + this.widgetName);\n        },\n\n        /**\n         * Adds properties to the touch event to mimic mouse event.\n         *\n         * @param {Event} event - Touch event object.\n         * @returns {Event}\n         */\n        _touchToMouse: function (event) {\n            var orig = event.originalEvent,\n                touch = orig.touches[0];\n\n            return _.extend(event, {\n                which:      1,\n                pageX:      touch.pageX,\n                pageY:      touch.pageY,\n                clientX:    touch.clientX,\n                clientY:    touch.clientY,\n                screenX:    touch.screenX,\n                screenY:    touch.screenY\n            });\n        }\n    });\n\n    sliderFn = 'touchSlider';\n});\n","Magento_Ui/js/lib/knockout/bindings/resizable.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    '../template/renderer',\n    'jquery/ui'\n], function (ko, $, async, registry, _, renderer) {\n    'use strict';\n\n    var sizeOptions = [\n            'minHeight',\n            'maxHeight',\n            'minWidth',\n            'maxWidth'\n        ],\n\n        handles = {\n            height: '.ui-resizable-s, .ui-resizable-n',\n            width: '.ui-resizable-w, .ui-resizable-e'\n        };\n\n    /**\n     * Recalcs visibility of handles, width and height of resizable based on content\n     * @param {HTMLElement} element\n     */\n    function adjustSize(element) {\n        var maxHeight,\n            maxWidth;\n\n        element = $(element);\n        maxHeight = element.resizable('option').maxHeight;\n        maxWidth = element.resizable('option').maxWidth;\n\n        if (maxHeight && element.height() > maxHeight) {\n            element.height(maxHeight + 1);\n            $(handles.height).hide();\n        } else {\n            $(handles.height).show();\n        }\n\n        if (maxWidth && element.width() > maxWidth) {\n            element.width(maxWidth + 1);\n            $(handles.width).hide();\n        } else {\n            $(handles.width).show();\n        }\n    }\n\n    /**\n     * Recalcs allowed min, max width and height based on configured selectors\n     * @param {Object} sizeConstraints\n     * @param {String} componentName\n     * @param {HTMLElement} element\n     * @param {Boolean} hasWidthUpdate\n     */\n    function recalcAllowedSize(sizeConstraints, componentName, element, hasWidthUpdate) {\n        var size;\n\n        element = $(element);\n\n        if (!element.data('resizable')) {\n            return;\n        }\n\n        if (!hasWidthUpdate) {\n            element.css('width', 'auto');\n        }\n\n        _.each(sizeConstraints, function (selector, key) {\n            async.async({\n                component: componentName,\n                selector: selector\n            }, function (elem) {\n                size = key.indexOf('Height') !== -1 ? $(elem).outerHeight(true) : $(elem).outerWidth(true);\n\n                if (element.data('resizable')) {\n                    element.resizable('option', key, size + 1);\n                }\n            });\n        }, this);\n\n        adjustSize(element);\n    }\n\n    /**\n     * Preprocess config to separate options,\n     * which must be processed further before applying\n     *\n     * @param {Object} config\n     * @param {Object} viewModel\n     * @param {*} element\n     * @return {Object} config\n     */\n    function processConfig(config, viewModel, element) {\n        var sizeConstraint,\n            sizeConstraints = {},\n            recalc,\n            hasWidthUpdate;\n\n        if (_.isEmpty(config)) {\n            return {};\n        }\n        _.each(sizeOptions, function (key) {\n            sizeConstraint = config[key];\n\n            if (sizeConstraint && !_.isNumber(sizeConstraint)) {\n                sizeConstraints[key] = sizeConstraint;\n                delete config[key];\n            }\n        });\n        hasWidthUpdate =  _.some(sizeConstraints, function (value, key) {\n            return key.indexOf('Width') !== -1;\n        });\n\n        recalc = recalcAllowedSize.bind(null, sizeConstraints, viewModel.name, element, hasWidthUpdate);\n        config.start = recalc;\n        $(window).on('resize.resizable', recalc);\n        registry.get(viewModel.provider).on('reloaded', recalc);\n\n        return config;\n    }\n\n    ko.bindingHandlers.resizable = {\n\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = processConfig(valueAccessor(), viewModel, element);\n\n            $(element).resizable(config);\n        }\n    };\n\n    renderer.addAttribute('resizable');\n});\n","Magento_Ui/js/lib/knockout/bindings/scope.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates scope binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'uiRegistry',\n    'mage/translate',\n    '../template/renderer'\n], function (ko, registry, $t, renderer) {\n    'use strict';\n\n    /**\n     * Creates child context with passed component param as $data. Extends context with $t helper.\n     * Applies bindings to descendant nodes.\n     * @param {HTMLElement} el - element to apply bindings to.\n     * @param {ko.bindingContext} bindingContext - instance of ko.bindingContext, passed to binding initially.\n     * @param {Object} component - component instance to attach to new context\n     */\n    function applyComponents(el, bindingContext, component) {\n        component = bindingContext.createChildContext(component);\n\n        ko.utils.extend(component, {\n            $t: $t\n        });\n\n        ko.utils.arrayForEach(el.childNodes, ko.cleanNode);\n\n        ko.applyBindingsToDescendants(component, el);\n    }\n\n    ko.bindingHandlers.scope = {\n\n        /**\n         * Scope binding's init method.\n         * @returns {Object} - Knockout declaration for it to let binding control descendants.\n         */\n        init: function () {\n            return {\n                controlsDescendantBindings: true\n            };\n        },\n\n        /**\n         * Reads params passed to binding, parses component declarations.\n         * Fetches for those found and attaches them to the new context.\n         * @param {HTMLElement} el - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to el.\n         * @param {ko.bindingContext} bindingContext - Instance of ko.bindingContext, passed to binding initially.\n         */\n        update: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            var component = valueAccessor(),\n                apply = applyComponents.bind(this, el, bindingContext);\n\n            if (typeof component === 'string') {\n                registry.get(component, apply);\n            } else if (typeof component === 'function') {\n                component(apply);\n            }\n        }\n    };\n\n    ko.virtualElements.allowedBindings.scope = true;\n\n    renderer\n        .addNode('scope')\n        .addAttribute('scope', {\n            name: 'ko-scope'\n        });\n});\n","Magento_Ui/js/lib/knockout/bindings/simple-checked.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.simpleChecked = {\n        'after': ['attr'],\n\n        /**\n         * Implements same functionality as a standard 'simpleChecked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                updateView,\n                updateModel;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            /**\n             * Updates checked observable\n             */\n            updateModel = function () {\n                var  modelValue = ko.dependencyDetection.ignore(valueAccessor),\n                    isChecked = element.checked;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (modelValue.peek() === isChecked) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue(isChecked);\n            };\n\n            /**\n             * Updates checkbox state\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                element.checked = !!modelValue;\n            };\n\n            ko.utils.registerEventHandler(element, 'change', updateModel);\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting.twoWayBindings.simpleChecked = true;\n\n    renderer.addAttribute('simpleChecked');\n    renderer.addAttribute('simple-checked', {\n        binding: 'simpleChecked'\n    });\n});\n","Magento_Ui/js/lib/knockout/bindings/staticChecked.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.staticChecked = {\n        'after': ['value', 'attr'],\n\n        /**\n         * Implements same functionality as a standard 'checked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor, allBindings) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                isValueArray,\n                oldElemValue,\n                useCheckedValue,\n                checkedValue,\n                updateModel,\n                updateView;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            checkedValue = ko.pureComputed(function () {\n                if (allBindings.has('checkedValue')) {\n                    return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                } else if (allBindings.has('value')) {\n                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                }\n\n                return element.value;\n            });\n\n            isValueArray = isCheckbox && ko.utils.unwrapObservable(valueAccessor()) instanceof Array;\n            oldElemValue = isValueArray ? checkedValue() : undefined;\n            useCheckedValue = isRadio || isValueArray;\n\n            /**\n             * Updates values array if it's necessary.\n             */\n            updateModel = function () {\n                var isChecked = element.checked,\n                    elemValue = useCheckedValue ? checkedValue() : isChecked,\n                    modelValue;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue = ko.dependencyDetection.ignore(valueAccessor);\n\n                if (isValueArray) {\n                    if (oldElemValue !== elemValue) {\n                        oldElemValue = elemValue;\n                    } else {\n                        ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);\n                    }\n                } else {\n                    ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                }\n            };\n\n            /**\n             * Updates checkbox state.\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                if (isValueArray) {\n                    element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n                } else if (isCheckbox) {\n                    element.checked = modelValue;\n                } else {\n                    element.checked = checkedValue() === modelValue;\n                }\n            };\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n\n            ko.utils.registerEventHandler(element, 'click', updateModel);\n\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting.twoWayBindings.staticChecked = true;\n\n    renderer.addAttribute('staticChecked');\n});\n","Magento_Ui/js/lib/knockout/bindings/tooltip.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    'mage/template',\n    'text!ui/template/tooltip/tooltip.html',\n    '../template/renderer'\n], function ($, ko, _, template, tooltipTmpl, renderer) {\n    'use strict';\n\n    var tooltip,\n        defaults,\n        positions,\n        transformProp,\n        checkedPositions = {},\n        iterator = 0,\n        previousTooltip,\n        tooltipData,\n        positionData = {},\n        tooltipsCollection = {},\n        isTouchDevice = (function () {\n            return 'ontouchstart' in document.documentElement;\n        })(),\n        CLICK_EVENT = (function () {\n            return isTouchDevice ? 'touchstart' : 'click';\n        })();\n\n    defaults = {\n        tooltipWrapper: '[data-tooltip=tooltip-wrapper]',\n        tooltipContentBlock: 'data-tooltip-content',\n        closeButtonClass: 'action-close',\n        tailClass: 'data-tooltip-tail',\n        action: 'hover',\n        delay: 300,\n        track: false,\n        step: 20,\n        position: 'top',\n        closeButton: false,\n        showed: false,\n        strict: true,\n        center: false\n    };\n\n    tooltipData = {\n        trigger: false,\n        timeout: 0,\n        element: false,\n        event: false,\n        targetElement: {},\n        showed: false,\n        currentID: 0\n    };\n\n    /**\n     * Polyfill for css transform\n     */\n    transformProp = (function () {\n        var style = document.createElement('div').style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform !== 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] !== 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    positions = {\n\n        /*eslint max-depth: [0, 0]*/\n\n        map: {\n            horizontal: {\n                s: 'w',\n                p: 'left'\n            },\n            vertical: {\n                s: 'h',\n                p: 'top'\n            }\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        top: function (s) {\n            return positions._topLeftChecker(s, positions.map, 'vertical', '_bottom', 'top', 'right');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        left: function (s) {\n            return positions._topLeftChecker(s, positions.map, 'horizontal', '_right', 'left', 'top');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        bottom: function (s) {\n            return positions._bottomRightChecker(s, positions.map, 'vertical', '_top', 'bottom', 'left');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        right: function (s) {\n            return positions._bottomRightChecker(s, positions.map, 'horizontal', '_left', 'right', 'bottom');\n        },\n\n        /**\n         * Check can tooltip setted on current position or not. If can't setted - delegate call.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {String} className - class whats should be setted to tooltip\n         * @param {String} side - parent method name\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _topLeftChecker: function (s, map, direction, className, side, delegate) {\n            var result = {\n                    position: {}\n                },\n                config = tooltip.getTooltip(tooltipData.currentID),\n                startPosition = !config.strict ? s.eventPosition : s.elementPosition,\n                changedDirection;\n\n            checkedPositions[side] = true;\n\n            if (\n                startPosition[map[direction].p] - s.tooltipSize[map[direction].s] - config.step >\n                s.scrollPosition[map[direction].p]\n            ) {\n                result.position[map[direction].p] = startPosition[map[direction].p] - s.tooltipSize[map[direction].s] -\n                    config.step;\n                result.className = className;\n                result.side = side;\n                changedDirection = direction === 'vertical' ? 'horizontal' : 'vertical';\n                result = positions._normalize(s, result, config, delegate, map, changedDirection);\n            } else if (!checkedPositions[delegate]) {\n                result = positions[delegate].apply(null, arguments);\n            } else {\n                result = positions.positionCenter(s, result);\n            }\n\n            return result;\n        },\n\n        /**\n         * Check can tooltip setted on current position or not. If can't setted - delegate call.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {String} className - class whats should be setted to tooltip\n         * @param {String} side - parent method name\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _bottomRightChecker: function (s, map, direction, className, side, delegate) {\n            var result = {\n                    position: {}\n                },\n                config = tooltip.getTooltip(tooltipData.currentID),\n                startPosition = !config.strict ? s.eventPosition : {\n                    top: s.elementPosition.top + s.elementSize.h,\n                    left: s.elementPosition.left + s.elementSize.w\n                },\n                changedDirection;\n\n            checkedPositions[side] = true;\n\n            if (\n                startPosition[map[direction].p] + s.tooltipSize[map[direction].s] + config.step <\n                s.scrollPosition[map[direction].p] + s.windowSize[map[direction].s]\n            ) {\n                result.position[map[direction].p] = startPosition[map[direction].p] + config.step;\n                result.className = className;\n                result.side = side;\n                changedDirection = direction === 'vertical' ? 'horizontal' : 'vertical';\n                result = positions._normalize(s, result, config, delegate, map, changedDirection);\n            } else if (!checkedPositions[delegate]) {\n                result = positions[delegate].apply(null, arguments);\n            } else {\n                result = positions.positionCenter(s, result);\n            }\n\n            return result;\n        },\n\n        /**\n         * Centered tooltip if tooltip does not fit in window\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        positionCenter: function (s, data) {\n            data = positions._positionCenter(s, data, 'horizontal', positions.map);\n            data = positions._positionCenter(s, data, 'vertical', positions.map);\n\n            return data;\n        },\n\n        /**\n         * Centered tooltip side\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {String} direction - vertical or horizontal\n         * @param {Object} map - mapping for get direction positions\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _positionCenter: function (s, data, direction, map) {\n            if (s.tooltipSize[map[direction].s] < s.windowSize[map[direction].s]) {\n                data.position[map[direction].p] = (s.windowSize[map[direction].s] -\n                    s.tooltipSize[map[direction].s]) / 2 + s.scrollPosition[map[direction].p];\n            } else {\n                data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                data.tooltipSize = {};\n                data.tooltipSize[map[direction].s] = s.windowSize[map[direction].s];\n            }\n\n            return data;\n        },\n\n        /**\n         * Normalize horizontal or vertical position.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {Object} config - tooltip config\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _normalize: function (s, data, config, delegate, map, direction) {\n            var startPosition = !config.center ? s.eventPosition : {\n                    left: s.elementPosition.left + s.elementSize.w / 2,\n                    top: s.elementPosition.top + s.elementSize.h / 2\n                },\n                depResult;\n\n            if (startPosition[map[direction].p] - s.tooltipSize[map[direction].s] / 2 >\n                s.scrollPosition[map[direction].p] && startPosition[map[direction].p] +\n                s.tooltipSize[map[direction].s] / 2 <\n                s.scrollPosition[map[direction].p] + s.windowSize[map[direction].s]\n            ) {\n                data.position[map[direction].p] = startPosition[map[direction].p] - s.tooltipSize[map[direction].s] / 2;\n            } else {\n\n                /*eslint-disable no-lonely-if*/\n                if (!checkedPositions[delegate]) {\n                    depResult = positions[delegate].apply(null, arguments);\n\n                    if (depResult.hasOwnProperty('className')) {\n                        data = depResult;\n                    } else {\n                        data = positions._normalizeTail(s, data, config, delegate, map, direction, startPosition);\n                    }\n                } else {\n                    data = positions._normalizeTail(s, data, config, delegate, map, direction, startPosition);\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Calc tail position.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {Object} config - tooltip config\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {Object} startPosition - start position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _normalizeTail: function (s, data, config, delegate, map, direction, startPosition) {\n            data.tail = {};\n\n            if (s.tooltipSize[map[direction].s] < s.windowSize[map[direction].s]) {\n\n                if (\n                    startPosition[map[direction].p] >\n                    s.windowSize[map[direction].s] / 2 + s.scrollPosition[map[direction].p]\n                ) {\n                    data.position[map[direction].p] = s.windowSize[map[direction].s] +\n                        s.scrollPosition[map[direction].p] - s.tooltipSize[map[direction].s];\n                    data.tail[map[direction].p] = startPosition[map[direction].p] -\n                        s.tooltipSize[map[direction].s] / 2 - data.position[map[direction].p];\n                } else {\n                    data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                    data.tail[map[direction].p] = startPosition[map[direction].p] -\n                        s.tooltipSize[map[direction].s] / 2 - data.position[map[direction].p];\n                }\n            } else {\n                data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                data.tail[map[direction].p] = s.eventPosition[map[direction].p] - s.windowSize[map[direction].s] / 2;\n                data.tooltipSize = {};\n                data.tooltipSize[map[direction].s] = s.windowSize[map[direction].s];\n            }\n\n            return data;\n        }\n    };\n\n    tooltip = {\n\n        /**\n         * Set new tooltip to tooltipCollection, save config, and add unic id\n         *\n         * @param {Object} config - tooltip config\n         * @returns {String} tooltip id\n         */\n        setTooltip: function (config) {\n            var property = 'id-' + iterator;\n\n            tooltipsCollection[property] = config;\n            iterator++;\n\n            return property;\n        },\n\n        /**\n         * Get tooltip config by id\n         *\n         * @param {String} id - tooltip id\n         * @returns {Object} tooltip config\n         */\n        getTooltip: function (id) {\n            return tooltipsCollection[id];\n        },\n\n        /**\n         * Set content to current tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {Object} viewModel - tooltip view model\n         * @param {String} id - tooltip id\n         * @param {Object} bindingCtx - tooltip context\n         * @param {Object} event - action event\n         */\n        setContent: function (tooltipElement, viewModel, id, bindingCtx, event) {\n            var html = $(tooltipElement).html(),\n                config = tooltip.getTooltip(id),\n                body = $('body');\n\n            tooltipData.currentID = id;\n            tooltipData.trigger = $(event.currentTarget);\n            tooltip.setTargetData(event);\n            body.on('mousemove.setTargetData', tooltip.setTargetData);\n            tooltip.clearTimeout(id);\n\n            tooltipData.timeout = _.delay(function () {\n                body.off('mousemove.setTargetData', tooltip.setTargetData);\n\n                if (tooltipData.trigger[0] === tooltipData.targetElement) {\n                    tooltip.destroy(id);\n                    event.stopPropagation();\n                    tooltipElement = tooltip.createTooltip(id);\n                    tooltipElement.find('.' + defaults.tooltipContentBlock).append(html);\n                    tooltipElement.applyBindings(bindingCtx);\n                    tooltip.setHandlers(id);\n                    tooltip.setPosition(tooltipElement, id);\n                    previousTooltip = id;\n                }\n\n            }, config.delay);\n        },\n\n        /**\n         * Set position to current tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {String} id - tooltip id\n         */\n        setPosition: function (tooltipElement, id) {\n            var config = tooltip.getTooltip(id);\n\n            tooltip.sizeData = {\n                windowSize: {\n                    h: $(window).outerHeight(),\n                    w: $(window).outerWidth()\n                },\n                scrollPosition: {\n                    top: $(window).scrollTop(),\n                    left: $(window).scrollLeft()\n                },\n                tooltipSize: {\n                    h: tooltipElement.outerHeight(),\n                    w: tooltipElement.outerWidth()\n                },\n                elementSize: {\n                    h: tooltipData.trigger.outerHeight(),\n                    w: tooltipData.trigger.outerWidth()\n                },\n                elementPosition: tooltipData.trigger.offset(),\n                eventPosition: this.getEventPosition(tooltipData.event)\n            };\n\n            _.extend(positionData, positions[config.position](tooltip.sizeData));\n            tooltipElement.css(positionData.position);\n            tooltipElement.addClass(positionData.className);\n            tooltip._setTooltipSize(positionData, tooltipElement);\n            tooltip._setTailPosition(positionData, tooltipElement);\n            checkedPositions = {};\n        },\n\n        /**\n         * Check position data and change tooltip size if needs\n         *\n         * @param {Object} data - position data\n         * @param {Object} tooltipElement - tooltip element\n         */\n        _setTooltipSize: function (data, tooltipElement) {\n            if (data.tooltipSize) {\n                data.tooltipSize.w ?\n                    tooltipElement.css('width', data.tooltipSize.w) :\n                    tooltipElement.css('height', data.tooltipSize.h);\n            }\n        },\n\n        /**\n         * Check position data and set position to tail\n         *\n         * @param {Object} data - position data\n         * @param {Object} tooltipElement - tooltip element\n         */\n        _setTailPosition: function (data, tooltipElement) {\n            var tail,\n                tailMargin;\n\n            if (data.tail) {\n                tail = tooltipElement.find('.' + defaults.tailClass);\n\n                if (data.tail.left) {\n                    tailMargin = parseInt(tail.css('margin-left'), 10);\n                    tail.css('margin-left', tailMargin + data.tail.left);\n                } else {\n                    tailMargin = parseInt(tail.css('margin-top'), 10);\n                    tail.css('margin-top', tailMargin + data.tail.top);\n                }\n            }\n        },\n\n        /**\n         * Resolves position for tooltip\n         *\n         * @param {Object} event\n         * @returns {Object}\n         */\n        getEventPosition: function (event) {\n            var position = {\n                left: event.originalEvent && event.originalEvent.pageX || 0,\n                top: event.originalEvent && event.originalEvent.pageY || 0\n            };\n\n            if (position.left === 0 && position.top === 0) {\n                _.extend(position, event.target.getBoundingClientRect());\n            }\n\n            return position;\n        },\n\n        /**\n         * Close tooltip if action happened outside handler and tooltip element\n         *\n         * @param {String} id - tooltip id\n         * @param {Object} event - action event\n         */\n        outerClick: function (id, event) {\n            var tooltipElement = $(event.target).parents(defaults.tooltipWrapper)[0],\n                isTrigger = event.target === tooltipData.trigger[0] || $.contains(tooltipData.trigger[0], event.target);\n\n            if (tooltipData.showed && tooltipElement !== tooltipData.element[0] && !isTrigger) {\n                tooltip.destroy(id);\n            }\n        },\n\n        /**\n         * Parse keydown event and if event trigger is escape key - close tooltip\n         *\n         * @param {Object} event - action event\n         */\n        keydownHandler: function (event) {\n            if (tooltipData.showed && event.keyCode === 27) {\n                tooltip.destroy(tooltipData.currentID);\n            }\n        },\n\n        /**\n         * Change tooltip position when track is enabled\n         *\n         * @param {Object} event - current event\n         */\n        track: function (event) {\n            var inequality = {},\n                map = positions.map,\n                translate = {\n                    left: 'translateX',\n                    top: 'translateY'\n                },\n                eventPosition = {\n                    left: event.pageX,\n                    top: event.pageY\n                },\n                tooltipSize = {\n                    w: tooltipData.element.outerWidth(),\n                    h: tooltipData.element.outerHeight()\n                },\n                direction = positionData.side === 'bottom' || positionData.side === 'top' ? 'horizontal' : 'vertical';\n\n            inequality[map[direction].p] = eventPosition[map[direction].p] - (positionData.position[map[direction].p] +\n                tooltipSize[map[direction].s] / 2);\n\n            if (positionData.position[map[direction].p] + inequality[map[direction].p] +\n                tooltip.sizeData.tooltipSize[map[direction].s] >\n                tooltip.sizeData.windowSize[map[direction].s] + tooltip.sizeData.scrollPosition[map[direction].p] ||\n                inequality[map[direction].p] + positionData.position[map[direction].p] <\n                tooltip.sizeData.scrollPosition[map[direction].p]) {\n\n                return false;\n            }\n\n            tooltipData.element[0].style[transformProp] = translate[map[direction].p] +\n                '(' + inequality[map[direction].p] + 'px)';\n        },\n\n        /**\n         * Set handlers to tooltip\n         *\n         * @param {String} id - tooltip id\n         */\n        setHandlers: function (id) {\n            var config = tooltip.getTooltip(id);\n\n            if (config.track) {\n                tooltipData.trigger.on('mousemove.track', tooltip.track);\n            }\n\n            if (config.action === 'click') {\n                $(window).on(CLICK_EVENT + '.outerClick', tooltip.outerClick.bind(null, id));\n            }\n\n            if (config.closeButton) {\n                $('.' + config.closeButtonClass).on('click.closeButton', tooltip.destroy.bind(null, id));\n            }\n\n            document.addEventListener('scroll', tooltip.destroy, true);\n            $(window).on('keydown.tooltip', tooltip.keydownHandler);\n            $(window).on('scroll.tooltip', tooltip.outerClick.bind(null, id));\n            $(window).on('resize.outerClick', tooltip.outerClick.bind(null, id));\n        },\n\n        /**\n         * Toggle tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {Object} viewModel - tooltip view model\n         * @param {String} id - tooltip id\n         */\n        toggleTooltip: function (tooltipElement, viewModel, id) {\n            if (previousTooltip === id && tooltipData.showed) {\n                tooltip.destroy(id);\n\n                return false;\n            }\n\n            tooltip.setContent.apply(null, arguments);\n        },\n\n        /**\n         * Create tooltip and append to DOM\n         *\n         * @param {String} id - tooltip id\n         * @returns {Object} tooltip element\n         */\n        createTooltip: function (id) {\n            var body = $('body'),\n                config = tooltip.getTooltip(id);\n\n            $(template(tooltipTmpl, {\n                data: config\n            })).appendTo(body);\n\n            tooltipData.showed = true;\n            tooltipData.element = $(config.tooltipWrapper);\n\n            return tooltipData.element;\n        },\n\n        /**\n         * Check action and clean timeout\n         *\n         * @param {String} id - tooltip id\n         */\n        clearTimeout: function (id) {\n            var config = tooltip.getTooltip(id);\n\n            if (config.action === 'hover') {\n                clearTimeout(tooltipData.timeout);\n            }\n        },\n\n        /**\n         * Check previous tooltip\n         */\n        checkPreviousTooltip: function () {\n            if (!tooltipData.timeout) {\n                tooltip.destroy();\n            }\n        },\n\n        /**\n         * Destroy tooltip instance\n         */\n        destroy: function () {\n            if (tooltipData.element) {\n                tooltipData.element.remove();\n                tooltipData.showed = false;\n            }\n\n            positionData = {};\n            tooltipData.timeout = false;\n            tooltip.removeHandlers();\n        },\n\n        /**\n         * Remove tooltip handlers\n         */\n        removeHandlers: function () {\n            $('.' + defaults.closeButtonClass).off('click.closeButton');\n            tooltipData.trigger.off('mousemove.track');\n            document.removeEventListener('scroll', tooltip.destroy, true);\n            $(window).off(CLICK_EVENT + '.outerClick');\n            $(window).off('keydown.tooltip');\n            $(window).off('resize.outerClick');\n        },\n\n        /**\n         * Set target element\n         *\n         * @param {Object} event - current event\n         */\n        setTargetData: function (event) {\n            tooltipData.event = event;\n\n            //TODO: bug chrome v.49; Link to issue https://bugs.chromium.org/p/chromium/issues/detail?id=161464\n            if (event.timeStamp - (tooltipData.timestamp || 0) < 1) {\n                return;\n            }\n\n            if (event.type === 'mousemove') {\n                tooltipData.targetElement = event.target;\n            } else {\n                tooltipData.targetElement = event.currentTarget;\n                tooltipData.timestamp = event.timeStamp;\n            }\n        },\n\n        /**\n         * Merged user config with defaults configuration\n         *\n         * @param {Object} config - user config\n         * @returns {Object} merged config\n         */\n        processingConfig: function (config) {\n            return _.extend({}, defaults, config);\n        }\n    };\n\n    ko.bindingHandlers.tooltip = {\n\n        /**\n         * Initialize tooltip\n         *\n         * @param {Object} elem - tooltip DOM element\n         * @param {Function} valueAccessor - ko observable property, tooltip data\n         * @param {Object} allBindings - all bindings on current element\n         * @param {Object} viewModel - current element viewModel\n         * @param {Object} bindingCtx - current element binding context\n         */\n        init: function (elem, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var config = tooltip.processingConfig(valueAccessor()),\n                $parentScope = config.parentScope ? $(config.parentScope) : $(elem).parent(),\n                tooltipId;\n\n            $(elem).addClass('hidden');\n\n            if (isTouchDevice) {\n                config.action = 'click';\n            }\n            tooltipId = tooltip.setTooltip(config);\n\n            if (config.action === 'hover') {\n                $parentScope.on(\n                    'mouseenter',\n                    config.trigger,\n                    tooltip.setContent.bind(null, elem, viewModel, tooltipId, bindingCtx)\n                );\n                $parentScope.on(\n                    'mouseleave',\n                    config.trigger,\n                    tooltip.checkPreviousTooltip.bind(null, tooltipId)\n                );\n            } else if (config.action === 'click') {\n                $parentScope.on(\n                    'click',\n                    config.trigger,\n                    tooltip.toggleTooltip.bind(null, elem, viewModel, tooltipId, bindingCtx)\n                );\n            }\n\n            return {\n                controlsDescendantBindings: true\n            };\n        }\n    };\n\n    renderer.addAttribute('tooltip');\n});\n","Magento_Ui/js/lib/knockout/extender/bound-nodes.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/utils/wrapper',\n    'uiEvents',\n    'es6-collections'\n], function (ko, _, wrapper, Events) {\n    'use strict';\n\n    var nodesMap = new WeakMap();\n\n    /**\n     * Returns a array of nodes associated with a specified model.\n     *\n     * @param {Object} model\n     * @returns {Undefined|Array}\n     */\n    function getBounded(model) {\n        return nodesMap.get(model);\n    }\n\n    /**\n     * Removes specified node to models' associations list, if it's\n     * a root node (node is not a descendant of any previously added nodes).\n     * Triggers 'addNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function addBounded(model, node) {\n        var nodes = getBounded(model),\n            isRoot;\n\n        if (!nodes) {\n            nodesMap.set(model, [node]);\n\n            Events.trigger.call(model, 'addNode', node);\n\n            return;\n        }\n\n        isRoot = nodes.every(function (bounded) {\n            return !bounded.contains(node);\n        });\n\n        if (isRoot) {\n            nodes.push(node);\n\n            Events.trigger.call(model, 'addNode', node);\n        }\n    }\n\n    /**\n     * Removes specified node from models' associations list.\n     * Triggers 'removeNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function removeBounded(model, node) {\n        var nodes = getBounded(model),\n            index;\n\n        if (!nodes) {\n            return;\n        }\n\n        index = nodes.indexOf(node);\n\n        if (~index) {\n            nodes.splice(index, 0);\n\n            Events.trigger.call(model, 'removeNode', node);\n        }\n\n        if (!nodes.length) {\n            nodesMap.delete(model);\n        }\n    }\n\n    /**\n     * Returns node's first sibling of 'element' type within the common component scope\n     *\n     * @param {HTMLElement} node\n     * @returns {HTMLElement}\n     */\n    function getElement(node, data) {\n        var elem;\n\n        while (node.nextElementSibling) {\n            node = node.nextElementSibling;\n\n            if (node.nodeType === 1 && ko.dataFor(node) === data) {\n                elem = node;\n                break;\n            }\n        }\n\n        return elem;\n    }\n\n    wrapper.extend(ko, {\n\n        /**\n         * Extends kncokouts' 'applyBindings'\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'applyBindings' method.\n         */\n        applyBindings: function (orig, ctx, node) {\n            var result = orig(),\n                data = ctx && (ctx.$data || ctx);\n\n            if (node && node.nodeType === 8) {\n                node = getElement(node, data);\n            }\n\n            if (!node || node.nodeType !== 1) {\n                return result;\n            }\n\n            if (data && data.registerNodes) {\n                addBounded(data, node);\n            }\n\n            return result;\n        },\n\n        /**\n         * Extends kncokouts' cleanNode\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'cleanNode' method.\n         */\n        cleanNode: function (orig, node) {\n            var result = orig(),\n                data;\n\n            if (node.nodeType !== 1) {\n                return result;\n            }\n\n            data = ko.dataFor(node);\n\n            if (data && data.registerNodes) {\n                removeBounded(data, node);\n            }\n\n            return result;\n        }\n    });\n\n    return {\n\n        /**\n         * Returns root nodes associated with a model. If callback is provided,\n         * will iterate through all of the present nodes triggering callback\n         * for each of it. Also it will subscribe to the 'addNode' event.\n         *\n         * @param {Object} model\n         * @param {Function} [callback]\n         * @returns {Array|Undefined}\n         */\n        get: function (model, callback) {\n            var nodes = getBounded(model) || [];\n\n            if (!_.isFunction(callback)) {\n                return nodes;\n            }\n\n            nodes.forEach(function (node) {\n                callback(node);\n            });\n\n            this.add.apply(this, arguments);\n        },\n\n        /**\n         * Subscribes to adding of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        add: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('addNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Subscribes to removal of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        remove: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('removeNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Removes subscriptions from the model.\n         *\n         * @param {Object} model\n         */\n        off: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            Events.off.apply(model, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/extender/observable_array.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore'\n], function (ko, _) {\n    'use strict';\n\n    function iterator(callback, args, elem) {\n        callback = elem[callback];\n\n        if (_.isFunction(callback)) {\n            return callback.apply(elem, args);\n        }\n\n        return callback;\n    }\n\n    function wrapper(method) {\n        return function (iteratee) {\n            var callback = iteratee,\n                elems = this(),\n                args = _.toArray(arguments);\n\n            if (_.isString(iteratee)) {\n                callback = iterator.bind(null, iteratee, args.slice(1));\n\n                args.unshift(callback);\n            }\n\n            args.unshift(elems);\n\n            return _[method].apply(_, args);\n        };\n    }\n\n    _.extend(ko.observableArray.fn, {\n        each: wrapper('each'),\n\n        map: wrapper('map'),\n\n        filter: wrapper('filter'),\n\n        some: wrapper('some'),\n\n        every: wrapper('every'),\n\n        groupBy: wrapper('groupBy'),\n\n        sortBy: wrapper('sortBy'),\n\n        findWhere: function (properties) {\n            return _.findWhere(this(), properties);\n        },\n\n        contains: function (value) {\n            return _.contains(this(), value);\n        },\n\n        hasNo: function () {\n            return !this.contains.apply(this, arguments);\n        },\n\n        getLength: function () {\n            return this().length;\n        },\n\n        indexBy: function (key) {\n            return _.indexBy(this(), key);\n        },\n\n        without: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.without.apply(_, args);\n        },\n\n        first: function () {\n            return _.first(this());\n        },\n\n        last: function () {\n            return _.last(this());\n        },\n\n        pluck: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.pluck.apply(_, args);\n        }\n    });\n});\n","Magento_Ui/js/lib/knockout/template/engine.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    './observable_source',\n    './renderer'\n], function (ko, _, Source, renderer) {\n    'use strict';\n\n    var RemoteTemplateEngine,\n        NativeTemplateEngine = ko.nativeTemplateEngine,\n        sources = {};\n\n    /**\n     * Remote template engine class. Is used to be able to load remote templates via knockout template binding.\n     */\n    RemoteTemplateEngine = function () {};\n\n    /**\n     * Creates unique template identifier based on template name and it's extenders (optional)\n     * @param  {String} templateName\n     * @return {String} - unique template identifier\n     */\n    function createTemplateIdentifier(templateName) {\n        return templateName;\n    }\n\n    RemoteTemplateEngine.prototype = new NativeTemplateEngine;\n    RemoteTemplateEngine.prototype.constructor = RemoteTemplateEngine;\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Caches template after it's unique name and renders in once.\n     * If template name is not typeof string, delegates work to knockout.templateSources.anonymousTemplate.\n     * @param  {*} template\n     * @returns {TemplateSource} Object with methods 'nodes' and 'data'.\n     */\n    RemoteTemplateEngine.prototype.makeTemplateSource = function (template) {\n        var source,\n            templateId;\n\n        if (typeof template === 'string') {\n            templateId = createTemplateIdentifier(template);\n            source = sources[templateId];\n\n            if (!source) {\n                source = new Source(template);\n                sources[templateId] = source;\n\n                renderer.render(template).done(function (rendered) {\n                    source.nodes(rendered);\n                });\n            }\n\n            return source;\n        } else if (template.nodeType === 1 || template.nodeType === 8) {\n            source = new ko.templateSources.anonymousTemplate(template);\n\n            return source;\n        }\n\n        throw new Error('Unknown template type: ' + template);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Should return array of html elements.\n     * @param  {TemplateSource} templateSource - object with methods 'nodes' and 'data'.\n     * @return {Array} - array of html elements\n     */\n    RemoteTemplateEngine.prototype.renderTemplateSource = function (templateSource) {\n        var nodes = templateSource.nodes();\n\n        return ko.utils.cloneNodes(nodes);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Created in order to invoke makeTemplateSource method with custom set of params.\n     * @param  {*} template - template identifier\n     * @param  {ko.bindingContext} bindingContext\n     * @param  {Object} options - options, passed to template binding\n     * @param  {HTMLElement} templateDocument - document\n     * @return {Array} - array of html elements\n     */\n    RemoteTemplateEngine.prototype.renderTemplate = function (template, bindingContext, options, templateDocument) {\n        var templateSource = this.makeTemplateSource(template, templateDocument, options);\n\n        return this.renderTemplateSource(templateSource, bindingContext, options);\n    };\n\n    return new RemoteTemplateEngine;\n});\n","Magento_Ui/js/lib/knockout/template/loader.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var licenseRegExp   = /<!--[\\s\\S]*?-->/,\n        defaultPlugin   = 'text',\n        defaultExt      = 'html';\n\n    /**\n     * Checks of provided string contains a file extension.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function hasFileExtension(str) {\n        return !!~str.indexOf('.') && !!str.split('.').pop();\n    }\n\n    /**\n     * Checks if provided string contains a requirejs's plugin reference.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function hasPlugin(str) {\n        return !!~str.indexOf('!');\n    }\n\n    /**\n     * Checks if provided string is a full path to the file.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function isFullPath(str) {\n        return !!~str.indexOf('://');\n    }\n\n    /**\n     * Removes license comment from the provided string.\n     *\n     * @param {String} content - String to be processed.\n     * @returns {String}\n     */\n    function removeLicense(content) {\n        return content.replace(licenseRegExp, function (match) {\n            return ~match.indexOf('/**') ? '' : match;\n        });\n    }\n\n    return {\n\n        /**\n         * Attempts to extract template by provided path from\n         * a DOM element and falls back to a file loading if\n         * none of the DOM nodes was found.\n         *\n         * @param {String} path - Path to the template or a DOM selector.\n         * @returns {jQueryPromise}\n         */\n        loadTemplate: function (path) {\n            var content = this.loadFromNode(path),\n                defer;\n\n            if (content) {\n                defer = $.Deferred();\n\n                defer.resolve(content);\n\n                return defer.promise();\n            }\n\n            return this.loadFromFile(path);\n        },\n\n        /**\n         * Loads template from external file by provided\n         * path, which will be preliminary formatted.\n         *\n         * @param {String} path - Path to the template.\n         * @returns {jQueryPromise}\n         */\n        loadFromFile: function (path) {\n            var loading = $.Deferred();\n\n            path = this.formatPath(path);\n\n            require([path], function (template) {\n                template = removeLicense(template);\n\n                loading.resolve(template);\n            });\n\n            return loading.promise();\n        },\n\n        /**\n         * Attempts to extract content of a node found by provided selector.\n         *\n         * @param {String} selector - Node's selector (not necessary valid).\n         * @returns {String|Boolean} If specified node doesn't exists\n         *      'false' will be returned, otherwise returns node's content.\n         */\n        loadFromNode: function (selector) {\n            var node;\n\n            try {\n                node =\n                    document.getElementById(selector) ||\n                    document.querySelector(selector);\n\n                return node ? node.innerHTML : false;\n            } catch (e) {\n                return false;\n            }\n        },\n\n        /**\n         * Adds requirejs's plugin and file extension to\n         * to the provided string if it's necessary.\n         *\n         * @param {String} path - Path to be processed.\n         * @returns {String} Formatted path.\n         */\n        formatPath: function (path) {\n            var result = path;\n\n            if (!hasPlugin(path)) {\n                result = defaultPlugin + '!' + result;\n            }\n\n            if (isFullPath(path)) {\n                return result;\n            }\n\n            if (!hasFileExtension(path)) {\n                result += '.' + defaultExt;\n            }\n\n            return result.replace(/^([^\\/]+)/g, '$1/template');\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/template/observable_source.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * Is being used by knockout template engine to store template to.\n */\ndefine([\n    'ko',\n    'uiClass'\n], function (ko, Class) {\n    'use strict';\n\n    return Class.extend({\n\n        /**\n         * Initializes templateName, _data, nodes properties.\n         *\n         * @param  {template} template - identifier of template\n         */\n        initialize: function (template) {\n            this.templateName = template;\n            this._data = {};\n            this.nodes = ko.observable([]);\n        },\n\n        /**\n         * Data setter. If only one arguments passed, returns corresponding value.\n         * Else, writes into it.\n         * @param  {String} key - key to write to or to read from\n         * @param  {*} value\n         * @return {*} - if 1 arg provided, returnes _data[key] property\n         */\n        data: function (key, value) {\n            if (arguments.length === 1) {\n                return this._data[key];\n            }\n\n            this._data[key] = value;\n        }\n    });\n});\n","Magento_Ui/js/lib/knockout/template/renderer.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    './loader'\n], function ($, _, loader) {\n    'use strict';\n\n    var colonReg    = /\\\\:/g,\n        attributes  = {},\n        elements    = {},\n        globals     = [],\n        renderer,\n        preset;\n\n    renderer = {\n\n        /**\n         * Loads template by provided path and\n         * than converts it's content to html.\n         *\n         * @param {String} tmplPath - Path to the template.\n         * @returns {jQueryPromise}\n         */\n        render: function (tmplPath) {\n            var loadPromise = loader.loadTemplate(tmplPath);\n\n            return loadPromise.then(renderer.parseTemplate);\n        },\n\n        /**\n         * Parses provided string as html content\n         * and returns an array of DOM elements.\n         *\n         * @param {String} html - String to be processed.\n         * @returns {Array}\n         */\n        parseTemplate: function (html) {\n            var fragment = document.createDocumentFragment();\n\n            $(fragment).append(html);\n\n            return renderer.normalize(fragment);\n        },\n\n        /**\n         * Processes custom attributes and nodes of provided DOM element.\n         *\n         * @param {HTMLElement} content - Element to be processed.\n         * @returns {Array} An array of content's child nodes.\n         */\n        normalize: function (content) {\n            globals.forEach(function (handler) {\n                handler(content);\n            });\n\n            return _.toArray(content.childNodes);\n        },\n\n        /**\n         * Adds new global content handler.\n         *\n         * @param {Function} handler - Function which will be invoked for\n         *      an every content passed to 'normalize' method.\n         * @returns {Renderer} Chainable.\n         */\n        addGlobal: function (handler) {\n            if (!_.contains(globals, handler)) {\n                globals.push(handler);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes specified global content handler.\n         *\n         * @param {Function} handler - Handler to be removed.\n         * @returns {Renderer} Chainable.\n         */\n        removeGlobal: function (handler) {\n            var index = globals.indexOf(handler);\n\n            if (~index) {\n                globals.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds new custom attribute handler.\n         *\n         * @param {String} id - Attribute identifier.\n         * @param {(Object|Function)} [config={}]\n         * @returns {Renderer} Chainable.\n         */\n        addAttribute: function (id, config) {\n            var data = {\n                name: id,\n                binding: id,\n                handler: renderer.handlers.attribute\n            };\n\n            if (_.isFunction(config)) {\n                data.handler = config;\n            } else if (_.isObject(config)) {\n                _.extend(data, config);\n            }\n\n            data.id = id;\n            attributes[id] = data;\n\n            return this;\n        },\n\n        /**\n         * Removes specified attribute handler.\n         *\n         * @param {String} id - Attribute identifier.\n         * @returns {Renderer} Chainable.\n         */\n        removeAttribute: function (id) {\n            delete attributes[id];\n\n            return this;\n        },\n\n        /**\n         * Adds new custom node handler.\n         *\n         * @param {String} id - Node identifier.\n         * @param {(Object|Function)} [config={}]\n         * @returns {Renderer} Chainable.\n         */\n        addNode: function (id, config) {\n            var data = {\n                name: id,\n                binding: id,\n                handler: renderer.handlers.node\n            };\n\n            if (_.isFunction(config)) {\n                data.handler = config;\n            } else if (_.isObject(config)) {\n                _.extend(data, config);\n            }\n\n            data.id = id;\n            elements[id] = data;\n\n            return this;\n        },\n\n        /**\n         * Removes specified custom node handler.\n         *\n         * @param {String} id - Node identifier.\n         * @returns {Renderer} Chainable.\n         */\n        removeNode: function (id) {\n            delete elements[id];\n\n            return this;\n        },\n\n        /**\n         * Checks if provided DOM element is a custom node.\n         *\n         * @param {HTMLElement} node - Node to be checked.\n         * @returns {Boolean}\n         */\n        isCustomNode: function (node) {\n            return _.some(elements, function (elem) {\n                return elem.name.toUpperCase() === node.tagName;\n            });\n        },\n\n        /**\n         * Processes custom attributes of a content's child nodes.\n         *\n         * @param {HTMLElement} content - DOM element to be processed.\n         */\n        processAttributes: function (content) {\n            var repeat;\n\n            repeat = _.some(attributes, function (attr) {\n                var attrName = attr.name,\n                    nodes    = content.querySelectorAll('[' + attrName + ']'),\n                    handler  = attr.handler;\n\n                return _.toArray(nodes).some(function (node) {\n                    var data = node.getAttribute(attrName);\n\n                    return handler(node, data, attr) === true;\n                });\n            });\n\n            if (repeat) {\n                renderer.processAttributes(content);\n            }\n        },\n\n        /**\n         * Processes custom nodes of a provided content.\n         *\n         * @param {HTMLElement} content - DOM element to be processed.\n         */\n        processNodes: function (content) {\n            var repeat;\n\n            repeat = _.some(elements, function (element) {\n                var nodes   = content.querySelectorAll(element.name),\n                    handler = element.handler;\n\n                return _.toArray(nodes).some(function (node) {\n                    var data = node.getAttribute('args');\n\n                    return handler(node, data, element) === true;\n                });\n            });\n\n            if (repeat) {\n                renderer.processNodes(content);\n            }\n        },\n\n        /**\n         * Wraps provided string in curly braces if it's necessary.\n         *\n         * @param {String} args - String to be wrapped.\n         * @returns {String} Wrapped string.\n         */\n        wrapArgs: function (args) {\n            if (~args.indexOf('\\\\:')) {\n                args = args.replace(colonReg, ':');\n            } else if (~args.indexOf(':') && !~args.indexOf('}')) {\n                args = '{' + args + '}';\n            }\n\n            return args;\n        },\n\n        /**\n         * Wraps child nodes of provided DOM element\n         * with knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node whose children should be wrapped.\n         * @param {String} binding - Name of the binding for the opener comment tag.\n         * @param {String} data - Data associated with a binding.\n         *\n         * @example\n         *      <div id=\"example\"><span/></div>\n         *      wrapChildren(document.getElementById('example'), 'foreach', 'data');\n         *      =>\n         *      <div id=\"example\">\n         *      <!-- ko foreach: data -->\n         *          <span></span>\n         *      <!-- /ko -->\n         *      </div>\n         */\n        wrapChildren: function (node, binding, data) {\n            var tag = this.createComment(binding, data),\n                $node = $(node);\n\n            $node.prepend(tag.open);\n            $node.append(tag.close);\n        },\n\n        /**\n         * Wraps specified node with knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node to be wrapped.\n         * @param {String} binding - Name of the binding for the opener comment tag.\n         * @param {String} data - Data associated with a binding.\n         *\n         * @example\n         *      <div id=\"example\"></div>\n         *      wrapNode(document.getElementById('example'), 'foreach', 'data');\n         *      =>\n         *      <!-- ko foreach: data -->\n         *          <div id=\"example\"></div>\n         *      <!-- /ko -->\n         */\n        wrapNode: function (node, binding, data) {\n            var tag = this.createComment(binding, data),\n                $node = $(node);\n\n            $node.before(tag.open);\n            $node.after(tag.close);\n        },\n\n        /**\n         * Creates knockouts' comment tag for the provided binding.\n         *\n         * @param {String} binding - Name of the binding.\n         * @param {String} data - Data associated with a binding.\n         * @returns {Object} Object with an open and close comment elements.\n         */\n        createComment: function (binding, data) {\n            return {\n                open: document.createComment(' ko ' + binding + ': ' + data + ' '),\n                close: document.createComment(' /ko ')\n            };\n        }\n    };\n\n    renderer.handlers = {\n\n        /**\n         * Basic node handler. Replaces custom nodes\n         * with a corresponding knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node to be processed.\n         * @param {String} data\n         * @param {Object} element\n         * @returns {Boolean} True\n         *\n         * @example Sample syntaxes conversions.\n         *      <with args=\"model\">\n         *          <span/>\n         *      </with>\n         *      =>\n         *      <!-- ko with: model-->\n         *          <span/>\n         *      <!-- /ko -->\n         */\n        node: function (node, data, element) {\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, element.binding, data);\n            $(node).replaceWith(node.childNodes);\n\n            return true;\n        },\n\n        /**\n         * Base attribute handler. Replaces custom attributes with\n         * a corresponding knockouts' data binding.\n         *\n         * @param {HTMLElement} node - Node to be processed.\n         * @param {String} data - Data associated with a binding.\n         * @param {Object} attr - Attribute definition.\n         *\n         * @example Sample syntaxes conversions.\n         *      <div text=\"label\"></div>\n         *      =>\n         *      <div data-bind=\"text: label\"></div>\n         */\n        attribute: function (node, data, attr) {\n            data = renderer.wrapArgs(data);\n\n            renderer.bindings.add(node, attr.binding, data);\n            node.removeAttribute(attr.name);\n        },\n\n        /**\n         * Wraps provided node with a knockouts' comment tag.\n         *\n         * @param {HTMLElement} node - Node that will be wrapped.\n         * @param {String} data - Data associated with a binding.\n         * @param {Object} attr - Attribute definition.\n         *\n         * @example\n         *      <div outereach=\"data\" class=\"test\"></div>\n         *      =>\n         *      <!-- ko foreach: data -->\n         *          <div class=\"test\"></div>\n         *      <!-- /ko -->\n         */\n        wrapAttribute: function (node, data, attr) {\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, attr.binding, data);\n            node.removeAttribute(attr.name);\n        }\n    };\n\n    renderer.bindings = {\n\n        /**\n         * Appends binding string to the current\n         * 'data-bind' attribute of provided node.\n         *\n         * @param {HTMLElement} node - DOM element whose 'data-bind' attribute will be extended.\n         * @param {String} name - Name of a binding.\n         * @param {String} data - Data associated with the binding.\n         */\n        add: function (node, name, data) {\n            var bindings = this.get(node);\n\n            if (bindings) {\n                bindings += ', ';\n            }\n\n            bindings += name;\n\n            if (data) {\n                bindings += ': ' + data;\n            }\n\n            this.set(node, bindings);\n        },\n\n        /**\n         * Extracts value of a 'data-bind' attribute from provided node.\n         *\n         * @param {HTMLElement} node - Node whose attribute to be extracted.\n         * @returns {String}\n         */\n        get: function (node) {\n            return node.getAttribute('data-bind') || '';\n        },\n\n        /**\n         * Sets 'data-bind' attribute of the specified node\n         * to the provided value.\n         *\n         * @param {HTMLElement} node - Node whose attribute will be altered.\n         * @param {String} bindings - New value of 'data-bind' attribute.\n         */\n        set: function (node, bindings) {\n            node.setAttribute('data-bind', bindings);\n        }\n    };\n\n    renderer\n        .addGlobal(renderer.processAttributes)\n        .addGlobal(renderer.processNodes);\n\n    /**\n     * Collection of default binding conversions.\n     */\n    preset = {\n        nodes: _.object([\n            'if',\n            'text',\n            'with',\n            'scope',\n            'ifnot',\n            'foreach',\n            'component'\n        ], Array.prototype),\n        attributes: _.object([\n            'css',\n            'attr',\n            'html',\n            'with',\n            'text',\n            'click',\n            'event',\n            'submit',\n            'enable',\n            'disable',\n            'options',\n            'visible',\n            'template',\n            'hasFocus',\n            'textInput',\n            'component',\n            'uniqueName',\n            'optionsText',\n            'optionsValue',\n            'checkedValue',\n            'selectedOptions'\n        ], Array.prototype)\n    };\n\n    _.extend(preset.attributes, {\n        if: renderer.handlers.wrapAttribute,\n        ifnot: renderer.handlers.wrapAttribute,\n        innerif: {\n            binding: 'if'\n        },\n        innerifnot: {\n            binding: 'ifnot'\n        },\n        outereach: {\n            binding: 'foreach',\n            handler: renderer.handlers.wrapAttribute\n        },\n        foreach: {\n            name: 'each'\n        },\n        value: {\n            name: 'ko-value'\n        },\n        style: {\n            name: 'ko-style'\n        },\n        checked: {\n            name: 'ko-checked'\n        },\n        disabled: {\n            name: 'ko-disabled',\n            binding: 'disable'\n        },\n        focused: {\n            name: 'ko-focused',\n            binding: 'hasFocus'\n        },\n\n        /**\n         * Custom 'render' attrobute handler function. Wraps child elements\n         * of a node with knockout's 'ko template:' comment tag.\n         *\n         * @param {HTMLElement} node - Element to be processed.\n         * @param {String} data - Data specified in 'render' attribute of a node.\n         */\n        render: function (node, data) {\n            data = data || 'getTemplate()';\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapChildren(node, 'template', data);\n            node.removeAttribute('render');\n        }\n    });\n\n    _.extend(preset.nodes, {\n        foreach: {\n            name: 'each'\n        },\n\n        /**\n         * Custom 'render' node handler function.\n         * Replaces node with knockout's 'ko template:' comment tag.\n         *\n         * @param {HTMLElement} node - Element to be processed.\n         * @param {String} data - Data specified in 'args' attribute of a node.\n         */\n        render: function (node, data) {\n            data = data || 'getTemplate()';\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, 'template', data);\n            $(node).replaceWith(node.childNodes);\n        }\n    });\n\n    _.each(preset.attributes, function (data, id) {\n        renderer.addAttribute(id, data);\n    });\n\n    _.each(preset.nodes, function (data, id) {\n        renderer.addNode(id, data);\n    });\n\n    return renderer;\n});\n","Magento_Ui/js/lib/registry/registry.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'es6-collections'\n], function ($, _) {\n    'use strict';\n\n    var privateData = new WeakMap();\n\n    /**\n     * Extarcts private items storage associated\n     * with a provided registry instance.\n     *\n     * @param {Object} container\n     * @returns {Object}\n     */\n    function getItems(container) {\n        return privateData.get(container).items;\n    }\n\n    /**\n     * Extracts private requests array associated\n     * with a provided registry instance.\n     *\n     * @param {Object} container\n     * @returns {Array}\n     */\n    function getRequests(container) {\n        return privateData.get(container).requests;\n    }\n\n    /**\n     * Wrapper function used for convinient access to the elements.\n     * See 'async' method for examples of usage and comparison\n     * with a regular 'get' method.\n     *\n     * @param {(String|Object|Function)} name - Key of the requested element.\n     * @param {Registry} registry - Instance of a registry\n     *      where to search for the element.\n     * @param {(Function|String)} [method] - Optional callback function\n     *      or a name of the elements' method which\n     *      will be invoked when element is available in registry.\n     * @returns {*}\n     */\n    function async(name, registry, method) {\n        var args = _.toArray(arguments).slice(3);\n\n        if (_.isString(method)) {\n            registry.get(name, function (component) {\n                component[method].apply(component, args);\n            });\n        } else if (_.isFunction(method)) {\n            registry.get(name, method);\n        } else if (!args.length) {\n            return registry.get(name);\n        }\n    }\n\n    /**\n     * Checks that every property of the query object\n     * is present and equal to the corresponding\n     * property in target object.\n     * Note that non-strict comparison is used.\n     *\n     * @param {Object} query - Query object.\n     * @param {Object} target - Target object.\n     * @returns {Boolean}\n     */\n    function compare(query, target) {\n        var matches = true,\n            index,\n            keys,\n            key;\n\n        if (!_.isObject(query) || !_.isObject(target)) {\n            return false;\n        }\n\n        keys = Object.getOwnPropertyNames(query);\n        index = keys.length;\n\n        while (matches && index--) {\n            key = keys[index];\n\n            /* eslint-disable eqeqeq */\n            if (target[key] != query[key]) {\n                matches = false;\n            }\n\n            /* eslint-enable eqeqeq */\n        }\n\n        return matches;\n    }\n\n    /**\n     * Explodes incoming string into object if\n     * string is defined as a set of key = value pairs.\n     *\n     * @param {(String|*)} query - String to be processed.\n     * @returns {Object|*} Either created object or an unmodified incoming\n     *      value if conversion was not possible.\n     * @example Sample conversions.\n     *      'key = value, key2 = value2'\n     *      => {key: 'value', key2: 'value2'}\n     */\n    function explode(query) {\n        var result = {},\n            index,\n            data;\n\n        if (typeof query !== 'string' || !~query.indexOf('=')) {\n            return query;\n        }\n\n        query = query.split(',');\n        index = query.length;\n\n        while (index--) {\n            data = query[index].split('=');\n\n            result[data[0].trim()] = data[1].trim();\n        }\n\n        return result;\n    }\n\n    /**\n     * Extracts items from the provided data object\n     * which matches specified search criteria.\n     *\n     * @param {Object} data - Data object where to perform a lookup.\n     * @param {(String|Object|Function)} query - Seach criteria.\n     * @param {Boolean} findAll - Flag that defines whether to\n     *      search for all applicable items or to stop on a first found entry.\n     * @returns {Array|Object|*}\n     */\n    function find(data, query, findAll) {\n        var iterator,\n            item;\n\n        query = explode(query);\n\n        if (typeof query === 'string') {\n            item = data[query];\n\n            if (findAll) {\n                return item ? [item] : [];\n            }\n\n            return item;\n        }\n\n        iterator = !_.isFunction(query) ?\n            compare.bind(null, query) :\n            query;\n\n        return findAll ?\n            _.filter(data, iterator) :\n            _.find(data, iterator);\n    }\n\n    /**\n     * @constructor\n     */\n    function Registry() {\n        var data = {\n            items: {},\n            requests: []\n        };\n\n        this._updateRequests = _.debounce(this._updateRequests.bind(this), 10);\n        privateData.set(this, data);\n    }\n\n    Registry.prototype = {\n        constructor: Registry,\n\n        /**\n         * Retrieves item from registry which matches specified search criteria.\n         *\n         * @param {(Object|String|Function|Array)} query - Search condition (see examples).\n         * @param {Function} [callback] - Callback that will be invoked when\n         *      all of the requested items are available.\n         * @returns {*}\n         *\n         * @example Requesting item by it's name.\n         *      var obj = {index: 'test', sample: true};\n         *\n         *      registry.set('first', obj);\n         *      registry.get('first') === obj;\n         *      => true\n         *\n         * @example Requesting item with a specific properties.\n         *      registry.get('sample = 1, index = test') === obj;\n         *      => true\n         *      registry.get('sample = 0, index = foo') === obj;\n         *      => false\n         *\n         * @example Declaring search criteria as an object.\n         *      registry.get({sample: true}) === obj;\n         *      => true;\n         *\n         * @example Providing custom search handler.\n         *      registry.get(function (item) { return item.sample === true; }) === obj;\n         *      => true\n         *\n         * @example Sample asynchronous request declaration.\n         *      registry.get('index = test', function (item) {});\n         *\n         * @example Requesting multiple elements.\n         *      registry.set('second', {index: 'test2'});\n         *      registry.get(['first', 'second'], function (first, second) {});\n         */\n        get: function (query, callback) {\n            if (typeof callback !== 'function') {\n                return find(getItems(this), query);\n            }\n\n            this._addRequest(query, callback);\n        },\n\n        /**\n         * Sets provided item to the registry.\n         *\n         * @param {String} id - Item's identifier.\n         * @param {*} item - Item's data.\n         * returns {Registry} Chainable.\n         */\n        set: function (id, item) {\n            getItems(this)[id] = item;\n\n            this._updateRequests();\n\n            return this;\n        },\n\n        /**\n         * Removes specified item from registry.\n         * Note that search query is not applicable.\n         *\n         * @param {String} id - Item's identifier.\n         * @returns {Registry} Chainable.\n         */\n        remove: function (id) {\n            delete getItems(this)[id];\n\n            return this;\n        },\n\n        /**\n         * Retrieves a collection of elements that match\n         * provided search criteria.\n         *\n         * @param {(Object|String|Function)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {Array} Found elements.\n         */\n        filter: function (query) {\n            return find(getItems(this), query, true);\n        },\n\n        /**\n         * Checks that at least one element in collection\n         * matches provided search criteria.\n         *\n         * @param {(Object|String|Function)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {Boolean}\n         */\n        has: function (query) {\n            return !!this.get(query);\n        },\n\n        /**\n         * Checks that registry contains a provided item.\n         *\n         * @param {*} item - Item to be checked.\n         * @returns {Boolean}\n         */\n        contains: function (item) {\n            return _.contains(getItems(this), item);\n        },\n\n        /**\n         * Extracts identifier of an item if it's present in registry.\n         *\n         * @param {*} item - Item whose identifier will be extracted.\n         * @returns {String|Undefined}\n         */\n        indexOf: function (item) {\n            return _.findKey(getItems(this), function (elem) {\n                return item === elem;\n            });\n        },\n\n        /**\n         * Same as a 'get' method except that it returns\n         * a promise object instead of invoking provided callback.\n         *\n         * @param {(String|Function|Object|Array)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {jQueryPromise}\n         */\n        promise: function (query) {\n            var defer    = $.Deferred(),\n                callback = defer.resolve.bind(defer);\n\n            this.get(query, callback);\n\n            return defer.promise();\n        },\n\n        /**\n         * Creates a wrapper function over the provided search query\n         * in order to provide somehow more convinient access to the\n         * registrie's items.\n         *\n         * @param {(String|Object|Function)} query - Search criteria.\n         *      See 'get' method for the syntax examples.\n         * @returns {Function}\n         *\n         * @example Comparison with a 'get' method on retrieving items.\n         *      var module = registry.async('name');\n         *\n         *      module();\n         *      => registry.get('name');\n         *\n         * @example Asynchronous request.\n         *      module(function (component) {});\n         *      => registry.get('name', function (component) {});\n         *\n         * @example Requesting item and invoking it's method with specified parameters.\n         *      module('trigger', true);\n         *      => registry.get('name', function (component) {\n         *          component.trigger(true);\n         *      });\n         */\n        async: function (query) {\n            return async.bind(null, query, this);\n        },\n\n        /**\n         * Creates new instance of a Registry.\n         *\n         * @returns {Registry} New instance.\n         */\n        create: function () {\n            return new Registry;\n        },\n\n        /**\n         * Adds new request to the queue or resolves it immediately\n         * if all of the required items are available.\n         *\n         * @private\n         * @param {(Object|String|Function|Array)} queries - Search criteria.\n         *      See 'get' method for the syntax examples.\n         * @param {Function} callback - Callback that will be invoked when\n         *      all of the requested items are available.\n         * @returns {Registry}\n         */\n        _addRequest: function (queries, callback) {\n            var request;\n\n            if (!Array.isArray(queries)) {\n                queries = queries ? [queries] : [];\n            }\n\n            request = {\n                queries: queries.map(explode),\n                callback: callback\n            };\n\n            this._canResolve(request) ?\n                this._resolveRequest(request) :\n                getRequests(this).push(request);\n\n            return this;\n        },\n\n        /**\n         * Updates requests list resolving applicable items.\n         *\n         * @private\n         * @returns {Registry} Chainable.\n         */\n        _updateRequests: function () {\n            getRequests(this)\n                .filter(this._canResolve, this)\n                .forEach(this._resolveRequest, this);\n\n            return this;\n        },\n\n        /**\n         * Resolves provided request invoking it's callback\n         * with items specified in query parameters.\n         *\n         * @private\n         * @param {Object} request - Request object.\n         * @returns {Registry} Chainable.\n         */\n        _resolveRequest: function (request) {\n            var requests = getRequests(this),\n                items    = request.queries.map(this.get, this),\n                index    = requests.indexOf(request);\n\n            request.callback.apply(null, items);\n\n            if (~index) {\n                requests.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if provided request can be resolved.\n         *\n         * @private\n         * @param {Object} request - Request object.\n         * @returns {Boolean}\n         */\n        _canResolve: function (request) {\n            var queries = request.queries;\n\n            return queries.every(this.has, this);\n        }\n    };\n\n    return new Registry;\n});\n","Magento_Ui/js/lib/validation/rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    './utils',\n    'moment',\n    'jquery/validate',\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, utils, moment) {\n    'use strict';\n\n    /**\n     * validate credit card number using mod10\n     * @param s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = \"0123456789\",\n            w = \"\", i, j, k, m, c, a, x;\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n            if (v.indexOf(x, 0) != -1)\n                w += x;\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n        return (c % 10 === 0);\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    return _.mapObject({\n        \"min_text_length\": [\n            function (value, params) {\n                return value.length == 0 || value.length >= +params;\n            },\n            $.mage.__('Please enter more or equal than {0} symbols.')\n        ],\n        \"max_text_length\": [\n            function (value, params) {\n                return value.length <= +params;\n            },\n            $.mage.__('Please enter less or equal than {0} symbols.')\n        ],\n        \"max-words\": [\n            function(value, params) {\n                return utils.stripHtml(value).match(/\\b\\w+\\b/g).length < params;\n            },\n            $.mage.__('Please enter {0} words or less.')\n        ],\n        \"min-words\": [\n            function(value, params) {\n                return utils.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            $.mage.__('Please enter at least {0} words.')\n        ],\n        \"range-words\": [\n            function(value, params) {\n                return utils.stripHtml(value).match(/\\b\\w+\\b/g).length >= params[0] &&\n                    value.match(/bw+b/g).length < params[1];\n            },\n            $.mage.__('Please enter between {0} and {1} words.')\n        ],\n        \"letters-with-basic-punc\": [\n            function(value) {\n                return /^[a-z\\-.,()\\u0027\\u0022\\s]+$/i.test(value);\n            },\n            $.mage.__('Letters or punctuation only please')\n        ],\n        \"alphanumeric\": [\n            function(value) {\n                return /^\\w+$/i.test(value);\n            },\n            $.mage.__('Letters, numbers, spaces or underscores only please')\n        ],\n        \"letters-only\": [\n            function(value) {\n                return /^[a-z]+$/i.test(value);\n            },\n            $.mage.__('Letters only please')\n        ],\n        \"no-whitespace\": [\n            function(value) {\n                return /^\\S+$/i.test(value);\n            },\n            $.mage.__('No white space please')\n        ],\n        \"zip-range\": [\n            function(value) {\n                return /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            $.mage.__('Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx')\n        ],\n        \"integer\": [\n            function(value) {\n                return /^-?\\d+$/.test(value);\n            },\n            $.mage.__('A positive or negative non-decimal number please')\n        ],\n        \"vinUS\": [\n            function(value) {\n                if (value.length !== 17) {\n                    return false;\n                }\n                var i, n, d, f, cd, cdv;\n                var LL = [\"A\", \"B\", \"C\", \"D\", \"E\", \"F\", \"G\", \"H\", \"J\", \"K\", \"L\", \"M\", \"N\", \"P\", \"R\", \"S\", \"T\", \"U\", \"V\", \"W\", \"X\", \"Y\", \"Z\"];\n                var VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9];\n                var FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2];\n                var rs = 0;\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = value.slice(i, i + 1);\n                    if (i === 8) {\n                        cdv = d;\n                    }\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {\n                            if (d.toUpperCase() === LL[n]) {\n                                d = VL[n];\n                                d *= f;\n                                if (isNaN(cdv) && n === 8) {\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n                cd = rs % 11;\n                if (cd === 10) {\n                    cd = \"X\";\n                }\n                if (cd === cdv) {\n                    return true;\n                }\n                return false;\n            },\n            $.mage.__('The specified vehicle identification number (VIN) is invalid.')\n        ],\n        \"dateITA\": [\n            function(value) {\n                var check = false;\n                var re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/;\n                if (re.test(value)) {\n                    var adata = value.split('/');\n                    var gg = parseInt(adata[0], 10);\n                    var mm = parseInt(adata[1], 10);\n                    var aaaa = parseInt(adata[2], 10);\n                    var xdata = new Date(aaaa, mm - 1, gg);\n                    if ((xdata.getFullYear() === aaaa) &&\n                        (xdata.getMonth() === mm - 1) && (xdata.getDate() === gg )) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n                return check;\n            },\n            $.mage.__('Please enter a correct date')\n        ],\n        \"dateNL\": [\n            function(value) {\n                return /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            $.mage.__('Vul hier een geldige datum in.')\n        ],\n        \"time\": [\n            function(value) {\n                return /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 and 23:59')\n        ],\n        \"time12h\": [\n            function(value) {\n                return /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\ [AP]M))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 am and 12:00 pm')\n        ],\n        \"phoneUS\": [\n            function(value) {\n                value = value.replace(/\\s+/g, \"\");\n                return value.length > 9 && value.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        \"phoneUK\": [\n            function(value) {\n                return value.length > 9 && value.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        \"mobileUK\": [\n            function(value) {\n                return value.length > 9 && value.match(/^((0|\\+44)7(5|6|7|8|9){1}\\d{2}\\s?\\d{6})$/);\n            },\n            $.mage.__('Please specify a valid mobile number')\n        ],\n        \"stripped-min-length\": [\n            function(value, param) {\n                return $(value).text().length >= param;\n            },\n            $.mage.__('Please enter at least {0} characters')\n        ],\n        \"email2\": [\n            function(value) {\n                return /^((([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\u0022)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\u0022)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);\n            },\n            $.validator.messages.email\n        ],\n        \"url2\": [\n            function(value) {\n                return /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);\n            },\n            $.validator.messages.url\n        ],\n        \"credit-card-types\": [\n            function(value, param) {\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, \"\");\n\n                var validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        \"ipv4\": [\n            function(value) {\n                return /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);\n            },\n            $.mage.__('Please enter a valid IP v4 address.')\n        ],\n        \"ipv6\": [\n            function(value) {\n                return /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid IP v6 address.')\n        ],\n        \"pattern\": [\n            function(value, param) {\n                return param.test(value);\n            },\n            $.mage.__('Invalid format.')\n        ],\n        \"validate-no-html-tags\": [\n            function(value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            $.mage.__('HTML tags are not allowed.')\n        ],\n        \"validate-select\": [\n            function(value) {\n                return ((value !== \"none\") && (value != null) && (value.length !== 0));\n            },\n            $.mage.__('Please select an option.')\n        ],\n        \"validate-no-empty\": [\n            function(value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('Empty Value.')\n        ],\n        \"validate-alphanum-with-spaces\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9 ]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.')\n        ],\n        \"validate-data\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')\n        ],\n        \"validate-street\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.')\n        ],\n        \"validate-phoneStrict\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        \"validate-phoneLax\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        \"validate-fax\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid fax number (Ex: 123-456-7890).')\n        ],\n        \"validate-email\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(value);\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        \"validate-emailSender\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[\\S ]+$/.test(value);\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        \"validate-password\": [\n            function(value) {\n                if (value == null) {\n                    return false;\n                }\n                /*strip leading and trailing spaces*/\n                var pass = $.trim(value);\n                if (!pass.length) {\n                    return true;\n                }\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        \"validate-admin-password\": [\n            function(value) {\n                if (value == null) {\n                    return false;\n                }\n                var pass = $.trim(value);\n                /*strip leading and trailing spaces*/\n                if (0 === pass.length) {\n                    return true;\n                }\n                if (!(/[a-z]/i.test(value)) || !(/[0-9]/.test(value))) {\n                    return false;\n                }\n                if (pass.length < 7) {\n                    return false;\n                }\n                return true;\n            },\n            $.mage.__('Please enter 7 or more characters, using both numeric and alphabetic.')\n        ],\n        \"validate-customer-password\": [\n            function (v, elm) {\n                var validator = this,\n                    length = 0,\n                    counter = 0;\n                var passwordMinLength = $(elm).data('password-min-length');\n                var passwordMinCharacterSets = $(elm).data('password-min-character-sets');\n                var pass = $.trim(v);\n                var result = pass.length >= passwordMinLength;\n                if (result == false) {\n                    validator.passwordErrorMessage = $.mage.__(\n                        \"Minimum length of this field must be equal or greater than %1 symbols.\" +\n                        \" Leading and trailing spaces will be ignored.\"\n                    ).replace('%1', passwordMinLength);\n                    return result;\n                }\n                if (pass.match(/\\d+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[a-z]+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[A-Z]+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter ++;\n                }\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__(\n                        \"Minimum of different classes of characters in password is %1.\" +\n                        \" Classes of characters: Lower Case, Upper Case, Digits, Special Characters.\"\n                    ).replace('%1', passwordMinCharacterSets);\n                }\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        \"validate-url\": [\n            function(value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = (value || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(value);\n\n            },\n            $.mage.__('Please enter a valid URL. Protocol is required (http://, https:// or ftp://).')\n        ],\n        \"validate-clean-url\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value);\n\n            },\n            $.mage.__('Please enter a valid URL. For example http://www.example.com or www.example.com.')\n        ],\n        \"validate-xml-identifier\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(value);\n\n            },\n            $.mage.__('Please enter a valid XML-identifier (Ex: something_1, block5, id-4).')\n        ],\n        \"validate-ssn\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(value);\n\n            },\n            $.mage.__('Please enter a valid social security number (Ex: 123-45-6789).')\n        ],\n        \"validate-zip-us\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(value);\n\n            },\n            $.mage.__('Please enter a valid zip code (Ex: 90602 or 90602-1234).')\n        ],\n        \"validate-date-au\": [\n            function(value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                var regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/;\n                if (utils.isEmpty(value) || !regex.test(value)) {\n                    return false;\n                }\n                var d = new Date(value.replace(regex, '$2/$1/$3'));\n                return parseInt(RegExp.$2, 10) === (1 + d.getMonth()) &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            $.mage.__('Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.')\n        ],\n        \"validate-currency-dollar\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(value);\n\n            },\n            $.mage.__('Please enter a valid $ amount. For example $100.00.')\n        ],\n        \"validate-not-negative-number\": [\n            function(value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = utils.parseNumber(value);\n                return !isNaN(value) && value >= 0;\n\n            },\n            $.mage.__('Please enter a number 0 or greater in this field.')\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        \"validate-zero-or-greater\": [\n            function(value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = utils.parseNumber(value);\n                return !isNaN(value) && value >= 0;\n\n            },\n            $.mage.__('Please enter a number 0 or greater in this field.')\n        ],\n        \"validate-greater-than-zero\": [\n            function(value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = utils.parseNumber(value);\n                return !isNaN(value) && value > 0;\n            },\n            $.mage.__('Please enter a number greater than 0 in this field.')\n        ],\n        \"validate-css-length\": [\n            function(value) {\n                if (value !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(value);\n                }\n                return true;\n            },\n            $.mage.__('Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).')\n        ],\n        /** @description Additional methods */\n        \"validate-number\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || (!isNaN(utils.parseNumber(value)) && /^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(value));\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        \"validate-number-range\": [\n            function(value, param) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                var numValue = utils.parseNumber(value);\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                var dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/,\n                    result = true,\n                    range, m;\n\n                range = param;\n                if (range) {\n                    m = dataAttrRange.exec(range);\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        \"validate-digits\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || !/[^\\d]/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        \"validate-digits-range\": [\n            function(value, param) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                var numValue = utils.parseNumber(value);\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                var dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/,\n                    result = true,\n                    range, m;\n                range = param;\n                if (range) {\n                    m = dataAttrRange.exec(range);\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-range': [\n            function(value) {\n                var minValue, maxValue;\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](value)) {\n                    minValue = maxValue = utils.parseNumber(value);\n                } else {\n                    var ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(value);\n\n                    if (ranges) {\n                        minValue = utils.parseNumber(ranges[1]);\n                        maxValue = utils.parseNumber(ranges[2]);\n                        if (minValue > maxValue) {\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        \"validate-alpha\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z]+$/.test(value);\n            },\n            $.mage.__('Please use letters only (a-z or A-Z) in this field.')\n        ],\n        \"validate-code\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z]+[a-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')\n        ],\n        \"validate-alphanum\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.')\n        ],\n        \"validate-date\": [\n            function(value) {\n                var test = new Date(value);\n                return utils.isEmptyNoTrim(value) || !isNaN(test);\n            },$.mage.__('Please enter a valid date.')\n\n        ],\n        \"validate-identifier\": [\n            function(value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(value);\n            },\n            $.mage.__('Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").')\n        ],\n        \"validate-zip-international\": [\n            /*function(v) {\n             // @TODO: Cleanup\n             return Validation.get('IsEmpty').test(v) || /(^[A-z0-9]{2,10}([\\s]{0,1}|[\\-]{0,1})[A-z0-9]{2,10}$)/.test(v);\n             }*/\n            function() {\n                return true;\n            },\n            $.mage.__('Please enter a valid zip code.')\n        ],\n        \"validate-state\": [\n            function(value) {\n                return (value !== 0 || value === '');\n            },\n            $.mage.__('Please select State/Province.')\n        ],\n        \"less-than-equals-to\": [\n            function(value, params) {\n                if ($.isNumeric(params) && $.isNumeric(value)) {\n                    return parseFloat(value) <= parseFloat(params);\n                }\n                return true;\n            },\n            $.mage.__('Please enter a value less than or equal to {0}.')\n        ],\n        \"greater-than-equals-to\": [\n            function(value, params) {\n                if ($.isNumeric(params) && $.isNumeric(value)) {\n                    return parseFloat(value) >= parseFloat(params);\n                }\n                return true;\n            },\n            $.mage.__('Please enter a value greater than or equal to {0}.')\n        ],\n        \"validate-emails\": [\n            function(value) {\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n                var valid_regexp = /^[a-z0-9\\._-]{1,30}@([a-z0-9_-]{1,30}\\.){1,5}[a-z]{2,4}$/i,\n                    emails = value.split(/[\\s\\n\\,]+/g);\n                for (var i = 0; i < emails.length; i++) {\n                    if (!valid_regexp.test(emails[i].strip())) {\n                        return false;\n                    }\n                }\n                return true;\n            }, \"Please enter valid email addresses, separated by commas. For example, johndoe@domain.com, johnsmith@domain.com.\"\n        ],\n        \"validate-cc-number\": [\n            /**\n             * Validate credit card number based on mod 10\n             * @param value - credit card number\n             * @return {boolean}\n             */\n                function(value) {\n                if (value) {\n                    return validateCreditCard(value);\n                }\n                return false;\n            }, $.mage.__('Please enter a valid credit card number.')\n        ],\n        \"validate-cc-ukss\": [\n            /**\n             * Validate Switch/Solo/Maestro issue number and start date is filled\n             * @param value - input field value\n             * @return {*}\n             */\n                function(value) {\n                return value;\n            }, $.mage.__('Please enter issue number or start date for switch/solo card type.')\n        ],\n        'required-entry': [\n            function(value) {\n                return !utils.isEmpty(value);\n            }, $.mage.__('This is a required field.')\n        ],\n        'checked': [\n            function(value) {\n                return value;\n            }, $.mage.__('This is a required field.')\n        ],\n        'not-negative-amount': [\n            function(value) {\n                if (value.length)\n                    return (/^\\s*\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n                else\n                    return true;\n            },\n            $.mage.__('Please enter positive number in this field.')\n        ],\n        'validate-per-page-value-list': [\n            function(value) {\n                var isValid = !utils.isEmpty(value);\n                var values = value.split(',');\n                for (var i = 0; i < values.length; i++) {\n                    if (!/^[0-9]+$/.test(values[i])) {\n                        isValid = false;\n                    }\n                }\n                return isValid;\n            },\n            $.mage.__('Please enter a valid value, ex: 10,20,30')\n        ],\n        'validate-new-password': [\n            function(value) {\n\n                if ($.validator.methods['validate-password'] &&\n                    !$.validator.methods['validate-password'](value)) {\n                    return false;\n                }\n                if (utils.isEmpty(value) && value !== '') {\n                    return false;\n                }\n                return true;\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-item-quantity': [\n            function (value, params) {\n                // obtain values for validation\n                var qty = utils.parseNumber(value);\n\n                // validate quantity\n                var isMinAllowedValid = typeof params.minAllowed === 'undefined' || (qty >= utils.parseNumber(params.minAllowed));\n                var isMaxAllowedValid = typeof params.maxAllowed === 'undefined'  || (qty <= utils.parseNumber(params.maxAllowed));\n                var isQtyIncrementsValid = typeof params.qtyIncrements === 'undefined'  || (qty % utils.parseNumber(params.qtyIncrements) === 0);\n\n                return isMaxAllowedValid && isMinAllowedValid && isQtyIncrementsValid && qty > 0;\n            },\n            ''\n        ],\n        'equalTo': [\n            function (value, param) {\n                return value === $(param).val();\n            },\n            $.validator.messages.equalTo\n        ],\n        'validate-file-type': [\n            function (name, types) {\n                var extension = name.split('.').pop().toLowerCase();\n\n                if (types && typeof types === 'string') {\n                    types = types.split(' ');\n                }\n\n                return !types || !types.length || ~types.indexOf(extension);\n            },\n            $.mage.__('We don\\'t recognize or support this file extension type.')\n        ],\n        'validate-max-size': [\n            function (size, maxSize) {\n                return maxSize === false || size < maxSize;\n            },\n            $.mage.__('File you are trying to upload exceeds maximum file size limit.')\n        ],\n        'validate-if-tag-script-exist': [\n            function (value) {\n                return !value || (/<script\\b[^>]*>([\\s\\S]*?)<\\/script>$/ig).test(value);\n            },\n            $.mage.__('Please use tag SCRIPT with SRC attribute or with proper content to include JavaScript to the document.')\n        ],\n        'date_range_min': [\n            function (value, minValue, params) {\n                return moment.utc(value, params.dateFormat).unix() >= minValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'date_range_max': [\n            function (value, maxValue, params) {\n                return moment.utc(value, params.dateFormat).unix() <= maxValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ]\n    }, function (data) {\n        return {\n            handler: data[0],\n            message: data[1]\n        };\n    });\n});\n","Magento_Ui/js/lib/validation/utils.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    var utils = {\n        /**\n         * Check if string is empty with trim\n         * @param {string}\n            */\n        isEmpty: function(value) {\n            return (value === '' || (value == null) || (value.length === 0) || /^\\s+$/.test(value));\n        },\n\n        /**\n         * Check if string is empty no trim\n         * @param {string}\n            */\n        isEmptyNoTrim: function(value) {\n            return (value === '' || (value == null) || (value.length === 0));\n        },\n\n\n        /**\n         * Checks if {value} is between numbers {from} and {to}\n         * @param {string} value\n         * @param {string} from\n         * @param {string} to\n         * @returns {boolean}\n         */\n        isBetween: function(value, from, to){\n            return (from === null || from === '' || value >= utils.parseNumber(from)) &&\n                   (to === null || to === '' || value <= utils.parseNumber(to));\n        },\n\n        /**\n         * Parse price string\n         * @param {string}\n            */\n        parseNumber: function(value) {\n            if (typeof value !== 'string') {\n                return parseFloat(value);\n            }\n            var isDot = value.indexOf('.');\n            var isComa = value.indexOf(',');\n            if (isDot !== -1 && isComa !== -1) {\n                if (isComa > isDot) {\n                    value = value.replace('.', '').replace(',', '.');\n                } else {\n                    value = value.replace(',', '');\n                }\n            } else if (isComa !== -1) {\n                value = value.replace(',', '.');\n            }\n            return parseFloat(value);\n        },\n\n        /**\n         * Removes HTML tags and space characters, numbers and punctuation.\n         * @param value Value being stripped.\n         * @return {*}\n         */\n        stripHtml: function(value) {\n            return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n        }\n    }\n\n    return utils;\n});","Magento_Ui/js/lib/validation/validator.js":"/*\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    './rules'\n], function (_, rulesList) {\n    'use strict';\n\n    /**\n     * Validates provided value be the specified rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {*} value - Value to be checked.\n     * @param {*} [params]\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validate(id, value, params, additionalParams) {\n        var rule,\n            message,\n            valid,\n            result = {\n                rule: id,\n                passed: true,\n                message: ''\n            };\n\n        if (!rulesList[id]) {\n            return result;\n        }\n\n        rule    = rulesList[id];\n        message = rule.message;\n        valid   = rule.handler(value, params, additionalParams);\n\n        if (!valid) {\n            params = Array.isArray(params) ?\n                params :\n                [params];\n\n            message = params.reduce(function (msg, param, idx) {\n                return msg.replace(new RegExp('\\\\{' + idx + '\\\\}', 'g'), param);\n            }, message);\n\n            result.passed = false;\n            result.message = message;\n        }\n\n        return result;\n    }\n\n    /**\n     * Validates provied value by a specfied set of rules.\n     *\n     * @param {(String|Object)} rules - One or many validation rules.\n     * @param {*} value - Value to be checked.\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validator(rules, value, additionalParams) {\n        var result;\n\n        if (typeof rules === 'object') {\n            result = {\n                passed: true\n            };\n\n            _.every(rules, function (ruleParams, id) {\n                if (ruleParams !== false || additionalParams) {\n                    result = validate(id, value, ruleParams, additionalParams);\n\n                    return result.passed;\n                }\n\n                return true;\n            });\n\n            return result;\n        }\n\n        return validate.apply(null, arguments);\n    }\n\n    /**\n     * Adds new validation rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {Function} handler - Validation function.\n     * @param {String} message - Error message.\n     */\n    validator.addRule = function (id, handler, message) {\n        rulesList[id] = {\n            handler: handler,\n            message: message\n        };\n    };\n\n    /**\n     * Returns rule object found by provided identifier.\n     *\n     * @param {String} id - Rule identifier.\n     * @returns {Object}\n     */\n    validator.getRule = function (id) {\n        return rulesList[id];\n    };\n\n    return validator;\n});\n","Magento_Ui/js/lib/view/utils/async.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    './dom-observer',\n    'Magento_Ui/js/lib/knockout/extender/bound-nodes',\n    './bindings'\n], function (ko, $, _, registry, domObserver, boundedNodes) {\n    'use strict';\n\n    /**\n     * Checks if provided value is a dom element.\n     *\n     * @param {*} node - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isDomElement(node) {\n        return typeof node === 'object' && node.tagName && node.nodeType;\n    }\n\n    /**\n     * Parses provided string and extracts\n     * component, context and selector data from it.\n     *\n     * @param {String} str - String to be processed.\n     * @returns {Object} Data retrieved from string.\n     *\n     * @example Sample format.\n     *      '{{component}}:{{ctx}} -> {{selector}}'\n     *\n     *      component - Name of component.\n     *      ctx - Selector of the root node upon which component is binded.\n     *      selector - Selector of DOM elements located\n     *          inside of a previously specified context.\n     */\n    function parseSelector(str) {\n        var data    = str.trim().split('->'),\n            result  = {},\n            componentData;\n\n        if (data.length === 1) {\n            if (!~data[0].indexOf(':')) {\n                result.selector = data[0];\n            } else {\n                componentData = data[0];\n            }\n        } else {\n            componentData   = data[0];\n            result.selector = data[1];\n        }\n\n        if (componentData) {\n            componentData = componentData.split(':');\n\n            result.component = componentData[0];\n            result.ctx = componentData[1];\n        }\n\n        _.each(result, function (value, key) {\n            result[key] = value.trim();\n        });\n\n        return result;\n    }\n\n    /**\n     * Internal method used to normalize argumnets passed\n     * to 'async' module methods.\n     *\n     * @param {(String|Objetc)} selector\n     * @param {(HTMLElement|Object|String)} [ctx]\n     * @returns {Object}\n     */\n    function parseData(selector, ctx) {\n        var data = {};\n\n        if (arguments.length === 2) {\n            data.selector = selector;\n\n            if (isDomElement(ctx)) {\n                data.ctx = ctx;\n            } else {\n                data.component = ctx;\n                data.ctx = '*';\n            }\n        } else {\n            data = _.isString(selector) ?\n                parseSelector(selector) :\n                selector;\n        }\n\n        return data;\n    }\n\n    /**\n     * Creates promise that will be resolved\n     * when requested component is registred.\n     *\n     * @param {String} name - Name of component.\n     * @returns {jQueryPromise}\n     */\n    function waitComponent(name) {\n        var deffer = $.Deferred();\n\n        if (_.isString(name)) {\n            registry.get(name, function (component) {\n                deffer.resolve(component);\n            });\n        } else {\n            deffer.resolve(name);\n        }\n\n        return deffer.promise();\n    }\n\n    /**\n     * Creates listener for the nodes binded to provided component.\n     *\n     * @param {Object} data - Listener data.\n     * @param {Object} component - Associated with nodes component.\n     */\n    function setRootListener(data, component) {\n        boundedNodes.get(component, function (root) {\n            if (!$(root).is(data.ctx || '*')) {\n                return;\n            }\n\n            data.selector ?\n                domObserver.get(data.selector, data.fn, root) :\n                data.fn(root);\n        });\n    }\n\n    /*eslint-disable no-unused-vars*/\n    /**\n     * Sets listener for the appearance of elements which\n     * matches specified selector data.\n     *\n     * @param {(String|Object)} selector - Valid css selector or a string\n     *      in format acceptable by 'parseSelector' method or an object with\n     *      'component', 'selector' and 'ctx' properties.\n     * @param {(HTMLElement|Object|String)} [ctx] - Optional context parameter\n     *      which might be a DOM element, component instance or components' name.\n     * @param {Function} fn - Callback that will be invoked\n     *      when required DOM element appears.\n     *\n     * @example\n     *      Creating listener of the 'span' nodes appearance,\n     *      located inside of 'div' nodes, which are binded to 'cms_page_listing' component:\n     *\n     *      $.async('cms_page_listing:div -> span', function (node) {});\n     *\n     * @example Another syntaxes of the previous example.\n     *      $.async({\n     *          component: 'cms_page_listing',\n     *          ctx: 'div',\n     *          selector: 'span'\n     *       }, function (node) {});\n     *\n     * @example Listens for appearance of any child node inside of specified component.\n     *      $.async('> *', 'cms_page_lsiting', function (node) {});\n     *\n     * @example Listens for appearance of 'span' nodes inside of specific context.\n     *      $.async('span', document.getElementById('test'), function (node) {});\n     */\n    $.async = function (selector, ctx, fn) {\n        var args = _.toArray(arguments),\n            data = parseData.apply(null, _.initial(args));\n\n        data.fn = _.last(args);\n\n        if (data.component) {\n            waitComponent(data.component)\n                .then(setRootListener.bind(null, data));\n        } else {\n            domObserver.get(data.selector, data.fn, data.ctx);\n        }\n    };\n\n    /*eslint-enable no-unused-vars*/\n\n    _.extend($.async, {\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Returns collection of elements found by provided selector data.\n         *\n         * @param {(String|Object)} selector - See 'async' definition.\n         * @param {(HTMLElement|Object|String)} [ctx] - See 'async' definition.\n         * @returns {Array} An array of DOM elements.\n         */\n        get: function (selector, ctx) {\n            var data        = parseData.apply(null, arguments),\n                component   = data.component,\n                nodes;\n\n            if (!component) {\n                return $(data.selector, data.ctx).toArray();\n            } else if (_.isString(component)) {\n                component = registry.get(component);\n            }\n\n            if (!component) {\n                return [];\n            }\n\n            nodes = boundedNodes.get(component);\n            nodes = $(nodes).filter(data.ctx).toArray();\n\n            return data.selector ?\n                $(data.selector, nodes).toArray() :\n                nodes;\n        },\n\n        /*eslint-enable no-unused-vars*/\n\n        /**\n         * Sets removal listener of the specified nodes.\n         *\n         * @param {(HTMLElement|Array|ArrayLike)} nodes - Nodes whose removal to track.\n         * @param {Function} fn - Callback that will be invoked when node is removed.\n         */\n        remove: function (nodes, fn) {\n            domObserver.remove(nodes, fn);\n        },\n\n        parseSelector: parseSelector\n    });\n\n    return $;\n});\n","Magento_Ui/js/lib/view/utils/bindings.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore'\n], function (ko, $, _) {\n    'use strict';\n\n    /**\n     * Checks if provided  value is a dom element.\n     *\n     * @param {*} node - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isDomElement(node) {\n        return typeof node === 'object' && node.tagName && node.nodeType;\n    }\n\n    /**\n     * Removes from the provided array all non-root nodes located inside\n     * of the comment element as long as the closing comment tags.\n     *\n     * @param {(Array|ArrayLike)} nodes - An array of nodes to be processed.\n     * @returns {Array}\n     */\n    function normalize(nodes) {\n        var result;\n\n        nodes   = _.toArray(nodes);\n        result  = nodes.slice();\n\n        nodes.forEach(function (node) {\n            if (node.nodeType === 8) {\n                result = !ko.virtualElements.hasBindingValue(node) ?\n                    _.without(result, node) :\n                    _.difference(result, ko.virtualElements.childNodes(node));\n            }\n        });\n\n        return result;\n    }\n\n    /**\n     * Extends binding context of each item in the collection.\n     *\n     * @param {...Object} extenders - Multiple extender objects to be applied to the context.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.extendCtx = function () {\n        var nodes       = normalize(this),\n            extenders   = _.toArray(arguments);\n\n        nodes.forEach(function (node) {\n            var ctx  = ko.contextFor(node),\n                data = [ctx].concat(extenders);\n\n            _.extend.apply(_, data);\n        });\n\n        return this;\n    };\n\n    /**\n     * Evaluates bindings specified in each DOM element of collection.\n     *\n     * @param {(HTMLElement|Object)} [ctx] - Context to use for bindings evaluation.\n     *      If not specified then current context of a collections' item will be used.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.applyBindings = function (ctx) {\n        var nodes = normalize(this),\n            nodeCtx;\n\n        if (isDomElement(ctx)) {\n            ctx = ko.contextFor(ctx);\n        }\n\n        nodes.forEach(function (node) {\n            nodeCtx = ctx || ko.contextFor(node);\n\n            ko.applyBindings(nodeCtx, node);\n        });\n\n        return this;\n    };\n\n    /**\n     * Adds specfied bindings to each DOM elemenet in\n     * collection and evalutes them with provided context.\n     *\n     * @param {(Object|Function)} data - Either bindings object or a function\n     *      which returns bindings data for each element in collection.\n     * @param {(HTMLElement|Object)} [ctx] - Context to use for bindings evaluation.\n     *      If not specified then current context of a collections' item will be used.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.bindings = function (data, ctx) {\n        var nodes    = normalize(this),\n            bindings = data,\n            nodeCtx;\n\n        if (isDomElement(ctx)) {\n            ctx = ko.contextFor(ctx);\n        }\n\n        nodes.forEach(function (node) {\n            nodeCtx = ctx || ko.contextFor(node);\n\n            if (_.isFunction(data)) {\n                bindings = data(nodeCtx, node);\n            }\n\n            ko.applyBindingsToNode(node, bindings, nodeCtx);\n        });\n\n        return this;\n    };\n});\n","Magento_Ui/js/lib/view/utils/dom-observer.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'MutationObserver',\n    'domReady!'\n], function ($, _) {\n    'use strict';\n\n    var counter = 1,\n        watchers,\n        globalObserver;\n\n    watchers = {\n        selectors: {},\n        nodes: {}\n    };\n\n    /**\n     * Checks if node represents an element node (nodeType === 1).\n     *\n     * @param {HTMLElement} node\n     * @returns {Boolean}\n     */\n    function isElementNode(node) {\n        return node.nodeType === 1;\n    }\n\n    /**\n     * Extracts all child descendant\n     * elements of a specified node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Array}\n     */\n    function extractChildren(node) {\n        var children = node.querySelectorAll('*');\n\n        return _.toArray(children);\n    }\n\n    /**\n     * Extracts node identifier. If ID is not specified,\n     * then it will be created for the provided node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Number}\n     */\n    function getNodeId(node) {\n        var id = node._observeId;\n\n        if (!id) {\n            id = node._observeId = counter++;\n        }\n\n        return id;\n    }\n\n    /**\n     * Invokes callback passing node to it.\n     *\n     * @param {HTMLElement} node\n     * @param {Object} data\n     */\n    function trigger(node, data) {\n        var id = getNodeId(node),\n            ids = data.invoked;\n\n        if (_.contains(ids, id)) {\n            return;\n        }\n\n        data.callback(node);\n        data.invoked.push(id);\n    }\n\n    /**\n     * Adds node to the observer list.\n     *\n     * @param {HTMLElement} node\n     * @returns {Object}\n     */\n    function createNodeData(node) {\n        var nodes   = watchers.nodes,\n            id      = getNodeId(node);\n\n        nodes[id] = nodes[id] || {};\n\n        return nodes[id];\n    }\n\n    /**\n     * Returns data associated with a specified node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Object|Undefined}\n     */\n    function getNodeData(node) {\n        var nodeId = node._observeId;\n\n        return watchers.nodes[nodeId];\n    }\n\n    /**\n     * Removes data associated with a specified node.\n     *\n     * @param {HTMLElement} node\n     */\n    function removeNodeData(node) {\n        var nodeId = node._observeId;\n\n        delete watchers.nodes[nodeId];\n    }\n\n    /**\n     * Adds removal listener for a specified node.\n     *\n     * @param {HTMLElement} node\n     * @param {Object} data\n     */\n    function addRemovalListener(node, data) {\n        var nodeData = createNodeData(node);\n\n        (nodeData.remove = nodeData.remove || []).push(data);\n    }\n\n    /**\n     * Adds listener for the nodes which matches specified selector.\n     *\n     * @param {String} selector - CSS selector.\n     * @param {Object} data\n     */\n    function addSelectorListener(selector, data) {\n        var storage = watchers.selectors;\n\n        (storage[selector] = storage[selector] || []).push(data);\n    }\n\n    /**\n     * Calls handlers assocoiated with an added node.\n     * Adds listeners for the node removal.\n     *\n     * @param {HTMLElement} node - Added node.\n     */\n    function processAdded(node) {\n        _.each(watchers.selectors, function (listeners, selector) {\n            listeners.forEach(function (data) {\n                if (!data.ctx.contains(node) || !$(node, data.ctx).is(selector)) {\n                    return;\n                }\n\n                if (data.type === 'add') {\n                    trigger(node, data);\n                } else if (data.type === 'remove') {\n                    addRemovalListener(node, data);\n                }\n            });\n        });\n    }\n\n    /**\n     * Calls handlers assocoiated with a removed node.\n     *\n     * @param {HTMLElement} node - Removed node.\n     */\n    function processRemoved(node) {\n        var nodeData    = getNodeData(node),\n            listeners   = nodeData && nodeData.remove;\n\n        if (!listeners) {\n            return;\n        }\n\n        listeners.forEach(function (data) {\n            trigger(node, data);\n        });\n\n        removeNodeData(node);\n    }\n\n    /**\n     * Removes all non-element nodes from provided array\n     * and appends to it descendant elements.\n     *\n     * @param {Array} nodes\n     * @returns {Array}\n     */\n    function formNodesList(nodes) {\n        var result = [],\n            children;\n\n        nodes = _.toArray(nodes).filter(isElementNode);\n\n        nodes.forEach(function (node) {\n            result.push(node);\n\n            children = extractChildren(node);\n            result   = result.concat(children);\n        });\n\n        return result;\n    }\n\n    /**\n     * Collects all removed and added nodes from\n     * mutation records into separate arrays\n     * while removing duplicates between both types of changes.\n     *\n     * @param {Array} mutations - An array of mutation records.\n     * @returns {Object} Object with 'removed' and 'added' nodes arrays.\n     */\n    function formChangesLists(mutations) {\n        var removed = [],\n            added = [];\n\n        mutations.forEach(function (record) {\n            removed = removed.concat(_.toArray(record.removedNodes));\n            added   = added.concat(_.toArray(record.addedNodes));\n        });\n\n        removed = removed.filter(function (node) {\n            var addIndex = added.indexOf(node),\n                wasAdded = !!~addIndex;\n\n            if (wasAdded) {\n                added.splice(addIndex, 1);\n            }\n\n            return !wasAdded;\n        });\n\n        return {\n            removed: formNodesList(removed),\n            added: formNodesList(added)\n        };\n    }\n\n    globalObserver = new MutationObserver(function (mutations) {\n        var changes = formChangesLists(mutations);\n\n        changes.removed.forEach(processRemoved);\n        changes.added.forEach(processAdded);\n    });\n\n    globalObserver.observe(document.body, {\n        subtree: true,\n        childList: true\n    });\n\n    return {\n\n        /**\n         * Adds listener for the appearance of nodes that matches provided\n         * selector and which are inside of the provided context. Callback will be\n         * also invoked on elements which a currently present.\n         *\n         * @param {String} selector - CSS selector.\n         * @param {Function} callback - Function that will invoked when node appears.\n         * @param {HTMLElement} [ctx=document.body] - Context inside of which to search for the node.\n         */\n        get: function (selector, callback, ctx) {\n            var data,\n                nodes;\n\n            data = {\n                ctx: ctx || document.body,\n                type: 'add',\n                callback: callback,\n                invoked: []\n            };\n\n            nodes = $(selector, data.ctx).toArray();\n\n            nodes.forEach(function (node) {\n                trigger(node, data);\n            });\n\n            addSelectorListener(selector, data);\n        },\n\n        /**\n         * Adds listener for the nodes removal.\n         *\n         * @param {(jQueryObject|HTMLElement|Array|String)} selector\n         * @param {Function} callback - Function that will invoked when node is removed.\n         * @param {HTMLElement} [ctx=document.body] - Context inside of which to search for the node.\n         */\n        remove: function (selector, callback, ctx) {\n            var nodes = [],\n                data;\n\n            data = {\n                ctx: ctx || document.body,\n                type: 'remove',\n                callback: callback,\n                invoked: []\n            };\n\n            if (typeof selector === 'object') {\n                nodes = !_.isUndefined(selector.length) ?\n                    _.toArray(selector) :\n                    [selector];\n            } else if (_.isString(selector)) {\n                nodes = $(selector, ctx).toArray();\n\n                addSelectorListener(selector, data);\n            }\n\n            nodes.forEach(function (node) {\n                addRemovalListener(node, data);\n            });\n        },\n\n        /**\n         * Removes listeners.\n         *\n         * @param {String} selector\n         * @param {Function} [fn]\n         */\n        off: function (selector, fn) {\n            var selectors = watchers.selectors,\n                listeners = selectors[selector];\n\n            if (selector && !fn) {\n                delete selectors[selector];\n            } else if (listeners && fn) {\n                selectors[selector] = listeners.filter(function (data) {\n                    return data.callback !== fn;\n                });\n            }\n        }\n    };\n});\n","Magento_Ui/js/lib/view/utils/raf.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'es6-collections'\n], function () {\n    'use strict';\n\n    var processMap = new WeakMap(),\n        origRaf,\n        raf;\n\n    origRaf = window.requestAnimationFrame ||\n        window.webkitRequestAnimationFrame ||\n        window.mozRequestAnimationFrame ||\n        window.onRequestAnimationFrame ||\n        window.msRequestAnimationFrame ||\n        function (callback) {\n            window.setTimeout(callback, 1000 / 60);\n        };\n\n    /**\n     * Creates new process object or extracts the\n     * the existing one.\n     *\n     * @param {*} id - Process identifier.\n     * @param {Number} fps - Required FPS count.\n     * @returns {Object}\n     */\n    function getProcess(id, fps) {\n        var process = processMap.get(id);\n\n        if (!process) {\n            process = {};\n            processMap.set(id, process);\n        }\n\n        if (process.fps !== fps) {\n            process.fps        = fps;\n            process.interval   = 1000 / fps;\n            process.update     = Date.now();\n        }\n\n        return process;\n    }\n\n    /**\n     * Proxy method which delegates call to the 'requestAnimationFrame'\n     * function and optionally can keep track of the FPS with which\n     * provided function is called.\n     *\n     * @param {Function} callback - Callback function to be passed to 'requestAnimationFrame'.\n     * @param {Number} [fps] - If specified, will update FPS counter for the provided function.\n     * @returns {Number|Boolean} ID of request or a flag which indicates\n     *      whether callback fits specified FPS.\n     */\n    raf = function (callback, fps) {\n        var rafId = origRaf(callback);\n\n        return fps ? raf.tick(callback, fps) : rafId;\n    };\n\n    /**\n     * Updates FPS counter for the specified process\n     * and returns a flag which indicates whether\n     * counter value is equal or greater than the required FPS.\n     *\n     * @param {*} id - Process identifier.\n     * @param {Number} fps - Required FPS count.\n     * @returns {Boolean}\n     */\n    raf.tick = function (id, fps) {\n        var process  = getProcess(id, fps),\n            now      = Date.now(),\n            delta    = now - process.update,\n            interval = process.interval;\n\n        if (fps >= 60 || delta >= interval) {\n            process.update = now - delta % interval;\n\n            return true;\n        }\n\n        return false;\n    };\n\n    return raf;\n});\n","Magento_Ui/js/modal/alert.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, _) {\n    'use strict';\n\n    $.widget('mage.alert', $.mage.confirm, {\n        options: {\n            modalClass: 'confirm',\n            title: $.mage.__('Attention'),\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal(true);\n                }\n            }]\n        },\n\n        /**\n         * Close modal window.\n         */\n        closeModal: function () {\n            this.options.actions.always();\n            this.element.bind('alertclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).alert(config);\n    };\n});\n","Magento_Ui/js/modal/confirm.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, _) {\n    'use strict';\n\n    $.widget('mage.confirm', $.mage.modal, {\n        options: {\n            modalClass: 'confirm',\n            title: '',\n            focus: '.action-accept',\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {},\n\n                /**\n                 * Callback confirm.\n                 */\n                confirm: function () {},\n\n                /**\n                 * Callback cancel.\n                 */\n                cancel: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function (event) {\n                    this.closeModal(event);\n                }\n            }, {\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function (event) {\n                    this.closeModal(event, true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this._super();\n            this.modal.find(this.options.modalCloseBtn).off().on('click', _.bind(this.closeModal, this));\n            this.openModal();\n        },\n\n        /**\n         * Remove modal window.\n         */\n        _remove: function () {\n            this.modal.remove();\n        },\n\n        /**\n         * Open modal window.\n         */\n        openModal: function () {\n            return this._super();\n        },\n\n        /**\n         * Close modal window.\n         */\n        closeModal: function (event, result) {\n            result = result || false;\n\n            if (result) {\n                this.options.actions.confirm(event);\n            } else {\n                this.options.actions.cancel(event);\n            }\n            this.options.actions.always(event);\n            this.element.bind('confirmclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).confirm(config);\n    };\n});\n","Magento_Ui/js/modal/modal-component.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiCollection',\n    'uiRegistry',\n    'underscore',\n    './modal'\n], function ($, Collection, registry, _) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/modal/modal-component',\n            title: '',\n            subTitle: '',\n            options: {\n                title: '',\n                subTitle: '',\n                buttons: [],\n                keyEventHandlers: {}\n            },\n            valid: true,\n            links: {\n                title: 'options.title',\n                subTitle: 'options.subTitle'\n            },\n            listens: {\n                state: 'onState',\n                title: 'setTitle',\n                'options.subTitle': 'setSubTitle'\n            },\n            modalClass: 'modal-component',\n            onCancel: 'closeModal'\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this,\n                'initModal',\n                'openModal',\n                'closeModal',\n                'toggleModal',\n                'setPrevValues',\n                'validate');\n            this.initializeContent();\n\n            return this;\n        },\n\n        /**\n         * Initializes modal configuration\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            return this._super()\n                .initSelector()\n                .initModalEvents();\n        },\n\n        /**\n         * Configure modal selector\n         *\n         * @returns {Object} Chainable.\n         */\n        initSelector: function () {\n            var modalClass = this.name.replace(/\\./g, '_');\n\n            this.contentSelector = '.' + this.modalClass;\n            this.options.modalClass = this.options.modalClass + ' ' + modalClass;\n            this.rootSelector = '.' + modalClass;\n\n            return this;\n        },\n\n        /**\n         * Configure modal keyboard handlers\n         * and outer click\n         *\n         * @returns {Object} Chainable.\n         */\n        initModalEvents: function () {\n            this.options.keyEventHandlers.escapeKey = this.options.outerClickHandler = this[this.onCancel].bind(this);\n\n            return this;\n        },\n\n        /**\n         * Initialize modal's content components\n         */\n        initializeContent: function () {\n            $.async({\n                component: this.name\n            }, this.initModal);\n        },\n\n        /**\n         * Init toolbar section so other components will be able to place something in it\n         */\n        initToolbarSection: function () {\n            this.set('toolbarSection', this.modal.data('mage-modal').modal.find('header').get(0));\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe(['state', 'focused']);\n\n            return this;\n        },\n\n        /**\n         * Wrap content in a modal of certain type\n         *\n         * @param {HTMLElement} element\n         * @returns {Object} Chainable.\n         */\n        initModal: function (element) {\n            if (!this.modal) {\n                this.overrideModalButtonCallback();\n                this.options.modalCloseBtnHandler = this[this.onCancel].bind(this);\n                this.modal = $(element).modal(this.options);\n                this.initToolbarSection();\n\n                if (this.waitCbk) {\n                    this.waitCbk();\n                    this.waitCbk = null;\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            if (this.modal) {\n                this.state(true);\n            } else {\n                this.waitCbk = this.openModal;\n            }\n        },\n\n        /**\n         * Close modal\n         */\n        closeModal: function () {\n            if (this.modal) {\n                this.state(false);\n            } else {\n                this.waitCbk = this.closeModal;\n            }\n        },\n\n        /**\n         * Toggle modal\n         */\n        toggleModal: function () {\n            if (this.modal) {\n                this.state(!this.state());\n            } else {\n                this.waitCbk = this.toggleModal;\n            }\n        },\n\n        /**\n         * Sets title for modal\n         *\n         * @param {String} title\n         */\n        setTitle: function (title) {\n            if (this.title !== title) {\n                this.title = title;\n            }\n\n            if (this.modal) {\n                this.modal.modal('setTitle', title);\n            }\n        },\n\n        /**\n         * Sets subTitle for modal\n         *\n         * @param {String} subTitle\n         */\n        setSubTitle: function (subTitle) {\n            if (this.subTitle !== subTitle) {\n                this.subTitle = subTitle;\n            }\n\n            if (this.modal) {\n                this.modal.modal('setSubTitle', subTitle);\n            }\n        },\n\n        /**\n         * Wrap content in a modal of certain type\n         *\n         * @param {Boolean} state\n         */\n        onState: function (state) {\n            if (state) {\n                this.modal.modal('openModal');\n                this.applyData();\n            } else {\n                this.modal.modal('closeModal');\n            }\n        },\n\n        /**\n         * Validate everything validatable in modal\n         */\n        validate: function (elem) {\n            if (typeof elem.validate === 'function') {\n                this.valid = this.valid & elem.validate().valid;\n            } else if (elem.elems) {\n                elem.elems().forEach(this.validate, this);\n            }\n        },\n\n        /**\n         * Reset data from provider\n         */\n        resetData: function () {\n            this.elems().forEach(this.resetValue, this);\n        },\n\n        /**\n         * Update 'applied' property with data from modal content\n         */\n        applyData: function () {\n            var applied = {};\n\n            this.elems().forEach(this.gatherValues.bind(this, applied), this);\n            this.applied = applied;\n        },\n\n        /**\n         * Gather values from modal content\n         *\n         * @param {Array} applied\n         * @param {HTMLElement} elem\n         */\n        gatherValues: function (applied, elem) {\n            if (typeof elem.value === 'function') {\n                applied[elem.name] = elem.value();\n            } else if (elem.elems) {\n                elem.elems().forEach(this.gatherValues.bind(this, applied), this);\n            }\n        },\n\n        /**\n         * Set to previous values from modal content\n         *\n         * @param {HTMLElement} elem\n         */\n        setPrevValues: function (elem) {\n            if (typeof elem.value === 'function') {\n                this.modal.focus();\n                elem.value(this.applied[elem.name]);\n            } else if (elem.elems) {\n                elem.elems().forEach(this.setPrevValues, this);\n            }\n        },\n\n        /**\n         * Triggers some method in every modal child elem, if this method is defined\n         *\n         * @param {Object} action - action configuration,\n         * must contain actionName and targetName and\n         * can contain params\n         */\n        triggerAction: function (action) {\n            var targetName = action.targetName,\n                params = action.params || [],\n                actionName = action.actionName,\n                target;\n\n            target = registry.async(targetName);\n\n            if (target && typeof target === 'function' && actionName) {\n                params.unshift(actionName);\n                target.apply(target, params);\n            }\n        },\n\n        /**\n         * Override modal buttons callback placeholders with real callbacks\n         */\n        overrideModalButtonCallback: function () {\n            var buttons = this.options.buttons;\n\n            if (buttons && buttons.length) {\n                buttons.forEach(function (button) {\n                    button.click = this.getButtonClickHandler(button.actions);\n                }, this);\n            }\n        },\n\n        /**\n         * Generate button click handler based on button's 'actions' configuration\n         */\n        getButtonClickHandler: function (actionsConfig) {\n            var actions = actionsConfig.map(\n                function (actionConfig) {\n                    if (_.isObject(actionConfig)) {\n                        return this.triggerAction.bind(this, actionConfig);\n                    }\n\n                    return this[actionConfig] ? this[actionConfig].bind(this) : function () {};\n                }, this);\n\n            return function () {\n                actions.forEach(\n                    function (action) {\n                        action();\n                    }\n                );\n            };\n        },\n\n        /**\n         * Cancels changes in modal:\n         * returning elems values to the previous state,\n         * and close modal\n         */\n        actionCancel: function () {\n            this.elems().forEach(this.setPrevValues, this);\n            this.closeModal();\n        },\n\n        /**\n         * Accept changes in modal by not preventing them.\n         * Can be extended by exporting 'gatherValues' result somewhere\n         */\n        actionDone: function () {\n            this.valid = true;\n            this.elems().forEach(this.validate, this);\n\n            if (this.valid) {\n                this.closeModal();\n            }\n        }\n    });\n});\n","Magento_Ui/js/modal/modal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'text!ui/template/modal/modal-popup.html',\n    'text!ui/template/modal/modal-slide.html',\n    'text!ui/template/modal/modal-custom.html',\n    'Magento_Ui/js/lib/key-codes',\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, template, popupTpl, slideTpl, customTpl, keyCodes) {\n    'use strict';\n\n    /**\n     * Detect browser transition end event.\n     * @return {String|undefined} - transition event.\n     */\n    var transitionEvent =  (function () {\n        var transition,\n            elementStyle = document.createElement('div').style,\n            transitions = {\n                'transition': 'transitionend',\n                'OTransition': 'oTransitionEnd',\n                'MozTransition': 'transitionend',\n                'WebkitTransition': 'webkitTransitionEnd'\n            };\n\n        for (transition in transitions) {\n            if (elementStyle[transition] !== undefined && transitions.hasOwnProperty(transition)) {\n                return transitions[transition];\n            }\n        }\n    })();\n\n    /**\n     * Modal Window Widget\n     */\n    $.widget('mage.modal', {\n        options: {\n            type: 'popup',\n            title: '',\n            subTitle: '',\n            modalClass: '',\n            focus: '[data-role=\"closeBtn\"]',\n            autoOpen: false,\n            clickableOverlay: true,\n            popupTpl: popupTpl,\n            slideTpl: slideTpl,\n            customTpl: customTpl,\n            modalVisibleClass: '_show',\n            parentModalClass: '_has-modal',\n            innerScrollClass: '_inner-scroll',\n            responsive: false,\n            innerScroll: false,\n            modalTitle: '[data-role=\"title\"]',\n            modalSubTitle: '[data-role=\"subTitle\"]',\n            modalBlock: '[data-role=\"modal\"]',\n            modalCloseBtn: '[data-role=\"closeBtn\"]',\n            modalContent: '[data-role=\"content\"]',\n            modalAction: '[data-role=\"action\"]',\n            focusableScope: '[data-role=\"focusable-scope\"]',\n            focusableStart: '[data-role=\"focusable-start\"]',\n            focusableEnd: '[data-role=\"focusable-end\"]',\n            appendTo: 'body',\n            wrapperClass: 'modals-wrapper',\n            overlayClass: 'modals-overlay',\n            responsiveClass: 'modal-slide',\n            trigger: '',\n            modalLeftMargin: 45,\n            closeText: $.mage.__('Close'),\n            buttons: [{\n                text: $.mage.__('Ok'),\n                class: '',\n                attr: {},\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) {\n                    this.closeModal(event);\n                }\n            }],\n            keyEventHandlers: {\n\n                /**\n                 * Tab key press handler,\n                 * set focus to elements\n                 */\n                tabKey: function () {\n                    if (document.activeElement === this.modal[0]) {\n                        this._setFocus('start');\n                    }\n                },\n\n                /**\n                 * Escape key press handler,\n                 * close modal window\n                 */\n                escapeKey: function () {\n                    if (this.options.isOpen && this.modal.find(document.activeElement).length ||\n                        this.options.isOpen && this.modal[0] === document.activeElement) {\n                        this.closeModal();\n                    }\n                }\n            }\n        },\n\n        /**\n         * Creates modal widget.\n         */\n        _create: function () {\n            _.bindAll(\n                this,\n                'keyEventSwitcher',\n                '_tabSwitcher',\n                'closeModal'\n            );\n\n            this.options.transitionEvent = transitionEvent;\n            this._createWrapper();\n            this._renderModal();\n            this._createButtons();\n            $(this.options.trigger).on('click', _.bind(this.toggleModal, this));\n            this._on(this.modal.find(this.options.modalCloseBtn), {\n                'click': this.options.modalCloseBtnHandler ? this.options.modalCloseBtnHandler : this.closeModal\n            });\n            this._on(this.element, {\n                'openModal': this.openModal,\n                'closeModal': this.closeModal\n            });\n            this.options.autoOpen ? this.openModal() : false;\n        },\n\n        /**\n         * Returns element from modal node.\n         * @return {Object} - element.\n         */\n        _getElem: function (elem) {\n            return this.modal.find(elem);\n        },\n\n        /**\n         * Gets visible modal count.\n         * * @return {Number} - visible modal count.\n         */\n        _getVisibleCount: function () {\n            var modals = this.modalWrapper.find(this.options.modalBlock);\n\n            return modals.filter('.' + this.options.modalVisibleClass).length;\n        },\n\n        /**\n         * Gets count of visible modal by slide type.\n         * * @return {Number} - visible modal count.\n         */\n        _getVisibleSlideCount: function () {\n            var elems = this.modalWrapper.find('[data-type=\"slide\"]');\n\n            return elems.filter('.' + this.options.modalVisibleClass).length;\n        },\n\n        /**\n         * Listener key events.\n         * Call handler function if it exists\n         */\n        keyEventSwitcher: function (event) {\n            var key = keyCodes[event.keyCode];\n\n            if (this.options.keyEventHandlers.hasOwnProperty(key)) {\n                this.options.keyEventHandlers[key].apply(this, arguments);\n            }\n        },\n\n        /**\n         * Set title for modal.\n         *\n         * @param {String} title\n         */\n        setTitle: function (title) {\n            var $title = $(this.options.modalTitle),\n                $subTitle = this.modal.find(this.options.modalSubTitle);\n\n            $title.text(title);\n            $title.append($subTitle);\n        },\n\n        /**\n         * Set sub title for modal.\n         *\n         * @param {String} subTitle\n         */\n        setSubTitle: function (subTitle) {\n            this.options.subTitle = subTitle;\n            this.modal.find(this.options.modalSubTitle).html(subTitle);\n        },\n\n        /**\n         * Toggle modal.\n         * * @return {Element} - current element.\n         */\n        toggleModal: function () {\n            if (this.options.isOpen === true) {\n                this.closeModal();\n            } else {\n                this.openModal();\n            }\n        },\n\n        /**\n         * Open modal.\n         * * @return {Element} - current element.\n         */\n        openModal: function () {\n            this.options.isOpen = true;\n            this.focussedElement = document.activeElement;\n            this._createOverlay();\n            this._setActive();\n            this._setKeyListener();\n            this.modal.one(this.options.transitionEvent, _.bind(this._setFocus, this, 'end', 'opened'));\n            this.modal.one(this.options.transitionEvent, _.bind(this._trigger, this, 'opened'));\n            this.modal.addClass(this.options.modalVisibleClass);\n\n            if (!this.options.transitionEvent) {\n                this._trigger('opened');\n            }\n\n            return this.element;\n        },\n\n        /**\n         * Set focus to element.\n         * @param {String} position - can be \"start\" and \"end\"\n         *      positions.\n         *      If position is \"end\" - sets focus to first\n         *      focusable element in modal window scope.\n         *      If position is \"start\" - sets focus to last\n         *      focusable element in modal window scope\n         *\n         *  @param {String} type - can be \"opened\" or false\n         *      If type is \"opened\" - looks to \"this.options.focus\"\n         *      property and sets focus\n         */\n        _setFocus: function (position, type) {\n            var focusableElements,\n                infelicity;\n\n            if (type === 'opened' && this.options.focus) {\n                this.modal.find($(this.options.focus)).focus();\n            } else if (type === 'opened' && !this.options.focus) {\n                this.modal.find(this.options.focusableScope).focus();\n            } else if (position === 'end') {\n                this.modal.find(this.options.modalCloseBtn).focus();\n            } else if (position === 'start') {\n                infelicity = 2; //Constant for find last focusable element\n                focusableElements = this.modal.find(':focusable');\n                focusableElements.eq(focusableElements.length - infelicity).focus();\n            }\n        },\n\n        /**\n         * Set events listener when modal is opened.\n         */\n        _setKeyListener: function () {\n            this.modal.find(this.options.focusableStart).bind('focusin', this._tabSwitcher);\n            this.modal.find(this.options.focusableEnd).bind('focusin', this._tabSwitcher);\n            this.modal.bind('keydown', this.keyEventSwitcher);\n        },\n\n        /**\n         * Remove events listener when modal is closed.\n         */\n        _removeKeyListener: function () {\n            this.modal.find(this.options.focusableStart).unbind('focusin', this._tabSwitcher);\n            this.modal.find(this.options.focusableEnd).unbind('focusin', this._tabSwitcher);\n            this.modal.unbind('keydown', this.keyEventSwitcher);\n        },\n\n        /**\n         * Switcher for focus event.\n         * @param {Object} e - event\n         */\n        _tabSwitcher: function (e) {\n            var target = $(e.target);\n\n            if (target.is(this.options.focusableStart)) {\n                this._setFocus('start');\n            } else if (target.is(this.options.focusableEnd)) {\n                this._setFocus('end');\n            }\n        },\n\n        /**\n         * Close modal.\n         * * @return {Element} - current element.\n         */\n        closeModal: function () {\n            var that = this;\n\n            this._removeKeyListener();\n            this.options.isOpen = false;\n            this.modal.one(this.options.transitionEvent, function () {\n                that._close();\n            });\n            this.modal.removeClass(this.options.modalVisibleClass);\n\n            if (!this.options.transitionEvent) {\n                that._close();\n            }\n\n            return this.element;\n        },\n\n        /**\n         * Helper for closeModal function.\n         */\n        _close: function () {\n            var trigger = _.bind(this._trigger, this, 'closed', this.modal);\n\n            $(this.focussedElement).focus();\n            this._destroyOverlay();\n            this._unsetActive();\n            _.defer(trigger, this);\n        },\n\n        /**\n         * Set z-index and margin for modal and overlay.\n         */\n        _setActive: function () {\n            var zIndex = this.modal.zIndex();\n\n            this.prevOverlayIndex = this.overlay.zIndex();\n            this.modal.zIndex(zIndex + this._getVisibleCount());\n            this.overlay.zIndex(zIndex + (this._getVisibleCount() - 1));\n\n            if (this._getVisibleSlideCount()) {\n                this.modal.css('marginLeft', this.options.modalLeftMargin * this._getVisibleSlideCount());\n            }\n        },\n\n        /**\n         * Unset styles for modal and set z-index for previous modal.\n         */\n        _unsetActive: function () {\n            this.modal.removeAttr('style');\n\n            if (this.overlay) {\n                this.overlay.zIndex(this.prevOverlayIndex);\n            }\n        },\n\n        /**\n         * Creates wrapper to hold all modals.\n         */\n        _createWrapper: function () {\n            this.modalWrapper = $(this.options.appendTo).find('.' + this.options.wrapperClass);\n\n            if (!this.modalWrapper.length) {\n                this.modalWrapper = $('<div></div>')\n                    .addClass(this.options.wrapperClass)\n                    .appendTo(this.options.appendTo);\n            }\n        },\n\n        /**\n         * Compile template and append to wrapper.\n         */\n        _renderModal: function () {\n            $(template(\n                this.options[this.options.type + 'Tpl'],\n                {\n                    data: this.options\n                })).appendTo(this.modalWrapper);\n            this.modal = this.modalWrapper.find(this.options.modalBlock).last();\n            this.element.appendTo(this._getElem(this.options.modalContent));\n\n            if (this.element.is(':hidden')) {\n                this.element.show();\n            }\n        },\n\n        /**\n         * Creates buttons pane.\n         */\n        _createButtons: function () {\n            this.buttons = this._getElem(this.options.modalAction);\n            _.each(this.options.buttons, function (btn, key) {\n                var button = this.buttons[key];\n\n                if (btn.attr) {\n                    $(button).attr(btn.attr);\n                }\n\n                if (btn.class) {\n                    $(button).addClass(btn.class);\n                }\n\n                if (!btn.click) {\n                    btn.click = this.closeModal;\n                }\n                $(button).on('click', _.bind(btn.click, this));\n            }, this);\n        },\n\n        /**\n         * Creates overlay, append it to wrapper, set previous click event on overlay.\n         */\n        _createOverlay: function () {\n            var events,\n                outerClickHandler = this.options.outerClickHandler || this.closeModal;\n\n            this.overlay = $('.' + this.options.overlayClass);\n\n            if (!this.overlay.length) {\n                $(this.options.appendTo).addClass(this.options.parentModalClass);\n                this.overlay = $('<div></div>')\n                    .addClass(this.options.overlayClass)\n                    .appendTo(this.modalWrapper);\n            }\n            events = $._data(this.overlay.get(0), 'events');\n            events ? this.prevOverlayHandler = events.click[0].handler : false;\n            this.options.clickableOverlay ? this.overlay.unbind().on('click', outerClickHandler) : false;\n        },\n\n        /**\n         * Destroy overlay.\n         */\n        _destroyOverlay: function () {\n            if (this._getVisibleCount()) {\n                this.overlay.unbind().on('click', this.prevOverlayHandler);\n            } else {\n                $(this.options.appendTo).removeClass(this.options.parentModalClass);\n                this.overlay.remove();\n                this.overlay = null;\n            }\n        }\n    });\n\n    return $.mage.modal;\n});\n","Magento_Ui/js/modal/modalToggle.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($) {\n    'use strict';\n\n    return function (config, el) {\n        var widget,\n            content;\n\n        if (config.contentSelector) {\n            content = $(config.contentSelector);\n        } else if (config.content) {\n            content = $('<div />').html(config.content);\n        } else {\n            content = $('<div />');\n        }\n\n        widget = content.modal(config);\n\n        $(el).on(config.toggleEvent, function () {\n            var state = widget.data('mage-modal').options.isOpen;\n\n            if (state) {\n                widget.modal('closeModal');\n            } else {\n                widget.modal('openModal');\n            }\n\n            return false;\n        });\n\n        return widget;\n    };\n});\n","Magento_Ui/js/modal/prompt.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, _) {\n    'use strict';\n\n    $.widget('mage.prompt', $.mage.modal, {\n        options: {\n            modalClass: 'prompt',\n            promptField: '[data-role=\"promptField\"]',\n            value: '',\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {},\n\n                /**\n                 * Callback confirm.\n                 */\n                confirm: function () {},\n\n                /**\n                 * Callback cancel.\n                 */\n                cancel: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }, {\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal(true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this.options.focus = this.options.promptField;\n            this._super();\n            this.modal.find(this.options.modalContent).append(\n                '<div class=\"prompt-message\">' +\n                    '<input data-role=\"promptField\" id=\"prompt-field\" class=\"admin__control-text\" type=\"text\"/>' +\n                '</div>'\n            );\n            this.modal.find(this.options.modalCloseBtn).off().on('click',  _.bind(this.closeModal, this, false));\n            this.openModal();\n        },\n\n        /**\n         * Compile template and append to wrapper.\n         */\n        _renderModal: function () {\n            this._super();\n            this.element.wrap('<label for=\"prompt-field\"></label>');\n        },\n\n        /**\n         * Remove widget\n         */\n        _remove: function () {\n            this.modal.remove();\n        },\n\n        /**\n         * Open modal window\n         */\n        openModal: function () {\n            this._super();\n            this.modal.find(this.options.promptField).val(this.options.value);\n        },\n\n        /**\n         * Close modal window\n         */\n        closeModal: function (result) {\n            var value;\n\n            if (result) {\n                value = this.modal.find(this.options.promptField).val();\n                this.options.actions.confirm(value);\n            } else {\n                this.options.actions.cancel();\n            }\n            this.options.actions.always();\n            this.element.bind('promptclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).prompt(config);\n    };\n});\n","Magento_Ui/js/model/messageList.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        './messages'\n    ], function (Messages) {\n        'use strict';\n        return new Messages();\n    }\n);\n","Magento_Ui/js/model/messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiClass'\n], function (ko, Class) {\n    'use strict';\n\n    return Class.extend({\n\n\n        initialize: function () {\n            this._super()\n                .initObservable();\n\n            return this;\n        },\n\n\n        initObservable: function () {\n            this.errorMessages = ko.observableArray([]);\n            this.successMessages = ko.observableArray([]);\n\n            return this;\n        },\n\n        /**\n         * Add  message to list.\n         * @param {Object} messageObj\n         * @param {Object} type\n         * @returns {Boolean}\n         */\n        add: function (messageObj, type) {\n            var expr = /([%])\\w+/g,\n                message;\n\n            if (!messageObj.hasOwnProperty('parameters')) {\n                this.clear();\n                type.push(messageObj.message);\n\n                return true;\n            }\n            message = messageObj.message.replace(expr, function (varName) {\n                varName = varName.substr(1);\n\n                if (messageObj.parameters.hasOwnProperty(varName)) {\n                    return messageObj.parameters[varName];\n                }\n\n                return messageObj.parameters.shift();\n            });\n            this.clear();\n            this.errorMessages.push(message);\n\n            return true;\n        },\n\n\n        addSuccessMessage: function (message) {\n            return this.add(message, this.successMessages);\n        },\n\n\n        addErrorMessage: function (message) {\n            return this.add(message, this.errorMessages);\n        },\n\n\n        getErrorMessages: function () {\n            return this.errorMessages;\n        },\n\n\n        getSuccessMessages: function () {\n            return this.successMessages;\n        },\n\n\n        hasMessages: function () {\n            return this.errorMessages().length > 0 || this.successMessages().length > 0;\n        },\n\n\n        clear: function () {\n            this.errorMessages.removeAll();\n            this.successMessages.removeAll();\n        }\n    });\n});\n","Magento_Ui/js/view/messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'uiComponent',\n    '../model/messageList'\n], function (ko, $, Component, globalMessages) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Ui/messages',\n            selector: '[data-role=checkout-messages]',\n            isHidden: false,\n            listens: {\n                isHidden: 'onHiddenChange'\n            }\n        },\n\n        initialize: function (config, messageContainer) {\n            this._super()\n                .initObservable();\n\n            this.messageContainer = messageContainer || config.messageContainer || globalMessages;\n\n            return this;\n        },\n\n        initObservable: function () {\n            this._super()\n                .observe('isHidden');\n\n            return this;\n        },\n\n        isVisible: function () {\n            return this.isHidden(this.messageContainer.hasMessages());\n        },\n\n        removeAll: function () {\n            this.messageContainer.clear();\n        },\n\n        onHiddenChange: function (isHidden) {\n            var self = this;\n            // Hide message block if needed\n            if (isHidden) {\n                setTimeout(function () {\n                    $(self.selector).hide('blind', {}, 500)\n                }, 5000);\n            }\n        }\n    });\n});\n","Magento_PageCache/js/page-cache.js":"/**\n * Handles additional ajax request for rendering user private content\n *\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'domReady',\n    'jquery/ui',\n    'mage/cookies'\n], function ($, domReady) {\n    'use strict';\n\n    /**\n     * Nodes tree to flat list converter\n     * @returns {Array}\n     */\n    $.fn.comments = function () {\n        var elements = [];\n\n        /**\n         * @param {jQuery} element - Comment holder\n         */\n        (function lookup(element) {\n            $(element).contents().each(function (index, el) {\n                switch (el.nodeType) {\n                    case 1: // ELEMENT_NODE\n                        lookup(el);\n                        break;\n\n                    case 8: // COMMENT_NODE\n                        elements.push(el);\n                        break;\n\n                    case 9: // DOCUMENT_NODE\n                        var hostName = window.location.hostname,\n                            iFrameHostName = $('<a>')\n                                .prop('href', element.prop('src'))\n                                .prop('hostname');\n\n                        if (hostName === iFrameHostName) {\n                            lookup($(el).find('body'));\n                        }\n                        break;\n                }\n            });\n        })(this);\n\n        return elements;\n    };\n\n    /**\n     * FormKey Widget - this widget is generating from key, saves it to cookie and\n     */\n    $.widget('mage.formKey', {\n        options: {\n            inputSelector: 'input[name=\"form_key\"]',\n            allowedCharacters: '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',\n            length: 16\n        },\n\n        /**\n         * Creates widget 'mage.formKey'\n         * @private\n         */\n        _create: function () {\n            var formKey = $.mage.cookies.get('form_key');\n\n            if (!formKey) {\n                formKey = generateRandomString(this.options.allowedCharacters, this.options.length);\n                $.mage.cookies.set('form_key', formKey);\n            }\n            $(this.options.inputSelector).val(formKey);\n        }\n    });\n\n    /**\n     * PageCache Widget\n     */\n    $.widget('mage.pageCache', {\n        options: {\n            url: '/',\n            patternPlaceholderOpen: /^ BLOCK (.+) $/,\n            patternPlaceholderClose: /^ \\/BLOCK (.+) $/,\n            versionCookieName: 'private_content_version',\n            handles: []\n        },\n\n        /**\n         * Creates widget 'mage.pageCache'\n         * @private\n         */\n        _create: function () {\n            var placeholders,\n                version = $.mage.cookies.get(this.options.versionCookieName);\n\n            if (!version) {\n                return;\n            }\n            placeholders = this._searchPlaceholders(this.element.comments());\n\n            if (placeholders && placeholders.length) {\n                this._ajax(placeholders, version);\n            }\n        },\n\n        /**\n         * Parse page for placeholders.\n         * @param {Array} elements\n         * @returns {Array}\n         * @private\n         */\n        _searchPlaceholders: function (elements) {\n            var placeholders = [],\n                tmp = {},\n                ii,\n                len,\n                el, matches, name;\n\n            if (!(elements && elements.length)) {\n                return placeholders;\n            }\n\n            for (ii = 0, len = elements.length; ii < len; ii++) {\n                el = elements[ii];\n                matches = this.options.patternPlaceholderOpen.exec(el.nodeValue);\n                name = null;\n\n                if (matches) {\n                    name = matches[1];\n                    tmp[name] = {\n                        name: name,\n                        openElement: el\n                    };\n                } else {\n                    matches = this.options.patternPlaceholderClose.exec(el.nodeValue);\n\n                    if (matches) {\n                        name = matches[1];\n\n                        if (tmp[name]) {\n                            tmp[name].closeElement = el;\n                            placeholders.push(tmp[name]);\n                            delete tmp[name];\n                        }\n                    }\n                }\n            }\n\n            return placeholders;\n        },\n\n        /**\n         * Parse for page and replace placeholders\n         * @param {Object} placeholder\n         * @param {Object} html\n         * @protected\n         */\n        _replacePlaceholder: function (placeholder, html) {\n            if (!placeholder || !html) {\n                return;\n            }\n\n            var parent = $(placeholder.openElement).parent(),\n                contents = parent.contents(),\n                startReplacing = false,\n                prevSibling = null,\n                yy,\n                len,\n                element;\n\n            for (yy = 0, len = contents.length; yy < len; yy++) {\n                element = contents[yy];\n\n                if (element == placeholder.openElement) {\n                    startReplacing = true;\n                }\n\n                if (startReplacing) {\n                    $(element).remove();\n                } else if (element.nodeType != 8) {\n                    //due to comment tag doesn't have siblings we try to find it manually\n                    prevSibling = element;\n                }\n\n                if (element == placeholder.closeElement) {\n                    break;\n                }\n            }\n\n            if (prevSibling) {\n                $(prevSibling).after(html);\n            } else {\n                $(parent).prepend(html);\n            }\n\n            // trigger event to use mage-data-init attribute\n            $(parent).trigger('contentUpdated');\n        },\n\n        /**\n         * AJAX helper\n         * @param {Object} placeholders\n         * @param {String} version\n         * @private\n         */\n        _ajax: function (placeholders, version) {\n            var ii,\n                data = {\n                    blocks: [],\n                    handles: this.options.handles,\n                    originalRequest: this.options.originalRequest,\n                    version: version\n                };\n\n            for (ii = 0; ii < placeholders.length; ii++) {\n                data.blocks.push(placeholders[ii].name);\n            }\n            data.blocks = JSON.stringify(data.blocks.sort());\n            data.handles = JSON.stringify(data.handles);\n            data.originalRequest = JSON.stringify(data.originalRequest);\n            $.ajax({\n                url: this.options.url,\n                data: data,\n                type: 'GET',\n                cache: true,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * Response handler\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var placeholder, i;\n\n                    for (i = 0; i < placeholders.length; i++) {\n                        placeholder = placeholders[i];\n\n                        if (response.hasOwnProperty(placeholder.name)) {\n                            this._replacePlaceholder(placeholder, response[placeholder.name]);\n                        }\n                    }\n                }\n            });\n        }\n    });\n\n    domReady(function () {\n        $('body')\n            .formKey();\n    });\n\n    return {\n        'pageCache': $.mage.pageCache,\n        'formKey': $.mage.formKey\n    };\n\n    /**\n     * Helper. Generate random string\n     * TODO: Merge with mage/utils\n     * @param {String} chars - list of symbols\n     * @param {Number} length - length for need string\n     * @returns {String}\n     */\n    function generateRandomString(chars, length) {\n        var result = '';\n        length = length > 0 ? length : 1;\n\n        while (length--) {\n            result += chars[Math.round(Math.random() * (chars.length - 1))];\n        }\n\n        return result;\n    }\n});\n","Magento_Catalog/js/price-box.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'mage/template',\n    'jquery/ui'\n], function ($, utils, _, mageTemplate) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceConfig: null,\n        prices: {},\n        priceTemplate: '<span class=\"price\"><%- data.formatted %></span>'\n    };\n\n    $.widget('mage.priceBox', {\n        options: globalOptions,\n        cache: {},\n\n        /**\n         * Widget initialisation.\n         * Every time when option changed prices also can be changed. So\n         * changed options.prices -> changed cached prices -> recalculation -> redraw price box\n         */\n        _init: function initPriceBox() {\n            var box = this.element;\n            box.trigger('updatePrice');\n            this.cache.displayPrices = utils.deepClone(this.options.prices);\n        },\n\n        /**\n         * Widget creating.\n         */\n        _create: function createPriceBox() {\n            var box = this.element;\n\n            this._setDefaultsFromPriceConfig();\n            this._setDefaultsFromDataSet();\n\n            box.on('reloadPrice', this.reloadPrice.bind(this));\n            box.on('updatePrice', this.onUpdatePrice.bind(this));\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updatePrice method.\n         * @param {Event} event\n         * @param {Object} prices\n         */\n        onUpdatePrice: function onUpdatePrice(event, prices) {\n            return this.updatePrice(prices);\n        },\n\n        /**\n         * Updates price via new (or additional values).\n         * It expects object like this:\n         * -----\n         *   \"option-hash\":\n         *      \"price-code\":\n         *         \"amount\": 999.99999,\n         *         ...\n         * -----\n         * Empty option-hash object or empty price-code object treats as zero amount.\n         * @param {Object} newPrices\n         */\n        updatePrice: function updatePrice(newPrices) {\n            var prices = this.cache.displayPrices,\n                additionalPrice = {},\n                pricesCode = [];\n\n            this.cache.additionalPriceObject = this.cache.additionalPriceObject || {};\n\n            if (newPrices) {\n                $.extend(this.cache.additionalPriceObject, newPrices);\n            }\n\n            if (!_.isEmpty(additionalPrice)) {\n                pricesCode = _.keys(additionalPrice);\n            } else if (!_.isEmpty(prices)) {\n                pricesCode = _.keys(prices);\n            }\n\n            _.each(this.cache.additionalPriceObject, function (additional) {\n                if (additional && !_.isEmpty(additional)) {\n                    pricesCode = _.keys(additional);\n                }\n                _.each(pricesCode, function (priceCode) {\n                    var priceValue = additional[priceCode] || {};\n                    priceValue.amount = +priceValue.amount || 0;\n                    priceValue.adjustments = priceValue.adjustments || {};\n\n                    additionalPrice[priceCode] = additionalPrice[priceCode] || {\n                        'amount': 0,\n                        'adjustments': {}\n                    };\n                    additionalPrice[priceCode].amount =  0 + (additionalPrice[priceCode].amount || 0)\n                        + priceValue.amount;\n                    _.each(priceValue.adjustments, function (adValue, adCode) {\n                        additionalPrice[priceCode].adjustments[adCode] = 0\n                            + (additionalPrice[priceCode].adjustments[adCode] || 0) + adValue;\n                    });\n                });\n            });\n\n            if (_.isEmpty(additionalPrice)) {\n                this.cache.displayPrices = utils.deepClone(this.options.prices);\n            } else {\n                _.each(additionalPrice, function (option, priceCode) {\n                    var origin = this.options.prices[priceCode] || {},\n                        final = prices[priceCode] || {};\n                    option.amount = option.amount || 0;\n                    origin.amount = origin.amount || 0;\n                    origin.adjustments = origin.adjustments || {};\n                    final.adjustments = final.adjustments || {};\n\n                    final.amount = 0 + origin.amount + option.amount;\n                    _.each(option.adjustments, function (pa, paCode) {\n                        final.adjustments[paCode] = 0 + (origin.adjustments[paCode] || 0) + pa;\n                    });\n                }, this);\n            }\n\n            this.element.trigger('reloadPrice');\n        },\n\n        /**\n         * Render price unit block.\n         */\n        reloadPrice: function reDrawPrices() {\n            var priceFormat = (this.options.priceConfig && this.options.priceConfig.priceFormat) || {},\n                priceTemplate = mageTemplate(this.options.priceTemplate);\n\n            _.each(this.cache.displayPrices, function (price, priceCode) {\n                price.final = _.reduce(price.adjustments, function(memo, amount) {\n                    return memo + amount;\n                }, price.amount);\n\n                price.formatted = utils.formatPrice(price.final, priceFormat);\n\n                $('[data-price-type=\"' + priceCode + '\"]', this.element).html(priceTemplate({data: price}));\n            }, this);\n        },\n\n        /**\n         * Overwrites initial (default) prices object.\n         * @param {Object} prices\n         */\n        setDefault: function setDefaultPrices(prices) {\n            this.cache.displayPrices = utils.deepClone(prices);\n            this.options.prices = utils.deepClone(prices);\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge of accepted configuration.\n         * @param  {Object} options\n         * @return {mage.priceBox}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            if ('disabled' in options) {\n                this._setOption('disabled', options.disabled);\n            }\n\n            return this;\n        },\n\n        /**\n         * setDefaultsFromDataSet\n         */\n        _setDefaultsFromDataSet: function _setDefaultsFromDataSet() {\n            var box = this.element,\n                priceHolders = $('[data-price-type]', box),\n                prices = this.options.prices;\n            this.options.productId = box.data('productId');\n\n            if (_.isEmpty(prices)) {\n                priceHolders.each(function (index, element) {\n                    var type = $(element).data('priceType'),\n                        amount = parseFloat($(element).data('priceAmount'));\n\n                    if (type && !_.isNaN(amount)) {\n                        prices[type] = {\n                            amount: amount\n                        };\n                    }\n                });\n            }\n        },\n\n        /**\n         * setDefaultsFromPriceConfig\n         */\n        _setDefaultsFromPriceConfig: function _setDefaultsFromPriceConfig() {\n            var config = this.options.priceConfig;\n\n            if (config) {\n                if (+config.productId !== +this.options.productId) {\n                    return;\n                }\n                this.options.prices = config.prices;\n            }\n        }\n    });\n\n    return $.mage.priceBox;\n});\n","Magento_Catalog/js/price-option-date.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'priceUtils',\n    'priceOptions',\n    'jquery/ui'\n], function ($, utils) {\n    'use strict';\n\n    var globalOptions = {\n            fromSelector: 'form',\n            dropdownsSelector: '[data-role=calendar-dropdown]'\n        },\n        optionHandler = {};\n\n    optionHandler.optionHandlers = {};\n\n    $.widget('mage.priceOptionDate', {\n        options: globalOptions,\n\n        /**\n         * Function-initializer of priceOptionDate widget\n         * @private\n         */\n        _create: function initOptionDate() {\n            var field = this.element,\n                form = field.closest(this.options.fromSelector),\n                dropdowns = $(this.options.dropdownsSelector, field),\n                dateOptionId;\n\n            if (dropdowns.length) {\n                dateOptionId = this.options.dropdownsSelector + dropdowns.attr('name');\n\n                optionHandler.optionHandlers[dateOptionId] = onCalendarDropdownChange(dropdowns);\n\n                form.priceOptions(optionHandler);\n\n                dropdowns.data('role', dateOptionId);\n                dropdowns.on('change', onDateChange.bind(this, dropdowns));\n            }\n        }\n    });\n\n    return $.mage.priceOptionDate;\n\n    /**\n     * Custom handler for Date-with-Dropdowns option type.\n     * @param  {jQuery} siblings\n     * @return {Function} function that return object { optionHash : optionAdditionalPrice }\n     */\n    function onCalendarDropdownChange(siblings) {\n        return function (element, optionConfig, form) {\n            var changes = {},\n                optionId = utils.findOptionId(element),\n                overhead = optionConfig[optionId].prices,\n                isNeedToUpdate = true,\n                optionHash = 'price-option-calendar-' + optionId;\n\n            siblings.each(function (index, el) {\n                isNeedToUpdate = isNeedToUpdate && !!$(el).val();\n            });\n\n            overhead = isNeedToUpdate ? overhead : {};\n            changes[optionHash] = overhead;\n\n            return changes;\n        };\n    }\n\n    /**\n     * Adjusts the number of days in the day option element based on which month or year\n     * is selected (changed). Adjusts the days to 28, 29, 30, or 31 typically.\n     * @param {jQuery} dropdowns\n     */\n    function onDateChange(dropdowns) {\n        var daysNodes,\n            curMonth, curYear, expectedDays,\n            options, needed,\n            month = dropdowns.filter('[data-calendar-role=month]'),\n            year = dropdowns.filter('[data-calendar-role=year]');\n\n        if (month.length && year.length) {\n            daysNodes = dropdowns.filter('[data-calendar-role=day]').find('option');\n\n            curMonth = month.val() || '01';\n            curYear = year.val() || '2000';\n            expectedDays = getDaysInMonth(curMonth, curYear);\n\n            if (daysNodes.length - 1 > expectedDays) { // remove unnecessary option nodes\n                daysNodes.each(function (i, e) {\n                    if (e.value > expectedDays) {\n                        $(e).remove();\n                    }\n                });\n            } else if (daysNodes.length - 1 < expectedDays) { // add missing option nodes\n                options = [];\n                needed = expectedDays - daysNodes.length + 1;\n\n                while (needed--) {\n                    options.push('<option value=\"' + (expectedDays - needed) + '\">' + (expectedDays - needed) + '</option>');\n                }\n                $(options.join('')).insertAfter(daysNodes.last());\n            }\n        }\n    }\n\n    /**\n     * Returns number of days for special month and year\n     * @param  {Number} month\n     * @param  {Number} year\n     * @return {Number}\n     */\n    function getDaysInMonth(month, year) {\n        return new Date(year, month, 0).getDate();\n    }\n});\n","Magento_Catalog/js/price-option-file.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.priceOptionFile', {\n        options: {\n            fileName: '',\n            fileNamed: '',\n            fieldNameAction: '',\n            changeFileSelector: '',\n            deleteFileSelector: ''\n        },\n\n        /**\n         * Creates instance of widget\n         * @private\n         */\n        _create: function () {\n            this.fileDeleteFlag = this.fileChangeFlag = false;\n            this.inputField = this.element.find('input[name=' + this.options.fileName + ']')[0];\n            this.inputFieldAction = this.element.find('input[name=' + this.options.fieldNameAction + ']')[0];\n            this.fileNameSpan = this.element.parent('dd').find('.' + this.options.fileNamed);\n\n            $(this.options.changeFileSelector).on('click', $.proxy(function () {\n                this._toggleFileChange();\n            }, this));\n            $(this.options.deleteFileSelector).on('click', $.proxy(function () {\n                this._toggleFileDelete();\n            }, this));\n        },\n\n        /**\n         * Toggles whether the current file is being changed or not. If the file is being deleted\n         * then the option to change the file is disabled.\n         * @private\n         */\n        _toggleFileChange: function () {\n            this.element.toggle();\n            this.fileChangeFlag = !this.fileChangeFlag;\n\n            if (!this.fileDeleteFlag) {\n                $(this.inputFieldAction).attr('value', this.fileChangeFlag ? 'save_new' : 'save_old');\n                this.inputField.disabled = !this.fileChangeFlag;\n            }\n        },\n\n        /**\n         * Toggles whether the file is to be deleted. When the file is being deleted, the name of\n         * the file is decorated with strike-through text and the option to change the file is\n         * disabled.\n         * @private\n         */\n        _toggleFileDelete: function () {\n            this.fileDeleteFlag = $(this.options.deleteFileSelector + ':checked').val();\n            $(this.inputFieldAction).attr('value',\n                this.fileDeleteFlag ? '' : this.fileChangeFlag ? 'save_new' : 'save_old');\n            this.inputField.disabled = this.fileDeleteFlag || !this.fileChangeFlag;\n            this.fileNameSpan.css('text-decoration', this.fileDeleteFlag ? 'line-through' : 'none');\n        }\n    });\n\n    return $.mage.priceOptionFile;\n});","Magento_Catalog/js/price-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery/ui'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        optionTemplate: '<%= data.label %>' +\n        '<% if (data.finalPrice.value) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd'\n    };\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            $(this.options.optionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions() {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') && priceBox.priceBox('option') && priceBox.priceBox('option').priceConfig) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event) {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionName = $element.prop('name'),\n                    optionType = $element.prop('type');\n                var  optionConfig = config.optionConfig && config.optionConfig[optionId];\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue] ? optionConfig[optionValue].prices : null;\n\n                    if (prices) {\n                        _.each(prices, function (price, type) {\n                            var value = +(price.amount);\n                            value += _.reduce(price.adjustments, function (sum, x) {\n                                return sum + x;\n                            }, 0);\n                            toTemplate.data[type] = {\n                                value: value,\n                                formatted: utils.formatPrice(value, format)\n                            };\n                        });\n\n                        $option.text(template(toTemplate));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         * @private\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n            this._super(options);\n\n            return this;\n        }\n    });\n\n    return $.mage.priceOptions;\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig) {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n});\n","Magento_Catalog/js/price-utils.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var globalPriceFormat = {\n        requiredPrecision: 2,\n        integerRequired: 1,\n        decimalSymbol: ',',\n        groupSymbol: ',',\n        groupLength: ','\n    };\n\n    return {\n        formatPrice: formatPrice,\n        deepClone: objectDeepClone,\n        strPad: stringPad,\n        findOptionId: findOptionId\n    };\n\n    /**\n     * Formatter for price amount\n     * @param  {Number}  amount\n     * @param  {Object}  format\n     * @param  {Boolean} isShowSign\n     * @return {String}              Formatted value\n     */\n    function formatPrice(amount, format, isShowSign) {\n        format = _.extend(globalPriceFormat, format);\n\n        // copied from price-option.js | Could be refactored with varien/js.js\n\n        var precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision,\n            integerRequired = isNaN(format.integerRequired = Math.abs(format.integerRequired)) ? 1 : format.integerRequired,\n            decimalSymbol = format.decimalSymbol === undefined ? ',' : format.decimalSymbol,\n            groupSymbol = format.groupSymbol === undefined ? '.' : format.groupSymbol,\n            groupLength = format.groupLength === undefined ? 3 : format.groupLength,\n            pattern = format.pattern || '%s',\n            s = '',\n            i, pad,\n            j, re, r, am;\n\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : (isShowSign ? '+' : '');\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n\n        // we're avoiding the usage of to fixed, and using round instead with the e representation to address\n        // numbers like 1.005 = 1.01. Using ToFixed to only provide trailig zeroes in case we have a whole number\n        i = parseInt(amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision)) , 10) + '';\n        pad = (i.length < integerRequired) ? (integerRequired - i.length) : 0;\n\n        i = stringPad('0', pad) + i;\n\n        j = i.length > groupLength ? i.length % groupLength : 0;\n        re = new RegExp('(\\\\d{' + groupLength + '})(?=\\\\d)', 'g');\n\n        // replace(/-/, 0) is only for fixing Safari bug which appears\n        // when Math.abs(0).toFixed() executed on '0' number.\n        // Result is '0.-0' :(\n\n\n        am = Number(Math.round(Math.abs(amount - i) + 'e+' + precision) + ('e-' + precision));\n        r = (j ? i.substr(0, j) + groupSymbol : '') +\n            i.substr(j).replace(re, '$1' + groupSymbol) +\n            (precision ? decimalSymbol + am.toFixed(2).replace(/-/, 0).slice(2) : '');\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Repeats {string} {times} times\n     * @param  {String} string\n     * @param  {Number} times\n     * @return {String}\n     */\n    function stringPad(string, times) {\n        return (new Array(times + 1)).join(string);\n    }\n\n    /**\n     * Deep clone of Object. Doesn't support functions\n     * @param {Object} obj\n     * @return {Object}\n     */\n    function objectDeepClone(obj) {\n        return JSON.parse(JSON.stringify(obj));\n    }\n\n    /**\n     * Helper to find ID in name attribute\n     * @param   {jQuery} element\n     * @returns {undefined|String}\n     */\n    function findOptionId(element) {\n        if (!element) {\n            return;\n        }\n        var re, id,\n            name = $(element).attr('name');\n\n        if (name.indexOf('[') !== -1) {\n            re = /\\[([^\\]]+)?\\]/;\n        } else {\n            re = /_([^\\]]+)?_/; // just to support file-type-option\n        }\n        id = re.exec(name) && re.exec(name)[1];\n\n        if (id) {\n            return id;\n        }\n    }\n});\n","Magento_Catalog/js/catalog-add-to-cart.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery/ui'\n], function($, $t) {\n    \"use strict\";\n\n    $.widget('mage.catalogAddToCart', {\n\n        options: {\n            processStart: null,\n            processStop: null,\n            bindSubmit: true,\n            minicartSelector: '[data-block=\"minicart\"]',\n            messagesSelector: '[data-placeholder=\"messages\"]',\n            productStatusSelector: '.stock.available',\n            addToCartButtonSelector: '.action.tocart',\n            addToCartButtonDisabledClass: 'disabled',\n            addToCartButtonTextWhileAdding: '',\n            addToCartButtonTextAdded: '',\n            addToCartButtonTextDefault: ''\n        },\n\n        _create: function() {\n            if (this.options.bindSubmit) {\n                this._bindSubmit();\n            }\n        },\n\n        _bindSubmit: function() {\n            var self = this;\n            this.element.on('submit', function(e) {\n                e.preventDefault();\n                self.submitForm($(this));\n            });\n        },\n\n        isLoaderEnabled: function() {\n            return this.options.processStart && this.options.processStop;\n        },\n\n        /**\n         * Handler for the form 'submit' event\n         *\n         * @param {Object} form\n         */\n        submitForm: function (form) {\n            var addToCartButton, self = this;\n\n            if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                self.element.off('submit');\n                // disable 'Add to Cart' button\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                addToCartButton.prop('disabled', true);\n                addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                form.submit();\n            } else {\n                self.ajaxSubmit(form);\n            }\n        },\n\n        ajaxSubmit: function(form) {\n            var self = this;\n            $(self.options.minicartSelector).trigger('contentLoading');\n            self.disableAddToCartButton(form);\n\n            $.ajax({\n                url: form.attr('action'),\n                data: form.serialize(),\n                type: 'post',\n                dataType: 'json',\n                beforeSend: function() {\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStart);\n                    }\n                },\n                success: function(res) {\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStop);\n                    }\n\n                    if (res.backUrl) {\n                        window.location = res.backUrl;\n                        return;\n                    }\n                    if (res.messages) {\n                        $(self.options.messagesSelector).html(res.messages);\n                    }\n                    if (res.minicart) {\n                        $(self.options.minicartSelector).replaceWith(res.minicart);\n                        $(self.options.minicartSelector).trigger('contentUpdated');\n                    }\n                    if (res.product && res.product.statusText) {\n                        $(self.options.productStatusSelector)\n                            .removeClass('available')\n                            .addClass('unavailable')\n                            .find('span')\n                            .html(res.product.statusText);\n                    }\n                    self.enableAddToCartButton(form);\n                }\n            });\n        },\n\n        disableAddToCartButton: function(form) {\n            var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...');\n            var addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n            addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n            addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n            addToCartButton.attr('title', addToCartButtonTextWhileAdding);\n        },\n\n        enableAddToCartButton: function(form) {\n            var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added');\n            var self = this,\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.find('span').text(addToCartButtonTextAdded);\n            addToCartButton.attr('title', addToCartButtonTextAdded);\n\n            setTimeout(function() {\n                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n                addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                addToCartButton.find('span').text(addToCartButtonTextDefault);\n                addToCartButton.attr('title', addToCartButtonTextDefault);\n            }, 1000);\n        }\n    });\n\n    return $.mage.catalogAddToCart;\n});\n","Magento_Catalog/js/compare.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global confirm:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"mage/decorate\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.compareItems', {\n        _create: function() {\n            this.element.decorate('list', true);\n            this._confirm(this.options.removeSelector, this.options.removeConfirmMessage);\n            this._confirm(this.options.clearAllSelector, this.options.clearAllConfirmMessage);\n        },\n\n        /**\n         * Set up a click event on the given selector to display a confirmation request message\n         * and ask for that confirmation.\n         * @param selector Selector for the confirmation on click event\n         * @param message Message to display asking for confirmation to perform action\n         * @private\n         */\n        _confirm: function(selector, message) {\n            $(selector).on('click', function() {\n                return confirm(message);\n            });\n        }\n    });\n\n    return $.mage.compareItems;\n});","Magento_Catalog/js/gallery.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true, jquery:true*/\n(function (factory) {\n    if (typeof define === \"function\" && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/ui\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    \"use strict\";\n\n    $.widget('mage.gallery', {\n        options: {\n            minWidth: 300, // Minimum width of the gallery image.\n            widthOffset: 90, // Offset added to the width of the gallery image.\n            heightOffset: 210, // Offset added to the height of the gallery image.\n            closeWindow: \"div.buttons-set a[role='close-window']\" // Selector for closing the gallery popup window.\n        },\n\n        /**\n         * Bind click handler for closing the popup window and resize the popup based on the image size.\n         * @private\n         */\n        _create: function() {\n            $(this.options.closeWindow).on('click', function() { window.close(); });\n            this._resizeWindow();\n        },\n\n        /**\n         * Resize the gallery image popup window based on the image's dimensions.\n         * @private\n         */\n        _resizeWindow: function() {\n            var img = this.element,\n                width = img.width() < this.options.minWidth ? this.options.minWidth : img.width();\n            window.resizeTo(width + this.options.widthOffset, img.height() + this.options.heightOffset);\n        }\n    });\n    \n    return $.mage.gallery;\n}));","Magento_Catalog/js/list.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.compareList', {\n        _create: function() {\n\n            var elem = this.element,\n                products = $('thead td', elem);\n\n            if (products.length > this.options.productsInRow) {\n                var headings = $('<table/>')\n                    .addClass('comparison headings data table')\n                    .insertBefore(elem.closest('.container'));\n                    \n                elem.addClass('scroll');\n\n                $('th', elem).each(function(){\n                    var th = $(this),\n                        thCopy = th.clone();\n\n                    th.animate({\n                        top: '+=0'\n                    }, 50, function(){\n                        var height = th.height();\n                        \n                        thCopy.css('height', height)\n                            .appendTo(headings)\n                            .wrap('<tr />');\n                    });\n                });\n            }\n\n            $(this.options.windowPrintSelector).on('click', function(e) {\n                e.preventDefault();\n                window.print();\n            });\n        }\n    });\n\n    return $.mage.compareList;\n});","Magento_Catalog/js/related-products.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"mage/translate\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.relatedProducts', {\n        options: {\n            relatedCheckbox: '.related-checkbox', // Class name for a related product's input checkbox.\n            relatedProductsCheckFlag: false, // Related products checkboxes are initially unchecked.\n            relatedProductsField: '#related-products-field', // Hidden input field that stores related products.\n            selectAllMessage: $.mage.__('select all'),\n            unselectAllMessage: $.mage.__('unselect all'),\n            selectAllLink: \"[role='select-all']\",\n            elementsSelector: \".item.product\"\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function() {\n            $(this.options.selectAllLink).on('click', $.proxy(this._selectAllRelated, this));\n            $(this.options.relatedCheckbox).on('click', $.proxy(this._addRelatedToProduct, this));\n            this._showRelatedProducts(\n                this.element.find(this.options.elementsSelector),\n                this.element.data('limit'),\n                this.element.data('shuffle')\n            );\n        },\n\n        /**\n         * This method either checks all checkboxes for a product's set of related products (select all)\n         * or unchecks them (unselect all).\n         * @private\n         * @param e - Click event on either the \"select all\" link or the \"unselect all\" link.\n         * @return {Boolean} - Prevent default event action and event propagation.\n         */\n        _selectAllRelated: function(e) {\n            var innerHTML = this.options.relatedProductsCheckFlag ?\n                this.options.selectAllMessage : this.options.unselectAllMessage;\n            $(e.target).html(innerHTML);\n            $(this.options.relatedCheckbox).attr('checked',\n                this.options.relatedProductsCheckFlag = !this.options.relatedProductsCheckFlag);\n            this._addRelatedToProduct();\n            return false;\n        },\n\n        /**\n         * This method iterates through each checkbox for all related products and collects only those products\n         * whose checkbox has been checked. The selected related products are stored in a hidden input field.\n         * @private\n         */\n        _addRelatedToProduct: function() {\n            $(this.options.relatedProductsField).val(\n                $(this.options.relatedCheckbox + ':checked').map(function() {\n                    return this.value;\n                }).get().join(',')\n            );\n        },\n\n        /**\n         * Show related products according to limit. Shuffle if needed.\n         * @param elements\n         * @param limit\n         * @param shuffle\n         * @private\n         */\n        _showRelatedProducts: function(elements, limit, shuffle) {\n            if (shuffle) {\n                this._shuffle(elements);\n            }\n            if (limit === 0) {\n                limit = elements.length;\n            }\n            for (var index = 0; index < limit; index++) {\n                $(elements[index]).show();\n            }\n        },\n\n        /**\n         * Shuffle an array\n         * @param o\n         * @returns {*}\n         */\n        _shuffle: function shuffle(o){ //v1.0\n            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);\n            return o;\n        }\n    });\n\n    return $.mage.relatedProducts;\n});","Magento_Catalog/js/upsell-products.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.upsellProducts', {\n        options: {\n            elementsSelector: \".item.product\"\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function() {\n            this._showUpsellProducts(\n                this.element.find(this.options.elementsSelector),\n                this.element.data('limit'),\n                this.element.data('shuffle')\n            );\n        },\n\n        /**\n         * Show upsell products according to limit. Shuffle if needed.\n         * @param elements\n         * @param limit\n         * @param shuffle\n         * @private\n         */\n        _showUpsellProducts: function(elements, limit, shuffle) {\n            if (shuffle) {\n                this._shuffle(elements);\n            }\n            if (limit === 0) {\n                limit = elements.length;\n            }\n            for (var index = 0; index < limit; index++) {\n                $(this.element).find(elements[index]).show();\n            }\n        },\n\n        /**\n         * Shuffle an array\n         * @param o\n         * @returns {*}\n         */\n        _shuffle: function shuffle(o){ //v1.0\n            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);\n            return o;\n        }\n    });\n\n    return $.mage.upsellProducts;\n});","Magento_Catalog/js/product/list/toolbar.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n\n], function($) {\n    /**\n     * ProductListToolbarForm Widget - this widget is setting cookie and submitting form according to toolbar controls\n     */\n    $.widget('mage.productListToolbarForm', {\n\n        options: {\n            modeControl: '[data-role=\"mode-switcher\"]',\n            directionControl: '[data-role=\"direction-switcher\"]',\n            orderControl: '[data-role=\"sorter\"]',\n            limitControl: '[data-role=\"limiter\"]',\n            mode: 'product_list_mode',\n            direction: 'product_list_dir',\n            order: 'product_list_order',\n            limit: 'product_list_limit',\n            modeDefault: 'grid',\n            directionDefault: 'asc',\n            orderDefault: 'position',\n            limitDefault: '9',\n            url: ''\n        },\n\n        _create: function () {\n            this._bind($(this.options.modeControl), this.options.mode, this.options.modeDefault);\n            this._bind($(this.options.directionControl), this.options.direction, this.options.directionDefault);\n            this._bind($(this.options.orderControl), this.options.order, this.options.orderDefault);\n            this._bind($(this.options.limitControl), this.options.limit, this.options.limitDefault);\n        },\n\n        _bind: function (element, paramName, defaultValue) {\n            if (element.is(\"select\")) {\n                element.on('change', {paramName: paramName, default: defaultValue}, $.proxy(this._processSelect, this));\n            } else {\n                element.on('click', {paramName: paramName, default: defaultValue}, $.proxy(this._processLink, this));\n            }\n        },\n\n        _processLink: function (event) {\n            event.preventDefault();\n            this.changeUrl(\n                event.data.paramName,\n                $(event.currentTarget).data('value'),\n                event.data.default\n            );\n        },\n\n        _processSelect: function (event) {\n            this.changeUrl(\n                event.data.paramName,\n                event.currentTarget.options[event.currentTarget.selectedIndex].value,\n                event.data.default\n            );\n        },\n\n        changeUrl: function (paramName, paramValue, defaultValue) {\n            var decode = window.decodeURIComponent;\n            var urlPaths = this.options.url.split('?'),\n                baseUrl = urlPaths[0],\n                urlParams = urlPaths[1] ? urlPaths[1].split('&') : [],\n                paramData = {},\n                parameters;\n            for (var i = 0; i < urlParams.length; i++) {\n                parameters = urlParams[i].split('=');\n                paramData[decode(parameters[0])] = parameters[1] !== undefined\n                    ? decode(parameters[1].replace(/\\+/g, '%20'))\n                    : '';\n            }\n            paramData[paramName] = paramValue;\n            if (paramValue == defaultValue) {\n                delete paramData[paramName];\n            }\n            paramData = $.param(paramData);\n\n            location.href = baseUrl + (paramData.length ? '?' + paramData : '');\n        }\n    });\n\n    return $.mage.productListToolbarForm;\n});\n","Magento_Catalog/js/view/compare-products.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    var sidebarInitialized = false;\n\n    function initSidebar() {\n        if (sidebarInitialized) {\n            return ;\n        }\n        sidebarInitialized = true;\n        require([\n            'jquery',\n            'mage/mage'\n        ], function ($) {\n            $('[data-role=compare-products-sidebar]').mage('compareItems', {\n                \"removeConfirmMessage\": $.mage.__(\n                    \"Are you sure you want to remove this item from your Compare Products list?\"\n                ),\n                \"removeSelector\": \"#compare-items a.action.delete\",\n                \"clearAllConfirmMessage\": $.mage.__(\n                    \"Are you sure you want to remove all items from your Compare Products list?\"\n                ),\n                \"clearAllSelector\": \"#compare-clear-all\"\n            });\n        });\n    }\n\n    return Component.extend({\n        initialize: function () {\n            this._super();\n            this.compareProducts = customerData.get('compare-products');\n\n            initSidebar();\n        }\n    });\n});\n","Magento_Catalog/js/view/image.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        initialize: function () {\n            this._super();\n\n            this.template = window.checkout.imageTemplate || this.template;\n        }\n    });\n});\n","Magento_Catalog/product/view/validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui',\n            'mage/validation/validation'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n    \n    $.widget('mage.validation', $.mage.validation, {\n        options: {\n            radioCheckboxClosest: 'ul, ol',\n            errorPlacement: function (error, element) {\n                var messageBox,\n                    dataValidate;\n\n                if ($(element).hasClass('datetime-picker')) {\n                    element = $(element).parent();\n\n                    if (element.parent().find('[generated=true].mage-error').length) {\n                        return;\n                    }\n                }\n\n                if (element.attr('data-errors-message-box')) {\n                    messageBox = $(element.attr('data-errors-message-box'));\n                    messageBox.html(error);\n\n                    return;\n                }\n\n                dataValidate = element.attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-one-checkbox-required-by-name') > 0) {\n                    error.appendTo('#links-advice-container');\n                } else if (element.is(':radio, :checkbox')) {\n                    element.closest(this.radioCheckboxClosest).after(error);\n                } else {\n                    element.after(error);\n                }\n            },\n            highlight: function (element, errorClass) {\n                var dataValidate = $(element).attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                    $(element).parent().find('.datetime-picker').each(function() {\n                        $(this).removeClass(errorClass);\n                        if ($(this).val().length === 0) {\n                            $(this).addClass(errorClass);\n                        }\n                    });\n                } else if ($(element).is(':radio, :checkbox')) {\n                    $(element).closest(this.radioCheckboxClosest).addClass(errorClass);\n                } else {\n                    $(element).addClass(errorClass);\n                }\n            },\n            unhighlight: function (element, errorClass) {\n                var dataValidate = $(element).attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                    $(element).parent().find('.datetime-picker').removeClass(errorClass);\n                } else if ($(element).is(':radio, :checkbox')) {\n                    $(element).closest(this.radioCheckboxClosest).removeClass(errorClass);\n                } else {\n                    $(element).removeClass(errorClass);\n                }\n            }\n        }\n    });\n\n    return $.mage.validation;\n}));","Magento_Customer/address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true, jquery:true*/\n/*global confirm:true*/\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/confirm',\n    \"jquery/ui\",\n    \"mage/translate\"\n], function($, confirm){\n    \"use strict\";\n    \n    $.widget('mage.address', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            deleteConfirmMessage: $.mage.__('Are you sure you want to delete this address?')\n        },\n\n        /**\n         * Bind event handlers for adding and deleting addresses.\n         * @private\n         */\n        _create: function() {\n            var options         = this.options,\n                addAddress      = options.addAddress,\n                deleteAddress   = options.deleteAddress;\n\n            if( addAddress ){\n                $(document).on('click', addAddress, this._addAddress.bind(this));\n            }\n            \n            if( deleteAddress ){\n                $(document).on('click', deleteAddress, this._deleteAddress.bind(this));\n            }\n        },\n\n        /**\n         * Add a new address.\n         * @private\n         */\n        _addAddress: function() {\n            window.location = this.options.addAddressLocation;\n        },\n\n        /**\n         * Delete the address whose id is specified in a data attribute after confirmation from the user.\n         * @private\n         * @param {Event}\n         * @return {Boolean}\n         */\n        _deleteAddress: function(e) {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteConfirmMessage,\n                actions: {\n                    confirm: function() {\n                        if (typeof $(e.target).parent().data('address') !== 'undefined') {\n                            window.location = self.options.deleteUrlPrefix + $(e.target).parent().data('address')\n                                + '/form_key/' + $.mage.cookies.get('form_key');\n                        }\n                        else {\n                            window.location = self.options.deleteUrlPrefix + $(e.target).data('address')\n                                + '/form_key/' + $.mage.cookies.get('form_key');\n                        }\n                    }\n                }\n            });\n\n            return false;\n        }\n    });\n    \n    return $.mage.address;\n});","Magento_Customer/change-email-password.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true expr:true*/\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.changeEmailPassword', {\n        options: {\n            changeEmailSelector: '[data-role=change-email]',\n            changePasswordSelector: '[data-role=change-password]',\n            mainContainerSelector: '[data-container=change-email-password]',\n            titleSelector: '[data-title=change-email-password]',\n            emailContainerSelector: '[data-container=change-email]',\n            newPasswordContainerSelector: '[data-container=new-password]',\n            confirmPasswordContainerSelector: '[data-container=confirm-password]',\n            currentPasswordSelector: '[data-input=current-password]',\n            emailSelector: '[data-input=change-email]',\n            newPasswordSelector: '[data-input=new-password]',\n            confirmPasswordSelector: '[data-input=confirm-password]'\n        },\n\n        /**\n         * Create widget\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(function () {\n                this._checkChoice();\n            }, this));\n\n            this._checkChoice();\n        },\n\n        /**\n         * Check choice\n         * @private\n         */\n        _checkChoice: function () {\n            if ($(this.options.changeEmailSelector).is(':checked') &&\n                $(this.options.changePasswordSelector).is(':checked')) {\n                this._showAll();\n            } else if ($(this.options.changeEmailSelector).is(':checked')) {\n                this._showEmail();\n            } else if ($(this.options.changePasswordSelector).is(':checked')) {\n                this._showPassword();\n            } else {\n                this._hideAll();\n            }\n        },\n\n        /**\n         * Show email and password input fields\n         * @private\n         */\n        _showAll: function () {\n            $(this.options.titleSelector).html(this.options.titleChangeEmailAndPassword);\n\n            $(this.options.mainContainerSelector).show();\n            $(this.options.emailContainerSelector).show();\n            $(this.options.newPasswordContainerSelector).show();\n            $(this.options.confirmPasswordContainerSelector).show();\n\n            $(this.options.currentPasswordSelector).attr('data-validate', '{required:true}').prop('disabled', false);\n            $(this.options.emailSelector).attr('data-validate', '{required:true}').prop('disabled', false);\n            $(this.options.newPasswordSelector).attr(\n                'data-validate',\n                '{required:true, \\'validate-customer-password\\':true}'\n            ).prop('disabled', false);\n            $(this.options.confirmPasswordSelector).attr(\n                'data-validate',\n                '{required:true, equalTo:\"' + this.options.newPasswordSelector + '\"}'\n            ).prop('disabled', false);\n        },\n\n        /**\n         * Hide email and password input fields\n         * @private\n         */\n        _hideAll: function () {\n            $(this.options.mainContainerSelector).hide();\n            $(this.options.emailContainerSelector).hide();\n            $(this.options.newPasswordContainerSelector).hide();\n            $(this.options.confirmPasswordContainerSelector).hide();\n\n            $(this.options.currentPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.emailSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.newPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.confirmPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Show email input fields\n         * @private\n         */\n        _showEmail: function () {\n            this._showAll();\n            $(this.options.titleSelector).html(this.options.titleChangeEmail);\n\n            $(this.options.newPasswordContainerSelector).hide();\n            $(this.options.confirmPasswordContainerSelector).hide();\n\n            $(this.options.newPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.confirmPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Show password input fields\n         * @private\n         */\n        _showPassword: function () {\n            this._showAll();\n            $(this.options.titleSelector).html(this.options.titleChangePassword);\n\n            $(this.options.emailContainerSelector).hide();\n\n            $(this.options.emailSelector).removeAttr('data-validate').prop('disabled', true);\n        }\n    });\n\n    return $.mage.changeEmailPassword;\n});\n","Magento_Customer/js/checkout-balance.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.checkoutBalance', {\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function() {\n            this.eventData = {\n                price: this.options.balance,\n                totalPrice: 0\n            };\n            this.element.on('change', $.proxy(function(e) {\n                if ($(e.target).is(':checked')) {\n                    this.eventData.price = -1 * this.options.balance;\n                } else {\n                    if (this.options.amountSubstracted) {\n                        this.eventData.price = this.options.usedAmount;\n                        this.options.amountSubstracted = false;\n                    } else {\n                        this.eventData.price = this.options.balance;\n                    }\n                }\n                this.element.trigger('updateCheckoutPrice', this.eventData);\n            }, this));\n        }\n    });\n\n    return $.mage.checkoutBalance;\n});","Magento_Customer/js/customer-data.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'Magento_Customer/js/section-config',\n    'mage/storage',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, sectionConfig, mageStorage) {\n    'use strict';\n\n    var options,\n        storage,\n        storageInvalidation,\n        invalidateCacheBySessionTimeOut,\n        invalidateCacheByCloseCookieSession,\n        dataProvider,\n        buffer,\n        customerData;\n\n    //TODO: remove global change, in this case made for initNamespaceStorage\n    $.cookieStorage.setConf({\n        path: '/'\n    });\n\n    storage = $.initNamespaceStorage('mage-cache-storage').localStorage;\n    storageInvalidation = $.initNamespaceStorage('mage-cache-storage-section-invalidation').localStorage;\n\n    /**\n     * @param {Object} invalidateOptions\n     */\n    invalidateCacheBySessionTimeOut = function (invalidateOptions) {\n        var date;\n\n        if (new Date($.localStorage.get('mage-cache-timeout')) < new Date()) {\n            storage.removeAll();\n            date = new Date(Date.now() + parseInt(invalidateOptions.cookieLifeTime, 10) * 1000);\n            $.localStorage.set('mage-cache-timeout', date);\n        }\n    };\n\n    /**\n     * Invalidate Cache By Close Cookie Session\n     */\n    invalidateCacheByCloseCookieSession = function () {\n        if (!$.cookieStorage.isSet('mage-cache-sessid')) {\n            $.cookieStorage.set('mage-cache-sessid', true);\n            storage.removeAll();\n        }\n    };\n\n    dataProvider = {\n\n        /**\n         * @param {Object} sectionNames\n         * @return {Object}\n         */\n        getFromStorage: function (sectionNames) {\n            var result = {};\n\n            _.each(sectionNames, function (sectionName) {\n                result[sectionName] = storage.get(sectionName);\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {Object} sectionNames\n         * @param {Number} updateSectionId\n         * @return {*}\n         */\n        getFromServer: function (sectionNames, updateSectionId) {\n            var parameters;\n\n            sectionNames = sectionConfig.filterClientSideSections(sectionNames);\n            parameters = _.isArray(sectionNames) ? {\n                sections: sectionNames.join(',')\n            } : [];\n            parameters['update_section_id'] = updateSectionId;\n\n            return $.getJSON(options.sectionLoadUrl, parameters).fail(function (jqXHR) {\n                throw new Error(jqXHR);\n            });\n        }\n    };\n\n    /**\n     * @param {Function} target\n     * @param {String} sectionName\n     * @return {*}\n     */\n    ko.extenders.disposableCustomerData = function (target, sectionName) {\n        var sectionDataIds, newSectionDataIds = {};\n        target.subscribe(function () {\n            setTimeout(function () {\n                storage.remove(sectionName);\n                sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n                _.each(sectionDataIds, function (data, name) {\n                    if (name != sectionName) {\n                        newSectionDataIds[name] = data;\n                    }\n                });\n                $.cookieStorage.set('section_data_ids', newSectionDataIds);\n            }, 3000);\n        });\n\n        return target;\n    };\n\n    buffer = {\n        data: {},\n\n        /**\n         * @param {String} sectionName\n         */\n        bind: function (sectionName) {\n            this.data[sectionName] = ko.observable({});\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {Object}\n         */\n        get: function (sectionName) {\n            if (!this.data[sectionName]) {\n                this.bind(sectionName);\n            }\n\n            return this.data[sectionName];\n        },\n\n        /**\n         * @return {Array}\n         */\n        keys: function () {\n            return _.keys(this.data);\n        },\n\n        /**\n         * @param {String} sectionName\n         * @param {Object} sectionData\n         */\n        notify: function (sectionName, sectionData) {\n            if (!this.data[sectionName]) {\n                this.bind(sectionName);\n            }\n            this.data[sectionName](sectionData);\n        },\n\n        /**\n         * @param {Object} sections\n         */\n        update: function (sections) {\n            var sectionId = 0,\n                sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n\n            _.each(sections, function (sectionData, sectionName) {\n                sectionId = sectionData['data_id'];\n                sectionDataIds[sectionName] = sectionId;\n                storage.set(sectionName, sectionData);\n                storageInvalidation.remove(sectionName);\n                buffer.notify(sectionName, sectionData);\n            });\n            $.cookieStorage.set('section_data_ids', sectionDataIds);\n        },\n\n        /**\n         * @param {Object} sections\n         */\n        remove: function (sections) {\n            _.each(sections, function (sectionName) {\n                storage.remove(sectionName);\n                if (!sectionConfig.isClientSideSection(sectionName)) {\n                    storageInvalidation.set(sectionName, true);\n                }\n            });\n        }\n    };\n\n    customerData = {\n\n        /**\n         * Customer data initialization\n         */\n        init: function() {\n            var countryData,\n                privateContent = $.cookieStorage.get('private_content_version');\n\n            if (_.isEmpty(storage.keys())) {\n                if (!_.isEmpty(privateContent)) {\n                    this.reload([], false);\n                }\n            } else if (this.needReload()) {\n                _.each(dataProvider.getFromStorage(storage.keys()), function (sectionData, sectionName) {\n                    buffer.notify(sectionName, sectionData);\n                });\n                this.reload(this.getExpiredKeys(), false);\n            } else {\n                _.each(dataProvider.getFromStorage(storage.keys()), function (sectionData, sectionName) {\n                    buffer.notify(sectionName, sectionData);\n                });\n\n                if (!_.isEmpty(storageInvalidation.keys())) {\n                    this.reload(storageInvalidation.keys(), false);\n                }\n            }\n\n            if (!_.isEmpty(privateContent)) {\n                countryData = this.get('directory-data');\n                if (_.isEmpty(countryData())) {\n                    customerData.reload(['directory-data'], false);\n                }\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        needReload: function () {\n            var cookieSections = $.cookieStorage.get('section_data_ids'),\n                storageVal,\n                name;\n\n            if (typeof cookieSections != 'object') {\n                return true;\n            }\n\n            for (name in cookieSections) {\n                if (name !== undefined) {\n                    storageVal = storage.get(name);\n\n                    if (typeof storageVal === 'undefined' ||\n                        typeof storageVal == 'object' && cookieSections[name] > storageVal['data_id']\n                    ) {\n                        return true;\n                    }\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         *\n         * @return {Array}\n         */\n        getExpiredKeys: function () {\n            var cookieSections = $.cookieStorage.get('section_data_ids'),\n                storageVal,\n                name,\n                expiredKeys = [];\n\n            if (typeof cookieSections != 'object') {\n                return [];\n            }\n\n            for (name in cookieSections) {\n                storageVal = storage.get(name);\n\n                if (typeof storageVal === 'undefined' ||\n                    typeof storageVal == 'object' && cookieSections[name] !=  storage.get(name)['data_id']\n                ) {\n                    expiredKeys.push(name);\n                }\n            }\n\n            return expiredKeys;\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {*}\n         */\n        get: function (sectionName) {\n            return buffer.get(sectionName);\n        },\n\n        /**\n         * @param {String} sectionName\n         * @param {Object} sectionData\n         */\n        set: function (sectionName, sectionData) {\n            var data = {};\n\n            data[sectionName] = sectionData;\n            buffer.update(data);\n        },\n\n        /**\n         * @param {Array} sectionNames\n         * @param {Number} updateSectionId\n         * @return {*}\n         */\n        reload: function (sectionNames, updateSectionId) {\n            return dataProvider.getFromServer(sectionNames, updateSectionId).done(function (sections) {\n                buffer.update(sections);\n            });\n        },\n\n        /**\n         * @param {Array} sectionNames\n         */\n        invalidate: function (sectionNames) {\n            var sectionDataIds,\n                sectionsNamesForInvalidation;\n\n            sectionsNamesForInvalidation = _.contains(sectionNames, '*') ? buffer.keys() : sectionNames;\n            buffer.remove(sectionsNamesForInvalidation);\n            sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n\n            // Invalidate section in cookie (increase version of section with 1000)\n            _.each(sectionsNamesForInvalidation, function (sectionName) {\n                if (!sectionConfig.isClientSideSection(sectionName)) {\n                    sectionDataIds[sectionName] += 1000;\n                }\n            });\n            $.cookieStorage.set('section_data_ids', sectionDataIds);\n        },\n\n        /**\n         * @param {Object} settings\n         * @constructor\n         */\n        'Magento_Customer/js/customer-data': function (settings) {\n            options = settings;\n            invalidateCacheBySessionTimeOut(settings);\n            invalidateCacheByCloseCookieSession();\n            customerData.init();\n        }\n    };\n\n    /**\n     * Events listener\n     */\n    $(document).on('ajaxComplete', function (event, xhr, settings) {\n        var sections,\n            redirects;\n\n        if (settings.type.match(/post|put/i)) {\n            sections = sectionConfig.getAffectedSections(settings.url);\n\n            if (sections) {\n                customerData.invalidate(sections);\n                redirects = ['redirect', 'backUrl'];\n\n                if (_.isObject(xhr.responseJSON) && !_.isEmpty(_.pick(xhr.responseJSON, redirects))) {\n                    return;\n                }\n                customerData.reload(sections, true);\n            }\n        }\n    });\n\n    /**\n     * Events listener\n     */\n    $(document).on('submit', function (event) {\n        var sections;\n\n        if (event.target.method.match(/post|put/i)) {\n            sections = sectionConfig.getAffectedSections(event.target.action);\n\n            if (sections) {\n                customerData.invalidate(sections);\n            }\n        }\n    });\n\n    return customerData;\n});\n","Magento_Customer/js/password-strength-indicator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * jshint browser:true\n */\ndefine([\n    'jquery',\n    'Magento_Customer/js/zxcvbn',\n    'mage/translate',\n    'mage/validation'\n], function ($, zxcvbn, $t) {\n    'use strict';\n\n    $.widget('mage.passwordStrengthIndicator', {\n        options: {\n            cache: {},\n            defaultClassName: 'password-strength-meter-',\n            passwordSelector: '[type=password]',\n            passwordStrengthMeterSelector: '[data-role=password-strength-meter]',\n            passwordStrengthMeterLabelSelector: '[data-role=password-strength-meter-label]'\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function () {\n            this.options.cache.input = $(this.options.passwordSelector, this.element);\n            this.options.cache.meter = $(this.options.passwordStrengthMeterSelector, this.element);\n            this.options.cache.label = $(this.options.passwordStrengthMeterLabelSelector, this.element);\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor scroll and resize events (resize events left for backward compat)\n         * @private\n         */\n        _bind: function () {\n            this._on(this.options.cache.input, {\n                'change': this._calculateStrength,\n                'keyup': this._calculateStrength,\n                'paste': this._calculateStrength\n            });\n        },\n\n        /**\n         * Calculate password strength\n         * @private\n         */\n        _calculateStrength: function () {\n            var password = this._getPassword(),\n                isEmpty = password.length === 0,\n                zxcvbnScore = zxcvbn(password).score,\n                isValid = $.validator.validateSingleElement(this.options.cache.input),\n                displayScore = zxcvbnScore || 1;\n\n            // Display score is based on combination of whether password is empty, valid, and zxcvbn strength\n            if (isEmpty) {\n                displayScore = 0;\n            } else if (!isValid) {\n                displayScore = 1;\n            }\n\n            // Update label\n            this._displayStrength(displayScore);\n        },\n\n        /**\n         * Display strength\n         * @param {Number} displayScore\n         * @private\n         */\n        _displayStrength: function (displayScore) {\n            var strengthLabel = '',\n                className = this._getClassName(displayScore);\n\n            switch (displayScore) {\n                case 0:\n                    strengthLabel = $t('No Password');\n                    break;\n\n                case 1:\n                    strengthLabel = $t('Weak');\n                    break;\n\n                case 2:\n                    strengthLabel = $t('Medium');\n                    break;\n\n                case 3:\n                    strengthLabel = $t('Strong');\n                    break;\n\n                case 4:\n                    strengthLabel = $t('Very Strong');\n                    break;\n            }\n\n            this.options.cache.meter\n                .removeClass()\n                .addClass(className);\n            this.options.cache.label.text(strengthLabel);\n        },\n\n        /**\n         * Get password value\n         * @returns {*}\n         * @private\n         */\n        _getPassword: function () {\n            return this.options.cache.input.val();\n        },\n\n        /**\n         * Get class name for score\n         * @param {int} displayScore\n         * @returns {String}\n         * @private\n         */\n        _getClassName: function (displayScore) {\n            return this.options.defaultClassName + displayScore;\n        }\n    });\n\n    return $.mage.passwordStrengthIndicator;\n});\n","Magento_Customer/js/section-config.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    var baseUrls, sections, clientSideSections;\n\n    var canonize = function(url){\n        var route = url;\n        for (var key in baseUrls) {\n            route = url.replace(baseUrls[key], '');\n            if (route != url) {\n                break;\n            }\n        }\n        return route.replace(/^\\/?index.php\\/?/, '').toLowerCase();\n    };\n\n    return {\n        getAffectedSections: function (url) {\n            var route = canonize(url);\n            var actions = _.find(sections, function(val, section) {\n                if (section.indexOf('*') >= 0) {\n                    section = section.replace(/\\*/g, '[^/]+') + '$';\n                    var matched = route.match(section);\n                    return matched && matched[0] == route;\n                }\n                return (route.indexOf(section) === 0);\n            });\n\n            return _.union(_.toArray(actions), _.toArray(sections['*']));\n        },\n\n        filterClientSideSections: function (sections) {\n            if (Array.isArray(sections)) {\n                return _.difference(sections, clientSideSections);\n            }\n            return sections;\n        },\n\n        isClientSideSection: function (sectionName) {\n            return _.contains(clientSideSections, sectionName);\n        },\n\n        'Magento_Customer/js/section-config': function(options) {\n            baseUrls = options.baseUrls;\n            sections = options.sections;\n            clientSideSections = options.clientSideSections;\n        }\n    };\n});\n","Magento_Customer/js/action/check-email-availability.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'mage/storage',\n        'Magento_Checkout/js/model/url-builder'\n    ],\n    function (storage, urlBuilder) {\n        'use strict';\n\n        return function (deferred, email) {\n            return storage.post(\n                urlBuilder.createUrl('/customers/isEmailAvailable', {}),\n                JSON.stringify({\n                    customerEmail: email\n                }),\n                false\n            ).done(\n                function (isEmailAvailable) {\n                    if (isEmailAvailable) {\n                        deferred.resolve();\n                    } else {\n                        deferred.reject();\n                    }\n                }\n            ).fail(\n                function () {\n                    deferred.reject();\n                }\n            );\n        };\n    }\n);\n","Magento_Customer/js/action/login.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mage/storage',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Customer/js/customer-data'\n    ],\n    function($, storage, globalMessageList, customerData) {\n        'use strict';\n        var callbacks = [],\n            action = function(loginData, redirectUrl, isGlobal, messageContainer) {\n                messageContainer = messageContainer || globalMessageList;\n                return storage.post(\n                    'customer/ajax/login',\n                    JSON.stringify(loginData),\n                    isGlobal\n                ).done(function (response) {\n                    if (response.errors) {\n                        messageContainer.addErrorMessage(response);\n                        callbacks.forEach(function(callback) {\n                            callback(loginData);\n                        });\n                    } else {\n                        callbacks.forEach(function(callback) {\n                            callback(loginData);\n                        });\n                        customerData.invalidate(['customer']);\n                        if (redirectUrl) {\n                            window.location.href = redirectUrl;\n                        } else if (response.redirectUrl) {\n                            window.location.href = response.redirectUrl;\n                        } else {\n                            location.reload();\n                        }\n                    }\n                }).fail(function () {\n                    messageContainer.addErrorMessage({'message': 'Could not authenticate. Please try again later'});\n                    callbacks.forEach(function(callback) {\n                        callback(loginData);\n                    });\n                });\n            };\n\n        action.registerLoginCallback = function(callback) {\n            callbacks.push(callback);\n        };\n\n        return action;\n    }\n);\n","Magento_Customer/js/model/address-list.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'ko',\n        './customer-addresses'\n    ],\n    function(ko, defaultProvider) {\n        \"use strict\";\n        return ko.observableArray(defaultProvider.getAddressItems());\n    }\n);","Magento_Customer/js/model/authentication-popup.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Ui/js/modal/modal'\n    ],\n    function ($, modal) {\n        'use strict';\n\n        return {\n            modalWindow: null,\n\n            /** Create popUp window for provided element */\n            createPopUp: function (element) {\n                this.modalWindow = element;\n                var options = {\n                    'type': 'popup',\n                    'modalClass': 'popup-authentication',\n                    'responsive': true,\n                    'innerScroll': true,\n                    'trigger': '.proceed-to-checkout',\n                    'buttons': []\n                };\n                modal(options, $(this.modalWindow));\n            },\n\n            /** Show login popup window */\n            showModal: function () {\n                $(this.modalWindow).modal('openModal');\n            }\n        }\n    }\n);\n","Magento_Customer/js/model/customer-addresses.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'ko',\n        './customer/address'\n    ],\n    function($, ko, address) {\n        \"use strict\";\n        var isLoggedIn = ko.observable(window.isCustomerLoggedIn);\n        return {\n            getAddressItems: function() {\n                var items = [];\n                if (isLoggedIn) {\n                    var customerData = window.customerData;\n                    if (Object.keys(customerData).length) {\n                        $.each(customerData.addresses, function (key, item) {\n                            items.push(new address(item));\n                        });\n                    }\n                }\n                return items;\n            }\n        }\n    }\n);","Magento_Customer/js/model/customer.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'ko',\n        'underscore',\n        './address-list'\n    ],\n    function($, ko, _, addressList) {\n        \"use strict\";\n        var isLoggedIn = ko.observable(window.isCustomerLoggedIn),\n            customerData = {};\n\n        if (isLoggedIn()) {\n            customerData = window.customerData;\n        } else {\n            customerData = {};\n        }\n\n        return {\n            customerData: customerData,\n            customerDetails: {},\n            isLoggedIn: isLoggedIn,\n            setIsLoggedIn: function (flag) {\n                isLoggedIn(flag);\n            },\n            getBillingAddressList: function () {\n                return addressList();\n            },\n            getShippingAddressList: function () {\n                return addressList();\n            },\n            setDetails: function (fieldName, value) {\n                if (fieldName) {\n                    this.customerDetails[fieldName] = value;\n                }\n            },\n            getDetails: function (fieldName) {\n                if (fieldName) {\n                    if (this.customerDetails.hasOwnProperty(fieldName)) {\n                        return this.customerDetails[fieldName];\n                    }\n                    return undefined;\n                } else {\n                    return this.customerDetails;\n                }\n            },\n            addCustomerAddress: function (address) {\n                var fields = [\n                        'customer_id', 'country_id', 'street', 'company', 'telephone', 'fax', 'postcode', 'city',\n                        'firstname', 'lastname', 'middlename', 'prefix', 'suffix', 'vat_id', 'default_billing',\n                        'default_shipping'\n                    ],\n                    customerAddress = {},\n                    hasAddress = 0,\n                    existingAddress;\n\n                if (!this.customerData.addresses) {\n                    this.customerData.addresses = [];\n                }\n\n                customerAddress = _.pick(address, fields);\n                if (address.hasOwnProperty('region_id')) {\n                    customerAddress.region = {\n                        region_id: address.region_id,\n                        region: address.region\n                    };\n                }\n                for (existingAddress in this.customerData.addresses) {\n                    if (this.customerData.addresses.hasOwnProperty(existingAddress)) {\n                        if (_.isEqual(this.customerData.addresses[existingAddress], customerAddress)) {\n                            hasAddress = existingAddress;\n                            break;\n                        }\n                    }\n                }\n                if (hasAddress === 0) {\n                    return this.customerData.addresses.push(customerAddress) - 1;\n                }\n                return hasAddress;\n            },\n            setAddressAsDefaultBilling: function (addressId) {\n                if (this.customerData.addresses[addressId]) {\n                    this.customerData.addresses[addressId].default_billing = 1;\n                    return true;\n                }\n                return false;\n            },\n            setAddressAsDefaultShipping: function (addressId) {\n                if (this.customerData.addresses[addressId]) {\n                    this.customerData.addresses[addressId].default_shipping = 1;\n                    return true;\n                }\n                return false;\n            }\n        };\n    }\n);\n","Magento_Customer/js/model/customer/address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([], function() {\n    /**\n     * @param addressData\n     * Returns new address object\n     */\n    return function (addressData) {\n        return {\n            customerAddressId: addressData.id,\n            email: addressData.email,\n            countryId: addressData.country_id,\n            regionId: addressData.region_id,\n            regionCode: addressData.region.region_code,\n            region: addressData.region.region,\n            customerId: addressData.customer_id,\n            street: addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode,\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData.vat_id,\n            sameAsBilling: addressData.same_as_billing,\n            saveInAddressBook: addressData.save_in_address_book,\n            customAttributes: addressData.custom_attributes,\n            isDefaultShipping: function() {\n                return addressData.default_shipping;\n            },\n            isDefaultBilling: function() {\n                return addressData.default_billing;\n            },\n            getAddressInline: function() {\n                return addressData.inline;\n            },\n            getType: function() {\n                return 'customer-address'\n            },\n            getKey: function() {\n                return this.getType() + this.customerAddressId;\n            },\n            getCacheKey: function() {\n                return this.getKey();\n            },\n            isEditable: function() {\n                return false;\n            },\n            canUseForBilling: function() {\n                return true;\n            }\n        }\n    }\n});\n","Magento_Customer/js/view/authentication-popup.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'ko',\n        'Magento_Ui/js/form/form',\n        'Magento_Customer/js/action/login',\n        'Magento_Customer/js/customer-data',\n        'Magento_Customer/js/model/authentication-popup',\n        'mage/translate',\n        'mage/url',\n        'Magento_Ui/js/modal/alert',\n        'mage/validation'\n    ],\n    function ($, ko, Component, loginAction, customerData, authenticationPopup, $t, url, alert) {\n        'use strict';\n\n        return Component.extend({\n            registerUrl: window.authenticationPopup.customerRegisterUrl,\n            forgotPasswordUrl: window.authenticationPopup.customerForgotPasswordUrl,\n            autocomplete: window.checkout.autocomplete,\n            modalWindow: null,\n            isLoading: ko.observable(false),\n\n            defaults: {\n                template: 'Magento_Customer/authentication-popup'\n            },\n\n            /**\n             * Init\n             */\n            initialize: function () {\n                var self = this;\n                this._super();\n                url.setBaseUrl(window.authenticationPopup.baseUrl);\n                loginAction.registerLoginCallback(function () {\n                    self.isLoading(false);\n                });\n            },\n\n            /** Init popup login window */\n            setModalElement: function (element) {\n                if (authenticationPopup.modalWindow == null) {\n                    authenticationPopup.createPopUp(element);\n                }\n            },\n\n            /** Is login form enabled for current customer */\n            isActive: function () {\n                var customer = customerData.get('customer');\n\n                return customer() == false;\n            },\n\n            /** Show login popup window */\n            showModal: function () {\n                if (this.modalWindow) {\n                    $(this.modalWindow).modal('openModal');\n                } else {\n                    alert({\n                        content: $t('Guest checkout is disabled.')\n                    });\n                }\n            },\n\n            /** Provide login action */\n            login: function (loginForm) {\n                var loginData = {},\n                    formDataArray = $(loginForm).serializeArray();\n                formDataArray.forEach(function (entry) {\n                    loginData[entry.name] = entry.value;\n                });\n\n                if ($(loginForm).validation() &&\n                    $(loginForm).validation('isValid')\n                ) {\n                    this.isLoading(true);\n                    loginAction(loginData, null, false);\n                }\n            }\n        });\n    }\n);\n","Magento_Customer/js/view/customer.js":"/**\n* Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n* See COPYING.txt for license details.\n*/\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        initialize: function () {\n            this._super();\n\n            this.customer = customerData.get('customer');\n        }\n    });\n});\n","Magento_Shipping/js/model/config.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([], function () {\n        \"use strict\";\n        return function () {\n            return window.checkoutConfig.shippingPolicy\n        }\n    }\n);\n","Magento_Shipping/js/view/checkout/shipping/shipping-policy.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'Magento_Shipping/js/model/config'\n\n], function (Component, config) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Shipping/checkout/shipping/shipping-policy'\n        },\n        config: config()\n    });\n});\n","Magento_Sales/gift-message.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.giftMessage', {\n        options: {\n            rowPrefix: '#order-item-row-', // Selector prefix for item's row in the table.\n            linkPrefix: '#order-item-gift-message-link-', // Selector prefix for the 'Gift Message' link.\n            duration: 100, // Toggle duration.\n            expandedClass: 'expanded', // Class added/removed to/from the 'Gift Message' link.\n            expandedContentClass: 'expanded-content', // Class added/removed to/from the 'Gift Message' content.\n            lastClass: 'last' // Class added/removed to/from the last item's row in the products table.\n        },\n\n        /**\n         * Bind a click handler on the widget's element to toggle the gift message.\n         * @private\n         */\n        _create: function() {\n            this.element.on('click', $.proxy(this._toggleGiftMessage, this));\n        },\n\n        /**\n         * Toggle the display of the item's corresponding gift message.\n         * @private\n         * @param event - {Object} - Click event.\n         */\n        _toggleGiftMessage: function(event) {\n            var element = $(event.target), // Click target. The 'Gift Message' link or 'Close' button.\n                options = this.options, // Cached widget options.\n                itemId = element.data('item-id'), // The individual item's numeric id.\n                link = $(options.linkPrefix + itemId), // The 'Gift Message' expandable link.\n                row = $(options.rowPrefix + itemId), // The item's row in the products table.\n                region = $('#' + element.attr('aria-controls')); // The gift message container region.\n            region.toggleClass(options.expandedContentClass, options.duration, function() {\n                if (region.attr('aria-expanded') === \"true\") {\n                    region.attr('aria-expanded', \"false\");\n                    if (region.hasClass(options.lastClass)) {\n                        row.addClass(options.lastClass);\n                    }\n                } else {\n                    region.attr('aria-expanded', \"true\");\n                    if (region.hasClass(options.lastClass)) {\n                        row.removeClass(options.lastClass);\n                    }\n                }\n                link.toggleClass(options.expandedClass);\n            });\n            event.preventDefault(); // Prevent event propagation and avoid going to the link's href.\n        }\n    });\n    \n    return $.mage.giftMessage;\n});","Magento_Sales/orders-returns.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true, jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.ordersReturns', {\n        options: {\n            zipCode: '#oar-zip', // Search by zip code.\n            emailAddress: '#oar-email', // Search by email address.\n            searchType: '#quick-search-type-id' // Search element used for choosing between the two.\n        },\n\n        _create: function() {\n            $(this.options.searchType).on('change', $.proxy(this._showIdentifyBlock, this)).trigger('change');\n        },\n\n        /**\n         * Show either the search by zip code option or the search by email address option.\n         * @private\n         * @param e - Change event. Event target value is either 'zip' or 'email'.\n         */\n        _showIdentifyBlock: function(e) {\n            var value = $(e.target).val();\n            $(this.options.zipCode).toggle(value === 'zip');\n            $(this.options.emailAddress).toggle(value === 'email');\n        }\n    });\n\n    return $.mage.ordersReturns;\n});","Magento_Sales/js/view/last-ordered-items.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        initialize: function () {\n            var isShowAddToCart = false;\n\n            this._super();\n            this.lastOrderedItems = customerData.get('last-ordered-items');\n\n            for (var item in this.lastOrderedItems.items) {\n                if (item['is_saleable']) {\n                    isShowAddToCart = true;\n                    break;\n                }\n            }\n\n            this.lastOrderedItems.isShowAddToCart = isShowAddToCart;\n        }\n    });\n});\n","Magento_Review/js/error-placement.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($, mage) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).mage('validation', {\n            errorPlacement: function (error, element) {\n\n                if (element.parents('#product-review-table').length) {\n                    $('#product-review-table').siblings(this.errorElement + '.' + this.errorClass).remove();\n                    $('#product-review-table').after(error);\n                } else {\n                    element.after(error);\n                }\n            }\n        });\n    };\n});\n","Magento_Review/js/process-reviews.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    function processReviews(url, fromPages) {\n        $.ajax({\n            url: url,\n            cache: true,\n            dataType: 'html'\n        }).done(function (data) {\n            $('#product-review-container').html(data);\n            $('[data-role=\"product-review\"] .pages a').each(function (index, element) {\n                $(element).click(function (event) {\n                    processReviews($(element).attr('href'), true);\n                    event.preventDefault();\n                });\n            });\n        }).complete(function () {\n            if (fromPages == true) {\n                $('html, body').animate({\n                    scrollTop: $('#reviews').offset().top - 50\n                }, 300);\n            }\n        });\n    }\n\n    return function (config, element) {\n        processReviews(config.productReviewUrl);\n        $(function () {\n            $('.product-info-main .reviews-actions a').click(function (event) {\n                event.preventDefault();\n                var acnchor = $(this).attr('href').replace(/^.*?(#|$)/, '');\n                $(\".product.data.items [data-role='content']\").each(function(index){\n                    if (this.id == 'reviews') {\n                        $('.product.data.items').tabs('activate', index);\n                        $('html, body').animate({\n                            scrollTop: $('#' + acnchor).offset().top - 50\n                        }, 300);\n                    }\n                });\n            });\n        });\n    };\n});\n","Magento_Review/js/view/review.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/view/customer'\n], function (Component, customerData, customer) {\n    'use strict';\n\n    return Component.extend({\n        initialize: function () {\n            this._super();\n\n            this.review = customerData.get('review').extend({disposableCustomerData: 'review'});\n        },\n        nickname: function() {\n            return this.review().nickname || customerData.get('customer')().firstname;\n        }\n    });\n});\n","Magento_Reports/js/recently-viewed.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.recentlyViewedProducts', {\n        options: {\n            localStorageKey: \"recently-viewed-products\",\n            productBlock: \"#widget_viewed_item\",\n            viewedContainer: \"ol\"\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function() {\n            var productHtml = $(this.options.productBlock).html();\n            var productSku = $(this.options.productBlock).data('sku');\n            var products = JSON.parse(window.localStorage.getItem(this.options.localStorageKey));\n            if (products) {\n                var productsLength = products['sku'].length;\n                var maximum = $(this.element).data('count');\n                var showed = 0;\n                for (var index = 0; index <= productsLength; index++) {\n                    if (products['sku'][index] == productSku || showed >= maximum) {\n                        products['sku'].splice(index, 1);\n                        products['html'].splice(index, 1);\n                    } else {\n                        $(this.element).find(this.options.viewedContainer).append(products['html'][index]);\n                        $(this.element).show();\n                        showed++;\n                    }\n                }\n                $(this.element).find(this.options.productBlock).show();\n            } else {\n                products = {};\n                products['sku'] = [];\n                products['html'] = [];\n            }\n            products['sku'].unshift(productSku);\n            products['html'].unshift(productHtml);\n            window.localStorage.setItem(this.options.localStorageKey, JSON.stringify(products));\n        }\n    });\n    \n    return $.mage.recentlyViewedProducts;\n});","Magento_Tax/js/view/checkout/cart/totals/grand-total.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Tax/js/view/checkout/summary/grand-total'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * @override\n             */\n            isDisplayed: function () {\n                return true;\n            }\n        });\n    }\n);\n","Magento_Tax/js/view/checkout/cart/totals/shipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Tax/js/view/checkout/summary/shipping',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * @override\n             */\n            isCalculated: function () {\n                return !!quote.shippingMethod();\n            },\n\n            /**\n             * @override\n             */\n            getShippingMethodTitle: function () {\n                return '(' + this._super() + ')';\n            }\n        });\n    }\n);\n","Magento_Tax/js/view/checkout/cart/totals/tax.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Tax/js/view/checkout/summary/tax',\n        'Magento_Checkout/js/model/totals'\n    ],\n    function (Component, totals) {\n        'use strict';\n\n        var isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n            isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed;\n\n        return Component.extend({\n\n            /**\n             * @override\n             */\n            ifShowValue: function () {\n                if (this.getPureValue() === 0) {\n                    return isZeroTaxDisplayed;\n                }\n\n                return true;\n            },\n\n            /**\n             * @override\n             */\n            ifShowDetails: function () {\n                return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n            },\n\n            /**\n             * @override\n             */\n            isCalculated: function () {\n                return this.totals() && totals.getSegment('tax') !== null;\n            }\n        });\n    }\n);\n","Magento_Tax/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/shipping_method/price.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Catalog/js/price-utils'\n    ],\n    function (Component,quote, priceUtils) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Tax/checkout/shipping_method/price'\n            },\n\n            isDisplayShippingPriceExclTax: window.checkoutConfig.isDisplayShippingPriceExclTax,\n            isDisplayShippingBothPrices: window.checkoutConfig.isDisplayShippingBothPrices,\n            isPriceEqual: function(item) {\n                return item.price_excl_tax != item.price_incl_tax;\n            },\n            getFormattedPrice: function (price) {\n                //todo add format data\n                return priceUtils.formatPrice(price, quote.getPriceFormat());\n            }\n        });\n    }\n);\n","Magento_Tax/js/view/checkout/summary/grand-total.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Catalog/js/price-utils',\n        'Magento_Checkout/js/model/totals'\n    ],\n    function (Component, quote, priceUtils, totals) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                isFullTaxSummaryDisplayed: window.checkoutConfig.isFullTaxSummaryDisplayed || false,\n                template: 'Magento_Tax/checkout/summary/grand-total'\n            },\n            totals: quote.getTotals(),\n            isTaxDisplayedInGrandTotal: window.checkoutConfig.includeTaxInGrandTotal || false,\n            isDisplayed: function() {\n                return this.isFullMode();\n            },\n            getValue: function() {\n                var price = 0;\n                if (this.totals()) {\n                    price = totals.getSegment('grand_total').value;\n                }\n                return this.getFormattedPrice(price);\n            },\n            getBaseValue: function() {\n                var price = 0;\n                if (this.totals()) {\n                    price = this.totals().base_grand_total;\n                }\n                return priceUtils.formatPrice(price, quote.getBasePriceFormat());\n            },\n            getGrandTotalExclTax: function() {\n                var totals = this.totals();\n                if (!totals) {\n                    return 0;\n                }\n                return this.getFormattedPrice(totals.grand_total);\n            },\n            isBaseGrandTotalDisplayNeeded: function() {\n                var totals = this.totals();\n                if (!totals) {\n                    return false;\n                }\n                return totals.base_currency_code != totals.quote_currency_code;\n            }\n        });\n    }\n);\n","Magento_Tax/js/view/checkout/summary/shipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/summary/shipping',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function ($, Component, quote) {\n        var displayMode = window.checkoutConfig.reviewShippingDisplayMode;\n        return Component.extend({\n            defaults: {\n                displayMode: displayMode,\n                template: 'Magento_Tax/checkout/summary/shipping'\n            },\n            isBothPricesDisplayed: function() {\n                return 'both' == this.displayMode\n            },\n            isIncludingDisplayed: function() {\n                return 'including' == this.displayMode;\n            },\n            isExcludingDisplayed: function() {\n                return 'excluding' == this.displayMode;\n            },\n            isCalculated: function() {\n                return this.totals() && this.isFullMode() && null != quote.shippingMethod();\n            },\n            getIncludingValue: function() {\n                if (!this.isCalculated()) {\n                    return this.notCalculatedMessage;\n                }\n                var price =  this.totals().shipping_incl_tax;\n                return this.getFormattedPrice(price);\n            },\n            getExcludingValue: function() {\n                if (!this.isCalculated()) {\n                    return this.notCalculatedMessage;\n                }\n                var price =  this.totals().shipping_amount;\n                return this.getFormattedPrice(price);\n            }\n        });\n    }\n);\n","Magento_Tax/js/view/checkout/summary/subtotal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        var displaySubtotalMode = window.checkoutConfig.reviewTotalsDisplayMode;\n        return Component.extend({\n            defaults: {\n                displaySubtotalMode: displaySubtotalMode,\n                template: 'Magento_Tax/checkout/summary/subtotal'\n            },\n            totals: quote.getTotals(),\n            getValue: function () {\n                var price = 0;\n                if (this.totals()) {\n                    price = this.totals().subtotal;\n                }\n                return this.getFormattedPrice(price);\n            },\n            isBothPricesDisplayed: function() {\n                return 'both' == this.displaySubtotalMode;\n            },\n            isIncludingTaxDisplayed: function() {\n                return 'including' == this.displaySubtotalMode;\n            },\n            getValueInclTax: function() {\n                var price = 0;\n                if (this.totals()) {\n                    price = this.totals().subtotal_incl_tax;\n                }\n                return this.getFormattedPrice(price);\n            }\n        });\n    }\n);\n","Magento_Tax/js/view/checkout/summary/tax.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'ko',\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/totals'\n    ],\n    function (ko, Component, quote, totals) {\n        \"use strict\";\n        var isTaxDisplayedInGrandTotal = window.checkoutConfig.includeTaxInGrandTotal;\n        var isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed;\n        var isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed;\n        return Component.extend({\n            defaults: {\n                isTaxDisplayedInGrandTotal: isTaxDisplayedInGrandTotal,\n                notCalculatedMessage: 'Not yet calculated',\n                template: 'Magento_Tax/checkout/summary/tax'\n            },\n            totals: quote.getTotals(),\n            isFullTaxSummaryDisplayed: isFullTaxSummaryDisplayed,\n            ifShowValue: function() {\n                if (this.isFullMode() && this.getPureValue() == 0) {\n                    return isZeroTaxDisplayed;\n                }\n                return true;\n            },\n            ifShowDetails: function() {\n                if (!this.isFullMode()) {\n                    return false;\n                }\n                return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n            },\n            getPureValue: function() {\n                var amount = 0;\n                if (this.totals()) {\n                    var taxTotal = totals.getSegment('tax');\n                    if (taxTotal) {\n                        amount = taxTotal.value;\n                    }\n                }\n                return amount;\n            },\n            isCalculated: function() {\n                return this.totals() && this.isFullMode() && null != totals.getSegment('tax');\n            },\n            getValue: function() {\n                if (!this.isCalculated()) {\n                    return this.notCalculatedMessage;\n                }\n                var amount = totals.getSegment('tax').value;\n                return this.getFormattedPrice(amount);\n            },\n            formatPrice: function(amount) {\n                return this.getFormattedPrice(amount);\n            },\n            getDetails: function() {\n                var taxSegment = totals.getSegment('tax');\n                if (taxSegment && taxSegment.extension_attributes) {\n                    return taxSegment.extension_attributes.tax_grandtotal_details;\n                }\n                return [];\n            }\n        });\n    }\n);\n","Magento_Tax/js/view/checkout/summary/item/details/subtotal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/item/details/subtotal'\n    ],\n    function (subtotal) {\n        'use strict';\n\n        var displayPriceMode = window.checkoutConfig.reviewItemPriceDisplayMode || 'including';\n\n        return subtotal.extend({\n            defaults: {\n                displayPriceMode: displayPriceMode,\n                template: 'Magento_Tax/checkout/summary/item/details/subtotal'\n            },\n            isPriceInclTaxDisplayed: function () {\n                return 'both' == displayPriceMode || 'including' == displayPriceMode;\n            },\n            isPriceExclTaxDisplayed: function () {\n                return 'both' == displayPriceMode || 'excluding' == displayPriceMode;\n            },\n            getValueInclTax: function (quoteItem) {\n                return this.getFormattedPrice(quoteItem['row_total_incl_tax']);\n            },\n            getValueExclTax: function (quoteItem) {\n                return this.getFormattedPrice(quoteItem['row_total']);\n            }\n\n        });\n    }\n);\n","Magento_Checkout/js/checkout-data.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global alert*/\n/**\n * Checkout adapter for customer data storage\n */\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data'\n], function ($, storage) {\n    'use strict';\n\n    var cacheKey = 'checkout-data';\n\n    var getData = function () {\n        return storage.get(cacheKey)();\n    };\n\n    var saveData = function (checkoutData) {\n        storage.set(cacheKey, checkoutData);\n    };\n\n    if ($.isEmptyObject(getData())) {\n        var checkoutData = {\n            'selectedShippingAddress': null,\n            'shippingAddressFromData' : null,\n            'newCustomerShippingAddress' : null,\n            'selectedShippingRate' : null,\n            'selectedPaymentMethod' : null,\n            'selectedBillingAddress' : null,\n            'billingAddressFormData' : null,\n            'newCustomerBillingAddress' : null\n        };\n        saveData(checkoutData);\n    }\n\n    return {\n        setSelectedShippingAddress: function (data) {\n            var obj = getData();\n            obj.selectedShippingAddress = data;\n            saveData(obj);\n        },\n\n        getSelectedShippingAddress: function () {\n            return getData().selectedShippingAddress;\n        },\n\n        setShippingAddressFromData: function (data) {\n            var obj = getData();\n            obj.shippingAddressFromData = data;\n            saveData(obj);\n        },\n\n        getShippingAddressFromData: function () {\n            return getData().shippingAddressFromData;\n        },\n\n        setNewCustomerShippingAddress: function (data) {\n            var obj = getData();\n            obj.newCustomerShippingAddress = data;\n            saveData(obj);\n        },\n\n        getNewCustomerShippingAddress: function () {\n            return getData().newCustomerShippingAddress;\n        },\n\n        setSelectedShippingRate: function (data) {\n            var obj = getData();\n            obj.selectedShippingRate = data;\n            saveData(obj);\n        },\n\n        getSelectedShippingRate: function() {\n            return getData().selectedShippingRate;\n        },\n\n        setSelectedPaymentMethod: function (data) {\n            var obj = getData();\n            obj.selectedPaymentMethod = data;\n            saveData(obj);\n        },\n\n        getSelectedPaymentMethod: function() {\n            return getData().selectedPaymentMethod;\n        },\n\n        setSelectedBillingAddress: function (data) {\n            var obj = getData();\n            obj.selectedBillingAddress = data;\n            saveData(obj);\n        },\n\n        getSelectedBillingAddress: function () {\n            return getData().selectedBillingAddress;\n        },\n\n        setBillingAddressFromData: function (data) {\n            var obj = getData();\n            obj.billingAddressFromData = data;\n            saveData(obj);\n        },\n\n        getBillingAddressFromData: function () {\n            return getData().billingAddressFromData;\n        },\n\n        setNewCustomerBillingAddress: function (data) {\n            var obj = getData();\n            obj.newCustomerBillingAddress = data;\n            saveData(obj);\n        },\n\n        getNewCustomerBillingAddress: function () {\n            return getData().newCustomerBillingAddress;\n        },\n\n        getValidatedEmailValue: function () {\n            var obj = getData();\n            return (obj.validatedEmailValue) ? obj.validatedEmailValue : '';\n        },\n\n        setValidatedEmailValue: function (email) {\n            var obj = getData();\n            obj.validatedEmailValue = email;\n            saveData(obj);\n        },\n\n        getInputFieldEmailValue: function () {\n            var obj = getData();\n            return (obj.inputFieldEmailValue) ? obj.inputFieldEmailValue : '';\n        },\n\n        setInputFieldEmailValue: function (email) {\n            var obj = getData();\n            obj.inputFieldEmailValue = email;\n            saveData(obj);\n        }\n    }\n});\n","Magento_Checkout/js/checkout-loader.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'rjsResolver'\n], function (resolver) {\n    'use strict';\n\n    /**\n     * Removes provided loader element from DOM.\n     *\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function hideLoader($loader) {\n        $loader.parentNode.removeChild($loader);\n    }\n\n    /**\n     * Initializes assets loading process listener.\n     *\n     * @param {Object} config - Optional configuration\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function init(config, $loader) {\n        resolver(hideLoader.bind(null, $loader));\n    }\n\n    return init;\n});\n","Magento_Checkout/js/discount-codes.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.discountCode', {\n        options: {\n        },\n        _create: function () {\n            this.couponCode = $(this.options.couponCodeSelector);\n            this.removeCoupon = $(this.options.removeCouponSelector);\n\n            $(this.options.applyButton).on('click', $.proxy(function () {\n                this.couponCode.attr('data-validate', '{required:true}');\n                this.removeCoupon.attr('value', '0');\n                $(this.element).validation().submit();\n            }, this));\n\n            $(this.options.cancelButton).on('click', $.proxy(function () {\n                this.couponCode.removeAttr('data-validate');\n                this.removeCoupon.attr('value', '1');\n                this.element.submit();\n            }, this));\n        }\n    });\n\n    return $.mage.discountCode;\n});","Magento_Checkout/js/proceed-to-checkout.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'jquery',\n        'Magento_Customer/js/model/authentication-popup',\n        'Magento_Customer/js/customer-data'\n    ],\n    function ($, authenticationPopup, customerData) {\n        'use strict';\n\n        return function (config, element) {\n            $(element).click(function (event) {\n                var cart = customerData.get('cart'),\n                    customer = customerData.get('customer');\n\n                event.preventDefault();\n\n                if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                    authenticationPopup.showModal();\n\n                    return false;\n                }\n                location.href = config.checkoutUrl;\n            });\n\n        };\n    }\n);\n","Magento_Checkout/js/region-updater.js":"/**\n * @category    frontend Checkout region-updater\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true expr:true*/\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'mage/validation'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.regionUpdater', {\n        options: {\n            regionTemplate:\n                '<option value=\"<%- data.value %>\" <% if (data.isSelected) { %>selected=\"selected\"<% } %>>' +\n                    '<%- data.title %>' +\n                '</option>',\n            isRegionRequired: true,\n            isZipRequired: true,\n            isCountryRequired: true,\n            currentRegion: null,\n            isMultipleCountriesAllowed: true\n        },\n\n        _create: function () {\n            this._initCountryElement();\n\n            this.currentRegionOption = this.options.currentRegion;\n            this.regionTmpl = mageTemplate(this.options.regionTemplate);\n\n            this._updateRegion(this.element.find('option:selected').val());\n\n            $(this.options.regionListId).on('change', $.proxy(function (e) {\n                this.setOption = false;\n                this.currentRegionOption = $(e.target).val();\n            }, this));\n\n            $(this.options.regionInputId).on('focusout', $.proxy(function () {\n                this.setOption = true;\n            }, this));\n        },\n\n        _initCountryElement: function() {\n            if (this.options.isMultipleCountriesAllowed) {\n                this.element.parents('div.field').show();\n                this.element.on('change', $.proxy(function (e) {\n                    this._updateRegion($(e.target).val());\n                }, this));\n                if (this.options.isCountryRequired) {\n                    this.element.addClass('required-entry');\n                    this.element.parents('div.field').addClass('required');\n                }\n            } else {\n                this.element.parents('div.field').hide();\n            }\n        },\n\n        /**\n         * Remove options from dropdown list\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @private\n         */\n        _removeSelectOptions: function (selectElement) {\n            selectElement.find('option').each(function (index) {\n                if (index) {\n                    $(this).remove();\n                }\n            });\n        },\n\n        /**\n         * Render dropdown list\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @param {String} key - region code\n         * @param {Object} value - region object\n         * @private\n         */\n        _renderSelectOption: function (selectElement, key, value) {\n            selectElement.append($.proxy(function () {\n                var name = value.name.replace(/[!\"#$%&'()*+,.\\/:;<=>?@[\\\\\\]^`{|}~]/g, '\\\\$&'),\n                    tmplData,\n                    tmpl;\n\n                if (value.code && $(name).is('span')) {\n                    key = value.code;\n                    value.name = $(name).text();\n                }\n\n                tmplData = {\n                    value: key,\n                    title: value.name,\n                    isSelected: false\n                };\n\n                if (this.options.defaultRegion === key) {\n                    tmplData.isSelected = true;\n                }\n\n                tmpl = this.regionTmpl({\n                    data: tmplData\n                });\n\n                return $(tmpl);\n            }, this));\n        },\n\n        /**\n         * Takes clearError callback function as first option\n         * If no form is passed as option, look up the closest form and call clearError method.\n         * @private\n         */\n        _clearError: function () {\n            if (this.options.clearError && typeof (this.options.clearError) === 'function') {\n                this.options.clearError.call(this);\n            } else {\n                if (!this.options.form) {\n                    this.options.form = this.element.closest('form').length ? $(this.element.closest('form')[0]) : null;\n                }\n\n                this.options.form = $(this.options.form);\n\n                this.options.form && this.options.form.data('validation') && this.options.form.validation('clearError',\n                    this.options.regionListId, this.options.regionInputId, this.options.postcodeId);\n            }\n        },\n        /**\n         * Update dropdown list based on the country selected\n         * @param {String} country - 2 uppercase letter for country code\n         * @private\n         */\n        _updateRegion: function (country) {\n            // Clear validation error messages\n            var regionList = $(this.options.regionListId),\n                regionInput = $(this.options.regionInputId),\n                postcode = $(this.options.postcodeId),\n                label = regionList.parent().siblings('label'),\n                requiredLabel = regionList.parents('div.field');\n\n            this._clearError();\n            this._checkRegionRequired(country);\n\n            // Populate state/province dropdown list if available or use input box\n            if (this.options.regionJson[country]) {\n                this._removeSelectOptions(regionList);\n                $.each(this.options.regionJson[country], $.proxy(function (key, value) {\n                    this._renderSelectOption(regionList, key, value);\n                }, this));\n\n                if (this.currentRegionOption) {\n                    regionList.val(this.currentRegionOption);\n                }\n\n                if (this.setOption) {\n                    regionList.find('option').filter(function () {\n                        return this.text === regionInput.val();\n                    }).attr('selected', true);\n                }\n\n                if (this.options.isRegionRequired) {\n                    regionList.addClass('required-entry').removeAttr('disabled');\n                    requiredLabel.addClass('required');\n                } else {\n                    regionList.removeClass('required-entry validate-select').removeAttr('data-validate');\n                    requiredLabel.removeClass('required');\n\n                    if (!this.options.optionalRegionAllowed) {\n                        regionList.attr('disabled', 'disabled');\n                    }\n                }\n\n                regionList.show();\n                regionInput.hide();\n                label.attr('for', regionList.attr('id'));\n            } else {\n                if (this.options.isRegionRequired) {\n                    regionInput.addClass('required-entry').removeAttr('disabled');\n                    requiredLabel.addClass('required');\n                } else {\n                    if (!this.options.optionalRegionAllowed) {\n                        regionInput.attr('disabled', 'disabled');\n                    }\n                }\n\n                regionList.removeClass('required-entry').hide();\n                regionInput.show();\n                requiredLabel.removeClass('required');\n                label.attr('for', regionInput.attr('id'));\n            }\n\n            // If country is in optionalzip list, make postcode input not required\n            if (this.options.isZipRequired) {\n                $.inArray(country, this.options.countriesWithOptionalZip) >= 0 ?\n                    postcode.removeClass('required-entry').closest('.field').removeClass('required') :\n                    postcode.addClass('required-entry').closest('.field').addClass('required');\n            }\n\n            // Add defaultvalue attribute to state/province select element\n            regionList.attr('defaultvalue', this.options.defaultRegion);\n        },\n\n        /**\n         * Check if the selected country has a mandatory region selection\n         *\n         * @param {String} country - Code of the country - 2 uppercase letter for country code\n         * @private\n         */\n        _checkRegionRequired: function (country) {\n            this.options.isRegionRequired = false;\n            var self = this;\n            $.each(this.options.regionJson.config.regions_required, function (index, elem) {\n                if (elem == country) {\n                    self.options.isRegionRequired = true;\n                }\n            });\n        }\n    });\n\n    return $.mage.regionUpdater;\n});\n","Magento_Checkout/js/shopping-cart.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.shoppingCart', {\n        _create: function() {\n            $(this.options.emptyCartButton).on('click', $.proxy(function() {\n                $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n                $(this.options.updateCartActionContainer)\n                    .attr('name', 'update_cart_action').attr('value', 'empty_cart');\n            }, this));\n            var items = $.find(\"[data-role='cart-item-qty']\");\n            for (var i = 0; i < items.length; i++) {\n                $(items[i]).on('keypress', $.proxy(function(event) {\n                    var keyCode = (event.keyCode ? event.keyCode : event.which);\n                    if(keyCode == 13) {\n                        $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n                        $(this.options.updateCartActionContainer)\n                            .attr('name', 'update_cart_action').attr('value', 'update_qty');\n\n                    }\n                }, this));\n            }\n            $(this.options.continueShoppingButton).on('click', $.proxy(function() {\n                location.href = this.options.continueShoppingUrl;\n            }, this));\n        }\n    });\n\n    return $.mage.shoppingCart;\n});","Magento_Checkout/js/sidebar.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global confirm:true*/\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'jquery/ui',\n    'mage/decorate',\n    'mage/collapsible',\n    'mage/cookies'\n], function ($, authenticationPopup, customerData, alert, confirm) {\n\n    $.widget('mage.sidebar', {\n        options: {\n            isRecursive: true,\n            minicart: {\n                maxItemsVisible: 3\n            }\n        },\n        scrollHeight: 0,\n\n        /**\n         * Create sidebar.\n         * @private\n         */\n        _create: function () {\n            this._initContent();\n        },\n\n        /**\n         * Update sidebar block.\n         */\n        update: function () {\n            $(this.options.targetElement).trigger('contentUpdated');\n            this._calcHeight();\n            this._isOverflowed();\n        },\n\n        _initContent: function () {\n            var self = this,\n                events = {};\n\n            this.element.decorate('list', this.options.isRecursive);\n\n            events['click ' + this.options.button.close] = function (event) {\n                event.stopPropagation();\n                $(self.options.targetElement).dropdownDialog('close');\n            };\n            events['click ' + this.options.button.checkout] = $.proxy(function () {\n                var cart = customerData.get('cart'),\n                    customer = customerData.get('customer');\n\n                if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                    // set URL for redirect on successful login/registration. It's postprocessed on backend.\n                    $.cookie('login_redirect', this.options.url.checkout);\n                    if (this.options.url.isRedirectRequired) {\n                        location.href = this.options.url.loginUrl;\n                    } else {\n                        authenticationPopup.showModal();\n                    }\n\n                    return false;\n                }\n                location.href = this.options.url.checkout;\n            }, this);\n            events['click ' + this.options.button.remove] =  function (event) {\n                event.stopPropagation();\n                confirm({\n                    content: self.options.confirmMessage,\n                    actions: {\n                        confirm: function () {\n                            self._removeItem($(event.currentTarget));\n                        },\n                        always: function (event) {\n                            event.stopImmediatePropagation();\n                        }\n                    }\n                });\n            };\n            events['keyup ' + this.options.item.qty] = function (event) {\n                self._showItemButton($(event.target));\n            };\n            events['click ' + this.options.item.button] = function (event) {\n                event.stopPropagation();\n                self._updateItemQty($(event.currentTarget));\n            };\n            events['focusout ' + this.options.item.qty] = function (event) {\n                self._validateQty($(event.currentTarget));\n            };\n\n            this._on(this.element, events);\n            this._calcHeight();\n            this._isOverflowed();\n        },\n\n        /**\n         * Add 'overflowed' class to minicart items wrapper element\n         *\n         * @private\n         */\n        _isOverflowed: function () {\n            var list = $(this.options.minicart.list),\n                cssOverflowClass = 'overflowed';\n\n            if (this.scrollHeight > list.innerHeight()) {\n                list.parent().addClass(cssOverflowClass);\n            } else {\n                list.parent().removeClass(cssOverflowClass);\n            }\n        },\n\n        _showItemButton: function (elem) {\n            var itemId = elem.data('cart-item'),\n                itemQty = elem.data('item-qty');\n\n            if (this._isValidQty(itemQty, elem.val())) {\n                $('#update-cart-item-' + itemId).show('fade', 300);\n            } else if (elem.val() == 0) {\n                this._hideItemButton(elem);\n            } else {\n                this._hideItemButton(elem);\n            }\n        },\n\n        /**\n         * @param origin - origin qty. 'data-item-qty' attribute.\n         * @param changed - new qty.\n         * @returns {boolean}\n         * @private\n         */\n        _isValidQty: function (origin, changed) {\n            return (origin != changed) &&\n                (changed.length > 0) &&\n                (changed - 0 == changed) &&\n                (changed - 0 > 0);\n        },\n\n        /**\n         * @param {Object} elem\n         * @private\n         */\n        _validateQty: function (elem) {\n            var itemQty = elem.data('item-qty');\n\n            if (!this._isValidQty(itemQty, elem.val())) {\n                elem.val(itemQty);\n            }\n        },\n\n        _hideItemButton: function (elem) {\n            var itemId = elem.data('cart-item');\n            $('#update-cart-item-' + itemId).hide('fade', 300);\n        },\n\n        _updateItemQty: function (elem) {\n            var itemId = elem.data('cart-item');\n            this._ajax(this.options.url.update, {\n                item_id: itemId,\n                item_qty: $('#cart-item-' + itemId + '-qty').val()\n            }, elem, this._updateItemQtyAfter);\n        },\n\n        /**\n         * Update content after update qty\n         *\n         * @param elem\n         */\n        _updateItemQtyAfter: function (elem) {\n            this._hideItemButton(elem);\n        },\n\n        _removeItem: function (elem) {\n            var itemId = elem.data('cart-item');\n            this._ajax(this.options.url.remove, {\n                item_id: itemId\n            }, elem, this._removeItemAfter);\n        },\n\n        /**\n         * Update content after item remove\n         *\n         * @param elem\n         * @param response\n         * @private\n         */\n        _removeItemAfter: function (elem, response) {\n        },\n\n        /**\n         * @param {String} url - ajax url\n         * @param {Object} data - post data for ajax call\n         * @param {Object} elem - element that initiated the event\n         * @param {Function} callback - callback method to execute after AJAX success\n         */\n        _ajax: function (url, data, elem, callback) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n                beforeSend: function () {\n                    elem.attr('disabled', 'disabled');\n                },\n                complete: function () {\n                    elem.attr('disabled', null);\n                }\n            })\n                .done(function (response) {\n                    if (response.success) {\n                        callback.call(this, elem, response);\n                    } else {\n                        var msg = response.error_message;\n\n                        if (msg) {\n                            alert({\n                                content: $.mage.__(msg)\n                            });\n                        }\n                    }\n                })\n                .fail(function (error) {\n                    console.log(JSON.stringify(error));\n                });\n        },\n\n        /**\n         * Calculate height of minicart list\n         *\n         * @private\n         */\n        _calcHeight: function () {\n            var self = this,\n                height = 0,\n                counter = this.options.minicart.maxItemsVisible,\n                target = $(this.options.minicart.list),\n                outerHeight;\n\n            self.scrollHeight = 0;\n            target.children().each(function () {\n\n                if ($(this).find('.options').length > 0) {\n                    $(this).collapsible();\n                }\n                outerHeight = $(this).outerHeight();\n\n                if (counter-- > 0) {\n                    height += outerHeight;\n                }\n                self.scrollHeight += outerHeight;\n            });\n\n            target.parent().height(height);\n        }\n    });\n\n    return $.mage.sidebar;\n});\n","Magento_Checkout/js/action/create-billing-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/model/address-converter'\n    ],\n    function (addressConverter) {\n        'use strict';\n\n        return function (addressData) {\n            return addressConverter.formAddressDataToQuoteAddress(addressData);\n        };\n    }\n);\n","Magento_Checkout/js/action/create-shipping-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Customer/js/model/address-list',\n        'Magento_Checkout/js/model/address-converter'\n    ],\n    function(addressList, addressConverter) {\n        \"use strict\";\n        return function(addressData) {\n            var address = addressConverter.formAddressDataToQuoteAddress(addressData);\n            var isAddressUpdated = addressList().some(function(currentAddress, index, addresses) {\n                if (currentAddress.getKey() == address.getKey()) {\n                    addresses[index] = address;\n                    return true;\n                }\n                return false;\n            });\n            if (!isAddressUpdated) {\n                addressList.push(address);\n            } else {\n                addressList.valueHasMutated();\n            }\n            return address;\n        };\n    }\n);","Magento_Checkout/js/action/get-payment-information.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/payment/method-converter',\n        'Magento_Checkout/js/model/payment-service'\n    ],\n    function ($, quote, urlBuilder, storage, errorProcessor, customer, methodConverter, paymentService) {\n        'use strict';\n\n        return function (deferred, messageContainer) {\n            var serviceUrl;\n\n            deferred = deferred || $.Deferred();\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/payment-information', {\n                    cartId: quote.getQuoteId()\n                });\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n            }\n\n            return storage.get(\n                serviceUrl, false\n            ).done(\n                function (response) {\n                    quote.setTotals(response.totals);\n                    paymentService.setPaymentMethods(methodConverter(response.payment_methods));\n                    deferred.resolve();\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    deferred.reject();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/action/get-totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global define,alert*/\ndefine(\n    [\n        'jquery',\n        '../model/quote',\n        'Magento_Checkout/js/model/resource-url-manager',\n        'Magento_Checkout/js/model/error-processor',\n        'mage/storage',\n        'Magento_Checkout/js/model/totals'\n    ],\n    function ($, quote, resourceUrlManager, errorProcessor, storage, totals) {\n        'use strict';\n\n        return function (callbacks, deferred) {\n            deferred = deferred || $.Deferred();\n            totals.isLoading(true);\n\n            return storage.get(\n                resourceUrlManager.getUrlForCartTotals(quote),\n                false\n            ).done(\n                function (response) {\n                    var proceed = true;\n\n                    totals.isLoading(false);\n\n                    if (callbacks.length > 0) {\n                        $.each(callbacks, function (index, callback) {\n                            proceed = proceed && callback();\n                        });\n                    }\n\n                    if (proceed) {\n                        quote.setTotals(response);\n                        deferred.resolve();\n                    }\n                }\n            ).error(\n                function (response) {\n                    totals.isLoading(false);\n                    deferred.reject();\n                    errorProcessor.process(response);\n                }\n            ).always(\n                function () {\n                    totals.isLoading(false);\n                }\n            );\n\n        };\n    }\n);","Magento_Checkout/js/action/place-order.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/place-order'\n    ],\n    function (quote, urlBuilder, customer, placeOrderService) {\n        'use strict';\n\n        return function (paymentData, messageContainer) {\n            var serviceUrl, payload;\n\n            payload = {\n                cartId: quote.getQuoteId(),\n                billingAddress: quote.billingAddress(),\n                paymentMethod: paymentData\n            };\n\n            if (customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n            } else {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/payment-information', {\n                    quoteId: quote.getQuoteId()\n                });\n                payload.email = quote.guestEmail;\n            }\n\n            return placeOrderService(serviceUrl, payload, messageContainer);\n        };\n    }\n);\n","Magento_Checkout/js/action/redirect-on-success.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'mage/url'\n    ],\n    function (url) {\n        'use strict';\n\n        return {\n            redirectUrl: window.checkoutConfig.defaultSuccessPageUrl,\n\n            /**\n             * Provide redirect to page\n             */\n            execute: function () {\n                window.location.replace(url.build(this.redirectUrl));\n            }\n        };\n    }\n);\n","Magento_Checkout/js/action/select-billing-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        '../model/quote'\n    ],\n    function ($, quote) {\n        'use strict';\n\n        return function (billingAddress) {\n            var address = null;\n\n            if (quote.shippingAddress() && billingAddress.getCacheKey() == quote.shippingAddress().getCacheKey()) {\n                address = $.extend({}, billingAddress);\n                address.saveInAddressBook = null;\n            } else {\n                address = billingAddress;\n            }\n            quote.billingAddress(address);\n        };\n    }\n);\n","Magento_Checkout/js/action/select-payment-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        '../model/quote'\n    ],\n    function(quote) {\n        'use strict';\n        return function (paymentMethod) {\n            quote.paymentMethod(paymentMethod);\n        }\n    }\n);\n","Magento_Checkout/js/action/select-shipping-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/model/quote'\n    ],\n    function(quote) {\n        'use strict';\n        return function(shippingAddress) {\n            quote.shippingAddress(shippingAddress);\n        };\n    }\n);\n","Magento_Checkout/js/action/select-shipping-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define,alert*/\ndefine(\n    [\n        '../model/quote'\n    ],\n    function (quote) {\n        \"use strict\";\n        return function (shippingMethod) {\n            quote.shippingMethod(shippingMethod)\n        }\n    }\n);\n","Magento_Checkout/js/action/set-billing-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/action/get-totals',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/get-payment-information'\n    ],\n    function ($,\n              quote,\n              urlBuilder,\n              storage,\n              errorProcessor,\n              customer,\n              getTotalsAction,\n              fullScreenLoader,\n              getPaymentInformationAction\n    ) {\n        'use strict';\n\n        return function (messageContainer) {\n            var serviceUrl,\n                payload;\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/billing-address', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/billing-address', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            }\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).done(\n                function () {\n                    var deferred = null;\n\n                    if (!quote.isVirtual()) {\n                        getTotalsAction([]);\n                        fullScreenLoader.stopLoader();\n                    } else {\n                        deferred = $.Deferred();\n                        getPaymentInformationAction(deferred);\n                        $.when(deferred).done(function () {\n                            fullScreenLoader.stopLoader();\n                        });\n                    }\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/action/set-payment-information.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/action/get-totals',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (quote, urlBuilder, storage, errorProcessor, customer, getTotalsAction, fullScreenLoader) {\n        'use strict';\n\n        return function (messageContainer, paymentData) {\n            var serviceUrl,\n                payload;\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    email: quote.guestEmail,\n                    paymentMethod: paymentData,\n                    billingAddress: quote.billingAddress()\n                };\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/set-payment-information', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    paymentMethod: paymentData,\n                    billingAddress: quote.billingAddress()\n                };\n            }\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                }\n            ).always(\n                function () {\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/action/set-shipping-information.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define,alert*/\ndefine(\n    [\n        '../model/quote',\n        'Magento_Checkout/js/model/shipping-save-processor'\n    ],\n    function (quote, shippingSaveProcessor) {\n        'use strict';\n        return function () {\n            return shippingSaveProcessor.saveShippingInformation(quote.shippingAddress().getType());\n        }\n    }\n);\n","Magento_Checkout/js/model/address-converter.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/new-customer-address',\n        'Magento_Customer/js/customer-data',\n        'mage/utils/objects'\n    ],\n    function($, address, customerData, mageUtils) {\n        'use strict';\n        var countryData = customerData.get('directory-data');\n\n        return {\n            /**\n             * Convert address form data to Address object\n             * @param {Object} formData\n             * @returns {Object}\n             */\n            formAddressDataToQuoteAddress: function(formData) {\n                // clone address form data to new object\n                var addressData = $.extend(true, {}, formData),\n                    region,\n                    regionName = addressData.region;\n                if (mageUtils.isObject(addressData.street)) {\n                    addressData.street = this.objectToArray(addressData.street);\n                }\n\n                addressData.region = {\n                    region_id: addressData.region_id,\n                    region_code: addressData.region_code,\n                    region: regionName\n                };\n\n                if (addressData.region_id\n                    && countryData()[addressData.country_id]\n                    && countryData()[addressData.country_id]['regions']\n                ) {\n                    region = countryData()[addressData.country_id]['regions'][addressData.region_id];\n                    if (region) {\n                        addressData.region.region_id = addressData['region_id'];\n                        addressData.region.region_code = region['code'];\n                        addressData.region.region = region['name'];\n                    }\n                }\n                delete addressData.region_id;\n\n                return address(addressData);\n            },\n\n            /**\n             * Convert Address object to address form data\n             * @param {Object} address\n             * @returns {Object}\n             */\n            quoteAddressToFormAddressData: function (address) {\n                var self = this;\n                var output = {};\n\n                if ($.isArray(address.street)) {\n                    var streetObject = {};\n                    address.street.forEach(function(value, index) {\n                        streetObject[index] = value;\n                    });\n                    address.street = streetObject;\n                }\n\n                $.each(address, function (key) {\n                    if (address.hasOwnProperty(key) && !$.isFunction(address[key])) {\n                        output[self.toUnderscore(key)] = address[key];\n                    }\n                });\n                return output;\n            },\n\n            toUnderscore: function (string) {\n                return string.replace(/([A-Z])/g, function($1){return \"_\"+$1.toLowerCase();});\n            },\n\n            formDataProviderToFlatData: function(formProviderData, formIndex) {\n                var addressData = {};\n                $.each(formProviderData, function(path, value) {\n                    var pathComponents = path.split('.');\n                    pathComponents.splice(pathComponents.indexOf(formIndex), 1);\n                    pathComponents.reverse();\n                    var dataObject = {};\n                    $.each(pathComponents, function(index, pathPart) {\n                        if (index == 0) {\n                            dataObject[pathPart] = value;\n                        } else {\n                            var parent = {};\n                            parent[pathPart] = dataObject;\n                            dataObject = parent;\n                        }\n                    });\n                    $.extend(true, addressData, dataObject);\n                });\n                return addressData;\n            },\n\n            /**\n             * Convert object to array\n             * @param {Object} object\n             * @returns {Array}\n             */\n            objectToArray: function (object) {\n                var convertedArray = [];\n\n                $.each(object, function (key) {\n                    return typeof object[key] === 'string' ? convertedArray.push(object[key]) : false;\n                });\n\n                return convertedArray.slice(0);\n            },\n\n            addressToEstimationAddress: function (address) {\n                var self = this;\n                var estimatedAddressData = {};\n\n                $.each(address, function (key) {\n                    estimatedAddressData[self.toUnderscore(key)] = address[key];\n                });\n                return this.formAddressDataToQuoteAddress(estimatedAddressData);\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/authentication-messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/model/messages'\n], function (ko, Messages) {\n    'use strict';\n\n    return new Messages();\n});\n\n","Magento_Checkout/js/model/checkout-data-resolver.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global alert*/\n/**\n * Checkout adapter for customer data storage\n */\ndefine(\n    [\n        'Magento_Customer/js/model/address-list',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/action/create-shipping-address',\n        'Magento_Checkout/js/action/select-shipping-address',\n        'Magento_Checkout/js/action/select-shipping-method',\n        'Magento_Checkout/js/model/payment-service',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/action/create-billing-address',\n        'underscore'\n    ],\n    function (\n        addressList,\n        quote,\n        checkoutData,\n        createShippingAddress,\n        selectShippingAddress,\n        selectShippingMethodAction,\n        paymentService,\n        selectPaymentMethodAction,\n        addressConverter,\n        selectBillingAddress,\n        createBillingAddress,\n        _\n    ) {\n        'use strict';\n\n        return {\n\n            /**\n             * Resolve estimation address. Used local storage\n             */\n            resolveEstimationAddress: function () {\n                var address;\n\n                if (checkoutData.getShippingAddressFromData()) {\n                    address = addressConverter.formAddressDataToQuoteAddress(checkoutData.getShippingAddressFromData());\n                    selectShippingAddress(address);\n                } else {\n                    this.resolveShippingAddress();\n                }\n\n                if (quote.isVirtual()) {\n                    if (checkoutData.getBillingAddressFromData()) {\n                        address = addressConverter.formAddressDataToQuoteAddress(\n                            checkoutData.getBillingAddressFromData()\n                        );\n                        selectBillingAddress(address);\n                    } else {\n                        this.resolveBillingAddress();\n                    }\n                }\n\n            },\n\n            /**\n             * Resolve shipping address. Used local storage\n             */\n            resolveShippingAddress: function () {\n                var newCustomerShippingAddress = checkoutData.getNewCustomerShippingAddress();\n\n                if (newCustomerShippingAddress) {\n                    createShippingAddress(newCustomerShippingAddress);\n                }\n                this.applyShippingAddress();\n            },\n\n            /**\n             * Apply resolved estimated address to quote\n             *\n             * @param {Object} isEstimatedAddress\n             */\n            applyShippingAddress: function (isEstimatedAddress) {\n                var address,\n                    shippingAddress,\n                    isConvertAddress,\n                    addressData,\n                    isShippingAddressInitialized;\n\n                if (addressList().length == 0) {\n                    address = addressConverter.formAddressDataToQuoteAddress(\n                        checkoutData.getShippingAddressFromData()\n                    );\n                    selectShippingAddress(address);\n                }\n                shippingAddress = quote.shippingAddress();\n                isConvertAddress = isEstimatedAddress || false;\n\n                if (!shippingAddress) {\n                    isShippingAddressInitialized = addressList.some(function (addressFromList) {\n                        if (checkoutData.getSelectedShippingAddress() == addressFromList.getKey()) {\n                            addressData = isConvertAddress ?\n                                addressConverter.addressToEstimationAddress(addressFromList)\n                                : addressFromList;\n                            selectShippingAddress(addressData);\n\n                            return true;\n                        }\n\n                        return false;\n                    });\n\n                    if (!isShippingAddressInitialized) {\n                        isShippingAddressInitialized = addressList.some(function (address) {\n                            if (address.isDefaultShipping()) {\n                                addressData = isConvertAddress ?\n                                    addressConverter.addressToEstimationAddress(address)\n                                    : address;\n                                selectShippingAddress(addressData);\n\n                                return true;\n                            }\n\n                            return false;\n                        });\n                    }\n\n                    if (!isShippingAddressInitialized && addressList().length == 1) {\n                        addressData = isConvertAddress ?\n                            addressConverter.addressToEstimationAddress(addressList()[0])\n                            : addressList()[0];\n                        selectShippingAddress(addressData);\n                    }\n                }\n            },\n\n            /**\n             * @param {Object} ratesData\n             */\n            resolveShippingRates: function (ratesData) {\n                var selectedShippingRate = checkoutData.getSelectedShippingRate(),\n                    availableRate = false;\n\n                if (ratesData.length == 1) {\n                    //set shipping rate if we have only one available shipping rate\n                    selectShippingMethodAction(ratesData[0]);\n\n                    return;\n                }\n\n                if (quote.shippingMethod()) {\n                    availableRate = _.find(ratesData, function (rate) {\n                        return rate.carrier_code == quote.shippingMethod().carrier_code &&\n                            rate.method_code == quote.shippingMethod().method_code;\n                    });\n                }\n\n                if (!availableRate && selectedShippingRate) {\n                    availableRate = _.find(ratesData, function (rate) {\n                        return rate.carrier_code + '_' + rate.method_code === selectedShippingRate;\n                    });\n                }\n\n                if (!availableRate && window.checkoutConfig.selectedShippingMethod) {\n                    availableRate = true;\n                    selectShippingMethodAction(window.checkoutConfig.selectedShippingMethod);\n                }\n\n                //Unset selected shipping method if not available\n                if (!availableRate) {\n                    selectShippingMethodAction(null);\n                } else {\n                    selectShippingMethodAction(availableRate);\n                }\n            },\n\n            /**\n             * Resolve payment method. Used local storage\n             */\n            resolvePaymentMethod: function () {\n                var availablePaymentMethods = paymentService.getAvailablePaymentMethods(),\n                    selectedPaymentMethod = checkoutData.getSelectedPaymentMethod();\n\n                if (selectedPaymentMethod) {\n                    availablePaymentMethods.some(function (payment) {\n                        if (payment.method == selectedPaymentMethod) {\n                            selectPaymentMethodAction(payment);\n                        }\n                    });\n                }\n            },\n\n            /**\n             * Resolve billing address. Used local storage\n             */\n            resolveBillingAddress: function () {\n                var selectedBillingAddress = checkoutData.getSelectedBillingAddress(),\n                    newCustomerBillingAddressData = checkoutData.getNewCustomerBillingAddress();\n\n                if (selectedBillingAddress) {\n                    if (selectedBillingAddress == 'new-customer-address' && newCustomerBillingAddressData) {\n                        selectBillingAddress(createBillingAddress(newCustomerBillingAddressData));\n                    } else {\n                        addressList.some(function (address) {\n                            if (selectedBillingAddress == address.getKey()) {\n                                selectBillingAddress(address);\n                            }\n                        });\n                    }\n                } else {\n                    this.applyBillingAddress();\n                }\n            },\n\n            /**\n             * Apply resolved billing address to quote\n             */\n            applyBillingAddress: function () {\n                var shippingAddress;\n\n                if (quote.billingAddress()) {\n                    selectBillingAddress(quote.billingAddress());\n\n                    return;\n                }\n                shippingAddress = quote.shippingAddress();\n\n                if (shippingAddress &&\n                    shippingAddress.canUseForBilling() &&\n                    (shippingAddress.isDefaultShipping() || !quote.isVirtual())\n                ) {\n                    //set billing address same as shipping by default if it is not empty\n                    selectBillingAddress(quote.shippingAddress());\n                }\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/customer-email-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Customer/js/model/customer',\n        'mage/validation'\n    ],\n    function ($, customer) {\n        'use strict';\n\n        return {\n\n            /**\n             * Validate checkout agreements\n             *\n             * @returns {Boolean}\n             */\n            validate: function () {\n                var emailValidationResult = customer.isLoggedIn(),\n                    loginFormSelector = 'form[data-role=email-with-possible-login]';\n\n                if (!customer.isLoggedIn()) {\n                    $(loginFormSelector).validation();\n                    emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n                }\n\n                return emailValidationResult;\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/error-processor.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'mage/url',\n        'Magento_Ui/js/model/messageList'\n    ],\n    function (url, globalMessageList) {\n        'use strict';\n\n        return {\n            process: function (response, messageContainer) {\n                messageContainer = messageContainer || globalMessageList;\n                if (response.status == 401) {\n                    window.location.replace(url.build('customer/account/login/'));\n                } else {\n                    var error = JSON.parse(response.responseText);\n                    messageContainer.addErrorMessage(error);\n                }\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/full-screen-loader.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    'jquery',\n    'rjsResolver'\n], function ($, resolver) {\n        'use strict';\n\n        var containerId = '#checkout';\n\n        return {\n\n            /**\n             * Start full page loader action\n             */\n            startLoader: function () {\n                $(containerId).trigger('processStart');\n            },\n\n            /**\n             * Stop full page loader action\n             *\n             * @param {Boolean} forceStop\n             */\n            stopLoader: function (forceStop) {\n                var $elem = $(containerId),\n                    stop = $elem.trigger.bind($elem, 'processStop');\n\n                forceStop ? stop() : resolver(stop);\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/new-customer-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([], function () {\n    /**\n     * @param {Object} addressData\n     * Returns new address object\n     */\n    return function (addressData) {\n        var identifier = Date.now();\n\n        return {\n            email: addressData.email,\n            countryId: (addressData.country_id) ? addressData.country_id : window.checkoutConfig.defaultCountryId,\n            regionId: (addressData.region && addressData.region.region_id) ?\n                addressData.region.region_id\n                : window.checkoutConfig.defaultRegionId,\n            regionCode: (addressData.region) ? addressData.region.region_code : null,\n            region: (addressData.region) ? addressData.region.region : null,\n            customerId: addressData.customer_id,\n            street: addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode ? addressData.postcode : window.checkoutConfig.defaultPostcode,\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData.vat_id,\n            saveInAddressBook: addressData.save_in_address_book,\n            customAttributes: addressData.custom_attributes,\n            isDefaultShipping: function () {\n                return addressData.default_shipping;\n            },\n            isDefaultBilling: function () {\n                return addressData.default_billing;\n            },\n            getType: function () {\n                return 'new-customer-address';\n            },\n            getKey: function () {\n                return this.getType();\n            },\n            getCacheKey: function () {\n                return this.getType() + identifier;\n            },\n            isEditable: function () {\n                return true;\n            },\n            canUseForBilling: function () {\n                return true;\n            }\n        }\n    }\n});\n","Magento_Checkout/js/model/payment-service.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'underscore',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/payment/method-list',\n        'Magento_Checkout/js/action/select-payment-method'\n    ],\n    function (_, quote, methodList, selectPaymentMethod) {\n        'use strict';\n        var freeMethodCode = 'free';\n\n        return {\n            isFreeAvailable: false,\n            /**\n             * Populate the list of payment methods\n             * @param {Array} methods\n             */\n            setPaymentMethods: function (methods) {\n                var self = this,\n                    freeMethod,\n                    filteredMethods,\n                    methodIsAvailable;\n\n                freeMethod = _.find(methods, function (method) {\n                    return method.method === freeMethodCode;\n                });\n                this.isFreeAvailable = freeMethod ? true : false;\n\n                if (self.isFreeAvailable && freeMethod && quote.totals().grand_total <= 0) {\n                    methods.splice(0, methods.length, freeMethod);\n                    selectPaymentMethod(freeMethod);\n                }\n                filteredMethods = _.without(methods, freeMethod);\n\n                if (filteredMethods.length === 1) {\n                    selectPaymentMethod(filteredMethods[0]);\n                } else if (quote.paymentMethod()) {\n                    methodIsAvailable = methods.some(function (item) {\n                        return item.method === quote.paymentMethod().method;\n                    });\n                    //Unset selected payment method if not available\n                    if (!methodIsAvailable) {\n                        selectPaymentMethod(null);\n                    }\n                }\n                methodList(methods);\n            },\n            /**\n             * Get the list of available payment methods.\n             * @returns {Array}\n             */\n            getAvailablePaymentMethods: function () {\n                var methods = [],\n                    self = this;\n                _.each(methodList(), function (method) {\n                    if (self.isFreeAvailable && (\n                        quote.totals().grand_total <= 0 && method.method === freeMethodCode ||\n                        quote.totals().grand_total > 0 && method.method !== freeMethodCode\n                        ) || !self.isFreeAvailable\n                    ) {\n                        methods.push(method);\n                    }\n                });\n\n                return methods;\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/place-order.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (storage, errorProcessor, fullScreenLoader) {\n        'use strict';\n\n        return function (serviceUrl, payload, messageContainer) {\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/model/postcode-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(['mageUtils'], function (utils) {\n    'use strict';\n    return {\n        validatedPostCodeExample: [],\n        validate: function(postCode, countryId) {\n            var patterns = window.checkoutConfig.postCodes[countryId];\n            this.validatedPostCodeExample = [];\n\n            if (!utils.isEmpty(postCode) && !utils.isEmpty(patterns)) {\n                for (var pattern in patterns) {\n                    if (patterns.hasOwnProperty(pattern)) {\n                        this.validatedPostCodeExample.push(patterns[pattern]['example']);\n                        var regex = new RegExp(patterns[pattern]['pattern']);\n                        if (regex.test(postCode)) {\n                            return true;\n                        }\n                    }\n                }\n                return false;\n            }\n            return true;\n        }\n    }\n});\n","Magento_Checkout/js/model/quote.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    ['ko'],\n    function (ko) {\n        'use strict';\n        var billingAddress = ko.observable(null);\n        var shippingAddress = ko.observable(null);\n        var shippingMethod = ko.observable(null);\n        var paymentMethod = ko.observable(null);\n        var quoteData = window.checkoutConfig.quoteData;\n        var basePriceFormat = window.checkoutConfig.basePriceFormat;\n        var priceFormat = window.checkoutConfig.priceFormat;\n        var storeCode = window.checkoutConfig.storeCode;\n        var totalsData = window.checkoutConfig.totalsData;\n        var totals = ko.observable(totalsData);\n        var collectedTotals = ko.observable({});\n        return {\n            totals: totals,\n            shippingAddress: shippingAddress,\n            shippingMethod: shippingMethod,\n            billingAddress: billingAddress,\n            paymentMethod: paymentMethod,\n            guestEmail: null,\n\n            getQuoteId: function() {\n                return quoteData.entity_id;\n            },\n            isVirtual: function() {\n                return !!Number(quoteData.is_virtual);\n            },\n            getPriceFormat: function() {\n                return priceFormat;\n            },\n            getBasePriceFormat: function() {\n                return basePriceFormat;\n            },\n            getItems: function() {\n                return window.checkoutConfig.quoteItemData;\n            },\n            getTotals: function() {\n                return totals;\n            },\n            setTotals: function(totalsData) {\n                if (_.isObject(totalsData) && _.isObject(totalsData.extension_attributes)) {\n                    _.each(totalsData.extension_attributes, function(element, index) {\n                        totalsData[index] = element;\n                    });\n                }\n                totals(totalsData);\n                this.setCollectedTotals('subtotal_with_discount', parseFloat(totalsData.subtotal_with_discount));\n            },\n            setPaymentMethod: function(paymentMethodCode) {\n                paymentMethod(paymentMethodCode);\n            },\n            getPaymentMethod: function() {\n                return paymentMethod;\n            },\n            getStoreCode: function() {\n                return storeCode;\n            },\n            setCollectedTotals: function(code, value) {\n                var totals = collectedTotals();\n                totals[code] = value;\n                collectedTotals(totals);\n            },\n            getCalculatedTotal: function() {\n                var total = 0.;\n                _.each(collectedTotals(), function(value) {\n                    total += value;\n                });\n                return total;\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/resource-url-manager.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/url-builder',\n        'mageUtils'\n    ],\n    function(customer, urlBuilder, utils) {\n        \"use strict\";\n        return {\n            getUrlForTotalsEstimationForNewAddress: function(quote) {\n                var params = (this.getCheckoutMethod() == 'guest') ? {cartId: quote.getQuoteId()} : {};\n                var urls = {\n                    'guest': '/guest-carts/:cartId/totals-information',\n                    'customer': '/carts/mine/totals-information'\n                };\n                return this.getUrl(urls, params);\n            },\n\n            getUrlForEstimationShippingMethodsForNewAddress: function(quote) {\n                var params = (this.getCheckoutMethod() == 'guest') ? {quoteId: quote.getQuoteId()} : {};\n                var urls = {\n                    'guest': '/guest-carts/:quoteId/estimate-shipping-methods',\n                    'customer': '/carts/mine/estimate-shipping-methods'\n                };\n                return this.getUrl(urls, params);\n            },\n\n            getUrlForEstimationShippingMethodsByAddressId: function(quote) {\n                var params = (this.getCheckoutMethod() == 'guest') ? {quoteId: quote.getQuoteId()} : {};\n                var urls = {\n                    'default': '/carts/mine/estimate-shipping-methods-by-address-id'\n                };\n                return this.getUrl(urls, params);\n            },\n\n            getApplyCouponUrl: function(couponCode, quoteId) {\n                var params = (this.getCheckoutMethod() == 'guest') ? {quoteId: quoteId} : {};\n                var urls = {\n                    'guest': '/guest-carts/' + quoteId + '/coupons/' + couponCode,\n                    'customer': '/carts/mine/coupons/' + couponCode\n                };\n                return this.getUrl(urls, params);\n            },\n\n            getCancelCouponUrl: function(quoteId) {\n                var params = (this.getCheckoutMethod() == 'guest') ? {quoteId: quoteId} : {};\n                var urls = {\n                    'guest': '/guest-carts/' + quoteId + '/coupons/',\n                    'customer': '/carts/mine/coupons/'\n                };\n                return this.getUrl(urls, params);\n            },\n\n            getUrlForCartTotals: function(quote) {\n                var params = (this.getCheckoutMethod() == 'guest') ? {quoteId: quote.getQuoteId()} : {};\n                var urls = {\n                    'guest': '/guest-carts/:quoteId/totals',\n                    'customer': '/carts/mine/totals'\n                };\n                return this.getUrl(urls, params);\n            },\n\n            getUrlForSetShippingInformation: function(quote) {\n                var params = (this.getCheckoutMethod() == 'guest') ? {cartId: quote.getQuoteId()} : {};\n                var urls = {\n                    'guest': '/guest-carts/:cartId/shipping-information',\n                    'customer': '/carts/mine/shipping-information'\n                };\n                return this.getUrl(urls, params);\n            },\n\n            /** Get url for service */\n            getUrl: function(urls, urlParams) {\n                var url;\n\n                if (utils.isEmpty(urls)) {\n                    return 'Provided service call does not exist.';\n                }\n\n                if (!utils.isEmpty(urls['default'])) {\n                    url = urls['default'];\n                } else {\n                    url = urls[this.getCheckoutMethod()];\n                }\n                return urlBuilder.createUrl(url, urlParams);\n            },\n\n            getCheckoutMethod: function() {\n                return customer.isLoggedIn() ? 'customer' : 'guest';\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-rate-registry.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function() {\n        \"use strict\";\n        var cache = [];\n        return {\n            get: function(addressKey) {\n                if (cache[addressKey]) {\n                    return cache[addressKey];\n                }\n                return false;\n            },\n            set: function(addressKey, data) {\n                cache[addressKey] = data;\n            }\n        };\n    }\n);","Magento_Checkout/js/model/shipping-rate-service.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n        'Magento_Checkout/js/model/shipping-rate-processor/customer-address'\n    ],\n    function (quote, defaultProcessor, customerAddressProcessor) {\n        'use strict';\n\n        var processors = [];\n\n        processors.default =  defaultProcessor;\n        processors['customer-address'] = customerAddressProcessor;\n\n        quote.shippingAddress.subscribe(function () {\n            var type = quote.shippingAddress().getType();\n\n            if (processors[type]) {\n                processors[type].getRates(quote.shippingAddress());\n            } else {\n                processors.default.getRates(quote.shippingAddress());\n            }\n        });\n\n        return {\n            registerProcessor: function (type, processor) {\n                processors[type] = processor;\n            }\n        }\n    }\n);\n","Magento_Checkout/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    ['jquery'],\n    function ($) {\n        'use strict';\n\n        var ratesRules = {},\n            checkoutConfig = window.checkoutConfig;\n\n        return {\n            registerRules: function (carrier, rules) {\n                if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                    ratesRules[carrier] = rules.getRules();\n                }\n            },\n            getRules: function () {\n                return ratesRules;\n            },\n            getObservableFields: function () {\n                var self = this,\n                    observableFields = [];\n\n                $.each(self.getRules(), function (carrier, fields) {\n                    $.each(fields, function (field, rules) {\n                        if (observableFields.indexOf(field) === -1) {\n                            observableFields.push(field);\n                        }\n                    });\n                });\n\n                return observableFields;\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'ko',\n        './shipping-rates-validation-rules',\n        '../model/address-converter',\n        '../action/select-shipping-address',\n        './postcode-validator',\n        'mage/translate',\n        'uiRegistry'\n    ],\n    function (\n        $,\n        ko,\n        shippingRatesValidationRules,\n        addressConverter,\n        selectShippingAddress,\n        postcodeValidator,\n        $t,\n        uiRegistry\n    ) {\n        'use strict';\n\n        var checkoutConfig = window.checkoutConfig,\n            validators = [],\n            observedElements = [],\n            postcodeElement = null,\n            postcodeElementName = 'postcode';\n\n        return {\n            validateAddressTimeout: 0,\n            validateDelay: 2000,\n\n            /**\n             * @param {String} carrier\n             * @param {Object} validator\n             */\n            registerValidator: function (carrier, validator) {\n                if (checkoutConfig.activeCarriers.indexOf(carrier) != -1) {\n                    validators.push(validator);\n                }\n            },\n\n            /**\n             * @param {Object} address\n             * @return {Boolean}\n             */\n            validateAddressData: function (address) {\n                return validators.some(function (validator) {\n                    return validator.validate(address);\n                });\n            },\n\n            /**\n             * Perform postponed binding for fieldset elements\n             *\n             * @param {String} formPath\n             */\n            initFields: function (formPath) {\n                var self = this,\n                    elements = shippingRatesValidationRules.getObservableFields();\n\n                if ($.inArray(postcodeElementName, elements) === -1) {\n                    // Add postcode field to observables if not exist for zip code validation support\n                    elements.push(postcodeElementName);\n                }\n\n                $.each(elements, function (index, field) {\n                    uiRegistry.async(formPath + '.' + field)(self.doElementBinding.bind(self));\n                });\n            },\n\n            /**\n             * Bind shipping rates request to form element\n             *\n             * @param {Object} element\n             * @param {Boolean} force\n             * @param {Number} delay\n             */\n            doElementBinding: function (element, force, delay) {\n                var observableFields = shippingRatesValidationRules.getObservableFields();\n\n                if (element && (observableFields.indexOf(element.index) !== -1 || force)) {\n                    if (element.index !== postcodeElementName) {\n                        this.bindHandler(element, delay);\n                    }\n                }\n\n                if (element.index === postcodeElementName) {\n                    this.bindHandler(element, delay);\n                    postcodeElement = element;\n                }\n            },\n\n            /**\n             * @param {*} elements\n             * @param {Boolean} force\n             * @param {Number} delay\n             */\n            bindChangeHandlers: function (elements, force, delay) {\n                var self = this;\n\n                $.each(elements, function (index, elem) {\n                    self.doElementBinding(elem, force, delay);\n                });\n            },\n\n            /**\n             * @param {Object} element\n             * @param {Number} delay\n             */\n            bindHandler: function (element, delay) {\n                var self = this;\n\n                delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n                if (element.component.indexOf('/group') !== -1) {\n                    $.each(element.elems(), function (index, elem) {\n                        self.bindHandler(elem);\n                    });\n                } else {\n                    element.on('value', function () {\n                        clearTimeout(self.validateAddressTimeout);\n                        self.validateAddressTimeout = setTimeout(function () {\n                            if (self.postcodeValidation()) {\n                                self.validateFields();\n                            }\n                        }, delay);\n                    });\n                    observedElements.push(element);\n                }\n            },\n\n            /**\n             * @return {*}\n             */\n            postcodeValidation: function () {\n                var countryId = $('select[name=\"country_id\"]').val(),\n                    validationResult,\n                    warnMessage;\n\n                if (postcodeElement == null || postcodeElement.value() == null) {\n                    return true;\n                }\n\n                postcodeElement.warn(null);\n                validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n                if (!validationResult) {\n                    warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                    if (postcodeValidator.validatedPostCodeExample.length) {\n                        warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                    }\n                    warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                    postcodeElement.warn(warnMessage);\n                }\n\n                return validationResult;\n            },\n\n            /**\n             * Convert form data to quote address and validate fields for shipping rates\n             */\n            validateFields: function () {\n                var addressFlat = addressConverter.formDataProviderToFlatData(\n                        this.collectObservedData(),\n                        'shippingAddress'\n                    ),\n                    address;\n\n                if (this.validateAddressData(addressFlat)) {\n                    address = addressConverter.formAddressDataToQuoteAddress(addressFlat);\n                    selectShippingAddress(address);\n                }\n            },\n\n            /**\n             * Collect observed fields data to object\n             *\n             * @returns {*}\n             */\n            collectObservedData: function () {\n                var observedValues = {};\n\n                $.each(observedElements, function (index, field) {\n                    observedValues[field.dataScope] = field.value();\n                });\n\n                return observedValues;\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-save-processor.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/model/shipping-save-processor/default'\n    ],\n    function(defaultProcessor) {\n        'use strict';\n        var processors = [];\n        processors['default'] =  defaultProcessor;\n\n        return {\n            registerProcessor: function(type, processor) {\n                processors[type] = processor;\n            },\n            saveShippingInformation: function (type) {\n                var rates = [];\n                if (processors[type]) {\n                    rates = processors[type].saveShippingInformation();\n                } else {\n                    rates = processors['default'].saveShippingInformation();\n                }\n                return rates;\n            }\n        }\n    }\n);\n","Magento_Checkout/js/model/shipping-service.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'ko',\n        'Magento_Checkout/js/model/checkout-data-resolver'\n    ],\n    function (ko, checkoutDataResolver) {\n        \"use strict\";\n        var shippingRates = ko.observableArray([]);\n        return {\n            isLoading: ko.observable(false),\n            /**\n             * Set shipping rates\n             *\n             * @param ratesData\n             */\n            setShippingRates: function(ratesData) {\n                shippingRates(ratesData);\n                shippingRates.valueHasMutated();\n                checkoutDataResolver.resolveShippingRates(ratesData);\n            },\n\n            /**\n             * Get shipping rates\n             *\n             * @returns {*}\n             */\n            getShippingRates: function() {\n                return shippingRates;\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/sidebar.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n        return {\n            popUp: false,\n            setPopup: function(popUp) {\n                this.popUp = popUp;\n            },\n            show: function() {\n                if (this.popUp) {\n                    this.popUp.modal('openModal');\n                }\n            },\n            hide: function() {\n                if (this.popUp) {\n                    this.popUp.modal('closeModal');\n                }\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/step-navigator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'ko'\n    ],\n    function($, ko) {\n        var steps = ko.observableArray();\n        return {\n            steps: steps,\n            stepCodes: [],\n            validCodes: [],\n\n            handleHash: function () {\n                var hashString = window.location.hash.replace('#', '');\n                if (hashString == '') {\n                    return false;\n                }\n\n                if (-1 == $.inArray(hashString, this.validCodes)) {\n                    window.location.href = window.checkoutConfig.pageNotFoundUrl;\n                    return false;\n                }\n\n                var isRequestedStepVisible = steps.sort(this.sortItems).some(function(element) {\n                    return (element.code == hashString || element.alias == hashString) && element.isVisible();\n                });\n\n                //if requested step is visible, then we don't need to load step data from server\n                if (isRequestedStepVisible) {\n                    return false;\n                }\n\n                steps.sort(this.sortItems).forEach(function(element) {\n                    if (element.code == hashString || element.alias == hashString) {\n                        element.navigate();\n                    } else {\n                        element.isVisible(false);\n                    }\n\n                });\n                return false;\n            },\n\n            registerStep: function(code, alias, title, isVisible, navigate, sortOrder) {\n                if (-1 != $.inArray(code, this.validCodes)) {\n                    throw new DOMException('Step code [' + code + '] already registered in step navigator');\n                }\n                if (alias != null) {\n                    if (-1 != $.inArray(alias, this.validCodes)) {\n                        throw new DOMException('Step code [' + alias + '] already registered in step navigator');\n                    }\n                    this.validCodes.push(alias);\n                }\n                this.validCodes.push(code);\n                steps.push({\n                    code: code,\n                    alias: alias != null ? alias : code,\n                    title : title,\n                    isVisible: isVisible,\n                    navigate: navigate,\n                    sortOrder: sortOrder\n                });\n                this.stepCodes.push(code);\n                var hash = window.location.hash.replace('#', '');\n                if (hash != '' && hash != code) {\n                    //Force hiding of not active step\n                    isVisible(false);\n                }\n            },\n\n            sortItems: function(itemOne, itemTwo) {\n                return itemOne.sortOrder > itemTwo.sortOrder ? 1 : -1\n            },\n\n            getActiveItemIndex: function() {\n                var activeIndex = 0;\n                steps.sort(this.sortItems).forEach(function(element, index) {\n                    if (element.isVisible()) {\n                        activeIndex = index;\n                    }\n                });\n                return activeIndex;\n            },\n\n            isProcessed: function(code) {\n                var activeItemIndex = this.getActiveItemIndex();\n                var sortedItems = steps.sort(this.sortItems);\n                var requestedItemIndex = -1;\n                sortedItems.forEach(function(element, index) {\n                    if (element.code == code) {\n                        requestedItemIndex = index;\n                    }\n                });\n                return activeItemIndex > requestedItemIndex;\n            },\n\n            navigateTo: function(code, scrollToElementId) {\n                var sortedItems = steps.sort(this.sortItems);\n                var bodyElem = $.browser.safari || $.browser.chrome ? $(\"body\") : $(\"html\");\n                scrollToElementId = scrollToElementId || null;\n\n                if (!this.isProcessed(code)) {\n                    return;\n                }\n                sortedItems.forEach(function(element) {\n                    if (element.code == code) {\n                        element.isVisible(true);\n                        bodyElem.animate({scrollTop: $('#' + code).offset().top}, 0, function () {\n                            window.location = window.checkoutConfig.checkoutUrl + \"#\" + code;\n                        });\n                        if (scrollToElementId && $('#' + scrollToElementId).length) {\n                            bodyElem.animate({scrollTop: $('#' + scrollToElementId).offset().top}, 0);\n                        }\n                    } else {\n                        element.isVisible(false);\n                    }\n\n                });\n            },\n\n            next: function() {\n                var activeIndex = 0;\n                steps.sort(this.sortItems).forEach(function(element, index) {\n                    if (element.isVisible()) {\n                        element.isVisible(false);\n                        activeIndex = index;\n                    }\n                });\n                if (steps().length > activeIndex + 1) {\n                    var code = steps()[activeIndex + 1].code;\n                    steps()[activeIndex + 1].isVisible(true);\n                    window.location = window.checkoutConfig.checkoutUrl + \"#\" + code;\n                    document.body.scrollTop = document.documentElement.scrollTop = 0;\n                }\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'ko',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (ko, quote) {\n        'use strict';\n\n        var quoteItems = ko.observable(quote.totals().items);\n\n        quote.totals.subscribe(function (newValue) {\n            quoteItems(newValue.items);\n        });\n\n        return {\n            totals: quote.totals,\n            isLoading: ko.observable(false),\n\n            /**\n             * @return {Function}\n             */\n            getItems: function () {\n                return quoteItems;\n            },\n\n            /**\n             * @param code\n             * @return {*}\n             */\n            getSegment: function (code) {\n                if (!this.totals()) {\n                    return null;\n                }\n\n                for (var i in this.totals().total_segments) {\n                    var total = this.totals().total_segments[i];\n\n                    if (total.code == code) {\n                        return total;\n                    }\n                }\n\n                return null;\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/url-builder.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    ['jquery'],\n    function($) {\n        return {\n            method: \"rest\",\n            storeCode: window.checkoutConfig.storeCode,\n            version: 'V1',\n            serviceUrl: ':method/:storeCode/:version',\n\n            createUrl: function(url, params) {\n                var completeUrl = this.serviceUrl + url;\n                return this.bindParams(completeUrl, params);\n            },\n            bindParams: function(url, params) {\n                params.method = this.method;\n                params.storeCode = this.storeCode;\n                params.version = this.version;\n\n                var urlParts = url.split(\"/\");\n                urlParts = urlParts.filter(Boolean);\n\n                $.each(urlParts, function(key, part) {\n                    part = part.replace(':', '');\n                    if (params[part] != undefined) {\n                        urlParts[key] = params[part];\n                    }\n                });\n                return urlParts.join('/');\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/cart/estimate-service.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n        'Magento_Checkout/js/model/cart/totals-processor/default'\n    ],\n    function (quote, defaultProcessor, totalsDefaultProvider) {\n        'use strict';\n\n        var rateProcessors = [],\n            totalsProcessors = [];\n\n        quote.shippingAddress.subscribe(function () {\n            var type = quote.shippingAddress().getType();\n            if (quote.isVirtual()) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type]\n                    ? totalsProcessors[type].estimateTotals(quote.shippingAddress())\n                    : totalsProcessors['default'].estimateTotals(quote.shippingAddress());\n            } else {\n                // update rates list when estimated address was set\n                rateProcessors['default'] = defaultProcessor;\n                rateProcessors[type]\n                    ? rateProcessors[type].getRates(quote.shippingAddress())\n                    : rateProcessors['default'].getRates(quote.shippingAddress());\n\n            }\n        });\n        quote.shippingMethod.subscribe(function () {\n            totalsDefaultProvider.estimateTotals(quote.shippingAddress());\n        });\n        quote.billingAddress.subscribe(function () {\n            var type = quote.billingAddress().getType();\n            if (quote.isVirtual()) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type]\n                    ? totalsProcessors[type].estimateTotals(quote.billingAddress())\n                    : totalsProcessors['default'].estimateTotals(quote.billingAddress());\n            }\n        });\n    }\n);\n","Magento_Checkout/js/model/cart/totals-processor/default.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'underscore',\n        'Magento_Checkout/js/model/resource-url-manager',\n        'Magento_Checkout/js/model/quote',\n        'mage/storage',\n        'Magento_Checkout/js/model/totals',\n        'Magento_Checkout/js/model/error-processor'\n    ],\n    function (_, resourceUrlManager, quote, storage, totalsService, errorProcessor) {\n        'use strict';\n\n        return {\n            requiredFields: ['countryId', 'region', 'regionId', 'postcode'],\n\n            /**\n             * Get shipping rates for specified address.\n             */\n            estimateTotals: function (address) {\n                var serviceUrl, payload;\n                totalsService.isLoading(true);\n                serviceUrl = resourceUrlManager.getUrlForTotalsEstimationForNewAddress(quote),\n                    payload = {\n                        addressInformation: {\n                            address: _.pick(address, this.requiredFields)\n                        }\n                    };\n\n                if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n                    payload.addressInformation['shipping_method_code'] = quote.shippingMethod()['method_code'];\n                    payload.addressInformation['shipping_carrier_code'] = quote.shippingMethod()['carrier_code'];\n                }\n\n                storage.post(\n                    serviceUrl, JSON.stringify(payload), false\n                ).done(\n                    function (result) {\n                        quote.setTotals(result);\n                    }\n                ).fail(\n                    function (response) {\n                        errorProcessor.process(response);\n                    }\n                ).always(\n                    function () {\n                        totalsService.isLoading(false);\n                    }\n                );\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/payment/additional-validators.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [],\n    function() {\n        'use strict';\n        var validators = [];\n        return {\n            /**\n             * Register unique validator\n             *\n             * @param validator\n             */\n            registerValidator: function(validator) {\n                validators.push(validator);\n            },\n\n            /**\n             * Returns array of registered validators\n             *\n             * @returns {Array}\n             */\n            getValidators: function() {\n                return validators;\n            },\n\n            /**\n             * Process validators\n             *\n             * @returns {boolean}\n             */\n            validate: function() {\n                var validationResult = true;\n\n                if (validators.length <= 0) {\n                    return validationResult;\n                }\n\n                validators.forEach(function(item) {\n                    if (item.validate() == false) {\n                        validationResult = false;\n                        return false;\n                    }\n                });\n                return validationResult;\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/payment/method-converter.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'underscore'\n    ],\n    function (_) {\n        'use strict';\n\n        return function (methods) {\n            _.each(methods, function(method) {\n                if (method.hasOwnProperty('code')) {\n                    method.method = method.code;\n                    delete method.code;\n                }\n            });\n\n            return methods;\n        };\n    }\n);\n","Magento_Checkout/js/model/payment/method-list.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko'\n    ],\n    function(ko) {\n        'use strict';\n        return ko.observableArray([]);\n    }\n);\n","Magento_Checkout/js/model/payment/renderer-list.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'ko'\n    ],\n    function(ko) {\n        'use strict';\n        return ko.observableArray([]);\n    }\n);\n","Magento_Checkout/js/model/shipping-address/form-popup-state.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'ko'\n    ],\n    function(ko) {\n        'use strict';\n        return {\n            isVisible: ko.observable(false)\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-rate-processor/customer-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/model/resource-url-manager',\n        'Magento_Checkout/js/model/quote',\n        'mage/storage',\n        'Magento_Checkout/js/model/shipping-service',\n        'Magento_Checkout/js/model/shipping-rate-registry',\n        'Magento_Checkout/js/model/error-processor'\n    ],\n    function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n        \"use strict\";\n        return {\n            getRates: function(address) {\n                shippingService.isLoading(true);\n                var cache = rateRegistry.get(address.getKey());\n                if (cache) {\n                    shippingService.setShippingRates(cache);\n                    shippingService.isLoading(false);\n                } else {\n                    storage.post(\n                        resourceUrlManager.getUrlForEstimationShippingMethodsByAddressId(),\n                        JSON.stringify({\n                            addressId: address.customerAddressId\n                        }),\n                        false\n                    ).done(\n                        function(result) {\n                            rateRegistry.set(address.getKey(), result);\n                            shippingService.setShippingRates(result);\n                        }\n\n                    ).fail(\n                        function(response) {\n                            shippingService.setShippingRates([]);\n                            errorProcessor.process(response);\n                        }\n                    ).always(\n                        function () {\n                            shippingService.isLoading(false);\n                        }\n                    );\n                }\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-rate-processor/new-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/model/resource-url-manager',\n        'Magento_Checkout/js/model/quote',\n        'mage/storage',\n        'Magento_Checkout/js/model/shipping-service',\n        'Magento_Checkout/js/model/shipping-rate-registry',\n        'Magento_Checkout/js/model/error-processor'\n    ],\n    function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n        'use strict';\n\n        return {\n            /**\n             * Get shipping rates for specified address.\n             * @param {Object} address\n             */\n            getRates: function (address) {\n                shippingService.isLoading(true);\n                var cache = rateRegistry.get(address.getCacheKey()),\n                    serviceUrl = resourceUrlManager.getUrlForEstimationShippingMethodsForNewAddress(quote),\n                    payload = JSON.stringify({\n                            address: {\n                                'street': address.street,\n                                'city': address.city,\n                                'region_id': address.regionId,\n                                'region': address.region,\n                                'country_id': address.countryId,\n                                'postcode': address.postcode,\n                                'email': address.email,\n                                'customer_id': address.customerId,\n                                'firstname': address.firstname,\n                                'lastname': address.lastname,\n                                'middlename': address.middlename,\n                                'prefix': address.prefix,\n                                'suffix': address.suffix,\n                                'vat_id': address.vatId,\n                                'company': address.company,\n                                'telephone': address.telephone,\n                                'fax': address.fax,\n                                'custom_attributes': address.customAttributes,\n                                'save_in_address_book': address.saveInAddressBook\n                            }\n                        }\n                    );\n\n                if (cache) {\n                    shippingService.setShippingRates(cache);\n                    shippingService.isLoading(false);\n                } else {\n                    storage.post(\n                        serviceUrl, payload, false\n                    ).done(\n                        function (result) {\n                            rateRegistry.set(address.getCacheKey(), result);\n                            shippingService.setShippingRates(result);\n                        }\n                    ).fail(\n                        function (response) {\n                            shippingService.setShippingRates([]);\n                            errorProcessor.process(response);\n                        }\n                    ).always(\n                        function () {\n                            shippingService.isLoading(false);\n                        }\n                    );\n                }\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-save-processor/default.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define,alert*/\ndefine(\n    [\n        'ko',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/resource-url-manager',\n        'mage/storage',\n        'Magento_Checkout/js/model/payment-service',\n        'Magento_Checkout/js/model/payment/method-converter',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/select-billing-address'\n    ],\n    function (\n        ko,\n        quote,\n        resourceUrlManager,\n        storage,\n        paymentService,\n        methodConverter,\n        errorProcessor,\n        fullScreenLoader,\n        selectBillingAddressAction\n    ) {\n        'use strict';\n\n        return {\n            saveShippingInformation: function () {\n                var payload;\n\n                if (!quote.billingAddress()) {\n                    selectBillingAddressAction(quote.shippingAddress());\n                }\n\n                payload = {\n                    addressInformation: {\n                        shipping_address: quote.shippingAddress(),\n                        billing_address: quote.billingAddress(),\n                        shipping_method_code: quote.shippingMethod().method_code,\n                        shipping_carrier_code: quote.shippingMethod().carrier_code\n                    }\n                };\n\n                fullScreenLoader.startLoader();\n\n                return storage.post(\n                    resourceUrlManager.getUrlForSetShippingInformation(quote),\n                    JSON.stringify(payload)\n                ).done(\n                    function (response) {\n                        quote.setTotals(response.totals);\n                        paymentService.setPaymentMethods(methodConverter(response.payment_methods));\n                        fullScreenLoader.stopLoader();\n                    }\n                ).fail(\n                    function (response) {\n                        errorProcessor.process(response);\n                        fullScreenLoader.stopLoader();\n                    }\n                );\n            }\n        };\n    }\n);\n","Magento_Checkout/js/view/authentication-messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/view/messages',\n    'Magento_Checkout/js/model/authentication-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_Checkout/js/view/authentication.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Ui/js/form/form',\n        'Magento_Customer/js/action/login',\n        'Magento_Customer/js/model/customer',\n        'mage/validation',\n        'Magento_Checkout/js/model/authentication-messages',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function($, Component, loginAction, customer, validation, messageContainer, fullScreenLoader) {\n        'use strict';\n        var checkoutConfig = window.checkoutConfig;\n\n        return Component.extend({\n            isGuestCheckoutAllowed: checkoutConfig.isGuestCheckoutAllowed,\n            isCustomerLoginRequired: checkoutConfig.isCustomerLoginRequired,\n            registerUrl: checkoutConfig.registerUrl,\n            forgotPasswordUrl: checkoutConfig.forgotPasswordUrl,\n            autocomplete: checkoutConfig.autocomplete,\n            defaults: {\n                template: 'Magento_Checkout/authentication'\n            },\n\n            /** Is login form enabled for current customer */\n            isActive: function() {\n                return !customer.isLoggedIn();\n            },\n\n            /** Provide login action */\n            login: function(loginForm) {\n                var loginData = {},\n                    formDataArray = $(loginForm).serializeArray();\n\n                formDataArray.forEach(function (entry) {\n                    loginData[entry.name] = entry.value;\n                });\n\n                if($(loginForm).validation()\n                    && $(loginForm).validation('isValid')\n                ) {\n                    fullScreenLoader.startLoader();\n                    loginAction(loginData, checkoutConfig.checkoutUrl, undefined, messageContainer).always(function() {\n                        fullScreenLoader.stopLoader();\n                    });\n                }\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/beforePlaceOrder.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    ['uiComponent'],\n    function (Component) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                displayArea: 'beforePlaceOrder'\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/billing-address.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n/*global define*/\ndefine(\n    [\n        'ko',\n        'Magento_Ui/js/form/form',\n        'Magento_Customer/js/model/customer',\n        'Magento_Customer/js/model/address-list',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/action/create-billing-address',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'Magento_Customer/js/customer-data',\n        'Magento_Checkout/js/action/set-billing-address',\n        'Magento_Ui/js/model/messageList',\n        'mage/translate'\n    ],\n    function (\n        ko,\n        Component,\n        customer,\n        addressList,\n        quote,\n        createBillingAddress,\n        selectBillingAddress,\n        checkoutData,\n        checkoutDataResolver,\n        customerData,\n        setBillingAddressAction,\n        globalMessageList,\n        $t\n    ) {\n        'use strict';\n\n        var lastSelectedBillingAddress = null,\n            newAddressOption = {\n                getAddressInline: function () {\n                return $t('New Address');\n            },\n                customerAddressId: null\n            },\n            countryData = customerData.get('directory-data'),\n            addressOptions = addressList().filter(function (address) {\n                return address.getType() == 'customer-address';\n            });\n\n        addressOptions.push(newAddressOption);\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/billing-address'\n            },\n            currentBillingAddress: quote.billingAddress,\n            addressOptions: addressOptions,\n            customerHasAddresses: addressOptions.length > 1,\n\n            /**\n             * Init component\n             */\n            initialize: function () {\n                this._super();\n                quote.paymentMethod.subscribe(function () {\n                    checkoutDataResolver.resolveBillingAddress();\n                }, this);\n            },\n\n            /**\n             * @return {exports.initObservable}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe({\n                        selectedAddress: null,\n                        isAddressDetailsVisible: quote.billingAddress() != null,\n                        isAddressFormVisible: !customer.isLoggedIn() || addressOptions.length == 1,\n                        isAddressSameAsShipping: false,\n                        saveInAddressBook: 1\n                    });\n\n                quote.billingAddress.subscribe(function (newAddress) {\n                    if (quote.isVirtual()) {\n                        this.isAddressSameAsShipping(false);\n                    } else {\n                        this.isAddressSameAsShipping(\n                            newAddress != null &&\n                            newAddress.getCacheKey() == quote.shippingAddress().getCacheKey()\n                        );\n                    }\n\n                    if (newAddress != null && newAddress.saveInAddressBook !== undefined) {\n                        this.saveInAddressBook(newAddress.saveInAddressBook);\n                    } else {\n                        this.saveInAddressBook(1);\n                    }\n                    this.isAddressDetailsVisible(true);\n                }, this);\n\n                return this;\n            },\n\n            canUseShippingAddress: ko.computed(function () {\n                return !quote.isVirtual() && quote.shippingAddress() && quote.shippingAddress().canUseForBilling();\n            }),\n\n            /**\n             * @param {Object} address\n             * @return {*}\n             */\n            addressOptionsText: function (address) {\n                return address.getAddressInline();\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            useShippingAddress: function () {\n                if (this.isAddressSameAsShipping()) {\n                    selectBillingAddress(quote.shippingAddress());\n                    if (window.checkoutConfig.reloadOnBillingAddress) {\n                        setBillingAddressAction(globalMessageList);\n                    }\n                    this.isAddressDetailsVisible(true);\n                } else {\n                    lastSelectedBillingAddress = quote.billingAddress();\n                    quote.billingAddress(null);\n                    this.isAddressDetailsVisible(false);\n                }\n                checkoutData.setSelectedBillingAddress(null);\n\n                return true;\n            },\n\n            /**\n             * Update address action\n             */\n            updateAddress: function () {\n                if (this.selectedAddress() && this.selectedAddress() != newAddressOption) {\n                    selectBillingAddress(this.selectedAddress());\n                    checkoutData.setSelectedBillingAddress(this.selectedAddress().getKey());\n                    if (window.checkoutConfig.reloadOnBillingAddress) {\n                        setBillingAddressAction(globalMessageList);\n                    }\n                } else {\n                    this.source.set('params.invalid', false);\n                    this.source.trigger(this.dataScopePrefix + '.data.validate');\n                    if (this.source.get(this.dataScopePrefix + '.custom_attributes')) {\n                        this.source.trigger(this.dataScopePrefix + '.custom_attributes.data.validate');\n                    };\n\n                    if (!this.source.get('params.invalid')) {\n                        var addressData = this.source.get(this.dataScopePrefix),\n                            newBillingAddress;\n\n                        if (customer.isLoggedIn() && !this.customerHasAddresses) {\n                            this.saveInAddressBook(1);\n                        }\n                        addressData.save_in_address_book = this.saveInAddressBook() ? 1 : 0;\n                        newBillingAddress = createBillingAddress(addressData);\n\n                        // New address must be selected as a billing address\n                        selectBillingAddress(newBillingAddress);\n                        checkoutData.setSelectedBillingAddress(newBillingAddress.getKey());\n                        checkoutData.setNewCustomerBillingAddress(addressData);\n\n                        if (window.checkoutConfig.reloadOnBillingAddress) {\n                            setBillingAddressAction(globalMessageList);\n                        }\n                    }\n                }\n            },\n\n            /**\n             * Edit address action\n             */\n            editAddress: function () {\n                lastSelectedBillingAddress = quote.billingAddress();\n                quote.billingAddress(null);\n                this.isAddressDetailsVisible(false);\n            },\n\n            /**\n             * Cancel address edit action\n             */\n            cancelAddressEdit: function () {\n                this.restoreBillingAddress();\n\n                if (quote.billingAddress()) {\n                    // restore 'Same As Shipping' checkbox state\n                    this.isAddressSameAsShipping(\n                        quote.billingAddress() != null &&\n                            quote.billingAddress().getCacheKey() == quote.shippingAddress().getCacheKey() &&\n                            !quote.isVirtual()\n                    );\n                    this.isAddressDetailsVisible(true);\n                }\n            },\n\n            /**\n             * Restore billing address\n             */\n            restoreBillingAddress: function () {\n                if (lastSelectedBillingAddress != null) {\n                    selectBillingAddress(lastSelectedBillingAddress);\n                }\n            },\n\n            /**\n             * @param {Object} address\n             */\n            onAddressChange: function (address) {\n                this.isAddressFormVisible(address == newAddressOption);\n            },\n\n            /**\n             * @param {int} countryId\n             * @return {*}\n             */\n            getCountryName: function (countryId) {\n                return countryData()[countryId] != undefined ? countryData()[countryId].name : '';\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/estimation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Catalog/js/price-utils',\n        'Magento_Checkout/js/model/totals',\n        'Magento_Checkout/js/model/sidebar'\n    ],\n    function (Component, quote, priceUtils, totals, sidebarModel) {\n        'use strict';\n\n        return Component.extend({\n            isLoading: totals.isLoading,\n            getQuantity: function () {\n                if (totals.totals()) {\n                    return parseFloat(totals.totals()['items_qty']);\n                }\n\n                return 0;\n            },\n            getPureValue: function () {\n                if (totals.totals()) {\n                    return parseFloat(totals.getSegment('grand_total').value);\n                }\n\n                return 0;\n            },\n            showSidebar: function () {\n                sidebarModel.show();\n            },\n            getFormattedPrice: function (price) {\n                return priceUtils.formatPrice(price, quote.getPriceFormat());\n            },\n            getValue: function () {\n                return this.getFormattedPrice(this.getPureValue());\n            }\n        });\n    }\n);\n\n","Magento_Checkout/js/view/minicart.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'ko',\n    'underscore',\n    'sidebar'\n], function (Component, customerData, $, ko, _) {\n    'use strict';\n\n    var sidebarInitialized = false,\n        addToCartCalls = 0,\n        miniCart;\n\n    miniCart = $('[data-block=\\'minicart\\']');\n    miniCart.on('dropdowndialogopen', function () {\n        initSidebar();\n    });\n\n    /**\n     * @return {Boolean}\n     */\n    function initSidebar() {\n        if (miniCart.data('mageSidebar')) {\n            miniCart.sidebar('update');\n        }\n\n        if (!$('[data-role=product-item]').length) {\n            return false;\n        }\n        miniCart.trigger('contentUpdated');\n\n        if (sidebarInitialized) {\n            return false;\n        }\n        sidebarInitialized = true;\n        miniCart.sidebar({\n            'targetElement': 'div.block.block-minicart',\n            'url': {\n                'checkout': window.checkout.checkoutUrl,\n                'update': window.checkout.updateItemQtyUrl,\n                'remove': window.checkout.removeItemUrl,\n                'loginUrl': window.checkout.customerLoginUrl,\n                'isRedirectRequired': window.checkout.isRedirectRequired\n            },\n            'button': {\n                'checkout': '#top-cart-btn-checkout',\n                'remove': '#mini-cart a.action.delete',\n                'close': '#btn-minicart-close'\n            },\n            'showcart': {\n                'parent': 'span.counter',\n                'qty': 'span.counter-number',\n                'label': 'span.counter-label'\n            },\n            'minicart': {\n                'list': '#mini-cart',\n                'content': '#minicart-content-wrapper',\n                'qty': 'div.items-total',\n                'subtotal': 'div.subtotal span.price',\n                'maxItemsVisible': window.checkout.minicartMaxItemsVisible\n            },\n            'item': {\n                'qty': ':input.cart-item-qty',\n                'button': ':button.update-cart-item'\n            },\n            'confirmMessage': $.mage.__(\n                'Are you sure you would like to remove this item from the shopping cart?'\n            )\n        });\n    }\n\n    return Component.extend({\n        shoppingCartUrl: window.checkout.shoppingCartUrl,\n        cart: {},\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            var self = this,\n                cartData = customerData.get('cart');\n\n            this.update(cartData());\n            cartData.subscribe(function (updatedCart) {\n                addToCartCalls--;\n                this.isLoading(addToCartCalls > 0);\n                sidebarInitialized = false;\n                this.update(updatedCart);\n                initSidebar();\n            }, this);\n            $('[data-block=\"minicart\"]').on('contentLoading', function (event) {\n                addToCartCalls++;\n                self.isLoading(true);\n            });\n\n            return this._super();\n        },\n        isLoading: ko.observable(false),\n        initSidebar: initSidebar,\n\n        /**\n         * @return {Boolean}\n         */\n        closeSidebar: function () {\n            var minicart = $('[data-block=\"minicart\"]');\n            minicart.on('click', '[data-action=\"close\"]', function (event) {\n                event.stopPropagation();\n                minicart.find('[data-role=\"dropdownDialog\"]').dropdownDialog('close');\n            });\n\n            return true;\n        },\n\n        /**\n         * @param {String} productType\n         * @return {*|String}\n         */\n        getItemRenderer: function (productType) {\n            return this.itemRenderer[productType] || 'defaultRenderer';\n        },\n\n        /**\n         * Update mini shopping cart content.\n         *\n         * @param {Object} updatedCart\n         * @returns void\n         */\n        update: function (updatedCart) {\n            _.each(updatedCart, function (value, key) {\n                if (!this.cart.hasOwnProperty(key)) {\n                    this.cart[key] = ko.observable();\n                }\n                this.cart[key](value);\n            }, this);\n        },\n\n        /**\n         * Get cart param by name.\n         * @param {String} name\n         * @returns {*}\n         */\n        getCartParam: function (name) {\n            if (!_.isUndefined(name)) {\n                if (!this.cart.hasOwnProperty(name)) {\n                    this.cart[name] = ko.observable();\n                }\n            }\n\n            return this.cart[name]();\n        }\n    });\n});\n","Magento_Checkout/js/view/payment.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        \"underscore\",\n        'uiComponent',\n        'ko',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/step-navigator',\n        'Magento_Checkout/js/model/payment-service',\n        'Magento_Checkout/js/model/payment/method-converter',\n        'Magento_Checkout/js/action/get-payment-information',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'mage/translate'\n    ],\n    function (\n        $,\n        _,\n        Component,\n        ko,\n        quote,\n        stepNavigator,\n        paymentService,\n        methodConverter,\n        getPaymentInformation,\n        checkoutDataResolver,\n        $t\n    ) {\n        'use strict';\n\n        /** Set payment methods to collection */\n        paymentService.setPaymentMethods(methodConverter(window.checkoutConfig.paymentMethods));\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/payment',\n                activeMethod: ''\n            },\n            isVisible: ko.observable(quote.isVirtual()),\n            quoteIsVirtual: quote.isVirtual(),\n            isPaymentMethodsAvailable: ko.computed(function () {\n                return paymentService.getAvailablePaymentMethods().length > 0;\n            }),\n\n            initialize: function () {\n                this._super();\n                checkoutDataResolver.resolvePaymentMethod();\n                stepNavigator.registerStep(\n                    'payment',\n                    null,\n                    $t('Review & Payments'),\n                    this.isVisible,\n                    _.bind(this.navigate, this),\n                    20\n                );\n                return this;\n            },\n\n            navigate: function () {\n                var self = this;\n                getPaymentInformation().done(function () {\n                    self.isVisible(true);\n                });\n            },\n\n            getFormKey: function() {\n                return window.checkoutConfig.formKey;\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/progress-bar.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        \"underscore\",\n        'ko',\n        'uiComponent',\n        'Magento_Checkout/js/model/step-navigator',\n        'jquery/jquery.hashchange'\n    ],\n    function ($, _, ko, Component, stepNavigator) {\n        var steps = stepNavigator.steps;\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/progress-bar',\n                visible: true\n            },\n            steps: steps,\n\n            initialize: function() {\n                this._super();\n                $(window).hashchange(_.bind(stepNavigator.handleHash, stepNavigator));\n                stepNavigator.handleHash();\n            },\n\n            sortItems: function(itemOne, itemTwo) {\n                return stepNavigator.sortItems(itemOne, itemTwo);\n            },\n\n            navigateTo: function(step) {\n                stepNavigator.navigateTo(step.code);\n            },\n\n            isProcessed: function(item) {\n                return stepNavigator.isProcessed(item.code);\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/registration.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'uiComponent',\n        'Magento_Ui/js/model/messageList'\n    ],\n    function ($, Component, messageList) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/registration',\n                accountCreated: false,\n                creationStarted: false,\n                isFormVisible: true\n            },\n\n            /**\n             * Initialize observable properties\n             */\n            initObservable: function () {\n                this._super()\n                    .observe('accountCreated')\n                    .observe('isFormVisible')\n                    .observe('creationStarted');\n\n                return this;\n            },\n\n            /**\n             * @return {*}\n             */\n            getEmailAddress: function () {\n                return this.email;\n            },\n\n            /**\n             * Create new user account\n             */\n            createAccount: function () {\n                this.creationStarted(true);\n                $.post(\n                    this.registrationUrl\n                ).done(\n                    function (response) {\n\n                        if (response.errors == false) {\n                            this.accountCreated(true)\n                        } else {\n                            messageList.addErrorMessage(response);\n                        }\n                        this.isFormVisible(false);\n                    }.bind(this)\n                ).fail(\n                    function (response) {\n                        this.accountCreated(false)\n                        this.isFormVisible(false);\n                        messageList.addErrorMessage(response);\n                    }.bind(this)\n                );\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/shipping-information.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'uiComponent',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/step-navigator',\n        'Magento_Checkout/js/model/sidebar'\n    ],\n    function($, Component, quote, stepNavigator, sidebarModel) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/shipping-information'\n            },\n\n            isVisible: function() {\n                return !quote.isVirtual() && stepNavigator.isProcessed('shipping');\n            },\n\n            getShippingMethodTitle: function() {\n                var shippingMethod = quote.shippingMethod();\n                return shippingMethod ? shippingMethod.carrier_title + \" - \" + shippingMethod.method_title : '';\n            },\n\n            back: function() {\n                sidebarModel.hide();\n                stepNavigator.navigateTo('shipping');\n            },\n\n            backToShippingMethod: function() {\n                sidebarModel.hide();\n                stepNavigator.navigateTo('shipping', 'opc-shipping_method');\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/shipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'Magento_Ui/js/form/form',\n        'ko',\n        'Magento_Customer/js/model/customer',\n        'Magento_Customer/js/model/address-list',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/action/create-shipping-address',\n        'Magento_Checkout/js/action/select-shipping-address',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-address/form-popup-state',\n        'Magento_Checkout/js/model/shipping-service',\n        'Magento_Checkout/js/action/select-shipping-method',\n        'Magento_Checkout/js/model/shipping-rate-registry',\n        'Magento_Checkout/js/action/set-shipping-information',\n        'Magento_Checkout/js/model/step-navigator',\n        'Magento_Ui/js/modal/modal',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'Magento_Checkout/js/checkout-data',\n        'uiRegistry',\n        'mage/translate',\n        'Magento_Checkout/js/model/shipping-rate-service'\n    ],\n    function (\n        $,\n        _,\n        Component,\n        ko,\n        customer,\n        addressList,\n        addressConverter,\n        quote,\n        createShippingAddress,\n        selectShippingAddress,\n        shippingRatesValidator,\n        formPopUpState,\n        shippingService,\n        selectShippingMethodAction,\n        rateRegistry,\n        setShippingInformationAction,\n        stepNavigator,\n        modal,\n        checkoutDataResolver,\n        checkoutData,\n        registry,\n        $t\n    ) {\n        'use strict';\n\n        var popUp = null;\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/shipping'\n            },\n            visible: ko.observable(!quote.isVirtual()),\n            errorValidationMessage: ko.observable(false),\n            isCustomerLoggedIn: customer.isLoggedIn,\n            isFormPopUpVisible: formPopUpState.isVisible,\n            isFormInline: addressList().length == 0,\n            isNewAddressAdded: ko.observable(false),\n            saveInAddressBook: 1,\n            quoteIsVirtual: quote.isVirtual(),\n\n            /**\n             * @return {exports}\n             */\n            initialize: function () {\n                var self = this,\n                    hasNewAddress,\n                    fieldsetName = 'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset';\n\n                this._super();\n                shippingRatesValidator.initFields(fieldsetName);\n\n                if (!quote.isVirtual()) {\n                    stepNavigator.registerStep(\n                        'shipping',\n                        '',\n                        $t('Shipping'),\n                        this.visible, _.bind(this.navigate, this),\n                        10\n                    );\n                }\n                checkoutDataResolver.resolveShippingAddress();\n\n                hasNewAddress = addressList.some(function (address) {\n                    return address.getType() == 'new-customer-address';\n                });\n\n                this.isNewAddressAdded(hasNewAddress);\n\n                this.isFormPopUpVisible.subscribe(function (value) {\n                    if (value) {\n                        self.getPopUp().openModal();\n                    }\n                });\n\n                quote.shippingMethod.subscribe(function () {\n                    self.errorValidationMessage(false);\n                });\n\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n                    if (shippingAddressData) {\n                        checkoutProvider.set(\n                            'shippingAddress',\n                            $.extend({}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                        );\n                    }\n                    checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                        checkoutData.setShippingAddressFromData(shippingAddressData);\n                    });\n                });\n\n                return this;\n            },\n\n            /**\n             * Load data from server for shipping step\n             */\n            navigate: function () {\n                //load data from server for shipping step\n            },\n\n            /**\n             * @return {*}\n             */\n            getPopUp: function () {\n                var self = this,\n                    buttons;\n\n                if (!popUp) {\n                    buttons = this.popUpForm.options.buttons;\n                    this.popUpForm.options.buttons = [\n                        {\n                            text: buttons.save.text ? buttons.save.text : $t('Save Address'),\n                            class: buttons.save.class ? buttons.save.class : 'action primary action-save-address',\n                            click: self.saveNewAddress.bind(self)\n                        },\n                        {\n                            text: buttons.cancel.text ? buttons.cancel.text : $t('Cancel'),\n                            class: buttons.cancel.class ? buttons.cancel.class : 'action secondary action-hide-popup',\n                            click: function () {\n                                this.closeModal();\n                            }\n                        }\n                    ];\n                    this.popUpForm.options.closed = function () {\n                        self.isFormPopUpVisible(false);\n                    };\n                    popUp = modal(this.popUpForm.options, $(this.popUpForm.element));\n                }\n\n                return popUp;\n            },\n\n            /**\n             * Show address form popup\n             */\n            showFormPopUp: function () {\n                this.isFormPopUpVisible(true);\n            },\n\n            /**\n             * Save new shipping address\n             */\n            saveNewAddress: function () {\n                var addressData,\n                    newShippingAddress;\n\n                this.source.set('params.invalid', false);\n                this.source.trigger('shippingAddress.data.validate');\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get('shippingAddress');\n                    // if user clicked the checkbox, its value is true or false. Need to convert.\n                    addressData.save_in_address_book = this.saveInAddressBook ? 1 : 0;\n\n                    // New address must be selected as a shipping address\n                    newShippingAddress = createShippingAddress(addressData);\n                    selectShippingAddress(newShippingAddress);\n                    checkoutData.setSelectedShippingAddress(newShippingAddress.getKey());\n                    checkoutData.setNewCustomerShippingAddress(addressData);\n                    this.getPopUp().closeModal();\n                    this.isNewAddressAdded(true);\n                }\n            },\n\n            /**\n             * Shipping Method View\n             */\n            rates: shippingService.getShippingRates(),\n            isLoading: shippingService.isLoading,\n            isSelected: ko.computed(function () {\n                    return quote.shippingMethod() ?\n                        quote.shippingMethod().carrier_code + '_' + quote.shippingMethod().method_code\n                        : null;\n                }\n            ),\n\n            /**\n             * @param {Object} shippingMethod\n             * @return {Boolean}\n             */\n            selectShippingMethod: function (shippingMethod) {\n                selectShippingMethodAction(shippingMethod);\n                checkoutData.setSelectedShippingRate(shippingMethod.carrier_code + '_' + shippingMethod.method_code);\n\n                return true;\n            },\n\n            /**\n             * Set shipping information handler\n             */\n            setShippingInformation: function () {\n                if (this.validateShippingInformation()) {\n                    setShippingInformationAction().done(\n                        function () {\n                            stepNavigator.next();\n                        }\n                    );\n                }\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            validateShippingInformation: function () {\n                var shippingAddress,\n                    addressData,\n                    loginFormSelector = 'form[data-role=email-with-possible-login]',\n                    emailValidationResult = customer.isLoggedIn();\n\n                if (!quote.shippingMethod()) {\n                    this.errorValidationMessage('Please specify a shipping method.');\n\n                    return false;\n                }\n\n                if (!customer.isLoggedIn()) {\n                    $(loginFormSelector).validation();\n                    emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n                }\n\n                if (this.isFormInline) {\n                    this.source.set('params.invalid', false);\n                    this.source.trigger('shippingAddress.data.validate');\n\n                    if (this.source.get('shippingAddress.custom_attributes')) {\n                        this.source.trigger('shippingAddress.custom_attributes.data.validate');\n                    }\n\n                    if (this.source.get('params.invalid') ||\n                        !quote.shippingMethod().method_code ||\n                        !quote.shippingMethod().carrier_code ||\n                        !emailValidationResult\n                    ) {\n                        return false;\n                    }\n\n                    shippingAddress = quote.shippingAddress();\n                    addressData = addressConverter.formAddressDataToQuoteAddress(\n                        this.source.get('shippingAddress')\n                    );\n\n                    //Copy form data to quote shipping address object\n                    for (var field in addressData) {\n\n                        if (addressData.hasOwnProperty(field) &&\n                            shippingAddress.hasOwnProperty(field) &&\n                            typeof addressData[field] != 'function' &&\n                            _.isEqual(shippingAddress[field], addressData[field])\n                        ) {\n                            shippingAddress[field] = addressData[field];\n                        } else if (typeof addressData[field] != 'function' &&\n                            !_.isEqual(shippingAddress[field], addressData[field])) {\n                            shippingAddress = addressData;\n                            break;\n                        }\n                    }\n\n                    if (customer.isLoggedIn()) {\n                        shippingAddress.save_in_address_book = 1;\n                    }\n                    selectShippingAddress(shippingAddress);\n                }\n\n                if (!emailValidationResult) {\n                    $(loginFormSelector + ' input[name=username]').focus();\n\n                    return false;\n                }\n\n                return true;\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/sidebar.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'ko',\n        'jquery',\n        'Magento_Checkout/js/model/sidebar'\n    ],\n    function(Component, ko, $, sidebarModel) {\n        'use strict';\n        return Component.extend({\n            setModalElement: function(element) {\n                sidebarModel.setPopup($(element));\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/totals'\n    ],\n    function(Component, totals) {\n        'use strict';\n        return Component.extend({\n            isLoading: totals.isLoading\n        });\n    }\n);\n","Magento_Checkout/js/view/cart/shipping-estimation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Ui/js/form/form',\n        'Magento_Checkout/js/action/select-shipping-address',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/model/cart/estimate-service',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'uiRegistry',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'mage/validation'\n    ],\n    function (\n        $,\n        Component,\n        selectShippingAddress,\n        addressConverter,\n        estimateService,\n        checkoutData,\n        shippingRatesValidator,\n        registry,\n        quote,\n        checkoutDataResolver\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/cart/shipping-estimation'\n            },\n            isVirtual: quote.isVirtual(),\n\n            /**\n             * @override\n             */\n            initialize: function () {\n                this._super();\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    var address, estimatedAddress;\n\n                    checkoutDataResolver.resolveEstimationAddress();\n                    address = quote.isVirtual() ? quote.billingAddress() : quote.shippingAddress();\n\n                    if (address) {\n                        estimatedAddress = address.isEditable() ?\n                            addressConverter.quoteAddressToFormAddressData(address) :\n                            addressConverter.quoteAddressToFormAddressData(\n                                addressConverter.addressToEstimationAddress(address)\n                            );\n                        checkoutProvider.set(\n                            'shippingAddress',\n                            $.extend({}, checkoutProvider.get('shippingAddress'), estimatedAddress)\n                        );\n                    }\n\n                    if (!quote.isVirtual()) {\n                        checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                            checkoutData.setShippingAddressFromData(shippingAddressData);\n                        });\n                    } else {\n                        checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                            checkoutData.setBillingAddressFromData(shippingAddressData);\n                        });\n                    }\n                });\n\n                return this;\n            },\n\n            /**\n             * @override\n             */\n            initElement: function (element) {\n                this._super();\n\n                if (element.index === 'address-fieldsets') {\n                    shippingRatesValidator.bindChangeHandlers(element.elems(), true, 500);\n                    element.elems.subscribe(function (elems) {\n                        shippingRatesValidator.doElementBinding(elems[elems.length - 1], true, 500);\n                    });\n                }\n\n                return this;\n            },\n\n            /**\n             * Returns shipping rates for address\n             * @returns void\n             */\n            getEstimationInfo: function () {\n                var addressData = null;\n\n                this.source.set('params.invalid', false);\n                this.source.trigger('shippingAddress.data.validate');\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get('shippingAddress');\n                    selectShippingAddress(addressConverter.formAddressDataToQuoteAddress(addressData));\n                }\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/cart/shipping-rates.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko',\n        'underscore',\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-service',\n        'Magento_Catalog/js/price-utils',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/action/select-shipping-method',\n        'Magento_Checkout/js/checkout-data'\n    ],\n    function (\n        ko,\n        _,\n        Component,\n        shippingService,\n        priceUtils,\n        quote,\n        selectShippingMethodAction,\n        checkoutData\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/cart/shipping-rates'\n            },\n            isVisible: ko.observable(!quote.isVirtual()),\n            isLoading: shippingService.isLoading,\n            shippingRates: shippingService.getShippingRates(),\n            shippingRateGroups: ko.observableArray([]),\n            selectedShippingMethod: ko.computed(function () {\n                    return quote.shippingMethod() ?\n                        quote.shippingMethod()['carrier_code'] + '_' + quote.shippingMethod()['method_code'] :\n                        null;\n                }\n            ),\n\n            /**\n             * @override\n             */\n            initObservable: function () {\n                var self = this;\n                this._super();\n\n                this.shippingRates.subscribe(function (rates) {\n                    self.shippingRateGroups([]);\n                    _.each(rates, function (rate) {\n                        var carrierTitle = rate['carrier_title'];\n\n                        if (self.shippingRateGroups.indexOf(carrierTitle) === -1) {\n                            self.shippingRateGroups.push(carrierTitle);\n                        }\n                    });\n                });\n\n                return this;\n            },\n\n            /**\n             * Get shipping rates for specific group based on title.\n             * @returns Array\n             */\n            getRatesForGroup: function (shippingRateGroupTitle) {\n                return _.filter(this.shippingRates(), function (rate) {\n                    return shippingRateGroupTitle === rate['carrier_title'];\n                });\n            },\n\n            /**\n             * Format shipping price.\n             * @returns {String}\n             */\n            getFormattedPrice: function (price) {\n                return priceUtils.formatPrice(price, quote.getPriceFormat());\n            },\n\n            /**\n             * Set shipping method.\n             * @param {String} methodData\n             * @returns bool\n             */\n            selectShippingMethod: function (methodData) {\n                selectShippingMethodAction(methodData);\n                checkoutData.setSelectedShippingRate(methodData['carrier_code'] + '_' + methodData['method_code']);\n\n                return true;\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/cart/totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/totals',\n        'Magento_Checkout/js/model/shipping-service'\n    ],\n    function (Component, totalsService, shippingService) {\n        'use strict';\n\n        return Component.extend({\n\n            isLoading: totalsService.isLoading,\n\n            /**\n             * @override\n             */\n            initialize: function () {\n                this._super();\n                totalsService.totals.subscribe(function () {\n                    window.dispatchEvent(new Event('resize'));\n                });\n                shippingService.getShippingRates().subscribe(function () {\n                    window.dispatchEvent(new Event('resize'));\n                });\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/cart/totals/shipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/shipping',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * @override\n             */\n            isCalculated: function () {\n                return !!quote.shippingMethod();\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Checkout/js/view/form/element/email.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/action/check-email-availability',\n    'Magento_Customer/js/action/login',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/validation'\n], function ($, Component, ko, customer, checkEmailAvailability, loginAction, quote, checkoutData, fullScreenLoader) {\n    'use strict';\n\n    var validatedEmail = checkoutData.getValidatedEmailValue();\n\n    if (validatedEmail && !customer.isLoggedIn()) {\n        quote.guestEmail = validatedEmail;\n    }\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/form/element/email',\n            email: checkoutData.getInputFieldEmailValue(),\n            emailFocused: false,\n            isLoading: false,\n            isPasswordVisible: false,\n            listens: {\n                email: 'emailHasChanged',\n                emailFocused: 'validateEmail'\n            }\n        },\n        checkDelay: 2000,\n        checkRequest: null,\n        isEmailCheckComplete: null,\n        isCustomerLoggedIn: customer.isLoggedIn,\n        forgotPasswordUrl: window.checkoutConfig.forgotPasswordUrl,\n        emailCheckTimeout: 0,\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['email', 'emailFocused', 'isLoading', 'isPasswordVisible']);\n\n            return this;\n        },\n\n        /**\n         * Callback on changing email property\n         */\n        emailHasChanged: function () {\n            var self = this;\n\n            clearTimeout(this.emailCheckTimeout);\n\n            if (self.validateEmail()) {\n                quote.guestEmail = self.email();\n                checkoutData.setValidatedEmailValue(self.email());\n            }\n            this.emailCheckTimeout = setTimeout(function () {\n                if (self.validateEmail()) {\n                    self.checkEmailAvailability();\n                } else {\n                    self.isPasswordVisible(false);\n                }\n            }, self.checkDelay);\n\n            checkoutData.setInputFieldEmailValue(self.email());\n        },\n\n        /**\n         * Check email existing.\n         */\n        checkEmailAvailability: function () {\n            var self = this;\n            this.validateRequest();\n            this.isEmailCheckComplete = $.Deferred();\n            this.isLoading(true);\n            this.checkRequest = checkEmailAvailability(this.isEmailCheckComplete, this.email());\n\n            $.when(this.isEmailCheckComplete).done(function () {\n                self.isPasswordVisible(false);\n            }).fail(function () {\n                self.isPasswordVisible(true);\n            }).always(function () {\n                self.isLoading(false);\n            });\n        },\n\n        /**\n         * If request has been sent -> abort it.\n         * ReadyStates for request aborting:\n         * 1 - The request has been set up\n         * 2 - The request has been sent\n         * 3 - The request is in process\n         */\n        validateRequest: function () {\n            if (this.checkRequest != null && $.inArray(this.checkRequest.readyState, [1, 2, 3])) {\n                this.checkRequest.abort();\n                this.checkRequest = null;\n            }\n        },\n\n        /**\n         * Local email validation.\n         *\n         * @param {Boolean} focused - input focus.\n         * @returns {Boolean} - validation result.\n         */\n        validateEmail: function (focused) {\n            var loginFormSelector = 'form[data-role=email-with-possible-login]',\n                usernameSelector = loginFormSelector + ' input[name=username]',\n                loginForm = $(loginFormSelector),\n                validator;\n\n            loginForm.validation();\n\n            if (focused === false && !!this.email()) {\n                return !!$(usernameSelector).valid();\n            }\n\n            validator = loginForm.validate();\n\n            return validator.check(usernameSelector);\n        },\n\n        /**\n         * Log in form submitting callback.\n         *\n         * @param {HTMLElement} loginForm - form element.\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if (this.isPasswordVisible() && $(loginForm).validation() && $(loginForm).validation('isValid')) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData).always(function() {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/default.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko',\n        'jquery',\n        'uiComponent',\n        'Magento_Checkout/js/action/place-order',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/payment-service',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'uiRegistry',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Ui/js/model/messages',\n        'uiLayout',\n        'Magento_Checkout/js/action/redirect-on-success'\n    ],\n    function (\n        ko,\n        $,\n        Component,\n        placeOrderAction,\n        selectPaymentMethodAction,\n        quote,\n        customer,\n        paymentService,\n        checkoutData,\n        checkoutDataResolver,\n        registry,\n        additionalValidators,\n        Messages,\n        layout,\n        redirectOnSuccessAction\n    ) {\n        'use strict';\n\n        return Component.extend({\n            redirectAfterPlaceOrder: true,\n            isPlaceOrderActionAllowed: ko.observable(quote.billingAddress() != null),\n\n            /**\n             * After place order callback\n             */\n            afterPlaceOrder: function () {\n                // Override this function and put after place order logic here\n            },\n\n            /**\n             * Initialize view.\n             *\n             * @return {exports}\n             */\n            initialize: function () {\n                var billingAddressCode,\n                    billingAddressData,\n                    defaultAddressData;\n\n                this._super().initChildren();\n                quote.billingAddress.subscribe(function (address) {\n                    this.isPlaceOrderActionAllowed(address !== null);\n                }, this);\n                checkoutDataResolver.resolveBillingAddress();\n\n                billingAddressCode = 'billingAddress' + this.getCode();\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    defaultAddressData = checkoutProvider.get(billingAddressCode);\n\n                    if (defaultAddressData === undefined) {\n                        // Skip if payment does not have a billing address form\n                        return;\n                    }\n                    billingAddressData = checkoutData.getBillingAddressFromData();\n\n                    if (billingAddressData) {\n                        checkoutProvider.set(\n                            billingAddressCode,\n                            $.extend(true, {}, defaultAddressData, billingAddressData)\n                        );\n                    }\n                    checkoutProvider.on(billingAddressCode, function (providerBillingAddressData) {\n                        checkoutData.setBillingAddressFromData(providerBillingAddressData);\n                    }, billingAddressCode);\n                });\n\n                return this;\n            },\n\n            /**\n             * Initialize child elements\n             *\n             * @returns {Component} Chainable.\n             */\n            initChildren: function () {\n                this.messageContainer = new Messages();\n                this.createMessagesComponent();\n\n                return this;\n            },\n\n            /**\n             * Create child message renderer component\n             *\n             * @returns {Component} Chainable.\n             */\n            createMessagesComponent: function () {\n\n                var messagesComponent = {\n                    parent: this.name,\n                    name: this.name + '.messages',\n                    displayArea: 'messages',\n                    component: 'Magento_Ui/js/view/messages',\n                    config: {\n                        messageContainer: this.messageContainer\n                    }\n                };\n\n                layout([messagesComponent]);\n\n                return this;\n            },\n\n            /**\n             * Place order.\n             */\n            placeOrder: function (data, event) {\n                var self = this;\n\n                if (event) {\n                    event.preventDefault();\n                }\n\n                if (this.validate() && additionalValidators.validate()) {\n                    this.isPlaceOrderActionAllowed(false);\n\n                    this.getPlaceOrderDeferredObject()\n                        .fail(\n                            function () {\n                                self.isPlaceOrderActionAllowed(true);\n                            }\n                        ).done(\n                            function () {\n                                self.afterPlaceOrder();\n\n                                if (self.redirectAfterPlaceOrder) {\n                                    redirectOnSuccessAction.execute();\n                                }\n                            }\n                        );\n\n                    return true;\n                }\n\n                return false;\n            },\n\n            getPlaceOrderDeferredObject: function () {\n                return $.when(\n                    placeOrderAction(this.getData(), this.messageContainer)\n                );\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            selectPaymentMethod: function () {\n                selectPaymentMethodAction(this.getData());\n                checkoutData.setSelectedPaymentMethod(this.item.method);\n\n                return true;\n            },\n\n            isChecked: ko.computed(function () {\n                return quote.paymentMethod() ? quote.paymentMethod().method : null;\n            }),\n\n            isRadioButtonVisible: ko.computed(function () {\n                return paymentService.getAvailablePaymentMethods().length !== 1;\n            }),\n\n            /**\n             * Get payment method data\n             */\n            getData: function () {\n                return {\n                    'method': this.item.method,\n                    'po_number': null,\n                    'additional_data': null\n                };\n            },\n\n            /**\n             * Get payment method type.\n             */\n            getTitle: function () {\n                return this.item.title;\n            },\n\n            /**\n             * Get payment method code.\n             */\n            getCode: function () {\n                return this.item.method;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            validate: function () {\n                return true;\n            },\n\n            /**\n             * @return {String}\n             */\n            getBillingAddressFormName: function () {\n                return 'billing-address-form-' + this.item.method;\n            },\n\n            /**\n             * Dispose billing address subscriptions\n             */\n            disposeSubscriptions: function () {\n                // dispose all active subscriptions\n                var billingAddressCode = 'billingAddress' + this.getCode();\n\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    checkoutProvider.off(billingAddressCode);\n                });\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/payment/email-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/model/customer-email-validator'\n    ],\n    function (Component, additionalValidators, agreementValidator) {\n        'use strict';\n\n        additionalValidators.registerValidator(agreementValidator);\n\n        return Component.extend({});\n    }\n);\n","Magento_Checkout/js/view/payment/list.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'Magento_Checkout/js/model/checkout-data-resolver'\n], function (_, ko, utils, Component, paymentMethods, rendererList, layout, checkoutDataResolver) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment-methods/list',\n            visible: paymentMethods().length > 0\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @returns {Component} Chainable.\n         */\n        initialize: function () {\n            this._super().initChildren();\n            paymentMethods.subscribe(\n                function (changes) {\n                    checkoutDataResolver.resolvePaymentMethod();\n                    //remove renderer for \"deleted\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'deleted') {\n                            this.removeRenderer(change.value.method);\n                        }\n                    }, this);\n                    //add renderer for \"added\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'added') {\n                            this.createRenderer(change.value);\n                        }\n                    }, this);\n                }, this, 'arrayChange');\n\n            return this;\n        },\n\n        /**\n         * Create renders for child payment methods.\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            var self = this;\n\n            _.each(paymentMethods(), function (paymentMethodData) {\n                self.createRenderer(paymentMethodData);\n            });\n\n            return this;\n        },\n\n        /**\n         * @returns\n         */\n        createComponent: function (payment) {\n            var rendererTemplate,\n                rendererComponent,\n                templateData;\n\n            templateData = {\n                parentName: this.name,\n                name: payment.name\n            };\n            rendererTemplate = {\n                parent: '${ $.$data.parentName }',\n                name: '${ $.$data.name }',\n                displayArea: 'payment-method-items',\n                component: payment.component\n            };\n            rendererComponent = utils.template(rendererTemplate, templateData);\n            utils.extend(rendererComponent, {\n                item: payment.item,\n                config: payment.config\n            });\n\n            return rendererComponent;\n        },\n\n        /**\n         * Create renderer.\n         *\n         * @param {Object} paymentMethodData\n         */\n        createRenderer: function (paymentMethodData) {\n            var isRendererForMethod = false;\n\n            _.find(rendererList(), function (renderer) {\n\n                if (renderer.hasOwnProperty('typeComparatorCallback') &&\n                    typeof renderer.typeComparatorCallback == 'function'\n                ) {\n                    isRendererForMethod = renderer.typeComparatorCallback(renderer.type, paymentMethodData.method);\n                } else {\n                    isRendererForMethod = renderer.type === paymentMethodData.method;\n                }\n\n                if (isRendererForMethod) {\n                    layout(\n                        [\n                            this.createComponent(\n                                {\n                                    config: renderer.config,\n                                    component: renderer.component,\n                                    name: renderer.type,\n                                    method: paymentMethodData.method,\n                                    item: paymentMethodData\n                                }\n                            )\n                        ]\n                    );\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Remove view renderer.\n         *\n         * @param {String} paymentMethodCode\n         */\n        removeRenderer: function (paymentMethodCode) {\n            var items = this.getRegion('payment-method-items');\n\n            _.find(items(), function (value) {\n                if (value.item.method.indexOf(paymentMethodCode) === 0) {\n                    value.disposeSubscriptions();\n                    value.destroy();\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Checkout/js/view/review/actions.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/review/actions',\n                displayArea: 'actions'\n            },\n            getActiveView: function() {\n                var view = this.getViewByCode(quote.paymentMethod());\n                return view ? view : this.getDefaultView();\n            },\n            getViewByCode: function(code) {\n                return _.find(this.elems(), function(elem) {\n                    return elem.index == code && !elem.isDefault;\n                });\n            },\n            getDefaultView: function() {\n                return _.find(this.elems(), function(elem) {\n                    return elem.isDefault;\n                });\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/review/actions/default.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent'\n    ],\n    function (Component) {\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/review/actions/default'\n            },\n            placeOrder: function(parent) {\n                return parent.placeOrder.bind(parent);\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/shipping-address/list.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Customer/js/model/address-list'\n], function (_, ko, utils, Component, layout, addressList) {\n    'use strict';\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-address/address-renderer/default'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/list',\n            visible: addressList().length > 0,\n            rendererTemplates: []\n        },\n\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            addressList.subscribe(\n                function(changes) {\n                    var self = this;\n                    changes.forEach(function(change) {\n                        if (change.status === 'added') {\n                           self.createRendererComponent(change.value, change.index);\n                        }\n                    });\n                },\n                this,\n                'arrayChange'\n            );\n            return this;\n        },\n\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = [];\n            return this;\n        },\n\n        initChildren: function () {\n            _.each(addressList(), this.createRendererComponent, this);\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param address\n         * @param index\n         */\n        createRendererComponent: function (address, index) {\n            if (index in this.rendererComponents) {\n                this.rendererComponents[index].address(address);\n            } else {\n                // rendererTemplates are provided via layout\n                var rendererTemplate = (address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined)\n                    ? utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()])\n                    : defaultRendererTemplate;\n                var templateData = {\n                    parentName: this.name,\n                    name: index\n                };\n                var rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(rendererComponent, {address: ko.observable(address)});\n                layout([rendererComponent]);\n                this.rendererComponents[index] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-address/address-renderer/default.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Customer/js/customer-data'\n], function($, ko, Component, selectShippingAddressAction, quote, formPopUpState, checkoutData, customerData) {\n    'use strict';\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/address-renderer/default'\n        },\n\n        initObservable: function () {\n            this._super();\n            this.isSelected = ko.computed(function() {\n                var isSelected = false;\n                var shippingAddress = quote.shippingAddress();\n                if (shippingAddress) {\n                    isSelected = shippingAddress.getKey() == this.address().getKey();\n                }\n                return isSelected;\n            }, this);\n\n            return this;\n        },\n\n        getCountryName: function(countryId) {\n            return (countryData()[countryId] != undefined) ? countryData()[countryId].name : \"\";\n        },\n\n        /** Set selected customer shipping address  */\n        selectAddress: function() {\n            selectShippingAddressAction(this.address());\n            checkoutData.setSelectedShippingAddress(this.address().getKey());\n        },\n\n        editAddress: function() {\n            formPopUpState.isVisible(true);\n            this.showPopup();\n\n        },\n        showPopup: function() {\n            $('[data-open-modal=\"opc-new-shipping-address\"]').trigger('click');\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/list.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine([\n    'jquery',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Checkout/js/model/quote'\n], function ($, ko, utils, Component, layout, quote) {\n    'use strict';\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-information/address-renderer/default'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/list',\n            rendererTemplates: {}\n        },\n\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            var self = this;\n            quote.shippingAddress.subscribe(function(address) {\n                self.createRendererComponent(address);\n            });\n            return this;\n        },\n\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = {};\n            return this;\n        },\n\n        initChildren: function () {\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param address\n         */\n        createRendererComponent: function (address) {\n\n            $.each(this.rendererComponents, function(index, component) {\n                component.visible(false);\n            });\n\n            if (this.rendererComponents[address.getType()]) {\n                this.rendererComponents[address.getType()].address(address);\n                this.rendererComponents[address.getType()].visible(true);\n            } else {\n                // rendererTemplates are provided via layout\n                var rendererTemplate =\n                    (address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined)\n                    ? utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()])\n                    : defaultRendererTemplate;\n                var templateData = {\n                    parentName: this.name,\n                    name: address.getType()\n                };\n\n                var rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(\n                    rendererComponent,\n                    {address: ko.observable(address), visible: ko.observable(true)}\n                );\n                layout([rendererComponent]);\n                this.rendererComponents[address.getType()] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/address-renderer/default.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function(Component, customerData) {\n    'use strict';\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/address-renderer/default'\n        },\n\n        getCountryName: function(countryId) {\n            return (countryData()[countryId] != undefined) ? countryData()[countryId].name : \"\";\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/abstract-total.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Catalog/js/price-utils',\n        'Magento_Checkout/js/model/totals',\n        'Magento_Checkout/js/model/step-navigator'\n    ],\n    function (Component, quote, priceUtils, totals, stepNavigator) {\n        \"use strict\";\n        return Component.extend({\n            getFormattedPrice: function (price) {\n                return priceUtils.formatPrice(price, quote.getPriceFormat());\n            },\n            getTotals: function() {\n                return totals.totals();\n            },\n            isFullMode: function() {\n                if (!this.getTotals()) {\n                    return false;\n                }\n                return stepNavigator.isProcessed('shipping');\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/cart-items.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'ko',\n        'Magento_Checkout/js/model/totals',\n        'uiComponent',\n        'Magento_Checkout/js/model/step-navigator',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (ko, totals, Component, stepNavigator, quote) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/cart-items'\n            },\n            totals: totals.totals(),\n            getItems: totals.getItems(),\n            getItemsQty: function() {\n                return parseFloat(this.totals.items_qty);\n            },\n            isItemsBlockExpanded: function () {\n                return quote.isVirtual() || stepNavigator.isProcessed('shipping');\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/grand-total.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/grand-total'\n            },\n            isDisplayed: function() {\n                return this.isFullMode();\n            },\n            getPureValue: function() {\n                var totals = quote.getTotals()();\n                if (totals) {\n                    return totals.grand_total;\n                }\n                return quote.grand_total;\n            },\n            getValue: function() {\n                return this.getFormattedPrice(this.getPureValue());\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/shipping.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function ($, Component, quote) {\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/shipping'\n            },\n            quoteIsVirtual: quote.isVirtual(),\n            totals: quote.getTotals(),\n            getShippingMethodTitle: function() {\n                if (!this.isCalculated()) {\n                    return '';\n                }\n                var shippingMethod = quote.shippingMethod();\n                return shippingMethod ? shippingMethod.carrier_title + \" - \" + shippingMethod.method_title : '';\n            },\n            isCalculated: function() {\n                return this.totals() && this.isFullMode() && null != quote.shippingMethod();\n            },\n            getValue: function() {\n                if (!this.isCalculated()) {\n                    return this.notCalculatedMessage;\n                }\n                var price =  this.totals().shipping_amount;\n                return this.getFormattedPrice(price);\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/subtotal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/subtotal'\n            },\n            getPureValue: function() {\n                var totals = quote.getTotals()();\n                if (totals) {\n                    return totals.subtotal;\n                }\n                return quote.subtotal;\n            },\n            getValue: function () {\n                return this.getFormattedPrice(this.getPureValue());\n            }\n\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * @return {*}\n             */\n            isDisplayed: function () {\n                return this.isFullMode();\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/item/details.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'uiComponent'\n    ],\n    function (Component) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/item/details'\n            },\n            getValue: function(quoteItem) {\n                return quoteItem.name;\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/item/details/subtotal.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total'\n    ],\n    function (viewModel) {\n        \"use strict\";\n        return viewModel.extend({\n            defaults: {\n                displayArea: 'after_details',\n                template: 'Magento_Checkout/summary/item/details/subtotal'\n            },\n            getValue: function(quoteItem) {\n                return this.getFormattedPrice(quoteItem.row_total);\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/summary/item/details/thumbnail.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'uiComponent'\n    ],\n    function (Component) {\n        \"use strict\";\n        var imageData = window.checkoutConfig.imageData;\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/summary/item/details/thumbnail'\n            },\n            displayArea: 'before_details',\n            imageData: imageData,\n            getImageItem: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id];\n                }\n                return [];\n            },\n            getSrc: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id]['src'];\n                }\n                return null;\n            },\n            getWidth: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id]['width'];\n                }\n                return null;\n            },\n            getHeight: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id]['height'];\n                }\n                return null;\n            },\n            getAlt: function(item) {\n                if (this.imageData[item.item_id]) {\n                    return this.imageData[item.item_id]['alt'];\n                }\n                return null;\n            }\n        });\n    }\n);\n","Magento_Payment/cc-type.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.creditCardType', {\n        options: {\n            typeCodes: ['SS', 'SM', 'SO'] // Type codes for Switch/Maestro/Solo credit cards.\n        },\n\n        /**\n         * Bind change handler to select element and trigger the event to show/hide\n         * the Switch/Maestro or Solo credit card type container for those credit card types.\n         * @private\n         */\n        _create: function() {\n            this.element.on('change', $.proxy(this._toggleCardType, this)).trigger('change');\n        },\n\n        /**\n         * Toggle the Switch/Maestro and Solo credit card type container depending on which\n         * credit card type is selected.\n         * @private\n         */\n        _toggleCardType: function() {\n            $(this.options.creditCardTypeContainer)\n                .toggle($.inArray(this.element.val(), this.options.typeCodes) !== -1);\n        }\n    });\n\n    return $.mage.creditCardType;\n});","Magento_Payment/transparent.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'Magento_Payment/js/model/credit-card-validation/validator'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.transparent', {\n        options: {\n            context: null,\n            placeOrderSelector: '[data-role=\"review-save\"]',\n            paymentFormSelector: '#co-payment-form',\n            updateSelectorPrefix: '#checkout-',\n            updateSelectorSuffix: '-load',\n            hiddenFormTmpl:\n                '<form target=\"<%= data.target %>\" action=\"<%= data.action %>\" method=\"POST\" ' +\n                'hidden enctype=\"application/x-www-form-urlencoded\" class=\"no-display\">' +\n                    '<% _.each(data.inputs, function(val, key){ %>' +\n                    '<input value=\"<%= val %>\" name=\"<%= key %>\" type=\"hidden\">' +\n                    '<% }); %>' +\n                '</form>',\n            reviewAgreementForm: '#checkout-agreements',\n            cgiUrl: null,\n            orderSaveUrl: null,\n            controller: null,\n            gateway: null,\n            dateDelim: null,\n            cardFieldsMap: null,\n            expireYearLength: 2\n        },\n\n        /**\n         * {Function}\n         * @private\n         */\n        _create: function () {\n            this.hiddenFormTmpl = mageTemplate(this.options.hiddenFormTmpl);\n\n            if (this.options.context) {\n                this.options.context.setPlaceOrderHandler($.proxy(this._orderSave, this));\n                this.options.context.setValidateHandler($.proxy(this._validateHandler, this));\n            } else {\n                $(this.options.placeOrderSelector)\n                    .off('click')\n                    .on('click', $.proxy(this._placeOrderHandler, this));\n            }\n\n            this.element.validation();\n            $('[data-container=\"' + this.options.gateway + '-cc-number\"]').on('focusout', function () {\n                $(this).valid();\n            });\n        },\n\n        /**\n         * handler for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _validateHandler: function () {\n            return this.element.validation && this.element.validation('isValid');\n        },\n\n        /**\n         * handler for Place Order button to call gateway for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _placeOrderHandler: function () {\n            if (this._validateHandler()) {\n                this._orderSave();\n            }\n\n            return false;\n        },\n\n        /**\n         * Save order and generate post data for gateway call\n         * @private\n         */\n        _orderSave: function () {\n            var postData = $(this.options.paymentFormSelector).serialize();\n\n            if ($(this.options.reviewAgreementForm).length) {\n                postData += '&' + $(this.options.reviewAgreementForm).serialize();\n            }\n            postData += '&controller=' + this.options.controller;\n            postData += '&cc_type=' + this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-type\"]'\n            ).val();\n\n            return $.ajax({\n                url: this.options.orderSaveUrl,\n                type: 'post',\n                context: this,\n                data: postData,\n                dataType: 'json',\n\n                /**\n                 * {Function}\n                 */\n                beforeSend: function () {\n                    this.element.trigger('showAjaxLoader');\n                }.bind(this),\n\n                /**\n                 * {Function}\n                 */\n                success: function (response) {\n                    var preparedData,\n                        msg,\n\n                        /**\n                         * {Function}\n                         */\n                        alertActionHandler = function () {\n                            // default action\n                        };\n\n                    if (response.success && response[this.options.gateway]) {\n                        preparedData = this._preparePaymentData(\n                            response[this.options.gateway].fields,\n                            this.options.cardFieldsMap\n                        );\n                        this._postPaymentToGateway(preparedData);\n                    } else {\n                        msg = response['error_messages'];\n\n                        if (this.options.context) {\n                            this.options.context.clearTimeout().fail();\n                            alertActionHandler = this.options.context.alertActionHandler;\n                        }\n\n                        if (typeof msg === 'object') {\n                            msg = msg.join('\\n');\n                        }\n\n                        if (msg) {\n                            alert(\n                                {\n                                    content: msg,\n                                    actions: {\n\n                                        /**\n                                         * {Function}\n                                         */\n                                        always: alertActionHandler\n                                    }\n                                }\n                            );\n                        }\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Post data to gateway for credit card validation\n         * @param {Object} data\n         * @private\n         */\n        _postPaymentToGateway: function (data) {\n            var tmpl,\n                iframeSelector = '[data-container=\"' + this.options.gateway + '-transparent-iframe\"]';\n\n            tmpl = this.hiddenFormTmpl({\n                data: {\n                    target: $(iframeSelector).attr('name'),\n                    action: this.options.cgiUrl,\n                    inputs: data\n                }\n            });\n            $(tmpl).appendTo($(iframeSelector)).submit();\n        },\n\n        /**\n         * Add credit card fields to post data for gateway\n         * @param {Object} data\n         * @param {Object} ccfields\n         * @private\n         */\n        _preparePaymentData: function (data, ccfields) {\n            var preparedata;\n\n            if (this.element.find('[data-container=\"' + this.options.gateway + '-cc-cvv\"]').length) {\n                data[ccfields.cccvv] = this.element.find(\n                    '[data-container=\"' + this.options.gateway + '-cc-cvv\"]'\n                ).val();\n            }\n            preparedata = this._prepareExpDate();\n            data[ccfields.ccexpdate] = preparedata.month + this.options.dateDelim + preparedata.year;\n            data[ccfields.ccnum] = this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-number\"]'\n            ).val();\n\n            return data;\n        },\n\n        /**\n         * Grab Month and Year into one\n         * @returns {Object}\n         * @private\n         */\n        _prepareExpDate: function () {\n            var year = this.element.find('[data-container=\"' + this.options.gateway + '-cc-year\"]').val(),\n                month = parseInt(\n                    this.element.find('[data-container=\"' + this.options.gateway + '-cc-month\"]').val(),\n                    10\n                );\n\n            if (year.length > this.options.expireYearLength) {\n                year = year.substring(year.length - this.options.expireYearLength);\n            }\n\n            if (month < 10) {\n                month = '0' + month;\n            }\n\n            return {\n                month: month, year: year\n            };\n        }\n    });\n\n    return $.mage.transparent;\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-data.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n        return {\n            creditCard: null,\n            creditCardNumber: null,\n            expirationMonth: null,\n            expirationYear: null,\n            cvvCode: null\n        }\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'mageUtils',\n        'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator',\n        'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type'\n    ],\n    function (utils, luhn10, creditCardTypes) {\n        'use strict';\n\n        function resultWrapper(card, isPotentiallyValid, isValid) {\n            return {\n                card: card,\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid\n            };\n        }\n\n        return function (value) {\n            var potentialTypes,\n                cardType,\n                valid,\n                i,\n                maxLength;\n\n            if (utils.isEmpty(value)) {\n                return resultWrapper(null, false, false);\n            }\n\n            value = value.replace(/\\-|\\s/g, '');\n\n            if (!/^\\d*$/.test(value)) {\n                return resultWrapper(null, false, false);\n            }\n\n            potentialTypes = creditCardTypes.getCardTypes(value);\n\n            if (potentialTypes.length === 0) {\n                return resultWrapper(null, false, false);\n            } else if (potentialTypes.length !== 1) {\n                return resultWrapper(null, true, false);\n            }\n\n            cardType = potentialTypes[0];\n\n            if (cardType.type === 'unionpay') {  // UnionPay is not Luhn 10 compliant\n                valid = true;\n            } else {\n                valid = luhn10(value);\n            }\n\n            for (i = 0; i < cardType.lengths.length; i++) {\n                if (cardType.lengths[i] === value.length) {\n                    return resultWrapper(cardType, valid, valid);\n                }\n            }\n\n            maxLength = Math.max.apply(null, cardType.lengths);\n\n            if (value.length < maxLength) {\n                return resultWrapper(cardType, true, false);\n            }\n\n            return resultWrapper(cardType, false, false);\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/cvv-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n\n        function resultWrapper(isValid, isPotentiallyValid) {\n            return {\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid\n            };\n        }\n\n        /**\n         * CVV number validation\n         * validate digit count fot CVV code\n         */\n        return function(value, maxLength) {\n            var DEFAULT_LENGTH = 3;\n            maxLength = maxLength || DEFAULT_LENGTH;\n\n            if (!/^\\d*$/.test(value)) {\n                return resultWrapper(false, false);\n            }\n            if (value.length === maxLength) {\n                return resultWrapper(true, true);\n            }\n            if (value.length < maxLength) {\n                return resultWrapper(false, true);\n            }\n            if (value.length > maxLength) {\n                return resultWrapper(false, false);\n            }\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'mageUtils',\n        'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date',\n        'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n        'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator'\n    ],\n    function(utils, parseDate, expirationMonth, expirationYear) {\n        'use strict';\n\n        function resultWrapper(isValid, isPotentiallyValid, month, year) {\n            return {\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid,\n                month: month,\n                year: year\n            };\n        }\n\n        return function(value) {\n            var date,\n                monthValid,\n                yearValid;\n\n            if (utils.isEmpty(value)) {\n                return resultWrapper(false, false, null, null);\n            }\n\n            value = value.replace(/^(\\d\\d) (\\d\\d(\\d\\d)?)$/, '$1/$2');\n            date = parseDate(value);\n            monthValid = expirationMonth(date.month);\n            yearValid = expirationYear(date.year);\n\n            if (monthValid.isValid && yearValid.isValid) {\n                return resultWrapper(true, true, date.month, date.year);\n            }\n\n            if (monthValid.isPotentiallyValid && yearValid.isPotentiallyValid) {\n                return resultWrapper(false, true, null, null);\n            }\n\n            return resultWrapper(false, false, null, null);\n        }\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'Magento_Payment/js/model/credit-card-validation/cvv-validator',\n            'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n            'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator',\n            'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n            'Magento_Payment/js/model/credit-card-validation/credit-card-data'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($, cvvValidator, creditCardNumberValidator, expirationDateValidator, monthValidator, creditCardData) {\n    \"use strict\";\n\n    $.each({\n        'validate-card-type': [\n            function (number, item, allowedTypes) {\n                var cardInfo,\n                    i,\n                    l;\n\n                if (!creditCardNumberValidator(number).isValid) {\n                    return false;\n                } else {\n                    cardInfo = creditCardNumberValidator(number).card;\n\n                    for (i = 0, l = allowedTypes.length; i < l; i++) {\n                        if (cardInfo.title == allowedTypes[i].type) {\n                            return true;\n                        }\n                    }\n                    return false;\n                }\n            },\n            'Please enter a valid credit card type number.'\n        ],\n        'validate-card-number': [\n            /**\n             * Validate credit card number based on mod 10\n             * @param number - credit card number\n             * @return {boolean}\n             */\n                function (number) {\n                return creditCardNumberValidator(number).isValid;\n            },\n            'Please enter a valid credit card number.'\n        ],\n        'validate-card-date': [\n            /**\n             * Validate credit card number based on mod 10\n             * @param date - month\n             * @return {boolean}\n             */\n                function (date) {\n                return monthValidator(date).isValid;\n            },\n            'Incorrect credit card expiration month.'\n        ],\n        'validate-card-cvv': [\n            /**\n             * Validate credit card number based on mod 10\n             * @param cvv - month\n             * @return {boolean}\n             */\n                function (cvv) {\n                var maxLength = creditCardData.creditCard ? creditCardData.creditCard.code.size : 3;\n                return cvvValidator(cvv, maxLength).isValid;\n            },\n            'Please enter a valid credit card verification number.'\n        ],\n        'validate-card-year': [\n            /**\n             * Validate credit card number based on mod 10\n             * @param date - month\n             * @return {boolean}\n             */\n                function (date) {\n                return monthValidator(date).isValid;\n            },\n            'Incorrect credit card expiration year.'\n        ]\n\n    }, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n}));","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [\n        'jquery',\n        'mageUtils'\n    ],\n    function ($, utils) {\n        'use strict';\n        var types = [\n            {\n                title: 'Visa',\n                type: 'VI',\n                pattern: '^4\\\\d*$',\n                gaps: [4, 8, 12],\n                lengths: [16],\n                code: {\n                    name: 'CVV',\n                    size: 3\n                }\n            },\n            {\n                title: 'MasterCard',\n                type: 'MC',\n                pattern: '^5([1-5]\\\\d*)?$',\n                gaps: [4, 8, 12],\n                lengths: [16],\n                code: {\n                    name: 'CVC',\n                    size: 3\n                }\n            },\n            {\n                title: 'American Express',\n                type: 'AE',\n                pattern: '^3([47]\\\\d*)?$',\n                isAmex: true,\n                gaps: [4, 10],\n                lengths: [15],\n                code: {\n                    name: 'CID',\n                    size: 4\n                }\n            },\n            {\n                title: 'Diners',\n                type: 'DN',\n                pattern: '^3((0([0-5]\\\\d*)?)|[689]\\\\d*)?$',\n                gaps: [4, 10],\n                lengths: [14],\n                code: {\n                    name: 'CVV',\n                    size: 3\n                }\n            },\n            {\n                title: 'Discover',\n                type: 'DI',\n                pattern: '^6(0|01|011\\\\d*|5\\\\d*|4|4[4-9]\\\\d*)?$',\n                gaps: [4, 8, 12],\n                lengths: [16],\n                code: {\n                    name: 'CID',\n                    size: 3\n                }\n            },\n            {\n                title: 'JCB',\n                type: 'JCB',\n                pattern: '^((2|21|213|2131\\\\d*)|(1|18|180|1800\\\\d*)|(3|35\\\\d*))$',\n                gaps: [4, 8, 12],\n                lengths: [16],\n                code: {\n                    name: 'CVV',\n                    size: 3\n                }\n            },\n            {\n                title: 'UnionPay',\n                type: 'UN',\n                pattern: '^6(2\\\\d*)?$',\n                gaps: [4, 8, 12],\n                lengths: [16, 17, 18, 19],\n                code: {\n                    name: 'CVN',\n                    size: 3\n                }\n            },\n            {\n                title: 'Maestro International',\n                type: 'MI',\n                pattern: '^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$',\n                gaps: [4, 8, 12],\n                lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n                code: {\n                    name: 'CVC',\n                    size: 3\n                }\n            },\n            {\n                title: 'Maestro Domestic',\n                type: 'MD',\n                pattern: '^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$',\n                gaps: [4, 8, 12],\n                lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n                code: {\n                    name: 'CVC',\n                    size: 3\n                }\n            }\n        ];\n        return {\n            getCardTypes: function (cardNumber) {\n                var i, value,\n                    result = [];\n\n                if (utils.isEmpty(cardNumber)) {\n                    return result;\n                }\n\n                if (cardNumber === '') {\n                    return $.extend(true, {}, types);\n                }\n\n                for (i = 0; i < types.length; i++) {\n                    value = types[i];\n\n                    if (new RegExp(value.pattern).test(cardNumber)) {\n                        result.push($.extend(true, {}, value));\n                    }\n                }\n                return result;\n            }\n        }\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n        /**\n         * Luhn algorithm verification\n         */\n        return function(a, b, c, d, e) {\n            for(d = +a[b = a.length-1], e = 0; b--;) {\n                c = +a[b];\n                d += ++e % 2 ? 2 * c % 10 + (c > 4) : c;\n            }\n            return !(d%10)\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function () {\n        'use strict';\n\n        function resultWrapper(isValid, isPotentiallyValid) {\n            return {\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid\n            };\n        }\n\n        return function (value) {\n            var month,\n                monthValid;\n\n            if ((value.replace(/\\s/g, '') === '') || (value === '0')) {\n                return resultWrapper(false, true);\n            }\n\n            if (!/^\\d*$/.test(value)) {\n                return resultWrapper(false, false);\n            }\n\n            if (isNaN(value)) {\n                return resultWrapper(false, false);\n            }\n\n            month = parseInt(value, 10);\n            monthValid = month > 0 && month < 13;\n\n            return resultWrapper(monthValid, monthValid);\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n\n        function resultWrapper(isValid, isPotentiallyValid) {\n            return {\n                isValid: isValid,\n                isPotentiallyValid: isPotentiallyValid\n            };\n        }\n\n        return function(value) {\n            var currentYear = new Date().getFullYear(),\n                len = value.length,\n                valid,\n                expMaxLifetime = 19;\n\n            if (value.replace(/\\s/g, '') === '') {\n                return resultWrapper(false, true);\n            }\n\n            if (!/^\\d*$/.test(value)) {\n                return resultWrapper(false, false);\n            }\n\n            if (len !== 4) {\n                return resultWrapper(false, true);\n            }\n\n            value = parseInt(value, 10);\n            valid = value >= currentYear && value <= currentYear + expMaxLifetime;\n            return resultWrapper(valid, valid);\n        };\n    }\n);\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(\n    [],\n    function() {\n        'use strict';\n        return function(value) {\n            var month, len;\n\n            if (value.match('/')) {\n                value = value.split(/\\s*\\/\\s*/g);\n\n                return {\n                    month: value[0],\n                    year: value.slice(1).join()\n                };\n            }\n\n            len = (value[0] === '0' || value.length > 5 || value.length === 4 || value.length === 3) ? 2 : 1;\n            month = value.substr(0, len);\n\n            return {\n                month: month,\n                year: value.substr(month.length, 4)\n            };\n        }\n    }\n);\n","Magento_Payment/js/view/payment/cc-form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n        'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n        'mage/translate'\n    ],\n    function (_, Component, creditCardData, cardNumberValidator, $t) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                creditCardType: '',\n                creditCardExpYear: '',\n                creditCardExpMonth: '',\n                creditCardNumber: '',\n                creditCardSsStartMonth: '',\n                creditCardSsStartYear: '',\n                creditCardSsIssue: '',\n                creditCardVerificationNumber: '',\n                selectedCardType: null\n            },\n\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'creditCardType',\n                        'creditCardExpYear',\n                        'creditCardExpMonth',\n                        'creditCardNumber',\n                        'creditCardVerificationNumber',\n                        'creditCardSsStartMonth',\n                        'creditCardSsStartYear',\n                        'creditCardSsIssue',\n                        'selectedCardType'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * Init component\n             */\n            initialize: function () {\n                var self = this;\n\n                this._super();\n\n                //Set credit card number to credit card data object\n                this.creditCardNumber.subscribe(function (value) {\n                    var result;\n\n                    self.selectedCardType(null);\n\n                    if (value === '' || value === null) {\n                        return false;\n                    }\n                    result = cardNumberValidator(value);\n\n                    if (!result.isPotentiallyValid && !result.isValid) {\n                        return false;\n                    }\n\n                    if (result.card !== null) {\n                        self.selectedCardType(result.card.type);\n                        creditCardData.creditCard = result.card;\n                    }\n\n                    if (result.isValid) {\n                        creditCardData.creditCardNumber = value;\n                        self.creditCardType(result.card.type);\n                    }\n                });\n\n                //Set expiration year to credit card data object\n                this.creditCardExpYear.subscribe(function (value) {\n                    creditCardData.expirationYear = value;\n                });\n\n                //Set expiration month to credit card data object\n                this.creditCardExpMonth.subscribe(function (value) {\n                    creditCardData.expirationMonth = value;\n                });\n\n                //Set cvv code to credit card data object\n                this.creditCardVerificationNumber.subscribe(function (value) {\n                    creditCardData.cvvCode = value;\n                });\n            },\n\n            /**\n             * Get code\n             * @returns {String}\n             */\n            getCode: function () {\n                return 'cc';\n            },\n\n            /**\n             * Get data\n             * @returns {Object}\n             */\n            getData: function () {\n                return {\n                    'method': this.item.method,\n                    'additional_data': {\n                        'cc_cid': this.creditCardVerificationNumber(),\n                        'cc_ss_start_month': this.creditCardSsStartMonth(),\n                        'cc_ss_start_year': this.creditCardSsStartYear(),\n                        'cc_ss_issue': this.creditCardSsIssue(),\n                        'cc_type': this.creditCardType(),\n                        'cc_exp_year': this.creditCardExpYear(),\n                        'cc_exp_month': this.creditCardExpMonth(),\n                        'cc_number': this.creditCardNumber()\n                    }\n                };\n            },\n\n            /**\n             * Get list of available credit card types\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                return window.checkoutConfig.payment.ccform.availableTypes[this.getCode()];\n            },\n\n            /**\n             * Get payment icons\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * Get list of months\n             * @returns {Object}\n             */\n            getCcMonths: function () {\n                return window.checkoutConfig.payment.ccform.months[this.getCode()];\n            },\n\n            /**\n             * Get list of years\n             * @returns {Object}\n             */\n            getCcYears: function () {\n                return window.checkoutConfig.payment.ccform.years[this.getCode()];\n            },\n\n            /**\n             * Check if current payment has verification\n             * @returns {Boolean}\n             */\n            hasVerification: function () {\n                return window.checkoutConfig.payment.ccform.hasVerification[this.getCode()];\n            },\n\n            /**\n             * @deprecated\n             * @returns {Boolean}\n             */\n            hasSsCardType: function () {\n                return window.checkoutConfig.payment.ccform.hasSsCardType[this.getCode()];\n            },\n\n            /**\n             * Get image url for CVV\n             * @returns {String}\n             */\n            getCvvImageUrl: function () {\n                return window.checkoutConfig.payment.ccform.cvvImageUrl[this.getCode()];\n            },\n\n            /**\n             * Get image for CVV\n             * @returns {String}\n             */\n            getCvvImageHtml: function () {\n                return '<img src=\"' + this.getCvvImageUrl() +\n                    '\" alt=\"' + $t('Card Verification Number Visual Reference') +\n                    '\" title=\"' + $t('Card Verification Number Visual Reference') +\n                    '\" />';\n            },\n\n            /**\n             * @deprecated\n             * @returns {Object}\n             */\n            getSsStartYears: function () {\n                return window.checkoutConfig.payment.ccform.ssStartYears[this.getCode()];\n            },\n\n            /**\n             * Get list of available credit card types values\n             * @returns {Object}\n             */\n            getCcAvailableTypesValues: function () {\n                return _.map(this.getCcAvailableTypes(), function (value, key) {\n                    return {\n                        'value': key,\n                        'type': value\n                    };\n                });\n            },\n\n            /**\n             * Get list of available month values\n             * @returns {Object}\n             */\n            getCcMonthsValues: function () {\n                return _.map(this.getCcMonths(), function (value, key) {\n                    return {\n                        'value': key,\n                        'month': value\n                    };\n                });\n            },\n\n            /**\n             * Get list of available year values\n             * @returns {Object}\n             */\n            getCcYearsValues: function () {\n                return _.map(this.getCcYears(), function (value, key) {\n                    return {\n                        'value': key,\n                        'year': value\n                    };\n                });\n            },\n\n            /**\n             * @deprecated\n             * @returns {Object}\n             */\n            getSsStartYearsValues: function () {\n                return _.map(this.getSsStartYears(), function (value, key) {\n                    return {\n                        'value': key,\n                        'year': value\n                    };\n                });\n            },\n\n            /**\n             * Is legend available to display\n             * @returns {Boolean}\n             */\n            isShowLegend: function () {\n                return false;\n            },\n\n            /**\n             * Get available credit card type by code\n             * @param {String} code\n             * @returns {String}\n             */\n            getCcTypeTitleByCode: function (code) {\n                var title = '',\n                    keyValue = 'value',\n                    keyType = 'type';\n\n                _.each(this.getCcAvailableTypesValues(), function (value) {\n                    if (value[keyValue] === code) {\n                        title = value[keyType];\n                    }\n                });\n\n                return title;\n            },\n\n            /**\n             * Prepare credit card number to output\n             * @param {String} number\n             * @returns {String}\n             */\n            formatDisplayCcNumber: function (number) {\n                return 'xxxx-' + number.substr(-4);\n            },\n\n            /**\n             * Get credit card details\n             * @returns {Array}\n             */\n            getInfo: function () {\n                return [\n                    {\n                        'name': 'Credit Card Type', value: this.getCcTypeTitleByCode(this.creditCardType())\n                    },\n                    {\n                        'name': 'Credit Card Number', value: this.formatDisplayCcNumber(this.creditCardNumber())\n                    }\n                ];\n            }\n        });\n    }\n);\n","Magento_Payment/js/view/payment/iframe.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Ui/js/model/messageList',\n        'mage/translate',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/set-payment-information',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Ui/js/modal/alert'\n    ],\n    function (\n        $,\n        Component,\n        messageList,\n        $t,\n        fullScreenLoader,\n        setPaymentInformationAction,\n        additionalValidators,\n        alert\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Payment/payment/iframe',\n                timeoutId: null,\n                timeoutMessage: 'Sorry, but something went wrong.'\n            },\n\n            /**\n             * @returns {String}\n             */\n            getSource: function () {\n                return window.checkoutConfig.payment.iframe.source[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getControllerName: function () {\n                return window.checkoutConfig.payment.iframe.controllerName[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getPlaceOrderUrl: function () {\n                return window.checkoutConfig.payment.iframe.placeOrderUrl[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCgiUrl: function () {\n                return window.checkoutConfig.payment.iframe.cgiUrl[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getSaveOrderUrl: function () {\n                return window.checkoutConfig.payment.iframe.saveOrderUrl[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getDateDelim: function () {\n                return window.checkoutConfig.payment.iframe.dateDelim[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCardFieldsMap: function () {\n                return window.checkoutConfig.payment.iframe.cardFieldsMap[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getExpireYearLength: function () {\n                return window.checkoutConfig.payment.iframe.expireYearLength[this.getCode()];\n            },\n\n            /**\n             * @param {Object} parent\n             * @returns {Function}\n             */\n            originalPlaceOrder: function (parent) {\n                return parent.placeOrder.bind(parent);\n            },\n\n            /**\n             * @returns {Number}\n             */\n            getTimeoutTime: function () {\n                return window.checkoutConfig.payment.iframe.timeoutTime[this.getCode()];\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTimeoutMessage: function () {\n                return $t(this.timeoutMessage);\n            },\n\n            /**\n             * @override\n             */\n            placeOrder: function () {\n                if (this.validateHandler() && additionalValidators.validate()) {\n\n                    fullScreenLoader.startLoader();\n\n                    this.isPlaceOrderActionAllowed(false);\n\n                    $.when(\n                        setPaymentInformationAction(\n                            this.messageContainer,\n                            {\n                                method: this.getCode()\n                            }\n                        )\n                    ).done(this.done.bind(this))\n                        .fail(this.fail.bind(this));\n\n                    this.initTimeoutHandler();\n                }\n            },\n\n            /**\n             * {Function}\n             */\n            initTimeoutHandler: function () {\n                this.timeoutId = setTimeout(\n                    this.timeoutHandler.bind(this),\n                    this.getTimeoutTime()\n                );\n\n                $(window).off('clearTimeout')\n                    .on('clearTimeout', this.clearTimeout.bind(this));\n            },\n\n            /**\n             * {Function}\n             */\n            clearTimeout: function () {\n                clearTimeout(this.timeoutId);\n\n                return this;\n            },\n\n            /**\n             * {Function}\n             */\n            timeoutHandler: function () {\n                this.clearTimeout();\n\n                alert(\n                    {\n                        content: this.getTimeoutMessage(),\n                        actions: {\n\n                            /**\n                             * {Function}\n                             */\n                            always: this.alertActionHandler.bind(this)\n                        }\n                    }\n                );\n\n                this.fail();\n            },\n\n            /**\n             * {Function}\n             */\n            alertActionHandler: function () {\n                fullScreenLoader.startLoader();\n                window.location.reload();\n            },\n\n            /**\n             * {Function}\n             */\n            fail: function () {\n                fullScreenLoader.stopLoader();\n                this.isPlaceOrderActionAllowed(true);\n\n                return this;\n            },\n\n            /**\n             * {Function}\n             */\n            done: function () {\n                this.placeOrderHandler().fail(function () {\n                    fullScreenLoader.stopLoader();\n                });\n\n                return this;\n            }\n        });\n    }\n);\n","Magento_Payment/js/view/payment/payments.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n        rendererList.push(\n            {\n                type: 'free',\n                component: 'Magento_Payment/js/view/payment/method-renderer/free-method'\n            }\n        );\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);","Magento_Payment/js/view/payment/method-renderer/free-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Payment/payment/free'\n            },\n\n            /** Returns is method available */\n            isAvailable: function() {\n                return quote.totals().grand_total <= 0;\n            }\n        });\n    }\n);\n","Magento_GiftMessage/extra-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.extraOptions', {\n        options: {\n            events: 'billingSave shippingSave',\n            additionalContainer: '#onepage-checkout-shipping-method-additional-load'\n        },\n\n        /**\n         * Set up event handler for requesting any additional extra options from the backend.\n         * @private\n         */\n        _create: function() {\n            this.element.on(this.options.events, $.proxy(this._addExtraOptions, this));\n        },\n\n        /**\n         * Fetch the extra options using an Ajax call. Extra options include Gift Receipt and\n         * Printed Card.\n         * @private\n         */\n        _addExtraOptions: function() {\n            $.ajax({\n                url: this.options.additionalUrl,\n                context: this,\n                type: 'post',\n                async: false,\n                success: function(response) {\n                    $(this.options.additionalContainer).html(response).trigger('contentUpdated');\n                }\n            });\n        }\n    });\n    \n    return $.mage.extraOptions;\n});","Magento_GiftMessage/gift-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.giftOptions', {\n        options: {\n            mageError: 'mage-error',\n            noDisplay: 'no-display',\n            requiredEntry: 'required-entry'\n        },\n\n        /**\n         * Initial toggle of the various gift options after widget instantiation.\n         * @private\n         */\n        _init: function() {\n            this._toggleVisibility();\n        },\n\n        /**\n         * Bind a click handler to the widget's context element.\n         * @private\n         */\n        _create: function() {\n            this.element.on('click', $.proxy(this._toggleVisibility, this));\n            $(this.element.data('selector').id).find('.giftmessage-area')\n                .on('change', $.proxy(this._toggleRequired, this));\n        },\n\n        /**\n         * Toggle the visibility of the widget's context element's selector(s).\n         * @private\n         * @param event {Object} - Click event. Target is a checkbox.\n         */\n        _toggleVisibility: function(event) {\n            var checkbox = event ? $(event.target) : this.element,\n                container = $(checkbox.data('selector').id);\n            if (checkbox.is(':checked')) {\n                container.show()\n                    .find('.giftmessage-area:not(:visible)').each(function(x, element) {\n                        if ($(element).val().length > 0) {\n                            $(element).change();\n                            container.find('a').click();\n                        }\n                    });\n            } else {\n                var _this = this;\n                container.hide()\n                    .find('.input-text:not(.giftmessage-area)').each(function(x, element) {\n                        $(element).val(element.defaultValue).removeClass(_this.options.mageError)\n                            .next('div.' + _this.options.mageError).remove();\n                    }).end()\n                    .find('.giftmessage-area').val('').change().end()\n                    .find('.select').val('').change().end()\n                    .find('.checkbox:checked').prop('checked', false).click().prop('checked', false).end()\n                    .find('.price-box').addClass(this.options.noDisplay).end();\n            }\n        },\n\n        /**\n         * Make the From and To input fields required if a gift message has been written.\n         * @private\n         * @param event {Object} - Change event. Target is a textarea.\n         */\n        _toggleRequired: function(event) {\n            var textArea = $(event.target),\n                length = textArea.val().length;\n            textArea.closest('li').prev('.fields')\n                .find('.input-text').toggleClass(this.options.requiredEntry, length > 0);\n        }\n    });\n    \n    return $.mage.giftOptions;\n});","Magento_GiftMessage/js/action/gift-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_GiftMessage/js/model/url-builder',\n        'mage/storage',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/model/error-processor',\n        'mage/url',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (urlBuilder, storage, messageList, errorProcessor, url, quote) {\n        'use strict';\n\n        return function (giftMessage, remove) {\n            var serviceUrl;\n\n            url.setBaseUrl(giftMessage.getConfigValue('baseUrl'));\n\n            if (giftMessage.getConfigValue('isCustomerLoggedIn')) {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message', {});\n\n                if (giftMessage.itemId != 'orderLevel') {\n                    serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message/:itemId', {\n                        itemId: giftMessage.itemId\n                    });\n                }\n            } else {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/gift-message', {\n                    cartId: quote.getQuoteId()\n                });\n\n                if (giftMessage.itemId != 'orderLevel') {\n                    serviceUrl = urlBuilder.createUrl(\n                        '/guest-carts/:cartId/gift-message/:itemId',\n                        {\n                            cartId: quote.getQuoteId(), itemId: giftMessage.itemId\n                        }\n                    );\n                }\n            }\n            messageList.clear();\n\n            storage.post(\n                serviceUrl,\n                JSON.stringify({\n                    gift_message: giftMessage.getSubmitParams(remove)\n                })\n            ).done(\n                function (response) {\n                    giftMessage.reset();\n                    _.each(giftMessage.getAfterSubmitCallbacks(), function (callback) {\n                        if (_.isFunction(callback)) {\n                            callback();\n                        }\n                    });\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response);\n                }\n            );\n        };\n    }\n);\n","Magento_GiftMessage/js/model/gift-message.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(['uiElement', 'underscore', 'mage/url'],\n    function (uiElement, _, url) {\n        'use strict';\n\n        var provider = uiElement();\n\n        return function (itemId) {\n            var model = {\n                id: 'message-' + itemId,\n                itemId: itemId,\n                observables: {},\n                additionalOptions: [],\n                submitParams: [\n                    'recipient',\n                    'sender',\n                    'message'\n                ],\n                initialize: function() {\n                    this.getObservable('alreadyAdded')(false);\n                    var message = false;\n\n                    if (this.itemId == 'orderLevel') {\n                        message = window.giftOptionsConfig.giftMessage.hasOwnProperty(this.itemId)\n                            ? window.giftOptionsConfig.giftMessage[this.itemId]\n                            : null;\n                    } else {\n                        message =\n                            window.giftOptionsConfig.giftMessage.hasOwnProperty('itemLevel')\n                            && window.giftOptionsConfig.giftMessage['itemLevel'].hasOwnProperty(this.itemId)\n                            ? window.giftOptionsConfig.giftMessage['itemLevel'][this.itemId]['message']\n                            : null;\n                    }\n                    if (_.isObject(message)) {\n                        this.getObservable('recipient')(message.recipient);\n                        this.getObservable('sender')(message.sender);\n                        this.getObservable('message')(message.message);\n                        this.getObservable('alreadyAdded')(true);\n                    }\n                },\n                getObservable: function(key) {\n                    this.initObservable(this.id, key);\n                    return provider[this.getUniqueKey(this.id, key)];\n                },\n                initObservable: function(node, key) {\n                    if (node && !this.observables.hasOwnProperty(node)) {\n                        this.observables[node] = [];\n                    }\n                    if (key && this.observables[node].indexOf(key) == -1) {\n                        this.observables[node].push(key);\n                        provider.observe(this.getUniqueKey(node, key));\n                    }\n                },\n                getUniqueKey: function(node, key) {\n                    return node + '-' + key;\n                },\n                getConfigValue: function(key) {\n                    return window.giftOptionsConfig.hasOwnProperty(key) ?\n                        window.giftOptionsConfig[key]\n                        : null;\n                },\n                reset: function() {\n                    this.getObservable('isClear')(true);\n                },\n                getAfterSubmitCallbacks: function() {\n                    var callbacks = [];\n                    callbacks.push(this.afterSubmit);\n                    _.each(this.additionalOptions, function(option) {\n                        if (_.isFunction(option.afterSubmit)) {\n                            callbacks.push(option.afterSubmit);\n                        }\n                    });\n                    return callbacks;\n                },\n                afterSubmit: function() {\n                    window.location.href = url.build('checkout/cart/updatePost')\n                        + '?form_key=' + window.giftOptionsConfig.giftMessage.formKey\n                        + '&cart[]';\n                },\n                getSubmitParams: function(remove) {\n                    var params = {},\n                        self = this;\n                    _.each(this.submitParams, function(key) {\n                        var observable = provider[self.getUniqueKey(self.id, key)];\n                        if (_.isFunction(observable)) {\n                            params[key] = remove ? null : observable();\n                        }\n                    });\n\n                    if(this.additionalOptions.length) {\n                        params['extension_attributes'] = {};\n                    }\n                    _.each(this.additionalOptions, function(option) {\n                        if (_.isFunction(option.getSubmitParams)) {\n                            params['extension_attributes'] = _.extend(\n                                params['extension_attributes'],\n                                option.getSubmitParams(remove)\n                            );\n                        }\n                    });\n                    return params;\n                },\n\n                /**\n                 * Check if gift message can be displayed\n                 *\n                 * @returns {Boolean}\n                 */\n                isGiftMessageAvailable: function () {\n                    var isGloballyAvailable,\n                        giftMessageConfig,\n                        itemConfig;\n\n                    // itemId represent gift message level: 'orderLevel' constant or cart item ID\n                    if (this.itemId === 'orderLevel') {\n                        return this.getConfigValue('isOrderLevelGiftOptionsEnabled');\n                    }\n\n                    // gift message product configuration must override system configuration\n                    isGloballyAvailable = this.getConfigValue('isItemLevelGiftOptionsEnabled');\n                    giftMessageConfig = window.giftOptionsConfig.giftMessage;\n                    itemConfig = giftMessageConfig.hasOwnProperty('itemLevel') &&\n                        giftMessageConfig.itemLevel.hasOwnProperty(this.itemId) ?\n                        giftMessageConfig.itemLevel[this.itemId] :\n                        {};\n\n                    return itemConfig.hasOwnProperty('is_available') ? itemConfig['is_available'] : isGloballyAvailable;\n                }\n            };\n            model.initialize();\n            return model;\n        }\n    }\n);\n","Magento_GiftMessage/js/model/gift-options.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(['underscore', 'ko'],\n    function (_, ko) {\n\n        'use strict';\n\n        return {\n            options: ko.observableArray([]),\n            addOption: function (option) {\n                if (!this.options().hasOwnProperty(option.itemId)) {\n                    this.options.push({\n                            id: option.itemId, value: option\n                        }\n                    );\n                }\n            },\n            getOptionByItemId: function (itemId) {\n                var option = null;\n                _.each(this.options(), function (data) {\n                    if (data.id === itemId) {\n                        option = data.value;\n\n                        return false;\n                    }\n                });\n\n                return option;\n            }\n        };\n    }\n);\n","Magento_GiftMessage/js/model/url-builder.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/url-builder'\n    ],\n    function ($, urlBuilder) {\n        'use strict';\n\n        return $.extend(\n            urlBuilder,\n            {\n                storeCode: window.giftOptionsConfig.storeCode\n            }\n        );\n    }\n);\n","Magento_GiftMessage/js/view/gift-message.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_GiftMessage/js/model/gift-message',\n        'Magento_GiftMessage/js/model/gift-options',\n        'Magento_GiftMessage/js/action/gift-options'\n    ],\n    function (Component, GiftMessage, giftOptions, giftOptionsService) {\n        'use strict';\n\n        return Component.extend({\n            formBlockVisibility: null,\n            resultBlockVisibility: null,\n            model: {},\n\n            /**\n             * Component init\n             */\n            initialize: function () {\n                var self = this,\n                    model;\n\n                this._super()\n                    .observe('formBlockVisibility')\n                    .observe({\n                        'resultBlockVisibility': false\n                    });\n\n                this.itemId = this.itemId || 'orderLevel';\n                model = new GiftMessage(this.itemId);\n                giftOptions.addOption(model);\n                this.model = model;\n\n                this.model.getObservable('isClear').subscribe(function (value) {\n                    if (value == true) {\n                        self.formBlockVisibility(false);\n                        self.model.getObservable('alreadyAdded')(true);\n                    }\n                });\n\n                this.isResultBlockVisible();\n            },\n\n            /**\n             * Is reslt block visible\n             */\n            isResultBlockVisible: function () {\n                var self = this;\n\n                if (this.model.getObservable('alreadyAdded')()) {\n                    this.resultBlockVisibility(true);\n                }\n                this.model.getObservable('additionalOptionsApplied').subscribe(function (value) {\n                    if (value == true) {\n                        self.resultBlockVisibility(true);\n                    }\n                });\n            },\n\n            /**\n             * @param {String} key\n             * @return {*}\n             */\n            getObservable: function (key) {\n                return this.model.getObservable(key);\n            },\n\n            /**\n             * Hide\\Show form block\n             */\n            toggleFormBlockVisibility: function () {\n                if (!this.model.getObservable('alreadyAdded')()) {\n                    this.formBlockVisibility(!this.formBlockVisibility());\n                } else {\n                    this.resultBlockVisibility(!this.resultBlockVisibility());\n                }\n            },\n\n            /**\n             * Edit options\n             */\n            editOptions: function () {\n                this.resultBlockVisibility(false);\n                this.formBlockVisibility(true);\n            },\n\n            /**\n             * Delete options\n             */\n            deleteOptions: function () {\n                giftOptionsService(this.model, true);\n            },\n\n            /**\n             * Hide form block\n             */\n            hideFormBlock: function () {\n                this.formBlockVisibility(false);\n\n                if (this.model.getObservable('alreadyAdded')()) {\n                    this.resultBlockVisibility(true);\n                }\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            hasActiveOptions: function () {\n                var regionData = this.getRegion('additionalOptions'),\n                    options = regionData();\n\n                for (var i = 0; i < options.length; i++) {\n                    if (options[i].isActive()) {\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isActive: function () {\n                return this.model.isGiftMessageAvailable();\n            },\n\n            /**\n             * Submit options\n             */\n            submitOptions: function () {\n                giftOptionsService(this.model);\n            }\n        });\n    }\n);\n","Magento_Downloadable/downloadable.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true expr:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"Magento_Catalog/js/price-box\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.downloadable', {\n        options: {\n            priceHolderSelector: '.price-box'\n        },\n\n        _create: function() {\n            var self = this;\n\n            this.element.find(this.options.linkElement).on('change', $.proxy(function() {\n                this._reloadPrice();\n            }, this));\n\n            this.element.find(this.options.allElements).on('change', function() {\n                if (this.checked) {\n                    $('label[for=\"' + this.id + '\"] > span').text($(this).attr('data-checked'));\n                    self.element.find(self.options.linkElement + ':not(:checked)').each(function(){\n                        $(this).trigger('click');\n                    });\n                } else {\n                    $('[for=\"' + this.id + '\"] > span').text($(this).attr('data-notchecked'));\n                    self.element.find(self.options.linkElement + ':checked').each(function(){\n                        $(this).trigger('click');\n                    });\n                }\n            });\n        },\n\n        /**\n         * Reload product price with selected link price included\n         * @private\n         */\n        _reloadPrice: function() {\n            var finalPrice = 0;\n            var basePrice = 0;\n            this.element.find(this.options.linkElement + ':checked').each($.proxy(function(index, element) {\n                finalPrice += this.options.config.links[$(element).val()].finalPrice;\n                basePrice += this.options.config.links[$(element).val()].basePrice;\n            }, this));\n\n            $(this.options.priceHolderSelector).trigger('updatePrice', {\n                'prices': {\n                    'finalPrice': { 'amount': finalPrice },\n                    'basePrice': { 'amount': basePrice }\n                }\n            });\n        }\n    });\n    \n    return $.mage.downloadable;\n});","Magento_Msrp/js/msrp.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'mage/dropdown',\n    'mage/template'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.addToCart', {\n        options: {\n            showAddToCart: true,\n            submitUrl: '',\n            cartButtonId: '',\n            singleOpenDropDown: true,\n            dialog: {}, // Options for mage/dropdown\n            dialogDelay: 500, // Delay in ms after resize dropdown shown again\n            origin: '', //Required, type of popup: 'msrp', 'tier' or 'info' popup\n\n            // Selectors\n            cartForm: '.form.map.checkout',\n            msrpLabelId: '#map-popup-msrp',\n            priceLabelId: '#map-popup-price',\n            popUpAttr: '[data-role=msrp-popup-template]',\n            popupCartButtonId: '#map-popup-button',\n            paypalCheckoutButons: '[data-action=checkout-form-submit]',\n            popupId: '',\n            realPrice: '',\n            isSaleable: '',\n            msrpPrice: '',\n            helpLinkId: '',\n            addToCartButton: '',\n\n            // Text options\n            productName: '',\n            addToCartUrl: ''\n        },\n\n        openDropDown: null,\n        triggerClass: 'dropdown-active',\n\n        popUpOptions: {\n            appendTo: 'body',\n            dialogContentClass: 'active',\n            closeOnMouseLeave: false,\n            autoPosition: true,\n            closeOnClickOutside: false,\n            'dialogClass': 'popup map-popup-wrapper',\n            position: {\n                my: 'left top',\n                collision: 'fit none',\n                at: 'left bottom',\n                within: 'body'\n            },\n            shadowHinter: 'popup popup-pointer'\n        },\n        popupOpened: false,\n\n        /**\n         * Creates widget instance\n         * @private\n         */\n        _create: function () {\n            if (this.options.origin === 'msrp') {\n                this.initMsrpPopup();\n            } else if (this.options.origin === 'info') {\n                this.initInfoPopup();\n            } else if (this.options.origin === 'tier') {\n                this.initTierPopup();\n            }\n            $(this.options.cartButtonId).on('click', this._addToCartSubmit.bind(this));\n        },\n\n        /**\n         * Init msrp popup\n         * @private\n         */\n        initMsrpPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $msrpPopup = $(popupDOM.innerHTML.trim());\n\n            $msrpPopup.find(this.options.productIdInput).val(this.options.productId);\n            $('body').append($msrpPopup);\n            $msrpPopup.trigger('contentUpdated');\n\n            $msrpPopup.find('button')\n                .on('click',\n                this.handleMsrpAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $msrpPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleMsrpPaypalCheckout.bind(this));\n\n            $(this.options.popupId).on('click',\n                this.openPopup.bind(this));\n\n            this.$popup = $msrpPopup;\n        },\n\n        /**\n         * Init info popup\n         * @private\n         */\n        initInfoPopup: function () {\n            var infoPopupDOM = $('[data-role=msrp-info-template]')[0],\n                $infoPopup = $(infoPopupDOM.innerHTML.trim());\n\n            $('body').append($infoPopup);\n\n            $(this.options.helpLinkId).on('click', function (e) {\n                this.popUpOptions.position.of = $(e.target);\n                $infoPopup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n                this._toggle($infoPopup);\n            }.bind(this));\n\n            this.$popup = $infoPopup;\n        },\n\n        /**\n         * Init tier price popup\n         * @private\n         */\n        initTierPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $tierPopup = $(popupDOM.innerHTML.trim());\n\n            $('body').append($tierPopup);\n            $tierPopup.find(this.options.productIdInput).val(this.options.productId);\n            this.popUpOptions.position.of = $(this.options.helpLinkId);\n\n            $tierPopup.find('button').on('click',\n                this.handleTierAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $tierPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleTierPaypalCheckout.bind(this));\n\n            $(this.options.attr).on('click', function (e) {\n                this.$popup = $tierPopup;\n                this.tierOptions = $(e.target).data('tier-price');\n                this.openPopup(e);\n            }.bind(this));\n        },\n\n        /**\n         * handle 'AddToCart' click on Msrp popup\n         * @param {Object} ev\n         *\n         * @private\n         */\n        handleMsrpAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Msrp popup\n         *\n         * @private\n         */\n        handleMsrpPaypalCheckout: function () {\n            this.closePopup(this.$popup);\n        },\n\n        /**\n         * handle 'AddToCart' click on Tier popup\n         *\n         * @param {Object} ev\n         * @private\n         */\n        handleTierAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton &&\n                this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Tier popup\n         *\n         * @private\n         */\n        handleTierPaypalCheckout: function () {\n            if (this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * Open and set up popup\n         *\n         * @param {Object} event\n         */\n        openPopup: function (event) {\n            var options = this.tierOptions || this.options;\n\n            this.popUpOptions.position.of = $(event.target);\n            this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n            this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n            this.$popup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n            this._toggle(this.$popup);\n\n            if (!this.options.isSaleable) {\n                this.$popup.find('form').hide();\n            }\n        },\n\n        /**\n         *\n         * @param {HTMLElement} $elem\n         * @private\n         */\n        _toggle: function ($elem) {\n            $(document).on('mouseup.msrp touchend.msrp', function (e) {\n                if (!$elem.is(e.target) && $elem.has(e.target).length === 0) {\n                    this.closePopup($elem);\n                }\n            }.bind(this));\n            $(window).on('resize', function () {\n                this.closePopup($elem);\n            }.bind(this));\n        },\n\n        /**\n         *\n         * @param {HTMLElement} $elem\n         */\n        closePopup: function ($elem) {\n            $elem.dropdownDialog('close');\n            $(document).off('mouseup.msrp touchend.msrp');\n        },\n\n        /**\n         * Handler for addToCart action\n         */\n        _addToCartSubmit: function () {\n            this.element.trigger('addToCart', this.element);\n\n            if (this.element.data('stop-processing')) {\n                return false;\n            }\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n\n                return false;\n            }\n\n            if (this.options.addToCartUrl) {\n                $('.mage-dropdown-dialog > .ui-dialog-content').dropdownDialog('close');\n            }\n            $(this.options.cartForm).submit();\n\n        }\n    });\n\n    return $.mage.addToCart;\n});\n","Magento_Msrp/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Tax/js/view/checkout/minicart/subtotal/totals',\n    'underscore'\n], function (Component, _) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.displaySubtotal(this.isMsrpApplied(this.cart().items));\n            this.cart.subscribe(function (updatedCart) {\n\n                this.displaySubtotal(this.isMsrpApplied(updatedCart.items));\n            }, this);\n        },\n\n        /**\n         * Determine if subtotal should be hidden.\n         * @param {Array} cartItems\n         * @return {Boolean}\n         */\n        isMsrpApplied: function (cartItems) {\n            return !_.find(cartItems, function (item) {\n                if (_.has(item, 'canApplyMsrp')) {\n                    return item.canApplyMsrp;\n                }\n\n                return false;\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery/ui',\n    'jquery/jquery.parsequery'\n], function ($, _, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.configurable', {\n        options: {\n            superSelector: '.super-attribute-select',\n            selectSimpleProduct: '[name=\"selected_configurable_option\"]',\n            priceHolderSelector: '.price-box',\n            spConfig: {},\n            state: {},\n            priceFormat: {},\n            optionTemplate: '<%- data.label %>' +\n            \"<% if (typeof data.finalPrice.value !== 'undefined') { %>\" +\n            ' <%- data.finalPrice.formatted %>' +\n            '<% } %>',\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n            mediaGalleryInitial: null,\n            onlyMainImg: false\n        },\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            // Initial setting of various option values\n            this._initializeOptions();\n\n            // Override defaults with URL query parameters and/or inputs values\n            this._overrideDefaults();\n\n            // Change events to check select reloads\n            this._setupChangeEvents();\n\n            // Fill state\n            this._fillState();\n\n            // Setup child and prev/next settings\n            this._setChildSettings();\n\n            // Setup/configure values to inputs\n            this._configureForValues();\n        },\n\n        /**\n         * Initialize tax configuration, initial settings, and options values.\n         * @private\n         */\n        _initializeOptions: function () {\n            var options = this.options,\n                gallery = $(options.mediaGallerySelector),\n                priceBoxOptions = $(this.options.priceHolderSelector).priceBox('option').priceConfig || null;\n\n            if (priceBoxOptions && priceBoxOptions.optionTemplate) {\n                options.optionTemplate = priceBoxOptions.optionTemplate;\n            }\n\n            if (priceBoxOptions && priceBoxOptions.priceFormat) {\n                options.priceFormat = priceBoxOptions.priceFormat;\n            }\n            options.optionTemplate = mageTemplate(options.optionTemplate);\n\n            options.settings = options.spConfig.containerId ?\n                $(options.spConfig.containerId).find(options.superSelector) :\n                $(options.superSelector);\n\n            options.values = options.spConfig.defaultValues || {};\n            options.parentImage = $('[data-role=base-image-container] img').attr('src');\n\n            this.inputSimpleProduct = this.element.find(options.selectSimpleProduct);\n\n            gallery.on('gallery:loaded', function () {\n                var galleryObject = gallery.data('gallery');\n                options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n            });\n        },\n\n        /**\n         * Override default options values settings with either URL query parameters or\n         * initialized inputs values.\n         * @private\n         */\n        _overrideDefaults: function () {\n            var hashIndex = window.location.href.indexOf('#');\n\n            if (hashIndex !== -1) {\n                this._parseQueryParams(window.location.href.substr(hashIndex + 1));\n            }\n\n            if (this.options.spConfig.inputsInitialized) {\n                this._setValuesByAttribute();\n            }\n        },\n\n        /**\n         * Parse query parameters from a query string and set options values based on the\n         * key value pairs of the parameters.\n         * @param {*} queryString - URL query string containing query parameters.\n         * @private\n         */\n        _parseQueryParams: function (queryString) {\n            var queryParams = $.parseQuery({\n                query: queryString\n            });\n\n            $.each(queryParams, $.proxy(function (key, value) {\n                this.options.values[key] = value;\n            }, this));\n        },\n\n        /**\n         * Override default options values with values based on each element's attribute\n         * identifier.\n         * @private\n         */\n        _setValuesByAttribute: function () {\n            this.options.values = {};\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                var attributeId;\n\n                if (element.value) {\n                    attributeId = element.id.replace(/[a-z]*/, '');\n                    this.options.values[attributeId] = element.value;\n                }\n            }, this));\n        },\n\n        /**\n         * Set up .on('change') events for each option element to configure the option.\n         * @private\n         */\n        _setupChangeEvents: function () {\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                $(element).on('change', this, this._configure);\n            }, this));\n        },\n\n        /**\n         * Iterate through the option settings and set each option's element configuration,\n         * attribute identifier. Set the state based on the attribute identifier.\n         * @private\n         */\n        _fillState: function () {\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.options.spConfig.attributes[attributeId]) {\n                    element.config = this.options.spConfig.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.options.state[attributeId] = false;\n                }\n            }, this));\n        },\n\n        /**\n         * Set each option's child settings, and next/prev option setting. Fill (initialize)\n         * an option's list of selections as needed or disable an option's setting.\n         * @private\n         */\n        _setChildSettings: function () {\n            var childSettings = [],\n                settings = this.options.settings,\n                index = settings.length,\n                option;\n\n            while (index--) {\n                option = settings[index];\n\n                if (index) {\n                    option.disabled = true;\n                } else {\n                    this._fillSelect(option);\n                }\n\n                _.extend(option, {\n                    childSettings: childSettings.slice(),\n                    prevSetting: settings[index - 1],\n                    nextSetting: settings[index + 1]\n                });\n\n                childSettings.push(option);\n            }\n        },\n\n        /**\n         * Setup for all configurable option settings. Set the value of the option and configure\n         * the option, which sets its state, and initializes the option's choices, etc.\n         * @private\n         */\n        _configureForValues: function () {\n            if (this.options.values) {\n                this.options.settings.each($.proxy(function (index, element) {\n                    var attributeId = element.attributeId;\n                    element.value = this.options.values[attributeId] || '';\n                    this._configureElement(element);\n                }, this));\n            }\n        },\n\n        /**\n         * Event handler for configuring an option.\n         * @private\n         * @param {Object} event - Event triggered to configure an option.\n         */\n        _configure: function (event) {\n            event.data._configureElement(this);\n        },\n\n        /**\n         * Configure an option, initializing it's state and enabling related options, which\n         * populates the related option's selection and resets child option selections.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _configureElement: function (element) {\n            this.simpleProduct = this._getSimpleProductId(element);\n\n            if (element.value) {\n                this.options.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this._fillSelect(element.nextSetting);\n                    this._resetChildren(element.nextSetting);\n                } else {\n                    if (!!document.documentMode) {\n                        this.inputSimpleProduct.val(element.options[element.selectedIndex].config.allowedProducts[0]);\n                    } else {\n                        this.inputSimpleProduct.val(element.selectedOptions[0].config.allowedProducts[0]);\n                    }\n                }\n            } else {\n                this._resetChildren(element);\n            }\n            this._reloadPrice();\n            this._changeProductImage();\n        },\n\n        /**\n         * Change displayed product image according to chosen options of configurable product\n         * @private\n         */\n        _changeProductImage: function () {\n            var images,\n                initialImages = $.extend(true, [], this.options.mediaGalleryInitial),\n                galleryObject = $(this.options.mediaGallerySelector).data('gallery');\n\n            if (this.options.spConfig.images[this.simpleProduct]) {\n                images = $.extend(true, [], this.options.spConfig.images[this.simpleProduct]);\n            }\n\n            function updateGallery(imagesArr) {\n                var imgToUpdate,\n                    mainImg;\n\n                mainImg = imagesArr.filter(function (img) {\n                    return img.isMain;\n                });\n\n                imgToUpdate = mainImg.length ? mainImg[0] : imagesArr[0];\n                galleryObject.updateDataByIndex(0, imgToUpdate);\n                galleryObject.seek(1);\n            }\n\n            if (galleryObject) {\n                if (images) {\n                    images.map(function (img) {\n                        img.type = 'image';\n                    });\n\n                    if (this.options.onlyMainImg) {\n                        updateGallery(images);\n                    } else {\n                        galleryObject.updateData(images)\n                    }\n                } else {\n                    if (this.options.onlyMainImg) {\n                        updateGallery(initialImages);\n                    } else {\n                        galleryObject.updateData(this.options.mediaGalleryInitial);\n                        $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n                    }\n                }\n            }\n        },\n\n        /**\n         * For a given option element, reset all of its selectable options. Clear any selected\n         * index, disable the option choice, and reset the option's state if necessary.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _resetChildren: function (element) {\n            if (element.childSettings) {\n                _.each(element.childSettings, function (set) {\n                    set.selectedIndex = 0;\n                    set.disabled = true;\n                });\n\n                if (element.config) {\n                    this.options.state[element.config.id] = false;\n                }\n            }\n        },\n\n        /**\n         * Populates an option's selectable choices.\n         * @private\n         * @param {*} element - Element associated with a configurable option.\n         */\n        _fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this._getAttributeOptions(attributeId),\n                prevConfig,\n                index = 1,\n                allowedProducts,\n                i,\n                j;\n\n            this._clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.options.spConfig.chooseText;\n            prevConfig = false;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (i = 0; i < options.length; i++) {\n                    allowedProducts = [];\n\n                    if (prevConfig) {\n                        for (j = 0; j < options[i].products.length; j++) {\n                            // prevConfig.config can be undefined\n                            if (prevConfig.config &&\n                                prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1) {\n                                allowedProducts.push(options[i].products[j]);\n                            }\n                        }\n                    } else {\n                        allowedProducts = options[i].products.slice(0);\n                    }\n\n                    if (allowedProducts.length > 0) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this._getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price !== 'undefined') {\n                            element.options[index].setAttribute('price', options[i].prices);\n                        }\n\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n                }\n            }\n        },\n\n        /**\n         * Generate the label associated with a configurable option. This includes the option's\n         * label or value and the option's price.\n         * @private\n         * @param {*} option - A single choice among a group of choices for a configurable option.\n         * @return {String} The option label with option value and price (e.g. Black +1.99)\n         */\n        _getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * Removes an option's selections.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * Retrieve the attribute options associated with a specific attribute Id.\n         * @private\n         * @param {Number} attributeId - The id of the attribute whose configurable options are sought.\n         * @return {Object} Object containing the attribute options.\n         */\n        _getAttributeOptions: function (attributeId) {\n            if (this.options.spConfig.attributes[attributeId]) {\n                return this.options.spConfig.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload the price of the configurable product incorporating the prices of all of the\n         * configurable product's option selections.\n         */\n        _reloadPrice: function () {\n            $(this.options.priceHolderSelector).trigger('updatePrice', this._getPrices());\n        },\n\n        /**\n         * Get product various prices\n         * @returns {{}}\n         * @private\n         */\n        _getPrices: function () {\n            var prices = {},\n                elements = _.toArray(this.options.settings),\n                hasProductPrice = false;\n\n            _.each(elements, function (element) {\n                var selected = element.options[element.selectedIndex],\n                    config = selected && selected.config,\n                    priceValue = {};\n\n                if (config && config.allowedProducts.length === 1 && !hasProductPrice) {\n                    priceValue = this._calculatePrice(config);\n                    hasProductPrice = true;\n                }\n\n                prices[element.attributeId] = priceValue;\n            }, this);\n\n            return prices;\n        },\n\n        /**\n         * Returns pracies for configured products\n         *\n         * @param {*} config - Products configuration\n         * @returns {*}\n         * @private\n         */\n        _calculatePrice: function (config) {\n            var displayPrices = $(this.options.priceHolderSelector).priceBox('option').prices,\n                newPrices = this.options.spConfig.optionPrices[_.first(config.allowedProducts)];\n\n            _.each(displayPrices, function (price, code) {\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Returns Simple product Id\n         *  depending on current selected option.\n         *\n         * @private\n         * @param {HTMLElement} element\n         * @returns {String|undefined}\n         */\n        _getSimpleProductId: function (element) {\n            // TODO: Rewrite algorithm. It should return ID of\n            //        simple product based on selected options.\n            var allOptions = element.config.options,\n                value = element.value,\n                config;\n\n            config = _.filter(allOptions, function (option) {\n                return option.id === value;\n            });\n            config = _.first(config);\n\n            return _.isEmpty(config) ?\n                undefined :\n                _.first(config.allowedProducts);\n\n        }\n\n    });\n\n    return $.mage.configurable;\n});\n","Magento_Wishlist/wishlist.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true sub:true*/\n/*global alert*/\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/validation/validation',\n\n    'mage/dataPost'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.wishlist', {\n        options: {\n            dataAttribute: 'item-id',\n            nameFormat: 'qty[{0}]',\n            btnRemoveSelector: '[data-role=remove]',\n            qtySelector: '[data-role=qty]',\n            addToCartSelector: '[data-role=tocart]',\n            addAllToCartSelector: '[data-role=all-tocart]',\n            commentInputType: 'textarea',\n            infoList: false\n        },\n\n        /**\n         * Bind handlers to events.\n         */\n        _create: function () {\n            var _this = this;\n            if (!this.options.infoList) {\n                this.element\n                    .on('addToCart', function (event, context) {\n                        event.stopPropagation(event);\n                        $(context).data('stop-processing', true);\n                        var urlParams = _this._getItemsToCartParams(\n                            $(context).parents('[data-row=product-item]').find(_this.options.addToCartSelector)\n                        );\n                        $.mage.dataPost().postData(urlParams);\n                        return false;\n                    })\n                    .on('click', this.options.btnRemoveSelector, $.proxy(function (event) {\n                        event.preventDefault();\n                        $.mage.dataPost().postData($(event.currentTarget).data('post-remove'));\n                    }, this))\n                    .on('click', this.options.addAllToCartSelector, $.proxy(this._addAllWItemsToCart, this))\n                    .on('focusin focusout', this.options.commentInputType, $.proxy(this._focusComment, this));\n            }\n\n            // Setup validation for the form\n            this.element.mage('validation', {\n                errorPlacement: function (error, element) {\n                    error.insertAfter(element.next());\n                }\n            });\n        },\n\n        /**\n         * Add wish list items to cart.\n         * @private\n         * @param {jQuery object} elem - clicked 'add to cart' button\n         */\n        _getItemsToCartParams: function (elem) {\n            if (elem.data(this.options.dataAttribute)) {\n                var itemId = elem.data(this.options.dataAttribute),\n                    url = this.options.addToCartUrl,\n                    qtyName = $.validator.format(this.options.nameFormat, itemId),\n                    qtyValue = elem.parents().find('[name=\"' + qtyName + '\"]').val();\n                url.data.item = itemId;\n                url.data.qty = qtyValue;\n                return url;\n            }\n        },\n\n        /**\n         * Add all wish list items to cart\n         * @private\n         */\n        _addAllWItemsToCart: function () {\n            var urlParams = this.options.addAllToCartUrl,\n                separator = (urlParams.action.indexOf('?') >= 0) ? '&' : '?';\n\n            this.element.find(this.options.qtySelector).each(function (index, element) {\n                urlParams.action += separator + $(element).prop('name') + '=' + encodeURIComponent($(element).val());\n                separator = '&';\n            });\n            $.mage.dataPost().postData(urlParams);\n        },\n\n        /**\n         * Toggle comment string.\n         * @private\n         * @param {Event} e\n         */\n        _focusComment: function (e) {\n            var commentInput = e.currentTarget;\n\n            if (commentInput.value === '' || commentInput.value === this.options.commentString) {\n                commentInput.value = commentInput.value === this.options.commentString ?\n                    '' : this.options.commentString;\n            }\n        }\n    });\n\n    // Extension for mage.wishlist - Select All checkbox\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            selectAllCheckbox: '#select-all',\n            parentContainer: '#wishlist-table'\n        },\n\n        _create: function () {\n            this._super();\n            var selectAllCheckboxParent = $(this.options.selectAllCheckbox).parents(this.options.parentContainer),\n                checkboxCount = selectAllCheckboxParent.find('input:checkbox:not(' + this.options.selectAllCheckbox + ')').length;\n            // If Select all checkbox is checked, check all item checkboxes, if unchecked, uncheck all item checkboxes\n            $(this.options.selectAllCheckbox).on('click', function () {\n                selectAllCheckboxParent.find('input:checkbox').attr('checked', $(this).is(':checked'));\n            });\n            // If all item checkboxes are checked, check select all checkbox,\n            // if not all item checkboxes are checked, uncheck select all checkbox\n            selectAllCheckboxParent.on('click', 'input:checkbox:not(' + this.options.selectAllCheckbox + ')', $.proxy(function () {\n                var checkedCount = selectAllCheckboxParent.find('input:checkbox:checked:not(' + this.options.selectAllCheckbox + ')').length;\n                $(this.options.selectAllCheckbox).attr('checked', checkboxCount === checkedCount);\n            }, this));\n        }\n    });\n    // Extension for mage.wishlist info add to cart\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        _create: function () {\n            this._super();\n\n            if (this.options.infoList) {\n                this.element.on('addToCart', $.proxy(function (event, context) {\n                    this.element.find('input:checkbox').attr('checked', false);\n                    $(context).closest('tr').find('input:checkbox').attr('checked', true);\n                    this.element.submit();\n                }, this));\n                this._checkBoxValidate();\n            }\n        },\n\n        /**\n         * validate checkbox selection.\n         * @private\n         */\n        _checkBoxValidate: function () {\n            this.element.validation({\n                submitHandler: $.proxy(function (form) {\n                    if ($(form).find('input:checkbox:checked').length) {\n                        form.submit();\n                    } else {\n                        alert({\n                            content: this.options.checkBoxValidationMessage\n                        });\n                    }\n                }, this)\n            });\n        }\n    });\n\n    // Extension for mage.wishlist - Add Wishlist item to Gift Registry\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            formTmplSelector: '#form-tmpl',\n            formTmplId: '#wishlist-hidden-form'\n        },\n\n        _create: function () {\n            this._super();\n            var _this = this;\n            this.element.on('click', '[data-wishlist-to-giftregistry]', function () {\n                var json = $(this).data('wishlist-to-giftregistry'),\n                    tmplJson = {\n                        item: json.itemId,\n                        entity: json.entity,\n                        url: json.url\n                    },\n                    html = mageTemplate(_this.options.formTmplSelector, {\n                        data: tmplJson\n                    });\n\n                $(html).appendTo('body');\n                $(_this.options.formTmplId).submit();\n            });\n        }\n    });\n\n    return $.mage.wishlist;\n});\n","Magento_Wishlist/js/add-to-wishlist.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.addToWishlist', {\n        options: {\n            bundleInfo: 'div.control [name^=bundle_option]',\n            configurableInfo: '.super-attribute-select',\n            groupedInfo: '#super-product-table input',\n            downloadableInfo: '#downloadable-links-list input',\n            customOptionsInfo: '.product-custom-option',\n            qtyInfo: '#qty'\n        },\n        _create: function () {\n            this._bind();\n        },\n        _bind: function() {\n            var options = this.options,\n                dataUpdateFunc = '_updateWishlistData',\n                changeCustomOption = 'change ' + options.customOptionsInfo,\n                changeQty = 'change ' + options.qtyInfo,\n                events = {};\n\n            if ('productType' in options) {\n                if (typeof options.productType === 'string') {\n                    options.productType = [options.productType];\n                }\n            } else {\n                options.productType = [];\n            }\n\n            events[changeCustomOption] = dataUpdateFunc;\n            events[changeQty] = dataUpdateFunc;\n\n            for (var key in options.productType) {\n                if (options.productType.hasOwnProperty(key) && options.productType[key] + 'Info' in options) {\n                    events['change ' + options[options.productType[key] + 'Info']] = dataUpdateFunc;\n                }\n            }\n            this._on(events);\n        },\n        _updateWishlistData: function(event) {\n            var dataToAdd = {},\n                isFileUploaded = false;\n            if (event.handleObj.selector == this.options.qtyInfo) {\n                this._updateAddToWishlistButton({});\n                event.stopPropagation();\n                return;\n            }\n            var self = this;\n            $(event.handleObj.selector).each(function(index, element){\n                if ($(element).is('input[type=text]')\n                    || $(element).is('input[type=email]')\n                    || $(element).is('input[type=number]')\n                    || $(element).is('input[type=hidden]')\n                    || $(element).is('input[type=checkbox]:checked')\n                    || $(element).is('input[type=radio]:checked')\n                    || $(element).is('textarea')\n                    || $('#' + element.id + ' option:selected').length\n                ) {\n                    dataToAdd = $.extend({}, dataToAdd, self._getElementData(element));\n                    return;\n                }\n                if ($(element).is('input[type=file]') && $(element).val()) {\n                    isFileUploaded = true;\n                }\n            });\n            if (isFileUploaded) {\n                this.bindFormSubmit();\n            }\n            this._updateAddToWishlistButton(dataToAdd);\n            event.stopPropagation();\n        },\n        _updateAddToWishlistButton: function(dataToAdd) {\n            var self = this;\n            $('[data-action=\"add-to-wishlist\"]').each(function(index, element) {\n                var params = $(element).data('post');\n                if (!params)\n                    params = {'data': {}};\n\n                if (!$.isEmptyObject(dataToAdd)) {\n                    self._removeExcessiveData(params, dataToAdd);\n                }\n\n                params.data = $.extend({}, params.data, dataToAdd, {'qty': $(self.options.qtyInfo).val()});\n                $(element).data('post', params);\n            });\n        },\n        _arrayDiffByKeys: function(array1, array2) {\n            var result = {};\n            $.each(array1, function(key, value) {\n                if (key.indexOf('option') === -1) {\n                    return;\n                }\n                if (!array2[key])\n                    result[key] = value;\n            });\n            return result;\n        },\n        _getElementData: function(element) {\n            element = $(element);\n            var data = {},\n                elementName = element.data('selector') ? element.data('selector') : element.attr('name'),\n                elementValue = element.val();\n            if (element.is('select[multiple]') && elementValue !== null) {\n                if (elementName.substr(elementName.length - 2) == '[]') {\n                    elementName = elementName.substring(0, elementName.length - 2);\n                }\n                $.each(elementValue, function (key, option) {\n                    data[elementName + '[' + option + ']'] = option;\n                });\n            } else {\n                if (elementValue) {\n                    if (elementName.substr(elementName.length - 2) == '[]') {\n                        elementName = elementName.substring(0, elementName.length - 2);\n                        if (elementValue) {\n                            data[elementName + '[' + elementValue + ']'] = elementValue;\n                        }\n                    } else {\n                        data[elementName] = elementValue;\n                    }\n                }\n            }\n            return data;\n        },\n        _removeExcessiveData: function(params, dataToAdd) {\n            var dataToRemove = this._arrayDiffByKeys(params.data, dataToAdd);\n            $.each(dataToRemove, function(key, value) {\n                delete params.data[key];\n            });\n        },\n        bindFormSubmit: function() {\n            var self = this;\n            $('[data-action=\"add-to-wishlist\"]').on('click', function(event) {\n                event.stopPropagation();\n                event.preventDefault();\n\n                var element = $('input[type=file]' + self.options.customOptionsInfo),\n                    params = $(event.currentTarget).data('post'),\n                    form = $(element).closest('form'),\n                    action = params.action;\n                if (params.data.id) {\n                    $('<input>', {\n                        type: 'hidden',\n                        name: 'id',\n                        value: params.data.id\n                    }).appendTo(form);\n                }\n                if (params.data.uenc) {\n                    action += 'uenc/' + params.data.uenc;\n                }\n\n                $(form).attr('action', action).submit();\n            });\n        }\n    });\n    \n    return $.mage.addToWishlist;\n});\n","Magento_Wishlist/js/search.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.wishlistSearch', {\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function() {\n            this.element.on('change', $.proxy(this._toggleForm, this));\n        },\n\n        /**\n         * Toggle Form\n         * @private\n         */\n        _toggleForm: function() {\n            switch (this.element.val()) {\n                case 'name':\n                    $(this.options.emailFormSelector).hide();\n                    $(this.options.nameFormSelector).show();\n                    break;\n                case 'email':\n                    $(this.options.nameFormSelector).hide();\n                    $(this.options.emailFormSelector).show();\n                    break;\n                default:\n                    $(this.options.emailFormSelector).add(this.options.nameFormSelector).hide();\n            }\n        }\n    });\n\n    return $.mage.wishlistSearch;\n});","Magento_Wishlist/js/view/wishlist.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        initialize: function () {\n            this._super();\n\n            this.wishlist = customerData.get('wishlist');\n        }\n    });\n});\n","Magento_Vault/js/customer_account/deleteWidget.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modalToggle',\n    'mage/translate'\n], function ($, modalToggle) {\n    'use strict';\n\n    return function (config, deleteButton) {\n        config.buttons = [\n            {\n                text: $.mage.__('Cancel'),\n                class: 'action secondary cancel'\n            }, {\n                text: $.mage.__('Delete'),\n                class: 'action primary',\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) { //eslint-disable-line no-unused-vars\n                    deleteButton.form.submit();\n                }\n            }\n        ];\n\n        modalToggle(config, deleteButton);\n    };\n});\n","Magento_Vault/js/view/payment/vault-enabler.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiElement'\n    ],\n    function (\n        Component\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                isActivePaymentTokenEnabler: true\n            },\n\n            /**\n             * @param {String} paymentCode\n             */\n            setPaymentCode: function (paymentCode) {\n                this.paymentCode = paymentCode;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'isActivePaymentTokenEnabler'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * @param {Object} data\n             */\n            visitAdditionalData: function (data) {\n                if (!this.isVaultEnabled()) {\n                    return;\n                }\n\n                if (!('additional_data' in data)) {\n                    data['additional_data'] = {};\n                }\n\n                data['additional_data']['is_active_payment_token_enabler'] = this.isActivePaymentTokenEnabler();\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isVaultEnabled: function () {\n                return typeof window.checkoutConfig.vault[this.paymentCode] !== 'undefined' &&\n                    window.checkoutConfig.vault[this.paymentCode]['is_enabled'] === true;\n            }\n        });\n    }\n);\n","Magento_Vault/js/view/payment/vault.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        _,\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        _.each(window.checkoutConfig.payment.vault, function (config, index) {\n            rendererList.push(\n                {\n                    type: index,\n                    config: config.config,\n                    component: config.component,\n\n                    /**\n                     * Custom payment method types comparator\n                     * @param {String} typeA\n                     * @param {String} typeB\n                     * @return {Boolean}\n                     */\n                    typeComparatorCallback: function (typeA, typeB) {\n                        return typeA.indexOf(typeB) === 0;\n                    }\n                }\n            );\n        });\n\n        /**\n         * Add view logic here if needed\n         */\n        return Component.extend({});\n    }\n);\n","Magento_Vault/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/checkout-data'\n    ],\n    function (Component, selectPaymentMethod, checkoutData) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Vault/payment/form'\n            },\n\n            /**\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([]);\n\n                return this;\n            },\n\n            /**\n             * @returns\n             */\n            selectPaymentMethod: function () {\n                selectPaymentMethod(\n                    {\n                        method: this.getId()\n                    }\n                );\n                checkoutData.setSelectedPaymentMethod(this.getId());\n\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTitle: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getToken: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getId: function () {\n                return this.index;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Get last 4 digits of card\n             * @returns {String}\n             */\n            getMaskedCard: function () {\n                return '';\n            },\n\n            /**\n             * Get expiration date\n             * @returns {String}\n             */\n            getExpirationDate: function () {\n                return '';\n            },\n\n            /**\n             * Get card type\n             * @returns {String}\n             */\n            getCardType: function () {\n                return '';\n            },\n\n            /**\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * @returns {*}\n             */\n            getData: function () {\n                var data = {\n                    method: this.getCode()\n                };\n\n                data['additional_data'] = {};\n                data['additional_data']['public_hash'] = this.getToken();\n\n                return data;\n            }\n        });\n    }\n);\n","Magento_SalesRule/js/form/element/coupon-type.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function (_, uiRegistry, select) {\n    'use strict';\n\n    return select.extend({\n\n        /**\n         * Hide fields on coupon tab\n         */\n        onUpdate: function () {\n\n            /* eslint-disable eqeqeq */\n            if (this.value() != this.displayOnlyForCouponType) {\n                uiRegistry.get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation').checked(false);\n            }\n\n            this.enableDisableFields();\n        },\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/manage-coupon-codes.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, uiRegistry, fieldset, async) {\n    'use strict';\n\n    return fieldset.extend({\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Initialize element\n         *\n         * @returns {Abstract} Chainable\n         */\n        initialize: function (elems, position) {\n            var obj = this;\n\n            this._super();\n\n            async.async('#sales-rule-form-tab-coupons', document.getElementById('container'), function (node) {\n                var useAutoGeneration = uiRegistry.get(\n                    'sales_rule_form.sales_rule_form.rule_information.use_auto_generation'\n                );\n\n                useAutoGeneration.on('checked', function () {\n                    obj.enableDisableFields();\n                });\n                obj.enableDisableFields();\n            });\n\n            return this;\n        },\n\n        /*eslint-enable no-unused-vars*/\n        /*eslint-disable lines-around-comment*/\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            /**\n             * \\Magento\\Rule\\Model\\AbstractModel::COUPON_TYPE_AUTO\n             */\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/action/cancel-coupon.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\n/*global define,alert*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/resource-url-manager',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_SalesRule/js/model/payment/discount-messages',\n        'mage/storage',\n        'Magento_Checkout/js/action/get-payment-information',\n        'Magento_Checkout/js/model/totals',\n        'mage/translate'\n    ],\n    function ($, quote, urlManager, errorProcessor, messageContainer, storage, getPaymentInformationAction, totals, $t) {\n        'use strict';\n\n        return function (isApplied, isLoading) {\n            var quoteId = quote.getQuoteId(),\n                url = urlManager.getCancelCouponUrl(quoteId),\n                message = $t('Your coupon was successfully removed.');\n            messageContainer.clear();\n\n            return storage.delete(\n                url,\n                false\n            ).done(\n                function () {\n                    var deferred = $.Deferred();\n                    totals.isLoading(true);\n                    getPaymentInformationAction(deferred);\n                    $.when(deferred).done(function () {\n                        isApplied(false);\n                        totals.isLoading(false);\n                    });\n                    messageContainer.addSuccessMessage({\n                        'message': message\n                    });\n                }\n            ).fail(\n                function (response) {\n                    totals.isLoading(false);\n                    errorProcessor.process(response, messageContainer);\n                }\n            ).always(\n                function () {\n                    isLoading(false);\n                }\n            );\n        };\n    }\n);\n","Magento_SalesRule/js/action/set-coupon-code.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\n/*global define,alert*/\ndefine(\n    [\n        'ko',\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/resource-url-manager',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_SalesRule/js/model/payment/discount-messages',\n        'mage/storage',\n        'mage/translate',\n        'Magento_Checkout/js/action/get-payment-information',\n        'Magento_Checkout/js/model/totals'\n    ],\n    function (\n        ko,\n        $,\n        quote,\n        urlManager,\n        errorProcessor,\n        messageContainer,\n        storage,\n        $t,\n        getPaymentInformationAction,\n        totals\n    ) {\n        'use strict';\n        return function (couponCode, isApplied, isLoading) {\n            var quoteId = quote.getQuoteId();\n            var url = urlManager.getApplyCouponUrl(couponCode, quoteId);\n            var message = $t('Your coupon was successfully applied.');\n            return storage.put(\n                url,\n                {},\n                false\n            ).done(\n                function (response) {\n                    if (response) {\n                        var deferred = $.Deferred();\n                        isLoading(false);\n                        isApplied(true);\n                        totals.isLoading(true);\n                        getPaymentInformationAction(deferred);\n                        $.when(deferred).done(function () {\n                            totals.isLoading(false);\n                        });\n                        messageContainer.addSuccessMessage({'message': message});\n                    }\n                }\n            ).fail(\n                function (response) {\n                    isLoading(false);\n                    totals.isLoading(false);\n                    errorProcessor.process(response, messageContainer);\n                }\n            );\n        };\n    }\n);\n","Magento_SalesRule/js/model/payment/discount-messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Ui/js/model/messages'\n    ],\n    function (Messages) {\n        'use strict';\n\n        return new Messages();\n    }\n);\n","Magento_SalesRule/js/view/cart/totals/discount.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_SalesRule/js/view/summary/discount'\n    ],\n    function (Component) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_SalesRule/cart/totals/discount'\n            },\n            /**\n             * @override\n             *\n             * @returns {boolean}\n             */\n            isDisplayed: function () {\n                return this.getPureValue() != 0;\n            }\n        });\n    }\n);\n","Magento_SalesRule/js/view/payment/discount-messages.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/view/messages',\n    '../../model/payment/discount-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n\n\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_SalesRule/js/view/payment/discount.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'ko',\n        'uiComponent',\n        'Magento_Checkout/js/model/quote',\n        'Magento_SalesRule/js/action/set-coupon-code',\n        'Magento_SalesRule/js/action/cancel-coupon'\n    ],\n    function ($, ko, Component, quote, setCouponCodeAction, cancelCouponAction) {\n        'use strict';\n        var totals = quote.getTotals();\n        var couponCode = ko.observable(null);\n        if (totals()) {\n            couponCode(totals()['coupon_code']);\n        }\n        var isApplied = ko.observable(couponCode() != null);\n        var isLoading = ko.observable(false);\n        return Component.extend({\n            defaults: {\n                template: 'Magento_SalesRule/payment/discount'\n            },\n            couponCode: couponCode,\n            /**\n             * Applied flag\n             */\n            isApplied: isApplied,\n            isLoading: isLoading,\n            /**\n             * Coupon code application procedure\n             */\n            apply: function() {\n                if (this.validate()) {\n                    isLoading(true);\n                    setCouponCodeAction(couponCode(), isApplied, isLoading);\n                }\n            },\n            /**\n             * Cancel using coupon\n             */\n            cancel: function() {\n                if (this.validate()) {\n                    isLoading(true);\n                    couponCode('');\n                    cancelCouponAction(isApplied, isLoading);\n                }\n            },\n            /**\n             * Coupon form validation\n             *\n             * @returns {boolean}\n             */\n            validate: function() {\n                var form = '#discount-form';\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","Magento_SalesRule/js/view/summary/discount.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component, quote) {\n        \"use strict\";\n        return Component.extend({\n            defaults: {\n                template: 'Magento_SalesRule/summary/discount'\n            },\n            totals: quote.getTotals(),\n            isDisplayed: function() {\n                return this.isFullMode() && this.getPureValue() != 0;\n            },\n            getCouponCode: function() {\n                if (!this.totals()) {\n                    return null;\n                }\n                return this.totals()['coupon_code'];\n            },\n            getPureValue: function() {\n                var price = 0;\n                if (this.totals() && this.totals().discount_amount) {\n                    price = parseFloat(this.totals().discount_amount);\n                }\n                return price;\n            },\n            getValue: function() {\n                return this.getFormattedPrice(this.getPureValue());\n            }\n        });\n    }\n);\n","Magento_Cookie/js/notices.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"mage/cookies\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.cookieNotices', {\n        _create: function() {\n            if ($.mage.cookies.get(this.options.cookieName)) {\n                this.element.hide();\n            } else {\n                this.element.show();\n            }\n            $(this.options.cookieAllowButtonSelector).on('click', $.proxy(function() {\n                var cookieExpires = new Date(new Date().getTime() + this.options.cookieLifetime * 1000);\n\n                $.mage.cookies.set(this.options.cookieName, this.options.cookieValue, {expires: cookieExpires});\n                if ($.mage.cookies.get(this.options.cookieName)) {\n                    window.location.reload();\n                } else {\n                    window.location.href = this.options.noCookiesUrl;\n                }\n            }, this));\n        }\n    });\n\n    return $.mage.cookieNotices;\n});\n","Magento_Cookie/js/require-cookie.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint evil:true browser:true jquery:true */\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.requireCookie', {\n        options: {\n            event: 'click',\n            noCookieUrl: 'enable-cookies',\n            triggers: ['.action.login', '.action.submit']\n        },\n\n        /**\n         * Constructor\n         * @private\n         */\n        _create: function() {\n            this._bind();\n        },\n\n        /**\n         * This method binds elements found in this widget.\n         * @private\n         */\n        _bind: function() {\n            var events = {};\n\n            $.each(this.options.triggers, function(index, value) {\n                events['click ' + value] = '_checkCookie';\n            });\n            this._on(events);\n        },\n\n        /**\n         * This method set the url for the redirect.\n         * @private\n         */\n        _checkCookie: function(event) {\n            if (navigator.cookieEnabled) {\n                return;\n            }\n            event.preventDefault();\n            window.location = this.options.noCookieUrl;\n        }\n    });\n\n    return $.mage.requireCookie;\n});\n","Magento_Search/form-mini.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    \"matchMedia\",\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, mageTemplate, mediaCheck) {\n    'use strict';\n\n    /**\n     * Check wether the incoming string is not empty or if doesn't consist of spaces.\n     *\n     * @param {String} value - Value to check.\n     * @returns {Boolean}\n     */\n    function isEmpty(value) {\n        return (value.length === 0) || (value == null) || /^\\s+$/.test(value);\n    }\n\n    $.widget('mage.quickSearch', {\n        options: {\n            autocomplete: 'off',\n            minSearchLength: 2,\n            responseFieldElements: 'ul li',\n            selectClass: 'selected',\n            template:\n                '<li class=\"<%- data.row_class %>\" id=\"qs-option-<%- data.index %>\" role=\"option\">' +\n                    '<span class=\"qs-option-name\">' +\n                       ' <%- data.title %>' +\n                    '</span>' +\n                    '<span aria-hidden=\"true\" class=\"amount\">' +\n                        '<%- data.num_results %>' +\n                    '</span>' +\n                '</li>',\n            submitBtn: 'button[type=\"submit\"]',\n            searchLabel: '[data-role=minisearch-label]',\n            isExpandable: null\n        },\n\n        _create: function () {\n            this.responseList = {\n                indexList: null,\n                selected: null\n            };\n            this.autoComplete = $(this.options.destinationSelector);\n            this.searchForm = $(this.options.formSelector);\n            this.submitBtn = this.searchForm.find(this.options.submitBtn)[0];\n            this.searchLabel = $(this.options.searchLabel);\n            this.isExpandable = this.options.isExpandable;\n\n            _.bindAll(this, '_onKeyDown', '_onPropertyChange', '_onSubmit');\n\n            this.submitBtn.disabled = true;\n\n            this.element.attr('autocomplete', this.options.autocomplete);\n\n            mediaCheck({\n                media: '(max-width: 768px)',\n                entry: function () {\n                    this.isExpandable = true;\n                }.bind(this),\n                exit: function () {\n                    this.isExpandable = false;\n                    this.element.removeAttr('aria-expanded');\n                }.bind(this)\n            });\n\n            this.searchLabel.on('click', function (e) {\n                // allow input to lose its' focus when clicking on label\n                if (this.isExpandable && this.isActive()) {\n                    e.preventDefault();\n                }\n            }.bind(this));\n\n            this.element.on('blur', $.proxy(function () {\n\n                setTimeout($.proxy(function () {\n                    if (this.autoComplete.is(':hidden')) {\n                        this.setActiveState(false);\n                    }\n                    this.autoComplete.hide();\n                    this._updateAriaHasPopup(false);\n                }, this), 250);\n            }, this));\n\n            this.element.trigger('blur');\n\n            this.element.on('focus', this.setActiveState.bind(this, true));\n            this.element.on('keydown', this._onKeyDown);\n            this.element.on('input propertychange', this._onPropertyChange);\n\n            this.searchForm.on('submit', $.proxy(function() {\n                this._onSubmit();\n                this._updateAriaHasPopup(false);\n            }, this));\n        },\n\n        /**\n         * Checks if search field is active.\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            return this.searchLabel.hasClass('active');\n        },\n\n        /**\n         * Sets state of the search field to provided value.\n         *\n         * @param {Boolean} isActive\n         */\n        setActiveState: function (isActive) {\n            this.searchLabel.toggleClass('active', isActive);\n\n            if (this.isExpandable) {\n                this.element.attr('aria-expanded', isActive);\n            }\n        },\n\n        /**\n         * @private\n         * @return {Element} The first element in the suggestion list.\n         */\n        _getFirstVisibleElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.first() : false;\n        },\n\n        /**\n         * @private\n         * @return {Element} The last element in the suggestion list.\n         */\n        _getLastElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.last() : false;\n        },\n\n        /**\n         * @private\n         * @param {Boolean} show Set attribute aria-haspopup to \"true/false\" for element.\n         */\n        _updateAriaHasPopup: function(show) {\n            if (show) {\n                this.element.attr('aria-haspopup', 'true');\n            } else {\n                this.element.attr('aria-haspopup', 'false');\n            }\n        },\n\n        /**\n         * Clears the item selected from the suggestion list and resets the suggestion list.\n         * @private\n         * @param {Boolean} all - Controls whether to clear the suggestion list.\n         */\n        _resetResponseList: function (all) {\n            this.responseList.selected = null;\n\n            if (all === true) {\n                this.responseList.indexList = null;\n            }\n        },\n\n        /**\n         * Executes when the search box is submitted. Sets the search input field to the\n         * value of the selected item.\n         * @private\n         * @param {Event} e - The submit event\n         */\n        _onSubmit: function (e) {\n            var value = this.element.val();\n\n            if (isEmpty(value)) {\n                e.preventDefault();\n            }\n\n            if (this.responseList.selected) {\n                this.element.val(this.responseList.selected.find('.qs-option-name').text());\n            }\n        },\n\n        /**\n         * Executes when keys are pressed in the search input field. Performs specific actions\n         * depending on which keys are pressed.\n         * @private\n         * @param {Event} e - The key down event\n         * @return {Boolean} Default return type for any unhandled keys\n         */\n        _onKeyDown: function (e) {\n            var keyCode = e.keyCode || e.which;\n\n            switch (keyCode) {\n                case $.ui.keyCode.HOME:\n                    this._getFirstVisibleElement().addClass(this.options.selectClass);\n                    this.responseList.selected = this._getFirstVisibleElement();\n                    break;\n                case $.ui.keyCode.END:\n                    this._getLastElement().addClass(this.options.selectClass);\n                    this.responseList.selected = this._getLastElement();\n                    break;\n                case $.ui.keyCode.ESCAPE:\n                    this._resetResponseList(true);\n                    this.autoComplete.hide();\n                    break;\n                case $.ui.keyCode.ENTER:\n                    this.searchForm.trigger('submit');\n                    break;\n                case $.ui.keyCode.DOWN:\n                    if (this.responseList.indexList) {\n                        if (!this.responseList.selected) {\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        }\n                        else if (!this._getLastElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected.removeClass(this.options.selectClass).next().addClass(this.options.selectClass);\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                    }\n                    break;\n                case $.ui.keyCode.UP:\n                    if (this.responseList.indexList !== null) {\n                        if (!this._getFirstVisibleElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected.removeClass(this.options.selectClass).prev().addClass(this.options.selectClass);\n\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getLastElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getLastElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                    }\n                    break;\n                default:\n                    return true;\n            }\n        },\n\n        /**\n         * Executes when the value of the search input field changes. Executes a GET request\n         * to populate a suggestion list based on entered text. Handles click (select), hover,\n         * and mouseout events on the populated suggestion list dropdown.\n         * @private\n         */\n        _onPropertyChange: function () {\n            var searchField = this.element,\n                clonePosition = {\n                    position: 'absolute',\n                    // Removed to fix display issues\n                    // left: searchField.offset().left,\n                    // top: searchField.offset().top + searchField.outerHeight(),\n                    width: searchField.outerWidth()\n                },\n                source = this.options.template,\n                template = mageTemplate(source),\n                dropdown = $('<ul role=\"listbox\"></ul>'),\n                value = this.element.val();\n\n            this.submitBtn.disabled = isEmpty(value);\n\n            if (value.length >= parseInt(this.options.minSearchLength, 10)) {\n                $.get(this.options.url, {q: value}, $.proxy(function (data) {\n                    $.each(data, function(index, element) {\n                        element.index = index;\n                        var html = template({\n                            data: element\n                        });\n                        dropdown.append(html);\n                    });\n                    this.responseList.indexList = this.autoComplete.html(dropdown)\n                        .css(clonePosition)\n                        .show()\n                        .find(this.options.responseFieldElements + ':visible');\n\n                    this._resetResponseList(false);\n                    this.element.removeAttr('aria-activedescendant');\n\n                    if (this.responseList.indexList.length) {\n                        this._updateAriaHasPopup(true);\n                    } else {\n                        this._updateAriaHasPopup(false);\n                    }\n\n                    this.responseList.indexList\n                        .on('click', function (e) {\n                            this.responseList.selected = $(e.currentTarget);\n                            this.searchForm.trigger('submit');\n                        }.bind(this))\n                        .on('mouseenter mouseleave', function (e) {\n                            this.responseList.indexList.removeClass(this.options.selectClass);\n                            $(e.target).addClass(this.options.selectClass);\n                            this.responseList.selected = $(e.target);\n                            this.element.attr('aria-activedescendant', $(e.target).attr('id'));\n                        }.bind(this))\n                        .on('mouseout', function (e) {\n                            if (!this._getLastElement() && this._getLastElement().hasClass(this.options.selectClass)) {\n                                $(e.target).removeClass(this.options.selectClass);\n                                this._resetResponseList(false);\n                            }\n                        }.bind(this));\n                }, this));\n            } else {\n                this._resetResponseList(true);\n                this.autoComplete.hide();\n                this._updateAriaHasPopup(false);\n                this.element.removeAttr('aria-activedescendant');\n            }\n        }\n    });\n\n    return $.mage.quickSearch;\n});\n","Magento_Paypal/order-review.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    \"jquery/ui\",\n    \"mage/translate\",\n    \"mage/mage\",\n    \"mage/validation\"\n], function($, alert){\n    \"use strict\";\n\n    $.widget('mage.orderReview', {\n        options: {\n            orderReviewSubmitSelector: '#review-button',\n            shippingSelector: '#shipping_method',\n            shippingSubmitFormSelector: null,\n            updateOrderSelector: '#update-order',\n            billingAsShippingSelector: '#billing\\\\:as_shipping',\n            updateContainerSelector: '#details-reload',\n            waitLoadingContainer: '#review-please-wait',\n            shippingMethodContainer: '#shipping-method-container',\n            agreementSelector: 'div.checkout-agreements input',\n            isAjax: false,\n            updateShippingMethodSubmitSelector: \"#update-shipping-method-submit\",\n            reviewSubmitSelector: \"#review-submit\",\n            shippingMethodUpdateUrl: null,\n            updateOrderSubmitUrl: null,\n            canEditShippingMethod: false\n        },\n\n        /**\n         * Widget instance properties\n         */\n        triggerPropertyChange: true,\n        isShippingSubmitForm: false,\n\n        _create: function () {\n            //change handler for ajaxEnabled\n            if (this.options.isAjax) {\n                this._submitOrder = this._ajaxSubmitOrder;\n            }\n\n            this.element.on('click', this.options.orderReviewSubmitSelector, $.proxy(this._submitOrder, this))\n                .on('click', this.options.billingAsShippingSelector, $.proxy(this._shippingTobilling, this))\n                .on('change', this.options.shippingSelector, $.proxy(this._submitUpdateOrder, this, this.options.updateOrderSubmitUrl, this.options.updateContainerSelector))\n                .find(this.options.updateOrderSelector).on('click', $.proxy(this._updateOrderHandler, this)).end()\n                .find(this.options.updateShippingMethodSubmitSelector).hide().end()\n                .find(this.options.reviewSubmitSelector).hide();\n            this._shippingTobilling();\n            if ($(this.options.shippingSubmitFormSelector).length && this.options.canEditShippingMethod) {\n                this.isShippingSubmitForm = true;\n                $(this.options.shippingSubmitFormSelector).find(this.options.updateShippingMethodSubmitSelector).hide().end()\n                    .on('change',\n                        this.options.shippingSelector, $.proxy(this._submitUpdateOrder, this, $(this.options.shippingSubmitFormSelector).prop('action'), this.options.updateContainerSelector));\n                this._updateOrderSubmit(!$(this.options.shippingSubmitFormSelector).find(this.options.shippingSelector).val());\n            } else {\n                var isDisable = (this.isShippingSubmitForm && this.element.find(this.options.shippingSelector).val());\n                this.element.on('input propertychange', \":input[name]\", $.proxy(this._updateOrderSubmit, this, isDisable, this._onShippingChange))\n                    .find('select').not(this.options.shippingSelector).on('change', this._propertyChange);\n                this._updateOrderSubmit(isDisable);\n            }\n        },\n\n        /**\n         * show ajax loader\n         */\n        _ajaxBeforeSend: function () {\n            this.element.find(this.options.waitLoadingContainer).show();\n        },\n\n        /**\n         * hide ajax loader\n         */\n        _ajaxComplete: function () {\n            this.element.find(this.options.waitLoadingContainer).hide();\n        },\n\n        /**\n         * trigger propertychange for input type select\n         */\n        _propertyChange: function () {\n            $(this).trigger('propertychange');\n        },\n\n        /**\n         * trigger change for the update of shippping methods from server\n         */\n        _updateOrderHandler: function () {\n            $(this.options.shippingSelector).trigger('change');\n        },\n\n        /**\n         * Attempt to submit order\n         */\n        _submitOrder: function () {\n            if (this._validateForm()) {\n                this.element.find(this.options.updateOrderSelector).fadeTo(0, 0.5)\n                    .end().find(this.options.waitLoadingContainer).show()\n                    .end().submit();\n                this._updateOrderSubmit(true);\n            }\n        },\n\n        /**\n         * Attempt to ajax submit order\n         */\n        _ajaxSubmitOrder: function () {\n            if (this.element.find(this.options.waitLoadingContainer).is(\":visible\")) {\n                return false;\n            }\n            $.ajax({\n                url: this.element.prop('action'),\n                type: 'post',\n                context: this,\n                data: {isAjax: 1},\n                dataType: 'json',\n                beforeSend: this._ajaxBeforeSend,\n                complete: this._ajaxComplete,\n                success: function (response) {\n                    if ($.type(response) === 'object' && !$.isEmptyObject(response)) {\n                        if (response.error_messages) {\n                            this._ajaxComplete();\n                            var msg = response.error_messages;\n                            if (msg) {\n                                if ($.type(msg) === 'array') {\n                                    msg = msg.join(\"\\n\");\n                                }\n                            }\n                            alert({\n                                content: $.mage.__(msg)\n                            });\n                            return false;\n                        }\n                        if (response.redirect) {\n                            $.mage.redirect(response.redirect);\n                            return false;\n                        }\n                        else if (response.success) {\n                            $.mage.redirect(this.options.successUrl);\n                            return false;\n                        }\n                        this._ajaxComplete();\n                        alert({\n                            content: $.mage.__('Sorry, something went wrong.')\n                        });\n                    }\n                },\n                error: function () {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    this._ajaxComplete();\n                }\n            });\n        },\n\n        /**\n         * Validate Order form\n         */\n        _validateForm: function () {\n            this.element.find(this.options.agreementSelector).off('change').on('change', $.proxy(function (e) {\n                var isValid = this._validateForm();\n                this._updateOrderSubmit(!isValid);\n            }, this));\n\n            if (this.element.data('mageValidation')) {\n                return this.element.validation().valid();\n            }\n            return true;\n        },\n\n        /**\n         * Check/Set whether order can be submitted\n         * Also disables form submission element, if any\n         * @param shouldDisable - whether should prevent order submission explicitly\n         * @param optional function for shipping change handler\n         * @param optional if true the property change will be set to true\n         */\n        _updateOrderSubmit: function (shouldDisable, fn) {\n            this._toggleButton(this.options.orderReviewSubmitSelector, shouldDisable);\n            if ($.type(fn) === 'function') {\n                fn.call(this);\n            }\n        },\n\n        /**\n         * Enable/Disable button\n         * @param button button selector to be toggled\n         * @param disable  boolean for toggling\n         */\n        _toggleButton: function (button, disable) {\n            $(button).prop({\"disabled\": disable}).toggleClass('no-checkout', disable).fadeTo(0, disable ? 0.5 : 1);\n        },\n\n        /**\n         * Copy element value from shipping to billing address\n         * @param e optional\n         */\n        _shippingTobilling: function (e) {\n            if (this.options.shippingSubmitFormSelector) {\n                return false;\n            }\n            var isChecked = $(this.options.billingAsShippingSelector).is(':checked'),\n                opacity = isChecked ? 0.5 : 1;\n            if (isChecked) {\n                this.element.validation(\"clearError\", ':input[name^=\"billing\"]');\n            }\n            $(':input[name^=\"shipping\"]', this.element).each($.proxy(function (key, value) {\n                var fieldObj = $(value.id.replace('shipping:', '#billing\\\\:'));\n                if (isChecked) {\n                    fieldObj = fieldObj.val($(value).val());\n                }\n                fieldObj.prop({\"readonly\": isChecked, \"disabled\": isChecked}).fadeTo(0, opacity);\n                if (fieldObj.is(\"select\")) {\n                    this.triggerPropertyChange = false;\n                    fieldObj.trigger('change');\n                }\n            }, this));\n            if (isChecked || e) {\n                this._updateOrderSubmit(true);\n            }\n            this.triggerPropertyChange = true;\n        },\n\n        /**\n         * Dispatch an ajax request of Update Order submission\n         * @param url - url where to submit shipping method\n         * @param resultId - id of element to be updated\n         */\n        _submitUpdateOrder: function (url, resultId) {\n            if (this.element.find(this.options.waitLoadingContainer).is(\":visible\")) {\n                return false;\n            }\n            var isChecked = $(this.options.billingAsShippingSelector).is(':checked'),\n                formData = null,\n                callBackResponseHandler = null,\n                shippingMethod = $.trim($(this.options.shippingSelector).val());\n            this._shippingTobilling();\n\n            if (url && resultId && shippingMethod) {\n                this._updateOrderSubmit(true);\n                this._toggleButton(this.options.updateOrderSelector, true);\n\n                // form data and callBack updated based on the shippping Form element\n                if (this.isShippingSubmitForm) {\n                    formData = $(this.options.shippingSubmitFormSelector).serialize() + \"&isAjax=true\";\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._updateOrderSubmit(false);\n                        this._ajaxComplete();\n                    };\n                } else {\n                    formData = this.element.serialize() + \"&isAjax=true\";\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._ajaxShippingUpdate(shippingMethod);\n                    };\n                }\n                if (isChecked) {\n                    $(this.options.shippingSelect).prop('disabled', true);\n                }\n                $.ajax({\n                    url: url,\n                    type: 'post',\n                    context: this,\n                    beforeSend: this._ajaxBeforeSend,\n                    data: formData,\n                    success: callBackResponseHandler\n                });\n            }\n        },\n\n        /**\n         * Update Shipping Methods Element from server\n         * @param shippingMethod\n         */\n        _ajaxShippingUpdate: function (shippingMethod) {\n            $.ajax({\n                    url: this.options.shippingMethodUpdateUrl,\n                    data: {isAjax: true, shipping_method: shippingMethod},\n                    type: 'post',\n                    context: this,\n                    success: function (response) {\n                        $(this.options.shippingMethodContainer).parent().html(response);\n                        this._toggleButton(this.options.updateOrderSelector, false);\n                        this._updateOrderSubmit(false);\n                    },\n                    complete: this._ajaxComplete\n                }\n            );\n        },\n\n        /**\n         * Actions on change Shipping Address data\n         */\n        _onShippingChange: function () {\n            if (this.triggerPropertyChange && $.trim($(this.options.shippingSelector).val())) {\n                this.element.find(this.options.shippingSelector).hide().end()\n                    .find(this.options.shippingSelector + '_update').show();\n            }\n        }\n    });\n    \n    return $.mage.orderReview;\n});\n","Magento_Paypal/js/paypal-checkout.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'jquery/ui',\n    'mage/mage'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.paypalCheckout', {\n        options: {\n            originalForm:\n                'form:not(#product_addtocart_form_from_popup):has(input[name=\"product\"][value=%1])',\n            productId: 'input[type=\"hidden\"][name=\"product\"]',\n            ppCheckoutSelector: '[data-role=pp-checkout-url]',\n            ppCheckoutInput: '<input type=\"hidden\" data-role=\"pp-checkout-url\" name=\"return_url\" value=\"\"/>'\n        },\n\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', '[data-action=\"checkout-form-submit\"]', $.proxy(function (e) {\n                var $target = $(e.target),\n                    returnUrl = $target.data('checkout-url'),\n                    productId = $target.closest('form').find(this.options.productId).val(),\n                    originalForm = this.options.originalForm.replace('%1', productId),\n                    self = this,\n                    billingAgreement = customerData.get('paypal-billing-agreement');\n\n                e.preventDefault();\n\n                if (billingAgreement().askToCreate) {\n                    confirm({\n                        content: billingAgreement().confirmMessage,\n                        actions: {\n\n                            /**\n                             * Confirmation handler\n                             *\n                             */\n                            confirm: function () {\n                                returnUrl = billingAgreement().confirmUrl;\n                                self._redirect(returnUrl, originalForm);\n                            },\n\n                            /**\n                             * Cancel confirmation handler\n                             *\n                             */\n                            cancel: function (event) {\n                                if (event && !$(event.target).hasClass('action-close')) {\n                                    self._redirect(returnUrl);\n                                }\n                            }\n                        }\n                    });\n                } else {\n                    this._redirect(returnUrl, originalForm);\n                }\n            }, this));\n        },\n\n        /**\n         * Redirect to certain url, with optional form\n         * @param {String} returnUrl\n         * @param {HTMLElement} originalForm\n         *\n         */\n        _redirect: function (returnUrl, originalForm) {\n            var $form,\n                ppCheckoutInput;\n\n            if (this.options.isCatalogProduct) {\n                // find the form from which the button was clicked\n                $form = originalForm ? $(originalForm) : $($(this.options.shortcutContainerClass).closest('form'));\n\n                ppCheckoutInput = $form.find(this.options.ppCheckoutSelector)[0];\n\n                if (!ppCheckoutInput) {\n                    ppCheckoutInput = $(this.options.ppCheckoutInput);\n                    ppCheckoutInput.appendTo($form);\n                }\n                $(ppCheckoutInput).val(returnUrl);\n\n                $form.submit();\n            } else {\n                $.mage.redirect(returnUrl);\n            }\n        }\n    });\n\n    return $.mage.paypalCheckout;\n});\n","Magento_Paypal/js/action/set-payment-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function ($, quote, urlBuilder, storage, errorProcessor, customer, fullScreenLoader) {\n        'use strict';\n\n        return function (messageContainer) {\n            var serviceUrl,\n                payload,\n                method = 'put',\n                paymentData = quote.paymentMethod();\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    email: quote.guestEmail,\n                    paymentMethod: paymentData\n                };\n                method = 'post';\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/selected-payment-method', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    method: paymentData\n                };\n            }\n            fullScreenLoader.startLoader();\n\n            return storage[method](\n                serviceUrl, JSON.stringify(payload)\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Paypal/js/in-context/billing-agreement.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.billingAgreement', {\n        options: {\n            invalidateOnLoad: false,\n            cancelButtonSelector: '.block-billing-agreements-view button.cancel',\n            cancelMessage: '',\n            cancelUrl: ''\n        },\n\n        /**\n         * Initialize billing agreements events\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            if (this.options.invalidateOnLoad) {\n                this.invalidate();\n            }\n            $(this.options.cancelButtonSelector).on('click', function () {\n                confirm({\n                    content: self.options.cancelMessage,\n                    actions: {\n                        /**\n                         * 'Confirm' action handler.\n                         */\n                        confirm: function () {\n                            self.invalidate();\n                            window.location.href = self.options.cancelUrl;\n                        }\n                    }\n                });\n\n                return false;\n            });\n        },\n\n        /**\n         * clear paypal billing agreement customer data\n         * @returns void\n         */\n        invalidate: function () {\n            customerData.invalidate(['paypal-billing-agreement']);\n        }\n    });\n\n    return $.mage.billingAgreement;\n});\n","Magento_Paypal/js/in-context/button.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'jquery',\n        'domReady!'\n    ],\n    function (\n        Component,\n        $\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {},\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                return this.initEvents();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initEvents: function () {\n                $('#' + this.id).off('click.' + this.id)\n                    .on('click.' + this.id, this.click.bind(this));\n\n                return this;\n            },\n\n            /**\n             * @param {Object} event\n             * @returns void\n             */\n            click: function (event) {\n                event.preventDefault();\n\n                $('#' + this.paypalButton).click();\n            }\n        });\n    }\n);\n","Magento_Paypal/js/in-context/express-checkout.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'uiComponent',\n        'paypalInContextExpressCheckout',\n        'Magento_Customer/js/customer-data',\n        'domReady!'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        paypalExpressCheckout,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                clientConfig: {\n\n                    /**\n                     * @param {Object} event\n                     */\n                    click: function (event) {\n                        $('body').trigger('processStart');\n\n                        event.preventDefault();\n\n                        paypalExpressCheckout.checkout.initXO();\n\n                        $.get(\n                            this.path,\n                            {\n                                button: 1\n                            }\n                        ).done(\n                            function (response) {\n                                if (response && response.url) {\n                                    paypalExpressCheckout.checkout.startFlow(response.url);\n\n                                    return;\n                                }\n\n                                paypalExpressCheckout.checkout.closeFlow();\n                            }\n                        ).fail(\n                            function () {\n                                $('body').trigger('processStop');\n                                paypalExpressCheckout.checkout.closeFlow();\n                            }\n                        ).always(\n                            function () {\n                                customerData.invalidate(['cart']);\n                            }\n                        );\n                    }\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                return this.initClient();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initClient: function () {\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n\n                paypalExpressCheckout.checkout.setup(this.merchantId, this.clientConfig);\n\n                return this;\n            }\n        });\n    }\n);\n","Magento_Paypal/js/model/iframe-redirect.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko',\n        'Magento_Paypal/js/model/iframe',\n        'Magento_Ui/js/model/messageList'\n    ],\n    function (ko, iframe, messageList) {\n        'use strict';\n\n        return function (cartUrl, errorMessage, goToSuccessPage, successUrl) {\n            if (this === window.self) {\n                window.location = cartUrl;\n            }\n\n            if (!!errorMessage.message) {\n                document.removeEventListener('click', iframe.stopEventPropagation, true);\n                iframe.isInAction(false);\n                messageList.addErrorMessage(errorMessage);\n            } else if (!!goToSuccessPage) {\n                window.location = successUrl;\n            } else {\n                window.location = cartUrl;\n            }\n        };\n    }\n);\n","Magento_Paypal/js/model/iframe.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'ko'\n    ],\n    function (ko) {\n        'use strict';\n\n        var isInAction = ko.observable(false);\n\n        return {\n            isInAction: isInAction,\n            stopEventPropagation: function (event) {\n                event.stopImmediatePropagation();\n                event.preventDefault();\n            }\n        };\n    }\n);\n","Magento_Paypal/js/view/payment/paypal-payments.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        var isContextCheckout = window.checkoutConfig.payment.paypalExpress.isContextCheckout,\n            paypalExpress = 'Magento_Paypal/js/view/payment/method-renderer' +\n                (isContextCheckout ? '/in-context/checkout-express' : '/paypal-express');\n\n        rendererList.push(\n            {\n                type: 'paypal_express',\n                component: paypalExpress,\n                config: window.checkoutConfig.payment.paypalExpress.inContextConfig\n            },\n            {\n                type: 'paypal_express_bml',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/paypal-express-bml'\n            },\n            {\n                type: 'payflow_express',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express'\n            },\n            {\n                type: 'payflow_express_bml',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml'\n            },\n            {\n                type: 'payflowpro',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method'\n            },\n            {\n                type: 'payflow_link',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n            },\n            {\n                type: 'payflow_advanced',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n            },\n            {\n                type: 'hosted_pro',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n            },\n            {\n                type: 'paypal_billing_agreement',\n                component: 'Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement'\n            }\n        );\n\n        /**\n         * Add view logic here if needed\n         **/\n        return Component.extend({});\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/iframe-methods.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'Magento_Paypal/js/model/iframe',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (Component, ko, iframe, fullScreenLoader) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/iframe-methods',\n                paymentReady: false\n            },\n            redirectAfterPlaceOrder: false,\n            isInAction: iframe.isInAction,\n\n            /**\n             * @return {exports}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe('paymentReady');\n\n                return this;\n            },\n\n            /**\n             * @return {*}\n             */\n            isPaymentReady: function () {\n                return this.paymentReady();\n            },\n\n            /**\n             * Get action url for payment method iframe.\n             * @returns {String}\n             */\n            getActionUrl: function () {\n                return this.isInAction() ? window.checkoutConfig.payment.paypalIframe.actionUrl[this.getCode()] : '';\n            },\n\n            /**\n             * Places order in pending payment status.\n             */\n            placePendingPaymentOrder: function () {\n                if (this.placeOrder()) {\n                    fullScreenLoader.startLoader();\n                    this.isInAction(true);\n                    // capture all click events\n                    document.addEventListener('click', iframe.stopEventPropagation, true);\n                }\n            },\n\n            getPlaceOrderDeferredObject: function () {\n                var self = this;\n                return this._super()\n                    .fail(\n                        function () {\n                            fullScreenLoader.stopLoader();\n                            self.isInAction(false);\n                            document.removeEventListener('click', iframe.stopEventPropagation, true);\n                        }\n                    );\n            },\n\n            /**\n             * After place order callback\n             */\n            afterPlaceOrder: function () {\n                if (this.iframeIsLoaded) {\n                    document.getElementById(this.getCode() + '-iframe')\n                        .contentWindow.location.reload();\n                }\n\n                this.paymentReady(true);\n                this.iframeIsLoaded = true;\n                this.isPlaceOrderActionAllowed(true);\n                fullScreenLoader.stopLoader();\n            },\n\n            /**\n             * Hide loader when iframe is fully loaded.\n             */\n            iframeLoaded: function () {\n                fullScreenLoader.stopLoader();\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/payflow-express-bml'\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/payflow-express'\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro-method.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Payment/js/view/payment/iframe',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/action/set-payment-information',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Vault/js/view/payment/vault-enabler'\n    ],\n    function ($, Component, additionalValidators, setPaymentInformationAction, fullScreenLoader, VaultEnabler) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/payflowpro-form'\n            },\n            placeOrderHandler: null,\n            validateHandler: null,\n\n            /**\n             * @returns {exports.initialize}\n             */\n            initialize: function () {\n                this._super();\n                this.vaultEnabler = new VaultEnabler();\n                this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n                return this;\n            },\n\n            /**\n             * @param {Function} handler\n             */\n            setPlaceOrderHandler: function(handler) {\n                this.placeOrderHandler = handler;\n            },\n\n            /**\n             * @param {Function} handler\n             */\n            setValidateHandler: function (handler) {\n                this.validateHandler = handler;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            context: function () {\n                return this;\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isShowLegend: function () {\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return 'payflowpro';\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                return true;\n            },\n\n            /**\n             * @override\n             */\n            placeOrder: function () {\n                var self = this;\n\n                if (this.validateHandler() && additionalValidators.validate()) {\n                    this.isPlaceOrderActionAllowed(false);\n                    fullScreenLoader.startLoader();\n                    $.when(\n                        setPaymentInformationAction(this.messageContainer, self.getData())\n                    ).done(\n                        function () {\n                            self.placeOrderHandler().fail(\n                                function () {\n                                    fullScreenLoader.stopLoader();\n                                }\n                            );\n                        }\n                    ).always(\n                        function () {\n                            self.isPlaceOrderActionAllowed(true);\n                            fullScreenLoader.stopLoader();\n                        }\n                    );\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            getData: function () {\n                var data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'cc_type': this.creditCardType(),\n                        'cc_exp_year': this.creditCardExpYear(),\n                        'cc_exp_month': this.creditCardExpMonth(),\n                        'cc_last_4': this.creditCardNumber().substr(-4)\n                    }\n                };\n\n                this.vaultEnabler.visitAdditionalData(data);\n\n                return data;\n            },\n\n            /**\n             * @returns {Bool}\n             */\n            isVaultEnabled: function () {\n                return this.vaultEnabler.isVaultEnabled();\n            },\n\n            /**\n             * @returns {String}\n             */\n            getVaultCode: function () {\n                return 'payflowpro_cc_vault';\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/payment/default',\n        \"mage/validation\"\n    ],\n    function ($, Component) {\n        'use strict';\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal_billing_agreement-form',\n                selectedBillingAgreement: ''\n            },\n            initObservable: function () {\n                this._super()\n                    .observe('selectedBillingAgreement');\n                return this;\n            },\n            getTransportName: function() {\n                return window.checkoutConfig.payment.paypalBillingAgreement.transportName;\n            },\n            getBillingAgreements: function() {\n                return window.checkoutConfig.payment.paypalBillingAgreement.agreements;\n            },\n            getData: function() {\n\n                var additionalData = null;\n                if (this.getTransportName()) {\n                    additionalData = {};\n                    additionalData[this.getTransportName()] = this.selectedBillingAgreement();\n                }\n                return {'method': this.item.method, 'additional_data': additionalData};\n            },\n            validate: function() {\n                var form = '#billing-agreement-form';\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Paypal/js/action/set-payment-method',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (\n        $,\n        Component,\n        setPaymentMethodAction,\n        additionalValidators,\n        quote,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express-bml',\n                billingAgreement: ''\n            },\n\n            /** Init observable variables */\n            initObservable: function () {\n                this._super()\n                    .observe('billingAgreement');\n\n                return this;\n            },\n\n            /** Open window with  */\n            showAcceptanceWindow: function (data, event) {\n                window.open(\n                    $(event.target).attr('href'),\n                    'olcwhatispaypal',\n                    'toolbar=no, location=no,' +\n                    ' directories=no, status=no,' +\n                    ' menubar=no, scrollbars=yes,' +\n                    ' resizable=yes, ,left=0,' +\n                    ' top=0, width=400, height=350'\n                );\n\n                return false;\n            },\n\n            /** Returns payment acceptance mark link path */\n            getPaymentAcceptanceMarkHref: function () {\n                return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkHref;\n            },\n\n            /** Returns payment acceptance mark image path */\n            getPaymentAcceptanceMarkSrc: function () {\n                return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkSrc;\n            },\n\n            /** Returns billing agreement data */\n            getBillingAgreementCode: function () {\n                return window.checkoutConfig.payment.paypalExpress.billingAgreementCode[this.item.method];\n            },\n\n            /** Returns payment information data */\n            getData: function () {\n                var parent = this._super(),\n                    additionalData = null;\n\n                if (this.getBillingAgreementCode()) {\n                    additionalData = {};\n                    additionalData[this.getBillingAgreementCode()] = this.billingAgreement();\n                }\n\n                return $.extend(true, parent, {\n                    'additional_data': additionalData\n                });\n            },\n\n            /** Redirect to paypal */\n            continueToPayPal: function () {\n                if (additionalValidators.validate()) {\n                    //update payment method information if additional data was changed\n                    this.selectPaymentMethod();\n                    setPaymentMethodAction(this.messageContainer).done(\n                        function () {\n                            customerData.invalidate(['cart']);\n                            $.mage.redirect(\n                                window.checkoutConfig.payment.paypalExpress.redirectUrl[quote.paymentMethod().method]\n                            );\n                        }\n                    );\n\n                    return false;\n                }\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express-bml.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express-bml'\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express'\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/in-context/checkout-express.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract',\n        'Magento_Paypal/js/action/set-payment-method',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Ui/js/lib/view/utils/dom-observer',\n        'paypalInContextExpressCheckout',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        setPaymentMethodAction,\n        additionalValidators,\n        domObserver,\n        paypalExpressCheckout,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express-in-context',\n                clientConfig: {\n\n                    /**\n                     * @param {Object} event\n                     */\n                    click: function (event) {\n                        event.preventDefault();\n\n                        if (additionalValidators.validate()) {\n                            paypalExpressCheckout.checkout.initXO();\n                            this.selectPaymentMethod();\n                            setPaymentMethodAction(this.messageContainer).done(\n                                function () {\n                                    $('body').trigger('processStart');\n\n                                    $.get(\n                                        this.path,\n                                        {\n                                            button: 0\n                                        }\n                                    ).done(\n                                        function (response) {\n                                            if (response && response.url) {\n                                                paypalExpressCheckout.checkout.startFlow(response.url);\n\n                                                return;\n                                            }\n\n                                            paypalExpressCheckout.checkout.closeFlow();\n                                            window.location.reload();\n                                        }\n                                    ).fail(\n                                        function () {\n                                            paypalExpressCheckout.checkout.closeFlow();\n                                            window.location.reload();\n                                        }\n                                    ).always(\n                                        function () {\n                                            $('body').trigger('processStop');\n                                            customerData.invalidate(['cart']);\n                                        }\n                                    );\n\n                                }.bind(this)\n                            );\n                        }\n                    }\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n                this.initClient();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initClient: function () {\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n\n                domObserver.get('#' + this.getButtonId(), function () {\n                    paypalExpressCheckout.checkout.setup(this.merchantId, this.clientConfig);\n                }.bind(this));\n\n                return this;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getButtonId: function () {\n                return this.inContextId;\n            }\n        });\n    }\n);\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro/vault.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'Magento_Vault/js/view/payment/method-renderer/vault'\n], function ($, VaultComponent) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Vault/payment/form'\n        },\n\n        /**\n         * @returns {String}\n         */\n        getToken: function () {\n            return this.publicHash;\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details['cc_last_4'];\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details['cc_exp_month'] + '/' + this.details['cc_exp_year'];\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details['cc_type'];\n        }\n    });\n});\n","Magento_Paypal/js/view/review/actions/iframe.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'ko',\n        'Magento_Paypal/js/model/iframe'\n    ],\n    function (Component, ko, iframe) {\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Paypal/review/actions/iframe'\n            },\n            getCode: function() {\n                return this.index;\n            },\n            getActionUrl: function() {\n                return this.isInAction() ? window.checkoutConfig.payment.paypalIframe.actionUrl[this.getCode()] : '';\n            },\n            afterSave: function() {\n                iframe.setIsInAction(true);\n                return false;\n            },\n            isInAction: function() {\n                return iframe.getIsInAction()();\n            },\n            placeOrder: function(context) {\n                return context.placeOrder.bind(context, this.afterSave);\n            }\n        });\n    }\n);\n","Magento_Bundle/js/price-bundle.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        optionConfig: null,\n        productBundleSelector: 'input.bundle.option, select.bundle.option, textarea.bundle.option',\n        qtyFieldSelector: 'input.qty',\n        priceBoxSelector: '.price-box',\n        optionHandlers: {},\n        optionTemplate: '<%- data.label %>' +\n        '<% if (data.finalPrice.value) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd', // should be eliminated\n        priceFormat: {},\n        isFixedPrice: false\n    };\n\n    $.widget('mage.priceBundle', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form);\n\n            options.trigger('change');\n        },\n\n        /**\n         * @private\n         */\n        _create: function createPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                priceBox = $(this.options.priceBoxSelector, form),\n                qty = $(this.options.qtyFieldSelector, form);\n\n            if (priceBox.data('magePriceBox') && priceBox.priceBox('option') && priceBox.priceBox('option').priceConfig) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n                priceBox.priceBox('setDefault', this.options.optionConfig.prices);\n            }\n            this._applyQtyFix();\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onBundleOptionChanged.bind(this));\n            qty.on('change', this._onQtyFieldChanged.bind(this));\n        },\n\n        /**\n         * Handle change on bundle option inputs\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onBundleOptionChanged: function onBundleOptionChanged(event) {\n            var changes,\n                bundleOption = $(event.target),\n                priceBox = $(this.options.priceBoxSelector, this.element),\n                handler = this.options.optionHandlers[bundleOption.data('role')];\n\n            bundleOption.data('optionContainer', bundleOption.closest(this.options.controlContainer));\n            bundleOption.data('qtyField', bundleOption.data('optionContainer').find(this.options.qtyFieldSelector));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(bundleOption, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(bundleOption, this.options.optionConfig);\n            }\n\n            if (changes) {\n                priceBox.trigger('updatePrice', changes);\n            }\n            this.updateProductSummary();\n        },\n\n        /**\n         * Handle change on qty inputs near bundle option\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyFieldChanged: function onQtyFieldChanged(event) {\n            var field = $(event.target),\n                optionInstance,\n                optionConfig;\n\n            if (field.data('optionId') && field.data('optionValueId')) {\n                optionInstance = field.data('option');\n                optionConfig = this.options.optionConfig\n                    .options[field.data('optionId')]\n                    .selections[field.data('optionValueId')];\n                optionConfig.qty = field.val();\n\n                optionInstance.trigger('change');\n            }\n        },\n\n        /**\n         * Helper to fix backend behavior:\n         *  - if default qty large than 1 then backend multiply price in config\n         *\n         * @private\n         */\n        _applyQtyFix: function applyQtyFix() {\n            var config = this.options.optionConfig;\n            if (config.isFixedPrice) {\n                _.each(config.options, function (option) {\n                    _.each(option.selections, function (item) {\n                        if (item.qty && item.qty !== 1) {\n                            _.each(item.prices, function (price) {\n                                price.amount = price.amount / item.qty;\n                            });\n                        }\n                    });\n                });\n            }\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionName = $element.prop('name'),\n                    optionType = $element.prop('type'),\n                    optionConfig = config.optionConfig && config.optionConfig.options[optionId].selections;\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue].prices;\n\n                    _.each(prices, function (price, type) {\n                        var value = +(price.amount);\n                        value += _.reduce(price.adjustments, function (sum, x) {\n                            return sum + x;\n                        }, 0);\n                        toTemplate.data[type] = {\n                            value: value,\n                            formatted: utils.formatPrice(value, format)\n                        };\n                    });\n\n                    $option.html(template(toTemplate));\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            this._super(options);\n\n            return this;\n        },\n\n        /**\n         * Handler to update productSummary box\n         */\n        updateProductSummary: function updateProductSummary() {\n            this.element.trigger('updateProductSummary', {\n                config: this.options.optionConfig\n            });\n        }\n    });\n\n    return $.mage.priceBundle;\n\n    /**\n     * Converts option value to priceBox object\n     *\n     * @param   {jQuery} element\n     * @param   {Object} config\n     * @returns {Object|null} - priceBox object with additional prices\n     */\n    function defaultGetOptionValue(element, config) {\n        var changes = {},\n            optionHash,\n            tempChanges,\n            qtyField,\n            optionId = utils.findOptionId(element[0]),\n            optionValue = element.val() || null,\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = config.options[optionId].selections,\n            optionQty = 0,\n            canQtyCustomize = false,\n            selectedIds = config.selected;\n\n        switch (optionType) {\n            case 'radio':\n\n            case 'select-one':\n\n                if (optionType === 'radio' && !element.is(':checked')) {\n                    return null;\n                }\n\n                qtyField = element.data('qtyField');\n                qtyField.data('option', element);\n\n                if (optionValue) {\n                    optionQty = optionConfig[optionValue].qty || 0;\n                    canQtyCustomize = optionConfig[optionValue].customQty === '1';\n                    toggleQtyField(qtyField, optionQty, optionId, optionValue, canQtyCustomize);\n                    tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                    tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig[optionValue]);\n                    tempChanges = applyQty(tempChanges, optionQty);\n                } else {\n                    tempChanges = {};\n                    toggleQtyField(qtyField, '0', optionId, optionValue, false);\n                }\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n\n            case 'select-multiple':\n                optionValue = _.compact(optionValue);\n\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = 'bundle-option-' + optionName + '##' + optionValueCode;\n                    optionQty = row.qty || 0;\n                    tempChanges = utils.deepClone(row.prices);\n                    tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);\n                    tempChanges = applyQty(tempChanges, optionQty);\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? tempChanges : {};\n                });\n\n                selectedIds[optionId] = optionValue || [];\n                break;\n\n            case 'checkbox':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);\n                tempChanges = applyQty(tempChanges, optionQty);\n                changes[optionHash] = element.is(':checked') ? tempChanges : {};\n\n                selectedIds[optionId] = selectedIds[optionId] || [];\n\n                if (!_.contains(selectedIds[optionId], optionValue) && element.is(':checked')) {\n                    selectedIds[optionId].push(optionValue);\n                } else if (!element.is(':checked')) {\n                    selectedIds[optionId] = _.without(selectedIds[optionId], optionValue);\n                }\n                break;\n\n            case 'hidden':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);\n                tempChanges = applyQty(tempChanges, optionQty);\n\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n        }\n\n        return changes;\n    }\n\n    /**\n     * Helper to toggle qty field\n     * @param {jQuery} element\n     * @param {String|Number} value\n     * @param {String|Number} optionId\n     * @param {String|Number} optionValueId\n     * @param {Boolean} canEdit\n     */\n    function toggleQtyField(element, value, optionId, optionValueId, canEdit) {\n        element\n            .val(value)\n            .data('optionId', optionId)\n            .data('optionValueId', optionValueId)\n            .attr('disabled', !canEdit);\n\n        if (canEdit) {\n            element.removeClass('qty-disabled');\n        } else {\n            element.addClass('qty-disabled');\n        }\n    }\n\n    /**\n     * Helper to multiply on qty\n     *\n     * @param   {Object} prices\n     * @param   {Number} qty\n     * @returns {Object}\n     */\n    function applyQty(prices, qty) {\n        _.each(prices, function (everyPrice) {\n            everyPrice.amount *= qty;\n            _.each(everyPrice.adjustments, function (el, index) {\n                everyPrice.adjustments[index] *= qty;\n            });\n        });\n\n        return prices;\n    }\n\n    /**\n     * Helper to limit price with tier price\n     *\n     * @param {Object} oneItemPrice\n     * @param {Number} qty\n     * @param {Object} optionConfig\n     * @returns {Object}\n     */\n    function applyTierPrice(oneItemPrice, qty, optionConfig) {\n        var tiers = optionConfig.tierPrice,\n            magicKey = _.keys(oneItemPrice)[0],\n            lowest = false;\n\n        _.each(tiers, function (tier, index) {\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if (tier.price_qty > qty) {\n                return;\n            }\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            if (tier.prices[magicKey].amount < oneItemPrice[magicKey].amount) {\n                lowest = index;\n            }\n        });\n\n        if (lowest !== false) {\n            oneItemPrice = utils.deepClone(tiers[lowest].prices);\n        }\n\n        return oneItemPrice;\n    }\n});\n","Magento_Bundle/js/float.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true expr:true*/\ndefine([\"jquery\",\"jquery/ui\"], function($){\n\n    $.widget('mage.float', {\n        options: {\n            productOptionsSelector: '#product-options-wrapper'\n        },\n\n        /**\n         * Bind handlers to scroll event\n         * @private\n         */\n        _create: function() {\n            $(window).on('scroll', $.proxy(this._setTop, this));\n        },\n\n        /**\n         * float bundleSummary on windowScroll\n         * @private\n         */\n        _setTop: function() {\n            if ((this.element).is(':visible')) {\n                var starTop = $(this.options.productOptionsSelector).offset().top,\n                    offset = $(document).scrollTop(),\n                    maxTop = this.element.parent().offset().top;\n                if (!this.options.top) {\n                    this.options.top = this.element.position().top;\n                    this.element.css('top', this.options.top);\n                }\n\n                if (starTop > offset) {\n                    return false;\n                }\n\n                if (offset < this.options.top) {\n                    offset = this.options.top;\n                }\n\n                var allowedTop = this.options.top + offset - starTop;\n\n                if (allowedTop < maxTop) {\n                    this.element.css('top', allowedTop);\n                }\n            }\n        }\n    });\n});","Magento_Bundle/js/product-summary.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'Magento_Bundle/js/price-bundle'\n], function ($, mageTemplate) {\n    'use strict';\n\n    /**\n     * Widget product Summary:\n     * Handles rendering of Bundle options and displays them in the Summary box\n     */\n    $.widget('mage.productSummary', {\n        options: {\n            mainContainer:          '#product_addtocart_form',\n            templates: {\n                summaryBlock:       '[data-template=\"bundle-summary\"]',\n                optionBlock:        '[data-template=\"bundle-option\"]'\n            },\n            optionSelector:         '[data-container=\"options\"]',\n            summaryContainer:       '[data-container=\"product-summary\"]',\n            bundleSummaryContainer: '.bundle-summary'\n        },\n        cache: {},\n        /**\n         * Method attaches event observer to the product form\n         * @private\n         */\n        _create: function () {\n            this.element\n                .closest(this.options.mainContainer)\n                .on('updateProductSummary', $.proxy(this._renderSummaryBox, this))\n                .priceBundle({})\n            ;\n        },\n        /**\n         * Method extracts data from the event and renders Summary box\n         * using jQuery template mechanism\n         * @param {Event} event\n         * @param {Object} data\n         * @private\n         */\n        _renderSummaryBox: function (event, data) {\n            this.cache.currentElement = data.config;\n            this.cache.currentElementCount = 0;\n\n            // Clear Summary box\n            this.element.html('');\n\n            $.each(this.cache.currentElement.selected, $.proxy(this._renderOption, this));\n            this.element\n                .parents(this.options.bundleSummaryContainer)\n                .toggleClass('empty', !this.cache.currentElementCount); // Zero elements equal '.empty' container\n        },\n\n        /**\n         * @param {String} key\n         * @param {String} row\n         * @private\n         */\n        _renderOption: function (key, row) {\n            var template;\n\n            if (row && row.length > 0 && row[0] !== null) {\n                template = this.element\n                    .closest(this.options.summaryContainer)\n                    .find(this.options.templates.summaryBlock)\n                    .html();\n                template = mageTemplate($.trim(template), {\n                    data: {\n                        _label_: this.cache.currentElement.options[key].title\n                    }\n                });\n\n                this.cache.currentKey = key;\n                this.cache.summaryContainer = $(template);\n                this.element.append(this.cache.summaryContainer);\n\n                $.each(row, this._renderOptionRow.bind(this));\n                this.cache.currentElementCount += row.length;\n\n                //Reset Cache\n                this.cache.currentKey = null;\n            }\n        },\n\n        /**\n         * @param {String} key\n         * @param {String} optionIndex\n         * @private\n         */\n        _renderOptionRow: function (key, optionIndex) {\n            var template;\n\n            template = this.element\n                .closest(this.options.summaryContainer)\n                .find(this.options.templates.optionBlock)\n                .html();\n            template = mageTemplate($.trim(template), {\n                data: {\n                    _quantity_: this.cache.currentElement.options[this.cache.currentKey].selections[optionIndex].qty,\n                    _label_: this.cache.currentElement.options[this.cache.currentKey].selections[optionIndex].name\n                }\n            });\n            this.cache.summaryContainer\n                .find(this.options.optionSelector)\n                .append(template);\n        }\n    });\n\n    return $.mage.productSummary;\n});\n","Magento_Bundle/js/slide.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true expr:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n\n    $.widget('mage.slide', {\n        options: {\n            slideSpeed: 1500,\n            slideSelector: '#bundle-slide',\n            slideBackSelector: '.bundle-slide-back',\n            bundleProductSelector: '#bundleProduct',\n            bundleOptionsContainer: '#options-container',\n            productViewContainer: '#productView',\n            slidedown: true\n\n        },\n\n        _create: function() {\n            if(this.options.slidedown === true) {\n                $(this.options.slideSelector).on('click', $.proxy(this._show, this));\n                $(this.options.slideBackSelector).on('click', $.proxy(this._hide, this));\n                this.options.autostart && this._show();\n            } else {\n                $(this.options.slideSelector).on('click', $.proxy(this._slide, this));\n                $(this.options.slideBackSelector).on('click', $.proxy(this._slideBack, this));\n                this.options.autostart && this._slide();\n            }\n        },\n\n        /**\n         * slide bundleOptionsContainer over to the main view area\n         * @private\n         */\n        _slide: function() {\n            $(this.options.bundleProductSelector).css('top', '0px');\n            $(this.options.bundleOptionsContainer).show();\n            this.element.css('height',$(this.options.productViewContainer).height() + 'px');\n            $(this.options.bundleProductSelector).css('left', '0px').animate(\n                {'left': '-' + this.element.width() + 'px'},\n                this.options.slideSpeed,\n                $.proxy(function() {\n                    this.element.css('height','auto');\n                    $(this.options.productViewContainer).hide();\n                }, this)\n            );\n        },\n\n        /**\n         * slideback productViewContainer to main view area\n         * @private\n         */\n        _slideBack: function() {\n            $(this.options.bundleProductSelector).css('top', '0px');\n            $(this.options.productViewContainer).show();\n            this.element.css('height', $(this.options.bundleOptionsContainer).height() + 'px');\n            $(this.options.bundleProductSelector).animate(\n                {'left': '0px'},\n                this.options.slideSpeed,\n                $.proxy(function() {\n                    $(this.options.bundleOptionsContainer).hide();\n                    this.element.css('height','auto');\n                }, this)\n            );\n        },\n        _show: function() {\n            $(this.options.bundleOptionsContainer).slideDown(800);\n            $('html, body').animate({\n                scrollTop: $(this.options.bundleOptionsContainer).offset().top\n            }, 600);\n            $('#product-options-wrapper > fieldset').focus();\n        },\n        _hide: function() {\n            $('html, body').animate({\n                scrollTop: 0\n            }, 600);\n            $(this.options.bundleOptionsContainer).slideUp(800);\n        }\n    });\n    \n    return $.mage.slide;\n});","Magento_Translation/add-class.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n'use strict';\n\n(function () {\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Weee/tax-toggle.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    function onToggle(config, e) {\n        var elem = $(e.currentTarget),\n            expandedClassName = config.expandedClassName || 'cart-tax-total-expanded';\n\n        elem.toggleClass(expandedClassName);\n\n        $(config.itemTaxId).toggle();\n    }\n\n    return function (data, el) {\n        $(el).on('click', onToggle.bind(null, data));\n    };\n});\n","Magento_Weee/js/view/cart/totals/weee.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Weee/js/view/checkout/summary/weee'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * @override\n             */\n            isFullMode: function () {\n                return true;\n            }\n        });\n    }\n);\n","Magento_Weee/js/view/checkout/summary/weee.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/totals',\n        'Magento_Catalog/js/price-utils'\n    ],\n    function (Component, quote, totals) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Weee/checkout/summary/weee'\n            },\n            isIncludedInSubtotal: window.checkoutConfig.isIncludedInSubtotal,\n            totals: totals.totals,\n\n            /**\n             * @returns {Number}\n             */\n            getWeeeTaxSegment: function () {\n                var weee = totals.getSegment('weee_tax') || totals.getSegment('weee');\n\n                if (weee !== null && weee.hasOwnProperty('value')) {\n                    return weee.value;\n                }\n\n                return 0;\n            },\n\n            /**\n             * Get weee value\n             * @returns {String}\n             */\n            getValue: function () {\n                return this.getFormattedPrice(this.getWeeeTaxSegment());\n            },\n\n            /**\n             * Weee display flag\n             * @returns {Boolean}\n             */\n            isDisplayed: function () {\n                return this.isFullMode() && this.getWeeeTaxSegment() > 0;\n            }\n        });\n    }\n);\n","Magento_Weee/js/view/checkout/summary/item/price/row_excl_tax.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Weee/js/view/checkout/summary/item/price/weee'\n    ],\n    function (weee) {\n        \"use strict\";\n        return weee.extend({\n            defaults: {\n                template: 'Magento_Weee/checkout/summary/item/price/row_excl_tax'\n            },\n\n            getFinalRowDisplayPriceExclTax: function(item) {\n                var rowTotalExclTax = parseFloat(item.row_total);\n                if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                    rowTotalExclTax += parseFloat(item.weee_tax_applied_amount);\n                }\n                return rowTotalExclTax;\n            },\n\n            getRowDisplayPriceExclTax: function(item) {\n                var rowTotalExclTax = parseFloat(item.row_total);\n                if (window.checkoutConfig.getIncludeWeeeFlag) {\n                    rowTotalExclTax += this.getRowWeeeTaxExclTax(item);\n                }\n                return rowTotalExclTax;\n            },\n\n            getRowWeeeTaxExclTax: function(item) {\n                var totalWeeeTaxExclTaxApplied = 0;\n                if (item.weee_tax_applied) {\n                    var weeeTaxAppliedAmounts = JSON.parse(item.weee_tax_applied);\n                    weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                        totalWeeeTaxExclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount.row_amount, 0));\n                    });\n                }\n                return totalWeeeTaxExclTaxApplied;\n            }\n\n        });\n    }\n);\n","Magento_Weee/js/view/checkout/summary/item/price/row_incl_tax.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Weee/js/view/checkout/summary/item/price/weee'\n    ],\n    function (weee) {\n        \"use strict\";\n        return weee.extend({\n            defaults: {\n                template: 'Magento_Weee/checkout/summary/item/price/row_incl_tax',\n                displayArea: 'row_incl_tax'\n            },\n\n            getFinalRowDisplayPriceInclTax: function(item) {\n                var rowTotalInclTax = parseFloat(item.row_total_incl_tax);\n                if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                    rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n                }\n                return rowTotalInclTax;\n            },\n\n            getRowDisplayPriceInclTax: function(item) {\n                var rowTotalInclTax = parseFloat(item.row_total_incl_tax);\n                if (window.checkoutConfig.getIncludeWeeeFlag) {\n                    rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n                }\n                return rowTotalInclTax;\n            },\n\n            getRowWeeeTaxInclTax: function(item) {\n                var totalWeeeTaxInclTaxApplied = 0;\n                if (item.weee_tax_applied) {\n                    var weeeTaxAppliedAmounts = JSON.parse(item.weee_tax_applied);\n                    weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                        totalWeeeTaxInclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount.row_amount_incl_tax, 0));\n                    });\n                }\n                return totalWeeeTaxInclTaxApplied;\n            }\n\n        });\n    }\n);\n","Magento_Weee/js/view/checkout/summary/item/price/weee.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (Component,quote) {\n        \"use strict\";\n        return Component.extend({\n\n            isDisplayPriceWithWeeeDetails: function(item) {\n                if(!parseFloat(item.weee_tax_applied_amount) || parseFloat(item.weee_tax_applied_amount <= 0)) {\n                    return false;\n                }\n                return window.checkoutConfig.isDisplayPriceWithWeeeDetails;\n            },\n            isDisplayFinalPrice: function(item) {\n                if(!parseFloat(item.weee_tax_applied_amount)) {\n                    return false;\n                }\n                return window.checkoutConfig.isDisplayFinalPrice;\n            },\n            getWeeeTaxApplied: function(item) {\n                if (item.weee_tax_applied) {\n                    return JSON.parse(item.weee_tax_applied)\n                }\n                return [];\n\n            }\n        });\n    }\n);\n","Magento_Usps/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        'use strict';\n        return {\n            getRules: function () {\n                return {\n                    'country_id': {\n                        'required': true\n                    },\n                    'postcode': {\n                        'required': false\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Usps/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        './shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n        var checkoutConfig = window.checkoutConfig;\n\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var rules = validationRules.getRules(),\n                    self = this;\n\n                $.each(rules, function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        self.validationErrors.push(message);\n                    }\n                });\n\n                if (!Boolean(this.validationErrors.length)) {\n                    if (address.country_id == checkoutConfig.originCountryCode) {\n                        return !utils.isEmpty(address.postcode);\n                    }\n                    return true;\n                }\n                return false;\n            }\n        };\n    }\n);\n","Magento_Usps/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../model/shipping-rates-validator',\n        '../model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        uspsShippingRatesValidator,\n        uspsShippingRatesValidationRules\n    ) {\n        'use strict';\n        defaultShippingRatesValidator.registerValidator('usps', uspsShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('usps', uspsShippingRatesValidationRules);\n        return Component;\n    }\n);\n","Magento_Ups/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        'use strict';\n        return {\n            getRules: function () {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Ups/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        'Magento_Ups/js/model/shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        'use strict';\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n\n                        self.validationErrors.push(message);\n                    }\n                });\n\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n    }\n);\n","Magento_Ups/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        'Magento_Ups/js/model/shipping-rates-validator',\n        'Magento_Ups/js/model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        upsShippingRatesValidator,\n        upsShippingRatesValidationRules\n    ) {\n        'use strict';\n        defaultShippingRatesValidator.registerValidator('ups', upsShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('ups', upsShippingRatesValidationRules);\n\n        return Component;\n    }\n);\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'jquery/jquery.parsequery'\n], function ($, _) {\n    'use strict';\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - option-type (integer, 0-3)\n     *  - option-label (string)\n     *  - option-tooltip-thumb\n     *  - option-tooltip-value\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.attr('option-type'), 10),\n                label = $this.attr('option-label'),\n                thumb = $this.attr('option-tooltip-thumb'),\n                value = $this.attr('option-tooltip-value'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.size()) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.hover(function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            }, function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // text for more button\n            moreButtonText: 'More',\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            //\n            onlyMainImg: false\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns array\n         */\n        getProduct: function () {\n            return this._CalcProducts().shift();\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                this._sortAttributes();\n                this._RenderControls();\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return attribute.position;\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                isProductViewExist = $('body.catalog-product-view').size() > 0,\n                $main = isProductViewExist ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (isProductViewExist) {\n                gallery.on('gallery:loaded', function () {\n                    var galleryObject = gallery.data('gallery');\n\n                    options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n                });\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n            this.productForm = this.element.parents(this.options.selectorProduct).find('form:first');\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    options = $widget._RenderSwatchOptions(item),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span class=\"' + classes.attributeLabelClass + '\">' + item.label + '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.productForm) {\n                    $widget.productForm.append(input);\n                    input = '';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code +\n                        '\" attribute-code=\"' + item.code +\n                        '\" attribute-id=\"' + item.id + '\">' +\n                            label +\n                        '<div class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: this.products\n                        };\n                    }\n                });\n            });\n\n            // Connect Tooltip\n            container\n                .find('[option-type=\"1\"], [option-type=\"2\"], [option-type=\"0\"], [option-type=\"3\"]')\n                .SwatchRendererTooltip();\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function () {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    attr;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\">' + moreText + '</a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ? optionConfig[id].value : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                label = this.label ? this.label : '';\n                attr =\n                    ' option-type=\"' + type + '\"' +\n                    ' option-id=\"' + id + '\"' +\n                    ' option-label=\"' + label + '\"' +\n                    ' option-tooltip-thumb=\"' + thumb + '\"' +\n                    ' option-tooltip-value=\"' + value + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        '\" style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        '\" style=\"background: url(' + value + ') no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Defaualt\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required:true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"true\" ' +\n                'style=\"visibility: hidden; position:absolute; left:-1000px\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n\n            var $widget = this;\n\n            $widget.element.on('click', '.' + this.options.classes.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + this.options.classes.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + this.options.classes.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n        },\n\n        /**\n         * Event for swatch options\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnClick: function ($this, $widget) {\n\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),\n                attributeId = $parent.attr('attribute-id'),\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n\n            if ($this.hasClass('disabled')) {\n                return;\n            }\n\n            if ($this.hasClass('selected')) {\n                $parent.removeAttr('option-selected').find('.selected').removeClass('selected');\n                $input.val('');\n                $label.text('');\n            } else {\n                $parent.attr('option-selected', $this.attr('option-id')).find('.selected').removeClass('selected');\n                $label.text($this.attr('option-label'));\n                $input.val($this.attr('option-id'));\n                $this.addClass('selected');\n            }\n\n            $widget._Rebuild();\n\n            if ($widget.element.parents($widget.options.selectorProduct)\n                    .find(this.options.selectorProductPrice).is(':data(mage-priceBox)')\n            ) {\n                $widget._UpdatePrice();\n            }\n\n            $widget._LoadProductMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for select\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnChange: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                attributeId = $parent.attr('attribute-id'),\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n\n            if ($this.val() > 0) {\n                $parent.attr('option-selected', $this.val());\n                $input.val($this.val());\n            } else {\n                $parent.removeAttr('option-selected');\n                $input.val('');\n            }\n\n            $widget._Rebuild();\n            $widget._UpdatePrice();\n            $widget._LoadProductMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for more switcher\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _OnMoreClick: function ($this) {\n            $this.nextAll().show();\n            $this.blur().remove();\n        },\n\n        /**\n         * Rewind options for controls\n         *\n         * @private\n         */\n        _Rewind: function (controls) {\n            controls.find('div[option-id], option[option-id]').removeClass('disabled').removeAttr('disabled');\n            controls.find('div[option-empty], option[option-empty]').attr('disabled', true).addClass('disabled');\n        },\n\n        /**\n         * Rebuild container\n         *\n         * @private\n         */\n        _Rebuild: function () {\n\n            var $widget = this,\n                controls = $widget.element.find('.' + $widget.options.classes.attributeClass + '[attribute-id]'),\n                selected = controls.filter('[option-selected]');\n\n            // Enable all options\n            $widget._Rewind(controls);\n\n            // done if nothing selected\n            if (selected.size() <= 0) {\n                return;\n            }\n\n            // Disable not available options\n            controls.each(function () {\n                var $this = $(this),\n                    id = $this.attr('attribute-id'),\n                    products = $widget._CalcProducts(id);\n\n                if (selected.size() === 1 && selected.first().attr('attribute-id') === id) {\n                    return;\n                }\n\n                $this.find('[option-id]').each(function () {\n                    var $element = $(this),\n                        option = $element.attr('option-id');\n\n                    if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option) ||\n                        $element.hasClass('selected') ||\n                        $element.is(':selected')) {\n                        return;\n                    }\n\n                    if (_.intersection(products, $widget.optionsMap[id][option].products).length <= 0) {\n                        $element.attr('disabled', true).addClass('disabled');\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get selected product list\n         *\n         * @returns {Array}\n         * @private\n         */\n        _CalcProducts: function ($skipAttributeId) {\n            var $widget = this,\n                products = [];\n\n            // Generate intersection of products\n            $widget.element.find('.' + $widget.options.classes.attributeClass + '[option-selected]').each(function () {\n                var id = $(this).attr('attribute-id'),\n                    option = $(this).attr('option-selected');\n\n                if ($skipAttributeId !== undefined && $skipAttributeId === id) {\n                    return;\n                }\n\n                if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option)) {\n                    return;\n                }\n\n                if (products.length === 0) {\n                    products = $widget.optionsMap[id][option].products;\n                } else {\n                    products = _.intersection(products, $widget.optionsMap[id][option].products);\n                }\n            });\n\n            return products;\n        },\n\n 