require.config({
    config: {
        'jsbuild':{"mage/adminhtml/browser.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"tinymce\",\n    \"Magento_Ui/js/modal/prompt\",\n    \"Magento_Ui/js/modal/confirm\",\n    \"Magento_Ui/js/modal/alert\",\n    \"Magento_Ui/js/modal/modal\",\n    \"jquery/ui\",\n    \"jquery/jstree/jquery.jstree\",\n    \"mage/mage\"\n], function($, tinyMCEm, prompt, confirm, alert){\n    \n    MediabrowserUtility = {\n        windowId: 'modal_dialog_message',\n        getMaxZIndex: function() {\n            var max = 0, i;\n            var cn = document.body.childNodes;\n            for (i = 0; i < cn.length; i++) {\n                var el = cn[i];\n                var zIndex = el.nodeType == 1 ? parseInt(el.style.zIndex, 10) || 0 : 0;\n                if (zIndex < 10000) {\n                    max = Math.max(max, zIndex);\n                }\n            }\n            return max + 10;\n        },\n        openDialog: function(url, width, height, title, options) {\n            var windowId = this.windowId,\n                content = '<div class=\"popup-window magento-message\" \"id=\"' + windowId + '\"></div>',\n                self = this;\n\n            if (this.modal) {\n                this.modal.html($(content).html());\n                this.modal.modal('option', 'closed', options.closed);\n            } else {\n                this.modal = $(content).modal($.extend({\n                    title:  title || 'Insert File...',\n                    modalClass: 'magento',\n                    type: 'slide',\n                    buttons: []\n                }, options));\n            }\n            this.modal.modal('openModal');\n            $.ajax({\n                url: url,\n                type: 'get',\n                context: $(this),\n                showLoader: true\n\n            }).done(function(data) {\n                self.modal.html(data).trigger('contentUpdated');\n            });\n        },\n        closeDialog: function() {\n            this.modal.modal('closeModal');\n        }\n    };\n\n    $.widget(\"mage.mediabrowser\", {\n        eventPrefix: \"mediabrowser\",\n        options: {\n            targetElementId: null,\n            contentsUrl: null,\n            onInsertUrl: null,\n            newFolderUrl: null,\n            deleteFolderUrl: null,\n            deleteFilesUrl: null,\n            headerText: null,\n            tree: null,\n            currentNode: null,\n            storeId: null,\n            showBreadcrumbs: null,\n            hidden: 'no-display'\n        },\n        /**\n         * Proxy creation\n         * @protected\n         */\n        _create: function() {\n            this._on({\n                'click [data-row=file]': 'selectFile',\n                'dblclick [data-row=file]': 'insert',\n                'click #new_folder': 'newFolder',\n                'click #delete_folder': 'deleteFolder',\n                'click #delete_files': 'deleteFiles',\n                'click #insert_files': 'insertSelectedFiles',\n                'fileuploaddone': '_uploadDone',\n                'click [data-row=breadcrumb]': 'selectFolder'\n            });\n            this.activeNode = null;\n            //tree dont use event bubbling\n            this.tree = this.element.find('[data-role=tree]');\n            this.tree.on(\"select_node.jstree\", $.proxy(this._selectNode, this));\n        },\n\n        _selectNode: function(event, data) {\n            var node = data.rslt.obj.data('node');\n            this.activeNode = node;\n            this.element.find('#delete_files, #insert_files').toggleClass(this.options.hidden, true);\n            this.element.find('#contents').toggleClass(this.options.hidden, false);\n            this.element.find('#delete_folder').toggleClass(this.options.hidden, node.id == 'root');\n            this.element.find('#content_header_text').html(node.id == 'root' ? this.headerText : node.text);\n\n            this.drawBreadcrumbs(data);\n            this.loadFileList(node);\n        },\n\n        reload : function() {\n            return this.loadFileList(this.activeNode);\n        },\n\n        insertAtCursor: function(element, value) {\n            if ('selection' in document) {\n                //For browsers like Internet Explorer\n                element.focus();\n                sel = document.selection.createRange();\n                sel.text = value;\n                element.focus();\n            } else if (element.selectionStart || element.selectionStart == '0') {\n                //For browsers like Firefox and Webkit based\n                var startPos = element.selectionStart;\n                var endPos = element.selectionEnd;\n                var scrollTop = element.scrollTop;\n                element.value = element.value.substring(0, startPos) + value + element.value.substring(startPos, endPos)\n                    + element.value.substring(endPos, element.value.length);\n                element.focus();\n                element.selectionStart = startPos + value.length;\n                element.selectionEnd = ((startPos + value.length) + element.value.substring(startPos, endPos).length);\n                element.scrollTop = scrollTop;\n            } else {\n                element.value += value;\n                element.focus();\n            }\n        },\n\n        loadFileList: function(node) {\n            var contentBlock = this.element.find('#contents');\n            return $.ajax({\n                url: this.options.contentsUrl,\n                type: 'GET',\n                dataType: 'html',\n                data: {\n                    form_key: FORM_KEY,\n                    node: node.id\n                },\n                context: contentBlock,\n                showLoader: true\n            }).done(function(data) {\n                contentBlock.html(data).trigger('contentUpdated');\n            });\n        },\n\n        selectFolder: function(event) {\n            this.element.find('[data-id=\"'+ $(event.currentTarget).data('node').id +'\"]>a').click();\n        },\n\n        insertSelectedFiles: function(event) {\n            this.element.find('[data-row=file].selected').trigger('dblclick');\n        },\n\n        selectFile: function(event) {\n            var fileRow = $(event.currentTarget);\n            fileRow.toggleClass('selected');\n            this.element.find('[data-row=file]').not(fileRow).removeClass('selected');\n            this.element.find('#delete_files, #insert_files')\n                .toggleClass(this.options.hidden, !fileRow.is('.selected'));\n            fileRow.trigger('selectfile');\n        },\n\n        _uploadDone: function(event) {\n            this.element.find('.file-row').remove();\n            this.reload();\n        },\n\n        insert: function(event) {\n            var fileRow = $(event.currentTarget);\n\n            if (!fileRow.prop('id')) {\n                return false;\n            }\n            var targetEl = this.getTargetElement();\n\n            if (!targetEl.length) {\n                MediabrowserUtility.closeDialog();\n                throw \"Target element not found for content update\";\n            }\n\n            return $.ajax({\n                url: this.options.onInsertUrl,\n                data: {\n                    filename: fileRow.attr('id'),\n                    node: this.activeNode.id,\n                    store: this.options.storeId,\n                    as_is: targetEl.is('textarea') ? 1 : 0,\n                    form_key: FORM_KEY\n                },\n                context: this,\n                showLoader: true\n            }).done($.proxy(function(data) {\n                if (targetEl.is('textarea')) {\n                    this.insertAtCursor(targetEl.get(0), data);\n                } else {\n                    targetEl.val(data).trigger('change');\n                }\n                MediabrowserUtility.closeDialog();\n                targetEl.focus();\n                jQuery(targetEl).change();\n            }, this));\n        },\n\n        /**\n         * Find document target element in next order:\n         *  in acive file browser opener:\n         *  - input field with ID: \"src\" in opener window\n         *  - input field with ID: \"href\" in opener window\n         *  in document:\n         *  - element with target ID\n         *\n         * return HTMLelement | null\n         */\n        getTargetElement: function() {\n            if (typeof(tinyMCE) != 'undefined' && tinyMCE.get(this.options.targetElementId)) {\n                var opener = this.getMediaBrowserOpener() || window;\n                var targetElementId = tinyMceEditors.get(this.options.targetElementId).getMediaBrowserTargetElementId();\n                return $(opener.document.getElementById(targetElementId));\n            } else {\n                return $('#' + this.options.targetElementId);\n            }\n        },\n\n        /**\n         * Return opener Window object if it exists, not closed and editor is active\n         *\n         * return object | null\n         */\n        getMediaBrowserOpener: function() {\n            if (typeof(tinyMCE) != 'undefined'\n                && tinyMCE.get(this.options.targetElementId)\n                && typeof(tinyMceEditors) != 'undefined'\n                && !tinyMceEditors.get(this.options.targetElementId).getMediaBrowserOpener().closed) {\n                return tinyMceEditors.get(this.options.targetElementId).getMediaBrowserOpener();\n            } else {\n                return null;\n            }\n        },\n\n        newFolder: function() {\n            var self = this;\n\n            prompt({\n                title: this.options.newFolderPrompt,\n                actions: {\n                    confirm: function (folderName) {\n                        return $.ajax({\n                            url: self.options.newFolderUrl,\n                            dataType: 'json',\n                            data: {\n                                name: folderName,\n                                node: self.activeNode.id,\n                                store: self.options.storeId,\n                                form_key: FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function(data) {\n                            if (data.error) {\n                                alert({\n                                    content: data.message\n                                });\n                            } else {\n                                self.tree.jstree('refresh',  self.element.find('[data-id=\"' + self.activeNode.id + '\"]'));\n                            }\n                        }, this));\n                    }\n                }\n            });\n        },\n\n        deleteFolder: function() {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteFolderConfirmationMessage,\n                actions: {\n                    confirm: function () {\n                        return $.ajax({\n                            url: self.options.deleteFolderUrl,\n                            dataType: 'json',\n                            data: {\n                                node: self.activeNode.id,\n                                store: self.options.storeId,\n                                form_key: FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function(data) {\n                            self.tree.jstree('refresh', self.activeNode.id);\n                        }, this));\n                    },\n                    cancel: function () {\n                        return false;\n                    }\n                }\n            });\n        },\n\n        deleteFiles: function() {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteFileConfirmationMessage,\n                actions: {\n                    confirm: function () {\n                        var selectedFiles = self.element.find('[data-row=file].selected');\n                        var ids = selectedFiles.map(function(index, file) {\n                            return $(this).attr('id');\n                        }).toArray();\n\n                        return $.ajax({\n                            url: self.options.deleteFilesUrl,\n                            data: {\n                                files: ids,\n                                store: self.options.storeId,\n                                form_key: FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function(data) {\n                            self.reload();\n                        }, this));\n                    },\n                    cancel: function () {\n                        return false;\n                    }\n                }\n            });\n        },\n\n        drawBreadcrumbs: function(data) {\n            if (this.element.find('#breadcrumbs').length) {\n                this.element.find('#breadcrumbs').remove();\n            }\n            var node = data.rslt.obj.data('node');\n            if (node.id == 'root') {\n                return;\n            }\n            var breadcrumbs = $('<ul class=\"breadcrumbs\" id=\"breadcrumbs\" />');\n            $(data.rslt.obj.parents('[data-id]').get().reverse()).add(data.rslt.obj).each(function(index, element){\n                var node = $(element).data('node');\n                if (index > 0) {\n                    breadcrumbs.append($('<li>\\/</li>'));\n                }\n                breadcrumbs.append($('<li />').data('node', node).attr('data-row', 'breadcrumb').text(node.text));\n\n            });\n\n            breadcrumbs.insertAfter(this.element.find('#content_header'))\n        }\n    });\n});\n","mage/adminhtml/form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    \"jquery\",\n    \"prototype\",\n    \"mage/adminhtml/events\"\n], function(jQuery){\n/*\n * @TODO Need to be removed after refactoring all dependent of the form the components\n */\n(function($) {\n    $(document).ready(function() {\n        $(document).on(\"beforeSubmit\", function(e) {\n            if (typeof varienGlobalEvents !== 'undefined') {\n                varienGlobalEvents.fireEvent(\"formSubmit\", $(e.target).attr('id'));\n            }\n        });\n    });\n})(jQuery);\n\n\n/**\n *  Additional elements methods\n */\nvar varienElementMethods = {\n    setHasChanges : function(element, event){\n        if($(element) && $(element).hasClassName('no-changes')) return;\n        var elm = element;\n        while(elm && elm.tagName != 'BODY') {\n            if(elm.statusBar)\n                Element.addClassName($(elm.statusBar), 'changed')\n            elm = elm.parentNode;\n        }\n    },\n    setHasError : function(element, flag, form){\n        var elm = element;\n        while(elm && elm.tagName != 'BODY') {\n            if(elm.statusBar){\n                if(form.errorSections.keys().indexOf(elm.statusBar.id)<0)\n                    form.errorSections.set(elm.statusBar.id, flag);\n                if(flag){\n                    Element.addClassName($(elm.statusBar), 'error');\n                    if(form.canShowError && $(elm.statusBar).show){\n                        form.canShowError = false;\n                        $(elm.statusBar).show();\n                    }\n                    form.errorSections.set(elm.statusBar.id, flag);\n                }\n                else if(!form.errorSections.get(elm.statusBar.id)){\n                    Element.removeClassName($(elm.statusBar), 'error')\n                }\n            }\n            elm = elm.parentNode;\n        }\n        this.canShowElement = false;\n    }\n}\n\nElement.addMethods(varienElementMethods);\n\n// Global bind changes\nvarienWindowOnloadCache = {};\nfunction varienWindowOnload(useCache){\n    var dataElements = $$('input', 'select', 'textarea');\n    for(var i=0; i<dataElements.length;i++){\n        if(dataElements[i] && dataElements[i].id){\n            if ((!useCache) || (!varienWindowOnloadCache[dataElements[i].id])) {\n                Event.observe(dataElements[i], 'change', dataElements[i].setHasChanges.bind(dataElements[i]));\n                if (useCache) {\n                    varienWindowOnloadCache[dataElements[i].id] = true;\n                }\n            }\n        }\n    }\n}\nEvent.observe(window, 'load', varienWindowOnload);\n\nRegionUpdater = Class.create();\nRegionUpdater.prototype = {\n    initialize: function (countryEl, regionTextEl, regionSelectEl, regions, disableAction, clearRegionValueOnDisable)\n    {\n        this.isRegionRequired = true;\n        this.countryEl = $(countryEl);\n        this.regionTextEl = $(regionTextEl);\n        this.regionSelectEl = $(regionSelectEl);\n        this.config = regions['config'];\n        delete regions.config;\n        this.regions = regions;\n        this.disableAction = (typeof disableAction=='undefined') ? 'hide' : disableAction;\n        this.clearRegionValueOnDisable = (typeof clearRegionValueOnDisable == 'undefined') ? false : clearRegionValueOnDisable;\n\n        if (this.regionSelectEl.options.length<=1) {\n            this.update();\n        }\n        else {\n            this.lastCountryId = this.countryEl.value;\n        }\n\n        this.countryEl.changeUpdater = this.update.bind(this);\n\n        Event.observe(this.countryEl, 'change', this.update.bind(this));\n    },\n\n    _checkRegionRequired: function()\n    {\n        if (!this.isRegionRequired) {\n            return;\n        }\n\n        var label, wildCard;\n        var elements = [this.regionTextEl, this.regionSelectEl];\n        var that = this;\n        if (typeof this.config == 'undefined') {\n            return;\n        }\n        var regionRequired = this.config.regions_required.indexOf(this.countryEl.value) >= 0;\n\n        elements.each(function(currentElement) {\n            if(!currentElement) {\n                return;\n            }\n            var form = currentElement.form,\n                validationInstance = form ? jQuery(form).data('validation') : null,\n                field = currentElement.up('.field') || new Element('div');\n\n            if (validationInstance) {\n                validationInstance.clearError(currentElement);\n            }\n            label = $$('label[for=\"' + currentElement.id + '\"]')[0];\n            if (label) {\n                wildCard = label.down('em') || label.down('span.required');\n                var topElement = label.up('tr') || label.up('li');\n                if (!that.config.show_all_regions && topElement) {\n                    if (regionRequired) {\n                        topElement.show();\n                    } else {\n                        topElement.hide();\n                    }\n                }\n            }\n\n            if (label && wildCard) {\n                if (!regionRequired) {\n                    wildCard.hide();\n                } else {\n                    wildCard.show();\n                }\n            }\n\n            //compute the need for the required fields\n            if (!regionRequired || !currentElement.visible()) {\n                if (field.hasClassName('required')) {\n                    field.removeClassName('required');\n                }\n                if (currentElement.hasClassName('required-entry')) {\n                    currentElement.removeClassName('required-entry');\n                }\n                if ('select' == currentElement.tagName.toLowerCase() &&\n                    currentElement.hasClassName('validate-select')\n                ) {\n                    currentElement.removeClassName('validate-select');\n                }\n            } else {\n                if (!field.hasClassName('required')) {\n                    field.addClassName('required');\n                }\n                if (!currentElement.hasClassName('required-entry')) {\n                    currentElement.addClassName('required-entry');\n                }\n                if ('select' == currentElement.tagName.toLowerCase() &&\n                    !currentElement.hasClassName('validate-select')\n                ) {\n                    currentElement.addClassName('validate-select');\n                }\n            }\n        });\n    },\n\n    disableRegionValidation: function()\n    {\n        this.isRegionRequired = false;\n    },\n\n    update: function()\n    {\n        if (this.regions[this.countryEl.value]) {\n\n            if (this.lastCountryId!=this.countryEl.value) {\n                var i, option, region, def;\n\n                def = this.regionSelectEl.getAttribute('defaultValue');\n                if (this.regionTextEl) {\n                    if (!def) {\n                        def = this.regionTextEl.value.toLowerCase();\n                    }\n                    this.regionTextEl.value = '';\n                }\n\n                this.regionSelectEl.options.length = 1;\n                for (regionId in this.regions[this.countryEl.value]) {\n                    region = this.regions[this.countryEl.value][regionId];\n\n                    option = document.createElement('OPTION');\n                    option.value = regionId;\n                    option.text = region.name.stripTags();\n                    option.title = region.name;\n\n                    if (this.regionSelectEl.options.add) {\n                        this.regionSelectEl.options.add(option);\n                    } else {\n                        this.regionSelectEl.appendChild(option);\n                    }\n\n                    if (regionId==def || region.name.toLowerCase()==def || region.code.toLowerCase()==def) {\n                        this.regionSelectEl.value = regionId;\n                    }\n                }\n            }\n\n            if (this.disableAction=='hide') {\n                if (this.regionTextEl) {\n                    this.regionTextEl.style.display = 'none';\n                    this.regionTextEl.style.disabled = true;\n                }\n                this.regionSelectEl.style.display = '';\n                this.regionSelectEl.disabled = false;\n            } else if (this.disableAction=='disable') {\n                if (this.regionTextEl) {\n                    this.regionTextEl.disabled = true;\n                }\n                this.regionSelectEl.disabled = false;\n            }\n            this.setMarkDisplay(this.regionSelectEl, true);\n\n            this.lastCountryId = this.countryEl.value;\n        } else {\n            if (this.disableAction=='hide') {\n                if (this.regionTextEl) {\n                    this.regionTextEl.style.display = '';\n                    this.regionTextEl.style.disabled = false;\n                }\n                this.regionSelectEl.style.display = 'none';\n                this.regionSelectEl.disabled = true;\n            } else if (this.disableAction=='disable') {\n                if (this.regionTextEl) {\n                    this.regionTextEl.disabled = false;\n                }\n                this.regionSelectEl.disabled = true;\n                if (this.clearRegionValueOnDisable) {\n                    this.regionSelectEl.value = '';\n                }\n            } else if (this.disableAction=='nullify') {\n                this.regionSelectEl.options.length = 1;\n                this.regionSelectEl.value = '';\n                this.regionSelectEl.selectedIndex = 0;\n                this.lastCountryId = '';\n            }\n            this.setMarkDisplay(this.regionSelectEl, false);\n\n//            // clone required stuff from select element and then remove it\n//            this._regionSelectEl.className = this.regionSelectEl.className;\n//            this._regionSelectEl.name      = this.regionSelectEl.name;\n//            this._regionSelectEl.id        = this.regionSelectEl.id;\n//            this._regionSelectEl.innerHTML = this.regionSelectEl.innerHTML;\n//            Element.remove(this.regionSelectEl);\n//            this.regionSelectEl = null;\n        }\n        varienGlobalEvents.fireEvent(\"address_country_changed\", this.countryEl);\n        this._checkRegionRequired();\n    },\n\n    setMarkDisplay: function(elem, display){\n        if(elem.parentNode.parentNode){\n            var marks = Element.select(elem.parentNode.parentNode, '.required');\n            if(marks[0]){\n                display ? marks[0].show() : marks[0].hide();\n            }\n        }\n    }\n};\n\nregionUpdater = RegionUpdater;\n\n/**\n * Fix errorrs in IE\n */\nEvent.pointerX = function(event){\n    try{\n        return event.pageX || (event.clientX +(document.documentElement.scrollLeft || document.body.scrollLeft));\n    }\n    catch(e){\n\n    }\n}\nEvent.pointerY = function(event){\n    try{\n        return event.pageY || (event.clientY +(document.documentElement.scrollTop || document.body.scrollTop));\n    }\n    catch(e){\n\n    }\n}\n\n/**\n * Observer that watches for dependent form elements\n * If an element depends on 1 or more of other elements, it should show up only when all of them gain specified values\n */\nFormElementDependenceController = Class.create();\nFormElementDependenceController.prototype = {\n    /**\n     * Structure of elements: {\n     *     'id_of_dependent_element' : {\n     *         'id_of_master_element_1' : 'reference_value',\n     *         'id_of_master_element_2' : 'reference_value'\n     *         'id_of_master_element_3' : ['reference_value1', 'reference_value2']\n     *         ...\n     *     }\n     * }\n     * @param object elementsMap\n     * @param object config\n     */\n    initialize : function (elementsMap, config)\n    {\n        if (config) {\n            this._config = config;\n        }\n        for (var idTo in elementsMap) {\n            for (var idFrom in elementsMap[idTo]) {\n                if ($(idFrom)) {\n                    Event.observe($(idFrom), 'change', this.trackChange.bindAsEventListener(this, idTo, elementsMap[idTo]));\n                    this.trackChange(null, idTo, elementsMap[idTo]);\n                } else {\n                    this.trackChange(null, idTo, elementsMap[idTo]);\n                }\n            }\n        }\n    },\n\n    /**\n     * Misc. config options\n     * Keys are underscored intentionally\n     */\n    _config : {\n        levels_up : 1 // how many levels up to travel when toggling element\n    },\n\n    /**\n     * Define whether target element should be toggled and show/hide its row\n     *\n     * @param object e - event\n     * @param string idTo - id of target element\n     * @param valuesFrom - ids of master elements and reference values\n     * @return\n     */\n    trackChange : function(e, idTo, valuesFrom)\n    {\n        // define whether the target should show up\n        var shouldShowUp = true;\n        for (var idFrom in valuesFrom) {\n            var from = $(idFrom);\n            if (from) {\n                var values = valuesFrom[idFrom]['values'];\n                var isInArray = values.indexOf(from.value) != -1;\n                var isNegative = valuesFrom[idFrom]['negative'];\n                if (!from || isInArray && isNegative || !isInArray && !isNegative) {\n                    shouldShowUp = false;\n                }\n            }\n        }\n\n        // toggle target row\n        var headElement = $(idTo + '-head'),\n            isInheritCheckboxChecked = $(idTo + '_inherit') && $(idTo + '_inherit').checked,\n            target = $(idTo);\n\n        // Target won't always exist (for example, if field type is \"label\")\n        if (target) {\n            var inputs = target.up(this._config.levels_up).select('input', 'select', 'td'),\n                isAnInputOrSelect = ['input', 'select'].indexOf(target.tagName.toLowerCase()) != -1;\n        } else {\n            var inputs = false,\n                isAnInputOrSelect = false;\n        }\n        if (shouldShowUp) {\n            var currentConfig = this._config;\n            if (inputs) {\n                inputs.each(function (item) {\n                    // don't touch hidden inputs (and Use Default inputs too), bc they may have custom logic\n                    if ((!item.type || item.type != 'hidden') && !($(item.id+'_inherit') && $(item.id+'_inherit').checked)\n                        && !(currentConfig.can_edit_price != undefined && !currentConfig.can_edit_price)) {\n                        item.disabled = false;\n                        jQuery(item).removeClass('ignore-validate');\n                    }\n                });\n            }\n            if (headElement) {\n                headElement.show();\n                if (headElement.hasClassName('open') && target) {\n                    target.show();\n                } else if (target) {\n                    target.hide();\n                }\n            } else {\n                if (target) {\n                    target.show();\n                }\n                if (isAnInputOrSelect && !isInheritCheckboxChecked) {\n                    if (target) {\n                        target.disabled = false;\n                    }\n                    jQuery('#' + idTo).removeClass('ignore-validate');\n                }\n            }\n        } else {\n            if (inputs) {\n                inputs.each(function (item){\n                    // don't touch hidden inputs (and Use Default inputs too), bc they may have custom logic\n                    if ((!item.type || item.type != 'hidden') && !($(item.id+'_inherit') && $(item.id+'_inherit').checked)) {\n                        item.disabled = true;\n                        jQuery(item).addClass('ignore-validate');\n                    }\n                });\n            }\n            if (headElement) {\n                headElement.hide();\n            }\n            if (target) {\n                target.hide();\n            }\n            if (isAnInputOrSelect && !isInheritCheckboxChecked) {\n                if (target) {\n                    target.disabled = true;\n                }\n                jQuery('#' + idTo).addClass('ignore-validate');\n            }\n\n        }\n        var rowElement = $('row_' + idTo);\n        if (rowElement == undefined && target) {\n            rowElement = target.up(this._config.levels_up);\n        }\n        if (rowElement) {\n            if (shouldShowUp) {\n                rowElement.show();\n            } else {\n                rowElement.hide();\n            }\n        }\n    }\n};\n\n\n    window.varienWindowOnload = varienWindowOnload;\n    window.varienElementMethods = varienElementMethods;\n});","mage/adminhtml/grid.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// also depends on a mage/adminhtml/tools.js for Base64 encoding\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'mage/mage',\n    'prototype',\n    'mage/adminhtml/form',\n    'mage/adminhtml/events'\n], function (jQuery, mageTemplate, alert, confirm) {\n\nwindow.varienGrid = new Class.create();\n\nvarienGrid.prototype = {\n    initialize:function (containerId, url, pageVar, sortVar, dirVar, filterVar) {\n        this.containerId = containerId;\n        jQuery('#' + containerId).data('gridObject', this);\n        this.url = url;\n        this.pageVar = pageVar || false;\n        this.sortVar = sortVar || false;\n        this.dirVar = dirVar || false;\n        this.filterVar = filterVar || false;\n        this.tableSufix = '_table';\n        this.useAjax = false;\n        this.rowClickCallback = false;\n        this.checkboxCheckCallback = false;\n        this.preInitCallback = false;\n        this.initCallback = false;\n        this.initRowCallback = false;\n        this.doFilterCallback = false;\n        this.sortableUpdateCallback = false;\n\n        this.reloadParams = false;\n\n        this.trOnMouseOver = this.rowMouseOver.bindAsEventListener(this);\n        this.trOnMouseOut = this.rowMouseOut.bindAsEventListener(this);\n        this.trOnClick = this.rowMouseClick.bindAsEventListener(this);\n        this.trOnDblClick = this.rowMouseDblClick.bindAsEventListener(this);\n        this.trOnKeyPress = this.keyPress.bindAsEventListener(this);\n\n        this.thLinkOnClick = this.doSort.bindAsEventListener(this);\n        this.initGrid();\n    },\n    initGrid:function () {\n        if (this.preInitCallback) {\n            this.preInitCallback(this);\n        }\n        if ($(this.containerId + this.tableSufix)) {\n            this.rows = $$('#' + this.containerId + this.tableSufix + ' tbody tr');\n            for (var row = 0; row < this.rows.length; row++) {\n                if (row % 2 == 0) {\n                    Element.addClassName(this.rows[row], 'even');\n                }\n\n                Event.observe(this.rows[row], 'mouseover', this.trOnMouseOver);\n                Event.observe(this.rows[row], 'mouseout', this.trOnMouseOut);\n                Event.observe(this.rows[row], 'click', this.trOnClick);\n                Event.observe(this.rows[row], 'dblclick', this.trOnDblClick);\n            }\n        }\n        if (this.sortVar && this.dirVar) {\n            var columns = $$('#' + this.containerId + this.tableSufix + ' thead [data-sort]');\n\n            for (var col = 0; col < columns.length; col++) {\n                Event.observe(columns[col], 'click', this.thLinkOnClick);\n            }\n        }\n        this.bindFilterFields();\n        this.bindFieldsChange();\n        if (this.initCallback) {\n            try {\n                this.initCallback(this);\n            }\n            catch (e) {\n                if (window.console) {\n                    console.log(e);\n                }\n            }\n        }\n        jQuery('#' + this.containerId).trigger('gridinit', this)\n    },\n    initGridAjax:function () {\n        this.initGrid();\n        this.initGridRows();\n    },\n    initGridRows:function () {\n        if (this.initRowCallback) {\n            for (var row = 0; row < this.rows.length; row++) {\n                try {\n                    this.initRowCallback(this, this.rows[row]);\n                } catch (e) {\n                    if (window.console) {\n                        console.log(e);\n                    }\n                }\n            }\n        }\n    },\n    rowMouseOver:function (event) {\n        var element = Event.findElement(event, 'tr');\n\n        if (!element.title) return;\n\n        Element.addClassName(element, 'on-mouse');\n\n        if (!Element.hasClassName('_clickable')\n            && (this.rowClickCallback !== openGridRow || element.title)) {\n            if (element.title) {\n                Element.addClassName(element, '_clickable');\n            }\n        }\n    },\n    rowMouseOut:function (event) {\n        var element = Event.findElement(event, 'tr');\n        Element.removeClassName(element, 'on-mouse');\n    },\n    rowMouseClick:function (event) {\n        if (this.rowClickCallback) {\n            try {\n                this.rowClickCallback(this, event);\n            }\n            catch (e) {\n            }\n        }\n        varienGlobalEvents.fireEvent('gridRowClick', event);\n    },\n    rowMouseDblClick:function (event) {\n        varienGlobalEvents.fireEvent('gridRowDblClick', event);\n    },\n    keyPress:function (event) {\n\n    },\n    doSort:function (event) {\n        var element = Event.findElement(event, 'th');\n\n        if (element.readAttribute('data-sort') && element.readAttribute('data-direction')) {\n            this.addVarToUrl(this.sortVar, element.readAttribute('data-sort'));\n            this.addVarToUrl(this.dirVar, element.readAttribute('data-direction'));\n            this.reload(this.url);\n        }\n        Event.stop(event);\n        return false;\n    },\n    loadByElement:function (element) {\n        if (element && element.name) {\n            this.reload(this.addVarToUrl(element.name, element.value));\n        }\n    },\n\n    _onAjaxSeccess: function(data, textStatus, transport) {\n        try {\n            var responseText = transport.responseText;\n\n            if (transport.responseText.isJSON()) {\n                var response = transport.responseText.evalJSON()\n                if (response.error) {\n                    alert({\n                        content: response.message\n                    });\n                }\n                if (response.ajaxExpired && response.ajaxRedirect) {\n                    setLocation(response.ajaxRedirect);\n                }\n            } else {\n                /**\n                 * For IE <= 7.\n                 * If there are two elements, and first has name, that equals id of second.\n                 * In this case, IE will choose one that is above\n                 *\n                 * @see https://prototype.lighthouseapp.com/projects/8886/tickets/994-id-selector-finds-elements-by-name-attribute-in-ie7\n                 */\n                var divId = $(this.containerId);\n                if (divId.id == this.containerId) {\n                    divId.update(responseText);\n                } else {\n                    $$('div[id=\"' + this.containerId + '\"]')[0].update(responseText);\n                }\n            }\n        } catch (e) {\n            var divId = $(this.containerId);\n            if (divId.id == this.containerId) {\n                divId.update(responseText);\n            } else {\n                $$('div[id=\"' + this.containerId + '\"]')[0].update(responseText);\n            }\n        }\n        jQuery('#' + this.containerId).trigger('contentUpdated');\n    },\n\n    reload:function (url, onSuccessCallback) {\n        this.reloadParams = this.reloadParams || {};\n        this.reloadParams.form_key = FORM_KEY;\n        url = url || this.url;\n        if (this.useAjax) {\n            var ajaxSettings = {\n                url: url + (url.match(new RegExp('\\\\?')) ? '&ajax=true' : '?ajax=true' ),\n                showLoader: true,\n                method: 'post',\n                context: jQuery('#' + this.containerId),\n                data: this.reloadParams,\n                error: this._processFailure.bind(this),\n                complete: this.initGridAjax.bind(this),\n                dataType: 'html',\n                success: function(data, textStatus, transport) {\n                    this._onAjaxSeccess(data, textStatus, transport);\n                    if (onSuccessCallback && typeof(onSuccessCallback) === \"function\") {\n                        // execute the callback, passing parameters as necessary\n                        onSuccessCallback();\n                    }\n                }.bind(this)\n            };\n            jQuery('#' + this.containerId).trigger('gridajaxsettings', ajaxSettings);\n            var ajaxRequest = jQuery.ajax(ajaxSettings);\n            jQuery('#' + this.containerId).trigger('gridajax', ajaxRequest);\n            return ajaxRequest;\n        } else {\n            if (this.reloadParams) {\n                $H(this.reloadParams).each(function(pair) {\n                    url = this.addVarToUrl(pair.key, pair.value);\n                }.bind(this));\n            }\n            location.href = url;\n        }\n    },\n    /*_processComplete : function(transport){\n        console.log(transport);\n        if (transport && transport.responseText){\n            try{\n                response = eval('(' + transport.responseText + ')');\n            }\n            catch (e) {\n                response = {};\n            }\n        }\n        if (response.ajaxExpired && response.ajaxRedirect) {\n            location.href = response.ajaxRedirect;\n            return false;\n        }\n        this.initGrid();\n    },*/\n    _processFailure:function (transport) {\n        location.href = BASE_URL;\n    },\n    _addVarToUrl:function (url, varName, varValue) {\n        var re = new RegExp('\\/(' + varName + '\\/.*?\\/)');\n        var parts = url.split(new RegExp('\\\\?'));\n        url = parts[0].replace(re, '/');\n        url += varName + '/' + varValue + '/';\n        if (parts.size() > 1) {\n            url += '?' + parts[1];\n        }\n        return url;\n    },\n    addVarToUrl:function (varName, varValue) {\n        this.url = this._addVarToUrl(this.url, varName, varValue);\n        return this.url;\n    },\n    doExport : function(){\n        if($(this.containerId+'_export')){\n            var exportUrl = $(this.containerId+'_export').value;\n            if(this.massaction && this.massaction.checkedString) {\n                exportUrl = this._addVarToUrl(exportUrl, this.massaction.formFieldNameInternal, this.massaction.checkedString);\n            }\n            location.href = exportUrl;\n        }\n    },\n    bindFilterFields : function(){\n        var filters = $$('#'+this.containerId+' [data-role=\"filter-form\"] input', '#'+this.containerId+' [data-role=\"filter-form\"] select');\n        for (var i=0; i<filters.length; i++) {\n            Event.observe(filters[i],'keypress',this.filterKeyPress.bind(this));\n        }\n    },\n    bindFieldsChange : function(){\n        if (!$(this.containerId)) {\n            return;\n        }\n//        var dataElements = $(this.containerId+this.tableSufix).down('.data tbody').select('input', 'select');\n        var dataElements = $(this.containerId+this.tableSufix).down('tbody').select('input', 'select');\n        for(var i=0; i<dataElements.length;i++){\n            Event.observe(dataElements[i], 'change', dataElements[i].setHasChanges.bind(dataElements[i]));\n        }\n    },\n    bindSortable: function(){\n        if (jQuery('#' + this.containerId).find('.draggable-handle').length) {\n            jQuery('#' + this.containerId).find('tbody').sortable({\n                axis: 'y',\n                handle: '.draggable-handle',\n                helper: function(event, ui) {\n                    ui.children().each(function() {\n                        jQuery(this).width(jQuery(this).width());\n                    });\n                    return ui;\n                },\n                update: this.sortableUpdateCallback ? this.sortableUpdateCallback : function(){},\n                tolerance: 'pointer'\n            });\n        }\n    },\n    filterKeyPress:function (event) {\n        if (event.keyCode == Event.KEY_RETURN) {\n            this.doFilter();\n        }\n    },\n    doFilter:function (callback) {\n        var filters = $$('#' + this.containerId + ' [data-role=\"filter-form\"] input', '#' + this.containerId + ' [data-role=\"filter-form\"] select');\n        var elements = [];\n        for (var i in filters) {\n            if (filters[i].value && filters[i].value.length) elements.push(filters[i]);\n        }\n        if (!this.doFilterCallback || (this.doFilterCallback && this.doFilterCallback())) {\n            this.reload(this.addVarToUrl(this.filterVar, Base64.encode(Form.serializeElements(elements))), callback);\n        }\n    },\n    resetFilter:function (callback) {\n        this.reload(this.addVarToUrl(this.filterVar, ''), callback);\n    },\n    checkCheckboxes:function (element) {\n        elements = Element.select($(this.containerId), 'input[name=\"' + element.name + '\"]');\n        for (var i = 0; i < elements.length; i++) {\n            this.setCheckboxChecked(elements[i], element.checked);\n        }\n    },\n    setCheckboxChecked:function (element, checked) {\n        element.checked = checked;\n        jQuery(element).trigger('change');\n        element.setHasChanges({});\n        if (this.checkboxCheckCallback) {\n            this.checkboxCheckCallback(this, element, checked);\n        }\n    },\n    inputPage:function (event, maxNum) {\n        var element = Event.element(event);\n        var keyCode = event.keyCode || event.which;\n        if (keyCode == Event.KEY_RETURN) {\n            this.setPage(element.value);\n        }\n        /*if(keyCode>47 && keyCode<58){\n\n         }\n         else{\n         Event.stop(event);\n         }*/\n    },\n    setPage:function (pageNumber) {\n        this.reload(this.addVarToUrl(this.pageVar, pageNumber));\n    }\n};\n\nfunction openGridRow(grid, event){\n    var element = Event.findElement(event, 'tr');\n    if(['a', 'input', 'select', 'option'].indexOf(Event.element(event).tagName.toLowerCase())!=-1) {\n        return;\n    }\n\n    if(element.title){\n        setLocation(element.title);\n    }\n}\nwindow.openGridRow = openGridRow;\n\nwindow.varienGridMassaction = Class.create();\nvarienGridMassaction.prototype = {\n    /* Predefined vars */\n    checkedValues: $H({}),\n    checkedString: '',\n    oldCallbacks: {},\n    errorText:'',\n    items: {},\n    gridIds: [],\n    useSelectAll: false,\n    currentItem: false,\n    lastChecked: { left: false, top: false, checkbox: false },\n    fieldTemplate: mageTemplate('<input type=\"hidden\" name=\"<%- name %>\" value=\"<%- value %>\" />'),\n    initialize: function (containerId, grid, checkedValues, formFieldNameInternal, formFieldName) {\n        this.setOldCallback('row_click', grid.rowClickCallback);\n        this.setOldCallback('init',      grid.initCallback);\n        this.setOldCallback('init_row',  grid.initRowCallback);\n        this.setOldCallback('pre_init',  grid.preInitCallback);\n\n        this.useAjax        = false;\n        this.grid           = grid;\n        this.grid.massaction = this;\n        this.containerId    = containerId;\n        this.initMassactionElements();\n\n        this.checkedString          = checkedValues;\n        this.formFieldName          = formFieldName;\n        this.formFieldNameInternal  = formFieldNameInternal;\n\n        this.grid.initCallback      = this.onGridInit.bind(this);\n        this.grid.preInitCallback   = this.onGridPreInit.bind(this);\n        this.grid.initRowCallback   = this.onGridRowInit.bind(this);\n        this.grid.rowClickCallback  = this.onGridRowClick.bind(this);\n        this.initCheckboxes();\n        this.checkCheckboxes();\n    },\n    setUseAjax: function(flag) {\n        this.useAjax = flag;\n    },\n    setUseSelectAll: function(flag) {\n        this.useSelectAll = flag;\n    },\n    initMassactionElements: function() {\n        this.container      = $(this.containerId);\n        this.multiselect    = $(this.containerId + '-mass-select');\n        this.count          = $(this.containerId + '-count');\n        this.formHiddens    = $(this.containerId + '-form-hiddens');\n        this.formAdditional = $(this.containerId + '-form-additional');\n        this.select         = $(this.containerId + '-select');\n        this.form           = this.prepareForm();\n        jQuery(this.form).mage('validation');\n        this.select.observe('change', this.onSelectChange.bindAsEventListener(this));\n        this.lastChecked    = { left: false, top: false, checkbox: false };\n        this.select.addClassName(this.select.value ? '_selected' : '');\n        this.initMassSelect();\n    },\n    prepareForm: function() {\n        var form = $(this.containerId + '-form'), formPlace = null,\n            formElement = this.formHiddens || this.formAdditional;\n\n        if (!formElement) {\n            formElement = this.container.getElementsByTagName('button')[0];\n            formElement && formElement.parentNode;\n        }\n        if (!form && formElement) {\n            /* fix problem with rendering form in FF through innerHTML property */\n            form = document.createElement('form');\n            form.setAttribute('method', 'post');\n            form.setAttribute('action', '');\n            form.id = this.containerId + '-form';\n            formPlace = formElement.parentNode;\n            formPlace.parentNode.appendChild(form);\n            form.appendChild(formPlace);\n        }\n\n        return form;\n    },\n    setGridIds: function(gridIds) {\n        this.gridIds = gridIds;\n        this.updateCount();\n    },\n    getGridIds: function() {\n        return this.gridIds;\n    },\n    setItems: function(items) {\n        this.items = items;\n        this.updateCount();\n    },\n    getItems: function() {\n        return this.items;\n    },\n    getItem: function(itemId) {\n        if(this.items[itemId]) {\n            return this.items[itemId];\n        }\n        return false;\n    },\n    getOldCallback: function (callbackName) {\n        return this.oldCallbacks[callbackName] ? this.oldCallbacks[callbackName] : Prototype.emptyFunction;\n    },\n    setOldCallback: function (callbackName, callback) {\n        this.oldCallbacks[callbackName] = callback;\n    },\n    onGridPreInit: function(grid) {\n        this.initMassactionElements();\n        this.getOldCallback('pre_init')(grid);\n    },\n    onGridInit: function(grid) {\n        this.initCheckboxes();\n        this.checkCheckboxes();\n        this.updateCount();\n        this.getOldCallback('init')(grid);\n    },\n    onGridRowInit: function(grid, row) {\n        this.getOldCallback('init_row')(grid, row);\n    },\n    isDisabled: function (evt) {\n        var target = jQuery(evt.target),\n            tr,\n            checkbox;\n\n        tr = target.is('tr') ? target : target.closest('tr');\n        checkbox = tr.find('input[type=\"checkbox\"]');\n\n        return checkbox.is(':disabled');\n    },\n    onGridRowClick: function(grid, evt) {\n        var tdElement = Event.findElement(evt, 'td');\n        var trElement = Event.findElement(evt, 'tr');\n\n        if (this.isDisabled(evt)) {\n            return false;\n        }\n\n        if(!$(tdElement).down('input')) {\n            if($(tdElement).down('a') || $(tdElement).down('select')) {\n                return;\n            }\n            if (trElement.title && trElement.title.strip() != '#') {\n                this.getOldCallback('row_click')(grid, evt);\n            }\n            else{\n                var checkbox = Element.select(trElement, 'input');\n                var isInput  = Event.element(evt).tagName == 'input';\n                var checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n\n                if(checked) {\n                    this.checkedString = varienStringArray.add(checkbox[0].value, this.checkedString);\n                } else {\n                    this.checkedString = varienStringArray.remove(checkbox[0].value, this.checkedString);\n                }\n                this.grid.setCheckboxChecked(checkbox[0], checked);\n                this.updateCount();\n            }\n            return;\n        }\n\n        if(Event.element(evt).isMassactionCheckbox) {\n           this.setCheckbox(Event.element(evt));\n        } else if (checkbox = this.findCheckbox(evt)) {\n           checkbox.checked = !checkbox.checked;\n           jQuery(checkbox).trigger('change');\n           this.setCheckbox(checkbox);\n        }\n    },\n    onSelectChange: function(evt) {\n        var item = this.getSelectedItem();\n        if(item) {\n            this.formAdditional.update($(this.containerId + '-item-' + item.id + '-block').innerHTML);\n            evt.target.addClassName('_selected')\n        } else {\n            this.formAdditional.update('');\n            evt.target.removeClassName('_selected')\n        }\n        jQuery(this.form).data('validator').resetForm();\n    },\n    findCheckbox: function(evt) {\n        if(['a', 'input', 'select'].indexOf(Event.element(evt).tagName.toLowerCase())!==-1) {\n            return false;\n        }\n        checkbox = false;\n        Event.findElement(evt, 'tr').select('[data-role=\"select-row\"]').each(function(element){\n            if(element.isMassactionCheckbox) {\n                checkbox = element;\n            }\n        }.bind(this));\n        return checkbox;\n    },\n    initCheckboxes: function() {\n        this.getCheckboxes().each(function(checkbox) {\n           checkbox.isMassactionCheckbox = true;\n        }.bind(this));\n    },\n    checkCheckboxes: function() {\n        this.getCheckboxes().each(function(checkbox) {\n            checkbox.checked = varienStringArray.has(checkbox.value, this.checkedString);\n            jQuery(checkbox).trigger('change');\n        }.bind(this));\n    },\n    selectAll: function() {\n        this.setCheckedValues((this.useSelectAll ? this.getGridIds() : this.getCheckboxesValuesAsString()));\n        this.checkCheckboxes();\n        this.updateCount();\n        this.clearLastChecked();\n        return false;\n    },\n    unselectAll: function() {\n        this.setCheckedValues('');\n        this.checkCheckboxes();\n        this.updateCount();\n        this.clearLastChecked();\n        return false;\n    },\n    selectVisible: function() {\n        this.setCheckedValues(this.getCheckboxesValuesAsString());\n        this.checkCheckboxes();\n        this.updateCount();\n        this.clearLastChecked();\n        return false;\n    },\n    unselectVisible: function() {\n        this.getCheckboxesValues().each(function(key){\n            this.checkedString = varienStringArray.remove(key, this.checkedString);\n        }.bind(this));\n        this.checkCheckboxes();\n        this.updateCount();\n        this.clearLastChecked();\n        return false;\n    },\n    setCheckedValues: function(values) {\n        this.checkedString = values;\n    },\n    getCheckedValues: function() {\n        return this.checkedString;\n    },\n    getCheckboxes: function() {\n        var result = [];\n        this.grid.rows.each(function(row){\n            var checkboxes = row.select('[data-role=\"select-row\"]');\n            checkboxes.each(function(checkbox){\n                result.push(checkbox);\n            });\n        });\n        return result;\n    },\n    getCheckboxesValues: function() {\n        var result = [];\n        this.getCheckboxes().each(function(checkbox) {\n            result.push(checkbox.value);\n        }.bind(this));\n        return result;\n    },\n    getCheckboxesValuesAsString: function() {\n        return this.getCheckboxesValues().join(',');\n    },\n    setCheckbox: function(checkbox) {\n        if(checkbox.checked) {\n            this.checkedString = varienStringArray.add(checkbox.value, this.checkedString);\n        } else {\n            this.checkedString = varienStringArray.remove(checkbox.value, this.checkedString);\n        }\n        this.updateCount();\n    },\n    updateCount: function() {\n        var checkboxesTotal = varienStringArray.count((this.useSelectAll ? this.getGridIds() : this.getCheckboxesValuesAsString())),\n            checkboxesChecked = varienStringArray.count(this.checkedString);\n        jQuery('[data-role=\"counter\"]' ,this.count).html(checkboxesChecked);\n        if (!checkboxesTotal) {\n            this.multiselect.addClassName('_disabled');\n        } else {\n            this.multiselect.removeClassName('_disabled');\n        }\n        if (checkboxesChecked == checkboxesTotal && checkboxesTotal != 0) {\n            this.count.removeClassName('_empty');\n            this.multiselect.addClassName('_checked').removeClassName('_indeterminate');\n        } else if (checkboxesChecked == 0) {\n            this.count.addClassName('_empty');\n            this.multiselect.removeClassName('_checked').removeClassName('_indeterminate');\n        } else {\n            this.count.removeClassName('_empty');\n            this.multiselect.addClassName('_checked').addClassName('_indeterminate');\n        }\n        if(!this.grid.reloadParams) {\n            this.grid.reloadParams = {};\n        }\n        this.grid.reloadParams[this.formFieldNameInternal] = this.checkedString;\n    },\n    getSelectedItem: function() {\n        if(this.getItem(this.select.value)) {\n            return this.getItem(this.select.value);\n        } else {\n            return false;\n        }\n    },\n    apply: function() {\n        var self = this;\n\n        if(varienStringArray.count(this.checkedString) == 0) {\n            alert({\n                content: this.errorText\n            });\n\n            return;\n        }\n\n        var item = this.getSelectedItem();\n        if(!item) {\n            jQuery(this.form).valid();\n            return;\n        }\n        this.currentItem = item;\n        var fieldName = (item.field ? item.field : this.formFieldName);\n\n        if (this.currentItem.confirm) {\n            confirm({\n                content: this.currentItem.confirm,\n                actions: {\n                    confirm: this.onConfirm.bind(this, fieldName, item)\n                }\n            });\n        } else {\n            this.onConfirm(fieldName, item);\n        }\n    },\n    onConfirm: function(fieldName, item) {\n        this.formHiddens.update('');\n        new Insertion.Bottom(this.formHiddens, this.fieldTemplate({\n            name: fieldName,\n            value: this.checkedString\n        }));\n        new Insertion.Bottom(this.formHiddens, this.fieldTemplate({\n            name: 'massaction_prepare_key',\n            value: fieldName\n        }));\n\n        if (!jQuery(this.form).valid()) {\n            return;\n        }\n\n        if (this.useAjax && item.url) {\n            new Ajax.Request(item.url, {\n                'method': 'post',\n                'parameters': this.form.serialize(true),\n                'onComplete': this.onMassactionComplete.bind(this)\n            });\n        } else if (item.url) {\n            this.form.action = item.url;\n            this.form.submit();\n        }\n    },\n    onMassactionComplete: function(transport) {\n        if(this.currentItem.complete) {\n            try {\n                var listener = this.getListener(this.currentItem.complete) || Prototype.emptyFunction;\n                listener(this.grid, this, transport);\n            } catch (e) {}\n       }\n    },\n    getListener: function(strValue) {\n        return eval(strValue);\n    },\n    initMassSelect: function() {\n        $$('input[data-role=\"select-row\"]').each(\n            function(element) {\n                element.observe('click', this.massSelect.bind(this));\n            }.bind(this)\n            );\n    },\n    clearLastChecked: function() {\n        this.lastChecked = {\n            left: false,\n            top: false,\n            checkbox: false\n        };\n    },\n    massSelect: function(evt) {\n        if(this.lastChecked.left !== false\n            && this.lastChecked.top !== false\n            && evt.button === 0\n            && evt.shiftKey === true\n        ) {\n            var currentCheckbox = Event.element(evt);\n            var lastCheckbox = this.lastChecked.checkbox;\n            if (lastCheckbox != currentCheckbox) {\n                var start = this.getCheckboxOrder(lastCheckbox);\n                var finish = this.getCheckboxOrder(currentCheckbox);\n                if (start !== false && finish !== false) {\n                    this.selectCheckboxRange(\n                        Math.min(start, finish),\n                        Math.max(start, finish),\n                        currentCheckbox.checked\n                    );\n                }\n            }\n        }\n\n        this.lastChecked = {\n            left: Event.element(evt).viewportOffset().left,\n            top: Event.element(evt).viewportOffset().top,\n            checkbox: Event.element(evt) // \"boundary\" checkbox\n        };\n    },\n    getCheckboxOrder: function(curCheckbox) {\n        var order = false;\n        this.getCheckboxes().each(function(checkbox, key){\n            if (curCheckbox == checkbox) {\n                order = key;\n            }\n        });\n        return order;\n    },\n    selectCheckboxRange: function(start, finish, isChecked){\n        this.getCheckboxes().each((function(checkbox, key){\n            if (key >= start && key <= finish) {\n                checkbox.checked = isChecked;\n                this.setCheckbox(checkbox);\n            }\n        }).bind(this));\n    }\n};\n\nwindow.varienGridAction = {\n    execute: function(select) {\n        if(!select.value || !select.value.isJSON()) {\n            return;\n        }\n\n        var config = select.value.evalJSON();\n        if(config.confirm && !window.confirm(config.confirm)) {\n            select.options[0].selected = true;\n            return;\n        }\n\n        if(config.popup) {\n            var win = window.open(config.href, 'action_window', 'width=500,height=600,resizable=1,scrollbars=1');\n            win.focus();\n            select.options[0].selected = true;\n        } else {\n            setLocation(config.href);\n        }\n    }\n};\n\nwindow.varienStringArray = {\n    remove: function(str, haystack)\n    {\n        haystack = ',' + haystack + ',';\n        haystack = haystack.replace(new RegExp(',' + str + ',', 'g'), ',');\n        return this.trimComma(haystack);\n    },\n    add: function(str, haystack)\n    {\n        haystack = ',' + haystack + ',';\n        if (haystack.search(new RegExp(',' + str + ',', 'g'), haystack) === -1) {\n            haystack += str + ',';\n        }\n        return this.trimComma(haystack);\n    },\n    has: function(str, haystack)\n    {\n        haystack = ',' + haystack + ',';\n        if (haystack.search(new RegExp(',' + str + ',', 'g'), haystack) === -1) {\n            return false;\n        }\n        return true;\n    },\n    count: function(haystack)\n    {\n        if (typeof haystack != 'string') {\n            return 0;\n        }\n        if (match = haystack.match(new RegExp(',', 'g'))) {\n            return match.length + 1;\n        } else if (haystack.length != 0) {\n            return 1;\n        }\n        return 0;\n    },\n    each: function(haystack, fnc)\n    {\n        var haystack = haystack.split(',');\n        for (var i=0; i<haystack.length; i++) {\n            fnc(haystack[i]);\n        }\n    },\n    trimComma: function(string)\n    {\n        string = string.replace(new RegExp('^(,+)','i'), '');\n        string = string.replace(new RegExp('(,+)$','i'), '');\n        return string;\n    }\n};\n\nwindow.serializerController = Class.create();\nserializerController.prototype = {\n    oldCallbacks: {},\n    initialize: function(hiddenDataHolder, predefinedData, inputsToManage, grid, reloadParamName){\n        //Grid inputs\n        this.tabIndex = 1000;\n        this.inputsToManage       = inputsToManage;\n        this.multidimensionalMode = inputsToManage.length > 0;\n\n        //Hash with grid data\n        this.gridData             = this.getGridDataHash(predefinedData);\n\n        //Hidden input data holder\n        this.hiddenDataHolder     = $(hiddenDataHolder);\n        this.hiddenDataHolder.value = this.serializeObject();\n\n        this.grid = grid;\n\n        // Set old callbacks\n        this.setOldCallback('row_click', this.grid.rowClickCallback);\n        this.setOldCallback('init_row', this.grid.initRowCallback);\n        this.setOldCallback('checkbox_check', this.grid.checkboxCheckCallback);\n\n        //Grid\n        this.reloadParamName = reloadParamName;\n        this.grid.reloadParams = {};\n        this.grid.reloadParams[this.reloadParamName+'[]'] = this.getDataForReloadParam();\n        this.grid.rowClickCallback = this.rowClick.bind(this);\n        this.grid.initRowCallback = this.rowInit.bind(this);\n        this.grid.checkboxCheckCallback = this.registerData.bind(this);\n        this.grid.rows.each(this.eachRow.bind(this));\n    },\n    setOldCallback: function (callbackName, callback) {\n        this.oldCallbacks[callbackName] = callback;\n    },\n    getOldCallback: function (callbackName) {\n        return this.oldCallbacks[callbackName] ? this.oldCallbacks[callbackName] : Prototype.emptyFunction;\n    },\n    registerData : function(grid, element, checked) {\n        if(this.multidimensionalMode){\n            if(checked){\n                 if(element.inputElements) {\n                     this.gridData.set(element.value, {});\n                     for(var i = 0; i < element.inputElements.length; i++) {\n                         element.inputElements[i].disabled = false;\n                         this.gridData.get(element.value)[element.inputElements[i].name] = element.inputElements[i].value;\n                     }\n                 }\n            }\n            else{\n                if(element.inputElements){\n                    for(var i = 0; i < element.inputElements.length; i++) {\n                        element.inputElements[i].disabled = true;\n                    }\n                }\n                this.gridData.unset(element.value);\n            }\n        }\n        else{\n            if(checked){\n                this.gridData.set(element.value, element.value);\n            }\n            else{\n                this.gridData.unset(element.value);\n            }\n        }\n\n        this.hiddenDataHolder.value = this.serializeObject();\n        this.grid.reloadParams = {};\n        this.grid.reloadParams[this.reloadParamName+'[]'] = this.getDataForReloadParam();\n        this.getOldCallback('checkbox_check')(grid, element, checked);\n    },\n    eachRow : function(row) {\n        this.rowInit(this.grid, row);\n    },\n    rowClick : function(grid, event) {\n        var trElement = Event.findElement(event, 'tr');\n        var isInput   = Event.element(event).tagName == 'INPUT';\n        if(trElement){\n            var checkbox = Element.select(trElement, 'input');\n            if(checkbox[0] && !checkbox[0].disabled){\n                var checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n                this.grid.setCheckboxChecked(checkbox[0], checked);\n            }\n        }\n        this.getOldCallback('row_click')(grid, event);\n    },\n    inputChange : function(event) {\n        var element = Event.element(event);\n        if(element && element.checkboxElement && element.checkboxElement.checked){\n            this.gridData.get(element.checkboxElement.value)[element.name] = element.value;\n            this.hiddenDataHolder.value = this.serializeObject();\n        }\n    },\n    rowInit : function(grid, row) {\n        if(this.multidimensionalMode){\n            var checkbox = $(row).select('.checkbox')[0];\n            var selectors = this.inputsToManage.map(function (name) { return ['input[name=\"' + name + '\"]', 'select[name=\"' + name + '\"]']; });\n            var inputs = $(row).select.apply($(row), selectors.flatten());\n            if(checkbox && inputs.length > 0) {\n                checkbox.inputElements = inputs;\n                for(var i = 0; i < inputs.length; i++) {\n                    inputs[i].checkboxElement = checkbox;\n                    if(this.gridData.get(checkbox.value) && this.gridData.get(checkbox.value)[inputs[i].name]) {\n                        inputs[i].value = this.gridData.get(checkbox.value)[inputs[i].name];\n                    }\n                    inputs[i].disabled = !checkbox.checked;\n                    inputs[i].tabIndex = this.tabIndex++;\n                    Event.observe(inputs[i],'keyup', this.inputChange.bind(this));\n                    Event.observe(inputs[i],'change', this.inputChange.bind(this));\n                }\n            }\n        }\n        this.getOldCallback('init_row')(grid, row);\n    },\n\n    //Stuff methods\n    getGridDataHash: function (_object){\n        return $H(this.multidimensionalMode ? _object : this.convertArrayToObject(_object))\n    },\n    getDataForReloadParam: function(){\n        return this.multidimensionalMode ? this.gridData.keys() : this.gridData.values();\n    },\n    serializeObject: function(){\n        if(this.multidimensionalMode){\n            var clone = this.gridData.clone();\n            clone.each(function(pair) {\n                clone.set(pair.key, Base64.encode(Object.toQueryString(pair.value)));\n            });\n            return clone.toQueryString();\n        }\n        else{\n            return this.gridData.values().join('&');\n        }\n    },\n    convertArrayToObject: function (_array){\n        var _object = {};\n        for(var i = 0, l = _array.length; i < l; i++){\n            _object[_array[i]] = _array[i];\n        }\n        return _object;\n    }\n};\n\n});","mage/adminhtml/wysiwyg/widget.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    \"jquery\",\n    \"tinymce\",\n    'Magento_Ui/js/modal/alert',\n    \"jquery/ui\",\n    \"mage/translate\",\n    \"mage/mage\",\n    \"mage/validation\",\n    \"mage/adminhtml/events\",\n    \"prototype\",\n    'Magento_Ui/js/modal/modal'\n], function(jQuery, tinyMCE, alert){\n\n    var widgetTools = {\n        getDivHtml: function(id, html) {\n            if (!html) html = '';\n            return '<div id=\"' + id + '\">' + html + '</div>';\n        },\n\n        onAjaxSuccess: function(transport) {\n            if (transport.responseText.isJSON()) {\n                var response = transport.responseText.evalJSON()\n                if (response.error) {\n                    throw response;\n                } else if (response.ajaxExpired && response.ajaxRedirect) {\n                    setLocation(response.ajaxRedirect);\n                }\n            }\n        },\n\n        dialogOpened : false,\n\n        getMaxZIndex: function() {\n            var max = 0, i;\n            var cn = document.body.childNodes;\n            for (i = 0; i < cn.length; i++) {\n                var el = cn[i];\n                var zIndex = el.nodeType == 1 ? parseInt(el.style.zIndex, 10) || 0 : 0;\n                if (zIndex < 10000) {\n                    max = Math.max(max, zIndex);\n                }\n            }\n            return max + 10;\n        },\n\n        openDialog: function(widgetUrl) {\n            if (this.dialogOpened) {\n                return\n            }\n            var oThis = this;\n            this.dialogWindow = jQuery('<div/>').modal({\n                title: jQuery.mage.__('Insert Widget...'),\n                type: 'slide',\n                buttons: [],\n                opened: function () {\n                    var dialog = jQuery(this).addClass('loading magento-message')\n                    new Ajax.Updater($(this), widgetUrl, {evalScripts: true, onComplete: function () {\n                            dialog.removeClass('loading');\n                        }\n                    });\n                },\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                    oThis.dialogOpened = false;\n                }\n            });\n            this.dialogOpened = true;\n            this.dialogWindow.modal('openModal');\n        }\n    };\n\n    var WysiwygWidget = {};\n    WysiwygWidget.Widget = Class.create();\n    WysiwygWidget.Widget.prototype = {\n\n        initialize: function(formEl, widgetEl, widgetOptionsEl, optionsSourceUrl, widgetTargetId) {\n            $(formEl).insert({bottom: widgetTools.getDivHtml(widgetOptionsEl)});\n            jQuery('#' + formEl).mage('validation', {\n                ignore: \".skip-submit\",\n                errorClass: 'mage-error'\n            });\n            this.formEl = formEl;\n            this.widgetEl = $(widgetEl);\n            this.widgetOptionsEl = $(widgetOptionsEl);\n            this.optionsUrl = optionsSourceUrl;\n            this.optionValues = new Hash({});\n            this.widgetTargetId = widgetTargetId;\n            if (typeof(tinyMCE) != \"undefined\" && tinyMCE.activeEditor) {\n                this.bMark = tinyMCE.activeEditor.selection.getBookmark();\n            }\n\n            Event.observe(this.widgetEl, \"change\", this.loadOptions.bind(this));\n\n            this.initOptionValues();\n        },\n\n        getOptionsContainerId: function() {\n            return this.widgetOptionsEl.id + '_' + this.widgetEl.value.gsub(/\\//, '_');\n        },\n\n        switchOptionsContainer: function(containerId) {\n            $$('#' + this.widgetOptionsEl.id + ' div[id^=' + this.widgetOptionsEl.id + ']').each(function(e) {\n                this.disableOptionsContainer(e.id);\n            }.bind(this));\n            if(containerId != undefined) {\n                this.enableOptionsContainer(containerId);\n            }\n            this._showWidgetDescription();\n        },\n\n        enableOptionsContainer: function(containerId) {\n            $$('#' + containerId + ' .widget-option').each(function(e) {\n                e.removeClassName('skip-submit');\n                if (e.hasClassName('obligatory')) {\n                    e.removeClassName('obligatory');\n                    e.addClassName('required-entry');\n                }\n            });\n            $(containerId).removeClassName('no-display');\n        },\n\n        disableOptionsContainer: function(containerId) {\n            if ($(containerId).hasClassName('no-display')) {\n                return;\n            }\n            $$('#' + containerId + ' .widget-option').each(function(e) {\n                // Avoid submitting fields of unactive container\n                if (!e.hasClassName('skip-submit')) {\n                    e.addClassName('skip-submit');\n                }\n                // Form validation workaround for unactive container\n                if (e.hasClassName('required-entry')) {\n                    e.removeClassName('required-entry');\n                    e.addClassName('obligatory');\n                }\n            });\n            $(containerId).addClassName('no-display');\n        },\n\n        // Assign widget options values when existing widget selected in WYSIWYG\n        initOptionValues: function() {\n\n            if (!this.wysiwygExists()) {\n                return false;\n            }\n\n            var e = this.getWysiwygNode();\n            if (e != undefined && e.id) {\n                var widgetCode = Base64.idDecode(e.id);\n                if (widgetCode.indexOf('{{widget') != -1) {\n                    this.optionValues = new Hash({});\n                    widgetCode.gsub(/([a-z0-9\\_]+)\\s*\\=\\s*[\\\"]{1}([^\\\"]+)[\\\"]{1}/i, function(match){\n                        if (match[1] == 'type') {\n                            this.widgetEl.value = match[2];\n                        } else {\n                            this.optionValues.set(match[1], match[2]);\n                        }\n                    }.bind(this));\n\n                    this.loadOptions();\n                }\n            }\n        },\n\n        loadOptions: function() {\n            if (!this.widgetEl.value) {\n                this.switchOptionsContainer();\n                return;\n            }\n\n            var optionsContainerId = this.getOptionsContainerId();\n            if ($(optionsContainerId) != undefined) {\n                this.switchOptionsContainer(optionsContainerId);\n                return;\n            }\n\n            this._showWidgetDescription();\n\n            var params = {widget_type: this.widgetEl.value, values: this.optionValues};\n            new Ajax.Request(this.optionsUrl,\n                {\n                    parameters: {widget: Object.toJSON(params)},\n                    onSuccess: function(transport) {\n                        try {\n                            widgetTools.onAjaxSuccess(transport);\n                            this.switchOptionsContainer();\n                            if ($(optionsContainerId) == undefined) {\n                                this.widgetOptionsEl.insert({bottom: widgetTools.getDivHtml(optionsContainerId, transport.responseText)});\n                            } else {\n                                this.switchOptionsContainer(optionsContainerId);\n                            }\n                        } catch(e) {\n                            alert({\n                                content: e.message\n                            });\n                        }\n                    }.bind(this)\n                }\n            );\n        },\n\n        _showWidgetDescription: function() {\n            var noteCnt = this.widgetEl.next().down('small');\n            var descrCnt = $('widget-description-' + this.widgetEl.selectedIndex);\n            if(noteCnt != undefined) {\n                var description = (descrCnt != undefined ? descrCnt.innerHTML : '');\n                noteCnt.update(description);\n            }\n        },\n\n        validateField: function() {\n            jQuery(this.widgetEl).valid();\n        },\n\n        insertWidget: function() {\n            jQuery('#' + this.formEl).validate({\n                ignore: \".skip-submit\",\n                errorClass: 'mage-error'\n            });\n\n            var validationResult = jQuery('#' + this.formEl).valid();\n            if (validationResult) {\n                var formElements = [];\n                var i = 0;\n                Form.getElements($(this.formEl)).each(function(e) {\n                    if(!e.hasClassName('skip-submit')) {\n                        formElements[i] = e;\n                        i++;\n                    }\n                });\n\n                // Add as_is flag to parameters if wysiwyg editor doesn't exist\n                var params = Form.serializeElements(formElements);\n                if (!this.wysiwygExists()) {\n                    params = params + '&as_is=1';\n                }\n\n                new Ajax.Request($(this.formEl).action,\n                    {\n                        parameters: params,\n                        onComplete: function(transport) {\n                            try {\n                                widgetTools.onAjaxSuccess(transport);\n                                widgetTools.dialogWindow.modal('closeModal');\n\n                                if (typeof(tinyMCE) != \"undefined\" && tinyMCE.activeEditor) {\n                                    tinyMCE.activeEditor.focus();\n                                    if (this.bMark) {\n                                        tinyMCE.activeEditor.selection.moveToBookmark(this.bMark);\n                                    }\n                                }\n\n                                this.updateContent(transport.responseText);\n                            } catch(e) {\n                                alert({\n                                    content: e.message\n                                });\n                            }\n                        }.bind(this)\n                    });\n            }\n        },\n\n        updateContent: function(content) {\n            if (this.wysiwygExists()) {\n                this.getWysiwyg().execCommand(\"mceInsertContent\", false, content);\n            } else {\n                var textarea = document.getElementById(this.widgetTargetId);\n                updateElementAtCursor(textarea, content);\n                varienGlobalEvents.fireEvent('tinymceChange');\n                jQuery(textarea).change();\n            }\n        },\n\n        wysiwygExists: function() {\n            return (typeof tinyMCE != 'undefined') && tinyMCE.get(this.widgetTargetId);\n        },\n\n        getWysiwyg: function() {\n            return tinyMCE.activeEditor;\n        },\n\n        getWysiwygNode: function() {\n            return tinyMCE.activeEditor.selection.getNode();\n        }\n    }\n\n    WysiwygWidget.chooser = Class.create();\n    WysiwygWidget.chooser.prototype = {\n\n        // HTML element A, on which click event fired when choose a selection\n        chooserId: null,\n\n        // Source URL for Ajax requests\n        chooserUrl: null,\n\n        // Chooser config\n        config: null,\n\n        // Chooser dialog window\n        dialogWindow: null,\n\n        // Chooser content for dialog window\n        dialogContent: null,\n\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n\n        initialize: function(chooserId, chooserUrl, config) {\n            this.chooserId = chooserId;\n            this.chooserUrl = chooserUrl;\n            this.config = config;\n        },\n\n        getResponseContainerId: function() {\n            return 'responseCnt' + this.chooserId;\n        },\n\n        getChooserControl: function() {\n            return $(this.chooserId + 'control');\n        },\n\n        getElement: function() {\n            return $(this.chooserId + 'value');\n        },\n\n        getElementLabel: function() {\n            return $(this.chooserId + 'label');\n        },\n\n        open: function() {\n            $(this.getResponseContainerId()).show();\n        },\n\n        close: function() {\n            $(this.getResponseContainerId()).hide();\n            this.closeDialogWindow();\n        },\n\n        choose: function(event) {\n            // Open dialog window with previously loaded dialog content\n            if (this.dialogContent) {\n                this.openDialogWindow(this.dialogContent);\n                return;\n            }\n            // Show or hide chooser content if it was already loaded\n            var responseContainerId = this.getResponseContainerId();\n\n            // Otherwise load content from server\n            new Ajax.Request(this.chooserUrl,\n                {\n                    parameters: {element_value: this.getElementValue(), element_label: this.getElementLabelText()},\n                    onSuccess: function(transport) {\n                        try {\n                            widgetTools.onAjaxSuccess(transport);\n                            this.dialogContent = widgetTools.getDivHtml(responseContainerId, transport.responseText);\n                            this.openDialogWindow(this.dialogContent);\n                        } catch(e) {\n                            alert({\n                                content: e.message\n                            });\n                        }\n                    }.bind(this)\n                }\n            );\n        },\n\n        openDialogWindow: function (content) {\n            this.dialogWindow = jQuery('<div/>').modal({\n                title: this.config.buttons.open,\n                type: 'slide',\n                buttons: [],\n                opened: function () {\n                    jQuery(this).addClass('magento-message');\n                },\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                    this.dialogWindow = null;\n                }\n            });\n\n            this.dialogWindow.modal('openModal').append(content);\n        },\n\n        closeDialogWindow: function () {\n            this.dialogWindow.modal('closeModal').remove();\n        },\n\n        getElementValue: function(value) {\n            return this.getElement().value;\n        },\n\n        getElementLabelText: function(value) {\n            return this.getElementLabel().innerHTML;\n        },\n\n        setElementValue: function(value) {\n            this.getElement().value = value;\n        },\n\n        setElementLabel: function(value) {\n            this.getElementLabel().innerHTML = value;\n        }\n    };\n\n    window.WysiwygWidget = WysiwygWidget;\n    window.widgetTools = widgetTools;\n});","mage/adminhtml/wysiwyg/tiny_mce/html5-schema.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /* eslint-disable max-len */\n\n    var schema = {\n        blockContent: [\n            'address', 'article', 'aside', 'blockquote', 'details', 'dialog', 'div', 'dl', 'fieldset',\n            'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr',\n            'menu', 'nav', 'ol', 'p', 'pre', 'section', 'table', 'ul'\n        ],\n        phrasingContent: [\n            '#comment', '#text', 'a', 'abbr', 'audio', 'b', 'bdi', 'bdo', 'br', 'button', 'canvas',\n            'cite','code', 'command', 'datalist', 'del', 'dfn', 'em', 'embed', 'i', 'iframe', 'img',\n            'input', 'ins', 'kbd', 'keygen', 'label', 'map', 'mark', 'meter', 'noscript', 'object',\n            'output', 'picture', 'progress', 'q', 'ruby', 's', 'samp', 'script', 'select', 'small',\n            'span', 'strong', 'sub', 'sup', 'textarea', 'time', 'u', 'var', 'video', 'wbr'\n        ],\n        blockElements: [\n            'address', 'article', 'aside', 'blockquote', 'caption', 'center', 'datalist', 'dd', 'dir', 'div',\n            'dl', 'dt', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6',\n            'header', 'hgroup', 'hr', 'isindex', 'li', 'menu', 'nav', 'noscript', 'ol', 'optgroup', 'option',\n            'p', 'pre', 'section', 'select', 'table', 'tbody', 'td', 'tfoot', 'th', 'thead', 'tr', 'ul'\n        ],\n        boolAttrs: [\n            'autoplay', 'checked', 'compact', 'controls', 'declare', 'defer', 'disabled', 'ismap', 'loop',\n            'multiple', 'nohref', 'noresize', 'noshade', 'nowrap', 'readonly', 'selected'\n        ],\n        shortEnded: [\n            'area', 'base', 'basefont', 'br', 'col', 'embed', 'frame', 'hr', 'img', 'input', 'isindex',\n            'link', 'meta', 'param', 'source', 'track', 'wbr'\n        ],\n        whiteSpace: [\n            'audio', 'iframe', 'noscript', 'object', 'pre', 'script', 'style', 'textarea', 'video'\n        ],\n        selfClosing: [\n            'colgroup', 'dd', 'dt', 'li', 'option', 'p', 'td', 'tfoot', 'th', 'thead', 'tr'\n        ]\n    };\n\n    schema.flowContent = schema.blockContent.concat(schema.phrasingContent, ['style']);\n    schema.nonEmpty = ['td', 'th', 'iframe', 'video', 'audio', 'object', 'script'].concat(schema.shortEnded);\n\n    _.extend(schema, (function (phrasingContent, flowContent) {\n        var validElements   = [],\n            validChildren   = [],\n            compiled        = {},\n            globalAttrs,\n            rawData;\n\n        globalAttrs = [\n            'id', 'dir', 'lang', 'class', 'style', 'title', 'hidden', 'onclick', 'onkeyup',\n            'tabindex', 'dropzone', 'accesskey', 'draggable', 'translate', 'onmouseup',\n            'onkeydown', 'spellcheck', 'ondblclick', 'onmouseout', 'onkeypress', 'contextmenu',\n            'onmousedown', 'onmouseover', 'onmousemove', 'contenteditable'\n        ];\n\n        rawData = [\n            ['html', 'manifest', 'head body'],\n            ['head', '', 'base command link meta noscript script style title'],\n            ['title hr noscript br'],\n            ['base', 'href target'],\n            ['link', 'href rel media hreflang type sizes hreflang'],\n            ['meta', 'name http-equiv content charset'],\n            ['style', 'media type scoped'],\n            ['script', 'src async defer type charset'],\n            ['body', 'onafterprint onbeforeprint onbeforeunload onblur onerror onfocus ' +\n                'onhashchange onload onmessage onoffline ononline onpagehide onpageshow ' +\n                'onpopstate onresize onscroll onstorage onunload background bgcolor text link vlink alink', flowContent\n            ],\n            ['caption', '', _.without(flowContent, 'table')],\n            ['address dt dd div', '', flowContent],\n            ['h1 h2 h3 h4 h5 h6 pre p abbr code var samp kbd sub sup i b u bdo span legend em strong small s cite dfn', '', phrasingContent],\n            ['blockquote', 'cite', flowContent],\n            ['ol', 'reversed start type', 'li'],\n            ['ul', 'type compact', 'li'],\n            ['li', 'value type', flowContent],\n            ['dl', '', 'dt dd'],\n            ['a', 'href target rel media hreflang type charset name rev shape coords download', phrasingContent],\n            ['q', 'cite', phrasingContent],\n            ['ins del', 'cite datetime', flowContent],\n            ['img', 'src sizes srcset alt usemap ismap width height name longdesc align border hspace vspace'],\n            ['iframe', 'src name width height longdesc frameborder marginwidth marginheight scrolling align sandbox seamless allowfullscreen', flowContent],\n            ['embed', 'src type width height'],\n            ['object', 'data type typemustmatch name usemap form width height declare classid code codebase codetype archive standby align border hspace vspace', flowContent.concat(['param'])],\n            ['param', 'name value valuetype type'],\n            ['map', 'name', flowContent.concat(['area'])],\n            ['area', 'alt coords shape href target rel media hreflang type nohref'],\n            ['table', 'border summary width frame rules cellspacing cellpadding align bgcolor', 'caption colgroup thead tfoot tbody tr col'],\n            ['colgroup', 'span width align char charoff valign', 'col'],\n            ['col', 'span'],\n            ['tbody thead tfoot', 'align char charoff valign', 'tr'],\n            ['tr', 'align char charoff valign bgcolor', 'td th'],\n            ['td', 'colspan rowspan headers abbr axis scope align char charoff valign nowrap bgcolor width height', flowContent],\n            ['th', 'colspan rowspan headers scope abbr axis align char charoff valign nowrap bgcolor width height accept', flowContent],\n            ['form', 'accept-charset action autocomplete enctype method name novalidate target onsubmit onreset', flowContent],\n            ['fieldset', 'disabled form name', flowContent.concat(['legend'])],\n            ['label', 'form for', phrasingContent],\n            ['input', 'accept alt autocomplete checked dirname disabled form formaction formenctype formmethod formnovalidate ' +\n                'formtarget height list max maxlength min multiple name pattern readonly required size src step type value width usemap align'\n            ],\n            ['button', 'disabled form formaction formenctype formmethod formnovalidate formtarget name type value', phrasingContent],\n            ['select', 'disabled form multiple name required size onfocus onblur onchange', 'option optgroup'],\n            ['optgroup', 'disabled label', 'option'],\n            ['option', 'disabled label selected value'],\n            ['textarea', 'cols dirname disabled form maxlength name readonly required rows wrap'],\n            ['menu', 'type label', flowContent.concat(['li'])],\n            ['noscript', '', flowContent],\n            ['wbr'],\n            ['ruby', '', phrasingContent.concat(['rt', 'rp'])],\n            ['figcaption', '', flowContent],\n            ['mark rt rp summary bdi', '', phrasingContent],\n            ['canvas', 'width height', flowContent],\n            ['video', 'src crossorigin poster preload autoplay mediagroup loop muted controls width height buffered', flowContent.concat(['track', 'source'])],\n            ['audio', 'src crossorigin preload autoplay mediagroup loop muted controls buffered volume', flowContent.concat(['track', 'source'])],\n            ['picture', '', 'img source'],\n            ['source', 'src srcset type media sizes'],\n            ['track', 'kind src srclang label default'],\n            ['datalist', '', phrasingContent.concat(['option'])],\n            ['article section nav aside header footer', '', flowContent],\n            ['hgroup', '', 'h1 h2 h3 h4 h5 h6'],\n            ['figure', '', flowContent.concat(['figcaption'])],\n            ['time', 'datetime', phrasingContent],\n            ['dialog', 'open', flowContent],\n            ['command', 'type label icon disabled checked radiogroup command'],\n            ['output', 'for form name', phrasingContent],\n            ['progress', 'value max', phrasingContent],\n            ['meter', 'value min max low high optimum', phrasingContent],\n            ['details', 'open', flowContent.concat(['summary'])],\n            ['keygen', 'autofocus challenge disabled form keytype name'],\n            ['script', 'language xml:space'],\n            ['style', 'xml:space'],\n            ['embed', 'align name hspace vspace'],\n            ['br', 'clear'],\n            ['applet', 'codebase archive code object alt name width height align hspace vspace'],\n            ['font basefont', 'size color face'],\n            ['h1 h2 h3 h4 h5 h6 div p legend caption', 'align'],\n            ['ol dl menu dir', 'compact'],\n            ['pre', 'width xml:space'],\n            ['hr', 'align noshade size width'],\n            ['isindex', 'prompt'],\n            ['col', 'width align char charoff valign'],\n            ['input button select textarea', 'autofocus'],\n            ['input textarea', 'placeholder onselect onchange onfocus onblur'],\n            ['link script img', 'crossorigin']\n        ];\n\n        rawData.forEach(function (data) {\n            var nodes       = data[0].split(' '),\n                attributes  = data[1] || [],\n                children    = data[2] || [],\n                ni          = nodes.length,\n                nodeName,\n                schemaData;\n\n            if (typeof attributes === 'string') {\n                attributes = attributes.split(' ');\n            }\n\n            if (typeof children === 'string') {\n                children = children.split(' ');\n            }\n\n            while (ni--) {\n                nodeName    = nodes[ni];\n                schemaData  = compiled[nodeName] || {};\n\n                compiled[nodeName] = {\n                    attributes: _.union(schemaData.attributes, globalAttrs, attributes),\n                    children: _.union(schemaData.children, children)\n                };\n            }\n        });\n\n        ['a', 'dfn', 'form', 'meter', 'progress'].forEach(function (nodeName) {\n            var node = compiled[nodeName];\n\n            node.children = _.without(node.children, nodeName);\n        });\n\n        _.each(compiled, function (node, nodeName) {\n            var attributes  = node.attributes.join('|'),\n                children    = node.children.join('|');\n\n            validElements.push(nodeName + '[' + attributes + ']');\n            validChildren.push(nodeName + '[' + children + ']');\n        });\n\n        return {\n            nodes: compiled,\n            validElements: validElements,\n            validChildren: validChildren\n        };\n    })(schema.phrasingContent, schema.flowContent));\n\n    return schema;\n});\n","mage/adminhtml/wysiwyg/tiny_mce/setup.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'tinymce',\n    'mage/adminhtml/wysiwyg/tiny_mce/html5-schema',\n    'mage/translate',\n    'prototype',\n    'mage/adminhtml/events',\n    'mage/adminhtml/browser'\n], function(jQuery, _, tinyMCE, html5Schema) {\n\n    tinyMceWysiwygSetup = Class.create();\n\n    tinyMceWysiwygSetup.prototype = {\n        mediaBrowserOpener: null,\n        mediaBrowserTargetElementId: null,\n\n        initialize: function(htmlId, config) {\n            if (config.baseStaticUrl && config.baseStaticDefaultUrl) {\n                tinyMCE.baseURL = tinyMCE.baseURL.replace(config.baseStaticUrl, config.baseStaticDefaultUrl);\n            }\n\n            this.id = htmlId;\n            this.config = config;\n            this.schema = config.schema || html5Schema;\n\n            _.bindAll(this, 'beforeSetContent', 'saveContent', 'onChangeContent', 'openFileBrowser', 'updateTextArea');\n\n            varienGlobalEvents.attachEventHandler('tinymceChange', this.onChangeContent);\n            varienGlobalEvents.attachEventHandler('tinymceBeforeSetContent', this.beforeSetContent);\n            varienGlobalEvents.attachEventHandler('tinymceSetContent', this.updateTextArea);\n            varienGlobalEvents.attachEventHandler('tinymceSaveContent', this.saveContent);\n\n            if (typeof tinyMceEditors == 'undefined') {\n                tinyMceEditors = $H({});\n            }\n\n            tinyMceEditors.set(this.id, this);\n        },\n\n        setup: function(mode) {\n            if (this.config.widget_plugin_src) {\n                tinyMCE.PluginManager.load('magentowidget', this.config.widget_plugin_src);\n            }\n\n            if (this.config.plugins) {\n                this.config.plugins.each(function(plugin) {\n                    tinyMCE.PluginManager.load(plugin.name, plugin.src);\n                });\n            }\n\n            tinyMCE.init(this.getSettings(mode));\n        },\n\n        getSettings: function(mode) {\n            var plugins = 'inlinepopups,safari,pagebreak,style,layer,table,advhr,advimage,emotions,iespell,media,searchreplace,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras',\n                self = this;\n\n            if (this.config.widget_plugin_src) {\n                plugins = 'magentowidget,' + plugins;\n            }\n\n            var magentoPluginsOptions = $H({});\n            var magentoPlugins = '';\n\n            if (this.config.plugins) {\n                this.config.plugins.each(function(plugin) {\n                    magentoPlugins = plugin.name + ',' + magentoPlugins;\n                    magentoPluginsOptions.set(plugin.name, plugin.options);\n                });\n                if (magentoPlugins) {\n                    plugins = '-' + magentoPlugins + plugins;\n                }\n            }\n\n            var settings = {\n                mode: (mode != undefined ? mode : 'none'),\n                elements: this.id,\n                theme: 'advanced',\n                plugins: plugins,\n                theme_advanced_buttons1: magentoPlugins + 'magentowidget,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,styleselect,formatselect,fontselect,fontsizeselect',\n                theme_advanced_buttons2: 'cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,|,forecolor,backcolor',\n                theme_advanced_buttons3: 'tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,iespell,media,advhr,|,ltr,rtl,|,fullscreen',\n                theme_advanced_buttons4: 'insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,pagebreak',\n                theme_advanced_toolbar_location: 'top',\n                theme_advanced_toolbar_align: 'left',\n                theme_advanced_statusbar_location: 'bottom',\n                valid_elements: this.schema.validElements.join(','),\n                valid_children: this.schema.validChildren.join(','),\n                theme_advanced_resizing: true,\n                theme_advanced_resize_horizontal: false,\n                convert_urls: false,\n                relative_urls: false,\n                content_css: this.config.content_css,\n                custom_popup_css: this.config.popup_css,\n                magentowidget_url: this.config.widget_window_url,\n                magentoPluginsOptions: magentoPluginsOptions,\n                doctype: '<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">',\n                setup: function(ed){\n                    ed.onInit.add(self.onEditorInit.bind(self));\n\n                    ed.onSubmit.add(function(ed, e) {\n                        varienGlobalEvents.fireEvent('tinymceSubmit', e);\n                    });\n\n                    ed.onPaste.add(function(ed, e, o) {\n                        varienGlobalEvents.fireEvent('tinymcePaste', o);\n                    });\n\n                    ed.onBeforeSetContent.add(function(ed, o) {\n                        varienGlobalEvents.fireEvent('tinymceBeforeSetContent', o);\n                    });\n\n                    ed.onSetContent.add(function(ed, o) {\n                        varienGlobalEvents.fireEvent('tinymceSetContent', o);\n                    });\n\n                    ed.onSaveContent.add(function(ed, o) {\n                        varienGlobalEvents.fireEvent('tinymceSaveContent', o);\n                    });\n\n                    var onChange = function(ed, l) {\n                        varienGlobalEvents.fireEvent('tinymceChange', l);\n                    };\n\n                    ed.onChange.add(onChange);\n                    ed.onKeyUp.add(onChange);\n\n                    ed.onExecCommand.add(function(ed, cmd, ui, val) {\n                        varienGlobalEvents.fireEvent('tinymceExecCommand', cmd);\n                    });\n                }\n            };\n\n            // Set the document base URL\n            if (this.config.document_base_url) {\n                settings.document_base_url = this.config.document_base_url;\n            }\n\n            if (this.config.files_browser_window_url) {\n                settings.file_browser_callback = function(fieldName, url, objectType, w) {\n                    varienGlobalEvents.fireEvent(\"open_browser_callback\", {\n                        win: w,\n                        type: objectType,\n                        field: fieldName\n                    });\n                };\n            }\n\n            if (this.config.width) {\n                settings.width = this.config.width;\n            }\n\n            if (this.config.height) {\n                settings.height = this.config.height;\n            }\n\n            if (this.config.settings) {\n                Object.extend(settings, this.config.settings)\n            }\n\n            return settings;\n        },\n\n        applySchema: function (editor) {\n            var schema      = editor.schema,\n                schemaData  = this.schema,\n                makeMap     = tinyMCE.makeMap;\n\n            jQuery.extend(true, {\n                nonEmpty: schema.getNonEmptyElements(),\n                boolAttrs: schema.getBoolAttrs(),\n                whiteSpace: schema.getWhiteSpaceElements(),\n                shortEnded: schema.getShortEndedElements(),\n                selfClosing: schema.getSelfClosingElements(),\n                blockElements: schema.getBlockElements()\n            }, {\n                nonEmpty: makeMap(schemaData.nonEmpty),\n                boolAttrs: makeMap(schemaData.boolAttrs),\n                whiteSpace: makeMap(schemaData.whiteSpace),\n                shortEnded: makeMap(schemaData.shortEnded),\n                selfClosing: makeMap(schemaData.selfClosing),\n                blockElements: makeMap(schemaData.blockElements)\n            });\n        },\n\n        openFileBrowser: function(o) {\n            var typeTitle,\n                storeId = this.config.store_id !== null ? this.config.store_id : 0,\n                frameDialog = jQuery(o.win.frameElement).parents('[role=\"dialog\"]'),\n                wUrl = this.config.files_browser_window_url +\n                'target_element_id/' + this.id + '/' +\n                'store/' + storeId + '/';\n\n            this.mediaBrowserOpener = o.win;\n            this.mediaBrowserTargetElementId = o.field;\n\n            if (typeof(o.type) != 'undefined' && o.type != \"\") {\n                typeTitle = 'image' == o.type ? this.translate('Insert Image...') : this.translate('Insert Media...');\n                wUrl = wUrl + \"type/\" + o.type + \"/\";\n            } else {\n                typeTitle = this.translate('Insert File...');\n            }\n\n            frameDialog.hide();\n            jQuery('#mceModalBlocker').hide();\n\n            MediabrowserUtility.openDialog(wUrl, false, false, typeTitle, {\n                closed: function() {\n                    frameDialog.show();\n                    jQuery('#mceModalBlocker').show();\n                }\n            });\n        },\n\n        translate: function(string) {\n            return jQuery.mage.__ ? jQuery.mage.__(string) : string;\n        },\n\n        getMediaBrowserOpener: function() {\n            return this.mediaBrowserOpener;\n        },\n\n        getMediaBrowserTargetElementId: function() {\n            return this.mediaBrowserTargetElementId;\n        },\n\n        getToggleButton: function() {\n            return $('toggle' + this.id);\n        },\n\n        getPluginButtons: function() {\n            return $$('#buttons' + this.id + ' > button.plugin');\n        },\n\n        turnOn: function(mode) {\n            this.closePopups();\n\n            this.setup(mode);\n\n            tinyMCE.execCommand('mceAddControl', false, this.id);\n\n            this.getPluginButtons().each(function(e) {\n                e.hide();\n            });\n\n            return this;\n        },\n\n        turnOff: function() {\n            this.closePopups();\n\n            tinyMCE.execCommand('mceRemoveControl', false, this.id);\n\n            this.getPluginButtons().each(function(e) {\n                e.show();\n            });\n\n            return this;\n        },\n\n        closePopups: function() {\n            if (typeof closeEditorPopup == 'function') {\n                // close all popups to avoid problems with updating parent content area\n                closeEditorPopup('widget_window' + this.id);\n                closeEditorPopup('browser_window' + this.id);\n            }\n        },\n\n        toggle: function() {\n            if (!tinyMCE.get(this.id)) {\n                this.turnOn();\n                return true;\n            } else {\n                this.turnOff();\n                return false;\n            }\n        },\n\n        onEditorInit: function (editor) {\n            this.applySchema(editor);\n        },\n\n        onFormValidation: function() {\n            if (tinyMCE.get(this.id)) {\n                $(this.id).value = tinyMCE.get(this.id).getContent();\n            }\n        },\n\n        onChangeContent: function() {\n            // Add \"changed\" to tab class if it exists\n            this.updateTextArea();\n\n            if (this.config.tab_id) {\n                var tab = $$('a[id$=' + this.config.tab_id + ']')[0];\n                if ($(tab) != undefined && $(tab).hasClassName('tab-item-link')) {\n                    $(tab).addClassName('changed');\n                }\n            }\n        },\n\n        // retrieve directives URL with substituted directive value\n        makeDirectiveUrl: function(directive) {\n            return this.config.directives_url.replace('directive', 'directive/___directive/' + directive);\n        },\n\n        encodeDirectives: function(content) {\n            // collect all HTML tags with attributes that contain directives\n            return content.gsub(/<([a-z0-9\\-\\_]+.+?)([a-z0-9\\-\\_]+=\".*?\\{\\{.+?\\}\\}.*?\".+?)>/i, function(match) {\n                var attributesString = match[2];\n                // process tag attributes string\n                attributesString = attributesString.gsub(/([a-z0-9\\-\\_]+)=\"(.*?)(\\{\\{.+?\\}\\})(.*?)\"/i, function(m) {\n                    return m[1] + '=\"' + m[2] + this.makeDirectiveUrl(Base64.mageEncode(m[3])) + m[4] + '\"';\n                }.bind(this));\n\n                return '<' + match[1] + attributesString + '>';\n\n            }.bind(this));\n        },\n\n        encodeWidgets: function(content) {\n            return content.gsub(/\\{\\{widget(.*?)\\}\\}/i, function(match) {\n                var attributes = this.parseAttributesString(match[1]);\n                if (attributes.type) {\n                    attributes.type = attributes.type.replace(/\\\\\\\\/g, \"\\\\\");\n                    var imageSrc = this.config.widget_placeholders[attributes.type];\n                    var imageHtml = '<img';\n                    imageHtml += ' id=\"' + Base64.idEncode(match[0]) + '\"';\n                    imageHtml += ' src=\"' + imageSrc + '\"';\n                    imageHtml += ' title=\"' + match[0].replace(/\\{\\{/g, '{').replace(/\\}\\}/g, '}').replace(/\\\"/g, '&quot;') + '\"';\n                    imageHtml += '>';\n\n                    return imageHtml;\n                }\n            }.bind(this));\n        },\n\n        decodeDirectives: function(content) {\n            // escape special chars in directives url to use it in regular expression\n            var url = this.makeDirectiveUrl('%directive%').replace(/([$^.?*!+:=()\\[\\]{}|\\\\])/g, '\\\\$1');\n            var reg = new RegExp(url.replace('%directive%', '([a-zA-Z0-9,_-]+)'));\n            return content.gsub(reg, function(match) {\n                return Base64.mageDecode(match[1]);\n            }.bind(this));\n        },\n\n        decodeWidgets: function(content) {\n            return content.gsub(/<img([^>]+id=\\\"[^>]+)>/i, function(match) {\n                var attributes = this.parseAttributesString(match[1]);\n                if (attributes.id) {\n                    var widgetCode = Base64.idDecode(attributes.id);\n                    if (widgetCode.indexOf('{{widget') != -1) {\n                        return widgetCode;\n                    }\n                    return match[0];\n                }\n                return match[0];\n            }.bind(this));\n        },\n\n        parseAttributesString: function(attributes) {\n            var result = {};\n            attributes.gsub(/(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/, function(match) {\n                result[match[1]] = match[2];\n            });\n            return result;\n        },\n\n        updateTextArea: function () {\n            var editor = tinyMCE.get(this.id),\n                content;\n\n            if (!editor) {\n                return;\n            }\n\n            content = editor.getContent();\n            content = this.decodeContent(content);\n\n            jQuery('#' + this.id).val(content).trigger('change');\n        },\n\n        decodeContent: function (content) {\n            var result = content;\n\n            if (this.config.add_widgets) {\n                result = this.decodeWidgets(result);\n                result = this.decodeDirectives(result);\n            } else if (this.config.add_directives) {\n                result = this.decodeDirectives(result);\n            }\n\n            return result;\n        },\n\n        encodeContent: function (content) {\n            var result = content;\n\n            if (this.config.add_widgets) {\n                result = this.encodeWidgets(result);\n                result = this.encodeDirectives(result);\n            } else if (this.config.add_directives) {\n                result = this.encodeDirectives(result);\n            }\n\n            return result;\n        },\n\n        beforeSetContent: function(o){\n            o.content = this.encodeContent(o.content);\n        },\n\n        saveContent: function(o) {\n            o.content = this.decodeContent(o.content);\n        }\n    };\n});\n","mage/adminhtml/wysiwyg/tiny_mce/plugins/magentowidget/editor_plugin.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ntinyMCE.addI18n({en:{\n    magentowidget:\n    {\n        insert_widget : \"Insert Widget\"\n    }\n}});\n\n/*\n    TODO: Apply JStrim to reduce file size\n*/\n\n(function() {\n    tinymce.create('tinymce.plugins.MagentowidgetPlugin', {\n        /**\n         * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.\n         * @param {string} url Absolute URL to where the plugin is located.\n         */\n        init : function(ed, url) {\n            ed.addCommand('mceMagentowidget', function() {\n                widgetTools.openDialog(ed.settings.magentowidget_url + 'widget_target_id/' + ed.getElement().id + '/');\n            });\n\n            // Register Widget plugin button\n            ed.addButton('magentowidget', {\n                title : 'magentowidget.insert_widget',\n                cmd : 'mceMagentowidget',\n                image : url + '/img/icon.gif'\n            });\n\n            // Add a node change handler, selects the button in the UI when a image is selected\n            ed.onNodeChange.add(function(ed, cm, n) {\n                cm.setActive('magentowidget', false);\n                if (n.id && n.nodeName == 'IMG') {\n                    var widgetCode = Base64.idDecode(n.id);\n                    if (widgetCode.indexOf('{{widget') != -1) {\n                        cm.setActive('magentowidget', true);\n                    }\n                }\n            });\n\n            // Add a widget placeholder image double click callback\n            ed.onDblClick.add(function(ed, e) {\n                var n = e.target;\n                if (n.id && n.nodeName == 'IMG') {\n                    var widgetCode = Base64.idDecode(n.id);\n                    if (widgetCode.indexOf('{{widget') != -1) {\n                        ed.execCommand('mceMagentowidget');\n                    }\n                }\n            });\n        },\n\n        getInfo : function() {\n            return {\n                longname : 'Magento Widget Manager Plugin for TinyMCE 3.x',\n                author : 'Magento Core Team',\n                authorurl : 'http://magentocommerce.com',\n                infourl : 'http://magentocommerce.com',\n                version : \"1.0\"\n            };\n        }\n    });\n\n    // Register plugin\n    tinymce.PluginManager.add('magentowidget', tinymce.plugins.MagentowidgetPlugin);\n})();\n","mage/apply/main.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    './scripts'\n], function (_, $, processScripts) {\n    'use strict';\n\n    var dataAttr = 'data-mage-init',\n        nodeSelector = '[' + dataAttr + ']';\n\n    /**\n     * Initializes components assigned to a specified element via data-* attribute.\n     *\n     * @param {HTMLElement} el - Element to initialize components with.\n     * @param {Object|String} config - Initial components' config.\n     * @param {String} component - Components' path.\n     */\n    function init(el, config, component) {\n        require([component], function (fn) {\n\n            if (typeof fn === 'object') {\n                fn = fn[component].bind(fn);\n            }\n\n            if (_.isFunction(fn)) {\n                fn(config, el);\n            } else if ($(el)[component]) {\n                $(el)[component](config);\n            }\n        });\n    }\n\n    /**\n     * Parses elements 'data-mage-init' attribute as a valid JSON data.\n     * Note: data-mage-init attribute will be removed.\n     *\n     * @param {HTMLElement} el - Element whose attribute should be parsed.\n     * @returns {Object}\n     */\n    function getData(el) {\n        var data = el.getAttribute(dataAttr);\n\n        el.removeAttribute(dataAttr);\n\n        return {\n            el: el,\n            data: JSON.parse(data)\n        };\n    }\n\n    return {\n        /**\n         * Initializes components assigned to HTML elements via [data-mage-init].\n         *\n         * @example Sample 'data-mage-init' declaration.\n         *      data-mage-init='{\"path/to/component\": {\"foo\": \"bar\"}}'\n         */\n        apply: function () {\n            var virtuals = processScripts(),\n                nodes = document.querySelectorAll(nodeSelector);\n\n            _.toArray(nodes)\n                .map(getData)\n                .concat(virtuals)\n                .forEach(function (itemContainer) {\n                    var element = itemContainer.el;\n\n                    _.each(itemContainer.data, function (obj, key) {\n                            if (obj.mixins) {\n                                require(obj.mixins, function () {\n                                    for (var i = 0, len = arguments.length; i < len; i++) {\n                                        $.extend(true, itemContainer.data[key], arguments[i](itemContainer.data[key], element));\n                                    }\n\n                                    delete obj.mixins;\n                                    init.call(null, element, obj, key);\n                                });\n                            } else {\n                                init.call(null, element, obj, key);\n                            }\n\n                        }\n                    );\n\n                });\n        },\n        applyFor: init\n    };\n});\n","mage/apply/scripts.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery'\n], function (_, $) {\n    'use strict';\n\n    var scriptSelector = 'script[type=\"text/x-magento-init\"]',\n        dataAttr = 'data-mage-init',\n        virtuals = [];\n\n    /**\n     * Adds components to the virtula list.\n     *\n     * @param {Object} components\n     */\n    function addVirtual(components) {\n        virtuals.push({\n            el: false,\n            data: components\n        });\n    }\n\n    /**\n     * Merges provided data with a current data\n     * of a elements' \"data-mage-init\" attribute.\n     *\n     * @param {Object} components - Object with components and theirs configuration.\n     * @param {HTMLElement} elem - Element whose data should be modified.\n     */\n    function setData(components, elem) {\n        var data = elem.getAttribute(dataAttr);\n\n        data = !!data ? JSON.parse(data) : {};\n        _.each(components, function(obj, key) {\n            if (_.has(obj, 'mixins')) {\n                data[key] = data[key] || {};\n                data[key].mixins = data[key].mixins || [];\n                data[key].mixins = data[key].mixins.concat(obj.mixins);\n                delete obj.mixins;\n            }\n        });\n\n        data = $.extend(true, data, components);\n        data = JSON.stringify(data);\n        elem.setAttribute(dataAttr, data);\n    }\n\n    /**\n     * Search for the elements by privded selector and extends theirs data.\n     *\n     * @param {Object} components - Object with components and theirs configuration.\n     * @param {String} selector - Selector for the elements.\n     */\n    function processElems(components, selector) {\n        var elems,\n            iterator;\n\n        if (selector === '*') {\n            addVirtual(components);\n\n            return;\n        }\n\n        elems = document.querySelectorAll(selector);\n        iterator = setData.bind(null, components);\n\n        _.toArray(elems).forEach(iterator);\n    }\n\n    /**\n     * Parses content of a provided script node.\n     * Note: node will be removed from DOM.\n     *\n     * @param {HTMLScriptElement} node - Node to be processed.\n     * @returns {Object}\n     */\n    function getNodeData(node) {\n        var data = node.textContent;\n\n        node.parentNode.removeChild(node);\n\n        return JSON.parse(data);\n    }\n\n    /**\n     * Parses 'script' tags with a custom type attribute and moves it's data\n     * to a 'data-mage-init' attribute of an elemennt found by provided selector.\n     * Note: All found script nodes will be removed from DOM.\n     *\n     * @returns {Array} An array of components not assigned to the specific element.\n     *\n     * @example Sample declaration.\n     *      <script type=\"text/x-magento-init\">\n     *          {\n     *              \"body\": {\n     *                  \"path/to/component\": {\"foo\": \"bar\"}\n     *              }\n     *          }\n     *      </script>\n     *\n     * @example Providing data without selector.\n     *      {\n     *          \"*\": {\n     *              \"path/to/component\": {\"bar\": \"baz\"}\n     *          }\n     *      }\n     */\n    return function () {\n        var nodes = document.querySelectorAll(scriptSelector);\n\n        _.toArray(nodes)\n            .map(getNodeData)\n            .forEach(function (item) {\n                _.each(item, processElems);\n            });\n\n        return virtuals.splice(0, virtuals.length);\n    };\n});\n","mage/backend/action-link.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.actionLink', {\n        /**\n         * Button creation\n         * @protected\n         */\n        _create: function() {\n            this._bind();\n        },\n\n        /**\n         * Bind handler on button click\n         * @protected\n         */\n        _bind: function() {\n            var keyCode = $.ui.keyCode;\n            this._on({\n                mousedown: function(e){\n                    this._stopPropogation(e);\n                },\n                mouseup: function(e){\n                    this._stopPropogation(e);\n                },\n                click: function(e) {\n                    this._stopPropogation(e);\n                    this._triggerEvent();\n                },\n                keydown: function(e) {\n                    switch (e.keyCode) {\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._stopPropogation(e);\n                            this._triggerEvent();\n                            break;\n                    }\n                },\n                keyup: function(e) {\n                    switch (e.keyCode) {\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._stopPropogation(e);\n                            break;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @private\n         */\n        _stopPropogation: function(e) {\n            e.stopImmediatePropagation();\n            e.preventDefault();\n        },\n\n        /**\n         * @private\n         */\n        _triggerEvent: function() {\n            $(this.options.related || this.element)\n                .trigger(this.options.event, this.options.eventData ? [this.options.eventData] : [{}]);\n        }\n    });\n    \n    return $.mage.actionLink;\n});\n","mage/backend/bootstrap.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true browser:true */\n/*global FORM_KEY:true*/\ndefine([\n    'jquery',\n    'mage/apply/main',\n    'Magento_Ui/js/lib/knockout/bootstrap',\n    'mage/mage'\n], function($, mage){\n    'use strict';\n\n    $.ajaxSetup({\n        /*\n         * @type {string}\n         */\n        type: 'POST',\n\n        /*\n         * Ajax before send callback\n         * @param {Object} The jQuery XMLHttpRequest object returned by $.ajax()\n         * @param {Object}\n         */\n        beforeSend: function(jqXHR, settings) {\n            var form_key = typeof FORM_KEY !== 'undefined' ? FORM_KEY : null;\n            if (!settings.url.match(new RegExp('[?&]isAjax=true',''))) {\n                settings.url = settings.url.match(\n                    new RegExp('\\\\?',\"g\")) ?\n                    settings.url + '&isAjax=true' :\n                    settings.url + '?isAjax=true';\n            }\n            if (!settings.data) {\n                settings.data = {\n                    form_key: form_key\n                };\n            } else if ($.type(settings.data) === \"string\" &&\n                settings.data.indexOf('form_key=') === -1) {\n                settings.data += '&' + $.param({\n                    form_key: form_key\n                });\n            } else if($.isPlainObject(settings.data) && !settings.data.form_key) {\n                settings.data.form_key = form_key;\n            }\n        },\n\n        /*\n         * Ajax complete callback\n         * @param {Object} The jQuery XMLHttpRequest object returned by $.ajax()\n         * @param {string}\n         */\n        complete: function(jqXHR) {\n            if (jqXHR.readyState === 4) {\n                try {\n                    var jsonObject = $.parseJSON(jqXHR.responseText);\n                    if (jsonObject.ajaxExpired && jsonObject.ajaxRedirect) {\n                        window.location.replace(jsonObject.ajaxRedirect);\n                    }\n                } catch(e) {}\n            }\n        }\n    });\n\n    var bootstrap = function() {\n        /**\n         * Init all components defined via data-mage-init attribute\n         * and subscribe init action on contentUpdated event\n         */\n        mage.apply();\n\n        /*\n         * Initialization of notification widget\n         */\n        $('body').mage('notification');\n    };\n\n    $(bootstrap);\n});\n","mage/backend/button.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global require:true*/\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    $.widget('ui.button', $.ui.button, {\n        options: {\n            eventData: {},\n            waitTillResolved: true\n        },\n\n        /**\n         * Button creation.\n         * @protected\n         */\n        _create: function () {\n            if (this.options.event) {\n                this.options.target = this.options.target || this.element;\n                this._bind();\n            }\n\n            this._super();\n        },\n\n        /**\n         * Bind handler on button click.\n         * @protected\n         */\n        _bind: function () {\n            this.element\n                .off('click.button')\n                .on('click.button', $.proxy(this._click, this));\n        },\n\n        /**\n         * Button click handler.\n         * @protected\n         */\n        _click: function () {\n            var options = this.options;\n\n            $(options.target).trigger(options.event, [options.eventData]);\n        }\n    });\n\n    return $.ui.button;\n}));\n","mage/backend/editablemultiselect.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    \"jquery/editableMultiselect/js/jquery.editable\",\n    \"jquery/editableMultiselect/js/jquery.multiselect\"\n], function($, alert, confirm){\n\n\n    /**\n     * Editable multiselect wrapper for multiselects\n     *\n     * This class is defined in global scope ('var' is not needed)\n     *\n     * @param String settings[add_button_caption] caption of the 'Add New Value' button\n     * @param String settings[new_url] URL to which new request has to be submitted\n     * @param String settings[save_url] URL to which save request has to be submitted\n     * @param String settings[delete_url] URL to which delete request has to be submitted\n     * @param String settings[delete_confirm_message] confirmation message that is shown to user during delete operation\n     * @param String settings[target_select_id] HTML ID of target select element\n     * @param Hash settings[submit_data] extra parameters to send with new/edit/delete requests\n     * @param String settings[entity_value_name] name of the request parameter that represents select option text\n     * @param String settings[entity_id_name] name of the request parameter that represents select option value\n     * @param Boolean settings[is_entry_editable] flag that shows if user can add/edit/remove data\n     *\n     * @constructor\n     */\n    EditableMultiselect = function(settings) {\n\n        this.settings = settings || {};\n        this.addButtonCaption = this.settings.add_button_caption || 'Add new value';\n        this.newUrl = this.settings.new_url;\n        this.saveUrl = this.settings.save_url;\n        this.deleteUrl = this.settings.delete_url;\n        this.deleteConfirmMessage = this.settings.delete_confirm_message;\n        this.targetSelectId = this.settings.target_select_id;\n        this.submitData = this.settings.submit_data || {};\n        this.entityIdName = this.settings.entity_id_name || 'entity_id';\n        this.entityValueName = this.settings.entity_value_name || 'entity_value';\n        this.isEntityEditable = this.settings.is_entity_editable || false;\n\n        /**\n         * Initialize editable multiselect (make it visible in UI)\n         */\n        EditableMultiselect.prototype.init = function() {\n            var self = this;\n            var mselectOptions = {\n                addText: this.addButtonCaption,\n                mselectInputSubmitCallback: function (value, options) {\n                    self.createEntity(value, options);\n                }\n            };\n\n            if (!this.isEntityEditable) {\n                // Override default layout of editable multiselect\n                mselectOptions.layout = '<section class=\"block %mselectListClass%\">' +\n                    '<div class=\"block-content\"><div class=\"%mselectItemsWrapperClass%\">' +\n                    '%items%' +\n                    '</div></div>' +\n                    '<div class=\"%mselectInputContainerClass%\">' +\n                    '<input type=\"text\" class=\"%mselectInputClass%\" title=\"%inputTitle%\"/>' +\n                    '<span class=\"%mselectButtonCancelClass%\" title=\"%cancelText%\"></span>' +\n                    '<span class=\"%mselectButtonSaveClass%\" title=\"Add\"></span>' +\n                    '</div>' +\n                    '</section>';\n            }\n\n            $('#' + this.targetSelectId).multiselect(mselectOptions);\n\n            // Make multiselect editable if needed\n            if (this.isEntityEditable) {\n                this.makeMultiselectEditable();\n\n                // Root element of HTML markup that represents select element in UI\n                var mselectList = $('#' + this.targetSelectId).next();\n                this.attachEventsToControls(mselectList);\n            }\n        };\n\n        /**\n         * Attach required event handlers to control elements of editable multiselect\n         *\n         * @param mselectList\n         */\n        EditableMultiselect.prototype.attachEventsToControls = function (mselectList)\n        {\n            mselectList.on(\"click.mselect-delete\", '.mselect-delete', {container: this}, function(event) {\n                // Pass the clicked button to container\n                event.data.container.deleteEntity({delete_button: this});\n            });\n\n            mselectList.on('click.mselect-checked', '.mselect-list-item input', {container: this}, function (event) {\n                var el = $(this),\n                    checkedClassName = 'mselect-checked';\n                el[el.is(':checked') ? 'addClass' : 'removeClass'](checkedClassName);\n                event.data.container.makeMultiselectEditable();\n            });\n\n            mselectList.on('click.mselect-edit', '.mselect-edit', {container: this}, function (event) {\n                event.data.container.makeMultiselectEditable();\n                $(this).parent().find('label span').trigger(\"dblclick\");\n            });\n        };\n\n        /**\n         * Make multiselect editable\n         */\n        EditableMultiselect.prototype.makeMultiselectEditable = function() {\n            var entityIdName = this.entityIdName,\n                entityValueName = this.entityValueName,\n                selectList = $('#' + this.targetSelectId).next();\n            selectList.find('.mselect-list-item:not(.mselect-list-item-not-editable) label span').editable(this.saveUrl,\n            {\n                type: 'text',\n                submit: '<button class=\"mselect-save\" title=\"Save\" type=\"submit\" />',\n                cancel: '<span class=\"mselect-cancel\" title=\"Cancel\"></span>',\n                event: 'dblclick',\n                placeholder: '',\n                isChecked: function(settings) {\n                    var that = $(this);\n                    if (!that.closest('.mselect-list-item').hasClass('mselect-disabled')) {\n                        var checked = that.parent().find('[type=checkbox]').prop('disabled');\n                        that.parent().find('[type=checkbox]').prop({\n                            disabled: !checked\n                        });\n                    }\n                },\n                data: function(value, settings) {\n                    settings.isChecked.apply(this, [settings]);\n                    if (typeof value === 'string') {\n                        var retval = value.unescapeHTML();\n                        return (retval);\n                    }\n                    return value;\n                },\n                submitdata: this.submitData,\n                onblur: 'cancel',\n                name: entityValueName,\n                ajaxoptions: {\n                    dataType: 'json'\n                },\n\n                onsubmit: function (settings, original) {\n                    var select = $(original).closest('.mselect-list').prev(),\n                        current = $(original).closest('.mselect-list-item').index(),\n                        entityId = select.find('option').eq(current).val();\n                    // Add entity ID to AJAX request params\n                    var entityInfo = {};\n                    entityInfo[entityIdName] = entityId;\n                    settings.submitdata = $.extend(settings.submitdata || {}, entityInfo);\n                },\n\n                callback: function (result, settings) {\n                    settings.isChecked.apply(this, [settings]);\n                    var select = $(this).closest('.mselect-list').prev(),\n                        current = $(this).closest('.mselect-list-item').index();\n                    if (result.success) {\n                        if (typeof result[entityValueName] === 'string') {\n                            select.find('option').eq(current).val(result[entityIdName]).text(result[entityValueName]);\n                            $(this).html(result[entityValueName].escapeHTML());\n                        }\n                    } else {\n                        alert({\n                            content: result.error_message\n                        });\n                    }\n                }\n            });\n        };\n\n        /**\n         * Callback function that is called when admin adds new value to select\n         *\n         * @param value\n         * @param options - list of settings of multiselect\n         */\n        EditableMultiselect.prototype.createEntity = function(value, options) {\n            if (!value) {\n                return;\n            }\n            var select = $('#' + this.targetSelectId),\n                entityIdName = this.entityIdName,\n                entityValueName = this.entityValueName,\n                entityInfo = {};\n            entityInfo[entityIdName] = null;\n            entityInfo[entityValueName] = value;\n\n            var postData = $.extend(entityInfo, this.submitData);\n\n            var ajaxOptions = {\n                type: 'POST',\n                data: postData,\n                dataType: 'json',\n                url: this.newUrl,\n                success: function(result, status) {\n                    if (result.success) {\n                        var resultEntityValueName=\"\";\n                        if (typeof result[entityValueName] === 'string') {\n                            resultEntityValueName=result[entityValueName].escapeHTML();\n                        } else {\n                            resultEntityValueName=result[entityValueName];\n                        }\n                        // Add item to initial select element\n                        select.append('<option value=\"' + result[entityIdName] + '\" selected=\"selected\">' +\n                        resultEntityValueName + '</option>');\n                        // Add editable multiselect item\n                        var mselectItemHtml = $(options.item.replace(/%value%|%label%/gi, resultEntityValueName)\n                                .replace(/%mselectDisabledClass%|%iseditable%|%isremovable%/gi, '')\n                                .replace(/%mselectListItemClass%/gi, options.mselectListItemClass))\n                                .find('[type=checkbox]')\n                                .attr('checked', true)\n                                .addClass(options.mselectCheckedClass)\n                                .end(),\n                            sectionBlock = select.nextAll('section.block:first'),\n                            itemsWrapper = sectionBlock.find('.' + options.mselectItemsWrapperClass + '');\n                        if( itemsWrapper.children('.' + options.mselectListItemClass + '').length ) {\n                            itemsWrapper.children('.' + options.mselectListItemClass + ':last').after(mselectItemHtml);\n                        } else {\n                            itemsWrapper.prepend(mselectItemHtml);\n                        }\n                        // Trigger blur event on input field, that is used to add new value, to hide it\n                        var inputSelector = '.' + options.mselectInputContainerClass + ' [type=text].' +\n                            options.mselectInputClass + '';\n                        sectionBlock.find(inputSelector).trigger('blur');\n                    } else {\n                        alert({\n                            content: result.error_message\n                        });\n                    }\n                }\n            };\n            $.ajax(ajaxOptions);\n        };\n\n        /**\n         * Callback function that is called when user tries to delete value from select\n         *\n         * @param options\n         */\n        EditableMultiselect.prototype.deleteEntity = function(options) {\n            var self = this;\n\n            if (options.delete_button) {\n                confirm({\n                    content: this.deleteConfirmMessage,\n                    actions: {\n                        confirm: function() {\n                            // Button that has been clicked\n                            var deleteButton = $(options.delete_button),\n                                index = deleteButton.parent().index(),\n                                select = deleteButton.closest('.mselect-list').prev(),\n                                entityId = select.find('option').eq(index).val(),\n                                entityInfo = {};\n                            entityInfo[self.entityIdName] = entityId;\n                            var postData = $.extend(entityInfo, self.submitData);\n\n                            var ajaxOptions = {\n                                type: 'POST',\n                                data: postData,\n                                dataType: 'json',\n                                url: self.deleteUrl,\n                                success: function(result, status) {\n                                    if (result.success) {\n                                        deleteButton.parent().remove();\n                                        select.find('option').eq(index).remove();\n                                    } else {\n                                        alert({\n                                            content: result.error_message\n                                        });\n                                    }\n                                }\n                            };\n                            $.ajax(ajaxOptions);\n                        }\n                    }\n                });\n            }\n        };\n    };\n});","mage/backend/floating-header.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n        \n    $.widget('mage.floatingHeader', {\n        options: {\n            placeholderAttrs: {\n                'class': 'page-actions-placeholder'\n            },\n            fixedClass: '_fixed',\n            hiddenClass: '_hidden',\n            title: '.page-title-wrapper .page-title',\n            pageMainActions: '.page-main-actions',\n            contains: '[data-role=modal]'\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function() {\n            var title = $(this.options.title).text(),\n                wrapped = this.element.find('.page-actions-buttons').children();\n\n            if (this.element.parents(this.options.contains).length) {\n                return this;\n            }\n\n            this._setVars();\n            this._bind();\n            this.element.find('script').remove();\n            if (wrapped.length) {\n                wrapped\n                    .unwrap()   // .page-actions-buttons\n                    .unwrap();  // .page-actions-inner\n            }\n            this.element.wrapInner($('<div/>', {'class': 'page-actions-buttons'}));\n            this.element.wrapInner($('<div/>', {'class': 'page-actions-inner', 'data-title': title}));\n        },\n\n        /**\n         * Set privat variables on load, for performance purposes\n         * @private\n         */\n        _setVars: function() {\n            this._placeholder = this.element.before($('<div/>', this.options.placeholderAttrs)).prev();\n            this._offsetTop = this._placeholder.offset().top;\n            this._height = this.element\n                .parents(this.options.pageMainActions)\n                .outerHeight();\n        },\n\n        /**\n         * Event binding, will monitor scroll and resize events (resize events left for backward compat)\n         * @private\n         */\n        _bind: function() {\n            this._on(window, {\n                scroll: this._handlePageScroll,\n                resize: this._handlePageScroll\n            });\n        },\n\n        /**\n         * Event handler for setting fixed positioning\n         * @event\n         * @private\n         */\n        _handlePageScroll: function() {\n            var isActive = ($(window).scrollTop() > this._offsetTop);\n\n            if (isActive) {\n                this.element\n                    .addClass(this.options.fixedClass)\n                    .parents(this.options.pageMainActions)\n                    .addClass(this.options.hiddenClass);\n            } else {\n                this.element\n                    .removeClass(this.options.fixedClass)\n                    .parents(this.options.pageMainActions)\n                    .removeClass(this.options.hiddenClass);\n            }\n\n            this._placeholder.height(isActive ? this._height: '');\n        },\n\n        /**\n         * Widget destroy functionality\n         * @private\n         */\n        _destroy: function() {\n            this._placeholder.remove();\n            this._off($(window));\n        }\n    });\n    \n    return $.mage.floatingHeader;\n});\n","mage/backend/form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/ui\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    \"use strict\";\n\n    $.widget(\"mage.form\", {\n        options: {\n            handlersData: {\n                save: {},\n                saveAndContinueEdit: {\n                    action: {\n                        args: {\n                            back: 'edit'\n                        }\n                    }\n                },\n                preview: {\n                    target: '_blank'\n                }\n            }\n        },\n\n        /**\n         * Form creation\n         * @protected\n         */\n        _create: function() {\n            this._bind();\n        },\n\n        /**\n         * Set form attributes to initial state\n         * @protected\n         */\n        _rollback: function() {\n            if (this.oldAttributes) {\n                this.element.prop(this.oldAttributes);\n            }\n        },\n\n        /**\n         * Check if field value is changed\n         * @protected\n         * @param {Object} e event object\n         */\n        _changesObserver: function(e) {\n            var target = $(e.target);\n            if (e.type === 'focus' || e.type === 'focusin') {\n                this.currentField = {\n                    statuses: {\n                        checked: target.is(':checked'),\n                        selected: target.is(':selected')\n                    },\n                    val: target.val()\n                };\n\n            } else {\n                if (this.currentField) {\n                    var changed = target.val() !== this.currentField.val ||\n                        target.is(':checked') !== this.currentField.statuses.checked ||\n                        target.is(':selected') !== this.currentField.statuses.selected;\n                    if (changed) {\n                        target.trigger('changed');\n                    }\n                }\n            }\n        },\n        /**\n         * Get array with handler names\n         * @protected\n         * @return {Array} Array of handler names\n         */\n        _getHandlers: function() {\n            var handlers = [];\n            $.each(this.options.handlersData, function(key) {\n                handlers.push(key);\n            });\n            return handlers;\n        },\n\n        /**\n         * Store initial value of form attribute\n         * @param {string} attrName name of attribute\n         * @protected\n         */\n        _storeAttribute: function(attrName) {\n            this.oldAttributes = this.oldAttributes || {};\n            if (!this.oldAttributes[attrName]) {\n                var prop = this.element.attr(attrName);\n                this.oldAttributes[attrName] = prop ? prop : '';\n            }\n        },\n\n        /**\n         * Bind handlers\n         * @protected\n         */\n        _bind: function() {\n            this.element\n                .on(this._getHandlers().join(' '), $.proxy(this._submit, this))\n                .on('focus blur focusin focusout', $.proxy(this._changesObserver, this));\n        },\n\n        /**\n         * Get action url for form\n         * @param {Object|string} data object with parameters for action url or url string\n         * @return {string} action url\n         */\n        _getActionUrl: function(data) {\n            if ($.type(data) === 'object') {\n                return this._buildURL(this.oldAttributes.action, data.args);\n            } else {\n                return $.type(data) === 'string' ? data : this.oldAttributes.action;\n            }\n        },\n\n        /**\n         * Add additional parameters into URL\n         * @param {string} url - original url\n         * @param {Object} params - object with parameters for action url\n         * @return {string} action url\n         * @private\n         */\n        _buildURL: function(url, params) {\n            var concat = /\\?/.test(url) ? ['&', '='] : ['/', '/'];\n            url = url.replace(/[\\/&]+$/, '');\n            $.each(params, function(key, value) {\n                url += concat[0] + key + concat[1] + window.encodeURIComponent(value);\n            });\n            return url + (concat[0] === '/' ? '/' : '');\n        },\n\n        /**\n         * Prepare data for form attributes\n         * @protected\n         * @param {Object}\n         * @return {Object}\n         */\n        _processData: function(data) {\n            $.each(data, $.proxy(function(attrName, attrValue) {\n                this._storeAttribute(attrName);\n                if (attrName === 'action') {\n                    data[attrName] = this._getActionUrl(attrValue);\n                }\n            }, this));\n            return data;\n        },\n\n        /**\n         * Get additional data before form submit\n         * @protected\n         * @param {string}\n         * @param {Object}\n         */\n        _beforeSubmit: function(handlerName, data) {\n            var submitData = {};\n            var event = new $.Event('beforeSubmit');\n            this.element.trigger(event, [submitData, handlerName]);\n            data = $.extend(\n                true, {},\n                this.options.handlersData[handlerName] || {},\n                submitData,\n                data\n            );\n            this.element.prop(this._processData(data));\n            return !event.isDefaultPrevented();\n        },\n\n        /**\n         * Submit the form\n         * @param {Object} e event object\n         * @param {Object} data event data object\n         */\n        _submit: function(e, data) {\n            this._rollback();\n            if (false !== this._beforeSubmit(e.type, data)) {\n                this.element.trigger('submit', e);\n            }\n        }\n    });\n    \n    return $.mage.form;\n}));\n","mage/backend/menu.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/ui\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    \"use strict\";\n    \n    $.widget('mage.menu', {\n        widgetEventPrefix: \"menu\",\n        version: \"1.10.1\",\n        defaultElement: \"<ul>\",\n        delay: 300,\n        options: {\n            icons: {\n                submenu: \"ui-icon-carat-1-e\"\n            },\n            menus: \"ul\",\n            position: {\n                my: \"left top\",\n                at: \"right top\"\n            },\n            role: \"menu\",\n\n            // callbacks\n            blur: null,\n            focus: null,\n            select: null\n        },\n\n        _create: function () {\n            this.activeMenu = this.element;\n            // flag used to prevent firing of the click handler\n            // as the event bubbles up through nested menus\n            this.mouseHandled = false;\n            this.element\n                .uniqueId()\n                .addClass(\"ui-menu ui-widget ui-widget-content ui-corner-all\")\n                .toggleClass(\"ui-menu-icons\", !!this.element.find(\".ui-icon\").length)\n                .attr({\n                    role: this.options.role,\n                    tabIndex: 0\n                })\n                // need to catch all clicks on disabled menu\n                // not possible through _on\n                .bind(\"click\" + this.eventNamespace, $.proxy(function (event) {\n                    if (this.options.disabled) {\n                        event.preventDefault();\n                    }\n                }, this));\n\n            if (this.options.disabled) {\n                this.element\n                    .addClass(\"ui-state-disabled\")\n                    .attr(\"aria-disabled\", \"true\");\n            }\n\n            this._on({\n                // Prevent focus from sticking to links inside menu after clicking\n                // them (focus should always stay on UL during navigation).\n                \"mousedown .ui-menu-item > a\": function (event) {\n                    event.preventDefault();\n                },\n                \"click .ui-state-disabled > a\": function (event) {\n                    event.preventDefault();\n                },\n                \"click .ui-menu-item:has(a)\": function (event) {\n                    var target = $(event.target).closest(\".ui-menu-item\");\n                    if (!this.mouseHandled && target.not(\".ui-state-disabled\").length) {\n                        this.mouseHandled = true;\n\n                        this.select(event);\n                        // Open submenu on click\n                        if (target.has(\".ui-menu\").length) {\n                            this.expand(event);\n                        } else if (!this.element.is(\":focus\")) {\n                            // Redirect focus to the menu\n                            this.element.trigger(\"focus\", [true]);\n\n                            // If the active item is on the top level, let it stay active.\n                            // Otherwise, blur the active item since it is no longer visible.\n                            if (this.active && this.active.parents(\".ui-menu\").length === 1) {\n                                clearTimeout(this.timer);\n                            }\n                        }\n                    }\n                },\n                \"mouseenter .ui-menu-item\": function (event) {\n                    var target = $(event.currentTarget);\n                    // Remove ui-state-active class from siblings of the newly focused menu item\n                    // to avoid a jump caused by adjacent elements both having a class with a border\n                    target.siblings().children(\".ui-state-active\").removeClass(\"ui-state-active\");\n                    this.focus(event, target);\n                },\n                mouseleave: \"collapseAll\",\n                \"mouseleave .ui-menu\": \"collapseAll\",\n                focus: function (event, keepActiveItem) {\n                    // If there's already an active item, keep it active\n                    // If not, activate the first item\n                    var item = this.active || this.element.children(\".ui-menu-item\").eq(0);\n\n                    if (!keepActiveItem) {\n                        this.focus(event, item);\n                    }\n                },\n                blur: function (event) {\n                    this._delay(function () {\n                        if (!$.contains(this.element[0], this.document[0].activeElement)) {\n                            this.collapseAll(event);\n                        }\n                    });\n                },\n                keydown: \"_keydown\"\n            });\n\n            this.refresh();\n\n            // Clicks outside of a menu collapse any open menus\n            this._on(this.document, {\n                click: function (event) {\n                    if (!$(event.target).closest(\".ui-menu\").length) {\n                        this.collapseAll(event);\n                    }\n\n                    // Reset the mouseHandled flag\n                    this.mouseHandled = false;\n                }\n            });\n        },\n\n        _destroy: function () {\n            // Destroy (sub)menus\n            this.element\n                .removeAttr(\"aria-activedescendant\")\n                .find(\".ui-menu\").addBack()\n                .removeClass(\"ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons\")\n                .removeAttr(\"role\")\n                .removeAttr(\"tabIndex\")\n                .removeAttr(\"aria-labelledby\")\n                .removeAttr(\"aria-expanded\")\n                .removeAttr(\"aria-hidden\")\n                .removeAttr(\"aria-disabled\")\n                .removeUniqueId()\n                .show();\n\n            // Destroy menu items\n            this.element.find(\".ui-menu-item\")\n                .removeClass(\"ui-menu-item\")\n                .removeAttr(\"role\")\n                .removeAttr(\"aria-disabled\")\n                .children(\"a\")\n                .removeUniqueId()\n                .removeClass(\"ui-corner-all ui-state-hover\")\n                .removeAttr(\"tabIndex\")\n                .removeAttr(\"role\")\n                .removeAttr(\"aria-haspopup\")\n                .children().each(function () {\n                    var elem = $(this);\n                    if (elem.data(\"ui-menu-submenu-carat\")) {\n                        elem.remove();\n                    }\n                });\n\n            // Destroy menu dividers\n            this.element.find(\".ui-menu-divider\").removeClass(\"ui-menu-divider ui-widget-content\");\n        },\n\n        _keydown: function (event) {\n            var match, prev, character, skip, regex,\n                preventDefault = true;\n\n            function escape(value) {\n                return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\");\n            }\n\n            switch (event.keyCode) {\n                case $.ui.keyCode.PAGE_UP:\n                    this.previousPage(event);\n                    break;\n                case $.ui.keyCode.PAGE_DOWN:\n                    this.nextPage(event);\n                    break;\n                case $.ui.keyCode.HOME:\n                    this._move(\"first\", \"first\", event);\n                    break;\n                case $.ui.keyCode.END:\n                    this._move(\"last\", \"last\", event);\n                    break;\n                case $.ui.keyCode.UP:\n                    this.previous(event);\n                    break;\n                case $.ui.keyCode.DOWN:\n                    this.next(event);\n                    break;\n                case $.ui.keyCode.LEFT:\n                    this.collapse(event);\n                    break;\n                case $.ui.keyCode.RIGHT:\n                    if (this.active && !this.active.is(\".ui-state-disabled\")) {\n                        this.expand(event);\n                    }\n                    break;\n                case $.ui.keyCode.ENTER:\n                case $.ui.keyCode.SPACE:\n                    this._activate(event);\n                    break;\n                case $.ui.keyCode.ESCAPE:\n                    this.collapse(event);\n                    break;\n                default:\n                    preventDefault = false;\n                    prev = this.previousFilter || \"\";\n                    character = String.fromCharCode(event.keyCode);\n                    skip = false;\n\n                    clearTimeout(this.filterTimer);\n\n                    if (character === prev) {\n                        skip = true;\n                    } else {\n                        character = prev + character;\n                    }\n\n                    regex = new RegExp(\"^\" + escape(character), \"i\");\n                    match = this.activeMenu.children(\".ui-menu-item\").filter(function () {\n                        return regex.test($(this).children(\"a\").text());\n                    });\n                    match = skip && match.index(this.active.next()) !== -1 ?\n                        this.active.nextAll(\".ui-menu-item\") :\n                        match;\n\n                    // If no matches on the current filter, reset to the last character pressed\n                    // to move down the menu to the first item that starts with that character\n                    if (!match.length) {\n                        character = String.fromCharCode(event.keyCode);\n                        regex = new RegExp(\"^\" + escape(character), \"i\");\n                        match = this.activeMenu.children(\".ui-menu-item\").filter(function () {\n                            return regex.test($(this).children(\"a\").text());\n                        });\n                    }\n\n                    if (match.length) {\n                        this.focus(event, match);\n                        if (match.length > 1) {\n                            this.previousFilter = character;\n                            this.filterTimer = this._delay(function () {\n                                delete this.previousFilter;\n                            }, 1000);\n                        } else {\n                            delete this.previousFilter;\n                        }\n                    } else {\n                        delete this.previousFilter;\n                    }\n            }\n\n            if (preventDefault) {\n                event.preventDefault();\n            }\n        },\n\n        _activate: function (event) {\n            if (!this.active.is(\".ui-state-disabled\")) {\n                if (this.active.children(\"a[aria-haspopup='true']\").length) {\n                    this.expand(event);\n                } else {\n                    this.select(event);\n                }\n            }\n        },\n\n        refresh: function () {\n            var menus,\n                icon = this.options.icons.submenu,\n                submenus = this.element.find(this.options.menus);\n\n            // Initialize nested menus\n            submenus.filter(\":not(.ui-menu)\")\n                .addClass(\"ui-menu ui-widget ui-widget-content ui-corner-all\")\n                .hide()\n                .attr({\n                    role: this.options.role,\n                    \"aria-hidden\": \"true\",\n                    \"aria-expanded\": \"false\"\n                })\n                .each(function () {\n                    var menu = $(this),\n                        item = menu.prev(\"a\"),\n                        submenuCarat = $(\"<span>\")\n                            .addClass(\"ui-menu-icon ui-icon \" + icon)\n                            .data(\"ui-menu-submenu-carat\", true);\n\n                    item\n                        .attr(\"aria-haspopup\", \"true\")\n                        .prepend(submenuCarat);\n                    menu.attr(\"aria-labelledby\", item.attr(\"id\"));\n                });\n\n            menus = submenus.add(this.element);\n\n            // Don't refresh list items that are already adapted\n            menus.children(\":not(.ui-menu-item):has(a)\")\n                .addClass(\"ui-menu-item\")\n                .attr(\"role\", \"presentation\")\n                .children(\"a\")\n                .uniqueId()\n                .addClass(\"ui-corner-all\")\n                .attr({\n                    tabIndex: -1,\n                    role: this._itemRole()\n                });\n\n            // Initialize unlinked menu-items containing spaces and/or dashes only as dividers\n            menus.children(\":not(.ui-menu-item)\").each(function () {\n                var item = $(this);\n                // hyphen, em dash, en dash\n                if (!/[^\\-\\u2014\\u2013\\s]/.test(item.text())) {\n                    item.addClass(\"ui-widget-content ui-menu-divider\");\n                }\n            });\n\n            // Add aria-disabled attribute to any disabled menu item\n            menus.children(\".ui-state-disabled\").attr(\"aria-disabled\", \"true\");\n\n            // If the active item has been removed, blur the menu\n            if (this.active && !$.contains(this.element[0], this.active[0])) {\n                this.blur();\n            }\n        },\n\n        _itemRole: function () {\n            return {\n                menu: \"menuitem\",\n                listbox: \"option\"\n            }[this.options.role];\n        },\n\n        _setOption: function (key, value) {\n            if (key === \"icons\") {\n                this.element.find(\".ui-menu-icon\")\n                    .removeClass(this.options.icons.submenu)\n                    .addClass(value.submenu);\n            }\n            this._super(key, value);\n        },\n\n        focus: function (event, item) {\n            var nested, focused;\n            this.blur(event, event && event.type === \"focus\");\n\n            this._scrollIntoView(item);\n\n            this.active = item.first();\n            focused = this.active.children(\"a\").addClass(\"ui-state-focus\");\n            // Only update aria-activedescendant if there's a role\n            // otherwise we assume focus is managed elsewhere\n            if (this.options.role) {\n                this.element.attr(\"aria-activedescendant\", focused.attr(\"id\"));\n            }\n\n            // Highlight active parent menu item, if any\n            this.active\n                .parent()\n                .closest(\".ui-menu-item\")\n                .children(\"a:first\")\n                .addClass(\"ui-state-active\");\n\n            if (event && event.type === \"keydown\") {\n                this._close();\n            } else {\n                this.timer = this._delay(function () {\n                    this._close();\n                }, this.delay);\n            }\n\n            nested = item.children(\".ui-menu\");\n            if (nested.length && ( /^mouse/.test(event.type) )) {\n                this._startOpening(nested);\n            }\n            this.activeMenu = item.parent();\n\n            this._trigger(\"focus\", event, {item: item});\n        },\n\n        _scrollIntoView: function (item) {\n            var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n            if (this._hasScroll()) {\n                borderTop = parseFloat($.css(this.activeMenu[0], \"borderTopWidth\")) || 0;\n                paddingTop = parseFloat($.css(this.activeMenu[0], \"paddingTop\")) || 0;\n                offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n                scroll = this.activeMenu.scrollTop();\n                elementHeight = this.activeMenu.height();\n                itemHeight = item.height();\n\n                if (offset < 0) {\n                    this.activeMenu.scrollTop(scroll + offset);\n                } else if (offset + itemHeight > elementHeight) {\n                    this.activeMenu.scrollTop(scroll + offset - elementHeight + itemHeight);\n                }\n            }\n        },\n\n        blur: function (event, fromFocus) {\n            if (!fromFocus) {\n                clearTimeout(this.timer);\n            }\n\n            if (!this.active) {\n                return;\n            }\n\n            this.active.children(\"a\").removeClass(\"ui-state-focus\");\n            this.active = null;\n\n            this._trigger(\"blur\", event, {item: this.active});\n        },\n\n        _startOpening: function (submenu) {\n            clearTimeout(this.timer);\n\n            // Don't open if already open fixes a Firefox bug that caused a .5 pixel\n            // shift in the submenu position when mousing over the carat icon\n            if (submenu.attr(\"aria-hidden\") !== \"true\") {\n                return;\n            }\n\n            this.timer = this._delay(function () {\n                this._close();\n                this._open(submenu);\n            }, this.delay);\n        },\n\n        _open: function (submenu) {\n            var position = $.extend({\n                of: this.active\n            }, this.options.position);\n\n            clearTimeout(this.timer);\n            this.element.find(\".ui-menu\").not(submenu.parents(\".ui-menu\"))\n                .hide()\n                .attr(\"aria-hidden\", \"true\");\n\n            submenu\n                .show()\n                .removeAttr(\"aria-hidden\")\n                .attr(\"aria-expanded\", \"true\")\n                .position(position);\n        },\n\n        collapseAll: function (event, all) {\n            clearTimeout(this.timer);\n            this.timer = this._delay(function () {\n                // If we were passed an event, look for the submenu that contains the event\n                var currentMenu = all ? this.element :\n                    $(event && event.target).closest(this.element.find(\".ui-menu\"));\n\n                // If we found no valid submenu ancestor, use the main menu to close all sub menus anyway\n                if (!currentMenu.length) {\n                    currentMenu = this.element;\n                }\n\n                this._close(currentMenu);\n\n                this.blur(event);\n                this.activeMenu = currentMenu;\n            }, this.delay);\n        },\n\n        // With no arguments, closes the currently active menu - if nothing is active\n        // it closes all menus.  If passed an argument, it will search for menus BELOW\n        _close: function (startMenu) {\n            if (!startMenu) {\n                startMenu = this.active ? this.active.parent() : this.element;\n            }\n\n            startMenu\n                .find(\".ui-menu\")\n                .hide()\n                .attr(\"aria-hidden\", \"true\")\n                .attr(\"aria-expanded\", \"false\")\n                .end()\n                .find(\"a.ui-state-active\")\n                .removeClass(\"ui-state-active\");\n        },\n\n        collapse: function (event) {\n            var newItem = this.active &&\n                this.active.parent().closest(\".ui-menu-item\", this.element);\n            if (newItem && newItem.length) {\n                this._close();\n                this.focus(event, newItem);\n            }\n        },\n\n        expand: function (event) {\n            var newItem = this.active &&\n                this.active\n                    .children(\".ui-menu \")\n                    .children(\".ui-menu-item\")\n                    .first();\n\n            if (newItem && newItem.length) {\n                this._open(newItem.parent());\n\n                // Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n                this._delay(function () {\n                    this.focus(event, newItem);\n                });\n            }\n        },\n\n        next: function (event) {\n            this._move(\"next\", \"first\", event);\n        },\n\n        previous: function (event) {\n            this._move(\"prev\", \"last\", event);\n        },\n\n        isFirstItem: function () {\n            return this.active && !this.active.prevAll(\".ui-menu-item\").length;\n        },\n\n        isLastItem: function () {\n            return this.active && !this.active.nextAll(\".ui-menu-item\").length;\n        },\n\n        _move: function (direction, filter, event) {\n            var next;\n            if (this.active) {\n                if (direction === \"first\" || direction === \"last\") {\n                    next = this.active\n                        [direction === \"first\" ? \"prevAll\" : \"nextAll\"](\".ui-menu-item\")\n                        .eq(-1);\n                } else {\n                    next = this.active\n                        [direction + \"All\"](\".ui-menu-item\")\n                        .eq(0);\n                }\n            }\n            if (!next || !next.length || !this.active) {\n                next = this.activeMenu.children(\".ui-menu-item\")[filter]();\n            }\n\n            this.focus(event, next);\n        },\n\n        nextPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n                return;\n            }\n            if (this.isLastItem()) {\n                return;\n            }\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.nextAll(\".ui-menu-item\").each(function () {\n                    item = $(this);\n                    return item.offset().top - base - height < 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children(\".ui-menu-item\")\n                    [!this.active ? \"first\" : \"last\"]());\n            }\n        },\n\n        previousPage: function (event) {\n            var item, base, height;\n            if (!this.active) {\n                this.next(event);\n                return;\n            }\n            if (this.isFirstItem()) {\n                return;\n            }\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.prevAll(\".ui-menu-item\").each(function () {\n                    item = $(this);\n                    return item.offset().top - base + height > 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children(\".ui-menu-item\").first());\n            }\n        },\n\n        _hasScroll: function () {\n            return this.element.outerHeight() < this.element.prop(\"scrollHeight\");\n        },\n\n        select: function (event) {\n            // TODO: It should never be possible to not have an active item at this\n            // point, but the tests don't trigger mouseenter before click.\n            this.active = this.active || $(event.target).closest(\".ui-menu-item\");\n            var ui = {item: this.active};\n            if (!this.active.has(\".ui-menu\").length) {\n                this.collapseAll(event, true);\n            }\n            this._trigger(\"select\", event, ui);\n        }\n    });\n    \n    return $.mage.menu;\n}));","mage/backend/notification.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.notification', {\n        options: {\n            templates: {\n                global: '<div data-role=\"messages\" id=\"messages\"><div class=\"message <% if (data.error) { %>error<% } %>\"><div><%- data.message %></div></div></div>',\n                error: '<div data-role=\"messages\" id=\"messages\"><div class=\"messages\"><div class=\"message message-error error\"><div data-ui-id=\"messages-message-error\"><%- data.message %></div></div></div></div>'\n            }\n        },\n        placeholder: '[data-role=messages]',\n        /**\n         * Notification creation\n         * @protected\n         */\n        _create: function () {\n            $(document).on('ajaxComplete ajaxError', $.proxy(this._add, this));\n        },\n\n        /**\n         * Add new message\n         * @protected\n         * @param {Object} event - object\n         * @param {Object} jqXHR - The jQuery XMLHttpRequest object returned by $.ajax()\n         */\n        _add: function (event, jqXHR) {\n            try {\n                var response = JSON.parse(jqXHR.responseText);\n\n                if (response && response.error && response.html_message) {\n                    $(this.placeholder).html(response.html_message);\n                }\n            } catch (e) {}\n        },\n\n        /**\n         * Adds new message.\n         *\n         * @param {Object} data - Data with a message to be displayed.\n         */\n        add: function (data) {\n            var template = data.error ? this.options.templates.error : this.options.templates.global;\n            var message = mageTemplate(template, {\n                data: data\n            });\n            if (typeof data.insertMethod === 'function') {\n                data.insertMethod(message);\n            } else {\n                var messageContainer = data.messageContainer || this.placeholder;\n                $(messageContainer).prepend(message);\n            }\n            return this;\n        },\n\n        /**\n         * Removes error messages.\n         */\n        clear: function () {\n            $(this.placeholder).html('');\n        }\n    });\n\n    return $.mage.notification;\n});\n","mage/backend/suggest.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/template',\n            'mage/mage',\n            'jquery/ui',\n            'mage/backend/menu',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    'use strict';\n\n    /**\n     * Implement base functionality\n     */\n    $.widget('mage.suggest', {\n        widgetEventPrefix: 'suggest',\n        options: {\n            template: '<% if (data.items.length) { %><% if (!data.term && !data.allShown() && data.recentShown()) { %>' +\n                '<h5 class=\"title\"><%- data.recentTitle %></h5>' +\n                '<% } %>' +\n                '<ul data-mage-init=\\'{\"menu\":[]}\\'>' +\n                '<% _.each(data.items, function(value){ %>' +\n                '<% if (!data.itemSelected(value)) { %><li <%= data.optionData(value) %>>' +\n                '<a href=\"#\"><%- value.label %></a></li><% } %>' +\n                '<% }); %>' +\n                '<% if (!data.term && !data.allShown() && data.recentShown()) { %>' +\n                '<li data-mage-init=\\'{\"actionLink\":{\"event\":\"showAll\"}}\\' class=\"show-all\">' +\n                '<a href=\"#\"><%- data.showAllTitle %></a></li>' +\n                '<% } %>' +\n                '</ul><% } else { %><span class=\"mage-suggest-no-records\"><%- data.noRecordsText %></span><% } %>',\n            minLength: 1,\n            /**\n             * @type {(String|Array)}\n             */\n            source: null,\n            delay: 500,\n            loadingClass: 'mage-suggest-state-loading',\n            events: {},\n            appendMethod: 'after',\n            controls: {\n                selector: ':ui-menu, :mage-menu',\n                eventsMap: {\n                    focus: ['menufocus'],\n                    blur: ['menublur'],\n                    select: ['menuselect']\n                }\n            },\n            termAjaxArgument: 'label_part',\n            filterProperty: 'label',\n            className: null,\n            inputWrapper: '<div class=\"mage-suggest\"><div class=\"mage-suggest-inner\"></div></div>',\n            dropdownWrapper: '<div class=\"mage-suggest-dropdown\"></div>',\n            preventClickPropagation: true,\n            currentlySelected: null\n        },\n\n        /**\n         * Component's constructor\n         * @private\n         */\n        _create: function () {\n            this._term = null;\n            this._nonSelectedItem = {\n                id: '',\n                label: ''\n            };\n            \n            this.templates = {};\n\n            this._renderedContext = null;\n            this._selectedItem = this._nonSelectedItem;\n            this._control = this.options.controls || {};\n            this._setTemplate();\n            this._prepareValueField();\n            this._render();\n            this._bind();\n        },\n\n        /**\n         * Render base elements for suggest component\n         * @private\n         */\n        _render: function () {\n            this.dropdown = $(this.options.dropdownWrapper).hide();\n            var wrapper = this.options.className ?\n                $(this.options.inputWrapper).addClass(this.options.className) :\n                $(this.options.inputWrapper);\n            this.element\n                .wrap(wrapper)[this.options.appendMethod](this.dropdown)\n                .attr('autocomplete', 'off');\n        },\n\n        /**\n         * Define a field for storing item id (find in DOM or create a new one)\n         * @private\n         */\n        _prepareValueField: function () {\n            if (this.options.valueField) {\n                this.valueField = $(this.options.valueField);\n            } else {\n                this.valueField = this._createValueField()\n                    .insertBefore(this.element)\n                    .attr('name', this.element.attr('name'));\n                this.element.removeAttr('name');\n            }\n        },\n\n        /**\n         * Create value field which keeps a id for selected option\n         * can be overridden in descendants\n         * @return {jQuery}\n         * @private\n         */\n        _createValueField: function () {\n            return $('<input/>', {\n                type: 'hidden'\n            });\n        },\n\n        /**\n         * Component's destructor\n         * @private\n         */\n        _destroy: function () {\n            this.element\n                .unwrap()\n                .removeAttr('autocomplete');\n\n            if (!this.options.valueField) {\n                this.element.attr('name', this.valueField.attr('name'));\n                this.valueField.remove();\n            }\n\n            this.dropdown.remove();\n            this._off(this.element, 'keydown keyup blur');\n        },\n\n        /**\n         * Return actual value of an \"input\"-element\n         * @return {String}\n         * @private\n         */\n        _value: function () {\n            return $.trim(this.element[this.element.is(':input') ? 'val' : 'text']());\n        },\n\n        /**\n         * Pass original event to a control component for handling it as it's own event\n         * @param {Object} event - event object\n         * @private\n         */\n        _proxyEvents: function (event) {\n            var fakeEvent = $.extend({}, $.Event(event.type), {\n                    ctrlKey: event.ctrlKey,\n                    keyCode: event.keyCode,\n                    which: event.keyCode\n                }),\n                target = this._control.selector ? this.dropdown.find(this._control.selector) : this.dropdown;\n            target.trigger(fakeEvent);\n        },\n\n        /**\n         * Bind handlers on specific events\n         * @private\n         */\n        _bind: function () {\n            this._on($.extend({\n                keydown: function (event) {\n                    var keyCode = $.ui.keyCode,\n                        suggestList,\n                        hasSuggestedItems,\n                        hasSelectedItems,\n                        selectedItem;\n\n                    switch (event.keyCode) {\n                        case keyCode.PAGE_UP:\n                        case keyCode.UP:\n                            if (!event.shiftKey) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n\n                            suggestList = event.currentTarget.parentNode.getElementsByTagName('ul')[0];\n                            hasSuggestedItems = event.currentTarget.parentNode.getElementsByTagName('ul')[0].children.length >= 0;\n                            if (hasSuggestedItems) {\n                                selectedItem =  $(suggestList.getElementsByClassName('_active')[0]).removeClass('_active').prev().addClass('_active');\n                                event.currentTarget.value = selectedItem.find(\"a\").text();\n                            }\n\n                            break;\n                        case keyCode.PAGE_DOWN:\n                        case keyCode.DOWN:\n                            if (!event.shiftKey) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n\n                            suggestList = event.currentTarget.parentNode.getElementsByTagName('ul')[0];\n                            hasSuggestedItems = event.currentTarget.parentNode.getElementsByTagName('ul')[0].children.length >= 0;\n                            if(hasSuggestedItems){\n                                hasSelectedItems = suggestList.getElementsByClassName('_active').length === 0;\n                                if(hasSelectedItems) {\n                                    selectedItem = $(suggestList.children[0]).addClass('_active');\n                                    event.currentTarget.value = selectedItem.find(\"a\").text();\n                                }else {\n                                    selectedItem = $(suggestList.getElementsByClassName('_active')[0]).removeClass('_active').next().addClass('_active');\n                                    event.currentTarget.value = selectedItem.find(\"a\").text();\n                                }\n                            }\n                            break;\n                        case keyCode.TAB:\n                            if (this.isDropdownShown()) {\n                                this._onSelectItem(event, null);\n                                event.preventDefault();\n                            }\n                            break;\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n\n                            if (this.isDropdownShown() && this._focused) {\n                                this._proxyEvents(event);\n                                event.preventDefault();\n                            }\n                            break;\n                        case keyCode.ESCAPE:\n                            if (this.isDropdownShown()) {\n                                event.stopPropagation();\n                            }\n                            this.close(event);\n                            this._blurItem();\n                            break;\n                    }\n                },\n                keyup: function (event) {\n                    var keyCode = $.ui.keyCode;\n                    switch (event.keyCode) {\n                        case keyCode.HOME:\n                        case keyCode.END:\n                        case keyCode.PAGE_UP:\n                        case keyCode.PAGE_DOWN:\n                        case keyCode.ESCAPE:\n                        case keyCode.UP:\n                        case keyCode.DOWN:\n                        case keyCode.LEFT:\n                        case keyCode.RIGHT:\n                        case keyCode.TAB:\n                            break;\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            if (this.isDropdownShown()) {\n                                event.preventDefault();\n                            }\n                            break;\n                        default:\n                            this.search(event);\n                    }\n                },\n                blur: function (event) {\n                    if (!this.preventBlur) {\n                        this._abortSearch();\n                        this.close(event);\n                        this._change(event);\n                    } else {\n                        this.element.trigger('focus');\n                    }\n                },\n                cut: this.search,\n                paste: this.search,\n                input: this.search,\n                selectItem: this._onSelectItem,\n                click: this.search\n            }, this.options.events));\n\n            this._bindDropdown();\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @private\n         */\n        _change: function (e) {\n            if (this._term !== this._value()) {\n                this._trigger('change', e);\n            }\n        },\n\n        /**\n         * Bind handlers for dropdown element on specific events\n         * @private\n         */\n        _bindDropdown: function () {\n            var events = {\n                click: function (e) {\n                    // prevent default browser's behavior of changing location by anchor href\n                    e.preventDefault();\n                },\n                mousedown: function (e) {\n                    e.preventDefault();\n                }\n            };\n            $.each(this._control.eventsMap, $.proxy(function (suggestEvent, controlEvents) {\n                $.each(controlEvents, $.proxy(function (i, handlerName) {\n                    switch (suggestEvent) {\n                    case 'select':\n                        events[handlerName] = this._onSelectItem;\n                        break;\n                    case 'focus':\n                        events[handlerName] = this._focusItem;\n                        break;\n                    case 'blur':\n                        events[handlerName] = this._blurItem;\n                        break;\n                    }\n                }, this));\n            }, this));\n\n            if (this.options.preventClickPropagation) {\n                this._on(this.dropdown, events);\n            }\n            // Fix for IE 8\n            this._on(this.dropdown, {\n                mousedown: function () {\n                    this.preventBlur = true;\n                },\n                mouseup: function () {\n                    this.preventBlur = false;\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        _trigger: function (type, event) {\n            var result = this._superApply(arguments);\n\n            if (result === false && event) {\n                event.stopImmediatePropagation();\n                event.preventDefault();\n            }\n\n            return result;\n        },\n\n        /**\n         * Handle focus event of options item\n         * @param {Object} e - event object\n         * @param {Object} ui - object that can contain information about focused item\n         * @private\n         */\n        _focusItem: function (e, ui) {\n            if (ui && ui.item) {\n                this._focused = $(ui.item).prop('tagName') ?\n                    this._readItemData(ui.item) :\n                    ui.item;\n\n                this.element.val(this._focused.label);\n                this._trigger('focus', e, {\n                    item: this._focused\n                });\n            }\n        },\n\n        /**\n         * Handle blur event of options item\n         * @private\n         */\n        _blurItem: function () {\n            this._focused = null;\n            this.element.val(this._term);\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @param {Object} item\n         * @private\n         */\n        _onSelectItem: function (e, item) {\n            if (item && $.type(item) === 'object' && $(e.target).is(this.element)) {\n                this._focusItem(e, {\n                    item: item\n                });\n            }\n\n            if (this._trigger('beforeselect', e || null, {\n                item: this._focused\n            }) === false) {\n                return;\n            }\n            this._selectItem(e);\n            this._blurItem();\n            this._trigger('select', e || null, {\n                item: this._selectedItem\n            });\n        },\n\n        /**\n         * Save selected item and hide dropdown\n         * @private\n         * @param {Object} e - event object\n         */\n        _selectItem: function (e) {\n            if (this._focused) {\n                this._selectedItem = this._focused;\n\n                if (this._selectedItem !== this._nonSelectedItem) {\n                    this._term = this._selectedItem.label;\n                    this.valueField.val(this._selectedItem.id);\n                    this.close(e);\n                }\n            }\n        },\n\n        /**\n         * Read option data from item element\n         * @param {Element} element\n         * @return {Object}\n         * @private\n         */\n        _readItemData: function (element) {\n            return element.data('suggestOption') || this._nonSelectedItem;\n        },\n\n        /**\n         * Check if dropdown is shown\n         * @return {Boolean}\n         */\n        isDropdownShown: function () {\n            return this.dropdown.is(':visible');\n        },\n\n        /**\n         * Open dropdown\n         * @private\n         * @param {Object} e - event object\n         */\n        open: function (e) {\n            if (!this.isDropdownShown()) {\n                this.element.addClass('_suggest-dropdown-open');\n                this.dropdown.show();\n                this._trigger('open', e);\n            }\n        },\n\n        /**\n         * Close and clear dropdown content\n         * @private\n         * @param {Object} e - event object\n         */\n        close: function (e) {\n            this._renderedContext = null;\n\n            if (this.dropdown.length) {\n                this.element.removeClass('_suggest-dropdown-open');\n                this.dropdown.hide().empty();\n            }\n\n            this._trigger('close', e);\n        },\n\n        /**\n         * Acquire content template\n         * @private\n         */\n        _setTemplate: function () {\n            this.templateName = 'suggest' + Math.random().toString(36).substr(2);\n\n            this.templates[this.templateName] = mageTemplate(this.options.template);\n        },\n\n        /**\n         * Execute search process\n         * @public\n         * @param {Object} e - event object\n         */\n        search: function (e) {\n            var term = this._value();\n\n            if ((this._term !== term || term.length === 0) && !this.preventBlur) {\n                this._term = term;\n\n                if ($.type(term) === 'string' && term.length >= this.options.minLength) {\n                    if (this._trigger('search', e) === false) {\n                        return;\n                    }\n                    this._search(e, term, {});\n                } else {\n                    this._selectedItem = this._nonSelectedItem;\n                    this._resetSuggestValue();\n                }\n            }\n        },\n\n        /*\n         * Clear suggest hidden input\n         * @private\n         */\n        _resetSuggestValue: function () {\n            this.valueField.val(this._nonSelectedItem.id);\n        },\n\n        /**\n         * Actual search method, can be overridden in descendants\n         * @param {Object} e - event object\n         * @param {String} term - search phrase\n         * @param {Object} context - search context\n         * @private\n         */\n        _search: function (e, term, context) {\n            var response = $.proxy(function (items) {\n                return this._processResponse(e, items, context || {});\n            }, this);\n            this.element.addClass(this.options.loadingClass);\n\n            if (this.options.delay) {\n                if ($.type(this.options.data) !== 'undefined') {\n                    response(this.filter(this.options.data, term));\n                }\n                clearTimeout(this._searchTimeout);\n                this._searchTimeout = this._delay(function () {\n                    this._source(term, response);\n                }, this.options.delay);\n            } else {\n                this._source(term, response);\n            }\n        },\n\n        /**\n         * Extend basic context with additional data (search results, search term)\n         * @param {Object} context\n         * @return {Object}\n         * @private\n         */\n        _prepareDropdownContext: function (context) {\n            return $.extend(context, {\n                items: this._items,\n                term: this._term,\n                optionData: function (item) {\n                    return 'data-suggest-option=\"' +\n                        $('<div>').text(JSON.stringify(item)).html().replace(/\"/g, '&quot;') + '\"';\n                },\n                itemSelected: $.proxy(this._isItemSelected, this),\n                noRecordsText: $.mage.__('No records found.')\n            });\n        },\n\n        /**\n         * @param item\n         * @return {Boolean}\n         * @private\n         */\n        _isItemSelected: function (item) {\n            return item.id == (this._selectedItem && this._selectedItem.id ?\n                this._selectedItem.id :\n                this.options.currentlySelected);\n        },\n\n        /**\n         * Render content of suggest's dropdown\n         * @param {Object} e - event object\n         * @param {Array} items - list of label+id objects\n         * @param {Object} context - template's context\n         * @private\n         */\n        _renderDropdown: function (e, items, context) {\n            var tmpl = this.templates[this.templateName];\n\n            this._items = items;\n\n            tmpl = tmpl({\n                data: this._prepareDropdownContext(context)\n            });\n\n            $(tmpl).appendTo(this.dropdown.empty());\n\n            this.dropdown.trigger('contentUpdated')\n                .find(this._control.selector).on('focus', function (e) {\n                    e.preventDefault();\n                });\n\n            this._renderedContext = context;\n            this.element.removeClass(this.options.loadingClass);\n            this.open(e);\n        },\n\n        /**\n         * @param {Object} e\n         * @param {Object} items\n         * @param {Object} context\n         * @private\n         */\n        _processResponse: function (e, items, context) {\n            var renderer = $.proxy(function (items) {\n                return this._renderDropdown(e, items, context || {});\n            }, this);\n\n            if (this._trigger('response', e, [items, renderer]) === false) {\n                return;\n            }\n            this._renderDropdown(e, items, context);\n        },\n\n        /**\n         * Implement search process via spesific source\n         * @param {String} term - search phrase\n         * @param {Function} response - search results handler, process search result\n         * @private\n         */\n        _source: function (term, response) {\n            var o = this.options;\n\n            if ($.isArray(o.source)) {\n                response(this.filter(o.source, term));\n            } else if ($.type(o.source) === 'string') {\n                if (this._xhr) {\n                    this._xhr.abort();\n                }\n                var ajaxData = {};\n                ajaxData[this.options.termAjaxArgument] = term;\n\n                this._xhr = $.ajax($.extend(true, {\n                    url: o.source,\n                    type: 'POST',\n                    dataType: 'json',\n                    data: ajaxData,\n                    success: $.proxy(function (items) {\n                        this.options.data = items;\n                        response.apply(response, arguments);\n                    }, this)\n                }, o.ajaxOptions || {}));\n            } else if ($.type(o.source) === 'function') {\n                o.source.apply(o.source, arguments);\n            }\n        },\n\n        /**\n         * Abort search process\n         * @private\n         */\n        _abortSearch: function () {\n            this.element.removeClass(this.options.loadingClass);\n            clearTimeout(this._searchTimeout);\n\n            if (this._xhr) {\n                this._xhr.abort();\n            }\n        },\n\n        /**\n         * Perform filtering in advance loaded items and returns search result\n         * @param {Array} items - all available items\n         * @param {String} term - search phrase\n         * @return {Object}\n         */\n        filter: function (items, term) {\n            var matcher = new RegExp(term.replace(/[\\-\\/\\\\\\^$*+?.()|\\[\\]{}]/g, '\\\\$&'), 'i');\n            var itemsArray = $.isArray(items) ? items : $.map(items, function (element) {\n                return element;\n            });\n            var property = this.options.filterProperty;\n\n            return $.grep(\n                itemsArray,\n                function (value) {\n                    return matcher.test(value[property] || value.id || value);\n                }\n            );\n        }\n    });\n\n    /**\n     * Implement show all functionality and storing and display recent searches\n     */\n    $.widget('mage.suggest', $.mage.suggest, {\n        options: {\n            showRecent: false,\n            showAll: false,\n            storageKey: 'suggest',\n            storageLimit: 10\n        },\n\n        /**\n         * @override\n         */\n        _create: function () {\n            if (this.options.showRecent && window.localStorage) {\n                var recentItems = JSON.parse(localStorage.getItem(this.options.storageKey));\n                /**\n                 * @type {Array} - list of recently searched items\n                 * @private\n                 */\n                this._recentItems = $.isArray(recentItems) ? recentItems : [];\n            }\n            this._super();\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n            this._on(this.dropdown, {\n                showAll: function (e) {\n                    e.stopImmediatePropagation();\n                    e.preventDefault();\n                    this.element.trigger('showAll');\n                }\n            });\n\n            if (this.options.showRecent || this.options.showAll) {\n                this._on({\n                    focus: function (e) {\n                        if (!this.isDropdownShown()) {\n                            this.search(e);\n                        }\n                    },\n                    showAll: this._showAll\n                });\n            }\n        },\n\n        /**\n         * @private\n         * @param {Object} e - event object\n         */\n        _showAll: function (e) {\n            this._abortSearch();\n            this._search(e, '', {\n                _allShown: true\n            });\n        },\n\n        /**\n         * @override\n         */\n        search: function (e) {\n            if (!this._value()) {\n\n                if (this.options.showRecent) {\n\n                    if (this._recentItems.length) {\n                        this._processResponse(e, this._recentItems, {});\n                    } else {\n                        this._showAll(e);\n                    }\n                } else if (this.options.showAll) {\n                    this._showAll(e);\n                }\n            }\n            this._superApply(arguments);\n        },\n\n        /**\n         * @override\n         */\n        _selectItem: function () {\n            this._superApply(arguments);\n\n            if (this._selectedItem && this._selectedItem.id && this.options.showRecent) {\n                this._addRecent(this._selectedItem);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _prepareDropdownContext: function () {\n            var context = this._superApply(arguments);\n\n            return $.extend(context, {\n                recentShown: $.proxy(function () {\n                    return this.options.showRecent;\n                }, this),\n                recentTitle: $.mage.__('Recent items'),\n                showAllTitle: $.mage.__('Show all...'),\n                allShown: function () {\n                    return !!context._allShown;\n                }\n            });\n        },\n\n        /**\n         * Add selected item of search result into storage of recents\n         * @param {Object} item - label+id object\n         * @private\n         */\n        _addRecent: function (item) {\n            this._recentItems = $.grep(this._recentItems, function (obj) {\n                return obj.id !== item.id;\n            });\n            this._recentItems.unshift(item);\n            this._recentItems = this._recentItems.slice(0, this.options.storageLimit);\n            localStorage.setItem(this.options.storageKey, JSON.stringify(this._recentItems));\n        }\n    });\n\n    /**\n     * Implement multi suggest functionality\n     */\n    $.widget('mage.suggest', $.mage.suggest, {\n        options: {\n            multiSuggestWrapper: '<ul class=\"mage-suggest-choices\">' +\n                '<li class=\"mage-suggest-search-field\" data-role=\"parent-choice-element\"><label class=\"mage-suggest-search-label\"></label></li></ul>',\n            choiceTemplate: '<li class=\"mage-suggest-choice button\"><div><%- text %></div>' +\n                '<span class=\"mage-suggest-choice-close\" tabindex=\"-1\" ' +\n                'data-mage-init=\\'{\"actionLink\":{\"event\":\"removeOption\"}}\\'></span></li>',\n            selectedClass: 'mage-suggest-selected'\n        },\n\n        /**\n         * @override\n         */\n        _create: function () {\n            this.choiceTmpl = mageTemplate(this.options.choiceTemplate);\n\n            this._super();\n\n            if (this.options.multiselect) {\n                this.valueField.hide();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _render: function () {\n            this._super();\n\n            if (this.options.multiselect) {\n                this._renderMultiselect();\n            }\n        },\n\n        /**\n         * Render selected options\n         * @private\n         */\n        _renderMultiselect: function () {\n            var that = this;\n            this.element.wrap(this.options.multiSuggestWrapper);\n            this.elementWrapper = this.element.closest('[data-role=\"parent-choice-element\"]');\n            $(function () {\n                that._getOptions()\n                    .each(function (i, option) {\n                        option = $(option);\n                        that._createOption({\n                            id: option.val(),\n                            label: option.text()\n                        });\n                    });\n            });\n        },\n\n        /**\n         * @return {Array} array of DOM-elements\n         * @private\n         */\n        _getOptions: function () {\n            return this.valueField.find('option');\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n\n            if (this.options.multiselect) {\n                this._on({\n                    keydown: function (event) {\n                        if (event.keyCode === $.ui.keyCode.BACKSPACE) {\n                            if (!this._value()) {\n                                this._removeLastAdded(event);\n                            }\n                        }\n                    },\n                    removeOption: this.removeOption\n                });\n            }\n        },\n\n        /**\n         * @param {Array} items\n         * @param {Object} context\n         * @return {Array}\n         * @private\n         */\n        _filterSelected: function (items) {\n            var options = this._getOptions();\n\n            return $.grep(items, function (value) {\n                var itemSelected = false;\n                $.each(options, function () {\n                    if (value.id == $(this).val()) {\n                        itemSelected = true;\n                    }\n                });\n\n                return !itemSelected;\n            });\n        },\n\n        /**\n         * @override\n         */\n        _processResponse: function (e, items, context) {\n            if (this.options.multiselect) {\n                items = this._filterSelected(items, context);\n            }\n            this._superApply([e, items, context]);\n        },\n\n        /**\n         * @override\n         */\n        _prepareValueField: function () {\n            this._super();\n\n            if (this.options.multiselect && !this.options.valueField && this.options.selectedItems) {\n                $.each(this.options.selectedItems, $.proxy(function (i, item) {\n                    this._addOption(item);\n                }, this));\n            }\n        },\n\n        /**\n         * If \"multiselect\" option is set, then do not need to clear value for hidden select, to avoid losing of\n         *      previously selected items\n         * @override\n         */\n        _resetSuggestValue: function () {\n            if (!this.options.multiselect) {\n                this._super();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _createValueField: function () {\n            if (this.options.multiselect) {\n                return $('<select/>', {\n                    type: 'hidden',\n                    multiple: 'multiple'\n                });\n            } else {\n                return this._super();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _selectItem: function (e) {\n            if (this.options.multiselect) {\n                if (this._focused) {\n                    this._selectedItem = this._focused;\n\n                    if (this._selectedItem !== this._nonSelectedItem) {\n                        this._term = '';\n                        this.element.val(this._term);\n\n                        if (this._isItemSelected(this._selectedItem)) {\n                            $(e.target).removeClass(this.options.selectedClass);\n                            this.removeOption(e, this._selectedItem);\n                            this._selectedItem = this._nonSelectedItem;\n                        } else {\n                            $(e.target).addClass(this.options.selectedClass);\n                            this._addOption(e, this._selectedItem);\n                        }\n                    }\n                }\n                this.close(e);\n            } else {\n                this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _isItemSelected: function (item) {\n            if (this.options.multiselect) {\n                return this.valueField.find('option[value=' + item.id + ']').length > 0;\n            } else {\n                return this._superApply(arguments);\n            }\n        },\n\n        /**\n         *\n         * @param {Object} item\n         * @return {Element}\n         * @private\n         */\n        _createOption: function (item) {\n            var option = this._getOption(item);\n\n            if (!option.length) {\n                option = $('<option>', {\n                    value: item.id,\n                    selected: true\n                }).text(item.label);\n            }\n\n            return option.data('renderedOption', this._renderOption(item));\n        },\n\n        /**\n         * Add selected item in to select options\n         * @param {Object} e - event object\n         * @param item\n         * @private\n         */\n        _addOption: function (e, item) {\n            this.valueField.append(this._createOption(item).data('selectTarget', $(e.target)));\n        },\n\n        /**\n         * @param {Object|Element} item\n         * @return {Element}\n         * @private\n         */\n        _getOption: function (item) {\n            return $(item).prop('tagName') ?\n                $(item) :\n                this.valueField.find('option[value=' + item.id + ']');\n        },\n\n        /**\n         * Remove last added option\n         * @private\n         * @param {Object} e - event object\n         */\n        _removeLastAdded: function (e) {\n            var lastAdded = this._getOptions().last();\n\n            if (lastAdded.length) {\n                this.removeOption(e, lastAdded);\n            }\n        },\n\n        /**\n         * Remove item from select options\n         * @param {Object} e - event object\n         * @param {Object} item\n         * @private\n         */\n        removeOption: function (e, item) {\n            var option = this._getOption(item);\n            var selectTarget = option.data('selectTarget');\n\n            if (selectTarget && selectTarget.length) {\n                selectTarget.removeClass(this.options.selectedClass);\n            }\n\n            option.data('renderedOption').remove();\n            option.remove();\n        },\n\n        /**\n         * Render visual element of selected item\n         * @param {Object} item - selected item\n         * @private\n         */\n        _renderOption: function (item) {\n            var tmpl = this.choiceTmpl({\n                text: item.label\n            });\n\n            return $(tmpl)\n                .insertBefore(this.elementWrapper)\n                .trigger('contentUpdated')\n                .on('removeOption', $.proxy(function (e) {\n                    this.removeOption(e, item);\n                }, this));\n        }\n    });\n\n    return $.mage.suggest;\n}));\n","mage/backend/tabs.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true browser:true*/\n/*global FORM_KEY:true*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/ui\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    // mage.tabs base functionality\n    $.widget('mage.tabs', $.ui.tabs, {\n        options: {\n            spinner: false,\n            groups: null,\n            tabPanelClass: '',\n            excludedPanel: ''\n        },\n\n        /**\n         * Tabs creation\n         * @protected\n         */\n        _create: function() {\n            var activeIndex = this._getTabIndex(this.options.active);\n            this.options.active = activeIndex >= 0 ? activeIndex : 0;\n            this._super();\n        },\n\n        /**\n         * @override\n         * @private\n         * @return {Array} Array of DOM-elements\n         */\n        _getList: function() {\n            if(this.options.groups) {\n                return this.element.find(this.options.groups);\n            } else {\n                return this._super();\n            }\n        },\n\n        /**\n         * Get active anchor\n         * @return {Element}\n         */\n        activeAnchor: function() {\n            return this.anchors.eq(this.option(\"active\"));\n        },\n\n        /**\n         * Get tab index by tab id\n         * @protected\n         * @param {string} id - id of tab\n         * @return {number}\n         */\n        _getTabIndex: function(id) {\n            var anchors = this.anchors ?\n                this.anchors :\n                this._getList().find(\"> li > a[href]\");\n            return anchors.index($('#' + id));\n        },\n\n        /**\n         * Switch between tabs\n         * @protected\n         * @param {Object} event - event object\n         * @param {undefined|Object} eventData\n         */\n        _toggle: function(event, eventData) {\n            var anchor = $(eventData.newTab).find('a');\n            if ($(eventData.newTab).find('a').data().tabType === 'link') {\n                location.href = anchor.prop('href');\n            } else {\n                this._superApply(arguments);\n            }\n        }\n    });\n    var rhash = /#.*$/,\n        isLocal = function(anchor) {\n            return anchor.hash.length > 1 &&\n                anchor.href.replace(rhash, \"\") ===\n                    location.href.replace(rhash, \"\")\n                        // support: Safari 5.1\n                        // Safari 5.1 doesn't encode spaces in window.location\n                        // but it does encode spaces from anchors (#8777)\n                        .replace(/\\s/g, \"%20\");\n        };\n\n    // Extension for mage.tabs - Move panels in destination element\n    $.widget('mage.tabs', $.mage.tabs, {\n        /**\n         * Move panels in destination element on creation\n         * @protected\n         * @override\n         */\n        _create: function() {\n            this._super();\n            this._movePanelsInDestination(this.panels);\n        },\n\n        /**\n         * Get panel for tab. If panel no exist in tabs container, then find panel in destination element\n         * @protected\n         * @override\n         * @param {Element} tab - tab \"li\" DOM-element\n         * @return {Element}\n         */\n        _getPanelForTab: function(tab) {\n            var panel = this._superApply(arguments);\n            if (!panel.length) {\n                var id = $(tab).attr(\"aria-controls\");\n                panel = $(this.options.destination).find(this._sanitizeSelector( \"#\" + id ));\n            }\n            return panel;\n        },\n\n        _processTabs: function() {\n            var that = this;\n\n            this.tablist = this._getList()\n                .addClass(\"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\")\n                .attr(\"role\", \"tablist\");\n\n            this.tabs = this.tablist.find(\"> li:has(a[href])\")\n                .addClass(\"ui-state-default ui-corner-top\")\n                .attr({\n                    role: \"tab\",\n                    tabIndex: -1\n                });\n\n            this.anchors = this.tabs.map(function() {\n                return $(\"a\", this)[ 0 ];\n            })\n                .addClass(\"ui-tabs-anchor\")\n                .attr({\n                    role: \"presentation\",\n                    tabIndex: -1\n                });\n\n            this.panels = $();\n\n            this.anchors.each(function(i, anchor) {\n                var selector, panel, panelId,\n                    anchorId = $(anchor).uniqueId().attr(\"id\"),\n                    tab = $(anchor).closest(\"li\"),\n                    originalAriaControls = tab.attr(\"aria-controls\");\n\n                // inline tab\n                if (isLocal(anchor)) {\n                    selector = anchor.hash;\n                    panel = that.document.find(that._sanitizeSelector(selector));\n                    // remote tab\n                } else {\n                    panelId = that._tabId(tab);\n                    selector = \"#\" + panelId;\n                    panel = that.document.find(selector);\n                    if (!panel.length) {\n                        panel = that._createPanel(panelId);\n                        panel.insertAfter(that.panels[ i - 1 ] || that.tablist);\n                    }\n                    panel.attr(\"aria-live\", \"polite\");\n                }\n\n                if (panel.length) {\n                    that.panels = that.panels.add(panel);\n                }\n                if (originalAriaControls) {\n                    tab.data(\"ui-tabs-aria-controls\", originalAriaControls);\n                }\n                tab.attr({\n                    \"aria-controls\": selector.substring(1),\n                    \"aria-labelledby\": anchorId\n                });\n                panel.attr(\"aria-labelledby\", anchorId);\n                if (that.options.excludedPanel.indexOf(anchorId+'_content') < 0) {\n                    panel.addClass(that.options.tabPanelClass);\n                }\n            });\n\n            this.panels\n                .addClass(\"ui-tabs-panel ui-widget-content ui-corner-bottom\")\n                .attr(\"role\", \"tabpanel\");\n        },\n\n        /**\n         * Move panels in destination element\n         * @protected\n         * @override\n         */\n        _movePanelsInDestination: function(panels) {\n            if (this.options.destination && !panels.parents(this.options.destination).length) {\n                this.element.trigger('beforePanelsMove', panels);\n\n                panels.find('script:not([type]), script[type=\"text/javascript\"]').remove();\n\n                panels.appendTo(this.options.destination)\n                    .each($.proxy(function(i, panel) {\n                        $(panel).trigger('move.tabs', this.anchors.eq(i));\n                    }, this));\n            }\n        },\n\n        /**\n         * Move panels in destination element on tabs switching\n         * @protected\n         * @override\n         * @param {Object} event - event object\n         * @param {Object} eventData\n         */\n        _toggle: function(event, eventData) {\n            this._movePanelsInDestination(eventData.newPanel);\n            this._superApply(arguments);\n        }\n    });\n\n    // Extension for mage.tabs - Ajax functionality for tabs\n    $.widget('mage.tabs', $.mage.tabs, {\n        options: {\n            ajaxOptions: {\n                data: {\n                    isAjax: true,\n                    form_key: typeof FORM_KEY !== 'undefined' ? FORM_KEY : null\n                }\n            },\n\n            /**\n             * Replacing href attribute with loaded panel id\n             * @param {Object} event - event object\n             * @param {Object} ui\n             */\n            load: function(event, ui) {\n                var panel = $(ui.panel);\n                $(ui.tab).prop('href', '#' + panel.prop('id'));\n                panel.trigger('contentUpdated');\n            }\n        }\n    });\n\n    // Extension for mage.tabs - Attach event handlers to tabs\n    $.widget('mage.tabs', $.mage.tabs, {\n        options: {\n            tabIdArgument: 'tab',\n            tabsBlockPrefix: null\n        },\n\n        /**\n         * Attach event handlers to tabs, on creation\n         * @protected\n         * @override\n         */\n        _refresh: function() {\n            this._super();\n            $.each(this.tabs, $.proxy(function(i, tab) {\n                $(this._getPanelForTab(tab))\n                    .off('changed' + this.eventNamespace)\n                    .off('highlight.validate' + this.eventNamespace)\n                    .off('focusin' + this.eventNamespace)\n\n                    .on('changed' + this.eventNamespace, {index: i}, $.proxy(this._onContentChange, this))\n                    .on('highlight.validate' + this.eventNamespace, {index: i}, $.proxy(this._onInvalid, this))\n                    .on('focusin' + this.eventNamespace, {index: i}, $.proxy(this._onFocus, this));\n            }, this));\n\n            ($(this.options.destination).is('form') ?\n                $(this.options.destination) :\n                $(this.options.destination).closest('form'))\n                    .off('beforeSubmit' + this.eventNamespace)\n                    .on('beforeSubmit' + this.eventNamespace, $.proxy(this._onBeforeSubmit, this));\n        },\n\n        /**\n         * Mark tab as changed if some field inside tab panel is changed\n         * @protected\n         * @param {Object} e - event object\n         */\n        _onContentChange: function(e) {\n            var cssChanged = '_changed';\n\n            this.anchors.eq(e.data.index).addClass(cssChanged);\n            this._updateNavTitleMessages(e,cssChanged);\n        },\n\n        /**\n         * Clone messages (tooltips) from anchor to parent element\n         * @protected\n         * @param {Object} e - event object\n         * @param {string} messageType - changed or error\n         */\n        _updateNavTitleMessages: function(e, messageType) {\n            var curAnchor = this.anchors.eq(e.data.index),\n                curItem = curAnchor.parents('[data-role=\"container\"]').find('[data-role=\"title\"]'),\n                curItemMessages = curItem.find('[data-role=\"title-messages\"]'),\n                curItemMessage,\n                activeClass = \"_active\";\n\n            if ((curItemMessages).is(\":empty\")) {\n                curAnchor\n                    .find('[data-role=\"item-messages\"]')\n                    .clone()\n                    .appendTo(curItemMessages);\n            }\n\n            curItemMessage = curItemMessages.find('.' + messageType).addClass(activeClass);\n        },\n\n        /**\n         * Mark tab as error if some field inside tab panel is not passed validation\n         * @param {Object} e - event object\n         * @protected\n         */\n        _onInvalid: function(e) {\n            var cssError = '_error',\n                fakeEvent = e;\n\n            fakeEvent.currentTarget = $(this.anchors).eq(e.data.index);\n            this._eventHandler(fakeEvent);\n            this.anchors.eq(e.data.index).addClass(cssError).find('.' + cssError).show();\n            this._updateNavTitleMessages(e, cssError);\n        },\n\n        /**\n         * Show tab panel if focus event triggered of some field inside tab panel\n         * @param {Object} e - event object\n         * @protected\n         */\n        _onFocus: function(e) {\n            this.option(\"_active\", e.data.index);\n        },\n\n        /**\n         * Add active tab id in data object when \"beforeSubmit\" event is triggered\n         * @param {Object} e - event object\n         * @param {Object} data - event data object\n         * @protected\n         */\n        _onBeforeSubmit: function(e, data) {\n            var activeAnchor = this.activeAnchor(),\n                activeTabId = activeAnchor.prop('id');\n            if (this.options.tabsBlockPrefix) {\n                if (activeAnchor.is('[id*=\"' + this.options.tabsBlockPrefix + '\"]')) {\n                    activeTabId = activeAnchor.prop('id').substr(this.options.tabsBlockPrefix.length);\n                }\n            }\n            $(this.anchors).removeClass('error');\n            var options = {\n                action: {\n                    args: {}\n                }\n            };\n            options.action.args[this.options.tabIdArgument] = activeTabId;\n            data = data ? $.extend(data, options) : options;\n        }\n    });\n\n    // Extension for mage.tabs - Shadow tabs functionality\n    $.widget('mage.tabs', $.mage.tabs, {\n        /**\n         * Add shadow tabs functionality on creation\n         * @protected\n         * @override\n         */\n        _refresh: function() {\n            this._super();\n            var anchors = this.anchors,\n                shadowTabs = this.options.shadowTabs,\n                tabs = this.tabs;\n\n            if (shadowTabs) {\n                anchors.each($.proxy(function(i, anchor) {\n                    var anchorId = $(anchor).prop('id');\n                    if (shadowTabs[anchorId]) {\n                        $(anchor).parents('li').on('click', $.proxy(function() {\n                            $.each(shadowTabs[anchorId], $.proxy(function(i, id) {\n                                this.load($(tabs).index($('#' + id).parents('li')), {});\n                            }, this));\n                        }, this));\n                    }\n                }, this));\n            }\n        }\n    });\n\n    return $.mage.tabs;\n}));\n","mage/backend/tree-suggest.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui',\n            'jquery/jstree/jquery.jstree',\n            'mage/backend/suggest'\n        ], factory);\n    } else {\n        factory(root.jQuery);\n    }\n}(this, function ($) {\n    'use strict';\n\n    $.extend(true, $, {\n        // @TODO: Move method 'treeToList' in file with utility functions\n        mage: {\n            treeToList: function (list, nodes, level, path) {\n                $.each(nodes, function () {\n                    if ($.type(this) === 'object') {\n                        list.push({\n                            label: this.label,\n                            id: this.id,\n                            level: level,\n                            item: this,\n                            path: path + this.label\n                        });\n\n                        if (this.children) {\n                            $.mage.treeToList(list, this.children, level + 1, path + this.label + ' / ');\n                        }\n                    }\n                });\n\n                return list;\n            }\n        }\n    });\n\n    var hover_node = $.jstree._instance.prototype.hover_node,\n        dehover_node = $.jstree._instance.prototype.dehover_node,\n        select_node = $.jstree._instance.prototype.select_node,\n        init = $.jstree._instance.prototype.init;\n\n    $.extend(true, $.jstree._instance.prototype, {\n        /**\n         * @override\n         */\n        init: function () {\n            this.get_container()\n                .show()\n                .on('keydown', $.proxy(function (e) {\n                    if (e.keyCode === $.ui.keyCode.ENTER) {\n                        var o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n                        this.select_node(o, true);\n                    }\n                }, this));\n            init.call(this);\n        },\n\n        /**\n         * @override\n         */\n        hover_node: function (obj) {\n            hover_node.apply(this, arguments);\n            obj = this._get_node(obj);\n\n            if (!obj.length) {\n                return false;\n            }\n            this.get_container().trigger('hover_node', [{\n                item: obj.find('a:first')\n            }]);\n        },\n\n        /**\n         * @override\n         */\n        dehover_node: function () {\n            dehover_node.call(this);\n            this.get_container().trigger('dehover_node');\n        },\n\n        /**\n         * @override\n         */\n        select_node: function (o) {\n            select_node.apply(this, arguments);\n\n            var node = this._get_node(o);\n\n            (node ? $(node) : this.data.ui.last_selected)\n                .trigger('select_tree_node');\n        }\n    });\n\n    $.widget('mage.treeSuggest', $.mage.suggest, {\n        widgetEventPrefix: 'suggest',\n        options: {\n            template:\n                '<% if (data.items.length) { %>' +\n                    '<% if (data.allShown()) { %>' +\n                        '<% if (typeof data.nested === \"undefined\") { %>' +\n                            '<div style=\"display:none;\" data-mage-init=\"{&quot;jstree&quot;:{&quot;plugins&quot;:[&quot;themes&quot;,&quot;html_data&quot;,&quot;ui&quot;,&quot;hotkeys&quot;],&quot;themes&quot;:{&quot;theme&quot;:&quot;default&quot;,&quot;dots&quot;:false,&quot;icons&quot;:false}}}\">' +\n                        '<% } %>' +\n                        '<ul>' +\n                            '<% _.each(data.items, function(value) { %>' +\n                                '<li class=\"<% if (data.itemSelected(value)) { %>mage-suggest-selected<% } %><% if (value.is_active == 0) { %> mage-suggest-not-active<% } %>\">' +\n                                    '<a href=\"#\" <%= data.optionData(value) %>><%- value.label %></a>' +\n                                    '<% if (value.children && value.children.length) { %>' +\n                                        '<%= data.renderTreeLevel(value.children) %>' +\n                                    '<% } %>' +\n                                '</li>' +\n                            '<% }); %>' +\n                        '</ul>' +\n                        '<% if (typeof data.nested === \"undefined\") { %>' +\n                            '</div>' +\n                        '<% } %>' +\n                    '<% } else { %>' +\n                        '<ul data-mage-init=\"{&quot;menu&quot;:[]}\">' +\n                            '<% _.each(data.items, function(value) { %>' +\n                                '<% if (!data.itemSelected(value)) {%>' +\n                                    '<li <%= data.optionData(value) %>>' +\n                                        '<a href=\"#\">' +\n                                            '<span class=\"category-label\"><%- value.label %></span>' +\n                                            '<span class=\"category-path\"><%- value.path %></span>' +\n                                        '</a>' +\n                                    '</li>' +\n                                '<% } %>' +\n                            '<% }); %>' +\n                        '</ul>' +\n                    '<% } %>' +\n                '<% } else { %>' +\n                    '<span class=\"mage-suggest-no-records\"><%- data.noRecordsText %></span>' +\n                '<% } %>',\n            controls: {\n                selector: ':ui-menu, :mage-menu, .jstree',\n                eventsMap: {\n                    focus: ['menufocus', 'hover_node'],\n                    blur: ['menublur', 'dehover_node'],\n                    select: ['menuselect', 'select_tree_node']\n                }\n            }\n        },\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n            this._on({\n                keydown: function (event) {\n                    var keyCode = $.ui.keyCode;\n\n                    switch (event.keyCode) {\n                        case keyCode.LEFT:\n\n                        case keyCode.RIGHT:\n\n                            if (this.isDropdownShown()) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n                            break;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        close: function (e) {\n            var eType = e ? e.type : null;\n\n            if (eType === 'select_tree_node') {\n                this.element.focus();\n            } else {\n                this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _filterSelected: function (items, context) {\n            if (context._allShown) {\n                return items;\n            } else {\n                return this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _prepareDropdownContext: function () {\n            var context = this._superApply(arguments),\n                optionData = context.optionData,\n                templates = this.templates,\n                tmplName = this.templateName;\n\n            context.optionData = function (item) {\n                item = $.extend({}, item);\n                delete item.children;\n\n                return optionData(item);\n            };\n\n            return $.extend(context, {\n                renderTreeLevel: function (children) {\n                    var _context = $.extend({}, this, {\n                        items: children,\n                        nested: true\n                    }),\n                    tmpl = templates[tmplName];\n\n                    tmpl = tmpl({\n                        data: _context\n                    });\n\n                    return $('<div>').append($(tmpl)).html();\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        _processResponse: function (e, items, context) {\n            if (context && !context._allShown) {\n                items = this.filter($.mage.treeToList([], items, 0, ''), this._term);\n            }\n            var control = this.dropdown.find(this._control.selector);\n\n            if (control.length && control.hasClass('jstree')) {\n                control.jstree('destroy');\n            }\n            this._superApply([e, items, context]);\n        }\n    });\n\n    return $.mage.treeSuggest;\n}));\n","mage/backend/validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint jquery:true browser:true*/\n/*global BASE_URL:true*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"underscore\",\n            'Magento_Ui/js/modal/alert',\n            \"jquery/ui\",\n            \"jquery/validate\",\n            \"mage/translate\",\n            \"mage/validation\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($, _, alert) {\n    \"use strict\";\n    \n    $.extend(true, $.validator.prototype, {\n        /**\n         * Focus invalid fields\n         */\n        focusInvalid: function() {\n            if (this.settings.focusInvalid) {\n                try {\n                    $(this.errorList.length && this.errorList[0].element || [])\n                        .focus()\n                        .trigger(\"focusin\");\n                } catch (e) {\n                    // ignore IE throwing errors when focusing hidden elements\n                }\n            }\n        },\n        elements: function () {\n            var validator = this,\n                rulesCache = {};\n\n            // select all valid inputs inside the form (no submit or reset buttons)\n            return $(this.currentForm)\n                .find(\"input, select, textarea\")\n                .not(this.settings.forceIgnore)\n                .not(':submit, :reset, :image, [disabled]')\n                .not(this.settings.ignore)\n                .filter(function () {\n                    if (!this.name && validator.settings.debug && window.console) {\n                        console.error('%o has no name assigned', this);\n                    }\n\n                    // select only the first element for each name, and only those with rules specified\n                    if (this.name in rulesCache || !validator.objectLength($(this).rules())) {\n                        return false;\n                    }\n\n                    rulesCache[this.name] = true;\n\n                    return true;\n                });\n        }\n    });\n\n    $.extend($.fn, {\n        /**\n         * ValidationDelegate overridden for those cases where the form is located in another form,\n         *     to avoid not correct working of validate plug-in\n         * @override\n         * @param {string} delegate - selector, if event target matched against this selector,\n         *     then event will be delegated\n         * @param {string} type - event type\n         * @param {function} handler - event handler\n         * @return {Element}\n         */\n        validateDelegate: function (delegate, type, handler) {\n            return this.on(type, $.proxy(function (event) {\n                var target = $(event.target);\n                var form = target[0].form;\n                if(form && $(form).is(this) && $.data(form, \"validator\") && target.is(delegate)) {\n                    return handler.apply(target, arguments);\n                }\n            }, this));\n        }\n    });\n\n    $.widget(\"mage.validation\", $.mage.validation, {\n        options: {\n            messagesId: 'messages',\n            forceIgnore: '',\n            ignore: ':disabled, .ignore-validate, .no-display.template, ' +\n                ':disabled input, .ignore-validate input, .no-display.template input, ' +\n                ':disabled select, .ignore-validate select, .no-display.template select, ' +\n                ':disabled textarea, .ignore-validate textarea, .no-display.template textarea',\n            errorElement: 'label',\n            errorUrl: typeof BASE_URL !== 'undefined' ? BASE_URL : null,\n            highlight: function(element) {\n                if ($.validator.defaults.highlight && $.isFunction($.validator.defaults.highlight)) {\n                    $.validator.defaults.highlight.apply(this, arguments);\n                }\n                $(element).trigger('highlight.validate');\n            },\n            unhighlight: function(element) {\n                if ($.validator.defaults.unhighlight && $.isFunction($.validator.defaults.unhighlight)) {\n                    $.validator.defaults.unhighlight.apply(this, arguments);\n                }\n                $(element).trigger('unhighlight.validate');\n            }\n        },\n\n        /**\n         * Validation creation\n         * @protected\n         */\n        _create: function() {\n            if (!this.options.submitHandler && $.type(this.options.submitHandler) !== 'function') {\n                if (!this.options.frontendOnly && this.options.validationUrl) {\n                    this.options.submitHandler = $.proxy(this._ajaxValidate, this);\n                } else {\n                    this.options.submitHandler = $.proxy(this._submit, this);\n                }\n            }\n            this.element.on('resetElement', function(e) {$(e.target).rules('remove');});\n            this._super('_create');\n        },\n\n        /**\n         * ajax validation\n         * @protected\n         */\n        _ajaxValidate: function() {\n            $.ajax({\n                url: this.options.validationUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: this.element.serialize(),\n                context: $('body'),\n                success: $.proxy(this._onSuccess, this),\n                error: $.proxy(this._onError, this),\n                showLoader: true,\n                dontHide: false\n            });\n        },\n\n        /*\n         * Process ajax success\n         * @protected\n         * @param {Object} JSON-response\n         * @param {string} response status\n         * @param {Object} The jQuery XMLHttpRequest object returned by $.ajax()\n         */\n        _onSuccess: function(response) {\n            if (!response.error) {\n                this._submit();\n            } else {\n                this._showErrors(response);\n                $('body').trigger('processStop');\n            }\n        },\n\n        /**\n         * Submitting a form\n         * @private\n         */\n        _submit: function() {\n            $(this.element[0]).trigger('afterValidate.beforeSubmit');\n            this.element[0].submit();\n        },\n\n        /**\n         * Displays errors after backend validation.\n         * @param {Object} data - Data that came from backend.\n         */\n        _showErrors: function(data) {\n            $('body').notification('clear')\n                .notification('add', {\n                    error: data.error,\n                    message: data.message,\n                    insertMethod: function(message) {\n                        $('.messages:first').html(message);\n                    }\n                });\n        },\n\n        /**\n         * Tries to retrieve element either by id or by inputs' name property.\n         * @param {String} code - String to search by.\n         * @returns {jQuery} jQuery element.\n         */\n        _getByCode: function(code) {\n            var parent = this.element[0],\n                element;\n\n            element = parent.querySelector('#' + code) || parent.querySelector('input[name=' + code + ']');\n\n            return $(element);\n        },\n\n        /*\n         * Process ajax error\n         * @protected\n         */\n        _onError: function() {\n            this.trigger('processStop');\n            \n            if (this.options.errorUrl) {\n                location.href = this.options.errorUrl;\n            }\n        }\n    });\n\n    _.each({\n        'validate-greater-zero-based-on-option': [\n            function (v, el) {\n                var optionType = $(el)\n                    .closest('.form-list')\n                    .prev('.fieldset-alt')\n                    .find('select.select-product-option-type'),\n                    optionTypeVal = optionType.val();\n                v = Number(v) || 0;\n                if (optionType && (optionTypeVal == 'checkbox' || optionTypeVal == 'multi') && v <= 0) {\n                    return false;\n                }\n                return true;\n            },\n            'Please enter a number greater 0 in this field.'\n        ],\n        'validate-rating': [\n            function () {\n                var ratings = $('#detailed_rating').find('.field-rating'),\n                    noError = true;\n\n                ratings.each(function (index, rating) {\n                    noError = noError && $(rating).find('input:checked').length > 0;\n                });\n                return noError;\n            },\n            'Please select one of each ratings above.'\n        ],\n        'validate-downloadable-file': [\n            function (v, element) {\n                var elmParent = $(element).parent(),\n                    linkType = elmParent.find('input[value=\"file\"]'),\n                    newFileContainer;\n\n                if (linkType.is(':checked') && (v === '' || v === '[]')) {\n                    newFileContainer = elmParent.find('.new-file');\n                    if (!alertAlreadyDisplayed && (newFileContainer.empty() || newFileContainer.is(':visible'))) {\n                        alertAlreadyDisplayed = true;\n                        alert({\n                            content: $.mage.__('There are files that were selected but not uploaded yet. ' +\n                            'Please upload or remove them first')\n                        });\n                    }\n                    return false;\n                }\n                return true;\n            },\n            'Please upload a file.'\n        ],\n        'validate-downloadable-url': [\n            function (v, element) {\n                var linkType = $(element).parent().find('input[value=\"url\"]');\n                if (linkType.is(':checked') && v === '') {\n                    return false;\n                }\n                return true;\n            },\n            'Please specify Url.'\n        ]\n    }, function (rule, i) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n\n    return $.mage.validation;\n}));\n","mage/requirejs/resolver.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'domReady!'\n], function (_) {\n    'use strict';\n\n    var context     = require.s.contexts._,\n        execCb      = context.execCb,\n        registry    = context.registry,\n        callbacks   = [],\n        retries     = 10,\n        updateDelay = 1,\n        ready,\n        update;\n\n    /**\n     * Checks if provided callback already exists in the callbacks list.\n     *\n     * @param {Object} callback - Callback object to be checked.\n     * @returns {Boolean}\n     */\n    function isSubscribed(callback) {\n        return !!_.findWhere(callbacks, callback);\n    }\n\n    /**\n     * Checks if provided module has unresolved dependencies.\n     *\n     * @param {Object} module - Module to be checked.\n     * @returns {Boolean}\n     */\n    function isPending(module) {\n        return !!module.depCount;\n    }\n\n    /**\n     * Checks if requirejs's registry object contains pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function hasPending() {\n        return _.some(registry, isPending);\n    }\n\n    /**\n     * Checks if 'resolver' module is in ready\n     * state and that there are no pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function isReady() {\n        return ready && !hasPending();\n    }\n\n    /**\n     * Invokes provided callback handler.\n     *\n     * @param {Object} callback\n     */\n    function invoke(callback) {\n        callback.handler.call(callback.ctx);\n    }\n\n    /**\n     * Sets 'resolver' module to a ready state\n     * and invokes pending callbacks.\n     */\n    function resolve() {\n        ready = true;\n\n        callbacks.splice(0).forEach(invoke);\n    }\n\n    /**\n     * Drops 'ready' flag and runs the update process.\n     */\n    function tick() {\n        ready = false;\n\n        update(retries);\n    }\n\n    /**\n     * Adds callback which will be invoked\n     * when all of the pending modules are initiated.\n     *\n     * @param {Function} handler - 'Ready' event handler function.\n     * @param {Object} [ctx] - Optional context with which handler\n     *      will be invoked.\n     */\n    function subscribe(handler, ctx) {\n        var callback = {\n            handler: handler,\n            ctx: ctx\n        };\n\n        if (!isSubscribed(callback)) {\n            callbacks.push(callback);\n\n            if (isReady()) {\n                _.defer(tick);\n            }\n        }\n    }\n\n    /**\n     * Checks for all modules to be initiated\n     * and invokes pending callbacks if it's so.\n     *\n     * @param {Number} [retry] - Number of retries\n     *      that will be used to repeat the 'update' function\n     *      invokation in case if there are no pending requests.\n     */\n    update = _.debounce(function (retry) {\n        if (!hasPending()) {\n            retry ? update(--retry) : resolve();\n        }\n    }, updateDelay);\n\n    /**\n     * Overrides requirejs's original 'execCb' method\n     * in order to track pending modules.\n     *\n     * @returns {*} Result of original method call.\n     */\n    context.execCb = function () {\n        var exported = execCb.apply(context, arguments);\n\n        tick();\n\n        return exported;\n    };\n\n    return subscribe;\n});\n","mage/requirejs/text.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* inspired by http://github.com/requirejs/text */\n/*global XMLHttpRequest, XDomainRequest */\n\ndefine(['module'], function (module) {\n    'use strict';\n\n    var xmlRegExp = /^\\s*<\\?xml(\\s)+version=[\\'\\\"](\\d)*.(\\d)*[\\'\\\"](\\s)*\\?>/im,\n        bodyRegExp = /<body[^>]*>\\s*([\\s\\S]+)\\s*<\\/body>/im,\n        stripReg = /!strip$/i,\n        defaultConfig = module.config && module.config() || {};\n\n    /**\n     * Strips <?xml ...?> declarations so that external SVG and XML documents can be\n     * added to a document without worry.\n     * Also, if the string is an HTML document, only the part inside the body tag is returned.\n     *\n     * @param {String} external\n     * @returns {String}\n     */\n    function stripContent(external) {\n        var matches;\n\n        if (!external) {\n            return '';\n        }\n\n        matches = external.match(bodyRegExp);\n        external = matches ?\n            matches[1] :\n            external.replace(xmlRegExp, '');\n\n        return external;\n    }\n\n    /**\n     * Checks that url match current location\n     *\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    function sameDomain(url) {\n        var uProtocol, uHostName, uPort,\n            xdRegExp = /^([\\w:]+)?\\/\\/([^\\/\\\\]+)/i,\n            location = window.location,\n            match = xdRegExp.exec(url);\n\n        if (!match) {\n            return true;\n        }\n        uProtocol = match[1];\n        uHostName = match[2];\n\n        uHostName = uHostName.split(':');\n        uPort = uHostName[1] || '';\n        uHostName = uHostName[0];\n\n        return (!uProtocol || uProtocol === location.protocol) &&\n            (!uHostName || uHostName.toLowerCase() === location.hostname.toLowerCase()) &&\n            (!uPort && !uHostName || uPort === location.port);\n    }\n\n    /**\n     * @returns {XMLHttpRequest|XDomainRequest|null}\n     */\n    function createRequest(url) {\n        var xhr = new XMLHttpRequest();\n\n        if (!sameDomain(url) && typeof XDomainRequest !== 'undefined') {\n            xhr = new XDomainRequest();\n        }\n\n        return xhr;\n    }\n\n    /**\n     * XHR requester. Returns value to callback.\n     *\n     * @param {String} url\n     * @param {Function} callback\n     * @param {Function} fail\n     * @param {Object} headers\n     */\n    function getContent(url, callback, fail, headers) {\n        var xhr = createRequest(url),\n            header,\n            errorHandler = fail || Function();\n\n        /*eslint-disable max-depth */\n        if ('setRequestHeader' in xhr && headers) {\n            for (header in headers) {\n                if (headers.hasOwnProperty(header)) {\n                    xhr.setRequestHeader(header.toLowerCase(), headers[header]);\n                }\n            }\n        }\n\n        /*eslint-enable max-depth */\n\n        if (defaultConfig.onXhr) {\n            defaultConfig.onXhr(xhr, url);\n        }\n\n        /**\n         * onload handler\n         */\n        xhr.onload = function () {\n\n            callback(xhr.responseText);\n\n            if (defaultConfig.onXhrComplete) {\n                defaultConfig.onXhrComplete(xhr, url);\n            }\n        };\n\n        /**\n         * onerror handler\n         */\n        xhr.onerror = function (event) {\n            errorHandler(event);\n\n            if (defaultConfig.onXhrFailure) {\n                defaultConfig.onXhrFailure(xhr, url, event);\n            }\n        };\n\n        xhr.open('GET', url);\n        xhr.send();\n    }\n\n    /**\n     * Main method used by RequireJs.\n     *\n     * @param {String} name - has format: some.module.filext!strip\n     * @param {Function} req\n     * @param {Function|undefined} onLoad\n     */\n    function loadContent(name, req, onLoad) {\n\n        var toStrip = stripReg.test(name),\n            url = req.toUrl(name.replace(stripReg, '')),\n            headers = defaultConfig.headers;\n\n        getContent(url, function (content) {\n                content = toStrip ? stripContent(content) : content;\n                onLoad(content);\n            }, onLoad.error, headers);\n    }\n\n    return {\n        load: loadContent,\n        get: getContent\n    };\n});\n","mage/utils/arrays.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    './strings'\n], function (_, utils) {\n    'use strict';\n\n    /**\n     * Defines index of an item in a specified container.\n     *\n     * @param {*} item - Item whose index should be defined.\n     * @param {Array} container - Container upon which to perform search.\n     * @returns {Number}\n     */\n    function getIndex(item, container) {\n        var index = container.indexOf(item);\n\n        if (~index) {\n            return index;\n        }\n\n        return _.findIndex(container, function (value) {\n            return value && value.name === item;\n        });\n    }\n\n    return {\n       /**\n         * Facade method to remove/add value from/to array\n         * without creating a new instance.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to add/remove.\n         * @param {Boolean} add - Flag that specfies operation.\n         * @returns {Utils} Chainable.\n         */\n        toggle: function (arr, value, add) {\n            return add ?\n                this.add(arr, value) :\n                this.remove(arr, value);\n        },\n\n        /**\n         * Removes the incoming value from array in case\n         * without creating a new instance of it.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to be removed.\n         * @returns {Utils} Chainable.\n         */\n        remove: function (arr, value) {\n            var index = arr.indexOf(value);\n\n            if (~index) {\n                arr.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds the incoming value to array if\n         * it's not alredy present in there.\n         *\n         * @param {Array} arr - Array to be modifed.\n         * @param {...*} Values to be added.\n         * @returns {Utils} Chainable.\n         */\n        add: function (arr) {\n            var values = _.toArray(arguments).slice(1);\n\n            values.forEach(function (value) {\n                if (!~arr.indexOf(value)) {\n                    arr.push(value);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Inserts specified item into container at a specified position.\n         *\n         * @param {*} item - Item to be inserted into container.\n         * @param {Array} container - Container of items.\n         * @param {*} [position=-1] - Position at which item should be inserted.\n         *      Position can represent:\n         *          - specific index in container\n         *          - item which might already be present in container\n         *          - structure with one of these properties: after, before\n         * @returns {Boolean|*}\n         *      - true if element has changed its' position\n         *      - false if nothing has changed\n         *      - inserted value if it wasn't present in container\n         */\n        insert: function (item, container, position) {\n            var currentIndex = getIndex(item, container),\n                newIndex,\n                target;\n\n            if (typeof position === 'undefined') {\n                position = -1;\n            } else if (typeof position === 'string') {\n                position = isNaN(+position) ? position : +position;\n            }\n\n            newIndex = position;\n\n            if (~currentIndex) {\n                target = container.splice(currentIndex, 1)[0];\n\n                if (typeof item === 'string') {\n                    item = target;\n                }\n            }\n\n            if (typeof position !== 'number') {\n                target = position.after || position.before || position;\n\n                newIndex = getIndex(target, container);\n\n                if (~newIndex && (position.after || newIndex >= currentIndex)) {\n                    newIndex++;\n                }\n            }\n\n            if (newIndex < 0) {\n                newIndex += container.length + 1;\n            }\n\n            container[newIndex] ?\n                container.splice(newIndex, 0, item) :\n                container[newIndex] = item;\n\n            return !~currentIndex ? item : currentIndex !== newIndex;\n        },\n\n        formatOffset: function (elems, offset) {\n            if (utils.isEmpty(offset)) {\n                offset = -1;\n            }\n\n            offset = +offset;\n\n            if (offset < 0) {\n                offset += elems.length + 1;\n            }\n\n            return offset;\n        }\n    };\n});\n","mage/utils/compare.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mage/utils/objects'\n], function (_, utils) {\n    'use strict';\n\n    var result = [];\n\n    /**\n     * Checks if all of the provided arrays contains equal values.\n     *\n     * @param {(Boolean|Array)} [keepOrder=false]\n     * @param {Array} target\n     * @returns {Boolean}\n     */\n    function equalArrays(keepOrder, target) {\n        var args = _.toArray(arguments),\n            arrays;\n\n        if (!Array.isArray(keepOrder)) {\n            arrays      = args.slice(2);\n        } else {\n            target      = keepOrder;\n            keepOrder   = false;\n            arrays      = args.slice(1);\n        }\n\n        if (!arrays.length) {\n            return true;\n        }\n\n        return arrays.every(function (array) {\n            if (array === target) {\n                return true;\n            } else if (array.length !== target.length) {\n                return false;\n            } else if (!keepOrder) {\n                return !_.difference(target, array).length;\n            }\n\n            return array.every(function (value, index) {\n                return target.indexOf(value) === index;\n            });\n        });\n    }\n\n    /**\n     * Checks if two values are different.\n     *\n     * @param {*} a - First value.\n     * @param {*} b - Second value.\n     * @returns {Boolean}\n     */\n    function isDifferent(a, b) {\n        var oldIsPrimitive = utils.isPrimitive(a);\n\n        if (Array.isArray(a) && Array.isArray(b)) {\n            return !equalArrays(true, a, b);\n        }\n\n        return oldIsPrimitive ? a !== b : true;\n    }\n\n    /**\n     * @param {String} prefix\n     * @param {String} part\n     */\n    function getPath(prefix, part) {\n        return prefix ? prefix + '.' + part : part;\n    }\n\n    /**\n     * Checks if object has own specified property.\n     *\n     * @param {*} obj - Value to be checked.\n     * @param {String} key - Key of the property.\n     * @returns {Boolean}\n     */\n    function hasOwn(obj, key) {\n        return Object.prototype.hasOwnProperty.call(obj, key);\n    }\n\n    /**\n     * @param {Array} changes\n     */\n    function getContainers(changes) {\n        var containers  = {},\n            indexed     = _.indexBy(changes, 'path');\n\n        _.each(indexed, function (change, name) {\n            var path;\n\n            name.split('.').forEach(function (part) {\n                path = getPath(path, part);\n\n                if (path in indexed) {\n                    return;\n                }\n\n                (containers[path] = containers[path] || []).push(change);\n            });\n        });\n\n        return containers;\n    }\n\n    /**\n     * @param {String} path\n     * @param {String} name\n     * @param {String} type\n     * @param {String} newValue\n     * @param {String} oldValue\n     */\n    function addChange(path, name, type, newValue, oldValue) {\n        var data;\n\n        data = {\n            path: path,\n            name: name,\n            type: type\n        };\n\n        if (type !== 'remove') {\n            data.value = newValue;\n            data.oldValue = oldValue;\n        } else {\n            data.oldValue = newValue;\n        }\n\n        result.push(data);\n    }\n\n    /**\n     * @param {String} ns\n     * @param {String} name\n     * @param {String} type\n     * @param {String} iterator\n     * @param {String} placeholder\n     */\n    function setAll(ns, name, type, iterator, placeholder) {\n        var key;\n\n        if (arguments.length > 4) {\n            type === 'add' ?\n                addChange(ns, name, 'update', iterator, placeholder) :\n                addChange(ns, name, 'update', placeholder, iterator);\n        } else {\n            addChange(ns, name, type, iterator);\n        }\n\n        if (!utils.isObject(iterator)) {\n            return;\n        }\n\n        for (key in iterator) {\n            if (hasOwn(iterator, key)) {\n                setAll(getPath(ns, key), key, type, iterator[key]);\n            }\n        }\n    }\n\n    /*eslint-disable max-depth*/\n    /**\n     * @param {Object} old\n     * @param {Object} current\n     * @param {String} ns\n     * @param {String} name\n     */\n    function compare(old, current, ns, name) {\n        var key,\n            oldIsObj = utils.isObject(old),\n            newIsObj = utils.isObject(current);\n\n        if (oldIsObj && newIsObj) {\n            for (key in old) {\n                if (hasOwn(old, key) && !hasOwn(current, key)) {\n                    setAll(getPath(ns, key), key, 'remove', old[key]);\n                }\n            }\n\n            for (key in current) {\n                if (hasOwn(current, key)) {\n                    hasOwn(old, key) ?\n                        compare(old[key], current[key], getPath(ns, key), key) :\n                        setAll(getPath(ns, key), key, 'add', current[key]);\n                }\n            }\n        } else if (oldIsObj) {\n            setAll(ns, name, 'remove', old, current);\n        } else if (newIsObj) {\n            setAll(ns, name, 'add', current, old);\n        } else if (isDifferent(old, current)) {\n            addChange(ns, name, 'update', current, old);\n        }\n    }\n\n    /*eslint-enable max-depth*/\n\n    return {\n\n        /**\n         *\n         * @returns {Object}\n         */\n        compare: function () {\n            var changes;\n\n            compare.apply(null, arguments);\n\n            changes = result.splice(0);\n\n            return {\n                containers: getContainers(changes),\n                changes: changes,\n                equal: !changes.length\n            };\n        },\n\n        equalArrays: equalArrays\n    };\n});\n","mage/utils/misc.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'FormData'\n], function (_, $) {\n    'use strict';\n\n    var defaultAttributes,\n        ajaxSettings,\n        map;\n\n    defaultAttributes = {\n        method: 'post',\n        enctype: 'multipart/form-data'\n    };\n\n    ajaxSettings = {\n        default: {\n            method: 'POST',\n            cache: false,\n            processData: false,\n            contentType: false\n        },\n        simple: {\n            method: 'POST',\n            dataType: 'json'\n        }\n    };\n\n    map = {\n        'D': 'DDD',\n        'dd': 'DD',\n        'd': 'D',\n        'EEEE': 'dddd',\n        'EEE': 'ddd',\n        'e': 'd',\n        'y': 'YYYY',\n        'a': 'A'\n    };\n\n    return {\n\n        /**\n         * Generates a unique identifier.\n         *\n         * @param {Number} [size=7] - Length of a resulting identifier.\n         * @returns {String}\n         */\n        uniqueid: function (size) {\n            var code = Math.random() * 25 + 65 | 0,\n                idstr = String.fromCharCode(code);\n\n            size = size || 7;\n\n            while (idstr.length < size) {\n                code = Math.floor(Math.random() * 42 + 48);\n\n                if (code < 58 || code > 64) {\n                    idstr += String.fromCharCode(code);\n                }\n            }\n\n            return idstr;\n        },\n\n        /**\n         * Limits function call.\n         *\n         * @param {Object} owner\n         * @param {String} target\n         * @param {Number} limit\n         */\n        limit: function (owner, target, limit) {\n            var fn = owner[target];\n\n            owner[target] = _.debounce(fn.bind(owner), limit);\n        },\n\n        /**\n         * Converts mage date format to a moment.js format.\n         *\n         * @param {String} mageFormat\n         * @returns {String}\n         */\n        normalizeDate: function (mageFormat) {\n            var result = mageFormat;\n\n            _.each(map, function (moment, mage) {\n                result = result.replace(mage, moment);\n            });\n\n            return result;\n        },\n\n        /**\n         * Puts provided value in range of min and max parameters.\n         *\n         * @param {Number} value - Value to be located.\n         * @param {Number} min - Min value.\n         * @param {Number} max - Max value.\n         * @returns {Number}\n         */\n        inRange: function (value, min, max) {\n            return Math.min(Math.max(min, value), max);\n        },\n\n        /**\n         * Serializes and sends data via POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} attrs - Attributes that will be added to virtual form.\n         */\n        submit: function (options, attrs) {\n            var form        = document.createElement('form'),\n                data        = this.serialize(options.data),\n                attributes  = _.extend({}, defaultAttributes, attrs || {}),\n                field;\n\n            if (!attributes.action) {\n                attributes.action = options.url;\n            }\n\n            data['form_key'] = window.FORM_KEY;\n\n            _.each(attributes, function (value, name) {\n                form.setAttribute(name, value);\n            });\n\n            _.each(data, function (value, name) {\n                field = document.createElement('input');\n\n                field.setAttribute('name', name);\n                field.setAttribute('type', 'hidden');\n\n                field.value = value;\n\n                form.appendChild(field);\n            });\n\n            document.body.appendChild(form);\n\n            form.submit();\n        },\n\n        /**\n         * Serializes and sends data via AJAX POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} config\n         */\n        ajaxSubmit: function (options, config) {\n            var t = new Date().getTime(),\n                settings;\n\n            options.data['form_key'] = window.FORM_KEY;\n            options.data = this.prepareFormData(options.data, config.ajaxSaveType);\n            settings = _.extend({}, ajaxSettings[config.ajaxSaveType], options || {});\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (data) {\n                    data.t = t;\n                    config.response.data(data);\n                    config.response.status(undefined);\n                    config.response.status(!data.error);\n                })\n                .fail(function (xhr) {\n                    config.response.status(undefined);\n                    config.response.status(false);\n                    config.response.data({\n                        error: true,\n                        messages: xhr.statusText,\n                        t: t\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n        },\n\n        /**\n         * Creates FormData object and append this data.\n         *\n         * @param {Object} data\n         * @param {String} type\n         * @returns {FormData}\n         */\n        prepareFormData: function (data, type) {\n            var formData;\n\n            if (type === 'default') {\n                formData = new FormData();\n                _.each(this.serialize(data), function (val, name) {\n                    formData.append(name, val);\n                });\n            } else if (type === 'simple') {\n                formData = this.serialize(data);\n            }\n\n            return formData;\n        }\n    };\n});\n","mage/utils/objects.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore'\n], function (ko, $, _) {\n    'use strict';\n\n    var primitives = [\n        'undefined',\n        'boolean',\n        'number',\n        'string'\n    ];\n\n    /**\n     * Sets nested property of a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @param {*} value - Value of the last property in 'path' array.\n     * returns {*} New value for the property.\n     */\n    function setNested(parent, path, value) {\n        var last = path.pop(),\n            len = path.length,\n            pi = 0,\n            part = path[pi];\n\n        for (; pi < len; part = path[++pi]) {\n            if (!_.isObject(parent[part])) {\n                parent[part] = {};\n            }\n\n            parent = parent[part];\n        }\n\n        if (typeof parent[last] === 'function') {\n            parent[last](value);\n        } else {\n            parent[last] = value;\n        }\n\n        return value;\n    }\n\n    /**\n     * Retrieves value of a nested property.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @returns {*} Value of the property.\n     */\n    function getNested(parent, path) {\n        var exists = true,\n            len = path.length,\n            pi = 0;\n\n        for (; pi < len && exists; pi++) {\n            parent = parent[path[pi]];\n\n            if (typeof parent === 'undefined') {\n                exists = false;\n            }\n        }\n\n        if (exists) {\n            if (ko.isObservable(parent)) {\n                parent = parent();\n            }\n\n            return parent;\n        }\n    }\n\n    /**\n     * Removes property from a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object from which to remove property.\n     * @param {Array} path - Splitted path to the propery.\n     */\n    function removeNested(parent, path) {\n        var field = path.pop();\n\n        parent = getNested(parent, path);\n\n        if (_.isObject(parent)) {\n            delete parent[field];\n        }\n    }\n\n    return {\n\n        /**\n         * Retrieves or defines objects' property by a composite path.\n         *\n         * @param {Object} data - Container for the properties specified in path.\n         * @param {String} path - Objects' properties divided by dots.\n         * @param {*} [value] - New value for the last property.\n         * @returns {*} Returns value of the last property in chain.\n         *\n         * @example\n         *      utils.nested({}, 'one.two', 3);\n         *      => { one: {two: 3} }\n         */\n        nested: function (data, path, value) {\n            var action = arguments.length > 2 ? setNested : getNested;\n\n            path = path ? path.split('.') : [];\n\n            return action(data, path, value);\n        },\n\n        /**\n         * Removes nested property from an object.\n         *\n         * @param {Object} data - Data source.\n         * @param {String} path - Path to the property e.g. 'one.two.three'\n         */\n        nestedRemove: function (data, path) {\n            path = path.split('.');\n\n            removeNested(data, path);\n        },\n\n        /**\n         * Flattens objects' nested properties.\n         *\n         * @param {Object} data - Object to flatten.\n         * @param {String} [separator='.'] - Objects' keys separator.\n         * @returns {Object} Flattened object.\n         *\n         * @example Example with a default separator.\n         *      utils.flatten({one: { two: { three: 'value'} }});\n         *      => { 'one.two.three': 'value' };\n         *\n         * @example Example with a custom separator.\n         *      utils.flatten({one: { two: { three: 'value'} }}, '=>');\n         *      => {'one=>two=>three': 'value'};\n         */\n        flatten: function (data, separator, parent, result) {\n            separator = separator || '.';\n            result = result || {};\n\n            _.each(data, function (node, name) {\n                if (parent) {\n                    name = parent + separator + name;\n                }\n\n                typeof node === 'object' ?\n                    this.flatten(node, separator, name, result) :\n                    result[name] = node;\n\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Opposite operation of the 'flatten' method.\n         *\n         * @param {Object} data - Previously flattened object.\n         * @param {String} [separator='.'] - Keys separator.\n         * @returns {Object} Object with nested properties.\n         *\n         * @example Example using custom separator.\n         *      utils.unflatten({'one=>two': 'value'}, '=>');\n         *      => {\n         *          one: { two: 'value' }\n         *      };\n         */\n        unflatten: function (data, separator) {\n            var result = {};\n\n            separator = separator || '.';\n\n            _.each(data, function (value, nodes) {\n                nodes = nodes.split(separator);\n\n                setNested(result, nodes, value);\n            });\n\n            return result;\n        },\n\n        /**\n         * Same operation as 'flatten' method,\n         * but returns objects' keys wrapped in '[]'.\n         *\n         * @param {Object} data - Object that should be serialized.\n         * @returns {Object} Serialized data.\n         *\n         * @example\n         *      utils.serialize({one: { two: { three: 'value'} }});\n         *      => { 'one[two][three]': 'value' }\n         */\n        serialize: function (data) {\n            var result = {};\n\n            data = this.flatten(data);\n\n            _.each(data, function (value, keys) {\n                keys = this.serializeName(keys);\n                value = _.isUndefined(value) ? '' : value;\n\n                result[keys] = value;\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Performs deep extend of specified objects.\n         *\n         * @returns {Object|Array} Extended object.\n         */\n        extend: function () {\n            var args = _.toArray(arguments);\n\n            args.unshift(true);\n\n            return $.extend.apply($, args);\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         *\n         * @param {(Object|Array)} data - Data that should be copied.\n         * @returns {Object|Array} Cloned object.\n         */\n        copy: function (data) {\n            var result = data,\n                isArray = Array.isArray(data),\n                placeholder;\n\n            if (this.isObject(data) || isArray) {\n                placeholder = isArray ? [] : {};\n                result = this.extend(placeholder, data);\n            }\n\n            return result;\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         * Doesn't save links to original object.\n         *\n         * @param {*} original - Object to clone\n         * @returns {*}\n         */\n        hardCopy: function (original) {\n            if (original === null || typeof original !== 'object') {\n                return original;\n            }\n\n            return JSON.parse(JSON.stringify(original));\n        },\n\n        /**\n         * Removes specified nested properties from the target object.\n         *\n         * @param {Object} target - Object whose properties should be removed.\n         * @param {(...String|Array|Object)} list - List that specifies properties to be removed.\n         * @returns {Object} Modified object.\n         *\n         * @example Basic usage\n         *      var obj = {a: {b: 2}, c: 'a'};\n         *\n         *      omit(obj, 'a.b');\n         *      => {'a.b': 2};\n         *      obj => {a: {}, c: 'a'};\n         *\n         * @example Various syntaxes that would return same result\n         *      omit(obj, ['a.b', 'c']);\n         *      omit(obj, 'a.b', 'c');\n         *      omit(obj, {'a.b': true, 'c': true});\n         */\n        omit: function (target, list) {\n            var removed = {},\n                ignored = list;\n\n            if (this.isObject(list)) {\n                ignored = [];\n\n                _.each(list, function (value, key) {\n                    if (value) {\n                        ignored.push(key);\n                    }\n                });\n            } else if (_.isString(list)) {\n                ignored = _.toArray(arguments).slice(1);\n            }\n\n            _.each(ignored, function (path) {\n                var value = this.nested(target, path);\n\n                if (!_.isUndefined(value)) {\n                    removed[path] = value;\n\n                    this.nestedRemove(target, path);\n                }\n            }, this);\n\n            return removed;\n        },\n\n        /**\n         * Checks if provided value is a plain object.\n         *\n         * @param {*} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isObject: function (value) {\n            var objProto = Object.prototype;\n\n            return typeof value == 'object' ?\n            objProto.toString.call(value) === '[object Object]' :\n                false;\n        },\n\n        /**\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isPrimitive: function (value) {\n            return value === null || ~primitives.indexOf(typeof value);\n        },\n\n        /**\n         * Iterates over obj props/array elems recursively, applying action to each one\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to be called with each item as an argument.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         */\n        forEachRecursive: function (data, action, maxDepth) {\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return;\n            }\n\n            if (!_.isObject(data)) {\n                action(data);\n\n                return;\n            }\n\n            _.each(data, function (value) {\n                this.forEachRecursive(value, action, maxDepth);\n            }, this);\n\n            action(data);\n        },\n\n        /**\n         * Maps obj props/array elems recursively\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to transform each item.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         *\n         * @returns {Object|Array}\n         */\n        mapRecursive: function (data, action, maxDepth) {\n            var newData;\n\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return data;\n            }\n\n            if (!_.isObject(data)) {\n                return action(data);\n            }\n\n            if (_.isArray(data)) {\n                newData = _.map(data, function (item) {\n                    return this.mapRecursive(item, action, maxDepth);\n                }, this);\n\n                return action(newData);\n            }\n\n            newData = _.mapObject(data, function (val, key) {\n                if (data.hasOwnProperty(key)) {\n                    return this.mapRecursive(val, action, maxDepth);\n                }\n\n                return val;\n            }, this);\n\n            return action(newData);\n        },\n\n        /**\n         * Removes empty(in common sence) obj props/array elems\n         *\n         * @param {*} data - Data to be cleaned.\n         * @returns {*}\n         */\n        removeEmptyValues: function (data) {\n            if (!_.isObject(data)) {\n                return data;\n            }\n\n            if (_.isArray(data)) {\n                return data.filter(function (item) {\n                    return !this.isEmptyObj(item);\n                }, this);\n            }\n\n            return _.omit(data, this.isEmptyObj.bind(this));\n        },\n\n        /**\n         * Checks that argument of any type is empty in common sence:\n         * empty string, string with spaces only, object without own props, empty array, null or undefined\n         *\n         * @param {*} val - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEmptyObj: function (val) {\n\n            return _.isObject(val) && _.isEmpty(val) ||\n            this.isEmpty(val) ||\n            val && val.trim && this.isEmpty(val.trim());\n        }\n    };\n});\n","mage/utils/strings.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var jsonRe = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/;\n\n    return {\n\n        /**\n         * Attempts to convert string to one of the primitive values,\n         * or to parse it as a valid json object.\n         *\n         * @param {String} str - String to be processed.\n         * @returns {*}\n         */\n        castString: function (str) {\n            try {\n                str = str === 'true' ? true :\n                    str === 'false' ? false :\n                        str === 'null' ? null :\n                            +str + '' === str ? +str :\n                                jsonRe.test(str) ? JSON.parse(str) :\n                                    str;\n            } catch (e) {\n            }\n\n            return str;\n        },\n\n        /**\n         * Splits string by separator if it's possible,\n         * otherwise returns the incoming value.\n         *\n         * @param {(String|Array|*)} str - String to split.\n         * @param {String} [separator=' '] - Seperator based on which to split the string.\n         * @returns {Array|*} Splitted string or the incoming value.\n         */\n        stringToArray: function (str, separator) {\n            separator = separator || ' ';\n\n            return typeof str === 'string' ?\n                str.split(separator) :\n                str;\n        },\n\n        /**\n         * Converts the incoming string which consists\n         * of a specified delimiters into a format commonly used in form elements.\n         *\n         * @param {String} name - The incoming string.\n         * @param {String} [separator='.']\n         * @returns {String} Serialized string.\n         *\n         * @example\n         *      utils.serializeName('one.two.three');\n         *      => 'one[two][three]';\n         */\n        serializeName: function (name, separator) {\n            var result;\n\n            separator = separator || '.';\n            name = name.split(separator);\n\n            result = name.shift();\n\n            name.forEach(function (part) {\n                result += '[' + part + ']';\n            });\n\n            return result;\n        },\n\n        /**\n         * Checks wether the incoming value is not empty,\n         * e.g. not 'null' or 'undefined'\n         *\n         * @param {*} value - Value to check.\n         * @returns {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || _.isUndefined(value) || _.isNull(value);\n        },\n\n        /**\n         * Adds 'prefix' to the 'part' value if it was provided.\n         *\n         * @param {String} prefix\n         * @param {String} part\n         * @returns {String}\n         */\n        fullPath: function (prefix, part) {\n            return prefix ? prefix + '.' + part : part;\n        },\n\n        /**\n         * Splits incoming string and returns its' part specified by offset.\n         *\n         * @param {String} parts\n         * @param {Number} [offset]\n         * @param {String} [delimiter=.]\n         * @returns {String}\n         */\n        getPart: function (parts, offset, delimiter) {\n            delimiter = delimiter || '.';\n            parts = parts.split(delimiter);\n            offset = this.formatOffset(parts, offset);\n\n            parts.splice(offset, 1);\n\n            return parts.join(delimiter) || '';\n        },\n\n        /**\n         * Converts nameThroughCamelCase to name-through-minus\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        camelCaseToMinus: function camelCaseToMinus(string) {\n            return ('' + string)\n                .split('')\n                .map(function (symbol, index) {\n                    return index ?\n                        symbol.toUpperCase() === symbol ?\n                        '-' + symbol.toLowerCase() :\n                            symbol :\n                        symbol.toLowerCase();\n                })\n                .join('');\n        },\n\n        /**\n         * Converts name-through-minus to nameThroughCamelCase\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        minusToCamelCase: function minusToCamelCase(string) {\n            return ('' + string)\n                .split('-')\n                .map(function (part, index) {\n                    return index ? part.charAt(0).toUpperCase() + part.slice(1) : part;\n                })\n                .join('');\n        }\n    };\n});\n","mage/utils/template.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/utils/objects',\n    'mage/utils/strings'\n], function (jQuery, _, utils, stringUtils) {\n    'use strict';\n\n    var tmplSettings = _.templateSettings,\n        interpolate = /\\$\\{([\\s\\S]+?)\\}/g,\n        opener = '${',\n        template,\n        hasStringTmpls;\n\n    /**\n     * Identifies whether ES6 templates are supported.\n     */\n    hasStringTmpls = (function () {\n        var testString = 'var foo = \"bar\"; return `${ foo }` === foo';\n\n        try {\n            return Function(testString)();\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    if (hasStringTmpls) {\n\n        /*eslint-disable no-unused-vars, no-eval*/\n        /**\n         * Evaluates template string using ES6 templates.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} $ - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, $) {\n            return eval('`' + tmpl + '`');\n        };\n\n        /*eslint-enable no-unused-vars, no-eval*/\n    } else {\n\n        /**\n         * Fallback function used when ES6 templates are not supported.\n         * Uses underscore templates renderer.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} data - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, data) {\n            var cached = tmplSettings.interpolate;\n\n            tmplSettings.interpolate = interpolate;\n\n            tmpl = _.template(tmpl, {\n                variable: '$'\n            })(data);\n\n            tmplSettings.interpolate = cached;\n\n            return tmpl;\n        };\n    }\n\n    /**\n     * Checks if provided value contains template syntax.\n     *\n     * @param {*} value - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isTemplate(value) {\n        return typeof value === 'string' && ~value.indexOf(opener);\n    }\n\n    /**\n     * Iteratively processes provided string\n     * until no templates syntax will be found.\n     *\n     * @param {String} tmpl - Template string.\n     * @param {Object} data - Data object used in a template.\n     * @param {Boolean} [castString=false] - Flag that indicates whether template\n     *      should be casted after evaluation to a value of another type or\n     *      that it should be leaved as a string.\n     * @returns {*} Compiled template.\n     */\n    function render(tmpl, data, castString) {\n        var last = tmpl;\n\n        while (~tmpl.indexOf(opener)) {\n            tmpl = template(tmpl, data);\n\n            if (tmpl === last) {\n                break;\n            }\n\n            last = tmpl;\n        }\n\n        return castString ?\n            stringUtils.castString(tmpl) :\n            tmpl;\n    }\n\n    return {\n\n        /**\n         * Applies provided data to the template.\n         *\n         * @param {Object|String} tmpl\n         * @param {Object} [data] - Data object to match with template.\n         * @param {Boolean} [castString=false] - Flag that indicates whether template\n         *      should be casted after evaluation to a value of another type or\n         *      that it should be leaved as a string.\n         * @returns {*}\n         *\n         * @example Template defined as a string.\n         *      var source = { foo: 'Random Stuff', bar: 'Some' };\n         *\n         *      utils.template('${ $.bar } ${ $.foo }', source);\n         *      => 'Some Random Stuff';\n         *\n         * @example Template defined as an object.\n         *      var tmpl = {\n         *              key: {'${ $.$data.bar }': '${ $.$data.foo }'},\n         *              foo: 'bar',\n         *              x1: 2, x2: 5,\n         *              delta: '${ $.x2 - $.x1 }',\n         *              baz: 'Upper ${ $.foo.toUpperCase() }'\n         *      };\n         *\n         *      utils.template(tmpl, source);\n         *      => {\n         *          key: {'Some': 'Random Stuff'},\n         *          foo: 'bar',\n         *          x1: 2, x2: 5,\n         *          delta: 3,\n         *          baz: 'Upper BAR'\n         *      };\n         */\n        template: function (tmpl, data, castString, dontClone) {\n            if (typeof tmpl === 'string') {\n                return render(tmpl, data, castString);\n            }\n\n            if (!dontClone) {\n                tmpl = utils.copy(tmpl);\n            }\n\n            tmpl.$data = data || {};\n\n            /**\n             * Template iterator function.\n             */\n            _.each(tmpl, function iterate(value, key, list) {\n                if (key === '$data') {\n                    return;\n                }\n\n                if (isTemplate(key)) {\n                    delete list[key];\n\n                    key = render(key, tmpl);\n                    list[key] = value;\n                }\n\n                if (isTemplate(value)) {\n                    list[key] = render(value, tmpl, castString);\n                } else if (jQuery.isPlainObject(value) || Array.isArray(value)) {\n                    _.each(value, iterate);\n                }\n            });\n\n            delete tmpl.$data;\n\n            return tmpl;\n        }\n    };\n});\n","mage/utils/wrapper.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Utility methods used to wrap and extend functions.\n *\n * @example Usage of a 'wrap' method with arguments delegation.\n *      var multiply = function (a, b) {\n *          return a * b;\n *      };\n *\n *      multiply = module.wrap(multiply, function (orig) {\n *          return 'Result is: ' + orig();\n *      });\n *\n *      multiply(2, 2);\n *      => 'Result is: 4'\n *\n * @example Usage of 'wrapSuper' method.\n *      var multiply = function (a, b) {\n *         return a * b;\n *      };\n *\n *      var obj = {\n *          multiply: module.wrapSuper(multiply, function () {\n *              return 'Result is: ' + this._super();\n *          });\n *      };\n *\n *      obj.multiply(2, 2);\n *      => 'Result is: 4'\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Checks if string has a '_super' substring.\n     */\n    var superReg = /\\b_super\\b/;\n\n    return {\n\n        /**\n         * Wraps target function with a specified wrapper, which will recieve\n         * reference to the original function as a first argument.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapper function.\n         */\n        wrap: function (target, wrapper) {\n            if (!_.isFunction(target) || !_.isFunction(wrapper)) {\n                return wrapper;\n            }\n\n            return function () {\n                var args    = _.toArray(arguments),\n                    ctx     = this,\n                    _super;\n\n                /**\n                 * Function that will be passed to the wrapper.\n                 * If no arguments will be passed to it, then the original\n                 * function will be called with an arguments of a wrapper function.\n                 */\n                _super = function () {\n                    var superArgs = arguments.length ? arguments : args.slice(1);\n\n                    return target.apply(ctx, superArgs);\n                };\n\n                args.unshift(_super);\n\n                return wrapper.apply(ctx, args);\n            };\n        },\n\n        /**\n         * Wraps the incoming function to implement support of the '_super' method.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapped function.\n         */\n        wrapSuper: function (target, wrapper) {\n            if (!this.hasSuper(wrapper) || !_.isFunction(target)) {\n                return wrapper;\n            }\n\n            return function () {\n                var _super  = this._super,\n                    args    = arguments,\n                    result;\n\n                /**\n                 * Temporary define '_super' method which\n                 * contains call to the original function.\n                 */\n                this._super = function () {\n                    var superArgs = arguments.length ? arguments : args;\n\n                    return target.apply(this, superArgs);\n                };\n\n                result = wrapper.apply(this, args);\n\n                this._super = _super;\n\n                return result;\n            };\n        },\n\n        /**\n         * Checks wether the incoming method contains calls of the '_super' method.\n         *\n         * @param {Function} fn - Function to be checked.\n         * @returns {Boolean}\n         */\n        hasSuper: function (fn) {\n            return _.isFunction(fn) && superReg.test(fn);\n        },\n\n        /**\n         * Extends target object with provided extenders.\n         * If property in target and extender objects is a function,\n         * then it will be wrapped using 'wrap' method.\n         *\n         * @param {Object} target - Object to be extended.\n         * @param {...Object} extenders - Multiple extenders objects.\n         * @returns {Object} Modified target object.\n         */\n        extend: function (target) {\n            var extenders = _.toArray(arguments).slice(1),\n                iterator = this._extend.bind(this, target);\n\n            extenders.forEach(iterator);\n\n            return target;\n        },\n\n        /**\n         * Same as the 'extend' method, but operates only on one extender object.\n         *\n         * @private\n         * @param {Object} target\n         * @param {Object} extender\n         */\n        _extend: function (target, extender) {\n            _.each(extender, function (value, key) {\n                target[key] = this.wrap(target[key], extender[key]);\n            }, this);\n        }\n    };\n});\n","mage/validation/url.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n\n        /**\n         * Redirects to the url if it is considered safe\n         *\n         * @param {String} path - url to be redirected to\n         */\n        redirect: function (path) {\n            path = this.sanitize(path);\n\n            if (this.validate(path)) {\n                window.location.href = path;\n            }\n        },\n\n        /**\n         * Validates url\n         *\n         * @param {Object} path - url to be validated\n         * @returns {Boolean}\n         */\n        validate: function (path) {\n            var hostname = window.location.hostname;\n\n            if (path.indexOf(hostname) === -1 ||\n                path.indexOf('javascript:') !== -1 ||\n                path.indexOf('vbscript:') !== -1) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Sanitize url, replacing disallowed chars\n         *\n         * @param {Sring} path - url to be normalized\n         * @returns {String}\n         */\n        sanitize: function (path) {\n            return path.replace('[^-A-Za-z0-9+&@#/%?=~_|!:,.;\\(\\)]', '');\n        }\n    };\n});\n","mage/view/composite.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine(['jquery'], function($) {\n    return function (wrapperTag) {\n        wrapperTag = wrapperTag || 'div';\n        var renderedChildren = {};\n        var children = {};\n        return {\n            addChild: function (child, key) {\n                children[key] = child;\n            },\n\n            render: function (root) {\n                $.each(children, function (key, child) {\n                    var childRoot = $('<div>');\n                    renderedChildren[key] = child.render(childRoot);\n                    root.append(childRoot);\n                });\n            }\n        }\n    }\n});\n","modernizr/modernizr.2.0.6.js":"/* Modernizr 2.0.6 (Custom Build) | MIT & BSD\n * Build: http://www.modernizr.com/download/#-csstransforms-csstransforms3d-cssclasses-prefixed-teststyles-testprop-testallprops-prefixes-domprefixes\n */\n;window.Modernizr=function(a,b,c){function C(a,b){var c=a.charAt(0).toUpperCase()+a.substr(1),d=(a+\" \"+o.join(c+\" \")+c).split(\" \");return B(d,b)}function B(a,b){for(var d in a)if(k[a[d]]!==c)return b==\"pfx\"?a[d]:!0;return!1}function A(a,b){return!!~(\"\"+a).indexOf(b)}function z(a,b){return typeof a===b}function y(a,b){return x(n.join(a+\";\")+(b||\"\"))}function x(a){k.cssText=a}var d=\"2.0.6\",e={},f=!0,g=b.documentElement,h=b.head||b.getElementsByTagName(\"head\")[0],i=\"modernizr\",j=b.createElement(i),k=j.style,l,m=Object.prototype.toString,n=\" -webkit- -moz- -o- -ms- -khtml- \".split(\" \"),o=\"Webkit Moz O ms Khtml\".split(\" \"),p={},q={},r={},s=[],t=function(a,c,d,e){var f,h,j,k=b.createElement(\"div\");if(parseInt(d,10))while(d--)j=b.createElement(\"div\"),j.id=e?e[d]:i+(d+1),k.appendChild(j);f=[\"&shy;\",\"<style>\",a,\"</style>\"].join(\"\"),k.id=i,k.innerHTML+=f,g.appendChild(k),h=c(k,a),k.parentNode.removeChild(k);return!!h},u,v={}.hasOwnProperty,w;!z(v,c)&&!z(v.call,c)?w=function(a,b){return v.call(a,b)}:w=function(a,b){return b in a&&z(a.constructor.prototype[b],c)};var D=function(a,c){var d=a.join(\"\"),f=c.length;t(d,function(a,c){var d=b.styleSheets[b.styleSheets.length-1],g=d.cssRules&&d.cssRules[0]?d.cssRules[0].cssText:d.cssText||\"\",h=a.childNodes,i={};while(f--)i[h[f].id]=h[f];e.csstransforms3d=i.csstransforms3d.offsetLeft===9},f,c)}([,[\"@media (\",n.join(\"transform-3d),(\"),i,\")\",\"{#csstransforms3d{left:9px;position:absolute}}\"].join(\"\")],[,\"csstransforms3d\"]);p.csstransforms=function(){return!!B([\"transformProperty\",\"WebkitTransform\",\"MozTransform\",\"OTransform\",\"msTransform\"])},p.csstransforms3d=function(){var a=!!B([\"perspectiveProperty\",\"WebkitPerspective\",\"MozPerspective\",\"OPerspective\",\"msPerspective\"]);a&&\"webkitPerspective\"in g.style&&(a=e.csstransforms3d);return a};for(var E in p)w(p,E)&&(u=E.toLowerCase(),e[u]=p[E](),s.push((e[u]?\"\":\"no-\")+u));x(\"\"),j=l=null,e._version=d,e._prefixes=n,e._domPrefixes=o,e.testProp=function(a){return B([a])},e.testAllProps=C,e.testStyles=t,e.prefixed=function(a){return C(a,\"pfx\")},g.className=g.className.replace(/\\bno-js\\b/,\"\")+(f?\" js \"+s.join(\" \"):\"\");return e}(this,this.document);","modernizr/modernizr.details.js":"// By @mathias, based on http://mths.be/axh\ndefine([\n    'modernizr/modernizr'\n], function(){\n\n    Modernizr.addTest('details', function() {\n        var doc = document,\n            el = doc.createElement('details'),\n            fake,\n            root,\n            diff;\n        if (!('open' in el)) { // return early if possible; thanks @aFarkas!\n            return false;\n        }\n        root = doc.body || (function() {\n            var de = doc.documentElement;\n            fake = true;\n            return de.insertBefore(doc.createElement('body'), de.firstElementChild || de.firstChild);\n        }());\n        el.innerHTML = '<summary>a</summary>b';\n        el.style.display = 'block';\n        root.appendChild(el);\n        diff = el.offsetHeight;\n        el.open = true;\n        diff = diff != el.offsetHeight;\n        root.removeChild(el);\n        fake && root.parentNode.removeChild(root);\n        return diff;\n    });\n\n});","modernizr/modernizr.js":"/*!\n * Modernizr v2.6.1\n * www.modernizr.com\n *\n * Copyright (c) Faruk Ates, Paul Irish, Alex Sexton\n * Available under the BSD and MIT licenses: www.modernizr.com/license/\n */\n\n/*\n * Modernizr tests which native CSS3 and HTML5 features are available in\n * the current UA and makes the results available to you in two ways:\n * as properties on a global Modernizr object, and as classes on the\n * <html> element. This information allows you to progressively enhance\n * your pages with a granular level of control over the experience.\n *\n * Modernizr has an optional (not included) conditional resource loader\n * called Modernizr.load(), based on Yepnope.js (yepnopejs.com).\n * To get a build that includes Modernizr.load(), as well as choosing\n * which tests to include, go to www.modernizr.com/download/\n *\n * Authors        Faruk Ates, Paul Irish, Alex Sexton\n * Contributors   Ryan Seddon, Ben Alman\n */\n\nwindow.Modernizr = (function( window, document, undefined ) {\n\n    var version = '2.6.1',\n\n        Modernizr = {},\n\n    /*>>cssclasses*/\n    // option for enabling the HTML classes to be added\n        enableClasses = true,\n    /*>>cssclasses*/\n\n        docElement = document.documentElement,\n\n        /**\n         * Create our \"modernizr\" element that we do most feature tests on.\n         */\n            mod = 'modernizr',\n        modElem = document.createElement(mod),\n        mStyle = modElem.style,\n\n        /**\n         * Create the input element for various Web Forms feature tests.\n         */\n            inputElem /*>>inputelem*/ = document.createElement('input') /*>>inputelem*/ ,\n\n    /*>>smile*/\n        smile = ':)',\n    /*>>smile*/\n\n        toString = {}.toString,\n\n    // TODO :: make the prefixes more granular\n    /*>>prefixes*/\n    // List of property values to set for css tests. See ticket #21\n        prefixes = ' -webkit- -moz- -o- -ms- '.split(' '),\n    /*>>prefixes*/\n\n    /*>>domprefixes*/\n    // Following spec is to expose vendor-specific style properties as:\n    //   elem.style.WebkitBorderRadius\n    // and the following would be incorrect:\n    //   elem.style.webkitBorderRadius\n\n    // Webkit ghosts their properties in lowercase but Opera & Moz do not.\n    // Microsoft uses a lowercase `ms` instead of the correct `Ms` in IE8+\n    //   erik.eae.net/archives/2008/03/10/21.48.10/\n\n    // More here: github.com/Modernizr/Modernizr/issues/issue/21\n        omPrefixes = 'Webkit Moz O ms',\n\n        cssomPrefixes = omPrefixes.split(' '),\n\n        domPrefixes = omPrefixes.toLowerCase().split(' '),\n    /*>>domprefixes*/\n\n    /*>>ns*/\n        ns = {'svg': 'http://www.w3.org/2000/svg'},\n    /*>>ns*/\n\n        tests = {},\n        inputs = {},\n        attrs = {},\n\n        classes = [],\n\n        slice = classes.slice,\n\n        featureName, // used in testing loop\n\n\n    /*>>teststyles*/\n    // Inject element with style element and some CSS rules\n        injectElementWithStyles = function( rule, callback, nodes, testnames ) {\n\n            var style, ret, node,\n                div = document.createElement('div'),\n            // After page load injecting a fake body doesn't work so check if body exists\n                body = document.body,\n            // IE6 and 7 won't return offsetWidth or offsetHeight unless it's in the body element, so we fake it.\n                fakeBody = body ? body : document.createElement('body');\n\n            if ( parseInt(nodes, 10) ) {\n                // In order not to give false positives we create a node for each test\n                // This also allows the method to scale for unspecified uses\n                while ( nodes-- ) {\n                    node = document.createElement('div');\n                    node.id = testnames ? testnames[nodes] : mod + (nodes + 1);\n                    div.appendChild(node);\n                }\n            }\n\n            // <style> elements in IE6-9 are considered 'NoScope' elements and therefore will be removed\n            // when injected with innerHTML. To get around this you need to prepend the 'NoScope' element\n            // with a 'scoped' element, in our case the soft-hyphen entity as it won't mess with our measurements.\n            // msdn.microsoft.com/en-us/library/ms533897%28VS.85%29.aspx\n            // Documents served as xml will throw if using &shy; so use xml friendly encoded version. See issue #277\n            style = ['&#173;','<style id=\"s', mod, '\">', rule, '</style>'].join('');\n            div.id = mod;\n            // IE6 will false positive on some tests due to the style element inside the test div somehow interfering offsetHeight, so insert it into body or fakebody.\n            // Opera will act all quirky when injecting elements in documentElement when page is served as xml, needs fakebody too. #270\n            (body ? div : fakeBody).innerHTML += style;\n            fakeBody.appendChild(div);\n            if ( !body ) {\n                //avoid crashing IE8, if background image is used\n                fakeBody.style.background = \"\";\n                docElement.appendChild(fakeBody);\n            }\n\n            ret = callback(div, rule);\n            // If this is done after page load we don't want to remove the body so check if body exists\n            !body ? fakeBody.parentNode.removeChild(fakeBody) : div.parentNode.removeChild(div);\n\n            return !!ret;\n\n        },\n    /*>>teststyles*/\n\n    /*>>mq*/\n    // adapted from matchMedia polyfill\n    // by Scott Jehl and Paul Irish\n    // gist.github.com/786768\n        testMediaQuery = function( mq ) {\n\n            var matchMedia = window.matchMedia || window.msMatchMedia;\n            if ( matchMedia ) {\n                return matchMedia(mq).matches;\n            }\n\n            var bool;\n\n            injectElementWithStyles('@media ' + mq + ' { #' + mod + ' { position: absolute; } }', function( node ) {\n                bool = (window.getComputedStyle ?\n                    getComputedStyle(node, null) :\n                    node.currentStyle)['position'] == 'absolute';\n            });\n\n            return bool;\n\n        },\n    /*>>mq*/\n\n\n    /*>>hasevent*/\n    //\n    // isEventSupported determines if a given element supports the given event\n    // kangax.github.com/iseventsupported/\n    //\n    // The following results are known incorrects:\n    //   Modernizr.hasEvent(\"webkitTransitionEnd\", elem) // false negative\n    //   Modernizr.hasEvent(\"textInput\") // in Webkit. github.com/Modernizr/Modernizr/issues/333\n    //   ...\n        isEventSupported = (function() {\n\n            var TAGNAMES = {\n                'select': 'input', 'change': 'input',\n                'submit': 'form', 'reset': 'form',\n                'error': 'img', 'load': 'img', 'abort': 'img'\n            };\n\n            function isEventSupported( eventName, element ) {\n\n                element = element || document.createElement(TAGNAMES[eventName] || 'div');\n                eventName = 'on' + eventName;\n\n                // When using `setAttribute`, IE skips \"unload\", WebKit skips \"unload\" and \"resize\", whereas `in` \"catches\" those\n                var isSupported = eventName in element;\n\n                if ( !isSupported ) {\n                    // If it has no `setAttribute` (i.e. doesn't implement Node interface), try generic element\n                    if ( !element.setAttribute ) {\n                        element = document.createElement('div');\n                    }\n                    if ( element.setAttribute && element.removeAttribute ) {\n                        element.setAttribute(eventName, '');\n                        isSupported = is(element[eventName], 'function');\n\n                        // If property was created, \"remove it\" (by setting value to `undefined`)\n                        if ( !is(element[eventName], 'undefined') ) {\n                            element[eventName] = undefined;\n                        }\n                        element.removeAttribute(eventName);\n                    }\n                }\n\n                element = null;\n                return isSupported;\n            }\n            return isEventSupported;\n        })(),\n    /*>>hasevent*/\n\n    // TODO :: Add flag for hasownprop ? didn't last time\n\n    // hasOwnProperty shim by kangax needed for Safari 2.0 support\n        _hasOwnProperty = ({}).hasOwnProperty, hasOwnProp;\n\n    if ( !is(_hasOwnProperty, 'undefined') && !is(_hasOwnProperty.call, 'undefined') ) {\n        hasOwnProp = function (object, property) {\n            return _hasOwnProperty.call(object, property);\n        };\n    }\n    else {\n        hasOwnProp = function (object, property) { /* yes, this can give false positives/negatives, but most of the time we don't care about those */\n            return ((property in object) && is(object.constructor.prototype[property], 'undefined'));\n        };\n    }\n\n    // Adapted from ES5-shim https://github.com/kriskowal/es5-shim/blob/master/es5-shim.js\n    // es5.github.com/#x15.3.4.5\n\n    if (!Function.prototype.bind) {\n        Function.prototype.bind = function bind(that) {\n\n            var target = this;\n\n            if (typeof target != \"function\") {\n                throw new TypeError();\n            }\n\n            var args = slice.call(arguments, 1),\n                bound = function () {\n\n                    if (this instanceof bound) {\n\n                        var F = function(){};\n                        F.prototype = target.prototype;\n                        var self = new F();\n\n                        var result = target.apply(\n                            self,\n                            args.concat(slice.call(arguments))\n                        );\n                        if (Object(result) === result) {\n                            return result;\n                        }\n                        return self;\n\n                    } else {\n\n                        return target.apply(\n                            that,\n                            args.concat(slice.call(arguments))\n                        );\n\n                    }\n\n                };\n\n            return bound;\n        };\n    }\n\n    /**\n     * setCss applies given styles to the Modernizr DOM node.\n     */\n    function setCss( str ) {\n        mStyle.cssText = str;\n    }\n\n    /**\n     * setCssAll extrapolates all vendor-specific css strings.\n     */\n    function setCssAll( str1, str2 ) {\n        return setCss(prefixes.join(str1 + ';') + ( str2 || '' ));\n    }\n\n    /**\n     * is returns a boolean for if typeof obj is exactly type.\n     */\n    function is( obj, type ) {\n        return typeof obj === type;\n    }\n\n    /**\n     * contains returns a boolean for if substr is found within str.\n     */\n    function contains( str, substr ) {\n        return !!~('' + str).indexOf(substr);\n    }\n\n    /*>>testprop*/\n\n    // testProps is a generic CSS / DOM property test.\n\n    // In testing support for a given CSS property, it's legit to test:\n    //    `elem.style[styleName] !== undefined`\n    // If the property is supported it will return an empty string,\n    // if unsupported it will return undefined.\n\n    // We'll take advantage of this quick test and skip setting a style\n    // on our modernizr element, but instead just testing undefined vs\n    // empty string.\n\n    // Because the testing of the CSS property names (with \"-\", as\n    // opposed to the camelCase DOM properties) is non-portable and\n    // non-standard but works in WebKit and IE (but not Gecko or Opera),\n    // we explicitly reject properties with dashes so that authors\n    // developing in WebKit or IE first don't end up with\n    // browser-specific content by accident.\n\n    function testProps( props, prefixed ) {\n        for ( var i in props ) {\n            var prop = props[i];\n            if ( !contains(prop, \"-\") && mStyle[prop] !== undefined ) {\n                return prefixed == 'pfx' ? prop : true;\n            }\n        }\n        return false;\n    }\n    /*>>testprop*/\n\n    // TODO :: add testDOMProps\n    /**\n     * testDOMProps is a generic DOM property test; if a browser supports\n     *   a certain property, it won't return undefined for it.\n     */\n    function testDOMProps( props, obj, elem ) {\n        for ( var i in props ) {\n            var item = obj[props[i]];\n            if ( item !== undefined) {\n\n                // return the property name as a string\n                if (elem === false) return props[i];\n\n                // let's bind a function\n                if (is(item, 'function')){\n                    // default to autobind unless override\n                    return item.bind(elem || obj);\n                }\n\n                // return the unbound function or obj or value\n                return item;\n            }\n        }\n        return false;\n    }\n\n    /*>>testallprops*/\n    /**\n     * testPropsAll tests a list of DOM properties we want to check against.\n     *   We specify literally ALL possible (known and/or likely) properties on\n     *   the element including the non-vendor prefixed one, for forward-\n     *   compatibility.\n     */\n    function testPropsAll( prop, prefixed, elem ) {\n\n        var ucProp  = prop.charAt(0).toUpperCase() + prop.slice(1),\n            props   = (prop + ' ' + cssomPrefixes.join(ucProp + ' ') + ucProp).split(' ');\n\n        // did they call .prefixed('boxSizing') or are we just testing a prop?\n        if(is(prefixed, \"string\") || is(prefixed, \"undefined\")) {\n            return testProps(props, prefixed);\n\n            // otherwise, they called .prefixed('requestAnimationFrame', window[, elem])\n        } else {\n            props = (prop + ' ' + (domPrefixes).join(ucProp + ' ') + ucProp).split(' ');\n            return testDOMProps(props, prefixed, elem);\n        }\n    }\n    /*>>testallprops*/\n\n\n    /**\n     * Tests\n     * -----\n     */\n\n        // The *new* flexbox\n        // dev.w3.org/csswg/css3-flexbox\n\n    tests['flexbox'] = function() {\n        return testPropsAll('flexWrap');\n    };\n\n    // The *old* flexbox\n    // www.w3.org/TR/2009/WD-css3-flexbox-20090723/\n\n    tests['flexboxlegacy'] = function() {\n        return testPropsAll('boxDirection');\n    };\n\n    // On the S60 and BB Storm, getContext exists, but always returns undefined\n    // so we actually have to call getContext() to verify\n    // github.com/Modernizr/Modernizr/issues/issue/97/\n\n    tests['canvas'] = function() {\n        var elem = document.createElement('canvas');\n        return !!(elem.getContext && elem.getContext('2d'));\n    };\n\n    tests['canvastext'] = function() {\n        return !!(Modernizr['canvas'] && is(document.createElement('canvas').getContext('2d').fillText, 'function'));\n    };\n\n    // webk.it/70117 is tracking a legit WebGL feature detect proposal\n\n    // We do a soft detect which may false positive in order to avoid\n    // an expensive context creation: bugzil.la/732441\n\n    tests['webgl'] = function() {\n        return !!window.WebGLRenderingContext;\n    };\n\n    /*\n     * The Modernizr.touch test only indicates if the browser supports\n     *    touch events, which does not necessarily reflect a touchscreen\n     *    device, as evidenced by tablets running Windows 7 or, alas,\n     *    the Palm Pre / WebOS (touch) phones.\n     *\n     * Additionally, Chrome (desktop) used to lie about its support on this,\n     *    but that has since been rectified: crbug.com/36415\n     *\n     * We also test for Firefox 4 Multitouch Support.\n     *\n     * For more info, see: modernizr.github.com/Modernizr/touch.html\n     */\n\n    tests['touch'] = function() {\n        var bool;\n\n        if(('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch) {\n            bool = true;\n        } else {\n            injectElementWithStyles(['@media (',prefixes.join('touch-enabled),('),mod,')','{#modernizr{top:9px;position:absolute}}'].join(''), function( node ) {\n                bool = node.offsetTop === 9;\n            });\n        }\n\n        return bool;\n    };\n\n\n    // geolocation is often considered a trivial feature detect...\n    // Turns out, it's quite tricky to get right:\n    //\n    // Using !!navigator.geolocation does two things we don't want. It:\n    //   1. Leaks memory in IE9: github.com/Modernizr/Modernizr/issues/513\n    //   2. Disables page caching in WebKit: webk.it/43956\n    //\n    // Meanwhile, in Firefox < 8, an about:config setting could expose\n    // a false positive that would throw an exception: bugzil.la/688158\n\n    tests['geolocation'] = function() {\n        return 'geolocation' in navigator;\n    };\n\n\n    tests['postmessage'] = function() {\n        return !!window.postMessage;\n    };\n\n\n    // Chrome incognito mode used to throw an exception when using openDatabase\n    // It doesn't anymore.\n    tests['websqldatabase'] = function() {\n        return !!window.openDatabase;\n    };\n\n    // Vendors had inconsistent prefixing with the experimental Indexed DB:\n    // - Webkit's implementation is accessible through webkitIndexedDB\n    // - Firefox shipped moz_indexedDB before FF4b9, but since then has been mozIndexedDB\n    // For speed, we don't test the legacy (and beta-only) indexedDB\n    tests['indexedDB'] = function() {\n        return !!testPropsAll(\"indexedDB\", window);\n    };\n\n    // documentMode logic from YUI to filter out IE8 Compat Mode\n    //   which false positives.\n    tests['hashchange'] = function() {\n        return isEventSupported('hashchange', window) && (document.documentMode === undefined || document.documentMode > 7);\n    };\n\n    // Per 1.6:\n    // This used to be Modernizr.historymanagement but the longer\n    // name has been deprecated in favor of a shorter and property-matching one.\n    // The old API is still available in 1.6, but as of 2.0 will throw a warning,\n    // and in the first release thereafter disappear entirely.\n    tests['history'] = function() {\n        return !!(window.history && history.pushState);\n    };\n\n    tests['draganddrop'] = function() {\n        var div = document.createElement('div');\n        return ('draggable' in div) || ('ondragstart' in div && 'ondrop' in div);\n    };\n\n    // FF3.6 was EOL'ed on 4/24/12, but the ESR version of FF10\n    // will be supported until FF19 (2/12/13), at which time, ESR becomes FF17.\n    // FF10 still uses prefixes, so check for it until then.\n    // for more ESR info, see: mozilla.org/en-US/firefox/organizations/faq/\n    tests['websockets'] = function() {\n        return 'WebSocket' in window || 'MozWebSocket' in window;\n    };\n\n\n    // css-tricks.com/rgba-browser-support/\n    tests['rgba'] = function() {\n        // Set an rgba() color and check the returned value\n\n        setCss('background-color:rgba(150,255,150,.5)');\n\n        return contains(mStyle.backgroundColor, 'rgba');\n    };\n\n    tests['hsla'] = function() {\n        // Same as rgba(), in fact, browsers re-map hsla() to rgba() internally,\n        //   except IE9 who retains it as hsla\n\n        setCss('background-color:hsla(120,40%,100%,.5)');\n\n        return contains(mStyle.backgroundColor, 'rgba') || contains(mStyle.backgroundColor, 'hsla');\n    };\n\n    tests['multiplebgs'] = function() {\n        // Setting multiple images AND a color on the background shorthand property\n        //  and then querying the style.background property value for the number of\n        //  occurrences of \"url(\" is a reliable method for detecting ACTUAL support for this!\n\n        setCss('background:url(https://),url(https://),red url(https://)');\n\n        // If the UA supports multiple backgrounds, there should be three occurrences\n        //   of the string \"url(\" in the return value for elemStyle.background\n\n        return (/(url\\s*\\(.*?){3}/).test(mStyle.background);\n    };\n\n\n\n    // this will false positive in Opera Mini\n    //   github.com/Modernizr/Modernizr/issues/396\n\n    tests['backgroundsize'] = function() {\n        return testPropsAll('backgroundSize');\n    };\n\n    tests['borderimage'] = function() {\n        return testPropsAll('borderImage');\n    };\n\n\n    // Super comprehensive table about all the unique implementations of\n    // border-radius: muddledramblings.com/table-of-css3-border-radius-compliance\n\n    tests['borderradius'] = function() {\n        return testPropsAll('borderRadius');\n    };\n\n    // WebOS unfortunately false positives on this test.\n    tests['boxshadow'] = function() {\n        return testPropsAll('boxShadow');\n    };\n\n    // FF3.0 will false positive on this test\n    tests['textshadow'] = function() {\n        return document.createElement('div').style.textShadow === '';\n    };\n\n\n    tests['opacity'] = function() {\n        // Browsers that actually have CSS Opacity implemented have done so\n        //  according to spec, which means their return values are within the\n        //  range of [0.0,1.0] - including the leading zero.\n\n        setCssAll('opacity:.55');\n\n        // The non-literal . in this regex is intentional:\n        //   German Chrome returns this value as 0,55\n        // github.com/Modernizr/Modernizr/issues/#issue/59/comment/516632\n        return (/^0.55$/).test(mStyle.opacity);\n    };\n\n\n    // Note, Android < 4 will pass this test, but can only animate\n    //   a single property at a time\n    //   daneden.me/2011/12/putting-up-with-androids-bullshit/\n    tests['cssanimations'] = function() {\n        return testPropsAll('animationName');\n    };\n\n\n    tests['csscolumns'] = function() {\n        return testPropsAll('columnCount');\n    };\n\n\n    tests['cssgradients'] = function() {\n        /**\n         * For CSS Gradients syntax, please see:\n         * webkit.org/blog/175/introducing-css-gradients/\n         * developer.mozilla.org/en/CSS/-moz-linear-gradient\n         * developer.mozilla.org/en/CSS/-moz-radial-gradient\n         * dev.w3.org/csswg/css3-images/#gradients-\n         */\n\n        var str1 = 'background-image:',\n            str2 = 'gradient(linear,left top,right bottom,from(#9f9),to(white));',\n            str3 = 'linear-gradient(left top,#9f9, white);';\n\n        setCss(\n            // legacy webkit syntax (FIXME: remove when syntax not in use anymore)\n            (str1 + '-webkit- '.split(' ').join(str2 + str1) +\n                // standard syntax             // trailing 'background-image:'\n                prefixes.join(str3 + str1)).slice(0, -str1.length)\n        );\n\n        return contains(mStyle.backgroundImage, 'gradient');\n    };\n\n\n    tests['cssreflections'] = function() {\n        return testPropsAll('boxReflect');\n    };\n\n\n    tests['csstransforms'] = function() {\n        return !!testPropsAll('transform');\n    };\n\n\n    tests['csstransforms3d'] = function() {\n\n        var ret = !!testPropsAll('perspective');\n\n        // Webkit's 3D transforms are passed off to the browser's own graphics renderer.\n        //   It works fine in Safari on Leopard and Snow Leopard, but not in Chrome in\n        //   some conditions. As a result, Webkit typically recognizes the syntax but\n        //   will sometimes throw a false positive, thus we must do a more thorough check:\n        if ( ret && 'webkitPerspective' in docElement.style ) {\n\n            // Webkit allows this media query to succeed only if the feature is enabled.\n            // `@media (transform-3d),(-webkit-transform-3d){ ... }`\n            injectElementWithStyles('@media (transform-3d),(-webkit-transform-3d){#modernizr{left:9px;position:absolute;height:3px;}}', function( node, rule ) {\n                ret = node.offsetLeft === 9 && node.offsetHeight === 3;\n            });\n        }\n        return ret;\n    };\n\n\n    tests['csstransitions'] = function() {\n        return testPropsAll('transition');\n    };\n\n\n    /*>>fontface*/\n    // @font-face detection routine by Diego Perini\n    // javascript.nwbox.com/CSSSupport/\n\n    // false positives:\n    //   WebOS github.com/Modernizr/Modernizr/issues/342\n    //   WP7   github.com/Modernizr/Modernizr/issues/538\n    tests['fontface'] = function() {\n        var bool;\n\n        injectElementWithStyles('@font-face {font-family:\"font\";src:url(\"https://\")}', function( node, rule ) {\n            var style = document.getElementById('smodernizr'),\n                sheet = style.sheet || style.styleSheet,\n                cssText = sheet ? (sheet.cssRules && sheet.cssRules[0] ? sheet.cssRules[0].cssText : sheet.cssText || '') : '';\n\n            bool = /src/i.test(cssText) && cssText.indexOf(rule.split(' ')[0]) === 0;\n        });\n\n        return bool;\n    };\n    /*>>fontface*/\n\n    // CSS generated content detection\n    tests['generatedcontent'] = function() {\n        var bool;\n\n        injectElementWithStyles(['#modernizr:after{content:\"',smile,'\";visibility:hidden}'].join(''), function( node ) {\n            bool = node.offsetHeight >= 1;\n        });\n\n        return bool;\n    };\n\n\n\n    // These tests evaluate support of the video/audio elements, as well as\n    // testing what types of content they support.\n    //\n    // We're using the Boolean constructor here, so that we can extend the value\n    // e.g.  Modernizr.video     // true\n    //       Modernizr.video.ogg // 'probably'\n    //\n    // Codec values from : github.com/NielsLeenheer/html5test/blob/9106a8/index.html#L845\n    //                     thx to NielsLeenheer and zcorpan\n\n    // Note: in some older browsers, \"no\" was a return value instead of empty string.\n    //   It was live in FF3.5.0 and 3.5.1, but fixed in 3.5.2\n    //   It was also live in Safari 4.0.0 - 4.0.4, but fixed in 4.0.5\n\n    tests['video'] = function() {\n        var elem = document.createElement('video'),\n            bool = false;\n\n        // IE9 Running on Windows Server SKU can cause an exception to be thrown, bug #224\n        try {\n            if ( bool = !!elem.canPlayType ) {\n                bool      = new Boolean(bool);\n                bool.ogg  = elem.canPlayType('video/ogg; codecs=\"theora\"')      .replace(/^no$/,'');\n\n                // Without QuickTime, this value will be `undefined`. github.com/Modernizr/Modernizr/issues/546\n                bool.h264 = elem.canPlayType('video/mp4; codecs=\"avc1.42E01E\"') .replace(/^no$/,'');\n\n                bool.webm = elem.canPlayType('video/webm; codecs=\"vp8, vorbis\"').replace(/^no$/,'');\n            }\n\n        } catch(e) { }\n\n        return bool;\n    };\n\n    tests['audio'] = function() {\n        var elem = document.createElement('audio'),\n            bool = false;\n\n        try {\n            if ( bool = !!elem.canPlayType ) {\n                bool      = new Boolean(bool);\n                bool.ogg  = elem.canPlayType('audio/ogg; codecs=\"vorbis\"').replace(/^no$/,'');\n                bool.mp3  = elem.canPlayType('audio/mpeg;')               .replace(/^no$/,'');\n\n                // Mimetypes accepted:\n                //   developer.mozilla.org/En/Media_formats_supported_by_the_audio_and_video_elements\n                //   bit.ly/iphoneoscodecs\n                bool.wav  = elem.canPlayType('audio/wav; codecs=\"1\"')     .replace(/^no$/,'');\n                bool.m4a  = ( elem.canPlayType('audio/x-m4a;')            ||\n                    elem.canPlayType('audio/aac;'))             .replace(/^no$/,'');\n            }\n        } catch(e) { }\n\n        return bool;\n    };\n\n\n    // In FF4, if disabled, window.localStorage should === null.\n\n    // Normally, we could not test that directly and need to do a\n    //   `('localStorage' in window) && ` test first because otherwise Firefox will\n    //   throw bugzil.la/365772 if cookies are disabled\n\n    // Also in iOS5 Private Browsing mode, attempting to use localStorage.setItem\n    // will throw the exception:\n    //   QUOTA_EXCEEDED_ERRROR DOM Exception 22.\n    // Peculiarly, getItem and removeItem calls do not throw.\n\n    // Because we are forced to try/catch this, we'll go aggressive.\n\n    // Just FWIW: IE8 Compat mode supports these features completely:\n    //   www.quirksmode.org/dom/html5.html\n    // But IE8 doesn't support either with local files\n\n    tests['localstorage'] = function() {\n        try {\n            localStorage.setItem(mod, mod);\n            localStorage.removeItem(mod);\n            return true;\n        } catch(e) {\n            return false;\n        }\n    };\n\n    tests['sessionstorage'] = function() {\n        try {\n            sessionStorage.setItem(mod, mod);\n            sessionStorage.removeItem(mod);\n            return true;\n        } catch(e) {\n            return false;\n        }\n    };\n\n\n    tests['webworkers'] = function() {\n        return !!window.Worker;\n    };\n\n\n    tests['applicationcache'] = function() {\n        return !!window.applicationCache;\n    };\n\n\n    // Thanks to Erik Dahlstrom\n    tests['svg'] = function() {\n        return !!document.createElementNS && !!document.createElementNS(ns.svg, 'svg').createSVGRect;\n    };\n\n    // specifically for SVG inline in HTML, not within XHTML\n    // test page: paulirish.com/demo/inline-svg\n    tests['inlinesvg'] = function() {\n        var div = document.createElement('div');\n        div.innerHTML = '<svg/>';\n        return (div.firstChild && div.firstChild.namespaceURI) == ns.svg;\n    };\n\n    // SVG SMIL animation\n    tests['smil'] = function() {\n        return !!document.createElementNS && /SVGAnimate/.test(toString.call(document.createElementNS(ns.svg, 'animate')));\n    };\n\n    // This test is only for clip paths in SVG proper, not clip paths on HTML content\n    // demo: srufaculty.sru.edu/david.dailey/svg/newstuff/clipPath4.svg\n\n    // However read the comments to dig into applying SVG clippaths to HTML content here:\n    //   github.com/Modernizr/Modernizr/issues/213#issuecomment-1149491\n    tests['svgclippaths'] = function() {\n        return !!document.createElementNS && /SVGClipPath/.test(toString.call(document.createElementNS(ns.svg, 'clipPath')));\n    };\n\n    /*>>webforms*/\n    // input features and input types go directly onto the ret object, bypassing the tests loop.\n    // Hold this guy to execute in a moment.\n    function webforms() {\n        /*>>input*/\n        // Run through HTML5's new input attributes to see if the UA understands any.\n        // We're using f which is the <input> element created early on\n        // Mike Taylr has created a comprehensive resource for testing these attributes\n        //   when applied to all input types:\n        //   miketaylr.com/code/input-type-attr.html\n        // spec: www.whatwg.org/specs/web-apps/current-work/multipage/the-input-element.html#input-type-attr-summary\n\n        // Only input placeholder is tested while textarea's placeholder is not.\n        // Currently Safari 4 and Opera 11 have support only for the input placeholder\n        // Both tests are available in feature-detects/forms-placeholder.js\n        Modernizr['input'] = (function( props ) {\n            for ( var i = 0, len = props.length; i < len; i++ ) {\n                attrs[ props[i] ] = !!(props[i] in inputElem);\n            }\n            if (attrs.list){\n                // safari false positive's on datalist: webk.it/74252\n                // see also github.com/Modernizr/Modernizr/issues/146\n                attrs.list = !!(document.createElement('datalist') && window.HTMLDataListElement);\n            }\n            return attrs;\n        })('autocomplete autofocus list placeholder max min multiple pattern required step'.split(' '));\n        /*>>input*/\n\n        /*>>inputtypes*/\n        // Run through HTML5's new input types to see if the UA understands any.\n        //   This is put behind the tests runloop because it doesn't return a\n        //   true/false like all the other tests; instead, it returns an object\n        //   containing each input type with its corresponding true/false value\n\n        // Big thanks to @miketaylr for the html5 forms expertise. miketaylr.com/\n        Modernizr['inputtypes'] = (function(props) {\n\n            for ( var i = 0, bool, inputElemType, defaultView, len = props.length; i < len; i++ ) {\n\n                inputElem.setAttribute('type', inputElemType = props[i]);\n                bool = inputElem.type !== 'text';\n\n                // We first check to see if the type we give it sticks..\n                // If the type does, we feed it a textual value, which shouldn't be valid.\n                // If the value doesn't stick, we know there's input sanitization which infers a custom UI\n                if ( bool ) {\n\n                    inputElem.value         = smile;\n                    inputElem.style.cssText = 'position:absolute;visibility:hidden;';\n\n                    if ( /^range$/.test(inputElemType) && inputElem.style.WebkitAppearance !== undefined ) {\n\n                        docElement.appendChild(inputElem);\n                        defaultView = document.defaultView;\n\n                        // Safari 2-4 allows the smiley as a value, despite making a slider\n                        bool =  defaultView.getComputedStyle &&\n                            defaultView.getComputedStyle(inputElem, null).WebkitAppearance !== 'textfield' &&\n                            // Mobile android web browser has false positive, so must\n                            // check the height to see if the widget is actually there.\n                            (inputElem.offsetHeight !== 0);\n\n                        docElement.removeChild(inputElem);\n\n                    } else if ( /^(search|tel)$/.test(inputElemType) ){\n                        // Spec doesn't define any special parsing or detectable UI\n                        //   behaviors so we pass these through as true\n\n                        // Interestingly, opera fails the earlier test, so it doesn't\n                        //  even make it here.\n\n                    } else if ( /^(url|email)$/.test(inputElemType) ) {\n                        // Real url and email support comes with prebaked validation.\n                        bool = inputElem.checkValidity && inputElem.checkValidity() === false;\n\n                    } else {\n                        // If the upgraded input compontent rejects the :) text, we got a winner\n                        bool = inputElem.value != smile;\n                    }\n                }\n\n                inputs[ props[i] ] = !!bool;\n            }\n            return inputs;\n        })('search tel url email datetime date month week time datetime-local number range color'.split(' '));\n        /*>>inputtypes*/\n    }\n    /*>>webforms*/\n\n\n    // End of test definitions\n    // -----------------------\n\n\n\n    // Run through all tests and detect their support in the current UA.\n    // todo: hypothetically we could be doing an array of tests and use a basic loop here.\n    for ( var feature in tests ) {\n        if ( hasOwnProp(tests, feature) ) {\n            // run the test, throw the return value into the Modernizr,\n            //   then based on that boolean, define an appropriate className\n            //   and push it into an array of classes we'll join later.\n            featureName  = feature.toLowerCase();\n            Modernizr[featureName] = tests[feature]();\n\n            classes.push((Modernizr[featureName] ? '' : 'no-') + featureName);\n        }\n    }\n\n    /*>>webforms*/\n    // input tests need to run.\n    Modernizr.input || webforms();\n    /*>>webforms*/\n\n\n    /**\n     * addTest allows the user to define their own feature tests\n     * the result will be added onto the Modernizr object,\n     * as well as an appropriate className set on the html element\n     *\n     * @param feature - String naming the feature\n     * @param test - Function returning true if feature is supported, false if not\n     */\n    Modernizr.addTest = function ( feature, test ) {\n        if ( typeof feature == 'object' ) {\n            for ( var key in feature ) {\n                if ( hasOwnProp( feature, key ) ) {\n                    Modernizr.addTest( key, feature[ key ] );\n                }\n            }\n        } else {\n\n            feature = feature.toLowerCase();\n\n            if ( Modernizr[feature] !== undefined ) {\n                // we're going to quit if you're trying to overwrite an existing test\n                // if we were to allow it, we'd do this:\n                //   var re = new RegExp(\"\\\\b(no-)?\" + feature + \"\\\\b\");\n                //   docElement.className = docElement.className.replace( re, '' );\n                // but, no rly, stuff 'em.\n                return Modernizr;\n            }\n\n            test = typeof test == 'function' ? test() : test;\n\n            if (enableClasses) {\n                docElement.className += ' ' + (test ? '' : 'no-') + feature;\n            }\n            Modernizr[feature] = test;\n\n        }\n\n        return Modernizr; // allow chaining.\n    };\n\n\n    // Reset modElem.cssText to nothing to reduce memory footprint.\n    setCss('');\n    modElem = inputElem = null;\n\n    /*>>shiv*/\n    /*! HTML5 Shiv v3.6 | @afarkas @jdalton @jon_neal @rem | MIT/GPL2 Licensed */\n    ;(function(window, document) {\n        /*jshint evil:true */\n        /** Preset options */\n        var options = window.html5 || {};\n\n        /** Used to skip problem elements */\n        var reSkip = /^<|^(?:button|map|select|textarea|object|iframe|option|optgroup)$/i;\n\n        /** Not all elements can be cloned in IE (this list can be shortend) **/\n        var saveClones = /^<|^(?:a|b|button|code|div|fieldset|form|h1|h2|h3|h4|h5|h6|i|iframe|img|input|label|li|link|ol|option|p|param|q|script|select|span|strong|style|table|tbody|td|textarea|tfoot|th|thead|tr|ul)$/i;\n\n        /** Detect whether the browser supports default html5 styles */\n        var supportsHtml5Styles;\n\n        /** Name of the expando, to work with multiple documents or to re-shiv one document */\n        var expando = '_html5shiv';\n\n        /** The id for the the documents expando */\n        var expanID = 0;\n\n        /** Cached data for each document */\n        var expandoData = {};\n\n        /** Detect whether the browser supports unknown elements */\n        var supportsUnknownElements;\n\n        (function() {\n            try {\n                var a = document.createElement('a');\n                a.innerHTML = '<xyz></xyz>';\n                //if the hidden property is implemented we can assume, that the browser supports basic HTML5 Styles\n                supportsHtml5Styles = ('hidden' in a);\n\n                supportsUnknownElements = a.childNodes.length == 1 || (function() {\n                    // assign a false positive if unable to shiv\n                    (document.createElement)('a');\n                    var frag = document.createDocumentFragment();\n                    return (\n                        typeof frag.cloneNode == 'undefined' ||\n                            typeof frag.createDocumentFragment == 'undefined' ||\n                            typeof frag.createElement == 'undefined'\n                        );\n                }());\n            } catch(e) {\n                supportsHtml5Styles = true;\n                supportsUnknownElements = true;\n            }\n\n        }());\n\n        /*--------------------------------------------------------------------------*/\n\n        /**\n         * Creates a style sheet with the given CSS text and adds it to the document.\n         * @private\n         * @param {Document} ownerDocument The document.\n         * @param {String} cssText The CSS text.\n         * @returns {StyleSheet} The style element.\n         */\n        function addStyleSheet(ownerDocument, cssText) {\n            var p = ownerDocument.createElement('p'),\n                parent = ownerDocument.getElementsByTagName('head')[0] || ownerDocument.documentElement;\n\n            p.innerHTML = 'x<style>' + cssText + '</style>';\n            return parent.insertBefore(p.lastChild, parent.firstChild);\n        }\n\n        /**\n         * Returns the value of `html5.elements` as an array.\n         * @private\n         * @returns {Array} An array of shived element node names.\n         */\n        function getElements() {\n            var elements = html5.elements;\n            return typeof elements == 'string' ? elements.split(' ') : elements;\n        }\n\n        /**\n         * Returns the data associated to the given document\n         * @private\n         * @param {Document} ownerDocument The document.\n         * @returns {Object} An object of data.\n         */\n        function getExpandoData(ownerDocument) {\n            var data = expandoData[ownerDocument[expando]];\n            if (!data) {\n                data = {};\n                expanID++;\n                ownerDocument[expando] = expanID;\n                expandoData[expanID] = data;\n            }\n            return data;\n        }\n\n        /**\n         * returns a shived element for the given nodeName and document\n         * @memberOf html5\n         * @param {String} nodeName name of the element\n         * @param {Document} ownerDocument The context document.\n         * @returns {Object} The shived element.\n         */\n        function createElement(nodeName, ownerDocument, data){\n            if (!ownerDocument) {\n                ownerDocument = document;\n            }\n            if(supportsUnknownElements){\n                return ownerDocument.createElement(nodeName);\n            }\n            if (!data) {\n                data = getExpandoData(ownerDocument);\n            }\n            var node;\n\n            if (data.cache[nodeName]) {\n                node = data.cache[nodeName].cloneNode();\n            } else if (saveClones.test(nodeName)) {\n                node = (data.cache[nodeName] = data.createElem(nodeName)).cloneNode();\n            } else {\n                node = data.createElem(nodeName);\n            }\n\n            // Avoid adding some elements to fragments in IE < 9 because\n            // * Attributes like `name` or `type` cannot be set/changed once an element\n            //   is inserted into a document/fragment\n            // * Link elements with `src` attributes that are inaccessible, as with\n            //   a 403 response, will cause the tab/window to crash\n            // * Script elements appended to fragments will execute when their `src`\n            //   or `text` property is set\n            return node.canHaveChildren && !reSkip.test(nodeName) ? data.frag.appendChild(node) : node;\n        }\n\n        /**\n         * returns a shived DocumentFragment for the given document\n         * @memberOf html5\n         * @param {Document} ownerDocument The context document.\n         * @returns {Object} The shived DocumentFragment.\n         */\n        function createDocumentFragment(ownerDocument, data){\n            if (!ownerDocument) {\n                ownerDocument = document;\n            }\n            if(supportsUnknownElements){\n                return ownerDocument.createDocumentFragment();\n            }\n            data = data || getExpandoData(ownerDocument);\n            var clone = data.frag.cloneNode(),\n                i = 0,\n                elems = getElements(),\n                l = elems.length;\n            for(;i<l;i++){\n                clone.createElement(elems[i]);\n            }\n            return clone;\n        }\n\n        /**\n         * Shivs the `createElement` and `createDocumentFragment` methods of the document.\n         * @private\n         * @param {Document|DocumentFragment} ownerDocument The document.\n         * @param {Object} data of the document.\n         */\n        function shivMethods(ownerDocument, data) {\n            if (!data.cache) {\n                data.cache = {};\n                data.createElem = ownerDocument.createElement;\n                data.createFrag = ownerDocument.createDocumentFragment;\n                data.frag = data.createFrag();\n            }\n\n\n            ownerDocument.createElement = function(nodeName) {\n                //abort shiv\n                if (!html5.shivMethods) {\n                    return data.createElem(nodeName);\n                }\n                return createElement(nodeName, ownerDocument, data);\n            };\n\n            ownerDocument.createDocumentFragment = Function('h,f', 'return function(){' +\n                'var n=f.cloneNode(),c=n.createElement;' +\n                'h.shivMethods&&(' +\n                // unroll the `createElement` calls\n                getElements().join().replace(/\\w+/g, function(nodeName) {\n                    data.createElem(nodeName);\n                    data.frag.createElement(nodeName);\n                    return 'c(\"' + nodeName + '\")';\n                }) +\n                ');return n}'\n            )(html5, data.frag);\n        }\n\n        /*--------------------------------------------------------------------------*/\n\n        /**\n         * Shivs the given document.\n         * @memberOf html5\n         * @param {Document} ownerDocument The document to shiv.\n         * @returns {Document} The shived document.\n         */\n        function shivDocument(ownerDocument) {\n            if (!ownerDocument) {\n                ownerDocument = document;\n            }\n            var data = getExpandoData(ownerDocument);\n\n            if (html5.shivCSS && !supportsHtml5Styles && !data.hasCSS) {\n                data.hasCSS = !!addStyleSheet(ownerDocument,\n                    // corrects block display not defined in IE6/7/8/9\n                    'article,aside,figcaption,figure,footer,header,hgroup,nav,section{display:block}' +\n                        // adds styling not present in IE6/7/8/9\n                        'mark{background:#FF0;color:#000}'\n                );\n            }\n            if (!supportsUnknownElements) {\n                shivMethods(ownerDocument, data);\n            }\n            return ownerDocument;\n        }\n\n        /*--------------------------------------------------------------------------*/\n\n        /**\n         * The `html5` object is exposed so that more elements can be shived and\n         * existing shiving can be detected on iframes.\n         * @type Object\n         * @example\n         *\n         * // options can be changed before the script is included\n         * html5 = { 'elements': 'mark section', 'shivCSS': false, 'shivMethods': false };\n         */\n        var html5 = {\n\n            /**\n             * An array or space separated string of node names of the elements to shiv.\n             * @memberOf html5\n             * @type Array|String\n             */\n            'elements': options.elements || 'abbr article aside audio bdi canvas data datalist details figcaption figure footer header hgroup mark meter nav output progress section summary time video',\n\n            /**\n             * A flag to indicate that the HTML5 style sheet should be inserted.\n             * @memberOf html5\n             * @type Boolean\n             */\n            'shivCSS': (options.shivCSS !== false),\n\n            /**\n             * Is equal to true if a browser supports creating unknown/HTML5 elements\n             * @memberOf html5\n             * @type boolean\n             */\n            'supportsUnknownElements': supportsUnknownElements,\n\n            /**\n             * A flag to indicate that the document's `createElement` and `createDocumentFragment`\n             * methods should be overwritten.\n             * @memberOf html5\n             * @type Boolean\n             */\n            'shivMethods': (options.shivMethods !== false),\n\n            /**\n             * A string to describe the type of `html5` object (\"default\" or \"default print\").\n             * @memberOf html5\n             * @type String\n             */\n            'type': 'default',\n\n            // shivs the document according to the specified `html5` object options\n            'shivDocument': shivDocument,\n\n            //creates a shived element\n            createElement: createElement,\n\n            //creates a shived documentFragment\n            createDocumentFragment: createDocumentFragment\n        };\n\n        /*--------------------------------------------------------------------------*/\n\n        // expose html5\n        window.html5 = html5;\n\n        // shiv the document\n        shivDocument(document);\n\n    }(this, document));\n    /*>>shiv*/\n\n    // Assign private properties to the return object with prefix\n    Modernizr._version      = version;\n\n    // expose these for the plugin API. Look in the source for how to join() them against your input\n    /*>>prefixes*/\n    Modernizr._prefixes     = prefixes;\n    /*>>prefixes*/\n    /*>>domprefixes*/\n    Modernizr._domPrefixes  = domPrefixes;\n    Modernizr._cssomPrefixes  = cssomPrefixes;\n    /*>>domprefixes*/\n\n    /*>>mq*/\n    // Modernizr.mq tests a given media query, live against the current state of the window\n    // A few important notes:\n    //   * If a browser does not support media queries at all (eg. oldIE) the mq() will always return false\n    //   * A max-width or orientation query will be evaluated against the current state, which may change later.\n    //   * You must specify values. Eg. If you are testing support for the min-width media query use:\n    //       Modernizr.mq('(min-width:0)')\n    // usage:\n    // Modernizr.mq('only screen and (max-width:768)')\n    Modernizr.mq            = testMediaQuery;\n    /*>>mq*/\n\n    /*>>hasevent*/\n    // Modernizr.hasEvent() detects support for a given event, with an optional element to test on\n    // Modernizr.hasEvent('gesturestart', elem)\n    Modernizr.hasEvent      = isEventSupported;\n    /*>>hasevent*/\n\n    /*>>testprop*/\n    // Modernizr.testProp() investigates whether a given style property is recognized\n    // Note that the property names must be provided in the camelCase variant.\n    // Modernizr.testProp('pointerEvents')\n    Modernizr.testProp      = function(prop){\n        return testProps([prop]);\n    };\n    /*>>testprop*/\n\n    /*>>testallprops*/\n    // Modernizr.testAllProps() investigates whether a given style property,\n    //   or any of its vendor-prefixed variants, is recognized\n    // Note that the property names must be provided in the camelCase variant.\n    // Modernizr.testAllProps('boxSizing')\n    Modernizr.testAllProps  = testPropsAll;\n    /*>>testallprops*/\n\n\n    /*>>teststyles*/\n    // Modernizr.testStyles() allows you to add custom styles to the document and test an element afterwards\n    // Modernizr.testStyles('#modernizr { position:absolute }', function(elem, rule){ ... })\n    Modernizr.testStyles    = injectElementWithStyles;\n    /*>>teststyles*/\n\n\n    /*>>prefixed*/\n    // Modernizr.prefixed() returns the prefixed or nonprefixed property name variant of your input\n    // Modernizr.prefixed('boxSizing') // 'MozBoxSizing'\n\n    // Properties must be passed as dom-style camelcase, rather than `box-sizing` hypentated style.\n    // Return values will also be the camelCase variant, if you need to translate that to hypenated style use:\n    //\n    //     str.replace(/([A-Z])/g, function(str,m1){ return '-' + m1.toLowerCase(); }).replace(/^ms-/,'-ms-');\n\n    // If you're trying to ascertain which transition end event to bind to, you might do something like...\n    //\n    //     var transEndEventNames = {\n    //       'WebkitTransition' : 'webkitTransitionEnd',\n    //       'MozTransition'    : 'transitionend',\n    //       'OTransition'      : 'oTransitionEnd',\n    //       'msTransition'     : 'MSTransitionEnd',\n    //       'transition'       : 'transitionend'\n    //     },\n    //     transEndEventName = transEndEventNames[ Modernizr.prefixed('transition') ];\n\n    Modernizr.prefixed      = function(prop, obj, elem){\n        if(!obj) {\n            return testPropsAll(prop, 'pfx');\n        } else {\n            // Testing DOM property e.g. Modernizr.prefixed('requestAnimationFrame', window) // 'mozRequestAnimationFrame'\n            return testPropsAll(prop, obj, elem);\n        }\n    };\n    /*>>prefixed*/\n\n\n    /*>>cssclasses*/\n    // Remove \"no-js\" class from <html> element, if it exists:\n    docElement.className = docElement.className.replace(/(^|\\s)no-js(\\s|$)/, '$1$2') +\n\n        // Add the new classes to the <html> element.\n        (enableClasses ? ' js ' + classes.join(' ') : '');\n    /*>>cssclasses*/\n\n    return Modernizr;\n\n})(this, this.document);","requirejs/domReady.js":"/**\n * @license RequireJS domReady 2.0.1 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/domReady for details\n */\n/*jslint */\n/*global require: false, define: false, requirejs: false,\n  window: false, clearInterval: false, document: false,\n  self: false, setInterval: false */\n\n\ndefine(function () {\n    'use strict';\n\n    var isTop, testDiv, scrollIntervalId,\n        isBrowser = typeof window !== \"undefined\" && window.document,\n        isPageLoaded = !isBrowser,\n        doc = isBrowser ? document : null,\n        readyCalls = [];\n\n    function runCallbacks(callbacks) {\n        var i;\n        for (i = 0; i < callbacks.length; i += 1) {\n            callbacks[i](doc);\n        }\n    }\n\n    function callReady() {\n        var callbacks = readyCalls;\n\n        if (isPageLoaded) {\n            //Call the DOM ready callbacks\n            if (callbacks.length) {\n                readyCalls = [];\n                runCallbacks(callbacks);\n            }\n        }\n    }\n\n    /**\n     * Sets the page as loaded.\n     */\n    function pageLoaded() {\n        if (!isPageLoaded) {\n            isPageLoaded = true;\n            if (scrollIntervalId) {\n                clearInterval(scrollIntervalId);\n            }\n\n            callReady();\n        }\n    }\n\n    if (isBrowser) {\n        if (document.addEventListener) {\n            //Standards. Hooray! Assumption here that if standards based,\n            //it knows about DOMContentLoaded.\n            document.addEventListener(\"DOMContentLoaded\", pageLoaded, false);\n            window.addEventListener(\"load\", pageLoaded, false);\n        } else if (window.attachEvent) {\n            window.attachEvent(\"onload\", pageLoaded);\n\n            testDiv = document.createElement('div');\n            try {\n                isTop = window.frameElement === null;\n            } catch (e) {}\n\n            //DOMContentLoaded approximation that uses a doScroll, as found by\n            //Diego Perini: http://javascript.nwbox.com/IEContentLoaded/,\n            //but modified by other contributors, including jdalton\n            if (testDiv.doScroll && isTop && window.external) {\n                scrollIntervalId = setInterval(function () {\n                    try {\n                        testDiv.doScroll();\n                        pageLoaded();\n                    } catch (e) {}\n                }, 30);\n            }\n        }\n\n        //Check if document already complete, and if so, just trigger page load\n        //listeners. Latest webkit browsers also use \"interactive\", and\n        //will fire the onDOMContentLoaded before \"interactive\" but not after\n        //entering \"interactive\" or \"complete\". More details:\n        //http://dev.w3.org/html5/spec/the-end.html#the-end\n        //http://stackoverflow.com/questions/3665561/document-readystate-of-interactive-vs-ondomcontentloaded\n        //Hmm, this is more complicated on further use, see \"firing too early\"\n        //bug: https://github.com/requirejs/domReady/issues/1\n        //so removing the || document.readyState === \"interactive\" test.\n        //There is still a window.onload binding that should get fired if\n        //DOMContentLoaded is missed.\n        if (document.readyState === \"complete\") {\n            pageLoaded();\n        }\n    }\n\n    /** START OF PUBLIC API **/\n\n    /**\n     * Registers a callback for DOM ready. If DOM is already ready, the\n     * callback is called immediately.\n     * @param {Function} callback\n     */\n    function domReady(callback) {\n        if (isPageLoaded) {\n            callback(doc);\n        } else {\n            readyCalls.push(callback);\n        }\n        return domReady;\n    }\n\n    domReady.version = '2.0.1';\n\n    /**\n     * Loader Plugin API method\n     */\n    domReady.load = function (name, req, onLoad, config) {\n        if (config.isBuild) {\n            onLoad(null);\n        } else {\n            domReady(onLoad);\n        }\n    };\n\n    /** END OF PUBLIC API **/\n\n    return domReady;\n});","varien/form.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Most likely it's depracated classes.\n * Not used anywhere among pages.\n */\nVarienForm = Class.create();\nVarienForm.prototype = {\n    initialize: function(formId, firstFieldFocus){\n        this.form       = $(formId);\n        if (!this.form) {\n            return;\n        }\n        this.cache      = $A();\n        this.currLoader = false;\n        this.currDataIndex = false;\n        this.validator  = new Validation(this.form);\n        this.elementFocus   = this.elementOnFocus.bindAsEventListener(this);\n        this.elementBlur    = this.elementOnBlur.bindAsEventListener(this);\n        this.childLoader    = this.onChangeChildLoad.bindAsEventListener(this);\n        this.highlightClass = 'highlight';\n        this.extraChildParams = '';\n        this.firstFieldFocus= firstFieldFocus || false;\n        this.bindElements();\n        if(this.firstFieldFocus){\n            try{\n                Form.Element.focus(Form.findFirstElement(this.form))\n            }\n            catch(e){}\n        }\n    },\n\n    submit : function(url){\n        if(this.validator && this.validator.validate()){\n             this.form.submit();\n        }\n        return false;\n    },\n\n    bindElements:function (){\n        var elements = Form.getElements(this.form);\n        for (var row in elements) {\n            if (elements[row].id) {\n                Event.observe(elements[row],'focus',this.elementFocus);\n                Event.observe(elements[row],'blur',this.elementBlur);\n            }\n        }\n    },\n\n    elementOnFocus: function(event){\n        var element = Event.findElement(event, 'fieldset');\n        if(element){\n            Element.addClassName(element, this.highlightClass);\n        }\n    },\n\n    elementOnBlur: function(event){\n        var element = Event.findElement(event, 'fieldset');\n        if(element){\n            Element.removeClassName(element, this.highlightClass);\n        }\n    },\n\n    setElementsRelation: function(parent, child, dataUrl, first){\n        if (parent=$(parent)) {\n            // TODO: array of relation and caching\n            if (!this.cache[parent.id]){\n                this.cache[parent.id] = $A();\n                this.cache[parent.id]['child']     = child;\n                this.cache[parent.id]['dataUrl']   = dataUrl;\n                this.cache[parent.id]['data']      = $A();\n                this.cache[parent.id]['first']      = first || false;\n            }\n            Event.observe(parent,'change',this.childLoader);\n        }\n    },\n\n    onChangeChildLoad: function(event){\n        element = Event.element(event);\n        this.elementChildLoad(element);\n    },\n\n    elementChildLoad: function(element, callback){\n        this.callback = callback || false;\n        if (element.value) {\n            this.currLoader = element.id;\n            this.currDataIndex = element.value;\n            if (this.cache[element.id]['data'][element.value]) {\n                this.setDataToChild(this.cache[element.id]['data'][element.value]);\n            }\n            else{\n                new Ajax.Request(this.cache[this.currLoader]['dataUrl'],{\n                        method: 'post',\n                        parameters: {\"parent\":element.value},\n                        onComplete: this.reloadChildren.bind(this)\n                });\n            }\n        }\n    },\n\n    reloadChildren: function(transport){\n        var data = eval('(' + transport.responseText + ')');\n        this.cache[this.currLoader]['data'][this.currDataIndex] = data;\n        this.setDataToChild(data);\n    },\n\n    setDataToChild: function(data){\n        if (data.length) {\n            var child = $(this.cache[this.currLoader]['child']);\n            if (child){\n                var html = '<select name=\"'+child.name+'\" id=\"'+child.id+'\" class=\"'+child.className+'\" title=\"'+child.title+'\" '+this.extraChildParams+'>';\n                if(this.cache[this.currLoader]['first']){\n                    html+= '<option value=\"\">'+this.cache[this.currLoader]['first']+'</option>';\n                }\n                for (var i in data){\n                    if(data[i].value) {\n                        html+= '<option value=\"'+data[i].value+'\"';\n                        if(child.value && (child.value == data[i].value || child.value == data[i].label)){\n                            html+= ' selected';\n                        }\n                        html+='>'+data[i].label+'</option>';\n                    }\n                }\n                html+= '</select>';\n                Element.insert(child, {before: html});\n                Element.remove(child);\n            }\n        }\n        else{\n            var child = $(this.cache[this.currLoader]['child']);\n            if (child){\n                var html = '<input type=\"text\" name=\"'+child.name+'\" id=\"'+child.id+'\" class=\"'+child.className+'\" title=\"'+child.title+'\" '+this.extraChildParams+'>';\n                Element.insert(child, {before: html});\n                Element.remove(child);\n            }\n        }\n\n        this.bindElements();\n        if (this.callback) {\n            this.callback();\n        }\n    }\n}\n\nRegionUpdater = Class.create();\nRegionUpdater.prototype = {\n    initialize: function (countryEl, regionTextEl, regionSelectEl, regions, disableAction, zipEl)\n    {\n        this.countryEl = $(countryEl);\n        this.regionTextEl = $(regionTextEl);\n        this.regionSelectEl = $(regionSelectEl);\n        this.zipEl = $(zipEl);\n        this.config = regions['config'];\n        delete regions.config;\n        this.regions = regions;\n\n        this.disableAction = (typeof disableAction=='undefined') ? 'hide' : disableAction;\n        this.zipOptions = (typeof zipOptions=='undefined') ? false : zipOptions;\n\n        if (this.regionSelectEl.options.length<=1) {\n            this.update();\n        }\n\n        Event.observe(this.countryEl, 'change', this.update.bind(this));\n    },\n\n    _checkRegionRequired: function()\n    {\n        var label, wildCard;\n        var elements = [this.regionTextEl, this.regionSelectEl];\n        var that = this;\n        if (typeof this.config == 'undefined') {\n            return;\n        }\n        var regionRequired = this.config.regions_required.indexOf(this.countryEl.value) >= 0;\n\n        elements.each(function(currentElement) {\n            Validation.reset(currentElement);\n            label = $$('label[for=\"' + currentElement.id + '\"]')[0];\n            if (label) {\n                wildCard = label.down('em') || label.down('span.required');\n                if (!that.config.show_all_regions) {\n                    if (regionRequired) {\n                        label.up().show();\n                    } else {\n                        label.up().hide();\n                    }\n                }\n            }\n\n            if (label && wildCard) {\n                if (!regionRequired) {\n                    wildCard.hide();\n                    if (label.hasClassName('required')) {\n                        label.removeClassName('required');\n                    }\n                } else if (regionRequired) {\n                    wildCard.show();\n                    if (!label.hasClassName('required')) {\n                        label.addClassName('required')\n                    }\n                }\n            }\n\n            if (!regionRequired) {\n                if (currentElement.hasClassName('required-entry')) {\n                    currentElement.removeClassName('required-entry');\n                }\n                if ('select' == currentElement.tagName.toLowerCase() &&\n                    currentElement.hasClassName('validate-select')) {\n                    currentElement.removeClassName('validate-select');\n                }\n            } else {\n                if (!currentElement.hasClassName('required-entry')) {\n                    currentElement.addClassName('required-entry');\n                }\n                if ('select' == currentElement.tagName.toLowerCase() &&\n                    !currentElement.hasClassName('validate-select')) {\n                    currentElement.addClassName('validate-select');\n                }\n            }\n        });\n    },\n\n    update: function()\n    {\n        if (this.regions[this.countryEl.value]) {\n            var i, option, region, def;\n\n            def = this.regionSelectEl.getAttribute('defaultValue');\n            if (this.regionTextEl) {\n                if (!def) {\n                    def = this.regionTextEl.value.toLowerCase();\n                }\n                this.regionTextEl.value = '';\n            }\n\n            this.regionSelectEl.options.length = 1;\n            for (regionId in this.regions[this.countryEl.value]) {\n                region = this.regions[this.countryEl.value][regionId];\n\n                option = document.createElement('OPTION');\n                option.value = regionId;\n                option.text = region.name.stripTags();\n                option.title = region.name;\n\n                if (this.regionSelectEl.options.add) {\n                    this.regionSelectEl.options.add(option);\n                } else {\n                    this.regionSelectEl.appendChild(option);\n                }\n\n                if (regionId==def || (region.name && region.name.toLowerCase()==def) ||\n                    (region.name && region.code.toLowerCase()==def)\n                ) {\n                    this.regionSelectEl.value = regionId;\n                }\n            }\n\n            if (this.disableAction=='hide') {\n                if (this.regionTextEl) {\n                    this.regionTextEl.style.display = 'none';\n                }\n\n                this.regionSelectEl.style.display = '';\n            } else if (this.disableAction=='disable') {\n                if (this.regionTextEl) {\n                    this.regionTextEl.disabled = true;\n                }\n                this.regionSelectEl.disabled = false;\n            }\n            this.setMarkDisplay(this.regionSelectEl, true);\n        } else {\n            this.regionSelectEl.options.length = 1;\n            if (this.disableAction=='hide') {\n                if (this.regionTextEl) {\n                    this.regionTextEl.style.display = '';\n                }\n                this.regionSelectEl.style.display = 'none';\n                Validation.reset(this.regionSelectEl);\n            } else if (this.disableAction=='disable') {\n                if (this.regionTextEl) {\n                    this.regionTextEl.disabled = false;\n                }\n                this.regionSelectEl.disabled = true;\n            } else if (this.disableAction=='nullify') {\n                this.regionSelectEl.options.length = 1;\n                this.regionSelectEl.value = '';\n                this.regionSelectEl.selectedIndex = 0;\n                this.lastCountryId = '';\n            }\n            this.setMarkDisplay(this.regionSelectEl, false);\n        }\n\n        this._checkRegionRequired();\n        // Make Zip and its label required/optional\n        var zipUpdater = new ZipUpdater(this.countryEl.value, this.zipEl);\n        zipUpdater.update();\n    },\n\n    setMarkDisplay: function(elem, display){\n        elem = $(elem);\n        var labelElement = elem.up(0).down('label > span.required') ||\n                           elem.up(1).down('label > span.required') ||\n                           elem.up(0).down('label.required > em') ||\n                           elem.up(1).down('label.required > em');\n        if(labelElement) {\n            inputElement = labelElement.up().next('input');\n            if (display) {\n                labelElement.show();\n                if (inputElement) {\n                    inputElement.addClassName('required-entry');\n                }\n            } else {\n                labelElement.hide();\n                if (inputElement) {\n                    inputElement.removeClassName('required-entry');\n                }\n            }\n        }\n    }\n}\n\nZipUpdater = Class.create();\nZipUpdater.prototype = {\n    initialize: function(country, zipElement)\n    {\n        this.country = country;\n        this.zipElement = $(zipElement);\n    },\n\n    update: function()\n    {\n        // Country ISO 2-letter codes must be pre-defined\n        if (typeof optionalZipCountries == 'undefined') {\n            return false;\n        }\n\n        // Ajax-request and normal content load compatibility\n        if (this.zipElement != undefined) {\n            this._setPostcodeOptional();\n        } else {\n            Event.observe(window, \"load\", this._setPostcodeOptional.bind(this));\n        }\n    },\n\n    _setPostcodeOptional: function()\n    {\n        this.zipElement = $(this.zipElement);\n        if (this.zipElement == undefined) {\n            return false;\n        }\n\n        // find label\n        var label = $$('label[for=\"' + this.zipElement.id + '\"]')[0];\n        if (label != undefined) {\n            var wildCard = label.down('em') || label.down('span.required');\n        }\n\n        // Make Zip and its label required/optional\n        if (optionalZipCountries.indexOf(this.country) != -1) {\n            while (this.zipElement.hasClassName('required-entry')) {\n                this.zipElement.removeClassName('required-entry');\n            }\n            if (wildCard != undefined) {\n                wildCard.hide();\n            }\n        } else {\n            this.zipElement.addClassName('required-entry');\n            if (wildCard != undefined) {\n                wildCard.show();\n            }\n        }\n    }\n}\n"}
    }
});
