require.config({
    config: {
        'jsbuild':{"jquery/jquery-ui-timepicker-addon.js":"/*! jQuery Timepicker Addon - v1.4.3 - 2013-11-30\n* http://trentrichardson.com/examples/timepicker\n* Copyright (c) 2013 Trent Richardson; Licensed MIT */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/ui\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n\t/*\n\t* Lets not redefine timepicker, Prevent \"Uncaught RangeError: Maximum call stack size exceeded\"\n\t*/\n\t$.ui.timepicker = $.ui.timepicker || {};\n\tif ($.ui.timepicker.version) {\n\t\treturn;\n\t}\n\n\t/*\n\t* Extend jQueryUI, get it started with our version number\n\t*/\n\t$.extend($.ui, {\n\t\ttimepicker: {\n\t\t\tversion: \"1.4.3\"\n\t\t}\n\t});\n\n\t/* \n\t* Timepicker manager.\n\t* Use the singleton instance of this class, $.timepicker, to interact with the time picker.\n\t* Settings for (groups of) time pickers are maintained in an instance object,\n\t* allowing multiple different settings on the same page.\n\t*/\n\tvar Timepicker = function () {\n\t\tthis.regional = []; // Available regional settings, indexed by language code\n\t\tthis.regional[''] = { // Default regional settings\n\t\t\tcurrentText: 'Now',\n\t\t\tcloseText: 'Done',\n\t\t\tamNames: ['AM', 'A'],\n\t\t\tpmNames: ['PM', 'P'],\n\t\t\ttimeFormat: 'HH:mm',\n\t\t\ttimeSuffix: '',\n\t\t\ttimeOnlyTitle: 'Choose Time',\n\t\t\ttimeText: 'Time',\n\t\t\thourText: 'Hour',\n\t\t\tminuteText: 'Minute',\n\t\t\tsecondText: 'Second',\n\t\t\tmillisecText: 'Millisecond',\n\t\t\tmicrosecText: 'Microsecond',\n\t\t\ttimezoneText: 'Time Zone',\n\t\t\tisRTL: false\n\t\t};\n\t\tthis._defaults = { // Global defaults for all the datetime picker instances\n\t\t\tshowButtonPanel: true,\n\t\t\ttimeOnly: false,\n\t\t\tshowHour: null,\n\t\t\tshowMinute: null,\n\t\t\tshowSecond: null,\n\t\t\tshowMillisec: null,\n\t\t\tshowMicrosec: null,\n\t\t\tshowTimezone: null,\n\t\t\tshowTime: true,\n\t\t\tstepHour: 1,\n\t\t\tstepMinute: 1,\n\t\t\tstepSecond: 1,\n\t\t\tstepMillisec: 1,\n\t\t\tstepMicrosec: 1,\n\t\t\thour: 0,\n\t\t\tminute: 0,\n\t\t\tsecond: 0,\n\t\t\tmillisec: 0,\n\t\t\tmicrosec: 0,\n\t\t\ttimezone: null,\n\t\t\thourMin: 0,\n\t\t\tminuteMin: 0,\n\t\t\tsecondMin: 0,\n\t\t\tmillisecMin: 0,\n\t\t\tmicrosecMin: 0,\n\t\t\thourMax: 23,\n\t\t\tminuteMax: 59,\n\t\t\tsecondMax: 59,\n\t\t\tmillisecMax: 999,\n\t\t\tmicrosecMax: 999,\n\t\t\tminDateTime: null,\n\t\t\tmaxDateTime: null,\n\t\t\tonSelect: null,\n\t\t\thourGrid: 0,\n\t\t\tminuteGrid: 0,\n\t\t\tsecondGrid: 0,\n\t\t\tmillisecGrid: 0,\n\t\t\tmicrosecGrid: 0,\n\t\t\talwaysSetTime: true,\n\t\t\tseparator: ' ',\n\t\t\taltFieldTimeOnly: true,\n\t\t\taltTimeFormat: null,\n\t\t\taltSeparator: null,\n\t\t\taltTimeSuffix: null,\n\t\t\tpickerTimeFormat: null,\n\t\t\tpickerTimeSuffix: null,\n\t\t\tshowTimepicker: true,\n\t\t\ttimezoneList: null,\n\t\t\taddSliderAccess: false,\n\t\t\tsliderAccessArgs: null,\n\t\t\tcontrolType: 'slider',\n\t\t\tdefaultValue: null,\n\t\t\tparse: 'strict'\n\t\t};\n\t\t$.extend(this._defaults, this.regional['']);\n\t};\n\n\t$.extend(Timepicker.prototype, {\n\t\t$input: null,\n\t\t$altInput: null,\n\t\t$timeObj: null,\n\t\tinst: null,\n\t\thour_slider: null,\n\t\tminute_slider: null,\n\t\tsecond_slider: null,\n\t\tmillisec_slider: null,\n\t\tmicrosec_slider: null,\n\t\ttimezone_select: null,\n\t\thour: 0,\n\t\tminute: 0,\n\t\tsecond: 0,\n\t\tmillisec: 0,\n\t\tmicrosec: 0,\n\t\ttimezone: null,\n\t\thourMinOriginal: null,\n\t\tminuteMinOriginal: null,\n\t\tsecondMinOriginal: null,\n\t\tmillisecMinOriginal: null,\n\t\tmicrosecMinOriginal: null,\n\t\thourMaxOriginal: null,\n\t\tminuteMaxOriginal: null,\n\t\tsecondMaxOriginal: null,\n\t\tmillisecMaxOriginal: null,\n\t\tmicrosecMaxOriginal: null,\n\t\tampm: '',\n\t\tformattedDate: '',\n\t\tformattedTime: '',\n\t\tformattedDateTime: '',\n\t\ttimezoneList: null,\n\t\tunits: ['hour', 'minute', 'second', 'millisec', 'microsec'],\n\t\tsupport: {},\n\t\tcontrol: null,\n\n\t\t/* \n\t\t* Override the default settings for all instances of the time picker.\n\t\t* @param  {Object} settings  object - the new settings to use as defaults (anonymous object)\n\t\t* @return {Object} the manager object\n\t\t*/\n\t\tsetDefaults: function (settings) {\n\t\t\textendRemove(this._defaults, settings || {});\n\t\t\treturn this;\n\t\t},\n\n\t\t/*\n\t\t* Create a new Timepicker instance\n\t\t*/\n\t\t_newInst: function ($input, opts) {\n\t\t\tvar tp_inst = new Timepicker(),\n\t\t\t\tinlineSettings = {},\n\t\t\t\tfns = {},\n\t\t\t\toverrides, i;\n\n\t\t\tfor (var attrName in this._defaults) {\n\t\t\t\tif (this._defaults.hasOwnProperty(attrName)) {\n\t\t\t\t\tvar attrValue = $input.attr('time:' + attrName);\n\t\t\t\t\tif (attrValue) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tinlineSettings[attrName] = eval(attrValue);\n\t\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t\tinlineSettings[attrName] = attrValue;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\toverrides = {\n\t\t\t\tbeforeShow: function (input, dp_inst) {\n\t\t\t\t\tif ($.isFunction(tp_inst._defaults.evnts.beforeShow)) {\n\t\t\t\t\t\treturn tp_inst._defaults.evnts.beforeShow.call($input[0], input, dp_inst, tp_inst);\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tonChangeMonthYear: function (year, month, dp_inst) {\n\t\t\t\t\t// Update the time as well : this prevents the time from disappearing from the $input field.\n\t\t\t\t\ttp_inst._updateDateTime(dp_inst);\n\t\t\t\t\tif ($.isFunction(tp_inst._defaults.evnts.onChangeMonthYear)) {\n\t\t\t\t\t\ttp_inst._defaults.evnts.onChangeMonthYear.call($input[0], year, month, dp_inst, tp_inst);\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tonClose: function (dateText, dp_inst) {\n\t\t\t\t\tif (tp_inst.timeDefined === true && $input.val() !== '') {\n\t\t\t\t\t\ttp_inst._updateDateTime(dp_inst);\n\t\t\t\t\t}\n\t\t\t\t\tif ($.isFunction(tp_inst._defaults.evnts.onClose)) {\n\t\t\t\t\t\ttp_inst._defaults.evnts.onClose.call($input[0], dateText, dp_inst, tp_inst);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t\tfor (i in overrides) {\n\t\t\t\tif (overrides.hasOwnProperty(i)) {\n\t\t\t\t\tfns[i] = opts[i] || null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\ttp_inst._defaults = $.extend({}, this._defaults, inlineSettings, opts, overrides, {\n\t\t\t\tevnts: fns,\n\t\t\t\ttimepicker: tp_inst // add timepicker as a property of datepicker: $.datepicker._get(dp_inst, 'timepicker');\n\t\t\t});\n\t\t\ttp_inst.amNames = $.map(tp_inst._defaults.amNames, function (val) {\n\t\t\t\treturn val.toUpperCase();\n\t\t\t});\n\t\t\ttp_inst.pmNames = $.map(tp_inst._defaults.pmNames, function (val) {\n\t\t\t\treturn val.toUpperCase();\n\t\t\t});\n\n\t\t\t// detect which units are supported\n\t\t\ttp_inst.support = detectSupport(\n\t\t\t\t\ttp_inst._defaults.timeFormat + \n\t\t\t\t\t(tp_inst._defaults.pickerTimeFormat ? tp_inst._defaults.pickerTimeFormat : '') +\n\t\t\t\t\t(tp_inst._defaults.altTimeFormat ? tp_inst._defaults.altTimeFormat : ''));\n\n\t\t\t// controlType is string - key to our this._controls\n\t\t\tif (typeof(tp_inst._defaults.controlType) === 'string') {\n\t\t\t\tif (tp_inst._defaults.controlType === 'slider' && typeof($.ui.slider) === 'undefined') {\n\t\t\t\t\ttp_inst._defaults.controlType = 'select';\n\t\t\t\t}\n\t\t\t\ttp_inst.control = tp_inst._controls[tp_inst._defaults.controlType];\n\t\t\t}\n\t\t\t// controlType is an object and must implement create, options, value methods\n\t\t\telse {\n\t\t\t\ttp_inst.control = tp_inst._defaults.controlType;\n\t\t\t}\n\n\t\t\t// prep the timezone options\n\t\t\tvar timezoneList = [-720, -660, -600, -570, -540, -480, -420, -360, -300, -270, -240, -210, -180, -120, -60,\n\t\t\t\t\t0, 60, 120, 180, 210, 240, 270, 300, 330, 345, 360, 390, 420, 480, 525, 540, 570, 600, 630, 660, 690, 720, 765, 780, 840];\n\t\t\tif (tp_inst._defaults.timezoneList !== null) {\n\t\t\t\ttimezoneList = tp_inst._defaults.timezoneList;\n\t\t\t}\n\t\t\tvar tzl = timezoneList.length, tzi = 0, tzv = null;\n\t\t\tif (tzl > 0 && typeof timezoneList[0] !== 'object') {\n\t\t\t\tfor (; tzi < tzl; tzi++) {\n\t\t\t\t\ttzv = timezoneList[tzi];\n\t\t\t\t\ttimezoneList[tzi] = { value: tzv, label: $.timepicker.timezoneOffsetString(tzv, tp_inst.support.iso8601) };\n\t\t\t\t}\n\t\t\t}\n\t\t\ttp_inst._defaults.timezoneList = timezoneList;\n\n\t\t\t// set the default units\n\t\t\ttp_inst.timezone = tp_inst._defaults.timezone !== null ? $.timepicker.timezoneOffsetNumber(tp_inst._defaults.timezone) :\n\t\t\t\t\t\t\t((new Date()).getTimezoneOffset() * -1);\n\t\t\ttp_inst.hour = tp_inst._defaults.hour < tp_inst._defaults.hourMin ? tp_inst._defaults.hourMin :\n\t\t\t\t\t\t\ttp_inst._defaults.hour > tp_inst._defaults.hourMax ? tp_inst._defaults.hourMax : tp_inst._defaults.hour;\n\t\t\ttp_inst.minute = tp_inst._defaults.minute < tp_inst._defaults.minuteMin ? tp_inst._defaults.minuteMin :\n\t\t\t\t\t\t\ttp_inst._defaults.minute > tp_inst._defaults.minuteMax ? tp_inst._defaults.minuteMax : tp_inst._defaults.minute;\n\t\t\ttp_inst.second = tp_inst._defaults.second < tp_inst._defaults.secondMin ? tp_inst._defaults.secondMin :\n\t\t\t\t\t\t\ttp_inst._defaults.second > tp_inst._defaults.secondMax ? tp_inst._defaults.secondMax : tp_inst._defaults.second;\n\t\t\ttp_inst.millisec = tp_inst._defaults.millisec < tp_inst._defaults.millisecMin ? tp_inst._defaults.millisecMin :\n\t\t\t\t\t\t\ttp_inst._defaults.millisec > tp_inst._defaults.millisecMax ? tp_inst._defaults.millisecMax : tp_inst._defaults.millisec;\n\t\t\ttp_inst.microsec = tp_inst._defaults.microsec < tp_inst._defaults.microsecMin ? tp_inst._defaults.microsecMin :\n\t\t\t\t\t\t\ttp_inst._defaults.microsec > tp_inst._defaults.microsecMax ? tp_inst._defaults.microsecMax : tp_inst._defaults.microsec;\n\t\t\ttp_inst.ampm = '';\n\t\t\ttp_inst.$input = $input;\n\n\t\t\tif (tp_inst._defaults.altField) {\n\t\t\t\ttp_inst.$altInput = $(tp_inst._defaults.altField).css({\n\t\t\t\t\tcursor: 'pointer'\n\t\t\t\t}).focus(function () {\n\t\t\t\t\t$input.trigger(\"focus\");\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tp_inst._defaults.minDate === 0 || tp_inst._defaults.minDateTime === 0) {\n\t\t\t\ttp_inst._defaults.minDate = new Date();\n\t\t\t}\n\t\t\tif (tp_inst._defaults.maxDate === 0 || tp_inst._defaults.maxDateTime === 0) {\n\t\t\t\ttp_inst._defaults.maxDate = new Date();\n\t\t\t}\n\n\t\t\t// datepicker needs minDate/maxDate, timepicker needs minDateTime/maxDateTime..\n\t\t\tif (tp_inst._defaults.minDate !== undefined && tp_inst._defaults.minDate instanceof Date) {\n\t\t\t\ttp_inst._defaults.minDateTime = new Date(tp_inst._defaults.minDate.getTime());\n\t\t\t}\n\t\t\tif (tp_inst._defaults.minDateTime !== undefined && tp_inst._defaults.minDateTime instanceof Date) {\n\t\t\t\ttp_inst._defaults.minDate = new Date(tp_inst._defaults.minDateTime.getTime());\n\t\t\t}\n\t\t\tif (tp_inst._defaults.maxDate !== undefined && tp_inst._defaults.maxDate instanceof Date) {\n\t\t\t\ttp_inst._defaults.maxDateTime = new Date(tp_inst._defaults.maxDate.getTime());\n\t\t\t}\n\t\t\tif (tp_inst._defaults.maxDateTime !== undefined && tp_inst._defaults.maxDateTime instanceof Date) {\n\t\t\t\ttp_inst._defaults.maxDate = new Date(tp_inst._defaults.maxDateTime.getTime());\n\t\t\t}\n\t\t\ttp_inst.$input.bind('focus', function () {\n\t\t\t\ttp_inst._onFocus();\n\t\t\t});\n\n\t\t\treturn tp_inst;\n\t\t},\n\n\t\t/*\n\t\t* add our sliders to the calendar\n\t\t*/\n\t\t_addTimePicker: function (dp_inst) {\n\t\t\tvar currDT = (this.$altInput && this._defaults.altFieldTimeOnly) ? this.$input.val() + ' ' + this.$altInput.val() : this.$input.val();\n\n\t\t\tthis.timeDefined = this._parseTime(currDT);\n\t\t\tthis._limitMinMaxDateTime(dp_inst, false);\n\t\t\tthis._injectTimePicker();\n\t\t},\n\n\t\t/*\n\t\t* parse the time string from input value or _setTime\n\t\t*/\n\t\t_parseTime: function (timeString, withDate) {\n\t\t\tif (!this.inst) {\n\t\t\t\tthis.inst = $.datepicker._getInst(this.$input[0]);\n\t\t\t}\n\n\t\t\tif (withDate || !this._defaults.timeOnly) {\n\t\t\t\tvar dp_dateFormat = $.datepicker._get(this.inst, 'dateFormat');\n\t\t\t\ttry {\n\t\t\t\t\tvar parseRes = parseDateTimeInternal(dp_dateFormat, this._defaults.timeFormat, timeString, $.datepicker._getFormatConfig(this.inst), this._defaults);\n\t\t\t\t\tif (!parseRes.timeObj) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\t$.extend(this, parseRes.timeObj);\n\t\t\t\t} catch (err) {\n\t\t\t\t\t$.timepicker.log(\"Error parsing the date/time string: \" + err +\n\t\t\t\t\t\t\t\t\t\"\\ndate/time string = \" + timeString +\n\t\t\t\t\t\t\t\t\t\"\\ntimeFormat = \" + this._defaults.timeFormat +\n\t\t\t\t\t\t\t\t\t\"\\ndateFormat = \" + dp_dateFormat);\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t} else {\n\t\t\t\tvar timeObj = $.datepicker.parseTime(this._defaults.timeFormat, timeString, this._defaults);\n\t\t\t\tif (!timeObj) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\t$.extend(this, timeObj);\n\t\t\t\treturn true;\n\t\t\t}\n\t\t},\n\n\t\t/*\n\t\t* generate and inject html for timepicker into ui datepicker\n\t\t*/\n\t\t_injectTimePicker: function () {\n\t\t\tvar $dp = this.inst.dpDiv,\n\t\t\t\to = this.inst.settings,\n\t\t\t\ttp_inst = this,\n\t\t\t\tlitem = '',\n\t\t\t\tuitem = '',\n\t\t\t\tshow = null,\n\t\t\t\tmax = {},\n\t\t\t\tgridSize = {},\n\t\t\t\tsize = null,\n\t\t\t\ti = 0,\n\t\t\t\tl = 0;\n\n\t\t\t// Prevent displaying twice\n\t\t\tif ($dp.find(\"div.ui-timepicker-div\").length === 0 && o.showTimepicker) {\n\t\t\t\tvar noDisplay = ' style=\"display:none;\"',\n\t\t\t\t\thtml = '<div class=\"ui-timepicker-div' + (o.isRTL ? ' ui-timepicker-rtl' : '') + '\"><dl>' + '<dt class=\"ui_tpicker_time_label\"' + ((o.showTime) ? '' : noDisplay) + '>' + o.timeText + '</dt>' +\n\t\t\t\t\t\t\t\t'<dd class=\"ui_tpicker_time\"' + ((o.showTime) ? '' : noDisplay) + '></dd>';\n\n\t\t\t\t// Create the markup\n\t\t\t\tfor (i = 0, l = this.units.length; i < l; i++) {\n\t\t\t\t\tlitem = this.units[i];\n\t\t\t\t\tuitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n\t\t\t\t\tshow = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n\t\t\t\t\t// Added by Peter Medeiros:\n\t\t\t\t\t// - Figure out what the hour/minute/second max should be based on the step values.\n\t\t\t\t\t// - Example: if stepMinute is 15, then minMax is 45.\n\t\t\t\t\tmax[litem] = parseInt((o[litem + 'Max'] - ((o[litem + 'Max'] - o[litem + 'Min']) % o['step' + uitem])), 10);\n\t\t\t\t\tgridSize[litem] = 0;\n\n\t\t\t\t\thtml += '<dt class=\"ui_tpicker_' + litem + '_label\"' + (show ? '' : noDisplay) + '>' + o[litem + 'Text'] + '</dt>' +\n\t\t\t\t\t\t\t\t'<dd class=\"ui_tpicker_' + litem + '\"><div class=\"ui_tpicker_' + litem + '_slider\"' + (show ? '' : noDisplay) + '></div>';\n\n\t\t\t\t\tif (show && o[litem + 'Grid'] > 0) {\n\t\t\t\t\t\thtml += '<div style=\"padding-left: 1px\"><table class=\"ui-tpicker-grid-label\"><tr>';\n\n\t\t\t\t\t\tif (litem === 'hour') {\n\t\t\t\t\t\t\tfor (var h = o[litem + 'Min']; h <= max[litem]; h += parseInt(o[litem + 'Grid'], 10)) {\n\t\t\t\t\t\t\t\tgridSize[litem]++;\n\t\t\t\t\t\t\t\tvar tmph = $.datepicker.formatTime(this.support.ampm ? 'hht' : 'HH', {hour: h}, o);\n\t\t\t\t\t\t\t\thtml += '<td data-for=\"' + litem + '\">' + tmph + '</td>';\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tfor (var m = o[litem + 'Min']; m <= max[litem]; m += parseInt(o[litem + 'Grid'], 10)) {\n\t\t\t\t\t\t\t\tgridSize[litem]++;\n\t\t\t\t\t\t\t\thtml += '<td data-for=\"' + litem + '\">' + ((m < 10) ? '0' : '') + m + '</td>';\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\thtml += '</tr></table></div>';\n\t\t\t\t\t}\n\t\t\t\t\thtml += '</dd>';\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t// Timezone\n\t\t\t\tvar showTz = o.showTimezone !== null ? o.showTimezone : this.support.timezone;\n\t\t\t\thtml += '<dt class=\"ui_tpicker_timezone_label\"' + (showTz ? '' : noDisplay) + '>' + o.timezoneText + '</dt>';\n\t\t\t\thtml += '<dd class=\"ui_tpicker_timezone\" ' + (showTz ? '' : noDisplay) + '></dd>';\n\n\t\t\t\t// Create the elements from string\n\t\t\t\thtml += '</dl></div>';\n\t\t\t\tvar $tp = $(html);\n\n\t\t\t\t// if we only want time picker...\n\t\t\t\tif (o.timeOnly === true) {\n\t\t\t\t\t$tp.prepend('<div class=\"ui-widget-header ui-helper-clearfix ui-corner-all\">' + '<div class=\"ui-datepicker-title\">' + o.timeOnlyTitle + '</div>' + '</div>');\n\t\t\t\t\t$dp.find('.ui-datepicker-header, .ui-datepicker-calendar').hide();\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t// add sliders, adjust grids, add events\n\t\t\t\tfor (i = 0, l = tp_inst.units.length; i < l; i++) {\n\t\t\t\t\tlitem = tp_inst.units[i];\n\t\t\t\t\tuitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n\t\t\t\t\tshow = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n\t\t\t\t\t// add the slider\n\t\t\t\t\ttp_inst[litem + '_slider'] = tp_inst.control.create(tp_inst, $tp.find('.ui_tpicker_' + litem + '_slider'), litem, tp_inst[litem], o[litem + 'Min'], max[litem], o['step' + uitem]);\n\n\t\t\t\t\t// adjust the grid and add click event\n\t\t\t\t\tif (show && o[litem + 'Grid'] > 0) {\n\t\t\t\t\t\tsize = 100 * gridSize[litem] * o[litem + 'Grid'] / (max[litem] - o[litem + 'Min']);\n\t\t\t\t\t\t$tp.find('.ui_tpicker_' + litem + ' table').css({\n\t\t\t\t\t\t\twidth: size + \"%\",\n\t\t\t\t\t\t\tmarginLeft: o.isRTL ? '0' : ((size / (-2 * gridSize[litem])) + \"%\"),\n\t\t\t\t\t\t\tmarginRight: o.isRTL ? ((size / (-2 * gridSize[litem])) + \"%\") : '0',\n\t\t\t\t\t\t\tborderCollapse: 'collapse'\n\t\t\t\t\t\t}).find(\"td\").click(function (e) {\n\t\t\t\t\t\t\t\tvar $t = $(this),\n\t\t\t\t\t\t\t\t\th = $t.html(),\n\t\t\t\t\t\t\t\t\tn = parseInt(h.replace(/[^0-9]/g), 10),\n\t\t\t\t\t\t\t\t\tap = h.replace(/[^apm]/ig),\n\t\t\t\t\t\t\t\t\tf = $t.data('for'); // loses scope, so we use data-for\n\n\t\t\t\t\t\t\t\tif (f === 'hour') {\n\t\t\t\t\t\t\t\t\tif (ap.indexOf('p') !== -1 && n < 12) {\n\t\t\t\t\t\t\t\t\t\tn += 12;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\tif (ap.indexOf('a') !== -1 && n === 12) {\n\t\t\t\t\t\t\t\t\t\t\tn = 0;\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\ttp_inst.control.value(tp_inst, tp_inst[f + '_slider'], litem, n);\n\n\t\t\t\t\t\t\t\ttp_inst._onTimeChange();\n\t\t\t\t\t\t\t\ttp_inst._onSelectHandler();\n\t\t\t\t\t\t\t}).css({\n\t\t\t\t\t\t\t\tcursor: 'pointer',\n\t\t\t\t\t\t\t\twidth: (100 / gridSize[litem]) + '%',\n\t\t\t\t\t\t\t\ttextAlign: 'center',\n\t\t\t\t\t\t\t\toverflow: 'hidden'\n\t\t\t\t\t\t\t});\n\t\t\t\t\t} // end if grid > 0\n\t\t\t\t} // end for loop\n\n\t\t\t\t// Add timezone options\n\t\t\t\tthis.timezone_select = $tp.find('.ui_tpicker_timezone').append('<select></select>').find(\"select\");\n\t\t\t\t$.fn.append.apply(this.timezone_select,\n\t\t\t\t$.map(o.timezoneList, function (val, idx) {\n\t\t\t\t\treturn $(\"<option />\").val(typeof val === \"object\" ? val.value : val).text(typeof val === \"object\" ? val.label : val);\n\t\t\t\t}));\n\t\t\t\tif (typeof(this.timezone) !== \"undefined\" && this.timezone !== null && this.timezone !== \"\") {\n\t\t\t\t\tvar local_timezone = (new Date(this.inst.selectedYear, this.inst.selectedMonth, this.inst.selectedDay, 12)).getTimezoneOffset() * -1;\n\t\t\t\t\tif (local_timezone === this.timezone) {\n\t\t\t\t\t\tselectLocalTimezone(tp_inst);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis.timezone_select.val(this.timezone);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (typeof(this.hour) !== \"undefined\" && this.hour !== null && this.hour !== \"\") {\n\t\t\t\t\t\tthis.timezone_select.val(o.timezone);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tselectLocalTimezone(tp_inst);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tthis.timezone_select.change(function () {\n\t\t\t\t\ttp_inst._onTimeChange();\n\t\t\t\t\ttp_inst._onSelectHandler();\n\t\t\t\t});\n\t\t\t\t// End timezone options\n\t\t\t\t\n\t\t\t\t// inject timepicker into datepicker\n\t\t\t\tvar $buttonPanel = $dp.find('.ui-datepicker-buttonpane');\n\t\t\t\tif ($buttonPanel.length) {\n\t\t\t\t\t$buttonPanel.before($tp);\n\t\t\t\t} else {\n\t\t\t\t\t$dp.append($tp);\n\t\t\t\t}\n\n\t\t\t\tthis.$timeObj = $tp.find('.ui_tpicker_time');\n\n\t\t\t\tif (this.inst !== null) {\n\t\t\t\t\tvar timeDefined = this.timeDefined;\n\t\t\t\t\tthis._onTimeChange();\n\t\t\t\t\tthis.timeDefined = timeDefined;\n\t\t\t\t}\n\n\t\t\t\t// slideAccess integration: http://trentrichardson.com/2011/11/11/jquery-ui-sliders-and-touch-accessibility/\n\t\t\t\tif (this._defaults.addSliderAccess) {\n\t\t\t\t\tvar sliderAccessArgs = this._defaults.sliderAccessArgs,\n\t\t\t\t\t\trtl = this._defaults.isRTL;\n\t\t\t\t\tsliderAccessArgs.isRTL = rtl;\n\t\t\t\t\t\t\n\t\t\t\t\tsetTimeout(function () { // fix for inline mode\n\t\t\t\t\t\tif ($tp.find('.ui-slider-access').length === 0) {\n\t\t\t\t\t\t\t$tp.find('.ui-slider:visible').sliderAccess(sliderAccessArgs);\n\n\t\t\t\t\t\t\t// fix any grids since sliders are shorter\n\t\t\t\t\t\t\tvar sliderAccessWidth = $tp.find('.ui-slider-access:eq(0)').outerWidth(true);\n\t\t\t\t\t\t\tif (sliderAccessWidth) {\n\t\t\t\t\t\t\t\t$tp.find('table:visible').each(function () {\n\t\t\t\t\t\t\t\t\tvar $g = $(this),\n\t\t\t\t\t\t\t\t\t\toldWidth = $g.outerWidth(),\n\t\t\t\t\t\t\t\t\t\toldMarginLeft = $g.css(rtl ? 'marginRight' : 'marginLeft').toString().replace('%', ''),\n\t\t\t\t\t\t\t\t\t\tnewWidth = oldWidth - sliderAccessWidth,\n\t\t\t\t\t\t\t\t\t\tnewMarginLeft = ((oldMarginLeft * newWidth) / oldWidth) + '%',\n\t\t\t\t\t\t\t\t\t\tcss = { width: newWidth, marginRight: 0, marginLeft: 0 };\n\t\t\t\t\t\t\t\t\tcss[rtl ? 'marginRight' : 'marginLeft'] = newMarginLeft;\n\t\t\t\t\t\t\t\t\t$g.css(css);\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, 10);\n\t\t\t\t}\n\t\t\t\t// end slideAccess integration\n\n\t\t\t\ttp_inst._limitMinMaxDateTime(this.inst, true);\n\t\t\t}\n\t\t},\n\n\t\t/*\n\t\t* This function tries to limit the ability to go outside the\n\t\t* min/max date range\n\t\t*/\n\t\t_limitMinMaxDateTime: function (dp_inst, adjustSliders) {\n\t\t\tvar o = this._defaults,\n\t\t\t\tdp_date = new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay);\n\n\t\t\tif (!this._defaults.showTimepicker) {\n\t\t\t\treturn;\n\t\t\t} // No time so nothing to check here\n\n\t\t\tif ($.datepicker._get(dp_inst, 'minDateTime') !== null && $.datepicker._get(dp_inst, 'minDateTime') !== undefined && dp_date) {\n\t\t\t\tvar minDateTime = $.datepicker._get(dp_inst, 'minDateTime'),\n\t\t\t\t\tminDateTimeDate = new Date(minDateTime.getFullYear(), minDateTime.getMonth(), minDateTime.getDate(), 0, 0, 0, 0);\n\n\t\t\t\tif (this.hourMinOriginal === null || this.minuteMinOriginal === null || this.secondMinOriginal === null || this.millisecMinOriginal === null || this.microsecMinOriginal === null) {\n\t\t\t\t\tthis.hourMinOriginal = o.hourMin;\n\t\t\t\t\tthis.minuteMinOriginal = o.minuteMin;\n\t\t\t\t\tthis.secondMinOriginal = o.secondMin;\n\t\t\t\t\tthis.millisecMinOriginal = o.millisecMin;\n\t\t\t\t\tthis.microsecMinOriginal = o.microsecMin;\n\t\t\t\t}\n\n\t\t\t\tif (dp_inst.settings.timeOnly || minDateTimeDate.getTime() === dp_date.getTime()) {\n\t\t\t\t\tthis._defaults.hourMin = minDateTime.getHours();\n\t\t\t\t\tif (this.hour <= this._defaults.hourMin) {\n\t\t\t\t\t\tthis.hour = this._defaults.hourMin;\n\t\t\t\t\t\tthis._defaults.minuteMin = minDateTime.getMinutes();\n\t\t\t\t\t\tif (this.minute <= this._defaults.minuteMin) {\n\t\t\t\t\t\t\tthis.minute = this._defaults.minuteMin;\n\t\t\t\t\t\t\tthis._defaults.secondMin = minDateTime.getSeconds();\n\t\t\t\t\t\t\tif (this.second <= this._defaults.secondMin) {\n\t\t\t\t\t\t\t\tthis.second = this._defaults.secondMin;\n\t\t\t\t\t\t\t\tthis._defaults.millisecMin = minDateTime.getMilliseconds();\n\t\t\t\t\t\t\t\tif (this.millisec <= this._defaults.millisecMin) {\n\t\t\t\t\t\t\t\t\tthis.millisec = this._defaults.millisecMin;\n\t\t\t\t\t\t\t\t\tthis._defaults.microsecMin = minDateTime.getMicroseconds();\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tif (this.microsec < this._defaults.microsecMin) {\n\t\t\t\t\t\t\t\t\t\tthis.microsec = this._defaults.microsecMin;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tthis._defaults.microsecMin = this.microsecMinOriginal;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tthis._defaults.millisecMin = this.millisecMinOriginal;\n\t\t\t\t\t\t\t\tthis._defaults.microsecMin = this.microsecMinOriginal;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tthis._defaults.secondMin = this.secondMinOriginal;\n\t\t\t\t\t\t\tthis._defaults.millisecMin = this.millisecMinOriginal;\n\t\t\t\t\t\t\tthis._defaults.microsecMin = this.microsecMinOriginal;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis._defaults.minuteMin = this.minuteMinOriginal;\n\t\t\t\t\t\tthis._defaults.secondMin = this.secondMinOriginal;\n\t\t\t\t\t\tthis._defaults.millisecMin = this.millisecMinOriginal;\n\t\t\t\t\t\tthis._defaults.microsecMin = this.microsecMinOriginal;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tthis._defaults.hourMin = this.hourMinOriginal;\n\t\t\t\t\tthis._defaults.minuteMin = this.minuteMinOriginal;\n\t\t\t\t\tthis._defaults.secondMin = this.secondMinOriginal;\n\t\t\t\t\tthis._defaults.millisecMin = this.millisecMinOriginal;\n\t\t\t\t\tthis._defaults.microsecMin = this.microsecMinOriginal;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ($.datepicker._get(dp_inst, 'maxDateTime') !== null && $.datepicker._get(dp_inst, 'maxDateTime') !== undefined && dp_date) {\n\t\t\t\tvar maxDateTime = $.datepicker._get(dp_inst, 'maxDateTime'),\n\t\t\t\t\tmaxDateTimeDate = new Date(maxDateTime.getFullYear(), maxDateTime.getMonth(), maxDateTime.getDate(), 0, 0, 0, 0);\n\n\t\t\t\tif (this.hourMaxOriginal === null || this.minuteMaxOriginal === null || this.secondMaxOriginal === null || this.millisecMaxOriginal === null) {\n\t\t\t\t\tthis.hourMaxOriginal = o.hourMax;\n\t\t\t\t\tthis.minuteMaxOriginal = o.minuteMax;\n\t\t\t\t\tthis.secondMaxOriginal = o.secondMax;\n\t\t\t\t\tthis.millisecMaxOriginal = o.millisecMax;\n\t\t\t\t\tthis.microsecMaxOriginal = o.microsecMax;\n\t\t\t\t}\n\n\t\t\t\tif (dp_inst.settings.timeOnly || maxDateTimeDate.getTime() === dp_date.getTime()) {\n\t\t\t\t\tthis._defaults.hourMax = maxDateTime.getHours();\n\t\t\t\t\tif (this.hour >= this._defaults.hourMax) {\n\t\t\t\t\t\tthis.hour = this._defaults.hourMax;\n\t\t\t\t\t\tthis._defaults.minuteMax = maxDateTime.getMinutes();\n\t\t\t\t\t\tif (this.minute >= this._defaults.minuteMax) {\n\t\t\t\t\t\t\tthis.minute = this._defaults.minuteMax;\n\t\t\t\t\t\t\tthis._defaults.secondMax = maxDateTime.getSeconds();\n\t\t\t\t\t\t\tif (this.second >= this._defaults.secondMax) {\n\t\t\t\t\t\t\t\tthis.second = this._defaults.secondMax;\n\t\t\t\t\t\t\t\tthis._defaults.millisecMax = maxDateTime.getMilliseconds();\n\t\t\t\t\t\t\t\tif (this.millisec >= this._defaults.millisecMax) {\n\t\t\t\t\t\t\t\t\tthis.millisec = this._defaults.millisecMax;\n\t\t\t\t\t\t\t\t\tthis._defaults.microsecMax = maxDateTime.getMicroseconds();\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tif (this.microsec > this._defaults.microsecMax) {\n\t\t\t\t\t\t\t\t\t\tthis.microsec = this._defaults.microsecMax;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tthis._defaults.microsecMax = this.microsecMaxOriginal;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tthis._defaults.millisecMax = this.millisecMaxOriginal;\n\t\t\t\t\t\t\t\tthis._defaults.microsecMax = this.microsecMaxOriginal;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tthis._defaults.secondMax = this.secondMaxOriginal;\n\t\t\t\t\t\t\tthis._defaults.millisecMax = this.millisecMaxOriginal;\n\t\t\t\t\t\t\tthis._defaults.microsecMax = this.microsecMaxOriginal;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis._defaults.minuteMax = this.minuteMaxOriginal;\n\t\t\t\t\t\tthis._defaults.secondMax = this.secondMaxOriginal;\n\t\t\t\t\t\tthis._defaults.millisecMax = this.millisecMaxOriginal;\n\t\t\t\t\t\tthis._defaults.microsecMax = this.microsecMaxOriginal;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tthis._defaults.hourMax = this.hourMaxOriginal;\n\t\t\t\t\tthis._defaults.minuteMax = this.minuteMaxOriginal;\n\t\t\t\t\tthis._defaults.secondMax = this.secondMaxOriginal;\n\t\t\t\t\tthis._defaults.millisecMax = this.millisecMaxOriginal;\n\t\t\t\t\tthis._defaults.microsecMax = this.microsecMaxOriginal;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (adjustSliders !== undefined && adjustSliders === true) {\n\t\t\t\tvar hourMax = parseInt((this._defaults.hourMax - ((this._defaults.hourMax - this._defaults.hourMin) % this._defaults.stepHour)), 10),\n\t\t\t\t\tminMax = parseInt((this._defaults.minuteMax - ((this._defaults.minuteMax - this._defaults.minuteMin) % this._defaults.stepMinute)), 10),\n\t\t\t\t\tsecMax = parseInt((this._defaults.secondMax - ((this._defaults.secondMax - this._defaults.secondMin) % this._defaults.stepSecond)), 10),\n\t\t\t\t\tmillisecMax = parseInt((this._defaults.millisecMax - ((this._defaults.millisecMax - this._defaults.millisecMin) % this._defaults.stepMillisec)), 10),\n\t\t\t\t\tmicrosecMax = parseInt((this._defaults.microsecMax - ((this._defaults.microsecMax - this._defaults.microsecMin) % this._defaults.stepMicrosec)), 10);\n\n\t\t\t\tif (this.hour_slider) {\n\t\t\t\t\tthis.control.options(this, this.hour_slider, 'hour', { min: this._defaults.hourMin, max: hourMax });\n\t\t\t\t\tthis.control.value(this, this.hour_slider, 'hour', this.hour - (this.hour % this._defaults.stepHour));\n\t\t\t\t}\n\t\t\t\tif (this.minute_slider) {\n\t\t\t\t\tthis.control.options(this, this.minute_slider, 'minute', { min: this._defaults.minuteMin, max: minMax });\n\t\t\t\t\tthis.control.value(this, this.minute_slider, 'minute', this.minute - (this.minute % this._defaults.stepMinute));\n\t\t\t\t}\n\t\t\t\tif (this.second_slider) {\n\t\t\t\t\tthis.control.options(this, this.second_slider, 'second', { min: this._defaults.secondMin, max: secMax });\n\t\t\t\t\tthis.control.value(this, this.second_slider, 'second', this.second - (this.second % this._defaults.stepSecond));\n\t\t\t\t}\n\t\t\t\tif (this.millisec_slider) {\n\t\t\t\t\tthis.control.options(this, this.millisec_slider, 'millisec', { min: this._defaults.millisecMin, max: millisecMax });\n\t\t\t\t\tthis.control.value(this, this.millisec_slider, 'millisec', this.millisec - (this.millisec % this._defaults.stepMillisec));\n\t\t\t\t}\n\t\t\t\tif (this.microsec_slider) {\n\t\t\t\t\tthis.control.options(this, this.microsec_slider, 'microsec', { min: this._defaults.microsecMin, max: microsecMax });\n\t\t\t\t\tthis.control.value(this, this.microsec_slider, 'microsec', this.microsec - (this.microsec % this._defaults.stepMicrosec));\n\t\t\t\t}\n\t\t\t}\n\n\t\t},\n\n\t\t/*\n\t\t* when a slider moves, set the internal time...\n\t\t* on time change is also called when the time is updated in the text field\n\t\t*/\n\t\t_onTimeChange: function () {\n\t\t\tif (!this._defaults.showTimepicker) {\n                                return;\n\t\t\t}\n\t\t\tvar hour = (this.hour_slider) ? this.control.value(this, this.hour_slider, 'hour') : false,\n\t\t\t\tminute = (this.minute_slider) ? this.control.value(this, this.minute_slider, 'minute') : false,\n\t\t\t\tsecond = (this.second_slider) ? this.control.value(this, this.second_slider, 'second') : false,\n\t\t\t\tmillisec = (this.millisec_slider) ? this.control.value(this, this.millisec_slider, 'millisec') : false,\n\t\t\t\tmicrosec = (this.microsec_slider) ? this.control.value(this, this.microsec_slider, 'microsec') : false,\n\t\t\t\ttimezone = (this.timezone_select) ? this.timezone_select.val() : false,\n\t\t\t\to = this._defaults,\n\t\t\t\tpickerTimeFormat = o.pickerTimeFormat || o.timeFormat,\n\t\t\t\tpickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;\n\n\t\t\tif (typeof(hour) === 'object') {\n\t\t\t\thour = false;\n\t\t\t}\n\t\t\tif (typeof(minute) === 'object') {\n\t\t\t\tminute = false;\n\t\t\t}\n\t\t\tif (typeof(second) === 'object') {\n\t\t\t\tsecond = false;\n\t\t\t}\n\t\t\tif (typeof(millisec) === 'object') {\n\t\t\t\tmillisec = false;\n\t\t\t}\n\t\t\tif (typeof(microsec) === 'object') {\n\t\t\t\tmicrosec = false;\n\t\t\t}\n\t\t\tif (typeof(timezone) === 'object') {\n\t\t\t\ttimezone = false;\n\t\t\t}\n\n\t\t\tif (hour !== false) {\n\t\t\t\thour = parseInt(hour, 10);\n\t\t\t}\n\t\t\tif (minute !== false) {\n\t\t\t\tminute = parseInt(minute, 10);\n\t\t\t}\n\t\t\tif (second !== false) {\n\t\t\t\tsecond = parseInt(second, 10);\n\t\t\t}\n\t\t\tif (millisec !== false) {\n\t\t\t\tmillisec = parseInt(millisec, 10);\n\t\t\t}\n\t\t\tif (microsec !== false) {\n\t\t\t\tmicrosec = parseInt(microsec, 10);\n\t\t\t}\n\t\t\tif (timezone !== false) {\n\t\t\t\ttimezone = timezone.toString();\n\t\t\t}\n\n\t\t\tvar ampm = o[hour < 12 ? 'amNames' : 'pmNames'][0];\n\n\t\t\t// If the update was done in the input field, the input field should not be updated.\n\t\t\t// If the update was done using the sliders, update the input field.\n\t\t\tvar hasChanged = (\n\t\t\t\t\t\thour !== parseInt(this.hour,10) || // sliders should all be numeric\n\t\t\t\t\t\tminute !== parseInt(this.minute,10) || \n\t\t\t\t\t\tsecond !== parseInt(this.second,10) || \n\t\t\t\t\t\tmillisec !== parseInt(this.millisec,10) || \n\t\t\t\t\t\tmicrosec !== parseInt(this.microsec,10) || \n\t\t\t\t\t\t(this.ampm.length > 0 && (hour < 12) !== ($.inArray(this.ampm.toUpperCase(), this.amNames) !== -1)) || \n\t\t\t\t\t\t(this.timezone !== null && timezone !== this.timezone.toString()) // could be numeric or \"EST\" format, so use toString()\n\t\t\t\t\t);\n\n\t\t\tif (hasChanged) {\n\n\t\t\t\tif (hour !== false) {\n\t\t\t\t\tthis.hour = hour;\n\t\t\t\t}\n\t\t\t\tif (minute !== false) {\n\t\t\t\t\tthis.minute = minute;\n\t\t\t\t}\n\t\t\t\tif (second !== false) {\n\t\t\t\t\tthis.second = second;\n\t\t\t\t}\n\t\t\t\tif (millisec !== false) {\n\t\t\t\t\tthis.millisec = millisec;\n\t\t\t\t}\n\t\t\t\tif (microsec !== false) {\n\t\t\t\t\tthis.microsec = microsec;\n\t\t\t\t}\n\t\t\t\tif (timezone !== false) {\n\t\t\t\t\tthis.timezone = timezone;\n\t\t\t\t}\n\n\t\t\t\tif (!this.inst) {\n\t\t\t\t\tthis.inst = $.datepicker._getInst(this.$input[0]);\n\t\t\t\t}\n\n\t\t\t\tthis._limitMinMaxDateTime(this.inst, true);\n\t\t\t}\n\t\t\tif (this.support.ampm) {\n\t\t\t\tthis.ampm = ampm;\n\t\t\t}\n\n\t\t\t// Updates the time within the timepicker\n\t\t\tthis.formattedTime = $.datepicker.formatTime(o.timeFormat, this, o);\n\t\t\tif (this.$timeObj) {\n\t\t\t\tif (pickerTimeFormat === o.timeFormat) {\n\t\t\t\t\tthis.$timeObj.text(this.formattedTime + pickerTimeSuffix);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.$timeObj.text($.datepicker.formatTime(pickerTimeFormat, this, o) + pickerTimeSuffix);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis.timeDefined = true;\n\t\t\tif (hasChanged) {\n\t\t\t\tthis._updateDateTime();\n\t\t\t\tthis.$input.focus();\n\t\t\t}\n\t\t},\n\n\t\t/*\n\t\t* call custom onSelect.\n\t\t* bind to sliders slidestop, and grid click.\n\t\t*/\n\t\t_onSelectHandler: function () {\n\t\t\tvar onSelect = this._defaults.onSelect || this.inst.settings.onSelect;\n\t\t\tvar inputEl = this.$input ? this.$input[0] : null;\n\t\t\tif (onSelect && inputEl) {\n\t\t\t\tonSelect.apply(inputEl, [this.formattedDateTime, this]);\n\t\t\t}\n\t\t},\n\n\t\t/*\n\t\t* update our input with the new date time..\n\t\t*/\n\t\t_updateDateTime: function (dp_inst) {\n\t\t\tdp_inst = this.inst || dp_inst;\n\t\t\tvar dtTmp = (dp_inst.currentYear > 0? \n\t\t\t\t\t\t\tnew Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay) : \n\t\t\t\t\t\t\tnew Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n\t\t\t\tdt = $.datepicker._daylightSavingAdjust(dtTmp),\n\t\t\t\t//dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n\t\t\t\t//dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay)),\n\t\t\t\tdateFmt = $.datepicker._get(dp_inst, 'dateFormat'),\n\t\t\t\tformatCfg = $.datepicker._getFormatConfig(dp_inst),\n\t\t\t\ttimeAvailable = dt !== null && this.timeDefined;\n\t\t\tthis.formattedDate = $.datepicker.formatDate(dateFmt, (dt === null ? new Date() : dt), formatCfg);\n\t\t\tvar formattedDateTime = this.formattedDate;\n\t\t\t\n\t\t\t// if a slider was changed but datepicker doesn't have a value yet, set it\n\t\t\tif (dp_inst.lastVal === \"\") {\n                dp_inst.currentYear = dp_inst.selectedYear;\n                dp_inst.currentMonth = dp_inst.selectedMonth;\n                dp_inst.currentDay = dp_inst.selectedDay;\n            }\n\n\t\t\t/*\n\t\t\t* remove following lines to force every changes in date picker to change the input value\n\t\t\t* Bug descriptions: when an input field has a default value, and click on the field to pop up the date picker. \n\t\t\t* If the user manually empty the value in the input field, the date picker will never change selected value.\n\t\t\t*/\n\t\t\t//if (dp_inst.lastVal !== undefined && (dp_inst.lastVal.length > 0 && this.$input.val().length === 0)) {\n\t\t\t//\treturn;\n\t\t\t//}\n\n\t\t\tif (this._defaults.timeOnly === true) {\n\t\t\t\tformattedDateTime = this.formattedTime;\n\t\t\t} else if (this._defaults.timeOnly !== true && (this._defaults.alwaysSetTime || timeAvailable)) {\n\t\t\t\tformattedDateTime += this._defaults.separator + this.formattedTime + this._defaults.timeSuffix;\n\t\t\t}\n\n\t\t\tthis.formattedDateTime = formattedDateTime;\n\n\t\t\tif (!this._defaults.showTimepicker) {\n\t\t\t\tthis.$input.val(this.formattedDate);\n\t\t\t} else if (this.$altInput && this._defaults.timeOnly === false && this._defaults.altFieldTimeOnly === true) {\n\t\t\t\tthis.$altInput.val(this.formattedTime);\n\t\t\t\tthis.$input.val(this.formattedDate);\n\t\t\t} else if (this.$altInput) {\n\t\t\t\tthis.$input.val(formattedDateTime);\n\t\t\t\tvar altFormattedDateTime = '',\n\t\t\t\t\taltSeparator = this._defaults.altSeparator ? this._defaults.altSeparator : this._defaults.separator,\n\t\t\t\t\taltTimeSuffix = this._defaults.altTimeSuffix ? this._defaults.altTimeSuffix : this._defaults.timeSuffix;\n\t\t\t\t\n\t\t\t\tif (!this._defaults.timeOnly) {\n\t\t\t\t\tif (this._defaults.altFormat) {\n\t\t\t\t\t\taltFormattedDateTime = $.datepicker.formatDate(this._defaults.altFormat, (dt === null ? new Date() : dt), formatCfg);\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\taltFormattedDateTime = this.formattedDate;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (altFormattedDateTime) {\n\t\t\t\t\t\taltFormattedDateTime += altSeparator;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (this._defaults.altTimeFormat) {\n\t\t\t\t\taltFormattedDateTime += $.datepicker.formatTime(this._defaults.altTimeFormat, this, this._defaults) + altTimeSuffix;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\taltFormattedDateTime += this.formattedTime + altTimeSuffix;\n\t\t\t\t}\n\t\t\t\tthis.$altInput.val(altFormattedDateTime);\n\t\t\t} else {\n\t\t\t\tthis.$input.val(formattedDateTime);\n\t\t\t}\n\n\t\t\tthis.$input.trigger(\"change\");\n\t\t},\n\n\t\t_onFocus: function () {\n\t\t\tif (!this.$input.val() && this._defaults.defaultValue) {\n\t\t\t\tthis.$input.val(this._defaults.defaultValue);\n\t\t\t\tvar inst = $.datepicker._getInst(this.$input.get(0)),\n\t\t\t\t\ttp_inst = $.datepicker._get(inst, 'timepicker');\n\t\t\t\tif (tp_inst) {\n\t\t\t\t\tif (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t$.datepicker._updateDatepicker(inst);\n\t\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t\t$.timepicker.log(err);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/*\n\t\t* Small abstraction to control types\n\t\t* We can add more, just be sure to follow the pattern: create, options, value\n\t\t*/\n\t\t_controls: {\n\t\t\t// slider methods\n\t\t\tslider: {\n\t\t\t\tcreate: function (tp_inst, obj, unit, val, min, max, step) {\n\t\t\t\t\tvar rtl = tp_inst._defaults.isRTL; // if rtl go -60->0 instead of 0->60\n\t\t\t\t\treturn obj.prop('slide', null).slider({\n\t\t\t\t\t\torientation: \"horizontal\",\n\t\t\t\t\t\tvalue: rtl ? val * -1 : val,\n\t\t\t\t\t\tmin: rtl ? max * -1 : min,\n\t\t\t\t\t\tmax: rtl ? min * -1 : max,\n\t\t\t\t\t\tstep: step,\n\t\t\t\t\t\tslide: function (event, ui) {\n\t\t\t\t\t\t\ttp_inst.control.value(tp_inst, $(this), unit, rtl ? ui.value * -1 : ui.value);\n\t\t\t\t\t\t\ttp_inst._onTimeChange();\n\t\t\t\t\t\t},\n\t\t\t\t\t\tstop: function (event, ui) {\n\t\t\t\t\t\t\ttp_inst._onSelectHandler();\n\t\t\t\t\t\t}\n\t\t\t\t\t});\t\n\t\t\t\t},\n\t\t\t\toptions: function (tp_inst, obj, unit, opts, val) {\n\t\t\t\t\tif (tp_inst._defaults.isRTL) {\n\t\t\t\t\t\tif (typeof(opts) === 'string') {\n\t\t\t\t\t\t\tif (opts === 'min' || opts === 'max') {\n\t\t\t\t\t\t\t\tif (val !== undefined) {\n\t\t\t\t\t\t\t\t\treturn obj.slider(opts, val * -1);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\treturn Math.abs(obj.slider(opts));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn obj.slider(opts);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tvar min = opts.min, \n\t\t\t\t\t\t\tmax = opts.max;\n\t\t\t\t\t\topts.min = opts.max = null;\n\t\t\t\t\t\tif (min !== undefined) {\n\t\t\t\t\t\t\topts.max = min * -1;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (max !== undefined) {\n\t\t\t\t\t\t\topts.min = max * -1;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn obj.slider(opts);\n\t\t\t\t\t}\n\t\t\t\t\tif (typeof(opts) === 'string' && val !== undefined) {\n\t\t\t\t\t\treturn obj.slider(opts, val);\n\t\t\t\t\t}\n\t\t\t\t\treturn obj.slider(opts);\n\t\t\t\t},\n\t\t\t\tvalue: function (tp_inst, obj, unit, val) {\n\t\t\t\t\tif (tp_inst._defaults.isRTL) {\n\t\t\t\t\t\tif (val !== undefined) {\n\t\t\t\t\t\t\treturn obj.slider('value', val * -1);\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn Math.abs(obj.slider('value'));\n\t\t\t\t\t}\n\t\t\t\t\tif (val !== undefined) {\n\t\t\t\t\t\treturn obj.slider('value', val);\n\t\t\t\t\t}\n\t\t\t\t\treturn obj.slider('value');\n\t\t\t\t}\n\t\t\t},\n\t\t\t// select methods\n\t\t\tselect: {\n\t\t\t\tcreate: function (tp_inst, obj, unit, val, min, max, step) {\n\t\t\t\t\tvar sel = '<select class=\"ui-timepicker-select\" data-unit=\"' + unit + '\" data-min=\"' + min + '\" data-max=\"' + max + '\" data-step=\"' + step + '\">',\n\t\t\t\t\t\tformat = tp_inst._defaults.pickerTimeFormat || tp_inst._defaults.timeFormat;\n\n\t\t\t\t\tfor (var i = min; i <= max; i += step) {\n\t\t\t\t\t\tsel += '<option value=\"' + i + '\"' + (i === val ? ' selected' : '') + '>';\n\t\t\t\t\t\tif (unit === 'hour') {\n\t\t\t\t\t\t\tsel += $.datepicker.formatTime($.trim(format.replace(/[^ht ]/ig, '')), {hour: i}, tp_inst._defaults);\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse if (unit === 'millisec' || unit === 'microsec' || i >= 10) { sel += i; }\n\t\t\t\t\t\telse {sel += '0' + i.toString(); }\n\t\t\t\t\t\tsel += '</option>';\n\t\t\t\t\t}\n\t\t\t\t\tsel += '</select>';\n\n\t\t\t\t\tobj.children('select').remove();\n\n\t\t\t\t\t$(sel).appendTo(obj).change(function (e) {\n\t\t\t\t\t\ttp_inst._onTimeChange();\n\t\t\t\t\t\ttp_inst._onSelectHandler();\n\t\t\t\t\t});\n\n\t\t\t\t\treturn obj;\n\t\t\t\t},\n\t\t\t\toptions: function (tp_inst, obj, unit, opts, val) {\n\t\t\t\t\tvar o = {},\n\t\t\t\t\t\t$t = obj.children('select');\n\t\t\t\t\tif (typeof(opts) === 'string') {\n\t\t\t\t\t\tif (val === undefined) {\n\t\t\t\t\t\t\treturn $t.data(opts);\n\t\t\t\t\t\t}\n\t\t\t\t\t\to[opts] = val;\t\n\t\t\t\t\t}\n\t\t\t\t\telse { o = opts; }\n\t\t\t\t\treturn tp_inst.control.create(tp_inst, obj, $t.data('unit'), $t.val(), o.min || $t.data('min'), o.max || $t.data('max'), o.step || $t.data('step'));\n\t\t\t\t},\n\t\t\t\tvalue: function (tp_inst, obj, unit, val) {\n\t\t\t\t\tvar $t = obj.children('select');\n\t\t\t\t\tif (val !== undefined) {\n\t\t\t\t\t\treturn $t.val(val);\n\t\t\t\t\t}\n\t\t\t\t\treturn $t.val();\n\t\t\t\t}\n\t\t\t}\n\t\t} // end _controls\n\n\t});\n\n\t$.fn.extend({\n\t\t/*\n\t\t* shorthand just to use timepicker.\n\t\t*/\n\t\ttimepicker: function (o) {\n\t\t\to = o || {};\n\t\t\tvar tmp_args = Array.prototype.slice.call(arguments);\n\n\t\t\tif (typeof o === 'object') {\n\t\t\t\ttmp_args[0] = $.extend(o, {\n\t\t\t\t\ttimeOnly: true\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn $(this).each(function () {\n\t\t\t\t$.fn.datetimepicker.apply($(this), tmp_args);\n\t\t\t});\n\t\t},\n\n\t\t/*\n\t\t* extend timepicker to datepicker\n\t\t*/\n\t\tdatetimepicker: function (o) {\n\t\t\to = o || {};\n\t\t\tvar tmp_args = arguments;\n\n\t\t\tif (typeof(o) === 'string') {\n\t\t\t\tif (o === 'getDate') {\n\t\t\t\t\treturn $.fn.datepicker.apply($(this[0]), tmp_args);\n\t\t\t\t} else {\n\t\t\t\t\treturn this.each(function () {\n\t\t\t\t\t\tvar $t = $(this);\n\t\t\t\t\t\t$t.datepicker.apply($t, tmp_args);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\treturn this.each(function () {\n\t\t\t\t\tvar $t = $(this);\n\t\t\t\t\t$t.datepicker($.timepicker._newInst($t, o)._defaults);\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t});\n\n\t/*\n\t* Public Utility to parse date and time\n\t*/\n\t$.datepicker.parseDateTime = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n\t\tvar parseRes = parseDateTimeInternal(dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings);\n\t\tif (parseRes.timeObj) {\n\t\t\tvar t = parseRes.timeObj;\n\t\t\tparseRes.date.setHours(t.hour, t.minute, t.second, t.millisec);\n\t\t\tparseRes.date.setMicroseconds(t.microsec);\n\t\t}\n\n\t\treturn parseRes.date;\n\t};\n\n\t/*\n\t* Public utility to parse time\n\t*/\n\t$.datepicker.parseTime = function (timeFormat, timeString, options) {\n\t\tvar o = extendRemove(extendRemove({}, $.timepicker._defaults), options || {}),\n\t\t\tiso8601 = (timeFormat.replace(/\\'.*?\\'/g, '').indexOf('Z') !== -1);\n\n\t\t// Strict parse requires the timeString to match the timeFormat exactly\n\t\tvar strictParse = function (f, s, o) {\n\n\t\t\t// pattern for standard and localized AM/PM markers\n\t\t\tvar getPatternAmpm = function (amNames, pmNames) {\n\t\t\t\tvar markers = [];\n\t\t\t\tif (amNames) {\n\t\t\t\t\t$.merge(markers, amNames);\n\t\t\t\t}\n\t\t\t\tif (pmNames) {\n\t\t\t\t\t$.merge(markers, pmNames);\n\t\t\t\t}\n\t\t\t\tmarkers = $.map(markers, function (val) {\n\t\t\t\t\treturn val.replace(/[.*+?|()\\[\\]{}\\\\]/g, '\\\\$&');\n\t\t\t\t});\n\t\t\t\treturn '(' + markers.join('|') + ')?';\n\t\t\t};\n\n\t\t\t// figure out position of time elements.. cause js cant do named captures\n\t\t\tvar getFormatPositions = function (timeFormat) {\n\t\t\t\tvar finds = timeFormat.toLowerCase().match(/(h{1,2}|m{1,2}|s{1,2}|l{1}|c{1}|t{1,2}|z|'.*?')/g),\n\t\t\t\t\torders = {\n\t\t\t\t\t\th: -1,\n\t\t\t\t\t\tm: -1,\n\t\t\t\t\t\ts: -1,\n\t\t\t\t\t\tl: -1,\n\t\t\t\t\t\tc: -1,\n\t\t\t\t\t\tt: -1,\n\t\t\t\t\t\tz: -1\n\t\t\t\t\t};\n\n\t\t\t\tif (finds) {\n\t\t\t\t\tfor (var i = 0; i < finds.length; i++) {\n\t\t\t\t\t\tif (orders[finds[i].toString().charAt(0)] === -1) {\n\t\t\t\t\t\t\torders[finds[i].toString().charAt(0)] = i + 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn orders;\n\t\t\t};\n\n\t\t\tvar regstr = '^' + f.toString()\n\t\t\t\t\t.replace(/([hH]{1,2}|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n\t\t\t\t\t\t\tvar ml = match.length;\n\t\t\t\t\t\t\tswitch (match.charAt(0).toLowerCase()) {\n\t\t\t\t\t\t\tcase 'h':\n\t\t\t\t\t\t\t\treturn ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n\t\t\t\t\t\t\tcase 'm':\n\t\t\t\t\t\t\t\treturn ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n\t\t\t\t\t\t\tcase 's':\n\t\t\t\t\t\t\t\treturn ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n\t\t\t\t\t\t\tcase 'l':\n\t\t\t\t\t\t\t\treturn '(\\\\d?\\\\d?\\\\d)';\n\t\t\t\t\t\t\tcase 'c':\n\t\t\t\t\t\t\t\treturn '(\\\\d?\\\\d?\\\\d)';\n\t\t\t\t\t\t\tcase 'z':\n\t\t\t\t\t\t\t\treturn '(z|[-+]\\\\d\\\\d:?\\\\d\\\\d|\\\\S+)?';\n\t\t\t\t\t\t\tcase 't':\n\t\t\t\t\t\t\t\treturn getPatternAmpm(o.amNames, o.pmNames);\n\t\t\t\t\t\t\tdefault:    // literal escaped in quotes\n\t\t\t\t\t\t\t\treturn '(' + match.replace(/\\'/g, \"\").replace(/(\\.|\\$|\\^|\\\\|\\/|\\(|\\)|\\[|\\]|\\?|\\+|\\*)/g, function (m) { return \"\\\\\" + m; }) + ')?';\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t})\n\t\t\t\t\t.replace(/\\s/g, '\\\\s?') +\n\t\t\t\t\to.timeSuffix + '$',\n\t\t\t\torder = getFormatPositions(f),\n\t\t\t\tampm = '',\n\t\t\t\ttreg;\n\n\t\t\ttreg = s.match(new RegExp(regstr, 'i'));\n\n\t\t\tvar resTime = {\n\t\t\t\thour: 0,\n\t\t\t\tminute: 0,\n\t\t\t\tsecond: 0,\n\t\t\t\tmillisec: 0,\n\t\t\t\tmicrosec: 0\n\t\t\t};\n\n\t\t\tif (treg) {\n\t\t\t\tif (order.t !== -1) {\n\t\t\t\t\tif (treg[order.t] === undefined || treg[order.t].length === 0) {\n\t\t\t\t\t\tampm = '';\n\t\t\t\t\t\tresTime.ampm = '';\n\t\t\t\t\t} else {\n\t\t\t\t\t\tampm = $.inArray(treg[order.t].toUpperCase(), o.amNames) !== -1 ? 'AM' : 'PM';\n\t\t\t\t\t\tresTime.ampm = o[ampm === 'AM' ? 'amNames' : 'pmNames'][0];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (order.h !== -1) {\n\t\t\t\t\tif (ampm === 'AM' && treg[order.h] === '12') {\n\t\t\t\t\t\tresTime.hour = 0; // 12am = 0 hour\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (ampm === 'PM' && treg[order.h] !== '12') {\n\t\t\t\t\t\t\tresTime.hour = parseInt(treg[order.h], 10) + 12; // 12pm = 12 hour, any other pm = hour + 12\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tresTime.hour = Number(treg[order.h]);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (order.m !== -1) {\n\t\t\t\t\tresTime.minute = Number(treg[order.m]);\n\t\t\t\t}\n\t\t\t\tif (order.s !== -1) {\n\t\t\t\t\tresTime.second = Number(treg[order.s]);\n\t\t\t\t}\n\t\t\t\tif (order.l !== -1) {\n\t\t\t\t\tresTime.millisec = Number(treg[order.l]);\n\t\t\t\t}\n\t\t\t\tif (order.c !== -1) {\n\t\t\t\t\tresTime.microsec = Number(treg[order.c]);\n\t\t\t\t}\n\t\t\t\tif (order.z !== -1 && treg[order.z] !== undefined) {\n\t\t\t\t\tresTime.timezone = $.timepicker.timezoneOffsetNumber(treg[order.z]);\n\t\t\t\t}\n\n\n\t\t\t\treturn resTime;\n\t\t\t}\n\t\t\treturn false;\n\t\t};// end strictParse\n\n\t\t// First try JS Date, if that fails, use strictParse\n\t\tvar looseParse = function (f, s, o) {\n\t\t\ttry {\n\t\t\t\tvar d = new Date('2012-01-01 ' + s);\n\t\t\t\tif (isNaN(d.getTime())) {\n\t\t\t\t\td = new Date('2012-01-01T' + s);\n\t\t\t\t\tif (isNaN(d.getTime())) {\n\t\t\t\t\t\td = new Date('01/01/2012 ' + s);\n\t\t\t\t\t\tif (isNaN(d.getTime())) {\n\t\t\t\t\t\t\tthrow \"Unable to parse time with native Date: \" + s;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn {\n\t\t\t\t\thour: d.getHours(),\n\t\t\t\t\tminute: d.getMinutes(),\n\t\t\t\t\tsecond: d.getSeconds(),\n\t\t\t\t\tmillisec: d.getMilliseconds(),\n\t\t\t\t\tmicrosec: d.getMicroseconds(),\n\t\t\t\t\ttimezone: d.getTimezoneOffset() * -1\n\t\t\t\t};\n\t\t\t}\n\t\t\tcatch (err) {\n\t\t\t\ttry {\n\t\t\t\t\treturn strictParse(f, s, o);\n\t\t\t\t}\n\t\t\t\tcatch (err2) {\n\t\t\t\t\t$.timepicker.log(\"Unable to parse \\ntimeString: \" + s + \"\\ntimeFormat: \" + f);\n\t\t\t\t}\t\t\t\t\n\t\t\t}\n\t\t\treturn false;\n\t\t}; // end looseParse\n\t\t\n\t\tif (typeof o.parse === \"function\") {\n\t\t\treturn o.parse(timeFormat, timeString, o);\n\t\t}\n\t\tif (o.parse === 'loose') {\n\t\t\treturn looseParse(timeFormat, timeString, o);\n\t\t}\n\t\treturn strictParse(timeFormat, timeString, o);\n\t};\n\n\t/**\n\t * Public utility to format the time\n\t * @param {string} format format of the time\n\t * @param {Object} time Object not a Date for timezones\n\t * @param {Object} [options] essentially the regional[].. amNames, pmNames, ampm\n\t * @returns {string} the formatted time\n\t */\n\t$.datepicker.formatTime = function (format, time, options) {\n\t\toptions = options || {};\n\t\toptions = $.extend({}, $.timepicker._defaults, options);\n\t\ttime = $.extend({\n\t\t\thour: 0,\n\t\t\tminute: 0,\n\t\t\tsecond: 0,\n\t\t\tmillisec: 0,\n\t\t\tmicrosec: 0,\n\t\t\ttimezone: null\n\t\t}, time);\n\n\t\tvar tmptime = format,\n\t\t\tampmName = options.amNames[0],\n\t\t\thour = parseInt(time.hour, 10);\n\n\t\tif (hour > 11) {\n\t\t\tampmName = options.pmNames[0];\n\t\t}\n\n\t\ttmptime = tmptime.replace(/(?:HH?|hh?|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n\t\t\tswitch (match) {\n\t\t\tcase 'HH':\n\t\t\t\treturn ('0' + hour).slice(-2);\n\t\t\tcase 'H':\n\t\t\t\treturn hour;\n\t\t\tcase 'hh':\n\t\t\t\treturn ('0' + convert24to12(hour)).slice(-2);\n\t\t\tcase 'h':\n\t\t\t\treturn convert24to12(hour);\n\t\t\tcase 'mm':\n\t\t\t\treturn ('0' + time.minute).slice(-2);\n\t\t\tcase 'm':\n\t\t\t\treturn time.minute;\n\t\t\tcase 'ss':\n\t\t\t\treturn ('0' + time.second).slice(-2);\n\t\t\tcase 's':\n\t\t\t\treturn time.second;\n\t\t\tcase 'l':\n\t\t\t\treturn ('00' + time.millisec).slice(-3);\n\t\t\tcase 'c':\n\t\t\t\treturn ('00' + time.microsec).slice(-3);\n\t\t\tcase 'z':\n\t\t\t\treturn $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, false);\n\t\t\tcase 'Z':\n\t\t\t\treturn $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, true);\n\t\t\tcase 'T':\n\t\t\t\treturn ampmName.charAt(0).toUpperCase();\n\t\t\tcase 'TT':\n\t\t\t\treturn ampmName.toUpperCase();\n\t\t\tcase 't':\n\t\t\t\treturn ampmName.charAt(0).toLowerCase();\n\t\t\tcase 'tt':\n\t\t\t\treturn ampmName.toLowerCase();\n\t\t\tdefault:\n\t\t\t\treturn match.replace(/'/g, \"\");\n\t\t\t}\n\t\t});\n\n\t\treturn tmptime;\n\t};\n\n\t/*\n\t* the bad hack :/ override datepicker so it doesn't close on select\n\t// inspired: http://stackoverflow.com/questions/1252512/jquery-datepicker-prevent-closing-picker-when-clicking-a-date/1762378#1762378\n\t*/\n\t$.datepicker._base_selectDate = $.datepicker._selectDate;\n\t$.datepicker._selectDate = function (id, dateStr) {\n\t\tvar inst = this._getInst($(id)[0]),\n\t\t\ttp_inst = this._get(inst, 'timepicker');\n\n\t\tif (tp_inst) {\n\t\t\ttp_inst._limitMinMaxDateTime(inst, true);\n\t\t\tinst.inline = inst.stay_open = true;\n\t\t\t//This way the onSelect handler called from calendarpicker get the full dateTime\n\t\t\tthis._base_selectDate(id, dateStr);\n\t\t\tinst.inline = inst.stay_open = false;\n\t\t\tthis._notifyChange(inst);\n\t\t\tthis._updateDatepicker(inst);\n\t\t} else {\n\t\t\tthis._base_selectDate(id, dateStr);\n\t\t}\n\t};\n\n\t/*\n\t* second bad hack :/ override datepicker so it triggers an event when changing the input field\n\t* and does not redraw the datepicker on every selectDate event\n\t*/\n\t$.datepicker._base_updateDatepicker = $.datepicker._updateDatepicker;\n\t$.datepicker._updateDatepicker = function (inst) {\n\n\t\t// don't popup the datepicker if there is another instance already opened\n\t\tvar input = inst.input[0];\n\t\tif ($.datepicker._curInst && $.datepicker._curInst !== inst && $.datepicker._datepickerShowing && $.datepicker._lastInput !== input) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (typeof(inst.stay_open) !== 'boolean' || inst.stay_open === false) {\n\n\t\t\tthis._base_updateDatepicker(inst);\n\n\t\t\t// Reload the time control when changing something in the input text field.\n\t\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\t\tif (tp_inst) {\n\t\t\t\ttp_inst._addTimePicker(inst);\n\t\t\t}\n\t\t}\n\t};\n\n\t/*\n\t* third bad hack :/ override datepicker so it allows spaces and colon in the input field\n\t*/\n\t$.datepicker._base_doKeyPress = $.datepicker._doKeyPress;\n\t$.datepicker._doKeyPress = function (event) {\n\t\tvar inst = $.datepicker._getInst(event.target),\n\t\t\ttp_inst = $.datepicker._get(inst, 'timepicker');\n\n\t\tif (tp_inst) {\n\t\t\tif ($.datepicker._get(inst, 'constrainInput')) {\n\t\t\t\tvar ampm = tp_inst.support.ampm,\n\t\t\t\t\ttz = tp_inst._defaults.showTimezone !== null ? tp_inst._defaults.showTimezone : tp_inst.support.timezone,\n\t\t\t\t\tdateChars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat')),\n\t\t\t\t\tdatetimeChars = tp_inst._defaults.timeFormat.toString()\n\t\t\t\t\t\t\t\t\t\t\t.replace(/[hms]/g, '')\n\t\t\t\t\t\t\t\t\t\t\t.replace(/TT/g, ampm ? 'APM' : '')\n\t\t\t\t\t\t\t\t\t\t\t.replace(/Tt/g, ampm ? 'AaPpMm' : '')\n\t\t\t\t\t\t\t\t\t\t\t.replace(/tT/g, ampm ? 'AaPpMm' : '')\n\t\t\t\t\t\t\t\t\t\t\t.replace(/T/g, ampm ? 'AP' : '')\n\t\t\t\t\t\t\t\t\t\t\t.replace(/tt/g, ampm ? 'apm' : '')\n\t\t\t\t\t\t\t\t\t\t\t.replace(/t/g, ampm ? 'ap' : '') + \n\t\t\t\t\t\t\t\t\t\t\t\" \" + tp_inst._defaults.separator + \n\t\t\t\t\t\t\t\t\t\t\ttp_inst._defaults.timeSuffix + \n\t\t\t\t\t\t\t\t\t\t\t(tz ? tp_inst._defaults.timezoneList.join('') : '') + \n\t\t\t\t\t\t\t\t\t\t\t(tp_inst._defaults.amNames.join('')) + (tp_inst._defaults.pmNames.join('')) + \n\t\t\t\t\t\t\t\t\t\t\tdateChars,\n\t\t\t\t\tchr = String.fromCharCode(event.charCode === undefined ? event.keyCode : event.charCode);\n\t\t\t\treturn event.ctrlKey || (chr < ' ' || !dateChars || datetimeChars.indexOf(chr) > -1);\n\t\t\t}\n\t\t}\n\n\t\treturn $.datepicker._base_doKeyPress(event);\n\t};\n\n\t/*\n\t* Fourth bad hack :/ override _updateAlternate function used in inline mode to init altField\n\t* Update any alternate field to synchronise with the main field.\n\t*/\n\t$.datepicker._base_updateAlternate = $.datepicker._updateAlternate;\n\t$.datepicker._updateAlternate = function (inst) {\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\tif (tp_inst) {\n\t\t\tvar altField = tp_inst._defaults.altField;\n\t\t\tif (altField) { // update alternate field too\n\t\t\t\tvar altFormat = tp_inst._defaults.altFormat || tp_inst._defaults.dateFormat,\n\t\t\t\t\tdate = this._getDate(inst),\n\t\t\t\t\tformatCfg = $.datepicker._getFormatConfig(inst),\n\t\t\t\t\taltFormattedDateTime = '', \n\t\t\t\t\taltSeparator = tp_inst._defaults.altSeparator ? tp_inst._defaults.altSeparator : tp_inst._defaults.separator, \n\t\t\t\t\taltTimeSuffix = tp_inst._defaults.altTimeSuffix ? tp_inst._defaults.altTimeSuffix : tp_inst._defaults.timeSuffix,\n\t\t\t\t\taltTimeFormat = tp_inst._defaults.altTimeFormat !== null ? tp_inst._defaults.altTimeFormat : tp_inst._defaults.timeFormat;\n\t\t\t\t\n\t\t\t\taltFormattedDateTime += $.datepicker.formatTime(altTimeFormat, tp_inst, tp_inst._defaults) + altTimeSuffix;\n\t\t\t\tif (!tp_inst._defaults.timeOnly && !tp_inst._defaults.altFieldTimeOnly && date !== null) {\n\t\t\t\t\tif (tp_inst._defaults.altFormat) {\n\t\t\t\t\t\taltFormattedDateTime = $.datepicker.formatDate(tp_inst._defaults.altFormat, date, formatCfg) + altSeparator + altFormattedDateTime;\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\taltFormattedDateTime = tp_inst.formattedDate + altSeparator + altFormattedDateTime;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t$(altField).val(altFormattedDateTime);\n\t\t\t}\n\t\t}\n\t\telse {\n\t\t\t$.datepicker._base_updateAlternate(inst);\n\t\t}\n\t};\n\n\t/*\n\t* Override key up event to sync manual input changes.\n\t*/\n\t$.datepicker._base_doKeyUp = $.datepicker._doKeyUp;\n\t$.datepicker._doKeyUp = function (event) {\n\t\tvar inst = $.datepicker._getInst(event.target),\n\t\t\ttp_inst = $.datepicker._get(inst, 'timepicker');\n\n\t\tif (tp_inst) {\n\t\t\tif (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n\t\t\t\ttry {\n\t\t\t\t\t$.datepicker._updateDatepicker(inst);\n\t\t\t\t} catch (err) {\n\t\t\t\t\t$.timepicker.log(err);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn $.datepicker._base_doKeyUp(event);\n\t};\n\n\t/*\n\t* override \"Today\" button to also grab the time.\n\t*/\n\t$.datepicker._base_gotoToday = $.datepicker._gotoToday;\n\t$.datepicker._gotoToday = function (id) {\n\t\tvar inst = this._getInst($(id)[0]),\n\t\t\t$dp = inst.dpDiv;\n\t\tthis._base_gotoToday(id);\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\tselectLocalTimezone(tp_inst);\n\t\tvar now = new Date();\n\t\tthis._setTime(inst, now);\n\t\t$('.ui-datepicker-today', $dp).click();\n\t};\n\n\t/*\n\t* Disable & enable the Time in the datetimepicker\n\t*/\n\t$.datepicker._disableTimepickerDatepicker = function (target) {\n\t\tvar inst = this._getInst(target);\n\t\tif (!inst) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\t$(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n\t\tif (tp_inst) {\n\t\t\tinst.settings.showTimepicker = false;\n\t\t\ttp_inst._defaults.showTimepicker = false;\n\t\t\ttp_inst._updateDateTime(inst);\n\t\t}\n\t};\n\n\t$.datepicker._enableTimepickerDatepicker = function (target) {\n\t\tvar inst = this._getInst(target);\n\t\tif (!inst) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\t$(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n\t\tif (tp_inst) {\n\t\t\tinst.settings.showTimepicker = true;\n\t\t\ttp_inst._defaults.showTimepicker = true;\n\t\t\ttp_inst._addTimePicker(inst); // Could be disabled on page load\n\t\t\ttp_inst._updateDateTime(inst);\n\t\t}\n\t};\n\n\t/*\n\t* Create our own set time function\n\t*/\n\t$.datepicker._setTime = function (inst, date) {\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\tif (tp_inst) {\n\t\t\tvar defaults = tp_inst._defaults;\n\n\t\t\t// calling _setTime with no date sets time to defaults\n\t\t\ttp_inst.hour = date ? date.getHours() : defaults.hour;\n\t\t\ttp_inst.minute = date ? date.getMinutes() : defaults.minute;\n\t\t\ttp_inst.second = date ? date.getSeconds() : defaults.second;\n\t\t\ttp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;\n\t\t\ttp_inst.microsec = date ? date.getMicroseconds() : defaults.microsec;\n\n\t\t\t//check if within min/max times.. \n\t\t\ttp_inst._limitMinMaxDateTime(inst, true);\n\n\t\t\ttp_inst._onTimeChange();\n\t\t\ttp_inst._updateDateTime(inst);\n\t\t}\n\t};\n\n\t/*\n\t* Create new public method to set only time, callable as $().datepicker('setTime', date)\n\t*/\n\t$.datepicker._setTimeDatepicker = function (target, date, withDate) {\n\t\tvar inst = this._getInst(target);\n\t\tif (!inst) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\n\t\tif (tp_inst) {\n\t\t\tthis._setDateFromField(inst);\n\t\t\tvar tp_date;\n\t\t\tif (date) {\n\t\t\t\tif (typeof date === \"string\") {\n\t\t\t\t\ttp_inst._parseTime(date, withDate);\n\t\t\t\t\ttp_date = new Date();\n\t\t\t\t\ttp_date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n\t\t\t\t\ttp_date.setMicroseconds(tp_inst.microsec);\n\t\t\t\t} else {\n\t\t\t\t\ttp_date = new Date(date.getTime());\n\t\t\t\t\ttp_date.setMicroseconds(date.getMicroseconds());\n\t\t\t\t}\n\t\t\t\tif (tp_date.toString() === 'Invalid Date') {\n\t\t\t\t\ttp_date = undefined;\n\t\t\t\t}\n\t\t\t\tthis._setTime(inst, tp_date);\n\t\t\t}\n\t\t}\n\n\t};\n\n\t/*\n\t* override setDate() to allow setting time too within Date object\n\t*/\n\t$.datepicker._base_setDateDatepicker = $.datepicker._setDateDatepicker;\n\t$.datepicker._setDateDatepicker = function (target, date) {\n\t\tvar inst = this._getInst(target);\n\t\tif (!inst) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (typeof(date) === 'string') {\n\t\t\tdate = new Date(date);\n\t\t\tif (!date.getTime()) {\n\t\t\t\t$.timepicker.log(\"Error creating Date object from string.\");\n\t\t\t}\n\t\t}\n\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\tvar tp_date;\n\t\tif (date instanceof Date) {\n\t\t\ttp_date = new Date(date.getTime());\n\t\t\ttp_date.setMicroseconds(date.getMicroseconds());\n\t\t} else {\n\t\t\ttp_date = date;\n\t\t}\n\t\t\n\t\t// This is important if you are using the timezone option, javascript's Date \n\t\t// object will only return the timezone offset for the current locale, so we \n\t\t// adjust it accordingly.  If not using timezone option this won't matter..\n\t\t// If a timezone is different in tp, keep the timezone as is\n\t\tif (tp_inst && tp_date) {\n\t\t\t// look out for DST if tz wasn't specified\n\t\t\tif (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n\t\t\t\ttp_inst.timezone = tp_date.getTimezoneOffset() * -1;\n\t\t\t}\n\t\t\tdate = $.timepicker.timezoneAdjust(date, tp_inst.timezone);\n\t\t\ttp_date = $.timepicker.timezoneAdjust(tp_date, tp_inst.timezone);\n\t\t}\n\n\t\tthis._updateDatepicker(inst);\n\t\tthis._base_setDateDatepicker.apply(this, arguments);\n\t\tthis._setTimeDatepicker(target, tp_date, true);\n\t};\n\n\t/*\n\t* override getDate() to allow getting time too within Date object\n\t*/\n\t$.datepicker._base_getDateDatepicker = $.datepicker._getDateDatepicker;\n\t$.datepicker._getDateDatepicker = function (target, noDefault) {\n\t\tvar inst = this._getInst(target);\n\t\tif (!inst) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\n\t\tif (tp_inst) {\n\t\t\t// if it hasn't yet been defined, grab from field\n\t\t\tif (inst.lastVal === undefined) {\n\t\t\t\tthis._setDateFromField(inst, noDefault);\n\t\t\t}\n\n\t\t\tvar date = this._getDate(inst);\n\t\t\tif (date && tp_inst._parseTime($(target).val(), tp_inst.timeOnly)) {\n\t\t\t\tdate.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n\t\t\t\tdate.setMicroseconds(tp_inst.microsec);\n\n\t\t\t\t// This is important if you are using the timezone option, javascript's Date \n\t\t\t\t// object will only return the timezone offset for the current locale, so we \n\t\t\t\t// adjust it accordingly.  If not using timezone option this won't matter..\n\t\t\t\tif (tp_inst.timezone != null) {\n\t\t\t\t\t// look out for DST if tz wasn't specified\n\t\t\t\t\tif (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n\t\t\t\t\t\ttp_inst.timezone = date.getTimezoneOffset() * -1;\n\t\t\t\t\t}\n\t\t\t\t\tdate = $.timepicker.timezoneAdjust(date, tp_inst.timezone);\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn date;\n\t\t}\n\t\treturn this._base_getDateDatepicker(target, noDefault);\n\t};\n\n\t/*\n\t* override parseDate() because UI 1.8.14 throws an error about \"Extra characters\"\n\t* An option in datapicker to ignore extra format characters would be nicer.\n\t*/\n\t$.datepicker._base_parseDate = $.datepicker.parseDate;\n\t$.datepicker.parseDate = function (format, value, settings) {\n\t\tvar date;\n\t\ttry {\n\t\t\tdate = this._base_parseDate(format, value, settings);\n\t\t} catch (err) {\n\t\t\t// Hack!  The error message ends with a colon, a space, and\n\t\t\t// the \"extra\" characters.  We rely on that instead of\n\t\t\t// attempting to perfectly reproduce the parsing algorithm.\n\t\t\tif (err.indexOf(\":\") >= 0) {\n\t\t\t\tdate = this._base_parseDate(format, value.substring(0, value.length - (err.length - err.indexOf(':') - 2)), settings);\n\t\t\t\t$.timepicker.log(\"Error parsing the date string: \" + err + \"\\ndate string = \" + value + \"\\ndate format = \" + format);\n\t\t\t} else {\n\t\t\t\tthrow err;\n\t\t\t}\n\t\t}\n\t\treturn date;\n\t};\n\n\t/*\n\t* override formatDate to set date with time to the input\n\t*/\n\t$.datepicker._base_formatDate = $.datepicker._formatDate;\n\t$.datepicker._formatDate = function (inst, day, month, year) {\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\tif (tp_inst) {\n\t\t\ttp_inst._updateDateTime(inst);\n\t\t\treturn tp_inst.$input.val();\n\t\t}\n\t\treturn this._base_formatDate(inst);\n\t};\n\n\t/*\n\t* override options setter to add time to maxDate(Time) and minDate(Time). MaxDate\n\t*/\n\t$.datepicker._base_optionDatepicker = $.datepicker._optionDatepicker;\n\t$.datepicker._optionDatepicker = function (target, name, value) {\n\t\tvar inst = this._getInst(target),\n\t\t\tname_clone;\n\t\tif (!inst) {\n\t\t\treturn null;\n\t\t}\n\n\t\tvar tp_inst = this._get(inst, 'timepicker');\n\t\tif (tp_inst) {\n\t\t\tvar min = null,\n\t\t\t\tmax = null,\n\t\t\t\tonselect = null,\n\t\t\t\toverrides = tp_inst._defaults.evnts,\n\t\t\t\tfns = {},\n\t\t\t\tprop;\n\t\t\tif (typeof name === 'string') { // if min/max was set with the string\n\t\t\t\tif (name === 'minDate' || name === 'minDateTime') {\n\t\t\t\t\tmin = value;\n\t\t\t\t} else if (name === 'maxDate' || name === 'maxDateTime') {\n\t\t\t\t\tmax = value;\n\t\t\t\t} else if (name === 'onSelect') {\n\t\t\t\t\tonselect = value;\n\t\t\t\t} else if (overrides.hasOwnProperty(name)) {\n\t\t\t\t\tif (typeof (value) === 'undefined') {\n\t\t\t\t\t\treturn overrides[name];\n\t\t\t\t\t}\n\t\t\t\t\tfns[name] = value;\n\t\t\t\t\tname_clone = {}; //empty results in exiting function after overrides updated\n\t\t\t\t}\n\t\t\t} else if (typeof name === 'object') { //if min/max was set with the JSON\n\t\t\t\tif (name.minDate) {\n\t\t\t\t\tmin = name.minDate;\n\t\t\t\t} else if (name.minDateTime) {\n\t\t\t\t\tmin = name.minDateTime;\n\t\t\t\t} else if (name.maxDate) {\n\t\t\t\t\tmax = name.maxDate;\n\t\t\t\t} else if (name.maxDateTime) {\n\t\t\t\t\tmax = name.maxDateTime;\n\t\t\t\t}\n\t\t\t\tfor (prop in overrides) {\n\t\t\t\t\tif (overrides.hasOwnProperty(prop) && name[prop]) {\n\t\t\t\t\t\tfns[prop] = name[prop];\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tfor (prop in fns) {\n\t\t\t\tif (fns.hasOwnProperty(prop)) {\n\t\t\t\t\toverrides[prop] = fns[prop];\n\t\t\t\t\tif (!name_clone) { name_clone = $.extend({}, name); }\n\t\t\t\t\tdelete name_clone[prop];\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (name_clone && isEmptyObject(name_clone)) { return; }\n\t\t\tif (min) { //if min was set\n\t\t\t\tif (min === 0) {\n\t\t\t\t\tmin = new Date();\n\t\t\t\t} else {\n\t\t\t\t\tmin = new Date(min);\n\t\t\t\t}\n\t\t\t\ttp_inst._defaults.minDate = min;\n\t\t\t\ttp_inst._defaults.minDateTime = min;\n\t\t\t} else if (max) { //if max was set\n\t\t\t\tif (max === 0) {\n\t\t\t\t\tmax = new Date();\n\t\t\t\t} else {\n\t\t\t\t\tmax = new Date(max);\n\t\t\t\t}\n\t\t\t\ttp_inst._defaults.maxDate = max;\n\t\t\t\ttp_inst._defaults.maxDateTime = max;\n\t\t\t} else if (onselect) {\n\t\t\t\ttp_inst._defaults.onSelect = onselect;\n\t\t\t}\n\t\t}\n\t\tif (value === undefined) {\n\t\t\treturn this._base_optionDatepicker.call($.datepicker, target, name);\n\t\t}\n\t\treturn this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n\t};\n\t\n\t/*\n\t* jQuery isEmptyObject does not check hasOwnProperty - if someone has added to the object prototype,\n\t* it will return false for all objects\n\t*/\n\tvar isEmptyObject = function (obj) {\n\t\tvar prop;\n\t\tfor (prop in obj) {\n\t\t\tif (obj.hasOwnProperty(prop)) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\t\treturn true;\n\t};\n\n\t/*\n\t* jQuery extend now ignores nulls!\n\t*/\n\tvar extendRemove = function (target, props) {\n\t\t$.extend(target, props);\n\t\tfor (var name in props) {\n\t\t\tif (props[name] === null || props[name] === undefined) {\n\t\t\t\ttarget[name] = props[name];\n\t\t\t}\n\t\t}\n\t\treturn target;\n\t};\n\n\t/*\n\t* Determine by the time format which units are supported\n\t* Returns an object of booleans for each unit\n\t*/\n\tvar detectSupport = function (timeFormat) {\n\t\tvar tf = timeFormat.replace(/'.*?'/g, '').toLowerCase(), // removes literals\n\t\t\tisIn = function (f, t) { // does the format contain the token?\n\t\t\t\t\treturn f.indexOf(t) !== -1 ? true : false;\n\t\t\t\t};\n\t\treturn {\n\t\t\t\thour: isIn(tf, 'h'),\n\t\t\t\tminute: isIn(tf, 'm'),\n\t\t\t\tsecond: isIn(tf, 's'),\n\t\t\t\tmillisec: isIn(tf, 'l'),\n\t\t\t\tmicrosec: isIn(tf, 'c'),\n\t\t\t\ttimezone: isIn(tf, 'z'),\n\t\t\t\tampm: isIn(tf, 't') && isIn(timeFormat, 'h'),\n\t\t\t\tiso8601: isIn(timeFormat, 'Z')\n\t\t\t};\n\t};\n\n\t/*\n\t* Converts 24 hour format into 12 hour\n\t* Returns 12 hour without leading 0\n\t*/\n\tvar convert24to12 = function (hour) {\n\t\thour %= 12;\n\n\t\tif (hour === 0) {\n\t\t\thour = 12;\n\t\t}\n\n\t\treturn String(hour);\n\t};\n\n\tvar computeEffectiveSetting = function (settings, property) {\n\t\treturn settings && settings[property] ? settings[property] : $.timepicker._defaults[property];\n\t};\n\n\t/*\n\t* Splits datetime string into date and time substrings.\n\t* Throws exception when date can't be parsed\n\t* Returns {dateString: dateString, timeString: timeString}\n\t*/\n\tvar splitDateTime = function (dateTimeString, timeSettings) {\n\t\t// The idea is to get the number separator occurrences in datetime and the time format requested (since time has\n\t\t// fewer unknowns, mostly numbers and am/pm). We will use the time pattern to split.\n\t\tvar separator = computeEffectiveSetting(timeSettings, 'separator'),\n\t\t\tformat = computeEffectiveSetting(timeSettings, 'timeFormat'),\n\t\t\ttimeParts = format.split(separator), // how many occurrences of separator may be in our format?\n\t\t\ttimePartsLen = timeParts.length,\n\t\t\tallParts = dateTimeString.split(separator),\n\t\t\tallPartsLen = allParts.length;\n\n\t\tif (allPartsLen > 1) {\n\t\t\treturn {\n\t\t\t\tdateString: allParts.splice(0, allPartsLen - timePartsLen).join(separator),\n\t\t\t\ttimeString: allParts.splice(0, timePartsLen).join(separator)\n\t\t\t};\n\t\t}\n\n\t\treturn {\n\t\t\tdateString: dateTimeString,\n\t\t\ttimeString: ''\n\t\t};\n\t};\n\n\t/*\n\t* Internal function to parse datetime interval\n\t* Returns: {date: Date, timeObj: Object}, where\n\t*   date - parsed date without time (type Date)\n\t*   timeObj = {hour: , minute: , second: , millisec: , microsec: } - parsed time. Optional\n\t*/\n\tvar parseDateTimeInternal = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n\t\tvar date,\n\t\t\tparts,\n\t\t\tparsedTime;\n\n\t\tparts = splitDateTime(dateTimeString, timeSettings);\n\t\tdate = $.datepicker._base_parseDate(dateFormat, parts.dateString, dateSettings);\n\n\t\tif (parts.timeString === '') {\n\t\t\treturn {\n\t\t\t\tdate: date\n\t\t\t};\n\t\t}\n\n\t\tparsedTime = $.datepicker.parseTime(timeFormat, parts.timeString, timeSettings);\n\n\t\tif (!parsedTime) {\n\t\t\tthrow 'Wrong time format';\n\t\t}\n\n\t\treturn {\n\t\t\tdate: date,\n\t\t\ttimeObj: parsedTime\n\t\t};\n\t};\n\n\t/*\n\t* Internal function to set timezone_select to the local timezone\n\t*/\n\tvar selectLocalTimezone = function (tp_inst, date) {\n\t\tif (tp_inst && tp_inst.timezone_select) {\n\t\t\tvar now = date || new Date();\n\t\t\ttp_inst.timezone_select.val(-now.getTimezoneOffset());\n\t\t}\n\t};\n\n\t/*\n\t* Create a Singleton Instance\n\t*/\n\t$.timepicker = new Timepicker();\n\n\t/**\n\t * Get the timezone offset as string from a date object (eg '+0530' for UTC+5.5)\n\t * @param {number} tzMinutes if not a number, less than -720 (-1200), or greater than 840 (+1400) this value is returned\n\t * @param {boolean} iso8601 if true formats in accordance to iso8601 \"+12:45\"\n\t * @return {string}\n\t */\n\t$.timepicker.timezoneOffsetString = function (tzMinutes, iso8601) {\n\t\tif (isNaN(tzMinutes) || tzMinutes > 840 || tzMinutes < -720) {\n\t\t\treturn tzMinutes;\n\t\t}\n\n\t\tvar off = tzMinutes,\n\t\t\tminutes = off % 60,\n\t\t\thours = (off - minutes) / 60,\n\t\t\tiso = iso8601 ? ':' : '',\n\t\t\ttz = (off >= 0 ? '+' : '-') + ('0' + Math.abs(hours)).slice(-2) + iso + ('0' + Math.abs(minutes)).slice(-2);\n\t\t\n\t\tif (tz === '+00:00') {\n\t\t\treturn 'Z';\n\t\t}\n\t\treturn tz;\n\t};\n\n\t/**\n\t * Get the number in minutes that represents a timezone string\n\t * @param  {string} tzString formatted like \"+0500\", \"-1245\", \"Z\"\n\t * @return {number} the offset minutes or the original string if it doesn't match expectations\n\t */\n\t$.timepicker.timezoneOffsetNumber = function (tzString) {\n\t\tvar normalized = tzString.toString().replace(':', ''); // excuse any iso8601, end up with \"+1245\"\n\n\t\tif (normalized.toUpperCase() === 'Z') { // if iso8601 with Z, its 0 minute offset\n\t\t\treturn 0;\n\t\t}\n\n\t\tif (!/^(\\-|\\+)\\d{4}$/.test(normalized)) { // possibly a user defined tz, so just give it back\n\t\t\treturn tzString;\n\t\t}\n\n\t\treturn ((normalized.substr(0, 1) === '-' ? -1 : 1) * // plus or minus\n\t\t\t\t\t((parseInt(normalized.substr(1, 2), 10) * 60) + // hours (converted to minutes)\n\t\t\t\t\tparseInt(normalized.substr(3, 2), 10))); // minutes\n\t};\n\n\t/**\n\t * No way to set timezone in js Date, so we must adjust the minutes to compensate. (think setDate, getDate)\n\t * @param  {Date} date\n\t * @param  {string} toTimezone formatted like \"+0500\", \"-1245\"\n\t * @return {Date}\n\t */\n\t$.timepicker.timezoneAdjust = function (date, toTimezone) {\n\t\tvar toTz = $.timepicker.timezoneOffsetNumber(toTimezone);\n\t\tif (!isNaN(toTz)) {\n\t\t\tdate.setMinutes(date.getMinutes() + -date.getTimezoneOffset() - toTz);\n\t\t}\n\t\treturn date;\n\t};\n\n\t/**\n\t * Calls `timepicker()` on the `startTime` and `endTime` elements, and configures them to\n\t * enforce date range limits.\n\t * n.b. The input value must be correctly formatted (reformatting is not supported)\n\t * @param  {Element} startTime\n\t * @param  {Element} endTime\n\t * @param  {Object} options Options for the timepicker() call\n\t * @return {jQuery}\n\t */\n\t$.timepicker.timeRange = function (startTime, endTime, options) {\n\t\treturn $.timepicker.handleRange('timepicker', startTime, endTime, options);\n\t};\n\n\t/**\n\t * Calls `datetimepicker` on the `startTime` and `endTime` elements, and configures them to\n\t * enforce date range limits.\n\t * @param  {Element} startTime\n\t * @param  {Element} endTime\n\t * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n\t *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n\t * @param  {string} method Can be used to specify the type of picker to be added\n\t * @return {jQuery}\n\t */\n\t$.timepicker.datetimeRange = function (startTime, endTime, options) {\n\t\t$.timepicker.handleRange('datetimepicker', startTime, endTime, options);\n\t};\n\n\t/**\n\t * Calls `datepicker` on the `startTime` and `endTime` elements, and configures them to\n\t * enforce date range limits.\n\t * @param  {Element} startTime\n\t * @param  {Element} endTime\n\t * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n\t *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n\t * @return {jQuery}\n\t */\n\t$.timepicker.dateRange = function (startTime, endTime, options) {\n\t\t$.timepicker.handleRange('datepicker', startTime, endTime, options);\n\t};\n\n\t/**\n\t * Calls `method` on the `startTime` and `endTime` elements, and configures them to\n\t * enforce date range limits.\n\t * @param  {string} method Can be used to specify the type of picker to be added\n\t * @param  {Element} startTime\n\t * @param  {Element} endTime\n\t * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n\t *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n\t * @return {jQuery}\n\t */\n\t$.timepicker.handleRange = function (method, startTime, endTime, options) {\n\t\toptions = $.extend({}, {\n\t\t\tminInterval: 0, // min allowed interval in milliseconds\n\t\t\tmaxInterval: 0, // max allowed interval in milliseconds\n\t\t\tstart: {},      // options for start picker\n\t\t\tend: {}         // options for end picker\n\t\t}, options);\n\n\t\tfunction checkDates(changed, other) {\n\t\t\tvar startdt = startTime[method]('getDate'),\n\t\t\t\tenddt = endTime[method]('getDate'),\n\t\t\t\tchangeddt = changed[method]('getDate');\n\n\t\t\tif (startdt !== null) {\n\t\t\t\tvar minDate = new Date(startdt.getTime()),\n\t\t\t\t\tmaxDate = new Date(startdt.getTime());\n\n\t\t\t\tminDate.setMilliseconds(minDate.getMilliseconds() + options.minInterval);\n\t\t\t\tmaxDate.setMilliseconds(maxDate.getMilliseconds() + options.maxInterval);\n\n\t\t\t\tif (options.minInterval > 0 && minDate > enddt) { // minInterval check\n\t\t\t\t\tendTime[method]('setDate', minDate);\n\t\t\t\t}\n\t\t\t\telse if (options.maxInterval > 0 && maxDate < enddt) { // max interval check\n\t\t\t\t\tendTime[method]('setDate', maxDate);\n\t\t\t\t}\n\t\t\t\telse if (startdt > enddt) {\n\t\t\t\t\tother[method]('setDate', changeddt);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tfunction selected(changed, other, option) {\n\t\t\tif (!changed.val()) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tvar date = changed[method].call(changed, 'getDate');\n\t\t\tif (date !== null && options.minInterval > 0) {\n\t\t\t\tif (option === 'minDate') {\n\t\t\t\t\tdate.setMilliseconds(date.getMilliseconds() + options.minInterval);\n\t\t\t\t}\n\t\t\t\tif (option === 'maxDate') {\n\t\t\t\t\tdate.setMilliseconds(date.getMilliseconds() - options.minInterval);\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (date.getTime) {\n\t\t\t\tother[method].call(other, 'option', option, date);\n\t\t\t}\n\t\t}\n\n\t\t$.fn[method].call(startTime, $.extend({\n\t\t\tonClose: function (dateText, inst) {\n\t\t\t\tcheckDates($(this), endTime);\n\t\t\t},\n\t\t\tonSelect: function (selectedDateTime) {\n\t\t\t\tselected($(this), endTime, 'minDate');\n\t\t\t}\n\t\t}, options, options.start));\n\t\t$.fn[method].call(endTime, $.extend({\n\t\t\tonClose: function (dateText, inst) {\n\t\t\t\tcheckDates($(this), startTime);\n\t\t\t},\n\t\t\tonSelect: function (selectedDateTime) {\n\t\t\t\tselected($(this), startTime, 'maxDate');\n\t\t\t}\n\t\t}, options, options.end));\n\n\t\tcheckDates(startTime, endTime);\n\t\tselected(startTime, endTime, 'minDate');\n\t\tselected(endTime, startTime, 'maxDate');\n\t\treturn $([startTime.get(0), endTime.get(0)]);\n\t};\n\n\t/**\n\t * Log error or data to the console during error or debugging\n\t * @param  {Object} err pass any type object to log to the console during error or debugging\n\t * @return {void}\n\t */\n\t$.timepicker.log = function (err) {\n\t\tif (window.console) {\n\t\t\twindow.console.log(err);\n\t\t}\n\t};\n\n\t/*\n\t * Add util object to allow access to private methods for testability.\n\t */\n\t$.timepicker._util = {\n\t\t_extendRemove: extendRemove,\n\t\t_isEmptyObject: isEmptyObject,\n\t\t_convert24to12: convert24to12,\n\t\t_detectSupport: detectSupport,\n\t\t_selectLocalTimezone: selectLocalTimezone,\n\t\t_computeEffectiveSetting: computeEffectiveSetting,\n\t\t_splitDateTime: splitDateTime,\n\t\t_parseDateTimeInternal: parseDateTimeInternal\n\t};\n\n\t/*\n\t* Microsecond support\n\t*/\n\tif (!Date.prototype.getMicroseconds) {\n\t\tDate.prototype.microseconds = 0;\n\t\tDate.prototype.getMicroseconds = function () { return this.microseconds; };\n\t\tDate.prototype.setMicroseconds = function (m) {\n\t\t\tthis.setMilliseconds(this.getMilliseconds() + Math.floor(m / 1000));\n\t\t\tthis.microseconds = m % 1000;\n\t\t\treturn this;\n\t\t};\n\t}\n\n\t/*\n\t* Keep up with the version\n\t*/\n\t$.timepicker.version = \"1.4.3\";\n\n}));","jquery/jquery.storageapi.min.js":"/* jQuery Storage API Plugin 1.7.3 https://github.com/julien-maurel/jQuery-Storage-API */\n!function(e){\"function\"==typeof define&&define.amd?define([\"jquery\"],e):e(\"object\"==typeof exports?require(\"jquery\"):jQuery)}(function(e){function t(t){var r,i,n,o=arguments.length,s=window[t],a=arguments,u=a[1];if(2>o)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(u)){i={};for(var f in u){r=u[f];try{i[r]=JSON.parse(s.getItem(r))}catch(c){i[r]=s.getItem(r)}}return i}if(2!=o){try{i=JSON.parse(s.getItem(u))}catch(c){throw new ReferenceError(u+\" is not defined in this storage\")}for(var f=2;o-1>f;f++)if(i=i[a[f]],void 0===i)throw new ReferenceError([].slice.call(a,1,f+1).join(\".\")+\" is not defined in this storage\");if(e.isArray(a[f])){n=i,i={};for(var m in a[f])i[a[f][m]]=n[a[f][m]];return i}return i[a[f]]}try{return JSON.parse(s.getItem(u))}catch(c){return s.getItem(u)}}function r(t){var r,i,n=arguments.length,o=window[t],s=arguments,a=s[1],u=s[2],f={};if(2>n||!e.isPlainObject(a)&&3>n)throw Error(\"Minimum 3 arguments must be given or second parameter must be an object\");if(e.isPlainObject(a)){for(var c in a)r=a[c],e.isPlainObject(r)?o.setItem(c,JSON.stringify(r)):o.setItem(c,r);return a}if(3==n)return\"object\"==typeof u?o.setItem(a,JSON.stringify(u)):o.setItem(a,u),u;try{i=o.getItem(a),null!=i&&(f=JSON.parse(i))}catch(m){}i=f;for(var c=2;n-2>c;c++)r=s[c],i[r]&&e.isPlainObject(i[r])||(i[r]={}),i=i[r];return i[s[c]]=s[c+1],o.setItem(a,JSON.stringify(f)),f}function i(t){var r,i,n=arguments.length,o=window[t],s=arguments,a=s[1];if(2>n)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(a)){for(var u in a)o.removeItem(a[u]);return!0}if(2==n)return o.removeItem(a),!0;try{r=i=JSON.parse(o.getItem(a))}catch(f){throw new ReferenceError(a+\" is not defined in this storage\")}for(var u=2;n-1>u;u++)if(i=i[s[u]],void 0===i)throw new ReferenceError([].slice.call(s,1,u).join(\".\")+\" is not defined in this storage\");if(e.isArray(s[u]))for(var c in s[u])delete i[s[u][c]];else delete i[s[u]];return o.setItem(a,JSON.stringify(r)),!0}function n(t,r){var n=a(t);for(var o in n)i(t,n[o]);if(r)for(var o in e.namespaceStorages)u(o)}function o(r){var i=arguments.length,n=arguments,s=(window[r],n[1]);if(1==i)return 0==a(r).length;if(e.isArray(s)){for(var u=0;u<s.length;u++)if(!o(r,s[u]))return!1;return!0}try{var f=t.apply(this,arguments);e.isArray(n[i-1])||(f={totest:f});for(var u in f)if(!(e.isPlainObject(f[u])&&e.isEmptyObject(f[u])||e.isArray(f[u])&&!f[u].length)&&f[u])return!1;return!0}catch(c){return!0}}function s(r){var i=arguments.length,n=arguments,o=(window[r],n[1]);if(2>i)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(o)){for(var a=0;a<o.length;a++)if(!s(r,o[a]))return!1;return!0}try{var u=t.apply(this,arguments);e.isArray(n[i-1])||(u={totest:u});for(var a in u)if(void 0===u[a]||null===u[a])return!1;return!0}catch(f){return!1}}function a(r){var i=arguments.length,n=window[r],o=arguments,s=(o[1],[]),a={};if(a=i>1?t.apply(this,o):n,a._cookie)for(var u in e.cookie())\"\"!=u&&s.push(u.replace(a._prefix,\"\"));else for(var f in a)s.push(f);return s}function u(t){if(!t||\"string\"!=typeof t)throw Error(\"First parameter must be a string\");g?(window.localStorage.getItem(t)||window.localStorage.setItem(t,\"{}\"),window.sessionStorage.getItem(t)||window.sessionStorage.setItem(t,\"{}\")):(window.localCookieStorage.getItem(t)||window.localCookieStorage.setItem(t,\"{}\"),window.sessionCookieStorage.getItem(t)||window.sessionCookieStorage.setItem(t,\"{}\"));var r={localStorage:e.extend({},e.localStorage,{_ns:t}),sessionStorage:e.extend({},e.sessionStorage,{_ns:t})};return e.cookie&&(window.cookieStorage.getItem(t)||window.cookieStorage.setItem(t,\"{}\"),r.cookieStorage=e.extend({},e.cookieStorage,{_ns:t})),e.namespaceStorages[t]=r,r}function f(e){if(!window[e])return!1;var t=\"jsapi\";try{return window[e].setItem(t,t),window[e].removeItem(t),!0}catch(r){return!1}}var c=\"ls_\",m=\"ss_\",g=f(\"localStorage\"),h={_type:\"\",_ns:\"\",_callMethod:function(e,t){var r=[this._type],t=Array.prototype.slice.call(t),i=t[0];return this._ns&&r.push(this._ns),\"string\"==typeof i&&-1!==i.indexOf(\".\")&&(t.shift(),[].unshift.apply(t,i.split(\".\"))),[].push.apply(r,t),e.apply(this,r)},get:function(){return this._callMethod(t,arguments)},set:function(){var t=arguments.length,i=arguments,n=i[0];if(1>t||!e.isPlainObject(n)&&2>t)throw Error(\"Minimum 2 arguments must be given or first parameter must be an object\");if(e.isPlainObject(n)&&this._ns){for(var o in n)r(this._type,this._ns,o,n[o]);return n}var s=this._callMethod(r,i);return this._ns?s[n.split(\".\")[0]]:s},remove:function(){if(arguments.length<1)throw Error(\"Minimum 1 argument must be given\");return this._callMethod(i,arguments)},removeAll:function(e){return this._ns?(r(this._type,this._ns,{}),!0):n(this._type,e)},isEmpty:function(){return this._callMethod(o,arguments)},isSet:function(){if(arguments.length<1)throw Error(\"Minimum 1 argument must be given\");return this._callMethod(s,arguments)},keys:function(){return this._callMethod(a,arguments)}};if(e.cookie){window.name||(window.name=Math.floor(1e8*Math.random()));var l={_cookie:!0,_prefix:\"\",_expires:null,_path:null,_domain:null,setItem:function(t,r){e.cookie(this._prefix+t,r,{expires:this._expires,path:this._path,domain:this._domain})},getItem:function(t){return e.cookie(this._prefix+t)},removeItem:function(t){return e.removeCookie(this._prefix+t)},clear:function(){for(var t in e.cookie())\"\"!=t&&(!this._prefix&&-1===t.indexOf(c)&&-1===t.indexOf(m)||this._prefix&&0===t.indexOf(this._prefix))&&e.removeCookie(t)},setExpires:function(e){return this._expires=e,this},setPath:function(e){return this._path=e,this},setDomain:function(e){return this._domain=e,this},setConf:function(e){return e.path&&(this._path=e.path),e.domain&&(this._domain=e.domain),e.expires&&(this._expires=e.expires),this},setDefaultConf:function(){this._path=this._domain=this._expires=null}};g||(window.localCookieStorage=e.extend({},l,{_prefix:c,_expires:3650}),window.sessionCookieStorage=e.extend({},l,{_prefix:m+window.name+\"_\"})),window.cookieStorage=e.extend({},l),e.cookieStorage=e.extend({},h,{_type:\"cookieStorage\",setExpires:function(e){return window.cookieStorage.setExpires(e),this},setPath:function(e){return window.cookieStorage.setPath(e),this},setDomain:function(e){return window.cookieStorage.setDomain(e),this},setConf:function(e){return window.cookieStorage.setConf(e),this},setDefaultConf:function(){return window.cookieStorage.setDefaultConf(),this}})}e.initNamespaceStorage=function(e){return u(e)},g?(e.localStorage=e.extend({},h,{_type:\"localStorage\"}),e.sessionStorage=e.extend({},h,{_type:\"sessionStorage\"})):(e.localStorage=e.extend({},h,{_type:\"localCookieStorage\"}),e.sessionStorage=e.extend({},h,{_type:\"sessionCookieStorage\"})),e.namespaceStorages={},e.removeAllStorages=function(t){e.localStorage.removeAll(t),e.sessionStorage.removeAll(t),e.cookieStorage&&e.cookieStorage.removeAll(t),t||(e.namespaceStorages={})}});","jquery/jquery.tabs.js":"/* ========================================================\n * bootstrap-tab.js v2.0.4\n * http://twitter.github.com/bootstrap/javascript.html#tabs\n * ========================================================\n * Copyright 2012 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================== */\n\ndefine([\n  \"jquery\"\n], function(jQuery){\n\n\n!function ($) {\n\n  \"use strict\"; // jshint ;_;\n\n\n /* TAB CLASS DEFINITION\n  * ==================== */\n\n  var Tab = function ( element ) {\n    this.element = $(element)\n  };\n\n  Tab.prototype = {\n\n    constructor: Tab\n\n  , show: function () {\n      var $this = this.element\n        , $ul = $this.closest('ul:not(.dropdown-menu)')\n        , selector = $this.attr('data-target')\n        , previous\n        , $target\n        , e;\n\n      if (!selector) {\n        selector = $this.attr('href');\n        selector = selector && selector.replace(/.*(?=#[^\\s]*$)/, ''); //strip for ie7\n      }\n\n      if ( $this.parent('li').hasClass('active') ) return;\n\n      previous = $ul.find('.active a').last()[0];\n\n      e = $.Event('show', {\n        relatedTarget: previous\n      });\n\n      $this.trigger(e);\n\n      if (e.isDefaultPrevented()) return;\n\n      $target = $(selector);\n\n      this.activate($this.parent('li'), $ul);\n      this.activate($target, $target.parent(), function () {\n        $this.trigger({\n          type: 'shown'\n        , relatedTarget: previous\n        })\n      })\n    }\n\n  , activate: function ( element, container, callback) {\n      var $active = container.find('> .active')\n        , transition = callback\n            && $.support.transition\n            && $active.hasClass('fade');\n\n      function next() {\n        $active\n          .removeClass('active')\n          .find('> .dropdown-menu > .active')\n          .removeClass('active');\n\n        element.addClass('active');\n\n        if (transition) {\n          element[0].offsetWidth; // reflow for transition\n          element.addClass('in');\n        } else {\n          element.removeClass('fade')\n        }\n\n        if ( element.parent('.dropdown-menu') ) {\n          element.closest('li.dropdown').addClass('active')\n        }\n\n        callback && callback()\n      }\n\n      transition ?\n        $active.one($.support.transition.end, next) :\n        next();\n\n      $active.removeClass('in')\n    }\n  };\n\n\n /* TAB PLUGIN DEFINITION\n  * ===================== */\n\n  $.fn.tab = function ( option ) {\n    return this.each(function () {\n      var $this = $(this)\n        , data = $this.data('tab');\n      if (!data) $this.data('tab', (data = new Tab(this)));\n      if (typeof option == 'string') data[option]()\n    })\n  };\n\n  $.fn.tab.Constructor = Tab;\n\n\n /* TAB DATA-API\n  * ============ */\n\n  $(function () {\n    $('body').on('click.tab.data-api', '[data-toggle=\"tab\"], [data-toggle=\"pill\"]', function (e) {\n      e.preventDefault();\n      $(this).tab('show')\n    })\n  })\n\n}(jQuery);\n\n/* =============================================================\n * bootstrap-collapse.js v2.0.4\n * http://twitter.github.com/bootstrap/javascript.html#collapse\n * =============================================================\n * Copyright 2012 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ============================================================ */\n\n\n!function ($) {\n\n  \"use strict\"; // jshint ;_;\n\n\n /* COLLAPSE PUBLIC CLASS DEFINITION\n  * ================================ */\n\n  var Collapse = function (element, options) {\n    this.$element = $(element);\n    this.options = $.extend({}, $.fn.collapse.defaults, options);\n\n    if (this.options.parent) {\n      this.$parent = $(this.options.parent)\n    }\n\n    this.options.toggle && this.toggle()\n  };\n\n  Collapse.prototype = {\n\n    constructor: Collapse\n\n  , dimension: function () {\n      var hasWidth = this.$element.hasClass('width');\n      return hasWidth ? 'width' : 'height'\n    }\n\n  , show: function () {\n      var dimension\n        , scroll\n        , actives\n        , hasData;\n\n      if (this.transitioning) return;\n\n      dimension = this.dimension();\n      scroll = $.camelCase(['scroll', dimension].join('-'));\n      actives = this.$parent && this.$parent.find('> .accordion-group > .in');\n\n      if (actives && actives.length) {\n        hasData = actives.data('collapse');\n        if (hasData && hasData.transitioning) return;\n        actives.collapse('hide');\n        hasData || actives.data('collapse', null)\n      }\n\n      this.$element[dimension](0);\n      this.transition('addClass', $.Event('show'), 'shown');\n      this.$element[dimension](this.$element[0][scroll]);\n    }\n\n  , hide: function () {\n      var dimension;\n      if (this.transitioning) return;\n      dimension = this.dimension();\n      this.reset(this.$element[dimension]());\n      this.transition('removeClass', $.Event('hide'), 'hidden');\n      this.$element[dimension](0)\n    }\n\n  , reset: function (size) {\n      var dimension = this.dimension();\n\n      this.$element\n        .removeClass('collapse')\n        [dimension](size || 'auto')\n        [0].offsetWidth;\n\n      this.$element[size !== null ? 'addClass' : 'removeClass']('collapse');\n\n      return this\n    }\n\n  , transition: function (method, startEvent, completeEvent) {\n      var that = this\n        , complete = function () {\n            if (startEvent.type == 'show') that.reset();\n            that.transitioning = 0;\n            that.$element.trigger(completeEvent)\n          };\n\n      this.$element.trigger(startEvent);\n\n      if (startEvent.isDefaultPrevented()) return;\n\n      this.transitioning = 1;\n\n      this.$element[method]('in');\n\n      $.support.transition && this.$element.hasClass('collapse') ?\n        this.$element.one($.support.transition.end, complete) :\n        complete()\n    }\n\n  , toggle: function () {\n      this[this.$element.hasClass('in') ? 'hide' : 'show']();\n    }\n\n  };\n\n\n /* COLLAPSIBLE PLUGIN DEFINITION\n  * ============================== */\n\n  $.fn.collapse = function (option) {\n    return this.each(function () {\n      var $this = $(this)\n        , data = $this.data('collapse')\n        , options = typeof option == 'object' && option;\n      if (!data) $this.data('collapse', (data = new Collapse(this, options)));\n      if (typeof option == 'string') data[option]()\n    })\n  };\n\n  $.fn.collapse.defaults = {\n    toggle: true\n  };\n\n  $.fn.collapse.Constructor = Collapse;\n\n\n /* COLLAPSIBLE DATA-API\n  * ==================== */\n\n  $(function () {\n    $('body').on('click.collapse.data-api', '[data-toggle=collapse]', function ( e ) {\n      var $this = $(this), href\n        , target = $this.attr('data-target')\n          || e.preventDefault()\n          || (href = $this.attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '') //strip for ie7\n        , option = $(target).data('collapse') ? 'toggle' : $this.data();\n      $(target).collapse(option);\n        $(this).toggleClass('active');\n    })\n  })\n\n}(jQuery);\n\n});","jquery/jquery.validate.js":"/**\n * jQuery Validation Plugin @VERSION\n *\n * http://bassistance.de/jquery-plugins/jquery-plugin-validation/\n * http://docs.jquery.com/Plugins/Validation\n *\n * Copyright (c) 2012 J\u00c3\u00b6rn Zaefferer\n *\n * Dual licensed under the MIT and GPL licenses:\n *   http://www.opensource.org/licenses/mit-license.php\n *   http://www.gnu.org/licenses/gpl.html\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/jquery.metadata\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function (jQuery) {\n\n(function ($) {\n\n    $.extend($.fn, {\n        // http://docs.jquery.com/Plugins/Validation/validate\n        validate: function (options) {\n\n            // if nothing is selected, return nothing; can't chain anyway\n            if (!this.length) {\n                if (options && options.debug && window.console) {\n                    console.warn(\"nothing selected, can't validate, returning nothing\");\n                }\n                return;\n            }\n\n            // check if a validator for this form was already created\n            var validator = $.data(this[0], 'validator');\n            if (validator) {\n                return validator;\n            }\n\n            // Add novalidate tag if HTML5.\n            this.attr('novalidate', 'novalidate');\n\n            validator = new $.validator(options, this[0]);\n            $.data(this[0], 'validator', validator);\n\n            if (validator.settings.onsubmit) {\n\n                this.validateDelegate(\":submit\", \"click\", function (ev) {\n                    if (validator.settings.submitHandler) {\n                        validator.submitButton = ev.target;\n                    }\n                    // allow suppressing validation by adding a cancel class to the submit button\n                    if ($(ev.target).hasClass('cancel')) {\n                        validator.cancelSubmit = true;\n                    }\n                });\n\n                // validate the form on submit\n                this.submit(function (event) {\n                    if (validator.settings.debug) {\n                        // prevent form submit to be able to see console output\n                        event.preventDefault();\n                    }\n                    function handle() {\n                        var hidden;\n                        if (validator.settings.submitHandler) {\n                            if (validator.submitButton) {\n                                // insert a hidden input as a replacement for the missing submit button\n                                hidden = $(\"<input type='hidden'/>\").attr(\"name\", validator.submitButton.name).val(validator.submitButton.value).appendTo(validator.currentForm);\n                            }\n                            validator.settings.submitHandler.call(validator, validator.currentForm, event);\n                            if (validator.submitButton) {\n                                // and clean up afterwards; thanks to no-block-scope, hidden can be referenced\n                                hidden.remove();\n                            }\n                            return false;\n                        }\n                        return true;\n                    }\n\n                    // prevent submit for invalid forms or custom submit handlers\n                    if (validator.cancelSubmit) {\n                        validator.cancelSubmit = false;\n                        return handle();\n                    }\n                    if (validator.form()) {\n                        if (validator.pendingRequest) {\n                            validator.formSubmitted = true;\n                            return false;\n                        }\n                        return handle();\n                    } else {\n                        validator.focusInvalid();\n                        return false;\n                    }\n                });\n            }\n\n            return validator;\n        },\n        // http://docs.jquery.com/Plugins/Validation/valid\n        valid: function () {\n            if ($(this[0]).is('form')) {\n                return this.validate().form();\n            } else {\n                var valid = true;\n                var validator = $(this[0].form).validate();\n                this.each(function () {\n                    valid &= validator.element(this);\n                });\n                return valid;\n            }\n        },\n        // attributes: space seperated list of attributes to retrieve and remove\n        removeAttrs: function (attributes) {\n            var result = {},\n                $element = this;\n            $.each(attributes.split(/\\s/), function (index, value) {\n                result[value] = $element.attr(value);\n                $element.removeAttr(value);\n            });\n            return result;\n        },\n        // http://docs.jquery.com/Plugins/Validation/rules\n        rules: function (command, argument) {\n            var element = this[0];\n\n            if (command) {\n                var settings = $.data(element.form, 'validator').settings;\n                var staticRules = settings.rules;\n                var existingRules = $.validator.staticRules(element);\n                switch (command) {\n                    case \"add\":\n                        $.extend(existingRules, $.validator.normalizeRule(argument));\n                        staticRules[element.name] = existingRules;\n                        if (argument.messages) {\n                            settings.messages[element.name] = $.extend(settings.messages[element.name], argument.messages);\n                        }\n                        break;\n                    case \"remove\":\n                        if (!argument) {\n                            delete staticRules[element.name];\n                            return existingRules;\n                        }\n                        var filtered = {};\n                        $.each(argument.split(/\\s/), function (index, method) {\n                            filtered[method] = existingRules[method];\n                            delete existingRules[method];\n                        });\n                        return filtered;\n                }\n            }\n\n            var data = $.validator.normalizeRules(\n                $.extend(\n                    {},\n                    $.validator.metadataRules(element),\n                    $.validator.classRules(element),\n                    $.validator.attributeRules(element),\n                    $.validator.staticRules(element)\n                ), element);\n\n            // make sure required is at front\n            if (data.required) {\n                var param = data.required;\n                delete data.required;\n                data = $.extend({required: param}, data);\n            }\n\n            return data;\n        }\n    });\n\n// Custom selectors\n    $.extend($.expr[\":\"], {\n        // http://docs.jquery.com/Plugins/Validation/blank\n        blank: function (a) {\n            return !$.trim(\"\" + a.value);\n        },\n        // http://docs.jquery.com/Plugins/Validation/filled\n        filled: function (a) {\n            return !!$.trim(\"\" + a.value);\n        },\n        // http://docs.jquery.com/Plugins/Validation/unchecked\n        unchecked: function (a) {\n            return !a.checked;\n        }\n    });\n\n// constructor for validator\n    $.validator = function (options, form) {\n        this.settings = $.extend(true, {}, $.validator.defaults, options);\n        this.currentForm = form;\n        this.init();\n    };\n\n    $.validator.format = function (source, params) {\n        if (arguments.length === 1) {\n            return function () {\n                var args = $.makeArray(arguments);\n                args.unshift(source);\n                return $.validator.format.apply(this, args);\n            };\n        }\n        if (arguments.length > 2 && params.constructor !== Array) {\n            params = $.makeArray(arguments).slice(1);\n        }\n        if (params.constructor !== Array) {\n            params = [ params ];\n        }\n        $.each(params, function (i, n) {\n            source = source.replace(new RegExp(\"\\\\{\" + i + \"\\\\}\", \"g\"), n);\n        });\n        return source;\n    };\n\n    $.extend($.validator, {\n\n        defaults: {\n            messages: {},\n            groups: {},\n            rules: {},\n            errorClass: \"error\",\n            validClass: \"valid\",\n            errorElement: \"label\",\n            focusInvalid: true,\n            errorContainer: $([]),\n            errorLabelContainer: $([]),\n            onsubmit: true,\n            ignore: \":hidden\",\n            ignoreTitle: false,\n            onfocusin: function (element, event) {\n                this.lastActive = element;\n\n                // hide error label and remove error class on focus if enabled\n                if (this.settings.focusCleanup && !this.blockFocusCleanup) {\n                    if (this.settings.unhighlight) {\n                        this.settings.unhighlight.call(this, element, this.settings.errorClass, this.settings.validClass);\n                    }\n                    this.addWrapper(this.errorsFor(element)).hide();\n                }\n            },\n            onfocusout: function (element, event) {\n                if (!this.checkable(element) && (element.name in this.submitted || !this.optional(element))) {\n                    this.element(element);\n                }\n            },\n            onkeyup: function (element, event) {\n                if (event.which == 9 && this.elementValue(element) === '') {\n                    return;\n                } else if (element.name in this.submitted || element === this.lastActive) {\n                    this.element(element);\n                }\n            },\n            onclick: function (element, event) {\n                // click on selects, radiobuttons and checkboxes\n                if (element.name in this.submitted) {\n                    this.element(element);\n                }\n                // or option elements, check parent select in that case\n                else if (element.parentNode.name in this.submitted) {\n                    this.element(element.parentNode);\n                }\n            },\n            highlight: function (element, errorClass, validClass) {\n                if (element.type === 'radio') {\n                    this.findByName(element.name).addClass(errorClass).removeClass(validClass);\n                } else {\n                    $(element).addClass(errorClass).removeClass(validClass);\n                }\n            },\n            unhighlight: function (element, errorClass, validClass) {\n                if (element.type === 'radio') {\n                    this.findByName(element.name).removeClass(errorClass).addClass(validClass);\n                } else {\n                    $(element).removeClass(errorClass).addClass(validClass);\n                }\n            }\n        },\n\n        // http://docs.jquery.com/Plugins/Validation/Validator/setDefaults\n        setDefaults: function (settings) {\n            $.extend($.validator.defaults, settings);\n        },\n\n        messages: {\n            required: \"This field is required.\",\n            remote: \"Please fix this field.\",\n            email: \"Please enter a valid email address.\",\n            url: \"Please enter a valid URL.\",\n            date: \"Please enter a valid date.\",\n            dateISO: \"Please enter a valid date (ISO).\",\n            number: \"Please enter a valid number.\",\n            digits: \"Please enter only digits.\",\n            creditcard: \"Please enter a valid credit card number.\",\n            equalTo: \"Please enter the same value again.\",\n            maxlength: $.validator.format(\"Please enter no more than {0} characters.\"),\n            minlength: $.validator.format(\"Please enter at least {0} characters.\"),\n            rangelength: $.validator.format(\"Please enter a value between {0} and {1} characters long.\"),\n            range: $.validator.format(\"Please enter a value between {0} and {1}.\"),\n            max: $.validator.format(\"Please enter a value less than or equal to {0}.\"),\n            min: $.validator.format(\"Please enter a value greater than or equal to {0}.\")\n        },\n\n        autoCreateRanges: false,\n\n        prototype: {\n\n            init: function () {\n                this.labelContainer = $(this.settings.errorLabelContainer);\n                this.errorContext = this.labelContainer.length && this.labelContainer || $(this.currentForm);\n                this.containers = $(this.settings.errorContainer).add(this.settings.errorLabelContainer);\n                this.submitted = {};\n                this.valueCache = {};\n                this.pendingRequest = 0;\n                this.pending = {};\n                this.invalid = {};\n                this.reset();\n\n                var groups = (this.groups = {});\n                $.each(this.settings.groups, function (key, value) {\n                    $.each(value.split(/\\s/), function (index, name) {\n                        groups[name] = key;\n                    });\n                });\n                var rules = this.settings.rules;\n                $.each(rules, function (key, value) {\n                    rules[key] = $.validator.normalizeRule(value);\n                });\n\n                function delegate(event) {\n                    var validator = $.data(this[0].form, \"validator\"),\n                        eventType = \"on\" + event.type.replace(/^validate/, \"\");\n                    if (validator.settings[eventType]) {\n                        validator.settings[eventType].call(validator, this[0], event);\n                    }\n                }\n\n                $(this.currentForm)\n                    .validateDelegate(\":text, [type='password'], [type='file'], select, textarea, \" +\n                    \"[type='number'], [type='search'], input.search, [type='tel'], [type='url'], \" +\n                    \"[type='email'], [type='datetime'], [type='date'], [type='month'], \" +\n                    \"[type='week'], [type='time'], [type='datetime-local'], \" +\n                    \"[type='range'], [type='color'] \",\n                    \"focusin focusout keyup\", delegate)\n                    .validateDelegate(\"[type='radio'], [type='checkbox'], select, option\", \"click\", delegate);\n\n                if (this.settings.invalidHandler) {\n                    $(this.currentForm).bind(\"invalid-form.validate\", this.settings.invalidHandler);\n                }\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/form\n            form: function () {\n                this.checkForm();\n                $.extend(this.submitted, this.errorMap);\n                this.invalid = $.extend({}, this.errorMap);\n                if (!this.valid()) {\n                    $(this.currentForm).triggerHandler(\"invalid-form\", [this]);\n                }\n                this.showErrors();\n                return this.valid();\n            },\n\n            checkForm: function () {\n                this.prepareForm();\n                for (var i = 0, elements = (this.currentElements = this.elements()); elements[i]; i++) {\n                    this.check(elements[i]);\n                }\n                return this.valid();\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/element\n            element: function (element) {\n                element = this.validationTargetFor(this.clean(element));\n                this.lastElement = element;\n                this.prepareElement(element);\n                this.currentElements = $(element);\n                var result = this.check(element) !== false;\n                if (result) {\n                    delete this.invalid[element.name];\n                } else {\n                    this.invalid[element.name] = true;\n                }\n                if (!this.numberOfInvalids()) {\n                    // Hide error containers on last error\n                    this.toHide = this.toHide.add(this.containers);\n                }\n                this.showErrors();\n                return result;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/showErrors\n            showErrors: function (errors) {\n                if (errors) {\n                    // add items to error list and map\n                    $.extend(this.errorMap, errors);\n                    this.errorList = [];\n                    for (var name in errors) {\n                        this.errorList.push({\n                            message: errors[name],\n                            element: this.findByName(name)[0]\n                        });\n                    }\n                    // remove items from success list\n                    this.successList = $.grep(this.successList, function (element) {\n                        return !(element.name in errors);\n                    });\n                }\n                if (this.settings.showErrors) {\n                    this.settings.showErrors.call(this, this.errorMap, this.errorList);\n                } else {\n                    this.defaultShowErrors();\n                }\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/resetForm\n            resetForm: function () {\n                if ($.fn.resetForm) {\n                    $(this.currentForm).resetForm();\n                }\n                this.submitted = {};\n                this.lastElement = null;\n                this.prepareForm();\n                this.hideErrors();\n                this.elements().removeClass(this.settings.errorClass).removeData(\"previousValue\");\n            },\n\n            numberOfInvalids: function () {\n                return this.objectLength(this.invalid);\n            },\n\n            objectLength: function (obj) {\n                var count = 0;\n                for (var i in obj) {\n                    count++;\n                }\n                return count;\n            },\n\n            hideErrors: function () {\n                this.addWrapper(this.toHide).hide();\n            },\n\n            valid: function () {\n                return this.size() === 0;\n            },\n\n            size: function () {\n                return this.errorList.length;\n            },\n\n            focusInvalid: function () {\n                if (this.settings.focusInvalid) {\n                    try {\n                        $(this.findLastActive() || this.errorList.length && this.errorList[0].element || [])\n                            .filter(\":visible\")\n                            .focus()\n                            // manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find\n                            .trigger(\"focusin\");\n                    } catch (e) {\n                        // ignore IE throwing errors when focusing hidden elements\n                    }\n                }\n            },\n\n            findLastActive: function () {\n                var lastActive = this.lastActive;\n                return lastActive && $.grep(this.errorList,function (n) {\n                    return n.element.name === lastActive.name;\n                }).length === 1 && lastActive;\n            },\n\n            elements: function () {\n                var validator = this,\n                    rulesCache = {};\n\n                // select all valid inputs inside the form (no submit or reset buttons)\n                return $(this.currentForm)\n                    .find(\"input, select, textarea\")\n                    .not(\":submit, :reset, :image, [disabled]\")\n                    .not(this.settings.ignore)\n                    .filter(function () {\n                        if (!this.name && validator.settings.debug && window.console) {\n                            console.error(\"%o has no name assigned\", this);\n                        }\n\n                        // select only the first element for each name, and only those with rules specified\n                        if (this.name in rulesCache || !validator.objectLength($(this).rules())) {\n                            return false;\n                        }\n\n                        rulesCache[this.name] = true;\n                        return true;\n                    });\n            },\n\n            clean: function (selector) {\n                return $(selector)[0];\n            },\n\n            errors: function () {\n                var errorClass = this.settings.errorClass.replace(' ', '.');\n                return $(this.settings.errorElement + \".\" + errorClass, this.errorContext);\n            },\n\n            reset: function () {\n                this.successList = [];\n                this.errorList = [];\n                this.errorMap = {};\n                this.toShow = $([]);\n                this.toHide = $([]);\n                this.currentElements = $([]);\n            },\n\n            prepareForm: function () {\n                this.reset();\n                this.toHide = this.errors().add(this.containers);\n            },\n\n            prepareElement: function (element) {\n                this.reset();\n                this.toHide = this.errorsFor(element);\n            },\n\n            elementValue: function (element) {\n                var type = $(element).attr('type'),\n                    val = $(element).val();\n\n                if (type === 'radio' || type === 'checkbox') {\n                    return $('input[name=\"' + $(element).attr('name') + '\"]:checked').val();\n                }\n\n                if (typeof val === 'string') {\n                    return val.replace(/\\r/g, \"\");\n                }\n                return val;\n            },\n\n            check: function (element) {\n                element = this.validationTargetFor(this.clean(element));\n\n                var rules = $(element).rules();\n                var dependencyMismatch = false;\n                var val = this.elementValue(element);\n                var result;\n\n                for (var method in rules) {\n                    var rule = { method: method, parameters: rules[method] };\n                    try {\n\n                        result = $.validator.methods[method].call(this, val, element, rule.parameters);\n\n                        // if a method indicates that the field is optional and therefore valid,\n                        // don't mark it as valid when there are no other rules\n                        if (result === \"dependency-mismatch\") {\n                            dependencyMismatch = true;\n                            continue;\n                        }\n                        dependencyMismatch = false;\n\n                        if (result === \"pending\") {\n                            this.toHide = this.toHide.not(this.errorsFor(element));\n                            return;\n                        }\n\n                        if (!result) {\n                            this.formatAndAdd(element, rule);\n                            return false;\n                        }\n                    } catch (e) {\n                        if (this.settings.debug && window.console) {\n                            console.log(\"exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method\", e);\n                        }\n                        throw e;\n                    }\n                }\n                if (dependencyMismatch) {\n                    return;\n                }\n                if (this.objectLength(rules)) {\n                    this.successList.push(element);\n                }\n                return true;\n            },\n\n            // return the custom message for the given element and validation method\n            // specified in the element's \"messages\" metadata\n            customMetaMessage: function (element, method) {\n                if (!$.metadata) {\n                    return;\n                }\n                var meta = this.settings.meta ? $(element).metadata()[this.settings.meta] : $(element).metadata();\n                return meta && meta.messages && meta.messages[method];\n            },\n\n            // return the custom message for the given element and validation method\n            // specified in the element's HTML5 data attribute\n            customDataMessage: function (element, method) {\n                return $(element).data('msg-' + method.toLowerCase()) || (element.attributes && $(element).attr('data-msg-' + method.toLowerCase()));\n            },\n\n            // return the custom message for the given element name and validation method\n            customMessage: function (name, method) {\n                var m = this.settings.messages[name];\n                return m && (m.constructor === String ? m : m[method]);\n            },\n\n            // return the first defined argument, allowing empty strings\n            findDefined: function () {\n                for (var i = 0; i < arguments.length; i++) {\n                    if (arguments[i] !== undefined) {\n                        return arguments[i];\n                    }\n                }\n                return undefined;\n            },\n\n            defaultMessage: function (element, method) {\n                var noMessage = $.mage.__(\"Warning: No message defined for %s\");\n                return this.findDefined(\n                    this.customMessage(element.name, method),\n                    this.customDataMessage(element, method),\n                    this.customMetaMessage(element, method),\n                    // title is never undefined, so handle empty string as undefined\n                    !this.settings.ignoreTitle && element.title || undefined,\n                    $.validator.messages[method],\n                    \"<strong>\" + noMessage.replace('%s', element.name) + \"</strong>\"\n                );\n            },\n\n            formatAndAdd: function (element, rule) {\n                var message = this.defaultMessage(element, rule.method),\n                    theregex = /\\$?\\{(\\d+)\\}/g;\n                if (typeof message === \"function\") {\n                    message = message.call(this, rule.parameters, element);\n                } else if (theregex.test(message)) {\n                    message = $.validator.format(message.replace(theregex, '{$1}'), rule.parameters);\n                }\n                this.errorList.push({\n                    message: message,\n                    element: element\n                });\n\n                this.errorMap[element.name] = message;\n                this.submitted[element.name] = message;\n            },\n\n            addWrapper: function (toToggle) {\n                if (this.settings.wrapper) {\n                    toToggle = toToggle.add(toToggle.parent(this.settings.wrapper));\n                }\n                return toToggle;\n            },\n\n            defaultShowErrors: function () {\n                var i, elements;\n                for (i = 0; this.errorList[i]; i++) {\n                    var error = this.errorList[i];\n                    if (this.settings.highlight) {\n                        this.settings.highlight.call(this, error.element, this.settings.errorClass, this.settings.validClass);\n                    }\n                    this.showLabel(error.element, error.message);\n                }\n                if (this.errorList.length) {\n                    this.toShow = this.toShow.add(this.containers);\n                }\n                if (this.settings.success) {\n                    for (i = 0; this.successList[i]; i++) {\n                        this.showLabel(this.successList[i]);\n                    }\n                }\n                if (this.settings.unhighlight) {\n                    for (i = 0, elements = this.validElements(); elements[i]; i++) {\n                        this.settings.unhighlight.call(this, elements[i], this.settings.errorClass, this.settings.validClass);\n                    }\n                }\n                this.toHide = this.toHide.not(this.toShow);\n                this.hideErrors();\n                this.addWrapper(this.toShow).show();\n            },\n\n            validElements: function () {\n                return this.currentElements.not(this.invalidElements());\n            },\n\n            invalidElements: function () {\n                return $(this.errorList).map(function () {\n                    return this.element;\n                });\n            },\n\n            showLabel: function (element, message) {\n                var label = this.errorsFor(element);\n                if (label.length) {\n                    // refresh error/success class\n                    label.removeClass(this.settings.validClass).addClass(this.settings.errorClass);\n\n                    // check if we have a generated label, replace the message then\n                    if (label.attr(\"generated\")) {\n                        label.hide().html(message);\n                    }\n                } else {\n                    // create label\n                    label = $(\"<\" + this.settings.errorElement + \"/>\")\n                        .attr({\"for\": this.idOrName(element), generated: true})\n                        .addClass(this.settings.errorClass)\n                        .html(message || \"\");\n                    if (this.settings.wrapper) {\n                        // make sure the element is visible, even in IE\n                        // actually showing the wrapped element is handled elsewhere\n                        label = label.hide().show().wrap(\"<\" + this.settings.wrapper + \"/>\").parent();\n                    }\n                    if (!this.labelContainer.append(label).length) {\n                        if (this.settings.errorPlacement) {\n                            this.settings.errorPlacement(label, $(element));\n                        } else {\n                            label.insertAfter(element);\n                        }\n                    }\n                }\n                if (!message && this.settings.success) {\n                    label.text(\"\");\n                    if (typeof this.settings.success === \"string\") {\n                        label.addClass(this.settings.success);\n                    } else {\n                        this.settings.success(label, element);\n                    }\n                }\n                this.toShow = this.toShow.add(label);\n            },\n\n            errorsFor: function (element) {\n                var name = this.idOrName(element);\n                return this.errors().filter(function () {\n                    return $(this).attr('for') === name;\n                });\n            },\n\n            idOrName: function (element) {\n                return this.groups[element.name] || (this.checkable(element) ? element.name : element.id || element.name);\n            },\n\n            validationTargetFor: function (element) {\n                // if radio/checkbox, validate first element in group instead\n                if (this.checkable(element)) {\n                    element = this.findByName(element.name).not(this.settings.ignore)[0];\n                }\n                return element;\n            },\n\n            checkable: function (element) {\n                return (/radio|checkbox/i).test(element.type);\n            },\n\n            findByName: function (name) {\n                return $(this.currentForm).find('[name=\"' + name + '\"]');\n            },\n\n            getLength: function (value, element) {\n                switch (element.nodeName.toLowerCase()) {\n                    case 'select':\n                        return $(\"option:selected\", element).length;\n                    case 'input':\n                        if (this.checkable(element)) {\n                            return this.findByName(element.name).filter(':checked').length;\n                        }\n                }\n                return value.length;\n            },\n\n            depend: function (param, element) {\n                return this.dependTypes[typeof param] ? this.dependTypes[typeof param](param, element) : true;\n            },\n\n            dependTypes: {\n                \"boolean\": function (param, element) {\n                    return param;\n                },\n                \"string\": function (param, element) {\n                    return !!$(param, element.form).length;\n                },\n                \"function\": function (param, element) {\n                    return param(element);\n                }\n            },\n\n            optional: function (element) {\n                var val = this.elementValue(element);\n                return !$.validator.methods.required.call(this, val, element) && \"dependency-mismatch\";\n            },\n\n            startRequest: function (element) {\n                if (!this.pending[element.name]) {\n                    this.pendingRequest++;\n                    this.pending[element.name] = true;\n                }\n            },\n\n            stopRequest: function (element, valid) {\n                this.pendingRequest--;\n                // sometimes synchronization fails, make sure pendingRequest is never < 0\n                if (this.pendingRequest < 0) {\n                    this.pendingRequest = 0;\n                }\n                delete this.pending[element.name];\n                if (valid && this.pendingRequest === 0 && this.formSubmitted && this.form()) {\n                    $(this.currentForm).submit();\n                    this.formSubmitted = false;\n                } else if (!valid && this.pendingRequest === 0 && this.formSubmitted) {\n                    $(this.currentForm).triggerHandler(\"invalid-form\", [this]);\n                    this.formSubmitted = false;\n                }\n            },\n\n            previousValue: function (element) {\n                return $.data(element, \"previousValue\") || $.data(element, \"previousValue\", {\n                    old: null,\n                    valid: true,\n                    message: this.defaultMessage(element, \"remote\")\n                });\n            }\n\n        },\n\n        classRuleSettings: {\n            required: {required: true},\n            email: {email: true},\n            url: {url: true},\n            date: {date: true},\n            dateISO: {dateISO: true},\n            number: {number: true},\n            digits: {digits: true},\n            creditcard: {creditcard: true}\n        },\n\n        addClassRules: function (className, rules) {\n            if (className.constructor === String) {\n                this.classRuleSettings[className] = rules;\n            } else {\n                $.extend(this.classRuleSettings, className);\n            }\n        },\n\n        classRules: function (element) {\n            var rules = {};\n            var classes = $(element).attr('class');\n            if (classes) {\n                $.each(classes.split(' '), function () {\n                    if (this in $.validator.classRuleSettings) {\n                        $.extend(rules, $.validator.classRuleSettings[this]);\n                    }\n                });\n            }\n            return rules;\n        },\n\n        attributeRules: function (element) {\n            var rules = {};\n            var $element = $(element);\n\n            for (var method in $.validator.methods) {\n                var value;\n\n                // support for <input required> in both html5 and older browsers\n                if (method === 'required') {\n                    value = $element.get(0).getAttribute(method);\n                    // Some browsers return an empty string for the required attribute\n                    // and non-HTML5 browsers might have required=\"\" markup\n                    if (value === \"\") {\n                        value = true;\n                    }\n                    // force non-HTML5 browsers to return bool\n                    value = !!value;\n                } else {\n                    value = $element.attr(method);\n                }\n\n                if (value) {\n                    rules[method] = value;\n                } else if ($element[0].getAttribute(\"type\") === method) {\n                    rules[method] = true;\n                }\n            }\n\n            // maxlength may be returned as -1, 2147483647 (IE) and 524288 (safari) for text inputs\n            if (rules.maxlength && /-1|2147483647|524288/.test(rules.maxlength)) {\n                delete rules.maxlength;\n            }\n\n            return rules;\n        },\n\n        metadataRules: function (element) {\n            if (!$.metadata) {\n                return {};\n            }\n\n            var meta = $.data(element.form, 'validator').settings.meta;\n            return meta ?\n                $(element).metadata()[meta] :\n                $(element).metadata();\n        },\n\n        staticRules: function (element) {\n            var rules = {};\n            var validator = $.data(element.form, 'validator');\n            if (validator.settings.rules) {\n                rules = $.validator.normalizeRule(validator.settings.rules[element.name]) || {};\n            }\n            return rules;\n        },\n\n        normalizeRules: function (rules, element) {\n            // handle dependency check\n            $.each(rules, function (prop, val) {\n                // ignore rule when param is explicitly false, eg. required:false\n                if (val === false) {\n                    delete rules[prop];\n                    return;\n                }\n                if (val.param || val.depends) {\n                    var keepRule = true;\n                    switch (typeof val.depends) {\n                        case \"string\":\n                            keepRule = !!$(val.depends, element.form).length;\n                            break;\n                        case \"function\":\n                            keepRule = val.depends.call(element, element);\n                            break;\n                    }\n                    if (keepRule) {\n                        rules[prop] = val.param !== undefined ? val.param : true;\n                    } else {\n                        delete rules[prop];\n                    }\n                }\n            });\n\n            // evaluate parameters\n            $.each(rules, function (rule, parameter) {\n                rules[rule] = $.isFunction(parameter) ? parameter(element) : parameter;\n            });\n\n            // clean number parameters\n            $.each(['minlength', 'maxlength', 'min', 'max'], function () {\n                if (rules[this]) {\n                    rules[this] = Number(rules[this]);\n                }\n            });\n            $.each(['rangelength', 'range'], function () {\n                if (rules[this]) {\n                    rules[this] = [Number(rules[this][0]), Number(rules[this][1])];\n                }\n            });\n\n            if ($.validator.autoCreateRanges) {\n                // auto-create ranges\n                if (rules.min && rules.max) {\n                    rules.range = [rules.min, rules.max];\n                    delete rules.min;\n                    delete rules.max;\n                }\n                if (rules.minlength && rules.maxlength) {\n                    rules.rangelength = [rules.minlength, rules.maxlength];\n                    delete rules.minlength;\n                    delete rules.maxlength;\n                }\n            }\n\n            // To support custom messages in metadata ignore rule methods titled \"messages\"\n            if (rules.messages) {\n                delete rules.messages;\n            }\n\n            return rules;\n        },\n\n        // Converts a simple string to a {string: true} rule, e.g., \"required\" to {required:true}\n        normalizeRule: function (data) {\n            if (typeof data === \"string\") {\n                var transformed = {};\n                $.each(data.split(/\\s/), function () {\n                    transformed[this] = true;\n                });\n                data = transformed;\n            }\n            return data;\n        },\n\n        // http://docs.jquery.com/Plugins/Validation/Validator/addMethod\n        addMethod: function (name, method, message) {\n            $.validator.methods[name] = method;\n            $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];\n            if (method.length < 3) {\n                $.validator.addClassRules(name, $.validator.normalizeRule(name));\n            }\n        },\n\n        methods: {\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/required\n            required: function (value, element, param) {\n                // check if dependency is met\n                if (!this.depend(param, element)) {\n                    return \"dependency-mismatch\";\n                }\n                if (element.nodeName.toLowerCase() === \"select\") {\n                    // could be an array for select-multiple or a string, both are fine this way\n                    var val = $(element).val();\n                    return val && val.length > 0;\n                }\n                if (this.checkable(element)) {\n                    return this.getLength(value, element) > 0;\n                }\n                return $.trim(value).length > 0;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/remote\n            remote: function (value, element, param) {\n                if (this.optional(element)) {\n                    return \"dependency-mismatch\";\n                }\n\n                var previous = this.previousValue(element);\n                if (!this.settings.messages[element.name]) {\n                    this.settings.messages[element.name] = {};\n                }\n                previous.originalMessage = this.settings.messages[element.name].remote;\n                this.settings.messages[element.name].remote = previous.message;\n\n                param = typeof param === \"string\" && {url: param} || param;\n\n                if (this.pending[element.name]) {\n                    return \"pending\";\n                }\n                if (previous.old === value) {\n                    return previous.valid;\n                }\n\n                previous.old = value;\n                var validator = this;\n                this.startRequest(element);\n                var data = {};\n                data[element.name] = value;\n                $.ajax($.extend(true, {\n                    url: param,\n                    mode: \"abort\",\n                    port: \"validate\" + element.name,\n                    dataType: \"json\",\n                    data: data,\n                    success: function (response) {\n                        validator.settings.messages[element.name].remote = previous.originalMessage;\n                        var valid = response === true || response === \"true\";\n                        if (valid) {\n                            var submitted = validator.formSubmitted;\n                            validator.prepareElement(element);\n                            validator.formSubmitted = submitted;\n                            validator.successList.push(element);\n                            delete validator.invalid[element.name];\n                            validator.showErrors();\n                        } else {\n                            var errors = {};\n                            var message = response || validator.defaultMessage(element, \"remote\");\n                            errors[element.name] = previous.message = $.isFunction(message) ? message(value) : message;\n                            validator.invalid[element.name] = true;\n                            validator.showErrors(errors);\n                        }\n                        previous.valid = valid;\n                        validator.stopRequest(element, valid);\n                    }\n                }, param));\n                return \"pending\";\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/minlength\n            minlength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || length >= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/maxlength\n            maxlength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || length <= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/rangelength\n            rangelength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || ( length >= param[0] && length <= param[1] );\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/min\n            min: function (value, element, param) {\n                return this.optional(element) || value >= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/max\n            max: function (value, element, param) {\n                return this.optional(element) || value <= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/range\n            range: function (value, element, param) {\n                return this.optional(element) || ( value >= param[0] && value <= param[1] );\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/email\n            email: function (value, element) {\n                // contributed by Scott Gonzalez: http://projects.scottsplayground.com/email_address_validation/\n                return this.optional(element) || /^((([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\x22)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\x22)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))$/i.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/url\n            url: function (value, element) {\n                // contributed by Scott Gonzalez: http://projects.scottsplayground.com/iri/\n                return this.optional(element) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/date\n            date: function (value, element) {\n                return this.optional(element) || !/Invalid|NaN/.test(new Date(value));\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/dateISO\n            dateISO: function (value, element) {\n                return this.optional(element) || /^\\d{4}[\\/\\-]\\d{1,2}[\\/\\-]\\d{1,2}$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/number\n            number: function (value, element) {\n                return this.optional(element) || /^-?(?:\\d+|\\d{1,3}(?:,\\d{3})+)?(?:\\.\\d+)?$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/digits\n            digits: function (value, element) {\n                return this.optional(element) || /^\\d+$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/creditcard\n            // based on http://en.wikipedia.org/wiki/Luhn\n            creditcard: function (value, element) {\n                if (this.optional(element)) {\n                    return \"dependency-mismatch\";\n                }\n                // accept only spaces, digits and dashes\n                if (/[^0-9 \\-]+/.test(value)) {\n                    return false;\n                }\n                var nCheck = 0,\n                    nDigit = 0,\n                    bEven = false;\n\n                value = value.replace(/\\D/g, \"\");\n\n                for (var n = value.length - 1; n >= 0; n--) {\n                    var cDigit = value.charAt(n);\n                    nDigit = parseInt(cDigit, 10);\n                    if (bEven) {\n                        if ((nDigit *= 2) > 9) {\n                            nDigit -= 9;\n                        }\n                    }\n                    nCheck += nDigit;\n                    bEven = !bEven;\n                }\n\n                return (nCheck % 10) === 0;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/equalTo\n            equalTo: function (value, element, param) {\n                // bind to the blur event of the target in order to revalidate whenever the target field is updated\n                // TODO find a way to bind the event just once, avoiding the unbind-rebind overhead\n                var target = $(param);\n                if (this.settings.onfocusout) {\n                    target.unbind(\".validate-equalTo\").bind(\"blur.validate-equalTo\", function () {\n                        $(element).valid();\n                    });\n                }\n                return value === target.val();\n            }\n\n        }\n\n    });\n\n// deprecated, use $.validator.format instead\n    $.format = $.validator.format;\n\n}(jQuery));\n\n// ajax mode: abort\n// usage: $.ajax({ mode: \"abort\"[, port: \"uniqueport\"]});\n// if mode:\"abort\" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()\n(function ($) {\n    var pendingRequests = {};\n    // Use a prefilter if available (1.5+)\n    if ($.ajaxPrefilter) {\n        $.ajaxPrefilter(function (settings, _, xhr) {\n            var port = settings.port;\n            if (settings.mode === \"abort\") {\n                if (pendingRequests[port]) {\n                    pendingRequests[port].abort();\n                }\n                pendingRequests[port] = xhr;\n            }\n        });\n    } else {\n        // Proxy ajax\n        var ajax = $.ajax;\n        $.ajax = function (settings) {\n            var mode = ( \"mode\" in settings ? settings : $.ajaxSettings ).mode,\n                port = ( \"port\" in settings ? settings : $.ajaxSettings ).port;\n            if (mode === \"abort\") {\n                if (pendingRequests[port]) {\n                    pendingRequests[port].abort();\n                }\n                return (pendingRequests[port] = ajax.apply(this, arguments));\n            }\n            return ajax.apply(this, arguments);\n        };\n    }\n}(jQuery));\n\n// provides cross-browser focusin and focusout events\n// IE has native support, in other browsers, use event caputuring (neither bubbles)\n\n// provides delegate(type: String, delegate: Selector, handler: Callback) plugin for easier event delegation\n// handler is only called when $(event.target).is(delegate), in the scope of the jquery-object for event.target\n(function ($) {\n    // only implement if not provided by jQuery core (since 1.4)\n    // TODO verify if jQuery 1.4's implementation is compatible with older jQuery special-event APIs\n    if (!jQuery.event.special.focusin && !jQuery.event.special.focusout && document.addEventListener) {\n        $.each({\n            focus: 'focusin',\n            blur: 'focusout'\n        }, function (original, fix) {\n            $.event.special[fix] = {\n                setup: function () {\n                    this.addEventListener(original, handler, true);\n                },\n                teardown: function () {\n                    this.removeEventListener(original, handler, true);\n                },\n                handler: function (e) {\n                    var args = arguments;\n                    args[0] = $.event.fix(e);\n                    args[0].type = fix;\n                    return $.event.handle.apply(this, args);\n                }\n            };\n            function handler(e) {\n                e = $.event.fix(e);\n                e.type = fix;\n                return $.event.handle.call(this, e);\n            }\n        });\n    }\n    $.extend($.fn, {\n        validateDelegate: function (delegate, type, handler) {\n            return this.bind(type, function (event) {\n                var target = $(event.target);\n                if (target.is(delegate)) {\n                    return handler.apply(target, arguments);\n                }\n            });\n        }\n    });\n}(jQuery));\n\n}));","jquery/colorpicker/js/colorpicker.js":"/**\n *\n * Color picker\n * Author: Stefan Petre www.eyecon.ro\n * \n * Dual licensed under the MIT and GPL licenses\n * \n */\n\ndefine([\n\t\"jquery\",\n], function ($) {\n\tvar ColorPicker = function () {\n\t\tvar\n\t\t\tids = {},\n\t\t\tinAction,\n\t\t\tcharMin = 65,\n\t\t\tvisible,\n\t\t\ttpl = '<div class=\"colorpicker\"><div class=\"colorpicker_color\"><div><div></div></div></div><div class=\"colorpicker_hue\"><div></div></div><div class=\"colorpicker_new_color\"></div><div class=\"colorpicker_current_color\"></div><div class=\"colorpicker_hex\"><input type=\"text\" maxlength=\"6\" size=\"6\" /></div><div class=\"colorpicker_rgb_r colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_g colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_h colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_s colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_submit\"></div></div>',\n\t\t\tdefaults = {\n\t\t\t\teventName: 'click',\n\t\t\t\tonShow: function () {},\n\t\t\t\tonBeforeShow: function(){},\n\t\t\t\tonHide: function () {},\n\t\t\t\tonChange: function () {},\n\t\t\t\tonSubmit: function () {},\n\t\t\t\tcolor: 'ff0000',\n\t\t\t\tlivePreview: true,\n\t\t\t\tflat: false\n\t\t\t},\n\t\t\tfillRGBFields = function  (hsb, cal) {\n\t\t\t\tvar rgb = HSBToRGB(hsb);\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(1).val(rgb.r).end()\n\t\t\t\t\t.eq(2).val(rgb.g).end()\n\t\t\t\t\t.eq(3).val(rgb.b).end();\n\t\t\t},\n\t\t\tfillHSBFields = function  (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(4).val(hsb.h).end()\n\t\t\t\t\t.eq(5).val(hsb.s).end()\n\t\t\t\t\t.eq(6).val(hsb.b).end();\n\t\t\t},\n\t\t\tfillHexFields = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(0).val(HSBToHex(hsb)).end();\n\t\t\t},\n\t\t\tsetSelector = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').selector.css('backgroundColor', '#' + HSBToHex({h: hsb.h, s: 100, b: 100}));\n\t\t\t\t$(cal).data('colorpicker').selectorIndic.css({\n\t\t\t\t\tleft: parseInt(150 * hsb.s/100, 10),\n\t\t\t\t\ttop: parseInt(150 * (100-hsb.b)/100, 10)\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetHue = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').hue.css('top', parseInt(150 - 150 * hsb.h/360, 10));\n\t\t\t},\n\t\t\tsetCurrentColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').currentColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tsetNewColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').newColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tkeyDown = function (ev) {\n\t\t\t\tvar pressedKey = ev.charCode || ev.keyCode || -1;\n\t\t\t\tif ((pressedKey > charMin && pressedKey <= 90) || pressedKey == 32) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tif (cal.data('colorpicker').livePreview === true) {\n\t\t\t\t\tchange.apply(this);\n\t\t\t\t}\n\t\t\t},\n\t\t\tchange = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent(), col;\n\t\t\t\tif (this.parentNode.className.indexOf('_hex') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = HexToHSB(fixHex(this.value));\n\t\t\t\t} else if (this.parentNode.className.indexOf('_hsb') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = fixHSB({\n\t\t\t\t\t\th: parseInt(cal.data('colorpicker').fields.eq(4).val(), 10),\n\t\t\t\t\t\ts: parseInt(cal.data('colorpicker').fields.eq(5).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(6).val(), 10)\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tcal.data('colorpicker').color = col = RGBToHSB(fixRGB({\n\t\t\t\t\t\tr: parseInt(cal.data('colorpicker').fields.eq(1).val(), 10),\n\t\t\t\t\t\tg: parseInt(cal.data('colorpicker').fields.eq(2).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(3).val(), 10)\n\t\t\t\t\t}));\n\t\t\t\t}\n\t\t\t\tif (ev) {\n\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t}\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onChange.apply(cal, [col, HSBToHex(col), HSBToRGB(col)]);\n\t\t\t},\n\t\t\tblur = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tcal.data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tfocus = function () {\n\t\t\t\tcharMin = this.parentNode.className.indexOf('_hex') > 0 ? 70 : 65;\n\t\t\t\t$(this).parent().parent().data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t\t$(this).parent().addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tdownIncrement = function (ev) {\n\t\t\t\tvar field = $(this).parent().find('input').focus();\n\t\t\t\tvar current = {\n\t\t\t\t\tel: $(this).parent().addClass('colorpicker_slider'),\n\t\t\t\t\tmax: this.parentNode.className.indexOf('_hsb_h') > 0 ? 360 : (this.parentNode.className.indexOf('_hsb') > 0 ? 100 : 255),\n\t\t\t\t\ty: ev.pageY,\n\t\t\t\t\tfield: field,\n\t\t\t\t\tval: parseInt(field.val(), 10),\n\t\t\t\t\tpreview: $(this).parent().parent().data('colorpicker').livePreview\t\t\t\t\t\n\t\t\t\t};\n\t\t\t\t$(document).bind('mouseup', current, upIncrement);\n\t\t\t\t$(document).bind('mousemove', current, moveIncrement);\n\t\t\t},\n\t\t\tmoveIncrement = function (ev) {\n\t\t\t\tev.data.field.val(Math.max(0, Math.min(ev.data.max, parseInt(ev.data.val + ev.pageY - ev.data.y, 10))));\n\t\t\t\tif (ev.data.preview) {\n\t\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupIncrement = function (ev) {\n\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\tev.data.el.removeClass('colorpicker_slider').find('input').focus();\n\t\t\t\t$(document).unbind('mouseup', upIncrement);\n\t\t\t\t$(document).unbind('mousemove', moveIncrement);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownHue = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\ty: $(this).offset().top\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upHue);\n\t\t\t\t$(document).bind('mousemove', current, moveHue);\n\t\t\t},\n\t\t\tmoveHue = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(4)\n\t\t\t\t\t\t.val(parseInt(360*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.y))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupHue = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upHue);\n\t\t\t\t$(document).unbind('mousemove', moveHue);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownSelector = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\tpos: $(this).offset()\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upSelector);\n\t\t\t\t$(document).bind('mousemove', current, moveSelector);\n\t\t\t},\n\t\t\tmoveSelector = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(6)\n\t\t\t\t\t\t.val(parseInt(100*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.pos.top))))/150, 10))\n\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.eq(5)\n\t\t\t\t\t\t.val(parseInt(100*(Math.max(0,Math.min(150,(ev.pageX - ev.data.pos.left))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupSelector = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upSelector);\n\t\t\t\t$(document).unbind('mousemove', moveSelector);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tenterSubmit = function (ev) {\n\t\t\t\t$(this).addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tleaveSubmit = function (ev) {\n\t\t\t\t$(this).removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tclickSubmit = function (ev) {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').color;\n\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onSubmit(col, HSBToHex(col), HSBToRGB(col), cal.data('colorpicker').el);\n\t\t\t},\n\t\t\tshow = function (ev) {\n\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\tcal.data('colorpicker').onBeforeShow.apply(this, [cal.get(0)]);\n\t\t\t\tvar pos = $(this).offset();\n\t\t\t\tvar viewPort = getViewport();\n\t\t\t\tvar top = pos.top + this.offsetHeight;\n\t\t\t\tvar left = pos.left;\n\t\t\t\tif (top + 176 > viewPort.t + viewPort.h) {\n\t\t\t\t\ttop -= this.offsetHeight + 176;\n\t\t\t\t}\n\t\t\t\tif (left + 356 > viewPort.l + viewPort.w) {\n\t\t\t\t\tleft -= 356;\n\t\t\t\t}\n\t\t\t\tcal.css({left: left + 'px', top: top + 'px'});\n\t\t\t\tif (cal.data('colorpicker').onShow.apply(this, [cal.get(0)]) != false) {\n\t\t\t\t\tcal.show();\n\t\t\t\t}\n\t\t\t\t$(document).bind('mousedown', {cal: cal}, hide);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\thide = function (ev) {\n\t\t\t\tif (!isChildOf(ev.data.cal.get(0), ev.target, ev.data.cal.get(0))) {\n\t\t\t\t\tif (ev.data.cal.data('colorpicker').onHide.apply(this, [ev.data.cal.get(0)]) != false) {\n\t\t\t\t\t\tev.data.cal.hide();\n\t\t\t\t\t}\n\t\t\t\t\t$(document).unbind('mousedown', hide);\n\t\t\t\t}\n\t\t\t},\n\t\t\tisChildOf = function(parentEl, el, container) {\n\t\t\t\tif (parentEl == el) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\tif (parentEl.contains) {\n\t\t\t\t\treturn parentEl.contains(el);\n\t\t\t\t}\n\t\t\t\tif ( parentEl.compareDocumentPosition ) {\n\t\t\t\t\treturn !!(parentEl.compareDocumentPosition(el) & 16);\n\t\t\t\t}\n\t\t\t\tvar prEl = el.parentNode;\n\t\t\t\twhile(prEl && prEl != container) {\n\t\t\t\t\tif (prEl == parentEl)\n\t\t\t\t\t\treturn true;\n\t\t\t\t\tprEl = prEl.parentNode;\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tgetViewport = function () {\n\t\t\t\tvar m = document.compatMode == 'CSS1Compat';\n\t\t\t\treturn {\n\t\t\t\t\tl : window.pageXOffset || (m ? document.documentElement.scrollLeft : document.body.scrollLeft),\n\t\t\t\t\tt : window.pageYOffset || (m ? document.documentElement.scrollTop : document.body.scrollTop),\n\t\t\t\t\tw : window.innerWidth || (m ? document.documentElement.clientWidth : document.body.clientWidth),\n\t\t\t\t\th : window.innerHeight || (m ? document.documentElement.clientHeight : document.body.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHSB = function (hsb) {\n\t\t\t\treturn {\n\t\t\t\t\th: Math.min(360, Math.max(0, hsb.h)),\n\t\t\t\t\ts: Math.min(100, Math.max(0, hsb.s)),\n\t\t\t\t\tb: Math.min(100, Math.max(0, hsb.b))\n\t\t\t\t};\n\t\t\t}, \n\t\t\tfixRGB = function (rgb) {\n\t\t\t\treturn {\n\t\t\t\t\tr: Math.min(255, Math.max(0, rgb.r)),\n\t\t\t\t\tg: Math.min(255, Math.max(0, rgb.g)),\n\t\t\t\t\tb: Math.min(255, Math.max(0, rgb.b))\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHex = function (hex) {\n\t\t\t\tvar len = 6 - hex.length;\n\t\t\t\tif (len > 0) {\n\t\t\t\t\tvar o = [];\n\t\t\t\t\tfor (var i=0; i<len; i++) {\n\t\t\t\t\t\to.push('0');\n\t\t\t\t\t}\n\t\t\t\t\to.push(hex);\n\t\t\t\t\thex = o.join('');\n\t\t\t\t}\n\t\t\t\treturn hex;\n\t\t\t}, \n\t\t\tHexToRGB = function (hex) {\n\t\t\t\tvar hex = parseInt(((hex.indexOf('#') > -1) ? hex.substring(1) : hex), 16);\n\t\t\t\treturn {r: hex >> 16, g: (hex & 0x00FF00) >> 8, b: (hex & 0x0000FF)};\n\t\t\t},\n\t\t\tHexToHSB = function (hex) {\n\t\t\t\treturn RGBToHSB(HexToRGB(hex));\n\t\t\t},\n\t\t\tRGBToHSB = function (rgb) {\n\t\t\t\tvar hsb = {\n\t\t\t\t\th: 0,\n\t\t\t\t\ts: 0,\n\t\t\t\t\tb: 0\n\t\t\t\t};\n\t\t\t\tvar min = Math.min(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar max = Math.max(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar delta = max - min;\n\t\t\t\thsb.b = max;\n\t\t\t\tif (max != 0) {\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\thsb.s = max != 0 ? 255 * delta / max : 0;\n\t\t\t\tif (hsb.s != 0) {\n\t\t\t\t\tif (rgb.r == max) {\n\t\t\t\t\t\thsb.h = (rgb.g - rgb.b) / delta;\n\t\t\t\t\t} else if (rgb.g == max) {\n\t\t\t\t\t\thsb.h = 2 + (rgb.b - rgb.r) / delta;\n\t\t\t\t\t} else {\n\t\t\t\t\t\thsb.h = 4 + (rgb.r - rgb.g) / delta;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\thsb.h = -1;\n\t\t\t\t}\n\t\t\t\thsb.h *= 60;\n\t\t\t\tif (hsb.h < 0) {\n\t\t\t\t\thsb.h += 360;\n\t\t\t\t}\n\t\t\t\thsb.s *= 100/255;\n\t\t\t\thsb.b *= 100/255;\n\t\t\t\treturn hsb;\n\t\t\t},\n\t\t\tHSBToRGB = function (hsb) {\n\t\t\t\tvar rgb = {};\n\t\t\t\tvar h = Math.round(hsb.h);\n\t\t\t\tvar s = Math.round(hsb.s*255/100);\n\t\t\t\tvar v = Math.round(hsb.b*255/100);\n\t\t\t\tif(s == 0) {\n\t\t\t\t\trgb.r = rgb.g = rgb.b = v;\n\t\t\t\t} else {\n\t\t\t\t\tvar t1 = v;\n\t\t\t\t\tvar t2 = (255-s)*v/255;\n\t\t\t\t\tvar t3 = (t1-t2)*(h%60)/60;\n\t\t\t\t\tif(h==360) h = 0;\n\t\t\t\t\tif(h<60) {rgb.r=t1;\trgb.b=t2; rgb.g=t2+t3}\n\t\t\t\t\telse if(h<120) {rgb.g=t1; rgb.b=t2;\trgb.r=t1-t3}\n\t\t\t\t\telse if(h<180) {rgb.g=t1; rgb.r=t2;\trgb.b=t2+t3}\n\t\t\t\t\telse if(h<240) {rgb.b=t1; rgb.r=t2;\trgb.g=t1-t3}\n\t\t\t\t\telse if(h<300) {rgb.b=t1; rgb.g=t2;\trgb.r=t2+t3}\n\t\t\t\t\telse if(h<360) {rgb.r=t1; rgb.g=t2;\trgb.b=t1-t3}\n\t\t\t\t\telse {rgb.r=0; rgb.g=0;\trgb.b=0}\n\t\t\t\t}\n\t\t\t\treturn {r:Math.round(rgb.r), g:Math.round(rgb.g), b:Math.round(rgb.b)};\n\t\t\t},\n\t\t\tRGBToHex = function (rgb) {\n\t\t\t\tvar hex = [\n\t\t\t\t\trgb.r.toString(16),\n\t\t\t\t\trgb.g.toString(16),\n\t\t\t\t\trgb.b.toString(16)\n\t\t\t\t];\n\t\t\t\t$.each(hex, function (nr, val) {\n\t\t\t\t\tif (val.length == 1) {\n\t\t\t\t\t\thex[nr] = '0' + val;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn hex.join('');\n\t\t\t},\n\t\t\tHSBToHex = function (hsb) {\n\t\t\t\treturn RGBToHex(HSBToRGB(hsb));\n\t\t\t},\n\t\t\trestoreOriginal = function () {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').origColor;\n\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t};\n\t\treturn {\n\t\t\tinit: function (opt) {\n\t\t\t\topt = $.extend({}, defaults, opt||{});\n\t\t\t\tif (typeof opt.color == 'string') {\n\t\t\t\t\topt.color = HexToHSB(opt.color);\n\t\t\t\t} else if (opt.color.r != undefined && opt.color.g != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = RGBToHSB(opt.color);\n\t\t\t\t} else if (opt.color.h != undefined && opt.color.s != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = fixHSB(opt.color);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function () {\n\t\t\t\t\tif (!$(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar options = $.extend({}, opt);\n\t\t\t\t\t\toptions.origColor = opt.color;\n\t\t\t\t\t\tvar id = 'collorpicker_' + parseInt(Math.random() * 1000);\n\t\t\t\t\t\t$(this).data('colorpickerId', id);\n\t\t\t\t\t\tvar cal = $(tpl).attr('id', id);\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.appendTo(this).show();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcal.appendTo(document.body);\n\t\t\t\t\t\t}\n\t\t\t\t\t\toptions.fields = cal\n\t\t\t\t\t\t\t\t\t\t\t.find('input')\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('keyup', keyDown)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('change', change)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('blur', blur)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('focus', focus);\n\t\t\t\t\t\tcal\n\t\t\t\t\t\t\t.find('span').bind('mousedown', downIncrement).end()\n\t\t\t\t\t\t\t.find('>div.colorpicker_current_color').bind('click', restoreOriginal);\n\t\t\t\t\t\toptions.selector = cal.find('div.colorpicker_color').bind('mousedown', downSelector);\n\t\t\t\t\t\toptions.selectorIndic = options.selector.find('div div');\n\t\t\t\t\t\toptions.el = this;\n\t\t\t\t\t\toptions.hue = cal.find('div.colorpicker_hue div');\n\t\t\t\t\t\tcal.find('div.colorpicker_hue').bind('mousedown', downHue);\n\t\t\t\t\t\toptions.newColor = cal.find('div.colorpicker_new_color');\n\t\t\t\t\t\toptions.currentColor = cal.find('div.colorpicker_current_color');\n\t\t\t\t\t\tcal.data('colorpicker', options);\n\t\t\t\t\t\tcal.find('div.colorpicker_submit')\n\t\t\t\t\t\t\t.bind('mouseenter', enterSubmit)\n\t\t\t\t\t\t\t.bind('mouseleave', leaveSubmit)\n\t\t\t\t\t\t\t.bind('click', clickSubmit);\n\t\t\t\t\t\tfillRGBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHexFields(options.color, cal.get(0));\n\t\t\t\t\t\tsetHue(options.color, cal.get(0));\n\t\t\t\t\t\tsetSelector(options.color, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(options.color, cal.get(0));\n\t\t\t\t\t\tsetNewColor(options.color, cal.get(0));\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.css({\n\t\t\t\t\t\t\t\tposition: 'relative',\n\t\t\t\t\t\t\t\tdisplay: 'block'\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t$(this).bind(options.eventName, show);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tshowPicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tshow.apply(this);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\thidePicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\t$('#' + $(this).data('colorpickerId')).hide();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetColor: function(col) {\n\t\t\t\tif (typeof col == 'string') {\n\t\t\t\t\tcol = HexToHSB(col);\n\t\t\t\t} else if (col.r != undefined && col.g != undefined && col.b != undefined) {\n\t\t\t\t\tcol = RGBToHSB(col);\n\t\t\t\t} else if (col.h != undefined && col.s != undefined && col.b != undefined) {\n\t\t\t\t\tcol = fixHSB(col);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function(){\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\t}();\n\t$.fn.extend({\n\t\tColorPicker: ColorPicker.init,\n\t\tColorPickerHide: ColorPicker.hidePicker,\n\t\tColorPickerShow: ColorPicker.showPicker,\n\t\tColorPickerSetColor: ColorPicker.setColor\n\t});\n});","jquery/editableMultiselect/js/jquery.editable.js":"/*\n * Jeditable - jQuery in place edit plugin\n *\n * Copyright (c) 2006-2009 Mika Tuupola, Dylan Verheul\n *\n * Licensed under the MIT license:\n *   http://www.opensource.org/licenses/mit-license.php\n *\n * Project home:\n *   http://www.appelsiini.net/projects/jeditable\n *\n * Based on editable by Dylan Verheul <dylan_at_dyve.net>:\n *    http://www.dyve.net/jquery/?editable\n *\n */\n\n/**\n * Version 1.7.1\n *\n * ** means there is basic unit tests for this parameter.\n *\n * @name  Jeditable\n * @type  jQuery\n * @param String  target             (POST) URL or function to send edited content to **\n * @param Hash    options            additional options\n * @param String  options[method]    method to use to send edited content (POST or PUT) **\n * @param Function options[callback] Function to run after submitting edited content **\n * @param String  options[name]      POST parameter name of edited content\n * @param String  options[id]        POST parameter name of edited div id\n * @param Hash    options[submitdata] Extra parameters to send when submitting edited content.\n * @param String  options[type]      text, textarea or select (or any 3rd party input type) **\n * @param Integer options[rows]      number of rows if using textarea **\n * @param Integer options[cols]      number of columns if using textarea **\n * @param Mixed   options[height]    'auto', 'none' or height in pixels **\n * @param Mixed   options[width]     'auto', 'none' or width in pixels **\n * @param String  options[loadurl]   URL to fetch input content before editing **\n * @param String  options[loadtype]  Request type for load url. Should be GET or POST.\n * @param String  options[loadtext]  Text to display while loading external content.\n * @param Mixed   options[loaddata]  Extra parameters to pass when fetching content before editing.\n * @param Mixed   options[data]      Or content given as paramameter. String or function.**\n * @param String  options[indicator] indicator html to show when saving\n * @param String  options[tooltip]   optional tooltip text via title attribute **\n * @param String  options[event]     jQuery event such as 'click' of 'dblclick' **\n * @param String  options[submit]    submit button value, empty means no button **\n * @param String  options[cancel]    cancel button value, empty means no button **\n * @param String  options[cssclass]  CSS class to apply to input form. 'inherit' to copy from parent. **\n * @param String  options[style]     Style to apply to input form 'inherit' to copy from parent. **\n * @param String  options[select]    true or false, when true text is highlighted ??\n * @param String  options[placeholder] Placeholder text or html to insert when element is empty. **\n * @param String  options[onblur]    'cancel', 'submit', 'ignore' or function ??\n *\n * @param Function options[onsubmit] function(settings, original) { ... } called before submit\n * @param Function options[onreset]  function(settings, original) { ... } called before reset\n * @param Function options[onerror]  function(settings, original, xhr) { ... } called on error\n *\n * @param Hash    options[ajaxoptions]  jQuery Ajax options. See docs.jquery.com.\n *\n */\n\n(function($) {\n\n    $.fn.editable = function(target, options) {\n\n        if ('disable' == target) {\n            $(this).data('disabled.editable', true);\n            return;\n        }\n        if ('enable' == target) {\n            $(this).data('disabled.editable', false);\n            return;\n        }\n        if ('destroy' == target) {\n            $(this)\n                .unbind($(this).data('event.editable'))\n                .removeData('disabled.editable')\n                .removeData('event.editable');\n            return;\n        }\n\n        var settings = $.extend({}, $.fn.editable.defaults, {target:target}, options);\n\n        /* setup some functions */\n        var plugin   = $.editable.types[settings.type].plugin || function() { };\n        var submit   = $.editable.types[settings.type].submit || function() { };\n        var buttons  = $.editable.types[settings.type].buttons\n            || $.editable.types['defaults'].buttons;\n        var content  = $.editable.types[settings.type].content\n            || $.editable.types['defaults'].content;\n        var element  = $.editable.types[settings.type].element\n            || $.editable.types['defaults'].element;\n        var reset    = $.editable.types[settings.type].reset\n            || $.editable.types['defaults'].reset;\n        var callback = settings.callback || function() { };\n        var onedit   = settings.onedit   || function() { };\n        var onsubmit = settings.onsubmit || function() { };\n        var onreset  = settings.onreset  || function() { };\n        var onerror  = settings.onerror  || reset;\n\n        /* show tooltip */\n        if (settings.tooltip) {\n            $(this).attr('title', settings.tooltip);\n        }\n\n        settings.autowidth  = 'auto' == settings.width;\n        settings.autoheight = 'auto' == settings.height;\n\n        return this.each(function() {\n\n            /* save this to self because this changes when scope changes */\n            var self = this;\n\n            /* inlined block elements lose their width and height after first edit */\n            /* save them for later use as workaround */\n            var savedwidth  = $(self).width();\n            var savedheight = $(self).height();\n\n            /* save so it can be later used by $.editable('destroy') */\n            $(this).data('event.editable', settings.event);\n\n            /* if element is empty add something clickable (if requested) */\n            if (!$.trim($(this).html())) {\n                $(this).html(settings.placeholder);\n            }\n\n            $(this).bind(settings.event, function(e) {\n\n                /* abort if disabled for this element */\n                if (true === $(this).data('disabled.editable')) {\n                    return;\n                }\n\n                /* prevent throwing an exeption if edit field is clicked again */\n                if (self.editing) {\n                    return;\n                }\n\n                /* abort if onedit hook returns false */\n                if (false === onedit.apply(this, [settings, self])) {\n                    return;\n                }\n\n                /* prevent default action and bubbling */\n                e.preventDefault();\n                e.stopPropagation();\n\n                /* remove tooltip */\n                if (settings.tooltip) {\n                    $(self).removeAttr('title');\n                }\n\n                /* figure out how wide and tall we are, saved width and height */\n                /* are workaround for http://dev.jquery.com/ticket/2190 */\n                if (0 == $(self).width()) {\n                    //$(self).css('visibility', 'hidden');\n                    settings.width  = savedwidth;\n                    settings.height = savedheight;\n                } else {\n                    if (settings.width != 'none') {\n                        settings.width =\n                            settings.autowidth ? $(self).width()  : settings.width;\n                    }\n                    if (settings.height != 'none') {\n                        settings.height =\n                            settings.autoheight ? $(self).height() : settings.height;\n                    }\n                }\n                //$(this).css('visibility', '');\n\n                /* remove placeholder text, replace is here because of IE */\n                if ($(this).html().toLowerCase().replace(/(;|\")/g, '') ==\n                    settings.placeholder.toLowerCase().replace(/(;|\")/g, '')) {\n                    $(this).html('');\n                }\n\n                self.editing    = true;\n                self.revert     = $(self).html();\n                $(self).html('');\n\n                /* create the form object */\n                var form = $('<form />');\n\n                /* apply css or style or both */\n                if (settings.cssclass) {\n                    if ('inherit' == settings.cssclass) {\n                        form.attr('class', $(self).attr('class'));\n                    } else {\n                        form.attr('class', settings.cssclass);\n                    }\n                }\n\n                if (settings.style) {\n                    if ('inherit' == settings.style) {\n                        form.attr('style', $(self).attr('style'));\n                        /* IE needs the second line or display wont be inherited */\n                        form.css('display', $(self).css('display'));\n                    } else {\n                        form.attr('style', settings.style);\n                    }\n                }\n\n                /* add main input element to form and store it in input */\n                var input = element.apply(form, [settings, self]);\n\n                /* set input content via POST, GET, given data or existing value */\n                var input_content;\n\n                if (settings.loadurl) {\n                    var t = setTimeout(function() {\n                        input.disabled = true;\n                        content.apply(form, [settings.loadtext, settings, self]);\n                    }, 100);\n\n                    var loaddata = {};\n                    loaddata[settings.id] = self.id;\n                    if ($.isFunction(settings.loaddata)) {\n                        $.extend(loaddata, settings.loaddata.apply(self, [self.revert, settings]));\n                    } else {\n                        $.extend(loaddata, settings.loaddata);\n                    }\n                    $.ajax({\n                        type : settings.loadtype,\n                        url  : settings.loadurl,\n                        data : loaddata,\n                        async : false,\n                        success: function(result) {\n                            window.clearTimeout(t);\n                            input_content = result;\n                            input.disabled = false;\n                        }\n                    });\n                } else if (settings.data) {\n                    input_content = settings.data;\n                    if ($.isFunction(settings.data)) {\n                        input_content = settings.data.apply(self, [self.revert, settings]);\n                    }\n                } else {\n                    input_content = self.revert;\n                }\n                content.apply(form, [input_content, settings, self]);\n\n                input.attr('name', settings.name);\n\n                /* add buttons to the form */\n                buttons.apply(form, [settings, self]);\n\n                /* add created form to self */\n                $(self).append(form);\n\n                /* attach 3rd party plugin if requested */\n                plugin.apply(form, [settings, self]);\n\n                /* focus to first visible form element */\n                $(':input:visible:enabled:first', form).focus();\n\n                /* highlight input contents when requested */\n                if (settings.select) {\n                    input.select();\n                }\n\n                /* discard changes if pressing esc */\n                input.keydown(function(e) {\n                    if (e.keyCode == 27) {\n                        e.preventDefault();\n                        //self.reset();\n                        reset.apply(form, [settings, self]);\n                    }\n                });\n\n                /* discard, submit or nothing with changes when clicking outside */\n                /* do nothing is usable when navigating with tab */\n                var t;\n                if ('cancel' == settings.onblur) {\n                    input.blur(function(e) {\n                        /* prevent canceling if submit was clicked */\n                        t = setTimeout(function() {\n                            reset.apply(form, [settings, self]);\n                        }, 500);\n                    });\n                } else if ('submit' == settings.onblur) {\n                    input.blur(function(e) {\n                        /* prevent double submit if submit was clicked */\n                        t = setTimeout(function() {\n                            form.submit();\n                        }, 200);\n                    });\n                } else if ($.isFunction(settings.onblur)) {\n                    input.blur(function(e) {\n                        settings.onblur.apply(self, [input.val(), settings]);\n                    });\n                } else {\n                    input.blur(function(e) {\n                        /* TODO: maybe something here */\n                    });\n                }\n\n                form.submit(function(e) {\n\n                    if (t) {\n                        clearTimeout(t);\n                    }\n\n                    /* do no submit */\n                    e.preventDefault();\n\n                    /* call before submit hook. */\n                    /* if it returns false abort submitting */\n                    if (false !== onsubmit.apply(form, [settings, self])) {\n                        /* custom inputs call before submit hook. */\n                        /* if it returns false abort submitting */\n                        if (false !== submit.apply(form, [settings, self])) {\n\n                            /* check if given target is function */\n                            if ($.isFunction(settings.target)) {\n                                var str = settings.target.apply(self, [input.val(), settings]);\n                                $(self).html(str);\n                                self.editing = false;\n                                callback.apply(self, [self.innerHTML, settings]);\n                                /* TODO: this is not dry */\n                                if (!$.trim($(self).html())) {\n                                    $(self).html(settings.placeholder);\n                                }\n                            } else {\n                                /* add edited content and id of edited element to POST */\n                                var submitdata = {};\n                                submitdata[settings.name] = input.val();\n                                submitdata[settings.id] = self.id;\n                                /* add extra data to be POST:ed */\n                                if ($.isFunction(settings.submitdata)) {\n                                    $.extend(submitdata, settings.submitdata.apply(self, [self.revert, settings]));\n                                } else {\n                                    $.extend(submitdata, settings.submitdata);\n                                }\n\n                                /* quick and dirty PUT support */\n                                if ('PUT' == settings.method) {\n                                    submitdata['_method'] = 'put';\n                                }\n\n                                /* show the saving indicator */\n                                $(self).html(settings.indicator);\n\n                                /* defaults for ajaxoptions */\n                                var ajaxoptions = {\n                                    type    : 'POST',\n                                    data    : submitdata,\n                                    dataType: 'html',\n                                    url     : settings.target,\n                                    success : function(result, status) {\n                                        if (ajaxoptions.dataType == 'html') {\n                                            $(self).html(result);\n                                        }\n                                        self.editing = false;\n                                        callback.apply(self, [result, settings]);\n                                        if (!$.trim($(self).html())) {\n                                            $(self).html(settings.placeholder);\n                                        }\n                                    },\n                                    error   : function(xhr, status, error) {\n                                        onerror.apply(form, [settings, self, xhr]);\n                                    }\n                                };\n\n                                /* override with what is given in settings.ajaxoptions */\n                                $.extend(ajaxoptions, settings.ajaxoptions);\n                                $.ajax(ajaxoptions);\n\n                            }\n                        }\n                    }\n\n                    /* show tooltip again */\n                    $(self).attr('title', settings.tooltip);\n\n                    return false;\n                });\n            });\n\n            /* privileged methods */\n            this.reset = function(form) {\n                /* prevent calling reset twice when blurring */\n                if (this.editing) {\n                    /* before reset hook, if it returns false abort reseting */\n                    if (false !== onreset.apply(form, [settings, self])) {\n                        $(self).html(self.revert);\n                        self.editing   = false;\n                        if (!$.trim($(self).html())) {\n                            $(self).html(settings.placeholder);\n                        }\n                        /* show tooltip again */\n                        if (settings.tooltip) {\n                            $(self).attr('title', settings.tooltip);\n                        }\n                    }\n                }\n            };\n        });\n\n    };\n\n\n    $.editable = {\n        types: {\n            defaults: {\n                element : function(settings, original) {\n                    var input = $('<input type=\"hidden\"></input>');\n                    $(this).append(input);\n                    return(input);\n                },\n                content : function(string, settings, original) {\n                    $(':input:first', this).val(string);\n                },\n                reset : function(settings, original) {\n                    settings.data.apply(original, [original, settings]);\n                    original.reset(this);\n                },\n                buttons : function(settings, original) {\n                    var form = this;\n                    if (settings.submit) {\n                        /* if given html string use that */\n                        if (settings.submit.match(/>$/)) {\n                            var submit = $(settings.submit).click(function() {\n                                if (submit.attr(\"type\") != \"submit\") {\n                                    form.submit();\n                                }\n                            });\n                            /* otherwise use button with given string as text */\n                        } else {\n                            var submit = $('<button type=\"submit\" />');\n                            submit.html(settings.submit);\n                        }\n                        $(this).append(submit);\n                    }\n                    if (settings.cancel) {\n                        /* if given html string use that */\n                        if (settings.cancel.match(/>$/)) {\n                            var cancel = $(settings.cancel);\n                            /* otherwise use button with given string as text */\n                        } else {\n                            var cancel = $('<button type=\"cancel\" />');\n                            cancel.html(settings.cancel);\n                        }\n                        $(this).append(cancel);\n\n                        $(cancel).click(function(event) {\n                            original.reset(this);\n                            return false;\n                        });\n                    }\n                }\n            },\n            text: {\n                element : function(settings, original) {\n                    var input = $('<input type=\"text\"/>');\n//                    if (settings.width  != 'none') { input.width(settings.width);  }\n//                    if (settings.height != 'none') { input.height(settings.height); }\n                    /* https://bugzilla.mozilla.org/show_bug.cgi?id=236791 */\n                    //input[0].setAttribute('autocomplete','off');\n                    input.attr('autocomplete','off');\n                    $(this).append(input);\n                    return(input);\n                }\n            },\n            textarea: {\n                element : function(settings, original) {\n                    var textarea = $('<textarea />');\n                    if (settings.rows) {\n                        textarea.attr('rows', settings.rows);\n                    } else if (settings.height != \"none\") {\n                        textarea.height(settings.height);\n                    }\n                    if (settings.cols) {\n                        textarea.attr('cols', settings.cols);\n                    } else if (settings.width != \"none\") {\n                        textarea.width(settings.width);\n                    }\n                    $(this).append(textarea);\n                    return(textarea);\n                }\n            },\n            select: {\n                element : function(settings, original) {\n                    var select = $('<select />');\n                    $(this).append(select);\n                    return(select);\n                },\n                content : function(data, settings, original) {\n                    /* If it is string assume it is json. */\n                    if (String == data.constructor) {\n                        eval ('var json = ' + data);\n                    } else {\n                        /* Otherwise assume it is a hash already. */\n                        var json = data;\n                    }\n                    for (var key in json) {\n                        if (!json.hasOwnProperty(key)) {\n                            continue;\n                        }\n                        if ('selected' == key) {\n                            continue;\n                        }\n                        var option = $('<option />').val(key).append(json[key]);\n                        $('select', this).append(option);\n                    }\n                    /* Loop option again to set selected. IE needed this... */\n                    $('select', this).children().each(function() {\n                        if ($(this).val() == json['selected'] ||\n                            $(this).text() == $.trim(original.revert)) {\n                            $(this).attr('selected', 'selected');\n                        }\n                    });\n                }\n            }\n        },\n\n        /* Add new input type */\n        addInputType: function(name, input) {\n            $.editable.types[name] = input;\n        }\n    };\n\n    // publicly accessible defaults\n    $.fn.editable.defaults = {\n        name       : 'value',\n        id         : 'id',\n        type       : 'text',\n        width      : 'auto',\n        height     : 'auto',\n        event      : 'click.editable',\n        onblur     : 'cancel',\n        loadtype   : 'GET',\n        loadtext   : 'Loading...',\n        placeholder: 'Click to edit',\n        loaddata   : {},\n        submitdata : {},\n        ajaxoptions: {}\n    };\n\n})(jQuery);\n","jquery/editableMultiselect/js/jquery.multiselect.js":"define([\n    \"jquery\"\n], function($){\n\n    /*\n     * jQuery.multiselect plugin\n     *\n     * Form control: allow select several values from list and add new value(s) to list\n     *\n     * Licensed under the BSD License:\n     *   http://www.opensource.org/licenses/bsd-license\n     *\n     * Version: 0.9.0\n     *\n     * @author Dmitry (dio) Levashov, dio@std42.ru\n     * @example\n     *  html: <select name=\"my-select\" multiple=\"on\"><option .... </select>\n     * js   : $('select[name=\"my-select\"]').multiselect()\n     *  or\n     * var opts = { ... };\n     * $('select[name=\"my-select\"]').multiselect(opts);\n     */\n    $.fn.multiselect = function(opts) {\n        var o = $.extend({\n            mselectHiddenClass: 'mselect-hidden',\n            mselectItemNotEditableClass: 'mselect-list-item-not-editable',\n            mselectItemNotRemovableClass: 'mselect-list-item-not-removable',\n            mselectListClass: 'mselect-list',\n            mselectItemsWrapperClass: 'mselect-items-wrapper',\n            mselectButtonAddClass: 'mselect-button-add',\n            mselectInputContainerClass: 'mselect-input-container',\n            mselectInputClass: 'mselect-input',\n            mselectButtonCancelClass: 'mselect-cancel',\n            mselectButtonSaveClass: 'mselect-save',\n            mselectListItemClass: 'mselect-list-item',\n            mselectItemsWrapperOverflowClass: 'mselect-fixed',\n            mselectDisabledClass: 'mselect-disabled',\n            mselectCheckedClass: 'mselect-checked',\n            layout: '<section class=\"block %mselectListClass%\">'\n                +'<div class=\"block-content\"><div class=\"%mselectItemsWrapperClass%\">'\n                +'%items%'\n                +'</div></div>'\n                +'<footer class=\"block-footer\">'\n                +'<span class=\"action-add %mselectButtonAddClass%\">%addText%</span>'\n                +'</footer>'\n                +'<div class=\"%mselectInputContainerClass%\">'\n                +'<input type=\"text\" class=\"%mselectInputClass%\" title=\"%inputTitle%\"/>'\n                +'<span class=\"%mselectButtonCancelClass%\" title=\"%cancelText%\"></span>'\n                +'<span class=\"%mselectButtonSaveClass%\" title=\"Add\"></span>'\n                +'</div>'\n                +'</section>',\n            item : '<div  class=\"%mselectListItemClass% %mselectDisabledClass% %iseditable% %isremovable%\"><label><input type=\"checkbox\" class=\"%mselectCheckedClass%\" value=\"%value%\" %checked% %disabled% /><span>%label%</span></label>' +\n                '<span class=\"mselect-edit\" title=\"Edit\">Edit</span>' +\n                '<span class=\"mselect-delete\" title=\"Delete\">Delete</span> ' +\n                '</div>',\n            addText: 'Add new value',\n            cancelText: 'Cancel',\n            inputTitle: 'Enter new option',\n            size: 5,\n            keyCodes: {\n                Enter: 13,\n                Esc: 27\n            },\n            toggleAddButton: true,\n            // New option for callback\n            mselectInputSubmitCallback: null,\n            parse : function(v) { return v.split(/\\s*,\\s*/); }\n        }, opts||{});\n\n        return this.filter('select[multiple]:not(.' + o.mselectHiddenClass + ')').each(function() {\n            var select = $(this).addClass(o.mselectHiddenClass).hide(),\n                size = select.attr('size') > 0 ? select.attr('size') : o.size,\n                items = (function() {\n                    var str = '';\n\n                    select.children('option').each(function(i, option) {\n                        option = $(option);\n\n                        str += o.item\n                            .replace(/%value%/gi,  option.val())\n                            .replace(/%checked%/gi, option.attr('selected') ? 'checked' : '')\n                            .replace(/%mselectCheckedClass%/gi, option.attr('selected') ? ''+o.mselectCheckedClass+'' : '')\n                            .replace(/%disabled%/gi, option.attr('disabled') ? 'disabled' : '')\n                            .replace(/%mselectDisabledClass%/gi, option.attr('disabled') ? ''+o.mselectDisabledClass+'' : '')\n                            .replace(/%mselectListItemClass%/gi, o.mselectListItemClass)\n                            .replace(/%iseditable%/gi, option.attr('data-is-editable') ? ''+o.mselectItemNotEditableClass+'' : '')\n                            .replace(/%isremovable%/i, option.attr('data-is-removable') ? ''+o.mselectItemNotRemovableClass+'' : '')\n                            .replace(/%label%/gi,  option.html());\n                    });\n\n                    return str;\n                })(),\n                html = o.layout\n                    .replace(/%items%/gi, items)\n                    .replace(/%mselectListClass%/gi, o.mselectListClass)\n                    .replace(/%mselectButtonAddClass%/gi, o.mselectButtonAddClass)\n                    .replace(/%mselectButtonSaveClass%/gi, o.mselectButtonSaveClass)\n                    .replace(/%mselectButtonCancelClass%/gi, o.mselectButtonCancelClass)\n                    .replace(/%mselectItemsWrapperClass%/gi, o.mselectItemsWrapperClass)\n                    .replace(/%mselectInputContainerClass%/gi, o.mselectInputContainerClass)\n                    .replace(/%mselectInputClass%/gi, o.mselectInputClass)\n                    .replace(/%addText%/gi, o.addText)\n                    .replace(/%cancelText%/gi, o.cancelText)\n                    .replace(/%inputTitle%/gi, o.inputTitle),\n                widget = $(html)\n                    .insertAfter(this)\n                    .on('change.mselectCheck', '[type=checkbox]', function() {\n                        var checkbox = $(this),\n                            index = checkbox.closest('.' + o.mselectListItemClass + '').index();\n\n                        select.find('option').eq(index).attr('selected', !!checkbox.attr('checked'));\n                    }),\n                list = widget.find('.' + o.mselectItemsWrapperClass + ''),\n                buttonAdd = widget.find('.' + o.mselectButtonAddClass + '')\n                    .on('click.mselectAdd', function(e) {\n                        e.preventDefault();\n                        o.toggleAddButton && buttonAdd.hide();\n                        container.show();\n                        input.focus();\n                        if (input.parents(o.mselectListClass).length) {\n                            list.scrollTop(list.height());\n                        }\n                    }),\n                container = widget.find('.' + o.mselectInputContainerClass + ''),\n                input = container.find('[type=text].' + o.mselectInputClass + '')\n                    .on('blur.mselectReset', function() {\n                        reset();\n                    })\n                    .on('keydown.mselectAddNewOption', function(e) {\n                        var c = e.keyCode;\n\n                        if (c == o.keyCodes.Enter || c == o.keyCodes.Esc) {\n                            e.preventDefault();\n                            c == o.keyCodes.Enter ? append(input.val())  : reset();\n                        }\n                    }),\n                buttonSave = container.find('.' + o.mselectButtonSaveClass + '')\n                    .on('mousedown.mselectSave', function(e) {\n                        append(input.val());\n                    }),\n                buttonCancel = container.find('.' + o.mselectButtonCancelClass + '')\n                    .on('mousedown.mdelectCancel', function(e) {\n                        input.val('');\n                    }),\n                append = function(v) {\n                    // Add ability to define custom handler for adding new values\n                    if ($.isFunction(o.mselectInputSubmitCallback)) {\n                        o.mselectInputSubmitCallback(v, o);\n                        return;\n                    }\n                    // end of callback implementation\n                    $.each(typeof(o.parse) == 'function' ? o.parse(v) : [$.trim(v)], function(i, v) {\n                        var item;\n\n                        if (v && !select.children('[value=\"' + v + '\"]').length) {\n                            item = $(o.item.replace(/%value%|%label%/gi, v)\n                                .replace(/%mselectDisabledClass%|%iseditable%|%isremovable%/gi,'')\n                                .replace(/%mselectListItemClass%/gi,o.mselectListItemClass))\n                                .find('[type=checkbox]')\n                                .attr('checked', true)\n                                .addClass(o.mselectCheckedClass)\n                                .end();\n\n                            list.children('.' + o.mselectListItemClass + '').length\n                                ? list.children('.' + o.mselectListItemClass + ':last').after(item)\n                                : list.prepend(item);\n\n                            select.append('<option value=\"' + v + '\" selected=\"selected\">' + v + '</option>');\n                        }\n                    });\n\n                    reset();\n                    list.scrollTop(list.height());\n                },\n                reset = function() {\n                    var ch = select.children();\n\n                    input.val('');\n                    container.hide();\n                    buttonAdd.show();\n                    list[list.children().length ? 'show' : 'hide']();\n\n                    if (ch.length >= size && !list.hasClass(o.mselectItemsWrapperOverflowClass)) {\n                        list.height(list.children('.' + o.mselectListItemClass + ':first')\n                            .outerHeight(true) * size)\n                            .addClass(o.mselectItemsWrapperOverflowClass);\n                    }\n                };\n            reset();\n        }).end();\n    };\n});","jquery/fileUploader/jquery.fileupload-fp.js":"/*\n * jQuery File Upload File Processing Plugin 1.0\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2012, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint nomen: true, unparam: true, regexp: true */\n/*global define, window, document */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define([\n            'jquery',\n            'jquery/fileUploader/load-image',\n            'jquery/fileUploader/canvas-to-blob',\n            'jquery/fileUploader/jquery.fileupload'\n        ], factory);\n    } else {\n        // Browser globals:\n        factory(\n            window.jQuery,\n            window.loadImage\n        );\n    }\n}(function ($, loadImage) {\n    'use strict';\n\n    // The File Upload IP version extends the basic fileupload widget\n    // with file processing functionality:\n    $.widget('blueimpFP.fileupload', $.blueimp.fileupload, {\n\n        options: {\n            // The list of file processing actions:\n            process: [\n            /*\n                {\n                    action: 'load',\n                    fileTypes: /^image\\/(gif|jpeg|png)$/,\n                    maxFileSize: 20000000 // 20MB\n                },\n                {\n                    action: 'resize',\n                    maxWidth: 1920,\n                    maxHeight: 1200,\n                    minWidth: 800,\n                    minHeight: 600\n                },\n                {\n                    action: 'save'\n                }\n            */\n            ],\n\n            // The add callback is invoked as soon as files are added to the\n            // fileupload widget (via file input selection, drag & drop or add\n            // API call). See the basic file upload widget for more information:\n            add: function (e, data) {\n                $(this).fileupload('process', data).done(function () {\n                    data.submit();\n                });\n            }\n        },\n\n        processActions: {\n            // Loads the image given via data.files and data.index\n            // as canvas element.\n            // Accepts the options fileTypes (regular expression)\n            // and maxFileSize (integer) to limit the files to load:\n            load: function (data, options) {\n                var that = this,\n                    file = data.files[data.index],\n                    dfd = $.Deferred();\n                if (window.HTMLCanvasElement &&\n                        window.HTMLCanvasElement.prototype.toBlob &&\n                        ($.type(options.maxFileSize) !== 'number' ||\n                            file.size < options.maxFileSize) &&\n                        (!options.fileTypes ||\n                            options.fileTypes.test(file.type))) {\n                    loadImage(\n                        file,\n                        function (canvas) {\n                            data.canvas = canvas;\n                            dfd.resolveWith(that, [data]);\n                        },\n                        {canvas: true}\n                    );\n                } else {\n                    dfd.rejectWith(that, [data]);\n                }\n                return dfd.promise();\n            },\n            // Resizes the image given as data.canvas and updates\n            // data.canvas with the resized image.\n            // Accepts the options maxWidth, maxHeight, minWidth and\n            // minHeight to scale the given image:\n            resize: function (data, options) {\n                if (data.canvas) {\n                    var canvas = loadImage.scale(data.canvas, options);\n                    if (canvas.width !== data.canvas.width ||\n                            canvas.height !== data.canvas.height) {\n                        data.canvas = canvas;\n                        data.processed = true;\n                    }\n                }\n                return data;\n            },\n            // Saves the processed image given as data.canvas\n            // inplace at data.index of data.files:\n            save: function (data, options) {\n                // Do nothing if no processing has happened:\n                if (!data.canvas || !data.processed) {\n                    return data;\n                }\n                var that = this,\n                    file = data.files[data.index],\n                    name = file.name,\n                    dfd = $.Deferred(),\n                    callback = function (blob) {\n                        if (!blob.name) {\n                            if (file.type === blob.type) {\n                                blob.name = file.name;\n                            } else if (file.name) {\n                                blob.name = file.name.replace(\n                                    /\\..+$/,\n                                    '.' + blob.type.substr(6)\n                                );\n                            }\n                        }\n                        // Store the created blob at the position\n                        // of the original file in the files list:\n                        data.files[data.index] = blob;\n                        dfd.resolveWith(that, [data]);\n                    };\n                // Use canvas.mozGetAsFile directly, to retain the filename, as\n                // Gecko doesn't support the filename option for FormData.append:\n                if (data.canvas.mozGetAsFile) {\n                    callback(data.canvas.mozGetAsFile(\n                        (/^image\\/(jpeg|png)$/.test(file.type) && name) ||\n                            ((name && name.replace(/\\..+$/, '')) ||\n                                'blob') + '.png',\n                        file.type\n                    ));\n                } else {\n                    data.canvas.toBlob(callback, file.type);\n                }\n                return dfd.promise();\n            }\n        },\n\n        // Resizes the file at the given index and stores the created blob at\n        // the original position of the files list, returns a Promise object:\n        _processFile: function (files, index, options) {\n            var that = this,\n                dfd = $.Deferred().resolveWith(that, [{\n                    files: files,\n                    index: index\n                }]),\n                chain = dfd.promise();\n            that._processing += 1;\n            $.each(options.process, function (i, settings) {\n                chain = chain.pipe(function (data) {\n                    return that.processActions[settings.action]\n                        .call(this, data, settings);\n                });\n            });\n            chain.always(function () {\n                that._processing -= 1;\n                if (that._processing === 0) {\n                    that.element\n                        .removeClass('fileupload-processing');\n                }\n            });\n            if (that._processing === 1) {\n                that.element.addClass('fileupload-processing');\n            }\n            return chain;\n        },\n\n        // Processes the files given as files property of the data parameter,\n        // returns a Promise object that allows to bind a done handler, which\n        // will be invoked after processing all files (inplace) is done:\n        process: function (data) {\n            var that = this,\n                options = $.extend({}, this.options, data);\n            if (options.process && options.process.length &&\n                    this._isXHRUpload(options)) {\n                $.each(data.files, function (index, file) {\n                    that._processingQueue = that._processingQueue.pipe(\n                        function () {\n                            var dfd = $.Deferred();\n                            that._processFile(data.files, index, options)\n                                .always(function () {\n                                    dfd.resolveWith(that);\n                                });\n                            return dfd.promise();\n                        }\n                    );\n                });\n            }\n            return this._processingQueue;\n        },\n\n        _create: function () {\n            $.blueimp.fileupload.prototype._create.call(this);\n            this._processing = 0;\n            this._processingQueue = $.Deferred().resolveWith(this)\n                .promise();\n        }\n\n    });\n\n}));\n","jquery/fileUploader/jquery.fileupload-ui.js":"/*\n * jQuery File Upload User Interface Plugin 6.9.5\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint nomen: true, unparam: true, regexp: true */\n/*global define, window, document, URL, webkitURL, FileReader */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define([\n            'jquery',\n            'mage/template',\n            'jquery/fileUploader/load-image',\n            'jquery/fileUploader/jquery.fileupload-fp',\n            'jquery/fileUploader/jquery.iframe-transport'\n        ], factory);\n    } else {\n        // Browser globals:\n        factory(\n            window.jQuery,\n            window.mageTemplate,\n            window.loadImage\n        );\n    }\n}(function ($, tmpl, loadImage) {\n    'use strict';\n\n    // The UI version extends the FP (file processing) version or the basic\n    // file upload widget and adds complete user interface interaction:\n    var parentWidget = ($.blueimpFP || $.blueimp).fileupload;\n    $.widget('blueimpUI.fileupload', parentWidget, {\n\n        options: {\n            // By default, files added to the widget are uploaded as soon\n            // as the user clicks on the start buttons. To enable automatic\n            // uploads, set the following option to true:\n            autoUpload: false,\n            // The following option limits the number of files that are\n            // allowed to be uploaded using this widget:\n            maxNumberOfFiles: undefined,\n            // The maximum allowed file size:\n            maxFileSize: undefined,\n            // The minimum allowed file size:\n            minFileSize: undefined,\n            // The regular expression for allowed file types, matches\n            // against either file type or file name:\n            acceptFileTypes:  /.+$/i,\n            // The regular expression to define for which files a preview\n            // image is shown, matched against the file type:\n            previewSourceFileTypes: /^image\\/(gif|jpeg|png)$/,\n            // The maximum file size of images that are to be displayed as preview:\n            previewSourceMaxFileSize: 5000000, // 5MB\n            // The maximum width of the preview images:\n            previewMaxWidth: 80,\n            // The maximum height of the preview images:\n            previewMaxHeight: 80,\n            // By default, preview images are displayed as canvas elements\n            // if supported by the browser. Set the following option to false\n            // to always display preview images as img elements:\n            previewAsCanvas: true,\n            // The ID of the upload template:\n            uploadTemplateId: 'template-upload',\n            // The ID of the download template:\n            downloadTemplateId: 'template-download',\n            // The container for the list of files. If undefined, it is set to\n            // an element with class \"files\" inside of the widget element:\n            filesContainer: undefined,\n            // By default, files are appended to the files container.\n            // Set the following option to true, to prepend files instead:\n            prependFiles: false,\n            // The expected data type of the upload response, sets the dataType\n            // option of the $.ajax upload requests:\n            dataType: 'json',\n\n            // The add callback is invoked as soon as files are added to the fileupload\n            // widget (via file input selection, drag & drop or add API call).\n            // See the basic file upload widget for more information:\n            add: function (e, data) {\n                var that = $(this).data('fileupload'),\n                    options = that.options,\n                    files = data.files;\n                $(this).fileupload('process', data).done(function () {\n                    that._adjustMaxNumberOfFiles(-files.length);\n                    data.maxNumberOfFilesAdjusted = true;\n                    data.files.valid = data.isValidated = that._validate(files);\n                    data.context = that._renderUpload(files).data('data', data);\n                    options.filesContainer[\n                        options.prependFiles ? 'prepend' : 'append'\n                    ](data.context);\n                    that._renderPreviews(files, data.context);\n                    that._forceReflow(data.context);\n                    that._transition(data.context).done(\n                        function () {\n                            if ((that._trigger('added', e, data) !== false) &&\n                                    (options.autoUpload || data.autoUpload) &&\n                                    data.autoUpload !== false && data.isValidated) {\n                                data.submit();\n                            }\n                        }\n                    );\n                });\n            },\n            // Callback for the start of each file upload request:\n            send: function (e, data) {\n                var that = $(this).data('fileupload');\n                if (!data.isValidated) {\n                    if (!data.maxNumberOfFilesAdjusted) {\n                        that._adjustMaxNumberOfFiles(-data.files.length);\n                        data.maxNumberOfFilesAdjusted = true;\n                    }\n                    if (!that._validate(data.files)) {\n                        return false;\n                    }\n                }\n                if (data.context && data.dataType &&\n                        data.dataType.substr(0, 6) === 'iframe') {\n                    // Iframe Transport does not support progress events.\n                    // In lack of an indeterminate progress bar, we set\n                    // the progress to 100%, showing the full animated bar:\n                    data.context\n                        .find('.progress').addClass(\n                            !$.support.transition && 'progress-animated'\n                        )\n                        .attr('aria-valuenow', 100)\n                        .find('.bar').css(\n                            'width',\n                            '100%'\n                        );\n                }\n                return that._trigger('sent', e, data);\n            },\n            // Callback for successful uploads:\n            done: function (e, data) {\n                var that = $(this).data('fileupload'),\n                    template;\n                if (data.context) {\n                    data.context.each(function (index) {\n                        var file = ($.isArray(data.result) &&\n                                data.result[index]) || {error: 'emptyResult'};\n                        if (file.error) {\n                            that._adjustMaxNumberOfFiles(1);\n                        }\n                        that._transition($(this)).done(\n                            function () {\n                                var node = $(this);\n                                template = that._renderDownload([file])\n                                    .replaceAll(node);\n                                that._forceReflow(template);\n                                that._transition(template).done(\n                                    function () {\n                                        data.context = $(this);\n                                        that._trigger('completed', e, data);\n                                    }\n                                );\n                            }\n                        );\n                    });\n                } else {\n                    if ($.isArray(data.result)) {\n                        $.each(data.result, function (index, file) {\n                            if (data.maxNumberOfFilesAdjusted && file.error) {\n                                that._adjustMaxNumberOfFiles(1);\n                            } else if (!data.maxNumberOfFilesAdjusted &&\n                                    !file.error) {\n                                that._adjustMaxNumberOfFiles(-1);\n                            }\n                        });\n                        data.maxNumberOfFilesAdjusted = true;\n                    }\n                    template = that._renderDownload(data.result)\n                        .appendTo(that.options.filesContainer);\n                    that._forceReflow(template);\n                    that._transition(template).done(\n                        function () {\n                            data.context = $(this);\n                            that._trigger('completed', e, data);\n                        }\n                    );\n                }\n            },\n            // Callback for failed (abort or error) uploads:\n            fail: function (e, data) {\n                var that = $(this).data('fileupload'),\n                    template;\n                if (data.maxNumberOfFilesAdjusted) {\n                    that._adjustMaxNumberOfFiles(data.files.length);\n                }\n                if (data.context) {\n                    data.context.each(function (index) {\n                        if (data.errorThrown !== 'abort') {\n                            var file = data.files[index];\n                            file.error = file.error || data.errorThrown ||\n                                true;\n                            that._transition($(this)).done(\n                                function () {\n                                    var node = $(this);\n                                    template = that._renderDownload([file])\n                                        .replaceAll(node);\n                                    that._forceReflow(template);\n                                    that._transition(template).done(\n                                        function () {\n                                            data.context = $(this);\n                                            that._trigger('failed', e, data);\n                                        }\n                                    );\n                                }\n                            );\n                        } else {\n                            that._transition($(this)).done(\n                                function () {\n                                    $(this).remove();\n                                    that._trigger('failed', e, data);\n                                }\n                            );\n                        }\n                    });\n                } else if (data.errorThrown !== 'abort') {\n                    data.context = that._renderUpload(data.files)\n                        .appendTo(that.options.filesContainer)\n                        .data('data', data);\n                    that._forceReflow(data.context);\n                    that._transition(data.context).done(\n                        function () {\n                            data.context = $(this);\n                            that._trigger('failed', e, data);\n                        }\n                    );\n                } else {\n                    that._trigger('failed', e, data);\n                }\n            },\n            // Callback for upload progress events:\n            progress: function (e, data) {\n                if (data.context) {\n                    var progress = parseInt(data.loaded / data.total * 100, 10);\n                    data.context.find('.progress')\n                        .attr('aria-valuenow', progress)\n                        .find('.bar').css(\n                            'width',\n                            progress + '%'\n                        );\n                }\n            },\n            // Callback for global upload progress events:\n            progressall: function (e, data) {\n                var $this = $(this),\n                    progress = parseInt(data.loaded / data.total * 100, 10),\n                    globalProgressNode = $this.find('.fileupload-progress'),\n                    extendedProgressNode = globalProgressNode\n                        .find('.progress-extended');\n                if (extendedProgressNode.length) {\n                    extendedProgressNode.html(\n                        $this.data('fileupload')._renderExtendedProgress(data)\n                    );\n                }\n                globalProgressNode\n                    .find('.progress')\n                    .attr('aria-valuenow', progress)\n                    .find('.bar').css(\n                        'width',\n                        progress + '%'\n                    );\n            },\n            // Callback for uploads start, equivalent to the global ajaxStart event:\n            start: function (e) {\n                var that = $(this).data('fileupload');\n                that._transition($(this).find('.fileupload-progress')).done(\n                    function () {\n                        that._trigger('started', e);\n                    }\n                );\n            },\n            // Callback for uploads stop, equivalent to the global ajaxStop event:\n            stop: function (e) {\n                var that = $(this).data('fileupload');\n                that._transition($(this).find('.fileupload-progress')).done(\n                    function () {\n                        $(this).find('.progress')\n                            .attr('aria-valuenow', '0')\n                            .find('.bar').css('width', '0%');\n                        $(this).find('.progress-extended').html('&nbsp;');\n                        that._trigger('stopped', e);\n                    }\n                );\n            },\n            // Callback for file deletion:\n            destroy: function (e, data) {\n                var that = $(this).data('fileupload');\n                if (data.url) {\n                    $.ajax(data);\n                    that._adjustMaxNumberOfFiles(1);\n                }\n                that._transition(data.context).done(\n                    function () {\n                        $(this).remove();\n                        that._trigger('destroyed', e, data);\n                    }\n                );\n            }\n        },\n\n        // Link handler, that allows to download files\n        // by drag & drop of the links to the desktop:\n        _enableDragToDesktop: function () {\n            var link = $(this),\n                url = link.prop('href'),\n                name = link.prop('download'),\n                type = 'application/octet-stream';\n            link.bind('dragstart', function (e) {\n                try {\n                    e.originalEvent.dataTransfer.setData(\n                        'DownloadURL',\n                        [type, name, url].join(':')\n                    );\n                } catch (err) {}\n            });\n        },\n\n        _adjustMaxNumberOfFiles: function (operand) {\n            if (typeof this.options.maxNumberOfFiles === 'number') {\n                this.options.maxNumberOfFiles += operand;\n                if (this.options.maxNumberOfFiles < 1) {\n                    this._disableFileInputButton();\n                } else {\n                    this._enableFileInputButton();\n                }\n            }\n        },\n\n        _formatFileSize: function (bytes) {\n            if (typeof bytes !== 'number') {\n                return '';\n            }\n            if (bytes >= 1000000000) {\n                return (bytes / 1000000000).toFixed(2) + ' GB';\n            }\n            if (bytes >= 1000000) {\n                return (bytes / 1000000).toFixed(2) + ' MB';\n            }\n            return (bytes / 1000).toFixed(2) + ' KB';\n        },\n\n        _formatBitrate: function (bits) {\n            if (typeof bits !== 'number') {\n                return '';\n            }\n            if (bits >= 1000000000) {\n                return (bits / 1000000000).toFixed(2) + ' Gbit/s';\n            }\n            if (bits >= 1000000) {\n                return (bits / 1000000).toFixed(2) + ' Mbit/s';\n            }\n            if (bits >= 1000) {\n                return (bits / 1000).toFixed(2) + ' kbit/s';\n            }\n            return bits + ' bit/s';\n        },\n\n        _formatTime: function (seconds) {\n            var date = new Date(seconds * 1000),\n                days = parseInt(seconds / 86400, 10);\n            days = days ? days + 'd ' : '';\n            return days +\n                ('0' + date.getUTCHours()).slice(-2) + ':' +\n                ('0' + date.getUTCMinutes()).slice(-2) + ':' +\n                ('0' + date.getUTCSeconds()).slice(-2);\n        },\n\n        _formatPercentage: function (floatValue) {\n            return (floatValue * 100).toFixed(2) + ' %';\n        },\n\n        _renderExtendedProgress: function (data) {\n            return this._formatBitrate(data.bitrate) + ' | ' +\n                this._formatTime(\n                    (data.total - data.loaded) * 8 / data.bitrate\n                ) + ' | ' +\n                this._formatPercentage(\n                    data.loaded / data.total\n                ) + ' | ' +\n                this._formatFileSize(data.loaded) + ' / ' +\n                this._formatFileSize(data.total);\n        },\n\n        _hasError: function (file) {\n            if (file.error) {\n                return file.error;\n            }\n            // The number of added files is subtracted from\n            // maxNumberOfFiles before validation, so we check if\n            // maxNumberOfFiles is below 0 (instead of below 1):\n            if (this.options.maxNumberOfFiles < 0) {\n                return 'maxNumberOfFiles';\n            }\n            // Files are accepted if either the file type or the file name\n            // matches against the acceptFileTypes regular expression, as\n            // only browsers with support for the File API report the type:\n            if (!(this.options.acceptFileTypes.test(file.type) ||\n                    this.options.acceptFileTypes.test(file.name))) {\n                return 'acceptFileTypes';\n            }\n            if (this.options.maxFileSize &&\n                    file.size > this.options.maxFileSize) {\n                return 'maxFileSize';\n            }\n            if (typeof file.size === 'number' &&\n                    file.size < this.options.minFileSize) {\n                return 'minFileSize';\n            }\n            return null;\n        },\n\n        _validate: function (files) {\n            var that = this,\n                valid = !!files.length;\n            $.each(files, function (index, file) {\n                file.error = that._hasError(file);\n                if (file.error) {\n                    valid = false;\n                }\n            });\n            return valid;\n        },\n\n        _renderTemplate: function (func, files) {\n            if (!func) {\n                return $();\n            }\n            var result = func({\n                files: files,\n                formatFileSize: this._formatFileSize,\n                options: this.options\n            });\n            if (result instanceof $) {\n                return result;\n            }\n            return $(this.options.templatesContainer).html(result).children();\n        },\n\n        _renderPreview: function (file, node) {\n            var that = this,\n                options = this.options,\n                dfd = $.Deferred();\n            return ((loadImage && loadImage(\n                file,\n                function (img) {\n                    node.append(img);\n                    that._forceReflow(node);\n                    that._transition(node).done(function () {\n                        dfd.resolveWith(node);\n                    });\n                    if (!$.contains(document.body, node[0])) {\n                        // If the element is not part of the DOM,\n                        // transition events are not triggered,\n                        // so we have to resolve manually:\n                        dfd.resolveWith(node);\n                    }\n                },\n                {\n                    maxWidth: options.previewMaxWidth,\n                    maxHeight: options.previewMaxHeight,\n                    canvas: options.previewAsCanvas\n                }\n            )) || dfd.resolveWith(node)) && dfd;\n        },\n\n        _renderPreviews: function (files, nodes) {\n            var that = this,\n                options = this.options;\n            nodes.find('.preview span').each(function (index, element) {\n                var file = files[index];\n                if (options.previewSourceFileTypes.test(file.type) &&\n                        ($.type(options.previewSourceMaxFileSize) !== 'number' ||\n                        file.size < options.previewSourceMaxFileSize)) {\n                    that._processingQueue = that._processingQueue.pipe(function () {\n                        var dfd = $.Deferred();\n                        that._renderPreview(file, $(element)).done(\n                            function () {\n                                dfd.resolveWith(that);\n                            }\n                        );\n                        return dfd.promise();\n                    });\n                }\n            });\n            return this._processingQueue;\n        },\n\n        _renderUpload: function (files) {\n            return this._renderTemplate(\n                this.options.uploadTemplate,\n                files\n            );\n        },\n\n        _renderDownload: function (files) {\n            return this._renderTemplate(\n                this.options.downloadTemplate,\n                files\n            ).find('a[download]').each(this._enableDragToDesktop).end();\n        },\n\n        _startHandler: function (e) {\n            e.preventDefault();\n            var button = $(this),\n                template = button.closest('.template-upload'),\n                data = template.data('data');\n            if (data && data.submit && !data.jqXHR && data.submit()) {\n                button.prop('disabled', true);\n            }\n        },\n\n        _cancelHandler: function (e) {\n            e.preventDefault();\n            var template = $(this).closest('.template-upload'),\n                data = template.data('data') || {};\n            if (!data.jqXHR) {\n                data.errorThrown = 'abort';\n                e.data.fileupload._trigger('fail', e, data);\n            } else {\n                data.jqXHR.abort();\n            }\n        },\n\n        _deleteHandler: function (e) {\n            e.preventDefault();\n            var button = $(this);\n            e.data.fileupload._trigger('destroy', e, {\n                context: button.closest('.template-download'),\n                url: button.attr('data-url'),\n                type: button.attr('data-type') || 'DELETE',\n                dataType: e.data.fileupload.options.dataType\n            });\n        },\n\n        _forceReflow: function (node) {\n            return $.support.transition && node.length &&\n                node[0].offsetWidth;\n        },\n\n        _transition: function (node) {\n            var dfd = $.Deferred();\n            if ($.support.transition && node.hasClass('fade')) {\n                node.bind(\n                    $.support.transition.end,\n                    function (e) {\n                        // Make sure we don't respond to other transitions events\n                        // in the container element, e.g. from button elements:\n                        if (e.target === node[0]) {\n                            node.unbind($.support.transition.end);\n                            dfd.resolveWith(node);\n                        }\n                    }\n                ).toggleClass('in');\n            } else {\n                node.toggleClass('in');\n                dfd.resolveWith(node);\n            }\n            return dfd;\n        },\n\n        _initButtonBarEventHandlers: function () {\n            var fileUploadButtonBar = this.element.find('.fileupload-buttonbar'),\n                filesList = this.options.filesContainer,\n                ns = this.options.namespace;\n            fileUploadButtonBar.find('.start')\n                .bind('click.' + ns, function (e) {\n                    e.preventDefault();\n                    filesList.find('.start button').click();\n                });\n            fileUploadButtonBar.find('.cancel')\n                .bind('click.' + ns, function (e) {\n                    e.preventDefault();\n                    filesList.find('.cancel button').click();\n                });\n            fileUploadButtonBar.find('.delete')\n                .bind('click.' + ns, function (e) {\n                    e.preventDefault();\n                    filesList.find('.delete input:checked')\n                        .siblings('button').click();\n                    fileUploadButtonBar.find('.toggle')\n                        .prop('checked', false);\n                });\n            fileUploadButtonBar.find('.toggle')\n                .bind('change.' + ns, function (e) {\n                    filesList.find('.delete input').prop(\n                        'checked',\n                        $(this).is(':checked')\n                    );\n                });\n        },\n\n        _destroyButtonBarEventHandlers: function () {\n            this.element.find('.fileupload-buttonbar button')\n                .unbind('click.' + this.options.namespace);\n            this.element.find('.fileupload-buttonbar .toggle')\n                .unbind('change.' + this.options.namespace);\n        },\n\n        _initEventHandlers: function () {\n            parentWidget.prototype._initEventHandlers.call(this);\n            var eventData = {fileupload: this};\n            this.options.filesContainer\n                .delegate(\n                    '.start button',\n                    'click.' + this.options.namespace,\n                    eventData,\n                    this._startHandler\n                )\n                .delegate(\n                    '.cancel button',\n                    'click.' + this.options.namespace,\n                    eventData,\n                    this._cancelHandler\n                )\n                .delegate(\n                    '.delete button',\n                    'click.' + this.options.namespace,\n                    eventData,\n                    this._deleteHandler\n                );\n            this._initButtonBarEventHandlers();\n        },\n\n        _destroyEventHandlers: function () {\n            var options = this.options;\n            this._destroyButtonBarEventHandlers();\n            options.filesContainer\n                .undelegate('.start button', 'click.' + options.namespace)\n                .undelegate('.cancel button', 'click.' + options.namespace)\n                .undelegate('.delete button', 'click.' + options.namespace);\n            parentWidget.prototype._destroyEventHandlers.call(this);\n        },\n\n        _enableFileInputButton: function () {\n            this.element.find('.fileinput-button input')\n                .prop('disabled', false)\n                .parent().removeClass('disabled');\n        },\n\n        _disableFileInputButton: function () {\n            this.element.find('.fileinput-button input')\n                .prop('disabled', true)\n                .parent().addClass('disabled');\n        },\n\n        _initTemplates: function () {\n            var options = this.options;\n            options.templatesContainer = document.createElement(\n                options.filesContainer.prop('nodeName')\n            );\n            if (tmpl) {\n                if (options.uploadTemplateId) {\n                    options.uploadTemplate = tmpl(options.uploadTemplateId);\n                }\n                if (options.downloadTemplateId) {\n                    options.downloadTemplate = tmpl(options.downloadTemplateId);\n                }\n            }\n        },\n\n        _initFilesContainer: function () {\n            var options = this.options;\n            if (options.filesContainer === undefined) {\n                options.filesContainer = this.element.find('.files');\n            } else if (!(options.filesContainer instanceof $)) {\n                options.filesContainer = $(options.filesContainer);\n            }\n        },\n\n        _stringToRegExp: function (str) {\n            var parts = str.split('/'),\n                modifiers = parts.pop();\n            parts.shift();\n            return new RegExp(parts.join('/'), modifiers);\n        },\n\n        _initRegExpOptions: function () {\n            var options = this.options;\n            if ($.type(options.acceptFileTypes) === 'string') {\n                options.acceptFileTypes = this._stringToRegExp(\n                    options.acceptFileTypes\n                );\n            }\n            if ($.type(options.previewSourceFileTypes) === 'string') {\n                options.previewSourceFileTypes = this._stringToRegExp(\n                    options.previewSourceFileTypes\n                );\n            }\n        },\n\n        _initSpecialOptions: function () {\n            parentWidget.prototype._initSpecialOptions.call(this);\n            this._initFilesContainer();\n            this._initTemplates();\n            this._initRegExpOptions();\n        },\n\n        _create: function () {\n            parentWidget.prototype._create.call(this);\n            this._refreshOptionsList.push(\n                'filesContainer',\n                'uploadTemplateId',\n                'downloadTemplateId'\n            );\n            if (!$.blueimpFP) {\n                this._processingQueue = $.Deferred().resolveWith(this).promise();\n                this.process = function () {\n                    return this._processingQueue;\n                };\n            }\n        },\n\n        enable: function () {\n            var wasDisabled = false;\n            if (this.options.disabled) {\n                wasDisabled = true;\n            }\n            parentWidget.prototype.enable.call(this);\n            if (wasDisabled) {\n                this.element.find('input, button').prop('disabled', false);\n                this._enableFileInputButton();\n            }\n        },\n\n        disable: function () {\n            if (!this.options.disabled) {\n                this.element.find('input, button').prop('disabled', true);\n                this._disableFileInputButton();\n            }\n            parentWidget.prototype.disable.call(this);\n        }\n\n    });\n\n}));\n","jquery/fileUploader/jquery.fileupload.js":"/*\n * jQuery File Upload Plugin 5.16.4\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint nomen: true, unparam: true, regexp: true */\n/*global define, window, document, Blob, FormData, location */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define([\n            'jquery',\n            'jquery/ui',\n            'jquery/fileUploader/jquery.iframe-transport'\n        ], factory);\n    } else {\n        // Browser globals:\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    // The FileReader API is not actually used, but works as feature detection,\n    // as e.g. Safari supports XHR file uploads via the FormData API,\n    // but not non-multipart XHR file uploads:\n    $.support.xhrFileUpload = !!(window.XMLHttpRequestUpload && window.FileReader);\n    $.support.xhrFormDataFileUpload = !!window.FormData;\n\n    // The fileupload widget listens for change events on file input fields defined\n    // via fileInput setting and paste or drop events of the given dropZone.\n    // In addition to the default jQuery Widget methods, the fileupload widget\n    // exposes the \"add\" and \"send\" methods, to add or directly send files using\n    // the fileupload API.\n    // By default, files added via file input selection, paste, drag & drop or\n    // \"add\" method are uploaded immediately, but it is possible to override\n    // the \"add\" callback option to queue file uploads.\n    $.widget('blueimp.fileupload', {\n\n        options: {\n            // The namespace used for event handler binding on the dropZone and\n            // fileInput collections.\n            // If not set, the name of the widget (\"fileupload\") is used.\n            namespace: undefined,\n            // The drop target collection, by the default the complete document.\n            // Set to null or an empty collection to disable drag & drop support:\n            dropZone: $(document),\n            // The file input field collection, that is listened for change events.\n            // If undefined, it is set to the file input fields inside\n            // of the widget element on plugin initialization.\n            // Set to null or an empty collection to disable the change listener.\n            fileInput: undefined,\n            // By default, the file input field is replaced with a clone after\n            // each input field change event. This is required for iframe transport\n            // queues and allows change events to be fired for the same file\n            // selection, but can be disabled by setting the following option to false:\n            replaceFileInput: true,\n            // The parameter name for the file form data (the request argument name).\n            // If undefined or empty, the name property of the file input field is\n            // used, or \"files[]\" if the file input name property is also empty,\n            // can be a string or an array of strings:\n            paramName: undefined,\n            // By default, each file of a selection is uploaded using an individual\n            // request for XHR type uploads. Set to false to upload file\n            // selections in one request each:\n            singleFileUploads: true,\n            // To limit the number of files uploaded with one XHR request,\n            // set the following option to an integer greater than 0:\n            limitMultiFileUploads: undefined,\n            // Set the following option to true to issue all file upload requests\n            // in a sequential order:\n            sequentialUploads: false,\n            // To limit the number of concurrent uploads,\n            // set the following option to an integer greater than 0:\n            limitConcurrentUploads: undefined,\n            // Set the following option to true to force iframe transport uploads:\n            forceIframeTransport: false,\n            // Set the following option to the location of a redirect url on the\n            // origin server, for cross-domain iframe transport uploads:\n            redirect: undefined,\n            // The parameter name for the redirect url, sent as part of the form\n            // data and set to 'redirect' if this option is empty:\n            redirectParamName: undefined,\n            // Set the following option to the location of a postMessage window,\n            // to enable postMessage transport uploads:\n            postMessage: undefined,\n            // By default, XHR file uploads are sent as multipart/form-data.\n            // The iframe transport is always using multipart/form-data.\n            // Set to false to enable non-multipart XHR uploads:\n            multipart: true,\n            // To upload large files in smaller chunks, set the following option\n            // to a preferred maximum chunk size. If set to 0, null or undefined,\n            // or the browser does not support the required Blob API, files will\n            // be uploaded as a whole.\n            maxChunkSize: undefined,\n            // When a non-multipart upload or a chunked multipart upload has been\n            // aborted, this option can be used to resume the upload by setting\n            // it to the size of the already uploaded bytes. This option is most\n            // useful when modifying the options object inside of the \"add\" or\n            // \"send\" callbacks, as the options are cloned for each file upload.\n            uploadedBytes: undefined,\n            // By default, failed (abort or error) file uploads are removed from the\n            // global progress calculation. Set the following option to false to\n            // prevent recalculating the global progress data:\n            recalculateProgress: true,\n            // Interval in milliseconds to calculate and trigger progress events:\n            progressInterval: 100,\n            // Interval in milliseconds to calculate progress bitrate:\n            bitrateInterval: 500,\n\n            // Additional form data to be sent along with the file uploads can be set\n            // using this option, which accepts an array of objects with name and\n            // value properties, a function returning such an array, a FormData\n            // object (for XHR file uploads), or a simple object.\n            // The form of the first fileInput is given as parameter to the function:\n            formData: function (form) {\n                return form.serializeArray();\n            },\n\n            // The add callback is invoked as soon as files are added to the fileupload\n            // widget (via file input selection, drag & drop, paste or add API call).\n            // If the singleFileUploads option is enabled, this callback will be\n            // called once for each file in the selection for XHR file uplaods, else\n            // once for each file selection.\n            // The upload starts when the submit method is invoked on the data parameter.\n            // The data object contains a files property holding the added files\n            // and allows to override plugin options as well as define ajax settings.\n            // Listeners for this callback can also be bound the following way:\n            // .bind('fileuploadadd', func);\n            // data.submit() returns a Promise object and allows to attach additional\n            // handlers using jQuery's Deferred callbacks:\n            // data.submit().done(func).fail(func).always(func);\n            add: function (e, data) {\n                data.submit();\n            },\n\n            // Other callbacks:\n            // Callback for the submit event of each file upload:\n            // submit: function (e, data) {}, // .bind('fileuploadsubmit', func);\n            // Callback for the start of each file upload request:\n            // send: function (e, data) {}, // .bind('fileuploadsend', func);\n            // Callback for successful uploads:\n            // done: function (e, data) {}, // .bind('fileuploaddone', func);\n            // Callback for failed (abort or error) uploads:\n            // fail: function (e, data) {}, // .bind('fileuploadfail', func);\n            // Callback for completed (success, abort or error) requests:\n            // always: function (e, data) {}, // .bind('fileuploadalways', func);\n            // Callback for upload progress events:\n            // progress: function (e, data) {}, // .bind('fileuploadprogress', func);\n            // Callback for global upload progress events:\n            // progressall: function (e, data) {}, // .bind('fileuploadprogressall', func);\n            // Callback for uploads start, equivalent to the global ajaxStart event:\n            // start: function (e) {}, // .bind('fileuploadstart', func);\n            // Callback for uploads stop, equivalent to the global ajaxStop event:\n            // stop: function (e) {}, // .bind('fileuploadstop', func);\n            // Callback for change events of the fileInput collection:\n            // change: function (e, data) {}, // .bind('fileuploadchange', func);\n            // Callback for paste events to the dropZone collection:\n            // paste: function (e, data) {}, // .bind('fileuploadpaste', func);\n            // Callback for drop events of the dropZone collection:\n            // drop: function (e, data) {}, // .bind('fileuploaddrop', func);\n            // Callback for dragover events of the dropZone collection:\n            // dragover: function (e) {}, // .bind('fileuploaddragover', func);\n\n            // The plugin options are used as settings object for the ajax calls.\n            // The following are jQuery ajax settings required for the file uploads:\n            processData: false,\n            contentType: false,\n            cache: false\n        },\n\n        // A list of options that require a refresh after assigning a new value:\n        _refreshOptionsList: [\n            'namespace',\n            'dropZone',\n            'fileInput',\n            'multipart',\n            'forceIframeTransport'\n        ],\n\n        _BitrateTimer: function () {\n            this.timestamp = +(new Date());\n            this.loaded = 0;\n            this.bitrate = 0;\n            this.getBitrate = function (now, loaded, interval) {\n                var timeDiff = now - this.timestamp;\n                if (!this.bitrate || !interval || timeDiff > interval) {\n                    this.bitrate = (loaded - this.loaded) * (1000 / timeDiff) * 8;\n                    this.loaded = loaded;\n                    this.timestamp = now;\n                }\n                return this.bitrate;\n            };\n        },\n\n        _isXHRUpload: function (options) {\n            return !options.forceIframeTransport &&\n                ((!options.multipart && $.support.xhrFileUpload) ||\n                $.support.xhrFormDataFileUpload);\n        },\n\n        _getFormData: function (options) {\n            var formData;\n            if (typeof options.formData === 'function') {\n                return options.formData(options.form);\n            }\n\t\t\tif ($.isArray(options.formData)) {\n                return options.formData;\n            }\n\t\t\tif (options.formData) {\n                formData = [];\n                $.each(options.formData, function (name, value) {\n                    formData.push({name: name, value: value});\n                });\n                return formData;\n            }\n            return [];\n        },\n\n        _getTotal: function (files) {\n            var total = 0;\n            $.each(files, function (index, file) {\n                total += file.size || 1;\n            });\n            return total;\n        },\n\n        _onProgress: function (e, data) {\n            if (e.lengthComputable) {\n                var now = +(new Date()),\n                    total,\n                    loaded;\n                if (data._time && data.progressInterval &&\n                        (now - data._time < data.progressInterval) &&\n                        e.loaded !== e.total) {\n                    return;\n                }\n                data._time = now;\n                total = data.total || this._getTotal(data.files);\n                loaded = parseInt(\n                    e.loaded / e.total * (data.chunkSize || total),\n                    10\n                ) + (data.uploadedBytes || 0);\n                this._loaded += loaded - (data.loaded || data.uploadedBytes || 0);\n                data.lengthComputable = true;\n                data.loaded = loaded;\n                data.total = total;\n                data.bitrate = data._bitrateTimer.getBitrate(\n                    now,\n                    loaded,\n                    data.bitrateInterval\n                );\n                // Trigger a custom progress event with a total data property set\n                // to the file size(s) of the current upload and a loaded data\n                // property calculated accordingly:\n                this._trigger('progress', e, data);\n                // Trigger a global progress event for all current file uploads,\n                // including ajax calls queued for sequential file uploads:\n                this._trigger('progressall', e, {\n                    lengthComputable: true,\n                    loaded: this._loaded,\n                    total: this._total,\n                    bitrate: this._bitrateTimer.getBitrate(\n                        now,\n                        this._loaded,\n                        data.bitrateInterval\n                    )\n                });\n            }\n        },\n\n        _initProgressListener: function (options) {\n            var that = this,\n                xhr = options.xhr ? options.xhr() : $.ajaxSettings.xhr();\n            // Accesss to the native XHR object is required to add event listeners\n            // for the upload progress event:\n            if (xhr.upload) {\n                $(xhr.upload).bind('progress', function (e) {\n                    var oe = e.originalEvent;\n                    // Make sure the progress event properties get copied over:\n                    e.lengthComputable = oe.lengthComputable;\n                    e.loaded = oe.loaded;\n                    e.total = oe.total;\n                    that._onProgress(e, options);\n                });\n                options.xhr = function () {\n                    return xhr;\n                };\n            }\n        },\n\n        _initXHRData: function (options) {\n            var formData,\n                file = options.files[0],\n                // Ignore non-multipart setting if not supported:\n                multipart = options.multipart || !$.support.xhrFileUpload,\n                paramName = options.paramName[0];\n            if (!multipart || options.blob) {\n                // For non-multipart uploads and chunked uploads,\n                // file meta data is not part of the request body,\n                // so we transmit this data as part of the HTTP headers.\n                // For cross domain requests, these headers must be allowed\n                // via Access-Control-Allow-Headers or removed using\n                // the beforeSend callback:\n                options.headers = $.extend(options.headers, {\n                    'X-File-Name': file.name,\n                    'X-File-Type': file.type,\n                    'X-File-Size': file.size\n                });\n                if (!options.blob) {\n                    // Non-chunked non-multipart upload:\n                    options.contentType = file.type;\n                    options.data = file;\n                } else if (!multipart) {\n                    // Chunked non-multipart upload:\n                    options.contentType = 'application/octet-stream';\n                    options.data = options.blob;\n                }\n            }\n            if (multipart && $.support.xhrFormDataFileUpload) {\n                if (options.postMessage) {\n                    // window.postMessage does not allow sending FormData\n                    // objects, so we just add the File/Blob objects to\n                    // the formData array and let the postMessage window\n                    // create the FormData object out of this array:\n                    formData = this._getFormData(options);\n                    if (options.blob) {\n                        formData.push({\n                            name: paramName,\n                            value: options.blob\n                        });\n                    } else {\n                        $.each(options.files, function (index, file) {\n                            formData.push({\n                                name: options.paramName[index] || paramName,\n                                value: file\n                            });\n                        });\n                    }\n                } else {\n                    if (options.formData instanceof FormData) {\n                        formData = options.formData;\n                    } else {\n                        formData = new FormData();\n                        $.each(this._getFormData(options), function (index, field) {\n                            formData.append(field.name, field.value);\n                        });\n                    }\n                    if (options.blob) {\n                        formData.append(paramName, options.blob, file.name);\n                    } else {\n                        $.each(options.files, function (index, file) {\n                            // File objects are also Blob instances.\n                            // This check allows the tests to run with\n                            // dummy objects:\n                            if (file instanceof Blob) {\n                                formData.append(\n                                    options.paramName[index] || paramName,\n                                    file,\n                                    file.name\n                                );\n                            }\n                        });\n                    }\n                }\n                options.data = formData;\n            }\n            // Blob reference is not needed anymore, free memory:\n            options.blob = null;\n        },\n\n        _initIframeSettings: function (options) {\n            // Setting the dataType to iframe enables the iframe transport:\n            options.dataType = 'iframe ' + (options.dataType || '');\n            // The iframe transport accepts a serialized array as form data:\n            options.formData = this._getFormData(options);\n            // Add redirect url to form data on cross-domain uploads:\n            if (options.redirect && $('<a></a>').prop('href', options.url)\n                    .prop('host') !== location.host) {\n                options.formData.push({\n                    name: options.redirectParamName || 'redirect',\n                    value: options.redirect\n                });\n            }\n        },\n\n        _initDataSettings: function (options) {\n            if (this._isXHRUpload(options)) {\n                if (!this._chunkedUpload(options, true)) {\n                    if (!options.data) {\n                        this._initXHRData(options);\n                    }\n                    this._initProgressListener(options);\n                }\n                if (options.postMessage) {\n                    // Setting the dataType to postmessage enables the\n                    // postMessage transport:\n                    options.dataType = 'postmessage ' + (options.dataType || '');\n                }\n            } else {\n                this._initIframeSettings(options, 'iframe');\n            }\n        },\n\n        _getParamName: function (options) {\n            var fileInput = $(options.fileInput),\n                paramName = options.paramName;\n            if (!paramName) {\n                paramName = [];\n                fileInput.each(function () {\n                    var input = $(this),\n                        name = input.prop('name') || 'files[]',\n                        i = (input.prop('files') || [1]).length;\n                    while (i) {\n                        paramName.push(name);\n                        i -= 1;\n                    }\n                });\n                if (!paramName.length) {\n                    paramName = [fileInput.prop('name') || 'files[]'];\n                }\n            } else if (!$.isArray(paramName)) {\n                paramName = [paramName];\n            }\n            return paramName;\n        },\n\n        _initFormSettings: function (options) {\n            // Retrieve missing options from the input field and the\n            // associated form, if available:\n            if (!options.form || !options.form.length) {\n                options.form = $(options.fileInput.prop('form'));\n            }\n            options.paramName = this._getParamName(options);\n            if (!options.url) {\n                options.url = options.form.prop('action') || location.href;\n            }\n            // The HTTP request method must be \"POST\" or \"PUT\":\n            options.type = (options.type || options.form.prop('method') || '')\n                .toUpperCase();\n            if (options.type !== 'POST' && options.type !== 'PUT') {\n                options.type = 'POST';\n            }\n            if (!options.formAcceptCharset) {\n                options.formAcceptCharset = options.form.attr('accept-charset');\n            }\n        },\n\n        _getAJAXSettings: function (data) {\n            var options = $.extend({}, this.options, data);\n            this._initFormSettings(options);\n            this._initDataSettings(options);\n            return options;\n        },\n\n        // Maps jqXHR callbacks to the equivalent\n        // methods of the given Promise object:\n        _enhancePromise: function (promise) {\n            promise.success = promise.done;\n            promise.error = promise.fail;\n            promise.complete = promise.always;\n            return promise;\n        },\n\n        // Creates and returns a Promise object enhanced with\n        // the jqXHR methods abort, success, error and complete:\n        _getXHRPromise: function (resolveOrReject, context, args) {\n            var dfd = $.Deferred(),\n                promise = dfd.promise();\n            context = context || this.options.context || promise;\n            if (resolveOrReject === true) {\n                dfd.resolveWith(context, args);\n            } else if (resolveOrReject === false) {\n                dfd.rejectWith(context, args);\n            }\n            promise.abort = dfd.promise;\n            return this._enhancePromise(promise);\n        },\n\n        // Uploads a file in multiple, sequential requests\n        // by splitting the file up in multiple blob chunks.\n        // If the second parameter is true, only tests if the file\n        // should be uploaded in chunks, but does not invoke any\n        // upload requests:\n        _chunkedUpload: function (options, testOnly) {\n            var that = this,\n                file = options.files[0],\n                fs = file.size,\n                ub = options.uploadedBytes = options.uploadedBytes || 0,\n                mcs = options.maxChunkSize || fs,\n                // Use the Blob methods with the slice implementation\n                // according to the W3C Blob API specification:\n                slice = file.webkitSlice || file.mozSlice || file.slice,\n                upload,\n                n,\n                jqXHR,\n                pipe;\n            if (!(this._isXHRUpload(options) && slice && (ub || mcs < fs)) ||\n                    options.data) {\n                return false;\n            }\n            if (testOnly) {\n                return true;\n            }\n            if (ub >= fs) {\n                file.error = 'uploadedBytes';\n                return this._getXHRPromise(\n                    false,\n                    options.context,\n                    [null, 'error', file.error]\n                );\n            }\n            // n is the number of blobs to upload,\n            // calculated via filesize, uploaded bytes and max chunk size:\n            n = Math.ceil((fs - ub) / mcs);\n            // The chunk upload method accepting the chunk number as parameter:\n            upload = function (i) {\n                if (!i) {\n                    return that._getXHRPromise(true, options.context);\n                }\n                // Upload the blobs in sequential order:\n                return upload(i -= 1).pipe(function () {\n                    // Clone the options object for each chunk upload:\n                    var o = $.extend({}, options);\n                    o.blob = slice.call(\n                        file,\n                        ub + i * mcs,\n                        ub + (i + 1) * mcs\n                    );\n                    // Expose the chunk index:\n                    o.chunkIndex = i;\n                    // Expose the number of chunks:\n                    o.chunksNumber = n;\n                    // Store the current chunk size, as the blob itself\n                    // will be dereferenced after data processing:\n                    o.chunkSize = o.blob.size;\n                    // Process the upload data (the blob and potential form data):\n                    that._initXHRData(o);\n                    // Add progress listeners for this chunk upload:\n                    that._initProgressListener(o);\n                    jqXHR = ($.ajax(o) || that._getXHRPromise(false, o.context))\n                        .done(function () {\n                            // Create a progress event if upload is done and\n                            // no progress event has been invoked for this chunk:\n                            if (!o.loaded) {\n                                that._onProgress($.Event('progress', {\n                                    lengthComputable: true,\n                                    loaded: o.chunkSize,\n                                    total: o.chunkSize\n                                }), o);\n                            }\n                            options.uploadedBytes = o.uploadedBytes +=\n                                o.chunkSize;\n                        });\n                    return jqXHR;\n                });\n            };\n            // Return the piped Promise object, enhanced with an abort method,\n            // which is delegated to the jqXHR object of the current upload,\n            // and jqXHR callbacks mapped to the equivalent Promise methods:\n            pipe = upload(n);\n            pipe.abort = function () {\n                return jqXHR.abort();\n            };\n            return this._enhancePromise(pipe);\n        },\n\n        _beforeSend: function (e, data) {\n            if (this._active === 0) {\n                // the start callback is triggered when an upload starts\n                // and no other uploads are currently running,\n                // equivalent to the global ajaxStart event:\n                this._trigger('start');\n                // Set timer for global bitrate progress calculation:\n                this._bitrateTimer = new this._BitrateTimer();\n            }\n            this._active += 1;\n            // Initialize the global progress values:\n            this._loaded += data.uploadedBytes || 0;\n            this._total += this._getTotal(data.files);\n        },\n\n        _onDone: function (result, textStatus, jqXHR, options) {\n            if (!this._isXHRUpload(options)) {\n                // Create a progress event for each iframe load:\n                this._onProgress($.Event('progress', {\n                    lengthComputable: true,\n                    loaded: 1,\n                    total: 1\n                }), options);\n            }\n            options.result = result;\n            options.textStatus = textStatus;\n            options.jqXHR = jqXHR;\n            this._trigger('done', null, options);\n        },\n\n        _onFail: function (jqXHR, textStatus, errorThrown, options) {\n            options.jqXHR = jqXHR;\n            options.textStatus = textStatus;\n            options.errorThrown = errorThrown;\n            this._trigger('fail', null, options);\n            if (options.recalculateProgress) {\n                // Remove the failed (error or abort) file upload from\n                // the global progress calculation:\n                this._loaded -= options.loaded || options.uploadedBytes || 0;\n                this._total -= options.total || this._getTotal(options.files);\n            }\n        },\n\n        _onAlways: function (jqXHRorResult, textStatus, jqXHRorError, options) {\n            this._active -= 1;\n            options.textStatus = textStatus;\n            if (jqXHRorError && jqXHRorError.always) {\n                options.jqXHR = jqXHRorError;\n                options.result = jqXHRorResult;\n            } else {\n                options.jqXHR = jqXHRorResult;\n                options.errorThrown = jqXHRorError;\n            }\n            this._trigger('always', null, options);\n            if (this._active === 0) {\n                // The stop callback is triggered when all uploads have\n                // been completed, equivalent to the global ajaxStop event:\n                this._trigger('stop');\n                // Reset the global progress values:\n                this._loaded = this._total = 0;\n                this._bitrateTimer = null;\n            }\n        },\n\n        _onSend: function (e, data) {\n            var that = this,\n                jqXHR,\n                slot,\n                pipe,\n                options = that._getAJAXSettings(data),\n                send = function (resolve, args) {\n                    that._sending += 1;\n                    // Set timer for bitrate progress calculation:\n                    options._bitrateTimer = new that._BitrateTimer();\n                    jqXHR = jqXHR || (\n                        (resolve !== false &&\n                        that._trigger('send', e, options) !== false &&\n                        (that._chunkedUpload(options) || $.ajax(options))) ||\n                        that._getXHRPromise(false, options.context, args)\n                    ).done(function (result, textStatus, jqXHR) {\n                        that._onDone(result, textStatus, jqXHR, options);\n                    }).fail(function (jqXHR, textStatus, errorThrown) {\n                        that._onFail(jqXHR, textStatus, errorThrown, options);\n                    }).always(function (jqXHRorResult, textStatus, jqXHRorError) {\n                        that._sending -= 1;\n                        that._onAlways(\n                            jqXHRorResult,\n                            textStatus,\n                            jqXHRorError,\n                            options\n                        );\n                        if (options.limitConcurrentUploads &&\n                                options.limitConcurrentUploads > that._sending) {\n                            // Start the next queued upload,\n                            // that has not been aborted:\n                            var nextSlot = that._slots.shift(),\n                                isPending;\n                            while (nextSlot) {\n                                // jQuery 1.6 doesn't provide .state(),\n                                // while jQuery 1.8+ removed .isRejected():\n                                isPending = nextSlot.state ?\n                                        nextSlot.state() === 'pending' :\n                                        !nextSlot.isRejected();\n                                if (isPending) {\n                                    nextSlot.resolve();\n                                    break;\n                                }\n                                nextSlot = that._slots.shift();\n                            }\n                        }\n                    });\n                    return jqXHR;\n                };\n            this._beforeSend(e, options);\n            if (this.options.sequentialUploads ||\n                    (this.options.limitConcurrentUploads &&\n                    this.options.limitConcurrentUploads <= this._sending)) {\n                if (this.options.limitConcurrentUploads > 1) {\n                    slot = $.Deferred();\n                    this._slots.push(slot);\n                    pipe = slot.pipe(send);\n                } else {\n                    pipe = (this._sequence = this._sequence.pipe(send, send));\n                }\n                // Return the piped Promise object, enhanced with an abort method,\n                // which is delegated to the jqXHR object of the current upload,\n                // and jqXHR callbacks mapped to the equivalent Promise methods:\n                pipe.abort = function () {\n                    var args = [undefined, 'abort', 'abort'];\n                    if (!jqXHR) {\n                        if (slot) {\n                            slot.rejectWith(pipe, args);\n                        }\n                        return send(false, args);\n                    }\n                    return jqXHR.abort();\n                };\n                return this._enhancePromise(pipe);\n            }\n            return send();\n        },\n\n        _onAdd: function (e, data) {\n            var that = this,\n                result = true,\n                options = $.extend({}, this.options, data),\n                limit = options.limitMultiFileUploads,\n                paramName = this._getParamName(options),\n                paramNameSet,\n                paramNameSlice,\n                fileSet,\n                i;\n            if (!(options.singleFileUploads || limit) ||\n                    !this._isXHRUpload(options)) {\n                fileSet = [data.files];\n                paramNameSet = [paramName];\n            } else if (!options.singleFileUploads && limit) {\n                fileSet = [];\n                paramNameSet = [];\n                for (i = 0; i < data.files.length; i += limit) {\n                    fileSet.push(data.files.slice(i, i + limit));\n                    paramNameSlice = paramName.slice(i, i + limit);\n                    if (!paramNameSlice.length) {\n                        paramNameSlice = paramName;\n                    }\n                    paramNameSet.push(paramNameSlice);\n                }\n            } else {\n                paramNameSet = paramName;\n            }\n            data.originalFiles = data.files;\n            $.each(fileSet || data.files, function (index, element) {\n                var newData = $.extend({}, data);\n                newData.files = fileSet ? element : [element];\n                newData.paramName = paramNameSet[index];\n                newData.submit = function () {\n                    newData.jqXHR = this.jqXHR =\n                        (that._trigger('submit', e, this) !== false) &&\n                        that._onSend(e, this);\n                    return this.jqXHR;\n                };\n                return (result = that._trigger('add', e, newData));\n            });\n            return result;\n        },\n\n        _replaceFileInput: function (input) {\n            var inputClone = input.clone(true);\n            $('<form></form>').append(inputClone)[0].reset();\n            // Detaching allows to insert the fileInput on another form\n            // without loosing the file input value:\n            input.after(inputClone).detach();\n            // Avoid memory leaks with the detached file input:\n            $.cleanData(input.unbind('remove'));\n            // Replace the original file input element in the fileInput\n            // collection with the clone, which has been copied including\n            // event handlers:\n            this.options.fileInput = this.options.fileInput.map(function (i, el) {\n                if (el === input[0]) {\n                    return inputClone[0];\n                }\n                return el;\n            });\n            // If the widget has been initialized on the file input itself,\n            // override this.element with the file input clone:\n            if (input[0] === this.element[0]) {\n                this.element = inputClone;\n            }\n        },\n\n        _handleFileTreeEntry: function (entry, path) {\n            var that = this,\n                dfd = $.Deferred(),\n                errorHandler = function () {\n                    dfd.reject();\n                },\n                dirReader;\n            path = path || '';\n            if (entry.isFile) {\n                entry.file(function (file) {\n                    file.relativePath = path;\n                    dfd.resolve(file);\n                }, errorHandler);\n            } else if (entry.isDirectory) {\n                dirReader = entry.createReader();\n                dirReader.readEntries(function (entries) {\n                    that._handleFileTreeEntries(\n                        entries,\n                        path + entry.name + '/'\n                    ).done(function (files) {\n                        dfd.resolve(files);\n                    }).fail(errorHandler);\n                }, errorHandler);\n            } else {\n                errorHandler();\n            }\n            return dfd.promise();\n        },\n\n        _handleFileTreeEntries: function (entries, path) {\n            var that = this;\n            return $.when.apply(\n                $,\n                $.map(entries, function (entry) {\n                    return that._handleFileTreeEntry(entry, path);\n                })\n            ).pipe(function () {\n                return Array.prototype.concat.apply(\n                    [],\n                    arguments\n                );\n            });\n        },\n\n        _getDroppedFiles: function (dataTransfer) {\n            dataTransfer = dataTransfer || {};\n            var items = dataTransfer.items;\n            if (items && items.length && (items[0].webkitGetAsEntry ||\n                    items[0].getAsEntry)) {\n                return this._handleFileTreeEntries(\n                    $.map(items, function (item) {\n                        if (item.webkitGetAsEntry) {\n                            return item.webkitGetAsEntry();\n                        }\n                        return item.getAsEntry();\n                    })\n                );\n            }\n            return $.Deferred().resolve(\n                $.makeArray(dataTransfer.files)\n            ).promise();\n        },\n\n        _getFileInputFiles: function (fileInput) {\n            fileInput = $(fileInput);\n            var entries = fileInput.prop('webkitEntries') ||\n                    fileInput.prop('entries'),\n                files,\n                value;\n            if (entries && entries.length) {\n                return this._handleFileTreeEntries(entries);\n            }\n            files = $.makeArray(fileInput.prop('files'));\n            if (!files.length) {\n                value = fileInput.prop('value');\n                if (!value) {\n                    return $.Deferred().reject([]).promise();\n                }\n                // If the files property is not available, the browser does not\n                // support the File API and we add a pseudo File object with\n                // the input value as name with path information removed:\n                files = [{name: value.replace(/^.*\\\\/, '')}];\n            }\n            return $.Deferred().resolve(files).promise();\n        },\n\n        _onChange: function (e) {\n            var that = e.data.fileupload,\n                data = {\n                    fileInput: $(e.target),\n                    form: $(e.target.form)\n                };\n            that._getFileInputFiles(data.fileInput).always(function (files) {\n                data.files = files;\n                if (that.options.replaceFileInput) {\n                    that._replaceFileInput(data.fileInput);\n                }\n                if (that._trigger('change', e, data) !== false) {\n                    that._onAdd(e, data);\n                }\n            });\n        },\n\n        _onPaste: function (e) {\n            var that = e.data.fileupload,\n                cbd = e.originalEvent.clipboardData,\n                items = (cbd && cbd.items) || [],\n                data = {files: []};\n            $.each(items, function (index, item) {\n                var file = item.getAsFile && item.getAsFile();\n                if (file) {\n                    data.files.push(file);\n                }\n            });\n            if (that._trigger('paste', e, data) === false ||\n                    that._onAdd(e, data) === false) {\n                return false;\n            }\n        },\n\n        _onDrop: function (e) {\n            e.preventDefault();\n            var that = e.data.fileupload,\n                dataTransfer = e.dataTransfer = e.originalEvent.dataTransfer,\n                data = {};\n            that._getDroppedFiles(dataTransfer).always(function (files) {\n                data.files = files;\n                if (that._trigger('drop', e, data) !== false) {\n                    that._onAdd(e, data);\n                }\n            });\n        },\n\n        _onDragOver: function (e) {\n            var that = e.data.fileupload,\n                dataTransfer = e.dataTransfer = e.originalEvent.dataTransfer;\n            if (that._trigger('dragover', e) === false) {\n                return false;\n            }\n            if (dataTransfer) {\n                dataTransfer.dropEffect = 'copy';\n            }\n            e.preventDefault();\n        },\n\n        _initEventHandlers: function () {\n            var ns = this.options.namespace;\n            if (this._isXHRUpload(this.options)) {\n                this.options.dropZone\n                    .bind('dragover.' + ns, {fileupload: this}, this._onDragOver)\n                    .bind('drop.' + ns, {fileupload: this}, this._onDrop)\n                    .bind('paste.' + ns, {fileupload: this}, this._onPaste);\n            }\n            this.options.fileInput\n                .bind('change.' + ns, {fileupload: this}, this._onChange);\n        },\n\n        _destroyEventHandlers: function () {\n            var ns = this.options.namespace;\n            this.options.dropZone\n                .unbind('dragover.' + ns, this._onDragOver)\n                .unbind('drop.' + ns, this._onDrop)\n                .unbind('paste.' + ns, this._onPaste);\n            this.options.fileInput\n                .unbind('change.' + ns, this._onChange);\n        },\n\n        _setOption: function (key, value) {\n            var refresh = $.inArray(key, this._refreshOptionsList) !== -1;\n            if (refresh) {\n                this._destroyEventHandlers();\n            }\n            $.Widget.prototype._setOption.call(this, key, value);\n            if (refresh) {\n                this._initSpecialOptions();\n                this._initEventHandlers();\n            }\n        },\n\n        _initSpecialOptions: function () {\n            var options = this.options;\n            if (options.fileInput === undefined) {\n                options.fileInput = this.element.is('input[type=\"file\"]') ?\n                        this.element : this.element.find('input[type=\"file\"]');\n            } else if (!(options.fileInput instanceof $)) {\n                options.fileInput = $(options.fileInput);\n            }\n            if (!(options.dropZone instanceof $)) {\n                options.dropZone = $(options.dropZone);\n            }\n        },\n\n        _create: function () {\n            var options = this.options;\n            // Initialize options set via HTML5 data-attributes:\n            $.extend(options, $(this.element[0].cloneNode(false)).data());\n            options.namespace = options.namespace || this.widgetName;\n            this._initSpecialOptions();\n            this._slots = [];\n            this._sequence = this._getXHRPromise(true);\n            this._sending = this._active = this._loaded = this._total = 0;\n            this._initEventHandlers();\n        },\n\n        destroy: function () {\n            this._destroyEventHandlers();\n            $.Widget.prototype.destroy.call(this);\n        },\n\n        enable: function () {\n            var wasDisabled = false;\n            if (this.options.disabled) {\n                wasDisabled = true;\n            }\n            $.Widget.prototype.enable.call(this);\n            if (wasDisabled) {\n                this._initEventHandlers();\n            }\n        },\n\n        disable: function () {\n            if (!this.options.disabled) {\n                this._destroyEventHandlers();\n            }\n            $.Widget.prototype.disable.call(this);\n        },\n\n        // This method is exposed to the widget API and allows adding files\n        // using the fileupload API. The data parameter accepts an object which\n        // must have a files property and can contain additional options:\n        // .fileupload('add', {files: filesList});\n        add: function (data) {\n            var that = this;\n            if (!data || this.options.disabled) {\n                return;\n            }\n            if (data.fileInput && !data.files) {\n                this._getFileInputFiles(data.fileInput).always(function (files) {\n                    data.files = files;\n                    that._onAdd(null, data);\n                });\n            } else {\n                data.files = $.makeArray(data.files);\n                this._onAdd(null, data);\n            }\n        },\n\n        // This method is exposed to the widget API and allows sending files\n        // using the fileupload API. The data parameter accepts an object which\n        // must have a files or fileInput property and can contain additional options:\n        // .fileupload('send', {files: filesList});\n        // The method returns a Promise object for the file upload call.\n        send: function (data) {\n            if (data && !this.options.disabled) {\n                if (data.fileInput && !data.files) {\n                    var that = this,\n                        dfd = $.Deferred(),\n                        promise = dfd.promise(),\n                        jqXHR,\n                        aborted;\n                    promise.abort = function () {\n                        aborted = true;\n                        if (jqXHR) {\n                            return jqXHR.abort();\n                        }\n                        dfd.reject(null, 'abort', 'abort');\n                        return promise;\n                    };\n                    this._getFileInputFiles(data.fileInput).always(\n                        function (files) {\n                            if (aborted) {\n                                return;\n                            }\n                            data.files = files;\n                            jqXHR = that._onSend(null, data).then(\n                                function (result, textStatus, jqXHR) {\n                                    dfd.resolve(result, textStatus, jqXHR);\n                                },\n                                function (jqXHR, textStatus, errorThrown) {\n                                    dfd.reject(jqXHR, textStatus, errorThrown);\n                                }\n                            );\n                        }\n                    );\n                    return this._enhancePromise(promise);\n                }\n                data.files = $.makeArray(data.files);\n                if (data.files.length) {\n                    return this._onSend(null, data);\n                }\n            }\n            return this._getXHRPromise(false, data && data.context);\n        }\n\n    });\n\n}));\n","jquery/fileUploader/jquery.iframe-transport.js":"/*\n * jQuery Iframe Transport Plugin 1.5\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint unparam: true, nomen: true */\n/*global define, window, document */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define(['jquery'], factory);\n    } else {\n        // Browser globals:\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    // Helper variable to create unique names for the transport iframes:\n    var counter = 0;\n\n    // The iframe transport accepts three additional options:\n    // options.fileInput: a jQuery collection of file input fields\n    // options.paramName: the parameter name for the file form data,\n    //  overrides the name property of the file input field(s),\n    //  can be a string or an array of strings.\n    // options.formData: an array of objects with name and value properties,\n    //  equivalent to the return data of .serializeArray(), e.g.:\n    //  [{name: 'a', value: 1}, {name: 'b', value: 2}]\n    $.ajaxTransport('iframe', function (options) {\n        if (options.async && (options.type === 'POST' || options.type === 'GET')) {\n            var form,\n                iframe;\n            return {\n                send: function (_, completeCallback) {\n                    form = $('<form style=\"display:none;\"></form>');\n                    form.attr('accept-charset', options.formAcceptCharset);\n                    // javascript:false as initial iframe src\n                    // prevents warning popups on HTTPS in IE6.\n                    // IE versions below IE8 cannot set the name property of\n                    // elements that have already been added to the DOM,\n                    // so we set the name along with the iframe HTML markup:\n                    iframe = $(\n                        '<iframe src=\"javascript:false;\" name=\"iframe-transport-' +\n                            (counter += 1) + '\"></iframe>'\n                    ).bind('load', function () {\n                        var fileInputClones,\n                            paramNames = $.isArray(options.paramName) ?\n                                    options.paramName : [options.paramName];\n                        iframe\n                            .unbind('load')\n                            .bind('load', function () {\n                                var response;\n                                // Wrap in a try/catch block to catch exceptions thrown\n                                // when trying to access cross-domain iframe contents:\n                                try {\n                                    response = iframe.contents();\n                                    // Google Chrome and Firefox do not throw an\n                                    // exception when calling iframe.contents() on\n                                    // cross-domain requests, so we unify the response:\n                                    if (!response.length || !response[0].firstChild) {\n                                        throw new Error();\n                                    }\n                                } catch (e) {\n                                    response = undefined;\n                                }\n                                // The complete callback returns the\n                                // iframe content document as response object:\n                                completeCallback(\n                                    200,\n                                    'success',\n                                    {'iframe': response}\n                                );\n                                // Fix for IE endless progress bar activity bug\n                                // (happens on form submits to iframe targets):\n                                $('<iframe src=\"javascript:false;\"></iframe>')\n                                    .appendTo(form);\n                                form.remove();\n                            });\n                        form\n                            .prop('target', iframe.prop('name'))\n                            .prop('action', options.url)\n                            .prop('method', options.type);\n                        if (options.formData) {\n                            $.each(options.formData, function (index, field) {\n                                $('<input type=\"hidden\"/>')\n                                    .prop('name', field.name)\n                                    .val(field.value)\n                                    .appendTo(form);\n                            });\n                        }\n                        if (options.fileInput && options.fileInput.length &&\n                                options.type === 'POST') {\n                            fileInputClones = options.fileInput.clone();\n                            // Insert a clone for each file input field:\n                            options.fileInput.after(function (index) {\n                                return fileInputClones[index];\n                            });\n                            if (options.paramName) {\n                                options.fileInput.each(function (index) {\n                                    $(this).prop(\n                                        'name',\n                                        paramNames[index] || options.paramName\n                                    );\n                                });\n                            }\n                            // Appending the file input fields to the hidden form\n                            // removes them from their original location:\n                            form\n                                .append(options.fileInput)\n                                .prop('enctype', 'multipart/form-data')\n                                // enctype must be set as encoding for IE:\n                                .prop('encoding', 'multipart/form-data');\n                        }\n                        form.submit();\n                        // Insert the file input fields at their original location\n                        // by replacing the clones with the originals:\n                        if (fileInputClones && fileInputClones.length) {\n                            options.fileInput.each(function (index, input) {\n                                var clone = $(fileInputClones[index]);\n                                $(input).prop('name', clone.prop('name'));\n                                clone.replaceWith(input);\n                            });\n                        }\n                    });\n                    form.append(iframe).appendTo(document.body);\n                },\n                abort: function () {\n                    if (iframe) {\n                        // javascript:false as iframe src aborts the request\n                        // and prevents warning popups on HTTPS in IE6.\n                        // concat is used to avoid the \"Script URL\" JSLint error:\n                        iframe\n                            .unbind('load')\n                            .prop('src', 'javascript'.concat(':false;'));\n                    }\n                    if (form) {\n                        form.remove();\n                    }\n                }\n            };\n        }\n    });\n\n    // The iframe transport returns the iframe content document as response.\n    // The following adds converters from iframe to text, json, html, and script:\n    $.ajaxSetup({\n        converters: {\n            'iframe text': function (iframe) {\n                return $(iframe[0].body).text();\n            },\n            'iframe json': function (iframe) {\n                return $.parseJSON($(iframe[0].body).text());\n            },\n            'iframe html': function (iframe) {\n                return $(iframe[0].body).html();\n            },\n            'iframe script': function (iframe) {\n                return $.globalEval($(iframe[0].body).text());\n            }\n        }\n    });\n\n}));\n","jquery/fileUploader/cors/jquery.postmessage-transport.js":"/*\n * jQuery postMessage Transport Plugin 1.1\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint unparam: true, nomen: true */\n/*global define, window, document */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define(['jquery'], factory);\n    } else {\n        // Browser globals:\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    var counter = 0,\n        names = [\n            'accepts',\n            'cache',\n            'contents',\n            'contentType',\n            'crossDomain',\n            'data',\n            'dataType',\n            'headers',\n            'ifModified',\n            'mimeType',\n            'password',\n            'processData',\n            'timeout',\n            'traditional',\n            'type',\n            'url',\n            'username'\n        ],\n        convert = function (p) {\n            return p;\n        };\n\n    $.ajaxSetup({\n        converters: {\n            'postmessage text': convert,\n            'postmessage json': convert,\n            'postmessage html': convert\n        }\n    });\n\n    $.ajaxTransport('postmessage', function (options) {\n        if (options.postMessage && window.postMessage) {\n            var iframe,\n                loc = $('<a>').prop('href', options.postMessage)[0],\n                target = loc.protocol + '//' + loc.host,\n                xhrUpload = options.xhr().upload;\n            return {\n                send: function (_, completeCallback) {\n                    var message = {\n                            id: 'postmessage-transport-' + (counter += 1)\n                        },\n                        eventName = 'message.' + message.id;\n                    iframe = $(\n                        '<iframe style=\"display:none;\" src=\"' +\n                            options.postMessage + '\" name=\"' +\n                            message.id + '\"></iframe>'\n                    ).bind('load', function () {\n                        $.each(names, function (i, name) {\n                            message[name] = options[name];\n                        });\n                        message.dataType = message.dataType.replace('postmessage ', '');\n                        $(window).bind(eventName, function (e) {\n                            e = e.originalEvent;\n                            var data = e.data,\n                                ev;\n                            if (e.origin === target && data.id === message.id) {\n                                if (data.type === 'progress') {\n                                    ev = document.createEvent('Event');\n                                    ev.initEvent(data.type, false, true);\n                                    $.extend(ev, data);\n                                    xhrUpload.dispatchEvent(ev);\n                                } else {\n                                    completeCallback(\n                                        data.status,\n                                        data.statusText,\n                                        {postmessage: data.result},\n                                        data.headers\n                                    );\n                                    iframe.remove();\n                                    $(window).unbind(eventName);\n                                }\n                            }\n                        });\n                        iframe[0].contentWindow.postMessage(\n                            message,\n                            target\n                        );\n                    }).appendTo(document.body);\n                },\n                abort: function () {\n                    if (iframe) {\n                        iframe.remove();\n                    }\n                }\n            };\n        }\n    });\n\n}));\n","jquery/fileUploader/cors/jquery.xdr-transport.js":"/*\n * jQuery XDomainRequest Transport Plugin 1.1.2\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n *\n * Based on Julian Aubourg's ajaxHooks xdr.js:\n * https://github.com/jaubourg/ajaxHooks/\n */\n\n/*jslint unparam: true */\n/*global define, window, XDomainRequest */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define(['jquery'], factory);\n    } else {\n        // Browser globals:\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n    if (window.XDomainRequest && !$.support.cors) {\n        $.ajaxTransport(function (s) {\n            if (s.crossDomain && s.async) {\n                if (s.timeout) {\n                    s.xdrTimeout = s.timeout;\n                    delete s.timeout;\n                }\n                var xdr;\n                return {\n                    send: function (headers, completeCallback) {\n                        function callback(status, statusText, responses, responseHeaders) {\n                            xdr.onload = xdr.onerror = xdr.ontimeout = $.noop;\n                            xdr = null;\n                            completeCallback(status, statusText, responses, responseHeaders);\n                        }\n                        xdr = new XDomainRequest();\n                        // XDomainRequest only supports GET and POST:\n                        if (s.type === 'DELETE') {\n                            s.url = s.url + (/\\?/.test(s.url) ? '&' : '?') +\n                                '_method=DELETE';\n                            s.type = 'POST';\n                        } else if (s.type === 'PUT') {\n                            s.url = s.url + (/\\?/.test(s.url) ? '&' : '?') +\n                                '_method=PUT';\n                            s.type = 'POST';\n                        }\n                        xdr.open(s.type, s.url);\n                        xdr.onload = function () {\n                            callback(\n                                200,\n                                'OK',\n                                {text: xdr.responseText},\n                                'Content-Type: ' + xdr.contentType\n                            );\n                        };\n                        xdr.onerror = function () {\n                            callback(404, 'Not Found');\n                        };\n                        if (s.xdrTimeout) {\n                            xdr.ontimeout = function () {\n                                callback(0, 'timeout');\n                            };\n                            xdr.timeout = s.xdrTimeout;\n                        }\n                        xdr.send((s.hasContent && s.data) || null);\n                    },\n                    abort: function () {\n                        if (xdr) {\n                            xdr.onerror = $.noop();\n                            xdr.abort();\n                        }\n                    }\n                };\n            }\n        });\n    }\n}));\n","jquery/fileUploader/vendor/jquery.ui.widget.js":"/*\n * jQuery UI Widget 1.8.23+amd\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2012, AUTHORS.txt (http://jqueryui.com/about)\n * Dual licensed under the MIT or GPL Version 2 licenses.\n * http://jquery.org/license\n *\n * http://docs.jquery.com/UI/Widget\n */\n\n(function (factory) {\n    if (typeof define === \"function\" && define.amd) {\n        // Register as an anonymous AMD module:\n        define([\"jquery\"], factory);\n    } else {\n        // Browser globals:\n        factory(jQuery);\n    }\n}(function( $, undefined ) {\n\n// jQuery 1.4+\nif ( $.cleanData ) {\n\tvar _cleanData = $.cleanData;\n\t$.cleanData = function( elems ) {\n\t\tfor ( var i = 0, elem; (elem = elems[i]) != null; i++ ) {\n\t\t\ttry {\n\t\t\t\t$( elem ).triggerHandler( \"remove\" );\n\t\t\t// http://bugs.jquery.com/ticket/8235\n\t\t\t} catch( e ) {}\n\t\t}\n\t\t_cleanData( elems );\n\t};\n} else {\n\tvar _remove = $.fn.remove;\n\t$.fn.remove = function( selector, keepData ) {\n\t\treturn this.each(function() {\n\t\t\tif ( !keepData ) {\n\t\t\t\tif ( !selector || $.filter( selector, [ this ] ).length ) {\n\t\t\t\t\t$( \"*\", this ).add( [ this ] ).each(function() {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t$( this ).triggerHandler( \"remove\" );\n\t\t\t\t\t\t// http://bugs.jquery.com/ticket/8235\n\t\t\t\t\t\t} catch( e ) {}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn _remove.call( $(this), selector, keepData );\n\t\t});\n\t};\n}\n\n$.widget = function( name, base, prototype ) {\n\tvar namespace = name.split( \".\" )[ 0 ],\n\t\tfullName;\n\tname = name.split( \".\" )[ 1 ];\n\tfullName = namespace + \"-\" + name;\n\n\tif ( !prototype ) {\n\t\tprototype = base;\n\t\tbase = $.Widget;\n\t}\n\n\t// create selector for plugin\n\t$.expr[ \":\" ][ fullName ] = function( elem ) {\n\t\treturn !!$.data( elem, name );\n\t};\n\n\t$[ namespace ] = $[ namespace ] || {};\n\t$[ namespace ][ name ] = function( options, element ) {\n\t\t// allow instantiation without initializing for simple inheritance\n\t\tif ( arguments.length ) {\n\t\t\tthis._createWidget( options, element );\n\t\t}\n\t};\n\n\tvar basePrototype = new base();\n\t// we need to make the options hash a property directly on the new instance\n\t// otherwise we'll modify the options hash on the prototype that we're\n\t// inheriting from\n//\t$.each( basePrototype, function( key, val ) {\n//\t\tif ( $.isPlainObject(val) ) {\n//\t\t\tbasePrototype[ key ] = $.extend( {}, val );\n//\t\t}\n//\t});\n\tbasePrototype.options = $.extend( true, {}, basePrototype.options );\n\t$[ namespace ][ name ].prototype = $.extend( true, basePrototype, {\n\t\tnamespace: namespace,\n\t\twidgetName: name,\n\t\twidgetEventPrefix: $[ namespace ][ name ].prototype.widgetEventPrefix || name,\n\t\twidgetBaseClass: fullName\n\t}, prototype );\n\n\t$.widget.bridge( name, $[ namespace ][ name ] );\n};\n\n$.widget.bridge = function( name, object ) {\n\t$.fn[ name ] = function( options ) {\n\t\tvar isMethodCall = typeof options === \"string\",\n\t\t\targs = Array.prototype.slice.call( arguments, 1 ),\n\t\t\treturnValue = this;\n\n\t\t// allow multiple hashes to be passed on init\n\t\toptions = !isMethodCall && args.length ?\n\t\t\t$.extend.apply( null, [ true, options ].concat(args) ) :\n\t\t\toptions;\n\n\t\t// prevent calls to internal methods\n\t\tif ( isMethodCall && options.charAt( 0 ) === \"_\" ) {\n\t\t\treturn returnValue;\n\t\t}\n\n\t\tif ( isMethodCall ) {\n\t\t\tthis.each(function() {\n\t\t\t\tvar instance = $.data( this, name ),\n\t\t\t\t\tmethodValue = instance && $.isFunction( instance[options] ) ?\n\t\t\t\t\t\tinstance[ options ].apply( instance, args ) :\n\t\t\t\t\t\tinstance;\n\t\t\t\t// TODO: add this back in 1.9 and use $.error() (see #5972)\n//\t\t\t\tif ( !instance ) {\n//\t\t\t\t\tthrow \"cannot call methods on \" + name + \" prior to initialization; \" +\n//\t\t\t\t\t\t\"attempted to call method '\" + options + \"'\";\n//\t\t\t\t}\n//\t\t\t\tif ( !$.isFunction( instance[options] ) ) {\n//\t\t\t\t\tthrow \"no such method '\" + options + \"' for \" + name + \" widget instance\";\n//\t\t\t\t}\n//\t\t\t\tvar methodValue = instance[ options ].apply( instance, args );\n\t\t\t\tif ( methodValue !== instance && methodValue !== undefined ) {\n\t\t\t\t\treturnValue = methodValue;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\t\t} else {\n\t\t\tthis.each(function() {\n\t\t\t\tvar instance = $.data( this, name );\n\t\t\t\tif ( instance ) {\n\t\t\t\t\tinstance.option( options || {} )._init();\n\t\t\t\t} else {\n\t\t\t\t\t$.data( this, name, new object( options, this ) );\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\treturn returnValue;\n\t};\n};\n\n$.Widget = function( options, element ) {\n\t// allow instantiation without initializing for simple inheritance\n\tif ( arguments.length ) {\n\t\tthis._createWidget( options, element );\n\t}\n};\n\n$.Widget.prototype = {\n\twidgetName: \"widget\",\n\twidgetEventPrefix: \"\",\n\toptions: {\n\t\tdisabled: false\n\t},\n\t_createWidget: function( options, element ) {\n\t\t// $.widget.bridge stores the plugin instance, but we do it anyway\n\t\t// so that it's stored even before the _create function runs\n\t\t$.data( element, this.widgetName, this );\n\t\tthis.element = $( element );\n\t\tthis.options = $.extend( true, {},\n\t\t\tthis.options,\n\t\t\tthis._getCreateOptions(),\n\t\t\toptions );\n\n\t\tvar self = this;\n\t\tthis.element.bind( \"remove.\" + this.widgetName, function() {\n\t\t\tself.destroy();\n\t\t});\n\n\t\tthis._create();\n\t\tthis._trigger( \"create\" );\n\t\tthis._init();\n\t},\n\t_getCreateOptions: function() {\n\t\treturn $.metadata && $.metadata.get( this.element[0] )[ this.widgetName ];\n\t},\n\t_create: function() {},\n\t_init: function() {},\n\n\tdestroy: function() {\n\t\tthis.element\n\t\t\t.unbind( \".\" + this.widgetName )\n\t\t\t.removeData( this.widgetName );\n\t\tthis.widget()\n\t\t\t.unbind( \".\" + this.widgetName )\n\t\t\t.removeAttr( \"aria-disabled\" )\n\t\t\t.removeClass(\n\t\t\t\tthis.widgetBaseClass + \"-disabled \" +\n\t\t\t\t\"ui-state-disabled\" );\n\t},\n\n\twidget: function() {\n\t\treturn this.element;\n\t},\n\n\toption: function( key, value ) {\n\t\tvar options = key;\n\n\t\tif ( arguments.length === 0 ) {\n\t\t\t// don't return a reference to the internal hash\n\t\t\treturn $.extend( {}, this.options );\n\t\t}\n\n\t\tif  (typeof key === \"string\" ) {\n\t\t\tif ( value === undefined ) {\n\t\t\t\treturn this.options[ key ];\n\t\t\t}\n\t\t\toptions = {};\n\t\t\toptions[ key ] = value;\n\t\t}\n\n\t\tthis._setOptions( options );\n\n\t\treturn this;\n\t},\n\t_setOptions: function( options ) {\n\t\tvar self = this;\n\t\t$.each( options, function( key, value ) {\n\t\t\tself._setOption( key, value );\n\t\t});\n\n\t\treturn this;\n\t},\n\t_setOption: function( key, value ) {\n\t\tthis.options[ key ] = value;\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis.widget()\n\t\t\t\t[ value ? \"addClass\" : \"removeClass\"](\n\t\t\t\t\tthis.widgetBaseClass + \"-disabled\" + \" \" +\n\t\t\t\t\t\"ui-state-disabled\" )\n\t\t\t\t.attr( \"aria-disabled\", value );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tenable: function() {\n\t\treturn this._setOption( \"disabled\", false );\n\t},\n\tdisable: function() {\n\t\treturn this._setOption( \"disabled\", true );\n\t},\n\n\t_trigger: function( type, event, data ) {\n\t\tvar prop, orig,\n\t\t\tcallback = this.options[ type ];\n\n\t\tdata = data || {};\n\t\tevent = $.Event( event );\n\t\tevent.type = ( type === this.widgetEventPrefix ?\n\t\t\ttype :\n\t\t\tthis.widgetEventPrefix + type ).toLowerCase();\n\t\t// the original event may come from any element\n\t\t// so we need to reset the target on the new event\n\t\tevent.target = this.element[ 0 ];\n\n\t\t// copy original event properties over to the new event\n\t\torig = event.originalEvent;\n\t\tif ( orig ) {\n\t\t\tfor ( prop in orig ) {\n\t\t\t\tif ( !( prop in event ) ) {\n\t\t\t\t\tevent[ prop ] = orig[ prop ];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tthis.element.trigger( event, data );\n\n\t\treturn !( $.isFunction(callback) &&\n\t\t\tcallback.call( this.element[0], event, data ) === false ||\n\t\t\tevent.isDefaultPrevented() );\n\t}\n};\n\n}));\n","jquery/jstree/jquery.hotkeys.js":"/*\n * jQuery Hotkeys Plugin\n * Copyright 2010, John Resig\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Based upon the plugin by Tzury Bar Yochay:\n * http://github.com/tzuryby/hotkeys\n *\n * Original idea by:\n * Binny V A, http://www.openjs.com/scripts/events/keyboard_shortcuts/\n*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\"jquery\"], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function (jQuery) {\n\n\tjQuery.hotkeys = {\n\t\tversion: \"0.8\",\n\n\t\tspecialKeys: {\n\t\t\t8: \"backspace\", 9: \"tab\", 13: \"return\", 16: \"shift\", 17: \"ctrl\", 18: \"alt\", 19: \"pause\",\n\t\t\t20: \"capslock\", 27: \"esc\", 32: \"space\", 33: \"pageup\", 34: \"pagedown\", 35: \"end\", 36: \"home\",\n\t\t\t37: \"left\", 38: \"up\", 39: \"right\", 40: \"down\", 45: \"insert\", 46: \"del\", \n\t\t\t96: \"0\", 97: \"1\", 98: \"2\", 99: \"3\", 100: \"4\", 101: \"5\", 102: \"6\", 103: \"7\",\n\t\t\t104: \"8\", 105: \"9\", 106: \"*\", 107: \"+\", 109: \"-\", 110: \".\", 111 : \"/\", \n\t\t\t112: \"f1\", 113: \"f2\", 114: \"f3\", 115: \"f4\", 116: \"f5\", 117: \"f6\", 118: \"f7\", 119: \"f8\", \n\t\t\t120: \"f9\", 121: \"f10\", 122: \"f11\", 123: \"f12\", 144: \"numlock\", 145: \"scroll\", 191: \"/\", 224: \"meta\"\n\t\t},\n\t\n\t\tshiftNums: {\n\t\t\t\"`\": \"~\", \"1\": \"!\", \"2\": \"@\", \"3\": \"#\", \"4\": \"$\", \"5\": \"%\", \"6\": \"^\", \"7\": \"&\", \n\t\t\t\"8\": \"*\", \"9\": \"(\", \"0\": \")\", \"-\": \"_\", \"=\": \"+\", \";\": \": \", \"'\": \"\\\"\", \",\": \"<\", \n\t\t\t\".\": \">\",  \"/\": \"?\",  \"\\\\\": \"|\"\n\t\t}\n\t};\n\n\tfunction keyHandler( handleObj ) {\n\t\t// Only care when a possible input has been specified\n\t\tif ( typeof handleObj.data !== \"string\" ) {\n\t\t\treturn;\n\t\t}\n\t\t\n\t\tvar origHandler = handleObj.handler,\n\t\t\tkeys = handleObj.data.toLowerCase().split(\" \");\n\t\n\t\thandleObj.handler = function( event ) {\n\t\t\t// Don't fire in text-accepting inputs that we didn't directly bind to\n\t\t\tif ( this !== event.target && (/textarea|select/i.test( event.target.nodeName ) ||\n\t\t\t\t event.target.type === \"text\") ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t\n\t\t\t// Keypress represents characters, not special keys\n\t\t\tvar special = event.type !== \"keypress\" && jQuery.hotkeys.specialKeys[ event.which ],\n\t\t\t\tcharacter = String.fromCharCode( event.which ).toLowerCase(),\n\t\t\t\tkey, modif = \"\", possible = {};\n\n\t\t\t// check combinations (alt|ctrl|shift+anything)\n\t\t\tif ( event.altKey && special !== \"alt\" ) {\n\t\t\t\tmodif += \"alt+\";\n\t\t\t}\n\n\t\t\tif ( event.ctrlKey && special !== \"ctrl\" ) {\n\t\t\t\tmodif += \"ctrl+\";\n\t\t\t}\n\t\t\t\n\t\t\t// TODO: Need to make sure this works consistently across platforms\n\t\t\tif ( event.metaKey && !event.ctrlKey && special !== \"meta\" ) {\n\t\t\t\tmodif += \"meta+\";\n\t\t\t}\n\n\t\t\tif ( event.shiftKey && special !== \"shift\" ) {\n\t\t\t\tmodif += \"shift+\";\n\t\t\t}\n\n\t\t\tif ( special ) {\n\t\t\t\tpossible[ modif + special ] = true;\n\n\t\t\t} else {\n\t\t\t\tpossible[ modif + character ] = true;\n\t\t\t\tpossible[ modif + jQuery.hotkeys.shiftNums[ character ] ] = true;\n\n\t\t\t\t// \"$\" can be triggered as \"Shift+4\" or \"Shift+$\" or just \"$\"\n\t\t\t\tif ( modif === \"shift+\" ) {\n\t\t\t\t\tpossible[ jQuery.hotkeys.shiftNums[ character ] ] = true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfor ( var i = 0, l = keys.length; i < l; i++ ) {\n\t\t\t\tif ( possible[ keys[i] ] ) {\n\t\t\t\t\treturn origHandler.apply( this, arguments );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.each([ \"keydown\", \"keyup\", \"keypress\" ], function() {\n\t\tjQuery.event.special[ this ] = { add: keyHandler };\n\t});\n\n}));","jquery/jstree/jquery.jstree.js":"/*\n * jsTree 1.0-rc3\n * http://jstree.com/\n *\n * Copyright (c) 2010 Ivan Bozhanov (vakata.com)\n *\n * Licensed same as jquery - under the terms of either the MIT License or the GPL Version 2 License\n *   http://www.opensource.org/licenses/mit-license.php\n *   http://www.gnu.org/licenses/gpl.html\n *\n * $Date: 2011-02-09 01:17:14 +0200 (\u00d1\u0081\u00d1\u0080, 09 \u00d1\u0084\u00d0\u00b5\u00d0\u00b2\u00d1\u0080 2011) $\n * $Revision: 236 $\n */\n\n/*jslint browser: true, onevar: true, undef: true, bitwise: true, strict: true */\n/*global window : false, clearInterval: false, clearTimeout: false, document: false, setInterval: false, setTimeout: false, jQuery: false, navigator: false, XSLTProcessor: false, DOMParser: false, XMLSerializer: false*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/jquery.cookie\",\n            \"jquery/jstree/jquery.hotkeys\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\"use strict\";\n\n// top wrapper to prevent multiple inclusion (is this OK?)\n(function () { if(jQuery && jQuery.jstree) { return; }\n\tvar is_ie6 = false, is_ie7 = false, is_ff2 = false;\n\n/*\n * jsTree core\n */\n(function ($) {\n\t// Common functions not related to jsTree\n\t// decided to move them to a `vakata` \"namespace\"\n\t$.vakata = {};\n\t// CSS related functions\n\t$.vakata.css = {\n\t\tget_css : function(rule_name, delete_flag, sheet) {\n\t\t\trule_name = rule_name.toLowerCase();\n\t\t\tvar css_rules = sheet.cssRules || sheet.rules,\n\t\t\t\tj = 0;\n\t\t\tdo {\n\t\t\t\tif(css_rules.length && j > css_rules.length + 5) { return false; }\n\t\t\t\tif(css_rules[j].selectorText && css_rules[j].selectorText.toLowerCase() == rule_name) {\n\t\t\t\t\tif(delete_flag === true) {\n\t\t\t\t\t\tif(sheet.removeRule) { sheet.removeRule(j); }\n\t\t\t\t\t\tif(sheet.deleteRule) { sheet.deleteRule(j); }\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t\telse { return css_rules[j]; }\n\t\t\t\t}\n\t\t\t}\n\t\t\twhile (css_rules[++j]);\n\t\t\treturn false;\n\t\t},\n\t\tadd_css : function(rule_name, sheet) {\n\t\t\tif($.jstree.css.get_css(rule_name, false, sheet)) { return false; }\n\t\t\tif(sheet.insertRule) { sheet.insertRule(rule_name + ' { }', 0); } else { sheet.addRule(rule_name, null, 0); }\n\t\t\treturn $.vakata.css.get_css(rule_name);\n\t\t},\n\t\tremove_css : function(rule_name, sheet) {\n\t\t\treturn $.vakata.css.get_css(rule_name, true, sheet);\n\t\t},\n\t\tadd_sheet : function(opts) {\n\t\t\tvar tmp = false, is_new = true;\n\t\t\tif(opts.str) {\n\t\t\t\tif(opts.title) { tmp = $(\"style[id='\" + opts.title + \"-stylesheet']\")[0]; }\n\t\t\t\tif(tmp) { is_new = false; }\n\t\t\t\telse {\n\t\t\t\t\ttmp = document.createElement(\"style\");\n\t\t\t\t\ttmp.setAttribute('type',\"text/css\");\n\t\t\t\t\tif(opts.title) { tmp.setAttribute(\"id\", opts.title + \"-stylesheet\"); }\n\t\t\t\t}\n\t\t\t\tif(tmp.styleSheet) {\n\t\t\t\t\tif(is_new) {\n\t\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t\t\ttmp.styleSheet.cssText = opts.str;\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\ttmp.styleSheet.cssText = tmp.styleSheet.cssText + \" \" + opts.str;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\ttmp.appendChild(document.createTextNode(opts.str));\n\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t}\n\t\t\t\treturn tmp.sheet || tmp.styleSheet;\n\t\t\t}\n\t\t\tif(opts.url) {\n\t\t\t\tif(document.createStyleSheet) {\n\t\t\t\t\ttry { tmp = document.createStyleSheet(opts.url); } catch (e) { }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\ttmp\t\t\t= document.createElement('link');\n\t\t\t\t\ttmp.rel\t\t= 'stylesheet';\n\t\t\t\t\ttmp.type\t= 'text/css';\n\t\t\t\t\ttmp.media\t= \"all\";\n\t\t\t\t\ttmp.href\t= opts.url;\n\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t\treturn tmp.styleSheet;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n\t// private variables\n\tvar instances = [],\t\t\t// instance array (used by $.jstree.reference/create/focused)\n\t\tfocused_instance = -1,\t// the index in the instance array of the currently focused instance\n\t\tplugins = {},\t\t\t// list of included plugins\n\t\tprepared_move = {};\t\t// for the move_node function\n\n\t// jQuery plugin wrapper (thanks to jquery UI widget function)\n\t$.fn.jstree = function (settings) {\n\t\tvar isMethodCall = (typeof settings == 'string'), // is this a method call like $().jstree(\"open_node\")\n\t\t\targs = Array.prototype.slice.call(arguments, 1),\n\t\t\treturnValue = this;\n\n\t\t// if a method call execute the method on all selected instances\n\t\tif(isMethodCall) {\n\t\t\tif(settings.substring(0, 1) == '_') { return returnValue; }\n\t\t\tthis.each(function() {\n\t\t\t\tvar instance = instances[$.data(this, \"jstree_instance_id\")],\n\t\t\t\t\tmethodValue = (instance && $.isFunction(instance[settings])) ? instance[settings].apply(instance, args) : instance;\n\t\t\t\t\tif(typeof methodValue !== \"undefined\" && (settings.indexOf(\"is_\") === 0 || (methodValue !== true && methodValue !== false))) { returnValue = methodValue; return false; }\n\t\t\t});\n\t\t}\n\t\telse {\n\t\t\tthis.each(function() {\n\t\t\t\t// extend settings and allow for multiple hashes and $.data\n\t\t\t\tvar instance_id = $.data(this, \"jstree_instance_id\"),\n\t\t\t\t\ta = [],\n\t\t\t\t\tb = settings ? $.extend({}, true, settings) : {},\n\t\t\t\t\tc = $(this),\n\t\t\t\t\ts = false,\n\t\t\t\t\tt = [];\n\t\t\t\ta = a.concat(args);\n\t\t\t\tif(c.data(\"jstree\")) { a.push(c.data(\"jstree\")); }\n\t\t\t\tb = a.length ? $.extend.apply(null, [true, b].concat(a)) : b;\n\n\t\t\t\t// if an instance already exists, destroy it first\n\t\t\t\tif(typeof instance_id !== \"undefined\" && instances[instance_id]) { instances[instance_id].destroy(); }\n\t\t\t\t// push a new empty object to the instances array\n\t\t\t\tinstance_id = parseInt(instances.push({}),10) - 1;\n\t\t\t\t// store the jstree instance id to the container element\n\t\t\t\t$.data(this, \"jstree_instance_id\", instance_id);\n\t\t\t\t// clean up all plugins\n\t\t\t\tb.plugins = $.isArray(b.plugins) ? b.plugins : $.jstree.defaults.plugins.slice();\n\t\t\t\tb.plugins.unshift(\"core\");\n\t\t\t\t// only unique plugins\n\t\t\t\tb.plugins = b.plugins.sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\");\n\n\t\t\t\t// extend defaults with passed data\n\t\t\t\ts = $.extend(true, {}, $.jstree.defaults, b);\n\t\t\t\ts.plugins = b.plugins;\n\t\t\t\t$.each(plugins, function (i, val) {\n\t\t\t\t\tif($.inArray(i, s.plugins) === -1) { s[i] = null; delete s[i]; }\n\t\t\t\t\telse { t.push(i); }\n\t\t\t\t});\n\t\t\t\ts.plugins = t;\n\n\t\t\t\t// push the new object to the instances array (at the same time set the default classes to the container) and init\n\t\t\t\tinstances[instance_id] = new $.jstree._instance(instance_id, $(this).addClass(\"jstree jstree-\" + instance_id), s);\n\t\t\t\t// init all activated plugins for this instance\n\t\t\t\t$.each(instances[instance_id]._get_settings().plugins, function (i, val) { instances[instance_id].data[val] = {}; });\n\t\t\t\t$.each(instances[instance_id]._get_settings().plugins, function (i, val) { if(plugins[val]) { plugins[val].__init.apply(instances[instance_id]); } });\n\t\t\t\t// initialize the instance\n\t\t\t\tsetTimeout(function() { if(instances[instance_id]) { instances[instance_id].init(); } }, 0);\n\t\t\t});\n\t\t}\n\t\t// return the jquery selection (or if it was a method call that returned a value - the returned value)\n\t\treturn returnValue;\n\t};\n\t// object to store exposed functions and objects\n\t$.jstree = {\n\t\tdefaults : {\n\t\t\tplugins : []\n\t\t},\n\t\t_focused : function () { return instances[focused_instance] || null; },\n\t\t_reference : function (needle) {\n\t\t\t// get by instance id\n\t\t\tif(instances[needle]) { return instances[needle]; }\n\t\t\t// get by DOM (if still no luck - return null\n\t\t\tvar o = $(needle);\n\t\t\tif(!o.length && typeof needle === \"string\") { o = $(\"#\" + needle); }\n\t\t\tif(!o.length) { return null; }\n\t\t\treturn instances[o.closest(\".jstree\").data(\"jstree_instance_id\")] || null;\n\t\t},\n\t\t_instance : function (index, container, settings) {\n\t\t\t// for plugins to store data in\n\t\t\tthis.data = { core : {} };\n\t\t\tthis.get_settings\t= function () { return $.extend(true, {}, settings); };\n\t\t\tthis._get_settings\t= function () { return settings; };\n\t\t\tthis.get_index\t\t= function () { return index; };\n\t\t\tthis.get_container\t= function () { return container; };\n\t\t\tthis.get_container_ul = function () { return container.children(\"ul:eq(0)\"); };\n\t\t\tthis._set_settings\t= function (s) {\n\t\t\t\tsettings = $.extend(true, {}, settings, s);\n\t\t\t};\n\t\t},\n\t\t_fn : { },\n\t\tplugin : function (pname, pdata) {\n\t\t\tpdata = $.extend({}, {\n\t\t\t\t__init\t\t: $.noop,\n\t\t\t\t__destroy\t: $.noop,\n\t\t\t\t_fn\t\t\t: {},\n\t\t\t\tdefaults\t: false\n\t\t\t}, pdata);\n\t\t\tplugins[pname] = pdata;\n\n\t\t\t$.jstree.defaults[pname] = pdata.defaults;\n\t\t\t$.each(pdata._fn, function (i, val) {\n\t\t\t\tval.plugin\t\t= pname;\n\t\t\t\tval.old\t\t\t= $.jstree._fn[i];\n\t\t\t\t$.jstree._fn[i] = function () {\n\t\t\t\t\tvar rslt,\n\t\t\t\t\t\tfunc = val,\n\t\t\t\t\t\targs = Array.prototype.slice.call(arguments),\n\t\t\t\t\t\tevnt = new $.Event(\"before.jstree\"),\n\t\t\t\t\t\trlbk = false;\n\n\t\t\t\t\tif(this.data.core.locked === true && i !== \"unlock\" && i !== \"is_locked\") { return; }\n\n\t\t\t\t\t// Check if function belongs to the included plugins of this instance\n\t\t\t\t\tdo {\n\t\t\t\t\t\tif(func && func.plugin && $.inArray(func.plugin, this._get_settings().plugins) !== -1) { break; }\n\t\t\t\t\t\tfunc = func.old;\n\t\t\t\t\t} while(func);\n\t\t\t\t\tif(!func) { return; }\n\n\t\t\t\t\t// context and function to trigger events, then finally call the function\n\t\t\t\t\tif(i.indexOf(\"_\") === 0) {\n\t\t\t\t\t\trslt = func.apply(this, args);\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\trslt = this.get_container().triggerHandler(evnt, { \"func\" : i, \"inst\" : this, \"args\" : args, \"plugin\" : func.plugin });\n\t\t\t\t\t\tif(rslt === false) { return; }\n\t\t\t\t\t\tif(typeof rslt !== \"undefined\") { args = rslt; }\n\n\t\t\t\t\t\trslt = func.apply(\n\t\t\t\t\t\t\t$.extend({}, this, {\n\t\t\t\t\t\t\t\t__callback : function (data) {\n\t\t\t\t\t\t\t\t\tthis.get_container().triggerHandler( i + '.jstree', { \"inst\" : this, \"args\" : args, \"rslt\" : data, \"rlbk\" : rlbk });\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t__rollback : function () {\n\t\t\t\t\t\t\t\t\trlbk = this.get_rollback();\n\t\t\t\t\t\t\t\t\treturn rlbk;\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t__call_old : function (replace_arguments) {\n\t\t\t\t\t\t\t\t\treturn func.old.apply(this, (replace_arguments ? Array.prototype.slice.call(arguments, 1) : args ) );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}), args);\n\t\t\t\t\t}\n\n\t\t\t\t\t// return the result\n\t\t\t\t\treturn rslt;\n\t\t\t\t};\n\t\t\t\t$.jstree._fn[i].old = val.old;\n\t\t\t\t$.jstree._fn[i].plugin = pname;\n\t\t\t});\n\t\t},\n\t\trollback : function (rb) {\n\t\t\tif(rb) {\n\t\t\t\tif(!$.isArray(rb)) { rb = [ rb ]; }\n\t\t\t\t$.each(rb, function (i, val) {\n\t\t\t\t\tinstances[val.i].set_rollback(val.h, val.d);\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t};\n\t// set the prototype for all instances\n\t$.jstree._fn = $.jstree._instance.prototype = {};\n\n\t// load the css when DOM is ready\n\t$(function() {\n\t\t// code is copied from jQuery ($.browser is deprecated + there is a bug in IE)\n\t\tvar u = navigator.userAgent.toLowerCase(),\n\t\t\tv = (u.match( /.+?(?:rv|it|ra|ie)[\\/: ]([\\d.]+)/ ) || [0,'0'])[1],\n\t\t\tcss_string = '' +\n\t\t\t\t'.jstree ul, .jstree li { display:block; margin:0 0 0 0; padding:0 0 0 0; list-style-type:none; } ' +\n\t\t\t\t'.jstree li { display:block; min-height:18px; line-height:18px; white-space:nowrap; margin-left:18px; min-width:18px; } ' +\n\t\t\t\t'.jstree-rtl li { margin-left:0; margin-right:18px; } ' +\n\t\t\t\t'.jstree > ul > li { margin-left:0px; } ' +\n\t\t\t\t'.jstree-rtl > ul > li { margin-right:0px; } ' +\n\t\t\t\t'.jstree ins { display:inline-block; text-decoration:none; width:18px; height:18px; margin:0 0 0 0; padding:0; } ' +\n\t\t\t\t'.jstree a { display:inline-block; line-height:16px; height:16px; color:black; white-space:nowrap; text-decoration:none; padding:1px 2px; margin:0; } ' +\n\t\t\t\t'.jstree a:focus { outline: none; } ' +\n\t\t\t\t'.jstree a > ins { height:16px; width:16px; } ' +\n\t\t\t\t'.jstree a > .jstree-icon { margin-right:3px; } ' +\n\t\t\t\t'.jstree-rtl a > .jstree-icon { margin-left:3px; margin-right:0; } ' +\n\t\t\t\t'li.jstree-open > ul { display:block; } ' +\n\t\t\t\t'li.jstree-closed > ul { display:none; } ';\n\t\t// Correct IE 6 (does not support the > CSS selector)\n\t\tif(/msie/.test(u) && parseInt(v, 10) == 6) {\n\t\t\tis_ie6 = true;\n\n\t\t\t// fix image flicker and lack of caching\n\t\t\ttry {\n\t\t\t\tdocument.execCommand(\"BackgroundImageCache\", false, true);\n\t\t\t} catch (err) { }\n\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree li { height:18px; margin-left:0; margin-right:0; } ' +\n\t\t\t\t'.jstree li li { margin-left:18px; } ' +\n\t\t\t\t'.jstree-rtl li li { margin-left:0px; margin-right:18px; } ' +\n\t\t\t\t'li.jstree-open ul { display:block; } ' +\n\t\t\t\t'li.jstree-closed ul { display:none !important; } ' +\n\t\t\t\t'.jstree li a { display:inline; border-width:0 !important; padding:0px 2px !important; } ' +\n\t\t\t\t'.jstree li a ins { height:16px; width:16px; margin-right:3px; } ' +\n\t\t\t\t'.jstree-rtl li a ins { margin-right:0px; margin-left:3px; } ';\n\t\t}\n\t\t// Correct IE 7 (shifts anchor nodes onhover)\n\t\tif(/msie/.test(u) && parseInt(v, 10) == 7) {\n\t\t\tis_ie7 = true;\n\t\t\tcss_string += '.jstree li a { border-width:0 !important; padding:0px 2px !important; } ';\n\t\t}\n\t\t// correct ff2 lack of display:inline-block\n\t\tif(!/compatible/.test(u) && /mozilla/.test(u) && parseFloat(v, 10) < 1.9) {\n\t\t\tis_ff2 = true;\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree ins { display:-moz-inline-box; } ' +\n\t\t\t\t'.jstree li { line-height:12px; } ' + // WHY??\n\t\t\t\t'.jstree a { display:-moz-inline-box; } ' +\n\t\t\t\t'.jstree .jstree-no-icons .jstree-checkbox { display:-moz-inline-stack !important; } ';\n\t\t\t\t/* this shouldn't be here as it is theme specific */\n\t\t}\n\t\t// the default stylesheet\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n\n\t// core functions (open, close, create, update, delete)\n\t$.jstree.plugin(\"core\", {\n\t\t__init : function () {\n\t\t\tthis.data.core.locked = false;\n\t\t\tthis.data.core.to_open = this.get_settings().core.initially_open;\n\t\t\tthis.data.core.to_load = this.get_settings().core.initially_load;\n\t\t},\n\t\tdefaults : {\n\t\t\thtml_titles\t: false,\n\t\t\tanimation\t: 500,\n\t\t\tinitially_open : [],\n\t\t\tinitially_load : [],\n\t\t\topen_parents : true,\n\t\t\tnotify_plugins : true,\n\t\t\trtl\t\t\t: false,\n\t\t\tload_open\t: false,\n\t\t\tstrings\t\t: {\n\t\t\t\tloading\t\t: \"Loading ...\",\n\t\t\t\tnew_node\t: \"New node\",\n\t\t\t\tmultiple_selection : \"Multiple selection\"\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\tinit\t: function () {\n\t\t\t\tthis.set_focus();\n\t\t\t\tif(this._get_settings().core.rtl) {\n\t\t\t\t\tthis.get_container().addClass(\"jstree-rtl\").css(\"direction\", \"rtl\");\n\t\t\t\t}\n\t\t\t\tthis.get_container().html(\"<ul><li class='jstree-last jstree-leaf'><ins>&#160;</ins><a class='jstree-loading' href='#'><ins class='jstree-icon'>&#160;</ins>\" + this._get_string(\"loading\") + \"</a></li></ul>\");\n\t\t\t\tthis.data.core.li_height = this.get_container_ul().find(\"li.jstree-closed, li.jstree-leaf\").eq(0).height() || 18;\n\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.delegate(\"li > ins\", \"click.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\t\tvar trgt = $(event.target);\n\t\t\t\t\t\t\t// if(trgt.is(\"ins\") && event.pageY - trgt.offset().top < this.data.core.li_height) { this.toggle_node(trgt); }\n\t\t\t\t\t\t\tthis.toggle_node(trgt);\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.bind(\"mousedown.jstree\", $.proxy(function () {\n\t\t\t\t\t\t\tthis.set_focus(); // This used to be setTimeout(set_focus,0) - why?\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.bind(\"dblclick.jstree\", function (event) {\n\t\t\t\t\t\tvar sel;\n\t\t\t\t\t\tif(document.selection && document.selection.empty) { document.selection.empty(); }\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(window.getSelection) {\n\t\t\t\t\t\t\t\tsel = window.getSelection();\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tsel.removeAllRanges();\n\t\t\t\t\t\t\t\t\tsel.collapse();\n\t\t\t\t\t\t\t\t} catch (err) { }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\tif(this._get_settings().core.notify_plugins) {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\t\tvar o = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\t\t\tt = this;\n\t\t\t\t\t\t\t\tif(o === -1) { o = this.get_container_ul(); }\n\t\t\t\t\t\t\t\tif(!o.length) { return; }\n\t\t\t\t\t\t\t\to.find(\"li\").each(function () {\n\t\t\t\t\t\t\t\t\tvar th = $(this);\n\t\t\t\t\t\t\t\t\tif(th.data(\"jstree\")) {\n\t\t\t\t\t\t\t\t\t\t$.each(th.data(\"jstree\"), function (plugin, values) {\n\t\t\t\t\t\t\t\t\t\t\tif(t.data[plugin] && $.isFunction(t[\"_\" + plugin + \"_notify\"])) {\n\t\t\t\t\t\t\t\t\t\t\t\tt[\"_\" + plugin + \"_notify\"].call(t, th, values);\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\tif(this._get_settings().core.load_open) {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\t\tvar o = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\t\t\tt = this;\n\t\t\t\t\t\t\t\tif(o === -1) { o = this.get_container_ul(); }\n\t\t\t\t\t\t\t\tif(!o.length) { return; }\n\t\t\t\t\t\t\t\to.find(\"li.jstree-open:not(:has(ul))\").each(function () {\n\t\t\t\t\t\t\t\t\tt.load_node(this, $.noop, $.noop);\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\tthis.__callback();\n\t\t\t\tthis.load_node(-1, function () { this.loaded(); this.reload_nodes(); });\n\t\t\t},\n\t\t\tdestroy\t: function () {\n\t\t\t\tvar i,\n\t\t\t\t\tn = this.get_index(),\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this;\n\n\t\t\t\t$.each(s.plugins, function (i, val) {\n\t\t\t\t\ttry { plugins[val].__destroy.apply(_this); } catch(err) { }\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t\t// set focus to another instance if this one is focused\n\t\t\t\tif(this.is_focused()) {\n\t\t\t\t\tfor(i in instances) {\n\t\t\t\t\t\tif(instances.hasOwnProperty(i) && i != n) {\n\t\t\t\t\t\t\tinstances[i].set_focus();\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t// if no other instance found\n\t\t\t\tif(n === focused_instance) { focused_instance = -1; }\n\t\t\t\t// remove all traces of jstree in the DOM (only the ones set using jstree*) and cleans all events\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.unbind(\".jstree\")\n\t\t\t\t\t.undelegate(\".jstree\")\n\t\t\t\t\t.removeData(\"jstree_instance_id\")\n\t\t\t\t\t.find(\"[class^='jstree']\")\n\t\t\t\t\t\t.addBack()\n\t\t\t\t\t\t.attr(\"class\", function () { return this.className.replace(/jstree[^ ]*|$/ig,''); });\n\t\t\t\t$(document)\n\t\t\t\t\t.unbind(\".jstree-\" + n)\n\t\t\t\t\t.undelegate(\".jstree-\" + n);\n\t\t\t\t// remove the actual data\n\t\t\t\tinstances[n] = null;\n\t\t\t\tdelete instances[n];\n\t\t\t},\n\n\t\t\t_core_notify : function (n, data) {\n\t\t\t\tif(data.opened) {\n\t\t\t\t\tthis.open_node(n, false, true);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlock : function () {\n\t\t\t\tthis.data.core.locked = true;\n\t\t\t\tthis.get_container().children(\"ul\").addClass(\"jstree-locked\").css(\"opacity\",\"0.7\");\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\tunlock : function () {\n\t\t\t\tthis.data.core.locked = false;\n\t\t\t\tthis.get_container().children(\"ul\").removeClass(\"jstree-locked\").css(\"opacity\",\"1\");\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\tis_locked : function () { return this.data.core.locked; },\n\t\t\tsave_opened : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.core.to_open = [];\n\t\t\t\tthis.get_container_ul().find(\"li.jstree-open\").each(function () {\n\t\t\t\t\tif(this.id) { _this.data.core.to_open.push(\"#\" + this.id.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\")); }\n\t\t\t\t});\n\t\t\t\tthis.__callback(_this.data.core.to_open);\n\t\t\t},\n\t\t\tsave_loaded : function () { },\n\t\t\treload_nodes : function (is_callback) {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tdone = true,\n\t\t\t\t\tcurrent = [],\n\t\t\t\t\tremaining = [];\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tthis.data.core.reopen = false;\n\t\t\t\t\tthis.data.core.refreshing = true;\n\t\t\t\t\tthis.data.core.to_open = $.map($.makeArray(this.data.core.to_open), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tthis.data.core.to_load = $.map($.makeArray(this.data.core.to_load), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t\tthis.data.core.to_load = this.data.core.to_load.concat(this.data.core.to_open);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(this.data.core.to_load.length) {\n\t\t\t\t\t$.each(this.data.core.to_load, function (i, val) {\n\t\t\t\t\t\tif(val == \"#\") { return true; }\n\t\t\t\t\t\tif($(val).length) { current.push(val); }\n\t\t\t\t\t\telse { remaining.push(val); }\n\t\t\t\t\t});\n\t\t\t\t\tif(current.length) {\n\t\t\t\t\t\tthis.data.core.to_load = remaining;\n\t\t\t\t\t\t$.each(current, function (i, val) {\n\t\t\t\t\t\t\tif(!_this._is_loaded(val)) {\n\t\t\t\t\t\t\t\t_this.load_node(val, function () { _this.reload_nodes(true); }, function () { _this.reload_nodes(true); });\n\t\t\t\t\t\t\t\tdone = false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t$.each(this.data.core.to_open, function (i, val) {\n\t\t\t\t\t\t_this.open_node(val, false, true);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(done) {\n\t\t\t\t\t// TODO: find a more elegant approach to syncronizing returning requests\n\t\t\t\t\tif(this.data.core.reopen) { clearTimeout(this.data.core.reopen); }\n\t\t\t\t\tthis.data.core.reopen = setTimeout(function () { _this.__callback({}, _this); }, 50);\n\t\t\t\t\tthis.data.core.refreshing = false;\n\t\t\t\t\tthis.reopen();\n\t\t\t\t}\n\t\t\t},\n\t\t\treopen : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t$.each(this.data.core.to_open, function (i, val) {\n\t\t\t\t\t\t_this.open_node(val, false, true);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.save_opened();\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tif(obj !== -1) { obj.children(\"UL\").remove(); }\n\t\t\t\telse { this.get_container_ul().empty(); }\n\t\t\t\tthis.load_node(obj, function () { _this.__callback({ \"obj\" : obj}); _this.reload_nodes(); });\n\t\t\t},\n\t\t\t// Dummy function to fire after the first load (so that there is a jstree.loaded event)\n\t\t\tloaded\t: function () {\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\t// deal with focus\n\t\t\tset_focus\t: function () {\n\t\t\t\tif(this.is_focused()) { return; }\n\t\t\t\tvar f = $.jstree._focused();\n\t\t\t\tif(f) { f.unset_focus(); }\n\n\t\t\t\tthis.get_container().addClass(\"jstree-focused\");\n\t\t\t\tfocused_instance = this.get_index();\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tis_focused\t: function () {\n\t\t\t\treturn focused_instance == this.get_index();\n\t\t\t},\n\t\t\tunset_focus\t: function () {\n\t\t\t\tif(this.is_focused()) {\n\t\t\t\t\tthis.get_container().removeClass(\"jstree-focused\");\n\t\t\t\t\tfocused_instance = -1;\n\t\t\t\t}\n\t\t\t\tthis.__callback();\n\t\t\t},\n\n\t\t\t// traverse\n\t\t\t_get_node\t\t: function (obj) {\n\t\t\t\tvar $obj = $(obj, this.get_container());\n\t\t\t\tif($obj.is(\".jstree\") || obj == -1) { return -1; }\n\t\t\t\t$obj = $obj.closest(\"li\", this.get_container());\n\t\t\t\treturn $obj.length ? $obj : false;\n\t\t\t},\n\t\t\t_get_next\t\t: function (obj, strict) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().find(\"> ul > li:first-child\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(strict) { return (obj.nextAll(\"li\").size() > 0) ? obj.nextAll(\"li:eq(0)\") : false; }\n\n\t\t\t\tif(obj.hasClass(\"jstree-open\")) { return obj.find(\"li:eq(0)\"); }\n\t\t\t\telse if(obj.nextAll(\"li\").size() > 0) { return obj.nextAll(\"li:eq(0)\"); }\n\t\t\t\telse { return obj.parentsUntil(\".jstree\",\"li\").next(\"li\").eq(0); }\n\t\t\t},\n\t\t\t_get_prev\t\t: function (obj, strict) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().find(\"> ul > li:last-child\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(strict) { return (obj.prevAll(\"li\").length > 0) ? obj.prevAll(\"li:eq(0)\") : false; }\n\n\t\t\t\tif(obj.prev(\"li\").length) {\n\t\t\t\t\tobj = obj.prev(\"li\").eq(0);\n\t\t\t\t\twhile(obj.hasClass(\"jstree-open\")) { obj = obj.children(\"ul:eq(0)\").children(\"li:last\"); }\n\t\t\t\t\treturn obj;\n\t\t\t\t}\n\t\t\t\telse { var o = obj.parentsUntil(\".jstree\",\"li:eq(0)\"); return o.length ? o : false; }\n\t\t\t},\n\t\t\t_get_parent\t\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj == -1 || !obj.length) { return false; }\n\t\t\t\tvar o = obj.parentsUntil(\".jstree\", \"li:eq(0)\");\n\t\t\t\treturn o.length ? o : -1;\n\t\t\t},\n\t\t\t_get_children\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().children(\"ul:eq(0)\").children(\"li\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\treturn obj.children(\"ul:eq(0)\").children(\"li\");\n\t\t\t},\n\t\t\tget_path\t\t: function (obj, id_mode) {\n\t\t\t\tvar p = [],\n\t\t\t\t\t_this = this;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1 || !obj || !obj.length) { return false; }\n\t\t\t\tobj.parentsUntil(\".jstree\", \"li\").each(function () {\n\t\t\t\t\tp.push( id_mode ? this.id : _this.get_text(this) );\n\t\t\t\t});\n\t\t\t\tp.reverse();\n\t\t\t\tp.push( id_mode ? obj.attr(\"id\") : this.get_text(obj) );\n\t\t\t\treturn p;\n\t\t\t},\n\n\t\t\t// string functions\n\t\t\t_get_string : function (key) {\n\t\t\t\treturn this._get_settings().core.strings[key] || key;\n\t\t\t},\n\n\t\t\tis_open\t\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-open\"); },\n\t\t\tis_closed\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-closed\"); },\n\t\t\tis_leaf\t\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-leaf\"); },\n\t\t\tcorrect_state\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { return false; }\n\t\t\t\tobj.removeClass(\"jstree-closed jstree-open\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\t// open/close\n\t\t\topen_node\t: function (obj, callback, skip_animation) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(!obj.hasClass(\"jstree-closed\")) { if(callback) { callback.call(); } return false; }\n\t\t\t\tvar s = skip_animation || is_ie6 ? 0 : this._get_settings().core.animation,\n\t\t\t\t\tt = this;\n\t\t\t\tif(!this._is_loaded(obj)) {\n\t\t\t\t\tobj.children(\"a\").addClass(\"jstree-loading\");\n\t\t\t\t\tthis.load_node(obj, function () { t.open_node(obj, callback, skip_animation); }, callback);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(this._get_settings().core.open_parents) {\n\t\t\t\t\t\tobj.parentsUntil(\".jstree\",\".jstree-closed\").each(function () {\n\t\t\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t\tif(s) { obj.children(\"ul\").css(\"display\",\"none\"); }\n\t\t\t\t\tobj.removeClass(\"jstree-closed\").addClass(\"jstree-open\").children(\"a\").removeClass(\"jstree-loading\");\n\t\t\t\t\tif(s) { obj.children(\"ul\").stop(true, true).slideDown(s, function () { this.style.display = \"\"; t.after_open(obj); }); }\n\t\t\t\t\telse { t.after_open(obj); }\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t\tif(callback) { callback.call(); }\n\t\t\t\t}\n\t\t\t},\n\t\t\tafter_open\t: function (obj) { this.__callback({ \"obj\" : obj }); },\n\t\t\tclose_node\t: function (obj, skip_animation) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = skip_animation || is_ie6 ? 0 : this._get_settings().core.animation,\n\t\t\t\t\tt = this;\n\t\t\t\tif(!obj.length || !obj.hasClass(\"jstree-open\")) { return false; }\n\t\t\t\tif(s) { obj.children(\"ul\").attr(\"style\",\"display:block !important\"); }\n\t\t\t\tobj.removeClass(\"jstree-open\").addClass(\"jstree-closed\");\n\t\t\t\tif(s) { obj.children(\"ul\").stop(true, true).slideUp(s, function () { this.style.display = \"\"; t.after_close(obj); }); }\n\t\t\t\telse { t.after_close(obj); }\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tafter_close\t: function (obj) { this.__callback({ \"obj\" : obj }); },\n\t\t\ttoggle_node\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj.hasClass(\"jstree-closed\")) { return this.open_node(obj); }\n\t\t\t\tif(obj.hasClass(\"jstree-open\")) { return this.close_node(obj); }\n\t\t\t},\n\t\t\topen_all\t: function (obj, do_animation, original_obj) {\n\t\t\t\tobj = obj ? this._get_node(obj) : -1;\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container_ul(); }\n\t\t\t\tif(original_obj) {\n\t\t\t\t\tobj = obj.find(\"li.jstree-closed\");\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\toriginal_obj = obj;\n\t\t\t\t\tif(obj.is(\".jstree-closed\")) { obj = obj.find(\"li.jstree-closed\").addBack(); }\n\t\t\t\t\telse { obj = obj.find(\"li.jstree-closed\"); }\n\t\t\t\t}\n\t\t\t\tvar _this = this;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tvar __this = this;\n\t\t\t\t\tif(!_this._is_loaded(this)) { _this.open_node(this, function() { _this.open_all(__this, do_animation, original_obj); }, !do_animation); }\n\t\t\t\t\telse { _this.open_node(this, false, !do_animation); }\n\t\t\t\t});\n\t\t\t\t// so that callback is fired AFTER all nodes are open\n\t\t\t\tif(original_obj.find('li.jstree-closed').length === 0) { this.__callback({ \"obj\" : original_obj }); }\n\t\t\t},\n\t\t\tclose_all\t: function (obj, do_animation) {\n\t\t\t\tvar _this = this;\n\t\t\t\tobj = obj ? this._get_node(obj) : this.get_container();\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container_ul(); }\n\t\t\t\tobj.find(\"li.jstree-open\").addBack().each(function () { _this.close_node(this, !do_animation); });\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tclean_node\t: function (obj) {\n\t\t\t\tobj = obj && obj != -1 ? $(obj) : this.get_container_ul();\n\t\t\t\tobj = obj.is(\"li\") ? obj.find(\"li\").addBack() : obj.find(\"li\");\n\t\t\t\tobj.removeClass(\"jstree-last\")\n\t\t\t\t\t.filter(\"li:last-child\").addClass(\"jstree-last\").end()\n\t\t\t\t\t.filter(\":has(li)\")\n\t\t\t\t\t\t.not(\".jstree-open\").removeClass(\"jstree-leaf\").addClass(\"jstree-closed\");\n\t\t\t\tobj.not(\".jstree-open, .jstree-closed\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\t// rollback\n\t\t\tget_rollback : function () {\n\t\t\t\tthis.__callback();\n\t\t\t\treturn { i : this.get_index(), h : this.get_container().children(\"ul\").clone(true), d : this.data };\n\t\t\t},\n\t\t\tset_rollback : function (html, data) {\n\t\t\t\tthis.get_container().empty().append(html);\n\t\t\t\tthis.data = data;\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\t// Dummy functions to be overwritten by any datastore plugin included\n\t\t\tload_node\t: function (obj, s_call, e_call) { this.__callback({ \"obj\" : obj }); },\n\t\t\t_is_loaded\t: function (obj) { return true; },\n\n\t\t\t// Basic operations: create\n\t\t\tcreate_node\t: function (obj, position, js, callback, is_loaded) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tposition = typeof position === \"undefined\" ? \"last\" : position;\n\t\t\t\tvar d = $(\"<li />\"),\n\t\t\t\t\ts = this._get_settings().core,\n\t\t\t\t\ttmp;\n\n\t\t\t\tif(obj !== -1 && !obj.length) { return false; }\n\t\t\t\tif(!is_loaded && !this._is_loaded(obj)) { this.load_node(obj, function () { this.create_node(obj, position, js, callback, true); }); return false; }\n\n\t\t\t\tthis.__rollback();\n\n\t\t\t\tif(typeof js === \"string\") { js = { \"data\" : js }; }\n\t\t\t\tif(!js) { js = {}; }\n\t\t\t\tif(js.attr) { d.attr(js.attr); }\n\t\t\t\tif(js.metadata) { d.data(js.metadata); }\n\t\t\t\tif(js.state) { d.addClass(\"jstree-\" + js.state); }\n\t\t\t\tif(!js.data) { js.data = this._get_string(\"new_node\"); }\n\t\t\t\tif(!$.isArray(js.data)) { tmp = js.data; js.data = []; js.data.push(tmp); }\n\t\t\t\t$.each(js.data, function (i, m) {\n\t\t\t\t\ttmp = $(\"<a />\");\n\t\t\t\t\tif($.isFunction(m)) { m = m.call(this, js); }\n\t\t\t\t\tif(typeof m == \"string\") { tmp.attr('href','#')[ s.html_titles ? \"html\" : \"text\" ](m); }\n\t\t\t\t\telse {\n\t\t\t\t\t\tif(!m.attr) { m.attr = {}; }\n\t\t\t\t\t\tif(!m.attr.href) { m.attr.href = '#'; }\n\t\t\t\t\t\ttmp.attr(m.attr)[ s.html_titles ? \"html\" : \"text\" ](m.title);\n\t\t\t\t\t\tif(m.language) { tmp.addClass(m.language); }\n\t\t\t\t\t}\n\t\t\t\t\ttmp.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\tif(!m.icon && js.icon) { m.icon = js.icon; }\n\t\t\t\t\tif(m.icon) {\n\t\t\t\t\t\tif(m.icon.indexOf(\"/\") === -1) { tmp.children(\"ins\").addClass(m.icon); }\n\t\t\t\t\t\telse { tmp.children(\"ins\").css(\"background\",\"url('\" + m.icon + \"') center center no-repeat\"); }\n\t\t\t\t\t}\n\t\t\t\t\td.append(tmp);\n\t\t\t\t});\n\t\t\t\td.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\tif(obj === -1) {\n\t\t\t\t\tobj = this.get_container();\n\t\t\t\t\tif(position === \"before\") { position = \"first\"; }\n\t\t\t\t\tif(position === \"after\") { position = \"last\"; }\n\t\t\t\t}\n\t\t\t\tswitch(position) {\n\t\t\t\t\tcase \"before\": obj.before(d); tmp = this._get_parent(obj); break;\n\t\t\t\t\tcase \"after\" : obj.after(d);  tmp = this._get_parent(obj); break;\n\t\t\t\t\tcase \"inside\":\n\t\t\t\t\tcase \"first\" :\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tobj.children(\"ul\").prepend(d);\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tobj.children(\"ul\").append(d);\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tif(!position) { position = 0; }\n\t\t\t\t\t\ttmp = obj.children(\"ul\").children(\"li\").eq(position);\n\t\t\t\t\t\tif(tmp.length) { tmp.before(d); }\n\t\t\t\t\t\telse { obj.children(\"ul\").append(d); }\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tif(tmp === -1 || tmp.get(0) === this.get_container().get(0)) { tmp = -1; }\n\t\t\t\tthis.clean_node(tmp);\n\t\t\t\tthis.__callback({ \"obj\" : d, \"parent\" : tmp });\n\t\t\t\tif(callback) { callback.call(this, d); }\n\t\t\t\treturn d;\n\t\t\t},\n\t\t\t// Basic operations: rename (deal with text)\n\t\t\tget_text\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tvar s = this._get_settings().core.html_titles;\n\t\t\t\tobj = obj.children(\"a:eq(0)\");\n\t\t\t\tif(s) {\n\t\t\t\t\tobj = obj.clone();\n\t\t\t\t\tobj.children(\"INS\").remove();\n\t\t\t\t\treturn obj.html();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\treturn obj.nodeValue;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset_text\t: function (obj, val) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tobj = obj.children(\"a:eq(0)\");\n\t\t\t\tif(this._get_settings().core.html_titles) {\n\t\t\t\t\tvar tmp = obj.children(\"INS\").clone();\n\t\t\t\t\tobj.html(val).prepend(tmp);\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val });\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val });\n\t\t\t\t\treturn (obj.nodeValue = val);\n\t\t\t\t}\n\t\t\t},\n\t\t\trename_node : function (obj, val) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tif(obj && obj.length && this.set_text.apply(this, Array.prototype.slice.call(arguments))) { this.__callback({ \"obj\" : obj, \"name\" : val }); }\n\t\t\t},\n\t\t\t// Basic operations: deleting nodes\n\t\t\tdelete_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar p = this._get_parent(obj), prev = $([]), t = this;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tprev = prev.add(t._get_prev(this));\n\t\t\t\t});\n\t\t\t\tobj = obj.detach();\n\t\t\t\tif(p !== -1 && p.find(\"> ul > li\").length === 0) {\n\t\t\t\t\tp.removeClass(\"jstree-open jstree-closed\").addClass(\"jstree-leaf\");\n\t\t\t\t}\n\t\t\t\tthis.clean_node(p);\n\t\t\t\tthis.__callback({ \"obj\" : obj, \"prev\" : prev, \"parent\" : p });\n\t\t\t\treturn obj;\n\t\t\t},\n\t\t\tprepare_move : function (o, r, pos, cb, is_cb) {\n\t\t\t\tvar p = {};\n\n\t\t\t\tp.ot = $.jstree._reference(o) || this;\n\t\t\t\tp.o = p.ot._get_node(o);\n\t\t\t\tp.r = r === - 1 ? -1 : this._get_node(r);\n\t\t\t\tp.p = (typeof pos === \"undefined\" || pos === false) ? \"last\" : pos; // TODO: move to a setting\n\t\t\t\tif(!is_cb && prepared_move.o && prepared_move.o[0] === p.o[0] && prepared_move.r[0] === p.r[0] && prepared_move.p === p.p) {\n\t\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\t\tif(cb) { cb.call(this, prepared_move); }\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tp.ot = $.jstree._reference(p.o) || this;\n\t\t\t\tp.rt = $.jstree._reference(p.r) || this; // r === -1 ? p.ot : $.jstree._reference(p.r) || this\n\t\t\t\tif(p.r === -1 || !p.r) {\n\t\t\t\t\tp.cr = -1;\n\t\t\t\t\tswitch(p.p) {\n\t\t\t\t\t\tcase \"first\":\n\t\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\t\tp.cp = 0;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\t\tp.cp = p.rt.get_container().find(\" > ul > li\").length;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\tp.cp = p.p;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(!/^(before|after)$/.test(p.p) && !this._is_loaded(p.r)) {\n\t\t\t\t\t\treturn this.load_node(p.r, function () { this.prepare_move(o, r, pos, cb, true); });\n\t\t\t\t\t}\n\t\t\t\t\tswitch(p.p) {\n\t\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\t\tp.cp = p.r.index();\n\t\t\t\t\t\t\tp.cr = p.rt._get_parent(p.r);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\t\tp.cp = p.r.index() + 1;\n\t\t\t\t\t\t\tp.cr = p.rt._get_parent(p.r);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\tcase \"first\":\n\t\t\t\t\t\t\tp.cp = 0;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\t\tp.cp = p.r.find(\" > ul > li\").length;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\tp.cp = p.p;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tp.np = p.cr == -1 ? p.rt.get_container() : p.cr;\n\t\t\t\tp.op = p.ot._get_parent(p.o);\n\t\t\t\tp.cop = p.o.index();\n\t\t\t\tif(p.op === -1) { p.op = p.ot ? p.ot.get_container() : this.get_container(); }\n\t\t\t\tif(!/^(before|after)$/.test(p.p) && p.op && p.np && p.op[0] === p.np[0] && p.o.index() < p.cp) { p.cp++; }\n\t\t\t\t//if(p.p === \"before\" && p.op && p.np && p.op[0] === p.np[0] && p.o.index() < p.cp) { p.cp--; }\n\t\t\t\tp.or = p.np.find(\" > ul > li:nth-child(\" + (p.cp + 1) + \")\");\n\t\t\t\tprepared_move = p;\n\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\tif(cb) { cb.call(this, prepared_move); }\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tvar obj = prepared_move, ret = true, r = obj.r === -1 ? this.get_container() : obj.r;\n\t\t\t\tif(!obj || !obj.o || obj.or[0] === obj.o[0]) { return false; }\n\t\t\t\tif(obj.op && obj.np && obj.op[0] === obj.np[0] && obj.cp - 1 === obj.o.index()) { return false; }\n\t\t\t\tobj.o.each(function () {\n\t\t\t\t\tif(r.parentsUntil(\".jstree\", \"li\").addBack().index(this) !== -1) { ret = false; return false; }\n\t\t\t\t});\n\t\t\t\treturn ret;\n\t\t\t},\n\t\t\tmove_node : function (obj, ref, position, is_copy, is_prepared, skip_check) {\n\t\t\t\tif(!is_prepared) {\n\t\t\t\t\treturn this.prepare_move(obj, ref, position, function (p) {\n\t\t\t\t\t\tthis.move_node(p, false, false, is_copy, true, skip_check);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(is_copy) {\n\t\t\t\t\tprepared_move.cy = true;\n\t\t\t\t}\n\t\t\t\tif(!skip_check && !this.check_move()) { return false; }\n\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar o = false;\n\t\t\t\tif(is_copy) {\n\t\t\t\t\to = obj.o.clone(true);\n\t\t\t\t\to.find(\"*[id]\").addBack().each(function () {\n\t\t\t\t\t\tif(this.id) { this.id = \"copy_\" + this.id; }\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\telse { o = obj.o; }\n\n\t\t\t\tif(obj.or.length) { obj.or.before(o); }\n\t\t\t\telse {\n\t\t\t\t\tif(!obj.np.children(\"ul\").length) { $(\"<ul />\").appendTo(obj.np); }\n\t\t\t\t\tobj.np.children(\"ul:eq(0)\").append(o);\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tobj.ot.clean_node(obj.op);\n\t\t\t\t\tobj.rt.clean_node(obj.np);\n\t\t\t\t\tif(!obj.op.find(\"> ul > li\").length) {\n\t\t\t\t\t\tobj.op.removeClass(\"jstree-open jstree-closed\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\t\t}\n\t\t\t\t} catch (e) { }\n\n\t\t\t\tif(is_copy) {\n\t\t\t\t\tprepared_move.cy = true;\n\t\t\t\t\tprepared_move.oc = o;\n\t\t\t\t}\n\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\treturn prepared_move;\n\t\t\t},\n\t\t\t_get_move : function () { return prepared_move; }\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree ui plugin\n * This plugins handles selecting/deselecting/hovering/dehovering nodes\n */\n(function ($) {\n\tvar scrollbar_width, e1, e2;\n\t$(function() {\n\t\tif (/msie/.test(navigator.userAgent.toLowerCase())) {\n\t\t\te1 = $('<textarea cols=\"10\" rows=\"2\"></textarea>').css({ position: 'absolute', top: -1000, left: 0 }).appendTo('body');\n\t\t\te2 = $('<textarea cols=\"10\" rows=\"2\" style=\"overflow: hidden;\"></textarea>').css({ position: 'absolute', top: -1000, left: 0 }).appendTo('body');\n\t\t\tscrollbar_width = e1.width() - e2.width();\n\t\t\te1.add(e2).remove();\n\t\t}\n\t\telse {\n\t\t\te1 = $('<div />').css({ width: 100, height: 100, overflow: 'auto', position: 'absolute', top: -1000, left: 0 })\n\t\t\t\t\t.prependTo('body').append('<div />').find('div').css({ width: '100%', height: 200 });\n\t\t\tscrollbar_width = 100 - e1.width();\n\t\t\te1.parent().remove();\n\t\t}\n\t});\n\t$.jstree.plugin(\"ui\", {\n\t\t__init : function () {\n\t\t\tthis.data.ui.selected = $();\n\t\t\tthis.data.ui.last_selected = false;\n\t\t\tthis.data.ui.hovered = null;\n\t\t\tthis.data.ui.to_select = this.get_settings().ui.initially_select;\n\n\t\t\tthis.get_container()\n\t\t\t\t.delegate(\"a\", \"click.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tevent.currentTarget.blur();\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.select_node(event.currentTarget, true, event);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseenter.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.hover_node(event.target);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseleave.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.dehover_node(event.target);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"reopen.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.reselect();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"get_rollback.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.dehover_node();\n\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"set_rollback.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.reselect();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"close_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tvar s = this._get_settings().ui,\n\t\t\t\t\t\t\tobj = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\tclk = (obj && obj.length) ? obj.children(\"ul\").find(\"a.jstree-clicked\") : $(),\n\t\t\t\t\t\t\t_this = this;\n\t\t\t\t\t\tif(s.selected_parent_close === false || !clk.length) { return; }\n\t\t\t\t\t\tclk.each(function () {\n\t\t\t\t\t\t\t_this.deselect_node(this);\n\t\t\t\t\t\t\tif(s.selected_parent_close === \"select_parent\") { _this.select_node(obj); }\n\t\t\t\t\t\t});\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"delete_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tvar s = this._get_settings().ui.select_prev_on_delete,\n\t\t\t\t\t\t\tobj = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\tclk = (obj && obj.length) ? obj.find(\"a.jstree-clicked\") : [],\n\t\t\t\t\t\t\t_this = this;\n\t\t\t\t\t\tclk.each(function () { _this.deselect_node(this); });\n\t\t\t\t\t\tif(s && clk.length) {\n\t\t\t\t\t\t\tdata.rslt.prev.each(function () {\n\t\t\t\t\t\t\t\tif(this.parentNode) { _this.select_node(this); return false; /* if return false is removed all prev nodes will be selected */}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tif(data.rslt.cy) {\n\t\t\t\t\t\t\tdata.rslt.oc.find(\"a.jstree-clicked\").removeClass(\"jstree-clicked\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tselect_limit : -1, // 0, 1, 2 ... or -1 for unlimited\n\t\t\tselect_multiple_modifier : \"ctrl\", // on, or ctrl, shift, alt\n\t\t\tselect_range_modifier : \"shift\",\n\t\t\tselected_parent_close : \"select_parent\", // false, \"deselect\", \"select_parent\"\n\t\t\tselected_parent_open : true,\n\t\t\tselect_prev_on_delete : true,\n\t\t\tdisable_selecting_children : false,\n\t\t\tinitially_select : []\n\t\t},\n\t\t_fn : {\n\t\t\t_get_node : function (obj, allow_multiple) {\n\t\t\t\tif(typeof obj === \"undefined\" || obj === null) { return allow_multiple ? this.data.ui.selected : this.data.ui.last_selected; }\n\t\t\t\tvar $obj = $(obj, this.get_container());\n\t\t\t\tif($obj.is(\".jstree\") || obj == -1) { return -1; }\n\t\t\t\t$obj = $obj.closest(\"li\", this.get_container());\n\t\t\t\treturn $obj.length ? $obj : false;\n\t\t\t},\n\t\t\t_ui_notify : function (n, data) {\n\t\t\t\tif(data.selected) {\n\t\t\t\t\tthis.select_node(n, false);\n\t\t\t\t}\n\t\t\t},\n\t\t\tsave_selected : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.ui.to_select = [];\n\t\t\t\tthis.data.ui.selected.each(function () { if(this.id) { _this.data.ui.to_select.push(\"#\" + this.id.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\")); } });\n\t\t\t\tthis.__callback(this.data.ui.to_select);\n\t\t\t},\n\t\t\treselect : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\ts = this.data.ui.to_select;\n\t\t\t\ts = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t// this.deselect_all(); WHY deselect, breaks plugin state notifier?\n\t\t\t\t$.each(s, function (i, val) { if(val && val !== \"#\") { _this.select_node(val); } });\n\t\t\t\tthis.data.ui.selected = this.data.ui.selected.filter(function () { return this.parentNode; });\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tthis.save_selected();\n\t\t\t\treturn this.__call_old();\n\t\t\t},\n\t\t\thover_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\t//if(this.data.ui.hovered && obj.get(0) === this.data.ui.hovered.get(0)) { return; }\n\t\t\t\tif(!obj.hasClass(\"jstree-hovered\")) { this.dehover_node(); }\n\t\t\t\tthis.data.ui.hovered = obj.children(\"a\").addClass(\"jstree-hovered\").parent();\n\t\t\t\tthis._fix_scroll(obj);\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tdehover_node : function () {\n\t\t\t\tvar obj = this.data.ui.hovered, p;\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tp = obj.children(\"a\").removeClass(\"jstree-hovered\").parent();\n\t\t\t\tif(this.data.ui.hovered[0] === p[0]) { this.data.ui.hovered = null; }\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tselect_node : function (obj, check, e) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj == -1 || !obj || !obj.length) { return false; }\n\t\t\t\tvar s = this._get_settings().ui,\n\t\t\t\t\tis_multiple = (s.select_multiple_modifier == \"on\" || (s.select_multiple_modifier !== false && e && e[s.select_multiple_modifier + \"Key\"])),\n\t\t\t\t\tis_range = (s.select_range_modifier !== false && e && e[s.select_range_modifier + \"Key\"] && this.data.ui.last_selected && this.data.ui.last_selected[0] !== obj[0] && this.data.ui.last_selected.parent()[0] === obj.parent()[0]),\n\t\t\t\t\tis_selected = this.is_selected(obj),\n\t\t\t\t\tproceed = true,\n\t\t\t\t\tt = this;\n\t\t\t\tif(check) {\n\t\t\t\t\tif(s.disable_selecting_children && is_multiple &&\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\t(obj.parentsUntil(\".jstree\",\"li\").children(\"a.jstree-clicked\").length) ||\n\t\t\t\t\t\t\t(obj.children(\"ul\").find(\"a.jstree-clicked:eq(0)\").length)\n\t\t\t\t\t\t)\n\t\t\t\t\t) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tproceed = false;\n\t\t\t\t\tswitch(!0) {\n\t\t\t\t\t\tcase (is_range):\n\t\t\t\t\t\t\tthis.data.ui.last_selected.addClass(\"jstree-last-selected\");\n\t\t\t\t\t\t\tobj = obj[ obj.index() < this.data.ui.last_selected.index() ? \"nextUntil\" : \"prevUntil\" ](\".jstree-last-selected\").addBack();\n\t\t\t\t\t\t\tif(s.select_limit == -1 || obj.length < s.select_limit) {\n\t\t\t\t\t\t\t\tthis.data.ui.last_selected.removeClass(\"jstree-last-selected\");\n\t\t\t\t\t\t\t\tthis.data.ui.selected.each(function () {\n\t\t\t\t\t\t\t\t\tif(this !== t.data.ui.last_selected[0]) { t.deselect_node(this); }\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\tis_selected = false;\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tproceed = false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (is_selected && !is_multiple):\n\t\t\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t\t\tis_selected = false;\n\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (!is_selected && !is_multiple):\n\t\t\t\t\t\t\tif(s.select_limit == -1 || s.select_limit > 0) {\n\t\t\t\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (is_selected && is_multiple):\n\t\t\t\t\t\t\tthis.deselect_node(obj);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (!is_selected && is_multiple):\n\t\t\t\t\t\t\tif(s.select_limit == -1 || this.data.ui.selected.length + 1 <= s.select_limit) {\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(proceed && !is_selected) {\n\t\t\t\t\tif(!is_range) { this.data.ui.last_selected = obj; }\n\t\t\t\t\tobj.children(\"a\").addClass(\"jstree-clicked\");\n\t\t\t\t\tif(s.selected_parent_open) {\n\t\t\t\t\t\tobj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n\t\t\t\t\t}\n\t\t\t\t\tthis.data.ui.selected = this.data.ui.selected.add(obj);\n\t\t\t\t\tthis._fix_scroll(obj.eq(0));\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"e\" : e });\n\t\t\t\t}\n\t\t\t},\n\t\t\t_fix_scroll : function (obj) {\n\t\t\t\tvar c = this.get_container()[0], t;\n\t\t\t\tif(c.scrollHeight > c.offsetHeight) {\n\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\tif(!obj || obj === -1 || !obj.length || !obj.is(\":visible\")) { return; }\n\t\t\t\t\tt = obj.offset().top - this.get_container().offset().top;\n\t\t\t\t\tif(t < 0) {\n\t\t\t\t\t\tc.scrollTop = c.scrollTop + t - 1;\n\t\t\t\t\t}\n\t\t\t\t\tif(t + this.data.core.li_height + (c.scrollWidth > c.offsetWidth ? scrollbar_width : 0) > c.offsetHeight) {\n\t\t\t\t\t\tc.scrollTop = c.scrollTop + (t - c.offsetHeight + this.data.core.li_height + 1 + (c.scrollWidth > c.offsetWidth ? scrollbar_width : 0));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tdeselect_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(this.is_selected(obj)) {\n\t\t\t\t\tobj.children(\"a\").removeClass(\"jstree-clicked\");\n\t\t\t\t\tthis.data.ui.selected = this.data.ui.selected.not(obj);\n\t\t\t\t\tif(this.data.ui.last_selected.get(0) === obj.get(0)) { this.data.ui.last_selected = this.data.ui.selected.eq(0); }\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t}\n\t\t\t},\n\t\t\ttoggle_select : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(this.is_selected(obj)) { this.deselect_node(obj); }\n\t\t\t\telse { this.select_node(obj); }\n\t\t\t},\n\t\t\tis_selected : function (obj) { return this.data.ui.selected.index(this._get_node(obj)) >= 0; },\n\t\t\tget_selected : function (context) {\n\t\t\t\treturn context ? $(context).find(\"a.jstree-clicked\").parent() : this.data.ui.selected;\n\t\t\t},\n\t\t\tdeselect_all : function (context) {\n\t\t\t\tvar ret = context ? $(context).find(\"a.jstree-clicked\").parent() : this.get_container().find(\"a.jstree-clicked\").parent();\n\t\t\t\tret.children(\"a.jstree-clicked\").removeClass(\"jstree-clicked\");\n\t\t\t\tthis.data.ui.selected = $([]);\n\t\t\t\tthis.data.ui.last_selected = false;\n\t\t\t\tthis.__callback({ \"obj\" : ret });\n\t\t\t}\n\t\t}\n\t});\n\t// include the selection plugin by default\n\t$.jstree.defaults.plugins.push(\"ui\");\n})(jQuery);\n//*/\n\n/*\n * jsTree CRRM plugin\n * Handles creating/renaming/removing/moving nodes by user interaction.\n */\n(function ($) {\n\t$.jstree.plugin(\"crrm\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\tif(this._get_settings().crrm.move.open_onmove) {\n\t\t\t\t\t\tvar t = this;\n\t\t\t\t\t\tdata.rslt.np.parentsUntil(\".jstree\").addBack().filter(\".jstree-closed\").each(function () {\n\t\t\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tinput_width_limit : 200,\n\t\t\tmove : {\n\t\t\t\talways_copy\t\t\t: false, // false, true or \"multitree\"\n\t\t\t\topen_onmove\t\t\t: true,\n\t\t\t\tdefault_position\t: \"last\",\n\t\t\t\tcheck_move\t\t\t: function (m) { return true; }\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\t_show_input : function (obj, callback) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar rtl = this._get_settings().core.rtl,\n\t\t\t\t\tw = this._get_settings().crrm.input_width_limit,\n\t\t\t\t\tw1 = obj.children(\"ins\").width(),\n\t\t\t\t\tw2 = obj.find(\"> a:visible > ins\").width() * obj.find(\"> a:visible > ins\").length,\n\t\t\t\t\tt = this.get_text(obj),\n\t\t\t\t\th1 = $(\"<div />\", { css : { \"position\" : \"absolute\", \"top\" : \"-200px\", \"left\" : (rtl ? \"0px\" : \"-1000px\"), \"visibility\" : \"hidden\" } }).appendTo(\"body\"),\n\t\t\t\t\th2 = obj.css(\"position\",\"relative\").append(\n\t\t\t\t\t$(\"<input />\", {\n\t\t\t\t\t\t\"value\" : t,\n\t\t\t\t\t\t\"class\" : \"jstree-rename-input\",\n\t\t\t\t\t\t// \"size\" : t.length,\n\t\t\t\t\t\t\"css\" : {\n\t\t\t\t\t\t\t\"padding\" : \"0\",\n\t\t\t\t\t\t\t\"border\" : \"1px solid silver\",\n\t\t\t\t\t\t\t\"position\" : \"absolute\",\n\t\t\t\t\t\t\t\"left\"  : (rtl ? \"auto\" : (w1 + w2 + 4) + \"px\"),\n\t\t\t\t\t\t\t\"right\" : (rtl ? (w1 + w2 + 4) + \"px\" : \"auto\"),\n\t\t\t\t\t\t\t\"top\" : \"0px\",\n\t\t\t\t\t\t\t\"height\" : (this.data.core.li_height - 2) + \"px\",\n\t\t\t\t\t\t\t\"lineHeight\" : (this.data.core.li_height - 2) + \"px\",\n\t\t\t\t\t\t\t\"width\" : \"150px\" // will be set a bit further down\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"blur\" : $.proxy(function () {\n\t\t\t\t\t\t\tvar i = obj.children(\".jstree-rename-input\"),\n\t\t\t\t\t\t\t\tv = i.val();\n\t\t\t\t\t\t\tif(v === \"\") { v = t; }\n\t\t\t\t\t\t\th1.remove();\n\t\t\t\t\t\t\ti.remove(); // rollback purposes\n\t\t\t\t\t\t\tthis.set_text(obj,t); // rollback purposes\n\t\t\t\t\t\t\tthis.rename_node(obj, v);\n\t\t\t\t\t\t\tcallback.call(this, obj, v, t);\n\t\t\t\t\t\t\tobj.css(\"position\",\"\");\n\t\t\t\t\t\t}, this),\n\t\t\t\t\t\t\"keyup\" : function (event) {\n\t\t\t\t\t\t\tvar key = event.keyCode || event.which;\n\t\t\t\t\t\t\tif(key == 27) { this.value = t; this.blur(); return; }\n\t\t\t\t\t\t\telse if(key == 13) { this.blur(); return; }\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\th2.width(Math.min(h1.text(\"pW\" + this.value).width(),w));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"keypress\" : function(event) {\n\t\t\t\t\t\t\tvar key = event.keyCode || event.which;\n\t\t\t\t\t\t\tif(key == 13) { return false; }\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t).children(\".jstree-rename-input\");\n\t\t\t\tthis.set_text(obj, \"\");\n\t\t\t\th1.css({\n\t\t\t\t\t\tfontFamily\t\t: h2.css('fontFamily')\t\t|| '',\n\t\t\t\t\t\tfontSize\t\t: h2.css('fontSize')\t\t|| '',\n\t\t\t\t\t\tfontWeight\t\t: h2.css('fontWeight')\t\t|| '',\n\t\t\t\t\t\tfontStyle\t\t: h2.css('fontStyle')\t\t|| '',\n\t\t\t\t\t\tfontStretch\t\t: h2.css('fontStretch')\t\t|| '',\n\t\t\t\t\t\tfontVariant\t\t: h2.css('fontVariant')\t\t|| '',\n\t\t\t\t\t\tletterSpacing\t: h2.css('letterSpacing')\t|| '',\n\t\t\t\t\t\twordSpacing\t\t: h2.css('wordSpacing')\t\t|| ''\n\t\t\t\t});\n\t\t\t\th2.width(Math.min(h1.text(\"pW\" + h2[0].value).width(),w))[0].select();\n\t\t\t},\n\t\t\trename : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar f = this.__callback;\n\t\t\t\tthis._show_input(obj, function (obj, new_name, old_name) {\n\t\t\t\t\tf.call(this, { \"obj\" : obj, \"new_name\" : new_name, \"old_name\" : old_name });\n\t\t\t\t});\n\t\t\t},\n\t\t\tcreate : function (obj, position, js, callback, skip_rename) {\n\t\t\t\tvar t, _this = this;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tthis.__rollback();\n\t\t\t\tt = this.create_node(obj, position, js, function (t) {\n\t\t\t\t\tvar p = this._get_parent(t),\n\t\t\t\t\t\tpos = $(t).index();\n\t\t\t\t\tif(callback) { callback.call(this, t); }\n\t\t\t\t\tif(p.length && p.hasClass(\"jstree-closed\")) { this.open_node(p, false, true); }\n\t\t\t\t\tif(!skip_rename) {\n\t\t\t\t\t\tthis._show_input(t, function (obj, new_name, old_name) {\n\t\t\t\t\t\t\t_this.__callback({ \"obj\" : obj, \"name\" : new_name, \"parent\" : p, \"position\" : pos });\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t\telse { _this.__callback({ \"obj\" : t, \"name\" : this.get_text(t), \"parent\" : p, \"position\" : pos }); }\n\t\t\t\t});\n\t\t\t\treturn t;\n\t\t\t},\n\t\t\tremove : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tvar p = this._get_parent(obj), prev = this._get_prev(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tobj = this.delete_node(obj);\n\t\t\t\tif(obj !== false) { this.__callback({ \"obj\" : obj, \"prev\" : prev, \"parent\" : p }); }\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar s = this._get_settings().crrm.move;\n\t\t\t\tif(!s.check_move.call(this, this._get_move())) { return false; }\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tmove_node : function (obj, ref, position, is_copy, is_prepared, skip_check) {\n\t\t\t\tvar s = this._get_settings().crrm.move;\n\t\t\t\tif(!is_prepared) {\n\t\t\t\t\tif(typeof position === \"undefined\") { position = s.default_position; }\n\t\t\t\t\tif(position === \"inside\" && !s.default_position.match(/^(before|after)$/)) { position = s.default_position; }\n\t\t\t\t\treturn this.__call_old(true, obj, ref, position, is_copy, false, skip_check);\n\t\t\t\t}\n\t\t\t\t// if the move is already prepared\n\t\t\t\tif(s.always_copy === true || (s.always_copy === \"multitree\" && obj.rt.get_index() !== obj.ot.get_index() )) {\n\t\t\t\t\tis_copy = true;\n\t\t\t\t}\n\t\t\t\tthis.__call_old(true, obj, ref, position, is_copy, true, skip_check);\n\t\t\t},\n\n\t\t\tcut : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tthis.data.crrm.cp_nodes = false;\n\t\t\t\tthis.data.crrm.ct_nodes = obj;\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tcopy : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tthis.data.crrm.ct_nodes = false;\n\t\t\t\tthis.data.crrm.cp_nodes = obj;\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tpaste : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tvar nodes = this.data.crrm.ct_nodes ? this.data.crrm.ct_nodes : this.data.crrm.cp_nodes;\n\t\t\t\tif(!this.data.crrm.ct_nodes && !this.data.crrm.cp_nodes) { return false; }\n\t\t\t\tif(this.data.crrm.ct_nodes) { this.move_node(this.data.crrm.ct_nodes, obj); this.data.crrm.ct_nodes = false; }\n\t\t\t\tif(this.data.crrm.cp_nodes) { this.move_node(this.data.crrm.cp_nodes, obj, false, true); }\n\t\t\t\tthis.__callback({ \"obj\" : obj, \"nodes\" : nodes });\n\t\t\t}\n\t\t}\n\t});\n\t// include the crr plugin by default\n\t// $.jstree.defaults.plugins.push(\"crrm\");\n})(jQuery);\n//*/\n\n/*\n * jsTree themes plugin\n * Handles loading and setting themes, as well as detecting path to themes, etc.\n */\n(function ($) {\n\tvar themes_loaded = [];\n\t// this variable stores the path to the themes folder - if left as false - it will be autodetected\n\t$.jstree._themes = false;\n\t$.jstree.plugin(\"themes\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function () {\n\t\t\t\t\t\tvar s = this._get_settings().themes;\n\t\t\t\t\t\tthis.data.themes.dots = s.dots;\n\t\t\t\t\t\tthis.data.themes.icons = s.icons;\n\t\t\t\t\t\tthis.set_theme(s.theme, s.url);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree\", $.proxy(function () {\n\t\t\t\t\t\t// bound here too, as simple HTML tree's won't honor dots & icons otherwise\n\t\t\t\t\t\tif(!this.data.themes.dots) { this.hide_dots(); }\n\t\t\t\t\t\telse { this.show_dots(); }\n\t\t\t\t\t\tif(!this.data.themes.icons) { this.hide_icons(); }\n\t\t\t\t\t\telse { this.show_icons(); }\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\ttheme : \"default\",\n\t\t\turl : false,\n\t\t\tdots : false,\n\t\t\ticons : true\n\t\t},\n\t\t_fn : {\n\t\t\tset_theme : function (theme_name, theme_url) {\n\t\t\t\tif(!theme_name) { return false; }\n\t\t\t\tif(!theme_url) { theme_url = $.jstree._themes + theme_name + '/style.css'; }\n\t\t\t\tif($.inArray(theme_url, themes_loaded) == -1) {\n\t\t\t\t\t// $.vakata.css.add_sheet({ \"url\" : theme_url });\n\t\t\t\t\tthemes_loaded.push(theme_url);\n\t\t\t\t}\n\t\t\t\tif(this.data.themes.theme != theme_name) {\n\t\t\t\t\tthis.get_container().removeClass('jstree-' + this.data.themes.theme);\n\t\t\t\t\tthis.data.themes.theme = theme_name;\n\t\t\t\t}\n\t\t\t\tthis.get_container().addClass('jstree-' + theme_name);\n\t\t\t\tif(!this.data.themes.dots) { this.hide_dots(); }\n\t\t\t\telse { this.show_dots(); }\n\t\t\t\tif(!this.data.themes.icons) { this.hide_icons(); }\n\t\t\t\telse { this.show_icons(); }\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tget_theme\t: function () { return this.data.themes.theme; },\n\n\t\t\tshow_dots\t: function () { this.data.themes.dots = true; this.get_container().children(\"ul\").removeClass(\"jstree-no-dots\"); },\n\t\t\thide_dots\t: function () { this.data.themes.dots = false; this.get_container().children(\"ul\").addClass(\"jstree-no-dots\"); },\n\t\t\ttoggle_dots\t: function () { if(this.data.themes.dots) { this.hide_dots(); } else { this.show_dots(); } },\n\n\t\t\tshow_icons\t: function () { this.data.themes.icons = true; this.get_container().children(\"ul\").removeClass(\"jstree-no-icons\"); },\n\t\t\thide_icons\t: function () { this.data.themes.icons = false; this.get_container().children(\"ul\").addClass(\"jstree-no-icons\"); },\n\t\t\ttoggle_icons: function () { if(this.data.themes.icons) { this.hide_icons(); } else { this.show_icons(); } }\n\t\t}\n\t});\n\t// autodetect themes path\n\t$(function () {\n\t\tif($.jstree._themes === false) {\n\t\t\t$(\"script\").each(function () {\n\t\t\t\tif(this.src.toString().match(/jquery\\.jstree[^\\/]*?\\.js(\\?.*)?$/)) {\n\t\t\t\t\t$.jstree._themes = this.src.toString().replace(/jquery\\.jstree[^\\/]*?\\.js(\\?.*)?$/, \"\") + 'themes/';\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t\tif($.jstree._themes === false) { $.jstree._themes = \"themes/\"; }\n\t});\n\t// include the themes plugin by default\n\t$.jstree.defaults.plugins.push(\"themes\");\n})(jQuery);\n//*/\n\n/*\n * jsTree hotkeys plugin\n * Enables keyboard navigation for all tree instances\n * Depends on the jstree ui & jquery hotkeys plugins\n */\n(function ($) {\n\tvar bound = [];\n\tfunction exec(i, event) {\n\t\tvar f = $.jstree._focused(), tmp;\n\t\tif(f && f.data && f.data.hotkeys && f.data.hotkeys.enabled) {\n\t\t\ttmp = f._get_settings().hotkeys[i];\n\t\t\tif(tmp) { return tmp.call(f, event); }\n\t\t}\n\t}\n\t$.jstree.plugin(\"hotkeys\", {\n\t\t__init : function () {\n\t\t\tif(typeof $.hotkeys === \"undefined\") { throw \"jsTree hotkeys: jQuery hotkeys plugin not included.\"; }\n\t\t\tif(!this.data.ui) { throw \"jsTree hotkeys: jsTree UI plugin not included.\"; }\n\t\t\t$.each(this._get_settings().hotkeys, function (i, v) {\n\t\t\t\tif(v !== false && $.inArray(i, bound) == -1) {\n\t\t\t\t\t$(document).bind(\"keydown\", i, function (event) { return exec(i, event); });\n\t\t\t\t\tbound.push(i);\n\t\t\t\t}\n\t\t\t});\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"lock.jstree\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.hotkeys.enabled) { this.data.hotkeys.enabled = false; this.data.hotkeys.revert = true; }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"unlock.jstree\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.hotkeys.revert) { this.data.hotkeys.enabled = true; }\n\t\t\t\t\t}, this));\n\t\t\tthis.enable_hotkeys();\n\t\t},\n\t\tdefaults : {\n\t\t\t\"up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"space\" : function () {\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").click(); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+space\" : function (event) {\n\t\t\t\tevent.type = \"click\";\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").trigger(event); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+space\" : function (event) {\n\t\t\t\tevent.type = \"click\";\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").trigger(event); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"f2\" : function () { this.rename(this.data.ui.hovered || this.data.ui.last_selected); },\n\t\t\t\"del\" : function () { this.remove(this.data.ui.hovered || this._get_node(null)); }\n\t\t},\n\t\t_fn : {\n\t\t\tenable_hotkeys : function () {\n\t\t\t\tthis.data.hotkeys.enabled = true;\n\t\t\t},\n\t\t\tdisable_hotkeys : function () {\n\t\t\t\tthis.data.hotkeys.enabled = false;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree JSON plugin\n * The JSON data store. Datastores are build by overriding the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.jstree.plugin(\"json_data\", {\n\t\t__init : function() {\n\t\t\tvar s = this._get_settings().json_data;\n\t\t\tif(s.progressive_unload) {\n\t\t\t\tthis.get_container().bind(\"after_close.jstree\", function (e, data) {\n\t\t\t\t\tdata.rslt.obj.children(\"ul\").remove();\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t// `data` can be a function:\n\t\t\t//  * accepts two arguments - node being loaded and a callback to pass the result to\n\t\t\t//  * will be executed in the current tree's scope & ajax won't be supported\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\tcorrect_state : true,\n\t\t\tprogressive_render : false,\n\t\t\tprogressive_unload : false\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_json(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tvar s = this._get_settings().json_data;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!s.ajax && !s.progressive_render && !$.isFunction(s.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").length > 0;\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = this._get_settings().json_data;\n\t\t\t\tif(obj && obj !== -1 && s.progressive_unload && ($.isFunction(s.data) || !!s.ajax)) {\n\t\t\t\t\tobj.removeData(\"jstree_children\");\n\t\t\t\t}\n\t\t\t\treturn this.__call_old();\n\t\t\t},\n\t\t\tload_node_json : function (obj, s_call, e_call) {\n\t\t\t\tvar s = this.get_settings().json_data, d,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\t\t\t\tobj = this._get_node(obj);\n\n\t\t\t\tif(obj && obj !== -1 && (s.progressive_render || s.progressive_unload) && !obj.is(\".jstree-open, .jstree-leaf\") && obj.children(\"ul\").children(\"li\").length === 0 && obj.data(\"jstree_children\")) {\n\t\t\t\t\td = this._parse_json(obj.data(\"jstree_children\"), obj);\n\t\t\t\t\tif(d) {\n\t\t\t\t\t\tobj.append(d);\n\t\t\t\t\t\tif(!s.progressive_unload) { obj.removeData(\"jstree_children\"); }\n\t\t\t\t\t}\n\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase (!s.data && !s.ajax): throw \"Neither data nor ajax settings supplied.\";\n\t\t\t\t\t// function option added here for easier model integration (also supporting async - see callback)\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\td = this._parse_json(d, obj);\n\t\t\t\t\t\t\tif(!d) {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\telse { obj.append(d).children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\td = this._parse_json(s.data, obj);\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty().append(d.children());\n\t\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().json_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj != -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\tvar sf = this.get_settings().json_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\") || (!$.isArray(d) && !$.isPlainObject(d))) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\td = this._parse_json(d, obj);\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\telse { obj.append(d).children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"json\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\t_parse_json : function (js, obj, is_callback) {\n\t\t\t\tvar d = false,\n\t\t\t\t\tp = this._get_settings(),\n\t\t\t\t\ts = p.json_data,\n\t\t\t\t\tt = p.core.html_titles,\n\t\t\t\t\ttmp, i, j, ul1, ul2;\n\n\t\t\t\tif(!js) { return d; }\n\t\t\t\tif(s.progressive_unload && obj && obj !== -1) {\n\t\t\t\t\tobj.data(\"jstree_children\", d);\n\t\t\t\t}\n\t\t\t\tif($.isArray(js)) {\n\t\t\t\t\td = $();\n\t\t\t\t\tif(!js.length) { return false; }\n\t\t\t\t\tfor(i = 0, j = js.length; i < j; i++) {\n\t\t\t\t\t\ttmp = this._parse_json(js[i], obj, true);\n\t\t\t\t\t\tif(tmp.length) { d = d.add(tmp); }\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(typeof js == \"string\") { js = { data : js }; }\n\t\t\t\t\tif(!js.data && js.data !== \"\") { return d; }\n\t\t\t\t\td = $(\"<li />\");\n\t\t\t\t\tif(js.attr) { d.attr(js.attr); }\n\t\t\t\t\tif(js.metadata) { d.data(js.metadata); }\n\t\t\t\t\tif(js.state) { d.addClass(\"jstree-\" + js.state); }\n\t\t\t\t\tif(!$.isArray(js.data)) { tmp = js.data; js.data = []; js.data.push(tmp); }\n\t\t\t\t\t$.each(js.data, function (i, m) {\n\t\t\t\t\t\ttmp = $(\"<a />\");\n\t\t\t\t\t\tif($.isFunction(m)) { m = m.call(this, js); }\n\t\t\t\t\t\tif(typeof m == \"string\") { tmp.attr('href','#')[ t ? \"html\" : \"text\" ](m); }\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(!m.attr) { m.attr = {}; }\n\t\t\t\t\t\t\tif(!m.attr.href) { m.attr.href = '#'; }\n\t\t\t\t\t\t\ttmp.attr(m.attr)[ t ? \"html\" : \"text\" ](m.title);\n\t\t\t\t\t\t\tif(m.language) { tmp.addClass(m.language); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\ttmp.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\t\tif(!m.icon && js.icon) { m.icon = js.icon; }\n\t\t\t\t\t\tif(m.icon) {\n\t\t\t\t\t\t\tif(m.icon.indexOf(\"/\") === -1) { tmp.children(\"ins\").addClass(m.icon); }\n\t\t\t\t\t\t\telse { tmp.children(\"ins\").css(\"background\",\"url('\" + m.icon + \"') center center no-repeat\"); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\td.append(tmp);\n\t\t\t\t\t});\n\t\t\t\t\td.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\tif(js.children) {\n\t\t\t\t\t\tif(s.progressive_render && js.state !== \"open\") {\n\t\t\t\t\t\t\td.addClass(\"jstree-closed\").data(\"jstree_children\", js.children);\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(s.progressive_unload) { d.data(\"jstree_children\", js.children); }\n\t\t\t\t\t\t\tif($.isArray(js.children) && js.children.length) {\n\t\t\t\t\t\t\t\ttmp = this._parse_json(js.children, obj, true);\n\t\t\t\t\t\t\t\tif(tmp.length) {\n\t\t\t\t\t\t\t\t\tul2 = $(\"<ul />\");\n\t\t\t\t\t\t\t\t\tul2.append(tmp);\n\t\t\t\t\t\t\t\t\td.append(ul2);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tul1 = $(\"<ul />\");\n\t\t\t\t\tul1.append(d);\n\t\t\t\t\td = ul1;\n\t\t\t\t}\n\t\t\t\treturn d;\n\t\t\t},\n\t\t\tget_json : function (obj, li_attr, a_attr, is_callback) {\n\t\t\t\tvar result = [],\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this,\n\t\t\t\t\ttmp1, tmp2, li, a, t, lang;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container().find(\"> ul > li\"); }\n\t\t\t\tli_attr = $.isArray(li_attr) ? li_attr : [ \"id\", \"class\" ];\n\t\t\t\tif(!is_callback && this.data.types) { li_attr.push(s.types.type_attr); }\n\t\t\t\ta_attr = $.isArray(a_attr) ? a_attr : [ ];\n\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tli = $(this);\n\t\t\t\t\ttmp1 = { data : [] };\n\t\t\t\t\tif(li_attr.length) { tmp1.attr = { }; }\n\t\t\t\t\t$.each(li_attr, function (i, v) {\n\t\t\t\t\t\ttmp2 = li.attr(v);\n\t\t\t\t\t\tif(tmp2 && tmp2.length && tmp2.replace(/jstree[^ ]*/ig,'').length) {\n\t\t\t\t\t\t\ttmp1.attr[v] = (\" \" + tmp2).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tif(li.hasClass(\"jstree-open\")) { tmp1.state = \"open\"; }\n\t\t\t\t\tif(li.hasClass(\"jstree-closed\")) { tmp1.state = \"closed\"; }\n\t\t\t\t\tif(li.data()) { tmp1.metadata = li.data(); }\n\t\t\t\t\ta = li.children(\"a\");\n\t\t\t\t\ta.each(function () {\n\t\t\t\t\t\tt = $(this);\n\t\t\t\t\t\tif(\n\t\t\t\t\t\t\ta_attr.length ||\n\t\t\t\t\t\t\t$.inArray(\"languages\", s.plugins) !== -1 ||\n\t\t\t\t\t\t\tt.children(\"ins\").get(0).style.backgroundImage.length ||\n\t\t\t\t\t\t\t(t.children(\"ins\").get(0).className && t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').length)\n\t\t\t\t\t\t) {\n\t\t\t\t\t\t\tlang = false;\n\t\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1 && $.isArray(s.languages) && s.languages.length) {\n\t\t\t\t\t\t\t\t$.each(s.languages, function (l, lv) {\n\t\t\t\t\t\t\t\t\tif(t.hasClass(lv)) {\n\t\t\t\t\t\t\t\t\t\tlang = lv;\n\t\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\ttmp2 = { attr : { }, title : _this.get_text(t, lang) };\n\t\t\t\t\t\t\t$.each(a_attr, function (k, z) {\n\t\t\t\t\t\t\t\ttmp2.attr[z] = (\" \" + (t.attr(z) || \"\")).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1 && $.isArray(s.languages) && s.languages.length) {\n\t\t\t\t\t\t\t\t$.each(s.languages, function (k, z) {\n\t\t\t\t\t\t\t\t\tif(t.hasClass(z)) { tmp2.language = z; return true; }\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/^\\s+$/ig,\"\").length) {\n\t\t\t\t\t\t\t\ttmp2.icon = t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(t.children(\"ins\").get(0).style.backgroundImage.length) {\n\t\t\t\t\t\t\t\ttmp2.icon = t.children(\"ins\").get(0).style.backgroundImage.replace(\"url(\",\"\").replace(\")\",\"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\ttmp2 = _this.get_text(t);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(a.length > 1) { tmp1.data.push(tmp2); }\n\t\t\t\t\t\telse { tmp1.data = tmp2; }\n\t\t\t\t\t});\n\t\t\t\t\tli = li.find(\"> ul > li\");\n\t\t\t\t\tif(li.length) { tmp1.children = _this.get_json(li, li_attr, a_attr, true); }\n\t\t\t\t\tresult.push(tmp1);\n\t\t\t\t});\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree languages plugin\n * Adds support for multiple language versions in one tree\n * This basically allows for many titles coexisting in one node, but only one of them being visible at any given time\n * This is useful for maintaining the same structure in many languages (hence the name of the plugin)\n */\n(function ($) {\n\t$.jstree.plugin(\"languages\", {\n\t\t__init : function () { this._load_css();  },\n\t\tdefaults : [],\n\t\t_fn : {\n\t\t\tset_lang : function (i) {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\tst = false,\n\t\t\t\t\tselector = \".jstree-\" + this.get_index() + ' a';\n\t\t\t\tif(!$.isArray(langs) || langs.length === 0) { return false; }\n\t\t\t\tif($.inArray(i,langs) == -1) {\n\t\t\t\t\tif(!!langs[i]) { i = langs[i]; }\n\t\t\t\t\telse { return false; }\n\t\t\t\t}\n\t\t\t\tif(i == this.data.languages.current_language) { return true; }\n\t\t\t\tst = $.vakata.css.get_css(selector + \".\" + this.data.languages.current_language, false, this.data.languages.language_css);\n\t\t\t\tif(st !== false) { st.style.display = \"none\"; }\n\t\t\t\tst = $.vakata.css.get_css(selector + \".\" + i, false, this.data.languages.language_css);\n\t\t\t\tif(st !== false) { st.style.display = \"\"; }\n\t\t\t\tthis.data.languages.current_language = i;\n\t\t\t\tthis.__callback(i);\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tget_lang : function () {\n\t\t\t\treturn this.data.languages.current_language;\n\t\t\t},\n\t\t\t_get_string : function (key, lang) {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.strings;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t}\n\t\t\t\tif(s[lang] && s[lang][key]) { return s[lang][key]; }\n\t\t\t\tif(s[key]) { return s[key]; }\n\t\t\t\treturn key;\n\t\t\t},\n\t\t\tget_text : function (obj, lang) {\n\t\t\t\tobj = this._get_node(obj) || this.data.ui.last_selected;\n\t\t\t\tif(!obj.size()) { return false; }\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.html_titles;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t\tobj = obj.children(\"a.\" + lang);\n\t\t\t\t}\n\t\t\t\telse { obj = obj.children(\"a:eq(0)\"); }\n\t\t\t\tif(s) {\n\t\t\t\t\tobj = obj.clone();\n\t\t\t\t\tobj.children(\"INS\").remove();\n\t\t\t\t\treturn obj.html();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\treturn obj.nodeValue;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset_text : function (obj, val, lang) {\n\t\t\t\tobj = this._get_node(obj) || this.data.ui.last_selected;\n\t\t\t\tif(!obj.size()) { return false; }\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.html_titles,\n\t\t\t\t\ttmp;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t\tobj = obj.children(\"a.\" + lang);\n\t\t\t\t}\n\t\t\t\telse { obj = obj.children(\"a:eq(0)\"); }\n\t\t\t\tif(s) {\n\t\t\t\t\ttmp = obj.children(\"INS\").clone();\n\t\t\t\t\tobj.html(val).prepend(tmp);\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val, \"lang\" : lang });\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val, \"lang\" : lang });\n\t\t\t\t\treturn (obj.nodeValue = val);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_load_css : function () {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\tstr = \"/* languages css */\",\n\t\t\t\t\tselector = \".jstree-\" + this.get_index() + ' a',\n\t\t\t\t\tln;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tthis.data.languages.current_language = langs[0];\n\t\t\t\t\tfor(ln = 0; ln < langs.length; ln++) {\n\t\t\t\t\t\tstr += selector + \".\" + langs[ln] + \" {\";\n\t\t\t\t\t\tif(langs[ln] != this.data.languages.current_language) { str += \" display:none; \"; }\n\t\t\t\t\t\tstr += \" } \";\n\t\t\t\t\t}\n\t\t\t\t\tthis.data.languages.language_css = $.vakata.css.add_sheet({ 'str' : str, 'title' : \"jstree-languages\" });\n\t\t\t\t}\n\t\t\t},\n\t\t\tcreate_node : function (obj, position, js, callback) {\n\t\t\t\tvar t = this.__call_old(true, obj, position, js, function (t) {\n\t\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\t\ta = t.children(\"a\"),\n\t\t\t\t\t\tln;\n\t\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\t\tfor(ln = 0; ln < langs.length; ln++) {\n\t\t\t\t\t\t\tif(!a.is(\".\" + langs[ln])) {\n\t\t\t\t\t\t\t\tt.append(a.eq(0).clone().removeClass(langs.join(\" \")).addClass(langs[ln]));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\ta.not(\".\" + langs.join(\", .\")).remove();\n\t\t\t\t\t}\n\t\t\t\t\tif(callback) { callback.call(this, t); }\n\t\t\t\t});\n\t\t\t\treturn t;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree cookies plugin\n * Stores the currently opened/selected nodes in a cookie and then restores them\n * Depends on the jquery.cookie plugin\n */\n(function ($) {\n\t$.jstree.plugin(\"cookies\", {\n\t\t__init : function () {\n\t\t\tif(typeof $.cookie === \"undefined\") { throw \"jsTree cookie: jQuery cookie plugin not included.\"; }\n\n\t\t\tvar s = this._get_settings().cookies,\n\t\t\t\ttmp;\n\t\t\tif(!!s.save_loaded) {\n\t\t\t\ttmp = $.cookie(s.save_loaded);\n\t\t\t\tif(tmp && tmp.length) { this.data.core.to_load = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tif(!!s.save_opened) {\n\t\t\t\ttmp = $.cookie(s.save_opened);\n\t\t\t\tif(tmp && tmp.length) { this.data.core.to_open = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tif(!!s.save_selected) {\n\t\t\t\ttmp = $.cookie(s.save_selected);\n\t\t\t\tif(tmp && tmp.length && this.data.ui) { this.data.ui.to_select = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tthis.get_container()\n\t\t\t\t.one( ( this.data.ui ? \"reselect\" : \"reopen\" ) + \".jstree\", $.proxy(function () {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"open_node.jstree close_node.jstree select_node.jstree deselect_node.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\t\t\tif(this._get_settings().cookies.auto_save) { this.save_cookie((e.handleObj.namespace + e.handleObj.type).replace(\"jstree\",\"\")); }\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tsave_loaded\t\t: \"jstree_load\",\n\t\t\tsave_opened\t\t: \"jstree_open\",\n\t\t\tsave_selected\t: \"jstree_select\",\n\t\t\tauto_save\t\t: true,\n\t\t\tcookie_options\t: {}\n\t\t},\n\t\t_fn : {\n\t\t\tsave_cookie : function (c) {\n\t\t\t\tif(this.data.core.refreshing) { return; }\n\t\t\t\tvar s = this._get_settings().cookies;\n\t\t\t\tif(!c) { // if called manually and not by event\n\t\t\t\t\tif(s.save_loaded) {\n\t\t\t\t\t\tthis.save_loaded();\n\t\t\t\t\t\t$.cookie(s.save_loaded, this.data.core.to_load.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\tif(s.save_opened) {\n\t\t\t\t\t\tthis.save_opened();\n\t\t\t\t\t\t$.cookie(s.save_opened, this.data.core.to_open.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\tif(s.save_selected && this.data.ui) {\n\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t$.cookie(s.save_selected, this.data.ui.to_select.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tswitch(c) {\n\t\t\t\t\tcase \"open_node\":\n\t\t\t\t\tcase \"close_node\":\n\t\t\t\t\t\tif(!!s.save_opened) {\n\t\t\t\t\t\t\tthis.save_opened();\n\t\t\t\t\t\t\t$.cookie(s.save_opened, this.data.core.to_open.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!!s.save_loaded) {\n\t\t\t\t\t\t\tthis.save_loaded();\n\t\t\t\t\t\t\t$.cookie(s.save_loaded, this.data.core.to_load.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"select_node\":\n\t\t\t\t\tcase \"deselect_node\":\n\t\t\t\t\t\tif(!!s.save_selected && this.data.ui) {\n\t\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t\t$.cookie(s.save_selected, this.data.ui.to_select.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t// include cookies by default\n\t// $.jstree.defaults.plugins.push(\"cookies\");\n})(jQuery);\n//*/\n\n/*\n * jsTree sort plugin\n * Sorts items alphabetically (or using any other function)\n */\n(function ($) {\n\t$.jstree.plugin(\"sort\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar obj = this._get_node(data.rslt.obj);\n\t\t\t\t\t\tobj = obj === -1 ? this.get_container().children(\"ul\") : obj.children(\"ul\");\n\t\t\t\t\t\tthis.sort(obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"rename_node.jstree create_node.jstree create.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.sort(data.rslt.obj.parent());\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar m = data.rslt.np == -1 ? this.get_container() : data.rslt.np;\n\t\t\t\t\t\tthis.sort(m.children(\"ul\"));\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : function (a, b) { return this.get_text(a) > this.get_text(b) ? 1 : -1; },\n\t\t_fn : {\n\t\t\tsort : function (obj) {\n\t\t\t\tvar s = this._get_settings().sort,\n\t\t\t\t\tt = this;\n\t\t\t\tobj.append($.makeArray(obj.children(\"li\")).sort($.proxy(s, t)));\n\t\t\t\tobj.find(\"> li > ul\").each(function() { t.sort($(this)); });\n\t\t\t\tthis.clean_node(obj);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree DND plugin\n * Drag and drop plugin for moving/copying nodes\n */\n(function ($) {\n\tvar o = false,\n\t\tr = false,\n\t\tm = false,\n\t\tml = false,\n\t\tsli = false,\n\t\tsti = false,\n\t\tdir1 = false,\n\t\tdir2 = false,\n\t\tlast_pos = false;\n\t$.vakata.dnd = {\n\t\tis_down : false,\n\t\tis_drag : false,\n\t\thelper : false,\n\t\tscroll_spd : 10,\n\t\tinit_x : 0,\n\t\tinit_y : 0,\n\t\tthreshold : 5,\n\t\thelper_left : 5,\n\t\thelper_top : 10,\n\t\tuser_data : {},\n\n\t\tdrag_start : function (e, data, html) {\n\t\t\tif($.vakata.dnd.is_drag) { $.vakata.drag_stop({}); }\n\t\t\ttry {\n\t\t\t\te.currentTarget.unselectable = \"on\";\n\t\t\t\te.currentTarget.onselectstart = function() { return false; };\n\t\t\t\tif(e.currentTarget.style) { e.currentTarget.style.MozUserSelect = \"none\"; }\n\t\t\t} catch(err) { }\n\t\t\t$.vakata.dnd.init_x = e.pageX;\n\t\t\t$.vakata.dnd.init_y = e.pageY;\n\t\t\t$.vakata.dnd.user_data = data;\n\t\t\t$.vakata.dnd.is_down = true;\n\t\t\t$.vakata.dnd.helper = $(\"<div id='vakata-dragged' />\").html(html); //.fadeTo(10,0.25);\n\t\t\t$(document).bind(\"mousemove\", $.vakata.dnd.drag);\n\t\t\t$(document).bind(\"mouseup\", $.vakata.dnd.drag_stop);\n\t\t\treturn false;\n\t\t},\n\t\tdrag : function (e) {\n\t\t\tif(!$.vakata.dnd.is_down) { return; }\n\t\t\tif(!$.vakata.dnd.is_drag) {\n\t\t\t\tif(Math.abs(e.pageX - $.vakata.dnd.init_x) > 5 || Math.abs(e.pageY - $.vakata.dnd.init_y) > 5) {\n\t\t\t\t\t$.vakata.dnd.helper.appendTo(\"body\");\n\t\t\t\t\t$.vakata.dnd.is_drag = true;\n\t\t\t\t\t$(document).triggerHandler(\"drag_start.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t\t\t}\n\t\t\t\telse { return; }\n\t\t\t}\n\n\t\t\t// maybe use a scrolling parent element instead of document?\n\t\t\tif(e.type === \"mousemove\") { // thought of adding scroll in order to move the helper, but mouse poisition is n/a\n\t\t\t\tvar d = $(document), t = d.scrollTop(), l = d.scrollLeft();\n\t\t\t\tif(e.pageY - t < 20) {\n\t\t\t\t\tif(sti && dir1 === \"down\") { clearInterval(sti); sti = false; }\n\t\t\t\t\tif(!sti) { dir1 = \"up\"; sti = setInterval(function () { $(document).scrollTop($(document).scrollTop() - $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sti && dir1 === \"up\") { clearInterval(sti); sti = false; }\n\t\t\t\t}\n\t\t\t\tif($(window).height() - (e.pageY - t) < 20) {\n\t\t\t\t\tif(sti && dir1 === \"up\") { clearInterval(sti); sti = false; }\n\t\t\t\t\tif(!sti) { dir1 = \"down\"; sti = setInterval(function () { $(document).scrollTop($(document).scrollTop() + $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sti && dir1 === \"down\") { clearInterval(sti); sti = false; }\n\t\t\t\t}\n\n\t\t\t\tif(e.pageX - l < 20) {\n\t\t\t\t\tif(sli && dir2 === \"right\") { clearInterval(sli); sli = false; }\n\t\t\t\t\tif(!sli) { dir2 = \"left\"; sli = setInterval(function () { $(document).scrollLeft($(document).scrollLeft() - $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sli && dir2 === \"left\") { clearInterval(sli); sli = false; }\n\t\t\t\t}\n\t\t\t\tif($(window).width() - (e.pageX - l) < 20) {\n\t\t\t\t\tif(sli && dir2 === \"left\") { clearInterval(sli); sli = false; }\n\t\t\t\t\tif(!sli) { dir2 = \"right\"; sli = setInterval(function () { $(document).scrollLeft($(document).scrollLeft() + $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sli && dir2 === \"right\") { clearInterval(sli); sli = false; }\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t$.vakata.dnd.helper.css({ left : (e.pageX + $.vakata.dnd.helper_left) + \"px\", top : (e.pageY + $.vakata.dnd.helper_top) + \"px\" });\n\t\t\t$(document).triggerHandler(\"drag.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t},\n\t\tdrag_stop : function (e) {\n\t\t\tif(sli) { clearInterval(sli); }\n\t\t\tif(sti) { clearInterval(sti); }\n\t\t\t$(document).unbind(\"mousemove\", $.vakata.dnd.drag);\n\t\t\t$(document).unbind(\"mouseup\", $.vakata.dnd.drag_stop);\n\t\t\t$(document).triggerHandler(\"drag_stop.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t\t$.vakata.dnd.helper.remove();\n\t\t\t$.vakata.dnd.init_x = 0;\n\t\t\t$.vakata.dnd.init_y = 0;\n\t\t\t$.vakata.dnd.user_data = {};\n\t\t\t$.vakata.dnd.is_down = false;\n\t\t\t$.vakata.dnd.is_drag = false;\n\t\t}\n\t};\n\t$(function() {\n\t\tvar css_string = '#vakata-dragged { display:block; margin:0 0 0 0; padding:4px 4px 4px 24px; position:absolute; top:-2000px; line-height:16px; z-index:10000; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"vakata\" });\n\t});\n\n\t$.jstree.plugin(\"dnd\", {\n\t\t__init : function () {\n\t\t\tthis.data.dnd = {\n\t\t\t\tactive : false,\n\t\t\t\tafter : false,\n\t\t\t\tinside : false,\n\t\t\t\tbefore : false,\n\t\t\t\toff : false,\n\t\t\t\tprepared : false,\n\t\t\t\tw : 0,\n\t\t\t\tto1 : false,\n\t\t\t\tto2 : false,\n\t\t\t\tcof : false,\n\t\t\t\tcw : false,\n\t\t\t\tch : false,\n\t\t\t\ti1 : false,\n\t\t\t\ti2 : false,\n\t\t\t\tmto : false\n\t\t\t};\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"mouseenter.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(this.data.themes) {\n\t\t\t\t\t\t\t\tm.attr(\"class\", \"jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t//if($(e.currentTarget).find(\"> ul > li\").length === 0) {\n\t\t\t\t\t\t\tif(e.currentTarget === e.target && $.vakata.dnd.user_data.obj && $($.vakata.dnd.user_data.obj).length && $($.vakata.dnd.user_data.obj).parents(\".jstree:eq(0)\")[0] !== e.target) { // node should not be from the same tree\n\t\t\t\t\t\t\t\tvar tr = $.jstree._reference(e.target), dc;\n\t\t\t\t\t\t\t\tif(tr.data.dnd.foreign) {\n\t\t\t\t\t\t\t\t\tdc = tr._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\t\tif(dc === true || dc.inside === true || dc.before === true || dc.after === true) {\n\t\t\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\ttr.prepare_move(o, tr.get_container(), \"last\");\n\t\t\t\t\t\t\t\t\tif(tr.check_move()) {\n\t\t\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mouseup.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\t//if($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && $(e.currentTarget).find(\"> ul > li\").length === 0) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && e.currentTarget === e.target && $.vakata.dnd.user_data.obj && $($.vakata.dnd.user_data.obj).length && $($.vakata.dnd.user_data.obj).parents(\".jstree:eq(0)\")[0] !== e.target) { // node should not be from the same tree\n\t\t\t\t\t\t\tvar tr = $.jstree._reference(e.currentTarget), dc;\n\t\t\t\t\t\t\tif(tr.data.dnd.foreign) {\n\t\t\t\t\t\t\t\tdc = tr._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\tif(dc === true || dc.inside === true || dc.before === true || dc.after === true) {\n\t\t\t\t\t\t\t\t\ttr._get_settings().dnd.drag_finish.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\ttr.move_node(o, tr.get_container(), \"last\", e[tr._get_settings().dnd.copy_modifier + \"Key\"]);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(e.relatedTarget && e.relatedTarget.id && e.relatedTarget.id === \"jstree-marker-line\") {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\t\t\tif($.vakata.dnd.helper.children(\"ins\").hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mousemove.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tvar cnt = this.get_container()[0];\n\n\t\t\t\t\t\t\t// Horizontal scroll\n\t\t\t\t\t\t\tif(e.pageX + 24 > this.data.dnd.cof.left + this.data.dnd.cw) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i1 = setInterval($.proxy(function () { this.scrollLeft += $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse if(e.pageX - 24 < this.data.dnd.cof.left) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i1 = setInterval($.proxy(function () { this.scrollLeft -= $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Vertical scroll\n\t\t\t\t\t\t\tif(e.pageY + 24 > this.data.dnd.cof.top + this.data.dnd.ch) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i2 = setInterval($.proxy(function () { this.scrollTop += $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse if(e.pageY - 24 < this.data.dnd.cof.top) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i2 = setInterval($.proxy(function () { this.scrollTop -= $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"scroll.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && m && ml) {\n\t\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\t\tml.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mousedown.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(e.which === 1) {\n\t\t\t\t\t\t\tthis.start_drag(e.currentTarget, e);\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseenter.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tthis.dnd_enter(e.currentTarget);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mousemove.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(!r || !r.length || r.children(\"a\")[0] !== e.currentTarget) {\n\t\t\t\t\t\t\t\tthis.dnd_enter(e.currentTarget);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(typeof this.data.dnd.off.top === \"undefined\") { this.data.dnd.off = $(e.target).offset(); }\n\t\t\t\t\t\t\tthis.data.dnd.w = (e.pageY - (this.data.dnd.off.top || 0)) % this.data.core.li_height;\n\t\t\t\t\t\t\tif(this.data.dnd.w < 0) { this.data.dnd.w += this.data.core.li_height; }\n\t\t\t\t\t\t\tthis.dnd_show();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(e.relatedTarget && e.relatedTarget.id && e.relatedTarget.id === \"jstree-marker-line\") {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(m) { m.hide(); }\n\t\t\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\t\t/*\n\t\t\t\t\t\t\tvar ec = $(e.currentTarget).closest(\"li\"),\n\t\t\t\t\t\t\t\ter = $(e.relatedTarget).closest(\"li\");\n\t\t\t\t\t\t\tif(er[0] !== ec.prev()[0] && er[0] !== ec.next()[0]) {\n\t\t\t\t\t\t\t\tif(m) { m.hide(); }\n\t\t\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t*/\n\t\t\t\t\t\t\tthis.data.dnd.mto = setTimeout(\n\t\t\t\t\t\t\t\t(function (t) { return function () { t.dnd_leave(e); }; })(this),\n\t\t\t\t\t\t\t0);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseup.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tthis.dnd_finish(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\n\t\t\t$(document)\n\t\t\t\t.bind(\"drag_stop.vakata\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\tthis.data.dnd.after\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.before\t= false;\n\t\t\t\t\t\tthis.data.dnd.inside\t= false;\n\t\t\t\t\t\tthis.data.dnd.off\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.prepared\t= false;\n\t\t\t\t\t\tthis.data.dnd.w\t\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.to1\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.to2\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.i1\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.i2\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.active\t= false;\n\t\t\t\t\t\tthis.data.dnd.foreign\t= false;\n\t\t\t\t\t\tif(m) { m.css({ \"top\" : \"-2000px\" }); }\n\t\t\t\t\t\tif(ml) { ml.css({ \"top\" : \"-2000px\" }); }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"drag_start.vakata\", $.proxy(function (e, data) {\n\t\t\t\t\t\tif(data.data.jstree) {\n\t\t\t\t\t\t\tvar et = $(data.event.target);\n\t\t\t\t\t\t\tif(et.closest(\".jstree\").hasClass(\"jstree-\" + this.get_index())) {\n\t\t\t\t\t\t\t\tthis.dnd_enter(et);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\t\t/*\n\t\t\t\t.bind(\"keydown.jstree-\" + this.get_index() + \" keyup.jstree-\" + this.get_index(), $.proxy(function(e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && !this.data.dnd.foreign) {\n\t\t\t\t\t\t\tvar h = $.vakata.dnd.helper.children(\"ins\");\n\t\t\t\t\t\t\tif(e[this._get_settings().dnd.copy_modifier + \"Key\"] && h.hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\th.parent().html(h.parent().html().replace(/ \\(Copy\\)$/, \"\") + \" (Copy)\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\th.parent().html(h.parent().html().replace(/ \\(Copy\\)$/, \"\"));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this)); */\n\n\n\n\t\t\tvar s = this._get_settings().dnd;\n\t\t\tif(s.drag_target) {\n\t\t\t\t$(document)\n\t\t\t\t\t.delegate(s.drag_target, \"mousedown.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\to = e.target;\n\t\t\t\t\t\t$.vakata.dnd.drag_start(e, { jstree : true, obj : e.target }, \"<ins class='jstree-icon'></ins>\" + $(e.target).text() );\n\t\t\t\t\t\tif(this.data.themes) {\n\t\t\t\t\t\t\tif(m) { m.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t}\n\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\tvar cnt = this.get_container();\n\t\t\t\t\t\tthis.data.dnd.cof = cnt.offset();\n\t\t\t\t\t\tthis.data.dnd.cw = parseInt(cnt.width(),10);\n\t\t\t\t\t\tthis.data.dnd.ch = parseInt(cnt.height(),10);\n\t\t\t\t\t\tthis.data.dnd.foreign = true;\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}, this));\n\t\t\t}\n\t\t\tif(s.drop_target) {\n\t\t\t\t$(document)\n\t\t\t\t\t.delegate(s.drop_target, \"mouseenter.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active && this._get_settings().dnd.drop_check.call(this, { \"o\" : o, \"r\" : $(e.target), \"e\" : e })) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.delegate(s.drop_target, \"mouseleave.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.delegate(s.drop_target, \"mouseup.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active && $.vakata.dnd.helper.children(\"ins\").hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\tthis._get_settings().dnd.drop_finish.call(this, { \"o\" : o, \"r\" : $(e.target), \"e\" : e });\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\tcopy_modifier\t: \"ctrl\",\n\t\t\tcheck_timeout\t: 100,\n\t\t\topen_timeout\t: 500,\n\t\t\tdrop_target\t\t: \".jstree-drop\",\n\t\t\tdrop_check\t\t: function (data) { return true; },\n\t\t\tdrop_finish\t\t: $.noop,\n\t\t\tdrag_target\t\t: \".jstree-draggable\",\n\t\t\tdrag_finish\t\t: $.noop,\n\t\t\tdrag_check\t\t: function (data) { return { after : false, before : false, inside : true }; }\n\t\t},\n\t\t_fn : {\n\t\t\tdnd_prepare : function () {\n\t\t\t\tif(!r || !r.length) { return; }\n\t\t\t\tthis.data.dnd.off = r.offset();\n\t\t\t\tif(this._get_settings().core.rtl) {\n\t\t\t\t\tthis.data.dnd.off.right = this.data.dnd.off.left + r.width();\n\t\t\t\t}\n\t\t\t\tif(this.data.dnd.foreign) {\n\t\t\t\t\tvar a = this._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : r });\n\t\t\t\t\tthis.data.dnd.after = a.after;\n\t\t\t\t\tthis.data.dnd.before = a.before;\n\t\t\t\t\tthis.data.dnd.inside = a.inside;\n\t\t\t\t\tthis.data.dnd.prepared = true;\n\t\t\t\t\treturn this.dnd_show();\n\t\t\t\t}\n\t\t\t\tthis.prepare_move(o, r, \"before\");\n\t\t\t\tthis.data.dnd.before = this.check_move();\n\t\t\t\tthis.prepare_move(o, r, \"after\");\n\t\t\t\tthis.data.dnd.after = this.check_move();\n\t\t\t\tif(this._is_loaded(r)) {\n\t\t\t\t\tthis.prepare_move(o, r, \"inside\");\n\t\t\t\t\tthis.data.dnd.inside = this.check_move();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.data.dnd.inside = false;\n\t\t\t\t}\n\t\t\t\tthis.data.dnd.prepared = true;\n\t\t\t\treturn this.dnd_show();\n\t\t\t},\n\t\t\tdnd_show : function () {\n\t\t\t\tif(!this.data.dnd.prepared) { return; }\n\t\t\t\tvar o = [\"before\",\"inside\",\"after\"],\n\t\t\t\t\tr = false,\n\t\t\t\t\trtl = this._get_settings().core.rtl,\n\t\t\t\t\tpos;\n\t\t\t\tif(this.data.dnd.w < this.data.core.li_height/3) { o = [\"before\",\"inside\",\"after\"]; }\n\t\t\t\telse if(this.data.dnd.w <= this.data.core.li_height*2/3) {\n\t\t\t\t\to = this.data.dnd.w < this.data.core.li_height/2 ? [\"inside\",\"before\",\"after\"] : [\"inside\",\"after\",\"before\"];\n\t\t\t\t}\n\t\t\t\telse { o = [\"after\",\"inside\",\"before\"]; }\n\t\t\t\t$.each(o, $.proxy(function (i, val) {\n\t\t\t\t\tif(this.data.dnd[val]) {\n\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\tr = val;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}, this));\n\t\t\t\tif(r === false) { $.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\"); }\n\n\t\t\t\tpos = rtl ? (this.data.dnd.off.right - 18) : (this.data.dnd.off.left + 10);\n\t\t\t\tswitch(r) {\n\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + \"px\", \"top\" : (this.data.dnd.off.top - 6) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.css({ \"left\" : (pos + 8) + \"px\", \"top\" : (this.data.dnd.off.top - 1) + \"px\" }).show(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height - 6) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.css({ \"left\" : (pos + 8) + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height - 1) + \"px\" }).show(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + ( rtl ? -4 : 4) + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height/2 - 5) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tlast_pos = r;\n\t\t\t\treturn r;\n\t\t\t},\n\t\t\tdnd_open : function () {\n\t\t\t\tthis.data.dnd.to2 = false;\n\t\t\t\tthis.open_node(r, $.proxy(this.dnd_prepare,this), true);\n\t\t\t},\n\t\t\tdnd_finish : function (e) {\n\t\t\t\tif(this.data.dnd.foreign) {\n\t\t\t\t\tif(this.data.dnd.after || this.data.dnd.before || this.data.dnd.inside) {\n\t\t\t\t\t\tthis._get_settings().dnd.drag_finish.call(this, { \"o\" : o, \"r\" : r, \"p\" : last_pos });\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.dnd_prepare();\n\t\t\t\t\tthis.move_node(o, r, last_pos, e[this._get_settings().dnd.copy_modifier + \"Key\"]);\n\t\t\t\t}\n\t\t\t\to = false;\n\t\t\t\tr = false;\n\t\t\t\tm.hide();\n\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t},\n\t\t\tdnd_enter : function (obj) {\n\t\t\t\tif(this.data.dnd.mto) {\n\t\t\t\t\tclearTimeout(this.data.dnd.mto);\n\t\t\t\t\tthis.data.dnd.mto = false;\n\t\t\t\t}\n\t\t\t\tvar s = this._get_settings().dnd;\n\t\t\t\tthis.data.dnd.prepared = false;\n\t\t\t\tr = this._get_node(obj);\n\t\t\t\tif(s.check_timeout) {\n\t\t\t\t\t// do the calculations after a minimal timeout (users tend to drag quickly to the desired location)\n\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\tthis.data.dnd.to1 = setTimeout($.proxy(this.dnd_prepare, this), s.check_timeout);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.dnd_prepare();\n\t\t\t\t}\n\t\t\t\tif(s.open_timeout) {\n\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\tif(r && r.length && r.hasClass(\"jstree-closed\")) {\n\t\t\t\t\t\t// if the node is closed - open it, then recalculate\n\t\t\t\t\t\tthis.data.dnd.to2 = setTimeout($.proxy(this.dnd_open, this), s.open_timeout);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(r && r.length && r.hasClass(\"jstree-closed\")) {\n\t\t\t\t\t\tthis.dnd_open();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tdnd_leave : function (e) {\n\t\t\t\tthis.data.dnd.after\t\t= false;\n\t\t\t\tthis.data.dnd.before\t= false;\n\t\t\t\tthis.data.dnd.inside\t= false;\n\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\tm.hide();\n\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\tif(r && r[0] === e.target.parentNode) {\n\t\t\t\t\tif(this.data.dnd.to1) {\n\t\t\t\t\t\tclearTimeout(this.data.dnd.to1);\n\t\t\t\t\t\tthis.data.dnd.to1 = false;\n\t\t\t\t\t}\n\t\t\t\t\tif(this.data.dnd.to2) {\n\t\t\t\t\t\tclearTimeout(this.data.dnd.to2);\n\t\t\t\t\t\tthis.data.dnd.to2 = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tstart_drag : function (obj, e) {\n\t\t\t\to = this._get_node(obj);\n\t\t\t\tif(this.data.ui && this.is_selected(o)) { o = this._get_node(null, true); }\n\t\t\t\tvar dt = o.length > 1 ? this._get_string(\"multiple_selection\") : this.get_text(o),\n\t\t\t\t\tcnt = this.get_container();\n\t\t\t\tif(!this._get_settings().core.html_titles) { dt = dt.replace(/</ig,\"&lt;\").replace(/>/ig,\"&gt;\"); }\n\t\t\t\t$.vakata.dnd.drag_start(e, { jstree : true, obj : o }, \"<ins class='jstree-icon'></ins>\" + dt );\n\t\t\t\tif(this.data.themes) {\n\t\t\t\t\tif(m) { m.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t}\n\t\t\t\tthis.data.dnd.cof = cnt.offset();\n\t\t\t\tthis.data.dnd.cw = parseInt(cnt.width(),10);\n\t\t\t\tthis.data.dnd.ch = parseInt(cnt.height(),10);\n\t\t\t\tthis.data.dnd.active = true;\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'#vakata-dragged ins { display:block; text-decoration:none; width:16px; height:16px; margin:0 0 0 0; padding:0; position:absolute; top:4px; left:4px; ' +\n\t\t\t' -moz-border-radius:4px; border-radius:4px; -webkit-border-radius:4px; ' +\n\t\t\t'} ' +\n\t\t\t'#vakata-dragged .jstree-ok { background:green; } ' +\n\t\t\t'#vakata-dragged .jstree-invalid { background:red; } ' +\n\t\t\t'#jstree-marker { padding:0; margin:0; font-size:12px; overflow:hidden; height:12px; width:8px; position:absolute; top:-30px; z-index:10001; background-repeat:no-repeat; display:none; background-color:transparent; text-shadow:1px 1px 1px white; color:black; line-height:10px; } ' +\n\t\t\t'#jstree-marker-line { padding:0; margin:0; line-height:0%; font-size:1px; overflow:hidden; height:1px; width:100px; position:absolute; top:-30px; z-index:10000; background-repeat:no-repeat; display:none; background-color:#456c43; ' +\n\t\t\t' cursor:pointer; border:1px solid #eeeeee; border-left:0; -moz-box-shadow: 0px 0px 2px #666; -webkit-box-shadow: 0px 0px 2px #666; box-shadow: 0px 0px 2px #666; ' +\n\t\t\t' -moz-border-radius:1px; border-radius:1px; -webkit-border-radius:1px; ' +\n\t\t\t'}' +\n\t\t\t'';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t\tm = $(\"<div />\").attr({ id : \"jstree-marker\" }).hide().html(\"&raquo;\")\n\t\t\t.bind(\"mouseleave mouseenter\", function (e) {\n\t\t\t\tm.hide();\n\t\t\t\tml.hide();\n\t\t\t\te.preventDefault();\n\t\t\t\te.stopImmediatePropagation();\n\t\t\t\treturn false;\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\tml = $(\"<div />\").attr({ id : \"jstree-marker-line\" }).hide()\n\t\t\t.bind(\"mouseup\", function (e) {\n\t\t\t\tif(r && r.length) {\n\t\t\t\t\tr.children(\"a\").trigger(e);\n\t\t\t\t\te.preventDefault();\n\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t})\n\t\t\t.bind(\"mouseleave\", function (e) {\n\t\t\t\tvar rt = $(e.relatedTarget);\n\t\t\t\tif(rt.is(\".jstree\") || rt.closest(\".jstree\").length === 0) {\n\t\t\t\t\tif(r && r.length) {\n\t\t\t\t\t\tr.children(\"a\").trigger(e);\n\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\tml.hide();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\t$(document).bind(\"drag_start.vakata\", function (e, data) {\n\t\t\tif(data.data.jstree) { m.show(); if(ml) { ml.show(); } }\n\t\t});\n\t\t$(document).bind(\"drag_stop.vakata\", function (e, data) {\n\t\t\tif(data.data.jstree) { m.hide(); if(ml) { ml.hide(); } }\n\t\t});\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree checkbox plugin\n * Inserts checkboxes in front of every node\n * Depends on the ui plugin\n * DOES NOT WORK NICELY WITH MULTITREE DRAG'N'DROP\n */\n(function ($) {\n\t$.jstree.plugin(\"checkbox\", {\n\t\t__init : function () {\n\t\t\tthis.data.checkbox.noui = this._get_settings().checkbox.override_ui;\n\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\tthis.select_node = this.deselect_node = this.deselect_all = $.noop;\n\t\t\t\tthis.get_selected = this.get_checked;\n\t\t\t}\n\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree clean_node.jstree refresh.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._prepare_checkboxes(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tthis._prepare_checkboxes();\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate( (this.data.ui && this.data.checkbox.noui ? \"a\" : \"ins.jstree-checkbox\") , \"click.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\tif(this._get_node(e.target).hasClass(\"jstree-checked\")) { this.uncheck_node(e.target); }\n\t\t\t\t\t\telse { this.check_node(e.target); }\n\t\t\t\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t\tif(this.data.cookies) { this.save_cookie(\"select_node\"); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\toverride_ui : false,\n\t\t\ttwo_state : false,\n\t\t\treal_checkboxes : false,\n\t\t\tchecked_parent_open : true,\n\t\t\treal_checkboxes_names : function (n) { return [ (\"check_\" + (n[0].id || Math.ceil(Math.random() * 10000))) , 1]; }\n\t\t},\n\t\t__destroy : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.find(\"input.jstree-real-checkbox\").removeClass(\"jstree-real-checkbox\").end()\n\t\t\t\t.find(\"ins.jstree-checkbox\").remove();\n\t\t},\n\t\t_fn : {\n\t\t\t_checkbox_notify : function (n, data) {\n\t\t\t\tif(data.checked) {\n\t\t\t\t\tthis.check_node(n, false);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_prepare_checkboxes : function (obj) {\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n\t\t\t\tif(obj === false) { return; } // added for removing root nodes\n\t\t\t\tvar c, _this = this, t, ts = this._get_settings().checkbox.two_state, rc = this._get_settings().checkbox.real_checkboxes, rcn = this._get_settings().checkbox.real_checkboxes_names;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tt = $(this);\n\t\t\t\t\tc = t.is(\"li\") && (t.hasClass(\"jstree-checked\") || (rc && t.children(\":checked\").length)) ? \"jstree-checked\" : \"jstree-unchecked\";\n\t\t\t\t\tt.find(\"li\").addBack().each(function () {\n\t\t\t\t\t\tvar $t = $(this), nm;\n\t\t\t\t\t\t$t.children(\"a\" + (_this.data.languages ? \"\" : \":eq(0)\") ).not(\":has(.jstree-checkbox)\").prepend(\"<ins class='jstree-checkbox'>&#160;</ins>\").parent().not(\".jstree-checked, .jstree-unchecked\").addClass( ts ? \"jstree-unchecked\" : c );\n\t\t\t\t\t\tif(rc) {\n\t\t\t\t\t\t\tif(!$t.children(\":checkbox\").length) {\n\t\t\t\t\t\t\t\tnm = rcn.call(_this, $t);\n\t\t\t\t\t\t\t\t$t.prepend(\"<input type='checkbox' class='jstree-real-checkbox' id='\" + nm[0] + \"' name='\" + nm[0] + \"' value='\" + nm[1] + \"' />\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$t.children(\":checkbox\").addClass(\"jstree-real-checkbox\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!ts) {\n\t\t\t\t\t\t\tif(c === \"jstree-checked\" || $t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n\t\t\t\t\t\t\t\t$t.find(\"li\").addBack().addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n\t\t\t\t\t\t\t\t$t.addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t\tif(!ts) {\n\t\t\t\t\tobj.find(\".jstree-checked\").parent().parent().each(function () { _this._repair_state(this); });\n\t\t\t\t}\n\t\t\t},\n\t\t\tchange_state : function (obj, state) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar coll = false, rc = this._get_settings().checkbox.real_checkboxes;\n\t\t\t\tif(!obj || obj === -1) { return false; }\n\t\t\t\tstate = (state === false || state === true) ? state : obj.hasClass(\"jstree-checked\");\n\t\t\t\tif(this._get_settings().checkbox.two_state) {\n\t\t\t\t\tif(state) {\n\t\t\t\t\t\tobj.removeClass(\"jstree-checked\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\tif(rc) { obj.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\tobj.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n\t\t\t\t\t\tif(rc) { obj.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(state) {\n\t\t\t\t\t\tcoll = obj.find(\"li\").addBack();\n\t\t\t\t\t\tif(!coll.filter(\".jstree-checked, .jstree-undetermined\").length) { return false; }\n\t\t\t\t\t\tcoll.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\tif(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\tcoll = obj.find(\"li\").addBack();\n\t\t\t\t\t\tif(!coll.filter(\".jstree-unchecked, .jstree-undetermined\").length) { return false; }\n\t\t\t\t\t\tcoll.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n\t\t\t\t\t\tif(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t\tif(this.data.ui) { this.data.ui.last_selected = obj; }\n\t\t\t\t\t\tthis.data.checkbox.last_selected = obj;\n\t\t\t\t\t}\n\t\t\t\t\tobj.parentsUntil(\".jstree\", \"li\").each(function () {\n\t\t\t\t\t\tvar $this = $(this);\n\t\t\t\t\t\tif(state) {\n\t\t\t\t\t\t\tif($this.children(\"ul\").children(\"li.jstree-checked, li.jstree-undetermined\").length) {\n\t\t\t\t\t\t\t\t$this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\t\t\t\tif(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$this.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\t\t\tif(rc) { $this.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($this.children(\"ul\").children(\"li.jstree-unchecked, li.jstree-undetermined\").length) {\n\t\t\t\t\t\t\t\t$this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\t\t\t\tif(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$this.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n\t\t\t\t\t\t\t\tif(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(this.data.ui && this.data.checkbox.noui) { this.data.ui.selected = this.get_checked(); }\n\t\t\t\tthis.__callback(obj);\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcheck_node : function (obj) {\n\t\t\t\tif(this.change_state(obj, false)) {\n\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\tif(this._get_settings().checkbox.checked_parent_open) {\n\t\t\t\t\t\tvar t = this;\n\t\t\t\t\t\tobj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n\t\t\t\t\t}\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t}\n\t\t\t},\n\t\t\tuncheck_node : function (obj) {\n\t\t\t\tif(this.change_state(obj, true)) { this.__callback({ \"obj\" : this._get_node(obj) }); }\n\t\t\t},\n\t\t\tcheck_all : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tcoll = this._get_settings().checkbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n\t\t\t\tcoll.each(function () {\n\t\t\t\t\t_this.change_state(this, false);\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tuncheck_all : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tcoll = this._get_settings().checkbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n\t\t\t\tcoll.each(function () {\n\t\t\t\t\t_this.change_state(this, true);\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t},\n\n\t\t\tis_checked : function(obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj.length ? obj.is(\".jstree-checked\") : false;\n\t\t\t},\n\t\t\tget_checked : function (obj, get_all) {\n\t\t\t\tobj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n\t\t\t\treturn get_all || this._get_settings().checkbox.two_state ? obj.find(\".jstree-checked\") : obj.find(\"> ul > .jstree-checked, .jstree-undetermined > ul > .jstree-checked\");\n\t\t\t},\n\t\t\tget_unchecked : function (obj, get_all) {\n\t\t\t\tobj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n\t\t\t\treturn get_all || this._get_settings().checkbox.two_state ? obj.find(\".jstree-unchecked\") : obj.find(\"> ul > .jstree-unchecked, .jstree-undetermined > ul > .jstree-unchecked\");\n\t\t\t},\n\n\t\t\tshow_checkboxes : function () { this.get_container().children(\"ul\").removeClass(\"jstree-no-checkboxes\"); },\n\t\t\thide_checkboxes : function () { this.get_container().children(\"ul\").addClass(\"jstree-no-checkboxes\"); },\n\n\t\t\t_repair_state : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return; }\n\t\t\t\tif(this._get_settings().checkbox.two_state) {\n\t\t\t\t\tobj.find('li').addBack().not('.jstree-checked').removeClass('jstree-undetermined').addClass('jstree-unchecked').children(':checkbox').prop('checked', true);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar rc = this._get_settings().checkbox.real_checkboxes,\n\t\t\t\t\ta = obj.find(\"> ul > .jstree-checked\").length,\n\t\t\t\t\tb = obj.find(\"> ul > .jstree-undetermined\").length,\n\t\t\t\t\tc = obj.find(\"> ul > li\").length;\n\t\t\t\tif(c === 0) { if(obj.hasClass(\"jstree-undetermined\")) { this.change_state(obj, false); } }\n\t\t\t\telse if(a === 0 && b === 0) { this.change_state(obj, true); }\n\t\t\t\telse if(a === c) { this.change_state(obj, false); }\n\t\t\t\telse {\n\t\t\t\t\tobj.parentsUntil(\".jstree\",\"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\tif(rc) { obj.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t}\n\t\t\t},\n\t\t\treselect : function () {\n\t\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\t\tvar _this = this,\n\t\t\t\t\t\ts = this.data.ui.to_select;\n\t\t\t\t\ts = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t$.each(s, function (i, val) { _this.check_node(val); });\n\t\t\t\t\tthis.__callback();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.__call_old();\n\t\t\t\t}\n\t\t\t},\n\t\t\tsave_loaded : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.core.to_load = [];\n\t\t\t\tthis.get_container_ul().find(\"li.jstree-closed.jstree-undetermined\").each(function () {\n\t\t\t\t\tif(this.id) { _this.data.core.to_load.push(\"#\" + this.id); }\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '.jstree .jstree-real-checkbox { display:none; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree XML plugin\n * The XML data store. Datastores are build by overriding the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.vakata.xslt = function (xml, xsl, callback) {\n\t\tvar rs = \"\", xm, xs, processor, support;\n\t\t// TODO: IE9 no XSLTProcessor, no document.recalc\n\t\tif(document.recalc) {\n\t\t\txm = document.createElement('xml');\n\t\t\txs = document.createElement('xml');\n\t\t\txm.innerHTML = xml;\n\t\t\txs.innerHTML = xsl;\n\t\t\t$(\"body\").append(xm).append(xs);\n\t\t\tsetTimeout( (function (xm, xs, callback) {\n\t\t\t\treturn function () {\n\t\t\t\t\tcallback.call(null, xm.transformNode(xs.XMLDocument));\n\t\t\t\t\tsetTimeout( (function (xm, xs) { return function () { $(xm).remove(); $(xs).remove(); }; })(xm, xs), 200);\n\t\t\t\t};\n\t\t\t})(xm, xs, callback), 100);\n\t\t\treturn true;\n\t\t}\n\t\tif(typeof window.DOMParser !== \"undefined\" && typeof window.XMLHttpRequest !== \"undefined\" && typeof window.XSLTProcessor === \"undefined\") {\n\t\t\txml = new DOMParser().parseFromString(xml, \"text/xml\");\n\t\t\txsl = new DOMParser().parseFromString(xsl, \"text/xml\");\n\t\t\t// alert(xml.transformNode());\n\t\t\t// callback.call(null, new XMLSerializer().serializeToString(rs));\n\n\t\t}\n\t\tif(typeof window.DOMParser !== \"undefined\" && typeof window.XMLHttpRequest !== \"undefined\" && typeof window.XSLTProcessor !== \"undefined\") {\n\t\t\tprocessor = new XSLTProcessor();\n\t\t\tsupport = $.isFunction(processor.transformDocument) ? (typeof window.XMLSerializer !== \"undefined\") : true;\n\t\t\tif(!support) { return false; }\n\t\t\txml = new DOMParser().parseFromString(xml, \"text/xml\");\n\t\t\txsl = new DOMParser().parseFromString(xsl, \"text/xml\");\n\t\t\tif($.isFunction(processor.transformDocument)) {\n\t\t\t\trs = document.implementation.createDocument(\"\", \"\", null);\n\t\t\t\tprocessor.transformDocument(xml, xsl, rs, null);\n\t\t\t\tcallback.call(null, new XMLSerializer().serializeToString(rs));\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telse {\n\t\t\t\tprocessor.importStylesheet(xsl);\n\t\t\t\trs = processor.transformToFragment(xml, document);\n\t\t\t\tcallback.call(null, $(\"<div />\").append(rs).html());\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t};\n\tvar xsl = {\n\t\t'nest' : '<' + '?xml version=\"1.0\" encoding=\"utf-8\" ?>' +\n\t\t\t'<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" >' +\n\t\t\t'<xsl:output method=\"html\" encoding=\"utf-8\" omit-xml-declaration=\"yes\" standalone=\"no\" indent=\"no\" media-type=\"text/html\" />' +\n\t\t\t'<xsl:template match=\"/\">' +\n\t\t\t'\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t<xsl:with-param name=\"node\" select=\"/root\" />' +\n\t\t\t'\t</xsl:call-template>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'<xsl:template name=\"nodes\">' +\n\t\t\t'\t<xsl:param name=\"node\" />' +\n\t\t\t'\t<ul>' +\n\t\t\t'\t<xsl:for-each select=\"$node/item\">' +\n\t\t\t'\t\t<xsl:variable name=\"children\" select=\"count(./item) &gt; 0\" />' +\n\t\t\t'\t\t<li>' +\n\t\t\t'\t\t\t<xsl:attribute name=\"class\">' +\n\t\t\t'\t\t\t\t<xsl:if test=\"position() = last()\">jstree-last </xsl:if>' +\n\t\t\t'\t\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"@state = \\'open\\'\">jstree-open </xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"$children or @hasChildren or @state = \\'closed\\'\">jstree-closed </xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:otherwise>jstree-leaf </xsl:otherwise>' +\n\t\t\t'\t\t\t\t</xsl:choose>' +\n\t\t\t'\t\t\t\t<xsl:value-of select=\"@class\" />' +\n\t\t\t'\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t\t<xsl:if test=\"name() != \\'class\\' and name() != \\'state\\' and name() != \\'hasChildren\\'\">' +\n\t\t\t'\t\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t</xsl:if>' +\n\t\t\t'\t\t\t</xsl:for-each>' +\n\t\t\t'\t<ins class=\"jstree-icon\"><xsl:text>&#xa0;</xsl:text></ins>' +\n\t\t\t'\t\t\t<xsl:for-each select=\"content/name\">' +\n\t\t\t'\t\t\t\t<a>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"href\">' +\n\t\t\t'\t\t\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"@href\"><xsl:value-of select=\"@href\" /></xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:otherwise>#</xsl:otherwise>' +\n\t\t\t'\t\t\t\t\t</xsl:choose>' +\n\t\t\t'\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"class\"><xsl:value-of select=\"@lang\" /> <xsl:value-of select=\"@class\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"style\"><xsl:value-of select=\"@style\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t\t\t<xsl:if test=\"name() != \\'style\\' and name() != \\'class\\' and name() != \\'href\\'\">' +\n\t\t\t'\t\t\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t\t</xsl:if>' +\n\t\t\t'\t\t\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t\t\t<ins>' +\n\t\t\t'\t\t\t\t\t\t<xsl:attribute name=\"class\">jstree-icon ' +\n\t\t\t'\t\t\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and not(contains(@icon,\\'/\\'))\"><xsl:value-of select=\"@icon\" /></xsl:if>' +\n\t\t\t'\t\t\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and contains(@icon,\\'/\\')\"><xsl:attribute name=\"style\">background:url(<xsl:value-of select=\"@icon\" />) center center no-repeat;</xsl:attribute></xsl:if>' +\n\t\t\t'\t\t\t\t\t\t<xsl:text>&#xa0;</xsl:text>' +\n\t\t\t'\t\t\t\t\t</ins>' +\n\t\t\t'\t\t\t\t\t<xsl:copy-of select=\"./child::node()\" />' +\n\t\t\t'\t\t\t\t</a>' +\n\t\t\t'\t\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t<xsl:if test=\"$children or @hasChildren\"><xsl:call-template name=\"nodes\"><xsl:with-param name=\"node\" select=\"current()\" /></xsl:call-template></xsl:if>' +\n\t\t\t'\t\t</li>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t</ul>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'</xsl:stylesheet>',\n\n\t\t'flat' : '<' + '?xml version=\"1.0\" encoding=\"utf-8\" ?>' +\n\t\t\t'<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" >' +\n\t\t\t'<xsl:output method=\"html\" encoding=\"utf-8\" omit-xml-declaration=\"yes\" standalone=\"no\" indent=\"no\" media-type=\"text/xml\" />' +\n\t\t\t'<xsl:template match=\"/\">' +\n\t\t\t'\t<ul>' +\n\t\t\t'\t<xsl:for-each select=\"//item[not(@parent_id) or @parent_id=0 or not(@parent_id = //item/@id)]\">' + /* the last `or` may be removed */\n\t\t\t'\t\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t\t<xsl:with-param name=\"node\" select=\".\" />' +\n\t\t\t'\t\t\t<xsl:with-param name=\"is_last\" select=\"number(position() = last())\" />' +\n\t\t\t'\t\t</xsl:call-template>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t</ul>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'<xsl:template name=\"nodes\">' +\n\t\t\t'\t<xsl:param name=\"node\" />' +\n\t\t\t'\t<xsl:param name=\"is_last\" />' +\n\t\t\t'\t<xsl:variable name=\"children\" select=\"count(//item[@parent_id=$node/attribute::id]) &gt; 0\" />' +\n\t\t\t'\t<li>' +\n\t\t\t'\t<xsl:attribute name=\"class\">' +\n\t\t\t'\t\t<xsl:if test=\"$is_last = true()\">jstree-last </xsl:if>' +\n\t\t\t'\t\t<xsl:choose>' +\n\t\t\t'\t\t\t<xsl:when test=\"@state = \\'open\\'\">jstree-open </xsl:when>' +\n\t\t\t'\t\t\t<xsl:when test=\"$children or @hasChildren or @state = \\'closed\\'\">jstree-closed </xsl:when>' +\n\t\t\t'\t\t\t<xsl:otherwise>jstree-leaf </xsl:otherwise>' +\n\t\t\t'\t\t</xsl:choose>' +\n\t\t\t'\t\t<xsl:value-of select=\"@class\" />' +\n\t\t\t'\t</xsl:attribute>' +\n\t\t\t'\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t<xsl:if test=\"name() != \\'parent_id\\' and name() != \\'hasChildren\\' and name() != \\'class\\' and name() != \\'state\\'\">' +\n\t\t\t'\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t</xsl:if>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t<ins class=\"jstree-icon\"><xsl:text>&#xa0;</xsl:text></ins>' +\n\t\t\t'\t<xsl:for-each select=\"content/name\">' +\n\t\t\t'\t\t<a>' +\n\t\t\t'\t\t<xsl:attribute name=\"href\">' +\n\t\t\t'\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t<xsl:when test=\"@href\"><xsl:value-of select=\"@href\" /></xsl:when>' +\n\t\t\t'\t\t\t<xsl:otherwise>#</xsl:otherwise>' +\n\t\t\t'\t\t\t</xsl:choose>' +\n\t\t\t'\t\t</xsl:attribute>' +\n\t\t\t'\t\t<xsl:attribute name=\"class\"><xsl:value-of select=\"@lang\" /> <xsl:value-of select=\"@class\" /></xsl:attribute>' +\n\t\t\t'\t\t<xsl:attribute name=\"style\"><xsl:value-of select=\"@style\" /></xsl:attribute>' +\n\t\t\t'\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t<xsl:if test=\"name() != \\'style\\' and name() != \\'class\\' and name() != \\'href\\'\">' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t</xsl:if>' +\n\t\t\t'\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t<ins>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"class\">jstree-icon ' +\n\t\t\t'\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and not(contains(@icon,\\'/\\'))\"><xsl:value-of select=\"@icon\" /></xsl:if>' +\n\t\t\t'\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and contains(@icon,\\'/\\')\"><xsl:attribute name=\"style\">background:url(<xsl:value-of select=\"@icon\" />) center center no-repeat;</xsl:attribute></xsl:if>' +\n\t\t\t'\t\t\t\t<xsl:text>&#xa0;</xsl:text>' +\n\t\t\t'\t\t\t</ins>' +\n\t\t\t'\t\t\t<xsl:copy-of select=\"./child::node()\" />' +\n\t\t\t'\t\t</a>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t<xsl:if test=\"$children\">' +\n\t\t\t'\t\t<ul>' +\n\t\t\t'\t\t<xsl:for-each select=\"//item[@parent_id=$node/attribute::id]\">' +\n\t\t\t'\t\t\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t\t\t<xsl:with-param name=\"node\" select=\".\" />' +\n\t\t\t'\t\t\t\t<xsl:with-param name=\"is_last\" select=\"number(position() = last())\" />' +\n\t\t\t'\t\t\t</xsl:call-template>' +\n\t\t\t'\t\t</xsl:for-each>' +\n\t\t\t'\t\t</ul>' +\n\t\t\t'\t</xsl:if>' +\n\t\t\t'\t</li>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'</xsl:stylesheet>'\n\t},\n\tescape_xml = function(string) {\n\t\treturn string\n\t\t\t.toString()\n\t\t\t.replace(/&/g, '&amp;')\n\t\t\t.replace(/</g, '&lt;')\n\t\t\t.replace(/>/g, '&gt;')\n\t\t\t.replace(/\"/g, '&quot;')\n\t\t\t.replace(/'/g, '&apos;');\n\t};\n\t$.jstree.plugin(\"xml_data\", {\n\t\tdefaults : {\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\txsl : \"flat\",\n\t\t\tclean_node : false,\n\t\t\tcorrect_state : true,\n\t\t\tget_skip_empty : false,\n\t\t\tget_include_preamble : true\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_xml(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tvar s = this._get_settings().xml_data;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!s.ajax && !$.isFunction(s.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").size() > 0;\n\t\t\t},\n\t\t\tload_node_xml : function (obj, s_call, e_call) {\n\t\t\t\tvar s = this.get_settings().xml_data,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase (!s.data && !s.ajax): throw \"Neither data nor ajax settings supplied.\";\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\tthis.parse_xml(d, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\tthis.parse_xml(s.data, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty().append(d.children());\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().xml_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj !== -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\td = x.responseText;\n\t\t\t\t\t\t\tvar sf = this.get_settings().xml_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\")) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tthis.parse_xml(d, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"xml\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tparse_xml : function (xml, callback) {\n\t\t\t\tvar s = this._get_settings().xml_data;\n\t\t\t\t$.vakata.xslt(xml, xsl[s.xsl], callback);\n\t\t\t},\n\t\t\tget_xml : function (tp, obj, li_attr, a_attr, is_callback) {\n\t\t\t\tvar result = \"\",\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this,\n\t\t\t\t\ttmp1, tmp2, li, a, lang;\n\t\t\t\tif(!tp) { tp = \"flat\"; }\n\t\t\t\tif(!is_callback) { is_callback = 0; }\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container().find(\"> ul > li\"); }\n\t\t\t\tli_attr = $.isArray(li_attr) ? li_attr : [ \"id\", \"class\" ];\n\t\t\t\tif(!is_callback && this.data.types && $.inArray(s.types.type_attr, li_attr) === -1) { li_attr.push(s.types.type_attr); }\n\n\t\t\t\ta_attr = $.isArray(a_attr) ? a_attr : [ ];\n\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tif(s.xml_data.get_include_preamble) {\n\t\t\t\t\t\tresult += '<' + '?xml version=\"1.0\" encoding=\"UTF-8\"?' + '>';\n\t\t\t\t\t}\n\t\t\t\t\tresult += \"<root>\";\n\t\t\t\t}\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tresult += \"<item\";\n\t\t\t\t\tli = $(this);\n\t\t\t\t\t$.each(li_attr, function (i, v) {\n\t\t\t\t\t\tvar t = li.attr(v);\n\t\t\t\t\t\tif(!s.xml_data.get_skip_empty || typeof t !== \"undefined\") {\n\t\t\t\t\t\t\tresult += \" \" + v + \"=\\\"\" + escape_xml((\" \" + (t || \"\")).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + \"\\\"\";\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tif(li.hasClass(\"jstree-open\")) { result += \" state=\\\"open\\\"\"; }\n\t\t\t\t\tif(li.hasClass(\"jstree-closed\")) { result += \" state=\\\"closed\\\"\"; }\n\t\t\t\t\tif(tp === \"flat\") { result += \" parent_id=\\\"\" + escape_xml(is_callback) + \"\\\"\"; }\n\t\t\t\t\tresult += \">\";\n\t\t\t\t\tresult += \"<content>\";\n\t\t\t\t\ta = li.children(\"a\");\n\t\t\t\t\ta.each(function () {\n\t\t\t\t\t\ttmp1 = $(this);\n\t\t\t\t\t\tlang = false;\n\t\t\t\t\t\tresult += \"<name\";\n\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1) {\n\t\t\t\t\t\t\t$.each(s.languages, function (k, z) {\n\t\t\t\t\t\t\t\tif(tmp1.hasClass(z)) { result += \" lang=\\\"\" + escape_xml(z) + \"\\\"\"; lang = z; return false; }\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(a_attr.length) {\n\t\t\t\t\t\t\t$.each(a_attr, function (k, z) {\n\t\t\t\t\t\t\t\tvar t = tmp1.attr(z);\n\t\t\t\t\t\t\t\tif(!s.xml_data.get_skip_empty || typeof t !== \"undefined\") {\n\t\t\t\t\t\t\t\t\tresult += \" \" + z + \"=\\\"\" + escape_xml((\" \" + t || \"\").replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + \"\\\"\";\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(tmp1.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/^\\s+$/ig,\"\").length) {\n\t\t\t\t\t\t\tresult += ' icon=\"' + escape_xml(tmp1.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + '\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(tmp1.children(\"ins\").get(0).style.backgroundImage.length) {\n\t\t\t\t\t\t\tresult += ' icon=\"' + escape_xml(tmp1.children(\"ins\").get(0).style.backgroundImage.replace(\"url(\",\"\").replace(\")\",\"\").replace(/'/ig,\"\").replace(/\"/ig,\"\")) + '\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t\tresult += \">\";\n\t\t\t\t\t\tresult += \"<![CDATA[\" + _this.get_text(tmp1, lang) + \"]]>\";\n\t\t\t\t\t\tresult += \"</name>\";\n\t\t\t\t\t});\n\t\t\t\t\tresult += \"</content>\";\n\t\t\t\t\ttmp2 = li[0].id || true;\n\t\t\t\t\tli = li.find(\"> ul > li\");\n\t\t\t\t\tif(li.length) { tmp2 = _this.get_xml(tp, li, li_attr, a_attr, tmp2); }\n\t\t\t\t\telse { tmp2 = \"\"; }\n\t\t\t\t\tif(tp == \"nest\") { result += tmp2; }\n\t\t\t\t\tresult += \"</item>\";\n\t\t\t\t\tif(tp == \"flat\") { result += tmp2; }\n\t\t\t\t});\n\t\t\t\tif(!is_callback) { result += \"</root>\"; }\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree search plugin\n * Enables both sync and async search on the tree\n * DOES NOT WORK WITH JSON PROGRESSIVE RENDER\n */\n(function ($) {\n\t$.expr[':'].jstree_contains = function(a,i,m){\n\t\treturn (a.textContent || a.innerText || \"\").toLowerCase().indexOf(m[3].toLowerCase())>=0;\n\t};\n\t$.expr[':'].jstree_title_contains = function(a,i,m) {\n\t\treturn (a.getAttribute(\"title\") || \"\").toLowerCase().indexOf(m[3].toLowerCase())>=0;\n\t};\n\t$.jstree.plugin(\"search\", {\n\t\t__init : function () {\n\t\t\tthis.data.search.str = \"\";\n\t\t\tthis.data.search.result = $();\n\t\t\tif(this._get_settings().search.show_only_matches) {\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.bind(\"search.jstree\", function (e, data) {\n\t\t\t\t\t\t$(this).children(\"ul\").find(\"li\").hide().removeClass(\"jstree-last\");\n\t\t\t\t\t\tdata.rslt.nodes.parentsUntil(\".jstree\").addBack().show()\n\t\t\t\t\t\t\t.filter(\"ul\").each(function () { $(this).children(\"li:visible\").eq(-1).addClass(\"jstree-last\"); });\n\t\t\t\t\t})\n\t\t\t\t\t.bind(\"clear_search.jstree\", function () {\n\t\t\t\t\t\t$(this).children(\"ul\").find(\"li\").css(\"display\",\"\").end().end().jstree(\"clean_node\", -1);\n\t\t\t\t\t});\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\tajax : false,\n\t\t\tsearch_method : \"jstree_contains\", // for case insensitive - jstree_contains\n\t\t\tshow_only_matches : false\n\t\t},\n\t\t_fn : {\n\t\t\tsearch : function (str, skip_async) {\n\t\t\t\tif($.trim(str) === \"\") { this.clear_search(); return; }\n\t\t\t\tvar s = this.get_settings().search,\n\t\t\t\t\tt = this,\n\t\t\t\t\terror_func = function () { },\n\t\t\t\t\tsuccess_func = function () { };\n\t\t\t\tthis.data.search.str = str;\n\n\t\t\t\tif(!skip_async && s.ajax !== false && this.get_container_ul().find(\"li.jstree-closed:not(:has(ul)):eq(0)\").length > 0) {\n\t\t\t\t\tthis.search.supress_callback = true;\n\t\t\t\t\terror_func = function () { };\n\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\tvar sf = this.get_settings().search.ajax.success;\n\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\tthis.data.search.to_open = d;\n\t\t\t\t\t\tthis._search_open();\n\t\t\t\t\t};\n\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, str); }\n\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, str); }\n\t\t\t\t\tif(!s.ajax.data) { s.ajax.data = { \"search_string\" : str }; }\n\t\t\t\t\tif(!s.ajax.dataType || /^json/.exec(s.ajax.dataType)) { s.ajax.dataType = \"json\"; }\n\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tif(this.data.search.result.length) { this.clear_search(); }\n\t\t\t\tthis.data.search.result = this.get_container().find(\"a\" + (this.data.languages ? \".\" + this.get_lang() : \"\" ) + \":\" + (s.search_method) + \"(\" + this.data.search.str + \")\");\n\t\t\t\tthis.data.search.result.addClass(\"jstree-search\").parent().parents(\".jstree-closed\").each(function () {\n\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t});\n\t\t\t\tthis.__callback({ nodes : this.data.search.result, str : str });\n\t\t\t},\n\t\t\tclear_search : function (str) {\n\t\t\t\tthis.data.search.result.removeClass(\"jstree-search\");\n\t\t\t\tthis.__callback(this.data.search.result);\n\t\t\t\tthis.data.search.result = $();\n\t\t\t},\n\t\t\t_search_open : function (is_callback) {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tdone = true,\n\t\t\t\t\tcurrent = [],\n\t\t\t\t\tremaining = [];\n\t\t\t\tif(this.data.search.to_open.length) {\n\t\t\t\t\t$.each(this.data.search.to_open, function (i, val) {\n\t\t\t\t\t\tif(val == \"#\") { return true; }\n\t\t\t\t\t\tif($(val).length && $(val).is(\".jstree-closed\")) { current.push(val); }\n\t\t\t\t\t\telse { remaining.push(val); }\n\t\t\t\t\t});\n\t\t\t\t\tif(current.length) {\n\t\t\t\t\t\tthis.data.search.to_open = remaining;\n\t\t\t\t\t\t$.each(current, function (i, val) {\n\t\t\t\t\t\t\t_this.open_node(val, function () { _this._search_open(true); });\n\t\t\t\t\t\t});\n\t\t\t\t\t\tdone = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(done) { this.search(this.data.search.str, true); }\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree contextmenu plugin\n */\n(function ($) {\n\t$.vakata.context = {\n\t\thide_on_mouseleave : false,\n\n\t\tcnt\t\t: $(\"<div id='vakata-contextmenu' />\"),\n\t\tvis\t\t: false,\n\t\ttgt\t\t: false,\n\t\tpar\t\t: false,\n\t\tfunc\t: false,\n\t\tdata\t: false,\n\t\trtl\t\t: false,\n\t\tshow\t: function (s, t, x, y, d, p, rtl) {\n\t\t\t$.vakata.context.rtl = !!rtl;\n\t\t\tvar html = $.vakata.context.parse(s), h, w;\n\t\t\tif(!html) { return; }\n\t\t\t$.vakata.context.vis = true;\n\t\t\t$.vakata.context.tgt = t;\n\t\t\t$.vakata.context.par = p || t || null;\n\t\t\t$.vakata.context.data = d || null;\n\t\t\t$.vakata.context.cnt\n\t\t\t\t.html(html)\n\t\t\t\t.css({ \"visibility\" : \"hidden\", \"display\" : \"block\", \"left\" : 0, \"top\" : 0 });\n\n\t\t\tif($.vakata.context.hide_on_mouseleave) {\n\t\t\t\t$.vakata.context.cnt\n\t\t\t\t\t.one(\"mouseleave\", function(e) { $.vakata.context.hide(); });\n\t\t\t}\n\n\t\t\th = $.vakata.context.cnt.height();\n\t\t\tw = $.vakata.context.cnt.width();\n\t\t\tif(x + w > $(document).width()) {\n\t\t\t\tx = $(document).width() - (w + 5);\n\t\t\t\t$.vakata.context.cnt.find(\"li > ul\").addClass(\"right\");\n\t\t\t}\n\t\t\tif(y + h > $(document).height()) {\n\t\t\t\ty = y - (h + t[0].offsetHeight);\n\t\t\t\t$.vakata.context.cnt.find(\"li > ul\").addClass(\"bottom\");\n\t\t\t}\n\n\t\t\t$.vakata.context.cnt\n\t\t\t\t.css({ \"left\" : x, \"top\" : y })\n\t\t\t\t.find(\"li:has(ul)\")\n\t\t\t\t\t.bind(\"mouseenter\", function (e) {\n\t\t\t\t\t\tvar w = $(document).width(),\n\t\t\t\t\t\t\th = $(document).height(),\n\t\t\t\t\t\t\tul = $(this).children(\"ul\").show();\n\t\t\t\t\t\tif(w !== $(document).width()) { ul.toggleClass(\"right\"); }\n\t\t\t\t\t\tif(h !== $(document).height()) { ul.toggleClass(\"bottom\"); }\n\t\t\t\t\t})\n\t\t\t\t\t.bind(\"mouseleave\", function (e) {\n\t\t\t\t\t\t$(this).children(\"ul\").hide();\n\t\t\t\t\t})\n\t\t\t\t\t.end()\n\t\t\t\t.css({ \"visibility\" : \"visible\" })\n\t\t\t\t.show();\n\t\t\t$(document).triggerHandler(\"context_show.vakata\");\n\t\t},\n\t\thide\t: function () {\n\t\t\t$.vakata.context.vis = false;\n\t\t\t$.vakata.context.cnt.attr(\"class\",\"\").css({ \"visibility\" : \"hidden\" });\n\t\t\t$(document).triggerHandler(\"context_hide.vakata\");\n\t\t},\n\t\tparse\t: function (s, is_callback) {\n\t\t\tif(!s) { return false; }\n\t\t\tvar str = \"\",\n\t\t\t\ttmp = false,\n\t\t\t\twas_sep = true;\n\t\t\tif(!is_callback) { $.vakata.context.func = {}; }\n\t\t\tstr += \"<ul>\";\n\t\t\t$.each(s, function (i, val) {\n\t\t\t\tif(!val) { return true; }\n\t\t\t\t$.vakata.context.func[i] = val.action;\n\t\t\t\tif(!was_sep && val.separator_before) {\n\t\t\t\t\tstr += \"<li class='vakata-separator vakata-separator-before'></li>\";\n\t\t\t\t}\n\t\t\t\twas_sep = false;\n\t\t\t\tstr += \"<li class='\" + (val._class || \"\") + (val._disabled ? \" jstree-contextmenu-disabled \" : \"\") + \"'><ins \";\n\t\t\t\tif(val.icon && val.icon.indexOf(\"/\") === -1) { str += \" class='\" + val.icon + \"' \"; }\n\t\t\t\tif(val.icon && val.icon.indexOf(\"/\") !== -1) { str += \" style='background:url(\" + val.icon + \") center center no-repeat;' \"; }\n\t\t\t\tstr += \">&#160;</ins><a href='#' rel='\" + i + \"'>\";\n\t\t\t\tif(val.submenu) {\n\t\t\t\t\tstr += \"<span style='float:\" + ($.vakata.context.rtl ? \"left\" : \"right\") + \";'>&raquo;</span>\";\n\t\t\t\t}\n\t\t\t\tstr += val.label + \"</a>\";\n\t\t\t\tif(val.submenu) {\n\t\t\t\t\ttmp = $.vakata.context.parse(val.submenu, true);\n\t\t\t\t\tif(tmp) { str += tmp; }\n\t\t\t\t}\n\t\t\t\tstr += \"</li>\";\n\t\t\t\tif(val.separator_after) {\n\t\t\t\t\tstr += \"<li class='vakata-separator vakata-separator-after'></li>\";\n\t\t\t\t\twas_sep = true;\n\t\t\t\t}\n\t\t\t});\n\t\t\tstr = str.replace(/<li class\\='vakata-separator vakata-separator-after'\\><\\/li\\>$/,\"\");\n\t\t\tstr += \"</ul>\";\n\t\t\t$(document).triggerHandler(\"context_parse.vakata\");\n\t\t\treturn str.length > 10 ? str : false;\n\t\t},\n\t\texec\t: function (i) {\n\t\t\tif($.isFunction($.vakata.context.func[i])) {\n\t\t\t\t// if is string - eval and call it!\n\t\t\t\t$.vakata.context.func[i].call($.vakata.context.data, $.vakata.context.par);\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telse { return false; }\n\t\t}\n\t};\n\t$(function () {\n\t\tvar css_string = '' +\n\t\t\t'#vakata-contextmenu { display:block; visibility:hidden; left:0; top:-200px; position:absolute; margin:0; padding:0; min-width:180px; background:#ebebeb; border:1px solid silver; z-index:10000; *width:180px; } ' +\n\t\t\t'#vakata-contextmenu ul { min-width:180px; *width:180px; } ' +\n\t\t\t'#vakata-contextmenu ul, #vakata-contextmenu li { margin:0; padding:0; list-style-type:none; display:block; } ' +\n\t\t\t'#vakata-contextmenu li { line-height:20px; min-height:20px; position:relative; padding:0px; } ' +\n\t\t\t'#vakata-contextmenu li a { padding:1px 6px; line-height:17px; display:block; text-decoration:none; margin:1px 1px 0 1px; } ' +\n\t\t\t'#vakata-contextmenu li ins { float:left; width:16px; height:16px; text-decoration:none; margin-right:2px; } ' +\n\t\t\t'#vakata-contextmenu li a:hover, #vakata-contextmenu li.vakata-hover > a { background:gray; color:white; } ' +\n\t\t\t'#vakata-contextmenu li ul { display:none; position:absolute; top:-2px; left:100%; background:#ebebeb; border:1px solid gray; } ' +\n\t\t\t'#vakata-contextmenu .right { right:100%; left:auto; } ' +\n\t\t\t'#vakata-contextmenu .bottom { bottom:-1px; top:auto; } ' +\n\t\t\t'#vakata-contextmenu li.vakata-separator { min-height:0; height:1px; line-height:1px; font-size:1px; overflow:hidden; margin:0 2px; background:silver; /* border-top:1px solid #fefefe; */ padding:0; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"vakata\" });\n\t\t$.vakata.context.cnt\n\t\t\t.delegate(\"a\",\"click\", function (e) { e.preventDefault(); })\n\t\t\t.delegate(\"a\",\"mouseup\", function (e) {\n\t\t\t\tif(!$(this).parent().hasClass(\"jstree-contextmenu-disabled\") && $.vakata.context.exec($(this).attr(\"rel\"))) {\n\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t}\n\t\t\t\telse { $(this).blur(); }\n\t\t\t})\n\t\t\t.delegate(\"a\",\"mouseover\", function () {\n\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").removeClass(\"vakata-hover\");\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\t$(document).bind(\"mousedown\", function (e) { if($.vakata.context.vis && !$.contains($.vakata.context.cnt[0], e.target)) { $.vakata.context.hide(); } });\n\t\tif(typeof $.hotkeys !== \"undefined\") {\n\t\t\t$(document)\n\t\t\t\t.bind(\"keydown\", \"up\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\tvar o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\".vakata-hover\").removeClass(\"vakata-hover\").prevAll(\"li:not(.vakata-separator)\").first();\n\t\t\t\t\t\tif(!o.length) { o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\"li:not(.vakata-separator)\").last(); }\n\t\t\t\t\t\to.addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"down\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\tvar o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\".vakata-hover\").removeClass(\"vakata-hover\").nextAll(\"li:not(.vakata-separator)\").first();\n\t\t\t\t\t\tif(!o.length) { o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\"li:not(.vakata-separator)\").first(); }\n\t\t\t\t\t\to.addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"right\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").children(\"ul\").show().children(\"li:not(.vakata-separator)\").removeClass(\"vakata-hover\").first().addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"left\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").children(\"ul\").hide().children(\".vakata-separator\").removeClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"esc\", function (e) {\n\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\te.preventDefault();\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"space\", function (e) {\n\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").last().children(\"a\").click();\n\t\t\t\t\te.preventDefault();\n\t\t\t\t});\n\t\t}\n\t});\n\n\t$.jstree.plugin(\"contextmenu\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.delegate(\"a\", \"contextmenu.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\tif(!$(e.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.show_contextmenu(e.currentTarget, e.pageX, e.pageY);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"click.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(this.data.contextmenu) {\n\t\t\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"destroy.jstree\", $.proxy(function () {\n\t\t\t\t\t\t// TODO: move this to descruct method\n\t\t\t\t\t\tif(this.data.contextmenu) {\n\t\t\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\t$(document).bind(\"context_hide.vakata\", $.proxy(function () { this.data.contextmenu = false; }, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tselect_node : false, // requires UI plugin\n\t\t\tshow_at_node : true,\n\t\t\titems : { // Could be a function that should return an object like this one\n\t\t\t\t\"create\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"separator_after\"\t: true,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Create\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.create(obj); }\n\t\t\t\t},\n\t\t\t\t\"rename\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Rename\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.rename(obj); }\n\t\t\t\t},\n\t\t\t\t\"remove\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Delete\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { if(this.is_selected(obj)) { this.remove(); } else { this.remove(obj); } }\n\t\t\t\t},\n\t\t\t\t\"ccp\" : {\n\t\t\t\t\t\"separator_before\"\t: true,\n\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Edit\",\n\t\t\t\t\t\"action\"\t\t\t: false,\n\t\t\t\t\t\"submenu\" : {\n\t\t\t\t\t\t\"cut\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Cut\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.cut(obj); }\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"copy\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Copy\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.copy(obj); }\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"paste\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Paste\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.paste(obj); }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\tshow_contextmenu : function (obj, x, y) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = this.get_settings().contextmenu,\n\t\t\t\t\ta = obj.children(\"a:visible:eq(0)\"),\n\t\t\t\t\to = false,\n\t\t\t\t\ti = false;\n\t\t\t\tif(s.select_node && this.data.ui && !this.is_selected(obj)) {\n\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\tthis.select_node(obj, true);\n\t\t\t\t}\n\t\t\t\tif(s.show_at_node || typeof x === \"undefined\" || typeof y === \"undefined\") {\n\t\t\t\t\to = a.offset();\n\t\t\t\t\tx = o.left;\n\t\t\t\t\ty = o.top + this.data.core.li_height;\n\t\t\t\t}\n\t\t\t\ti = obj.data(\"jstree\") && obj.data(\"jstree\").contextmenu ? obj.data(\"jstree\").contextmenu : s.items;\n\t\t\t\tif($.isFunction(i)) { i = i.call(this, obj); }\n\t\t\t\tthis.data.contextmenu = true;\n\t\t\t\t$.vakata.context.show(i, a, x, y, this, obj, this._get_settings().core.rtl);\n\t\t\t\tif(this.data.themes) { $.vakata.context.cnt.attr(\"class\", \"jstree-\" + this.data.themes.theme + \"-context\"); }\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree types plugin\n * Adds support types of nodes\n * You can set an attribute on each li node, that represents its type.\n * According to the type setting the node may get custom icon/validation rules\n */\n(function ($) {\n\t$.jstree.plugin(\"types\", {\n\t\t__init : function () {\n\t\t\tvar s = this._get_settings().types;\n\t\t\tthis.data.types.attach_to = [];\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function () {\n\t\t\t\t\t\tvar types = s.types,\n\t\t\t\t\t\t\tattr  = s.type_attr,\n\t\t\t\t\t\t\ticons_css = \"\",\n\t\t\t\t\t\t\t_this = this;\n\n\t\t\t\t\t\t$.each(types, function (i, tp) {\n\t\t\t\t\t\t\t$.each(tp, function (k, v) {\n\t\t\t\t\t\t\t\tif(!/^(max_depth|max_children|icon|valid_children)$/.test(k)) { _this.data.types.attach_to.push(k); }\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tif(!tp.icon) { return true; }\n\t\t\t\t\t\t\tif( tp.icon.image || tp.icon.position) {\n\t\t\t\t\t\t\t\tif(i == \"default\")\t{ icons_css += '.jstree-' + _this.get_index() + ' a > .jstree-icon { '; }\n\t\t\t\t\t\t\t\telse\t\t\t\t{ icons_css += '.jstree-' + _this.get_index() + ' li[' + attr + '=\"' + i + '\"] > a > .jstree-icon { '; }\n\t\t\t\t\t\t\t\tif(tp.icon.image)\t{ icons_css += ' background-image:url(' + tp.icon.image + '); '; }\n\t\t\t\t\t\t\t\tif(tp.icon.position){ icons_css += ' background-position:' + tp.icon.position + '; '; }\n\t\t\t\t\t\t\t\telse\t\t\t\t{ icons_css += ' background-position:0 0; '; }\n\t\t\t\t\t\t\t\ticons_css += '} ';\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t\tif(icons_css !== \"\") { $.vakata.css.add_sheet({ 'str' : icons_css, title : \"jstree-types\" }); }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"before.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar s, t,\n\t\t\t\t\t\t\to = this._get_settings().types.use_data ? this._get_node(data.args[0]) : false,\n\t\t\t\t\t\t\td = o && o !== -1 && o.length ? o.data(\"jstree\") : false;\n\t\t\t\t\t\tif(d && d.types && d.types[data.func] === false) { e.stopImmediatePropagation(); return false; }\n\t\t\t\t\t\tif($.inArray(data.func, this.data.types.attach_to) !== -1) {\n\t\t\t\t\t\t\tif(!data.args[0] || (!data.args[0].tagName && !data.args[0].jquery)) { return; }\n\t\t\t\t\t\t\ts = this._get_settings().types.types;\n\t\t\t\t\t\t\tt = this._get_type(data.args[0]);\n\t\t\t\t\t\t\tif(\n\t\t\t\t\t\t\t\t(\n\t\t\t\t\t\t\t\t\t(s[t] && typeof s[t][data.func] !== \"undefined\") ||\n\t\t\t\t\t\t\t\t\t(s[\"default\"] && typeof s[\"default\"][data.func] !== \"undefined\")\n\t\t\t\t\t\t\t\t) && this._check(data.func, data.args[0]) === false\n\t\t\t\t\t\t\t) {\n\t\t\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\tif(is_ie6) {\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.bind(\"load_node.jstree set_type.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\tvar r = data && data.rslt && data.rslt.obj && data.rslt.obj !== -1 ? this._get_node(data.rslt.obj).parent() : this.get_container_ul(),\n\t\t\t\t\t\t\t\tc = false,\n\t\t\t\t\t\t\t\ts = this._get_settings().types;\n\t\t\t\t\t\t\t$.each(s.types, function (i, tp) {\n\t\t\t\t\t\t\t\tif(tp.icon && (tp.icon.image || tp.icon.position)) {\n\t\t\t\t\t\t\t\t\tc = i === \"default\" ? r.find(\"li > a > .jstree-icon\") : r.find(\"li[\" + s.type_attr + \"='\" + i + \"'] > a > .jstree-icon\");\n\t\t\t\t\t\t\t\t\tif(tp.icon.image) { c.css(\"backgroundImage\",\"url(\" + tp.icon.image + \")\"); }\n\t\t\t\t\t\t\t\t\tc.css(\"backgroundPosition\", tp.icon.position || \"0 0\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}, this));\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t// defines maximum number of root nodes (-1 means unlimited, -2 means disable max_children checking)\n\t\t\tmax_children\t\t: -1,\n\t\t\t// defines the maximum depth of the tree (-1 means unlimited, -2 means disable max_depth checking)\n\t\t\tmax_depth\t\t\t: -1,\n\t\t\t// defines valid node types for the root nodes\n\t\t\tvalid_children\t\t: \"all\",\n\n\t\t\t// whether to use $.data\n\t\t\tuse_data : false,\n\t\t\t// where is the type stores (the rel attribute of the LI element)\n\t\t\ttype_attr : \"rel\",\n\t\t\t// a list of types\n\t\t\ttypes : {\n\t\t\t\t// the default type\n\t\t\t\t\"default\" : {\n\t\t\t\t\t\"max_children\"\t: -1,\n\t\t\t\t\t\"max_depth\"\t\t: -1,\n\t\t\t\t\t\"valid_children\": \"all\"\n\n\t\t\t\t\t// Bound functions - you can bind any other function here (using boolean or function)\n\t\t\t\t\t//\"select_node\"\t: true\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\t_types_notify : function (n, data) {\n\t\t\t\tif(data.type && this._get_settings().types.use_data) {\n\t\t\t\t\tthis.set_type(data.type, n);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_get_type : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn (!obj || !obj.length) ? false : obj.attr(this._get_settings().types.type_attr) || \"default\";\n\t\t\t},\n\t\t\tset_type : function (str, obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar ret = (!obj.length || !str) ? false : obj.attr(this._get_settings().types.type_attr, str);\n\t\t\t\tif(ret) { this.__callback({ obj : obj, type : str}); }\n\t\t\t\treturn ret;\n\t\t\t},\n\t\t\t_check : function (rule, obj, opts) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar v = false, t = this._get_type(obj), d = 0, _this = this, s = this._get_settings().types, data = false;\n\t\t\t\tif(obj === -1) {\n\t\t\t\t\tif(!!s[rule]) { v = s[rule]; }\n\t\t\t\t\telse { return; }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(t === false) { return; }\n\t\t\t\t\tdata = s.use_data ? obj.data(\"jstree\") : false;\n\t\t\t\t\tif(data && data.types && typeof data.types[rule] !== \"undefined\") { v = data.types[rule]; }\n\t\t\t\t\telse if(!!s.types[t] && typeof s.types[t][rule] !== \"undefined\") { v = s.types[t][rule]; }\n\t\t\t\t\telse if(!!s.types[\"default\"] && typeof s.types[\"default\"][rule] !== \"undefined\") { v = s.types[\"default\"][rule]; }\n\t\t\t\t}\n\t\t\t\tif($.isFunction(v)) { v = v.call(this, obj); }\n\t\t\t\tif(rule === \"max_depth\" && obj !== -1 && opts !== false && s.max_depth !== -2 && v !== 0) {\n\t\t\t\t\t// also include the node itself - otherwise if root node it is not checked\n\t\t\t\t\tobj.children(\"a:eq(0)\").parentsUntil(\".jstree\",\"li\").each(function (i) {\n\t\t\t\t\t\t// check if current depth already exceeds global tree depth\n\t\t\t\t\t\tif(s.max_depth !== -1 && s.max_depth - (i + 1) <= 0) { v = 0; return false; }\n\t\t\t\t\t\td = (i === 0) ? v : _this._check(rule, this, false);\n\t\t\t\t\t\t// check if current node max depth is already matched or exceeded\n\t\t\t\t\t\tif(d !== -1 && d - (i + 1) <= 0) { v = 0; return false; }\n\t\t\t\t\t\t// otherwise - set the max depth to the current value minus current depth\n\t\t\t\t\t\tif(d >= 0 && (d - (i + 1) < v || v < 0) ) { v = d - (i + 1); }\n\t\t\t\t\t\t// if the global tree depth exists and it minus the nodes calculated so far is less than `v` or `v` is unlimited\n\t\t\t\t\t\tif(s.max_depth >= 0 && (s.max_depth - (i + 1) < v || v < 0) ) { v = s.max_depth - (i + 1); }\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar m  = this._get_move(),\n\t\t\t\t\ts  = m.rt._get_settings().types,\n\t\t\t\t\tmc = m.rt._check(\"max_children\", m.cr),\n\t\t\t\t\tmd = m.rt._check(\"max_depth\", m.cr),\n\t\t\t\t\tvc = m.rt._check(\"valid_children\", m.cr),\n\t\t\t\t\tch = 0, d = 1, t;\n\n\t\t\t\tif(vc === \"none\") { return false; }\n\t\t\t\tif($.isArray(vc) && m.ot && m.ot._get_type) {\n\t\t\t\t\tm.o.each(function () {\n\t\t\t\t\t\tif($.inArray(m.ot._get_type(this), vc) === -1) { d = false; return false; }\n\t\t\t\t\t});\n\t\t\t\t\tif(d === false) { return false; }\n\t\t\t\t}\n\t\t\t\tif(s.max_children !== -2 && mc !== -1) {\n\t\t\t\t\tch = m.cr === -1 ? this.get_container().find(\"> ul > li\").not(m.o).length : m.cr.find(\"> ul > li\").not(m.o).length;\n\t\t\t\t\tif(ch + m.o.length > mc) { return false; }\n\t\t\t\t}\n\t\t\t\tif(s.max_depth !== -2 && md !== -1) {\n\t\t\t\t\td = 0;\n\t\t\t\t\tif(md === 0) { return false; }\n\t\t\t\t\tif(typeof m.o.d === \"undefined\") {\n\t\t\t\t\t\t// TODO: deal with progressive rendering and async when checking max_depth (how to know the depth of the moved node)\n\t\t\t\t\t\tt = m.o;\n\t\t\t\t\t\twhile(t.length > 0) {\n\t\t\t\t\t\t\tt = t.find(\"> ul > li\");\n\t\t\t\t\t\t\td ++;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tm.o.d = d;\n\t\t\t\t\t}\n\t\t\t\t\tif(md - m.o.d < 0) { return false; }\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcreate_node : function (obj, position, js, callback, is_loaded, skip_check) {\n\t\t\t\tif(!skip_check && (is_loaded || this._is_loaded(obj))) {\n\t\t\t\t\tvar p  = (typeof position == \"string\" && position.match(/^before|after$/i) && obj !== -1) ? this._get_parent(obj) : this._get_node(obj),\n\t\t\t\t\t\ts  = this._get_settings().types,\n\t\t\t\t\t\tmc = this._check(\"max_children\", p),\n\t\t\t\t\t\tmd = this._check(\"max_depth\", p),\n\t\t\t\t\t\tvc = this._check(\"valid_children\", p),\n\t\t\t\t\t\tch;\n\t\t\t\t\tif(typeof js === \"string\") { js = { data : js }; }\n\t\t\t\t\tif(!js) { js = {}; }\n\t\t\t\t\tif(vc === \"none\") { return false; }\n\t\t\t\t\tif($.isArray(vc)) {\n\t\t\t\t\t\tif(!js.attr || !js.attr[s.type_attr]) {\n\t\t\t\t\t\t\tif(!js.attr) { js.attr = {}; }\n\t\t\t\t\t\t\tjs.attr[s.type_attr] = vc[0];\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($.inArray(js.attr[s.type_attr], vc) === -1) { return false; }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif(s.max_children !== -2 && mc !== -1) {\n\t\t\t\t\t\tch = p === -1 ? this.get_container().find(\"> ul > li\").length : p.find(\"> ul > li\").length;\n\t\t\t\t\t\tif(ch + 1 > mc) { return false; }\n\t\t\t\t\t}\n\t\t\t\t\tif(s.max_depth !== -2 && md !== -1 && (md - 1) < 0) { return false; }\n\t\t\t\t}\n\t\t\t\treturn this.__call_old(true, obj, position, js, callback, is_loaded, skip_check);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree HTML plugin\n * The HTML data store. Datastores are build by replacing the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.jstree.plugin(\"html_data\", {\n\t\t__init : function () {\n\t\t\t// this used to use html() and clean the whitespace, but this way any attached data was lost\n\t\t\tthis.data.html_data.original_container_html = this.get_container().find(\" > ul > li\").clone(true);\n\t\t\t// remove white space from LI node - otherwise nodes appear a bit to the right\n\t\t\tthis.data.html_data.original_container_html.find(\"li\").addBack().contents().filter(function() { return this.nodeType == 3; }).remove();\n\t\t},\n\t\tdefaults : {\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\tcorrect_state : true\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_html(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!this._get_settings().html_data.ajax && !$.isFunction(this._get_settings().html_data.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").size() > 0;\n\t\t\t},\n\t\t\tload_node_html : function (obj, s_call, e_call) {\n\t\t\t\tvar d,\n\t\t\t\t\ts = this.get_settings().html_data,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\tif(d && d !== \"\" && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") !== \"\") {\n\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\t\tif(obj == -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()).find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); }\n\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d).children(\"ul\").find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !s.ajax):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t\t.children(\"ul\").empty()\n\t\t\t\t\t\t\t\t.append(this.data.html_data.original_container_html)\n\t\t\t\t\t\t\t\t.find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end()\n\t\t\t\t\t\t\t\t.filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\");\n\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\td = $(s.data);\n\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t\t.children(\"ul\").empty().append(d.children())\n\t\t\t\t\t\t\t\t.find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end()\n\t\t\t\t\t\t\t\t.filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\");\n\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().html_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj != -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\tvar sf = this.get_settings().html_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\")) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\t\tif(obj == -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()).find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); }\n\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d).children(\"ul\").find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"html\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t// include the HTML data plugin by default\n\t$.jstree.defaults.plugins.push(\"html_data\");\n})(jQuery);\n//*/\n\n/*\n * jsTree themeroller plugin\n * Adds support for jQuery UI themes. Include this at the end of your plugins list, also make sure \"themes\" is not included.\n */\n(function ($) {\n\t$.jstree.plugin(\"themeroller\", {\n\t\t__init : function () {\n\t\t\tvar s = this._get_settings().themeroller;\n\t\t\tthis.get_container()\n\t\t\t\t.addClass(\"ui-widget-content\")\n\t\t\t\t.addClass(\"jstree-themeroller\")\n\t\t\t\t.delegate(\"a\",\"mouseenter.jstree\", function (e) {\n\t\t\t\t\tif(!$(e.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t$(this).addClass(s.item_h);\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.delegate(\"a\",\"mouseleave.jstree\", function () {\n\t\t\t\t\t$(this).removeClass(s.item_h);\n\t\t\t\t})\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.inst.get_container().find(\"> ul > li > .jstree-loading > ins\").addClass(\"ui-icon-refresh\");\n\t\t\t\t\t\tthis._themeroller(data.inst.get_container().find(\"> ul > li\"));\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree refresh.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tthis._themeroller();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"close_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"delete_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.parent);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"correct_state.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.opened + \" \" + s.closed + \" ui-icon\").end()\n\t\t\t\t\t\t\t.find(\"> a > ins.ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_open + \" \" + s.item_clsd).addClass(s.item_leaf || \"jstree-no-icon\");\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"select_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").addClass(s.item_a);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"deselect_node.jstree deselect_all.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t.find(\"a.\" + s.item_a).removeClass(s.item_a).end()\n\t\t\t\t\t\t\t.find(\"a.jstree-clicked\").addClass(s.item_a);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"dehover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").removeClass(s.item_h);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"hover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t.find(\"a.\" + s.item_h).not(data.rslt.obj).removeClass(s.item_h);\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").addClass(s.item_h);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.o);\n\t\t\t\t\t\tthis._themeroller(data.rslt.op);\n\t\t\t\t\t}, this));\n\t\t},\n\t\t__destroy : function () {\n\t\t\tvar s = this._get_settings().themeroller,\n\t\t\t\tc = [ \"ui-icon\" ];\n\t\t\t$.each(s, function (i, v) {\n\t\t\t\tv = v.split(\" \");\n\t\t\t\tif(v.length) { c = c.concat(v); }\n\t\t\t});\n\t\t\tthis.get_container()\n\t\t\t\t.removeClass(\"ui-widget-content\")\n\t\t\t\t.find(\".\" + c.join(\", .\")).removeClass(c.join(\" \"));\n\t\t},\n\t\t_fn : {\n\t\t\t_themeroller : function (obj) {\n\t\t\t\tvar s = this._get_settings().themeroller;\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container_ul() : this._get_node(obj).parent();\n\t\t\t\tobj\n\t\t\t\t\t.find(\"li.jstree-closed\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.opened).addClass(\"ui-icon \" + s.closed).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_leaf + \" \" + s.item_open).addClass(s.item_clsd || \"jstree-no-icon\")\n\t\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.end()\n\t\t\t\t\t.end()\n\t\t\t\t\t.find(\"li.jstree-open\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.closed).addClass(\"ui-icon \" + s.opened).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_leaf + \" \" + s.item_clsd).addClass(s.item_open || \"jstree-no-icon\")\n\t\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.end()\n\t\t\t\t\t.end()\n\t\t\t\t\t.find(\"li.jstree-leaf\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.closed + \" ui-icon \" + s.opened).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_clsd + \" \" + s.item_open).addClass(s.item_leaf || \"jstree-no-icon\");\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t\"opened\"\t: \"ui-icon-triangle-1-se\",\n\t\t\t\"closed\"\t: \"ui-icon-triangle-1-e\",\n\t\t\t\"item\"\t\t: \"ui-state-default\",\n\t\t\t\"item_h\"\t: \"ui-state-hover\",\n\t\t\t\"item_a\"\t: \"ui-state-active\",\n\t\t\t\"item_open\"\t: \"ui-icon-folder-open\",\n\t\t\t\"item_clsd\"\t: \"ui-icon-folder-collapsed\",\n\t\t\t\"item_leaf\"\t: \"ui-icon-document\"\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'.jstree-themeroller .ui-icon { overflow:visible; } ' +\n\t\t\t'.jstree-themeroller a { padding:0 2px; } ' +\n\t\t\t'.jstree-themeroller .jstree-no-icon { display:none; }';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree unique plugin\n * Forces different names amongst siblings (still a bit experimental)\n * NOTE: does not check language versions (it will not be possible to have nodes with the same title, even in different languages)\n */\n(function ($) {\n\t$.jstree.plugin(\"unique\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"before.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar nms = [], res = true, p, t;\n\t\t\t\t\t\tif(data.func == \"move_node\") {\n\t\t\t\t\t\t\t// obj, ref, position, is_copy, is_prepared, skip_check\n\t\t\t\t\t\t\tif(data.args[4] === true) {\n\t\t\t\t\t\t\t\tif(data.args[0].o && data.args[0].o.length) {\n\t\t\t\t\t\t\t\t\tdata.args[0].o.children(\"a\").each(function () { nms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\t\t\t\t\t\tres = this._check_unique(nms, data.args[0].np.find(\"> ul > li\").not(data.args[0].o), \"move_node\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(data.func == \"create_node\") {\n\t\t\t\t\t\t\t// obj, position, js, callback, is_loaded\n\t\t\t\t\t\t\tif(data.args[4] || this._is_loaded(data.args[0])) {\n\t\t\t\t\t\t\t\tp = this._get_node(data.args[0]);\n\t\t\t\t\t\t\t\tif(data.args[1] && (data.args[1] === \"before\" || data.args[1] === \"after\")) {\n\t\t\t\t\t\t\t\t\tp = this._get_parent(data.args[0]);\n\t\t\t\t\t\t\t\t\tif(!p || p === -1) { p = this.get_container(); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(typeof data.args[2] === \"string\") { nms.push(data.args[2]); }\n\t\t\t\t\t\t\t\telse if(!data.args[2] || !data.args[2].data) { nms.push(this._get_string(\"new_node\")); }\n\t\t\t\t\t\t\t\telse { nms.push(data.args[2].data); }\n\t\t\t\t\t\t\t\tres = this._check_unique(nms, p.find(\"> ul > li\"), \"create_node\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(data.func == \"rename_node\") {\n\t\t\t\t\t\t\t// obj, val\n\t\t\t\t\t\t\tnms.push(data.args[1]);\n\t\t\t\t\t\t\tt = this._get_node(data.args[0]);\n\t\t\t\t\t\t\tp = this._get_parent(t);\n\t\t\t\t\t\t\tif(!p || p === -1) { p = this.get_container(); }\n\t\t\t\t\t\t\tres = this._check_unique(nms, p.find(\"> ul > li\").not(t), \"rename_node\");\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!res) {\n\t\t\t\t\t\t\te.stopPropagation();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\terror_callback : $.noop\n\t\t},\n\t\t_fn : {\n\t\t\t_check_unique : function (nms, p, func) {\n\t\t\t\tvar cnms = [];\n\t\t\t\tp.children(\"a\").each(function () { cnms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\tif(!cnms.length || !nms.length) { return true; }\n\t\t\t\tcnms = cnms.sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\");\n\t\t\t\tif((cnms.length + nms.length) != cnms.concat(nms).sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\").length) {\n\t\t\t\t\tthis._get_settings().unique.error_callback.call(null, nms, p, func);\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar p = this._get_move(), nms = [];\n\t\t\t\tif(p.o && p.o.length) {\n\t\t\t\t\tp.o.children(\"a\").each(function () { nms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\t\treturn this._check_unique(nms, p.np.find(\"> ul > li\").not(p.o), \"check_move\");\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree wholerow plugin\n * Makes select and hover work on the entire width of the node\n * MAY BE HEAVY IN LARGE DOM\n */\n(function ($) {\n\t$.jstree.plugin(\"wholerow\", {\n\t\t__init : function () {\n\t\t\tif(!this.data.ui) { throw \"jsTree wholerow: jsTree UI plugin not included.\"; }\n\t\t\tthis.data.wholerow.html = false;\n\t\t\tthis.data.wholerow.to = false;\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._get_settings().core.animation = 0;\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree clean_node.jstree loaded.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._prepare_wholerow_span( data && data.rslt && data.rslt.obj ? data.rslt.obj : -1 );\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"search.jstree clear_search.jstree reopen.jstree after_open.jstree after_close.jstree create_node.jstree delete_node.jstree clean_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tif(this.data.to) { clearTimeout(this.data.to); }\n\t\t\t\t\t\tthis.data.to = setTimeout( (function (t, o) { return function() { t._prepare_wholerow_ul(o); }; })(this,  data && data.rslt && data.rslt.obj ? data.rslt.obj : -1), 0);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"deselect_all.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container().find(\" > .jstree-wholerow .jstree-clicked\").removeClass(\"jstree-clicked \" + (this.data.themeroller ? this._get_settings().themeroller.item_a : \"\" ));\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"select_node.jstree deselect_node.jstree \", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.each(function () {\n\t\t\t\t\t\t\tvar ref = data.inst.get_container().find(\" > .jstree-wholerow li:visible:eq(\" + ( parseInt((($(this).offset().top - data.inst.get_container().offset().top + data.inst.get_container()[0].scrollTop) / data.inst.data.core.li_height),10)) + \")\");\n\t\t\t\t\t\t\t// ref.children(\"a\")[e.type === \"select_node\" ? \"addClass\" : \"removeClass\"](\"jstree-clicked\");\n\t\t\t\t\t\t\tref.children(\"a\").attr(\"class\",data.rslt.obj.children(\"a\").attr(\"class\"));\n\t\t\t\t\t\t});\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"hover_node.jstree dehover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container().find(\" > .jstree-wholerow .jstree-hovered\").removeClass(\"jstree-hovered \" + (this.data.themeroller ? this._get_settings().themeroller.item_h : \"\" ));\n\t\t\t\t\t\tif(e.type === \"hover_node\") {\n\t\t\t\t\t\t\tvar ref = this.get_container().find(\" > .jstree-wholerow li:visible:eq(\" + ( parseInt(((data.rslt.obj.offset().top - this.get_container().offset().top + this.get_container()[0].scrollTop) / this.data.core.li_height),10)) + \")\");\n\t\t\t\t\t\t\t// ref.children(\"a\").addClass(\"jstree-hovered\");\n\t\t\t\t\t\t\tref.children(\"a\").attr(\"class\",data.rslt.obj.children(\".jstree-hovered\").attr(\"class\"));\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\".jstree-wholerow-span, ins.jstree-icon, li\", \"click.jstree\", function (e) {\n\t\t\t\t\t\tvar n = $(e.currentTarget);\n\t\t\t\t\t\tif(e.target.tagName === \"A\" || (e.target.tagName === \"INS\" && n.closest(\"li\").is(\".jstree-open, .jstree-closed\"))) { return; }\n\t\t\t\t\t\tn.closest(\"li\").children(\"a:visible:eq(0)\").click();\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t})\n\t\t\t\t.delegate(\"li\", \"mouseover.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\tif($(e.currentTarget).children(\".jstree-hovered, .jstree-clicked\").length) { return false; }\n\t\t\t\t\t\tthis.hover_node(e.currentTarget);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"li\", \"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($(e.currentTarget).children(\"a\").hasClass(\"jstree-hovered\").length) { return; }\n\t\t\t\t\t\tthis.dehover_node(e.currentTarget);\n\t\t\t\t\t}, this));\n\t\t\tif(is_ie7 || is_ie6) {\n\t\t\t\t$.vakata.css.add_sheet({ str : \".jstree-\" + this.get_index() + \" { position:relative; } \", title : \"jstree\" });\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t},\n\t\t__destroy : function () {\n\t\t\tthis.get_container().children(\".jstree-wholerow\").remove();\n\t\t\tthis.get_container().find(\".jstree-wholerow-span\").remove();\n\t\t},\n\t\t_fn : {\n\t\t\t_prepare_wholerow_span : function (obj) {\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n\t\t\t\tif(obj === false) { return; } // added for removing root nodes\n\t\t\t\tobj.each(function () {\n\t\t\t\t\t$(this).find(\"li\").addBack().each(function () {\n\t\t\t\t\t\tvar $t = $(this);\n\t\t\t\t\t\tif($t.children(\".jstree-wholerow-span\").length) { return true; }\n\t\t\t\t\t\t$t.prepend(\"<span class='jstree-wholerow-span' style='width:\" + ($t.parentsUntil(\".jstree\",\"li\").length * 18) + \"px;'>&#160;</span>\");\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t},\n\t\t\t_prepare_wholerow_ul : function () {\n\t\t\t\tvar o = this.get_container().children(\"ul\").eq(0), h = o.html();\n\t\t\t\to.addClass(\"jstree-wholerow-real\");\n\t\t\t\tif(this.data.wholerow.last_html !== h) {\n\t\t\t\t\tthis.data.wholerow.last_html = h;\n\t\t\t\t\tthis.get_container().children(\".jstree-wholerow\").remove();\n\t\t\t\t\tthis.get_container().append(\n\t\t\t\t\t\to.clone().removeClass(\"jstree-wholerow-real\")\n\t\t\t\t\t\t\t.wrapAll(\"<div class='jstree-wholerow' />\").parent()\n\t\t\t\t\t\t\t.width(o.parent()[0].scrollWidth)\n\t\t\t\t\t\t\t.css(\"top\", (o.height() + ( is_ie7 ? 5 : 0)) * -1 )\n\t\t\t\t\t\t\t.find(\"li[id]\").each(function () { this.removeAttribute(\"id\"); }).end()\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'.jstree .jstree-wholerow-real { position:relative; z-index:1; } ' +\n\t\t\t'.jstree .jstree-wholerow-real li { cursor:pointer; } ' +\n\t\t\t'.jstree .jstree-wholerow-real a { border-left-color:transparent !important; border-right-color:transparent !important; } ' +\n\t\t\t'.jstree .jstree-wholerow { position:relative; z-index:0; height:0; } ' +\n\t\t\t'.jstree .jstree-wholerow ul, .jstree .jstree-wholerow li { width:100%; } ' +\n\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow li, .jstree .jstree-wholerow a { margin:0 !important; padding:0 !important; } ' +\n\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow li { background:transparent !important; }' +\n\t\t\t'.jstree .jstree-wholerow ins, .jstree .jstree-wholerow span, .jstree .jstree-wholerow input { display:none !important; }' +\n\t\t\t'.jstree .jstree-wholerow a, .jstree .jstree-wholerow a:hover { text-indent:-9999px; !important; width:100%; padding:0 !important; border-right-width:0px !important; border-left-width:0px !important; } ' +\n\t\t\t'.jstree .jstree-wholerow-span { position:absolute; left:0; margin:0px; padding:0; height:18px; border-width:0; padding:0; z-index:0; }';\n\t\tif(is_ff2) {\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree .jstree-wholerow a { display:block; height:18px; margin:0; padding:0; border:0; } ' +\n\t\t\t\t'.jstree .jstree-wholerow-real a { border-color:transparent !important; } ';\n\t\t}\n\t\tif(is_ie7 || is_ie6) {\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow li, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow a { margin:0; padding:0; line-height:18px; } ' +\n\t\t\t\t'.jstree .jstree-wholerow a { display:block; height:18px; line-height:18px; overflow:hidden; } ';\n\t\t}\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n* jsTree model plugin\n* This plugin gets jstree to use a class model to retrieve data, creating great dynamism\n*/\n(function ($) {\n\tvar nodeInterface = [\"getChildren\",\"getChildrenCount\",\"getAttr\",\"getName\",\"getProps\"],\n\t\tvalidateInterface = function(obj, inter) {\n\t\t\tvar valid = true;\n\t\t\tobj = obj || {};\n\t\t\tinter = [].concat(inter);\n\t\t\t$.each(inter, function (i, v) {\n\t\t\t\tif(!$.isFunction(obj[v])) { valid = false; return false; }\n\t\t\t});\n\t\t\treturn valid;\n\t\t};\n\t$.jstree.plugin(\"model\", {\n\t\t__init : function () {\n\t\t\tif(!this.data.json_data) { throw \"jsTree model: jsTree json_data plugin not included.\"; }\n\t\t\tthis._get_settings().json_data.data = function (n, b) {\n\t\t\t\tvar obj = (n == -1) ? this._get_settings().model.object : n.data(\"jstree_model\");\n\t\t\t\tif(!validateInterface(obj, nodeInterface)) { return b.call(null, false); }\n\t\t\t\tif(this._get_settings().model.async) {\n\t\t\t\t\tobj.getChildren($.proxy(function (data) {\n\t\t\t\t\t\tthis.model_done(data, b);\n\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.model_done(obj.getChildren(), b);\n\t\t\t\t}\n\t\t\t};\n\t\t},\n\t\tdefaults : {\n\t\t\tobject : false,\n\t\t\tid_prefix : false,\n\t\t\tasync : false\n\t\t},\n\t\t_fn : {\n\t\t\tmodel_done : function (data, callback) {\n\t\t\t\tvar ret = [],\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this;\n\n\t\t\t\tif(!$.isArray(data)) { data = [data]; }\n\t\t\t\t$.each(data, function (i, nd) {\n\t\t\t\t\tvar r = nd.getProps() || {};\n\t\t\t\t\tr.attr = nd.getAttr() || {};\n\t\t\t\t\tif(nd.getChildrenCount()) { r.state = \"closed\"; }\n\t\t\t\t\tr.data = nd.getName();\n\t\t\t\t\tif(!$.isArray(r.data)) { r.data = [r.data]; }\n\t\t\t\t\tif(_this.data.types && $.isFunction(nd.getType)) {\n\t\t\t\t\t\tr.attr[s.types.type_attr] = nd.getType();\n\t\t\t\t\t}\n\t\t\t\t\tif(r.attr.id && s.model.id_prefix) { r.attr.id = s.model.id_prefix + r.attr.id; }\n\t\t\t\t\tif(!r.metadata) { r.metadata = { }; }\n\t\t\t\t\tr.metadata.jstree_model = nd;\n\t\t\t\t\tret.push(r);\n\t\t\t\t});\n\t\t\t\tcallback.call(null, ret);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n\n/*\n * jsTree checkbox plugin copy-paste\n * change_state method was modified\n * refactoring is needed after update to a newer version of jstree, that supports plugin extending\n */\n(function ($) {\n    $.jstree.plugin(\"vcheckbox\", {\n        __init : function () {\n            this.data.vcheckbox.noui = this._get_settings().vcheckbox.override_ui;\n            if(this.data.ui && this.data.vcheckbox.noui) {\n                this.select_node = this.deselect_node = this.deselect_all = $.noop;\n                this.get_selected = this.get_checked;\n            }\n\n            this.get_container()\n                .bind(\"open_node.jstree create_node.jstree clean_node.jstree refresh.jstree\", $.proxy(function (e, data) {\n                    this._prepare_checkboxes(data.rslt.obj);\n                }, this))\n                .bind(\"loaded.jstree\", $.proxy(function (e) {\n                    this._prepare_checkboxes();\n                }, this))\n                .delegate( (this.data.ui && this.data.vcheckbox.noui ? \"a\" : \"ins.jstree-checkbox\") , \"click.jstree\", $.proxy(function (e) {\n                    e.preventDefault();\n                    if(this._get_node(e.target).hasClass(\"jstree-checked\")) { this.uncheck_node(e.target); }\n                    else { this.check_node(e.target); }\n                    if(this.data.ui && this.data.vcheckbox.noui) {\n                        this.save_selected();\n                        if(this.data.cookies) { this.save_cookie(\"select_node\"); }\n                    }\n                    else {\n                        e.stopImmediatePropagation();\n                        return false;\n                    }\n                }, this));\n        },\n        defaults : {\n            override_ui : false,\n            two_state : false,\n            real_checkboxes : false,\n            checked_parent_open : true,\n            real_checkboxes_names : function (n) { return [ (\"check_\" + (n[0].id || Math.ceil(Math.random() * 10000))) , 1]; }\n        },\n        __destroy : function () {\n            this.get_container()\n                .find(\"input.jstree-real-checkbox\").removeClass(\"jstree-real-checkbox\").end()\n                .find(\"ins.jstree-checkbox\").remove();\n        },\n        _fn : {\n            _checkbox_notify : function (n, data) {\n                if(data.checked) {\n                    this.check_node(n, false);\n                }\n            },\n            _prepare_checkboxes : function (obj) {\n                obj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n                if(obj === false) { return; } // added for removing root nodes\n                var c, _this = this, t, ts = this._get_settings().vcheckbox.two_state, rc = this._get_settings().vcheckbox.real_checkboxes, rcn = this._get_settings().vcheckbox.real_checkboxes_names;\n                obj.each(function () {\n                    t = $(this);\n                    c = t.is(\"li\") && (t.hasClass(\"jstree-checked\") || (rc && t.children(\":checked\").length)) ? \"jstree-checked\" : \"jstree-unchecked\";\n                    t.find(\"li\").addBack().each(function () {\n                        var $t = $(this), nm;\n                        $t.children(\"a\" + (_this.data.languages ? \"\" : \":eq(0)\") ).not(\":has(.jstree-checkbox)\").prepend(\"<ins class='jstree-checkbox'>&#160;</ins>\").parent().not(\".jstree-checked, .jstree-unchecked\").addClass( ts ? \"jstree-unchecked\" : c );\n                        if(rc) {\n                            if(!$t.children(\":checkbox\").length) {\n                                nm = rcn.call(_this, $t);\n                                $t.prepend(\"<input type='checkbox' class='jstree-real-checkbox' id='\" + nm[0] + \"' name='\" + nm[0] + \"' value='\" + nm[1] + \"' />\");\n                            }\n                            else {\n                                $t.children(\":checkbox\").addClass(\"jstree-real-checkbox\");\n                            }\n                        }\n                        if(!ts) {\n                            if(c === \"jstree-checked\" || $t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n                                $t.find(\"li\").addBack().addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n                            }\n                        }\n                        else {\n                            if($t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n                                $t.addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n                            }\n                        }\n                    });\n                });\n                if(!ts) {\n                    obj.find(\".jstree-checked\").parent().parent().each(function () { _this._repair_state(this); });\n                }\n            },\n            change_state : function (obj, state) {\n                obj = this._get_node(obj);\n                var coll = false, rc = this._get_settings().vcheckbox.real_checkboxes;\n                if(!obj || obj === -1) { return false; }\n                state = (state === false || state === true) ? state : obj.hasClass(\"jstree-checked\");\n                if(this._get_settings().vcheckbox.two_state) {\n                    if(state) {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-checked\").length) { return false; }\n                        coll.removeClass(\"jstree-checked\").addClass(\"jstree-unchecked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n                    }\n                    else {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-unchecked\").length) { return false; }\n                        coll.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n                        if(this.data.ui) { this.data.ui.last_selected = obj; }\n                        this.data.vcheckbox.last_selected = obj;\n                    }\n                    obj.parentsUntil(\".jstree\", \"li\").each(function () {\n                        var $this = $(this);\n                        if(state) {\n                            if($this.children(\"ul\").children(\"li.jstree-checked\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", true); }\n                                return false;\n                            }\n                        }\n                        else {\n                            if($this.children(\"ul\").children(\"li.jstree-unchecked\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", true); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n                            }\n                        }\n                    });\n                }\n                else {\n                    if(state) {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-checked, .jstree-undetermined\").length) { return false; }\n                        coll.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n                    }\n                    else {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-unchecked, .jstree-undetermined\").length) { return false; }\n                        coll.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n                        if(this.data.ui) { this.data.ui.last_selected = obj; }\n                        this.data.vcheckbox.last_selected = obj;\n                    }\n                    obj.parentsUntil(\".jstree\", \"li\").each(function () {\n                        var $this = $(this);\n                        if(state) {\n                            if($this.children(\"ul\").children(\"li.jstree-checked, li.jstree-undetermined\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", false); }\n                            }\n                        }\n                        else {\n                            if($this.children(\"ul\").children(\"li.jstree-unchecked, li.jstree-undetermined\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n                            }\n                        }\n                    });\n                }\n                if(this.data.ui && this.data.vcheckbox.noui) { this.data.ui.selected = this.get_checked(); }\n                this.__callback(obj);\n                return true;\n            },\n            check_node : function (obj) {\n                if(this.change_state(obj, false)) {\n                    obj = this._get_node(obj);\n                    if(this._get_settings().vcheckbox.checked_parent_open) {\n                        var t = this;\n                        obj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n                    }\n                    this.__callback({ \"obj\" : obj });\n                }\n            },\n            uncheck_node : function (obj) {\n                if(this.change_state(obj, true)) { this.__callback({ \"obj\" : this._get_node(obj) }); }\n            },\n            check_all : function () {\n                var _this = this,\n                    coll = this._get_settings().vcheckbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n                coll.each(function () {\n                    _this.change_state(this, false);\n                });\n                this.__callback();\n            },\n            uncheck_all : function () {\n                var _this = this,\n                    coll = this._get_settings().vcheckbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n                coll.each(function () {\n                    _this.change_state(this, true);\n                });\n                this.__callback();\n            },\n\n            is_checked : function(obj) {\n                obj = this._get_node(obj);\n                return obj.length ? obj.is(\".jstree-checked\") : false;\n            },\n            get_checked : function (obj, get_all) {\n                obj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n                return get_all || this._get_settings().vcheckbox.two_state ? obj.find(\".jstree-checked\") : obj.find(\"> ul > .jstree-checked, .jstree-undetermined > ul > .jstree-checked\");\n            },\n            get_unchecked : function (obj, get_all) {\n                obj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n                return get_all || this._get_settings().vcheckbox.two_state ? obj.find(\".jstree-unchecked\") : obj.find(\"> ul > .jstree-unchecked, .jstree-undetermined > ul > .jstree-unchecked\");\n            },\n\n            show_checkboxes : function () { this.get_container().children(\"ul\").removeClass(\"jstree-no-checkboxes\"); },\n            hide_checkboxes : function () { this.get_container().children(\"ul\").addClass(\"jstree-no-checkboxes\"); },\n\n            _repair_state : function (obj) {\n                obj = this._get_node(obj);\n                if(!obj.length) { return; }\n                if(this._get_settings().vcheckbox.two_state) {\n                    obj.find('li').addBack().not('.jstree-checked').removeClass('jstree-undetermined').addClass('jstree-unchecked').children(':checkbox').prop('checked', true);\n                    return;\n                }\n                var rc = this._get_settings().vcheckbox.real_checkboxes,\n                    a = obj.find(\"> ul > .jstree-checked\").length,\n                    b = obj.find(\"> ul > .jstree-undetermined\").length,\n                    c = obj.find(\"> ul > li\").length;\n                if(c === 0) { if(obj.hasClass(\"jstree-undetermined\")) { this.change_state(obj, false); } }\n                else if(a === 0 && b === 0) { this.change_state(obj, true); }\n                else if(a === c) { this.change_state(obj, false); }\n                else {\n                    obj.parentsUntil(\".jstree\",\"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                    if(rc) { obj.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                }\n            },\n            reselect : function () {\n                if(this.data.ui && this.data.vcheckbox.noui) {\n                    var _this = this,\n                        s = this.data.ui.to_select;\n                    s = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n                    this.deselect_all();\n                    $.each(s, function (i, val) { _this.check_node(val); });\n                    this.__callback();\n                }\n                else {\n                    this.__call_old();\n                }\n            },\n            save_loaded : function () {\n                var _this = this;\n                this.data.core.to_load = [];\n                this.get_container_ul().find(\"li.jstree-closed.jstree-undetermined\").each(function () {\n                    if(this.id) { _this.data.core.to_load.push(\"#\" + this.id); }\n                });\n            }\n        }\n    });\n    $(function() {\n        var css_string = '.jstree .jstree-real-checkbox { display:none; } ';\n        $.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n    });\n})(jQuery);\n\n\n})();\n\n}));","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiated by prepareExports, accounting for which module loader is being used.\n  var weakMapFactory;\n\n  // Extends a Knockout instance with Knockout-ES5 functionality\n  function attachToKo(ko) {\n    ko.track = track;\n    ko.untrack = untrack;\n    ko.getObservable = getObservable;\n    ko.valueHasMutated = valueHasMutated;\n    ko.defineProperty = defineComputedProperty;\n\n    // todo: test it, maybe added it to ko. directly\n    ko.es5 = {\n      getAllObservablesForObject: getAllObservablesForObject,\n      notifyWhenPresentOrFutureArrayValuesMutate: notifyWhenPresentOrFutureArrayValuesMutate,\n      isTracked: isTracked\n    };\n  }\n\n  // Determines which module loading scenario we're in, grabs dependencies, and attaches to KO\n  function prepareExports() {\n    if (typeof exports === 'object' && typeof module === 'object') {\n      // Node.js case - load KO and WeakMap modules synchronously\n      ko = require('knockout');\n      var WM = require('../lib/weakmap');\n      attachToKo(ko);\n      weakMapFactory = function() { return new WM(); };\n      module.exports = ko;\n    } else if (typeof define === 'function' && define.amd) {\n      define(['knockout'], function(koModule) {\n        ko = koModule;\n        attachToKo(koModule);\n        weakMapFactory = function() { return new global.WeakMap(); };\n        return koModule;\n      });\n    } else if ('ko' in global) {\n      // Non-module case - attach to the global instance, and assume a global WeakMap constructor\n      ko = global.ko;\n      attachToKo(global.ko);\n      weakMapFactory = function() { return new global.WeakMap(); };\n    }\n  }\n\n  prepareExports();\n\n})(this);","knockoutjs/knockout-fast-foreach.js":"/*!\n  Knockout Fast Foreach v0.4.1 (2015-07-17T14:06:15.974Z)\n  By: Brian M Hunt (C) 2015\n  License: MIT\n\n  Adds `fastForEach` to `ko.bindingHandlers`.\n*/\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    define(['knockout'], factory);\n  } else if (typeof exports === 'object') {\n    module.exports = factory(require('knockout'));\n  } else {\n    root.KnockoutFastForeach = factory(root.ko);\n  }\n}(this, function (ko) {\n  \"use strict\";\n// index.js\n// --------\n// Fast For Each\n//\n// Employing sound techniques to make a faster Knockout foreach binding.\n// --------\n\n//      Utilities\n\n// from https://github.com/jonschlinkert/is-plain-object\nfunction isPlainObject(o) {\n  return !!o && typeof o === 'object' && o.constructor === Object;\n}\n\n// From knockout/src/virtualElements.js\nvar commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\nvar startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\nvar supportsDocumentFragment = document && typeof document.createDocumentFragment === \"function\";\nfunction isVirtualNode(node) {\n  return (node.nodeType === 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n}\n\n\n// Get a copy of the (possibly virtual) child nodes of the given element,\n// put them into a container, then empty the given node.\nfunction makeTemplateNode(sourceNode) {\n  var container = document.createElement(\"div\");\n  var parentNode;\n  if (sourceNode.content) {\n    // For e.g. <template> tags\n    parentNode = sourceNode.content;\n  } else if (sourceNode.tagName === 'SCRIPT') {\n    parentNode = document.createElement(\"div\");\n    parentNode.innerHTML = sourceNode.text;\n  } else {\n    // Anything else e.g. <div>\n    parentNode = sourceNode;\n  }\n  ko.utils.arrayForEach(ko.virtualElements.childNodes(parentNode), function (child) {\n    // FIXME - This cloneNode could be expensive; we may prefer to iterate over the\n    // parentNode children in reverse (so as not to foul the indexes as childNodes are\n    // removed from parentNode when inserted into the container)\n    if (child) {\n      container.insertBefore(child.cloneNode(true), null);\n    }\n  });\n  return container;\n}\n\nfunction insertAllAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode) {\n  var frag, len, i;\n  // poor man's node and array check, should be enough for this\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\" && typeof nodeOrNodeArrayToInsert.length === \"undefined\") {\n    throw new Error(\"Expected a single node or a node array\");\n  }\n\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\") {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode);\n    return;\n  }\n\n  if (nodeOrNodeArrayToInsert.length === 1) {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert[0], insertAfterNode);\n    return;\n  }\n\n  if (supportsDocumentFragment) {\n    frag = document.createDocumentFragment();\n\n    for (i = 0, len = nodeOrNodeArrayToInsert.length; i !== len; ++i) {\n      frag.appendChild(nodeOrNodeArrayToInsert[i]);\n    }\n    ko.virtualElements.insertAfter(containerNode, frag, insertAfterNode);\n  } else {\n    // Nodes are inserted in reverse order - pushed down immediately after\n    // the last node for the previous item or as the first node of element.\n    for (i = nodeOrNodeArrayToInsert.length - 1; i >= 0; --i) {\n      var child = nodeOrNodeArrayToInsert[i];\n      if (!child) {\n        return;\n      }\n      ko.virtualElements.insertAfter(containerNode, child, insertAfterNode);\n    }\n  }\n}\n\n// Mimic a KO change item 'add'\nfunction valueToChangeAddItem(value, index) {\n  return {\n    status: 'added',\n    value: value,\n    index: index\n  };\n}\n\nfunction isAdditionAdjacentToLast(changeIndex, arrayChanges) {\n  return changeIndex > 0 &&\n    changeIndex < arrayChanges.length &&\n    arrayChanges[changeIndex].status === \"added\" &&\n    arrayChanges[changeIndex - 1].status === \"added\" &&\n    arrayChanges[changeIndex - 1].index === arrayChanges[changeIndex].index - 1;\n}\n\nfunction FastForEach(spec) {\n  this.element = spec.element;\n  this.container = isVirtualNode(this.element) ?\n                   this.element.parentNode : this.element;\n  this.$context = spec.$context;\n  this.data = spec.data;\n  this.as = spec.as;\n  this.noContext = spec.noContext;\n  this.templateNode = makeTemplateNode(\n    spec.name ? document.getElementById(spec.name).cloneNode(true) : spec.element\n  );\n  this.afterQueueFlush = spec.afterQueueFlush;\n  this.beforeQueueFlush = spec.beforeQueueFlush;\n  this.changeQueue = [];\n  this.lastNodesList = [];\n  this.indexesToDelete = [];\n  this.rendering_queued = false;\n\n  // Remove existing content.\n  ko.virtualElements.emptyNode(this.element);\n\n  // Prime content\n  var primeData = ko.unwrap(this.data);\n  if (primeData.map) {\n    this.onArrayChange(primeData.map(valueToChangeAddItem));\n  }\n\n  // Watch for changes\n  if (ko.isObservable(this.data)) {\n    if (!this.data.indexOf) {\n      // Make sure the observable is trackable.\n      this.data = this.data.extend({trackArrayChanges: true});\n    }\n    this.changeSubs = this.data.subscribe(this.onArrayChange, this, 'arrayChange');\n  }\n}\n\n\nFastForEach.animateFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame ||\n  window.mozRequestAnimationFrame || window.msRequestAnimationFrame ||\n  function(cb) { return window.setTimeout(cb, 1000 / 60); };\n\n\nFastForEach.prototype.dispose = function () {\n  if (this.changeSubs) {\n    this.changeSubs.dispose();\n  }\n};\n\n\n// If the array changes we register the change.\nFastForEach.prototype.onArrayChange = function (changeSet) {\n  var self = this;\n  var changeMap = {\n    added: [],\n    deleted: []\n  };\n  for (var i = 0, len = changeSet.length; i < len; i++) {\n    // the change is appended to a last change info object when both are 'added' and have indexes next to each other\n    // here I presume that ko is sending changes in monotonic order (in index variable) which happens to be true, tested with push and splice with multiple pushed values\n    if (isAdditionAdjacentToLast(i, changeSet)) {\n      var batchValues = changeMap.added[changeMap.added.length - 1].values;\n      if (!batchValues) {\n        // transform the last addition into a batch addition object\n        var lastAddition = changeMap.added.pop();\n        var batchAddition = {\n          isBatch: true,\n          status: 'added',\n          index: lastAddition.index,\n          values: [lastAddition.value]\n        };\n        batchValues = batchAddition.values;\n        changeMap.added.push(batchAddition);\n      }\n      batchValues.push(changeSet[i].value);\n    } else {\n      changeMap[changeSet[i].status].push(changeSet[i]);\n    }\n  }\n  if (changeMap.deleted.length > 0) {\n    this.changeQueue.push.apply(this.changeQueue, changeMap.deleted);\n    this.changeQueue.push({status: 'clearDeletedIndexes'});\n  }\n  this.changeQueue.push.apply(this.changeQueue, changeMap.added);\n  // Once a change is registered, the ticking count-down starts for the processQueue.\n  if (this.changeQueue.length > 0 && !this.rendering_queued) {\n    this.rendering_queued = true;\n    FastForEach.animateFrame.call(window, function () { self.processQueue(); });\n  }\n};\n\n\n// Reflect all the changes in the queue in the DOM, then wipe the queue.\nFastForEach.prototype.processQueue = function () {\n  var self = this;\n\n  // Callback so folks can do things before the queue flush.\n  if (typeof this.beforeQueueFlush === 'function') {\n    this.beforeQueueFlush(this.changeQueue);\n  }\n\n  ko.utils.arrayForEach(this.changeQueue, function (changeItem) {\n    // console.log(self.data(), \"CI\", JSON.stringify(changeItem, null, 2), JSON.stringify($(self.element).text()))\n    self[changeItem.status](changeItem);\n    // console.log(\"  ==> \", JSON.stringify($(self.element).text()))\n  });\n  this.rendering_queued = false;\n  // Callback so folks can do things.\n  if (typeof this.afterQueueFlush === 'function') {\n    this.afterQueueFlush(this.changeQueue);\n  }\n  this.changeQueue = [];\n};\n\n\n// Process a changeItem with {status: 'added', ...}\nFastForEach.prototype.added = function (changeItem) {\n  var index = changeItem.index;\n  var valuesToAdd = changeItem.isBatch ? changeItem.values : [changeItem.value];\n  var referenceElement = this.lastNodesList[index - 1] || null;\n  // gather all childnodes for a possible batch insertion\n  var allChildNodes = [];\n\n  for (var i = 0, len = valuesToAdd.length; i < len; ++i) {\n    var templateClone = this.templateNode.cloneNode(true);\n    var childContext;\n\n    if (this.noContext) {\n      childContext = this.$context.extend({\n        '$item': valuesToAdd[i]\n      });\n    } else {\n      childContext = this.$context.createChildContext(valuesToAdd[i], this.as || null);\n    }\n\n    // apply bindings first, and then process child nodes, because bindings can add childnodes\n    ko.applyBindingsToDescendants(childContext, templateClone);\n\n    var childNodes = ko.virtualElements.childNodes(templateClone);\n    // Note discussion at https://github.com/angular/angular.js/issues/7851\n    allChildNodes.push.apply(allChildNodes, Array.prototype.slice.call(childNodes));\n    this.lastNodesList.splice(index + i, 0, childNodes[childNodes.length - 1]);\n  }\n\n  insertAllAfter(this.element, allChildNodes, referenceElement);\n};\n\n\n// Process a changeItem with {status: 'deleted', ...}\nFastForEach.prototype.deleted = function (changeItem) {\n  var index = changeItem.index;\n  var ptr = this.lastNodesList[index],\n      // We use this.element because that will be the last previous node\n      // for virtual element lists.\n      lastNode = this.lastNodesList[index - 1] || this.element;\n  do {\n    ptr = ptr.previousSibling;\n    ko.removeNode((ptr && ptr.nextSibling) || ko.virtualElements.firstChild(this.element));\n  } while (ptr && ptr !== lastNode);\n  // The \"last node\" in the DOM from which we begin our delets of the next adjacent node is\n  // now the sibling that preceded the first node of this item.\n  this.lastNodesList[index] = this.lastNodesList[index - 1];\n  this.indexesToDelete.push(index);\n};\n\n\n// We batch our deletion of item indexes in our parallel array.\n// See brianmhunt/knockout-fast-foreach#6/#8\nFastForEach.prototype.clearDeletedIndexes = function () {\n  // We iterate in reverse on the presumption (following the unit tests) that KO's diff engine\n  // processes diffs (esp. deletes) monotonically ascending i.e. from index 0 -> N.\n  for (var i = this.indexesToDelete.length - 1; i >= 0; --i) {\n    this.lastNodesList.splice(this.indexesToDelete[i], 1);\n  }\n  this.indexesToDelete = [];\n};\n\n\nko.bindingHandlers.fastForEach = {\n  // Valid valueAccessors:\n  //    []\n  //    ko.observable([])\n  //    ko.observableArray([])\n  //    ko.computed\n  //    {data: array, name: string, as: string}\n  init: function init(element, valueAccessor, bindings, vm, context) {\n    var value = valueAccessor(),\n        ffe;\n    if (isPlainObject(value)) {\n      value.element = value.element || element;\n      value.$context = context;\n      ffe = new FastForEach(value);\n    } else {\n      ffe = new FastForEach({\n        element: element,\n        data: ko.unwrap(context.$rawData) === value ? context.$rawData : value,\n        $context: context\n      });\n    }\n    ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n      ffe.dispose();\n    });\n    return {controlsDescendantBindings: true};\n  },\n\n  // Export for testing, debugging, and overloading.\n  FastForEach: FastForEach\n};\n\nko.virtualElements.allowedBindings.fastForEach = true;\n}));","knockoutjs/knockout-repeat.js":"// REPEAT binding for Knockout http://knockoutjs.com/\n// (c) Michael Best\n// License: MIT (http://www.opensource.org/licenses/mit-license.php)\n// Version 2.1.0\n\n(function(factory) {\n    if (typeof define === 'function' && define.amd) {\n        // [1] AMD anonymous module\n        define(['knockout'], factory);\n    } else if (typeof exports === 'object') {\n        // [2] commonJS\n        factory(require('knockout'));\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko);\n    }\n})(function(ko) {\n\nif (!ko.virtualElements)\n    throw Error('Repeat requires at least Knockout 2.1');\n\nvar ko_bindingFlags = ko.bindingFlags || {};\nvar ko_unwrap = ko.utils.unwrapObservable;\n\nvar koProtoName = '__ko_proto__';\n\nif (ko.version >= \"3.0.0\") {\n    // In Knockout 3.0.0, use the node preprocessor to replace a node with a repeat binding with a virtual element\n    var provider = ko.bindingProvider.instance, previousPreprocessFn = provider.preprocessNode;\n    provider.preprocessNode = function(node) {\n        var newNodes, nodeBinding;\n        if (!previousPreprocessFn || !(newNodes = previousPreprocessFn.call(this, node))) {\n            if (node.nodeType === 1 && (nodeBinding = node.getAttribute('data-bind'))) {\n                if (/^\\s*repeat\\s*:/.test(nodeBinding)) {\n                    var leadingComment = node.ownerDocument.createComment('ko ' + nodeBinding),\n                        trailingComment = node.ownerDocument.createComment('/ko');\n                    node.parentNode.insertBefore(leadingComment, node);\n                    node.parentNode.insertBefore(trailingComment, node.nextSibling);\n                    node.removeAttribute('data-bind');\n                    newNodes = [leadingComment, node, trailingComment];\n                }\n            }\n        }\n        return newNodes;\n    };\n}\n\nko.virtualElements.allowedBindings.repeat = true;\nko.bindingHandlers.repeat = {\n    flags: ko_bindingFlags.contentBind | ko_bindingFlags.canUseVirtual,\n    init: function(element, valueAccessor, allBindingsAccessor, xxx, bindingContext) {\n\n        // Read and set fixed options--these options cannot be changed\n        var repeatParam = ko_unwrap(valueAccessor());\n        if (repeatParam && typeof repeatParam == 'object' && !('length' in repeatParam)) {\n            var repeatIndex = repeatParam.index,\n                repeatData = repeatParam.item,\n                repeatStep = repeatParam.step,\n                repeatReversed = repeatParam.reverse,\n                repeatBind = repeatParam.bind,\n                repeatInit = repeatParam.init,\n                repeatUpdate = repeatParam.update;\n        }\n        // Set default values for options that need it\n        repeatIndex = repeatIndex || '$index';\n        repeatData = repeatData || ko.bindingHandlers.repeat.itemName || '$item';\n        repeatStep = repeatStep || 1;\n        repeatReversed = repeatReversed || false;\n\n        var parent = element.parentNode, placeholder;\n        if (element.nodeType == 8) {    // virtual element\n            // Extract the \"children\" and find the single element node\n            var childNodes = ko.utils.arrayFilter(ko.virtualElements.childNodes(element), function(node) { return node.nodeType == 1;});\n            if (childNodes.length !== 1) {\n                throw Error(\"Repeat binding requires a single element to repeat\");\n            }\n            ko.virtualElements.emptyNode(element);\n\n            // The placeholder is the closing comment normally, or the opening comment if reversed\n            placeholder = repeatReversed ? element : element.nextSibling;\n            // The element to repeat is the contained element\n            element = childNodes[0];\n        } else {    // regular element\n            // First clean the element node and remove node's binding\n            var origBindString = element.getAttribute('data-bind');\n            ko.cleanNode(element);\n            element.removeAttribute('data-bind');\n\n            // Original element is no longer needed: delete it and create a placeholder comment\n            placeholder = element.ownerDocument.createComment('ko_repeatplaceholder ' + origBindString);\n            parent.replaceChild(placeholder, element);\n        }\n\n        // extract and remove a data-repeat-bind attribute, if present\n        if (!repeatBind) {\n            repeatBind = element.getAttribute('data-repeat-bind');\n            if (repeatBind) {\n                element.removeAttribute('data-repeat-bind');\n            }\n        }\n\n        // Make a copy of the element node to be copied for each repetition\n        var cleanNode = element.cloneNode(true);\n        if (typeof repeatBind == \"string\") {\n            cleanNode.setAttribute('data-bind', repeatBind);\n            repeatBind = null;\n        }\n\n        // Set up persistent data\n        var lastRepeatCount = 0,\n            notificationObservable = ko.observable(),\n            repeatArray, arrayObservable;\n\n        if (repeatInit) {\n            repeatInit(parent);\n        }\n\n        var subscribable = ko.computed(function() {\n            function makeArrayItemAccessor(index) {\n                var f = function(newValue) {\n                    var item = repeatArray[index];\n                    // Reading the value of the item\n                    if (!arguments.length) {\n                        notificationObservable();   // for dependency tracking\n                        return ko_unwrap(item);\n                    }\n                    // Writing a value to the item\n                    if (ko.isObservable(item)) {\n                        item(newValue);\n                    } else if (arrayObservable && arrayObservable.splice) {\n                        arrayObservable.splice(index, 1, newValue);\n                    } else {\n                        repeatArray[index] = newValue;\n                    }\n                    return this;\n                };\n                // Pretend that our accessor function is an observable\n                f[koProtoName] = ko.observable;\n                return f;\n            }\n\n            function makeBinding(item, index, context) {\n                return repeatArray\n                    ? function() { return repeatBind.call(bindingContext.$data, item, index, context); }\n                    : function() { return repeatBind.call(bindingContext.$data, index, context); }\n            }\n\n            // Read and set up variable options--these options can change and will update the binding\n            var paramObservable = valueAccessor(), repeatParam = ko_unwrap(paramObservable), repeatCount = 0;\n            if (repeatParam && typeof repeatParam == 'object') {\n                if ('length' in repeatParam) {\n                    repeatArray = repeatParam;\n                    repeatCount = repeatArray.length;\n                } else {\n                    if ('foreach' in repeatParam) {\n                        repeatArray = ko_unwrap(paramObservable = repeatParam.foreach);\n                        if (repeatArray && typeof repeatArray == 'object' && 'length' in repeatArray) {\n                            repeatCount = repeatArray.length || 0;\n                        } else {\n                            repeatCount = repeatArray || 0;\n                            repeatArray = null;\n                        }\n                    }\n                    // If a count value is provided (>0), always output that number of items\n                    if ('count' in repeatParam)\n                        repeatCount = ko_unwrap(repeatParam.count) || repeatCount;\n                    // If a limit is provided, don't output more than the limit\n                    if ('limit' in repeatParam)\n                        repeatCount = Math.min(repeatCount, ko_unwrap(repeatParam.limit)) || repeatCount;\n                }\n                arrayObservable = repeatArray && ko.isObservable(paramObservable) ? paramObservable : null;\n            } else {\n                repeatCount = repeatParam || 0;\n            }\n\n            // Remove nodes from end if array is shorter\n            for (; lastRepeatCount > repeatCount; lastRepeatCount-=repeatStep) {\n                ko.removeNode(repeatReversed ? placeholder.nextSibling : placeholder.previousSibling);\n            }\n\n            // Notify existing nodes of change\n            notificationObservable.notifySubscribers();\n\n            // Add nodes to end if array is longer (also initially populates nodes)\n            for (; lastRepeatCount < repeatCount; lastRepeatCount+=repeatStep) {\n                // Clone node and add to document\n                var newNode = cleanNode.cloneNode(true);\n                parent.insertBefore(newNode, repeatReversed ? placeholder.nextSibling : placeholder);\n                newNode.setAttribute('data-repeat-index', lastRepeatCount);\n\n                // Apply bindings to inserted node\n                if (repeatArray && repeatData == '$data') {\n                    var newContext = bindingContext.createChildContext(makeArrayItemAccessor(lastRepeatCount));\n                } else {\n                    var newContext = bindingContext.extend();\n                    if (repeatArray)\n                        newContext[repeatData] = makeArrayItemAccessor(lastRepeatCount);\n                }\n                newContext[repeatIndex] = lastRepeatCount;\n                if (repeatBind) {\n                    var result = ko.applyBindingsToNode(newNode, makeBinding(newContext[repeatData], lastRepeatCount, newContext), newContext, true),\n                        shouldBindDescendants = result && result.shouldBindDescendants;\n                }\n                if (!repeatBind || (result && shouldBindDescendants !== false)) {\n                    ko.applyBindings(newContext, newNode);\n                }\n            }\n            if (repeatUpdate) {\n                repeatUpdate(parent);\n            }\n        }, null, {disposeWhenNodeIsRemoved: placeholder});\n\n        return { controlsDescendantBindings: true, subscribable: subscribable };\n    }\n};\n});","knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.3.0\n * (c) Steven Sanderson - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\nvar DEBUG=true;\n(function(undefined){\n    // (0, eval)('this') is a robust way of getting a reference to the global object\n    // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n    var window = this || (0, eval)('this'),\n        document = window['document'],\n        navigator = window['navigator'],\n        jQueryInstance = window[\"jQuery\"],\n        JSON = window[\"JSON\"];\n(function(factory) {\n    // Support three module loading scenarios\n    if (typeof define === 'function' && define['amd']) {\n        // [1] AMD anonymous module\n        define(['exports', 'require'], factory);\n    } else if (typeof require === 'function' && typeof exports === 'object' && typeof module === 'object') {\n        // [2] CommonJS/Node.js\n        factory(module['exports'] || exports);  // module.exports is for Node.js\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window['ko'] = {});\n    }\n}(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\nvar ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\nko.exportSymbol = function(koPath, object) {\n    var tokens = koPath.split(\".\");\n\n    // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n    // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n    var target = ko;\n\n    for (var i = 0; i < tokens.length - 1; i++)\n        target = target[tokens[i]];\n    target[tokens[tokens.length - 1]] = object;\n};\nko.exportProperty = function(owner, publicName, object) {\n    owner[publicName] = object;\n};\nko.version = \"3.3.0\";\n\nko.exportSymbol('version', ko.version);\nko.utils = (function () {\n    function objectForEach(obj, action) {\n        for (var prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                action(prop, obj[prop]);\n            }\n        }\n    }\n\n    function extend(target, source) {\n        if (source) {\n            for(var prop in source) {\n                if(source.hasOwnProperty(prop)) {\n                    target[prop] = source[prop];\n                }\n            }\n        }\n        return target;\n    }\n\n    function setPrototypeOf(obj, proto) {\n        obj.__proto__ = proto;\n        return obj;\n    }\n\n    var canSetPrototype = ({ __proto__: [] } instanceof Array);\n\n    // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n    var knownEvents = {}, knownEventTypesByEventName = {};\n    var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n    knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n    knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n    objectForEach(knownEvents, function(eventType, knownEventsForType) {\n        if (knownEventsForType.length) {\n            for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n        }\n    });\n    var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n    // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n    // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n    // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n    // If there is a future need to detect specific versions of IE10+, we will amend this.\n    var ieVersion = document && (function() {\n        var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n        // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n        while (\n            div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n            iElems[0]\n        ) {}\n        return version > 4 ? version : undefined;\n    }());\n    var isIe6 = ieVersion === 6,\n        isIe7 = ieVersion === 7;\n\n    function isClickOnCheckableElement(element, eventType) {\n        if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n        if (eventType.toLowerCase() != \"click\") return false;\n        var inputType = element.type;\n        return (inputType == \"checkbox\") || (inputType == \"radio\");\n    }\n\n    // For details on the pattern for changing node classes\n    // see: https://github.com/knockout/knockout/issues/1597\n    var cssClassNameRegex = /\\S+/g;\n\n    function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n        var addOrRemoveFn;\n        if (classNames) {\n            if (typeof node.classList === 'object') {\n                addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                    addOrRemoveFn.call(node.classList, className);\n                });\n            } else if (typeof node.className['baseVal'] === 'string') {\n                // SVG tag .classNames is an SVGAnimatedString instance\n                toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n            } else {\n                // node.className ought to be a string.\n                toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n            }\n        }\n    }\n\n    function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n        // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n        var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n        ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n            ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n        });\n        obj[prop] = currentClassNames.join(\" \");\n    }\n\n    return {\n        fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n        arrayForEach: function (array, action) {\n            for (var i = 0, j = array.length; i < j; i++)\n                action(array[i], i);\n        },\n\n        arrayIndexOf: function (array, item) {\n            if (typeof Array.prototype.indexOf == \"function\")\n                return Array.prototype.indexOf.call(array, item);\n            for (var i = 0, j = array.length; i < j; i++)\n                if (array[i] === item)\n                    return i;\n            return -1;\n        },\n\n        arrayFirst: function (array, predicate, predicateOwner) {\n            for (var i = 0, j = array.length; i < j; i++)\n                if (predicate.call(predicateOwner, array[i], i))\n                    return array[i];\n            return null;\n        },\n\n        arrayRemoveItem: function (array, itemToRemove) {\n            var index = ko.utils.arrayIndexOf(array, itemToRemove);\n            if (index > 0) {\n                array.splice(index, 1);\n            }\n            else if (index === 0) {\n                array.shift();\n            }\n        },\n\n        arrayGetDistinctValues: function (array) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++) {\n                if (ko.utils.arrayIndexOf(result, array[i]) < 0)\n                    result.push(array[i]);\n            }\n            return result;\n        },\n\n        arrayMap: function (array, mapping) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++)\n                result.push(mapping(array[i], i));\n            return result;\n        },\n\n        arrayFilter: function (array, predicate) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++)\n                if (predicate(array[i], i))\n                    result.push(array[i]);\n            return result;\n        },\n\n        arrayPushAll: function (array, valuesToPush) {\n            if (valuesToPush instanceof Array)\n                array.push.apply(array, valuesToPush);\n            else\n                for (var i = 0, j = valuesToPush.length; i < j; i++)\n                    array.push(valuesToPush[i]);\n            return array;\n        },\n\n        addOrRemoveItem: function(array, value, included) {\n            var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n            if (existingEntryIndex < 0) {\n                if (included)\n                    array.push(value);\n            } else {\n                if (!included)\n                    array.splice(existingEntryIndex, 1);\n            }\n        },\n\n        canSetPrototype: canSetPrototype,\n\n        extend: extend,\n\n        setPrototypeOf: setPrototypeOf,\n\n        setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n        objectForEach: objectForEach,\n\n        objectMap: function(source, mapping) {\n            if (!source)\n                return source;\n            var target = {};\n            for (var prop in source) {\n                if (source.hasOwnProperty(prop)) {\n                    target[prop] = mapping(source[prop], prop, source);\n                }\n            }\n            return target;\n        },\n\n        emptyDomNode: function (domNode) {\n            while (domNode.firstChild) {\n                ko.removeNode(domNode.firstChild);\n            }\n        },\n\n        moveCleanedNodesToContainerElement: function(nodes) {\n            // Ensure it's a real array, as we're about to reparent the nodes and\n            // we don't want the underlying collection to change while we're doing that.\n            var nodesArray = ko.utils.makeArray(nodes);\n            var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n            var container = templateDocument.createElement('div');\n            for (var i = 0, j = nodesArray.length; i < j; i++) {\n                container.appendChild(ko.cleanNode(nodesArray[i]));\n            }\n            return container;\n        },\n\n        cloneNodes: function (nodesArray, shouldCleanNodes) {\n            for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                var clonedNode = nodesArray[i].cloneNode(true);\n                newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n            }\n            return newNodesArray;\n        },\n\n        setDomNodeChildren: function (domNode, childNodes) {\n            ko.utils.emptyDomNode(domNode);\n            if (childNodes) {\n                for (var i = 0, j = childNodes.length; i < j; i++)\n                    domNode.appendChild(childNodes[i]);\n            }\n        },\n\n        replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n            var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n            if (nodesToReplaceArray.length > 0) {\n                var insertionPoint = nodesToReplaceArray[0];\n                var parent = insertionPoint.parentNode;\n                for (var i = 0, j = newNodesArray.length; i < j; i++)\n                    parent.insertBefore(newNodesArray[i], insertionPoint);\n                for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                    ko.removeNode(nodesToReplaceArray[i]);\n                }\n            }\n        },\n\n        fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n            // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n            // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n            // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n            // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n            // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n            //\n            // Rules:\n            //   [A] Any leading nodes that have been removed should be ignored\n            //       These most likely correspond to memoization nodes that were already removed during binding\n            //       See https://github.com/SteveSanderson/knockout/pull/440\n            //   [B] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n            //       and include any nodes that have been inserted among the previous collection\n\n            if (continuousNodeArray.length) {\n                // The parent node can be a virtual element; so get the real parent node\n                parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                // Rule [A]\n                while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                    continuousNodeArray.splice(0, 1);\n\n                // Rule [B]\n                if (continuousNodeArray.length > 1) {\n                    var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                    // Replace with the actual new continuous node set\n                    continuousNodeArray.length = 0;\n                    while (current !== last) {\n                        continuousNodeArray.push(current);\n                        current = current.nextSibling;\n                        if (!current) // Won't happen, except if the developer has manually removed some DOM elements (then we're in an undefined scenario)\n                            return;\n                    }\n                    continuousNodeArray.push(last);\n                }\n            }\n            return continuousNodeArray;\n        },\n\n        setOptionNodeSelectionState: function (optionNode, isSelected) {\n            // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n            if (ieVersion < 7)\n                optionNode.setAttribute(\"selected\", isSelected);\n            else\n                optionNode.selected = isSelected;\n        },\n\n        stringTrim: function (string) {\n            return string === null || string === undefined ? '' :\n                string.trim ?\n                    string.trim() :\n                    string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n        },\n\n        stringStartsWith: function (string, startsWith) {\n            string = string || \"\";\n            if (startsWith.length > string.length)\n                return false;\n            return string.substring(0, startsWith.length) === startsWith;\n        },\n\n        domNodeIsContainedBy: function (node, containedByNode) {\n            if (node === containedByNode)\n                return true;\n            if (node.nodeType === 11)\n                return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n            if (containedByNode.contains)\n                return containedByNode.contains(node.nodeType === 3 ? node.parentNode : node);\n            if (containedByNode.compareDocumentPosition)\n                return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n            while (node && node != containedByNode) {\n                node = node.parentNode;\n            }\n            return !!node;\n        },\n\n        domNodeIsAttachedToDocument: function (node) {\n            return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n        },\n\n        anyDomNodeIsAttachedToDocument: function(nodes) {\n            return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n        },\n\n        tagNameLower: function(element) {\n            // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n            // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n            // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n            return element && element.tagName && element.tagName.toLowerCase();\n        },\n\n        registerEventHandler: function (element, eventType, handler) {\n            var mustUseAttachEvent = ieVersion && eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n            if (!mustUseAttachEvent && jQueryInstance) {\n                jQueryInstance(element)['bind'](eventType, handler);\n            } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                element.addEventListener(eventType, handler, false);\n            else if (typeof element.attachEvent != \"undefined\") {\n                var attachEventHandler = function (event) { handler.call(element, event); },\n                    attachEventName = \"on\" + eventType;\n                element.attachEvent(attachEventName, attachEventHandler);\n\n                // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                // so to avoid leaks, we have to remove them manually. See bug #856\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                    element.detachEvent(attachEventName, attachEventHandler);\n                });\n            } else\n                throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n        },\n\n        triggerEvent: function (element, eventType) {\n            if (!(element && element.nodeType))\n                throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n            // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n            // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n            // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n            // In both cases, we'll use the click method instead.\n            var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n            if (jQueryInstance && !useClickWorkaround) {\n                jQueryInstance(element)['trigger'](eventType);\n            } else if (typeof document.createEvent == \"function\") {\n                if (typeof element.dispatchEvent == \"function\") {\n                    var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                    var event = document.createEvent(eventCategory);\n                    event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                    element.dispatchEvent(event);\n                }\n                else\n                    throw new Error(\"The supplied element doesn't support dispatchEvent\");\n            } else if (useClickWorkaround && element.click) {\n                element.click();\n            } else if (typeof element.fireEvent != \"undefined\") {\n                element.fireEvent(\"on\" + eventType);\n            } else {\n                throw new Error(\"Browser doesn't support triggering events\");\n            }\n        },\n\n        unwrapObservable: function (value) {\n            return ko.isObservable(value) ? value() : value;\n        },\n\n        peekObservable: function (value) {\n            return ko.isObservable(value) ? value.peek() : value;\n        },\n\n        toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n        setTextContent: function(element, textContent) {\n            var value = ko.utils.unwrapObservable(textContent);\n            if ((value === null) || (value === undefined))\n                value = \"\";\n\n            // We need there to be exactly one child: a text node.\n            // If there are no children, more than one, or if it's not a text node,\n            // we'll clear everything and create a single text node.\n            var innerTextNode = ko.virtualElements.firstChild(element);\n            if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n            } else {\n                innerTextNode.data = value;\n            }\n\n            ko.utils.forceRefresh(element);\n        },\n\n        setElementName: function(element, name) {\n            element.name = name;\n\n            // Workaround IE 6/7 issue\n            // - https://github.com/SteveSanderson/knockout/issues/197\n            // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n            if (ieVersion <= 7) {\n                try {\n                    element.mergeAttributes(document.createElement(\"<input name='\" + element.name + \"'/>\"), false);\n                }\n                catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n            }\n        },\n\n        forceRefresh: function(node) {\n            // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n            if (ieVersion >= 9) {\n                // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                var elem = node.nodeType == 1 ? node : node.parentNode;\n                if (elem.style)\n                    elem.style.zoom = elem.style.zoom;\n            }\n        },\n\n        ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n            // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n            // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n            // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n            if (ieVersion) {\n                var originalWidth = selectElement.style.width;\n                selectElement.style.width = 0;\n                selectElement.style.width = originalWidth;\n            }\n        },\n\n        range: function (min, max) {\n            min = ko.utils.unwrapObservable(min);\n            max = ko.utils.unwrapObservable(max);\n            var result = [];\n            for (var i = min; i <= max; i++)\n                result.push(i);\n            return result;\n        },\n\n        makeArray: function(arrayLikeObject) {\n            var result = [];\n            for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                result.push(arrayLikeObject[i]);\n            };\n            return result;\n        },\n\n        isIe6 : isIe6,\n        isIe7 : isIe7,\n        ieVersion : ieVersion,\n\n        getFormFields: function(form, fieldName) {\n            var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n            var isMatchingField = (typeof fieldName == 'string')\n                ? function(field) { return field.name === fieldName }\n                : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n            var matches = [];\n            for (var i = fields.length - 1; i >= 0; i--) {\n                if (isMatchingField(fields[i]))\n                    matches.push(fields[i]);\n            };\n            return matches;\n        },\n\n        parseJson: function (jsonString) {\n            if (typeof jsonString == \"string\") {\n                jsonString = ko.utils.stringTrim(jsonString);\n                if (jsonString) {\n                    if (JSON && JSON.parse) // Use native parsing where available\n                        return JSON.parse(jsonString);\n                    return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                }\n            }\n            return null;\n        },\n\n        stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n            if (!JSON || !JSON.stringify)\n                throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n            return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n        },\n\n        postJson: function (urlOrForm, data, options) {\n            options = options || {};\n            var params = options['params'] || {};\n            var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n            var url = urlOrForm;\n\n            // If we were given a form, use its 'action' URL and pick out any requested field values\n            if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                var originalForm = urlOrForm;\n                url = originalForm.action;\n                for (var i = includeFields.length - 1; i >= 0; i--) {\n                    var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                    for (var j = fields.length - 1; j >= 0; j--)\n                        params[fields[j].name] = fields[j].value;\n                }\n            }\n\n            data = ko.utils.unwrapObservable(data);\n            var form = document.createElement(\"form\");\n            form.style.display = \"none\";\n            form.action = url;\n            form.method = \"post\";\n            for (var key in data) {\n                // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                var input = document.createElement(\"input\");\n                input.type = \"hidden\";\n                input.name = key;\n                input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                form.appendChild(input);\n            }\n            objectForEach(params, function(key, value) {\n                var input = document.createElement(\"input\");\n                input.type = \"hidden\";\n                input.name = key;\n                input.value = value;\n                form.appendChild(input);\n            });\n            document.body.appendChild(form);\n            options['submitter'] ? options['submitter'](form) : form.submit();\n            setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n        }\n    }\n}());\n\nko.exportSymbol('utils', ko.utils);\nko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\nko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\nko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\nko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\nko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\nko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\nko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\nko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\nko.exportSymbol('utils.extend', ko.utils.extend);\nko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\nko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\nko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\nko.exportSymbol('utils.postJson', ko.utils.postJson);\nko.exportSymbol('utils.parseJson', ko.utils.parseJson);\nko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\nko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\nko.exportSymbol('utils.range', ko.utils.range);\nko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\nko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\nko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\nko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\nko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\nko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\nko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\nif (!Function.prototype['bind']) {\n    // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n    // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n    Function.prototype['bind'] = function (object) {\n        var originalFunction = this;\n        if (arguments.length === 1) {\n            return function () {\n                return originalFunction.apply(object, arguments);\n            };\n        } else {\n            var partialArgs = Array.prototype.slice.call(arguments, 1);\n            return function () {\n                var args = partialArgs.slice(0);\n                args.push.apply(args, arguments);\n                return originalFunction.apply(object, args);\n            };\n        }\n    };\n}\n\nko.utils.domData = new (function () {\n    var uniqueId = 0;\n    var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n    var dataStore = {};\n\n    function getAll(node, createIfNotFound) {\n        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n        if (!hasExistingDataStore) {\n            if (!createIfNotFound)\n                return undefined;\n            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n            dataStore[dataStoreKey] = {};\n        }\n        return dataStore[dataStoreKey];\n    }\n\n    return {\n        get: function (node, key) {\n            var allDataForNode = getAll(node, false);\n            return allDataForNode === undefined ? undefined : allDataForNode[key];\n        },\n        set: function (node, key, value) {\n            if (value === undefined) {\n                // Make sure we don't actually create a new domData key if we are actually deleting a value\n                if (getAll(node, false) === undefined)\n                    return;\n            }\n            var allDataForNode = getAll(node, true);\n            allDataForNode[key] = value;\n        },\n        clear: function (node) {\n            var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n            if (dataStoreKey) {\n                delete dataStore[dataStoreKey];\n                node[dataStoreKeyExpandoPropertyName] = null;\n                return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n            }\n            return false;\n        },\n\n        nextKey: function () {\n            return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n        }\n    };\n})();\n\nko.exportSymbol('utils.domData', ko.utils.domData);\nko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\nko.utils.domNodeDisposal = new (function () {\n    var domDataKey = ko.utils.domData.nextKey();\n    var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n    var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n    function getDisposeCallbacksCollection(node, createIfNotFound) {\n        var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n        if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n            allDisposeCallbacks = [];\n            ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n        }\n        return allDisposeCallbacks;\n    }\n    function destroyCallbacksCollection(node) {\n        ko.utils.domData.set(node, domDataKey, undefined);\n    }\n\n    function cleanSingleNode(node) {\n        // Run all the dispose callbacks\n        var callbacks = getDisposeCallbacksCollection(node, false);\n        if (callbacks) {\n            callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n            for (var i = 0; i < callbacks.length; i++)\n                callbacks[i](node);\n        }\n\n        // Erase the DOM data\n        ko.utils.domData.clear(node);\n\n        // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n        ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n        // Clear any immediate-child comment nodes, as these wouldn't have been found by\n        // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n        if (cleanableNodeTypesWithDescendants[node.nodeType])\n            cleanImmediateCommentTypeChildren(node);\n    }\n\n    function cleanImmediateCommentTypeChildren(nodeWithChildren) {\n        var child, nextChild = nodeWithChildren.firstChild;\n        while (child = nextChild) {\n            nextChild = child.nextSibling;\n            if (child.nodeType === 8)\n                cleanSingleNode(child);\n        }\n    }\n\n    return {\n        addDisposeCallback : function(node, callback) {\n            if (typeof callback != \"function\")\n                throw new Error(\"Callback must be a function\");\n            getDisposeCallbacksCollection(node, true).push(callback);\n        },\n\n        removeDisposeCallback : function(node, callback) {\n            var callbacksCollection = getDisposeCallbacksCollection(node, false);\n            if (callbacksCollection) {\n                ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                if (callbacksCollection.length == 0)\n                    destroyCallbacksCollection(node);\n            }\n        },\n\n        cleanNode : function(node) {\n            // First clean this node, where applicable\n            if (cleanableNodeTypes[node.nodeType]) {\n                cleanSingleNode(node);\n\n                // ... then its descendants, where applicable\n                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                    // Clone the descendants list in case it changes during iteration\n                    var descendants = [];\n                    ko.utils.arrayPushAll(descendants, node.getElementsByTagName(\"*\"));\n                    for (var i = 0, j = descendants.length; i < j; i++)\n                        cleanSingleNode(descendants[i]);\n                }\n            }\n            return node;\n        },\n\n        removeNode : function(node) {\n            ko.cleanNode(node);\n            if (node.parentNode)\n                node.parentNode.removeChild(node);\n        },\n\n        \"cleanExternalData\" : function (node) {\n            // Special support for jQuery here because it's so commonly used.\n            // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n            // so notify it to tear down any resources associated with the node & descendants here.\n            if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                jQueryInstance['cleanData']([node]);\n        }\n    };\n})();\nko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\nko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\nko.exportSymbol('cleanNode', ko.cleanNode);\nko.exportSymbol('removeNode', ko.removeNode);\nko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\nko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\nko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n(function () {\n    var leadingCommentRegex = /^(\\s*)<!--(.*?)-->/;\n\n    function simpleHtmlParse(html, documentContext) {\n        documentContext || (documentContext = document);\n        var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n        // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n        // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n        // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n        // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n        // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n        // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n        // Trim whitespace, otherwise indexOf won't work as expected\n        var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\");\n\n        // Finds the first match from the left column, and returns the corresponding \"wrap\" data from the right column\n        var wrap = tags.match(/^<(thead|tbody|tfoot)/)              && [1, \"<table>\", \"</table>\"] ||\n                   !tags.indexOf(\"<tr\")                             && [2, \"<table><tbody>\", \"</tbody></table>\"] ||\n                   (!tags.indexOf(\"<td\") || !tags.indexOf(\"<th\"))   && [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"] ||\n                   /* anything else */                                 [0, \"\", \"\"];\n\n        // Go to html and back, then peel off extra wrappers\n        // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n        var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n        if (typeof windowContext['innerShiv'] == \"function\") {\n            div.appendChild(windowContext['innerShiv'](markup));\n        } else {\n            div.innerHTML = markup;\n        }\n\n        // Move to the right depth\n        while (wrap[0]--)\n            div = div.lastChild;\n\n        return ko.utils.makeArray(div.lastChild.childNodes);\n    }\n\n    function jQueryHtmlParse(html, documentContext) {\n        // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n        if (jQueryInstance['parseHTML']) {\n            return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n        } else {\n            // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n            var elems = jQueryInstance['clean']([html], documentContext);\n\n            // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n            // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n            // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n            if (elems && elems[0]) {\n                // Find the top-most parent element that's a direct child of a document fragment\n                var elem = elems[0];\n                while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                    elem = elem.parentNode;\n                // ... then detach it\n                if (elem.parentNode)\n                    elem.parentNode.removeChild(elem);\n            }\n\n            return elems;\n        }\n    }\n\n    ko.utils.parseHtmlFragment = function(html, documentContext) {\n        return jQueryInstance ? jQueryHtmlParse(html, documentContext)   // As below, benefit from jQuery's optimisations where possible\n                              : simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n    };\n\n    ko.utils.setHtml = function(node, html) {\n        ko.utils.emptyDomNode(node);\n\n        // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n        html = ko.utils.unwrapObservable(html);\n\n        if ((html !== null) && (html !== undefined)) {\n            if (typeof html != 'string')\n                html = html.toString();\n\n            // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n            // for example <tr> elements which are not normally allowed to exist on their own.\n            // If you've referenced jQuery we'll use that rather than duplicating its code.\n            if (jQueryInstance) {\n                jQueryInstance(node)['html'](html);\n            } else {\n                // ... otherwise, use KO's own parsing logic.\n                var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                for (var i = 0; i < parsedNodes.length; i++)\n                    node.appendChild(parsedNodes[i]);\n            }\n        }\n    };\n})();\n\nko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\nko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\nko.memoization = (function () {\n    var memos = {};\n\n    function randomMax8HexChars() {\n        return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n    }\n    function generateRandomId() {\n        return randomMax8HexChars() + randomMax8HexChars();\n    }\n    function findMemoNodes(rootNode, appendToArray) {\n        if (!rootNode)\n            return;\n        if (rootNode.nodeType == 8) {\n            var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n            if (memoId != null)\n                appendToArray.push({ domNode: rootNode, memoId: memoId });\n        } else if (rootNode.nodeType == 1) {\n            for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                findMemoNodes(childNodes[i], appendToArray);\n        }\n    }\n\n    return {\n        memoize: function (callback) {\n            if (typeof callback != \"function\")\n                throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n            var memoId = generateRandomId();\n            memos[memoId] = callback;\n            return \"<!--[ko_memo:\" + memoId + \"]-->\";\n        },\n\n        unmemoize: function (memoId, callbackParams) {\n            var callback = memos[memoId];\n            if (callback === undefined)\n                throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n            try {\n                callback.apply(null, callbackParams || []);\n                return true;\n            }\n            finally { delete memos[memoId]; }\n        },\n\n        unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n            var memos = [];\n            findMemoNodes(domNode, memos);\n            for (var i = 0, j = memos.length; i < j; i++) {\n                var node = memos[i].domNode;\n                var combinedParams = [node];\n                if (extraCallbackParamsArray)\n                    ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                if (node.parentNode)\n                    node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n            }\n        },\n\n        parseMemoText: function (memoText) {\n            var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n            return match ? match[1] : null;\n        }\n    };\n})();\n\nko.exportSymbol('memoization', ko.memoization);\nko.exportSymbol('memoization.memoize', ko.memoization.memoize);\nko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\nko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\nko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\nko.extenders = {\n    'throttle': function(target, timeout) {\n        // Throttling means two things:\n\n        // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n        //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n        target['throttleEvaluation'] = timeout;\n\n        // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n        //     so the target cannot change value synchronously or faster than a certain rate\n        var writeTimeoutInstance = null;\n        return ko.dependentObservable({\n            'read': target,\n            'write': function(value) {\n                clearTimeout(writeTimeoutInstance);\n                writeTimeoutInstance = setTimeout(function() {\n                    target(value);\n                }, timeout);\n            }\n        });\n    },\n\n    'rateLimit': function(target, options) {\n        var timeout, method, limitFunction;\n\n        if (typeof options == 'number') {\n            timeout = options;\n        } else {\n            timeout = options['timeout'];\n            method = options['method'];\n        }\n\n        limitFunction = method == 'notifyWhenChangesStop' ?  debounce : throttle;\n        target.limit(function(callback) {\n            return limitFunction(callback, timeout);\n        });\n    },\n\n    'notify': function(target, notifyWhen) {\n        target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n            null :  // null equalityComparer means to always notify\n            valuesArePrimitiveAndEqual;\n    }\n};\n\nvar primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\nfunction valuesArePrimitiveAndEqual(a, b) {\n    var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n    return oldValueIsPrimitive ? (a === b) : false;\n}\n\nfunction throttle(callback, timeout) {\n    var timeoutInstance;\n    return function () {\n        if (!timeoutInstance) {\n            timeoutInstance = setTimeout(function() {\n                timeoutInstance = undefined;\n                callback();\n            }, timeout);\n        }\n    };\n}\n\nfunction debounce(callback, timeout) {\n    var timeoutInstance;\n    return function () {\n        clearTimeout(timeoutInstance);\n        timeoutInstance = setTimeout(callback, timeout);\n    };\n}\n\nfunction applyExtenders(requestedExtenders) {\n    var target = this;\n    if (requestedExtenders) {\n        ko.utils.objectForEach(requestedExtenders, function(key, value) {\n            var extenderHandler = ko.extenders[key];\n            if (typeof extenderHandler == 'function') {\n                target = extenderHandler(target, value) || target;\n            }\n        });\n    }\n    return target;\n}\n\nko.exportSymbol('extenders', ko.extenders);\n\nko.subscription = function (target, callback, disposeCallback) {\n    this._target = target;\n    this.callback = callback;\n    this.disposeCallback = disposeCallback;\n    this.isDisposed = false;\n    ko.exportProperty(this, 'dispose', this.dispose);\n};\nko.subscription.prototype.dispose = function () {\n    this.isDisposed = true;\n    this.disposeCallback();\n};\n\nko.subscribable = function () {\n    ko.utils.setPrototypeOfOrExtend(this, ko.subscribable['fn']);\n    this._subscriptions = {};\n    this._versionNumber = 1;\n}\n\nvar defaultEvent = \"change\";\n\nvar ko_subscribable_fn = {\n    subscribe: function (callback, callbackTarget, event) {\n        var self = this;\n\n        event = event || defaultEvent;\n        var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n        var subscription = new ko.subscription(self, boundCallback, function () {\n            ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n            if (self.afterSubscriptionRemove)\n                self.afterSubscriptionRemove(event);\n        });\n\n        if (self.beforeSubscriptionAdd)\n            self.beforeSubscriptionAdd(event);\n\n        if (!self._subscriptions[event])\n            self._subscriptions[event] = [];\n        self._subscriptions[event].push(subscription);\n\n        return subscription;\n    },\n\n    \"notifySubscribers\": function (valueToNotify, event) {\n        event = event || defaultEvent;\n        if (event === defaultEvent) {\n            this.updateVersion();\n        }\n        if (this.hasSubscriptionsForEvent(event)) {\n            try {\n                ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                for (var a = this._subscriptions[event].slice(0), i = 0, subscription; subscription = a[i]; ++i) {\n                    // In case a subscription was disposed during the arrayForEach cycle, check\n                    // for isDisposed on each subscription before invoking its callback\n                    if (!subscription.isDisposed)\n                        subscription.callback(valueToNotify);\n                }\n            } finally {\n                ko.dependencyDetection.end(); // End suppressing dependency detection\n            }\n        }\n    },\n\n    getVersion: function () {\n        return this._versionNumber;\n    },\n\n    hasChanged: function (versionToCheck) {\n        return this.getVersion() !== versionToCheck;\n    },\n\n    updateVersion: function () {\n        ++this._versionNumber;\n    },\n\n    limit: function(limitFunction) {\n        var self = this, selfIsObservable = ko.isObservable(self),\n            isPending, previousValue, pendingValue, beforeChange = 'beforeChange';\n\n        if (!self._origNotifySubscribers) {\n            self._origNotifySubscribers = self[\"notifySubscribers\"];\n            self[\"notifySubscribers\"] = function(value, event) {\n                if (!event || event === defaultEvent) {\n                    self._rateLimitedChange(value);\n                } else if (event === beforeChange) {\n                    self._rateLimitedBeforeChange(value);\n                } else {\n                    self._origNotifySubscribers(value, event);\n                }\n            };\n        }\n\n        var finish = limitFunction(function() {\n            // If an observable provided a reference to itself, access it to get the latest value.\n            // This allows computed observables to delay calculating their value until needed.\n            if (selfIsObservable && pendingValue === self) {\n                pendingValue = self();\n            }\n            isPending = false;\n            if (self.isDifferent(previousValue, pendingValue)) {\n                self._origNotifySubscribers(previousValue = pendingValue);\n            }\n        });\n\n        self._rateLimitedChange = function(value) {\n            isPending = true;\n            pendingValue = value;\n            finish();\n        };\n        self._rateLimitedBeforeChange = function(value) {\n            if (!isPending) {\n                previousValue = value;\n                self._origNotifySubscribers(value, beforeChange);\n            }\n        };\n    },\n\n    hasSubscriptionsForEvent: function(event) {\n        return this._subscriptions[event] && this._subscriptions[event].length;\n    },\n\n    getSubscriptionsCount: function (event) {\n        if (event) {\n            return this._subscriptions[event] && this._subscriptions[event].length || 0;\n        } else {\n            var total = 0;\n            ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                total += subscriptions.length;\n            });\n            return total;\n        }\n    },\n\n    isDifferent: function(oldValue, newValue) {\n        return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n    },\n\n    extend: applyExtenders\n};\n\nko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\nko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\nko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n}\n\nko.subscribable['fn'] = ko_subscribable_fn;\n\n\nko.isSubscribable = function (instance) {\n    return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n};\n\nko.exportSymbol('subscribable', ko.subscribable);\nko.exportSymbol('isSubscribable', ko.isSubscribable);\n\nko.computedContext = ko.dependencyDetection = (function () {\n    var outerFrames = [],\n        currentFrame,\n        lastId = 0;\n\n    // Return a unique ID that can be assigned to an observable for dependency tracking.\n    // Theoretically, you could eventually overflow the number storage size, resulting\n    // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n    // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n    // take over 285 years to reach that number.\n    // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n    function getId() {\n        return ++lastId;\n    }\n\n    function begin(options) {\n        outerFrames.push(currentFrame);\n        currentFrame = options;\n    }\n\n    function end() {\n        currentFrame = outerFrames.pop();\n    }\n\n    return {\n        begin: begin,\n\n        end: end,\n\n        registerDependency: function (subscribable) {\n            if (currentFrame) {\n                if (!ko.isSubscribable(subscribable))\n                    throw new Error(\"Only subscribable things can act as dependencies\");\n                currentFrame.callback(subscribable, subscribable._id || (subscribable._id = getId()));\n            }\n        },\n\n        ignore: function (callback, callbackTarget, callbackArgs) {\n            try {\n                begin();\n                return callback.apply(callbackTarget, callbackArgs || []);\n            } finally {\n                end();\n            }\n        },\n\n        getDependenciesCount: function () {\n            if (currentFrame)\n                return currentFrame.computed.getDependenciesCount();\n        },\n\n        isInitial: function() {\n            if (currentFrame)\n                return currentFrame.isInitial;\n        }\n    };\n})();\n\nko.exportSymbol('computedContext', ko.computedContext);\nko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\nko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\nko.exportSymbol('computedContext.isSleeping', ko.computedContext.isSleeping);\n\nko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\nko.observable = function (initialValue) {\n    var _latestValue = initialValue;\n\n    function observable() {\n        if (arguments.length > 0) {\n            // Write\n\n            // Ignore writes if the value hasn't changed\n            if (observable.isDifferent(_latestValue, arguments[0])) {\n                observable.valueWillMutate();\n                _latestValue = arguments[0];\n                if (DEBUG) observable._latestValue = _latestValue;\n                observable.valueHasMutated();\n            }\n            return this; // Permits chained assignments\n        }\n        else {\n            // Read\n            ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n            return _latestValue;\n        }\n    }\n    ko.subscribable.call(observable);\n    ko.utils.setPrototypeOfOrExtend(observable, ko.observable['fn']);\n\n    if (DEBUG) observable._latestValue = _latestValue;\n    observable.peek = function() { return _latestValue };\n    observable.valueHasMutated = function () { observable[\"notifySubscribers\"](_latestValue); }\n    observable.valueWillMutate = function () { observable[\"notifySubscribers\"](_latestValue, \"beforeChange\"); }\n\n    ko.exportProperty(observable, 'peek', observable.peek);\n    ko.exportProperty(observable, \"valueHasMutated\", observable.valueHasMutated);\n    ko.exportProperty(observable, \"valueWillMutate\", observable.valueWillMutate);\n\n    return observable;\n}\n\nko.observable['fn'] = {\n    \"equalityComparer\": valuesArePrimitiveAndEqual\n};\n\nvar protoProperty = ko.observable.protoProperty = \"__ko_proto__\";\nko.observable['fn'][protoProperty] = ko.observable;\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.observable['fn'], ko.subscribable['fn']);\n}\n\nko.hasPrototype = function(instance, prototype) {\n    if ((instance === null) || (instance === undefined) || (instance[protoProperty] === undefined)) return false;\n    if (instance[protoProperty] === prototype) return true;\n    return ko.hasPrototype(instance[protoProperty], prototype); // Walk the prototype chain\n};\n\nko.isObservable = function (instance) {\n    return ko.hasPrototype(instance, ko.observable);\n}\nko.isWriteableObservable = function (instance) {\n    // Observable\n    if ((typeof instance == \"function\") && instance[protoProperty] === ko.observable)\n        return true;\n    // Writeable dependent observable\n    if ((typeof instance == \"function\") && (instance[protoProperty] === ko.dependentObservable) && (instance.hasWriteFunction))\n        return true;\n    // Anything else\n    return false;\n}\n\n\nko.exportSymbol('observable', ko.observable);\nko.exportSymbol('isObservable', ko.isObservable);\nko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\nko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\nko.observableArray = function (initialValues) {\n    initialValues = initialValues || [];\n\n    if (typeof initialValues != 'object' || !('length' in initialValues))\n        throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n    var result = ko.observable(initialValues);\n    ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n    return result.extend({'trackArrayChanges':true});\n};\n\nko.observableArray['fn'] = {\n    'remove': function (valueOrPredicate) {\n        var underlyingArray = this.peek();\n        var removedValues = [];\n        var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n        for (var i = 0; i < underlyingArray.length; i++) {\n            var value = underlyingArray[i];\n            if (predicate(value)) {\n                if (removedValues.length === 0) {\n                    this.valueWillMutate();\n                }\n                removedValues.push(value);\n                underlyingArray.splice(i, 1);\n                i--;\n            }\n        }\n        if (removedValues.length) {\n            this.valueHasMutated();\n        }\n        return removedValues;\n    },\n\n    'removeAll': function (arrayOfValues) {\n        // If you passed zero args, we remove everything\n        if (arrayOfValues === undefined) {\n            var underlyingArray = this.peek();\n            var allValues = underlyingArray.slice(0);\n            this.valueWillMutate();\n            underlyingArray.splice(0, underlyingArray.length);\n            this.valueHasMutated();\n            return allValues;\n        }\n        // If you passed an arg, we interpret it as an array of entries to remove\n        if (!arrayOfValues)\n            return [];\n        return this['remove'](function (value) {\n            return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n        });\n    },\n\n    'destroy': function (valueOrPredicate) {\n        var underlyingArray = this.peek();\n        var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n        this.valueWillMutate();\n        for (var i = underlyingArray.length - 1; i >= 0; i--) {\n            var value = underlyingArray[i];\n            if (predicate(value))\n                underlyingArray[i][\"_destroy\"] = true;\n        }\n        this.valueHasMutated();\n    },\n\n    'destroyAll': function (arrayOfValues) {\n        // If you passed zero args, we destroy everything\n        if (arrayOfValues === undefined)\n            return this['destroy'](function() { return true });\n\n        // If you passed an arg, we interpret it as an array of entries to destroy\n        if (!arrayOfValues)\n            return [];\n        return this['destroy'](function (value) {\n            return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n        });\n    },\n\n    'indexOf': function (item) {\n        var underlyingArray = this();\n        return ko.utils.arrayIndexOf(underlyingArray, item);\n    },\n\n    'replace': function(oldItem, newItem) {\n        var index = this['indexOf'](oldItem);\n        if (index >= 0) {\n            this.valueWillMutate();\n            this.peek()[index] = newItem;\n            this.valueHasMutated();\n        }\n    }\n};\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\nko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n    ko.observableArray['fn'][methodName] = function () {\n        // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n        // (for consistency with mutating regular observables)\n        var underlyingArray = this.peek();\n        this.valueWillMutate();\n        this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n        var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n        this.valueHasMutated();\n        return methodCallResult;\n    };\n});\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\nko.utils.arrayForEach([\"slice\"], function (methodName) {\n    ko.observableArray['fn'][methodName] = function () {\n        var underlyingArray = this();\n        return underlyingArray[methodName].apply(underlyingArray, arguments);\n    };\n});\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n}\n\nko.exportSymbol('observableArray', ko.observableArray);\nvar arrayChangeEventName = 'arrayChange';\nko.extenders['trackArrayChanges'] = function(target) {\n    // Only modify the target observable once\n    if (target.cacheDiffForKnownOperation) {\n        return;\n    }\n    var trackingChanges = false,\n        cachedDiff = null,\n        arrayChangeSubscription,\n        pendingNotifications = 0,\n        underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n        underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n    // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n    target.beforeSubscriptionAdd = function (event) {\n        if (underlyingBeforeSubscriptionAddFunction)\n            underlyingBeforeSubscriptionAddFunction.call(target, event);\n        if (event === arrayChangeEventName) {\n            trackChanges();\n        }\n    };\n    // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n    target.afterSubscriptionRemove = function (event) {\n        if (underlyingAfterSubscriptionRemoveFunction)\n            underlyingAfterSubscriptionRemoveFunction.call(target, event);\n        if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n            arrayChangeSubscription.dispose();\n            trackingChanges = false;\n        }\n    };\n\n    function trackChanges() {\n        // Calling 'trackChanges' multiple times is the same as calling it once\n        if (trackingChanges) {\n            return;\n        }\n\n        trackingChanges = true;\n\n        // Intercept \"notifySubscribers\" to track how many times it was called.\n        var underlyingNotifySubscribersFunction = target['notifySubscribers'];\n        target['notifySubscribers'] = function(valueToNotify, event) {\n            if (!event || event === defaultEvent) {\n                ++pendingNotifications;\n            }\n            return underlyingNotifySubscribersFunction.apply(this, arguments);\n        };\n\n        // Each time the array changes value, capture a clone so that on the next\n        // change it's possible to produce a diff\n        var previousContents = [].concat(target.peek() || []);\n        cachedDiff = null;\n        arrayChangeSubscription = target.subscribe(function(currentContents) {\n            // Make a copy of the current contents and ensure it's an array\n            currentContents = [].concat(currentContents || []);\n\n            // Compute the diff and issue notifications, but only if someone is listening\n            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                var changes = getChanges(previousContents, currentContents);\n            }\n\n            // Eliminate references to the old, removed items, so they can be GCed\n            previousContents = currentContents;\n            cachedDiff = null;\n            pendingNotifications = 0;\n\n            if (changes && changes.length) {\n                target['notifySubscribers'](changes, arrayChangeEventName);\n            }\n        });\n    }\n\n    function getChanges(previousContents, currentContents) {\n        // We try to re-use cached diffs.\n        // The scenarios where pendingNotifications > 1 are when using rate-limiting or the Deferred Updates\n        // plugin, which without this check would not be compatible with arrayChange notifications. Normally,\n        // notifications are issued immediately so we wouldn't be queueing up more than one.\n        if (!cachedDiff || pendingNotifications > 1) {\n            cachedDiff = ko.utils.compareArrays(previousContents, currentContents, { 'sparse': true });\n        }\n\n        return cachedDiff;\n    }\n\n    target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n        // Only run if we're currently tracking changes for this observable array\n        // and there aren't any pending deferred notifications.\n        if (!trackingChanges || pendingNotifications) {\n            return;\n        }\n        var diff = [],\n            arrayLength = rawArray.length,\n            argsLength = args.length,\n            offset = 0;\n\n        function pushDiff(status, value, index) {\n            return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n        }\n        switch (operationName) {\n            case 'push':\n                offset = arrayLength;\n            case 'unshift':\n                for (var index = 0; index < argsLength; index++) {\n                    pushDiff('added', args[index], offset + index);\n                }\n                break;\n\n            case 'pop':\n                offset = arrayLength - 1;\n            case 'shift':\n                if (arrayLength) {\n                    pushDiff('deleted', rawArray[offset], offset);\n                }\n                break;\n\n            case 'splice':\n                // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                    endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                    endAddIndex = startIndex + argsLength - 2,\n                    endIndex = Math.max(endDeleteIndex, endAddIndex),\n                    additions = [], deletions = [];\n                for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                    if (index < endDeleteIndex)\n                        deletions.push(pushDiff('deleted', rawArray[index], index));\n                    if (index < endAddIndex)\n                        additions.push(pushDiff('added', args[argsIndex], index));\n                }\n                ko.utils.findMovesInArrayComparison(deletions, additions);\n                break;\n\n            default:\n                return;\n        }\n        cachedDiff = diff;\n    };\n};\nko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n    var _latestValue,\n        _needsEvaluation = true,\n        _isBeingEvaluated = false,\n        _suppressDisposalUntilDisposeWhenReturnsFalse = false,\n        _isDisposed = false,\n        readFunction = evaluatorFunctionOrOptions,\n        pure = false,\n        isSleeping = false;\n\n    if (readFunction && typeof readFunction == \"object\") {\n        // Single-parameter syntax - everything is on this \"options\" param\n        options = readFunction;\n        readFunction = options[\"read\"];\n    } else {\n        // Multi-parameter syntax - construct the options according to the params passed\n        options = options || {};\n        if (!readFunction)\n            readFunction = options[\"read\"];\n    }\n    if (typeof readFunction != \"function\")\n        throw new Error(\"Pass a function that returns the value of the ko.computed\");\n\n    function addDependencyTracking(id, target, trackingObj) {\n        if (pure && target === dependentObservable) {\n            throw Error(\"A 'pure' computed must not be called recursively\");\n        }\n\n        dependencyTracking[id] = trackingObj;\n        trackingObj._order = _dependenciesCount++;\n        trackingObj._version = target.getVersion();\n    }\n\n    function haveDependenciesChanged() {\n        var id, dependency;\n        for (id in dependencyTracking) {\n            if (dependencyTracking.hasOwnProperty(id)) {\n                dependency = dependencyTracking[id];\n                if (dependency._target.hasChanged(dependency._version)) {\n                    return true;\n                }\n            }\n        }\n    }\n\n    function disposeComputed() {\n        if (!isSleeping && dependencyTracking) {\n            ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                if (dependency.dispose)\n                    dependency.dispose();\n            });\n        }\n        dependencyTracking = null;\n        _dependenciesCount = 0;\n        _isDisposed = true;\n        _needsEvaluation = false;\n        isSleeping = false;\n    }\n\n    function evaluatePossiblyAsync() {\n        var throttleEvaluationTimeout = dependentObservable['throttleEvaluation'];\n        if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n            clearTimeout(evaluationTimeoutInstance);\n            evaluationTimeoutInstance = setTimeout(function () {\n                evaluateImmediate(true /*notifyChange*/);\n            }, throttleEvaluationTimeout);\n        } else if (dependentObservable._evalRateLimited) {\n            dependentObservable._evalRateLimited();\n        } else {\n            evaluateImmediate(true /*notifyChange*/);\n        }\n    }\n\n    function evaluateImmediate(notifyChange) {\n        if (_isBeingEvaluated) {\n            // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n            // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n            // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n            // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n            return;\n        }\n\n        // Do not evaluate (and possibly capture new dependencies) if disposed\n        if (_isDisposed) {\n            return;\n        }\n\n        if (disposeWhen && disposeWhen()) {\n            // See comment below about _suppressDisposalUntilDisposeWhenReturnsFalse\n            if (!_suppressDisposalUntilDisposeWhenReturnsFalse) {\n                dispose();\n                return;\n            }\n        } else {\n            // It just did return false, so we can stop suppressing now\n            _suppressDisposalUntilDisposeWhenReturnsFalse = false;\n        }\n\n        _isBeingEvaluated = true;\n\n        try {\n            // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n            // Then, during evaluation, we cross off any that are in fact still being used.\n            var disposalCandidates = dependencyTracking,\n                disposalCount = _dependenciesCount,\n                isInitial = pure ? undefined : !_dependenciesCount;   // If we're evaluating when there are no previous dependencies, it must be the first time\n\n            ko.dependencyDetection.begin({\n                callback: function(subscribable, id) {\n                    if (!_isDisposed) {\n                        if (disposalCount && disposalCandidates[id]) {\n                            // Don't want to dispose this subscription, as it's still being used\n                            addDependencyTracking(id, subscribable, disposalCandidates[id]);\n                            delete disposalCandidates[id];\n                            --disposalCount;\n                        } else if (!dependencyTracking[id]) {\n                            // Brand new subscription - add it\n                            addDependencyTracking(id, subscribable, isSleeping ? { _target: subscribable } : subscribable.subscribe(evaluatePossiblyAsync));\n                        }\n                    }\n                },\n                computed: dependentObservable,\n                isInitial: isInitial\n            });\n\n            dependencyTracking = {};\n            _dependenciesCount = 0;\n\n            try {\n                var newValue = evaluatorFunctionTarget ? readFunction.call(evaluatorFunctionTarget) : readFunction();\n\n            } finally {\n                ko.dependencyDetection.end();\n\n                // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                if (disposalCount && !isSleeping) {\n                    ko.utils.objectForEach(disposalCandidates, function(id, toDispose) {\n                        if (toDispose.dispose)\n                            toDispose.dispose();\n                    });\n                }\n\n                _needsEvaluation = false;\n            }\n\n            if (dependentObservable.isDifferent(_latestValue, newValue)) {\n                if (!isSleeping) {\n                    notify(_latestValue, \"beforeChange\");\n                }\n\n                _latestValue = newValue;\n                if (DEBUG) dependentObservable._latestValue = _latestValue;\n\n                if (isSleeping) {\n                    dependentObservable.updateVersion();\n                } else if (notifyChange) {\n                    notify(_latestValue);\n                }\n            }\n\n            if (isInitial) {\n                notify(_latestValue, \"awake\");\n            }\n        } finally {\n            _isBeingEvaluated = false;\n        }\n\n        if (!_dependenciesCount)\n            dispose();\n    }\n\n    function dependentObservable() {\n        if (arguments.length > 0) {\n            if (typeof writeFunction === \"function\") {\n                // Writing a value\n                writeFunction.apply(evaluatorFunctionTarget, arguments);\n            } else {\n                throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n            }\n            return this; // Permits chained assignments\n        } else {\n            // Reading the value\n            ko.dependencyDetection.registerDependency(dependentObservable);\n            if (_needsEvaluation || (isSleeping && haveDependenciesChanged())) {\n                evaluateImmediate();\n            }\n            return _latestValue;\n        }\n    }\n\n    function peek() {\n        // Peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n        if ((_needsEvaluation && !_dependenciesCount) || (isSleeping && haveDependenciesChanged())) {\n            evaluateImmediate();\n        }\n        return _latestValue;\n    }\n\n    function isActive() {\n        return _needsEvaluation || _dependenciesCount > 0;\n    }\n\n    function notify(value, event) {\n        dependentObservable[\"notifySubscribers\"](value, event);\n    }\n\n    // By here, \"options\" is always non-null\n    var writeFunction = options[\"write\"],\n        disposeWhenNodeIsRemoved = options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n        disposeWhenOption = options[\"disposeWhen\"] || options.disposeWhen,\n        disposeWhen = disposeWhenOption,\n        dispose = disposeComputed,\n        dependencyTracking = {},\n        _dependenciesCount = 0,\n        evaluationTimeoutInstance = null;\n\n    if (!evaluatorFunctionTarget)\n        evaluatorFunctionTarget = options[\"owner\"];\n\n    ko.subscribable.call(dependentObservable);\n    ko.utils.setPrototypeOfOrExtend(dependentObservable, ko.dependentObservable['fn']);\n\n    dependentObservable.peek = peek;\n    dependentObservable.getDependenciesCount = function () { return _dependenciesCount; };\n    dependentObservable.hasWriteFunction = typeof writeFunction === \"function\";\n    dependentObservable.dispose = function () { dispose(); };\n    dependentObservable.isActive = isActive;\n\n    // Replace the limit function with one that delays evaluation as well.\n    var originalLimit = dependentObservable.limit;\n    dependentObservable.limit = function(limitFunction) {\n        originalLimit.call(dependentObservable, limitFunction);\n        dependentObservable._evalRateLimited = function() {\n            dependentObservable._rateLimitedBeforeChange(_latestValue);\n\n            _needsEvaluation = true;    // Mark as dirty\n\n            // Pass the observable to the rate-limit code, which will access it when\n            // it's time to do the notification.\n            dependentObservable._rateLimitedChange(dependentObservable);\n        }\n    };\n\n    if (options['pure']) {\n        pure = true;\n        isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n        dependentObservable.beforeSubscriptionAdd = function (event) {\n            // If asleep, wake up the computed by subscribing to any dependencies.\n            if (!_isDisposed && isSleeping && event == 'change') {\n                isSleeping = false;\n                if (_needsEvaluation || haveDependenciesChanged()) {\n                    dependencyTracking = null;\n                    _dependenciesCount = 0;\n                    _needsEvaluation = true;\n                    evaluateImmediate();\n                } else {\n                    // First put the dependencies in order\n                    var dependeciesOrder = [];\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependeciesOrder[dependency._order] = id;\n                    });\n                    // Next, subscribe to each one\n                    ko.utils.arrayForEach(dependeciesOrder, function(id, order) {\n                        var dependency = dependencyTracking[id],\n                            subscription = dependency._target.subscribe(evaluatePossiblyAsync);\n                        subscription._order = order;\n                        subscription._version = dependency._version;\n                        dependencyTracking[id] = subscription;\n                    });\n                }\n                if (!_isDisposed) {     // test since evaluating could trigger disposal\n                    notify(_latestValue, \"awake\");\n                }\n            }\n        };\n\n        dependentObservable.afterSubscriptionRemove = function (event) {\n            if (!_isDisposed && event == 'change' && !dependentObservable.hasSubscriptionsForEvent('change')) {\n                ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                    if (dependency.dispose) {\n                        dependencyTracking[id] = {\n                            _target: dependency._target,\n                            _order: dependency._order,\n                            _version: dependency._version\n                        };\n                        dependency.dispose();\n                    }\n                });\n                isSleeping = true;\n                notify(undefined, \"asleep\");\n            }\n        };\n\n        // Because a pure computed is not automatically updated while it is sleeping, we can't\n        // simply return the version number. Instead, we check if any of the dependencies have\n        // changed and conditionally re-evaluate the computed observable.\n        dependentObservable._originalGetVersion = dependentObservable.getVersion;\n        dependentObservable.getVersion = function () {\n            if (isSleeping && (_needsEvaluation || haveDependenciesChanged())) {\n                evaluateImmediate();\n            }\n            return dependentObservable._originalGetVersion();\n        };\n    } else if (options['deferEvaluation']) {\n        // This will force a computed with deferEvaluation to evaluate when the first subscriptions is registered.\n        dependentObservable.beforeSubscriptionAdd = function (event) {\n            if (event == 'change' || event == 'beforeChange') {\n                peek();\n            }\n        }\n    }\n\n    ko.exportProperty(dependentObservable, 'peek', dependentObservable.peek);\n    ko.exportProperty(dependentObservable, 'dispose', dependentObservable.dispose);\n    ko.exportProperty(dependentObservable, 'isActive', dependentObservable.isActive);\n    ko.exportProperty(dependentObservable, 'getDependenciesCount', dependentObservable.getDependenciesCount);\n\n    // Add a \"disposeWhen\" callback that, on each evaluation, disposes if the node was removed without using ko.removeNode.\n    if (disposeWhenNodeIsRemoved) {\n        // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n        // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n        // we'll prevent disposal until \"disposeWhen\" first returns false.\n        _suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n        // Only watch for the node's disposal if the value really is a node. It might not be,\n        // e.g., { disposeWhenNodeIsRemoved: true } can be used to opt into the \"only dispose\n        // after first false result\" behaviour even if there's no specific node to watch. This\n        // technique is intended for KO's internal use only and shouldn't be documented or used\n        // by application code, as it's likely to change in a future version of KO.\n        if (disposeWhenNodeIsRemoved.nodeType) {\n            disposeWhen = function () {\n                return !ko.utils.domNodeIsAttachedToDocument(disposeWhenNodeIsRemoved) || (disposeWhenOption && disposeWhenOption());\n            };\n        }\n    }\n\n    // Evaluate, unless sleeping or deferEvaluation is true\n    if (!isSleeping && !options['deferEvaluation'])\n        evaluateImmediate();\n\n    // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n    // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n    if (disposeWhenNodeIsRemoved && isActive() && disposeWhenNodeIsRemoved.nodeType) {\n        dispose = function() {\n            ko.utils.domNodeDisposal.removeDisposeCallback(disposeWhenNodeIsRemoved, dispose);\n            disposeComputed();\n        };\n        ko.utils.domNodeDisposal.addDisposeCallback(disposeWhenNodeIsRemoved, dispose);\n    }\n\n    return dependentObservable;\n};\n\nko.isComputed = function(instance) {\n    return ko.hasPrototype(instance, ko.dependentObservable);\n};\n\nvar protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\nko.dependentObservable[protoProp] = ko.observable;\n\nko.dependentObservable['fn'] = {\n    \"equalityComparer\": valuesArePrimitiveAndEqual\n};\nko.dependentObservable['fn'][protoProp] = ko.dependentObservable;\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.dependentObservable constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.dependentObservable['fn'], ko.subscribable['fn']);\n}\n\nko.exportSymbol('dependentObservable', ko.dependentObservable);\nko.exportSymbol('computed', ko.dependentObservable); // Make \"ko.computed\" an alias for \"ko.dependentObservable\"\nko.exportSymbol('isComputed', ko.isComputed);\n\nko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n    if (typeof evaluatorFunctionOrOptions === 'function') {\n        return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n    } else {\n        evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n        evaluatorFunctionOrOptions['pure'] = true;\n        return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n    }\n}\nko.exportSymbol('pureComputed', ko.pureComputed);\n\n(function() {\n    var maxNestedObservableDepth = 10; // Escape the (unlikely) pathalogical case where an observable's current value is itself (or similar reference cycle)\n\n    ko.toJS = function(rootObject) {\n        if (arguments.length == 0)\n            throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n        // We just unwrap everything at every level in the object graph\n        return mapJsObjectGraph(rootObject, function(valueToMap) {\n            // Loop because an observable's value might in turn be another observable wrapper\n            for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                valueToMap = valueToMap();\n            return valueToMap;\n        });\n    };\n\n    ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n        var plainJavaScriptObject = ko.toJS(rootObject);\n        return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n    };\n\n    function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n        visitedObjects = visitedObjects || new objectLookup();\n\n        rootObject = mapInputCallback(rootObject);\n        var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n        if (!canHaveProperties)\n            return rootObject;\n\n        var outputProperties = rootObject instanceof Array ? [] : {};\n        visitedObjects.save(rootObject, outputProperties);\n\n        visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n            var propertyValue = mapInputCallback(rootObject[indexer]);\n\n            switch (typeof propertyValue) {\n                case \"boolean\":\n                case \"number\":\n                case \"string\":\n                case \"function\":\n                    outputProperties[indexer] = propertyValue;\n                    break;\n                case \"object\":\n                case \"undefined\":\n                    var previouslyMappedValue = visitedObjects.get(propertyValue);\n                    outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                        ? previouslyMappedValue\n                        : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                    break;\n            }\n        });\n\n        return outputProperties;\n    }\n\n    function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n        if (rootObject instanceof Array) {\n            for (var i = 0; i < rootObject.length; i++)\n                visitorCallback(i);\n\n            // For arrays, also respect toJSON property for custom mappings (fixes #278)\n            if (typeof rootObject['toJSON'] == 'function')\n                visitorCallback('toJSON');\n        } else {\n            for (var propertyName in rootObject) {\n                visitorCallback(propertyName);\n            }\n        }\n    };\n\n    function objectLookup() {\n        this.keys = [];\n        this.values = [];\n    };\n\n    objectLookup.prototype = {\n        constructor: objectLookup,\n        save: function(key, value) {\n            var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n            if (existingIndex >= 0)\n                this.values[existingIndex] = value;\n            else {\n                this.keys.push(key);\n                this.values.push(value);\n            }\n        },\n        get: function(key) {\n            var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n            return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n        }\n    };\n})();\n\nko.exportSymbol('toJS', ko.toJS);\nko.exportSymbol('toJSON', ko.toJSON);\n(function () {\n    var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n    // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n    // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n    // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n    ko.selectExtensions = {\n        readValue : function(element) {\n            switch (ko.utils.tagNameLower(element)) {\n                case 'option':\n                    if (element[hasDomDataExpandoProperty] === true)\n                        return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                    return ko.utils.ieVersion <= 7\n                        ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                        : element.value;\n                case 'select':\n                    return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                default:\n                    return element.value;\n            }\n        },\n\n        writeValue: function(element, value, allowUnset) {\n            switch (ko.utils.tagNameLower(element)) {\n                case 'option':\n                    switch(typeof value) {\n                        case \"string\":\n                            ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                            if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                delete element[hasDomDataExpandoProperty];\n                            }\n                            element.value = value;\n                            break;\n                        default:\n                            // Store arbitrary object using DomData\n                            ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                            element[hasDomDataExpandoProperty] = true;\n\n                            // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                            element.value = typeof value === \"number\" ? value : \"\";\n                            break;\n                    }\n                    break;\n                case 'select':\n                    if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                        value = undefined;\n                    var selection = -1;\n                    for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                        optionValue = ko.selectExtensions.readValue(element.options[i]);\n                        // Include special check to handle selecting a caption with a blank string value\n                        if (optionValue == value || (optionValue == \"\" && value === undefined)) {\n                            selection = i;\n                            break;\n                        }\n                    }\n                    if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                        element.selectedIndex = selection;\n                    }\n                    break;\n                default:\n                    if ((value === null) || (value === undefined))\n                        value = \"\";\n                    element.value = value;\n                    break;\n            }\n        }\n    };\n})();\n\nko.exportSymbol('selectExtensions', ko.selectExtensions);\nko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\nko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\nko.expressionRewriting = (function () {\n    var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n    // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n    // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n    // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n    var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n    function getWriteableValue(expression) {\n        if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n            return false;\n        var match = expression.match(javaScriptAssignmentTarget);\n        return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n    }\n\n    // The following regular expressions will be used to split an object-literal string into tokens\n\n        // These two match strings, either with double quotes or single quotes\n    var stringDouble = '\"(?:[^\"\\\\\\\\]|\\\\\\\\.)*\"',\n        stringSingle = \"'(?:[^'\\\\\\\\]|\\\\\\\\.)*'\",\n        // Matches a regular expression (text enclosed by slashes), but will also match sets of divisions\n        // as a regular expression (this is handled by the parsing loop below).\n        stringRegexp = '/(?:[^/\\\\\\\\]|\\\\\\\\.)*/\\w*',\n        // These characters have special meaning to the parser and must not appear in the middle of a\n        // token, except as part of a string.\n        specials = ',\"\\'{}()/:[\\\\]',\n        // Match text (at least two characters) that does not contain any of the above special characters,\n        // although some of the special characters are allowed to start it (all but the colon and comma).\n        // The text can contain spaces, but leading or trailing spaces are skipped.\n        everyThingElse = '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n        // Match any non-space character not matched already. This will match colons and commas, since they're\n        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n        oneNotSpace = '[^\\\\s]',\n\n        // Create the actual regular expression by or-ing the above strings. The order is important.\n        bindingToken = RegExp(stringDouble + '|' + stringSingle + '|' + stringRegexp + '|' + everyThingElse + '|' + oneNotSpace, 'g'),\n\n        // Match end of previous token to determine whether a slash is a division or regex.\n        divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n        keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n    function parseObjectLiteral(objectLiteralString) {\n        // Trim leading and trailing spaces from the string\n        var str = ko.utils.stringTrim(objectLiteralString);\n\n        // Trim braces '{' surrounding the whole object literal\n        if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n        // Split into tokens\n        var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n        if (toks) {\n            // Append a comma so that we don't need a separate code block to deal with the last item\n            toks.push(',');\n\n            for (var i = 0, tok; tok = toks[i]; ++i) {\n                var c = tok.charCodeAt(0);\n                // A comma signals the end of a key/value pair if depth is zero\n                if (c === 44) { // \",\"\n                    if (depth <= 0) {\n                        result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                        key = depth = 0;\n                        values = [];\n                        continue;\n                    }\n                // Simply skip the colon that separates the name and value\n                } else if (c === 58) { // \":\"\n                    if (!depth && !key && values.length === 1) {\n                        key = values.pop();\n                        continue;\n                    }\n                // A set of slashes is initially matched as a regular expression, but could be division\n                } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                    // Look at the end of the previous token to determine if the slash is actually division\n                    var match = toks[i-1].match(divisionLookBehind);\n                    if (match && !keywordRegexLookBehind[match[0]]) {\n                        // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                        str = str.substr(str.indexOf(tok) + 1);\n                        toks = str.match(bindingToken);\n                        toks.push(',');\n                        i = -1;\n                        // Continue with just the slash\n                        tok = '/';\n                    }\n                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                    ++depth;\n                } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                    --depth;\n                // The key will be the first token; if it's a string, trim the quotes\n                } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                    tok = tok.slice(1, -1);\n                }\n                values.push(tok);\n            }\n        }\n        return result;\n    }\n\n    // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n    var twoWayBindings = {};\n\n    function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n        bindingOptions = bindingOptions || {};\n\n        function processKeyValue(key, val) {\n            var writableVal;\n            function callPreprocessHook(obj) {\n                return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n            }\n            if (!bindingParams) {\n                if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                    return;\n\n                if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                    // For two-way bindings, provide a write method in case the value\n                    // isn't a writable observable.\n                    propertyAccessorResultStrings.push(\"'\" + key + \"':function(_z){\" + writableVal + \"=_z}\");\n                }\n            }\n            // Values are wrapped in a function so that each value can be accessed independently\n            if (makeValueAccessors) {\n                val = 'function(){return ' + val + ' }';\n            }\n            resultStrings.push(\"'\" + key + \"':\" + val);\n        }\n\n        var resultStrings = [],\n            propertyAccessorResultStrings = [],\n            makeValueAccessors = bindingOptions['valueAccessors'],\n            bindingParams = bindingOptions['bindingParams'],\n            keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n        ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n            processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n        });\n\n        if (propertyAccessorResultStrings.length)\n            processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n        return resultStrings.join(\",\");\n    }\n\n    return {\n        bindingRewriteValidators: [],\n\n        twoWayBindings: twoWayBindings,\n\n        parseObjectLiteral: parseObjectLiteral,\n\n        preProcessBindings: preProcessBindings,\n\n        keyValueArrayContainsKey: function(keyValueArray, key) {\n            for (var i = 0; i < keyValueArray.length; i++)\n                if (keyValueArray[i]['key'] == key)\n                    return true;\n            return false;\n        },\n\n        // Internal, private KO utility for updating model properties from within bindings\n        // property:            If the property being updated is (or might be) an observable, pass it here\n        //                      If it turns out to be a writable observable, it will be written to directly\n        // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n        //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n        // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n        // value:               The value to be written\n        // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n        //                      it is !== existing value on that writable observable\n        writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n            if (!property || !ko.isObservable(property)) {\n                var propWriters = allBindings.get('_ko_property_writers');\n                if (propWriters && propWriters[key])\n                    propWriters[key](value);\n            } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                property(value);\n            }\n        }\n    };\n})();\n\nko.exportSymbol('expressionRewriting', ko.expressionRewriting);\nko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\nko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\nko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\nko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\nko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\nko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n(function() {\n    // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n    // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n    // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n    // of that virtual hierarchy\n    //\n    // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n    // without having to scatter special cases all over the binding and templating code.\n\n    // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n    // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n    // So, use node.text where available, and node.nodeValue elsewhere\n    var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n    var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n    var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n    var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n    function isStartComment(node) {\n        return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n    }\n\n    function isEndComment(node) {\n        return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n    }\n\n    function getVirtualChildren(startComment, allowUnbalanced) {\n        var currentNode = startComment;\n        var depth = 1;\n        var children = [];\n        while (currentNode = currentNode.nextSibling) {\n            if (isEndComment(currentNode)) {\n                depth--;\n                if (depth === 0)\n                    return children;\n            }\n\n            children.push(currentNode);\n\n            if (isStartComment(currentNode))\n                depth++;\n        }\n        if (!allowUnbalanced)\n            throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n        return null;\n    }\n\n    function getMatchingEndComment(startComment, allowUnbalanced) {\n        var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n        if (allVirtualChildren) {\n            if (allVirtualChildren.length > 0)\n                return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n            return startComment.nextSibling;\n        } else\n            return null; // Must have no matching end comment, and allowUnbalanced is true\n    }\n\n    function getUnbalancedChildTags(node) {\n        // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n        //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n        var childNode = node.firstChild, captureRemaining = null;\n        if (childNode) {\n            do {\n                if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                    captureRemaining.push(childNode);\n                else if (isStartComment(childNode)) {\n                    var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                    if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                        childNode = matchingEndComment;\n                    else\n                        captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                } else if (isEndComment(childNode)) {\n                    captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                }\n            } while (childNode = childNode.nextSibling);\n        }\n        return captureRemaining;\n    }\n\n    ko.virtualElements = {\n        allowedBindings: {},\n\n        childNodes: function(node) {\n            return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n        },\n\n        emptyNode: function(node) {\n            if (!isStartComment(node))\n                ko.utils.emptyDomNode(node);\n            else {\n                var virtualChildren = ko.virtualElements.childNodes(node);\n                for (var i = 0, j = virtualChildren.length; i < j; i++)\n                    ko.removeNode(virtualChildren[i]);\n            }\n        },\n\n        setDomNodeChildren: function(node, childNodes) {\n            if (!isStartComment(node))\n                ko.utils.setDomNodeChildren(node, childNodes);\n            else {\n                ko.virtualElements.emptyNode(node);\n                var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                for (var i = 0, j = childNodes.length; i < j; i++)\n                    endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n            }\n        },\n\n        prepend: function(containerNode, nodeToPrepend) {\n            if (!isStartComment(containerNode)) {\n                if (containerNode.firstChild)\n                    containerNode.insertBefore(nodeToPrepend, containerNode.firstChild);\n                else\n                    containerNode.appendChild(nodeToPrepend);\n            } else {\n                // Start comments must always have a parent and at least one following sibling (the end comment)\n                containerNode.parentNode.insertBefore(nodeToPrepend, containerNode.nextSibling);\n            }\n        },\n\n        insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n            if (!insertAfterNode) {\n                ko.virtualElements.prepend(containerNode, nodeToInsert);\n            } else if (!isStartComment(containerNode)) {\n                // Insert after insertion point\n                if (insertAfterNode.nextSibling)\n                    containerNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);\n                else\n                    containerNode.appendChild(nodeToInsert);\n            } else {\n                // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                containerNode.parentNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);\n            }\n        },\n\n        firstChild: function(node) {\n            if (!isStartComment(node))\n                return node.firstChild;\n            if (!node.nextSibling || isEndComment(node.nextSibling))\n                return null;\n            return node.nextSibling;\n        },\n\n        nextSibling: function(node) {\n            if (isStartComment(node))\n                node = getMatchingEndComment(node);\n            if (node.nextSibling && isEndComment(node.nextSibling))\n                return null;\n            return node.nextSibling;\n        },\n\n        hasBindingValue: isStartComment,\n\n        virtualNodeBindingValue: function(node) {\n            var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n            return regexMatch ? regexMatch[1] : null;\n        },\n\n        normaliseVirtualElementDomStructure: function(elementVerified) {\n            // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n            // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n            // that are direct descendants of <ul> into the preceding <li>)\n            if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                return;\n\n            // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n            // must be intended to appear *after* that child, so move them there.\n            var childNode = elementVerified.firstChild;\n            if (childNode) {\n                do {\n                    if (childNode.nodeType === 1) {\n                        var unbalancedTags = getUnbalancedChildTags(childNode);\n                        if (unbalancedTags) {\n                            // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                            var nodeToInsertBefore = childNode.nextSibling;\n                            for (var i = 0; i < unbalancedTags.length; i++) {\n                                if (nodeToInsertBefore)\n                                    elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                else\n                                    elementVerified.appendChild(unbalancedTags[i]);\n                            }\n                        }\n                    }\n                } while (childNode = childNode.nextSibling);\n            }\n        }\n    };\n})();\nko.exportSymbol('virtualElements', ko.virtualElements);\nko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\nko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\nko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\nko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\nko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n(function() {\n    var defaultBindingAttributeName = \"data-bind\";\n\n    ko.bindingProvider = function() {\n        this.bindingCache = {};\n    };\n\n    ko.utils.extend(ko.bindingProvider.prototype, {\n        'nodeHasBindings': function(node) {\n            switch (node.nodeType) {\n                case 1: // Element\n                    return node.getAttribute(defaultBindingAttributeName) != null\n                        || ko.components['getComponentNameForNode'](node);\n                case 8: // Comment node\n                    return ko.virtualElements.hasBindingValue(node);\n                default: return false;\n            }\n        },\n\n        'getBindings': function(node, bindingContext) {\n            var bindingsString = this['getBindingsString'](node, bindingContext),\n                parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n            return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n        },\n\n        'getBindingAccessors': function(node, bindingContext) {\n            var bindingsString = this['getBindingsString'](node, bindingContext),\n                parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n            return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n        },\n\n        // The following function is only used internally by this default provider.\n        // It's not part of the interface definition for a general binding provider.\n        'getBindingsString': function(node, bindingContext) {\n            switch (node.nodeType) {\n                case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                default: return null;\n            }\n        },\n\n        // The following function is only used internally by this default provider.\n        // It's not part of the interface definition for a general binding provider.\n        'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n            try {\n                var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                return bindingFunction(bindingContext, node);\n            } catch (ex) {\n                ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                throw ex;\n            }\n        }\n    });\n\n    ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n    function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n        var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n        return cache[cacheKey]\n            || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n    }\n\n    function createBindingsStringEvaluator(bindingsString, options) {\n        // Build the source for a function that evaluates \"expression\"\n        // For each scope variable, add an extra level of \"with\" nesting\n        // Example result: with(sc1) { with(sc0) { return (expression) } }\n        var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n            functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n        return new Function(\"$context\", \"$element\", functionBody);\n    }\n})();\n\nko.exportSymbol('bindingProvider', ko.bindingProvider);\n(function () {\n    ko.bindingHandlers = {};\n\n    // The following element types will not be recursed into during binding. In the future, we\n    // may consider adding <template> to this list, because such elements' contents are always\n    // intended to be bound in a different context from where they appear in the document.\n    var bindingDoesNotRecurseIntoElementTypes = {\n        // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n        // because it's unexpected and a potential XSS issue\n        'script': true,\n        'textarea': true\n    };\n\n    // Use an overridable method for retrieving binding handlers so that a plugins may support dynamically created handlers\n    ko['getBindingHandler'] = function(bindingKey) {\n        return ko.bindingHandlers[bindingKey];\n    };\n\n    // The ko.bindingContext constructor is only called directly to create the root context. For child\n    // contexts, use bindingContext.createChildContext or bindingContext.extend.\n    ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback) {\n\n        // The binding context object includes static properties for the current, parent, and root view models.\n        // If a view model is actually stored in an observable, the corresponding binding context object, and\n        // any child contexts, must be updated when the view model is changed.\n        function updateContext() {\n            // Most of the time, the context will directly get a view model object, but if a function is given,\n            // we call the function to retrieve the view model. If the function accesses any obsevables or returns\n            // an observable, the dependency is tracked, and those observables can later cause the binding\n            // context to be updated.\n            var dataItemOrObservable = isFunc ? dataItemOrAccessor() : dataItemOrAccessor,\n                dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n            if (parentContext) {\n                // When a \"parent\" context is given, register a dependency on the parent context. Thus whenever the\n                // parent context is updated, this context will also be updated.\n                if (parentContext._subscribable)\n                    parentContext._subscribable();\n\n                // Copy $root and any custom properties from the parent context\n                ko.utils.extend(self, parentContext);\n\n                // Because the above copy overwrites our own properties, we need to reset them.\n                // During the first execution, \"subscribable\" isn't set, so don't bother doing the update then.\n                if (subscribable) {\n                    self._subscribable = subscribable;\n                }\n            } else {\n                self['$parents'] = [];\n                self['$root'] = dataItem;\n\n                // Export 'ko' in the binding context so it will be available in bindings and templates\n                // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                // See https://github.com/SteveSanderson/knockout/issues/490\n                self['ko'] = ko;\n            }\n            self['$rawData'] = dataItemOrObservable;\n            self['$data'] = dataItem;\n            if (dataItemAlias)\n                self[dataItemAlias] = dataItem;\n\n            // The extendCallback function is provided when creating a child context or extending a context.\n            // It handles the specific actions needed to finish setting up the binding context. Actions in this\n            // function could also add dependencies to this binding context.\n            if (extendCallback)\n                extendCallback(self, parentContext, dataItem);\n\n            return self['$data'];\n        }\n        function disposeWhen() {\n            return nodes && !ko.utils.anyDomNodeIsAttachedToDocument(nodes);\n        }\n\n        var self = this,\n            isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor),\n            nodes,\n            subscribable = ko.dependentObservable(updateContext, null, { disposeWhen: disposeWhen, disposeWhenNodeIsRemoved: true });\n\n        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n        // the context object.\n        if (subscribable.isActive()) {\n            self._subscribable = subscribable;\n\n            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n            subscribable['equalityComparer'] = null;\n\n            // We need to be able to dispose of this computed observable when it's no longer needed. This would be\n            // easy if we had a single node to watch, but binding contexts can be used by many different nodes, and\n            // we cannot assume that those nodes have any relation to each other. So instead we track any node that\n            // the context is attached to, and dispose the computed when all of those nodes have been cleaned.\n\n            // Add properties to *subscribable* instead of *self* because any properties added to *self* may be overwritten on updates\n            nodes = [];\n            subscribable._addNode = function(node) {\n                nodes.push(node);\n                ko.utils.domNodeDisposal.addDisposeCallback(node, function(node) {\n                    ko.utils.arrayRemoveItem(nodes, node);\n                    if (!nodes.length) {\n                        subscribable.dispose();\n                        self._subscribable = subscribable = undefined;\n                    }\n                });\n            };\n        }\n    }\n\n    // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n    // any obsevables, the new child context will automatically get a dependency on the parent context.\n    // But this does not mean that the $data value of the child context will also get updated. If the child\n    // view model also depends on the parent view model, you must provide a function that returns the correct\n    // view model on each update.\n    ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback) {\n        return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function(self, parentContext) {\n            // Extend the context hierarchy by setting the appropriate pointers\n            self['$parentContext'] = parentContext;\n            self['$parent'] = parentContext['$data'];\n            self['$parents'] = (parentContext['$parents'] || []).slice(0);\n            self['$parents'].unshift(self['$parent']);\n            if (extendCallback)\n                extendCallback(self);\n        });\n    };\n\n    // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n    // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n    // when an observable view model is updated.\n    ko.bindingContext.prototype['extend'] = function(properties) {\n        // If the parent context references an observable view model, \"_subscribable\" will always be the\n        // latest view model object. If not, \"_subscribable\" isn't set, and we can use the static \"$data\" value.\n        return new ko.bindingContext(this._subscribable || this['$data'], this, null, function(self, parentContext) {\n            // This \"child\" context doesn't directly track a parent observable view model,\n            // so we need to manually set the $rawData value to match the parent.\n            self['$rawData'] = parentContext['$rawData'];\n            ko.utils.extend(self, typeof(properties) == \"function\" ? properties() : properties);\n        });\n    };\n\n    // Returns the valueAccesor function for a binding value\n    function makeValueAccessor(value) {\n        return function() {\n            return value;\n        };\n    }\n\n    // Returns the value of a valueAccessor function\n    function evaluateValueAccessor(valueAccessor) {\n        return valueAccessor();\n    }\n\n    // Given a function that returns bindings, create and return a new object that contains\n    // binding value-accessors functions. Each accessor function calls the original function\n    // so that it always gets the latest value and all dependencies are captured. This is used\n    // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n    function makeAccessorsFromFunction(callback) {\n        return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n            return function() {\n                return callback()[key];\n            };\n        });\n    }\n\n    // Given a bindings function or object, create and return a new object that contains\n    // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n    function makeBindingAccessors(bindings, context, node) {\n        if (typeof bindings === 'function') {\n            return makeAccessorsFromFunction(bindings.bind(null, context, node));\n        } else {\n            return ko.utils.objectMap(bindings, makeValueAccessor);\n        }\n    }\n\n    // This function is used if the binding provider doesn't include a getBindingAccessors function.\n    // It must be called with 'this' set to the provider instance.\n    function getBindingsAndMakeAccessors(node, context) {\n        return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n    }\n\n    function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n        var validator = ko.virtualElements.allowedBindings[bindingName];\n        if (!validator)\n            throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n    }\n\n    function applyBindingsToDescendantsInternal (bindingContext, elementOrVirtualElement, bindingContextsMayDifferFromDomParentElement) {\n        var currentChild,\n            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement),\n            provider = ko.bindingProvider['instance'],\n            preprocessNode = provider['preprocessNode'];\n\n        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n        // trigger insertion of <template> contents at that point in the document.\n        if (preprocessNode) {\n            while (currentChild = nextInQueue) {\n                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                preprocessNode.call(provider, currentChild);\n            }\n            // Reset nextInQueue for the next loop\n            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n        }\n\n        while (currentChild = nextInQueue) {\n            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild, bindingContextsMayDifferFromDomParentElement);\n        }\n    }\n\n    function applyBindingsToNodeAndDescendantsInternal (bindingContext, nodeVerified, bindingContextMayDifferFromDomParentElement) {\n        var shouldBindDescendants = true;\n\n        // Perf optimisation: Apply bindings only if...\n        // (1) We need to store the binding context on this node (because it may differ from the DOM parent node's binding context)\n        //     Note that we can't store binding contexts on non-elements (e.g., text nodes), as IE doesn't allow expando properties for those\n        // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n        var isElement = (nodeVerified.nodeType === 1);\n        if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n            ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n        var shouldApplyBindings = (isElement && bindingContextMayDifferFromDomParentElement)             // Case (1)\n                               || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);       // Case (2)\n        if (shouldApplyBindings)\n            shouldBindDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext, bindingContextMayDifferFromDomParentElement)['shouldBindDescendants'];\n\n        if (shouldBindDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n            // We're recursing automatically into (real or virtual) child nodes without changing binding contexts. So,\n            //  * For children of a *real* element, the binding context is certainly the same as on their DOM .parentNode,\n            //    hence bindingContextsMayDifferFromDomParentElement is false\n            //  * For children of a *virtual* element, we can't be sure. Evaluating .parentNode on those children may\n            //    skip over any number of intermediate virtual elements, any of which might define a custom binding context,\n            //    hence bindingContextsMayDifferFromDomParentElement is true\n            applyBindingsToDescendantsInternal(bindingContext, nodeVerified, /* bindingContextsMayDifferFromDomParentElement: */ !isElement);\n        }\n    }\n\n    var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n\n    function topologicalSortBindings(bindings) {\n        // Depth-first sort\n        var result = [],                // The list of key/handler pairs that we will return\n            bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n            cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n        ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n            if (!bindingsConsidered[bindingKey]) {\n                var binding = ko['getBindingHandler'](bindingKey);\n                if (binding) {\n                    // First add dependencies (if any) of the current binding\n                    if (binding['after']) {\n                        cyclicDependencyStack.push(bindingKey);\n                        ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                            if (bindings[bindingDependencyKey]) {\n                                if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                    throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                } else {\n                                    pushBinding(bindingDependencyKey);\n                                }\n                            }\n                        });\n                        cyclicDependencyStack.length--;\n                    }\n                    // Next add the current binding\n                    result.push({ key: bindingKey, handler: binding });\n                }\n                bindingsConsidered[bindingKey] = true;\n            }\n        });\n\n        return result;\n    }\n\n    function applyBindingsToNodeInternal(node, sourceBindings, bindingContext, bindingContextMayDifferFromDomParentElement) {\n        // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n        var alreadyBound = ko.utils.domData.get(node, boundElementDomDataKey);\n        if (!sourceBindings) {\n            if (alreadyBound) {\n                throw Error(\"You cannot apply bindings multiple times to the same element.\");\n            }\n            ko.utils.domData.set(node, boundElementDomDataKey, true);\n        }\n\n        // Optimization: Don't store the binding context on this node if it's definitely the same as on node.parentNode, because\n        // we can easily recover it just by scanning up the node's ancestors in the DOM\n        // (note: here, parent node means \"real DOM parent\" not \"virtual parent\", as there's no O(1) way to find the virtual parent)\n        if (!alreadyBound && bindingContextMayDifferFromDomParentElement)\n            ko.storedBindingContextForNode(node, bindingContext);\n\n        // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n        var bindings;\n        if (sourceBindings && typeof sourceBindings !== 'function') {\n            bindings = sourceBindings;\n        } else {\n            var provider = ko.bindingProvider['instance'],\n                getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n            // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n            // the binding context is updated or if the binding provider accesses observables.\n            var bindingsUpdater = ko.dependentObservable(\n                function() {\n                    bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                    // Register a dependency on the binding context to support obsevable view models.\n                    if (bindings && bindingContext._subscribable)\n                        bindingContext._subscribable();\n                    return bindings;\n                },\n                null, { disposeWhenNodeIsRemoved: node }\n            );\n\n            if (!bindings || !bindingsUpdater.isActive())\n                bindingsUpdater = null;\n        }\n\n        var bindingHandlerThatControlsDescendantBindings;\n        if (bindings) {\n            // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n            // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n            // the latest binding value and registers a dependency on the binding updater.\n            var getValueAccessor = bindingsUpdater\n                ? function(bindingKey) {\n                    return function() {\n                        return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                    };\n                } : function(bindingKey) {\n                    return bindings[bindingKey];\n                };\n\n            // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n            function allBindings() {\n                return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n            }\n            // The following is the 3.x allBindings API\n            allBindings['get'] = function(key) {\n                return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n            };\n            allBindings['has'] = function(key) {\n                return key in bindings;\n            };\n\n            // First put the bindings into the right order\n            var orderedBindings = topologicalSortBindings(bindings);\n\n            // Go through the sorted bindings, calling init and update for each\n            ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                // so bindingKeyAndHandler.handler will always be nonnull.\n                var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                    handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                    bindingKey = bindingKeyAndHandler.key;\n\n                if (node.nodeType === 8) {\n                    validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                }\n\n                try {\n                    // Run init, ignoring any dependencies\n                    if (typeof handlerInitFn == \"function\") {\n                        ko.dependencyDetection.ignore(function() {\n                            var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, bindingContext['$data'], bindingContext);\n\n                            // If this binding handler claims to control descendant bindings, make a note of this\n                            if (initResult && initResult['controlsDescendantBindings']) {\n                                if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                    throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                bindingHandlerThatControlsDescendantBindings = bindingKey;\n                            }\n                        });\n                    }\n\n                    // Run update in its own computed wrapper\n                    if (typeof handlerUpdateFn == \"function\") {\n                        ko.dependentObservable(\n                            function() {\n                                handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, bindingContext['$data'], bindingContext);\n                            },\n                            null,\n                            { disposeWhenNodeIsRemoved: node }\n                        );\n                    }\n                } catch (ex) {\n                    ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                    throw ex;\n                }\n            });\n        }\n\n        return {\n            'shouldBindDescendants': bindingHandlerThatControlsDescendantBindings === undefined\n        };\n    };\n\n    var storedBindingContextDomDataKey = ko.utils.domData.nextKey();\n    ko.storedBindingContextForNode = function (node, bindingContext) {\n        if (arguments.length == 2) {\n            ko.utils.domData.set(node, storedBindingContextDomDataKey, bindingContext);\n            if (bindingContext._subscribable)\n                bindingContext._subscribable._addNode(node);\n        } else {\n            return ko.utils.domData.get(node, storedBindingContextDomDataKey);\n        }\n    }\n\n    function getBindingContext(viewModelOrBindingContext) {\n        return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n            ? viewModelOrBindingContext\n            : new ko.bindingContext(viewModelOrBindingContext);\n    }\n\n    ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n        if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n            ko.virtualElements.normaliseVirtualElementDomStructure(node);\n        return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext), true);\n    };\n\n    ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n        var context = getBindingContext(viewModelOrBindingContext);\n        return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n    };\n\n    ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n        if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n            applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);\n    };\n\n    ko.applyBindings = function (viewModelOrBindingContext, rootNode) {\n        // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n        if (!jQueryInstance && window['jQuery']) {\n            jQueryInstance = window['jQuery'];\n        }\n\n        if (rootNode && (rootNode.nodeType !== 1) && (rootNode.nodeType !== 8))\n            throw new Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n        rootNode = rootNode || window.document.body; // Make \"rootNode\" parameter optional\n\n        applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);\n    };\n\n    // Retrieving binding context from arbitrary nodes\n    ko.contextFor = function(node) {\n        // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n        switch (node.nodeType) {\n            case 1:\n            case 8:\n                var context = ko.storedBindingContextForNode(node);\n                if (context) return context;\n                if (node.parentNode) return ko.contextFor(node.parentNode);\n                break;\n        }\n        return undefined;\n    };\n    ko.dataFor = function(node) {\n        var context = ko.contextFor(node);\n        return context ? context['$data'] : undefined;\n    };\n\n    ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n    ko.exportSymbol('applyBindings', ko.applyBindings);\n    ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n    ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n    ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n    ko.exportSymbol('contextFor', ko.contextFor);\n    ko.exportSymbol('dataFor', ko.dataFor);\n})();\n(function(undefined) {\n    var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n        loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n    ko.components = {\n        get: function(componentName, callback) {\n            var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n            if (cachedDefinition) {\n                // It's already loaded and cached. Reuse the same definition object.\n                // Note that for API consistency, even cache hits complete asynchronously by default.\n                // You can bypass this by putting synchronous:true on your component config.\n                if (cachedDefinition.isSynchronousComponent) {\n                    ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                        callback(cachedDefinition.definition);\n                    });\n                } else {\n                    setTimeout(function() { callback(cachedDefinition.definition); }, 0);\n                }\n            } else {\n                // Join the loading process that is already underway, or start a new one.\n                loadComponentAndNotify(componentName, callback);\n            }\n        },\n\n        clearCachedDefinition: function(componentName) {\n            delete loadedDefinitionsCache[componentName];\n        },\n\n        _getFirstResultFromLoaders: getFirstResultFromLoaders\n    };\n\n    function getObjectOwnProperty(obj, propName) {\n        return obj.hasOwnProperty(propName) ? obj[propName] : undefined;\n    }\n\n    function loadComponentAndNotify(componentName, callback) {\n        var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n            completedAsync;\n        if (!subscribable) {\n            // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n            subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n            subscribable.subscribe(callback);\n\n            beginLoadingComponent(componentName, function(definition, config) {\n                var isSynchronousComponent = !!(config && config['synchronous']);\n                loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                delete loadingSubscribablesCache[componentName];\n\n                // For API consistency, all loads complete asynchronously. However we want to avoid\n                // adding an extra setTimeout if it's unnecessary (i.e., the completion is already\n                // async) since setTimeout(..., 0) still takes about 16ms or more on most browsers.\n                //\n                // You can bypass the 'always synchronous' feature by putting the synchronous:true\n                // flag on your component configuration when you register it.\n                if (completedAsync || isSynchronousComponent) {\n                    // Note that notifySubscribers ignores any dependencies read within the callback.\n                    // See comment in loaderRegistryBehaviors.js for reasoning\n                    subscribable['notifySubscribers'](definition);\n                } else {\n                    setTimeout(function() {\n                        subscribable['notifySubscribers'](definition);\n                    }, 0);\n                }\n            });\n            completedAsync = true;\n        } else {\n            subscribable.subscribe(callback);\n        }\n    }\n\n    function beginLoadingComponent(componentName, callback) {\n        getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n            if (config) {\n                // We have a config, so now load its definition\n                getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                    callback(definition, config);\n                });\n            } else {\n                // The component has no config - it's unknown to all the loaders.\n                // Note that this is not an error (e.g., a module loading error) - that would abort the\n                // process and this callback would not run. For this callback to run, all loaders must\n                // have confirmed they don't know about this component.\n                callback(null, null);\n            }\n        });\n    }\n\n    function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n        // On the first call in the stack, start with the full set of loaders\n        if (!candidateLoaders) {\n            candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n        }\n\n        // Try the next candidate\n        var currentCandidateLoader = candidateLoaders.shift();\n        if (currentCandidateLoader) {\n            var methodInstance = currentCandidateLoader[methodName];\n            if (methodInstance) {\n                var wasAborted = false,\n                    synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                        if (wasAborted) {\n                            callback(null);\n                        } else if (result !== null) {\n                            // This candidate returned a value. Use it.\n                            callback(result);\n                        } else {\n                            // Try the next candidate\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    }));\n\n                // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                // that we'll extend the API to support synchronous return values in the future. It won't be\n                // a breaking change, because currently no loader is allowed to return anything except undefined.\n                if (synchronousReturnValue !== undefined) {\n                    wasAborted = true;\n\n                    // Method to suppress exceptions will remain undocumented. This is only to keep\n                    // KO's specs running tidily, since we can observe the loading got aborted without\n                    // having exceptions cluttering up the console too.\n                    if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                        throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                    }\n                }\n            } else {\n                // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n            }\n        } else {\n            // No candidates returned a value\n            callback(null);\n        }\n    }\n\n    // Reference the loaders via string name so it's possible for developers\n    // to replace the whole array by assigning to ko.components.loaders\n    ko.components['loaders'] = [];\n\n    ko.exportSymbol('components', ko.components);\n    ko.exportSymbol('components.get', ko.components.get);\n    ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n})();\n(function(undefined) {\n\n    // The default loader is responsible for two things:\n    // 1. Maintaining the default in-memory registry of component configuration objects\n    //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n    // 2. Answering requests for components by fetching configuration objects\n    //    from that default in-memory registry and resolving them into standard\n    //    component definition objects (of the form { createViewModel: ..., template: ... })\n    // Custom loaders may override either of these facilities, i.e.,\n    // 1. To supply configuration objects from some other source (e.g., conventions)\n    // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n    var defaultConfigRegistry = {};\n\n    ko.components.register = function(componentName, config) {\n        if (!config) {\n            throw new Error('Invalid configuration for ' + componentName);\n        }\n\n        if (ko.components.isRegistered(componentName)) {\n            throw new Error('Component ' + componentName + ' is already registered');\n        }\n\n        defaultConfigRegistry[componentName] = config;\n    }\n\n    ko.components.isRegistered = function(componentName) {\n        return componentName in defaultConfigRegistry;\n    }\n\n    ko.components.unregister = function(componentName) {\n        delete defaultConfigRegistry[componentName];\n        ko.components.clearCachedDefinition(componentName);\n    }\n\n    ko.components.defaultLoader = {\n        'getConfig': function(componentName, callback) {\n            var result = defaultConfigRegistry.hasOwnProperty(componentName)\n                ? defaultConfigRegistry[componentName]\n                : null;\n            callback(result);\n        },\n\n        'loadComponent': function(componentName, config, callback) {\n            var errorCallback = makeErrorCallback(componentName);\n            possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                resolveConfig(componentName, errorCallback, loadedConfig, callback);\n            });\n        },\n\n        'loadTemplate': function(componentName, templateConfig, callback) {\n            resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n        },\n\n        'loadViewModel': function(componentName, viewModelConfig, callback) {\n            resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n        }\n    };\n\n    var createViewModelKey = 'createViewModel';\n\n    // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n    // into the standard component definition format:\n    //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n    // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n    // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n    // so this is implemented manually below.\n    function resolveConfig(componentName, errorCallback, config, callback) {\n        var result = {},\n            makeCallBackWhenZero = 2,\n            tryIssueCallback = function() {\n                if (--makeCallBackWhenZero === 0) {\n                    callback(result);\n                }\n            },\n            templateConfig = config['template'],\n            viewModelConfig = config['viewModel'];\n\n        if (templateConfig) {\n            possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                    result['template'] = resolvedTemplate;\n                    tryIssueCallback();\n                });\n            });\n        } else {\n            tryIssueCallback();\n        }\n\n        if (viewModelConfig) {\n            possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                    result[createViewModelKey] = resolvedViewModel;\n                    tryIssueCallback();\n                });\n            });\n        } else {\n            tryIssueCallback();\n        }\n    }\n\n    function resolveTemplate(errorCallback, templateConfig, callback) {\n        if (typeof templateConfig === 'string') {\n            // Markup - parse it\n            callback(ko.utils.parseHtmlFragment(templateConfig));\n        } else if (templateConfig instanceof Array) {\n            // Assume already an array of DOM nodes - pass through unchanged\n            callback(templateConfig);\n        } else if (isDocumentFragment(templateConfig)) {\n            // Document fragment - use its child nodes\n            callback(ko.utils.makeArray(templateConfig.childNodes));\n        } else if (templateConfig['element']) {\n            var element = templateConfig['element'];\n            if (isDomElement(element)) {\n                // Element instance - copy its child nodes\n                callback(cloneNodesFromTemplateSourceElement(element));\n            } else if (typeof element === 'string') {\n                // Element ID - find it, then copy its child nodes\n                var elemInstance = document.getElementById(element);\n                if (elemInstance) {\n                    callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                } else {\n                    errorCallback('Cannot find element with ID ' + element);\n                }\n            } else {\n                errorCallback('Unknown element type: ' + element);\n            }\n        } else {\n            errorCallback('Unknown template value: ' + templateConfig);\n        }\n    }\n\n    function resolveViewModel(errorCallback, viewModelConfig, callback) {\n        if (typeof viewModelConfig === 'function') {\n            // Constructor - convert to standard factory function format\n            // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n            // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n            // be used in factory functions, not viewmodel constructors.\n            callback(function (params /*, componentInfo */) {\n                return new viewModelConfig(params);\n            });\n        } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n            // Already a factory function - use it as-is\n            callback(viewModelConfig[createViewModelKey]);\n        } else if ('instance' in viewModelConfig) {\n            // Fixed object instance - promote to createViewModel format for API consistency\n            var fixedInstance = viewModelConfig['instance'];\n            callback(function (params, componentInfo) {\n                return fixedInstance;\n            });\n        } else if ('viewModel' in viewModelConfig) {\n            // Resolved AMD module whose value is of the form { viewModel: ... }\n            resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n        } else {\n            errorCallback('Unknown viewModel value: ' + viewModelConfig);\n        }\n    }\n\n    function cloneNodesFromTemplateSourceElement(elemInstance) {\n        switch (ko.utils.tagNameLower(elemInstance)) {\n            case 'script':\n                return ko.utils.parseHtmlFragment(elemInstance.text);\n            case 'textarea':\n                return ko.utils.parseHtmlFragment(elemInstance.value);\n            case 'template':\n                // For browsers with proper <template> element support (i.e., where the .content property\n                // gives a document fragment), use that document fragment.\n                if (isDocumentFragment(elemInstance.content)) {\n                    return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                }\n        }\n\n        // Regular elements such as <div>, and <template> elements on old browsers that don't really\n        // understand <template> and just treat it as a regular container\n        return ko.utils.cloneNodes(elemInstance.childNodes);\n    }\n\n    function isDomElement(obj) {\n        if (window['HTMLElement']) {\n            return obj instanceof HTMLElement;\n        } else {\n            return obj && obj.tagName && obj.nodeType === 1;\n        }\n    }\n\n    function isDocumentFragment(obj) {\n        if (window['DocumentFragment']) {\n            return obj instanceof DocumentFragment;\n        } else {\n            return obj && obj.nodeType === 11;\n        }\n    }\n\n    function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n        if (typeof config['require'] === 'string') {\n            // The config is the value of an AMD module\n            if (amdRequire || window['require']) {\n                (amdRequire || window['require'])([config['require']], callback);\n            } else {\n                errorCallback('Uses require, but no AMD loader is present');\n            }\n        } else {\n            callback(config);\n        }\n    }\n\n    function makeErrorCallback(componentName) {\n        return function (message) {\n            throw new Error('Component \\'' + componentName + '\\': ' + message);\n        };\n    }\n\n    ko.exportSymbol('components.register', ko.components.register);\n    ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n    ko.exportSymbol('components.unregister', ko.components.unregister);\n\n    // Expose the default loader so that developers can directly ask it for configuration\n    // or to resolve configuration\n    ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n    // By default, the default loader is the only registered component loader\n    ko.components['loaders'].push(ko.components.defaultLoader);\n\n    // Privately expose the underlying config registry for use in old-IE shim\n    ko.components._allRegisteredComponents = defaultConfigRegistry;\n})();\n(function (undefined) {\n    // Overridable API for determining which component name applies to a given node. By overriding this,\n    // you can for example map specific tagNames to components that are not preregistered.\n    ko.components['getComponentNameForNode'] = function(node) {\n        var tagNameLower = ko.utils.tagNameLower(node);\n        return ko.components.isRegistered(tagNameLower) && tagNameLower;\n    };\n\n    ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n        // Determine if it's really a custom element matching a component\n        if (node.nodeType === 1) {\n            var componentName = ko.components['getComponentNameForNode'](node);\n            if (componentName) {\n                // It does represent a component, so add a component binding for it\n                allBindings = allBindings || {};\n\n                if (allBindings['component']) {\n                    // Avoid silently overwriting some other 'component' binding that may already be on the element\n                    throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                }\n\n                var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                allBindings['component'] = valueAccessors\n                    ? function() { return componentBindingValue; }\n                    : componentBindingValue;\n            }\n        }\n\n        return allBindings;\n    }\n\n    var nativeBindingProviderInstance = new ko.bindingProvider();\n\n    function getComponentParamsFromCustomElement(elem, bindingContext) {\n        var paramsAttribute = elem.getAttribute('params');\n\n        if (paramsAttribute) {\n            var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                    return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                }),\n                result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                    var paramValue = paramValueComputed.peek();\n                    // Does the evaluation of the parameter value unwrap any observables?\n                    if (!paramValueComputed.isActive()) {\n                        // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                        // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                        return paramValue;\n                    } else {\n                        // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                        // level of observability, and any inner (resulting model value) level of observability.\n                        // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                        // writable observable, the computed will also be writable and pass the value on to the observable.\n                        return ko.computed({\n                            'read': function() {\n                                return ko.utils.unwrapObservable(paramValueComputed());\n                            },\n                            'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                paramValueComputed()(value);\n                            },\n                            disposeWhenNodeIsRemoved: elem\n                        });\n                    }\n                });\n\n            // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n            // This is in case the developer wants to react to outer (binding) observability separately from inner\n            // (model value) observability, or in case the model value observable has subobservables.\n            if (!result.hasOwnProperty('$raw')) {\n                result['$raw'] = rawParamComputedValues;\n            }\n\n            return result;\n        } else {\n            // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n            // any empty one. Otherwise component viewmodels need special code to check whether or not\n            // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n            return { '$raw': {} };\n        }\n    }\n\n    // --------------------------------------------------------------------------------\n    // Compatibility code for older (pre-HTML5) IE browsers\n\n    if (ko.utils.ieVersion < 9) {\n        // Whenever you preregister a component, enable it as a custom element in the current document\n        ko.components['register'] = (function(originalFunction) {\n            return function(componentName) {\n                document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                return originalFunction.apply(this, arguments);\n            }\n        })(ko.components['register']);\n\n        // Whenever you create a document fragment, enable all preregistered component names as custom elements\n        // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n        document.createDocumentFragment = (function(originalFunction) {\n            return function() {\n                var newDocFrag = originalFunction(),\n                    allComponents = ko.components._allRegisteredComponents;\n                for (var componentName in allComponents) {\n                    if (allComponents.hasOwnProperty(componentName)) {\n                        newDocFrag.createElement(componentName);\n                    }\n                }\n                return newDocFrag;\n            };\n        })(document.createDocumentFragment);\n    }\n})();(function(undefined) {\n\n    var componentLoadingOperationUniqueId = 0;\n\n    ko.bindingHandlers['component'] = {\n        'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n            var currentViewModel,\n                currentLoadingOperationId,\n                disposeAssociatedComponentViewModel = function () {\n                    var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                    if (typeof currentViewModelDispose === 'function') {\n                        currentViewModelDispose.call(currentViewModel);\n                    }\n\n                    // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                    currentLoadingOperationId = null;\n                },\n                originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n            ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n            ko.computed(function () {\n                var value = ko.utils.unwrapObservable(valueAccessor()),\n                    componentName, componentParams;\n\n                if (typeof value === 'string') {\n                    componentName = value;\n                } else {\n                    componentName = ko.utils.unwrapObservable(value['name']);\n                    componentParams = ko.utils.unwrapObservable(value['params']);\n                }\n\n                if (!componentName) {\n                    throw new Error('No component name specified');\n                }\n\n                var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                ko.components.get(componentName, function(componentDefinition) {\n                    // If this is not the current load operation for this element, ignore it.\n                    if (currentLoadingOperationId !== loadingOperationId) {\n                        return;\n                    }\n\n                    // Clean up previous state\n                    disposeAssociatedComponentViewModel();\n\n                    // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                    if (!componentDefinition) {\n                        throw new Error('Unknown component \\'' + componentName + '\\'');\n                    }\n                    cloneTemplateIntoElement(componentName, componentDefinition, element);\n                    var componentViewModel = createViewModel(componentDefinition, element, originalChildNodes, componentParams),\n                        childBindingContext = bindingContext['createChildContext'](componentViewModel, /* dataItemAlias */ undefined, function(ctx) {\n                            ctx['$component'] = componentViewModel;\n                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                        });\n                    currentViewModel = componentViewModel;\n                    ko.applyBindingsToDescendants(childBindingContext, element);\n                });\n            }, null, { disposeWhenNodeIsRemoved: element });\n\n            return { 'controlsDescendantBindings': true };\n        }\n    };\n\n    ko.virtualElements.allowedBindings['component'] = true;\n\n    function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n        var template = componentDefinition['template'];\n        if (!template) {\n            throw new Error('Component \\'' + componentName + '\\' has no template');\n        }\n\n        var clonedNodesArray = ko.utils.cloneNodes(template);\n        ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n    }\n\n    function createViewModel(componentDefinition, element, originalChildNodes, componentParams) {\n        var componentViewModelFactory = componentDefinition['createViewModel'];\n        return componentViewModelFactory\n            ? componentViewModelFactory.call(componentDefinition, componentParams, { 'element': element, 'templateNodes': originalChildNodes })\n            : componentParams; // Template-only component\n    }\n\n})();\nvar attrHtmlToJavascriptMap = { 'class': 'className', 'for': 'htmlFor' };\nko.bindingHandlers['attr'] = {\n    'update': function(element, valueAccessor, allBindings) {\n        var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n        ko.utils.objectForEach(value, function(attrName, attrValue) {\n            attrValue = ko.utils.unwrapObservable(attrValue);\n\n            // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n            // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n            // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n            var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n            if (toRemove)\n                element.removeAttribute(attrName);\n\n            // In IE <= 7 and IE8 Quirks Mode, you have to use the Javascript property name instead of the\n            // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n            // but instead of figuring out the mode, we'll just set the attribute through the Javascript\n            // property for IE <= 8.\n            if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavascriptMap) {\n                attrName = attrHtmlToJavascriptMap[attrName];\n                if (toRemove)\n                    element.removeAttribute(attrName);\n                else\n                    element[attrName] = attrValue;\n            } else if (!toRemove) {\n                element.setAttribute(attrName, attrValue.toString());\n            }\n\n            // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n            // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n            // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n            // entirely, and there's no strong reason to allow for such casing in HTML.\n            if (attrName === \"name\") {\n                ko.utils.setElementName(element, toRemove ? \"\" : attrValue.toString());\n            }\n        });\n    }\n};\n(function() {\n\nko.bindingHandlers['checked'] = {\n    'after': ['value', 'attr'],\n    'init': function (element, valueAccessor, allBindings) {\n        var checkedValue = ko.pureComputed(function() {\n            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n            if (allBindings['has']('checkedValue')) {\n                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n            } else if (allBindings['has']('value')) {\n                return ko.utils.unwrapObservable(allBindings.get('value'));\n            }\n\n            return element.value;\n        });\n\n        function updateModel() {\n            // This updates the model value from the view value.\n            // It runs in response to DOM events (click) and changes in checkedValue.\n            var isChecked = element.checked,\n                elemValue = useCheckedValue ? checkedValue() : isChecked;\n\n            // When we're first setting up this computed, don't change any model state.\n            if (ko.computedContext.isInitial()) {\n                return;\n            }\n\n            // We can ignore unchecked radio buttons, because some other radio\n            // button will be getting checked, and that one can take care of updating state.\n            if (isRadio && !isChecked) {\n                return;\n            }\n\n            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n            if (isValueArray) {\n                if (oldElemValue !== elemValue) {\n                    // When we're responding to the checkedValue changing, and the element is\n                    // currently checked, replace the old elem value with the new elem value\n                    // in the model array.\n                    if (isChecked) {\n                        ko.utils.addOrRemoveItem(modelValue, elemValue, true);\n                        ko.utils.addOrRemoveItem(modelValue, oldElemValue, false);\n                    }\n\n                    oldElemValue = elemValue;\n                } else {\n                    // When we're responding to the user having checked/unchecked a checkbox,\n                    // add/remove the element value to the model array.\n                    ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);\n                }\n            } else {\n                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n            }\n        };\n\n        function updateView() {\n            // This updates the view value from the model value.\n            // It runs in response to changes in the bound (checked) value.\n            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n            if (isValueArray) {\n                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n            } else if (isCheckbox) {\n                // When a checkbox is bound to any other value (not an array), being checked represents the value being trueish\n                element.checked = modelValue;\n            } else {\n                // For radio buttons, being checked means that the radio button's value corresponds to the model value\n                element.checked = (checkedValue() === modelValue);\n            }\n        };\n\n        var isCheckbox = element.type == \"checkbox\",\n            isRadio = element.type == \"radio\";\n\n        // Only bind to check boxes and radio buttons\n        if (!isCheckbox && !isRadio) {\n            return;\n        }\n\n        var isValueArray = isCheckbox && (ko.utils.unwrapObservable(valueAccessor()) instanceof Array),\n            oldElemValue = isValueArray ? checkedValue() : undefined,\n            useCheckedValue = isRadio || isValueArray;\n\n        // IE 6 won't allow radio buttons to be selected unless they have a name\n        if (isRadio && !element.name)\n            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n        // Set up two computeds to update the binding:\n\n        // The first responds to changes in the checkedValue value and to element clicks\n        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n        // The second responds to changes in the model value (the one associated with the checked binding)\n        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n    }\n};\nko.expressionRewriting.twoWayBindings['checked'] = true;\n\nko.bindingHandlers['checkedValue'] = {\n    'update': function (element, valueAccessor) {\n        element.value = ko.utils.unwrapObservable(valueAccessor());\n    }\n};\n\n})();var classesWrittenByBindingKey = '__ko__cssValue';\nko.bindingHandlers['css'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        if (value !== null && typeof value == \"object\") {\n            ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n            });\n        } else {\n            value = String(value || ''); // Make sure we don't try to store or set a non-string value\n            ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n            element[classesWrittenByBindingKey] = value;\n            ko.utils.toggleDomNodeCssClass(element, value, true);\n        }\n    }\n};\nko.bindingHandlers['enable'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        if (value && element.disabled)\n            element.removeAttribute(\"disabled\");\n        else if ((!value) && (!element.disabled))\n            element.disabled = true;\n    }\n};\n\nko.bindingHandlers['disable'] = {\n    'update': function (element, valueAccessor) {\n        ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n    }\n};\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\nfunction makeEventHandlerShortcut(eventName) {\n    ko.bindingHandlers[eventName] = {\n        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var newValueAccessor = function () {\n                var result = {};\n                result[eventName] = valueAccessor();\n                return result;\n            };\n            return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n        }\n    }\n}\n\nko.bindingHandlers['event'] = {\n    'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n        var eventsToHandle = valueAccessor() || {};\n        ko.utils.objectForEach(eventsToHandle, function(eventName) {\n            if (typeof eventName == \"string\") {\n                ko.utils.registerEventHandler(element, eventName, function (event) {\n                    var handlerReturnValue;\n                    var handlerFunction = valueAccessor()[eventName];\n                    if (!handlerFunction)\n                        return;\n\n                    try {\n                        // Take all the event args, and prefix with the viewmodel\n                        var argsForHandler = ko.utils.makeArray(arguments);\n                        viewModel = bindingContext['$data'];\n                        argsForHandler.unshift(viewModel);\n                        handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                    } finally {\n                        if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                            if (event.preventDefault)\n                                event.preventDefault();\n                            else\n                                event.returnValue = false;\n                        }\n                    }\n\n                    var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                    if (!bubble) {\n                        event.cancelBubble = true;\n                        if (event.stopPropagation)\n                            event.stopPropagation();\n                    }\n                });\n            }\n        });\n    }\n};\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\nko.bindingHandlers['foreach'] = {\n    makeTemplateValueAccessor: function(valueAccessor) {\n        return function() {\n            var modelValue = valueAccessor(),\n                unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n            // If unwrappedValue is the array, pass in the wrapped value on its own\n            // The value will be unwrapped and tracked within the template binding\n            // (See https://github.com/SteveSanderson/knockout/issues/523)\n            if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n            // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n            ko.utils.unwrapObservable(modelValue);\n            return {\n                'foreach': unwrappedValue['data'],\n                'as': unwrappedValue['as'],\n                'includeDestroyed': unwrappedValue['includeDestroyed'],\n                'afterAdd': unwrappedValue['afterAdd'],\n                'beforeRemove': unwrappedValue['beforeRemove'],\n                'afterRender': unwrappedValue['afterRender'],\n                'beforeMove': unwrappedValue['beforeMove'],\n                'afterMove': unwrappedValue['afterMove'],\n                'templateEngine': ko.nativeTemplateEngine.instance\n            };\n        };\n    },\n    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n        return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n    },\n    'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n        return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n    }\n};\nko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\nko.virtualElements.allowedBindings['foreach'] = true;\nvar hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\nvar hasfocusLastValue = '__ko_hasfocusLastValue';\nko.bindingHandlers['hasfocus'] = {\n    'init': function(element, valueAccessor, allBindings) {\n        var handleElementFocusChange = function(isFocused) {\n            // Where possible, ignore which event was raised and determine focus state using activeElement,\n            // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n            // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n            // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n            // from calling 'blur()' on the element when it loses focus.\n            // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n            element[hasfocusUpdatingProperty] = true;\n            var ownerDoc = element.ownerDocument;\n            if (\"activeElement\" in ownerDoc) {\n                var active;\n                try {\n                    active = ownerDoc.activeElement;\n                } catch(e) {\n                    // IE9 throws if you access activeElement during page load (see issue #703)\n                    active = ownerDoc.body;\n                }\n                isFocused = (active === element);\n            }\n            var modelValue = valueAccessor();\n            ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n            //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n            element[hasfocusLastValue] = isFocused;\n            element[hasfocusUpdatingProperty] = false;\n        };\n        var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n        var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n        ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n        ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n        ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n        ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n    },\n    'update': function(element, valueAccessor) {\n        var value = !!ko.utils.unwrapObservable(valueAccessor()); //force boolean to compare with last value\n        if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n            value ? element.focus() : element.blur();\n            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]); // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n        }\n    }\n};\nko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\nko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\nko.expressionRewriting.twoWayBindings['hasFocus'] = true;\nko.bindingHandlers['html'] = {\n    'init': function() {\n        // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor) {\n        // setHtml will unwrap the value if needed\n        ko.utils.setHtml(element, valueAccessor());\n    }\n};\n// Makes a binding like with or if\nfunction makeWithIfBinding(bindingKey, isWith, isNot, makeContextCallback) {\n    ko.bindingHandlers[bindingKey] = {\n        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var didDisplayOnLastUpdate,\n                savedNodes;\n            ko.computed(function() {\n                var dataValue = ko.utils.unwrapObservable(valueAccessor()),\n                    shouldDisplay = !isNot !== !dataValue, // equivalent to isNot ? !dataValue : !!dataValue\n                    isFirstRender = !savedNodes,\n                    needsRefresh = isFirstRender || isWith || (shouldDisplay !== didDisplayOnLastUpdate);\n\n                if (needsRefresh) {\n                    // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                    if (isFirstRender && ko.computedContext.getDependenciesCount()) {\n                        savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                    }\n\n                    if (shouldDisplay) {\n                        if (!isFirstRender) {\n                            ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                        }\n                        ko.applyBindingsToDescendants(makeContextCallback ? makeContextCallback(bindingContext, dataValue) : bindingContext, element);\n                    } else {\n                        ko.virtualElements.emptyNode(element);\n                    }\n\n                    didDisplayOnLastUpdate = shouldDisplay;\n                }\n            }, null, { disposeWhenNodeIsRemoved: element });\n            return { 'controlsDescendantBindings': true };\n        }\n    };\n    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n    ko.virtualElements.allowedBindings[bindingKey] = true;\n}\n\n// Construct the actual binding handlers\nmakeWithIfBinding('if');\nmakeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\nmakeWithIfBinding('with', true /* isWith */, false /* isNot */,\n    function(bindingContext, dataValue) {\n        return bindingContext['createChildContext'](dataValue);\n    }\n);\nvar captionPlaceholder = {};\nko.bindingHandlers['options'] = {\n    'init': function(element) {\n        if (ko.utils.tagNameLower(element) !== \"select\")\n            throw new Error(\"options binding applies only to SELECT elements\");\n\n        // Remove all existing <option>s.\n        while (element.length > 0) {\n            element.remove(0);\n        }\n\n        // Ensures that the binding processor doesn't try to bind the options\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor, allBindings) {\n        function selectedOptions() {\n            return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n        }\n\n        var selectWasPreviouslyEmpty = element.length == 0,\n            multiple = element.multiple,\n            previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n            unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n            valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n            includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n            arrayToDomNodeChildrenOptions = {},\n            captionValue,\n            filteredArray,\n            previousSelectedValues = [];\n\n        if (!valueAllowUnset) {\n            if (multiple) {\n                previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n            } else if (element.selectedIndex >= 0) {\n                previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n            }\n        }\n\n        if (unwrappedArray) {\n            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                unwrappedArray = [unwrappedArray];\n\n            // Filter out any entries marked as destroyed\n            filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n            });\n\n            // If caption is included, add it to the array\n            if (allBindings['has']('optionsCaption')) {\n                captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                // If caption value is null or undefined, don't show a caption\n                if (captionValue !== null && captionValue !== undefined) {\n                    filteredArray.unshift(captionPlaceholder);\n                }\n            }\n        } else {\n            // If a falsy value is provided (e.g. null), we'll simply empty the select element\n        }\n\n        function applyToObject(object, predicate, defaultValue) {\n            var predicateType = typeof predicate;\n            if (predicateType == \"function\")    // Given a function; run it against the data value\n                return predicate(object);\n            else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                return object[predicate];\n            else                                // Given no optionsText arg; use the data value itself\n                return defaultValue;\n        }\n\n        // The following functions can run at two different times:\n        // The first is when the whole array is being updated directly from this binding handler.\n        // The second is when an observable value for a specific array entry is updated.\n        // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n        var itemUpdate = false;\n        function optionForArrayItem(arrayEntry, index, oldOptions) {\n            if (oldOptions.length) {\n                previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                itemUpdate = true;\n            }\n            var option = element.ownerDocument.createElement(\"option\");\n            if (arrayEntry === captionPlaceholder) {\n                ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                ko.selectExtensions.writeValue(option, undefined);\n            } else {\n                // Apply a value to the option element\n                var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                // Apply some text to the option element\n                var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                ko.utils.setTextContent(option, optionText);\n            }\n            return [option];\n        }\n\n        // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n        // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n        arrayToDomNodeChildrenOptions['beforeRemove'] =\n            function (option) {\n                element.removeChild(option);\n            };\n\n        function setSelectionCallback(arrayEntry, newOptions) {\n            if (itemUpdate && valueAllowUnset) {\n                // The model value is authoritative, so make sure its value is the one selected\n                // There is no need to use dependencyDetection.ignore since setDomNodeChildrenFromArrayMapping does so already.\n                ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n            } else if (previousSelectedValues.length) {\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                // If this option was changed from being selected during a single-item update, notify the change\n                if (itemUpdate && !isSelected) {\n                    ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                }\n            }\n        }\n\n        var callback = setSelectionCallback;\n        if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n            callback = function(arrayEntry, newOptions) {\n                setSelectionCallback(arrayEntry, newOptions);\n                ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n            }\n        }\n\n        ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n        ko.dependencyDetection.ignore(function () {\n            if (valueAllowUnset) {\n                // The model value is authoritative, so make sure its value is the one selected\n                ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n            } else {\n                // Determine if the selection has changed as a result of updating the options list\n                var selectionChanged;\n                if (multiple) {\n                    // For a multiple-select box, compare the new selection count to the previous one\n                    // But if nothing was selected before, the selection can't have changed\n                    selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                } else {\n                    // For a single-select box, compare the current value to the previous value\n                    // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                    selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                        ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                        : (previousSelectedValues.length || element.selectedIndex >= 0);\n                }\n\n                // Ensure consistency between model value and selected option.\n                // If the dropdown was changed so that selection is no longer the same,\n                // notify the value or selectedOptions binding.\n                if (selectionChanged) {\n                    ko.utils.triggerEvent(element, \"change\");\n                }\n            }\n        });\n\n        // Workaround for IE bug\n        ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n        if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n            element.scrollTop = previousScrollTop;\n    }\n};\nko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\nko.bindingHandlers['selectedOptions'] = {\n    'after': ['options', 'foreach'],\n    'init': function (element, valueAccessor, allBindings) {\n        ko.utils.registerEventHandler(element, \"change\", function () {\n            var value = valueAccessor(), valueToWrite = [];\n            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                if (node.selected)\n                    valueToWrite.push(ko.selectExtensions.readValue(node));\n            });\n            ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n        });\n    },\n    'update': function (element, valueAccessor) {\n        if (ko.utils.tagNameLower(element) != \"select\")\n            throw new Error(\"values binding applies only to SELECT elements\");\n\n        var newValue = ko.utils.unwrapObservable(valueAccessor());\n        if (newValue && typeof newValue.length == \"number\") {\n            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                ko.utils.setOptionNodeSelectionState(node, isSelected);\n            });\n        }\n    }\n};\nko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\nko.bindingHandlers['style'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor() || {});\n        ko.utils.objectForEach(value, function(styleName, styleValue) {\n            styleValue = ko.utils.unwrapObservable(styleValue);\n\n            if (styleValue === null || styleValue === undefined || styleValue === false) {\n                // Empty string removes the value, whereas null/undefined have no effect\n                styleValue = \"\";\n            }\n\n            element.style[styleName] = styleValue;\n        });\n    }\n};\nko.bindingHandlers['submit'] = {\n    'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n        if (typeof valueAccessor() != \"function\")\n            throw new Error(\"The value for a submit binding must be a function\");\n        ko.utils.registerEventHandler(element, \"submit\", function (event) {\n            var handlerReturnValue;\n            var value = valueAccessor();\n            try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n            finally {\n                if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                    if (event.preventDefault)\n                        event.preventDefault();\n                    else\n                        event.returnValue = false;\n                }\n            }\n        });\n    }\n};\nko.bindingHandlers['text'] = {\n    'init': function() {\n        // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n        // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor) {\n        ko.utils.setTextContent(element, valueAccessor());\n    }\n};\nko.virtualElements.allowedBindings['text'] = true;\n(function () {\n\nif (window && window.navigator) {\n    var parseVersion = function (matches) {\n        if (matches) {\n            return parseFloat(matches[1]);\n        }\n    };\n\n    // Detect various browser versions because some old versions don't fully support the 'input' event\n    var operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()),\n        userAgent = window.navigator.userAgent,\n        safariVersion = parseVersion(userAgent.match(/^(?:(?!chrome).)*version\\/([^ ]*) safari/i)),\n        firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]*)/));\n}\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\nif (ko.utils.ieVersion < 10) {\n    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n        selectionChangeHandlerName = ko.utils.domData.nextKey();\n    var selectionChangeHandler = function(event) {\n        var target = this.activeElement,\n            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n        if (handler) {\n            handler(event);\n        }\n    };\n    var registerForSelectionChangeEvent = function (element, handler) {\n        var ownerDoc = element.ownerDocument;\n        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n        }\n        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n    };\n}\n\nko.bindingHandlers['textInput'] = {\n    'init': function (element, valueAccessor, allBindings) {\n\n        var previousElementValue = element.value,\n            timeoutHandle,\n            elementValueBeforeEvent;\n\n        var updateModel = function (event) {\n            clearTimeout(timeoutHandle);\n            elementValueBeforeEvent = timeoutHandle = undefined;\n\n            var elementValue = element.value;\n            if (previousElementValue !== elementValue) {\n                // Provide a way for tests to know exactly which event was processed\n                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                previousElementValue = elementValue;\n                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n            }\n        };\n\n        var deferUpdateModel = function (event) {\n            if (!timeoutHandle) {\n                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                // event firing and the updateModel function running. This allows us to ignore model\n                // updates that are from the previous state of the element, usually due to techniques\n                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                elementValueBeforeEvent = element.value;\n                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                timeoutHandle = setTimeout(handler, 4);\n            }\n        };\n\n        var updateView = function () {\n            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n            if (modelValue === null || modelValue === undefined) {\n                modelValue = '';\n            }\n\n            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                setTimeout(updateView, 4);\n                return;\n            }\n\n            // Update the element only if the element and model are different. On some browsers, updating the value\n            // will move the cursor to the end of the input, which would be bad while the user is typing.\n            if (element.value !== modelValue) {\n                previousElementValue = modelValue;  // Make sure we ignore events (propertychange) that result from updating the value\n                element.value = modelValue;\n            }\n        };\n\n        var onEvent = function (event, handler) {\n            ko.utils.registerEventHandler(element, event, handler);\n        };\n\n        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n            // Provide a way for tests to specify exactly which events are bound\n            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                if (eventName.slice(0,5) == 'after') {\n                    onEvent(eventName.slice(5), deferUpdateModel);\n                } else {\n                    onEvent(eventName, updateModel);\n                }\n            });\n        } else {\n            if (ko.utils.ieVersion < 10) {\n                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                // but that's an acceptable compromise for this binding. IE 9 does support 'input', but since it doesn't fire it\n                // when using autocomplete, we'll use 'propertychange' for it also.\n                onEvent('propertychange', function(event) {\n                    if (event.propertyName === 'value') {\n                        updateModel(event);\n                    }\n                });\n\n                if (ko.utils.ieVersion == 8) {\n                    // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                    // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                    // events too.\n                    onEvent('keyup', updateModel);      // A single keystoke\n                    onEvent('keydown', updateModel);    // The first character when a key is held down\n                }\n                if (ko.utils.ieVersion >= 8) {\n                    // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                    // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                    // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                    // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                    // These are also needed in IE8 because of the bug described above.\n                    registerForSelectionChangeEvent(element, updateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                    onEvent('dragend', deferUpdateModel);\n                }\n            } else {\n                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                // through the user interface.\n                onEvent('input', updateModel);\n\n                if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                    // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                    // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                    onEvent('keydown', deferUpdateModel);\n                    onEvent('paste', deferUpdateModel);\n                    onEvent('cut', deferUpdateModel);\n                } else if (operaVersion < 11) {\n                    // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                    // We can try to catch some of those using 'keydown'.\n                    onEvent('keydown', deferUpdateModel);\n                } else if (firefoxVersion < 4.0) {\n                    // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                    onEvent('DOMAutoComplete', updateModel);\n\n                    // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                    onEvent('dragdrop', updateModel);       // <3.5\n                    onEvent('drop', updateModel);           // 3.5\n                }\n            }\n        }\n\n        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n        onEvent('change', updateModel);\n\n        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n    }\n};\nko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\nko.bindingHandlers['textinput'] = {\n    // preprocess is the only way to set up a full alias\n    'preprocess': function (value, name, addBinding) {\n        addBinding('textInput', value);\n    }\n};\n\n})();ko.bindingHandlers['uniqueName'] = {\n    'init': function (element, valueAccessor) {\n        if (valueAccessor()) {\n            var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n            ko.utils.setElementName(element, name);\n        }\n    }\n};\nko.bindingHandlers['uniqueName'].currentIndex = 0;\nko.bindingHandlers['value'] = {\n    'after': ['options', 'foreach'],\n    'init': function (element, valueAccessor, allBindings) {\n        // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n        if (element.tagName.toLowerCase() == \"input\" && (element.type == \"checkbox\" || element.type == \"radio\")) {\n            ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n            return;\n        }\n\n        // Always catch \"change\" event; possibly other events too if asked\n        var eventsToCatch = [\"change\"];\n        var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n        var propertyChangedFired = false;\n        var elementValueBeforeEvent = null;\n\n        if (requestedEventsToCatch) {\n            if (typeof requestedEventsToCatch == \"string\") // Allow both individual event names, and arrays of event names\n                requestedEventsToCatch = [requestedEventsToCatch];\n            ko.utils.arrayPushAll(eventsToCatch, requestedEventsToCatch);\n            eventsToCatch = ko.utils.arrayGetDistinctValues(eventsToCatch);\n        }\n\n        var valueUpdateHandler = function() {\n            elementValueBeforeEvent = null;\n            propertyChangedFired = false;\n            var modelValue = valueAccessor();\n            var elementValue = ko.selectExtensions.readValue(element);\n            ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n        }\n\n        // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n        // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n        var ieAutoCompleteHackNeeded = ko.utils.ieVersion && element.tagName.toLowerCase() == \"input\" && element.type == \"text\"\n                                       && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n        if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n            ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n            ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n            ko.utils.registerEventHandler(element, \"blur\", function() {\n                if (propertyChangedFired) {\n                    valueUpdateHandler();\n                }\n            });\n        }\n\n        ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n            // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n            // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n            // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n            var handler = valueUpdateHandler;\n            if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                handler = function() {\n                    // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                    // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                    // at the earliest asynchronous opportunity. We store this temporary information so that\n                    // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                    // we can overwrite that model value change with the value the user just typed. Otherwise,\n                    // techniques like rateLimit can trigger model changes at critical moments that will\n                    // override the user's inputs, causing keystrokes to be lost.\n                    elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                    setTimeout(valueUpdateHandler, 0);\n                };\n                eventName = eventName.substring(\"after\".length);\n            }\n            ko.utils.registerEventHandler(element, eventName, handler);\n        });\n\n        var updateFromModel = function () {\n            var newValue = ko.utils.unwrapObservable(valueAccessor());\n            var elementValue = ko.selectExtensions.readValue(element);\n\n            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                setTimeout(updateFromModel, 0);\n                return;\n            }\n\n            var valueHasChanged = (newValue !== elementValue);\n\n            if (valueHasChanged) {\n                if (ko.utils.tagNameLower(element) === \"select\") {\n                    var allowUnset = allBindings.get('valueAllowUnset');\n                    var applyValueAction = function () {\n                        ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                    };\n                    applyValueAction();\n\n                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                    } else {\n                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                        // to apply the value as well.\n                        setTimeout(applyValueAction, 0);\n                    }\n                } else {\n                    ko.selectExtensions.writeValue(element, newValue);\n                }\n            }\n        };\n\n        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n    },\n    'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n};\nko.expressionRewriting.twoWayBindings['value'] = true;\nko.bindingHandlers['visible'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        var isCurrentlyVisible = !(element.style.display == \"none\");\n        if (value && !isCurrentlyVisible)\n            element.style.display = \"\";\n        else if ((!value) && isCurrentlyVisible)\n            element.style.display = \"none\";\n    }\n};\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\nmakeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\nko.templateEngine = function () { };\n\nko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n    throw new Error(\"Override renderTemplateSource\");\n};\n\nko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n    throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n};\n\nko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n    // Named template\n    if (typeof template == \"string\") {\n        templateDocument = templateDocument || document;\n        var elem = templateDocument.getElementById(template);\n        if (!elem)\n            throw new Error(\"Cannot find template with ID \" + template);\n        return new ko.templateSources.domElement(elem);\n    } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n        // Anonymous template\n        return new ko.templateSources.anonymousTemplate(template);\n    } else\n        throw new Error(\"Unknown template type: \" + template);\n};\n\nko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n    var templateSource = this['makeTemplateSource'](template, templateDocument);\n    return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n};\n\nko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n    // Skip rewriting if requested\n    if (this['allowTemplateRewriting'] === false)\n        return true;\n    return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n};\n\nko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n    var templateSource = this['makeTemplateSource'](template, templateDocument);\n    var rewritten = rewriterCallback(templateSource['text']());\n    templateSource['text'](rewritten);\n    templateSource['data'](\"isRewritten\", true);\n};\n\nko.exportSymbol('templateEngine', ko.templateEngine);\n\nko.templateRewriting = (function () {\n    var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n    var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n    function validateDataBindValuesForRewriting(keyValueArray) {\n        var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n        for (var i = 0; i < keyValueArray.length; i++) {\n            var key = keyValueArray[i]['key'];\n            if (allValidators.hasOwnProperty(key)) {\n                var validator = allValidators[key];\n\n                if (typeof validator === \"function\") {\n                    var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                    if (possibleErrorMessage)\n                        throw new Error(possibleErrorMessage);\n                } else if (!validator) {\n                    throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                }\n            }\n        }\n    }\n\n    function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n        var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n        validateDataBindValuesForRewriting(dataBindKeyValueArray);\n        var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n        // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n        // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n        // extra indirection.\n        var applyBindingsToNextSiblingScript =\n            \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n        return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n    }\n\n    return {\n        ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n            if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                templateEngine['rewriteTemplate'](template, function (htmlString) {\n                    return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                }, templateDocument);\n        },\n\n        memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n            return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n            }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n            });\n        },\n\n        applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n            return ko.memoization.memoize(function (domNode, bindingContext) {\n                var nodeToBind = domNode.nextSibling;\n                if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                    ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                }\n            });\n        }\n    }\n})();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\nko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n(function() {\n    // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n    // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n    //\n    // Two are provided by default:\n    //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n    //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n    //                                           without reading/writing the actual element text content, since it will be overwritten\n    //                                           with the rendered template output.\n    // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n    // Template sources need to have the following functions:\n    //   text()             - returns the template text from your storage location\n    //   text(value)        - writes the supplied template text to your storage location\n    //   data(key)          - reads values stored using data(key, value) - see below\n    //   data(key, value)   - associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n    //\n    // Optionally, template sources can also have the following functions:\n    //   nodes()            - returns a DOM element containing the nodes of this template, where available\n    //   nodes(value)       - writes the given DOM element to your storage location\n    // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n    // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n    //\n    // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n    // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n    ko.templateSources = {};\n\n    // ---- ko.templateSources.domElement -----\n\n    ko.templateSources.domElement = function(element) {\n        this.domElement = element;\n    }\n\n    ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n        var tagNameLower = ko.utils.tagNameLower(this.domElement),\n            elemContentsProperty = tagNameLower === \"script\" ? \"text\"\n                                 : tagNameLower === \"textarea\" ? \"value\"\n                                 : \"innerHTML\";\n\n        if (arguments.length == 0) {\n            return this.domElement[elemContentsProperty];\n        } else {\n            var valueToWrite = arguments[0];\n            if (elemContentsProperty === \"innerHTML\")\n                ko.utils.setHtml(this.domElement, valueToWrite);\n            else\n                this.domElement[elemContentsProperty] = valueToWrite;\n        }\n    };\n\n    var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n    ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n        if (arguments.length === 1) {\n            return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n        } else {\n            ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n        }\n    };\n\n    // ---- ko.templateSources.anonymousTemplate -----\n    // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n    // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n    // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n    var anonymousTemplatesDomDataKey = ko.utils.domData.nextKey();\n    ko.templateSources.anonymousTemplate = function(element) {\n        this.domElement = element;\n    }\n    ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n    ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n    ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n        if (arguments.length == 0) {\n            var templateData = ko.utils.domData.get(this.domElement, anonymousTemplatesDomDataKey) || {};\n            if (templateData.textData === undefined && templateData.containerData)\n                templateData.textData = templateData.containerData.innerHTML;\n            return templateData.textData;\n        } else {\n            var valueToWrite = arguments[0];\n            ko.utils.domData.set(this.domElement, anonymousTemplatesDomDataKey, {textData: valueToWrite});\n        }\n    };\n    ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n        if (arguments.length == 0) {\n            var templateData = ko.utils.domData.get(this.domElement, anonymousTemplatesDomDataKey) || {};\n            return templateData.containerData;\n        } else {\n            var valueToWrite = arguments[0];\n            ko.utils.domData.set(this.domElement, anonymousTemplatesDomDataKey, {containerData: valueToWrite});\n        }\n    };\n\n    ko.exportSymbol('templateSources', ko.templateSources);\n    ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n    ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n})();\n(function () {\n    var _templateEngine;\n    ko.setTemplateEngine = function (templateEngine) {\n        if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n            throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n        _templateEngine = templateEngine;\n    }\n\n    function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n        var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n        while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n            nextInQueue = ko.virtualElements.nextSibling(node);\n            action(node, nextInQueue);\n        }\n    }\n\n    function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n        // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n        // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n        // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n        // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n        // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n        if (continuousNodeArray.length) {\n            var firstNode = continuousNodeArray[0],\n                lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                parentNode = firstNode.parentNode,\n                provider = ko.bindingProvider['instance'],\n                preprocessNode = provider['preprocessNode'];\n\n            if (preprocessNode) {\n                invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                    var nodePreviousSibling = node.previousSibling;\n                    var newNodes = preprocessNode.call(provider, node);\n                    if (newNodes) {\n                        if (node === firstNode)\n                            firstNode = newNodes[0] || nextNodeInRange;\n                        if (node === lastNode)\n                            lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                    }\n                });\n\n                // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                // first node needs to be in the array).\n                continuousNodeArray.length = 0;\n                if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                    return;\n                }\n                if (firstNode === lastNode) {\n                    continuousNodeArray.push(firstNode);\n                } else {\n                    continuousNodeArray.push(firstNode, lastNode);\n                    ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                }\n            }\n\n            // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n            // whereas a regular applyBindings won't introduce new memoized nodes\n            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                if (node.nodeType === 1 || node.nodeType === 8)\n                    ko.applyBindings(bindingContext, node);\n            });\n            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                if (node.nodeType === 1 || node.nodeType === 8)\n                    ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n            });\n\n            // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n            ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n        }\n    }\n\n    function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n        return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                                        : null;\n    }\n\n    function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n        options = options || {};\n        var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n        var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n        var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n        ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n        var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n        // Loosely check result is an array of DOM nodes\n        if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n            throw new Error(\"Template engine must return an array of DOM nodes\");\n\n        var haveAddedNodesToParent = false;\n        switch (renderMode) {\n            case \"replaceChildren\":\n                ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                haveAddedNodesToParent = true;\n                break;\n            case \"replaceNode\":\n                ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                haveAddedNodesToParent = true;\n                break;\n            case \"ignoreTargetNode\": break;\n            default:\n                throw new Error(\"Unknown renderMode: \" + renderMode);\n        }\n\n        if (haveAddedNodesToParent) {\n            activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n            if (options['afterRender'])\n                ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext['$data']]);\n        }\n\n        return renderedNodesArray;\n    }\n\n    function resolveTemplateName(template, data, context) {\n        // The template can be specified as:\n        if (ko.isObservable(template)) {\n            // 1. An observable, with string value\n            return template();\n        } else if (typeof template === 'function') {\n            // 2. A function of (data, context) returning a string\n            return template(data, context);\n        } else {\n            // 3. A string\n            return template;\n        }\n    }\n\n    ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n        options = options || {};\n        if ((options['templateEngine'] || _templateEngine) == undefined)\n            throw new Error(\"Set a template engine before calling renderTemplate\");\n        renderMode = renderMode || \"replaceChildren\";\n\n        if (targetNodeOrNodeArray) {\n            var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n            var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n            var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n            return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                function () {\n                    // Ensure we've got a proper binding context to work with\n                    var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                        ? dataOrBindingContext\n                        : new ko.bindingContext(ko.utils.unwrapObservable(dataOrBindingContext));\n\n                    var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                        renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                    if (renderMode == \"replaceNode\") {\n                        targetNodeOrNodeArray = renderedNodesArray;\n                        firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    }\n                },\n                null,\n                { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n            );\n        } else {\n            // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n            return ko.memoization.memoize(function (domNode) {\n                ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n            });\n        }\n    };\n\n    ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n        // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n        // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n        var arrayItemContext;\n\n        // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n        var executeTemplateForArrayItem = function (arrayValue, index) {\n            // Support selecting template as a function of the data being rendered\n            arrayItemContext = parentBindingContext['createChildContext'](arrayValue, options['as'], function(context) {\n                context['$index'] = index;\n            });\n\n            var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n            return executeTemplate(null, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n        }\n\n        // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n        var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n            activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n            if (options['afterRender'])\n                options['afterRender'](addedNodesArray, arrayValue);\n\n            // release the \"cache\" variable, so that it can be collected by\n            // the GC when its value isn't used from within the bindings anymore.\n            arrayItemContext = null;\n        };\n\n        return ko.dependentObservable(function () {\n            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                unwrappedArray = [unwrappedArray];\n\n            // Filter out any entries marked as destroyed\n            var filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                return options['includeDestroyed'] || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n            });\n\n            // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n            // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n            ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, filteredArray, executeTemplateForArrayItem, options, activateBindingsCallback]);\n\n        }, null, { disposeWhenNodeIsRemoved: targetNode });\n    };\n\n    var templateComputedDomDataKey = ko.utils.domData.nextKey();\n    function disposeOldComputedAndStoreNewOne(element, newComputed) {\n        var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n        if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n            oldComputed.dispose();\n        ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && newComputed.isActive()) ? newComputed : undefined);\n    }\n\n    ko.bindingHandlers['template'] = {\n        'init': function(element, valueAccessor) {\n            // Support anonymous templates\n            var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n            if (typeof bindingValue == \"string\" || bindingValue['name']) {\n                // It's a named template - clear the element\n                ko.virtualElements.emptyNode(element);\n            } else if ('nodes' in bindingValue) {\n                // We've been given an array of DOM nodes. Save them as the template source.\n                // There is no known use case for the node array being an observable array (if the output\n                // varies, put that behavior *into* your template - that's what templates are for), and\n                // the implementation would be a mess, so assert that it's not observable.\n                var nodes = bindingValue['nodes'] || [];\n                if (ko.isObservable(nodes)) {\n                    throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                }\n                var container = ko.utils.moveCleanedNodesToContainerElement(nodes); // This also removes the nodes from their current parent\n                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n            } else {\n                // It's an anonymous template - store the element contents, then clear the element\n                var templateNodes = ko.virtualElements.childNodes(element),\n                    container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n            }\n            return { 'controlsDescendantBindings': true };\n        },\n        'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var value = valueAccessor(),\n                dataValue,\n                options = ko.utils.unwrapObservable(value),\n                shouldDisplay = true,\n                templateComputed = null,\n                templateName;\n\n            if (typeof options == \"string\") {\n                templateName = value;\n                options = {};\n            } else {\n                templateName = options['name'];\n\n                // Support \"if\"/\"ifnot\" conditions\n                if ('if' in options)\n                    shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                if (shouldDisplay && 'ifnot' in options)\n                    shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                dataValue = ko.utils.unwrapObservable(options['data']);\n            }\n\n            if ('foreach' in options) {\n                // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                var dataArray = (shouldDisplay && options['foreach']) || [];\n                templateComputed = ko.renderTemplateForEach(templateName || element, dataArray, options, element, bindingContext);\n            } else if (!shouldDisplay) {\n                ko.virtualElements.emptyNode(element);\n            } else {\n                // Render once for this single data point (or use the viewModel if no data was provided)\n                var innerBindingContext = ('data' in options) ?\n                    bindingContext['createChildContext'](dataValue, options['as']) :  // Given an explitit 'data' value, we create a child binding context for it\n                    bindingContext;                                                        // Given no explicit 'data' value, we retain the same binding context\n                templateComputed = ko.renderTemplate(templateName || element, innerBindingContext, options, element);\n            }\n\n            // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n            disposeOldComputedAndStoreNewOne(element, templateComputed);\n        }\n    };\n\n    // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n    ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n        var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n        if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n            return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n        if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n            return null; // Named templates can be rewritten, so return \"no error\"\n        return \"This template engine does not support anonymous templates nested within its templates\";\n    };\n\n    ko.virtualElements.allowedBindings['template'] = true;\n})();\n\nko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\nko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\nko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n    if (left.length && right.length) {\n        var failedCompares, l, r, leftItem, rightItem;\n        for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n            for (r = 0; rightItem = right[r]; ++r) {\n                if (leftItem['value'] === rightItem['value']) {\n                    leftItem['moved'] = rightItem['index'];\n                    rightItem['moved'] = leftItem['index'];\n                    right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                    failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                    break;\n                }\n            }\n            failedCompares += r;\n        }\n    }\n};\n\nko.utils.compareArrays = (function () {\n    var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n    // Simple calculation based on Levenshtein distance.\n    function compareArrays(oldArray, newArray, options) {\n        // For backward compatibility, if the third arg is actually a bool, interpret\n        // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n        options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n        oldArray = oldArray || [];\n        newArray = newArray || [];\n\n        if (oldArray.length <= newArray.length)\n            return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n        else\n            return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n    }\n\n    function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n        var myMin = Math.min,\n            myMax = Math.max,\n            editDistanceMatrix = [],\n            smlIndex, smlIndexMax = smlArray.length,\n            bigIndex, bigIndexMax = bigArray.length,\n            compareRange = (bigIndexMax - smlIndexMax) || 1,\n            maxDistance = smlIndexMax + bigIndexMax + 1,\n            thisRow, lastRow,\n            bigIndexMaxForRow, bigIndexMinForRow;\n\n        for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n            lastRow = thisRow;\n            editDistanceMatrix.push(thisRow = []);\n            bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n            bigIndexMinForRow = myMax(0, smlIndex - 1);\n            for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                if (!bigIndex)\n                    thisRow[bigIndex] = smlIndex + 1;\n                else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                    thisRow[bigIndex] = bigIndex + 1;\n                else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                    thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                else {\n                    var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                    var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                    thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                }\n            }\n        }\n\n        var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n        for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n            meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n            if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                notInSml.push(editScript[editScript.length] = {     // added\n                    'status': statusNotInSml,\n                    'value': bigArray[--bigIndex],\n                    'index': bigIndex });\n            } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                notInBig.push(editScript[editScript.length] = {     // deleted\n                    'status': statusNotInBig,\n                    'value': smlArray[--smlIndex],\n                    'index': smlIndex });\n            } else {\n                --bigIndex;\n                --smlIndex;\n                if (!options['sparse']) {\n                    editScript.push({\n                        'status': \"retained\",\n                        'value': bigArray[bigIndex] });\n                }\n            }\n        }\n\n        // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n        // smlIndexMax keeps the time complexity of this algorithm linear.\n        ko.utils.findMovesInArrayComparison(notInSml, notInBig, smlIndexMax * 10);\n\n        return editScript.reverse();\n    }\n\n    return compareArrays;\n})();\n\nko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n(function () {\n    // Objective:\n    // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n    //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n    // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n    //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n    //   previously mapped - retain those nodes, and just insert/delete other ones\n\n    // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n    // You can use this, for example, to activate bindings on those nodes.\n\n    function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n        // Map this array value inside a dependentObservable so we re-map when any dependency changes\n        var mappedNodes = [];\n        var dependentObservable = ko.dependentObservable(function() {\n            var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n            // On subsequent evaluations, just replace the previously-inserted DOM nodes\n            if (mappedNodes.length > 0) {\n                ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                if (callbackAfterAddingNodes)\n                    ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n            }\n\n            // Replace the contents of the mappedNodes array, thereby updating the record\n            // of which nodes would be deleted if valueToMap was itself later removed\n            mappedNodes.length = 0;\n            ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n        }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n        return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n    }\n\n    var lastMappingResultDomDataKey = ko.utils.domData.nextKey();\n\n    ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes) {\n        // Compare the provided array against the previous one\n        array = array || [];\n        options = options || {};\n        var isFirstExecution = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) === undefined;\n        var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) || [];\n        var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; });\n        var editScript = ko.utils.compareArrays(lastArray, array, options['dontLimitMoves']);\n\n        // Build the new mapping result\n        var newMappingResult = [];\n        var lastMappingResultIndex = 0;\n        var newMappingResultIndex = 0;\n\n        var nodesToDelete = [];\n        var itemsToProcess = [];\n        var itemsForBeforeRemoveCallbacks = [];\n        var itemsForMoveCallbacks = [];\n        var itemsForAfterAddCallbacks = [];\n        var mapData;\n\n        function itemMovedOrRetained(editScriptIndex, oldPosition) {\n            mapData = lastMappingResult[oldPosition];\n            if (newMappingResultIndex !== oldPosition)\n                itemsForMoveCallbacks[editScriptIndex] = mapData;\n            // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n            mapData.indexObservable(newMappingResultIndex++);\n            ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n            newMappingResult.push(mapData);\n            itemsToProcess.push(mapData);\n        }\n\n        function callCallback(callback, items) {\n            if (callback) {\n                for (var i = 0, n = items.length; i < n; i++) {\n                    if (items[i]) {\n                        ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                            callback(node, i, items[i].arrayEntry);\n                        });\n                    }\n                }\n            }\n        }\n\n        for (var i = 0, editScriptItem, movedIndex; editScriptItem = editScript[i]; i++) {\n            movedIndex = editScriptItem['moved'];\n            switch (editScriptItem['status']) {\n                case \"deleted\":\n                    if (movedIndex === undefined) {\n                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                        // Stop tracking changes to the mapping for these nodes\n                        if (mapData.dependentObservable)\n                            mapData.dependentObservable.dispose();\n\n                        // Queue these nodes for later removal\n                        nodesToDelete.push.apply(nodesToDelete, ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode));\n                        if (options['beforeRemove']) {\n                            itemsForBeforeRemoveCallbacks[i] = mapData;\n                            itemsToProcess.push(mapData);\n                        }\n                    }\n                    lastMappingResultIndex++;\n                    break;\n\n                case \"retained\":\n                    itemMovedOrRetained(i, lastMappingResultIndex++);\n                    break;\n\n                case \"added\":\n                    if (movedIndex !== undefined) {\n                        itemMovedOrRetained(i, movedIndex);\n                    } else {\n                        mapData = { arrayEntry: editScriptItem['value'], indexObservable: ko.observable(newMappingResultIndex++) };\n                        newMappingResult.push(mapData);\n                        itemsToProcess.push(mapData);\n                        if (!isFirstExecution)\n                            itemsForAfterAddCallbacks[i] = mapData;\n                    }\n                    break;\n            }\n        }\n\n        // Call beforeMove first before any changes have been made to the DOM\n        callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n        // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n        ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n        // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n        for (var i = 0, nextNode = ko.virtualElements.firstChild(domNode), lastNode, node; mapData = itemsToProcess[i]; i++) {\n            // Get nodes for newly added items\n            if (!mapData.mappedNodes)\n                ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n            // Put nodes in the right place if they aren't there already\n            for (var j = 0; node = mapData.mappedNodes[j]; nextNode = node.nextSibling, lastNode = node, j++) {\n                if (node !== nextNode)\n                    ko.virtualElements.insertAfter(domNode, node, lastNode);\n            }\n\n            // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n            if (!mapData.initialized && callbackAfterAddingNodes) {\n                callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                mapData.initialized = true;\n            }\n        }\n\n        // If there's a beforeRemove callback, call it after reordering.\n        // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n        // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n        // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n        // Perhaps we'll make that change in the future if this scenario becomes more common.\n        callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n        // Finally call afterMove and afterAdd callbacks\n        callCallback(options['afterMove'], itemsForMoveCallbacks);\n        callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n\n        // Store a copy of the array items we just considered so we can difference it next time\n        ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n    }\n})();\n\nko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\nko.nativeTemplateEngine = function () {\n    this['allowTemplateRewriting'] = false;\n}\n\nko.nativeTemplateEngine.prototype = new ko.templateEngine();\nko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\nko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n    var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n        templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n        templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n    if (templateNodes) {\n        return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n    } else {\n        var templateText = templateSource['text']();\n        return ko.utils.parseHtmlFragment(templateText, templateDocument);\n    }\n};\n\nko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\nko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\nko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n(function() {\n    ko.jqueryTmplTemplateEngine = function () {\n        // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n        // doesn't expose a version number, so we have to infer it.\n        // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n        // which KO internally refers to as version \"2\", so older versions are no longer detected.\n        var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n            if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                return 0;\n            // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n            try {\n                if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                    // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                    return 2; // Final version of jquery.tmpl\n                }\n            } catch(ex) { /* Apparently not the version we were looking for */ }\n\n            return 1; // Any older version that we don't support\n        })();\n\n        function ensureHasReferencedJQueryTemplates() {\n            if (jQueryTmplVersion < 2)\n                throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n        }\n\n        function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n            return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n        }\n\n        this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n            templateDocument = templateDocument || document;\n            options = options || {};\n            ensureHasReferencedJQueryTemplates();\n\n            // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n            var precompiled = templateSource['data']('precompiled');\n            if (!precompiled) {\n                var templateText = templateSource['text']() || \"\";\n                // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                precompiled = jQueryInstance['template'](null, templateText);\n                templateSource['data']('precompiled', precompiled);\n            }\n\n            var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n            var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n            var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n            resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n            jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n            return resultNodes;\n        };\n\n        this['createJavaScriptEvaluatorBlock'] = function(script) {\n            return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n        };\n\n        this['addTemplate'] = function(templateName, templateMarkup) {\n            document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n        };\n\n        if (jQueryTmplVersion > 0) {\n            jQueryInstance['tmpl']['tag']['ko_code'] = {\n                open: \"__.push($1 || '');\"\n            };\n            jQueryInstance['tmpl']['tag']['ko_with'] = {\n                open: \"with($1) {\",\n                close: \"} \"\n            };\n        }\n    };\n\n    ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n    ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n    // Use this one by default *only if jquery.tmpl is referenced*\n    var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n    if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n        ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n    ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n})();\n}));\n}());\n})();\n","mage/accordion.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    \"jquery\",\n    \"mage/tabs\"\n], function($, tabs){\n    \"use strict\";\n\n    $.widget(\"mage.accordion\", tabs, {\n        options: {\n            active : [0],\n            multipleCollapsible: false,\n            openOnFocus: false\n        },\n\n        _callCollapsible: function() {\n            if((typeof this.options.active) === \"string\") {\n                this.options.active = this.options.active.split(\" \").map(function(item) {\n                    return parseInt(item, 10);\n                });\n            }\n            var self = this,\n                disabled = false,\n                active = false;\n\n            $.each(this.collapsibles, function(i) {\n                disabled = active = false;\n                if($.inArray(i,self.options.disabled) !== -1) {\n                    disabled = true;\n                }\n                if($.inArray(i,self.options.active) !== -1) {\n                    active = true;\n                }\n                self._instantiateCollapsible(this,i,active,disabled);\n            });\n        },\n\n        /**\n         * Overwrites default functionality to provide the option to activate/deactivate multiple sections simultaneous\n         * @param action\n         * @param index\n         * @private\n         */\n        _toggleActivate: function(action,index) {\n            if($.isArray( index && this.options.multipleCollapsible)) {\n                var self = this;\n                $.each(index, function() {\n                    self.collapsibles.eq(this).collapsible(action);\n                });\n            } else if( (index === undefined) && this.options.multipleCollapsible) {\n                this.collapsibles.collapsible(action);\n            } else {\n                this._super(action,index);\n            }\n        },\n\n        /**\n         * If the Accordion allows multiple section to be active at the same time, if deep linking is used\n         * sections that don't contain the id from anchor shouldn't be closed, otherwise the accordion uses the\n         * tabs behavior\n         * @private\n         */\n        _handleDeepLinking: function() {\n            if(!this.options.multipleCollapsible) {\n                this._super();\n            }\n        },\n\n        /**\n         * Prevent default behavior that closes the other sections when one gets activated if the Accordion allows\n         * multiple sections simultaneous\n         * @private\n         */\n        _closeOthers: function() {\n            if(!this.options.multipleCollapsible) {\n                this._super();\n            }\n            $.each(this.collapsibles, function() {\n                $(this).on(\"beforeOpen\", function() {\n                    var section = $(this);\n                    section.addClass('allow').prevAll().addClass('allow');\n                    section.nextAll().removeClass('allow');\n                });\n            });\n        }\n    });\n    \n    return $.mage.accordion;\n});\n","mage/calendar.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*jshint browser:true jquery:true */\n/*eslint max-depth: 0*/\n\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui',\n            'jquery/jquery-ui-timepicker-addon'\n        ], factory);\n    } else {\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    var calendarBasePrototype,\n        datepickerPrototype = $.datepicker.constructor.prototype;\n\n    $.datepicker.markerClassName = '_has-datepicker';\n\n    /**\n     * Extend JQuery date picker prototype with store local time methods\n     */\n    $.extend(datepickerPrototype, {\n        /**\n         * Get date/time according to store settings.\n         * We use serverTimezoneOffset (in seconds) instead of serverTimezoneSeconds\n         * in order to have ability to know actual store time even if page hadn't been reloaded\n         * @returns {Date}\n         */\n        _getTimezoneDate: function (options) {\n            // local time in ms\n            var ms = Date.now();\n\n            options = options || $.calendarConfig || {};\n\n            // Adjust milliseconds according to store timezone offset,\n            // mind the GMT zero offset\n            if (typeof options.serverTimezoneOffset !== 'undefined') {\n                // Make UTC time and add store timezone offset in seconds\n                ms += new Date().getTimezoneOffset() * 60 * 1000 + options.serverTimezoneOffset * 1000;\n            } else if (typeof options.serverTimezoneSeconds !== 'undefined') {\n                //Set milliseconds according to client local timezone offset\n                ms = (options.serverTimezoneSeconds + new Date().getTimezoneOffset() * 60) * 1000;\n            }\n\n            return new Date(ms);\n        },\n\n        /**\n         * Set date/time according to store settings.\n         * @param {String|Object} target - the target input field or division or span\n         */\n        _setTimezoneDateDatepicker: function (target) {\n            this._setDateDatepicker(target, this._getTimezoneDate());\n        }\n    });\n\n    /**\n     * Widget calendar\n     */\n    $.widget('mage.calendar', {\n\n        /**\n         * Merge global options with options passed to widget invoke\n         * @protected\n         */\n        _create: function () {\n            this._enableAMPM();\n            this.options = $.extend(\n                {},\n                $.calendarConfig ? $.calendarConfig : {},\n                this.options.showsTime ? {\n                    showTime: true,\n                    showHour: true,\n                    showMinute: true\n                } : {},\n                this.options\n            );\n            this._initPicker(this.element);\n            this._overwriteGenerateHtml();\n        },\n\n        /**\n         * Get picker name\n         * @protected\n         */\n        _picker: function () {\n            return this.options.showsTime ? 'datetimepicker' : 'datepicker';\n        },\n\n        /**\n         * Fix for Timepicker - Set ampm option for Timepicker if timeformat contains string 'tt'\n         * @protected\n         */\n        _enableAMPM: function () {\n            if (this.options.timeFormat && this.options.timeFormat.indexOf('tt') >= 0) {\n                this.options.ampm = true;\n            }\n        },\n\n        /**\n         * Wrapper for overwrite jQuery UI datepicker function.\n         */\n        _overwriteGenerateHtml: function () {\n            /**\n             * Overwrite jQuery UI datepicker function.\n             * Reason: magento date could be set before calendar show\n             * but local date will be styled as current in original _generateHTML\n             *\n             * @param {Object} inst - instance datepicker.\n             * @return {String} html template\n             */\n            $.datepicker.constructor.prototype._generateHTML = function (inst) {\n                var today = this._getTimezoneDate(),\n                    isRTL = this._get(inst, 'isRTL'),\n                    showButtonPanel = this._get(inst, 'showButtonPanel'),\n                    hideIfNoPrevNext = this._get(inst, 'hideIfNoPrevNext'),\n                    navigationAsDateFormat = this._get(inst, 'navigationAsDateFormat'),\n                    numMonths = this._getNumberOfMonths(inst),\n                    showCurrentAtPos = this._get(inst, 'showCurrentAtPos'),\n                    stepMonths = this._get(inst, 'stepMonths'),\n                    isMultiMonth = parseInt(numMonths[0], 10) !== 1 || parseInt(numMonths[1], 10) !== 1,\n                    currentDate = this._daylightSavingAdjust(!inst.currentDay ? new Date(9999, 9, 9) :\n                        new Date(inst.currentYear, inst.currentMonth, inst.currentDay)),\n                    minDate = this._getMinMaxDate(inst, 'min'),\n                    maxDate = this._getMinMaxDate(inst, 'max'),\n                    drawMonth = inst.drawMonth - showCurrentAtPos,\n                    drawYear = inst.drawYear,\n                    maxDraw,\n                    prevText = this._get(inst, 'prevText'),\n                    prev,\n                    nextText = this._get(inst, 'nextText'),\n                    next,\n                    currentText = this._get(inst, 'currentText'),\n                    gotoDate,\n                    controls,\n                    buttonPanel,\n                    firstDay,\n                    showWeek = this._get(inst, 'showWeek'),\n                    dayNames = this._get(inst, 'dayNames'),\n                    dayNamesMin = this._get(inst, 'dayNamesMin'),\n                    monthNames = this._get(inst, 'monthNames'),\n                    monthNamesShort =  this._get(inst, 'monthNamesShort'),\n                    beforeShowDay = this._get(inst, 'beforeShowDay'),\n                    showOtherMonths = this._get(inst, 'showOtherMonths'),\n                    selectOtherMonths = this._get(inst, 'selectOtherMonths'),\n                    defaultDate = this._getDefaultDate(inst),\n                    html = '',\n                    row = 0,\n                    col = 0,\n                    selectedDate,\n                    cornerClass = ' ui-corner-all',\n                    group = '',\n                    calender = '',\n                    dow = 0,\n                    thead,\n                    day,\n                    daysInMonth,\n                    leadDays,\n                    curRows,\n                    numRows,\n                    printDate,\n                    dRow = 0,\n                    tbody,\n                    daySettings,\n                    otherMonth,\n                    unselectable;\n\n                if (drawMonth < 0) {\n                    drawMonth += 12;\n                    drawYear--;\n                }\n\n                if (maxDate) {\n                    maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),\n                        maxDate.getMonth() - numMonths[0] * numMonths[1] + 1, maxDate.getDate()));\n                    maxDraw = minDate && maxDraw < minDate ? minDate : maxDraw;\n\n                    while (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {\n                        drawMonth--;\n\n                        if (drawMonth < 0) {\n                            drawMonth = 11;\n                            drawYear--;\n\n                        }\n                    }\n                }\n                inst.drawMonth = drawMonth;\n                inst.drawYear = drawYear;\n                prevText = !navigationAsDateFormat ? prevText : this.formatDate(prevText,\n                    this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),\n                    this._getFormatConfig(inst));\n                prev = this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?\n                    '<a class=\"ui-datepicker-prev ui-corner-all\" data-handler=\"prev\" data-event=\"click\"' +\n                    ' title=\"' + prevText + '\">' +\n                    '<span class=\"ui-icon ui-icon-circle-triangle-' + (isRTL ? 'e' : 'w') + '\">' +\n                    '' + prevText + '</span></a>'\n                    : hideIfNoPrevNext ? ''\n                        :   '<a class=\"ui-datepicker-prev ui-corner-all ui-state-disabled\" title=\"' +\n                            '' + prevText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' +\n                            '' + (isRTL ? 'e' : 'w') + '\">' + prevText + '</span></a>';\n                nextText = !navigationAsDateFormat ?\n                    nextText\n                    :   this.formatDate(nextText,\n                        this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),\n                        this._getFormatConfig(inst));\n                next = this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?\n                    '<a class=\"ui-datepicker-next ui-corner-all\" data-handler=\"next\" data-event=\"click\"' +\n                    'title=\"' + nextText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' +\n                    '' + (isRTL ? 'w' : 'e') + '\">' + nextText + '</span></a>'\n                    : hideIfNoPrevNext ? ''\n                        :   '<a class=\"ui-datepicker-next ui-corner-all ui-state-disabled\" title=\"' + nextText + '\">' +\n                            '<span class=\"ui-icon ui-icon-circle-triangle-' + (isRTL ? 'w' : 'e') + '\">' + nextText +\n                            '</span></a>';\n                gotoDate = this._get(inst, 'gotoCurrent') && inst.currentDay ? currentDate : today;\n                currentText = !navigationAsDateFormat ? currentText :\n                    this.formatDate(currentText, gotoDate, this._getFormatConfig(inst));\n                controls = !inst.inline ?\n                    '<button type=\"button\" class=\"ui-datepicker-close ui-state-default ui-priority-primary ' +\n                    'ui-corner-all\" data-handler=\"hide\" data-event=\"click\">' +\n                    this._get(inst, 'closeText') + '</button>'\n                    : '';\n                buttonPanel = showButtonPanel ?\n                    '<div class=\"ui-datepicker-buttonpane ui-widget-content\">' + (isRTL ? controls : '') +\n                    (this._isInRange(inst, gotoDate) ? '<button type=\"button\" class=\"ui-datepicker-current ' +\n                    'ui-state-default ui-priority-secondary ui-corner-all\" data-handler=\"today\" data-event=\"click\"' +\n                    '>' + currentText + '</button>' : '') + (isRTL ? '' : controls) + '</div>' : '';\n                firstDay = parseInt(this._get(inst, 'firstDay'), 10);\n                firstDay = isNaN(firstDay) ? 0 : firstDay;\n\n                for (row; row < numMonths[0]; row++) {\n                    this.maxRows = 4;\n\n                    for (col; col < numMonths[1]; col++) {\n                        selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));\n\n                        if (isMultiMonth) {\n                            calender += '<div class=\"ui-datepicker-group';\n\n                            if (numMonths[1] > 1) {\n                                switch (col) {\n                                    case 0: calender += ' ui-datepicker-group-first';\n                                        cornerClass = ' ui-corner-' + (isRTL ? 'right' : 'left');\n                                        break;\n\n                                    case numMonths[1] - 1: calender += ' ui-datepicker-group-last';\n                                        cornerClass = ' ui-corner-' + (isRTL ? 'left' : 'right');\n                                        break;\n\n                                    default: calender += ' ui-datepicker-group-middle'; cornerClass = '';\n                                }\n                            }\n                            calender += '\">';\n                        }\n                        calender += '<div class=\"ui-datepicker-header ' +\n                            'ui-widget-header ui-helper-clearfix' + cornerClass + '\">' +\n                            (/all|left/.test(cornerClass) && parseInt(row, 10) === 0 ? isRTL ? next : prev : '') +\n                            (/all|right/.test(cornerClass) && parseInt(row, 10) === 0 ? isRTL ? prev : next : '') +\n                            this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,\n                            row > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers\n                            '</div><table class=\"ui-datepicker-calendar\"><thead>' +\n                            '<tr>';\n                        thead = showWeek ?\n                            '<th class=\"ui-datepicker-week-col\">' + this._get(inst, 'weekHeader') + '</th>' : '';\n\n                        for (dow; dow < 7; dow++) { // days of the week\n                            day = (dow + firstDay) % 7;\n                            thead += '<th' + ((dow + firstDay + 6) % 7 >= 5 ?\n                                ' class=\"ui-datepicker-week-end\"' : '') + '>' +\n                                '<span title=\"' + dayNames[day] + '\">' + dayNamesMin[day] + '</span></th>';\n                        }\n                        calender += thead + '</tr></thead><tbody>';\n                        daysInMonth = this._getDaysInMonth(drawYear, drawMonth);\n\n                        if (drawYear === inst.selectedYear && drawMonth === inst.selectedMonth) {\n                            inst.selectedDay = Math.min(inst.selectedDay, daysInMonth);\n                        }\n                        leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;\n                        curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate\n                        numRows = isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows;\n                        this.maxRows = numRows;\n                        printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));\n\n                        for (dRow; dRow < numRows; dRow++) { // create date picker rows\n                            calender += '<tr>';\n                            tbody = !showWeek ? '' : '<td class=\"ui-datepicker-week-col\">' +\n                            this._get(inst, 'calculateWeek')(printDate) + '</td>';\n\n                            for (dow = 0; dow < 7; dow++) { // create date picker days\n                                daySettings = beforeShowDay ?\n                                    beforeShowDay.apply(inst.input ? inst.input[0] : null, [printDate]) : [true, ''];\n                                otherMonth = printDate.getMonth() !== drawMonth;\n                                unselectable = otherMonth && !selectOtherMonths || !daySettings[0] ||\n                                minDate && printDate < minDate || maxDate && printDate > maxDate;\n                                tbody += '<td class=\"' +\n                                ((dow + firstDay + 6) % 7 >= 5 ? ' ui-datepicker-week-end' : '') + // highlight weekends\n                                (otherMonth ? ' ui-datepicker-other-month' : '') + // highlight days from other months\n                                (printDate.getTime() === selectedDate.getTime() &&\n                                drawMonth === inst.selectedMonth && inst._keyEvent || // user pressed key\n                                defaultDate.getTime() === printDate.getTime() &&\n                                defaultDate.getTime() === selectedDate.getTime() ?\n                                    // or defaultDate is current printedDate and defaultDate is selectedDate\n                                ' ' + this._dayOverClass : '') + // highlight selected day\n                                (unselectable ? ' ' + this._unselectableClass + ' ui-state-disabled' : '') +\n                                (otherMonth && !showOtherMonths ? '' : ' ' + daySettings[1] + // highlight custom dates\n                                (printDate.getTime() === currentDate.getTime() ? ' ' + this._currentClass : '') +\n                                (printDate.getDate() === today.getDate() && printDate.getMonth() === today.getMonth() &&\n                                printDate.getYear() === today.getYear() ? ' ui-datepicker-today' : '')) + '\"' +\n                                ((!otherMonth || showOtherMonths) && daySettings[2] ?\n                                ' title=\"' + daySettings[2] + '\"' : '') + // cell title\n                                (unselectable ? '' : ' data-handler=\"selectDay\" data-event=\"click\" data-month=\"' +\n                                '' + printDate.getMonth() + '\" data-year=\"' + printDate.getFullYear() + '\"') + '>' +\n                                (otherMonth && !showOtherMonths ? '&#xa0;' : // display for other months\n                                    unselectable ? '<span class=\"ui-state-default\">' + printDate.getDate() + '</span>'\n                                        : '<a class=\"ui-state-default' +\n                                    (printDate.getTime() === today.getTime() ? ' ' : '') +\n                                    (printDate.getTime() === currentDate.getTime() ? ' ui-state-active' : '') +\n                                    (otherMonth ? ' ui-priority-secondary' : '') +\n                                    '\" href=\"#\">' + printDate.getDate() + '</a>') + '</td>';\n                                printDate.setDate(printDate.getDate() + 1);\n                                printDate = this._daylightSavingAdjust(printDate);\n                            }\n                            calender += tbody + '</tr>';\n                        }\n                        drawMonth++;\n\n                        if (drawMonth > 11) {\n                            drawMonth = 0;\n                            drawYear++;\n                        }\n                        calender += '</tbody></table>' + (isMultiMonth ? '</div>' +\n                        (numMonths[0] > 0 && col === numMonths[1] - 1 ? '<div class=\"ui-datepicker-row-break\"></div>'\n                            : '') : '');\n                        group += calender;\n                    }\n                    html += group;\n                }\n                html += buttonPanel + ($.ui.ie6 && !inst.inline ?\n                    '<iframe src=\"javascript:false;\" class=\"ui-datepicker-cover\" frameborder=\"0\"></iframe>' : '');\n                inst._keyEvent = false;\n\n                return html;\n            };\n        },\n\n        /**\n         * Set current date if the date is not set\n         * @protected\n         * @param {Object} element\n         */\n        _setCurrentDate: function (element) {\n            if (!element.val()) {\n                element[this._picker()]('setTimezoneDate').val('');\n            }\n        },\n\n        /**\n         * Init Datetimepicker\n         * @protected\n         * @param {Object} element\n         */\n        _initPicker: function (element) {\n            var picker = element[this._picker()](this.options),\n                pickerButtonText = picker.next('.ui-datepicker-trigger')\n                    .find('img')\n                    .attr('title');\n\n            picker.next('.ui-datepicker-trigger')\n                .addClass('v-middle')\n                .text('') // Remove jQuery UI datepicker generated image\n                .append('<span>' + pickerButtonText + '</span>');\n            this._setCurrentDate(element);\n        },\n\n        /**\n         * destroy instance of datetimepicker\n         */\n        _destroy: function () {\n            this.element[this._picker()]('destroy');\n            this._super();\n        },\n\n        /**\n         * Method is kept for backward compatibility and unit-tests acceptance\n         * see \\mage\\calendar\\calendar-test.js\n         * @return {Object} date\n         */\n        getTimezoneDate: function () {\n            return datepickerPrototype._getTimezoneDate.call(this, this.options);\n        }\n    });\n\n    calendarBasePrototype = $.mage.calendar.prototype;\n\n    /**\n     * Extension for Calendar - date and time format convert functionality\n     * @var {Object}\n     */\n    $.widget('mage.calendar', $.extend({}, calendarBasePrototype,\n            /** @lends {$.mage.calendar.prototype} */ {\n                /**\n                 * key - backend format, value - jquery format\n                 * @type {Object}\n                 * @private\n                 */\n                dateTimeFormat: {\n                    date: {\n                        'EEEE': 'DD',\n                        'EEE': 'D',\n                        'EE': 'D',\n                        'E': 'D',\n                        'D': 'o',\n                        'MMMM': 'MM',\n                        'MMM': 'M',\n                        'MM': 'mm',\n                        'M': 'mm',\n                        'yyyy': 'yy',\n                        'y': 'yy',\n                        'Y': 'yy',\n                        'yy': 'yy' // Always long year format on frontend\n                    },\n                    time: {\n                        'a': 'TT'\n                    }\n                },\n\n                /**\n                 * Add Date and Time converting to _create method\n                 * @protected\n                 */\n                _create: function () {\n                    if (this.options.dateFormat) {\n                        this.options.dateFormat = this._convertFormat(this.options.dateFormat, 'date');\n                    }\n\n                    if (this.options.timeFormat) {\n                        this.options.timeFormat = this._convertFormat(this.options.timeFormat, 'time');\n                    }\n                    calendarBasePrototype._create.apply(this, arguments);\n                },\n\n                /**\n                 * Converting date or time format\n                 * @protected\n                 * @param {String} format\n                 * @param {String} type\n                 * @return {String}\n                 */\n                _convertFormat: function (format, type) {\n                    var symbols = format.match(/([a-z]+)/ig),\n                        separators = format.match(/([^a-z]+)/ig),\n                        self = this,\n                        convertedFormat = '';\n\n                    if (symbols) {\n                        $.each(symbols, function (key, val) {\n                            convertedFormat +=\n                                (self.dateTimeFormat[type][val] || val) +\n                                (separators[key] || '');\n                        });\n                    }\n\n                    return convertedFormat;\n                }\n            })\n    );\n\n    /**\n     * Widget dateRange\n     * @extends $.mage.calendar\n     */\n    $.widget('mage.dateRange', $.mage.calendar, {\n\n        /**\n         * creates two instances of datetimepicker for date range selection\n         * @protected\n         */\n        _initPicker: function () {\n            var from,\n                to;\n\n            if (this.options.from && this.options.to) {\n                from = this.element.find('#' + this.options.from.id);\n                to = this.element.find('#' + this.options.to.id);\n                this.options.onSelect = $.proxy(function (selectedDate) {\n                    to[this._picker()]('option', 'minDate', selectedDate);\n                }, this);\n                $.mage.calendar.prototype._initPicker.call(this, from);\n                from.on('change', $.proxy(function () {\n                    to[this._picker()]('option', 'minDate', from[this._picker()]('getDate'));\n                }, this));\n                this.options.onSelect = $.proxy(function (selectedDate) {\n                    from[this._picker()]('option', 'maxDate', selectedDate);\n                }, this);\n                $.mage.calendar.prototype._initPicker.call(this, to);\n                to.on('change', $.proxy(function () {\n                    from[this._picker()]('option', 'maxDate', to[this._picker()]('getDate'));\n                }, this));\n            }\n        },\n\n        /**\n         * destroy two instances of datetimepicker\n         */\n        _destroy: function () {\n            if (this.options.from) {\n                this.element.find('#' + this.options.from.id)[this._picker()]('destroy');\n            }\n\n            if (this.options.to) {\n                this.element.find('#' + this.options.to.id)[this._picker()]('destroy');\n            }\n            this._super();\n        }\n    });\n\n    // Overrides the \"today\" button functionality to select today's date when clicked.\n    $.datepicker._gotoTodayOriginal = $.datepicker._gotoToday;\n\n    /**\n     * overwrite jQuery UI _showDatepicker function for proper HTML generation conditions.\n     *\n     */\n    $.datepicker._showDatepickerOriginal = $.datepicker._showDatepicker;\n\n    /**\n     * Triggers original method showDataPicker for rendering calendar\n     * @param {HTMLObject} input\n     * @private\n     */\n    $.datepicker._showDatepicker = function (input) {\n        if (!input.disabled) {\n            $.datepicker._showDatepickerOriginal.call(this, input);\n        }\n    };\n\n    /**\n     * _gotoToday\n     * @param {Object} el\n     */\n    $.datepicker._gotoToday = function (el) {\n        //Set date/time according to timezone offset\n        $(el).datepicker('setTimezoneDate')\n            // To ensure that user can re-select date field without clicking outside it first.\n            .blur();\n    };\n\n    return {\n        dateRange:  $.mage.dateRange,\n        calendar:   $.mage.calendar\n    };\n}));\n","mage/captcha.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\nvar Captcha = Class.create();\nCaptcha.prototype = {\n    initialize: function(url, formId){\n        this.url = url;\n        this.formId = formId;\n    },\n    refresh: function(elem) {\n        formId = this.formId;\n        if (elem) Element.addClassName(elem, 'refreshing');\n        new Ajax.Request(this.url, {\n            onSuccess: function (response) {\n                if (response.responseText.isJSON()) {\n                    var json = response.responseText.evalJSON();\n                    if (!json.error && json.imgSrc) {\n                        $(formId).writeAttribute('src', json.imgSrc);\n                        if (elem) Element.removeClassName(elem, 'refreshing');\n                    } else {\n                        if (elem) Element.removeClassName(elem, 'refreshing');\n                    }\n                }\n            },\n            method: 'post',\n            parameters: {\n                'formId'   : this.formId\n            }\n        });\n    }\n};\n\n\n","mage/collapsible.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    'jquery/jquery-storageapi',\n    \"mage/mage\"\n], function($){\n    \"use strict\";\n    \n    var hideProps = {},\n        showProps = {};\n\n    hideProps.height =  \"hide\";\n    showProps.height =  \"show\";\n\n    $.widget(\"mage.collapsible\", {\n        options: {\n            active: false,\n            disabled: false,\n            collapsible: true,\n            header: \"[data-role=title]\",\n            content: \"[data-role=content]\",\n            trigger: \"[data-role=trigger]\",\n            closedState: null,\n            openedState: null,\n            disabledState: null,\n            ajaxUrlElement: \"[data-ajax=true]\",\n            ajaxContent: false,\n            loadingClass: null,\n            saveState: false,\n            animate: false,\n            icons: {\n                activeHeader: null,\n                header: null\n            },\n            collateral: {\n                element: null,\n                openedState: null\n            }\n        },\n\n        _create: function () {\n            this.storage= $.localStorage;\n            this.icons = false;\n            if((typeof this.options.icons) === \"string\") {\n                this.options.icons = $.parseJSON(this.options.icons);\n            }\n\n            this._processPanels();\n            this._processState();\n            this._refresh();\n\n\n            if (this.options.icons.header && this.options.icons.activeHeader) {\n                this._createIcons();\n                this.icons = true;\n            }\n\n            this._bind(\"click\");\n            this._trigger('created');\n        },\n\n        _refresh: function () {\n            this.trigger.attr(\"tabIndex\",0);\n            if (this.options.active && !this.options.disabled) {\n                if (this.options.openedState) {\n                    this.element.addClass(this.options.openedState);\n                }\n                if (this.options.collateral.element && this.options.collateral.openedState) {\n                    $(this.options.collateral.element).addClass(this.options.collateral.openedState);\n                }\n                if (this.options.ajaxContent) {\n                    this._loadContent();\n                }\n                // ARIA (updates aria attributes)\n                this.header.attr({\n                    'aria-selected': false\n                });\n            }\n            else if (this.options.disabled) {\n                this.disable();\n            } else {\n                this.content.hide();\n                if(this.options.closedState) {\n                    this.element.addClass(this.options.closedState);\n                }\n            }\n        },\n\n        /**\n         * Processing the state:\n         *     If deep linking is used and the anchor is the id of the content or the content contains this id,\n         *     and the collapsible element is a nested one having collapsible parents, in order to see the content,\n         *     all the parents must be expanded.\n         * @private\n         */\n        _processState: function () {\n            var anchor = window.location.hash,\n                isValid = $.mage.isValidSelector(anchor),\n                urlPath = window.location.pathname.replace('.', '');\n\n            this.stateKey = encodeURIComponent(urlPath + this.element.attr(\"id\"));\n            \n            if ( isValid && ( $(this.content.find(anchor)).length > 0 || this.content.attr(\"id\") === anchor.replace(\"#\",\"\")) ) {\n                this.element.parents(\"[data-collapsible=true]\").collapsible(\"forceActivate\");\n                if(!this.options.disabled) {\n                    this.options.active = true;\n                    if (this.options.saveState) {\n                        this.storage.set(this.stateKey,true);\n                    }\n                }\n            } else if (this.options.saveState && !this.options.disabled) {\n                var state = this.storage.get(this.stateKey);\n                if (typeof state === 'undefined' || state === null) {\n                    this.storage.set(this.stateKey,this.options.active);\n                } else if (state === true) {\n                    this.options.active = true;\n                } else if (state === false) {\n                    this.options.active = false;\n                }\n            }\n        },\n\n        _createIcons: function () {\n            var icons = this.options.icons;\n            if (icons) {\n                $(\"<span>\")\n                    .addClass(icons.header)\n                    .attr(\"data-role\",\"icons\")\n                    .prependTo(this.header);\n                if (this.options.active && !this.options.disabled) {\n                    this.header.children(\"[data-role=icons]\")\n                        .removeClass(icons.header)\n                        .addClass(icons.activeHeader);\n                }\n            }\n        },\n\n        _destroyIcons: function () {\n            this.header\n                .children(\"[data-role=icons]\")\n                .remove();\n        },\n\n        _destroy: function () {\n            var options = this.options;\n\n            this.element.removeAttr(\"data-collapsible\");\n\n            this.trigger.removeAttr(\"tabIndex\");\n            if(options.openedState) {\n                this.element.removeClass(options.openedState);\n            }\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).removeClass(this.options.collateral.openedState);\n            }\n            if(options.closedState){\n                this.element.removeClass(options.closedState);\n            }\n            if(options.disabledState){\n                this.element.removeClass(options.disabledState);\n            }\n\n            if (this.icons) {\n                this._destroyIcons();\n            }\n        },\n\n        _processPanels: function () {\n            this.element.attr(\"data-collapsible\", \"true\");\n\n            if (typeof this.options.header === \"object\") {\n                this.header = this.options.header;\n            } else {\n                var headers = this.element.find(this.options.header);\n                if(headers.length > 0) {\n                    this.header = headers.eq(0);\n                } else {\n                    this.header = this.element;\n                }\n            }\n\n            if (typeof this.options.content === \"object\") {\n                this.content = this.options.content;\n            } else {\n                this.content = this.header.next(this.options.content).eq(0);\n            }\n\n            // ARIA (init aria attributes)\n            if (this.header.attr('id')) {\n                this.content.attr('aria-labelledby', this.header.attr('id'));\n            }\n\n            if (this.content.attr('id')) {\n                this.header.attr('aria-controls', this.content.attr('id'));\n            }\n\n            this.header\n                .attr({\n                    'role': 'tab',\n                    'aria-selected': this.options.active,\n                    'aria-expanded': this.options.active\n                });\n\n            // For collapsible widget only (not tabs or accordion)\n            if (this.header.parent().attr('role') != 'presentation') {\n                this.header\n                    .parent()\n                    .attr('role', 'tablist');\n            }\n\n            this.content.attr({\n                'role': 'tabpanel',\n                'aria-hidden': !this.options.active\n            });\n\n            if (typeof this.options.trigger === \"object\") {\n                this.trigger = this.options.trigger;\n            } else {\n                var triggers = this.header.find(this.options.trigger);\n                if(triggers.length > 0) {\n                    this.trigger = triggers.eq(0);\n                } else {\n                    this.trigger = this.header;\n                }\n            }\n        },\n\n        _keydown: function (event) {\n            if (event.altKey || event.ctrlKey) {\n                return;\n            }\n\n            var keyCode = $.ui.keyCode;\n\n            switch (event.keyCode) {\n                case keyCode.SPACE:\n                case keyCode.ENTER:\n                    this._eventHandler(event);\n                    break;\n            }\n\n        },\n\n        _bind: function (event) {\n            this.events = {\n                keydown: \"_keydown\"\n            };\n            var self = this;\n            if (event) {\n                $.each(event.split(\" \"), function (index, eventName) {\n                    self.events[ eventName ] = \"_eventHandler\";\n                });\n            }\n            this._off(this.trigger);\n            if(!this.options.disabled) {\n                this._on(this.trigger, this.events);\n            }\n        },\n\n        disable: function() {\n            this._off(this.trigger);\n            this.forceDeactivate();\n            this.options.disabled = true;\n            if(this.options.disabledState) {\n                this.element.addClass(this.options.disabledState);\n            }\n            this.trigger.attr(\"tabIndex\",-1);\n        },\n\n        enable: function() {\n            this._on(this.trigger, this.events);\n            this.options.disabled = false;\n            if(this.options.disabledState) {\n                this.element.removeClass(this.options.disabledState);\n            }\n        },\n\n        _eventHandler: function (event) {\n\n            if (this.options.active && this.options.collapsible) {\n                this.deactivate();\n            } else {\n                this.activate();\n\n            }\n            event.preventDefault();\n\n        },\n\n        _animate: function(prop) {\n            var duration,\n                easing,\n                animate = this.options.animate;\n\n            if ( typeof animate === \"number\" ) {\n                duration = animate;\n            }\n            if (typeof animate === \"string\" ) {\n                animate = $.parseJSON(animate);\n            }\n            duration = duration || animate.duration;\n            easing = animate.easing;\n            this.content.animate(prop,duration,easing);\n        },\n\n        deactivate: function () {\n            if(this.options.animate) {\n                this._animate(hideProps);\n            } else {\n                this.content.hide();\n            }\n            this._close();\n        },\n\n        forceDeactivate: function () {\n            this.content.hide();\n            this._close();\n\n        },\n\n        _close: function () {\n\n            this.options.active = false;\n\n            if (this.options.saveState) {\n                this.storage.set(this.stateKey,false);\n            }\n            if (this.options.openedState) {\n                this.element.removeClass(this.options.openedState);\n            }\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).removeClass(this.options.collateral.openedState);\n            }\n            if(this.options.closedState) {\n                this.element.addClass(this.options.closedState);\n            }\n            if (this.icons) {\n                this.header.children(\"[data-role=icons]\")\n                    .removeClass(this.options.icons.activeHeader)\n                    .addClass(this.options.icons.header);\n            }\n\n            // ARIA (updates aria attributes)\n            this.header.attr({\n                'aria-selected': 'false',\n                'aria-expanded': 'false'\n            });\n            this.content.attr({\n                'aria-hidden': 'true'\n            });\n\n            this.element.trigger('dimensionsChanged', {opened: false});\n        },\n\n        activate: function () {\n            if (!this.options.disabled) {\n                if (this.options.animate) {\n                    this._animate(showProps);\n                } else {\n                    this.content.show();\n                }\n                this._open();\n            }\n        },\n\n        forceActivate: function () {\n            if (!this.options.disabled) {\n                this.content.show();\n                this._open();\n            }\n        },\n\n        _open: function () {\n\n            this.element.trigger(\"beforeOpen\");\n\n            this.options.active = true;\n\n            if (this.options.ajaxContent) {\n                this._loadContent();\n            }\n            if (this.options.saveState) {\n                this.storage.set(this.stateKey,true);\n            }\n            if (this.options.openedState) {\n                this.element.addClass(this.options.openedState);\n            }\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).addClass(this.options.collateral.openedState);\n            }\n            if (this.options.closedState) {\n                this.element.removeClass(this.options.closedState);\n            }\n            if (this.icons) {\n                this.header.children(\"[data-role=icons]\")\n                    .removeClass(this.options.icons.header)\n                    .addClass(this.options.icons.activeHeader);\n            }\n\n            // ARIA (updates aria attributes)\n            this.header.attr({\n                'aria-selected': 'true',\n                'aria-expanded': 'true'\n            });\n            this.content.attr({\n                'aria-hidden': 'false'\n            });\n\n            this.element.trigger('dimensionsChanged', {opened: true});\n        },\n\n        _loadContent: function () {\n            var url = this.element.find(this.options.ajaxUrlElement).attr(\"href\");\n            if(url) {\n                this.xhr = $.get(url, function () {\n                });\n            }\n            var that = this;\n            if (that.xhr && that.xhr.statusText !== \"canceled\") {\n                if(that.options.loadingClass) {\n                    that.element.addClass(that.options.loadingClass);\n                }\n                that.content.attr(\"aria-busy\", \"true\");\n                that.xhr\n                    .success(function (response) {\n                        setTimeout(function () {\n                            that.content.html(response);\n                        }, 1);\n                    })\n                    .complete(function (jqXHR, status) {\n                        setTimeout(function () {\n                            if (status === \"abort\") {\n                                that.content.stop(false, true);\n                            }\n                            if(that.options.loadingClass) {\n                                that.element.removeClass(that.options.loadingClass);\n                            }\n                            that.content.removeAttr(\"aria-busy\");\n                            if (jqXHR === that.xhr) {\n                                delete that.xhr;\n                            }\n                        }, 1);\n                    });\n            }\n        }\n\n    });\n    \n    return $.mage.collapsible;\n});\n","mage/dropdown_old.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true */\ndefine([\n    \"jquery\"\n], function($){\n\n    'use strict';\n    var ESC_KEY_CODE = '27';\n\n    $(document)\n        .on('click.dropdown', function(event) {\n            if (!$(event.target).is('[data-toggle=dropdown].active, ' +\n                '[data-toggle=dropdown].active *, ' +\n                '[data-toggle=dropdown].active + .dropdown-menu, ' +\n                '[data-toggle=dropdown].active + .dropdown-menu *,' +\n                '[data-toggle=dropdown].active + [data-target=\"dropdown\"],' +\n                '[data-toggle=dropdown].active + [data-target=\"dropdown\"] *')\n            ) {\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n            }\n        })\n        .on('keyup.dropdown', function(event) {\n            if (event.keyCode == ESC_KEY_CODE) {\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n            }\n        });\n\n    $.fn.dropdown = function(options) {\n        options = $.extend({\n            parent: null,\n            btnArrow: '.arrow',\n            activeClass: 'active'\n        }, options);\n\n        return this.each(function() {\n            var elem = $(this);\n\n            elem.off('open.dropdown, close.dropdown, click.dropdown');\n            elem.on('open.dropdown', function() {\n                elem\n                    .addClass(options.activeClass)\n                    .parent()\n                    .addClass(options.activeClass);\n                elem.find(options.btnArrow).text('\\u25b2'); // arrow up\n            });\n\n            elem.on('close.dropdown', function() {\n                elem\n                    .removeClass(options.activeClass)\n                    .parent()\n                    .removeClass(options.activeClass);\n                elem.find(options.btnArrow).text('\\u25bc'); // arrow down\n            });\n\n            elem.on('click.dropdown', function() {\n                var isActive = elem.hasClass('active');\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n                elem.trigger(isActive ? 'close.dropdown' : 'open.dropdown');\n                return false;\n            });\n        });\n    };\n\n    return function (data, el) {\n        $(el).dropdown(data);\n    };\n});\n","mage/edit-trigger.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true */\n(function (root, factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"mage/template\",\n            \"jquery/ui\"\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    \"use strict\";\n    $.widget(\"mage.editTrigger\", {\n        options: {\n            img: '',\n            alt: '[TR]',\n            template: '#translate-inline-icon',\n            zIndex: 2000,\n            editSelector: '[data-translate]',\n            delay: 2000,\n            offsetTop: -3,\n            singleElement: true\n        },\n        /**\n         * editTriger creation\n         * @protected\n         */\n        _create: function() {\n            this.tmpl = mageTemplate(this.options.template);\n            this._initTrigger();\n            this._bind();\n        },\n        _getCss: function() {\n            return {\n                position: 'absolute',\n                cursor: 'pointer',\n                display: 'none',\n                'z-index': this.options.zIndex\n            };\n        },\n        _createTrigger: function(appendTo) {\n            var tmpl = this.tmpl({\n                data: this.options\n            });\n\n            return $(tmpl)\n                .css(this._getCss())\n                .data('role', 'edit-trigger-element')\n                .appendTo(appendTo);\n        },\n        _initTrigger: function() {\n            this.trigger = this._createTrigger($('body'));\n        },\n        /**\n         * Bind on mousemove event\n         * @protected\n         */\n        _bind: function() {\n            this.trigger.on('click.' + this.widgetName, $.proxy(this._onClick, this));\n            this.element.on('mousemove.' + this.widgetName, $.proxy(this._onMouseMove, this));\n        },\n        /**\n         * Show editTriger\n         */\n        show: function() {\n            if (this.trigger.is(':hidden')) {\n                this.trigger.show();\n            }\n        },\n        /**\n         * Hide editTriger\n         */\n        hide: function() {\n            this.currentTarget = null;\n            if (this.trigger && this.trigger.is(':visible')) {\n                this.trigger.hide();\n            }\n        },\n        /**\n         * Set editTriger position\n         * @protected\n         */\n        _setPosition: function(el) {\n            var offset = el.offset();\n            this.trigger.css({\n                top: offset.top + el.outerHeight() + this.options.offsetTop,\n                left: offset.left\n            });\n        },\n        /**\n         * Show/hide trigger on mouse move\n         * @param {Object} event object\n         * @protected\n         */\n        _onMouseMove: function(e) {\n            var target = $(e.target);\n            target = target.is(this.trigger) || target.is(this.options.editSelector) ?\n                target :\n                target.parents(this.options.editSelector).first();\n\n            if (target.size()) {\n                if (!target.is(this.trigger)) {\n                    this._setPosition(target);\n                    this.currentTarget = target;\n                }\n                this.show();\n            } else {\n                this.hide();\n            }\n        },\n        /**\n         * Trigger event \"edit\" on element for translate\n         * @param {Object} event object\n         * @protected\n         */\n        _onClick: function(e) {\n            e.preventDefault();\n            e.stopImmediatePropagation();\n            $(this.currentTarget).trigger('edit.' + this.widgetName);\n            this.hide(true);\n        },\n        /**\n         * Destroy editTriger\n         */\n        destroy: function() {\n            this.trigger.remove();\n            this.element.off('.' + this.widgetName);\n            return $.Widget.prototype.destroy.call(this);\n        }\n    });\n\n    /**\n     * Extention for widget editTrigger - hide trigger with delay\n     */\n    var editTriggerPrototype = $.mage.editTrigger.prototype;\n    $.widget(\"mage.editTrigger\", $.extend({}, editTriggerPrototype, {\n        /**\n         * Added clear timeout on trigger show\n         */\n        show: function() {\n            editTriggerPrototype.show.apply(this, arguments);\n            if(this.options.delay){\n                this._clearTimer();\n            }\n        },\n        /**\n         * Added setTimeout on trigger hide\n         */\n        hide: function(immediate) {\n            if(!immediate && this.options.delay){\n                if(!this.timer){\n                    this.timer = setTimeout($.proxy(function() {\n                        editTriggerPrototype.hide.apply(this, arguments);\n                        this._clearTimer();\n                    }, this), this.options.delay);\n                }\n            } else {\n                editTriggerPrototype.hide.apply(this, arguments);\n            }\n        },\n        /**\n         * Clear timer\n         * @protected\n         */\n        _clearTimer: function() {\n            if (this.timer) {\n                clearTimeout(this.timer);\n                this.timer = null;\n            }\n        }\n    }));\n\n    return $.mage.editTrigger;\n}));\n","mage/ie-class-fixer.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n(function () {\n\n    var userAgent = navigator.userAgent, // user agent identifier\n        html = document.documentElement, // html tag\n        version = 9, // minimal supported version of IE\n        gap = ''; // gap between classes\n\n    if (html.className) { // check if neighbour class exist in html tag\n        gap = ' ';\n    } // end if\n\n    for (version; version <= 10; version++) { // loop from minimal to 10 version of IE\n        if (userAgent.indexOf('MSIE ' + version) > -1) { // match IE individual name\n            html.className += gap + 'ie' + version;\n        } // end if\n    }\n\n    if (userAgent.match(/Trident.*rv[ :]*11\\./)) { // Special case for IE11\n        html.className += gap + 'ie11';\n    } // end if\n\n})();\n","mage/loader_old.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true */\n/*global console:true*/\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/template',\n            'jquery/ui',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.loader', {\n        loaderStarted: 0,\n        spinner: $(undefined),\n        options: {\n            icon: '',\n            texts: {\n                loaderText: $.mage.__('Please wait...'),\n                imgAlt: $.mage.__('Loading...')\n            },\n            template: '<div class=\"loading-mask\" data-role=\"loader\">' +\n                '<div class=\"popup popup-loading\">' +\n                '<div class=\"popup-inner\">' +\n                '<% if (data.icon) { %><img <% if (data.texts.imgAlt) { %>alt=\"<%- data.texts.imgAlt %>\"<% } %> src=\"<%- data.icon %>\"><% } %>' +\n                '<% if (data.texts.loaderText) { %><%- data.texts.loaderText %><% } %>' +\n                '</div>' +\n                '</div>' +\n                '</div>'\n        },\n\n        /**\n         * Loader creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind on ajax events\n         * @protected\n         */\n        _bind: function () {\n            this._on({\n                'processStop': 'hide',\n                'processStart': 'show',\n                'show.loader': 'show',\n                'hide.loader': 'hide',\n                'contentUpdated.loader': '_contentUpdated'\n            });\n        },\n\n        /**\n         * Verify loader present after content updated\n         *\n         * This will be cleaned up by the task MAGETWO-11070\n         *\n         * @param event\n         * @private\n         */\n        _contentUpdated: function (e) {\n            this.show(e);\n        },\n\n        /**\n         * Show loader\n         */\n        show: function (e, ctx) {\n            this._render();\n            this.loaderStarted++;\n            this.spinner.show();\n\n            if (ctx) {\n                this.spinner\n                    .css({\n                        width: ctx.outerWidth(),\n                        height: ctx.outerHeight(),\n                        position: 'absolute'\n                    })\n                    .position({\n                        my: 'top left',\n                        at: 'top left',\n                        of: ctx\n                    });\n            }\n\n            return false;\n        },\n\n        /**\n         * Hide loader\n         */\n        hide: function () {\n            if (this.loaderStarted > 0) {\n                this.loaderStarted--;\n\n                if (this.loaderStarted === 0) {\n                    this.spinner.hide();\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Render loader\n         * @protected\n         */\n        _render: function () {\n            var tmpl;\n\n            if (this.spinner.length === 0) {\n                tmpl = mageTemplate(this.options.template, {\n                    data: this.options\n                });\n\n                this.spinner = $(tmpl);\n            }\n\n            this.element.prepend(this.spinner);\n        },\n\n        /**\n         * Destroy loader\n         */\n        _destroy: function () {\n            this.spinner.remove();\n        }\n    });\n\n    /**\n     * This widget takes care of registering the needed loader listeners on the body\n     */\n    $.widget('mage.loaderAjax', {\n        options: {\n            defaultContainer: '[data-container=body]'\n        },\n\n        _create: function () {\n            this._bind();\n            // There should only be one instance of this widget, and it should be attached\n            // to the body only. Having it on the page twice will trigger multiple processStarts.\n            if (window.console && !this.element.is(this.options.defaultContainer) && $.mage.isDevMode(undefined)) {\n                console.warn('This widget is intended to be attached to the body, not below.');\n            }\n        },\n\n        _bind: function () {\n            $(document).on({\n                'ajaxSend': this._onAjaxSend.bind(this),\n                'ajaxComplete': this._onAjaxComplete.bind(this)\n            });\n        },\n\n        _getJqueryObj: function (loaderContext) {\n            var ctx;\n            // Check to see if context is jQuery object or not.\n            if (loaderContext) {\n                if (loaderContext.jquery) {\n                    ctx = loaderContext;\n                } else {\n                    ctx = $(loaderContext);\n                }\n            } else {\n                ctx = $('[data-container=\"body\"]');\n            }\n\n            return ctx;\n        },\n\n        _onAjaxSend: function (e, jqxhr, settings) {\n            if (settings && settings.showLoader) {\n                var ctx = this._getJqueryObj(settings.loaderContext);\n                ctx.trigger('processStart');\n\n                // Check to make sure the loader is there on the page if not report it on the console.\n                // NOTE that this check should be removed before going live. It is just an aid to help\n                // in finding the uses of the loader that maybe broken.\n                if (window.console && !ctx.parents('[data-role=\"loader\"]').length) {\n                    console.warn('Expected to start loader but did not find one in the dom');\n                }\n            }\n        },\n\n        _onAjaxComplete: function (e, jqxhr, settings) {\n            if (settings && settings.showLoader && !settings.dontHide) {\n                this._getJqueryObj(settings.loaderContext).trigger('processStop');\n            }\n        }\n    });\n\n    return {\n        loader: $.mage.loader,\n        loaderAjax: $.mage.loaderAjax\n    };\n}));","mage/mage.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint eqnull:true browser:true expr:true */\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/apply/main'\n        ], factory);\n    } else {\n        factory(root.jQuery);\n    }\n}(this, function ($, mage) {\n    'use strict';\n\n    /**\n     * Main namespace for Magento extensions\n     * @type {Object}\n     */\n    $.mage = $.mage || {};\n\n    /**\n     * Plugin mage, initialize components on elements\n     * @param {String} name - Components' path.\n     * @param {Object} config - Components' config.\n     * @returns {JQuery} Chainable.\n     */\n    $.fn.mage = function (name, config) {\n        config = config || {};\n\n        this.each(function (index, el) {\n            mage.applyFor(el, config, name);\n        });\n\n        return this;\n    };\n\n    $.extend($.mage, {\n        /**\n         * Handle all components declared via data attribute\n         * @return {Object} $.mage\n         */\n        init: function () {\n            mage.apply();\n\n            return this;\n        },\n\n        /**\n         * Method handling redirects and page refresh\n         * @param {String} url - redirect URL\n         * @param {(undefined|String)} type - 'assign', 'reload', 'replace'\n         * @param {(undefined|Number)} timeout - timeout in milliseconds before processing the redirect or reload\n         * @param {(undefined|Boolean)} forced - true|false used for 'reload' only\n         */\n        redirect: function (url, type, timeout, forced) {\n            var _redirect;\n\n            forced  = !!forced;\n            timeout = timeout || 0;\n            type    = type || 'assign';\n\n            _redirect = function () {\n                window.location[type](type === 'reload' ? forced : url);\n            };\n\n            timeout ? setTimeout(_redirect, timeout) : _redirect();\n        },\n\n        /**\n         * Checks if provided string is a valid selector.\n         * @param {String} selector - Selector to check.\n         * @returns {Boolean}\n         */\n        isValidSelector: function (selector) {\n            try {\n                document.querySelector(selector);\n\n                return true;\n            } catch (e) {\n                return false;\n            }\n        }\n    });\n\n    /**\n     * Init components inside of dynamically updated elements\n     */\n    $('body').on('contentUpdated', function () {\n        if (mage) {\n            mage.apply();\n        }\n    });\n\n    return $.mage;\n}));\n","mage/popup-window.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\ndefine([\n    \"jquery\",\n    \"jquery/ui\"\n], function($){\n    \"use strict\";\n    \n    $.widget('mage.popupWindow', {\n        options: {\n            centerBrowser: 0, // center window over browser window? {1 (YES) or 0 (NO)}. overrides top and left\n            centerScreen: 0, // center window over entire screen? {1 (YES) or 0 (NO)}. overrides top and left\n            height: 500, // sets the height in pixels of the window.\n            left: 0, // left position when the window appears.\n            location: 0, // determines whether the address bar is displayed {1 (YES) or 0 (NO)}.\n            menubar: 0, // determines whether the menu bar is displayed {1 (YES) or 0 (NO)}.\n            resizable: 0, // whether the window can be resized {1 (YES) or 0 (NO)}. Can also be overloaded using resizable.\n            scrollbars: 0, // determines whether scrollbars appear on the window {1 (YES) or 0 (NO)}.\n            status: 0, // whether a status line appears at the bottom of the window {1 (YES) or 0 (NO)}.\n            width: 500, // sets the width in pixels of the window.\n            windowName: null, // name of window set from the name attribute of the element that invokes the click\n            windowURL: null, // url used for the popup\n            top: 0, // top position when the window appears.\n            toolbar: 0 // determines whether a toolbar (includes the forward and back buttons) is displayed {1 (YES) or 0 (NO)}.\n        },\n\n        _create: function() {\n            this.element.on('click', $.proxy(this._openPopupWindow, this));\n        },\n\n        _openPopupWindow: function(event) {\n            var element = $(event.target),\n                settings = this.options,\n                windowFeatures =\n                    'height=' + settings.height +\n                        ',width=' + settings.width +\n                        ',toolbar=' + settings.toolbar +\n                        ',scrollbars=' + settings.scrollbars +\n                        ',status=' + settings.status +\n                        ',resizable=' + settings.resizable +\n                        ',location=' + settings.location +\n                        ',menuBar=' + settings.menubar,\n                centeredX,\n                centeredY;\n\n            settings.windowName = settings.windowName || element.attr('name');\n            settings.windowURL = settings.windowURL || element.attr('href');\n\n            if (settings.centerBrowser) {\n                if ($.browser.msie) { // Hacked together for IE browsers\n                    centeredY = (window.screenTop - 120) + ((((document.documentElement.clientHeight + 120) / 2) - (settings.height / 2)));\n                    centeredX = window.screenLeft + ((((document.body.offsetWidth + 20) / 2) - (settings.width / 2)));\n                } else {\n                    centeredY = window.screenY + (((window.outerHeight / 2) - (settings.height / 2)));\n                    centeredX = window.screenX + (((window.outerWidth / 2) - (settings.width / 2)));\n                }\n                windowFeatures += ',left=' + centeredX +',top=' + centeredY;\n            } else if (settings.centerScreen) {\n                centeredY = (screen.height - settings.height) / 2;\n                centeredX = (screen.width - settings.width) / 2;\n                windowFeatures += ',left=' + centeredX +',top=' + centeredY;\n            } else {\n                windowFeatures += ',left=' + settings.left +',top=' + settings.top;\n            }\n\n            window.open(settings.windowURL, settings.windowName, windowFeatures).focus();\n            event.preventDefault();\n        }\n    });\n    \n    return $.mage.popupWindow;\n});\n","mage/smart-keyboard-handler.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n],function($){\n    'use strict';\n\n    function KeyboardHandler() {\n        var body = $('body'),\n            focusState = false,\n            tabFocusClass = '_keyfocus',\n            productsGrid = '[data-container=\"product-grid\"]',\n            catalogProductsGrid = $(productsGrid),\n            CODE_TAB = 9;\n\n        return {\n            apply: smartKeyboardFocus\n        };\n\n        /**\n         * Tab key onKeypress handler. Apply main logic:\n         *  - call differ actions onTabKeyPress and onClick\n         */\n        function smartKeyboardFocus() {\n            $(document).on('keydown keypress', function(event) {\n                if (event.which === CODE_TAB && !focusState) {\n                    body\n                        .on('focusin.keyboardHandler', onFocusInHandler)\n                        .on('click', onClickHandler);\n                }\n            });\n\n            // ARIA support for catalog grid products\n            if (catalogProductsGrid.length) {\n                body.on('focusin.gridProducts', productsGrid, function() {\n                    if (body.hasClass(tabFocusClass)) {\n                        $(this).addClass('active');\n                    }\n                });\n                body.on('focusout.gridProducts', productsGrid, function() {\n                    $(this).removeClass('active');\n                });\n            }\n        }\n\n        /**\n         * Handle logic, when onTabKeyPress fired at first.\n         * Then it changes state.\n         */\n        function onFocusInHandler () {\n            focusState = true;\n            $('body').addClass(tabFocusClass)\n                .off('focusin.keyboardHandler', onFocusInHandler);\n        }\n\n        /**\n         * Handle logic to remove state after onTabKeyPress to normal.\n         * @param {Event} event\n         */\n        function onClickHandler(event) {\n            focusState  = false;\n            $('body').removeClass(tabFocusClass)\n                .off('click', onClickHandler);\n        }\n    }\n\n    return new KeyboardHandler;\n});","mage/storage.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(['jquery', 'mage/url'], function ($, urlBuilder) {\n    'use strict';\n\n    return {\n        /**\n         * Perform asynchronous GET request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        get: function (url, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'GET',\n                global: global,\n                contentType: contentType\n            });\n        },\n        /**\n         * Perform asynchronous POST request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        post: function (url, data, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'POST',\n                data: data,\n                global: global,\n                contentType: contentType\n            });\n        },\n        /**\n         * Perform asynchronous PUT request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        put: function(url, data, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'PUT',\n                data: data,\n                global: global,\n                contentType: contentType\n            });\n        },\n        /**\n         * Perform asynchronous DELETE request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        delete: function(url, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'DELETE',\n                global: global,\n                contentType: contentType\n            });\n        }\n    };\n});\n","mage/tabs.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    \"jquery\",\n    \"jquery/ui\",\n    \"mage/mage\",\n    \"mage/collapsible\"\n], function($){\n    \"use strict\";\n        \n    $.widget(\"mage.tabs\", {\n        options: {\n            active: 0,\n            disabled: [],\n            openOnFocus: true,\n            collapsible: false,\n            collapsibleElement: \"[data-role=collapsible]\",\n            header: \"[data-role=title]\",\n            content: \"[data-role=content]\",\n            trigger: \"[data-role=trigger]\",\n            closedState: null,\n            openedState: null,\n            disabledState: null,\n            ajaxUrlElement: \"[data-ajax=true]\",\n            ajaxContent: false,\n            loadingClass: null,\n            saveState: false,\n            animate: false,\n            icons: {\n                activeHeader: null,\n                header: null\n            }\n        },\n\n        _create : function () {\n            if((typeof this.options.disabled) === \"string\") {\n                this.options.disabled = this.options.disabled.split(\" \").map(function(item) {\n                    return parseInt(item, 10);\n                });\n            }\n            this._processPanels();\n\n            this._handleDeepLinking();\n\n            this._processTabIndex();\n\n            this._closeOthers();\n\n            this._bind();\n        },\n\n        _destroy: function() {\n            $.each(this.collapsibles, function() {\n                $(this).collapsible(\"destroy\");\n            });\n        },\n\n        /**\n         * If deep linking is used, all sections must be closed but the one that contains the anchor.\n         * @private\n         */\n        _handleDeepLinking: function() {\n            var self = this,\n                anchor = window.location.hash,\n                isValid = $.mage.isValidSelector(anchor),\n                anchorId = anchor.replace(\"#\",\"\");\n\n            if (anchor && isValid) {\n                $.each(self.contents,function(i) {\n                    if($(this).attr(\"id\") === anchorId) {\n                        self.collapsibles.not(self.collapsibles.eq(i)).collapsible(\"forceDeactivate\");\n                        return false;\n                    }\n                });\n            }\n        },\n\n        /**\n         * When the widget gets instantiated, the first tab that is not disabled receive focusable property\n         * Updated: for accessibility all tabs receive tabIndex 0\n         * @private\n         */\n        _processTabIndex: function() {\n            var self = this;\n            self.triggers.attr(\"tabIndex\",0);\n            $.each(this.collapsibles, function(i) {\n                if(!$(this).collapsible(\"option\",\"disabled\")) {\n                    self.triggers.eq(i).attr(\"tabIndex\", 0);\n                    return false;\n                }\n            });\n            $.each(this.collapsibles, function(i) {\n                $(this).on(\"beforeOpen\", function () {\n                    self.triggers.attr(\"tabIndex\",0);\n                    self.triggers.eq(i).attr(\"tabIndex\",0);\n\n                });\n            });\n        },\n\n        /**\n         * Prepare the elements for instantiating the collapsible widget\n         * @private\n         */\n        _processPanels: function() {\n            this.contents = this.element.find(this.options.content);\n\n            this.collapsibles = this.element.find(this.options.collapsibleElement);\n\n            this.collapsibles\n                .attr('role', 'presentation')\n                .parent()\n                .attr('role', 'tablist');\n\n            this.headers = this.element.find(this.options.header);\n            if (this.headers.length === 0) {\n                this.headers = this.collapsibles;\n            }\n            this.triggers = this.element.find(this.options.trigger);\n            if (this.triggers.length === 0) {\n                this.triggers = this.headers;\n            }\n            this._callCollapsible();\n        },\n\n        /**\n         * Setting the disabled and active tabs and calling instantiation of collapsible\n         * @private\n         */\n        _callCollapsible: function() {\n            var self = this,\n                disabled = false,\n                active = false;\n\n            $.each(this.collapsibles, function(i) {\n                disabled = active = false;\n                if($.inArray(i,self.options.disabled) !== -1) {\n                    disabled = true;\n                }\n                if(i === self.options.active) {\n                    active = true;\n                }\n                self._instantiateCollapsible(this,i,active,disabled);\n            });\n        },\n\n        /**\n         * Instantiate collapsible\n         * @param element\n         * @param index\n         * @param active\n         * @param disabled\n         * @private\n         */\n        _instantiateCollapsible: function(element,index,active,disabled) {\n            $(element).collapsible(\n                $.extend({}, this.options, {\n                    active: active,\n                    disabled: disabled,\n                    header: this.headers.eq(index),\n                    content: this.contents.eq(index),\n                    trigger: this.triggers.eq(index)}\n                ));\n        },\n\n        /**\n         * Adding callback to close others tabs when one gets opened\n         * @private\n         */\n        _closeOthers: function() {\n            var self = this;\n            $.each(this.collapsibles, function() {\n                $(this).on(\"beforeOpen\", function () {\n                    self.collapsibles.not(this).collapsible(\"forceDeactivate\");\n                });\n            });\n        },\n\n        activate: function(index) {\n            this._toggleActivate(\"activate\",index);\n        },\n\n        deactivate: function(index) {\n            this._toggleActivate(\"deactivate\",index);\n        },\n\n        _toggleActivate: function(action,index) {\n            this.collapsibles.eq(index).collapsible(action);\n        },\n\n        disable: function(index) {\n            this._toggleEnable(\"disable\",index);\n        },\n\n        enable: function(index) {\n            this._toggleEnable(\"enable\",index);\n        },\n\n        _toggleEnable: function(action,index) {\n            if($.isArray( index )) {\n                var self = this;\n                $.each(index, function() {\n                    self.collapsibles.eq(this).collapsible(action);\n                });\n            } else if(index === undefined) {\n                this.collapsibles.collapsible(action);\n            } else {\n                this.collapsibles.eq(index).collapsible(action);\n            }\n        },\n\n        _keydown: function( event ) {\n            if ( event.altKey || event.ctrlKey ) {\n                return;\n            }\n            var keyCode = $.ui.keyCode,\n                toFocus = false,\n                toFocusIndex,\n                enabledTriggers = [],\n                length,\n                currentIndex,\n                self = this;\n\n            $.each(this.triggers, function() {\n                if(!self.collapsibles.eq(self.triggers.index($(this))).collapsible(\"option\",\"disabled\")) {\n                    enabledTriggers.push(this);\n                }\n            });\n            length = $(enabledTriggers).length;\n            currentIndex = $(enabledTriggers).index(event.target);\n            var nextToFocus = function(direction) {\n                if(length > 0) {\n                    if(direction === \"right\") {\n                        toFocusIndex = (currentIndex + 1) % length;\n                    } else {\n                        toFocusIndex = (currentIndex + length - 1) % length;\n                    }\n                    return enabledTriggers[toFocusIndex];\n                }\n                else return event.target;\n            };\n\n            switch ( event.keyCode ) {\n                case keyCode.RIGHT:\n                case keyCode.DOWN:\n                    toFocus = nextToFocus(\"right\");\n                    break;\n                case keyCode.LEFT:\n                case keyCode.UP:\n                    toFocus = nextToFocus(\"left\");\n                    break;\n                case keyCode.HOME:\n                    toFocus = enabledTriggers[0];\n                    break;\n                case keyCode.END:\n                    toFocus = enabledTriggers[length - 1];\n                    break;\n            }\n\n            if ( toFocus ) {\n                toFocusIndex = this.triggers.index(toFocus);\n                $( event.target ).attr( \"tabIndex\", -1 );\n                $( toFocus ).attr( \"tabIndex\", 0 );\n                toFocus.focus();\n                if(this.options.openOnFocus) {\n                    this.activate(toFocusIndex);\n                }\n                event.preventDefault();\n            }\n        },\n\n        _bind: function () {\n            var events = {\n                keydown: \"_keydown\"\n            };\n            this._off(this.triggers);\n            this._on(this.triggers, events);\n        }\n    });\n\n    return $.mage.tabs;\n});\n","mage/template.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'underscore'\n        ], factory);\n    } else {\n        root.mageTemplate = factory(root._);\n    }\n}(this, function (_) {\n    'use strict';\n\n    /**\n     * Checks if provided string is a valid DOM selector.\n     *\n     * @param {String} selector - Selector to be checked.\n     * @returns {Boolean}\n     */\n    function isSelector(selector) {\n        try {\n            document.querySelector(selector);\n\n            return true;\n        } catch (e) {\n            return false;\n        }\n    }\n\n    /**\n     * Unescapes characters used in underscore templates.\n     *\n     * @param {String} str - String to be processed.\n     * @returns {String}\n     */\n    function unescape(str) {\n        return str.replace(/&lt;%|%3C%/g, '<%').replace(/%&gt;|%%3E/g, '%>');\n    }\n\n    /**\n     * If 'tmpl' is a valid selector, returns target node's innerHTML if found.\n     * Else, returns empty string and emits console warning.\n     * If 'tmpl' is not a selector, returns 'tmpl' as is.\n     *\n     * @param {String} tmpl\n     * @returns {String}\n     */\n    function getTmplString(tmpl) {\n        if (isSelector(tmpl)) {\n            tmpl = document.querySelector(tmpl);\n\n            if (tmpl) {\n                tmpl = tmpl.innerHTML.trim();\n            } else {\n                console.warn('No template was found by selector: ' + tmpl);\n\n                tmpl = '';\n            }\n        }\n\n        return unescape(tmpl);\n    }\n\n    /**\n     * Compiles or renders template provided either\n     * by selector or by the template string.\n     *\n     * @param {String} tmpl - Template string or selector.\n     * @param {(Object|Array|Function)} [data] - Data object with which to render template.\n     * @returns {String|Function}\n     */\n    return function (tmpl, data) {\n        var render;\n\n        tmpl   = getTmplString(tmpl);\n        render = _.template(tmpl);\n\n        return !_.isUndefined(data) ?\n            render(data) :\n            render;\n    };\n}));\n","mage/translate-inline.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true*/\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"mage/template\",\n            \"jquery/ui\",\n            \"mage/translate\"\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    'use strict';\n\n    $.widget(\"mage.translateInline\", $.ui.dialog, {\n        options: {\n            translateForm: {\n                template: '#translate-form-template',\n                data: {\n                    id: 'translate-inline-form',\n                    message: 'Please refresh the page to see your changes after submitting this form.'\n                }\n            },\n            autoOpen : false,\n            translateArea: null,\n            modal: true,\n            dialogClass: 'popup-window',\n            width: '75%',\n            title: $.mage.__('Translate'),\n            height: 470,\n            position: {\n                my: 'left top',\n                at: 'center top',\n                of: 'body'\n            },\n            buttons: [{\n                text: $.mage.__('Submit'),\n                'class': 'action-primary',\n                click: function(e) {\n                    $(this).translateInline('submit');\n                }\n            },\n            {\n                text: $.mage.__('Close'),\n                'class': 'action-close',\n                click: function() {\n                    $(this).translateInline('close');\n                }\n            }],\n            open: function () {\n                $(this).closest('.ui-dialog').addClass('ui-dialog-active');\n\n                var topMargin = jQuery(this).closest('.ui-dialog').children('.ui-dialog-titlebar').outerHeight() + 45;\n                jQuery(this).closest('.ui-dialog').css('margin-top', topMargin);\n            },\n            close: function () {\n                $(this).closest('.ui-dialog').removeClass('ui-dialog-active');\n            }\n        },\n        /**\n         * Translate Inline creation\n         * @protected\n         */\n        _create: function() {\n            this.tmpl = mageTemplate(this.options.translateForm.template);\n            (this.options.translateArea && $(this.options.translateArea).length ?\n                $(this.options.translateArea) :\n                this.element.closest('body'))\n                    .on('edit.editTrigger', $.proxy(this._onEdit, this));\n            this._super();\n        },\n\n        _prepareContent: function(templateData) {\n            var data = $.extend({\n                items: templateData,\n                escape: $.mage.escapeHTML\n            }, this.options.translateForm.data);\n            this.data = data;\n\n            return $(this.tmpl({\n                data: data\n            }));\n        },\n\n        /**\n         * Render translation form and open dialog\n         * @param {Object} event object\n         * @protected\n         */\n        _onEdit: function(e) {\n            this.target = e.target;\n            this.element.html(this._prepareContent($(e.target).data('translate')));\n            this.open(e);\n        },\n\n        submit: function() {\n            if (this.formIsSubmitted) {\n                return;\n            }\n            this._formSubmit();\n        },\n        /**\n         * Send ajax request on form submit\n         * @protected\n         */\n        _formSubmit: function() {\n            this.formIsSubmitted = true;\n            var parameters = $.param({area: this.options.area}) +\n                '&' + $('#' + this.options.translateForm.data.id).serialize();\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'POST',\n                data: parameters,\n                loaderContext: this.element,\n                showLoader: true\n            }).complete($.proxy(this._formSubmitComplete, this));\n        },\n\n        _formSubmitComplete: function(response) {\n            this.close();\n            this.formIsSubmitted = false;\n            this._updatePlaceholder(response.responseJSON[this.data.items[0]['original']])\n        },\n\n        _updatePlaceholder: function(newValue) {\n            var target = jQuery(this.target);\n            target.data('translate')[0]['shown'] = newValue;\n            target.data('translate')[0]['translated'] = newValue;\n            target.html(newValue);\n        },\n\n        /**\n         * Destroy translateInline\n         */\n        destroy: function() {\n            this.element.off('.editTrigger');\n            this._super();\n        }\n    });\n    /*\n     * @TODO move the \"escapeHTML\" method into the file with global utility functions\n     */\n    $.extend(true, $, {\n        mage: {\n            escapeHTML: function(str) {\n                return str ?\n                    jQuery('<div/>').text(str).html().replace(/\"/g, '&quot;'):\n                    false;\n            }\n        }\n    });\n\n    $.widget('ui.button', $.ui.button, {\n        _create: function () {\n            this._super();\n            /**\n             * Decode HTML entities to prevent incorrect rendering of dialog button label\n             */\n            this.options.label = this.options.label\n                ? jQuery('<div/>').html(this.options.label).text()\n                : this.options.label;\n            /**\n             * Reset button to make decoded label visible\n             */\n            this._resetButton();\n        }\n    });\n\n    $.widget('ui.dialog', $.ui.dialog, {\n        /**\n         * Prevent rendering of dialog title as escaped HTML\n         */\n        _title: function (title) {\n            this._super(title);\n            if (this.options.title) {\n                title.html(this.options.title);\n            }\n        }\n    });\n\n    return $.mage.translateInline;\n}));\n","mage/translate.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint browser:true jquery:true*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"mage/mage\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    $.extend(true, $, {\n        mage: {\n            translate: (function() {\n                /**\n                 * Key-value translations storage\n                 * @type {Object}\n                 * @private\n                 */\n                var _data = {};\n\n                /**\n                 * Add new translation (two string parameters) or several translations (object)\n                 * @param {(Object.<string>|string)}\n                 * @param {string}\n                 */\n                this.add = function() {\n                    if (arguments.length > 1) {\n                        _data[arguments[0]] = arguments[1];\n                    } else if (typeof arguments[0] === 'object') {\n                        $.extend(_data, arguments[0]);\n                    }\n                };\n\n                /**\n                 * Make a translation with parsing (to handle case when _data represents tuple)\n                 * @param {string} text\n                 * @return {string}\n                 */\n                this.translate = function (text) {\n                    return _data[text] ? _data[text] : text;\n                };\n\n                return this;\n            }())\n        }\n    });\n    /**\n     * Sort alias for jQuery.mage.translate.translate method\n     * @type {function(string): string}\n     */\n    $.mage.__ = $.proxy($.mage.translate.translate, $.mage.translate);\n\n    return $.mage.__;\n}));","mage/url.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint regexdash:true eqnull:true browser:true jquery:true*/\ndefine([], function () {\n    var baseUrl = '';\n    return {\n        setBaseUrl: function (url) {\n            baseUrl = url;\n        },\n        build: function(path) {\n            if (path.indexOf(baseUrl) != -1) {\n                return path;\n            }\n            return baseUrl + path;\n        }\n    }\n});\n","mage/validation.js":"/**\n * Copyright \u00c2\u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*jshint regexdash:true eqnull:true browser:true jquery:true*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui',\n            'jquery/validate',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    \"use strict\";\n    $.extend(true, $, {\n        // @TODO: Move methods 'isEmpty', 'isEmptyNoTrim', 'parseNumber', 'stripHtml' in file with utility functions\n        mage: {\n            /**\n             * Check if string is empty with trim\n             * @param {string} value\n             */\n            isEmpty: function (value) {\n                return (value === '' || value === undefined || (value == null) || (value.length === 0) || /^\\s+$/.test(value));\n            },\n\n            /**\n             * Check if string is empty no trim\n             * @param {string} value\n             */\n            isEmptyNoTrim: function (value) {\n                return (value === '' || (value == null) || (value.length === 0));\n            },\n\n\n            /**\n             * Checks if {value} is between numbers {from} and {to}\n             * @param {string} value\n             * @param {string} from\n             * @param {string} to\n             * @returns {boolean}\n             */\n            isBetween: function (value, from, to) {\n                return ($.mage.isEmpty(from) || value >= $.mage.parseNumber(from)) &&\n                    ($.mage.isEmpty(to) || value <= $.mage.parseNumber(to));\n            },\n\n            /**\n             * Parse price string\n             * @param {string} value\n             */\n            parseNumber: function (value) {\n                if (typeof value !== 'string') {\n                    return parseFloat(value);\n                }\n                var isDot = value.indexOf('.');\n                var isComa = value.indexOf(',');\n                if (isDot !== -1 && isComa !== -1) {\n                    if (isComa > isDot) {\n                        value = value.replace('.', '').replace(',', '.');\n                    } else {\n                        value = value.replace(',', '');\n                    }\n                } else if (isComa !== -1) {\n                    value = value.replace(',', '.');\n                }\n                return parseFloat(value);\n            },\n\n            /**\n             * Removes HTML tags and space characters, numbers and punctuation.\n             * @param value Value being stripped.\n             * @return {*}\n             */\n            stripHtml: function (value) {\n                return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                    .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n            }\n        }\n    });\n\n    $.validator.addMethod = function (name, method, message, dontSkip) {\n        $.validator.methods[name] = method;\n        $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];\n\n        if (method.length < 3 || dontSkip) {\n            $.validator.addClassRules(name, $.validator.normalizeRule(name));\n        }\n    };\n\n    /**\n     * Javascript object with credit card types\n     * 0 - regexp for card number\n     * 1 - regexp for cvn\n     * 2 - check or not credit card number trough Luhn algorithm by\n     */\n    var creditCartTypes = {\n        'SO': [new RegExp('^(6334[5-9]([0-9]{11}|[0-9]{13,14}))|(6767([0-9]{12}|[0-9]{14,15}))$'), new RegExp('^([0-9]{3}|[0-9]{4})?$'), true],\n        'SM': [new RegExp('(^(5[0678])[0-9]{11,18}$)|(^(6[^05])[0-9]{11,18}$)|(^(601)[^1][0-9]{9,16}$)|(^(6011)[0-9]{9,11}$)|(^(6011)[0-9]{13,16}$)|(^(65)[0-9]{11,13}$)|(^(65)[0-9]{15,18}$)|(^(49030)[2-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49033)[5-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49110)[1-2]([0-9]{10}$|[0-9]{12,13}$))|(^(49117)[4-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49118)[0-2]([0-9]{10}$|[0-9]{12,13}$))|(^(4936)([0-9]{12}$|[0-9]{14,15}$))'), new RegExp('^([0-9]{3}|[0-9]{4})?$'), true],\n        'VI': [new RegExp('^4[0-9]{12}([0-9]{3})?$'), new RegExp('^[0-9]{3}$'), true],\n        'MC': [new RegExp('^5[1-5][0-9]{14}$'), new RegExp('^[0-9]{3}$'), true],\n        'AE': [new RegExp('^3[47][0-9]{13}$'), new RegExp('^[0-9]{4}$'), true],\n        'DI': [new RegExp('^(30[0-5][0-9]{13}|3095[0-9]{12}|35(2[8-9][0-9]{12}|[3-8][0-9]{13})|36[0-9]{12}|3[8-9][0-9]{14}|6011(0[0-9]{11}|[2-4][0-9]{11}|74[0-9]{10}|7[7-9][0-9]{10}|8[6-9][0-9]{10}|9[0-9]{11})|62(2(12[6-9][0-9]{10}|1[3-9][0-9]{11}|[2-8][0-9]{12}|9[0-1][0-9]{11}|92[0-5][0-9]{10})|[4-6][0-9]{13}|8[2-8][0-9]{12})|6(4[4-9][0-9]{13}|5[0-9]{14}))$'), new RegExp('^[0-9]{3}$'), true],\n        'JCB': [new RegExp('^(30[0-5][0-9]{13}|3095[0-9]{12}|35(2[8-9][0-9]{12}|[3-8][0-9]{13})|36[0-9]{12}|3[8-9][0-9]{14}|6011(0[0-9]{11}|[2-4][0-9]{11}|74[0-9]{10}|7[7-9][0-9]{10}|8[6-9][0-9]{10}|9[0-9]{11})|62(2(12[6-9][0-9]{10}|1[3-9][0-9]{11}|[2-8][0-9]{12}|9[0-1][0-9]{11}|92[0-5][0-9]{10})|[4-6][0-9]{13}|8[2-8][0-9]{12})|6(4[4-9][0-9]{13}|5[0-9]{14}))$'), new RegExp('^[0-9]{3}$'), true],\n        'OT': [new RegExp('^([0-9]+)$'), new RegExp('^([0-9]{3}|[0-9]{4})?$'), false],\n        'DN': [new RegExp('^3((0([0-5]\\\\d*)?)|[689]\\\\d*)?$'), new RegExp('^[0-9]{3}$'), true],\n        'UN': [new RegExp('^6(2\\\\d*)?$'), new RegExp('^[0-9]{3}$'), true],\n        'MI': [new RegExp('^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'MD': [new RegExp('^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$'), new RegExp('^[0-9]{3}$'), true]\n    };\n\n    /**\n     * validate credit card number using mod10\n     * @param s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = \"0123456789\",\n            w = \"\", i, j, k, m, c, a, x;\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n            if (v.indexOf(x, 0) != -1)\n                w += x;\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n        return (c % 10 === 0);\n    }\n\n    /**\n     * validate all table required inputs at once, using single hidden input\n     * @param {String} value\n     * @param {HTMLElement} element\n     *\n     * @return {Boolean}\n     */\n    function tableSingleValidation(value, element) {\n        var empty = $(element).closest('table')\n            .find('input.required-option:visible')\n            .filter(function (i, el) {\n                return $.mage.isEmpty(el.value);\n            })\n            .length;\n        return empty === 0;\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    var rules = {\n        \"max-words\": [\n            function (value, element, params) {\n                return this.optional(element) || $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length < params;\n            },\n            'Please enter {0} words or less.'\n        ],\n        \"min-words\": [\n            function (value, element, params) {\n                return this.optional(element) || $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            'Please enter at least {0} words.'\n        ],\n        \"range-words\": [\n            function (value, element, params) {\n                return this.optional(element) ||\n                    $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length >= params[0] &&\n                    value.match(/bw+b/g).length < params[1];\n            },\n            'Please enter between {0} and {1} words.'\n        ],\n        \"letters-with-basic-punc\": [\n            function (value, element) {\n                return this.optional(element) || /^[a-z\\-.,()'\\\"\\s]+$/i.test(value);\n            },\n            'Letters or punctuation only please'\n        ],\n        \"alphanumeric\": [\n            function (value, element) {\n                return this.optional(element) || /^\\w+$/i.test(value);\n            },\n            'Letters, numbers, spaces or underscores only please'\n        ],\n        \"letters-only\": [\n            function (value, element) {\n                return this.optional(element) || /^[a-z]+$/i.test(value);\n            },\n            'Letters only please'\n        ],\n        \"no-whitespace\": [\n            function (value, element) {\n                return this.optional(element) || /^\\S+$/i.test(value);\n            },\n            'No white space please'\n        ],\n        \"zip-range\": [\n            function (value, element) {\n                return this.optional(element) || /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            'Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx'\n        ],\n        \"integer\": [\n            function (value, element) {\n                return this.optional(element) || /^-?\\d+$/.test(value);\n            },\n            'A positive or negative non-decimal number please'\n        ],\n        \"vinUS\": [\n            function (v) {\n                if (v.length !== 17) {\n                    return false;\n                }\n                var i, n, d, f, cd, cdv;\n                var LL = [\"A\", \"B\", \"C\", \"D\", \"E\", \"F\", \"G\", \"H\", \"J\", \"K\", \"L\", \"M\", \"N\", \"P\", \"R\", \"S\", \"T\", \"U\", \"V\", \"W\", \"X\", \"Y\", \"Z\"];\n                var VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9];\n                var FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2];\n                var rs = 0;\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = v.slice(i, i + 1);\n                    if (i === 8) {\n                        cdv = d;\n                    }\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {\n                            if (d.toUpperCase() === LL[n]) {\n                                d = VL[n];\n                                d *= f;\n                                if (isNaN(cdv) && n === 8) {\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n                cd = rs % 11;\n                if (cd === 10) {\n                    cd = \"X\";\n                }\n                if (cd === cdv) {\n                    return true;\n                }\n                return false;\n            },\n            'The specified vehicle identification number (VIN) is invalid.'\n        ],\n        \"dateITA\": [\n            function (value, element) {\n                var check = false;\n                var re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/;\n                if (re.test(value)) {\n                    var adata = value.split('/');\n                    var gg = parseInt(adata[0], 10);\n                    var mm = parseInt(adata[1], 10);\n                    var aaaa = parseInt(adata[2], 10);\n                    var xdata = new Date(aaaa, mm - 1, gg);\n                    if ((xdata.getFullYear() === aaaa) &&\n                        (xdata.getMonth() === mm - 1) && (xdata.getDate() === gg )) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n                return this.optional(element) || check;\n            },\n            'Please enter a correct date'\n        ],\n        \"dateNL\": [\n            function (value, element) {\n                return this.optional(element) || /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            'Vul hier een geldige datum in.'\n        ],\n        \"time\": [\n            function (value, element) {\n                return this.optional(element) || /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            'Please enter a valid time, between 00:00 and 23:59'\n        ],\n        \"time12h\": [\n            function (value, element) {\n                return this.optional(element) || /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\ [AP]M))$/i.test(value);\n            },\n            'Please enter a valid time, between 00:00 am and 12:00 pm'\n        ],\n        \"phoneUS\": [\n            function (phone_number, element) {\n                phone_number = phone_number.replace(/\\s+/g, \"\");\n                return this.optional(element) || phone_number.length > 9 &&\n                    phone_number.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            'Please specify a valid phone number'\n        ],\n        \"phoneUK\": [\n            function (phone_number, element) {\n                return this.optional(element) || phone_number.length > 9 &&\n                    phone_number.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            'Please specify a valid phone number'\n        ],\n        \"mobileUK\": [\n            function (phone_number, element) {\n                return this.optional(element) || phone_number.length > 9 &&\n                    phone_number.match(/^((0|\\+44)7(5|6|7|8|9){1}\\d{2}\\s?\\d{6})$/);\n            },\n            'Please specify a valid mobile number'\n        ],\n        \"stripped-min-length\": [\n            function (value, element, param) {\n                return $(value).text().length >= param;\n            },\n            'Please enter at least {0} characters'\n        ],\n        \"email2\": [\n            function (value, element) {\n                return this.optional(element) || /^((([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\x22)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\x22)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);\n            },\n            $.validator.messages.email\n        ],\n        \"url2\": [\n            function (value, element) {\n                return this.optional(element) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);\n            },\n            $.validator.messages.url\n        ],\n        \"credit-card-types\": [\n            function (value, element, param) {\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, \"\");\n\n                var validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n                return false;\n            },\n            'Please enter a valid credit card number.'\n        ],\n        \"ipv4\": [\n            function (value, element) {\n                return this.optional(element) || /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);\n            },\n            'Please enter a valid IP v4 address.'\n        ],\n        \"ipv6\": [\n            function (value, element) {\n                return this.optional(element) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);\n            },\n            'Please enter a valid IP v6 address.'\n        ],\n        \"pattern\": [\n            function (value, element, param) {\n                return this.optional(element) || param.test(value);\n            },\n            'Invalid format.'\n        ],\n        \"allow-container-className\": [\n            function (element) {\n                if (element.type === 'radio' || element.type === 'checkbox') {\n                    return $(element).hasClass('change-container-classname');\n                }\n            },\n            ''\n        ],\n        \"validate-no-html-tags\": [\n            function (value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            'HTML tags are not allowed.'\n        ],\n        \"validate-select\": [\n            function (value) {\n                return ((value !== \"none\") && (value != null) && (value.length !== 0));\n            },\n            'Please select an option.'\n        ],\n        \"validate-no-empty\": [\n            function (value) {\n                return !$.mage.isEmpty(value);\n            },\n            'Empty Value.'\n        ],\n        \"validate-alphanum-with-spaces\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z0-9 ]+$/.test(v);\n            },\n            'Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.'\n        ],\n        \"validate-data\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(v);\n            },\n            'Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.'\n        ],\n        \"validate-street\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(v);\n            },\n            'Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.'\n        ],\n        \"validate-phoneStrict\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(v);\n            },\n            'Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.'\n        ],\n        \"validate-phoneLax\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(v);\n            },\n            'Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.'\n        ],\n        \"validate-fax\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(v);\n            },\n            'Please enter a valid fax number (Ex: 123-456-7890).'\n        ],\n        \"validate-email\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(v);\n            },\n            'Please enter a valid email address (Ex: johndoe@domain.com).'\n        ],\n        \"validate-emailSender\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[\\S ]+$/.test(v);\n            },\n            'Please enter a valid email address (Ex: johndoe@domain.com).'\n        ],\n        \"validate-password\": [\n            function (v) {\n                if (v == null) {\n                    return false;\n                }\n                /*strip leading and trailing spaces*/\n                var pass = $.trim(v);\n                if (!pass.length) {\n                    return true;\n                }\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            'Please enter 6 or more characters. Leading and trailing spaces will be ignored.'\n        ],\n        \"validate-admin-password\": [\n            function (v) {\n                if (v == null) {\n                    return false;\n                }\n                var pass = $.trim(v);\n                /*strip leading and trailing spaces*/\n                if (0 === pass.length) {\n                    return true;\n                }\n                if (!(/[a-z]/i.test(v)) || !(/[0-9]/.test(v))) {\n                    return false;\n                }\n                if (pass.length < 7) {\n                    return false;\n                }\n                return true;\n            },\n            'Please enter 7 or more characters, using both numeric and alphabetic.'\n        ],\n        \"validate-customer-password\": [\n            function (v, elm) {\n                var validator = this,\n                    length = 0,\n                    counter = 0;\n                var passwordMinLength = $(elm).data('password-min-length');\n                var passwordMinCharacterSets = $(elm).data('password-min-character-sets');\n                var pass = $.trim(v);\n                var result = pass.length >= passwordMinLength;\n                if (result == false) {\n                    validator.passwordErrorMessage = $.mage.__(\n                        \"Minimum length of this field must be equal or greater than %1 symbols.\" +\n                        \" Leading and trailing spaces will be ignored.\"\n                    ).replace('%1', passwordMinLength);\n                    return result;\n                }\n                if (pass.match(/\\d+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[a-z]+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[A-Z]+/)) {\n                    counter ++;\n                }\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter ++;\n                }\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__(\n                        \"Minimum of different classes of characters in password is %1.\" +\n                        \" Classes of characters: Lower Case, Upper Case, Digits, Special Characters.\"\n                    ).replace('%1', passwordMinCharacterSets);\n                }\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        \"validate-url\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = (v || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(v);\n\n            },\n            'Please enter a valid URL. Protocol is required (http://, https:// or ftp://).'\n        ],\n        \"validate-clean-url\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v);\n\n            },\n            'Please enter a valid URL. For example http://www.example.com or www.example.com.'\n        ],\n        \"validate-xml-identifier\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(v);\n\n            },\n            'Please enter a valid XML-identifier (Ex: something_1, block5, id-4).'\n        ],\n        \"validate-ssn\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(v);\n\n            },\n            'Please enter a valid social security number (Ex: 123-45-6789).'\n        ],\n        \"validate-zip-us\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(v);\n\n            },\n            'Please enter a valid zip code (Ex: 90602 or 90602-1234).'\n        ],\n        \"validate-date-au\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                var regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/;\n                if ($.mage.isEmpty(v) || !regex.test(v)) {\n                    return false;\n                }\n                var d = new Date(v.replace(regex, '$2/$1/$3'));\n                return parseInt(RegExp.$2, 10) === (1 + d.getMonth()) &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            'Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.'\n        ],\n        \"validate-currency-dollar\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(v);\n\n            },\n            'Please enter a valid $ amount. For example $100.00.'\n        ],\n        \"validate-not-negative-number\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n                return !isNaN(v) && v >= 0;\n\n            },\n            'Please enter a number 0 or greater in this field.'\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        \"validate-zero-or-greater\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n                return !isNaN(v) && v >= 0;\n\n            },\n            'Please enter a number 0 or greater in this field.'\n        ],\n        \"validate-greater-than-zero\": [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n                return !isNaN(v) && v > 0;\n            },\n            'Please enter a number greater than 0 in this field.'\n        ],\n        \"validate-css-length\": [\n            function (v) {\n                if (v !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(v);\n                }\n                return true;\n            },\n            'Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).'\n        ],\n        /** @description Additional methods */\n        \"validate-number\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || (!isNaN($.mage.parseNumber(v)) && /^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(v));\n            },\n            'Please enter a valid number in this field.'\n        ],\n        \"required-number\": [\n            function (v) {\n                return !!v.length;\n            },\n            'Please enter a valid number in this field.'\n        ],\n        \"validate-number-range\": [\n            function (v, elm, param) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                var numValue = $.mage.parseNumber(v);\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                var dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/,\n                    classNameRange = /^number-range-(-?[\\d.,]+)?-(-?[\\d.,]+)?$/,\n                    result = true,\n                    range, m, classes, ii;\n\n                range = param;\n                if (typeof range === 'object') {\n                    m = dataAttrRange.exec(range);\n                    if (m) {\n                        result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                    }\n                } else if (elm && elm.className) {\n                    classes = elm.className.split(\" \");\n                    ii = classes.length;\n\n                    while (ii--) {\n                        range = classes[ii];\n                        m = classNameRange.exec(range);\n                        if (m) {\n                            result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                            break;\n                        }\n                    }\n                }\n\n                return result;\n            },\n            'The value is not within the specified range.',\n            true\n        ],\n        \"validate-digits\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || !/[^\\d]/.test(v);\n            },\n            'Please enter a valid number in this field.'\n        ],\n        \"validate-digits-range\": [\n            function (v, elm, param) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                var numValue = $.mage.parseNumber(v);\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                var dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/,\n                    classNameRange = /^digits-range-(-?\\d+)?-(-?\\d+)?$/,\n                    result = true,\n                    range, m, classes, ii;\n                range = param;\n\n                if (typeof range === 'object') {\n                    m = dataAttrRange.exec(range);\n                    if (m) {\n                        result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                    }\n                } else if (elm && elm.className) {\n                    classes = elm.className.split(\" \");\n                    ii = classes.length;\n\n                    while (ii--) {\n                        range = classes[ii];\n                        m = classNameRange.exec(range);\n                        if (m) {\n                            result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                            break;\n                        }\n                    }\n                }\n\n                return result;\n            },\n            'The value is not within the specified range.',\n            true\n        ],\n        'validate-range': [\n            function (v, elm) {\n                var minValue, maxValue;\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](v)) {\n                    minValue = maxValue = $.mage.parseNumber(v);\n                } else {\n                    var ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(v);\n\n                    if (ranges) {\n                        minValue = $.mage.parseNumber(ranges[1]);\n                        maxValue = $.mage.parseNumber(ranges[2]);\n                        if (minValue > maxValue) {\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n                var reRange = /^range-(-?\\d+)?-(-?\\d+)?$/,\n                    result = true;\n\n                var values = $(elm).prop('class').split(\" \");\n\n                for (var i = values.length - 1; i >= 0; i--) {\n                    var name = values[i];\n                    var validRange = reRange.exec(name);\n                    if (validRange) {\n                        var minValidRange = $.mage.parseNumber(validRange[1]);\n                        var maxValidRange = $.mage.parseNumber(validRange[2]);\n                        result = result &&\n                        (isNaN(minValidRange) || minValue >= minValidRange) &&\n                        (isNaN(maxValidRange) || maxValue <= maxValidRange);\n                    }\n                }\n                return result;\n            },\n            'The value is not within the specified range.'\n        ],\n        \"validate-alpha\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z]+$/.test(v);\n            },\n            'Please use letters only (a-z or A-Z) in this field.'\n        ],\n        \"validate-code\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-z]+[a-z0-9_]+$/.test(v);\n            },\n            'Please use only letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.'\n        ],\n        \"validate-alphanum\": [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z0-9]+$/.test(v);\n            },\n            'Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.'\n        ],\n        \"validate-date\": [\n            function (v) {\n                var test = new Date(v);\n                return $.mage.isEmptyNoTrim(v) || !isNaN(test);\n            }, 'Please enter a valid date.'\n\n        ],\n        \"validate-date-range\": [\n            function (v, elm) {\n                var m = /\\bdate-range-(\\w+)-(\\w+)\\b/.exec(elm.className);\n                if (!m || m[2] === 'to' || $.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                var currentYear = new Date().getFullYear() + '';\n                var normalizedTime = function (v) {\n                    v = v.split(/[.\\/]/);\n                    if (v[2] && v[2].length < 4) {\n                        v[2] = currentYear.substr(0, v[2].length) + v[2];\n                    }\n                    return new Date(v.join('/')).getTime();\n                };\n\n                var dependentElements = $(elm.form).find('.validate-date-range.date-range-' + m[1] + '-to');\n                return !dependentElements.length || $.mage.isEmptyNoTrim(dependentElements[0].value) ||\n                    normalizedTime(v) <= normalizedTime(dependentElements[0].value);\n            },\n            'Make sure the To Date is later than or the same as the From Date.'\n        ],\n        \"validate-cpassword\": [\n            function () {\n                var conf = $('#confirmation').length > 0 ? $('#confirmation') : $($('.validate-cpassword')[0]);\n                var pass = false;\n                if ($('#password')) {\n                    pass = $('#password');\n                }\n                var passwordElements = $('.validate-password');\n                for (var i = 0; i < passwordElements.length; i++) {\n                    var passwordElement = $(passwordElements[i]);\n                    if (passwordElement.closest('form').attr('id') === conf.closest('form').attr('id')) {\n                        pass = passwordElement;\n    