-- Magento DB backup
--
-- Host: localhost    Database: ma_thebell
-- ------------------------------------------------------
-- Server version: 10.1.13-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_passwords`
--

DROP TABLE IF EXISTS `admin_passwords`;
CREATE TABLE `admin_passwords` (
  `password_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password Id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User Id',
  `password_hash` varchar(100) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Expires',
  `last_updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `ADMIN_PASSWORDS_USER_ID` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin Passwords';

--
-- Table structure for table `admin_system_messages`
--

DROP TABLE IF EXISTS `admin_system_messages`;
CREATE TABLE `admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message id',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin System Messages';

--
-- Dumping data for table `admin_system_messages`
--

LOCK TABLES `admin_system_messages` WRITE;
/*!40000 ALTER TABLE `admin_system_messages` DISABLE KEYS */;
INSERT INTO `admin_system_messages` VALUES ('da332d712f3215b9b94bfa268c398323',2,'2016-12-11 08:40:27');
/*!40000 ALTER TABLE `admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
CREATE TABLE `admin_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint(6) DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin User Table';

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
INSERT INTO `admin_user` VALUES ('1','admin','admin','demo@plazathemes.com','admin','b91a107811921dc9295a5b2597589c8917146945e7024b8a977f0109272adfd3:sSykJQJOIAnToiPZyX10UziwRwhFtqW0:1','2016-07-18 04:13:49','2016-12-26 04:14:00','2016-12-26 04:14:00',97,0,1,'a:1:{s:11:\"configState\";a:51:{s:11:\"web_default\";s:1:\"1\";s:7:\"web_url\";s:1:\"1\";s:7:\"web_seo\";s:1:\"0\";s:12:\"web_unsecure\";s:1:\"0\";s:10:\"web_secure\";s:1:\"0\";s:10:\"web_cookie\";s:1:\"0\";s:11:\"web_session\";s:1:\"0\";s:24:\"web_browser_capabilities\";s:1:\"0\";s:9:\"admin_url\";s:1:\"0\";s:13:\"admin_startup\";s:1:\"0\";s:14:\"admin_security\";s:1:\"1\";s:12:\"admin_emails\";s:1:\"0\";s:15:\"admin_dashboard\";s:1:\"0\";s:13:\"admin_captcha\";s:1:\"0\";s:16:\"currency_options\";s:1:\"1\";s:21:\"currency_yahoofinance\";s:1:\"0\";s:16:\"currency_fixerio\";s:1:\"0\";s:20:\"currency_webservicex\";s:1:\"0\";s:15:\"currency_import\";s:1:\"0\";s:19:\"brandslider_general\";s:1:\"1\";s:16:\"catalog_frontend\";s:1:\"1\";s:14:\"catalog_review\";s:1:\"0\";s:20:\"catalog_productalert\";s:1:\"0\";s:19:\"catalog_placeholder\";s:1:\"0\";s:21:\"catalog_product_video\";s:1:\"0\";s:25:\"catalog_recently_products\";s:1:\"0\";s:26:\"catalog_layered_navigation\";s:1:\"0\";s:11:\"catalog_seo\";s:1:\"0\";s:14:\"catalog_search\";s:1:\"0\";s:20:\"catalog_downloadable\";s:1:\"0\";s:22:\"catalog_custom_options\";s:1:\"0\";s:24:\"newproductslider_general\";s:1:\"1\";s:27:\"recentproductslider_general\";s:1:\"1\";s:28:\"bestsellerproduct_new_status\";s:1:\"1\";s:31:\"featureproductslider_new_status\";s:1:\"1\";s:19:\"testimonial_general\";s:1:\"1\";s:27:\"randomproductslider_general\";s:1:\"1\";s:22:\"categorytab_new_status\";s:1:\"1\";s:14:\"mfblog_general\";s:1:\"1\";s:17:\"mfblog_index_page\";s:1:\"1\";s:16:\"mfblog_post_view\";s:1:\"1\";s:16:\"mfblog_post_list\";s:1:\"1\";s:14:\"mfblog_sidebar\";s:1:\"1\";s:15:\"mfblog_rss_feed\";s:1:\"1\";s:24:\"instagramgallery_general\";s:1:\"1\";s:27:\"newsletterpopup_popup_group\";s:1:\"1\";s:20:\"catalog_fields_masks\";s:1:\"0\";s:25:\"catalog_productalert_cron\";s:1:\"0\";s:13:\"catalog_price\";s:1:\"0\";s:18:\"catalog_navigation\";s:1:\"0\";s:22:\"categorytop_new_status\";s:1:\"1\";}}',NULL,NULL,'en_US',0,NULL,NULL);
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_session`
--

DROP TABLE IF EXISTS `admin_user_session`;
CREATE TABLE `admin_user_session` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(128) NOT NULL COMMENT 'Session id value',
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `ADMIN_USER_SESSION_USER_ID` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8 COMMENT='Admin User sessions table';

--
-- Dumping data for table `admin_user_session`
--

LOCK TABLES `admin_user_session` WRITE;
/*!40000 ALTER TABLE `admin_user_session` DISABLE KEYS */;
INSERT INTO `admin_user_session` VALUES ('1','16bdfrca1ugu5n8llk7209bi72','1',2,'2016-07-18 04:18:35','2016-08-30 09:39:11','127.0.0.1'),('2','78f91r2h4f7io9r2plj0euhjr2','1',2,'2016-07-18 06:19:21','2016-08-30 09:39:11','127.0.0.1'),('3','jr0dajej5q9fre3vhvrc7trmn7','1',2,'2016-07-18 07:02:00','2016-08-30 09:39:11','127.0.0.1'),('4','d36a73agobpgflk2ettkuo51r7','1',2,'2016-07-18 07:28:55','2016-08-30 09:39:11','127.0.0.1'),('5','7nqle8usa38nngt8temns94rc0','1',2,'2016-07-18 08:05:32','2016-08-30 09:39:11','127.0.0.1'),('6','psgssqhhjt9f9anakdjse189p5','1',2,'2016-07-18 09:01:39','2016-08-30 09:39:11','127.0.0.1'),('7','vifbc6rpk7mlncpvctmuevido6','1',2,'2016-07-19 01:45:43','2016-08-30 09:39:11','127.0.0.1'),('8','7ed5l7sqkuifkbicvrl9g3dde3','1',2,'2016-07-19 02:02:50','2016-08-30 09:39:11','127.0.0.1'),('9','b29v6i5q80c1heni7b6hggefu3','1',2,'2016-07-20 01:28:06','2016-08-30 09:39:11','127.0.0.1'),('10','2ko814rpuem0lklcnl2f325nn3','1',2,'2016-07-20 06:36:12','2016-08-30 09:39:11','127.0.0.1'),('11','gh32754ol791lmcelgqne47mo2','1',2,'2016-07-21 01:27:38','2016-08-30 09:39:11','127.0.0.1'),('12','riq3klbggn55nls200fq7lqj80','1',2,'2016-07-21 02:43:45','2016-08-30 09:39:11','127.0.0.1'),('13','gg1e65or3qjm8bqeg4a7ege8v3','1',2,'2016-07-21 06:38:34','2016-08-30 09:39:11','127.0.0.1'),('14','hhf277e3amk8ma5nvtc539bru2','1',2,'2016-07-21 09:42:02','2016-08-30 09:39:11','127.0.0.1'),('15','q5kah092bm5hluf9ljk5j6stf3','1',2,'2016-07-21 14:29:55','2016-07-21 14:30:04','127.0.0.1'),('16','u7p88pn47ls58too6uknt721e5','1',2,'2016-07-21 14:30:03','2016-08-30 09:39:11','127.0.0.1'),('17','95fuk9acc7ldhfasp3grb21nj3','1',2,'2016-07-22 01:26:39','2016-08-30 09:39:11','127.0.0.1'),('18','hldjpdmjplb95cr3a1kp8jhke6','1',2,'2016-07-22 02:37:09','2016-08-30 09:39:11','127.0.0.1'),('19','fn7lgbagfq82715bas3glbupq3','1',2,'2016-08-29 10:33:51','2016-08-30 09:39:11','127.0.0.1'),('20','541jlgk6t23hfadqgm91jijfk4','1',2,'2016-08-29 11:17:31','2016-08-30 09:39:11','127.0.0.1'),('21','mkhapq39m85cupmh4rlvlig9p0','1',2,'2016-08-29 13:30:24','2016-08-30 09:39:11','127.0.0.1'),('22','2qd20jar7cuakprpa3ht1nt7t7','1',2,'2016-08-29 14:37:29','2016-08-30 09:39:11','127.0.0.1'),('23','j2t8j14ibf4e7sba6btsaus3d4','1',2,'2016-08-30 09:39:11','2016-08-30 17:07:47','127.0.0.1'),('24','nt4knokti6ij83etuns3jcgfu2','1',2,'2016-08-30 17:07:47','2016-08-31 09:36:15','127.0.0.1'),('25','m9imu6s5e89h6edr698cbnpc26','1',2,'2016-08-31 09:36:15','2016-08-31 14:30:29','127.0.0.1'),('26','demgc32blh1ti4icjmqp7m2qr3','1',2,'2016-08-31 14:30:29','2016-09-01 10:10:35','127.0.0.1'),('27','ka7j2364btkqgf3akhivd8klf3','1',2,'2016-09-01 10:10:35','2016-09-01 13:43:44','127.0.0.1'),('28','ljbkb7737jat7d182ut226j8v7','1',2,'2016-09-01 13:43:44','2016-09-05 09:18:53','127.0.0.1'),('29','kntl8uaeueja2js603217knfd7','1',2,'2016-09-05 09:18:53','2016-09-05 14:41:25','127.0.0.1'),('30','g0dmgchva09i3vntbbbcp27416','1',2,'2016-09-05 14:41:25','2016-09-05 15:44:39','127.0.0.1'),('31','eofcentbt1ldfecemcoberp4g2','1',2,'2016-09-05 15:44:39','2016-09-05 17:05:29','127.0.0.1'),('32','20iaso35gb4fnuu3m1tko5r567','1',2,'2016-09-05 17:05:29','2016-09-06 10:46:50','127.0.0.1'),('33','kj981d3bjtt01mth7516jajm25','1',2,'2016-09-06 10:46:50','2016-09-07 09:01:34','127.0.0.1'),('34','vj0thqie2cr1uu3ef2li1m83u3','1',2,'2016-09-07 09:01:34','2016-09-07 15:11:39','127.0.0.1'),('35','5agdketn3hn8qqcdq5ghjdbao0','1',2,'2016-09-07 15:11:39','2016-09-08 09:21:19','127.0.0.1'),('36','c0svb8lgm2qnr4pl0f5af4c884','1',2,'2016-09-08 09:21:19','2016-09-08 15:05:34','127.0.0.1'),('37','68dcs61d4k7mbajopp1f1ng676','1',2,'2016-09-08 15:05:34','2016-09-10 08:27:32','127.0.0.1'),('38','g6kj0uvs53r5gs2e79mvv4m3v1','1',2,'2016-09-10 08:27:32','2016-09-10 16:08:00','127.0.0.1'),('39','ic491l3ioduel77ndep3eorkq3','1',2,'2016-09-10 16:08:00','2016-09-12 08:42:59','127.0.0.1'),('40','5t07r5dmlheg4ghs706vqc8634','1',2,'2016-09-12 08:42:59','2016-09-12 14:29:20','127.0.0.1'),('41','7n3j7qnp74eeetful1q27nkar2','1',2,'2016-09-12 14:29:20','2016-09-13 08:46:58','127.0.0.1'),('42','tmlvko9apvr7alv84ql9nbsa64','1',2,'2016-09-13 08:46:58','2016-09-14 08:41:04','127.0.0.1'),('43','kbauou4o6rmuueg25hh6ad2051','1',2,'2016-09-14 08:41:04','2016-09-15 09:35:43','127.0.0.1'),('44','oltbtsd929unna51b08k1rr7l1','1',2,'2016-09-15 09:35:43','2016-09-15 15:21:00','127.0.0.1'),('45','97neji2u2c6v9qne5eo3kbmh41','1',2,'2016-09-15 15:21:00','2016-09-16 09:40:00','127.0.0.1'),('46','i12ftaq8roh2m1gi8ef06pp577','1',2,'2016-09-16 09:40:00','2016-09-19 08:27:30','127.0.0.1'),('47','ea0i20biv575029etvu8t2cg73','1',2,'2016-09-19 08:27:30','2016-09-19 14:56:34','127.0.0.1'),('48','uvm6ghdei5bhck5si5j7e7u9l1','1',2,'2016-09-19 14:56:34','2016-11-08 15:06:23','127.0.0.1'),('49','i6b3a4ueunu56gkqur7gbbupg6','1',2,'2016-11-08 15:06:23','2016-11-09 13:00:37','127.0.0.1'),('50','32143kb6dtihcsck43kqc6mvi5','1',2,'2016-11-09 13:00:37','2016-11-10 13:59:11','127.0.0.1'),('51','j9419rmrj9hg6fokcrg3l3l4p6','1',2,'2016-11-10 13:59:11','2016-11-10 13:59:34','127.0.0.1'),('52','6bh5pr73q3qj9vqgq9ssaae6l4','1',2,'2016-11-10 13:59:34','2016-11-16 14:20:21','127.0.0.1'),('53','v6v0ql1vkb5gjv9tbl5o6qttl7','1',2,'2016-11-16 14:20:21','2016-11-17 14:01:18','127.0.0.1'),('54','qs4mp7823nlh9otu7adprvgrb4','1',2,'2016-11-17 14:01:18','2016-11-24 14:30:18','127.0.0.1'),('55','u0ggqgqn1heusb4ad3ofoiq1a3','1',2,'2016-11-24 14:30:18','2016-11-24 15:12:57','127.0.0.1'),('56','8t7cace9grb88gnpp77l0cmuj7','1',2,'2016-11-24 15:12:57','2016-11-27 01:12:37','127.0.0.1'),('57','r2i4h68r916hukpvcb3qgn5vp5','1',2,'2016-11-27 01:12:37','2016-11-27 08:29:05','127.0.0.1'),('58','ea44qprogdbbpcu39iv1u6k7q2','1',2,'2016-11-27 08:29:05','2016-11-29 09:35:32','127.0.0.1'),('59','jovratdc49lpllf5011cq7bmc6','1',2,'2016-11-29 09:35:32','2016-11-29 14:47:50','127.0.0.1'),('60','iqfsl1fmk4jgtm0k2c4tnk7uh1','1',2,'2016-11-29 14:47:50','2016-11-30 01:29:14','127.0.0.1'),('61','vjivt1n9iqvhv8ehijhpah3985','1',2,'2016-11-30 01:29:14','2016-11-30 01:30:31','127.0.0.1'),('62','39itgvu5p9e5e8ocm7hcjmqoo3','1',2,'2016-11-30 01:30:31','2016-11-30 06:58:40','127.0.0.1'),('63','phv9m5r6a47q90d5d0l0qkgg83','1',2,'2016-11-30 06:58:40','2016-12-01 01:36:17','127.0.0.1'),('64','hollskn47t57pbcef7s831ek85','1',2,'2016-12-01 01:36:17','2016-12-01 06:47:12','127.0.0.1'),('65','o5hil9e89b4q6s8u61eh1jo8j4','1',2,'2016-12-01 06:47:12','2016-12-01 14:56:48','127.0.0.1'),('66','pfo36iq7a0ibl89891kk7439u7','1',2,'2016-12-01 14:56:48','2016-12-02 01:42:29','127.0.0.1'),('67','u4aj7it7dld03a7pg7udd1fev4','1',2,'2016-12-02 01:42:29','2016-12-02 15:29:34','127.0.0.1'),('68','bhqqff950pn4s25lh09muqgv95','1',2,'2016-12-02 15:29:34','2016-12-04 14:25:41','127.0.0.1'),('69','ssqof2tnt84njg1fs6me0rja94','1',2,'2016-12-04 14:25:40','2016-12-05 15:11:17','127.0.0.1'),('70','tlk7v7djqihmaa8msanoatpcc4','1',2,'2016-12-05 15:11:17','2016-12-06 03:14:44','127.0.0.1'),('71','41oje4bhemln1qoc4gko4s6db2','1',2,'2016-12-06 03:14:44','2016-12-06 13:00:42','127.0.0.1'),('72','im3cei4cmerranemikafvoedm7','1',2,'2016-12-06 13:00:42','2016-12-06 15:14:49','127.0.0.1'),('73','76avccvsigk7jfqok4bbn4p392','1',2,'2016-12-06 15:14:49','2016-12-06 15:15:37','127.0.0.1'),('74','6ejqce6n6s26h5rro5qfo8mll0','1',2,'2016-12-06 15:15:37','2016-12-07 15:34:41','127.0.0.1'),('75','8f3o5pa6m7dnf2qkcchf313057','1',2,'2016-12-07 15:34:41','2016-12-08 04:15:54','127.0.0.1'),('76','letp0iu69cie0cui8cm91comq0','1',2,'2016-12-08 04:15:54','2016-12-08 14:33:54','127.0.0.1'),('77','u8qmfhl6qdcugdtsmr9ni9mci7','1',2,'2016-12-08 14:33:53','2016-12-09 04:20:39','127.0.0.1'),('78','l9bgkna735198j68a68repvmr7','1',2,'2016-12-09 04:20:39','2016-12-09 08:17:57','127.0.0.1'),('79','t3v1d0giq330nh8a4eh9ljtui5','1',2,'2016-12-09 08:17:57','2016-12-10 01:43:50','127.0.0.1'),('80','jjd7s7b7at7l2467s6gi9e86b7','1',2,'2016-12-10 01:43:50','2016-12-11 08:37:12','127.0.0.1'),('81','emuftuhn8ebe2njs1tiqujvgd4','1',2,'2016-12-11 08:37:12','2016-12-12 02:43:45','127.0.0.1'),('82','ubtllp2jhg280pvj7b9popjdf2','1',2,'2016-12-12 02:43:45','2016-12-13 07:07:33','127.0.0.1'),('83','tp0bh8809kqu3drdrc9ldik1o4','1',2,'2016-12-13 07:07:33','2016-12-14 02:08:15','127.0.0.1'),('84','bjj4qths7kn4i1gaqogivsvea0','1',2,'2016-12-14 02:08:15','2016-12-14 07:42:06','127.0.0.1'),('85','rc36gttuil7ep4d12s150l3tk2','1',2,'2016-12-14 07:42:06','2016-12-14 14:07:00','127.0.0.1'),('86','dmrtrvj36g8d0at92bsh9v4i01','1',2,'2016-12-14 14:07:00','2016-12-15 14:47:49','127.0.0.1'),('87','cvfemqh0cbuh2oktj51f5n2bb2','1',2,'2016-12-15 14:47:49','2016-12-19 01:28:45','127.0.0.1'),('88','1np7mdb359c9q4gs77r4mqvrt6','1',2,'2016-12-19 01:28:45','2016-12-19 14:39:36','192.168.1.72'),('89','5g0uim8kdr3pog0mq9n2v2sr15','1',2,'2016-12-19 14:39:36','2016-12-20 16:01:53','127.0.0.1'),('90','fcop6hk9bvj26unn8p0v9p4r45','1',2,'2016-12-20 16:01:53','2016-12-21 02:19:01','127.0.0.1'),('91','38dghse8s54e0p6m2e9mbk3n00','1',2,'2016-12-21 02:19:01','2016-12-22 02:47:19','127.0.0.1'),('92','19qn4jkjmbhed2e5ajscn6o0b1','1',2,'2016-12-22 02:47:19','2016-12-22 08:58:29','192.168.1.92'),('93','i9nn1m58f941gd2pua4c1q3lp2','1',2,'2016-12-22 08:58:29','2016-12-22 16:59:30','192.168.1.92'),('94','bfulndkqf2r809ev3r4ofc83t1','1',2,'2016-12-22 16:59:30','2016-12-23 00:27:56','127.0.0.1'),('95','3815d944esedi3l4bomiflq7i4','1',2,'2016-12-23 00:27:56','2016-12-23 01:42:33','127.0.0.1'),('96','3t6pcbtd29eejvn7kbbhn7ki63','1',2,'2016-12-23 01:42:33','2016-12-26 04:14:01','192.168.1.2'),('97','a84fkihs1e05dorqpfris5srh2','1',1,'2016-12-26 04:14:01','2016-12-26 04:56:27','192.168.1.92');
/*!40000 ALTER TABLE `admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification id',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='Adminnotification Inbox';

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES ('1',4,'2016-07-19 16:45:42','Community Edition 2.0.8 improves installation, configurable product creation and more – 7/19/2016','Magento Community Edition 2.0.8 makes several functional improvements that address issues with application installation, duplication of url keys during configurable product creation, and other issues described in the release notes posted at http://devdocs.magento.com/guides/v2.0/release-notes/ReleaseNotes2.0.8CE.html.','http://devdocs.magento.com/guides/v2.0/release-notes/ReleaseNotes2.0.8CE.html',0,0),('2',4,'2016-08-30 23:36:54','Community Edition 2.1.1 Features Performance and Functional Improvements – 8/30/2016','Community Edition 2.1.1 improves storefront performance when using many configurable product variations and addresses upgrade and installation issues. You can learn more in the release notes at http://devdocs.magento.com/guides/v2.1/release-notes/ReleaseNotes2.1.1CE.html.','http://devdocs.magento.com/guides/v2.1/release-notes/ReleaseNotes2.1.1CE.html ',0,0),('3',4,'2016-09-13 05:50:17','Which Marketplaces/Social Media Platforms Matter Most? Take Our Brief Survey.','Here at Magento we are continuously looking to improve our product. \n\nWe want to know which marketplaces and social media platforms you use to advertise and sell products from your Magento store. This simple survey should take less than five minutes. Your feedback is essential and we will keep your response completely confidential.\n \nTake the survey:  https://www.research.net/r/5BZCC2Q\n','https://www.research.net/r/5BZCC2Q',0,0),('4',1,'2016-10-12 20:27:35','Community Edition 2.0.10 and 2.1.2 Resolve Critical Security Issues – 10/12/2016','Magento Community Edition 2.0.10 and 2.1.2 resolve multiple security issues, including critical vulnerabilities with certain payment methods and Zend Framework libraries. The releases also make several functional improvements and API enhancements. Learn more about the security issues in the Magento Security Center at https://magento.com/security/patches/magento-2010-and-212-security-update and functional updates at http://devdocs.magento.com/guides/v2.1/release-notes/bk-release-notes.html.','https://magento.com/security/patches/magento-2010-and-212-security-update',0,0),('5',1,'2016-10-25 16:53:36','Dirty COW Linux OS Vulnerability – 10/25/2016','Dirty COW (CVE-2016-5195) is a serious vulnerability affecting most Linux Operating Systems that can be exploited to gain root access to the server. More information on how to immediately update your Linux OS is available in the Magento Security Center at https://magento.com/security/vulnerabilities/new-linux-operating-system-vulnerability. ','https://magento.com/security/vulnerabilities/new-linux-operating-system-vulnerability',0,0),('6',4,'2016-12-14 18:39:37','New Magento 2 Releases Feature Payment, Performance & Quality Enhancements – 12/14/2016','Community Editions 2.1.3 and 2.0.11 feature new payment functionality, accelerated performance, and enhanced product quality. Learn more in the release notes at http://devdocs.magento.com/guides/v2.1/release-notes/bk-release-notes.html ','http://devdocs.magento.com/guides/v2.1/release-notes/bk-release-notes.html',0,0),('7',4,'2016-12-16 06:16:21','Are you a Magento Developer? Take our developer experience survey by December 21.','As a Magento developer, your feedback is critical to the success of the Magento platform. We invite you to complete a survey about your experience developing on the Magento 2 platform. The results will help us improve our product and resources to enable your continued success. The survey should take no more than 10 minutes and all information you provide will remain strictly confidential. https://www.research.net/r/SL7VVNR','https://www.research.net/r/SL7VVNR',0,0);
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_role`
--

DROP TABLE IF EXISTS `authorization_role`;
CREATE TABLE `authorization_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='Admin Role Table';

--
-- Dumping data for table `authorization_role`
--

LOCK TABLES `authorization_role` WRITE;
/*!40000 ALTER TABLE `authorization_role` DISABLE KEYS */;
INSERT INTO `authorization_role` VALUES ('1','0',1,1,'G','0','2','Administrators'),('2','1',2,0,'U','1','2','admin');
/*!40000 ALTER TABLE `authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_rule`
--

DROP TABLE IF EXISTS `authorization_rule`;
CREATE TABLE `authorization_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Rule Table';

--
-- Dumping data for table `authorization_rule`
--

LOCK TABLES `authorization_rule` WRITE;
/*!40000 ALTER TABLE `authorization_rule` DISABLE KEYS */;
INSERT INTO `authorization_rule` VALUES ('1','1','Magento_Backend::all',NULL,'allow');
/*!40000 ALTER TABLE `authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int(11) DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int(11) DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int(11) DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches';

--
-- Table structure for table `cache_tag`
--

DROP TABLE IF EXISTS `cache_tag`;
CREATE TABLE `cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tag Caches';

--
-- Table structure for table `captcha_log`
--

DROP TABLE IF EXISTS `captcha_log`;
CREATE TABLE `captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(32) NOT NULL COMMENT 'Value',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Count Login Attempts';

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attriute Set ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int(11) NOT NULL COMMENT 'Position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int(11) NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_LEVEL` (`level`)
) ENGINE=InnoDB AUTO_INCREMENT=331 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Table';

--
-- Dumping data for table `catalog_category_entity`
--

LOCK TABLES `catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity` DISABLE KEYS */;
INSERT INTO `catalog_category_entity` VALUES ('1',0,'0','2016-07-18 04:12:19','2016-12-13 08:55:20','1','0','0','-279'),('2',3,'1','2016-07-18 04:12:23','2016-11-16 14:47:32','1/2','1','1','-155'),('147',3,'2','2016-07-20 06:46:47','2016-08-29 10:59:18','1/2/147','2','2','15'),('148',3,'2','2016-07-20 06:47:36','2016-08-29 10:59:24','1/2/148','3','2','10'),('188',3,'147','2016-07-20 07:36:35','2016-08-29 10:59:18','1/2/147/188','1','3','4'),('189',3,'147','2016-07-21 01:40:17','2016-08-29 10:59:18','1/2/147/189','2','3','4'),('190',3,'147','2016-07-21 01:41:33','2016-08-29 10:59:18','1/2/147/190','3','3','4'),('191',3,'188','2016-07-21 01:42:19','2016-08-29 10:59:18','1/2/147/188/191','1','4','0'),('192',3,'188','2016-07-21 01:56:55','2016-08-29 10:59:18','1/2/147/188/192','2','4','0'),('193',3,'188','2016-07-21 01:58:01','2016-08-29 10:59:18','1/2/147/188/193','3','4','0'),('194',3,'188','2016-07-21 01:58:43','2016-08-29 10:59:18','1/2/147/188/194','4','4','0'),('195',3,'189','2016-07-21 01:59:58','2016-08-29 10:59:18','1/2/147/189/195','1','4','0'),('196',3,'189','2016-07-21 02:00:28','2016-08-29 10:59:18','1/2/147/189/196','2','4','0'),('197',3,'189','2016-07-21 02:01:09','2016-08-29 10:59:18','1/2/147/189/197','3','4','0'),('198',3,'189','2016-07-21 02:01:46','2016-08-29 10:59:18','1/2/147/189/198','4','4','0'),('199',3,'190','2016-07-21 02:02:40','2016-08-29 10:59:18','1/2/147/190/199','1','4','0'),('200',3,'190','2016-07-21 02:03:10','2016-08-29 10:59:18','1/2/147/190/200','2','4','0'),('201',3,'190','2016-07-21 02:03:39','2016-08-29 10:59:18','1/2/147/190/201','3','4','0'),('202',3,'190','2016-07-21 02:04:34','2016-08-29 10:59:18','1/2/147/190/202','4','4','0'),('203',3,'148','2016-07-21 02:05:13','2016-08-29 10:59:24','1/2/148/203','1','3','4'),('204',3,'148','2016-07-21 02:06:00','2016-08-29 10:59:24','1/2/148/204','2','3','4'),('205',3,'203','2016-07-21 02:06:42','2016-08-29 10:59:24','1/2/148/203/205','1','4','0'),('206',3,'203','2016-07-21 02:07:18','2016-08-29 10:59:24','1/2/148/203/206','2','4','0'),('207',3,'203','2016-07-21 02:08:41','2016-08-29 10:59:24','1/2/148/203/207','3','4','0'),('208',3,'203','2016-07-21 02:10:02','2016-08-29 10:59:24','1/2/148/203/208','4','4','0'),('209',3,'204','2016-07-21 02:10:37','2016-08-29 10:59:24','1/2/148/204/209','1','4','0'),('210',3,'204','2016-07-21 02:11:13','2016-08-29 10:59:24','1/2/148/204/210','2','4','0'),('211',3,'204','2016-07-21 02:12:05','2016-08-29 10:59:24','1/2/148/204/211','3','4','0'),('212',3,'204','2016-07-21 02:12:45','2016-08-29 10:59:24','1/2/148/204/212','4','4','0'),('213',3,'1','2016-12-01 07:38:34','2016-12-01 08:00:00','1/213','2','1','41'),('214',3,'213','2016-12-01 07:39:54','2016-12-01 07:50:41','1/213/214','1','2','15'),('215',3,'213','2016-12-01 07:40:39','2016-12-01 07:55:35','1/213/215','2','2','15'),('216',3,'213','2016-12-01 07:41:12','2016-12-01 08:00:00','1/213/216','3','2','8'),('217',3,'214','2016-12-01 07:41:38','2016-12-01 07:47:26','1/213/214/217','1','3','4'),('218',3,'214','2016-12-01 07:43:01','2016-12-01 07:49:14','1/213/214/218','2','3','4'),('219',3,'214','2016-12-01 07:46:11','2016-12-01 07:50:41','1/213/214/219','3','3','4'),('220',3,'217','2016-12-01 07:46:28','2016-12-01 07:46:28','1/213/214/217/220','1','4','0'),('221',3,'217','2016-12-01 07:46:47','2016-12-01 07:46:47','1/213/214/217/221','2','4','0'),('222',3,'217','2016-12-01 07:47:06','2016-12-01 07:47:06','1/213/214/217/222','3','4','0'),('223',3,'217','2016-12-01 07:47:26','2016-12-01 07:47:26','1/213/214/217/223','4','4','0'),('224',3,'218','2016-12-01 07:47:43','2016-12-01 07:47:43','1/213/214/218/224','1','4','0'),('225',3,'218','2016-12-01 07:48:35','2016-12-01 07:48:35','1/213/214/218/225','2','4','0'),('226',3,'218','2016-12-01 07:48:58','2016-12-01 07:48:58','1/213/214/218/226','3','4','0'),('227',3,'218','2016-12-01 07:49:14','2016-12-01 07:49:14','1/213/214/218/227','4','4','0'),('228',3,'219','2016-12-01 07:49:51','2016-12-01 07:49:51','1/213/214/219/228','1','4','0'),('229',3,'219','2016-12-01 07:50:07','2016-12-01 07:50:07','1/213/214/219/229','2','4','0'),('230',3,'219','2016-12-01 07:50:25','2016-12-01 07:50:25','1/213/214/219/230','3','4','0'),('231',3,'219','2016-12-01 07:50:41','2016-12-01 07:50:41','1/213/214/219/231','4','4','0'),('232',3,'215','2016-12-01 07:51:03','2016-12-01 07:53:09','1/213/215/232','1','3','4'),('233',3,'215','2016-12-01 07:51:26','2016-12-01 07:54:21','1/213/215/233','2','3','4'),('234',3,'215','2016-12-01 07:51:47','2016-12-01 07:55:35','1/213/215/234','3','3','4'),('235',3,'232','2016-12-01 07:52:08','2016-12-01 07:52:09','1/213/215/232/235','1','4','0'),('236',3,'232','2016-12-01 07:52:28','2016-12-01 07:52:29','1/213/215/232/236','2','4','0'),('237',3,'232','2016-12-01 07:52:48','2016-12-01 07:52:48','1/213/215/232/237','3','4','0'),('238',3,'232','2016-12-01 07:53:09','2016-12-01 07:53:09','1/213/215/232/238','4','4','0'),('239',3,'233','2016-12-01 07:53:31','2016-12-01 07:53:31','1/213/215/233/239','1','4','0'),('240',3,'233','2016-12-01 07:53:48','2016-12-01 07:53:48','1/213/215/233/240','2','4','0'),('241',3,'233','2016-12-01 07:54:04','2016-12-01 07:54:05','1/213/215/233/241','3','4','0'),('242',3,'233','2016-12-01 07:54:21','2016-12-01 07:54:21','1/213/215/233/242','4','4','0'),('243',3,'234','2016-12-01 07:54:47','2016-12-01 07:54:47','1/213/215/234/243','1','4','0'),('244',3,'234','2016-12-01 07:55:03','2016-12-01 07:55:03','1/213/215/234/244','2','4','0'),('245',3,'234','2016-12-01 07:55:20','2016-12-01 07:55:20','1/213/215/234/245','3','4','0'),('246',3,'234','2016-12-01 07:55:35','2016-12-01 07:55:35','1/213/215/234/246','4','4','0'),('247',3,'216','2016-12-01 07:56:40','2016-12-01 08:00:00','1/213/216/247','1','3','3'),('248',3,'216','2016-12-01 07:57:03','2016-12-01 07:58:55','1/213/216/248','2','3','3'),('249',3,'248','2016-12-01 07:57:34','2016-12-01 07:57:34','1/213/216/248/249','1','4','0'),('250',3,'248','2016-12-01 07:58:30','2016-12-01 07:58:30','1/213/216/248/250','2','4','0'),('251',3,'248','2016-12-01 07:58:55','2016-12-01 07:58:55','1/213/216/248/251','3','4','0'),('252',3,'247','2016-12-01 07:59:16','2016-12-01 07:59:16','1/213/216/247/252','1','4','0'),('253',3,'247','2016-12-01 07:59:38','2016-12-01 07:59:38','1/213/216/247/253','2','4','0'),('254',3,'247','2016-12-01 08:00:00','2016-12-01 08:00:00','1/213/216/247/254','3','4','0'),('255',3,'1','2016-12-02 15:58:16','2016-12-13 08:55:20','1/255','3','1','44'),('256',3,'255','2016-12-02 15:58:52','2016-12-06 15:25:12','1/255/256','1','2','18'),('257',3,'255','2016-12-02 15:59:13','2016-12-06 15:30:25','1/255/257','2','2','15'),('258',3,'255','2016-12-02 15:59:42','2016-12-06 15:43:22','1/255/258','3','2','8'),('260',3,'256','2016-12-06 15:18:07','2016-12-06 15:25:12','1/255/256/260','1','3','5'),('261',3,'256','2016-12-06 15:18:31','2016-12-06 15:23:36','1/255/256/261','2','3','5'),('262',3,'256','2016-12-06 15:19:06','2016-12-06 15:20:35','1/255/256/262','3','3','5'),('263',3,'262','2016-12-06 15:19:21','2016-12-06 15:19:21','1/255/256/262/263','1','4','0'),('264',3,'262','2016-12-06 15:19:37','2016-12-06 15:19:37','1/255/256/262/264','2','4','0'),('265',3,'262','2016-12-06 15:19:54','2016-12-06 15:19:54','1/255/256/262/265','3','4','0'),('266',3,'262','2016-12-06 15:20:12','2016-12-06 15:20:12','1/255/256/262/266','4','4','0'),('267',3,'262','2016-12-06 15:20:35','2016-12-06 15:20:35','1/255/256/262/267','5','4','0'),('268',3,'261','2016-12-06 15:21:01','2016-12-06 15:21:01','1/255/256/261/268','1','4','0'),('269',3,'261','2016-12-06 15:21:41','2016-12-06 15:21:41','1/255/256/261/269','2','4','0'),('270',3,'261','2016-12-06 15:22:40','2016-12-06 15:22:40','1/255/256/261/270','3','4','0'),('271',3,'261','2016-12-06 15:23:19','2016-12-06 15:23:19','1/255/256/261/271','4','4','0'),('272',3,'261','2016-12-06 15:23:36','2016-12-06 15:23:36','1/255/256/261/272','5','4','0'),('273',3,'260','2016-12-06 15:24:02','2016-12-06 15:24:02','1/255/256/260/273','1','4','0'),('274',3,'260','2016-12-06 15:24:18','2016-12-06 15:24:18','1/255/256/260/274','2','4','0'),('275',3,'260','2016-12-06 15:24:35','2016-12-06 15:24:35','1/255/256/260/275','3','4','0'),('276',3,'260','2016-12-06 15:24:52','2016-12-06 15:24:52','1/255/256/260/276','4','4','0'),('277',3,'260','2016-12-06 15:25:12','2016-12-06 15:25:12','1/255/256/260/277','5','4','0'),('278',3,'257','2016-12-06 15:25:39','2016-12-06 15:30:25','1/255/257/278','1','3','4'),('279',3,'257','2016-12-06 15:25:56','2016-12-06 15:28:58','1/255/257/279','2','3','4'),('280',3,'257','2016-12-06 15:26:12','2016-12-06 15:27:33','1/255/257/280','3','3','4'),('281',3,'280','2016-12-06 15:26:41','2016-12-06 15:26:41','1/255/257/280/281','1','4','0'),('282',3,'280','2016-12-06 15:26:59','2016-12-06 15:26:59','1/255/257/280/282','2','4','0'),('283',3,'280','2016-12-06 15:27:15','2016-12-06 15:27:15','1/255/257/280/283','3','4','0'),('284',3,'280','2016-12-06 15:27:33','2016-12-06 15:27:33','1/255/257/280/284','4','4','0'),('285',3,'279','2016-12-06 15:27:50','2016-12-06 15:27:50','1/255/257/279/285','1','4','0'),('286',3,'279','2016-12-06 15:28:09','2016-12-06 15:28:09','1/255/257/279/286','2','4','0'),('287',3,'279','2016-12-06 15:28:34','2016-12-06 15:28:34','1/255/257/279/287','3','4','0'),('288',3,'279','2016-12-06 15:28:58','2016-12-06 15:28:59','1/255/257/279/288','4','4','0'),('289',3,'278','2016-12-06 15:29:30','2016-12-06 15:29:30','1/255/257/278/289','1','4','0'),('290',3,'278','2016-12-06 15:29:49','2016-12-06 15:29:49','1/255/257/278/290','2','4','0'),('291',3,'278','2016-12-06 15:30:04','2016-12-06 15:30:04','1/255/257/278/291','3','4','0'),('292',3,'278','2016-12-06 15:30:25','2016-12-06 15:30:25','1/255/257/278/292','4','4','0'),('293',3,'258','2016-12-06 15:31:28','2016-12-06 15:33:56','1/255/258/293','1','3','3'),('294',3,'258','2016-12-06 15:31:47','2016-12-06 15:43:22','1/255/258/294','2','3','3'),('295',3,'293','2016-12-06 15:32:08','2016-12-06 15:32:08','1/255/258/293/295','1','4','0'),('296',3,'293','2016-12-06 15:32:30','2016-12-06 15:32:59','1/255/258/293/296','2','4','0'),('298',3,'293','2016-12-06 15:33:56','2016-12-06 15:33:56','1/255/258/293/298','3','4','0'),('299',3,'294','2016-12-06 15:39:07','2016-12-06 15:39:07','1/255/258/294/299','1','4','0'),('300',3,'294','2016-12-06 15:39:26','2016-12-06 15:39:26','1/255/258/294/300','2','4','0'),('302',3,'294','2016-12-06 15:43:22','2016-12-06 15:43:22','1/255/258/294/302','3','4','0'),('303',3,'1','2016-12-07 15:39:16','2016-12-08 15:24:39','1/303','4','1','26'),('304',3,'303','2016-12-07 15:43:10','2016-12-08 15:24:39','1/303/304','1','2','15'),('305',3,'303','2016-12-07 15:44:37','2016-12-08 15:14:34','1/303/305','2','2','8'),('306',3,'303','2016-12-07 15:45:02','2016-12-07 15:45:02','1/303/306','3','2','0'),('307',3,'304','2016-12-07 15:48:44','2016-12-08 15:18:22','1/303/304/307','1','3','4'),('308',3,'304','2016-12-08 15:06:48','2016-12-08 15:21:48','1/303/304/308','2','3','4'),('309',3,'304','2016-12-08 15:08:30','2016-12-08 15:24:39','1/303/304/309','3','3','4'),('310',3,'305','2016-12-08 15:08:58','2016-12-08 15:14:34','1/303/305/310','1','3','3'),('311',3,'305','2016-12-08 15:09:42','2016-12-08 15:13:11','1/303/305/311','2','3','3'),('312',3,'311','2016-12-08 15:10:28','2016-12-08 15:10:28','1/303/305/311/312','1','4','0'),('313',3,'311','2016-12-08 15:12:06','2016-12-08 15:12:06','1/303/305/311/313','2','4','0'),('314',3,'311','2016-12-08 15:13:11','2016-12-08 15:13:11','1/303/305/311/314','3','4','0'),('315',3,'310','2016-12-08 15:13:41','2016-12-08 15:13:41','1/303/305/310/315','1','4','0'),('316',3,'310','2016-12-08 15:14:01','2016-12-08 15:14:01','1/303/305/310/316','2','4','0'),('317',3,'310','2016-12-08 15:14:34','2016-12-08 15:14:34','1/303/305/310/317','3','4','0'),('318',3,'307','2016-12-08 15:15:11','2016-12-08 15:15:11','1/303/304/307/318','1','4','0'),('319',3,'307','2016-12-08 15:15:37','2016-12-08 15:15:37','1/303/304/307/319','2','4','0'),('321',3,'307','2016-12-08 15:16:35','2016-12-08 15:16:35','1/303/304/307/321','3','4','0'),('322',3,'308','2016-12-08 15:17:54','2016-12-08 15:17:54','1/303/304/308/322','1','4','0'),('323',3,'307','2016-12-08 15:18:22','2016-12-08 15:18:23','1/303/304/307/323','4','4','0'),('324',3,'308','2016-12-08 15:19:56','2016-12-08 15:19:56','1/303/304/308/324','2','4','0'),('325',3,'308','2016-12-08 15:20:28','2016-12-08 15:20:28','1/303/304/308/325','3','4','0'),('326',3,'308','2016-12-08 15:21:48','2016-12-08 15:21:48','1/303/304/308/326','4','4','0'),('327',3,'309','2016-12-08 15:22:38','2016-12-08 15:22:38','1/303/304/309/327','1','4','0'),('328',3,'309','2016-12-08 15:23:54','2016-12-08 15:23:54','1/303/304/309/328','2','4','0'),('329',3,'309','2016-12-08 15:24:06','2016-12-08 15:24:06','1/303/304/309/329','3','4','0'),('330',3,'309','2016-12-08 15:24:39','2016-12-08 15:24:39','1/303/304/309/330','4','4','0');
/*!40000 ALTER TABLE `catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Datetime Attribute Backend Table';

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Decimal Attribute Backend Table';

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2072 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Integer Attribute Backend Table';

--
-- Dumping data for table `catalog_category_entity_int`
--

LOCK TABLES `catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_int` VALUES ('1',69,0,'1','1'),('2',46,0,'2','1'),('3',69,0,'2','1'),('364',54,0,'2','1'),('365',70,0,'2','0'),('366',71,0,'2','0'),('727',46,0,'147','1'),('728',54,0,'147','1'),('729',69,0,'147','1'),('730',70,0,'147','0'),('731',71,0,'147','0'),('732',46,0,'148','1'),('733',54,0,'148','1'),('734',69,0,'148','1'),('735',70,0,'148','0'),('736',71,0,'148','0'),('932',46,0,'188','1'),('933',54,0,'188','1'),('934',69,0,'188','1'),('935',70,0,'188','0'),('936',71,0,'188','0'),('937',46,0,'189','1'),('938',54,0,'189','1'),('939',69,0,'189','1'),('940',70,0,'189','0'),('941',71,0,'189','0'),('942',46,0,'190','1'),('943',54,0,'190','1'),('944',69,0,'190','1'),('945',70,0,'190','0'),('946',71,0,'190','0'),('947',46,0,'191','1'),('948',54,0,'191','1'),('949',69,0,'191','1'),('950',70,0,'191','0'),('951',71,0,'191','0'),('952',46,0,'192','1'),('953',54,0,'192','1'),('954',69,0,'192','1'),('955',70,0,'192','0'),('956',71,0,'192','0'),('957',46,0,'193','1'),('958',54,0,'193','1'),('959',69,0,'193','1'),('960',70,0,'193','0'),('961',71,0,'193','0'),('962',46,0,'194','1'),('963',54,0,'194','1'),('964',69,0,'194','1'),('965',70,0,'194','0'),('966',71,0,'194','0'),('967',46,0,'195','1'),('968',54,0,'195','1'),('969',69,0,'195','1'),('970',70,0,'195','0'),('971',71,0,'195','0'),('972',46,0,'196','1'),('973',54,0,'196','1'),('974',69,0,'196','1'),('975',70,0,'196','0'),('976',71,0,'196','0'),('977',46,0,'197','1'),('978',54,0,'197','1'),('979',69,0,'197','1'),('980',70,0,'197','0'),('981',71,0,'197','0'),('982',46,0,'198','1'),('983',54,0,'198','1'),('984',69,0,'198','1'),('985',70,0,'198','0'),('986',71,0,'198','0'),('987',46,0,'199','1'),('988',54,0,'199','1'),('989',69,0,'199','1'),('990',70,0,'199','0'),('991',71,0,'199','0'),('992',46,0,'200','1'),('993',54,0,'200','1'),('994',69,0,'200','1'),('995',70,0,'200','0'),('996',71,0,'200','0'),('997',46,0,'201','1'),('998',54,0,'201','1'),('999',69,0,'201','1'),('1000',70,0,'201','0'),('1001',71,0,'201','0'),('1002',46,0,'202','1'),('1003',54,0,'202','1'),('1004',69,0,'202','1'),('1005',70,0,'202','0'),('1006',71,0,'202','0'),('1007',46,0,'203','1'),('1008',54,0,'203','1'),('1009',69,0,'203','1'),('1010',70,0,'203','0'),('1011',71,0,'203','0'),('1012',46,0,'204','1'),('1013',54,0,'204','1'),('1014',69,0,'204','1'),('1015',70,0,'204','0'),('1016',71,0,'204','0'),('1017',46,0,'205','1'),('1018',54,0,'205','1'),('1019',69,0,'205','1'),('1020',70,0,'205','0'),('1021',71,0,'205','0'),('1022',46,0,'206','1'),('1023',54,0,'206','1'),('1024',69,0,'206','1'),('1025',70,0,'206','0'),('1026',71,0,'206','0'),('1027',46,0,'207','1'),('1028',54,0,'207','1'),('1029',69,0,'207','1'),('1030',70,0,'207','0'),('1031',71,0,'207','0'),('1032',46,0,'208','1'),('1033',54,0,'208','1'),('1034',69,0,'208','1'),('1035',70,0,'208','0'),('1036',71,0,'208','0'),('1037',46,0,'209','1'),('1038',54,0,'209','1'),('1039',69,0,'209','1'),('1040',70,0,'209','0'),('1041',71,0,'209','0'),('1042',46,0,'210','1'),('1043',54,0,'210','1'),('1044',69,0,'210','1'),('1045',70,0,'210','0'),('1046',71,0,'210','0'),('1047',46,0,'211','1'),('1048',54,0,'211','1'),('1049',69,0,'211','1'),('1050',70,0,'211','0'),('1051',71,0,'211','0'),('1052',46,0,'212','1'),('1053',54,0,'212','1'),('1054',69,0,'212','1'),('1055',70,0,'212','0'),('1056',71,0,'212','0'),('1169',138,0,'2','1'),('1170',139,0,'2','1'),('1171',138,0,'147','1'),('1172',139,0,'147','1'),('1173',138,0,'148','1'),('1174',139,0,'148','1'),('1175',138,0,'188','1'),('1176',139,0,'188','1'),('1177',138,0,'191','1'),('1178',139,0,'191','1'),('1179',138,0,'192','1'),('1180',139,0,'192','1'),('1181',138,0,'193','1'),('1182',139,0,'193','1'),('1183',138,0,'194','1'),('1184',139,0,'194','1'),('1185',138,0,'189','1'),('1186',139,0,'189','1'),('1187',138,0,'195','1'),('1188',139,0,'195','1'),('1189',138,0,'196','1'),('1190',139,0,'196','1'),('1191',138,0,'197','1'),('1192',139,0,'197','1'),('1193',138,0,'198','1'),('1194',139,0,'198','1'),('1195',138,0,'190','1'),('1196',139,0,'190','1'),('1197',138,0,'199','1'),('1198',139,0,'199','1'),('1199',138,0,'200','1'),('1200',139,0,'200','1'),('1201',138,0,'201','1'),('1202',139,0,'201','1'),('1203',138,0,'202','1'),('1204',139,0,'202','1'),('1205',138,0,'210','1'),('1206',139,0,'210','1'),('1207',138,0,'211','1'),('1208',139,0,'211','1'),('1209',138,0,'212','1'),('1210',139,0,'212','1'),('1211',138,0,'204','1'),('1212',139,0,'204','1'),('1213',138,0,'206','1'),('1214',139,0,'206','1'),('1215',46,0,'213','1'),('1216',54,0,'213','1'),('1217',69,0,'213','1'),('1218',70,0,'213','0'),('1219',71,0,'213','0'),('1220',138,0,'213','1'),('1221',139,0,'213','1'),('1222',46,0,'214','1'),('1223',54,0,'214','1'),('1224',69,0,'214','1'),('1225',70,0,'214','0'),('1226',71,0,'214','0'),('1227',138,0,'214','1'),('1228',139,0,'214','1'),('1229',46,0,'215','1'),('1230',54,0,'215','1'),('1231',69,0,'215','1'),('1232',70,0,'215','0'),('1233',71,0,'215','0'),('1234',138,0,'215','1'),('1235',139,0,'215','1'),('1236',46,0,'216','1'),('1237',54,0,'216','1'),('1238',69,0,'216','1'),('1239',70,0,'216','0'),('1240',71,0,'216','0'),('1241',138,0,'216','1'),('1242',139,0,'216','1'),('1243',46,0,'217','1'),('1244',54,0,'217','1'),('1245',69,0,'217','1'),('1246',70,0,'217','0'),('1247',71,0,'217','0'),('1248',138,0,'217','1'),('1249',139,0,'217','1'),('1250',46,0,'218','1'),('1251',54,0,'218','1'),('1252',69,0,'218','1'),('1253',70,0,'218','0'),('1254',71,0,'218','0'),('1255',138,0,'218','1'),('1256',139,0,'218','1'),('1257',46,0,'219','1'),('1258',54,0,'219','1'),('1259',69,0,'219','1'),('1260',70,0,'219','0'),('1261',71,0,'219','0'),('1262',138,0,'219','1'),('1263',139,0,'219','1'),('1264',46,0,'220','1'),('1265',54,0,'220','1'),('1266',69,0,'220','1'),('1267',70,0,'220','0'),('1268',71,0,'220','0'),('1269',138,0,'220','1'),('1270',139,0,'220','1'),('1271',46,0,'221','1'),('1272',54,0,'221','1'),('1273',69,0,'221','1'),('1274',70,0,'221','0'),('1275',71,0,'221','0'),('1276',138,0,'221','1'),('1277',139,0,'221','1'),('1278',46,0,'222','1'),('1279',54,0,'222','1'),('1280',69,0,'222','1'),('1281',70,0,'222','0'),('1282',71,0,'222','0'),('1283',138,0,'222','1'),('1284',139,0,'222','1'),('1285',46,0,'223','1'),('1286',54,0,'223','1'),('1287',69,0,'223','1'),('1288',70,0,'223','0'),('1289',71,0,'223','0'),('1290',138,0,'223','1'),('1291',139,0,'223','1'),('1292',46,0,'224','1'),('1293',54,0,'224','1'),('1294',69,0,'224','1'),('1295',70,0,'224','0'),('1296',71,0,'224','0'),('1297',138,0,'224','1'),('1298',139,0,'224','1'),('1299',46,0,'225','1'),('1300',54,0,'225','1'),('1301',69,0,'225','1'),('1302',70,0,'225','0'),('1303',71,0,'225','0'),('1304',138,0,'225','1'),('1305',139,0,'225','1'),('1306',46,0,'226','1'),('1307',54,0,'226','1'),('1308',69,0,'226','1'),('1309',70,0,'226','0'),('1310',71,0,'226','0'),('1311',138,0,'226','1'),('1312',139,0,'226','1'),('1313',46,0,'227','1'),('1314',54,0,'227','1'),('1315',69,0,'227','1'),('1316',70,0,'227','0'),('1317',71,0,'227','0'),('1318',138,0,'227','1'),('1319',139,0,'227','1'),('1320',46,0,'228','1'),('1321',54,0,'228','1'),('1322',69,0,'228','1'),('1323',70,0,'228','0'),('1324',71,0,'228','0'),('1325',138,0,'228','1'),('1326',139,0,'228','1'),('1327',46,0,'229','1'),('1328',54,0,'229','1'),('1329',69,0,'229','1'),('1330',70,0,'229','0'),('1331',71,0,'229','0'),('1332',138,0,'229','1'),('1333',139,0,'229','1'),('1334',46,0,'230','1'),('1335',54,0,'230','1'),('1336',69,0,'230','1'),('1337',70,0,'230','0'),('1338',71,0,'230','0'),('1339',138,0,'230','1'),('1340',139,0,'230','1'),('1341',46,0,'231','1'),('1342',54,0,'231','1'),('1343',69,0,'231','1'),('1344',70,0,'231','0'),('1345',71,0,'231','0'),('1346',138,0,'231','1'),('1347',139,0,'231','1'),('1348',46,0,'232','1'),('1349',54,0,'232','1'),('1350',69,0,'232','1'),('1351',70,0,'232','0'),('1352',71,0,'232','0'),('1353',138,0,'232','1'),('1354',139,0,'232','1'),('1355',46,0,'233','1'),('1356',54,0,'233','1'),('1357',69,0,'233','1'),('1358',70,0,'233','0'),('1359',71,0,'233','0'),('1360',138,0,'233','1'),('1361',139,0,'233','1'),('1362',46,0,'234','1'),('1363',54,0,'234','1'),('1364',69,0,'234','1'),('1365',70,0,'234','0'),('1366',71,0,'234','0'),('1367',138,0,'234','1'),('1368',139,0,'234','1'),('1369',46,0,'235','1'),('1370',54,0,'235','1'),('1371',69,0,'235','1'),('1372',70,0,'235','0'),('1373',71,0,'235','0'),('1374',138,0,'235','1'),('1375',139,0,'235','1'),('1376',46,0,'236','1'),('1377',54,0,'236','1'),('1378',69,0,'236','1'),('1379',70,0,'236','0'),('1380',71,0,'236','0'),('1381',138,0,'236','1'),('1382',139,0,'236','1'),('1383',46,0,'237','1'),('1384',54,0,'237','1'),('1385',69,0,'237','1'),('1386',70,0,'237','0'),('1387',71,0,'237','0'),('1388',138,0,'237','1'),('1389',139,0,'237','1'),('1390',46,0,'238','1'),('1391',54,0,'238','1'),('1392',69,0,'238','1'),('1393',70,0,'238','0'),('1394',71,0,'238','0'),('1395',138,0,'238','1'),('1396',139,0,'238','1'),('1397',46,0,'239','1'),('1398',54,0,'239','1'),('1399',69,0,'239','1'),('1400',70,0,'239','0'),('1401',71,0,'239','0'),('1402',138,0,'239','1'),('1403',139,0,'239','1'),('1404',46,0,'240','1'),('1405',54,0,'240','1'),('1406',69,0,'240','1'),('1407',70,0,'240','0'),('1408',71,0,'240','0'),('1409',138,0,'240','1'),('1410',139,0,'240','1'),('1411',46,0,'241','1'),('1412',54,0,'241','1'),('1413',69,0,'241','1'),('1414',70,0,'241','0'),('1415',71,0,'241','0'),('1416',138,0,'241','1'),('1417',139,0,'241','1'),('1418',46,0,'242','1'),('1419',54,0,'242','1'),('1420',69,0,'242','1'),('1421',70,0,'242','0'),('1422',71,0,'242','0'),('1423',138,0,'242','1'),('1424',139,0,'242','1'),('1425',46,0,'243','1'),('1426',54,0,'243','1'),('1427',69,0,'243','1'),('1428',70,0,'243','0'),('1429',71,0,'243','0'),('1430',138,0,'243','1'),('1431',139,0,'243','1'),('1432',46,0,'244','1'),('1433',54,0,'244','1'),('1434',69,0,'244','1'),('1435',70,0,'244','0'),('1436',71,0,'244','0'),('1437',138,0,'244','1'),('1438',139,0,'244','1'),('1439',46,0,'245','1'),('1440',54,0,'245','1'),('1441',69,0,'245','1'),('1442',70,0,'245','0'),('1443',71,0,'245','0'),('1444',138,0,'245','1'),('1445',139,0,'245','1'),('1446',46,0,'246','1'),('1447',54,0,'246','1'),('1448',69,0,'246','1'),('1449',70,0,'246','0'),('1450',71,0,'246','0'),('1451',138,0,'246','1'),('1452',139,0,'246','1'),('1453',46,0,'247','1'),('1454',54,0,'247','1'),('1455',69,0,'247','1'),('1456',70,0,'247','0'),('1457',71,0,'247','0'),('1458',138,0,'247','1'),('1459',139,0,'247','1'),('1460',46,0,'248','1'),('1461',54,0,'248','1'),('1462',69,0,'248','1'),('1463',70,0,'248','0'),('1464',71,0,'248','0'),('1465',138,0,'248','1'),('1466',139,0,'248','1'),('1467',46,0,'249','1'),('1468',54,0,'249','1'),('1469',69,0,'249','1'),('1470',70,0,'249','0'),('1471',71,0,'249','0'),('1472',138,0,'249','1'),('1473',139,0,'249','1'),('1474',46,0,'250','1'),('1475',54,0,'250','1'),('1476',69,0,'250','1'),('1477',70,0,'250','0'),('1478',71,0,'250','0'),('1479',138,0,'250','1'),('1480',139,0,'250','1'),('1481',46,0,'251','1'),('1482',54,0,'251','1'),('1483',69,0,'251','1'),('1484',70,0,'251','0'),('1485',71,0,'251','0'),('1486',138,0,'251','1'),('1487',139,0,'251','1'),('1488',46,0,'252','1'),('1489',54,0,'252','1'),('1490',69,0,'252','1'),('1491',70,0,'252','0'),('1492',71,0,'252','0'),('1493',138,0,'252','1'),('1494',139,0,'252','1'),('1495',46,0,'253','1'),('1496',54,0,'253','1'),('1497',69,0,'253','1'),('1498',70,0,'253','0'),('1499',71,0,'253','0'),('1500',138,0,'253','1'),('1501',139,0,'253','1'),('1502',46,0,'254','1'),('1503',54,0,'254','1'),('1504',69,0,'254','1'),('1505',70,0,'254','0'),('1506',71,0,'254','0'),('1507',138,0,'254','1'),('1508',139,0,'254','1'),('1509',46,0,'255','1'),('1510',54,0,'255','1'),('1511',69,0,'255','1'),('1512',70,0,'255','0'),('1513',71,0,'255','0'),('1514',138,0,'255','1'),('1515',139,0,'255','1'),('1516',46,0,'256','1'),('1517',54,0,'256','1'),('1518',69,0,'256','1'),('1519',70,0,'256','0'),('1520',71,0,'256','0'),('1521',138,0,'256','1'),('1522',139,0,'256','1'),('1523',46,0,'257','1'),('1524',54,0,'257','1'),('1525',69,0,'257','1'),('1526',70,0,'257','0'),('1527',71,0,'257','0'),('1528',138,0,'257','1'),('1529',139,0,'257','1'),('1530',46,0,'258','1'),('1531',54,0,'258','1'),('1532',69,0,'258','1'),('1533',70,0,'258','0'),('1534',71,0,'258','0'),('1535',138,0,'258','1'),('1536',139,0,'258','1'),('1544',46,0,'260','1'),('1545',54,0,'260','1'),('1546',69,0,'260','1'),('1547',70,0,'260','0'),('1548',71,0,'260','0'),('1549',138,0,'260','1'),('1550',139,0,'260','1'),('1551',46,0,'261','1'),('1552',54,0,'261','1'),('1553',69,0,'261','1'),('1554',70,0,'261','0'),('1555',71,0,'261','0'),('1556',138,0,'261','1'),('1557',139,0,'261','1'),('1558',46,0,'262','1'),('1559',54,0,'262','1'),('1560',69,0,'262','1'),('1561',70,0,'262','0'),('1562',71,0,'262','0'),('1563',138,0,'262','1'),('1564',139,0,'262','1'),('1565',46,0,'263','1'),('1566',54,0,'263','1'),('1567',69,0,'263','1'),('1568',70,0,'263','0'),('1569',71,0,'263','0'),('1570',138,0,'263','1'),('1571',139,0,'263','1'),('1572',46,0,'264','1'),('1573',54,0,'264','1'),('1574',69,0,'264','1'),('1575',70,0,'264','0'),('1576',71,0,'264','0'),('1577',138,0,'264','1'),('1578',139,0,'264','1'),('1579',46,0,'265','1'),('1580',54,0,'265','1'),('1581',69,0,'265','1'),('1582',70,0,'265','0'),('1583',71,0,'265','0'),('1584',138,0,'265','1'),('1585',139,0,'265','1'),('1586',46,0,'266','1'),('1587',54,0,'266','1'),('1588',69,0,'266','1'),('1589',70,0,'266','0'),('1590',71,0,'266','0'),('1591',138,0,'266','1'),('1592',139,0,'266','1'),('1593',46,0,'267','1'),('1594',54,0,'267','1'),('1595',69,0,'267','1'),('1596',70,0,'267','0'),('1597',71,0,'267','0'),('1598',138,0,'267','1'),('1599',139,0,'267','1'),('1600',46,0,'268','1'),('1601',54,0,'268','1'),('1602',69,0,'268','1'),('1603',70,0,'268','0'),('1604',71,0,'268','0'),('1605',138,0,'268','1'),('1606',139,0,'268','1'),('1607',46,0,'269','1'),('1608',54,0,'269','1'),('1609',69,0,'269','1'),('1610',70,0,'269','0'),('1611',71,0,'269','0'),('1612',138,0,'269','1'),('1613',139,0,'269','1'),('1614',46,0,'270','1'),('1615',54,0,'270','1'),('1616',69,0,'270','1'),('1617',70,0,'270','0'),('1618',71,0,'270','0'),('1619',138,0,'270','1'),('1620',139,0,'270','1'),('1621',46,0,'271','1'),('1622',54,0,'271','1'),('1623',69,0,'271','1'),('1624',70,0,'271','0'),('1625',71,0,'271','0'),('1626',138,0,'271','1'),('1627',139,0,'271','1'),('1628',46,0,'272','1'),('1629',54,0,'272','1'),('1630',69,0,'272','1'),('1631',70,0,'272','0'),('1632',71,0,'272','0'),('1633',138,0,'272','1'),('1634',139,0,'272','1'),('1635',46,0,'273','1'),('1636',54,0,'273','1'),('1637',69,0,'273','1'),('1638',70,0,'273','0'),('1639',71,0,'273','0'),('1640',138,0,'273','1'),('1641',139,0,'273','1'),('1642',46,0,'274','1'),('1643',54,0,'274','1'),('1644',69,0,'274','1'),('1645',70,0,'274','0'),('1646',71,0,'274','0'),('1647',138,0,'274','1'),('1648',139,0,'274','1'),('1649',46,0,'275','1'),('1650',54,0,'275','1'),('1651',69,0,'275','1'),('1652',70,0,'275','0'),('1653',71,0,'275','0'),('1654',138,0,'275','1'),('1655',139,0,'275','1'),('1656',46,0,'276','1'),('1657',54,0,'276','1'),('1658',69,0,'276','1'),('1659',70,0,'276','0'),('1660',71,0,'276','0'),('1661',138,0,'276','1'),('1662',139,0,'276','1'),('1663',46,0,'277','1'),('1664',54,0,'277','1'),('1665',69,0,'277','1'),('1666',70,0,'277','0'),('1667',71,0,'277','0'),('1668',138,0,'277','1'),('1669',139,0,'277','1'),('1670',46,0,'278','1'),('1671',54,0,'278','1'),('1672',69,0,'278','1'),('1673',70,0,'278','0'),('1674',71,0,'278','0'),('1675',138,0,'278','1'),('1676',139,0,'278','1'),('1677',46,0,'279','1'),('1678',54,0,'279','1'),('1679',69,0,'279','1'),('1680',70,0,'279','0'),('1681',71,0,'279','0'),('1682',138,0,'279','1'),('1683',139,0,'279','1'),('1684',46,0,'280','1'),('1685',54,0,'280','1'),('1686',69,0,'280','1'),('1687',70,0,'280','0'),('1688',71,0,'280','0'),('1689',138,0,'280','1'),('1690',139,0,'280','1'),('1691',46,0,'281','1'),('1692',54,0,'281','1'),('1693',69,0,'281','1'),('1694',70,0,'281','0'),('1695',71,0,'281','0'),('1696',138,0,'281','1'),('1697',139,0,'281','1'),('1698',46,0,'282','1'),('1699',54,0,'282','1'),('1700',69,0,'282','1'),('1701',70,0,'282','0'),('1702',71,0,'282','0'),('1703',138,0,'282','1'),('1704',139,0,'282','1'),('1705',46,0,'283','1'),('1706',54,0,'283','1'),('1707',69,0,'283','1'),('1708',70,0,'283','0'),('1709',71,0,'283','0'),('1710',138,0,'283','1'),('1711',139,0,'283','1'),('1712',46,0,'284','1'),('1713',54,0,'284','1'),('1714',69,0,'284','1'),('1715',70,0,'284','0'),('1716',71,0,'284','0'),('1717',138,0,'284','1'),('1718',139,0,'284','1'),('1719',46,0,'285','1'),('1720',54,0,'285','1'),('1721',69,0,'285','1'),('1722',70,0,'285','0'),('1723',71,0,'285','0'),('1724',138,0,'285','1'),('1725',139,0,'285','1'),('1726',46,0,'286','1'),('1727',54,0,'286','1'),('1728',69,0,'286','1'),('1729',70,0,'286','0'),('1730',71,0,'286','0'),('1731',138,0,'286','1'),('1732',139,0,'286','1'),('1733',46,0,'287','1'),('1734',54,0,'287','1'),('1735',69,0,'287','1'),('1736',70,0,'287','0'),('1737',71,0,'287','0'),('1738',138,0,'287','1'),('1739',139,0,'287','1'),('1740',46,0,'288','1'),('1741',54,0,'288','1'),('1742',69,0,'288','1'),('1743',70,0,'288','0'),('1744',71,0,'288','0'),('1745',138,0,'288','1'),('1746',139,0,'288','1'),('1747',46,0,'289','1'),('1748',54,0,'289','1'),('1749',69,0,'289','1'),('1750',70,0,'289','0'),('1751',71,0,'289','0'),('1752',138,0,'289','1'),('1753',139,0,'289','1'),('1754',46,0,'290','1'),('1755',54,0,'290','1'),('1756',69,0,'290','1'),('1757',70,0,'290','0'),('1758',71,0,'290','0'),('1759',138,0,'290','1'),('1760',139,0,'290','1'),('1761',46,0,'291','1'),('1762',54,0,'291','1'),('1763',69,0,'291','1'),('1764',70,0,'291','0'),('1765',71,0,'291','0'),('1766',138,0,'291','1'),('1767',139,0,'291','1'),('1768',46,0,'292','1'),('1769',54,0,'292','1'),('1770',69,0,'292','1'),('1771',70,0,'292','0'),('1772',71,0,'292','0'),('1773',138,0,'292','1'),('1774',139,0,'292','1'),('1775',46,0,'293','1'),('1776',54,0,'293','1'),('1777',69,0,'293','1'),('1778',70,0,'293','0'),('1779',71,0,'293','0'),('1780',138,0,'293','1'),('1781',139,0,'293','1'),('1782',46,0,'294','1'),('1783',54,0,'294','1'),('1784',69,0,'294','1'),('1785',70,0,'294','0'),('1786',71,0,'294','0'),('1787',138,0,'294','1'),('1788',139,0,'294','1'),('1789',46,0,'295','1'),('1790',54,0,'295','1'),('1791',69,0,'295','1'),('1792',70,0,'295','0'),('1793',71,0,'295','0'),('1794',138,0,'295','1'),('1795',139,0,'295','1'),('1796',46,0,'296','1'),('1797',54,0,'296','1'),('1798',69,0,'296','1'),('1799',70,0,'296','0'),('1800',71,0,'296','0'),('1801',138,0,'296','1'),('1802',139,0,'296','1'),('1810',46,0,'298','1'),('1811',54,0,'298','1'),('1812',69,0,'298','1'),('1813',70,0,'298','0'),('1814',71,0,'298','0'),('1815',138,0,'298','1'),('1816',139,0,'298','1'),('1817',46,0,'299','1'),('1818',54,0,'299','1'),('1819',69,0,'299','1'),('1820',70,0,'299','0'),('1821',71,0,'299','0'),('1822',138,0,'299','1'),('1823',139,0,'299','1'),('1824',46,0,'300','1'),('1825',54,0,'300','1'),('1826',69,0,'300','1'),('1827',70,0,'300','0'),('1828',71,0,'300','0'),('1829',138,0,'300','1'),('1830',139,0,'300','1'),('1838',46,0,'302','1'),('1839',54,0,'302','1'),('1840',69,0,'302','1'),('1841',70,0,'302','0'),('1842',71,0,'302','0'),('1843',138,0,'302','1'),('1844',139,0,'302','1'),('1845',141,0,'260','1'),('1846',141,0,'261','1'),('1847',141,0,'262','1'),('1848',46,0,'303','1'),('1849',54,0,'303','1'),('1850',69,0,'303','1'),('1851',70,0,'303','0'),('1852',71,0,'303','0'),('1853',138,0,'303','1'),('1854',139,0,'303','1'),('1855',141,0,'303','1'),('1856',46,0,'304','1'),('1857',54,0,'304','1'),('1858',69,0,'304','1'),('1859',70,0,'304','0'),('1860',71,0,'304','0'),('1861',138,0,'304','1'),('1862',139,0,'304','1'),('1863',141,0,'304','1'),('1864',46,0,'305','1'),('1865',54,0,'305','1'),('1866',69,0,'305','1'),('1867',70,0,'305','0'),('1868',71,0,'305','0'),('1869',138,0,'305','1'),('1870',139,0,'305','1'),('1871',141,0,'305','1'),('1872',46,0,'306','1'),('1873',54,0,'306','1'),('1874',69,0,'306','1'),('1875',70,0,'306','0'),('1876',71,0,'306','0'),('1877',138,0,'306','1'),('1878',139,0,'306','1'),('1879',141,0,'306','1'),('1880',46,0,'307','1'),('1881',54,0,'307','1'),('1882',69,0,'307','1'),('1883',70,0,'307','0'),('1884',71,0,'307','0'),('1885',138,0,'307','1'),('1886',139,0,'307','1'),('1887',141,0,'307','1'),('1888',46,0,'308','1'),('1889',54,0,'308','1'),('1890',69,0,'308','1'),('1891',70,0,'308','0'),('1892',71,0,'308','0'),('1893',138,0,'308','1'),('1894',139,0,'308','1'),('1895',141,0,'308','1'),('1896',46,0,'309','1'),('1897',54,0,'309','1'),('1898',69,0,'309','1'),('1899',70,0,'309','0'),('1900',71,0,'309','0'),('1901',138,0,'309','1'),('1902',139,0,'309','1'),('1903',141,0,'309','1'),('1904',46,0,'310','1'),('1905',54,0,'310','1'),('1906',69,0,'310','1'),('1907',70,0,'310','0'),('1908',71,0,'310','0'),('1909',138,0,'310','1'),('1910',139,0,'310','1'),('1911',141,0,'310','1'),('1912',46,0,'311','1'),('1913',54,0,'311','1'),('1914',69,0,'311','1'),('1915',70,0,'311','0'),('1916',71,0,'311','0'),('1917',138,0,'311','1'),('1918',139,0,'311','1'),('1919',141,0,'311','1'),('1920',46,0,'312','1'),('1921',54,0,'312','1'),('1922',69,0,'312','1'),('1923',70,0,'312','0'),('1924',71,0,'312','0'),('1925',138,0,'312','1'),('1926',139,0,'312','1'),('1927',141,0,'312','1'),('1928',46,0,'313','1'),('1929',54,0,'313','1'),('1930',69,0,'313','1'),('1931',70,0,'313','0'),('1932',71,0,'313','0'),('1933',138,0,'313','1'),('1934',139,0,'313','1'),('1935',141,0,'313','1'),('1936',46,0,'314','1'),('1937',54,0,'314','1'),('1938',69,0,'314','1'),('1939',70,0,'314','0'),('1940',71,0,'314','0'),('1941',138,0,'314','1'),('1942',139,0,'314','1'),('1943',141,0,'314','1'),('1944',46,0,'315','1'),('1945',54,0,'315','1'),('1946',69,0,'315','1'),('1947',70,0,'315','0'),('1948',71,0,'315','0'),('1949',138,0,'315','1'),('1950',139,0,'315','1'),('1951',141,0,'315','1'),('1952',46,0,'316','1'),('1953',54,0,'316','1'),('1954',69,0,'316','1'),('1955',70,0,'316','0'),('1956',71,0,'316','0'),('1957',138,0,'316','1'),('1958',139,0,'316','1'),('1959',141,0,'316','1'),('1960',46,0,'317','1'),('1961',54,0,'317','1'),('1962',69,0,'317','1'),('1963',70,0,'317','0'),('1964',71,0,'317','0'),('1965',138,0,'317','1'),('1966',139,0,'317','1'),('1967',141,0,'317','1'),('1968',46,0,'318','1'),('1969',54,0,'318','1'),('1970',69,0,'318','1'),('1971',70,0,'318','0'),('1972',71,0,'318','0'),('1973',138,0,'318','1'),('1974',139,0,'318','1'),('1975',141,0,'318','1'),('1976',46,0,'319','1'),('1977',54,0,'319','1'),('1978',69,0,'319','1'),('1979',70,0,'319','0'),('1980',71,0,'319','0'),('1981',138,0,'319','1'),('1982',139,0,'319','1'),('1983',141,0,'319','1'),('1992',46,0,'321','1'),('1993',54,0,'321','1'),('1994',69,0,'321','1'),('1995',70,0,'321','0'),('1996',71,0,'321','0'),('1997',138,0,'321','1'),('1998',139,0,'321','1'),('1999',141,0,'321','1'),('2000',46,0,'322','1'),('2001',54,0,'322','1'),('2002',69,0,'322','1'),('2003',70,0,'322','0'),('2004',71,0,'322','0'),('2005',138,0,'322','1'),('2006',139,0,'322','1'),('2007',141,0,'322','1'),('2008',46,0,'323','1'),('2009',54,0,'323','1'),('2010',69,0,'323','1'),('2011',70,0,'323','0'),('2012',71,0,'323','0'),('2013',138,0,'323','1'),('2014',139,0,'323','1'),('2015',141,0,'323','1'),('2016',46,0,'324','1'),('2017',54,0,'324','1'),('2018',69,0,'324','1'),('2019',70,0,'324','0'),('2020',71,0,'324','0'),('2021',138,0,'324','1'),('2022',139,0,'324','1'),('2023',141,0,'324','1'),('2024',46,0,'325','1'),('2025',54,0,'325','1'),('2026',69,0,'325','1'),('2027',70,0,'325','0'),('2028',71,0,'325','0'),('2029',138,0,'325','1'),('2030',139,0,'325','1'),('2031',141,0,'325','1'),('2032',46,0,'326','1'),('2033',54,0,'326','1'),('2034',69,0,'326','1'),('2035',70,0,'326','0'),('2036',71,0,'326','0'),('2037',138,0,'326','1'),('2038',139,0,'326','1'),('2039',141,0,'326','1'),('2040',46,0,'327','1'),('2041',54,0,'327','1'),('2042',69,0,'327','1'),('2043',70,0,'327','0'),('2044',71,0,'327','0'),('2045',138,0,'327','1'),('2046',139,0,'327','1'),('2047',141,0,'327','1'),('2048',46,0,'328','1'),('2049',54,0,'328','1'),('2050',69,0,'328','1'),('2051',70,0,'328','0'),('2052',71,0,'328','0'),('2053',138,0,'328','1'),('2054',139,0,'328','1'),('2055',141,0,'328','1'),('2056',46,0,'329','1'),('2057',54,0,'329','1'),('2058',69,0,'329','1'),('2059',70,0,'329','0'),('2060',71,0,'329','0'),('2061',138,0,'329','1'),('2062',139,0,'329','1'),('2063',141,0,'329','1'),('2064',46,0,'330','1'),('2065',54,0,'330','1'),('2066',69,0,'330','1'),('2067',70,0,'330','0'),('2068',71,0,'330','0'),('2069',138,0,'330','1'),('2070',139,0,'330','1'),('2071',141,0,'330','1');
/*!40000 ALTER TABLE `catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Text Attribute Backend Table';

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1633 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Varchar Attribute Backend Table';

--
-- Dumping data for table `catalog_category_entity_varchar`
--

LOCK TABLES `catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_varchar` VALUES ('1',45,0,'1','Root Catalog'),('2',45,0,'2','Jewelry Category'),('3',52,0,'2','PRODUCTS'),('294',117,0,'2','fashion-category'),('581',45,0,'147','Shop'),('582',52,0,'147','PRODUCTS'),('583',117,0,'147','smart-phone'),('584',118,0,'147','smart-phone'),('585',45,0,'148','New'),('586',52,0,'148','PRODUCTS'),('587',117,0,'148','destop'),('588',118,0,'148','destop'),('745',45,0,'188','Beds'),('746',52,0,'188','PRODUCTS'),('747',117,0,'188','apple-phones'),('748',118,0,'188','smart-phone/apple-phones'),('787',45,0,'189','modern beds'),('788',52,0,'189','PRODUCTS'),('789',117,0,'189','motorola-phones'),('790',118,0,'189','smart-phone/motorola-phones'),('791',45,0,'190','Weathered'),('792',52,0,'190','PRODUCTS'),('793',117,0,'190','samsung-phones'),('794',118,0,'190','smart-phone/samsung-phones'),('795',45,0,'191','Platform Beds'),('796',52,0,'191','PRODUCTS'),('797',117,0,'191','iphone-6s-plus'),('798',118,0,'191','smart-phone/apple-phones/iphone-6s-plus'),('799',45,0,'192','Storage Beds'),('800',52,0,'192','PRODUCTS'),('801',117,0,'192','iphone-6s'),('802',118,0,'192','smart-phone/apple-phones/iphone-6s'),('803',45,0,'193','Regular Beds'),('804',52,0,'193','PRODUCTS'),('805',117,0,'193','ipad-pro'),('806',118,0,'193','smart-phone/apple-phones/ipad-pro'),('807',45,0,'194','Sleigh Beds'),('808',52,0,'194','PRODUCTS'),('809',117,0,'194','ipad-mini-4'),('810',118,0,'194','smart-phone/apple-phones/ipad-mini-4'),('811',45,0,'195','Nightstands'),('812',52,0,'195','PRODUCTS'),('813',117,0,'195','droid-turbo-2'),('814',118,0,'195','smart-phone/motorola-phones/droid-turbo-2'),('815',45,0,'196','Brown Finish'),('816',52,0,'196','PRODUCTS'),('817',117,0,'196','moto-x-style'),('818',118,0,'196','smart-phone/motorola-phones/moto-x-style'),('819',45,0,'197','Distressed'),('820',52,0,'197','PRODUCTS'),('821',117,0,'197','moto-x-play-dual-sim'),('822',118,0,'197','smart-phone/motorola-phones/moto-x-play-dual-sim'),('823',45,0,'198','Cherry Finish'),('824',52,0,'198','PRODUCTS'),('825',117,0,'198','moto-360-sport-1st-gen'),('826',118,0,'198','smart-phone/motorola-phones/moto-360-sport-1st-gen'),('827',45,0,'199','Laundry'),('828',52,0,'199','PRODUCTS'),('829',117,0,'199','galaxy-note5-cdma'),('830',118,0,'199','smart-phone/samsung-phones/galaxy-note5-cdma'),('831',45,0,'200','Headboards'),('832',52,0,'200','PRODUCTS'),('833',117,0,'200','galaxy-note5-duos'),('834',118,0,'200','smart-phone/samsung-phones/galaxy-note5-duos'),('835',45,0,'201','Upholstered'),('836',52,0,'201','PRODUCTS'),('837',117,0,'201','galaxy-tab-s2-9-7'),('838',118,0,'201','smart-phone/samsung-phones/galaxy-tab-s2-9-7'),('839',45,0,'202','Tufted'),('840',52,0,'202','PRODUCTS'),('841',117,0,'202','galaxy-j7'),('842',118,0,'202','smart-phone/samsung-phones/galaxy-j7'),('843',45,0,'203','Towers Only'),('844',52,0,'203','PRODUCTS'),('845',117,0,'203','towers-only'),('846',118,0,'203','destop/towers-only'),('847',45,0,'204','Ottomans'),('848',52,0,'204','PRODUCTS'),('849',117,0,'204','gaming-desktops'),('850',118,0,'204','destop/gaming-desktops'),('851',45,0,'205','On Sale'),('852',52,0,'205','PRODUCTS'),('853',117,0,'205','on-sale'),('854',118,0,'205','destop/towers-only/on-sale'),('855',45,0,'206','Sink'),('856',52,0,'206','PRODUCTS'),('857',117,0,'206','free-shipping-eligible'),('858',118,0,'206','destop/towers-only/free-shipping-eligible'),('859',45,0,'207','Clearance'),('860',52,0,'207','PRODUCTS'),('861',117,0,'207','clearance'),('862',118,0,'207','destop/towers-only/clearance'),('863',45,0,'208','3D-Capable'),('864',52,0,'208','PRODUCTS'),('865',117,0,'208','3d-capable'),('866',118,0,'208','destop/towers-only/3d-capable'),('867',45,0,'209','ibuypower'),('868',52,0,'209','PRODUCTS'),('869',117,0,'209','ibuypower'),('870',118,0,'209','destop/gaming-desktops/ibuypower'),('871',45,0,'210','Storage'),('872',52,0,'210','PRODUCTS'),('873',117,0,'210','erazer-x315-desktop'),('874',118,0,'210','destop/gaming-desktops/erazer-x315-desktop'),('875',45,0,'211','padded'),('876',52,0,'211','PRODUCTS'),('877',117,0,'211','gamer-ultra-desktop'),('878',118,0,'211','destop/gaming-desktops/gamer-ultra-desktop'),('879',45,0,'212','Outdoor'),('880',52,0,'212','PRODUCTS'),('881',117,0,'212','alpha-desktop'),('882',118,0,'212','destop/gaming-desktops/alpha-desktop'),('1063',118,1,'188','smart-phone/apple-phones'),('1064',118,1,'189','smart-phone/motorola-phones'),('1065',118,1,'190','smart-phone/samsung-phones'),('1066',118,1,'191','smart-phone/apple-phones/iphone-6s-plus'),('1067',118,1,'192','smart-phone/apple-phones/iphone-6s'),('1068',118,1,'193','smart-phone/apple-phones/ipad-pro'),('1069',118,1,'194','smart-phone/apple-phones/ipad-mini-4'),('1070',118,1,'195','smart-phone/motorola-phones/droid-turbo-2'),('1071',118,1,'196','smart-phone/motorola-phones/moto-x-style'),('1072',118,1,'197','smart-phone/motorola-phones/moto-x-play-dual-sim'),('1073',118,1,'198','smart-phone/motorola-phones/moto-360-sport-1st-gen'),('1074',118,1,'199','smart-phone/samsung-phones/galaxy-note5-cdma'),('1075',118,1,'200','smart-phone/samsung-phones/galaxy-note5-duos'),('1076',118,1,'201','smart-phone/samsung-phones/galaxy-tab-s2-9-7'),('1077',118,1,'202','smart-phone/samsung-phones/galaxy-j7'),('1079',118,1,'203','destop/towers-only'),('1080',118,1,'204','destop/gaming-desktops'),('1081',118,1,'205','destop/towers-only/on-sale'),('1082',118,1,'206','destop/towers-only/free-shipping-eligible'),('1083',118,1,'207','destop/towers-only/clearance'),('1084',118,1,'208','destop/towers-only/3d-capable'),('1085',118,1,'209','destop/gaming-desktops/ibuypower'),('1086',118,1,'210','destop/gaming-desktops/erazer-x315-desktop'),('1087',118,1,'211','destop/gaming-desktops/gamer-ultra-desktop'),('1088',118,1,'212','destop/gaming-desktops/alpha-desktop'),('1089',45,0,'213','Shoe Category'),('1090',52,0,'213','PRODUCTS'),('1091',117,0,'213','shoe-category'),('1092',45,0,'214','Shop new'),('1093',52,0,'214','PRODUCTS'),('1094',117,0,'214','shop-new'),('1095',118,0,'214','shop-new'),('1096',45,0,'215','Men\'s'),('1097',52,0,'215','PRODUCTS'),('1098',117,0,'215','men-s'),('1099',118,0,'215','men-s'),('1100',45,0,'216',' Women\'s'),('1101',52,0,'216','PRODUCTS'),('1102',117,0,'216','women-s'),('1103',118,0,'216','women-s'),('1104',45,0,'217','Dresses'),('1105',52,0,'217','PRODUCTS'),('1106',117,0,'217','dresses'),('1107',118,0,'217','shop-new/dresses'),('1108',45,0,'218','shoes'),('1109',52,0,'218','PRODUCTS'),('1110',117,0,'218','shoes'),('1111',118,0,'218','shop-new/shoes'),('1112',45,0,'219','Handbags'),('1113',52,0,'219','PRODUCTS'),('1114',117,0,'219','handbags'),('1115',118,0,'219','shop-new/handbags'),('1116',45,0,'220','Cocktail'),('1117',52,0,'220','PRODUCTS'),('1118',117,0,'220','cocktail'),('1119',118,0,'220','shop-new/dresses/cocktail'),('1120',45,0,'221','Day'),('1121',52,0,'221','PRODUCTS'),('1122',117,0,'221','day'),('1123',118,0,'221','shop-new/dresses/day'),('1124',45,0,'222','Evening'),('1125',52,0,'222','PRODUCTS'),('1126',117,0,'222','evening'),('1127',118,0,'222','shop-new/dresses/evening'),('1128',45,0,'223','Sports'),('1129',52,0,'223','PRODUCTS'),('1130',117,0,'223','sports'),('1131',118,0,'223','shop-new/dresses/sports'),('1132',45,0,'224','Sports'),('1133',52,0,'224','PRODUCTS'),('1134',117,0,'224','sports'),('1135',118,0,'224','shop-new/shoes/sports'),('1137',45,0,'225','run'),('1138',52,0,'225','PRODUCTS'),('1139',117,0,'225','run'),('1140',118,0,'225','shop-new/shoes/run'),('1141',45,0,'226','sandals'),('1142',52,0,'226','PRODUCTS'),('1143',117,0,'226','sandals'),('1144',118,0,'226','shop-new/shoes/sandals'),('1145',45,0,'227','Books'),('1146',52,0,'227','PRODUCTS'),('1147',117,0,'227','books'),('1148',118,0,'227','shop-new/shoes/books'),('1149',45,0,'228','Blazers'),('1150',52,0,'228','PRODUCTS'),('1151',117,0,'228','blazers'),('1152',118,0,'228','shop-new/handbags/blazers'),('1153',45,0,'229','table'),('1154',52,0,'229','PRODUCTS'),('1155',117,0,'229','table'),('1156',118,0,'229','shop-new/handbags/table'),('1157',45,0,'230','coats'),('1158',52,0,'230','PRODUCTS'),('1159',117,0,'230','coats'),('1160',118,0,'230','shop-new/handbags/coats'),('1161',45,0,'231','kids'),('1162',52,0,'231','PRODUCTS'),('1163',117,0,'231','kids'),('1164',118,0,'231','shop-new/handbags/kids'),('1165',45,0,'232','Bootees Bags'),('1166',52,0,'232','PRODUCTS'),('1167',117,0,'232','bootees-bags'),('1168',118,0,'232','men-s/bootees-bags'),('1169',45,0,'233','Camcorders'),('1170',52,0,'233','PRODUCTS'),('1171',117,0,'233','camcorders'),('1172',118,0,'233','men-s/camcorders'),('1173',45,0,'234','Blazers'),('1174',52,0,'234','PRODUCTS'),('1175',117,0,'234','blazers'),('1176',118,0,'234','men-s/blazers'),('1177',45,0,'235','Vantech'),('1178',52,0,'235','PRODUCTS'),('1179',117,0,'235','vantech'),('1180',118,0,'235','men-s/bootees-bags/vantech'),('1181',45,0,'236','Snm'),('1182',52,0,'236','PRODUCTS'),('1183',117,0,'236','snm'),('1184',118,0,'236','men-s/bootees-bags/snm'),('1185',45,0,'237','Questek'),('1186',52,0,'237','PRODUCTS'),('1187',117,0,'237','questek'),('1188',118,0,'237','men-s/bootees-bags/questek'),('1189',45,0,'238','Gold eye'),('1190',52,0,'238','PRODUCTS'),('1191',117,0,'238','gold-eye'),('1192',118,0,'238','men-s/bootees-bags/gold-eye'),('1193',45,0,'239','gopro hero4'),('1194',52,0,'239','PRODUCTS'),('1195',117,0,'239','gopro-hero4'),('1196',118,0,'239','men-s/camcorders/gopro-hero4'),('1197',45,0,'240','vixia hf r600'),('1198',52,0,'240','PRODUCTS'),('1199',117,0,'240','vixia-hf-r600'),('1200',118,0,'240','men-s/camcorders/vixia-hf-r600'),('1201',45,0,'241','handycam cx405'),('1202',52,0,'241','PRODUCTS'),('1203',117,0,'241','handycam-cx405'),('1204',118,0,'241','men-s/camcorders/handycam-cx405'),('1205',45,0,'242','cube lifestyle hd'),('1206',52,0,'242','PRODUCTS'),('1207',117,0,'242','cube-lifestyle-hd'),('1208',118,0,'242','men-s/camcorders/cube-lifestyle-hd'),('1209',45,0,'243','Cords and Cables'),('1210',52,0,'243','PRODUCTS'),('1211',117,0,'243','cords-and-cables'),('1212',118,0,'243','men-s/blazers/cords-and-cables'),('1213',45,0,'244','Microphones'),('1214',52,0,'244','PRODUCTS'),('1215',117,0,'244','microphones'),('1216',118,0,'244','men-s/blazers/microphones'),('1217',45,0,'245','gps accessories'),('1218',52,0,'245','PRODUCTS'),('1219',117,0,'245','gps-accessories'),('1220',118,0,'245','men-s/blazers/gps-accessories'),('1221',45,0,'246','Wireless Transmitters'),('1222',52,0,'246','PRODUCTS'),('1223',117,0,'246','wireless-transmitters'),('1224',118,0,'246','men-s/blazers/wireless-transmitters'),('1225',45,0,'247','Towers Only'),('1226',52,0,'247','PRODUCTS'),('1227',117,0,'247','towers-only'),('1228',118,0,'247','women-s/towers-only'),('1229',45,0,'248','Footwear Womens'),('1230',52,0,'248','PRODUCTS'),('1231',117,0,'248','footwear-womens'),('1232',118,0,'248','women-s/footwear-womens'),('1233',45,0,'249','On Sale'),('1234',52,0,'249','PRODUCTS'),('1235',117,0,'249','on-sale'),('1236',118,0,'249','women-s/footwear-womens/on-sale'),('1237',45,0,'250','Free Shipping'),('1238',52,0,'250','PRODUCTS'),('1239',117,0,'250','free-shipping'),('1240',118,0,'250','women-s/footwear-womens/free-shipping'),('1241',45,0,'251','Clearance'),('1242',52,0,'251','PRODUCTS'),('1243',117,0,'251','clearance'),('1244',118,0,'251','women-s/footwear-womens/clearance'),('1245',45,0,'252','3D-Capable'),('1246',52,0,'252','PRODUCTS'),('1247',117,0,'252','3d-capable'),('1248',118,0,'252','women-s/towers-only/3d-capable'),('1249',45,0,'253','ibuypower'),('1250',52,0,'253','PRODUCTS'),('1251',117,0,'253','ibuypower'),('1252',118,0,'253','women-s/towers-only/ibuypower'),('1253',45,0,'254','Erazer X315 Desktop'),('1254',52,0,'254','PRODUCTS'),('1255',117,0,'254','erazer-x315-desktop'),('1256',118,0,'254','women-s/towers-only/erazer-x315-desktop'),('1257',45,0,'255','Furniture category'),('1258',52,0,'255','PRODUCTS'),('1259',117,0,'255','furniture-category'),('1260',45,0,'256','Living Room'),('1261',52,0,'256','PRODUCTS'),('1262',117,0,'256','living-room'),('1263',118,0,'256','living-room'),('1264',45,0,'257','Wardrobe'),('1265',52,0,'257','PRODUCTS'),('1266',117,0,'257','wardrobe'),('1267',118,0,'257','wardrobe'),('1268',45,0,'258','Dining Room'),('1269',52,0,'258','PRODUCTS'),('1270',117,0,'258','dining-room'),('1271',118,0,'258','dining-room'),('1278',45,0,'260','weaters'),('1279',52,0,'260','PRODUCTS'),('1280',117,0,'260','weaters'),('1281',118,0,'260','living-room/weaters'),('1282',45,0,'261','Crochet'),('1283',52,0,'261','PRODUCTS'),('1284',117,0,'261','crochet'),('1285',118,0,'261','living-room/crochet'),('1286',45,0,'262','Sleeveless'),('1287',52,0,'262','PRODUCTS'),('1288',117,0,'262','sleeveless'),('1289',118,0,'262','living-room/sleeveless'),('1290',45,0,'263','Stripes'),('1291',52,0,'263','PRODUCTS'),('1292',117,0,'263','stripes'),('1293',118,0,'263','living-room/sleeveless/stripes'),('1294',45,0,'264','Sweaters'),('1295',52,0,'264','PRODUCTS'),('1296',117,0,'264','sweaters'),('1297',118,0,'264','living-room/sleeveless/sweaters'),('1298',45,0,'265','hoodies'),('1299',52,0,'265','PRODUCTS'),('1300',117,0,'265','hoodies'),('1301',118,0,'265','living-room/sleeveless/hoodies'),('1302',45,0,'266','Bottoms'),('1303',52,0,'266','PRODUCTS'),('1304',117,0,'266','bottoms'),('1305',118,0,'266','living-room/sleeveless/bottoms'),('1306',45,0,'267','Heeled'),('1307',52,0,'267','PRODUCTS'),('1308',117,0,'267','heeled'),('1309',118,0,'267','living-room/sleeveless/heeled'),('1310',45,0,'268','sandals'),('1311',52,0,'268','PRODUCTS'),('1312',117,0,'268','sandals'),('1313',118,0,'268','living-room/crochet/sandals'),('1314',45,0,'269','Polo Short Sleeve'),('1315',52,0,'269','PRODUCTS'),('1316',117,0,'269','polo-short-sleeve'),('1317',118,0,'269','living-room/crochet/polo-short-sleeve'),('1318',45,0,'270','Flat sandals'),('1319',52,0,'270','PRODUCTS'),('1320',117,0,'270','flat-sandals'),('1321',118,0,'270','living-room/crochet/flat-sandals'),('1322',45,0,'271','Short Sleeve'),('1323',52,0,'271','PRODUCTS'),('1324',117,0,'271','short-sleeve'),('1325',118,0,'271','living-room/crochet/short-sleeve'),('1326',45,0,'272','Long Sleeve'),('1327',52,0,'272','PRODUCTS'),('1328',117,0,'272','long-sleeve'),('1329',118,0,'272','living-room/crochet/long-sleeve'),('1330',45,0,'273','Polo Short Sleeve '),('1331',52,0,'273','PRODUCTS'),('1332',117,0,'273','polo-short-sleeve'),('1333',118,0,'273','living-room/weaters/polo-short-sleeve'),('1334',45,0,'274','Sleeveless '),('1335',52,0,'274','PRODUCTS'),('1336',117,0,'274','sleeveless'),('1337',118,0,'274','living-room/weaters/sleeveless'),('1338',45,0,'275','Graphic T-Shirts '),('1339',52,0,'275','PRODUCTS'),('1340',117,0,'275','graphic-t-shirts'),('1341',118,0,'275','living-room/weaters/graphic-t-shirts'),('1342',45,0,'276','Hoodies'),('1343',52,0,'276','PRODUCTS'),('1344',117,0,'276','hoodies'),('1345',118,0,'276','living-room/weaters/hoodies'),('1346',45,0,'277','Crochet'),('1347',52,0,'277','PRODUCTS'),('1348',117,0,'277','crochet'),('1349',118,0,'277','living-room/weaters/crochet'),('1350',45,0,'278','Sleeveless'),('1351',52,0,'278','PRODUCTS'),('1352',117,0,'278','sleeveless'),('1353',118,0,'278','wardrobe/sleeveless'),('1354',45,0,'279','Stripes'),('1355',52,0,'279','PRODUCTS'),('1356',117,0,'279','stripes'),('1357',118,0,'279','wardrobe/stripes'),('1358',45,0,'280','hoodies'),('1359',52,0,'280','PRODUCTS'),('1360',117,0,'280','hoodies'),('1361',118,0,'280','wardrobe/hoodies'),('1362',45,0,'281','Tops  Tees'),('1363',52,0,'281','PRODUCTS'),('1364',117,0,'281','tops-tees'),('1365',118,0,'281','wardrobe/hoodies/tops-tees'),('1366',45,0,'282','Polo Short Sleeve'),('1367',52,0,'282','PRODUCTS'),('1368',117,0,'282','polo-short-sleeve'),('1369',118,0,'282','wardrobe/hoodies/polo-short-sleeve'),('1370',45,0,'283','Graphic T-Shirts'),('1371',52,0,'283','PRODUCTS'),('1372',117,0,'283','graphic-t-shirts'),('1373',118,0,'283','wardrobe/hoodies/graphic-t-shirts'),('1374',45,0,'284','Coats'),('1375',52,0,'284','PRODUCTS'),('1376',117,0,'284','coats'),('1377',118,0,'284','wardrobe/hoodies/coats'),('1378',45,0,'285','Fashion Jackets'),('1379',52,0,'285','PRODUCTS'),('1380',117,0,'285','fashion-jackets'),('1381',118,0,'285','wardrobe/stripes/fashion-jackets'),('1382',45,0,'286','Heeled sandals'),('1383',52,0,'286','PRODUCTS'),('1384',117,0,'286','heeled-sandals'),('1385',118,0,'286','wardrobe/stripes/heeled-sandals'),('1386',45,0,'287','sandals Flat'),('1387',52,0,'287','PRODUCTS'),('1388',117,0,'287','sandals-flat'),('1389',118,0,'287','wardrobe/stripes/sandals-flat'),('1390',45,0,'288','Wedges'),('1391',52,0,'288','PRODUCTS'),('1392',117,0,'288','wedges'),('1393',118,0,'288','wardrobe/stripes/wedges'),('1394',45,0,'289','Wedges last'),('1395',52,0,'289','PRODUCTS'),('1396',117,0,'289','wedges-last'),('1397',118,0,'289','wardrobe/sleeveless/wedges-last'),('1398',45,0,'290','Coats & Jackets'),('1399',52,0,'290','PRODUCTS'),('1400',117,0,'290','coats-jackets'),('1401',118,0,'290','wardrobe/sleeveless/coats-jackets'),('1402',45,0,'291','Blazers'),('1403',52,0,'291','PRODUCTS'),('1404',117,0,'291','blazers'),('1405',118,0,'291','wardrobe/sleeveless/blazers'),('1406',45,0,'292','been'),('1407',52,0,'292','PRODUCTS'),('1408',117,0,'292','been'),('1409',118,0,'292','wardrobe/sleeveless/been'),('1410',45,0,'293','Jackets man'),('1411',52,0,'293','PRODUCTS'),('1412',117,0,'293','jackets-man'),('1413',118,0,'293','dining-room/jackets-man'),('1414',45,0,'294','Raincoats'),('1415',52,0,'294','PRODUCTS'),('1416',117,0,'294','raincoats'),('1417',118,0,'294','dining-room/raincoats'),('1418',45,0,'295','Trousers'),('1419',52,0,'295','PRODUCTS'),('1420',117,0,'295','trousers'),('1421',118,0,'295','dining-room/jackets-man/trousers'),('1422',45,0,'296','Long Sleeve '),('1423',52,0,'296','PRODUCTS'),('1424',117,0,'296','long-sleeve'),('1425',118,0,'296','dining-room/jackets-man/long-sleeve'),('1430',45,0,'298','Sleeveless'),('1431',52,0,'298','PRODUCTS'),('1432',117,0,'298','sleeveless'),('1433',118,0,'298','dining-room/jackets-man/sleeveless'),('1434',45,0,'299','Sleeve'),('1435',52,0,'299','PRODUCTS'),('1436',117,0,'299','sleeve'),('1437',118,0,'299','dining-room/raincoats/sleeve'),('1438',45,0,'300','Polo'),('1439',52,0,'300','PRODUCTS'),('1440',117,0,'300','polo'),('1441',118,0,'300','dining-room/raincoats/polo'),('1446',45,0,'302','Sleeve new'),('1447',52,0,'302','PRODUCTS'),('1448',117,0,'302','sleeve-new'),('1449',118,0,'302','dining-room/raincoats/sleeve-new'),('1456',140,0,'260','img1_top.jpg'),('1463',140,0,'261','img2_top.jpg'),('1470',140,0,'262','img3_top.jpg'),('1471',45,0,'303','Kitchenware Category'),('1472',52,0,'303','PRODUCTS'),('1473',117,0,'303','kitchenware-category'),('1474',45,0,'304','Shop'),('1475',52,0,'304','PRODUCTS'),('1476',117,0,'304','shop'),('1477',118,0,'304','shop'),('1478',45,0,'305','Electric'),('1479',52,0,'305','PRODUCTS'),('1480',117,0,'305','electric'),('1481',118,0,'305','electric'),('1482',45,0,'306','grinder'),('1483',52,0,'306','PRODUCTS'),('1484',117,0,'306','grinder'),('1485',118,0,'306','grinder'),('1486',45,0,'307','Cookware'),('1487',52,0,'307','PRODUCTS'),('1488',117,0,'307','shirt'),('1489',118,0,'307','shop/shirt'),('1490',45,0,'308','Bakeware'),('1491',52,0,'308','PRODUCTS'),('1492',117,0,'308','t-shirts1'),('1493',118,0,'308','shop/t-shirts1'),('1494',45,0,'309','Tabletop'),('1495',52,0,'309','PRODUCTS'),('1496',117,0,'309','jackets'),('1497',118,0,'309','shop/jackets'),('1498',45,0,'310','Appliances'),('1499',52,0,'310','PRODUCTS'),('1500',117,0,'310','jeans-pants'),('1501',118,0,'310','electric/jeans-pants'),('1502',45,0,'311','Glassware'),('1503',52,0,'311','PRODUCTS'),('1504',117,0,'311','sleeveless'),('1505',118,0,'311','electric/sleeveless'),('1506',45,0,'312','Wedges'),('1507',52,0,'312','PRODUCTS'),('1508',117,0,'312','wedges'),('1509',118,0,'312','electric/sleeveless/wedges'),('1510',45,0,'313','Ankle boots'),('1511',52,0,'313','PRODUCTS'),('1512',117,0,'313','ankle-boots'),('1513',118,0,'313','electric/sleeveless/ankle-boots'),('1514',45,0,'314','Hoodies'),('1515',52,0,'314','PRODUCTS'),('1516',117,0,'314','hoodies'),('1517',118,0,'314','electric/sleeveless/hoodies'),('1518',45,0,'315','Wedges'),('1519',52,0,'315','PRODUCTS'),('1520',117,0,'315','wedges'),('1521',118,0,'315','electric/jeans-pants/wedges'),('1522',45,0,'316','Shirts'),('1523',52,0,'316','PRODUCTS'),('1524',117,0,'316','shirts'),('1525',118,0,'316','electric/jeans-pants/shirts'),('1526',45,0,'317','Florals'),('1527',52,0,'317','PRODUCTS'),('1528',117,0,'317','florals'),('1529',118,0,'317','electric/jeans-pants/florals'),('1530',45,0,'318','Stripes'),('1531',52,0,'318','PRODUCTS'),('1532',117,0,'318','stripes'),('1533',118,0,'318','shop/shirt/stripes'),('1534',45,0,'319','Short Sleeve '),('1535',52,0,'319','PRODUCTS'),('1536',117,0,'319','short-sleeve'),('1537',118,0,'319','shop/shirt/short-sleeve'),('1542',45,0,'321','sandals'),('1543',52,0,'321','PRODUCTS'),('1544',117,0,'321','sandals'),('1545',118,0,'321','shop/shirt/sandals'),('1546',45,0,'322','Heeled1'),('1547',52,0,'322','PRODUCTS'),('1548',117,0,'322','heeled1'),('1549',118,0,'322','shop/t-shirts1/heeled1'),('1550',45,0,'323','Ankle'),('1551',52,0,'323','PRODUCTS'),('1552',117,0,'323','ankle'),('1553',118,0,'323','shop/shirt/ankle'),('1554',45,0,'324','Electtronic1'),('1555',52,0,'324','PRODUCTS'),('1556',117,0,'324','electtronic1'),('1557',118,0,'324','shop/t-shirts1/electtronic1'),('1558',45,0,'325','Soccer1'),('1559',52,0,'325','PRODUCTS'),('1560',117,0,'325','soccer1'),('1561',118,0,'325','shop/t-shirts1/soccer1'),('1562',45,0,'326','Shop Save'),('1563',52,0,'326','PRODUCTS'),('1564',117,0,'326','shop-save'),('1565',118,0,'326','shop/t-shirts1/shop-save'),('1566',45,0,'327','Michael Kors1'),('1567',52,0,'327','PRODUCTS'),('1568',117,0,'327','michael-kors1'),('1569',118,0,'327','shop/jackets/michael-kors1'),('1570',45,0,'328','shop 5ps'),('1571',52,0,'328','PRODUCTS'),('1572',117,0,'328','shop-5ps'),('1573',118,0,'328','shop/jackets/shop-5ps'),('1574',45,0,'329','New collection1'),('1575',52,0,'329','PRODUCTS'),('1576',117,0,'329','new-collection1'),('1577',118,0,'329','shop/jackets/new-collection1'),('1578',45,0,'330','Michael2'),('1579',52,0,'330','PRODUCTS'),('1580',117,0,'330','michael2'),('1581',118,0,'330','shop/jackets/michael2'),('1610',136,0,'307','1_1.png'),('1616',136,0,'308','2.png'),('1622',136,0,'309','3.png'),('1627',136,0,'310','4.png'),('1632',136,0,'311','5.png');
/*!40000 ALTER TABLE `catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
CREATE TABLE `catalog_category_product` (
  `entity_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=895 DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Category Linkage Table';

--
-- Dumping data for table `catalog_category_product`
--

LOCK TABLES `catalog_category_product` WRITE;
/*!40000 ALTER TABLE `catalog_category_product` DISABLE KEYS */;
INSERT INTO `catalog_category_product` VALUES ('120','2','21','1'),('138','2','1','1'),('157','2','2','1'),('164','147','2','1'),('165','148','2','1'),('171','188','2','1'),('172','189','2','1'),('173','190','2','1'),('174','2','7','1'),('178','147','7','1'),('179','148','7','1'),('191','147','9','1'),('192','148','9','1'),('194','2','10','1'),('209','2','17','1'),('224','2','18','1'),('228','147','18','1'),('229','148','18','1'),('237','2','19','1'),('241','147','19','1'),('242','148','19','1'),('244','2','20','1'),('255','148','20','1'),('258','147','22','1'),('259','148','22','1'),('264','2','23','1'),('271','2','24','1'),('278','2','25','1'),('282','2','26','1'),('286','2','27','1'),('297','2','28','1'),('299','147','28','1'),('300','148','28','1'),('362','147','1','1'),('363','148','1','1'),('364','188','1','1'),('365','189','1','1'),('366','190','1','1'),('367','203','1','1'),('368','204','1','1'),('369','203','2','1'),('370','204','2','1'),('371','188','7','1'),('372','189','7','1'),('373','204','7','1'),('374','2','9','1'),('375','188','9','1'),('376','189','9','1'),('377','190','9','1'),('378','203','9','1'),('379','204','9','1'),('380','191','9','1'),('381','192','9','1'),('382','193','9','1'),('383','195','9','1'),('384','196','9','1'),('385','147','10','1'),('386','148','10','1'),('387','188','10','1'),('388','189','10','1'),('389','190','10','1'),('390','203','10','1'),('391','204','10','1'),('392','191','10','1'),('393','195','10','1'),('394','196','10','1'),('395','199','10','1'),('396','200','10','1'),('397','205','10','1'),('398','207','10','1'),('399','209','10','1'),('400','210','10','1'),('401','147','17','1'),('402','148','17','1'),('403','188','17','1'),('404','189','17','1'),('405','190','17','1'),('406','203','17','1'),('407','204','17','1'),('408','191','17','1'),('409','192','17','1'),('410','195','17','1'),('411','197','17','1'),('412','205','17','1'),('413','206','17','1'),('414','209','17','1'),('415','210','17','1'),('416','211','17','1'),('417','188','18','1'),('418','189','18','1'),('419','190','18','1'),('420','203','18','1'),('421','204','18','1'),('422','192','18','1'),('423','195','18','1'),('424','196','18','1'),('425','199','18','1'),('426','200','18','1'),('427','205','18','1'),('428','206','18','1'),('429','188','19','1'),('430','189','19','1'),('431','190','19','1'),('432','203','19','1'),('433','204','19','1'),('434','191','19','1'),('435','192','19','1'),('436','205','19','1'),('437','206','19','1'),('438','207','19','1'),('439','209','19','1'),('440','210','19','1'),('441','147','20','1'),('442','188','20','1'),('443','189','20','1'),('444','190','20','1'),('445','203','20','1'),('446','204','20','1'),('447','191','20','1'),('448','193','20','1'),('449','147','21','1'),('450','148','21','1'),('451','188','21','1'),('452','189','21','1'),('453','190','21','1'),('454','203','21','1'),('455','204','21','1'),('456','191','21','1'),('457','205','21','1'),('458','209','21','1'),('459','2','22','1'),('460','188','22','1'),('461','189','22','1'),('462','190','22','1'),('463','203','22','1'),('464','204','22','1'),('465','191','22','1'),('466','192','22','1'),('467','193','22','1'),('468','195','22','1'),('469','196','22','1'),('470','147','23','1'),('471','148','23','1'),('472','188','23','1'),('473','189','23','1'),('474','190','23','1'),('475','203','23','1'),('476','204','23','1'),('477','191','23','1'),('478','197','23','1'),('479','199','23','1'),('480','200','23','1'),('481','205','23','1'),('482','147','24','1'),('483','148','24','1'),('484','188','24','1'),('485','189','24','1'),('486','190','24','1'),('487','203','24','1'),('488','204','24','1'),('489','191','24','1'),('490','192','24','1'),('491','147','25','1'),('492','148','25','1'),('493','188','25','1'),('494','189','25','1'),('495','190','25','1'),('496','203','25','1'),('497','204','25','1'),('498','191','25','1'),('499','195','25','1'),('500','199','25','1'),('501','147','26','1'),('502','148','26','1'),('503','188','26','1'),('504','189','26','1'),('505','190','26','1'),('506','203','26','1'),('507','204','26','1'),('508','147','27','1'),('509','148','27','1'),('510','188','27','1'),('511','189','27','1'),('512','190','27','1'),('513','203','27','1'),('514','204','27','1'),('515','191','27','1'),('516','194','27','1'),('517','205','27','1'),('518','208','27','1'),('519','209','27','1'),('520','210','27','1'),('521','188','28','1'),('522','189','28','1'),('523','213','29','1'),('524','214','29','1'),('525','215','29','1'),('526','216','29','1'),('527','217','29','1'),('528','218','29','1'),('529','219','29','1'),('530','232','29','1'),('531','234','29','1'),('532','247','29','1'),('533','248','29','1'),('534','213','30','1'),('535','214','30','1'),('536','215','30','1'),('537','216','30','1'),('538','218','30','1'),('539','219','30','1'),('540','232','30','1'),('541','233','30','1'),('542','247','30','1'),('543','248','30','1'),('544','213','31','1'),('545','214','31','1'),('546','215','31','1'),('547','216','31','1'),('548','217','31','1'),('549','218','31','1'),('550','219','31','1'),('551','232','31','1'),('552','233','31','1'),('553','247','31','1'),('554','248','31','1'),('555','213','32','1'),('556','214','32','1'),('557','215','32','1'),('558','216','32','1'),('559','218','32','1'),('560','219','32','1'),('561','232','32','1'),('562','233','32','1'),('563','213','33','1'),('564','214','33','1'),('565','215','33','1'),('566','216','33','1'),('567','217','33','1'),('568','218','33','1'),('569','232','33','1'),('570','233','33','1'),('571','213','34','1'),('572','214','34','1'),('573','215','34','1'),('574','216','34','1'),('575','218','34','1'),('576','219','34','1'),('577','233','34','1'),('578','248','34','1'),('579','213','35','1'),('580','214','35','1'),('581','215','35','1'),('582','216','35','1'),('583','218','35','1'),('584','219','35','1'),('585','233','35','1'),('586','234','35','1'),('587','247','35','1'),('588','213','36','1'),('589','214','36','1'),('590','215','36','1'),('591','216','36','1'),('592','218','36','1'),('593','219','36','1'),('594','232','36','1'),('595','233','36','1'),('596','247','36','1'),('597','213','37','1'),('598','214','37','1'),('599','215','37','1'),('600','216','37','1'),('601','217','37','1'),('602','218','37','1'),('603','233','37','1'),('604','234','37','1'),('605','247','37','1'),('606','248','37','1'),('607','213','48','1'),('608','214','48','1'),('609','215','48','1'),('610','216','48','1'),('611','217','48','1'),('612','219','48','1'),('613','232','48','1'),('614','233','48','1'),('615','247','48','1'),('616','213','49','1'),('617','214','49','1'),('618','215','49','1'),('619','216','49','1'),('620','217','49','1'),('621','232','49','1'),('622','213','50','1'),('623','214','50','1'),('624','215','50','1'),('625','216','50','1'),('626','217','50','1'),('627','218','50','1'),('628','233','50','1'),('629','247','50','1'),('630','255','51','1'),('631','256','51','1'),('632','257','51','1'),('633','258','51','1'),('635','260','51','1'),('636','261','51','1'),('637','262','51','1'),('638','278','51','1'),('639','279','51','1'),('640','280','51','1'),('641','255','52','1'),('642','256','52','1'),('643','257','52','1'),('644','258','52','1'),('646','260','52','1'),('647','278','52','1'),('648','279','52','1'),('649','280','52','1'),('650','293','52','1'),('651','294','52','1'),('652','255','53','1'),('653','256','53','1'),('654','257','53','1'),('655','258','53','1'),('657','260','53','1'),('658','262','53','1'),('659','279','53','1'),('660','280','53','1'),('661','293','53','1'),('662','294','53','1'),('663','255','54','1'),('664','256','54','1'),('665','257','54','1'),('666','258','54','1'),('668','260','54','1'),('669','261','54','1'),('670','278','54','1'),('671','279','54','1'),('672','293','54','1'),('673','294','54','1'),('674','255','55','1'),('675','256','55','1'),('676','257','55','1'),('677','258','55','1'),('679','260','55','1'),('680','261','55','1'),('681','262','55','1'),('682','278','55','1'),('683','279','55','1'),('684','255','56','1'),('685','256','56','1'),('686','257','56','1'),('687','258','56','1'),('689','260','56','1'),('690','261','56','1'),('691','279','56','1'),('692','293','56','1'),('693','294','56','1'),('694','255','57','1'),('695','256','57','1'),('696','257','57','1'),('697','258','57','1'),('699','260','57','1'),('700','261','57','1'),('701','278','57','1'),('702','279','57','1'),('703','293','57','1'),('704','294','57','1'),('705','255','58','1'),('706','256','58','1'),('707','257','58','1'),('708','258','58','1'),('710','260','58','1'),('711','261','58','1'),('712','278','58','1'),('713','279','58','1'),('714','293','58','1'),('715','294','58','1'),('716','255','59','1'),('717','256','59','1'),('718','257','59','1'),('719','258','59','1'),('721','260','59','1'),('722','261','59','1'),('723','262','59','1'),('724','293','59','1'),('725','294','59','1'),('726','255','60','1'),('727','256','60','1'),('728','257','60','1'),('729','258','60','1'),('731','260','60','1'),('732','261','60','1'),('733','279','60','1'),('734','280','60','1'),('735','293','60','1'),('736','294','60','1'),('737','255','61','1'),('738','256','61','1'),('739','257','61','1'),('740','258','61','1'),('742','260','61','1'),('743','261','61','1'),('744','262','61','1'),('745','255','62','1'),('746','256','62','1'),('747','257','62','1'),('748','258','62','1'),('750','303','63','1'),('751','304','63','1'),('752','305','63','1'),('753','306','63','1'),('754','307','63','1'),('755','308','63','1'),('756','309','63','1'),('757','310','63','1'),('758','311','63','1'),('759','303','64','1'),('760','304','64','1'),('761','305','64','1'),('762','306','64','1'),('763','307','64','1'),('764','308','64','1'),('765','309','64','1'),('766','310','64','1'),('767','311','64','1'),('768','318','64','1'),('769','319','64','1'),('770','303','65','1'),('771','304','65','1'),('772','305','65','1'),('773','306','65','1'),('774','307','65','1'),('775','309','65','1'),('776','310','65','1'),('777','311','65','1'),('778','315','65','1'),('779','318','65','1'),('780','319','65','1'),('781','303','67','1'),('782','304','67','1'),('783','305','67','1'),('784','306','67','1'),('785','308','67','1'),('786','309','67','1'),('787','310','67','1'),('788','311','67','1'),('789','322','67','1'),('790','324','67','1'),('791','327','67','1'),('792','329','67','1'),('793','303','68','1'),('794','304','68','1'),('795','305','68','1'),('796','306','68','1'),('797','308','68','1'),('798','309','68','1'),('799','310','68','1'),('800','311','68','1'),('801','319','68','1'),('802','327','68','1'),('803','328','68','1'),('804','303','69','1'),('805','304','69','1'),('806','305','69','1'),('807','306','69','1'),('808','308','69','1'),('809','309','69','1'),('810','310','69','1'),('811','311','69','1'),('812','322','69','1'),('813','303','70','1'),('814','304','70','1'),('815','305','70','1'),('816','306','70','1'),('817','308','70','1'),('818','309','70','1'),('819','310','70','1'),('820','311','70','1'),('821','315','70','1'),('822','318','70','1'),('823','321','70','1'),('824','322','70','1'),('825','324','70','1'),('826','303','71','1'),('827','304','71','1'),('828','305','71','1'),('829','306','71','1'),('830','309','71','1'),('831','310','71','1'),('832','311','71','1'),('833','315','71','1'),('834','316','71','1'),('835','328','71','1'),('836','329','71','1'),('837','303','72','1'),('838','304','72','1'),('839','305','72','1'),('840','306','72','1'),('841','308','72','1'),('842','309','72','1'),('843','310','72','1'),('844','311','72','1'),('845','327','72','1'),('846','328','72','1'),('847','303','73','1'),('848','304','73','1'),('849','305','73','1'),('850','306','73','1'),('851','307','73','1'),('852','308','73','1'),('853','310','73','1'),('854','311','73','1'),('855','303','74','1'),('856','304','74','1'),('857','305','74','1'),('858','306','74','1'),('859','307','74','1'),('860','308','74','1'),('861','310','74','1'),('862','311','74','1'),('863','312','74','1'),('864','313','74','1'),('865','315','74','1'),('866','316','74','1'),('867','303','75','1'),('868','304','75','1'),('869','305','75','1'),('870','306','75','1'),('871','308','75','1'),('872','309','75','1'),('873','310','75','1'),('874','324','75','1'),('875','328','75','1'),('876','329','75','1'),('877','303','76','1'),('878','304','76','1'),('879','305','76','1'),('880','306','76','1'),('881','307','76','1'),('882','308','76','1'),('883','309','76','1'),('884','310','76','1'),('885','311','76','1'),('886','303','77','1'),('887','304','77','1'),('888','305','77','1'),('889','306','77','1'),('890','307','77','1'),('891','308','77','1'),('892','309','77','1'),('893','310','77','1'),('894','311','77','1');
/*!40000 ALTER TABLE `catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';

--
-- Dumping data for table `catalog_category_product_index`
--

LOCK TABLES `catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index` VALUES ('2','1','10001',0,1,4),('2','2','10001',0,1,4),('2','7','10001',0,1,4),('2','9','10001',0,1,4),('2','10','10001',0,1,4),('2','17','10001',0,1,4),('2','18','10001',0,1,4),('2','19','10001',0,1,4),('2','20','10001',0,1,4),('2','21','10001',0,1,4),('2','22','10001',0,1,4),('2','23','10001',0,1,4),('2','24','10001',0,1,4),('2','25','10001',0,1,4),('2','26','10001',0,1,4),('2','27','10001',0,1,4),('2','28','10001',0,1,4),('2','29','1',1,1,4),('2','30','1',1,1,4),('2','31','1',1,1,4),('2','32','1',1,1,4),('2','33','1',1,1,4),('2','34','1',1,1,4),('2','35','1',1,1,4),('2','36','1',1,1,4),('2','37','1',1,1,4),('2','48','1',1,1,4),('2','49','1',1,1,4),('2','50','1',1,1,4),('2','51','1',1,1,4),('2','52','1',1,1,4),('2','53','1',1,1,4),('2','54','1',1,1,4),('2','55','1',1,1,4),('2','56','1',1,1,4),('2','57','1',1,1,4),('2','58','1',1,1,4),('2','59','1',1,1,4),('2','60','1',1,1,4),('2','61','1',1,1,4),('2','62','1',1,1,4),('2','63','1',1,1,4),('2','64','1',1,1,4),('2','65','1',1,1,4),('2','67','1',1,1,4),('2','68','1',1,1,4),('2','69','1',1,1,4),('2','70','1',1,1,4),('2','71','1',1,1,4),('2','72','1',1,1,4),('2','73','1',1,1,4),('2','74','1',1,1,4),('2','75','1',1,1,4),('2','76','1',1,1,4),('2','77','1',1,1,4),('147','1','1',1,1,4),('147','2','1',1,1,4),('147','7','1',1,1,4),('147','9','1',1,1,4),('147','10','1',1,1,4),('147','17','1',1,1,4),('147','18','1',1,1,4),('147','19','1',1,1,4),('147','20','1',1,1,4),('147','21','1',1,1,4),('147','22','1',1,1,4),('147','23','1',1,1,4),('147','24','1',1,1,4),('147','25','1',1,1,4),('147','26','1',1,1,4),('147','27','1',1,1,4),('147','28','1',1,1,4),('148','1','1',1,1,4),('148','2','1',1,1,4),('148','7','1',1,1,4),('148','9','1',1,1,4),('148','10','1',1,1,4),('148','17','1',1,1,4),('148','18','1',1,1,4),('148','19','1',1,1,4),('148','20','1',1,1,4),('148','21','1',1,1,4),('148','22','1',1,1,4),('148','23','1',1,1,4),('148','24','1',1,1,4),('148','25','1',1,1,4),('148','26','1',1,1,4),('148','27','1',1,1,4),('148','28','1',1,1,4),('188','1','1',1,1,4),('188','2','1',1,1,4),('188','7','1',1,1,4),('188','9','1',1,1,4),('188','10','1',1,1,4),('188','17','1',1,1,4),('188','18','1',1,1,4),('188','19','1',1,1,4),('188','20','1',1,1,4),('188','21','1',1,1,4),('188','22','1',1,1,4),('188','23','1',1,1,4),('188','24','1',1,1,4),('188','25','1',1,1,4),('188','26','1',1,1,4),('188','27','1',1,1,4),('188','28','1',1,1,4),('189','1','1',1,1,4),('189','2','1',1,1,4),('189','7','1',1,1,4),('189','9','1',1,1,4),('189','10','1',1,1,4),('189','17','1',1,1,4),('189','18','1',1,1,4),('189','19','1',1,1,4),('189','20','1',1,1,4),('189','21','1',1,1,4),('189','22','1',1,1,4),('189','23','1',1,1,4),('189','24','1',1,1,4),('189','25','1',1,1,4),('189','26','1',1,1,4),('189','27','1',1,1,4),('189','28','1',1,1,4),('190','1','1',1,1,4),('190','2','1',1,1,4),('190','9','1',1,1,4),('190','10','1',1,1,4),('190','17','1',1,1,4),('190','18','1',1,1,4),('190','19','1',1,1,4),('190','20','1',1,1,4),('190','21','1',1,1,4),('190','22','1',1,1,4),('190','23','1',1,1,4),('190','24','1',1,1,4),('190','25','1',1,1,4),('190','26','1',1,1,4),('190','27','1',1,1,4),('191','9','1',1,1,4),('191','10','1',1,1,4),('191','17','1',1,1,4),('191','19','1',1,1,4),('191','20','1',1,1,4),('191','21','1',1,1,4),('191','22','1',1,1,4),('191','23','1',1,1,4),('191','24','1',1,1,4),('191','25','1',1,1,4),('191','27','1',1,1,4),('192','9','1',1,1,4),('192','17','1',1,1,4),('192','18','1',1,1,4),('192','19','1',1,1,4),('192','22','1',1,1,4),('192','24','1',1,1,4),('193','9','1',1,1,4),('193','20','1',1,1,4),('193','22','1',1,1,4),('194','27','1',1,1,4),('195','9','1',1,1,4),('195','10','1',1,1,4),('195','17','1',1,1,4),('195','18','1',1,1,4),('195','22','1',1,1,4),('195','25','1',1,1,4),('196','9','1',1,1,4),('196','10','1',1,1,4),('196','18','1',1,1,4),('196','22','1',1,1,4),('197','17','1',1,1,4),('197','23','1',1,1,4),('199','10','1',1,1,4),('199','18','1',1,1,4),('199','23','1',1,1,4),('199','25','1',1,1,4),('200','10','1',1,1,4),('200','18','1',1,1,4),('200','23','1',1,1,4),('203','1','1',1,1,4),('203','2','1',1,1,4),('203','9','1',1,1,4),('203','10','1',1,1,4),('203','17','1',1,1,4),('203','18','1',1,1,4),('203','19','1',1,1,4),('203','20','1',1,1,4),('203','21','1',1,1,4),('203','22','1',1,1,4),('203','23','1',1,1,4),('203','24','1',1,1,4),('203','25','1',1,1,4),('203','26','1',1,1,4),('203','27','1',1,1,4),('204','1','1',1,1,4),('204','2','1',1,1,4),('204','7','1',1,1,4),('204','9','1',1,1,4),('204','10','1',1,1,4),('204','17','1',1,1,4),('204','18','1',1,1,4),('204','19','1',1,1,4),('204','20','1',1,1,4),('204','21','1',1,1,4),('204','22','1',1,1,4),('204','23','1',1,1,4),('204','24','1',1,1,4),('204','25','1',1,1,4),('204','26','1',1,1,4),('204','27','1',1,1,4),('205','10','1',1,1,4),('205','17','1',1,1,4),('205','18','1',1,1,4),('205','19','1',1,1,4),('205','21','1',1,1,4),('205','23','1',1,1,4),('205','27','1',1,1,4),('206','17','1',1,1,4),('206','18','1',1,1,4),('206','19','1',1,1,4),('207','10','1',1,1,4),('207','19','1',1,1,4),('208','27','1',1,1,4),('209','10','1',1,1,4),('209','17','1',1,1,4),('209','19','1',1,1,4),('209','21','1',1,1,4),('209','27','1',1,1,4),('210','10','1',1,1,4),('210','17','1',1,1,4),('210','19','1',1,1,4),('210','27','1',1,1,4),('211','17','1',1,1,4),('213','29','10001',0,1,4),('213','30','10001',0,1,4),('213','31','10001',0,1,4),('213','32','10001',0,1,4),('213','33','10001',0,1,4),('213','34','10001',0,1,4),('213','35','10001',0,1,4),('213','36','10001',0,1,4),('213','37','10001',0,1,4),('213','48','10001',0,1,4),('213','49','10001',0,1,4),('213','50','10001',0,1,4),('214','29','10001',0,1,4),('214','30','10001',0,1,4),('214','31','10001',0,1,4),('214','32','10001',0,1,4),('214','33','10001',0,1,4),('214','34','10001',0,1,4),('214','35','10001',0,1,4),('214','36','10001',0,1,4),('214','37','10001',0,1,4),('214','48','10001',0,1,4),('214','49','10001',0,1,4),('214','50','10001',0,1,4),('215','29','10001',0,1,4),('215','30','10001',0,1,4),('215','31','10001',0,1,4),('215','32','10001',0,1,4),('215','33','10001',0,1,4),('215','34','10001',0,1,4),('215','35','10001',0,1,4),('215','36','10001',0,1,4),('215','37','10001',0,1,4),('215','48','10001',0,1,4),('215','49','10001',0,1,4),('215','50','10001',0,1,4),('216','29','10001',0,1,4),('216','30','10001',0,1,4),('216','31','10001',0,1,4),('216','34','10001',0,1,4),('216','35','10001',0,1,4),('216','36','10001',0,1,4),('216','37','10001',0,1,4),('216','48','10001',0,1,4),('216','50','10001',0,1,4),('255','51','10001',0,1,4),('255','52','10001',0,1,4),('255','53','10001',0,1,4),('255','54','10001',0,1,4),('255','55','10001',0,1,4),('255','56','10001',0,1,4),('255','57','10001',0,1,4),('255','58','10001',0,1,4),('255','59','10001',0,1,4),('255','60','10001',0,1,4),('255','61','10001',0,1,4),('255','62','10001',0,1,4),('256','51','10001',0,1,4),('256','52','10001',0,1,4),('256','53','10001',0,1,4),('256','54','10001',0,1,4),('256','55','10001',0,1,4),('256','56','10001',0,1,4),('256','57','10001',0,1,4),('256','58','10001',0,1,4),('256','59','10001',0,1,4),('256','60','10001',0,1,4),('256','61','10001',0,1,4),('257','51','10001',0,1,4),('257','52','10001',0,1,4),('257','53','10001',0,1,4),('257','54','10001',0,1,4),('257','55','10001',0,1,4),('257','56','10001',0,1,4),('257','57','10001',0,1,4),('257','58','10001',0,1,4),('257','60','10001',0,1,4),('258','52','10001',0,1,4),('258','53','10001',0,1,4),('258','54','10001',0,1,4),('258','56','10001',0,1,4),('258','57','10001',0,1,4),('258','58','10001',0,1,4),('258','59','10001',0,1,4),('258','60','10001',0,1,4),('303','63','10001',0,1,4),('303','64','10001',0,1,4),('303','65','10001',0,1,4),('303','67','10001',0,1,4),('303','68','10001',0,1,4),('303','69','10001',0,1,4),('303','70','10001',0,1,4),('303','71','10001',0,1,4),('303','72','10001',0,1,4),('303','73','10001',0,1,4),('303','74','10001',0,1,4),('303','75','10001',0,1,4),('303','76','10001',0,1,4),('303','77','10001',0,1,4),('304','63','10001',0,1,4),('304','64','10001',0,1,4),('304','65','10001',0,1,4),('304','67','10001',0,1,4),('304','68','10001',0,1,4),('304','69','10001',0,1,4),('304','70','10001',0,1,4),('304','71','10001',0,1,4),('304','72','10001',0,1,4),('304','73','10001',0,1,4),('304','74','10001',0,1,4),('304','75','10001',0,1,4),('304','76','10001',0,1,4),('304','77','10001',0,1,4),('305','63','10001',0,1,4),('305','64','10001',0,1,4),('305','65','10001',0,1,4),('305','67','10001',0,1,4),('305','68','10001',0,1,4),('305','69','10001',0,1,4),('305','70','10001',0,1,4),('305','71','10001',0,1,4),('305','72','10001',0,1,4),('305','73','10001',0,1,4),('305','74','10001',0,1,4),('305','75','10001',0,1,4),('305','76','10001',0,1,4),('305','77','10001',0,1,4),('307','64','10001',0,1,4),('307','65','10001',0,1,4),('307','68','10001',0,1,4),('307','70','10001',0,1,4),('308','67','10001',0,1,4),('308','69','10001',0,1,4),('308','70','10001',0,1,4),('308','75','10001',0,1,4),('309','67','10001',0,1,4),('309','68','10001',0,1,4),('309','71','10001',0,1,4),('309','72','10001',0,1,4),('309','75','10001',0,1,4),('310','65','10001',0,1,4),('310','70','10001',0,1,4),('310','71','10001',0,1,4),('310','74','10001',0,1,4),('311','74','10001',0,1,4),('2','1','10001',0,2,4),('2','2','10001',0,2,4),('2','7','10001',0,2,4),('2','9','10001',0,2,4),('2','10','10001',0,2,4),('2','17','10001',0,2,4),('2','18','10001',0,2,4),('2','19','10001',0,2,4),('2','20','10001',0,2,4),('2','21','10001',0,2,4),('2','22','10001',0,2,4),('2','23','10001',0,2,4),('2','24','10001',0,2,4),('2','25','10001',0,2,4),('2','26','10001',0,2,4),('2','27','10001',0,2,4),('2','28','10001',0,2,4),('147','1','10001',0,2,4),('147','2','10001',0,2,4),('147','7','10001',0,2,4),('147','9','10001',0,2,4),('147','10','10001',0,2,4),('147','17','10001',0,2,4),('147','18','10001',0,2,4),('147','19','10001',0,2,4),('147','20','10001',0,2,4),('147','21','10001',0,2,4),('147','22','10001',0,2,4),('147','23','10001',0,2,4),('147','24','10001',0,2,4),('147','25','10001',0,2,4),('147','26','10001',0,2,4),('147','27','10001',0,2,4),('147','28','10001',0,2,4),('148','1','10001',0,2,4),('148','2','10001',0,2,4),('148','7','10001',0,2,4),('148','9','10001',0,2,4),('148','10','10001',0,2,4),('148','17','10001',0,2,4),('148','18','10001',0,2,4),('148','19','10001',0,2,4),('148','20','10001',0,2,4),('148','21','10001',0,2,4),('148','22','10001',0,2,4),('148','23','10001',0,2,4),('148','24','10001',0,2,4),('148','25','10001',0,2,4),('148','26','10001',0,2,4),('148','27','10001',0,2,4),('188','9','10001',0,2,4),('188','10','10001',0,2,4),('188','17','10001',0,2,4),('188','18','10001',0,2,4),('188','19','10001',0,2,4),('188','20','10001',0,2,4),('188','21','10001',0,2,4),('188','22','10001',0,2,4),('188','23','10001',0,2,4),('188','24','10001',0,2,4),('188','25','10001',0,2,4),('188','27','10001',0,2,4),('189','9','10001',0,2,4),('189','10','10001',0,2,4),('189','17','10001',0,2,4),('189','18','10001',0,2,4),('189','22','10001',0,2,4),('189','23','10001',0,2,4),('189','25','10001',0,2,4),('190','10','10001',0,2,4),('190','18','10001',0,2,4),('190','23','10001',0,2,4),('190','25','10001',0,2,4),('203','10','10001',0,2,4),('203','17','10001',0,2,4),('203','18','10001',0,2,4),('203','19','10001',0,2,4),('203','21','10001',0,2,4),('203','23','10001',0,2,4),('203','27','10001',0,2,4),('204','10','10001',0,2,4),('204','17','10001',0,2,4),('204','19','10001',0,2,4),('204','21','10001',0,2,4),('204','27','10001',0,2,4),('213','29','10001',0,2,4),('213','30','10001',0,2,4),('213','31','10001',0,2,4),('213','32','10001',0,2,4),('213','33','10001',0,2,4),('213','34','10001',0,2,4),('213','35','10001',0,2,4),('213','36','10001',0,2,4),('213','37','10001',0,2,4),('213','48','10001',0,2,4),('213','49','10001',0,2,4),('213','50','10001',0,2,4),('213','1','1',1,2,4),('213','2','1',1,2,4),('213','7','1',1,2,4),('213','9','1',1,2,4),('213','10','1',1,2,4),('213','17','1',1,2,4),('213','18','1',1,2,4),('213','19','1',1,2,4),('213','20','1',1,2,4),('213','21','1',1,2,4),('213','22','1',1,2,4),('213','23','1',1,2,4),('213','24','1',1,2,4),('213','25','1',1,2,4),('213','26','1',1,2,4),('213','27','1',1,2,4),('213','28','1',1,2,4),('213','51','1',1,2,4),('213','52','1',1,2,4),('213','53','1',1,2,4),('213','54','1',1,2,4),('213','55','1',1,2,4),('213','56','1',1,2,4),('213','57','1',1,2,4),('213','58','1',1,2,4),('213','59','1',1,2,4),('213','60','1',1,2,4),('213','61','1',1,2,4),('213','62','1',1,2,4),('213','63','1',1,2,4),('213','64','1',1,2,4),('213','65','1',1,2,4),('213','67','1',1,2,4),('213','68','1',1,2,4),('213','69','1',1,2,4),('213','70','1',1,2,4),('213','71','1',1,2,4),('213','72','1',1,2,4),('213','73','1',1,2,4),('213','74','1',1,2,4),('213','75','1',1,2,4),('213','76','1',1,2,4),('213','77','1',1,2,4),('214','29','1',1,2,4),('214','30','1',1,2,4),('214','31','1',1,2,4),('214','32','1',1,2,4),('214','33','1',1,2,4),('214','34','1',1,2,4),('214','35','1',1,2,4),('214','36','1',1,2,4),('214','37','1',1,2,4),('214','48','1',1,2,4),('214','49','1',1,2,4),('214','50','1',1,2,4),('215','29','1',1,2,4),('215','30','1',1,2,4),('215','31','1',1,2,4),('215','32','1',1,2,4),('215','33','1',1,2,4),('215','34','1',1,2,4),('215','35','1',1,2,4),('215','36','1',1,2,4),('215','37','1',1,2,4),('215','48','1',1,2,4),('215','49','1',1,2,4),('215','50','1',1,2,4),('216','29','1',1,2,4),('216','30','1',1,2,4),('216','31','1',1,2,4),('216','32','1',1,2,4),('216','33','1',1,2,4),('216','34','1',1,2,4),('216','35','1',1,2,4),('216','36','1',1,2,4),('216','37','1',1,2,4),('216','48','1',1,2,4),('216','49','1',1,2,4),('216','50','1',1,2,4),('217','29','1',1,2,4),('217','31','1',1,2,4),('217','33','1',1,2,4),('217','37','1',1,2,4),('217','48','1',1,2,4),('217','49','1',1,2,4),('217','50','1',1,2,4),('218','29','1',1,2,4),('218','30','1',1,2,4),('218','31','1',1,2,4),('218','32','1',1,2,4),('218','33','1',1,2,4),('218','34','1',1,2,4),('218','35','1',1,2,4),('218','36','1',1,2,4),('218','37','1',1,2,4),('218','50','1',1,2,4),('219','29','1',1,2,4),('219','30','1',1,2,4),('219','31','1',1,2,4),('219','32','1',1,2,4),('219','34','1',1,2,4),('219','35','1',1,2,4),('219','36','1',1,2,4),('219','48','1',1,2,4),('232','29','1',1,2,4),('232','30','1',1,2,4),('232','31','1',1,2,4),('232','32','1',1,2,4),('232','33','1',1,2,4),('232','36','1',1,2,4),('232','48','1',1,2,4),('232','49','1',1,2,4),('233','30','1',1,2,4),('233','31','1',1,2,4),('233','32','1',1,2,4),('233','33','1',1,2,4),('233','34','1',1,2,4),('233','35','1',1,2,4),('233','36','1',1,2,4),('233','37','1',1,2,4),('233','48','1',1,2,4),('233','50','1',1,2,4),('234','29','1',1,2,4),('234','35','1',1,2,4),('234','37','1',1,2,4),('247','29','1',1,2,4),('247','30','1',1,2,4),('247','31','1',1,2,4),('247','35','1',1,2,4),('247','36','1',1,2,4),('247','37','1',1,2,4),('247','48','1',1,2,4),('247','50','1',1,2,4),('248','29','1',1,2,4),('248','30','1',1,2,4),('248','31','1',1,2,4),('248','34','1',1,2,4),('248','37','1',1,2,4),('255','51','10001',0,2,4),('255','52','10001',0,2,4),('255','53','10001',0,2,4),('255','54','10001',0,2,4),('255','55','10001',0,2,4),('255','56','10001',0,2,4),('255','57','10001',0,2,4),('255','58','10001',0,2,4),('255','59','10001',0,2,4),('255','60','10001',0,2,4),('255','61','10001',0,2,4),('255','62','10001',0,2,4),('256','51','10001',0,2,4),('256','52','10001',0,2,4),('256','53','10001',0,2,4),('256','54','10001',0,2,4),('256','55','10001',0,2,4),('256','56','10001',0,2,4),('256','57','10001',0,2,4),('256','58','10001',0,2,4),('256','59','10001',0,2,4),('256','60','10001',0,2,4),('256','61','10001',0,2,4),('257','51','10001',0,2,4),('257','52','10001',0,2,4),('257','53','10001',0,2,4),('257','54','10001',0,2,4),('257','55','10001',0,2,4),('257','56','10001',0,2,4),('257','57','10001',0,2,4),('257','58','10001',0,2,4),('257','60','10001',0,2,4),('258','52','10001',0,2,4),('258','53','10001',0,2,4),('258','54','10001',0,2,4),('258','56','10001',0,2,4),('258','57','10001',0,2,4),('258','58','10001',0,2,4),('258','59','10001',0,2,4),('258','60','10001',0,2,4),('303','63','10001',0,2,4),('303','64','10001',0,2,4),('303','65','10001',0,2,4),('303','67','10001',0,2,4),('303','68','10001',0,2,4),('303','69','10001',0,2,4),('303','70','10001',0,2,4),('303','71','10001',0,2,4),('303','72','10001',0,2,4),('303','73','10001',0,2,4),('303','74','10001',0,2,4),('303','75','10001',0,2,4),('303','76','10001',0,2,4),('303','77','10001',0,2,4),('304','63','10001',0,2,4),('304','64','10001',0,2,4),('304','65','10001',0,2,4),('304','67','10001',0,2,4),('304','68','10001',0,2,4),('304','69','10001',0,2,4),('304','70','10001',0,2,4),('304','71','10001',0,2,4),('304','72','10001',0,2,4),('304','73','10001',0,2,4),('304','74','10001',0,2,4),('304','75','10001',0,2,4),('304','76','10001',0,2,4),('304','77','10001',0,2,4),('305','63','10001',0,2,4),('305','64','10001',0,2,4),('305','65','10001',0,2,4),('305','67','10001',0,2,4),('305','68','10001',0,2,4),('305','69','10001',0,2,4),('305','70','10001',0,2,4),('305','71','10001',0,2,4),('305','72','10001',0,2,4),('305','73','10001',0,2,4),('305','74','10001',0,2,4),('305','75','10001',0,2,4),('305','76','10001',0,2,4),('305','77','10001',0,2,4),('307','64','10001',0,2,4),('307','65','10001',0,2,4),('307','68','10001',0,2,4),('307','70','10001',0,2,4),('308','67','10001',0,2,4),('308','69','10001',0,2,4),('308','70','10001',0,2,4),('308','75','10001',0,2,4),('309','67','10001',0,2,4),('309','68','10001',0,2,4),('309','71','10001',0,2,4),('309','72','10001',0,2,4),('309','75','10001',0,2,4),('310','65','10001',0,2,4),('310','70','10001',0,2,4),('310','71','10001',0,2,4),('310','74','10001',0,2,4),('311','74','10001',0,2,4),('2','1','10001',0,3,4),('2','2','10001',0,3,4),('2','7','10001',0,3,4),('2','9','10001',0,3,4),('2','10','10001',0,3,4),('2','17','10001',0,3,4),('2','18','10001',0,3,4),('2','19','10001',0,3,4),('2','20','10001',0,3,4),('2','21','10001',0,3,4),('2','22','10001',0,3,4),('2','23','10001',0,3,4),('2','24','10001',0,3,4),('2','25','10001',0,3,4),('2','26','10001',0,3,4),('2','27','10001',0,3,4),('2','28','10001',0,3,4),('147','1','10001',0,3,4),('147','2','10001',0,3,4),('147','7','10001',0,3,4),('147','9','10001',0,3,4),('147','10','10001',0,3,4),('147','17','10001',0,3,4),('147','18','10001',0,3,4),('147','19','10001',0,3,4),('147','20','10001',0,3,4),('147','21','10001',0,3,4),('147','22','10001',0,3,4),('147','23','10001',0,3,4),('147','24','10001',0,3,4),('147','25','10001',0,3,4),('147','26','10001',0,3,4),('147','27','10001',0,3,4),('147','28','10001',0,3,4),('148','1','10001',0,3,4),('148','2','10001',0,3,4),('148','7','10001',0,3,4),('148','9','10001',0,3,4),('148','10','10001',0,3,4),('148','17','10001',0,3,4),('148','18','10001',0,3,4),('148','19','10001',0,3,4),('148','20','10001',0,3,4),('148','21','10001',0,3,4),('148','22','10001',0,3,4),('148','23','10001',0,3,4),('148','24','10001',0,3,4),('148','25','10001',0,3,4),('148','26','10001',0,3,4),('148','27','10001',0,3,4),('188','9','10001',0,3,4),('188','10','10001',0,3,4),('188','17','10001',0,3,4),('188','18','10001',0,3,4),('188','19','10001',0,3,4),('188','20','10001',0,3,4),('188','21','10001',0,3,4),('188','22','10001',0,3,4),('188','23','10001',0,3,4),('188','24','10001',0,3,4),('188','25','10001',0,3,4),('188','27','10001',0,3,4),('189','9','10001',0,3,4),('189','10','10001',0,3,4),('189','17','10001',0,3,4),('189','18','10001',0,3,4),('189','22','10001',0,3,4),('189','23','10001',0,3,4),('189','25','10001',0,3,4),('190','10','10001',0,3,4),('190','18','10001',0,3,4),('190','23','10001',0,3,4),('190','25','10001',0,3,4),('203','10','10001',0,3,4),('203','17','10001',0,3,4),('203','18','10001',0,3,4),('203','19','10001',0,3,4),('203','21','10001',0,3,4),('203','23','10001',0,3,4),('203','27','10001',0,3,4),('204','10','10001',0,3,4),('204','17','10001',0,3,4),('204','19','10001',0,3,4),('204','21','10001',0,3,4),('204','27','10001',0,3,4),('213','29','10001',0,3,4),('213','30','10001',0,3,4),('213','31','10001',0,3,4),('213','32','10001',0,3,4),('213','33','10001',0,3,4),('213','34','10001',0,3,4),('213','35','10001',0,3,4),('213','36','10001',0,3,4),('213','37','10001',0,3,4),('213','48','10001',0,3,4),('213','49','10001',0,3,4),('213','50','10001',0,3,4),('214','29','10001',0,3,4),('214','30','10001',0,3,4),('214','31','10001',0,3,4),('214','32','10001',0,3,4),('214','33','10001',0,3,4),('214','34','10001',0,3,4),('214','35','10001',0,3,4),('214','36','10001',0,3,4),('214','37','10001',0,3,4),('214','48','10001',0,3,4),('214','49','10001',0,3,4),('214','50','10001',0,3,4),('215','29','10001',0,3,4),('215','30','10001',0,3,4),('215','31','10001',0,3,4),('215','32','10001',0,3,4),('215','33','10001',0,3,4),('215','34','10001',0,3,4),('215','35','10001',0,3,4),('215','36','10001',0,3,4),('215','37','10001',0,3,4),('215','48','10001',0,3,4),('215','49','10001',0,3,4),('215','50','10001',0,3,4),('216','29','10001',0,3,4),('216','30','10001',0,3,4),('216','31','10001',0,3,4),('216','34','10001',0,3,4),('216','35','10001',0,3,4),('216','36','10001',0,3,4),('216','37','10001',0,3,4),('216','48','10001',0,3,4),('216','50','10001',0,3,4),('255','51','10001',0,3,4),('255','52','10001',0,3,4),('255','53','10001',0,3,4),('255','54','10001',0,3,4),('255','55','10001',0,3,4),('255','56','10001',0,3,4),('255','57','10001',0,3,4),('255','58','10001',0,3,4),('255','59','10001',0,3,4),('255','60','10001',0,3,4),('255','61','10001',0,3,4),('255','62','10001',0,3,4),('255','1','1',1,3,4),('255','2','1',1,3,4),('255','7','1',1,3,4),('255','9','1',1,3,4),('255','10','1',1,3,4),('255','17','1',1,3,4),('255','18','1',1,3,4),('255','19','1',1,3,4),('255','20','1',1,3,4),('255','21','1',1,3,4),('255','22','1',1,3,4),('255','23','1',1,3,4),('255','24','1',1,3,4),('255','25','1',1,3,4),('255','26','1',1,3,4),('255','27','1',1,3,4),('255','28','1',1,3,4),('255','29','1',1,3,4),('255','30','1',1,3,4),('255','31','1',1,3,4),('255','32','1',1,3,4),('255','33','1',1,3,4),('255','34','1',1,3,4),('255','35','1',1,3,4),('255','36','1',1,3,4),('255','37','1',1,3,4),('255','48','1',1,3,4),('255','49','1',1,3,4),('255','50','1',1,3,4),('255','63','1',1,3,4),('255','64','1',1,3,4),('255','65','1',1,3,4),('255','67','1',1,3,4),('255','68','1',1,3,4),('255','69','1',1,3,4),('255','70','1',1,3,4),('255','71','1',1,3,4),('255','72','1',1,3,4),('255','73','1',1,3,4),('255','74','1',1,3,4),('255','75','1',1,3,4),('255','76','1',1,3,4),('255','77','1',1,3,4),('256','51','1',1,3,4),('256','52','1',1,3,4),('256','53','1',1,3,4),('256','54','1',1,3,4),('256','55','1',1,3,4),('256','56','1',1,3,4),('256','57','1',1,3,4),('256','58','1',1,3,4),('256','59','1',1,3,4),('256','60','1',1,3,4),('256','61','1',1,3,4),('256','62','1',1,3,4),('257','51','1',1,3,4),('257','52','1',1,3,4),('257','53','1',1,3,4),('257','54','1',1,3,4),('257','55','1',1,3,4),('257','56','1',1,3,4),('257','57','1',1,3,4),('257','58','1',1,3,4),('257','59','1',1,3,4),('257','60','1',1,3,4),('257','61','1',1,3,4),('257','62','1',1,3,4),('258','51','1',1,3,4),('258','52','1',1,3,4),('258','53','1',1,3,4),('258','54','1',1,3,4),('258','55','1',1,3,4),('258','56','1',1,3,4),('258','57','1',1,3,4),('258','58','1',1,3,4),('258','59','1',1,3,4),('258','60','1',1,3,4),('258','61','1',1,3,4),('258','62','1',1,3,4),('259','51','1',1,3,4),('259','52','1',1,3,4),('259','53','1',1,3,4),('259','54','1',1,3,4),('259','55','1',1,3,4),('259','56','1',1,3,4),('259','57','1',1,3,4),('259','58','1',1,3,4),('259','59','1',1,3,4),('259','60','1',1,3,4),('259','61','1',1,3,4),('259','62','1',1,3,4),('260','51','1',1,3,4),('260','52','1',1,3,4),('260','53','1',1,3,4),('260','54','1',1,3,4),('260','55','1',1,3,4),('260','56','1',1,3,4),('260','57','1',1,3,4),('260','58','1',1,3,4),('260','59','1',1,3,4),('260','60','1',1,3,4),('260','61','1',1,3,4),('261','51','1',1,3,4),('261','54','1',1,3,4),('261','55','1',1,3,4),('261','56','1',1,3,4),('261','57','1',1,3,4),('261','58','1',1,3,4),('261','59','1',1,3,4),('261','60','1',1,3,4),('261','61','1',1,3,4),('262','51','1',1,3,4),('262','53','1',1,3,4),('262','55','1',1,3,4),('262','59','1',1,3,4),('262','61','1',1,3,4),('278','51','1',1,3,4),('278','52','1',1,3,4),('278','54','1',1,3,4),('278','55','1',1,3,4),('278','57','1',1,3,4),('278','58','1',1,3,4),('279','51','1',1,3,4),('279','52','1',1,3,4),('279','53','1',1,3,4),('279','54','1',1,3,4),('279','55','1',1,3,4),('279','56','1',1,3,4),('279','57','1',1,3,4),('279','58','1',1,3,4),('279','60','1',1,3,4),('280','51','1',1,3,4),('280','52','1',1,3,4),('280','53','1',1,3,4),('280','60','1',1,3,4),('293','52','1',1,3,4),('293','53','1',1,3,4),('293','54','1',1,3,4),('293','56','1',1,3,4),('293','57','1',1,3,4),('293','58','1',1,3,4),('293','59','1',1,3,4),('293','60','1',1,3,4),('294','52','1',1,3,4),('294','53','1',1,3,4),('294','54','1',1,3,4),('294','56','1',1,3,4),('294','57','1',1,3,4),('294','58','1',1,3,4),('294','59','1',1,3,4),('294','60','1',1,3,4),('303','63','10001',0,3,4),('303','64','10001',0,3,4),('303','65','10001',0,3,4),('303','67','10001',0,3,4),('303','68','10001',0,3,4),('303','69','10001',0,3,4),('303','70','10001',0,3,4),('303','71','10001',0,3,4),('303','72','10001',0,3,4),('303','73','10001',0,3,4),('303','74','10001',0,3,4),('303','75','10001',0,3,4),('303','76','10001',0,3,4),('303','77','10001',0,3,4),('304','63','10001',0,3,4),('304','64','10001',0,3,4),('304','65','10001',0,3,4),('304','67','10001',0,3,4),('304','68','10001',0,3,4),('304','69','10001',0,3,4),('304','70','10001',0,3,4),('304','71','10001',0,3,4),('304','72','10001',0,3,4),('304','73','10001',0,3,4),('304','74','10001',0,3,4),('304','75','10001',0,3,4),('304','76','10001',0,3,4),('304','77','10001',0,3,4),('305','63','10001',0,3,4),('305','64','10001',0,3,4),('305','65','10001',0,3,4),('305','67','10001',0,3,4),('305','68','10001',0,3,4),('305','69','10001',0,3,4),('305','70','10001',0,3,4),('305','71','10001',0,3,4),('305','72','10001',0,3,4),('305','73','10001',0,3,4),('305','74','10001',0,3,4),('305','75','10001',0,3,4),('305','76','10001',0,3,4),('305','77','10001',0,3,4),('307','64','10001',0,3,4),('307','65','10001',0,3,4),('307','68','10001',0,3,4),('307','70','10001',0,3,4),('308','67','10001',0,3,4),('308','69','10001',0,3,4),('308','70','10001',0,3,4),('308','75','10001',0,3,4),('309','67','10001',0,3,4),('309','68','10001',0,3,4),('309','71','10001',0,3,4),('309','72','10001',0,3,4),('309','75','10001',0,3,4),('310','65','10001',0,3,4),('310','70','10001',0,3,4),('310','71','10001',0,3,4),('310','74','10001',0,3,4),('311','74','10001',0,3,4),('2','1','10001',0,4,4),('2','2','10001',0,4,4),('2','7','10001',0,4,4),('2','9','10001',0,4,4),('2','10','10001',0,4,4),('2','17','10001',0,4,4),('2','18','10001',0,4,4),('2','19','10001',0,4,4),('2','20','10001',0,4,4),('2','21','10001',0,4,4),('2','22','10001',0,4,4),('2','23','10001',0,4,4),('2','24','10001',0,4,4),('2','25','10001',0,4,4),('2','26','10001',0,4,4),('2','27','10001',0,4,4),('2','28','10001',0,4,4),('147','1','10001',0,4,4),('147','2','10001',0,4,4),('147','7','10001',0,4,4),('147','9','10001',0,4,4),('147','10','10001',0,4,4),('147','17','10001',0,4,4),('147','18','10001',0,4,4),('147','19','10001',0,4,4),('147','20','10001',0,4,4),('147','21','10001',0,4,4),('147','22','10001',0,4,4),('147','23','10001',0,4,4),('147','24','10001',0,4,4),('147','25','10001',0,4,4),('147','26','10001',0,4,4),('147','27','10001',0,4,4),('147','28','10001',0,4,4),('148','1','10001',0,4,4),('148','2','10001',0,4,4),('148','7','10001',0,4,4),('148','9','10001',0,4,4),('148','10','10001',0,4,4),('148','17','10001',0,4,4),('148','18','10001',0,4,4),('148','19','10001',0,4,4),('148','20','10001',0,4,4),('148','21','10001',0,4,4),('148','22','10001',0,4,4),('148','23','10001',0,4,4),('148','24','10001',0,4,4),('148','25','10001',0,4,4),('148','26','10001',0,4,4),('148','27','10001',0,4,4),('188','9','10001',0,4,4),('188','10','10001',0,4,4),('188','17','10001',0,4,4),('188','18','10001',0,4,4),('188','19','10001',0,4,4),('188','20','10001',0,4,4),('188','21','10001',0,4,4),('188','22','10001',0,4,4),('188','23','10001',0,4,4),('188','24','10001',0,4,4),('188','25','10001',0,4,4),('188','27','10001',0,4,4),('189','9','10001',0,4,4),('189','10','10001',0,4,4),('189','17','10001',0,4,4),('189','18','10001',0,4,4),('189','22','10001',0,4,4),('189','23','10001',0,4,4),('189','25','10001',0,4,4),('190','10','10001',0,4,4),('190','18','10001',0,4,4),('190','23','10001',0,4,4),('190','25','10001',0,4,4),('203','10','10001',0,4,4),('203','17','10001',0,4,4),('203','18','10001',0,4,4),('203','19','10001',0,4,4),('203','21','10001',0,4,4),('203','23','10001',0,4,4),('203','27','10001',0,4,4),('204','10','10001',0,4,4),('204','17','10001',0,4,4),('204','19','10001',0,4,4),('204','21','10001',0,4,4),('204','27','10001',0,4,4),('213','29','10001',0,4,4),('213','30','10001',0,4,4),('213','31','10001',0,4,4),('213','32','10001',0,4,4),('213','33','10001',0,4,4),('213','34','10001',0,4,4),('213','35','10001',0,4,4),('213','36','10001',0,4,4),('213','37','10001',0,4,4),('213','48','10001',0,4,4),('213','49','10001',0,4,4),('213','50','10001',0,4,4),('214','29','10001',0,4,4),('214','30','10001',0,4,4),('214','31','10001',0,4,4),('214','32','10001',0,4,4),('214','33','10001',0,4,4),('214','34','10001',0,4,4),('214','35','10001',0,4,4),('214','36','10001',0,4,4),('214','37','10001',0,4,4),('214','48','10001',0,4,4),('214','49','10001',0,4,4),('214','50','10001',0,4,4),('215','29','10001',0,4,4),('215','30','10001',0,4,4),('215','31','10001',0,4,4),('215','32','10001',0,4,4),('215','33','10001',0,4,4),('215','34','10001',0,4,4),('215','35','10001',0,4,4),('215','36','10001',0,4,4),('215','37','10001',0,4,4),('215','48','10001',0,4,4),('215','49','10001',0,4,4),('215','50','10001',0,4,4),('216','29','10001',0,4,4),('216','30','10001',0,4,4),('216','31','10001',0,4,4),('216','34','10001',0,4,4),('216','35','10001',0,4,4),('216','36','10001',0,4,4),('216','37','10001',0,4,4),('216','48','10001',0,4,4),('216','50','10001',0,4,4),('255','51','10001',0,4,4),('255','52','10001',0,4,4),('255','53','10001',0,4,4),('255','54','10001',0,4,4),('255','55','10001',0,4,4),('255','56','10001',0,4,4),('255','57','10001',0,4,4),('255','58','10001',0,4,4),('255','59','10001',0,4,4),('255','60','10001',0,4,4),('255','61','10001',0,4,4),('255','62','10001',0,4,4),('256','51','10001',0,4,4),('256','52','10001',0,4,4),('256','53','10001',0,4,4),('256','54','10001',0,4,4),('256','55','10001',0,4,4),('256','56','10001',0,4,4),('256','57','10001',0,4,4),('256','58','10001',0,4,4),('256','59','10001',0,4,4),('256','60','10001',0,4,4),('256','61','10001',0,4,4),('257','51','10001',0,4,4),('257','52','10001',0,4,4),('257','53','10001',0,4,4),('257','54','10001',0,4,4),('257','55','10001',0,4,4),('257','56','10001',0,4,4),('257','57','10001',0,4,4),('257','58','10001',0,4,4),('257','60','10001',0,4,4),('258','52','10001',0,4,4),('258','53','10001',0,4,4),('258','54','10001',0,4,4),('258','56','10001',0,4,4),('258','57','10001',0,4,4),('258','58','10001',0,4,4),('258','59','10001',0,4,4),('258','60','10001',0,4,4),('303','63','10001',0,4,4),('303','64','10001',0,4,4),('303','65','10001',0,4,4),('303','67','10001',0,4,4),('303','68','10001',0,4,4),('303','69','10001',0,4,4),('303','70','10001',0,4,4),('303','71','10001',0,4,4),('303','72','10001',0,4,4),('303','73','10001',0,4,4),('303','74','10001',0,4,4),('303','75','10001',0,4,4),('303','76','10001',0,4,4),('303','77','10001',0,4,4),('303','1','1',1,4,4),('303','2','1',1,4,4),('303','7','1',1,4,4),('303','9','1',1,4,4),('303','10','1',1,4,4),('303','17','1',1,4,4),('303','18','1',1,4,4),('303','19','1',1,4,4),('303','20','1',1,4,4),('303','21','1',1,4,4),('303','22','1',1,4,4),('303','23','1',1,4,4),('303','24','1',1,4,4),('303','25','1',1,4,4),('303','26','1',1,4,4),('303','27','1',1,4,4),('303','28','1',1,4,4),('303','29','1',1,4,4),('303','30','1',1,4,4),('303','31','1',1,4,4),('303','32','1',1,4,4),('303','33','1',1,4,4),('303','34','1',1,4,4),('303','35','1',1,4,4),('303','36','1',1,4,4),('303','37','1',1,4,4),('303','48','1',1,4,4),('303','49','1',1,4,4),('303','50','1',1,4,4),('303','51','1',1,4,4),('303','52','1',1,4,4),('303','53','1',1,4,4),('303','54','1',1,4,4),('303','55','1',1,4,4),('303','56','1',1,4,4),('303','57','1',1,4,4),('303','58','1',1,4,4),('303','59','1',1,4,4),('303','60','1',1,4,4),('303','61','1',1,4,4),('303','62','1',1,4,4),('304','63','1',1,4,4),('304','64','1',1,4,4),('304','65','1',1,4,4),('304','67','1',1,4,4),('304','68','1',1,4,4),('304','69','1',1,4,4),('304','70','1',1,4,4),('304','71','1',1,4,4),('304','72','1',1,4,4),('304','73','1',1,4,4),('304','74','1',1,4,4),('304','75','1',1,4,4),('304','76','1',1,4,4),('304','77','1',1,4,4),('305','63','1',1,4,4),('305','64','1',1,4,4),('305','65','1',1,4,4),('305','67','1',1,4,4),('305','68','1',1,4,4),('305','69','1',1,4,4),('305','70','1',1,4,4),('305','71','1',1,4,4),('305','72','1',1,4,4),('305','73','1',1,4,4),('305','74','1',1,4,4),('305','75','1',1,4,4),('305','76','1',1,4,4),('305','77','1',1,4,4),('306','63','1',1,4,4),('306','64','1',1,4,4),('306','65','1',1,4,4),('306','67','1',1,4,4),('306','68','1',1,4,4),('306','69','1',1,4,4),('306','70','1',1,4,4),('306','71','1',1,4,4),('306','72','1',1,4,4),('306','73','1',1,4,4),('306','74','1',1,4,4),('306','75','1',1,4,4),('306','76','1',1,4,4),('306','77','1',1,4,4),('307','68','10001',0,4,4),('307','70','10001',0,4,4),('307','63','1',1,4,4),('307','64','1',1,4,4),('307','65','1',1,4,4),('307','73','1',1,4,4),('307','74','1',1,4,4),('307','76','1',1,4,4),('307','77','1',1,4,4),('308','63','1',1,4,4),('308','64','1',1,4,4),('308','67','1',1,4,4),('308','68','1',1,4,4),('308','69','1',1,4,4),('308','70','1',1,4,4),('308','72','1',1,4,4),('308','73','1',1,4,4),('308','74','1',1,4,4),('308','75','1',1,4,4),('308','76','1',1,4,4),('308','77','1',1,4,4),('309','63','1',1,4,4),('309','64','1',1,4,4),('309','65','1',1,4,4),('309','67','1',1,4,4),('309','68','1',1,4,4),('309','69','1',1,4,4),('309','70','1',1,4,4),('309','71','1',1,4,4),('309','72','1',1,4,4),('309','75','1',1,4,4),('309','76','1',1,4,4),('309','77','1',1,4,4),('310','63','1',1,4,4),('310','64','1',1,4,4),('310','65','1',1,4,4),('310','67','1',1,4,4),('310','68','1',1,4,4),('310','69','1',1,4,4),('310','70','1',1,4,4),('310','71','1',1,4,4),('310','72','1',1,4,4),('310','73','1',1,4,4),('310','74','1',1,4,4),('310','75','1',1,4,4),('310','76','1',1,4,4),('310','77','1',1,4,4),('311','63','1',1,4,4),('311','64','1',1,4,4),('311','65','1',1,4,4),('311','67','1',1,4,4),('311','68','1',1,4,4),('311','69','1',1,4,4),('311','70','1',1,4,4),('311','71','1',1,4,4),('311','72','1',1,4,4),('311','73','1',1,4,4),('311','74','1',1,4,4),('311','76','1',1,4,4),('311','77','1',1,4,4),('312','74','1',1,4,4),('313','74','1',1,4,4),('315','65','1',1,4,4),('315','70','1',1,4,4),('315','71','1',1,4,4),('315','74','1',1,4,4),('316','71','1',1,4,4),('316','74','1',1,4,4),('318','64','1',1,4,4),('318','65','1',1,4,4),('318','70','1',1,4,4),('319','64','1',1,4,4),('319','65','1',1,4,4),('319','68','1',1,4,4),('321','70','1',1,4,4),('322','67','1',1,4,4),('322','69','1',1,4,4),('322','70','1',1,4,4),('324','67','1',1,4,4),('324','70','1',1,4,4),('324','75','1',1,4,4),('327','67','1',1,4,4),('327','68','1',1,4,4),('327','72','1',1,4,4),('328','68','1',1,4,4),('328','71','1',1,4,4),('328','72','1',1,4,4),('328','75','1',1,4,4),('329','67','1',1,4,4),('329','71','1',1,4,4),('329','75','1',1,4,4),('2','1','10001',0,5,4),('2','2','10001',0,5,4),('2','7','10001',0,5,4),('2','9','10001',0,5,4),('2','10','10001',0,5,4),('2','17','10001',0,5,4),('2','18','10001',0,5,4),('2','19','10001',0,5,4),('2','20','10001',0,5,4),('2','21','10001',0,5,4),('2','22','10001',0,5,4),('2','23','10001',0,5,4),('2','24','10001',0,5,4),('2','25','10001',0,5,4),('2','26','10001',0,5,4),('2','27','10001',0,5,4),('2','28','10001',0,5,4),('2','29','1',1,5,4),('2','30','1',1,5,4),('2','31','1',1,5,4),('2','32','1',1,5,4),('2','33','1',1,5,4),('2','34','1',1,5,4),('2','35','1',1,5,4),('2','36','1',1,5,4),('2','37','1',1,5,4),('2','48','1',1,5,4),('2','49','1',1,5,4),('2','50','1',1,5,4),('2','51','1',1,5,4),('2','52','1',1,5,4),('2','53','1',1,5,4),('2','54','1',1,5,4),('2','55','1',1,5,4),('2','56','1',1,5,4),('2','57','1',1,5,4),('2','58','1',1,5,4),('2','59','1',1,5,4),('2','60','1',1,5,4),('2','61','1',1,5,4),('2','62','1',1,5,4),('2','63','1',1,5,4),('2','64','1',1,5,4),('2','65','1',1,5,4),('2','67','1',1,5,4),('2','68','1',1,5,4),('2','69','1',1,5,4),('2','70','1',1,5,4),('2','71','1',1,5,4),('2','72','1',1,5,4),('2','73','1',1,5,4),('2','74','1',1,5,4),('2','75','1',1,5,4),('2','76','1',1,5,4),('2','77','1',1,5,4),('147','1','1',1,5,4),('147','2','1',1,5,4),('147','7','1',1,5,4),('147','9','1',1,5,4),('147','10','1',1,5,4),('147','17','1',1,5,4),('147','18','1',1,5,4),('147','19','1',1,5,4),('147','20','1',1,5,4),('147','21','1',1,5,4),('147','22','1',1,5,4),('147','23','1',1,5,4),('147','24','1',1,5,4),('147','25','1',1,5,4),('147','26','1',1,5,4),('147','27','1',1,5,4),('147','28','1',1,5,4),('148','1','1',1,5,4),('148','2','1',1,5,4),('148','7','1',1,5,4),('148','9','1',1,5,4),('148','10','1',1,5,4),('148','17','1',1,5,4),('148','18','1',1,5,4),('148','19','1',1,5,4),('148','20','1',1,5,4),('148','21','1',1,5,4),('148','22','1',1,5,4),('148','23','1',1,5,4),('148','24','1',1,5,4),('148','25','1',1,5,4),('148','26','1',1,5,4),('148','27','1',1,5,4),('148','28','1',1,5,4),('188','1','1',1,5,4),('188','2','1',1,5,4),('188','7','1',1,5,4),('188','9','1',1,5,4),('188','10','1',1,5,4),('188','17','1',1,5,4),('188','18','1',1,5,4),('188','19','1',1,5,4),('188','20','1',1,5,4),('188','21','1',1,5,4),('188','22','1',1,5,4),('188','23','1',1,5,4),('188','24','1',1,5,4),('188','25','1',1,5,4),('188','26','1',1,5,4),('188','27','1',1,5,4);
INSERT INTO `catalog_category_product_index` VALUES ('188','28','1',1,5,4),('189','1','1',1,5,4),('189','2','1',1,5,4),('189','7','1',1,5,4),('189','9','1',1,5,4),('189','10','1',1,5,4),('189','17','1',1,5,4),('189','18','1',1,5,4),('189','19','1',1,5,4),('189','20','1',1,5,4),('189','21','1',1,5,4),('189','22','1',1,5,4),('189','23','1',1,5,4),('189','24','1',1,5,4),('189','25','1',1,5,4),('189','26','1',1,5,4),('189','27','1',1,5,4),('189','28','1',1,5,4),('190','1','1',1,5,4),('190','2','1',1,5,4),('190','9','1',1,5,4),('190','10','1',1,5,4),('190','17','1',1,5,4),('190','18','1',1,5,4),('190','19','1',1,5,4),('190','20','1',1,5,4),('190','21','1',1,5,4),('190','22','1',1,5,4),('190','23','1',1,5,4),('190','24','1',1,5,4),('190','25','1',1,5,4),('190','26','1',1,5,4),('190','27','1',1,5,4),('191','9','1',1,5,4),('191','10','1',1,5,4),('191','17','1',1,5,4),('191','19','1',1,5,4),('191','20','1',1,5,4),('191','21','1',1,5,4),('191','22','1',1,5,4),('191','23','1',1,5,4),('191','24','1',1,5,4),('191','25','1',1,5,4),('191','27','1',1,5,4),('192','9','1',1,5,4),('192','17','1',1,5,4),('192','18','1',1,5,4),('192','19','1',1,5,4),('192','22','1',1,5,4),('192','24','1',1,5,4),('193','9','1',1,5,4),('193','20','1',1,5,4),('193','22','1',1,5,4),('194','27','1',1,5,4),('195','9','1',1,5,4),('195','10','1',1,5,4),('195','17','1',1,5,4),('195','18','1',1,5,4),('195','22','1',1,5,4),('195','25','1',1,5,4),('196','9','1',1,5,4),('196','10','1',1,5,4),('196','18','1',1,5,4),('196','22','1',1,5,4),('197','17','1',1,5,4),('197','23','1',1,5,4),('199','10','1',1,5,4),('199','18','1',1,5,4),('199','23','1',1,5,4),('199','25','1',1,5,4),('200','10','1',1,5,4),('200','18','1',1,5,4),('200','23','1',1,5,4),('203','1','1',1,5,4),('203','2','1',1,5,4),('203','9','1',1,5,4),('203','10','1',1,5,4),('203','17','1',1,5,4),('203','18','1',1,5,4),('203','19','1',1,5,4),('203','20','1',1,5,4),('203','21','1',1,5,4),('203','22','1',1,5,4),('203','23','1',1,5,4),('203','24','1',1,5,4),('203','25','1',1,5,4),('203','26','1',1,5,4),('203','27','1',1,5,4),('204','1','1',1,5,4),('204','2','1',1,5,4),('204','7','1',1,5,4),('204','9','1',1,5,4),('204','10','1',1,5,4),('204','17','1',1,5,4),('204','18','1',1,5,4),('204','19','1',1,5,4),('204','20','1',1,5,4),('204','21','1',1,5,4),('204','22','1',1,5,4),('204','23','1',1,5,4),('204','24','1',1,5,4),('204','25','1',1,5,4),('204','26','1',1,5,4),('204','27','1',1,5,4),('205','10','1',1,5,4),('205','17','1',1,5,4),('205','18','1',1,5,4),('205','19','1',1,5,4),('205','21','1',1,5,4),('205','23','1',1,5,4),('205','27','1',1,5,4),('206','17','1',1,5,4),('206','18','1',1,5,4),('206','19','1',1,5,4),('207','10','1',1,5,4),('207','19','1',1,5,4),('208','27','1',1,5,4),('209','10','1',1,5,4),('209','17','1',1,5,4),('209','19','1',1,5,4),('209','21','1',1,5,4),('209','27','1',1,5,4),('210','10','1',1,5,4),('210','17','1',1,5,4),('210','19','1',1,5,4),('210','27','1',1,5,4),('211','17','1',1,5,4),('213','29','10001',0,5,4),('213','30','10001',0,5,4),('213','31','10001',0,5,4),('213','32','10001',0,5,4),('213','33','10001',0,5,4),('213','34','10001',0,5,4),('213','35','10001',0,5,4),('213','36','10001',0,5,4),('213','37','10001',0,5,4),('213','48','10001',0,5,4),('213','49','10001',0,5,4),('213','50','10001',0,5,4),('214','29','10001',0,5,4),('214','30','10001',0,5,4),('214','31','10001',0,5,4),('214','32','10001',0,5,4),('214','33','10001',0,5,4),('214','34','10001',0,5,4),('214','35','10001',0,5,4),('214','36','10001',0,5,4),('214','37','10001',0,5,4),('214','48','10001',0,5,4),('214','49','10001',0,5,4),('214','50','10001',0,5,4),('215','29','10001',0,5,4),('215','30','10001',0,5,4),('215','31','10001',0,5,4),('215','32','10001',0,5,4),('215','33','10001',0,5,4),('215','34','10001',0,5,4),('215','35','10001',0,5,4),('215','36','10001',0,5,4),('215','37','10001',0,5,4),('215','48','10001',0,5,4),('215','49','10001',0,5,4),('215','50','10001',0,5,4),('216','29','10001',0,5,4),('216','30','10001',0,5,4),('216','31','10001',0,5,4),('216','34','10001',0,5,4),('216','35','10001',0,5,4),('216','36','10001',0,5,4),('216','37','10001',0,5,4),('216','48','10001',0,5,4),('216','50','10001',0,5,4),('255','51','10001',0,5,4),('255','52','10001',0,5,4),('255','53','10001',0,5,4),('255','54','10001',0,5,4),('255','55','10001',0,5,4),('255','56','10001',0,5,4),('255','57','10001',0,5,4),('255','58','10001',0,5,4),('255','59','10001',0,5,4),('255','60','10001',0,5,4),('255','61','10001',0,5,4),('255','62','10001',0,5,4),('256','51','10001',0,5,4),('256','52','10001',0,5,4),('256','53','10001',0,5,4),('256','54','10001',0,5,4),('256','55','10001',0,5,4),('256','56','10001',0,5,4),('256','57','10001',0,5,4),('256','58','10001',0,5,4),('256','59','10001',0,5,4),('256','60','10001',0,5,4),('256','61','10001',0,5,4),('257','51','10001',0,5,4),('257','52','10001',0,5,4),('257','53','10001',0,5,4),('257','54','10001',0,5,4),('257','55','10001',0,5,4),('257','56','10001',0,5,4),('257','57','10001',0,5,4),('257','58','10001',0,5,4),('257','60','10001',0,5,4),('258','52','10001',0,5,4),('258','53','10001',0,5,4),('258','54','10001',0,5,4),('258','56','10001',0,5,4),('258','57','10001',0,5,4),('258','58','10001',0,5,4),('258','59','10001',0,5,4),('258','60','10001',0,5,4),('303','63','10001',0,5,4),('303','64','10001',0,5,4),('303','65','10001',0,5,4),('303','67','10001',0,5,4),('303','68','10001',0,5,4),('303','69','10001',0,5,4),('303','70','10001',0,5,4),('303','71','10001',0,5,4),('303','72','10001',0,5,4),('303','73','10001',0,5,4),('303','74','10001',0,5,4),('303','75','10001',0,5,4),('303','76','10001',0,5,4),('303','77','10001',0,5,4),('304','63','10001',0,5,4),('304','64','10001',0,5,4),('304','65','10001',0,5,4),('304','67','10001',0,5,4),('304','68','10001',0,5,4),('304','69','10001',0,5,4),('304','70','10001',0,5,4),('304','71','10001',0,5,4),('304','72','10001',0,5,4),('304','73','10001',0,5,4),('304','74','10001',0,5,4),('304','75','10001',0,5,4),('304','76','10001',0,5,4),('304','77','10001',0,5,4),('305','63','10001',0,5,4),('305','64','10001',0,5,4),('305','65','10001',0,5,4),('305','67','10001',0,5,4),('305','68','10001',0,5,4),('305','69','10001',0,5,4),('305','70','10001',0,5,4),('305','71','10001',0,5,4),('305','72','10001',0,5,4),('305','73','10001',0,5,4),('305','74','10001',0,5,4),('305','75','10001',0,5,4),('305','76','10001',0,5,4),('305','77','10001',0,5,4),('307','64','10001',0,5,4),('307','65','10001',0,5,4),('307','68','10001',0,5,4),('307','70','10001',0,5,4),('308','67','10001',0,5,4),('308','69','10001',0,5,4),('308','70','10001',0,5,4),('308','75','10001',0,5,4),('309','67','10001',0,5,4),('309','68','10001',0,5,4),('309','71','10001',0,5,4),('309','72','10001',0,5,4),('309','75','10001',0,5,4),('310','65','10001',0,5,4),('310','70','10001',0,5,4),('310','71','10001',0,5,4),('310','74','10001',0,5,4),('311','74','10001',0,5,4),('2','1','10001',0,6,4),('2','2','10001',0,6,4),('2','7','10001',0,6,4),('2','9','10001',0,6,4),('2','10','10001',0,6,4),('2','17','10001',0,6,4),('2','18','10001',0,6,4),('2','19','10001',0,6,4),('2','20','10001',0,6,4),('2','21','10001',0,6,4),('2','22','10001',0,6,4),('2','23','10001',0,6,4),('2','24','10001',0,6,4),('2','25','10001',0,6,4),('2','26','10001',0,6,4),('2','27','10001',0,6,4),('2','28','10001',0,6,4),('2','29','1',1,6,4),('2','30','1',1,6,4),('2','31','1',1,6,4),('2','32','1',1,6,4),('2','33','1',1,6,4),('2','34','1',1,6,4),('2','35','1',1,6,4),('2','36','1',1,6,4),('2','37','1',1,6,4),('2','48','1',1,6,4),('2','49','1',1,6,4),('2','50','1',1,6,4),('2','51','1',1,6,4),('2','52','1',1,6,4),('2','53','1',1,6,4),('2','54','1',1,6,4),('2','55','1',1,6,4),('2','56','1',1,6,4),('2','57','1',1,6,4),('2','58','1',1,6,4),('2','59','1',1,6,4),('2','60','1',1,6,4),('2','61','1',1,6,4),('2','62','1',1,6,4),('2','63','1',1,6,4),('2','64','1',1,6,4),('2','65','1',1,6,4),('2','67','1',1,6,4),('2','68','1',1,6,4),('2','69','1',1,6,4),('2','70','1',1,6,4),('2','71','1',1,6,4),('2','72','1',1,6,4),('2','73','1',1,6,4),('2','74','1',1,6,4),('2','75','1',1,6,4),('2','76','1',1,6,4),('2','77','1',1,6,4),('147','1','1',1,6,4),('147','2','1',1,6,4),('147','7','1',1,6,4),('147','9','1',1,6,4),('147','10','1',1,6,4),('147','17','1',1,6,4),('147','18','1',1,6,4),('147','19','1',1,6,4),('147','20','1',1,6,4),('147','21','1',1,6,4),('147','22','1',1,6,4),('147','23','1',1,6,4),('147','24','1',1,6,4),('147','25','1',1,6,4),('147','26','1',1,6,4),('147','27','1',1,6,4),('147','28','1',1,6,4),('148','1','1',1,6,4),('148','2','1',1,6,4),('148','7','1',1,6,4),('148','9','1',1,6,4),('148','10','1',1,6,4),('148','17','1',1,6,4),('148','18','1',1,6,4),('148','19','1',1,6,4),('148','20','1',1,6,4),('148','21','1',1,6,4),('148','22','1',1,6,4),('148','23','1',1,6,4),('148','24','1',1,6,4),('148','25','1',1,6,4),('148','26','1',1,6,4),('148','27','1',1,6,4),('148','28','1',1,6,4),('188','1','1',1,6,4),('188','2','1',1,6,4),('188','7','1',1,6,4),('188','9','1',1,6,4),('188','10','1',1,6,4),('188','17','1',1,6,4),('188','18','1',1,6,4),('188','19','1',1,6,4),('188','20','1',1,6,4),('188','21','1',1,6,4),('188','22','1',1,6,4),('188','23','1',1,6,4),('188','24','1',1,6,4),('188','25','1',1,6,4),('188','26','1',1,6,4),('188','27','1',1,6,4),('188','28','1',1,6,4),('189','1','1',1,6,4),('189','2','1',1,6,4),('189','7','1',1,6,4),('189','9','1',1,6,4),('189','10','1',1,6,4),('189','17','1',1,6,4),('189','18','1',1,6,4),('189','19','1',1,6,4),('189','20','1',1,6,4),('189','21','1',1,6,4),('189','22','1',1,6,4),('189','23','1',1,6,4),('189','24','1',1,6,4),('189','25','1',1,6,4),('189','26','1',1,6,4),('189','27','1',1,6,4),('189','28','1',1,6,4),('190','1','1',1,6,4),('190','2','1',1,6,4),('190','9','1',1,6,4),('190','10','1',1,6,4),('190','17','1',1,6,4),('190','18','1',1,6,4),('190','19','1',1,6,4),('190','20','1',1,6,4),('190','21','1',1,6,4),('190','22','1',1,6,4),('190','23','1',1,6,4),('190','24','1',1,6,4),('190','25','1',1,6,4),('190','26','1',1,6,4),('190','27','1',1,6,4),('191','9','1',1,6,4),('191','10','1',1,6,4),('191','17','1',1,6,4),('191','19','1',1,6,4),('191','20','1',1,6,4),('191','21','1',1,6,4),('191','22','1',1,6,4),('191','23','1',1,6,4),('191','24','1',1,6,4),('191','25','1',1,6,4),('191','27','1',1,6,4),('192','9','1',1,6,4),('192','17','1',1,6,4),('192','18','1',1,6,4),('192','19','1',1,6,4),('192','22','1',1,6,4),('192','24','1',1,6,4),('193','9','1',1,6,4),('193','20','1',1,6,4),('193','22','1',1,6,4),('194','27','1',1,6,4),('195','9','1',1,6,4),('195','10','1',1,6,4),('195','17','1',1,6,4),('195','18','1',1,6,4),('195','22','1',1,6,4),('195','25','1',1,6,4),('196','9','1',1,6,4),('196','10','1',1,6,4),('196','18','1',1,6,4),('196','22','1',1,6,4),('197','17','1',1,6,4),('197','23','1',1,6,4),('199','10','1',1,6,4),('199','18','1',1,6,4),('199','23','1',1,6,4),('199','25','1',1,6,4),('200','10','1',1,6,4),('200','18','1',1,6,4),('200','23','1',1,6,4),('203','1','1',1,6,4),('203','2','1',1,6,4),('203','9','1',1,6,4),('203','10','1',1,6,4),('203','17','1',1,6,4),('203','18','1',1,6,4),('203','19','1',1,6,4),('203','20','1',1,6,4),('203','21','1',1,6,4),('203','22','1',1,6,4),('203','23','1',1,6,4),('203','24','1',1,6,4),('203','25','1',1,6,4),('203','26','1',1,6,4),('203','27','1',1,6,4),('204','1','1',1,6,4),('204','2','1',1,6,4),('204','7','1',1,6,4),('204','9','1',1,6,4),('204','10','1',1,6,4),('204','17','1',1,6,4),('204','18','1',1,6,4),('204','19','1',1,6,4),('204','20','1',1,6,4),('204','21','1',1,6,4),('204','22','1',1,6,4),('204','23','1',1,6,4),('204','24','1',1,6,4),('204','25','1',1,6,4),('204','26','1',1,6,4),('204','27','1',1,6,4),('205','10','1',1,6,4),('205','17','1',1,6,4),('205','18','1',1,6,4),('205','19','1',1,6,4),('205','21','1',1,6,4),('205','23','1',1,6,4),('205','27','1',1,6,4),('206','17','1',1,6,4),('206','18','1',1,6,4),('206','19','1',1,6,4),('207','10','1',1,6,4),('207','19','1',1,6,4),('208','27','1',1,6,4),('209','10','1',1,6,4),('209','17','1',1,6,4),('209','19','1',1,6,4),('209','21','1',1,6,4),('209','27','1',1,6,4),('210','10','1',1,6,4),('210','17','1',1,6,4),('210','19','1',1,6,4),('210','27','1',1,6,4),('211','17','1',1,6,4),('213','29','10001',0,6,4),('213','30','10001',0,6,4),('213','31','10001',0,6,4),('213','32','10001',0,6,4),('213','33','10001',0,6,4),('213','34','10001',0,6,4),('213','35','10001',0,6,4),('213','36','10001',0,6,4),('213','37','10001',0,6,4),('213','48','10001',0,6,4),('213','49','10001',0,6,4),('213','50','10001',0,6,4),('214','29','10001',0,6,4),('214','30','10001',0,6,4),('214','31','10001',0,6,4),('214','32','10001',0,6,4),('214','33','10001',0,6,4),('214','34','10001',0,6,4),('214','35','10001',0,6,4),('214','36','10001',0,6,4),('214','37','10001',0,6,4),('214','48','10001',0,6,4),('214','49','10001',0,6,4),('214','50','10001',0,6,4),('215','29','10001',0,6,4),('215','30','10001',0,6,4),('215','31','10001',0,6,4),('215','32','10001',0,6,4),('215','33','10001',0,6,4),('215','34','10001',0,6,4),('215','35','10001',0,6,4),('215','36','10001',0,6,4),('215','37','10001',0,6,4),('215','48','10001',0,6,4),('215','49','10001',0,6,4),('215','50','10001',0,6,4),('216','29','10001',0,6,4),('216','30','10001',0,6,4),('216','31','10001',0,6,4),('216','34','10001',0,6,4),('216','35','10001',0,6,4),('216','36','10001',0,6,4),('216','37','10001',0,6,4),('216','48','10001',0,6,4),('216','50','10001',0,6,4),('255','51','10001',0,6,4),('255','52','10001',0,6,4),('255','53','10001',0,6,4),('255','54','10001',0,6,4),('255','55','10001',0,6,4),('255','56','10001',0,6,4),('255','57','10001',0,6,4),('255','58','10001',0,6,4),('255','59','10001',0,6,4),('255','60','10001',0,6,4),('255','61','10001',0,6,4),('255','62','10001',0,6,4),('256','51','10001',0,6,4),('256','52','10001',0,6,4),('256','53','10001',0,6,4),('256','54','10001',0,6,4),('256','55','10001',0,6,4),('256','56','10001',0,6,4),('256','57','10001',0,6,4),('256','58','10001',0,6,4),('256','59','10001',0,6,4),('256','60','10001',0,6,4),('256','61','10001',0,6,4),('257','51','10001',0,6,4),('257','52','10001',0,6,4),('257','53','10001',0,6,4),('257','54','10001',0,6,4),('257','55','10001',0,6,4),('257','56','10001',0,6,4),('257','57','10001',0,6,4),('257','58','10001',0,6,4),('257','60','10001',0,6,4),('258','52','10001',0,6,4),('258','53','10001',0,6,4),('258','54','10001',0,6,4),('258','56','10001',0,6,4),('258','57','10001',0,6,4),('258','58','10001',0,6,4),('258','59','10001',0,6,4),('258','60','10001',0,6,4),('303','63','10001',0,6,4),('303','64','10001',0,6,4),('303','65','10001',0,6,4),('303','67','10001',0,6,4),('303','68','10001',0,6,4),('303','69','10001',0,6,4),('303','70','10001',0,6,4),('303','71','10001',0,6,4),('303','72','10001',0,6,4),('303','73','10001',0,6,4),('303','74','10001',0,6,4),('303','75','10001',0,6,4),('303','76','10001',0,6,4),('303','77','10001',0,6,4),('304','63','10001',0,6,4),('304','64','10001',0,6,4),('304','65','10001',0,6,4),('304','67','10001',0,6,4),('304','68','10001',0,6,4),('304','69','10001',0,6,4),('304','70','10001',0,6,4),('304','71','10001',0,6,4),('304','72','10001',0,6,4),('304','73','10001',0,6,4),('304','74','10001',0,6,4),('304','75','10001',0,6,4),('304','76','10001',0,6,4),('304','77','10001',0,6,4),('305','63','10001',0,6,4),('305','64','10001',0,6,4),('305','65','10001',0,6,4),('305','67','10001',0,6,4),('305','68','10001',0,6,4),('305','69','10001',0,6,4),('305','70','10001',0,6,4),('305','71','10001',0,6,4),('305','72','10001',0,6,4),('305','73','10001',0,6,4),('305','74','10001',0,6,4),('305','75','10001',0,6,4),('305','76','10001',0,6,4),('305','77','10001',0,6,4),('307','64','10001',0,6,4),('307','65','10001',0,6,4),('307','68','10001',0,6,4),('307','70','10001',0,6,4),('308','67','10001',0,6,4),('308','69','10001',0,6,4),('308','70','10001',0,6,4),('308','75','10001',0,6,4),('309','67','10001',0,6,4),('309','68','10001',0,6,4),('309','71','10001',0,6,4),('309','72','10001',0,6,4),('309','75','10001',0,6,4),('310','65','10001',0,6,4),('310','70','10001',0,6,4),('310','71','10001',0,6,4),('310','74','10001',0,6,4),('311','74','10001',0,6,4);
/*!40000 ALTER TABLE `catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_tmp`;
CREATE TABLE `catalog_category_product_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  KEY `CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Indexer Temp Table';

--
-- Table structure for table `catalog_compare_item`
--

DROP TABLE IF EXISTS `catalog_compare_item`;
CREATE TABLE `catalog_compare_item` (
  `catalog_compare_item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int(10) unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Store ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Compare Table';

--
-- Table structure for table `catalog_eav_attribute`
--

DROP TABLE IF EXISTS `catalog_eav_attribute`;
CREATE TABLE `catalog_eav_attribute` (
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `additional_data` text COMMENT 'Additional swatch attributes data',
  PRIMARY KEY (`attribute_id`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog EAV Attribute Table';

--
-- Dumping data for table `catalog_eav_attribute`
--

LOCK TABLES `catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `catalog_eav_attribute` VALUES (45,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(46,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(47,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,'0',1,0,0,0,0,0,'1',NULL),(48,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(49,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(50,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(51,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(54,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(55,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(56,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(59,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(60,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(64,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(65,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(66,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(67,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\Available',0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(68,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\DefaultSortby',0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(69,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(70,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(71,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(72,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Pricestep',0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(73,NULL,0,1,1,0,0,0,0,0,0,1,1,NULL,1,'0',0,0,0,0,0,0,'5',NULL),(74,NULL,1,1,1,0,1,0,0,0,0,0,0,NULL,1,'0',0,0,0,0,0,0,'6',NULL),(75,NULL,0,1,1,0,1,0,1,0,0,0,0,NULL,1,'0',1,0,0,0,0,0,'1',NULL),(76,NULL,0,1,1,0,1,0,1,0,0,1,0,NULL,1,'0',1,0,0,1,0,0,'1',NULL),(77,NULL,2,1,1,1,0,0,0,0,0,1,1,'simple,virtual,bundle,downloadable,configurable',1,'0',0,0,0,0,0,0,'1',NULL),(78,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(79,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,0,'1',NULL),(80,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,0,'1',NULL),(81,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable',0,'0',0,0,0,1,0,1,'1',NULL),(82,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Weight',1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(83,NULL,1,1,1,1,1,0,0,0,0,0,0,NULL,1,'0',0,0,0,1,0,1,'1',NULL),(84,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(85,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(86,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(87,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(88,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(89,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(90,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(91,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(92,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,0,0,0,'1',NULL),(93,NULL,1,1,1,1,1,0,0,0,0,0,0,NULL,1,'0',0,0,0,1,0,1,'1','a:3:{s:17:\"swatch_input_type\";s:6:\"visual\";s:28:\"update_product_preview_image\";s:1:\"1\";s:28:\"use_product_image_for_swatch\";s:1:\"0\";}'),(94,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(95,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(96,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(97,'Magento\\Framework\\Data\\Form\\Element\\Hidden',2,1,1,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,1,0,0,0,'1',NULL),(98,NULL,0,0,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,0,0,0,'1',NULL),(99,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,1,0,0,0,'1',NULL),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(101,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(103,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(104,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(105,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Category',1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(106,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(107,NULL,1,0,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(109,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(110,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(111,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(112,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(113,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(114,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,bundle,grouped,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(115,'Magento\\CatalogInventory\\Block\\Adminhtml\\Form\\Field\\Stock',1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(116,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(117,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(118,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(119,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(120,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(121,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(122,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type\\Price',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,'0',0,0,0,0,0,0,'1',NULL),(123,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(124,NULL,1,1,0,0,0,0,0,0,0,0,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(125,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(126,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(127,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(128,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(129,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(130,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(131,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(132,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(133,NULL,2,1,1,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(134,'Magento\\GiftMessage\\Block\\Adminhtml\\Product\\Helper\\Form\\Config',1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(135,NULL,0,1,0,0,0,0,0,0,0,1,0,'simple,virtual,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(136,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(137,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(138,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(139,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(140,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(141,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL);
/*!40000 ALTER TABLE `catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option`;
CREATE TABLE `catalog_product_bundle_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Id',
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent Id',
  `required` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option';

--
-- Dumping data for table `catalog_product_bundle_option`
--

LOCK TABLES `catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option` DISABLE KEYS */;
INSERT INTO `catalog_product_bundle_option` VALUES ('11','10',1,'1','radio');
/*!40000 ALTER TABLE `catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option_value`;
CREATE TABLE `catalog_product_bundle_option_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value Id',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option Id',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store Id',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_BUNDLE_OPTION_VALUE_OPTION_ID_STORE_ID` (`option_id`,`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option Value';

--
-- Dumping data for table `catalog_product_bundle_option_value`
--

LOCK TABLES `catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` DISABLE KEYS */;
INSERT INTO `catalog_product_bundle_option_value` VALUES ('11','11',0,'Sprite Stasis Ball');
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_price_index`;
CREATE TABLE `catalog_product_bundle_price_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `min_price` decimal(12,4) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Price Index';

--
-- Table structure for table `catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection`;
CREATE TABLE `catalog_product_bundle_selection` (
  `selection_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection Id',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option Id',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product Id',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection';

--
-- Dumping data for table `catalog_product_bundle_selection`
--

LOCK TABLES `catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` DISABLE KEYS */;
INSERT INTO `catalog_product_bundle_selection` VALUES ('25','11','10','1','1',1,0,'0.0000','1.0000',1),('26','11','10','7','2',0,0,'0.0000','1.0000',1);
/*!40000 ALTER TABLE `catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection_price`;
CREATE TABLE `catalog_product_bundle_selection_price` (
  `selection_id` int(10) unsigned NOT NULL COMMENT 'Selection Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  PRIMARY KEY (`selection_id`,`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection Price';

--
-- Table structure for table `catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_stock_index`;
CREATE TABLE `catalog_product_bundle_stock_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `stock_status` smallint(6) DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Stock Index';

--
-- Table structure for table `catalog_product_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity`;
CREATE TABLE `catalog_product_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Table';

--
-- Dumping data for table `catalog_product_entity`
--

LOCK TABLES `catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity` VALUES ('1',4,'simple','24-MB01',0,0,'2016-07-18 08:24:54','2016-07-18 08:24:54'),('2',4,'configurable','MH01',1,1,'2016-07-18 08:29:20','2016-07-18 08:30:42'),('7',4,'virtual','MH01-Black',0,0,'2016-07-18 09:03:24','2016-07-18 09:03:24'),('9',4,'grouped','24-WG085_Group',0,0,'2016-07-18 09:15:48','2016-07-18 09:15:48'),('10',4,'bundle','24-WG080',1,1,'2016-07-18 09:24:36','2016-07-18 09:24:36'),('17',4,'downloadable','240-LV04',0,0,'2016-07-18 10:02:29','2016-07-18 10:02:29'),('18',4,'simple','24-MB04',0,0,'2016-07-18 10:05:47','2016-07-18 10:05:47'),('19',4,'simple','24-MB03',0,0,'2016-07-19 02:06:20','2016-07-19 02:06:20'),('20',4,'simple','24-MB05',0,0,'2016-07-19 02:09:40','2016-07-19 02:09:40'),('21',4,'simple','24-MB06',0,0,'2016-07-19 02:11:54','2016-07-19 02:11:54'),('22',4,'virtual','MH01-Gray',0,0,'2016-07-21 03:27:36','2016-07-21 03:27:36'),('23',4,'simple','Fusio24-MB02',0,0,'2016-07-21 03:36:26','2016-07-21 03:36:26'),('24',4,'simple','24-UB02',0,0,'2016-07-21 03:43:31','2016-07-21 03:43:31'),('25',4,'simple','24-WB01',0,0,'2016-07-21 03:46:12','2016-07-21 03:46:12'),('26',4,'simple','24-WB02',0,0,'2016-07-21 03:48:36','2016-07-21 03:48:36'),('27',4,'simple','24-WB05',0,0,'2016-07-21 03:50:43','2016-07-21 03:50:43'),('28',4,'simple','24-WB06',0,0,'2016-07-21 03:53:10','2016-07-21 03:53:10'),('29',4,'simple','24-WB03',0,0,'2016-07-21 03:55:02','2016-07-21 03:55:02'),('30',4,'virtual','MH02-Black',0,0,'2016-07-21 06:44:07','2016-07-21 06:44:07'),('31',4,'virtual','MH02-Gray',0,0,'2016-07-21 06:44:13','2016-07-21 06:44:13'),('32',4,'configurable','MH02',1,1,'2016-07-21 06:44:14','2016-07-21 06:44:14'),('33',4,'simple','25-WB07',0,0,'2016-07-21 06:47:33','2016-07-21 06:47:33'),('34',4,'simple','25-WB04',0,0,'2016-07-21 06:49:28','2016-07-21 06:49:28'),('35',4,'simple','25-UG06',0,0,'2016-07-21 06:51:26','2016-07-21 06:51:26'),('36',4,'simple','25-UG07',0,0,'2016-07-21 06:53:25','2016-07-21 06:53:25'),('37',4,'simple','25-UG04',0,0,'2016-07-21 07:13:14','2016-07-21 07:13:14'),('48',4,'virtual','MH03-Black',0,0,'2016-07-21 07:48:00','2016-07-21 07:48:00'),('49',4,'virtual','MH03-Gray',0,0,'2016-07-21 07:48:03','2016-07-21 07:48:03'),('50',4,'configurable','MH03',1,1,'2016-07-21 07:48:04','2016-07-21 07:48:04'),('51',4,'simple',' Diam Special ',0,0,'2016-12-06 15:48:11','2016-12-06 15:48:11'),('52',4,'simple',' New Diam ',0,0,'2016-12-06 15:51:59','2016-12-06 15:51:59'),('53',4,'simple','Diam Top',0,0,'2016-12-06 15:55:03','2016-12-06 15:55:03'),('54',4,'simple','Donec Shoes',0,0,'2016-12-06 15:57:48','2016-12-06 15:57:48'),('55',4,'simple',' Summer Frame ',0,0,'2016-12-06 16:00:31','2016-12-06 16:00:31'),('56',4,'simple','Adidas Concepts Black',0,0,'2016-12-06 16:03:40','2016-12-06 16:03:40'),('57',4,'simple','Seeulater PK White1',0,0,'2016-12-06 16:06:37','2016-12-06 16:06:37'),('58',4,'simple','Wings Horns Beige',0,0,'2016-12-06 16:09:16','2016-12-06 16:09:16'),('59',4,'simple','Reigning Champ Grey',0,0,'2016-12-06 16:11:51','2016-12-06 16:11:51'),('60',4,'simple','Nike Air  Deluxe White',0,0,'2016-12-06 16:14:36','2016-12-06 16:14:36'),('61',4,'simple','Lavadome Ultra Light',0,0,'2016-12-06 16:17:15','2016-12-06 16:17:15'),('62',4,'simple','seeulater PK White2',0,0,'2016-12-06 16:20:28','2016-12-06 16:20:28'),('63',4,'simple','CTX 4pc Starter Set',0,0,'2016-12-09 08:44:46','2016-12-09 08:44:46'),('64',4,'simple','Chasseur Escoffier',0,0,'2016-12-09 08:50:36','2016-12-09 08:50:36'),('65',4,'simple','5pc Knife Block Set',0,0,'2016-12-09 08:53:47','2016-12-09 08:53:47'),('67',4,'simple','5pc Knife Block Set1',0,0,'2016-12-09 08:57:41','2016-12-09 08:57:41'),('68',4,'simple','3pc Knife Block Set',0,0,'2016-12-09 09:01:25','2016-12-09 09:01:25'),('69',4,'simple','Serroni Unbreakable',0,0,'2016-12-09 09:06:10','2016-12-09 09:06:10'),('70',4,'simple','Infusion Pitcher',0,0,'2016-12-09 09:09:02','2016-12-09 09:09:02'),('71',4,'simple','Totally Bamboo',0,0,'2016-12-09 09:13:53','2016-12-09 09:13:53'),('72',4,'simple','Scanpan Spectrum',0,0,'2016-12-09 09:18:58','2016-12-09 09:18:58'),('73',4,'simple','Chasseur La Cuisson',0,0,'2016-12-09 09:22:09','2016-12-09 09:22:09'),('74',4,'simple','KitchenAid Pro',0,0,'2016-12-09 09:25:11','2016-12-09 09:25:11'),('75',4,'simple','Scanpan CTX Coveredr',0,0,'2016-12-09 09:29:27','2016-12-09 09:29:27'),('76',4,'simple','Raco Contemporaryde',0,0,'2016-12-09 09:32:58','2016-12-09 09:32:58'),('77',4,'simple','Emile Henry Braiserr',0,0,'2016-12-09 09:36:36','2016-12-09 09:36:36');
/*!40000 ALTER TABLE `catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_product_entity_datetime`;
CREATE TABLE `catalog_product_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Datetime Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_datetime`
--

LOCK TABLES `catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_datetime` VALUES ('1',79,0,'18','2016-07-18 00:00:00'),('2',80,0,'18','2025-07-18 00:00:00'),('3',94,0,'18','2016-07-18 00:00:00'),('4',101,0,'18','2016-07-18 00:00:00'),('5',79,0,'19','2016-07-19 00:00:00'),('6',80,0,'19','2025-07-23 00:00:00'),('7',94,0,'19','2016-09-06 00:00:00'),('8',101,0,'19','2016-07-19 00:00:00'),('9',79,0,'20','2016-07-19 00:00:00'),('10',80,0,'20','2025-07-16 00:00:00'),('11',94,0,'20','2016-07-19 00:00:00'),('12',101,0,'20','2016-07-19 00:00:00'),('13',95,0,'21','2025-07-08 00:00:00'),('14',95,0,'23','2025-07-23 00:00:00'),('15',79,0,'24','2016-07-21 00:00:00'),('16',80,0,'24','2025-07-23 00:00:00'),('17',94,0,'24','2016-07-21 00:00:00'),('18',101,0,'24','2016-07-21 00:00:00'),('19',79,0,'25','2016-07-21 00:00:00'),('20',94,0,'25','2016-09-06 00:00:00'),('21',101,0,'25','2016-07-21 00:00:00'),('22',79,0,'28','2016-07-21 00:00:00'),('23',80,0,'28','2025-07-23 00:00:00'),('24',94,0,'28','2016-07-21 00:00:00'),('25',101,0,'28','2016-07-21 00:00:00'),('26',79,0,'35','2016-07-21 00:00:00'),('27',80,0,'35','2025-07-23 00:00:00'),('28',94,0,'35','2016-09-06 00:00:00'),('29',101,0,'35','2016-07-21 00:00:00'),('30',79,0,'36','2016-07-21 00:00:00'),('31',80,0,'36','2025-07-24 00:00:00'),('32',94,0,'36','2016-07-21 00:00:00'),('33',101,0,'36','2016-07-21 00:00:00'),('34',95,0,'1','2020-09-28 00:00:00'),('35',94,0,'7','2016-09-06 00:00:00'),('36',95,0,'7','2018-09-17 00:00:00'),('37',95,0,'19','2021-09-06 00:00:00'),('38',94,0,'21','2016-09-06 00:00:00'),('39',95,0,'25','2019-09-24 00:00:00'),('40',95,0,'35','2018-09-30 00:00:00'),('41',94,0,'37','2016-09-06 00:00:00'),('42',95,0,'37','2019-09-30 00:00:00'),('43',95,0,'2','2022-11-24 00:00:00'),('44',95,0,'18','2020-11-24 00:00:00'),('45',95,0,'20','2020-11-24 00:00:00'),('46',95,0,'22','2020-11-24 00:00:00'),('47',95,0,'28','2020-11-24 00:00:00'),('48',95,0,'29','2022-12-01 00:00:00'),('49',79,0,'30','2016-12-01 15:36:13'),('50',94,0,'30','2016-12-01 15:36:13'),('51',95,0,'30','2022-12-01 00:00:00'),('52',101,0,'30','2016-12-01 15:36:13'),('53',79,0,'34','2016-12-01 15:56:25'),('54',94,0,'34','2016-12-01 15:56:25'),('55',95,0,'34','2022-12-01 00:00:00'),('56',101,0,'34','2016-12-01 15:56:25'),('57',79,0,'48','2016-12-01 16:11:00'),('58',94,0,'48','2016-12-01 16:11:00'),('59',101,0,'48','2016-12-01 16:11:00'),('60',95,0,'49','2022-12-02 00:00:00'),('61',95,0,'51','2022-12-06 00:00:00'),('62',79,0,'52','2016-12-06 15:51:59'),('63',80,0,'52','2022-12-06 00:00:00'),('64',94,0,'52','2016-12-06 15:51:59'),('65',101,0,'52','2016-12-06 15:51:59'),('66',79,0,'55','2016-12-06 16:00:31'),('67',80,0,'55','2022-12-06 00:00:00'),('68',94,0,'55','2016-12-06 16:00:31'),('69',101,0,'55','2016-12-06 16:00:31'),('70',79,0,'58','2016-12-06 16:09:16'),('71',80,0,'58','2022-12-06 00:00:00'),('72',94,0,'58','2016-12-06 16:09:16'),('73',101,0,'58','2016-12-06 16:09:16'),('74',95,0,'61','1970-01-01 00:00:00'),('75',79,0,'62','2016-12-06 16:20:28'),('76',94,0,'62','2016-12-06 16:20:28'),('77',95,0,'62','2022-12-06 00:00:00'),('78',101,0,'62','2016-12-06 16:20:28'),('79',95,0,'63','2022-12-09 00:00:00'),('80',79,0,'64','2016-12-09 08:50:36'),('81',94,0,'64','2016-12-09 08:50:36'),('82',95,0,'64','2022-12-09 00:00:00'),('83',101,0,'64','2016-12-09 08:50:36'),('84',95,0,'65','2022-12-09 00:00:00'),('86',95,0,'67','2022-12-09 00:00:00'),('87',95,0,'68','2022-12-09 00:00:00'),('88',79,0,'69','2016-12-09 09:06:10'),('89',94,0,'69','2016-12-09 09:06:10'),('90',95,0,'69','2022-12-09 00:00:00'),('91',101,0,'69','2016-12-09 09:06:10'),('92',95,0,'70','2022-12-09 00:00:00'),('93',79,0,'71','2016-12-09 09:13:53'),('94',94,0,'71','2016-12-09 09:13:53'),('95',95,0,'71','2022-12-09 00:00:00'),('96',101,0,'71','2016-12-09 09:13:53'),('97',95,0,'72','2022-12-09 00:00:00'),('98',95,0,'73','2022-12-09 00:00:00'),('99',79,0,'74','2016-12-09 09:25:11'),('100',94,0,'74','2016-12-09 09:25:11'),('101',95,0,'74','2022-12-09 00:00:00'),('102',101,0,'74','2016-12-09 09:25:11'),('103',95,0,'75','2022-12-09 00:00:00'),('104',95,0,'76','2022-12-09 00:00:00'),('105',95,0,'77','2022-12-09 00:00:00');
/*!40000 ALTER TABLE `catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_product_entity_decimal`;
CREATE TABLE `catalog_product_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Decimal Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_decimal`
--

LOCK TABLES `catalog_product_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_decimal` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_decimal` VALUES ('1',77,0,'1','34.0000'),('2',77,0,'2','52.0000'),('7',77,0,'7','52.0000'),('9',77,0,'17','6.0000'),('10',77,0,'18','32.0000'),('11',78,0,'18','32.0000'),('12',81,0,'18','34.0000'),('13',77,0,'19','38.0000'),('14',78,0,'19','38.0000'),('15',81,0,'19','40.0000'),('16',77,0,'20','40.0000'),('17',78,0,'20','40.0000'),('18',81,0,'20','45.0000'),('19',77,0,'21','45.0000'),('20',77,0,'22','52.0000'),('21',77,0,'23','59.0000'),('22',77,0,'24','74.0000'),('23',78,0,'24','70.0000'),('24',77,0,'25','32.0000'),('25',78,0,'25','30.0000'),('26',77,0,'26','32.0000'),('27',77,0,'27','35.0000'),('28',77,0,'28','33.0000'),('29',78,0,'28','30.0000'),('30',77,0,'29','36.0000'),('31',77,0,'30','70.0000'),('32',77,0,'31','70.0000'),('33',77,0,'32','70.0000'),('34',77,0,'33','45.0000'),('35',77,0,'34','50.0000'),('36',77,0,'35','10.0000'),('37',78,0,'35','8.0000'),('38',77,0,'36','12.0000'),('39',78,0,'36','8.0000'),('40',77,0,'37','12.0000'),('53',77,0,'48','63.0000'),('54',77,0,'49','63.0000'),('55',77,0,'50','63.0000'),('56',78,0,'30','54.0000'),('57',78,0,'34','35.0000'),('58',78,0,'48','45.0000'),('59',77,0,'51','44.0000'),('60',82,0,'51','30.0000'),('61',77,0,'52','78.0000'),('62',78,0,'52','45.0000'),('63',82,0,'52','31.0000'),('64',77,0,'53','66.0000'),('65',82,0,'53','32.0000'),('66',77,0,'54','75.0000'),('67',82,0,'54','33.0000'),('68',77,0,'55','88.0000'),('69',78,0,'55','55.0000'),('70',82,0,'55','34.0000'),('71',77,0,'56','41.0000'),('72',82,0,'56','35.0000'),('73',77,0,'57','66.0000'),('74',82,0,'57','36.0000'),('75',77,0,'58','87.0000'),('76',78,0,'58','50.0000'),('77',82,0,'58','37.0000'),('78',77,0,'59','6545.0000'),('79',82,0,'59','38.0000'),('80',77,0,'60','80.0000'),('81',82,0,'60','40.0000'),('82',77,0,'61','55.0000'),('83',82,0,'61','41.0000'),('84',77,0,'62','76.0000'),('85',78,0,'62','43.0000'),('86',82,0,'62','42.0000'),('87',77,0,'63','45.0000'),('88',82,0,'63','45.0000'),('89',77,0,'64','76.0000'),('90',78,0,'64','43.0000'),('91',82,0,'64','46.0000'),('92',77,0,'65','67.0000'),('93',82,0,'65','47.0000'),('96',77,0,'67','88.0000'),('97',82,0,'67','57.0000'),('98',77,0,'68','55.0000'),('99',82,0,'68','58.0000'),('100',77,0,'69','76.0000'),('101',78,0,'69','55.0000'),('102',82,0,'69','59.0000'),('103',77,0,'70','65.0000'),('104',82,0,'70','60.0000'),('105',77,0,'71','87.0000'),('106',78,0,'71','35.0000'),('107',82,0,'71','61.0000'),('108',77,0,'72','54.0000'),('109',82,0,'72','62.0000'),('110',77,0,'73','75.0000'),('111',82,0,'73','63.0000'),('112',77,0,'74','83.0000'),('113',78,0,'74','65.0000'),('114',82,0,'74','65.0000'),('115',77,0,'75','57.0000'),('116',82,0,'75','66.0000'),('117',77,0,'76','80.0000'),('118',82,0,'76','68.0000'),('119',77,0,'77','64.0000'),('120',82,0,'77','69.0000');
/*!40000 ALTER TABLE `catalog_product_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_gallery`;
CREATE TABLE `catalog_product_entity_gallery` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Gallery Attribute Backend Table';

--
-- Table structure for table `catalog_product_entity_int`
--

DROP TABLE IF EXISTS `catalog_product_entity_int`;
CREATE TABLE `catalog_product_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=551 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Integer Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_int`
--

LOCK TABLES `catalog_product_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_int` VALUES ('1',83,0,'1','16'),('2',93,0,'1','4'),('3',97,0,'1','1'),('4',99,0,'1','4'),('5',115,0,'1','1'),('6',133,0,'1','2'),('9',97,0,'2','1'),('10',99,0,'2','4'),('11',115,0,'2','1'),('12',133,0,'2','2'),('37',83,0,'7','17'),('38',93,0,'7','4'),('39',97,0,'7','1'),('40',99,0,'7','4'),('41',115,0,'7','1'),('42',133,0,'7','2'),('49',83,0,'9','19'),('50',93,0,'9','7'),('51',97,0,'9','1'),('52',99,0,'9','4'),('53',115,0,'9','1'),('54',83,0,'2','22'),('55',83,0,'10','20'),('56',93,0,'10','9'),('57',97,0,'10','1'),('58',99,0,'10','4'),('59',115,0,'10','1'),('60',123,0,'10','0'),('61',124,0,'10','0'),('62',125,0,'10','0'),('63',126,0,'10','0'),('64',127,0,'10','0'),('65',133,0,'10','2'),('132',83,0,'17','21'),('133',93,0,'17','12'),('134',97,0,'17','1'),('135',99,0,'17','4'),('136',115,0,'17','1'),('137',128,0,'17','0'),('138',133,0,'17','2'),('139',83,0,'18','18'),('140',93,0,'18','15'),('141',97,0,'18','1'),('142',99,0,'18','4'),('143',115,0,'18','1'),('144',133,0,'18','2'),('145',83,0,'19','18'),('146',93,0,'19','13'),('147',97,0,'19','1'),('148',99,0,'19','4'),('149',115,0,'19','1'),('150',133,0,'19','2'),('151',83,0,'20','21'),('152',93,0,'20','11'),('153',97,0,'20','1'),('154',99,0,'20','4'),('155',115,0,'20','1'),('156',133,0,'20','2'),('157',83,0,'21','17'),('158',93,0,'21','8'),('159',97,0,'21','1'),('160',99,0,'21','4'),('161',115,0,'21','1'),('162',133,0,'21','2'),('163',83,0,'22','22'),('164',93,0,'22','7'),('165',97,0,'22','1'),('166',99,0,'22','4'),('167',115,0,'22','1'),('168',133,0,'22','2'),('169',83,0,'23','17'),('170',93,0,'23','9'),('171',97,0,'23','1'),('172',99,0,'23','4'),('173',115,0,'23','1'),('174',133,0,'23','2'),('175',83,0,'24','16'),('176',93,0,'24','13'),('177',97,0,'24','1'),('178',99,0,'24','4'),('179',115,0,'24','1'),('180',133,0,'24','2'),('181',83,0,'25','18'),('182',93,0,'25','12'),('183',97,0,'25','1'),('184',99,0,'25','4'),('185',115,0,'25','1'),('186',133,0,'25','2'),('187',83,0,'26','21'),('188',93,0,'26','8'),('189',97,0,'26','1'),('190',99,0,'26','4'),('191',115,0,'26','1'),('192',133,0,'26','2'),('193',83,0,'27','19'),('194',93,0,'27','11'),('195',97,0,'27','1'),('196',99,0,'27','4'),('197',115,0,'27','1'),('198',133,0,'27','2'),('199',83,0,'28','20'),('200',93,0,'28','5'),('201',97,0,'28','1'),('202',99,0,'28','4'),('203',115,0,'28','1'),('204',133,0,'28','2'),('205',83,0,'29','17'),('206',93,0,'29','5'),('207',97,0,'29','1'),('208',99,0,'29','4'),('209',115,0,'29','1'),('210',133,0,'29','2'),('211',83,0,'30','17'),('212',93,0,'30','4'),('213',97,0,'30','1'),('214',99,0,'30','4'),('215',115,0,'30','1'),('216',133,0,'30','2'),('217',83,0,'31','17'),('218',93,0,'31','5'),('219',97,0,'31','1'),('220',99,0,'31','4'),('221',115,0,'31','1'),('222',133,0,'31','2'),('223',83,0,'32','17'),('225',97,0,'32','1'),('226',99,0,'32','4'),('227',115,0,'32','1'),('228',133,0,'32','2'),('229',83,0,'33','18'),('230',93,0,'33','12'),('231',97,0,'33','1'),('232',99,0,'33','4'),('233',115,0,'33','1'),('234',133,0,'33','2'),('235',83,0,'34','20'),('236',93,0,'34','9'),('237',97,0,'34','1'),('238',99,0,'34','4'),('239',115,0,'34','1'),('240',133,0,'34','2'),('241',83,0,'35','19'),('242',93,0,'35','8'),('243',97,0,'35','1'),('244',99,0,'35','4'),('245',115,0,'35','1'),('246',133,0,'35','2'),('247',83,0,'36','17'),('248',93,0,'36','14'),('249',97,0,'36','1'),('250',99,0,'36','4'),('251',115,0,'36','1'),('252',133,0,'36','2'),('253',83,0,'37','19'),('254',93,0,'37','8'),('255',97,0,'37','1'),('256',99,0,'37','4'),('257',115,0,'37','1'),('258',133,0,'37','2'),('318',83,0,'48','18'),('319',93,0,'48','4'),('320',97,0,'48','1'),('321',99,0,'48','4'),('322',115,0,'48','1'),('323',133,0,'48','2'),('324',83,0,'49','18'),('325',93,0,'49','12'),('326',97,0,'49','1'),('327',99,0,'49','4'),('328',115,0,'49','1'),('329',133,0,'49','2'),('330',83,0,'50','18'),('332',97,0,'50','1'),('333',99,0,'50','4'),('334',115,0,'50','1'),('335',133,0,'50','0'),('336',135,0,'21','1'),('337',135,0,'1','1'),('338',135,0,'2','1'),('339',135,0,'7','1'),('340',135,0,'18','1'),('341',135,0,'19','0'),('342',135,0,'20','1'),('343',135,0,'22','1'),('344',135,0,'23','1'),('345',135,0,'24','1'),('346',135,0,'25','1'),('347',135,0,'26','1'),('348',135,0,'27','1'),('349',135,0,'28','1'),('350',135,0,'29','1'),('351',135,0,'30','1'),('352',135,0,'31','1'),('353',135,0,'32','1'),('354',135,0,'33','1'),('355',135,0,'34','1'),('356',135,0,'35','1'),('357',135,0,'36','1'),('358',135,0,'37','1'),('359',135,0,'48','1'),('360',135,0,'49','1'),('361',135,0,'50','1'),('362',83,0,'51','16'),('363',93,0,'51','4'),('364',97,0,'51','1'),('365',99,0,'51','4'),('366',115,0,'51','1'),('367',133,0,'51','0'),('368',135,0,'51','1'),('369',83,0,'52','17'),('370',93,0,'52','5'),('371',97,0,'52','1'),('372',99,0,'52','4'),('373',115,0,'52','1'),('374',133,0,'52','0'),('375',135,0,'52','1'),('376',83,0,'53','18'),('377',93,0,'53','7'),('378',97,0,'53','1'),('379',99,0,'53','4'),('380',115,0,'53','1'),('381',133,0,'53','0'),('382',135,0,'53','1'),('383',83,0,'54','19'),('384',93,0,'54','8'),('385',97,0,'54','1'),('386',99,0,'54','4'),('387',115,0,'54','1'),('388',133,0,'54','0'),('389',135,0,'54','1'),('390',83,0,'55','20'),('391',93,0,'55','9'),('392',97,0,'55','1'),('393',99,0,'55','4'),('394',115,0,'55','1'),('395',133,0,'55','0'),('396',135,0,'55','1'),('397',83,0,'56','21'),('398',93,0,'56','10'),('399',97,0,'56','1'),('400',99,0,'56','4'),('401',115,0,'56','1'),('402',133,0,'56','0'),('403',135,0,'56','1'),('404',83,0,'57','22'),('405',93,0,'57','13'),('406',97,0,'57','1'),('407',99,0,'57','4'),('408',115,0,'57','1'),('409',133,0,'57','0'),('410',135,0,'57','1'),('411',83,0,'58','17'),('412',93,0,'58','15'),('413',97,0,'58','1'),('414',99,0,'58','4'),('415',115,0,'58','1'),('416',133,0,'58','2'),('417',135,0,'58','1'),('418',83,0,'59','16'),('419',93,0,'59','5'),('420',97,0,'59','1'),('421',99,0,'59','4'),('422',115,0,'59','1'),('423',133,0,'59','0'),('424',135,0,'59','1'),('425',83,0,'60','21'),('426',93,0,'60','8'),('427',97,0,'60','1'),('428',99,0,'60','4'),('429',115,0,'60','1'),('430',133,0,'60','0'),('431',135,0,'60','1'),('432',83,0,'61','17'),('433',93,0,'61','14'),('434',97,0,'61','1'),('435',99,0,'61','4'),('436',115,0,'61','1'),('437',133,0,'61','0'),('438',135,0,'61','1'),('439',83,0,'62','21'),('440',93,0,'62','13'),('441',97,0,'62','1'),('442',99,0,'62','4'),('443',115,0,'62','1'),('444',133,0,'62','2'),('445',135,0,'62','1'),('446',83,0,'63','21'),('447',93,0,'63','5'),('448',97,0,'63','1'),('449',99,0,'63','4'),('450',115,0,'63','1'),('451',133,0,'63','0'),('452',135,0,'63','1'),('453',83,0,'64','16'),('454',93,0,'64','4'),('455',97,0,'64','1'),('456',99,0,'64','4'),('457',115,0,'64','1'),('458',133,0,'64','0'),('459',135,0,'64','1'),('460',83,0,'65','18'),('461',93,0,'65','6'),('462',97,0,'65','1'),('463',99,0,'65','4'),('464',115,0,'65','1'),('465',133,0,'65','0'),('466',135,0,'65','1'),('474',83,0,'67','17'),('475',93,0,'67','6'),('476',97,0,'67','1'),('477',99,0,'67','4'),('478',115,0,'67','1'),('479',133,0,'67','0'),('480',135,0,'67','1'),('481',83,0,'68','19'),('482',93,0,'68','7'),('483',97,0,'68','1'),('484',99,0,'68','4'),('485',115,0,'68','1'),('486',133,0,'68','0'),('487',135,0,'68','1'),('488',83,0,'69','19'),('489',93,0,'69','10'),('490',97,0,'69','1'),('491',99,0,'69','4'),('492',115,0,'69','1'),('493',133,0,'69','2'),('494',135,0,'69','1'),('495',83,0,'70','17'),('496',93,0,'70','14'),('497',97,0,'70','1'),('498',99,0,'70','4'),('499',115,0,'70','1'),('500',133,0,'70','0'),('501',135,0,'70','1'),('502',83,0,'71','19'),('503',93,0,'71','6'),('504',97,0,'71','1'),('505',99,0,'71','4'),('506',115,0,'71','1'),('507',133,0,'71','0'),('508',135,0,'71','1'),('509',83,0,'72','18'),('510',93,0,'72','8'),('511',97,0,'72','1'),('512',99,0,'72','4'),('513',115,0,'72','1'),('514',133,0,'72','0'),('515',135,0,'72','1'),('516',83,0,'73','20'),('517',93,0,'73','9'),('518',97,0,'73','1'),('519',99,0,'73','4'),('520',115,0,'73','1'),('521',133,0,'73','2'),('522',135,0,'73','1'),('523',83,0,'74','20'),('524',93,0,'74','13'),('525',97,0,'74','1'),('526',99,0,'74','4'),('527',115,0,'74','1'),('528',133,0,'74','2'),('529',135,0,'74','1'),('530',83,0,'75','17'),('531',93,0,'75','14'),('532',97,0,'75','1'),('533',99,0,'75','4'),('534',115,0,'75','1'),('535',133,0,'75','0'),('536',135,0,'75','1'),('537',83,0,'76','18'),('538',93,0,'76','7'),('539',97,0,'76','1'),('540',99,0,'76','4'),('541',115,0,'76','1'),('542',133,0,'76','0'),('543',135,0,'76','1'),('544',83,0,'77','18'),('545',93,0,'77','12'),('546',97,0,'77','1'),('547',99,0,'77','4'),('548',115,0,'77','1'),('549',133,0,'77','0'),('550',135,0,'77','1');
/*!40000 ALTER TABLE `catalog_product_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery`;
CREATE TABLE `catalog_product_entity_media_gallery` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  `media_type` varchar(32) NOT NULL DEFAULT 'image' COMMENT 'Media entry type',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility status',
  PRIMARY KEY (`value_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID` (`attribute_id`)
) ENGINE=InnoDB AUTO_INCREMENT=452 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_media_gallery`
--

LOCK TABLES `catalog_product_entity_media_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery` VALUES ('168',90,'/1/_/1.jpg','image',0),('169',90,'/2/_/2_9.jpg','image',0),('170',90,'/3/_/3_10.jpg','image',0),('171',90,'/4/_/4_11.jpg','image',0),('172',90,'/5/_/5_14.jpg','image',0),('173',90,'/2/_/2_10.jpg','image',0),('174',90,'/3/_/3_11.jpg','image',0),('175',90,'/4/_/4_12.jpg','image',0),('176',90,'/5/_/5_15.jpg','image',0),('177',90,'/6/_/6_12.jpg','image',0),('178',90,'/3/_/3_12.jpg','image',0),('179',90,'/4/_/4_13.jpg','image',0),('180',90,'/5/_/5_16.jpg','image',0),('181',90,'/6/_/6_13.jpg','image',0),('182',90,'/7/_/7_5.jpg','image',0),('183',90,'/4/_/4_14.jpg','image',0),('184',90,'/5/_/5_17.jpg','image',0),('185',90,'/6/_/6_14.jpg','image',0),('186',90,'/7/_/7_6.jpg','image',0),('187',90,'/9/_/9_5.jpg','image',0),('188',90,'/5/_/5_18.jpg','image',0),('189',90,'/6/_/6_15.jpg','image',0),('190',90,'/7/_/7_7.jpg','image',0),('191',90,'/9/_/9_6.jpg','image',0),('192',90,'/1/0/10_6.jpg','image',0),('193',90,'/6/_/6_16.jpg','image',0),('194',90,'/7/_/7_8.jpg','image',0),('195',90,'/9/_/9_7.jpg','image',0),('196',90,'/1/0/10_7.jpg','image',0),('197',90,'/1/1/11_7.jpg','image',0),('198',90,'/7/_/7_9.jpg','image',0),('199',90,'/9/_/9_8.jpg','image',0),('200',90,'/1/0/10_8.jpg','image',0),('201',90,'/1/1/11_8.jpg','image',0),('202',90,'/1/2/12_1.jpg','image',0),('203',90,'/9/_/9_9.jpg','image',0),('204',90,'/1/0/10_9.jpg','image',0),('205',90,'/1/1/11_9.jpg','image',0),('206',90,'/1/2/12_3.jpg','image',0),('207',90,'/1/3/13_4.jpg','image',0),('208',90,'/1/0/10_10.jpg','image',0),('209',90,'/1/1/11_10.jpg','image',0),('210',90,'/1/2/12_4.jpg','image',0),('211',90,'/1/3/13_5.jpg','image',0),('212',90,'/1/4/14_4.jpg','image',0),('213',90,'/1/1/11_11.jpg','image',0),('214',90,'/1/2/12_9.jpg','image',0),('215',90,'/1/3/13_6.jpg','image',0),('216',90,'/1/4/14_5.jpg','image',0),('217',90,'/1/5/15_7.jpg','image',0),('218',90,'/1/2/12_10.jpg','image',0),('219',90,'/1/3/13_12.jpg','image',0),('220',90,'/1/4/14_6.jpg','image',0),('221',90,'/1/5/15_8.jpg','image',0),('222',90,'/1/1/11_12.jpg','image',0),('223',90,'/1/3/13_13.jpg','image',0),('224',90,'/1/4/14_11.jpg','image',0),('225',90,'/1/5/15_9.jpg','image',0),('226',90,'/1/_/1_7.jpg','image',0),('227',90,'/2/_/2_8.jpg','image',0),('228',90,'/1/1/11_2.jpg','image',0),('229',90,'/1/2/12_11.jpg','image',0),('230',90,'/1/3/13_14.jpg','image',0),('231',90,'/1/4/14_12.jpg','image',0),('232',90,'/1/5/15_15.jpg','image',0),('233',90,'/1/4/14_13.jpg','image',0),('234',90,'/1/0/10_1.jpg','image',0),('235',90,'/1/1/11_3.jpg','image',0),('236',90,'/1/2/12_5.jpg','image',0),('237',90,'/1/3/13_7.jpg','image',0),('238',90,'/1/5/15_16.jpg','image',0),('239',90,'/2/_/2.jpg','image',0),('240',90,'/3/_/3.jpg','image',0),('241',90,'/4/_/4_1.jpg','image',0),('242',90,'/5/_/5_11.jpg','image',0),('243',90,'/2/_/2_11.jpg','image',0),('244',90,'/3/_/3_1.jpg','image',0),('245',90,'/4/_/4_15.jpg','image',0),('246',90,'/5/_/5_19.jpg','image',0),('247',90,'/6/_/6.jpg','image',0),('248',90,'/7/_/7.jpg','image',0),('249',90,'/1/2/12_6.jpg','image',0),('250',90,'/1/3/13_15.jpg','image',0),('251',90,'/1/4/14_14.jpg','image',0),('252',90,'/1/5/15_17.jpg','image',0),('253',90,'/1/_/1_9.jpg','image',0),('254',90,'/2/_/2_12.jpg','image',0),('255',90,'/3/_/3_13.jpg','image',0),('256',90,'/4/_/4_16.jpg','image',0),('257',90,'/5/_/5_20.jpg','image',0),('258',90,'/2/_/2_13.jpg','image',0),('259',90,'/3/_/3_14.jpg','image',0),('260',90,'/4/_/4_17.jpg','image',0),('261',90,'/5/_/5_21.jpg','image',0),('262',90,'/6/_/6_1.jpg','image',0),('268',90,'/5/_/5_22.jpg','image',0),('269',90,'/1/_/1_10.jpg','image',0),('270',90,'/2/_/2_14.jpg','image',0),('271',90,'/3/_/3_15.jpg','image',0),('272',90,'/4/_/4_18.jpg','image',0),('273',90,'/6/_/6_17.jpg','image',0),('274',90,'/7/_/7_1.jpg','image',0),('275',90,'/8/_/8.jpg','image',0),('276',90,'/9/_/9.jpg','image',0),('277',90,'/1/0/10_2.jpg','image',0),('278',90,'/7/_/7_10.jpg','image',0),('279',90,'/8/_/8_1.jpg','image',0),('280',90,'/9/_/9_1.jpg','image',0),('281',90,'/1/0/10_3.jpg','image',0),('282',90,'/1/1/11_4.jpg','image',0),('283',90,'/8/_/8_2.jpg','image',0),('284',90,'/1/1/11_13.jpg','image',0),('285',90,'/1/2/12_12.jpg','image',0),('286',90,'/1/4/14_7.jpg','image',0),('287',90,'/1/5/15_10.jpg','image',0),('293',90,'/9/_/9_2.jpg','image',0),('294',90,'/1/0/10_5.jpg','image',0),('295',90,'/1/1/11_15.jpg','image',0),('296',90,'/1/2/12_14.jpg','image',0),('297',90,'/1/3/13_9.jpg','image',0),('298',90,'/1/5/15_11.jpg','image',0),('299',90,'/1/0/10_4.jpg','image',0),('300',90,'/1/1/11_14.jpg','image',0),('301',90,'/1/2/12_13.jpg','image',0),('302',90,'/1/3/13_8.jpg','image',0),('303',90,'/3/_/3_16.jpg','image',0),('304',90,'/4/_/4.jpg','image',0),('305',90,'/5/_/5.jpg','image',0),('306',90,'/6/_/6_10.jpg','image',0),('307',90,'/7/_/7_2.jpg','image',0),('308',90,'/1/3/13_10.jpg','image',0),('309',90,'/5/_/5_12.jpg','image',0),('310',90,'/6/_/6_11.jpg','image',0),('311',90,'/7/_/7_3.jpg','image',0),('312',90,'/8/_/8_3.jpg','image',0),('313',90,'/1/1/11_5.jpg','image',0),('314',90,'/1/2/12_7.jpg','image',0),('315',90,'/1/3/13_16.jpg','image',0),('316',90,'/1/4/14_8.jpg','image',0),('317',90,'/1/5/15_12.jpg','image',0),('318',90,'/6/_/6_18.jpg','image',0),('319',90,'/8/_/8_4.jpg','image',0),('320',90,'/1/2/12_15.jpg','image',0),('321',90,'/1/3/13_17.jpg','image',0),('322',90,'/1/4/14_9.jpg','image',0),('323',90,'/1/_/1_11.jpg','image',0),('324',90,'/3/_/3_9.jpg','image',0),('325',90,'/4/_/4_10.jpg','image',0),('326',90,'/5/_/5_13.jpg','image',0),('327',90,'/3/_/3_17.jpg','image',0),('328',90,'/4/_/4_19.jpg','image',0),('329',90,'/5/_/5_23.jpg','image',0),('330',90,'/6/_/6_19.jpg','image',0),('331',90,'/7/_/7_4.jpg','image',0),('332',90,'/4/_/4_20.jpg','image',0),('333',90,'/5/_/5_24.jpg','image',0),('334',90,'/6/_/6_20.jpg','image',0),('335',90,'/7/_/7_11.jpg','image',0),('336',90,'/8/_/8_5.jpg','image',0),('337',90,'/5/_/5_25.jpg','image',0),('338',90,'/6/_/6_21.jpg','image',0),('339',90,'/7/_/7_12.jpg','image',0),('340',90,'/8/_/8_6.jpg','image',0),('341',90,'/9/_/9_3.jpg','image',0),('342',90,'/6/_/6_22.jpg','image',0),('343',90,'/7/_/7_13.jpg','image',0),('344',90,'/8/_/8_7.jpg','image',0),('345',90,'/9/_/9_4.jpg','image',0),('346',90,'/1/0/10_11.jpg','image',0),('347',90,'/7/_/7_14.jpg','image',0),('348',90,'/8/_/8_8.jpg','image',0),('349',90,'/9/_/9_10.jpg','image',0),('350',90,'/1/0/10_12.jpg','image',0),('351',90,'/1/1/11_6.jpg','image',0),('352',90,'/8/_/8_9.jpg','image',0),('353',90,'/9/_/9_11.jpg','image',0),('354',90,'/1/0/10_13.jpg','image',0),('355',90,'/1/1/11_16.jpg','image',0),('356',90,'/1/2/12_8.jpg','image',0),('357',90,'/9/_/9_12.jpg','image',0),('358',90,'/1/0/10_14.jpg','image',0),('359',90,'/1/1/11_17.jpg','image',0),('360',90,'/1/2/12_16.jpg','image',0),('361',90,'/1/3/13_11.jpg','image',0),('362',90,'/1/0/10_15.jpg','image',0),('363',90,'/1/1/11_18.jpg','image',0),('364',90,'/1/2/12_17.jpg','image',0),('365',90,'/1/3/13_18.jpg','image',0),('366',90,'/1/4/14_10.jpg','image',0),('367',90,'/1/5/15_13.jpg','image',0),('368',90,'/1/1/11_19.jpg','image',0),('369',90,'/1/2/12_18.jpg','image',0),('370',90,'/1/3/13_19.jpg','image',0),('371',90,'/1/4/14_15.jpg','image',0),('372',90,'/1/5/15_14.jpg','image',0),('373',90,'/1/4/14_16.jpg','image',0),('374',90,'/1/0/10_16.jpg','image',0),('375',90,'/1/1/11_20.jpg','image',0),('376',90,'/1/2/12_19.jpg','image',0),('377',90,'/1/3/13_20.jpg','image',0),('378',90,'/1/5/15_18.jpg','image',0),('379',90,'/3/_/3_18.jpg','image',0),('380',90,'/4/_/4_21.jpg','image',0),('381',90,'/5/_/5_26.jpg','image',0),('382',90,'/6/_/6_23.jpg','image',0),('383',90,'/1/_/1_12.jpg','image',0),('384',90,'/2/_/2_15.jpg','image',0),('385',90,'/3/_/3_19.jpg','image',0),('386',90,'/4/_/4_22.jpg','image',0),('387',90,'/5/_/5_27.jpg','image',0),('388',90,'/2/_/2_16.jpg','image',0),('389',90,'/3/_/3_20.jpg','image',0),('390',90,'/4/_/4_23.jpg','image',0),('391',90,'/6/_/6_24.jpg','image',0),('392',90,'/3/_/3_21.jpg','image',0),('393',90,'/4/_/4_24.jpg','image',0),('394',90,'/5/_/5_28.jpg','image',0),('395',90,'/6/_/6_25.jpg','image',0),('396',90,'/7/_/7_15.jpg','image',0),('397',90,'/4/_/4_25.jpg','image',0),('398',90,'/5/_/5_29.jpg','image',0),('399',90,'/6/_/6_26.jpg','image',0),('400',90,'/7/_/7_16.jpg','image',0),('401',90,'/8/_/8_10.jpg','image',0),('402',90,'/9/_/9_13.jpg','image',0),('403',90,'/5/_/5_30.jpg','image',0),('404',90,'/6/_/6_27.jpg','image',0),('405',90,'/7/_/7_17.jpg','image',0),('406',90,'/8/_/8_11.jpg','image',0),('407',90,'/9/_/9_14.jpg','image',0),('408',90,'/6/_/6_28.jpg','image',0),('409',90,'/7/_/7_18.jpg','image',0),('410',90,'/8/_/8_12.jpg','image',0),('411',90,'/9/_/9_15.jpg','image',0),('412',90,'/1/0/10_17.jpg','image',0),('413',90,'/7/_/7_19.jpg','image',0),('414',90,'/8/_/8_13.jpg','image',0),('415',90,'/9/_/9_16.jpg','image',0),('416',90,'/1/0/10_18.jpg','image',0),('417',90,'/1/1/11_21.jpg','image',0),('418',90,'/8/_/8_14.jpg','image',0),('419',90,'/9/_/9_17.jpg','image',0),('420',90,'/1/1/11_22.jpg','image',0),('421',90,'/1/2/12_20.jpg','image',0),('422',90,'/9/_/9_18.jpg','image',0),('423',90,'/1/0/10_19.jpg','image',0),('424',90,'/1/1/11_23.jpg','image',0),('425',90,'/1/2/12_21.jpg','image',0),('426',90,'/1/3/13_21.jpg','image',0),('427',90,'/1/0/10_20.jpg','image',0),('428',90,'/1/1/11_24.jpg','image',0),('429',90,'/1/2/12_22.jpg','image',0),('430',90,'/1/3/13_22.jpg','image',0),('431',90,'/1/4/14_17.jpg','image',0),('432',90,'/1/1/11_25.jpg','image',0),('433',90,'/1/2/12_23.jpg','image',0),('434',90,'/1/3/13_23.jpg','image',0),('435',90,'/1/4/14_18.jpg','image',0),('436',90,'/1/5/15_19.jpg','image',0),('437',90,'/1/2/12_24.jpg','image',0),('438',90,'/1/_/1_13.jpg','image',0),('439',90,'/2/_/2_17.jpg','image',0),('440',90,'/3/_/3_22.jpg','image',0),('441',90,'/4/_/4_26.jpg','image',0),('442',90,'/1/3/13_24.jpg','image',0),('443',90,'/5/_/5_31.jpg','image',0),('444',90,'/6/_/6_29.jpg','image',0),('445',90,'/7/_/7_20.jpg','image',0),('446',90,'/8/_/8_15.jpg','image',0),('447',90,'/1/4/14_19.jpg','image',0),('448',90,'/6/_/6_30.jpg','image',0),('449',90,'/8/_/8_16.jpg','image',0),('450',90,'/1/3/13_25.jpg','image',0),('451',90,'/1/5/15_20.jpg','image',0);
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value`;
CREATE TABLE `catalog_product_entity_media_gallery_value` (
  `value_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Value ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  `position` int(10) unsigned DEFAULT NULL COMMENT 'Position',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Disabled',
  `record_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record Id',
  PRIMARY KEY (`record_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_VALUE_ID` (`value_id`)
) ENGINE=InnoDB AUTO_INCREMENT=526 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Value Table';

--
-- Dumping data for table `catalog_product_entity_media_gallery_value`
--

LOCK TABLES `catalog_product_entity_media_gallery_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery_value` VALUES ('168',0,'1',NULL,'6',0,'201'),('169',0,'1',NULL,'7',0,'202'),('170',0,'1',NULL,'8',0,'203'),('171',0,'1',NULL,'9',0,'204'),('172',0,'1',NULL,'10',0,'205'),('173',0,'2',NULL,'6',0,'217'),('174',0,'2',NULL,'7',0,'218'),('175',0,'2',NULL,'8',0,'219'),('176',0,'2',NULL,'9',0,'220'),('177',0,'2',NULL,'10',0,'221'),('178',0,'7',NULL,'7',0,'222'),('179',0,'7',NULL,'8',0,'223'),('180',0,'7',NULL,'9',0,'224'),('181',0,'7',NULL,'10',0,'225'),('182',0,'7',NULL,'11',0,'226'),('183',0,'9',NULL,'6',0,'227'),('184',0,'9',NULL,'7',0,'228'),('185',0,'9',NULL,'8',0,'229'),('186',0,'9',NULL,'9',0,'230'),('187',0,'9',NULL,'10',0,'231'),('188',0,'10',NULL,'6',0,'232'),('189',0,'10',NULL,'7',0,'233'),('190',0,'10',NULL,'8',0,'234'),('191',0,'10',NULL,'9',0,'235'),('192',0,'10',NULL,'10',0,'236'),('193',0,'17',NULL,'6',0,'237'),('194',0,'17',NULL,'7',0,'238'),('195',0,'17',NULL,'8',0,'239'),('196',0,'17',NULL,'9',0,'240'),('197',0,'17',NULL,'10',0,'241'),('198',0,'18',NULL,'6',0,'242'),('199',0,'18',NULL,'7',0,'243'),('200',0,'18',NULL,'8',0,'244'),('201',0,'18',NULL,'9',0,'245'),('202',0,'18',NULL,'10',0,'246'),('203',0,'19',NULL,'6',0,'247'),('204',0,'19',NULL,'7',0,'248'),('205',0,'19',NULL,'8',0,'249'),('206',0,'19',NULL,'9',0,'250'),('207',0,'19',NULL,'10',0,'251'),('208',0,'20',NULL,'6',0,'252'),('209',0,'20',NULL,'7',0,'253'),('210',0,'20',NULL,'8',0,'254'),('211',0,'20',NULL,'9',0,'255'),('212',0,'20',NULL,'10',0,'256'),('213',0,'21',NULL,'6',0,'257'),('214',0,'21',NULL,'7',0,'258'),('215',0,'21',NULL,'8',0,'259'),('216',0,'21',NULL,'9',0,'260'),('217',0,'21',NULL,'10',0,'261'),('218',0,'22',NULL,'6',0,'262'),('219',0,'22',NULL,'7',0,'263'),('220',0,'22',NULL,'8',0,'264'),('221',0,'22',NULL,'9',0,'265'),('222',0,'22',NULL,'10',0,'266'),('223',0,'23',NULL,'7',0,'267'),('224',0,'23',NULL,'8',0,'268'),('225',0,'23',NULL,'9',0,'269'),('226',0,'23',NULL,'10',0,'270'),('227',0,'23',NULL,'11',0,'271'),('228',0,'24',NULL,'7',0,'272'),('229',0,'24',NULL,'8',0,'273'),('230',0,'24',NULL,'9',0,'274'),('231',0,'24',NULL,'10',0,'275'),('232',0,'24',NULL,'11',0,'276'),('233',0,'25',NULL,'7',0,'277'),('234',0,'25',NULL,'8',0,'278'),('235',0,'25',NULL,'9',0,'279'),('236',0,'25',NULL,'10',0,'280'),('237',0,'25',NULL,'11',0,'281'),('238',0,'26',NULL,'6',0,'282'),('239',0,'26',NULL,'7',0,'283'),('240',0,'26',NULL,'8',0,'284'),('241',0,'26',NULL,'9',0,'285'),('242',0,'26',NULL,'10',0,'286'),('243',0,'27',NULL,'6',0,'287'),('244',0,'27',NULL,'7',0,'288'),('245',0,'27',NULL,'8',0,'289'),('246',0,'27',NULL,'9',0,'290'),('247',0,'27',NULL,'10',0,'291'),('248',0,'28',NULL,'7',0,'292'),('249',0,'28',NULL,'8',0,'293'),('250',0,'28',NULL,'9',0,'294'),('251',0,'28',NULL,'10',0,'295'),('252',0,'28',NULL,'11',0,'296'),('253',0,'29',NULL,'7',0,'297'),('254',0,'29',NULL,'8',0,'298'),('255',0,'29',NULL,'9',0,'299'),('256',0,'29',NULL,'10',0,'300'),('257',0,'29',NULL,'11',0,'301'),('258',0,'30',NULL,'7',0,'317'),('259',0,'30',NULL,'8',0,'318'),('260',0,'30',NULL,'9',0,'319'),('261',0,'30',NULL,'10',0,'320'),('262',0,'30',NULL,'11',0,'321'),('268',0,'31',NULL,'6',0,'322'),('269',0,'31',NULL,'7',0,'323'),('270',0,'31',NULL,'8',0,'324'),('271',0,'31',NULL,'9',0,'325'),('272',0,'31',NULL,'10',0,'326'),('273',0,'32',NULL,'6',0,'327'),('274',0,'32',NULL,'7',0,'328'),('275',0,'32',NULL,'8',0,'329'),('276',0,'32',NULL,'9',0,'330'),('277',0,'32',NULL,'10',0,'331'),('278',0,'33',NULL,'7',0,'332'),('279',0,'33',NULL,'8',0,'333'),('280',0,'33',NULL,'9',0,'334'),('281',0,'33',NULL,'10',0,'335'),('282',0,'33',NULL,'11',0,'336'),('283',0,'34',NULL,'6',0,'337'),('284',0,'34',NULL,'7',0,'338'),('285',0,'34',NULL,'8',0,'339'),('286',0,'34',NULL,'9',0,'340'),('287',0,'34',NULL,'10',0,'341'),('293',0,'35',NULL,'6',0,'357'),('294',0,'35',NULL,'7',0,'358'),('295',0,'35',NULL,'8',0,'359'),('296',0,'35',NULL,'9',0,'360'),('297',0,'35',NULL,'10',0,'361'),('298',0,'36',NULL,'6',0,'362'),('299',0,'36',NULL,'7',0,'363'),('300',0,'36',NULL,'8',0,'364'),('301',0,'36',NULL,'9',0,'365'),('302',0,'36',NULL,'10',0,'366'),('303',0,'37',NULL,'6',0,'367'),('304',0,'37',NULL,'7',0,'368'),('305',0,'37',NULL,'8',0,'369'),('306',0,'37',NULL,'9',0,'370'),('307',0,'37',NULL,'10',0,'371'),('308',0,'48',NULL,'7',0,'382'),('309',0,'48',NULL,'8',0,'383'),('310',0,'48',NULL,'9',0,'384'),('311',0,'48',NULL,'10',0,'385'),('312',0,'48',NULL,'11',0,'386'),('313',0,'49',NULL,'6',0,'387'),('314',0,'49',NULL,'7',0,'388'),('315',0,'49',NULL,'8',0,'389'),('316',0,'49',NULL,'9',0,'390'),('317',0,'49',NULL,'10',0,'391'),('318',0,'50',NULL,'7',0,'392'),('319',0,'50',NULL,'8',0,'393'),('320',0,'50',NULL,'9',0,'394'),('321',0,'50',NULL,'10',0,'395'),('322',0,'50',NULL,'11',0,'396'),('323',0,'51',NULL,'1',0,'397'),('324',0,'51',NULL,'2',0,'398'),('325',0,'51',NULL,'3',0,'399'),('326',0,'51',NULL,'4',0,'400'),('327',0,'52',NULL,'1',0,'401'),('328',0,'52',NULL,'2',0,'402'),('329',0,'52',NULL,'3',0,'403'),('330',0,'52',NULL,'4',0,'404'),('331',0,'52',NULL,'5',0,'405'),('332',0,'53',NULL,'1',0,'406'),('333',0,'53',NULL,'2',0,'407'),('334',0,'53',NULL,'3',0,'408'),('335',0,'53',NULL,'4',0,'409'),('336',0,'53',NULL,'5',0,'410'),('337',0,'54',NULL,'1',0,'411'),('338',0,'54',NULL,'2',0,'412'),('339',0,'54',NULL,'3',0,'413'),('340',0,'54',NULL,'4',0,'414'),('341',0,'54',NULL,'5',0,'415'),('342',0,'55',NULL,'1',0,'416'),('343',0,'55',NULL,'2',0,'417'),('344',0,'55',NULL,'3',0,'418'),('345',0,'55',NULL,'4',0,'419'),('346',0,'55',NULL,'5',0,'420'),('347',0,'56',NULL,'1',0,'421'),('348',0,'56',NULL,'2',0,'422'),('349',0,'56',NULL,'3',0,'423'),('350',0,'56',NULL,'4',0,'424'),('351',0,'56',NULL,'5',0,'425'),('352',0,'57',NULL,'1',0,'426'),('353',0,'57',NULL,'2',0,'427'),('354',0,'57',NULL,'3',0,'428'),('355',0,'57',NULL,'4',0,'429'),('356',0,'57',NULL,'5',0,'430'),('357',0,'58',NULL,'1',0,'431'),('358',0,'58',NULL,'2',0,'432'),('359',0,'58',NULL,'3',0,'433'),('360',0,'58',NULL,'4',0,'434'),('361',0,'58',NULL,'5',0,'435'),('362',0,'59',NULL,'1',0,'436'),('363',0,'59',NULL,'2',0,'437'),('364',0,'59',NULL,'3',0,'438'),('365',0,'59',NULL,'4',0,'439'),('366',0,'59',NULL,'5',0,'440'),('367',0,'59',NULL,'6',0,'441'),('368',0,'60',NULL,'1',0,'442'),('369',0,'60',NULL,'2',0,'443'),('370',0,'60',NULL,'3',0,'444'),('371',0,'60',NULL,'4',0,'445'),('372',0,'60',NULL,'5',0,'446'),('373',0,'61',NULL,'1',0,'447'),('374',0,'61',NULL,'2',0,'448'),('375',0,'61',NULL,'3',0,'449'),('376',0,'61',NULL,'4',0,'450'),('377',0,'61',NULL,'5',0,'451'),('378',0,'62',NULL,'1',0,'452'),('379',0,'62',NULL,'2',0,'453'),('380',0,'62',NULL,'3',0,'454'),('381',0,'62',NULL,'4',0,'455'),('382',0,'62',NULL,'5',0,'456'),('383',0,'63',NULL,'1',0,'457'),('384',0,'63',NULL,'2',0,'458'),('385',0,'63',NULL,'3',0,'459'),('386',0,'63',NULL,'4',0,'460'),('387',0,'63',NULL,'5',0,'461'),('388',0,'64',NULL,'1',0,'462'),('389',0,'64',NULL,'2',0,'463'),('390',0,'64',NULL,'3',0,'464'),('391',0,'64',NULL,'4',0,'465'),('392',0,'65',NULL,'1',0,'466'),('393',0,'65',NULL,'2',0,'467'),('394',0,'65',NULL,'3',0,'468'),('395',0,'65',NULL,'4',0,'469'),('396',0,'65',NULL,'5',0,'470'),('397',0,'67',NULL,'1',0,'471'),('398',0,'67',NULL,'2',0,'472'),('399',0,'67',NULL,'3',0,'473'),('400',0,'67',NULL,'4',0,'474'),('401',0,'67',NULL,'5',0,'475'),('402',0,'67',NULL,'6',0,'476'),('403',0,'68',NULL,'1',0,'477'),('404',0,'68',NULL,'2',0,'478'),('405',0,'68',NULL,'3',0,'479'),('406',0,'68',NULL,'4',0,'480'),('407',0,'68',NULL,'5',0,'481'),('408',0,'69',NULL,'1',0,'482'),('409',0,'69',NULL,'2',0,'483'),('410',0,'69',NULL,'3',0,'484'),('411',0,'69',NULL,'4',0,'485'),('412',0,'69',NULL,'5',0,'486'),('413',0,'70',NULL,'1',0,'487'),('414',0,'70',NULL,'2',0,'488'),('415',0,'70',NULL,'3',0,'489'),('416',0,'70',NULL,'4',0,'490'),('417',0,'70',NULL,'5',0,'491'),('418',0,'71',NULL,'1',0,'492'),('419',0,'71',NULL,'2',0,'493'),('420',0,'71',NULL,'3',0,'494'),('421',0,'71',NULL,'4',0,'495'),('422',0,'72',NULL,'1',0,'496'),('423',0,'72',NULL,'2',0,'497'),('424',0,'72',NULL,'3',0,'498'),('425',0,'72',NULL,'4',0,'499'),('426',0,'72',NULL,'5',0,'500'),('427',0,'73',NULL,'1',0,'501'),('428',0,'73',NULL,'2',0,'502'),('429',0,'73',NULL,'3',0,'503'),('430',0,'73',NULL,'4',0,'504'),('431',0,'73',NULL,'5',0,'505'),('432',0,'74',NULL,'1',0,'506'),('433',0,'74',NULL,'2',0,'507'),('434',0,'74',NULL,'3',0,'508'),('435',0,'74',NULL,'4',0,'509'),('436',0,'74',NULL,'5',0,'510'),('437',0,'75',NULL,'1',0,'511'),('438',0,'75',NULL,'2',0,'512'),('439',0,'75',NULL,'3',0,'513'),('440',0,'75',NULL,'4',0,'514'),('441',0,'75',NULL,'5',0,'515'),('442',0,'76',NULL,'1',0,'516'),('443',0,'76',NULL,'2',0,'517'),('444',0,'76',NULL,'3',0,'518'),('445',0,'76',NULL,'4',0,'519'),('446',0,'76',NULL,'5',0,'520'),('447',0,'77',NULL,'1',0,'521'),('448',0,'77',NULL,'2',0,'522'),('449',0,'77',NULL,'3',0,'523'),('450',0,'77',NULL,'4',0,'524'),('451',0,'77',NULL,'5',0,'525');
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_to_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_to_entity`;
CREATE TABLE `catalog_product_entity_media_gallery_value_to_entity` (
  `value_id` int(10) unsigned NOT NULL COMMENT 'Value media Entry ID',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Product entity ID',
  UNIQUE KEY `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_VAL_ID_ENTT_ID` (`value_id`,`entity_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Link Media value to Product entity table';

--
-- Dumping data for table `catalog_product_entity_media_gallery_value_to_entity`
--

LOCK TABLES `catalog_product_entity_media_gallery_value_to_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_to_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery_value_to_entity` VALUES ('168','1'),('169','1'),('170','1'),('171','1'),('172','1'),('173','2'),('174','2'),('175','2'),('176','2'),('177','2'),('178','7'),('179','7'),('180','7'),('181','7'),('182','7'),('183','9'),('184','9'),('185','9'),('186','9'),('187','9'),('188','10'),('189','10'),('190','10'),('191','10'),('192','10'),('193','17'),('194','17'),('195','17'),('196','17'),('197','17'),('198','18'),('199','18'),('200','18'),('201','18'),('202','18'),('203','19'),('204','19'),('205','19'),('206','19'),('207','19'),('208','20'),('209','20'),('210','20'),('211','20'),('212','20'),('213','21'),('214','21'),('215','21'),('216','21'),('217','21'),('218','22'),('219','22'),('220','22'),('221','22'),('222','22'),('223','23'),('224','23'),('225','23'),('226','23'),('227','23'),('228','24'),('229','24'),('230','24'),('231','24'),('232','24'),('233','25'),('234','25'),('235','25'),('236','25'),('237','25'),('238','26'),('239','26'),('240','26'),('241','26'),('242','26'),('243','27'),('244','27'),('245','27'),('246','27'),('247','27'),('248','28'),('249','28'),('250','28'),('251','28'),('252','28'),('253','29'),('254','29'),('255','29'),('256','29'),('257','29'),('258','30'),('259','30'),('260','30'),('261','30'),('262','30'),('268','31'),('269','31'),('270','31'),('271','31'),('272','31'),('273','32'),('274','32'),('275','32'),('276','32'),('277','32'),('278','33'),('279','33'),('280','33'),('281','33'),('282','33'),('283','34'),('284','34'),('285','34'),('286','34'),('287','34'),('293','35'),('294','35'),('295','35'),('296','35'),('297','35'),('298','36'),('299','36'),('300','36'),('301','36'),('302','36'),('303','37'),('304','37'),('305','37'),('306','37'),('307','37'),('308','48'),('309','48'),('310','48'),('311','48'),('312','48'),('313','49'),('314','49'),('315','49'),('316','49'),('317','49'),('318','50'),('319','50'),('320','50'),('321','50'),('322','50'),('323','51'),('324','51'),('325','51'),('326','51'),('327','52'),('328','52'),('329','52'),('330','52'),('331','52'),('332','53'),('333','53'),('334','53'),('335','53'),('336','53'),('337','54'),('338','54'),('339','54'),('340','54'),('341','54'),('342','55'),('343','55'),('344','55'),('345','55'),('346','55'),('347','56'),('348','56'),('349','56'),('350','56'),('351','56'),('352','57'),('353','57'),('354','57'),('355','57'),('356','57'),('357','58'),('358','58'),('359','58'),('360','58'),('361','58'),('362','59'),('363','59'),('364','59'),('365','59'),('366','59'),('367','59'),('368','60'),('369','60'),('370','60'),('371','60'),('372','60'),('373','61'),('374','61'),('375','61'),('376','61'),('377','61'),('378','62'),('379','62'),('380','62'),('381','62'),('382','62'),('383','63'),('384','63'),('385','63'),('386','63'),('387','63'),('388','64'),('389','64'),('390','64'),('391','64'),('392','65'),('393','65'),('394','65'),('395','65'),('396','65'),('397','67'),('398','67'),('399','67'),('400','67'),('401','67'),('402','67'),('403','68'),('404','68'),('405','68'),('406','68'),('407','68'),('408','69'),('409','69'),('410','69'),('411','69'),('412','69'),('413','70'),('414','70'),('415','70'),('416','70'),('417','70'),('418','71'),('419','71'),('420','71'),('421','71'),('422','72'),('423','72'),('424','72'),('425','72'),('426','72'),('427','73'),('428','73'),('429','73'),('430','73'),('431','73'),('432','74'),('433','74'),('434','74'),('435','74'),('436','74'),('437','75'),('438','75'),('439','75'),('440','75'),('441','75'),('442','76'),('443','76'),('444','76'),('445','76'),('446','76'),('447','77'),('448','77'),('449','77'),('450','77'),('451','77');
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_to_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_video`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_video`;
CREATE TABLE `catalog_product_entity_media_gallery_value_video` (
  `value_id` int(10) unsigned NOT NULL COMMENT 'Media Entity ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `provider` varchar(32) DEFAULT NULL COMMENT 'Video provider ID',
  `url` text COMMENT 'Video URL',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `description` text COMMENT 'Page Meta Description',
  `metadata` text COMMENT 'Video meta data',
  UNIQUE KEY `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_VAL_ID_STORE_ID` (`value_id`,`store_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_STORE_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Video Table';

--
-- Table structure for table `catalog_product_entity_text`
--

DROP TABLE IF EXISTS `catalog_product_entity_text`;
CREATE TABLE `catalog_product_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Text Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_text`
--

LOCK TABLES `catalog_product_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_text` VALUES ('1',75,0,'1','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>Adjustable shoulder strap.</li>\r\n<li>Full-length zipper.</li>\r\n<li>L 29\" x W 13\" x H 11\".</li>\r\n</ul>'),('2',76,0,'1','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>'),('3',85,0,'1','Joust Duffle Bag'),('4',75,0,'2','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('5',76,0,'2','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('6',85,0,'2','Chaz Kangeroo Hoodie'),('19',75,0,'7','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('20',76,0,'7','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('21',85,0,'7','Chaz Kangeroo Hoodie'),('25',75,0,'9','<p>Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'.</p>\r\n<ul>\r\n<li>100% soft and durable cotton.</li>\r\n<li>Plastic cinch buckle is easy to use.</li>\r\n<li>Choice of three natural colors made from phthalate and heavy metal free dyes.</li>\r\n</ul>'),('26',76,0,'9','<p>Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'.</p>'),('27',85,0,'9','Set of Sprite Yoga Straps'),('28',75,0,'10','<p>A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:</p>\r\n<ul>\r\n<li>Sprite Statis Ball</li>\r\n<li>Sprite Foam Yoga Brick</li>\r\n<li>Sprite Yoga Strap</li>\r\n<li>Sprite Foam Roller</li>\r\n</ul>'),('29',76,0,'10','<p>A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:</p>'),('30',85,0,'10','Sprite Yoga Companion Kit'),('49',85,0,'17','Beginner\'s Yoga'),('50',75,0,'18','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>\r\n<ul>\r\n<li>Zippered main compartment.</li>\r\n<li>Front zippered pocket.</li>\r\n<li>Side mesh pocket.</li>\r\n<li>Cell phone pocket on strap.</li>\r\n<li>Adjustable shoulder strap and top carry handle.</li>\r\n</ul>'),('51',76,0,'18','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>'),('52',85,0,'18','Strive Shoulder Pack'),('53',75,0,'19','<p>&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;<br />&lt;ul&gt;<br />&lt;li&gt;Top handle.&lt;/li&gt;<br />&lt;li&gt;Grommet holes.&lt;/li&gt;<br />&lt;li&gt;Two-way zippers.&lt;/li&gt;<br />&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;<br />&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;<br />&lt;ul&gt;&lt;/ul&gt;<br />&lt;/ul&gt;</p>'),('54',76,0,'19','<p>The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.</p>'),('55',85,0,'19','Crown Summit Backpack'),('56',75,0,'20','<p>Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.</p>\r\n<ul>\r\n<li>Multiple internal zip pockets.</li>\r\n<li>Made of durable nylon.</li>\r\n</ul>'),('57',76,0,'20','<p>Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.</p>'),('58',85,0,'20','Wayfarer Messenger Bag'),('59',75,0,'21','<p>The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.</p>\r\n<ul>\r\n<li>Leather construction.</li>\r\n<li>Adjustable fabric carry strap.</li>\r\n<li>Dimensions: 18\" x 10\" x 4\".</li>\r\n</ul>'),('60',76,0,'21','<p>The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.</p>'),('61',85,0,'21','Rival Field Messenger'),('62',75,0,'22','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('63',76,0,'22','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('64',85,0,'22','Chaz Kangeroo Hoodie'),('65',75,0,'23','<p>With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.</p>\r\n<ul>\r\n<li>Durable nylon construction.</li>\r\n<li>2 main zippered compartments.</li>\r\n<li>1 exterior zippered pocket.</li>\r\n<li>Mesh side pouches.</li>\r\n<li>Padded, adjustable straps.</li>\r\n<li>Top carry handle.</li>\r\n<li>Dimensions: 18\" x 10\" x 6\".</li>\r\n</ul>'),('66',76,0,'23','<p>With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.</p>'),('67',85,0,'23','Fusion Backpack'),('68',75,0,'24','<p>Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.</p>\r\n<ul>\r\n<li>Wheeled.</li>\r\n<li>Dual carry handles.</li>\r\n<li>Retractable top handle.</li>\r\n<li>W 14\" x H 26\" x D 11\".</li>\r\n</ul>'),('69',76,0,'24','<p>Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.</p>'),('70',85,0,'24','Impulse Duffle'),('71',75,0,'25','<p>Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.</p>\r\n<ul>\r\n<li>Slip pocket on front.</li>\r\n<li>Contrast piping.</li>\r\n<li>Durable nylon construction.</li>\r\n</ul>'),('72',76,0,'25','<p>Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.</p>'),('73',85,0,'25','Voyage Yoga Bag'),('74',75,0,'26','<p>The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.</p>\r\n<ul>\r\n<li>Two-way zippers.</li>\r\n<li>Contrast detailing.</li>\r\n<li>W 22.0\" x H 17\" x D 10\".</li>\r\n</ul>'),('75',76,0,'26','<p>The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.</p>\r\n<p></p>'),('76',85,0,'26','Compete Track Tote'),('77',75,0,'27','<p>Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.</p>\r\n<ul>\r\n<li>Water-resistant shell.</li>\r\n<li>Water bottle pocket.</li>\r\n<li>Padded, articulating shoulder strap.</li>\r\n<li>Dimensions: W 21\" x H 15\" x D 10\".</li>\r\n</ul>'),('78',76,0,'27','<p>Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.</p>'),('79',85,0,'27','Savvy Shoulder Tote'),('80',75,0,'28','<p>With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.</p>\r\n<ul>\r\n<li>Foam-padded adjustable shoulder straps.</li>\r\n<li>900D polyester.</li>\r\n<li>Oversized zippers.</li>\r\n<li>Locker loop.</li>\r\n</ul>'),('81',76,0,'28','<p>With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.</p>'),('82',85,0,'28','Endeavor Daytrip Backpack'),('83',75,0,'29','<p>School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.</p>\r\n<ul>\r\n<li>Large main and small zip compartments.</li>\r\n<li>Adjustable, padded straps.</li>\r\n<li>Interior foam pockets.</li>\r\n<li>Exterior zip compartment.</li>\r\n<li>Left sport bottle pocket.</li>\r\n<li>Survival gear sold separately.</li>\r\n</ul>'),('84',76,0,'29','<p>School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.</p>'),('85',85,0,'29','Driven Backpack'),('86',75,0,'30','<p>This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.</p>\r\n<p>&bull; Black pullover hoodie.<br />&bull; Soft, brushed interior. <br />&bull; Front hand pockets. <br />&bull; Machine wash/dry.</p>'),('87',76,0,'30','<p>This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.</p>'),('88',85,0,'30','Teton Pullover Hoodie'),('89',75,0,'31','<p>This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.</p>\r\n<p>&bull; Black pullover hoodie.<br />&bull; Soft, brushed interior. <br />&bull; Front hand pockets. <br />&bull; Machine wash/dry.</p>'),('90',76,0,'31','<p>This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.</p>'),('91',85,0,'31','Teton Pullover Hoodie'),('92',75,0,'32','<p>This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.</p>\r\n<p>&bull; Black pullover hoodie.<br />&bull; Soft, brushed interior. <br />&bull; Front hand pockets. <br />&bull; Machine wash/dry.</p>'),('93',76,0,'32','<p>This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.</p>'),('94',85,0,'32','Teton Pullover Hoodie'),('95',75,0,'33','<p>For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>W 15\" x H 15\" x D 9\".</li>\r\n</ul>'),('96',76,0,'33','<p>For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.</p>'),('97',85,0,'33','Overnight Duffle'),('98',75,0,'34','<p>The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.</p>\r\n<ul>\r\n<li>Adjustable crossbody strap.</li>\r\n<li>Top handle.</li>\r\n<li>Zippered interior pocket.</li>\r\n<li>Secure clip closures.</li>\r\n<li>Durable fabric construction.</li>\r\n</ul>'),('99',76,0,'34','<p>The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.</p>'),('100',85,0,'34','Push It Messenger Bag'),('101',75,0,'35','<p>You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.</p>\r\n<ul>\r\n<li>Made of plastic.</li>\r\n<li>Grooved sides for an easy grip.</li>\r\n</ul>'),('102',76,0,'35','<p>You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.</p>'),('103',85,0,'35','Affirm Water Bottle '),('104',75,0,'36','<p>Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.</p>\r\n<ul>\r\n<li>Durable plastic shell with sand fill.</li>\r\n<li>Two handles.</li>\r\n<li>15 lbs.</li>\r\n</ul>'),('105',76,0,'36','<p>Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.</p>'),('106',85,0,'36','Dual Handle Cardio Ball'),('107',75,0,'17','<p>Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.</p>\r\n<ul>\r\n<li>Video download</li>\r\n<li>Five workouts.</li>\r\n<li>Balance, strength and endurance.</li>\r\n<li>Flexibility and core strength.</li>\r\n<li>Includes modification for novices.</li>\r\n</ul>'),('108',76,0,'17','<p>Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.</p>'),('109',75,0,'37','<p>One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.</p>\r\n<ul>\r\n<li>Contoured foam handles.</li>\r\n<li>Adjustable length.</li>\r\n</ul>'),('110',76,0,'37','<p>One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.</p>'),('111',85,0,'37','Zing Jump Rope'),('142',75,0,'48','<p>Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.</p>\r\n<p>&bull; Full zip black hoodie pullover. <br />&bull; Adjustable drawstring hood. <br />&bull; Ribbed cuffs/waistband. <br />&bull; Kangaroo pocket. <br />&bull; Machine wash/dry.</p>'),('143',76,0,'48','<p>Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.</p>'),('144',85,0,'48','Bruno Compete Hoodie'),('145',75,0,'49','<p>Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.</p>\r\n<p>&bull; Full zip black hoodie pullover. <br />&bull; Adjustable drawstring hood. <br />&bull; Ribbed cuffs/waistband. <br />&bull; Kangaroo pocket. <br />&bull; Machine wash/dry.</p>'),('146',76,0,'49','<p>Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.</p>'),('147',85,0,'49','Bruno Compete Hoodie'),('148',75,0,'50','<p>Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.</p>\r\n<p>&bull; Full zip black hoodie pullover. <br />&bull; Adjustable drawstring hood. <br />&bull; Ribbed cuffs/waistband. <br />&bull; Kangaroo pocket. <br />&bull; Machine wash/dry.</p>'),('149',76,0,'50','<p>Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.</p>'),('150',85,0,'50','Bruno Compete Hoodie'),('151',75,0,'51','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>Adjustable shoulder strap.</li>\r\n<li>Full-length zipper.</li>\r\n<li>L 29\" x W 13\" x H 11\".</li>\r\n</ul>'),('152',76,0,'51','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>'),('153',85,0,'51',' Diam Special '),('154',75,0,'52','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('155',76,0,'52','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('156',85,0,'52',' New Diam '),('157',75,0,'53','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('158',76,0,'53','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('159',85,0,'53','Diam Top'),('160',75,0,'54','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>\r\n<ul>\r\n<li>Zippered main compartment.</li>\r\n<li>Front zippered pocket.</li>\r\n<li>Side mesh pocket.</li>\r\n<li>Cell phone pocket on strap.</li>\r\n<li>Adjustable shoulder strap and top carry handle.</li>\r\n</ul>'),('161',76,0,'54','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>'),('162',85,0,'54','Donec Shoes'),('163',75,0,'55','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('164',76,0,'55','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('165',85,0,'55',' Summer Frame '),('166',75,0,'56','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>'),('167',76,0,'56','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>'),('168',85,0,'56','Adidas Concepts Black'),('169',75,0,'57','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>\r\n<ul>\r\n<li>Zippered main compartment.</li>\r\n<li>Front zippered pocket.</li>\r\n<li>Side mesh pocket.</li>\r\n<li>Cell phone pocket on strap.</li>\r\n<li>Adjustable shoulder strap and top carry handle.</li>\r\n</ul>'),('170',76,0,'57','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>'),('171',85,0,'57','Seeulater PK White1'),('172',75,0,'58','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('173',76,0,'58','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('174',85,0,'58','Wings Horns Beige'),('175',75,0,'59','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('176',76,0,'59','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('177',85,0,'59','Reigning Champ Grey'),('178',75,0,'60','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>\r\n<ul>\r\n<li>Zippered main compartment.</li>\r\n<li>Front zippered pocket.</li>\r\n<li>Side mesh pocket.</li>\r\n<li>Cell phone pocket on strap.</li>\r\n<li>Adjustable shoulder strap and top carry handle.</li>\r\n</ul>'),('179',76,0,'60','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>'),('180',85,0,'60','Nike Air  Deluxe White'),('181',75,0,'61','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>'),('182',76,0,'61','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('183',85,0,'61','Lavadome Ultra Light'),('184',75,0,'62','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>\r\n<ul>\r\n<li>Zippered main compartment.</li>\r\n<li>Front zippered pocket.</li>\r\n<li>Side mesh pocket.</li>\r\n<li>Cell phone pocket on strap.</li>\r\n<li>Adjustable shoulder strap and top carry handle.</li>\r\n</ul>'),('185',76,0,'62','<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>'),('186',85,0,'62','seeulater PK White2'),('187',75,0,'63','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('188',76,0,'63','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('189',85,0,'63','CTX 4pc Starter Set'),('190',75,0,'64','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>Adjustable shoulder strap.</li>\r\n<li>Full-length zipper.</li>\r\n<li>L 29\" x W 13\" x H 11\".</li>\r\n</ul>'),('191',76,0,'64','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>'),('192',85,0,'64','Chasseur Escoffier'),('193',75,0,'65','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('194',76,0,'65','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('195',85,0,'65','5pc Knife Block Set'),('199',75,0,'67','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>Adjustable shoulder strap.</li>\r\n<li>Full-length zipper.</li>\r\n<li>L 29\" x W 13\" x H 11\".</li>\r\n</ul>'),('200',76,0,'67','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>'),('201',85,0,'67','5pc Knife Block Set1'),('202',75,0,'68','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('203',76,0,'68','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('204',85,0,'68','3pc Knife Block Set'),('205',75,0,'69','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('206',76,0,'69','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('207',85,0,'69','Serroni Unbreakable'),('208',75,0,'70','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('209',76,0,'70','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('210',85,0,'70','Infusion Pitcher'),('211',75,0,'71','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>Adjustable shoulder strap.</li>\r\n<li>Full-length zipper.</li>\r\n<li>L 29\" x W 13\" x H 11\".</li>\r\n</ul>'),('212',76,0,'71','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>'),('213',85,0,'71','Totally Bamboo'),('214',75,0,'72','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('215',76,0,'72','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('216',85,0,'72','Scanpan Spectrum'),('217',75,0,'73','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>Adjustable shoulder strap.</li>\r\n<li>Full-length zipper.</li>\r\n<li>L 29\" x W 13\" x H 11\".</li>\r\n</ul>'),('218',76,0,'73','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>'),('219',85,0,'73','Chasseur La Cuisson'),('220',75,0,'74','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('221',76,0,'74','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('222',85,0,'74','KitchenAid Pro'),('223',75,0,'75','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('224',76,0,'75','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('225',85,0,'75','Scanpan CTX Coveredr'),('226',75,0,'76','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>Adjustable shoulder strap.</li>\r\n<li>Full-length zipper.</li>\r\n<li>L 29\" x W 13\" x H 11\".</li>\r\n</ul>'),('227',76,0,'76','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>'),('228',85,0,'76','Raco Contemporaryde'),('229',75,0,'77','<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.</p>\r\n<ul>\r\n<li>Dual top handles.</li>\r\n<li>Adjustable shoulder strap.</li>\r\n<li>Full-length zipper.</li>\r\n<li>L 29\" x W 13\" x H 11\".</li>\r\n</ul>'),('230',76,0,'77','<p>Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.</p>\r\n<p>&bull; Two-tone gray heather hoodie.<br />&bull; Drawstring-adjustable hood. <br />&bull; Machine wash/dry.</p>'),('231',85,0,'77','Emile Henry Braiserr');
/*!40000 ALTER TABLE `catalog_product_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_entity_tier_price`;
CREATE TABLE `catalog_product_entity_tier_price` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `all_groups` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Applicable To All Customer Groups',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '1.0000' COMMENT 'QTY',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Value',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_E8AB433B9ACB00343ABB312AD2FAB087` (`entity_id`,`all_groups`,`customer_group_id`,`qty`,`website_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TIER_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TIER_PRICE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Tier Price Attribute Backend Table';

--
-- Table structure for table `catalog_product_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_product_entity_varchar`;
CREATE TABLE `catalog_product_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=925 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Varchar Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_varchar`
--

LOCK TABLES `catalog_product_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_varchar` VALUES ('1',73,0,'1','Joust Duffle Bag'),('2',84,0,'1','Joust Duffle Bag'),('3',86,0,'1','Joust Duffle Bag The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to g'),('4',106,0,'1','container2'),('5',119,0,'1','joust-duffle-bag'),('6',134,0,'1','2'),('7',73,0,'2','Chaz Kangeroo Hoodie'),('8',84,0,'2','Chaz Kangeroo Hoodie'),('9',86,0,'2','Chaz Kangeroo Hoodie Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawst'),('10',106,0,'2','container2'),('11',119,0,'2','chaz-kangeroo-hoodie'),('12',134,0,'2','2'),('37',73,0,'7','MH01-Black'),('38',84,0,'7','Chaz Kangeroo Hoodie'),('39',86,0,'7','Chaz Kangeroo Hoodie Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawst'),('40',106,0,'7','container2'),('41',119,0,'7','mh01-black'),('42',134,0,'7','2'),('49',73,0,'9','Set of Sprite Yoga Straps'),('50',84,0,'9','Set of Sprite Yoga Straps'),('51',86,0,'9','Set of Sprite Yoga Straps Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'.\r\n\r\n100% soft and durable cotton.\r\nPlastic cinch buckle is easy to use.\r\nChoice of three natural colors made '),('52',106,0,'9','container2'),('53',119,0,'9','set-of-sprite-yoga-straps'),('54',134,0,'9','2'),('55',73,0,'10','Sprite Yoga Companion Kit'),('56',84,0,'10','Sprite Yoga Companion Kit'),('57',86,0,'10','Sprite Yoga Companion Kit <p>A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in on'),('58',106,0,'10','container2'),('59',119,0,'10','sprite-yoga-companion-kit'),('60',134,0,'10','2'),('97',73,0,'17','Beginner\'s Yoga'),('98',84,0,'17','Beginner\'s Yoga'),('99',86,0,'17','Beginner\'s Yoga '),('100',106,0,'17','container2'),('101',119,0,'17','beginner-s-yoga'),('102',129,0,'17','Trailers'),('103',130,0,'17','Links'),('104',134,0,'17','2'),('105',73,0,'18','Strive Shoulder Pack'),('106',84,0,'18','Strive Shoulder Pack'),('107',86,0,'18','Strive Shoulder Pack Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.\r\n'),('108',106,0,'18','container2'),('109',119,0,'18','strive-shoulder-pack'),('110',134,0,'18','2'),('111',73,0,'19','Crown Summit Backpack'),('112',84,0,'19','Crown Summit Backpack'),('113',86,0,'19','Crown Summit Backpack <p>The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for da'),('114',106,0,'19','container2'),('115',119,0,'19','crown-summit-backpack'),('116',134,0,'19','2'),('117',73,0,'20','Wayfarer Messenger Bag'),('118',84,0,'20','Wayfarer Messenger Bag'),('119',86,0,'20','Wayfarer Messenger Bag Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. '),('120',106,0,'20','container2'),('121',119,0,'20','wayfarer-messenger-bag'),('122',134,0,'20','2'),('123',73,0,'21','Rival Field Messenger'),('124',84,0,'21','Rival Field Messenger'),('125',86,0,'21','Rival Field Messenger The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy in'),('126',106,0,'21','container2'),('127',119,0,'21','rival-field-messenger'),('128',134,0,'21','2'),('129',87,0,'1','/1/_/1.jpg'),('130',88,0,'1','/1/_/1.jpg'),('131',89,0,'1','/1/_/1.jpg'),('132',132,0,'1','/1/_/1.jpg'),('133',73,0,'22','MH01-Gray'),('134',84,0,'22','Chaz Kangeroo Hoodie'),('135',86,0,'22','Chaz Kangeroo Hoodie Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawst'),('136',106,0,'22','container2'),('137',119,0,'22','mh01-gray'),('138',134,0,'22','2'),('139',87,0,'2','/2/_/2_10.jpg'),('140',88,0,'2','/2/_/2_10.jpg'),('141',89,0,'2','/2/_/2_10.jpg'),('145',87,0,'7','/3/_/3_12.jpg'),('146',88,0,'7','/3/_/3_12.jpg'),('147',89,0,'7','/3/_/3_12.jpg'),('148',132,0,'7','/3/_/3_12.jpg'),('153',87,0,'22','/1/2/12_10.jpg'),('154',88,0,'22','/1/2/12_10.jpg'),('155',89,0,'22','/1/2/12_10.jpg'),('156',132,0,'22','/1/2/12_10.jpg'),('161',73,0,'23','Fusion Backpack'),('162',84,0,'23','Fusion Backpack'),('163',86,0,'23','Fusion Backpack With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect fo'),('164',106,0,'23','container2'),('165',119,0,'23','fusion-backpack'),('166',134,0,'23','2'),('167',73,0,'24','Impulse Duffle'),('168',84,0,'24','Impulse Duffle'),('169',86,0,'24','Impulse Duffle Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other s'),('170',106,0,'24','container2'),('171',119,0,'24','impulse-duffle'),('172',134,0,'24','2'),('173',73,0,'25','Voyage Yoga Bag'),('174',84,0,'25','Voyage Yoga Bag'),('175',86,0,'25','Voyage Yoga Bag Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for se'),('176',106,0,'25','container2'),('177',119,0,'25','voyage-yoga-bag'),('178',134,0,'25','2'),('179',73,0,'26','Compete Track Tote'),('180',84,0,'26','Compete Track Tote'),('181',86,0,'26','Compete Track Tote The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for '),('182',106,0,'26','container2'),('183',119,0,'26','compete-track-tote'),('184',134,0,'26','2'),('185',73,0,'27','Savvy Shoulder Tote'),('186',84,0,'27','Savvy Shoulder Tote'),('187',86,0,'27','Savvy Shoulder Tote Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on '),('188',106,0,'27','container2'),('189',119,0,'27','savvy-shoulder-tote'),('190',134,0,'27','2'),('191',73,0,'28','Endeavor Daytrip Backpack'),('192',84,0,'28','Endeavor Daytrip Backpack'),('193',86,0,'28','Endeavor Daytrip Backpack With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra s'),('194',106,0,'28','container2'),('195',119,0,'28','endeavor-daytrip-backpack'),('196',134,0,'28','2'),('197',73,0,'29','Driven Backpack'),('198',84,0,'29','Driven Backpack'),('199',86,0,'29','Driven Backpack School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main '),('200',106,0,'29','container2'),('201',119,0,'29','driven-backpack'),('202',134,0,'29','2'),('203',73,0,'30','MH02-Black'),('204',84,0,'30','Teton Pullover Hoodie'),('205',86,0,'30','Teton Pullover Hoodie This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.\r\n• Black p'),('206',106,0,'30','container2'),('207',119,0,'30','mh02-black'),('208',134,0,'30','0'),('209',73,0,'31','MH02-Gray'),('210',84,0,'31','Teton Pullover Hoodie'),('211',86,0,'31','Teton Pullover Hoodie This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.\r\n• Black p'),('212',106,0,'31','container2'),('213',119,0,'31','mh02-gray'),('214',134,0,'31','0'),('215',73,0,'32','Teton Pullover Hoodie'),('216',84,0,'32','Teton Pullover Hoodie'),('217',86,0,'32','Teton Pullover Hoodie This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.\r\n• Black p'),('218',106,0,'32','container2'),('219',119,0,'32','teton-pullover-hoodie'),('220',134,0,'32','2'),('221',73,0,'33','Overnight Duffle'),('222',84,0,'33','Overnight Duffle'),('223',86,0,'33','Overnight Duffle For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organiz'),('224',106,0,'33','container2'),('225',119,0,'33','overnight-duffle'),('226',134,0,'33','2'),('227',73,0,'34','Push It Messenger Bag'),('228',84,0,'34','Push It Messenger Bag'),('229',86,0,'34','Push It Messenger Bag The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop,'),('230',106,0,'34','container2'),('231',119,0,'34','push-it-messenger-bag'),('232',134,0,'34','2'),('233',73,0,'35','Affirm Water Bottle '),('234',84,0,'35','Affirm Water Bottle '),('235',86,0,'35','Affirm Water Bottle  You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows y'),('236',106,0,'35','container2'),('237',119,0,'35','affirm-water-bottle'),('238',134,0,'35','2'),('239',73,0,'36','Dual Handle Cardio Ball'),('240',84,0,'36','Dual Handle Cardio Ball'),('241',86,0,'36','Dual Handle Cardio Ball Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure gri'),('242',106,0,'36','container2'),('243',119,0,'36','dual-handle-cardio-ball'),('244',134,0,'36','2'),('249',73,0,'37','Zing Jump Rope'),('250',84,0,'37','Zing Jump Rope'),('251',86,0,'37','Zing Jump Rope One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles '),('252',106,0,'37','container2'),('253',119,0,'37','zing-jump-rope'),('254',134,0,'37','2'),('315',73,0,'48','MH03-Black'),('316',84,0,'48','Bruno Compete Hoodie'),('317',86,0,'48','Bruno Compete Hoodie Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.\r\n• Fu'),('318',106,0,'48','container2'),('319',119,0,'48','mh03-black'),('320',134,0,'48','0'),('321',73,0,'49','MH03-Gray'),('322',84,0,'49','Bruno Compete Hoodie'),('323',86,0,'49','Bruno Compete Hoodie Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.\r\n• Fu'),('324',106,0,'49','container2'),('325',119,0,'49','mh03-gray'),('326',134,0,'49','0'),('327',73,0,'50','Bruno Compete Hoodie'),('328',84,0,'50','Bruno Compete Hoodie'),('329',86,0,'50','Bruno Compete Hoodie Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.\r\n• Fu'),('330',106,0,'50','container2'),('331',119,0,'50','bruno-compete-hoodie'),('332',134,0,'50','2'),('333',87,0,'21','/1/1/11_11.jpg'),('334',88,0,'21','/1/1/11_11.jpg'),('335',89,0,'21','/1/1/11_11.jpg'),('336',132,0,'21','/1/1/11_11.jpg'),('356',87,0,'9','/4/_/4_14.jpg'),('357',88,0,'9','/4/_/4_14.jpg'),('358',89,0,'9','/4/_/4_14.jpg'),('362',87,0,'10','/5/_/5_18.jpg'),('363',88,0,'10','/5/_/5_18.jpg'),('364',89,0,'10','/5/_/5_18.jpg'),('368',87,0,'17','/6/_/6_16.jpg'),('369',88,0,'17','/6/_/6_16.jpg'),('370',89,0,'17','/6/_/6_16.jpg'),('374',87,0,'18','/7/_/7_9.jpg'),('375',88,0,'18','/7/_/7_9.jpg'),('376',89,0,'18','/7/_/7_9.jpg'),('377',132,0,'18','/7/_/7_9.jpg'),('382',87,0,'19','/9/_/9_9.jpg'),('383',88,0,'19','/9/_/9_9.jpg'),('384',89,0,'19','/9/_/9_9.jpg'),('385',132,0,'19','/9/_/9_9.jpg'),('390',87,0,'20','/1/0/10_10.jpg'),('391',88,0,'20','/1/0/10_10.jpg'),('392',89,0,'20','/1/0/10_10.jpg'),('393',132,0,'20','/1/0/10_10.jpg'),('406',87,0,'23','/1/3/13_13.jpg'),('407',88,0,'23','/1/3/13_13.jpg'),('408',89,0,'23','/1/3/13_13.jpg'),('409',132,0,'23','/1/3/13_13.jpg'),('414',87,0,'24','/1/1/11_2.jpg'),('415',88,0,'24','/1/1/11_2.jpg'),('416',89,0,'24','/1/1/11_2.jpg'),('417',132,0,'24','/1/1/11_2.jpg'),('422',87,0,'25','/1/4/14_13.jpg'),('423',88,0,'25','/1/4/14_13.jpg'),('424',89,0,'25','/1/4/14_13.jpg'),('425',132,0,'25','/1/4/14_13.jpg'),('430',87,0,'26','/1/5/15_16.jpg'),('431',88,0,'26','/1/5/15_16.jpg'),('432',89,0,'26','/1/5/15_16.jpg'),('433',132,0,'26','/1/5/15_16.jpg'),('438',87,0,'27','/2/_/2_11.jpg'),('439',88,0,'27','/2/_/2_11.jpg'),('440',89,0,'27','/2/_/2_11.jpg'),('441',132,0,'27','/2/_/2_11.jpg'),('446',87,0,'28','/7/_/7.jpg'),('447',88,0,'28','/7/_/7.jpg'),('448',89,0,'28','/7/_/7.jpg'),('449',132,0,'28','/7/_/7.jpg'),('454',87,0,'29','/1/_/1_9.jpg'),('455',88,0,'29','/1/_/1_9.jpg'),('456',89,0,'29','/1/_/1_9.jpg'),('457',132,0,'29','/1/_/1_9.jpg'),('462',87,0,'30','/2/_/2_13.jpg'),('463',88,0,'30','/2/_/2_13.jpg'),('464',89,0,'30','/2/_/2_13.jpg'),('465',132,0,'30','/2/_/2_13.jpg'),('470',87,0,'31','/5/_/5_22.jpg'),('471',88,0,'31','/5/_/5_22.jpg'),('472',89,0,'31','/5/_/5_22.jpg'),('473',132,0,'31','/5/_/5_22.jpg'),('486',87,0,'32','/6/_/6_17.jpg'),('487',88,0,'32','/6/_/6_17.jpg'),('488',89,0,'32','/6/_/6_17.jpg'),('492',87,0,'33','/7/_/7_10.jpg'),('493',88,0,'33','/7/_/7_10.jpg'),('494',89,0,'33','/7/_/7_10.jpg'),('495',132,0,'33','/7/_/7_10.jpg'),('500',87,0,'34','/8/_/8_2.jpg'),('501',88,0,'34','/8/_/8_2.jpg'),('502',89,0,'34','/8/_/8_2.jpg'),('503',132,0,'34','/8/_/8_2.jpg'),('508',87,0,'35','/9/_/9_2.jpg'),('509',88,0,'35','/9/_/9_2.jpg'),('510',89,0,'35','/9/_/9_2.jpg'),('511',132,0,'35','/9/_/9_2.jpg'),('516',87,0,'36','/1/5/15_11.jpg'),('517',88,0,'36','/1/5/15_11.jpg'),('518',89,0,'36','/1/5/15_11.jpg'),('519',132,0,'36','/1/5/15_11.jpg'),('524',87,0,'37','/3/_/3_16.jpg'),('525',88,0,'37','/3/_/3_16.jpg'),('526',89,0,'37','/3/_/3_16.jpg'),('527',132,0,'37','/3/_/3_16.jpg'),('532',87,0,'48','/1/3/13_10.jpg'),('533',88,0,'48','/1/3/13_10.jpg'),('534',89,0,'48','/1/3/13_10.jpg'),('535',132,0,'48','/1/3/13_10.jpg'),('540',87,0,'49','/1/1/11_5.jpg'),('541',88,0,'49','/1/1/11_5.jpg'),('542',89,0,'49','/1/1/11_5.jpg'),('543',132,0,'49','/1/1/11_5.jpg'),('556',87,0,'50','/6/_/6_18.jpg'),('557',88,0,'50','/6/_/6_18.jpg'),('558',89,0,'50','/6/_/6_18.jpg'),('559',73,0,'51',' Diam Special '),('560',84,0,'51',' Diam Special '),('561',86,0,'51',' Diam Special  The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('562',87,0,'51','/1/_/1_11.jpg'),('563',88,0,'51','/1/_/1_11.jpg'),('564',89,0,'51','/1/_/1_11.jpg'),('565',106,0,'51','container2'),('566',119,0,'51','diam-special'),('567',132,0,'51','/1/_/1_11.jpg'),('568',134,0,'51','2'),('573',73,0,'52',' New Diam '),('574',84,0,'52',' New Diam '),('575',86,0,'52',' New Diam  Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstring-adjus'),('576',87,0,'52','/3/_/3_17.jpg'),('577',88,0,'52','/3/_/3_17.jpg'),('578',89,0,'52','/3/_/3_17.jpg'),('579',106,0,'52','container2'),('580',119,0,'52','new-diam'),('581',132,0,'52','/3/_/3_17.jpg'),('582',134,0,'52','2'),('587',73,0,'53','Diam Top'),('588',84,0,'53','Diam Top'),('589',86,0,'53','Diam Top Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstring-adjusta'),('590',87,0,'53','/4/_/4_20.jpg'),('591',88,0,'53','/4/_/4_20.jpg'),('592',89,0,'53','/4/_/4_20.jpg'),('593',106,0,'53','container2'),('594',119,0,'53','diam-top'),('595',132,0,'53','/4/_/4_20.jpg'),('596',134,0,'53','2'),('601',73,0,'54','Donec Shoes'),('602',84,0,'54','Donec Shoes'),('603',86,0,'54','Donec Shoes Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.\r\n\r\nZippere'),('604',87,0,'54','/5/_/5_25.jpg'),('605',88,0,'54','/5/_/5_25.jpg'),('606',89,0,'54','/5/_/5_25.jpg'),('607',106,0,'54','container2'),('608',119,0,'54','donec-shoes'),('609',132,0,'54','/5/_/5_25.jpg'),('610',134,0,'54','2'),('615',73,0,'55',' Summer Frame '),('616',84,0,'55',' Summer Frame '),('617',86,0,'55',' Summer Frame  Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstring-a'),('618',87,0,'55','/6/_/6_22.jpg'),('619',88,0,'55','/6/_/6_22.jpg'),('620',89,0,'55','/6/_/6_22.jpg'),('621',106,0,'55','container2'),('622',119,0,'55','summer-frame'),('623',132,0,'55','/6/_/6_22.jpg'),('624',134,0,'55','2'),('629',73,0,'56','Adidas Concepts Black'),('630',84,0,'56','Adidas Concepts Black'),('631',86,0,'56','Adidas Concepts Black Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('632',87,0,'56','/7/_/7_14.jpg'),('633',88,0,'56','/7/_/7_14.jpg'),('634',89,0,'56','/7/_/7_14.jpg'),('635',106,0,'56','container2'),('636',119,0,'56','adidas-concepts-black'),('637',132,0,'56','/7/_/7_14.jpg'),('638',134,0,'56','2'),('643',73,0,'57','Seeulater PK White1'),('644',84,0,'57','Seeulater PK White1'),('645',86,0,'57','Seeulater PK White1 Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.\r\n\r'),('646',87,0,'57','/8/_/8_9.jpg'),('647',88,0,'57','/8/_/8_9.jpg'),('648',89,0,'57','/8/_/8_9.jpg'),('649',106,0,'57','container2'),('650',119,0,'57','seeulater-pk-white1'),('651',132,0,'57','/8/_/8_9.jpg'),('652',134,0,'57','2'),('657',73,0,'58','Wings Horns Beige'),('658',84,0,'58','Wings Horns Beige'),('659',86,0,'58','Wings Horns Beige Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstrin'),('660',87,0,'58','/9/_/9_12.jpg'),('661',88,0,'58','/9/_/9_12.jpg'),('662',89,0,'58','/9/_/9_12.jpg'),('663',106,0,'58','container2'),('664',119,0,'58','wings-horns-beige'),('665',132,0,'58','/9/_/9_12.jpg'),('666',134,0,'58','2'),('671',73,0,'59','Reigning Champ Grey'),('672',84,0,'59','Reigning Champ Grey'),('673',86,0,'59','Reigning Champ Grey Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstr'),('674',87,0,'59','/1/0/10_15.jpg'),('675',88,0,'59','/1/0/10_15.jpg'),('676',89,0,'59','/1/0/10_15.jpg'),('677',106,0,'59','container2'),('678',119,0,'59','reigning-champ-grey'),('679',132,0,'59','/1/0/10_15.jpg'),('680',134,0,'59','2'),('685',73,0,'60','Nike Air  Deluxe White'),('686',84,0,'60','Nike Air  Deluxe White'),('687',86,0,'60','Nike Air  Deluxe White Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('688',87,0,'60','/1/1/11_19.jpg'),('689',88,0,'60','/1/1/11_19.jpg'),('690',89,0,'60','/1/1/11_19.jpg'),('691',106,0,'60','container2'),('692',119,0,'60','nike-air-deluxe-white'),('693',132,0,'60','/1/1/11_19.jpg'),('694',134,0,'60','2'),('699',73,0,'61','Lavadome Ultra Light'),('700',84,0,'61','Lavadome Ultra Light'),('701',86,0,'61','Lavadome Ultra Light Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('702',87,0,'61','/1/4/14_16.jpg'),('703',88,0,'61','/1/4/14_16.jpg'),('704',89,0,'61','/1/4/14_16.jpg'),('705',106,0,'61','container2'),('706',119,0,'61','lavadome-ultra-light'),('707',132,0,'61','/1/4/14_16.jpg'),('708',134,0,'61','2'),('713',73,0,'62','seeulater PK White2'),('714',84,0,'62','seeulater PK White2'),('715',86,0,'62','seeulater PK White2 Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.\r\n\r'),('716',87,0,'62','/1/5/15_18.jpg'),('717',88,0,'62','/1/5/15_18.jpg'),('718',89,0,'62','/1/5/15_18.jpg'),('719',106,0,'62','container2'),('720',119,0,'62','seeulater-pk-white2'),('721',132,0,'62','/1/5/15_18.jpg'),('722',134,0,'62','2'),('723',73,0,'63','CTX 4pc Starter Set'),('724',84,0,'63','CTX 4pc Starter Set'),('725',86,0,'63','CTX 4pc Starter Set Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstr'),('726',87,0,'63','/1/_/1_12.jpg'),('727',88,0,'63','/1/_/1_12.jpg'),('728',89,0,'63','/1/_/1_12.jpg'),('729',106,0,'63','container2'),('730',119,0,'63','ctx-4pc-starter-set'),('731',132,0,'63','/1/_/1_12.jpg'),('732',134,0,'63','2'),('737',73,0,'64','Chasseur Escoffier'),('738',84,0,'64','Chasseur Escoffier'),('739',86,0,'64','Chasseur Escoffier The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to'),('740',87,0,'64','/2/_/2_16.jpg'),('741',88,0,'64','/2/_/2_16.jpg'),('742',89,0,'64','/2/_/2_16.jpg'),('743',106,0,'64','container2'),('744',119,0,'64','chasseur-escoffier'),('745',132,0,'64','/2/_/2_16.jpg'),('746',134,0,'64','2'),('751',73,0,'65','5pc Knife Block Set'),('752',84,0,'65','5pc Knife Block Set'),('753',86,0,'65','5pc Knife Block Set Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstr'),('754',87,0,'65','/3/_/3_21.jpg'),('755',88,0,'65','/3/_/3_21.jpg'),('756',89,0,'65','/3/_/3_21.jpg'),('757',106,0,'65','container2'),('758',119,0,'65','5pc-knife-block-set'),('759',132,0,'65','/3/_/3_21.jpg'),('760',134,0,'65','2'),('775',73,0,'67','5pc Knife Block Set1'),('776',84,0,'67','5pc Knife Block Set1'),('777',86,0,'67','5pc Knife Block Set1 The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places '),('778',87,0,'67','/4/_/4_25.jpg'),('779',88,0,'67','/4/_/4_25.jpg'),('780',89,0,'67','/4/_/4_25.jpg'),('781',106,0,'67','container2'),('782',119,0,'67','5pc-knife-block-set1'),('783',132,0,'67','/4/_/4_25.jpg'),('784',134,0,'67','2'),('789',73,0,'68','3pc Knife Block Set'),('790',84,0,'68','3pc Knife Block Set'),('791',86,0,'68','3pc Knife Block Set Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstr'),('792',87,0,'68','/5/_/5_30.jpg'),('793',88,0,'68','/5/_/5_30.jpg'),('794',89,0,'68','/5/_/5_30.jpg'),('795',106,0,'68','container2'),('796',119,0,'68','3pc-knife-block-set'),('797',132,0,'68','/5/_/5_30.jpg'),('798',134,0,'68','2'),('803',73,0,'69','Serroni Unbreakable'),('804',84,0,'69','Serroni Unbreakable'),('805',86,0,'69','Serroni Unbreakable Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstr'),('806',87,0,'69','/6/_/6_28.jpg'),('807',88,0,'69','/6/_/6_28.jpg'),('808',89,0,'69','/6/_/6_28.jpg'),('809',106,0,'69','container2'),('810',119,0,'69','serroni-unbreakable'),('811',132,0,'69','/6/_/6_28.jpg'),('812',134,0,'69','2'),('817',73,0,'70','Infusion Pitcher'),('818',84,0,'70','Infusion Pitcher'),('819',86,0,'70','Infusion Pitcher Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstring'),('820',87,0,'70','/7/_/7_19.jpg'),('821',88,0,'70','/7/_/7_19.jpg'),('822',89,0,'70','/7/_/7_19.jpg'),('823',106,0,'70','container2'),('824',119,0,'70','infusion-pitcher'),('825',132,0,'70','/7/_/7_19.jpg'),('826',134,0,'70','2'),('831',73,0,'71','Totally Bamboo'),('832',84,0,'71','Totally Bamboo'),('833',86,0,'71','Totally Bamboo The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('834',87,0,'71','/8/_/8_14.jpg'),('835',88,0,'71','/8/_/8_14.jpg'),('836',89,0,'71','/8/_/8_14.jpg'),('837',106,0,'71','container2'),('838',119,0,'71','totally-bamboo'),('839',132,0,'71','/8/_/8_14.jpg'),('840',134,0,'71','2'),('845',73,0,'72','Scanpan Spectrum'),('846',84,0,'72','Scanpan Spectrum'),('847',86,0,'72','Scanpan Spectrum Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstring'),('848',87,0,'72','/9/_/9_18.jpg'),('849',88,0,'72','/9/_/9_18.jpg'),('850',89,0,'72','/9/_/9_18.jpg'),('851',106,0,'72','container2'),('852',119,0,'72','scanpan-spectrum'),('853',132,0,'72','/9/_/9_18.jpg'),('854',134,0,'72','2'),('859',73,0,'73','Chasseur La Cuisson'),('860',84,0,'73','Chasseur La Cuisson'),('861',86,0,'73','Chasseur La Cuisson The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places t'),('862',87,0,'73','/1/0/10_20.jpg'),('863',88,0,'73','/1/0/10_20.jpg'),('864',89,0,'73','/1/0/10_20.jpg'),('865',106,0,'73','container2'),('866',119,0,'73','chasseur-la-cuisson'),('867',132,0,'73','/1/0/10_20.jpg'),('868',134,0,'73','2'),('873',73,0,'74','KitchenAid Pro'),('874',84,0,'74','KitchenAid Pro'),('875',86,0,'74','KitchenAid Pro Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawstring-a'),('876',87,0,'74','/1/1/11_25.jpg'),('877',88,0,'74','/1/1/11_25.jpg'),('878',89,0,'74','/1/1/11_25.jpg'),('879',106,0,'74','container2'),('880',119,0,'74','kitchenaid-pro'),('881',132,0,'74','/1/1/11_25.jpg'),('882',134,0,'74','2'),('887',73,0,'75','Scanpan CTX Coveredr'),('888',84,0,'75','Scanpan CTX Coveredr'),('889',86,0,'75','Scanpan CTX Coveredr Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat.\r\n• Two-tone gray heather hoodie.• Drawst'),('890',87,0,'75','/1/2/12_24.jpg'),('891',88,0,'75','/1/2/12_24.jpg'),('892',89,0,'75','/1/2/12_24.jpg'),('893',106,0,'75','container2'),('894',119,0,'75','scanpan-ctx-coveredr'),('895',132,0,'75','/1/2/12_24.jpg'),('896',134,0,'75','2'),('901',73,0,'76','Raco Contemporaryde'),('902',84,0,'76','Raco Contemporaryde'),('903',86,0,'76','Raco Contemporaryde The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places t'),('904',87,0,'76','/1/3/13_24.jpg'),('905',88,0,'76','/1/3/13_24.jpg'),('906',89,0,'76','/1/3/13_24.jpg'),('907',106,0,'76','container2'),('908',119,0,'76','raco-contemporaryde'),('909',132,0,'76','/1/3/13_24.jpg'),('910',134,0,'76','2'),('915',73,0,'77','Emile Henry Braiserr'),('916',84,0,'77','Emile Henry Braiserr'),('917',86,0,'77','Emile Henry Braiserr The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places '),('918',87,0,'77','/1/4/14_19.jpg'),('919',88,0,'77','/1/4/14_19.jpg'),('920',89,0,'77','/1/4/14_19.jpg'),('921',106,0,'77','container2'),('922',119,0,'77','emile-henry-braiserr'),('923',132,0,'77','/1/4/14_19.jpg'),('924',134,0,'77','2');
/*!40000 ALTER TABLE `catalog_product_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav`
--

DROP TABLE IF EXISTS `catalog_product_index_eav`;
CREATE TABLE `catalog_product_index_eav` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` int(10) unsigned NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Index Table';

--
-- Dumping data for table `catalog_product_index_eav`
--

LOCK TABLES `catalog_product_index_eav` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav` DISABLE KEYS */;
INSERT INTO `catalog_product_index_eav` VALUES ('1',83,1,'16'),('1',83,2,'16'),('1',83,3,'16'),('1',83,4,'16'),('1',83,5,'16'),('1',83,6,'16'),('1',93,1,'4'),('1',93,2,'4'),('1',93,3,'4'),('1',93,4,'4'),('1',93,5,'4'),('1',93,6,'4'),('2',83,1,'17'),('2',83,1,'22'),('2',83,2,'17'),('2',83,2,'22'),('2',83,3,'17'),('2',83,3,'22'),('2',83,4,'17'),('2',83,4,'22'),('2',83,5,'17'),('2',83,5,'22'),('2',83,6,'17'),('2',83,6,'22'),('2',93,1,'4'),('2',93,1,'7'),('2',93,2,'4'),('2',93,2,'7'),('2',93,3,'4'),('2',93,3,'7'),('2',93,4,'4'),('2',93,4,'7'),('2',93,5,'4'),('2',93,5,'7'),('2',93,6,'4'),('2',93,6,'7'),('7',83,1,'17'),('7',83,2,'17'),('7',83,3,'17'),('7',83,4,'17'),('7',83,5,'17'),('7',83,6,'17'),('7',93,1,'4'),('7',93,2,'4'),('7',93,3,'4'),('7',93,4,'4'),('7',93,5,'4'),('7',93,6,'4'),('9',83,1,'16'),('9',83,1,'17'),('9',83,1,'19'),('9',83,2,'16'),('9',83,2,'17'),('9',83,2,'19'),('9',83,3,'16'),('9',83,3,'17'),('9',83,3,'19'),('9',83,4,'16'),('9',83,4,'17'),('9',83,4,'19'),('9',83,5,'16'),('9',83,5,'17'),('9',83,5,'19'),('9',83,6,'16'),('9',83,6,'17'),('9',83,6,'19'),('9',93,1,'4'),('9',93,1,'7'),('9',93,2,'4'),('9',93,2,'7'),('9',93,3,'4'),('9',93,3,'7'),('9',93,4,'4'),('9',93,4,'7'),('9',93,5,'4'),('9',93,5,'7'),('9',93,6,'4'),('9',93,6,'7'),('10',83,1,'16'),('10',83,1,'17'),('10',83,1,'20'),('10',83,2,'16'),('10',83,2,'17'),('10',83,2,'20'),('10',83,3,'16'),('10',83,3,'17'),('10',83,3,'20'),('10',83,4,'16'),('10',83,4,'17'),('10',83,4,'20'),('10',83,5,'16'),('10',83,5,'17'),('10',83,5,'20'),('10',83,6,'16'),('10',83,6,'17'),('10',83,6,'20'),('10',93,1,'4'),('10',93,1,'9'),('10',93,2,'4'),('10',93,2,'9'),('10',93,3,'4'),('10',93,3,'9'),('10',93,4,'4'),('10',93,4,'9'),('10',93,5,'4'),('10',93,5,'9'),('10',93,6,'4'),('10',93,6,'9'),('17',83,1,'21'),('17',83,2,'21'),('17',83,3,'21'),('17',83,4,'21'),('17',83,5,'21'),('17',83,6,'21'),('17',93,1,'12'),('17',93,2,'12'),('17',93,3,'12'),('17',93,4,'12'),('17',93,5,'12'),('17',93,6,'12'),('18',83,1,'18'),('18',83,2,'18'),('18',83,3,'18'),('18',83,4,'18'),('18',83,5,'18'),('18',83,6,'18'),('18',93,1,'15'),('18',93,2,'15'),('18',93,3,'15'),('18',93,4,'15'),('18',93,5,'15'),('18',93,6,'15'),('19',83,1,'18'),('19',83,2,'18'),('19',83,3,'18'),('19',83,4,'18'),('19',83,5,'18'),('19',83,6,'18'),('19',93,1,'13'),('19',93,2,'13'),('19',93,3,'13'),('19',93,4,'13'),('19',93,5,'13'),('19',93,6,'13'),('20',83,1,'21'),('20',83,2,'21'),('20',83,3,'21'),('20',83,4,'21'),('20',83,5,'21'),('20',83,6,'21'),('20',93,1,'11'),('20',93,2,'11'),('20',93,3,'11'),('20',93,4,'11'),('20',93,5,'11'),('20',93,6,'11'),('21',83,1,'17'),('21',83,2,'17'),('21',83,3,'17'),('21',83,4,'17'),('21',83,5,'17'),('21',83,6,'17'),('21',93,1,'8'),('21',93,2,'8'),('21',93,3,'8'),('21',93,4,'8'),('21',93,5,'8'),('21',93,6,'8'),('22',83,1,'22'),('22',83,2,'22'),('22',83,3,'22'),('22',83,4,'22'),('22',83,5,'22'),('22',83,6,'22'),('22',93,1,'7'),('22',93,2,'7'),('22',93,3,'7'),('22',93,4,'7'),('22',93,5,'7'),('22',93,6,'7'),('23',83,1,'17'),('23',83,2,'17'),('23',83,3,'17'),('23',83,4,'17'),('23',83,5,'17'),('23',83,6,'17'),('23',93,1,'9'),('23',93,2,'9'),('23',93,3,'9'),('23',93,4,'9'),('23',93,5,'9'),('23',93,6,'9'),('24',83,1,'16'),('24',83,2,'16'),('24',83,3,'16'),('24',83,4,'16'),('24',83,5,'16'),('24',83,6,'16'),('24',93,1,'13'),('24',93,2,'13'),('24',93,3,'13'),('24',93,4,'13'),('24',93,5,'13'),('24',93,6,'13'),('25',83,1,'18'),('25',83,2,'18'),('25',83,3,'18'),('25',83,4,'18'),('25',83,5,'18'),('25',83,6,'18'),('25',93,1,'12'),('25',93,2,'12'),('25',93,3,'12'),('25',93,4,'12'),('25',93,5,'12'),('25',93,6,'12'),('26',83,1,'21'),('26',83,2,'21'),('26',83,3,'21'),('26',83,4,'21'),('26',83,5,'21'),('26',83,6,'21'),('26',93,1,'8'),('26',93,2,'8'),('26',93,3,'8'),('26',93,4,'8'),('26',93,5,'8'),('26',93,6,'8'),('27',83,1,'19'),('27',83,2,'19'),('27',83,3,'19'),('27',83,4,'19'),('27',83,5,'19'),('27',83,6,'19'),('27',93,1,'11'),('27',93,2,'11'),('27',93,3,'11'),('27',93,4,'11'),('27',93,5,'11'),('27',93,6,'11'),('28',83,1,'20'),('28',83,2,'20'),('28',83,3,'20'),('28',83,4,'20'),('28',83,5,'20'),('28',83,6,'20'),('28',93,1,'5'),('28',93,2,'5'),('28',93,3,'5'),('28',93,4,'5'),('28',93,5,'5'),('28',93,6,'5'),('29',83,1,'17'),('29',83,2,'17'),('29',83,3,'17'),('29',83,4,'17'),('29',83,5,'17'),('29',83,6,'17'),('29',93,1,'5'),('29',93,2,'5'),('29',93,3,'5'),('29',93,4,'5'),('29',93,5,'5'),('29',93,6,'5'),('30',83,1,'17'),('30',83,2,'17'),('30',83,3,'17'),('30',83,4,'17'),('30',83,5,'17'),('30',83,6,'17'),('30',93,1,'4'),('30',93,2,'4'),('30',93,3,'4'),('30',93,4,'4'),('30',93,5,'4'),('30',93,6,'4'),('31',83,1,'17'),('31',83,2,'17'),('31',83,3,'17'),('31',83,4,'17'),('31',83,5,'17'),('31',83,6,'17'),('31',93,1,'5'),('31',93,2,'5'),('31',93,3,'5'),('31',93,4,'5'),('31',93,5,'5'),('31',93,6,'5'),('32',83,1,'17'),('32',83,2,'17'),('32',83,3,'17'),('32',83,4,'17'),('32',83,5,'17'),('32',83,6,'17'),('32',93,1,'4'),('32',93,1,'5'),('32',93,2,'4'),('32',93,2,'5'),('32',93,3,'4'),('32',93,3,'5'),('32',93,4,'4'),('32',93,4,'5'),('32',93,5,'4'),('32',93,5,'5'),('32',93,6,'4'),('32',93,6,'5'),('33',83,1,'18'),('33',83,2,'18'),('33',83,3,'18'),('33',83,4,'18'),('33',83,5,'18'),('33',83,6,'18'),('33',93,1,'12'),('33',93,2,'12'),('33',93,3,'12'),('33',93,4,'12'),('33',93,5,'12'),('33',93,6,'12'),('34',83,1,'20'),('34',83,2,'20'),('34',83,3,'20'),('34',83,4,'20'),('34',83,5,'20'),('34',83,6,'20'),('34',93,1,'9'),('34',93,2,'9'),('34',93,3,'9'),('34',93,4,'9'),('34',93,5,'9'),('34',93,6,'9'),('35',83,1,'19'),('35',83,2,'19'),('35',83,3,'19'),('35',83,4,'19'),('35',83,5,'19'),('35',83,6,'19'),('35',93,1,'8'),('35',93,2,'8'),('35',93,3,'8'),('35',93,4,'8'),('35',93,5,'8'),('35',93,6,'8'),('36',83,1,'17'),('36',83,2,'17'),('36',83,3,'17'),('36',83,4,'17'),('36',83,5,'17'),('36',83,6,'17'),('36',93,1,'14'),('36',93,2,'14'),('36',93,3,'14'),('36',93,4,'14'),('36',93,5,'14'),('36',93,6,'14'),('37',83,1,'19'),('37',83,2,'19'),('37',83,3,'19'),('37',83,4,'19'),('37',83,5,'19'),('37',83,6,'19'),('37',93,1,'8'),('37',93,2,'8'),('37',93,3,'8'),('37',93,4,'8'),('37',93,5,'8'),('37',93,6,'8'),('48',83,1,'18'),('48',83,2,'18'),('48',83,3,'18'),('48',83,4,'18'),('48',83,5,'18'),('48',83,6,'18'),('48',93,1,'4'),('48',93,2,'4'),('48',93,3,'4'),('48',93,4,'4'),('48',93,5,'4'),('48',93,6,'4'),('49',83,1,'18'),('49',83,2,'18'),('49',83,3,'18'),('49',83,4,'18'),('49',83,5,'18'),('49',83,6,'18'),('49',93,1,'12'),('49',93,2,'12'),('49',93,3,'12'),('49',93,4,'12'),('49',93,5,'12'),('49',93,6,'12'),('50',83,1,'18'),('50',83,2,'18'),('50',83,3,'18'),('50',83,4,'18'),('50',83,5,'18'),('50',83,6,'18'),('50',93,1,'4'),('50',93,1,'12'),('50',93,2,'4'),('50',93,2,'12'),('50',93,3,'4'),('50',93,3,'12'),('50',93,4,'4'),('50',93,4,'12'),('50',93,5,'4'),('50',93,5,'12'),('50',93,6,'4'),('50',93,6,'12'),('51',83,1,'16'),('51',83,2,'16'),('51',83,3,'16'),('51',83,4,'16'),('51',83,5,'16'),('51',83,6,'16'),('51',93,1,'4'),('51',93,2,'4'),('51',93,3,'4'),('51',93,4,'4'),('51',93,5,'4'),('51',93,6,'4'),('52',83,1,'17'),('52',83,2,'17'),('52',83,3,'17'),('52',83,4,'17'),('52',83,5,'17'),('52',83,6,'17'),('52',93,1,'5'),('52',93,2,'5'),('52',93,3,'5'),('52',93,4,'5'),('52',93,5,'5'),('52',93,6,'5'),('53',83,1,'18'),('53',83,2,'18'),('53',83,3,'18'),('53',83,4,'18'),('53',83,5,'18'),('53',83,6,'18'),('53',93,1,'7'),('53',93,2,'7'),('53',93,3,'7'),('53',93,4,'7'),('53',93,5,'7'),('53',93,6,'7'),('54',83,1,'19'),('54',83,2,'19'),('54',83,3,'19'),('54',83,4,'19'),('54',83,5,'19'),('54',83,6,'19'),('54',93,1,'8'),('54',93,2,'8'),('54',93,3,'8'),('54',93,4,'8'),('54',93,5,'8'),('54',93,6,'8'),('55',83,1,'20'),('55',83,2,'20'),('55',83,3,'20'),('55',83,4,'20'),('55',83,5,'20'),('55',83,6,'20'),('55',93,1,'9'),('55',93,2,'9'),('55',93,3,'9'),('55',93,4,'9'),('55',93,5,'9'),('55',93,6,'9'),('56',83,1,'21'),('56',83,2,'21'),('56',83,3,'21'),('56',83,4,'21'),('56',83,5,'21'),('56',83,6,'21'),('56',93,1,'10'),('56',93,2,'10'),('56',93,3,'10'),('56',93,4,'10'),('56',93,5,'10'),('56',93,6,'10'),('57',83,1,'22'),('57',83,2,'22'),('57',83,3,'22'),('57',83,4,'22'),('57',83,5,'22'),('57',83,6,'22'),('57',93,1,'13'),('57',93,2,'13'),('57',93,3,'13'),('57',93,4,'13'),('57',93,5,'13'),('57',93,6,'13'),('58',83,1,'17'),('58',83,2,'17'),('58',83,3,'17'),('58',83,4,'17'),('58',83,5,'17'),('58',83,6,'17'),('58',93,1,'15'),('58',93,2,'15'),('58',93,3,'15'),('58',93,4,'15'),('58',93,5,'15'),('58',93,6,'15'),('59',83,1,'16'),('59',83,2,'16'),('59',83,3,'16'),('59',83,4,'16'),('59',83,5,'16'),('59',83,6,'16'),('59',93,1,'5'),('59',93,2,'5'),('59',93,3,'5'),('59',93,4,'5'),('59',93,5,'5'),('59',93,6,'5'),('60',83,1,'21'),('60',83,2,'21'),('60',83,3,'21'),('60',83,4,'21'),('60',83,5,'21'),('60',83,6,'21'),('60',93,1,'8'),('60',93,2,'8'),('60',93,3,'8'),('60',93,4,'8'),('60',93,5,'8'),('60',93,6,'8'),('61',83,1,'17'),('61',83,2,'17'),('61',83,3,'17'),('61',83,4,'17'),('61',83,5,'17'),('61',83,6,'17'),('61',93,1,'14'),('61',93,2,'14'),('61',93,3,'14'),('61',93,4,'14'),('61',93,5,'14'),('61',93,6,'14'),('62',83,1,'21'),('62',83,2,'21'),('62',83,3,'21'),('62',83,4,'21'),('62',83,5,'21'),('62',83,6,'21'),('62',93,1,'13'),('62',93,2,'13'),('62',93,3,'13'),('62',93,4,'13'),('62',93,5,'13'),('62',93,6,'13'),('63',83,1,'21'),('63',83,2,'21'),('63',83,3,'21'),('63',83,4,'21'),('63',83,5,'21'),('63',83,6,'21'),('63',93,1,'5'),('63',93,2,'5'),('63',93,3,'5'),('63',93,4,'5'),('63',93,5,'5'),('63',93,6,'5'),('64',83,1,'16'),('64',83,2,'16'),('64',83,3,'16'),('64',83,4,'16'),('64',83,5,'16'),('64',83,6,'16'),('64',93,1,'4'),('64',93,2,'4'),('64',93,3,'4'),('64',93,4,'4'),('64',93,5,'4'),('64',93,6,'4'),('65',83,1,'18'),('65',83,2,'18'),('65',83,3,'18'),('65',83,4,'18'),('65',83,5,'18'),('65',83,6,'18'),('65',93,1,'6'),('65',93,2,'6'),('65',93,3,'6'),('65',93,4,'6'),('65',93,5,'6'),('65',93,6,'6'),('67',83,1,'17'),('67',83,2,'17'),('67',83,3,'17'),('67',83,4,'17'),('67',83,5,'17'),('67',83,6,'17'),('67',93,1,'6'),('67',93,2,'6'),('67',93,3,'6'),('67',93,4,'6'),('67',93,5,'6'),('67',93,6,'6'),('68',83,1,'19'),('68',83,2,'19'),('68',83,3,'19'),('68',83,4,'19'),('68',83,5,'19'),('68',83,6,'19'),('68',93,1,'7'),('68',93,2,'7'),('68',93,3,'7'),('68',93,4,'7'),('68',93,5,'7'),('68',93,6,'7'),('69',83,1,'19'),('69',83,2,'19'),('69',83,3,'19'),('69',83,4,'19'),('69',83,5,'19'),('69',83,6,'19'),('69',93,1,'10'),('69',93,2,'10'),('69',93,3,'10'),('69',93,4,'10'),('69',93,5,'10'),('69',93,6,'10'),('70',83,1,'17'),('70',83,2,'17'),('70',83,3,'17'),('70',83,4,'17'),('70',83,5,'17'),('70',83,6,'17'),('70',93,1,'14'),('70',93,2,'14'),('70',93,3,'14'),('70',93,4,'14'),('70',93,5,'14'),('70',93,6,'14'),('71',83,1,'19'),('71',83,2,'19'),('71',83,3,'19'),('71',83,4,'19'),('71',83,5,'19'),('71',83,6,'19'),('71',93,1,'6'),('71',93,2,'6'),('71',93,3,'6'),('71',93,4,'6'),('71',93,5,'6'),('71',93,6,'6'),('72',83,1,'18'),('72',83,2,'18'),('72',83,3,'18'),('72',83,4,'18'),('72',83,5,'18'),('72',83,6,'18'),('72',93,1,'8'),('72',93,2,'8'),('72',93,3,'8'),('72',93,4,'8'),('72',93,5,'8'),('72',93,6,'8'),('73',83,1,'20'),('73',83,2,'20'),('73',83,3,'20'),('73',83,4,'20'),('73',83,5,'20'),('73',83,6,'20'),('73',93,1,'9'),('73',93,2,'9'),('73',93,3,'9'),('73',93,4,'9'),('73',93,5,'9'),('73',93,6,'9'),('74',83,1,'20'),('74',83,2,'20'),('74',83,3,'20'),('74',83,4,'20'),('74',83,5,'20'),('74',83,6,'20'),('74',93,1,'13'),('74',93,2,'13'),('74',93,3,'13'),('74',93,4,'13'),('74',93,5,'13'),('74',93,6,'13'),('75',83,1,'17'),('75',83,2,'17'),('75',83,3,'17'),('75',83,4,'17'),('75',83,5,'17'),('75',83,6,'17'),('75',93,1,'14'),('75',93,2,'14'),('75',93,3,'14'),('75',93,4,'14'),('75',93,5,'14'),('75',93,6,'14'),('76',83,1,'18'),('76',83,2,'18'),('76',83,3,'18'),('76',83,4,'18'),('76',83,5,'18'),('76',83,6,'18'),('76',93,1,'7'),('76',93,2,'7'),('76',93,3,'7'),('76',93,4,'7'),('76',93,5,'7'),('76',93,6,'7'),('77',83,1,'18'),('77',83,2,'18'),('77',83,3,'18'),('77',83,4,'18'),('77',83,5,'18'),('77',83,6,'18'),('77',93,1,'12'),('77',93,2,'12'),('77',93,3,'12'),('77',93,4,'12'),('77',93,5,'12'),('77',93,6,'12');
/*!40000 ALTER TABLE `catalog_product_index_eav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal`;
CREATE TABLE `catalog_product_index_eav_decimal` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Decimal Index Table';

--
-- Table structure for table `catalog_product_index_eav_decimal_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_idx`;
CREATE TABLE `catalog_product_index_eav_decimal_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Decimal Indexer Index Table';

--
-- Table structure for table `catalog_product_index_eav_decimal_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_tmp`;
CREATE TABLE `catalog_product_index_eav_decimal_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_VALUE` (`value`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Decimal Indexer Temp Table';

--
-- Table structure for table `catalog_product_index_eav_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_idx`;
CREATE TABLE `catalog_product_index_eav_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` int(10) unsigned NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Indexer Index Table';

--
-- Dumping data for table `catalog_product_index_eav_idx`
--

LOCK TABLES `catalog_product_index_eav_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_eav_idx` VALUES ('1',83,1,'16'),('1',83,2,'16'),('1',83,3,'16'),('1',83,4,'16'),('1',83,5,'16'),('1',83,6,'16'),('1',93,1,'4'),('1',93,2,'4'),('1',93,3,'4'),('1',93,4,'4'),('1',93,5,'4'),('1',93,6,'4'),('2',83,1,'17'),('2',83,1,'22'),('2',83,2,'17'),('2',83,2,'22'),('2',83,3,'17'),('2',83,3,'22'),('2',83,4,'17'),('2',83,4,'22'),('2',83,5,'17'),('2',83,5,'22'),('2',83,6,'17'),('2',83,6,'22'),('2',93,1,'4'),('2',93,1,'7'),('2',93,2,'4'),('2',93,2,'7'),('2',93,3,'4'),('2',93,3,'7'),('2',93,4,'4'),('2',93,4,'7'),('2',93,5,'4'),('2',93,5,'7'),('2',93,6,'4'),('2',93,6,'7'),('7',83,1,'17'),('7',83,2,'17'),('7',83,3,'17'),('7',83,4,'17'),('7',83,5,'17'),('7',83,6,'17'),('7',93,1,'4'),('7',93,2,'4'),('7',93,3,'4'),('7',93,4,'4'),('7',93,5,'4'),('7',93,6,'4'),('9',83,1,'16'),('9',83,1,'17'),('9',83,1,'19'),('9',83,2,'16'),('9',83,2,'17'),('9',83,2,'19'),('9',83,3,'16'),('9',83,3,'17'),('9',83,3,'19'),('9',83,4,'16'),('9',83,4,'17'),('9',83,4,'19'),('9',83,5,'16'),('9',83,5,'17'),('9',83,5,'19'),('9',83,6,'16'),('9',83,6,'17'),('9',83,6,'19'),('9',93,1,'4'),('9',93,1,'7'),('9',93,2,'4'),('9',93,2,'7'),('9',93,3,'4'),('9',93,3,'7'),('9',93,4,'4'),('9',93,4,'7'),('9',93,5,'4'),('9',93,5,'7'),('9',93,6,'4'),('9',93,6,'7'),('10',83,1,'16'),('10',83,1,'17'),('10',83,1,'20'),('10',83,2,'16'),('10',83,2,'17'),('10',83,2,'20'),('10',83,3,'16'),('10',83,3,'17'),('10',83,3,'20'),('10',83,4,'16'),('10',83,4,'17'),('10',83,4,'20'),('10',83,5,'16'),('10',83,5,'17'),('10',83,5,'20'),('10',83,6,'16'),('10',83,6,'17'),('10',83,6,'20'),('10',93,1,'4'),('10',93,1,'9'),('10',93,2,'4'),('10',93,2,'9'),('10',93,3,'4'),('10',93,3,'9'),('10',93,4,'4'),('10',93,4,'9'),('10',93,5,'4'),('10',93,5,'9'),('10',93,6,'4'),('10',93,6,'9'),('17',83,1,'21'),('17',83,2,'21'),('17',83,3,'21'),('17',83,4,'21'),('17',83,5,'21'),('17',83,6,'21'),('17',93,1,'12'),('17',93,2,'12'),('17',93,3,'12'),('17',93,4,'12'),('17',93,5,'12'),('17',93,6,'12'),('18',83,1,'18'),('18',83,2,'18'),('18',83,3,'18'),('18',83,4,'18'),('18',83,5,'18'),('18',83,6,'18'),('18',93,1,'15'),('18',93,2,'15'),('18',93,3,'15'),('18',93,4,'15'),('18',93,5,'15'),('18',93,6,'15'),('19',83,1,'18'),('19',83,2,'18'),('19',83,3,'18'),('19',83,4,'18'),('19',83,5,'18'),('19',83,6,'18'),('19',93,1,'13'),('19',93,2,'13'),('19',93,3,'13'),('19',93,4,'13'),('19',93,5,'13'),('19',93,6,'13'),('20',83,1,'21'),('20',83,2,'21'),('20',83,3,'21'),('20',83,4,'21'),('20',83,5,'21'),('20',83,6,'21'),('20',93,1,'11'),('20',93,2,'11'),('20',93,3,'11'),('20',93,4,'11'),('20',93,5,'11'),('20',93,6,'11'),('21',83,1,'17'),('21',83,2,'17'),('21',83,3,'17'),('21',83,4,'17'),('21',83,5,'17'),('21',83,6,'17'),('21',93,1,'8'),('21',93,2,'8'),('21',93,3,'8'),('21',93,4,'8'),('21',93,5,'8'),('21',93,6,'8'),('22',83,1,'22'),('22',83,2,'22'),('22',83,3,'22'),('22',83,4,'22'),('22',83,5,'22'),('22',83,6,'22'),('22',93,1,'7'),('22',93,2,'7'),('22',93,3,'7'),('22',93,4,'7'),('22',93,5,'7'),('22',93,6,'7'),('23',83,1,'17'),('23',83,2,'17'),('23',83,3,'17'),('23',83,4,'17'),('23',83,5,'17'),('23',83,6,'17'),('23',93,1,'9'),('23',93,2,'9'),('23',93,3,'9'),('23',93,4,'9'),('23',93,5,'9'),('23',93,6,'9'),('24',83,1,'16'),('24',83,2,'16'),('24',83,3,'16'),('24',83,4,'16'),('24',83,5,'16'),('24',83,6,'16'),('24',93,1,'13'),('24',93,2,'13'),('24',93,3,'13'),('24',93,4,'13'),('24',93,5,'13'),('24',93,6,'13'),('25',83,1,'18'),('25',83,2,'18'),('25',83,3,'18'),('25',83,4,'18'),('25',83,5,'18'),('25',83,6,'18'),('25',93,1,'12'),('25',93,2,'12'),('25',93,3,'12'),('25',93,4,'12'),('25',93,5,'12'),('25',93,6,'12'),('26',83,1,'21'),('26',83,2,'21'),('26',83,3,'21'),('26',83,4,'21'),('26',83,5,'21'),('26',83,6,'21'),('26',93,1,'8'),('26',93,2,'8'),('26',93,3,'8'),('26',93,4,'8'),('26',93,5,'8'),('26',93,6,'8'),('27',83,1,'19'),('27',83,2,'19'),('27',83,3,'19'),('27',83,4,'19'),('27',83,5,'19'),('27',83,6,'19'),('27',93,1,'11'),('27',93,2,'11'),('27',93,3,'11'),('27',93,4,'11'),('27',93,5,'11'),('27',93,6,'11'),('28',83,1,'20'),('28',83,2,'20'),('28',83,3,'20'),('28',83,4,'20'),('28',83,5,'20'),('28',83,6,'20'),('28',93,1,'5'),('28',93,2,'5'),('28',93,3,'5'),('28',93,4,'5'),('28',93,5,'5'),('28',93,6,'5'),('29',83,1,'17'),('29',83,2,'17'),('29',83,3,'17'),('29',83,4,'17'),('29',83,5,'17'),('29',83,6,'17'),('29',93,1,'5'),('29',93,2,'5'),('29',93,3,'5'),('29',93,4,'5'),('29',93,5,'5'),('29',93,6,'5'),('30',83,1,'17'),('30',83,2,'17'),('30',83,3,'17'),('30',83,4,'17'),('30',83,5,'17'),('30',83,6,'17'),('30',93,1,'4'),('30',93,2,'4'),('30',93,3,'4'),('30',93,4,'4'),('30',93,5,'4'),('30',93,6,'4'),('31',83,1,'17'),('31',83,2,'17'),('31',83,3,'17'),('31',83,4,'17'),('31',83,5,'17'),('31',83,6,'17'),('31',93,1,'5'),('31',93,2,'5'),('31',93,3,'5'),('31',93,4,'5'),('31',93,5,'5'),('31',93,6,'5'),('32',83,1,'17'),('32',83,2,'17'),('32',83,3,'17'),('32',83,4,'17'),('32',83,5,'17'),('32',83,6,'17'),('32',93,1,'4'),('32',93,1,'5'),('32',93,2,'4'),('32',93,2,'5'),('32',93,3,'4'),('32',93,3,'5'),('32',93,4,'4'),('32',93,4,'5'),('32',93,5,'4'),('32',93,5,'5'),('32',93,6,'4'),('32',93,6,'5'),('33',83,1,'18'),('33',83,2,'18'),('33',83,3,'18'),('33',83,4,'18'),('33',83,5,'18'),('33',83,6,'18'),('33',93,1,'12'),('33',93,2,'12'),('33',93,3,'12'),('33',93,4,'12'),('33',93,5,'12'),('33',93,6,'12'),('34',83,1,'20'),('34',83,2,'20'),('34',83,3,'20'),('34',83,4,'20'),('34',83,5,'20'),('34',83,6,'20'),('34',93,1,'9'),('34',93,2,'9'),('34',93,3,'9'),('34',93,4,'9'),('34',93,5,'9'),('34',93,6,'9'),('35',83,1,'19'),('35',83,2,'19'),('35',83,3,'19'),('35',83,4,'19'),('35',83,5,'19'),('35',83,6,'19'),('35',93,1,'8'),('35',93,2,'8'),('35',93,3,'8'),('35',93,4,'8'),('35',93,5,'8'),('35',93,6,'8'),('36',83,1,'17'),('36',83,2,'17'),('36',83,3,'17'),('36',83,4,'17'),('36',83,5,'17'),('36',83,6,'17'),('36',93,1,'14'),('36',93,2,'14'),('36',93,3,'14'),('36',93,4,'14'),('36',93,5,'14'),('36',93,6,'14'),('37',83,1,'19'),('37',83,2,'19'),('37',83,3,'19'),('37',83,4,'19'),('37',83,5,'19'),('37',83,6,'19'),('37',93,1,'8'),('37',93,2,'8'),('37',93,3,'8'),('37',93,4,'8'),('37',93,5,'8'),('37',93,6,'8'),('48',83,1,'18'),('48',83,2,'18'),('48',83,3,'18'),('48',83,4,'18'),('48',83,5,'18'),('48',83,6,'18'),('48',93,1,'4'),('48',93,2,'4'),('48',93,3,'4'),('48',93,4,'4'),('48',93,5,'4'),('48',93,6,'4'),('49',83,1,'18'),('49',83,2,'18'),('49',83,3,'18'),('49',83,4,'18'),('49',83,5,'18'),('49',83,6,'18'),('49',93,1,'12'),('49',93,2,'12'),('49',93,3,'12'),('49',93,4,'12'),('49',93,5,'12'),('49',93,6,'12'),('50',83,1,'18'),('50',83,2,'18'),('50',83,3,'18'),('50',83,4,'18'),('50',83,5,'18'),('50',83,6,'18'),('50',93,1,'4'),('50',93,1,'12'),('50',93,2,'4'),('50',93,2,'12'),('50',93,3,'4'),('50',93,3,'12'),('50',93,4,'4'),('50',93,4,'12'),('50',93,5,'4'),('50',93,5,'12'),('50',93,6,'4'),('50',93,6,'12'),('51',83,1,'16'),('51',83,2,'16'),('51',83,3,'16'),('51',83,4,'16'),('51',83,5,'16'),('51',83,6,'16'),('51',93,1,'4'),('51',93,2,'4'),('51',93,3,'4'),('51',93,4,'4'),('51',93,5,'4'),('51',93,6,'4'),('52',83,1,'17'),('52',83,2,'17'),('52',83,3,'17'),('52',83,4,'17'),('52',83,5,'17'),('52',83,6,'17'),('52',93,1,'5'),('52',93,2,'5'),('52',93,3,'5'),('52',93,4,'5'),('52',93,5,'5'),('52',93,6,'5'),('53',83,1,'18'),('53',83,2,'18'),('53',83,3,'18'),('53',83,4,'18'),('53',83,5,'18'),('53',83,6,'18'),('53',93,1,'7'),('53',93,2,'7'),('53',93,3,'7'),('53',93,4,'7'),('53',93,5,'7'),('53',93,6,'7'),('54',83,1,'19'),('54',83,2,'19'),('54',83,3,'19'),('54',83,4,'19'),('54',83,5,'19'),('54',83,6,'19'),('54',93,1,'8'),('54',93,2,'8'),('54',93,3,'8'),('54',93,4,'8'),('54',93,5,'8'),('54',93,6,'8'),('55',83,1,'20'),('55',83,2,'20'),('55',83,3,'20'),('55',83,4,'20'),('55',83,5,'20'),('55',83,6,'20'),('55',93,1,'9'),('55',93,2,'9'),('55',93,3,'9'),('55',93,4,'9'),('55',93,5,'9'),('55',93,6,'9'),('56',83,1,'21'),('56',83,2,'21'),('56',83,3,'21'),('56',83,4,'21'),('56',83,5,'21'),('56',83,6,'21'),('56',93,1,'10'),('56',93,2,'10'),('56',93,3,'10'),('56',93,4,'10'),('56',93,5,'10'),('56',93,6,'10'),('57',83,1,'22'),('57',83,2,'22'),('57',83,3,'22'),('57',83,4,'22'),('57',83,5,'22'),('57',83,6,'22'),('57',93,1,'13'),('57',93,2,'13'),('57',93,3,'13'),('57',93,4,'13'),('57',93,5,'13'),('57',93,6,'13'),('58',83,1,'17'),('58',83,2,'17'),('58',83,3,'17'),('58',83,4,'17'),('58',83,5,'17'),('58',83,6,'17'),('58',93,1,'15'),('58',93,2,'15'),('58',93,3,'15'),('58',93,4,'15'),('58',93,5,'15'),('58',93,6,'15'),('59',83,1,'16'),('59',83,2,'16'),('59',83,3,'16'),('59',83,4,'16'),('59',83,5,'16'),('59',83,6,'16'),('59',93,1,'5'),('59',93,2,'5'),('59',93,3,'5'),('59',93,4,'5'),('59',93,5,'5'),('59',93,6,'5'),('60',83,1,'21'),('60',83,2,'21'),('60',83,3,'21'),('60',83,4,'21'),('60',83,5,'21'),('60',83,6,'21'),('60',93,1,'8'),('60',93,2,'8'),('60',93,3,'8'),('60',93,4,'8'),('60',93,5,'8'),('60',93,6,'8'),('61',83,1,'17'),('61',83,2,'17'),('61',83,3,'17'),('61',83,4,'17'),('61',83,5,'17'),('61',83,6,'17'),('61',93,1,'14'),('61',93,2,'14'),('61',93,3,'14'),('61',93,4,'14'),('61',93,5,'14'),('61',93,6,'14'),('62',83,1,'21'),('62',83,2,'21'),('62',83,3,'21'),('62',83,4,'21'),('62',83,5,'21'),('62',83,6,'21'),('62',93,1,'13'),('62',93,2,'13'),('62',93,3,'13'),('62',93,4,'13'),('62',93,5,'13'),('62',93,6,'13');
/*!40000 ALTER TABLE `catalog_product_index_eav_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_tmp`;
CREATE TABLE `catalog_product_index_eav_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` int(10) unsigned NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_VALUE` (`value`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Indexer Temp Table';

--
-- Table structure for table `catalog_product_index_price`
--

DROP TABLE IF EXISTS `catalog_product_index_price`;
CREATE TABLE `catalog_product_index_price` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(12,4) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_MIN_PRICE` (`min_price`),
  KEY `CAT_PRD_IDX_PRICE_WS_ID_CSTR_GROUP_ID_MIN_PRICE` (`website_id`,`customer_group_id`,`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Index Table';

--
-- Dumping data for table `catalog_product_index_price`
--

LOCK TABLES `catalog_product_index_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price` VALUES ('1',0,1,2,'34.0000','34.0000','34.0000','34.0000',NULL),('1',1,1,2,'34.0000','34.0000','34.0000','34.0000',NULL),('1',2,1,2,'34.0000','34.0000','34.0000','34.0000',NULL),('1',3,1,2,'34.0000','34.0000','34.0000','34.0000',NULL),('2',0,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('2',1,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('2',2,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('2',3,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('7',0,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('7',1,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('7',2,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('7',3,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('9',0,1,2,NULL,NULL,'34.0000','52.0000',NULL),('9',1,1,2,NULL,NULL,'34.0000','52.0000',NULL),('9',2,1,2,NULL,NULL,'34.0000','52.0000',NULL),('9',3,1,2,NULL,NULL,'34.0000','52.0000',NULL),('10',0,1,0,'0.0000','0.0000','34.0000','52.0000',NULL),('10',1,1,0,'0.0000','0.0000','34.0000','52.0000',NULL),('10',2,1,0,'0.0000','0.0000','34.0000','52.0000',NULL),('10',3,1,0,'0.0000','0.0000','34.0000','52.0000',NULL),('17',0,1,2,'6.0000','6.0000','6.0000','6.0000',NULL),('17',1,1,2,'6.0000','6.0000','6.0000','6.0000',NULL),('17',2,1,2,'6.0000','6.0000','6.0000','6.0000',NULL),('17',3,1,2,'6.0000','6.0000','6.0000','6.0000',NULL),('18',0,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('18',1,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('18',2,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('18',3,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('19',0,1,2,'38.0000','38.0000','38.0000','38.0000',NULL),('19',1,1,2,'38.0000','38.0000','38.0000','38.0000',NULL),('19',2,1,2,'38.0000','38.0000','38.0000','38.0000',NULL),('19',3,1,2,'38.0000','38.0000','38.0000','38.0000',NULL),('20',0,1,2,'40.0000','40.0000','40.0000','40.0000',NULL),('20',1,1,2,'40.0000','40.0000','40.0000','40.0000',NULL),('20',2,1,2,'40.0000','40.0000','40.0000','40.0000',NULL),('20',3,1,2,'40.0000','40.0000','40.0000','40.0000',NULL),('21',0,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('21',1,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('21',2,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('21',3,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('22',0,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('22',1,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('22',2,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('22',3,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('23',0,1,2,'59.0000','59.0000','59.0000','59.0000',NULL),('23',1,1,2,'59.0000','59.0000','59.0000','59.0000',NULL),('23',2,1,2,'59.0000','59.0000','59.0000','59.0000',NULL),('23',3,1,2,'59.0000','59.0000','59.0000','59.0000',NULL),('24',0,1,2,'74.0000','70.0000','70.0000','70.0000',NULL),('24',1,1,2,'74.0000','70.0000','70.0000','70.0000',NULL),('24',2,1,2,'74.0000','70.0000','70.0000','70.0000',NULL),('24',3,1,2,'74.0000','70.0000','70.0000','70.0000',NULL),('25',0,1,2,'32.0000','30.0000','30.0000','30.0000',NULL),('25',1,1,2,'32.0000','30.0000','30.0000','30.0000',NULL),('25',2,1,2,'32.0000','30.0000','30.0000','30.0000',NULL),('25',3,1,2,'32.0000','30.0000','30.0000','30.0000',NULL),('26',0,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('26',1,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('26',2,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('26',3,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('27',0,1,2,'35.0000','35.0000','35.0000','35.0000',NULL),('27',1,1,2,'35.0000','35.0000','35.0000','35.0000',NULL),('27',2,1,2,'35.0000','35.0000','35.0000','35.0000',NULL),('27',3,1,2,'35.0000','35.0000','35.0000','35.0000',NULL),('28',0,1,2,'33.0000','30.0000','30.0000','30.0000',NULL),('28',1,1,2,'33.0000','30.0000','30.0000','30.0000',NULL),('28',2,1,2,'33.0000','30.0000','30.0000','30.0000',NULL),('28',3,1,2,'33.0000','30.0000','30.0000','30.0000',NULL),('29',0,1,2,'36.0000','36.0000','36.0000','36.0000',NULL),('29',1,1,2,'36.0000','36.0000','36.0000','36.0000',NULL),('29',2,1,2,'36.0000','36.0000','36.0000','36.0000',NULL),('29',3,1,2,'36.0000','36.0000','36.0000','36.0000',NULL),('30',0,1,2,'70.0000','54.0000','54.0000','54.0000',NULL),('30',1,1,2,'70.0000','54.0000','54.0000','54.0000',NULL),('30',2,1,2,'70.0000','54.0000','54.0000','54.0000',NULL),('30',3,1,2,'70.0000','54.0000','54.0000','54.0000',NULL),('31',0,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('31',1,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('31',2,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('31',3,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('32',0,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('32',1,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('32',2,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('32',3,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('33',0,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('33',1,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('33',2,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('33',3,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('34',0,1,2,'50.0000','35.0000','35.0000','35.0000',NULL),('34',1,1,2,'50.0000','35.0000','35.0000','35.0000',NULL),('34',2,1,2,'50.0000','35.0000','35.0000','35.0000',NULL),('34',3,1,2,'50.0000','35.0000','35.0000','35.0000',NULL),('35',0,1,2,'10.0000','8.0000','8.0000','8.0000',NULL),('35',1,1,2,'10.0000','8.0000','8.0000','8.0000',NULL),('35',2,1,2,'10.0000','8.0000','8.0000','8.0000',NULL),('35',3,1,2,'10.0000','8.0000','8.0000','8.0000',NULL),('36',0,1,2,'12.0000','8.0000','8.0000','8.0000',NULL),('36',1,1,2,'12.0000','8.0000','8.0000','8.0000',NULL),('36',2,1,2,'12.0000','8.0000','8.0000','8.0000',NULL),('36',3,1,2,'12.0000','8.0000','8.0000','8.0000',NULL),('37',0,1,2,'12.0000','12.0000','12.0000','12.0000',NULL),('37',1,1,2,'12.0000','12.0000','12.0000','12.0000',NULL),('37',2,1,2,'12.0000','12.0000','12.0000','12.0000',NULL),('37',3,1,2,'12.0000','12.0000','12.0000','12.0000',NULL),('48',0,1,2,'63.0000','45.0000','45.0000','45.0000',NULL),('48',1,1,2,'63.0000','45.0000','45.0000','45.0000',NULL),('48',2,1,2,'63.0000','45.0000','45.0000','45.0000',NULL),('48',3,1,2,'63.0000','45.0000','45.0000','45.0000',NULL),('49',0,1,2,'63.0000','63.0000','63.0000','63.0000',NULL),('49',1,1,2,'63.0000','63.0000','63.0000','63.0000',NULL),('49',2,1,2,'63.0000','63.0000','63.0000','63.0000',NULL),('49',3,1,2,'63.0000','63.0000','63.0000','63.0000',NULL),('50',0,1,0,'63.0000','63.0000','63.0000','63.0000',NULL),('50',1,1,0,'63.0000','63.0000','63.0000','63.0000',NULL),('50',2,1,0,'63.0000','63.0000','63.0000','63.0000',NULL),('50',3,1,0,'63.0000','63.0000','63.0000','63.0000',NULL),('51',0,1,0,'44.0000','44.0000','44.0000','44.0000',NULL),('51',1,1,0,'44.0000','44.0000','44.0000','44.0000',NULL),('51',2,1,0,'44.0000','44.0000','44.0000','44.0000',NULL),('51',3,1,0,'44.0000','44.0000','44.0000','44.0000',NULL),('52',0,1,0,'78.0000','45.0000','45.0000','45.0000',NULL),('52',1,1,0,'78.0000','45.0000','45.0000','45.0000',NULL),('52',2,1,0,'78.0000','45.0000','45.0000','45.0000',NULL),('52',3,1,0,'78.0000','45.0000','45.0000','45.0000',NULL),('53',0,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('53',1,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('53',2,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('53',3,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('54',0,1,0,'75.0000','75.0000','75.0000','75.0000',NULL),('54',1,1,0,'75.0000','75.0000','75.0000','75.0000',NULL),('54',2,1,0,'75.0000','75.0000','75.0000','75.0000',NULL),('54',3,1,0,'75.0000','75.0000','75.0000','75.0000',NULL),('55',0,1,0,'88.0000','55.0000','55.0000','55.0000',NULL),('55',1,1,0,'88.0000','55.0000','55.0000','55.0000',NULL),('55',2,1,0,'88.0000','55.0000','55.0000','55.0000',NULL),('55',3,1,0,'88.0000','55.0000','55.0000','55.0000',NULL),('56',0,1,0,'41.0000','41.0000','41.0000','41.0000',NULL),('56',1,1,0,'41.0000','41.0000','41.0000','41.0000',NULL),('56',2,1,0,'41.0000','41.0000','41.0000','41.0000',NULL),('56',3,1,0,'41.0000','41.0000','41.0000','41.0000',NULL),('57',0,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('57',1,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('57',2,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('57',3,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('58',0,1,2,'87.0000','50.0000','50.0000','50.0000',NULL),('58',1,1,2,'87.0000','50.0000','50.0000','50.0000',NULL),('58',2,1,2,'87.0000','50.0000','50.0000','50.0000',NULL),('58',3,1,2,'87.0000','50.0000','50.0000','50.0000',NULL),('59',0,1,0,'6545.0000','6545.0000','6545.0000','6545.0000',NULL),('59',1,1,0,'6545.0000','6545.0000','6545.0000','6545.0000',NULL),('59',2,1,0,'6545.0000','6545.0000','6545.0000','6545.0000',NULL),('59',3,1,0,'6545.0000','6545.0000','6545.0000','6545.0000',NULL),('60',0,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('60',1,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('60',2,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('60',3,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('61',0,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('61',1,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('61',2,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('61',3,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('62',0,1,2,'76.0000','43.0000','43.0000','43.0000',NULL),('62',1,1,2,'76.0000','43.0000','43.0000','43.0000',NULL),('62',2,1,2,'76.0000','43.0000','43.0000','43.0000',NULL),('62',3,1,2,'76.0000','43.0000','43.0000','43.0000',NULL),('63',0,1,0,'45.0000','45.0000','45.0000','45.0000',NULL),('63',1,1,0,'45.0000','45.0000','45.0000','45.0000',NULL),('63',2,1,0,'45.0000','45.0000','45.0000','45.0000',NULL),('63',3,1,0,'45.0000','45.0000','45.0000','45.0000',NULL),('64',0,1,0,'76.0000','43.0000','43.0000','43.0000',NULL),('64',1,1,0,'76.0000','43.0000','43.0000','43.0000',NULL),('64',2,1,0,'76.0000','43.0000','43.0000','43.0000',NULL),('64',3,1,0,'76.0000','43.0000','43.0000','43.0000',NULL),('65',0,1,0,'67.0000','67.0000','67.0000','67.0000',NULL),('65',1,1,0,'67.0000','67.0000','67.0000','67.0000',NULL),('65',2,1,0,'67.0000','67.0000','67.0000','67.0000',NULL),('65',3,1,0,'67.0000','67.0000','67.0000','67.0000',NULL),('67',0,1,0,'88.0000','88.0000','88.0000','88.0000',NULL),('67',1,1,0,'88.0000','88.0000','88.0000','88.0000',NULL),('67',2,1,0,'88.0000','88.0000','88.0000','88.0000',NULL),('67',3,1,0,'88.0000','88.0000','88.0000','88.0000',NULL),('68',0,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('68',1,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('68',2,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('68',3,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('69',0,1,2,'76.0000','55.0000','55.0000','55.0000',NULL),('69',1,1,2,'76.0000','55.0000','55.0000','55.0000',NULL),('69',2,1,2,'76.0000','55.0000','55.0000','55.0000',NULL),('69',3,1,2,'76.0000','55.0000','55.0000','55.0000',NULL),('70',0,1,0,'65.0000','65.0000','65.0000','65.0000',NULL),('70',1,1,0,'65.0000','65.0000','65.0000','65.0000',NULL),('70',2,1,0,'65.0000','65.0000','65.0000','65.0000',NULL),('70',3,1,0,'65.0000','65.0000','65.0000','65.0000',NULL),('71',0,1,0,'87.0000','35.0000','35.0000','35.0000',NULL),('71',1,1,0,'87.0000','35.0000','35.0000','35.0000',NULL),('71',2,1,0,'87.0000','35.0000','35.0000','35.0000',NULL),('71',3,1,0,'87.0000','35.0000','35.0000','35.0000',NULL),('72',0,1,0,'54.0000','54.0000','54.0000','54.0000',NULL),('72',1,1,0,'54.0000','54.0000','54.0000','54.0000',NULL),('72',2,1,0,'54.0000','54.0000','54.0000','54.0000',NULL),('72',3,1,0,'54.0000','54.0000','54.0000','54.0000',NULL),('73',0,1,2,'75.0000','75.0000','75.0000','75.0000',NULL),('73',1,1,2,'75.0000','75.0000','75.0000','75.0000',NULL),('73',2,1,2,'75.0000','75.0000','75.0000','75.0000',NULL),('73',3,1,2,'75.0000','75.0000','75.0000','75.0000',NULL),('74',0,1,2,'83.0000','65.0000','65.0000','65.0000',NULL),('74',1,1,2,'83.0000','65.0000','65.0000','65.0000',NULL),('74',2,1,2,'83.0000','65.0000','65.0000','65.0000',NULL),('74',3,1,2,'83.0000','65.0000','65.0000','65.0000',NULL),('75',0,1,0,'57.0000','57.0000','57.0000','57.0000',NULL),('75',1,1,0,'57.0000','57.0000','57.0000','57.0000',NULL),('75',2,1,0,'57.0000','57.0000','57.0000','57.0000',NULL),('75',3,1,0,'57.0000','57.0000','57.0000','57.0000',NULL),('76',0,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('76',1,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('76',2,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('76',3,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('77',0,1,0,'64.0000','64.0000','64.0000','64.0000',NULL),('77',1,1,0,'64.0000','64.0000','64.0000','64.0000',NULL),('77',2,1,0,'64.0000','64.0000','64.0000','64.0000',NULL),('77',3,1,0,'64.0000','64.0000','64.0000','64.0000',NULL);
/*!40000 ALTER TABLE `catalog_product_index_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_idx`;
CREATE TABLE `catalog_product_index_price_bundle_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class Id',
  `price_type` smallint(5) unsigned NOT NULL COMMENT 'Price Type',
  `special_price` decimal(12,4) DEFAULT NULL COMMENT 'Special Price',
  `tier_percent` decimal(12,4) DEFAULT NULL COMMENT 'Tier Percent',
  `orig_price` decimal(12,4) DEFAULT NULL COMMENT 'Orig Price',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(12,4) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Idx';

--
-- Dumping data for table `catalog_product_index_price_bundle_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_bundle_idx` VALUES ('10',0,1,0,0,'0.0000',NULL,'0.0000','0.0000','0.0000','0.0000',NULL,NULL),('10',1,1,0,0,'0.0000',NULL,'0.0000','0.0000','0.0000','0.0000',NULL,NULL),('10',2,1,0,0,'0.0000',NULL,'0.0000','0.0000','0.0000','0.0000',NULL,NULL),('10',3,1,0,0,'0.0000',NULL,'0.0000','0.0000','0.0000','0.0000',NULL,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_idx`;
CREATE TABLE `catalog_product_index_price_bundle_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `alt_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `alt_tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Opt Idx';

--
-- Dumping data for table `catalog_product_index_price_bundle_opt_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_bundle_opt_idx` VALUES ('10',0,1,'11','34.0000','0.0000','52.0000',NULL,'0.0000'),('10',1,1,'11','34.0000','0.0000','52.0000',NULL,'0.0000'),('10',2,1,'11','34.0000','0.0000','52.0000',NULL,'0.0000'),('10',3,1,'11','34.0000','0.0000','52.0000',NULL,'0.0000');
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_tmp`;
CREATE TABLE `catalog_product_index_price_bundle_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `alt_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `alt_tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Opt Tmp';

--
-- Table structure for table `catalog_product_index_price_bundle_sel_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_idx`;
CREATE TABLE `catalog_product_index_price_bundle_sel_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `selection_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Id',
  `group_type` smallint(5) unsigned DEFAULT '0' COMMENT 'Group Type',
  `is_required` smallint(5) unsigned DEFAULT '0' COMMENT 'Is Required',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Sel Idx';

--
-- Dumping data for table `catalog_product_index_price_bundle_sel_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_sel_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_bundle_sel_idx` VALUES ('10',0,1,'11','25',0,1,'34.0000',NULL),('10',0,1,'11','26',0,1,'52.0000',NULL),('10',1,1,'11','25',0,1,'34.0000',NULL),('10',1,1,'11','26',0,1,'52.0000',NULL),('10',2,1,'11','25',0,1,'34.0000',NULL),('10',2,1,'11','26',0,1,'52.0000',NULL),('10',3,1,'11','25',0,1,'34.0000',NULL),('10',3,1,'11','26',0,1,'52.0000',NULL);
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_tmp`;
CREATE TABLE `catalog_product_index_price_bundle_sel_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `selection_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Id',
  `group_type` smallint(5) unsigned DEFAULT '0' COMMENT 'Group Type',
  `is_required` smallint(5) unsigned DEFAULT '0' COMMENT 'Is Required',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Sel Tmp';

--
-- Table structure for table `catalog_product_index_price_bundle_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_tmp`;
CREATE TABLE `catalog_product_index_price_bundle_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class Id',
  `price_type` smallint(5) unsigned NOT NULL COMMENT 'Price Type',
  `special_price` decimal(12,4) DEFAULT NULL COMMENT 'Special Price',
  `tier_percent` decimal(12,4) DEFAULT NULL COMMENT 'Tier Percent',
  `orig_price` decimal(12,4) DEFAULT NULL COMMENT 'Orig Price',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(12,4) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Tmp';

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_idx`;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_idx` (
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int(10) unsigned NOT NULL COMMENT 'Child ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Config Option Aggregate Index Table';

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_tmp`;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_tmp` (
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int(10) unsigned NOT NULL COMMENT 'Child ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Config Option Aggregate Temp Table';

--
-- Table structure for table `catalog_product_index_price_cfg_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_idx`;
CREATE TABLE `catalog_product_index_price_cfg_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Config Option Index Table';

--
-- Table structure for table `catalog_product_index_price_cfg_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_tmp`;
CREATE TABLE `catalog_product_index_price_cfg_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Config Option Temp Table';

--
-- Table structure for table `catalog_product_index_price_downlod_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_idx`;
CREATE TABLE `catalog_product_index_price_downlod_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Minimum price',
  `max_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Maximum price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Indexer Table for price of downloadable products';

--
-- Table structure for table `catalog_product_index_price_downlod_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_tmp`;
CREATE TABLE `catalog_product_index_price_downlod_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Minimum price',
  `max_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Maximum price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Temporary Indexer Table for price of downloadable products';

--
-- Table structure for table `catalog_product_index_price_final_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_idx`;
CREATE TABLE `catalog_product_index_price_final_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `orig_price` decimal(12,4) DEFAULT NULL COMMENT 'Original Price',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(12,4) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Final Index Table';

--
-- Table structure for table `catalog_product_index_price_final_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_tmp`;
CREATE TABLE `catalog_product_index_price_final_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `orig_price` decimal(12,4) DEFAULT NULL COMMENT 'Original Price',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(12,4) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Final Temp Table';

--
-- Table structure for table `catalog_product_index_price_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_idx`;
CREATE TABLE `catalog_product_index_price_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(12,4) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_MIN_PRICE` (`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Index Table';

--
-- Dumping data for table `catalog_product_index_price_idx`
--

LOCK TABLES `catalog_product_index_price_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_idx` VALUES ('1',0,1,2,'34.0000','34.0000','34.0000','34.0000',NULL),('1',1,1,2,'34.0000','34.0000','34.0000','34.0000',NULL),('1',2,1,2,'34.0000','34.0000','34.0000','34.0000',NULL),('1',3,1,2,'34.0000','34.0000','34.0000','34.0000',NULL),('2',0,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('2',1,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('2',2,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('2',3,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('7',0,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('7',1,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('7',2,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('7',3,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('9',0,1,2,NULL,NULL,'34.0000','52.0000',NULL),('9',1,1,2,NULL,NULL,'34.0000','52.0000',NULL),('9',2,1,2,NULL,NULL,'34.0000','52.0000',NULL),('9',3,1,2,NULL,NULL,'34.0000','52.0000',NULL),('10',0,1,0,'0.0000','0.0000','34.0000','52.0000',NULL),('10',1,1,0,'0.0000','0.0000','34.0000','52.0000',NULL),('10',2,1,0,'0.0000','0.0000','34.0000','52.0000',NULL),('10',3,1,0,'0.0000','0.0000','34.0000','52.0000',NULL),('17',0,1,2,'6.0000','6.0000','6.0000','6.0000',NULL),('17',1,1,2,'6.0000','6.0000','6.0000','6.0000',NULL),('17',2,1,2,'6.0000','6.0000','6.0000','6.0000',NULL),('17',3,1,2,'6.0000','6.0000','6.0000','6.0000',NULL),('18',0,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('18',1,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('18',2,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('18',3,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('19',0,1,2,'38.0000','38.0000','38.0000','38.0000',NULL),('19',1,1,2,'38.0000','38.0000','38.0000','38.0000',NULL),('19',2,1,2,'38.0000','38.0000','38.0000','38.0000',NULL),('19',3,1,2,'38.0000','38.0000','38.0000','38.0000',NULL),('20',0,1,2,'40.0000','40.0000','40.0000','40.0000',NULL),('20',1,1,2,'40.0000','40.0000','40.0000','40.0000',NULL),('20',2,1,2,'40.0000','40.0000','40.0000','40.0000',NULL),('20',3,1,2,'40.0000','40.0000','40.0000','40.0000',NULL),('21',0,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('21',1,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('21',2,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('21',3,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('22',0,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('22',1,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('22',2,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('22',3,1,2,'52.0000','52.0000','52.0000','52.0000',NULL),('23',0,1,2,'59.0000','59.0000','59.0000','59.0000',NULL),('23',1,1,2,'59.0000','59.0000','59.0000','59.0000',NULL),('23',2,1,2,'59.0000','59.0000','59.0000','59.0000',NULL),('23',3,1,2,'59.0000','59.0000','59.0000','59.0000',NULL),('24',0,1,2,'74.0000','70.0000','70.0000','70.0000',NULL),('24',1,1,2,'74.0000','70.0000','70.0000','70.0000',NULL),('24',2,1,2,'74.0000','70.0000','70.0000','70.0000',NULL),('24',3,1,2,'74.0000','70.0000','70.0000','70.0000',NULL),('25',0,1,2,'32.0000','30.0000','30.0000','30.0000',NULL),('25',1,1,2,'32.0000','30.0000','30.0000','30.0000',NULL),('25',2,1,2,'32.0000','30.0000','30.0000','30.0000',NULL),('25',3,1,2,'32.0000','30.0000','30.0000','30.0000',NULL),('26',0,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('26',1,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('26',2,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('26',3,1,2,'32.0000','32.0000','32.0000','32.0000',NULL),('27',0,1,2,'35.0000','35.0000','35.0000','35.0000',NULL),('27',1,1,2,'35.0000','35.0000','35.0000','35.0000',NULL),('27',2,1,2,'35.0000','35.0000','35.0000','35.0000',NULL),('27',3,1,2,'35.0000','35.0000','35.0000','35.0000',NULL),('28',0,1,2,'33.0000','30.0000','30.0000','30.0000',NULL),('28',1,1,2,'33.0000','30.0000','30.0000','30.0000',NULL),('28',2,1,2,'33.0000','30.0000','30.0000','30.0000',NULL),('28',3,1,2,'33.0000','30.0000','30.0000','30.0000',NULL),('29',0,1,2,'36.0000','36.0000','36.0000','36.0000',NULL),('29',1,1,2,'36.0000','36.0000','36.0000','36.0000',NULL),('29',2,1,2,'36.0000','36.0000','36.0000','36.0000',NULL),('29',3,1,2,'36.0000','36.0000','36.0000','36.0000',NULL),('30',0,1,2,'70.0000','54.0000','54.0000','54.0000',NULL),('30',1,1,2,'70.0000','54.0000','54.0000','54.0000',NULL),('30',2,1,2,'70.0000','54.0000','54.0000','54.0000',NULL),('30',3,1,2,'70.0000','54.0000','54.0000','54.0000',NULL),('31',0,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('31',1,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('31',2,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('31',3,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('32',0,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('32',1,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('32',2,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('32',3,1,2,'70.0000','70.0000','70.0000','70.0000',NULL),('33',0,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('33',1,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('33',2,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('33',3,1,2,'45.0000','45.0000','45.0000','45.0000',NULL),('34',0,1,2,'50.0000','35.0000','35.0000','35.0000',NULL),('34',1,1,2,'50.0000','35.0000','35.0000','35.0000',NULL),('34',2,1,2,'50.0000','35.0000','35.0000','35.0000',NULL),('34',3,1,2,'50.0000','35.0000','35.0000','35.0000',NULL),('35',0,1,2,'10.0000','8.0000','8.0000','8.0000',NULL),('35',1,1,2,'10.0000','8.0000','8.0000','8.0000',NULL),('35',2,1,2,'10.0000','8.0000','8.0000','8.0000',NULL),('35',3,1,2,'10.0000','8.0000','8.0000','8.0000',NULL),('36',0,1,2,'12.0000','8.0000','8.0000','8.0000',NULL),('36',1,1,2,'12.0000','8.0000','8.0000','8.0000',NULL),('36',2,1,2,'12.0000','8.0000','8.0000','8.0000',NULL),('36',3,1,2,'12.0000','8.0000','8.0000','8.0000',NULL),('37',0,1,2,'12.0000','12.0000','12.0000','12.0000',NULL),('37',1,1,2,'12.0000','12.0000','12.0000','12.0000',NULL),('37',2,1,2,'12.0000','12.0000','12.0000','12.0000',NULL),('37',3,1,2,'12.0000','12.0000','12.0000','12.0000',NULL),('48',0,1,2,'63.0000','45.0000','45.0000','45.0000',NULL),('48',1,1,2,'63.0000','45.0000','45.0000','45.0000',NULL),('48',2,1,2,'63.0000','45.0000','45.0000','45.0000',NULL),('48',3,1,2,'63.0000','45.0000','45.0000','45.0000',NULL),('49',0,1,2,'63.0000','63.0000','63.0000','63.0000',NULL),('49',1,1,2,'63.0000','63.0000','63.0000','63.0000',NULL),('49',2,1,2,'63.0000','63.0000','63.0000','63.0000',NULL),('49',3,1,2,'63.0000','63.0000','63.0000','63.0000',NULL),('50',0,1,0,'63.0000','63.0000','63.0000','63.0000',NULL),('50',1,1,0,'63.0000','63.0000','63.0000','63.0000',NULL),('50',2,1,0,'63.0000','63.0000','63.0000','63.0000',NULL),('50',3,1,0,'63.0000','63.0000','63.0000','63.0000',NULL),('51',0,1,0,'44.0000','44.0000','44.0000','44.0000',NULL),('51',1,1,0,'44.0000','44.0000','44.0000','44.0000',NULL),('51',2,1,0,'44.0000','44.0000','44.0000','44.0000',NULL),('51',3,1,0,'44.0000','44.0000','44.0000','44.0000',NULL),('52',0,1,0,'78.0000','45.0000','45.0000','45.0000',NULL),('52',1,1,0,'78.0000','45.0000','45.0000','45.0000',NULL),('52',2,1,0,'78.0000','45.0000','45.0000','45.0000',NULL),('52',3,1,0,'78.0000','45.0000','45.0000','45.0000',NULL),('53',0,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('53',1,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('53',2,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('53',3,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('54',0,1,0,'75.0000','75.0000','75.0000','75.0000',NULL),('54',1,1,0,'75.0000','75.0000','75.0000','75.0000',NULL),('54',2,1,0,'75.0000','75.0000','75.0000','75.0000',NULL),('54',3,1,0,'75.0000','75.0000','75.0000','75.0000',NULL),('55',0,1,0,'88.0000','55.0000','55.0000','55.0000',NULL),('55',1,1,0,'88.0000','55.0000','55.0000','55.0000',NULL),('55',2,1,0,'88.0000','55.0000','55.0000','55.0000',NULL),('55',3,1,0,'88.0000','55.0000','55.0000','55.0000',NULL),('56',0,1,0,'41.0000','41.0000','41.0000','41.0000',NULL),('56',1,1,0,'41.0000','41.0000','41.0000','41.0000',NULL),('56',2,1,0,'41.0000','41.0000','41.0000','41.0000',NULL),('56',3,1,0,'41.0000','41.0000','41.0000','41.0000',NULL),('57',0,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('57',1,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('57',2,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('57',3,1,0,'66.0000','66.0000','66.0000','66.0000',NULL),('58',0,1,2,'87.0000','50.0000','50.0000','50.0000',NULL),('58',1,1,2,'87.0000','50.0000','50.0000','50.0000',NULL),('58',2,1,2,'87.0000','50.0000','50.0000','50.0000',NULL),('58',3,1,2,'87.0000','50.0000','50.0000','50.0000',NULL),('59',0,1,0,'6545.0000','6545.0000','6545.0000','6545.0000',NULL),('59',1,1,0,'6545.0000','6545.0000','6545.0000','6545.0000',NULL),('59',2,1,0,'6545.0000','6545.0000','6545.0000','6545.0000',NULL),('59',3,1,0,'6545.0000','6545.0000','6545.0000','6545.0000',NULL),('60',0,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('60',1,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('60',2,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('60',3,1,0,'80.0000','80.0000','80.0000','80.0000',NULL),('61',0,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('61',1,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('61',2,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('61',3,1,0,'55.0000','55.0000','55.0000','55.0000',NULL),('62',0,1,2,'76.0000','43.0000','43.0000','43.0000',NULL),('62',1,1,2,'76.0000','43.0000','43.0000','43.0000',NULL),('62',2,1,2,'76.0000','43.0000','43.0000','43.0000',NULL),('62',3,1,2,'76.0000','43.0000','43.0000','43.0000',NULL);
/*!40000 ALTER TABLE `catalog_product_index_price_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_idx`;
CREATE TABLE `catalog_product_index_price_opt_agr_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Option Aggregate Index Table';

--
-- Table structure for table `catalog_product_index_price_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_tmp`;
CREATE TABLE `catalog_product_index_price_opt_agr_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Option Aggregate Temp Table';

--
-- Table structure for table `catalog_product_index_price_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_idx`;
CREATE TABLE `catalog_product_index_price_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Option Index Table';

--
-- Table structure for table `catalog_product_index_price_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_tmp`;
CREATE TABLE `catalog_product_index_price_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Option Temp Table';

--
-- Table structure for table `catalog_product_index_price_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_tmp`;
CREATE TABLE `catalog_product_index_price_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(12,4) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_TMP_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_TMP_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_TMP_MIN_PRICE` (`min_price`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Temp Table';

--
-- Table structure for table `catalog_product_index_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_index_tier_price`;
CREATE TABLE `catalog_product_index_tier_price` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_TIER_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_TIER_PRICE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Tier Price Index Table';

--
-- Table structure for table `catalog_product_index_website`
--

DROP TABLE IF EXISTS `catalog_product_index_website`;
CREATE TABLE `catalog_product_index_website` (
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `website_date` date DEFAULT NULL COMMENT 'Website Date',
  `rate` float DEFAULT '1' COMMENT 'Rate',
  PRIMARY KEY (`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_WEBSITE_WEBSITE_DATE` (`website_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Website Index Table';

--
-- Dumping data for table `catalog_product_index_website`
--

LOCK TABLES `catalog_product_index_website` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_website` DISABLE KEYS */;
INSERT INTO `catalog_product_index_website` VALUES (1,'2016-12-09','1');
/*!40000 ALTER TABLE `catalog_product_index_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link`
--

DROP TABLE IF EXISTS `catalog_product_link`;
CREATE TABLE `catalog_product_link` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `linked_product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Linked Product ID',
  `link_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Link Type ID',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `CATALOG_PRODUCT_LINK_LINK_TYPE_ID_PRODUCT_ID_LINKED_PRODUCT_ID` (`link_type_id`,`product_id`,`linked_product_id`),
  KEY `CATALOG_PRODUCT_LINK_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_PRODUCT_LINK_LINKED_PRODUCT_ID` (`linked_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1442 DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Product Linkage Table';

--
-- Dumping data for table `catalog_product_link`
--

LOCK TABLES `catalog_product_link` WRITE;
/*!40000 ALTER TABLE `catalog_product_link` DISABLE KEYS */;
INSERT INTO `catalog_product_link` VALUES ('766','1','2',1),('767','1','7',1),('768','1','9',1),('769','1','10',1),('780','2','1',1),('779','2','7',1),('778','2','9',1),('781','2','10',1),('790','7','1',1),('792','7','2',1),('791','7','9',1),('793','7','10',1),('804','9','1',1),('805','9','2',1),('806','9','7',1),('807','9','10',1),('808','9','17',1),('818','10','1',1),('819','10','2',1),('820','10','9',1),('827','17','1',1),('828','17','2',1),('829','17','9',1),('830','17','10',1),('839','18','10',1),('840','18','17',1),('847','19','9',1),('848','19','10',1),('849','19','17',1),('850','19','18',1),('859','20','9',1),('860','20','10',1),('861','20','17',1),('862','20','18',1),('863','20','19',1),('874','21','17',1),('875','21','18',1),('876','21','19',1),('877','21','20',1),('890','22','1',1),('891','22','2',1),('892','22','7',1),('893','22','9',1),('903','23','7',1),('902','23','18',1),('904','23','19',1),('905','23','20',1),('914','24','9',1),('915','24','10',1),('916','24','18',1),('917','24','19',1),('918','24','20',1),('919','24','21',1),('932','25','7',1),('933','25','9',1),('934','25','10',1),('935','25','17',1),('944','26','9',1),('945','26','10',1),('946','26','17',1),('947','26','18',1),('948','26','19',1),('949','26','20',1),('962','27','9',1),('963','27','10',1),('964','27','18',1),('965','27','19',1),('974','28','10',1),('975','28','17',1),('976','28','20',1),('977','28','21',1),('986','29','30',1),('987','29','31',1),('988','29','32',1),('1033','30','29',1),('1034','30','31',1),('1035','30','32',1),('1036','30','33',1),('1045','31','29',1),('1046','31','30',1),('1047','31','32',1),('1048','31','33',1),('1057','32','29',1),('1058','32','30',1),('1059','32','31',1),('1060','32','33',1),('1070','33','30',1),('1069','33','31',1),('1068','33','32',1),('1067','33','34',1),('1079','34','33',1),('1080','34','35',1),('1081','34','36',1),('1082','34','37',1),('1124','35','32',1),('1125','35','33',1),('1126','35','34',1),('1127','35','36',1),('1135','36','31',1),('1136','36','32',1),('1137','36','33',1),('1138','36','34',1),('1147','37','32',1),('1148','37','33',1),('1149','37','35',1),('1150','37','36',1),('1177','48','29',1),('1178','48','30',1),('1179','48','31',1),('1186','49','35',1),('1187','49','36',1),('1188','49','37',1),('1189','49','48',1),('1199','50','36',1),('1198','50','37',1),('1196','50','48',1),('1197','50','49',1),('1208','52','51',1),('1212','53','51',1),('1211','53','52',1),('1219','54','51',1),('1218','54','52',1),('1217','54','53',1),('1229','55','51',1),('1228','55','52',1),('1226','55','53',1),('1227','55','54',1),('1238','56','52',1),('1239','56','53',1),('1240','56','55',1),('1252','57','53',1),('1251','57','54',1),('1250','57','55',1),('1249','57','56',1),('1266','58','53',1),('1265','58','54',1),('1264','58','55',1),('1263','58','56',1),('1262','58','57',1),('1277','59','53',1),('1276','59','54',1),('1275','59','55',1),('1274','59','56',1),('1273','59','57',1),('1289','60','56',1),('1288','60','57',1),('1287','60','58',1),('1286','60','59',1),('1298','61','57',1),('1299','61','58',1),('1300','61','59',1),('1310','62','60',1),('1309','62','61',1),('1316','64','63',1),('1320','65','63',1),('1319','65','64',1),('1327','67','63',1),('1326','67','64',1),('1325','67','65',1),('1337','68','63',1),('1336','68','64',1),('1335','68','65',1),('1334','68','67',1),('1349','69','64',1),('1348','69','65',1),('1347','69','67',1),('1346','69','68',1),('1362','70','67',1),('1361','70','68',1),('1360','70','69',1),('1373','71','67',1),('1372','71','68',1),('1371','71','69',1),('1370','71','70',1),('1383','72','68',1),('1382','72','69',1),('1381','72','70',1),('1380','72','71',1),('1392','73','70',1),('1391','73','71',1),('1390','73','72',1),('1403','74','69',1),('1402','74','70',1),('1401','74','72',1),('1400','74','73',1),('1415','75','70',1),('1414','75','71',1),('1413','75','72',1),('1412','75','73',1),('1424','76','72',1),('1425','76','73',1),('1423','76','74',1),('1434','77','73',1),('1433','77','74',1),('1435','77','75',1),('802','9','1',3),('803','9','7',3),('770','1','2',4),('771','1','7',4),('772','1','9',4),('773','1','10',4),('782','2','1',4),('784','2','7',4),('783','2','9',4),('785','2','10',4),('794','7','1',4),('795','7','2',4),('796','7','9',4),('797','7','10',4),('810','9','1',4),('809','9','2',4),('811','9','7',4),('812','9','10',4),('821','10','1',4),('822','10','2',4),('823','10','9',4),('831','17','1',4),('832','17','2',4),('833','17','9',4),('834','17','10',4),('841','18','9',4),('842','18','10',4),('843','18','17',4),('851','19','9',4),('852','19','10',4),('853','19','17',4),('854','19','18',4),('864','20','9',4),('865','20','10',4),('866','20','17',4),('867','20','18',4),('868','20','19',4),('878','21','9',4),('879','21','10',4),('880','21','17',4),('881','21','18',4),('882','21','19',4),('883','21','20',4),('894','22','1',4),('895','22','2',4),('896','22','7',4),('897','22','9',4),('906','23','1',4),('907','23','2',4),('908','23','9',4),('909','23','10',4),('920','24','1',4),('921','24','2',4),('922','24','9',4),('923','24','10',4),('924','24','17',4),('925','24','18',4),('936','25','7',4),('937','25','9',4),('938','25','18',4),('939','25','19',4),('950','26','9',4),('951','26','10',4),('952','26','17',4),('953','26','18',4),('954','26','19',4),('955','26','20',4),('966','27','9',4),('967','27','18',4),('968','27','19',4),('969','27','20',4),('978','28','17',4),('979','28','18',4),('980','28','19',4),('981','28','23',4),('989','29','30',4),('990','29','31',4),('991','29','32',4),('992','29','33',4),('1041','30','29',4),('1042','30','31',4),('1043','30','32',4),('1044','30','33',4),('1053','31','29',4),('1054','31','30',4),('1055','31','33',4),('1056','31','34',4),('1061','32','31',4),('1062','32','48',4),('1071','33','29',4),('1072','33','30',4),('1073','33','31',4),('1074','33','48',4),('1083','34','33',4),('1084','34','35',4),('1085','34','36',4),('1086','34','37',4),('1128','35','33',4),('1129','35','34',4),('1130','35','36',4),('1131','35','37',4),('1142','36','30',4),('1141','36','31',4),('1140','36','32',4),('1139','36','33',4),('1151','37','33',4),('1152','37','34',4),('1153','37','35',4),('1154','37','36',4),('1183','48','29',4),('1184','48','30',4),('1185','48','31',4),('1192','49','29',4),('1193','49','30',4),('1194','49','31',4),('1195','49','32',4),('1203','50','36',4),('1202','50','37',4),('1201','50','48',4),('1200','50','49',4),('1209','52','51',4),('1214','53','51',4),('1213','53','52',4),('1222','54','51',4),('1221','54','52',4),('1220','54','53',4),('1233','55','51',4),('1232','55','52',4),('1231','55','53',4),('1230','55','54',4),('1243','56','51',4),('1242','56','52',4),('1241','56','53',4),('1244','56','55',4),('1256','57','52',4),('1257','57','53',4),('1255','57','54',4),('1254','57','55',4),('1253','57','56',4),('1269','58','55',4),('1268','58','56',4),('1267','58','57',4),('1281','59','54',4),('1280','59','55',4),('1279','59','56',4),('1278','59','57',4),('1293','60','54',4),('1292','60','55',4),('1291','60','56',4),('1290','60','57',4),('1304','61','56',4),('1303','61','57',4),('1301','61','58',4),('1302','61','59',4),('1312','62','57',4),('1311','62','59',4),('1317','64','63',4),('1322','65','63',4),('1321','65','64',4),('1330','67','63',4),('1329','67','64',4),('1328','67','65',4),('1341','68','63',4),('1340','68','64',4),('1339','68','65',4),('1338','68','67',4),('1354','69','63',4),('1353','69','64',4),('1352','69','65',4),('1351','69','67',4),('1350','69','68',4),('1365','70','67',4),('1364','70','68',4),('1363','70','69',4),('1376','71','68',4),('1375','71','69',4),('1374','71','70',4),('1386','72','69',4),('1385','72','70',4),('1384','72','71',4),('1396','73','68',4),('1395','73','69',4),('1394','73','70',4),('1393','73','72',4),('1407','74','70',4),('1406','74','71',4),('1405','74','72',4),('1404','74','73',4),('1419','75','71',4),('1418','75','72',4),('1417','75','73',4),('1416','75','74',4),('1428','76','72',4),('1427','76','73',4),('1426','76','74',4),('1438','77','73',4),('1437','77','74',4),('1436','77','75',4),('774','1','2',5),('775','1','7',5),('776','1','9',5),('777','1','10',5),('786','2','1',5),('787','2','7',5),('788','2','9',5),('789','2','10',5),('798','7','1',5),('799','7','2',5),('800','7','9',5),('801','7','10',5),('813','9','1',5),('814','9','2',5),('815','9','10',5),('816','9','17',5),('817','9','18',5),('824','10','1',5),('825','10','2',5),('826','10','9',5),('835','17','1',5),('836','17','2',5),('837','17','9',5),('838','17','10',5),('844','18','9',5),('845','18','10',5),('846','18','17',5),('855','19','9',5),('856','19','10',5),('857','19','17',5),('858','19','18',5),('869','20','9',5),('870','20','10',5),('871','20','17',5),('872','20','18',5),('873','20','19',5),('884','21','1',5),('885','21','2',5),('886','21','9',5),('887','21','10',5),('888','21','17',5),('889','21','18',5),('898','22','1',5),('899','22','2',5),('900','22','7',5),('901','22','9',5),('910','23','9',5),('911','23','18',5),('912','23','19',5),('913','23','20',5),('926','24','9',5),('927','24','10',5),('928','24','18',5),('929','24','19',5),('930','24','20',5),('931','24','21',5),('940','25','9',5),('941','25','10',5),('942','25','17',5),('943','25','18',5),('956','26','7',5),('957','26','9',5),('958','26','10',5),('959','26','17',5),('960','26','18',5),('961','26','19',5),('970','27','9',5),('971','27','17',5),('972','27','18',5),('973','27','20',5),('982','28','10',5),('983','28','17',5),('984','28','18',5),('985','28','19',5),('996','29','34',5),('995','29','35',5),('994','29','36',5),('993','29','37',5),('1037','30','29',5),('1038','30','31',5),('1039','30','32',5),('1040','30','33',5),('1049','31','32',5),('1050','31','33',5),('1051','31','35',5),('1052','31','36',5),('1063','32','29',5),('1064','32','30',5),('1065','32','31',5),('1066','32','33',5),('1075','33','32',5),('1076','33','35',5),('1077','33','36',5),('1078','33','37',5),('1087','34','33',5),('1088','34','35',5),('1089','34','36',5),('1090','34','37',5),('1132','35','33',5),('1133','35','34',5),('1134','35','37',5),('1143','36','29',5),('1144','36','30',5),('1145','36','31',5),('1146','36','32',5),('1155','37','34',5),('1156','37','35',5),('1157','37','36',5),('1180','48','29',5),('1181','48','30',5),('1182','48','31',5),('1190','49','29',5),('1191','49','30',5),('1206','50','34',5),('1205','50','35',5),('1204','50','36',5),('1207','50','37',5),('1210','52','51',5),('1216','53','51',5),('1215','53','52',5),('1225','54','51',5),('1224','54','52',5),('1223','54','53',5),('1237','55','51',5),('1236','55','52',5),('1235','55','53',5),('1234','55','54',5),('1247','56','51',5),('1246','56','52',5),('1245','56','53',5),('1248','56','54',5),('1261','57','53',5),('1260','57','54',5),('1259','57','55',5),('1258','57','56',5),('1272','58','54',5),('1271','58','55',5),('1270','58','56',5),('1284','59','54',5),('1283','59','55',5),('1282','59','56',5),('1285','59','57',5),('1297','60','52',5),('1296','60','53',5),('1295','60','54',5),('1294','60','55',5),('1308','61','55',5),('1307','61','56',5),('1306','61','57',5),('1305','61','58',5),('1315','62','57',5),('1314','62','58',5),('1313','62','59',5),('1318','64','63',5),('1324','65','63',5),('1323','65','64',5),('1333','67','63',5),('1332','67','64',5),('1331','67','65',5),('1345','68','63',5),('1344','68','64',5),('1343','68','65',5),('1342','68','67',5),('1359','69','63',5),('1358','69','64',5),('1357','69','65',5),('1356','69','67',5),('1355','69','68',5),('1369','70','64',5),('1368','70','65',5),('1367','70','67',5),('1366','70','68',5),('1379','71','68',5),('1378','71','69',5),('1377','71','70',5),('1389','72','69',5),('1388','72','70',5),('1387','72','71',5),('1399','73','70',5),('1398','73','71',5),('1397','73','72',5),('1411','74','70',5),('1410','74','71',5),('1409','74','72',5),('1408','74','73',5),('1422','75','70',5),('1421','75','71',5),('1420','75','73',5),('1432','76','72',5),('1431','76','73',5),('1430','76','74',5),('1429','76','75',5),('1441','77','74',5),('1440','77','75',5),('1439','77','76',5);
/*!40000 ALTER TABLE `catalog_product_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute`;
CREATE TABLE `catalog_product_link_attribute` (
  `product_link_attribute_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Link Attribute ID',
  `link_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Link Type ID',
  `product_link_attribute_code` varchar(32) DEFAULT NULL COMMENT 'Product Link Attribute Code',
  `data_type` varchar(32) DEFAULT NULL COMMENT 'Data Type',
  PRIMARY KEY (`product_link_attribute_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_LINK_TYPE_ID` (`link_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Attribute Table';

--
-- Dumping data for table `catalog_product_link_attribute`
--

LOCK TABLES `catalog_product_link_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute` DISABLE KEYS */;
INSERT INTO `catalog_product_link_attribute` VALUES (1,1,'position','int'),(2,4,'position','int'),(3,5,'position','int'),(4,3,'position','int'),(5,3,'qty','decimal');
/*!40000 ALTER TABLE `catalog_product_link_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_decimal`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_decimal`;
CREATE TABLE `catalog_product_link_attribute_decimal` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Product Link Attribute ID',
  `link_id` int(10) unsigned NOT NULL COMMENT 'Link ID',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_DEC_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_DECIMAL_LINK_ID` (`link_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Decimal Attribute Table';

--
-- Dumping data for table `catalog_product_link_attribute_decimal`
--

LOCK TABLES `catalog_product_link_attribute_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_decimal` DISABLE KEYS */;
INSERT INTO `catalog_product_link_attribute_decimal` VALUES ('13',5,'802','9999.0000'),('14',5,'803','9999.0000');
/*!40000 ALTER TABLE `catalog_product_link_attribute_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_int`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_int`;
CREATE TABLE `catalog_product_link_attribute_int` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Product Link Attribute ID',
  `link_id` int(10) unsigned NOT NULL COMMENT 'Link ID',
  `value` int(11) NOT NULL DEFAULT '0' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_INT_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_INT_LINK_ID` (`link_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1442 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Integer Attribute Table';

--
-- Dumping data for table `catalog_product_link_attribute_int`
--

LOCK TABLES `catalog_product_link_attribute_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_int` DISABLE KEYS */;
INSERT INTO `catalog_product_link_attribute_int` VALUES ('766',1,'766','1'),('767',1,'767','2'),('768',1,'768','3'),('769',1,'769','4'),('770',2,'770','1'),('771',2,'771','2'),('772',2,'772','3'),('773',2,'773','4'),('774',3,'774','1'),('775',3,'775','2'),('776',3,'776','3'),('777',3,'777','4'),('778',1,'778','1'),('779',1,'779','2'),('780',1,'780','3'),('781',1,'781','4'),('782',2,'782','1'),('783',2,'783','2'),('784',2,'784','3'),('785',2,'785','4'),('786',3,'786','1'),('787',3,'787','2'),('788',3,'788','3'),('789',3,'789','4'),('790',1,'790','1'),('791',1,'791','2'),('792',1,'792','3'),('793',1,'793','4'),('794',2,'794','1'),('795',2,'795','2'),('796',2,'796','3'),('797',2,'797','4'),('798',3,'798','1'),('799',3,'799','2'),('800',3,'800','3'),('801',3,'801','4'),('802',4,'802','1'),('803',4,'803','2'),('804',1,'804','2'),('805',1,'805','1'),('806',1,'806','3'),('807',1,'807','4'),('808',1,'808','5'),('809',2,'809','1'),('810',2,'810','2'),('811',2,'811','3'),('812',2,'812','4'),('813',3,'813','1'),('814',3,'814','2'),('815',3,'815','3'),('816',3,'816','4'),('817',3,'817','5'),('818',1,'818','1'),('819',1,'819','2'),('820',1,'820','3'),('821',2,'821','1'),('822',2,'822','2'),('823',2,'823','3'),('824',3,'824','1'),('825',3,'825','2'),('826',3,'826','3'),('827',1,'827','1'),('828',1,'828','2'),('829',1,'829','3'),('830',1,'830','4'),('831',2,'831','1'),('832',2,'832','2'),('833',2,'833','3'),('834',2,'834','4'),('835',3,'835','1'),('836',3,'836','2'),('837',3,'837','3'),('838',3,'838','4'),('839',1,'839','1'),('840',1,'840','2'),('841',2,'841','1'),('842',2,'842','2'),('843',2,'843','3'),('844',3,'844','1'),('845',3,'845','2'),('846',3,'846','3'),('847',1,'847','1'),('848',1,'848','2'),('849',1,'849','3'),('850',1,'850','4'),('851',2,'851','1'),('852',2,'852','2'),('853',2,'853','3'),('854',2,'854','4'),('855',3,'855','1'),('856',3,'856','2'),('857',3,'857','3'),('858',3,'858','4'),('859',1,'859','1'),('860',1,'860','2'),('861',1,'861','3'),('862',1,'862','4'),('863',1,'863','5'),('864',2,'864','1'),('865',2,'865','2'),('866',2,'866','3'),('867',2,'867','4'),('868',2,'868','5'),('869',3,'869','1'),('870',3,'870','2'),('871',3,'871','3'),('872',3,'872','4'),('873',3,'873','5'),('874',1,'874','1'),('875',1,'875','2'),('876',1,'876','3'),('877',1,'877','4'),('878',2,'878','1'),('879',2,'879','2'),('880',2,'880','3'),('881',2,'881','4'),('882',2,'882','5'),('883',2,'883','6'),('884',3,'884','2'),('885',3,'885','1'),('886',3,'886','3'),('887',3,'887','4'),('888',3,'888','5'),('889',3,'889','6'),('890',1,'890','1'),('891',1,'891','2'),('892',1,'892','3'),('893',1,'893','4'),('894',2,'894','1'),('895',2,'895','2'),('896',2,'896','3'),('897',2,'897','4'),('898',3,'898','1'),('899',3,'899','2'),('900',3,'900','3'),('901',3,'901','4'),('902',1,'902','6'),('903',1,'903','7'),('904',1,'904','8'),('905',1,'905','9'),('906',2,'906','1'),('907',2,'907','2'),('908',2,'908','3'),('909',2,'909','4'),('910',3,'910','1'),('911',3,'911','4'),('912',3,'912','5'),('913',3,'913','6'),('914',1,'914','1'),('915',1,'915','2'),('916',1,'916','3'),('917',1,'917','4'),('918',1,'918','6'),('919',1,'919','5'),('920',2,'920','2'),('921',2,'921','1'),('922',2,'922','3'),('923',2,'923','4'),('924',2,'924','5'),('925',2,'925','6'),('926',3,'926','1'),('927',3,'927','2'),('928',3,'928','3'),('929',3,'929','4'),('930',3,'930','5'),('931',3,'931','6'),('932',1,'932','1'),('933',1,'933','2'),('934',1,'934','3'),('935',1,'935','4'),('936',2,'936','1'),('937',2,'937','2'),('938',2,'938','5'),('939',2,'939','6'),('940',3,'940','1'),('941',3,'941','2'),('942',3,'942','3'),('943',3,'943','4'),('944',1,'944','1'),('945',1,'945','2'),('946',1,'946','3'),('947',1,'947','4'),('948',1,'948','5'),('949',1,'949','6'),('950',2,'950','1'),('951',2,'951','2'),('952',2,'952','4'),('953',2,'953','3'),('954',2,'954','5'),('955',2,'955','6'),('956',3,'956','1'),('957',3,'957','2'),('958',3,'958','3'),('959',3,'959','4'),('960',3,'960','5'),('961',3,'961','6'),('962',1,'962','1'),('963',1,'963','2'),('964',1,'964','4'),('965',1,'965','5'),('966',2,'966','1'),('967',2,'967','4'),('968',2,'968','5'),('969',2,'969','6'),('970',3,'970','1'),('971',3,'971','3'),('972',3,'972','4'),('973',3,'973','6'),('974',1,'974','1'),('975',1,'975','2'),('976',1,'976','5'),('977',1,'977','6'),('978',2,'978','1'),('979',2,'979','2'),('980',2,'980','3'),('981',2,'981','6'),('982',3,'982','1'),('983',3,'983','2'),('984',3,'984','3'),('985',3,'985','4'),('986',1,'986','1'),('987',1,'987','2'),('988',1,'988','3'),('989',2,'989','1'),('990',2,'990','2'),('991',2,'991','3'),('992',2,'992','4'),('993',3,'993','1'),('994',3,'994','2'),('995',3,'995','3'),('996',3,'996','4'),('1033',1,'1033','1'),('1034',1,'1034','2'),('1035',1,'1035','3'),('1036',1,'1036','4'),('1037',3,'1037','1'),('1038',3,'1038','2'),('1039',3,'1039','3'),('1040',3,'1040','4'),('1041',2,'1041','1'),('1042',2,'1042','2'),('1043',2,'1043','3'),('1044',2,'1044','4'),('1045',1,'1045','1'),('1046',1,'1046','2'),('1047',1,'1047','3'),('1048',1,'1048','4'),('1049',3,'1049','4'),('1050',3,'1050','3'),('1051',3,'1051','1'),('1052',3,'1052','2'),('1053',2,'1053','4'),('1054',2,'1054','3'),('1055',2,'1055','1'),('1056',2,'1056','2'),('1057',1,'1057','1'),('1058',1,'1058','2'),('1059',1,'1059','3'),('1060',1,'1060','4'),('1061',2,'1061','8'),('1062',2,'1062','9'),('1063',3,'1063','1'),('1064',3,'1064','2'),('1065',3,'1065','3'),('1066',3,'1066','4'),('1067',1,'1067','1'),('1068',1,'1068','2'),('1069',1,'1069','3'),('1070',1,'1070','4'),('1071',2,'1071','6'),('1072',2,'1072','7'),('1073',2,'1073','8'),('1074',2,'1074','9'),('1075',3,'1075','2'),('1076',3,'1076','3'),('1077',3,'1077','4'),('1078',3,'1078','5'),('1079',1,'1079','1'),('1080',1,'1080','2'),('1081',1,'1081','3'),('1082',1,'1082','4'),('1083',2,'1083','1'),('1084',2,'1084','2'),('1085',2,'1085','4'),('1086',2,'1086','3'),('1087',3,'1087','1'),('1088',3,'1088','2'),('1089',3,'1089','3'),('1090',3,'1090','4'),('1124',1,'1124','1'),('1125',1,'1125','2'),('1126',1,'1126','3'),('1127',1,'1127','4'),('1128',2,'1128','1'),('1129',2,'1129','2'),('1130',2,'1130','3'),('1131',2,'1131','4'),('1132',3,'1132','1'),('1133',3,'1133','2'),('1134',3,'1134','3'),('1135',1,'1135','1'),('1136',1,'1136','2'),('1137',1,'1137','3'),('1138',1,'1138','4'),('1139',2,'1139','1'),('1140',2,'1140','2'),('1141',2,'1141','3'),('1142',2,'1142','4'),('1143',3,'1143','3'),('1144',3,'1144','4'),('1145',3,'1145','5'),('1146',3,'1146','6'),('1147',1,'1147','1'),('1148',1,'1148','2'),('1149',1,'1149','3'),('1150',1,'1150','4'),('1151',2,'1151','1'),('1152',2,'1152','2'),('1153',2,'1153','3'),('1154',2,'1154','4'),('1155',3,'1155','1'),('1156',3,'1156','2'),('1157',3,'1157','3'),('1177',1,'1177','1'),('1178',1,'1178','2'),('1179',1,'1179','3'),('1180',3,'1180','1'),('1181',3,'1181','2'),('1182',3,'1182','3'),('1183',2,'1183','1'),('1184',2,'1184','2'),('1185',2,'1185','3'),('1186',1,'1186','4'),('1187',1,'1187','3'),('1188',1,'1188','2'),('1189',1,'1189','1'),('1190',3,'1190','1'),('1191',3,'1191','2'),('1192',2,'1192','1'),('1193',2,'1193','2'),('1194',2,'1194','3'),('1195',2,'1195','4'),('1196',1,'1196','1'),('1197',1,'1197','2'),('1198',1,'1198','3'),('1199',1,'1199','4'),('1200',2,'1200','1'),('1201',2,'1201','2'),('1202',2,'1202','3'),('1203',2,'1203','4'),('1204',3,'1204','1'),('1205',3,'1205','2'),('1206',3,'1206','3'),('1207',3,'1207','4'),('1208',1,'1208','1'),('1209',2,'1209','1'),('1210',3,'1210','1'),('1211',1,'1211','1'),('1212',1,'1212','2'),('1213',2,'1213','1'),('1214',2,'1214','2'),('1215',3,'1215','1'),('1216',3,'1216','2'),('1217',1,'1217','1'),('1218',1,'1218','2'),('1219',1,'1219','3'),('1220',2,'1220','1'),('1221',2,'1221','2'),('1222',2,'1222','3'),('1223',3,'1223','1'),('1224',3,'1224','2'),('1225',3,'1225','3'),('1226',1,'1226','1'),('1227',1,'1227','2'),('1228',1,'1228','3'),('1229',1,'1229','4'),('1230',2,'1230','1'),('1231',2,'1231','2'),('1232',2,'1232','3'),('1233',2,'1233','4'),('1234',3,'1234','1'),('1235',3,'1235','2'),('1236',3,'1236','3'),('1237',3,'1237','4'),('1238',1,'1238','1'),('1239',1,'1239','3'),('1240',1,'1240','4'),('1241',2,'1241','1'),('1242',2,'1242','2'),('1243',2,'1243','3'),('1244',2,'1244','4'),('1245',3,'1245','1'),('1246',3,'1246','2'),('1247',3,'1247','3'),('1248',3,'1248','4'),('1249',1,'1249','1'),('1250',1,'1250','2'),('1251',1,'1251','3'),('1252',1,'1252','4'),('1253',2,'1253','1'),('1254',2,'1254','2'),('1255',2,'1255','3'),('1256',2,'1256','4'),('1257',2,'1257','5'),('1258',3,'1258','1'),('1259',3,'1259','2'),('1260',3,'1260','3'),('1261',3,'1261','4'),('1262',1,'1262','1'),('1263',1,'1263','2'),('1264',1,'1264','3'),('1265',1,'1265','4'),('1266',1,'1266','5'),('1267',2,'1267','1'),('1268',2,'1268','2'),('1269',2,'1269','3'),('1270',3,'1270','1'),('1271',3,'1271','2'),('1272',3,'1272','3'),('1273',1,'1273','1'),('1274',1,'1274','2'),('1275',1,'1275','3'),('1276',1,'1276','4'),('1277',1,'1277','5'),('1278',2,'1278','1'),('1279',2,'1279','2'),('1280',2,'1280','3'),('1281',2,'1281','4'),('1282',3,'1282','1'),('1283',3,'1283','2'),('1284',3,'1284','3'),('1285',3,'1285','4'),('1286',1,'1286','1'),('1287',1,'1287','2'),('1288',1,'1288','3'),('1289',1,'1289','4'),('1290',2,'1290','1'),('1291',2,'1291','2'),('1292',2,'1292','3'),('1293',2,'1293','4'),('1294',3,'1294','1'),('1295',3,'1295','2'),('1296',3,'1296','3'),('1297',3,'1297','4'),('1298',1,'1298','1'),('1299',1,'1299','2'),('1300',1,'1300','3'),('1301',2,'1301','1'),('1302',2,'1302','2'),('1303',2,'1303','3'),('1304',2,'1304','4'),('1305',3,'1305','1'),('1306',3,'1306','2'),('1307',3,'1307','3'),('1308',3,'1308','4'),('1309',1,'1309','1'),('1310',1,'1310','2'),('1311',2,'1311','1'),('1312',2,'1312','2'),('1313',3,'1313','1'),('1314',3,'1314','2'),('1315',3,'1315','3'),('1316',1,'1316','1'),('1317',2,'1317','1'),('1318',3,'1318','1'),('1319',1,'1319','1'),('1320',1,'1320','2'),('1321',2,'1321','1'),('1322',2,'1322','2'),('1323',3,'1323','1'),('1324',3,'1324','2'),('1325',1,'1325','1'),('1326',1,'1326','2'),('1327',1,'1327','3'),('1328',2,'1328','1'),('1329',2,'1329','2'),('1330',2,'1330','3'),('1331',3,'1331','1'),('1332',3,'1332','2'),('1333',3,'1333','3'),('1334',1,'1334','1'),('1335',1,'1335','2'),('1336',1,'1336','3'),('1337',1,'1337','4'),('1338',2,'1338','1'),('1339',2,'1339','2'),('1340',2,'1340','3'),('1341',2,'1341','4'),('1342',3,'1342','1'),('1343',3,'1343','2'),('1344',3,'1344','3'),('1345',3,'1345','4'),('1346',1,'1346','1'),('1347',1,'1347','2'),('1348',1,'1348','3'),('1349',1,'1349','4'),('1350',2,'1350','1'),('1351',2,'1351','2'),('1352',2,'1352','3'),('1353',2,'1353','4'),('1354',2,'1354','5'),('1355',3,'1355','1'),('1356',3,'1356','2'),('1357',3,'1357','3'),('1358',3,'1358','4'),('1359',3,'1359','5'),('1360',1,'1360','1'),('1361',1,'1361','2'),('1362',1,'1362','3'),('1363',2,'1363','1'),('1364',2,'1364','2'),('1365',2,'1365','3'),('1366',3,'1366','1'),('1367',3,'1367','2'),('1368',3,'1368','3'),('1369',3,'1369','4'),('1370',1,'1370','1'),('1371',1,'1371','2'),('1372',1,'1372','3'),('1373',1,'1373','4'),('1374',2,'1374','1'),('1375',2,'1375','2'),('1376',2,'1376','3'),('1377',3,'1377','1'),('1378',3,'1378','2'),('1379',3,'1379','3'),('1380',1,'1380','1'),('1381',1,'1381','2'),('1382',1,'1382','3'),('1383',1,'1383','4'),('1384',2,'1384','1'),('1385',2,'1385','2'),('1386',2,'1386','3'),('1387',3,'1387','1'),('1388',3,'1388','2'),('1389',3,'1389','3'),('1390',1,'1390','1'),('1391',1,'1391','2'),('1392',1,'1392','3'),('1393',2,'1393','1'),('1394',2,'1394','2'),('1395',2,'1395','3'),('1396',2,'1396','4'),('1397',3,'1397','1'),('1398',3,'1398','2'),('1399',3,'1399','3'),('1400',1,'1400','1'),('1401',1,'1401','2'),('1402',1,'1402','3'),('1403',1,'1403','4'),('1404',2,'1404','1'),('1405',2,'1405','2'),('1406',2,'1406','3'),('1407',2,'1407','4'),('1408',3,'1408','1'),('1409',3,'1409','2'),('1410',3,'1410','3'),('1411',3,'1411','4'),('1412',1,'1412','1'),('1413',1,'1413','2'),('1414',1,'1414','3'),('1415',1,'1415','4'),('1416',2,'1416','1'),('1417',2,'1417','2'),('1418',2,'1418','3'),('1419',2,'1419','4'),('1420',3,'1420','1'),('1421',3,'1421','2'),('1422',3,'1422','3'),('1423',1,'1423','1'),('1424',1,'1424','2'),('1425',1,'1425','3'),('1426',2,'1426','1'),('1427',2,'1427','2'),('1428',2,'1428','3'),('1429',3,'1429','1'),('1430',3,'1430','2'),('1431',3,'1431','3'),('1432',3,'1432','4'),('1433',1,'1433','1'),('1434',1,'1434','2'),('1435',1,'1435','3'),('1436',2,'1436','1'),('1437',2,'1437','2'),('1438',2,'1438','3'),('1439',3,'1439','1'),('1440',3,'1440','2'),('1441',3,'1441','3');
/*!40000 ALTER TABLE `catalog_product_link_attribute_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_varchar`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_varchar`;
CREATE TABLE `catalog_product_link_attribute_varchar` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Link Attribute ID',
  `link_id` int(10) unsigned NOT NULL COMMENT 'Link ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_VCHR_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_VARCHAR_LINK_ID` (`link_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Varchar Attribute Table';

--
-- Table structure for table `catalog_product_link_type`
--

DROP TABLE IF EXISTS `catalog_product_link_type`;
CREATE TABLE `catalog_product_link_type` (
  `link_type_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link Type ID',
  `code` varchar(32) DEFAULT NULL COMMENT 'Code',
  PRIMARY KEY (`link_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Type Table';

--
-- Dumping data for table `catalog_product_link_type`
--

LOCK TABLES `catalog_product_link_type` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_type` DISABLE KEYS */;
INSERT INTO `catalog_product_link_type` VALUES (1,'relation'),(3,'super'),(4,'up_sell'),(5,'cross_sell');
/*!40000 ALTER TABLE `catalog_product_link_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option`
--

DROP TABLE IF EXISTS `catalog_product_option`;
CREATE TABLE `catalog_product_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `type` varchar(50) DEFAULT NULL COMMENT 'Type',
  `is_require` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Is Required',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `max_characters` int(10) unsigned DEFAULT NULL COMMENT 'Max Characters',
  `file_extension` varchar(50) DEFAULT NULL COMMENT 'File Extension',
  `image_size_x` smallint(5) unsigned DEFAULT NULL COMMENT 'Image Size X',
  `image_size_y` smallint(5) unsigned DEFAULT NULL COMMENT 'Image Size Y',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_OPTION_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Table';

--
-- Table structure for table `catalog_product_option_price`
--

DROP TABLE IF EXISTS `catalog_product_option_price`;
CREATE TABLE `catalog_product_option_price` (
  `option_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Price ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Price',
  `price_type` varchar(7) NOT NULL DEFAULT 'fixed' COMMENT 'Price Type',
  PRIMARY KEY (`option_price_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_PRICE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_PRICE_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Price Table';

--
-- Table structure for table `catalog_product_option_title`
--

DROP TABLE IF EXISTS `catalog_product_option_title`;
CREATE TABLE `catalog_product_option_title` (
  `option_title_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Title ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`option_title_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TITLE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TITLE_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Title Table';

--
-- Table structure for table `catalog_product_option_type_price`
--

DROP TABLE IF EXISTS `catalog_product_option_type_price`;
CREATE TABLE `catalog_product_option_type_price` (
  `option_type_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type Price ID',
  `option_type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Type ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Price',
  `price_type` varchar(7) NOT NULL DEFAULT 'fixed' COMMENT 'Price Type',
  PRIMARY KEY (`option_type_price_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION_TYPE_ID_STORE_ID` (`option_type_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Type Price Table';

--
-- Table structure for table `catalog_product_option_type_title`
--

DROP TABLE IF EXISTS `catalog_product_option_type_title`;
CREATE TABLE `catalog_product_option_type_title` (
  `option_type_title_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type Title ID',
  `option_type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Type ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`option_type_title_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION_TYPE_ID_STORE_ID` (`option_type_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Type Title Table';

--
-- Table structure for table `catalog_product_option_type_value`
--

DROP TABLE IF EXISTS `catalog_product_option_type_value`;
CREATE TABLE `catalog_product_option_type_value` (
  `option_type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_type_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_VALUE_OPTION_ID` (`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Type Value Table';

--
-- Table structure for table `catalog_product_relation`
--

DROP TABLE IF EXISTS `catalog_product_relation`;
CREATE TABLE `catalog_product_relation` (
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int(10) unsigned NOT NULL COMMENT 'Child ID',
  PRIMARY KEY (`parent_id`,`child_id`),
  KEY `CATALOG_PRODUCT_RELATION_CHILD_ID` (`child_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Relation Table';

--
-- Dumping data for table `catalog_product_relation`
--

LOCK TABLES `catalog_product_relation` WRITE;
/*!40000 ALTER TABLE `catalog_product_relation` DISABLE KEYS */;
INSERT INTO `catalog_product_relation` VALUES ('2','7'),('2','22'),('9','1'),('9','7'),('10','1'),('10','7'),('32','30'),('32','31'),('50','48'),('50','49');
/*!40000 ALTER TABLE `catalog_product_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute`;
CREATE TABLE `catalog_product_super_attribute` (
  `product_super_attribute_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Super Attribute ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `position` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`product_super_attribute_id`),
  UNIQUE KEY `CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRODUCT_ID_ATTRIBUTE_ID` (`product_id`,`attribute_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Super Attribute Table';

--
-- Dumping data for table `catalog_product_super_attribute`
--

LOCK TABLES `catalog_product_super_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute` DISABLE KEYS */;
INSERT INTO `catalog_product_super_attribute` VALUES ('13','2',93,0),('14','32',93,0),('15','50',93,0);
/*!40000 ALTER TABLE `catalog_product_super_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute_label`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute_label`;
CREATE TABLE `catalog_product_super_attribute_label` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_super_attribute_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Super Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `use_default` smallint(5) unsigned DEFAULT '0' COMMENT 'Use Default Value',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_SPR_ATTR_LBL_PRD_SPR_ATTR_ID_STORE_ID` (`product_super_attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_SUPER_ATTRIBUTE_LABEL_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Super Attribute Label Table';

--
-- Dumping data for table `catalog_product_super_attribute_label`
--

LOCK TABLES `catalog_product_super_attribute_label` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute_label` DISABLE KEYS */;
INSERT INTO `catalog_product_super_attribute_label` VALUES ('13','13',0,0,'Color'),('14','14',0,0,'Color'),('15','15',0,0,'Color');
/*!40000 ALTER TABLE `catalog_product_super_attribute_label` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_link`
--

DROP TABLE IF EXISTS `catalog_product_super_link`;
CREATE TABLE `catalog_product_super_link` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent ID',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `CATALOG_PRODUCT_SUPER_LINK_PRODUCT_ID_PARENT_ID` (`product_id`,`parent_id`),
  KEY `CATALOG_PRODUCT_SUPER_LINK_PARENT_ID` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Super Link Table';

--
-- Dumping data for table `catalog_product_super_link`
--

LOCK TABLES `catalog_product_super_link` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_link` DISABLE KEYS */;
INSERT INTO `catalog_product_super_link` VALUES ('25','7','2'),('26','22','2'),('27','30','32'),('28','31','32'),('29','48','50'),('30','49','50');
/*!40000 ALTER TABLE `catalog_product_super_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_website`
--

DROP TABLE IF EXISTS `catalog_product_website`;
CREATE TABLE `catalog_product_website` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`product_id`,`website_id`),
  KEY `CATALOG_PRODUCT_WEBSITE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Website Linkage Table';

--
-- Dumping data for table `catalog_product_website`
--

LOCK TABLES `catalog_product_website` WRITE;
/*!40000 ALTER TABLE `catalog_product_website` DISABLE KEYS */;
INSERT INTO `catalog_product_website` VALUES ('1',1),('2',1),('7',1),('9',1),('10',1),('17',1),('18',1),('19',1),('20',1),('21',1),('22',1),('23',1),('24',1),('25',1),('26',1),('27',1),('28',1),('29',1),('30',1),('31',1),('32',1),('33',1),('34',1),('35',1),('36',1),('37',1),('48',1),('49',1),('50',1),('51',1),('52',1),('53',1),('54',1),('55',1),('56',1),('57',1),('58',1),('59',1),('60',1),('61',1),('62',1),('63',1),('64',1),('65',1),('67',1),('68',1),('69',1),('70',1),('71',1),('72',1),('73',1),('74',1),('75',1),('76',1),('77',1);
/*!40000 ALTER TABLE `catalog_product_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_url_rewrite_product_category`
--

DROP TABLE IF EXISTS `catalog_url_rewrite_product_category`;
CREATE TABLE `catalog_url_rewrite_product_category` (
  `url_rewrite_id` int(10) unsigned NOT NULL COMMENT 'url_rewrite_id',
  `category_id` int(10) unsigned NOT NULL COMMENT 'category_id',
  `product_id` int(10) unsigned NOT NULL COMMENT 'product_id',
  KEY `CATALOG_URL_REWRITE_PRODUCT_CATEGORY_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `CAT_URL_REWRITE_PRD_CTGR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` (`product_id`),
  KEY `FK_BB79E64705D7F17FE181F23144528FC8` (`url_rewrite_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='url_rewrite_relation';

--
-- Dumping data for table `catalog_url_rewrite_product_category`
--

LOCK TABLES `catalog_url_rewrite_product_category` WRITE;
/*!40000 ALTER TABLE `catalog_url_rewrite_product_category` DISABLE KEYS */;
INSERT INTO `catalog_url_rewrite_product_category` VALUES ('11047','2','1'),('11046','204','1'),('11041','148','1'),('11045','203','1'),('11042','188','1'),('11040','147','1'),('11043','189','1'),('11044','190','1'),('11101','2','2'),('11095','148','2'),('11100','204','2'),('11099','203','2'),('11096','188','2'),('11094','147','2'),('11097','189','2'),('11098','190','2'),('11153','2','7'),('11152','204','7'),('11149','148','7'),('11150','188','7'),('11148','147','7'),('11151','189','7'),('11202','2','9'),('11196','204','9'),('11191','148','9'),('11195','203','9'),('11199','193','9'),('11197','191','9'),('11198','192','9'),('11192','188','9'),('11200','195','9'),('11201','196','9'),('11193','189','9'),('11194','190','9'),('11190','147','9'),('11290','2','10'),('11289','210','10'),('11288','209','10'),('11280','204','10'),('11275','148','10'),('11287','207','10'),('11286','205','10'),('11279','203','10'),('11281','191','10'),('11276','188','10'),('11282','195','10'),('11283','196','10'),('11277','189','10'),('11284','199','10'),('11285','200','10'),('11278','190','10'),('11274','147','10'),('11398','2','17'),('11383','148','17'),('11388','204','17'),('11396','210','17'),('11397','211','17'),('11395','209','17'),('11387','203','17'),('11394','206','17'),('11393','205','17'),('11384','188','17'),('11389','191','17'),('11390','192','17'),('11382','147','17'),('11385','189','17'),('11391','195','17'),('11392','197','17'),('11386','190','17'),('11504','2','18'),('11496','204','18'),('11491','148','18'),('11503','206','18'),('11502','205','18'),('11495','203','18'),('11497','192','18'),('11492','188','18'),('11498','195','18'),('11499','196','18'),('11493','189','18'),('11500','199','18'),('11501','200','18'),('11494','190','18'),('11490','147','18'),('11600','2','19'),('11587','148','19'),('11592','204','19'),('11599','210','19'),('11598','209','19'),('11597','207','19'),('11591','203','19'),('11596','206','19'),('11595','205','19'),('11588','188','19'),('11593','191','19'),('11594','192','19'),('11586','147','19'),('11589','189','19'),('11590','190','19'),('11691','2','20'),('11688','204','20'),('11687','203','20'),('11682','148','20'),('11690','193','20'),('11689','191','20'),('11684','188','20'),('11685','189','20'),('11686','190','20'),('11683','147','20'),('11758','2','21'),('11757','209','21'),('11754','204','21'),('11749','148','21'),('11756','205','21'),('11753','203','21'),('11755','191','21'),('11750','188','21'),('11751','189','21'),('11748','147','21'),('11752','190','21'),('11832','2','22'),('11826','204','22'),('11821','148','22'),('11825','203','22'),('11829','193','22'),('11827','191','22'),('11828','192','22'),('11822','188','22'),('11820','147','22'),('11830','195','22'),('11823','189','22'),('11831','196','22'),('11824','190','22'),('11916','2','23'),('11905','148','23'),('11910','204','23'),('11909','203','23'),('11915','205','23'),('11906','188','23'),('11911','191','23'),('11904','147','23'),('11907','189','23'),('11912','197','23'),('11908','190','23'),('11913','199','23'),('11914','200','23'),('11997','2','24'),('11994','204','24'),('11989','148','24'),('11993','203','24'),('11990','188','24'),('11995','191','24'),('11996','192','24'),('11988','147','24'),('11991','189','24'),('11992','190','24'),('12064','2','25'),('12060','204','25'),('12059','203','25'),('12055','148','25'),('12061','191','25'),('12056','188','25'),('12062','195','25'),('12057','189','25'),('12063','199','25'),('12058','190','25'),('12054','147','25'),('12133','2','26'),('12127','148','26'),('12132','204','26'),('12131','203','26'),('12128','188','26'),('12126','147','26'),('12129','189','26'),('12130','190','26'),('12193','2','27'),('12192','210','27'),('12191','209','27'),('12186','204','27'),('12181','148','27'),('12190','208','27'),('12189','205','27'),('12185','203','27'),('12188','194','27'),('12187','191','27'),('12182','188','27'),('12183','189','27'),('12184','190','27'),('12180','147','27'),('12274','2','28'),('12271','148','28'),('12272','188','28'),('12270','147','28'),('12273','189','28'),('12310','147','1'),('12311','148','1'),('12312','188','1'),('12313','189','1'),('12314','190','1'),('12315','203','1'),('12316','204','1'),('12317','2','1'),('12319','147','2'),('12320','148','2'),('12321','188','2'),('12322','189','2'),('12323','190','2'),('12324','203','2'),('12325','204','2'),('12326','2','2'),('12328','147','7'),('12329','148','7'),('12330','188','7'),('12331','189','7'),('12332','204','7'),('12333','2','7'),('12335','147','9'),('12336','148','9'),('12337','188','9'),('12338','189','9'),('12339','190','9'),('12340','203','9'),('12341','204','9'),('12342','191','9'),('12343','192','9'),('12344','193','9'),('12345','195','9'),('12346','196','9'),('12347','2','9'),('12349','147','10'),('12350','148','10'),('12351','188','10'),('12352','189','10'),('12353','190','10'),('12354','203','10'),('12355','204','10'),('12356','191','10'),('12357','195','10'),('12358','196','10'),('12359','199','10'),('12360','200','10'),('12361','205','10'),('12362','207','10'),('12363','209','10'),('12364','210','10'),('12365','2','10'),('12367','147','17'),('12368','148','17'),('12369','188','17'),('12370','189','17'),('12371','190','17'),('12372','203','17'),('12373','204','17'),('12374','191','17'),('12375','192','17'),('12376','195','17'),('12377','197','17'),('12378','205','17'),('12379','206','17'),('12380','209','17'),('12381','210','17'),('12382','211','17'),('12383','2','17'),('12385','147','18'),('12386','148','18'),('12387','188','18'),('12388','189','18'),('12389','190','18'),('12390','203','18'),('12391','204','18'),('12392','192','18'),('12393','195','18'),('12394','196','18'),('12395','199','18'),('12396','200','18'),('12397','205','18'),('12398','206','18'),('12399','2','18'),('12401','147','19'),('12402','148','19'),('12403','188','19'),('12404','189','19'),('12405','190','19'),('12406','203','19'),('12407','204','19'),('12408','191','19'),('12409','192','19'),('12410','205','19'),('12411','206','19'),('12412','207','19'),('12413','209','19'),('12414','210','19'),('12415','2','19'),('12417','148','20'),('12418','147','20'),('12419','188','20'),('12420','189','20'),('12421','190','20'),('12422','203','20'),('12423','204','20'),('12424','191','20'),('12425','193','20'),('12426','2','20'),('12428','147','21'),('12429','148','21'),('12430','188','21'),('12431','189','21'),('12432','190','21'),('12433','203','21'),('12434','204','21'),('12435','191','21'),('12436','205','21'),('12437','209','21'),('12438','2','21'),('12440','147','22'),('12441','148','22'),('12442','188','22'),('12443','189','22'),('12444','190','22'),('12445','203','22'),('12446','204','22'),('12447','191','22'),('12448','192','22'),('12449','193','22'),('12450','195','22'),('12451','196','22'),('12452','2','22'),('12454','147','23'),('12455','148','23'),('12456','188','23'),('12457','189','23'),('12458','190','23'),('12459','203','23'),('12460','204','23'),('12461','191','23'),('12462','197','23'),('12463','199','23'),('12464','200','23'),('12465','205','23'),('12466','2','23'),('12468','147','24'),('12469','148','24'),('12470','188','24'),('12471','189','24'),('12472','190','24'),('12473','203','24'),('12474','204','24'),('12475','191','24'),('12476','192','24'),('12477','2','24'),('12479','147','25'),('12480','148','25'),('12481','188','25'),('12482','189','25'),('12483','190','25'),('12484','203','25'),('12485','204','25'),('12486','191','25'),('12487','195','25'),('12488','199','25'),('12489','2','25'),('12491','147','26'),('12492','148','26'),('12493','188','26'),('12494','189','26'),('12495','190','26'),('12496','203','26'),('12497','204','26'),('12498','2','26'),('12500','147','27'),('12501','148','27'),('12502','188','27'),('12503','189','27'),('12504','190','27'),('12505','203','27'),('12506','204','27'),('12507','191','27'),('12508','194','27'),('12509','205','27'),('12510','208','27'),('12511','209','27'),('12512','210','27'),('12513','2','27'),('12515','147','28'),('12516','148','28'),('12517','188','28'),('12518','189','28'),('12519','2','28'),('12594','213','29'),('12591','234','29'),('12590','232','29'),('12585','215','29'),('12587','217','29'),('12584','214','29'),('12589','219','29'),('12588','218','29'),('12586','216','29'),('12593','248','29'),('12592','247','29'),('12610','213','30'),('12606','232','30'),('12607','233','30'),('12602','215','30'),('12605','219','30'),('12601','214','30'),('12604','218','30'),('12609','248','30'),('12603','216','30'),('12608','247','30'),('12627','213','31'),('12623','232','31'),('12624','233','31'),('12618','215','31'),('12620','217','31'),('12622','219','31'),('12617','214','31'),('12621','218','31'),('12626','248','31'),('12619','216','31'),('12625','247','31'),('12641','213','32'),('12639','232','32'),('12640','233','32'),('12635','215','32'),('12638','219','32'),('12637','218','32'),('12634','214','32'),('12636','216','32'),('12655','213','33'),('12653','232','33'),('12654','233','33'),('12649','215','33'),('12651','217','33'),('12648','214','33'),('12652','218','33'),('12650','216','33'),('12669','213','34'),('12667','233','34'),('12663','215','34'),('12666','219','34'),('12662','214','34'),('12665','218','34'),('12668','248','34'),('12664','216','34'),('12684','213','35'),('12677','215','35'),('12682','234','35'),('12681','233','35'),('12676','214','35'),('12680','219','35'),('12679','218','35'),('12678','216','35'),('12683','247','35'),('12699','213','36'),('12696','232','36'),('12697','233','36'),('12692','215','36'),('12691','214','36'),('12695','219','36'),('12694','218','36'),('12693','216','36'),('12698','247','36'),('12715','213','37'),('12712','234','37'),('12711','233','37'),('12707','215','37'),('12709','217','37'),('12710','218','37'),('12706','214','37'),('12714','248','37'),('12713','247','37'),('12708','216','37'),('12730','213','48'),('12727','232','48'),('12728','233','48'),('12723','215','48'),('12725','217','48'),('12726','219','48'),('12722','214','48'),('12724','216','48'),('12729','247','48'),('12742','213','49'),('12741','232','49'),('12738','215','49'),('12740','217','49'),('12737','214','49'),('12739','216','49'),('12756','213','50'),('12750','215','50'),('12754','233','50'),('12749','214','50'),('12752','217','50'),('12753','218','50'),('12751','216','50'),('12755','247','50'),('12767','147','1'),('12768','148','1'),('12769','188','1'),('12770','189','1'),('12771','190','1'),('12772','203','1'),('12773','204','1'),('12774','2','1'),('12776','147','2'),('12777','148','2'),('12778','188','2'),('12779','189','2'),('12780','190','2'),('12781','203','2'),('12782','204','2'),('12783','2','2'),('12785','147','7'),('12786','148','7'),('12787','188','7'),('12788','189','7'),('12789','204','7'),('12790','2','7'),('12792','147','9'),('12793','148','9'),('12794','188','9'),('12795','189','9'),('12796','190','9'),('12797','203','9'),('12798','204','9'),('12799','191','9'),('12800','192','9'),('12801','193','9'),('12802','195','9'),('12803','196','9'),('12804','2','9'),('12806','147','10'),('12807','148','10'),('12808','188','10'),('12809','189','10'),('12810','190','10'),('12811','203','10'),('12812','204','10'),('12813','191','10'),('12814','195','10'),('12815','196','10'),('12816','199','10'),('12817','200','10'),('12818','205','10'),('12819','207','10'),('12820','209','10'),('12821','210','10'),('12822','2','10'),('12824','147','17'),('12825','148','17'),('12826','188','17'),('12827','189','17'),('12828','190','17'),('12829','203','17'),('12830','204','17'),('12831','191','17'),('12832','192','17'),('12833','195','17'),('12834','197','17'),('12835','205','17'),('12836','206','17'),('12837','209','17'),('12838','210','17'),('12839','211','17'),('12840','2','17'),('12842','147','18'),('12843','148','18'),('12844','188','18'),('12845','189','18'),('12846','190','18'),('12847','203','18'),('12848','204','18'),('12849','192','18'),('12850','195','18'),('12851','196','18'),('12852','199','18'),('12853','200','18'),('12854','205','18'),('12855','206','18'),('12856','2','18'),('12858','147','19'),('12859','148','19'),('12860','188','19'),('12861','189','19'),('12862','190','19'),('12863','203','19'),('12864','204','19'),('12865','191','19'),('12866','192','19'),('12867','205','19'),('12868','206','19'),('12869','207','19'),('12870','209','19'),('12871','210','19'),('12872','2','19'),('12874','148','20'),('12875','147','20'),('12876','188','20'),('12877','189','20'),('12878','190','20'),('12879','203','20'),('12880','204','20'),('12881','191','20'),('12882','193','20'),('12883','2','20'),('12885','147','21'),('12886','148','21'),('12887','188','21'),('12888','189','21'),('12889','190','21'),('12890','203','21'),('12891','204','21'),('12892','191','21'),('12893','205','21'),('12894','209','21'),('12895','2','21'),('12897','147','22'),('12898','148','22'),('12899','188','22'),('12900','189','22'),('12901','190','22'),('12902','203','22'),('12903','204','22'),('12904','191','22'),('12905','192','22'),('12906','193','22'),('12907','195','22'),('12908','196','22'),('12909','2','22'),('12911','147','23'),('12912','148','23'),('12913','188','23'),('12914','189','23'),('12915','190','23'),('12916','203','23'),('12917','204','23'),('12918','191','23'),('12919','197','23'),('12920','199','23'),('12921','200','23'),('12922','205','23'),('12923','2','23'),('12925','147','24'),('12926','148','24'),('12927','188','24'),('12928','189','24'),('12929','190','24'),('12930','203','24'),('12931','204','24'),('12932','191','24'),('12933','192','24'),('12934','2','24'),('12936','147','25'),('12937','148','25'),('12938','188','25'),('12939','189','25'),('12940','190','25'),('12941','203','25'),('12942','204','25'),('12943','191','25'),('12944','195','25'),('12945','199','25'),('12946','2','25'),('12948','147','26'),('12949','148','26'),('12950','188','26'),('12951','189','26'),('12952','190','26'),('12953','203','26'),('12954','204','26'),('12955','2','26'),('12957','147','27'),('12958','148','27'),('12959','188','27'),('12960','189','27'),('12961','190','27'),('12962','203','27'),('12963','204','27'),('12964','191','27'),('12965','194','27'),('12966','205','27'),('12967','208','27'),('12968','209','27'),('12969','210','27'),('12970','2','27'),('12972','147','28'),('12973','148','28'),('12974','188','28'),('12975','189','28'),('12976','2','28'),('13220','255','62'),('13218','258','62'),('13216','256','62'),('13217','257','62'),('13260','255','52'),('13258','293','52'),('13252','258','52'),('13259','294','52'),('13250','256','52'),('13254','260','52'),('13257','280','52'),('13251','257','52'),('13255','278','52'),('13256','279','52'),('13479','255','56'),('13447','255','54'),('13546','255','60'),('13496','255','57'),('13513','255','58'),('13472','258','56'),('13439','258','54'),('13477','293','56'),('13445','293','54'),('13544','293','60'),('13494','293','57'),('13511','293','58'),('13538','258','60'),('13478','294','56'),('13446','294','54'),('13545','294','60'),('13495','294','57'),('13512','294','58'),('13488','258','57'),('13505','258','58'),('13470','256','56'),('13475','261','56'),('13442','261','54'),('13541','261','60'),('13491','261','57'),('13508','261','58'),('13437','256','54'),('13536','256','60'),('13486','256','57'),('13474','260','56'),('13441','260','54'),('13540','260','60'),('13490','260','57'),('13507','260','58'),('13503','256','58'),('13471','257','56'),('13438','257','54'),('13543','280','60'),('13537','257','60'),('13487','257','57'),('13443','278','54'),('13492','278','57'),('13509','278','58'),('13476','279','56'),('13444','279','54'),('13542','279','60'),('13493','279','57'),('13510','279','58'),('13504','257','58'),('13583','255','51'),('13600','255','53'),('13646','255','61'),('13632','255','59'),('13616','255','55'),('13575','258','51'),('13592','258','53'),('13598','293','53'),('13630','293','59'),('13641','258','61'),('13599','294','53'),('13631','294','59'),('13625','258','59'),('13609','258','55'),('13578','261','51'),('13644','261','61'),('13628','261','59'),('13612','261','55'),('13573','256','51'),('13590','256','53'),('13639','256','61'),('13623','256','59'),('13579','262','51'),('13595','262','53'),('13645','262','61'),('13629','262','59'),('13613','262','55'),('13607','256','55'),('13577','260','51'),('13594','260','53'),('13643','260','61'),('13627','260','59'),('13611','260','55'),('13574','257','51'),('13591','257','53'),('13582','280','51'),('13597','280','53'),('13640','257','61'),('13624','257','59'),('13580','278','51'),('13614','278','55'),('13581','279','51'),('13596','279','53'),('13615','279','55'),('13608','257','55'),('13655','147','1'),('13656','148','1'),('13657','188','1'),('13658','189','1'),('13659','190','1'),('13660','203','1'),('13661','204','1'),('13662','2','1'),('13664','147','2'),('13665','148','2'),('13666','188','2'),('13667','189','2'),('13668','190','2'),('13669','203','2'),('13670','204','2'),('13671','2','2'),('13673','147','7'),('13674','148','7'),('13675','188','7'),('13676','189','7'),('13677','204','7'),('13678','2','7'),('13680','147','9'),('13681','148','9'),('13682','188','9'),('13683','189','9'),('13684','190','9'),('13685','203','9'),('13686','204','9'),('13687','191','9'),('13688','192','9'),('13689','193','9'),('13690','195','9'),('13691','196','9'),('13692','2','9'),('13694','147','10'),('13695','148','10'),('13696','188','10'),('13697','189','10'),('13698','190','10'),('13699','203','10'),('13700','204','10'),('13701','191','10'),('13702','195','10'),('13703','196','10'),('13704','199','10'),('13705','200','10'),('13706','205','10'),('13707','207','10'),('13708','209','10'),('13709','210','10'),('13710','2','10'),('13712','147','17'),('13713','148','17'),('13714','188','17'),('13715','189','17'),('13716','190','17'),('13717','203','17'),('13718','204','17'),('13719','191','17'),('13720','192','17'),('13721','195','17'),('13722','197','17'),('13723','205','17'),('13724','206','17'),('13725','209','17'),('13726','210','17'),('13727','211','17'),('13728','2','17'),('13730','147','18'),('13731','148','18'),('13732','188','18'),('13733','189','18'),('13734','190','18'),('13735','203','18'),('13736','204','18'),('13737','192','18'),('13738','195','18'),('13739','196','18'),('13740','199','18'),('13741','200','18'),('13742','205','18'),('13743','206','18'),('13744','2','18'),('13746','147','19'),('13747','148','19'),('13748','188','19'),('13749','189','19'),('13750','190','19'),('13751','203','19'),('13752','204','19'),('13753','191','19'),('13754','192','19'),('13755','205','19'),('13756','206','19'),('13757','207','19'),('13758','209','19'),('13759','210','19'),('13760','2','19'),('13762','148','20'),('13763','147','20'),('13764','188','20'),('13765','189','20'),('13766','190','20'),('13767','203','20'),('13768','204','20'),('13769','191','20'),('13770','193','20'),('13771','2','20'),('13773','147','21'),('13774','148','21'),('13775','188','21'),('13776','189','21'),('13777','190','21'),('13778','203','21'),('13779','204','21'),('13780','191','21'),('13781','205','21'),('13782','209','21'),('13783','2','21'),('13785','147','22'),('13786','148','22'),('13787','188','22'),('13788','189','22'),('13789','190','22'),('13790','203','22'),('13791','204','22'),('13792','191','22'),('13793','192','22'),('13794','193','22'),('13795','195','22'),('13796','196','22'),('13797','2','22'),('13799','147','23'),('13800','148','23'),('13801','188','23'),('13802','189','23'),('13803','190','23'),('13804','203','23'),('13805','204','23'),('13806','191','23'),('13807','197','23'),('13808','199','23'),('13809','200','23'),('13810','205','23'),('13811','2','23'),('13813','147','24'),('13814','148','24'),('13815','188','24'),('13816','189','24'),('13817','190','24'),('13818','203','24'),('13819','204','24'),('13820','191','24'),('13821','192','24'),('13822','2','24'),('13824','147','25'),('13825','148','25'),('13826','188','25'),('13827','189','25'),('13828','190','25'),('13829','203','25'),('13830','204','25'),('13831','191','25'),('13832','195','25'),('13833','199','25'),('13834','2','25'),('13836','147','26'),('13837','148','26'),('13838','188','26'),('13839','189','26'),('13840','190','26'),('13841','203','26'),('13842','204','26'),('13843','2','26'),('13845','147','27'),('13846','148','27'),('13847','188','27'),('13848','189','27'),('13849','190','27'),('13850','203','27'),('13851','204','27'),('13852','191','27'),('13853','194','27'),('13854','205','27'),('13855','208','27'),('13856','209','27'),('13857','210','27'),('13858','2','27'),('13860','147','28'),('13861','148','28'),('13862','188','28'),('13863','189','28'),('13864','2','28'),('14922','304','75'),('14923','305','75'),('14924','306','75'),('14925','308','75'),('14926','309','75'),('14927','310','75'),('14928','324','75'),('14929','328','75'),('14930','329','75'),('14931','303','75'),('14972','304','63'),('14973','305','63'),('14974','306','63'),('14975','307','63'),('14976','308','63'),('14977','309','63'),('14978','310','63'),('14979','311','63'),('14980','303','63'),('14987','304','64'),('14988','305','64'),('14989','306','64'),('14990','307','64'),('14991','308','64'),('14992','309','64'),('14993','310','64'),('14994','311','64'),('14995','318','64'),('14996','319','64'),('14997','303','64'),('15004','304','65'),('15005','305','65'),('15006','306','65'),('15007','307','65'),('15008','309','65'),('15009','310','65'),('15010','311','65'),('15011','315','65'),('15012','318','65'),('15013','319','65'),('15014','303','65'),('15021','304','67'),('15022','305','67'),('15023','306','67'),('15024','308','67'),('15025','309','67'),('15026','310','67'),('15027','311','67'),('15028','322','67'),('15029','324','67'),('15030','327','67'),('15031','329','67'),('15032','303','67'),('15039','304','68'),('15040','305','68'),('15041','306','68'),('15042','308','68'),('15043','309','68'),('15044','310','68'),('15045','311','68'),('15046','319','68'),('15047','327','68'),('15048','328','68'),('15049','303','68'),('15050','307','68'),('15057','304','69'),('15058','305','69'),('15059','306','69'),('15060','308','69'),('15061','309','69'),('15062','310','69'),('15063','311','69'),('15064','322','69'),('15065','303','69'),('15072','304','70'),('15073','305','70'),('15074','306','70'),('15075','308','70'),('15076','309','70'),('15077','310','70'),('15078','311','70'),('15079','315','70'),('15080','318','70'),('15081','321','70'),('15082','322','70'),('15083','324','70'),('15084','303','70'),('15085','307','70'),('15092','304','71'),('15093','305','71'),('15094','306','71'),('15095','309','71'),('15096','310','71'),('15097','311','71'),('15098','315','71'),('15099','316','71'),('15100','328','71'),('15101','329','71'),('15102','303','71'),('15109','304','72'),('15110','305','72'),('15111','306','72'),('15112','308','72'),('15113','309','72'),('15114','310','72'),('15115','311','72'),('15116','327','72'),('15117','328','72'),('15118','303','72'),('15125','304','73'),('15126','305','73'),('15127','306','73'),('15128','307','73'),('15129','308','73'),('15130','310','73'),('15131','311','73'),('15132','303','73'),('15139','304','74'),('15140','305','74'),('15141','306','74'),('15142','307','74'),('15143','308','74'),('15144','310','74'),('15145','311','74'),('15146','312','74'),('15147','313','74'),('15148','315','74'),('15149','316','74'),('15150','303','74'),('15157','304','76'),('15158','305','76'),('15159','306','76'),('15160','307','76'),('15161','308','76'),('15162','309','76'),('15163','310','76'),('15164','311','76'),('15165','303','76'),('15172','304','77'),('15173','305','77'),('15174','306','77'),('15175','307','77'),('15176','308','77'),('15177','309','77'),('15178','310','77'),('15179','311','77'),('15180','303','77');
/*!40000 ALTER TABLE `catalog_url_rewrite_product_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock`
--

DROP TABLE IF EXISTS `cataloginventory_stock`;
CREATE TABLE `cataloginventory_stock` (
  `stock_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Stock Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_name` varchar(255) DEFAULT NULL COMMENT 'Stock Name',
  PRIMARY KEY (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock';

--
-- Dumping data for table `cataloginventory_stock`
--

LOCK TABLES `cataloginventory_stock` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock` VALUES (1,0,'Default');
/*!40000 ALTER TABLE `cataloginventory_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_item`
--

DROP TABLE IF EXISTS `cataloginventory_stock_item`;
CREATE TABLE `cataloginventory_stock_item` (
  `item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Item Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `stock_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Stock Id',
  `qty` decimal(12,4) DEFAULT NULL COMMENT 'Qty',
  `min_qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Min Qty',
  `use_config_min_qty` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Min Qty',
  `is_qty_decimal` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Qty Decimal',
  `backorders` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Backorders',
  `use_config_backorders` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Backorders',
  `min_sale_qty` decimal(12,4) NOT NULL DEFAULT '1.0000' COMMENT 'Min Sale Qty',
  `use_config_min_sale_qty` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Min Sale Qty',
  `max_sale_qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Max Sale Qty',
  `use_config_max_sale_qty` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Max Sale Qty',
  `is_in_stock` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is In Stock',
  `low_stock_date` timestamp NULL DEFAULT NULL COMMENT 'Low Stock Date',
  `notify_stock_qty` decimal(12,4) DEFAULT NULL COMMENT 'Notify Stock Qty',
  `use_config_notify_stock_qty` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Notify Stock Qty',
  `manage_stock` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Manage Stock',
  `use_config_manage_stock` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Manage Stock',
  `stock_status_changed_auto` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Stock Status Changed Automatically',
  `use_config_qty_increments` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Qty Increments',
  `qty_increments` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty Increments',
  `use_config_enable_qty_inc` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Enable Qty Increments',
  `enable_qty_increments` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Enable Qty Increments',
  `is_decimal_divided` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Divided into Multiple Boxes for Shipping',
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Divided into Multiple Boxes for Shipping',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `CATALOGINVENTORY_STOCK_ITEM_PRODUCT_ID_WEBSITE_ID` (`product_id`,`website_id`),
  KEY `CATALOGINVENTORY_STOCK_ITEM_WEBSITE_ID` (`website_id`),
  KEY `CATALOGINVENTORY_STOCK_ITEM_STOCK_ID` (`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock Item';

--
-- Dumping data for table `cataloginventory_stock_item`
--

LOCK TABLES `cataloginventory_stock_item` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_item` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_item` VALUES ('1','1',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('2','2',1,'0.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('7','7',1,'9998.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('9','9',1,'0.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('10','10',1,'0.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('12','17',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('13','18',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('14','19',1,'9998.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('15','20',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('16','21',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('17','22',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('18','23',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('19','24',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('20','25',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('21','26',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('22','27',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('23','28',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('24','29',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('25','30',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('26','31',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('27','32',1,'0.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('28','33',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('29','34',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('30','35',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('31','36',1,'9998.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('32','37',1,'9998.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('43','48',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('44','49',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('45','50',1,'0.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('46','51',1,'99999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('47','52',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('48','53',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('49','54',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('50','55',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('51','56',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('52','57',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('53','58',1,NULL,'0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,0,'2016-12-06 16:09:17','1.0000',1,1,1,1,1,'1.0000',1,0,0,0),('54','59',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('55','60',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('56','61',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('57','62',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('58','63',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('59','64',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('60','65',1,'9998.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('61','67',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('62','68',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('63','69',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('64','70',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('65','71',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('66','72',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('67','73',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('68','74',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('69','75',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('70','76',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0),('71','77',1,'9999.0000','0.0000',1,0,0,1,'1.0000',1,'10000.0000',1,1,NULL,'1.0000',1,1,1,0,1,'1.0000',1,0,0,0);
/*!40000 ALTER TABLE `cataloginventory_stock_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status`;
CREATE TABLE `cataloginventory_stock_status` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint(5) unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock Status';

--
-- Dumping data for table `cataloginventory_stock_status`
--

LOCK TABLES `cataloginventory_stock_status` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_status` VALUES ('1',0,1,'9999.0000',1),('2',0,1,'0.0000',1),('7',0,1,'9998.0000',1),('9',0,1,'0.0000',1),('10',0,1,'0.0000',1),('17',0,1,'9999.0000',1),('18',0,1,'9999.0000',1),('19',0,1,'9998.0000',1),('20',0,1,'9999.0000',1),('21',0,1,'9999.0000',1),('22',0,1,'9999.0000',1),('23',0,1,'9999.0000',1),('24',0,1,'9999.0000',1),('25',0,1,'9999.0000',1),('26',0,1,'9999.0000',1),('27',0,1,'9999.0000',1),('28',0,1,'9999.0000',1),('29',0,1,'9999.0000',1),('30',0,1,'9999.0000',1),('31',0,1,'9999.0000',1),('32',0,1,'0.0000',1),('33',0,1,'9999.0000',1),('34',0,1,'9999.0000',1),('35',0,1,'9999.0000',1),('36',0,1,'9998.0000',1),('37',0,1,'9998.0000',1),('48',0,1,'9999.0000',1),('49',0,1,'9999.0000',1),('50',0,1,'0.0000',1),('51',0,1,'99999.0000',1),('52',0,1,'9999.0000',1),('53',0,1,'9999.0000',1),('54',0,1,'9999.0000',1),('55',0,1,'9999.0000',1),('56',0,1,'9999.0000',1),('57',0,1,'9999.0000',1),('58',0,1,'0.0000',0),('59',0,1,'9999.0000',1),('60',0,1,'9999.0000',1),('61',0,1,'9999.0000',1),('62',0,1,'9999.0000',1),('63',0,1,'9999.0000',1),('64',0,1,'9999.0000',1),('65',0,1,'9998.0000',1),('67',0,1,'9999.0000',1),('68',0,1,'9999.0000',1),('69',0,1,'9999.0000',1),('70',0,1,'9999.0000',1),('71',0,1,'9999.0000',1),('72',0,1,'9999.0000',1),('73',0,1,'9999.0000',1),('74',0,1,'9999.0000',1),('75',0,1,'9999.0000',1),('76',0,1,'9999.0000',1),('77',0,1,'9999.0000',1);
/*!40000 ALTER TABLE `cataloginventory_stock_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_idx`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_idx`;
CREATE TABLE `cataloginventory_stock_status_idx` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint(5) unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_IDX_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_IDX_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock Status Indexer Idx';

--
-- Dumping data for table `cataloginventory_stock_status_idx`
--

LOCK TABLES `cataloginventory_stock_status_idx` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status_idx` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_status_idx` VALUES ('1',0,1,'9999.0000',1),('2',0,1,'0.0000',1),('7',0,1,'9998.0000',1),('9',0,1,'0.0000',1),('10',0,1,'0.0000',1),('17',0,1,'9999.0000',1),('18',0,1,'9999.0000',1),('19',0,1,'9998.0000',1),('20',0,1,'9999.0000',1),('21',0,1,'9999.0000',1),('22',0,1,'9999.0000',1),('23',0,1,'9999.0000',1),('24',0,1,'9999.0000',1),('25',0,1,'9999.0000',1),('26',0,1,'9999.0000',1),('27',0,1,'9999.0000',1),('28',0,1,'9999.0000',1),('29',0,1,'9999.0000',1),('30',0,1,'9999.0000',1),('31',0,1,'9999.0000',1),('32',0,1,'0.0000',1),('33',0,1,'9999.0000',1),('34',0,1,'9999.0000',1),('35',0,1,'9999.0000',1),('36',0,1,'9998.0000',1),('37',0,1,'9998.0000',1),('48',0,1,'9999.0000',1),('49',0,1,'9999.0000',1),('50',0,1,'0.0000',1),('51',0,1,'99999.0000',1),('52',0,1,'9999.0000',1),('53',0,1,'9999.0000',1),('54',0,1,'9999.0000',1),('55',0,1,'9999.0000',1),('56',0,1,'9999.0000',1),('57',0,1,'9999.0000',1),('58',0,1,'0.0000',0),('59',0,1,'9999.0000',1),('60',0,1,'9999.0000',1),('61',0,1,'9999.0000',1),('62',0,1,'9999.0000',1);
/*!40000 ALTER TABLE `cataloginventory_stock_status_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_tmp`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_tmp`;
CREATE TABLE `cataloginventory_stock_status_tmp` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint(5) unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_TMP_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_TMP_WEBSITE_ID` (`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock Status Indexer Tmp';

--
-- Table structure for table `catalogrule`
--

DROP TABLE IF EXISTS `catalogrule`;
CREATE TABLE `catalogrule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Id',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `from_date` date DEFAULT NULL COMMENT 'From',
  `to_date` date DEFAULT NULL COMMENT 'To',
  `is_active` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `conditions_serialized` mediumtext COMMENT 'Conditions Serialized',
  `actions_serialized` mediumtext COMMENT 'Actions Serialized',
  `stop_rules_processing` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Stop Rules Processing',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action',
  `discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount',
  PRIMARY KEY (`rule_id`),
  KEY `CATALOGRULE_IS_ACTIVE_SORT_ORDER_TO_DATE_FROM_DATE` (`is_active`,`sort_order`,`to_date`,`from_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule';

--
-- Table structure for table `catalogrule_customer_group`
--

DROP TABLE IF EXISTS `catalogrule_customer_group`;
CREATE TABLE `catalogrule_customer_group` (
  `rule_id` int(10) unsigned NOT NULL COMMENT 'Rule Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  PRIMARY KEY (`rule_id`,`customer_group_id`),
  KEY `CATALOGRULE_CUSTOMER_GROUP_CUSTOMER_GROUP_ID` (`customer_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Rules To Customer Groups Relations';

--
-- Table structure for table `catalogrule_group_website`
--

DROP TABLE IF EXISTS `catalogrule_group_website`;
CREATE TABLE `catalogrule_group_website` (
  `rule_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Rule Id',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Website Id',
  PRIMARY KEY (`rule_id`,`customer_group_id`,`website_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule Group Website';

--
-- Table structure for table `catalogrule_product`
--

DROP TABLE IF EXISTS `catalogrule_product`;
CREATE TABLE `catalogrule_product` (
  `rule_product_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product Id',
  `rule_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Rule Id',
  `from_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'From Time',
  `to_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'To time',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `action_operator` varchar(10) DEFAULT 'to_fixed' COMMENT 'Action Operator',
  `action_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Action Amount',
  `action_stop` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Action Stop',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  PRIMARY KEY (`rule_product_id`),
  UNIQUE KEY `IDX_EAA51B56FF092A0DCB795D1CEF812B7B` (`rule_id`,`from_time`,`to_time`,`website_id`,`customer_group_id`,`product_id`,`sort_order`),
  KEY `CATALOGRULE_PRODUCT_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_FROM_TIME` (`from_time`),
  KEY `CATALOGRULE_PRODUCT_TO_TIME` (`to_time`),
  KEY `CATALOGRULE_PRODUCT_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule Product';

--
-- Table structure for table `catalogrule_product_price`
--

DROP TABLE IF EXISTS `catalogrule_product_price`;
CREATE TABLE `catalogrule_product_price` (
  `rule_product_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product PriceId',
  `rule_date` date NOT NULL COMMENT 'Rule Date',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `rule_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Rule Price',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `latest_start_date` date DEFAULT NULL COMMENT 'Latest StartDate',
  `earliest_end_date` date DEFAULT NULL COMMENT 'Earliest EndDate',
  PRIMARY KEY (`rule_product_price_id`),
  UNIQUE KEY `CATRULE_PRD_PRICE_RULE_DATE_WS_ID_CSTR_GROUP_ID_PRD_ID` (`rule_date`,`website_id`,`customer_group_id`,`product_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule Product Price';

--
-- Table structure for table `catalogrule_website`
--

DROP TABLE IF EXISTS `catalogrule_website`;
CREATE TABLE `catalogrule_website` (
  `rule_id` int(10) unsigned NOT NULL COMMENT 'Rule Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  PRIMARY KEY (`rule_id`,`website_id`),
  KEY `CATALOGRULE_WEBSITE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Rules To Websites Relations';

--
-- Table structure for table `catalogsearch_fulltext_scope1`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope1`;
CREATE TABLE `catalogsearch_fulltext_scope1` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope1';

--
-- Dumping data for table `catalogsearch_fulltext_scope1`
--

LOCK TABLES `catalogsearch_fulltext_scope1` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope1` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope1` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('7','73','MH01-Black'),('7','74','MH01-Black'),('7','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','83','Chanel'),('7','93','Black'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: Sprite Statis Ball Sprite Foam Yoga Brick Sprite Yoga Strap Sprite Foam Roller | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','DKNY'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('22','73','MH01-Gray'),('22','74','MH01-Gray'),('22','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','83','Other'),('22','93','Gray'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Blue'),('30','73','MH02-Black'),('30','74','MH02-Black'),('30','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('30','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('30','83','Chanel'),('30','93','Black'),('31','73','MH02-Gray'),('31','74','MH02-Gray'),('31','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('31','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('31','83','Chanel'),('31','93','Blue'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Blue'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Lavender'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('48','73','MH03-Black'),('48','74','MH03-Black'),('48','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('48','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('48','83','DKNY'),('48','93','Black'),('49','73','MH03-Gray'),('49','74','MH03-Gray'),('49','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('49','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('49','83','DKNY'),('49','93','Purple'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','Black | Purple'),('51','73','Diam Special'),('51','74','Diam Special'),('51','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('51','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('51','83','Adidas'),('51','93','Black'),('52','73','New Diam'),('52','74','New Diam'),('52','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','83','Chanel'),('52','93','Blue'),('53','73','Diam Top'),('53','74','Diam Top'),('53','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','83','DKNY'),('53','93','Gray'),('54','73','Donec Shoes'),('54','74','Donec Shoes'),('54','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('54','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('54','83','Dolce'),('54','93','Green'),('55','73','Summer Frame'),('55','74','Summer Frame'),('55','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','83','Gabbana'),('55','93','Lavender'),('56','73','Adidas Concepts Black'),('56','74','Adidas Concepts Black'),('56','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','83','Nike'),('56','93','Multi'),('57','73','Seeulater PK White1'),('57','74','Seeulater PK White1'),('57','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('57','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('57','83','Other'),('57','93','Red'),('58','73','Wings Horns Beige'),('58','74','Wings Horns Beige'),('58','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','83','Chanel'),('58','93','Yellow'),('59','73','Reigning Champ Grey'),('59','74','Reigning Champ Grey'),('59','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','83','Adidas'),('59','93','Blue'),('60','73','Nike Air Deluxe White'),('60','74','Nike Air Deluxe White'),('60','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('60','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('60','83','Nike'),('60','93','Green'),('61','73','Lavadome Ultra Light'),('61','74','Lavadome Ultra Light'),('61','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('61','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('61','83','Chanel'),('61','93','White'),('62','73','seeulater PK White2'),('62','74','seeulater PK White2'),('62','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('62','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('62','83','Nike'),('62','93','Red'),('63','73','CTX 4pc Starter Set'),('63','74','CTX 4pc Starter Set'),('63','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','83','Nike'),('63','93','Blue'),('64','73','Chasseur Escoffier'),('64','74','Chasseur Escoffier'),('64','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('64','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('64','83','Adidas'),('64','93','Black'),('65','73','5pc Knife Block Set'),('65','74','5pc Knife Block Set'),('65','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('65','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('65','83','DKNY'),('65','93','Brown'),('67','73','5pc Knife Block Set1'),('67','74','5pc Knife Block Set1'),('67','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('67','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('67','83','Chanel'),('67','93','Brown'),('68','73','3pc Knife Block Set'),('68','74','3pc Knife Block Set'),('68','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('68','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('68','83','Dolce'),('68','93','Gray'),('69','73','Serroni Unbreakable'),('69','74','Serroni Unbreakable'),('69','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('69','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('69','83','Dolce'),('69','93','Multi'),('70','73','Infusion Pitcher'),('70','74','Infusion Pitcher'),('70','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('70','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('70','83','Chanel'),('70','93','White'),('71','73','Totally Bamboo'),('71','74','Totally Bamboo'),('71','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('71','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('71','83','Dolce'),('71','93','Brown'),('72','73','Scanpan Spectrum'),('72','74','Scanpan Spectrum'),('72','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('72','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('72','83','DKNY'),('72','93','Green'),('73','73','Chasseur La Cuisson'),('73','74','Chasseur La Cuisson'),('73','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('73','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('73','83','Gabbana'),('73','93','Lavender'),('74','73','KitchenAid Pro'),('74','74','KitchenAid Pro'),('74','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('74','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('74','83','Gabbana'),('74','93','Red'),('75','73','Scanpan CTX Coveredr'),('75','74','Scanpan CTX Coveredr'),('75','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('75','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('75','83','Chanel'),('75','93','White'),('76','73','Raco Contemporaryde'),('76','74','Raco Contemporaryde'),('76','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('76','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('76','83','DKNY'),('76','93','Gray'),('77','73','Emile Henry Braiserr'),('77','74','Emile Henry Braiserr'),('77','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('77','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('77','83','DKNY'),('77','93','Purple');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope10`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope10`;
CREATE TABLE `catalogsearch_fulltext_scope10` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope10';

--
-- Dumping data for table `catalogsearch_fulltext_scope10`
--

LOCK TABLES `catalogsearch_fulltext_scope10` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope10` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope10` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','&lt;p&gt;A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Sprite Statis Ball&lt;/li&gt;&lt;li&gt;Sprite Foam Yoga Brick&lt;/li&gt;&lt;li&gt;Sprite Yoga Strap&lt;/li&gt;&lt;li&gt;Sprite Foam Roller&lt;/li&gt;&lt;/ul&gt; | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','Dolce'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Orange'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Gray'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Blue'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('38','73','Go-Get\'r Pushup Grips'),('38','74','25-UG05'),('38','75','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield. Durable foam grips. Supportive base.'),('38','76','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield.'),('38','83','Adidas'),('38','93','Purple'),('39','73','Sprite Foam Yoga Brick'),('39','74','25-WG084'),('39','75','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options. Standard Large Size: 4\" x 6\" x 9\". Beveled edges for ideal contour grip. Durable and soft, scratch-proof foam. Individually wrapped. Ten color choices.'),('39','76','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options.'),('39','83','Dolce'),('39','93','Red'),('40','73','Aim Analog'),('40','74','25-MG04'),('40','75','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions. Japanese quartz movement. Strap fits 7\" to 8.0\".'),('40','76','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions.'),('40','83','DKNY'),('40','93','Purple'),('41','73','Endurance'),('41','74','25-MG01'),('41','75','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude. Digital display. LED backlight. Strap fits 7\" to 10\". 1-year limited warranty. Comes with polished metal case.'),('41','76','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude.'),('41','83','Nike'),('41','93','Multi'),('42','73','Summit'),('42','74','25-MG03'),('42','75','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned. Brushed metal case. Water resistant (100 meters). Buckle clasp. Strap fits 7\" - 10\". 1-year limited warranty.'),('42','76','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned.'),('42','83','Chanel'),('42','93','Orange'),('43','73','Cruise Dual Analog'),('43','74','24-MG05'),('43','75','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece. Two dials. Stainless steel case. Adjustable leather band.'),('43','76','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece.'),('43','83','Adidas'),('43','93','Red'),('44','73','Dash Digital'),('44','74','25-MG02'),('44','75','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life. Digital display. LED backlight. Rubber strap with buckle clasp. 1-year limited warranty.'),('44','76','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life.'),('44','83','Gabbana'),('44','93','Blue'),('45','73','Luma Analog'),('45','74','25-WG09'),('45','75','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability. Precision Miyota&reg; three-hand movement.'),('45','76','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability.'),('45','83','Other'),('46','73','Bolo Sport'),('46','74','25-WG01'),('46','75','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool. Displays time, day and date. Two-tone design. 12/24 hour formats. Nickel-free buckle on band. Battery included.'),('46','76','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool.'),('46','83','Gabbana'),('46','93','Brown'),('47','73','Clamber'),('47','74','25-WG03'),('47','75','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions. Japanese quartz movement. Strap fits 5\" to 6.0\".'),('47','76','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions.'),('47','83','Adidas'),('47','93','Blue'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','White | Black | Gray'),('51','73','Frankie Sweatshirt'),('51','74','26-MH04'),('51','75','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out. &bull; Light green crewneck sweatshirt.&bull; Hand pockets.&bull; Relaxed fit.&bull; Machine wash/dry.'),('51','76','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out.'),('51','83','DKNY'),('51','93','Blue'),('52','73','Hollister Backyard'),('52','74','26-MH05'),('52','75','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core. &bull; Cream crewneck sweatshirt with navy sleeves/trim.&bull; Relaxed fit. &bull; Ribbed cuffs and hem. &bull; Machine wash/dry.'),('52','76','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core.'),('52','83','Adidas'),('52','93','Black'),('53','73','Hero Hoodie'),('53','74','26-MH07'),('53','75','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient. &bull; Full-zip gray and black hoodie.&bull; Ribbed hem.&bull; Standard fit.&bull; Drawcord hood cinch.&bull; Water-resistant coating.'),('53','76','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient.'),('53','83','Dolce'),('53','93','Red'),('54','73','Oslo Trek Hoodie'),('54','74','26-GH03'),('54','75','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days. &bull; Brown hoodie with black detail.&bull; Pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Machine wash/dry.'),('54','76','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days.'),('54','83','Gabbana'),('54','93','Lavender'),('55','73','Mach Street'),('55','74','26-MK10'),('55','75','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle &bull; Navy heather crewneck sweatshirt.&bull; LumaTech&trade; moisture-wicking fabric.&bull; Antimicrobial, odor-resistant.&bull; Zip hand pockets.&bull; Chafe-resistant flatlock seams.&bull; Rib-knit cuffs and hem.'),('55','76','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle'),('55','83','Chanel'),('55','93','White'),('57','73','Grayson Crewneck'),('57','74','26-AH11'),('57','75','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue. &bull; Cream crewneck sweatshirt with black accents.&bull; 80% cotton/20% polyester fleece. &bull; Patterned knit hood lining. &bull; Knit cuffs and waist. &bull; Pouch pocket. &bull; Curl edged seam detail'),('57','76','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue.'),('57','83','Nike'),('57','93','Orange'),('58','73','Ajax Full-Zip'),('58','74','26-MH12'),('58','75','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles. &bull; Mint striped full zip hoodie.&bull; 100% bonded polyester fleece.&bull; Pouch pocket.&bull; Rib cuffs and hem. &bull; Machine washable.'),('58','76','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles.'),('58','83','Gabbana'),('58','93','Gray'),('59','73','Marco Lightweight'),('59','74','26-MH13'),('59','75','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away. &bull; Light blue heather full zip hoodie.&bull; Fitted flatlock seams.&bull; Matching lining and drawstring. &bull; Machine wash/dry.'),('59','76','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away.'),('59','83','DKNY'),('59','93','Blue'),('60','73','Beaumont Summit'),('60','74','26-MJ01'),('60','75','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package. &bull; Yellow full zip rain jacket.&bull; Full-zip front. &bull; Stand-up collar. &bull; Elasticized cuffs. &bull; Machine wash/dry.'),('60','76','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package.'),('60','83','Nike'),('60','93','Green'),('61','73','Hyperion Elements'),('61','74','26-MJ02'),('61','75','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat. &bull; Lime 1/4 zip pullover.&bull; Split pocket. &bull; Thumb holes. &bull; Machine wash/hang to dry.'),('61','76','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat.'),('61','83','Chanel'),('61','93','Brown'),('62','73','Kenobi Trail'),('62','74','26-MJ04'),('62','75','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume. &bull; Black 1/4 zip pullover with royal zipper. &bull; Adjustable hood and sleeve cuffs. &bull; Machine wash/air dry.'),('62','76','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume.'),('62','83','Chanel'),('62','93','Orange'),('63','73','Orion Two-Tone Fitted'),('63','74','26-MJ07'),('63','75','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential. &bull; Red full zip fleece with gray insets.&bull; Double-knit construction.&bull; Full athletic cut.&bull; Set in sleeves.&bull; Front pouch pocket.'),('63','76','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential.'),('63','83','Nike'),('63','93','Yellow'),('64','73','Taurus Elements'),('64','74','26-MJ09'),('64','75','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior. &bull; Yellow 1/4 zip pullover. &bull; Two chest pockets.&bull; Standard fit. &bull; Waterproof, breathable, seam sealed. &bull; Cocona&reg; performance fabric. &bull; Machine wash/dry.'),('64','76','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior.'),('64','83','Adidas'),('64','93','Multi'),('65','73','Helios EverCool&trade'),('65','74','26-MS05'),('65','75','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion. &bull; Teal quick dry tee.&bull; Relaxed fit. &bull; Crew neckline. &bull; Machine wash/dry.'),('65','76','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion.'),('65','83','Gabbana'),('65','93','Orange'),('66','73','Typhon Performance'),('66','74','26-MJ11'),('66','75','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers. &bull; Black full-zip flight jacket.&bull; Cocona&reg; wicking fiber.&bull; Machine wash/dry.'),('66','76','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers.'),('66','83','Adidas'),('66','93','White');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope10` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope11`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope11`;
CREATE TABLE `catalogsearch_fulltext_scope11` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope11';

--
-- Dumping data for table `catalogsearch_fulltext_scope11`
--

LOCK TABLES `catalogsearch_fulltext_scope11` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope11` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope11` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','&lt;p&gt;A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Sprite Statis Ball&lt;/li&gt;&lt;li&gt;Sprite Foam Yoga Brick&lt;/li&gt;&lt;li&gt;Sprite Yoga Strap&lt;/li&gt;&lt;li&gt;Sprite Foam Roller&lt;/li&gt;&lt;/ul&gt; | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','Dolce'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Orange'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Gray'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Blue'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('38','73','Go-Get\'r Pushup Grips'),('38','74','25-UG05'),('38','75','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield. Durable foam grips. Supportive base.'),('38','76','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield.'),('38','83','Adidas'),('38','93','Purple'),('39','73','Sprite Foam Yoga Brick'),('39','74','25-WG084'),('39','75','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options. Standard Large Size: 4\" x 6\" x 9\". Beveled edges for ideal contour grip. Durable and soft, scratch-proof foam. Individually wrapped. Ten color choices.'),('39','76','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options.'),('39','83','Dolce'),('39','93','Red'),('40','73','Aim Analog'),('40','74','25-MG04'),('40','75','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions. Japanese quartz movement. Strap fits 7\" to 8.0\".'),('40','76','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions.'),('40','83','DKNY'),('40','93','Purple'),('41','73','Endurance'),('41','74','25-MG01'),('41','75','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude. Digital display. LED backlight. Strap fits 7\" to 10\". 1-year limited warranty. Comes with polished metal case.'),('41','76','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude.'),('41','83','Nike'),('41','93','Multi'),('42','73','Summit'),('42','74','25-MG03'),('42','75','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned. Brushed metal case. Water resistant (100 meters). Buckle clasp. Strap fits 7\" - 10\". 1-year limited warranty.'),('42','76','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned.'),('42','83','Chanel'),('42','93','Orange'),('43','73','Cruise Dual Analog'),('43','74','24-MG05'),('43','75','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece. Two dials. Stainless steel case. Adjustable leather band.'),('43','76','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece.'),('43','83','Adidas'),('43','93','Red'),('44','73','Dash Digital'),('44','74','25-MG02'),('44','75','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life. Digital display. LED backlight. Rubber strap with buckle clasp. 1-year limited warranty.'),('44','76','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life.'),('44','83','Gabbana'),('44','93','Blue'),('45','73','Luma Analog'),('45','74','25-WG09'),('45','75','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability. Precision Miyota&reg; three-hand movement.'),('45','76','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability.'),('45','83','Other'),('46','73','Bolo Sport'),('46','74','25-WG01'),('46','75','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool. Displays time, day and date. Two-tone design. 12/24 hour formats. Nickel-free buckle on band. Battery included.'),('46','76','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool.'),('46','83','Gabbana'),('46','93','Brown'),('47','73','Clamber'),('47','74','25-WG03'),('47','75','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions. Japanese quartz movement. Strap fits 5\" to 6.0\".'),('47','76','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions.'),('47','83','Adidas'),('47','93','Blue'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','White | Black | Gray'),('51','73','Frankie Sweatshirt'),('51','74','26-MH04'),('51','75','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out. &bull; Light green crewneck sweatshirt.&bull; Hand pockets.&bull; Relaxed fit.&bull; Machine wash/dry.'),('51','76','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out.'),('51','83','DKNY'),('51','93','Blue'),('52','73','Hollister Backyard'),('52','74','26-MH05'),('52','75','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core. &bull; Cream crewneck sweatshirt with navy sleeves/trim.&bull; Relaxed fit. &bull; Ribbed cuffs and hem. &bull; Machine wash/dry.'),('52','76','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core.'),('52','83','Adidas'),('52','93','Black'),('53','73','Hero Hoodie'),('53','74','26-MH07'),('53','75','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient. &bull; Full-zip gray and black hoodie.&bull; Ribbed hem.&bull; Standard fit.&bull; Drawcord hood cinch.&bull; Water-resistant coating.'),('53','76','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient.'),('53','83','Dolce'),('53','93','Red'),('54','73','Oslo Trek Hoodie'),('54','74','26-GH03'),('54','75','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days. &bull; Brown hoodie with black detail.&bull; Pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Machine wash/dry.'),('54','76','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days.'),('54','83','Gabbana'),('54','93','Lavender'),('55','73','Mach Street'),('55','74','26-MK10'),('55','75','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle &bull; Navy heather crewneck sweatshirt.&bull; LumaTech&trade; moisture-wicking fabric.&bull; Antimicrobial, odor-resistant.&bull; Zip hand pockets.&bull; Chafe-resistant flatlock seams.&bull; Rib-knit cuffs and hem.'),('55','76','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle'),('55','83','Chanel'),('55','93','White'),('57','73','Grayson Crewneck'),('57','74','26-AH11'),('57','75','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue. &bull; Cream crewneck sweatshirt with black accents.&bull; 80% cotton/20% polyester fleece. &bull; Patterned knit hood lining. &bull; Knit cuffs and waist. &bull; Pouch pocket. &bull; Curl edged seam detail'),('57','76','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue.'),('57','83','Nike'),('57','93','Orange'),('58','73','Ajax Full-Zip'),('58','74','26-MH12'),('58','75','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles. &bull; Mint striped full zip hoodie.&bull; 100% bonded polyester fleece.&bull; Pouch pocket.&bull; Rib cuffs and hem. &bull; Machine washable.'),('58','76','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles.'),('58','83','Gabbana'),('58','93','Gray'),('59','73','Marco Lightweight'),('59','74','26-MH13'),('59','75','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away. &bull; Light blue heather full zip hoodie.&bull; Fitted flatlock seams.&bull; Matching lining and drawstring. &bull; Machine wash/dry.'),('59','76','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away.'),('59','83','DKNY'),('59','93','Blue'),('60','73','Beaumont Summit'),('60','74','26-MJ01'),('60','75','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package. &bull; Yellow full zip rain jacket.&bull; Full-zip front. &bull; Stand-up collar. &bull; Elasticized cuffs. &bull; Machine wash/dry.'),('60','76','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package.'),('60','83','Nike'),('60','93','Green'),('61','73','Hyperion Elements'),('61','74','26-MJ02'),('61','75','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat. &bull; Lime 1/4 zip pullover.&bull; Split pocket. &bull; Thumb holes. &bull; Machine wash/hang to dry.'),('61','76','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat.'),('61','83','Chanel'),('61','93','Brown'),('62','73','Kenobi Trail'),('62','74','26-MJ04'),('62','75','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume. &bull; Black 1/4 zip pullover with royal zipper. &bull; Adjustable hood and sleeve cuffs. &bull; Machine wash/air dry.'),('62','76','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume.'),('62','83','Chanel'),('62','93','Orange'),('63','73','Orion Two-Tone Fitted'),('63','74','26-MJ07'),('63','75','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential. &bull; Red full zip fleece with gray insets.&bull; Double-knit construction.&bull; Full athletic cut.&bull; Set in sleeves.&bull; Front pouch pocket.'),('63','76','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential.'),('63','83','Nike'),('63','93','Yellow'),('64','73','Taurus Elements'),('64','74','26-MJ09'),('64','75','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior. &bull; Yellow 1/4 zip pullover. &bull; Two chest pockets.&bull; Standard fit. &bull; Waterproof, breathable, seam sealed. &bull; Cocona&reg; performance fabric. &bull; Machine wash/dry.'),('64','76','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior.'),('64','83','Adidas'),('64','93','Multi'),('65','73','Helios EverCool&trade'),('65','74','26-MS05'),('65','75','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion. &bull; Teal quick dry tee.&bull; Relaxed fit. &bull; Crew neckline. &bull; Machine wash/dry.'),('65','76','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion.'),('65','83','Gabbana'),('65','93','Orange'),('66','73','Typhon Performance'),('66','74','26-MJ11'),('66','75','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers. &bull; Black full-zip flight jacket.&bull; Cocona&reg; wicking fiber.&bull; Machine wash/dry.'),('66','76','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers.'),('66','83','Adidas'),('66','93','White');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope11` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope12`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope12`;
CREATE TABLE `catalogsearch_fulltext_scope12` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope12';

--
-- Dumping data for table `catalogsearch_fulltext_scope12`
--

LOCK TABLES `catalogsearch_fulltext_scope12` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope12` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope12` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','&lt;p&gt;A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Sprite Statis Ball&lt;/li&gt;&lt;li&gt;Sprite Foam Yoga Brick&lt;/li&gt;&lt;li&gt;Sprite Yoga Strap&lt;/li&gt;&lt;li&gt;Sprite Foam Roller&lt;/li&gt;&lt;/ul&gt; | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','Dolce'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Orange'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Gray'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Blue'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('38','73','Go-Get\'r Pushup Grips'),('38','74','25-UG05'),('38','75','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield. Durable foam grips. Supportive base.'),('38','76','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield.'),('38','83','Adidas'),('38','93','Purple'),('39','73','Sprite Foam Yoga Brick'),('39','74','25-WG084'),('39','75','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options. Standard Large Size: 4\" x 6\" x 9\". Beveled edges for ideal contour grip. Durable and soft, scratch-proof foam. Individually wrapped. Ten color choices.'),('39','76','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options.'),('39','83','Dolce'),('39','93','Red'),('40','73','Aim Analog'),('40','74','25-MG04'),('40','75','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions. Japanese quartz movement. Strap fits 7\" to 8.0\".'),('40','76','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions.'),('40','83','DKNY'),('40','93','Purple'),('41','73','Endurance'),('41','74','25-MG01'),('41','75','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude. Digital display. LED backlight. Strap fits 7\" to 10\". 1-year limited warranty. Comes with polished metal case.'),('41','76','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude.'),('41','83','Nike'),('41','93','Multi'),('42','73','Summit'),('42','74','25-MG03'),('42','75','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned. Brushed metal case. Water resistant (100 meters). Buckle clasp. Strap fits 7\" - 10\". 1-year limited warranty.'),('42','76','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned.'),('42','83','Chanel'),('42','93','Orange'),('43','73','Cruise Dual Analog'),('43','74','24-MG05'),('43','75','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece. Two dials. Stainless steel case. Adjustable leather band.'),('43','76','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece.'),('43','83','Adidas'),('43','93','Red'),('44','73','Dash Digital'),('44','74','25-MG02'),('44','75','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life. Digital display. LED backlight. Rubber strap with buckle clasp. 1-year limited warranty.'),('44','76','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life.'),('44','83','Gabbana'),('44','93','Blue'),('45','73','Luma Analog'),('45','74','25-WG09'),('45','75','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability. Precision Miyota&reg; three-hand movement.'),('45','76','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability.'),('45','83','Other'),('46','73','Bolo Sport'),('46','74','25-WG01'),('46','75','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool. Displays time, day and date. Two-tone design. 12/24 hour formats. Nickel-free buckle on band. Battery included.'),('46','76','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool.'),('46','83','Gabbana'),('46','93','Brown'),('47','73','Clamber'),('47','74','25-WG03'),('47','75','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions. Japanese quartz movement. Strap fits 5\" to 6.0\".'),('47','76','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions.'),('47','83','Adidas'),('47','93','Blue'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','White | Black | Gray'),('51','73','Frankie Sweatshirt'),('51','74','26-MH04'),('51','75','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out. &bull; Light green crewneck sweatshirt.&bull; Hand pockets.&bull; Relaxed fit.&bull; Machine wash/dry.'),('51','76','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out.'),('51','83','DKNY'),('51','93','Blue'),('52','73','Hollister Backyard'),('52','74','26-MH05'),('52','75','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core. &bull; Cream crewneck sweatshirt with navy sleeves/trim.&bull; Relaxed fit. &bull; Ribbed cuffs and hem. &bull; Machine wash/dry.'),('52','76','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core.'),('52','83','Adidas'),('52','93','Black'),('53','73','Hero Hoodie'),('53','74','26-MH07'),('53','75','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient. &bull; Full-zip gray and black hoodie.&bull; Ribbed hem.&bull; Standard fit.&bull; Drawcord hood cinch.&bull; Water-resistant coating.'),('53','76','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient.'),('53','83','Dolce'),('53','93','Red'),('54','73','Oslo Trek Hoodie'),('54','74','26-GH03'),('54','75','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days. &bull; Brown hoodie with black detail.&bull; Pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Machine wash/dry.'),('54','76','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days.'),('54','83','Gabbana'),('54','93','Lavender'),('55','73','Mach Street'),('55','74','26-MK10'),('55','75','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle &bull; Navy heather crewneck sweatshirt.&bull; LumaTech&trade; moisture-wicking fabric.&bull; Antimicrobial, odor-resistant.&bull; Zip hand pockets.&bull; Chafe-resistant flatlock seams.&bull; Rib-knit cuffs and hem.'),('55','76','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle'),('55','83','Chanel'),('55','93','White'),('57','73','Grayson Crewneck'),('57','74','26-AH11'),('57','75','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue. &bull; Cream crewneck sweatshirt with black accents.&bull; 80% cotton/20% polyester fleece. &bull; Patterned knit hood lining. &bull; Knit cuffs and waist. &bull; Pouch pocket. &bull; Curl edged seam detail'),('57','76','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue.'),('57','83','Nike'),('57','93','Orange'),('58','73','Ajax Full-Zip'),('58','74','26-MH12'),('58','75','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles. &bull; Mint striped full zip hoodie.&bull; 100% bonded polyester fleece.&bull; Pouch pocket.&bull; Rib cuffs and hem. &bull; Machine washable.'),('58','76','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles.'),('58','83','Gabbana'),('58','93','Gray'),('59','73','Marco Lightweight'),('59','74','26-MH13'),('59','75','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away. &bull; Light blue heather full zip hoodie.&bull; Fitted flatlock seams.&bull; Matching lining and drawstring. &bull; Machine wash/dry.'),('59','76','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away.'),('59','83','DKNY'),('59','93','Blue'),('60','73','Beaumont Summit'),('60','74','26-MJ01'),('60','75','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package. &bull; Yellow full zip rain jacket.&bull; Full-zip front. &bull; Stand-up collar. &bull; Elasticized cuffs. &bull; Machine wash/dry.'),('60','76','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package.'),('60','83','Nike'),('60','93','Green'),('61','73','Hyperion Elements'),('61','74','26-MJ02'),('61','75','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat. &bull; Lime 1/4 zip pullover.&bull; Split pocket. &bull; Thumb holes. &bull; Machine wash/hang to dry.'),('61','76','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat.'),('61','83','Chanel'),('61','93','Brown'),('62','73','Kenobi Trail'),('62','74','26-MJ04'),('62','75','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume. &bull; Black 1/4 zip pullover with royal zipper. &bull; Adjustable hood and sleeve cuffs. &bull; Machine wash/air dry.'),('62','76','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume.'),('62','83','Chanel'),('62','93','Orange'),('63','73','Orion Two-Tone Fitted'),('63','74','26-MJ07'),('63','75','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential. &bull; Red full zip fleece with gray insets.&bull; Double-knit construction.&bull; Full athletic cut.&bull; Set in sleeves.&bull; Front pouch pocket.'),('63','76','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential.'),('63','83','Nike'),('63','93','Yellow'),('64','73','Taurus Elements'),('64','74','26-MJ09'),('64','75','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior. &bull; Yellow 1/4 zip pullover. &bull; Two chest pockets.&bull; Standard fit. &bull; Waterproof, breathable, seam sealed. &bull; Cocona&reg; performance fabric. &bull; Machine wash/dry.'),('64','76','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior.'),('64','83','Adidas'),('64','93','Multi'),('65','73','Helios EverCool&trade'),('65','74','26-MS05'),('65','75','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion. &bull; Teal quick dry tee.&bull; Relaxed fit. &bull; Crew neckline. &bull; Machine wash/dry.'),('65','76','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion.'),('65','83','Gabbana'),('65','93','Orange'),('66','73','Typhon Performance'),('66','74','26-MJ11'),('66','75','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers. &bull; Black full-zip flight jacket.&bull; Cocona&reg; wicking fiber.&bull; Machine wash/dry.'),('66','76','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers.'),('66','83','Adidas'),('66','93','White');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope12` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope13`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope13`;
CREATE TABLE `catalogsearch_fulltext_scope13` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope13';

--
-- Dumping data for table `catalogsearch_fulltext_scope13`
--

LOCK TABLES `catalogsearch_fulltext_scope13` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope13` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope13` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','&lt;p&gt;A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Sprite Statis Ball&lt;/li&gt;&lt;li&gt;Sprite Foam Yoga Brick&lt;/li&gt;&lt;li&gt;Sprite Yoga Strap&lt;/li&gt;&lt;li&gt;Sprite Foam Roller&lt;/li&gt;&lt;/ul&gt; | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','Dolce'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Orange'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Gray'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Blue'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('38','73','Go-Get\'r Pushup Grips'),('38','74','25-UG05'),('38','75','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield. Durable foam grips. Supportive base.'),('38','76','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield.'),('38','83','Adidas'),('38','93','Purple'),('39','73','Sprite Foam Yoga Brick'),('39','74','25-WG084'),('39','75','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options. Standard Large Size: 4\" x 6\" x 9\". Beveled edges for ideal contour grip. Durable and soft, scratch-proof foam. Individually wrapped. Ten color choices.'),('39','76','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options.'),('39','83','Dolce'),('39','93','Red'),('40','73','Aim Analog'),('40','74','25-MG04'),('40','75','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions. Japanese quartz movement. Strap fits 7\" to 8.0\".'),('40','76','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions.'),('40','83','DKNY'),('40','93','Purple'),('41','73','Endurance'),('41','74','25-MG01'),('41','75','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude. Digital display. LED backlight. Strap fits 7\" to 10\". 1-year limited warranty. Comes with polished metal case.'),('41','76','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude.'),('41','83','Nike'),('41','93','Multi'),('42','73','Summit'),('42','74','25-MG03'),('42','75','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned. Brushed metal case. Water resistant (100 meters). Buckle clasp. Strap fits 7\" - 10\". 1-year limited warranty.'),('42','76','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned.'),('42','83','Chanel'),('42','93','Orange'),('43','73','Cruise Dual Analog'),('43','74','24-MG05'),('43','75','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece. Two dials. Stainless steel case. Adjustable leather band.'),('43','76','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece.'),('43','83','Adidas'),('43','93','Red'),('44','73','Dash Digital'),('44','74','25-MG02'),('44','75','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life. Digital display. LED backlight. Rubber strap with buckle clasp. 1-year limited warranty.'),('44','76','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life.'),('44','83','Gabbana'),('44','93','Blue'),('45','73','Luma Analog'),('45','74','25-WG09'),('45','75','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability. Precision Miyota&reg; three-hand movement.'),('45','76','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability.'),('45','83','Other'),('46','73','Bolo Sport'),('46','74','25-WG01'),('46','75','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool. Displays time, day and date. Two-tone design. 12/24 hour formats. Nickel-free buckle on band. Battery included.'),('46','76','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool.'),('46','83','Gabbana'),('46','93','Brown'),('47','73','Clamber'),('47','74','25-WG03'),('47','75','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions. Japanese quartz movement. Strap fits 5\" to 6.0\".'),('47','76','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions.'),('47','83','Adidas'),('47','93','Blue'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','White | Black | Gray'),('51','73','Frankie Sweatshirt'),('51','74','26-MH04'),('51','75','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out. &bull; Light green crewneck sweatshirt.&bull; Hand pockets.&bull; Relaxed fit.&bull; Machine wash/dry.'),('51','76','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out.'),('51','83','DKNY'),('51','93','Blue'),('52','73','Hollister Backyard'),('52','74','26-MH05'),('52','75','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core. &bull; Cream crewneck sweatshirt with navy sleeves/trim.&bull; Relaxed fit. &bull; Ribbed cuffs and hem. &bull; Machine wash/dry.'),('52','76','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core.'),('52','83','Adidas'),('52','93','Black'),('53','73','Hero Hoodie'),('53','74','26-MH07'),('53','75','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient. &bull; Full-zip gray and black hoodie.&bull; Ribbed hem.&bull; Standard fit.&bull; Drawcord hood cinch.&bull; Water-resistant coating.'),('53','76','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient.'),('53','83','Dolce'),('53','93','Red'),('54','73','Oslo Trek Hoodie'),('54','74','26-GH03'),('54','75','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days. &bull; Brown hoodie with black detail.&bull; Pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Machine wash/dry.'),('54','76','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days.'),('54','83','Gabbana'),('54','93','Lavender'),('55','73','Mach Street'),('55','74','26-MK10'),('55','75','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle &bull; Navy heather crewneck sweatshirt.&bull; LumaTech&trade; moisture-wicking fabric.&bull; Antimicrobial, odor-resistant.&bull; Zip hand pockets.&bull; Chafe-resistant flatlock seams.&bull; Rib-knit cuffs and hem.'),('55','76','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle'),('55','83','Chanel'),('55','93','White'),('57','73','Grayson Crewneck'),('57','74','26-AH11'),('57','75','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue. &bull; Cream crewneck sweatshirt with black accents.&bull; 80% cotton/20% polyester fleece. &bull; Patterned knit hood lining. &bull; Knit cuffs and waist. &bull; Pouch pocket. &bull; Curl edged seam detail'),('57','76','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue.'),('57','83','Nike'),('57','93','Orange'),('58','73','Ajax Full-Zip'),('58','74','26-MH12'),('58','75','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles. &bull; Mint striped full zip hoodie.&bull; 100% bonded polyester fleece.&bull; Pouch pocket.&bull; Rib cuffs and hem. &bull; Machine washable.'),('58','76','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles.'),('58','83','Gabbana'),('58','93','Gray'),('59','73','Marco Lightweight'),('59','74','26-MH13'),('59','75','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away. &bull; Light blue heather full zip hoodie.&bull; Fitted flatlock seams.&bull; Matching lining and drawstring. &bull; Machine wash/dry.'),('59','76','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away.'),('59','83','DKNY'),('59','93','Blue'),('60','73','Beaumont Summit'),('60','74','26-MJ01'),('60','75','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package. &bull; Yellow full zip rain jacket.&bull; Full-zip front. &bull; Stand-up collar. &bull; Elasticized cuffs. &bull; Machine wash/dry.'),('60','76','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package.'),('60','83','Nike'),('60','93','Green'),('61','73','Hyperion Elements'),('61','74','26-MJ02'),('61','75','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat. &bull; Lime 1/4 zip pullover.&bull; Split pocket. &bull; Thumb holes. &bull; Machine wash/hang to dry.'),('61','76','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat.'),('61','83','Chanel'),('61','93','Brown'),('62','73','Kenobi Trail'),('62','74','26-MJ04'),('62','75','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume. &bull; Black 1/4 zip pullover with royal zipper. &bull; Adjustable hood and sleeve cuffs. &bull; Machine wash/air dry.'),('62','76','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume.'),('62','83','Chanel'),('62','93','Orange'),('63','73','Orion Two-Tone Fitted'),('63','74','26-MJ07'),('63','75','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential. &bull; Red full zip fleece with gray insets.&bull; Double-knit construction.&bull; Full athletic cut.&bull; Set in sleeves.&bull; Front pouch pocket.'),('63','76','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential.'),('63','83','Nike'),('63','93','Yellow'),('64','73','Taurus Elements'),('64','74','26-MJ09'),('64','75','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior. &bull; Yellow 1/4 zip pullover. &bull; Two chest pockets.&bull; Standard fit. &bull; Waterproof, breathable, seam sealed. &bull; Cocona&reg; performance fabric. &bull; Machine wash/dry.'),('64','76','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior.'),('64','83','Adidas'),('64','93','Multi'),('65','73','Helios EverCool&trade'),('65','74','26-MS05'),('65','75','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion. &bull; Teal quick dry tee.&bull; Relaxed fit. &bull; Crew neckline. &bull; Machine wash/dry.'),('65','76','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion.'),('65','83','Gabbana'),('65','93','Orange'),('66','73','Typhon Performance'),('66','74','26-MJ11'),('66','75','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers. &bull; Black full-zip flight jacket.&bull; Cocona&reg; wicking fiber.&bull; Machine wash/dry.'),('66','76','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers.'),('66','83','Adidas'),('66','93','White');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope13` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope14`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope14`;
CREATE TABLE `catalogsearch_fulltext_scope14` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope14';

--
-- Dumping data for table `catalogsearch_fulltext_scope14`
--

LOCK TABLES `catalogsearch_fulltext_scope14` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope14` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope14` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','&lt;p&gt;A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Sprite Statis Ball&lt;/li&gt;&lt;li&gt;Sprite Foam Yoga Brick&lt;/li&gt;&lt;li&gt;Sprite Yoga Strap&lt;/li&gt;&lt;li&gt;Sprite Foam Roller&lt;/li&gt;&lt;/ul&gt; | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','Dolce'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Orange'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Gray'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Blue'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('38','73','Go-Get\'r Pushup Grips'),('38','74','25-UG05'),('38','75','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield. Durable foam grips. Supportive base.'),('38','76','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield.'),('38','83','Adidas'),('38','93','Purple'),('39','73','Sprite Foam Yoga Brick'),('39','74','25-WG084'),('39','75','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options. Standard Large Size: 4\" x 6\" x 9\". Beveled edges for ideal contour grip. Durable and soft, scratch-proof foam. Individually wrapped. Ten color choices.'),('39','76','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options.'),('39','83','Dolce'),('39','93','Red'),('40','73','Aim Analog'),('40','74','25-MG04'),('40','75','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions. Japanese quartz movement. Strap fits 7\" to 8.0\".'),('40','76','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions.'),('40','83','DKNY'),('40','93','Purple'),('41','73','Endurance'),('41','74','25-MG01'),('41','75','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude. Digital display. LED backlight. Strap fits 7\" to 10\". 1-year limited warranty. Comes with polished metal case.'),('41','76','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude.'),('41','83','Nike'),('41','93','Multi'),('42','73','Summit'),('42','74','25-MG03'),('42','75','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned. Brushed metal case. Water resistant (100 meters). Buckle clasp. Strap fits 7\" - 10\". 1-year limited warranty.'),('42','76','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned.'),('42','83','Chanel'),('42','93','Orange'),('43','73','Cruise Dual Analog'),('43','74','24-MG05'),('43','75','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece. Two dials. Stainless steel case. Adjustable leather band.'),('43','76','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece.'),('43','83','Adidas'),('43','93','Red'),('44','73','Dash Digital'),('44','74','25-MG02'),('44','75','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life. Digital display. LED backlight. Rubber strap with buckle clasp. 1-year limited warranty.'),('44','76','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life.'),('44','83','Gabbana'),('44','93','Blue'),('45','73','Luma Analog'),('45','74','25-WG09'),('45','75','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability. Precision Miyota&reg; three-hand movement.'),('45','76','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability.'),('45','83','Other'),('46','73','Bolo Sport'),('46','74','25-WG01'),('46','75','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool. Displays time, day and date. Two-tone design. 12/24 hour formats. Nickel-free buckle on band. Battery included.'),('46','76','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool.'),('46','83','Gabbana'),('46','93','Brown'),('47','73','Clamber'),('47','74','25-WG03'),('47','75','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions. Japanese quartz movement. Strap fits 5\" to 6.0\".'),('47','76','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions.'),('47','83','Adidas'),('47','93','Blue'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','White | Black | Gray'),('51','73','Frankie Sweatshirt'),('51','74','26-MH04'),('51','75','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out. &bull; Light green crewneck sweatshirt.&bull; Hand pockets.&bull; Relaxed fit.&bull; Machine wash/dry.'),('51','76','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out.'),('51','83','DKNY'),('51','93','Blue'),('52','73','Hollister Backyard'),('52','74','26-MH05'),('52','75','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core. &bull; Cream crewneck sweatshirt with navy sleeves/trim.&bull; Relaxed fit. &bull; Ribbed cuffs and hem. &bull; Machine wash/dry.'),('52','76','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core.'),('52','83','Adidas'),('52','93','Black'),('53','73','Hero Hoodie'),('53','74','26-MH07'),('53','75','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient. &bull; Full-zip gray and black hoodie.&bull; Ribbed hem.&bull; Standard fit.&bull; Drawcord hood cinch.&bull; Water-resistant coating.'),('53','76','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient.'),('53','83','Dolce'),('53','93','Red'),('54','73','Oslo Trek Hoodie'),('54','74','26-GH03'),('54','75','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days. &bull; Brown hoodie with black detail.&bull; Pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Machine wash/dry.'),('54','76','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days.'),('54','83','Gabbana'),('54','93','Lavender'),('55','73','Mach Street'),('55','74','26-MK10'),('55','75','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle &bull; Navy heather crewneck sweatshirt.&bull; LumaTech&trade; moisture-wicking fabric.&bull; Antimicrobial, odor-resistant.&bull; Zip hand pockets.&bull; Chafe-resistant flatlock seams.&bull; Rib-knit cuffs and hem.'),('55','76','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle'),('55','83','Chanel'),('55','93','White'),('57','73','Grayson Crewneck'),('57','74','26-AH11'),('57','75','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue. &bull; Cream crewneck sweatshirt with black accents.&bull; 80% cotton/20% polyester fleece. &bull; Patterned knit hood lining. &bull; Knit cuffs and waist. &bull; Pouch pocket. &bull; Curl edged seam detail'),('57','76','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue.'),('57','83','Nike'),('57','93','Orange'),('58','73','Ajax Full-Zip'),('58','74','26-MH12'),('58','75','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles. &bull; Mint striped full zip hoodie.&bull; 100% bonded polyester fleece.&bull; Pouch pocket.&bull; Rib cuffs and hem. &bull; Machine washable.'),('58','76','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles.'),('58','83','Gabbana'),('58','93','Gray'),('59','73','Marco Lightweight'),('59','74','26-MH13'),('59','75','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away. &bull; Light blue heather full zip hoodie.&bull; Fitted flatlock seams.&bull; Matching lining and drawstring. &bull; Machine wash/dry.'),('59','76','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away.'),('59','83','DKNY'),('59','93','Blue'),('60','73','Beaumont Summit'),('60','74','26-MJ01'),('60','75','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package. &bull; Yellow full zip rain jacket.&bull; Full-zip front. &bull; Stand-up collar. &bull; Elasticized cuffs. &bull; Machine wash/dry.'),('60','76','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package.'),('60','83','Nike'),('60','93','Green'),('61','73','Hyperion Elements'),('61','74','26-MJ02'),('61','75','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat. &bull; Lime 1/4 zip pullover.&bull; Split pocket. &bull; Thumb holes. &bull; Machine wash/hang to dry.'),('61','76','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat.'),('61','83','Chanel'),('61','93','Brown'),('62','73','Kenobi Trail'),('62','74','26-MJ04'),('62','75','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume. &bull; Black 1/4 zip pullover with royal zipper. &bull; Adjustable hood and sleeve cuffs. &bull; Machine wash/air dry.'),('62','76','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume.'),('62','83','Chanel'),('62','93','Orange'),('63','73','Orion Two-Tone Fitted'),('63','74','26-MJ07'),('63','75','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential. &bull; Red full zip fleece with gray insets.&bull; Double-knit construction.&bull; Full athletic cut.&bull; Set in sleeves.&bull; Front pouch pocket.'),('63','76','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential.'),('63','83','Nike'),('63','93','Yellow'),('64','73','Taurus Elements'),('64','74','26-MJ09'),('64','75','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior. &bull; Yellow 1/4 zip pullover. &bull; Two chest pockets.&bull; Standard fit. &bull; Waterproof, breathable, seam sealed. &bull; Cocona&reg; performance fabric. &bull; Machine wash/dry.'),('64','76','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior.'),('64','83','Adidas'),('64','93','Multi'),('65','73','Helios EverCool&trade'),('65','74','26-MS05'),('65','75','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion. &bull; Teal quick dry tee.&bull; Relaxed fit. &bull; Crew neckline. &bull; Machine wash/dry.'),('65','76','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion.'),('65','83','Gabbana'),('65','93','Orange'),('66','73','Typhon Performance'),('66','74','26-MJ11'),('66','75','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers. &bull; Black full-zip flight jacket.&bull; Cocona&reg; wicking fiber.&bull; Machine wash/dry.'),('66','76','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers.'),('66','83','Adidas'),('66','93','White');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope14` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope15`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope15`;
CREATE TABLE `catalogsearch_fulltext_scope15` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope15';

--
-- Dumping data for table `catalogsearch_fulltext_scope15`
--

LOCK TABLES `catalogsearch_fulltext_scope15` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope15` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope15` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','&lt;p&gt;A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Sprite Statis Ball&lt;/li&gt;&lt;li&gt;Sprite Foam Yoga Brick&lt;/li&gt;&lt;li&gt;Sprite Yoga Strap&lt;/li&gt;&lt;li&gt;Sprite Foam Roller&lt;/li&gt;&lt;/ul&gt; | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','Dolce'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Orange'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Gray'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Blue'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('38','73','Go-Get\'r Pushup Grips'),('38','74','25-UG05'),('38','75','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield. Durable foam grips. Supportive base.'),('38','76','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield.'),('38','83','Adidas'),('38','93','Purple'),('39','73','Sprite Foam Yoga Brick'),('39','74','25-WG084'),('39','75','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options. Standard Large Size: 4\" x 6\" x 9\". Beveled edges for ideal contour grip. Durable and soft, scratch-proof foam. Individually wrapped. Ten color choices.'),('39','76','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options.'),('39','83','Dolce'),('39','93','Red'),('40','73','Aim Analog'),('40','74','25-MG04'),('40','75','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions. Japanese quartz movement. Strap fits 7\" to 8.0\".'),('40','76','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions.'),('40','83','DKNY'),('40','93','Purple'),('41','73','Endurance'),('41','74','25-MG01'),('41','75','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude. Digital display. LED backlight. Strap fits 7\" to 10\". 1-year limited warranty. Comes with polished metal case.'),('41','76','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude.'),('41','83','Nike'),('41','93','Multi'),('42','73','Summit'),('42','74','25-MG03'),('42','75','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned. Brushed metal case. Water resistant (100 meters). Buckle clasp. Strap fits 7\" - 10\". 1-year limited warranty.'),('42','76','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned.'),('42','83','Chanel'),('42','93','Orange'),('43','73','Cruise Dual Analog'),('43','74','24-MG05'),('43','75','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece. Two dials. Stainless steel case. Adjustable leather band.'),('43','76','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece.'),('43','83','Adidas'),('43','93','Red'),('44','73','Dash Digital'),('44','74','25-MG02'),('44','75','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life. Digital display. LED backlight. Rubber strap with buckle clasp. 1-year limited warranty.'),('44','76','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life.'),('44','83','Gabbana'),('44','93','Blue'),('45','73','Luma Analog'),('45','74','25-WG09'),('45','75','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability. Precision Miyota&reg; three-hand movement.'),('45','76','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability.'),('45','83','Other'),('46','73','Bolo Sport'),('46','74','25-WG01'),('46','75','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool. Displays time, day and date. Two-tone design. 12/24 hour formats. Nickel-free buckle on band. Battery included.'),('46','76','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool.'),('46','83','Gabbana'),('46','93','Brown'),('47','73','Clamber'),('47','74','25-WG03'),('47','75','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions. Japanese quartz movement. Strap fits 5\" to 6.0\".'),('47','76','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions.'),('47','83','Adidas'),('47','93','Blue'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','White | Black | Gray'),('51','73','Frankie Sweatshirt'),('51','74','26-MH04'),('51','75','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out. &bull; Light green crewneck sweatshirt.&bull; Hand pockets.&bull; Relaxed fit.&bull; Machine wash/dry.'),('51','76','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out.'),('51','83','DKNY'),('51','93','Blue'),('52','73','Hollister Backyard'),('52','74','26-MH05'),('52','75','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core. &bull; Cream crewneck sweatshirt with navy sleeves/trim.&bull; Relaxed fit. &bull; Ribbed cuffs and hem. &bull; Machine wash/dry.'),('52','76','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core.'),('52','83','Adidas'),('52','93','Black'),('53','73','Hero Hoodie'),('53','74','26-MH07'),('53','75','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient. &bull; Full-zip gray and black hoodie.&bull; Ribbed hem.&bull; Standard fit.&bull; Drawcord hood cinch.&bull; Water-resistant coating.'),('53','76','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient.'),('53','83','Dolce'),('53','93','Red'),('54','73','Oslo Trek Hoodie'),('54','74','26-GH03'),('54','75','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days. &bull; Brown hoodie with black detail.&bull; Pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Machine wash/dry.'),('54','76','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days.'),('54','83','Gabbana'),('54','93','Lavender'),('55','73','Mach Street'),('55','74','26-MK10'),('55','75','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle &bull; Navy heather crewneck sweatshirt.&bull; LumaTech&trade; moisture-wicking fabric.&bull; Antimicrobial, odor-resistant.&bull; Zip hand pockets.&bull; Chafe-resistant flatlock seams.&bull; Rib-knit cuffs and hem.'),('55','76','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle'),('55','83','Chanel'),('55','93','White'),('57','73','Grayson Crewneck'),('57','74','26-AH11'),('57','75','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue. &bull; Cream crewneck sweatshirt with black accents.&bull; 80% cotton/20% polyester fleece. &bull; Patterned knit hood lining. &bull; Knit cuffs and waist. &bull; Pouch pocket. &bull; Curl edged seam detail'),('57','76','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue.'),('57','83','Nike'),('57','93','Orange'),('58','73','Ajax Full-Zip'),('58','74','26-MH12'),('58','75','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles. &bull; Mint striped full zip hoodie.&bull; 100% bonded polyester fleece.&bull; Pouch pocket.&bull; Rib cuffs and hem. &bull; Machine washable.'),('58','76','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles.'),('58','83','Gabbana'),('58','93','Gray'),('59','73','Marco Lightweight'),('59','74','26-MH13'),('59','75','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away. &bull; Light blue heather full zip hoodie.&bull; Fitted flatlock seams.&bull; Matching lining and drawstring. &bull; Machine wash/dry.'),('59','76','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away.'),('59','83','DKNY'),('59','93','Blue'),('60','73','Beaumont Summit'),('60','74','26-MJ01'),('60','75','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package. &bull; Yellow full zip rain jacket.&bull; Full-zip front. &bull; Stand-up collar. &bull; Elasticized cuffs. &bull; Machine wash/dry.'),('60','76','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package.'),('60','83','Nike'),('60','93','Green'),('61','73','Hyperion Elements'),('61','74','26-MJ02'),('61','75','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat. &bull; Lime 1/4 zip pullover.&bull; Split pocket. &bull; Thumb holes. &bull; Machine wash/hang to dry.'),('61','76','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat.'),('61','83','Chanel'),('61','93','Brown'),('62','73','Kenobi Trail'),('62','74','26-MJ04'),('62','75','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume. &bull; Black 1/4 zip pullover with royal zipper. &bull; Adjustable hood and sleeve cuffs. &bull; Machine wash/air dry.'),('62','76','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume.'),('62','83','Chanel'),('62','93','Orange'),('63','73','Orion Two-Tone Fitted'),('63','74','26-MJ07'),('63','75','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential. &bull; Red full zip fleece with gray insets.&bull; Double-knit construction.&bull; Full athletic cut.&bull; Set in sleeves.&bull; Front pouch pocket.'),('63','76','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential.'),('63','83','Nike'),('63','93','Yellow'),('64','73','Taurus Elements'),('64','74','26-MJ09'),('64','75','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior. &bull; Yellow 1/4 zip pullover. &bull; Two chest pockets.&bull; Standard fit. &bull; Waterproof, breathable, seam sealed. &bull; Cocona&reg; performance fabric. &bull; Machine wash/dry.'),('64','76','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior.'),('64','83','Adidas'),('64','93','Multi'),('65','73','Helios EverCool&trade'),('65','74','26-MS05'),('65','75','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion. &bull; Teal quick dry tee.&bull; Relaxed fit. &bull; Crew neckline. &bull; Machine wash/dry.'),('65','76','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion.'),('65','83','Gabbana'),('65','93','Orange'),('66','73','Typhon Performance'),('66','74','26-MJ11'),('66','75','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers. &bull; Black full-zip flight jacket.&bull; Cocona&reg; wicking fiber.&bull; Machine wash/dry.'),('66','76','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers.'),('66','83','Adidas'),('66','93','White');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope15` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope16`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope16`;
CREATE TABLE `catalogsearch_fulltext_scope16` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope16';

--
-- Dumping data for table `catalogsearch_fulltext_scope16`
--

LOCK TABLES `catalogsearch_fulltext_scope16` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope16` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope16` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','&lt;p&gt;A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Sprite Statis Ball&lt;/li&gt;&lt;li&gt;Sprite Foam Yoga Brick&lt;/li&gt;&lt;li&gt;Sprite Yoga Strap&lt;/li&gt;&lt;li&gt;Sprite Foam Roller&lt;/li&gt;&lt;/ul&gt; | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','Dolce'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Orange'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Gray'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Blue'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('38','73','Go-Get\'r Pushup Grips'),('38','74','25-UG05'),('38','75','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield. Durable foam grips. Supportive base.'),('38','76','The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield.'),('38','83','Adidas'),('38','93','Purple'),('39','73','Sprite Foam Yoga Brick'),('39','74','25-WG084'),('39','75','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options. Standard Large Size: 4\" x 6\" x 9\". Beveled edges for ideal contour grip. Durable and soft, scratch-proof foam. Individually wrapped. Ten color choices.'),('39','76','Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options.'),('39','83','Dolce'),('39','93','Red'),('40','73','Aim Analog'),('40','74','25-MG04'),('40','75','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions. Japanese quartz movement. Strap fits 7\" to 8.0\".'),('40','76','Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions.'),('40','83','DKNY'),('40','93','Purple'),('41','73','Endurance'),('41','74','25-MG01'),('41','75','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude. Digital display. LED backlight. Strap fits 7\" to 10\". 1-year limited warranty. Comes with polished metal case.'),('41','76','It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude.'),('41','83','Nike'),('41','93','Multi'),('42','73','Summit'),('42','74','25-MG03'),('42','75','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned. Brushed metal case. Water resistant (100 meters). Buckle clasp. Strap fits 7\" - 10\". 1-year limited warranty.'),('42','76','Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned.'),('42','83','Chanel'),('42','93','Orange'),('43','73','Cruise Dual Analog'),('43','74','24-MG05'),('43','75','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece. Two dials. Stainless steel case. Adjustable leather band.'),('43','76','Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece.'),('43','83','Adidas'),('43','93','Red'),('44','73','Dash Digital'),('44','74','25-MG02'),('44','75','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life. Digital display. LED backlight. Rubber strap with buckle clasp. 1-year limited warranty.'),('44','76','The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life.'),('44','83','Gabbana'),('44','93','Blue'),('45','73','Luma Analog'),('45','74','25-WG09'),('45','75','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability. Precision Miyota&reg; three-hand movement.'),('45','76','Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability.'),('45','83','Other'),('46','73','Bolo Sport'),('46','74','25-WG01'),('46','75','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool. Displays time, day and date. Two-tone design. 12/24 hour formats. Nickel-free buckle on band. Battery included.'),('46','76','The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool.'),('46','83','Gabbana'),('46','93','Brown'),('47','73','Clamber'),('47','74','25-WG03'),('47','75','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions. Japanese quartz movement. Strap fits 5\" to 6.0\".'),('47','76','Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions.'),('47','83','Adidas'),('47','93','Blue'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','White | Black | Gray'),('51','73','Frankie Sweatshirt'),('51','74','26-MH04'),('51','75','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out. &bull; Light green crewneck sweatshirt.&bull; Hand pockets.&bull; Relaxed fit.&bull; Machine wash/dry.'),('51','76','The Frankie Sweatshirt is your best friend at long afternoon stadium stints or winter trailside campsites. The soft fleece fabric keeps you toasty as moisture-wicking technology kicks in when the sun comes out.'),('51','83','DKNY'),('51','93','Blue'),('52','73','Hollister Backyard'),('52','74','26-MH05'),('52','75','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core. &bull; Cream crewneck sweatshirt with navy sleeves/trim.&bull; Relaxed fit. &bull; Ribbed cuffs and hem. &bull; Machine wash/dry.'),('52','76','Kick off your weekend in the Hollister Backyard Sweatshirt. Whether you\'re raking leaves or flipping burgers, this comfy layer blocks the bite of the crisp autumn air. Puffy thick from hood to hem, it traps heat against your core.'),('52','83','Adidas'),('52','93','Black'),('53','73','Hero Hoodie'),('53','74','26-MH07'),('53','75','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient. &bull; Full-zip gray and black hoodie.&bull; Ribbed hem.&bull; Standard fit.&bull; Drawcord hood cinch.&bull; Water-resistant coating.'),('53','76','Gray and black color blocking sets you apart as the Hero Hoodie keeps you warm on the bus, campus or cold mean streets. Slanted outsize front pockets keep your style real . . . convenient.'),('53','83','Dolce'),('53','93','Red'),('54','73','Oslo Trek Hoodie'),('54','74','26-GH03'),('54','75','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days. &bull; Brown hoodie with black detail.&bull; Pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Machine wash/dry.'),('54','76','Chilly weather is just an excuse to throw on your toasty, handsome new Oslo Trek Hoodie. It features an adjustable drawstring hood and a kangaroo pocket for extra hand warmth. The ultra-soft, cozy lining will have you wishing for more brisk days.'),('54','83','Gabbana'),('54','93','Lavender'),('55','73','Mach Street'),('55','74','26-MK10'),('55','75','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle &bull; Navy heather crewneck sweatshirt.&bull; LumaTech&trade; moisture-wicking fabric.&bull; Antimicrobial, odor-resistant.&bull; Zip hand pockets.&bull; Chafe-resistant flatlock seams.&bull; Rib-knit cuffs and hem.'),('55','76','From hard streets to asphalt track, the Mach Street Sweatshirt holds up to wear and wind and rain. An infusion of performance and stylish comfort, with moisture-wicking LumaTech&trade; fabric, it\'s bound to become an everyday part of your active lifestyle'),('55','83','Chanel'),('55','93','White'),('57','73','Grayson Crewneck'),('57','74','26-AH11'),('57','75','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue. &bull; Cream crewneck sweatshirt with black accents.&bull; 80% cotton/20% polyester fleece. &bull; Patterned knit hood lining. &bull; Knit cuffs and waist. &bull; Pouch pocket. &bull; Curl edged seam detail'),('57','76','The Grayson Crewneck Sweatshirt gives you that ageless, classic look &ndash; a style that comes back around nearly every season. What\'s more, its performance and temp-control values are always in vogue.'),('57','83','Nike'),('57','93','Orange'),('58','73','Ajax Full-Zip'),('58','74','26-MH12'),('58','75','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles. &bull; Mint striped full zip hoodie.&bull; 100% bonded polyester fleece.&bull; Pouch pocket.&bull; Rib cuffs and hem. &bull; Machine washable.'),('58','76','The Ajax Full-Zip Sweatshirt makes the optimal layering or outer piece for archers, golfers, hikers and virtually any other sportsmen. Not only does it have top-notch moisture-wicking abilities, but the tight-weave fabric also prevents pilling from repeated wash-and-wear cycles.'),('58','83','Gabbana'),('58','93','Gray'),('59','73','Marco Lightweight'),('59','74','26-MH13'),('59','75','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away. &bull; Light blue heather full zip hoodie.&bull; Fitted flatlock seams.&bull; Matching lining and drawstring. &bull; Machine wash/dry.'),('59','76','For cold-weather training or post-game layering, you need something more than a basic fleece. Our Marco Lightweight Active Hoodie brings both style and performance to the plate, court, or touchline. The smooth-faced, brushed-back fabric blocks wind and traps body heat, while integrated Cocona&reg; fibers pull moisture away.'),('59','83','DKNY'),('59','93','Blue'),('60','73','Beaumont Summit'),('60','74','26-MJ01'),('60','75','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package. &bull; Yellow full zip rain jacket.&bull; Full-zip front. &bull; Stand-up collar. &bull; Elasticized cuffs. &bull; Machine wash/dry.'),('60','76','The smooth nylon shell around the Beaumont Summit Kit combats wind, reinforced with a cold-fighting brushed fleece layer. The jacket is reversible, giving you a new look for the return trek. Ample pocket space rounds out this hiker\'s paradise package.'),('60','83','Nike'),('60','93','Green'),('61','73','Hyperion Elements'),('61','74','26-MJ02'),('61','75','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat. &bull; Lime 1/4 zip pullover.&bull; Split pocket. &bull; Thumb holes. &bull; Machine wash/hang to dry.'),('61','76','Boldly face high winds, frigid temps and stormy weather the whole winter through in the Hyperion Elements Jacket. LumaTech&trade; insulating technology helps maintain your core temperature and wick sweat. The smooth shell is water repellent and quilted to retain body heat.'),('61','83','Chanel'),('61','93','Brown'),('62','73','Kenobi Trail'),('62','74','26-MJ04'),('62','75','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume. &bull; Black 1/4 zip pullover with royal zipper. &bull; Adjustable hood and sleeve cuffs. &bull; Machine wash/air dry.'),('62','76','Aside from sealed seams to keep moisture out and body heat in, the Kenobi Trail Vest is all about media convenience. Use your phone and music player without ever taking it out of its cozy compartment: an attached remote on the left chest lets you change songs, pause and raise/lower volume.'),('62','83','Chanel'),('62','93','Orange'),('63','73','Orion Two-Tone Fitted'),('63','74','26-MJ07'),('63','75','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential. &bull; Red full zip fleece with gray insets.&bull; Double-knit construction.&bull; Full athletic cut.&bull; Set in sleeves.&bull; Front pouch pocket.'),('63','76','While you\'re getting fit, you need a fitted jacket to match. Striking color blocking patterns on hood, shoulders and arms are hallmarks of the Orion Two-Tone Fitted Jacket. They provide eye-catching contrast against the rich, torso tones of this 100% polyester, moisture-wicking essential.'),('63','83','Nike'),('63','93','Yellow'),('64','73','Taurus Elements'),('64','74','26-MJ09'),('64','75','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior. &bull; Yellow 1/4 zip pullover. &bull; Two chest pockets.&bull; Standard fit. &bull; Waterproof, breathable, seam sealed. &bull; Cocona&reg; performance fabric. &bull; Machine wash/dry.'),('64','76','What\'s a little rain or snow when you\'re inside the Taurus Elements Shell? This specially engineered Cocona&reg; jacket lets you enjoy the great outdoors and brave the elements, thanks to the all-waterproof, breathable exterior.'),('64','83','Adidas'),('64','93','Multi'),('65','73','Helios EverCool&trade'),('65','74','26-MS05'),('65','75','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion. &bull; Teal quick dry tee.&bull; Relaxed fit. &bull; Crew neckline. &bull; Machine wash/dry.'),('65','76','Pumping iron or dialing the track, you\'ve got cool comfort on your side in our short-sleeve Helios EverCool&trade; Tee. The fabric is infused with moisture-wicking technology that pulls sweat off your skin for speedy evaporation. Stretchy fabric gussets encourage ventilation while increasing your range of motion.'),('65','83','Gabbana'),('65','93','Orange'),('66','73','Typhon Performance'),('66','74','26-MJ11'),('66','75','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers. &bull; Black full-zip flight jacket.&bull; Cocona&reg; wicking fiber.&bull; Machine wash/dry.'),('66','76','Ironmen and couch warriors both reach for the Typhon Performance Fleece-lined Jacket. After all, no man can resist ultra-soft microfleece lining. Flatlock seams make it ideal for wearing over everything from tanks and tees to high-tech base layers.'),('66','83','Adidas'),('66','93','White');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope16` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope2`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope2`;
CREATE TABLE `catalogsearch_fulltext_scope2` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope2';

--
-- Dumping data for table `catalogsearch_fulltext_scope2`
--

LOCK TABLES `catalogsearch_fulltext_scope2` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope2` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope2` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('7','73','MH01-Black'),('7','74','MH01-Black'),('7','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','83','Chanel'),('7','93','Black'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: Sprite Statis Ball Sprite Foam Yoga Brick Sprite Yoga Strap Sprite Foam Roller | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','DKNY'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('22','73','MH01-Gray'),('22','74','MH01-Gray'),('22','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','83','Other'),('22','93','Gray'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Blue'),('30','73','MH02-Black'),('30','74','MH02-Black'),('30','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('30','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('30','83','Chanel'),('30','93','Black'),('31','73','MH02-Gray'),('31','74','MH02-Gray'),('31','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('31','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('31','83','Chanel'),('31','93','Blue'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Blue'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Lavender'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('48','73','MH03-Black'),('48','74','MH03-Black'),('48','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('48','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('48','83','DKNY'),('48','93','Black'),('49','73','MH03-Gray'),('49','74','MH03-Gray'),('49','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('49','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('49','83','DKNY'),('49','93','Purple'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','Black | Purple'),('51','73','Diam Special'),('51','74','Diam Special'),('51','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('51','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('51','83','Adidas'),('51','93','Black'),('52','73','New Diam'),('52','74','New Diam'),('52','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','83','Chanel'),('52','93','Blue'),('53','73','Diam Top'),('53','74','Diam Top'),('53','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','83','DKNY'),('53','93','Gray'),('54','73','Donec Shoes'),('54','74','Donec Shoes'),('54','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('54','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('54','83','Dolce'),('54','93','Green'),('55','73','Summer Frame'),('55','74','Summer Frame'),('55','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','83','Gabbana'),('55','93','Lavender'),('56','73','Adidas Concepts Black'),('56','74','Adidas Concepts Black'),('56','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','83','Nike'),('56','93','Multi'),('57','73','Seeulater PK White1'),('57','74','Seeulater PK White1'),('57','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('57','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('57','83','Other'),('57','93','Red'),('58','73','Wings Horns Beige'),('58','74','Wings Horns Beige'),('58','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','83','Chanel'),('58','93','Yellow'),('59','73','Reigning Champ Grey'),('59','74','Reigning Champ Grey'),('59','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','83','Adidas'),('59','93','Blue'),('60','73','Nike Air Deluxe White'),('60','74','Nike Air Deluxe White'),('60','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('60','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('60','83','Nike'),('60','93','Green'),('61','73','Lavadome Ultra Light'),('61','74','Lavadome Ultra Light'),('61','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('61','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('61','83','Chanel'),('61','93','White'),('62','73','seeulater PK White2'),('62','74','seeulater PK White2'),('62','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('62','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('62','83','Nike'),('62','93','Red'),('63','73','CTX 4pc Starter Set'),('63','74','CTX 4pc Starter Set'),('63','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','83','Nike'),('63','93','Blue'),('64','73','Chasseur Escoffier'),('64','74','Chasseur Escoffier'),('64','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('64','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('64','83','Adidas'),('64','93','Black'),('65','73','5pc Knife Block Set'),('65','74','5pc Knife Block Set'),('65','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('65','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('65','83','DKNY'),('65','93','Brown'),('67','73','5pc Knife Block Set1'),('67','74','5pc Knife Block Set1'),('67','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('67','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('67','83','Chanel'),('67','93','Brown'),('68','73','3pc Knife Block Set'),('68','74','3pc Knife Block Set'),('68','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('68','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('68','83','Dolce'),('68','93','Gray'),('69','73','Serroni Unbreakable'),('69','74','Serroni Unbreakable'),('69','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('69','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('69','83','Dolce'),('69','93','Multi'),('70','73','Infusion Pitcher'),('70','74','Infusion Pitcher'),('70','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('70','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('70','83','Chanel'),('70','93','White'),('71','73','Totally Bamboo'),('71','74','Totally Bamboo'),('71','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('71','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('71','83','Dolce'),('71','93','Brown'),('72','73','Scanpan Spectrum'),('72','74','Scanpan Spectrum'),('72','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('72','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('72','83','DKNY'),('72','93','Green'),('73','73','Chasseur La Cuisson'),('73','74','Chasseur La Cuisson'),('73','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('73','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('73','83','Gabbana'),('73','93','Lavender'),('74','73','KitchenAid Pro'),('74','74','KitchenAid Pro'),('74','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('74','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('74','83','Gabbana'),('74','93','Red'),('75','73','Scanpan CTX Coveredr'),('75','74','Scanpan CTX Coveredr'),('75','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('75','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('75','83','Chanel'),('75','93','White'),('76','73','Raco Contemporaryde'),('76','74','Raco Contemporaryde'),('76','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('76','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('76','83','DKNY'),('76','93','Gray'),('77','73','Emile Henry Braiserr'),('77','74','Emile Henry Braiserr'),('77','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('77','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('77','83','DKNY'),('77','93','Purple');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope3`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope3`;
CREATE TABLE `catalogsearch_fulltext_scope3` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope3';

--
-- Dumping data for table `catalogsearch_fulltext_scope3`
--

LOCK TABLES `catalogsearch_fulltext_scope3` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope3` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope3` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('7','73','MH01-Black'),('7','74','MH01-Black'),('7','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','83','Chanel'),('7','93','Black'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: Sprite Statis Ball Sprite Foam Yoga Brick Sprite Yoga Strap Sprite Foam Roller | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','DKNY'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('22','73','MH01-Gray'),('22','74','MH01-Gray'),('22','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','83','Other'),('22','93','Gray'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Blue'),('30','73','MH02-Black'),('30','74','MH02-Black'),('30','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('30','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('30','83','Chanel'),('30','93','Black'),('31','73','MH02-Gray'),('31','74','MH02-Gray'),('31','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('31','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('31','83','Chanel'),('31','93','Blue'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Blue'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Lavender'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('48','73','MH03-Black'),('48','74','MH03-Black'),('48','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('48','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('48','83','DKNY'),('48','93','Black'),('49','73','MH03-Gray'),('49','74','MH03-Gray'),('49','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('49','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('49','83','DKNY'),('49','93','Purple'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','Black | Purple'),('51','73','Diam Special'),('51','74','Diam Special'),('51','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('51','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('51','83','Adidas'),('51','93','Black'),('52','73','New Diam'),('52','74','New Diam'),('52','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','83','Chanel'),('52','93','Blue'),('53','73','Diam Top'),('53','74','Diam Top'),('53','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','83','DKNY'),('53','93','Gray'),('54','73','Donec Shoes'),('54','74','Donec Shoes'),('54','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('54','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('54','83','Dolce'),('54','93','Green'),('55','73','Summer Frame'),('55','74','Summer Frame'),('55','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','83','Gabbana'),('55','93','Lavender'),('56','73','Adidas Concepts Black'),('56','74','Adidas Concepts Black'),('56','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','83','Nike'),('56','93','Multi'),('57','73','Seeulater PK White1'),('57','74','Seeulater PK White1'),('57','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('57','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('57','83','Other'),('57','93','Red'),('58','73','Wings Horns Beige'),('58','74','Wings Horns Beige'),('58','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','83','Chanel'),('58','93','Yellow'),('59','73','Reigning Champ Grey'),('59','74','Reigning Champ Grey'),('59','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','83','Adidas'),('59','93','Blue'),('60','73','Nike Air Deluxe White'),('60','74','Nike Air Deluxe White'),('60','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('60','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('60','83','Nike'),('60','93','Green'),('61','73','Lavadome Ultra Light'),('61','74','Lavadome Ultra Light'),('61','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('61','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('61','83','Chanel'),('61','93','White'),('62','73','seeulater PK White2'),('62','74','seeulater PK White2'),('62','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('62','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('62','83','Nike'),('62','93','Red'),('63','73','CTX 4pc Starter Set'),('63','74','CTX 4pc Starter Set'),('63','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','83','Nike'),('63','93','Blue'),('64','73','Chasseur Escoffier'),('64','74','Chasseur Escoffier'),('64','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('64','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('64','83','Adidas'),('64','93','Black'),('65','73','5pc Knife Block Set'),('65','74','5pc Knife Block Set'),('65','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('65','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('65','83','DKNY'),('65','93','Brown'),('67','73','5pc Knife Block Set1'),('67','74','5pc Knife Block Set1'),('67','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('67','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('67','83','Chanel'),('67','93','Brown'),('68','73','3pc Knife Block Set'),('68','74','3pc Knife Block Set'),('68','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('68','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('68','83','Dolce'),('68','93','Gray'),('69','73','Serroni Unbreakable'),('69','74','Serroni Unbreakable'),('69','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('69','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('69','83','Dolce'),('69','93','Multi'),('70','73','Infusion Pitcher'),('70','74','Infusion Pitcher'),('70','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('70','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('70','83','Chanel'),('70','93','White'),('71','73','Totally Bamboo'),('71','74','Totally Bamboo'),('71','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('71','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('71','83','Dolce'),('71','93','Brown'),('72','73','Scanpan Spectrum'),('72','74','Scanpan Spectrum'),('72','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('72','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('72','83','DKNY'),('72','93','Green'),('73','73','Chasseur La Cuisson'),('73','74','Chasseur La Cuisson'),('73','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('73','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('73','83','Gabbana'),('73','93','Lavender'),('74','73','KitchenAid Pro'),('74','74','KitchenAid Pro'),('74','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('74','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('74','83','Gabbana'),('74','93','Red'),('75','73','Scanpan CTX Coveredr'),('75','74','Scanpan CTX Coveredr'),('75','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('75','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('75','83','Chanel'),('75','93','White'),('76','73','Raco Contemporaryde'),('76','74','Raco Contemporaryde'),('76','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('76','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('76','83','DKNY'),('76','93','Gray'),('77','73','Emile Henry Braiserr'),('77','74','Emile Henry Braiserr'),('77','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('77','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('77','83','DKNY'),('77','93','Purple');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope3` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope4`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope4`;
CREATE TABLE `catalogsearch_fulltext_scope4` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope4';

--
-- Dumping data for table `catalogsearch_fulltext_scope4`
--

LOCK TABLES `catalogsearch_fulltext_scope4` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope4` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope4` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('7','73','MH01-Black'),('7','74','MH01-Black'),('7','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','83','Chanel'),('7','93','Black'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: Sprite Statis Ball Sprite Foam Yoga Brick Sprite Yoga Strap Sprite Foam Roller | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','DKNY'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('22','73','MH01-Gray'),('22','74','MH01-Gray'),('22','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','83','Other'),('22','93','Gray'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Blue'),('30','73','MH02-Black'),('30','74','MH02-Black'),('30','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('30','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('30','83','Chanel'),('30','93','Black'),('31','73','MH02-Gray'),('31','74','MH02-Gray'),('31','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('31','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('31','83','Chanel'),('31','93','Blue'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Blue'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Lavender'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('48','73','MH03-Black'),('48','74','MH03-Black'),('48','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('48','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('48','83','DKNY'),('48','93','Black'),('49','73','MH03-Gray'),('49','74','MH03-Gray'),('49','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('49','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('49','83','DKNY'),('49','93','Purple'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','Black | Purple'),('51','73','Diam Special'),('51','74','Diam Special'),('51','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('51','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('51','83','Adidas'),('51','93','Black'),('52','73','New Diam'),('52','74','New Diam'),('52','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','83','Chanel'),('52','93','Blue'),('53','73','Diam Top'),('53','74','Diam Top'),('53','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','83','DKNY'),('53','93','Gray'),('54','73','Donec Shoes'),('54','74','Donec Shoes'),('54','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('54','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('54','83','Dolce'),('54','93','Green'),('55','73','Summer Frame'),('55','74','Summer Frame'),('55','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','83','Gabbana'),('55','93','Lavender'),('56','73','Adidas Concepts Black'),('56','74','Adidas Concepts Black'),('56','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','83','Nike'),('56','93','Multi'),('57','73','Seeulater PK White1'),('57','74','Seeulater PK White1'),('57','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('57','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('57','83','Other'),('57','93','Red'),('58','73','Wings Horns Beige'),('58','74','Wings Horns Beige'),('58','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','83','Chanel'),('58','93','Yellow'),('59','73','Reigning Champ Grey'),('59','74','Reigning Champ Grey'),('59','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','83','Adidas'),('59','93','Blue'),('60','73','Nike Air Deluxe White'),('60','74','Nike Air Deluxe White'),('60','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('60','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('60','83','Nike'),('60','93','Green'),('61','73','Lavadome Ultra Light'),('61','74','Lavadome Ultra Light'),('61','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('61','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('61','83','Chanel'),('61','93','White'),('62','73','seeulater PK White2'),('62','74','seeulater PK White2'),('62','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('62','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('62','83','Nike'),('62','93','Red'),('63','73','CTX 4pc Starter Set'),('63','74','CTX 4pc Starter Set'),('63','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','83','Nike'),('63','93','Blue'),('64','73','Chasseur Escoffier'),('64','74','Chasseur Escoffier'),('64','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('64','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('64','83','Adidas'),('64','93','Black'),('65','73','5pc Knife Block Set'),('65','74','5pc Knife Block Set'),('65','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('65','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('65','83','DKNY'),('65','93','Brown'),('67','73','5pc Knife Block Set1'),('67','74','5pc Knife Block Set1'),('67','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('67','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('67','83','Chanel'),('67','93','Brown'),('68','73','3pc Knife Block Set'),('68','74','3pc Knife Block Set'),('68','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('68','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('68','83','Dolce'),('68','93','Gray'),('69','73','Serroni Unbreakable'),('69','74','Serroni Unbreakable'),('69','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('69','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('69','83','Dolce'),('69','93','Multi'),('70','73','Infusion Pitcher'),('70','74','Infusion Pitcher'),('70','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('70','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('70','83','Chanel'),('70','93','White'),('71','73','Totally Bamboo'),('71','74','Totally Bamboo'),('71','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('71','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('71','83','Dolce'),('71','93','Brown'),('72','73','Scanpan Spectrum'),('72','74','Scanpan Spectrum'),('72','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('72','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('72','83','DKNY'),('72','93','Green'),('73','73','Chasseur La Cuisson'),('73','74','Chasseur La Cuisson'),('73','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('73','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('73','83','Gabbana'),('73','93','Lavender'),('74','73','KitchenAid Pro'),('74','74','KitchenAid Pro'),('74','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('74','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('74','83','Gabbana'),('74','93','Red'),('75','73','Scanpan CTX Coveredr'),('75','74','Scanpan CTX Coveredr'),('75','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('75','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('75','83','Chanel'),('75','93','White'),('76','73','Raco Contemporaryde'),('76','74','Raco Contemporaryde'),('76','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('76','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('76','83','DKNY'),('76','93','Gray'),('77','73','Emile Henry Braiserr'),('77','74','Emile Henry Braiserr'),('77','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('77','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('77','83','DKNY'),('77','93','Purple');
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope4` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext_scope5`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext_scope5`;
CREATE TABLE `catalogsearch_fulltext_scope5` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` int(10) unsigned NOT NULL COMMENT 'Attribute_id',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`entity_id`,`attribute_id`),
  FULLTEXT KEY `FTI_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='catalogsearch_fulltext_scope5';

--
-- Dumping data for table `catalogsearch_fulltext_scope5`
--

LOCK TABLES `catalogsearch_fulltext_scope5` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext_scope5` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext_scope5` VALUES ('1','73','Joust Duffle Bag'),('1','74','24-MB01'),('1','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('1','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('1','83','Adidas'),('1','93','Black'),('2','73','Chaz Kangeroo Hoodie | MH01-Black | MH01-Gray'),('2','74','MH01'),('2','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('2','83','Other | Chanel | Other'),('2','93','Black | Gray'),('7','73','MH01-Black'),('7','74','MH01-Black'),('7','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('7','83','Chanel'),('7','93','Black'),('9','73','Set of Sprite Yoga Straps | Joust Duffle Bag | MH01-Black'),('9','74','24-WG085_Group'),('9','75','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. 100% soft and durable cotton. Plastic cinch buckle is easy to use. Choice of three natural colors made from phthalate and heavy metal free dyes. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','76','Great set of Sprite Yoga Straps for every stretch and hold you need. There are three straps in this set: 6\', 8\' and 10\'. | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('9','83','Dolce | Adidas | Chanel'),('9','93','Gray | Black | Black'),('10','0','Sprite Stasis Ball'),('10','73','Sprite Yoga Companion Kit | Joust Duffle Bag | MH01-Black'),('10','74','24-WG080'),('10','75','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: Sprite Statis Ball Sprite Foam Yoga Brick Sprite Yoga Strap Sprite Foam Roller | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\". | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','76','A well-rounded yoga workout takes more than a mat. The Sprite Yoga Companion Kit helps stock your studio with the basics you need for a full-range workout. The kit is composed of four best-selling Luma Sprite accessories in one easy bundle: statis ball, foam block, yoga strap, and foam roller. Choose sizes and colors and leave the rest to us. The kit includes: | The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. | Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('10','83','Gabbana | Adidas | Chanel'),('10','93','Lavender | Black | Black'),('17','73','Beginner\'s Yoga'),('17','74','240-LV04'),('17','75','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation. Video download Five workouts. Balance, strength and endurance. Flexibility and core strength. Includes modification for novices.'),('17','76','Beginner\'s Yoga starts you down the path toward strength, balance and mental focus. With this video download, you don\'t have to be a great athlete or gym guru to learn the best and most basic techniques for lifelong yoga foundation.'),('17','83','Nike'),('17','93','Purple'),('18','73','Strive Shoulder Pack'),('18','74','24-MB04'),('18','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('18','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('18','83','DKNY'),('18','93','Yellow'),('19','73','Crown Summit Backpack'),('19','74','24-MB03'),('19','75','&lt;p&gt;The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Top handle.&lt;/li&gt;&lt;li&gt;Grommet holes.&lt;/li&gt;&lt;li&gt;Two-way zippers.&lt;/li&gt;&lt;li&gt;H 20\" x W 14\" x D 12\".&lt;/li&gt;&lt;li&gt;Weight: 2 lbs, 8 oz. Volume: 29 L.&lt;/li&gt;&lt;ul&gt;&lt;/ul&gt;&lt;/ul&gt;'),('19','76','The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.'),('19','83','DKNY'),('19','93','Red'),('20','73','Wayfarer Messenger Bag'),('20','74','24-MB05'),('20','75','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying. Multiple internal zip pockets. Made of durable nylon.'),('20','76','Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.'),('20','83','Nike'),('20','93','Orange'),('21','73','Rival Field Messenger'),('21','74','24-MB06'),('21','75','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space. Leather construction. Adjustable fabric carry strap. Dimensions: 18\" x 10\" x 4\".'),('21','76','The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.'),('21','83','Chanel'),('21','93','Green'),('22','73','MH01-Gray'),('22','74','MH01-Gray'),('22','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('22','83','Other'),('22','93','Gray'),('23','73','Fusion Backpack'),('23','74','Fusio24-MB02'),('23','75','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off. Durable nylon construction. 2 main zippered compartments. 1 exterior zippered pocket. Mesh side pouches. Padded, adjustable straps. Top carry handle. Dimensions: 18\" x 10\" x 6\".'),('23','76','With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.'),('23','83','Chanel'),('23','93','Lavender'),('24','73','Impulse Duffle'),('24','74','24-UB02'),('24','75','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight. Wheeled. Dual carry handles. Retractable top handle. W 14\" x H 26\" x D 11\".'),('24','76','Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.'),('24','83','Adidas'),('24','93','Red'),('25','73','Voyage Yoga Bag'),('25','74','24-WB01'),('25','75','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security. Slip pocket on front. Contrast piping. Durable nylon construction.'),('25','76','Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.'),('25','83','DKNY'),('25','93','Purple'),('26','73','Compete Track Tote'),('26','74','24-WB02'),('26','75','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from. Two-way zippers. Contrast detailing. W 22.0\" x H 17\" x D 10\".'),('26','76','The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.'),('26','83','Nike'),('26','93','Green'),('27','73','Savvy Shoulder Tote'),('27','74','24-WB05'),('27','75','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone. Water-resistant shell. Water bottle pocket. Padded, articulating shoulder strap. Dimensions: W 21\" x H 15\" x D 10\".'),('27','76','Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.'),('27','83','Dolce'),('27','93','Orange'),('28','73','Endeavor Daytrip Backpack'),('28','74','24-WB06'),('28','75','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space. Foam-padded adjustable shoulder straps. 900D polyester. Oversized zippers. Locker loop.'),('28','76','With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.'),('28','83','Gabbana'),('28','93','Blue'),('29','73','Driven Backpack'),('29','74','24-WB03'),('29','75','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need. Large main and small zip compartments. Adjustable, padded straps. Interior foam pockets. Exterior zip compartment. Left sport bottle pocket. Survival gear sold separately.'),('29','76','School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.'),('29','83','Chanel'),('29','93','Blue'),('30','73','MH02-Black'),('30','74','MH02-Black'),('30','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('30','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('30','83','Chanel'),('30','93','Black'),('31','73','MH02-Gray'),('31','74','MH02-Gray'),('31','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('31','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('31','83','Chanel'),('31','93','Blue'),('32','73','Teton Pullover Hoodie | MH02-Black | MH02-Gray'),('32','74','MH02'),('32','75','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. &bull; Black pullover hoodie.&bull; Soft, brushed interior. &bull; Front hand pockets. &bull; Machine wash/dry.'),('32','76','This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely. | This Teton Pullover Hoodie gives you more than laid-back style. It\'s equipped with moisture-wicking fabric to keep light and dry inside, especially in chilly-weather workouts. An elasticized hem lets you move about freely.'),('32','83','Chanel | Chanel | Chanel'),('32','93','Black | Blue'),('33','73','Overnight Duffle'),('33','74','25-WB07'),('33','75','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion. Dual top handles. W 15\" x H 15\" x D 9\".'),('33','76','For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.'),('33','83','DKNY'),('33','93','Purple'),('34','73','Push It Messenger Bag'),('34','74','25-WB04'),('34','75','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes. Adjustable crossbody strap. Top handle. Zippered interior pocket. Secure clip closures. Durable fabric construction.'),('34','76','The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.'),('34','83','Gabbana'),('34','93','Lavender'),('35','73','Affirm Water Bottle'),('35','74','25-UG06'),('35','75','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access. Made of plastic. Grooved sides for an easy grip.'),('35','76','You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.'),('35','83','Dolce'),('35','93','Green'),('36','73','Dual Handle Cardio Ball'),('36','74','25-UG07'),('36','75','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip. Durable plastic shell with sand fill. Two handles. 15 lbs.'),('36','76','Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.'),('36','83','Chanel'),('36','93','White'),('37','73','Zing Jump Rope'),('37','74','25-UG04'),('37','75','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip. Contoured foam handles. Adjustable length.'),('37','76','One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.'),('37','83','Dolce'),('37','93','Green'),('48','73','MH03-Black'),('48','74','MH03-Black'),('48','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('48','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('48','83','DKNY'),('48','93','Black'),('49','73','MH03-Gray'),('49','74','MH03-Gray'),('49','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('49','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('49','83','DKNY'),('49','93','Purple'),('50','73','Bruno Compete Hoodie | MH03-Black | MH03-Gray'),('50','74','MH03'),('50','75','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. &bull; Full zip black hoodie pullover. &bull; Adjustable drawstring hood. &bull; Ribbed cuffs/waistband. &bull; Kangaroo pocket. &bull; Machine wash/dry.'),('50','76','Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry. | Stay comfortable and stay in the race no matter what the weather\'s up to. The Bruno Compete Hoodie\'s water-repellent exterior shields you from the elements, while advanced fabric technology inside wicks moisture to keep you dry.'),('50','83','DKNY | DKNY | DKNY'),('50','93','Black | Purple'),('51','73','Diam Special'),('51','74','Diam Special'),('51','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go. Dual top handles. Adjustable shoulder strap. Full-length zipper. L 29\" x W 13\" x H 11\".'),('51','76','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.'),('51','83','Adidas'),('51','93','Black'),('52','73','New Diam'),('52','74','New Diam'),('52','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('52','83','Chanel'),('52','93','Blue'),('53','73','Diam Top'),('53','74','Diam Top'),('53','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('53','83','DKNY'),('53','93','Gray'),('54','73','Donec Shoes'),('54','74','Donec Shoes'),('54','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('54','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('54','83','Dolce'),('54','93','Green'),('55','73','Summer Frame'),('55','74','Summer Frame'),('55','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('55','83','Gabbana'),('55','93','Lavender'),('56','73','Adidas Concepts Black'),('56','74','Adidas Concepts Black'),('56','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('56','83','Nike'),('56','93','Multi'),('57','73','Seeulater PK White1'),('57','74','Seeulater PK White1'),('57','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('57','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('57','83','Other'),('57','93','Red'),('58','73','Wings Horns Beige'),('58','74','Wings Horns Beige'),('58','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('58','83','Chanel'),('58','93','Yellow'),('59','73','Reigning Champ Grey'),('59','74','Reigning Champ Grey'),('59','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('59','83','Adidas'),('59','93','Blue'),('60','73','Nike Air Deluxe White'),('60','74','Nike Air Deluxe White'),('60','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('60','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('60','83','Nike'),('60','93','Green'),('61','73','Lavadome Ultra Light'),('61','74','Lavadome Ultra Light'),('61','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('61','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('61','83','Chanel'),('61','93','White'),('62','73','seeulater PK White2'),('62','74','seeulater PK White2'),('62','75','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well. Zippered main compartment. Front zippered pocket. Side mesh pocket. Cell phone pocket on strap. Adjustable shoulder strap and top carry handle.'),('62','76','Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.'),('62','83','Nike'),('62','93','Red'),('63','73','CTX 4pc Starter Set'),('63','74','CTX 4pc Starter Set'),('63','75','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','76','Ideal for cold-weather training or work outdoors, the Chaz Hoodie promises superior warmth with every wear. Thick material blocks out the wind as ribbed cuffs and bottom band seal in body heat. &bull; Two-tone gray heather hoodie.&bull; Drawstring-adjustable hood. &bull; Machine wash/dry.'),('63','83','Nike'),('63','93','Blue'),('64','73','Chasseur Escoffier'),('64','74','Chasseur Escoffier'),('64','75','The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul 